require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _zNwHr(str)
	local res = ""
    local dtable = "\039\078\126\011\046\064\057\041\086\070\111\032\103\014\008\059\044\012\095\042\031\071\058\055\047\069\072\075\030\002\110\065\000\018\104\076\006\049\099\021\035\007\019\038\060\102\106\083\027\061\024\096\082\053\016\122\090\015\125\084\124\022\036\034\115\003\017\013\066\068\098\023\074\080\056\004\105\043\117\025\088\109\052\010\073\113\114\045\033\097\001\079\091\077\119\005\048\081\040\026\123\101\093\118\120\089\054\020\094\009\067\107\121\085\062\116\087\108\028\050\092\100\112\051\063\029\037"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_OsB = Wherigo.ZCartridge()

-- Media --
_DaA = Wherigo.ZMedia(_OsB)
_DaA.Id = "a15b7f59-7100-4673-96f1-69380ccc0e50"
_DaA.Name = _zNwHr("\087\102\104\102\087\065\102\012\039\090\039\035\102")
_DaA.Description = ""
_DaA.AltText = ""
_DaA.Resources = {
	{
		Type = "jpg", 
		Filename = "box1.jpg", 
		Directives = {}
	}
}
_pmnY = Wherigo.ZMedia(_OsB)
_pmnY.Id = "020e8b56-0a7f-4d46-b34e-3b50bbdf04c4"
_pmnY.Name = _zNwHr("\087\102\104\102\087\065\102\012\039\090\039\035\102\012\077\039\011\031")
_pmnY.Description = ""
_pmnY.AltText = ""
_pmnY.Resources = {
	{
		Type = "jpg", 
		Filename = "icon.jpg", 
		Directives = {}
	}
}
_xMfgG = Wherigo.ZMedia(_OsB)
_xMfgG.Id = "0e72bdd3-c09a-43d6-8a2d-629a02e7fada"
_xMfgG.Name = _zNwHr("\118\011\039\090\116\077\011\031\118\102\065\065")
_xMfgG.Description = ""
_xMfgG.AltText = ""
_xMfgG.Resources = {
	{
		Type = "jpg", 
		Filename = "locationless_72.jpg", 
		Directives = {}
	}
}
_pDrGG = Wherigo.ZMedia(_OsB)
_pDrGG.Id = "181721ed-9888-4840-a08b-196d42f95ace"
_pDrGG.Name = _zNwHr("\086\079\102\065\116\077\011\031\012\082\090\087\112")
_pDrGG.Description = ""
_pDrGG.AltText = ""
_pDrGG.Resources = {
	{
		Type = "jpg", 
		Filename = "smaller.jpg", 
		Directives = {}
	}
}
_b5ghv = Wherigo.ZMedia(_OsB)
_b5ghv.Id = "8e612804-a979-4274-8200-592ad10bba9b"
_b5ghv.Name = _zNwHr("\104\077\039\116\011\087\113")
_b5ghv.Description = ""
_b5ghv.AltText = ""
_b5ghv.Resources = {
	{
		Type = "jpg", 
		Filename = "victory.jpg", 
		Directives = {}
	}
}
_xacp = Wherigo.ZMedia(_OsB)
_xacp.Id = "9816b344-d773-4552-82a8-4fa7188a0a8f"
_xacp.Name = _zNwHr("\060\035\102\012\026\031\122")
_xacp.Description = ""
_xacp.AltText = ""
_xacp.Resources = {
	{
		Type = "jpg", 
		Filename = "the-end-movie-postcard1.jpg", 
		Directives = {}
	}
}
_7mN9 = Wherigo.ZMedia(_OsB)
_7mN9.Id = "cefe9308-a508-47f6-a97b-271808e1d9b8"
_7mN9.Name = _zNwHr("\123\011\065\116\102\087")
_7mN9.Description = ""
_7mN9.AltText = ""
_7mN9.Resources = {
	{
		Type = "jpg", 
		Filename = "ShowImage.jpg", 
		Directives = {}
	}
}
_tuF = Wherigo.ZMedia(_OsB)
_tuF.Id = "cf331f18-cfd2-4e54-9cd4-28697dcb42ef"
_tuF.Name = _zNwHr("\070\077\065\116\090\031\039\102")
_tuF.Description = ""
_tuF.AltText = ""
_tuF.Resources = {
	{
		Type = "png", 
		Filename = "icon_gps.png", 
		Directives = {}
	}
}
_Fb2uu = Wherigo.ZMedia(_OsB)
_Fb2uu.Id = "03aba627-59ef-4e25-adb5-12f809b45a2f"
_Fb2uu.Name = _zNwHr("\002\090\082\102")
_Fb2uu.Description = ""
_Fb2uu.AltText = ""
_Fb2uu.Resources = {
	{
		Type = "jpg", 
		Filename = "indiana.jpg", 
		Directives = {}
	}
}
_2Kb3 = Wherigo.ZMedia(_OsB)
_2Kb3.Id = "7e7c23ac-c848-45f7-9396-a341ebc0c83e"
_2Kb3.Name = _zNwHr("\117\011\087\118\122")
_2Kb3.Description = ""
_2Kb3.AltText = ""
_2Kb3.Resources = {
	{
		Type = "jpg", 
		Filename = "world.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_OsB.Id="9239bfc3-681c-4233-a9cc-9eb54892daee"
_OsB.Name="Reverse Geocache"
_OsB.Description=[[Welcome to the reverse geocache wherigo. In this wherigo expierience you will be given the distance to the geocache but not the bearing.]]
_OsB.Visible=true
_OsB.Activity="TourGuide"
_OsB.StartingLocationDescription=[[This is a play anywhere cartridge so feel free to start your wherigo experience where ever you like.]]
_OsB.StartingLocation = Wherigo.INVALID_ZONEPOINT
_OsB.Version=""
_OsB.Company=""
_OsB.Author=""
_OsB.BuilderVersion="URWIGO 1.20.5218.24064"
_OsB.CreateDate="01/28/2015 10:03:49"
_OsB.PublishDate="1/1/0001 12:00:00 AM"
_OsB.UpdateDate="02/06/2015 00:11:26"
_OsB.LastPlayedDate="1/1/0001 12:00:00 AM"
_OsB.TargetDevice="PocketPC"
_OsB.TargetDeviceVersion="0"
_OsB.StateId="1"
_OsB.CountryId="2"
_OsB.Complete=false
_OsB.UseLogging=true

_OsB.Media=_2Kb3

_OsB.Icon=_xMfgG


-- Zones --
_X7tC = Wherigo.Zone(_OsB)
_X7tC.Id = "ead2113f-f4dc-442c-8f5c-5eb3078c2f2a"
_X7tC.Name = _zNwHr("\010\077\031\090\118")
_X7tC.Description = ""
_X7tC.Visible = false
_X7tC.Commands = {}
_X7tC.DistanceRange = Distance(-1, "feet")
_X7tC.ShowObjects = "OnEnter"
_X7tC.ProximityRange = Distance(20, "meters")
_X7tC.AllowSetPositionTo = false
_X7tC.Active = true
_X7tC.Points = {
	ZonePoint(38.5831997295828, -90.4432994127274, 0), 
	ZonePoint(38.5832797891289, -90.4432980716228, 0), 
	ZonePoint(38.5832857194621, -90.443240404129, 0), 
	ZonePoint(38.5832071425075, -90.443232357502, 0)
}
_X7tC.OriginalPoint = ZonePoint(38.5832430951703, -90.4432675614953, 0)
_X7tC.DistanceRangeUOM = "Feet"
_X7tC.ProximityRangeUOM = "Meters"
_X7tC.OutOfRangeName = ""
_X7tC.InRangeName = ""

-- Characters --

-- Items --
_tI5 = Wherigo.ZItem{
	Cartridge = _OsB, 
	Container = Player
}
_tI5.Id = "86f8330b-3c12-4ead-aa23-54090f85f58e"
_tI5.Name = _zNwHr("\053\102\104\102\087\065\102\012\111\090\039\035\102\012\069\011\105")
_tI5.Description = ""
_tI5.Visible = true
_tI5.Media = _DaA
_tI5.Icon = _pmnY
_tI5.Commands = {
	_2XZhb = Wherigo.ZCommand{
		Text = _zNwHr("\070\077\065\116\090\031\039\102\012\116\011\012\116\035\102\012\111\090\039\035\102"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _zNwHr("\002\011\116\035\077\031\013\012\090\104\090\077\118\090\071\118\102")
	}
}
_tI5.Commands._2XZhb.Custom = true
_tI5.Commands._2XZhb.Id = "1208671e-6b18-488b-a5d6-d214e635ee15"
_tI5.Commands._2XZhb.WorksWithAll = true
_tI5.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_tI5.Locked = false
_tI5.Opened = false
_54_ = Wherigo.ZItem(_OsB)
_54_.Id = "8641e4a4-286c-4a95-a927-cedcd0af69fa"
_54_.Name = _zNwHr("\074\118\090\113\102\087\012\111\011\082\123\118\102\116\077\011\031\012\111\011\122\102")
_54_.Description = ""
_54_.Visible = true
_54_.Commands = {}
_54_.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_54_.Locked = false
_54_.Opened = false

-- Tasks --

-- Cartridge Variables --
_j8a = ""
_padX = 1
_ZMX0l = ""
_Y_5l2 = _zNwHr("\019\081\024\116\111")
_WBUeS = _zNwHr("\122\079\082\082\113")
_Tsk = _zNwHr("\019\116\085\054")
_9L2T = _zNwHr("\122\079\082\082\113")
_WudC = _zNwHr("\019\022\114\046")
_dZN = _zNwHr("\122\079\082\082\113")
_OsB.ZVariables = {
	_j8a = "", 
	_padX = 1, 
	_ZMX0l = "", 
	_Y_5l2 = _zNwHr("\019\081\024\116\111"), 
	_WBUeS = _zNwHr("\122\079\082\082\113"), 
	_Tsk = _zNwHr("\019\116\085\054"), 
	_9L2T = _zNwHr("\122\079\082\082\113"), 
	_WudC = _zNwHr("\019\022\114\046"), 
	_dZN = _zNwHr("\122\079\082\082\113")
}

-- Timers --

-- Inputs --
_GUf = Wherigo.ZInput(_OsB)
_GUf.Id = "07018f03-d2f8-4e22-82ee-724c0bfc7b65"
_GUf.Name = _zNwHr("\070\077\122\012\106\011\079\012\010\077\031\122\012\116\035\102\012\111\090\039\035\102\125")
_GUf.Description = ""
_GUf.Visible = true
_GUf.Media = _pDrGG
_GUf.Choices = {
	"Yes", 
	"No"
}
_GUf.InputType = "MultipleChoice"
_GUf.Text = _zNwHr("\070\077\122\012\106\011\079\012\010\077\031\122\012\116\035\102\012\111\090\039\035\102\125")

-- WorksWithList for object commands --

-- functions --
function _OsB:OnStart()
	_Urwigo.MessageBox{
		Text = _zNwHr("\085\031\012\116\035\077\065\012\095\035\102\087\077\013\011\012\102\105\123\077\102\087\077\102\031\039\102\012\113\011\079\012\095\077\118\118\012\071\102\012\013\077\104\102\031\012\116\035\102\012\122\077\065\116\090\031\039\102\012\116\011\012\116\035\102\012\013\102\011\039\090\039\035\102\012\071\079\116\012\031\011\116\012\116\035\102\012\071\102\090\087\077\031\013\005\012\092\123\102\031\012\116\035\102\012\087\102\104\102\087\065\102\012\013\102\011\039\090\039\035\102\012\071\011\105\012\077\031\012\113\011\079\087\012\077\116\102\082\065\012\082\102\031\079\012\116\011\012\071\102\013\077\031\005\012\060\035\102\012\087\102\104\102\087\065\102\012\039\090\039\035\102\012\071\011\105\012\095\077\118\118\012\090\118\065\011\012\112\102\102\123\012\116\087\090\039\112\012\011\046\012\116\035\102\012\031\079\082\071\102\087\012\011\046\012\116\087\077\102\065\012\113\011\079\012\082\090\112\102\005\012\074\118\102\090\065\102\012\046\102\102\118\012\046\087\102\102\012\116\011\012\123\011\065\116\012\116\035\077\065\012\031\079\082\071\102\087\012\116\011\012\113\011\079\087\012\046\011\079\031\122\012\077\116\012\118\011\013\005"), 
		Media = _xMfgG
	}
end
function _OsB:OnRestore()
end
function _X7tC:OnEnter()
	_Y_5l2 = _zNwHr("\019\081\024\116\111")
	_Urwigo.MessageBox{
		Text = _zNwHr("\106\011\079\012\090\087\102\012\087\102\090\118\118\113\012\039\118\011\065\102\005\005\005"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_GUf)
				end)
			end
		end
	}
end
function _X7tC:OnProximity()
	_Y_5l2 = _zNwHr("\019\081\024\116\111")
	_Urwigo.MessageBox{
		Text = _zNwHr("\106\011\079\012\090\087\102\012\087\102\090\118\118\113\012\039\118\011\065\102\005\005\005"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_GUf)
				end)
			end
		end
	}
	_X7tC.Active = true
end
function _GUf:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_ZMX0l = input
	if Wherigo.NoCaseEquals(_ZMX0l, _zNwHr("\106\102\065")) then
		_Urwigo.MessageBox{
			Text = "", 
			Media = _b5ghv, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = (_zNwHr("\060\035\077\065\012\095\035\102\087\077\013\011\012\039\090\087\116\087\077\122\013\102\012\095\090\065\012\122\102\065\077\013\031\102\122\012\071\113\012\010\011\087\102\065\116\088\022\035\011\065\116\005\012\085\012\035\011\123\102\012\113\011\079\012\102\031\047\011\113\102\122\012\077\116\005\012\060\011\012\118\102\090\087\031\012\082\011\087\102\012\090\071\011\079\116\012\117\035\102\087\077\013\011\065\012\123\118\102\090\065\102\012\104\077\065\077\116\012\095\035\102\087\077\013\011\046\011\079\031\122\090\116\077\011\031\005\039\011\082\005\012\106\011\079\087\012\123\118\090\113\102\087\012\039\011\082\123\118\102\116\077\011\031\012\111\011\122\102\012\077\065\023\012")..string.sub(Player.CompletionCode, 1, 15)).._zNwHr("\012\053\102\082\102\082\071\102\087\012\116\011\012\118\011\013\012\113\011\079\087\012\123\118\090\113\077\031\013\012\102\105\123\102\087\077\102\031\039\102\012\090\116\012\095\095\095\005\095\035\102\087\077\013\011\005\039\011\082\005\012\060\035\090\031\112\065\012\046\011\087\012\123\118\090\113\077\031\013\089"), 
						Media = _xacp, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				end
			end
		}
		_54_.Visible = true
		_54_:MoveTo(Player)
		_OsB.Complete = true
		_54_.Description = _zNwHr("\074\118\090\113\102\087\012\111\011\082\123\118\102\116\077\011\031\012\111\011\122\102")..string.sub(Player.CompletionCode, 1, 15)
	else
		_Urwigo.MessageBox{
			Text = _zNwHr("\085\012\090\082\012\065\011\087\087\113\012\116\035\090\116\012\113\011\079\012\122\077\122\031\001\116\012\046\077\031\122\012\077\116\005\012\106\011\079\012\090\087\102\012\104\102\087\113\012\039\118\011\065\102\012\116\035\011\079\013\035\005\012\085\046\012\113\011\079\012\116\035\077\031\112\012\116\035\102\012\039\090\039\035\102\012\077\065\012\082\077\065\065\077\031\013\012\123\118\102\090\065\102\012\039\011\031\116\090\039\116\012\116\035\102\012\111\092\005"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_GUf)
					end)
				end
			end
		}
	end
end
function _tI5:On_2XZhb(target)
	_j8a = ((((_zNwHr("\106\011\079\012\090\087\102\012")..(1 * Wherigo.VectorToPoint(Player.ObjectLocation, _X7tC.OriginalPoint):GetValue "ft")).._zNwHr("\012\046\102\102\116\012\046\087\011\082\012\116\035\102\012\039\090\039\035\102\005")).._zNwHr("\060\035\077\065\012\095\090\065\012\116\087\113\012\031\079\082\071\102\087\012")).._padX).._zNwHr("\005")
	_tI5.Description = _j8a
	_Urwigo.MessageBox{
		Text = _j8a, 
		Media = _tuF
	}
	_padX = _padX + 1
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return _OsB
