require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _Hk9(str)
	local res = ""
    local dtable = "\013\022\002\090\039\117\121\019\018\106\046\063\008\082\059\118\103\065\112\125\023\007\040\000\027\004\029\056\034\010\015\091\066\009\108\021\086\088\050\079\033\095\044\024\092\069\041\057\048\049\076\114\072\006\078\045\083\107\111\051\001\068\094\089\099\098\109\043\030\085\104\087\096\031\028\017\081\047\014\122\005\037\102\053\116\123\011\025\105\003\055\036\035\097\038\077\067\062\061\026\124\075\042\126\071\101\054\100\070\119\120\115\060\020\080\012\113\052\058\074\016\084\073\110\032\093\064"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_3Nho1 = Wherigo.ZCartridge()

-- Media --
_feS8k = Wherigo.ZMedia(_3Nho1)
_feS8k.Id = "0e5b52ef-6308-4f01-be64-8a4972b0b2e7"
_feS8k.Name = _Hk9("\071\106\089\124\052\089\065\071")
_feS8k.Description = ""
_feS8k.AltText = ""
_feS8k.Resources = {
	{
		Type = "jpg", 
		Filename = "heinrich.jpg", 
		Directives = {}
	}
}
_drxTX = Wherigo.ZMedia(_3Nho1)
_drxTX.Id = "4930e3d4-72b4-4eb4-a642-f2799ea4e4ab"
_drxTX.Name = _Hk9("\110\071\106\052\089\017\059")
_drxTX.Description = ""
_drxTX.AltText = ""
_drxTX.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo1.jpg", 
		Directives = {}
	}
}
_71A = Wherigo.ZMedia(_3Nho1)
_71A.Id = "360a6177-8cbc-4a15-b8ea-1c555dcb14f2"
_71A.Name = _Hk9("\066\094\124\108\094\017\106\112")
_71A.Description = ""
_71A.AltText = ""
_71A.Resources = {
	{
		Type = "jpg", 
		Filename = "bandages.jpg", 
		Directives = {}
	}
}
_tiB = Wherigo.ZMedia(_3Nho1)
_tiB.Id = "2fa7b76d-d99d-49d6-b877-afc3c70bfb02"
_tiB.Name = _Hk9("\106\016\089\108\106\124\065\106")
_tiB.Description = ""
_tiB.AltText = ""
_tiB.Resources = {
	{
		Type = "jpg", 
		Filename = "evidence.jpg", 
		Directives = {}
	}
}
_E58w = Wherigo.ZMedia(_3Nho1)
_E58w.Id = "894652ef-4652-49ec-8f97-e9f3d702736b"
_E58w.Name = _Hk9("\017\059\035\108\106\124\125\094\067\067\059\125\065\094\124")
_E58w.Description = ""
_E58w.AltText = ""
_E58w.Resources = {
	{
		Type = "jpg", 
		Filename = "golden_ammo_can.jpg", 
		Directives = {}
	}
}
_mERx3 = Wherigo.ZMedia(_3Nho1)
_mERx3.Id = "0d9f46c7-8e83-4a1b-a7e9-d680b609fc80"
_mERx3.Name = _Hk9("\065\052\094\080\007\125\067\094\124")
_mERx3.Description = ""
_mERx3.AltText = ""
_mERx3.Resources = {
	{
		Type = "jpg", 
		Filename = "crazy_man.jpg", 
		Directives = {}
	}
}
_XTIp = Wherigo.ZMedia(_3Nho1)
_XTIp.Id = "3c3e9422-660d-48f9-979c-c77fb05ebb2d"
_XTIp.Name = _Hk9("\065\052\094\065\058\106\108\125\110\089\124\108\059\110")
_XTIp.Description = ""
_XTIp.AltText = ""
_XTIp.Resources = {
	{
		Type = "jpg", 
		Filename = "cracked_window.jpg", 
		Directives = {}
	}
}
_kgJ = Wherigo.ZMedia(_3Nho1)
_kgJ.Id = "a668c626-05ea-40da-a8f6-6ed9632765c2"
_kgJ.Name = _Hk9("\124\059\085\106\019\094\108")
_kgJ.Description = ""
_kgJ.AltText = ""
_kgJ.Resources = {
	{
		Type = "jpg", 
		Filename = "notepad.jpg", 
		Directives = {}
	}
}
_RELx = Wherigo.ZMedia(_3Nho1)
_RELx.Id = "a0caf04e-df33-4766-b9e6-c81c7d7df719"
_RELx.Name = _Hk9("\110\052\059\124\017\125\094\124\112\110\106\052")
_RELx.Description = ""
_RELx.AltText = ""
_RELx.Resources = {
	{
		Type = "jpg", 
		Filename = "wrong_answer.jpg", 
		Directives = {}
	}
}
_Aphu = Wherigo.ZMedia(_3Nho1)
_Aphu.Id = "e01c5ad3-2ce6-463b-a809-f54fc4585cae"
_Aphu.Name = _Hk9("\109\059\006\124\085\094\089\124")
_Aphu.Description = ""
_Aphu.AltText = ""
_Aphu.Resources = {
	{
		Type = "jpg", 
		Filename = "fountain1.jpg", 
		Directives = {}
	}
}
_t_Ykx = Wherigo.ZMedia(_3Nho1)
_t_Ykx.Id = "986b0b59-f32c-48c5-8823-a2ebb8224f8a"
_t_Ykx.Name = _Hk9("\067\094\017\124\089\083\007\089\124\017\125\017\035\094\112\112")
_t_Ykx.Description = ""
_t_Ykx.AltText = ""
_t_Ykx.Resources = {
	{
		Type = "jpg", 
		Filename = "detective.jpg", 
		Directives = {}
	}
}
_iwj = Wherigo.ZMedia(_3Nho1)
_iwj.Id = "704d0708-e923-4b0f-a347-b775316d71df"
_iwj.Name = _Hk9("\122\094\112\058")
_iwj.Description = ""
_iwj.AltText = ""
_iwj.Resources = {
	{
		Type = "jpg", 
		Filename = "task.jpg", 
		Directives = {}
	}
}
_nw6Gm = Wherigo.ZMedia(_3Nho1)
_nw6Gm.Id = "95708fd7-712c-46df-b3a5-8d4049e199ac"
_nw6Gm.Name = _Hk9("\057\065\094\052\094\066")
_nw6Gm.Description = ""
_nw6Gm.AltText = ""
_nw6Gm.Resources = {
	{
		Type = "png", 
		Filename = "headerMOGA2015.png", 
		Directives = {}
	}
}
_yxLx3 = Wherigo.ZMedia(_3Nho1)
_yxLx3.Id = "423eac83-98fd-4826-84b9-09c146a9c94c"
_yxLx3.Name = _Hk9("\066\059\059\058\125\059\083\125\085\071\106\125\108\106\094\108")
_yxLx3.Description = ""
_yxLx3.AltText = ""
_yxLx3.Resources = {
	{
		Type = "jpg", 
		Filename = "Egyptian_Book_of_the_Dead.jpg", 
		Directives = {}
	}
}
_J80 = Wherigo.ZMedia(_3Nho1)
_J80.Id = "b4e1daf5-2899-4dfc-b1e3-8e666948c04a"
_J80.Name = _Hk9("\019\071\059\124\106\125\065\094\035\035")
_J80.Description = ""
_J80.AltText = ""
_J80.Resources = {
	{
		Type = "mp3", 
		Filename = "Telephone_Ring.mp3", 
		Directives = {}
	}
}
_tJ5 = Wherigo.ZMedia(_3Nho1)
_tJ5.Id = "56f3abe8-b491-4801-99b7-1212f75863e4"
_tJ5.Name = _Hk9("\019\071\059\124\106")
_tJ5.Description = ""
_tJ5.AltText = ""
_tJ5.Resources = {
	{
		Type = "jpg", 
		Filename = "telephone_ringing.jpg", 
		Directives = {}
	}
}
_9wxH = Wherigo.ZMedia(_3Nho1)
_9wxH.Id = "1c80cc56-47c4-4def-9a6e-effa29236971"
_9wxH.Name = _Hk9("\058\124\059\065\058")
_9wxH.Description = ""
_9wxH.AltText = ""
_9wxH.Resources = {
	{
		Type = "mp3", 
		Filename = "knock-on-wood.mp3", 
		Directives = {}
	}
}
_I_Il = Wherigo.ZMedia(_3Nho1)
_I_Il.Id = "a8cd555c-8d08-4410-b838-bcb6e4614217"
_I_Il.Name = _Hk9("\019\059\035\089\065\106\125\112\085\094\085\089\059\124")
_I_Il.Description = ""
_I_Il.AltText = ""
_I_Il.Resources = {
	{
		Type = "jpg", 
		Filename = "police_station.jpg", 
		Directives = {}
	}
}
_6Y9 = Wherigo.ZMedia(_3Nho1)
_6Y9.Id = "009222c3-e8dd-4d0c-8245-f4c2d2f84498"
_6Y9.Name = _Hk9("\085\071\106\125\067\006\067\067\007")
_6Y9.Description = ""
_6Y9.AltText = ""
_6Y9.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_final_resize.jpg", 
		Directives = {}
	}
}
_suJf = Wherigo.ZMedia(_3Nho1)
_suJf.Id = "39c4cb23-248c-4932-b8de-61bedf33dd6b"
_suJf.Name = _Hk9("\085\071\106\125\067\006\067\067\007\125\017\052\059\094\124")
_suJf.Description = ""
_suJf.AltText = ""
_suJf.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_groan.jpg", 
		Directives = {}
	}
}
_Cb3 = Wherigo.ZMedia(_3Nho1)
_Cb3.Id = "e8ad8bdc-8fd5-4c15-8841-4bc64c98bc59"
_Cb3.Name = _Hk9("\062\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106")
_Cb3.Description = ""
_Cb3.AltText = ""
_Cb3.Resources = {
	{
		Type = "jpg", 
		Filename = "detective_malone.jpg", 
		Directives = {}
	}
}
_89gA = Wherigo.ZMedia(_3Nho1)
_89gA.Id = "1731406b-7e6a-4f9e-8d37-f44a5d81b90c"
_89gA.Name = _Hk9("\019\071\059\124\106\125\065\059\124\016\106\052\112\094\085\089\059\124")
_89gA.Description = ""
_89gA.AltText = ""
_89gA.Resources = {
	{
		Type = "jpg", 
		Filename = "phone_convo.jpg", 
		Directives = {}
	}
}
_mw4KC = Wherigo.ZMedia(_3Nho1)
_mw4KC.Id = "6f544cea-eeb2-46db-8f29-033fffc0713e"
_mw4KC.Name = _Hk9("\112\071\059\085\017\006\124\042\112\071\106\035\035\112")
_mw4KC.Description = ""
_mw4KC.AltText = ""
_mw4KC.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun_shells.jpg", 
		Directives = {}
	}
}
_a30x0 = Wherigo.ZMedia(_3Nho1)
_a30x0.Id = "f1b66f70-7b93-4765-8324-5f2b9fb8e5ea"
_a30x0.Name = _Hk9("\112\071\059\085\017\006\124")
_a30x0.Description = ""
_a30x0.AltText = ""
_a30x0.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun.jpg", 
		Directives = {}
	}
}
__2lH = Wherigo.ZMedia(_3Nho1)
__2lH.Id = "1831fa6b-1836-494f-a18a-6d987e15ce8b"
__2lH.Name = _Hk9("\105\006\124\125\065\094\112\106")
__2lH.Description = ""
__2lH.AltText = ""
__2lH.Resources = {
	{
		Type = "jpg", 
		Filename = "gun_case.jpg", 
		Directives = {}
	}
}
_ep9P = Wherigo.ZMedia(_3Nho1)
_ep9P.Id = "0ab97ac5-0226-437e-b97f-f0c3a0fc7eb8"
_ep9P.Name = _Hk9("\065\106\067\106\085\106\052\007")
_ep9P.Description = ""
_ep9P.AltText = ""
_ep9P.Resources = {
	{
		Type = "jpg", 
		Filename = "cemetery.jpg", 
		Directives = {}
	}
}
_BnyC = Wherigo.ZMedia(_3Nho1)
_BnyC.Id = "cd1a8ddd-14ed-4251-987e-111069fe2073"
_BnyC.Name = _Hk9("\094\124\058\071\050")
_BnyC.Description = ""
_BnyC.AltText = ""
_BnyC.Resources = {
	{
		Type = "jpg", 
		Filename = "ankh1.jpg", 
		Directives = {}
	}
}
_fZBK = Wherigo.ZMedia(_3Nho1)
_fZBK.Id = "09a7cb2c-05fc-4590-8b24-8bcbce4e131b"
_fZBK.Name = _Hk9("\057\071\059\085\017\006\124\125\052\106\035\059\094\108")
_fZBK.Description = ""
_fZBK.AltText = ""
_fZBK.Resources = {
	{
		Type = "mp3", 
		Filename = "shotgun_reload.mp3", 
		Directives = {}
	}
}
_hiw1 = Wherigo.ZMedia(_3Nho1)
_hiw1.Id = "7c34e486-028d-4c69-9a85-46d2aa94fff1"
_hiw1.Name = _Hk9("\057\071\059\085\017\006\124\125\109\089\052\106")
_hiw1.Description = ""
_hiw1.AltText = ""
_hiw1.Resources = {
	{
		Type = "mp3", 
		Filename = "shotgun-fire.mp3", 
		Directives = {}
	}
}
_vvk = Wherigo.ZMedia(_3Nho1)
_vvk.Id = "5c80f435-6931-43ed-bfef-a2d61b4a6bd5"
_vvk.Name = _Hk9("\096\094\019\125\085\059\125\085\071\106\125\083\089\124\094\035")
_vvk.Description = ""
_vvk.AltText = ""
_vvk.Resources = {
	{
		Type = "jpg", 
		Filename = "map140.jpg", 
		Directives = {}
	}
}
_Avmh = Wherigo.ZMedia(_3Nho1)
_Avmh.Id = "10f01a67-e25b-445a-b6ab-83232c472220"
_Avmh.Name = _Hk9("\033\052\089\017\071\085\125\057\071\089\124\089\124\017\125\051\089\017\071\085")
_Avmh.Description = ""
_Avmh.AltText = ""
_Avmh.Resources = {
	{
		Type = "jpg", 
		Filename = "Bright-Light1.jpg", 
		Directives = {}
	}
}
_ClR_ = Wherigo.ZMedia(_3Nho1)
_ClR_.Id = "07b1fb4a-7929-45f2-bdfc-11ef28ddeb03"
_ClR_.Name = _Hk9("\067\006\067\067\007\125\094\085\085\094\065\058")
_ClR_.Description = ""
_ClR_.AltText = ""
_ClR_.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_attack.jpg", 
		Directives = {}
	}
}
_53Cm = Wherigo.ZMedia(_3Nho1)
_53Cm.Id = "24b62609-fbfa-4277-8462-b0247cfce804"
_53Cm.Name = _Hk9("\065\071\094\067\066\106\052\125\059\083\125\065\059\067\067\106\052\065\106")
_53Cm.Description = ""
_53Cm.AltText = ""
_53Cm.Resources = {
	{
		Type = "jpg", 
		Filename = "chamber_of_commerce.jpg", 
		Directives = {}
	}
}
_7Pla = Wherigo.ZMedia(_3Nho1)
_7Pla.Id = "78e53f37-41bd-4dea-8b6d-aa94761a8894"
_7Pla.Name = _Hk9("\065\071\094\067\066\106\052\125\059\083\125\065\059\067\067\106\052\065\106\125\089\065\059\124")
_7Pla.Description = ""
_7Pla.AltText = ""
_7Pla.Resources = {
	{
		Type = "jpg", 
		Filename = "chamber_of_commerce_icon.jpg", 
		Directives = {}
	}
}
_6cIY = Wherigo.ZMedia(_3Nho1)
_6cIY.Id = "192f433d-6030-4f35-81f7-e4054d87a845"
_6cIY.Name = _Hk9("\112\085\059\052\106")
_6cIY.Description = ""
_6cIY.AltText = ""
_6cIY.Resources = {
	{
		Type = "jpg", 
		Filename = "bussiness_district.jpg", 
		Directives = {}
	}
}
_H3Ew = Wherigo.ZMedia(_3Nho1)
_H3Ew.Id = "b35a8a44-66e0-4b1c-857e-beb8490e47e9"
_H3Ew.Name = _Hk9("\112\085\059\052\106\125\089\065\059\124")
_H3Ew.Description = ""
_H3Ew.AltText = ""
_H3Ew.Resources = {
	{
		Type = "jpg", 
		Filename = "bussiness_district_icon.jpg", 
		Directives = {}
	}
}
_hTfw = Wherigo.ZMedia(_3Nho1)
_hTfw.Id = "b0288446-8e98-4e2a-a7e4-868a54cb1e8d"
_hTfw.Name = _Hk9("\019\059\035\089\065\106\125\112\085\094\085\089\059\124\125\089\065\059\124")
_hTfw.Description = ""
_hTfw.AltText = ""
_hTfw.Resources = {
	{
		Type = "jpg", 
		Filename = "police_station_icon.jpg", 
		Directives = {}
	}
}
_tpg = Wherigo.ZMedia(_3Nho1)
_tpg.Id = "790bdbfc-4c38-4e3c-ae4e-e800d01973f5"
_tpg.Name = _Hk9("\065\106\067\106\085\106\052\007\125\089\065\059\124")
_tpg.Description = ""
_tpg.AltText = ""
_tpg.Resources = {
	{
		Type = "jpg", 
		Filename = "cemetery_icon.jpg", 
		Directives = {}
	}
}
_ajz17 = Wherigo.ZMedia(_3Nho1)
_ajz17.Id = "5b21eb20-7187-4896-8490-bc54ea0737f6"
_ajz17.Name = _Hk9("\017\059\035\108\106\124\125\094\067\067\059\125\065\094\124\125\089\065\059\124")
_ajz17.Description = ""
_ajz17.AltText = ""
_ajz17.Resources = {
	{
		Type = "jpg", 
		Filename = "golden_ammo_can_icon.jpg", 
		Directives = {}
	}
}
_KP8Y5 = Wherigo.ZMedia(_3Nho1)
_KP8Y5.Id = "3fdf71c6-139d-4c0e-949d-37ab005ef465"
_KP8Y5.Name = _Hk9("\083\059\006\124\085\094\089\124\125\089\065\059\124")
_KP8Y5.Description = ""
_KP8Y5.AltText = ""
_KP8Y5.Resources = {
	{
		Type = "jpg", 
		Filename = "fountain_icon.jpg", 
		Directives = {}
	}
}
_jvSQ = Wherigo.ZMedia(_3Nho1)
_jvSQ.Id = "6fa284da-8b2a-4fff-a28d-0b53b80b42a9"
_jvSQ.Name = _Hk9("\094\052\065\071\089\016\106\112\042\089\065\059\124")
_jvSQ.Description = ""
_jvSQ.AltText = ""
_jvSQ.Resources = {
	{
		Type = "jpg", 
		Filename = "archives_icon.jpg", 
		Directives = {}
	}
}
_XyK_ = Wherigo.ZMedia(_3Nho1)
_XyK_.Id = "f20d4163-7a4f-414a-bcf2-db378eb81ca2"
_XyK_.Name = _Hk9("\094\052\065\071\089\016\106\112")
_XyK_.Description = ""
_XyK_.AltText = ""
_XyK_.Resources = {
	{
		Type = "jpg", 
		Filename = "archives.jpg", 
		Directives = {}
	}
}
_SuNy = Wherigo.ZMedia(_3Nho1)
_SuNy.Id = "65c5fd81-1095-4b27-9394-d7dd07c2e5d5"
_SuNy.Name = _Hk9("\108\106\085\106\065\085\089\016\106\125\067\094\035\059\124\106\125\089\065\059\124")
_SuNy.Description = ""
_SuNy.AltText = ""
_SuNy.Resources = {
	{
		Type = "jpg", 
		Filename = "detective_malone_icon.jpg", 
		Directives = {}
	}
}
_Wf0 = Wherigo.ZMedia(_3Nho1)
_Wf0.Id = "1f6c0340-fdc9-4298-be40-477a03ce26a2"
_Wf0.Name = _Hk9("\065\052\094\080\007\125\067\094\124\125\089\065\059\124")
_Wf0.Description = ""
_Wf0.AltText = ""
_Wf0.Resources = {
	{
		Type = "jpg", 
		Filename = "crazy_man_icon.jpg", 
		Directives = {}
	}
}
_QJu = Wherigo.ZMedia(_3Nho1)
_QJu.Id = "b16a52ec-ac4b-4542-b84e-3f1a57e0c03b"
_QJu.Name = _Hk9("\071\106\089\124\052\089\065\071\125\089\065\059\124")
_QJu.Description = ""
_QJu.AltText = ""
_QJu.Resources = {
	{
		Type = "jpg", 
		Filename = "heinrich_icon.jpg", 
		Directives = {}
	}
}
_tGn = Wherigo.ZMedia(_3Nho1)
_tGn.Id = "170078ac-b3a2-4778-bcbf-84013faf7968"
_tGn.Name = _Hk9("\067\006\067\067\007\125\089\065\059\124")
_tGn.Description = ""
_tGn.AltText = ""
_tGn.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_final_resize_icon.jpg", 
		Directives = {}
	}
}
_h937 = Wherigo.ZMedia(_3Nho1)
_h937.Id = "f4a24d49-5460-4044-8dab-5592811da250"
_h937.Name = _Hk9("\112\071\059\085\017\006\124\042\112\071\106\035\035\112\042\089\065\059\124")
_h937.Description = ""
_h937.AltText = ""
_h937.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun_shells_icon.jpg", 
		Directives = {}
	}
}
_C39xx = Wherigo.ZMedia(_3Nho1)
_C39xx.Id = "6e6d0b7c-26de-4d37-8f64-f7578881c481"
_C39xx.Name = _Hk9("\066\059\059\058\125\059\083\125\085\071\106\125\108\106\094\108\125\089\065\059\124")
_C39xx.Description = ""
_C39xx.AltText = ""
_C39xx.Resources = {
	{
		Type = "jpg", 
		Filename = "Egyptian_Book_of_the_Dead_icon.jpg", 
		Directives = {}
	}
}
_1G2G4 = Wherigo.ZMedia(_3Nho1)
_1G2G4.Id = "c7537017-bed9-4fb8-8bd8-1af4ae5d323d"
_1G2G4.Name = _Hk9("\112\071\059\085\017\006\124\125\089\065\059\124")
_1G2G4.Description = ""
_1G2G4.AltText = ""
_1G2G4.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun_icon2.jpg", 
		Directives = {}
	}
}
_CfmI = Wherigo.ZMedia(_3Nho1)
_CfmI.Id = "068c8699-4f66-428b-98e7-9b5f14356ff0"
_CfmI.Name = _Hk9("\065\052\094\065\058\106\108\125\110\089\124\108\059\110\125\089\065\059\124")
_CfmI.Description = ""
_CfmI.AltText = ""
_CfmI.Resources = {
	{
		Type = "jpg", 
		Filename = "cracked_window_icon.jpg", 
		Directives = {}
	}
}
_YK9J = Wherigo.ZMedia(_3Nho1)
_YK9J.Id = "fb1de128-66e2-4675-9e45-079c82afbc99"
_YK9J.Name = _Hk9("\094\124\058\071\042\089\065\059\124")
_YK9J.Description = ""
_YK9J.AltText = ""
_YK9J.Resources = {
	{
		Type = "jpg", 
		Filename = "ankh_icon.jpg", 
		Directives = {}
	}
}
_81v = Wherigo.ZMedia(_3Nho1)
_81v.Id = "5a0bda36-16d5-4c51-aaf6-3241a5473f05"
_81v.Name = _Hk9("\017\006\124\125\065\094\112\106\125\089\065\059\124")
_81v.Description = ""
_81v.AltText = ""
_81v.Resources = {
	{
		Type = "jpg", 
		Filename = "gun_case_icon.jpg", 
		Directives = {}
	}
}
_klkr = Wherigo.ZMedia(_3Nho1)
_klkr.Id = "685de4cf-75ac-4716-a42c-6fbb9ef9d050"
_klkr.Name = _Hk9("\112\094\052\065\059\019\071\094\017\006\112\042\089\065\059\124")
_klkr.Description = ""
_klkr.AltText = ""
_klkr.Resources = {
	{
		Type = "jpg", 
		Filename = "sarcophagus_icon.jpg", 
		Directives = {}
	}
}
_hQa3 = Wherigo.ZMedia(_3Nho1)
_hQa3.Id = "2aeac13e-7914-44df-8b2a-215002e32e27"
_hQa3.Name = _Hk9("\067\094\019\125\089\065\059\124")
_hQa3.Description = ""
_hQa3.AltText = ""
_hQa3.Resources = {
	{
		Type = "jpg", 
		Filename = "map140_icon.jpg", 
		Directives = {}
	}
}
_AYzzi = Wherigo.ZMedia(_3Nho1)
_AYzzi.Id = "148a0131-fe9f-43d0-97ec-4d27cfbe7e57"
_AYzzi.Name = _Hk9("\085\094\112\058\125\089\065\059\124")
_AYzzi.Description = ""
_AYzzi.AltText = ""
_AYzzi.Resources = {
	{
		Type = "jpg", 
		Filename = "task_icon.jpg", 
		Directives = {}
	}
}
_ZcCL3 = Wherigo.ZMedia(_3Nho1)
_ZcCL3.Id = "97624775-d0df-4595-bdcf-85dde3884f60"
_ZcCL3.Name = _Hk9("\112\071\059\019\125\059\110\124\106\052")
_ZcCL3.Description = ""
_ZcCL3.AltText = ""
_ZcCL3.Resources = {
	{
		Type = "jpg", 
		Filename = "shop_owner.jpg", 
		Directives = {}
	}
}
_aeMj = Wherigo.ZMedia(_3Nho1)
_aeMj.Id = "3dfcfb09-f9c5-49be-a38d-9e9b9a629e7b"
_aeMj.Name = _Hk9("\124\059\085\106\019\094\108\042\089\065\059\124")
_aeMj.Description = ""
_aeMj.AltText = ""
_aeMj.Resources = {
	{
		Type = "jpg", 
		Filename = "notepad_icon.jpg", 
		Directives = {}
	}
}
_9ho = Wherigo.ZMedia(_3Nho1)
_9ho.Id = "d8e35644-8480-44d2-be19-9312be092eff"
_9ho.Name = _Hk9("\067\006\067\067\007\125\017\052\059\094\124")
_9ho.Description = ""
_9ho.AltText = ""
_9ho.Resources = {
	{
		Type = "mp3", 
		Filename = "Mummy.mp3", 
		Directives = {}
	}
}
_hb9GP = Wherigo.ZMedia(_3Nho1)
_hb9GP.Id = "50e64107-dd07-427c-9b4d-a38f946bc20c"
_hb9GP.Name = _Hk9("\067\006\067\067\007\125\108\106\094\085\071")
_hb9GP.Description = ""
_hb9GP.AltText = ""
_hb9GP.Resources = {
	{
		Type = "mp3", 
		Filename = "Monster_Laugh.mp3", 
		Directives = {}
	}
}
_K4VU = Wherigo.ZMedia(_3Nho1)
_K4VU.Id = "a4fa4f24-2c5b-4087-8a85-13ad5ab60545"
_K4VU.Name = _Hk9("\067\006\067\067\007\125\094\085\085\094\065\058\125\112\059\006\124\108")
_K4VU.Description = ""
_K4VU.AltText = ""
_K4VU.Resources = {
	{
		Type = "mp3", 
		Filename = "punch_or_whack_-Vladimir-403040765.mp3", 
		Directives = {}
	}
}
_nBhR = Wherigo.ZMedia(_3Nho1)
_nBhR.Id = "9ee3990d-7fda-4e29-9805-df86785c4496"
_nBhR.Name = _Hk9("\112\065\094\052\094\066\125\089\065\059\124")
_nBhR.Description = ""
_nBhR.AltText = ""
_nBhR.Resources = {
	{
		Type = "jpg", 
		Filename = "scarab_icon.jpg", 
		Directives = {}
	}
}
_k1Zz = Wherigo.ZMedia(_3Nho1)
_k1Zz.Id = "4cfd19fa-bcbf-4cae-af3b-afba9d7abe6c"
_k1Zz.Name = _Hk9("\065\094\052\085\125\108\106\085\094\089\035")
_k1Zz.Description = ""
_k1Zz.AltText = ""
_k1Zz.Resources = {
	{
		Type = "jpg", 
		Filename = "cart_detail.jpg", 
		Directives = {}
	}
}
_yVITk = Wherigo.ZMedia(_3Nho1)
_yVITk.Id = "6700313e-1a71-4da1-99e6-13da067d5d71"
_yVITk.Name = _Hk9("\112\019\094\052\058\035\106\125\112\059\006\124\108")
_yVITk.Description = ""
_yVITk.AltText = ""
_yVITk.Resources = {
	{
		Type = "mp3", 
		Filename = "magic-chime-02.mp3", 
		Directives = {}
	}
}
_PE1 = Wherigo.ZMedia(_3Nho1)
_PE1.Id = "4de454d1-e034-4fe5-9504-e85934d32fed"
_PE1.Name = _Hk9("\097\094\052\085\042\108\106\085\094\089\035\042\089\065\059\124")
_PE1.Description = ""
_PE1.AltText = ""
_PE1.Resources = {
	{
		Type = "png", 
		Filename = "cart_detail_icon.png", 
		Directives = {}
	}
}
_5N2tX = Wherigo.ZMedia(_3Nho1)
_5N2tX.Id = "cb9f70f8-fef7-4078-95f3-7f65a6e4e7f2"
_5N2tX.Name = _Hk9("\050")
_5N2tX.Description = ""
_5N2tX.AltText = ""
_5N2tX.Resources = {
	{
		Type = "jpg", 
		Filename = "1.jpg", 
		Directives = {}
	}
}
_4Dzp = Wherigo.ZMedia(_3Nho1)
_4Dzp.Id = "bad1cfbc-c3ca-4a20-9d20-5cb1f4d29198"
_4Dzp.Name = _Hk9("\107")
_4Dzp.Description = ""
_4Dzp.AltText = ""
_4Dzp.Resources = {
	{
		Type = "jpg", 
		Filename = "6.jpg", 
		Directives = {}
	}
}
_R3A = Wherigo.ZMedia(_3Nho1)
_R3A.Id = "7173a86c-8395-4efb-b755-9eac225c21dd"
_R3A.Name = _Hk9("\084")
_R3A.Description = ""
_R3A.AltText = ""
_R3A.Resources = {
	{
		Type = "jpg", 
		Filename = "5.jpg", 
		Directives = {}
	}
}
_K87 = Wherigo.ZMedia(_3Nho1)
_K87.Id = "259cbd36-5148-4cb4-94b3-3e2721dd7fb7"
_K87.Name = _Hk9("\039")
_K87.Description = ""
_K87.AltText = ""
_K87.Resources = {
	{
		Type = "jpg", 
		Filename = "2.jpg", 
		Directives = {}
	}
}
_iit1b = Wherigo.ZMedia(_3Nho1)
_iit1b.Id = "4a723c39-9bc1-4371-9829-e1f9f3acc21a"
_iit1b.Name = _Hk9("\118")
_iit1b.Description = ""
_iit1b.AltText = ""
_iit1b.Resources = {
	{
		Type = "jpg", 
		Filename = "4.jpg", 
		Directives = {}
	}
}
_qzXFo = Wherigo.ZMedia(_3Nho1)
_qzXFo.Id = "e21e13d8-4ce6-45e7-8b69-52a5f8f358e1"
_qzXFo.Name = _Hk9("\050\039")
_qzXFo.Description = ""
_qzXFo.AltText = ""
_qzXFo.Resources = {
	{
		Type = "jpg", 
		Filename = "12.jpg", 
		Directives = {}
	}
}
_z7bIL = Wherigo.ZMedia(_3Nho1)
_z7bIL.Id = "fdc1475e-da0f-4d95-b848-adb3590ec3e0"
_z7bIL.Name = _Hk9("\066\094\124\108\094\017\106\042\089\065\059\124")
_z7bIL.Description = ""
_z7bIL.AltText = ""
_z7bIL.Resources = {
	{
		Type = "jpg", 
		Filename = "bandage_icon.jpg", 
		Directives = {}
	}
}
_Z68r = Wherigo.ZMedia(_3Nho1)
_Z68r.Id = "fbcf51dc-6b87-4d78-b8ed-5e4ac3deae89"
_Z68r.Name = _Hk9("\106\016\089\108\106\124\065\106\125\089\065\059\124")
_Z68r.Description = ""
_Z68r.AltText = ""
_Z68r.Resources = {
	{
		Type = "jpg", 
		Filename = "evidence_icon.jpg", 
		Directives = {}
	}
}
_AjUR = Wherigo.ZMedia(_3Nho1)
_AjUR.Id = "eb195e2a-3846-443c-a622-d3e6a631804e"
_AjUR.Name = _Hk9("\094\124\017\106\035\112")
_AjUR.Description = ""
_AjUR.AltText = ""
_AjUR.Resources = {
	{
		Type = "mp3", 
		Filename = "heavenly_choir.mp3", 
		Directives = {}
	}
}
_hGLkU = Wherigo.ZMedia(_3Nho1)
_hGLkU.Id = "0f825baa-1baf-42f0-9065-a82aeb062b8e"
_hGLkU.Name = _Hk9("\017\052\094\112\112\007\125\094\052\106\094")
_hGLkU.Description = ""
_hGLkU.AltText = ""
_hGLkU.Resources = {
	{
		Type = "jpg", 
		Filename = "grassy_area.jpg", 
		Directives = {}
	}
}
_SKKY1 = Wherigo.ZMedia(_3Nho1)
_SKKY1.Id = "87ad7b65-0482-43c5-b785-cea37e848b94"
_SKKY1.Name = _Hk9("\017\052\094\112\112\007\125\094\052\106\094\125\089\065\059\124")
_SKKY1.Description = ""
_SKKY1.AltText = ""
_SKKY1.Resources = {
	{
		Type = "jpg", 
		Filename = "grassy_area_icon.jpg", 
		Directives = {}
	}
}
_Gcf0 = Wherigo.ZMedia(_3Nho1)
_Gcf0.Id = "b89106d5-a0d5-4bf6-b49a-dfa6e37e0c18"
_Gcf0.Name = _Hk9("\065\052\059\112\112\071\094\089\052\112")
_Gcf0.Description = ""
_Gcf0.AltText = ""
_Gcf0.Resources = {
	{
		Type = "jpg", 
		Filename = "resize_crosshairs.jpg", 
		Directives = {}
	}
}
_uUW = Wherigo.ZMedia(_3Nho1)
_uUW.Id = "e380d15d-b137-4b89-8e4c-806107c22e5c"
_uUW.Name = _Hk9("\112\094\052\065\059\019\071\094\017\006\112")
_uUW.Description = ""
_uUW.AltText = ""
_uUW.Resources = {
	{
		Type = "jpg", 
		Filename = "sarcophagus.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_3Nho1.Id="d427a52b-22bb-48a7-8afc-6c281c5ca518"
_3Nho1.Name="The Curse of the Pharaoh"
_3Nho1.Description=[[]]
_3Nho1.Visible=true
_3Nho1.Activity="Fiction"
_3Nho1.StartingLocationDescription=[[Move to the archives building, your adventure begins there.]]
_3Nho1.StartingLocation = ZonePoint(37.38331,-89.66678,0)
_3Nho1.Version=""
_3Nho1.Company=""
_3Nho1.Author="Forest-Ghost"
_3Nho1.BuilderVersion="URWIGO 1.21.5528.18461"
_3Nho1.CreateDate="03/02/2015 23:22:32"
_3Nho1.PublishDate="1/1/0001 12:00:00 AM"
_3Nho1.UpdateDate="07/14/2015 16:23:54"
_3Nho1.LastPlayedDate="1/1/0001 12:00:00 AM"
_3Nho1.TargetDevice="PocketPC"
_3Nho1.TargetDeviceVersion="0"
_3Nho1.StateId="1"
_3Nho1.CountryId="2"
_3Nho1.Complete=false
_3Nho1.UseLogging=true

_3Nho1.Media=_k1Zz

_3Nho1.Icon=_PE1


-- Zones --
_4N_ia = Wherigo.Zone(_3Nho1)
_4N_ia.Id = "09a4e3b1-2ba9-4582-9e22-0d59e182d7d4"
_4N_ia.Name = _Hk9("\018\052\065\071\089\016\106\112")
_4N_ia.Description = ""
_4N_ia.Visible = true
_4N_ia.Media = _XyK_
_4N_ia.Icon = _jvSQ
_4N_ia.Commands = {}
_4N_ia.DistanceRange = Distance(-1, "feet")
_4N_ia.ShowObjects = "OnProximity"
_4N_ia.ProximityRange = Distance(8, "meters")
_4N_ia.AllowSetPositionTo = false
_4N_ia.Active = true
_4N_ia.Points = {
	ZonePoint(37.3835471097173, -89.6669024203368, 0), 
	ZonePoint(37.3835197222938, -89.6666538675797, 0), 
	ZonePoint(37.3833942201783, -89.6666717806698, 0), 
	ZonePoint(37.3834229170128, -89.6669373601254, 0)
}
_4N_ia.OriginalPoint = ZonePoint(37.3834709923006, -89.6667913571779, 0)
_4N_ia.DistanceRangeUOM = "Feet"
_4N_ia.ProximityRangeUOM = "Meters"
_4N_ia.OutOfRangeName = ""
_4N_ia.InRangeName = ""
_2W4Qr = Wherigo.Zone(_3Nho1)
_2W4Qr.Id = "a59a371c-58f2-44e8-bada-897338372dc2"
_2W4Qr.Name = _Hk9("\097\071\094\067\066\106\052\125\059\083\125\097\059\067\067\106\052\065\106")
_2W4Qr.Description = ""
_2W4Qr.Visible = true
_2W4Qr.Media = _53Cm
_2W4Qr.Icon = _7Pla
_2W4Qr.Commands = {}
_2W4Qr.DistanceRange = Distance(-1, "feet")
_2W4Qr.ShowObjects = "OnProximity"
_2W4Qr.ProximityRange = Distance(8, "meters")
_2W4Qr.AllowSetPositionTo = false
_2W4Qr.Active = false
_2W4Qr.Points = {
	ZonePoint(37.3822731421092, -89.6667121387665, 0), 
	ZonePoint(37.3822638904461, -89.6665553852838, 0), 
	ZonePoint(37.3823834557339, -89.6665459975522, 0), 
	ZonePoint(37.3823931530884, -89.6667029067797, 0)
}
_2W4Qr.OriginalPoint = ZonePoint(37.3823284103444, -89.6666291070956, 0)
_2W4Qr.DistanceRangeUOM = "Feet"
_2W4Qr.ProximityRangeUOM = "Meters"
_2W4Qr.OutOfRangeName = ""
_2W4Qr.InRangeName = ""
_xsr = Wherigo.Zone(_3Nho1)
_xsr.Id = "aef1780b-3ccb-4939-b44c-0a323b915a7d"
_xsr.Name = _Hk9("\115\059\035\089\065\106\125\057\085\094\085\089\059\124")
_xsr.Description = ""
_xsr.Visible = true
_xsr.Media = _I_Il
_xsr.Icon = _hTfw
_xsr.Commands = {}
_xsr.DistanceRange = Distance(-1, "feet")
_xsr.ShowObjects = "OnProximity"
_xsr.ProximityRange = Distance(8, "meters")
_xsr.AllowSetPositionTo = false
_xsr.Active = false
_xsr.Points = {
	ZonePoint(37.3841681913819, -89.6685438583725, 0), 
	ZonePoint(37.3842674055066, -89.6685289380494, 0), 
	ZonePoint(37.3842539195393, -89.6683998428161, 0), 
	ZonePoint(37.3841535061508, -89.6684136306451, 0)
}
_xsr.OriginalPoint = ZonePoint(37.3842107556447, -89.6684715674708, 0)
_xsr.DistanceRangeUOM = "Feet"
_xsr.ProximityRangeUOM = "Meters"
_xsr.OutOfRangeName = ""
_xsr.InRangeName = ""
_elRnB = Wherigo.Zone(_3Nho1)
_elRnB.Id = "ddea06c8-2018-4f93-b0ff-fee1fd0d076a"
_elRnB.Name = _Hk9("\097\059\006\052\085\071\059\006\112\106\125\109\059\006\124\085\094\089\124")
_elRnB.Description = ""
_elRnB.Visible = true
_elRnB.Media = _Aphu
_elRnB.Icon = _KP8Y5
_elRnB.Commands = {}
_elRnB.DistanceRange = Distance(-1, "feet")
_elRnB.ShowObjects = "OnProximity"
_elRnB.ProximityRange = Distance(8, "meters")
_elRnB.AllowSetPositionTo = false
_elRnB.Active = false
_elRnB.Points = {
	ZonePoint(37.3826577488001, -89.6677485917391, 0), 
	ZonePoint(37.3827641662553, -89.6677321821646, 0), 
	ZonePoint(37.3827527260422, -89.6675738596712, 0), 
	ZonePoint(37.3826459938133, -89.667585208771, 0)
}
_elRnB.OriginalPoint = ZonePoint(37.3827051587277, -89.6676599605865, 0)
_elRnB.DistanceRangeUOM = "Feet"
_elRnB.ProximityRangeUOM = "Meters"
_elRnB.OutOfRangeName = ""
_elRnB.InRangeName = ""
_XWpy6 = Wherigo.Zone(_3Nho1)
_XWpy6.Id = "45b3a5cf-586b-4802-b99c-a8f0e58783af"
_XWpy6.Name = _Hk9("\033\006\112\089\124\106\112\112\125\062\089\112\085\052\089\065\085")
_XWpy6.Description = ""
_XWpy6.Visible = true
_XWpy6.Media = _6cIY
_XWpy6.Icon = _H3Ew
_XWpy6.Commands = {}
_XWpy6.DistanceRange = Distance(-1, "feet")
_XWpy6.ShowObjects = "OnProximity"
_XWpy6.ProximityRange = Distance(9, "meters")
_XWpy6.AllowSetPositionTo = false
_XWpy6.Active = false
_XWpy6.Points = {
	ZonePoint(37.3819995743028, -89.6678687455155, 0), 
	ZonePoint(37.3819829402929, -89.6677147162209, 0), 
	ZonePoint(37.3820955117369, -89.6676957900597, 0), 
	ZonePoint(37.3821152328037, -89.6678483441394, 0)
}
_XWpy6.OriginalPoint = ZonePoint(37.3820483147841, -89.6677818989839, 0)
_XWpy6.DistanceRangeUOM = "Feet"
_XWpy6.ProximityRangeUOM = "Meters"
_XWpy6.OutOfRangeName = ""
_XWpy6.InRangeName = ""
_yp1 = Wherigo.Zone(_3Nho1)
_yp1.Id = "f66faa86-d53a-4bc1-86f1-91c27b7d25fd"
_yp1.Name = _Hk9("\097\106\067\106\085\106\052\007")
_yp1.Description = ""
_yp1.Visible = true
_yp1.Media = _ep9P
_yp1.Icon = _tpg
_yp1.Commands = {}
_yp1.DistanceRange = Distance(-1, "feet")
_yp1.ShowObjects = "OnProximity"
_yp1.ProximityRange = Distance(8, "meters")
_yp1.AllowSetPositionTo = false
_yp1.Active = false
_yp1.Points = {
	ZonePoint(37.3795535082121, -89.6688958285173, 0), 
	ZonePoint(37.3795450459772, -89.6687388180373, 0), 
	ZonePoint(37.3796586123133, -89.668731361057, 0), 
	ZonePoint(37.3796695837718, -89.6688816137865, 0)
}
_yp1.OriginalPoint = ZonePoint(37.3796066875686, -89.6688119053495, 0)
_yp1.DistanceRangeUOM = "Feet"
_yp1.ProximityRangeUOM = "Meters"
_yp1.OutOfRangeName = ""
_yp1.InRangeName = ""
_6dp5L = Wherigo.Zone(_3Nho1)
_6dp5L.Id = "4874f845-c734-45ce-9acd-b24e6525d0be"
_6dp5L.Name = _Hk9("\122\071\106\125\096\089\112\112\089\124\017\125\018\052\085\089\083\094\065\085\112")
_6dp5L.Description = ""
_6dp5L.Visible = true
_6dp5L.Media = _E58w
_6dp5L.Icon = _ajz17
_6dp5L.Commands = {}
_6dp5L.DistanceRange = Distance(-1, "feet")
_6dp5L.ShowObjects = "OnProximity"
_6dp5L.ProximityRange = Distance(8, "meters")
_6dp5L.AllowSetPositionTo = false
_6dp5L.Active = false
_6dp5L.Points = {
	ZonePoint(37.3695412715596, -89.671184033691, 0), 
	ZonePoint(37.3694586175747, -89.6710452592884, 0), 
	ZonePoint(37.3695662861017, -89.6709162853665, 0), 
	ZonePoint(37.3696373128259, -89.6710573132474, 0)
}
_6dp5L.OriginalPoint = ZonePoint(37.3695508720155, -89.6710507228983, 0)
_6dp5L.DistanceRangeUOM = "Feet"
_6dp5L.ProximityRangeUOM = "Meters"
_6dp5L.OutOfRangeName = ""
_6dp5L.InRangeName = ""
_T52 = Wherigo.Zone(_3Nho1)
_T52.Id = "b58951ce-d0ee-4982-960c-aac3dabb4306"
_T52.Name = _Hk9("\105\052\094\112\112\007\125\018\052\106\094")
_T52.Description = ""
_T52.Visible = true
_T52.Media = _hGLkU
_T52.Icon = _SKKY1
_T52.Commands = {}
_T52.DistanceRange = Distance(-1, "feet")
_T52.ShowObjects = "OnProximity"
_T52.ProximityRange = Distance(8, "meters")
_T52.AllowSetPositionTo = false
_T52.Active = false
_T52.Points = {
	ZonePoint(37.3833057114415, -89.6673777947876, 0), 
	ZonePoint(37.3832862104041, -89.6671797136519, 0), 
	ZonePoint(37.3834196272362, -89.6671563784334, 0), 
	ZonePoint(37.3834379560476, -89.6673494974825, 0)
}
_T52.OriginalPoint = ZonePoint(37.3833623762823, -89.6672658460889, 0)
_T52.DistanceRangeUOM = "Feet"
_T52.ProximityRangeUOM = "Meters"
_T52.OutOfRangeName = ""
_T52.InRangeName = ""

-- Characters --
_SiIHi = Wherigo.ZCharacter{
	Cartridge = _3Nho1, 
	Container = _4N_ia
}
_SiIHi.Id = "c24c1041-c735-4fff-8ad4-40ea07ebb019"
_SiIHi.Name = _Hk9("\062\052\011\125\053\106\089\124\052\089\065\071")
_SiIHi.Description = ""
_SiIHi.Visible = true
_SiIHi.Media = _feS8k
_SiIHi.Icon = _QJu
_SiIHi.Commands = {
	_Zdgic = Wherigo.ZCommand{
		Text = _Hk9("\122\094\035\058"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_z71o = Wherigo.ZCommand{
		Text = _Hk9("\122\094\035\058"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_N6PyN = Wherigo.ZCommand{
		Text = _Hk9("\014\106\085\006\052\124\125\085\071\106\125\097\035\006\106\112"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_rhtcy = Wherigo.ZCommand{
		Text = _Hk9("\122\094\035\058"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_cDY = Wherigo.ZCommand{
		Text = _Hk9("\122\094\035\058"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_NpPn = Wherigo.ZCommand{
		Text = _Hk9("\122\094\035\058"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_SiIHi.Commands._Zdgic.Custom = true
_SiIHi.Commands._Zdgic.Id = "7f3d64cb-c88c-4413-a206-bc29658740c1"
_SiIHi.Commands._Zdgic.WorksWithAll = true
_SiIHi.Commands._z71o.Custom = true
_SiIHi.Commands._z71o.Id = "de774268-3203-4c68-9f12-3f8680753165"
_SiIHi.Commands._z71o.WorksWithAll = true
_SiIHi.Commands._N6PyN.Custom = true
_SiIHi.Commands._N6PyN.Id = "1af81172-91e3-4771-8188-ea8673491b45"
_SiIHi.Commands._N6PyN.WorksWithAll = true
_SiIHi.Commands._rhtcy.Custom = true
_SiIHi.Commands._rhtcy.Id = "579ace2d-3901-4e76-a06d-c2a70a858492"
_SiIHi.Commands._rhtcy.WorksWithAll = true
_SiIHi.Commands._cDY.Custom = true
_SiIHi.Commands._cDY.Id = "e901db5a-f578-4e69-bb3c-ffa9c8d4b7b6"
_SiIHi.Commands._cDY.WorksWithAll = true
_SiIHi.Commands._NpPn.Custom = true
_SiIHi.Commands._NpPn.Id = "0f7bf0d9-6964-4c76-8a04-91ef2c13eb70"
_SiIHi.Commands._NpPn.WorksWithAll = true
_SiIHi.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_SiIHi.Gender = "Male"
_SiIHi.Type = "NPC"
_qjxuj = Wherigo.ZCharacter{
	Cartridge = _3Nho1, 
	Container = _xsr
}
_qjxuj.Id = "7575d054-f686-426a-a3a2-b8a229fb2f9f"
_qjxuj.Name = _Hk9("\062\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106")
_qjxuj.Description = ""
_qjxuj.Visible = true
_qjxuj.Media = _Cb3
_qjxuj.Icon = _SuNy
_qjxuj.Commands = {
	_9wPud = Wherigo.ZCommand{
		Text = _Hk9("\122\094\035\058"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_jg0m = Wherigo.ZCommand{
		Text = _Hk9("\122\094\035\058"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_qjxuj.Commands._9wPud.Custom = true
_qjxuj.Commands._9wPud.Id = "f46673df-9bee-4fe2-9563-abb40c9e4e56"
_qjxuj.Commands._9wPud.WorksWithAll = true
_qjxuj.Commands._jg0m.Custom = true
_qjxuj.Commands._jg0m.Id = "8a09d9b1-0d51-4428-bfde-df1c0cab8ee0"
_qjxuj.Commands._jg0m.WorksWithAll = true
_qjxuj.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_qjxuj.Gender = "Male"
_qjxuj.Type = "NPC"
_errz = Wherigo.ZCharacter{
	Cartridge = _3Nho1, 
	Container = _2W4Qr
}
_errz.Id = "59444279-288b-4033-910c-40c0215e571d"
_errz.Name = _Hk9("\046\007\106\125\072\089\085\124\106\112\112")
_errz.Description = _Hk9("\018\124\125\106\007\106\125\110\089\085\124\106\112\112\125\110\071\059\125\094\019\019\106\094\052\112\125\085\059\125\066\106\125\089\124\125\094\125\019\094\124\089\065\011")
_errz.Visible = true
_errz.Media = _mERx3
_errz.Icon = _Wf0
_errz.Commands = {
	_SAVdQ = Wherigo.ZCommand{
		Text = _Hk9("\122\094\035\058"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_errz.Commands._SAVdQ.Custom = true
_errz.Commands._SAVdQ.Id = "6a25d0ec-6285-4384-80e8-d2819be22c5d"
_errz.Commands._SAVdQ.WorksWithAll = true
_errz.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_errz.Gender = "Male"
_errz.Type = "NPC"
_lWQ = Wherigo.ZCharacter(_3Nho1)
_lWQ.Id = "5522b4f7-c65e-43a9-9300-d52259f36311"
_lWQ.Name = _Hk9("\122\071\106\125\096\006\067\067\007")
_lWQ.Description = ""
_lWQ.Visible = true
_lWQ.Media = _6Y9
_lWQ.Icon = _tGn
_lWQ.Commands = {}
_lWQ.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_lWQ.Gender = "Male"
_lWQ.Type = "NPC"

-- Items --
_akw = Wherigo.ZItem(_3Nho1)
_akw.Id = "40ecbfbc-bda3-48b9-adf7-7637bf4a9268"
_akw.Name = _Hk9("\057\094\052\065\059\019\071\094\017\006\112")
_akw.Description = ""
_akw.Visible = true
_akw.Media = _uUW
_akw.Icon = _klkr
_akw.Commands = {
	_rdEku = Wherigo.ZCommand{
		Text = _Hk9("\046\111\094\067\089\124\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_PTv74 = Wherigo.ZCommand{
		Text = _Hk9("\046\111\094\067\089\124\106\125\018\017\094\089\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_Zlml = Wherigo.ZCommand{
		Text = _Hk9("\102\124\059\065\058\125\059\124\125\057\094\052\065\059\019\071\094\017\006\112"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_8tBC = Wherigo.ZCommand{
		Text = _Hk9("\051\106\094\016\106\125\057\094\052\065\059\019\071\094\017\006\112"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_akw.Commands._rdEku.Custom = true
_akw.Commands._rdEku.Id = "d9cd50b3-c560-426b-aeb2-012340ad350e"
_akw.Commands._rdEku.WorksWithAll = true
_akw.Commands._PTv74.Custom = true
_akw.Commands._PTv74.Id = "43ad774e-731f-4016-a82c-3c342e3cb9f2"
_akw.Commands._PTv74.WorksWithAll = true
_akw.Commands._Zlml.Custom = true
_akw.Commands._Zlml.Id = "769aa51a-7ab0-4201-878c-a7fbcda01872"
_akw.Commands._Zlml.WorksWithAll = true
_akw.Commands._8tBC.Custom = true
_akw.Commands._8tBC.Id = "2ff51ed7-40cc-423e-8d16-ec1daa1bf70d"
_akw.Commands._8tBC.WorksWithAll = true
_akw.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_akw.Locked = false
_akw.Opened = false
_KfbSl = Wherigo.ZItem(_3Nho1)
_KfbSl.Id = "2dbd9bfa-aa17-4662-97d5-c69687f35e22"
_KfbSl.Name = _Hk9("\033\094\124\108\094\017\106\112")
_KfbSl.Description = _Hk9("\057\059\067\106\125\066\094\124\108\094\017\106\112\125\085\071\094\085\125\007\059\006\125\083\059\006\124\108\125\035\094\007\089\124\017\125\124\106\094\052\125\085\071\106\125\083\059\006\124\085\094\089\124\011")
_KfbSl.Visible = true
_KfbSl.Media = _71A
_KfbSl.Icon = _z7bIL
_KfbSl.Commands = {}
_KfbSl.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_KfbSl.Locked = false
_KfbSl.Opened = false
_O4x_U = Wherigo.ZItem(_3Nho1)
_O4x_U.Id = "dce417d4-3f5b-4ee3-aab0-7824c535dcb6"
_O4x_U.Name = _Hk9("\115\035\094\007\106\052\125\097\059\067\019\035\106\085\089\059\124\125\097\059\108\106")
_O4x_U.Description = ""
_O4x_U.Visible = true
_O4x_U.Media = _drxTX
_O4x_U.Commands = {}
_O4x_U.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_O4x_U.Locked = false
_O4x_U.Opened = false
_6xL = Wherigo.ZItem{
	Cartridge = _3Nho1, 
	Container = _XWpy6
}
_6xL.Id = "32bdb90a-202a-4bb6-8ee8-467d16663a54"
_6xL.Name = _Hk9("\097\052\094\065\058\106\108\125\072\089\124\108\059\110")
_6xL.Description = ""
_6xL.Visible = true
_6xL.Media = _XTIp
_6xL.Icon = _CfmI
_6xL.Commands = {
	_8Ok = Wherigo.ZCommand{
		Text = _Hk9("\046\111\094\067\089\124\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_6xL.Commands._8Ok.Custom = true
_6xL.Commands._8Ok.Id = "704c6dd8-611e-49a1-87a5-4aabc25751a3"
_6xL.Commands._8Ok.WorksWithAll = true
_6xL.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_6xL.Locked = false
_6xL.Opened = false
_fZksA = Wherigo.ZItem(_3Nho1)
_fZksA.Id = "6237f315-d372-4f67-9914-becec388b218"
_fZksA.Name = _Hk9("\046\016\089\108\106\124\065\106\125\033\059\111")
_fZksA.Description = _Hk9("\109\089\035\035\106\108\125\110\089\085\071\125\106\016\089\108\106\124\065\106\125\085\071\094\085\125\007\059\006\125\083\059\006\124\108\125\094\085\125\085\071\106\125\065\052\089\067\106\125\112\065\106\124\106\112\011")
_fZksA.Visible = true
_fZksA.Media = _tiB
_fZksA.Icon = _Z68r
_fZksA.Commands = {}
_fZksA.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_fZksA.Locked = false
_fZksA.Opened = false
_KEY = Wherigo.ZItem(_3Nho1)
_KEY.Id = "01069a78-d135-4a16-970f-f98e0e1fed57"
_KEY.Name = _Hk9("\109\059\006\124\085\094\089\124")
_KEY.Description = ""
_KEY.Visible = true
_KEY.Media = _Aphu
_KEY.Commands = {
	_27s = Wherigo.ZCommand{
		Text = _Hk9("\046\111\094\067\089\124\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_KEY.Commands._27s.Custom = true
_KEY.Commands._27s.Id = "cb430acb-2333-42b1-97de-669b96d0be2e"
_KEY.Commands._27s.WorksWithAll = true
_KEY.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_KEY.Locked = false
_KEY.Opened = false
_Dyj = Wherigo.ZItem(_3Nho1)
_Dyj.Id = "45251dd1-b2b1-4944-8cb8-637c61765a21"
_Dyj.Name = _Hk9("\046\017\007\019\085\089\094\124\125\033\059\059\058\125\059\083\125\085\071\106\125\062\106\094\108")
_Dyj.Description = ""
_Dyj.Visible = true
_Dyj.Media = _yxLx3
_Dyj.Icon = _C39xx
_Dyj.Commands = {
	_KXeC = Wherigo.ZCommand{
		Text = _Hk9("\014\106\094\108"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_Dyj.Commands._KXeC.Custom = true
_Dyj.Commands._KXeC.Id = "97dcb495-f171-41a5-ac47-146a7b8e1b27"
_Dyj.Commands._KXeC.WorksWithAll = true
_Dyj.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Dyj.Locked = false
_Dyj.Opened = false
_5OLq = Wherigo.ZItem(_3Nho1)
_5OLq.Id = "db6043c5-ffd7-4e95-a5f4-00d6ec550d7d"
_5OLq.Name = _Hk9("\057\071\059\085\017\006\124")
_5OLq.Description = ""
_5OLq.Visible = true
_5OLq.Media = _a30x0
_5OLq.Icon = _1G2G4
_5OLq.Commands = {
	_Lq_Qr = Wherigo.ZCommand{
		Text = _Hk9("\109\089\052\106\125\105\006\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_3W6T = Wherigo.ZCommand{
		Text = _Hk9("\109\089\052\106\125\105\006\124\125\094\085\125\096\006\067\067\007"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_ltk = Wherigo.ZCommand{
		Text = _Hk9("\014\106\035\059\094\108"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_5OLq.Commands._Lq_Qr.Custom = true
_5OLq.Commands._Lq_Qr.Id = "f958718e-fc95-4fa4-a6b1-4a73780af108"
_5OLq.Commands._Lq_Qr.WorksWithAll = true
_5OLq.Commands._3W6T.Custom = true
_5OLq.Commands._3W6T.Id = "a385b8df-957d-4a87-b24f-969f3800d62e"
_5OLq.Commands._3W6T.WorksWithAll = true
_5OLq.Commands._ltk.Custom = true
_5OLq.Commands._ltk.Id = "7d4272e2-4220-4aba-ad0e-19da92f8ad2c"
_5OLq.Commands._ltk.WorksWithAll = true
_5OLq.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_5OLq.Locked = false
_5OLq.Opened = false
_siY = Wherigo.ZItem(_3Nho1)
_siY.Id = "514c57eb-dd1f-4884-993b-980b51831680"
_siY.Name = _Hk9("\105\006\124\125\097\094\112\106")
_siY.Description = ""
_siY.Visible = true
_siY.Media = __2lH
_siY.Icon = _81v
_siY.Commands = {
	_K5m0v = Wherigo.ZCommand{
		Text = _Hk9("\046\111\094\067\089\124\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_x5N = Wherigo.ZCommand{
		Text = _Hk9("\122\094\058\106\125\105\006\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_siY.Commands._K5m0v.Custom = true
_siY.Commands._K5m0v.Id = "5de996ca-67dd-44bc-b265-eae141382ccc"
_siY.Commands._K5m0v.WorksWithAll = true
_siY.Commands._x5N.Custom = true
_siY.Commands._x5N.Id = "90bf3888-f8f3-488b-b42f-85578402d810"
_siY.Commands._x5N.WorksWithAll = true
_siY.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_siY.Locked = false
_siY.Opened = false
_rP1 = Wherigo.ZItem(_3Nho1)
_rP1.Id = "64400859-64ef-4c9e-8d3d-b0761e0ec8a1"
_rP1.Name = _Hk9("\057\071\106\035\035\112")
_rP1.Description = ""
_rP1.Visible = true
_rP1.Media = _mw4KC
_rP1.Icon = _h937
_rP1.Commands = {
	_U5Hfk = Wherigo.ZCommand{
		Text = _Hk9("\014\106\035\059\094\108"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_rP1.Commands._U5Hfk.Custom = true
_rP1.Commands._U5Hfk.Id = "2115f282-363b-4e61-9377-8d20d5258cef"
_rP1.Commands._U5Hfk.WorksWithAll = true
_rP1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_rP1.Locked = false
_rP1.Opened = false
_ZDSD = Wherigo.ZItem{
	Cartridge = _3Nho1, 
	Container = _T52
}
_ZDSD.Id = "9f4d790d-249a-4f12-80e7-5dc8dbd7a0b9"
_ZDSD.Name = _Hk9("\018\124\058\071\125\122\094\035\089\112\067\094\124")
_ZDSD.Description = ""
_ZDSD.Visible = true
_ZDSD.Media = _BnyC
_ZDSD.Icon = _YK9J
_ZDSD.Commands = {
	_vzD6 = Wherigo.ZCommand{
		Text = _Hk9("\115\089\065\058\125\070\019"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_rV1Q = Wherigo.ZCommand{
		Text = _Hk9("\070\112\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_7ysPN = Wherigo.ZCommand{
		Text = _Hk9("\070\112\106\125\059\124\125\096\006\067\067\007"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_ZDSD.Commands._vzD6.Custom = true
_ZDSD.Commands._vzD6.Id = "85ffd9ae-6d9a-455b-b901-e6e113f29811"
_ZDSD.Commands._vzD6.WorksWithAll = true
_ZDSD.Commands._rV1Q.Custom = true
_ZDSD.Commands._rV1Q.Id = "73af17f1-ab65-4fb4-b265-c6c823464f44"
_ZDSD.Commands._rV1Q.WorksWithAll = true
_ZDSD.Commands._7ysPN.Custom = true
_ZDSD.Commands._7ysPN.Id = "59d71b0f-c956-44e2-b012-35602a53fbec"
_ZDSD.Commands._7ysPN.WorksWithAll = true
_ZDSD.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_ZDSD.Locked = false
_ZDSD.Opened = false
_KoHOe = Wherigo.ZItem(_3Nho1)
_KoHOe.Id = "d95d48b1-f8d3-49a4-bab9-f16216f5ce32"
_KoHOe.Name = _Hk9("\096\094\019")
_KoHOe.Description = _Hk9("\122\071\106\125\067\089\112\112\089\124\017\125\094\052\085\089\083\094\065\085\112\125\094\052\106\125\035\059\065\094\085\106\108\125\094\085\125\055\125\060\091\125\039\039\011\050\091\060\125\072\125\049\028\048\125\118\049\011\039\107\039\011")
_KoHOe.Visible = true
_KoHOe.Media = _vvk
_KoHOe.Icon = _hQa3
_KoHOe.Commands = {}
_KoHOe.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_KoHOe.Locked = false
_KoHOe.Opened = false
_BJqI = Wherigo.ZItem(_3Nho1)
_BJqI.Id = "aafb78a1-dc3a-45a7-96c8-58c9832e77da"
_BJqI.Name = _Hk9("\065\071\106\094\085")
_BJqI.Description = ""
_BJqI.Visible = true
_BJqI.Commands = {
	_0jg = Wherigo.ZCommand{
		Text = _Hk9("\065\071\106\094\085"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_BJqI.Commands._0jg.Custom = true
_BJqI.Commands._0jg.Id = "24f7e828-0b6a-49a5-ba62-cb41770ffe9f"
_BJqI.Commands._0jg.WorksWithAll = true
_BJqI.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_BJqI.Locked = false
_BJqI.Opened = false
_mTI = Wherigo.ZItem{
	Cartridge = _3Nho1, 
	Container = Player
}
_mTI.Id = "255d8a30-b253-45be-8cf2-2bdecb985d58"
_mTI.Name = _Hk9("\055\059\085\106\019\094\108")
_mTI.Description = _Hk9("\018\125\124\059\085\106\019\094\108\125\083\059\052\125\085\094\058\089\124\017\125\124\059\085\106\112\011")
_mTI.Visible = true
_mTI.Media = _kgJ
_mTI.Icon = _aeMj
_mTI.Commands = {
	_O60p0 = Wherigo.ZCommand{
		Text = _Hk9("\046\111\094\067\089\124\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}, 
	_ZkcZ = Wherigo.ZCommand{
		Text = _Hk9("\072\052\089\085\106\125\055\059\085\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Hk9("\055\059\085\071\089\124\017\125\094\016\094\089\035\094\066\035\106")
	}
}
_mTI.Commands._O60p0.Custom = true
_mTI.Commands._O60p0.Id = "c06c63cd-93e7-476c-8bdc-3ea72c7149ca"
_mTI.Commands._O60p0.WorksWithAll = true
_mTI.Commands._ZkcZ.Custom = true
_mTI.Commands._ZkcZ.Id = "0f5be6d5-a208-4f23-b6fd-63c2f33a693c"
_mTI.Commands._ZkcZ.WorksWithAll = true
_mTI.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_mTI.Locked = false
_mTI.Opened = false

-- Tasks --
_pBIW = Wherigo.ZTask(_3Nho1)
_pBIW.Id = "c9cdfa3f-2171-44dc-8670-4f67f6e25056"
_pBIW.Name = _Hk9("\122\094\035\058\125\085\059\125\062\052\011\125\053\106\089\124\052\089\065\071")
_pBIW.Description = _Hk9("\057\059\067\106\085\071\089\124\017\125\071\094\112\125\071\094\019\019\106\124\106\108\125\085\059\125\062\052\011\125\053\106\089\124\052\089\065\071\005\112\125\106\111\071\089\066\089\085\011\125\053\106\094\108\125\085\059\125\085\071\106\125\094\052\065\071\089\016\106\112\125\085\059\125\083\089\124\108\125\059\006\085\125\110\071\094\085\125\071\094\019\019\106\124\106\108\011")
_pBIW.Visible = true
_pBIW.Media = _iwj
_pBIW.Icon = _AYzzi
_pBIW.Active = false
_pBIW.Complete = false
_pBIW.CorrectState = "None"
_pk1 = Wherigo.ZTask(_3Nho1)
_pk1.Id = "1ed6fd0d-3fde-445e-a2da-ef8db0cf8085"
_pk1.Name = _Hk9("\123\124\016\106\112\085\089\017\094\085\106\125\085\071\106\125\065\035\006\106\112")
_pk1.Description = _Hk9("\105\059\125\085\059\125\085\071\106\125\035\059\065\094\085\089\059\124\112\125\085\071\094\085\125\062\052\011\125\053\106\089\124\052\089\065\071\125\071\094\112\125\067\094\052\058\106\108\125\059\124\125\007\059\006\052\125\067\094\019\011\125\064\059\006\125\110\089\035\035\125\124\106\106\108\125\085\059\125\106\111\094\067\089\124\106\125\094\125\019\035\094\117\006\106\043\125\089\124\085\106\052\016\089\106\110\125\094\124\125\106\007\106\110\089\085\124\106\112\112\125\094\124\108\125\089\124\016\106\112\085\089\017\094\085\106\125\094\125\065\052\089\067\106\125\112\065\106\124\106\011")
_pk1.Visible = true
_pk1.Media = _iwj
_pk1.Icon = _AYzzi
_pk1.Active = false
_pk1.Complete = false
_pk1.CorrectState = "None"
_506P = Wherigo.ZTask(_3Nho1)
_506P.Id = "3e15c0c9-1bfd-41ac-b2f9-0162c187bbed"
_506P.Name = _Hk9("\109\089\124\108\125\085\071\106\125\096\089\112\112\089\124\017\125\018\124\058\071\125\122\094\035\089\112\067\094\124")
_506P.Description = _Hk9("\122\071\106\125\018\124\058\071\125\112\007\067\066\059\035\125\110\071\089\065\071\125\110\094\112\125\059\124\125\085\059\019\125\059\083\125\085\071\106\125\112\094\052\065\059\019\071\059\017\006\112\125\089\112\125\067\089\112\112\089\124\017\011\125\109\089\124\108\125\059\006\085\125\110\071\094\085\125\071\094\019\019\106\124\106\108\125\085\059\125\089\085\011")
_506P.Visible = true
_506P.Media = _iwj
_506P.Icon = _AYzzi
_506P.Active = false
_506P.Complete = false
_506P.CorrectState = "None"
_eXRJK = Wherigo.ZTask(_3Nho1)
_eXRJK.Id = "9a645791-4c6a-4570-8dd0-61ca43773292"
_eXRJK.Name = _Hk9("\123\124\016\106\112\085\089\017\094\085\106\125\085\071\106\125\057\094\052\065\059\019\071\094\017\006\112")
_eXRJK.Description = _Hk9("\097\035\059\112\106\035\007\125\106\111\094\067\089\124\106\125\085\071\106\125\106\067\019\085\007\125\112\094\052\065\059\019\071\094\017\006\112\125\089\124\125\085\071\106\125\029\089\085\106\067\112\029\125\067\106\124\006\125\083\059\052\125\094\124\007\125\106\111\085\052\094\125\065\035\006\106\112\011")
_eXRJK.Visible = true
_eXRJK.Media = _iwj
_eXRJK.Icon = _AYzzi
_eXRJK.Active = false
_eXRJK.Complete = false
_eXRJK.CorrectState = "None"
_QUP0_ = Wherigo.ZTask(_3Nho1)
_QUP0_.Id = "5ef72341-aaa7-4a92-94eb-e694c5816d0f"
_QUP0_.Name = _Hk9("\122\094\058\106\125\108\059\110\124\125\085\071\106\125\096\006\067\067\007")
_QUP0_.Description = _Hk9("\122\071\106\125\067\006\067\067\007\125\071\094\112\125\094\019\019\106\094\052\106\108\125\089\124\125\085\071\106\125\065\106\067\106\085\106\052\007\011\125\064\059\006\125\110\089\035\035\125\124\106\106\108\125\085\059\125\083\089\124\108\125\094\125\110\094\007\125\085\059\125\085\094\058\106\125\071\089\067\125\108\059\110\124\011\125\057\019\106\094\058\125\085\059\125\062\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106\125\059\052\125\062\052\011\125\053\106\089\124\052\089\065\071\125\083\059\052\125\112\059\067\106\125\089\108\106\094\112\125\059\124\125\071\059\110\125\085\059\125\085\094\058\106\125\071\089\067\125\108\059\110\124\011")
_QUP0_.Visible = true
_QUP0_.Media = _iwj
_QUP0_.Icon = _AYzzi
_QUP0_.Active = false
_QUP0_.Complete = false
_QUP0_.CorrectState = "None"
_0Jiq = Wherigo.ZTask(_3Nho1)
_0Jiq.Id = "b23e6eae-0cca-4b93-9f40-1ba152065851"
_0Jiq.Name = _Hk9("\109\089\124\108\125\085\071\106\125\096\089\112\112\089\124\017\125\018\052\085\089\083\094\065\085\112")
_0Jiq.Description = _Hk9("\123\085\125\089\112\125\052\006\067\059\052\106\108\125\085\071\094\085\125\085\071\106\125\067\006\067\067\007\125\071\094\108\125\094\125\065\059\035\035\106\065\085\089\059\124\125\059\083\125\052\094\052\106\125\094\052\085\089\083\094\065\085\112\011\125\109\089\124\108\125\085\071\106\125\067\089\112\112\089\124\017\125\094\052\085\089\083\094\065\085\112\011\125")
_0Jiq.Visible = true
_0Jiq.Media = _iwj
_0Jiq.Icon = _AYzzi
_0Jiq.Active = false
_0Jiq.Complete = false
_0Jiq.CorrectState = "None"

-- Cartridge Variables --
_yVV = ""
_WAx = ""
_3b5ng = ""
__uz5U = ""
_LDf = 0
_FWKXN = ""
_MSf = ""
_Kk5I = 0
_wtR = 3
_RWHIt = 6
_rJPzi = 8
_7P6Y_ = ""
_LoLAm = _Hk9("\042\118\055\042\089\094")
_Fg1 = _Hk9("\042\057\089\123\053\089")
_3LxZ = _Hk9("\042\094\058\110")
_Vye0o = _Hk9("\042\019\033\123\072")
_XwR = _Hk9("\042\085\048\091\040\109")
_VtGSC = _Hk9("\042\052\102\080")
_3Nho1.ZVariables = {
	_yVV = "", 
	_WAx = "", 
	_3b5ng = "", 
	__uz5U = "", 
	_LDf = 0, 
	_FWKXN = "", 
	_MSf = "", 
	_Kk5I = 0, 
	_wtR = 3, 
	_RWHIt = 6, 
	_rJPzi = 8, 
	_7P6Y_ = "", 
	_LoLAm = _Hk9("\042\118\055\042\089\094"), 
	_Fg1 = _Hk9("\042\057\089\123\053\089"), 
	_3LxZ = _Hk9("\042\094\058\110"), 
	_Vye0o = _Hk9("\042\019\033\123\072"), 
	_XwR = _Hk9("\042\085\048\091\040\109"), 
	_VtGSC = _Hk9("\042\052\102\080")
}

-- Timers --
_rKz = Wherigo.ZTimer(_3Nho1)
_rKz.Id = "46733b72-ed0f-44f0-be64-0cc87f72dfa8"
_rKz.Name = _Hk9("\018\124\058\071\125\122\089\067\106\052")
_rKz.Description = ""
_rKz.Visible = true
_rKz.Duration = 3
_rKz.Type = "Countdown"
_mk2 = Wherigo.ZTimer(_3Nho1)
_mk2.Id = "c5d7332c-c44f-42ad-9c59-2e30ed867f8c"
_mk2.Name = _Hk9("\096\006\067\067\007\125\072\094\035\058\089\124\017")
_mk2.Description = ""
_mk2.Visible = true
_mk2.Duration = 8
_mk2.Type = "Countdown"
_ebuWk = Wherigo.ZTimer(_3Nho1)
_ebuWk.Id = "5c4d1893-c484-4aef-b05a-e1979e915668"
_ebuWk.Name = _Hk9("\096\006\067\067\007\125\018\085\085\094\065\058")
_ebuWk.Description = ""
_ebuWk.Visible = true
_ebuWk.Duration = 16
_ebuWk.Type = "Countdown"

-- Inputs --
_t97OF = Wherigo.ZInput(_3Nho1)
_t97OF.Id = "5addd28c-df1a-4904-a56d-266538bddfda"
_t97OF.Name = _Hk9("\072\089\035\035\125\007\059\006\125\071\106\035\019\125\067\106\125\089\124\016\106\112\085\089\017\094\085\106\125\067\007\125\067\089\112\112\089\124\017\125\106\111\071\089\066\089\085\012")
_t97OF.Description = ""
_t97OF.Visible = true
_t97OF.Media = _feS8k
_t97OF.Choices = {
	"Yes", 
	"No"
}
_t97OF.InputType = "MultipleChoice"
_t97OF.Text = _Hk9("\072\089\035\035\125\007\059\006\125\071\106\035\019\125\067\106\125\089\124\016\106\112\085\089\017\094\085\106\125\067\007\125\067\089\112\112\089\124\017\125\106\111\071\089\066\089\085\012")
_2ZW = Wherigo.ZInput(_3Nho1)
_2ZW.Id = "f6ad2592-eb48-469d-abfe-05be589c0a4c"
_2ZW.Name = _Hk9("\109\059\006\124\085\094\089\124\125\115\035\094\117\006\106")
_2ZW.Description = ""
_2ZW.Visible = true
_2ZW.Media = _Aphu
_2ZW.InputType = "Text"
_2ZW.Text = _Hk9("\064\059\006\125\112\106\106\125\112\065\052\094\085\065\071\125\067\094\052\058\112\125\124\106\094\052\125\085\071\106\125\110\059\052\108\125\089\124\125\085\071\106\125\065\106\124\085\106\052\125\059\083\125\085\071\106\125\019\035\094\117\006\106\011\125\072\071\094\085\125\089\112\125\085\071\089\112\125\110\059\052\108\012")
_Y45C = Wherigo.ZInput(_3Nho1)
_Y45C.Id = "b40c9e69-97a9-43b9-a016-91fdca1371bd"
_Y45C.Name = _Hk9("\067\089\112\112\089\124\017\125\094\052\085\089\083\094\065\085\112\125\123\124\019\006\085")
_Y45C.Description = ""
_Y45C.Visible = true
_Y45C.Media = _E58w
_Y45C.Choices = {
	"Yes", 
	"No", 
	"Need Hint"
}
_Y45C.InputType = "MultipleChoice"
_Y45C.Text = _Hk9("\062\089\108\125\007\059\006\125\083\089\124\108\125\085\071\106\125\067\089\112\112\089\124\017\125\094\052\085\089\083\094\065\085\112")
_kJCuB = Wherigo.ZInput(_3Nho1)
_kJCuB.Id = "2da84ff6-cd08-4209-8607-4e1bec00bfd6"
_kJCuB.Name = _Hk9("\123\124\108\089\094\124\125\057\085\094\085\006\106\125\123\124\019\006\085")
_kJCuB.Description = ""
_kJCuB.Visible = true
_kJCuB.Media = _mERx3
_kJCuB.InputType = "Text"
_kJCuB.Text = _Hk9("\072\071\094\085\125\089\112\125\085\071\106\125\083\089\052\112\085\125\108\094\085\106\125\007\059\006\125\112\106\106\125\067\094\052\058\106\108\125\124\106\094\052\125\085\071\106\125\085\059\019\125\059\083\125\085\071\106\125\019\035\094\117\006\106\012")
_s2g = Wherigo.ZInput(_3Nho1)
_s2g.Id = "14f5a4fc-f8a9-4110-a77a-d0b2090dd11f"
_s2g.Name = _Hk9("\105\059\125\110\089\085\071\125\085\071\106\125\108\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106\012")
_s2g.Description = ""
_s2g.Visible = true
_s2g.Media = _Cb3
_s2g.Choices = {
	"Yes", 
	"No"
}
_s2g.InputType = "MultipleChoice"
_s2g.Text = _Hk9("\072\106\125\094\052\106\125\017\059\089\124\017\125\085\059\125\108\052\089\016\106\125\085\059\125\085\071\106\125\065\106\067\106\085\106\052\007\125\124\059\110\125\085\059\125\089\124\016\106\112\085\089\017\094\085\106\011\125\072\089\035\035\125\007\059\006\125\065\059\067\106\125\110\089\085\071\125\006\112\012")
_OgEK = Wherigo.ZInput(_3Nho1)
_OgEK.Id = "d387ecb2-fb3d-48e4-b447-ad1cdf61eb89"
_OgEK.Name = _Hk9("\112\094\052\065\059\019\071\094\017\006\112")
_OgEK.Description = ""
_OgEK.Visible = true
_OgEK.Media = _uUW
_OgEK.Choices = {
	"Examine Again", 
	"Leave"
}
_OgEK.InputType = "MultipleChoice"
_OgEK.Text = ""
_eNG = Wherigo.ZInput(_3Nho1)
_eNG.Id = "ee100bcd-1530-4275-8ef4-100c8754e082"
_eNG.Name = _Hk9("\072\052\089\085\106\125\055\059\085\106")
_eNG.Description = ""
_eNG.Visible = true
_eNG.InputType = "Text"
_eNG.Text = _Hk9("\072\052\089\085\106\125\094\125\124\059\085\106\125\071\106\052\106\119")

-- WorksWithList for object commands --

-- functions --
function _3Nho1:OnStart()
	_LDf = 0
	_SiIHi.Commands._z71o.Enabled = false
	_SiIHi.Commands._N6PyN.Enabled = false
	_5OLq.Commands._3W6T.Enabled = false
	_pBIW.Active = true
	_SiIHi.Commands._NpPn.Enabled = false
	_SiIHi.Commands._cDY.Enabled = false
	_SiIHi.Commands._N6PyN.Enabled = false
	_ZDSD.Commands._7ysPN.Enabled = false
	_ZDSD.Commands._rV1Q.Enabled = false
	_qjxuj.Commands._jg0m.Enabled = false
	_SiIHi.Commands._rhtcy.Enabled = false
	_wtR = 3
	_rP1.Description = (_Hk9("\064\059\006\125\065\006\052\052\106\124\085\035\007\125\071\094\016\106\125").._wtR).._Hk9("\125\066\059\111\106\023\112\047\125\059\083\125\112\071\106\035\035\112\011")
	_Urwigo.MessageBox{
		Text = _Hk9("\122\071\106\125\097\006\052\112\106\125\059\083\125\085\071\106\125\115\071\094\052\094\059\071\119\125\089\124\125\085\071\089\112\125\110\071\106\052\089\017\059\125\007\059\006\125\110\089\035\035\125\124\106\106\108\125\085\059\125\112\059\035\016\106\125\085\071\106\125\067\007\112\085\106\052\007\125\059\083\125\085\071\106\125\019\071\094\052\094\059\071\125\094\124\108\125\071\106\035\019\125\085\071\106\125\019\052\059\083\106\112\112\059\052\125\017\106\085\125\066\094\065\058\125\071\089\112\125\067\089\112\112\089\124\017\125\106\111\071\089\066\089\085\011\125"), 
		Media = _nw6Gm, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _Hk9("\123\083\125\007\059\006\125\017\106\085\125\112\085\006\065\058\125\094\035\059\124\017\125\085\071\106\125\110\094\007\125\065\071\106\065\058\125\085\071\106\125\029\085\094\112\058\112\029\125\067\106\124\006\125\083\059\052\125\071\089\124\085\112\011\125"), 
					Media = _iwj, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\122\071\106\052\106\125\094\052\106\125\094\125\016\094\052\089\106\085\007\125\059\083\125\089\085\106\067\112\043\125\065\071\094\052\094\065\085\106\052\112\125\094\124\108\125\035\059\065\094\085\089\059\124\112\125\085\071\094\085\125\007\059\006\125\110\089\035\035\125\124\106\106\108\125\085\059\125\089\124\085\106\052\094\065\085\125\110\089\085\071\125\094\035\059\124\017\125\085\071\106\125\110\094\007\011\125\096\094\058\106\125\112\006\052\106\125\085\059\125\112\106\094\052\065\071\125\106\094\065\071\125\094\052\106\094\125\085\071\059\052\059\006\017\071\035\007\011"), 
								Media = _t_Ykx, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _Hk9("\115\052\059\065\106\106\108\125\085\059\125\085\071\106\125\094\052\065\071\089\016\106\112\125\066\006\089\035\108\089\124\017\125\124\059\110\125\085\059\125\112\019\106\094\058\125\110\089\085\071\125\062\052\011\125\053\106\089\124\052\089\065\071\011\125\053\106\125\089\112\125\110\094\089\085\089\124\017\125\085\071\106\052\106\125\110\089\085\071\125\094\125\067\089\112\112\089\059\124\125\083\059\052\125\007\059\006\011\125"), 
											Media = _XyK_, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _3Nho1:OnRestore()
end
function _4N_ia:OnExit()
	_LoLAm = _Hk9("\042\118\055\042\089\094")
	if _Kk5I == 1 then
		_T52.Active = true
		_Urwigo.MessageBox{
			Text = _Hk9("\018\112\125\007\059\006\125\035\106\094\016\106\125\085\071\106\125\094\052\065\071\089\016\106\112\125\066\006\089\035\108\089\124\017\125\007\059\006\125\124\059\085\089\065\106\125\112\059\067\106\125\112\065\052\094\019\106\125\067\094\052\058\112\125\059\124\125\085\071\106\125\112\089\108\106\110\094\035\058\125\085\059\125\085\071\106\125\110\106\112\085\011"), 
			Media = _t_Ykx, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _Hk9("\064\059\006\125\112\071\059\006\035\108\125\089\124\016\106\112\085\089\017\094\085\106\125\085\071\106\125\094\052\106\094\011\125\123\085\125\094\019\019\106\094\052\112\125\112\059\067\106\085\071\089\124\017\125\110\094\112\125\108\052\094\017\017\106\108\125\085\071\052\059\006\017\071\125\085\071\106\125\017\052\094\112\112\011"), 
						Media = _t_Ykx
					}
				end
			end
		}
	end
end
function _4N_ia:OnProximity()
	_LoLAm = _Hk9("\042\118\055\042\089\094")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _Hk9("\122\071\089\112\125\089\112\125\085\071\106\125\018\052\065\071\089\016\106\112\125\066\006\089\035\108\089\124\017\125\110\071\106\052\106\125\062\052\011\125\053\106\089\124\052\089\065\071\125\108\059\106\112\125\071\089\112\125\052\106\112\106\094\052\065\071\011\125\057\019\106\094\058\125\085\059\125\071\089\067\125\110\071\106\124\125\007\059\006\125\017\106\085\125\094\125\065\071\094\124\065\106\011"), 
		Media = _XyK_, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _4N_ia:OnSetActive()
	_LoLAm = _Hk9("\042\118\055\042\089\094")
	_Urwigo.GlobalZoneActiveChanged()
end
function _2W4Qr:OnProximity()
	_LoLAm = _Hk9("\042\039\072\118\077\052")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _Hk9("\018\112\125\007\059\006\125\124\106\094\052\125\085\071\106\125\065\071\094\067\066\106\052\125\059\083\125\065\059\067\067\106\052\065\106\125\007\059\006\125\112\106\106\125\094\125\065\052\094\080\106\108\125\106\007\106\110\089\085\124\106\112\112\125\112\085\094\124\108\089\124\017\125\124\106\094\052\066\007\011"), 
		Media = _53Cm, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _2W4Qr:OnSetActive()
	_LoLAm = _Hk9("\042\039\072\118\077\052")
	_Urwigo.GlobalZoneActiveChanged()
end
function _xsr:OnProximity()
	_LoLAm = _Hk9("\042\111\112\052")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _Hk9("\018\112\125\007\059\006\125\106\124\085\106\052\125\085\071\106\125\019\059\035\089\065\106\125\112\085\094\085\089\059\124\125\007\059\006\125\112\106\106\125\112\106\016\106\052\094\035\125\059\083\083\089\065\106\052\112\125\052\006\124\124\089\124\017\125\094\052\059\006\124\108\125\065\052\094\080\089\035\007\011\125\062\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106\005\112\125\059\083\083\089\065\106\125\089\112\125\035\059\065\094\085\106\108\125\089\124\125\085\071\106\125\066\094\065\058\011\125\064\059\006\125\112\071\059\006\035\108\125\112\019\106\094\058\125\085\059\125\071\089\067\011"), 
		Media = _I_Il, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _xsr:OnSetActive()
	_LoLAm = _Hk9("\042\111\112\052")
	_Urwigo.GlobalZoneActiveChanged()
end
function _elRnB:OnProximity()
	_LoLAm = _Hk9("\042\106\035\014\124\033")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _Hk9("\018\112\125\007\059\006\125\124\106\094\052\125\085\071\106\125\083\059\006\124\085\094\089\124\125\007\059\006\125\124\059\085\089\065\106\125\112\065\052\094\085\065\071\125\067\094\052\058\112\125\059\124\125\085\071\106\125\019\035\094\117\006\106\125\089\124\125\083\052\059\124\085\125\059\083\125\085\071\106\125\083\059\006\124\085\094\089\124\011\125\122\071\106\052\106\125\094\052\106\125\112\106\016\106\052\094\035\125\066\094\124\108\094\017\106\112\125\035\094\007\089\124\017\125\124\106\094\052\066\007\011"), 
		Media = _Aphu, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_2ZW)
				end)
			end
		end
	}
end
function _elRnB:OnSetActive()
	_LoLAm = _Hk9("\042\106\035\014\124\033")
	_Urwigo.GlobalZoneActiveChanged()
end
function _XWpy6:OnProximity()
	_LoLAm = _Hk9("\042\038\072\019\007\107")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _Hk9("\018\112\125\007\059\006\125\110\094\035\058\125\006\019\125\085\059\125\085\071\106\125\066\006\112\089\124\106\112\112\125\108\089\112\065\052\089\065\085\011\125\018\125\112\085\059\052\106\125\059\110\124\106\052\125\065\059\067\106\112\125\059\006\085\125\085\059\125\017\052\106\106\085\125\007\059\006\011"), 
		Media = _6cIY, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _Hk9("\057\059\067\106\085\071\089\124\017\125\094\085\085\094\065\058\106\108\125\067\007\125\066\006\089\035\108\089\124\017\041\125\051\059\059\058\125\067\007\125\110\089\124\108\059\110\125\089\112\125\066\052\059\058\106\124\011"), 
					Media = _ZcCL3, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\064\059\006\125\112\071\059\006\035\108\125\089\124\016\106\112\085\089\017\094\085\106\125\085\071\106\125\066\052\059\058\106\124\125\110\089\124\108\059\110\125\085\059\125\083\089\124\108\125\059\006\085\125\110\071\094\085\125\071\094\019\019\106\124\106\108\011"), 
								Media = _t_Ykx, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _XWpy6:OnSetActive()
	_LoLAm = _Hk9("\042\038\072\019\007\107")
	_Urwigo.GlobalZoneActiveChanged()
end
function _yp1:OnProximity()
	_LoLAm = _Hk9("\042\007\019\050")
	_Urwigo.GlobalZoneProximity()
	_qjxuj.Commands._jg0m.Enabled = true
	_SiIHi.Commands._NpPn.Enabled = true
	_SiIHi.Commands._cDY.Enabled = false
	_Urwigo.MessageBox{
		Text = _Hk9("\070\019\059\124\125\106\124\085\106\052\089\124\017\125\085\071\106\125\065\106\067\106\085\106\052\007\125\007\059\006\125\112\106\106\125\085\071\106\125\094\052\106\094\125\089\124\125\108\089\112\094\052\052\094\007\011\125\105\052\094\016\106\112\085\059\124\106\112\125\071\094\016\106\125\066\106\106\124\125\112\067\094\112\071\106\108\125\094\124\108\125\085\071\106\125\017\052\059\006\124\108\125\089\112\125\085\059\052\124\125\006\019\125\106\016\106\052\007\110\071\106\052\106\011"), 
		Media = _ep9P, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _Hk9("\109\052\059\067\125\094\065\052\059\112\112\125\085\071\106\125\083\089\106\035\108\125\007\059\006\125\112\106\106\125\094\125\110\094\035\058\089\124\017\125\065\059\052\019\112\106\125\065\059\016\106\052\106\108\125\089\124\125\066\094\124\108\094\017\106\112\011\125\123\085\125\089\112\125\085\071\106\125\096\006\067\067\007\041"), 
					Media = _6Y9, 
					Callback = function(action)
						if action ~= nil then
							_mk2:Start()
							Wherigo.PlayAudio(_9ho)
						end
					end
				}
			end
		end
	}
end
function _yp1:OnSetActive()
	_LoLAm = _Hk9("\042\007\019\050")
	_Urwigo.GlobalZoneActiveChanged()
end
function _6dp5L:OnProximity()
	_LoLAm = _Hk9("\042\107\108\019\084\051")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _Hk9("\064\059\006\125\094\052\106\125\017\106\085\085\089\124\017\125\016\106\052\007\125\065\035\059\112\106\125\085\059\125\085\071\106\125\067\089\112\112\089\124\017\125\094\052\085\089\083\094\065\085\112\011"), 
		Media = _E58w, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_Y45C)
				end)
			end
		end
	}
end
function _6dp5L:OnSetActive()
	_LoLAm = _Hk9("\042\107\108\019\084\051")
	_Urwigo.GlobalZoneActiveChanged()
end
function _T52:OnProximity()
	_LoLAm = _Hk9("\042\122\084\039")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _Hk9("\064\059\006\125\124\059\085\089\065\106\125\112\059\067\106\085\071\089\124\017\125\089\124\125\085\071\106\125\017\052\094\112\112\011"), 
		Media = _t_Ykx, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _T52:OnSetActive()
	_LoLAm = _Hk9("\042\122\084\039")
	_Urwigo.GlobalZoneActiveChanged()
end
function _t97OF:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_yVV = input
	if Wherigo.NoCaseEquals(_yVV, _Hk9("\064\106\112")) then
		_Urwigo.MessageBox{
			Text = _Hk9("\046\111\065\106\035\035\106\124\085\041\125\123\125\094\067\125\017\035\094\108\125\007\059\006\125\094\052\106\125\110\089\035\035\089\124\017\125\085\059\125\071\106\035\019\011"), 
			Media = _feS8k, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _Hk9("\122\071\106\052\106\125\094\052\106\125\112\106\016\106\052\094\035\125\035\106\094\108\112\125\007\059\006\125\112\071\059\006\035\108\125\083\059\035\035\059\110\011\125\123\125\110\089\035\035\125\067\094\052\058\125\085\071\106\125\035\059\065\094\085\089\059\124\112\125\059\124\125\007\059\006\052\125\067\094\019\011"), 
						Media = _feS8k, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _Hk9("\033\106\083\059\052\106\125\007\059\006\125\035\106\094\016\106\125\007\059\006\125\112\071\059\006\035\108\125\085\094\058\106\125\094\125\035\059\059\058\125\094\085\125\085\071\106\125\106\067\019\085\007\125\112\094\052\065\059\019\071\094\017\006\112\011\125\072\106\125\094\035\112\059\125\071\094\016\106\125\094\125\052\094\052\106\125\065\059\019\007\125\059\083\125\085\071\106\125\046\017\007\019\085\089\094\124\125\033\059\059\058\125\059\083\125\085\071\106\125\062\106\094\108\011\125"), 
									Media = _feS8k, 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _Hk9("\122\071\106\125\112\094\052\065\059\019\071\094\017\006\112\125\094\124\108\125\066\059\059\058\125\059\083\125\085\071\106\125\108\106\094\108\125\094\052\106\125\124\059\110\125\094\016\094\089\035\094\066\035\106\125\089\124\125\085\071\106\125\089\085\106\067\112\125\067\106\124\006\011"), 
												Media = _t_Ykx, 
												Callback = function(action)
													if action ~= nil then
														_elRnB.Active = true
														_XWpy6.Active = true
														_2W4Qr.Active = true
														Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
		_akw:MoveTo(_4N_ia)
		_Dyj:MoveTo(_4N_ia)
		_SiIHi.Commands._Zdgic.Enabled = false
		_pBIW.Complete = true
		_eXRJK.Active = true
		_pk1.Active = true
		_akw.Commands._PTv74.Enabled = false
		_SiIHi.Commands._z71o.Enabled = false
		_SiIHi.Commands._rhtcy.Enabled = true
		_SiIHi.Description = _Hk9("\062\052\011\125\053\106\089\124\052\089\065\071\125\094\019\019\106\094\052\112\125\085\059\125\066\106\125\110\094\089\085\089\124\017\125\094\052\059\006\124\108\125\124\106\052\016\059\006\112\035\007\011\125\014\106\085\006\052\124\125\085\059\125\071\089\067\125\094\083\085\106\052\125\007\059\006\125\071\094\016\106\125\089\124\016\106\112\085\089\017\094\085\106\108\125\085\071\106\125\065\035\006\106\112\011")
	elseif Wherigo.NoCaseEquals(_yVV, _Hk9("\055\059")) then
		_Urwigo.MessageBox{
			Text = _Hk9("\122\071\094\085\125\089\112\125\085\059\059\125\066\094\108\011\125\123\083\125\007\059\006\125\065\071\094\124\017\106\125\007\059\006\052\125\067\089\124\108\043\125\019\035\106\094\112\106\125\035\106\085\125\067\106\125\058\124\059\110\011"), 
			Media = _feS8k, 
			Callback = function(action)
				if action ~= nil then
					_SiIHi.Commands._z71o.Enabled = true
					_SiIHi.Commands._Zdgic.Enabled = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _2ZW:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_WAx = input
	if Wherigo.NoCaseEquals(_WAx, _Hk9("\016\106\085\106\052\094\124\112")) then
		_Urwigo.MessageBox{
			Text = _Hk9("\122\071\094\085\125\089\112\125\065\059\052\052\106\065\085\041"), 
			Media = _Aphu, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _Hk9("\064\059\006\125\067\094\058\106\125\124\059\085\106\125\059\083\125\085\071\106\125\067\094\052\058\089\124\017\112\125\059\124\125\085\071\106\125\019\035\094\117\006\106\125\094\124\108\125\019\089\065\058\125\006\019\125\112\059\067\106\125\059\083\125\085\071\106\125\066\094\124\108\094\017\106\112\125\124\106\094\052\066\007\125\085\059\125\058\106\106\019\125\094\112\125\106\016\089\108\106\124\065\106\011"), 
						Media = _kgJ, 
						Callback = function(action)
							if action ~= nil then
								_KfbSl:MoveTo(Player)
								_elRnB.Active = false
								_LDf = 0
								if _2W4Qr.Active == false then
									_LDf = _LDf + 1
								end
								if _elRnB.Active == false then
									_LDf = _LDf + 1
								end
								if _XWpy6.Active == false then
									_LDf = _LDf + 1
								end
								if _LDf >= 3 then
									_pk1.Complete = true
									_SiIHi.Commands._N6PyN.Enabled = true
									_SiIHi.Commands._rhtcy.Enabled = false
									_SiIHi.Description = _Hk9("\062\052\011\125\053\106\089\124\052\089\065\071\125\089\112\125\110\094\089\085\089\124\017\125\094\052\059\006\124\108\125\094\124\111\089\059\006\112\035\007\011\125")
									Wherigo.PlayAudio(_yVITk)
									_Urwigo.MessageBox{
										Text = _Hk9("\105\059\059\108\125\010\059\066\041\125\064\059\006\125\071\094\016\106\125\083\059\035\035\059\110\106\108\125\094\035\035\125\059\083\125\085\071\106\125\115\052\059\083\106\112\112\059\052\005\112\125\035\106\094\108\112\011\125\064\059\006\125\112\071\059\006\035\108\125\071\106\094\108\125\066\094\065\058\125\085\059\125\085\094\035\058\125\085\059\125\062\052\011\125\053\106\089\124\052\089\065\071\011"), 
										Media = _nw6Gm, 
										Callback = function(action)
											if action ~= nil then
												Wherigo.Command "StopSound"
											end
										end
									}
								end
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _Hk9("\122\071\094\085\125\089\112\125\124\059\085\125\065\059\052\052\106\065\085\011\125\051\059\059\058\125\083\059\052\125\085\071\106\125\110\059\052\108\125\089\124\125\085\071\106\125\067\089\108\108\035\106\125\059\083\125\085\071\106\125\019\035\094\117\006\106\011"), 
			Media = _RELx, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_2ZW)
					end)
				end
			end
		}
	end
end
function _Y45C:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_3b5ng = input
	if Wherigo.NoCaseEquals(_3b5ng, _Hk9("\064\106\112")) then
		_Urwigo.MessageBox{
			Text = _Hk9("\018\110\106\112\059\067\106\041\125\097\059\124\017\052\094\085\006\035\094\085\089\059\124\112\125\059\124\125\083\089\124\108\089\124\017\125\085\071\106\125\094\052\085\089\083\094\065\085\112\125\094\124\108\125\065\059\067\019\035\106\085\089\124\017\125\085\071\089\112\125\110\071\106\052\089\017\059\041\125\062\052\011\125\053\106\089\124\052\089\065\071\125\110\089\035\035\125\066\106\125\016\106\052\007\125\071\094\019\019\007\125\110\089\085\071\125\007\059\006\011\125\122\071\089\112\125\110\071\106\052\089\017\059\125\110\094\112\125\065\052\106\094\085\106\108\125\066\007\125\109\059\052\106\112\085\056\105\071\059\112\085\011"), 
			Media = _nw6Gm, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = (_Hk9("\064\059\006\052\125\019\035\094\007\106\052\125\065\059\067\019\035\106\085\089\059\124\125\065\059\108\106\125\089\112\125")..string.sub(Player.CompletionCode, 1, 15)).._Hk9("\125\064\059\006\125\065\094\124\125\094\035\112\059\125\083\089\124\108\125\007\059\006\052\125\019\035\094\007\106\052\125\065\059\067\019\035\106\085\089\059\124\125\065\059\108\106\125\089\124\125\007\059\006\052\125\089\124\016\106\124\085\059\052\007\011\125\096\094\058\106\125\112\006\052\106\125\085\059\125\035\059\017\125\007\059\006\052\125\106\111\019\106\052\089\106\124\065\106\125\059\124\125\110\071\106\052\089\017\059\011\065\059\067\011"), 
						Media = _drxTX, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _Hk9("\122\059\125\083\089\124\108\125\059\006\085\125\067\059\052\106\125\094\066\059\006\085\125\110\071\106\052\089\017\059\112\125\019\035\106\094\112\106\125\016\089\112\089\085\125\110\071\106\052\089\017\059\083\059\006\124\108\094\085\089\059\124\011\065\059\067\011\125\122\071\094\124\058\112\125\083\059\052\125\019\035\094\007\089\124\017\011"), 
									Media = _drxTX
								}
							end
						end
					}
					_3Nho1.Complete = true
					_0Jiq.Complete = true
					_O4x_U.Description = string.sub(Player.CompletionCode, 1, 15)
					_O4x_U:MoveTo(Player)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_3b5ng, _Hk9("\055\059")) then
		_Urwigo.MessageBox{
			Text = _Hk9("\123\125\094\067\125\112\059\052\052\007\125\085\071\094\085\125\007\059\006\125\108\089\108\124\005\085\125\083\089\124\108\125\089\085\011\125\064\059\006\125\094\052\106\125\089\124\125\085\071\106\125\065\059\052\052\106\065\085\125\035\059\065\094\085\089\059\124\011\125\123\083\125\007\059\006\125\085\071\089\124\058\125\085\071\106\125\065\094\065\071\106\125\089\112\125\067\089\112\112\089\124\017\125\019\035\106\094\112\106\125\065\059\124\085\094\065\085\125\085\071\106\125\097\040\011"), 
			Media = _E58w, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Y45C)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _Hk9("\105\059\125\066\106\124\106\094\085\071\125\085\059\125\085\071\106\125\067\006\067\067\089\106\112\005\125\035\094\089\052\011\125\122\071\106\125\065\059\059\052\108\089\124\094\085\106\112\125\094\052\106\119\125\055\125\060\091\125\039\039\011\050\091\060\125\072\125\049\028\048\125\118\049\011\039\107\039\011"), 
			Media = _E58w, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Y45C)
					end)
				end
			end
		}
	end
end
function _kJCuB:OnGetInput(input)
	if input == nil then
		input = ""
	end
	__uz5U = input
	if Wherigo.NoCaseEquals(__uz5U, _Hk9("\039\049\049\049")) then
		_Urwigo.MessageBox{
			Text = _Hk9("\064\106\112\041\125\122\071\059\112\106\125\110\106\052\106\125\085\071\106\125\124\006\067\066\106\052\112\125\085\071\094\085\125\110\106\052\106\125\017\035\059\110\089\124\017\011\125\072\071\106\124\125\123\125\085\006\052\124\106\108\125\094\052\059\006\124\108\125\085\071\106\052\106\125\110\094\112\125\124\059\085\071\089\124\017\125\085\071\106\052\106\125\106\111\065\106\019\085\125\094\125\065\059\006\019\035\106\125\066\094\124\108\094\017\106\112\125\059\124\125\085\071\106\125\017\052\059\006\124\108\011\125"), 
			Media = _mERx3, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _Hk9("\064\059\006\125\067\094\058\106\125\124\059\085\106\125\059\083\125\085\071\106\125\106\007\106\125\110\089\085\124\106\112\112\005\125\112\085\059\052\007\011"), 
						Media = _kgJ, 
						Callback = function(action)
							if action ~= nil then
								_2W4Qr.Active = false
								_LDf = 0
								if _2W4Qr.Active == false then
									_LDf = _LDf + 1
								end
								if _elRnB.Active == false then
									_LDf = _LDf + 1
								end
								if _XWpy6.Active == false then
									_LDf = _LDf + 1
								end
								if _LDf >= 3 then
									_SiIHi.Commands._N6PyN.Enabled = true
									_SiIHi.Commands._rhtcy.Enabled = false
									_pk1.Complete = true
									_SiIHi.Description = _Hk9("\062\052\011\125\053\106\089\124\052\089\065\071\125\089\112\125\110\094\089\085\089\124\017\125\094\052\059\006\124\108\125\094\124\111\089\059\006\112\035\007\011\125")
									Wherigo.PlayAudio(_yVITk)
									_Urwigo.MessageBox{
										Text = _Hk9("\105\059\059\108\125\010\059\066\041\125\064\059\006\125\071\094\016\106\125\083\059\035\035\059\110\106\108\125\094\035\035\125\059\083\125\085\071\106\125\115\052\059\083\106\112\112\059\052\005\112\125\035\106\094\108\112\011\125\064\059\006\125\112\071\059\006\035\108\125\071\106\094\108\125\066\094\065\058\125\085\059\125\085\094\035\058\125\085\059\125\062\052\011\125\053\106\089\124\052\089\065\071\011"), 
										Media = _nw6Gm, 
										Callback = function(action)
											if action ~= nil then
												Wherigo.Command "StopSound"
											end
										end
									}
								end
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _Hk9("\055\059\043\125\085\071\059\112\106\125\094\052\106\124\005\085\125\085\071\106\125\124\006\067\066\106\052\112\125\085\071\094\085\125\110\106\052\106\125\017\035\059\110\089\124\017\011\125\051\059\059\058\125\083\059\052\125\085\071\106\125\083\059\006\052\125\108\089\017\089\085\125\007\106\094\052\125\124\106\094\052\125\085\071\106\125\085\059\019\125\059\083\125\085\071\106\125\019\035\094\117\006\106\011\125"), 
			Media = _RELx, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_kJCuB)
					end)
				end
			end
		}
	end
end
function _s2g:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FWKXN = input
	if Wherigo.NoCaseEquals(_FWKXN, _Hk9("\064\106\112")) then
		_Urwigo.MessageBox{
			Text = _Hk9("\123\125\094\067\125\017\035\094\108\125\085\059\125\071\106\094\052\125\089\085\011\125\072\106\125\065\059\006\035\108\125\006\112\106\125\007\059\006\052\125\071\106\035\019\011\125"), 
			Media = _Cb3, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _Hk9("\064\059\006\125\067\094\007\125\124\106\106\108\125\094\125\110\106\094\019\059\124\125\085\059\125\019\052\059\085\106\065\085\125\007\059\006\052\112\106\035\083\011\125\122\094\058\106\125\085\071\089\112\125\112\071\059\085\017\006\124\125\094\124\108\125\067\106\106\085\125\006\112\125\059\016\106\052\125\094\085\125\085\071\106\125\065\106\067\106\085\106\052\007\011"), 
						Media = _Cb3, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.PlayAudio(_fZBK)
								_Urwigo.MessageBox{
									Text = _Hk9("\062\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106\125\071\094\124\108\112\125\007\059\006\125\094\125\112\071\059\085\017\006\124\125\094\124\108\125\112\106\016\106\052\094\035\125\066\059\111\106\112\125\059\083\125\112\071\106\035\035\112\011"), 
									Media = _a30x0, 
									Callback = function(action)
										if action ~= nil then
											_xsr.Active = false
											_qjxuj:MoveTo(_yp1)
											_SiIHi:MoveTo(_yp1)
											_yp1.Active = true
											_5OLq:MoveTo(Player)
											_rP1:MoveTo(Player)
											_QUP0_.Active = true
											_qjxuj.Commands._9wPud.Enabled = false
											_qjxuj.Description = _Hk9("\122\071\106\125\108\106\085\106\065\085\089\016\106\125\094\019\019\106\094\052\112\125\085\059\125\066\106\125\016\106\052\007\125\083\052\089\017\071\085\106\124\106\108\011")
											_SiIHi.Description = _Hk9("\062\052\011\125\053\106\089\124\052\089\065\071\125\094\019\019\106\094\052\112\125\085\059\125\066\106\125\016\106\052\007\125\083\052\089\017\071\085\106\124\106\108\011")
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _Hk9("\040\058\094\007\043\125\007\059\006\125\065\094\124\125\083\089\124\108\125\006\112\125\094\085\125\085\071\106\125\065\106\067\106\085\106\052\007\125\089\083\125\007\059\006\125\065\071\094\124\017\106\125\007\059\006\052\125\067\089\124\108\011"), 
			Media = _Cb3, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _Hk9("\122\071\106\125\019\052\059\083\106\112\112\059\052\125\094\124\108\125\095\124\066\112\019\015\108\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106\125\035\106\094\016\106\125\083\059\052\125\085\071\106\125\065\106\067\106\085\106\052\007\011\125\064\059\006\125\083\089\124\108\125\007\059\006\052\112\106\035\083\125\094\035\059\124\106\125\094\085\125\085\071\106\125\019\059\035\089\065\106\125\112\085\094\085\089\059\124\011"), 
						Media = _I_Il, 
						Callback = function(action)
							if action ~= nil then
								_siY:MoveTo(_xsr)
								_qjxuj:MoveTo(_yp1)
								_SiIHi:MoveTo(_yp1)
								_qjxuj.Commands._9wPud.Enabled = false
								_SiIHi.Commands._NpPn.Enabled = true
								_yp1.Active = true
								_SiIHi.Commands._rhtcy.Enabled = false
								_QUP0_.Active = true
								_qjxuj.Description = _Hk9("\122\071\106\125\108\106\085\106\065\085\089\016\106\125\094\019\019\106\094\052\112\125\085\059\125\066\106\125\016\106\052\007\125\083\052\089\017\071\085\106\124\106\108\011")
								_SiIHi.Description = _Hk9("\062\052\011\125\053\106\089\124\052\089\065\071\125\094\019\019\106\094\052\112\125\085\059\125\066\106\125\016\106\052\007\125\083\052\089\017\071\085\106\124\106\108\011")
							end
						end
					}
				end
			end
		}
	end
end
function _OgEK:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_MSf = input
	if Wherigo.NoCaseEquals(_MSf, _Hk9("\046\111\094\067\089\124\106\125\018\017\094\089\124")) then
		_Urwigo.MessageBox{
			Text = _Hk9("\070\019\059\124\125\065\035\059\112\106\052\125\089\124\112\019\106\065\085\089\059\124\125\007\059\006\125\124\059\085\089\065\106\125\085\071\094\085\125\112\059\067\106\085\071\089\124\017\125\071\094\112\125\066\052\059\058\106\124\125\059\083\083\125\083\052\059\067\125\085\071\106\125\085\059\019\125\059\083\125\085\071\106\125\112\094\052\065\059\019\071\059\017\006\112\011"), 
			Media = _uUW, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.PlayAudio(_yVITk)
					_Urwigo.MessageBox{
						Text = _Hk9("\123\085\125\035\059\059\058\112\125\035\089\058\106\125\085\071\106\125\094\124\058\071\125\112\007\067\066\059\035\125\110\071\089\065\071\125\110\094\112\125\059\124\125\085\059\019\125\059\083\125\085\071\106\125\112\094\052\065\059\019\071\059\017\006\112\125\089\112\125\067\089\112\112\089\124\017\041\125"), 
						Media = _nw6Gm, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _Hk9("\064\059\006\125\112\071\059\006\035\108\125\089\124\016\106\112\085\089\017\094\085\106\125\085\071\106\125\067\089\112\112\089\124\017\125\094\124\058\071\125\112\007\067\066\059\035\011\125\123\085\125\067\094\007\125\066\106\125\112\059\067\106\125\110\071\106\052\106\125\124\106\094\052\066\007\011\125"), 
									Media = _nw6Gm, 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _Hk9("\018\125\124\106\110\125\085\094\112\058\125\089\112\125\094\016\094\089\035\094\066\035\106\125\089\124\125\085\071\106\125\029\085\094\112\058\112\029\125\067\106\124\006\011"), 
												Media = _iwj, 
												Callback = function(action)
													if action ~= nil then
														Wherigo.Command "StopSound"
														_Kk5I = _Kk5I + 1
														_akw.Commands._PTv74.Enabled = false
														_eXRJK.Complete = true
														_506P.Active = true
														Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end
end
function _eNG:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_7P6Y_ = input
	_mTI.Description = _7P6Y_
end
function _rKz:OnStart()
	_ebuWk:Stop()
	Wherigo.PlayAudio(_AjUR)
	_Urwigo.MessageBox{
		Text = "", 
		Media = _Avmh
	}
end
function _rKz:OnTick()
	_Urwigo.MessageBox{
		Text = _Hk9("\122\071\106\125\067\006\067\067\007\125\065\059\110\106\052\112\125\066\106\083\059\052\106\125\085\071\106\125\035\089\017\071\085\011"), 
		Media = _Avmh, 
		Callback = function(action)
			if action ~= nil then
				_rKz:Stop()
				Wherigo.PlayAudio(_hb9GP)
				_Urwigo.MessageBox{
					Text = _Hk9("\064\059\006\125\124\059\110\125\071\094\016\106\125\085\071\106\125\067\006\067\067\007\125\006\124\108\106\052\125\007\059\006\052\125\065\059\124\085\052\059\035\041"), 
					Media = _suJf, 
					Callback = function(action)
						if action ~= nil then
							_QUP0_.Complete = true
							_5rNkE()
							Wherigo.Command "StopSound"
						end
					end
				}
			end
		end
	}
end
function _mk2:OnStart()
	_Urwigo.MessageBox{
		Text = _Hk9("\122\071\106\125\067\006\067\067\007\125\089\112\125\110\094\035\058\089\124\017\125\085\059\110\094\052\108\112\125\007\059\006\011"), 
		Media = _6Y9, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.Command "StopSound"
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _mk2:OnTick()
	Wherigo.PlayAudio(_9ho)
	_mk2:Stop()
	_Urwigo.MessageBox{
		Text = _Hk9("\122\071\106\125\067\006\067\067\007\125\067\059\016\106\112\125\089\124\085\059\125\085\071\106\125\094\052\106\094\011\125\053\106\125\106\007\106\112\125\085\071\106\125\108\106\085\106\065\085\089\016\106\125\094\124\108\125\062\052\011\125\053\106\089\124\052\089\065\071\011"), 
		Media = _6Y9, 
		Callback = function(action)
			if action ~= nil then
				_ZDSD.Commands._7ysPN.Enabled = true
				_ZDSD.Commands._rV1Q.Enabled = false
				_5OLq.Commands._Lq_Qr.Enabled = false
				_5OLq.Commands._3W6T.Enabled = true
				_lWQ:MoveTo(_yp1)
				Wherigo.Command "StopSound"
				_Urwigo.MessageBox{
					Text = _Hk9("\122\071\106\125\067\006\067\067\007\125\094\085\085\094\065\058\112\041"), 
					Media = _ClR_, 
					Callback = function(action)
						if action ~= nil then
							_ebuWk:Start()
						end
					end
				}
			end
		end
	}
end
function _ebuWk:OnTick()
	_Urwigo.MessageBox{
		Text = _Hk9("\122\071\106\125\067\006\067\067\007\125\094\085\085\094\065\058\112\041"), 
		Media = _ClR_, 
		Callback = function(action)
			if action ~= nil then
				local _rndChoiceValue = math.random()
				if _rndChoiceValue < 0.333333333333333 then
					_ebuWk:Stop()
					Wherigo.PlayAudio(_K4VU)
					_Urwigo.MessageBox{
						Text = _Hk9("\122\071\106\125\067\006\067\067\007\125\112\110\089\124\017\112\125\094\124\108\125\071\089\085\112\125\062\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106\125\110\089\085\071\125\094\125\065\052\006\112\071\089\124\017\125\066\035\059\110\011"), 
						Media = _ClR_, 
						Callback = function(action)
							if action ~= nil then
								_ebuWk:Start()
								Wherigo.Command "StopSound"
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				elseif _rndChoiceValue < 0.666666666666667 then
					_ebuWk:Stop()
					Wherigo.PlayAudio(_K4VU)
					_Urwigo.MessageBox{
						Text = _Hk9("\122\071\106\125\067\006\067\067\007\125\112\110\089\124\017\112\125\094\124\108\125\071\089\085\112\125\062\052\011\125\053\106\089\124\052\089\065\071\125\110\089\085\071\125\094\125\065\052\006\112\071\089\124\017\125\066\035\059\110\011"), 
						Media = _ClR_, 
						Callback = function(action)
							if action ~= nil then
								_ebuWk:Start()
								Wherigo.Command "StopSound"
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				else
					_ebuWk:Stop()
					Wherigo.PlayAudio(_K4VU)
					_Urwigo.MessageBox{
						Text = _Hk9("\122\071\106\125\067\006\067\067\007\125\112\110\089\124\017\112\125\094\085\125\007\059\006\125\066\006\085\125\007\059\006\125\094\052\106\125\094\066\035\106\125\085\059\125\017\052\094\065\106\083\006\035\035\007\125\108\059\108\017\106\125\071\089\067\011"), 
						Media = _ClR_, 
						Callback = function(action)
							if action ~= nil then
								_ebuWk:Start()
								Wherigo.Command "StopSound"
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				end
			end
		end
	}
end
function _SiIHi:On_Zdgic(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\053\106\035\035\059\043\125\067\007\125\124\094\067\106\125\089\112\125\095\124\066\112\019\015\062\052\011\125\053\106\089\124\052\089\065\071\125\033\052\006\017\112\065\071\011\125\123\125\071\094\016\106\125\066\106\106\124\125\112\085\006\108\007\089\124\017\125\085\071\106\125\094\124\065\089\106\124\085\125\046\017\007\019\085\089\094\124\125\115\071\094\052\059\094\071\125\018\058\071\106\124\094\085\106\124\011"), 
		Media = _feS8k, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _Hk9("\122\071\106\125\067\059\052\124\089\124\017\125\094\083\085\106\052\125\085\071\106\125\106\111\071\089\066\089\085\125\094\052\052\089\016\106\108\125\123\125\065\094\067\106\125\089\124\085\059\125\106\111\094\067\089\124\106\125\018\058\071\106\124\094\085\106\124\005\112\125\112\094\052\065\059\019\071\094\017\006\112\125\094\124\108\125\085\071\106\125\065\059\124\085\106\124\085\112\125\094\035\059\124\017\125\110\089\085\071\125\112\106\016\106\052\094\035\125\094\052\085\089\083\094\065\085\112\125\110\106\052\106\125\067\089\112\112\089\124\017\011"), 
					Media = _feS8k, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\123\125\065\059\124\085\094\065\085\106\108\125\085\071\106\125\094\006\085\071\059\052\089\085\089\106\112\125\066\006\085\125\124\059\125\059\124\106\125\071\094\112\125\066\106\106\124\125\094\066\035\106\125\085\059\125\065\059\067\106\125\006\019\125\110\089\085\071\125\094\125\112\059\035\006\085\089\059\124\011"), 
								Media = _feS8k, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(_t97OF)
										end)
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _SiIHi:On_z71o(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\018\071\071\043\125\007\059\006\125\071\094\016\106\125\052\106\085\006\052\124\106\108\011"), 
		Media = _feS8k, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_t97OF)
				end)
			end
		end
	}
end
function _SiIHi:On_N6PyN(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\046\111\065\106\035\035\106\124\085\041\125\007\059\006\125\071\094\016\106\125\083\059\006\124\108\125\094\035\035\125\059\083\125\085\071\106\125\065\035\006\106\112\011\125"), 
		Media = _feS8k, 
		Callback = function(action)
			if action ~= nil then
				_KfbSl:MoveTo(_SiIHi)
				_fZksA:MoveTo(_SiIHi)
				_Urwigo.MessageBox{
					Text = _Hk9("\123\125\110\089\035\035\125\085\094\058\106\125\094\124\007\125\106\016\089\108\106\124\065\106\125\085\071\094\085\125\007\059\006\125\071\094\016\106\125\083\059\006\124\108\011"), 
					Media = _feS8k, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\033\106\083\059\052\106\125\110\106\125\065\059\124\085\089\124\006\106\125\085\071\059\006\017\071\043\125\123\125\071\094\016\106\125\094\125\065\059\124\083\106\112\112\089\059\124\119\125\123\125\071\094\016\106\125\124\059\085\125\066\106\106\124\125\065\059\067\019\035\106\085\106\035\007\125\006\019\083\052\059\124\085\125\110\089\085\071\125\007\059\006\011\125\122\071\106\052\106\125\089\112\125\067\059\052\106\125\085\059\125\085\071\089\112\125\065\094\112\106\125\085\071\106\124\125\123\125\071\094\016\106\125\112\071\094\052\106\108\011"), 
								Media = _feS8k, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _Hk9("\051\106\085\125\067\106\125\085\106\035\035\125\007\059\006\125\094\125\112\085\059\052\007\011\011\011"), 
											Media = _feS8k, 
											Callback = function(action)
												if action ~= nil then
													_i7H()
													_SiIHi.Commands._N6PyN.Enabled = false
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _SiIHi:On_rhtcy(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\123\125\112\106\106\125\085\071\094\085\125\007\059\006\125\071\094\016\106\125\124\059\085\125\083\059\006\124\108\125\094\035\035\125\059\083\125\085\071\106\125\065\035\006\106\112\125\007\106\085\011\125\115\035\106\094\112\106\125\052\106\085\006\052\124\125\071\106\052\106\125\110\071\106\124\125\007\059\006\125\071\094\016\106\125\108\059\124\106\125\112\059\011"), 
		Media = _feS8k, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _SiIHi:On_cDY(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\123\125\094\067\125\017\035\094\108\125\007\059\006\125\067\094\108\106\125\089\085\011\125\057\019\106\094\058\125\085\059\125\108\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106\125\085\059\125\083\089\124\108\125\059\006\085\125\059\006\052\125\124\106\111\085\125\067\059\016\106\011"), 
		Media = _feS8k, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _SiIHi:On_NpPn(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\053\106\035\019\041\041\041\041\125\123\085\112\125\085\071\106\125\067\006\067\067\007\041\125\123\005\016\106\125\071\106\094\052\108\125\085\071\094\085\125\094\125\065\106\052\085\094\089\124\125\094\124\058\071\125\085\094\035\089\112\067\094\124\125\071\094\112\125\019\059\110\106\052\125\059\016\106\052\125\085\071\106\125\067\006\067\067\007\011"), 
		Media = _feS8k, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _qjxuj:On_9wPud(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\053\089\043\125\123\125\094\067\125\108\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106\011\125\123\125\094\067\125\089\124\125\065\071\094\052\017\106\125\059\083\125\085\071\089\112\125\065\094\112\106\011"), 
		Media = _Cb3, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _Hk9("\046\016\106\052\125\112\089\124\065\106\125\123\125\017\059\085\125\019\006\085\125\059\124\125\085\071\089\112\125\065\094\112\106\125\085\071\089\124\017\112\125\071\094\016\106\125\124\059\085\125\066\106\106\124\125\052\089\017\071\085\125\089\124\125\085\059\110\124\011\125"), 
					Media = _Cb3, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\123\125\071\094\016\106\125\066\106\106\124\125\017\106\085\085\089\124\017\125\094\035\035\125\058\089\124\108\112\125\059\083\125\065\094\035\035\112\119\125\065\059\067\019\035\094\089\124\085\112\043\125\108\089\112\085\006\052\066\094\124\065\106\112\043\125\094\124\108\125\112\089\017\071\085\089\124\017\112\125\059\083\125\094\124\125\006\124\056\124\094\085\006\052\094\035\125\058\089\124\108\011"), 
								Media = _Cb3, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _Hk9("\122\071\106\125\019\052\059\083\106\112\112\059\052\125\112\019\106\094\058\112\125\006\019\043\125\123\125\052\106\094\035\035\007\125\094\067\125\112\059\052\052\007\125\083\059\052\125\106\016\106\052\007\085\071\089\124\017\125\108\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106\011\125\123\125\066\035\094\067\106\125\067\007\112\106\035\083\125\083\059\052\125\110\071\094\085\125\071\094\112\125\071\094\019\019\106\124\106\108\011\125"), 
											Media = _feS8k, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _Hk9("\123\125\094\019\019\052\106\065\089\094\085\106\125\085\071\094\085\125\066\006\085\125\006\124\083\059\052\085\006\124\094\085\106\035\007\125\085\071\106\052\106\125\089\112\125\124\059\085\071\089\124\017\125\110\106\125\065\094\124\125\108\059\125\124\059\110\011\125\122\071\089\112\125\067\059\052\124\089\124\017\125\123\125\017\059\085\125\094\125\065\094\035\035\125\083\052\059\067\125\085\071\106\125\017\052\059\006\124\108\112\125\058\106\106\019\106\052\125\094\085\125\085\071\106\125\065\106\067\106\085\106\052\007\125\110\071\059\125\052\106\019\059\052\085\106\108\125\085\071\094\085\125\094\125\019\106\052\112\059\124\125\110\094\112\125\094\085\085\094\065\058\106\108\011"), 
														Media = _Cb3, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _Hk9("\072\071\106\124\125\085\071\106\125\016\089\065\085\089\067\125\110\094\112\125\094\112\058\106\108\125\110\071\059\125\085\071\106\089\052\125\094\085\085\094\065\058\106\052\125\110\094\112\043\125\085\071\106\125\059\124\035\007\125\085\071\089\124\017\125\085\071\106\007\125\065\059\006\035\108\125\112\085\094\085\106\125\110\094\112\043\125\029\096\070\096\096\064\041\041\041\029"), 
																	Media = _Cb3, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.RunDialogs(function()
																				Wherigo.GetInput(_s2g)
																			end)
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _qjxuj:On_jg0m(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\122\071\106\125\067\006\067\067\007\125\089\112\125\112\059\125\083\052\089\017\071\085\106\124\089\124\017\041\125\070\112\106\125\094\125\112\071\059\085\017\006\124\125\085\059\125\085\094\058\106\125\071\089\067\125\108\059\110\124\041\041\041"), 
		Media = _Cb3
	}
end
function _errz:On_SAVdQ(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\064\059\006\125\106\111\019\035\094\089\124\125\085\059\125\085\071\106\125\110\089\085\124\106\112\112\125\085\071\094\085\125\007\059\006\125\094\052\106\125\089\124\016\106\112\085\089\017\094\085\089\124\017\125\085\071\106\125\065\094\112\106\125\094\124\108\125\094\112\058\125\071\089\067\125\110\071\094\085\125\071\094\019\019\106\124\106\108\011"), 
		Media = _t_Ykx, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _Hk9("\122\071\106\125\106\007\106\125\110\089\085\124\106\112\112\125\010\006\067\019\112\125\006\019\125\124\106\052\016\059\006\112\035\007\011\125\123\125\110\094\112\125\071\106\052\106\125\094\124\108\125\123\125\071\106\094\052\108\125\089\085\041\041\041\041\041"), 
					Media = _mERx3, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\123\125\110\094\112\125\085\094\058\089\124\017\125\094\125\035\059\059\058\125\094\085\125\085\071\089\112\125\066\106\094\006\085\089\083\006\035\125\112\085\094\085\006\106\125\110\071\106\124\125\123\125\071\106\094\052\108\125\094\125\108\106\106\019\125\017\052\059\094\124\125\066\106\071\089\124\108\125\067\106\011\125\018\035\035\125\059\083\125\094\125\112\006\108\108\106\124\125\085\071\106\125\108\094\085\106\125\059\124\125\085\071\089\112\125\112\085\094\085\006\106\125\112\085\094\052\085\112\125\017\035\059\110\089\124\017\125\052\106\108\011"), 
								Media = _mERx3, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _Hk9("\123\125\085\006\052\124\106\108\125\094\052\059\006\124\108\125\085\059\125\112\106\106\125\110\071\094\085\125\110\094\112\125\067\094\058\089\124\017\125\085\071\106\125\112\059\006\124\108\125\066\006\085\125\110\071\094\085\106\016\106\052\125\089\085\125\110\094\112\125\108\089\112\094\019\019\106\094\052\106\108\011"), 
											Media = _mERx3, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.RunDialogs(function()
														Wherigo.GetInput(_kJCuB)
													end)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _akw:On_rdEku(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\070\019\059\124\125\106\111\094\067\089\124\089\124\017\125\085\071\106\125\112\094\052\065\059\019\071\094\017\006\112\125\007\059\006\125\112\106\106\125\112\059\067\106\125\112\065\052\094\085\065\071\125\067\094\052\058\112\125\059\124\125\085\071\106\125\112\006\052\083\094\065\106\125\066\006\085\125\124\059\085\125\067\006\065\071\125\106\035\112\106\011"), 
		Media = _uUW, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_OgEK)
				end)
				_akw.Commands._rdEku.Enabled = false
				_akw.Commands._PTv74.Enabled = true
			end
		end
	}
end
function _akw:On_PTv74(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\070\019\059\124\125\065\035\059\112\106\052\125\089\124\112\019\106\065\085\089\059\124\125\007\059\006\125\124\059\085\089\065\106\125\085\071\094\085\125\112\059\067\106\085\071\089\124\017\125\071\094\112\125\066\052\059\058\106\124\125\059\083\083\125\083\052\059\067\125\085\071\106\125\085\059\019\125\059\083\125\085\071\106\125\112\094\052\065\059\019\071\059\017\006\112\011"), 
		Media = _uUW, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.PlayAudio(_yVITk)
				_Urwigo.MessageBox{
					Text = _Hk9("\123\085\125\035\059\059\058\112\125\035\089\058\106\125\085\071\106\125\094\124\058\071\125\112\007\067\066\059\035\125\110\071\089\065\071\125\110\094\112\125\059\124\125\085\059\019\125\059\083\125\085\071\106\125\112\094\052\065\059\019\071\059\017\006\112\125\089\112\125\067\089\112\112\089\124\017\041\125"), 
					Media = _nw6Gm, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\064\059\006\125\112\071\059\006\035\108\125\089\124\016\106\112\085\089\017\094\085\106\125\085\071\106\125\067\089\112\112\089\124\017\125\094\124\058\071\125\112\007\067\066\059\035\011\125\123\085\125\067\094\007\125\066\106\125\112\059\067\106\125\110\071\106\052\106\125\124\106\094\052\066\007\011\125"), 
								Media = _nw6Gm, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _Hk9("\018\125\124\106\110\125\085\094\112\058\125\089\112\125\094\016\094\089\035\094\066\035\106\125\089\124\125\085\071\106\125\029\085\094\112\058\112\029\125\067\106\124\006\011"), 
											Media = _iwj, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.Command "StopSound"
													_akw.Commands._PTv74.Enabled = false
													_eXRJK.Complete = true
													_506P.Active = true
													_Kk5I = _Kk5I + 1
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _akw:On_Zlml(target)
	Wherigo.PlayAudio(_9wxH)
	_Urwigo.MessageBox{
		Text = _Hk9("\064\059\006\125\085\052\007\125\058\124\059\065\058\089\124\017\125\059\124\125\085\071\106\125\112\094\052\065\059\019\071\094\017\006\112\125\066\006\085\125\124\059\085\125\067\006\065\071\125\071\094\019\019\106\124\112\011"), 
		Media = _uUW, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.Command "StopSound"
			end
		end
	}
end
function _akw:On_8tBC(target)
	Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
function _6xL:On_8Ok(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\051\059\059\058\089\124\017\125\065\035\059\112\106\035\007\125\094\085\125\085\071\106\125\065\052\094\065\058\106\108\125\110\089\124\108\059\110\125\007\059\006\125\112\106\106\125\112\059\067\106\125\059\035\108\125\083\089\066\106\052\125\065\094\006\017\071\085\125\089\124\125\085\071\106\125\066\052\059\058\106\124\125\017\035\094\112\112\011\125"), 
		Media = _XTIp, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _Hk9("\064\059\006\125\094\035\112\059\125\124\059\085\089\065\106\125\094\125\112\067\094\035\035\125\065\071\006\124\058\125\059\083\125\052\059\085\085\106\124\125\083\035\106\112\071\011\125"), 
					Media = _XTIp, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\064\059\006\125\085\094\058\106\125\066\059\085\071\125\089\085\106\067\112\125\094\124\108\125\108\106\019\059\112\089\085\125\085\071\106\067\125\089\124\125\085\071\106\125\106\016\089\108\106\124\065\106\125\066\059\111\011"), 
								Media = _tiB, 
								Callback = function(action)
									if action ~= nil then
										_XWpy6.Active = false
										_fZksA:MoveTo(Player)
										_LDf = 0
										if _2W4Qr.Active == false then
											_LDf = _LDf + 1
										end
										if _elRnB.Active == false then
											_LDf = _LDf + 1
										end
										if _XWpy6.Active == false then
											_LDf = _LDf + 1
										end
										if _LDf >= 3 then
											_SiIHi.Commands._N6PyN.Enabled = true
											_pk1.Complete = true
											_SiIHi.Commands._rhtcy.Enabled = false
											_SiIHi.Description = _Hk9("\062\052\011\125\053\106\089\124\052\089\065\071\125\089\112\125\110\094\089\085\089\124\017\125\094\052\059\006\124\108\125\094\124\111\089\059\006\112\035\007\011\125")
											Wherigo.PlayAudio(_yVITk)
											_Urwigo.MessageBox{
												Text = _Hk9("\105\059\059\108\125\010\059\066\041\125\064\059\006\125\071\094\016\106\125\083\059\035\035\059\110\106\108\125\094\035\035\125\059\083\125\085\071\106\125\115\052\059\083\106\112\112\059\052\005\112\125\035\106\094\108\112\011\125\064\059\006\125\112\071\059\006\035\108\125\071\106\094\108\125\066\094\065\058\125\085\059\125\085\094\035\058\125\085\059\125\062\052\011\125\053\106\089\124\052\089\065\071\011"), 
												Media = _nw6Gm, 
												Callback = function(action)
													if action ~= nil then
														Wherigo.Command "StopSound"
													end
												end
											}
										end
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _KEY:On_27s(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\070\019\059\124\125\065\035\059\112\106\052\125\089\124\112\019\106\065\085\089\059\124\125\089\085\125\094\019\019\106\094\052\112\125\085\071\094\085\125\112\059\067\106\085\071\089\124\017\125\110\094\112\125\085\052\007\089\124\017\125\085\059\125\065\035\094\110\125\094\085\125\085\071\106\125\083\059\006\124\085\094\089\124\011\125\122\071\106\052\106\125\094\052\106\125\112\065\052\094\085\065\071\125\067\094\052\058\112\125\059\124\125\085\071\106\125\019\035\094\117\006\106\125\094\124\108\125\112\106\016\106\052\094\035\125\066\094\124\108\094\017\106\112\125\035\094\007\089\124\017\125\124\106\094\052\066\007\011\125\095\124\066\112\019\015"), 
		Media = _Aphu, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_2ZW)
				end)
			end
		end
	}
end
function _Dyj:On_KXeC(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\064\059\006\125\059\019\106\124\125\006\019\125\085\071\106\125\094\124\065\089\106\124\085\125\085\059\067\106\125\094\124\108\125\085\052\007\125\052\106\094\108\089\124\017\125\085\071\052\059\006\017\071\125\112\106\016\106\052\094\035\125\019\094\017\106\112\011"), 
		Media = _yxLx3, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _Hk9("\064\059\006\125\094\052\106\125\124\059\085\125\094\066\035\106\125\085\059\125\006\124\108\106\052\112\085\094\124\108\125\085\071\106\125\066\059\059\058\125\112\089\124\065\106\125\089\085\125\089\112\125\110\052\089\085\085\106\124\125\089\124\125\046\017\007\019\085\089\094\124\125\071\089\106\052\059\017\035\007\019\071\089\065\112\011"), 
					Media = _yxLx3, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\033\106\083\059\052\106\125\007\059\006\125\065\035\059\112\106\125\089\085\043\125\007\059\006\125\124\059\085\089\065\106\125\094\124\125\089\067\094\017\106\125\059\083\125\094\125\019\052\089\106\112\085\125\071\059\035\108\089\124\017\125\006\019\125\094\124\125\094\124\058\071\125\085\094\035\089\112\067\094\124\125\059\016\106\052\125\094\125\067\006\067\067\007\011\125\123\124\125\085\071\106\125\089\067\094\017\106\125\035\089\017\071\085\125\089\112\125\065\059\067\089\124\017\125\059\006\085\125\083\052\059\067\125\085\071\106\125\085\094\035\089\112\067\094\124\125\094\124\108\125\089\085\125\094\019\019\106\094\052\112\125\085\071\106\125\067\006\067\067\007\125\089\112\125\006\124\108\106\052\125\085\071\106\125\065\059\124\085\052\059\035\125\059\083\125\085\071\106\125\019\052\089\106\112\085\011"), 
								Media = _yxLx3, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _Hk9("\064\059\006\125\065\035\059\112\106\125\085\071\106\125\066\059\059\058\011"), 
											Media = _yxLx3, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _5OLq:On_Lq_Qr(target)
	_5KnZR()
end
function _5OLq:On_3W6T(target)
	_EV1()
end
function _5OLq:On_ltk(target)
	_LWln()
end
function _siY:On_K5m0v(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\064\059\006\125\112\106\106\125\112\106\016\106\052\094\035\125\112\071\059\085\125\017\006\124\112\125\035\094\007\089\124\017\125\089\124\125\085\071\106\125\065\094\112\106\125\094\035\059\124\017\125\110\089\085\071\125\112\059\067\106\125\066\059\111\106\112\125\059\083\125\094\067\067\006\124\089\085\089\059\124\011"), 
		Media = __2lH
	}
end
function _siY:On_x5N(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\072\071\089\035\106\125\124\059\125\059\124\106\125\089\112\125\035\059\059\058\089\124\017\125\007\059\006\125\085\094\058\106\125\059\124\106\125\059\083\125\085\071\106\125\112\071\059\085\017\006\124\112\125\083\052\059\067\125\085\071\106\125\065\094\112\106\125\094\035\059\124\017\125\110\089\085\071\125\112\106\016\106\052\094\035\125\066\059\111\106\112\125\059\083\125\094\067\067\006\124\089\085\089\059\124\011"), 
		Media = _a30x0, 
		Callback = function(action)
			if action ~= nil then
				_5OLq:MoveTo(Player)
				_rP1:MoveTo(Player)
				_siY.Commands._x5N.Enabled = false
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _rP1:On_U5Hfk(target)
	_LWln()
end
function _ZDSD:On_vzD6(target)
	Wherigo.PlayAudio(_yVITk)
	_Urwigo.MessageBox{
		Text = _Hk9("\064\059\006\125\019\089\065\058\125\006\019\125\085\071\106\125\018\124\058\071\011"), 
		Media = _BnyC, 
		Callback = function(action)
			if action ~= nil then
				_506P.Complete = true
				_ZDSD:MoveTo(Player)
				_Urwigo.MessageBox{
					Text = _Hk9("\064\059\006\125\071\094\016\106\125\083\059\006\124\108\125\085\071\106\125\018\124\058\071\125\059\083\125\018\058\071\106\124\094\085\106\124\041\125\122\071\089\112\125\085\094\035\089\112\067\094\124\125\110\094\112\125\019\035\094\065\106\108\125\059\124\125\085\059\019\125\059\083\125\085\071\106\125\112\094\052\065\059\019\071\094\017\006\112\125\059\083\125\018\058\071\106\124\094\085\106\124\125\094\124\108\125\110\094\112\125\112\094\089\108\125\085\059\125\071\059\035\108\125\112\019\106\065\089\094\035\125\019\059\110\106\052\112\125\059\016\106\052\125\071\089\067\011"), 
					Media = _feS8k, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\115\035\106\094\112\106\125\066\106\125\016\106\052\007\125\065\094\052\106\083\006\035\125\110\089\085\071\125\089\085\011"), 
								Media = _feS8k, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.Command "StopSound"
										_T52.Name = _Hk9("\122\071\106\125\018\124\058\071\125\059\083\125\018\058\071\106\124\094\085\106\124")
										_ZDSD.Commands._vzD6.Enabled = false
										_ZDSD.Commands._rV1Q.Enabled = true
										_T52.Active = false
										_Kk5I = 0
										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _ZDSD:On_rV1Q(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\064\059\006\125\085\052\007\125\071\059\035\108\089\124\017\125\085\071\106\125\018\124\058\071\125\006\019\125\066\006\085\125\124\059\085\125\067\006\065\071\125\071\094\019\019\106\124\112\011"), 
		Media = _BnyC, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _ZDSD:On_7ysPN(target)
	_ebuWk:Stop()
	_Urwigo.MessageBox{
		Text = _Hk9("\064\059\006\125\071\059\035\108\125\085\071\106\125\018\124\058\071\125\059\083\125\018\058\071\106\124\094\085\106\124\125\071\089\017\071\125\089\124\125\085\071\106\125\094\089\052\011\125\018\125\066\052\089\017\071\085\125\035\089\017\071\085\125\106\067\089\085\112\125\083\059\052\085\071\125\083\052\059\067\125\085\071\106\125\018\124\058\071\011"), 
		Media = _BnyC, 
		Callback = function(action)
			if action ~= nil then
				_rKz:Start()
			end
		end
	}
end
function _BJqI:On_0jg(target)
	_rP1:MoveTo(Player)
	_5OLq:MoveTo(Player)
	_xsr.Active = true
	_yp1.Active = true
end
function _mTI:On_O60p0(target)
	_Urwigo.MessageBox{
		Text = _Hk9("\123\085\125\089\112\125\007\059\006\052\125\085\052\006\112\085\106\108\125\124\059\085\106\019\094\108\125\094\124\108\125\019\106\124\065\089\035\011"), 
		Media = _kgJ
	}
end
function _mTI:On_ZkcZ(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_eNG)
	end)
end
function _Urwigo.GlobalZoneProximity()
	_3Nho1:RequestSync()
end
function _Urwigo.GlobalZoneActiveChanged()
	_3Nho1:RequestSync()
end

-- Urwigo functions --
function _Hkx()
	Wherigo.PlayAudio(_J80)
	_Urwigo.MessageBox{
		Text = _Hk9("\122\071\106\125\019\071\059\124\106\125\052\089\124\017\112\125\094\124\108\125\085\071\106\125\019\052\059\083\106\112\112\059\052\125\019\089\065\058\112\125\006\019\125\085\071\106\125\019\071\059\124\106\011\125\064\059\006\125\071\106\094\052\125\059\016\106\052\125\085\071\106\125\052\106\065\106\089\016\106\052\119"), 
		Media = _tJ5, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _Hk9("\053\106\035\035\059\125\062\052\011\125\053\106\089\124\052\089\065\071\043\125\085\071\089\112\125\089\112\125\108\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106\011\125\057\059\067\106\085\071\089\124\017\125\071\094\112\125\071\094\019\019\106\124\106\108\043\125\065\059\067\106\125\085\059\125\085\071\106\125\019\059\035\089\065\106\125\112\085\094\085\089\059\124\125\052\089\017\071\085\125\094\110\094\007\041"), 
					Media = _89gA, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\115\052\059\083\106\112\112\059\052\125\053\106\089\124\052\089\065\071\119\125\123\125\006\124\108\106\112\085\094\124\108\043\125\123\125\110\089\035\035\125\108\052\089\016\106\125\085\059\125\085\071\106\125\019\059\035\089\065\106\125\112\085\094\085\089\059\124\125\124\059\110\011"), 
								Media = _89gA, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _Hk9("\051\106\085\112\125\071\106\094\108\125\085\059\125\085\071\106\125\019\059\035\089\065\106\125\112\085\094\085\089\059\124\011\125\096\106\106\085\125\067\106\125\059\016\106\052\125\085\071\106\052\106\011\125\123\085\125\110\089\035\035\125\066\106\125\117\006\089\065\058\106\052\125\089\083\125\007\059\006\125\108\052\089\016\106\125\083\052\059\067\125\085\071\089\112\125\019\059\089\124\085\125\059\124\011\125"), 
											Media = _feS8k, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.Command "StopSound"
													_xsr.Active = true
													_SiIHi.Commands._cDY.Enabled = true
													_SiIHi.Description = _Hk9("\062\052\011\125\053\106\089\124\052\089\065\071\125\089\112\125\110\094\089\085\089\124\017\125\089\124\125\085\071\106\125\019\059\035\089\065\106\125\112\085\094\085\089\059\124\011")
													_SiIHi:MoveTo(_xsr)
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _i7H()
	_Urwigo.MessageBox{
		Text = _Hk9("\122\071\059\006\112\094\124\108\112\125\059\083\125\007\106\094\052\112\125\094\017\059\043\125\102\089\124\017\125\018\067\106\124\071\059\085\106\019\125\123\037\125\052\106\089\017\124\106\108\125\094\112\125\019\071\094\052\094\059\071\125\059\016\106\052\125\094\035\035\125\059\083\125\046\017\007\019\085\011\125"), 
		Media = _R3A, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _Hk9("\018\067\106\124\071\059\085\106\019\125\110\094\112\125\094\124\125\106\111\085\052\106\067\106\035\007\125\019\059\110\106\052\083\006\035\125\052\006\035\106\052\125\094\124\108\125\071\106\125\108\106\083\089\106\108\125\085\071\106\125\094\124\065\089\106\124\085\125\085\052\094\108\089\085\089\059\124\112\125\066\007\125\106\112\085\094\066\035\089\112\071\089\124\017\125\094\125\124\106\110\125\052\106\035\089\017\089\059\124\125\085\071\094\085\125\066\106\035\089\106\016\106\108\125\089\124\125\059\124\106\125\017\059\108\015\125\085\071\106\125\112\006\124\125\017\059\108\125\018\085\106\124\011\125"), 
					Media = _K87, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\018\067\106\124\071\059\085\106\019\125\123\037\125\065\071\094\124\017\106\108\125\071\089\112\125\124\094\067\106\125\085\059\125\018\058\071\106\124\094\085\106\124\125\094\124\108\125\019\052\059\065\035\094\089\067\106\108\125\071\089\067\112\106\035\083\125\094\112\125\085\071\106\125\108\089\016\089\124\106\125\052\006\035\106\052\125\059\016\106\052\125\094\035\035\125\059\083\125\046\017\007\019\085\011"), 
								Media = _5N2tX, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _Hk9("\018\058\071\106\124\094\085\106\124\125\106\052\106\065\085\106\108\125\067\094\124\007\125\017\052\106\094\085\125\110\059\052\058\112\125\089\124\125\071\089\112\125\059\110\124\125\071\059\124\059\052\043\125\066\006\085\125\094\112\125\071\089\112\125\019\059\110\106\052\125\017\052\106\110\125\112\059\125\094\035\112\059\125\017\052\106\110\125\108\089\112\035\059\007\094\035\085\007\125\094\067\059\124\017\125\071\089\112\125\083\059\035\035\059\110\106\052\112\011\125"), 
											Media = _iit1b, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _Hk9("\053\089\112\125\083\059\035\035\059\110\106\052\112\125\019\035\059\085\085\106\108\125\085\059\125\058\089\035\035\125\071\089\067\125\094\124\108\125\059\124\106\125\124\089\017\071\085\043\125\006\124\108\106\052\125\085\071\106\125\035\089\017\071\085\125\059\083\125\094\125\083\006\035\035\125\067\059\059\124\043\125\018\058\071\106\124\094\085\106\124\125\110\094\112\125\065\094\019\085\006\052\106\108\125\094\124\108\125\085\094\058\106\124\125\085\059\125\085\071\106\125\046\017\007\019\085\089\094\124\125\097\089\085\007\125\059\083\125\085\071\106\125\062\106\094\108\119\125\053\094\067\006\124\094\019\085\052\094\043\125\110\071\106\052\106\125\071\106\125\110\094\112\125\085\059\125\066\106\125\067\006\067\067\089\083\089\106\108\125\094\035\089\016\106\011"), 
														Media = _qzXFo, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _Hk9("\018\083\085\106\052\125\018\058\071\106\124\094\085\106\124\112\125\083\059\035\035\059\110\106\052\112\125\067\006\067\067\089\083\089\106\108\125\071\089\067\043\125\094\125\065\006\052\112\106\125\110\094\112\125\019\035\094\065\106\108\125\006\019\059\124\125\071\089\112\125\085\059\067\066\125\085\071\094\085\125\089\083\125\106\016\106\052\125\085\071\106\125\112\006\124\125\017\059\108\125\110\094\112\125\085\059\125\112\106\106\125\085\071\106\125\035\089\017\071\085\125\059\083\125\085\071\106\125\083\006\035\035\125\067\059\059\124\043\125\071\106\125\110\059\006\035\108\125\059\124\065\106\125\094\017\094\089\124\125\052\089\112\106\125\085\059\125\110\094\035\058\125\085\071\106\125\106\094\052\085\071\125\094\112\125\094\125\035\089\016\089\124\017\125\108\106\094\108\011\125"), 
																	Media = _4Dzp, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _Hk9("\122\071\094\085\125\089\112\125\085\071\106\125\106\124\108\125\059\083\125\071\089\112\085\059\052\007\125\035\106\112\112\059\124\043\125\066\006\085\125\123\125\094\067\125\094\083\052\094\089\108\125\124\059\085\125\059\083\125\085\071\106\125\112\085\059\052\007\011\125\064\059\006\125\112\106\106\125\085\071\052\106\106\125\124\089\017\071\085\112\125\094\017\059\125\110\071\106\124\125\085\071\106\125\112\094\052\065\059\019\071\094\017\006\112\125\110\094\112\125\108\106\035\089\016\106\052\106\108\043\125\089\085\125\110\094\112\125\006\124\108\106\052\125\085\071\106\125\035\089\017\071\085\125\059\083\125\094\125\083\006\035\035\125\067\059\059\124\011\125"), 
																				Media = _feS8k, 
																				Callback = function(action)
																					if action ~= nil then
																						_Urwigo.MessageBox{
																							Text = _Hk9("\122\071\106\125\124\106\111\085\125\067\059\052\124\089\124\017\125\110\071\106\124\125\123\125\110\106\124\085\125\085\059\125\065\071\106\065\058\125\085\071\106\125\106\111\071\089\066\089\085\043\125\085\071\106\125\112\094\052\065\059\019\071\094\017\006\112\125\110\094\112\125\106\067\019\085\007\011\125\123\125\083\106\094\052\125\085\071\106\125\110\059\052\112\085\119\125\085\071\106\125\067\006\067\067\007\125\071\094\112\125\052\089\112\106\124\041"), 
																							Media = _feS8k, 
																							Callback = function(action)
																								if action ~= nil then
																									_Hkx()
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _EV1()
	if _RWHIt > 0 then
		local _rndChoiceValue = math.random()
		if _rndChoiceValue < 0.25 then
			_RWHIt = _RWHIt - 1
			Wherigo.PlayAudio(_hiw1)
			_Urwigo.MessageBox{
				Text = (_Hk9("\064\059\006\125\112\071\059\059\085\125\094\085\125\085\071\106\125\067\006\067\067\007\125\094\124\108\125\071\089\085\125\071\089\067\125\108\106\094\108\125\059\124\011\125\053\106\125\112\085\094\017\017\106\052\112\125\085\059\125\085\071\106\125\112\089\108\106\011\125\064\059\006\052\125\065\006\052\052\106\124\085\125\094\067\067\059\125\089\112\125").._RWHIt).._Hk9("\125\011"), 
				Media = _a30x0, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
						_rJPzi = _rJPzi - 1
						if _rJPzi == 0 then
							_ebuWk:Stop()
							_Urwigo.MessageBox{
								Text = _Hk9("\072\059\110\041\041\041\125\064\059\006\125\085\059\059\058\125\108\059\110\124\125\085\071\106\125\067\006\067\067\007\011\125\072\071\059\125\110\059\006\035\108\125\071\094\016\106\125\058\124\059\110\124\125\089\085\125\110\094\112\125\019\059\112\112\089\066\035\106\125\006\112\089\124\017\125\094\125\112\071\059\085\017\006\124\012"), 
								Media = _Gcf0, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.PlayAudio(_hb9GP)
										_QUP0_.Complete = true
										_Urwigo.MessageBox{
											Text = _Hk9("\122\071\106\125\067\006\067\067\007\125\083\094\035\035\112\125\085\059\125\085\071\106\125\017\052\059\006\124\108\125\108\106\083\106\094\085\106\108\011"), 
											Media = _suJf, 
											Callback = function(action)
												if action ~= nil then
													_5rNkE()
												end
											end
										}
									end
								end
							}
						else
						end
					end
				end
			}
			_5OLq.Description = (_Hk9("\064\059\006\052\125\065\006\052\052\106\124\085\125\094\067\067\059\125\089\112\125").._RWHIt).._Hk9("\125\011")
		elseif _rndChoiceValue < 0.5 then
			_RWHIt = _RWHIt - 1
			Wherigo.PlayAudio(_hiw1)
			_Urwigo.MessageBox{
				Text = (_Hk9("\064\059\006\125\112\071\059\059\085\125\094\085\125\085\071\106\125\067\006\067\067\007\125\066\006\085\125\059\124\035\007\125\019\094\052\085\089\094\035\035\007\125\071\089\085\125\071\089\067\011\125\053\106\125\112\085\094\017\017\106\052\112\125\085\059\125\085\071\106\125\112\089\108\106\011\125\064\059\006\052\125\065\006\052\052\106\124\085\125\094\067\067\059\125\089\112\125").._RWHIt).._Hk9("\125\011"), 
				Media = _a30x0, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
						_rJPzi = _rJPzi - 1
						if _rJPzi == 0 then
							_ebuWk:Stop()
							_Urwigo.MessageBox{
								Text = _Hk9("\072\059\110\041\041\041\125\064\059\006\125\085\059\059\058\125\108\059\110\124\125\085\071\106\125\067\006\067\067\007\011\125\072\071\059\125\110\059\006\035\108\125\071\094\016\106\125\058\124\059\110\124\125\089\085\125\110\094\112\125\019\059\112\112\089\066\035\106\125\006\112\089\124\017\125\094\125\112\071\059\085\017\006\124\012"), 
								Media = _Gcf0, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.PlayAudio(_hb9GP)
										_QUP0_.Complete = true
										_Urwigo.MessageBox{
											Text = _Hk9("\122\071\106\125\067\006\067\067\007\125\083\094\035\035\112\125\085\059\125\085\071\106\125\017\052\059\006\124\108\125\108\106\083\106\094\085\106\108\011"), 
											Media = _suJf, 
											Callback = function(action)
												if action ~= nil then
													_5rNkE()
												end
											end
										}
									end
								end
							}
						else
						end
					end
				end
			}
			_5OLq.Description = (_Hk9("\064\059\006\052\125\065\006\052\052\106\124\085\125\094\067\067\059\125\089\112\125").._RWHIt).._Hk9("\125\011")
		elseif _rndChoiceValue < 0.75 then
			_RWHIt = _RWHIt - 1
			Wherigo.PlayAudio(_hiw1)
			_Urwigo.MessageBox{
				Text = _Hk9("\064\059\006\125\112\071\059\059\085\125\085\071\106\125\067\006\067\067\007\125\094\124\108\125\065\059\067\019\035\106\085\106\035\007\125\067\089\112\112\125\071\089\067\011"), 
				Media = _a30x0, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
					end
				end
			}
			_5OLq.Description = (_Hk9("\064\059\006\052\125\065\006\052\052\106\124\085\125\094\067\067\059\125\089\112\125").._RWHIt).._Hk9("\125\011")
		else
			_RWHIt = _RWHIt - 1
			Wherigo.PlayAudio(_hiw1)
			_Urwigo.MessageBox{
				Text = _Hk9("\064\059\006\125\112\071\059\059\085\125\085\071\106\125\067\006\067\067\007\125\066\006\085\125\094\065\065\089\108\106\124\085\035\007\125\071\089\085\125\059\124\106\125\059\083\125\085\071\106\125\017\052\094\016\106\112\085\059\124\106\112\125\089\124\112\085\106\094\108\011"), 
				Media = _a30x0, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
					end
				end
			}
			_5OLq.Description = (_Hk9("\064\059\006\052\125\065\006\052\052\106\124\085\125\094\067\067\059\125\089\112\125").._RWHIt).._Hk9("\125\011")
		end
	elseif _RWHIt == 0 then
		_Urwigo.MessageBox{
			Text = _Hk9("\064\059\006\125\094\052\106\125\094\035\035\125\059\006\085\125\059\083\125\094\067\067\059\125\094\124\108\125\110\089\035\035\125\124\106\106\108\125\085\059\125\052\106\035\059\094\108\011"), 
			Media = _a30x0
		}
	end
end
function _5KnZR()
	if _RWHIt > 0 then
		_RWHIt = _RWHIt - 1
		Wherigo.PlayAudio(_hiw1)
		if true then
			_5OLq.Description = (_Hk9("\064\059\006\052\125\065\006\052\052\106\124\085\125\094\067\067\059\125\089\112\125").._RWHIt).._Hk9("\125\011")
			_Urwigo.MessageBox{
				Text = (_Hk9("\064\059\006\125\083\089\052\106\125\059\083\083\125\094\125\052\059\006\124\108\125\089\124\085\059\125\085\071\106\125\094\089\052\011\125\064\059\006\052\125\065\006\052\052\106\124\085\125\094\067\067\059\125\089\112\125").._RWHIt).._Hk9("\125\011"), 
				Media = _a30x0, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
					end
				end
			}
		end
	elseif _RWHIt == 0 then
		_Urwigo.MessageBox{
			Text = _Hk9("\064\059\006\125\094\052\106\125\094\035\035\125\059\006\085\125\059\083\125\094\067\067\059\125\094\124\108\125\110\089\035\035\125\124\106\106\108\125\085\059\125\052\106\035\059\094\108\011"), 
			Media = _a30x0
		}
	end
end
function _5rNkE()
	Wherigo.PlayAudio(_yVITk)
	_Urwigo.MessageBox{
		Text = _Hk9("\062\052\011\125\053\106\089\124\052\089\065\071\125\094\124\108\125\062\106\085\106\065\085\089\016\106\125\096\094\035\059\124\106\125\010\006\067\019\125\006\019\125\089\124\125\085\071\106\125\094\089\052\125\110\089\085\071\125\010\059\007\041"), 
		Media = _nw6Gm, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _Hk9("\072\059\110\041\125\123\125\108\089\108\124\005\085\125\085\071\089\124\058\125\089\085\125\110\094\112\125\019\059\112\112\089\066\035\106\011"), 
					Media = _Cb3, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _Hk9("\123\125\065\094\124\005\085\125\066\106\035\089\106\016\106\125\007\059\006\125\108\089\108\125\089\085\041"), 
								Media = _feS8k, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _Hk9("\123\125\065\094\124\125\071\094\124\108\035\106\125\085\071\106\125\112\089\085\006\094\085\089\059\124\125\083\052\059\067\125\071\106\052\106\011\125\123\125\110\089\035\035\125\066\106\125\052\106\085\006\052\124\089\124\017\125\085\071\106\125\067\006\067\067\007\125\085\059\125\071\089\112\125\083\089\124\094\035\125\052\106\112\085\089\124\017\125\019\035\094\065\106\011"), 
											Media = _feS8k, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _Hk9("\122\071\094\124\058\125\007\059\006\125\112\059\125\067\006\065\071\125\083\059\052\125\094\035\035\125\059\083\125\007\059\006\052\125\071\106\035\019\011\125\070\124\083\059\052\085\006\124\094\085\106\035\007\125\089\085\125\035\059\059\058\112\125\035\089\058\106\125\085\071\106\125\094\052\085\089\083\094\065\085\112\125\083\052\059\067\125\085\071\106\125\106\111\071\089\066\089\085\125\094\052\106\125\112\085\089\035\035\125\067\089\112\112\089\124\017\125\085\071\059\006\017\071\011"), 
														Media = _feS8k, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _Hk9("\062\052\011\125\053\106\089\124\052\089\065\071\125\052\106\094\065\071\106\112\125\059\016\106\052\125\085\059\125\106\111\094\067\089\124\106\125\085\071\106\125\067\006\067\067\007\125\094\124\108\125\019\006\035\035\112\125\094\125\019\094\019\007\052\006\112\125\112\065\052\059\035\035\125\083\052\059\067\125\006\124\108\106\052\124\106\094\085\071\125\085\071\106\125\067\006\067\067\089\106\112\125\066\094\124\108\094\017\106\112\011"), 
																	Media = _t_Ykx, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _Hk9("\123\085\005\112\125\094\125\067\094\019\125\085\059\125\085\071\106\125\067\089\112\112\089\124\017\125\094\052\085\089\083\094\065\085\112\041"), 
																				Media = _vvk, 
																				Callback = function(action)
																					if action ~= nil then
																						_KoHOe:MoveTo(Player)
																						_0Jiq.Active = true
																						_6dp5L.Active = false
																						_5OLq.Commands._3W6T.Enabled = false
																						_5OLq.Commands._Lq_Qr.Enabled = true
																						_SiIHi:MoveTo(_4N_ia)
																						_SiIHi.Commands._NpPn.Enabled = false
																						_Urwigo.MessageBox{
																							Text = _Hk9("\115\106\052\071\094\019\112\125\007\059\006\125\065\094\124\125\006\112\106\125\085\071\089\112\125\067\094\019\125\085\059\125\083\089\124\108\125\085\071\106\125\085\071\106\125\067\089\112\112\089\124\017\125\094\052\085\089\083\094\065\085\112\011\125\123\125\110\089\035\035\125\066\106\125\071\106\094\108\089\124\017\125\066\094\065\058\125\085\059\125\085\071\106\125\094\052\065\071\089\016\106\112\125\124\059\110\011\125\122\071\094\124\058\112\125\094\017\094\089\124\125\083\059\052\125\094\035\035\125\059\083\125\007\059\006\052\125\071\106\035\019\011"), 
																							Media = _feS8k, 
																							Callback = function(action)
																								if action ~= nil then
																									_SiIHi.Commands._cDY.Enabled = false
																									_SiIHi.Description = _Hk9("\062\052\011\125\053\106\089\124\052\089\065\071\125\089\112\125\059\016\106\052\010\059\007\106\108\125\007\059\006\125\083\059\006\124\108\125\071\089\112\125\067\089\112\112\089\124\017\125\106\111\071\089\066\089\085\011")
																									_6dp5L.Active = true
																									_yp1.Active = false
																									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _LWln()
	if _wtR > 0 then
		_RWHIt = 6
		_wtR = _wtR - 1
		_rP1.Description = (_Hk9("\064\059\006\125\065\006\052\052\106\124\085\035\007\125\071\094\016\106\125").._wtR).._Hk9("\125\066\059\111\106\023\112\047\125\059\083\125\112\071\106\035\035\112\011")
		_5OLq.Description = (_Hk9("\064\059\006\052\125\065\006\052\052\106\124\085\125\094\067\067\059\125\089\112\125").._RWHIt).._Hk9("\125\011")
		Wherigo.PlayAudio(_fZBK)
		_Urwigo.MessageBox{
			Text = (_Hk9("\064\059\006\125\052\106\035\059\094\108\125\007\059\006\052\125\017\006\124\011\125\064\059\006\125\071\094\016\106\125").._wtR).._Hk9("\125\066\059\111\106\023\112\047\125\059\083\125\112\071\106\035\035\112\125\035\106\083\085\011"), 
			Media = _mw4KC, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _Hk9("\064\059\006\125\094\052\106\125\065\059\067\019\035\106\085\106\035\007\125\059\006\085\125\059\083\125\094\067\067\059\011"), 
			Media = _mw4KC, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end

-- Begin user functions --
-- End user functions --
return _3Nho1
