require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _O5Os(str)
	local res = ""
    local dtable = "\084\043\082\123\066\090\053\083\107\063\005\117\040\101\042\026\067\097\100\086\099\006\064\075\057\120\119\046\105\121\124\055\062\002\058\078\032\102\118\110\001\008\003\114\108\052\122\038\007\091\004\049\125\021\041\039\096\009\044\079\054\081\095\113\011\111\126\028\059\056\089\061\088\030\037\070\023\076\115\025\024\017\010\036\065\103\098\029\031\092\015\051\035\047\068\072\093\016\033\045\106\050\000\085\012\018\071\104\112\034\022\116\080\014\020\013\077\060\048\074\087\069\094\109\027\073\019"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

cartZooventurePenguinEscape = Wherigo.ZCartridge()

-- Media --
zmediaAlarmClcok = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaAlarmClcok.Id = "959e0d9c-3424-4b75-b4db-a30a6d4c8a5a"
zmediaAlarmClcok.Name = _O5Os("\085\045\018\044\124\017\045\021\066\009")
zmediaAlarmClcok.Description = ""
zmediaAlarmClcok.AltText = ""
zmediaAlarmClcok.Resources = {
	{
		Type = "jpg", 
		Filename = "alarmclock_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "alarmclock_garmin.jpg", 
		Directives = {}
	}
}
zmediaAlarmClock_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaAlarmClock_MSG.Id = "113ae463-94e5-4b87-8a26-a247537ec620"
zmediaAlarmClock_MSG.Name = _O5Os("\085\045\018\044\124\017\045\066\021\009\063\117\008\107")
zmediaAlarmClock_MSG.Description = ""
zmediaAlarmClock_MSG.AltText = ""
zmediaAlarmClock_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "alarmclockmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "alarmclockmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaBenthePenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaBenthePenguin.Id = "b1d44275-da3d-4501-a712-9df8336a0df7"
zmediaBenthePenguin.Name = _O5Os("\005\014\040\112\108\014\113\014\040\086\012\029\040")
zmediaBenthePenguin.Description = ""
zmediaBenthePenguin.AltText = ""
zmediaBenthePenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "benpenguin_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "benpenguin_garmin.jpg", 
		Directives = {}
	}
}
zmediaBenthePenguin_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaBenthePenguin_MSG.Id = "7ce5a514-8fa8-494c-b79d-8b4da5576190"
zmediaBenthePenguin_MSG.Name = _O5Os("\005\014\040\112\108\014\113\014\040\086\012\029\040\063\117\008\107")
zmediaBenthePenguin_MSG.Description = ""
zmediaBenthePenguin_MSG.AltText = ""
zmediaBenthePenguin_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "benpenguinmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "benpenguinmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaBrianthePenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaBrianthePenguin.Id = "34b2abf2-0f2e-4ac3-89db-9f73445756d9"
zmediaBrianthePenguin.Name = _O5Os("\005\044\029\018\040\112\108\014\113\014\040\086\012\029\040")
zmediaBrianthePenguin.Description = ""
zmediaBrianthePenguin.AltText = ""
zmediaBrianthePenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "brianpenguin_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "brianpenguin_garmin.jpg", 
		Directives = {}
	}
}
zmediaBrianthePenguin_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaBrianthePenguin_MSG.Id = "25a91485-cc84-4868-9c05-221736b4d257"
zmediaBrianthePenguin_MSG.Name = _O5Os("\005\044\029\018\040\112\108\014\113\014\040\086\012\029\040\063\117\008\107")
zmediaBrianthePenguin_MSG.Description = ""
zmediaBrianthePenguin_MSG.AltText = ""
zmediaBrianthePenguin_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "brianpenguinmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "brianpenguinmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaBrownBear = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaBrownBear.Id = "8b11caa6-6a2a-47a1-aa7b-5ec77daa9573"
zmediaBrownBear.Name = _O5Os("\005\044\066\027\040\005\014\018\044")
zmediaBrownBear.Description = ""
zmediaBrownBear.AltText = ""
zmediaBrownBear.Resources = {
	{
		Type = "jpg", 
		Filename = "brownbear_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "brownbear_garmin.jpg", 
		Directives = {}
	}
}
zmediaBrownBear_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaBrownBear_MSG.Id = "6f01a802-4e3f-4ac7-be68-7ca593937df2"
zmediaBrownBear_MSG.Name = _O5Os("\005\044\066\027\040\005\014\018\044\063\117\008\107")
zmediaBrownBear_MSG.Description = ""
zmediaBrownBear_MSG.AltText = ""
zmediaBrownBear_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "brownbearmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "brownbearmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaBrownBearSleeping = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaBrownBearSleeping.Id = "f29f0125-28bd-41b4-8567-d36ef06fb143"
zmediaBrownBearSleeping.Name = _O5Os("\005\044\066\027\040\005\014\018\044\008\045\014\014\109\029\040\086")
zmediaBrownBearSleeping.Description = ""
zmediaBrownBearSleeping.AltText = ""
zmediaBrownBearSleeping.Resources = {
	{
		Type = "jpg", 
		Filename = "brownbearsleeping_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "brownbearsleeping_garmin.jpg", 
		Directives = {}
	}
}
zmediaBrownBearSleeping_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaBrownBearSleeping_MSG.Id = "528325a3-358e-4f8f-b733-0ada74b88414"
zmediaBrownBearSleeping_MSG.Name = _O5Os("\005\044\066\027\040\005\014\018\044\008\045\014\014\109\029\040\086\063\117\008\107")
zmediaBrownBearSleeping_MSG.Description = ""
zmediaBrownBearSleeping_MSG.AltText = ""
zmediaBrownBearSleeping_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "brownbearsleepingmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "brownbearsleepingmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaCake = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaCake.Id = "7aa9bd61-c59f-4318-97b7-2f022b439f1d"
zmediaCake.Name = _O5Os("\017\018\009\014")
zmediaCake.Description = ""
zmediaCake.AltText = ""
zmediaCake.Resources = {
	{
		Type = "jpg", 
		Filename = "cake_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "cake_garmin.jpg", 
		Directives = {}
	}
}
zmediaCake_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaCake_MSG.Id = "758c1610-1a2b-47f6-9b71-5565b6780e94"
zmediaCake_MSG.Name = _O5Os("\017\018\009\014\063\117\008\107")
zmediaCake_MSG.Description = ""
zmediaCake_MSG.AltText = ""
zmediaCake_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "cakemsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "cakemsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaColobus = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaColobus.Id = "b7baf352-8653-4eb5-b1b8-40c60d85932f"
zmediaColobus.Name = _O5Os("\017\066\045\066\087\012\079")
zmediaColobus.Description = ""
zmediaColobus.AltText = ""
zmediaColobus.Resources = {
	{
		Type = "jpg", 
		Filename = "colobus_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "colobus_garmin.jpg", 
		Directives = {}
	}
}
zmediaColobus_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaColobus_MSG.Id = "58e41daf-265f-4884-bfcb-3357a21d3d5a"
zmediaColobus_MSG.Name = _O5Os("\017\066\045\066\087\012\079\063\117\008\107")
zmediaColobus_MSG.Description = ""
zmediaColobus_MSG.AltText = ""
zmediaColobus_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "colobusmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "colobusmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaDrainPlug = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaDrainPlug.Id = "935822c8-9f00-4067-8c01-25a86fda64e8"
zmediaDrainPlug.Name = _O5Os("\095\044\018\029\040\113\045\012\086")
zmediaDrainPlug.Description = ""
zmediaDrainPlug.AltText = ""
zmediaDrainPlug.Resources = {
	{
		Type = "jpg", 
		Filename = "drainplug_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "drainplug_garmin.jpg", 
		Directives = {}
	}
}
zmediaDrainPlug_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaDrainPlug_MSG.Id = "f127d873-541a-4a3a-942c-6d27ee8003e1"
zmediaDrainPlug_MSG.Name = _O5Os("\095\044\018\029\040\113\045\012\086\063\117\008\107")
zmediaDrainPlug_MSG.Description = ""
zmediaDrainPlug_MSG.AltText = ""
zmediaDrainPlug_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "drainplugmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "drainplugmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaEgg = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaEgg.Id = "17ad5ca4-b304-4ab0-a0ef-468cd80bb436"
zmediaEgg.Name = _O5Os("\122\086\086")
zmediaEgg.Description = ""
zmediaEgg.AltText = ""
zmediaEgg.Resources = {
	{
		Type = "jpg", 
		Filename = "egg2_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "egg2_garmin.jpg", 
		Directives = {}
	}
}
zmediaEgg_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaEgg_MSG.Id = "597ccb5c-15a4-4fed-b705-3897184e5e5d"
zmediaEgg_MSG.Name = _O5Os("\122\086\086\063\117\008\107")
zmediaEgg_MSG.Description = ""
zmediaEgg_MSG.AltText = ""
zmediaEgg_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "egg2msg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "egg2msg_garmin.jpg", 
		Directives = {}
	}
}
zmediaEmptyFoliage = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaEmptyFoliage.Id = "0838164b-abb5-4ac1-bda1-18efe59adfcb"
zmediaEmptyFoliage.Name = _O5Os("\122\124\109\112\030\076\066\045\029\018\086\014")
zmediaEmptyFoliage.Description = ""
zmediaEmptyFoliage.AltText = ""
zmediaEmptyFoliage.Resources = {
	{
		Type = "jpg", 
		Filename = "emptyfoliage_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "emptyfoliage_garmin.jpg", 
		Directives = {}
	}
}
zmediaHappyPig = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaHappyPig.Id = "edbbeebb-a5aa-41fd-aaff-e9cc4bd719d7"
zmediaHappyPig.Name = _O5Os("\096\018\109\109\030\113\029\086")
zmediaHappyPig.Description = ""
zmediaHappyPig.AltText = ""
zmediaHappyPig.Resources = {
	{
		Type = "jpg", 
		Filename = "happypig_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "happypig_garmin.jpg", 
		Directives = {}
	}
}
zmediaHappyPig_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaHappyPig_MSG.Id = "24a2cc42-9dad-4f5b-9b51-254e66d920cb"
zmediaHappyPig_MSG.Name = _O5Os("\096\018\109\109\030\113\029\086\063\117\008\107")
zmediaHappyPig_MSG.Description = ""
zmediaHappyPig_MSG.AltText = ""
zmediaHappyPig_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "happypigmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "happypigmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaHen = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaHen.Id = "2d912544-2e02-4d88-927d-51fd9f26eef8"
zmediaHen.Name = _O5Os("\096\014\040")
zmediaHen.Description = ""
zmediaHen.AltText = ""
zmediaHen.Resources = {
	{
		Type = "jpg", 
		Filename = "hen_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "hen_garmin.jpg", 
		Directives = {}
	}
}
zmediaHen_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaHen_MSG.Id = "d88a4e6b-f226-4efd-8dd8-d76d69987c50"
zmediaHen_MSG.Name = _O5Os("\096\014\040\063\117\008\107")
zmediaHen_MSG.Description = ""
zmediaHen_MSG.AltText = ""
zmediaHen_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "henmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "henmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaHippo = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaHippo.Id = "84b96e04-3ce3-4ae8-aca6-be701e9ad753"
zmediaHippo.Name = _O5Os("\096\029\109\109\066")
zmediaHippo.Description = ""
zmediaHippo.AltText = ""
zmediaHippo.Resources = {
	{
		Type = "jpg", 
		Filename = "hippo_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "hippo_garmin.jpg", 
		Directives = {}
	}
}
zmediaHippo_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaHippo_MSG.Id = "c48bfabd-f8d1-45f1-b785-902ce4baf90c"
zmediaHippo_MSG.Name = _O5Os("\096\029\109\109\066\063\117\008\107")
zmediaHippo_MSG.Description = ""
zmediaHippo_MSG.AltText = ""
zmediaHippo_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "hippomsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "hippomsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaHoney = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaHoney.Id = "23b41b70-ead5-4970-92cf-c2fe1751fdb5"
zmediaHoney.Name = _O5Os("\096\066\040\014\030")
zmediaHoney.Description = ""
zmediaHoney.AltText = ""
zmediaHoney.Resources = {
	{
		Type = "jpg", 
		Filename = "honey_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "honey_garmin.jpg", 
		Directives = {}
	}
}
zmediaHoney_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaHoney_MSG.Id = "8481d68f-f1cf-4b54-a97a-68ef95c4b1af"
zmediaHoney_MSG.Name = _O5Os("\096\066\040\014\030\063\117\008\107")
zmediaHoney_MSG.Description = ""
zmediaHoney_MSG.AltText = ""
zmediaHoney_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "honeymsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "honeymsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaJaredthePenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaJaredthePenguin.Id = "f340758d-73e7-4dd4-a81c-74e1827755a7"
zmediaJaredthePenguin.Name = _O5Os("\120\018\044\014\019\112\108\014\113\014\040\086\012\029\040")
zmediaJaredthePenguin.Description = ""
zmediaJaredthePenguin.AltText = ""
zmediaJaredthePenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "jaredpenguin_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "jaredpenguin_garmin.jpg", 
		Directives = {}
	}
}
zmediaJaredthePenguin_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaJaredthePenguin_MSG.Id = "952a979d-7bbb-409b-a723-6a4873899efe"
zmediaJaredthePenguin_MSG.Name = _O5Os("\120\018\044\014\019\112\108\014\113\014\040\086\012\029\040\063\117\008\107")
zmediaJaredthePenguin_MSG.Description = ""
zmediaJaredthePenguin_MSG.AltText = ""
zmediaJaredthePenguin_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "jaredpenguinmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "jaredpenguinmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaJenthePenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaJenthePenguin.Id = "ecf6aab1-10dc-443d-8e20-d4939d9f449c"
zmediaJenthePenguin.Name = _O5Os("\120\014\040\112\108\014\113\014\040\086\012\029\040")
zmediaJenthePenguin.Description = ""
zmediaJenthePenguin.AltText = ""
zmediaJenthePenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "jenpenguin_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "jenpenguin_garmin.jpg", 
		Directives = {}
	}
}
zmediaJenthePenguin_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaJenthePenguin_MSG.Id = "3cb40882-d210-4927-96b1-d3fa54e4a485"
zmediaJenthePenguin_MSG.Name = _O5Os("\120\014\040\112\108\014\113\014\040\086\012\029\040\063\117\008\107")
zmediaJenthePenguin_MSG.Description = ""
zmediaJenthePenguin_MSG.AltText = ""
zmediaJenthePenguin_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "jenpenguinmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "jenpenguinmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaKokothePenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaKokothePenguin.Id = "ddba811a-1b33-45f5-87ac-49b0fd3a346e"
zmediaKokothePenguin.Name = _O5Os("\024\066\009\066\112\108\014\113\014\040\086\012\029\040")
zmediaKokothePenguin.Description = ""
zmediaKokothePenguin.AltText = ""
zmediaKokothePenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "kokopenguin_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "kokopenguin_garmin.jpg", 
		Directives = {}
	}
}
zmediaKokothePenguin_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaKokothePenguin_MSG.Id = "6895e204-199d-4432-8adb-9ddb36fc1038"
zmediaKokothePenguin_MSG.Name = _O5Os("\024\066\009\066\112\108\014\113\014\040\086\012\029\040\063\117\008\107")
zmediaKokothePenguin_MSG.Description = ""
zmediaKokothePenguin_MSG.AltText = ""
zmediaKokothePenguin_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "kokopenguinmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "kokopenguinmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaLemon = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaLemon.Id = "006ebf6d-e2cd-4e8e-8c59-31a83099eb02"
zmediaLemon.Name = _O5Os("\078\014\124\066\040")
zmediaLemon.Description = ""
zmediaLemon.AltText = ""
zmediaLemon.Resources = {
	{
		Type = "jpg", 
		Filename = "lemon_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "lemon_garmin.jpg", 
		Directives = {}
	}
}
zmediaLemon_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaLemon_MSG.Id = "793a8527-b552-4623-a1bd-dc43e658f79c"
zmediaLemon_MSG.Name = _O5Os("\078\014\124\066\040\063\117\008\107")
zmediaLemon_MSG.Description = ""
zmediaLemon_MSG.AltText = ""
zmediaLemon_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "lemonmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "lemonmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaOrangMap = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaOrangMap.Id = "d08a931f-050b-4b1a-bd5e-178078f0936c"
zmediaOrangMap.Name = _O5Os("\060\044\018\040\086\117\018\109")
zmediaOrangMap.Description = ""
zmediaOrangMap.AltText = ""
zmediaOrangMap.Resources = {
	{
		Type = "jpg", 
		Filename = "orangmap_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "orangmap_garmin.jpg", 
		Directives = {}
	}
}
zmediaOrangutan1 = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaOrangutan1.Id = "c1536e0c-3de5-4be3-a5f4-29c6ba35ec0a"
zmediaOrangutan1.Name = _O5Os("\060\044\018\040\086\012\112\018\040\052")
zmediaOrangutan1.Description = ""
zmediaOrangutan1.AltText = ""
zmediaOrangutan1.Resources = {
	{
		Type = "jpg", 
		Filename = "orangutan1_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "orangutan1_garmin.jpg", 
		Directives = {}
	}
}
zmediaOrangutan2 = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaOrangutan2.Id = "4c9ff2bc-b8cd-43de-8223-f2dc9c77aec7"
zmediaOrangutan2.Name = _O5Os("\060\044\018\040\086\012\112\018\040\102")
zmediaOrangutan2.Description = ""
zmediaOrangutan2.AltText = ""
zmediaOrangutan2.Resources = {
	{
		Type = "jpg", 
		Filename = "orangutan2_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "orangutan2_garmin.jpg", 
		Directives = {}
	}
}
zmediaOrangutanPenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaOrangutanPenguin.Id = "6bedd031-508d-4d76-a02a-493f287045bf"
zmediaOrangutanPenguin.Name = _O5Os("\060\044\018\040\086\012\112\018\040\113\014\040\086\012\029\040")
zmediaOrangutanPenguin.Description = ""
zmediaOrangutanPenguin.AltText = ""
zmediaOrangutanPenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "orangutanpenguin_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "orangutanpenguin_garmin.jpg", 
		Directives = {}
	}
}
zmediaPenguins = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaPenguins.Id = "906f109c-4045-47fd-a56d-437fe18e213d"
zmediaPenguins.Name = _O5Os("\113\014\040\086\012\029\040\079")
zmediaPenguins.Description = ""
zmediaPenguins.AltText = ""
zmediaPenguins.Resources = {
	{
		Type = "jpg", 
		Filename = "penguingroup_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "penguingroup_garmin.jpg", 
		Directives = {}
	}
}
zmediaPenguins_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaPenguins_MSG.Id = "75f5d2e3-b906-49f1-bc8f-6baa4a3324a5"
zmediaPenguins_MSG.Name = _O5Os("\113\014\040\086\012\029\040\079\063\117\008\107")
zmediaPenguins_MSG.Description = ""
zmediaPenguins_MSG.AltText = ""
zmediaPenguins_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "penguingroupmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "penguingroupmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaPinkBackGorilla = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaPinkBackGorilla.Id = "ef907420-4015-47a5-a24a-6e52b9cc3b8d"
zmediaPinkBackGorilla.Name = _O5Os("\113\029\040\009\005\018\021\009\107\066\044\029\045\045\018")
zmediaPinkBackGorilla.Description = ""
zmediaPinkBackGorilla.AltText = ""
zmediaPinkBackGorilla.Resources = {
	{
		Type = "jpg", 
		Filename = "pinkbackgorilla_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "pinkbackgorilla_garmin.jpg", 
		Directives = {}
	}
}
zmediaPinkBackGorilla_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaPinkBackGorilla_MSG.Id = "bfee3169-65ec-4519-9681-69a12e277c12"
zmediaPinkBackGorilla_MSG.Name = _O5Os("\113\029\040\009\005\018\021\009\107\066\044\029\045\045\018\063\117\008\107")
zmediaPinkBackGorilla_MSG.Description = ""
zmediaPinkBackGorilla_MSG.AltText = ""
zmediaPinkBackGorilla_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "pinkbackgorillamsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "pinkbackgorillamsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaPython = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaPython.Id = "69531233-c52f-45a9-8a29-75d6bd601573"
zmediaPython.Name = _O5Os("\113\030\112\108\066\040")
zmediaPython.Description = ""
zmediaPython.AltText = ""
zmediaPython.Resources = {
	{
		Type = "jpg", 
		Filename = "python_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "python_garmin.jpg", 
		Directives = {}
	}
}
zmediaPython_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaPython_MSG.Id = "92f30158-b676-4474-a949-24a618aea918"
zmediaPython_MSG.Name = _O5Os("\113\030\112\108\066\040\063\117\008\107")
zmediaPython_MSG.Description = ""
zmediaPython_MSG.AltText = ""
zmediaPython_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "pythonmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "pythonmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaSadPig = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSadPig.Id = "37499b24-dbcf-48a2-a9a4-788b4b13e565"
zmediaSadPig.Name = _O5Os("\008\018\019\113\029\086")
zmediaSadPig.Description = ""
zmediaSadPig.AltText = ""
zmediaSadPig.Resources = {
	{
		Type = "jpg", 
		Filename = "sadpig_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "sadpig_garmin.jpg", 
		Directives = {}
	}
}
zmediaSadPig_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSadPig_MSG.Id = "decc192f-605b-4133-9d2c-65111ff593ec"
zmediaSadPig_MSG.Name = _O5Os("\008\018\019\113\029\086\063\117\008\107")
zmediaSadPig_MSG.Description = ""
zmediaSadPig_MSG.AltText = ""
zmediaSadPig_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "sadpigmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "sadpigmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaSadTiger = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSadTiger.Id = "eb610bd7-ea32-456d-b93a-b393986e6715"
zmediaSadTiger.Name = _O5Os("\008\018\019\001\029\086\014\044")
zmediaSadTiger.Description = ""
zmediaSadTiger.AltText = ""
zmediaSadTiger.Resources = {
	{
		Type = "jpg", 
		Filename = "sadtiger_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "sadtiger_garmin.jpg", 
		Directives = {}
	}
}
zmediaSadTiger_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSadTiger_MSG.Id = "b334f45f-0a83-4589-bc32-cd7e8a2be398"
zmediaSadTiger_MSG.Name = _O5Os("\008\018\019\001\029\086\014\044\063\117\008\107")
zmediaSadTiger_MSG.Description = ""
zmediaSadTiger_MSG.AltText = ""
zmediaSadTiger_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "sadtigermsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "sadtigermsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaShampoo = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaShampoo.Id = "bfae6e42-dc41-49bc-a890-7cf668b9cc77"
zmediaShampoo.Name = _O5Os("\008\108\018\124\109\066\066")
zmediaShampoo.Description = ""
zmediaShampoo.AltText = ""
zmediaShampoo.Resources = {
	{
		Type = "jpg", 
		Filename = "shampoo_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "shampoo_garmin.jpg", 
		Directives = {}
	}
}
zmediaShampoo_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaShampoo_MSG.Id = "e08b19a8-d763-41d1-b4b1-6b07de98f81e"
zmediaShampoo_MSG.Name = _O5Os("\008\108\018\124\109\066\066\063\117\008\107")
zmediaShampoo_MSG.Description = ""
zmediaShampoo_MSG.AltText = ""
zmediaShampoo_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "shampoomsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "shampoomsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaShaunathePenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaShaunathePenguin.Id = "296429a7-9782-4b76-8e06-aaf9e51dfc47"
zmediaShaunathePenguin.Name = _O5Os("\008\108\018\012\040\018\112\108\014\113\014\040\086\012\029\040")
zmediaShaunathePenguin.Description = ""
zmediaShaunathePenguin.AltText = ""
zmediaShaunathePenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "shaunapenguin_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "shaunapenguin_garmin.jpg", 
		Directives = {}
	}
}
zmediaShaunathePenguin_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaShaunathePenguin_MSG.Id = "426ec243-fb87-49e9-a1e5-6078230ed596"
zmediaShaunathePenguin_MSG.Name = _O5Os("\008\108\018\012\040\018\112\108\014\113\014\040\086\012\029\040\063\117\008\107")
zmediaShaunathePenguin_MSG.Description = ""
zmediaShaunathePenguin_MSG.AltText = ""
zmediaShaunathePenguin_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "shaunapenguinmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "shaunapenguinmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaSiamang = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSiamang.Id = "1d8d38d4-547f-45e8-8e9e-7ddcbe3d8c1a"
zmediaSiamang.Name = _O5Os("\008\029\018\124\018\040\086")
zmediaSiamang.Description = ""
zmediaSiamang.AltText = ""
zmediaSiamang.Resources = {
	{
		Type = "jpg", 
		Filename = "siamang_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "siamang_garmin.jpg", 
		Directives = {}
	}
}
zmediaSiamang_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSiamang_MSG.Id = "4d9c40d7-5a29-427b-a4ef-41ce95781eac"
zmediaSiamang_MSG.Name = _O5Os("\008\029\018\124\018\040\086\063\117\008\107")
zmediaSiamang_MSG.Description = ""
zmediaSiamang_MSG.AltText = ""
zmediaSiamang_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "siamangmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "siamangmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaSiamangVoice = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSiamangVoice.Id = "ee6156fe-4efb-48f1-bbd2-98d99bb695da"
zmediaSiamangVoice.Name = _O5Os("\008\029\018\124\018\040\086\020\066\029\021\014")
zmediaSiamangVoice.Description = ""
zmediaSiamangVoice.AltText = ""
zmediaSiamangVoice.Resources = {
	{
		Type = "jpg", 
		Filename = "siamangvoice_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "siamangvoice_garmin.jpg", 
		Directives = {}
	}
}
zmediaSiamangVoice_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSiamangVoice_MSG.Id = "dfdeee74-025f-4249-b443-55439e13fd39"
zmediaSiamangVoice_MSG.Name = _O5Os("\008\029\018\124\018\040\086\020\066\029\021\014\063\117\008\107")
zmediaSiamangVoice_MSG.Description = ""
zmediaSiamangVoice_MSG.AltText = ""
zmediaSiamangVoice_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "siamangvoicemsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "siamangvoicemsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaSilverBackGorilla = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSilverBackGorilla.Id = "a8f9e78e-28f5-4df9-9762-b81289344920"
zmediaSilverBackGorilla.Name = _O5Os("\008\029\045\039\014\044\005\018\021\009\107\066\044\029\045\045\018")
zmediaSilverBackGorilla.Description = ""
zmediaSilverBackGorilla.AltText = ""
zmediaSilverBackGorilla.Resources = {
	{
		Type = "jpg", 
		Filename = "silverbackgorilla_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "silverbackgorilla_garmin.jpg", 
		Directives = {}
	}
}
zmediaSilverBackGorilla_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSilverBackGorilla_MSG.Id = "67e52127-f530-4bdc-81ee-f4a5eac8169e"
zmediaSilverBackGorilla_MSG.Name = _O5Os("\008\029\045\039\014\044\005\018\021\009\107\066\044\029\045\045\018\063\117\008\107")
zmediaSilverBackGorilla_MSG.Description = ""
zmediaSilverBackGorilla_MSG.AltText = ""
zmediaSilverBackGorilla_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "silverbackgorillamsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "silverbackgorillamsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaSnowLeopard = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSnowLeopard.Id = "19150646-4062-471c-8aef-e31edc4b1e79"
zmediaSnowLeopard.Name = _O5Os("\008\040\066\027\078\014\066\109\018\044\019")
zmediaSnowLeopard.Description = ""
zmediaSnowLeopard.AltText = ""
zmediaSnowLeopard.Resources = {
	{
		Type = "jpg", 
		Filename = "snowleopard_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "snowleopard_garmin.jpg", 
		Directives = {}
	}
}
zmediaSnowLeopard_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSnowLeopard_MSG.Id = "e22f790b-3856-4970-9399-831e873bd977"
zmediaSnowLeopard_MSG.Name = _O5Os("\008\040\066\027\078\014\066\109\018\044\019\063\117\008\107")
zmediaSnowLeopard_MSG.Description = ""
zmediaSnowLeopard_MSG.AltText = ""
zmediaSnowLeopard_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "snowleopardmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "snowleopardmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaSnowyOwl = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSnowyOwl.Id = "803c3b46-27ca-46d8-98b9-1fc123319c17"
zmediaSnowyOwl.Name = _O5Os("\008\040\066\027\030\060\027\045")
zmediaSnowyOwl.Description = ""
zmediaSnowyOwl.AltText = ""
zmediaSnowyOwl.Resources = {
	{
		Type = "jpg", 
		Filename = "snowyowl_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "snowyowl_garmin.jpg", 
		Directives = {}
	}
}
zmediaSnowyOwl_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSnowyOwl_MSG.Id = "c962bb51-eb42-44df-9bb6-65ea12c05b4e"
zmediaSnowyOwl_MSG.Name = _O5Os("\008\040\066\027\030\060\027\045\063\117\008\107")
zmediaSnowyOwl_MSG.Description = ""
zmediaSnowyOwl_MSG.AltText = ""
zmediaSnowyOwl_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "snowyowlmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "snowyowlmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaStripeyTiger = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaStripeyTiger.Id = "934d9bfa-8df5-4f02-aca8-7b913a0de2e3"
zmediaStripeyTiger.Name = _O5Os("\008\112\044\029\109\014\030\001\029\086\014\044")
zmediaStripeyTiger.Description = ""
zmediaStripeyTiger.AltText = ""
zmediaStripeyTiger.Resources = {
	{
		Type = "jpg", 
		Filename = "stripeytiger_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "stripeytiger_garmin.jpg", 
		Directives = {}
	}
}
zmediaZebra_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZebra_MSG.Id = "f7587a65-eb1f-4ee4-b413-5237385b1f3f"
zmediaZebra_MSG.Name = _O5Os("\006\014\087\044\018\063\117\008\107")
zmediaZebra_MSG.Description = ""
zmediaZebra_MSG.AltText = ""
zmediaZebra_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "zebramsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zebramsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaZoneAustralasia = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZoneAustralasia.Id = "18d712de-690f-4e84-8e05-ccbb6b98b059"
zmediaZoneAustralasia.Name = _O5Os("\006\066\040\014\085\012\079\112\044\018\045\018\079\029\018")
zmediaZoneAustralasia.Description = ""
zmediaZoneAustralasia.AltText = ""
zmediaZoneAustralasia.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneaustralia_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zoneaustralia_garmin.jpg", 
		Directives = {}
	}
}
zmediaIntro = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaIntro.Id = "d791dacf-c89c-4f8b-9819-b865912fee04"
zmediaIntro.Name = _O5Os("\126\040\112\044\066")
zmediaIntro.Description = ""
zmediaIntro.AltText = ""
zmediaIntro.Resources = {
	{
		Type = "jpg", 
		Filename = "intro.jpg", 
		Directives = {}
	}
}
zmediaSunBear_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSunBear_MSG.Id = "20f17c50-3929-47bd-a6be-881b4b46e3be"
zmediaSunBear_MSG.Name = _O5Os("\008\012\040\005\014\018\044\063\117\008\107")
zmediaSunBear_MSG.Description = ""
zmediaSunBear_MSG.AltText = ""
zmediaSunBear_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "sunbearmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "sunbearmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaZoneAfrica = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZoneAfrica.Id = "1a078299-4f27-4b60-92e8-d070a8afbf69"
zmediaZoneAfrica.Name = _O5Os("\006\066\040\014\085\038\044\029\021\018")
zmediaZoneAfrica.Description = ""
zmediaZoneAfrica.AltText = ""
zmediaZoneAfrica.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneafrica_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zoneafrica_garmin.jpg", 
		Directives = {}
	}
}
zmediaTigerStripes_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaTigerStripes_MSG.Id = "998422b6-ac10-41dd-b147-b470b14b8410"
zmediaTigerStripes_MSG.Name = _O5Os("\001\029\086\014\044\008\112\044\029\109\014\079\063\117\008\107")
zmediaTigerStripes_MSG.Description = ""
zmediaTigerStripes_MSG.AltText = ""
zmediaTigerStripes_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "tigerstripesmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "tigerstripesmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaZebra = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZebra.Id = "9db45c7c-bd94-478b-99ca-347236b69ea6"
zmediaZebra.Name = _O5Os("\006\014\087\044\018")
zmediaZebra.Description = ""
zmediaZebra.AltText = ""
zmediaZebra.Resources = {
	{
		Type = "jpg", 
		Filename = "zebra_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zebra_garmin.jpg", 
		Directives = {}
	}
}
zmediaSiamangWithVoice_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSiamangWithVoice_MSG.Id = "bf235662-0ba4-4880-aad8-979ddd51b542"
zmediaSiamangWithVoice_MSG.Name = _O5Os("\008\029\018\124\018\040\086\121\029\112\108\020\066\029\021\014\063\117\008\107")
zmediaSiamangWithVoice_MSG.Description = ""
zmediaSiamangWithVoice_MSG.AltText = ""
zmediaSiamangWithVoice_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "siamangwithvoicemsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "siamangwithvoicemsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaZookeeper_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZookeeper_MSG.Id = "6fcf8da4-99aa-4239-bf2c-d6bde0487962"
zmediaZookeeper_MSG.Name = _O5Os("\006\066\066\009\014\014\109\014\044\063\117\008\107")
zmediaZookeeper_MSG.Description = ""
zmediaZookeeper_MSG.AltText = ""
zmediaZookeeper_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "zookeepermsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zookeepermsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaSiamangWithVoice = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSiamangWithVoice.Id = "8254fab5-5668-40d2-aa88-3aa6c2fdd6aa"
zmediaSiamangWithVoice.Name = _O5Os("\008\029\018\124\018\040\086\121\029\112\108\020\066\029\021\014")
zmediaSiamangWithVoice.Description = ""
zmediaSiamangWithVoice.AltText = ""
zmediaSiamangWithVoice.Resources = {
	{
		Type = "jpg", 
		Filename = "siamangwithvoice_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "siamangwithvoice_garmin.jpg", 
		Directives = {}
	}
}
zmediaPoster = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaPoster.Id = "f1f68444-a11b-44d1-a5e0-cfe52f106670"
zmediaPoster.Name = _O5Os("\113\066\079\112\014\044")
zmediaPoster.Description = ""
zmediaPoster.AltText = ""
zmediaPoster.Resources = {
	{
		Type = "jpg", 
		Filename = "zooposter.jpg", 
		Directives = {}
	}
}
zmediaSunBear = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaSunBear.Id = "49d6c3a8-9068-458a-b627-3010e660160f"
zmediaSunBear.Name = _O5Os("\008\012\040\005\014\018\044")
zmediaSunBear.Description = ""
zmediaSunBear.AltText = ""
zmediaSunBear.Resources = {
	{
		Type = "jpg", 
		Filename = "sunbear_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "sunbear_garmin.jpg", 
		Directives = {}
	}
}
zmediaZoneTemperateForest = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZoneTemperateForest.Id = "ef005318-de62-495b-be7a-b789d8798732"
zmediaZoneTemperateForest.Name = _O5Os("\006\066\040\014\001\014\124\109\014\044\018\112\014\076\066\044\014\079\112")
zmediaZoneTemperateForest.Description = ""
zmediaZoneTemperateForest.AltText = ""
zmediaZoneTemperateForest.Resources = {
	{
		Type = "jpg", 
		Filename = "zonetemperate_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zonetemperate_garmin.jpg", 
		Directives = {}
	}
}
zmediaZonePenguinPool = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZonePenguinPool.Id = "34302e3f-24df-46e1-9c6f-335e2bd1cf6a"
zmediaZonePenguinPool.Name = _O5Os("\006\066\040\014\113\014\040\086\012\029\040\113\066\066\045")
zmediaZonePenguinPool.Description = ""
zmediaZonePenguinPool.AltText = ""
zmediaZonePenguinPool.Resources = {
	{
		Type = "jpg", 
		Filename = "zonepenguinpool_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zonepenguinpool_garmin.jpg", 
		Directives = {}
	}
}
zmediaStripeyTiger_MSG = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaStripeyTiger_MSG.Id = "4f1fab0b-80bb-43ed-9560-0f5b7f4bfed3"
zmediaStripeyTiger_MSG.Name = _O5Os("\008\112\044\029\109\014\030\001\029\086\014\044\063\117\008\107")
zmediaStripeyTiger_MSG.Description = ""
zmediaStripeyTiger_MSG.AltText = ""
zmediaStripeyTiger_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "stripeytigermsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "stripeytigermsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaZoneAfricanVillage = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZoneAfricanVillage.Id = "42d4845d-0baf-4200-8355-d6f4616bb8fc"
zmediaZoneAfricanVillage.Name = _O5Os("\006\066\040\014\085\038\044\029\021\018\040\020\029\045\045\018\086\014")
zmediaZoneAfricanVillage.Description = ""
zmediaZoneAfricanVillage.AltText = ""
zmediaZoneAfricanVillage.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneafricanvillage_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zoneafricanvillage_garmin.jpg", 
		Directives = {}
	}
}
zmediaTigerStripes = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaTigerStripes.Id = "78105f79-8c96-473b-9a31-4f3f0beb0266"
zmediaTigerStripes.Name = _O5Os("\001\029\086\014\044\008\112\044\029\109\014\079")
zmediaTigerStripes.Description = ""
zmediaTigerStripes.AltText = ""
zmediaTigerStripes.Resources = {
	{
		Type = "jpg", 
		Filename = "tigerstripes_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "tigerstripes_garmin.jpg", 
		Directives = {}
	}
}
zmediaZookeeper = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZookeeper.Id = "f5d3a945-b657-44f6-ad97-8dd862fa7b1c"
zmediaZookeeper.Name = _O5Os("\006\066\066\009\014\014\109\014\044")
zmediaZookeeper.Description = ""
zmediaZookeeper.AltText = ""
zmediaZookeeper.Resources = {
	{
		Type = "jpg", 
		Filename = "zookeeper_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zookeeper_garmin.jpg", 
		Directives = {}
	}
}
zmediaZoneTropicalAsia = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZoneTropicalAsia.Id = "1d9ff9ff-962a-4c63-a4be-288f7bbd2f99"
zmediaZoneTropicalAsia.Name = _O5Os("\006\066\040\014\001\044\066\109\029\021\018\045\085\079\029\018")
zmediaZoneTropicalAsia.Description = ""
zmediaZoneTropicalAsia.AltText = ""
zmediaZoneTropicalAsia.Resources = {
	{
		Type = "jpg", 
		Filename = "zonetropicalasia_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zonetropicalasia_garmin.jpg", 
		Directives = {}
	}
}
zmediaZoneRainForest = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZoneRainForest.Id = "4d6a3ad0-2098-49d8-b97c-d6ce999fa043"
zmediaZoneRainForest.Name = _O5Os("\006\066\040\014\003\018\029\040\076\066\044\014\079\112")
zmediaZoneRainForest.Description = ""
zmediaZoneRainForest.AltText = ""
zmediaZoneRainForest.Resources = {
	{
		Type = "jpg", 
		Filename = "zonerainforest_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zonerainforest_garmin.jpg", 
		Directives = {}
	}
}
zmediaZoneNorthernTrail = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaZoneNorthernTrail.Id = "bf494152-0284-4b07-9673-13c2d1adca45"
zmediaZoneNorthernTrail.Name = _O5Os("\006\066\040\014\036\066\044\112\108\014\044\040\001\044\018\029\045")
zmediaZoneNorthernTrail.Description = ""
zmediaZoneNorthernTrail.AltText = ""
zmediaZoneNorthernTrail.Resources = {
	{
		Type = "jpg", 
		Filename = "zonenorthtrail_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zonenorthtrail_garmin.jpg", 
		Directives = {}
	}
}
zmediaiconalarmclock = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconalarmclock.Id = "8e9287cd-6067-498b-acdc-9f45d6356f78"
zmediaiconalarmclock.Name = _O5Os("\029\021\066\040\018\045\018\044\124\021\045\066\021\009")
zmediaiconalarmclock.Description = ""
zmediaiconalarmclock.AltText = ""
zmediaiconalarmclock.Resources = {
	{
		Type = "jpg", 
		Filename = "iconalarmclock.jpg", 
		Directives = {}
	}
}
zmediaiconbenpenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconbenpenguin.Id = "755557cf-c109-4805-829a-a019f8964feb"
zmediaiconbenpenguin.Name = _O5Os("\029\021\066\040\087\014\040\109\014\040\086\012\029\040")
zmediaiconbenpenguin.Description = ""
zmediaiconbenpenguin.AltText = ""
zmediaiconbenpenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "iconbenpenguin.jpg", 
		Directives = {}
	}
}
zmediaiconbrianpenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconbrianpenguin.Id = "fbcdade0-3385-4c21-98b1-711a03800e19"
zmediaiconbrianpenguin.Name = _O5Os("\029\021\066\040\087\044\029\018\040\109\014\040\086\012\029\040")
zmediaiconbrianpenguin.Description = ""
zmediaiconbrianpenguin.AltText = ""
zmediaiconbrianpenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "iconbrianpenguin.jpg", 
		Directives = {}
	}
}
zmediaiconbrownbear = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconbrownbear.Id = "c47bdf9c-f2d6-482a-a475-38702b7cc0f7"
zmediaiconbrownbear.Name = _O5Os("\029\021\066\040\087\044\066\027\040\087\014\018\044")
zmediaiconbrownbear.Description = ""
zmediaiconbrownbear.AltText = ""
zmediaiconbrownbear.Resources = {
	{
		Type = "jpg", 
		Filename = "iconbrownbear.jpg", 
		Directives = {}
	}
}
zmediaiconcake = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconcake.Id = "0e840a2f-7bd7-49e1-8d36-0b01a0fca61e"
zmediaiconcake.Name = _O5Os("\029\021\066\040\021\018\009\014")
zmediaiconcake.Description = ""
zmediaiconcake.AltText = ""
zmediaiconcake.Resources = {
	{
		Type = "jpg", 
		Filename = "iconcake.jpg", 
		Directives = {}
	}
}
zmediaiconcolobus = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconcolobus.Id = "aef57e39-6c58-4c0b-a765-0287fa75ec68"
zmediaiconcolobus.Name = _O5Os("\029\021\066\040\021\066\045\066\087\012\079")
zmediaiconcolobus.Description = ""
zmediaiconcolobus.AltText = ""
zmediaiconcolobus.Resources = {
	{
		Type = "jpg", 
		Filename = "iconcolobus.jpg", 
		Directives = {}
	}
}
zmediaicondrainplug = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaicondrainplug.Id = "3155a2c8-6e77-48d6-b855-fd36ba8b0c54"
zmediaicondrainplug.Name = _O5Os("\029\021\066\040\019\044\018\029\040\109\045\012\086")
zmediaicondrainplug.Description = ""
zmediaicondrainplug.AltText = ""
zmediaicondrainplug.Resources = {
	{
		Type = "jpg", 
		Filename = "icondrainplug.jpg", 
		Directives = {}
	}
}
zmediaiconegg = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconegg.Id = "740cee7f-26e5-4c09-bebc-a0defccf0b9f"
zmediaiconegg.Name = _O5Os("\029\021\066\040\014\086\086")
zmediaiconegg.Description = ""
zmediaiconegg.AltText = ""
zmediaiconegg.Resources = {
	{
		Type = "jpg", 
		Filename = "iconegg.jpg", 
		Directives = {}
	}
}
zmediaicongorilla = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaicongorilla.Id = "7c40a624-0653-43dc-adde-25e05b4814b9"
zmediaicongorilla.Name = _O5Os("\029\021\066\040\086\066\044\029\045\045\018")
zmediaicongorilla.Description = ""
zmediaicongorilla.AltText = ""
zmediaicongorilla.Resources = {
	{
		Type = "jpg", 
		Filename = "icongorilla.jpg", 
		Directives = {}
	}
}
zmediaiconhen = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconhen.Id = "3d80c320-3a1b-4f01-83db-3bff41aeb8d5"
zmediaiconhen.Name = _O5Os("\029\021\066\040\108\014\040")
zmediaiconhen.Description = ""
zmediaiconhen.AltText = ""
zmediaiconhen.Resources = {
	{
		Type = "jpg", 
		Filename = "iconhen.jpg", 
		Directives = {}
	}
}
zmediaiconhippo = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconhippo.Id = "aa4a9afd-a139-42cb-bbd3-3684fa0d5a5c"
zmediaiconhippo.Name = _O5Os("\029\021\066\040\108\029\109\109\066")
zmediaiconhippo.Description = ""
zmediaiconhippo.AltText = ""
zmediaiconhippo.Resources = {
	{
		Type = "jpg", 
		Filename = "iconhippo.jpg", 
		Directives = {}
	}
}
zmediaiconhoney = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconhoney.Id = "abd3b674-d7db-434a-90dc-0d923bd0f433"
zmediaiconhoney.Name = _O5Os("\029\021\066\040\108\066\040\014\030")
zmediaiconhoney.Description = ""
zmediaiconhoney.AltText = ""
zmediaiconhoney.Resources = {
	{
		Type = "jpg", 
		Filename = "iconhoney.jpg", 
		Directives = {}
	}
}
zmediaiconjaredpenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconjaredpenguin.Id = "a279ff5b-8936-4f08-8f81-6815f9dbf94d"
zmediaiconjaredpenguin.Name = _O5Os("\029\021\066\040\101\018\044\014\019\109\014\040\086\012\029\040")
zmediaiconjaredpenguin.Description = ""
zmediaiconjaredpenguin.AltText = ""
zmediaiconjaredpenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "iconjaredpenguin.jpg", 
		Directives = {}
	}
}
zmediaiconjenpenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconjenpenguin.Id = "3f673dca-87ba-4188-9f19-7e1c184c0033"
zmediaiconjenpenguin.Name = _O5Os("\029\021\066\040\101\014\040\109\014\040\086\012\029\040")
zmediaiconjenpenguin.Description = ""
zmediaiconjenpenguin.AltText = ""
zmediaiconjenpenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "iconjenpenguin.jpg", 
		Directives = {}
	}
}
zmediaiconkokopenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconkokopenguin.Id = "1f7b1cf2-a14a-4fc6-8844-2079461642d5"
zmediaiconkokopenguin.Name = _O5Os("\029\021\066\040\009\066\009\066\109\014\040\086\012\029\040")
zmediaiconkokopenguin.Description = ""
zmediaiconkokopenguin.AltText = ""
zmediaiconkokopenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "iconkokopenguin.jpg", 
		Directives = {}
	}
}
zmediaiconlemon = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconlemon.Id = "32612d18-f86b-4829-b18d-a68d395ab2bf"
zmediaiconlemon.Name = _O5Os("\029\021\066\040\045\014\124\066\040")
zmediaiconlemon.Description = ""
zmediaiconlemon.AltText = ""
zmediaiconlemon.Resources = {
	{
		Type = "jpg", 
		Filename = "iconlemon.jpg", 
		Directives = {}
	}
}
zmediaiconpig = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconpig.Id = "4d08d304-da98-47d6-84eb-05964a111ae2"
zmediaiconpig.Name = _O5Os("\029\021\066\040\109\029\086")
zmediaiconpig.Description = ""
zmediaiconpig.AltText = ""
zmediaiconpig.Resources = {
	{
		Type = "jpg", 
		Filename = "iconpig.jpg", 
		Directives = {}
	}
}
zmediaiconpython = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconpython.Id = "41041035-b47f-43e5-be6b-e105db820e61"
zmediaiconpython.Name = _O5Os("\029\021\066\040\109\030\112\108\066\040")
zmediaiconpython.Description = ""
zmediaiconpython.AltText = ""
zmediaiconpython.Resources = {
	{
		Type = "jpg", 
		Filename = "iconpython.jpg", 
		Directives = {}
	}
}
zmediaiconshampoo = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconshampoo.Id = "9e6bc3b3-68da-46b6-aa05-fb46d9447392"
zmediaiconshampoo.Name = _O5Os("\029\021\066\040\079\108\018\124\109\066\066")
zmediaiconshampoo.Description = ""
zmediaiconshampoo.AltText = ""
zmediaiconshampoo.Resources = {
	{
		Type = "jpg", 
		Filename = "iconshampoo.jpg", 
		Directives = {}
	}
}
zmediaiconshaunapenguin = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconshaunapenguin.Id = "ff099c8b-130e-4cd4-a2ce-0b4237694e68"
zmediaiconshaunapenguin.Name = _O5Os("\029\021\066\040\079\108\018\012\040\018\109\014\040\086\012\029\040")
zmediaiconshaunapenguin.Description = ""
zmediaiconshaunapenguin.AltText = ""
zmediaiconshaunapenguin.Resources = {
	{
		Type = "jpg", 
		Filename = "iconshaunapenguin.jpg", 
		Directives = {}
	}
}
zmediaiconsimang = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconsimang.Id = "f6022b59-ddc2-47c6-872d-649bff9e6eda"
zmediaiconsimang.Name = _O5Os("\029\021\066\040\079\029\124\018\040\086")
zmediaiconsimang.Description = ""
zmediaiconsimang.AltText = ""
zmediaiconsimang.Resources = {
	{
		Type = "jpg", 
		Filename = "iconsiamang.jpg", 
		Directives = {}
	}
}
zmediaiconsimangvoice = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconsimangvoice.Id = "b29d4f66-45ca-4d37-9d95-42529a4a49f5"
zmediaiconsimangvoice.Name = _O5Os("\029\021\066\040\079\029\124\018\040\086\039\066\029\021\014")
zmediaiconsimangvoice.Description = ""
zmediaiconsimangvoice.AltText = ""
zmediaiconsimangvoice.Resources = {
	{
		Type = "jpg", 
		Filename = "iconsiamangvoice.jpg", 
		Directives = {}
	}
}
zmediaiconsnowleopard = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconsnowleopard.Id = "09f1cf52-7adb-404d-a576-3f7644709a4a"
zmediaiconsnowleopard.Name = _O5Os("\029\021\066\040\079\040\066\027\045\014\066\109\018\044\019")
zmediaiconsnowleopard.Description = ""
zmediaiconsnowleopard.AltText = ""
zmediaiconsnowleopard.Resources = {
	{
		Type = "jpg", 
		Filename = "iconsnowleopard.jpg", 
		Directives = {}
	}
}
zmediaiconsnowyowl = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconsnowyowl.Id = "edae77fa-4a3a-47a2-b771-bd1ab62227a2"
zmediaiconsnowyowl.Name = _O5Os("\029\021\066\040\079\040\066\027\030\066\027\045")
zmediaiconsnowyowl.Description = ""
zmediaiconsnowyowl.AltText = ""
zmediaiconsnowyowl.Resources = {
	{
		Type = "jpg", 
		Filename = "iconsnowyowl.jpg", 
		Directives = {}
	}
}
zmediaiconsunbear = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconsunbear.Id = "00416478-2e69-4b12-a1cd-0ee45e3b9684"
zmediaiconsunbear.Name = _O5Os("\029\021\066\040\079\012\040\087\014\018\044")
zmediaiconsunbear.Description = ""
zmediaiconsunbear.AltText = ""
zmediaiconsunbear.Resources = {
	{
		Type = "jpg", 
		Filename = "iconsunbear.jpg", 
		Directives = {}
	}
}
zmediaicontiger = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaicontiger.Id = "d75752cb-907a-415f-b5c2-e58b3def3d6b"
zmediaicontiger.Name = _O5Os("\029\021\066\040\112\029\086\014\044")
zmediaicontiger.Description = ""
zmediaicontiger.AltText = ""
zmediaicontiger.Resources = {
	{
		Type = "jpg", 
		Filename = "icontiger.jpg", 
		Directives = {}
	}
}
zmediaicontigerstripes = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaicontigerstripes.Id = "68c5ba1a-268a-4d03-be36-bda3b5dd8633"
zmediaicontigerstripes.Name = _O5Os("\029\021\066\040\112\029\086\014\044\079\112\044\029\109\014\079")
zmediaicontigerstripes.Description = ""
zmediaicontigerstripes.AltText = ""
zmediaicontigerstripes.Resources = {
	{
		Type = "jpg", 
		Filename = "icontigerstripes.jpg", 
		Directives = {}
	}
}
zmediaiconzebra = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconzebra.Id = "4d7925d7-526a-4233-a7ca-d09c24ead6f6"
zmediaiconzebra.Name = _O5Os("\029\021\066\040\047\014\087\044\018")
zmediaiconzebra.Description = ""
zmediaiconzebra.AltText = ""
zmediaiconzebra.Resources = {
	{
		Type = "jpg", 
		Filename = "iconzebra.jpg", 
		Directives = {}
	}
}
zmediaiconzookeeper = Wherigo.ZMedia(cartZooventurePenguinEscape)
zmediaiconzookeeper.Id = "839b6141-bf4a-49a5-93dc-d3bfdccd7222"
zmediaiconzookeeper.Name = _O5Os("\029\021\066\040\047\066\066\009\014\014\109\014\044")
zmediaiconzookeeper.Description = ""
zmediaiconzookeeper.AltText = ""
zmediaiconzookeeper.Resources = {
	{
		Type = "jpg", 
		Filename = "iconzookeeper.jpg", 
		Directives = {}
	}
}
_dcYr = Wherigo.ZMedia(cartZooventurePenguinEscape)
_dcYr.Id = "8d62854e-0296-4708-842b-77cf62522567"
_dcYr.Name = _O5Os("\076\029\040\018\045")
_dcYr.Description = ""
_dcYr.AltText = ""
_dcYr.Resources = {
	{
		Type = "jpg", 
		Filename = "Ziel.jpg", 
		Directives = {}
	}
}
_Tdle7 = Wherigo.ZMedia(cartZooventurePenguinEscape)
_Tdle7.Id = "74c49121-be08-48ff-bd6d-6c11d4154c95"
_Tdle7.Name = _O5Os("\076\029\040\018\045\126\017\060\036")
_Tdle7.Description = ""
_Tdle7.AltText = ""
_Tdle7.Resources = {
	{
		Type = "jpg", 
		Filename = "ZielICON.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
cartZooventurePenguinEscape.Id="85ec1dbd-f1f9-42be-9303-ae899773a301"
cartZooventurePenguinEscape.Name="Basar-Adventure: Pinguin-Ausbruch"
cartZooventurePenguinEscape.Description=[[Oh je! Die Pinguine im virtuellen Zoo am Saar-Basar spinnen.
Helf dem Zoowaerter dabei, die Pinguine wieder einzufangen.]]
cartZooventurePenguinEscape.Visible=true
cartZooventurePenguinEscape.Activity="TourGuide"
cartZooventurePenguinEscape.StartingLocationDescription=[[Gehe zum simulierten Seehund- und Pinguinbecken auf dem Gelaende des Saar-Basar und starte dein Abenteuer.]]
cartZooventurePenguinEscape.StartingLocation = ZonePoint(49.2270816147449,7.03726197473049,0)
cartZooventurePenguinEscape.Version="1.3"
cartZooventurePenguinEscape.Company=""
cartZooventurePenguinEscape.Author="tower27"
cartZooventurePenguinEscape.BuilderVersion="URWIGO 1.14.4469.18959"
cartZooventurePenguinEscape.CreateDate="01/05/2008 12:22:46"
cartZooventurePenguinEscape.PublishDate="1/1/0001 12:00:00 AM"
cartZooventurePenguinEscape.UpdateDate="01/23/2011 12:03:27"
cartZooventurePenguinEscape.LastPlayedDate="1/1/0001 12:00:00 AM"
cartZooventurePenguinEscape.TargetDevice="PocketPC"
cartZooventurePenguinEscape.TargetDeviceVersion="0"
cartZooventurePenguinEscape.StateId="1"
cartZooventurePenguinEscape.CountryId="2"
cartZooventurePenguinEscape.Complete=false
cartZooventurePenguinEscape.UseLogging=true

cartZooventurePenguinEscape.Media=zmediaPenguins

cartZooventurePenguinEscape.Icon=zmediaiconjaredpenguin


-- Zones --
zonePenguinPool = Wherigo.Zone(cartZooventurePenguinEscape)
zonePenguinPool.Id = "289835ba-908d-4baf-b369-39e690ab1d49"
zonePenguinPool.Name = _O5Os("\113\029\040\086\012\029\040\087\014\021\009\014\040")
zonePenguinPool.Description = ""
zonePenguinPool.Visible = false
zonePenguinPool.Media = zmediaZonePenguinPool
zonePenguinPool.Commands = {}
zonePenguinPool.DistanceRange = Distance(-1, "feet")
zonePenguinPool.ShowObjects = "OnEnter"
zonePenguinPool.ProximityRange = Distance(200, "feet")
zonePenguinPool.AllowSetPositionTo = false
zonePenguinPool.Active = false
zonePenguinPool.Points = {
	ZonePoint(49.2269443289279, 7.03761636159658, 0), 
	ZonePoint(49.2269092958034, 7.03792213342428, 0), 
	ZonePoint(49.2266675665678, 7.03779875180959, 0), 
	ZonePoint(49.2267271231559, 7.03751980207204, 0)
}
zonePenguinPool.OriginalPoint = ZonePoint(47.6687000274658, -122.352783330282, 0)
zonePenguinPool.DistanceRangeUOM = "Feet"
zonePenguinPool.ProximityRangeUOM = "Feet"
zonePenguinPool.OutOfRangeName = ""
zonePenguinPool.InRangeName = ""
zoneNorthernTrail = Wherigo.Zone(cartZooventurePenguinEscape)
zoneNorthernTrail.Id = "85fd18dc-9d1f-4a4d-aa38-67e947f177e1"
zoneNorthernTrail.Name = _O5Os("\008\112\044\014\029\021\108\014\045\047\066\066")
zoneNorthernTrail.Description = ""
zoneNorthernTrail.Visible = false
zoneNorthernTrail.Media = zmediaZoneNorthernTrail
zoneNorthernTrail.Commands = {}
zoneNorthernTrail.DistanceRange = Distance(-1, "feet")
zoneNorthernTrail.ShowObjects = "OnEnter"
zoneNorthernTrail.ProximityRange = Distance(200, "feet")
zoneNorthernTrail.AllowSetPositionTo = false
zoneNorthernTrail.Active = false
zoneNorthernTrail.Points = {
	ZonePoint(49.228586040865, 7.03719324312448, 0), 
	ZonePoint(49.2284616772931, 7.03705376825571, 0), 
	ZonePoint(49.2283705939152, 7.03723079405069, 0), 
	ZonePoint(49.2284932061156, 7.03740513763666, 0)
}
zoneNorthernTrail.OriginalPoint = ZonePoint(47.6704666773478, -122.35058333079, 0)
zoneNorthernTrail.DistanceRangeUOM = "Feet"
zoneNorthernTrail.ProximityRangeUOM = "Feet"
zoneNorthernTrail.OutOfRangeName = ""
zoneNorthernTrail.InRangeName = ""
zoneAustralasia = Wherigo.Zone(cartZooventurePenguinEscape)
zoneAustralasia.Id = "654dead2-57e8-42b3-a6cc-eeb279781d21"
zoneAustralasia.Name = _O5Os("\003\018\012\087\009\018\112\047\014\040")
zoneAustralasia.Description = ""
zoneAustralasia.Visible = false
zoneAustralasia.Media = zmediaZoneAustralasia
zoneAustralasia.Commands = {}
zoneAustralasia.DistanceRange = Distance(-1, "feet")
zoneAustralasia.ShowObjects = "OnEnter"
zoneAustralasia.ProximityRange = Distance(200, "feet")
zoneAustralasia.AllowSetPositionTo = false
zoneAustralasia.Active = false
zoneAustralasia.Points = {
	ZonePoint(49.2286681469247, 7.03645999423503, 0), 
	ZonePoint(49.2285245159679, 7.03637952796459, 0), 
	ZonePoint(49.2284684647496, 7.03664774886608, 0), 
	ZonePoint(49.228622605447, 7.03672553292751, 0)
}
zoneAustralasia.OriginalPoint = ZonePoint(47.6700333277384, -122.351533317566, 0)
zoneAustralasia.DistanceRangeUOM = "Feet"
zoneAustralasia.ProximityRangeUOM = "Feet"
zoneAustralasia.OutOfRangeName = ""
zoneAustralasia.InRangeName = ""
zoneTropicalAsia = Wherigo.Zone(cartZooventurePenguinEscape)
zoneTropicalAsia.Id = "745b4610-e11f-4492-815a-205b4b2cfcfb"
zoneTropicalAsia.Name = _O5Os("\085\038\038\014\040\108\018\012\079")
zoneTropicalAsia.Description = ""
zoneTropicalAsia.Visible = false
zoneTropicalAsia.Media = zmediaZoneTropicalAsia
zoneTropicalAsia.Commands = {}
zoneTropicalAsia.DistanceRange = Distance(-1, "feet")
zoneTropicalAsia.ShowObjects = "OnEnter"
zoneTropicalAsia.ProximityRange = Distance(200, "feet")
zoneTropicalAsia.AllowSetPositionTo = false
zoneTropicalAsia.Active = false
zoneTropicalAsia.Points = {
	ZonePoint(49.2289766455409, 7.03434741935968, 0), 
	ZonePoint(49.2287874741552, 7.0342079444909, 0), 
	ZonePoint(49.2287174104952, 7.03459418258905, 0), 
	ZonePoint(49.2289696392062, 7.03465855560541, 0)
}
zoneTropicalAsia.OriginalPoint = ZonePoint(47.6697999954224, -122.34913333257, 0)
zoneTropicalAsia.DistanceRangeUOM = "Feet"
zoneTropicalAsia.ProximityRangeUOM = "Feet"
zoneTropicalAsia.OutOfRangeName = ""
zoneTropicalAsia.InRangeName = ""
zoneAfricanSavanna = Wherigo.Zone(cartZooventurePenguinEscape)
zoneAfricanSavanna.Id = "64cf6a18-f1be-4bc2-b7da-2938f172c88e"
zoneAfricanSavanna.Name = _O5Os("\085\038\044\029\009\018\040\029\079\021\108\014\037\008\018\039\018\040\040\014")
zoneAfricanSavanna.Description = ""
zoneAfricanSavanna.Visible = false
zoneAfricanSavanna.Media = zmediaZoneAfrica
zoneAfricanSavanna.Commands = {}
zoneAfricanSavanna.DistanceRange = Distance(-1, "feet")
zoneAfricanSavanna.ShowObjects = "OnEnter"
zoneAfricanSavanna.ProximityRange = Distance(200, "feet")
zoneAfricanSavanna.AllowSetPositionTo = false
zoneAfricanSavanna.Active = false
zoneAfricanSavanna.Points = {
	ZonePoint(49.2284187630301, 7.03341769865989, 0), 
	ZonePoint(49.2283276795731, 7.03397023371696, 0), 
	ZonePoint(49.2281455121552, 7.034517404356, 0), 
	ZonePoint(49.2277951883099, 7.03429746321678, 0), 
	ZonePoint(49.2280649378907, 7.033256766119, 0)
}
zoneAfricanSavanna.OriginalPoint = ZonePoint(47.6668333053589, -122.351150004069, 0)
zoneAfricanSavanna.DistanceRangeUOM = "Feet"
zoneAfricanSavanna.ProximityRangeUOM = "Feet"
zoneAfricanSavanna.OutOfRangeName = ""
zoneAfricanSavanna.InRangeName = ""
zoneTemperateForest = Wherigo.Zone(cartZooventurePenguinEscape)
zoneTemperateForest.Id = "8f0e6d97-fc39-4ccb-8dee-148a901012b5"
zoneTemperateForest.Name = _O5Os("\107\014\124\018\014\079\079\029\086\112\014\037\005\044\014\029\112\014\040")
zoneTemperateForest.Description = ""
zoneTemperateForest.Visible = false
zoneTemperateForest.Media = zmediaZoneTemperateForest
zoneTemperateForest.Commands = {}
zoneTemperateForest.DistanceRange = Distance(-1, "feet")
zoneTemperateForest.ShowObjects = "OnEnter"
zoneTemperateForest.ProximityRange = Distance(200, "feet")
zoneTemperateForest.AllowSetPositionTo = false
zoneTemperateForest.Active = false
zoneTemperateForest.Points = {
	ZonePoint(49.2272782371486, 7.03643317214488, 0), 
	ZonePoint(49.2272151779329, 7.03673357955455, 0), 
	ZonePoint(49.2270330064131, 7.03662629119396, 0), 
	ZonePoint(49.2270960658614, 7.03631515494823, 0)
}
zoneTemperateForest.OriginalPoint = ZonePoint(47.66656665802, -122.351233323415, 0)
zoneTemperateForest.DistanceRangeUOM = "Feet"
zoneTemperateForest.ProximityRangeUOM = "Feet"
zoneTemperateForest.OutOfRangeName = ""
zoneTemperateForest.InRangeName = ""
zoneTropicalRainForest = Wherigo.Zone(cartZooventurePenguinEscape)
zoneTropicalRainForest.Id = "3b621b09-879c-475e-9574-b3a719ceede3"
zoneTropicalRainForest.Name = _O5Os("\085\038\038\014\040\109\018\044\009")
zoneTropicalRainForest.Description = ""
zoneTropicalRainForest.Visible = false
zoneTropicalRainForest.Media = zmediaZoneRainForest
zoneTropicalRainForest.Commands = {}
zoneTropicalRainForest.DistanceRange = Distance(-1, "feet")
zoneTropicalRainForest.ShowObjects = "OnEnter"
zoneTropicalRainForest.ProximityRange = Distance(200, "feet")
zoneTropicalRainForest.AllowSetPositionTo = false
zoneTropicalRainForest.Active = false
zoneTropicalRainForest.Points = {
	ZonePoint(49.2275891529384, 7.03669200531482, 0), 
	ZonePoint(49.2275672575243, 7.03687037221431, 0), 
	ZonePoint(49.227444643026, 7.03683818570613, 0), 
	ZonePoint(49.2274910614075, 7.03664908997058, 0)
}
zoneTropicalRainForest.OriginalPoint = ZonePoint(47.6685166676839, -122.352066675822, 0)
zoneTropicalRainForest.DistanceRangeUOM = "Feet"
zoneTropicalRainForest.ProximityRangeUOM = "Feet"
zoneTropicalRainForest.OutOfRangeName = ""
zoneTropicalRainForest.InRangeName = ""
zoneAfricanVillage = Wherigo.Zone(cartZooventurePenguinEscape)
zoneAfricanVillage.Id = "b9bcbf64-bbf8-4b42-86d7-f5853d61e462"
zoneAfricanVillage.Name = _O5Os("\085\038\044\029\009\018\108\018\012\079")
zoneAfricanVillage.Description = ""
zoneAfricanVillage.Visible = false
zoneAfricanVillage.Media = zmediaZoneAfricanVillage
zoneAfricanVillage.Commands = {}
zoneAfricanVillage.DistanceRange = Distance(-1, "feet")
zoneAfricanVillage.ShowObjects = "OnEnter"
zoneAfricanVillage.ProximityRange = Distance(200, "feet")
zoneAfricanVillage.AllowSetPositionTo = false
zoneAfricanVillage.Active = false
zoneAfricanVillage.Points = {
	ZonePoint(49.2278157699045, 7.03393871776103, 0), 
	ZonePoint(49.2274671953582, 7.03382874719142, 0), 
	ZonePoint(49.2273796134274, 7.03430618039607, 0), 
	ZonePoint(49.2277457048665, 7.03445101968288, 0)
}
zoneAfricanVillage.OriginalPoint = ZonePoint(47.6669166564941, -122.350816663106, 0)
zoneAfricanVillage.DistanceRangeUOM = "Feet"
zoneAfricanVillage.ProximityRangeUOM = "Feet"
zoneAfricanVillage.OutOfRangeName = ""
zoneAfricanVillage.InRangeName = ""
_T3ad7 = Wherigo.Zone(cartZooventurePenguinEscape)
_T3ad7.Id = "79a8f99a-9f58-40ea-886e-c7908b07dd06"
_T3ad7.Name = _O5Os("\076\029\040\018\045")
_T3ad7.Description = ""
_T3ad7.Visible = false
_T3ad7.Media = _dcYr
_T3ad7.Icon = _Tdle7
_T3ad7.Commands = {}
_T3ad7.DistanceRange = Distance(-1, "feet")
_T3ad7.ShowObjects = "OnEnter"
_T3ad7.ProximityRange = Distance(60, "meters")
_T3ad7.AllowSetPositionTo = false
_T3ad7.Active = false
_T3ad7.Points = {
	ZonePoint(49.2286124242939, 7.03796622223496, 0), 
	ZonePoint(49.2286010389155, 7.03812782532811, 0), 
	ZonePoint(49.2285519941789, 7.03812179035782, 0), 
	ZonePoint(49.2285721375588, 7.03795147008538, 0)
}
_T3ad7.OriginalPoint = ZonePoint(49.2285843987368, 7.03804182700157, 0)
_T3ad7.DistanceRangeUOM = "Feet"
_T3ad7.ProximityRangeUOM = "Meters"
_T3ad7.OutOfRangeName = ""
_T3ad7.InRangeName = ""

-- Characters --
zcharacterZookeeper = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterZookeeper.Id = "7a6deaed-23ed-4ff7-88e3-9060fe784a1a"
zcharacterZookeeper.Name = _O5Os("\006\066\066\027\018\014\044\112\014\044")
zcharacterZookeeper.Description = ""
zcharacterZookeeper.Visible = true
zcharacterZookeeper.Media = zmediaZookeeper
zcharacterZookeeper.Icon = zmediaiconzookeeper
zcharacterZookeeper.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\003\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterZookeeper.Commands.Talk.Custom = true
zcharacterZookeeper.Commands.Talk.Id = "bae7e056-24fb-4835-972d-21b5a44c77cb"
zcharacterZookeeper.Commands.Talk.WorksWithAll = true
zcharacterZookeeper.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterZookeeper.Gender = "Male"
zcharacterZookeeper.Type = "NPC"
zcharacterPenguins = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterPenguins.Id = "3bcd03b9-0c63-4bbe-b58e-39bb4e632746"
zcharacterPenguins.Name = _O5Os("\113\029\040\086\012\029\040\014")
zcharacterPenguins.Description = ""
zcharacterPenguins.Visible = true
zcharacterPenguins.Media = zmediaPenguins
zcharacterPenguins.Commands = {
	Photograph = Wherigo.ZCommand{
		Text = _O5Os("\038\066\112\066\086\044\018\038\029\014\044\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Yell = Wherigo.ZCommand{
		Text = _O5Os("\079\021\108\044\014\029"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Feed = Wherigo.ZCommand{
		Text = _O5Os("\038\012\014\112\112\014\044\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterPenguins.Commands.Photograph.Custom = true
zcharacterPenguins.Commands.Photograph.Id = "e4aeed33-31ab-4878-8acc-0d128b2e6e33"
zcharacterPenguins.Commands.Photograph.WorksWithAll = true
zcharacterPenguins.Commands.Yell.Custom = true
zcharacterPenguins.Commands.Yell.Id = "41a83379-a70c-4d0e-84b7-a1669ca1d7b9"
zcharacterPenguins.Commands.Yell.WorksWithAll = true
zcharacterPenguins.Commands.Feed.Custom = true
zcharacterPenguins.Commands.Feed.Id = "1c559540-b891-4e9a-a2f2-d4c21b6a6908"
zcharacterPenguins.Commands.Feed.WorksWithAll = true
zcharacterPenguins.Commands.Examine.Custom = true
zcharacterPenguins.Commands.Examine.Id = "aaa0721b-f096-4211-8a2c-e63d65f7639e"
zcharacterPenguins.Commands.Examine.WorksWithAll = true
zcharacterPenguins.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterPenguins.Gender = "Male"
zcharacterPenguins.Type = "NPC"
zcharacterBrownBear = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterBrownBear.Id = "6c874cb3-11e8-48c2-abc0-583607db5967"
zcharacterBrownBear.Name = _O5Os("\005\044\018\012\040\087\018\014\044")
zcharacterBrownBear.Description = ""
zcharacterBrownBear.Visible = true
zcharacterBrownBear.Media = zmediaBrownBearSleeping
zcharacterBrownBear.Icon = zmediaiconbrownbear
zcharacterBrownBear.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterBrownBear.Commands.Talk.Custom = true
zcharacterBrownBear.Commands.Talk.Id = "01e21341-3305-4c0f-b3e9-8d932274117c"
zcharacterBrownBear.Commands.Talk.WorksWithAll = true
zcharacterBrownBear.Commands.Examine.Custom = true
zcharacterBrownBear.Commands.Examine.Id = "da9d7c05-a494-40c3-b5fc-92bc8733021d"
zcharacterBrownBear.Commands.Examine.WorksWithAll = true
zcharacterBrownBear.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterBrownBear.Gender = "Male"
zcharacterBrownBear.Type = "NPC"
zcharacterSnowyOwl = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterSnowyOwl.Id = "73edfeb0-4432-4103-b5c8-210ede83ed69"
zcharacterSnowyOwl.Name = _O5Os("\008\021\108\040\014\014\014\012\045\014")
zcharacterSnowyOwl.Description = ""
zcharacterSnowyOwl.Visible = true
zcharacterSnowyOwl.Media = zmediaSnowyOwl
zcharacterSnowyOwl.Icon = zmediaiconsnowyowl
zcharacterSnowyOwl.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterSnowyOwl.Commands.Talk.Custom = true
zcharacterSnowyOwl.Commands.Talk.Id = "e188fa37-272a-4e84-9dab-cdd27e1bc42c"
zcharacterSnowyOwl.Commands.Talk.WorksWithAll = true
zcharacterSnowyOwl.Commands.Examine.Custom = true
zcharacterSnowyOwl.Commands.Examine.Id = "55ce487f-350c-4f09-b203-f3ca7404fc94"
zcharacterSnowyOwl.Commands.Examine.WorksWithAll = true
zcharacterSnowyOwl.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterSnowyOwl.Gender = "Male"
zcharacterSnowyOwl.Type = "NPC"
zcharacterTiger = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterTiger.Id = "d9594da7-d5b4-4ab5-98ab-0bb5666a8272"
zcharacterTiger.Name = _O5Os("\001\029\086\014\044")
zcharacterTiger.Description = ""
zcharacterTiger.Visible = true
zcharacterTiger.Media = zmediaSadTiger
zcharacterTiger.Icon = zmediaicontiger
zcharacterTiger.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterTiger.Commands.Talk.Custom = true
zcharacterTiger.Commands.Talk.Id = "88d0ec75-a79d-42f4-b9c5-021c0a1074b3"
zcharacterTiger.Commands.Talk.WorksWithAll = true
zcharacterTiger.Commands.Examine.Custom = true
zcharacterTiger.Commands.Examine.Id = "510a6c06-2394-4807-aa22-3fef4f6d58ff"
zcharacterTiger.Commands.Examine.WorksWithAll = true
zcharacterTiger.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterTiger.Gender = "Male"
zcharacterTiger.Type = "NPC"
zcharacterSnowLeopard = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterSnowLeopard.Id = "5cc8597f-23d6-43f3-b3e5-54223e63203c"
zcharacterSnowLeopard.Name = _O5Os("\008\021\108\040\014\014\045\014\066\109\018\044\019")
zcharacterSnowLeopard.Description = ""
zcharacterSnowLeopard.Visible = true
zcharacterSnowLeopard.Media = zmediaSnowLeopard
zcharacterSnowLeopard.Icon = zmediaiconsnowleopard
zcharacterSnowLeopard.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterSnowLeopard.Commands.Talk.Custom = true
zcharacterSnowLeopard.Commands.Talk.Id = "20f1e52e-8ac6-4bf6-b367-398b437da818"
zcharacterSnowLeopard.Commands.Talk.WorksWithAll = true
zcharacterSnowLeopard.Commands.Examine.Custom = true
zcharacterSnowLeopard.Commands.Examine.Id = "c2df9b10-0db3-43e9-bc95-85336735b53a"
zcharacterSnowLeopard.Commands.Examine.WorksWithAll = true
zcharacterSnowLeopard.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterSnowLeopard.Gender = "Male"
zcharacterSnowLeopard.Type = "NPC"
zcharacterSunBear = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterSunBear.Id = "ef4cee16-973b-49a7-b125-6ca7bba6785d"
zcharacterSunBear.Name = _O5Os("\008\066\040\040\014\040\087\018\014\044")
zcharacterSunBear.Description = ""
zcharacterSunBear.Visible = true
zcharacterSunBear.Media = zmediaSunBear
zcharacterSunBear.Icon = zmediaiconsunbear
zcharacterSunBear.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterSunBear.Commands.Talk.Custom = true
zcharacterSunBear.Commands.Talk.Id = "27b32e0a-4753-4b54-9490-11c61a857e91"
zcharacterSunBear.Commands.Talk.WorksWithAll = true
zcharacterSunBear.Commands.Examine.Custom = true
zcharacterSunBear.Commands.Examine.Id = "3742671d-7eb2-44d7-90b3-a7b63b6e7976"
zcharacterSunBear.Commands.Examine.WorksWithAll = true
zcharacterSunBear.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterSunBear.Gender = "Male"
zcharacterSunBear.Type = "NPC"
zcharacterHippopotamus = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterHippopotamus.Id = "1541b407-a49c-4051-a2be-f1868473d055"
zcharacterHippopotamus.Name = _O5Os("\036\029\045\109\038\014\044\019")
zcharacterHippopotamus.Description = ""
zcharacterHippopotamus.Visible = true
zcharacterHippopotamus.Media = zmediaHippo
zcharacterHippopotamus.Icon = zmediaiconhippo
zcharacterHippopotamus.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterHippopotamus.Commands.Talk.Custom = true
zcharacterHippopotamus.Commands.Talk.Id = "9d1d574b-68a8-4ea1-b2c7-64753f7f29eb"
zcharacterHippopotamus.Commands.Talk.WorksWithAll = true
zcharacterHippopotamus.Commands.Examine.Custom = true
zcharacterHippopotamus.Commands.Examine.Id = "59340a0a-9ee0-4c4f-bbc3-d20626f0720b"
zcharacterHippopotamus.Commands.Examine.WorksWithAll = true
zcharacterHippopotamus.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterHippopotamus.Gender = "Male"
zcharacterHippopotamus.Type = "NPC"
zcharacterZebra = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterZebra.Id = "33ff0d6b-ca79-4afe-a5a8-7a80cb86863a"
zcharacterZebra.Name = _O5Os("\006\014\087\044\018")
zcharacterZebra.Description = ""
zcharacterZebra.Visible = true
zcharacterZebra.Media = zmediaZebra
zcharacterZebra.Icon = zmediaiconzebra
zcharacterZebra.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterZebra.Commands.Talk.Custom = true
zcharacterZebra.Commands.Talk.Id = "d4d1f0ee-6ccd-41c9-bc39-4e37405213fd"
zcharacterZebra.Commands.Talk.WorksWithAll = true
zcharacterZebra.Commands.Examine.Custom = true
zcharacterZebra.Commands.Examine.Id = "b1338b8e-c40e-4e9e-aea4-39f21c1208b8"
zcharacterZebra.Commands.Examine.WorksWithAll = true
zcharacterZebra.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterZebra.Gender = "Male"
zcharacterZebra.Type = "NPC"
zcharacterPython = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterPython.Id = "2640bbc5-166a-45f1-a6ab-f53ec5ce1f52"
zcharacterPython.Name = _O5Os("\113\030\112\108\066\040")
zcharacterPython.Description = ""
zcharacterPython.Visible = true
zcharacterPython.Media = zmediaPython
zcharacterPython.Icon = zmediaiconpython
zcharacterPython.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterPython.Commands.Talk.Custom = true
zcharacterPython.Commands.Talk.Id = "5efa0335-de41-4c29-b600-e8cc926502e9"
zcharacterPython.Commands.Talk.WorksWithAll = true
zcharacterPython.Commands.Examine.Custom = true
zcharacterPython.Commands.Examine.Id = "c92695d9-069a-480c-adcd-109e6cf891e5"
zcharacterPython.Commands.Examine.WorksWithAll = true
zcharacterPython.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterPython.Gender = "Male"
zcharacterPython.Type = "NPC"
zcharacterSiamang = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterSiamang.Id = "7a67bf0b-2bea-4dab-b4cb-31343754f207"
zcharacterSiamang.Name = _O5Os("\008\021\108\029\124\109\018\040\079\014")
zcharacterSiamang.Description = ""
zcharacterSiamang.Visible = true
zcharacterSiamang.Media = zmediaSiamang
zcharacterSiamang.Icon = zmediaiconsimang
zcharacterSiamang.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterSiamang.Commands.Talk.Custom = true
zcharacterSiamang.Commands.Talk.Id = "eb8293ee-564f-410c-aa31-fea6199137c3"
zcharacterSiamang.Commands.Talk.WorksWithAll = true
zcharacterSiamang.Commands.Examine.Custom = true
zcharacterSiamang.Commands.Examine.Id = "f7fb744e-0d1c-4b3f-a235-cbc721c91b9f"
zcharacterSiamang.Commands.Examine.WorksWithAll = true
zcharacterSiamang.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterSiamang.Gender = "Male"
zcharacterSiamang.Type = "NPC"
zcharacterSadPig = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterSadPig.Id = "6a5c3899-0d26-4f1b-9a23-3ee1e934f5fb"
zcharacterSadPig.Name = _O5Os("\008\021\108\027\014\029\040")
zcharacterSadPig.Description = ""
zcharacterSadPig.Visible = true
zcharacterSadPig.Media = zmediaSadPig
zcharacterSadPig.Icon = zmediaiconpig
zcharacterSadPig.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterSadPig.Commands.Talk.Custom = true
zcharacterSadPig.Commands.Talk.Id = "9acddaf0-7cee-455a-856f-c59536008fe9"
zcharacterSadPig.Commands.Talk.WorksWithAll = true
zcharacterSadPig.Commands.Examine.Custom = true
zcharacterSadPig.Commands.Examine.Id = "5b1b0a21-bd46-48a3-9cae-6f9644369a57"
zcharacterSadPig.Commands.Examine.WorksWithAll = true
zcharacterSadPig.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterSadPig.Gender = "Male"
zcharacterSadPig.Type = "NPC"
zcharacterChicken = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterChicken.Id = "6651679e-da89-49ff-a4b1-57a189805c7e"
zcharacterChicken.Name = _O5Os("\096\012\108\040")
zcharacterChicken.Description = ""
zcharacterChicken.Visible = true
zcharacterChicken.Media = zmediaHen
zcharacterChicken.Icon = zmediaiconhen
zcharacterChicken.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterChicken.Commands.Talk.Custom = true
zcharacterChicken.Commands.Talk.Id = "846d21be-2de9-4045-8b9d-6b9c01e4fea9"
zcharacterChicken.Commands.Talk.WorksWithAll = true
zcharacterChicken.Commands.Examine.Custom = true
zcharacterChicken.Commands.Examine.Id = "420fe647-0ed3-45a9-81d9-6346ee31900b"
zcharacterChicken.Commands.Examine.WorksWithAll = true
zcharacterChicken.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterChicken.Gender = "Male"
zcharacterChicken.Type = "NPC"
zcharacterSilverbackGorilla = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterSilverbackGorilla.Id = "d1017611-37c1-4bc0-a835-ba303d0f7042"
zcharacterSilverbackGorilla.Name = _O5Os("\107\066\044\029\045\045\018")
zcharacterSilverbackGorilla.Description = ""
zcharacterSilverbackGorilla.Visible = true
zcharacterSilverbackGorilla.Media = zmediaPinkBackGorilla
zcharacterSilverbackGorilla.Icon = zmediaicongorilla
zcharacterSilverbackGorilla.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterSilverbackGorilla.Commands.Talk.Custom = true
zcharacterSilverbackGorilla.Commands.Talk.Id = "6a3532ba-2ec1-438c-ab93-779f2612cbf0"
zcharacterSilverbackGorilla.Commands.Talk.WorksWithAll = true
zcharacterSilverbackGorilla.Commands.Examine.Custom = true
zcharacterSilverbackGorilla.Commands.Examine.Id = "9afc55b8-f412-4eb4-afae-3d7943732bb6"
zcharacterSilverbackGorilla.Commands.Examine.WorksWithAll = true
zcharacterSilverbackGorilla.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterSilverbackGorilla.Gender = "Male"
zcharacterSilverbackGorilla.Type = "NPC"
zcharacterColobusMonkey = Wherigo.ZCharacter(cartZooventurePenguinEscape)
zcharacterColobusMonkey.Id = "1968a0dc-12a7-4e41-bb0f-0e04ce76651d"
zcharacterColobusMonkey.Name = _O5Os("\008\112\012\124\124\014\045\018\038\038\014")
zcharacterColobusMonkey.Description = ""
zcharacterColobusMonkey.Visible = true
zcharacterColobusMonkey.Media = zmediaColobus
zcharacterColobusMonkey.Icon = zmediaiconcolobus
zcharacterColobusMonkey.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _O5Os("\044\014\019\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zcharacterColobusMonkey.Commands.Talk.Custom = true
zcharacterColobusMonkey.Commands.Talk.Id = "ef6c60b5-b1b7-424d-a334-9fb1341bf012"
zcharacterColobusMonkey.Commands.Talk.WorksWithAll = true
zcharacterColobusMonkey.Commands.Examine.Custom = true
zcharacterColobusMonkey.Commands.Examine.Id = "ac563801-31ad-42d5-862b-58625e95d4ee"
zcharacterColobusMonkey.Commands.Examine.WorksWithAll = true
zcharacterColobusMonkey.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterColobusMonkey.Gender = "Male"
zcharacterColobusMonkey.Type = "NPC"

-- Items --
zitemAlarmClock = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemAlarmClock.Id = "606df513-248f-4d0b-b574-59f21a936a02"
zitemAlarmClock.Name = _O5Os("\121\014\021\009\014\044")
zitemAlarmClock.Description = ""
zitemAlarmClock.Visible = true
zitemAlarmClock.Media = zmediaAlarmClcok
zitemAlarmClock.Icon = zmediaiconalarmclock
zitemAlarmClock.Commands = {
	UseWith = Wherigo.ZCommand{
		Text = _O5Os("\087\014\040\012\112\047\014\037\124\029\112"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _O5Os("\001\108\014\037\056\104\079\014\037\121\029\112\108\056\037\021\066\124\124\018\040\019\037\029\079\037\040\066\112\037\018\039\018\029\045\018\087\045\014\037\087\014\021\018\012\079\014\037\030\066\012\037\018\044\014\037\040\066\112\037\109\044\014\079\014\040\112\045\030\037\029\040\037\018\037\047\066\040\014\028\037\017\108\014\021\009\037\112\108\014\037\056\078\066\021\018\112\029\066\040\079\056\037\112\018\087\037\112\066\037\040\018\039\029\086\018\112\014\028")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemAlarmClock.Commands.UseWith.Custom = true
zitemAlarmClock.Commands.UseWith.Id = "09f716b4-5aca-45c2-9f5e-04aecb9d8624"
zitemAlarmClock.Commands.UseWith.WorksWithAll = false
zitemAlarmClock.Commands.UseWith.WorksWithListIds = {
	"7a6deaed-23ed-4ff7-88e3-9060fe784a1a", 
	"6c874cb3-11e8-48c2-abc0-583607db5967", 
	"73edfeb0-4432-4103-b5c8-210ede83ed69"
}
zitemAlarmClock.Commands.Examine.Custom = true
zitemAlarmClock.Commands.Examine.Id = "b33bd174-aed8-45fb-9673-cab689f5a167"
zitemAlarmClock.Commands.Examine.WorksWithAll = true
zitemAlarmClock.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemAlarmClock.Locked = false
zitemAlarmClock.Opened = false
zitemShaunathePenguin = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemShaunathePenguin.Id = "11fdd341-e664-4f04-b18d-e8b814fec5f4"
zitemShaunathePenguin.Name = _O5Os("\008\018\087\018\037\019\014\044\037\113\029\040\086\012\029\040")
zitemShaunathePenguin.Description = ""
zitemShaunathePenguin.Visible = true
zitemShaunathePenguin.Media = zmediaShaunathePenguin
zitemShaunathePenguin.Icon = zmediaiconshaunapenguin
zitemShaunathePenguin.Commands = {
	Take = Wherigo.ZCommand{
		Text = _O5Os("\040\029\124\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemShaunathePenguin.Commands.Take.Custom = true
zitemShaunathePenguin.Commands.Take.Id = "435f4051-f046-4bae-9655-1054f1f680c9"
zitemShaunathePenguin.Commands.Take.WorksWithAll = true
zitemShaunathePenguin.Commands.Examine.Custom = true
zitemShaunathePenguin.Commands.Examine.Id = "6d061ad7-a3c0-4ed2-bfe5-1906be2870ee"
zitemShaunathePenguin.Commands.Examine.WorksWithAll = true
zitemShaunathePenguin.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemShaunathePenguin.Locked = false
zitemShaunathePenguin.Opened = false
zitemHoney = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemHoney.Id = "7d965d84-6812-4356-b346-54e0fb972f4e"
zitemHoney.Name = _O5Os("\096\066\040\029\086")
zitemHoney.Description = ""
zitemHoney.Visible = true
zitemHoney.Media = zmediaHoney
zitemHoney.Icon = zmediaiconhoney
zitemHoney.Commands = {
	Give = Wherigo.ZCommand{
		Text = _O5Os("\086\029\087"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _O5Os("\001\108\014\037\056\107\029\039\014\056\037\021\066\124\124\018\040\019\037\029\079\037\040\066\112\037\018\039\018\029\045\018\087\045\014\037\087\014\021\018\012\079\014\037\030\066\012\037\018\044\014\037\040\066\112\037\109\044\014\079\014\040\112\045\030\037\029\040\037\018\037\047\066\040\014\028\037\017\108\014\021\009\037\112\108\014\037\056\078\066\021\018\112\029\066\040\079\056\037\112\018\087\037\112\066\037\040\018\039\029\086\018\112\014\028")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemHoney.Commands.Give.Custom = true
zitemHoney.Commands.Give.Id = "f62c1200-6866-4a64-abab-fa70b396905f"
zitemHoney.Commands.Give.WorksWithAll = false
zitemHoney.Commands.Give.WorksWithListIds = {
	"7a6deaed-23ed-4ff7-88e3-9060fe784a1a", 
	"d9594da7-d5b4-4ab5-98ab-0bb5666a8272", 
	"5cc8597f-23d6-43f3-b3e5-54223e63203c", 
	"ef4cee16-973b-49a7-b125-6ca7bba6785d"
}
zitemHoney.Commands.Examine.Custom = true
zitemHoney.Commands.Examine.Id = "950a3857-3cc3-4874-a6ba-7f2a2b085d29"
zitemHoney.Commands.Examine.WorksWithAll = true
zitemHoney.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemHoney.Locked = false
zitemHoney.Opened = true
zitemJenthePenguin = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemJenthePenguin.Id = "6ff3ac97-57d4-4b24-abe2-f73b4419eb59"
zitemJenthePenguin.Name = _O5Os("\120\014\079\009\018\037\019\014\044\037\113\029\040\086\012\029\040")
zitemJenthePenguin.Description = ""
zitemJenthePenguin.Visible = true
zitemJenthePenguin.Media = zmediaJenthePenguin
zitemJenthePenguin.Icon = zmediaiconjenpenguin
zitemJenthePenguin.Commands = {
	Take = Wherigo.ZCommand{
		Text = _O5Os("\040\029\124\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemJenthePenguin.Commands.Take.Custom = true
zitemJenthePenguin.Commands.Take.Id = "82714a09-daf9-466c-978e-e8234d95c0b8"
zitemJenthePenguin.Commands.Take.WorksWithAll = true
zitemJenthePenguin.Commands.Examine.Custom = true
zitemJenthePenguin.Commands.Examine.Id = "17029c91-e624-44b7-a60a-4aedc3beacdb"
zitemJenthePenguin.Commands.Examine.WorksWithAll = true
zitemJenthePenguin.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemJenthePenguin.Locked = false
zitemJenthePenguin.Opened = false
zitemTigerStripes = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemTigerStripes.Id = "b43ee503-12d9-4983-932c-ba6a420c8d7f"
zitemTigerStripes.Name = _O5Os("\001\029\086\014\044\079\112\044\014\029\038\014\040")
zitemTigerStripes.Description = ""
zitemTigerStripes.Visible = true
zitemTigerStripes.Media = zmediaTigerStripes
zitemTigerStripes.Icon = zmediaicontigerstripes
zitemTigerStripes.Commands = {
	Take = Wherigo.ZCommand{
		Text = _O5Os("\040\029\124\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Give = Wherigo.ZCommand{
		Text = _O5Os("\086\029\087"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _O5Os("\001\108\014\037\056\107\029\039\014\056\037\021\066\124\124\018\040\019\037\029\079\037\040\066\112\037\018\039\018\029\045\018\087\045\014\037\087\014\021\018\012\079\014\037\030\066\012\037\018\044\014\037\040\066\112\037\109\044\014\079\014\040\112\045\030\037\029\040\037\018\037\047\066\040\014\028\037\017\108\014\021\009\037\112\108\014\037\056\078\066\021\018\112\029\066\040\079\056\037\112\018\087\037\112\066\037\040\018\039\029\086\018\112\014\028")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Use = Wherigo.ZCommand{
		Text = _O5Os("\087\014\040\012\112\047\014"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemTigerStripes.Commands.Take.Custom = true
zitemTigerStripes.Commands.Take.Id = "b96f01ef-3a41-4f4c-a5bc-181f8acfef8f"
zitemTigerStripes.Commands.Take.WorksWithAll = true
zitemTigerStripes.Commands.Give.Custom = true
zitemTigerStripes.Commands.Give.Id = "4af342f4-ac74-41a4-a6a3-f5cf8f121f19"
zitemTigerStripes.Commands.Give.WorksWithAll = false
zitemTigerStripes.Commands.Give.WorksWithListIds = {
	"7a6deaed-23ed-4ff7-88e3-9060fe784a1a", 
	"d9594da7-d5b4-4ab5-98ab-0bb5666a8272", 
	"5cc8597f-23d6-43f3-b3e5-54223e63203c"
}
zitemTigerStripes.Commands.Examine.Custom = true
zitemTigerStripes.Commands.Examine.Id = "16c171a8-7ec6-4dd8-8a5c-3e5ed30a02cb"
zitemTigerStripes.Commands.Examine.WorksWithAll = true
zitemTigerStripes.Commands.Use.Custom = true
zitemTigerStripes.Commands.Use.Id = "2d092330-0fe2-458c-b147-cc977f60f855"
zitemTigerStripes.Commands.Use.WorksWithAll = true
zitemTigerStripes.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemTigerStripes.Locked = false
zitemTigerStripes.Opened = false
zitemDrainPlug = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemDrainPlug.Id = "93d0b513-bcde-4e2a-8588-43689d64d3ab"
zitemDrainPlug.Name = _O5Os("\121\018\040\040\014\040\079\112\066\014\109\079\014\045")
zitemDrainPlug.Description = ""
zitemDrainPlug.Visible = true
zitemDrainPlug.Media = zmediaDrainPlug
zitemDrainPlug.Icon = zmediaicondrainplug
zitemDrainPlug.Commands = {
	Give = Wherigo.ZCommand{
		Text = _O5Os("\086\029\087"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _O5Os("\001\108\014\037\056\107\029\039\014\056\037\021\066\124\124\018\040\019\037\029\079\037\040\066\112\037\018\039\018\029\045\018\087\045\014\037\087\014\021\018\012\079\014\037\030\066\012\037\018\044\014\037\040\066\112\037\109\044\014\079\014\040\112\045\030\037\029\040\037\018\037\047\066\040\014\028\037\017\108\014\021\009\037\112\108\014\037\056\078\066\021\018\112\029\066\040\079\056\037\112\018\087\037\112\066\037\040\018\039\029\086\018\112\014\028")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemDrainPlug.Commands.Give.Custom = true
zitemDrainPlug.Commands.Give.Id = "94cb43dc-4f79-48e4-a49f-fbb43adae13b"
zitemDrainPlug.Commands.Give.WorksWithAll = false
zitemDrainPlug.Commands.Give.WorksWithListIds = {
	"7a6deaed-23ed-4ff7-88e3-9060fe784a1a", 
	"1541b407-a49c-4051-a2be-f1868473d055", 
	"33ff0d6b-ca79-4afe-a5a8-7a80cb86863a"
}
zitemDrainPlug.Commands.Examine.Custom = true
zitemDrainPlug.Commands.Examine.Id = "54fd94fc-baca-4d7f-b4da-c46c5243ed04"
zitemDrainPlug.Commands.Examine.WorksWithAll = true
zitemDrainPlug.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemDrainPlug.Locked = false
zitemDrainPlug.Opened = false
zitemBenthePenguin = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemBenthePenguin.Id = "3c9dae29-7587-4a7f-a5a6-d4ddd00a9a81"
zitemBenthePenguin.Name = _O5Os("\005\014\040\037\019\014\044\037\113\029\040\086\012\029\040")
zitemBenthePenguin.Description = _O5Os("\095\018\079\037\029\079\112\037\019\014\044\037\113\029\040\086\012\029\040\037\005\014\040\059\037\014\029\040\037\009\045\014\029\040\014\044\037\038\044\014\021\108\014\044\037\113\029\040\086\012\029\040")
zitemBenthePenguin.Visible = true
zitemBenthePenguin.Media = zmediaBenthePenguin
zitemBenthePenguin.Icon = zmediaiconbenpenguin
zitemBenthePenguin.Commands = {
	Take = Wherigo.ZCommand{
		Text = _O5Os("\040\029\124\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemBenthePenguin.Commands.Take.Custom = true
zitemBenthePenguin.Commands.Take.Id = "b442d3de-707e-42a6-b14d-e0278cd29d3f"
zitemBenthePenguin.Commands.Take.WorksWithAll = true
zitemBenthePenguin.Commands.Examine.Custom = true
zitemBenthePenguin.Commands.Examine.Id = "dbdba7d8-9a5b-4bb4-a85a-afa3a4501cbb"
zitemBenthePenguin.Commands.Examine.WorksWithAll = true
zitemBenthePenguin.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemBenthePenguin.Locked = false
zitemBenthePenguin.Opened = false
zitemSiamangsVoice = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemSiamangsVoice.Id = "2bc471f0-b348-460c-8c5a-1e8151aa0313"
zitemSiamangsVoice.Name = _O5Os("\008\112\029\124\124\014\037\019\014\079\037\008\021\108\029\124\109\018\040\079\014\040")
zitemSiamangsVoice.Description = ""
zitemSiamangsVoice.Visible = true
zitemSiamangsVoice.Media = zmediaSiamangVoice
zitemSiamangsVoice.Icon = zmediaiconsimangvoice
zitemSiamangsVoice.Commands = {
	Take = Wherigo.ZCommand{
		Text = _O5Os("\040\029\124\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Give = Wherigo.ZCommand{
		Text = _O5Os("\086\029\087"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _O5Os("\001\108\014\037\056\107\029\039\014\056\037\021\066\124\124\018\040\019\037\029\079\037\040\066\112\037\018\039\018\029\045\018\087\045\014\037\087\014\021\018\012\079\014\037\030\066\012\037\018\044\014\037\040\066\112\037\109\044\014\079\014\040\112\045\030\037\029\040\037\018\037\047\066\040\014\028\037\017\108\014\021\009\037\112\108\014\037\056\078\066\021\018\112\029\066\040\079\056\037\112\018\087\037\112\066\037\040\018\039\029\086\018\112\014\028")
	}
}
zitemSiamangsVoice.Commands.Take.Custom = true
zitemSiamangsVoice.Commands.Take.Id = "e99b8a9d-0525-4617-a5e2-35f2c98fd6c4"
zitemSiamangsVoice.Commands.Take.WorksWithAll = true
zitemSiamangsVoice.Commands.Examine.Custom = true
zitemSiamangsVoice.Commands.Examine.Id = "f7c7f4ee-2217-4e9e-aa4e-bfee6d1f0a61"
zitemSiamangsVoice.Commands.Examine.WorksWithAll = true
zitemSiamangsVoice.Commands.Give.Custom = true
zitemSiamangsVoice.Commands.Give.Id = "6f868cc4-def4-461d-84c2-9f1851609bfe"
zitemSiamangsVoice.Commands.Give.WorksWithAll = false
zitemSiamangsVoice.Commands.Give.WorksWithListIds = {
	"7a6deaed-23ed-4ff7-88e3-9060fe784a1a", 
	"2640bbc5-166a-45f1-a6ab-f53ec5ce1f52", 
	"7a67bf0b-2bea-4dab-b4cb-31343754f207"
}
zitemSiamangsVoice.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemSiamangsVoice.Locked = false
zitemSiamangsVoice.Opened = false
zitemLemon = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemLemon.Id = "30215c81-f464-489f-9280-aa0d5e4ce450"
zitemLemon.Name = _O5Os("\006\029\112\044\066\040\014")
zitemLemon.Description = ""
zitemLemon.Visible = true
zitemLemon.Media = zmediaLemon
zitemLemon.Icon = zmediaiconlemon
zitemLemon.Commands = {
	Take = Wherigo.ZCommand{
		Text = _O5Os("\040\029\124\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Give = Wherigo.ZCommand{
		Text = _O5Os("\086\029\087"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _O5Os("\001\108\014\037\056\107\029\039\014\056\037\021\066\124\124\018\040\019\037\029\079\037\040\066\112\037\018\039\018\029\045\018\087\045\014\037\087\014\021\018\012\079\014\037\030\066\012\037\018\044\014\037\040\066\112\037\109\044\014\079\014\040\112\045\030\037\029\040\037\018\037\047\066\040\014\028\037\017\108\014\021\009\037\112\108\014\037\056\078\066\021\018\112\029\066\040\079\056\037\112\018\087\037\112\066\037\040\018\039\029\086\018\112\014\028")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemLemon.Commands.Take.Custom = true
zitemLemon.Commands.Take.Id = "265549fc-acef-4a40-9c20-b7f1a39d30ca"
zitemLemon.Commands.Take.WorksWithAll = true
zitemLemon.Commands.Give.Custom = true
zitemLemon.Commands.Give.Id = "ed8d55d0-d374-4458-a70b-339a94b8550d"
zitemLemon.Commands.Give.WorksWithAll = false
zitemLemon.Commands.Give.WorksWithListIds = {
	"7a6deaed-23ed-4ff7-88e3-9060fe784a1a", 
	"6a5c3899-0d26-4f1b-9a23-3ee1e934f5fb"
}
zitemLemon.Commands.Examine.Custom = true
zitemLemon.Commands.Examine.Id = "3c2876f2-2d2d-4df9-954b-6852f7dcadb6"
zitemLemon.Commands.Examine.WorksWithAll = true
zitemLemon.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemLemon.Locked = false
zitemLemon.Opened = false
zitemKokothePenguin = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemKokothePenguin.Id = "1ab03efc-f483-45d6-8689-a140c7e70707"
zitemKokothePenguin.Name = _O5Os("\024\066\009\066\037\019\014\044\037\113\029\040\086\012\029\040")
zitemKokothePenguin.Description = ""
zitemKokothePenguin.Visible = true
zitemKokothePenguin.Media = zmediaKokothePenguin
zitemKokothePenguin.Icon = zmediaiconkokopenguin
zitemKokothePenguin.Commands = {
	Take = Wherigo.ZCommand{
		Text = _O5Os("\040\029\124\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemKokothePenguin.Commands.Take.Custom = true
zitemKokothePenguin.Commands.Take.Id = "ab7a8f4d-5dfe-478d-90f3-2260c0ae8664"
zitemKokothePenguin.Commands.Take.WorksWithAll = true
zitemKokothePenguin.Commands.Examine.Custom = true
zitemKokothePenguin.Commands.Examine.Id = "b72c48cb-da2a-4b39-9df5-189baca15671"
zitemKokothePenguin.Commands.Examine.WorksWithAll = true
zitemKokothePenguin.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemKokothePenguin.Locked = false
zitemKokothePenguin.Opened = false
zitemEgg = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemEgg.Id = "a9799df3-4696-4d4c-b021-e4495b9705bb"
zitemEgg.Name = _O5Os("\122\029")
zitemEgg.Description = ""
zitemEgg.Visible = true
zitemEgg.Media = zmediaEgg
zitemEgg.Icon = zmediaiconegg
zitemEgg.Commands = {
	Take = Wherigo.ZCommand{
		Text = _O5Os("\040\029\124\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemEgg.Commands.Take.Custom = true
zitemEgg.Commands.Take.Id = "6a495a10-79a6-4b07-9443-228933647ba7"
zitemEgg.Commands.Take.WorksWithAll = true
zitemEgg.Commands.Examine.Custom = true
zitemEgg.Commands.Examine.Id = "0536bebe-f661-4b83-9cb8-d33a4ee301a3"
zitemEgg.Commands.Examine.WorksWithAll = true
zitemEgg.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemEgg.Locked = false
zitemEgg.Opened = false
zitemBrianthePenguin = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemBrianthePenguin.Id = "f108da47-4157-414a-a9c1-6657bab8ae2a"
zitemBrianthePenguin.Name = _O5Os("\005\018\021\014\045\045\014\037\019\014\044\037\113\029\040\086\012\029\040")
zitemBrianthePenguin.Description = ""
zitemBrianthePenguin.Visible = true
zitemBrianthePenguin.Media = zmediaBrianthePenguin
zitemBrianthePenguin.Icon = zmediaiconbrianpenguin
zitemBrianthePenguin.Commands = {
	Take = Wherigo.ZCommand{
		Text = _O5Os("\040\029\124\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemBrianthePenguin.Commands.Take.Custom = true
zitemBrianthePenguin.Commands.Take.Id = "c24226bf-d73d-4837-8823-2f489fcef889"
zitemBrianthePenguin.Commands.Take.WorksWithAll = true
zitemBrianthePenguin.Commands.Examine.Custom = true
zitemBrianthePenguin.Commands.Examine.Id = "08e5edb2-ac73-43f0-b185-c55e732895de"
zitemBrianthePenguin.Commands.Examine.WorksWithAll = true
zitemBrianthePenguin.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemBrianthePenguin.Locked = false
zitemBrianthePenguin.Opened = false
zitemJaredthePenguin = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemJaredthePenguin.Id = "70142c7c-d9d5-4ebc-a73d-3744c76212dd"
zitemJaredthePenguin.Name = _O5Os("\120\066\009\066\037\019\014\044\037\113\029\040\086\012\029\040")
zitemJaredthePenguin.Description = ""
zitemJaredthePenguin.Visible = true
zitemJaredthePenguin.Media = zmediaJaredthePenguin
zitemJaredthePenguin.Icon = zmediaiconjaredpenguin
zitemJaredthePenguin.Commands = {
	Take = Wherigo.ZCommand{
		Text = _O5Os("\040\029\124\124"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemJaredthePenguin.Commands.Take.Custom = true
zitemJaredthePenguin.Commands.Take.Id = "e76a2856-3e75-4839-bf22-caa014ac61c3"
zitemJaredthePenguin.Commands.Take.WorksWithAll = true
zitemJaredthePenguin.Commands.Examine.Custom = true
zitemJaredthePenguin.Commands.Examine.Id = "1d2f4ff0-4758-4543-8b14-c4d2b0450678"
zitemJaredthePenguin.Commands.Examine.WorksWithAll = true
zitemJaredthePenguin.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemJaredthePenguin.Locked = false
zitemJaredthePenguin.Opened = false
zitemShampoo = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemShampoo.Id = "a9a88211-7d77-477c-bace-667ad490c23a"
zitemShampoo.Name = _O5Os("\008\108\018\124\109\066\066")
zitemShampoo.Description = ""
zitemShampoo.Visible = true
zitemShampoo.Media = zmediaShampoo
zitemShampoo.Icon = zmediaiconshampoo
zitemShampoo.Commands = {
	UseWith = Wherigo.ZCommand{
		Text = _O5Os("\087\014\040\012\112\047\014\037\124\029\112"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _O5Os("\001\108\014\037\056\104\079\014\037\121\029\112\108\056\037\021\066\124\124\018\040\019\037\029\079\037\040\066\112\037\018\039\018\029\045\018\087\045\014\037\087\014\021\018\012\079\014\037\030\066\012\037\018\044\014\037\040\066\112\037\109\044\014\079\014\040\112\045\030\037\029\040\037\018\037\047\066\040\014\028\037\017\108\014\021\009\037\112\108\014\037\056\078\066\021\018\112\029\066\040\079\056\037\112\018\087\037\112\066\037\040\018\039\029\086\018\112\014\028")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemShampoo.Commands.UseWith.Custom = true
zitemShampoo.Commands.UseWith.Id = "5b380ca4-a3e6-40b9-acce-8ebb4d49e537"
zitemShampoo.Commands.UseWith.WorksWithAll = false
zitemShampoo.Commands.UseWith.WorksWithListIds = {
	"d1017611-37c1-4bc0-a835-ba303d0f7042"
}
zitemShampoo.Commands.Examine.Custom = true
zitemShampoo.Commands.Examine.Id = "f78020dc-421e-4882-90ed-fad8cce60bff"
zitemShampoo.Commands.Examine.WorksWithAll = true
zitemShampoo.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemShampoo.Locked = false
zitemShampoo.Opened = false
zitemCake = Wherigo.ZItem(cartZooventurePenguinEscape)
zitemCake.Id = "9c9523d8-9da9-4f74-955e-473b844226b6"
zitemCake.Name = _O5Os("\024\012\021\108\014\040")
zitemCake.Description = ""
zitemCake.Visible = true
zitemCake.Media = zmediaCake
zitemCake.Icon = zmediaiconcake
zitemCake.Commands = {
	Examine = Wherigo.ZCommand{
		Text = _O5Os("\012\040\112\014\044\079\012\021\108\014"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O5Os("\036\066\112\108\029\040\086\037\018\039\018\029\045\018\087\045\014")
	}
}
zitemCake.Commands.Examine.Custom = true
zitemCake.Commands.Examine.Id = "3ff651f8-9f6f-4434-83d9-9e4c57e9cf3a"
zitemCake.Commands.Examine.WorksWithAll = true
zitemCake.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemCake.Locked = false
zitemCake.Opened = false

-- Tasks --
ztaskVisitthePenguinPool = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskVisitthePenguinPool.Id = "33437ee4-f7a6-4840-ae8c-0310f6afa394"
ztaskVisitthePenguinPool.Name = _O5Os("\005\014\079\012\021\108\014\037\019\018\079\037\113\029\040\086\012\029\040\087\014\021\009\014\040")
ztaskVisitthePenguinPool.Description = ""
ztaskVisitthePenguinPool.Visible = false
ztaskVisitthePenguinPool.Media = zmediaZonePenguinPool
ztaskVisitthePenguinPool.Active = false
ztaskVisitthePenguinPool.Complete = false
ztaskVisitthePenguinPool.CorrectState = "None"
ztaskVisittheNorthernTrail = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskVisittheNorthernTrail.Id = "09bc3364-9fe2-496b-8c5d-4c511f924556"
ztaskVisittheNorthernTrail.Name = _O5Os("\005\014\079\012\021\108\014\037\019\014\040\037\008\112\044\014\029\021\108\014\045\047\066\066")
ztaskVisittheNorthernTrail.Description = ""
ztaskVisittheNorthernTrail.Visible = false
ztaskVisittheNorthernTrail.Media = zmediaZoneNorthernTrail
ztaskVisittheNorthernTrail.Active = false
ztaskVisittheNorthernTrail.Complete = false
ztaskVisittheNorthernTrail.CorrectState = "None"
ztaskVisitAustralasia = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskVisitAustralasia.Id = "98dc22cd-f2ca-466d-b924-411987471fa0"
ztaskVisitAustralasia.Name = _O5Os("\005\014\079\012\021\108\014\037\019\029\014\037\003\018\012\087\009\018\112\047\014\040")
ztaskVisitAustralasia.Description = ""
ztaskVisitAustralasia.Visible = false
ztaskVisitAustralasia.Media = zmediaZoneAustralasia
ztaskVisitAustralasia.Active = false
ztaskVisitAustralasia.Complete = false
ztaskVisitAustralasia.CorrectState = "None"
ztaskHelpRoundUpthePenguins = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskHelpRoundUpthePenguins.Id = "a82e23c3-d861-4d1e-8198-2892712bbe7b"
ztaskHelpRoundUpthePenguins.Name = _O5Os("\076\018\040\086\037\019\029\014\037\113\029\040\086\012\029\040\014\037\014\029\040")
ztaskHelpRoundUpthePenguins.Description = _O5Os("\095\012\037\124\012\079\079\112\037\040\066\021\108\037\061\037\113\029\040\086\012\029\040\014\037\014\029\040\038\018\040\086\014\040\028")
ztaskHelpRoundUpthePenguins.Visible = false
ztaskHelpRoundUpthePenguins.Media = zmediaPenguins
ztaskHelpRoundUpthePenguins.Active = false
ztaskHelpRoundUpthePenguins.Complete = false
ztaskHelpRoundUpthePenguins.CorrectState = "None"
ztaskWakeupBrownBear = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskWakeupBrownBear.Id = "21f04316-5c21-4e84-82a2-a6678ad80f46"
ztaskWakeupBrownBear.Name = _O5Os("\121\014\021\009\037\019\014\040\037\005\044\018\012\040\087\018\014\044\014\040\037\018\012\038")
ztaskWakeupBrownBear.Description = _O5Os("\076\029\040\019\014\037\019\014\040\037\121\014\021\009\014\044\037\012\040\019\037\087\014\014\040\019\014\037\019\014\040\037\121\029\040\112\014\044\079\021\108\045\018\038\037\019\014\079\037\005\018\014\044\014\040")
ztaskWakeupBrownBear.Visible = false
ztaskWakeupBrownBear.Media = zmediaAlarmClcok
ztaskWakeupBrownBear.Active = false
ztaskWakeupBrownBear.Complete = false
ztaskWakeupBrownBear.CorrectState = "None"
ztaskReturntheTigersStripes = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskReturntheTigersStripes.Id = "3d54bf3e-842b-4977-997d-8a22ca31a07b"
ztaskReturntheTigersStripes.Name = _O5Os("\005\014\079\066\044\086\014\037\019\029\014\037\001\029\086\014\044\079\112\044\014\029\038\014\040")
ztaskReturntheTigersStripes.Description = _O5Os("\076\029\040\019\014\037\019\029\014\037\008\112\044\014\029\038\014\040\037\019\014\079\037\001\029\086\014\044\079\037\012\040\019\037\086\029\087\037\079\029\014\037\029\108\124\037\047\012\044\012\014\021\009\059\037\079\066\037\019\018\079\079\037\014\044\037\027\029\014\019\014\044\037\079\021\108\066\014\040\037\018\012\079\079\029\014\108\112\028")
ztaskReturntheTigersStripes.Visible = false
ztaskReturntheTigersStripes.Media = zmediaTigerStripes
ztaskReturntheTigersStripes.Active = false
ztaskReturntheTigersStripes.Complete = false
ztaskReturntheTigersStripes.CorrectState = "None"
ztaskFindanAdhesiveforTiger = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskFindanAdhesiveforTiger.Id = "a12b0a8f-0422-4471-a6ed-a29814327e8a"
ztaskFindanAdhesiveforTiger.Name = _O5Os("\076\029\040\019\014\037\014\029\040\014\040\037\024\045\014\087\079\112\066\038\038")
ztaskFindanAdhesiveforTiger.Description = _O5Os("\076\029\040\019\014\037\108\014\044\018\012\079\059\037\027\066\124\029\112\037\019\014\044\037\001\029\086\014\044\037\079\014\029\040\014\037\008\112\044\014\029\038\014\040\037\027\029\014\019\014\044\037\018\040\009\045\014\087\014\040\037\009\018\040\040\099")
ztaskFindanAdhesiveforTiger.Visible = false
ztaskFindanAdhesiveforTiger.Media = zmediaSadTiger
ztaskFindanAdhesiveforTiger.Active = false
ztaskFindanAdhesiveforTiger.Complete = false
ztaskFindanAdhesiveforTiger.CorrectState = "None"
ztaskVisitTropicalAsia = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskVisitTropicalAsia.Id = "278cb7ab-736e-4883-8d57-42ecb31c433a"
ztaskVisitTropicalAsia.Name = _O5Os("\005\014\079\012\021\108\014\037\019\018\079\037\085\038\038\014\040\108\018\012\079")
ztaskVisitTropicalAsia.Description = ""
ztaskVisitTropicalAsia.Visible = false
ztaskVisitTropicalAsia.Media = zmediaZoneTropicalAsia
ztaskVisitTropicalAsia.Active = false
ztaskVisitTropicalAsia.Complete = false
ztaskVisitTropicalAsia.CorrectState = "None"
ztaskVisittheTemperateForest = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskVisittheTemperateForest.Id = "26dab41a-432b-44b7-a894-ee0c5e914d48"
ztaskVisittheTemperateForest.Name = _O5Os("\005\014\079\012\021\108\014\037\019\029\014\037\086\014\124\018\014\079\079\029\086\112\014\040\037\005\044\014\029\112\014\040")
ztaskVisittheTemperateForest.Description = _O5Os("\107\014\108\014\037\012\014\087\014\044\037\019\029\014\037\096\018\014\040\086\014\087\044\012\014\021\009\014\037\029\040\037\019\029\014\037\110\086\014\124\018\014\079\079\029\086\112\014\040\037\005\044\014\029\112\014\040\110")
ztaskVisittheTemperateForest.Visible = false
ztaskVisittheTemperateForest.Media = zmediaZoneTemperateForest
ztaskVisittheTemperateForest.Active = false
ztaskVisittheTemperateForest.Complete = false
ztaskVisittheTemperateForest.CorrectState = "None"
ztaskVisittheAfricanSavanna = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskVisittheAfricanSavanna.Id = "ad82a054-2ca3-46d2-b6b7-6935113d3104"
ztaskVisittheAfricanSavanna.Name = _O5Os("\005\014\079\012\021\108\014\037\019\029\014\037\085\038\044\029\009\018\040\029\079\021\108\014\037\008\018\039\018\040\040\014")
ztaskVisittheAfricanSavanna.Description = ""
ztaskVisittheAfricanSavanna.Visible = false
ztaskVisittheAfricanSavanna.Media = zmediaZoneAfrica
ztaskVisittheAfricanSavanna.Active = false
ztaskVisittheAfricanSavanna.Complete = false
ztaskVisittheAfricanSavanna.CorrectState = "None"
ztaskRetrievetheSiamangsVoice = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskRetrievetheSiamangsVoice.Id = "ed3ad33e-0b4a-4238-a776-46d5a368eee8"
ztaskRetrievetheSiamangsVoice.Name = _O5Os("\005\014\079\066\044\086\014\037\019\029\014\037\008\112\029\124\124\014")
ztaskRetrievetheSiamangsVoice.Description = _O5Os("\107\029\087\037\019\014\124\037\008\021\108\029\124\109\018\040\079\014\040\037\079\014\029\040\014\037\008\112\029\124\124\014\037\047\012\044\012\021\009\028")
ztaskRetrievetheSiamangsVoice.Visible = false
ztaskRetrievetheSiamangsVoice.Media = zmediaSiamangVoice
ztaskRetrievetheSiamangsVoice.Active = false
ztaskRetrievetheSiamangsVoice.Complete = false
ztaskRetrievetheSiamangsVoice.CorrectState = "None"
ztaskFindtheHipposDrainPlug = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskFindtheHipposDrainPlug.Id = "006f5b14-1068-4e5d-a7ba-e4f2b388d91b"
ztaskFindtheHipposDrainPlug.Name = _O5Os("\076\029\040\019\014\037\019\014\040\037\121\018\040\040\014\040\079\112\066\014\109\079\014\045")
ztaskFindtheHipposDrainPlug.Description = _O5Os("\076\029\040\019\014\037\019\014\040\037\008\112\066\014\109\079\014\045\037\019\014\044\037\005\018\019\014\027\018\040\040\014\037\012\040\019\037\110\086\029\087\110\037\029\108\040\037\019\014\124\037\036\029\045\109\038\014\044\019\037\047\012\044\014\012\021\009\028")
ztaskFindtheHipposDrainPlug.Visible = false
ztaskFindtheHipposDrainPlug.Media = zmediaDrainPlug
ztaskFindtheHipposDrainPlug.Active = false
ztaskFindtheHipposDrainPlug.Complete = false
ztaskFindtheHipposDrainPlug.CorrectState = "None"
ztaskCurlthePigsTail = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskCurlthePigsTail.Id = "46b0f19c-75b7-406e-8fce-0ef8a6265696"
ztaskCurlthePigsTail.Name = _O5Os("\003\029\040\086\014\045\037\019\018\079\037\008\021\108\027\018\014\040\047\021\108\014\040")
ztaskCurlthePigsTail.Description = _O5Os("\076\029\040\019\014\037\108\014\044\018\012\079\059\037\027\029\014\037\019\018\079\037\008\021\108\027\014\029\040\037\027\029\014\019\014\044\037\047\012\037\040\066\044\124\018\045\014\044\037\076\066\044\124\037\047\012\044\012\014\021\009\009\014\108\044\014\040\037\009\018\040\040\028")
ztaskCurlthePigsTail.Visible = false
ztaskCurlthePigsTail.Media = zmediaSadPig
ztaskCurlthePigsTail.Active = false
ztaskCurlthePigsTail.Complete = false
ztaskCurlthePigsTail.CorrectState = "None"
ztaskVisittheTropicalRainForest = Wherigo.ZTask(cartZooventurePenguinEscape)
ztaskVisittheTropicalRainForest.Id = "f82edbae-e0f9-4685-8f7d-0f0d33a40694"
ztaskVisittheTropicalRainForest.Name = _O5Os("\005\014\079\012\021\108\014\037\019\014\040\037\085\038\038\014\040\109\018\044\009")
ztaskVisittheTropicalRainForest.Description = ""
ztaskVisittheTropicalRainForest.Visible = false
ztaskVisittheTropicalRainForest.Media = zmediaZoneRainForest
ztaskVisittheTropicalRainForest.Active = false
ztaskVisittheTropicalRainForest.Complete = false
ztaskVisittheTropicalRainForest.CorrectState = "None"

-- Cartridge Variables --
TropicalAsiaAnswer = ""
SnowyOwlAnswer = ""
PigChat = _O5Os("\119")
PenguinVariable = 0
GorillaChat = _O5Os("\119")
PenguinCount = _O5Os("\061")
ChickenChat = false
AfricanAnswer = 0
HippoChat = _O5Os("\119")
RainForestAnswer = ""
KookaAnswer = ""
TigerChat = _O5Os("\119")
SnowyChat = _O5Os("\119")
ZebraChat = _O5Os("\119")
SiamangChat = _O5Os("\119")
TemperateAnswer = 0
NorthernTBoolean = false
PythonChat = _O5Os("\119")
SnowLeopardChat = _O5Os("\119")
SnowyTry = false
ColobusChat = _O5Os("\119")
ZooChat = _O5Os("\119")
KOOKABIRDANSWER = 0
_0vdu = _O5Os("\047\066\040\014\113\014\040\086\012\029\040\113\066\066\045")
_jWr1A = _O5Os("\047\021\108\018\044\018\021\112\014\044\006\066\066\009\014\014\109\014\044")
_CunLL = _O5Os("\047\029\112\014\124\085\045\018\044\124\017\045\066\021\009")
_Kb2vH = _O5Os("\047\112\018\079\009\020\029\079\029\112\112\108\014\113\014\040\086\012\029\040\113\066\066\045")
_Ve7E = _O5Os("\047\029\040\109\012\112\036\066\044\112\108\014\044\040\001\044\018\029\045")
_kv3 = _O5Os("\019\012\124\124\030")
cartZooventurePenguinEscape.ZVariables = {
	TropicalAsiaAnswer = "", 
	SnowyOwlAnswer = "", 
	PigChat = _O5Os("\119"), 
	PenguinVariable = 0, 
	GorillaChat = _O5Os("\119"), 
	PenguinCount = _O5Os("\061"), 
	ChickenChat = false, 
	AfricanAnswer = 0, 
	HippoChat = _O5Os("\119"), 
	RainForestAnswer = "", 
	KookaAnswer = "", 
	TigerChat = _O5Os("\119"), 
	SnowyChat = _O5Os("\119"), 
	ZebraChat = _O5Os("\119"), 
	SiamangChat = _O5Os("\119"), 
	TemperateAnswer = 0, 
	NorthernTBoolean = false, 
	PythonChat = _O5Os("\119"), 
	SnowLeopardChat = _O5Os("\119"), 
	SnowyTry = false, 
	ColobusChat = _O5Os("\119"), 
	ZooChat = _O5Os("\119"), 
	KOOKABIRDANSWER = 0, 
	_0vdu = _O5Os("\047\066\040\014\113\014\040\086\012\029\040\113\066\066\045"), 
	_jWr1A = _O5Os("\047\021\108\018\044\018\021\112\014\044\006\066\066\009\014\014\109\014\044"), 
	_CunLL = _O5Os("\047\029\112\014\124\085\045\018\044\124\017\045\066\021\009"), 
	_Kb2vH = _O5Os("\047\112\018\079\009\020\029\079\029\112\112\108\014\113\014\040\086\012\029\040\113\066\066\045"), 
	_Ve7E = _O5Os("\047\029\040\109\012\112\036\066\044\112\108\014\044\040\001\044\018\029\045"), 
	_kv3 = _O5Os("\019\012\124\124\030")
}

-- Timers --

-- Inputs --
zinputNorthernTrail = Wherigo.ZInput(cartZooventurePenguinEscape)
zinputNorthernTrail.Id = "176fb290-349e-4f69-957b-ec4b554308c6"
zinputNorthernTrail.Name = _O5Os("\052\028\037\008\021\108\040\014\014\014\012\045\014\063\008\112\044\014\029\021\108\014\047\066\066")
zinputNorthernTrail.Description = ""
zinputNorthernTrail.Visible = true
zinputNorthernTrail.InputType = "Text"
zinputNorthernTrail.Text = _O5Os("\085\012\079\037\027\029\014\039\029\014\045\014\040\037\005\012\021\108\079\112\018\087\014\040\037\087\014\079\112\014\108\112\037\019\018\079\037\121\066\044\112\037\018\012\038\037\019\014\124\037\012\040\112\014\044\079\112\014\040\037\008\021\108\029\045\019\037\013\014\086\018\045\037\066\087\037\020\066\044\019\014\044\100\037\066\019\014\044\037\003\012\021\009\079\014\029\112\014\055\037\010")
zinputKookaburra = Wherigo.ZInput(cartZooventurePenguinEscape)
zinputKookaburra.Id = "ca503856-a4ba-4697-8927-c363777f41c0"
zinputKookaburra.Name = _O5Os("\102\028\037\001\029\086\014\044\063\117\018\040\012\045\079")
zinputKookaburra.Description = ""
zinputKookaburra.Visible = true
zinputKookaburra.InputType = "Text"
zinputKookaburra.Text = _O5Os("\121\029\014\037\029\079\112\037\019\029\014\037\036\012\124\124\014\044\037\019\014\079\037\122\029\040\086\018\040\086\079\037\018\040\037\019\014\124\037\019\012\037\086\014\044\018\019\014\037\079\112\014\108\079\112\010")
zinputAfricanSavanna = Wherigo.ZInput(cartZooventurePenguinEscape)
zinputAfricanSavanna.Id = "fb170690-8fa4-4856-a77c-7cc7a98529f3"
zinputAfricanSavanna.Name = _O5Os("\046\028\037\085\038\044\029\009\018\108\018\012\079\063\006\014\087\044\018")
zinputAfricanSavanna.Description = ""
zinputAfricanSavanna.Visible = true
zinputAfricanSavanna.InputType = "Text"
zinputAfricanSavanna.Text = _O5Os("\085\087\037\027\014\045\021\108\014\044\037\039\066\045\045\014\040\037\008\112\012\040\019\014\037\029\079\112\037\108\029\014\044\037\019\029\014\037\085\040\045\029\014\038\014\044\012\040\086\037\086\014\066\038\038\040\014\112\010\118\005\003\033\013\014\029\040\014\037\014\029\040\079\112\014\045\045\029\086\014\037\006\029\038\038\014\044\055")
zinputTropicalAsia = Wherigo.ZInput(cartZooventurePenguinEscape)
zinputTropicalAsia.Id = "93de6e08-d3a6-41e2-ae6f-3b1a1c7938d2"
zinputTropicalAsia.Name = _O5Os("\092\028\037\008\021\108\029\124\109\018\040\079\014\063\085\038\038\014\040\108\018\012\079")
zinputTropicalAsia.Description = ""
zinputTropicalAsia.Visible = true
zinputTropicalAsia.InputType = "Text"
zinputTropicalAsia.Text = _O5Os("\036\014\040\040\037\124\029\044\037\019\014\040\037\005\012\021\108\079\112\018\087\014\040\059\037\019\014\044\037\108\029\014\044\037\012\087\014\044\037\019\029\044\037\079\021\108\027\014\087\112\028")
zinputTemperateForest = Wherigo.ZInput(cartZooventurePenguinEscape)
zinputTemperateForest.Id = "3f475ca4-aebe-4c97-8400-e619c0522fe4"
zinputTemperateForest.Name = _O5Os("\007\028\037\107\014\124\018\014\079\079\029\086\112\063\008\021\108\027\014\029\040")
zinputTemperateForest.Description = ""
zinputTemperateForest.Visible = true
zinputTemperateForest.InputType = "Text"
zinputTemperateForest.Text = _O5Os("\085\040\037\027\014\045\021\108\014\124\037\122\029\040\086\018\040\086\037\079\112\014\108\079\112\037\095\012\037\013\014\029\040\079\112\014\045\045\029\086\014\037\006\018\108\045\055\010")
zinputRainForest = Wherigo.ZInput(cartZooventurePenguinEscape)
zinputRainForest.Id = "91d52800-c694-45c5-948b-85752f5eaaa0"
zinputRainForest.Name = _O5Os("\061\028\037\008\021\108\045\018\040\086\014\040\108\018\012\079")
zinputRainForest.Description = ""
zinputRainForest.Visible = true
zinputRainForest.Choices = {
	"Einkaufswagen", 
	"Taxi", 
	"Busse", 
	"Kinderwagen"
}
zinputRainForest.InputType = "MultipleChoice"
zinputRainForest.Text = _O5Os("\121\014\045\021\108\014\037\076\018\108\044\047\014\012\086\014\037\079\112\014\108\014\040\037\108\029\014\044\010")

-- WorksWithList for object commands --
zitemAlarmClock.Commands.UseWith.WorksWithList = {
	zcharacterZookeeper, 
	zcharacterBrownBear, 
	zcharacterSnowyOwl
}
zitemHoney.Commands.Give.WorksWithList = {
	zcharacterZookeeper, 
	zcharacterTiger, 
	zcharacterSnowLeopard, 
	zcharacterSunBear
}
zitemTigerStripes.Commands.Give.WorksWithList = {
	zcharacterZookeeper, 
	zcharacterTiger, 
	zcharacterSnowLeopard
}
zitemDrainPlug.Commands.Give.WorksWithList = {
	zcharacterZookeeper, 
	zcharacterHippopotamus, 
	zcharacterZebra
}
zitemSiamangsVoice.Commands.Give.WorksWithList = {
	zcharacterZookeeper, 
	zcharacterPython, 
	zcharacterSiamang
}
zitemLemon.Commands.Give.WorksWithList = {
	zcharacterZookeeper, 
	zcharacterSadPig
}
zitemShampoo.Commands.UseWith.WorksWithList = {
	zcharacterSilverbackGorilla
}

-- functions --
function cartZooventurePenguinEscape:OnStart()
	if (_G[_O5Os("\122\040\039")][_O5Os("\095\014\039\029\021\014\126\095")] == _O5Os("\095\014\079\009\112\066\109")) or (_G[_O5Os("\122\040\039")][_O5Os("\113\045\018\112\038\066\044\124")] == _O5Os("\121\029\040\092\102")) then
		for k, v in pairs(_G[_O5Os("\021\018\044\112\006\066\066\039\014\040\112\012\044\014\113\014\040\086\012\029\040\122\079\021\018\109\014")][_O5Os("\085\045\045\006\060\087\101\014\021\112\079")]) do
			v[_O5Os("\020\029\079\029\087\045\014")] = false
			v[_O5Os("\085\021\112\029\039\014")] = false
		end
		_G[_O5Os("\121\108\014\044\029\086\066")][_O5Os("\017\066\124\124\018\040\019")](_O5Os("\008\018\039\014\017\045\066\079\014"))
		return
	end
	zonePenguinPool.Visible = true
	zonePenguinPool.Active = true
	ztaskVisitthePenguinPool.Active = true
	ztaskVisitthePenguinPool.Visible = true
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\110\096\018\045\045\066\099\037\121\029\045\045\009\066\124\124\014\040\037\029\124\037\006\066\066\028\037\126\021\108\037\087\029\040\037\019\014\044\037\006\066\066\027\018\014\044\112\014\044\037\012\040\019\037\029\021\108\037\027\014\044\019\014\037\019\029\021\108\037\087\014\029\037\019\014\029\040\014\124\037\003\012\040\019\086\018\040\086\037\087\014\086\045\014\029\112\014\040\028\118\005\003\033\118\005\003\033\104\040\079\014\044\014\037\001\066\012\044\037\079\112\018\044\112\014\112\037\018\124\037\039\029\044\112\012\014\045\045\014\040\037\113\029\040\086\012\029\040\100\107\014\108\014\086\014\028\037"), 
			Media = zmediaZookeeper_MSG
		}, 
		{
			Text = _O5Os("\095\014\029\040\014\037\085\012\038\086\018\087\014\035\037\005\014\079\012\021\108\014\037\019\029\014\037\113\029\086\012\029\040\014\118\005\003\033\118\005\003\033\008\021\108\018\012\037\047\012\037\019\014\040\037\110\078\066\021\018\112\029\066\040\079\110\037\012\040\019\037\018\012\038\037\019\029\014\037\024\018\044\112\014\037\012\124\037\019\066\044\112\108\029\040\037\047\012\037\086\014\045\018\040\086\014\040\028"), 
			Media = zmediaZonePenguinPool
		}
	}
end
function cartZooventurePenguinEscape:OnRestore()
end
function zonePenguinPool:OnEnter()
	_0vdu = _O5Os("\047\066\040\014\113\014\040\086\012\029\040\113\066\066\045")
	if (ztaskVisitthePenguinPool.Complete == false) and (not Player:Contains(zitemJaredthePenguin)) then
		ZooChat = _O5Os("\119")
		ztaskVisitthePenguinPool.Complete = true
		zcharacterZookeeper:MoveTo(zonePenguinPool)
		zcharacterPenguins:MoveTo(zonePenguinPool)
		_Urwigo.MessageBox{
			Text = _O5Os("\096\029\014\044\037\079\029\014\108\079\112\037\095\012\037\012\040\079\014\044\037\113\029\040\086\012\029\040\100\005\014\021\009\014\040\059\037\029\040\037\019\014\124\037\061\037\113\029\040\086\012\029\040\014\037\045\014\087\014\040\035\037\048\040\087\079\109\069\008\018\087\018\059\037\120\014\079\009\018\059\037\024\066\009\066\059\037\005\014\040\059\037\120\066\009\066\037\012\040\019\037\005\018\021\014\045\045\014\028\037\118\005\003\033\020\014\044\079\012\021\108\056\059\037\079\029\014\037\018\012\038\037\019\029\021\108\037\018\012\038\124\014\044\009\079\018\124\037\047\012\037\124\018\021\108\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif (PenguinVariable == 6) and (ztaskVisitthePenguinPool.Complete == false) then
		ZooChat = _O5Os("\092\025")
		ztaskVisitthePenguinPool.Complete = true
		ztaskHelpRoundUpthePenguins.Complete = true
		zcharacterZookeeper:MoveTo(zonePenguinPool)
		zcharacterPenguins:MoveTo(zonePenguinPool)
		zcharacterPenguins.Visible = true
		zitemShaunathePenguin:MoveTo(nil)
		zitemJenthePenguin:MoveTo(nil)
		zitemKokothePenguin:MoveTo(nil)
		zitemBenthePenguin:MoveTo(nil)
		zitemBrianthePenguin:MoveTo(nil)
		zitemJaredthePenguin:MoveTo(nil)
		_T3ad7.Active = true
		_T3ad7.Visible = true
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\121\012\040\019\014\044\087\018\044\099\037\095\012\037\108\018\079\112\037\124\029\044\037\086\045\012\014\021\009\045\029\021\108\014\044\027\014\029\079\014\037\086\014\108\066\045\038\014\040\059\037\018\045\045\014\037\113\029\040\086\012\029\040\014\037\027\029\014\019\014\044\037\014\029\040\047\012\038\018\040\086\014\040\037\012\040\019\037\108\018\079\112\037\079\029\014\037\027\029\014\019\014\044\037\029\040\037\029\108\044\037\005\014\021\009\014\040\037\086\014\087\044\018\021\108\112\028\037\036\012\040\037\009\018\040\040\037\029\021\108\037\079\029\014\037\014\040\019\045\029\021\108\037\038\012\014\112\112\014\044\040\037\012\040\019\037\027\029\044\037\009\066\014\040\040\014\040\037\027\029\014\019\014\044\037\040\066\044\124\018\045\037\027\014\029\112\014\044\037\018\044\087\014\029\112\014\040\028\118\005\003\033\118\005\003\033\020\029\014\045\014\040\037\095\018\040\009\037\038\012\014\044\037\019\014\029\040\014\037\096\029\045\038\014\099\037\020\029\014\045\037\008\109\018\079\079\037\040\066\021\108\037\108\029\014\044\037\029\124\037\006\066\066\028"), 
				Media = zmediaZookeeper_MSG
			}, 
			{
				Text = _O5Os("\085\045\079\037\095\018\040\009\037\038\012\014\044\037\019\014\029\040\014\037\096\029\045\038\014\037\038\029\040\019\014\079\112\037\019\012\037\087\014\029\037\118\005\003\033\036\037\046\025\037\052\092\028\032\102\119\037\100\037\122\037\032\037\119\102\028\102\032\025\037\014\029\040\014\037\095\066\079\014\059\037\029\040\037\019\014\044\037\019\012\037\019\014\029\040\014\037\122\044\045\014\087\040\029\079\079\014\037\039\014\044\014\027\029\086\014\040\037\009\018\040\040\079\112\028\037\013\096\029\040\112\035\037\047\014\044\087\044\066\021\108\014\040\014\079\037\107\045\018\079\055\028\037\118\005\003\033\118\005\003\033\122\079\037\086\029\087\112\037\018\012\021\108\037\014\029\040\014\037\040\014\012\014\037\006\066\040\014\059\037\124\029\112\037\019\014\044\037\029\108\044\037\108\029\040\038\029\040\019\014\112\028"), 
				Media = zmediaIntro
			}, 
			{
				Text = _O5Os("\095\014\044\037\076\044\014\029\079\021\108\018\045\112\021\066\019\014\037\038\012\014\044\037\019\029\014\037\017\018\044\019\044\029\019\086\014\037\029\079\112\035\037")..string.sub(Player.CompletionCode, 1, 15), 
				Media = zmediaIntro
			}, 
			{
				Text = _O5Os("\036\014\012\014\037\006\066\040\014\035\118\005\003\033\037\048\040\087\079\109\069\100\037\076\029\040\018\045"), 
				Media = _dcYr
			}
		}
	end
end
function zonePenguinPool:OnExit()
	_0vdu = _O5Os("\047\066\040\014\113\014\040\086\012\029\040\113\066\066\045")
	if zoneNorthernTrail.Visible == true then
		zonePenguinPool.Active = false
		zonePenguinPool.Visible = false
		zcharacterPenguins.Commands.Photograph.Enabled = false
		zcharacterPenguins.Commands.Yell.Enabled = false
		zcharacterPenguins.Commands.Feed.Enabled = false
		cartZooventurePenguinEscape:RequestSync()
	end
end
function zoneNorthernTrail:OnEnter()
	_0vdu = _O5Os("\047\066\040\014\036\066\044\112\108\014\044\040\001\044\018\029\045")
	if ztaskVisittheNorthernTrail.Complete == false then
		ztaskVisittheNorthernTrail.Complete = true
		zcharacterZookeeper:MoveTo(zoneNorthernTrail)
		zcharacterBrownBear:MoveTo(zoneNorthernTrail)
		ZooChat = _O5Os("\102")
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\059\037\117\029\079\112\028\037\122\029\040\014\044\037\019\014\044\037\113\029\040\086\012\029\040\014\037\108\018\112\037\019\014\040\037\121\014\021\009\014\044\037\039\066\124\037\005\044\018\012\040\087\018\014\044\014\040\037\086\014\079\112\066\108\045\014\040\059\037\018\045\079\037\014\044\037\079\029\021\108\037\039\014\044\079\112\014\021\009\112\037\108\018\112\028\118\005\003\033\118\005\003\033\008\109\044\029\021\108\037\124\029\112\037\029\108\124\028\037\020\029\014\045\045\014\029\021\108\112\037\009\018\040\040\037\014\044\037\012\040\079\037\108\014\045\038\014\040\037\019\014\040\037\113\029\040\086\012\029\040\037\047\012\037\038\029\040\019\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	end
end
function zoneNorthernTrail:OnExit()
	_0vdu = _O5Os("\047\066\040\014\036\066\044\112\108\014\044\040\001\044\018\029\045")
	if zoneAustralasia.Visible == true then
		zoneNorthernTrail.Visible = false
		zoneNorthernTrail.Active = false
		cartZooventurePenguinEscape:RequestSync()
	end
end
function zoneAustralasia:OnEnter()
	_0vdu = _O5Os("\047\066\040\014\085\012\079\112\044\018\045\018\079\029\018")
	if ztaskVisitAustralasia.Complete == false then
		ztaskVisitAustralasia.Complete = true
		zcharacterZookeeper:MoveTo(zoneAustralasia)
		zcharacterTiger:MoveTo(zoneAustralasia)
		ZooChat = _O5Os("\032")
		_Urwigo.MessageBox{
			Text = _O5Os("\096\014\030\059\037\108\029\014\044\037\029\079\112\037\019\066\021\108\037\014\087\014\040\037\040\066\021\108\037\014\029\040\037\113\029\040\086\012\029\040\037\039\066\044\087\014\029\037\086\014\044\018\040\040\112\028\037\095\014\044\037\009\045\014\029\040\014\037\003\018\021\009\014\044\037\108\018\112\037\019\014\124\037\018\044\124\014\040\037\001\029\086\014\044\037\079\014\029\040\014\037\008\112\044\014\029\038\014\040\037\086\014\079\112\066\108\045\014\040\059\037\101\014\112\047\112\037\108\018\112\037\019\014\044\037\085\044\124\014\037\044\029\021\108\112\029\086\037\079\021\108\045\014\021\108\112\014\037\078\018\012\040\014\028\118\005\003\033\118\005\003\033\003\014\019\056\037\124\029\112\037\019\014\124\037\001\029\086\014\044\059\037\039\029\014\045\045\014\029\021\108\112\037\009\066\014\040\040\014\040\037\027\029\044\037\029\108\124\037\108\014\045\038\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	end
end
function zoneAustralasia:OnExit()
	_0vdu = _O5Os("\047\066\040\014\085\012\079\112\044\018\045\018\079\029\018")
	if zoneTropicalAsia.Visible == true then
		zoneAustralasia.Visible = false
		zoneAustralasia.Active = false
		cartZooventurePenguinEscape:RequestSync()
	end
end
function zoneTropicalAsia:OnEnter()
	_0vdu = _O5Os("\047\066\040\014\001\044\066\109\029\021\018\045\085\079\029\018")
	if ztaskVisitTropicalAsia.Complete == false then
		ztaskVisitTropicalAsia.Complete = true
		zcharacterZookeeper:MoveTo(zoneTropicalAsia)
		zcharacterSiamang:MoveTo(zoneTropicalAsia)
		ZooChat = _O5Os("\052\007")
		_Urwigo.MessageBox{
			Text = _O5Os("\121\029\045\045\009\066\124\124\014\040\037\087\014\029\037\019\014\040\037\085\038\038\014\040\099\037\118\005\003\033\122\079\037\027\012\040\019\014\044\112\037\124\029\021\108\059\037\019\018\079\079\037\027\029\044\037\019\014\124\037\008\021\108\029\124\109\018\040\079\014\040\037\040\066\021\108\037\040\029\021\108\112\037\079\021\108\044\014\029\014\040\037\086\014\108\066\014\044\112\037\108\018\087\014\040\059\037\040\066\044\124\045\014\044\027\014\029\079\014\037\087\014\086\044\012\014\079\079\112\037\014\044\037\124\029\021\108\037\029\124\124\014\044\028\118\005\003\033\118\005\003\033\121\018\079\037\027\066\108\045\037\109\018\079\079\029\014\044\112\037\029\079\112\010\037\078\018\079\079\037\012\040\079\037\040\018\021\108\079\021\108\018\012\014\040\059\037\027\018\079\037\124\029\112\037\029\108\124\037\045\066\079\037\029\079\112\028"), 
			Media = zmediaZookeeper_MSG
		}
	end
end
function zoneTropicalAsia:OnExit()
	_0vdu = _O5Os("\047\066\040\014\001\044\066\109\029\021\018\045\085\079\029\018")
	if zoneAfricanSavanna.Visible == true then
		zoneTropicalAsia.Visible = false
		zoneTropicalAsia.Active = false
		cartZooventurePenguinEscape:RequestSync()
	end
end
function zoneAfricanSavanna:OnEnter()
	_0vdu = _O5Os("\047\066\040\014\085\038\044\029\021\018\040\008\018\039\018\040\040\018")
	zcharacterZookeeper:MoveTo(zoneAfricanSavanna)
	if ztaskVisittheAfricanSavanna.Complete == false then
		ztaskVisittheAfricanSavanna.Complete = true
		zcharacterHippopotamus:MoveTo(zoneAfricanSavanna)
		zitemCake:MoveTo(zoneAfricanSavanna)
		ZooChat = _O5Os("\102\102")
		_Urwigo.MessageBox{
			Text = _O5Os("\096\029\014\044\037\079\029\040\019\037\027\029\044\037\029\040\037\019\014\044\037\018\038\044\029\009\018\040\029\079\021\108\014\040\037\008\018\039\018\040\040\014\059\037\096\014\029\124\018\112\037\019\014\044\037\107\029\044\018\038\038\014\040\059\037\036\029\045\109\038\014\044\019\014\037\012\040\019\037\006\014\087\044\018\079\028\118\005\003\033\118\005\003\033\078\018\079\079\037\012\040\079\037\040\018\021\108\079\021\108\018\012\014\040\059\037\066\087\037\027\029\044\037\108\029\014\044\037\008\109\012\044\014\040\037\012\040\079\014\044\014\044\037\113\029\040\086\012\029\040\014\037\038\029\040\019\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif (ztaskVisittheAfricanSavanna.Complete == true) and Player:Contains(zitemDrainPlug) then
		_Urwigo.MessageBox{
			Text = _O5Os("\107\029\087\037\019\014\040\037\008\112\066\014\109\079\014\045\037\047\012\044\012\014\021\009\037\018\040\037\096\029\109\109\066\037\012\040\019\037\079\012\021\108\037\027\014\029\112\014\044\037\040\018\021\108\037\019\014\040\037\113\029\040\086\012\029\040\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	end
end
function zoneAfricanSavanna:OnExit()
	_0vdu = _O5Os("\047\066\040\014\085\038\044\029\021\018\040\008\018\039\018\040\040\018")
	if zoneTemperateForest.Visible == true then
		zoneAfricanSavanna.Visible = false
		zoneAfricanSavanna.Active = false
		zoneAfricanVillage.Visible = false
		zoneAfricanVillage.Active = false
		cartZooventurePenguinEscape:RequestSync()
	end
end
function zoneTemperateForest:OnEnter()
	_0vdu = _O5Os("\047\066\040\014\001\014\124\109\014\044\018\112\014\076\066\044\014\079\112")
	if ztaskVisittheTemperateForest.Complete == false then
		ztaskVisittheTemperateForest.Complete = true
		ZooChat = _O5Os("\102\070")
		zcharacterZookeeper:MoveTo(zoneTemperateForest)
		zcharacterSadPig:MoveTo(zoneTemperateForest)
		_Urwigo.MessageBox{
			Text = _O5Os("\036\012\040\037\079\029\040\019\037\027\029\044\037\029\040\037\019\014\040\037\086\014\124\018\014\079\079\029\086\112\014\040\037\005\044\014\029\112\014\040\028\037\008\021\108\018\012\037\019\029\021\108\037\014\029\040\037\027\014\040\029\086\037\012\124\059\037\018\087\014\044\037\087\014\014\029\045\037\019\029\021\108\059\037\019\018\124\029\112\037\027\029\044\037\027\014\029\112\014\044\037\040\018\021\108\037\019\014\040\037\113\029\040\086\012\029\040\014\040\037\079\012\021\108\014\040\037\009\066\014\040\040\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	end
end
function zoneTemperateForest:OnExit()
	_0vdu = _O5Os("\047\066\040\014\001\014\124\109\014\044\018\112\014\076\066\044\014\079\112")
	if zoneTropicalRainForest.Visible == true then
		zoneTemperateForest.Visible = false
		zoneTemperateForest.Active = false
		cartZooventurePenguinEscape:RequestSync()
	end
end
function zoneTropicalRainForest:OnEnter()
	_0vdu = _O5Os("\047\066\040\014\001\044\066\109\029\021\018\045\003\018\029\040\076\066\044\014\079\112")
	if ztaskVisittheTropicalRainForest.Complete == false then
		ztaskVisittheTropicalRainForest.Complete = true
		zcharacterZookeeper:MoveTo(zoneTropicalRainForest)
		zcharacterSilverbackGorilla:MoveTo(zoneTropicalRainForest)
		ZooChat = _O5Os("\092\046")
		_Urwigo.MessageBox{
			Text = _O5Os("\096\029\014\044\037\029\124\037\085\038\038\014\040\109\018\044\009\037\038\029\040\019\014\112\037\124\018\040\037\039\014\044\079\021\108\029\014\019\014\040\014\037\085\044\112\014\040\037\039\066\040\037\113\044\029\124\018\112\014\040\028\118\005\003\033\118\005\003\033\096\066\014\044\112\037\079\029\021\108\037\018\087\014\044\037\079\066\037\018\040\059\037\018\045\079\037\066\087\037\019\014\044\037\107\066\044\029\045\045\018\037\014\029\040\037\113\044\066\087\045\014\124\037\108\018\014\112\112\014\028\037\078\018\079\079\037\012\040\079\037\040\018\021\108\079\021\108\018\012\014\040\059\037\018\087\014\044\037\018\021\108\112\014\037\018\012\021\108\037\018\012\038\037\019\014\040\037\045\014\112\047\112\014\040\037\040\066\021\108\037\038\014\108\045\014\040\019\014\040\037\113\029\040\086\012\029\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	end
end
function zoneTropicalRainForest:OnExit()
	_0vdu = _O5Os("\047\066\040\014\001\044\066\109\029\021\018\045\003\018\029\040\076\066\044\014\079\112")
	if zonePenguinPool.Visible == true then
		zoneTropicalRainForest.Visible = false
		zoneTropicalRainForest.Active = false
		cartZooventurePenguinEscape:RequestSync()
	end
end
function zoneAfricanVillage:OnEnter()
	_0vdu = _O5Os("\047\066\040\014\085\038\044\029\021\018\040\020\029\045\045\018\086\014")
	if not zoneAfricanVillage:Contains(zcharacterZebra) then
		zcharacterZookeeper:MoveTo(zoneAfricanVillage)
		ZooChat = _O5Os("\102\092\018")
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\117\018\045\037\079\021\108\018\012\014\040\059\037\066\087\037\027\029\044\037\108\029\014\044\037\018\012\021\108\037\014\029\040\014\040\037\113\029\040\086\012\029\040\037\038\029\040\019\014\040\028\037\126\021\108\037\108\018\087\014\037\014\029\040\014\037\020\014\044\124\012\112\012\040\086\059\037\018\087\014\044\037\027\029\044\037\124\012\014\079\079\014\040\037\108\014\044\018\012\079\038\029\040\019\014\040\059\037\066\087\037\079\029\014\037\079\112\029\124\124\112\028"), 
				Media = zmediaZookeeper_MSG
			}, 
			{
				Text = _O5Os("\085\087\037\027\014\045\021\108\014\044\037\104\108\044\047\014\029\112\037\029\079\112\037\108\029\014\044\037\019\029\014\037\085\040\045\029\014\038\014\044\012\040\086\037\086\014\066\038\038\040\014\112\010\118\005\003\033\118\005\003\033\008\109\044\029\021\108\037\124\029\112\037\124\029\044\059\037\027\014\040\040\037\019\012\037\014\079\037\108\014\044\018\012\079\086\014\038\012\040\019\014\040\037\108\018\079\112\028"), 
				Media = zmediaZookeeper_MSG
			}
		}
	end
end
function zoneAfricanVillage:OnExit()
	_0vdu = _O5Os("\047\066\040\014\085\038\044\029\021\018\040\020\029\045\045\018\086\014")
	if zcharacterHippopotamus:Contains(zitemDrainPlug) then
		zoneAfricanVillage.Visible = false
		zoneAfricanVillage.Active = false
		cartZooventurePenguinEscape:RequestSync()
	end
end
function _T3ad7:OnEnter()
	_0vdu = _O5Os("\063\001\092\018\019\032")
	_Urwigo.MessageBox{
		Text = _O5Os("\008\012\021\108\014\037\108\029\014\044\037\019\014\040\037\107\014\066\021\018\021\108\014\028\037\036\066\021\108\124\018\045\037\047\012\044\037\122\044\029\040\040\014\044\012\040\086\035\037\019\014\044\037\076\044\014\029\079\021\108\018\045\112\021\066\019\014\037\029\079\112\037")..string.sub(Player.CompletionCode, 1, 15), 
		Media = _dcYr
	}
end
function zinputNorthernTrail:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	SnowyOwlAnswer = tostring(input)
	if SnowyOwlAnswer ~= _O5Os("\070") then
		_Urwigo.MessageBox{
			Text = _O5Os("\005\029\079\112\037\019\012\037\079\029\021\108\014\044\010\118\005\003\033\078\066\079\059\037\079\021\108\018\012\037\045\029\014\087\014\044\037\040\066\021\108\124\018\045\037\040\018\021\108\028"), 
			Media = zmediaSnowyOwl_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputNorthernTrail)
					end)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(SnowyOwlAnswer, _O5Os("\070")) then
		zitemAlarmClock:MoveTo(Player)
		zitemAlarmClock.Commands.UseWith.Enabled = true
		ZooChat = _O5Os("\046")
		SnowyChat = _O5Os("\102")
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\095\018\079\037\029\079\112\037\027\066\108\045\037\044\029\021\108\112\029\086\059\037\039\029\014\045\014\040\037\095\018\040\009\099"), 
				Media = zmediaSnowyOwl_MSG
			}, 
			{
				Text = _O5Os("\095\018\037\095\012\037\124\029\044\037\086\014\108\066\045\038\014\040\037\108\018\079\112\059\037\086\014\087\014\037\029\021\108\037\019\029\044\037\019\029\014\079\014\040\037\121\014\021\009\014\044\059\037\019\014\040\037\014\029\040\037\009\045\014\029\040\014\044\037\113\029\040\086\012\029\040\037\108\014\012\112\014\037\124\066\044\086\014\040\037\108\029\014\044\037\027\014\086\086\014\027\066\044\038\014\040\037\108\018\112\028\037\036\029\124\124\037\029\108\040\037\019\066\021\108\037\014\029\040\038\018\021\108\037\124\029\112\028"), 
				Media = zmediaSnowyOwl_MSG
			}, 
			{
				Text = _O5Os("\036\014\012\014\044\037\107\014\086\014\040\079\112\018\040\019\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\121\014\021\009\014\044"), 
				Media = zmediaAlarmClock_MSG
			}
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\095\012\037\079\066\045\045\112\014\079\112\037\047\012\124\029\040\019\014\079\112\037\014\029\040\014\037\085\040\112\027\066\044\112\037\039\014\044\079\012\021\108\014\040\028"), 
			Media = zmediaSnowyOwl_MSG
		}
	end
end
function zinputKookaburra:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	KOOKABIRDANSWER = input
	if KOOKABIRDANSWER == 3 then
		zitemJenthePenguin:MoveTo(zoneAustralasia)
		ZooChat = _O5Os("\052\092")
		TigerChat = _O5Os("\046")
		_Urwigo.MessageBox{
			Text = _O5Os("\085\108\018\059\037\029\021\108\037\027\012\079\079\112\014\059\037\019\018\079\079\037\079\029\021\108\037\019\014\044\037\113\029\040\086\012\029\040\037\108\029\014\044\037\018\045\079\037\117\018\040\012\045\037\039\014\044\009\045\014\029\019\014\112\037\108\018\112\028\037\008\029\014\037\019\018\021\108\112\014\037\027\066\108\045\059\037\079\066\037\009\066\014\040\040\014\037\079\029\014\037\079\029\021\108\037\039\066\044\037\012\040\079\037\039\014\044\079\112\014\021\009\014\040\028\118\005\003\033\118\005\003\033\095\012\037\079\066\045\045\112\014\079\037\120\014\079\009\018\037\019\014\040\037\113\029\040\086\012\029\040\037\101\014\112\047\112\037\110\040\014\108\124\014\040\110\059\037\087\014\039\066\044\037\014\044\037\040\066\021\108\037\124\014\108\044\037\085\014\044\086\014\044\037\124\018\021\108\014\040\037\009\018\040\040\028"), 
			Media = zmediaStripeyTiger_MSG
		}
	elseif KOOKABIRDANSWER ~= 3 then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\124\124\059\037\027\018\044\012\124\037\079\021\108\018\012\079\112\037\019\012\037\040\029\021\108\112\037\040\066\021\108\124\018\045\037\086\014\040\018\012\014\044\037\040\018\021\108\037\012\040\019\037\009\066\124\124\079\112\037\027\029\014\019\014\044\059\037\027\014\040\040\037\019\012\037\087\014\044\014\029\112\037\087\029\079\112\010"), 
			Media = zmediaStripeyTiger_MSG
		}
	end
end
function zinputAfricanSavanna:OnGetInput(input)
	if input == nil then
		input = ""
	end
	AfricanAnswer = tonumber(input)
	if (AfricanAnswer == 5) or (AfricanAnswer == 6) then
		ztaskFindtheHipposDrainPlug.Complete = true
		zcharacterZebra:MoveTo(zoneAfricanVillage)
		ZooChat = _O5Os("\102\046")
		_Urwigo.MessageBox{
			Text = _O5Os("\122\029\040\037\006\014\087\044\018\037\009\066\124\124\112\037\040\014\012\086\029\014\044\029\086\037\018\012\038\037\019\029\021\108\037\047\012\086\014\045\018\012\038\014\040\028\028\028\028"), 
			Media = zmediaZebra_MSG
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\096\124\059\037\040\014\029\040\028\037\024\066\124\124\037\027\029\014\019\014\044\059\037\027\014\040\040\037\019\012\037\014\029\040\014\037\087\014\079\079\014\044\014\037\085\040\112\027\066\044\112\037\108\018\079\112\028"), 
			Media = zmediaZookeeper_MSG
		}
	end
end
function zinputTropicalAsia:OnGetInput(input)
	if input == nil then
		input = ""
	end
	TropicalAsiaAnswer = input
	if Wherigo.NoCaseEquals(TropicalAsiaAnswer, _O5Os("\019")) or Wherigo.NoCaseEquals(TropicalAsiaAnswer, _O5Os("\095")) then
		zitemKokothePenguin:MoveTo(zoneTropicalAsia)
		ZooChat = _O5Os("\102\119")
		SiamangChat = _O5Os("\092")
		_Urwigo.MessageBox{
			Text = _O5Os("\120\018\059\037\019\018\079\037\029\079\112\037\014\026\018\009\112\037\044\029\021\108\112\029\086\099\037\107\012\112\014\037\085\044\087\014\029\112\099\118\005\003\033\036\012\040\037\086\044\014\029\038\037\019\029\044\037\079\021\108\040\014\045\045\037\019\014\040\037\113\029\040\086\012\029\040\037\024\066\009\066\028"), 
			Media = zmediaOrangutanPenguin
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\036\014\029\040\059\037\079\066\037\079\112\014\108\112\037\019\018\079\037\040\029\021\108\112\037\018\012\038\037\019\014\124\037\008\021\108\029\045\019\037\100\037\079\021\108\018\012\037\040\066\021\108\124\018\045\037\086\014\040\018\012\037\040\018\021\108\099"), 
			Media = zmediaSiamang_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputTropicalAsia)
					end)
				end
			end
		}
	end
end
function zinputTemperateForest:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	TemperateAnswer = input
	if TemperateAnswer == 1 then
		PigChat = _O5Os("\092")
		ZooChat = _O5Os("\092\102")
		zitemBrianthePenguin:MoveTo(zoneTemperateForest)
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\120\018\059\037\019\018\079\037\029\079\112\037\027\066\108\045\037\044\029\021\108\112\029\086\099\118\005\003\033\118\005\003\033\095\018\037\029\079\112\037\005\018\021\014\045\045\014\037\019\014\044\037\113\029\040\086\012\029\040\059\037\045\066\079\037\086\044\014\029\038\037\029\108\040\059\037\087\014\039\066\044\037\014\044\037\027\029\014\019\014\044\037\027\014\086\044\014\040\040\014\040\037\009\018\040\040\028"), 
				Media = zmediaHappyPig_MSG
			}
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\096\124\059\037\040\014\029\040\059\037\019\018\079\037\029\079\112\037\040\029\021\108\112\037\044\029\021\108\112\029\086\028\037\020\014\044\079\012\021\108\037\014\029\040\014\037\018\040\019\014\044\014\037\006\018\108\045\028"), 
			Media = zmediaHappyPig_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputTemperateForest)
					end)
				end
			end
		}
	end
end
function zinputRainForest:OnGetInput(input)
	if input == nil then
		input = ""
	end
	RainForestAnswer = input
	if Wherigo.NoCaseEquals(RainForestAnswer, _O5Os("\001\018\026\029")) then
		ZooChat = _O5Os("\092\061")
		ColobusChat = _O5Os("\102")
		zitemShampoo:MoveTo(Player)
		zitemShampoo.Commands.UseWith.Enabled = true
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\107\012\112\059\037\079\021\108\066\014\040\037\086\014\124\018\021\108\112\028\037\118\005\003\033\095\014\044\037\113\029\040\086\012\029\040\037\108\018\112\037\019\029\021\108\037\009\066\124\124\014\040\037\079\014\108\014\040\037\012\040\019\037\029\079\112\037\047\012\124\037\107\066\044\029\045\045\018\037\086\014\045\018\012\038\014\040\028\037\040\018\037\101\018\059\037\047\012\124\029\040\019\014\079\112\037\027\029\044\019\037\014\044\037\124\029\021\108\037\040\029\021\108\112\037\124\014\108\044\037\079\112\066\014\044\014\040\028\118\005\003\033\118\005\003\033\095\014\079\027\014\086\014\040\037\086\014\087\014\037\029\021\108\037\019\029\044\037\019\018\079\037\008\108\018\124\109\066\066\059\037\039\029\014\045\037\107\045\012\014\021\009\037\019\018\124\029\112\028"), 
				Media = zmediaColobus_MSG
			}, 
			{
				Text = _O5Os("\036\014\012\014\044\037\107\014\086\014\040\079\112\018\040\019\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\008\108\018\124\109\066\066"), 
				Media = zmediaShampoo_MSG
			}
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\036\014\029\040\059\037\019\018\079\037\029\079\112\037\040\029\021\108\112\037\044\029\021\108\112\029\086\059\037\039\014\044\079\012\021\108\056\079\037\040\066\021\108\124\018\045\028"), 
			Media = zmediaColobus_MSG
		}
	end
end
function zcharacterZookeeper:OnTalk(target)
	if Wherigo.NoCaseEquals(ZooChat, _O5Os("\119")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\095\029\014\037\113\029\040\086\012\029\040\014\037\079\029\040\019\037\029\124\124\014\044\037\079\014\108\044\037\040\014\112\112\028\037\020\014\044\079\012\021\108\037\124\029\112\037\029\108\040\014\040\037\047\012\037\009\066\124\124\012\040\029\047\029\014\044\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\121\029\044\037\124\012\014\079\079\014\040\037\019\029\014\037\113\029\040\086\012\029\040\014\037\027\029\014\019\014\044\038\029\040\019\014\040\028\037\078\018\079\079\037\012\040\079\037\047\012\014\044\079\112\037\029\124\037\008\112\044\014\029\021\108\014\045\047\066\066\037\040\018\021\108\079\021\108\018\012\014\040\028\118\005\003\033\118\005\003\033\121\014\040\040\037\019\012\037\019\029\044\037\040\029\021\108\112\037\079\029\021\108\014\044\037\087\029\079\112\059\037\027\018\079\037\019\012\037\040\012\040\037\112\012\040\037\079\066\045\045\079\112\059\037\079\021\108\018\012\037\047\012\037\019\014\040\037\110\078\066\021\018\112\029\066\040\079\110\037\066\019\014\044\037\040\012\112\047\014\037\019\029\014\037\024\018\044\112\014\037\013\124\018\109\055\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\078\066\079\059\037\044\014\019\014\037\124\029\112\037\019\014\124\037\005\044\018\012\040\087\018\014\044\028\037\122\044\037\009\018\040\040\037\012\040\079\037\039\029\014\045\045\014\029\021\108\112\037\108\014\045\038\014\040\059\037\014\029\040\014\040\037\113\029\040\086\012\029\040\037\047\012\037\038\029\040\019\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\092")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\040\014\037\019\014\040\037\121\014\021\009\014\044\037\087\014\009\066\124\124\014\040\037\027\029\044\037\019\014\040\037\005\018\014\044\014\040\037\040\029\014\037\027\018\021\108\028\037\121\066\037\029\079\112\037\019\014\044\037\040\012\044\037\010"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\046")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\008\012\109\014\044\059\037\095\012\037\108\018\079\112\037\019\014\040\037\121\014\021\009\014\044\037\087\014\009\066\124\124\014\040\028\037\036\012\040\037\124\012\079\079\112\037\019\012\037\029\108\040\037\040\012\044\037\040\066\021\108\037\110\087\014\040\012\112\047\014\040\110\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\007")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\120\029\109\029\014\059\037\019\012\037\108\018\079\112\037\008\018\087\018\059\037\019\014\029\040\014\040\037\014\044\079\112\014\040\037\113\029\040\086\012\029\040\037\086\014\038\012\040\019\014\040\028\037\110\036\029\124\124\110\037\029\108\040\059\037\079\066\037\019\018\079\079\037\014\044\037\012\040\079\037\040\029\021\108\112\037\124\014\108\044\037\027\014\086\045\018\012\038\014\040\037\009\018\040\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\061")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\126\021\108\037\039\014\044\124\012\112\014\059\037\019\014\044\037\040\018\014\021\108\079\112\014\037\113\029\040\086\012\029\040\037\029\079\112\037\027\014\029\112\014\044\037\086\014\045\018\012\038\014\040\028\037\078\018\079\079\037\012\040\079\037\087\014\029\037\019\014\040\037\117\018\040\012\045\079\059\037\019\014\040\037\009\045\014\029\040\014\040\037\003\018\012\087\009\018\112\047\014\040\037\040\018\021\108\079\021\108\018\012\014\040\059\037\066\087\037\027\029\044\037\019\066\044\112\037\014\112\027\018\079\037\108\014\044\018\012\079\038\029\040\019\014\040\037\009\066\014\040\040\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\032")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\059\037\045\018\079\079\037\012\040\079\037\124\029\112\037\019\014\124\037\001\029\086\014\044\037\044\014\019\014\040\059\037\019\014\044\037\079\029\014\108\112\037\047\029\014\124\045\029\021\108\037\047\014\044\009\040\029\044\079\021\108\112\037\018\012\079\028\037\020\029\014\045\045\014\029\021\108\112\037\009\066\014\040\040\014\040\037\027\029\044\037\029\108\040\037\018\012\038\124\012\040\112\014\044\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\070")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\085\012\038\059\037\079\012\021\108\014\040\037\027\029\044\037\019\029\014\037\008\112\044\014\029\038\014\040\037\019\014\079\037\001\029\086\014\044\079\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\025")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\014\030\059\037\019\012\037\108\018\079\112\037\019\029\014\037\008\112\044\014\029\038\014\040\037\086\014\038\012\040\019\014\040\028\037\110\107\029\087\110\037\079\029\014\037\029\108\124\037\047\012\044\012\014\021\009\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\052\119")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\124\124\124\059\037\027\029\044\037\124\012\014\079\079\014\040\037\027\018\079\037\027\029\044\009\045\029\021\108\037\024\045\014\087\044\029\086\014\079\037\038\029\040\019\014\040\059\037\012\124\037\019\029\014\037\008\112\044\014\029\038\014\040\037\027\029\014\019\014\044\037\018\040\047\012\087\044\029\040\086\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\052\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\029\014\044\037\108\018\079\037\019\012\037\014\112\027\018\079\037\044\029\021\108\112\029\086\037\009\045\014\087\044\029\086\014\040\037\096\066\040\029\086\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\052\102")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\095\014\044\037\001\029\086\014\044\037\039\014\044\124\012\112\014\112\059\037\019\018\079\079\037\079\029\021\108\037\014\029\040\014\044\037\019\014\044\037\113\029\040\086\012\029\040\014\037\018\045\079\037\117\018\040\012\045\037\039\014\044\009\045\014\029\019\014\112\037\108\018\112\028\037\008\021\108\018\012\037\124\018\045\037\086\014\040\018\012\037\018\040\037\019\014\124\037\107\014\108\014\086\014\037\019\014\044\037\117\018\040\012\045\079\037\040\018\021\108\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\052\092")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\095\012\037\108\018\079\112\037\014\029\040\014\040\037\113\029\040\086\012\029\040\037\086\014\038\012\040\019\014\040\099\037\110\036\029\124\124\110\037\029\108\040\059\037\087\014\039\066\044\037\014\044\037\027\029\014\019\014\044\037\027\014\086\044\014\040\040\014\040\037\009\018\040\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\052\046")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\078\018\079\079\037\012\040\079\037\047\012\124\037\085\038\038\014\040\108\018\012\079\037\086\014\108\014\040\059\037\039\014\044\079\012\021\108\014\040\037\027\029\044\037\019\066\044\112\037\012\040\079\014\044\037\107\045\012\014\021\009\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\052\007")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\126\021\108\037\087\029\040\037\087\014\079\066\044\086\112\037\027\014\086\014\040\037\019\014\124\037\008\021\108\029\124\109\018\040\079\014\040\028\037\107\014\108\037\047\012\037\029\108\124\037\012\040\019\037\110\044\014\019\014\110\037\124\029\112\037\029\108\124\059\037\012\124\037\108\014\044\018\012\079\047\012\038\029\040\019\014\040\059\037\066\087\037\124\029\112\037\029\108\124\037\018\045\045\014\079\037\009\045\018\044\037\029\079\112\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\052\061")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\020\029\014\045\045\014\029\021\108\112\037\027\014\029\079\079\037\019\029\014\037\113\030\112\108\066\040\059\037\027\018\079\037\124\029\112\037\019\014\124\037\008\021\108\029\124\109\018\040\079\014\040\037\109\018\079\079\029\014\044\112\037\029\079\112\028\037\003\014\019\014\037\019\066\021\108\037\124\018\045\037\124\029\112\037\029\108\044\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\052\032")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\029\045\038\037\019\014\044\037\113\030\112\108\066\040\037\100\037\110\036\029\124\124\110\037\019\029\014\037\008\112\029\124\124\014\037\019\014\079\037\008\021\108\029\124\109\018\040\079\014\040\037\087\014\039\066\044\037\079\029\014\037\027\029\014\019\014\044\037\039\014\044\045\066\044\014\040\037\086\014\108\112\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\052\070")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\107\029\087\037\019\014\124\037\008\021\108\029\124\018\040\079\014\040\037\079\014\029\040\014\037\008\112\029\124\124\014\037\027\029\014\019\014\044\037\047\012\044\012\014\021\009\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\052\025")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\066\038\038\014\040\112\045\029\021\108\037\038\029\040\019\014\040\037\027\029\044\037\108\014\044\018\012\079\059\037\027\066\037\079\029\021\108\037\019\029\014\079\014\044\037\113\029\040\086\012\029\040\037\039\014\044\079\112\014\021\009\112\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102\119")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\095\012\037\108\018\079\112\037\019\014\040\037\113\029\040\086\012\029\040\037\024\066\009\066\037\086\014\038\012\040\019\014\040\099\037\110\036\029\124\124\110\037\029\108\040\037\124\029\112\059\037\087\014\039\066\044\037\014\044\037\027\029\014\019\014\044\037\027\014\086\044\014\040\040\014\040\037\009\018\040\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\126\021\108\037\108\018\087\037\014\087\014\040\037\086\014\108\066\014\044\112\059\037\014\029\040\014\044\037\019\014\044\037\113\029\040\086\012\029\040\014\037\079\014\029\037\087\014\029\037\019\014\044\037\018\038\044\029\009\018\040\029\079\021\108\014\040\037\008\018\039\018\040\040\014\037\086\014\079\014\108\014\040\037\027\066\044\019\014\040\028\037\078\018\079\079\037\012\040\079\037\079\021\108\040\014\045\045\037\108\029\040\037\086\014\108\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102\102")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\003\014\019\014\037\124\029\112\037\019\014\124\037\036\029\045\109\038\014\044\019\059\037\039\029\014\045\045\014\029\021\108\112\037\027\014\029\079\079\037\014\079\037\029\044\086\014\040\019\037\014\112\027\018\079\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102\092")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\078\018\079\079\037\012\040\079\037\029\124\037\085\038\044\029\009\018\108\018\012\079\037\040\018\021\108\037\019\014\044\037\085\040\112\027\066\044\112\037\079\012\021\108\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102\092\018")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\018\079\112\037\095\012\037\108\014\044\018\012\079\086\014\038\012\040\019\014\040\059\037\027\014\045\021\108\014\079\037\001\029\014\044\037\027\029\044\037\079\012\021\108\014\040\010"), 
			Media = zmediaZookeeper_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputAfricanSavanna)
					end)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102\046")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\003\014\019\014\037\124\029\112\037\019\014\124\037\006\014\087\044\018\059\037\039\029\014\045\045\014\029\021\108\112\037\027\014\029\079\079\037\014\079\059\037\027\066\037\027\029\044\037\040\018\021\108\037\019\014\124\037\040\018\014\021\108\079\112\014\040\037\113\029\040\086\012\029\040\037\079\012\021\108\014\040\037\124\012\014\079\079\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102\007")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\107\029\087\037\019\014\124\037\036\029\045\109\038\014\044\019\037\019\014\040\037\008\112\066\014\109\079\014\045\037\047\012\044\012\014\021\009\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102\061")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\095\012\037\108\018\079\112\037\014\040\019\045\029\021\108\037\005\014\040\037\019\014\040\037\113\029\040\086\012\029\040\037\086\014\038\012\040\019\014\040\059\037\045\066\079\059\037\110\040\029\124\124\110\037\029\108\040\059\037\019\018\124\029\112\037\014\044\037\040\029\021\108\112\037\040\066\021\108\124\018\045\037\014\040\112\027\029\079\021\108\014\040\037\009\018\040\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102\032")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\060\009\018\030\059\037\018\012\038\037\086\014\108\112\056\079\037\029\040\037\019\029\014\037\086\014\124\018\014\079\079\029\086\112\014\040\037\005\044\014\029\112\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102\070")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\059\037\019\018\079\037\008\021\108\027\014\029\040\037\079\021\108\018\012\112\037\018\087\014\044\037\012\040\086\045\012\014\021\009\045\029\021\108\037\019\044\014\029\040\028\037\121\029\014\037\009\066\014\040\040\014\040\037\027\029\044\037\029\108\124\037\040\012\044\037\108\014\045\038\014\040\010"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\102\025")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\085\044\124\014\079\037\008\021\108\027\014\029\040\037\100\037\027\029\014\037\009\066\014\040\040\014\040\037\027\029\044\037\019\029\044\037\040\012\044\037\108\014\045\038\014\040\059\037\019\018\079\079\037\019\014\029\040\037\008\021\108\027\018\040\047\037\027\029\014\019\014\044\037\086\014\044\029\040\086\014\045\112\037\027\029\044\019\010"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\092\119")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\126\021\108\037\027\012\014\040\079\021\108\112\014\059\037\027\029\044\037\009\066\014\040\040\112\014\040\037\019\014\124\037\018\044\124\014\040\037\008\021\108\027\014\029\040\037\108\014\045\038\014\040\059\037\124\018\045\037\079\021\108\018\012\014\040\059\037\066\087\037\014\044\037\019\029\014\079\014\037\006\029\112\044\066\040\014\037\124\018\086\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\092\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\029\045\038\037\019\014\124\037\008\021\108\027\014\029\040\059\037\079\014\029\040\014\037\076\044\018\086\014\037\047\012\037\087\014\018\040\112\027\066\044\112\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\092\102")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\107\044\066\079\079\018\044\112\029\086\099\037\110\036\029\124\124\110\037\040\012\040\037\019\014\040\037\113\029\040\086\012\029\040\037\005\018\021\014\045\045\014\037\124\029\112\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\092\092")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\085\012\038\037\047\012\124\037\085\038\038\014\040\109\018\044\009\059\037\019\066\044\112\037\079\012\021\108\014\040\037\027\029\044\037\019\014\040\037\045\014\112\047\112\014\040\037\019\014\044\037\113\029\040\086\012\029\040\014\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\092\046")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\037\117\018\040\040\059\037\027\018\079\037\029\079\112\037\019\014\040\040\037\040\012\044\037\029\124\037\107\066\044\029\045\045\018\009\018\014\038\029\086\037\045\066\079\010"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\092\007")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\121\029\044\037\124\012\014\079\079\014\040\037\019\014\040\037\018\040\019\014\044\014\040\037\085\038\038\014\040\037\019\018\079\037\008\108\018\124\109\066\066\037\027\029\014\019\014\044\037\027\014\086\040\014\108\124\014\040\059\037\019\018\079\037\079\029\014\037\019\014\124\037\107\066\044\029\045\045\018\037\086\014\079\112\066\108\045\014\040\037\108\018\087\014\040\028\118\005\003\033\095\029\014\079\014\037\096\018\018\044\038\018\044\087\014\037\079\112\014\108\112\037\029\108\124\037\014\029\040\038\018\021\108\037\040\029\021\108\112\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\092\061")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\078\066\079\059\037\086\029\087\037\019\014\124\037\107\066\044\029\045\045\018\037\019\018\079\037\008\108\018\124\109\066\066\059\037\019\018\124\029\112\037\014\044\037\027\029\014\019\014\044\037\110\040\066\044\124\018\045\110\037\018\012\079\079\014\108\014\040\037\009\018\040\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\092\032")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\078\066\079\037\087\014\014\029\045\037\019\029\021\108\059\037\040\029\124\124\037\120\066\009\066\037\019\014\040\037\113\029\040\086\012\029\040\037\124\029\112\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\092\070")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\107\044\066\079\079\018\044\112\029\086\014\037\085\044\087\014\029\112\028\037\036\012\040\037\086\014\108\037\047\012\044\012\014\021\009\037\047\012\124\037\113\029\040\086\012\029\040\087\014\021\009\014\040\037\012\040\019\037\079\066\044\086\014\037\019\018\038\012\014\044\059\037\019\018\079\079\037\019\029\014\037\003\018\021\009\014\044\037\027\029\014\019\014\044\037\029\040\037\029\108\044\037\107\014\108\014\086\014\037\009\066\124\124\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif Wherigo.NoCaseEquals(ZooChat, _O5Os("\092\025")) then
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\121\012\040\019\014\044\087\018\044\099\037\095\012\037\108\018\079\112\037\124\029\044\037\086\045\012\014\021\009\045\029\021\108\014\044\027\014\029\079\014\037\086\014\108\066\045\038\014\040\059\037\018\045\045\014\037\113\029\040\086\012\029\040\014\037\027\029\014\019\014\044\037\014\029\040\047\012\038\018\040\086\014\040\037\012\040\019\037\108\018\079\112\037\079\029\014\037\027\029\014\019\014\044\037\029\040\037\029\108\044\037\005\014\021\009\014\040\037\086\014\087\044\018\021\108\112\028\037\036\012\040\037\009\018\040\040\037\029\021\108\037\079\029\014\037\014\040\019\045\029\021\108\037\038\012\014\112\112\014\044\040\037\012\040\019\037\027\029\044\037\009\066\014\040\040\014\040\037\027\029\014\019\014\044\037\040\066\044\124\018\045\037\027\014\029\112\014\044\037\018\044\087\014\029\112\014\040\028\118\005\003\033\118\005\003\033\020\029\014\045\014\040\037\095\018\040\009\037\038\012\014\044\037\019\014\029\040\014\037\096\029\045\038\014\099\037\020\029\014\045\037\008\109\018\079\079\037\040\066\021\108\037\108\029\014\044\037\029\124\037\006\066\066\028"), 
				Media = zmediaZookeeper_MSG
			}, 
			{
				Text = _O5Os("\085\045\079\037\095\018\040\009\037\038\012\014\044\037\019\014\029\040\014\037\096\029\045\038\014\037\038\029\040\019\014\079\112\037\019\012\037\087\014\029\037\118\005\003\033\036\037\046\025\037\052\092\028\032\102\119\037\100\037\122\037\032\037\119\102\028\102\032\025\037\014\029\040\014\037\095\066\079\014\059\037\029\040\037\019\014\044\037\019\012\037\019\014\029\040\014\037\122\044\045\014\087\040\029\079\079\014\037\039\014\044\014\027\029\086\014\040\037\009\018\040\040\079\112\028\037\013\096\029\040\112\035\037\047\014\044\087\044\066\021\108\014\040\014\079\037\107\045\018\079\055"), 
				Media = zmediaIntro
			}, 
			{
				Text = _O5Os("\095\014\044\037\076\044\014\029\079\021\108\018\045\112\021\066\019\014\037\038\012\014\044\037\019\029\014\037\017\018\044\019\044\029\019\086\014\037\029\079\112\035\037")..string.sub(Player.CompletionCode, 1, 15), 
				Media = zmediaIntro
			}
		}
	end
end
function zcharacterPenguins:OnPhotograph(target)
	ZooChat = _O5Os("\052")
	zcharacterPenguins.Visible = false
	ztaskVisittheNorthernTrail.Visible = true
	ztaskVisittheNorthernTrail.Active = true
	ztaskHelpRoundUpthePenguins.Visible = true
	ztaskHelpRoundUpthePenguins.Active = true
	zoneNorthernTrail.Visible = true
	zoneNorthernTrail.Active = true
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\121\018\079\037\038\012\014\044\037\014\029\040\037\005\045\029\112\047\045\029\021\108\112\086\014\027\029\112\112\014\044\099\118\005\003\033\118\005\003\033\095\029\014\037\113\029\040\086\012\029\040\014\037\044\014\040\040\014\040\037\018\012\038\086\014\044\014\086\112\037\029\040\037\018\045\045\014\037\003\029\021\108\112\012\040\086\014\040\037\019\018\039\066\040\059\037\027\018\014\108\044\014\040\019\037\079\029\014\037\124\029\112\037\029\108\044\014\040\037\008\112\012\124\124\014\045\038\045\012\014\086\014\045\040\037\019\029\014\037\085\012\086\014\040\037\087\014\019\014\021\009\014\040\028\118\005\003\033\118\005\003\033\008\029\014\037\079\112\066\079\079\014\040\037\019\018\079\037\107\018\112\112\014\044\037\018\012\038\037\012\040\019\037\079\112\012\014\044\124\014\040\037\029\040\037\018\045\045\014\037\003\029\021\108\112\012\040\086\014\040\037\019\018\039\066\040\028\118\005\003\033")
		}, 
		{
			Text = _O5Os("\110\060\108\037\117\018\040\040\037\099\110\037\095\012\037\009\018\040\040\040\079\112\037\019\066\021\108\037\019\029\014\037\001\029\014\044\014\037\040\029\021\108\112\037\124\029\112\037\019\014\029\040\014\124\037\005\045\029\112\047\037\014\044\079\021\108\044\014\021\009\014\040\028\118\005\003\033\118\005\003\033\036\012\040\037\124\012\079\079\037\029\021\108\037\019\029\014\037\001\029\014\044\014\037\027\029\014\019\014\044\037\014\029\040\038\018\040\086\014\040\059\037\018\087\014\044\037\019\012\037\124\012\079\079\112\037\124\029\044\037\019\018\087\014\029\037\108\014\045\038\014\040\028\037\078\018\079\079\037\012\040\079\037\047\012\014\044\079\112\037\047\012\124\037\008\112\044\014\029\021\108\014\045\047\066\066\037\086\014\108\014\040\028\110"), 
			Media = zmediaZookeeper_MSG
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\037\076\018\040\086\014\037\018\045\045\014\037\113\029\040\086\012\029\040\014\037\027\029\014\019\014\044\037\014\029\040\028"), 
			Media = zmediaPenguins
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\037\107\014\108\014\037\047\012\124\037\008\112\044\014\029\021\108\014\045\047\066\066\028\037\008\021\108\018\012\037\047\012\037\019\014\040\037\110\078\066\021\018\112\029\066\040\079\110\037\087\047\027\028\037\047\012\044\037\024\018\044\112\014\028"), 
			Media = zmediaZoneNorthernTrail
		}
	}
end
function zcharacterPenguins:OnYell(target)
	ZooChat = _O5Os("\052")
	zcharacterPenguins.Visible = false
	ztaskVisittheNorthernTrail.Visible = true
	ztaskVisittheNorthernTrail.Active = true
	ztaskHelpRoundUpthePenguins.Visible = true
	ztaskHelpRoundUpthePenguins.Active = true
	zoneNorthernTrail.Visible = true
	zoneNorthernTrail.Active = true
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\060\108\059\037\027\029\014\037\045\018\012\112\099\118\005\003\033\118\005\003\033\095\029\014\037\113\029\040\086\012\029\040\014\037\108\018\045\112\014\040\037\079\029\021\108\037\124\029\112\037\029\108\044\014\040\037\008\112\012\124\124\014\045\038\045\012\014\086\014\045\040\037\019\029\014\037\060\108\044\014\040\037\047\012\028\118\005\003\033\118\005\003\033\008\029\014\037\079\112\066\079\079\014\040\037\019\018\079\037\107\018\112\112\014\044\037\018\012\038\037\012\040\019\037\079\112\012\014\044\124\014\040\037\029\040\037\018\045\045\014\037\003\029\021\108\112\012\040\086\014\040\037\019\018\039\066\040\028")
		}, 
		{
			Text = _O5Os("\117\018\040\040\059\037\101\014\112\047\112\037\108\018\079\112\037\095\012\037\019\029\014\037\001\029\014\044\014\037\112\066\112\018\045\037\014\044\079\021\108\044\014\021\009\112\028\118\005\003\033\118\005\003\033\036\012\040\037\124\012\079\079\037\029\021\108\037\019\029\014\037\001\029\014\044\014\037\027\029\014\019\014\044\037\014\029\040\038\018\040\086\014\040\059\037\018\087\014\044\037\019\012\037\124\012\079\079\112\037\124\029\044\037\019\018\087\014\029\037\108\014\045\038\014\040\028\037\078\018\079\079\037\012\040\079\037\047\012\014\044\079\112\037\047\012\124\037\008\112\044\014\029\021\108\014\045\047\066\066\037\086\014\108\014\040\028\110"), 
			Media = zmediaZookeeper_MSG
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\037\076\018\040\086\014\037\018\045\045\014\037\113\029\040\086\012\029\040\014\037\027\029\014\019\014\044\037\014\029\040\028"), 
			Media = zmediaPenguins
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\037\107\014\108\014\037\047\012\124\037\008\112\044\014\029\021\108\014\045\047\066\066\028\037\008\021\108\018\012\037\047\012\037\019\014\040\037\110\078\066\021\018\112\029\066\040\079\110\037\087\047\027\028\037\047\012\044\037\024\018\044\112\014\028"), 
			Media = zmediaZoneNorthernTrail
		}
	}
end
function zcharacterPenguins:OnFeed(target)
	ZooChat = _O5Os("\052")
	zcharacterPenguins.Visible = false
	zcharacterPenguins:MoveTo(nil)
	ztaskVisittheNorthernTrail.Visible = true
	ztaskVisittheNorthernTrail.Active = true
	ztaskHelpRoundUpthePenguins.Visible = true
	ztaskHelpRoundUpthePenguins.Active = true
	zoneNorthernTrail.Visible = true
	zoneNorthernTrail.Active = true
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\095\012\037\044\014\029\021\108\079\112\037\014\029\040\014\040\037\018\045\112\014\040\037\117\012\014\079\045\029\044\029\014\086\014\045\037\012\014\087\014\044\037\019\018\079\037\107\029\112\112\014\044\059\037\027\066\044\018\012\038\108\029\040\037\019\029\014\037\113\029\040\086\012\029\040\014\037\027\029\045\019\037\012\124\108\014\044\079\021\108\040\018\109\109\014\040\019\037\108\014\044\012\124\045\018\012\038\014\040\028\118\005\003\033\118\005\003\033\008\029\014\037\079\112\066\079\079\014\040\037\019\018\079\037\107\018\112\112\014\044\037\018\012\038\037\012\040\019\037\079\112\012\014\044\124\014\040\037\029\040\037\018\045\045\014\037\003\029\021\108\112\012\040\086\014\040\037\019\018\039\066\040\028")
		}, 
		{
			Text = _O5Os("\117\018\040\040\059\037\014\029\040\014\037\019\014\044\037\027\029\021\108\112\029\086\079\112\014\040\037\003\014\086\014\045\037\029\124\037\006\066\066\037\029\079\112\037\019\066\021\108\035\037\038\012\014\112\112\014\044\014\037\009\014\029\040\014\037\001\029\014\044\014\099\118\005\003\033\118\005\003\033\036\012\040\037\124\012\079\079\037\029\021\108\037\019\029\014\037\001\029\014\044\014\037\027\029\014\019\014\044\037\014\029\040\038\018\040\086\014\040\059\037\018\087\014\044\037\019\012\037\124\012\079\079\112\037\124\029\044\037\019\018\087\014\029\037\108\014\045\038\014\040\028\037\078\018\079\079\037\012\040\079\037\047\012\014\044\079\112\037\047\012\124\037\008\112\044\014\029\021\108\014\045\047\066\066\037\086\014\108\014\040\028\110"), 
			Media = zmediaZookeeper_MSG
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\037\076\018\040\086\014\037\018\045\045\014\037\113\029\040\086\012\029\040\014\037\027\029\014\019\014\044\037\014\029\040\028"), 
			Media = zmediaPenguins
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\037\107\014\108\014\037\047\012\124\037\008\112\044\014\029\021\108\014\045\047\066\066\028\037\008\021\108\018\012\037\047\012\037\019\014\040\037\110\078\066\021\018\112\029\066\040\079\110\037\087\047\027\028\037\047\012\044\037\024\018\044\112\014\028"), 
			Media = zmediaZoneNorthernTrail
		}
	}
end
function zcharacterPenguins:OnExamine(target)
	if ztaskHelpRoundUpthePenguins.Complete == true then
		_Urwigo.MessageBox{
			Text = _O5Os("\095\029\014\037\113\029\040\086\012\029\040\014\037\079\021\108\027\029\124\124\014\040\037\038\044\066\014\108\045\029\021\108\037\012\040\019\037\018\045\087\014\044\040\019\037\029\040\037\029\108\044\014\124\037\005\014\021\009\014\040\037\108\014\044\012\124\028")
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\095\014\044\037\096\012\124\087\066\045\019\112\109\029\040\086\012\029\040\037\018\014\108\040\014\045\112\037\029\040\037\079\014\029\040\014\044\037\122\044\079\021\108\014\029\040\012\040\086\037\018\045\045\014\040\037\018\040\019\014\044\014\040\037\005\044\029\045\045\014\040\109\029\040\086\012\029\040\014\040\037\012\040\019\037\014\044\044\014\029\021\108\112\037\014\029\040\014\037\107\044\066\014\079\079\014\037\039\066\040\037\087\029\079\037\047\012\037\046\007\037\021\124\037\012\040\019\037\014\029\040\037\019\012\044\021\108\079\021\108\040\029\112\112\045\029\021\108\014\079\037\107\014\027\029\021\108\112\037\039\066\040\037\046\037\009\086\028\037\118\005\003\033\118\005\003\033\121\029\014\037\018\045\045\014\037\113\029\040\086\012\029\040\014\037\029\079\112\037\018\012\021\108\037\019\014\044\037\096\012\124\087\066\045\019\112\109\029\040\086\012\029\040\037\018\040\037\014\029\040\037\078\014\087\014\040\037\029\124\037\121\018\079\079\014\044\037\108\066\021\108\037\018\040\086\014\109\018\079\079\112\028\037\117\029\112\037\029\108\044\014\124\037\009\012\044\047\014\040\037\008\021\108\027\018\040\047\037\012\040\019\037\019\014\040\037\027\014\029\112\037\040\018\021\108\037\108\029\040\112\014\040\037\039\014\044\079\014\112\047\112\014\040\037\076\012\014\079\079\014\040\059\037\019\029\014\037\029\108\044\037\014\029\040\014\040\037\018\012\038\044\014\021\108\112\014\040\037\107\018\040\086\037\014\044\124\066\014\086\045\029\021\108\014\040\059\037\018\014\108\040\014\045\112\037\019\029\014\079\014\037\085\044\112\037\039\066\124\037\024\066\014\044\109\014\044\087\018\012\037\018\045\045\014\040\037\018\040\019\014\044\014\040\037\113\029\040\086\012\029\040\014\040\028\037\118\005\003\033\118\005\003\033\095\018\079\037\107\014\038\029\014\019\014\044\037\029\079\112\037\029\040\037\047\027\014\029\037\008\021\108\029\021\108\112\014\040\037\018\012\038\086\014\087\018\012\112\028\037\095\029\014\037\014\044\079\112\014\037\076\014\019\014\044\079\021\108\029\021\108\112\037\029\079\112\037\018\087\086\014\038\045\018\021\108\112\037\012\040\019\037\079\021\108\012\014\112\047\112\037\019\018\079\037\001\029\014\044\037\039\066\044\037\018\014\012\079\079\014\044\014\040\037\122\029\040\038\045\012\014\079\079\014\040\037\027\029\014\037\121\029\040\019\037\012\040\019\037\121\018\079\079\014\044\059\037\027\066\086\014\086\014\040\037\019\029\014\037\047\027\014\029\112\014\037\008\021\108\029\021\108\112\037\019\014\044\037\121\018\014\044\124\014\029\079\066\045\018\112\029\066\040\037\019\029\014\040\112\037\028"), 
			Media = zmediaPenguins_MSG
		}
	end
end
function zcharacterBrownBear:OnTalk(target)
	if Wherigo.NoCaseEquals(ZooChat, _O5Os("\102")) then
		ZooChat = _O5Os("\092")
		zcharacterSnowyOwl:MoveTo(zoneNorthernTrail)
		ztaskWakeupBrownBear.Visible = true
		ztaskWakeupBrownBear.Active = true
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\110\006\006\006\006\006\006\006\006\006\006\006\006\006\006\006\006\110\118\005\003\033\118\005\003\033\095\014\044\037\005\044\018\012\040\087\018\014\044\037\079\021\108\045\018\014\038\112\037\027\066\108\045\028"), 
				Media = zmediaBrownBearSleeping_MSG
			}, 
			{
				Text = _O5Os("\060\108\037\040\014\029\040\059\037\066\108\040\014\037\079\014\029\040\014\040\037\121\014\021\009\014\044\037\009\018\040\040\037\019\014\044\037\005\044\018\012\040\087\018\014\044\037\040\029\021\108\112\037\018\012\038\027\018\021\108\014\040\028\037\121\029\044\037\124\012\014\079\079\014\040\037\029\108\040\037\038\029\040\019\014\040\059\037\019\018\124\029\112\037\027\029\044\037\029\108\040\037\027\014\021\009\014\040\037\009\066\014\040\040\014\040\028\118\005\003\033\118\005\003\033\085\087\014\044\037\079\021\108\018\012\037\124\018\045\059\037\019\018\037\009\066\124\124\112\037\014\029\040\014\037\008\021\108\040\014\014\014\012\045\014\037\086\014\038\045\066\086\014\040\028"), 
				Media = zmediaZookeeper_MSG
			}
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\110\006\006\006\006\006\006\006\006\006\006\006\006\006\006\006\006\110\118\005\003\033\118\005\003\033\095\014\044\037\005\044\018\012\040\087\018\014\044\037\079\021\108\045\018\014\038\112\037\027\066\108\045\028"), 
			Media = zmediaBrownBearSleeping_MSG
		}
	end
end
function zcharacterBrownBear:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\018\037\005\044\018\012\040\087\018\014\044\014\040\037\027\018\014\108\044\014\040\019\037\019\014\044\037\121\029\040\112\014\044\124\066\040\018\112\014\037\040\029\021\108\112\037\086\014\040\012\086\037\036\018\108\044\012\040\086\037\038\029\040\019\014\040\059\037\087\014\086\014\087\014\040\037\079\029\014\037\079\029\021\108\037\029\040\037\014\029\040\014\037\121\029\040\112\014\044\044\012\108\014\028\037\118\005\003\033\118\005\003\033\095\029\014\079\014\037\121\029\040\112\014\044\044\012\108\014\037\029\079\112\037\009\014\029\040\037\014\021\108\112\014\044\037\121\029\040\112\014\044\079\021\108\045\018\038\059\037\019\018\037\079\029\014\037\044\014\045\018\112\029\039\037\045\014\029\021\108\112\037\027\029\014\019\014\044\037\018\012\038\047\012\027\014\021\009\014\040\037\079\029\040\019\028\037\006\027\018\044\037\086\014\108\014\040\037\019\014\044\037\096\014\044\047\079\021\108\045\018\086\037\012\040\019\037\019\029\014\037\085\112\014\124\038\044\014\064\012\014\040\047\037\019\014\012\112\045\029\021\108\037\047\012\044\012\014\021\009\059\037\019\029\014\037\024\066\014\044\109\014\044\112\014\124\109\014\044\018\112\012\044\037\079\029\040\009\112\037\108\029\040\086\014\086\014\040\037\040\012\044\037\045\014\029\021\108\112\037\010\037\039\066\040\037\040\066\044\124\018\045\014\044\027\014\029\079\014\037\092\061\059\007\037\087\029\079\037\092\070\059\007\037\107\044\018\019\037\017\037\086\014\108\112\037\079\029\014\037\040\012\044\037\012\124\037\046\037\087\029\079\037\007\037\107\044\018\019\037\017\037\047\012\044\012\014\021\009\028\037\118\005\003\033\118\005\003\033\104\014\087\045\029\021\108\014\044\027\014\029\079\014\037\087\014\086\029\040\040\112\037\079\029\014\037\047\027\029\079\021\108\014\040\037\060\009\112\066\087\014\044\037\012\040\019\037\095\014\047\014\124\087\014\044\037\012\040\019\037\014\040\019\014\112\037\047\027\029\079\021\108\014\040\037\117\018\014\044\047\037\012\040\019\037\117\018\029\059\037\029\040\037\019\014\040\037\079\012\014\019\045\029\021\108\014\040\037\001\014\029\045\014\040\037\029\108\044\014\079\037\020\014\044\087\044\014\029\112\012\040\086\079\086\014\087\029\014\112\014\079\037\108\018\045\112\014\040\037\079\029\014\037\108\029\040\086\014\086\014\040\037\086\018\044\037\009\014\029\040\014\037\066\019\014\044\037\040\012\044\037\014\029\040\014\037\039\014\044\009\012\014\044\047\112\014\037\121\029\040\112\014\044\044\012\108\014\028"), 
		Media = zmediaBrownBearSleeping_MSG
	}
end
function zcharacterSnowyOwl:OnTalk(target)
	if Wherigo.NoCaseEquals(SnowyChat, _O5Os("\119")) then
		SnowyChat = _O5Os("\052")
		_Urwigo.MessageBox{
			Text = _O5Os("\121\014\044\037\087\029\079\112\037\019\012\037\019\014\040\040\010\118\005\003\033\118\005\003\033\005\029\079\112\037\019\012\037\014\029\040\014\044\037\019\014\044\101\014\040\029\086\014\040\037\019\029\014\037\039\014\044\079\012\021\108\014\040\059\037\019\029\014\079\014\037\009\029\040\019\029\079\021\108\014\040\037\113\029\040\086\012\029\040\014\037\027\029\014\019\014\044\037\014\029\040\047\012\038\018\040\086\014\040\010\037\118\005\003\033\118\005\003\033\126\021\108\037\009\018\040\040\037\019\029\044\037\108\014\045\038\014\040\059\037\018\087\014\044\037\047\012\014\044\079\112\037\087\014\018\040\112\027\066\044\112\014\037\124\029\044\037\087\029\112\112\014\037\014\029\040\014\037\076\044\018\086\014\028"), 
			Media = zmediaSnowyOwl_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputNorthernTrail)
					end)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(SnowyChat, _O5Os("\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\126\021\108\037\087\029\040\037\124\029\044\037\079\029\021\108\014\044\059\037\019\012\037\079\021\108\018\038\038\079\112\037\014\079\037\019\029\014\079\014\079\037\117\018\045\028"), 
			Media = zmediaSnowyOwl_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputNorthernTrail)
					end)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(SnowyChat, _O5Os("\102")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\121\066\044\018\012\038\037\027\018\044\112\014\079\112\037\095\012\010\037\078\066\079\059\037\027\014\021\009\037\019\014\040\037\005\044\018\012\040\087\018\014\044\014\040\028"), 
			Media = zmediaSnowyOwl_MSG
		}
	elseif Wherigo.NoCaseEquals(SnowyChat, _O5Os("\092")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\126\079\112\037\019\018\079\037\040\029\021\108\112\037\014\029\040\014\044\037\019\014\044\037\113\029\040\086\012\029\040\014\059\037\040\018\021\108\037\019\014\040\014\040\037\019\012\037\079\012\021\108\079\112\010"), 
			Media = zmediaSnowyOwl_MSG
		}
	elseif Wherigo.NoCaseEquals(SnowyChat, _O5Os("\046")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\120\018\059\037\019\014\029\040\014\037\085\044\087\014\029\112\037\108\029\014\044\037\029\079\112\037\014\044\045\014\019\029\086\112\028"), 
			Media = zmediaSnowyOwl_MSG
		}
	end
end
function zcharacterSnowyOwl:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\029\014\037\024\066\014\044\109\014\044\045\018\014\040\086\014\037\018\012\079\086\014\027\018\021\108\079\014\040\014\044\037\008\021\108\040\014\014\014\012\045\014\040\037\087\014\112\044\018\014\086\112\037\014\112\027\018\037\007\007\037\087\029\079\037\061\061\037\021\124\028\037\095\029\014\037\117\018\014\040\040\021\108\014\040\037\079\029\040\019\037\019\018\087\014\029\037\027\029\014\037\087\014\029\037\039\029\014\045\014\040\037\018\040\019\014\044\014\040\037\122\012\045\014\040\018\044\112\014\040\037\014\112\027\018\079\037\009\045\014\029\040\014\044\037\018\045\079\037\019\029\014\037\121\014\029\087\021\108\014\040\028\037\008\029\014\037\014\044\044\014\029\021\108\014\040\037\029\124\037\095\012\044\021\108\079\021\108\040\029\112\112\037\014\029\040\014\037\078\018\014\040\086\014\037\039\066\040\037\007\070\037\021\124\059\037\121\014\029\087\021\108\014\040\037\027\014\044\019\014\040\037\019\018\086\014\086\014\040\037\019\012\044\021\108\079\021\108\040\029\112\112\045\029\021\108\037\061\092\037\021\124\037\086\044\066\079\079\028\037\118\005\003\033\118\005\003\033\085\014\108\040\045\029\021\108\014\079\037\086\029\045\112\037\038\012\014\044\037\019\018\079\037\024\066\014\044\109\014\044\086\014\027\029\021\108\112\028\037\085\012\079\086\014\027\018\021\108\079\014\040\014\037\008\021\108\040\014\014\100\122\012\045\014\040\037\027\029\014\086\014\040\037\047\027\029\079\021\108\014\040\037\052\059\061\037\012\040\019\037\102\059\007\037\024\029\045\066\086\044\018\124\124\028\037\095\029\014\037\117\018\014\040\040\021\108\014\040\037\027\029\014\086\014\040\037\019\018\087\014\029\037\019\012\044\021\108\079\021\108\040\029\112\112\045\029\021\108\037\052\028\032\119\119\059\037\019\029\014\037\121\014\029\087\021\108\014\040\037\102\028\052\119\119\037\107\044\018\124\124\028\037\095\029\014\037\076\045\012\014\086\014\045\079\109\018\040\040\027\014\029\112\014\037\087\014\112\044\018\014\086\112\037\052\046\007\037\087\029\079\037\052\007\032\037\006\014\040\112\029\124\014\112\014\044\028"), 
		Media = zmediaSnowyOwl_MSG
	}
end
function zcharacterTiger:OnTalk(target)
	if Wherigo.NoCaseEquals(TigerChat, _O5Os("\119")) then
		zcharacterSnowLeopard:MoveTo(zoneAustralasia)
		ztaskReturntheTigersStripes.Visible = true
		ztaskReturntheTigersStripes.Active = true
		ZooChat = _O5Os("\070")
		TigerChat = _O5Os("\052")
		_Urwigo.MessageBox{
			Text = _O5Os("\036\014\029\040\059\037\029\021\108\037\009\066\124\124\014\037\040\029\021\108\112\037\044\018\012\079\028\028\028\028\028\118\005\003\033\126\044\086\014\040\019\027\018\079\037\079\112\029\124\124\112\037\124\029\112\037\124\029\044\037\040\029\021\108\112\059\037\040\014\029\040\059\037\124\014\029\040\014\037\008\112\044\014\029\038\014\040\037\079\029\040\019\037\039\014\044\079\021\108\027\012\040\019\014\040\028\037\122\029\040\037\001\029\086\014\044\037\009\018\040\040\037\019\066\021\108\037\040\029\021\108\112\037\066\108\040\014\037\079\014\029\040\014\037\008\112\044\014\029\038\014\040\037\079\014\029\040\028\118\005\003\033\118\005\003\033\060\108\037\087\029\112\112\014\059\037\108\029\045\038\037\124\029\044\037\124\014\029\040\014\037\008\112\044\014\029\038\014\040\037\027\029\014\019\014\044\037\047\012\037\038\029\040\019\014\040\059\037\039\029\014\045\045\014\029\021\108\112\037\009\018\040\040\037\012\040\079\037\018\012\021\108\037\019\014\044\037\008\021\108\040\014\014\045\014\066\109\018\044\019\037\108\014\045\038\014\040\010"), 
			Media = zmediaSadTiger_MSG
		}
	elseif Wherigo.NoCaseEquals(TigerChat, _O5Os("\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\066\108\059\037\019\018\079\037\029\079\112\037\079\066\037\109\014\029\040\045\029\021\108\037\028\028\028\028"), 
			Media = zmediaSadTiger_MSG
		}
	elseif Wherigo.NoCaseEquals(TigerChat, _O5Os("\102")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\005\029\112\112\014\037\108\029\045\038\037\124\029\044\059\037\019\018\124\029\112\037\029\021\108\037\124\014\029\040\014\037\008\112\044\014\029\038\014\040\037\027\029\014\019\014\044\037\038\014\079\112\124\018\021\108\014\040\037\009\018\040\040\028"), 
			Media = zmediaSadTiger_MSG
		}
	elseif Wherigo.NoCaseEquals(TigerChat, _O5Os("\092")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\107\012\112\059\037\019\018\079\037\027\018\044\037\079\021\108\040\014\045\045\028\028\028"), 
			Media = zmediaStripeyTiger_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputKookaburra)
					end)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(TigerChat, _O5Os("\046")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\020\029\014\045\014\040\037\095\018\040\009\037\038\012\014\044\037\019\014\029\040\014\037\096\029\045\038\014\059\037\029\021\108\037\038\012\014\108\045\014\037\124\029\021\108\037\027\029\014\037\040\014\012\037\086\014\087\066\044\014\040\028"), 
			Media = zmediaStripeyTiger_MSG
		}
	end
end
function zcharacterTiger:OnExamine(target)
	if zcharacterTiger:Contains(zitemHoney) then
		_Urwigo.MessageBox{
			Text = _O5Os("\095\014\044\037\001\029\086\014\044\037\013\113\018\040\112\108\014\044\018\037\112\029\086\044\029\079\055\037\029\079\112\037\014\029\040\014\037\029\040\037\085\079\029\014\040\037\039\014\044\087\044\014\029\112\014\112\014\037\107\044\066\079\079\009\018\112\047\014\028\037\118\005\003\033\118\005\003\033\085\012\038\086\044\012\040\019\037\019\014\044\037\021\108\018\044\018\009\112\014\044\029\079\112\029\079\021\108\014\040\037\079\021\108\027\018\044\047\014\040\037\008\112\044\014\029\038\012\040\086\037\018\012\038\037\086\066\045\019\086\014\045\087\014\124\037\087\029\079\037\044\066\112\087\044\018\012\040\014\124\037\107\044\012\040\019\037\029\079\112\037\014\044\037\012\040\039\014\044\027\014\021\108\079\014\045\087\018\044\028\037\095\014\044\037\001\029\086\014\044\037\029\079\112\037\019\029\014\037\086\044\066\014\079\079\112\014\037\018\045\045\014\044\037\045\014\087\014\040\019\014\040\037\003\018\012\087\009\018\112\047\014\040\018\044\112\014\040\028"), 
			Media = zmediaStripeyTiger_MSG
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\095\029\014\079\014\044\037\001\029\086\014\044\037\029\079\112\037\079\014\108\044\037\012\040\086\045\012\014\021\009\045\029\021\108\059\037\019\018\037\014\044\037\079\014\029\040\014\037\008\112\044\014\029\038\014\040\037\039\014\044\045\066\044\014\040\037\108\018\112\028\037\096\029\045\038\037\029\108\124\037\079\029\014\037\047\012\037\038\029\040\019\014\040\028"), 
			Media = zmediaSadTiger_MSG
		}
	end
end
function zcharacterSnowLeopard:OnTalk(target)
	if Wherigo.NoCaseEquals(SnowLeopardChat, _O5Os("\119")) then
		zitemTigerStripes:MoveTo(zoneAustralasia)
		SnowLeopardChat = _O5Os("\052")
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\059\037\029\021\108\037\087\029\040\037\108\014\012\112\014\037\124\066\044\086\014\040\037\018\012\038\086\014\027\018\021\108\112\037\012\040\019\037\040\014\087\014\040\037\124\029\044\037\079\112\018\040\019\037\014\029\040\037\113\029\040\086\012\029\040\028\037\104\040\019\037\086\014\044\018\019\014\037\018\045\079\037\029\021\108\037\029\108\040\037\038\044\018\086\014\037\027\066\045\045\112\014\059\037\027\018\079\037\014\044\037\108\029\014\044\037\124\018\021\108\112\059\037\108\018\112\037\014\044\037\018\012\021\108\037\079\021\108\066\040\037\019\029\014\037\008\112\044\014\029\038\014\040\037\039\066\124\037\001\029\086\014\044\037\108\029\014\044\037\012\014\087\014\044\018\045\045\037\039\014\044\112\014\029\045\112\028\118\005\003\033\118\005\003\033\024\018\040\040\079\112\037\095\012\037\108\029\014\044\037\087\029\112\112\014\037\018\012\038\044\018\014\012\124\014\040\037\012\040\019\037\019\029\014\037\008\112\044\014\029\038\014\040\037\124\029\112\040\014\108\124\014\040\010"), 
			Media = zmediaSnowLeopard_MSG
		}
	elseif Wherigo.NoCaseEquals(SnowLeopardChat, _O5Os("\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\036\029\124\124\079\112\037\095\012\037\019\029\014\037\008\112\044\014\029\038\014\040\037\066\019\014\044\037\027\018\079\010"), 
			Media = zmediaSnowLeopard_MSG
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\096\066\038\038\014\040\112\045\029\021\108\037\086\014\108\112\037\014\079\037\086\045\014\029\021\108\037\019\014\124\037\001\029\086\014\044\037\027\029\014\019\014\044\037\087\014\079\079\014\044\099"), 
			Media = zmediaSnowLeopard_MSG
		}
	end
end
function zcharacterSnowLeopard:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\014\044\037\008\021\108\040\014\014\045\014\066\109\018\044\019\037\066\019\014\044\037\126\044\087\029\079\037\013\104\040\021\029\018\037\012\040\021\029\018\055\037\029\079\112\037\014\029\040\014\037\107\044\066\079\079\009\018\112\047\014\037\013\113\018\040\112\108\014\044\029\040\018\014\055\037\019\014\044\037\047\014\040\112\044\018\045\018\079\029\018\112\029\079\021\108\014\040\037\096\066\021\108\086\014\087\029\044\086\014\028\037\122\044\037\079\029\014\108\112\037\014\029\040\014\124\037\078\014\066\109\018\044\019\014\040\037\018\014\108\040\045\029\021\108\059\037\108\018\112\037\018\087\014\044\037\014\029\040\037\045\018\014\040\086\014\044\014\079\059\037\124\014\029\079\112\037\086\044\018\012\014\079\037\076\014\045\045\028\037\008\021\108\040\014\014\045\014\066\109\018\044\019\014\040\037\045\014\087\014\040\037\018\045\079\037\122\029\040\047\014\045\086\018\014\040\086\014\044\028\037\118\005\003\033\118\005\003\033\095\014\044\037\008\021\108\040\014\014\045\014\066\109\018\044\019\037\027\029\044\009\112\037\029\040\037\079\014\029\040\014\124\037\019\029\021\009\014\040\037\076\014\045\045\037\079\014\108\044\037\124\018\079\079\029\086\059\037\029\079\112\037\101\014\019\066\021\108\037\009\045\014\029\040\014\044\037\012\040\019\037\045\014\029\021\108\112\014\044\037\018\045\079\037\014\029\040\037\019\012\044\021\108\079\021\108\040\029\112\112\045\029\021\108\014\044\037\078\014\066\109\018\044\019\028\037\095\029\014\037\024\066\109\038\100\003\012\124\109\038\100\078\018\014\040\086\014\037\087\014\112\044\018\014\086\112\037\052\119\119\010\052\007\119\037\021\124\059\037\108\029\040\047\012\037\009\066\124\124\014\040\037\070\119\010\052\119\119\037\021\124\037\008\021\108\027\018\040\047\028\037\095\029\014\037\008\021\108\012\045\112\014\044\108\066\014\108\014\037\087\014\112\044\018\014\086\112\037\012\124\037\019\029\014\037\061\119\037\021\124\037\012\040\019\037\019\018\079\037\107\014\027\029\021\108\112\037\039\018\044\029\029\014\044\112\037\047\027\029\079\021\108\014\040\037\102\007\037\012\040\019\037\032\007\037\009\086\028"), 
		Media = zmediaSnowLeopard_MSG
	}
end
function zcharacterSunBear:OnTalk(target)
	if Wherigo.NoCaseEquals(ZooChat, _O5Os("\052\119")) then
		zitemHoney:MoveTo(Player)
		zitemHoney.Commands.Give.Enabled = true
		ZooChat = _O5Os("\052\052")
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\096\124\124\124\124\059\037\045\014\021\009\014\044\028\037\095\029\014\079\014\044\037\096\066\040\029\086\037\108\029\014\044\028\037\118\005\003\033\118\005\003\033\122\044\037\079\021\108\124\014\021\009\112\037\045\014\021\009\014\044\037\012\040\019\037\124\018\040\037\009\018\040\040\037\124\029\112\037\019\014\044\037\009\045\014\087\044\029\086\014\040\037\117\018\079\079\014\037\086\018\040\047\037\112\066\045\045\037\095\029\040\086\014\037\047\012\079\018\124\124\014\040\087\044\029\040\086\014\040\028\118\005\003\033\118\005\003\033\096\029\014\044\059\037\040\029\124\124\037\019\018\039\066\040\099"), 
				Media = zmediaSunBear_MSG
			}, 
			{
				Text = _O5Os("\036\014\012\014\044\037\126\040\039\014\040\112\018\044\086\014\086\014\040\079\112\018\040\019\035\118\005\003\033\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\096\066\040\029\086"), 
				Media = zmediaHoney_MSG
			}
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\096\124\124\124\059\037\019\014\044\037\096\066\040\029\086\037\029\079\112\037\079\066\066\066\066\037\086\012\112\099"), 
			Media = zmediaSunBear_MSG
		}
	end
end
function zcharacterSunBear:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\014\044\037\117\018\045\018\029\014\040\087\018\014\044\037\013\124\014\029\079\112\037\096\014\045\018\044\021\112\066\079\037\124\018\045\018\030\018\040\012\079\059\037\124\018\040\021\108\124\018\045\037\104\044\079\012\079\037\124\018\045\018\030\018\040\012\079\055\059\037\018\012\021\108\037\018\045\079\037\008\066\040\040\014\040\087\018\014\044\037\087\014\047\014\029\021\108\040\014\112\059\037\029\079\112\037\014\029\040\014\037\003\018\012\087\112\029\014\044\018\044\112\037\018\012\079\037\019\014\044\037\076\018\124\029\045\029\014\037\019\014\044\037\005\018\014\044\014\040\037\013\104\044\079\029\019\018\014\055\028\037\122\044\037\045\014\087\112\037\029\040\037\008\012\014\019\066\079\112\018\079\029\014\040\037\012\040\019\037\029\079\112\037\019\014\044\037\009\045\014\029\040\079\112\014\037\012\040\019\037\018\124\037\087\014\079\112\014\040\037\018\040\037\014\029\040\014\037\087\018\012\124\087\014\027\066\108\040\014\040\019\014\037\078\014\087\014\040\079\027\014\029\079\014\037\018\040\086\014\109\018\079\079\112\014\037\020\014\044\112\044\014\112\014\044\037\079\014\029\040\014\044\037\076\018\124\029\045\029\014\028\118\005\003\033\118\005\003\033\117\018\045\018\029\014\040\087\018\014\044\014\040\037\079\029\040\019\037\040\018\021\108\112\018\009\112\029\039\059\037\112\018\086\079\012\014\087\014\044\037\079\021\108\045\018\038\014\040\037\079\029\014\037\029\040\037\019\014\040\037\005\018\014\012\124\014\040\059\037\044\012\040\019\037\102\037\087\029\079\037\032\037\117\014\112\014\044\037\012\014\087\014\044\037\019\014\124\037\122\044\019\087\066\019\014\040\028\037\008\029\014\037\087\044\014\021\108\014\040\037\066\019\014\044\037\039\014\044\087\029\014\086\014\040\037\085\014\079\112\014\059\037\012\124\037\019\018\044\018\012\079\037\014\029\040\037\036\014\079\112\037\066\019\014\044\037\014\029\040\014\037\085\012\079\079\029\021\108\112\079\109\045\018\112\112\038\066\044\124\037\047\012\037\014\044\044\029\021\108\112\014\040\059\037\124\018\040\021\108\124\018\045\037\009\018\040\040\037\124\018\040\037\079\029\014\037\018\012\021\108\037\087\014\029\124\037\008\066\040\040\014\040\087\018\019\014\040\037\087\014\066\087\018\021\108\112\014\040\028\037\085\124\037\005\066\019\014\040\037\087\014\027\014\086\014\040\037\079\029\014\037\079\029\021\108\037\027\029\014\037\018\045\045\014\037\005\018\014\044\014\040\037\018\045\079\037\008\066\108\045\014\040\086\018\014\040\086\014\044\037\038\066\044\112\059\037\027\066\087\014\029\037\079\029\014\037\019\029\014\037\076\012\014\079\079\014\037\040\018\021\108\037\029\040\040\014\040\037\019\044\014\108\014\040\028"), 
		Media = zmediaSunBear_MSG
	}
end
function zcharacterHippopotamus:OnTalk(target)
	if Wherigo.NoCaseEquals(HippoChat, _O5Os("\119")) then
		ztaskFindtheHipposDrainPlug.Visible = true
		ztaskFindtheHipposDrainPlug.Active = true
		HippoChat = _O5Os("\052")
		ZooChat = _O5Os("\102\092")
		zoneAfricanVillage.Visible = true
		zoneAfricanVillage.Active = true
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\117\018\040\040\059\037\029\079\112\037\019\018\079\037\108\014\029\079\079\037\108\014\012\112\014\028\037\126\021\108\037\027\012\014\044\019\014\037\101\018\037\086\014\044\040\014\037\014\029\040\014\037\009\045\014\029\040\014\037\113\066\066\045\109\018\044\112\030\037\039\014\044\018\040\079\112\018\045\112\014\040\059\037\018\087\014\044\037\045\014\029\019\014\044\037\108\018\112\037\101\014\124\018\040\019\037\019\014\040\037\008\112\066\014\109\079\014\045\037\018\012\079\037\124\014\029\040\014\044\037\121\018\040\040\014\037\086\014\009\045\018\012\112\028\118\005\003\033\118\005\003\033\104\040\019\037\040\012\040\037\029\079\112\037\019\018\079\037\086\018\040\047\014\037\121\018\079\079\014\044\037\018\012\079\086\014\045\018\012\038\014\040\028"), 
				Media = zmediaHippo_MSG
			}, 
			{
				Text = _O5Os("\029\021\108\037\039\014\044\044\018\112\014\037\019\029\044\037\027\018\079\037\012\014\087\014\044\037\019\029\014\037\113\029\040\086\012\029\040\014\059\037\027\014\040\040\037\019\012\037\124\029\044\037\039\014\044\079\109\044\029\021\108\079\112\059\037\124\029\044\037\087\014\029\124\037\008\012\021\108\014\040\037\040\018\021\108\037\019\014\124\037\008\112\066\014\109\079\014\045\037\047\012\037\108\014\045\038\014\040\028"), 
				Media = zmediaHippo_MSG
			}, 
			{
				Text = _O5Os("\008\021\108\018\012\037\029\124\037\085\038\044\029\009\018\108\018\012\079\059\037\019\018\037\108\018\087\014\037\029\021\108\037\108\014\012\112\014\037\124\066\044\086\014\040\037\014\029\040\014\040\037\019\014\044\037\113\029\040\086\012\029\040\014\037\086\014\079\014\108\014\040\028\118\005\003\033\118\005\003\033\020\029\014\045\037\107\045\012\014\021\009\059\037\029\021\108\037\027\014\044\019\014\037\124\029\112\037\019\014\124\037\024\012\021\108\014\040\037\108\029\014\044\037\079\014\029\040\028"), 
				Media = zmediaHippo_MSG
			}
		}
	elseif Wherigo.NoCaseEquals(HippoChat, _O5Os("\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\018\079\112\037\095\012\037\124\014\029\040\014\040\037\121\018\040\040\014\040\079\112\066\014\109\079\014\045\037\086\014\038\012\040\019\014\040\010"), 
			Media = zmediaHippo_MSG
		}
	elseif Wherigo.NoCaseEquals(HippoChat, _O5Os("\102")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\020\029\014\045\014\040\037\095\018\040\009\059\037\019\018\079\079\037\019\012\037\019\014\040\037\008\112\066\014\109\079\014\045\037\124\014\029\040\014\044\037\121\018\040\040\014\037\027\029\014\019\014\044\086\014\038\012\040\019\014\040\037\108\018\079\112\028"), 
			Media = zmediaHippo_MSG
		}
	end
end
function zcharacterHippopotamus:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\018\079\037\076\045\012\079\079\109\038\014\044\019\037\013\096\029\109\109\066\109\066\112\018\124\012\079\037\018\124\109\108\029\087\029\012\079\055\059\037\018\012\021\108\037\036\029\045\109\038\014\044\019\037\066\019\014\044\037\107\044\066\079\079\038\045\012\079\079\109\038\014\044\019\037\086\014\040\018\040\040\112\059\037\029\079\112\037\014\029\040\037\086\044\066\079\079\014\079\059\037\109\038\045\018\040\047\014\040\038\044\014\079\079\014\040\019\014\079\037\008\018\014\012\086\014\112\029\014\044\028\037\122\079\037\045\014\087\112\037\029\040\037\107\014\027\018\014\079\079\014\044\040\018\014\108\014\037\029\124\037\124\029\112\112\045\014\044\014\040\037\012\040\019\037\079\012\014\019\045\029\021\108\014\040\037\085\038\044\029\009\018\037\012\040\019\037\047\018\014\108\045\112\037\040\018\021\108\037\019\014\040\037\122\045\014\038\018\040\112\014\040\037\047\012\037\019\014\040\037\079\021\108\027\014\044\079\112\014\040\037\045\018\040\019\087\014\027\066\108\040\014\040\019\014\040\037\008\018\014\012\086\014\112\029\014\044\014\040\028\037\118\005\003\033\118\005\003\033\008\029\014\037\014\044\044\014\029\021\108\014\040\037\014\029\040\014\037\024\066\109\038\100\003\012\124\109\038\100\078\018\014\040\086\014\037\039\066\040\037\102\059\025\037\087\029\079\037\007\059\052\037\117\014\112\014\044\040\059\037\027\066\047\012\037\040\066\021\108\037\014\029\040\037\046\119\037\087\029\079\037\007\061\037\006\014\040\112\029\124\014\112\014\044\037\045\018\040\086\014\044\037\008\021\108\027\018\040\047\037\009\066\124\124\112\028\037\118\005\003\033\118\005\003\033\076\045\012\079\079\109\038\014\044\019\014\037\009\066\014\040\040\014\040\037\029\108\044\014\037\024\029\014\038\014\044\037\087\029\079\037\047\012\037\052\007\119\037\107\044\018\019\037\018\012\038\009\045\018\109\109\014\040\028"), 
		Media = zmediaHippo_MSG
	}
end
function zcharacterZebra:OnTalk(target)
	if Wherigo.NoCaseEquals(ZebraChat, _O5Os("\119")) then
		zitemDrainPlug:MoveTo(Player)
		zitemDrainPlug.Commands.Give.Enabled = true
		ZooChat = _O5Os("\102\007")
		ZebraChat = _O5Os("\052")
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\126\021\108\037\108\018\087\014\037\086\014\108\066\014\044\112\059\037\014\029\040\014\044\037\019\014\044\037\027\029\045\019\014\040\037\113\029\040\086\012\029\040\014\037\108\018\112\037\019\014\040\037\121\018\040\040\014\040\079\112\066\014\109\079\014\045\037\019\014\079\037\036\029\045\109\038\014\044\019\014\079\037\086\014\009\045\018\012\112\028\118\005\003\033\118\005\003\033\107\014\079\021\108\029\014\108\112\037\029\108\124\037\044\014\021\108\112\059\037\014\044\037\108\018\112\037\019\029\014\037\113\029\040\086\012\029\040\014\037\019\066\021\108\037\018\012\021\108\037\040\029\014\037\047\012\044\037\113\066\066\045\109\018\044\112\030\037\014\029\040\086\014\045\018\019\014\040\028\028\028\028\028\118\005\003\033\118\005\003\033\104\040\019\037\124\029\021\108\037\018\012\021\108\037\040\029\021\108\112\028"), 
				Media = zmediaZebra_MSG
			}, 
			{
				Text = _O5Os("\095\014\044\037\014\029\040\014\037\113\029\040\086\012\029\040\037\108\018\112\112\014\037\079\029\021\108\037\108\014\012\112\014\037\124\066\044\086\014\040\037\087\014\029\037\124\029\044\037\039\014\044\079\112\014\021\009\112\059\037\018\087\014\044\037\029\040\047\027\029\079\021\108\014\040\037\108\018\112\037\014\044\037\096\012\040\086\014\044\037\087\014\009\066\124\124\014\040\037\012\040\019\037\029\079\112\037\027\014\086\086\014\044\018\040\040\112\037\100\037\079\066\037\079\021\108\040\014\045\045\059\037\019\018\079\079\037\014\044\037\019\014\040\037\008\112\066\014\109\079\014\045\037\108\029\014\044\037\039\014\044\086\014\079\079\014\040\037\108\018\112\028\118\005\003\033\118\005\003\033\126\021\108\037\086\014\087\037\029\108\040\037\019\029\044\059\037\027\014\040\040\037\019\012\037\019\018\079\037\036\029\045\109\038\014\044\019\037\012\014\087\014\044\044\014\019\014\079\112\059\037\012\040\079\037\047\012\044\037\040\018\014\021\108\079\112\014\040\037\113\066\066\045\109\018\044\112\030\037\014\029\040\047\012\045\018\019\014\040\028"), 
				Media = zmediaZebra_MSG
			}, 
			{
				Text = _O5Os("\036\014\012\014\044\037\126\040\039\014\040\112\018\044\086\014\086\014\040\079\112\018\040\019\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\121\018\040\040\014\040\079\112\066\014\109\079\014\045"), 
				Media = zmediaDrainPlug_MSG
			}
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\117\014\029\040\079\112\037\095\012\059\037\019\018\079\037\036\029\045\109\038\014\044\019\037\045\018\014\019\112\037\124\029\021\108\037\047\012\037\040\018\014\021\108\079\112\014\040\037\113\066\066\045\109\018\044\112\030\037\014\029\040\010"), 
			Media = zmediaZebra_MSG
		}
	end
end
function zcharacterZebra:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\006\014\087\044\018\079\037\014\044\044\014\029\021\108\014\040\037\014\029\040\014\037\024\066\109\038\044\012\124\109\038\045\018\014\040\086\014\037\039\066\040\037\102\052\119\037\087\029\079\037\092\119\119\037\006\014\040\112\029\124\014\112\014\044\040\059\037\019\014\044\037\008\021\108\027\018\040\047\037\027\029\044\019\037\046\119\037\087\029\079\037\061\119\037\006\014\040\112\029\124\014\112\014\044\037\045\018\040\086\037\012\040\019\037\019\029\014\037\008\021\108\012\045\112\014\044\108\066\014\108\014\037\087\014\112\044\018\014\086\112\037\052\052\119\037\087\029\079\037\052\061\119\037\006\014\040\112\029\124\014\112\014\044\028\037\095\018\079\037\107\014\027\029\021\108\112\037\039\018\044\029\029\014\044\112\037\047\027\029\079\021\108\014\040\037\052\070\119\037\012\040\019\037\046\007\119\037\024\029\045\066\086\044\018\124\124\028\118\005\003\033\118\005\003\033\076\012\014\044\037\019\029\014\037\122\040\112\027\029\021\009\045\012\040\086\037\019\014\044\037\008\112\044\014\029\038\014\040\037\086\029\087\112\037\014\079\037\124\014\108\044\014\044\014\037\122\044\009\045\018\014\044\012\040\086\079\039\014\044\079\012\021\108\014\028\037\006\012\124\037\014\029\040\014\040\037\027\029\044\019\037\039\014\044\124\012\112\014\112\059\037\079\029\014\037\009\066\014\040\040\014\040\037\029\124\037\108\066\108\014\040\037\107\044\018\079\037\066\019\014\044\037\087\014\029\037\108\014\029\079\079\014\044\059\037\038\045\029\124\124\014\044\040\019\014\044\037\078\012\038\112\037\018\045\079\037\001\018\044\040\012\040\086\037\027\029\044\009\014\040\028\037\122\079\037\029\079\112\037\018\012\021\108\037\019\014\040\009\087\018\044\059\037\019\018\079\079\037\019\012\044\021\108\037\019\029\014\037\008\112\044\014\029\038\014\040\047\014\029\021\108\040\012\040\086\037\019\029\014\037\104\124\044\029\079\079\014\037\019\014\044\037\014\029\040\047\014\045\040\014\040\037\001\029\014\044\014\037\040\029\021\108\112\037\124\014\108\044\037\014\044\009\014\040\040\087\018\044\037\079\029\040\019\028\037\095\018\037\006\014\087\044\018\079\037\029\040\037\096\014\044\019\014\040\037\045\014\087\014\040\059\037\009\066\014\040\040\112\014\037\014\079\037\019\018\019\012\044\021\108\037\038\012\014\044\037\003\018\014\012\087\014\044\037\014\044\079\021\108\027\014\044\112\037\027\014\044\019\014\040\059\037\079\029\021\108\037\014\029\040\037\014\029\040\047\014\045\040\014\079\037\005\014\012\112\014\112\029\014\044\037\108\014\044\018\012\079\047\012\079\012\021\108\014\040\028"), 
		Media = zmediaZebra_MSG
	}
end
function zcharacterPython:OnTalk(target)
	if Wherigo.NoCaseEquals(PythonChat, _O5Os("\119")) then
		zitemSiamangsVoice:MoveTo(zoneTropicalAsia)
		ZooChat = _O5Os("\052\032")
		PythonChat = _O5Os("\052")
		_Urwigo.MessageBox{
			Text = _O5Os("\018\014\108\108\037\018\014\108\108\037\100\118\005\003\033\118\005\003\033\120\014\019\014\079\124\018\045\059\037\027\014\040\040\037\029\021\108\037\039\014\044\079\012\021\108\014\037\047\012\037\044\014\019\014\040\059\037\009\066\124\124\112\037\019\029\014\079\014\044\037\079\021\108\044\014\021\009\045\029\021\108\014\037\024\044\018\021\108\037\018\012\079\037\124\014\029\040\014\124\037\003\018\021\108\014\040\037\108\014\044\018\012\079\028\118\005\003\033\104\040\019\037\029\021\108\037\009\018\040\040\037\019\014\079\027\014\086\014\040\037\018\012\021\108\037\040\029\021\108\112\037\014\029\040\079\021\108\045\018\038\014\040\028\037\118\005\003\033\118\005\003\033\096\029\045\038\037\124\029\044\037\019\066\021\108\037\087\029\112\112\014\099"), 
			Media = zmediaPython_MSG
		}
	elseif Wherigo.NoCaseEquals(PythonChat, _O5Os("\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\029\045\038\079\112\037\019\012\037\124\029\044\037\040\012\040\037\066\019\014\044\037\040\029\021\108\112\010\118\005\003\033\118\005\003\033\110\036\029\124\124\110\037\019\018\079\037\079\021\108\044\014\021\009\045\029\021\108\014\037\001\014\029\045\037\039\066\040\037\124\029\044\037\027\014\086\028"), 
			Media = zmediaPython_MSG
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\020\029\014\045\014\040\037\095\018\040\009\037\038\012\014\044\037\019\014\029\040\014\037\096\029\045\038\014\028\037\095\029\014\079\014\044\037\009\044\018\021\108\037\108\018\112\037\124\029\021\108\037\101\018\037\027\018\108\040\079\029\040\040\029\086\037\086\014\124\018\021\108\112\099"), 
			Media = zmediaPython_MSG
		}
	end
end
function zcharacterPython:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\029\014\037\009\045\014\029\040\079\112\014\037\085\044\112\037\019\014\044\037\107\018\112\112\012\040\086\037\008\012\014\019\109\030\112\108\066\040\079\037\013\085\040\112\018\044\014\079\029\018\037\109\014\044\112\108\014\040\079\029\079\055\037\027\029\044\019\037\040\012\044\037\014\112\027\018\037\032\119\010\025\119\037\006\014\040\112\029\124\014\112\014\044\037\045\018\040\086\028\037\122\029\040\029\086\014\037\085\044\112\014\040\037\019\014\044\037\107\018\112\112\012\040\086\037\122\029\086\014\040\112\045\029\021\108\014\040\037\113\030\112\108\066\040\079\037\013\113\030\112\108\066\040\055\037\047\018\014\108\045\014\040\037\047\012\037\019\014\040\037\086\044\066\014\079\079\112\014\040\037\008\021\108\045\018\040\086\014\040\037\019\014\044\037\121\014\045\112\037\124\029\112\037\014\029\040\014\044\037\124\018\026\029\124\018\045\014\040\037\078\018\014\040\086\014\037\039\066\040\037\087\029\079\037\047\012\037\038\018\079\112\037\047\014\108\040\037\117\014\112\014\044\040\028\118\005\003\033\118\005\003\033\113\030\112\108\066\040\027\014\029\087\021\108\014\040\037\045\014\086\014\040\037\101\014\037\040\018\021\108\037\085\044\112\037\047\027\014\029\037\087\029\079\037\012\014\087\014\044\037\052\119\119\037\122\029\014\044\037\018\087\028\037"), 
		Media = zmediaPython_MSG
	}
end
function zcharacterSiamang:OnTalk(target)
	if Wherigo.NoCaseEquals(SiamangChat, _O5Os("\119")) then
		ztaskRetrievetheSiamangsVoice.Visible = true
		ztaskRetrievetheSiamangsVoice.Active = true
		zcharacterPython:MoveTo(zoneTropicalAsia)
		ZooChat = _O5Os("\052\061")
		SiamangChat = _O5Os("\052")
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\095\014\044\037\008\021\108\029\124\109\018\040\079\014\037\066\014\038\038\040\014\112\037\019\014\040\037\117\012\040\019\037\047\012\124\037\003\014\019\014\040\059\037\018\087\014\044\037\014\079\037\009\066\124\124\014\040\037\009\014\029\040\014\037\001\066\014\040\014\037\108\014\044\018\012\079\028"), 
				Media = zmediaSiamang_MSG
			}, 
			{
				Text = _O5Os("\060\108\037\040\014\029\040\059\037\019\014\044\037\008\021\108\029\124\109\018\040\079\014\037\108\018\112\037\079\014\029\040\014\037\008\112\029\124\124\014\037\039\014\044\045\066\044\014\040\028\037\121\018\044\112\014\059\037\108\066\014\044\079\112\037\095\012\037\019\018\079\010\037\122\079\037\009\066\124\124\112\037\018\012\079\037\019\014\124\037\008\021\108\045\018\040\086\014\040\086\014\108\014\086\014\028\118\005\003\033\118\005\003\033\078\018\079\079\037\012\040\079\037\124\029\112\037\019\014\044\037\113\030\112\108\066\040\037\044\014\019\014\040\037\012\040\019\037\108\014\044\018\012\079\038\029\040\019\014\040\059\037\027\018\079\037\108\029\014\044\037\045\066\079\037\029\079\112\028"), 
				Media = zmediaZookeeper_MSG
			}
		}
	elseif Wherigo.NoCaseEquals(SiamangChat, _O5Os("\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\095\014\044\037\008\021\108\029\124\109\018\040\079\014\037\066\014\038\038\040\014\112\037\019\014\040\037\117\012\040\019\037\047\012\124\037\003\014\019\014\040\059\037\018\087\014\044\037\014\079\037\009\066\124\124\112\037\040\029\021\108\112\079\037\108\014\044\018\012\079\028"), 
			Media = zmediaSiamang_MSG
		}
	elseif Wherigo.NoCaseEquals(SiamangChat, _O5Os("\102")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\059\037\019\012\037\108\018\079\112\037\019\018\079\037\018\087\014\044\037\079\021\108\040\014\045\045\037\108\014\044\018\012\079\037\086\014\038\012\040\019\014\040\028\028\028\028"), 
			Media = zmediaSiamangWithVoice_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputTropicalAsia)
					end)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(SiamangChat, _O5Os("\092")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\020\029\014\045\014\040\037\095\018\040\009\059\037\019\018\079\079\037\019\012\037\124\029\044\037\124\014\029\040\014\037\008\112\029\124\124\014\044\037\027\029\014\019\014\044\086\014\087\044\018\021\108\112\037\108\018\079\112\028\037\020\029\014\045\037\107\045\012\014\021\009\037\087\014\029\037\019\014\029\040\014\044\037\008\012\021\108\014\037\040\018\021\108\037\019\014\040\037\113\029\040\086\012\029\040\014\040\028"), 
			Media = zmediaSiamangWithVoice_MSG
		}
	end
end
function zcharacterSiamang:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\107\014\124\014\029\040\014\037\008\021\108\029\124\109\018\040\079\014\040\037\014\044\044\014\029\021\108\014\040\037\014\029\040\014\037\024\066\109\038\044\012\124\109\038\045\018\014\040\086\014\037\039\066\040\037\061\046\037\087\029\079\037\025\046\037\006\014\040\112\029\124\014\112\014\044\040\059\037\027\029\014\037\018\045\045\014\037\117\014\040\079\021\108\014\040\018\038\038\014\040\037\079\029\040\019\037\079\029\014\037\079\021\108\027\018\040\047\045\066\079\028\037\008\112\014\108\014\040\019\037\027\014\044\019\014\040\037\079\029\014\037\047\027\029\079\021\108\014\040\037\052\037\012\040\019\037\052\059\032\037\117\014\112\014\044\040\037\108\066\021\108\028\037\118\005\003\033\118\005\003\033\107\014\124\014\029\040\014\037\008\021\108\029\124\109\018\040\079\014\040\037\009\066\124\124\012\040\029\047\029\014\044\014\040\037\012\040\112\014\044\014\029\040\018\040\019\014\044\037\124\029\112\037\014\029\040\014\044\037\003\014\029\108\014\037\039\066\040\037\078\018\012\112\014\040\037\012\040\019\037\024\066\014\044\109\014\044\108\018\045\112\012\040\086\014\040\028\037\095\014\044\037\108\018\014\012\038\029\086\079\112\014\037\078\018\012\112\037\029\079\112\037\019\014\044\037\010\113\018\040\112\100\108\066\066\112\010\037\086\014\040\018\040\040\112\014\037\003\012\038\059\037\019\014\044\037\019\014\044\037\024\066\040\112\018\009\112\018\012\038\040\018\108\124\014\037\124\029\112\037\014\040\112\038\014\044\040\112\014\040\037\107\044\012\109\109\014\040\124\029\112\086\045\029\014\019\014\044\040\037\019\029\014\040\112\028\037\118\005\003\033\118\005\003\033\107\014\124\014\029\040\014\037\008\021\108\029\124\109\018\040\079\014\040\037\079\029\040\019\037\085\045\045\014\079\038\044\014\079\079\014\044\059\037\019\014\040\037\008\021\108\027\014\044\109\012\040\009\112\037\029\108\044\014\044\037\036\018\108\044\012\040\086\037\124\018\021\108\014\040\037\018\045\045\014\044\019\029\040\086\079\037\113\038\045\018\040\047\014\040\037\018\012\079\028\037"), 
		Media = zmediaSiamang_MSG
	}
end
function zcharacterSadPig:OnTalk(target)
	if Wherigo.NoCaseEquals(PigChat, _O5Os("\119")) then
		PigChat = _O5Os("\052")
		ZooChat = _O5Os("\102\025")
		ztaskCurlthePigsTail.Visible = true
		ztaskCurlthePigsTail.Active = true
		zcharacterChicken:MoveTo(zoneTemperateForest)
		_Urwigo.MessageBox{
			Text = _O5Os("\126\021\108\037\087\029\040\037\079\066\066\066\066\037\012\040\086\045\012\014\021\009\045\029\021\108\028\037\096\014\012\112\014\037\124\066\044\086\014\040\037\087\029\040\037\029\021\108\037\018\012\038\086\014\027\018\021\108\112\037\012\040\019\037\124\014\029\040\037\108\012\014\087\079\021\108\014\044\037\009\045\014\029\040\014\044\037\003\029\040\086\014\045\079\021\108\027\018\040\047\037\027\018\044\037\086\018\040\047\037\086\014\044\018\019\014\037\012\040\019\037\040\029\021\108\112\037\124\014\108\044\037\086\014\044\029\040\086\014\045\112\028\118\005\003\033\118\005\003\033\060\108\059\037\019\018\079\037\029\079\112\037\079\066\037\079\021\108\045\029\124\124\059\037\009\018\040\040\079\112\037\019\012\037\124\029\044\037\040\029\021\108\112\037\108\014\045\038\014\040\059\037\019\018\079\079\037\124\014\029\040\037\008\021\108\027\018\014\040\047\021\108\014\040\037\027\029\014\019\014\044\037\040\066\044\124\018\045\037\027\029\044\019\028"), 
			Media = zmediaSadPig_MSG
		}
	elseif Wherigo.NoCaseEquals(PigChat, _O5Os("\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\117\014\029\040\037\018\044\124\014\044\059\037\018\044\124\014\044\037\003\029\040\086\014\045\079\021\108\027\018\040\047\099"), 
			Media = zmediaSadPig_MSG
		}
	elseif Wherigo.NoCaseEquals(PigChat, _O5Os("\102")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\029\045\038\037\124\029\044\059\037\108\014\044\018\012\079\047\012\038\029\040\019\014\040\059\037\027\029\014\037\018\045\112\037\024\066\044\079\018\009\079\037\027\014\044\019\014\040\037\009\066\014\040\040\014\040\028"), 
			Media = zmediaHappyPig_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputTemperateForest)
					end)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(PigChat, _O5Os("\092")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\020\029\014\045\014\040\037\095\018\040\009\037\038\012\014\044\037\019\014\029\040\014\037\096\029\045\038\014\059\037\029\021\108\037\108\066\038\038\014\059\037\019\012\037\038\029\040\019\014\079\112\037\018\045\045\014\037\113\029\040\086\012\029\040\014\099"), 
			Media = zmediaHappyPig_MSG
		}
	end
end
function zcharacterSadPig:OnExamine(target)
	if zcharacterSadPig:Contains(zitemLemon) then
		_Urwigo.MessageBox{
			Text = _O5Os("\095\018\079\037\096\018\012\079\079\021\108\027\014\029\040\037\029\079\112\037\014\029\040\014\079\037\019\014\044\037\018\124\037\045\018\014\040\086\079\112\014\040\037\019\066\124\014\079\112\029\047\029\014\044\112\014\040\037\096\018\012\079\112\029\014\044\014\037\029\040\037\019\014\044\037\124\014\040\079\021\108\045\029\021\108\014\040\037\006\029\039\029\045\029\079\018\112\029\066\040\079\086\014\079\021\108\029\021\108\112\014\028\118\005\003\033\118\005\003\033\008\029\014\037\086\014\108\066\014\044\014\040\037\047\012\037\019\014\040\037\029\040\112\014\045\045\029\086\040\014\112\014\079\112\014\040\037\001\029\014\044\014\040\037\012\040\019\037\079\029\040\019\037\009\014\029\040\014\079\038\018\045\045\079\037\012\040\079\018\012\087\014\044\059\037\079\066\037\019\018\079\079\037\047\027\014\029\037\027\014\079\014\040\112\045\029\021\108\014\037\020\066\044\012\044\112\014\029\045\014\037\038\018\045\079\021\108\037\079\029\040\019\028"), 
			Media = zmediaHappyPig_MSG
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\095\018\079\037\096\018\012\079\079\021\108\027\014\029\040\037\029\079\112\037\014\029\040\014\079\037\019\014\044\037\018\124\037\045\018\014\040\086\079\112\014\040\037\019\066\124\014\079\112\029\047\029\014\044\112\014\040\037\096\018\012\079\112\029\014\044\014\037\029\040\037\019\014\044\037\124\014\040\079\021\108\045\029\021\108\014\040\037\006\029\039\029\045\029\079\018\112\029\066\040\079\086\014\079\021\108\029\021\108\112\014\028\118\005\003\033\118\005\003\033\008\029\014\037\086\014\108\066\014\044\014\040\037\047\012\037\019\014\040\037\029\040\112\014\045\045\029\086\040\014\112\014\079\112\014\040\037\001\029\014\044\014\040\037\012\040\019\037\079\029\040\019\037\009\014\029\040\014\079\038\018\045\045\079\037\012\040\079\018\012\087\014\044\059\037\079\066\037\019\018\079\079\037\047\027\014\029\037\027\014\079\014\040\112\045\029\021\108\014\037\020\066\044\012\044\112\014\029\045\014\037\038\018\045\079\021\108\037\079\029\040\019\028\118\005\003\033\118\005\003\033\095\029\014\079\014\079\037\008\021\108\027\014\029\040\037\029\079\112\037\079\014\108\044\037\012\040\086\045\012\014\021\009\045\029\021\108\059\037\027\014\029\045\037\079\014\029\040\037\003\029\040\086\014\045\079\021\108\027\018\040\047\037\040\029\021\108\112\037\124\014\108\044\037\086\014\044\029\040\086\014\045\112\037\029\079\112\028"), 
			Media = zmediaSadPig_MSG
		}
	end
end
function zcharacterChicken:OnTalk(target)
	if ChickenChat == false then
		ChickenChat = true
		zitemEgg:MoveTo(zoneTemperateForest)
		zitemLemon:MoveTo(zoneTemperateForest)
		_Urwigo.MessageBox{
			Text = _O5Os("\121\014\044\037\029\079\112\037\019\018\010\037\024\066\124\124\037\087\029\112\112\014\037\040\018\014\108\014\044\037\047\012\037\124\029\044\059\037\019\014\040\040\037\124\014\029\040\014\037\085\012\086\014\040\037\079\029\040\019\037\047\029\014\124\045\029\021\108\037\079\021\108\045\014\021\108\112\028\118\005\003\033\118\005\003\033\008\021\108\018\012\037\124\018\045\037\018\012\038\037\124\014\029\040\014\037\038\044\029\079\021\108\037\086\014\045\014\086\112\014\040\037\122\029\014\044\059\037\079\014\108\014\040\037\019\029\014\037\040\029\021\108\112\037\112\066\045\045\037\018\012\079\028\037\085\124\037\008\021\108\066\014\040\079\112\014\040\037\029\079\112\037\019\018\079\037\107\014\045\087\014\028"), 
			Media = zmediaHen_MSG
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\059\037\124\014\029\040\014\037\024\012\014\009\014\040\037\079\029\040\019\037\009\012\044\047\037\039\066\044\037\019\014\124\037\008\021\108\045\012\014\109\038\014\040\028"), 
			Media = zmediaHen_MSG
		}
	end
end
function zcharacterChicken:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\085\012\038\037\019\014\044\037\122\044\019\014\037\045\014\087\014\040\037\124\014\108\044\037\096\012\014\108\040\014\044\037\018\045\079\037\117\014\040\079\021\108\014\040\028\037\085\045\045\014\029\040\014\037\029\040\037\017\108\029\040\018\037\045\014\087\014\040\037\124\014\108\044\037\018\045\079\037\092\037\117\029\045\045\029\018\044\019\014\040\037\096\012\108\040\014\044\028\118\005\003\033\118\005\003\033\096\018\012\079\108\012\014\108\040\014\044\037\009\066\014\040\040\014\040\037\029\124\037\120\018\108\044\037\021\018\028\037\102\007\119\037\087\029\079\037\092\119\119\037\122\029\014\044\037\045\014\086\014\040\059\037\027\014\040\040\037\029\108\040\014\040\037\112\018\086\045\029\021\108\037\019\018\079\037\086\014\045\014\086\112\014\037\122\029\037\027\014\086\086\014\040\066\124\124\014\040\037\027\029\044\019\028"), 
		Media = zmediaHen_MSG
	}
end
function zcharacterSilverbackGorilla:OnTalk(target)
	if Wherigo.NoCaseEquals(GorillaChat, _O5Os("\119")) then
		GorillaChat = _O5Os("\052")
		ZooChat = _O5Os("\092\007")
		zcharacterColobusMonkey:MoveTo(zoneTropicalRainForest)
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\036\066\044\124\018\045\014\044\027\014\029\079\014\037\044\014\019\014\037\029\021\108\037\101\018\037\040\029\021\108\112\037\124\029\112\037\038\044\014\124\019\014\040\037\001\029\014\044\014\040\059\037\018\087\014\044\037\019\014\044\037\113\029\040\086\012\029\040\037\108\018\112\037\124\029\044\037\018\040\086\014\087\066\112\014\040\059\037\124\014\029\040\037\096\018\018\044\037\018\012\038\037\019\014\124\037\003\012\014\021\009\014\040\037\047\012\037\086\014\079\112\018\045\112\014\040\028\118\005\003\033\118\005\003\033\104\040\019\037\019\018\040\040\037\108\018\112\037\019\014\044\037\087\045\066\014\019\014\044\027\014\029\079\014\037\124\014\029\040\037\027\012\040\019\014\044\079\021\108\066\014\040\014\079\037\079\029\045\087\014\044\040\014\079\037\096\018\018\044\037\109\029\040\009\037\086\014\038\018\014\044\087\112\028"), 
				Media = zmediaPinkBackGorilla_MSG
			}, 
			{
				Text = _O5Os("\036\066\044\124\018\045\014\044\027\014\029\079\014\037\108\018\087\014\037\029\021\108\037\101\018\037\018\012\021\108\037\029\124\124\014\044\037\008\108\018\124\109\066\066\037\087\014\029\037\124\029\044\059\037\018\087\014\044\037\019\014\044\037\087\045\066\014\019\014\037\009\045\014\029\040\014\037\008\112\012\124\124\014\045\018\038\038\014\037\108\018\112\037\124\029\044\037\124\014\029\040\014\079\037\086\014\009\045\018\012\112\028\118\005\003\033\118\005\003\033\024\018\040\040\079\112\037\095\012\037\124\029\044\037\108\014\045\038\014\040\059\037\124\014\029\040\037\008\108\018\124\109\066\066\037\027\029\014\019\014\044\047\012\087\014\009\066\124\124\014\040\010\037\020\029\014\045\045\014\029\021\108\112\037\038\029\040\019\014\040\037\027\029\044\037\101\018\037\101\014\124\018\040\019\014\040\059\037\019\014\044\037\012\040\079\037\012\040\112\014\044\079\112\012\014\112\047\014\040\037\009\018\040\040\028"), 
				Media = zmediaPinkBackGorilla_MSG
			}
		}
	elseif Wherigo.NoCaseEquals(GorillaChat, _O5Os("\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\096\018\079\112\037\095\012\037\124\014\029\040\037\008\108\018\124\109\066\066\037\086\014\038\012\040\019\014\040\010"), 
			Media = zmediaPinkBackGorilla_MSG
		}
	elseif Wherigo.NoCaseEquals(GorillaChat, _O5Os("\102")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\059\037\029\021\108\037\038\012\108\045\014\037\124\029\021\108\037\101\014\112\047\112\037\079\066\037\039\029\014\045\037\087\014\079\079\014\044\028"), 
			Media = zmediaSilverBackGorilla_MSG
		}
	end
end
function zcharacterSilverbackGorilla:OnExamine(target)
	if zcharacterSilverbackGorilla:Contains(zitemShampoo) then
		_Urwigo.MessageBox{
			Text = _O5Os("\107\066\044\029\045\045\018\079\037\027\014\029\079\014\040\037\014\029\040\014\040\037\044\066\087\012\079\112\014\040\059\037\079\112\018\124\124\029\086\014\040\037\024\066\044\109\014\044\087\018\012\037\018\012\038\028\037\008\029\014\037\079\029\040\019\037\079\112\014\108\014\040\019\037\014\112\027\018\037\052\059\102\007\037\087\029\079\037\052\059\032\007\037\117\014\112\014\044\037\108\066\021\108\059\037\027\066\087\014\029\037\079\029\014\037\124\014\029\079\112\037\019\029\014\037\024\040\029\014\037\014\112\027\018\079\037\086\014\087\014\012\086\112\037\108\018\045\112\014\040\028\037\118\005\003\033\118\005\003\033\107\066\044\029\045\045\018\079\037\045\014\087\014\040\037\029\040\037\107\044\012\109\109\014\040\037\047\012\079\018\124\124\014\040\059\037\019\029\014\037\047\027\014\029\037\087\029\079\037\046\119\037\001\029\014\044\014\037\012\124\038\018\079\079\014\040\037\009\066\040\040\014\040\028"), 
			Media = zmediaSilverBackGorilla_MSG
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\107\066\044\029\045\045\018\079\037\027\014\029\079\014\040\037\014\029\040\014\040\037\044\066\087\012\079\112\014\040\059\037\079\112\018\124\124\029\086\014\040\037\024\066\044\109\014\044\087\018\012\037\018\012\038\028\037\008\029\014\037\079\029\040\019\037\079\112\014\108\014\040\019\037\014\112\027\018\037\052\059\102\007\037\087\029\079\037\052\059\032\007\037\117\014\112\014\044\037\108\066\021\108\059\037\027\066\087\014\029\037\079\029\014\037\124\014\029\079\112\037\019\029\014\037\024\040\029\014\037\014\112\027\018\079\037\086\014\087\014\012\086\112\037\108\018\045\112\014\040\028\037\118\005\003\033\118\005\003\033\107\066\044\029\045\045\018\079\037\045\014\087\014\040\037\029\040\037\107\044\012\109\109\014\040\037\047\012\079\018\124\124\014\040\059\037\019\029\014\037\047\027\014\029\037\087\029\079\037\046\119\037\001\029\014\044\014\037\012\124\038\018\079\079\014\040\037\009\066\040\040\014\040\028\118\005\003\033\118\005\003\033\095\029\014\079\014\044\037\107\066\044\029\045\045\018\037\108\029\014\044\037\029\079\112\037\079\014\108\044\037\112\044\018\012\044\029\086\059\037\027\014\029\045\037\079\014\029\040\037\003\012\021\009\014\040\037\040\029\021\108\112\037\124\014\108\044\037\079\029\045\087\014\044\040\037\086\045\018\040\047\112\028"), 
			Media = zmediaPinkBackGorilla_MSG
		}
	end
end
function zcharacterColobusMonkey:OnTalk(target)
	if Wherigo.NoCaseEquals(ColobusChat, _O5Os("\119")) then
		ColobusChat = _O5Os("\052")
		_Urwigo.MessageBox{
			Text = _O5Os("\121\029\014\037\019\012\037\027\014\029\079\079\112\059\037\045\029\014\087\014\037\029\021\108\037\019\029\014\037\040\014\012\014\037\076\044\029\079\012\044\037\019\014\079\037\107\066\044\029\045\045\018\028\037\113\029\040\009\037\029\079\112\037\124\014\029\040\014\037\078\029\014\087\045\029\040\086\079\038\018\044\087\014\028\118\005\003\033\118\005\003\033\085\087\014\044\037\014\086\018\045\059\037\019\014\044\037\113\029\040\086\012\029\040\059\037\040\018\021\108\037\019\014\124\037\019\012\037\079\012\021\108\079\112\059\037\029\079\112\037\108\029\014\044\037\044\014\029\040\037\086\014\009\066\124\124\014\040\037\012\040\019\037\108\018\112\037\108\029\014\044\037\104\040\066\044\019\040\012\040\086\037\086\014\124\018\021\108\112\028\037\121\014\040\040\037\019\012\037\124\029\044\037\014\029\040\014\037\076\044\018\086\014\037\087\014\018\040\112\027\066\044\112\014\079\112\059\037\086\014\087\014\037\029\021\108\037\019\029\044\037\019\018\079\037\008\108\018\124\109\066\066\028"), 
			Media = zmediaColobus_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputRainForest)
					end)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(ColobusChat, _O5Os("\052")) then
		_Urwigo.MessageBox{
			Text = _O5Os("\122\040\019\045\029\021\108\037\087\014\044\014\029\112\010"), 
			Media = zmediaColobus_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputRainForest)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _O5Os("\008\066\045\045\037\029\021\108\037\019\014\029\040\037\096\018\018\044\037\079\021\108\066\014\040\014\044\037\124\018\021\108\014\040\010"), 
			Media = zmediaColobus_MSG
		}
	end
end
function zcharacterColobusMonkey:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\029\014\037\008\021\108\027\018\044\047\100\027\014\029\079\079\014\040\037\008\112\012\124\124\014\045\018\038\038\014\040\037\079\029\040\019\037\014\029\040\014\037\113\044\029\124\018\112\014\040\086\018\112\112\012\040\086\037\018\012\079\037\019\014\044\037\107\044\012\109\109\014\037\019\014\044\037\008\112\012\124\124\014\045\018\038\038\014\040\037\029\040\040\014\044\108\018\045\087\037\019\014\044\037\076\018\124\029\045\029\014\037\019\014\044\037\117\014\014\044\009\018\112\047\014\040\039\014\044\027\018\040\019\112\014\040\028\037\095\014\044\037\027\029\079\079\014\040\079\021\108\018\038\112\045\029\021\108\014\037\036\018\124\014\037\017\066\045\066\087\012\079\037\014\040\112\079\112\018\124\124\112\037\019\014\124\037\107\044\029\014\021\108\029\079\021\108\014\040\037\013\009\066\045\066\087\066\079\037\100\037\019\014\044\037\020\014\044\079\112\012\124\124\014\045\112\014\055\028\118\005\003\033\118\005\003\033\095\018\079\037\076\014\045\045\037\019\029\014\079\014\044\037\001\029\014\044\014\037\029\079\112\037\009\066\040\112\044\018\079\112\044\014\029\021\108\037\079\021\108\027\018\044\047\100\027\014\029\010\037\086\014\038\018\014\044\087\112\028\037\118\005\003\033\118\005\003\033\005\014\029\037\018\045\045\014\040\037\008\112\012\124\124\014\045\018\038\038\014\040\037\029\079\112\037\019\014\044\037\095\018\012\124\014\040\037\044\012\014\021\009\086\014\087\029\045\019\014\112\059\037\014\029\040\014\037\085\040\109\018\079\079\012\040\086\037\018\040\037\019\029\014\037\087\018\012\124\087\014\027\066\108\040\014\040\019\014\037\078\014\087\014\040\079\027\014\029\079\014\028\037"), 
		Media = zmediaColobus_MSG
	}
end
function zitemAlarmClock:OnUseWith(target)
	if target == zcharacterZookeeper then
		_Urwigo.MessageBox{
			Text = _O5Os("\121\029\014\037\086\012\112\059\037\014\044\037\038\012\040\009\112\029\066\040\029\014\044\112\037\040\066\021\108\028\037\078\066\079\059\037\110\087\014\040\012\112\047\014\110\037\029\108\040\037\124\029\112\037\019\014\124\037\005\044\018\012\040\087\018\014\044\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif target == zcharacterSnowyOwl then
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\059\037\040\014\029\040\059\037\027\018\079\037\014\029\040\037\079\021\108\044\014\021\009\045\029\021\108\014\044\037\024\044\018\021\108\028\037\078\014\086\037\019\018\079\037\095\029\040\086\037\027\014\086\099"), 
			Media = zmediaSnowyOwl_MSG
		}
	elseif target == zcharacterBrownBear then
		ztaskWakeupBrownBear.Complete = true
		zitemAlarmClock:MoveTo(zcharacterBrownBear)
		zitemAlarmClock.Visible = false
		zitemAlarmClock.Commands.UseWith.Enabled = false
		zitemShaunathePenguin:MoveTo(zoneNorthernTrail)
		ZooChat = _O5Os("\007")
		SnowyChat = _O5Os("\092")
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\107\018\014\108\040\028\028\028\028\028\118\005\003\033\118\005\003\033\096\124\059\037\086\012\112\014\040\037\117\066\044\086\014\040\099\118\005\003\033\126\021\108\037\038\012\014\108\045\014\037\124\029\021\108\059\037\018\045\079\037\066\087\037\029\021\108\037\014\027\029\086\037\086\014\079\021\108\045\018\038\014\040\037\108\018\014\112\112\014\028\037\121\014\045\021\108\014\040\037\117\066\040\018\112\037\108\018\087\014\040\037\027\029\044\037\019\014\040\040\010\037"), 
				Media = zmediaBrownBear_MSG
			}, 
			{
				Text = _O5Os("\085\108\059\037\027\018\079\037\029\079\112\037\019\018\079\037\019\014\040\040\037\012\040\112\014\044\037\124\029\044\010\037\008\018\087\018\059\037\019\014\044\037\113\029\040\086\012\029\040\099\037\121\018\079\037\124\018\021\108\079\112\037\095\012\037\019\014\040\040\037\019\018\010\118\005\003\033\118\005\003\033\024\018\040\040\079\112\037\095\012\037\087\029\112\112\014\037\019\029\014\079\014\040\037\087\045\066\014\019\014\040\037\113\029\040\086\012\029\040\037\012\040\112\014\044\037\124\029\044\037\044\018\012\079\040\014\108\124\014\040\059\037\019\018\124\029\112\037\029\021\108\037\029\040\037\003\012\108\014\037\027\014\029\112\014\044\037\079\021\108\045\018\038\014\040\037\009\018\040\040\028"), 
				Media = zmediaBrownBear_MSG
			}
		}
	end
end
function zitemAlarmClock:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\014\044\037\121\014\021\009\014\044\037\019\014\079\037\005\044\018\012\040\087\018\014\044\014\040\028\037\118\005\003\033\118\005\003\033\095\018\079\037\029\079\112\037\014\029\040\014\037\008\109\014\047\029\018\045\018\040\038\014\044\112\029\086\012\040\086\059\037\012\124\037\087\014\079\066\040\019\014\044\079\037\045\018\040\086\014\037\006\014\029\112\044\018\014\012\124\014\037\047\012\037\012\014\087\014\044\087\044\012\014\021\009\014\040\028"), 
		Media = zmediaAlarmClock_MSG
	}
end
function zitemShaunathePenguin:OnTake(target)
	zitemShaunathePenguin.Commands.Take.Enabled = false
	zitemShaunathePenguin:MoveTo(Player)
	PenguinCount = _O5Os("\007")
	ztaskHelpRoundUpthePenguins.Description = (_O5Os("\095\012\037\124\012\079\079\112\037\040\066\021\108\037")..PenguinCount).._O5Os("\037\113\029\040\086\012\029\040\014\037\038\029\040\019\014\040\028")
	ztaskVisitAustralasia.Visible = true
	ztaskVisitAustralasia.Active = true
	zoneAustralasia.Visible = true
	zoneAustralasia.Active = true
	ZooChat = _O5Os("\061")
	SnowyChat = _O5Os("\046")
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\036\014\012\014\044\037\107\014\086\014\040\079\112\018\040\019\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\008\018\087\018\037\019\014\044\037\113\029\040\086\012\029\040"), 
			Media = zmediaShaunathePenguin_MSG
		}, 
		{
			Text = _O5Os("\008\012\109\014\044\059\037\101\014\112\047\112\037\019\018\037\027\029\044\037\108\029\014\044\037\018\124\037\008\112\044\014\029\021\108\014\045\047\066\066\037\038\014\044\112\029\086\037\079\029\040\019\059\037\045\018\079\079\037\012\040\079\037\047\012\037\019\014\040\037\003\018\012\087\009\018\112\047\014\040\037\086\014\108\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\037\107\014\108\014\037\047\012\037\019\014\040\037\003\018\012\087\009\018\112\047\014\040\028\118\005\003\033\008\021\108\018\012\037\018\012\038\037\019\029\014\037\024\018\044\112\014\037\066\019\014\044\037\047\012\037\019\014\040\037\110\078\066\021\018\112\029\066\040\079\110\028"), 
			Media = zmediaZoneAustralasia
		}
	}
	PenguinVariable = PenguinVariable + 1
end
function zitemShaunathePenguin:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\008\018\087\018\037\029\079\112\037\014\029\040\037\079\021\108\045\018\012\014\044\037\113\029\040\086\012\029\040\059\037\018\012\038\037\019\014\040\037\019\012\037\086\012\112\037\018\012\038\109\018\079\079\014\040\037\079\066\045\045\112\014\079\112\028\037\121\014\040\040\037\014\044\037\019\029\044\037\040\066\021\108\124\018\045\037\027\014\086\044\014\040\040\112\059\037\027\029\044\019\037\014\079\037\019\029\044\037\040\029\021\108\112\037\086\014\045\029\040\086\014\040\059\037\029\108\040\037\027\029\014\019\014\044\037\014\029\040\047\012\038\018\040\086\014\040\028"), 
		Media = zmediaShaunathePenguin_MSG
	}
end
function zitemHoney:OnGive(target)
	if target == zcharacterTiger then
		ztaskFindanAdhesiveforTiger.Complete = true
		zitemHoney:MoveTo(zcharacterTiger)
		zitemHoney.Visible = false
		zitemHoney.Commands.Give.Enabled = false
		zcharacterTiger.Media = zmediaStripeyTiger
		ZooChat = _O5Os("\052\102")
		TigerChat = _O5Os("\092")
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\096\066\040\029\086\010\037\095\012\037\027\014\029\079\079\112\037\019\066\021\108\059\037\019\018\079\079\037\001\029\086\014\044\037\009\014\029\040\014\040\037\096\066\040\029\086\037\014\079\079\014\040\028\118\005\003\033\118\005\003\033\085\087\014\044\037\027\018\044\112\014\037\124\018\045\059\037\029\021\108\037\009\018\040\040\037\019\014\040\037\096\066\040\029\086\037\101\018\037\039\014\044\027\014\040\019\014\040\059\037\048\040\087\079\109\069\012\124\037\124\014\029\040\014\037\008\112\044\014\029\038\014\040\037\027\029\014\019\014\044\037\018\040\047\012\009\045\014\087\014\040\028"), 
				Media = zmediaSadTiger_MSG
			}, 
			{
				Text = _O5Os("\126\021\108\037\087\029\040\037\124\029\044\037\012\014\087\044\029\086\014\040\079\037\047\029\014\124\045\029\021\108\037\079\029\021\108\014\044\059\037\019\018\079\079\037\029\021\108\037\019\014\040\037\113\029\040\086\012\029\040\037\120\014\079\009\018\037\029\124\037\107\014\108\014\086\014\037\019\014\044\037\117\018\040\012\045\079\037\086\014\079\014\108\014\040\037\108\018\087\014\028\037\122\044\037\108\018\112\037\079\029\021\108\037\027\066\108\045\037\018\045\079\037\009\045\014\029\040\014\037\003\018\012\087\009\018\112\047\014\037\039\014\044\009\045\014\029\019\014\112\028\118\005\003\033\118\005\003\033\005\014\018\040\112\027\066\044\112\014\037\124\029\044\037\014\029\040\014\037\076\044\018\086\014\035\037\018\040\037\027\014\045\021\108\014\124\037\122\029\040\086\018\040\086\037\079\112\014\108\014\040\037\027\029\044\037\086\014\044\018\019\014\010\037\076\029\040\019\014\037\014\079\037\108\014\044\018\012\079\037\012\040\019\037\079\018\086\056\079\037\124\029\044\037\019\018\040\040\099"), 
				Media = zmediaStripeyTiger_MSG
			}
		}
	elseif target == zcharacterSunBear then
		_Urwigo.MessageBox{
			Text = _O5Os("\036\014\029\040\037\019\018\040\009\014\059\037\029\021\108\037\108\018\087\014\037\087\014\044\014\029\112\079\037\039\066\040\037\019\014\124\037\096\066\040\029\086\028"), 
			Media = zmediaSunBear_MSG
		}
	elseif target == zcharacterSnowLeopard then
		_Urwigo.MessageBox{
			Text = _O5Os("\036\014\029\040\037\019\018\040\009\014\059\037\029\021\108\037\124\018\086\037\009\014\029\040\014\040\037\096\066\040\029\086\028"), 
			Media = zmediaSnowLeopard_MSG
		}
	elseif target == zcharacterZookeeper then
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\037\040\014\029\040\059\037\112\066\112\018\045\037\039\014\044\009\045\014\087\112\037\079\029\040\019\037\101\014\112\047\112\037\124\014\029\040\014\037\096\018\014\040\019\014\028\037\118\005\003\033\118\005\003\033\020\014\044\079\012\021\108\037\019\066\021\108\037\124\018\045\059\037\019\014\040\037\096\066\040\029\086\037\019\014\124\037\001\029\086\014\044\037\047\012\037\086\014\087\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	end
end
function zitemHoney:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\014\044\037\029\079\112\037\079\014\108\044\059\037\079\014\108\044\037\009\045\014\087\044\029\086\028"), 
		Media = zmediaHoney_MSG
	}
end
function zitemJenthePenguin:OnTake(target)
	zitemJenthePenguin:MoveTo(Player)
	zitemJenthePenguin.Commands.Take.Enabled = false
	ZooChat = _O5Os("\052\046")
	PenguinCount = _O5Os("\046")
	ztaskHelpRoundUpthePenguins.Description = (_O5Os("\095\012\037\124\012\079\079\037\040\066\021\108\037")..PenguinCount).._O5Os("\037\113\029\040\086\012\029\040\014\037\038\029\040\019\014\040\028")
	ztaskVisitTropicalAsia.Visible = true
	ztaskVisitTropicalAsia.Active = true
	zoneTropicalAsia.Visible = true
	zoneTropicalAsia.Active = true
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\036\014\012\014\044\037\107\014\086\014\040\079\112\018\040\019\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\120\014\079\009\018\037\019\014\044\037\113\029\040\086\012\029\040"), 
			Media = zmediaJenthePenguin_MSG
		}, 
		{
			Text = _O5Os("\001\066\045\045\037\086\014\124\018\021\108\112\059\037\045\018\079\079\037\012\040\079\037\040\012\040\037\047\012\124\037\085\038\038\014\040\108\018\012\079\037\086\014\108\014\040\059\037\012\124\037\019\066\044\112\037\040\018\021\108\037\019\014\124\037\040\018\014\021\108\079\112\014\040\037\113\029\040\086\012\029\040\037\047\012\037\079\012\021\108\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\037\086\014\108\014\037\047\012\124\037\085\038\038\014\040\108\018\012\079\028"), 
			Media = zmediaZoneTropicalAsia
		}
	}
	PenguinVariable = PenguinVariable + 1
end
function zitemJenthePenguin:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\014\044\037\113\029\040\086\012\029\040\037\108\066\014\044\112\037\040\029\021\108\112\037\018\012\038\037\047\012\037\045\018\021\108\014\040\028\028\028\028"), 
		Media = zmediaJenthePenguin_MSG
	}
end
function zitemTigerStripes:OnTake(target)
	zitemTigerStripes.Commands.Take.Enabled = false
	zitemTigerStripes.Commands.Give.Enabled = true
	zitemTigerStripes.Commands.Use.Enabled = true
	zitemTigerStripes:MoveTo(Player)
	ZooChat = _O5Os("\025")
	SnowLeopardChat = _O5Os("\102")
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\036\014\012\014\044\037\107\014\086\014\040\079\112\018\040\019\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\001\029\086\014\044\079\112\044\014\029\038\014\040"), 
			Media = zmediaTigerStripes_MSG
		}, 
		{
			Text = _O5Os("\107\012\112\037\086\014\124\018\021\108\112\099\037\036\012\040\037\124\012\014\079\079\014\040\037\027\029\044\037\019\029\014\037\040\012\044\037\040\066\021\108\037\019\014\124\037\001\029\086\014\044\037\086\014\087\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	}
end
function zitemTigerStripes:OnGive(target)
	if target == zcharacterTiger then
		zitemTigerStripes.Commands.Give.Enabled = false
		ztaskReturntheTigersStripes.Complete = true
		ztaskFindanAdhesiveforTiger.Visible = true
		ztaskFindanAdhesiveforTiger.Active = true
		zitemTigerStripes:MoveTo(zcharacterTiger)
		zitemTigerStripes.Visible = false
		zcharacterSunBear:MoveTo(zoneAustralasia)
		ZooChat = _O5Os("\052\119")
		TigerChat = _O5Os("\102")
		_Urwigo.MessageBox{
			Text = _O5Os("\060\108\059\037\019\018\040\009\014\099\118\005\003\033\118\005\003\033\085\087\014\044\037\027\018\044\112\014\059\037\027\029\014\037\087\014\009\066\124\124\014\037\029\021\108\037\019\029\014\037\040\012\040\037\027\029\014\019\014\044\037\018\040\037\124\014\029\040\037\076\014\045\045\037\019\044\018\040\010\037\008\029\014\037\108\018\045\112\014\040\037\040\029\021\108\112\037\039\066\040\037\018\045\045\014\029\040\014\028\118\005\003\033\118\005\003\033\024\018\040\040\079\112\037\095\012\037\124\029\044\037\108\014\045\038\014\040\059\037\014\112\027\018\079\037\047\012\037\038\029\040\019\014\040\059\037\124\029\112\037\019\014\124\037\029\021\108\037\019\029\014\037\008\112\044\014\029\038\014\040\037\027\029\014\019\014\044\037\018\040\087\044\029\040\086\014\040\037\009\018\040\040\010"), 
			Media = zmediaSadTiger_MSG
		}
	elseif target == zcharacterZookeeper then
		_Urwigo.MessageBox{
			Text = _O5Os("\008\112\044\014\029\038\014\040\010\118\005\003\033\036\014\059\037\019\018\040\009\014\059\037\014\029\040\014\037\086\014\079\112\044\014\029\038\112\014\037\104\040\029\038\066\044\124\037\086\014\108\112\037\086\018\044\037\040\029\021\108\112\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif target == zcharacterSnowLeopard then
		_Urwigo.MessageBox{
			Text = _O5Os("\005\044\044\044\028\028\028\028\118\005\003\033\036\014\029\040\037\019\018\040\009\014\059\037\019\029\014\037\018\040\019\014\044\014\040\037\008\021\108\040\014\014\045\014\066\109\018\044\019\014\040\037\027\012\044\019\014\040\037\124\029\021\108\037\018\012\079\045\018\021\108\014\040\059\037\027\014\040\040\037\029\021\108\037\079\066\037\044\012\124\045\018\012\038\014\040\037\027\012\014\044\019\014\028"), 
			Media = zmediaSnowLeopard_MSG
		}
	end
end
function zitemTigerStripes:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\122\079\037\027\029\044\019\037\101\018\037\086\014\079\018\086\112\059\037\019\029\014\037\008\112\044\014\029\038\014\040\037\079\014\029\014\040\037\079\066\027\018\079\037\027\029\014\037\076\029\040\086\014\044\018\087\019\044\012\014\021\009\014\059\037\018\087\014\044\037\038\012\014\044\037\124\029\021\108\037\079\014\108\014\040\037\019\029\014\037\018\045\045\014\037\086\045\014\029\021\108\037\018\012\079\028"), 
		Media = zmediaTigerStripes_MSG
	}
end
function zitemTigerStripes:OnUse(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\085\045\079\066\037\019\029\044\037\079\112\014\108\014\040\037\079\029\014\037\040\029\021\108\112\037\027\029\044\009\045\029\021\108\037\086\012\112\099\037\020\014\044\079\012\021\108\037\079\029\014\037\045\029\014\087\014\044\037\019\014\124\037\001\029\086\014\044\037\047\012\037\110\086\014\087\014\040\110\028"), 
		Media = zmediaTigerStripes_MSG
	}
end
function zitemDrainPlug:OnGive(target)
	if target == zcharacterHippopotamus then
		zitemDrainPlug:MoveTo(zcharacterHippopotamus)
		zitemDrainPlug.Visible = false
		zitemDrainPlug.Commands.Give.Enabled = false
		zitemBenthePenguin:MoveTo(zoneAfricanSavanna)
		ZooChat = _O5Os("\102\061")
		HippoChat = _O5Os("\102")
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\020\029\014\045\014\040\037\095\018\040\009\059\037\019\018\079\079\037\019\012\037\124\014\029\040\014\040\037\121\018\040\040\014\040\079\112\066\014\109\079\014\045\037\027\029\014\019\014\044\037\087\014\079\066\044\086\112\037\108\018\079\112\028\037\120\014\112\047\112\037\009\018\040\040\037\029\021\108\037\014\040\019\045\029\021\108\037\027\029\014\019\014\044\037\124\014\029\040\014\040\037\113\066\066\045\037\018\012\038\038\012\014\045\045\014\040\037\012\040\019\037\014\029\040\014\037\113\018\044\112\030\037\066\044\086\018\040\029\079\029\014\044\014\040\028\118\005\003\033\118\005\003\033\104\040\019\037\029\021\108\037\027\014\044\019\014\037\018\012\021\108\037\019\018\079\037\006\014\087\044\018\037\014\029\040\045\018\019\014\040\028"), 
				Media = zmediaHippo_MSG
			}, 
			{
				Text = _O5Os("\085\021\108\037\079\066\059\037\079\021\108\018\012\037\124\018\045\037\108\029\014\044\028\118\005\003\033\095\014\044\037\038\044\014\021\108\014\037\113\029\040\086\012\029\040\037\108\018\112\037\079\029\021\108\037\108\029\040\112\014\044\037\124\029\044\037\039\014\044\079\112\014\021\009\112\059\037\012\124\037\014\029\040\037\008\112\012\014\021\009\037\039\066\040\037\124\014\029\040\014\124\037\024\012\021\108\014\040\037\047\012\037\079\112\014\108\045\014\040\028"), 
				Media = zmediaHippo_MSG
			}
		}
	elseif target == zcharacterZebra then
		_Urwigo.MessageBox{
			Text = _O5Os("\036\014\029\040\059\037\019\014\040\037\079\066\045\045\112\014\079\112\037\019\012\037\124\029\044\037\040\029\021\108\112\037\027\029\014\019\014\044\037\047\012\044\012\014\021\009\037\086\014\087\014\040\028\037\122\044\029\040\040\014\044\014\037\019\029\021\108\037\019\066\021\108\059\037\019\018\079\079\037\029\021\108\037\047\012\044\037\040\018\014\021\108\079\112\014\040\037\113\066\066\045\100\113\018\044\112\030\037\019\014\079\037\036\029\045\109\038\014\044\019\014\079\037\086\014\108\014\040\037\027\029\045\045\028\118\005\003\033\118\005\003\033\121\014\040\040\037\009\014\029\040\037\121\018\079\079\014\044\037\029\124\037\113\066\066\045\037\029\079\112\059\037\124\018\021\108\112\037\019\018\079\037\036\029\045\109\038\014\044\019\037\045\014\029\019\014\044\037\009\014\029\040\014\037\113\066\066\045\109\018\044\112\030\079\037\124\014\108\044\028\028\028\028"), 
			Media = zmediaZebra_MSG
		}
	elseif target == zcharacterZookeeper then
		_Urwigo.MessageBox{
			Text = _O5Os("\036\014\029\040\059\037\019\014\044\037\086\014\108\066\044\112\037\019\014\124\037\036\029\045\109\038\014\044\019\028\037\107\029\087\037\029\108\040\037\040\029\021\108\112\037\124\029\044\028"), 
			Media = zmediaZookeeper_MSG
		}
	end
end
function zitemDrainPlug:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\014\044\037\008\112\066\014\109\079\014\045\037\038\012\014\044\037\019\014\040\037\036\029\045\109\038\014\044\019\109\066\066\045\028"), 
		Media = zmediaDrainPlug_MSG
	}
end
function zitemBenthePenguin:OnTake(target)
	zitemBenthePenguin:MoveTo(Player)
	zitemBenthePenguin.Commands.Take.Enabled = false
	ZooChat = _O5Os("\102\032")
	PenguinCount = _O5Os("\102")
	ztaskHelpRoundUpthePenguins.Description = (_O5Os("\095\012\037\124\012\079\079\112\037\040\066\021\108\037")..PenguinCount).._O5Os("\037\113\029\040\086\012\029\040\014\037\038\029\040\019\014\040\028")
	ztaskVisittheTemperateForest.Visible = true
	ztaskVisittheTemperateForest.Active = true
	zoneTemperateForest.Visible = true
	zoneTemperateForest.Active = true
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\036\014\012\014\044\037\107\014\086\014\040\079\112\018\040\019\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\005\014\040\037\019\014\044\037\113\029\040\086\012\029\040"), 
			Media = zmediaBenthePenguin_MSG
		}, 
		{
			Text = _O5Os("\107\044\066\079\079\018\044\112\029\086\099\118\005\003\033\120\014\112\047\112\037\019\018\037\108\029\014\044\037\029\040\037\019\014\044\037\018\038\044\029\009\018\040\029\079\021\108\014\040\037\008\018\039\018\040\040\014\037\018\045\045\014\079\037\029\040\037\060\044\019\040\012\040\086\037\029\079\112\059\037\045\018\079\079\037\012\040\079\037\019\066\021\108\037\124\018\045\037\029\040\037\019\029\014\037\110\107\014\124\018\014\079\079\029\086\112\014\040\037\005\044\014\029\112\014\040\110\037\086\014\108\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\118\005\003\033\107\014\108\014\037\029\040\037\019\029\014\037\110\107\014\124\018\014\079\079\029\086\112\014\040\037\005\044\014\029\112\014\040\110\059\037\018\124\037\005\014\079\112\014\040\037\012\014\087\014\044\037\019\029\014\037\096\018\014\040\086\014\087\044\012\014\021\009\014\028"), 
			Media = zmediaZoneTemperateForest
		}
	}
	PenguinVariable = PenguinVariable + 1
end
function zitemBenthePenguin:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\029\014\079\014\044\037\113\029\040\086\012\029\040\037\027\029\045\045\037\079\021\108\066\040\037\029\124\124\014\044\037\014\029\040\037\086\044\066\079\079\014\044\037\008\018\014\040\086\014\044\037\027\014\044\019\014\040\028\037\060\087\037\019\018\079\037\018\087\014\044\037\101\014\124\018\045\079\037\086\014\045\029\040\086\112\010"), 
		Media = zmediaBenthePenguin_MSG
	}
end
function zitemSiamangsVoice:OnTake(target)
	zitemSiamangsVoice:MoveTo(Player)
	zitemSiamangsVoice.Commands.Take.Enabled = false
	zitemSiamangsVoice.Commands.Give.Enabled = true
	ZooChat = _O5Os("\052\070")
	PythonChat = _O5Os("\102")
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\095\012\037\086\044\014\029\038\079\112\037\029\040\037\019\018\079\037\117\018\012\045\037\019\014\044\037\113\030\112\108\066\040\037\012\040\019\037\040\029\124\124\079\112\037\019\029\014\037\008\112\029\124\124\014\037\019\014\079\037\008\021\108\029\124\109\018\040\079\014\040\037\108\014\044\018\012\079\028")
		}, 
		{
			Text = _O5Os("\036\014\012\014\044\037\107\014\086\014\040\079\112\018\040\019\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\095\029\014\037\008\112\029\124\124\014\037\019\014\079\037\008\021\108\029\124\109\018\040\079\014\040"), 
			Media = zmediaSiamangVoice_MSG
		}, 
		{
			Text = _O5Os("\107\012\112\037\086\014\124\018\021\108\112\099\118\005\003\033\036\012\040\037\086\029\087\037\019\029\014\037\008\112\029\124\124\014\037\047\012\044\012\014\021\009\037\018\040\037\079\014\029\040\014\040\037\005\014\079\029\112\047\014\044\028"), 
			Media = zmediaZookeeper_MSG
		}
	}
end
function zitemSiamangsVoice:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\018\079\037\029\079\112\037\019\029\014\037\008\112\029\124\124\014\037\019\014\079\037\008\021\108\029\124\109\018\040\079\014\040\099"), 
		Media = zmediaSiamangVoice_MSG
	}
end
function zitemSiamangsVoice:OnGive(target)
	if target == zcharacterPython then
		_Urwigo.MessageBox{
			Text = _O5Os("\036\014\029\040\059\037\040\014\029\040\059\037\040\014\029\040\028\037\126\021\108\037\108\018\087\037\079\029\014\037\019\066\021\108\037\086\014\044\018\019\014\037\014\044\079\112\037\018\087\086\014\086\014\087\014\040\028\037\126\021\108\037\027\029\045\045\037\019\029\014\037\040\029\021\108\112\037\124\014\108\044\099"), 
			Media = zmediaPython_MSG
		}
	elseif target == zcharacterZookeeper then
		_Urwigo.MessageBox{
			Text = _O5Os("\036\014\029\040\059\037\087\029\112\112\014\037\086\029\087\037\079\029\014\037\040\029\021\108\112\037\124\029\044\028\037\107\029\087\037\079\029\014\037\019\014\124\037\008\021\108\029\124\109\018\040\079\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}
	elseif target == zcharacterSiamang then
		ztaskRetrievetheSiamangsVoice.Complete = true
		zitemSiamangsVoice.Commands.Give.Enabled = false
		zitemSiamangsVoice.Visible = false
		ZooChat = _O5Os("\052\025")
		SiamangChat = _O5Os("\102")
		zcharacterSiamang.Media = zmediaSiamangWithVoice
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\020\029\014\045\014\040\037\095\018\040\009\037\038\012\044\037\019\014\029\040\014\037\096\029\045\038\014\028\037\095\029\014\079\014\044\037\009\045\014\029\040\014\059\037\038\044\014\021\108\014\037\113\029\040\086\012\029\040\037\108\018\112\037\079\029\014\037\124\029\044\037\086\014\079\112\066\108\045\014\040\037\018\045\079\037\029\021\108\037\079\021\108\045\029\014\038\059\037\018\087\014\044\037\029\021\108\037\108\018\087\014\037\014\029\040\014\037\126\019\014\014\059\037\027\066\037\014\044\037\079\029\021\108\037\039\014\044\079\112\014\021\009\112\037\108\018\112\028"), 
				Media = zmediaSiamangWithVoice_MSG
			}, 
			{
				Text = _O5Os("\008\018\086\037\124\029\044\059\037\027\014\045\021\108\014\044\037\005\012\021\108\079\112\018\087\014\037\108\029\014\044\037\012\087\014\044\037\012\040\079\037\079\021\108\027\014\087\112\059\037\027\014\040\040\037\019\012\037\014\079\037\108\014\044\012\018\079\086\014\038\012\040\019\014\040\037\108\018\079\112\059\037\009\066\124\124\037\047\012\037\124\029\044\037\012\040\019\037\079\018\086\037\014\079\037\124\029\044\099"), 
				Media = zmediaSiamangWithVoice_MSG
			}
		}
	end
end
function zitemLemon:OnTake(target)
	zitemLemon:MoveTo(Player)
	ZooChat = _O5Os("\092\119")
	zitemLemon.Commands.Take.Enabled = false
	zitemLemon.Commands.Give.Enabled = true
	_Urwigo.MessageBox{
		Text = _O5Os("\036\014\012\014\044\037\107\014\086\014\040\079\112\018\040\019\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\006\029\112\044\066\040\014"), 
		Media = zmediaLemon_MSG
	}
end
function zitemLemon:OnGive(target)
	if target == zcharacterZookeeper then
		_Urwigo.MessageBox{
			Text = _O5Os("\005\066\018\059\037\019\029\014\037\029\079\112\037\079\066\037\079\018\012\014\044\059\037\019\018\037\009\044\018\014\012\079\014\045\040\037\079\029\021\108\037\101\018\037\124\014\029\040\014\037\096\018\018\044\014\028\118\005\003\033\036\014\029\040\059\037\019\018\040\009\014\059\037\019\029\014\037\027\029\045\045\037\029\021\108\037\040\029\021\108\112\099"), 
			Media = zmediaZookeeper_MSG
		}
	elseif target == zcharacterSadPig then
		zitemLemon:MoveTo(zcharacterSadPig)
		zitemLemon.Visible = false
		zcharacterSadPig.Name = _O5Os("\076\044\066\014\108\045\029\021\108\014\079\037\008\021\108\027\014\029\040")
		zcharacterSadPig.Media = zmediaHappyPig
		zitemLemon.Commands.Give.Enabled = false
		ztaskCurlthePigsTail.Complete = true
		PigChat = _O5Os("\102")
		ZooChat = _O5Os("\092\052")
		_Urwigo.OldDialog{
			{
				Text = _O5Os("\062\012\029\014\014\014\009\037\100\037\019\029\014\037\029\079\112\037\079\018\012\014\044\099\037\095\018\037\044\029\040\086\014\045\112\037\079\029\021\108\037\124\014\029\040\037\008\021\108\027\018\014\040\047\021\108\014\040\028\118\005\003\033\118\005\003\033\020\029\014\045\014\040\037\095\018\040\009\037\038\012\014\044\037\019\014\029\040\014\037\096\029\045\038\014\059\037\101\014\112\047\112\037\086\014\108\112\037\014\079\037\124\029\044\037\027\029\014\019\014\044\037\039\029\014\045\037\087\014\079\079\014\044\028"), 
				Media = zmediaHappyPig_MSG
			}, 
			{
				Text = _O5Os("\095\014\044\037\087\045\066\019\014\037\113\029\040\086\012\029\040\059\037\040\018\021\108\037\019\014\124\037\019\012\037\079\012\021\108\079\112\059\037\039\014\044\079\112\014\021\009\112\037\079\029\021\108\037\087\014\029\037\019\014\040\037\024\066\044\079\018\009\079\059\037\012\124\037\124\029\112\037\029\108\040\014\040\037\107\014\087\012\044\112\079\112\018\086\037\039\066\040\037\029\108\044\014\124\037\008\112\018\124\124\014\079\018\014\045\112\014\079\112\014\040\037\047\012\037\038\014\029\014\044\040\028"), 
				Media = zmediaHappyPig_MSG
			}, 
			{
				Text = _O5Os("\076\029\040\019\014\037\108\014\044\018\012\079\059\037\027\014\045\021\108\014\037\076\018\108\044\047\014\012\086\014\037\108\029\014\044\037\079\112\014\108\014\040\037\012\040\019\037\009\066\124\124\037\019\018\040\040\037\027\029\014\019\014\044\037\047\012\037\124\029\044\037\012\040\019\037\014\044\047\018\014\108\045\014\037\014\079\037\124\029\044\028"), 
				Media = zmediaHappyPig_MSG
			}
		}
	end
end
function zitemLemon:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\029\014\037\006\029\112\044\066\040\014\037\029\079\112\037\079\012\014\079\079\100\079\018\012\014\044\059\037\087\044\044\044\044\028\028\028\028\028"), 
		Media = zmediaLemon_MSG
	}
end
function zitemKokothePenguin:OnTake(target)
	zitemKokothePenguin:MoveTo(Player)
	zitemKokothePenguin.Commands.Take.Enabled = false
	ZooChat = _O5Os("\102\052")
	PenguinCount = _O5Os("\092")
	ztaskHelpRoundUpthePenguins.Description = (_O5Os("\095\012\037\124\012\079\079\112\037\101\014\112\047\112\037\040\066\021\108\037")..PenguinCount).._O5Os("\037\113\029\040\086\012\029\040\014\037\038\029\040\019\014\040\028")
	ztaskVisittheAfricanSavanna.Visible = true
	ztaskVisittheAfricanSavanna.Active = true
	zoneAfricanSavanna.Visible = true
	zoneAfricanSavanna.Active = true
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\036\014\012\014\044\037\113\029\040\086\012\029\040\037\124\029\112\086\014\040\066\124\124\014\040\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\024\066\009\066\037\019\014\044\037\113\029\040\086\012\029\040"), 
			Media = zmediaKokothePenguin_MSG
		}, 
		{
			Text = _O5Os("\107\044\066\079\079\018\044\112\029\086\099\118\005\003\033\120\014\112\047\112\059\037\019\018\037\029\124\037\085\038\038\014\040\108\018\012\079\037\018\045\045\014\037\086\014\044\014\086\014\045\112\037\029\079\112\059\037\045\018\079\079\037\012\040\079\037\029\040\037\019\029\014\037\085\038\044\029\009\018\040\029\079\021\108\014\037\008\018\039\018\040\040\014\037\086\014\108\014\040\059\037\012\124\037\019\066\044\112\037\040\018\021\108\037\019\014\124\037\040\018\014\021\108\079\112\014\040\037\113\029\040\086\012\029\040\037\047\012\037\079\012\021\108\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\037\005\014\079\012\021\108\014\037\019\029\014\037\085\038\044\029\009\018\040\029\079\021\108\014\037\008\018\039\018\040\040\014\028\118\005\003\033\008\021\108\018\012\037\018\012\038\037\019\029\014\037\024\018\044\112\014\037\066\019\014\044\037\047\012\037\019\014\040\037\110\078\066\021\018\112\029\066\040\079\110\037\012\124\037\108\029\040\037\047\012\037\086\014\045\018\040\086\014\040\028"), 
			Media = zmediaZoneAfrica
		}
	}
	PenguinVariable = PenguinVariable + 1
end
function zitemKokothePenguin:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\029\014\079\014\044\037\113\029\040\086\012\029\040\037\079\021\108\045\014\109\109\112\037\113\018\109\029\014\044\037\012\040\019\037\117\018\045\079\112\029\038\112\014\037\124\029\112\037\079\029\021\108\037\044\012\124\028"), 
		Media = zmediaKokothePenguin_MSG
	}
end
function zitemEgg:OnTake(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\107\018\021\009\059\037\086\018\021\009\059\037\086\018\021\009\099\118\005\003\033\076\029\040\086\014\044\037\027\014\086\037\039\066\040\037\124\014\029\040\014\124\037\122\029\099"), 
		Media = zmediaHen_MSG
	}
end
function zitemEgg:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\018\079\037\029\079\112\037\014\029\040\037\045\014\021\009\014\044\014\079\037\096\012\014\108\040\014\044\014\029\028"), 
		Media = zmediaEgg_MSG
	}
end
function zitemBrianthePenguin:OnTake(target)
	zitemBrianthePenguin:MoveTo(Player)
	zitemBrianthePenguin.Commands.Take.Enabled = false
	ZooChat = _O5Os("\092\092")
	PenguinCount = _O5Os("\052")
	ztaskVisittheTropicalRainForest.Visible = true
	ztaskVisittheTropicalRainForest.Active = true
	zoneTropicalRainForest.Visible = true
	zoneTropicalRainForest.Active = true
	ztaskHelpRoundUpthePenguins.Description = (_O5Os("\095\012\037\124\012\079\079\112\037\040\066\021\108\037")..PenguinCount).._O5Os("\037\113\029\040\086\012\029\040\014\037\038\029\040\019\014\040\028")
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\036\014\012\014\044\037\107\014\086\014\040\079\112\018\040\019\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\005\018\021\014\045\045\014\037\019\014\044\037\113\029\040\086\012\029\040"), 
			Media = zmediaBrianthePenguin_MSG
		}, 
		{
			Text = _O5Os("\107\012\112\014\037\085\044\087\014\029\112\099\037\078\018\079\079\037\012\040\079\037\040\012\040\037\029\040\037\019\014\040\037\085\038\038\014\040\109\018\044\009\037\086\014\108\014\040\059\037\012\124\037\019\014\040\037\045\014\112\047\112\014\040\037\113\029\040\086\012\029\040\037\047\012\037\038\018\040\086\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\037\107\014\108\037\029\040\037\019\014\040\037\085\038\038\014\040\109\018\044\009\099\118\005\003\033\008\021\108\018\012\037\018\012\038\037\019\029\014\037\024\018\044\112\014\037\012\040\019\037\047\012\037\019\014\040\037\110\078\066\021\018\112\029\066\040\079\110\037\012\124\037\019\066\044\112\108\029\040\037\047\012\037\038\029\040\019\014\040\028"), 
			Media = zmediaZoneRainForest
		}
	}
	PenguinVariable = PenguinVariable + 1
end
function zitemBrianthePenguin:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\060\108\059\037\019\014\044\037\029\079\112\037\018\087\014\044\037\014\044\079\112\018\012\040\045\029\021\108\037\045\014\029\079\014\037\012\040\019\037\047\012\044\012\014\021\009\108\018\045\112\014\040\019\028\037\060\087\037\019\014\044\037\027\066\108\045\037\014\029\040\014\037\076\044\014\021\108\108\014\029\112\037\109\045\018\040\112\010"), 
		Media = zmediaBrianthePenguin_MSG
	}
end
function zitemJaredthePenguin:OnTake(target)
	zitemJaredthePenguin:MoveTo(Player)
	zitemJaredthePenguin.Commands.Take.Enabled = false
	ztaskHelpRoundUpthePenguins.Name = _O5Os("\005\044\029\040\086\037\019\029\014\037\113\029\040\086\012\029\040\014\037\047\012\124\037\113\066\066\045\037\047\012\044\012\014\021\009\099")
	ztaskHelpRoundUpthePenguins.Description = _O5Os("\095\012\037\108\018\079\112\037\018\045\045\014\037\113\029\040\086\012\029\040\014\037\014\029\040\086\014\038\018\040\086\014\040\099")
	PenguinCount = _O5Os("\119")
	ZooChat = _O5Os("\092\070")
	ztaskVisitthePenguinPool.Complete = false
	zonePenguinPool.Visible = true
	zonePenguinPool.Active = true
	_Urwigo.OldDialog{
		{
			Text = _O5Os("\036\014\012\014\044\037\107\014\086\014\040\079\112\018\040\019\035\118\005\003\033\037\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\048\040\087\079\109\069\100\037\120\066\009\066\037\019\014\044\037\113\029\040\086\012\029\040"), 
			Media = zmediaJaredthePenguin_MSG
		}, 
		{
			Text = _O5Os("\024\045\018\079\079\014\099\037\120\014\112\047\112\059\037\019\018\037\018\045\045\014\037\113\029\040\086\012\029\040\014\037\014\029\040\086\014\038\018\040\086\014\040\037\079\029\040\019\059\037\029\079\112\037\014\079\037\006\014\029\112\059\037\079\029\014\037\047\012\124\037\113\066\066\045\037\047\012\044\012\014\021\009\037\047\012\037\087\044\029\040\086\014\040\028"), 
			Media = zmediaZookeeper_MSG
		}, 
		{
			Text = _O5Os("\036\014\012\014\037\085\012\038\086\018\087\014\035\037\107\014\108\014\037\027\029\014\019\014\044\037\047\012\124\037\113\029\040\086\012\029\040\087\014\021\009\014\040\028"), 
			Media = zmediaZonePenguinPool
		}
	}
	PenguinVariable = PenguinVariable + 1
end
function zitemJaredthePenguin:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\029\014\079\014\044\037\113\029\040\086\012\029\040\037\029\079\112\037\019\014\044\037\107\044\066\014\079\079\112\014\037\039\066\040\037\018\045\045\014\040\099"), 
		Media = zmediaJaredthePenguin_MSG
	}
end
function zitemShampoo:OnUseWith(target)
	GorillaChat = _O5Os("\102")
	ZooChat = _O5Os("\092\032")
	zitemShampoo:MoveTo(zcharacterSilverbackGorilla)
	zitemShampoo.Visible = false
	zitemJaredthePenguin:MoveTo(zoneTropicalRainForest)
	zcharacterSilverbackGorilla.Media = zmediaSilverBackGorilla
	zcharacterSilverbackGorilla.Name = _O5Os("\076\044\066\014\108\045\029\021\108\014\044\037\107\066\044\029\045\045\018")
	zitemShampoo.Commands.UseWith.Enabled = false
	_Urwigo.MessageBox{
		Text = _O5Os("\060\108\059\037\039\029\014\045\014\040\037\095\018\040\009\059\037\124\014\029\040\037\079\029\045\087\014\044\040\014\079\037\096\018\018\044\037\029\079\112\037\079\021\108\066\014\040\014\044\037\018\045\079\037\101\014\037\047\012\039\066\044\028\118\005\003\033\118\005\003\033\120\014\112\047\112\037\038\018\040\086\037\029\021\108\037\019\014\040\037\104\014\087\014\045\112\018\014\112\014\044\037\014\029\040\037\100\037\019\018\124\029\112\037\019\012\037\029\108\040\037\027\029\014\019\014\044\037\029\040\037\079\014\029\040\037\005\014\021\009\014\040\037\047\012\044\012\014\021\009\037\087\044\029\040\086\014\040\037\009\018\040\040\079\112\028"), 
		Media = zmediaSilverBackGorilla_MSG
	}
end
function zitemShampoo:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\076\012\044\037\014\124\109\038\029\040\019\045\029\021\108\014\037\096\018\012\112"), 
		Media = zmediaShampoo_MSG
	}
end
function zitemCake:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _O5Os("\095\014\044\037\079\029\014\108\112\037\018\087\014\044\037\045\014\021\009\014\044\037\018\012\079\099"), 
		Media = zmediaCake_MSG
	}
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return cartZooventurePenguinEscape
