require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartPrimitiveCompassNavigation = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartPrimitiveCompassNavigation.MsgBoxCBFuncs = {}

zmediaShip = Wherigo.ZMedia(cartPrimitiveCompassNavigation)
zmediaShip.Name="Ship"
zmediaShip.Description=""
zmediaShip.AltText=""
zmediaShip.Id="5c3f44e3-2488-418b-9ff1-2baf1fcdf38a"
zmediaShip.Resources = {
{ Type = "jpg", Filename = "Ship.jpg", Directives = {},},
}
zmediaTelescope1 = Wherigo.ZMedia(cartPrimitiveCompassNavigation)
zmediaTelescope1.Name="Telescope1"
zmediaTelescope1.Description=""
zmediaTelescope1.AltText=""
zmediaTelescope1.Id="7129aebd-4901-4c97-97ef-0289b0243275"
zmediaTelescope1.Resources = {
{ Type = "jpg", Filename = "Telescope1.jpg", Directives = {},},
}
zmediaTelescope2 = Wherigo.ZMedia(cartPrimitiveCompassNavigation)
zmediaTelescope2.Name="Telescope2"
zmediaTelescope2.Description=""
zmediaTelescope2.AltText=""
zmediaTelescope2.Id="3662612b-e3ea-45e8-ab25-9cd23100a97a"
zmediaTelescope2.Resources = {
{ Type = "jpg", Filename = "Telescope2.jpg", Directives = {},},
}
zmediaTelescope3 = Wherigo.ZMedia(cartPrimitiveCompassNavigation)
zmediaTelescope3.Name="Telescope3"
zmediaTelescope3.Description=""
zmediaTelescope3.AltText=""
zmediaTelescope3.Id="3e198d8e-bdd8-4381-becb-716fcd97beb6"
zmediaTelescope3.Resources = {
{ Type = "jpg", Filename = "Telescope3.jpg", Directives = {},},
}
zmediaCompass = Wherigo.ZMedia(cartPrimitiveCompassNavigation)
zmediaCompass.Name="Compass"
zmediaCompass.Description=""
zmediaCompass.AltText=""
zmediaCompass.Id="62d8d961-66d6-40c8-aa35-2bd385ec8474"
zmediaCompass.Resources = {
{ Type = "jpg", Filename = "Compass.jpg", Directives = {},},
}
zmediaMark = Wherigo.ZMedia(cartPrimitiveCompassNavigation)
zmediaMark.Name="Mark"
zmediaMark.Description=""
zmediaMark.AltText=""
zmediaMark.Id="4d52cf51-a615-4b7a-9c7f-c3ceb1dbffed"
zmediaMark.Resources = {
{ Type = "jpg", Filename = "Mark.jpg", Directives = {},},
}
-- Cartridge Info --
cartPrimitiveCompassNavigation.Id="b5987c60-56c3-41c6-84f7-e2c1ba59f8ea"
cartPrimitiveCompassNavigation.Name="PrimitiveCompassNavigation"
cartPrimitiveCompassNavigation.Description=[[This cartridge demonstrate the primitive compass navigation.


In few hundreds years ago, many people went sea, and tried to find a new world.

Of course they didn't have GPS system. But they had skill to find location.

The compass navigation is one of method to find the location, and it is still important method for navigation using simple tool.

Using this cartridge, you can demonstrate one of the compass navigation to return to the original point.
 
After starting the cartridge before walking, try to find and record some marker direction. These are the keys to identify the current location.
Then please walk at least 100 meters away.
After walking, try to return the original point with compass without GPS.
When you can return within 10 meters to original point, you will complete the cartridge.

The proper original location is, 
- open area at least 100 meters in one direction
- some markers (top of hill, monument, playground equipment, etc) can be found not to far (too difficult) and not to close (too easy). (Markers approximately 50 meters away are recommended.)
- Less texture on the ground surface to avoid spoil when you return and find the original point. 


This cartridge is suitable for compass navigation skill training.]]
cartPrimitiveCompassNavigation.Visible=true
cartPrimitiveCompassNavigation.Activity="Puzzle"
cartPrimitiveCompassNavigation.StartingLocationDescription=[[Anywhere in the world, at least 100 meters in one direction.]]
cartPrimitiveCompassNavigation.StartingLocation = Wherigo.INVALID_ZONEPOINT
cartPrimitiveCompassNavigation.Version=""
cartPrimitiveCompassNavigation.Company=""
cartPrimitiveCompassNavigation.Author=""
cartPrimitiveCompassNavigation.BuilderVersion="2.0.4927.3981"
cartPrimitiveCompassNavigation.CreateDate="4/12/2008 6:42:54 PM"
cartPrimitiveCompassNavigation.PublishDate="1/1/0001 12:00:00 AM"
cartPrimitiveCompassNavigation.UpdateDate="4/12/2008 8:45:45 PM"
cartPrimitiveCompassNavigation.LastPlayedDate="1/1/0001 12:00:00 AM"
cartPrimitiveCompassNavigation.TargetDevice="PocketPC"
cartPrimitiveCompassNavigation.TargetDeviceVersion="0"
cartPrimitiveCompassNavigation.StateId="1"
cartPrimitiveCompassNavigation.CountryId="2"
cartPrimitiveCompassNavigation.Complete=false
cartPrimitiveCompassNavigation.UseLogging=true

-- Zones --

-- Characters --

-- Items --
zitemMarker1 = Wherigo.ZItem(cartPrimitiveCompassNavigation)
zitemMarker1.Id="a854195c-0603-472f-b6b6-9112834b47e4"
zitemMarker1.Name="Marker1"
zitemMarker1.Description=[[marker1]]
zitemMarker1.Visible=true
zitemMarker1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemMarker1.Media=zmediaTelescope1
zitemMarker1.Locked = false
zitemMarker1.Opened = false
zitemMarker1.Commands = {
  ChangeName = Wherigo.ZCommand{Text="ChangeName", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  AddDirection = Wherigo.ZCommand{Text="AddDirection", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemMarker1.Commands.ChangeName.Custom = true
zitemMarker1.Commands.ChangeName.Id="c75c7aaa-94a2-45b5-ba86-f99dc7a0d8bb"
zitemMarker1.Commands.ChangeName.WorksWithAll = true
zitemMarker1.Commands.AddDirection.Custom = true
zitemMarker1.Commands.AddDirection.Id="12fd8f1f-9c0e-40e8-999e-8227abc62903"
zitemMarker1.Commands.AddDirection.WorksWithAll = true

zitemMarker2 = Wherigo.ZItem(cartPrimitiveCompassNavigation)
zitemMarker2.Id="ce6b21c1-a4b9-46e0-8108-4b5655431b25"
zitemMarker2.Name="Marker2"
zitemMarker2.Description=[[marker2]]
zitemMarker2.Visible=true
zitemMarker2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemMarker2.Media=zmediaTelescope2
zitemMarker2.Locked = false
zitemMarker2.Opened = false
zitemMarker2.Commands = {
  ChangeName = Wherigo.ZCommand{Text="ChangeName", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  AddDirection = Wherigo.ZCommand{Text="AddDirection", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemMarker2.Commands.ChangeName.Custom = true
zitemMarker2.Commands.ChangeName.Id="54b44b7c-12b8-43ad-a943-6efa1e5aee15"
zitemMarker2.Commands.ChangeName.WorksWithAll = true
zitemMarker2.Commands.AddDirection.Custom = true
zitemMarker2.Commands.AddDirection.Id="9731951a-3162-42de-ae93-2a687076f7f4"
zitemMarker2.Commands.AddDirection.WorksWithAll = true

zitemMarker3 = Wherigo.ZItem(cartPrimitiveCompassNavigation)
zitemMarker3.Id="8ed5fe41-8557-4e26-b99b-5f7269e795ac"
zitemMarker3.Name="Marker3"
zitemMarker3.Description=[[marker3]]
zitemMarker3.Visible=true
zitemMarker3.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemMarker3.Media=zmediaTelescope3
zitemMarker3.Locked = false
zitemMarker3.Opened = false
zitemMarker3.Commands = {
  ChangeName = Wherigo.ZCommand{Text="ChangeName", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  AddDirection = Wherigo.ZCommand{Text="AddDirection", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemMarker3.Commands.ChangeName.Custom = true
zitemMarker3.Commands.ChangeName.Id="1fbba74a-f53b-48d0-9bbf-15144302addc"
zitemMarker3.Commands.ChangeName.WorksWithAll = true
zitemMarker3.Commands.AddDirection.Custom = true
zitemMarker3.Commands.AddDirection.Id="ee60e8c8-1153-4558-aa6b-8d4048f9bf71"
zitemMarker3.Commands.AddDirection.WorksWithAll = true

zitemInstructionAwayPoint = Wherigo.ZItem(cartPrimitiveCompassNavigation)
zitemInstructionAwayPoint.Id="2ef5737f-355c-4a3c-bc5a-dd43d8660089"
zitemInstructionAwayPoint.Name="InstructionAwayPoint"
zitemInstructionAwayPoint.Description=[[Press "Instruction" button for detail procedure to return the original point.
After you returned to original point, press "Returned" button.]]
zitemInstructionAwayPoint.Visible=false
zitemInstructionAwayPoint.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemInstructionAwayPoint.Locked = false
zitemInstructionAwayPoint.Opened = false
zitemInstructionAwayPoint.Commands = {
  Instruction = Wherigo.ZCommand{Text="Instruction", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Returned = Wherigo.ZCommand{Text="Returned", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zitemInstructionAwayPoint.Commands.Instruction.Custom = true
zitemInstructionAwayPoint.Commands.Instruction.Id="be618e8e-32fc-4d49-bbc6-1cd4517b5d53"
zitemInstructionAwayPoint.Commands.Instruction.WorksWithAll = true
zitemInstructionAwayPoint.Commands.Returned.Custom = true
zitemInstructionAwayPoint.Commands.Returned.Id="8b99f069-2427-4111-adb9-75b6b15328b1"
zitemInstructionAwayPoint.Commands.Returned.WorksWithAll = true

zitemCompCode = Wherigo.ZItem(cartPrimitiveCompassNavigation)
zitemCompCode.Id="ad3ce1ce-706e-462e-a3ec-06e973c318db"
zitemCompCode.Name="CompCode"
zitemCompCode.Description=[[]]
zitemCompCode.Visible=true
zitemCompCode.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemCompCode.Locked = false
zitemCompCode.Opened = false
zitemCompCode.Commands = {
}

zitemInstructionStartPoint = Wherigo.ZItem(cartPrimitiveCompassNavigation)
zitemInstructionStartPoint.Id="3c113236-7086-429a-a6bf-01de4544c581"
zitemInstructionStartPoint.Name="InstructionStartPoint"
zitemInstructionStartPoint.Description=[[Before walking please record the markers direction to identify the location. Press "Instruction" button for detail procedure. After record markers direction, please press "Recorded" button.]]
zitemInstructionStartPoint.Visible=true
zitemInstructionStartPoint.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemInstructionStartPoint.Locked = false
zitemInstructionStartPoint.Opened = false
zitemInstructionStartPoint.Commands = {
  Instruction = Wherigo.ZCommand{Text="Instruction", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Recorded = Wherigo.ZCommand{Text="Recorded", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zitemInstructionStartPoint.Commands.Instruction.Custom = true
zitemInstructionStartPoint.Commands.Instruction.Id="ddc0806b-bd07-4d3a-95e3-ba99a1e43d14"
zitemInstructionStartPoint.Commands.Instruction.WorksWithAll = true
zitemInstructionStartPoint.Commands.Recorded.Custom = true
zitemInstructionStartPoint.Commands.Recorded.Id="bfcad76b-6244-4e98-923b-423ef2785539"
zitemInstructionStartPoint.Commands.Recorded.WorksWithAll = true

-- Tasks --
ztaskWalk100MetersAway = Wherigo.ZTask(cartPrimitiveCompassNavigation)
ztaskWalk100MetersAway.Id="c7d4049d-07d1-4051-8a0c-f25967f1785d"
ztaskWalk100MetersAway.Name="Walk100MetersAway"
ztaskWalk100MetersAway.Description=[[Walk 100 meters away from the Original Point in any direction.]]
ztaskWalk100MetersAway.Visible=false
ztaskWalk100MetersAway.Active=true
ztaskWalk100MetersAway.Complete=false
ztaskWalk100MetersAway.CorrectState = "None"

ztaskReturnOriginal = Wherigo.ZTask(cartPrimitiveCompassNavigation)
ztaskReturnOriginal.Id="4fc764cd-aa40-41e2-a5ad-ef9cf4e08db8"
ztaskReturnOriginal.Name="ReturnOriginal"
ztaskReturnOriginal.Description=[[Return to Original Point.
Zone is not displayed. So, you should find it using compass.
Please try to go the point where the markers can be seen in the same directions you recorded.]]
ztaskReturnOriginal.Visible=false
ztaskReturnOriginal.Active=true
ztaskReturnOriginal.Complete=false
ztaskReturnOriginal.CorrectState = "None"

ztaskIdentifyOriginal = Wherigo.ZTask(cartPrimitiveCompassNavigation)
ztaskIdentifyOriginal.Id="19013353-0b00-4121-a01a-03df85e48d51"
ztaskIdentifyOriginal.Name="IdentifyOriginal"
ztaskIdentifyOriginal.Description=[[Before walking, try to find and record some marker direction. These are the keys to identify the current location]]
ztaskIdentifyOriginal.Visible=true
ztaskIdentifyOriginal.Active=true
ztaskIdentifyOriginal.Complete=false
ztaskIdentifyOriginal.CorrectState = "None"

-- Cartridge Variables --
NameMarker2 = "Marker2"
Angle1 = 0
Angle2 = 0
Angle3 = 0
NameMarker1 = "Marker1"
NameMarker3 = "Marker3"
cartPrimitiveCompassNavigation.ZVariables = {NameMarker2 = "Marker2", Angle1 = 0, Angle2 = 0, Angle3 = 0, NameMarker1 = "Marker1", NameMarker3 = "Marker3"}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.NameMarker2 = {}
buildervar.NameMarker2.Id ="53a655ae-be9c-4ef6-a92c-eabff4527fdc"
buildervar.NameMarker2.Name = "NameMarker2"
buildervar.NameMarker2.Type = "String"
buildervar.NameMarker2.Data=[[Marker2]]
buildervar.NameMarker2.Description=[[]]

buildervar.Angle1 = {}
buildervar.Angle1.Id ="72642820-2846-4d9d-b07b-940afcb0bacf"
buildervar.Angle1.Name = "Angle1"
buildervar.Angle1.Type = "Number"
buildervar.Angle1.Data=[[0]]
buildervar.Angle1.Description=[[]]

buildervar.Angle2 = {}
buildervar.Angle2.Id ="c93390c7-a5c9-4953-807c-5979c50f6278"
buildervar.Angle2.Name = "Angle2"
buildervar.Angle2.Type = "Number"
buildervar.Angle2.Data=[[0]]
buildervar.Angle2.Description=[[]]

buildervar.Angle3 = {}
buildervar.Angle3.Id ="670cf2e7-f4dd-4402-aabe-0747b7e5842f"
buildervar.Angle3.Name = "Angle3"
buildervar.Angle3.Type = "Number"
buildervar.Angle3.Data=[[0]]
buildervar.Angle3.Description=[[]]

buildervar.NameMarker1 = {}
buildervar.NameMarker1.Id ="cc85c335-25bb-48db-abef-272d148c1aa5"
buildervar.NameMarker1.Name = "NameMarker1"
buildervar.NameMarker1.Type = "String"
buildervar.NameMarker1.Data=[[Marker1]]
buildervar.NameMarker1.Description=[[]]

buildervar.NameMarker3 = {}
buildervar.NameMarker3.Id ="70ae0433-4bd6-4cb4-988b-497dc342c718"
buildervar.NameMarker3.Name = "NameMarker3"
buildervar.NameMarker3.Type = "String"
buildervar.NameMarker3.Data=[[Marker3]]
buildervar.NameMarker3.Description=[[]]


-- ZTimers --
ztimerTwoSecondsTimer = Wherigo.ZTimer(cartPrimitiveCompassNavigation)
ztimerTwoSecondsTimer.Id="509b4a51-8f0d-423e-bf3f-89660e55add3"
ztimerTwoSecondsTimer.Name="TwoSecondsTimer"
ztimerTwoSecondsTimer.Description=[[]]
ztimerTwoSecondsTimer.Visible=true
ztimerTwoSecondsTimer.Duration=2
ztimerTwoSecondsTimer.Type="Countdown"

-- Inputs --
zinputDirAngle1 = Wherigo.ZInput(cartPrimitiveCompassNavigation)
zinputDirAngle1.Id="45923ec2-aab1-490f-907e-16c69f629b99"
zinputDirAngle1.Name="DirAngle1"
zinputDirAngle1.Description=[[direction1]]
zinputDirAngle1.Visible=true
zinputDirAngle1.InputType="Text"
zinputDirAngle1.InputVariableId="72642820-2846-4d9d-b07b-940afcb0bacf"
zinputDirAngle1.Text=[[Please input the direction for Marker1]]

zinputNameStr1 = Wherigo.ZInput(cartPrimitiveCompassNavigation)
zinputNameStr1.Id="c6987162-258e-4484-b34a-3a34e45f28a5"
zinputNameStr1.Name="NameStr1"
zinputNameStr1.Description=[[name1]]
zinputNameStr1.Visible=true
zinputNameStr1.InputType="Text"
zinputNameStr1.InputVariableId="cc85c335-25bb-48db-abef-272d148c1aa5"
zinputNameStr1.Text=[[Please input the name for Marker1]]

zinputDirAngle2 = Wherigo.ZInput(cartPrimitiveCompassNavigation)
zinputDirAngle2.Id="0219c7c0-fac9-4a1a-96a4-7b7094505cc7"
zinputDirAngle2.Name="DirAngle2"
zinputDirAngle2.Description=[[direction2]]
zinputDirAngle2.Visible=true
zinputDirAngle2.InputType="Text"
zinputDirAngle2.InputVariableId="c93390c7-a5c9-4953-807c-5979c50f6278"
zinputDirAngle2.Text=[[Please input the direction for Marker2]]

zinputDirAngle3 = Wherigo.ZInput(cartPrimitiveCompassNavigation)
zinputDirAngle3.Id="7d1d5ee2-bf2a-4ed3-bd6b-6e19af8489c3"
zinputDirAngle3.Name="DirAngle3"
zinputDirAngle3.Description=[[direction3]]
zinputDirAngle3.Visible=true
zinputDirAngle3.InputType="Text"
zinputDirAngle3.InputVariableId="670cf2e7-f4dd-4402-aabe-0747b7e5842f"
zinputDirAngle3.Text=[[Please input the direction for Marker3]]

zinputNameStr2 = Wherigo.ZInput(cartPrimitiveCompassNavigation)
zinputNameStr2.Id="900fc68b-92d8-4177-bf94-0ad31f1da4f9"
zinputNameStr2.Name="NameStr2"
zinputNameStr2.Description=[[name2]]
zinputNameStr2.Visible=true
zinputNameStr2.InputType="Text"
zinputNameStr2.InputVariableId="53a655ae-be9c-4ef6-a92c-eabff4527fdc"
zinputNameStr2.Text=[[Please input the name for Marker2]]

zinputNameStr3 = Wherigo.ZInput(cartPrimitiveCompassNavigation)
zinputNameStr3.Id="b72fea95-7482-4e5b-829b-cb1371bb66e1"
zinputNameStr3.Name="NameStr3"
zinputNameStr3.Description=[[name3]]
zinputNameStr3.Visible=true
zinputNameStr3.InputType="Text"
zinputNameStr3.InputVariableId="70ae0433-4bd6-4cb4-988b-497dc342c718"
zinputNameStr3.Text=[[Please input the name for Marker3]]

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function zitemInstructionStartPoint:OnInstruction()
-- #GroupDescription=instruction --
-- #Comment=instruction Comment --
if Player.PositionAccuracy:GetValue('m')>0 and Player.PositionAccuracy:GetValue('m')<50 then
ztimerTwoSecondsTimer:Start()
Wherigo.Dialog{{Text=[[(1) This cartridge demonstrate the primitive compass navigation.
In few hundreds years ago, many people went sea, and tried to find a new world.
Of course they didn't have GPS system. But they had skill to find location.
The compass navigation is one of method to find the location, and it is still important method for navigation using simple tool.
Using this cartridge, you can demonstrate one of the compass navigation to return to the original point.
]],Media=zmediaShip},{Text=[[(2) Please verify you are standing at the following point.
 - open area at least 100 meters in one direction
 - some markers (top of hill, monument, playground equipment, etc) can be found not to far (too difficult) and not to close (too easy).(Markers approximately 50 meters away are recommended.)
 - Less texture on the ground surface to avoid spoil when you return and find the original point. 
If not, find the location and restart the cartridge.]],},{Text=[[(3) Prepare compass. Suitable compass is a instrument with direction dial and smooth needle to indicate the magnetic north. 
Compass with direction-to-travel arrow helps to identify the location.]],Media=zmediaCompass},{Text=[[(4) Find and record the direction of markers. The clear objects such as top of hill, monument, playground equipment is suitable.
 a. Rotate the compass dial to align the needle (generally shown in red color) to "N" indication of the compass.
 b. Align the center of the compass dial in-line with you and the marker object. If the compass has direction-to-travel arrow, try to align the arrow.
 c. Read the direction of the dial to the marker.
 d. Record the marker direction. You can write into paper, and you can also use "Marker" Item in your cartridge inventory (To use marker is an optional and it is NOT necessary to complete this cartridge).
]],Media=zmediaMark},{Text=[[(5) Record at least two markers direction.
When you finish record, press "Recorded" button.]],},}
zitemInstructionStartPoint.Commands["Recorded"].Enabled = true
else
Wherigo.MessageBox{Text=[[Your GPS signal is not optimal. Try to moving around to get better reception.]],}
end

end

function zitemInstructionStartPoint:OnRecorded()
-- #GroupDescription=recorded --
-- #Comment=recorded Comment --
Wherigo.MessageBox{Text=[[Did you finish recording the markers direction?]],Buttons={"Yes","No",},Callback=cartPrimitiveCompassNavigation.MsgBoxCBFuncs.MsgBoxCB1}
end

function zitemMarker1:OnChangeName()
-- #GroupDescription=changeName --
-- #Comment=changeName Comment --
Wherigo.GetInput(zinputNameStr1)
end

function zitemMarker1:OnAddDirection()
-- #GroupDescription=addDirection --
-- #Comment=addDirection Comment --
Wherigo.GetInput(zinputDirAngle1)
end

function cartPrimitiveCompassNavigation:OnStart()
-- #GroupDescription=start --
-- #Comment=start Comment --
Wherigo.ShowScreen(Wherigo.TASKSCREEN)
zitemInstructionStartPoint:MoveTo(Player)
end

function zitemMarker2:OnChangeName()
-- #GroupDescription=changeName --
-- #Comment=changeName Comment --
Wherigo.GetInput(zinputNameStr2)
end

function zitemMarker2:OnAddDirection()
-- #GroupDescription=addDirection --
-- #Comment=addDirection Comment --
Wherigo.GetInput(zinputDirAngle2)
end

function zitemMarker3:OnChangeName()
-- #GroupDescription=changeName --
-- #Comment=changeName Comment --
Wherigo.GetInput(zinputNameStr3)
end

function zitemMarker3:OnAddDirection()
-- #GroupDescription=addDirection --
-- #Comment=addDirection Comment --
Wherigo.GetInput(zinputDirAngle3)
end

function zitemInstructionAwayPoint:OnInstruction()
-- #GroupDescription=instruction --
-- #Comment=instruction Comment --
Wherigo.Dialog{{Text=[[(1) Walk to return the original point where you can find the markers in the direction you recorded.
 You don't see the zone in your cartridge now. So, you should return to the point only using the compass.]],},{Text=[[(2) When you return to the original point, and confirm that you can see the marker in the right direction. Please push "Returned" button. If you are within 10 meters from the original point, you can complete this cartridge.]],},}
zoneOrigin.Visible = false
zitemInstructionAwayPoint.Commands["Returned"].Enabled = true
end

function zitemInstructionAwayPoint:OnReturned()
-- #GroupDescription=returned --
-- #Comment=returned Comment --
Wherigo.MessageBox{Text=[[Do you confirm that you can see the markers in the right direction, and you have returned to original point.]],Buttons={"Yes","No",},Callback=cartPrimitiveCompassNavigation.MsgBoxCBFuncs.MsgBoxCB2}
end

function zinputDirAngle1:OnGetInput(input)
Angle1 = tonumber(input)
-- #GroupDescription=input --
-- #Comment=input Comment --
zitemMarker1.Description = [[]] .. Angle1 .. [[ degree]]
Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemMarker1)
end

function zinputDirAngle2:OnGetInput(input)
Angle2 = tonumber(input)
-- #GroupDescription=input --
-- #Comment=input Comment --
zitemMarker2.Description = [[]] .. Angle2 .. [[ degree]]
Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemMarker2)
end

function zinputDirAngle3:OnGetInput(input)
Angle3 = tonumber(input)
-- #GroupDescription=input --
-- #Comment=input Comment --
zitemMarker3.Description = [[]] .. Angle3 .. [[ degree]]
Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemMarker3)
end

function zinputNameStr1:OnGetInput(input)
NameMarker1 = input
-- #GroupDescription=input --
-- #Comment=input Comment --
zitemMarker1.Name = NameMarker1
Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemMarker1)
end

function zinputNameStr2:OnGetInput(input)
NameMarker2 = input
-- #GroupDescription=input --
-- #Comment=input Comment --
zitemMarker2.Name = NameMarker2
Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemMarker2)
end

function zinputNameStr3:OnGetInput(input)
NameMarker3 = input
-- #GroupDescription=input --
-- #Comment=input Comment --
zitemMarker3.Name = NameMarker3
Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemMarker3)
end

function ztimerTwoSecondsTimer:OnTick()
-- #GroupDescription=tick --
-- #Comment=tick Comment --
zoneOrigin = GetNewZone(Player.ObjectLocation, 'Origin', 0, 0, 10)
zoneOrigin.Active = true
zoneOrigin.Visible = true
zitemMarker1:MoveTo(zoneOrigin)
zitemMarker2:MoveTo(zoneOrigin)
zitemMarker3:MoveTo(zoneOrigin)
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=5#--
cartPrimitiveCompassNavigation.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
if action ~= nil then
-- #GroupDescription=OkClicked --
-- #Comment=OkClicked Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
zitemInstructionStartPoint:MoveTo(nil)
end
end

cartPrimitiveCompassNavigation.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
-- #GroupDescription=selectButton --
-- #Comment=WhenButtonPressed --
if   action == "Button1" then
ztaskIdentifyOriginal.Complete = true
ztaskWalk100MetersAway.Visible = true
zitemMarker1:MoveTo(Player)
zitemMarker2:MoveTo(Player)
zitemMarker3:MoveTo(Player)
Wherigo.MessageBox{Text=[[Please walk at least 100 meters in any direction. After walking the next instruction will be shown.]],Buttons={"OK",},Callback=cartPrimitiveCompassNavigation.MsgBoxCBFuncs.MsgBoxCB3}
elseif action == "Button2" then
Wherigo.MessageBox{Text=[[Try to record the markers direction with following the instruction.]],}
end
end

cartPrimitiveCompassNavigation.MsgBoxCBFuncs.MsgBoxCB4 = function(action)
if action ~= nil then
-- #GroupDescription=OKClicked --
-- #Comment=OKClicked Comment --
Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemInstructionAwayPoint)
end
end

cartPrimitiveCompassNavigation.MsgBoxCBFuncs.MsgBoxCB5 = function(action)
if action ~= nil then
-- #GroupDescription=OKClicked --
-- #Comment=OKClicked Comment --
zitemInstructionAwayPoint:MoveTo(nil)
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartPrimitiveCompassNavigation.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
-- #GroupDescription=haveReturnedButton --
-- #Comment=haveReturnedButton Comment --
if   action == "Button1" and zoneOrigin:Contains(Player) then
cartPrimitiveCompassNavigation.Complete = true
cartPrimitiveCompassNavigation:RequestSync()
ztaskReturnOriginal.Complete = true
zitemCompCode:MoveTo(Player)
zitemCompCode.Description = [[Congratulations! Your Completion code is ]] .. Player.CompletionCode
Wherigo.MessageBox{Text=[[Congratulations! You have returned to original point and completed the cartridge. You may found that GPS is more easy and accurate method to find the location. But please remind the compass navigation is still one of the important method for many people (boat, divers and so on).
The photos are provided from PhotoLibrary http://www.photolibrary.jp/
Thank you for playing this cartridge! Your Completion Code is ]] .. Player.CompletionCode .. [[]],Buttons={"OK",},Callback=cartPrimitiveCompassNavigation.MsgBoxCBFuncs.MsgBoxCB5}
else
if   action == "Button1" and  not zoneOrigin:Contains(Player) then
Wherigo.MessageBox{Text=[[You are not at the original point. When you believe you are at the original point. Please push "Returned" button.]],}
end
if   action == "Button2" then
Wherigo.MessageBox{Text=[[When you believe you are at the original point. Please push "Returned" button.]],}
end
end
end

------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --


function GetNewZone(refPt, zoneName, distanceMeter, angle, radiusMeter)
  -- create a center point
  local dist = Wherigo.Distance(distanceMeter, "meters")
  local cenPt = Wherigo.TranslatePoint(refPt, dist, angle)
  -- create a list of zone points
  local pts = GetZonePoints(cenPt, radiusMeter)
  -- create the new zone
  local TempZone = Wherigo.Zone{
    Cartridge = cartPrimitiveCompassNavigation ,
    Name = zoneName ,
    OutOfRangeName = "" ,
    InRangeName = "" ,
    Description = [[]] ,
    Visible = false ,
    Active = false ,
    DistanceRange = Wherigo.Distance(90, "meters") ,
    ShowObjects = "OnEnter" ,
    ProximityRange = Wherigo.Distance(10, "meters") ,
    AllowSetPointTo = false ,
    Points = pts ,
  }
  function TempZone:OnNotInRange()
  -- #GroupDescription=notInRange --
  -- #Comment=notInRange Comment --
  ztaskWalk100MetersAway.Complete = true
  ztaskReturnOriginal.Visible = true
  zoneOrigin.Visible = false
  zitemInstructionStartPoint:MoveTo(nil)
  zitemInstructionAwayPoint:MoveTo(Player)
  zitemInstructionAwayPoint.Visible = true
  Wherigo.MessageBox{Text=[[OK. You have walked 100 meters. Now, please return to the original point using compass.]],Buttons={"OK",},Callback=cartPrimitiveCompassNavigation.MsgBoxCBFuncs.MsgBoxCB4}
  end
  
  function TempZone:OnExit()
  -- #GroupDescription=exit --
  -- #Comment=exit Comment --
   if ztaskIdentifyOriginal.Complete == false then
     Wherigo.MessageBox{Text=[[Are you sure to record markers? Please open item Instruction and push Recorded button]],}
   end
  end
  
  return TempZone
 end


function GetZonePoints(centerPt, radiusMeter)
  local radius = Wherigo.Distance(radiusMeter, 'm')
  local pts = {
    Wherigo.TranslatePoint(centerPt, radius, 22.5),
    Wherigo.TranslatePoint(centerPt, radius, 67.5),
    Wherigo.TranslatePoint(centerPt, radius, 112.5),
    Wherigo.TranslatePoint(centerPt, radius, 157.5),
    Wherigo.TranslatePoint(centerPt, radius, 202.5),
    Wherigo.TranslatePoint(centerPt, radius, 247.5),
    Wherigo.TranslatePoint(centerPt, radius, 292.5),
    Wherigo.TranslatePoint(centerPt, radius, 337.5),
  }
  return pts
end
-- #End Author Functions# --
-- Nothing after this line --
return cartPrimitiveCompassNavigation
