require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _O1AC(str)
	local res = ""
    local dtable = "\032\023\030\101\017\011\073\007\106\091\109\083\126\016\058\120\008\094\096\020\001\013\015\125\099\061\000\092\121\116\029\110\102\123\077\119\006\100\024\060\090\103\022\078\076\056\074\085\081\054\021\037\040\034\004\086\117\066\065\055\050\113\075\018\084\068\049\112\080\047\035\118\038\114\104\108\053\089\079\063\095\039\098\002\067\005\036\043\107\097\071\052\051\059\088\115\045\028\057\031\026\048\009\019\033\072\046\062\087\003\044\082\010\027\124\042\064\105\012\069\041\122\111\070\014\093\025"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

objInitiation = Wherigo.ZCartridge()

-- Media --
objJune = Wherigo.ZMedia(objInitiation)
objJune.Id = "64a713c1-bea8-4e6f-8616-502a5808a9e9"
objJune.Name = "June"
objJune.Description = "June"
objJune.AltText = ""
objJune.Resources = {
	{
		Type = "gif", 
		Filename = "NOARAPH.gif", 
		Directives = {}
	}
}
objicon_June = Wherigo.ZMedia(objInitiation)
objicon_June.Id = "9273e26f-e0fc-45d7-8219-b5a57ed0b7bf"
objicon_June.Name = "icon_June"
objicon_June.Description = "icon_June"
objicon_June.AltText = ""
objicon_June.Resources = {
	{
		Type = "jpg", 
		Filename = "NOARAPH3232.jpg", 
		Directives = {}
	}
}
objTresor = Wherigo.ZMedia(objInitiation)
objTresor.Id = "84c5532c-8d46-4d18-9305-e6efa4294a31"
objTresor.Name = "Tresor"
objTresor.Description = "tresor"
objTresor.AltText = ""
objTresor.Resources = {
	{
		Type = "png", 
		Filename = "Coffre300300.png", 
		Directives = {}
	}
}
objicon_tresor = Wherigo.ZMedia(objInitiation)
objicon_tresor.Id = "0b55449e-5503-46f0-b967-a1acd3553322"
objicon_tresor.Name = "icon_tresor"
objicon_tresor.Description = "icone tresor"
objicon_tresor.AltText = ""
objicon_tresor.Resources = {
	{
		Type = "png", 
		Filename = "IcoCoffre3232.png", 
		Directives = {}
	}
}
objBravo = Wherigo.ZMedia(objInitiation)
objBravo.Id = "4c278f54-cafe-4de3-8cbe-f87b4dee135a"
objBravo.Name = "Bravo"
objBravo.Description = "Bravo"
objBravo.AltText = ""
objBravo.Resources = {
	{
		Type = "jpg", 
		Filename = "bravo220220.jpg", 
		Directives = {}
	}
}
objicon_Bravo = Wherigo.ZMedia(objInitiation)
objicon_Bravo.Id = "874ca985-1cd3-43c7-b2e0-344a950823ca"
objicon_Bravo.Name = "icon_Bravo"
objicon_Bravo.Description = "icone Bravo"
objicon_Bravo.AltText = ""
objicon_Bravo.Resources = {
	{
		Type = "jpg", 
		Filename = "Iconbravo-32-32.jpg", 
		Directives = {}
	}
}
objposter = Wherigo.ZMedia(objInitiation)
objposter.Id = "f65f96f6-edab-4f54-9134-aba597d7733b"
objposter.Name = "poster"
objposter.Description = ""
objposter.AltText = ""
objposter.Resources = {
	{
		Type = "png", 
		Filename = "logo.png", 
		Directives = {}
	}
}
objicon = Wherigo.ZMedia(objInitiation)
objicon.Id = "0b30c872-e0b5-4f23-a547-425c019489c5"
objicon.Name = "icon"
objicon.Description = ""
objicon.AltText = ""
objicon.Resources = {
	{
		Type = "png", 
		Filename = "iconewherigo.png", 
		Directives = {}
	}
}
-- Cartridge Info --
objInitiation.Id="60534035-1f4f-456f-b5ab-f69766a70bcc"
objInitiation.Name="Initiation"
objInitiation.Description=[[Cartouche pour l event initiation wherigo realise par Team verturin et Zombi.dc]]
objInitiation.Visible=true
objInitiation.Activity="Geocache"
objInitiation.StartingLocationDescription=[[Cartouche pour l event initiation wherigo realise par Team verturin et Zombi.dc]]
objInitiation.StartingLocation = ZonePoint(48.6213333333333,2.56475,0)
objInitiation.Version="V1"
objInitiation.Company="Team Verturin et Zombi.dc"
objInitiation.Author="Team Verturin et Zombi.dc"
objInitiation.BuilderVersion="URWIGO 1.21.5528.18461"
objInitiation.CreateDate="03/01/2015 16:29:22"
objInitiation.PublishDate="1/1/0001 12:00:00 AM"
objInitiation.UpdateDate="03/05/2015 17:31:35"
objInitiation.LastPlayedDate="1/1/0001 12:00:00 AM"
objInitiation.TargetDevice="PocketPC"
objInitiation.TargetDeviceVersion="0"
objInitiation.StateId="1"
objInitiation.CountryId="2"
objInitiation.Complete=false
objInitiation.UseLogging=true

objInitiation.Media=objposter

objInitiation.Icon=objicon


-- Zones --
objMapremierezone = Wherigo.Zone(objInitiation)
objMapremierezone.Id = "1b77979c-a683-49a5-82f1-499ab18d1ac8"
objMapremierezone.Name = "Ma premiere zone"
objMapremierezone.Description = "La premiere zone de cette aventure"
objMapremierezone.Visible = true
objMapremierezone.Commands = {}
objMapremierezone.DistanceRange = Distance(-1, "feet")
objMapremierezone.ShowObjects = "OnEnter"
objMapremierezone.ProximityRange = Distance(60, "meters")
objMapremierezone.AllowSetPositionTo = false
objMapremierezone.Active = true
objMapremierezone.Points = {
	ZonePoint(48.6213654972257, 2.56449872951694, 0), 
	ZonePoint(48.621414242503, 2.56461233082566, 0), 
	ZonePoint(48.6213299263179, 2.56469803005853, 0), 
	ZonePoint(48.6212785460736, 2.56458841476069, 0)
}
objMapremierezone.OriginalPoint = ZonePoint(48.6213470530301, 2.56459937629046, 0)
objMapremierezone.DistanceRangeUOM = "Feet"
objMapremierezone.ProximityRangeUOM = "Meters"
objMapremierezone.OutOfRangeName = ""
objMapremierezone.InRangeName = ""
objZonequestion = Wherigo.Zone(objInitiation)
objZonequestion.Id = "812fbbed-5fa9-473b-aef2-1988cc607923"
objZonequestion.Name = "Zone question"
objZonequestion.Description = "Emplacement de la zone question"
objZonequestion.Visible = false
objZonequestion.Commands = {}
objZonequestion.DistanceRange = Distance(-1, "feet")
objZonequestion.ShowObjects = "OnEnter"
objZonequestion.ProximityRange = Distance(60, "meters")
objZonequestion.AllowSetPositionTo = false
objZonequestion.Active = false
objZonequestion.Points = {
	ZonePoint(48.6178217092593, 2.56854106637742, 0), 
	ZonePoint(48.6176677110602, 2.56871470865717, 0), 
	ZonePoint(48.6179001978173, 2.56937996504955, 0), 
	ZonePoint(48.618042503417, 2.56922406569716, 0)
}
objZonequestion.OriginalPoint = ZonePoint(48.6178580303885, 2.56896495144533, 0)
objZonequestion.DistanceRangeUOM = "Feet"
objZonequestion.ProximityRangeUOM = "Meters"
objZonequestion.OutOfRangeName = ""
objZonequestion.InRangeName = ""

-- Characters --
objJune1 = Wherigo.ZCharacter{
	Cartridge = objInitiation, 
	Container = objZonequestion
}
objJune1.Id = "96bef616-456b-43a5-ae69-f06ed3c8a7cf"
objJune1.Name = "June"
objJune1.Description = ""
objJune1.Visible = true
objJune1.Media = objJune
objJune1.Icon = objicon_June
objJune1.Commands = {
	cmdParler = Wherigo.ZCommand{
		Text = "Parler", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objJune1.Commands.cmdParler.Custom = true
objJune1.Commands.cmdParler.Id = "81ed044e-88ef-4187-8401-8846487c4479"
objJune1.Commands.cmdParler.WorksWithAll = true
objJune1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objJune1.Gender = "It"
objJune1.Type = "NPC"

-- Items --
objCompletionCode = Wherigo.ZItem(objInitiation)
objCompletionCode.Id = "454f1ba3-08b1-4e0a-b632-9608d64004de"
objCompletionCode.Name = "Completion Code"
objCompletionCode.Description = ""
objCompletionCode.Visible = true
objCompletionCode.Media = objBravo
objCompletionCode.Icon = objicon_Bravo
objCompletionCode.Commands = {}
objCompletionCode.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objCompletionCode.Locked = false
objCompletionCode.Opened = false
objSolution = Wherigo.ZItem(objInitiation)
objSolution.Id = "845955f6-54c7-458b-b626-e387a3f4685c"
objSolution.Name = "Solution"
objSolution.Description = [[N48 37.076 E002 34.151
Dans l'arbre]]
objSolution.Visible = true
objSolution.Media = objTresor
objSolution.Icon = objicon_tresor
objSolution.Commands = {}
objSolution.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objSolution.Locked = false
objSolution.Opened = false

-- Tasks --
objRejoindrelazonequestion = Wherigo.ZTask(objInitiation)
objRejoindrelazonequestion.Id = "238f6dde-4334-4306-9d21-ace8ffa420fd"
objRejoindrelazonequestion.Name = "Rejoindre la zone question"
objRejoindrelazonequestion.Description = "Rejoindre la zone question"
objRejoindrelazonequestion.Visible = true
objRejoindrelazonequestion.Active = false
objRejoindrelazonequestion.Complete = false
objRejoindrelazonequestion.CorrectState = "None"
objParleravecJune = Wherigo.ZTask(objInitiation)
objParleravecJune.Id = "57b115d1-4e74-46a4-aa60-ec0bd08fac7a"
objParleravecJune.Name = "Parler avec June"
objParleravecJune.Description = "Parler avec June"
objParleravecJune.Visible = true
objParleravecJune.Active = false
objParleravecJune.Complete = false
objParleravecJune.CorrectState = "None"

-- Cartridge Variables --
currentZone = "objMapremierezone"
currentCharacter = "objJune1"
currentItem = "objCompletionCode"
currentTask = "objRejoindrelazonequestion"
currentInput = "objQuestion"
currentTimer = "dummy"
objInitiation.ZVariables = {
	currentZone = "objMapremierezone", 
	currentCharacter = "objJune1", 
	currentItem = "objCompletionCode", 
	currentTask = "objRejoindrelazonequestion", 
	currentInput = "objQuestion", 
	currentTimer = "dummy"
}

-- Timers --

-- Inputs --
objQuestion = Wherigo.ZInput(objInitiation)
objQuestion.Id = "c6a976aa-0c2b-4e22-b9ac-f1770b460b34"
objQuestion.Name = "Question"
objQuestion.Description = "Question de la zone 2"
objQuestion.Visible = true
objQuestion.InputType = "Text"
objQuestion.Text = "Combien font 2 + 2"

-- WorksWithList for object commands --

-- functions --
function objInitiation:OnStart()
	_Urwigo.MessageBox{
		Text = [[Bonjour et bienvenu dans votre premiere cartouche.
Direction la zone 1]], 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, objMapremierezone)
			end
		end
	}
end
function objInitiation:OnRestore()
end
function objMapremierezone:OnEnter()
	currentZone = "objMapremierezone"
	_Urwigo.MessageBox{
		Text = "Bienvenu dans la zone 1, direction la zone question", 
		Callback = function(action)
			if action ~= nil then
				objZonequestion.Visible = true
				objZonequestion.Active = true
				objMapremierezone.Visible = false
				objMapremierezone.Active = false
				objRejoindrelazonequestion.Active = true
				objInitiation:RequestSync()
			end
		end
	}
end
function objZonequestion:OnEnter()
	currentZone = "objZonequestion"
	_Urwigo.MessageBox{
		Text = "Bravo pour avoir rejoint la zone question, allez voir June"
	}
	objParleravecJune.Active = true
	objRejoindrelazonequestion.Complete = true
end
function objQuestion:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 4 then
		_Urwigo.OldDialog{
			{
				Text = "Bravo c est la bonne reponse, vous etes un aventurier accompli! Je vous donne les coordonnes du tresor et le code de completion dans votre inventaire", 
				Media = objBravo
			}
		}
		objSolution:MoveTo(Player)
		objCompletionCode.Description = string.sub(Player.CompletionCode, 1, 15)
		objCompletionCode:MoveTo(Player)
	elseif input ~= 4 then
		_Urwigo.Dialog(false, {
			{
				Text = "Ce n est pas la bonne reponse, essayer encore!"
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(objQuestion)
			end)
		end)
	end
end
function objJune1:OncmdParler(target)
	objParleravecJune.Complete = true
	_Urwigo.Dialog(false, {
		{
			Text = "Maintenant un petit cacul"
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(objQuestion)
		end)
	end)
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return objInitiation
