require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _kXg0(str)
	local res = ""
    local dtable = "\086\021\085\045\093\003\103\023\063\112\061\052\054\037\027\016\115\108\080\090\007\113\114\107\071\053\068\028\051\088\043\057\011\047\049\102\101\042\069\079\105\012\075\117\025\031\020\119\094\091\032\055\081\095\018\008\072\100\120\099\087\109\048\092\070\073\026\078\024\060\121\039\004\074\005\056\124\122\062\029\084\022\015\077\116\110\076\019\064\000\123\126\059\098\010\014\104\033\017\002\082\035\009\125\046\036\038\040\111\106\097\030\013\041\050\034\067\006\118\044\065\058\089\083\066\096\001"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_U1Rd = Wherigo.ZCartridge()

-- Media --
-- Cartridge Info --
_U1Rd.Id="8b89e812-c63b-4889-8d6d-eac22fb48844"
_U1Rd.Name="Legends of Slaga"
_U1Rd.Description=[[]]
_U1Rd.Visible=true
_U1Rd.Activity="TourGuide"
_U1Rd.StartingLocationDescription=[[]]
_U1Rd.StartingLocation = ZonePoint(38.5747670527722,-90.3721221720477,0)
_U1Rd.Version=""
_U1Rd.Company=""
_U1Rd.Author=""
_U1Rd.BuilderVersion="URWIGO 1.21.5528.18461"
_U1Rd.CreateDate="11/05/2015 12:01:03"
_U1Rd.PublishDate="1/1/0001 12:00:00 AM"
_U1Rd.UpdateDate="11/06/2015 08:19:44"
_U1Rd.LastPlayedDate="1/1/0001 12:00:00 AM"
_U1Rd.TargetDevice="PocketPC"
_U1Rd.TargetDeviceVersion="0"
_U1Rd.StateId="1"
_U1Rd.CountryId="2"
_U1Rd.Complete=false
_U1Rd.UseLogging=true


-- Zones --
_AmX = Wherigo.Zone(_U1Rd)
_AmX.Id = "20430a37-68be-474b-a7e4-56362a44bbcd"
_AmX.Name = _kXg0("\065\041\086\111\018")
_AmX.Description = ""
_AmX.Visible = true
_AmX.Commands = {}
_AmX.DistanceRange = Distance(-1, "feet")
_AmX.ShowObjects = "OnEnter"
_AmX.ProximityRange = Distance(60, "meters")
_AmX.AllowSetPositionTo = false
_AmX.Active = false
_AmX.Points = {
	ZonePoint(38.5743928814342, -90.3725110378775, 0), 
	ZonePoint(38.5744120152431, -90.3723370000236, 0), 
	ZonePoint(38.5746097309698, -90.3723234033163, 0), 
	ZonePoint(38.5746394945805, -90.3725055991945, 0)
}
_AmX.OriginalPoint = ZonePoint(38.5745135305569, -90.372419260103, 0)
_AmX.DistanceRangeUOM = "Feet"
_AmX.ProximityRangeUOM = "Meters"
_AmX.OutOfRangeName = ""
_AmX.InRangeName = ""

-- Characters --

-- Items --

-- Tasks --

-- Cartridge Variables --
_e8d = _kXg0("\054\121\062\030")
_zEX7 = _kXg0("\058\044\062\062\071")
_9ZJj8 = _kXg0("\058\044\062\062\071")
_n2yzO = _kXg0("\058\044\062\062\071")
_SKp = _kXg0("\058\044\062\062\071")
_Ev_ = _kXg0("\058\044\062\062\071")
_U1Rd.ZVariables = {
	_e8d = _kXg0("\054\121\062\030"), 
	_zEX7 = _kXg0("\058\044\062\062\071"), 
	_9ZJj8 = _kXg0("\058\044\062\062\071"), 
	_n2yzO = _kXg0("\058\044\062\062\071"), 
	_SKp = _kXg0("\058\044\062\062\071"), 
	_Ev_ = _kXg0("\058\044\062\062\071")
}

-- Timers --

-- Inputs --

-- WorksWithList for object commands --

-- functions --
function _U1Rd:OnStart()
	_Urwigo.MessageBox{
		Text = _kXg0("\061\037\018\060\109\062\037\051\085\109\051\085\097\037\051\087\037\007\037\086\058\017\051\109\036\051\124\018\111\007\111\105")
	}
end
function _U1Rd:OnRestore()
end
function _AmX:OnEnter()
	_e8d = _kXg0("\054\121\062\030")
	_U1Rd.Complete = true
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return _U1Rd
