require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartHiddenTreasure = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartHiddenTreasure.MsgBoxCBFuncs = {}

zmediaKeyIcon = Wherigo.ZMedia(cartHiddenTreasure)
zmediaKeyIcon.Name="KeyIcon"
zmediaKeyIcon.Description=""
zmediaKeyIcon.AltText=""
zmediaKeyIcon.Id="ddcc4fc6-692c-4b0d-8a9e-f72b3f4612bd"
zmediaKeyIcon.Resources = {
{ Type = "jpg", Filename = "keyIcon.jpg", Directives = {},},
}
zmediaflag = Wherigo.ZMedia(cartHiddenTreasure)
zmediaflag.Name="flag"
zmediaflag.Description=""
zmediaflag.AltText=""
zmediaflag.Id="c13832fb-77bd-418a-b17c-d5d91c7829d6"
zmediaflag.Resources = {
{ Type = "jpg", Filename = "FlagIcon.jpg", Directives = {"NoResize,"},},
}
zmediaMap = Wherigo.ZMedia(cartHiddenTreasure)
zmediaMap.Name="Map"
zmediaMap.Description=""
zmediaMap.AltText=""
zmediaMap.Id="13c0576f-00eb-4c11-b6a7-24c7e0ce5696"
zmediaMap.Resources = {
{ Type = "jpg", Filename = "map140.jpg", Directives = {},},
}
zmediaTreasureChest = Wherigo.ZMedia(cartHiddenTreasure)
zmediaTreasureChest.Name="Treasure Chest"
zmediaTreasureChest.Description="A wooden chest with a lock."
zmediaTreasureChest.AltText=""
zmediaTreasureChest.Id="bf664364-fbd5-455c-a5d0-88e732eed15a"
zmediaTreasureChest.Resources = {
{ Type = "jpg", Filename = "chest140.jpg", Directives = {},},
}
zmediaKey = Wherigo.ZMedia(cartHiddenTreasure)
zmediaKey.Name="Key"
zmediaKey.Description="An old, rusty key."
zmediaKey.AltText=""
zmediaKey.Id="640842d3-2d68-46a6-80db-1ab590541c50"
zmediaKey.Resources = {
{ Type = "jpg", Filename = "key180.jpg", Directives = {},},
}
zmediaMapIcon = Wherigo.ZMedia(cartHiddenTreasure)
zmediaMapIcon.Name="MapIcon"
zmediaMapIcon.Description=""
zmediaMapIcon.AltText=""
zmediaMapIcon.Id="9984fba4-8d74-44e8-b3b9-cc9925a9a43c"
zmediaMapIcon.Resources = {
{ Type = "jpg", Filename = "MapIcon.jpg", Directives = {},},
}
zmediaopenchest = Wherigo.ZMedia(cartHiddenTreasure)
zmediaopenchest.Name="openchest"
zmediaopenchest.Description=""
zmediaopenchest.AltText=""
zmediaopenchest.Id="ff18df68-faac-44ea-a49e-3b3df1862721"
zmediaopenchest.Resources = {
{ Type = "jpg", Filename = "OpenChest140.jpg", Directives = {},},
}
zmediapaper = Wherigo.ZMedia(cartHiddenTreasure)
zmediapaper.Name="paper"
zmediapaper.Description=""
zmediapaper.AltText=""
zmediapaper.Id="b15d1347-55d2-4dab-80b2-88968949ef3b"
zmediapaper.Resources = {
{ Type = "wav", Filename = "PAPER3.wav", Directives = {},},
}
zmediachest = Wherigo.ZMedia(cartHiddenTreasure)
zmediachest.Name="chest"
zmediachest.Description=""
zmediachest.AltText=""
zmediachest.Id="8a4084d4-f855-4501-aa1f-e0f13ea2cf6a"
zmediachest.Resources = {
{ Type = "wav", Filename = "Crunch.wav", Directives = {},},
}
zmediakey = Wherigo.ZMedia(cartHiddenTreasure)
zmediakey.Name="key"
zmediakey.Description=""
zmediakey.AltText=""
zmediakey.Id="2a22525e-3b16-4eda-b058-803a10ef8486"
zmediakey.Resources = {
{ Type = "wav", Filename = "METAL1.wav", Directives = {},},
}
zmediacheer = Wherigo.ZMedia(cartHiddenTreasure)
zmediacheer.Name="cheer"
zmediacheer.Description=""
zmediacheer.AltText=""
zmediacheer.Id="9f552443-0335-452c-915b-cfd526466f8a"
zmediacheer.Resources = {
{ Type = "wav", Filename = "Cheering 2.wav", Directives = {},},
}
-- Cartridge Info --
cartHiddenTreasure.Id="46c54ec9-79a8-4b29-bd39-e23962b4d31a"
cartHiddenTreasure.Name="Hidden Treasure"
cartHiddenTreasure.Description=[[You found an old letter in your attic.

My Dearest Child,

Before I was your father I lived an unmentionable life of, well, let us just say adventure.  When I met your mother, I desired a more peaceful life here on the outskirts of Saint Louis.  I buried some of the items I aquired in my younger years on the farm.  You can find a map near where you used to swing.  It will lead you to a chest filled with items that should leave you and your children comfortable for the rest of your lives.

Love,

Your Father
]]
cartHiddenTreasure.Visible=true
cartHiddenTreasure.Activity="Fiction"
cartHiddenTreasure.StartingLocationDescription=[[Clydesdale Park]]
cartHiddenTreasure.StartingLocation = ZonePoint(38.528814,-90.341842,0)
cartHiddenTreasure.Version="1"
cartHiddenTreasure.Company=""
cartHiddenTreasure.Author="Southwicks"
cartHiddenTreasure.BuilderVersion="2.0.4907.3996"
cartHiddenTreasure.CreateDate="2/29/2008 12:38:58 PM"
cartHiddenTreasure.PublishDate="2/29/2008 3:18:09 PM"
cartHiddenTreasure.UpdateDate="3/17/2008 8:41:46 PM"
cartHiddenTreasure.LastPlayedDate="1/1/0001 12:00:00 AM"
cartHiddenTreasure.TargetDevice="PocketPC"
cartHiddenTreasure.TargetDeviceVersion="0"
cartHiddenTreasure.StateId="1"
cartHiddenTreasure.CountryId="2"
cartHiddenTreasure.Complete=false
cartHiddenTreasure.UseLogging=false
cartHiddenTreasure.Icon=zmediaflag

-- Zones --
zoneZone_1 = Wherigo.Zone(cartHiddenTreasure)
zoneZone_1.Id="832f50ac-5227-4f31-9e80-f7cbbf5f3aba"
zoneZone_1.Name="Zone_1"
zoneZone_1.Description=[[]]
zoneZone_1.Visible=false
zoneZone_1.DistanceRange = Distance(-1, "feet")
zoneZone_1.ShowObjects="OnEnter"
zoneZone_1.ProximityRange = Distance(200, "feet")
zoneZone_1.AllowSetPositionTo=false
zoneZone_1.Active=true
zoneZone_1.Points = {
  ZonePoint(38.52845,-90.33853,0),
  ZonePoint(38.52845,-90.33822,0),
  ZonePoint(38.52826,-90.33822,0),
  ZonePoint(38.52821,-90.3385,0)
}
zoneZone_1.OriginalPoint = ZonePoint(38.52845,-90.33853,0)
zoneZone_1.DistanceRangeUOM = "Feet"
zoneZone_1.ProximityRangeUOM = "Feet"
zoneZone_1.OutOfRangeName = ""
zoneZone_1.InRangeName = ""

zoneZone_2 = Wherigo.Zone(cartHiddenTreasure)
zoneZone_2.Id="4838f673-4e7e-4960-a07c-d8c3888694e2"
zoneZone_2.Name="Zone_2"
zoneZone_2.Description=[[]]
zoneZone_2.Visible=false
zoneZone_2.DistanceRange = Distance(1500, "feet")
zoneZone_2.ShowObjects="OnEnter"
zoneZone_2.ProximityRange = Distance(200, "feet")
zoneZone_2.AllowSetPositionTo=false
zoneZone_2.Active=true
zoneZone_2.Points = {
  ZonePoint(38.52717,-90.33791,0),
  ZonePoint(38.52715,-90.3376,0),
  ZonePoint(38.52687,-90.33761,0),
  ZonePoint(38.52695,-90.33795,0)
}
zoneZone_2.OriginalPoint = ZonePoint(38.52717,-90.33791,0)
zoneZone_2.DistanceRangeUOM = "Feet"
zoneZone_2.ProximityRangeUOM = "Feet"
zoneZone_2.OutOfRangeName = ""
zoneZone_2.InRangeName = ""
zoneZone_2.Icon=zmediaMapIcon

zoneTreasure = Wherigo.Zone(cartHiddenTreasure)
zoneTreasure.Id="134aa74d-8896-4c19-8e19-9ff731ec8045"
zoneTreasure.Name="Treasure"
zoneTreasure.Description=[[]]
zoneTreasure.Visible=false
zoneTreasure.DistanceRange = Distance(1500, "feet")
zoneTreasure.ShowObjects="OnEnter"
zoneTreasure.ProximityRange = Distance(200, "feet")
zoneTreasure.AllowSetPositionTo=false
zoneTreasure.Active=false
zoneTreasure.Points = {
  ZonePoint(38.52738,-90.33744,0),
  ZonePoint(38.52727,-90.33708,0),
  ZonePoint(38.52703,-90.33712,0),
  ZonePoint(38.52714,-90.33749,0)
}
zoneTreasure.OriginalPoint = ZonePoint(38.52738,-90.33744,0)
zoneTreasure.DistanceRangeUOM = "Feet"
zoneTreasure.ProximityRangeUOM = "Feet"
zoneTreasure.OutOfRangeName = ""
zoneTreasure.InRangeName = ""

zoneZone_4 = Wherigo.Zone(cartHiddenTreasure)
zoneZone_4.Id="a91b5367-91b4-46fe-bad9-9ecc040db7a0"
zoneZone_4.Name="Zone_4"
zoneZone_4.Description=[[]]
zoneZone_4.Visible=false
zoneZone_4.DistanceRange = Distance(1500, "feet")
zoneZone_4.ShowObjects="OnEnter"
zoneZone_4.ProximityRange = Distance(200, "feet")
zoneZone_4.AllowSetPositionTo=false
zoneZone_4.Active=false
zoneZone_4.Points = {
  ZonePoint(38.52703,-90.33733,0),
  ZonePoint(38.52699,-90.33692,0),
  ZonePoint(38.52669,-90.33692,0),
  ZonePoint(38.52676,-90.33741,0)
}
zoneZone_4.OriginalPoint = ZonePoint(38.52703,-90.33733,0)
zoneZone_4.DistanceRangeUOM = "Feet"
zoneZone_4.ProximityRangeUOM = "Feet"
zoneZone_4.OutOfRangeName = ""
zoneZone_4.InRangeName = ""
zoneZone_4.Icon=zmediaKeyIcon

-- Characters --

-- Items --
zitemTreasureMap = Wherigo.ZItem(cartHiddenTreasure)
zitemTreasureMap.Id="4cb40950-cb0c-4345-b4bb-ae076e3c7d92"
zitemTreasureMap.Name="Treasure Map"
zitemTreasureMap.Description=[[A very old and worn map.]]
zitemTreasureMap.Visible=true
zitemTreasureMap.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemTreasureMap.Media=zmediaMap
zitemTreasureMap.Icon=zmediaMapIcon
zitemTreasureMap.Locked = false
zitemTreasureMap.Opened = false
zitemTreasureMap.Commands = {
  Read = Wherigo.ZCommand{Text="Read", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemTreasureMap.Commands.Read.Custom = true
zitemTreasureMap.Commands.Read.Id="6c9d3066-82a0-4a16-bb2e-7400f8850e77"
zitemTreasureMap.Commands.Read.WorksWithAll = true

zitemTreasureChest = Wherigo.ZItem(cartHiddenTreasure)
zitemTreasureChest.Id="fadfd728-e5ed-4c60-9768-42e21f617216"
zitemTreasureChest.Name="Treasure Chest"
zitemTreasureChest.Description=[[A wooden chest with a lock.  Maybe you can find the key if you hunt around.]]
zitemTreasureChest.Visible=true
zitemTreasureChest.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemTreasureChest.Media=zmediaTreasureChest
zitemTreasureChest.Locked = false
zitemTreasureChest.Opened = false
zitemTreasureChest.Commands = {
  Take = Wherigo.ZCommand{Text="Take", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemTreasureChest.Commands.Take.Custom = true
zitemTreasureChest.Commands.Take.Id="a98824dd-0eb7-4ff5-bea1-9cb605958ca1"
zitemTreasureChest.Commands.Take.WorksWithAll = true

zitemKey = Wherigo.ZItem(cartHiddenTreasure)
zitemKey.Id="7412b961-946c-433b-95c6-cf84a238448e"
zitemKey.Name="Key"
zitemKey.Description=[[An old rusty key.]]
zitemKey.Visible=true
zitemKey.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemKey.Media=zmediaKey
zitemKey.Icon=zmediaKeyIcon
zitemKey.Locked = false
zitemKey.Opened = false
zitemKey.Commands = {
  UnlockChest = Wherigo.ZCommand{Text="Unlock Chest", CmdWith=true, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemKey.Commands.UnlockChest.Custom = true
zitemKey.Commands.UnlockChest.Id="2d7a8f70-b6f0-47c7-8031-1e449eb44f18"
zitemKey.Commands.UnlockChest.WorksWithAll = false
zitemKey.Commands.UnlockChest.WorksWithListIds = {"fadfd728-e5ed-4c60-9768-42e21f617216", }

-- Tasks --
ztaskFindtheMap = Wherigo.ZTask(cartHiddenTreasure)
ztaskFindtheMap.Id="a9bfbd04-443b-4226-8c78-627f1b8c35d3"
ztaskFindtheMap.Name="Find the Map"
ztaskFindtheMap.Description=[[Look near the playground to find the treasure map.]]
ztaskFindtheMap.Visible=true
ztaskFindtheMap.Active=true
ztaskFindtheMap.Complete=false
ztaskFindtheMap.CorrectState = "None"

ztaskFindChest = Wherigo.ZTask(cartHiddenTreasure)
ztaskFindChest.Id="df26fe47-3e65-4416-a6bd-7e1ebd6071a4"
ztaskFindChest.Name="Find Chest"
ztaskFindChest.Description=[[Read the map to find the location of the treasure chest.]]
ztaskFindChest.Visible=false
ztaskFindChest.Active=true
ztaskFindChest.Complete=false
ztaskFindChest.CorrectState = "None"

ztaskFindKey = Wherigo.ZTask(cartHiddenTreasure)
ztaskFindKey.Id="54ec1a70-b87a-4625-bc8c-8e94b56ca750"
ztaskFindKey.Name="Find Key"
ztaskFindKey.Description=[[Walk around to search for the key that opens the treasure chest.]]
ztaskFindKey.Visible=false
ztaskFindKey.Active=true
ztaskFindKey.Complete=false
ztaskFindKey.CorrectState = "None"

ztaskUnlockChest = Wherigo.ZTask(cartHiddenTreasure)
ztaskUnlockChest.Id="ef23650a-905d-4230-a47c-e705577cc9f1"
ztaskUnlockChest.Name="Unlock Chest"
ztaskUnlockChest.Description=[[Use key to unlock chest.]]
ztaskUnlockChest.Visible=false
ztaskUnlockChest.Active=true
ztaskUnlockChest.Complete=false
ztaskUnlockChest.CorrectState = "None"

-- Cartridge Variables --
-- Builder Variables (to be read by the builder only) --
buildervar = {}
-- ZTimers --

-- Inputs --

-- WorksWithList for zobject zcommands --
zitemKey.Commands.UnlockChest.WorksWithList={zitemTreasureChest, }

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function zitemTreasureMap:OnRead()
-- #GroupDescription=Read Map --
-- #Comment=Read Map Comment --
zitemTreasureMap.Commands["Read"].Enabled = false
Wherigo.MessageBox{Text=[[The map shows you where to find the Treasure Chest!]],Media=zmediaMap,}
zoneTreasure.Visible = true
end

function zoneZone_2:OnEnter()
-- #GroupDescription=Enter Zone 2 --
-- #Comment=Enter Zone 2 Comment --
Wherigo.PlayAudio(zmediapaper)
zoneTreasure.Active = true
ztaskFindChest.Visible = true
ztaskFindtheMap.Complete = true
Wherigo.MessageBox{Text=[[You found the treasure map!]],Media=zmediaMap,}
zitemTreasureMap:MoveTo(Player)
end

function zitemKey:OnUnlockChest(target)
-- #GroupDescription=Unlock Chest --
-- #Comment=Unlock Chest Comment --
zitemKey.Commands["UnlockChest"].Enabled = false
Wherigo.PlayAudio(zmediacheer)
Wherigo.MessageBox{Text=[[Congratulations, you are rich!  Your completion code is :]] ..Player.CompletionCode
,Media=zmediaopenchest,}
ztaskUnlockChest.Complete = true
cartHiddenTreasure.Complete = true
end

function zoneTreasure:OnEnter()
-- #GroupDescription=Enter Zone 3 --
-- #Comment=Enter Zone 3 Comment --
Wherigo.PlayAudio(zmediachest)
zitemKey.Commands["UnlockChest"].Enabled = false
zoneZone_4.Active = true
ztaskFindKey.Visible = true
ztaskFindChest.Complete = true
Wherigo.MessageBox{Text=[[You have found the treasure chest!]],Media=zmediaTreasureChest,}
zitemTreasureChest:MoveTo(zoneTreasure)
end

function zitemTreasureChest:OnTake()
-- #GroupDescription=take chest --
-- #Comment=take chest Comment --
zitemTreasureChest.Commands["Take"].Enabled = false
zitemTreasureChest:MoveTo(Player)
end

function zoneZone_4:OnEnter()
-- #GroupDescription=Enter Zone 4 --
-- #Comment=Enter Zone 4 Comment --
Wherigo.PlayAudio(zmediakey)
zitemKey.Commands["UnlockChest"].Enabled = true
ztaskUnlockChest.Visible = true
ztaskFindKey.Complete = true
zitemKey:MoveTo(zoneZone_4)
Wherigo.MessageBox{Text=[[You found the key!]],Media=zmediaKey,}
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
-- #End Author Functions# --
-- Nothing after this line --
return cartHiddenTreasure
