require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _3UMLA(str)
	local res = ""
    local dtable = "\058\073\018\095\064\013\024\111\001\076\072\062\054\081\118\034\109\100\059\053\126\061\123\004\093\094\043\021\017\026\070\042\019\096\108\105\025\009\067\085\075\065\016\020\116\046\030\106\056\031\033\074\037\125\050\011\023\045\098\115\040\122\121\036\038\114\015\047\083\055\000\028\039\035\051\006\080\077\014\119\103\069\088\097\087\007\049\092\107\002\032\066\012\029\101\082\041\060\110\102\010\008\120\086\104\048\052\113\003\063\089\084\057\022\112\071\027\078\068\091\124\005\117\099\079\044\090"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_c4vM = Wherigo.ZCartridge()

-- Media --
_C1Eb = Wherigo.ZMedia(_c4vM)
_C1Eb.Id = "b6c71eac-18c9-47a4-83a1-d662e16d9acb"
_C1Eb.Name = _3UMLA("\119\084\099\084\045\036\060\063")
_C1Eb.Description = _3UMLA("\010\073\084\123\045\095\123\066\091\095\045\091\099\084\066\066\084\045\095\123\066\091\018\123\091\048\095\123\046")
_C1Eb.AltText = ""
_C1Eb.Resources = {
	{
		Type = "jpg", 
		Filename = "Danatisy.jpg", 
		Directives = {}
	}
}
_8Hm = Wherigo.ZMedia(_c4vM)
_8Hm.Id = "22797aa4-e36e-446b-8ae0-34f14233f459"
_8Hm.Name = _3UMLA("\077\040\096\002\119\040\078")
_8Hm.Description = _3UMLA("\010\008\081\008\091\018\123\091\077\084\066\124\091\018\095\091\035\084\091\096\036\015\036\095\066\095\058\018\123\058\078\008\123\035\036\099")
_8Hm.AltText = ""
_8Hm.Resources = {
	{
		Type = "JPG", 
		Filename = "PURIDUM.JPG", 
		Directives = {}
	}
}
_bVkg = Wherigo.ZMedia(_c4vM)
_bVkg.Id = "a5e62f25-2036-40a0-8e68-c14de1e0fed3"
_bVkg.Name = _3UMLA("\010\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095")
_bVkg.Description = _3UMLA("\010\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\091\018\095\091\077\040\096\002\119\040\078\046")
_bVkg.AltText = ""
_bVkg.Resources = {
	{
		Type = "JPG", 
		Filename = "Cle.JPG", 
		Directives = {}
	}
}
_sqS7B = Wherigo.ZMedia(_c4vM)
_sqS7B.Id = "7321f7be-5f03-4782-9f75-eed0d432086b"
_sqS7B.Name = _3UMLA("\010\084\091\077\008\066\045\095\091\018\123\091\039\105\084\045\095\084\123")
_sqS7B.Description = _3UMLA("\104\008\123\060\091\095\045\095\060\091\095\099\091\100\084\124\095\091\018\123\091\039\105\084\045\095\084\123\091\095\045\091\123\099\095\091\115\008\066\045\095\091\017\084\060\060\036\015\095\091\059\035\008\108\123\095\091\015\008\045\066\095\091\124\105\095\017\036\099\046")
_sqS7B.AltText = ""
_sqS7B.Resources = {
	{
		Type = "JPG", 
		Filename = "Porte_Chateau.JPG", 
		Directives = {}
	}
}
_WvfC = Wherigo.ZMedia(_c4vM)
_WvfC.Id = "64386089-58cc-4da5-8555-d75a91b3ae9c"
_WvfC.Name = _3UMLA("\010\095\091\077\008\099\045\091\018\123\091\092\066\095\008\099")
_WvfC.Description = _3UMLA("\040\099\091\115\008\099\045\091\115\123\066\095\017\095\099\045\091\036\017\084\081\036\099\084\036\066\095\091\084\063\084\099\045\091\018\095\060\091\015\095\066\045\123\060\091\045\105\095\066\084\115\095\123\045\036\108\123\095\060\091\060\036\091\015\008\123\060\091\035\095\091\045\066\084\015\095\066\060\095\062\046")
_WvfC.AltText = ""
_WvfC.Resources = {
	{
		Type = "JPG", 
		Filename = "Pont.JPG", 
		Directives = {}
	}
}
_GKkR = Wherigo.ZMedia(_c4vM)
_GKkR.Id = "c0296eff-c36e-47ff-b620-8a794cf23bff"
_GKkR.Name = _3UMLA("\010\073\042\066\059\066\095\091\018\095\091\077\008\095\099\008")
_GKkR.Description = _3UMLA("\010\073\042\066\059\066\095\091\078\084\081\036\108\123\095\091\008\123\091\035\095\091\010\123\045\036\099\091\060\095\091\066\095\100\123\081\036\095\046")
_GKkR.AltText = ""
_GKkR.Resources = {
	{
		Type = "JPG", 
		Filename = "Arbre.JPG", 
		Directives = {}
	}
}
_Hq1Y = Wherigo.ZMedia(_c4vM)
_Hq1Y.Id = "fb0dc374-33a9-4776-8032-75195c286a16"
_Hq1Y.Name = _3UMLA("\010\095\091\010\123\045\036\099\091\077\008\095\099\008")
_Hq1Y.Description = _3UMLA("\077\008\095\099\008\091\035\095\091\010\123\045\036\099\046")
_Hq1Y.AltText = ""
_Hq1Y.Resources = {
	{
		Type = "JPG", 
		Filename = "Lutin.JPG", 
		Directives = {}
	}
}
_R40 = Wherigo.ZMedia(_c4vM)
_R40.Id = "2b001c7d-bd71-4e5c-a4cf-b7e74750bfed"
_R40.Name = _3UMLA("\010\095\091\039\105\084\045\095\084\123\091\018\095\091\077\040\096\002\119\040\078")
_R40.Description = _3UMLA("\010\095\091\039\105\084\045\095\084\123\091\018\095\091\077\040\096\002\119\040\078\046")
_R40.AltText = ""
_R40.Resources = {
	{
		Type = "JPG", 
		Filename = "Chateau.JPG", 
		Directives = {}
	}
}
_qwfpX = Wherigo.ZMedia(_c4vM)
_qwfpX.Id = "b75bdea2-11b5-490c-a6f1-d7b4dd1dc26c"
_qwfpX.Name = _3UMLA("\010\084\091\039\035\084\036\066\036\095\066\095")
_qwfpX.Description = _3UMLA("\010\084\091\039\035\084\036\066\036\095\066\095\091\008\123\091\015\008\123\060\091\066\095\099\124\008\099\045\066\095\066\095\062\091\096\123\059\036\095\099\046")
_qwfpX.AltText = ""
_qwfpX.Resources = {
	{
		Type = "JPG", 
		Filename = "Clairiere.JPG", 
		Directives = {}
	}
}
_JFP = Wherigo.ZMedia(_c4vM)
_JFP.Id = "90b2e500-961e-4ef1-9821-9f6abf8bca49"
_JFP.Name = _3UMLA("\010\095\091\116\008\123\066\059\036")
_JFP.Description = _3UMLA("\010\095\091\116\008\123\066\059\036\091\008\123\091\105\084\059\036\045\095\091\096\123\059\036\095\099\046")
_JFP.AltText = ""
_JFP.Resources = {
	{
		Type = "JPG", 
		Filename = "Gourbi.JPG", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "Gourbi_IC.jpg", 
		Directives = {}
	}
}
_sv8 = Wherigo.ZMedia(_c4vM)
_sv8.Id = "9dbb3170-179c-4ca5-b524-7042004c54fd"
_sv8.Name = _3UMLA("\010\095\091\052\008\123\095\123\066")
_sv8.Description = _3UMLA("\118\008\045\066\095\091\048\008\123\095\123\066\046")
_sv8.AltText = ""
_sv8.Resources = {
	{
		Type = "JPG", 
		Filename = "Player.JPG", 
		Directives = {}
	}
}
_nMhUc = Wherigo.ZMedia(_c4vM)
_nMhUc.Id = "c3764f49-74a4-4e0e-91c1-9ce6daf1761e"
_nMhUc.Name = _3UMLA("\096\123\059\036\095\099")
_nMhUc.Description = _3UMLA("\010\095\091\017\084\081\036\124\036\095\099\046\091\065\099\059\060\115\019\069\008\063\095\062\091\081\095\099\045\036\035\051")
_nMhUc.AltText = ""
_nMhUc.Resources = {
	{
		Type = "JPG", 
		Filename = "Rubien.JPG", 
		Directives = {}
	}
}
_NxxF = Wherigo.ZMedia(_c4vM)
_NxxF.Id = "c10d874b-25ad-40ec-b019-137b55b38ab2"
_NxxF.Name = _3UMLA("\096\123\059\036\095\099\091\084\124\045\036\100")
_NxxF.Description = _3UMLA("\096\123\059\036\095\099\091\035\008\066\060\108\123\073\036\035\091\095\060\045\091\084\045\045\084\108\123\095\046")
_NxxF.AltText = ""
_NxxF.Resources = {
	{
		Type = "JPG", 
		Filename = "Rubien_Action.JPG", 
		Directives = {}
	}
}
_EFv = Wherigo.ZMedia(_c4vM)
_EFv.Id = "7d235b39-e122-4df6-9a09-fe2b938193f9"
_EFv.Name = _3UMLA("\112\084\124\105\095")
_EFv.Description = _3UMLA("\002\017\084\081\095\091\018\095\091\045\084\124\105\095\091\084\091\084\124\124\008\017\115\035\036\066\046")
_EFv.AltText = ""
_EFv.Resources = {
	{
		Type = "JPG", 
		Filename = "Tache.JPG", 
		Directives = {}
	}
}
_6Ly = Wherigo.ZMedia(_c4vM)
_6Ly.Id = "b0ea3a67-2f5c-4c7a-9b78-491580298985"
_6Ly.Name = _3UMLA("\052\084\124\089\091\065\084\017\115\019\091\069\008")
_6Ly.Description = _3UMLA("\010\095\060\091\015\084\035\095\123\066\095\123\103\091\081\095\008\124\084\124\105\095\123\066\060\091\095\099\091\084\124\045\036\008\099\046")
_6Ly.AltText = ""
_6Ly.Resources = {
	{
		Type = "jpg", 
		Filename = "JackSo.jpg", 
		Directives = {}
	}
}
_flcQf = Wherigo.ZMedia(_c4vM)
_flcQf.Id = "6ebe6b06-81b7-44ae-867e-13e63e51b599"
_flcQf.Name = _3UMLA("\010\084\091\039\084\124\105\095")
_flcQf.Description = _3UMLA("\010\084\091\124\084\124\105\095\091\095\099\100\036\099\091\018\036\060\115\008\099\036\059\035\095\046\091\002\035\091\099\095\091\066\095\060\045\095\091\108\123\073\084\091\060\073\063\091\066\095\099\018\066\095\091\095\045\091\060\036\081\099\095\066\091\035\095\091\124\084\066\099\095\045\091\018\095\091\015\036\060\036\045\095\046")
_flcQf.AltText = ""
_flcQf.Resources = {
	{
		Type = "jpg", 
		Filename = "Cache.jpg", 
		Directives = {}
	}
}
_waa = Wherigo.ZMedia(_c4vM)
_waa.Id = "722bfcc3-71b7-49a7-a2cf-6813028e7b50"
_waa.Name = _3UMLA("\040\099\035\008\124\089")
_waa.Description = _3UMLA("\039\008\018\095\091\016\040\099\035\008\124\089\016\046")
_waa.AltText = ""
_waa.Resources = {
	{
		Type = "JPG", 
		Filename = "Unlock.JPG", 
		Directives = {}
	}
}
_byfLx = Wherigo.ZMedia(_c4vM)
_byfLx.Id = "63ac4f3d-0fda-4571-a44e-76fe6fcacc35"
_byfLx.Name = _3UMLA("\127\077\123\095\045\045\095\077\123\095\045\045\095")
_byfLx.Description = _3UMLA("\069\008\099\091\018\073\095\066\066\095\123\066")
_byfLx.AltText = ""
_byfLx.Resources = {
	{
		Type = "fdl", 
		Filename = "Puette.fdl", 
		Directives = {}
	}
}
_l592 = Wherigo.ZMedia(_c4vM)
_l592.Id = "3e5f486c-0569-4aed-b7ca-9f4bc82491e6"
_l592.Name = _3UMLA("\127\111\095")
_l592.Description = _3UMLA("\069\008\099\091\018\095\091\066\095\123\060\060\036\045\095")
_l592.AltText = ""
_l592.Resources = {
	{
		Type = "fdl", 
		Filename = "Hourra.fdl", 
		Directives = {}
	}
}
_o40K = Wherigo.ZMedia(_c4vM)
_o40K.Id = "7d25b308-4623-4d05-be33-a64dbf93df81"
_o40K.Name = _3UMLA("\077\123\066\036\018\123\017\091\002\124\008\099\095")
_o40K.Description = _3UMLA("\002\017\084\081\095\091\075\055\083\075\055")
_o40K.AltText = ""
_o40K.Resources = {
	{
		Type = "jpg", 
		Filename = "PURIDUM_IC.jpg", 
		Directives = {}
	}
}
_sMo = Wherigo.ZMedia(_c4vM)
_sMo.Id = "5499abf0-dd0b-4c10-8289-87ec56ff5d81"
_sMo.Name = _3UMLA("\116\008\123\066\059\036\091\002\124\008\099\095")
_sMo.Description = _3UMLA("\002\017\084\081\095\091\075\055\083\075\055")
_sMo.AltText = ""
_sMo.Resources = {
	{
		Type = "jpg", 
		Filename = "Gourbi_IC1.jpg", 
		Directives = {}
	}
}
_UI6 = Wherigo.ZMedia(_c4vM)
_UI6.Id = "e63ce9ea-2e48-4cae-8bc1-f8c3ebfd1ecc"
_UI6.Name = _3UMLA("\039\105\084\045\095\084\123\091\002\124\008\099\095")
_UI6.Description = _3UMLA("\002\017\084\081\095\091\075\055\083\075\055")
_UI6.AltText = ""
_UI6.Resources = {
	{
		Type = "jpg", 
		Filename = "Chateau_IC.jpg", 
		Directives = {}
	}
}
_2Sl8 = Wherigo.ZMedia(_c4vM)
_2Sl8.Id = "7a17d64d-dabc-421c-ba56-82cc2d6aa58a"
_2Sl8.Name = _3UMLA("\039\035\084\036\066\036\095\066\095\091\002\124\008\099\095")
_2Sl8.Description = _3UMLA("\002\017\084\081\095\091\075\055\083\075\055")
_2Sl8.AltText = ""
_2Sl8.Resources = {
	{
		Type = "jpg", 
		Filename = "Clairiere_IC.jpg", 
		Directives = {}
	}
}
_BRA = Wherigo.ZMedia(_c4vM)
_BRA.Id = "1e8e8c12-e3f2-4a41-9649-9669775c09c2"
_BRA.Name = _3UMLA("\042\066\059\066\095\091\018\095\091\077\008\095\099\008\091\002\124\008\099\095")
_BRA.Description = _3UMLA("\002\017\084\081\095\091\075\055\083\075\055")
_BRA.AltText = ""
_BRA.Resources = {
	{
		Type = "jpg", 
		Filename = "Arbre_IC.jpg", 
		Directives = {}
	}
}
_Dvhd = Wherigo.ZMedia(_c4vM)
_Dvhd.Id = "b4c7b11f-09fa-4185-bbba-027884c9f0bc"
_Dvhd.Name = _3UMLA("\077\008\099\045\091\002\124\008\099\095")
_Dvhd.Description = _3UMLA("\002\017\084\081\095\091\075\055\083\075\055")
_Dvhd.AltText = ""
_Dvhd.Resources = {
	{
		Type = "jpg", 
		Filename = "Pont_IC.jpg", 
		Directives = {}
	}
}
_iUhbO = Wherigo.ZMedia(_c4vM)
_iUhbO.Id = "1804ba91-38e4-4541-9389-4a1c7bb613dc"
_iUhbO.Name = _3UMLA("\039\084\124\105\095\091\002\124\008\099\095")
_iUhbO.Description = _3UMLA("\002\017\084\081\095\091\075\055\083\075\055")
_iUhbO.AltText = ""
_iUhbO.Resources = {
	{
		Type = "jpg", 
		Filename = "Cache_IC.jpg", 
		Directives = {}
	}
}
_l3te = Wherigo.ZMedia(_c4vM)
_l3te.Id = "0e4d46d0-c476-4484-8029-d77a7b65aeab"
_l3te.Name = _3UMLA("\010\095\091\010\123\045\036\099\091\077\008\095\099\008")
_l3te.Description = ""
_l3te.AltText = ""
_l3te.Resources = {
	{
		Type = "jpg", 
		Filename = "Lutin_115_100.jpg", 
		Directives = {}
	}
}
__bV = Wherigo.ZMedia(_c4vM)
__bV.Id = "732ee6a0-7fc6-4825-ab2f-817bf2cce08b"
__bV.Name = _3UMLA("\010\095\091\077\095\045\036\045\091\077\066\036\099\124\095")
__bV.Description = ""
__bV.AltText = ""
__bV.Resources = {
	{
		Type = "jpg", 
		Filename = "Petit_Prince.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_c4vM.Id="556d64aa-c29d-4e2b-9cce-767f9da9e36d"
_c4vM.Name="PURIDUM"
_c4vM.Description=[[Une cartouche inspiree d'un tutoriel de l'application Web Earwigo. J'ai adapte le jeu au secteur du Parc de la Riviere-du-Moulin et compose une nouvelle histoire avec l'application URWIGO.]]
_c4vM.Visible=true
_c4vM.Activity="Geocache"
_c4vM.StartingLocationDescription=[[Sur le stationnement du Parc Urbain RIviere DU Moulin (PURIDUM).]]
_c4vM.StartingLocation = ZonePoint(48.3979656962689,-71.0456020522435,0)
_c4vM.Version="1.2"
_c4vM.Company=""
_c4vM.Author="Danatisy"
_c4vM.BuilderVersion="URWIGO 1.20.5218.24064"
_c4vM.CreateDate="09/04/2014 21:05:25"
_c4vM.PublishDate="1/1/0001 12:00:00 AM"
_c4vM.UpdateDate="10/26/2014 17:07:22"
_c4vM.LastPlayedDate="1/1/0001 12:00:00 AM"
_c4vM.TargetDevice="PocketPC"
_c4vM.TargetDeviceVersion="0"
_c4vM.StateId="1"
_c4vM.CountryId="2"
_c4vM.Complete=false
_c4vM.UseLogging=true

_c4vM.Media=_8Hm

_c4vM.Icon=_o40K


-- Zones --
_ZkEED = Wherigo.Zone(_c4vM)
_ZkEED.Id = "9926a671-ac0f-430d-ba31-bef1165f727f"
_ZkEED.Name = _3UMLA("\119\095\115\084\066\045")
_ZkEED.Description = _3UMLA("\039\073\095\060\045\091\036\124\036\091\108\123\095\091\035\073\105\036\060\045\008\036\066\095\091\124\008\017\017\095\099\124\095\046")
_ZkEED.Visible = false
_ZkEED.Media = _8Hm
_ZkEED.Icon = _o40K
_ZkEED.Commands = {}
_ZkEED.DistanceRange = Distance(-1, "feet")
_ZkEED.ShowObjects = "OnEnter"
_ZkEED.ProximityRange = Distance(60, "meters")
_ZkEED.AllowSetPositionTo = false
_ZkEED.Active = false
_ZkEED.Points = {
	ZonePoint(48.3971644988852, -71.0447565300942, 0), 
	ZonePoint(48.3972982004457, -71.0451743530115, 0), 
	ZonePoint(48.3972009091526, -71.0453026916344, 0), 
	ZonePoint(48.3970554595084, -71.0450417967954, 0), 
	ZonePoint(48.3970255894211, -71.0449308736802, 0), 
	ZonePoint(48.3970567127668, -71.0448329150676, 0)
}
_ZkEED.OriginalPoint = ZonePoint(48.3971335616966, -71.0450065267139, 0)
_ZkEED.DistanceRangeUOM = "Feet"
_ZkEED.ProximityRangeUOM = "Meters"
_ZkEED.OutOfRangeName = ""
_ZkEED.InRangeName = ""
_PBp3G = Wherigo.Zone(_c4vM)
_PBp3G.Id = "253dac36-17c6-4834-abdc-8731130c28c1"
_PBp3G.Name = _3UMLA("\010\084\091\039\035\084\036\066\036\095\066\095")
_PBp3G.Description = _3UMLA("\040\099\095\091\066\095\099\124\008\099\045\066\095\091\095\060\045\091\115\066\095\015\123\095\091\084\091\124\095\045\091\095\099\018\066\008\036\045\046")
_PBp3G.Visible = false
_PBp3G.Media = _qwfpX
_PBp3G.Icon = _2Sl8
_PBp3G.Commands = {}
_PBp3G.DistanceRange = Distance(-1, "feet")
_PBp3G.ShowObjects = "OnEnter"
_PBp3G.ProximityRange = Distance(60, "meters")
_PBp3G.AllowSetPositionTo = false
_PBp3G.Active = false
_PBp3G.Points = {
	ZonePoint(48.3958270343173, -71.0399258716584, 0), 
	ZonePoint(48.3956176761009, -71.0400656785328, 0), 
	ZonePoint(48.3955042789729, -71.0397471161999, 0), 
	ZonePoint(48.3957255209238, -71.0395946188451, 0)
}
_PBp3G.OriginalPoint = ZonePoint(48.3956686275787, -71.0398333213091, 0)
_PBp3G.DistanceRangeUOM = "Feet"
_PBp3G.ProximityRangeUOM = "Meters"
_PBp3G.OutOfRangeName = ""
_PBp3G.InRangeName = ""
_hMA = Wherigo.Zone(_c4vM)
_hMA.Id = "d3284c34-df96-402c-814e-3fed780736b3"
_hMA.Name = _3UMLA("\010\095\091\077\008\099\045\091\018\123\091\092\066\095\008\099")
_hMA.Description = _3UMLA("\010\095\091\092\066\095\008\099\126\091\035\073\095\060\115\066\036\045\091\018\095\091\035\084\091\066\036\015\036\095\066\095\126\091\124\008\123\035\095\091\060\008\123\060\091\035\123\036\046")
_hMA.Visible = false
_hMA.Media = _WvfC
_hMA.Icon = _Dvhd
_hMA.Commands = {}
_hMA.DistanceRange = Distance(-1, "feet")
_hMA.ShowObjects = "OnEnter"
_hMA.ProximityRange = Distance(60, "meters")
_hMA.AllowSetPositionTo = false
_hMA.Active = false
_hMA.Points = {
	ZonePoint(48.3949650544991, -71.0391708298207, 0), 
	ZonePoint(48.3949507088456, -71.0393535520394, 0), 
	ZonePoint(48.3947758667429, -71.0393501492657, 0), 
	ZonePoint(48.3947816147607, -71.0391453488351, 0)
}
_hMA.OriginalPoint = ZonePoint(48.3948683112121, -71.0392549699902, 0)
_hMA.DistanceRangeUOM = "Feet"
_hMA.ProximityRangeUOM = "Meters"
_hMA.OutOfRangeName = ""
_hMA.InRangeName = ""
_DczE = Wherigo.Zone(_c4vM)
_DczE.Id = "146e625d-0f42-47b7-8068-02aaed214a60"
_DczE.Name = _3UMLA("\010\095\091\116\008\123\066\059\036\091\018\095\091\096\123\059\036\095\099")
_DczE.Description = _3UMLA("\010\095\091\116\008\123\066\059\036\091\018\095\091\096\123\059\036\095\099\091\035\095\091\017\084\081\036\124\036\095\099\046\091\002\035\091\060\095\091\124\008\099\045\095\099\045\095\091\018\095\091\115\095\123\046")
_DczE.Visible = false
_DczE.Media = _JFP
_DczE.Icon = _sMo
_DczE.Commands = {}
_DczE.DistanceRange = Distance(-1, "feet")
_DczE.ShowObjects = "OnEnter"
_DczE.ProximityRange = Distance(60, "meters")
_DczE.AllowSetPositionTo = false
_DczE.Active = false
_DczE.Points = {
	ZonePoint(48.3946524941598, -71.042380092907, 0), 
	ZonePoint(48.3944778602746, -71.0424421157201, 0), 
	ZonePoint(48.3944428239363, -71.0422657104649, 0), 
	ZonePoint(48.394619546092, -71.0420340879442, 0)
}
_DczE.OriginalPoint = ZonePoint(48.3945481811157, -71.0422805017591, 0)
_DczE.DistanceRangeUOM = "Feet"
_DczE.ProximityRangeUOM = "Meters"
_DczE.OutOfRangeName = ""
_DczE.InRangeName = ""
_eT6x = Wherigo.Zone(_c4vM)
_eT6x.Id = "1d00a944-8d9e-4225-b6da-4b2605dd45f5"
_eT6x.Name = _3UMLA("\010\073\042\066\059\066\095\091\018\095\091\077\008\095\099\008")
_eT6x.Description = _3UMLA("\039\073\095\060\045\091\036\124\036\091\108\123\095\091\060\095\091\045\095\066\066\095\091\077\008\095\099\008\091\035\095\091\010\123\045\036\099\046")
_eT6x.Visible = false
_eT6x.Media = _GKkR
_eT6x.Icon = _BRA
_eT6x.Commands = {}
_eT6x.DistanceRange = Distance(-1, "feet")
_eT6x.ShowObjects = "OnEnter"
_eT6x.ProximityRange = Distance(60, "meters")
_eT6x.AllowSetPositionTo = false
_eT6x.Active = false
_eT6x.Points = {
	ZonePoint(48.3958671053379, -71.0427180512429, 0), 
	ZonePoint(48.3956408283453, -71.0428578581174, 0), 
	ZonePoint(48.3955185265409, -71.04246955835, 0), 
	ZonePoint(48.3957647015559, -71.0423318131449, 0)
}
_eT6x.OriginalPoint = ZonePoint(48.395697790445, -71.0425943202138, 0)
_eT6x.DistanceRangeUOM = "Feet"
_eT6x.ProximityRangeUOM = "Meters"
_eT6x.OutOfRangeName = ""
_eT6x.InRangeName = ""
__zg2 = Wherigo.Zone(_c4vM)
__zg2.Id = "3b4ad49e-3aab-400c-b5bd-b093686a2137"
__zg2.Name = _3UMLA("\010\095\091\039\105\084\045\095\084\123")
__zg2.Description = _3UMLA("\010\095\091\039\105\084\045\095\084\123\091\018\123\091\096\008\063\084\123\017\095\091\018\095\091\077\040\096\002\119\040\078\091\008\123\091\035\095\091\077\066\036\099\124\095\091\060\095\066\084\091\018\095\035\036\015\066\095\046")
__zg2.Visible = false
__zg2.Media = _R40
__zg2.Icon = _UI6
__zg2.Commands = {}
__zg2.DistanceRange = Distance(-1, "feet")
__zg2.ShowObjects = "OnEnter"
__zg2.ProximityRange = Distance(60, "meters")
__zg2.AllowSetPositionTo = false
__zg2.Active = false
__zg2.Points = {
	ZonePoint(48.3991038490964, -71.0465013070584, 0), 
	ZonePoint(48.3988036820772, -71.0464788402875, 0), 
	ZonePoint(48.3988968684586, -71.0456372471966, 0), 
	ZonePoint(48.399013027183, -71.0458508713724, 0), 
	ZonePoint(48.3991937381688, -71.0460090637208, 0), 
	ZonePoint(48.3991748858969, -71.0461814093907, 0)
}
__zg2.OriginalPoint = ZonePoint(48.3990310084801, -71.0461097898377, 0)
__zg2.DistanceRangeUOM = "Feet"
__zg2.ProximityRangeUOM = "Meters"
__zg2.OutOfRangeName = ""
__zg2.InRangeName = ""
_z7N = Wherigo.Zone(_c4vM)
_z7N.Id = "f6d61ad2-2cef-41e4-bffc-7c6d8c0b4602"
_z7N.Name = _3UMLA("\127\008\099\095\091\018\095\091\035\084\091\039\084\124\105\095")
_z7N.Description = _3UMLA("\077\095\066\036\017\095\045\066\095\091\008\123\091\095\060\045\091\060\036\045\123\095\091\035\095\091\124\008\099\045\095\099\084\099\045\091\018\123\091\124\084\066\099\095\045\091\018\095\091\015\036\060\036\045\095\046")
_z7N.Visible = false
_z7N.Media = _flcQf
_z7N.Icon = _iUhbO
_z7N.Commands = {}
_z7N.DistanceRange = Distance(-1, "feet")
_z7N.ShowObjects = "OnEnter"
_z7N.ProximityRange = Distance(60, "meters")
_z7N.AllowSetPositionTo = false
_z7N.Active = false
_z7N.Points = {
	ZonePoint(48.3965224846625, -71.0476305170537, 0), 
	ZonePoint(48.3964496024033, -71.0478900896391, 0), 
	ZonePoint(48.3962632635811, -71.0479741718132, 0), 
	ZonePoint(48.3961089066316, -71.0477830144085, 0), 
	ZonePoint(48.3961137217633, -71.0474520921706, 0), 
	ZonePoint(48.3963087326678, -71.0473152995109, 0), 
	ZonePoint(48.3964592200238, -71.0474239289759, 0)
}
_z7N.OriginalPoint = ZonePoint(48.3963179902476, -71.047638444796, 0)
_z7N.DistanceRangeUOM = "Feet"
_z7N.ProximityRangeUOM = "Meters"
_z7N.OutOfRangeName = ""
_z7N.InRangeName = ""

-- Characters --
_s2NLj = Wherigo.ZCharacter{
	Cartridge = _c4vM, 
	Container = _PBp3G
}
_s2NLj.Id = "e40632e8-2164-45c2-879d-f2db6e1a0bd6"
_s2NLj.Name = _3UMLA("\096\123\059\036\095\099")
_s2NLj.Description = _3UMLA("\096\123\059\036\095\099\091\035\095\091\017\084\081\036\124\036\095\099\091\084\091\059\095\084\123\124\008\123\115\091\018\095\091\015\095\124\123\091\095\045\091\036\035\091\124\008\099\099\084\036\045\091\059\095\084\123\124\008\123\115\091\115\035\123\060\091\018\095\091\017\084\081\036\095\091\108\123\095\091\015\008\123\060\091\099\095\091\115\008\123\066\066\036\095\062\091\035\073\036\017\084\081\036\099\095\066\046\091\096\123\059\036\095\099\091\095\060\045\091\060\095\099\060\036\059\035\095\091\095\045\091\084\091\060\095\066\015\036\091\084\015\095\124\091\100\036\018\095\035\036\045\095\091\035\095\091\096\008\063\084\123\017\095\046\091\002\035\091\060\095\017\059\035\095\091\100\066\084\081\036\035\095\091\017\084\036\060\091\060\036\091\015\008\123\060\091\035\123\036\091\100\084\036\045\095\060\091\124\008\099\100\036\084\099\124\095\126\091\036\035\091\099\095\091\015\008\123\060\091\035\084\036\060\060\095\066\084\091\115\084\060\091\045\008\017\059\095\066\046")
_s2NLj.Visible = true
_s2NLj.Media = _nMhUc
_s2NLj.Commands = {
	_t4jh = Wherigo.ZCommand{
		Text = _3UMLA("\042\100\100\066\008\099\045\095\066"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}, 
	_ep5B = Wherigo.ZCommand{
		Text = _3UMLA("\119\036\060\124\123\045\095\066"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _3UMLA("\118\008\045\105\036\099\081\091\084\015\084\036\035\084\059\035\095")
	}
}
_s2NLj.Commands._t4jh.Custom = true
_s2NLj.Commands._t4jh.Id = "0b3fb76b-d556-4280-a75a-210197a66e8c"
_s2NLj.Commands._t4jh.WorksWithAll = true
_s2NLj.Commands._ep5B.Custom = true
_s2NLj.Commands._ep5B.Id = "bc8b885c-6b44-4784-be30-e234b44a12a5"
_s2NLj.Commands._ep5B.WorksWithAll = true
_s2NLj.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_s2NLj.Gender = "Male"
_s2NLj.Type = "NPC"
_8Mqt = Wherigo.ZCharacter{
	Cartridge = _c4vM, 
	Container = _eT6x
}
_8Mqt.Id = "e64c434b-1f48-4967-b8e1-891203cc0e91"
_8Mqt.Name = _3UMLA("\077\008\095\099\008\091\035\095\091\010\123\045\036\099")
_8Mqt.Description = _3UMLA("\010\095\091\010\123\045\036\099\091\015\008\123\060\091\084\045\045\095\099\018\091\084\091\035\073\042\066\059\066\095\091\078\084\081\036\108\123\095\046")
_8Mqt.Visible = false
_8Mqt.Media = _Hq1Y
_8Mqt.Commands = {}
_8Mqt.ObjectLocation = ZonePoint(48.395721026304, -71.042658984661, 0)
_8Mqt.Gender = "Male"
_8Mqt.Type = "NPC"

-- Items --
_CKhcU = Wherigo.ZItem(_c4vM)
_CKhcU.Id = "80c2116e-1186-4047-a44e-5771f8dc433f"
_CKhcU.Name = _3UMLA("\039\035\095\091\018\123\091\096\008\063\084\123\017\095")
_CKhcU.Description = _3UMLA("\010\084\091\124\035\095\091\095\060\045\091\015\036\095\036\035\035\095\126\091\017\084\036\060\091\095\035\035\095\091\060\095\017\059\035\095\091\084\015\008\036\066\091\095\045\095\091\100\008\066\081\095\095\091\036\035\091\063\091\084\091\108\123\095\035\108\123\095\060\091\017\036\099\123\045\095\060\091\084\091\115\095\036\099\095\046\091\010\095\091\045\095\017\115\060\091\099\073\084\123\066\084\091\115\084\060\091\066\084\036\060\008\099\091\018\073\095\035\035\095\046\091\118\073\084\015\095\062\058\015\008\123\060\091\048\084\017\084\036\060\091\015\123\091\124\095\091\081\095\099\066\095\091\018\095\091\124\035\095\110\091\039\095\091\060\095\066\084\036\045\091\059\036\095\099\091\018\095\091\124\008\099\099\084\036\045\066\095\091\060\008\099\091\123\045\036\035\036\060\084\045\036\008\099\046")
_CKhcU.Visible = false
_CKhcU.Media = _bVkg
_CKhcU.Commands = {
	_uz1 = Wherigo.ZCommand{
		Text = _3UMLA("\077\066\095\099\018\066\095"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _3UMLA("\077\066\095\099\018\066\095\091\035\084\091\124\035\095\091\115\008\123\066\091\008\123\015\066\036\066\091\035\084\091\115\008\066\045\095\091\018\123\091\039\105\084\045\095\084\123\046")
	}, 
	_oE1 = Wherigo.ZCommand{
		Text = _3UMLA("\125\123\015\066\036\066\091\035\084\091\115\008\066\045\095"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _3UMLA("\010\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\091\099\073\084\091\108\123\073\123\099\095\091\060\095\123\035\095\091\100\008\099\124\045\036\008\099\001\091\065\099\059\060\115\019\008\123\015\066\036\066\091\035\084\091\115\008\066\045\095\091\018\123\091\018\008\099\081\095\008\099\046")
	}
}
_CKhcU.Commands._uz1.Custom = true
_CKhcU.Commands._uz1.Id = "ab643abb-e46c-4a05-acd9-ac6c91fcfb27"
_CKhcU.Commands._uz1.WorksWithAll = true
_CKhcU.Commands._oE1.Custom = true
_CKhcU.Commands._oE1.Id = "760d7d5e-1f18-4a5e-8161-8b067d2b26cb"
_CKhcU.Commands._oE1.WorksWithAll = true
_CKhcU.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_CKhcU.Locked = false
_CKhcU.Opened = false
_W2C = Wherigo.ZItem{
	Cartridge = _c4vM, 
	Container = _z7N
}
_W2C.Id = "e4eaf327-6c29-4fa1-bfb3-e17117be523e"
_W2C.Name = _3UMLA("\039\084\124\105\095")
_W2C.Description = _3UMLA("\010\084\091\124\084\124\105\095\091\095\060\045\091\095\099\100\036\099\091\015\036\060\036\059\035\095\046\091\002\035\091\099\095\091\066\095\060\045\095\091\108\123\073\084\091\060\073\063\091\066\095\099\018\066\095\091\095\045\091\060\036\081\099\095\066\091\035\095\091\124\084\066\099\095\045\091\018\095\091\015\036\060\036\045\095\046")
_W2C.Visible = false
_W2C.Media = _flcQf
_W2C.Commands = {
	_akm = Wherigo.ZCommand{
		Text = _3UMLA("\112\066\008\123\015\095\095"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _3UMLA("\096\036\095\099\091\084\091\045\066\008\123\015\095\066\091\036\124\036\046\091\127\008\099\095\091\018\095\091\035\084\091\124\084\124\105\095\091\060\095\123\035\095\017\095\099\045\046")
	}, 
	_X_wV = Wherigo.ZCommand{
		Text = _3UMLA("\077\084\060\091\045\066\008\123\015\095\095"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _3UMLA("\096\036\095\099\091\018\095\091\018\036\060\115\008\099\036\059\035\095\091\036\124\036\046\091\127\008\099\095\091\018\095\091\035\084\091\124\084\124\105\095\091\060\095\123\035\095\017\095\099\045\046")
	}
}
_W2C.Commands._akm.Custom = true
_W2C.Commands._akm.Id = "34ebe798-d135-4609-b6db-7288abfc6558"
_W2C.Commands._akm.WorksWithAll = true
_W2C.Commands._X_wV.Custom = true
_W2C.Commands._X_wV.Id = "5b455315-146a-4ebc-9d86-3b77d37281ae"
_W2C.Commands._X_wV.WorksWithAll = true
_W2C.ObjectLocation = ZonePoint(48.3962833333333, -71.0476666666667, 0)
_W2C.Locked = false
_W2C.Opened = false
_QofY = Wherigo.ZItem(_c4vM)
_QofY.Id = "4003ef45-053f-4097-b3f3-08a1f889cefd"
_QofY.Name = _3UMLA("\039\008\018\095\091\016\040\099\035\008\124\089\016")
_QofY.Description = ""
_QofY.Visible = false
_QofY.Media = _waa
_QofY.Commands = {}
_QofY.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_QofY.Locked = false
_QofY.Opened = false

-- Tasks --
_uc2rF = Wherigo.ZTask(_c4vM)
_uc2rF.Id = "0382cf32-29cf-4b95-a14f-51bf5cfd6728"
_uc2rF.Name = _3UMLA("\112\066\084\015\095\066\060\095\066\091\035\095\091\092\066\095\008\099")
_uc2rF.Description = _3UMLA("\112\066\084\015\095\066\060\095\066\091\035\095\091\077\008\099\045\091\095\045\091\035\095\091\124\008\123\066\084\099\045\091\018\123\091\092\066\095\008\099\046")
_uc2rF.Visible = true
_uc2rF.Media = _WvfC
_uc2rF.Icon = _EFv
_uc2rF.Active = true
_uc2rF.Complete = false
_uc2rF.CorrectState = "None"
_Am_D = Wherigo.ZTask(_c4vM)
_Am_D.Id = "c7c2435c-acb9-46e9-a1a8-991f848348ec"
_Am_D.Name = _3UMLA("\125\123\015\066\036\066\091\035\084\091\115\008\066\045\095\091\018\123\091\039\105\084\045\095\084\123")
_Am_D.Description = _3UMLA("\125\123\015\066\036\066\091\035\084\091\115\008\066\045\095\091\018\123\091\039\105\084\045\095\084\123\091\018\123\091\096\008\036\091\018\095\124\105\123\091\095\045\091\066\095\045\084\059\035\036\066\091\035\084\091\115\084\036\103\091\018\123\091\096\008\063\084\123\017\095\046")
_Am_D.Visible = true
_Am_D.Media = _R40
_Am_D.Icon = _EFv
_Am_D.Active = true
_Am_D.Complete = false
_Am_D.CorrectState = "None"
_ajK = Wherigo.ZTask(_c4vM)
_ajK.Id = "93c9042a-2afe-4557-ac69-810cdb17bd28"
_ajK.Name = _3UMLA("\112\066\008\123\015\095\066\091\035\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095")
_ajK.Description = _3UMLA("\112\066\008\123\015\095\066\091\035\084\091\017\063\060\045\095\066\036\095\123\060\095\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\091\108\123\095\091\096\123\059\036\095\099\091\015\008\123\060\091\084\091\018\095\124\066\036\045\046")
_ajK.Visible = true
_ajK.Media = _bVkg
_ajK.Icon = _EFv
_ajK.Active = true
_ajK.Complete = false
_ajK.CorrectState = "None"
_WPWF = Wherigo.ZTask(_c4vM)
_WPWF.Id = "33880e01-79f0-40f3-913d-a55f27024e66"
_WPWF.Name = _3UMLA("\119\036\060\124\123\045\095\066\091\084\015\095\124\091\035\095\091\078\084\081\036\124\036\095\099")
_WPWF.Description = _3UMLA("\112\066\008\123\015\095\066\091\096\123\059\036\095\099\091\035\095\091\078\084\081\036\124\036\095\099\091\095\045\091\018\036\060\124\123\045\095\066\091\084\015\095\124\091\035\123\036\046")
_WPWF.Visible = true
_WPWF.Media = _nMhUc
_WPWF.Icon = _EFv
_WPWF.Active = true
_WPWF.Complete = false
_WPWF.CorrectState = "NotCorrect"
_qiI3 = Wherigo.ZTask(_c4vM)
_qiI3.Id = "8bdd752d-87d1-4ced-9700-3cea7885b66a"
_qiI3.Name = _3UMLA("\112\066\008\123\015\095\066\091\035\084\091\124\084\124\105\095")
_qiI3.Description = _3UMLA("\119\095\066\099\036\095\066\095\091\095\045\091\123\035\045\036\017\095\091\045\084\124\105\095\091\084\091\084\124\124\008\017\115\035\036\066\046")
_qiI3.Visible = true
_qiI3.Media = _flcQf
_qiI3.Icon = _EFv
_qiI3.Active = true
_qiI3.Complete = false
_qiI3.CorrectState = "None"

-- Cartridge Variables --
_iR_VP = _3UMLA("\096\123\059\036\095\099")
_UtJ = _3UMLA("\004\127\089\082\082\119")
_YrF = _3UMLA("\004\060\055\118\010\048")
_61Zl = _3UMLA("\004\039\041\105\124\040")
_qX1Wu = _3UMLA("\004\123\124\055\066\031")
_aDLAz = _3UMLA("\004\082\106\082")
_2ACv = _3UMLA("\004\041\096\010")
_c4vM.ZVariables = {
	_iR_VP = _3UMLA("\096\123\059\036\095\099"), 
	_UtJ = _3UMLA("\004\127\089\082\082\119"), 
	_YrF = _3UMLA("\004\060\055\118\010\048"), 
	_61Zl = _3UMLA("\004\039\041\105\124\040"), 
	_qX1Wu = _3UMLA("\004\123\124\055\066\031"), 
	_aDLAz = _3UMLA("\004\082\106\082"), 
	_2ACv = _3UMLA("\004\041\096\010")
}

-- Timers --
_KRL = Wherigo.ZTimer(_c4vM)
_KRL.Id = "fa14c9d3-8d38-4e01-a450-1415fb61c3c2"
_KRL.Name = _3UMLA("\039\105\008\099\008\091\060\008\066\045\036\095\091\018\123\091\077\008\099\045")
_KRL.Description = _3UMLA("\040\099\091\124\105\066\008\099\008\091\018\095\091\087\106\091\060\095\124\008\099\018\095\060\091\084\115\066\095\060\091\095\045\066\095\091\060\008\066\045\036\095\091\018\095\091\035\084\091\062\008\099\095\091\077\008\099\045\091\018\123\091\092\066\095\008\099\046")
_KRL.Visible = true
_KRL.Duration = 10
_KRL.Type = "Countdown"

-- Inputs --
_E0E = Wherigo.ZInput(_c4vM)
_E0E.Id = "aaad12b3-031e-42ea-afbe-7dfeac6c9b29"
_E0E.Name = _3UMLA("\014\123\036\091\015\008\123\060\091\095\099\015\008\036\095\091\036\124\036\110")
_E0E.Description = _3UMLA("\014\123\095\060\045\036\008\099\091\018\095\091\077\008\095\099\008\046")
_E0E.Visible = true
_E0E.Media = _l3te
_E0E.Choices = {
	"Danatisy", 
	"Rubien", 
	"Poeno"
}
_E0E.InputType = "MultipleChoice"
_E0E.Text = _3UMLA("\014\123\036\091\015\008\123\060\091\095\099\015\008\036\095\091\036\124\036\110")

-- WorksWithList for object commands --

-- functions --
function _c4vM:OnStart()
	_ZkEED.Active = true
	_ZkEED.Visible = true
	_Urwigo.MessageBox{
		Text = (_3UMLA("\092\008\099\048\008\123\066\091")..Player.Name).._3UMLA("\126\098\092\096\012\104\008\045\066\095\091\017\036\060\060\036\008\099\126\091\060\036\091\015\008\123\060\091\035\073\084\124\124\095\115\045\095\062\126\091\124\008\099\060\036\060\045\095\066\084\091\084\091\035\036\059\095\066\095\066\091\035\095\091\096\008\063\084\123\017\095\091\018\095\091\077\040\096\002\119\040\078\046\091\096\095\099\018\095\062\058\015\008\123\060\091\015\095\066\060\091\035\084\091\062\008\099\095\091\119\095\115\084\066\045\046\091\104\008\123\060\091\100\095\066\095\062\091\124\008\099\099\084\036\060\060\084\099\124\095\091\084\015\095\124\091\035\095\060\091\095\035\095\017\095\099\045\060\091\018\095\091\124\095\091\048\095\123\046"), 
		Buttons = {
			_3UMLA("\039\073\095\060\045\091\123\099\091\018\095\115\084\066\045\046\046\046")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _ZkEED)
			end
		end
	}
end
function _c4vM:OnRestore()
end
function _ZkEED:OnEnter()
	_UtJ = _3UMLA("\004\127\089\082\082\119")
	_PBp3G.Active = true
	_PBp3G.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _3UMLA("\078\008\099\091\099\008\017\091\095\060\045\091\119\084\099\084\045\036\060\063\046\091\052\073\084\036\091\115\066\008\081\066\084\017\017\095\091\124\095\045\045\095\091\124\084\066\045\008\123\124\105\095\091\115\008\123\066\091\015\008\045\066\095\091\115\035\084\036\060\036\066\046\091\065\099\059\060\115\019\052\095\091\015\008\123\060\091\115\066\095\060\095\099\045\095\091\084\091\035\073\084\015\084\099\124\095\091\035\095\060\091\115\095\066\060\008\099\099\084\081\095\060\091\095\045\091\008\059\048\095\045\060\091\108\123\095\091\015\008\123\060\091\066\095\099\124\008\099\045\066\095\066\095\062\046"), 
			Media = _C1Eb
		}, 
		{
			Text = _3UMLA("\078\008\036\126\091\119\084\099\084\045\036\060\063\046\046\046"), 
			Media = _C1Eb
		}, 
		{
			Text = _3UMLA("\010\095\091\052\008\123\095\123\066\091\061\104\008\123\060\097\091\060\095\066\084\091\066\095\115\066\095\060\095\099\045\095\091\115\084\066\091\124\095\045\045\095\091\036\124\008\099\095\046"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\096\123\059\036\095\099\126\091\035\095\091\078\084\081\036\124\036\095\099\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\104\008\123\060\091\018\095\015\066\095\062\091\059\036\095\099\045\008\045\091\015\008\123\060\091\066\095\099\018\066\095\091\084\091\010\084\091\039\035\084\036\066\036\095\066\095\046"), 
			Media = _qwfpX
		}, 
		{
			Text = _3UMLA("\069\095\035\008\099\091\015\008\045\066\095\091\124\008\017\115\008\066\045\095\017\095\099\045\126\091\015\008\123\060\091\084\123\066\095\062\091\115\095\123\045\058\095\045\066\095\091\084\091\100\066\084\099\124\105\036\066\091\123\099\091\115\008\099\045\046"), 
			Media = _WvfC
		}, 
		{
			Text = _3UMLA("\096\123\059\036\095\099\091\010\095\091\078\084\081\036\124\036\095\099\091\105\084\059\036\045\095\091\035\095\091\116\008\123\066\059\036\046"), 
			Media = _JFP
		}, 
		{
			Text = _3UMLA("\077\123\036\060\091\084\035\035\095\066\091\015\095\066\060\091\035\073\042\066\059\066\095\091\018\095\091\077\008\095\099\008\046\046\046"), 
			Media = _GKkR
		}, 
		{
			Text = _3UMLA("\046\046\046\018\084\099\060\091\115\035\123\060\036\095\123\066\060\091\105\036\060\045\008\036\066\095\060\091\008\123\091\035\084\091\017\084\081\036\095\091\095\103\036\060\045\095\126\091\036\035\091\063\091\123\099\091\035\123\045\036\099\046\091\069\008\099\091\099\008\017\091\095\060\045\091\077\008\095\099\008\046"), 
			Media = _Hq1Y
		}, 
		{
			Text = _3UMLA("\010\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\091\015\008\123\060\091\060\095\066\084\091\124\095\066\045\084\036\099\095\017\095\099\045\091\123\045\036\035\095\046\046\046"), 
			Media = _bVkg
		}, 
		{
			Text = _3UMLA("\046\046\046\115\008\123\066\091\008\123\015\066\036\066\091\035\084\091\115\008\066\045\095\091\018\123\091\039\105\084\045\095\084\123\046"), 
			Media = _R40
		}, 
		{
			Text = _3UMLA("\042\091\035\084\091\100\036\099\084\035\095\126\091\015\008\123\060\091\066\095\124\095\015\066\095\062\091\123\099\091\124\008\018\095\091\016\040\099\035\008\124\089\016\091\095\045\091\045\066\008\123\015\095\066\095\062\046\046\046"), 
			Media = _waa
		}, 
		{
			Text = _3UMLA("\046\046\046\091\123\099\095\091\124\084\124\105\095\046"), 
			Media = _flcQf
		}, 
		{
			Text = _3UMLA("\096\095\099\018\008\099\060\058\099\008\123\060\091\017\084\036\099\045\095\099\084\099\045\091\015\095\066\060\091\035\084\091\115\066\008\124\105\084\036\099\095\091\095\045\084\115\095\046\091\052\073\084\036\091\084\124\045\036\015\095\091\035\084\091\062\008\099\095\091\016\010\084\091\039\035\084\036\066\036\095\066\095\016\046\091\039\105\008\036\060\036\060\060\095\062\091\124\095\045\045\095\091\062\008\099\095\091\115\008\123\066\091\015\008\123\060\091\063\091\081\123\036\018\095\066\046"), 
			Media = _C1Eb
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _PBp3G)
	end)
end
function _ZkEED:OnExit()
	_UtJ = _3UMLA("\004\127\089\082\082\119")
	_c4vM:RequestSync()
end
function _PBp3G:OnEnter()
	_UtJ = _3UMLA("\004\077\092\115\075\116")
	_Urwigo.MessageBox{
		Text = _3UMLA("\092\036\095\099\015\095\099\123\095\091\018\084\099\060\091\010\084\091\039\035\084\036\066\036\095\066\095\046\091\065\099\059\060\115\019\052\095\091\015\008\123\060\091\036\099\015\036\045\095\091\084\091\100\084\036\066\095\091\124\008\099\099\084\036\060\060\084\099\124\095\091\084\015\095\124\091\096\123\059\036\095\099\091\035\095\091\078\084\081\036\124\036\095\099\046"), 
		Media = _C1Eb, 
		Buttons = {
			_3UMLA("\096\095\099\124\008\099\045\066\095\062\091\096\123\059\036\095\099\046\046\046")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _s2NLj)
			end
		end
	}
end
function _PBp3G:OnExit()
	_UtJ = _3UMLA("\004\077\092\115\075\116")
	_ZkEED.Active = false
	_PBp3G.Active = false
	_WPWF.Complete = true
end
function _hMA:OnEnter()
	_UtJ = _3UMLA("\004\105\078\042")
	_DczE.Active = true
	_DczE.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _3UMLA("\069\036\091\015\008\123\060\091\095\045\095\060\091\036\124\036\126\091\124\073\095\060\045\091\108\123\095\091\015\008\123\060\091\084\015\036\095\062\091\059\095\060\008\036\099\091\018\095\091\060\008\036\099\060\046\091\010\095\091\092\066\095\008\099\091\084\091\124\095\091\115\008\123\015\008\036\066\091\018\095\091\081\123\095\066\036\066\091\095\099\091\035\095\091\045\066\084\015\095\066\060\084\099\045\091\060\036\017\115\035\095\017\095\099\045\046\091\065\099\059\060\115\019\104\008\123\060\091\095\045\095\060\091\115\066\095\045\091\084\091\124\008\099\045\036\099\123\095\066\091\015\095\066\060\091\035\095\091\116\008\123\066\059\036\091\018\095\091\096\123\059\036\095\099\046"), 
			Media = _C1Eb
		}, 
		{
			Text = _3UMLA("\096\095\045\066\084\015\095\066\060\095\062\091\035\095\091\115\008\099\045\091\115\008\123\066\091\066\095\045\008\123\066\099\095\066\091\084\123\091\060\095\099\045\036\095\066\046"), 
			Media = _C1Eb
		}, 
		{
			Text = _3UMLA("\096\123\059\036\095\099\091\099\073\095\060\045\091\115\084\060\091\066\084\099\124\123\099\036\095\066\046\091\065\099\059\060\115\019\039\105\095\017\036\099\091\100\084\036\060\084\099\045\091\095\099\091\035\008\099\081\095\084\099\045\091\035\084\091\066\036\015\036\095\066\095\091\095\099\091\084\017\008\099\045\126\091\015\008\123\060\091\115\008\123\066\066\095\062\091\018\036\060\124\123\045\095\066\091\084\015\095\124\091\035\123\036\046\091\096\095\099\018\095\062\058\015\008\123\060\091\015\095\066\060\091\035\095\091\116\008\123\066\059\036\046"), 
			Media = _C1Eb
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _DczE)
	end)
end
function _hMA:OnExit()
	_UtJ = _3UMLA("\004\105\078\042")
	_Urwigo.Dialog(false, {
		{
			Text = _3UMLA("\096\123\059\036\095\099\126\091\095\060\045\058\124\095\091\108\123\095\091\048\095\091\115\095\123\103\091\015\008\123\060\091\115\008\060\095\066\091\108\123\095\035\108\123\095\060\091\108\123\095\060\045\036\008\099\060\110"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\092\036\095\099\091\060\123\066\091\017\008\099\091\084\017\036\046\091\065\099\059\060\115\019\052\095\091\060\123\036\060\091\105\095\123\066\095\123\103\091\018\095\091\015\008\123\060\091\066\095\099\124\008\099\045\066\095\066\091\095\045\091\048\073\084\036\091\095\015\036\018\095\017\017\095\099\045\091\018\123\091\045\095\017\115\060\091\084\091\015\008\123\060\091\084\124\124\008\066\018\095\066\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\031\100\100\036\008\123\046\046\046\091\052\095\091\060\123\036\060\091\124\008\099\045\095\099\045\091\108\123\095\091\015\008\123\060\091\060\008\063\095\062\091\123\099\091\081\095\099\045\036\035\091\078\084\081\036\124\036\095\099\046\091\065\099\059\060\115\019\052\095\091\124\066\008\063\084\036\060\091\108\123\095\091\015\008\123\060\091\095\045\036\095\062\091\095\099\091\124\008\035\095\066\095\091\095\099\015\095\066\060\091\017\008\036\091\095\045\091\108\123\095\091\015\008\123\060\046\046\046"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\077\008\123\066\108\123\008\036\091\060\095\066\084\036\060\058\048\095\091\095\099\091\124\008\035\095\066\095\110\091\065\099\059\060\115\019\104\008\123\060\091\060\095\017\059\035\095\062\091\081\095\099\045\036\035\091\095\045\091\048\095\091\099\095\091\015\008\036\060\091\115\084\060\091\018\095\091\066\084\036\060\008\099\091\018\095\091\015\008\123\060\091\095\100\100\066\084\063\095\066\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\040\099\095\091\124\105\084\099\124\095\051\091\065\099\059\060\115\019\077\123\036\060\058\048\095\091\015\008\123\060\091\115\008\060\095\066\091\123\099\095\091\108\123\095\060\045\036\008\099\091\018\036\066\095\124\045\095\091\108\123\036\091\115\008\123\066\066\084\036\045\091\015\008\123\060\091\060\095\017\059\035\095\066\091\095\045\066\084\099\081\095\110"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\104\084\060\058\063\046\091\104\008\063\008\099\060\091\124\095\091\108\123\095\091\048\095\091\115\095\123\103\091\045\073\084\115\115\066\095\099\018\066\095\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\052\095\091\060\123\036\060\091\095\099\091\017\036\060\060\036\008\099\091\115\008\123\066\091\060\084\123\015\095\066\091\035\095\091\096\008\063\084\123\017\095\126\091\017\084\036\060\091\048\095\091\099\073\084\036\091\084\123\124\123\099\095\091\036\018\095\095\091\124\008\017\017\095\099\045\091\063\091\084\066\066\036\015\095\066\046\091\077\008\123\066\066\036\095\062\058\015\008\123\060\091\017\095\091\018\036\066\095\091\115\084\066\091\008\123\091\124\008\017\017\095\099\124\095\066\110"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\039\073\095\060\045\091\123\099\095\091\108\123\095\060\045\036\008\099\091\115\084\060\091\018\123\091\045\008\123\045\091\095\045\066\084\099\081\095\046\091\010\095\091\096\008\063\084\123\017\095\091\084\091\018\095\060\095\060\115\095\066\095\017\095\099\045\091\059\095\060\008\036\099\091\018\073\084\036\018\095\046\091\052\095\091\060\123\036\060\091\105\095\123\066\095\123\103\091\108\123\095\091\015\008\123\060\091\060\008\063\095\062\091\036\099\045\095\066\095\060\060\095\091\084\091\035\073\084\036\018\095\066\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\010\095\091\096\008\063\084\123\017\095\091\095\060\045\091\095\099\091\017\084\123\015\084\036\060\091\095\045\084\045\091\115\084\066\124\095\091\108\123\095\091\035\095\091\078\084\081\036\124\036\095\099\091\118\008\036\066\091\084\091\084\060\060\084\060\060\036\099\095\091\035\095\091\015\036\095\123\103\091\066\008\036\091\095\045\091\115\095\066\060\008\099\099\095\091\099\073\084\091\115\066\036\060\091\035\084\091\066\095\035\095\015\095\091\018\123\091\045\066\008\099\095\046\091\077\084\066\124\095\091\108\123\095\091\035\095\060\091\017\084\081\036\124\036\095\099\060\091\099\095\091\115\095\123\015\095\099\045\091\060\073\084\100\100\066\008\099\045\095\066\091\095\099\045\066\095\091\095\123\103\126\091\036\035\091\100\084\123\045\091\123\099\091\017\008\066\045\095\035\091\045\095\035\091\108\123\095\091\015\008\123\060\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\069\036\091\015\008\123\060\091\115\008\123\015\036\095\062\091\035\036\059\095\066\095\066\091\035\095\091\048\095\123\099\095\091\115\066\036\099\124\095\091\018\123\091\018\008\099\081\095\008\099\091\084\123\091\039\105\084\045\095\084\123\126\091\015\008\123\060\091\066\095\099\018\066\036\095\062\091\123\099\091\100\036\095\066\091\060\095\066\015\036\124\095\091\084\091\035\084\091\118\084\045\036\008\099\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\039\095\035\084\091\060\095\017\059\035\095\091\100\084\060\124\036\099\084\099\045\126\091\017\084\036\060\091\099\095\091\115\095\099\060\095\062\058\015\008\123\060\091\115\084\060\091\108\123\095\091\108\123\095\035\108\123\073\123\099\091\018\073\084\123\045\066\095\091\115\008\123\066\066\084\036\045\091\066\095\084\035\036\060\095\066\091\124\095\045\091\084\124\045\095\091\105\095\066\008\036\108\123\095\110\091\010\095\091\018\008\099\081\095\008\099\091\017\084\081\036\108\123\095\091\115\084\066\066\084\036\045\091\018\084\099\081\095\066\095\123\103\046\091\002\035\091\060\095\066\084\036\045\091\115\066\095\100\095\066\084\059\035\095\091\108\123\095\091\048\095\091\066\095\045\008\123\066\099\095\091\124\105\095\062\091\017\008\036\091\095\099\091\060\095\124\123\066\036\045\095\046\091\039\095\091\100\123\045\091\123\099\091\115\035\084\036\060\036\066\091\018\095\091\100\084\036\066\095\091\015\008\045\066\095\091\124\008\099\099\084\036\060\060\084\099\124\095\046"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\042\045\045\095\099\018\095\062\051\091\104\008\123\060\091\084\015\095\062\091\124\008\017\017\095\099\124\095\091\084\091\048\008\123\095\066\091\124\095\045\045\095\091\124\084\066\045\008\123\124\105\095\126\091\015\008\123\060\091\018\095\015\095\062\091\035\084\091\045\095\066\017\036\099\095\066\046\091\104\008\123\060\091\099\095\091\115\095\099\060\095\062\091\045\008\123\045\091\018\095\091\017\095\017\095\091\115\084\060\091\108\123\095\091\048\095\091\015\084\036\060\091\018\095\017\095\123\066\095\066\091\036\124\036\091\115\008\123\066\091\095\099\124\008\066\095\091\018\095\060\091\018\095\124\095\099\099\036\095\060\110"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\011\123\017\017\046\046\046\091\125\041\046\091\014\123\095\091\018\008\036\060\058\048\095\091\100\084\036\066\095\110"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\039\073\095\060\045\091\066\095\035\084\045\036\015\095\017\095\099\045\091\060\036\017\115\035\095\046\091\104\008\123\060\091\018\095\015\066\095\062\091\015\008\123\060\091\066\095\099\018\066\095\091\015\095\066\060\091\035\073\042\066\059\066\095\091\018\095\091\077\008\095\099\008\091\095\045\091\045\066\008\123\015\095\066\091\035\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\010\084\091\039\035\095\091\060\073\036\099\060\095\066\095\091\018\084\099\060\091\035\095\091\115\008\066\045\095\091\018\123\091\039\105\084\045\095\084\123\091\095\045\091\123\099\095\091\100\008\036\060\091\018\095\015\095\066\066\008\123\035\035\095\095\126\091\035\095\091\115\066\036\099\124\095\091\060\095\066\084\091\035\036\059\066\095\091\095\045\091\115\008\123\066\066\084\091\066\095\081\099\095\066\091\060\123\066\091\035\095\091\096\008\063\084\123\017\095\046\091\039\073\095\060\045\091\045\008\123\045\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\042\105\051\091\039\073\095\060\045\091\115\035\123\060\091\060\036\017\115\035\095\091\108\123\095\091\048\095\091\099\095\091\035\073\095\060\115\095\066\084\036\045\046\091\125\123\091\115\123\036\060\058\048\095\091\045\066\008\123\015\095\066\091\035\073\042\066\059\066\095\091\018\095\091\077\008\095\099\008\110"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\039\008\099\045\036\099\123\008\099\060\091\035\095\091\035\008\099\081\091\018\095\091\035\084\091\066\036\015\036\095\066\095\091\048\123\060\108\123\073\084\091\017\008\099\091\116\008\123\066\059\036\046\091\052\095\091\015\008\123\060\091\063\091\036\099\018\036\108\123\095\066\084\036\091\035\095\091\124\105\095\017\036\099\046"), 
			Media = _nMhUc
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _DczE)
	end)
	_uc2rF.Complete = true
	_hMA.Active = false
end
function _DczE:OnEnter()
	_UtJ = _3UMLA("\004\119\124\062\082")
	_eT6x.Active = true
	_eT6x.Visible = true
	_Urwigo.MessageBox{
		Text = _3UMLA("\118\008\123\060\091\015\008\036\124\036\091\066\095\099\018\123\091\084\091\017\008\099\091\116\008\123\066\059\036\046\091\065\099\059\060\115\019\104\008\123\060\091\018\095\015\095\062\091\017\084\036\099\045\095\099\084\099\045\091\045\066\008\123\015\095\066\091\035\095\091\010\123\045\036\099\091\077\008\095\099\008\046\091\039\073\095\060\045\091\035\123\036\091\108\123\036\091\084\091\035\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\046\091\065\099\059\060\115\019\052\073\084\036\091\084\124\045\036\015\095\091\035\084\091\062\008\099\095\091\010\073\042\066\059\066\095\091\018\095\091\077\008\095\099\008\091\095\045\091\015\008\123\060\091\115\008\123\015\095\062\091\015\008\123\060\091\063\091\066\095\099\018\066\095\091\095\099\091\035\084\091\060\095\035\095\124\045\036\008\099\099\084\099\045\091\018\084\099\060\091\035\084\091\060\095\124\045\036\008\099\091\016\010\036\095\123\103\016\091\018\095\091\015\008\045\066\095\091\116\077\069\046\091\042\045\045\095\099\045\036\008\099\051\091\077\008\095\099\008\091\095\060\045\091\123\099\091\124\008\108\123\036\099\046\091\069\008\063\095\062\091\060\123\066\091\015\008\060\091\081\084\066\018\095\060\051"), 
		Media = _nMhUc, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _DczE:OnExit()
	_UtJ = _3UMLA("\004\119\124\062\082")
	_c4vM:RequestSync()
end
function _eT6x:OnEnter()
	_UtJ = _3UMLA("\004\095\112\013\103")
	_8Mqt.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _3UMLA("\014\123\036\091\015\084\091\035\084\110"), 
			Media = _Hq1Y
		}, 
		{
			Text = _3UMLA("\039\073\095\060\045\091\017\008\036\126\091\035\095\091\052\008\123\095\123\066\046\091\052\095\091\060\123\036\060\091\095\099\091\017\036\060\060\036\008\099\091\115\008\123\066\091\060\084\123\015\095\066\091\035\095\091\096\008\063\084\123\017\095\046"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\042\105\091\059\008\099\051\091\082\045\091\124\008\017\017\095\099\045\091\115\095\099\060\095\062\058\015\008\123\060\091\063\091\084\066\066\036\015\095\066\110"), 
			Media = _Hq1Y
		}, 
		{
			Text = _3UMLA("\125\099\091\017\073\084\091\018\036\045\091\108\123\095\091\048\095\091\018\095\015\084\036\060\091\066\095\124\123\115\095\066\095\066\091\123\099\095\091\124\035\095\091\084\091\124\095\045\091\095\099\018\066\008\036\045\126\091\017\084\036\060\091\048\095\091\099\073\084\036\091\084\123\124\123\099\091\084\123\045\066\095\091\036\099\018\036\124\095\046"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\052\095\091\060\123\036\060\091\095\099\091\115\008\060\060\095\060\060\036\008\099\091\018\095\091\035\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\126\091\017\084\036\060\091\115\008\123\066\091\015\008\123\060\091\035\084\091\066\095\017\095\045\045\066\095\091\048\095\091\018\008\036\060\091\017\073\084\060\060\123\066\095\066\091\108\123\095\091\015\008\123\060\091\095\045\095\060\091\059\036\095\099\091\035\084\091\059\008\099\099\095\091\115\095\066\060\008\099\099\095\091\095\099\091\017\036\060\060\036\008\099\091\018\095\091\060\084\123\015\095\045\084\081\095\091\018\123\091\096\008\063\084\123\017\095\046"), 
			Media = _Hq1Y
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_E0E)
		end)
	end)
end
function _eT6x:OnExit()
	_UtJ = _3UMLA("\004\095\112\013\103")
	_ajK.Complete = true
	_DczE.Visible = false
	_DczE.Active = false
	_c4vM:RequestSync()
end
function __zg2:OnEnter()
	_UtJ = _3UMLA("\004\004\062\081\055")
	_eT6x.Active = false
	_eT6x.Visible = false
	_Urwigo.MessageBox{
		Text = _3UMLA("\104\008\123\060\091\095\045\095\060\091\084\066\066\036\015\095\091\084\123\091\039\105\084\045\095\084\123\091\018\123\091\096\008\063\084\123\017\095\091\018\095\091\077\040\096\002\119\040\078\046\091\065\099\059\060\115\019\104\008\123\060\091\115\008\123\015\095\062\091\066\095\115\066\095\099\018\066\095\091\035\084\091\039\035\095\091\095\045\091\008\123\015\066\036\066\091\035\084\091\115\008\066\045\095\091\018\123\091\039\105\084\045\095\084\123\046"), 
		Media = _sqS7B, 
		Buttons = {
			_3UMLA("\039\035\095\091\018\123\091\096\008\063\084\123\017\095\046\046\046")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _CKhcU)
			end
		end
	}
end
function __zg2:OnExit()
	_UtJ = _3UMLA("\004\004\062\081\055")
	__zg2.Active = false
	__zg2.Visible = false
	_CKhcU.Visible = false
	_W2C:MoveTo(_z7N)
	_W2C.Visible = true
	_c4vM:RequestSync()
end
function _z7N:OnEnter()
	_UtJ = _3UMLA("\004\062\070\118")
	_W2C.Visible = true
	_W2C.Commands._akm.Enabled = true
	_W2C.Commands._X_wV.Enabled = true
	_Urwigo.MessageBox{
		Text = _3UMLA("\104\008\123\060\091\015\008\036\124\036\091\095\099\100\036\099\091\084\091\035\073\036\099\045\095\066\036\095\123\066\091\018\123\091\115\095\066\036\017\095\045\066\095\091\008\123\091\060\095\091\045\066\008\123\015\095\091\035\084\091\124\084\124\105\095\046\091\039\105\008\036\060\036\066\091\016\039\084\124\105\095\046\046\046\016\091\115\008\123\066\091\015\008\123\060\091\066\095\099\018\066\095\091\084\123\091\115\008\036\099\045\091\062\095\066\008\046\046\046"), 
		Media = _C1Eb, 
		Buttons = {
			_3UMLA("\039\084\124\105\095\046\046\046")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _W2C)
			end
		end
	}
end
function _E0E:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_iR_VP = input
	if Wherigo.NoCaseEquals(_iR_VP, _3UMLA("\096\123\059\036\095\099")) then
		_CKhcU:MoveTo(Player)
		Wherigo.PlayAudio(_l592)
		_Urwigo.MessageBox{
			Text = _3UMLA("\092\008\099\099\095\091\066\095\115\008\099\060\095\046\091\010\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\091\015\008\123\060\091\084\115\115\084\066\045\036\095\099\045\046\091\104\008\123\060\091\115\008\123\015\095\062\091\035\084\091\115\066\095\099\018\066\095\091\084\091\115\084\066\045\036\066\091\018\095\091\035\084\091\060\095\124\045\036\008\099\091\016\002\099\015\095\099\045\084\036\066\095\016\091\018\095\091\015\008\045\066\095\091\116\077\069\046"), 
			Media = _Hq1Y, 
			Callback = function(action)
				if action ~= nil then
					_CKhcU.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		Wherigo.PlayAudio(_byfLx)
		_Urwigo.MessageBox{
			Text = _3UMLA("\011\123\017\017\051\091\078\084\123\015\084\036\060\095\091\066\095\115\008\099\060\095\046\091\082\060\060\084\063\095\062\091\018\095\091\099\008\123\015\095\084\123\046\046\046"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_E0E)
					end)
				end
			end
		}
	end
end
function _KRL:OnStart()
	_Urwigo.Dialog(false, {
		{
			Text = _3UMLA("\096\123\059\036\095\099\126\091\095\060\045\058\124\095\091\108\123\095\091\048\095\091\115\095\123\103\091\015\008\123\060\091\115\008\060\095\066\091\108\123\095\035\108\123\095\060\091\108\123\095\060\045\036\008\099\060\110"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\092\036\095\099\091\060\123\066\091\017\008\099\091\084\017\036\046\091\065\099\059\060\115\019\052\095\091\060\123\036\060\091\105\095\123\066\095\123\103\091\018\095\091\015\008\123\060\091\066\095\099\124\008\099\045\066\095\066\091\095\045\091\048\073\084\036\091\095\015\036\018\095\017\017\095\099\045\091\018\123\091\045\095\017\115\060\091\084\091\015\008\123\060\091\084\124\124\008\066\018\095\066\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\031\100\100\036\008\123\046\046\046\091\052\095\091\060\123\036\060\091\124\008\099\045\095\099\045\091\108\123\095\091\015\008\123\060\091\060\008\063\095\062\091\123\099\091\081\095\099\045\036\035\091\078\084\081\036\124\036\095\099\046\091\065\099\059\060\115\019\052\095\091\124\066\008\063\084\036\060\091\108\123\095\091\015\008\123\060\091\095\045\036\095\062\091\095\099\091\124\008\035\095\066\095\091\095\099\015\095\066\060\091\017\008\036\091\095\045\091\108\123\095\091\015\008\123\060\046\046\046"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\077\008\123\066\108\123\008\036\091\060\095\066\084\036\060\058\048\095\091\095\099\091\124\008\035\095\066\095\110\091\065\099\059\060\115\019\104\008\123\060\091\060\095\017\059\035\095\062\091\081\095\099\045\036\035\091\095\045\091\048\095\091\099\095\091\015\008\036\060\091\115\084\060\091\018\095\091\066\084\036\060\008\099\091\018\095\091\015\008\123\060\091\095\100\100\066\084\063\095\066\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\040\099\095\091\124\105\084\099\124\095\051\091\065\099\059\060\115\019\077\123\036\060\058\048\095\091\015\008\123\060\091\115\008\060\095\066\091\123\099\095\091\108\123\095\060\045\036\008\099\091\018\036\066\095\124\045\095\091\108\123\036\091\115\008\123\066\066\084\036\045\091\015\008\123\060\091\060\095\017\059\035\095\066\091\095\045\066\084\099\081\095\110"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\104\084\060\058\063\126\091\015\008\063\008\099\060\091\124\095\091\108\123\095\091\048\095\091\115\095\123\103\091\045\073\084\115\115\066\095\099\018\066\095\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\052\095\091\060\123\036\060\091\095\099\091\017\036\060\060\036\008\099\091\115\008\123\066\091\060\084\123\015\095\066\091\035\095\091\096\008\063\084\123\017\095\126\091\017\084\036\060\091\048\095\091\099\073\084\036\091\084\123\124\123\099\095\091\036\018\095\095\091\124\008\017\017\095\099\045\091\063\091\084\066\066\036\015\095\066\046\091\077\008\123\066\066\036\095\062\058\015\008\123\060\091\017\095\091\018\036\066\095\091\115\084\066\091\008\123\091\124\008\017\017\017\095\099\124\095\066\110"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\039\073\095\060\045\091\123\099\095\091\108\123\095\060\045\036\008\099\091\115\084\060\091\018\123\091\045\008\123\045\091\095\045\066\084\099\081\095\046\091\010\095\091\096\008\063\084\123\017\095\091\084\091\018\095\060\095\060\115\095\066\095\017\095\099\045\091\059\095\060\008\036\099\091\018\073\084\036\018\095\046\091\052\095\091\060\123\036\060\091\105\095\123\066\095\123\103\091\108\123\095\091\015\008\123\060\091\060\008\063\095\062\091\036\099\045\095\066\095\060\060\095\091\084\091\035\073\084\036\018\095\066\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\010\095\091\096\008\063\084\123\017\095\091\095\060\045\091\095\099\091\017\084\123\015\084\036\060\091\095\045\084\045\091\115\084\066\124\095\091\108\123\095\091\035\095\091\017\084\081\036\124\036\095\099\091\099\008\036\066\091\084\091\084\060\060\084\060\060\036\099\095\091\035\095\091\015\036\095\123\103\091\066\008\036\091\095\045\091\115\095\066\060\008\099\099\095\091\099\073\084\091\115\066\036\060\091\035\084\091\066\095\035\095\015\095\091\018\123\091\045\066\008\099\095\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\069\036\091\015\008\123\060\091\115\008\123\015\036\095\062\091\035\036\059\095\066\095\066\091\035\095\091\048\095\123\099\095\091\115\066\036\099\124\095\091\018\123\091\018\008\099\081\095\008\099\091\017\084\081\036\108\123\095\126\091\015\008\123\060\091\066\095\099\018\066\036\095\062\091\123\099\091\100\036\095\066\091\060\095\066\015\036\124\095\091\084\091\035\084\091\118\084\045\036\008\099\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\039\095\035\084\091\060\095\017\059\035\095\091\100\084\060\124\036\099\084\099\045\126\091\017\084\036\060\091\099\095\091\115\095\099\060\095\062\058\015\008\123\060\091\115\084\060\091\108\123\095\091\108\123\095\035\108\123\095\091\018\073\084\123\045\066\095\091\115\008\123\066\066\084\036\045\091\100\084\036\066\095\091\124\095\045\091\084\124\045\095\091\105\095\066\008\036\108\123\095\110\091\010\095\091\018\008\099\081\095\008\099\091\017\084\081\036\108\123\095\091\115\084\066\066\084\036\045\091\018\084\099\081\095\066\095\123\103\046\091\002\035\091\060\095\066\084\036\045\091\115\066\095\100\095\066\084\059\035\095\091\108\123\095\091\048\095\091\066\095\045\008\123\066\099\095\091\124\105\095\062\091\017\008\036\091\095\099\091\060\095\124\123\066\036\045\095\046\091\039\095\091\100\123\045\091\123\099\091\115\035\084\036\060\036\066\091\018\095\091\100\084\036\066\095\091\015\008\045\066\095\091\124\008\099\099\084\036\060\060\084\099\124\095\046"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\042\045\045\095\099\018\095\062\091\123\099\091\115\095\123\046\091\104\008\123\060\091\084\015\095\062\091\124\008\017\017\095\099\124\095\091\084\091\048\008\123\095\066\091\124\095\045\045\095\091\124\084\066\045\008\123\124\105\095\126\091\015\008\123\060\091\018\095\015\095\062\091\035\084\091\045\095\066\017\036\099\095\066\046\091\104\008\123\060\091\099\095\091\115\095\099\060\095\062\091\045\008\123\045\091\018\095\091\017\095\017\095\091\115\084\060\091\108\123\095\091\048\095\091\015\084\036\060\091\018\095\017\095\123\066\095\066\091\036\124\036\091\115\008\123\066\091\095\099\124\008\066\095\091\018\095\060\091\018\095\124\095\099\099\036\095\060\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\011\123\017\017\046\046\046\091\125\041\046\091\014\123\095\091\018\008\036\060\058\048\095\091\100\084\036\066\095\110"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\039\073\095\060\045\091\066\095\035\084\045\036\015\095\017\095\099\045\091\060\036\017\115\035\095\046\091\104\008\123\060\091\018\095\015\066\095\062\091\015\008\123\060\091\066\095\099\018\066\095\091\015\095\066\060\091\035\073\042\066\059\066\095\091\018\095\091\077\008\095\099\008\091\095\045\091\045\066\008\123\015\095\062\091\035\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\010\084\091\039\035\095\091\060\073\036\099\060\095\066\095\091\018\084\099\060\091\035\095\091\115\008\066\045\095\091\018\123\091\039\105\084\045\095\084\123\091\095\045\091\123\099\095\091\100\008\036\060\091\018\095\015\095\066\066\008\123\035\035\095\095\126\091\035\095\091\115\066\036\099\124\095\091\060\095\066\084\091\035\036\059\066\095\091\095\045\091\115\008\123\066\066\084\091\066\095\081\099\095\066\091\060\123\066\091\035\095\091\096\008\063\084\123\017\095\046\091\039\073\095\060\045\091\045\008\123\045\046"), 
			Media = _nMhUc
		}, 
		{
			Text = _3UMLA("\042\105\051\091\039\073\095\060\045\091\115\035\123\060\091\060\036\017\115\035\095\091\108\123\095\091\048\095\091\099\095\091\035\073\095\060\115\095\066\084\036\045\046\091\125\123\091\115\123\036\060\058\048\095\091\045\066\008\123\015\095\066\091\035\073\042\066\059\066\095\091\018\095\091\077\008\095\099\008\110"), 
			Media = _sv8
		}, 
		{
			Text = _3UMLA("\039\008\099\045\036\099\123\008\099\060\091\099\008\045\066\095\091\124\105\095\017\036\099\091\048\123\060\108\123\073\084\091\017\084\091\011\123\045\045\095\046\091\052\095\091\015\008\123\060\091\063\091\036\099\018\036\108\123\095\066\084\036\091\035\095\091\124\105\095\017\036\099\046"), 
			Media = _nMhUc
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _DczE)
	end)
end
function _s2NLj:On_t4jh(target)
	--[[Inserer le son d'echec ici.]]
	Wherigo.PlayAudio(_byfLx)
	_hMA.Active = true
	_hMA.Visible = true
	_WPWF.CorrectState = "NotCorrect"
	_Urwigo.Dialog(false, {
		{
			Text = _3UMLA("\096\123\059\036\095\099\091\035\095\091\078\084\081\036\124\036\095\099\091\095\060\045\091\060\123\066\115\066\036\060\091\108\123\095\091\015\008\123\060\091\008\060\036\095\062\091\035\073\084\100\100\066\008\099\045\095\066\091\017\084\036\060\091\036\035\091\115\095\123\045\091\124\008\099\045\066\095\066\091\015\008\045\066\095\091\084\045\045\084\108\123\095\046"), 
			Media = _C1Eb
		}, 
		{
			Text = _3UMLA("\096\123\059\036\095\099\091\124\008\099\045\066\095\036\099\045\091\015\008\045\066\095\091\084\045\045\084\108\123\095\091\018\073\123\099\091\060\008\035\036\018\095\091\066\095\015\095\066\060\091\095\045\091\015\008\123\060\091\095\099\015\008\036\095\091\095\099\091\035\073\084\036\066\046"), 
			Media = _NxxF
		}, 
		{
			Text = _3UMLA("\104\008\123\060\091\015\008\123\060\091\095\100\100\066\008\099\018\066\095\062\091\060\123\066\091\035\095\091\060\008\035\091\095\045\091\015\008\123\060\091\015\008\123\060\091\059\035\095\060\060\095\062\091\060\095\066\036\095\123\060\095\017\095\099\045\091\084\015\095\124\091\018\008\123\035\095\123\066\060\091\036\099\045\095\099\060\095\060\046\091\104\008\123\060\091\099\073\095\045\095\060\091\115\084\060\091\018\036\060\115\008\060\095\091\084\091\124\008\099\045\036\099\123\095\066\091\124\095\045\045\095\091\084\015\095\099\045\123\066\095\091\018\084\099\060\091\124\095\060\091\124\008\099\018\036\045\036\008\099\060\046")
		}, 
		{
			Text = _3UMLA("\104\008\045\066\095\091\060\095\123\035\091\095\060\115\008\036\066\091\095\060\045\091\018\095\091\015\008\123\060\091\066\095\099\018\066\095\091\084\123\091\077\008\099\045\091\095\045\091\018\095\017\084\099\018\095\066\091\084\060\060\036\060\045\084\099\124\095\091\084\123\091\092\066\095\008\099\126\091\035\073\095\060\115\066\036\045\091\018\095\091\035\084\091\066\036\015\036\095\066\095\046\091\104\008\123\060\091\063\091\060\095\066\095\062\091\060\008\036\081\099\095\091\115\008\123\066\091\124\008\099\045\036\099\123\095\066\046"), 
			Media = _WvfC
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _hMA)
	end)
end
function _s2NLj:On_ep5B(target)
	if Wherigo.NoCaseEquals(_G[_UtJ].Name, _3UMLA("\010\084\091\039\035\084\036\066\036\095\066\095")) then
		if _WPWF.Complete == false then
			_DczE.Active = true
			_DczE.Visible = true
			_uc2rF.Complete = true
			--[[Inserer le son de reussite ici.]]
			Wherigo.PlayAudio(_l592)
			_Urwigo.Dialog(false, {
				{
					Text = _3UMLA("\104\008\123\060\091\084\015\095\062\091\100\084\036\045\091\035\095\091\059\008\099\091\124\105\008\036\103\091\018\095\091\018\036\060\124\123\045\095\066\091\084\015\095\124\091\096\123\059\036\095\099\046\091\010\073\084\100\100\066\008\099\045\095\066\091\084\123\066\084\036\045\091\095\045\095\091\123\099\095\091\095\066\066\095\123\066\046\091\104\008\123\060\091\084\015\095\062\091\123\099\095\091\017\036\060\060\036\008\099\001\091\065\099\059\060\115\019\060\084\123\015\095\066\091\035\095\091\096\008\063\084\123\017\095\046\091\065\099\059\060\115\019\078\084\036\060\126\091\015\008\123\060\091\099\095\091\060\084\015\095\062\091\045\066\008\115\091\115\084\066\091\008\123\091\124\008\017\017\095\099\124\095\066\046"), 
					Media = _C1Eb
				}, 
				{
					Text = _3UMLA("\096\123\059\036\095\099\126\091\095\060\045\058\124\095\091\108\123\095\091\048\095\091\115\095\123\103\091\015\008\123\060\091\115\008\060\095\066\091\108\123\095\035\108\123\095\060\091\108\123\095\060\045\036\008\099\060\110"), 
					Media = _sv8
				}, 
				{
					Text = _3UMLA("\092\036\095\099\091\060\123\066\091\017\008\099\091\084\017\036\046\091\065\099\059\060\115\019\052\095\091\060\123\036\060\091\105\095\123\066\095\123\103\091\018\095\091\015\008\123\060\091\066\095\099\124\008\099\045\066\095\066\091\095\045\091\048\073\084\036\091\095\015\036\018\095\017\017\095\099\045\091\018\123\091\045\095\017\115\060\091\084\091\015\008\123\060\091\084\124\124\008\066\018\095\066\046"), 
					Media = _nMhUc
				}, 
				{
					Text = _3UMLA("\031\100\036\008\123\046\046\046\091\052\095\091\060\123\036\060\091\105\095\123\066\095\123\103\091\018\095\091\035\073\095\099\045\095\099\018\066\095\046\091\065\099\059\060\115\019\052\095\091\124\066\008\063\084\036\060\091\108\123\095\091\015\008\123\060\091\095\045\036\095\062\091\095\099\091\124\008\035\095\066\095\091\095\099\015\095\066\060\091\017\008\036\091\095\045\091\108\123\095\091\015\008\123\060\046\046\046"), 
					Media = _sv8
				}, 
				{
					Text = _3UMLA("\077\008\123\066\108\123\008\036\091\060\095\066\084\036\060\058\048\095\091\095\099\091\124\008\035\095\066\095\110\091\065\099\059\060\115\019\104\008\123\060\091\060\095\017\059\035\095\062\091\081\095\099\045\036\035\091\095\045\091\048\095\091\099\095\091\015\008\036\060\091\115\084\060\091\018\095\091\066\084\036\060\008\099\091\018\095\091\015\008\123\060\091\095\100\100\066\084\063\095\066\046"), 
					Media = _nMhUc
				}, 
				{
					Text = _3UMLA("\040\099\095\091\124\105\084\099\124\095\051\091\065\099\059\060\115\019\077\123\036\060\058\048\095\091\015\008\123\060\091\115\008\060\095\066\091\123\099\095\091\108\123\095\060\045\036\008\099\091\018\036\066\095\124\045\095\091\108\123\036\091\115\008\123\066\066\084\036\045\091\015\008\123\060\091\060\095\017\059\035\095\066\091\095\045\066\084\099\081\095\110"), 
					Media = _sv8
				}, 
				{
					Text = _3UMLA("\042\035\035\095\062\058\063\126\091\015\008\063\008\099\060\091\124\095\091\108\123\095\091\048\095\091\115\095\123\103\091\015\008\123\060\091\084\115\115\066\095\099\018\066\095\046"), 
					Media = _nMhUc
				}, 
				{
					Text = _3UMLA("\052\095\091\060\123\036\060\091\095\099\091\017\036\060\060\036\008\099\091\115\008\123\066\091\060\084\123\015\095\066\091\035\095\091\096\008\063\084\123\017\095\126\091\017\084\036\060\091\048\095\091\099\073\084\036\091\084\123\124\123\099\095\091\036\018\095\095\091\124\008\017\017\095\099\045\091\063\091\084\066\066\036\015\095\066\046\091\077\008\123\066\066\036\095\062\058\015\008\123\060\091\017\095\091\018\036\066\095\091\115\084\066\091\008\123\091\124\008\017\017\095\099\124\095\066\110"), 
					Media = _sv8
				}, 
				{
					Text = _3UMLA("\039\073\095\060\045\091\123\099\095\091\108\123\095\060\045\036\008\099\091\115\084\060\091\018\123\091\045\008\123\045\091\095\045\066\084\099\081\095\046\091\010\095\091\096\008\063\084\123\017\095\091\084\091\018\095\060\095\060\115\095\066\095\017\095\099\045\091\059\095\060\008\036\099\091\018\073\084\036\018\095\046\091\052\095\091\060\123\036\060\091\105\095\123\066\095\123\103\091\108\123\095\091\015\008\123\060\091\060\008\063\095\062\091\036\099\045\095\066\095\060\060\095\091\084\091\035\073\084\036\018\095\066\046"), 
					Media = _nMhUc
				}, 
				{
					Text = _3UMLA("\010\095\091\096\008\063\084\123\017\095\091\095\060\045\091\095\099\091\017\084\123\015\084\036\060\091\095\045\084\045\091\115\084\066\124\095\091\108\123\095\091\035\095\091\017\084\081\036\124\036\095\099\091\099\008\036\066\091\084\091\084\060\060\084\060\060\036\099\095\091\035\095\091\015\036\095\123\103\091\066\008\036\091\095\045\091\115\095\066\060\008\099\099\095\091\099\073\084\091\115\066\036\060\091\035\084\091\066\095\035\095\015\095\091\018\123\091\045\066\008\099\095\046\091\077\084\066\124\095\091\108\123\095\091\035\095\060\091\017\084\081\036\124\036\095\099\060\091\099\095\091\115\095\123\015\095\099\045\091\060\073\084\100\100\066\008\099\045\095\066\091\095\099\045\066\095\091\095\123\103\126\091\036\035\091\100\084\123\045\091\123\099\091\017\008\066\045\095\035\091\045\095\035\091\108\123\095\091\015\008\123\060\046"), 
					Media = _nMhUc
				}, 
				{
					Text = _3UMLA("\069\036\091\015\008\123\060\091\115\008\123\015\036\095\062\091\035\036\059\095\066\095\066\091\035\095\091\048\095\123\099\095\091\115\066\036\099\124\095\091\018\123\091\018\008\099\081\095\008\099\091\084\123\091\039\105\084\045\095\084\123\126\091\015\008\123\060\091\066\095\099\018\066\036\095\062\091\123\099\091\100\036\095\066\091\060\095\066\015\036\124\095\091\084\091\035\084\091\118\084\045\036\008\099\046"), 
					Media = _nMhUc
				}, 
				{
					Text = _3UMLA("\039\095\035\084\091\017\095\091\060\095\017\059\035\095\091\100\084\060\124\036\099\084\099\045\126\091\017\084\036\060\091\099\095\091\115\095\099\060\095\062\058\015\008\123\060\091\115\084\060\091\108\123\095\091\108\123\095\035\108\123\073\123\099\091\018\073\084\123\045\066\095\091\115\008\123\066\066\084\036\045\091\066\095\084\035\036\060\095\066\091\124\095\045\091\084\124\045\095\091\105\095\066\008\036\108\123\095\110\091\010\095\091\018\008\099\081\095\008\099\091\017\084\081\036\108\123\095\091\115\084\066\066\084\036\045\091\018\084\099\081\095\066\095\123\103\046\091\002\035\091\060\095\066\084\036\045\091\115\066\095\100\095\066\084\059\035\095\091\108\123\095\091\048\095\091\066\095\045\008\123\066\099\095\091\124\105\095\062\091\017\008\036\091\095\099\091\060\095\124\123\066\036\045\095\046\091\039\095\091\100\123\045\091\123\099\091\115\035\084\036\060\036\066\091\018\095\091\100\084\036\066\095\091\015\008\045\066\095\091\124\008\099\099\084\036\060\060\084\099\124\095\046"), 
					Media = _sv8
				}, 
				{
					Text = _3UMLA("\042\045\045\095\099\018\095\062\091\123\099\091\115\095\123\046\091\104\008\123\060\091\084\015\095\062\091\124\008\017\017\095\099\124\095\091\084\091\048\008\123\095\066\091\124\095\091\016\048\095\123\016\126\091\015\008\123\060\091\018\095\015\095\062\091\035\084\091\045\095\066\017\036\099\095\066\046\091\104\008\123\060\091\099\095\091\115\095\099\060\095\062\091\045\008\123\045\091\018\095\091\017\095\017\095\091\115\084\060\091\108\123\095\091\048\095\091\015\084\036\060\091\018\095\017\095\123\066\095\066\091\036\124\036\091\115\008\123\066\091\095\099\124\008\066\095\091\018\095\060\091\018\095\124\095\099\099\036\095\060\046"), 
					Media = _nMhUc
				}, 
				{
					Text = _3UMLA("\011\123\017\017\046\046\046\091\125\041\046\091\014\123\095\091\018\008\036\060\058\048\095\091\100\084\036\066\095\110"), 
					Media = _sv8
				}, 
				{
					Text = _3UMLA("\039\073\095\060\045\091\066\095\035\084\045\036\015\095\017\095\099\045\091\060\036\017\115\035\095\046\091\104\008\123\060\091\018\095\015\066\095\062\091\015\008\123\060\091\066\095\099\018\066\095\091\015\095\066\060\091\035\073\042\066\059\066\095\091\018\095\091\077\008\095\099\008\091\095\045\091\045\066\008\123\015\095\066\091\035\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\046"), 
					Media = _nMhUc
				}, 
				{
					Text = _3UMLA("\010\084\091\039\035\095\091\060\073\036\099\060\095\066\095\091\018\084\099\060\091\035\095\091\115\008\066\045\095\091\018\123\091\039\105\084\045\095\084\123\091\095\045\091\123\099\095\091\100\008\036\060\091\018\095\015\095\066\066\008\123\035\035\095\095\126\091\035\095\091\115\066\036\099\124\095\091\060\095\066\084\091\035\036\059\066\095\091\095\045\091\115\008\123\066\066\084\091\066\095\081\099\095\066\091\060\123\066\091\035\095\091\096\008\063\084\123\017\095\046\091\039\073\095\060\045\091\045\008\123\045\046"), 
					Media = _nMhUc
				}, 
				{
					Text = _3UMLA("\042\105\051\091\039\073\095\060\045\091\115\035\123\060\091\060\036\017\115\035\095\091\108\123\095\091\048\095\091\099\095\091\035\073\095\060\115\095\066\084\036\060\046\091\125\123\091\115\123\036\060\058\048\095\091\045\066\008\123\015\095\066\091\035\073\042\066\059\066\095\091\018\095\091\077\008\095\099\008\110"), 
					Media = _sv8
				}, 
				{
					Text = _3UMLA("\039\008\099\045\036\099\123\008\099\060\091\035\095\091\035\008\099\081\091\018\095\091\035\084\091\066\036\015\036\095\066\095\091\095\099\091\084\017\008\099\045\091\048\123\060\108\123\073\084\091\017\008\099\091\116\008\123\066\059\036\046\091\052\095\091\015\008\123\060\091\063\091\036\099\018\036\108\123\095\066\084\036\091\035\095\091\124\105\095\017\036\099\046"), 
					Media = _nMhUc
				}
			}, function(action)
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _DczE)
			end)
		else
			_hMA.Visible = true
			_Urwigo.MessageBox{
				Text = _3UMLA("\002\035\091\095\060\045\091\045\066\008\115\091\045\084\066\018\091\115\008\123\066\091\018\036\060\124\123\045\095\066\091\084\015\095\124\091\096\123\059\036\095\099\046"), 
				Media = _C1Eb, 
				Buttons = {
					_3UMLA("\042\035\035\095\066\091\084\123\091\115\008\099\045\046\046\046")
				}, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _DczE)
					end
				end
			}
		end
		_s2NLj.Visible = false
		_hMA.Active = false
	else
		_Urwigo.MessageBox{
			Text = _3UMLA("\104\008\123\060\091\099\073\095\045\095\060\091\115\084\060\091\018\084\099\060\091\035\084\091\059\008\099\099\095\091\062\008\099\095\091\115\008\123\066\091\066\095\099\124\008\099\045\066\095\066\091\096\123\059\036\095\099\091\035\095\091\078\084\081\036\124\036\095\099\046"), 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _CKhcU:On_uz1(target)
	if _ajK.Complete == false then
		--[[Inserer PlaySound Hourra ici.]]
		Wherigo.PlayAudio(_l592)
		__zg2.Visible = true
		__zg2.Active = true
		_Urwigo.MessageBox{
			Text = _3UMLA("\104\008\123\060\091\084\015\095\062\091\017\084\036\099\045\095\099\084\099\045\091\035\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\091\095\099\091\015\008\045\066\095\091\115\008\060\060\095\060\060\036\008\099\046\091\104\008\123\060\091\115\008\123\015\095\062\091\015\008\123\060\091\018\036\066\036\081\095\066\091\015\095\066\060\091\035\095\091\039\105\084\045\095\084\123\091\095\045\091\018\095\035\036\015\066\095\066\091\035\095\091\077\066\036\099\124\095\046"), 
			Media = _Hq1Y, 
			Buttons = {
				_3UMLA("\042\035\035\095\066\091\084\123\091\039\105\084\045\095\084\123\046\046\046")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, __zg2)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _3UMLA("\104\008\123\060\091\095\045\095\060\091\018\095\048\084\091\095\099\091\115\008\060\060\095\060\060\036\008\099\091\018\095\091\035\084\091\039\035\095\091\018\123\091\096\008\063\084\123\017\095\046\091\104\008\123\060\091\018\095\015\095\062\091\100\084\036\066\095\091\123\099\091\084\123\045\066\095\091\124\105\008\036\103\046"), 
			Media = _C1Eb, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _CKhcU:On_oE1(target)
	if _G[_UtJ] == __zg2 then
		_Am_D.Complete = true
		_z7N.Active = true
		_z7N.Visible = true
		_W2C.Visible = true
		_W2C.Opened = true
		--[[Inserer PlaySound Hourra ici.]]
		Wherigo.PlayAudio(_l592)
		_Urwigo.Dialog(false, {
			{
				Text = _3UMLA("\092\036\095\099\091\100\084\036\045\051\091\065\099\059\060\115\019\010\095\091\077\066\036\099\124\095\091\095\060\045\091\035\036\059\095\066\095\091\095\045\091\035\095\091\096\008\063\084\123\017\095\091\018\095\091\077\040\096\002\119\040\078\091\115\095\123\045\091\095\099\100\036\099\091\066\095\045\066\008\123\015\095\066\091\035\084\091\115\084\036\103\091\115\095\066\018\123\095\046"), 
				Media = __bV
			}, 
			{
				Text = _3UMLA("\078\084\036\099\045\095\099\084\099\045\091\108\123\095\091\015\008\045\066\095\091\017\036\060\060\036\008\099\091\095\060\045\091\084\124\124\008\017\115\035\036\095\126\091\048\073\084\036\091\084\124\045\036\015\095\091\035\084\091\062\008\099\095\091\008\123\091\060\095\091\045\066\008\123\015\095\091\035\084\091\124\084\124\105\095\046\091\104\008\123\060\091\115\008\123\015\095\062\091\015\008\123\060\091\063\091\066\095\099\018\066\095\091\095\045\091\060\036\081\099\095\066\091\035\095\091\124\084\066\099\095\045\091\018\095\091\015\036\060\036\045\095\046"), 
				Media = _C1Eb
			}, 
			{
				Text = _3UMLA("\042\123\091\100\084\036\045\046\046\046\091\108\123\095\091\100\084\036\045\058\036\035\091\035\084\091\035\095\091\077\095\045\036\045\091\077\066\036\099\124\095\110\091\052\095\091\124\066\008\063\084\036\060\091\108\123\073\036\035\091\095\045\084\036\045\091\084\123\091\124\095\099\045\066\095\058\015\036\035\035\095\091\018\084\099\060\091\123\099\095\091\085\105\095\066\036\081\008\091\018\123\091\017\095\017\095\091\099\008\017\046"), 
				Media = _nMhUc
			}, 
			{
				Text = _3UMLA("\096\095\099\018\008\099\060\058\099\008\123\060\091\015\095\066\060\091\035\084\091\124\084\124\105\095\046\046\046"), 
				Media = _C1Eb
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _z7N)
		end)
	else
		_Urwigo.MessageBox{
			Text = _3UMLA("\119\095\060\008\035\095\051\091\065\099\059\060\115\019\002\035\091\099\073\063\091\084\091\084\123\124\123\099\095\091\115\008\066\045\095\091\084\091\008\123\015\066\036\066\091\036\124\036\046\091\039\105\008\036\060\036\060\060\095\062\091\084\123\045\066\095\091\124\105\008\060\095\046"), 
			Media = _C1Eb, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _W2C:On_akm(target)
	if _G[_UtJ] == _z7N then
		--[[Inserer PlaySound Hourra ici.]]
		Wherigo.PlayAudio(_l592)
		_Urwigo.Dialog(false, {
			{
				Text = _3UMLA("\031\095\035\036\124\036\124\036\045\084\045\036\008\099\060\051\091\065\099\059\060\115\019\118\008\123\060\091\060\008\017\017\095\060\091\052\084\124\089\091\065\084\017\115\019\091\069\008\126\091\124\095\123\103\091\084\091\108\123\036\091\119\084\099\084\045\036\060\063\091\084\091\066\095\099\018\123\091\105\008\017\017\084\081\095\091\115\008\123\066\091\099\008\060\091\087\075\126\106\106\106\091\124\084\124\105\095\060\091\045\066\008\123\015\095\095\060\046\091\078\095\066\124\036\091\018\073\084\015\008\036\066\091\048\008\123\095\091\124\095\045\045\095\091\124\084\066\045\008\123\124\105\095\091\085\105\095\066\036\081\008\046"), 
				Media = _6Ly
			}, 
			{
				Text = _3UMLA("\119\084\099\084\045\036\060\063\091\084\091\084\048\008\123\045\095\091\035\095\091\124\008\018\095\091\016\040\099\035\008\124\089\016\091\018\084\099\060\091\035\084\091\060\095\124\045\036\008\099\091\016\002\099\015\095\099\045\084\036\066\095\016\091\018\123\091\048\095\123\046\091\002\035\091\015\008\123\060\091\060\095\066\084\091\123\045\036\035\095\091\115\008\123\066\091\008\059\045\095\099\036\066\091\123\099\091\060\045\084\045\123\045\091\016\039\008\017\115\035\095\045\095\018\016\091\060\123\066\091\085\105\095\066\036\081\008\046\124\008\017\046"), 
				Media = _6Ly
			}, 
			{
				Text = _3UMLA("\104\008\123\060\091\115\008\123\015\095\062\091\108\123\036\045\045\095\066\091\035\084\091\062\008\099\095\091\008\123\091\100\095\066\017\095\066\091\017\084\099\123\095\035\035\095\017\095\099\045\091\035\084\091\124\084\066\045\008\123\124\105\095\091\085\105\095\066\036\081\008\046\091\040\099\095\091\060\084\123\015\095\081\084\066\018\095\091\084\123\045\008\017\084\045\036\108\123\095\091\084\091\018\095\048\084\091\095\045\095\091\095\103\095\124\123\045\095\095\046\091\104\008\123\060\091\115\008\123\066\066\095\062\091\066\008\123\015\066\036\066\091\035\084\091\124\084\066\045\008\123\124\105\095\091\095\099\091\045\008\123\045\091\045\095\017\115\060\091\095\045\091\045\084\115\095\066\091\060\123\066\091\125\040\002\091\084\123\091\018\095\017\084\066\066\084\081\095\046\091\010\084\091\124\084\124\105\095\091\060\095\066\084\091\095\099\124\008\066\095\091\015\036\060\036\059\035\095\046"), 
				Media = _6Ly
			}
		}, function(action)
			_qiI3.Complete = true
			_QofY.Visible = true
			_c4vM.Complete = true
			_QofY:MoveTo(Player)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_c4vM:RequestSync()
		end)
	else
		_Urwigo.MessageBox{
			Text = _3UMLA("\002\035\091\099\073\063\091\084\091\115\084\060\091\018\095\091\124\084\124\105\095\091\084\091\045\066\008\123\015\095\066\091\036\124\036\046\046\046"), 
			Media = _6Ly, 
			Buttons = {
				_3UMLA("\039\084\124\105\095\046\046\046")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _W2C:On_X_wV(target)
	--[[Inserer PlaySound PouetPouet ici.]]
	Wherigo.PlayAudio(_byfLx)
	_Urwigo.Dialog(false, {
		{
			Text = _3UMLA("\119\095\060\008\035\095\091\108\123\095\091\015\008\123\060\091\099\073\084\063\095\062\091\115\084\060\091\045\066\008\123\015\095\091\035\084\091\124\084\124\105\095\046\091\040\099\095\091\060\084\123\015\095\081\084\066\018\095\091\084\123\045\008\017\084\045\036\108\123\095\091\060\095\066\084\091\095\103\095\124\123\045\095\095\046\091\104\008\123\060\091\115\008\123\066\066\095\062\091\108\123\036\045\045\095\066\091\017\084\036\099\045\095\099\084\099\045\091\095\045\091\066\095\015\095\099\036\066\091\123\099\091\084\123\045\066\095\091\048\008\123\066\046"), 
			Media = _C1Eb
		}, 
		{
			Text = _3UMLA("\104\008\123\060\091\017\095\066\036\045\095\062\091\108\123\084\099\018\091\017\095\017\095\091\035\095\091\124\008\018\095\091\016\040\099\035\008\124\089\016\091\115\008\123\066\091\008\059\045\095\099\036\066\091\035\095\091\060\045\084\045\123\045\091\016\039\008\017\115\035\095\045\095\018\016\091\018\084\099\060\091\085\105\095\066\036\081\008\046\124\008\017\046\091\065\099\059\060\115\019\104\008\123\060\091\035\095\091\045\066\008\123\015\095\066\095\062\091\018\084\099\060\091\035\084\091\060\095\124\045\036\008\099\091\016\002\099\015\095\099\045\084\036\066\095\016\091\018\123\091\048\095\123\046"), 
			Media = _C1Eb
		}, 
		{
			Text = _3UMLA("\082\099\091\066\095\018\095\017\084\066\066\084\099\045\091\035\095\091\048\095\123\126\091\124\105\008\036\060\036\060\060\095\062\091\125\040\002\091\115\008\123\066\091\066\095\115\066\095\099\018\066\095\091\035\084\091\124\084\066\045\008\123\124\105\095\091\084\091\124\095\045\045\095\091\095\045\084\115\095\058\124\036\046\091\010\084\091\124\084\124\105\095\091\060\095\066\084\091\095\099\124\008\066\095\091\015\036\060\036\059\035\095\046"), 
			Media = _C1Eb
		}
	}, function(action)
		_c4vM:RequestSync()
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _QofY:OnClick()
	_Urwigo.MessageBox{
		Text = _3UMLA("\104\008\036\124\036\091\015\008\045\066\095\091\124\008\018\095\091\016\040\099\035\008\124\089\016\046\091\104\008\123\060\091\099\073\084\015\095\062\091\115\084\060\091\084\091\035\095\091\115\066\095\099\018\066\095\091\095\099\091\099\008\045\095\046\091\002\035\091\018\095\017\095\123\066\095\066\084\091\018\084\099\060\091\035\084\091\069\095\124\045\036\008\099\091\016\002\099\015\095\099\045\084\036\066\095\016\091\018\123\091\048\095\123\046\091\039\073\095\060\045\091\035\095\001\098\092\096\012")..string.sub(Player.CompletionCode, 1, 15), 
		Media = _waa, 
		Buttons = {
			_3UMLA("\078\095\099\123\091\115\066\036\099\124\036\115\084\035\046\046\046")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return _c4vM
