require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

_YKa = Wherigo.ZCartridge()

-- String decode --
function _JSg(str)
	local res = ""
    local dtable = "\101\046\043\102\025\097\019\093\005\074\077\091\068\079\120\069\109\035\122\098\104\034\039\017\033\049\123\078\118\000\015\066\121\113\004\108\072\058\012\103\126\032\099\042\037\060\116\087\084\059\011\027\110\115\023\002\125\009\083\106\092\057\041\090\036\022\003\094\086\075\018\095\089\052\067\124\076\088\085\080\100\105\053\055\119\111\030\007\117\031\029\063\026\112\096\038\001\016\010\082\024\006\114\071\008\107\081\040\013\014\050\020\021\051\056\048\065\073\045\062\047\064\070\028\054\044\061"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
_3gB = Wherigo.ZMedia(_YKa)
_3gB.Id = "dd2bf2f2-2dd8-4ac4-bc18-5cd885f37b5e"
_3gB.Name = _JSg("\016\047\006\094\001\042\026")
_3gB.Description = ""
_3gB.AltText = ""
_3gB.Resources = {
	{
		Type = "jpg", 
		Filename = "etape1.jpg", 
		Directives = {}
	}
}
_TBqNS = Wherigo.ZMedia(_YKa)
_TBqNS.Id = "a79f4d72-d7e9-41ed-be75-5ba8012dd3e5"
_TBqNS.Name = _JSg("\016\047\006\094\001\042\111")
_TBqNS.Description = ""
_TBqNS.AltText = ""
_TBqNS.Resources = {
	{
		Type = "jpg", 
		Filename = "etape2.jpg", 
		Directives = {}
	}
}
_hhTMo = Wherigo.ZMedia(_YKa)
_hhTMo.Id = "74d5f710-0ce1-499a-9ea1-053717c1b2f2"
_hhTMo.Name = _JSg("\016\047\006\094\001\042\114")
_hhTMo.Description = ""
_hhTMo.AltText = ""
_hhTMo.Resources = {
	{
		Type = "jpg", 
		Filename = "etape3.jpg", 
		Directives = {}
	}
}
_9rnZ = Wherigo.ZMedia(_YKa)
_9rnZ.Id = "79df3ea5-5c79-454b-ab82-d2b5856a9df7"
_9rnZ.Name = _JSg("\075\006\043\021\001\042\026")
_9rnZ.Description = ""
_9rnZ.AltText = ""
_9rnZ.Resources = {
	{
		Type = "jpg", 
		Filename = "cache1.jpg", 
		Directives = {}
	}
}
_6_YEr = Wherigo.ZMedia(_YKa)
_6_YEr.Id = "12a83878-a3e9-4bf0-900b-452f3a503b6a"
_6_YEr.Name = _JSg("\016\047\006\094\001\042\083")
_6_YEr.Description = ""
_6_YEr.AltText = ""
_6_YEr.Resources = {
	{
		Type = "jpg", 
		Filename = "etape5.jpg", 
		Directives = {}
	}
}
_O2N = Wherigo.ZMedia(_YKa)
_O2N.Id = "f2679c34-0d63-4d8c-96f6-201a7155ccc1"
_O2N.Name = _JSg("\016\047\006\094\001\042\115")
_O2N.Description = ""
_O2N.AltText = ""
_O2N.Resources = {
	{
		Type = "jpg", 
		Filename = "etape8.jpg", 
		Directives = {}
	}
}
_kvJp = Wherigo.ZMedia(_YKa)
_kvJp.Id = "b47e6af1-b847-4cb9-9e69-1aa4d0a41d3d"
_kvJp.Name = _JSg("\016\047\006\094\001\042\084")
_kvJp.Description = ""
_kvJp.AltText = ""
_kvJp.Resources = {
	{
		Type = "jpg", 
		Filename = "etape7.jpg", 
		Directives = {}
	}
}
_lDyrW = Wherigo.ZMedia(_YKa)
_lDyrW.Id = "4babba3e-2852-4ed8-a3f9-6ae818e6bb3e"
_lDyrW.Name = _JSg("\016\047\006\094\001\042\125")
_lDyrW.Description = ""
_lDyrW.AltText = ""
_lDyrW.Resources = {
	{
		Type = "jpg", 
		Filename = "etape6.jpg", 
		Directives = {}
	}
}
_HXTD = Wherigo.ZMedia(_YKa)
_HXTD.Id = "7c7a6d5f-4412-403b-9b8f-33f4403adcb2"
_HXTD.Name = _JSg("\075\006\043\021\001\042\111")
_HXTD.Description = ""
_HXTD.AltText = ""
_HXTD.Resources = {
	{
		Type = "jpg", 
		Filename = "cache2.jpg", 
		Directives = {}
	}
}
_8DO = Wherigo.ZMedia(_YKa)
_8DO.Id = "ce6dc407-b052-4759-9927-a354437ede9d"
_8DO.Name = _JSg("\043\006\043\021\001\042\114")
_8DO.Description = ""
_8DO.AltText = ""
_8DO.Resources = {
	{
		Type = "jpg", 
		Filename = "cache3.jpg", 
		Directives = {}
	}
}
_Hwl = Wherigo.ZMedia(_YKa)
_Hwl.Id = "4fdf42c0-f90f-44e0-9596-6cb5587cd4df"
_Hwl.Name = _JSg("\059\094\086\082\036\001\103\042\043\006\043\021\001\042\111")
_Hwl.Description = ""
_Hwl.AltText = ""
_Hwl.Resources = {
	{
		Type = "jpg", 
		Filename = "spoilercache2.jpg", 
		Directives = {}
	}
}
_8hNF = Wherigo.ZMedia(_YKa)
_8hNF.Id = "6b47ce04-8c06-4f3c-b19d-9c7010b8a53a"
_8hNF.Name = _JSg("\059\094\086\082\036\001\103\042\043\006\043\021\001\042\026")
_8hNF.Description = ""
_8hNF.AltText = ""
_8hNF.Resources = {
	{
		Type = "jpg", 
		Filename = "spoilercache1.jpg", 
		Directives = {}
	}
}
_wNXf = Wherigo.ZMedia(_YKa)
_wNXf.Id = "555eb850-eea2-464e-99b2-902ba35e97a4"
_wNXf.Name = _JSg("\059\094\086\082\036\001\103\042\043\006\043\021\001\042\114")
_wNXf.Description = ""
_wNXf.AltText = ""
_wNXf.Resources = {
	{
		Type = "jpg", 
		Filename = "spoilercache3.jpg", 
		Directives = {}
	}
}
_8Xj = Wherigo.ZMedia(_YKa)
_8Xj.Id = "4232f62f-e654-4967-b5a5-82b15e4e76f4"
_8Xj.Name = _JSg("\001\047\006\094\001\042\074")
_8Xj.Description = ""
_8Xj.AltText = ""
_8Xj.Resources = {
	{
		Type = "jpg", 
		Filename = "etape4.jpg", 
		Directives = {}
	}
}
_ErF4 = Wherigo.ZMedia(_YKa)
_ErF4.Id = "3aa8093b-5ac1-46dc-94ff-8e888bacef79"
_ErF4.Name = _JSg("\094\006\103\043\042\043\086\053\047\001\053\047\082\086\053\042")
_ErF4.Description = ""
_ErF4.AltText = ""
_ErF4.Resources = {
	{
		Type = "jpg", 
		Filename = "parcacontention.jpg", 
		Directives = {}
	}
}
_dpymf = Wherigo.ZMedia(_YKa)
_dpymf.Id = "6c0a7239-d5d3-4221-b263-2a8dc7db3e62"
_dpymf.Name = _JSg("\006\029\006\047\006\103")
_dpymf.Description = ""
_dpymf.AltText = ""
_dpymf.Resources = {
	{
		Type = "jpg", 
		Filename = "ours.jpg", 
		Directives = {}
	}
}
_9il = Wherigo.ZMedia(_YKa)
_9il.Id = "19ab20a5-021a-4249-a6fb-0740640a7fa2"
_9il.Name = _JSg("\082\043\086\053\001")
_9il.Description = ""
_9il.AltText = ""
_9il.Resources = {
	{
		Type = "jpg", 
		Filename = "icone.jpg", 
		Directives = {}
	}
}
_xaY = Wherigo.ZMedia(_YKa)
_xaY.Id = "41729d5e-50de-4e5f-88f2-51e8c989d160"
_xaY.Name = _JSg("\043\006\103\047\086\089\043\021\001")
_xaY.Description = ""
_xaY.AltText = ""
_xaY.Resources = {
	{
		Type = "JPG", 
		Filename = "Capture.JPG", 
		Directives = {}
	}
}
_dsN = Wherigo.ZMedia(_YKa)
_dsN.Id = "c97c1539-1157-423b-85e0-1d7ab3f33f97"
_dsN.Name = _JSg("\054\001\036\001\043\047\001\089\103\042\081\001\042\036\006\053\040\089\001\054")
_dsN.Description = ""
_dsN.AltText = ""
_dsN.Resources = {
	{
		Type = "jpg", 
		Filename = "flags.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_YKa.Id="14f53da9-6207-41e9-bce4-3aeba9deaeee"
_YKa.Name="Le plateau du Zoum "
_YKa.Description=[[Une courte promenade de 1000 metres autour du plateau du Zoum durant laquelle vous decouvrirez 3 caches .Une boussole vous sera necessaire

A short walk around the 1000 meter plateau Zoum during which you will find three caches. A compass will be needed

Un paseo alrededor de la Zoum meseta de 1000 metros durante el cual se encuentran tres caches. Una brujula sera necesario]]
_YKa.Visible=true
_YKa.Activity="TourGuide"
_YKa.StartingLocationDescription=[[]]
_YKa.StartingLocation = ZonePoint(43.0879195145298,-0.454983757678655,0)
_YKa.Version="1.0"
_YKa.Company=""
_YKa.Author="Ossau 64"
_YKa.BuilderVersion="URWIGO 1.12.4091.37853"
_YKa.CreateDate="11/22/2010 15:55:58"
_YKa.PublishDate="1/1/0001 12:00:00 AM"
_YKa.UpdateDate="06/01/2011 23:48:15"
_YKa.LastPlayedDate="1/1/0001 12:00:00 AM"
_YKa.TargetDevice="PocketPC"
_YKa.TargetDeviceVersion="0"
_YKa.StateId="1"
_YKa.CountryId="2"
_YKa.Complete=false
_YKa.UseLogging=true

_YKa.Media=_xaY

_YKa.Icon=_9il


-- Zones --
_986j = Wherigo.Zone(_YKa)
_986j.Id = "e3f184fa-2db5-4f5f-9158-27ebbf194727"
_986j.Name = _JSg("\016\047\006\094\001\042\115")
_986j.Description = ""
_986j.Visible = false
_986j.Media = _O2N
_986j.Commands = {}
_986j.DistanceRange = Distance(-1, "feet")
_986j.ShowObjects = "OnEnter"
_986j.ProximityRange = Distance(60, "meters")
_986j.AllowSetPositionTo = false
_986j.Active = false
_986j.Points = {
	ZonePoint(43.0878902058251, -0.454751148479453, 0), 
	ZonePoint(43.0879528885176, -0.454885258930198, 0), 
	ZonePoint(43.0878196877192, -0.45482625033187, 0), 
	ZonePoint(43.0878471114367, -0.454708233135215, 0), 
	ZonePoint(43.0878862881546, -0.454595580356589, 0), 
	ZonePoint(43.0879959828316, -0.454681411045066, 0), 
	ZonePoint(43.0879531333718, -0.454884253101817, 0)
}
_986j.OriginalPoint = ZonePoint(43.0879064711224, -0.454761733625744, 0)
_986j.DistanceRangeUOM = "Feet"
_986j.ProximityRangeUOM = "Meters"
_986j.OutOfRangeName = ""
_986j.InRangeName = ""
_CKWRk = Wherigo.Zone(_YKa)
_CKWRk.Id = "17e68a84-9c1d-4aef-a112-aaa0756b0986"
_CKWRk.Name = _JSg("\016\047\006\094\001\042\026")
_CKWRk.Description = ""
_CKWRk.Visible = false
_CKWRk.Media = _3gB
_CKWRk.Commands = {}
_CKWRk.DistanceRange = Distance(-1, "feet")
_CKWRk.ShowObjects = "OnEnter"
_CKWRk.ProximityRange = Distance(60, "meters")
_CKWRk.AllowSetPositionTo = false
_CKWRk.Active = false
_CKWRk.Points = {
	ZonePoint(43.0880828970726, -0.454770938657769, 0), 
	ZonePoint(43.0880967313008, -0.454877724104175, 0), 
	ZonePoint(43.0880143380199, -0.454851404928216, 0), 
	ZonePoint(43.0880226630518, -0.454672367476472, 0), 
	ZonePoint(43.0880745720489, -0.454660297535905, 0), 
	ZonePoint(43.0881294192433, -0.454688460730561, 0), 
	ZonePoint(43.0881274604158, -0.454771609210023, 0), 
	ZonePoint(43.088096608874, -0.454878227018365, 0)
}
_CKWRk.OriginalPoint = ZonePoint(43.0880805862534, -0.454771378707686, 0)
_CKWRk.DistanceRangeUOM = "Feet"
_CKWRk.ProximityRangeUOM = "Meters"
_CKWRk.OutOfRangeName = ""
_CKWRk.InRangeName = ""
_0xVO = Wherigo.Zone(_YKa)
_0xVO.Id = "4ad97cec-b677-479c-a3cb-03d202f46cf8"
_0xVO.Name = _JSg("\016\047\006\094\001\042\111")
_0xVO.Description = ""
_0xVO.Visible = false
_0xVO.Media = _TBqNS
_0xVO.Commands = {}
_0xVO.DistanceRange = Distance(-1, "feet")
_0xVO.ShowObjects = "OnEnter"
_0xVO.ProximityRange = Distance(60, "meters")
_0xVO.AllowSetPositionTo = false
_0xVO.Active = false
_0xVO.Points = {
	ZonePoint(43.0882239264652, -0.454802705522528, 0), 
	ZonePoint(43.0882298029384, -0.454735650297156, 0), 
	ZonePoint(43.0882768147032, -0.454711510416022, 0), 
	ZonePoint(43.0883708381245, -0.454730285879126, 0), 
	ZonePoint(43.0883747557639, -0.454821480985632, 0), 
	ZonePoint(43.0883571263846, -0.45488585400199, 0), 
	ZonePoint(43.0882885676387, -0.454877807374945, 0)
}
_0xVO.OriginalPoint = ZonePoint(43.0883031188598, -0.4547950420682, 0)
_0xVO.DistanceRangeUOM = "Feet"
_0xVO.ProximityRangeUOM = "Meters"
_0xVO.OutOfRangeName = ""
_0xVO.InRangeName = ""
_irJ6 = Wherigo.Zone(_YKa)
_irJ6.Id = "15fcd506-2486-4aaf-bc4f-f007ebe73704"
_irJ6.Name = _JSg("\016\047\006\094\001\042\114")
_irJ6.Description = ""
_irJ6.Visible = false
_irJ6.Media = _hhTMo
_irJ6.Commands = {}
_irJ6.DistanceRange = Distance(-1, "feet")
_irJ6.ShowObjects = "OnEnter"
_irJ6.ProximityRange = Distance(25, "meters")
_irJ6.AllowSetPositionTo = false
_irJ6.Active = false
_irJ6.Points = {
	ZonePoint(43.0892908448109, -0.454900743551263, 0), 
	ZonePoint(43.0893578109195, -0.455003170408019, 0), 
	ZonePoint(43.0893848666757, -0.45484978157998, 0), 
	ZonePoint(43.0893143502906, -0.454726399965295, 0), 
	ZonePoint(43.089247751408, -0.454774679727563, 0), 
	ZonePoint(43.0892203283176, -0.454887332506189, 0), 
	ZonePoint(43.0892359986565, -0.455018760747918, 0), 
	ZonePoint(43.0893045563419, -0.455048265047082, 0), 
	ZonePoint(43.089358055768, -0.455003505684146, 0)
}
_irJ6.OriginalPoint = ZonePoint(43.0893016181321, -0.454912515468606, 0)
_irJ6.DistanceRangeUOM = "Feet"
_irJ6.ProximityRangeUOM = "Meters"
_irJ6.OutOfRangeName = ""
_irJ6.InRangeName = ""
_FFoC = Wherigo.Zone(_YKa)
_FFoC.Id = "9bc7aeff-5ac1-47ed-997b-2b30866d016a"
_FFoC.Name = _JSg("\043\006\043\021\001\042\026")
_FFoC.Description = ""
_FFoC.Visible = false
_FFoC.Media = _9rnZ
_FFoC.Commands = {}
_FFoC.DistanceRange = Distance(-1, "feet")
_FFoC.ShowObjects = "OnEnter"
_FFoC.ProximityRange = Distance(15, "meters")
_FFoC.AllowSetPositionTo = false
_FFoC.Active = false
_FFoC.Points = {
	ZonePoint(43.0902923505565, -0.455042976686473, 0), 
	ZonePoint(43.0902218352162, -0.454957145997996, 0), 
	ZonePoint(43.0903060618632, -0.454890090772624, 0), 
	ZonePoint(43.0904079171886, -0.454935688325877, 0), 
	ZonePoint(43.0904235872237, -0.455126125165934, 0), 
	ZonePoint(43.0903765771066, -0.45523341352653, 0), 
	ZonePoint(43.0903001855893, -0.455211955854411, 0), 
	ZonePoint(43.090200288846, -0.45510734970283, 0), 
	ZonePoint(43.0902179176949, -0.454954463788981, 0)
}
_FFoC.OriginalPoint = ZonePoint(43.0903051912539, -0.455051023313517, 0)
_FFoC.DistanceRangeUOM = "Feet"
_FFoC.ProximityRangeUOM = "Meters"
_FFoC.OutOfRangeName = ""
_FFoC.InRangeName = ""
_SmiN = Wherigo.Zone(_YKa)
_SmiN.Id = "c77e90b8-9443-4c5f-b6fd-73db73d6ee43"
_SmiN.Name = _JSg("\016\047\006\094\001\042\074")
_SmiN.Description = ""
_SmiN.Visible = false
_SmiN.Media = _8Xj
_SmiN.Commands = {}
_SmiN.DistanceRange = Distance(-1, "feet")
_SmiN.ShowObjects = "OnEnter"
_SmiN.ProximityRange = Distance(20, "meters")
_SmiN.AllowSetPositionTo = false
_SmiN.Active = false
_SmiN.Points = {
	ZonePoint(43.0898683710556, -0.45606331779098, 0), 
	ZonePoint(43.0898844084983, -0.456142275318856, 0), 
	ZonePoint(43.089822339899, -0.456078069940562, 0), 
	ZonePoint(43.0898634741257, -0.455997603670115, 0), 
	ZonePoint(43.0899496600348, -0.455992239252085, 0), 
	ZonePoint(43.0899633714183, -0.456070023313517, 0), 
	ZonePoint(43.0899516188041, -0.456134396329875, 0), 
	ZonePoint(43.0898839188054, -0.456142610594983, 0)
}
_SmiN.OriginalPoint = ZonePoint(43.0898983953302, -0.456077567026372, 0)
_SmiN.DistanceRangeUOM = "Feet"
_SmiN.ProximityRangeUOM = "Meters"
_SmiN.OutOfRangeName = ""
_SmiN.InRangeName = ""
_e2T = Wherigo.Zone(_YKa)
_e2T.Id = "240ff80a-7a77-4d4f-afc0-9a0cffeac07e"
_e2T.Name = _JSg("\016\047\006\094\001\042\083")
_e2T.Description = ""
_e2T.Visible = false
_e2T.Media = _6_YEr
_e2T.Commands = {}
_e2T.DistanceRange = Distance(-1, "feet")
_e2T.ShowObjects = "OnEnter"
_e2T.ProximityRange = Distance(60, "meters")
_e2T.AllowSetPositionTo = false
_e2T.Active = false
_e2T.Points = {
	ZonePoint(43.0891093090306, -0.457523425760271, 0), 
	ZonePoint(43.0890936386593, -0.457614620866778, 0), 
	ZonePoint(43.0890466275214, -0.457442959489824, 0), 
	ZonePoint(43.08913281458, -0.457383950891497, 0), 
	ZonePoint(43.0891935372075, -0.457483192625048, 0), 
	ZonePoint(43.0891484849412, -0.457574387731554, 0), 
	ZonePoint(43.0890936386593, -0.457617303075792, 0)
}
_e2T.OriginalPoint = ZonePoint(43.0891168643713, -0.457519977205823, 0)
_e2T.DistanceRangeUOM = "Feet"
_e2T.ProximityRangeUOM = "Meters"
_e2T.OutOfRangeName = ""
_e2T.InRangeName = ""
_8c6C = Wherigo.Zone(_YKa)
_8c6C.Id = "89ccfc50-641f-472a-b300-9cb9952ceae2"
_8c6C.Name = _JSg("\016\047\006\094\001\042\125")
_8c6C.Description = ""
_8c6C.Visible = false
_8c6C.Media = _lDyrW
_8c6C.Commands = {}
_8c6C.DistanceRange = Distance(-1, "feet")
_8c6C.ShowObjects = "OnEnter"
_8c6C.ProximityRange = Distance(60, "meters")
_8c6C.AllowSetPositionTo = false
_8c6C.Active = false
_8c6C.Points = {
	ZonePoint(43.0878516792083, -0.456758209821697, 0), 
	ZonePoint(43.0879006500982, -0.456661650297161, 0), 
	ZonePoint(43.0879535386152, -0.456685790178295, 0), 
	ZonePoint(43.0879437444488, -0.45680917179298, 0), 
	ZonePoint(43.0878810617469, -0.456881591436382, 0), 
	ZonePoint(43.0878360085153, -0.456862815973278, 0)
}
_8c6C.OriginalPoint = ZonePoint(43.0878944471054, -0.456776538249966, 0)
_8c6C.DistanceRangeUOM = "Feet"
_8c6C.ProximityRangeUOM = "Meters"
_8c6C.OutOfRangeName = ""
_8c6C.InRangeName = ""
_NutXI = Wherigo.Zone(_YKa)
_NutXI.Id = "3b5b00ea-1958-4e64-b258-37faa1945d31"
_NutXI.Name = _JSg("\075\006\043\021\001\042\114")
_NutXI.Description = ""
_NutXI.Visible = false
_NutXI.Media = _8DO
_NutXI.Commands = {}
_NutXI.DistanceRange = Distance(-1, "feet")
_NutXI.ShowObjects = "OnEnter"
_NutXI.ProximityRange = Distance(60, "meters")
_NutXI.AllowSetPositionTo = false
_NutXI.Active = false
_NutXI.Points = {
	ZonePoint(43.087605, -0.454348, 0), 
	ZonePoint(43.0876490739801, -0.454443218420022, 0), 
	ZonePoint(43.0875609259882, -0.454405667493814, 0), 
	ZonePoint(43.087539378682, -0.454314472387307, 0), 
	ZonePoint(43.0876040205779, -0.45425009937095, 0), 
	ZonePoint(43.0876627858786, -0.454293014715188, 0), 
	ZonePoint(43.0876882508247, -0.454349341104501, 0), 
	ZonePoint(43.0876489515525, -0.454443386058085, 0)
}
_NutXI.OriginalPoint = ZonePoint(43.0876197984355, -0.454355899943733, 0)
_NutXI.DistanceRangeUOM = "Feet"
_NutXI.ProximityRangeUOM = "Meters"
_NutXI.OutOfRangeName = ""
_NutXI.InRangeName = ""
_ZMw = Wherigo.Zone(_YKa)
_ZMw.Id = "c1338c99-f479-449a-b86b-7347c21ddc3c"
_ZMw.Name = _JSg("\016\047\006\094\001\042\084")
_ZMw.Description = ""
_ZMw.Visible = false
_ZMw.Media = _kvJp
_ZMw.Commands = {}
_ZMw.DistanceRange = Distance(-1, "feet")
_ZMw.ShowObjects = "OnEnter"
_ZMw.ProximityRange = Distance(5, "meters")
_ZMw.AllowSetPositionTo = false
_ZMw.Active = false
_ZMw.Points = {
	ZonePoint(43.087438, -0.454674, 0), 
	ZonePoint(43.0874859917966, -0.454774582838067, 0), 
	ZonePoint(43.0875153745106, -0.454686069940575, 0), 
	ZonePoint(43.0874879506446, -0.454600239252099, 0), 
	ZonePoint(43.0874252674762, -0.454592192625054, 0), 
	ZonePoint(43.0873821727608, -0.454659247850426, 0), 
	ZonePoint(43.0873998024208, -0.454750442956933, 0), 
	ZonePoint(43.0874879506446, -0.454779947256097, 0)
}
_ZMw.OriginalPoint = ZonePoint(43.0874528137818, -0.454689590339906, 0)
_ZMw.DistanceRangeUOM = "Feet"
_ZMw.ProximityRangeUOM = "Meters"
_ZMw.OutOfRangeName = ""
_ZMw.InRangeName = ""
_aWUT = Wherigo.Zone(_YKa)
_aWUT.Id = "e83b6ceb-ea7d-4a7f-915d-4c04274e8b1f"
_aWUT.Name = _JSg("\075\006\043\021\001\042\111")
_aWUT.Description = ""
_aWUT.Visible = false
_aWUT.Media = _HXTD
_aWUT.Commands = {}
_aWUT.DistanceRange = Distance(-1, "feet")
_aWUT.ShowObjects = "OnEnter"
_aWUT.ProximityRange = Distance(60, "meters")
_aWUT.AllowSetPositionTo = false
_aWUT.Active = false
_aWUT.Points = {
	ZonePoint(43.087522, -0.45673, 0), 
	ZonePoint(43.0875889680425, -0.456800240348576, 0), 
	ZonePoint(43.0876072097818, -0.456669650297163, 0), 
	ZonePoint(43.0875210205765, -0.456621370534895, 0), 
	ZonePoint(43.0874485431965, -0.456707201223372, 0), 
	ZonePoint(43.0874838024732, -0.456857404928206, 0), 
	ZonePoint(43.0875895801815, -0.456801078538893, 0)
}
_aWUT.OriginalPoint = ZonePoint(43.0875373034646, -0.456740992267301, 0)
_aWUT.DistanceRangeUOM = "Feet"
_aWUT.ProximityRangeUOM = "Meters"
_aWUT.OutOfRangeName = ""
_aWUT.InRangeName = ""

-- Characters --

-- Items --
_CCR = Wherigo.ZItem(_YKa)
_CCR.Id = "5b07f1eb-611e-4b6d-bbff-3ca4079da39d"
_CCR.Name = _JSg("\059\094\086\082\036\001\103\042\043\006\043\021\001\042\114")
_CCR.Description = ""
_CCR.Visible = true
_CCR.Media = _wNXf
_CCR.Commands = {}
_CCR.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_CCR.Locked = false
_CCR.Opened = false
_mUxNd = Wherigo.ZItem(_YKa)
_mUxNd.Id = "92ecec67-f795-42ba-b9e4-d287d17c23f7"
_mUxNd.Name = _JSg("\059\094\086\082\036\001\103\042\043\006\043\021\001\042\111")
_mUxNd.Description = ""
_mUxNd.Visible = true
_mUxNd.Media = _Hwl
_mUxNd.Commands = {}
_mUxNd.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_mUxNd.Locked = false
_mUxNd.Opened = false
_GhP = Wherigo.ZItem(_YKa)
_GhP.Id = "3565d925-f217-4e67-8808-15a8d65e24a0"
_GhP.Name = _JSg("\059\094\086\082\036\001\103\042\043\006\043\021\001\042\026")
_GhP.Description = ""
_GhP.Visible = true
_GhP.Media = _8hNF
_GhP.Commands = {}
_GhP.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_GhP.Locked = false
_GhP.Opened = false
_Syo = Wherigo.ZItem(_YKa)
_Syo.Id = "91e35182-aa95-478c-8986-e70fcc7b2b53"
_Syo.Name = _JSg("\094\006\103\043\042\043\086\053\047\001\053\047\082\086\053\042")
_Syo.Description = ""
_Syo.Visible = true
_Syo.Media = _ErF4
_Syo.Commands = {}
_Syo.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Syo.Locked = false
_Syo.Opened = false
_MsnlS = Wherigo.ZItem(_YKa)
_MsnlS.Id = "d75744c5-bd0d-4aaa-9d75-b24385fc5c3b"
_MsnlS.Name = _JSg("\001\047\006\094\001\042\074")
_MsnlS.Description = ""
_MsnlS.Visible = true
_MsnlS.Media = _8Xj
_MsnlS.Commands = {}
_MsnlS.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_MsnlS.Locked = false
_MsnlS.Opened = false
_pWf2V = Wherigo.ZItem(_YKa)
_pWf2V.Id = "4f28a5c3-59bc-4a93-bdf6-17db53dbf005"
_pWf2V.Name = _JSg("\054\001\036\001\043\047\001\089\103\042\081\001\042\036\006\053\040\089\001\054")
_pWf2V.Description = ""
_pWf2V.Visible = true
_pWf2V.Media = _dsN
_pWf2V.Commands = {
	_vuiS = Wherigo.ZCommand{
		Text = _JSg("\123\103\006\053\043\006\082\054"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _JSg("\028\086\047\021\082\053\040\042\006\029\006\082\036\006\020\036\001")
	}, 
	_Fvm = Wherigo.ZCommand{
		Text = _JSg("\117\053\040\036\006\082\054"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _JSg("\028\086\047\021\082\053\040\042\006\029\006\082\036\006\020\036\001")
	}, 
	_mpS = Wherigo.ZCommand{
		Text = _JSg("\016\054\094\006\040\053\086\036"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _JSg("\028\086\047\021\082\053\040\042\006\029\006\082\036\006\020\036\001")
	}
}
_pWf2V.Commands._vuiS.Custom = true
_pWf2V.Commands._vuiS.Id = "e0da5e7f-9a81-4f7e-9ded-ae38449a30b5"
_pWf2V.Commands._vuiS.WorksWithAll = true
_pWf2V.Commands._Fvm.Custom = true
_pWf2V.Commands._Fvm.Id = "156165a2-f68a-468e-87fe-6402d82e27ab"
_pWf2V.Commands._Fvm.WorksWithAll = true
_pWf2V.Commands._mpS.Custom = true
_pWf2V.Commands._mpS.Id = "7cffcbd1-75cc-4de6-8496-7386315a12bd"
_pWf2V.Commands._mpS.WorksWithAll = true
_pWf2V.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_pWf2V.Locked = false
_pWf2V.Opened = false

-- Tasks --

-- Cartridge Variables --
_Tbe = _JSg("\125\074\116")
_zPa = _JSg("\114")
_8hBYr = _JSg("\111")
_aCBOH = _JSg("\026")
_CTm_8 = _JSg("\111")
_ncb = _JSg("\032\089\082\054\121\037\086\089\015")
_AcG7 = _JSg("\080\082\001\103\103\001\042\103\001\043\047\006\053\040\089\036\006\082\103\001")
_OkLRm = ""
_YKa.ZVariables = {
	_Tbe = _JSg("\125\074\116"), 
	_zPa = _JSg("\114"), 
	_8hBYr = _JSg("\111"), 
	_aCBOH = _JSg("\026"), 
	_CTm_8 = _JSg("\111"), 
	_ncb = _JSg("\032\089\082\054\121\037\086\089\015"), 
	_AcG7 = _JSg("\080\082\001\103\103\001\042\103\001\043\047\006\053\040\089\036\006\082\103\001"), 
	_OkLRm = ""
}

-- Timers --

-- Inputs --
_1zmS6 = Wherigo.ZInput(_YKa)
_1zmS6.Id = "37c9728e-5209-46e1-a34c-2128df19dc08"
_1zmS6.Name = _JSg("\016\047\006\094\001\042\115")
_1zmS6.Description = ""
_1zmS6.Visible = true
_1zmS6.Media = _dpymf
_1zmS6.InputType = "Text"
_1zmS6.Text = _JSg("\117\042\034\089\001\036\036\001\042\006\036\047\082\047\089\081\001\042\043\001\042\047\103\086\089\029\001\042\036\001\042\094\036\006\047\001\006\089\042\081\089\042\064\086\089\017\042\092")
_WvV1I = Wherigo.ZInput(_YKa)
_WvV1I.Id = "1874359f-9160-423b-9750-6e90f8f3bf16"
_WvV1I.Name = _JSg("\016\047\006\094\001\042\026")
_WvV1I.Description = ""
_WvV1I.Visible = true
_WvV1I.Media = _dpymf
_WvV1I.Choices = {
	"2", 
	"3", 
	"4", 
	"5"
}
_WvV1I.InputType = "MultipleChoice"
_WvV1I.Text = _JSg("\118\043\082\042\043\001\042\047\103\086\089\029\001\042\096\053\020\054\094\050\089\053\001\042\047\006\020\036\001\042\001\053\042\094\082\001\103\103\001\046\032\100\120\075\086\017\020\082\001\053\042\006\042\047\042\001\036\036\001\042\081\001\042\094\082\001\081\054\042\092")
_1Ya1f = Wherigo.ZInput(_YKa)
_1Ya1f.Id = "c36649e2-ef62-4d9b-98e1-723e08ca6c50"
_1Ya1f.Name = _JSg("\016\047\006\094\001\042\111")
_1Ya1f.Description = ""
_1Ya1f.Visible = true
_1Ya1f.Media = _dpymf
_1Ya1f.Choices = {
	"2", 
	"3", 
	"4", 
	"5"
}
_1Ya1f.InputType = "MultipleChoice"
_1Ya1f.Text = _JSg("\069\086\089\054\042\001\047\001\054\042\081\001\029\006\053\047\042\036\006\042\043\006\020\006\053\001\042\081\089\042\064\086\089\017\042\046\032\100\120\075\086\017\020\082\001\053\042\006\042\047\042\001\036\036\001\042\081\001\042\004\001\053\001\047\103\001\054\042\092")
_sC9 = Wherigo.ZInput(_YKa)
_sC9.Id = "8880a500-0b1a-4582-a448-3f197c94c3bf"
_sC9.Name = _JSg("\016\047\006\094\001\042\096\053\020\054\094\050\074")
_sC9.Description = ""
_sC9.Visible = true
_sC9.Media = _dpymf
_sC9.Choices = {
	"1", 
	"2", 
	"3", 
	"4"
}
_sC9.InputType = "MultipleChoice"
_sC9.Text = _JSg("\069\086\089\054\042\001\047\001\054\042\081\001\029\006\053\047\042\089\053\001\042\094\001\047\082\047\001\042\043\086\053\054\047\103\089\043\047\082\086\053\042\046\032\100\120\075\086\017\020\082\001\053\042\033\042\006\042\047\042\082\036\042\081\042\086\089\029\001\103\047\089\103\001\042\054\089\103\042\036\001\042\096\053\020\054\094\050\047\086\082\047\042\096\053\020\054\094\050\092")
_xSyrw = Wherigo.ZInput(_YKa)
_xSyrw.Id = "e8c3a752-70f6-446b-82b1-f53df5edc69c"
_xSyrw.Name = _JSg("\016\047\006\094\001\042\083")
_xSyrw.Description = ""
_xSyrw.Visible = true
_xSyrw.Media = _dpymf
_xSyrw.Choices = {
	"2", 
	"4", 
	"5"
}
_xSyrw.InputType = "MultipleChoice"
_xSyrw.Text = _JSg("\075\086\017\020\082\001\053\042\033\042\006\042\047\042\082\036\042\081\001\042\047\103\001\054\042\040\103\006\053\081\042\006\103\020\103\001\042\081\001\029\006\053\047\042\029\086\089\054\042\092")
_wr19v = Wherigo.ZInput(_YKa)
_wr19v.Id = "b88da4fd-4ee9-4ac3-ba85-6c1ea4ac50a9"
_wr19v.Name = _JSg("\016\047\006\094\001\042\125")
_wr19v.Description = ""
_wr19v.Visible = true
_wr19v.Media = _dpymf
_wr19v.Choices = {
	"Buis/Houx", 
	"Noistier/Frene", 
	"Chene/Hetre"
}
_wr19v.InputType = "MultipleChoice"
_wr19v.Text = _JSg("\029\086\089\054\042\001\047\001\054\042\081\001\029\006\053\047\042\089\053\042\017\089\103\042\029\001\040\001\047\006\036\042\034\089\082\042\001\054\047\042\043\086\017\094\086\054\001\042\001\053\042\017\006\060\086\103\082\047\001\042\081\001\002\002\002\002")
_Mu_ = Wherigo.ZInput(_YKa)
_Mu_.Id = "c73600de-96f0-4c40-9e0f-5919d2d4afe8"
_Mu_.Name = _JSg("\016\047\006\094\001\042\084")
_Mu_.Description = ""
_Mu_.Visible = true
_Mu_.Media = _dpymf
_Mu_.Choices = {
	"Pierre ronde", 
	"Panneau", 
	"Pierre rectangulaire", 
	"Souche"
}
_Mu_.InputType = "MultipleChoice"
_Mu_.Text = _JSg("\059\089\103\042\036\001\042\047\006\036\089\054\042\043\001\042\047\103\086\089\029\001\042\089\053\042\086\020\060\001\047\042\002\077\001\034\089\001\036\042\092")
_ctC = Wherigo.ZInput(_YKa)
_ctC.Id = "04df93ba-9a91-4ee3-9a5a-9df2afb9c448"
_ctC.Name = _JSg("\016\047\006\094\001\042\026\042\016")
_ctC.Description = ""
_ctC.Visible = true
_ctC.Media = _dpymf
_ctC.Choices = {
	"2", 
	"3", 
	"4", 
	"5"
}
_ctC.InputType = "MultipleChoice"
_ctC.Text = _JSg("\117\034\089\082\042\021\006\033\042\089\053\006\042\017\001\054\006\042\081\001\042\094\082\001\081\103\006\046\032\100\120\092\075\089\006\053\047\086\042\047\082\001\053\001\042\036\086\054\042\094\082\001\054\092")
_rU3vQ = Wherigo.ZInput(_YKa)
_rU3vQ.Id = "ec5686f2-5124-4a91-a0b3-d82f3bc72847"
_rU3vQ.Name = _JSg("\016\047\006\094\001\042\026\042\117")
_rU3vQ.Description = ""
_rU3vQ.Visible = true
_rU3vQ.Media = _dpymf
_rU3vQ.Choices = {
	"2", 
	"3", 
	"4", 
	"5"
}
_rU3vQ.InputType = "MultipleChoice"
_rU3vQ.Text = _JSg("\037\001\103\001\042\082\054\042\006\042\054\047\086\053\001\042\047\006\020\036\001\046\032\100\120\037\086\085\042\017\089\043\021\042\081\086\001\054\042\082\047\042\004\001\001\047\092")
_0Zf = Wherigo.ZInput(_YKa)
_0Zf.Id = "755e4c02-edd2-40af-b9e3-47762aa3cf36"
_0Zf.Name = _JSg("\016\047\006\094\001\042\111\042\016")
_0Zf.Description = ""
_0Zf.Visible = true
_0Zf.Media = _dpymf
_0Zf.Choices = {
	"2", 
	"3", 
	"4", 
	"5"
}
_0Zf.InputType = "MultipleChoice"
_0Zf.Text = _JSg("\079\054\047\001\081\042\001\054\047\006\042\001\053\042\004\103\001\053\047\001\042\081\001\042\036\006\042\043\006\020\082\053\006\042\064\086\089\017\046\032\100\120\092\075\089\006\053\047\086\042\036\086\042\021\006\043\001\042\094\006\103\006\042\036\006\054\042\029\001\053\047\006\053\006\054\092")
_zVXe = Wherigo.ZInput(_YKa)
_zVXe.Id = "500eb4ee-25c0-47dd-adcb-db4e0b83c3e8"
_zVXe.Name = _JSg("\016\047\006\094\001\042\111\042\117")
_zVXe.Description = ""
_zVXe.Visible = true
_zVXe.Media = _dpymf
_zVXe.Choices = {
	"2", 
	"3", 
	"4", 
	"5"
}
_zVXe.InputType = "MultipleChoice"
_zVXe.Text = _JSg("\073\086\089\042\006\103\001\042\082\053\042\004\103\086\053\047\042\086\004\042\047\021\001\042\043\086\047\047\006\040\001\042\064\086\089\017\046\032\100\120\037\086\085\042\017\089\043\021\042\081\086\001\054\042\082\047\042\004\086\103\042\085\082\053\081\086\085\054\092")
_FuN = Wherigo.ZInput(_YKa)
_FuN.Id = "c5a88664-2a63-41cb-8272-ca48f3aa73ee"
_FuN.Name = _JSg("\016\047\006\094\001\042\096\053\020\054\094\050\074\042\016")
_FuN.Description = ""
_FuN.Visible = true
_FuN.Media = _dpymf
_FuN.Choices = {
	"1", 
	"2", 
	"3", 
	"4"
}
_FuN.InputType = "MultipleChoice"
_FuN.Text = _JSg("\079\054\047\001\081\042\001\054\047\006\042\001\053\042\004\103\001\053\047\001\042\081\001\042\089\053\042\094\001\034\089\001\053\086\042\001\081\082\004\082\043\082\086\046\032\100\120\092\075\089\006\053\047\006\054\042\047\006\103\060\001\047\006\054\042\047\082\001\053\001\042\034\089\001\042\036\006\042\006\094\001\103\047\089\103\006\042\081\001\036\042\047\001\043\021\086\092")
_a0D_ = Wherigo.ZInput(_YKa)
_a0D_.Id = "5a3fae86-6c05-4e42-834d-990b8de2f149"
_a0D_.Name = _JSg("\016\047\006\094\001\042\096\053\020\054\094\050\074\042\117")
_a0D_.Description = ""
_a0D_.Visible = true
_a0D_.Media = _dpymf
_a0D_.Choices = {
	"1", 
	"2", 
	"3", 
	"4"
}
_a0D_.InputType = "MultipleChoice"
_a0D_.Text = _JSg("\073\086\089\042\006\103\001\042\082\053\042\004\103\086\053\047\042\086\004\042\006\042\054\017\006\036\036\042\020\089\082\036\081\082\053\040\046\032\100\120\037\086\085\042\017\006\053\033\042\021\006\054\042\047\042\021\001\042\086\094\001\053\082\053\040\042\086\004\042\047\021\001\042\047\086\094\092")
_wSlQ = Wherigo.ZInput(_YKa)
_wSlQ.Id = "32987949-4db1-4bd2-bd84-6649fa2e4035"
_wSlQ.Name = _JSg("\016\047\006\094\001\042\083\042\016")
_wSlQ.Description = ""
_wSlQ.Visible = true
_wSlQ.Media = _dpymf
_wSlQ.Choices = {
	"2", 
	"4", 
	"5"
}
_wSlQ.InputType = "MultipleChoice"
_wSlQ.Text = _JSg("\092\075\089\006\053\047\086\042\021\006\033\042\081\001\042\006\103\020\086\036\042\017\089\033\042\040\103\006\053\081\001\042\081\001\036\006\053\047\001\042\081\001\042\089\054\047\001\081\092")
_Yl0_q = Wherigo.ZInput(_YKa)
_Yl0_q.Id = "0b563094-6c46-472e-979b-78f3fa822ace"
_Yl0_q.Name = _JSg("\016\047\006\094\001\042\083\042\117")
_Yl0_q.Description = ""
_Yl0_q.Visible = true
_Yl0_q.Media = _dpymf
_Yl0_q.Choices = {
	"2", 
	"4", 
	"5"
}
_Yl0_q.InputType = "MultipleChoice"
_Yl0_q.Text = _JSg("\037\086\085\042\017\089\043\021\042\082\054\042\047\021\001\103\001\042\086\004\042\029\001\103\033\042\036\006\103\040\001\042\047\103\001\001\042\082\053\042\004\103\086\053\047\042\086\004\042\033\086\089\092")
_N1cL = Wherigo.ZInput(_YKa)
_N1cL.Id = "462092ca-395c-49e3-b189-f90d5cb15bfe"
_N1cL.Name = _JSg("\016\047\006\094\001\042\125\042\016")
_N1cL.Description = ""
_N1cL.Visible = true
_N1cL.Media = _dpymf
_N1cL.Choices = {
	"Boj / Acebol", 
	"Noistier / Ash", 
	"Roble / Haya"
}
_N1cL.InputType = "MultipleChoice"
_N1cL.Text = _JSg("\089\054\047\001\081\042\001\054\047\006\042\004\103\001\053\047\001\042\006\042\089\053\006\042\094\006\103\001\081\042\029\001\103\081\001\042\034\089\001\042\054\001\042\043\086\017\094\086\053\001\042\081\001\042\036\006\042\017\006\033\086\103\082\006\042\002\002\002\002")
_WIm = Wherigo.ZInput(_YKa)
_WIm.Id = "49519832-472e-4830-aec4-0660686f38f9"
_WIm.Name = _JSg("\016\047\006\094\001\042\125\042\117")
_WIm.Description = ""
_WIm.Visible = true
_WIm.Media = _dpymf
_WIm.Choices = {
	"Boxwood / Holly", 
	"Noistier / Ash", 
	"Oak / Beech"
}
_WIm.InputType = "MultipleChoice"
_WIm.Text = _JSg("\033\086\089\042\006\103\001\042\082\053\042\004\103\086\053\047\042\086\004\042\006\042\040\103\001\001\053\042\085\006\036\036\042\085\021\082\043\021\042\082\054\042\043\086\017\094\086\054\001\081\042\086\004\042\017\006\060\086\103\082\047\033\042\002\002\002\002")
_JLvI = Wherigo.ZInput(_YKa)
_JLvI.Id = "7227963e-a26e-4311-8246-a79c20399978"
_JLvI.Name = _JSg("\016\047\006\094\001\042\084\042\016")
_JLvI.Description = ""
_JLvI.Visible = true
_JLvI.Media = _dpymf
_JLvI.Choices = {
	"Piedra ronda", 
	"Grupo", 
	"Piedra rectangular", 
	"Cepa"
}
_JLvI.InputType = "MultipleChoice"
_JLvI.Text = _JSg("\016\053\042\001\054\047\006\042\029\001\103\047\082\001\053\047\001\042\001\054\042\089\053\042\086\020\060\001\047\086\002\042\092\107\089\001\092")
_F9z = Wherigo.ZInput(_YKa)
_F9z.Id = "46ef551d-00b8-4627-b933-bb4234476064"
_F9z.Name = _JSg("\016\047\006\094\001\042\084\042\117")
_F9z.Description = ""
_F9z.Visible = true
_F9z.Media = _dpymf
_F9z.Choices = {
	"Round stone", 
	"Panel", 
	"Rectangular stone", 
	"Strain"
}
_F9z.InputType = "MultipleChoice"
_F9z.Text = _JSg("\014\053\042\047\021\082\054\042\054\036\086\094\001\042\082\054\042\006\053\042\086\020\060\001\043\047\002\042\048\021\082\043\021\092")
_BTZVr = Wherigo.ZInput(_YKa)
_BTZVr.Id = "0e92ddc6-15fc-44f4-ba47-744c7bf0f884"
_BTZVr.Name = _JSg("\016\047\006\094\001\042\115\042\016")
_BTZVr.Description = ""
_BTZVr.Visible = true
_BTZVr.Media = _dpymf
_BTZVr.InputType = "Text"
_BTZVr.Text = _JSg("\092\117\042\034\089\001\042\006\036\047\082\047\089\081\042\001\054\047\006\042\001\054\042\036\006\042\064\086\089\017\042\017\001\054\001\047\006\092")
_07s0r = Wherigo.ZInput(_YKa)
_07s0r.Id = "ce790781-c363-44db-9fe1-3c4023373b4e"
_07s0r.Name = _JSg("\016\047\006\094\001\042\115\042\117")
_07s0r.Description = ""
_07s0r.Visible = true
_07s0r.Media = _dpymf
_07s0r.InputType = "Text"
_07s0r.Text = _JSg("\117\047\042\085\021\006\047\042\006\036\047\082\047\089\081\001\042\047\021\082\054\042\082\054\042\047\021\001\042\094\036\006\047\001\006\089\042\064\086\089\017\092")

-- WorksWithList for object commands --

-- functions --
function _YKa:OnStart()
	_pWf2V:MoveTo(Player)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _pWf2V)
end
function _YKa:OnRestore()
end
function _986j:OnEnter()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_1zmS6)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_BTZVr)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_07s0r)
		end)
	end
end
function _CKWRk:OnEnter()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_WvV1I)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_ctC)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_rU3vQ)
		end)
	end
end
function _0xVO:OnEnter()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_1Ya1f)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_0Zf)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_zVXe)
		end)
	end
end
function _0xVO:OnExit()
	_Syo.Visible = false
end
function _irJ6:OnEnter()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\032\082\001\053\042\029\086\089\054\042\006\029\001\019\042\047\103\086\089\029\001\042\036\001\042\094\006\103\043\042\006\042\043\086\053\047\001\053\047\082\086\053\126\042\017\006\082\053\047\001\053\006\053\047\042\094\103\001\053\001\019\042\029\086\047\103\001\042\020\086\089\054\054\086\036\001\042\001\047\042\004\006\082\047\001\054\042\026\116\116\042\017\001\047\103\001\054\042\006\089\042\043\006\094\042\114\083\083\042\094\086\089\103\042\006\103\103\082\029\001\103\042\006\042\036\006\042\043\006\043\021\001\042\022\077\001\042\064\086\089\017\042\018\042\026\042\018\042\096\053\020\054\094\050\104\075\111\010\070\075\100\042\022\042"), 
				Media = _dpymf
			}
		}, function(action)
			_Syo.Visible = false
			_FFoC.Active = true
			_irJ6.Visible = false
			_irJ6.Active = false
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\032\089\001\053\086\126\042\021\001\042\001\053\043\086\053\047\103\006\081\086\042\001\036\042\006\103\040\089\017\001\053\047\086\042\081\001\042\094\006\103\034\089\001\126\042\006\021\086\103\006\042\047\086\017\006\053\042\036\006\042\020\103\089\060\089\036\006\042\033\042\036\006\042\004\006\020\103\082\043\006\043\082\086\053\042\081\001\042\026\116\116\042\017\001\047\103\086\054\042\081\001\042\036\006\042\094\006\103\047\082\081\006\042\114\083\083\042\040\103\006\081\086\054\042\094\006\103\006\042\036\036\001\040\006\103\042\006\036\042\043\006\043\021\001\042\022\077\001\042\064\086\089\017\042\018\042\026\042\018\042\096\053\020\054\094\050\104\075\111\010\070\075\100\042\022\042"), 
				Media = _dpymf
			}
		}, function(action)
			_Syo.Visible = false
			_FFoC.Active = true
			_irJ6.Visible = false
			_irJ6.Active = false
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\048\001\036\036\042\033\086\089\023\029\001\042\004\086\089\053\081\042\047\021\001\042\094\006\103\106\042\043\086\053\047\006\082\053\017\001\053\047\126\042\053\086\085\042\047\006\106\001\042\033\086\089\103\042\043\086\017\094\006\054\054\042\006\053\081\042\017\006\106\001\042\026\116\116\042\017\001\047\001\103\054\042\021\001\006\081\082\053\040\042\114\083\083\042\081\001\040\103\001\001\054\042\047\086\042\103\001\006\043\021\042\047\021\001\042\043\006\043\021\001\042\022\077\001\042\064\086\089\017\042\018\042\026\042\018\042\096\053\020\054\094\050\104\075\111\010\070\075\100\042\022\042"), 
				Media = _dpymf
			}
		}, function(action)
			_Syo.Visible = false
			_FFoC.Active = true
			_irJ6.Visible = false
			_irJ6.Active = false
		end)
	end
	_YKa:RequestSync()
end
function _FFoC:OnEnter()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\032\082\001\053\042\029\086\089\054\042\006\029\001\019\042\047\103\086\089\029\001\042\096\053\020\054\094\050\036\006\042\043\006\043\021\001\042\022\077\001\042\064\086\089\017\042\018\042\026\042\018\042\096\053\020\054\094\050\104\075\111\010\070\075\100\022\042\096\053\020\054\094\050\126\042\017\006\082\053\047\001\053\006\053\047\042\094\103\001\053\001\019\042\029\086\047\103\001\042\020\086\089\054\054\086\036\001\042\001\047\042\004\006\082\047\001\054\042\026\116\116\042\017\001\047\103\001\054\042\006\089\042\043\006\094\042\111\074\116\042\094\086\089\103\042\006\103\103\082\029\001\103\042\006\042\036\006\042\094\103\086\043\021\006\082\053\001\042\001\047\006\094\001\042\096\053\020\054\094\050"), 
				Media = _dpymf
			}, 
			{
				Text = _JSg("\079\053\001\042\094\021\086\047\086\042\054\094\086\082\036\001\103\042\081\001\042\036\006\042\043\006\043\021\001\042\043\001\042\047\103\086\089\029\001\042\081\006\053\054\042\029\086\047\103\001\042\082\053\029\001\053\047\006\082\103\001\042"), 
				Media = _dpymf
			}
		}, function(action)
			_FFoC.Active = false
			_FFoC.Visible = false
			_SmiN.Active = true
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\032\089\001\053\086\126\042\021\001\042\001\053\043\086\053\047\103\006\081\086\042\001\036\042\043\006\043\021\001\042\096\053\020\054\094\050\022\077\001\042\064\086\089\017\042\018\042\026\042\018\042\096\053\020\054\094\050\104\075\111\010\070\075\100\022\126\042\006\021\086\103\006\042\047\086\017\006\053\042\036\006\042\020\103\089\060\089\036\006\042\033\042\036\006\042\004\006\020\103\082\043\006\043\082\086\053\042\081\001\042\026\116\116\042\017\001\047\103\086\054\042\081\001\042\036\006\042\094\006\103\047\082\081\006\042\111\074\116\042\040\103\006\081\086\054\042\094\006\103\006\042\036\036\001\040\006\103\042\006\042\036\006\042\054\082\040\089\082\001\053\047\001\042\001\047\006\094\006"), 
				Media = _dpymf
			}, 
			{
				Text = _JSg("\079\053\006\042\082\017\006\040\001\053\042\081\001\042\036\086\054\042\043\089\001\103\086\054\042\054\094\086\082\036\001\103\042\036\086\042\034\089\001\042\001\054\047\006\042\001\053\042\047\089\042\082\053\029\001\053\047\006\103\082\086"), 
				Media = _dpymf
			}
		}, function(action)
			_FFoC.Active = false
			_FFoC.Visible = false
			_SmiN.Active = true
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\048\001\036\036\042\033\086\089\023\029\001\042\004\086\089\053\081\042\047\021\001\042\043\006\043\021\001\042\096\053\020\054\094\050\022\077\001\042\064\086\089\017\042\018\042\026\042\018\042\096\053\020\054\094\050\104\075\111\010\070\075\100\022\042\126\042\053\086\085\042\047\006\106\001\042\033\086\089\103\042\043\086\017\094\006\054\054\042\006\053\081\042\017\006\106\001\042\026\116\116\042\017\001\047\001\103\054\042\021\001\006\081\082\053\040\042\111\074\116\042\081\001\040\103\001\001\054\042\047\086\042\103\001\006\043\021\042\047\021\001\042\053\001\015\047\042\054\047\006\040\001"), 
				Media = _dpymf
			}, 
			{
				Text = _JSg("\117\042\094\082\043\047\089\103\001\042\086\004\042\047\021\001\042\054\094\086\082\036\001\103\042\021\082\081\001\054\042\085\021\006\047\042\082\054\042\082\053\042\033\086\089\103\042\082\053\029\001\053\047\086\103\033"), 
				Media = _dpymf
			}
		}, function(action)
			_FFoC.Active = false
			_FFoC.Visible = false
			_SmiN.Active = true
		end)
	end
	_YKa:RequestSync()
end
function _FFoC:OnProximity()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_GhP:MoveTo(Player)
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\069\086\089\054\042\001\047\001\054\042\047\086\089\047\042\094\103\001\054\042\081\001\042\036\006\042\043\006\043\021\001\042\043\086\053\047\082\053\089\001\019"), 
				Media = _dpymf
			}
		}, function(action)
			_FFoC.Visible = true
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_GhP:MoveTo(Player)
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\079\054\047\001\081\042\001\054\047\006\042\043\001\103\043\006\042\081\001\042\036\006\042\043\006\043\021\001\042\081\001\042\043\086\053\047\082\053\089\006\103"), 
				Media = _dpymf
			}
		}, function(action)
			_FFoC.Visible = true
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_GhP:MoveTo(Player)
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\073\086\089\042\006\103\001\042\053\001\006\103\042\047\021\001\042\043\006\043\021\001\042\043\086\053\047\082\053\089\001"), 
				Media = _dpymf
			}
		}, function(action)
			_FFoC.Visible = true
		end)
	end
	_YKa:RequestSync()
end
function _SmiN:OnEnter()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_sC9)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_FuN)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_a0D_)
		end)
	end
end
function _SmiN:OnProximity()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.MessageBox{
			Text = _JSg("\069\086\089\054\042\053\023\001\047\001\054\042\094\036\089\054\042\047\103\001\054\042\036\086\082\053\042\089\053\001\042\094\021\086\047\086\042\054\094\086\082\036\001\103\042\043\001\042\047\103\086\089\029\001\042\081\006\053\054\042\029\086\047\103\001\042\082\053\029\001\053\047\006\082\103\001"), 
			Media = _dpymf, 
			Callback = function(action)
				if action ~= nil then
					_MsnlS:MoveTo(Player)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.MessageBox{
			Text = _JSg("\016\054\047\006\054\042\017\089\033\042\043\001\103\043\006\042\081\001\042\089\053\042\054\094\086\082\036\001\103\042\001\054\047\006\042\004\086\047\086\042\001\053\042\047\089\042\082\053\029\001\053\047\006\103\082\086"), 
			Media = _dpymf, 
			Callback = function(action)
				if action ~= nil then
					_MsnlS:MoveTo(Player)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.MessageBox{
			Text = _JSg("\073\086\089\023\103\001\042\029\001\103\033\042\053\001\006\103\036\033\042\006\042\054\094\086\082\036\001\103\042\047\021\082\054\042\094\021\086\047\086\042\082\053\042\033\086\089\103\042\082\053\029\001\053\047\086\103\033"), 
			Media = _dpymf, 
			Callback = function(action)
				if action ~= nil then
					_MsnlS:MoveTo(Player)
				end
			end
		}
	end
end
function _e2T:OnEnter()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_xSyrw)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_wSlQ)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_Yl0_q)
		end)
	end
end
function _8c6C:OnEnter()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_wr19v)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_N1cL)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_WIm)
		end)
	end
end
function _NutXI:OnEnter()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\079\053\001\042\094\021\086\047\086\042\054\094\086\082\036\001\103\042\081\001\042\036\006\042\043\006\043\021\001\042\043\001\042\047\103\086\089\029\001\042\081\006\053\054\042\029\086\047\103\001\042\082\053\029\001\053\047\006\082\103\001\042"), 
				Media = _dpymf
			}
		}, function(action)
			_CKWRk.Active = true
			_CKWRk.Visible = true
			_CCR:MoveTo(Player)
			_YKa.Complete = true
			_YKa:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\079\053\006\042\082\017\006\040\001\053\042\081\001\042\036\086\054\042\043\089\001\103\086\054\042\054\094\086\082\036\001\103\042\036\086\042\034\089\001\042\001\054\047\006\042\001\053\042\047\089\042\082\053\029\001\053\047\006\103\082\086"), 
				Media = _dpymf
			}
		}, function(action)
			_CKWRk.Active = true
			_CKWRk.Visible = true
			_CCR:MoveTo(Player)
			_YKa.Complete = true
			_YKa:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\117\042\094\082\043\047\089\103\001\042\086\004\042\047\021\001\042\054\094\086\082\036\001\103\042\021\082\081\001\054\042\085\021\006\047\042\082\054\042\082\053\042\033\086\089\103\042\082\053\029\001\053\047\086\103\033"), 
				Media = _dpymf
			}
		}, function(action)
			_CKWRk.Active = true
			_CKWRk.Visible = true
			_CCR:MoveTo(Player)
			_YKa.Complete = true
			_YKa:RequestSync()
		end)
	end
end
function _NutXI:OnExit()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\010\001\042\029\086\089\054\042\103\001\017\001\103\043\082\001\042\081\001\042\017\023\006\029\086\082\103\042\054\089\082\029\082\042\047\086\089\047\042\006\089\042\036\086\053\040\042\081\001\042\043\001\047\047\001\042\094\103\086\017\001\053\006\081\001\042\126\042\017\006\082\053\047\001\053\006\053\047\042\036\006\042\043\006\103\047\086\089\043\021\001\042\029\006\042\054\001\042\054\006\089\029\001\040\006\103\081\001\103\042\001\047\042\054\001\042\004\001\103\017\001\103"), 
				Media = _dpymf
			}
		}, function(action)
			_NutXI.Active = false
			_CKWRk.Active = false
			_CKWRk.Visible = false
			_NutXI.Visible = false
			Wherigo.Command "SaveClose"
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\104\103\006\043\082\006\054\042\094\086\103\042\054\001\040\089\082\103\017\001\042\006\042\036\086\042\036\006\103\040\086\042\081\001\042\036\006\042\043\006\017\082\053\006\047\006\126\042\001\036\042\043\006\103\047\089\043\021\086\042\081\001\042\006\021\086\103\006\126\042\040\089\006\103\081\001\042\033\042\043\082\001\103\103\001"), 
				Media = _dpymf
			}
		}, function(action)
			_NutXI.Active = false
			_CKWRk.Active = false
			_CKWRk.Visible = false
			_NutXI.Visible = false
			Wherigo.Command "SaveClose"
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\049\021\006\053\106\042\033\086\089\042\004\086\103\042\004\086\036\036\086\085\082\053\040\042\017\001\042\047\021\103\086\089\040\021\086\089\047\042\047\021\001\042\085\006\036\106\126\042\047\021\001\042\043\006\103\047\103\082\081\040\001\042\085\082\036\036\042\053\086\085\042\054\006\029\001\042\006\053\081\042\043\036\086\054\001"), 
				Media = _dpymf
			}
		}, function(action)
			_NutXI.Active = false
			_CKWRk.Active = false
			_CKWRk.Visible = false
			_NutXI.Visible = false
			Wherigo.Command "SaveClose"
		end)
	end
end
function _ZMw:OnEnter()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_Mu_)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_JLvI)
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_F9z)
		end)
	end
end
function _aWUT:OnEnter()
	if Wherigo.NoCaseEquals(_OkLRm, _JSg("\026")) then
		_mUxNd:MoveTo(Player)
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\079\053\001\042\094\021\086\047\086\042\054\094\086\082\036\001\103\042\043\001\042\047\103\086\089\029\001\042\081\006\053\054\042\029\086\047\103\001\042\082\053\029\001\053\047\006\082\103\001"), 
				Media = _dpymf
			}, 
			{
				Text = _JSg("\032\082\001\053\042\029\086\089\054\042\006\029\001\019\042\047\103\086\089\029\001\042\096\053\020\054\094\050\036\006\042\043\006\043\021\001\042\022\077\001\042\064\086\089\017\042\018\042\111\042\018\042\096\053\020\054\094\050\096\053\020\054\094\050\104\075\111\010\070\075\078\022\042\096\053\020\054\094\050\126\042\017\006\082\053\047\001\053\006\053\047\042\094\103\001\053\001\019\042\029\086\047\103\001\042\020\086\089\054\054\086\036\001\042\001\047\042\004\006\082\047\001\054\042\026\084\116\042\017\001\047\103\001\054\042\006\089\042\043\006\094\042\062\083\042\094\086\089\103\042\006\103\103\082\029\001\103\042\006\042\036\006\042\094\103\086\043\021\006\082\053\001\042\001\047\006\094\001\042\096\053\020\054\094\050"), 
				Media = _dpymf
			}
		}, function(action)
			_ZMw.Active = true
			_ZMw.Visible = false
			_aWUT.Active = false
			_aWUT.Visible = false
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\111")) then
		_mUxNd:MoveTo(Player)
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\079\053\006\042\004\086\047\086\042\034\089\001\042\006\036\001\103\086\053\042\001\053\042\054\089\042\082\053\029\001\053\047\006\103\082\086"), 
				Media = _dpymf
			}, 
			{
				Text = _JSg("\032\089\001\053\086\126\042\021\001\042\001\053\043\086\053\047\103\006\081\086\042\001\036\042\043\006\043\021\001\042\096\053\020\054\094\050\022\077\001\042\064\086\089\017\042\018\042\111\042\018\042\096\053\020\054\094\050\096\053\020\054\094\050\104\075\111\010\070\075\078\022\126\042\006\021\086\103\006\042\047\086\017\006\042\036\006\042\020\103\089\060\089\036\006\042\033\042\103\001\043\082\020\001\042\026\084\116\042\017\001\047\103\086\054\042\081\001\042\036\006\042\094\006\103\047\082\081\006\042\062\083\042\040\103\006\081\086\054\042\094\006\103\006\042\036\036\001\040\006\103\042\006\042\036\006\042\054\082\040\089\082\001\053\047\001\042\001\047\006\094\006"), 
				Media = _dpymf
			}
		}, function(action)
			_ZMw.Active = true
			_ZMw.Visible = false
			_aWUT.Active = false
			_aWUT.Visible = false
		end)
	elseif Wherigo.NoCaseEquals(_OkLRm, _JSg("\114")) then
		_mUxNd:MoveTo(Player)
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\117\042\094\021\086\047\086\042\047\021\006\047\042\054\094\086\082\036\001\103\042\082\053\042\033\086\089\103\042\082\053\029\001\053\047\086\103\033"), 
				Media = _dpymf
			}, 
			{
				Text = _JSg("\042\048\001\036\036\042\033\086\089\023\029\001\042\004\086\089\053\081\042\047\021\001\042\043\006\043\021\001\042\096\053\020\054\094\050\022\077\001\042\064\086\089\017\042\018\042\111\042\018\042\096\053\020\054\094\050\096\053\020\054\094\050\104\075\111\010\070\075\078\022\126\042\053\086\085\042\047\006\106\001\042\033\086\089\103\042\043\086\017\094\006\054\054\042\006\053\081\042\040\001\047\042\026\084\116\042\017\001\047\001\103\054\042\021\001\006\081\082\053\040\042\062\083\042\081\001\040\103\001\001\054\042\047\086\042\103\001\006\043\021\042\047\021\001\042\053\001\015\047\042\054\047\006\040\001"), 
				Media = _dpymf
			}
		}, function(action)
			_ZMw.Active = true
			_ZMw.Visible = false
			_aWUT.Active = false
			_aWUT.Visible = false
		end)
	end
end
function _aWUT:OnExit()
	_mUxNd.Visible = false
end
function _1zmS6:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Tbe = input
	if Wherigo.NoCaseEquals(_AcG7, _JSg("\080\082\001\103\103\001\042\103\001\043\047\006\053\040\089\036\006\082\103\001")) and Wherigo.NoCaseEquals(_Tbe, _JSg("\125\074\116")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\032\103\006\029\086\042\029\086\089\054\042\006\029\001\019\042\020\082\001\053\042\103\001\094\086\053\081\089\042\006\089\015\042\034\089\001\054\047\082\086\053\054\042\001\047\042\017\006\082\053\047\001\053\006\053\047\042\029\086\089\054\042\094\086\089\029\001\019\042\006\036\036\001\103\042\043\021\001\103\043\021\001\103\042\036\006\042\043\006\043\021\001\042\022\042\077\001\042\094\036\006\047\001\006\089\042\081\089\042\064\086\089\017\042\104\075\111\123\074\117\104\042\022"), 
				Media = _dpymf
			}
		}, function(action)
			_986j.Active = false
			_986j.Visible = false
			_NutXI.Active = true
			_NutXI.Visible = true
		end)
		_YKa:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\013\001\054\086\036\001\042\017\006\082\054\042\029\086\089\054\042\006\029\001\019\042\089\053\001\042\017\006\089\029\006\082\054\001\042\103\001\094\086\053\054\001\042\001\047\042\082\036\042\029\086\089\054\042\004\006\089\047\042\103\001\029\001\053\082\103\042\006\042\036\023\001\047\006\094\001\042\084")
			}
		}, function(action)
			_986j.Visible = false
			_986j.Active = false
			_ZMw.Active = true
			_ZMw.Visible = true
		end)
	end
end
function _WvV1I:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_zPa = input
	_CKWRk.Visible = false
	_CKWRk.Active = false
	_0xVO.Visible = true
	_0xVO.Active = true
end
function _1Ya1f:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_8hBYr = input
	if Wherigo.NoCaseEquals(_8hBYr, _JSg("\111")) and Wherigo.NoCaseEquals(_zPa, _JSg("\114")) then
		_Syo:MoveTo(Player)
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\032\082\001\053\042\017\006\082\053\047\001\053\006\053\047\042\029\086\089\054\042\006\036\036\001\019\042\081\001\029\086\082\103\042\047\103\086\089\029\001\103\042\089\053\042\094\006\103\043\042\006\042\043\086\053\047\001\053\047\082\086\053\042"), 
				Media = _dpymf
			}, 
			{
				Text = _JSg("\080\086\089\103\042\096\053\020\054\094\050\054\006\029\086\082\103\042\043\001\042\034\089\001\042\029\086\089\054\042\043\021\001\103\043\021\001\019\042\089\053\001\042\094\021\086\047\086\042\054\094\086\082\036\001\103\042\001\054\047\042\081\006\053\054\042\029\086\047\103\001\042\082\053\029\001\053\047\006\082\103\001\042"), 
				Media = _dpymf
			}
		}, function(action)
			_irJ6.Active = true
			_0xVO.Active = false
			_0xVO.Visible = false
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\013\001\054\086\036\001\042\017\006\082\054\042\029\086\089\054\042\006\029\001\019\042\089\053\001\042\017\006\089\029\006\082\054\001\042\103\001\094\086\053\054\001\042\001\047\042\082\036\042\029\086\089\054\042\004\006\089\047\042\103\001\029\001\053\082\103\042\006\042\036\023\001\047\006\094\001\042\026"), 
				Media = _dpymf
			}
		}, function(action)
			_0xVO.Active = false
			_0xVO.Visible = false
			_CKWRk.Active = true
			_CKWRk.Visible = true
		end)
	end
	_YKa:RequestSync()
end
function _sC9:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_aCBOH = input
	_SmiN.Active = false
	_SmiN.Visible = false
	_e2T.Active = true
	_e2T.Visible = true
end
function _xSyrw:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_CTm_8 = input
	_e2T.Visible = false
	_e2T.Active = false
	_8c6C.Active = true
	_8c6C.Visible = true
end
function _wr19v:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_ncb = input
	if (Wherigo.NoCaseEquals(_aCBOH, _JSg("\026")) and Wherigo.NoCaseEquals(_CTm_8, _JSg("\111"))) and Wherigo.NoCaseEquals(_ncb, _JSg("\032\089\082\054\121\037\086\089\015")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\032\103\006\029\086\042\029\086\089\054\042\006\029\001\019\042\020\082\001\053\042\103\001\094\086\053\081\089\042\006\089\015\042\034\089\001\054\047\082\086\053\054\042\001\047\042\017\006\082\053\047\001\053\006\053\047\042\029\086\089\054\042\094\086\089\029\001\019\042\006\036\036\001\103\042\043\021\001\103\043\021\001\103\042\036\006\042\043\006\043\021\001\042\022\042\077\001\042\064\086\089\017\042\018\042\111\042\018\042\096\053\020\054\094\050\096\053\020\054\094\050\104\075\111\010\070\075\078\022"), 
				Media = _dpymf
			}
		}, function(action)
			_8c6C.Active = false
			_8c6C.Visible = false
			_aWUT.Active = true
			_aWUT.Visible = true
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\013\001\054\086\036\001\042\017\006\082\054\042\029\086\089\054\042\006\029\001\019\042\089\053\001\042\017\006\089\029\006\082\054\001\042\103\001\094\086\053\054\001\042\001\047\042\082\036\042\029\086\089\054\042\004\006\089\047\042\103\001\029\001\053\082\103\042\006\042\036\023\001\047\006\094\001\042\074"), 
				Media = _dpymf
			}
		}, function(action)
			_8c6C.Active = false
			_8c6C.Visible = false
			_SmiN.Visible = true
			_SmiN.Active = true
		end)
	end
	_YKa:RequestSync()
end
function _Mu_:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_AcG7 = input
	_ZMw.Visible = false
	_ZMw.Active = false
	_986j.Active = true
	_986j.Visible = true
end
function _ctC:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_zPa = input
	_CKWRk.Visible = false
	_CKWRk.Active = false
	_0xVO.Visible = true
	_0xVO.Active = true
end
function _rU3vQ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_zPa = input
	_CKWRk.Visible = false
	_CKWRk.Active = false
	_0xVO.Visible = true
	_0xVO.Active = true
end
function _0Zf:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_8hBYr = input
	if Wherigo.NoCaseEquals(_8hBYr, _JSg("\111")) and Wherigo.NoCaseEquals(_zPa, _JSg("\114")) then
		_Syo:MoveTo(Player)
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\032\089\001\053\086\126\042\006\021\086\103\006\042\089\054\047\001\081\042\047\082\001\053\001\042\034\089\001\042\001\053\043\086\053\047\103\006\103\042\089\053\042\094\006\103\034\089\001\042\001\053\042\043\086\053\047\082\001\053\081\006"), 
				Media = _dpymf
			}, 
			{
				Text = _JSg("\080\006\103\006\042\001\053\043\086\053\047\103\006\103\042\036\086\042\034\089\001\042\001\054\047\006\042\020\089\054\043\006\053\081\086\042\089\053\042\054\094\086\082\036\001\103\042\004\086\047\086\042\001\054\047\006\042\001\053\042\047\089\042\082\053\029\001\053\047\006\103\082\086"), 
				Media = _dpymf
			}
		}, function(action)
			_irJ6.Active = true
			_0xVO.Active = false
			_0xVO.Visible = false
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\077\086\042\054\001\053\047\082\017\086\054\126\042\094\001\103\086\042\089\054\047\001\081\042\047\082\001\053\001\042\089\053\006\042\103\001\054\094\089\001\054\047\006\042\001\034\089\082\029\086\043\006\081\006\042\033\042\081\001\020\001\042\029\086\036\029\001\103\042\006\036\042\094\006\054\086\042\026"), 
				Media = _dpymf
			}
		}, function(action)
			_0xVO.Active = false
			_0xVO.Visible = false
			_CKWRk.Active = true
			_CKWRk.Visible = true
		end)
	end
	_YKa:RequestSync()
end
function _zVXe:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_8hBYr = input
	if Wherigo.NoCaseEquals(_8hBYr, _JSg("\111")) and Wherigo.NoCaseEquals(_zPa, _JSg("\114")) then
		_Syo:MoveTo(Player)
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\048\001\036\036\042\053\086\085\042\033\086\089\023\036\036\042\021\006\029\001\042\047\086\042\004\082\053\081\042\006\042\094\006\103\106\042\082\053\042\043\086\053\047\006\082\053\017\001\053\047"), 
				Media = _dpymf
			}, 
			{
				Text = _JSg("\049\086\042\004\082\053\081\042\085\021\006\047\042\033\086\089\042\006\103\001\042\036\086\086\106\082\053\040\042\004\086\103\042\006\042\094\021\086\047\086\042\054\094\086\082\036\001\103\042\082\054\042\082\053\042\033\086\089\103\042\082\053\029\001\053\047\086\103\033"), 
				Media = _dpymf
			}
		}, function(action)
			_irJ6.Active = true
			_0xVO.Active = false
			_0xVO.Visible = false
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\059\086\103\103\033\042\020\089\047\042\033\086\089\042\021\006\029\001\042\006\042\085\103\086\053\040\042\006\053\054\085\001\103\042\006\053\081\042\033\086\089\042\017\089\054\047\042\103\001\047\089\103\053\042\047\086\042\054\047\001\094\042\026"), 
				Media = _dpymf
			}
		}, function(action)
			_0xVO.Active = false
			_0xVO.Visible = false
			_CKWRk.Active = true
			_CKWRk.Visible = true
		end)
	end
	_YKa:RequestSync()
end
function _FuN:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_aCBOH = input
	_SmiN.Active = false
	_SmiN.Visible = false
	_e2T.Active = true
	_e2T.Visible = true
end
function _a0D_:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_aCBOH = input
	_SmiN.Active = false
	_SmiN.Visible = false
	_e2T.Active = true
	_e2T.Visible = true
end
function _wSlQ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_CTm_8 = input
	_e2T.Visible = false
	_e2T.Active = false
	_8c6C.Active = true
	_8c6C.Visible = true
end
function _Yl0_q:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_CTm_8 = input
	_e2T.Visible = false
	_e2T.Active = false
	_8c6C.Active = true
	_8c6C.Visible = true
end
function _N1cL:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_ncb = input
	if (Wherigo.NoCaseEquals(_aCBOH, _JSg("\026")) and Wherigo.NoCaseEquals(_CTm_8, _JSg("\111"))) and Wherigo.NoCaseEquals(_ncb, _JSg("\032\086\060\042\121\042\117\043\001\020\086\036")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\123\001\036\082\043\082\047\006\043\082\086\053\001\054\042\089\054\047\001\081\042\021\006\042\043\086\053\047\001\054\047\006\081\086\042\036\006\054\042\094\103\001\040\089\053\047\006\054\042\033\042\006\021\086\103\006\042\089\054\047\001\081\042\094\089\001\081\001\042\082\103\042\094\006\103\006\042\036\006\042\043\006\043\021\001\042\022\042\077\001\042\064\086\089\017\042\018\042\111\042\018\042\096\053\020\054\094\050\096\053\020\054\094\050\104\075\111\010\070\075\078\022"), 
				Media = _dpymf
			}
		}, function(action)
			_8c6C.Active = false
			_8c6C.Visible = false
			_aWUT.Active = true
			_aWUT.Visible = true
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\077\086\042\054\001\053\047\082\017\086\054\126\042\094\001\103\086\042\089\054\047\001\081\042\047\082\001\053\001\042\089\053\006\042\103\001\054\094\089\001\054\047\006\042\001\034\089\082\029\086\043\006\081\006\042\033\042\021\006\033\042\034\089\001\042\029\086\036\029\001\103\042\006\036\042\094\006\054\086\042\074"), 
				Media = _dpymf
			}
		}, function(action)
			_8c6C.Active = false
			_8c6C.Visible = false
			_SmiN.Visible = true
			_SmiN.Active = true
		end)
	end
	_YKa:RequestSync()
end
function _WIm:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_ncb = input
	if (Wherigo.NoCaseEquals(_aCBOH, _JSg("\026")) and Wherigo.NoCaseEquals(_CTm_8, _JSg("\111"))) and Wherigo.NoCaseEquals(_ncb, _JSg("\032\086\015\085\086\086\081\042\121\042\037\086\036\036\033")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\075\086\053\040\103\006\047\089\036\006\047\082\086\053\054\042\033\086\089\042\021\006\029\001\042\006\053\054\085\001\103\001\081\042\034\089\001\054\047\082\086\053\054\042\006\053\081\042\053\086\085\042\033\086\089\042\043\006\053\042\040\086\042\004\086\103\042\047\021\001\042\043\006\043\021\001\042\022\042\077\001\042\064\086\089\017\042\018\042\111\042\018\042\096\053\020\054\094\050\096\053\020\054\094\050\104\075\111\010\070\075\078\022"), 
				Media = _dpymf
			}
		}, function(action)
			_8c6C.Active = false
			_8c6C.Visible = false
			_aWUT.Active = true
			_aWUT.Visible = true
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\059\086\103\103\033\042\020\089\047\042\033\086\089\042\021\006\029\001\042\006\042\085\103\086\053\040\042\006\053\054\085\001\103\042\006\053\081\042\033\086\089\042\021\006\029\001\042\047\086\042\040\086\042\020\006\043\106\042\047\086\042\054\047\001\094\042\074"), 
				Media = _dpymf
			}
		}, function(action)
			_8c6C.Active = false
			_8c6C.Visible = false
			_SmiN.Visible = true
			_SmiN.Active = true
		end)
	end
	_YKa:RequestSync()
end
function _JLvI:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_AcG7 = input
	_ZMw.Visible = false
	_ZMw.Active = false
	_986j.Active = true
	_986j.Visible = true
end
function _F9z:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_AcG7 = input
	_ZMw.Visible = false
	_ZMw.Active = false
	_986j.Active = true
	_986j.Visible = true
end
function _BTZVr:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Tbe = input
	if Wherigo.NoCaseEquals(_AcG7, _JSg("\080\082\001\081\103\006\042\103\001\043\047\006\053\040\089\036\006\103")) and Wherigo.NoCaseEquals(_Tbe, _JSg("\125\074\116")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\075\086\053\040\103\006\047\089\036\006\047\082\086\053\054\042\033\086\089\042\021\006\029\001\042\006\053\054\085\001\103\001\081\042\034\089\001\054\047\082\086\053\054\042\006\053\081\042\053\086\085\042\033\086\089\042\043\006\053\042\040\086\042\004\086\103\042\047\021\001\042\043\006\043\021\001\022\042\077\001\042\094\036\006\047\001\006\089\042\081\089\042\064\086\089\017\042\104\075\111\123\074\117\104\042\022"), 
				Media = _dpymf
			}
		}, function(action)
			_986j.Active = false
			_986j.Visible = false
			_NutXI.Active = true
			_NutXI.Visible = true
		end)
		_YKa:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\077\086\042\054\001\053\047\082\017\086\054\126\042\094\001\103\086\042\089\054\047\001\081\042\047\082\001\053\001\042\089\053\006\042\103\001\054\094\089\001\054\047\006\042\001\034\089\082\029\086\043\006\081\006\042\033\042\081\001\020\001\042\029\086\036\029\001\103\042\006\036\042\094\006\054\086\042\084")
			}
		}, function(action)
			_986j.Visible = false
			_986j.Active = false
			_ZMw.Active = true
			_ZMw.Visible = true
		end)
	end
end
function _07s0r:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Tbe = input
	if Wherigo.NoCaseEquals(_AcG7, _JSg("\100\001\043\047\006\053\040\089\036\006\103\042\054\047\086\053\001")) and Wherigo.NoCaseEquals(_Tbe, _JSg("\125\074\116")) then
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\075\086\053\040\103\006\047\089\036\006\047\082\086\053\054\042\033\086\089\042\021\006\029\001\042\006\053\054\085\001\103\001\081\042\034\089\001\054\047\082\086\053\054\042\006\053\081\042\053\086\085\042\033\086\089\042\043\006\053\042\040\086\042\004\086\103\042\047\021\001\042\043\006\043\021\001\042\022\042\077\001\042\094\036\006\047\001\006\089\042\081\089\042\064\086\089\017\042\104\075\111\123\074\117\104\042\022"), 
				Media = _dpymf
			}
		}, function(action)
			_986j.Active = false
			_986j.Visible = false
			_NutXI.Active = true
			_NutXI.Visible = true
		end)
		_YKa:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _JSg("\059\086\103\103\033\042\020\089\047\042\033\086\089\042\021\006\029\001\042\006\042\085\103\086\053\040\042\006\053\054\085\001\103\042\006\053\081\042\033\086\089\042\017\089\054\047\042\103\001\047\089\103\053\042\047\086\042\054\047\001\094\042\084")
			}
		}, function(action)
			_986j.Visible = false
			_986j.Active = false
			_ZMw.Active = true
			_ZMw.Visible = true
		end)
	end
end
function _pWf2V:On_vuiS(target)
	_OkLRm = _JSg("\026")
	_CKWRk.Active = true
	_CKWRk.Visible = true
	_pWf2V.Visible = false
end
function _pWf2V:On_Fvm(target)
	_OkLRm = _JSg("\114")
	_CKWRk.Visible = true
	_CKWRk.Active = true
	_pWf2V.Visible = false
end
function _pWf2V:On_mpS(target)
	_OkLRm = _JSg("\111")
	_CKWRk.Active = true
	_CKWRk.Visible = true
	_pWf2V.Visible = false
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return _YKa
