require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _C0U(str)
	local res = ""
    local dtable = "\053\032\050\101\071\002\116\026\029\014\031\027\124\095\112\073\089\078\042\045\098\063\000\077\118\057\082\044\114\008\067\020\093\109\036\076\062\066\115\064\009\106\117\035\111\025\083\065\028\033\018\005\087\080\070\125\061\088\056\122\013\074\011\091\108\120\121\006\092\047\010\105\046\003\041\096\055\021\072\113\059\068\099\015\094\043\097\084\081\110\052\001\126\012\103\069\034\119\017\100\060\123\086\004\038\104\037\075\085\051\019\079\024\039\048\030\049\023\007\090\040\022\016\102\107\054\058"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

cartLegendsofSLAGA = Wherigo.ZCartridge()

-- Media --
zmedia029e81d04655454f9566dde1af9803a7 = Wherigo.ZMedia(cartLegendsofSLAGA)
zmedia029e81d04655454f9566dde1af9803a7.Id = "746921a9-b3f2-4956-b03a-7828670b895e"
zmedia029e81d04655454f9566dde1af9803a7.Name = _C0U("\115\003\026\004\059\117\100\115\091\126\001\001\091\001\091\124\026\001\126\126\100\100\004\117\087\124\026\059\115\110\087\077")
zmedia029e81d04655454f9566dde1af9803a7.Description = _C0U("\034\004\100\072\087")
zmedia029e81d04655454f9566dde1af9803a7.AltText = ""
zmedia029e81d04655454f9566dde1af9803a7.Resources = {
	{
		Type = "jpg", 
		Filename = "029e81d0-4655-454f-9566-dde1af9803a7.jpg", 
		Directives = {}
	}
}
_Vjlb = Wherigo.ZMedia(cartLegendsofSLAGA)
_Vjlb.Id = "f4f42c49-a745-411f-a450-3e5fef89274d"
_Vjlb.Name = _C0U("\098\106\004\029\072\095\045")
_Vjlb.Description = ""
_Vjlb.AltText = ""
_Vjlb.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo_icon.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
cartLegendsofSLAGA.Id="e4449bdd-fe6f-4821-936b-7e499c54964c"
cartLegendsofSLAGA.Name="Legends of SLAGA"
cartLegendsofSLAGA.Description=[[The Legends of SLAGA wherigo geoart series. This series of 28 caches covers the history of SLAGA from 2001-2016. ]]
cartLegendsofSLAGA.Visible=true
cartLegendsofSLAGA.Activity="Puzzle"
cartLegendsofSLAGA.StartingLocationDescription=[[]]
cartLegendsofSLAGA.StartingLocation = ZonePoint(38.5287,-90.4356333333333,0)
cartLegendsofSLAGA.Version="0.01"
cartLegendsofSLAGA.Company=""
cartLegendsofSLAGA.Author="Forest-Ghost"
cartLegendsofSLAGA.BuilderVersion="URWIGO 1.22.5798.37755"
cartLegendsofSLAGA.CreateDate="04/28/2016 02:59:13"
cartLegendsofSLAGA.PublishDate="1/1/0001 12:00:00 AM"
cartLegendsofSLAGA.UpdateDate="04/29/2016 18:32:17"
cartLegendsofSLAGA.LastPlayedDate="1/1/0001 12:00:00 AM"
cartLegendsofSLAGA.TargetDevice="PocketPC"
cartLegendsofSLAGA.TargetDeviceVersion="0"
cartLegendsofSLAGA.StateId="1"
cartLegendsofSLAGA.CountryId="2"
cartLegendsofSLAGA.Complete=false
cartLegendsofSLAGA.UseLogging=true

cartLegendsofSLAGA.Media=zmedia029e81d04655454f9566dde1af9803a7

cartLegendsofSLAGA.Icon=_Vjlb


-- Zones --
zone1 = Wherigo.Zone(cartLegendsofSLAGA)
zone1.Id = "bd156696-a097-4f91-9ad3-83b80ffcf04b"
zone1.Name = _C0U("\117")
zone1.Description = _C0U("\018\002\110\059\002\110\117\073\077\003\003\002\053\002\026\115\002\003\126\073\117\110\059")
zone1.Visible = true
zone1.Media = zmedia029e81d04655454f9566dde1af9803a7
zone1.Commands = {}
zone1.DistanceRange = Distance(-1, "feet")
zone1.ShowObjects = "OnEnter"
zone1.ProximityRange = Distance(8, "meters")
zone1.AllowSetPositionTo = false
zone1.Active = false
zone1.Points = {
	ZonePoint(38.528735, -90.4355983333333, 0), 
	ZonePoint(38.528735, -90.4356683333333, 0), 
	ZonePoint(38.528665, -90.4356683333333, 0), 
	ZonePoint(38.528665, -90.4355983333333, 0)
}
zone1.OriginalPoint = ZonePoint(38.5287, -90.4356333333333, 0)
zone1.DistanceRangeUOM = "Feet"
zone1.ProximityRangeUOM = "Meters"
zone1.OutOfRangeName = ""
zone1.InRangeName = ""
zone2 = Wherigo.Zone(cartLegendsofSLAGA)
zone2.Id = "6284f16c-8391-4d94-8dc8-3376dc357e21"
zone2.Name = _C0U("\003")
zone2.Description = _C0U("\018\110\059\002\110\117\073\026\117\077\002\105\090\021\039\015\081\053\115\026\115\002\003\126\073\117\110\077")
zone2.Visible = true
zone2.Media = zmedia029e81d04655454f9566dde1af9803a7
zone2.Commands = {}
zone2.DistanceRange = Distance(-1, "feet")
zone2.ShowObjects = "OnEnter"
zone2.ProximityRange = Distance(8, "meters")
zone2.AllowSetPositionTo = false
zone2.Active = false
zone2.Points = {
	ZonePoint(38.531985, -90.4355816666667, 0), 
	ZonePoint(38.531985, -90.4356516666667, 0), 
	ZonePoint(38.531915, -90.4356516666667, 0), 
	ZonePoint(38.531915, -90.4355816666667, 0)
}
zone2.OriginalPoint = ZonePoint(38.53195, -90.4356166666667, 0)
zone2.DistanceRangeUOM = "Feet"
zone2.ProximityRangeUOM = "Meters"
zone2.OutOfRangeName = ""
zone2.InRangeName = ""
zone3 = Wherigo.Zone(cartLegendsofSLAGA)
zone3.Id = "0ca159ce-2741-4f11-a683-dec4e4062465"
zone3.Name = _C0U("\110")
zone3.Description = _C0U("\018\110\059\002\110\003\073\115\117\077\002\105\090\021\039\015\081\053\115\026\115\002\003\126\073\117\091\117")
zone3.Visible = true
zone3.Media = zmedia029e81d04655454f9566dde1af9803a7
zone3.Commands = {}
zone3.DistanceRange = Distance(-1, "feet")
zone3.ShowObjects = "OnEnter"
zone3.ProximityRange = Distance(8, "meters")
zone3.AllowSetPositionTo = false
zone3.Active = false
zone3.Points = {
	ZonePoint(38.5336516666667, -90.4356483333333, 0), 
	ZonePoint(38.5336516666667, -90.4357183333333, 0), 
	ZonePoint(38.5335816666667, -90.4357183333333, 0), 
	ZonePoint(38.5335816666667, -90.4356483333333, 0)
}
zone3.OriginalPoint = ZonePoint(38.5336166666667, -90.4356833333333, 0)
zone3.DistanceRangeUOM = "Feet"
zone3.ProximityRangeUOM = "Meters"
zone3.OutOfRangeName = ""
zone3.InRangeName = ""
zone4 = Wherigo.Zone(cartLegendsofSLAGA)
zone4.Id = "de5dc047-984a-4f9e-8368-310fe47a8997"
zone4.Name = _C0U("\091")
zone4.Description = _C0U("\018\110\059\002\110\003\073\117\115\126\002\105\090\021\039\015\081\053\115\026\115\002\003\126\073\117\110\001")
zone4.Visible = true
zone4.Media = zmedia029e81d04655454f9566dde1af9803a7
zone4.Commands = {}
zone4.DistanceRange = Distance(-1, "feet")
zone4.ShowObjects = "OnEnter"
zone4.ProximityRange = Distance(8, "meters")
zone4.AllowSetPositionTo = false
zone4.Active = false
zone4.Points = {
	ZonePoint(38.535135, -90.4355483333333, 0), 
	ZonePoint(38.535135, -90.4356183333333, 0), 
	ZonePoint(38.535065, -90.4356183333333, 0), 
	ZonePoint(38.535065, -90.4355483333333, 0)
}
zone4.OriginalPoint = ZonePoint(38.5351, -90.4355833333333, 0)
zone4.DistanceRangeUOM = "Feet"
zone4.ProximityRangeUOM = "Meters"
zone4.OutOfRangeName = ""
zone4.InRangeName = ""
zone5 = Wherigo.Zone(cartLegendsofSLAGA)
zone5.Id = "f8b867f6-4499-48e9-84c5-27a856a60679"
zone5.Name = _C0U("\001")
zone5.Description = _C0U("\018\110\059\002\110\110\073\110\091\059\002\105\090\021\039\015\081\053\115\026\115\002\003\126\073\091\001\126")
zone5.Visible = true
zone5.Media = zmedia029e81d04655454f9566dde1af9803a7
zone5.Commands = {}
zone5.DistanceRange = Distance(-1, "feet")
zone5.ShowObjects = "OnEnter"
zone5.ProximityRange = Distance(8, "meters")
zone5.AllowSetPositionTo = false
zone5.Active = false
zone5.Points = {
	ZonePoint(38.555835, -90.4408983333333, 0), 
	ZonePoint(38.555835, -90.4409683333333, 0), 
	ZonePoint(38.555765, -90.4409683333333, 0), 
	ZonePoint(38.555765, -90.4408983333333, 0)
}
zone5.OriginalPoint = ZonePoint(38.5558, -90.4409333333333, 0)
zone5.DistanceRangeUOM = "Feet"
zone5.ProximityRangeUOM = "Meters"
zone5.OutOfRangeName = ""
zone5.InRangeName = ""
zone6 = Wherigo.Zone(cartLegendsofSLAGA)
zone6.Id = "d3034815-546f-426f-9b91-18f97b8d7a70"
zone6.Name = _C0U("\126")
zone6.Description = _C0U("\018\110\059\002\110\110\073\091\003\003\002\105\090\021\039\015\081\053\115\026\115\002\003\126\073\001\110\077")
zone6.Visible = true
zone6.Media = zmedia029e81d04655454f9566dde1af9803a7
zone6.Commands = {}
zone6.DistanceRange = Distance(-1, "feet")
zone6.ShowObjects = "OnEnter"
zone6.ProximityRange = Distance(8, "meters")
zone6.AllowSetPositionTo = false
zone6.Active = false
zone6.Points = {
	ZonePoint(38.5570683333333, -90.4422483333333, 0), 
	ZonePoint(38.5570683333333, -90.4423183333333, 0), 
	ZonePoint(38.5569983333333, -90.4423183333333, 0), 
	ZonePoint(38.5569983333333, -90.4422483333333, 0)
}
zone6.OriginalPoint = ZonePoint(38.5570333333333, -90.4422833333333, 0)
zone6.DistanceRangeUOM = "Feet"
zone6.ProximityRangeUOM = "Meters"
zone6.OutOfRangeName = ""
zone6.InRangeName = ""
zone7 = Wherigo.Zone(cartLegendsofSLAGA)
zone7.Id = "0766485c-5a1c-48e7-893b-9e7e3ccf957b"
zone7.Name = _C0U("\077")
zone7.Description = _C0U("\018\110\059\002\110\110\073\091\077\115\002\105\090\021\039\015\081\053\115\026\115\002\003\126\073\126\110\117")
zone7.Visible = true
zone7.Media = zmedia029e81d04655454f9566dde1af9803a7
zone7.Commands = {}
zone7.DistanceRange = Distance(-1, "feet")
zone7.ShowObjects = "OnEnter"
zone7.ProximityRange = Distance(8, "meters")
zone7.AllowSetPositionTo = false
zone7.Active = false
zone7.Points = {
	ZonePoint(38.5578683333333, -90.443815, 0), 
	ZonePoint(38.5578683333333, -90.443885, 0), 
	ZonePoint(38.5577983333333, -90.443885, 0), 
	ZonePoint(38.5577983333333, -90.443815, 0)
}
zone7.OriginalPoint = ZonePoint(38.5578333333333, -90.44385, 0)
zone7.DistanceRangeUOM = "Feet"
zone7.ProximityRangeUOM = "Meters"
zone7.OutOfRangeName = ""
zone7.InRangeName = ""
zone8 = Wherigo.Zone(cartLegendsofSLAGA)
zone8.Id = "4c6c44c0-a8de-4c34-a026-2a92fba55223"
zone8.Name = _C0U("\059")
zone8.Description = _C0U("\018\110\059\002\110\110\073\110\077\001\002\105\090\021\039\015\081\053\115\026\115\002\003\126\073\077\091\110")
zone8.Visible = true
zone8.Media = zmedia029e81d04655454f9566dde1af9803a7
zone8.Commands = {}
zone8.DistanceRange = Distance(-1, "feet")
zone8.ShowObjects = "OnEnter"
zone8.ProximityRange = Distance(8, "meters")
zone8.AllowSetPositionTo = false
zone8.Active = false
zone8.Points = {
	ZonePoint(38.556285, -90.4456816666667, 0), 
	ZonePoint(38.556285, -90.4457516666667, 0), 
	ZonePoint(38.556215, -90.4457516666667, 0), 
	ZonePoint(38.556215, -90.4456816666667, 0)
}
zone8.OriginalPoint = ZonePoint(38.55625, -90.4457166666667, 0)
zone8.DistanceRangeUOM = "Feet"
zone8.ProximityRangeUOM = "Meters"
zone8.OutOfRangeName = ""
zone8.InRangeName = ""
zone9 = Wherigo.Zone(cartLegendsofSLAGA)
zone9.Id = "034def4f-386a-4c61-b7da-c5fa0f8b92a0"
zone9.Name = _C0U("\026")
zone9.Description = _C0U("\018\110\059\002\110\003\073\077\117\117\002\105\090\021\039\015\081\053\115\026\002\003\059\073\091\059\117")
zone9.Visible = true
zone9.Media = zmedia029e81d04655454f9566dde1af9803a7
zone9.Commands = {}
zone9.DistanceRange = Distance(-1, "feet")
zone9.ShowObjects = "OnEnter"
zone9.ProximityRange = Distance(8, "meters")
zone9.AllowSetPositionTo = false
zone9.Active = false
zone9.Points = {
	ZonePoint(38.5452183333333, -90.4746483333333, 0), 
	ZonePoint(38.5452183333333, -90.4747183333333, 0), 
	ZonePoint(38.5451483333333, -90.4747183333333, 0), 
	ZonePoint(38.5451483333333, -90.4746483333333, 0)
}
zone9.OriginalPoint = ZonePoint(38.5451833333333, -90.4746833333333, 0)
zone9.DistanceRangeUOM = "Feet"
zone9.ProximityRangeUOM = "Meters"
zone9.OutOfRangeName = ""
zone9.InRangeName = ""
zone10 = Wherigo.Zone(cartLegendsofSLAGA)
zone10.Id = "c13e513e-d420-45ef-b867-b86f07e7be04"
zone10.Name = _C0U("\117\115")
zone10.Description = _C0U("\018\110\059\002\110\003\073\059\001\059\002\105\090\021\039\015\081\053\115\026\115\002\003\059\073\110\110\026")
zone10.Visible = true
zone10.Media = zmedia029e81d04655454f9566dde1af9803a7
zone10.Commands = {}
zone10.DistanceRange = Distance(-1, "feet")
zone10.ShowObjects = "OnEnter"
zone10.ProximityRange = Distance(8, "meters")
zone10.AllowSetPositionTo = false
zone10.Active = false
zone10.Points = {
	ZonePoint(38.5476683333333, -90.4722816666667, 0), 
	ZonePoint(38.5476683333333, -90.4723516666667, 0), 
	ZonePoint(38.5475983333333, -90.4723516666667, 0), 
	ZonePoint(38.5475983333333, -90.4722816666667, 0)
}
zone10.OriginalPoint = ZonePoint(38.5476333333333, -90.4723166666667, 0)
zone10.DistanceRangeUOM = "Feet"
zone10.ProximityRangeUOM = "Meters"
zone10.OutOfRangeName = ""
zone10.InRangeName = ""
zone11 = Wherigo.Zone(cartLegendsofSLAGA)
zone11.Id = "44765164-e90f-4a55-9642-170bf0f28086"
zone11.Name = _C0U("\117\117")
zone11.Description = _C0U("\018\110\059\002\110\003\073\026\115\026\002\105\090\021\039\015\081\053\115\026\115\002\003\059\073\003\091\001")
zone11.Visible = true
zone11.Media = zmedia029e81d04655454f9566dde1af9803a7
zone11.Commands = {}
zone11.DistanceRange = Distance(-1, "feet")
zone11.ShowObjects = "OnEnter"
zone11.ProximityRange = Distance(8, "meters")
zone11.AllowSetPositionTo = false
zone11.Active = false
zone11.Points = {
	ZonePoint(38.5485183333333, -90.470715, 0), 
	ZonePoint(38.5485183333333, -90.470785, 0), 
	ZonePoint(38.5484483333333, -90.470785, 0), 
	ZonePoint(38.5484483333333, -90.470715, 0)
}
zone11.OriginalPoint = ZonePoint(38.5484833333333, -90.47075, 0)
zone11.DistanceRangeUOM = "Feet"
zone11.ProximityRangeUOM = "Meters"
zone11.OutOfRangeName = ""
zone11.InRangeName = ""
zone12 = Wherigo.Zone(cartLegendsofSLAGA)
zone12.Id = "45ca4ba1-14fa-4290-bbb9-d1ce785a3c3c"
zone12.Name = _C0U("\117\003")
zone12.Description = _C0U("\018\110\059\002\110\110\073\115\117\115\002\105\090\021\039\015\081\053\115\026\115\002\003\059\073\115\059\077")
zone12.Visible = true
zone12.Media = zmedia029e81d04655454f9566dde1af9803a7
zone12.Commands = {}
zone12.DistanceRange = Distance(-1, "feet")
zone12.ShowObjects = "OnEnter"
zone12.ProximityRange = Distance(8, "meters")
zone12.AllowSetPositionTo = false
zone12.Active = false
zone12.Points = {
	ZonePoint(38.5502016666667, -90.4680816666667, 0), 
	ZonePoint(38.5502016666667, -90.4681516666667, 0), 
	ZonePoint(38.5501316666667, -90.4681516666667, 0), 
	ZonePoint(38.5501316666667, -90.4680816666667, 0)
}
zone12.OriginalPoint = ZonePoint(38.5501666666667, -90.4681166666667, 0)
zone12.DistanceRangeUOM = "Feet"
zone12.ProximityRangeUOM = "Meters"
zone12.OutOfRangeName = ""
zone12.InRangeName = ""
zone13 = Wherigo.Zone(cartLegendsofSLAGA)
zone13.Id = "5520bc8d-fffc-4544-8f85-57bc994c16cb"
zone13.Name = _C0U("\117\110")
zone13.Description = _C0U("\018\110\059\002\110\110\073\115\110\117\002\105\090\021\039\015\081\053\115\026\115\002\003\077\073\026\126\110")
zone13.Visible = true
zone13.Media = zmedia029e81d04655454f9566dde1af9803a7
zone13.Commands = {}
zone13.DistanceRange = Distance(-1, "feet")
zone13.ShowObjects = "OnEnter"
zone13.ProximityRange = Distance(8, "meters")
zone13.AllowSetPositionTo = false
zone13.Active = false
zone13.Points = {
	ZonePoint(38.5505516666667, -90.466015, 0), 
	ZonePoint(38.5505516666667, -90.466085, 0), 
	ZonePoint(38.5504816666667, -90.466085, 0), 
	ZonePoint(38.5504816666667, -90.466015, 0)
}
zone13.OriginalPoint = ZonePoint(38.5505166666667, -90.46605, 0)
zone13.DistanceRangeUOM = "Feet"
zone13.ProximityRangeUOM = "Meters"
zone13.OutOfRangeName = ""
zone13.InRangeName = ""
zone14 = Wherigo.Zone(cartLegendsofSLAGA)
zone14.Id = "bb5a3e8c-7dc0-4a8d-b207-93d965b7bcf4"
zone14.Name = _C0U("\117\091")
zone14.Description = _C0U("\018\110\059\002\110\110\073\115\059\117\002\105\090\021\039\015\081\053\115\026\115\002\003\077\073\059\001\001")
zone14.Visible = true
zone14.Media = zmedia029e81d04655454f9566dde1af9803a7
zone14.Commands = {}
zone14.DistanceRange = Distance(-1, "feet")
zone14.ShowObjects = "OnEnter"
zone14.ProximityRange = Distance(8, "meters")
zone14.AllowSetPositionTo = false
zone14.Active = false
zone14.Points = {
	ZonePoint(38.551385, -90.464215, 0), 
	ZonePoint(38.551385, -90.464285, 0), 
	ZonePoint(38.551315, -90.464285, 0), 
	ZonePoint(38.551315, -90.464215, 0)
}
zone14.OriginalPoint = ZonePoint(38.55135, -90.46425, 0)
zone14.DistanceRangeUOM = "Feet"
zone14.ProximityRangeUOM = "Meters"
zone14.OutOfRangeName = ""
zone14.InRangeName = ""
zone15 = Wherigo.Zone(cartLegendsofSLAGA)
zone15.Id = "960c7836-4e5a-4d64-a966-4352faf324be"
zone15.Name = _C0U("\117\001")
zone15.Description = _C0U("\018\002\110\059\002\110\110\073\117\091\126\002\053\002\026\115\002\003\077\073\126\026\110")
zone15.Visible = true
zone15.Media = zmedia029e81d04655454f9566dde1af9803a7
zone15.Commands = {}
zone15.DistanceRange = Distance(-1, "feet")
zone15.ShowObjects = "OnEnter"
zone15.ProximityRange = Distance(8, "meters")
zone15.AllowSetPositionTo = false
zone15.Active = false
zone15.Points = {
	ZonePoint(38.5524683333333, -90.461515, 0), 
	ZonePoint(38.5524683333333, -90.461585, 0), 
	ZonePoint(38.5523983333333, -90.461585, 0), 
	ZonePoint(38.5523983333333, -90.461515, 0)
}
zone15.OriginalPoint = ZonePoint(38.5524333333333, -90.46155, 0)
zone15.DistanceRangeUOM = "Feet"
zone15.ProximityRangeUOM = "Meters"
zone15.OutOfRangeName = ""
zone15.InRangeName = ""
zone16 = Wherigo.Zone(cartLegendsofSLAGA)
zone16.Id = "e55f8791-9285-464c-9e2a-6f49227ba7c1"
zone16.Name = _C0U("\117\126")
zone16.Description = _C0U("\018\110\059\002\110\110\073\117\077\117\002\105\090\021\039\015\081\053\115\026\115\002\003\077\073\001\026\003")
zone16.Visible = true
zone16.Media = zmedia029e81d04655454f9566dde1af9803a7
zone16.Commands = {}
zone16.DistanceRange = Distance(-1, "feet")
zone16.ShowObjects = "OnEnter"
zone16.ProximityRange = Distance(8, "meters")
zone16.AllowSetPositionTo = false
zone16.Active = false
zone16.Points = {
	ZonePoint(38.552885, -90.4598316666667, 0), 
	ZonePoint(38.552885, -90.4599016666667, 0), 
	ZonePoint(38.552815, -90.4599016666667, 0), 
	ZonePoint(38.552815, -90.4598316666667, 0)
}
zone16.OriginalPoint = ZonePoint(38.55285, -90.4598666666667, 0)
zone16.DistanceRangeUOM = "Feet"
zone16.ProximityRangeUOM = "Meters"
zone16.OutOfRangeName = ""
zone16.InRangeName = ""
zone17 = Wherigo.Zone(cartLegendsofSLAGA)
zone17.Id = "ecb335c5-936c-4765-80ba-162aede494e5"
zone17.Name = _C0U("\117\077")
zone17.Description = _C0U("\018\110\059\002\110\110\073\003\115\026\002\105\090\021\039\015\081\053\115\026\115\002\003\077\073\091\126\126")
zone17.Visible = true
zone17.Media = zmedia029e81d04655454f9566dde1af9803a7
zone17.Commands = {}
zone17.DistanceRange = Distance(-1, "feet")
zone17.ShowObjects = "OnEnter"
zone17.ProximityRange = Distance(8, "meters")
zone17.AllowSetPositionTo = false
zone17.Active = false
zone17.Points = {
	ZonePoint(38.5535183333333, -90.4577316666667, 0), 
	ZonePoint(38.5535183333333, -90.4578016666667, 0), 
	ZonePoint(38.5534483333333, -90.4578016666667, 0), 
	ZonePoint(38.5534483333333, -90.4577316666667, 0)
}
zone17.OriginalPoint = ZonePoint(38.5534833333333, -90.4577666666667, 0)
zone17.DistanceRangeUOM = "Feet"
zone17.ProximityRangeUOM = "Meters"
zone17.OutOfRangeName = ""
zone17.InRangeName = ""
zone18 = Wherigo.Zone(cartLegendsofSLAGA)
zone18.Id = "ee9efdd8-5b73-42e5-93e8-09b09fa20e65"
zone18.Name = _C0U("\117\059")
zone18.Description = _C0U("\018\110\059\002\110\110\073\003\091\059\002\105\090\021\039\015\081\053\115\026\115\002\003\077\073\110\091\001")
zone18.Visible = true
zone18.Media = zmedia029e81d04655454f9566dde1af9803a7
zone18.Commands = {}
zone18.DistanceRange = Distance(-1, "feet")
zone18.ShowObjects = "OnEnter"
zone18.ProximityRange = Distance(8, "meters")
zone18.AllowSetPositionTo = false
zone18.Active = false
zone18.Points = {
	ZonePoint(38.5541683333333, -90.455715, 0), 
	ZonePoint(38.5541683333333, -90.455785, 0), 
	ZonePoint(38.5540983333333, -90.455785, 0), 
	ZonePoint(38.5540983333333, -90.455715, 0)
}
zone18.OriginalPoint = ZonePoint(38.5541333333333, -90.45575, 0)
zone18.DistanceRangeUOM = "Feet"
zone18.ProximityRangeUOM = "Meters"
zone18.OutOfRangeName = ""
zone18.InRangeName = ""
zone19 = Wherigo.Zone(cartLegendsofSLAGA)
zone19.Id = "ca58a5c8-bb37-4fdc-8eee-b12d9f957a2c"
zone19.Name = _C0U("\117\026")
zone19.Description = _C0U("\018\110\059\002\110\110\073\003\026\110\002\105\090\021\039\015\081\053\115\026\115\002\003\077\073\117\026\077")
zone19.Visible = true
zone19.Media = zmedia029e81d04655454f9566dde1af9803a7
zone19.Commands = {}
zone19.DistanceRange = Distance(-1, "feet")
zone19.ShowObjects = "OnEnter"
zone19.ProximityRange = Distance(8, "meters")
zone19.AllowSetPositionTo = false
zone19.Active = false
zone19.Points = {
	ZonePoint(38.5549183333333, -90.4532483333333, 0), 
	ZonePoint(38.5549183333333, -90.4533183333333, 0), 
	ZonePoint(38.5548483333333, -90.4533183333333, 0), 
	ZonePoint(38.5548483333333, -90.4532483333333, 0)
}
zone19.OriginalPoint = ZonePoint(38.5548833333333, -90.4532833333333, 0)
zone19.DistanceRangeUOM = "Feet"
zone19.ProximityRangeUOM = "Meters"
zone19.OutOfRangeName = ""
zone19.InRangeName = ""
zone20 = Wherigo.Zone(cartLegendsofSLAGA)
zone20.Id = "4a14dc50-9fc9-4a9f-b91e-fd911e001d6e"
zone20.Name = _C0U("\003\115")
zone20.Description = _C0U("\018\002\110\059\002\110\110\073\110\110\026\002\053\002\026\115\002\003\077\073\115\059\091")
zone20.Visible = true
zone20.Media = zmedia029e81d04655454f9566dde1af9803a7
zone20.Commands = {}
zone20.DistanceRange = Distance(-1, "feet")
zone20.ShowObjects = "OnEnter"
zone20.ProximityRange = Distance(8, "meters")
zone20.AllowSetPositionTo = false
zone20.Active = false
zone20.Points = {
	ZonePoint(38.55566, -90.45139, 0), 
	ZonePoint(38.55566, -90.45141, 0), 
	ZonePoint(38.55564, -90.45141, 0), 
	ZonePoint(38.55564, -90.45139, 0)
}
zone20.OriginalPoint = ZonePoint(38.55565, -90.4514, 0)
zone20.DistanceRangeUOM = "Feet"
zone20.ProximityRangeUOM = "Meters"
zone20.OutOfRangeName = ""
zone20.InRangeName = ""

-- Characters --

-- Items --
_2ZcL = Wherigo.ZItem{
	Cartridge = cartLegendsofSLAGA, 
	Container = Player
}
_2ZcL.Id = "447fd828-d716-44a1-946e-a8cb7eb53235"
_2ZcL.Name = _C0U("\036\004\095\004\090\100\039\002\045\124\002\047\065\087\095\087\002\117\003\020\003\115")
_2ZcL.Description = _C0U("\054\029\004\039\039\002\004\066\087\034\072\090\004\002\007\045\002\039\004\004\002\007\106\004\002\083\045\045\029\100\072\090\087\007\004\039\002\124\045\029\002\036\004\095\004\090\100\039\002\045\124\002\047\036\048\005\048\002\117\003\020\003\115\073")
_2ZcL.Visible = true
_2ZcL.Media = zmedia029e81d04655454f9566dde1af9803a7
_2ZcL.Icon = _Vjlb
_2ZcL.Commands = {
	_GHG = Wherigo.ZCommand{
		Text = _C0U("\096\066\087\034\072\090\004"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _C0U("\018\045\007\106\072\090\095\002\087\025\087\072\065\087\021\065\004")
	}
}
_2ZcL.Commands._GHG.Custom = true
_2ZcL.Commands._GHG.Id = "9702989b-e85b-4574-9e59-c01796ca3944"
_2ZcL.Commands._GHG.WorksWithAll = true
_2ZcL.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_2ZcL.Locked = false
_2ZcL.Opened = false
_sjYh5 = Wherigo.ZItem{
	Cartridge = cartLegendsofSLAGA, 
	Container = Player
}
_sjYh5.Id = "ee393891-2799-4aed-9a6b-2130aac78e98"
_sjYh5.Name = _C0U("\036\004\095\004\090\100\039\002\045\124\002\047\065\087\095\087\002\117\020\059")
_sjYh5.Description = _C0U("\054\029\004\039\039\002\004\066\087\034\072\090\004\002\007\045\002\039\004\004\002\007\106\004\002\083\045\045\029\100\072\090\087\007\004\039\002\124\045\029\002\036\004\095\004\090\100\039\002\045\124\002\047\036\048\005\048\002\117\020\059\073")
_sjYh5.Visible = true
_sjYh5.Media = zmedia029e81d04655454f9566dde1af9803a7
_sjYh5.Icon = _Vjlb
_sjYh5.Commands = {
	_Aya = Wherigo.ZCommand{
		Text = _C0U("\096\066\087\034\072\090\004"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _C0U("\018\045\007\106\072\090\095\002\087\025\087\072\065\087\021\065\004")
	}
}
_sjYh5.Commands._Aya.Custom = true
_sjYh5.Commands._Aya.Id = "62862d4e-00b0-4e88-8b4f-d80630255239"
_sjYh5.Commands._Aya.WorksWithAll = true
_sjYh5.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_sjYh5.Locked = false
_sjYh5.Opened = false
_F0srk = Wherigo.ZItem(cartLegendsofSLAGA)
_F0srk.Id = "6180e4d9-019d-4ad8-a63a-508f6780eec1"
_F0srk.Name = _C0U("\031\045\034\015\065\004\007\072\045\090\002\031\045\100\004")
_F0srk.Description = ""
_F0srk.Visible = true
_F0srk.Media = zmedia029e81d04655454f9566dde1af9803a7
_F0srk.Icon = _Vjlb
_F0srk.Commands = {}
_F0srk.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_F0srk.Locked = false
_F0srk.Opened = false
_d2zf = Wherigo.ZItem{
	Cartridge = cartLegendsofSLAGA, 
	Container = Player
}
_d2zf.Id = "e4cad4d9-803d-4990-97b7-897b5f6eee03"
_d2zf.Name = _C0U("\018\087\025\072\095\087\007\045\029")
_d2zf.Description = _C0U("\109\039\004\002\007\106\072\039\002\072\007\004\034\002\007\045\002\018\087\025\072\095\087\007\004\002\007\045\002\087\090\067\002\045\124\002\007\106\004\002\098\106\004\029\072\095\045\039\002\117\020\003\115\073")
_d2zf.Visible = true
_d2zf.Media = zmedia029e81d04655454f9566dde1af9803a7
_d2zf.Icon = _Vjlb
_d2zf.Commands = {
	_EBG = Wherigo.ZCommand{
		Text = _C0U("\018\087\025\072\095\087\007\004"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _C0U("\018\045\007\106\072\090\095\002\087\025\087\072\065\087\021\065\004")
	}
}
_d2zf.Commands._EBG.Custom = true
_d2zf.Commands._EBG.Id = "22a23eee-5a11-46dd-843c-037f438a3373"
_d2zf.Commands._EBG.WorksWithAll = true
_d2zf.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_d2zf.Locked = false
_d2zf.Opened = false

-- Tasks --

-- Cartridge Variables --
Answer = ""
_ssPt = _C0U("\060\045\090\004\117")
_enrNn = _C0U("\100\043\034\034\067")
_DveH = _C0U("\014\003\120\083\036")
_xjw = _C0U("\100\043\034\034\067")
_OIH4 = _C0U("\014\021\054\072")
_AYTs = _C0U("\100\043\034\034\067")
cartLegendsofSLAGA.ZVariables = {
	Answer = "", 
	_ssPt = _C0U("\060\045\090\004\117"), 
	_enrNn = _C0U("\100\043\034\034\067"), 
	_DveH = _C0U("\014\003\120\083\036"), 
	_xjw = _C0U("\100\043\034\034\067"), 
	_OIH4 = _C0U("\014\021\054\072"), 
	_AYTs = _C0U("\100\043\034\034\067")
}

-- Timers --

-- Inputs --
_bPi = Wherigo.ZInput(cartLegendsofSLAGA)
_bPi.Id = "0727e8b1-c769-4eee-9f5a-749804976756"
_bPi.Name = _C0U("\018\087\025\072\095\087\007\004")
_bPi.Description = ""
_bPi.Visible = true
_bPi.InputType = "Text"
_bPi.Text = _C0U("\053\106\072\083\106\002\036\112\047\002\098\106\004\029\072\095\045\002\098\045\043\065\100\002\067\045\043\002\065\072\125\004\002\007\045\002\090\087\025\072\095\087\007\004\002\007\045\022\002\096\090\007\004\029\002\087\002\090\043\034\021\004\029\002\021\004\007\098\004\004\090\002\117\002\087\090\100\002\003\115\073")

-- WorksWithList for object commands --

-- functions --
function cartLegendsofSLAGA:OnStart()
	_Urwigo.MessageBox{
		Text = _C0U("\053\004\065\083\045\034\004\002\007\045\002\007\106\004\002\036\004\095\004\090\100\039\002\045\124\002\047\036\048\005\048\002\098\106\004\029\072\095\045\073\002\016\090\002\007\106\072\039\002\083\087\029\007\029\072\100\095\004\002\067\045\043\002\098\072\065\065\002\124\072\090\100\002\007\106\004\002\083\045\045\029\100\072\090\087\007\004\039\002\007\045\002\007\106\004\002\124\072\029\039\007\002\007\098\004\090\007\067\002\036\004\095\004\090\100\039\002\045\124\002\047\036\048\005\048\002\083\087\083\106\004\039\073\002\112\015\004\090\002\067\045\043\029\002\072\007\004\034\039\002\034\004\090\043\002\007\045\002\087\083\083\004\039\039\002\007\106\004\002\083\045\045\029\100\072\090\087\007\004\039\002\124\045\029\002\004\087\083\106\002\045\124\002\007\106\004\002\083\087\083\106\004\039\073"), 
		Media = zmedia029e81d04655454f9566dde1af9803a7, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _C0U("\017\045\043\002\083\087\090\002\087\065\039\045\002\043\039\004\002\007\106\004\002\098\106\004\029\072\095\045\002\090\087\025\072\095\087\007\045\029\002\072\090\002\007\106\004\002\072\007\004\034\039\002\034\004\090\043\002\007\045\002\090\087\025\072\095\087\007\004\002\007\045\002\004\087\083\106\002\045\124\002\007\106\004\002\007\098\004\090\007\067\002\060\045\090\004\039\073\002"), 
					Media = zmedia029e81d04655454f9566dde1af9803a7
				}
			end
		end
	}
end
function cartLegendsofSLAGA:OnRestore()
end
function zone1:OnProximity()
	_ssPt = _C0U("\060\045\090\004\117")
	_Urwigo.GlobalZoneProximity()
	zone1.Active = false
	zone2.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone2:OnProximity()
	_ssPt = _C0U("\060\045\090\004\003")
	_Urwigo.GlobalZoneProximity()
	zone2.Active = false
	zone3.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone3:OnProximity()
	_ssPt = _C0U("\060\045\090\004\110")
	_Urwigo.GlobalZoneProximity()
	zone3.Active = false
	zone4.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone4:OnProximity()
	_ssPt = _C0U("\060\045\090\004\091")
	_Urwigo.GlobalZoneProximity()
	zone4.Active = false
	zone5.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone5:OnProximity()
	_ssPt = _C0U("\060\045\090\004\001")
	_Urwigo.GlobalZoneProximity()
	zone5.Active = false
	zone6.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone6:OnProximity()
	_ssPt = _C0U("\060\045\090\004\126")
	_Urwigo.GlobalZoneProximity()
	zone6.Active = false
	zone7.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone7:OnProximity()
	_ssPt = _C0U("\060\045\090\004\077")
	_Urwigo.GlobalZoneProximity()
	zone7.Active = false
	zone8.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone8:OnProximity()
	_ssPt = _C0U("\060\045\090\004\059")
	_Urwigo.GlobalZoneProximity()
	zone8.Active = false
	cartLegendsofSLAGA:RequestSync()
end
function zone9:OnProximity()
	_ssPt = _C0U("\060\045\090\004\026")
	_Urwigo.GlobalZoneProximity()
	zone9.Active = false
	zone10.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone10:OnProximity()
	_ssPt = _C0U("\060\045\090\004\117\115")
	_Urwigo.GlobalZoneProximity()
	zone10.Active = false
	zone11.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone11:OnProximity()
	_ssPt = _C0U("\060\045\090\004\117\117")
	_Urwigo.GlobalZoneProximity()
	zone11.Active = false
	zone12.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone12:OnProximity()
	_ssPt = _C0U("\060\045\090\004\117\003")
	_Urwigo.GlobalZoneProximity()
	zone12.Active = false
	_Urwigo.MessageBox{
		Text = _C0U("\088\106\004\002\083\087\083\106\004\002\072\039\002\106\072\100\100\004\090\002\072\090\002\007\106\004\002\065\087\029\095\004\002\106\045\065\065\045\098\002\007\029\004\004\073"), 
		Media = zmedia029e81d04655454f9566dde1af9803a7, 
		Callback = function(action)
			if action ~= nil then
				zone13.Active = true
				cartLegendsofSLAGA:RequestSync()
			end
		end
	}
end
function zone13:OnProximity()
	_ssPt = _C0U("\060\045\090\004\117\110")
	_Urwigo.GlobalZoneProximity()
	zone13.Active = false
	zone14.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone14:OnProximity()
	_ssPt = _C0U("\060\045\090\004\117\091")
	_Urwigo.GlobalZoneProximity()
	zone14.Active = false
	zone15.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone15:OnProximity()
	_ssPt = _C0U("\060\045\090\004\117\001")
	_Urwigo.GlobalZoneProximity()
	zone15.Active = false
	zone16.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone16:OnProximity()
	_ssPt = _C0U("\060\045\090\004\117\126")
	_Urwigo.GlobalZoneProximity()
	zone16.Active = false
	zone17.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone17:OnProximity()
	_ssPt = _C0U("\060\045\090\004\117\077")
	_Urwigo.GlobalZoneProximity()
	zone17.Active = false
	zone18.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone18:OnProximity()
	_ssPt = _C0U("\060\045\090\004\117\059")
	_Urwigo.GlobalZoneProximity()
	zone18.Active = false
	zone19.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone19:OnProximity()
	_ssPt = _C0U("\060\045\090\004\117\026")
	_Urwigo.GlobalZoneProximity()
	zone19.Active = false
	zone20.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone20:OnProximity()
	_ssPt = _C0U("\060\045\090\004\003\115")
	_Urwigo.GlobalZoneProximity()
	if true then
		zone20.Active = false
	end
end
function _bPi:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	Answer = tostring(input)
	if input == 1 then
		_M7We()
		zone1.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 2 then
		_M7We()
		zone2.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 3 then
		_M7We()
		zone3.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 4 then
		_M7We()
		zone4.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 5 then
		_M7We()
		zone5.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 6 then
		_M7We()
		zone6.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 7 then
		_M7We()
		zone7.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 8 then
		_M7We()
		zone8.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 9 then
		_M7We()
		zone9.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 10 then
		_M7We()
		zone10.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 11 then
		_M7We()
		zone11.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 12 then
		_M7We()
		zone12.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 13 then
		_M7We()
		zone13.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 14 then
		_M7We()
		zone14.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 15 then
		_M7We()
		zone15.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 16 then
		_M7We()
		zone16.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 17 then
		_M7We()
		zone17.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 18 then
		_M7We()
		zone18.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 19 then
		_M7We()
		zone19.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 20 then
		_M7We()
		zone20.Active = true
		_Urwigo.MessageBox{
			Text = (_C0U("\017\045\043\002\087\029\004\002\090\045\098\002\090\087\025\072\095\087\007\072\090\095\002\007\045\002\098\106\004\029\072\095\045\002\090\043\034\021\004\029\002")..Answer).._C0U("\073"), 
			Callback = function(action)
				if action ~= nil then
					_G[_ssPt].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _C0U("\088\106\087\007\002\072\039\002\090\045\007\002\087\090\002\045\015\007\072\045\090\073\002\054\065\004\087\039\004\002\004\090\007\004\029\002\087\002\090\043\034\021\004\029\002\021\004\007\098\004\004\090\002\117\002\087\090\100\002\003\115\073")
		}
	end
end
function _2ZcL:On_GHG(target)
	_Urwigo.MessageBox{
		Text = _C0U("\026\002\018\002\110\059\002\110\003\073\077\117\117\002\053\002\026\115\002\003\059\073\091\059\117\101\038\027\037\117\115\002\018\002\110\059\002\110\003\073\059\001\059\002\053\002\026\115\002\003\059\073\110\110\026\101\038\027\037\117\117\002\018\002\110\059\002\110\003\073\026\115\026\002\053\002\026\115\002\003\059\073\003\091\001\101\038\027\037\117\003\002\018\002\110\059\002\110\110\073\115\117\115\002\053\002\026\115\002\003\059\073\115\059\077\101\038\027\037\117\110\002\018\002\110\059\002\110\110\073\115\110\117\002\053\002\026\115\002\003\077\073\026\126\110\101\038\027\037\117\091\002\018\002\110\059\002\110\110\073\115\059\117\002\053\002\026\115\002\003\077\073\059\001\001\101\038\027\037\117\001\002\018\002\110\059\002\110\110\073\117\091\126\002\053\002\026\115\002\003\077\073\126\026\110\101\038\027\037\117\126\002\018\002\110\059\002\110\110\073\117\077\117\002\053\002\026\115\002\003\077\073\001\026\003\101\038\027\037\117\077\002\018\002\110\059\002\110\110\073\003\115\026\002\053\002\026\115\002\003\077\073\091\126\126\101\038\027\037\117\059\002\018\002\110\059\002\110\110\073\003\091\059\002\053\002\026\115\002\003\077\073\110\091\001\101\038\027\037\117\026\002\018\002\110\059\002\110\110\073\003\026\110\002\053\002\026\115\002\003\077\073\117\026\077\101\038\027\037\003\115\002\018\002\110\059\002\110\110\073\110\110\026\002\053\002\026\115\002\003\077\073\115\059\091")
	}
end
function _sjYh5:On_Aya(target)
	_Urwigo.MessageBox{
		Text = _C0U("\117\002\018\002\110\059\002\110\117\073\077\003\003\002\053\002\026\115\002\003\126\073\117\110\059\101\038\027\037\003\002\018\002\110\059\002\110\117\073\026\117\077\002\053\002\026\115\002\003\126\073\117\110\077\101\038\027\037\110\002\018\002\110\059\002\110\003\073\115\117\077\002\053\002\026\115\002\003\126\073\117\091\117\101\038\027\037\091\002\018\002\110\059\002\110\003\073\117\115\126\002\053\002\026\115\002\003\126\073\117\110\001\101\038\027\037\001\002\018\002\110\059\002\110\110\073\110\091\059\002\053\002\026\115\002\003\126\073\091\001\126\101\038\027\037\126\002\018\002\110\059\002\110\110\073\091\003\003\002\053\002\026\115\002\003\126\073\001\110\077\101\038\027\037\077\002\018\002\110\059\002\110\110\073\091\077\115\002\053\002\026\115\002\003\126\073\126\110\117\101\038\027\037\059\002\018\002\110\059\002\110\110\073\110\077\001\002\053\002\026\115\002\003\126\073\077\091\110")
	}
end
function _d2zf:On_EBG(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_bPi)
	end)
end
function _Urwigo.GlobalZoneProximity()
	cartLegendsofSLAGA.Complete = true
	_F0srk.Description = string.sub(Player.CompletionCode, 1, 15)
	_F0srk:MoveTo(Player)
end

-- Urwigo functions --
function _M7We()
	zone1.Active = false
	zone2.Active = false
	zone3.Active = false
	zone4.Active = false
	zone5.Active = false
	zone6.Active = false
	zone7.Active = false
	zone8.Active = false
	zone9.Active = false
	zone10.Active = false
	zone11.Active = false
	zone12.Active = false
	zone13.Active = false
	zone14.Active = false
	zone15.Active = false
	zone16.Active = false
	zone17.Active = false
	zone18.Active = false
	zone19.Active = false
	zone20.Active = false
end

-- Begin user functions --
-----------------------------------------------------------------------------------------------
-- URWIGO: Following code is imported from the Wherigo Builder cartridge.
-- It is only neccessary if the cartridge uses Author functions that use message box callbacks.
-- Otherwise it can be removed.
cartLegendsofSLAGA.MsgBoxCBFuncs = {}
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=2#--






cartLegendsofSLAGA.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Callback --
Wherigo.Command("SaveClose")
end
end





cartLegendsofSLAGA.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Callback --
zone13.Active = true
cartLegendsofSLAGA:RequestSync()
end
end

-----------------------------------------------------------------------------------------------
-- URWIGO: Here follow imported Author functions

function gsub_wig (str, obf)
    local result = ""
    if (obf == nil) then
        obf = true
    end
    local rot_palette = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@.-~"
    local plen = string.len(rot_palette)
    local magic = { ["\001"] = "B"; ["\002"] = "R"; ["\003"] = "" }
    str = string.gsub(str, "\038nbsp;", " ")
    
    for i = 1, string.len(str) do
        local c = string.sub(str, i, i)
        local p = string.find(rot_palette, c, 1, true)	-- true -> plain text search
        if (p) then
            local jump = (i-1) % 8 + 9
            if (obf) then
                p = p + jump
                if (p > plen) then
                    p = p - plen
                end
            else
                p = p - jump
                if (p < 1) then
                    p = p + plen
                end
            end
            c = string.sub(rot_palette, p, p)		--(debug) .. "(" .. string.byte(c) .. ")"
        else
            x = magic[c]
            if (x) then
                --c = x					--(debug) .. "(*)"
            else
                --(debug) c = c .. "(=" .. string.byte(c) .. ")"
            end
        end

        if (p) then
            p = p
        else
            p = "null"
        end

        result = result .. c			--(debug) .. "[i=" .. i .. "]"
    end
    return result
end

ucoderes = ""
function ucode_wig(ucodenum)
   if pcall(toucode_wig,ucodenum) then
       return ucoderes
   else
       return "?"
   end
end
function toucode_wig(ucodenum)
    ucoderes = string.char(ucodenum)
end





-- End user functions --
return cartLegendsofSLAGA
