require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _Qfj2(str)
	local res = ""
    local dtable = "\055\033\092\120\030\059\101\053\113\104\077\084\040\067\007\117\002\014\102\093\045\088\047\036\079\098\115\015\017\037\049\003\106\122\041\114\004\073\032\066\083\123\121\126\031\063\096\000\050\080\119\057\090\018\074\021\022\087\081\078\028\118\009\023\010\054\065\103\107\089\111\001\012\005\029\044\100\094\052\097\075\070\060\039\019\008\110\051\046\068\043\016\058\020\069\076\086\082\072\124\027\024\071\025\013\109\011\064\034\026\108\056\062\105\006\125\091\035\042\061\095\038\048\112\116\085\099"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_WIk9 = Wherigo.ZCartridge()

-- Media --
_bU4T6 = Wherigo.ZMedia(_WIk9)
_bU4T6.Id = "c26b09a2-23be-4763-b14a-e6b389b6481f"
_bU4T6.Name = _Qfj2("\041\071\016\087\077\093\039\082\080\111\027\127\010")
_bU4T6.Description = ""
_bU4T6.AltText = ""
_bU4T6.Resources = {
	{
		Type = "fdl", 
		Filename = "Fail.fdl", 
		Directives = {}
	}
}
_CB08 = Wherigo.ZMedia(_WIk9)
_CB08.Id = "b68148ad-10ba-4c8b-af28-6f69a4479788"
_CB08.Name = _Qfj2("\099\007\036\036\039\011\080\039\027\127\010\036\007\114\125")
_CB08.Description = ""
_CB08.AltText = ""
_CB08.Resources = {
	{
		Type = "jpg", 
		Filename = "MA_230x164.jpg", 
		Directives = {}
	}
}
_5bf = Wherigo.ZMedia(_WIk9)
_5bf.Id = "9f46c635-902a-4bc8-83cc-4328897166fb"
_5bf.Name = _Qfj2("\096\007\114\125\007\036")
_5bf.Description = ""
_5bf.AltText = ""
_5bf.Resources = {
	{
		Type = "jpg", 
		Filename = "Leiter.jpg", 
		Directives = {}
	}
}
_aNnq = Wherigo.ZMedia(_WIk9)
_aNnq.Id = "e0323fd2-04c8-447d-8272-afb8d0eabdb7"
_aNnq.Name = _Qfj2("\058\114\111\111\069\071\106\106\007\087\039\040\114\111\077")
_aNnq.Description = ""
_aNnq.AltText = ""
_aNnq.Resources = {
	{
		Type = "jpg", 
		Filename = "Willkommen.jpg", 
		Directives = {}
	}
}
_MDPqF = Wherigo.ZMedia(_WIk9)
_MDPqF.Id = "0866415a-f51e-4f7d-8b14-d7c49778059a"
_MDPqF.Name = _Qfj2("\090\036\007\127\069\114\068\007\036\039\098\016\127\069\027\080\127\069")
_MDPqF.Description = ""
_MDPqF.AltText = ""
_MDPqF.Resources = {
	{
		Type = "jpg", 
		Filename = "Dreckiger_Rucksack.jpg", 
		Directives = {}
	}
}
_FYB = Wherigo.ZMedia(_WIk9)
_FYB.Id = "24b0a184-c018-4f27-8fa2-1cefe76a3ee9"
_FYB.Name = _Qfj2("\098\016\127\069\027\080\127\069")
_FYB.Description = ""
_FYB.AltText = ""
_FYB.Resources = {
	{
		Type = "jpg", 
		Filename = "Rucksack.jpg", 
		Directives = {}
	}
}
_GX0gb = Wherigo.ZMedia(_WIk9)
_GX0gb.Id = "d632cedf-09b6-4b83-9fa3-c5fc1b04bfe7"
_GX0gb.Name = _Qfj2("\040\007\027\007\087")
_GX0gb.Description = ""
_GX0gb.AltText = ""
_GX0gb.Resources = {
	{
		Type = "JPG", 
		Filename = "Besen.JPG", 
		Directives = {}
	}
}
_8Xm = Wherigo.ZMedia(_WIk9)
_8Xm.Id = "941ae6e2-b8e4-421a-8582-e878d07a3264"
_8Xm.Name = _Qfj2("\082\036\080\016\039\041\114\039\027\127\010\036\007\114\125")
_8Xm.Description = ""
_8Xm.AltText = ""
_8Xm.Resources = {
	{
		Type = "jpg", 
		Filename = "Si_1.jpg", 
		Directives = {}
	}
}
_1ZOBx = Wherigo.ZMedia(_WIk9)
_1ZOBx.Id = "050aab2f-06a2-44b5-9b10-d30a2250110b"
_1ZOBx.Name = _Qfj2("\040\111\114\087\077\021\060\071\071\026\027")
_1ZOBx.Description = ""
_1ZOBx.AltText = ""
_1ZOBx.Resources = {
	{
		Type = "jpg", 
		Filename = "noobs.jpg", 
		Directives = {}
	}
}
_iVa = Wherigo.ZMedia(_WIk9)
_iVa.Id = "226f4f38-7c90-4c75-ac98-c9e6de1749a3"
_iVa.Name = _Qfj2("\096\071\068\026\016\127\010")
_iVa.Description = ""
_iVa.AltText = ""
_iVa.Resources = {
	{
		Type = "jpg", 
		Filename = "Logbuch.jpg", 
		Directives = {}
	}
}
_69Rmn = Wherigo.ZMedia(_WIk9)
_69Rmn.Id = "e9a28528-fab7-40be-b9b5-772c88773c90"
_69Rmn.Name = _Qfj2("\011\114\127\036\071\127\080\127\010\007")
_69Rmn.Description = ""
_69Rmn.AltText = ""
_69Rmn.Resources = {
	{
		Type = "jpg", 
		Filename = "Microcache.jpg", 
		Directives = {}
	}
}
_eNnP = Wherigo.ZMedia(_WIk9)
_eNnP.Id = "fef3dea7-494c-4e1b-8d88-3940205b61dd"
_eNnP.Name = _Qfj2("\041\016\077\071\069\016")
_eNnP.Description = ""
_eNnP.AltText = ""
_eNnP.Resources = {
	{
		Type = "jpg", 
		Filename = "Sudoku.jpg", 
		Directives = {}
	}
}
_O_d = Wherigo.ZMedia(_WIk9)
_O_d.Id = "be75af63-9e19-4770-b2d0-75c9c350c8e4"
_O_d.Name = _Qfj2("\082\080\111\027\127\010")
_O_d.Description = ""
_O_d.AltText = ""
_O_d.Resources = {
	{
		Type = "jpg", 
		Filename = "Falsch.jpg", 
		Directives = {}
	}
}
_G76e = Wherigo.ZMedia(_WIk9)
_G76e.Id = "eca2d6de-30b7-4fa0-86d5-9cc77db24286"
_G76e.Name = _Qfj2("\098\114\127\010\125\114\068\121\111\016")
_G76e.Description = ""
_G76e.AltText = ""
_G76e.Resources = {
	{
		Type = "jpg", 
		Filename = "Richtig_lu.jpg", 
		Directives = {}
	}
}
_d2a = Wherigo.ZMedia(_WIk9)
_d2a.Id = "665d6aa3-fd6f-4c17-bb2d-a3d3afe08e5a"
_d2a.Name = _Qfj2("\098\114\127\010\125\114\068\121\106\080")
_d2a.Description = ""
_d2a.AltText = ""
_d2a.Resources = {
	{
		Type = "jpg", 
		Filename = "Richtig_ma.jpg", 
		Directives = {}
	}
}
_jYZo = Wherigo.ZMedia(_WIk9)
_jYZo.Id = "4cdb578b-1c36-4e0f-a4d9-22a24464314a"
_jYZo.Name = _Qfj2("\098\114\127\010\125\114\068\121\027\114")
_jYZo.Description = ""
_jYZo.AltText = ""
_jYZo.Resources = {
	{
		Type = "jpg", 
		Filename = "Richtig_si.jpg", 
		Directives = {}
	}
}
_uhUXQ = Wherigo.ZMedia(_WIk9)
_uhUXQ.Id = "e28e5ed7-6928-45d6-a44a-d24baa432801"
_uhUXQ.Name = _Qfj2("\096\114\087\069\027")
_uhUXQ.Description = ""
_uhUXQ.AltText = ""
_uhUXQ.Resources = {
	{
		Type = "jpg", 
		Filename = "Links_neu.jpg", 
		Directives = {}
	}
}
_JgW = Wherigo.ZMedia(_WIk9)
_JgW.Id = "be28d0cd-308c-492c-bc93-aa0f268786b2"
_JgW.Name = _Qfj2("\099\007\036\036\039\011\080\039\051\080\036\039\077\080")
_JgW.Description = ""
_JgW.AltText = ""
_JgW.Resources = {
	{
		Type = "jpg", 
		Filename = "HerrMawarda.jpg", 
		Directives = {}
	}
}
_DhtJH = Wherigo.ZMedia(_WIk9)
_DhtJH.Id = "376a3712-bb48-455f-ab67-28e1ace35db7"
_DhtJH.Name = _Qfj2("\082\012\082")
_DhtJH.Description = ""
_DhtJH.AltText = ""
_DhtJH.Resources = {
	{
		Type = "jpg", 
		Filename = "FTF.jpg", 
		Directives = {}
	}
}
_l1Lb3 = Wherigo.ZMedia(_WIk9)
_l1Lb3.Id = "39059ec1-9e69-447c-b50e-dc3701175b04"
_l1Lb3.Name = _Qfj2("\096\114\087\069\027\039\049")
_l1Lb3.Description = ""
_l1Lb3.AltText = ""
_l1Lb3.Resources = {
	{
		Type = "jpg", 
		Filename = "Links_2.jpg", 
		Directives = {}
	}
}
_nRS = Wherigo.ZMedia(_WIk9)
_nRS.Id = "01a4ac06-73a9-476e-a94b-75547216cebb"
_nRS.Name = _Qfj2("\090\036\007\010\016\087\068\039\088\066\123")
_nRS.Description = ""
_nRS.AltText = ""
_nRS.Resources = {
	{
		Type = "jpg", 
		Filename = "360.jpg", 
		Directives = {}
	}
}
_d8jdz = Wherigo.ZMedia(_WIk9)
_d8jdz.Id = "f1c6f7c9-a58d-43c6-babb-4e4cec6e08e2"
_d8jdz.Name = _Qfj2("\058\080\027\027\007\036\019\111\080\027\127\010\007")
_d8jdz.Description = ""
_d8jdz.AltText = ""
_d8jdz.Resources = {
	{
		Type = "jpg", 
		Filename = "Wasser.jpg", 
		Directives = {}
	}
}
_2U5Iq = Wherigo.ZMedia(_WIk9)
_2U5Iq.Id = "6b10cc8d-38be-4838-aebb-be6570b4e983"
_2U5Iq.Name = _Qfj2("\082\071\125\071\080\124\124\080\036\080\125")
_2U5Iq.Description = ""
_2U5Iq.AltText = ""
_2U5Iq.Resources = {
	{
		Type = "jpg", 
		Filename = "Ma_Cam.jpg", 
		Directives = {}
	}
}
_ud2Ak = Wherigo.ZMedia(_WIk9)
_ud2Ak.Id = "66a84dfa-cc82-4754-89ba-64daeabd45e1"
_ud2Ak.Name = _Qfj2("\040\007\036\068\106\080\087\087")
_ud2Ak.Description = ""
_ud2Ak.AltText = ""
_ud2Ak.Resources = {
	{
		Type = "jpg", 
		Filename = "Foto.jpg", 
		Directives = {}
	}
}
_LlU = Wherigo.ZMedia(_WIk9)
_LlU.Id = "366d8c5d-3096-4e22-97e2-156b10436b64"
_LlU.Name = _Qfj2("\041\127\010\114\111\077")
_LlU.Description = ""
_LlU.AltText = ""
_LlU.Resources = {
	{
		Type = "jpg", 
		Filename = "Schild.jpg", 
		Directives = {}
	}
}
_EY9 = Wherigo.ZMedia(_WIk9)
_EY9.Id = "76d57768-44e2-410f-8ad8-333d6a66529e"
_EY9.Name = _Qfj2("\099\080\111\125")
_EY9.Description = ""
_EY9.AltText = ""
_EY9.Resources = {
	{
		Type = "jpg", 
		Filename = "HALT.jpg", 
		Directives = {}
	}
}
_ombe5 = Wherigo.ZMedia(_WIk9)
_ombe5.Id = "20737ac7-3059-4f3f-9104-3a57625cbc47"
_ombe5.Name = _Qfj2("\126\106\051\007\068")
_ombe5.Description = ""
_ombe5.AltText = ""
_ombe5.Resources = {
	{
		Type = "jpg", 
		Filename = "Karte.jpg", 
		Directives = {}
	}
}
_e98 = Wherigo.ZMedia(_WIk9)
_e98.Id = "761f0f60-3998-4aaa-b57e-86f2b7ea67a8"
_e98.Name = _Qfj2("\077\007\036\121\060\080\127\010\125\007\004\124\036\007\027\027")
_e98.Description = ""
_e98.AltText = ""
_e98.Resources = {
	{
		Type = "jpg", 
		Filename = "der_nachtexpress.jpg", 
		Directives = {}
	}
}
_8SEU = Wherigo.ZMedia(_WIk9)
_8SEU.Id = "9e89e7a5-8ec5-47e2-bb5d-be3814f66781"
_8SEU.Name = _Qfj2("\103\007\027\127\010\080\019\019\125")
_8SEU.Description = ""
_8SEU.AltText = ""
_8SEU.Resources = {
	{
		Type = "jpg", 
		Filename = "Geschafft.jpg", 
		Directives = {}
	}
}
_KP_ = Wherigo.ZMedia(_WIk9)
_KP_.Id = "205d593b-d74e-4884-8dac-b468e93bdff5"
_KP_.Name = _Qfj2("\103\016\125\039\068\007\106\080\127\010\125")
_KP_.Description = ""
_KP_.AltText = ""
_KP_.Resources = {
	{
		Type = "jpg", 
		Filename = "gut.jpg", 
		Directives = {}
	}
}
_uFIl = Wherigo.ZMedia(_WIk9)
_uFIl.Id = "548420e1-eb37-451b-8c59-838dc8a506f7"
_uFIl.Name = _Qfj2("\067\026\026\114\007\068\016\087\068\039\081\114\087\077\007\036\051\080\068\007\087")
_uFIl.Description = ""
_uFIl.AltText = ""
_uFIl.Resources = {
	{
		Type = "jpg", 
		Filename = "Abbiegung.jpg", 
		Directives = {}
	}
}
_flfH = Wherigo.ZMedia(_WIk9)
_flfH.Id = "78641899-8274-411c-aebb-2a9421b911b9"
_flfH.Name = _Qfj2("\041\071\016\087\077\093\039\098\114\127\010\125\114\068")
_flfH.Description = ""
_flfH.AltText = ""
_flfH.Resources = {
	{
		Type = "fdl", 
		Filename = "Indiana_Jones.fdl", 
		Directives = {}
	}
}
_WCwgB = Wherigo.ZMedia(_WIk9)
_WCwgB.Id = "ccaed45e-09c6-431c-a4e7-e991817ff47c"
_WCwgB.Name = _Qfj2("\041\071\016\087\077\093\039\067\127\010\125\016\087\068")
_WCwgB.Description = ""
_WCwgB.AltText = ""
_WCwgB.Resources = {
	{
		Type = "fdl", 
		Filename = "Achtung.fdl", 
		Directives = {}
	}
}
_OS1O = Wherigo.ZMedia(_WIk9)
_OS1O.Id = "762bc430-e71c-49a9-a9ea-161f34ac6d94"
_OS1O.Name = _Qfj2("\011\007\125\080\111\111\027\124\111\114\087\125")
_OS1O.Description = ""
_OS1O.AltText = ""
_OS1O.Resources = {
	{
		Type = "jpg", 
		Filename = "Splint.jpg", 
		Directives = {}
	}
}
_Ywh = Wherigo.ZMedia(_WIk9)
_Ywh.Id = "b99c1e9e-9aa9-4454-acc5-9654b6b42b1f"
_Ywh.Name = _Qfj2("\103\036\007\087\034\027\125\007\114\087")
_Ywh.Description = ""
_Ywh.AltText = ""
_Ywh.Resources = {
	{
		Type = "jpg", 
		Filename = "Grenzstein.jpg", 
		Directives = {}
	}
}
_DCI = Wherigo.ZMedia(_WIk9)
_DCI.Id = "829efa41-0184-4b98-a221-c540662aefa4"
_DCI.Name = _Qfj2("\082\114\087\080\111\007\039\040\080\016\106")
_DCI.Description = ""
_DCI.AltText = ""
_DCI.Resources = {
	{
		Type = "jpg", 
		Filename = "FInale.jpg", 
		Directives = {}
	}
}
_5kNEu = Wherigo.ZMedia(_WIk9)
_5kNEu.Id = "03a5244f-51c6-431c-a083-7d134bb50cde"
_5kNEu.Name = _Qfj2("\082\114\087\080\111\007\039\040\080\016\106\051\016\036\034\007\111")
_5kNEu.Description = ""
_5kNEu.AltText = ""
_5kNEu.Resources = {
	{
		Type = "jpg", 
		Filename = "P1230522.jpg", 
		Directives = {}
	}
}
_DRbK = Wherigo.ZMedia(_WIk9)
_DRbK.Id = "e2b56917-6f0f-497a-ae8e-342c08bbf2fc"
_DRbK.Name = _Qfj2("\041\125\016\106\124\019")
_DRbK.Description = ""
_DRbK.AltText = ""
_DRbK.Resources = {
	{
		Type = "jpg", 
		Filename = "Stumpf.jpg", 
		Directives = {}
	}
}
_S9H_k = Wherigo.ZMedia(_WIk9)
_S9H_k.Id = "d9a0be1d-4e07-4231-96b4-87bc436c9e49"
_S9H_k.Name = _Qfj2("\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_S9H_k.Description = ""
_S9H_k.AltText = ""
_S9H_k.Resources = {
	{
		Type = "jpg", 
		Filename = "Aufgabenzettel_1.jpg", 
		Directives = {}
	}
}
_KMc = Wherigo.ZMedia(_WIk9)
_KMc.Id = "f781c728-1ebf-473d-b6d0-8d56c22d118c"
_KMc.Name = _Qfj2("\067\016\019\068\080\026\007\087\034\007\125\125\007\111\121\022")
_KMc.Description = ""
_KMc.AltText = ""
_KMc.Resources = {
	{
		Type = "jpg", 
		Filename = "Aufgabenzettel_0.jpg", 
		Directives = {}
	}
}
_N31 = Wherigo.ZMedia(_WIk9)
_N31.Id = "39f057a7-112d-45c3-970c-36fa5d4c0e71"
_N31.Name = _Qfj2("\103\007\071\127\080\127\010\114\087\068")
_N31.Description = ""
_N31.AltText = ""
_N31.Resources = {
	{
		Type = "jpg", 
		Filename = "Logo_Geocaching_Color_64.jpg", 
		Directives = {}
	}
}
_pGjA = Wherigo.ZMedia(_WIk9)
_pGjA.Id = "0a99700e-9bfc-42ea-8e5d-a563d6ae361c"
_pGjA.Name = _Qfj2("\082\012\082\121\031")
_pGjA.Description = ""
_pGjA.AltText = ""
_pGjA.Resources = {
	{
		Type = "jpg", 
		Filename = "FTF_.jpg", 
		Directives = {}
	}
}
_0OOoO = Wherigo.ZMedia(_WIk9)
_0OOoO.Id = "c8c5ab3e-0171-41fa-bdae-77e7ed76e70d"
_0OOoO.Name = _Qfj2("\012\114\007\036\007")
_0OOoO.Description = ""
_0OOoO.AltText = ""
_0OOoO.Resources = {
	{
		Type = "jpg", 
		Filename = "Tire_.jpg", 
		Directives = {}
	}
}
_j0bC0 = Wherigo.ZMedia(_WIk9)
_j0bC0.Id = "e3b9f7a9-21ce-4982-abc2-21f657aeb9b0"
_j0bC0.Name = _Qfj2("\011\043\027\125\007\036\043\014\080\127\010\007")
_j0bC0.Description = ""
_j0bC0.AltText = ""
_j0bC0.Resources = {
	{
		Type = "jpg", 
		Filename = "Mystery.jpg", 
		Directives = {}
	}
}
_Ni18q = Wherigo.ZMedia(_WIk9)
_Ni18q.Id = "3d3aa257-564a-4fad-babe-e6e2dba4126c"
_Ni18q.Name = _Qfj2("\014\080\127\010\007\106\071\026\114\111")
_Ni18q.Description = ""
_Ni18q.AltText = ""
_Ni18q.Resources = {
	{
		Type = "jpg", 
		Filename = "Cachemobil.jpg", 
		Directives = {}
	}
}
_x9c = Wherigo.ZMedia(_WIk9)
_x9c.Id = "96d2058c-2462-4f6a-b55b-73b0f6087003"
_x9c.Name = _Qfj2("\058\114\125\034")
_x9c.Description = ""
_x9c.AltText = ""
_x9c.Resources = {
	{
		Type = "jpg", 
		Filename = "Witz.jpg", 
		Directives = {}
	}
}
_1FNrt = Wherigo.ZMedia(_WIk9)
_1FNrt.Id = "8b145184-d476-4ef5-8b5f-f732e6eed2d3"
_1FNrt.Name = _Qfj2("\095\127\071\050\019\080\077")
_1FNrt.Description = ""
_1FNrt.AltText = ""
_1FNrt.Resources = {
	{
		Type = "jpg", 
		Filename = "EcoPfad.jpg", 
		Directives = {}
	}
}
_ifhtq = Wherigo.ZMedia(_WIk9)
_ifhtq.Id = "5f83884e-9102-4b9d-afda-3f086f465dfd"
_ifhtq.Name = _Qfj2("\103\007\036\080\077\007\080\016\027")
_ifhtq.Description = ""
_ifhtq.AltText = ""
_ifhtq.Resources = {
	{
		Type = "jpg", 
		Filename = "Gerade.jpg", 
		Directives = {}
	}
}
_Mwd = Wherigo.ZMedia(_WIk9)
_Mwd.Id = "9a56e276-263a-4c95-96eb-87f4b9b1d028"
_Mwd.Name = _Qfj2("\058\038\103\039\014\071\114\087")
_Mwd.Description = ""
_Mwd.AltText = ""
_Mwd.Resources = {
	{
		Type = "jpg", 
		Filename = "WIG-Coin.jpg", 
		Directives = {}
	}
}
_5mamI = Wherigo.ZMedia(_WIk9)
_5mamI.Id = "a7dfade0-d65f-471d-8089-5c4cc2a14741"
_5mamI.Name = _Qfj2("\008\069\039\014\071\114\087")
_5mamI.Description = ""
_5mamI.AltText = ""
_5mamI.Resources = {
	{
		Type = "jpg", 
		Filename = "M5kCoin.jpg", 
		Directives = {}
	}
}
_dAa = Wherigo.ZMedia(_WIk9)
_dAa.Id = "8bbb746c-a109-4f28-a572-92d919b086b4"
_dAa.Name = _Qfj2("\041\124\071\114\111\007\036\039\040\071\087\016\027\039\040\071\087\016\027")
_dAa.Description = ""
_dAa.AltText = ""
_dAa.Resources = {
	{
		Type = "jpg", 
		Filename = "IMAG0215.jpg", 
		Directives = {}
	}
}
__z0qX = Wherigo.ZMedia(_WIk9)
__z0qX.Id = "f040ee9a-fc10-431d-9210-354e6f568100"
__z0qX.Name = _Qfj2("\123\123\039\041\080\062\007\039\040\016\125\125\071\087\039\025\081")
__z0qX.Description = ""
__z0qX.AltText = ""
__z0qX.Resources = {
	{
		Type = "jpg", 
		Filename = "Diskette_2.jpg", 
		Directives = {}
	}
}
_6fYi = Wherigo.ZMedia(_WIk9)
_6fYi.Id = "f7ea633d-5540-4983-8d9f-f545696b0210"
_6fYi.Name = _Qfj2("\123\123\039\041\080\062\007\039\040\016\125\125\071\087")
_6fYi.Description = ""
_6fYi.AltText = ""
_6fYi.Resources = {
	{
		Type = "jpg", 
		Filename = "Diskette_1.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_WIk9.Id="8790cfbb-8e76-40f6-9b06-1c1603a1465f"
_WIk9.Name="Ein ganz normaler Cacher-Alltag - MaSiLu 5k"
_WIk9.Description=[[]]
_WIk9.Visible=true
_WIk9.Activity="Geocache"
_WIk9.StartingLocationDescription=[[Willkommen bei dem MaSiLu Jubilaeums Cache]]
_WIk9.StartingLocation = ZonePoint(51.311487236931,9.61428165435791,0)
_WIk9.Version="1.4"
_WIk9.Company=""
_WIk9.Author="Team Tante Tilly"
_WIk9.BuilderVersion="URWIGO 1.14.4469.18959"
_WIk9.CreateDate="12/05/2011 18:13:08"
_WIk9.PublishDate="1/1/0001 12:00:00 AM"
_WIk9.UpdateDate="04/15/2012 09:45:47"
_WIk9.LastPlayedDate="1/1/0001 12:00:00 AM"
_WIk9.TargetDevice="PocketPC"
_WIk9.TargetDeviceVersion="0"
_WIk9.StateId="1"
_WIk9.CountryId="2"
_WIk9.Complete=false
_WIk9.UseLogging=true


-- Zones --
_xEx1 = Wherigo.Zone(_WIk9)
_xEx1.Id = "2ca2683a-9506-4b6d-97dc-c176bdd14ab0"
_xEx1.Name = _Qfj2("\041\125\080\036\125\039\053\071\087\007")
_xEx1.Description = ""
_xEx1.Visible = true
_xEx1.Commands = {}
_xEx1.DistanceRange = Distance(-1, "feet")
_xEx1.ShowObjects = "OnEnter"
_xEx1.ProximityRange = Distance(0, "meters")
_xEx1.AllowSetPositionTo = false
_xEx1.Active = false
_xEx1.Points = {
	ZonePoint(51.3117756132498, 9.61509972810745, 0), 
	ZonePoint(51.3116381317424, 9.61431920528412, 0), 
	ZonePoint(51.3114201724109, 9.61422801017761, 0), 
	ZonePoint(51.3113966998058, 9.61459815502167, 0), 
	ZonePoint(51.3116062762125, 9.61522310972214, 0)
}
_xEx1.OriginalPoint = ZonePoint(51.3115673786843, 9.6146936416626, 0)
_xEx1.DistanceRangeUOM = "Feet"
_xEx1.ProximityRangeUOM = "Meters"
_xEx1.OutOfRangeName = ""
_xEx1.InRangeName = ""
_vPIJG = Wherigo.Zone(_WIk9)
_vPIJG.Id = "c87d1e21-0fea-4049-813c-5704e13e17c1"
_vPIJG.Name = _Qfj2("\011\114\027\125\076\039\007\125\051\080\027\039\062\007\036\068\007\027\027\007\087")
_vPIJG.Description = ""
_vPIJG.Visible = false
_vPIJG.Commands = {}
_vPIJG.DistanceRange = Distance(-1, "feet")
_vPIJG.ShowObjects = "OnEnter"
_vPIJG.ProximityRange = Distance(0, "meters")
_vPIJG.AllowSetPositionTo = false
_vPIJG.Active = false
_vPIJG.Points = {
	ZonePoint(51.3119700985811, 9.61557984352112, 0), 
	ZonePoint(51.3116113060345, 9.61570054292679, 0), 
	ZonePoint(51.3118510602435, 9.61663663387299, 0), 
	ZonePoint(51.3121813489552, 9.61647838354111, 0)
}
_vPIJG.OriginalPoint = ZonePoint(51.3119034534536, 9.6160988509655, 0)
_vPIJG.DistanceRangeUOM = "Feet"
_vPIJG.ProximityRangeUOM = "Meters"
_vPIJG.OutOfRangeName = ""
_vPIJG.InRangeName = ""
_4Hwl = Wherigo.Zone(_WIk9)
_4Hwl.Id = "4628df55-1d26-42fb-a7cf-907dee7ec4f1"
_4Hwl.Name = _Qfj2("\011\080\041\114\096\016\027\039\007\036\027\125\007\036\039\014\080\127\010\007\039\021\039\011\016\111\125\114\039\014\080\127\010\007")
_4Hwl.Description = ""
_4Hwl.Visible = true
_4Hwl.Commands = {}
_4Hwl.DistanceRange = Distance(-1, "feet")
_4Hwl.ShowObjects = "OnEnter"
_4Hwl.ProximityRange = Distance(10, "meters")
_4Hwl.AllowSetPositionTo = false
_4Hwl.Active = false
_4Hwl.Points = {
	ZonePoint(51.3162217442942, 9.62075650691986, 0), 
	ZonePoint(51.3161144520877, 9.62121248245239, 0), 
	ZonePoint(51.3164497394, 9.62130904197693, 0), 
	ZonePoint(51.3164899737128, 9.62084233760834, 0)
}
_4Hwl.OriginalPoint = ZonePoint(51.3163189773737, 9.62103009223938, 0)
_4Hwl.DistanceRangeUOM = "Feet"
_4Hwl.ProximityRangeUOM = "Meters"
_4Hwl.OutOfRangeName = ""
_4Hwl.InRangeName = ""
_2vQBm = Wherigo.Zone(_WIk9)
_2vQBm.Id = "39e8241c-f286-4db7-8879-6c4e9d76d71f"
_2vQBm.Name = _Qfj2("\014\080\127\010\007\021\025\021\011\071\026\114\111")
_2vQBm.Description = ""
_2vQBm.Visible = true
_2vQBm.Commands = {}
_2vQBm.DistanceRange = Distance(-1, "feet")
_2vQBm.ShowObjects = "OnEnter"
_2vQBm.ProximityRange = Distance(0, "meters")
_2vQBm.AllowSetPositionTo = false
_2vQBm.Active = false
_2vQBm.Points = {
	ZonePoint(51.311631425317, 9.61431920528412, 0), 
	ZonePoint(51.311420172411, 9.6142253279686, 0), 
	ZonePoint(51.3113933465755, 9.61459279060364, 0), 
	ZonePoint(51.3116012463899, 9.61521774530411, 0), 
	ZonePoint(51.311770583446, 9.61509436368942, 0)
}
_2vQBm.OriginalPoint = ZonePoint(51.3115633548279, 9.61468988656998, 0)
_2vQBm.DistanceRangeUOM = "Feet"
_2vQBm.ProximityRangeUOM = "Meters"
_2vQBm.OutOfRangeName = ""
_2vQBm.InRangeName = ""
_JXU = Wherigo.Zone(_WIk9)
_JXU.Id = "1547bd83-9acf-41db-829f-597ab6118afc"
_JXU.Name = _Qfj2("\082\114\087\080\111\007\039\011\016\111\125\114\039\014\080\127\010\007")
_JXU.Description = ""
_JXU.Visible = true
_JXU.Commands = {}
_JXU.DistanceRange = Distance(-1, "feet")
_JXU.ShowObjects = "OnEnter"
_JXU.ProximityRange = Distance(10, "meters")
_JXU.AllowSetPositionTo = false
_JXU.Active = false
_JXU.Points = {
	ZonePoint(51.3194764347043, 9.6222048997879, 0), 
	ZonePoint(51.3191746961427, 9.62206542491913, 0), 
	ZonePoint(51.319121053524, 9.62249457836151, 0), 
	ZonePoint(51.319395971282, 9.62260186672211, 0)
}
_JXU.OriginalPoint = ZonePoint(51.3192920389132, 9.62234169244766, 0)
_JXU.DistanceRangeUOM = "Feet"
_JXU.ProximityRangeUOM = "Meters"
_JXU.OutOfRangeName = ""
_JXU.InRangeName = ""
_2HX = Wherigo.Zone(_WIk9)
_2HX.Id = "6f9d236f-349a-4d15-837b-1eddeeafe721"
_2HX.Name = _Qfj2("\090\080\039\068\007\010\125\039\007\027\039\111\080\087\068\039\089\089\089")
_2HX.Description = ""
_2HX.Visible = false
_2HX.Commands = {}
_2HX.DistanceRange = Distance(-1, "feet")
_2HX.ShowObjects = "OnEnter"
_2HX.ProximityRange = Distance(0, "meters")
_2HX.AllowSetPositionTo = false
_2HX.Active = false
_2HX.Points = {
	ZonePoint(51.3234390836033, 9.62378472089767, 0), 
	ZonePoint(51.3232044185013, 9.62391078472137, 0), 
	ZonePoint(51.3230083046023, 9.6241682767868, 0), 
	ZonePoint(51.3235983199531, 9.6244016289711, 0), 
	ZonePoint(51.3236427384151, 9.62397247552872, 0)
}
_2HX.OriginalPoint = ZonePoint(51.323378573015, 9.62404757738113, 0)
_2HX.DistanceRangeUOM = "Feet"
_2HX.ProximityRangeUOM = "Meters"
_2HX.OutOfRangeName = ""
_2HX.InRangeName = ""
_HI6 = Wherigo.Zone(_WIk9)
_HI6.Id = "393d8b82-cbff-4a7d-9973-d62b4709bcbc"
_HI6.Name = _Qfj2("\082\012\082\039\021\039\041\125\080\036\125\034\071\087\007")
_HI6.Description = ""
_HI6.Visible = true
_HI6.Commands = {}
_HI6.DistanceRange = Distance(-1, "feet")
_HI6.ShowObjects = "OnProximity"
_HI6.ProximityRange = Distance(0, "meters")
_HI6.AllowSetPositionTo = false
_HI6.Active = false
_HI6.Points = {
	ZonePoint(51.323650281169, 9.62310075759888, 0), 
	ZonePoint(51.3235547395339, 9.62364792823792, 0), 
	ZonePoint(51.3236787760042, 9.62381154298782, 0), 
	ZonePoint(51.3237994598156, 9.62318122386932, 0)
}
_HI6.OriginalPoint = ZonePoint(51.3236708141307, 9.62343536317348, 0)
_HI6.DistanceRangeUOM = "Feet"
_HI6.ProximityRangeUOM = "Meters"
_HI6.OutOfRangeName = ""
_HI6.InRangeName = ""
_HSO = Wherigo.Zone(_WIk9)
_HSO.Id = "dbe71971-8552-4f6a-b800-60498df35a13"
_HSO.Name = _Qfj2("\082\012\082\039\053\114\007\111\034\071\087\007")
_HSO.Description = ""
_HSO.Visible = true
_HSO.Commands = {}
_HSO.DistanceRange = Distance(-1, "feet")
_HSO.ShowObjects = "OnEnter"
_HSO.ProximityRange = Distance(0, "meters")
_HSO.AllowSetPositionTo = false
_HSO.Active = false
_HSO.Points = {
	ZonePoint(51.3238002978965, 9.62169662117958, 0), 
	ZonePoint(51.3239528283676, 9.62170466780663, 0), 
	ZonePoint(51.3239461237422, 9.6208356320858, 0), 
	ZonePoint(51.3237902409246, 9.62084367871284, 0)
}
_HSO.OriginalPoint = ZonePoint(51.3238723727327, 9.62127014994621, 0)
_HSO.DistanceRangeUOM = "Feet"
_HSO.ProximityRangeUOM = "Meters"
_HSO.OutOfRangeName = ""
_HSO.InRangeName = ""
_MZz4 = Wherigo.Zone(_WIk9)
_MZz4.Id = "978e0d3e-2417-4f8b-a9ec-ad59f99594c1"
_MZz4.Name = _Qfj2("\058\071\039\068\007\010\125\027\039\077\007\087\087\039\111\080\087\068\046")
_MZz4.Description = ""
_MZz4.Visible = true
_MZz4.Commands = {}
_MZz4.DistanceRange = Distance(-1, "feet")
_MZz4.ShowObjects = "OnEnter"
_MZz4.ProximityRange = Distance(60, "meters")
_MZz4.AllowSetPositionTo = false
_MZz4.Active = false
_MZz4.Points = {
	ZonePoint(51.3239871895578, 9.61549133062363, 0), 
	ZonePoint(51.3238329830403, 9.61549401283264, 0), 
	ZonePoint(51.3238346592008, 9.61573541164398, 0), 
	ZonePoint(51.3239888657127, 9.61572736501694, 0)
}
_MZz4.OriginalPoint = ZonePoint(51.3239109243779, 9.6156120300293, 0)
_MZz4.DistanceRangeUOM = "Feet"
_MZz4.ProximityRangeUOM = "Meters"
_MZz4.OutOfRangeName = ""
_MZz4.InRangeName = ""
_nGGC = Wherigo.Zone(_WIk9)
_nGGC.Id = "a5b644fb-261e-4dc2-947c-68e5805ab33b"
_nGGC.Name = _Qfj2("\099\114\007\036\039\068\007\010\125\027\039\111\080\087\068\039\089\089\089\039")
_nGGC.Description = ""
_nGGC.Visible = true
_nGGC.Commands = {}
_nGGC.DistanceRange = Distance(-1, "feet")
_nGGC.ShowObjects = "OnEnter"
_nGGC.ProximityRange = Distance(10, "meters")
_nGGC.AllowSetPositionTo = false
_nGGC.Active = false
_nGGC.Points = {
	ZonePoint(51.3124998992676, 9.61877971887589, 0), 
	ZonePoint(51.3120975195582, 9.61877971887589, 0), 
	ZonePoint(51.3121243449819, 9.61920887231827, 0), 
	ZonePoint(51.3125267244561, 9.61929470300674, 0)
}
_nGGC.OriginalPoint = ZonePoint(51.3123121220659, 9.6190157532692, 0)
_nGGC.DistanceRangeUOM = "Feet"
_nGGC.ProximityRangeUOM = "Meters"
_nGGC.OutOfRangeName = ""
_nGGC.InRangeName = ""
_LHeUh = Wherigo.Zone(_WIk9)
_LHeUh.Id = "b5f29ed9-d29d-40ac-b593-4a24f5e9fdc0"
_LHeUh.Name = _Qfj2("\103\007\077\016\111\077\027\124\114\007\111\039")
_LHeUh.Description = _Qfj2("\095\114\087\007\039\069\087\114\019\019\007\111\114\068\007\039\067\016\019\068\080\026\007\039\019\016\036\039\069\111\007\114\087\007\039\082\114\087\068\007\036")
_LHeUh.Visible = true
_LHeUh.Commands = {}
_LHeUh.DistanceRange = Distance(-1, "feet")
_LHeUh.ShowObjects = "OnEnter"
_LHeUh.ProximityRange = Distance(60, "meters")
_LHeUh.AllowSetPositionTo = false
_LHeUh.Active = false
_LHeUh.Points = {
	ZonePoint(51.323599996123, 9.61371570825577, 0), 
	ZonePoint(51.3234876926537, 9.61394101381302, 0), 
	ZonePoint(51.3235899391071, 9.61406171321869, 0), 
	ZonePoint(51.3236888330008, 9.61383104324341, 0)
}
_LHeUh.OriginalPoint = ZonePoint(51.3235916152212, 9.61388736963272, 0)
_LHeUh.DistanceRangeUOM = "Feet"
_LHeUh.ProximityRangeUOM = "Meters"
_LHeUh.OutOfRangeName = ""
_LHeUh.InRangeName = ""
_zg7Kf = Wherigo.Zone(_WIk9)
_zg7Kf.Id = "66c506fd-f189-4232-844c-e4f33f82bbfd"
_zg7Kf.Name = _Qfj2("\077\007\036\121\060\080\127\010\125\007\004\124\036\007\027\027")
_zg7Kf.Description = ""
_zg7Kf.Visible = true
_zg7Kf.Commands = {}
_zg7Kf.DistanceRange = Distance(-1, "feet")
_zg7Kf.ShowObjects = "OnEnter"
_zg7Kf.ProximityRange = Distance(60, "meters")
_zg7Kf.AllowSetPositionTo = false
_zg7Kf.Active = false
_zg7Kf.Points = {
	ZonePoint(51.3207965175731, 9.61071565747261, 0), 
	ZonePoint(51.3207160564664, 9.61078271269798, 0), 
	ZonePoint(51.3207831073985, 9.61090877652168, 0), 
	ZonePoint(51.3208233379106, 9.610785394907, 0)
}
_zg7Kf.OriginalPoint = ZonePoint(51.3207797548371, 9.61079813539982, 0)
_zg7Kf.DistanceRangeUOM = "Feet"
_zg7Kf.ProximityRangeUOM = "Meters"
_zg7Kf.OutOfRangeName = ""
_zg7Kf.InRangeName = ""
_EiVA_ = Wherigo.Zone(_WIk9)
_EiVA_.Id = "5247785e-5528-4a4e-a0e7-88ee16b44304"
_EiVA_.Name = _Qfj2("\038\087\019\071\036\106\080\125\114\071\087\027\027\127\010\114\111\077")
_EiVA_.Description = ""
_EiVA_.Visible = true
_EiVA_.Commands = {}
_EiVA_.DistanceRange = Distance(-1, "feet")
_EiVA_.ShowObjects = "OnEnter"
_EiVA_.ProximityRange = Distance(60, "meters")
_EiVA_.AllowSetPositionTo = false
_EiVA_.Active = false
_EiVA_.Points = {
	ZonePoint(51.3211133318089, 9.60502400994301, 0), 
	ZonePoint(51.3209758782823, 9.60490599274635, 0), 
	ZonePoint(51.3209071513645, 9.60513666272163, 0), 
	ZonePoint(51.3210496338844, 9.60524931550026, 0)
}
_EiVA_.OriginalPoint = ZonePoint(51.321011498835, 9.60507899522781, 0)
_EiVA_.DistanceRangeUOM = "Feet"
_EiVA_.ProximityRangeUOM = "Meters"
_EiVA_.OutOfRangeName = ""
_EiVA_.InRangeName = ""
_9zZDt = Wherigo.Zone(_WIk9)
_9zZDt.Id = "815d181e-5601-418d-b28f-555ece30f0c3"
_9zZDt.Name = _Qfj2("\058\080\027\039\027\125\080\087\077\039\080\016\019\039\077\007\106\039\041\127\010\114\111\077\039\046")
_9zZDt.Description = ""
_9zZDt.Visible = true
_9zZDt.Commands = {}
_9zZDt.DistanceRange = Distance(-1, "feet")
_9zZDt.ShowObjects = "OnEnter"
_9zZDt.ProximityRange = Distance(60, "meters")
_9zZDt.AllowSetPositionTo = false
_9zZDt.Active = false
_9zZDt.Points = {
	ZonePoint(51.3214904887603, 9.6037794649601, 0), 
	ZonePoint(51.3211367994432, 9.60361585021019, 0), 
	ZonePoint(51.3210446050972, 9.60398867726326, 0), 
	ZonePoint(51.3214334963533, 9.60417106747627, 0)
}
_9zZDt.OriginalPoint = ZonePoint(51.3212763474135, 9.60388876497746, 0)
_9zZDt.DistanceRangeUOM = "Feet"
_9zZDt.ProximityRangeUOM = "Meters"
_9zZDt.OutOfRangeName = ""
_9zZDt.InRangeName = ""
_U2cu = Wherigo.Zone(_WIk9)
_U2cu.Id = "248a337d-730b-4c92-b7eb-22b3f82646ef"
_U2cu.Name = _Qfj2("\095\069\007\111\114\068\039\046\046\046")
_U2cu.Description = ""
_U2cu.Visible = true
_U2cu.Commands = {}
_U2cu.DistanceRange = Distance(-1, "feet")
_U2cu.ShowObjects = "OnEnter"
_U2cu.ProximityRange = Distance(60, "meters")
_U2cu.AllowSetPositionTo = false
_U2cu.Active = false
_U2cu.Points = {
	ZonePoint(51.3201913795389, 9.60177049040794, 0), 
	ZonePoint(51.3202818993094, 9.60181340575218, 0), 
	ZonePoint(51.3203171013942, 9.60173562169075, 0), 
	ZonePoint(51.3202383157385, 9.60166856646538, 0)
}
_U2cu.OriginalPoint = ZonePoint(51.3202571739953, 9.60174702107906, 0)
_U2cu.DistanceRangeUOM = "Feet"
_U2cu.ProximityRangeUOM = "Meters"
_U2cu.OutOfRangeName = ""
_U2cu.InRangeName = ""
_wroP8 = Wherigo.Zone(_WIk9)
_wroP8.Id = "a946c566-4e04-4b3c-8ca2-47df8eeb3d20"
_wroP8.Name = _Qfj2("\067\026\069\016\007\036\034\016\087\068\039")
_wroP8.Description = _Qfj2("\089\089\089\039\019\016\007\036\039\103\007\071\127\080\127\010\007\036\039\071\010\087\007\039\081\114\087\077\007\036\051\080\068\007\087\039\071\077\007\036\039\082\080\010\036\036\080\077")
_wroP8.Visible = true
_wroP8.Commands = {}
_wroP8.DistanceRange = Distance(-1, "feet")
_wroP8.ShowObjects = "OnEnter"
_wroP8.ProximityRange = Distance(60, "meters")
_wroP8.AllowSetPositionTo = false
_wroP8.Active = false
_wroP8.Points = {
	ZonePoint(51.3169845175946, 9.59743872284889, 0), 
	ZonePoint(51.316877227172, 9.59754601120949, 0), 
	ZonePoint(51.3169576950125, 9.59772035479546, 0), 
	ZonePoint(51.3170666616548, 9.59759429097176, 0)
}
_wroP8.OriginalPoint = ZonePoint(51.3169715253585, 9.5975748449564, 0)
_wroP8.DistanceRangeUOM = "Feet"
_wroP8.ProximityRangeUOM = "Meters"
_wroP8.OutOfRangeName = ""
_wroP8.InRangeName = ""
_qeXAn = Wherigo.Zone(_WIk9)
_qeXAn.Id = "a98f6c45-e1e0-40c2-9c99-f43aaf3aad46"
_qeXAn.Name = _Qfj2("\081\114\087\077\007\036\051\080\068\007\087\027\125\036\007\127\069\007\039\013\114\087\027\068\007\027\080\106\125\039\127\080\089\039\001\008\123\039\011\007\125\007\036\039\126\106\051\007\068\035")
_qeXAn.Description = ""
_qeXAn.Visible = true
_qeXAn.Commands = {}
_qeXAn.DistanceRange = Distance(-1, "feet")
_qeXAn.ShowObjects = "OnEnter"
_qeXAn.ProximityRange = Distance(60, "meters")
_qeXAn.AllowSetPositionTo = false
_qeXAn.Active = false
_qeXAn.Points = {
	ZonePoint(51.3150004423985, 9.59346771240234, 0), 
	ZonePoint(51.3148294407734, 9.59355890750885, 0), 
	ZonePoint(51.3148797354352, 9.59382176399231, 0), 
	ZonePoint(51.3151043842514, 9.5937305688858, 0)
}
_qeXAn.OriginalPoint = ZonePoint(51.3149535007146, 9.59364473819732, 0)
_qeXAn.DistanceRangeUOM = "Feet"
_qeXAn.ProximityRangeUOM = "Meters"
_qeXAn.OutOfRangeName = ""
_qeXAn.InRangeName = ""
_BXdrW = Wherigo.Zone(_WIk9)
_BXdrW.Id = "e58e6965-fccb-4eb6-9254-bda0d465f8ca"
_BXdrW.Name = _Qfj2("\041\016\077\071\069\016\039\021\039\011\043\027\125\007\036\043\039\014\080\127\010\007")
_BXdrW.Description = ""
_BXdrW.Visible = true
_BXdrW.Commands = {}
_BXdrW.DistanceRange = Distance(-1, "feet")
_BXdrW.ShowObjects = "OnEnter"
_BXdrW.ProximityRange = Distance(60, "meters")
_BXdrW.AllowSetPositionTo = false
_BXdrW.Active = false
_BXdrW.Points = {
	ZonePoint(51.3163566974192, 9.59874898195267, 0), 
	ZonePoint(51.3162485673094, 9.59883615374565, 0), 
	ZonePoint(51.3163072425944, 9.59901586174965, 0), 
	ZonePoint(51.3164162107818, 9.59893807768822, 0)
}
_BXdrW.OriginalPoint = ZonePoint(51.3163321795262, 9.59888476878405, 0)
_BXdrW.DistanceRangeUOM = "Feet"
_BXdrW.ProximityRangeUOM = "Meters"
_BXdrW.OutOfRangeName = ""
_BXdrW.InRangeName = ""
_qhao = Wherigo.Zone(_WIk9)
_qhao.Id = "4108c1c6-3f9d-44a8-b6b1-f40eb85714e3"
_qhao.Name = _Qfj2("\082\114\087\080\111")
_qhao.Description = ""
_qhao.Visible = true
_qhao.Commands = {}
_qhao.DistanceRange = Distance(-1, "feet")
_qhao.ShowObjects = "OnEnter"
_qhao.ProximityRange = Distance(60, "meters")
_qhao.AllowSetPositionTo = false
_qhao.Active = false
_qhao.Points = {
	ZonePoint(51.3176659735616, 9.60893467068672, 0), 
	ZonePoint(51.3175352152679, 9.60892662405968, 0), 
	ZonePoint(51.3175754486288, 9.60917338728905, 0), 
	ZonePoint(51.3176642971756, 9.60912510752678, 0)
}
_qhao.OriginalPoint = ZonePoint(51.3176102336585, 9.60903994739056, 0)
_qhao.DistanceRangeUOM = "Feet"
_qhao.ProximityRangeUOM = "Meters"
_qhao.OutOfRangeName = ""
_qhao.InRangeName = ""
_Icfi = Wherigo.Zone(_WIk9)
_Icfi.Id = "4296cb60-44c9-4772-b178-3e8524cbde68"
_Icfi.Name = _Qfj2("\040\071\087\016\027\039\014\080\127\010\007\039\021\039\103\014\088\040\067\014\060")
_Icfi.Description = _Qfj2("\011\080\041\114\096\016\039\008\069\039\040\071\087\016\027\093\039\067\016\019\039\077\007\106\039\098\016\127\069\051\007\068\039\034\016\106\039\014\080\127\010\007\021\025\021\011\071\026\114\111")
_Icfi.Visible = true
_Icfi.Commands = {}
_Icfi.DistanceRange = Distance(-1, "feet")
_Icfi.ShowObjects = "OnEnter"
_Icfi.ProximityRange = Distance(60, "meters")
_Icfi.AllowSetPositionTo = false
_Icfi.Active = false
_Icfi.Points = {
	ZonePoint(51.318032262438, 9.61218819022179, 0), 
	ZonePoint(51.3180356151831, 9.61228206753731, 0), 
	ZonePoint(51.3180842299594, 9.61229547858238, 0), 
	ZonePoint(51.3181294919462, 9.61218819022179, 0), 
	ZonePoint(51.3181127282525, 9.61210504174232, 0)
}
_Icfi.OriginalPoint = ZonePoint(51.3180788655558, 9.61221179366112, 0)
_Icfi.DistanceRangeUOM = "Feet"
_Icfi.ProximityRangeUOM = "Meters"
_Icfi.OutOfRangeName = ""
_Icfi.InRangeName = ""
_Kar = Wherigo.Zone(_WIk9)
_Kar.Id = "305ae853-5ed9-4c99-bdef-a30dd7f9098b"
_Kar.Name = _Qfj2("\099\114\007\036\039\111\080\087\068\039\068\007\010\125\039\007\027\039\034\016\106\039\050\080\036\069\124\111\080\125\034")
_Kar.Description = ""
_Kar.Visible = true
_Kar.Commands = {}
_Kar.DistanceRange = Distance(-1, "feet")
_Kar.ShowObjects = "OnEnter"
_Kar.ProximityRange = Distance(60, "meters")
_Kar.AllowSetPositionTo = false
_Kar.Active = false
_Kar.Points = {
	ZonePoint(51.3170473829602, 9.61206346750259, 0), 
	ZonePoint(51.3170473829602, 9.61236387491226, 0), 
	ZonePoint(51.3174245733437, 9.61232632398605, 0), 
	ZonePoint(51.3174279261332, 9.61209833621979, 0)
}
_Kar.OriginalPoint = ZonePoint(51.3172368163493, 9.61221300065517, 0)
_Kar.DistanceRangeUOM = "Feet"
_Kar.ProximityRangeUOM = "Meters"
_Kar.OutOfRangeName = ""
_Kar.InRangeName = ""
_fqJt = Wherigo.Zone(_WIk9)
_fqJt.Id = "84eed26f-a46b-4db8-909f-8073751bb6b3"
_fqJt.Name = _Qfj2("\050\071\051\007\036\039\014\080\127\010\007\036")
_fqJt.Description = ""
_fqJt.Visible = true
_fqJt.Commands = {}
_fqJt.DistanceRange = Distance(-1, "feet")
_fqJt.ShowObjects = "OnEnter"
_fqJt.ProximityRange = Distance(60, "meters")
_fqJt.AllowSetPositionTo = false
_fqJt.Active = false
_fqJt.Points = {
	ZonePoint(51.3205752491892, 9.60703700780869, 0), 
	ZonePoint(51.3204646145973, 9.60703164339066, 0), 
	ZonePoint(51.320456233178, 9.60713356733322, 0), 
	ZonePoint(51.32056854407, 9.60715770721436, 0)
}
_fqJt.OriginalPoint = ZonePoint(51.3205161602586, 9.60708998143673, 0)
_fqJt.DistanceRangeUOM = "Feet"
_fqJt.ProximityRangeUOM = "Meters"
_fqJt.OutOfRangeName = ""
_fqJt.InRangeName = ""
_kHmEv = Wherigo.Zone(_WIk9)
_kHmEv.Id = "fff50bdf-84d6-401b-aa2c-8d11bfac9ad6"
_kHmEv.Name = _Qfj2("\014\080\127\010\007\021\025\021\011\071\026\114\111")
_kHmEv.Description = ""
_kHmEv.Visible = true
_kHmEv.Commands = {}
_kHmEv.DistanceRange = Distance(-1, "feet")
_kHmEv.ShowObjects = "OnEnter"
_kHmEv.ProximityRange = Distance(60, "meters")
_kHmEv.AllowSetPositionTo = false
_kHmEv.Active = false
_kHmEv.Points = {
	ZonePoint(51.3116314253198, 9.61431384086609, 0), 
	ZonePoint(51.3114184957995, 9.61422801017761, 0), 
	ZonePoint(51.3113883167325, 9.61459279060364, 0), 
	ZonePoint(51.3115928633539, 9.61522042751312, 0), 
	ZonePoint(51.311769745148, 9.61509302258492, 0)
}
_kHmEv.OriginalPoint = ZonePoint(51.3115601692707, 9.61468961834908, 0)
_kHmEv.DistanceRangeUOM = "Feet"
_kHmEv.ProximityRangeUOM = "Meters"
_kHmEv.OutOfRangeName = ""
_kHmEv.InRangeName = ""
_GVR = Wherigo.Zone(_WIk9)
_GVR.Id = "632c541f-0242-421a-87cf-7ee4709c3483"
_GVR.Name = _Qfj2("\082\012\082\039\041\125\080\036\125\039\019\016\007\036\039\111\080\087\068\027\080\106\007\039\103\007\071\127\080\127\010\007\036")
_GVR.Description = ""
_GVR.Visible = true
_GVR.Commands = {}
_GVR.DistanceRange = Distance(-1, "feet")
_GVR.ShowObjects = "OnEnter"
_GVR.ProximityRange = Distance(60, "meters")
_GVR.AllowSetPositionTo = false
_GVR.Active = false
_GVR.Points = {
	ZonePoint(51.3237994598169, 9.62318256497383, 0), 
	ZonePoint(51.3236502811704, 9.62310209870338, 0), 
	ZonePoint(51.3235530633643, 9.62364658713341, 0), 
	ZonePoint(51.3236770998392, 9.62381020188332, 0)
}
_GVR.OriginalPoint = ZonePoint(51.3236699760477, 9.62343536317348, 0)
_GVR.DistanceRangeUOM = "Feet"
_GVR.ProximityRangeUOM = "Meters"
_GVR.OutOfRangeName = ""
_GVR.InRangeName = ""
_Rpn9 = Wherigo.Zone(_WIk9)
_Rpn9.Id = "f352df7f-f3ca-45e1-aa2d-dcb0d51ca756"
_Rpn9.Name = _Qfj2("\082\012\082\039\053\114\007\111\039\019\016\007\036\039\111\080\087\068\027\080\106\007\039\103\007\071\127\080\127\010\007\036")
_Rpn9.Description = ""
_Rpn9.Visible = true
_Rpn9.Commands = {}
_Rpn9.DistanceRange = Distance(-1, "feet")
_Rpn9.ShowObjects = "OnEnter"
_Rpn9.ProximityRange = Distance(60, "meters")
_Rpn9.AllowSetPositionTo = false
_Rpn9.Active = false
_Rpn9.Points = {
	ZonePoint(51.3239461237435, 9.62083697319031, 0), 
	ZonePoint(51.3237919170879, 9.62084233760834, 0), 
	ZonePoint(51.3237952694121, 9.6217006444931, 0), 
	ZonePoint(51.3239561806812, 9.62170600891113, 0)
}
_Rpn9.OriginalPoint = ZonePoint(51.3238723727312, 9.62127149105072, 0)
_Rpn9.DistanceRangeUOM = "Feet"
_Rpn9.ProximityRangeUOM = "Meters"
_Rpn9.OutOfRangeName = ""
_Rpn9.InRangeName = ""
_WmZi = Wherigo.Zone(_WIk9)
_WmZi.Id = "6532d52a-f508-4b4d-ba13-363720756aaf"
_WmZi.Name = _Qfj2("\012\114\007\036\007")
_WmZi.Description = ""
_WmZi.Visible = true
_WmZi.Commands = {}
_WmZi.DistanceRange = Distance(-1, "feet")
_WmZi.ShowObjects = "OnEnter"
_WmZi.ProximityRange = Distance(60, "meters")
_WmZi.AllowSetPositionTo = false
_WmZi.Active = false
_WmZi.Points = {
	ZonePoint(51.3183365230563, 9.59951475262642, 0), 
	ZonePoint(51.3182795267303, 9.59944501519203, 0), 
	ZonePoint(51.3182225303336, 9.59952548146248, 0), 
	ZonePoint(51.3182912612738, 9.59959790110588, 0)
}
_WmZi.OriginalPoint = ZonePoint(51.3182824603485, 9.5995207875967, 0)
_WmZi.DistanceRangeUOM = "Feet"
_WmZi.ProximityRangeUOM = "Meters"
_WmZi.OutOfRangeName = ""
_WmZi.InRangeName = ""
_QN3Yc = Wherigo.Zone(_WIk9)
_QN3Yc.Id = "aff6bdfb-222d-4adf-aca0-407b5a3b9ae6"
_QN3Yc.Name = _Qfj2("\082\080\027\125\039\068\007\027\127\010\080\019\019\125")
_QN3Yc.Description = ""
_QN3Yc.Visible = true
_QN3Yc.Commands = {}
_QN3Yc.DistanceRange = Distance(-1, "feet")
_QN3Yc.ShowObjects = "OnEnter"
_QN3Yc.ProximityRange = Distance(60, "meters")
_QN3Yc.AllowSetPositionTo = false
_QN3Yc.Active = false
_QN3Yc.Points = {
	ZonePoint(51.3165754715127, 9.60541158914566, 0), 
	ZonePoint(51.3165067380017, 9.60543572902679, 0), 
	ZonePoint(51.3165520015449, 9.60562884807587, 0), 
	ZonePoint(51.3166240878363, 9.60554033517838, 0)
}
_QN3Yc.OriginalPoint = ZonePoint(51.3165645747239, 9.60550412535668, 0)
_QN3Yc.DistanceRangeUOM = "Feet"
_QN3Yc.ProximityRangeUOM = "Meters"
_QN3Yc.OutOfRangeName = ""
_QN3Yc.InRangeName = ""
_WjJO = Wherigo.Zone(_WIk9)
_WjJO.Id = "cba32e41-878f-48bd-abf1-50e24d484ac5"
_WjJO.Name = _Qfj2("\040\071\087\016\027\021\040\071\087\016\027\039\014\080\127\010\007\039\021\039\103\014\088\040\067\090\112")
_WjJO.Description = _Qfj2("\011\080\041\114\096\016\039\008\069\039\040\071\087\016\027\021\040\071\087\016\027\093\039\081\016\036\034\039\062\071\036\039\077\007\106\039\014\080\127\010\007\021\025\021\011\071\026\114\111")
_WjJO.Visible = true
_WjJO.Commands = {}
_WjJO.DistanceRange = Distance(-1, "feet")
_WjJO.ShowObjects = "OnEnter"
_WjJO.ProximityRange = Distance(60, "meters")
_WjJO.AllowSetPositionTo = false
_WjJO.Active = false
_WjJO.Points = {
	ZonePoint(51.3146969978999, 9.61288556456566, 0), 
	ZonePoint(51.3146081436061, 9.6129284799099, 0), 
	ZonePoint(51.3146299380714, 9.61304381489754, 0), 
	ZonePoint(51.314718792323, 9.61301162838936, 0)
}
_WjJO.OriginalPoint = ZonePoint(51.3146634679751, 9.61296737194062, 0)
_WjJO.DistanceRangeUOM = "Feet"
_WjJO.ProximityRangeUOM = "Meters"
_WjJO.OutOfRangeName = ""
_WjJO.InRangeName = ""

-- Characters --
_nVz = Wherigo.ZCharacter{
	Cartridge = _WIk9, 
	Container = _4Hwl
}
_nVz.Id = "2fbc59a1-7cac-4f13-b5a9-756fc25f1940"
_nVz.Name = _Qfj2("\040\111\114\087\077\021\060\071\071\026\027")
_nVz.Description = _Qfj2("\090\080\027\039\027\127\010\007\114\087\125\039\007\114\087\039\103\007\071\127\080\127\010\007\036\039\034\016\039\027\007\114\087\039\089\089\089")
_nVz.Visible = true
_nVz.Media = _1ZOBx
_nVz.Commands = {
	_YeOP = Wherigo.ZCommand{
		Text = _Qfj2("\080\087\027\124\036\007\127\010\007\087"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Qfj2("\060\114\127\010\125\039\062\007\036\019\016\068\026\080\036")
	}
}
_nVz.Commands._YeOP.Custom = true
_nVz.Commands._YeOP.Id = "f49b7c12-9e63-4145-9586-4a6648805bcf"
_nVz.Commands._YeOP.WorksWithAll = true
_nVz.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_nVz.Gender = "Male"
_nVz.Type = "NPC"

-- Items --
_eYw = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _2vQBm
}
_eYw.Id = "126c8076-c1c4-465e-9a51-5f232dd0ea91"
_eYw.Name = _Qfj2("\096\007\114\125\007\036")
_eYw.Description = ""
_eYw.Visible = true
_eYw.Media = _5bf
_eYw.Commands = {
	_B0xdW = Wherigo.ZCommand{
		Text = _Qfj2("\026\007\087\016\125\034\007\087"), 
		CmdWith = true, 
		Enabled = true, 
		EmptyTargetListText = _Qfj2("\095\114\087\007\039\088\076\052\123\039\011\007\125\007\036\039\096\007\114\125\007\036\039\026\007\087\016\125\034\007\087\039\051\114\111\111\039\068\016\125\039\016\007\026\007\036\111\007\068\125\039\027\007\114\087\089")
	}
}
_eYw.Commands._B0xdW.Custom = true
_eYw.Commands._B0xdW.Id = "07eb8024-545d-479f-bc3f-a1f8d774e428"
_eYw.Commands._B0xdW.WorksWithAll = false
_eYw.Commands._B0xdW.WorksWithListIds = {
	"7cefd568-f2c7-4f1e-b7cc-0cba2ee82711"
}
_eYw.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_eYw.Locked = false
_eYw.Opened = false
_5BBLl = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _2vQBm
}
_5BBLl.Id = "e9c308dc-5782-4856-9cdf-87ae2a710b2e"
_5BBLl.Name = _Qfj2("\090\036\007\127\069\114\068\007\036\039\098\016\127\069\027\080\127\069")
_5BBLl.Description = _Qfj2("\090\007\036\039\106\016\007\027\125\007\039\106\080\111\039\068\007\036\007\114\087\114\068\125\039\051\007\036\077\007\087\089")
_5BBLl.Visible = true
_5BBLl.Media = _MDPqF
_5BBLl.Commands = {}
_5BBLl.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_5BBLl.Locked = false
_5BBLl.Opened = false
_QyB2 = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _2vQBm
}
_QyB2.Id = "c801e933-6bc9-443e-bd08-be551d25d8b6"
_QyB2.Name = _Qfj2("\040\007\027\007\087")
_QyB2.Description = _Qfj2("\038\077\007\080\111\039\034\016\106\039\036\007\114\087\114\068\007\087\039\077\036\007\127\069\114\068\007\036\039\041\080\127\010\007\087")
_QyB2.Visible = true
_QyB2.Media = _GX0gb
_QyB2.Commands = {
	_wmcn = Wherigo.ZCommand{
		Text = _Qfj2("\098\016\127\069\027\080\127\069\039\036\007\114\087\114\068\007\087"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_QyB2.Commands._wmcn.Custom = true
_QyB2.Commands._wmcn.Id = "df3cb19a-0c91-4dc5-a48b-997e6a8dc5e6"
_QyB2.Commands._wmcn.WorksWithAll = true
_QyB2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_QyB2.Locked = false
_QyB2.Opened = false
_EYwS = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = Player
}
_EYwS.Id = "39fe6826-e29d-4353-b29b-ae5d1abb6f13"
_EYwS.Name = _Qfj2("\012\007\080\106\039\098\016\127\069\027\080\127\069")
_EYwS.Description = _Qfj2("\041\114\007\010\125\039\077\071\127\010\039\068\016\125\039\080\016\027\039\071\077\007\036\039\087\114\127\010\125\046")
_EYwS.Visible = false
_EYwS.Media = _FYB
_EYwS.Commands = {}
_EYwS.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_EYwS.Locked = false
_EYwS.Opened = false
_IkhN4 = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _2vQBm
}
_IkhN4.Id = "b183720f-6895-4944-894f-58c7db85d799"
_IkhN4.Name = _Qfj2("\011\007\125\080\111\111\027\124\111\114\087\125")
_IkhN4.Description = _Qfj2("\095\114\087\039\041\124\111\114\087\125\039\080\016\027\039\011\007\125\080\111\111")
_IkhN4.Visible = true
_IkhN4.Media = _OS1O
_IkhN4.Commands = {
	_kxe = Wherigo.ZCommand{
		Text = _Qfj2("\026\007\087\016\125\034\007\087"), 
		CmdWith = true, 
		Enabled = true, 
		EmptyTargetListText = _Qfj2("\010\114\007\036\039\077\071\127\010\039\087\114\127\010\125\002")
	}
}
_IkhN4.Commands._kxe.Custom = true
_IkhN4.Commands._kxe.Id = "3cea8acc-1473-4d17-bf2a-d6d7e04e3e86"
_IkhN4.Commands._kxe.WorksWithAll = false
_IkhN4.Commands._kxe.WorksWithListIds = {
	"d0886476-2828-4742-91d3-8202b76f90a4"
}
_IkhN4.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_IkhN4.Locked = false
_IkhN4.Opened = false
_SyQ = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _LHeUh
}
_SyQ.Id = "d0886476-2828-4742-91d3-8202b76f90a4"
_SyQ.Name = _Qfj2("\040\080\016\106\027\125\016\106\124\019\039\127\080\089\039\031\076\008\039\011\007\125\007\036\039\010\071\127\010")
_SyQ.Description = ""
_SyQ.Visible = true
_SyQ.Commands = {}
_SyQ.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_SyQ.Locked = false
_SyQ.Opened = false
_UWjoe = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _2vQBm
}
_UWjoe.Id = "fb87439f-b938-4337-a751-cc036239b806"
_UWjoe.Name = _Qfj2("\082\071\125\071\080\124\124\080\036\080\125")
_UWjoe.Description = _Qfj2("\034\016\106\039\090\071\069\016\106\007\087\125\114\007\036\087\039\016\087\077\039\067\036\127\010\114\062\114\007\036\007\087")
_UWjoe.Visible = true
_UWjoe.Media = _2U5Iq
_UWjoe.Commands = {
	_QmZ = Wherigo.ZCommand{
		Text = _Qfj2("\095\114\087\039\082\071\125\071\039\106\080\127\010\007\087"), 
		CmdWith = true, 
		Enabled = true, 
		EmptyTargetListText = _Qfj2("\060\007\114\087\076\039\077\080\027\039\040\114\111\077\039\010\007\026\007\039\114\127\010\039\106\114\036\039\019\016\007\036\039\007\125\051\080\027\039\026\007\027\071\087\077\007\036\007\027\039\080\016\019\089")
	}
}
_UWjoe.Commands._QmZ.Custom = true
_UWjoe.Commands._QmZ.Id = "c6da5849-e359-4420-a036-39232da50ab2"
_UWjoe.Commands._QmZ.WorksWithAll = false
_UWjoe.Commands._QmZ.WorksWithListIds = {
	"b0532277-3844-438b-9340-8d088a809cb8"
}
_UWjoe.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_UWjoe.Locked = false
_UWjoe.Opened = false
_SMtE = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _EiVA_
}
_SMtE.Id = "b0532277-3844-438b-9340-8d088a809cb8"
_SMtE.Name = _Qfj2("\038\087\125\007\036\007\027\027\080\087\125\007\027\039\041\127\010\114\111\077")
_SMtE.Description = _Qfj2("\095\114\087\039\114\087\125\007\036\007\027\027\080\087\125\007\027\039\095\127\071\039\050\019\080\077\039\041\127\010\114\111\077")
_SMtE.Visible = true
_SMtE.Media = _LlU
_SMtE.Commands = {}
_SMtE.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_SMtE.Locked = false
_SMtE.Opened = false
_EJSdl = Wherigo.ZItem(_WIk9)
_EJSdl.Id = "add99640-2b21-4a58-94d1-492295dadf6b"
_EJSdl.Name = _Qfj2("\082\071\125\071")
_EJSdl.Description = _Qfj2("\089\089\089\039\062\071\087\039\007\114\087\007\106\039\040\007\036\068\106\080\087\087\076\039\077\007\036\039\007\114\087\007\039\099\080\087\077\010\080\027\124\007\111\039\026\007\077\114\007\087\125\089")
_EJSdl.Visible = true
_EJSdl.Media = _ud2Ak
_EJSdl.Commands = {}
_EJSdl.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_EJSdl.Locked = false
_EJSdl.Opened = false
_ru0s = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _U2cu
}
_ru0s.Id = "7cefd568-f2c7-4f1e-b7cc-0cba2ee82711"
_ru0s.Name = _Qfj2("\081\111\007\125\125\007\036\026\080\016\106")
_ru0s.Description = _Qfj2("\090\080\027\039\114\027\125\039\080\026\007\036\039\007\114\087\039\125\071\111\111\007\036\039\081\111\007\125\125\007\036\026\080\016\106")
_ru0s.Visible = true
_ru0s.Commands = {}
_ru0s.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_ru0s.Locked = false
_ru0s.Opened = false
_Fbx = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _4Hwl
}
_Fbx.Id = "67431dab-54a5-420f-a006-ee7e57dab09f"
_Fbx.Name = _Qfj2("\041\127\010\114\111\077\039\089\089\089")
_Fbx.Description = _Qfj2("\089\089\089\039\106\114\125\039\049\039\058\007\068\087\080\106\007\087\089\083\040\098\113\083\040\098\113\081\071\106\114\027\127\010\093\039\067\087\039\077\114\007\027\007\036\039\041\125\007\111\111\007\039\019\080\007\111\111\125\039\016\087\027\039\007\114\087\039\041\124\036\016\127\010\039\007\114\087\093\083\040\098\113\041\071\111\080\087\068\039\077\080\027\039\077\007\016\125\027\127\010\007\039\098\007\114\127\010\039\026\007\027\125\007\010\125\076\039\051\114\036\077\039\033\007\077\007\039\089\089\089\039\036\007\127\010\125\027\039\068\007\077\036\007\010\125\089\083\040\098\113\083\040\098\113\090\016\039\026\036\080\016\127\010\027\125\039\109\007\027\109\039\087\114\127\010\125\039\034\016\039\106\080\127\010\007\087\089\039\041\127\010\080\016\039\007\114\087\019\080\127\010\039\068\007\087\080\016\039\010\114\087\039\002\002\002\083\040\098\113")
_Fbx.Visible = true
_Fbx.Commands = {}
_Fbx.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Fbx.Locked = false
_Fbx.Opened = false
_U0GsD = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _4Hwl
}
_U0GsD.Id = "09d2dfea-b379-4f49-b0c1-522056124126"
_U0GsD.Name = _Qfj2("\103\036\007\087\034\027\125\007\114\087")
_U0GsD.Description = _Qfj2("\117\081\111\016\068\027\127\010\007\114\027\027\007\036\106\071\077\016\027\039\007\114\087\020\083\040\098\113\083\040\098\113\095\114\087\039\103\036\007\087\034\027\125\007\114\087\039\013\080\016\127\010\039\067\026\106\080\036\069\016\087\068\076\039\011\080\036\069\027\125\007\114\087\039\071\077\007\036\039\040\080\087\087\027\125\007\114\087\039\068\007\087\080\087\087\125\035\039\114\027\125\039\007\114\087\007\039\016\007\026\111\114\127\010\007\039\081\007\087\087\034\007\114\127\010\087\016\087\068\039\062\071\087\039\103\036\007\087\034\124\016\087\069\125\007\087\089\083\040\098\113\083\040\098\113\117\081\111\016\068\027\127\010\007\114\027\027\007\036\106\071\077\016\027\039\080\016\027\020\083\040\098\113\083\040\098\113\058\007\087\087\039\077\016\039\010\114\007\036\039\087\080\127\010\039\099\114\087\051\007\114\027\007\087\039\027\016\127\010\027\125\076\039\051\114\036\027\125\039\077\016\039\087\114\127\010\125\027\039\019\114\087\077\007\087\089\039\041\127\010\080\016\039\080\016\019\039\077\007\036\039\080\087\077\007\036\007\087\039\041\007\114\125\007\089")
_U0GsD.Visible = true
_U0GsD.Commands = {}
_U0GsD.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_U0GsD.Locked = false
_U0GsD.Opened = false
_uJrKb = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _nGGC
}
_uJrKb.Id = "d33f87ab-f71e-4ae8-a0c8-73d42c05518f"
_uJrKb.Name = _Qfj2("\058\007\068\069\036\007\016\034\016\087\068")
_uJrKb.Description = _Qfj2("\058\114\007\039\077\007\036\039\060\080\106\007\039\027\127\010\071\087\039\027\080\068\125\076\039\010\114\007\036\039\069\036\007\016\034\007\087\039\027\114\127\010\039\058\007\068\007\039\093\035")
_uJrKb.Visible = true
_uJrKb.Commands = {}
_uJrKb.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_uJrKb.Locked = false
_uJrKb.Opened = false
_wI7r = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _2HX
}
_wI7r.Id = "340257e6-e2ad-4586-a117-d494fb63c4a0"
_wI7r.Name = _Qfj2("\050\080\034\114\019\114\027\127\010\007\039\095\077\007\111\125\080\087\087\007")
_wI7r.Description = _Qfj2("\067\127\010\076\039\089\089\089\039\027\127\010\080\016\039\077\071\127\010\039\027\007\111\026\007\036\039\080\016\019\039\077\080\027\039\041\127\010\114\111\077\039\016\087\077\039\114\087\019\071\036\106\114\007\036\007\039\077\114\127\010\089\039")
_wI7r.Visible = true
_wI7r.Commands = {}
_wI7r.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_wI7r.Locked = false
_wI7r.Opened = false
_QALJa = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _qhao
}
_QALJa.Id = "f49f404b-0434-4a11-afc6-ea12426576e7"
_QALJa.Name = _Qfj2("\082\114\087\080\111")
_QALJa.Description = _Qfj2("\090\080\027\039\040\114\111\077\039\069\080\087\087\039\041\124\071\114\111\007\036\039\007\087\125\010\080\111\125\007\087\039\006\035")
_QALJa.Visible = true
_QALJa.Media = _5kNEu
_QALJa.Commands = {}
_QALJa.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_QALJa.Locked = false
_QALJa.Opened = false
_EzD = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _U2cu
}
_EzD.Id = "4da30000-f814-4412-8c51-7a871009023e"
_EzD.Name = _Qfj2("\103\007\071\127\080\127\010\007")
_EzD.Description = _Qfj2("\103\014\031\112\008\097\052\039\109\090\007\036\039\040\016\087\069\007\036\109\083\040\098\113\083\040\098\113\025\099\076\039\077\080\039\010\114\087\125\007\087\039\026\111\114\125\034\125\039\087\071\127\010\039\007\114\087\039\014\080\127\010\007\039\077\016\036\127\010\039\077\114\007\039\040\080\007\016\106\007\089\039\058\007\036\039\077\007\087\039\087\071\127\010\039\087\114\127\010\125\039\010\080\125\039\089\089\089")
_EzD.Visible = true
_EzD.Media = _N31
_EzD.Commands = {}
_EzD.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_EzD.Locked = false
_EzD.Opened = false
_l7YN = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _2HX
}
_l7YN.Id = "7dda2288-fc51-4c39-a1c3-bbff8ffe7c13"
_l7YN.Name = _Qfj2("\103\007\071\127\080\127\010\007")
_l7YN.Description = _Qfj2("\103\014\031\001\053\060\067\039\109\098\080\027\125\124\111\080\125\034\039\080\106\039\011\016\010\111\007\087\026\007\036\068\039\021\039\022\001\109\083\040\098\113\083\040\098\113\058\007\036\039\077\007\087\039\087\071\127\010\039\087\114\127\010\125\039\010\080\125\076\039\027\071\111\111\125\007\039\034\016\068\036\007\114\019\007\087\002")
_l7YN.Visible = true
_l7YN.Media = _N31
_l7YN.Commands = {}
_l7YN.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_l7YN.Locked = false
_l7YN.Opened = false
_1f1T = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _2vQBm
}
_1f1T.Id = "b6403cf8-f71b-44ba-90c7-22f02c0ef75b"
_1f1T.Name = _Qfj2("\058\080\027\027\007\036\019\111\080\027\127\010\007\039\013\031\096\035")
_1f1T.Description = _Qfj2("\012\036\114\087\069\007\087\039\114\027\125\039\051\114\127\010\125\114\068\002")
_1f1T.Visible = true
_1f1T.Media = _d8jdz
_1f1T.Commands = {}
_1f1T.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_1f1T.Locked = false
_1f1T.Opened = false
_abo = Wherigo.ZItem(_WIk9)
_abo.Id = "7bbe7295-f6aa-40fd-adbe-e14c58b0f474"
_abo.Name = _Qfj2("\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_abo.Description = _Qfj2("\038\106\039\011\071\106\007\087\125\039\026\036\080\016\127\010\027\125\039\077\016\039\087\114\127\010\125\027\039\062\071\106\039\067\016\019\068\080\026\007\087\034\007\125\125\007\111\039\034\016\039\106\080\127\010\007\087\089")
_abo.Visible = true
_abo.Media = _KMc
_abo.Commands = {}
_abo.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_abo.Locked = true
_abo.Opened = false
__AE = Wherigo.ZItem(_WIk9)
__AE.Id = "9b3369ed-4b00-469c-9061-872526260240"
__AE.Name = _Qfj2("\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
__AE.Description = _Qfj2("\040\007\114\039\077\007\106\039\014\080\127\010\007\093\083\040\098\113\109\103\014\070\060\059\095\039\021\039\103\071\125\125\007\027\010\080\007\016\027\007\036\093\039\081\080\125\010\089\039\081\114\036\127\010\007\039\041\125\089\039\055\071\010\080\087\087\007\027\039\040\071\027\127\071\109\083\040\098\113\083\040\098\113\051\080\036\039\077\007\036\039\025\051\087\007\036\039\027\071\039\019\080\114\036\039\016\087\077\039\010\080\125\039\077\114\007\039\050\007\114\111\016\087\068\039\114\087\039\077\080\027\039\096\114\027\125\114\087\068\039\068\007\027\127\010\036\114\007\026\007\087\089\039\090\080\039\007\027\039\027\114\127\010\039\080\026\007\036\039\010\114\007\036\039\016\106\039\077\007\087\039\011\080\027\114\111\016\039\008\081\039\014\080\127\010\007\039\010\080\087\077\007\111\125\076\039\122\087\026\027\124\006\106\016\027\027\125\039\077\016\039\077\114\007\027\007\039\038\087\019\071\036\106\080\125\114\071\087\039\010\114\007\036\039\062\071\036\039\025\036\125\039\007\036\027\125\039\027\016\127\010\007\087\089\083\040\098\113\083\040\098\113\012\036\080\068\007\039\077\114\007\027\007\039\050\007\114\111\016\087\068\039\114\106\039\067\087\027\127\010\111\016\027\027\039\114\087\039\077\007\114\087\039\103\007\036\080\007\125\039\007\114\087\089\039\090\016\039\026\036\080\016\127\010\027\125\039\077\080\019\016\007\036\039\077\080\027\039\058\010\007\036\007\114\068\071\021\041\124\114\007\111\039\087\114\127\010\125\039\062\007\036\111\080\027\027\007\087\039\006\035")
__AE.Visible = true
__AE.Media = _S9H_k
__AE.Commands = {
	_07X = Wherigo.ZCommand{
		Text = _Qfj2("\050\007\114\111\016\087\068\039\007\114\087\125\036\080\068\007\087"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Qfj2("\060\114\127\010\125\039\062\007\036\019\016\068\026\080\036")
	}
}
__AE.Commands._07X.Custom = true
__AE.Commands._07X.Id = "c68d8931-4137-4b53-bd96-f3679046e7e1"
__AE.Commands._07X.WorksWithAll = true
__AE.ObjectLocation = Wherigo.INVALID_ZONEPOINT
__AE.Locked = false
__AE.Opened = false
_bt1 = Wherigo.ZItem(_WIk9)
_bt1.Id = "7f9e1949-b3a0-46f4-a2e3-08c6f791d179"
_bt1.Name = _Qfj2("\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_bt1.Description = _Qfj2("\067\087\039\077\114\007\027\007\036\039\041\125\007\111\111\007\039\010\080\027\125\039\077\016\039\080\026\007\036\039\051\114\036\069\111\114\127\010\039\062\114\007\111\039\103\007\077\016\111\077\039\068\007\010\080\026\125\089")
_bt1.Visible = true
_bt1.Media = _S9H_k
_bt1.Commands = {
	_WkTP = Wherigo.ZCommand{
		Text = _Qfj2("\096\071\007\027\016\087\068\039\007\114\087\125\036\080\068\007\087"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_bt1.Commands._WkTP.Custom = true
_bt1.Commands._WkTP.Id = "cdfe782e-8630-48a5-8048-7481560a888c"
_bt1.Commands._WkTP.WorksWithAll = true
_bt1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_bt1.Locked = false
_bt1.Opened = false
_5_r = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _zg7Kf
}
_5_r.Id = "9f3b10ef-a896-41da-bdd7-0034a956f5ed"
_5_r.Name = _Qfj2("\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_5_r.Description = _Qfj2("\099\114\007\036\039\068\114\026\125\039\007\027\039\007\114\087\007\039\082\036\080\068\007\039\034\016\039\026\007\080\087\125\051\071\036\125\007\087\089\039\090\007\087\039\099\114\087\051\007\114\027\039\077\080\034\016\039\019\114\087\077\007\027\125\039\077\016\039\114\087\039\077\007\036\039\126\106\068\007\026\016\087\068\089\083\040\098\113\099\080\027\125\039\077\016\039\077\114\007\039\041\125\080\125\114\071\087\039\068\007\019\016\087\077\007\087\039\016\087\077\039\077\007\087\069\027\125\039\077\016\039\069\080\087\087\027\125\039\077\114\007\039\082\036\080\068\007\039\026\007\080\087\125\051\071\036\125\007\087\046")
_5_r.Visible = true
_5_r.Media = _S9H_k
_5_r.Commands = {
	_OE9 = Wherigo.ZCommand{
		Text = _Qfj2("\055\080"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_5_r.Commands._OE9.Custom = true
_5_r.Commands._OE9.Id = "7c049d6e-dea9-4508-8915-083dc72d756d"
_5_r.Commands._OE9.WorksWithAll = true
_5_r.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_5_r.Locked = false
_5_r.Opened = false
_HqSm = Wherigo.ZItem(_WIk9)
_HqSm.Id = "c123077f-8e95-4fd0-957b-978faec25511"
_HqSm.Name = _Qfj2("\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_HqSm.Description = _Qfj2("\096\071\027\039\033\007\125\034\125\039\089\089\089\039\027\125\036\007\087\068\039\077\114\127\010\039\080\087\076\039\077\080\087\087\039\019\114\087\077\007\027\125\039\077\016\039\077\080\027\039\082\114\087\080\111\039\080\016\127\010\089")
_HqSm.Visible = true
_HqSm.Media = _S9H_k
_HqSm.Commands = {
	_9Pm = Wherigo.ZCommand{
		Text = _Qfj2("\011\080\127\010\039\114\127\010"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_HqSm.Commands._9Pm.Custom = true
_HqSm.Commands._9Pm.Id = "8bcd88c7-6522-4790-995a-90c39d5a5b0c"
_HqSm.Commands._9Pm.WorksWithAll = true
_HqSm.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_HqSm.Locked = false
_HqSm.Opened = false
_JK1v = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _Icfi
}
_JK1v.Id = "e081f377-b654-496e-95fe-2a54fd1ea3a7"
_JK1v.Name = _Qfj2("\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_JK1v.Description = _Qfj2("\058\114\111\111\027\125\039\077\016\039\071\010\087\007\039\077\007\087\039\040\071\087\016\027\039\087\080\127\010\039\099\080\016\027\007\039\068\007\010\007\087\046")
_JK1v.Visible = true
_JK1v.Media = _S9H_k
_JK1v.Commands = {
	_IPj5 = Wherigo.ZCommand{
		Text = _Qfj2("\060\007\114\087"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_JK1v.Commands._IPj5.Custom = true
_JK1v.Commands._IPj5.Id = "f6420e55-83a1-4e36-bfa1-b54b85b0a200"
_JK1v.Commands._IPj5.WorksWithAll = true
_JK1v.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_JK1v.Locked = false
_JK1v.Opened = false
_Ydd6 = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _fqJt
}
_Ydd6.Id = "bb66bbfd-14d3-443a-ae46-6956667735ec"
_Ydd6.Name = _Qfj2("\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_Ydd6.Description = _Qfj2("\012\036\080\068\007\039\077\114\007\039\068\007\019\016\087\077\007\087\007\039\053\080\010\111\039\114\087\039\077\080\027\039\103\050\041\039\007\114\087\089")
_Ydd6.Visible = true
_Ydd6.Media = _S9H_k
_Ydd6.Commands = {
	_edh = Wherigo.ZCommand{
		Text = _Qfj2("\081\007\114\087\039\050\036\071\026\111\007\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_Ydd6.Commands._edh.Custom = true
_Ydd6.Commands._edh.Id = "36f5a55d-51fe-49d9-8acc-191a435ac764"
_Ydd6.Commands._edh.WorksWithAll = true
_Ydd6.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Ydd6.Locked = false
_Ydd6.Opened = false
_8aw = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _zg7Kf
}
_8aw.Id = "5c83767e-a990-43f8-aefa-644b8bcab7a5"
_8aw.Name = _Qfj2("\103\036\007\087\034\027\125\007\114\087\039\089\089\089")
_8aw.Description = _Qfj2("\095\114\087\039\103\036\007\087\034\027\125\007\114\087\039\010\114\087\125\007\036\039\007\114\087\007\036\039\069\111\007\114\087\007\087\039\080\026\007\036\039\077\071\127\010\039\027\127\010\071\087\039\127\080\089\039\088\039\026\114\027\039\079\039\011\007\125\007\036\039\010\071\010\007\087\039\082\114\127\010\125\007\089\039\090\071\036\125\039\027\114\087\077\039\068\036\007\087\034\051\007\036\125\114\068\007\039\013\096\071\007\027\016\087\068\027\021\035\095\036\068\007\026\087\114\027\027\007\039\077\007\027\039\060\080\127\010\125\007\004\124\036\007\027\027\007\027\039\114\087\039\041\125\007\114\087\039\068\007\106\007\114\027\027\007\111\125\089")
_8aw.Visible = true
_8aw.Media = _Ywh
_8aw.Commands = {}
_8aw.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_8aw.Locked = false
_8aw.Opened = false
_HXCPe = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _qhao
}
_HXCPe.Id = "dce6276f-2edd-4eb8-8c72-43c6560c00c1"
_HXCPe.Name = _Qfj2("\040\080\016\106")
_HXCPe.Description = _Qfj2("\090\114\007\027\007\036\039\040\080\016\106\039\034\007\114\068\125\039\106\114\125\039\027\007\114\087\007\036\039\041\127\010\087\114\125\125\069\080\087\125\007\039\077\114\036\007\069\125\039\080\016\019\039\077\080\027\039\097\007\036\027\125\007\127\069\039\077\007\027\039\082\114\087\080\111\027\089\039\082\016\007\036\039\077\114\007\039\068\080\087\034\039\068\007\087\080\016\007\087\039\013\040\007\125\080\021\012\007\027\125\007\036\035\039\103\007\071\127\080\127\010\007\036\039\089\089\089\039\111\007\114\127\010\125\039\111\114\087\069\027\039\093\035\083\040\098\113\096\025\041\039\041\126\014\099\039\089\089\089")
_HXCPe.Visible = true
_HXCPe.Media = _DCI
_HXCPe.Commands = {}
_HXCPe.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_HXCPe.Locked = false
_HXCPe.Opened = false
_1wkyv = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _Icfi
}
_1wkyv.Id = "564a4617-f486-4120-a234-b1160093c7e2"
_1wkyv.Name = _Qfj2("\041\127\010\114\111\077")
_1wkyv.Description = ""
_1wkyv.Visible = true
_1wkyv.Commands = {}
_1wkyv.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_1wkyv.Locked = false
_1wkyv.Opened = false
_jZRD = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _zg7Kf
}
_jZRD.Id = "d6545dce-a3e7-40a2-b6ad-8facc09288d5"
_jZRD.Name = _Qfj2("\014\080\127\010\007\036\080\016\125\071\026\080\010\087\007\087")
_jZRD.Description = _Qfj2("\095\114\087\007\039\103\007\071\127\080\127\010\007\036\080\016\125\071\026\080\010\087\039\051\016\007\036\077\007\039\080\087\039\077\114\007\027\007\106\039\127\080\089\039\079\123\127\106\039\040\080\016\106\027\125\016\106\124\007\087\039\062\071\036\026\007\114\039\019\016\007\010\036\007\087\089")
_jZRD.Visible = true
_jZRD.Media = _DRbK
_jZRD.Commands = {}
_jZRD.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_jZRD.Locked = false
_jZRD.Opened = false
_MaUa = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _WmZi
}
_MaUa.Id = "c4321ea9-4be4-43b4-a875-98c638e1a1a9"
_MaUa.Name = _Qfj2("\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_MaUa.Description = _Qfj2("\099\080\027\125\039\077\016\039\077\114\007\039\026\111\016\125\036\016\007\087\027\125\114\068\007\039\040\007\027\125\114\007\039\068\007\027\007\010\007\087\046")
_MaUa.Visible = true
_MaUa.Media = _S9H_k
_MaUa.Commands = {
	_tEw = Wherigo.ZCommand{
		Text = _Qfj2("\055\080"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Qfj2("\060\114\127\010\125\039\062\007\036\019\016\068\026\080\036")
	}
}
_MaUa.Commands._tEw.Custom = true
_MaUa.Commands._tEw.Id = "552328c8-6cde-4518-a721-ff13f5baf4bc"
_MaUa.Commands._tEw.WorksWithAll = true
_MaUa.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_MaUa.Locked = false
_MaUa.Opened = false
_ii2N = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _WmZi
}
_ii2N.Id = "ffb47acd-85c3-4f32-acb0-b5dbe9a75094"
_ii2N.Name = _Qfj2("\040\080\016\106\027\125\080\106\106")
_ii2N.Description = _Qfj2("\058\114\007\039\077\007\036\039\060\080\106\007\039\027\127\010\071\087\039\027\080\068\125\076\039\077\080\027\027\039\114\027\125\039\077\007\036\039\041\125\080\106\106\039\007\114\087\007\027\039\040\080\016\106\007\027\076\039\077\007\036\039\127\080\089\039\031\076\008\123\039\106\039\010\071\127\010\039\114\027\125\089")
_ii2N.Visible = true
_ii2N.Commands = {}
_ii2N.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_ii2N.Locked = false
_ii2N.Opened = false
_BmP = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _WjJO
}
_BmP.Id = "5e2393eb-e37b-439f-88e2-ce1a607556c7"
_BmP.Name = _Qfj2("\081\080\124\016\125\125\007\039\040\080\016\106\027\127\010\007\114\026\007")
_BmP.Description = _Qfj2("\067\127\010\125\007\039\080\016\019\039\077\114\007\039\014\080\127\010\007\036\039\067\016\125\071\026\080\010\087")
_BmP.Visible = true
_BmP.Media = _dAa
_BmP.Commands = {}
_BmP.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_BmP.Locked = false
_BmP.Opened = false
_J05 = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _WjJO
}
_J05.Id = "1d375b33-ffb4-41fb-989e-bd7747f338af"
_J05.Name = _Qfj2("\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_J05.Description = _Qfj2("\041\016\127\010\007\039\077\007\087\039\040\071\087\016\027\021\040\071\087\016\027\039\014\080\127\010\007")
_J05.Visible = true
_J05.Media = _S9H_k
_J05.Commands = {
	_teiN = Wherigo.ZCommand{
		Text = _Qfj2("\103\007\019\016\087\077\007\087"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Qfj2("\060\114\127\010\125\039\062\007\036\019\016\068\026\080\036")
	}
}
_J05.Commands._teiN.Custom = true
_J05.Commands._teiN.Id = "84348431-c1de-4f3a-b66e-eb12c339ee66"
_J05.Commands._teiN.WorksWithAll = true
_J05.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_J05.Locked = false
_J05.Opened = false
_Ss9px = Wherigo.ZItem{
	Cartridge = _WIk9, 
	Container = _kHmEv
}
_Ss9px.Id = "d71069fc-4f56-4a16-8f49-cab07eea3ca0"
_Ss9px.Name = _Qfj2("\014\080\127\010\007\021\025\021\011\071\026\114\111")
_Ss9px.Description = _Qfj2("\090\080\027\039\027\114\007\010\125\039\080\016\027\076\039\051\114\007\039\011\036\089\039\012\114\111\111\043\027\039\103\007\027\127\010\071\027\027\039\006\035")
_Ss9px.Visible = true
_Ss9px.Media = _Ni18q
_Ss9px.Commands = {}
_Ss9px.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Ss9px.Locked = false
_Ss9px.Opened = false
_KvaM = Wherigo.ZItem(_WIk9)
_KvaM.Id = "a1e3bef8-db23-4d5f-9598-b15ff5f77478"
_KvaM.Name = _Qfj2("\058\010\007\036\007\114\068\071\039\014\071\114\087")
_KvaM.Description = ""
_KvaM.Visible = true
_KvaM.Media = _Mwd
_KvaM.Commands = {}
_KvaM.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_KvaM.Locked = false
_KvaM.Opened = false
_xD0tC = Wherigo.ZItem(_WIk9)
_xD0tC.Id = "6defef84-a30d-43c4-a6c6-9437c13b31f6"
_xD0tC.Name = _Qfj2("\011\080\041\114\096\016\039\008\069\039\014\071\114\087")
_xD0tC.Description = ""
_xD0tC.Visible = true
_xD0tC.Media = _5mamI
_xD0tC.Commands = {}
_xD0tC.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_xD0tC.Locked = false
_xD0tC.Opened = false
_SGIi5 = Wherigo.ZItem(_WIk9)
_SGIi5.Id = "252a1bcb-6475-4489-b643-a4fb86a421d2"
_SGIi5.Name = _Qfj2("\041\080\062\007\039\040\016\125\125\071\087")
_SGIi5.Description = ""
_SGIi5.Visible = true
_SGIi5.Media = _6fYi
_SGIi5.Commands = {
	_FFiF = Wherigo.ZCommand{
		Text = _Qfj2("\041\124\007\114\127\010\007\036\087"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _Qfj2("\060\114\127\010\125\039\062\007\036\019\016\068\026\080\036")
	}
}
_SGIi5.Commands._FFiF.Custom = true
_SGIi5.Commands._FFiF.Id = "ab13d9e6-f897-42fd-a309-938238b61b7a"
_SGIi5.Commands._FFiF.WorksWithAll = true
_SGIi5.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_SGIi5.Locked = false
_SGIi5.Opened = false

-- Tasks --
_bSQ4 = Wherigo.ZTask(_WIk9)
_bSQ4.Id = "dc1728ee-53fc-48dc-a3b4-d4cd93f68c1c"
_bSQ4.Name = _Qfj2("\082\114\087\077\007\039\077\007\114\087\007\087\039\007\036\027\125\007\087\039\014\080\127\010\007\089\089\089")
_bSQ4.Description = ""
_bSQ4.Visible = true
_bSQ4.Active = false
_bSQ4.Complete = false
_bSQ4.CorrectState = "None"
_OWdO = Wherigo.ZTask(_WIk9)
_OWdO.Id = "b6b9ee25-b22e-4783-bb0c-70006e7392cd"
_OWdO.Name = _Qfj2("\103\007\010\007\039\034\016\036\016\007\127\069\039\034\016\106\039\014\080\127\010\007\021\025\021\011\071\026\114\111")
_OWdO.Description = _Qfj2("\103\007\010\007\039\034\016\036\016\007\127\069\039\034\016\106\039\014\080\127\010\007\021\025\021\011\071\026\114\111\039\016\087\077\039\010\071\111\007\039\077\007\114\087\007\039\067\016\027\036\016\007\027\125\016\087\068\089")
_OWdO.Visible = true
_OWdO.Active = false
_OWdO.Complete = false
_OWdO.CorrectState = "None"
_Wmc6B = Wherigo.ZTask(_WIk9)
_Wmc6B.Id = "d0e6994e-123c-4f56-a3d5-f73aa48b7435"
_Wmc6B.Name = _Qfj2("\098\016\127\069\027\080\127\069\039\036\007\114\087\114\068\007\087")
_Wmc6B.Description = _Qfj2("\090\007\114\087\007\039\103\007\071\127\080\127\010\114\087\068\039\012\071\071\111\027\039\027\071\111\111\125\007\087\039\114\106\106\007\036\039\027\080\016\026\007\036\039\027\007\114\087\089")
_Wmc6B.Visible = true
_Wmc6B.Active = false
_Wmc6B.Complete = false
_Wmc6B.CorrectState = "Correct"
_T8fa = Wherigo.ZTask(_WIk9)
_T8fa.Id = "096e9b26-8a94-4da4-b20f-8187319c973b"
_T8fa.Name = _Qfj2("\041\016\127\010\007\039\077\114\007\039\038\087\019\071\036\106\080\125\114\071\087\007\087\076\039\077\114\007\039\077\016\039\034\016\036\039\050\007\114\111\016\087\068\039\026\036\080\016\127\010\027\125\002")
_T8fa.Description = _Qfj2("\040\007\087\016\125\034\007\039\114\106\039\067\087\027\127\010\111\016\027\027\039\077\007\087\039\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_T8fa.Visible = true
_T8fa.Active = false
_T8fa.Complete = false
_T8fa.CorrectState = "None"
_iLwN = Wherigo.ZTask(_WIk9)
_iLwN.Id = "803cc2e8-d641-4af7-a410-518ca598e1de"
_iLwN.Name = _Qfj2("\082\114\087\077\007\039\077\080\027\039\011\016\111\125\114\039\082\114\087\080\111")
_iLwN.Description = ""
_iLwN.Visible = true
_iLwN.Active = false
_iLwN.Complete = false
_iLwN.CorrectState = "None"
_HZ5 = Wherigo.ZTask(_WIk9)
_HZ5.Id = "59e06e12-b413-4e0c-8143-94ae8801bcf4"
_HZ5.Name = _Qfj2("\096\071\068\007\114\087\125\036\080\068")
_HZ5.Description = ""
_HZ5.Visible = true
_HZ5.Active = false
_HZ5.Complete = false
_HZ5.CorrectState = "None"
_Uojb = Wherigo.ZTask(_WIk9)
_Uojb.Id = "1f20c14f-c057-44df-bc42-412ba82752b3"
_Uojb.Name = _Qfj2("\082\114\087\077\007\039\036\080\016\027\039\051\114\007\039\106\080\087\039\124\007\114\111\125\002")
_Uojb.Description = _Qfj2("\097\114\007\111\111\007\114\127\010\125\039\125\036\114\019\019\027\125\039\077\016\039\033\080\039\034\016\019\080\007\111\111\114\068\039\007\114\087\007\087\039\103\007\071\127\080\127\010\007\036\076\039\077\080\062\071\087\039\027\071\111\111\039\007\027\039\033\080\039\106\007\010\036\007\036\007\039\068\007\026\007\087\039\006\035")
_Uojb.Visible = true
_Uojb.Active = false
_Uojb.Complete = false
_Uojb.CorrectState = "None"
_s8d = Wherigo.ZTask(_WIk9)
_s8d.Id = "64742ee8-4187-4fd9-82e0-74d4f8fd7dc5"
_s8d.Name = _Qfj2("\099\071\111\039\077\114\036\039\077\007\087\039\082\012\082")
_s8d.Description = _Qfj2("\040\007\114\039\122\087\026\027\124\006\077\007\036\039\087\080\007\127\010\027\125\007\087\039\067\016\019\068\080\026\007\076\039\051\071\111\111\007\087\039\051\114\036\039\027\007\010\007\087\039\051\114\007\039\007\027\039\016\106\039\077\007\114\087\007\039\041\127\010\087\007\111\111\114\068\069\007\114\125\039\051\114\036\069\111\114\127\010\039\068\007\027\125\007\111\111\125\039\114\027\125\089\039\053\114\007\111\039\114\027\125\039\007\027\039\013\051\114\007\039\114\106\039\036\114\127\010\125\114\068\007\087\039\096\007\026\007\087\035\039\062\071\036\039\077\007\087\039\080\087\077\007\036\007\087\039\122\087\026\027\124\006\014\080\127\010\007\036\087\039\077\114\007\039\090\071\027\007\039\034\016\039\019\114\087\077\007\087\089\039\096\007\068\007\039\080\111\027\071\039\026\007\114\039\077\007\087\039\087\080\127\010\027\125\007\087\039\127\080\089\039\031\123\123\039\026\114\027\039\031\079\123\039\122\087\026\027\124\006\011\007\125\007\036\087\039\007\114\087\007\087\039\041\124\016\036\125\039\007\114\087\039\089\039\095\027\039\068\007\010\125\039\051\007\114\125\007\036\039\077\007\087\039\058\007\068\039\007\087\125\111\080\087\068\039\026\114\027\039\069\016\036\034\039\087\080\127\010\039\077\007\036\039\040\114\007\068\016\087\068\089\039\038\087\019\071\036\106\114\007\036\007\039\077\114\127\010\039\062\071\036\010\007\036\039\051\071\039\077\080\027\039\053\114\007\111\039\114\027\125\039\016\087\077\039\010\080\026\039\114\106\106\007\036\039\077\007\114\087\039\103\007\036\080\007\125\039\114\106\039\067\016\068\007\089\039\083\040\098\113\083\040\098\113\040\114\027\125\039\077\016\039\034\016\039\111\080\087\068\027\080\106\076\039\106\016\027\027\125\039\077\016\039\087\071\127\010\039\106\080\111\039\036\080\087\089\039\090\080\027\039\114\027\125\039\069\007\114\087\039\041\124\080\027\027\039\089\089\089\039\080\111\027\071\039\125\036\071\007\077\007\111\007\039\087\114\127\010\125\089\083\040\098\113\083\040\098\113\058\007\087\087\039\077\016\039\077\114\007\039\053\071\087\007\039\062\007\036\111\080\007\027\027\125\039\027\125\080\036\125\007\125\039\077\007\036\039\014\071\016\087\125\077\071\051\087\039\080\016\125\071\106\080\125\114\027\127\010\089\039\097\114\007\111\039\103\111\016\007\127\069\002\083\040\098\113\083\040\098\113\099\114\087\051\007\114\027\093\039\090\114\007\039\126\007\026\007\036\009\016\007\036\016\087\068\039\062\071\087\039\041\125\080\036\125\039\016\087\077\039\053\114\007\111\039\051\114\036\077\039\106\114\125\039\007\114\087\007\106\039\012\071\087\039\027\114\068\087\080\111\114\027\114\007\036\125\039\013\089\089\089\039\019\080\111\111\027\039\077\007\114\087\039\103\007\036\080\007\125\039\012\071\007\087\007\039\016\087\125\007\036\027\125\016\007\125\034\125\035\089\039")
_s8d.Visible = true
_s8d.Active = false
_s8d.Complete = false
_s8d.CorrectState = "None"
_1npYZ = Wherigo.ZTask(_WIk9)
_1npYZ.Id = "63ae7d44-a9df-400b-b630-e9492130281c"
_1npYZ.Name = _Qfj2("\012\036\080\068\007\039\077\114\007\039\096\071\007\027\016\087\068\039\007\114\087")
_1npYZ.Description = _Qfj2("\040\007\087\016\125\034\007\039\077\007\087\039\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_1npYZ.Visible = true
_1npYZ.Active = false
_1npYZ.Complete = false
_1npYZ.CorrectState = "None"
_tGnDZ = Wherigo.ZTask(_WIk9)
_tGnDZ.Id = "4b1320d9-c5b6-4b0a-b990-49698faae674"
_tGnDZ.Name = _Qfj2("\058\080\027\039\027\125\080\087\077\039\068\007\087\080\016\039\080\016\019\039\077\007\106\039\041\127\010\114\111\077\046")
_tGnDZ.Description = ""
_tGnDZ.Visible = true
_tGnDZ.Active = false
_tGnDZ.Complete = false
_tGnDZ.CorrectState = "None"
_JcE04 = Wherigo.ZTask(_WIk9)
_JcE04.Id = "6d7570d5-3ffb-4f7d-a7c7-24294fadd14d"
_JcE04.Name = _Qfj2("\103\007\010\039\051\007\114\125\007\036\039\034\016\036\039\082\012\082\039\021\039\041\125\080\036\125\034\071\087\007")
_JcE04.Description = ""
_JcE04.Visible = true
_JcE04.Active = false
_JcE04.Complete = false
_JcE04.CorrectState = "None"
_tqC = Wherigo.ZTask(_WIk9)
_tqC.Id = "7fbc1c47-151c-4359-a30e-9af28280417e"
_tqC.Name = _Qfj2("\103\007\010\007\039\034\016\036\016\007\127\069\039\034\016\036\039\082\012\082\039\021\039\041\125\080\036\125\034\071\087\007\039\019\016\007\036\039\111\080\087\068\027\080\106\007\039\014\080\127\010\007\036")
_tqC.Description = ""
_tqC.Visible = true
_tqC.Active = false
_tqC.Complete = false
_tqC.CorrectState = "None"
_9kl = Wherigo.ZTask(_WIk9)
_9kl.Id = "cffd54db-462d-4c37-8089-950ed421c22f"
_9kl.Name = _Qfj2("\060\080\127\010\125\007\004\124\036\007\027\027\039\021\039\082\036\080\068\007")
_9kl.Description = _Qfj2("\082\114\087\077\007\039\077\114\007\039\041\125\080\125\114\071\087\039\016\087\077\039\026\007\087\016\125\034\007\039\114\106\039\067\087\027\127\010\111\016\027\027\039\077\007\087\039\067\016\019\068\080\026\007\087\034\007\125\125\007\111\089")
_9kl.Visible = true
_9kl.Active = false
_9kl.Complete = false
_9kl.CorrectState = "None"
_Hda = Wherigo.ZTask(_WIk9)
_Hda.Id = "cd45895a-5c72-4394-94e5-82c11a79c276"
_Hda.Name = _Qfj2("\041\016\127\010\007\039\077\114\007\039\038\087\019\071\036\106\080\125\114\071\087")
_Hda.Description = _Qfj2("\041\016\127\010\007\039\077\114\007\039\007\036\019\071\036\077\007\036\111\114\127\010\007\039\038\087\019\071\036\106\080\125\114\071\087\039\016\087\077\039\026\007\087\016\125\034\007\039\114\106\039\067\087\027\127\010\111\016\027\027\039\077\007\114\087\007\087\039\067\016\019\068\080\026\007\087\034\007\125\125\007\111")
_Hda.Visible = true
_Hda.Active = false
_Hda.Complete = false
_Hda.CorrectState = "None"
_iPQg = Wherigo.ZTask(_WIk9)
_iPQg.Id = "8f4904a9-cc69-486d-931a-a9b723ef2e17"
_iPQg.Name = _Qfj2("\082\114\087\077\007\039\036\080\016\027\076\039\051\080\027\039\010\114\007\036\039\027\071\039\036\114\007\127\010\125\002")
_iPQg.Description = _Qfj2("\041\016\127\010\007\039\077\007\087\039\109\041\125\114\087\069\007\036\109\039\106\114\125\039\077\007\106\039\096\071\007\027\016\087\068\027\051\071\036\125\089\083\040\098\113\083\040\098\113\095\062\125\111\089\039\026\036\080\016\127\010\027\125\039\077\016\039\010\114\007\036\039\034\016\027\080\007\125\034\111\114\127\010\039\007\114\087\039\013\062\114\036\125\016\007\111\111\007\027\035\039\099\114\111\019\027\106\114\125\125\007\111\089")
_iPQg.Visible = true
_iPQg.Active = false
_iPQg.Complete = false
_iPQg.CorrectState = "None"
_Yvv = Wherigo.ZTask(_WIk9)
_Yvv.Id = "12005725-eba4-44ae-88f5-e0a2aecbe4db"
_Yvv.Name = _Qfj2("\041\016\127\010\007\039\077\007\087\039\082\114\087\080\111\039\040\007\010\080\007\111\125\007\036")
_Yvv.Description = _Qfj2("\041\016\127\010\007\039\077\007\087\039\082\114\087\080\111\039\040\007\010\080\007\111\125\007\036\039\016\087\077\039\026\007\087\016\125\034\007\039\114\106\039\067\087\027\127\010\111\016\027\027\039\077\007\087\039\067\016\019\068\080\026\007\087\034\007\125\125\007\111\076\039\077\080\106\114\125\039\007\027\039\051\007\114\125\007\036\039\068\007\010\007\087\039\069\080\087\087\089")
_Yvv.Visible = true
_Yvv.Active = false
_Yvv.Complete = false
_Yvv.CorrectState = "None"
_AtKtv = Wherigo.ZTask(_WIk9)
_AtKtv.Id = "7cd3420c-98f0-4ff3-a8fe-bd955f83d901"
_AtKtv.Name = _Qfj2("\041\016\127\010\007\039\077\007\087\039\040\071\087\016\027\039\014\080\127\010\007")
_AtKtv.Description = _Qfj2("\041\016\127\010\007\039\077\007\087\039\040\071\087\016\027\039\014\080\127\010\007\039\016\087\077\039\026\007\087\016\125\034\007\039\114\106\039\067\087\027\127\010\111\016\027\027\039\077\007\087\039\067\016\019\068\080\026\007\087\034\007\125\125\007\111\076\039\077\080\106\114\125\039\007\027\039\051\007\114\125\007\036\039\068\007\010\007\087\039\069\080\087\087\089")
_AtKtv.Visible = true
_AtKtv.Active = false
_AtKtv.Complete = false
_AtKtv.CorrectState = "None"
_Rll = Wherigo.ZTask(_WIk9)
_Rll.Id = "afe73d88-2dc7-46f2-ac04-c40289373904"
_Rll.Name = _Qfj2("\103\007\010\007\039\051\007\114\125\007\036\039\089\089\089")
_Rll.Description = _Qfj2("\089\089\089\039\026\114\027\039\034\016\036\039\087\080\007\127\010\027\125\007\087\039\041\125\080\125\114\071\087")
_Rll.Visible = true
_Rll.Active = false
_Rll.Complete = false
_Rll.CorrectState = "None"
_dBmN = Wherigo.ZTask(_WIk9)
_dBmN.Id = "5b883980-518c-4b5d-81e7-6a827d85b937"
_dBmN.Name = _Qfj2("\041\016\127\010\039\077\080\027\039\012\114\007\036")
_dBmN.Description = _Qfj2("\058\007\087\087\039\077\016\039\077\080\027\039\012\114\007\036\039\068\007\019\016\087\077\007\087\039\010\080\027\125\076\039\026\007\087\016\125\034\007\039\114\106\039\067\087\027\127\010\111\016\027\027\039\077\007\087\039\067\016\019\068\080\026\007\087\034\007\125\125\007\111\089")
_dBmN.Visible = true
_dBmN.Active = false
_dBmN.Complete = false
_dBmN.CorrectState = "None"
_yTqfN = Wherigo.ZTask(_WIk9)
_yTqfN.Id = "e87b5370-b1f1-4048-84ca-910e315473a1"
_yTqfN.Name = _Qfj2("\103\007\010\007\039\034\016\106\039\082\114\087\080\111")
_yTqfN.Description = _Qfj2("\089\089\089\039\077\080\026\007\114\039\026\036\080\016\127\010\125\039\077\007\036\039\068\007\027\127\010\071\125\125\007\036\125\007\039\058\007\068\039\087\114\127\010\125\039\062\007\036\111\080\027\027\007\087\039\051\007\036\077\007\087\089")
_yTqfN.Visible = true
_yTqfN.Active = false
_yTqfN.Complete = false
_yTqfN.CorrectState = "None"
_AqFN = Wherigo.ZTask(_WIk9)
_AqFN.Id = "f9967a69-ffdf-4b81-81e1-073167a46e6c"
_AqFN.Name = _Qfj2("\082\114\087\077\007\039\036\080\016\027\076\039\051\080\027\039\077\016\039\010\114\007\036\039\125\016\087\039\106\016\027\027\125")
_AqFN.Description = ""
_AqFN.Visible = true
_AqFN.Active = false
_AqFN.Complete = false
_AqFN.CorrectState = "None"
_kfC = Wherigo.ZTask(_WIk9)
_kfC.Id = "beec4905-1c6f-4301-ab17-e608ff2a0986"
_kfC.Name = _Qfj2("\041\016\127\010\007\039\077\007\087\039\040\071\087\016\027\021\040\071\087\016\027\039\014\080\127\010\007")
_kfC.Description = _Qfj2("\041\016\127\010\007\039\077\007\087\039\040\071\087\016\027\021\040\071\087\016\027\039\014\080\127\010\007\039\016\087\077\039\026\007\087\016\125\034\007\039\114\106\039\067\087\027\127\010\111\016\027\027\039\077\007\087\039\067\016\019\068\080\026\007\087\034\007\125\125\007\111\076\039\077\080\106\114\125\039\007\027\039\051\007\114\125\007\036\039\068\007\010\007\087\039\069\080\087\087\089")
_kfC.Visible = true
_kfC.Active = false
_kfC.Complete = false
_kfC.CorrectState = "None"
_RNIu5 = Wherigo.ZTask(_WIk9)
_RNIu5.Id = "0d49f4b1-3351-43ac-ab79-bec4f5f95657"
_RNIu5.Name = _Qfj2("\103\007\010\039\051\007\114\125\007\036\039\089\089\089")
_RNIu5.Description = _Qfj2("\077\007\087\039\068\007\027\127\010\071\125\125\007\036\125\007\087\039\099\080\016\124\125\051\007\068\089")
_RNIu5.Visible = true
_RNIu5.Active = false
_RNIu5.Complete = false
_RNIu5.CorrectState = "None"

-- Cartridge Variables --
_4YMfE = _Qfj2("\121\004\095\004\031")
_vy8k8 = _Qfj2("\121\087\097\034")
_4TH = _Qfj2("\121\007\070\051")
_pTha = _Qfj2("\121\026\041\059\079")
_eRa = _Qfj2("\121\011\126\043\123\067")
_4U2G7 = _Qfj2("\121\080\114\098\019")
_WIk9.ZVariables = {
	_4YMfE = _Qfj2("\121\004\095\004\031"), 
	_vy8k8 = _Qfj2("\121\087\097\034"), 
	_4TH = _Qfj2("\121\007\070\051"), 
	_pTha = _Qfj2("\121\026\041\059\079"), 
	_eRa = _Qfj2("\121\011\126\043\123\067"), 
	_4U2G7 = _Qfj2("\121\080\114\098\019")
}

-- Timers --
_aiRf = Wherigo.ZTimer(_WIk9)
_aiRf.Id = "b738882e-ec47-40ea-a34e-80b7218ca186"
_aiRf.Name = _Qfj2("\082\012\082\039\012\114\106\007\036")
_aiRf.Description = ""
_aiRf.Visible = true
_aiRf.Duration = 20
_aiRf.Type = "Countdown"
_ICyin = Wherigo.ZTimer(_WIk9)
_ICyin.Id = "97950a67-4ef9-49a8-a3b3-aca019d8d1a2"
_ICyin.Name = _Qfj2("\082\012\082\039\012\114\106\007\036\039\019\016\007\036\039\111\080\087\068\027\080\106\007\039\103\007\071\127\080\127\010\007\036")
_ICyin.Description = ""
_ICyin.Visible = true
_ICyin.Duration = 50
_ICyin.Type = "Countdown"

-- Inputs --
_MUy0A = Wherigo.ZInput(_WIk9)
_MUy0A.Id = "380a9481-1de2-48e9-a70c-d738de7c038d"
_MUy0A.Name = _Qfj2("\123\008\089\031\039\050\007\114\111\016\087\068\039\011\007\125\007\036\080\087\068\080\026\007")
_MUy0A.Description = ""
_MUy0A.Visible = true
_MUy0A.InputType = "Text"
_MUy0A.Text = _Qfj2("\058\114\007\062\114\007\111\039\011\007\125\007\036\039\027\071\111\111\027\125\039\077\016\039\124\007\114\111\007\087\046")
_rjy1m = Wherigo.ZInput(_WIk9)
_rjy1m.Id = "442e1962-77e5-415c-8393-0a7ae1afb85d"
_rjy1m.Name = _Qfj2("\123\008\089\049\039\103\036\080\077\039\050\007\114\111\016\087\068")
_rjy1m.Description = ""
_rjy1m.Visible = true
_rjy1m.InputType = "Text"
_rjy1m.Text = _Qfj2("\058\114\007\062\114\007\111\039\103\036\080\077\039\106\016\027\027\125\039\077\016\039\124\007\114\111\007\087\046")
_5YgLk = Wherigo.ZInput(_WIk9)
_5YgLk.Id = "3399ba8f-f503-4c32-8bff-67a7b771519f"
_5YgLk.Name = _Qfj2("\123\066\039\096\071\068\007\114\087\125\036\080\068")
_5YgLk.Description = ""
_5YgLk.Visible = true
_5YgLk.Media = _iVa
_5YgLk.InputType = "Text"
_5YgLk.Text = _Qfj2("\011\080\127\010\039\077\007\114\087\007\087\039\007\036\027\125\007\087\039\096\071\068\026\016\127\010\007\114\087\125\036\080\068\039\114\087\077\007\106\039\077\016\039\077\007\114\087\007\087\039\103\007\071\021\060\114\127\069\087\080\106\007\039\114\087\039\077\080\027\039\096\071\068\026\016\127\010\039\027\127\010\036\007\114\026\027\125\089\083\040\098\113\083\040\098\113\099\114\087\051\007\114\027\093\039\103\036\071\027\027\021\039\081\111\007\114\087\027\127\010\036\114\019\125\039\069\080\087\087\039\114\068\087\071\036\114\007\036\125\039\051\007\036\077\007\087")
_o8AGq = Wherigo.ZInput(_WIk9)
_o8AGq.Id = "40d28382-5e8b-4333-944a-a7029e480217"
_o8AGq.Name = _Qfj2("\031\079\039\013\040\080\016\106\027\125\016\106\124\019\039\031\076\008\035\039\103\007\077\016\111\077\027\124\114\007\111")
_o8AGq.Description = ""
_o8AGq.Visible = true
_o8AGq.InputType = "Text"
_o8AGq.Text = _Qfj2("\058\114\007\039\111\080\016\125\007\125\039\077\114\007\039\053\080\010\111\076\039\077\114\007\039\077\016\039\026\007\069\071\106\106\007\087\039\010\080\027\125\046")
_sbn = Wherigo.ZInput(_WIk9)
_sbn.Id = "f25ff2ec-b800-4d2b-8e24-7a6724383a96"
_sbn.Name = _Qfj2("\031\112\039\041\127\010\114\111\077")
_sbn.Description = ""
_sbn.Visible = true
_sbn.Choices = {
	"Smartphone", 
	"Kutsche", 
	"Kurbel", 
	"Handhaspel"
}
_sbn.InputType = "MultipleChoice"
_sbn.Text = _Qfj2("\058\080\027\039\026\007\077\114\007\087\007\087\039\077\114\007\039\034\051\007\114\039\040\007\036\068\106\080\007\087\087\007\036\039\122\087\026\027\124\006\080\016\019\039\077\007\106\039\040\114\111\077\046")
_5oKA = Wherigo.ZInput(_WIk9)
_5oKA.Id = "c528ca3b-243e-40ea-b578-18f51f4dd6cb"
_5oKA.Name = _Qfj2("\049\088\039\041\016\077\071\069\016")
_5oKA.Description = ""
_5oKA.Visible = true
_5oKA.Media = _eNnP
_5oKA.InputType = "Text"
_5oKA.Text = _Qfj2("\058\114\007\039\111\080\016\125\007\125\039\077\114\007\039\019\007\010\111\007\087\077\007\039\053\080\010\111\046")
_kGoNX = Wherigo.ZInput(_WIk9)
_kGoNX.Id = "65ce07eb-3a27-4457-b3bc-67bda5aededf"
_kGoNX.Name = _Qfj2("\049\031\039\081\114\087\077\007\036\051\080\068\007\087\039\077\080\026\007\114\046")
_kGoNX.Description = ""
_kGoNX.Visible = true
_kGoNX.Media = _uFIl
_kGoNX.Choices = {
	"Ja", 
	"Nein"
}
_kGoNX.InputType = "MultipleChoice"
_kGoNX.Text = _Qfj2("\058\114\036\039\026\114\007\125\007\087\039\077\114\036\039\080\087\039\077\114\007\027\007\036\039\041\125\007\111\111\007\039\080\016\127\010\039\007\114\087\007\039\080\111\125\007\036\087\080\125\114\062\007\039\098\071\016\125\007\039\019\016\007\036\039\081\114\087\077\007\036\051\080\068\007\087\039\016\087\077\039\082\080\010\036\036\080\077\019\080\010\036\007\036\039\080\087\039\013\127\080\089\039\001\008\123\039\011\007\125\007\036\039\126\106\051\007\068\035\089\083\040\098\113\011\071\007\127\010\125\007\027\125\039\077\016\039\077\114\007\027\007\087\039\126\106\051\007\068\039\068\007\010\007\087\046")
_ahZc = Wherigo.ZInput(_WIk9)
_ahZc.Id = "6a7f33da-6872-4a98-ac2f-0168e4212fff"
_ahZc.Name = _Qfj2("\031\008\039\077\007\036\121\060\080\127\010\125\007\004\124\036\007\027\027")
_ahZc.Description = ""
_ahZc.Visible = true
_ahZc.InputType = "Text"
_ahZc.Text = _Qfj2("\058\114\007\062\114\007\111\039\082\012\082\027\039\010\080\125\039\099\007\036\036\039\011\080\039\034\016\027\080\106\106\007\087\039\106\114\125\039\077\007\087\039\097\007\036\036\016\007\127\069\125\007\087\039\077\007\027\039\060\080\127\010\125\007\004\124\036\007\027\027\007\027\039\114\087\039\077\007\036\039\060\080\127\010\125\039\079\089\023\008\089\039\060\071\062\007\106\026\007\036\039\049\123\031\031\039\068\007\027\127\010\080\019\019\125\046")
_Q28 = Wherigo.ZInput(_WIk9)
_Q28.Id = "a8d63530-abb5-4069-a0db-a724376186ae"
_Q28.Name = _Qfj2("\031\066\039\013\041\127\010\114\111\077\039\040\080\087\077\035\039\050\071\051\007\036\039\014\080\127\010\007\036")
_Q28.Description = ""
_Q28.Visible = true
_Q28.InputType = "Text"
_Q28.Text = _Qfj2("\058\007\111\127\010\007\039\038\087\019\071\036\106\080\125\114\071\087\039\013\034\051\007\114\027\125\007\111\111\114\068\035\039\010\080\027\125\039\077\016\039\034\016\039\077\007\106\039\109\011\080\069\007\111\109\039\007\114\087\007\027\039\050\071\051\007\036\039\014\080\127\010\007\036\027\039\010\114\007\036\039\062\071\036\039\025\036\125\039\068\007\019\016\087\077\007\087\046")
_1d1qD = Wherigo.ZInput(_WIk9)
_1d1qD.Id = "30ede7df-3d30-4897-81bc-eef0d6ff366b"
_1d1qD.Name = _Qfj2("\031\052\039\103\007\036\016\127\010")
_1d1qD.Description = ""
_1d1qD.Visible = true
_1d1qD.InputType = "Text"
_1d1qD.Text = _Qfj2("\090\114\007\039\096\071\007\027\016\087\068\039\080\016\019\039\077\007\106\039\109\041\125\114\087\069\007\036\109\039\111\080\016\125\007\125\093")
_Dcm = Wherigo.ZInput(_WIk9)
_Dcm.Id = "4f8e484f-0371-4f9d-b4e5-f3899b677ac3"
_Dcm.Name = _Qfj2("\049\008\039\082\114\087\080\111")
_Dcm.Description = ""
_Dcm.Visible = true
_Dcm.Choices = {
	"Ja", 
	"Nein"
}
_Dcm.InputType = "MultipleChoice"
_Dcm.Text = _Qfj2("\099\080\027\125\039\077\016\039\077\080\027\039\082\114\087\080\111\039\068\007\019\016\087\077\007\087\046")
_1lF = Wherigo.ZInput(_WIk9)
_1lF.Id = "cdc97b17-b988-495c-aa91-c0bdf6bd7a93"
_1lF.Name = _Qfj2("\049\066\039\040\071\087\016\027\039\014\080\127\010\007")
_1lF.Description = ""
_1lF.Visible = true
_1lF.Choices = {
	"Ja", 
	"Nein"
}
_1lF.InputType = "MultipleChoice"
_1lF.Text = _Qfj2("\099\080\027\125\039\077\016\039\077\007\087\039\040\071\087\016\027\039\014\080\127\010\007\039\109\103\014\088\040\067\014\060\039\021\011\080\041\114\096\016\039\008\069\039\040\071\087\016\027\093\039\067\016\019\039\077\007\106\039\098\016\127\069\051\007\068\039\034\016\106\039\014\080\127\010\007\021\025\021\011\071\026\114\111\109\039\068\007\019\016\087\077\007\087\046")
_pjpX9 = Wherigo.ZInput(_WIk9)
_pjpX9.Id = "54e2ad00-e51b-4a79-862f-9f46d1709bb6"
_pjpX9.Name = _Qfj2("\031\031\039\082\012\082\039\096\080\010\106\007\039\103\007\071\127\080\127\010\007\036")
_pjpX9.Description = ""
_pjpX9.Visible = true
_pjpX9.Choices = {
	"Lahme Ente", 
	"Ehrgeiziger Sprinter"
}
_pjpX9.InputType = "MultipleChoice"
_pjpX9.Text = _Qfj2("\090\080\027\039\051\080\036\039\033\080\039\051\071\010\111\039\068\080\036\039\087\114\127\010\125\027\089\039\082\016\007\036\039\090\114\127\010\039\027\125\007\111\111\125\039\027\114\127\010\039\033\007\125\034\125\039\077\114\007\039\082\036\080\068\007\093\039\058\080\027\039\026\114\027\125\039\077\016\046\039\083\040\098\113\083\040\098\113\095\114\087\039\109\095\010\036\068\007\114\034\114\068\007\036\039\041\124\036\114\087\125\007\036\109\039\062\007\036\027\016\127\010\125\039\007\027\039\016\087\125\007\036\039\068\111\007\114\127\010\007\087\039\040\007\077\114\087\068\016\087\068\007\087\039\087\071\127\010\106\080\111\089\039\083\040\098\113\095\114\087\007\039\109\096\080\010\106\007\039\095\087\125\007\109\039\062\007\036\027\016\127\010\125\039\007\027\039\106\114\125\039\088\123\039\041\007\069\016\087\077\007\087\039\106\007\010\036\039\087\071\127\010\039\007\114\087\106\080\111\089")
_r30yE = Wherigo.ZInput(_WIk9)
_r30yE.Id = "b70d7680-ac07-406c-8356-33008595437d"
_r30yE.Name = _Qfj2("\049\123\039\098\080\016\124\007")
_r30yE.Description = ""
_r30yE.Visible = true
_r30yE.InputType = "Text"
_r30yE.Text = _Qfj2("\058\007\111\127\010\007\087\039\109\081\114\111\111\007\036\109\039\010\080\027\125\039\077\016\039\068\007\019\016\087\077\007\087\046")
_ZLE = Wherigo.ZInput(_WIk9)
_ZLE.Id = "5b2af3ba-ac14-4b60-816f-f89337b15994"
_ZLE.Name = _Qfj2("\049\079\039\103\036\007\087\034\027\125\007\114\087\039\001\008\112")
_ZLE.Description = ""
_ZLE.Visible = true
_ZLE.InputType = "Text"
_ZLE.Text = _Qfj2("\058\114\007\062\114\007\111\039\014\080\127\010\007\027\039\106\016\027\027\039\077\080\027\039\012\007\080\106\039\087\071\127\010\039\019\114\087\077\007\087\046")
_yCe = Wherigo.ZInput(_WIk9)
_yCe.Id = "f45191bf-6995-425b-b5f1-4bd37b812fda"
_yCe.Name = _Qfj2("\049\112\039\040\071\087\016\027\021\040\071\087\016\027")
_yCe.Description = ""
_yCe.Visible = true
_yCe.Choices = {
	"Ja", 
	"Nein"
}
_yCe.InputType = "MultipleChoice"
_yCe.Text = _Qfj2("\099\080\027\125\039\077\016\039\077\007\087\039\040\071\087\016\027\021\040\071\087\016\027\039\014\080\127\010\007\039\109\103\014\088\040\067\090\112\039\021\039\011\080\041\114\096\016\039\008\069\039\040\071\087\016\027\021\040\071\087\016\027\093\039\081\016\036\034\039\062\071\036\039\077\007\106\039\014\080\127\010\007\021\025\021\011\071\026\114\111\109\039\051\114\036\069\111\114\127\010\039\068\007\019\016\087\077\007\087\046")

-- WorksWithList for object commands --
_eYw.Commands._B0xdW.WorksWithList = {
	_ru0s
}
_IkhN4.Commands._kxe.WorksWithList = {
	_SyQ
}
_UWjoe.Commands._QmZ.WorksWithList = {
	_SMtE
}

-- functions --
function _WIk9:OnStart()
	if (_G[_Qfj2("\095\087\062")][_Qfj2("\090\007\062\114\127\007\038\090")] == _Qfj2("\090\007\027\069\125\071\124")) or (_G[_Qfj2("\095\087\062")][_Qfj2("\050\111\080\125\019\071\036\106")] == _Qfj2("\058\114\087\088\049")) then
		for k, v in pairs(_G[_Qfj2("\121\058\038\069\052")][_Qfj2("\067\111\111\053\025\026\033\007\127\125\027")]) do
			v[_Qfj2("\097\114\027\114\026\111\007")] = false
			v[_Qfj2("\067\127\125\114\062\007")] = false
		end
		_G[_Qfj2("\058\010\007\036\114\068\071")][_Qfj2("\014\071\106\106\080\087\077")](_Qfj2("\041\080\062\007\014\111\071\027\007"))
		return
	end
	_xEx1.Active = true
	_xEx1.Visible = true
	_abo:MoveTo(Player)
	_abo.Visible = true
	_SGIi5:MoveTo(Player)
end
function _WIk9:OnEnd()
	Wherigo.Command "SaveClose"
end
function _WIk9:OnRestore()
end
function _xEx1:OnEnter()
	_4YMfE = _Qfj2("\121\004\095\004\031")
	_WIk9:RequestSync()
	_bSQ4.Active = true
	_bSQ4.Visible = true
	_xEx1.Visible = false
	_nGGC.Active = true
	_nGGC.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\095\036\027\125\007\036\039\011\080\114\039\049\123\031\123\039\007\114\068\007\087\077\111\114\127\010\039\007\114\087\039\068\080\087\034\039\087\071\036\106\080\111\007\036\039\012\080\068\089\039\095\114\087\039\087\007\016\007\027\039\103\007\071\127\080\127\010\007\036\039\012\007\080\106\039\106\114\125\039\077\007\106\039\060\080\106\007\087\039\109\011\080\041\114\096\016\109\039\106\080\127\010\125\039\027\114\127\010\039\080\016\019\039\077\007\087\039\058\007\068\089\039\041\114\007\039\051\071\111\111\007\087\039\114\010\036\007\087\039\007\036\027\125\007\087\039\014\080\127\010\007\039\019\114\087\077\007\087\089\039\083\040\098\113\012\071\125\080\111\039\080\016\019\068\007\036\007\068\125\039\016\087\077\039\010\114\026\026\007\111\114\068\039\027\125\007\111\111\007\087\039\027\114\007\039\010\114\007\036\039\114\010\036\039\067\016\125\071\039\080\026\039\016\087\077\039\068\007\010\007\087\039\111\071\027\039\114\087\039\098\114\127\010\125\016\087\068\039\007\036\027\125\007\036\039\090\071\027\007\089"), 
			Media = _aNnq
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _xEx1:OnExit()
	_4YMfE = _Qfj2("\121\004\095\004\031")
	_vPIJG.Active = true
	_xEx1.Active = false
	_xEx1.Visible = false
	_WIk9:RequestSync()
end
function _vPIJG:OnEnter()
	_4YMfE = _Qfj2("\121\062\050\038\055\103")
	_nGGC.Active = false
	_nGGC.Visible = false
	_bSQ4.Active = false
	_bSQ4.Visible = false
	_OWdO.Active = true
	_WIk9:RequestSync()
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\011\114\027\125\039\089\089\089\039\067\016\027\036\016\007\027\125\016\087\068\039\062\007\036\068\007\027\027\007\087\039\089\089\089\039\051\080\027\039\007\114\087\039\026\111\071\007\077\007\036\039\067\087\019\080\007\087\068\007\036\039\082\007\010\111\007\036\089\039\122\087\026\027\124\006\083\040\098\113\099\007\036\036\039\011\080\039\010\080\125\039\012\007\114\111\007\039\027\007\114\087\007\036\039\067\016\027\036\016\007\027\125\016\087\068\039\114\106\039\067\016\125\071\039\111\114\007\068\007\087\039\068\007\111\080\027\027\007\087\089\039\090\080\026\007\114\039\010\080\125\039\114\010\106\039\011\036\089\039\012\114\111\111\043\039\007\004\125\036\080\039\062\071\036\010\007\036\039\068\007\027\080\068\125\076\039\051\080\027\027\039\007\036\039\080\111\111\007\027\039\106\114\125\087\007\010\106\007\087\039\106\016\027\027\089\039\083\040\098\113\090\080\039\010\114\111\019\125\039\080\111\111\007\027\039\087\114\127\010\125\027\076\039\077\114\007\039\067\016\027\036\016\007\027\125\016\087\068\039\026\036\080\016\127\010\007\087\039\051\114\036\039\080\016\019\039\033\007\077\007\087\039\082\080\111\111\089\083\040\098\113"), 
			Media = _CB08
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_OWdO.Visible = true
	_2vQBm.Active = true
	_2vQBm.Visible = true
end
function _vPIJG:OnExit()
	_4YMfE = _Qfj2("\121\062\050\038\055\103")
	_vPIJG.Active = false
	_WIk9:RequestSync()
end
function _4Hwl:OnEnter()
	_4YMfE = _Qfj2("\121\079\099\051\111")
	_WIk9:RequestSync()
	_nGGC.Visible = false
	_nGGC.Active = false
	_bSQ4.Complete = true
	_bSQ4.Active = false
	_bSQ4.Visible = false
	_Uojb.Visible = true
	_Uojb.Active = true
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\055\007\125\034\125\039\068\007\010\125\039\007\027\039\111\071\027\039\089\089\089\089\083\040\098\113\083\040\098\113\090\080\027\039\012\007\080\106\039\027\125\007\010\125\039\062\071\036\039\027\007\114\087\007\106\039\007\036\027\125\007\087\039\014\080\127\010\007\093\083\040\098\113\109\103\071\125\125\007\027\010\080\007\016\027\007\036\093\039\081\080\125\010\089\039\081\114\036\127\010\007\039\041\125\089\039\055\071\010\080\087\087\007\027\039\040\071\027\127\071\039\021\039\103\014\070\060\059\095\109\083\040\098\113\083\040\098\113\090\071\127\010\039\077\080\039\114\027\125\039\027\127\010\071\087\039\077\080\027\039\007\036\027\125\007\039\050\036\071\026\111\007\106\039\089\089\089\039\124\007\114\111\007\039\027\071\016\087\077\027\071\062\114\007\111\039\011\007\125\007\036\039\106\114\125\039\068\007\087\080\016\027\071\062\114\007\111\039\103\036\080\077\039\089\089\089\083\040\098\113\083\040\098\113\099\067\095\046\039\058\080\027\039\051\071\111\111\007\087\039\077\114\007\046\039\038\127\010\039\068\111\080\016\026\007\039\114\127\010\039\026\036\080\016\127\010\007\039\099\114\111\019\007\002"), 
			Media = _N31
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _4Hwl:OnExit()
	_4YMfE = _Qfj2("\121\079\099\051\111")
	_abo.Visible = true
	__AE.Visible = false
	_WIk9:RequestSync()
end
function _2vQBm:OnEnter()
	_4YMfE = _Qfj2("\121\049\062\059\040\106")
	_WIk9:RequestSync()
	_OWdO.Visible = false
	_OWdO.Active = false
	_5BBLl:MoveTo(Player)
	_QyB2:MoveTo(Player)
	_IkhN4:MoveTo(Player)
	_UWjoe:MoveTo(Player)
	_1f1T:MoveTo(Player)
	_eYw:MoveTo(Player)
	_bSQ4.Active = true
	_bSQ4.Visible = true
	_2vQBm.Visible = false
	_nGGC.Active = true
	_nGGC.Visible = true
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.MessageBox{
		Text = _Qfj2("\090\080\039\114\027\125\039\033\080\039\077\114\007\039\096\007\114\125\007\036\076\039\077\007\036\039\098\016\127\069\027\080\127\069\039\016\087\077\039\051\080\027\039\106\080\087\039\027\071\087\027\125\039\087\071\127\010\039\027\071\039\026\036\080\016\127\010\125\039\089\089\089\089\083\040\098\113\083\040\098\113\055\007\125\034\125\039\069\080\087\087\039\007\027\039\080\026\007\036\039\010\071\019\019\007\087\125\111\114\127\010\039\027\127\010\087\007\111\111\039\111\071\027\068\007\010\007\087\089"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _2vQBm:OnExit()
	_4YMfE = _Qfj2("\121\049\062\059\040\106")
	if _EYwS.Locked == true then
		_bSQ4.Active = true
		_bSQ4.Visible = true
		_4Hwl.Active = true
		_4Hwl.Visible = true
	else
		Wherigo.PlayAudio(_WCwgB)
		_Urwigo.MessageBox{
			Text = _Qfj2("\095\114\087\007\039\027\127\010\036\007\114\007\087\077\007\039\082\036\080\016\039\041\114\039\019\036\080\068\125\093\039\058\114\111\111\027\125\039\077\016\039\051\114\036\069\111\114\127\010\039\106\114\125\039\027\071\039\007\114\087\007\106\039\077\036\007\127\069\114\068\007\087\039\098\016\127\069\027\080\127\069\039\111\071\027\046"), 
			Media = _8Xm, 
			Buttons = {
				_Qfj2("\060\007\114\087"), 
				_Qfj2("\060\080\125\016\007\036\111\114\127\010\039\087\114\127\010\125\039\089\089\089")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
		_Wmc6B.Visible = true
		_Wmc6B.Active = true
		_4Hwl.Visible = false
		_bSQ4.Visible = false
	end
	_2vQBm.Active = false
	_2vQBm.Visible = false
	_WIk9:RequestSync()
end
function _JXU:OnEnter()
	_4YMfE = _Qfj2("\121\055\022\126")
	_WIk9:RequestSync()
	_4Hwl.Active = false
	_4Hwl.Visible = false
	_iLwN.Active = false
	_iLwN.Visible = false
	_HZ5.Active = true
	_HZ5.Visible = true
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\055\126\099\016\016\016\016\016\016\016\016\039\089\089\089\039\077\114\007\039\007\036\027\125\007\039\090\071\027\007\039\089\089\089\039\103\007\019\016\087\077\007\087\083\040\098\113\083\040\098\113\055\007\125\034\125\039\106\080\127\010\125\039\027\127\010\087\007\111\111\039\007\016\036\007\087\039\096\071\068\007\114\087\125\036\080\068\039\089\089\089"), 
			Media = _69Rmn
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_5YgLk)
		end)
	end)
end
function _JXU:OnExit()
	_4YMfE = _Qfj2("\121\055\022\126")
	_WIk9:RequestSync()
end
function _2HX:OnEnter()
	_4YMfE = _Qfj2("\121\049\099\022")
	_WIk9:RequestSync()
	_HI6.Active = true
	_HI6.Visible = true
	_JcE04.Active = true
	_JcE04.Visible = true
	_JXU.Active = false
	_2HX.Visible = false
	_RNIu5.Active = false
	_RNIu5.Visible = false
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\099\114\007\036\039\026\114\125\125\007\039\096\038\060\081\041\039\080\026\026\114\007\068\007\087\089\083\040\098\113\067\127\010\125\016\087\068\039\099\007\036\036\039\011\080\039\089\089\089\039\077\080\027\039\109\036\114\127\010\125\114\068\007\109\039\096\114\087\069\027\089"), 
			Media = _uhUXQ
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _2HX:OnExit()
	_4YMfE = _Qfj2("\121\049\099\022")
	_WIk9:RequestSync()
end
function _HI6:OnEnter()
	_4YMfE = _Qfj2("\121\099\038\066")
	_WIk9:RequestSync()
	_2HX.Active = false
	_2HX.Visible = false
	_HI6.Visible = false
	_HSO.Active = true
	_HSO.Visible = true
	_s8d.Active = true
	_s8d.Visible = true
	_JcE04.Active = false
	_JcE04.Visible = false
	_JcE04.Complete = true
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\082\114\036\027\125\039\125\071\039\082\114\087\077\039\013\069\016\036\034\039\082\012\082\035\039\083\040\098\113\040\007\114\106\039\103\007\071\127\080\127\010\114\087\068\039\026\007\077\007\016\125\007\125\039\082\012\082\076\039\051\007\087\087\039\106\080\087\039\080\111\027\039\095\036\027\125\007\036\039\007\114\087\007\087\039\062\007\036\027\125\007\127\069\125\007\087\039\103\007\071\127\080\127\010\007\039\068\007\019\016\087\077\007\087\039\010\080\125\089\083\040\098\113\058\114\007\039\062\114\007\111\007\087\039\026\007\069\080\087\087\125\039\114\027\125\076\039\114\027\125\039\099\007\036\036\039\011\080\039\114\087\039\077\007\036\039\036\007\111\080\125\114\062\039\069\016\036\034\007\087\039\053\007\114\125\039\027\007\114\087\007\036\039\103\007\071\127\080\127\010\007\036\039\096\080\016\019\026\080\010\087\039\080\016\127\010\039\034\016\106\039\051\080\010\036\007\087\039\082\012\082\021\055\080\007\068\007\036\039\068\007\051\071\036\077\007\087\089\039\067\111\111\007\036\077\114\087\068\027\039\026\007\077\007\016\125\007\125\039\077\080\027\039\080\016\127\010\039\114\106\106\007\036\039\027\007\010\036\039\062\114\007\111\039\041\125\036\007\027\027\089\039\096\071\027\036\007\087\087\007\087\076\039\114\087\027\039\014\080\127\010\007\021\025\021\011\071\026\114\111\039\007\114\087\021\039\016\087\077\039\080\016\027\125\007\114\068\007\087\076\039\111\071\027\036\007\087\087\007\087\076\039\011\036\089\039\012\114\111\111\043\039\069\016\036\034\039\062\071\036\039\077\007\106\039\014\080\127\010\007\039\051\007\068\077\036\016\007\127\069\007\087\076\039\014\080\127\010\007\039\019\114\087\077\007\087\076\039\019\036\007\016\007\087\039\089\089\089\083\040\098\113\083\040\098\113\099\114\007\036\039\051\080\036\125\007\125\039\007\114\087\007\039\069\087\114\019\019\007\111\114\068\007\039\067\016\019\068\080\026\007\039\080\016\019\039\077\114\127\010\076\039\077\114\007\039\077\016\039\111\071\007\027\007\087\039\106\016\027\027\125\089"), 
			Media = _pGjA
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _HI6:OnExit()
	_4YMfE = _Qfj2("\121\099\038\066")
	_WIk9:RequestSync()
	_aiRf:Start()
end
function _HSO:OnEnter()
	_4YMfE = _Qfj2("\121\099\041\025")
	_aiRf:Stop()
	_WIk9:RequestSync()
end
function _HSO:OnExit()
	_4YMfE = _Qfj2("\121\099\041\025")
	_WIk9:RequestSync()
end
function _MZz4:OnEnter()
	_4YMfE = _Qfj2("\121\011\053\034\079")
	_HSO.Active = false
	_HSO.Visible = false
	_MZz4.Visible = false
	_LHeUh.Visible = true
	_LHeUh.Active = true
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\090\036\007\010\007\039\077\114\127\010\039\010\114\007\036\039\016\106\039\088\066\123\039\103\036\080\077\039\016\087\077\039\068\007\010\007\039\077\007\087\039\058\007\068\039\051\007\114\125\007\036\089\083\040\098\113\090\114\007\039\025\051\087\007\036\039\077\114\007\027\007\027\039\014\080\127\010\007\027\039\019\036\007\016\007\087\039\027\114\127\010\039\033\007\125\034\125\039\027\127\010\071\087\039\016\007\026\007\036\039\007\114\087\039\040\114\111\077\039\062\071\087\039\095\016\036\007\036\039\012\036\080\127\069\080\016\019\034\007\114\127\010\016\087\068\039\119\111\080\127\010\119\039"), 
			Media = _nRS
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _MZz4:OnExit()
	_4YMfE = _Qfj2("\121\011\053\034\079")
	_WIk9:RequestSync()
end
function _nGGC:OnEnter()
	_4YMfE = _Qfj2("\121\087\103\103\014")
	_WIk9:RequestSync()
	_4Hwl.Active = true
	_4Hwl.Visible = true
	_nGGC.Visible = false
	_Wmc6B.Active = false
	_Wmc6B.Visible = false
	_Wmc6B.Complete = true
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\082\071\111\068\007\039\077\007\106\039\058\007\068\039\087\080\127\010\039\111\114\087\069\027\002\039\103\007\036\080\077\007\080\016\027\039\027\127\010\007\114\077\007\125\039\077\007\106\087\080\127\010\039\069\071\106\124\111\007\125\125\039\080\016\027\039\006\035"), 
			Media = _l1Lb3
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _nGGC:OnExit()
	_4YMfE = _Qfj2("\121\087\103\103\014")
	_nGGC.Active = false
	_nGGC.Visible = false
	_WIk9:RequestSync()
end
function _LHeUh:OnEnter()
	_4YMfE = _Qfj2("\121\096\099\007\126\010")
	_MZz4.Visible = false
	_MZz4.Active = false
	_RNIu5.Visible = false
	_RNIu5.Active = false
	_AqFN.Active = true
	_AqFN.Visible = true
	Wherigo.PlayAudio(_WCwgB)
	Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	_WIk9:RequestSync()
end
function _LHeUh:OnExit()
	_4YMfE = _Qfj2("\121\096\099\007\126\010")
	_bt1.Visible = false
	_abo.Visible = true
	_WIk9:RequestSync()
end
function _zg7Kf:OnEnter()
	_4YMfE = _Qfj2("\121\034\068\001\081\019")
	_9kl.Active = true
	_9kl.Visible = true
	_abo.Visible = false
	_5_r.Visible = true
	_5_r:MoveTo(Player)
	_RNIu5.Active = false
	_RNIu5.Visible = false
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\053\016\027\080\106\106\007\087\039\106\114\125\039\040\111\114\087\077\021\060\071\071\026\027\076\039\103\114\111\036\080\114\087\031\039\016\087\077\039\090\007\036\039\055\071\039\062\071\087\039\041\080\033\071\106\080\039\026\114\111\077\007\125\039\099\007\036\036\039\011\080\039\077\080\027\039\012\007\080\106\039\109\077\007\036\121\060\080\127\010\125\007\004\124\036\007\027\027\109\089\039\025\019\125\039\034\114\007\010\007\087\039\027\114\007\039\068\007\106\007\114\087\027\080\106\039\077\016\036\127\010\039\077\114\007\039\096\080\087\077\007\039\016\087\077\039\106\080\127\010\007\087\039\060\080\127\010\125\127\080\127\010\007\027\039\016\087\027\114\127\010\007\036\089\039\083\040\098\113\126\106\039\080\087\039\077\114\007\027\007\036\039\041\125\080\125\114\071\087\039\051\007\114\125\007\036\039\034\016\039\069\071\106\106\007\087\076\039\106\016\027\027\125\039\077\016\039\077\114\007\039\082\036\080\068\007\039\034\016\106\039\060\080\127\010\125\007\004\124\036\007\027\027\039\026\007\080\087\125\051\071\036\125\007\087\039\069\071\007\087\087\007\087\089"), 
			Media = _e98
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _zg7Kf:OnExit()
	_4YMfE = _Qfj2("\121\034\068\001\081\019")
	_5_r.Visible = false
	_abo.Visible = true
	_WIk9:RequestSync()
end
function _EiVA_:OnEnter()
	_4YMfE = _Qfj2("\121\095\114\097\067\121")
	_EiVA_.Visible = false
	_U2cu.Active = true
	_U2cu.Visible = true
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\090\080\039\051\114\036\039\033\080\039\087\114\127\010\125\039\087\016\036\039\041\124\080\027\027\039\010\080\026\007\087\039\069\071\007\087\087\007\087\076\039\106\071\007\127\010\125\007\087\039\051\114\036\039\007\016\127\010\039\080\087\039\077\114\007\027\007\036\039\041\125\007\111\111\007\039\080\016\019\039\077\080\027\039\095\127\071\039\050\019\080\077\039\041\127\010\114\111\077\039\080\016\019\106\007\036\069\027\080\106\039\106\080\127\010\007\087\089\039\090\007\087\087\039\103\007\071\127\080\127\010\007\087\039\010\007\114\027\027\125\039\080\016\127\010\039\109\041\114\127\010\039\051\007\114\125\007\036\039\026\114\111\077\007\087\109\089\083\040\098\113\083\040\098\113\058\007\087\087\039\077\016\039\077\114\127\010\039\080\016\027\036\007\114\127\010\007\087\077\039\068\007\026\114\111\077\007\125\039\010\080\027\125\076\039\069\080\087\087\039\007\027\039\077\007\087\039\058\007\068\039\051\007\114\125\007\036\039\068\007\010\007\087\039\089\089\089"), 
			Media = _1FNrt
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _EiVA_:OnExit()
	_4YMfE = _Qfj2("\121\095\114\097\067\121")
	_9zZDt.Active = true
	_9zZDt.Visible = false
	_WIk9:RequestSync()
end
function _9zZDt:OnEnter()
	_4YMfE = _Qfj2("\121\052\034\053\090\125")
	_U2cu.Active = false
	_U2cu.Visible = false
	_EiVA_.Visible = true
	_RNIu5.Active = false
	_RNIu5.Visible = false
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\058\114\036\039\010\071\019\019\007\087\039\077\016\039\010\080\027\125\039\077\114\127\010\039\068\016\125\039\080\016\019\039\077\007\106\039\041\127\010\114\111\077\039\114\087\019\071\036\106\114\007\036\125\089\039\067\111\111\007\027\039\058\114\127\010\125\114\068\007\039\077\071\069\016\106\007\087\125\114\007\036\125\039\016\087\077\039\080\036\127\010\114\062\114\007\036\125\076\039\016\087\077\039\069\080\087\087\027\125\039\007\114\087\007\039\082\036\080\068\007\039\077\080\034\016\039\026\007\080\087\125\051\071\036\125\007\087\089"), 
			Media = _EY9
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_sbn)
		end)
	end)
	_WIk9:RequestSync()
end
function _9zZDt:OnExit()
	_4YMfE = _Qfj2("\121\052\034\053\090\125")
	_WIk9:RequestSync()
end
function _U2cu:OnEnter()
	_4YMfE = _Qfj2("\121\126\049\127\016")
	_ru0s.Visible = true
	_iPQg.Visible = true
	_iPQg.Active = true
	_U2cu.Visible = false
	_abo.Visible = true
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\040\067\099\039\089\089\089\039\051\080\027\039\036\114\007\127\010\125\039\077\007\087\087\039\010\114\007\036\039\027\071\046\083\040\098\113\083\040\098\113\058\007\036\039\099\007\036\036\087\039\011\080\039\069\007\087\087\125\076\039\077\007\036\039\051\007\114\027\027\076\039\077\080\027\027\039\007\036\039\007\114\087\007\039\027\007\010\036\039\068\007\036\114\087\068\007\039\095\069\007\111\068\036\007\087\034\007\039\010\080\125\039\016\087\077\039\114\087\039\027\071\039\034\114\007\106\111\114\127\010\039\080\111\111\007\027\039\036\007\114\087\068\036\007\114\019\125\039\071\077\007\036\039\080\016\127\010\039\080\087\019\080\027\027\125\089\039\090\080\039\027\124\114\007\111\125\039\077\007\036\039\103\007\036\016\127\010\039\007\036\027\125\039\027\124\080\007\125\007\036\039\007\114\087\007\039\098\071\111\111\007\039\006\035\083\040\098\113\083\040\098\113\096\071\007\027\007\039\077\114\007\039\067\016\019\068\080\026\007\039\089\089\089")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_RNIu5.Active = false
	_RNIu5.Visible = false
	_WIk9:RequestSync()
end
function _U2cu:OnExit()
	_4YMfE = _Qfj2("\121\126\049\127\016")
	_abo.Visible = true
	_WIk9:RequestSync()
end
function _wroP8:OnEnter()
	_4YMfE = _Qfj2("\121\051\036\071\050\112")
	_RNIu5.Active = false
	_RNIu5.Visible = false
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_kGoNX)
	end)
	_WIk9:RequestSync()
end
function _wroP8:OnExit()
	_4YMfE = _Qfj2("\121\051\036\071\050\112")
	_WIk9:RequestSync()
end
function _qeXAn:OnEnter()
	_4YMfE = _Qfj2("\121\009\007\022\067\087")
	_qeXAn.Visible = false
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\090\080\039\068\007\010\125\039\007\027\039\111\080\087\068\076\039\007\114\087\019\080\127\010\039\077\007\087\039\058\114\087\125\007\036\111\114\007\125\010\021\058\007\068\039\010\071\127\010\068\007\010\007\087\039\089\089\089"), 
			Media = _ombe5
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _qeXAn:OnExit()
	_4YMfE = _Qfj2("\121\009\007\022\067\087")
	_qeXAn.Active = false
	_WIk9:RequestSync()
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\089\089\089\039\016\087\077\039\051\007\114\111\039\077\016\039\077\007\087\039\068\036\071\027\027\007\087\039\126\106\051\007\068\039\068\007\068\080\087\068\007\087\039\026\114\027\125\076\039\026\007\069\071\106\106\027\125\039\077\016\039\034\016\036\039\095\087\125\027\127\010\080\007\077\114\068\016\087\068\039\007\114\087\007\087\039\069\111\007\114\087\007\087\039\081\016\036\034\051\114\125\034\089\083\040\098\113\083\040\098\113\058\080\036\016\106\039\027\125\007\010\125\039\007\114\087\039\050\114\111\027\039\114\106\039\058\080\111\077\046\039\083\040\098\113\083\040\098\113\089\089\089\039\051\007\114\111\039\077\114\007\039\012\080\087\087\007\087\039\034\080\124\019\007\087\039\089\089\089\039\010\080\076\039\010\080\076\039\010\080"), 
			Media = _x9c
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _BXdrW:OnEnter()
	_4YMfE = _Qfj2("\121\040\022\077\036\058")
	_Rll.Active = false
	_Rll.Visible = false
	_Rll.Complete = true
	_wroP8.Active = false
	_wroP8.Visible = false
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\058\080\007\010\036\007\087\077\039\027\007\114\087\007\036\039\103\007\071\127\080\127\010\007\036\039\096\080\016\019\026\080\010\087\039\007\087\125\027\127\010\007\114\077\007\125\039\027\114\127\010\039\077\080\027\039\012\007\080\106\039\011\080\041\114\096\016\039\087\080\125\016\007\036\111\114\127\010\039\080\016\127\010\039\106\080\111\039\077\080\034\016\039\007\114\087\007\087\039\011\043\027\125\007\036\043\039\014\080\127\010\007\039\080\016\027\034\016\124\036\071\026\114\007\036\007\087\089\039\060\080\127\010\039\069\016\036\034\007\036\039\053\007\114\125\039\051\114\036\077\039\099\007\036\036\039\011\080\039\027\071\068\080\036\039\034\016\039\007\114\087\007\106\039\011\043\027\125\007\036\043\021\055\016\087\069\043\089\039\067\111\111\007\036\077\114\087\068\027\039\106\016\027\027\039\114\010\106\039\082\036\080\016\039\041\114\039\026\007\114\039\068\080\087\034\039\027\127\010\051\007\036\007\087\039\098\080\007\125\027\007\111\087\039\010\007\111\019\007\087\089\083\040\098\113\083\040\098\113\126\106\039\034\016\106\039\082\114\087\080\111\039\034\016\039\069\071\106\106\007\087\039\106\016\027\027\125\039\077\016\039\077\080\027\039\019\071\111\068\007\087\077\007\039\041\016\077\071\069\016\039\098\080\007\125\027\007\111\039\111\071\007\027\007\087\089\039\058\114\036\039\051\007\036\077\007\087\039\027\007\010\007\087\076\039\071\026\039\038\010\036\039\026\007\114\039\077\114\007\027\007\036\039\010\080\036\125\007\087\039\060\016\027\027\039\080\016\019\039\077\114\007\039\099\114\111\019\007\039\062\071\087\039\007\114\087\007\106\039\012\007\111\007\019\071\087\033\071\069\007\036\039\080\087\068\007\051\114\007\027\007\087\039\027\007\114\077\046\039\083\040\098\113\083\040\098\113\038\087\039\077\007\036\039\040\007\027\127\010\036\007\114\026\016\087\068\039\010\080\125\039\077\007\036\039\025\051\087\007\036\039\077\007\027\039\014\080\127\010\007\027\039\077\080\027\039\098\080\007\125\027\007\111\039\033\007\077\007\087\019\080\111\111\027\039\106\114\125\039\007\114\087\007\036\039\090\114\019\019\114\127\016\111\125\043\039\062\071\087\039\088\076\008\039\026\007\051\007\036\125\007\125\039\006\035"), 
			Media = _j0bC0
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_5oKA)
		end)
	end)
	_WIk9:RequestSync()
end
function _BXdrW:OnExit()
	_4YMfE = _Qfj2("\121\040\022\077\036\058")
	_abo.Visible = true
	_WIk9:RequestSync()
end
function _qhao:OnEnter()
	_4YMfE = _Qfj2("\121\009\010\080\071")
	_yTqfN.Active = false
	_yTqfN.Visible = false
	_yTqfN.Complete = true
	_Yvv.Active = true
	_Yvv.Visible = true
	_abo.Visible = false
	_HqSm.Visible = true
	_HqSm:MoveTo(Player)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\041\016\124\007\036\076\039\077\016\039\010\080\027\125\039\007\027\039\026\114\027\039\010\114\007\036\010\114\087\039\068\007\027\127\010\080\019\019\125\089\039\055\007\125\034\125\039\026\036\080\016\127\010\027\125\039\077\016\039\087\016\036\039\087\071\127\010\039\077\007\087\039\082\114\087\080\111\039\014\080\127\010\007\026\007\010\080\007\111\125\007\036\039\034\016\039\019\114\087\077\007\087\002\039")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _qhao:OnExit()
	_4YMfE = _Qfj2("\121\009\010\080\071")
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\082\071\111\068\007\039\007\114\087\019\080\127\010\039\077\007\106\039\058\007\068\039\016\106\039\051\114\007\077\007\036\039\034\016\106\039\014\080\127\010\007\021\025\021\011\071\026\114\111\039\034\016\039\069\071\106\106\007\087\089")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_Icfi.Active = true
	_Icfi.Visible = true
	_qhao.Visible = false
	_WIk9:RequestSync()
end
function _Icfi:OnEnter()
	_4YMfE = _Qfj2("\121\038\127\019\114")
	_qhao.Active = false
	_Icfi.Visible = false
	_Kar.Active = true
	_Kar.Visible = true
	_abo.Visible = false
	_JK1v.Visible = true
	_JK1v:MoveTo(Player)
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\060\114\127\010\125\039\027\071\039\027\127\010\087\007\111\111\039\089\089\089\039\010\114\007\036\039\069\071\007\087\087\125\007\027\125\039\077\016\039\087\071\127\010\039\007\114\087\007\087\039\040\071\087\016\027\039\014\080\127\010\007\039\080\106\039\058\007\068\007\027\036\080\087\077\039\106\114\125\087\007\010\106\007\087\089"), 
			Media = _EY9
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _Icfi:OnExit()
	_4YMfE = _Qfj2("\121\038\127\019\114")
	_JK1v.Visible = false
	_abo.Visible = true
	_AtKtv.Visible = false
	_AtKtv.Active = false
	_AtKtv.Complete = true
	_kHmEv.Active = true
	_kHmEv.Visible = true
	_WIk9:RequestSync()
end
function _Kar:OnEnter()
	_4YMfE = _Qfj2("\121\081\080\036")
	_Icfi.Active = false
	_Icfi.Visible = false
	_Kar.Visible = false
	_WjJO.Active = true
	_WjJO.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\082\071\111\068\007\039\077\007\106\039\058\007\068\039\007\114\087\019\080\127\010\039\068\007\036\080\077\007\039\080\016\027\089"), 
			Media = _ifhtq
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _Kar:OnExit()
	_4YMfE = _Qfj2("\121\081\080\036")
	_Kar.Active = false
	_WIk9:RequestSync()
end
function _fqJt:OnEnter()
	_4YMfE = _Qfj2("\121\019\009\055\125")
	_zg7Kf.Active = false
	_fqJt.Active = true
	_fqJt.Visible = true
	_Hda.Active = true
	_Hda.Visible = true
	_abo.Visible = false
	_Ydd6.Visible = true
	_Ydd6:MoveTo(Player)
	_RNIu5.Active = false
	_RNIu5.Visible = false
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\090\080\027\039\012\007\080\106\039\011\080\041\114\096\016\039\069\080\087\087\039\106\080\087\039\071\010\087\007\039\036\071\125\039\034\016\039\051\007\036\077\007\087\039\080\111\027\039\050\071\051\007\036\039\014\080\127\010\007\036\039\026\007\034\007\114\127\010\007\087\089\039\083\040\098\113\083\040\098\113\081\007\114\087\039\058\007\068\039\114\027\125\039\034\016\039\051\007\114\125\076\039\069\007\114\087\039\040\007\036\068\039\114\027\125\039\034\016\039\027\125\007\114\111\089\039\083\040\098\113\083\040\098\113\038\106\039\055\080\010\036\039\049\123\031\031\039\010\080\026\007\087\039\027\114\007\039\007\027\039\080\016\019\039\016\087\068\111\080\016\026\111\114\127\010\007\039\049\089\112\123\123\039\082\016\087\077\007\039\068\007\026\036\080\127\010\125\089\039\067\111\111\007\036\077\114\087\068\027\039\068\114\026\125\039\007\027\039\080\016\127\010\039\007\114\087\007\087\039\011\071\087\080\125\039\106\114\125\039\007\114\087\007\106\039\069\111\007\114\087\007\087\039\109\011\080\069\007\111\109\039\080\016\019\039\114\010\036\007\036\039\058\007\027\125\007\089\039\041\114\007\039\010\080\026\007\087\039\019\016\007\036\039\114\010\036\007\039\041\125\080\125\114\027\125\114\069\039\087\071\127\010\039\087\114\127\010\125\039\007\114\087\106\080\111\039\007\114\087\007\087\039\077\036\007\114\027\125\007\111\111\114\068\007\087\039\058\007\036\125\039\080\087\039\090\071\027\007\087\039\019\114\087\077\007\087\039\069\071\007\087\087\007\087\039\016\087\077\039\010\080\026\007\087\039\077\114\007\027\007\087\039\011\071\087\080\125\039\106\114\125\039\051\007\087\114\068\007\036\039\080\111\027\039\010\016\087\077\007\036\125\039\090\071\027\007\087\039\080\026\068\007\027\127\010\111\071\027\027\007\087\089\039\083\040\098\113\083\040\098\113\025\026\039\027\114\007\039\027\114\127\010\039\077\080\019\016\007\036\039\027\127\010\080\007\106\007\087\039\106\016\007\027\027\007\087\046\039\058\114\036\039\068\111\080\016\026\007\087\039\087\114\127\010\125\076\039\080\026\007\036\039\114\010\036\039\106\016\007\027\027\125\039\033\007\125\034\125\039\077\114\007\039\077\080\034\016\039\124\080\027\027\007\087\077\007\039\053\080\010\111\039\010\114\007\036\039\062\071\036\039\025\036\125\039\019\114\087\077\007\087\089")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _fqJt:OnExit()
	_4YMfE = _Qfj2("\121\019\009\055\125")
	_Ydd6.Visible = false
	_abo.Visible = true
	_WIk9:RequestSync()
end
function _kHmEv:OnEnter()
	_4YMfE = _Qfj2("\121\069\099\106\095\062")
	_WjJO.Active = false
	_kHmEv.Visible = false
	_RNIu5.Active = false
	_RNIu5.Visible = false
	Wherigo.PlayAudio(_flfH)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\099\007\036\034\111\114\127\010\007\087\039\103\111\016\007\127\069\051\016\087\027\127\010\002\039\090\016\039\010\080\027\125\039\077\114\007\039\098\016\087\077\007\039\068\007\027\127\010\080\019\019\125\089\083\040\098\113\083\040\098\113\090\114\007\039\041\080\055\071\011\080\027\039\016\087\077\039\077\080\027\039\012\007\080\106\039\012\080\087\125\007\039\012\114\111\111\043\039\010\071\019\019\007\087\076\039\077\080\027\027\039\114\010\036\039\041\124\080\027\027\039\010\080\125\125\007\125\039\016\087\077\039\007\016\127\010\039\077\114\007\039\055\016\026\114\111\080\007\016\106\027\021\098\016\087\077\007\039\068\007\019\080\111\111\007\087\039\010\080\125\089\083\040\098\113\083\040\098\113\038\010\036\039\010\080\026\125\039\010\071\019\019\007\087\125\111\114\127\010\039\016\087\125\007\036\051\007\068\027\039\068\007\087\016\068\039\068\007\125\036\016\087\069\007\087\039\016\087\077\039\087\114\127\010\125\039\087\016\036\039\077\114\007\039\058\080\027\027\007\036\019\111\080\027\127\010\007\039\036\016\106\068\007\125\036\080\068\007\087\089\083\040\098\113\083\040\098\113\081\071\106\106\125\039\068\016\125\039\087\080\127\010\039\099\080\016\027\007\039\089\089\089")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _kHmEv:OnExit()
	_4YMfE = _Qfj2("\121\069\099\106\095\062")
	_kHmEv.Active = false
	Wherigo.Command "SaveClose"
end
function _GVR:OnEnter()
	_4YMfE = _Qfj2("\121\103\097\098")
	_Rpn9.Active = true
	_Rpn9.Visible = true
	_s8d.Active = true
	_s8d.Visible = true
	_GVR.Visible = false
	_tqC.Visible = false
	_tqC.Active = false
	_tqC.Complete = true
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\095\114\087\007\039\016\106\019\080\087\068\036\007\114\127\010\007\039\095\036\069\111\080\007\036\016\087\068\039\027\124\080\036\007\087\039\051\114\036\039\016\087\027\002\083\040\098\113\083\040\098\113\099\025\096\039\090\038\098\039\095\060\090\096\038\014\099\039\090\095\060\039\082\012\082\039\002\002\002")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _GVR:OnExit()
	_4YMfE = _Qfj2("\121\103\097\098")
	_ICyin:Start()
	_WIk9:RequestSync()
end
function _Rpn9:OnEnter()
	_4YMfE = _Qfj2("\121\098\124\087\052")
	_ICyin:Stop()
	_WIk9:RequestSync()
end
function _Rpn9:OnExit()
	_4YMfE = _Qfj2("\121\098\124\087\052")
	_WIk9:RequestSync()
end
function _WmZi:OnEnter()
	_4YMfE = _Qfj2("\121\058\106\053\114")
	_RNIu5.Active = false
	_RNIu5.Visible = false
	_MaUa:MoveTo(Player)
	_dBmN.Active = true
	_dBmN.Visible = true
	_abo.Visible = false
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\012\114\007\036\007\039\089\089\089\039\027\114\007\039\111\007\026\007\087\039\071\019\125\039\114\106\039\058\080\111\077\089\083\040\098\113\058\007\087\087\039\106\080\087\039\080\111\111\007\114\087\039\114\106\039\058\080\111\077\039\114\027\125\076\039\077\080\087\087\039\069\080\087\087\039\007\027\039\124\080\027\027\114\007\036\007\087\076\039\077\080\027\027\039\106\080\087\039\051\007\111\127\010\007\039\125\036\114\019\019\125\089\039\083\040\098\113\090\080\027\039\012\007\080\106\039\011\080\041\114\096\016\039\010\080\125\039\114\106\106\007\036\039\041\124\080\027\027\039\077\080\036\080\087\076\039\051\007\087\087\039\027\114\007\039\026\007\027\071\087\077\007\036\007\039\012\114\007\036\007\039\027\007\010\007\087\089\039\090\080\039\051\114\036\077\039\027\127\010\071\087\039\106\080\111\039\026\007\114\039\007\114\087\007\106\039\069\111\007\114\087\007\087\039\081\036\080\026\026\007\111\069\080\007\019\007\036\039\007\114\087\007\039\122\087\026\027\124\006\111\007\026\007\087\027\124\007\087\077\007\087\077\007\039\011\016\087\077\039\034\016\039\011\016\087\077\039\040\007\080\125\016\106\068\039\016\007\026\007\036\039\049\039\041\125\016\087\077\007\087\039\077\016\036\127\010\068\007\019\016\007\010\036\125\076\039\077\080\106\114\125\039\007\036\039\080\016\127\010\039\077\007\087\039\098\007\027\125\039\027\007\114\087\007\027\039\058\007\068\007\027\039\027\127\010\080\019\019\125\089\039\083\040\098\113\040\111\114\087\077\027\127\010\111\007\114\127\010\007\087\039\051\007\036\077\007\087\039\109\027\125\071\111\034\039\051\114\007\039\040\071\111\111\007\109\039\077\007\087\039\080\087\077\007\036\007\087\039\103\007\071\127\080\127\010\007\036\087\039\068\007\034\007\114\068\125\076\039\080\016\127\010\039\051\007\087\087\039\077\114\007\027\007\039\087\114\127\010\125\039\027\071\039\007\114\087\007\087\039\109\053\016\068\080\087\068\109\039\034\016\039\012\114\007\036\007\087\039\010\080\026\007\087\089\039\058\007\111\127\010\007\027\039\012\114\007\036\039\051\007\036\077\007\087\039\077\114\007\039\011\080\041\114\096\016\027\039\051\071\010\111\039\080\087\039\077\114\007\027\007\036\039\041\125\080\125\114\071\087\039\019\114\087\077\007\087\046"), 
			Media = _0OOoO
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _WmZi:OnExit()
	_4YMfE = _Qfj2("\121\058\106\053\114")
	_WIk9:RequestSync()
end
function _QN3Yc:OnEnter()
	_4YMfE = _Qfj2("\121\059\060\088\070\127")
	_RNIu5.Active = false
	_RNIu5.Visible = false
	_BXdrW.Active = false
	_BXdrW.Visible = false
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\103\014\088\052\049\081\059\039\021\039\081\087\016\007\111\111\013\007\036\035\021\014\080\127\010\007\039\118\031\079\083\040\098\113\083\040\098\113\040\080\111\077\039\114\027\125\039\007\027\039\027\071\051\007\114\125\089\039\090\114\007\039\011\080\041\114\096\016\027\039\026\036\080\016\127\010\007\087\039\087\016\036\039\087\071\127\010\039\022\022\022\039\013\007\114\087\007\039\026\007\027\125\114\106\106\125\007\039\067\087\034\080\010\111\035\039\103\007\071\127\080\127\010\007\027\076\039\077\080\087\087\039\010\080\026\007\087\039\027\114\007\039\114\010\036\007\087\039\008\123\123\123\039\014\080\127\010\007\039\011\007\114\111\007\087\027\125\007\114\087\039\068\007\027\127\010\080\019\019\125\089\039\058\007\114\111\039\114\010\036\039\033\007\125\034\125\039\080\016\127\010\039\069\016\036\034\039\062\071\036\039\077\007\106\039\053\114\007\111\039\027\125\007\010\125\039\106\016\007\027\027\125\039\114\010\036\039\077\114\007\027\007\039\053\080\010\111\039\019\114\087\077\007\087\089\083\040\098\113\103\016\125\076\039\087\114\127\010\125\039\033\007\077\007\036\039\010\080\125\039\051\114\007\039\077\114\007\039\011\080\041\114\096\016\027\039\106\071\026\114\111\007\027\039\038\087\125\007\036\087\007\125\039\077\080\026\007\114\076\039\077\007\027\051\007\068\007\087\039\069\071\007\087\087\125\039\114\010\036\039\077\114\007\039\026\007\087\071\007\125\114\068\125\007\039\053\080\010\111\039\080\016\127\010\039\062\071\087\039\077\007\036\039\069\111\007\114\087\027\125\007\087\039\041\007\114\125\007\039\077\007\027\039\103\036\007\087\034\027\125\007\114\087\007\027\039\062\071\036\039\007\016\127\010\039\109\080\026\027\124\114\127\069\007\087\109\089\039"), 
			Media = _N31
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_ZLE)
		end)
	end)
	_WIk9:RequestSync()
end
function _QN3Yc:OnExit()
	_4YMfE = _Qfj2("\121\059\060\088\070\127")
	_WIk9:RequestSync()
end
function _WjJO:OnEnter()
	_4YMfE = _Qfj2("\121\058\033\055\025")
	_kHmEv.Active = true
	_kHmEv.Visible = true
	_abo.Visible = false
	_J05:MoveTo(Player)
	_J05.Visible = true
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\099\114\007\036\039\068\114\026\125\039\007\027\039\087\071\127\010\039\007\114\087\007\087\039\040\071\087\016\027\021\040\071\087\016\027\039\014\080\127\010\007\039\068\007\068\007\087\039\096\080\087\068\007\051\007\114\111\007\039\080\016\019\039\077\007\106\039\098\016\127\069\051\007\068\039\034\016\106\039\014\080\127\010\007\021\025\021\011\071\026\114\111\089"), 
			Media = _EY9
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_WIk9:RequestSync()
end
function _WjJO:OnExit()
	_4YMfE = _Qfj2("\121\058\033\055\025")
	_WIk9:RequestSync()
end
function _Wmc6B:OnSetComplete()
	_bSQ4.Visible = true
	_2vQBm.Active = false
	_2vQBm.Visible = false
	_nGGC.Active = true
	_nGGC.Visible = true
end
function _MUy0A:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\099\067\096\096\025\046\039\089\089\089\039\077\114\007\039\011\007\125\007\036\039\067\087\068\080\026\007\039\069\080\087\087\039\087\016\036\039\007\114\087\007\039\053\080\010\111\039\027\007\114\087\002"), 
				Media = _O_d
			}
		}, function(action)
			_WIk9:RequestSync()
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		return
	end
	if input == 270 then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_rjy1m)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\090\080\087\087\039\010\080\027\125\039\077\016\039\077\114\007\039\095\036\069\111\080\007\036\016\087\068\039\062\071\087\039\040\111\114\087\077\021\060\071\071\026\027\039\051\071\010\111\039\077\071\127\010\039\087\071\127\010\039\087\114\127\010\125\039\062\007\036\027\125\080\087\077\007\087\089\039\097\007\036\027\016\127\010\039\007\027\039\087\071\127\010\039\106\080\111\002"), 
				Media = _O_d
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		_WIk9:RequestSync()
	end
end
function _rjy1m:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\099\067\096\096\025\039\089\089\089\039\077\114\007\039\103\036\080\077\039\067\087\068\080\026\007\039\114\027\125\039\007\114\087\007\039\053\080\010\111\002"), 
				Media = _O_d
			}
		}, function(action)
			_WIk9:RequestSync()
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		return
	end
	if input == 16 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\041\126\050\095\098\039\089\089\089\039\077\080\087\087\039\069\080\087\087\039\007\027\039\033\080\039\034\016\106\039\011\016\111\125\114\021\082\114\087\080\111\039\068\007\010\007\087\002\039\103\007\010\007\039\077\007\087\039\058\007\068\039\007\114\087\019\080\127\010\039\051\007\114\125\007\036\039\098\114\127\010\125\016\087\068\039\060\071\036\077\007\087\089"), 
				Media = _jYZo
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		_JXU.Active = true
		_JXU.Visible = true
		_iLwN.Active = true
		_iLwN.Visible = true
		_T8fa.Active = false
		_T8fa.Visible = false
		__AE.Visible = false
		_abo.Visible = true
		_4Hwl.Visible = false
		_4Hwl.Active = false
		_nGGC.Active = false
		_nGGC.Visible = false
		_RNIu5.Active = true
		_RNIu5.Visible = true
		_WIk9:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\096\007\114\077\007\036\039\019\080\111\027\127\010\076\039\062\007\036\027\016\127\010\039\007\027\039\077\071\127\010\039\087\071\127\010\039\106\080\111\089\083\040\098\113\058\114\007\039\069\071\106\106\027\125\039\077\016\039\077\007\087\087\039\077\080\039\077\036\080\016\019\046\039\099\080\027\125\039\026\007\114\106\039\050\007\114\111\007\087\039\051\071\010\111\039\087\114\127\010\125\039\080\016\019\068\007\124\080\027\027\125\002"), 
				Media = _O_d
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		_WIk9:RequestSync()
	end
end
function _5YgLk:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 56752 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\103\007\010\039\077\007\087\039\058\007\068\039\051\007\114\125\007\036\039\034\016\036\039\087\080\007\127\010\027\125\007\087\039\014\080\127\010\007\080\016\019\068\080\026\007\089"), 
				Media = _d2a
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		_HZ5.Active = false
		_HZ5.Visible = false
		_JXU.Visible = false
		_2HX.Active = true
		_2HX.Visible = true
		_WIk9:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\058\114\036\039\077\080\127\010\007\087\039\007\010\007\036\039\080\087\039\077\007\087\039\060\080\106\007\087\039\077\007\036\039\055\016\026\114\111\080\036\007\039\077\114\007\027\007\027\039\014\080\127\010\007\027\039\089\089\089\039\062\007\036\027\016\127\010\039\007\027\039\087\071\127\010\039\106\080\111\089"), 
				Media = _O_d
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_5YgLk)
			end)
			_WIk9:RequestSync()
		end)
	end
end
function _o8AGq:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\090\016\039\069\007\087\087\027\125\039\077\114\007\039\040\007\077\007\016\125\016\087\068\039\034\051\114\027\127\010\007\087\039\058\071\007\036\125\007\036\087\039\016\087\077\039\053\080\010\111\007\087\039\046\046\046\039\083\040\098\113\083\040\098\113\025\077\007\036\039\010\080\027\125\039\077\016\039\077\114\007\039\067\016\019\068\080\026\007\039\068\080\036\039\087\114\127\010\125\039\068\007\111\071\007\027\125\039\016\087\077\039\019\114\027\127\010\125\039\114\106\039\012\036\016\007\026\007\087\046\039\097\007\036\027\016\127\010\039\007\027\039\087\071\127\010\039\007\114\087\106\080\111\039\089\089\089"), 
				Media = _O_d
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		return
	end
	if input == 47 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\090\007\087\039\011\007\125\080\111\111\027\124\111\114\087\125\039\026\036\080\016\127\010\007\039\114\127\010\039\087\114\127\010\125\039\106\007\010\036\039\016\087\077\039\124\080\127\069\007\039\114\010\087\039\114\087\039\077\007\087\039\012\007\080\106\039\098\016\127\069\027\080\127\069\089\083\040\098\113\058\007\114\125\007\036\039\068\007\010\125\039\007\027\076\039\077\007\087\039\058\007\068\039\007\087\125\111\080\087\068\076\039\051\114\036\039\010\080\026\007\087\039\087\071\127\010\039\007\114\087\039\041\125\016\007\127\069\039\062\071\036\039\016\087\027\039\089\089\089\039\010\071\124\124\076\039\010\071\124\124\039\089\089\089"), 
				Media = _G76e
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		_zg7Kf.Active = true
		_zg7Kf.Visible = true
		_1npYZ.Active = false
		_1npYZ.Visible = true
		_1npYZ.Complete = true
		_LHeUh.Active = false
		_LHeUh.Visible = false
		_bt1.Visible = false
		_abo.Visible = true
		_RNIu5.Active = true
		_RNIu5.Visible = true
		_IkhN4.Visible = false
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\090\016\039\010\080\027\125\039\077\114\007\027\007\039\069\087\114\019\019\007\111\114\068\007\039\067\016\019\068\080\026\007\039\051\071\010\111\039\077\071\127\010\039\087\114\127\010\125\039\036\114\127\010\125\114\068\039\068\007\111\071\007\027\125\089\083\040\098\113\097\007\036\027\016\127\010\039\007\027\039\087\071\127\010\039\007\114\087\106\080\111\089"), 
				Media = _O_d
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
	end
end
function _sbn:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 14595 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\103\016\125\039\068\007\106\080\127\010\125\002\039\055\007\125\034\125\039\051\007\114\027\027\125\039\077\016\039\080\016\127\010\039\051\080\036\016\106\039\077\071\069\016\106\007\087\125\114\007\036\007\087\039\016\087\077\039\080\036\127\010\114\062\114\007\036\007\087\039\027\071\039\051\114\127\010\125\114\068\039\114\027\125\089\039\090\114\007\039\081\080\106\007\036\080\039\016\087\077\039\080\111\111\007\027\039\051\080\027\039\077\080\034\016\039\068\007\010\071\007\036\125\039\124\080\127\069\007\039\114\127\010\039\033\007\125\034\125\039\114\087\039\077\007\087\039\012\007\080\106\039\098\016\127\069\027\080\127\069\089"), 
				Media = _G76e
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		_tGnDZ.Visible = false
		_tGnDZ.Active = false
		_tGnDZ.Complete = true
		_U2cu.Active = true
		_U2cu.Visible = true
		_EiVA_.Active = false
		_EiVA_.Visible = false
		_9zZDt.Active = false
		_9zZDt.Visible = false
		_RNIu5.Active = true
		_RNIu5.Visible = true
		_UWjoe.Visible = false
		_EJSdl.Visible = false
		_WIk9:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\090\080\039\106\016\027\027\125\039\077\016\039\051\071\010\111\039\034\016\036\016\007\127\069\068\007\010\007\087\076\039\087\080\127\010\027\127\010\080\016\007\087\039\016\087\077\039\087\071\127\010\106\080\111\039\010\114\007\036\010\007\036\039\034\016\036\016\007\127\069\039\069\071\106\106\007\087\089")
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		_9zZDt.Active = false
		_9zZDt.Visible = false
	end
end
function _5oKA:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\095\038\060\095\039\053\067\099\096\039\089\089\089\039\007\114\087\007\039\053\080\010\111\039\089\089\089\089\039\053\080\010\111\076\039\053\080\010\111\076\039\053\080\010\111\039\002\002\002"), 
				Media = _O_d
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_5oKA)
			end)
		end)
		return
	end
	if input == 8 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = "", 
				Media = _G76e
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		_WIk9:RequestSync()
		_BXdrW.Visible = false
		_QN3Yc.Active = true
		_QN3Yc.Visible = true
		_RNIu5.Active = true
		_RNIu5.Visible = true
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\025\099\039\011\095\038\060\039\103\025\012\012\039\089\089\089\039\027\071\039\027\127\010\051\007\036\039\114\027\125\039\077\080\027\039\077\071\127\010\039\087\114\127\010\125\089\039\058\114\111\111\027\125\039\077\016\039\051\114\036\069\111\114\127\010\039\051\007\114\125\007\036\039\106\080\127\010\007\087\046"), 
				Media = _O_d
			}
		}, function(action)
			_WIk9:RequestSync()
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_5oKA)
			end)
		end)
	end
end
function _kGoNX:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 13166 then
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\103\016\125\076\039\077\080\087\087\039\068\007\010\007\087\039\051\114\036\039\007\114\087\007\087\039\069\111\007\114\087\007\087\039\126\106\051\007\068\089\039\082\071\111\068\007\039\077\007\106\039\041\127\010\071\125\125\007\036\051\007\068\039\051\007\114\125\007\036\039\068\007\036\080\077\007\080\016\027\089")
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		_qeXAn.Active = true
		_qeXAn.Visible = true
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\103\007\010\007\039\077\007\087\039\058\007\068\039\111\114\087\069\027\039\051\007\114\125\007\036\089"), 
				Media = _l1Lb3
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
	end
	_Rll.Active = true
	_Rll.Visible = true
	_wroP8.Active = false
	_wroP8.Visible = false
	_BXdrW.Active = true
	_BXdrW.Visible = true
end
function _ahZc:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\038\127\010\039\077\080\127\010\125\007\039\080\087\039\007\114\087\007\039\053\080\010\111\039\077\007\036\039\082\016\087\077\007\039\089\089\089\039\069\007\114\087\039\058\071\036\125\089"), 
				Media = _O_d
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		return
	end
	if input == 8 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = "", 
				Media = _d2a
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		_zg7Kf.Visible = false
		_9kl.Visible = false
		_9kl.Active = false
		_9kl.Complete = true
		_fqJt.Active = true
		_fqJt.Visible = true
		_abo.Visible = true
		_5_r.Visible = false
		_RNIu5.Active = true
		_RNIu5.Visible = true
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\097\007\036\027\016\127\010\039\007\027\039\077\071\127\010\039\007\114\087\019\080\127\010\039\087\071\127\010\106\080\111\039\106\114\125\039\027\016\127\010\007\087\039\027\125\080\125\125\039\034\016\039\036\080\125\007\087\089"), 
				Media = _O_d
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
	end
end
function _Q28:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\058\114\036\039\027\114\087\077\039\080\016\019\039\077\007\036\039\041\016\127\010\007\039\087\080\127\010\039\007\114\087\007\106\039\058\007\036\125\089"), 
				Media = _O_d
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		return
	end
	if input == 11 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\090\007\087\087\039\114\106\039\060\071\062\007\106\007\036\039\013\011\071\087\080\125\039\120\039\031\031\035\039\049\123\031\031\039\027\114\087\077\039\027\114\007\039\106\114\125\039\109\087\016\036\109\039\052\112\039\082\016\087\077\007\087\039\087\080\127\010\039\099\080\016\027\007\039\068\007\068\080\087\068\007\087\089\039\012\027\007\076\039\125\027\007\076\039\125\027\007\039\089\089\089\039\099\007\036\036\039\011\080\093\039\058\114\007\039\069\071\087\087\125\007\039\077\007\087\087\039\027\071\039\007\125\051\080\027\039\124\080\027\027\114\007\036\007\087\046"), 
				Media = _jYZo
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		_fqJt.Active = false
		_fqJt.Visible = false
		_Hda.Active = false
		_Hda.Visible = false
		_Hda.Complete = true
		_abo.Visible = true
		_Ydd6.Visible = false
		_EiVA_.Visible = true
		_EiVA_.Active = true
		_RNIu5.Visible = true
		_RNIu5.Active = true
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\038\127\010\039\068\111\080\016\026\007\039\077\016\039\010\080\027\125\039\087\114\127\010\125\039\077\080\027\039\098\114\127\010\125\114\068\007\039\068\007\019\016\087\077\007\087\089\039\097\007\036\027\016\127\010\039\007\027\039\087\071\127\010\039\106\080\111\089"), 
				Media = _O_d
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
	end
end
function _1d1qD:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 40987 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\058\114\007\039\068\016\125\076\039\077\080\027\027\039\077\007\036\039\012\007\080\106\039\098\016\127\069\027\080\127\069\039\027\071\071\071\039\068\036\071\027\027\039\114\027\125\076\039\077\080\039\069\071\106\106\125\039\033\007\125\034\125\039\080\016\127\010\039\077\114\007\039\096\007\114\125\007\036\039\036\007\114\087\039\006\035"), 
				Media = _d2a
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		_iPQg.Active = false
		_iPQg.Visible = false
		_iPQg.Complete = true
		_U2cu.Active = false
		_U2cu.Visible = false
		_WmZi.Active = true
		_WmZi.Visible = true
		_RNIu5.Active = true
		_RNIu5.Visible = true
		_eYw.Visible = false
		_WIk9:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\090\114\007\039\067\087\125\051\071\036\125\039\114\027\125\039\111\007\114\077\007\036\039\087\114\127\010\125\039\036\114\127\010\125\114\068\002"), 
				Media = _O_d
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
	end
end
function _Dcm:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 13166 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\041\016\124\007\036\039\089\089\089\039\125\071\111\111\039\068\007\106\080\127\010\125\089"), 
				Media = _8SEU
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		_qhao.Visible = false
		_Icfi.Active = true
		_Icfi.Visible = true
		_Yvv.Active = false
		_Yvv.Visible = false
		_Yvv.Complete = true
		_AtKtv.Active = true
		_AtKtv.Visible = true
		_HqSm.Visible = false
		_abo.Visible = true
		_KvaM:MoveTo(Player)
		_xD0tC:MoveTo(Player)
		_WIk9:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\090\080\087\087\039\027\016\127\010\039\068\007\019\080\007\111\111\114\068\027\125\039\051\007\114\125\007\036\002\039\025\077\007\036\039\051\114\111\111\027\125\039\077\016\039\007\125\051\080\039\027\071\039\069\016\036\034\039\062\071\036\039\077\007\106\039\053\114\007\111\039\080\016\019\068\007\026\007\087\046"), 
				Media = _CB08
			}
		}, function(action)
			_WIk9:RequestSync()
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	end
end
function _1lF:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 13166 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\041\016\124\007\036\076\039\077\080\087\087\039\069\080\087\087\039\007\027\039\033\080\039\080\016\019\039\077\007\106\039\041\127\010\071\125\125\007\036\051\007\068\039\051\007\114\125\007\036\039\068\007\010\007\087\089"), 
				Media = _KP_
			}
		}, function(action)
			_WIk9:RequestSync()
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		_Icfi.Active = false
		_AtKtv.Active = false
		_AtKtv.Visible = false
		_AtKtv.Complete = true
		_kfC.Active = true
		_kfC.Visible = true
		_RNIu5.Active = true
		_RNIu5.Visible = true
		_JK1v.Visible = false
		_abo.Visible = true
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\090\080\087\087\039\027\016\127\010\039\068\007\019\080\007\111\111\114\068\027\125\039\051\007\114\125\007\036\002\039\025\077\007\036\039\051\114\111\111\027\125\039\077\016\039\080\016\019\068\007\026\007\087\046"), 
				Media = _CB08
			}
		}, function(action)
			_WIk9:RequestSync()
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	end
end
function _pjpX9:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 26294 then
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\025\081\076\039\077\080\087\087\039\026\007\069\071\106\106\027\125\039\077\016\039\033\007\125\034\125\039\007\114\087\007\039\087\007\016\007\039\014\010\080\087\127\007\039\016\087\077\039\088\123\039\041\007\069\016\087\077\007\087\039\106\007\010\036\039\016\106\039\077\114\007\039\041\125\036\007\127\069\007\039\034\016\039\027\127\010\080\019\019\007\087\089")
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		_HI6.Active = false
		_HI6.Visible = false
		_HSO.Active = false
		_HSO.Visible = false
		_GVR.Active = true
		_s8d.Active = false
		_s8d.Visible = false
		_tqC.Active = true
		_tqC.Visible = true
		_WIk9:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\058\025\058\039\007\114\087\039\007\010\036\068\007\114\034\114\068\007\036\039\041\124\036\114\087\125\007\036\076\039\077\016\039\010\080\027\125\039\068\080\087\034\039\027\127\010\071\007\087\039\011\016\125\089\083\040\098\113\083\040\098\113\096\071\027\039\068\007\010\125\039\007\027\039\089\089\089\039\080\016\019\039\007\114\087\039\060\007\016\007\027\039\089\089\089\039\026\007\068\114\026\039\077\114\127\010\039\034\016\036\016\007\127\069\039\034\016\036\039\041\125\080\036\125\039\053\071\087\007")
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		_HI6.Active = true
		_HI6.Visible = true
		_HSO.Active = false
		_HSO.Visible = false
		_s8d.Active = true
		_s8d.Visible = true
		_WIk9:RequestSync()
	end
end
function _r30yE:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 20963 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = "", 
				Media = _jYZo
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		_WmZi.Visible = false
		_WmZi.Active = false
		_dBmN.Active = false
		_dBmN.Visible = false
		_dBmN.Complete = true
		_MaUa.Visible = false
		_abo.Visible = true
		_wroP8.Active = true
		_wroP8.Visible = true
		_RNIu5.Active = true
		_RNIu5.Visible = true
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\099\106\106\106\106\106\039\089\089\089\089\039\060\095\038\060\039\002\002\002"), 
				Media = _O_d
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
	end
end
function _ZLE:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\067\010\106\106\106\106\039\089\089\089\039\051\114\036\039\027\124\036\080\127\010\007\087\039\062\071\087\039\007\114\087\007\036\039\053\080\010\111\089"), 
				Media = _O_d
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_ZLE)
			end)
			_WIk9:RequestSync()
		end)
		return
	end
	if input == 758 then
		Wherigo.PlayAudio(_flfH)
		_Urwigo.Dialog(false, {
			{
				Text = "", 
				Media = _d2a
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_WIk9:RequestSync()
		end)
		_QN3Yc.Visible = false
		_QN3Yc.Active = false
		_qhao.Active = true
		_qhao.Visible = true
		_yTqfN.Active = true
		_yTqfN.Visible = true
		_WIk9:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\089\089\089\039\062\071\087\039\077\007\036\039\069\111\007\114\087\027\125\007\087\039\041\007\114\125\007\039\089\089\089\039\062\071\087\039\077\007\036\039\069\111\007\114\087\027\125\007\087\039\041\007\114\125\007\039\002\002\002"), 
				Media = _O_d
			}
		}, function(action)
			_WIk9:RequestSync()
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_ZLE)
			end)
		end)
	end
end
function _yCe:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 13166 then
		_Urwigo.Dialog(false, {
			{
				Text = "", 
				Media = _KP_
			}
		}, function(action)
			_WIk9:RequestSync()
			_J05.Visible = false
			_abo.Visible = true
			_WjJO.Visible = false
			_WjJO.Active = false
			_kfC.Active = false
			_kfC.Visible = false
			_kfC.Complete = true
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _Qfj2("\058\095\038\012\095\098\041\126\014\099\095\060\039\089\089\089"), 
				Media = _CB08
			}
		}, function(action)
			_WIk9:RequestSync()
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	end
end
function _aiRf:OnStart()
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.OldDialog{
		{
			Text = _Qfj2("\090\007\036\039\014\071\016\087\125\077\071\051\087\039\111\080\007\016\019\125\039\089\089\089\083\040\098\113\083\040\098\113\011\067\014\099\039\099\038\060\039\089\089\089\039\082\012\082\039\026\007\077\007\016\125\007\125\039\081\098\038\095\103\039\002\002\002")
		}
	}
end
function _aiRf:OnStop()
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\103\111\016\007\127\069\051\016\087\027\127\010\076\039\077\016\039\051\080\036\027\125\039\077\007\036\039\095\036\027\125\007\039\080\087\039\077\114\007\027\007\106\039\014\080\127\010\007\089\039\060\080\127\010\039\077\114\007\027\007\106\039\041\124\016\036\125\039\010\080\027\125\039\077\016\039\077\114\036\039\077\007\087\039\095\114\087\125\036\080\068\039\114\087\039\007\114\087\039\026\111\016\007\125\007\087\051\007\114\027\027\007\027\039\096\071\068\026\016\127\010\039\068\007\027\114\127\010\007\036\125\089\083\040\098\113\055\007\125\034\125\039\007\036\027\125\039\007\114\087\106\080\111\039\069\016\036\034\039\077\016\036\127\010\080\125\106\007\087\039\016\087\077\039\051\007\114\125\007\036\039\068\007\010\125\039\007\027\039\068\007\036\080\077\007\080\016\027\089\039\038\106\106\007\036\039\077\007\036\039\060\080\027\007\039\087\080\127\010\039\089\089\089"), 
			Media = _DhtJH
		}
	}, function(action)
		Wherigo.PlayAudio(_flfH)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_MZz4.Active = true
	_MZz4.Visible = true
	_HI6.Active = false
	_HI6.Visible = false
	_HSO.Visible = false
	_s8d.Active = false
	_s8d.Visible = false
	_s8d.Complete = true
	_RNIu5.Active = true
	_RNIu5.Visible = true
end
function _aiRf:OnTick()
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\096\007\114\077\007\036\039\034\016\039\111\080\087\068\027\080\106\039\089\089\089\039\077\080\039\051\080\036\039\051\071\010\111\039\027\127\010\071\087\039\051\114\007\077\007\036\039\007\114\087\039\027\125\080\077\125\026\007\069\080\087\087\125\007\036\039\082\012\082\021\055\080\007\068\007\036\039\027\127\010\087\007\111\111\007\036\039\089\089\089\089\039\103\098\098\098\098\098\036\036\036\036\036\036\036\036\036\083\040\098\113\083\040\098\113\090\080\027\039\010\007\114\027\027\125\039\019\016\036\039\077\114\127\010\093\039\060\025\014\099\011\067\096\039\098\095\060\060\095\060\002"), 
			Media = _JgW
		}
	}, function(action)
		Wherigo.PlayAudio(_bU4T6)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_pjpX9)
		end)
	end)
end
function _ICyin:OnStart()
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\090\007\036\039\014\071\016\087\125\077\071\051\087\039\111\080\007\016\019\125\039\089\089\089\039\122\087\026\027\124\006\027\127\010\071\087\039\051\114\007\077\007\036\083\040\098\113\083\040\098\113\011\067\014\099\039\099\038\060\039\089\089\089\039\033\007\125\034\125\039\080\026\007\036\039\051\114\036\069\111\114\127\010\039\089\089\089\039\087\071\127\010\039\087\007\039\014\010\080\087\127\007\039\026\007\069\071\106\106\027\125\039\077\016\039\087\114\127\010\125\002")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _ICyin:OnStop()
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\103\111\016\007\127\069\051\016\087\027\127\010\076\039\077\016\039\051\080\036\027\125\039\077\114\007\039\007\036\027\125\007\039\111\080\010\106\007\039\095\087\125\007\039\080\087\039\077\114\007\027\007\106\039\014\080\127\010\007\089\039\060\080\127\010\039\077\114\007\027\007\106\039\034\051\007\114\125\007\087\039\041\124\016\036\125\039\010\080\027\125\039\077\016\039\077\114\036\039\077\007\087\039\095\114\087\125\036\080\068\039\114\087\039\007\114\087\039\026\111\016\007\125\007\087\051\007\114\027\027\007\027\039\096\071\068\026\016\127\010\039\068\007\027\114\127\010\007\036\125\089\083\040\098\113\083\040\098\113\055\007\125\034\125\039\007\036\027\125\039\007\114\087\106\080\111\039\069\016\036\034\039\077\016\036\127\010\080\125\106\007\087\039\016\087\077\039\051\007\114\125\007\036\039\068\007\010\125\039\007\027\039\068\007\036\080\077\007\080\016\027\089\039\038\106\106\007\036\039\077\007\036\039\060\080\027\007\039\087\080\127\010\039\089\089\089"), 
			Media = _DhtJH
		}
	}, function(action)
		Wherigo.PlayAudio(_flfH)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_MZz4.Active = true
	_MZz4.Visible = true
	_GVR.Active = false
	_GVR.Visible = false
	_Rpn9.Active = false
	_Rpn9.Visible = false
	_s8d.Visible = false
	_s8d.Active = false
	_s8d.Complete = true
	_RNIu5.Active = true
	_RNIu5.Visible = true
end
function _ICyin:OnTick()
	Wherigo.PlayAudio(_WCwgB)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\095\027\039\010\080\125\039\007\127\010\125\039\069\007\114\087\007\087\039\053\051\007\127\069\002\039\055\007\125\034\125\039\026\114\027\125\039\077\016\039\049\039\106\080\111\039\068\007\111\080\016\019\007\087\089\083\040\098\113\083\040\098\113\058\114\036\039\068\111\080\016\026\007\087\076\039\077\080\027\027\039\077\114\007\039\082\012\082\039\090\114\087\068\007\036\039\087\114\127\010\125\039\027\071\039\077\007\114\087\007\039\041\080\127\010\007\039\027\114\087\077\089\039\103\007\010\039\106\114\125\039\068\007\027\007\087\069\125\007\106\039\081\071\124\019\039\007\114\087\019\080\127\010\039\051\007\114\125\007\036\039\089\089\089"), 
			Media = _CB08
		}
	}, function(action)
		Wherigo.PlayAudio(_bU4T6)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_s8d.Active = false
	_s8d.Visible = false
	_Rpn9.Active = false
	_Rpn9.Visible = false
	_GVR.Active = false
	_MZz4.Active = true
	_MZz4.Visible = true
end
function _nVz:On_YeOP(target)
	_T8fa.Active = true
	_T8fa.Visible = true
	_Uojb.Active = false
	_Uojb.Visible = false
	_Uojb.Complete = true
	_abo.Visible = false
	__AE.Visible = true
	__AE:MoveTo(Player)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\103\025\012\012\039\041\095\038\039\090\067\060\081\039\089\089\089\039\083\040\098\113\083\040\098\113\089\089\089\039\026\007\114\106\039\103\007\027\124\036\080\007\127\010\039\106\114\125\039\122\087\026\027\124\006\040\111\114\087\077\021\060\071\071\026\027\039\027\125\007\111\111\125\039\027\114\127\010\039\010\007\036\080\016\027\076\039\077\080\027\027\039\007\036\039\080\016\127\010\039\080\016\019\039\077\007\036\039\041\016\127\010\007\039\087\080\127\010\039\077\114\007\027\007\036\039\090\071\027\007\039\114\027\125\089\039\083\040\098\113\095\036\039\069\080\087\087\039\077\114\036\039\007\114\087\007\039\016\106\019\080\087\068\036\007\114\127\010\007\039\095\036\069\111\080\007\036\016\087\068\039\016\087\077\039\095\114\087\051\007\114\027\016\087\068\039\034\016\039\077\007\106\039\012\010\007\106\080\039\050\095\038\096\126\060\103\039\068\007\026\007\087\089\039\083\040\098\113\083\040\098\113\090\016\039\069\007\087\087\027\125\039\077\114\127\010\039\033\007\125\034\125\039\106\114\125\039\077\007\106\039\109\050\007\114\111\007\087\039\090\114\087\068\109\039\080\016\027\039\016\087\077\039\069\080\087\087\027\125\039\007\087\077\111\114\127\010\039\062\007\036\027\016\127\010\007\087\039\077\007\114\087\007\039\007\036\027\125\007\039\090\071\027\007\039\034\016\039\010\007\026\007\087\089\039\083\040\098\113\083\040\098\113\096\071\007\027\007\039\077\114\007\039\067\016\019\068\080\026\007\039\080\016\019\039\077\007\106\039\067\016\019\068\080\026\007\087\034\007\125\125\007\111\002")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _eYw:On_B0xdW(target)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\058\114\036\039\077\007\087\069\007\087\076\039\077\080\027\027\039\077\016\039\077\114\007\039\096\007\114\125\007\036\039\026\007\114\039\077\114\007\027\007\106\039\069\111\007\114\087\007\087\039\081\111\007\125\125\007\036\026\080\016\106\039\087\114\127\010\125\039\026\036\080\016\127\010\027\125\089\039\067\026\007\036\039\016\106\027\071\087\027\125\039\051\071\111\111\125\007\027\125\039\077\016\039\077\114\007\039\096\007\114\125\007\036\039\033\080\039\062\114\036\125\016\007\111\111\039\080\016\127\010\039\087\114\127\010\125\039\027\127\010\111\007\124\124\007\087\076\039\071\077\007\036\046\083\040\098\113\058\007\087\087\039\077\016\039\027\127\010\071\087\039\106\080\111\039\080\106\039\040\080\016\106\039\026\114\027\125\039\016\087\077\039\068\007\087\080\016\039\027\127\010\080\016\027\125\076\039\077\080\087\087\039\026\007\069\071\106\106\027\125\039\077\016\039\036\080\016\027\076\039\051\080\027\039\010\114\007\036\039\027\071\039\036\114\007\127\010\125\089\039\060\071\125\114\007\036\007\039\077\114\036\039\077\080\027\039\096\071\007\027\016\087\068\027\051\071\036\125\076\039\077\080\027\039\080\016\019\039\077\007\106\039\109\041\125\114\087\069\007\036\109\039\027\125\007\010\125\002\039\083\040\098\113\041\127\010\080\016\039\027\114\127\010\007\036\010\007\114\125\027\010\080\111\026\007\036\039\080\016\019\039\026\007\114\077\007\087\039\041\007\114\125\007\087\039\087\080\127\010\089\083\040\098\113")
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_1d1qD)
		end)
	end)
end
function _QyB2:On_wmcn(target)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\041\016\124\007\036\039\077\007\114\087\039\098\016\127\069\027\080\127\069\039\114\027\125\039\033\007\125\034\125\039\027\080\016\026\007\036\039\016\087\077\039\087\016\087\039\069\080\087\087\039\007\027\039\007\087\077\111\114\127\010\039\111\071\027\039\068\007\010\007\087\089\083\040\098\113\083\040\098\113\090\007\087\039\040\007\027\007\087\039\111\080\027\027\007\039\114\127\010\039\010\114\007\036\039\114\106\039\014\080\127\010\007\021\025\021\011\071\026\114\111\089")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_5BBLl.Visible = false
	_QyB2.Visible = false
	_EYwS:MoveTo(Player)
	_EYwS.Locked = false
	_EYwS.Visible = true
	_Wmc6B.Complete = true
	_Wmc6B.Active = false
	_Wmc6B.Visible = false
	_bSQ4.Active = true
	_bSQ4.Visible = true
	_nGGC.Active = true
	_nGGC.Visible = true
end
function _IkhN4:On_kxe(target)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\095\114\087\051\007\068\010\080\087\077\027\127\010\016\010\039\080\087\076\039\109\099\016\125\109\039\080\026\039\016\087\077\039\077\080\087\087\093\083\040\098\113\083\040\098\113\089\089\089\039\016\087\125\007\087\039\036\080\016\027\076\039\071\026\007\087\039\036\007\114\087\076\039\016\087\125\007\087\039\036\080\016\027\076\039\071\026\007\087\039\036\007\114\087\039\089\089\089\083\040\098\113\083\040\098\113\090\080\039\010\080\026\007\087\039\077\114\007\039\027\114\127\010\039\080\026\007\036\039\007\125\051\080\027\039\125\071\111\111\007\027\039\080\016\027\068\007\077\080\127\010\125\039\089\089\089\089\039\103\098\098\098\098\098\036\036\036\036\036\036\036\083\040\098\113\083\040\098\113\090\007\087\069\039\077\080\036\080\087\076\039\077\080\027\039\097\007\036\027\125\007\127\069\039\019\016\007\036\039\077\114\007\039\060\080\127\010\021\090\114\036\021\014\080\127\010\007\036\039\051\114\007\077\007\036\039\027\071\039\010\007\036\034\016\036\114\127\010\125\007\087\039\051\114\007\039\077\016\039\007\027\039\062\071\036\068\007\019\016\087\077\007\087\039\010\080\027\125\089\083\040\098\113\083\040\098\113\012\036\080\068\007\039\077\114\007\039\068\007\019\016\087\077\007\087\007\039\053\080\010\111\039\114\106\039\067\087\027\127\010\111\016\027\027\039\114\087\039\077\007\114\087\007\087\039\067\016\019\068\080\026\007\087\034\007\125\125\007\111\039\007\114\087\089")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_abo.Visible = false
	_bt1.Visible = true
	_bt1:MoveTo(Player)
	_AqFN.Active = false
	_AqFN.Visible = false
	_AqFN.Complete = true
	_1npYZ.Active = true
	_1npYZ.Visible = true
end
function _UWjoe:On_QmZ(target)
	_Urwigo.Dialog(false, {
		{
			Text = _Qfj2("\040\007\027\125\114\106\106\125\039\007\114\087\007\039\068\016\125\007\039\038\077\007\007\039\010\114\007\036\039\007\114\087\039\082\071\125\071\039\034\016\039\106\080\127\010\007\087\089\039\090\080\027\039\082\071\125\071\039\087\007\010\106\007\039\114\127\010\039\106\114\125\089")
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
	_EJSdl:MoveTo(Player)
end
function __AE:On_07X(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_MUy0A)
	end)
end
function _bt1:On_WkTP(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_o8AGq)
	end)
end
function _5_r:On_OE9(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_ahZc)
	end)
end
function _HqSm:On_9Pm(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Dcm)
	end)
end
function _JK1v:On_IPj5(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_1lF)
	end)
end
function _Ydd6:On_edh(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Q28)
	end)
end
function _MaUa:On_tEw(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_r30yE)
	end)
end
function _J05:On_teiN(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_yCe)
	end)
end
function _SGIi5:On_FFiF(target)
	_WIk9:RequestSync()
	_Urwigo.Dialog(false, {
		{
			Text = "", 
			Media = __z0qX
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return _WIk9
