require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _1Z1j(str)
	local res = ""
    local dtable = "\097\118\042\014\089\057\010\064\008\070\001\028\071\007\072\005\085\083\037\075\093\035\027\115\050\066\016\049\055\124\018\030\065\031\034\043\108\122\103\047\094\113\033\090\111\044\106\060\052\099\117\062\107\006\100\023\081\105\098\040\077\109\114\082\020\046\036\029\095\061\123\051\076\038\039\101\041\069\013\116\104\004\003\087\119\074\012\017\011\084\126\059\000\053\058\002\022\063\096\086\026\091\056\112\068\088\025\102\009\019\092\078\067\121\125\024\054\079\073\120\080\045\032\021\048\110\015"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_kY69 = Wherigo.ZCartridge()

-- Media --
_D8OaO = Wherigo.ZMedia(_kY69)
_D8OaO.Id = "1f5942cc-7ac3-4b37-80d8-d89fbebea6c8"
_D8OaO.Name = _1Z1j("\081\076\058\126\063\058\050\081")
_D8OaO.Description = ""
_D8OaO.AltText = ""
_D8OaO.Resources = {
	{
		Type = "jpg", 
		Filename = "heinrich.jpg", 
		Directives = {}
	}
}
_eZg = Wherigo.ZMedia(_kY69)
_eZg.Id = "f4a1db87-7abf-41bd-ad95-408f921c4eb0"
_eZg.Name = _1Z1j("\085\081\076\063\058\039\045")
_eZg.Description = ""
_eZg.AltText = ""
_eZg.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo1.jpg", 
		Directives = {}
	}
}
_WmfG = Wherigo.ZMedia(_kY69)
_WmfG.Id = "f0b655ae-5cb9-466e-aa10-4b1f2e2b35e9"
_WmfG.Name = _1Z1j("\059\001\126\055\001\039\076\024")
_WmfG.Description = ""
_WmfG.AltText = ""
_WmfG.Resources = {
	{
		Type = "jpg", 
		Filename = "bandages.jpg", 
		Directives = {}
	}
}
_h6tHB = Wherigo.ZMedia(_kY69)
_h6tHB.Id = "17c2718a-5733-4d9a-b037-09aad175b35c"
_h6tHB.Name = _1Z1j("\076\002\058\055\076\126\050\076")
_h6tHB.Description = ""
_h6tHB.AltText = ""
_h6tHB.Resources = {
	{
		Type = "jpg", 
		Filename = "evidence.jpg", 
		Directives = {}
	}
}
_cI6Fa = Wherigo.ZMedia(_kY69)
_cI6Fa.Id = "92e82c7f-ce65-465a-8b40-c866804bda00"
_cI6Fa.Name = _1Z1j("\039\045\037\055\076\126\123\001\062\062\045\123\050\001\126")
_cI6Fa.Description = ""
_cI6Fa.AltText = ""
_cI6Fa.Resources = {
	{
		Type = "jpg", 
		Filename = "golden_ammo_can.jpg", 
		Directives = {}
	}
}
_Ypz = Wherigo.ZMedia(_kY69)
_Ypz.Id = "8f958483-e56e-416a-8df0-e06d508deaef"
_Ypz.Name = _1Z1j("\050\063\001\038\114\123\062\001\126")
_Ypz.Description = ""
_Ypz.AltText = ""
_Ypz.Resources = {
	{
		Type = "jpg", 
		Filename = "crazy_man.jpg", 
		Directives = {}
	}
}
_u7Fg = Wherigo.ZMedia(_kY69)
_u7Fg.Id = "2475448a-0331-4e18-badc-3a70fbceeb24"
_u7Fg.Name = _1Z1j("\050\063\001\050\053\076\055\123\085\058\126\055\045\085")
_u7Fg.Description = ""
_u7Fg.AltText = ""
_u7Fg.Resources = {
	{
		Type = "jpg", 
		Filename = "cracked_window.jpg", 
		Directives = {}
	}
}
_sD1f = Wherigo.ZMedia(_kY69)
_sD1f.Id = "d0c79c15-848b-4a60-ad0c-58354ebd4f3c"
_sD1f.Name = _1Z1j("\126\045\080\076\104\001\055")
_sD1f.Description = ""
_sD1f.AltText = ""
_sD1f.Resources = {
	{
		Type = "jpg", 
		Filename = "notepad.jpg", 
		Directives = {}
	}
}
_xt9 = Wherigo.ZMedia(_kY69)
_xt9.Id = "a07105c1-37af-4a6b-b36f-9c6019afb836"
_xt9.Name = _1Z1j("\085\063\045\126\039\123\001\126\024\085\076\063")
_xt9.Description = ""
_xt9.AltText = ""
_xt9.Resources = {
	{
		Type = "jpg", 
		Filename = "wrong_answer.jpg", 
		Directives = {}
	}
}
_OTuwt = Wherigo.ZMedia(_kY69)
_OTuwt.Id = "0b40bdb6-8641-47e3-9b58-a5eb2ebfba19"
_OTuwt.Name = _1Z1j("\010\045\051\126\080\001\058\126")
_OTuwt.Description = ""
_OTuwt.AltText = ""
_OTuwt.Resources = {
	{
		Type = "jpg", 
		Filename = "fountain1.jpg", 
		Directives = {}
	}
}
_ExG = Wherigo.ZMedia(_kY69)
_ExG.Id = "3e7840a9-31ac-4019-84ce-fd9a08086c08"
_ExG.Name = _1Z1j("\062\001\039\126\058\108\114\058\126\039\123\039\037\001\024\024")
_ExG.Description = ""
_ExG.AltText = ""
_ExG.Resources = {
	{
		Type = "jpg", 
		Filename = "detective.jpg", 
		Directives = {}
	}
}
_AyT = Wherigo.ZMedia(_kY69)
_AyT.Id = "2832c9a3-6cfa-459d-8337-d5db28dbc4be"
_AyT.Name = _1Z1j("\090\001\024\053")
_AyT.Description = ""
_AyT.AltText = ""
_AyT.Resources = {
	{
		Type = "jpg", 
		Filename = "task.jpg", 
		Directives = {}
	}
}
_NarJ = Wherigo.ZMedia(_kY69)
_NarJ.Id = "0b532c12-f151-4920-9e72-0cd3077e8243"
_NarJ.Name = _1Z1j("\018\050\001\063\001\059")
_NarJ.Description = ""
_NarJ.AltText = ""
_NarJ.Resources = {
	{
		Type = "png", 
		Filename = "headerMOGA2015.png", 
		Directives = {}
	}
}
_4CqLz = Wherigo.ZMedia(_kY69)
_4CqLz.Id = "29a0f840-3c3c-4dd0-a62d-7ab268033f52"
_4CqLz.Name = _1Z1j("\059\045\045\053\123\045\108\123\080\081\076\123\055\076\001\055")
_4CqLz.Description = ""
_4CqLz.AltText = ""
_4CqLz.Resources = {
	{
		Type = "jpg", 
		Filename = "Egyptian_Book_of_the_Dead.jpg", 
		Directives = {}
	}
}
_ZBDC = Wherigo.ZMedia(_kY69)
_ZBDC.Id = "3d2113bc-9a21-4553-951c-d8f1911ba464"
_ZBDC.Name = _1Z1j("\104\081\045\126\076\123\050\001\037\037")
_ZBDC.Description = ""
_ZBDC.AltText = ""
_ZBDC.Resources = {
	{
		Type = "mp3", 
		Filename = "Telephone_Ring.mp3", 
		Directives = {}
	}
}
_xTL = Wherigo.ZMedia(_kY69)
_xTL.Id = "4f52f675-44c3-4536-a1a5-8d00610893b4"
_xTL.Name = _1Z1j("\104\081\045\126\076")
_xTL.Description = ""
_xTL.AltText = ""
_xTL.Resources = {
	{
		Type = "jpg", 
		Filename = "telephone_ringing.jpg", 
		Directives = {}
	}
}
_3r9 = Wherigo.ZMedia(_kY69)
_3r9.Id = "c5983748-e7f0-4211-94fe-c9964ce74578"
_3r9.Name = _1Z1j("\053\126\045\050\053")
_3r9.Description = ""
_3r9.AltText = ""
_3r9.Resources = {
	{
		Type = "mp3", 
		Filename = "knock-on-wood.mp3", 
		Directives = {}
	}
}
_7j08 = Wherigo.ZMedia(_kY69)
_7j08.Id = "32a7b007-07c3-4ad4-b37b-a50b22bdf18a"
_7j08.Name = _1Z1j("\104\045\037\058\050\076\123\024\080\001\080\058\045\126")
_7j08.Description = ""
_7j08.AltText = ""
_7j08.Resources = {
	{
		Type = "jpg", 
		Filename = "police_station.jpg", 
		Directives = {}
	}
}
_sR9K = Wherigo.ZMedia(_kY69)
_sR9K.Id = "7f0b3c4f-5e6a-4288-837a-f0ca0fcdfb4a"
_sR9K.Name = _1Z1j("\080\081\076\123\062\051\062\062\114")
_sR9K.Description = ""
_sR9K.AltText = ""
_sR9K.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_final_resize.jpg", 
		Directives = {}
	}
}
_nf9ZN = Wherigo.ZMedia(_kY69)
_nf9ZN.Id = "09ad8312-addc-4120-8130-e1a4f37d3bfb"
_nf9ZN.Name = _1Z1j("\080\081\076\123\062\051\062\062\114\123\039\063\045\001\126")
_nf9ZN.Description = ""
_nf9ZN.AltText = ""
_nf9ZN.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_groan.jpg", 
		Directives = {}
	}
}
_txi = Wherigo.ZMedia(_kY69)
_txi.Id = "4e9fa151-69e1-4a70-a30d-b22dd8553d84"
_txi.Name = _1Z1j("\105\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076")
_txi.Description = ""
_txi.AltText = ""
_txi.Resources = {
	{
		Type = "bmp", 
		Filename = "detective_malone.bmp", 
		Directives = {}
	}
}
_7FZa7 = Wherigo.ZMedia(_kY69)
_7FZa7.Id = "2f2ed83b-d289-4148-b064-6c05e5af9561"
_7FZa7.Name = _1Z1j("\104\081\045\126\076\123\050\045\126\002\076\063\024\001\080\058\045\126")
_7FZa7.Description = ""
_7FZa7.AltText = ""
_7FZa7.Resources = {
	{
		Type = "jpg", 
		Filename = "phone_convo.jpg", 
		Directives = {}
	}
}
_2RY = Wherigo.ZMedia(_kY69)
_2RY.Id = "c4aa964e-6be0-4f18-84bf-491427fa6ffb"
_2RY.Name = _1Z1j("\024\081\045\080\039\051\126\069\024\081\076\037\037\024")
_2RY.Description = ""
_2RY.AltText = ""
_2RY.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun_shells.jpg", 
		Directives = {}
	}
}
_Ovc1 = Wherigo.ZMedia(_kY69)
_Ovc1.Id = "9bb13720-8223-49e8-aafd-dfd98b92d9f8"
_Ovc1.Name = _1Z1j("\024\081\045\080\039\051\126")
_Ovc1.Description = ""
_Ovc1.AltText = ""
_Ovc1.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun.jpg", 
		Directives = {}
	}
}
_I6F3 = Wherigo.ZMedia(_kY69)
_I6F3.Id = "bbceb77d-6793-4dbf-8ad0-b7cc51fa4c83"
_I6F3.Name = _1Z1j("\013\051\126\123\050\001\024\076")
_I6F3.Description = ""
_I6F3.AltText = ""
_I6F3.Resources = {
	{
		Type = "jpg", 
		Filename = "gun_case.jpg", 
		Directives = {}
	}
}
_TEp = Wherigo.ZMedia(_kY69)
_TEp.Id = "9ed581d0-5270-4898-a026-9b4e46a80fc0"
_TEp.Name = _1Z1j("\050\076\062\076\080\076\063\114")
_TEp.Description = ""
_TEp.AltText = ""
_TEp.Resources = {
	{
		Type = "jpg", 
		Filename = "cemetery.jpg", 
		Directives = {}
	}
}
_qxpI = Wherigo.ZMedia(_kY69)
_qxpI.Id = "74092c88-a675-4005-830e-ebf77c08b861"
_qxpI.Name = _1Z1j("\001\126\053\081\028")
_qxpI.Description = ""
_qxpI.AltText = ""
_qxpI.Resources = {
	{
		Type = "jpg", 
		Filename = "ankh1.jpg", 
		Directives = {}
	}
}
_F2E = Wherigo.ZMedia(_kY69)
_F2E.Id = "44414081-00f0-4987-addb-5708828d734c"
_F2E.Name = _1Z1j("\018\081\045\080\039\051\126\123\063\076\037\045\001\055")
_F2E.Description = ""
_F2E.AltText = ""
_F2E.Resources = {
	{
		Type = "mp3", 
		Filename = "shotgun_reload.mp3", 
		Directives = {}
	}
}
_cGB = Wherigo.ZMedia(_kY69)
_cGB.Id = "adf211aa-a17e-411a-9fbd-2e7cc56ed204"
_cGB.Name = _1Z1j("\018\081\045\080\039\051\126\123\010\058\063\076")
_cGB.Description = ""
_cGB.AltText = ""
_cGB.Resources = {
	{
		Type = "mp3", 
		Filename = "shotgun-fire.mp3", 
		Directives = {}
	}
}
_9af = Wherigo.ZMedia(_kY69)
_9af.Id = "3b0bc980-64f2-4819-910e-e2d299808be8"
_9af.Name = _1Z1j("\061\001\104\123\080\045\123\080\081\076\123\108\058\126\001\037")
_9af.Description = ""
_9af.AltText = ""
_9af.Resources = {
	{
		Type = "jpg", 
		Filename = "map140.jpg", 
		Directives = {}
	}
}
__jbt = Wherigo.ZMedia(_kY69)
__jbt.Id = "3b82f987-6a8f-4d1d-8b37-69375ab837dd"
__jbt.Name = _1Z1j("\026\063\058\039\081\080\123\018\081\058\126\058\126\039\123\073\058\039\081\080")
__jbt.Description = ""
__jbt.AltText = ""
__jbt.Resources = {
	{
		Type = "jpg", 
		Filename = "Bright-Light1.jpg", 
		Directives = {}
	}
}
_chmel = Wherigo.ZMedia(_kY69)
_chmel.Id = "086fa262-6c35-439b-bae7-d265ceb01f06"
_chmel.Name = _1Z1j("\062\051\062\062\114\123\001\080\080\001\050\053")
_chmel.Description = ""
_chmel.AltText = ""
_chmel.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_attack.jpg", 
		Directives = {}
	}
}
_G1mCq = Wherigo.ZMedia(_kY69)
_G1mCq.Id = "ffba912f-1576-4d5b-af49-d40724360501"
_G1mCq.Name = _1Z1j("\050\081\001\062\059\076\063\123\045\108\123\050\045\062\062\076\063\050\076")
_G1mCq.Description = ""
_G1mCq.AltText = ""
_G1mCq.Resources = {
	{
		Type = "jpg", 
		Filename = "chamber_of_commerce.jpg", 
		Directives = {}
	}
}
_UJe = Wherigo.ZMedia(_kY69)
_UJe.Id = "13fa499a-77e4-4e8a-9adc-8a14adc1e103"
_UJe.Name = _1Z1j("\050\081\001\062\059\076\063\123\045\108\123\050\045\062\062\076\063\050\076\123\058\050\045\126")
_UJe.Description = ""
_UJe.AltText = ""
_UJe.Resources = {
	{
		Type = "jpg", 
		Filename = "chamber_of_commerce_icon.jpg", 
		Directives = {}
	}
}
_KsS = Wherigo.ZMedia(_kY69)
_KsS.Id = "01b40195-a56c-4ddb-9337-6b2ba2f9e3fa"
_KsS.Name = _1Z1j("\024\080\045\063\076")
_KsS.Description = ""
_KsS.AltText = ""
_KsS.Resources = {
	{
		Type = "jpg", 
		Filename = "bussiness_district.jpg", 
		Directives = {}
	}
}
_mau = Wherigo.ZMedia(_kY69)
_mau.Id = "ce09f282-594d-4b73-9d41-ad6ee5996eb9"
_mau.Name = _1Z1j("\024\080\045\063\076\123\058\050\045\126")
_mau.Description = ""
_mau.AltText = ""
_mau.Resources = {
	{
		Type = "jpg", 
		Filename = "bussiness_district_icon.jpg", 
		Directives = {}
	}
}
_o8F = Wherigo.ZMedia(_kY69)
_o8F.Id = "603abdd6-5b30-41e4-b301-d5b4f111d852"
_o8F.Name = _1Z1j("\104\045\037\058\050\076\123\024\080\001\080\058\045\126\123\058\050\045\126")
_o8F.Description = ""
_o8F.AltText = ""
_o8F.Resources = {
	{
		Type = "jpg", 
		Filename = "police_station_icon.jpg", 
		Directives = {}
	}
}
_3Tunl = Wherigo.ZMedia(_kY69)
_3Tunl.Id = "ad2c7051-2557-4019-b470-24e55cfb2131"
_3Tunl.Name = _1Z1j("\050\076\062\076\080\076\063\114\123\058\050\045\126")
_3Tunl.Description = ""
_3Tunl.AltText = ""
_3Tunl.Resources = {
	{
		Type = "jpg", 
		Filename = "cemetery_icon.jpg", 
		Directives = {}
	}
}
_uiwc = Wherigo.ZMedia(_kY69)
_uiwc.Id = "59601ad0-96f6-46d7-b794-fcc2cc6d9ef9"
_uiwc.Name = _1Z1j("\039\045\037\055\076\126\123\001\062\062\045\123\050\001\126\123\058\050\045\126")
_uiwc.Description = ""
_uiwc.AltText = ""
_uiwc.Resources = {
	{
		Type = "jpg", 
		Filename = "golden_ammo_can_icon.jpg", 
		Directives = {}
	}
}
_d0t = Wherigo.ZMedia(_kY69)
_d0t.Id = "a16cc944-9316-4faa-900e-c0b678be5683"
_d0t.Name = _1Z1j("\108\045\051\126\080\001\058\126\123\058\050\045\126")
_d0t.Description = ""
_d0t.AltText = ""
_d0t.Resources = {
	{
		Type = "jpg", 
		Filename = "fountain_icon.jpg", 
		Directives = {}
	}
}
_dl_nB = Wherigo.ZMedia(_kY69)
_dl_nB.Id = "7e94d930-5edd-45be-b5e8-4c0bf099a39d"
_dl_nB.Name = _1Z1j("\001\063\050\081\058\002\076\024\069\058\050\045\126")
_dl_nB.Description = ""
_dl_nB.AltText = ""
_dl_nB.Resources = {
	{
		Type = "jpg", 
		Filename = "archives_icon.jpg", 
		Directives = {}
	}
}
_jA2 = Wherigo.ZMedia(_kY69)
_jA2.Id = "a0d11a6a-4995-4725-a263-b2c13f51c438"
_jA2.Name = _1Z1j("\001\063\050\081\058\002\076\024")
_jA2.Description = ""
_jA2.AltText = ""
_jA2.Resources = {
	{
		Type = "jpg", 
		Filename = "archives.jpg", 
		Directives = {}
	}
}
_iPb = Wherigo.ZMedia(_kY69)
_iPb.Id = "2e96fa52-5a6f-4fdf-9a2a-64047d21dd25"
_iPb.Name = _1Z1j("\055\076\080\076\050\080\058\002\076\123\062\001\037\045\126\076\123\058\050\045\126")
_iPb.Description = ""
_iPb.AltText = ""
_iPb.Resources = {
	{
		Type = "bmp", 
		Filename = "detective_malone_icon.bmp", 
		Directives = {}
	}
}
_b1osU = Wherigo.ZMedia(_kY69)
_b1osU.Id = "8c0d3669-5f2a-46cc-be0b-d8ce6c70e05c"
_b1osU.Name = _1Z1j("\050\063\001\038\114\123\062\001\126\123\058\050\045\126")
_b1osU.Description = ""
_b1osU.AltText = ""
_b1osU.Resources = {
	{
		Type = "jpg", 
		Filename = "crazy_man_icon.jpg", 
		Directives = {}
	}
}
_Ehcjv = Wherigo.ZMedia(_kY69)
_Ehcjv.Id = "b98a01e3-2047-4ab5-aae5-697155b682e6"
_Ehcjv.Name = _1Z1j("\081\076\058\126\063\058\050\081\123\058\050\045\126")
_Ehcjv.Description = ""
_Ehcjv.AltText = ""
_Ehcjv.Resources = {
	{
		Type = "jpg", 
		Filename = "heinrich_icon.jpg", 
		Directives = {}
	}
}
_87H = Wherigo.ZMedia(_kY69)
_87H.Id = "32ec75b6-fdce-4f82-9a52-7777a460c053"
_87H.Name = _1Z1j("\062\051\062\062\114\123\058\050\045\126")
_87H.Description = ""
_87H.AltText = ""
_87H.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_final_resize_icon.jpg", 
		Directives = {}
	}
}
_Pl5lq = Wherigo.ZMedia(_kY69)
_Pl5lq.Id = "376eaa7c-bfc6-49da-8b89-4303a7782b49"
_Pl5lq.Name = _1Z1j("\024\081\045\080\039\051\126\069\024\081\076\037\037\024\069\058\050\045\126")
_Pl5lq.Description = ""
_Pl5lq.AltText = ""
_Pl5lq.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun_shells_icon.jpg", 
		Directives = {}
	}
}
_pTdVS = Wherigo.ZMedia(_kY69)
_pTdVS.Id = "ab5c5e69-c643-4461-8f32-8b3e98349663"
_pTdVS.Name = _1Z1j("\059\045\045\053\123\045\108\123\080\081\076\123\055\076\001\055\123\058\050\045\126")
_pTdVS.Description = ""
_pTdVS.AltText = ""
_pTdVS.Resources = {
	{
		Type = "jpg", 
		Filename = "Egyptian_Book_of_the_Dead_icon.jpg", 
		Directives = {}
	}
}
_D6c = Wherigo.ZMedia(_kY69)
_D6c.Id = "5758e6f0-5fb3-40ac-ab98-30fbe3a77e39"
_D6c.Name = _1Z1j("\024\081\045\080\039\051\126\123\058\050\045\126")
_D6c.Description = ""
_D6c.AltText = ""
_D6c.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun_icon2.jpg", 
		Directives = {}
	}
}
_tuvnf = Wherigo.ZMedia(_kY69)
_tuvnf.Id = "a64d1ade-1a9a-4731-a86d-7a7cbe0ca066"
_tuvnf.Name = _1Z1j("\050\063\001\050\053\076\055\123\085\058\126\055\045\085\123\058\050\045\126")
_tuvnf.Description = ""
_tuvnf.AltText = ""
_tuvnf.Resources = {
	{
		Type = "jpg", 
		Filename = "cracked_window_icon.jpg", 
		Directives = {}
	}
}
_pvv8j = Wherigo.ZMedia(_kY69)
_pvv8j.Id = "3dfc2ab8-4827-4030-a0ac-0eb01e2b4684"
_pvv8j.Name = _1Z1j("\001\126\053\081\069\058\050\045\126")
_pvv8j.Description = ""
_pvv8j.AltText = ""
_pvv8j.Resources = {
	{
		Type = "jpg", 
		Filename = "ankh_icon.jpg", 
		Directives = {}
	}
}
_4nfn4 = Wherigo.ZMedia(_kY69)
_4nfn4.Id = "a2806e28-c67c-48ff-9338-121c30098d38"
_4nfn4.Name = _1Z1j("\039\051\126\123\050\001\024\076\123\058\050\045\126")
_4nfn4.Description = ""
_4nfn4.AltText = ""
_4nfn4.Resources = {
	{
		Type = "jpg", 
		Filename = "gun_case_icon.jpg", 
		Directives = {}
	}
}
_P9W2I = Wherigo.ZMedia(_kY69)
_P9W2I.Id = "4750758d-34f0-429d-babf-3e3d36b1c875"
_P9W2I.Name = _1Z1j("\024\001\063\050\045\104\081\001\039\051\024\069\058\050\045\126")
_P9W2I.Description = ""
_P9W2I.AltText = ""
_P9W2I.Resources = {
	{
		Type = "jpg", 
		Filename = "sarcophagus_icon.jpg", 
		Directives = {}
	}
}
_LFo = Wherigo.ZMedia(_kY69)
_LFo.Id = "e34ae2ea-4e33-45d2-a7eb-4b9aaf51501e"
_LFo.Name = _1Z1j("\062\001\104\123\058\050\045\126")
_LFo.Description = ""
_LFo.AltText = ""
_LFo.Resources = {
	{
		Type = "jpg", 
		Filename = "map140_icon.jpg", 
		Directives = {}
	}
}
_rmPhh = Wherigo.ZMedia(_kY69)
_rmPhh.Id = "49cf4e91-4ab6-4d9b-97db-650d67fb62c0"
_rmPhh.Name = _1Z1j("\080\001\024\053\123\058\050\045\126")
_rmPhh.Description = ""
_rmPhh.AltText = ""
_rmPhh.Resources = {
	{
		Type = "jpg", 
		Filename = "task_icon.jpg", 
		Directives = {}
	}
}
_7MLu = Wherigo.ZMedia(_kY69)
_7MLu.Id = "ea8c00f8-d107-4511-b37f-cdf02da29de1"
_7MLu.Name = _1Z1j("\024\081\045\104\123\045\085\126\076\063")
_7MLu.Description = ""
_7MLu.AltText = ""
_7MLu.Resources = {
	{
		Type = "jpg", 
		Filename = "shop_owner.jpg", 
		Directives = {}
	}
}
_58I1u = Wherigo.ZMedia(_kY69)
_58I1u.Id = "095a42b6-ccf3-4806-955c-53e054785c89"
_58I1u.Name = _1Z1j("\126\045\080\076\104\001\055\069\058\050\045\126")
_58I1u.Description = ""
_58I1u.AltText = ""
_58I1u.Resources = {
	{
		Type = "jpg", 
		Filename = "notepad_icon.jpg", 
		Directives = {}
	}
}
_z22QE = Wherigo.ZMedia(_kY69)
_z22QE.Id = "4f8d9293-76be-4fd1-9460-c4e309d3b967"
_z22QE.Name = _1Z1j("\062\051\062\062\114\123\039\063\045\001\126")
_z22QE.Description = ""
_z22QE.AltText = ""
_z22QE.Resources = {
	{
		Type = "mp3", 
		Filename = "Mummy.mp3", 
		Directives = {}
	}
}
_Kpf_ = Wherigo.ZMedia(_kY69)
_Kpf_.Id = "40233c96-2ed2-4eb3-972f-00a2056359ff"
_Kpf_.Name = _1Z1j("\062\051\062\062\114\123\055\076\001\080\081")
_Kpf_.Description = ""
_Kpf_.AltText = ""
_Kpf_.Resources = {
	{
		Type = "mp3", 
		Filename = "Monster_Laugh.mp3", 
		Directives = {}
	}
}
_XuMK = Wherigo.ZMedia(_kY69)
_XuMK.Id = "60ffe702-00bf-4b6c-bb63-9c399a7bace7"
_XuMK.Name = _1Z1j("\062\051\062\062\114\123\001\080\080\001\050\053\123\024\045\051\126\055")
_XuMK.Description = ""
_XuMK.AltText = ""
_XuMK.Resources = {
	{
		Type = "mp3", 
		Filename = "punch_or_whack_-Vladimir-403040765.mp3", 
		Directives = {}
	}
}
_qdjr = Wherigo.ZMedia(_kY69)
_qdjr.Id = "7df35bc8-17d9-43ed-828a-85d0caee32da"
_qdjr.Name = _1Z1j("\024\050\001\063\001\059\123\058\050\045\126")
_qdjr.Description = ""
_qdjr.AltText = ""
_qdjr.Resources = {
	{
		Type = "jpg", 
		Filename = "scarab_icon.jpg", 
		Directives = {}
	}
}
_Tsr = Wherigo.ZMedia(_kY69)
_Tsr.Id = "ff44777c-9f44-4ae7-8739-da9320c36e7b"
_Tsr.Name = _1Z1j("\050\001\063\080\123\055\076\080\001\058\037")
_Tsr.Description = ""
_Tsr.AltText = ""
_Tsr.Resources = {
	{
		Type = "jpg", 
		Filename = "cart_detail.jpg", 
		Directives = {}
	}
}
_NJ_V = Wherigo.ZMedia(_kY69)
_NJ_V.Id = "17748300-12bc-4d12-8dce-046189f2001e"
_NJ_V.Name = _1Z1j("\024\104\001\063\053\037\076\123\024\045\051\126\055")
_NJ_V.Description = ""
_NJ_V.AltText = ""
_NJ_V.Resources = {
	{
		Type = "mp3", 
		Filename = "magic-chime-02.mp3", 
		Directives = {}
	}
}
_nbo = Wherigo.ZMedia(_kY69)
_nbo.Id = "150e5c5f-3f5c-47e0-b69a-3f2ccf22dd76"
_nbo.Name = _1Z1j("\113\001\063\080\069\055\076\080\001\058\037\069\058\050\045\126")
_nbo.Description = ""
_nbo.AltText = ""
_nbo.Resources = {
	{
		Type = "png", 
		Filename = "cart_detail_icon.png", 
		Directives = {}
	}
}
_mPy = Wherigo.ZMedia(_kY69)
_mPy.Id = "234aad9a-85a5-48ee-b45b-824d8fb42f92"
_mPy.Name = _1Z1j("\028")
_mPy.Description = ""
_mPy.AltText = ""
_mPy.Resources = {
	{
		Type = "jpg", 
		Filename = "1.jpg", 
		Directives = {}
	}
}
_XXe = Wherigo.ZMedia(_kY69)
_XXe.Id = "1edd5620-b3cb-4d5f-8191-e3df4e30dae4"
_XXe.Name = _1Z1j("\117")
_XXe.Description = ""
_XXe.AltText = ""
_XXe.Resources = {
	{
		Type = "jpg", 
		Filename = "6.jpg", 
		Directives = {}
	}
}
_cLD1r = Wherigo.ZMedia(_kY69)
_cLD1r.Id = "9748dc76-ab0c-4142-9050-d18c1eae2be5"
_cLD1r.Name = _1Z1j("\094")
_cLD1r.Description = ""
_cLD1r.AltText = ""
_cLD1r.Resources = {
	{
		Type = "jpg", 
		Filename = "5.jpg", 
		Directives = {}
	}
}
_tyQFR = Wherigo.ZMedia(_kY69)
_tyQFR.Id = "67e253af-9707-40ec-82bc-d2d12797c173"
_tyQFR.Name = _1Z1j("\025")
_tyQFR.Description = ""
_tyQFR.AltText = ""
_tyQFR.Resources = {
	{
		Type = "jpg", 
		Filename = "2.jpg", 
		Directives = {}
	}
}
_ZQI = Wherigo.ZMedia(_kY69)
_ZQI.Id = "85506a2d-4ccf-4979-9708-fb13685ec2a6"
_ZQI.Name = _1Z1j("\049")
_ZQI.Description = ""
_ZQI.AltText = ""
_ZQI.Resources = {
	{
		Type = "jpg", 
		Filename = "4.jpg", 
		Directives = {}
	}
}
_m32L = Wherigo.ZMedia(_kY69)
_m32L.Id = "77e99b7a-4fd9-4eda-bc83-96feaf0a0bda"
_m32L.Name = _1Z1j("\028\025")
_m32L.Description = ""
_m32L.AltText = ""
_m32L.Resources = {
	{
		Type = "jpg", 
		Filename = "12.jpg", 
		Directives = {}
	}
}
_eWBJ = Wherigo.ZMedia(_kY69)
_eWBJ.Id = "0cf69174-ead7-4580-ab30-ce7aaab22a1e"
_eWBJ.Name = _1Z1j("\059\001\126\055\001\039\076\069\058\050\045\126")
_eWBJ.Description = ""
_eWBJ.AltText = ""
_eWBJ.Resources = {
	{
		Type = "jpg", 
		Filename = "bandage_icon.jpg", 
		Directives = {}
	}
}
_A7i = Wherigo.ZMedia(_kY69)
_A7i.Id = "e683ddf3-4273-4cb2-9380-a7fa294bacbd"
_A7i.Name = _1Z1j("\076\002\058\055\076\126\050\076\123\058\050\045\126")
_A7i.Description = ""
_A7i.AltText = ""
_A7i.Resources = {
	{
		Type = "jpg", 
		Filename = "evidence_icon.jpg", 
		Directives = {}
	}
}
_rwnjR = Wherigo.ZMedia(_kY69)
_rwnjR.Id = "b56947fe-cd9b-4728-9287-16669e17ca6c"
_rwnjR.Name = _1Z1j("\001\126\039\076\037\024")
_rwnjR.Description = ""
_rwnjR.AltText = ""
_rwnjR.Resources = {
	{
		Type = "mp3", 
		Filename = "heavenly_choir.mp3", 
		Directives = {}
	}
}
_ZOv2R = Wherigo.ZMedia(_kY69)
_ZOv2R.Id = "e5079a76-13be-441d-9866-161d72679553"
_ZOv2R.Name = _1Z1j("\039\063\001\024\024\114\123\001\063\076\001")
_ZOv2R.Description = ""
_ZOv2R.AltText = ""
_ZOv2R.Resources = {
	{
		Type = "jpg", 
		Filename = "grassy_area.jpg", 
		Directives = {}
	}
}
_vTvl = Wherigo.ZMedia(_kY69)
_vTvl.Id = "eda0f9ae-48f6-42b7-8908-71945b104329"
_vTvl.Name = _1Z1j("\039\063\001\024\024\114\123\001\063\076\001\123\058\050\045\126")
_vTvl.Description = ""
_vTvl.AltText = ""
_vTvl.Resources = {
	{
		Type = "jpg", 
		Filename = "grassy_area_icon.jpg", 
		Directives = {}
	}
}
_GhZg = Wherigo.ZMedia(_kY69)
_GhZg.Id = "9bdce240-5d2c-413a-b9e3-4556c38c9fcc"
_GhZg.Name = _1Z1j("\050\063\045\024\024\081\001\058\063\024")
_GhZg.Description = ""
_GhZg.AltText = ""
_GhZg.Resources = {
	{
		Type = "jpg", 
		Filename = "resize_crosshairs.jpg", 
		Directives = {}
	}
}
_8Ez9Z = Wherigo.ZMedia(_kY69)
_8Ez9Z.Id = "d8dfb747-b35c-4f89-a3cb-c0da3395e286"
_8Ez9Z.Name = _1Z1j("\024\001\063\050\045\104\081\001\039\051\024")
_8Ez9Z.Description = ""
_8Ez9Z.AltText = ""
_8Ez9Z.Resources = {
	{
		Type = "jpg", 
		Filename = "sarcophagus.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_kY69.Id="83289d76-bf69-481f-b290-e20b5bc78f55"
_kY69.Name="The Curse of the Pharaoh"
_kY69.Description=[[]]
_kY69.Visible=true
_kY69.Activity="Fiction"
_kY69.StartingLocationDescription=[[Move to the archives building, your adventure begins there.]]
_kY69.StartingLocation = ZonePoint(37.38331,-89.66678,0)
_kY69.Version=""
_kY69.Company=""
_kY69.Author="Forest-Ghost"
_kY69.BuilderVersion="URWIGO 1.21.5528.18461"
_kY69.CreateDate="03/02/2015 23:22:32"
_kY69.PublishDate="1/1/0001 12:00:00 AM"
_kY69.UpdateDate="03/30/2015 21:35:25"
_kY69.LastPlayedDate="1/1/0001 12:00:00 AM"
_kY69.TargetDevice="PocketPC"
_kY69.TargetDeviceVersion="0"
_kY69.StateId="1"
_kY69.CountryId="2"
_kY69.Complete=false
_kY69.UseLogging=true

_kY69.Media=_Tsr

_kY69.Icon=_nbo


-- Zones --
_qis = Wherigo.Zone(_kY69)
_qis.Id = "3fac5171-d784-4cac-b328-226ee9f32d7b"
_qis.Name = _1Z1j("\033\063\050\081\058\002\076\024")
_qis.Description = ""
_qis.Visible = true
_qis.Media = _jA2
_qis.Icon = _dl_nB
_qis.Commands = {}
_qis.DistanceRange = Distance(-1, "feet")
_qis.ShowObjects = "OnProximity"
_qis.ProximityRange = Distance(8, "meters")
_qis.AllowSetPositionTo = false
_qis.Active = true
_qis.Points = {
	ZonePoint(37.3835471097173, -89.6669024203368, 0), 
	ZonePoint(37.3835197222938, -89.6666538675797, 0), 
	ZonePoint(37.3833942201783, -89.6666717806698, 0), 
	ZonePoint(37.3834229170128, -89.6669373601254, 0)
}
_qis.OriginalPoint = ZonePoint(37.3834709923006, -89.6667913571779, 0)
_qis.DistanceRangeUOM = "Feet"
_qis.ProximityRangeUOM = "Meters"
_qis.OutOfRangeName = ""
_qis.InRangeName = ""
_qSnu = Wherigo.Zone(_kY69)
_qSnu.Id = "087da99a-5838-4cbe-9f40-b402d18babce"
_qSnu.Name = _1Z1j("\113\081\001\062\059\076\063\123\045\108\123\113\045\062\062\076\063\050\076")
_qSnu.Description = ""
_qSnu.Visible = true
_qSnu.Media = _G1mCq
_qSnu.Icon = _UJe
_qSnu.Commands = {}
_qSnu.DistanceRange = Distance(-1, "feet")
_qSnu.ShowObjects = "OnProximity"
_qSnu.ProximityRange = Distance(8, "meters")
_qSnu.AllowSetPositionTo = false
_qSnu.Active = false
_qSnu.Points = {
	ZonePoint(37.3822731421092, -89.6667121387665, 0), 
	ZonePoint(37.3822638904461, -89.6665553852838, 0), 
	ZonePoint(37.3823834557339, -89.6665459975522, 0), 
	ZonePoint(37.3823931530884, -89.6667029067797, 0)
}
_qSnu.OriginalPoint = ZonePoint(37.3823284103444, -89.6666291070956, 0)
_qSnu.DistanceRangeUOM = "Feet"
_qSnu.ProximityRangeUOM = "Meters"
_qSnu.OutOfRangeName = ""
_qSnu.InRangeName = ""
_Q_2VJ = Wherigo.Zone(_kY69)
_Q_2VJ.Id = "dbc94abf-e3b9-49d0-8950-3c2130fabe5f"
_Q_2VJ.Name = _1Z1j("\121\045\037\058\050\076\123\018\080\001\080\058\045\126")
_Q_2VJ.Description = ""
_Q_2VJ.Visible = true
_Q_2VJ.Media = _7j08
_Q_2VJ.Icon = _o8F
_Q_2VJ.Commands = {}
_Q_2VJ.DistanceRange = Distance(-1, "feet")
_Q_2VJ.ShowObjects = "OnProximity"
_Q_2VJ.ProximityRange = Distance(8, "meters")
_Q_2VJ.AllowSetPositionTo = false
_Q_2VJ.Active = false
_Q_2VJ.Points = {
	ZonePoint(37.3841681913819, -89.6685438583725, 0), 
	ZonePoint(37.3842674055066, -89.6685289380494, 0), 
	ZonePoint(37.3842539195393, -89.6683998428161, 0), 
	ZonePoint(37.3841535061508, -89.6684136306451, 0)
}
_Q_2VJ.OriginalPoint = ZonePoint(37.3842107556447, -89.6684715674708, 0)
_Q_2VJ.DistanceRangeUOM = "Feet"
_Q_2VJ.ProximityRangeUOM = "Meters"
_Q_2VJ.OutOfRangeName = ""
_Q_2VJ.InRangeName = ""
__5gT = Wherigo.Zone(_kY69)
__5gT.Id = "4217790c-9442-4b92-ae0e-a58852b64d4e"
__5gT.Name = _1Z1j("\113\045\051\063\080\081\045\051\024\076\123\010\045\051\126\080\001\058\126")
__5gT.Description = ""
__5gT.Visible = true
__5gT.Media = _OTuwt
__5gT.Icon = _d0t
__5gT.Commands = {}
__5gT.DistanceRange = Distance(-1, "feet")
__5gT.ShowObjects = "OnProximity"
__5gT.ProximityRange = Distance(8, "meters")
__5gT.AllowSetPositionTo = false
__5gT.Active = false
__5gT.Points = {
	ZonePoint(37.3826577488001, -89.6677485917391, 0), 
	ZonePoint(37.3827641662553, -89.6677321821646, 0), 
	ZonePoint(37.3827527260422, -89.6675738596712, 0), 
	ZonePoint(37.3826459938133, -89.667585208771, 0)
}
__5gT.OriginalPoint = ZonePoint(37.3827051587277, -89.6676599605865, 0)
__5gT.DistanceRangeUOM = "Feet"
__5gT.ProximityRangeUOM = "Meters"
__5gT.OutOfRangeName = ""
__5gT.InRangeName = ""
_gxY = Wherigo.Zone(_kY69)
_gxY.Id = "4f280948-7ed8-4765-b38c-337bdbc190d4"
_gxY.Name = _1Z1j("\026\051\024\058\126\076\024\024\123\105\058\024\080\063\058\050\080")
_gxY.Description = ""
_gxY.Visible = true
_gxY.Media = _KsS
_gxY.Icon = _mau
_gxY.Commands = {}
_gxY.DistanceRange = Distance(-1, "feet")
_gxY.ShowObjects = "OnProximity"
_gxY.ProximityRange = Distance(9, "meters")
_gxY.AllowSetPositionTo = false
_gxY.Active = false
_gxY.Points = {
	ZonePoint(37.3819995743028, -89.6678687455155, 0), 
	ZonePoint(37.3819829402929, -89.6677147162209, 0), 
	ZonePoint(37.3820955117369, -89.6676957900597, 0), 
	ZonePoint(37.3821152328037, -89.6678483441394, 0)
}
_gxY.OriginalPoint = ZonePoint(37.3820483147841, -89.6677818989839, 0)
_gxY.DistanceRangeUOM = "Feet"
_gxY.ProximityRangeUOM = "Meters"
_gxY.OutOfRangeName = ""
_gxY.InRangeName = ""
_Yt3vA = Wherigo.Zone(_kY69)
_Yt3vA.Id = "0c81e588-30e2-462f-8d11-5cb28d03ac55"
_Yt3vA.Name = _1Z1j("\113\076\062\076\080\076\063\114")
_Yt3vA.Description = ""
_Yt3vA.Visible = true
_Yt3vA.Media = _TEp
_Yt3vA.Icon = _3Tunl
_Yt3vA.Commands = {}
_Yt3vA.DistanceRange = Distance(-1, "feet")
_Yt3vA.ShowObjects = "OnProximity"
_Yt3vA.ProximityRange = Distance(8, "meters")
_Yt3vA.AllowSetPositionTo = false
_Yt3vA.Active = false
_Yt3vA.Points = {
	ZonePoint(37.3795535082121, -89.6688958285173, 0), 
	ZonePoint(37.3795450459772, -89.6687388180373, 0), 
	ZonePoint(37.3796586123133, -89.668731361057, 0), 
	ZonePoint(37.3796695837718, -89.6688816137865, 0)
}
_Yt3vA.OriginalPoint = ZonePoint(37.3796066875686, -89.6688119053495, 0)
_Yt3vA.DistanceRangeUOM = "Feet"
_Yt3vA.ProximityRangeUOM = "Meters"
_Yt3vA.OutOfRangeName = ""
_Yt3vA.InRangeName = ""
_VT4Xx = Wherigo.Zone(_kY69)
_VT4Xx.Id = "343a1cc8-72b9-446a-88b8-136fd9851a7b"
_VT4Xx.Name = _1Z1j("\090\081\076\123\061\058\024\024\058\126\039\123\033\063\080\058\108\001\050\080\024")
_VT4Xx.Description = ""
_VT4Xx.Visible = true
_VT4Xx.Media = _cI6Fa
_VT4Xx.Icon = _uiwc
_VT4Xx.Commands = {}
_VT4Xx.DistanceRange = Distance(-1, "feet")
_VT4Xx.ShowObjects = "OnProximity"
_VT4Xx.ProximityRange = Distance(8, "meters")
_VT4Xx.AllowSetPositionTo = false
_VT4Xx.Active = false
_VT4Xx.Points = {
	ZonePoint(37.3695412715596, -89.671184033691, 0), 
	ZonePoint(37.3694586175747, -89.6710452592884, 0), 
	ZonePoint(37.3695662861017, -89.6709162853665, 0), 
	ZonePoint(37.3696373128259, -89.6710573132474, 0)
}
_VT4Xx.OriginalPoint = ZonePoint(37.3695508720155, -89.6710507228983, 0)
_VT4Xx.DistanceRangeUOM = "Feet"
_VT4Xx.ProximityRangeUOM = "Meters"
_VT4Xx.OutOfRangeName = ""
_VT4Xx.InRangeName = ""
_Jth = Wherigo.Zone(_kY69)
_Jth.Id = "5374ac3d-12a2-46da-8f26-4938ecda4926"
_Jth.Name = _1Z1j("\013\063\001\024\024\114\123\033\063\076\001")
_Jth.Description = ""
_Jth.Visible = true
_Jth.Media = _ZOv2R
_Jth.Icon = _vTvl
_Jth.Commands = {}
_Jth.DistanceRange = Distance(-1, "feet")
_Jth.ShowObjects = "OnProximity"
_Jth.ProximityRange = Distance(8, "meters")
_Jth.AllowSetPositionTo = false
_Jth.Active = false
_Jth.Points = {
	ZonePoint(37.3833057114415, -89.6673777947876, 0), 
	ZonePoint(37.3832862104041, -89.6671797136519, 0), 
	ZonePoint(37.3834196272362, -89.6671563784334, 0), 
	ZonePoint(37.3834379560476, -89.6673494974825, 0)
}
_Jth.OriginalPoint = ZonePoint(37.3833623762823, -89.6672658460889, 0)
_Jth.DistanceRangeUOM = "Feet"
_Jth.ProximityRangeUOM = "Meters"
_Jth.OutOfRangeName = ""
_Jth.InRangeName = ""

-- Characters --
_FawQ = Wherigo.ZCharacter{
	Cartridge = _kY69, 
	Container = _qis
}
_FawQ.Id = "98e4bc90-b2d0-45d2-9071-633ad3312f7f"
_FawQ.Name = _1Z1j("\105\063\066\123\015\076\058\126\063\058\050\081")
_FawQ.Description = ""
_FawQ.Visible = true
_FawQ.Media = _D8OaO
_FawQ.Icon = _Ehcjv
_FawQ.Commands = {
	_qdHz = Wherigo.ZCommand{
		Text = _1Z1j("\090\001\037\053"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_KspV7 = Wherigo.ZCommand{
		Text = _1Z1j("\090\001\037\053"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_uyK82 = Wherigo.ZCommand{
		Text = _1Z1j("\064\076\080\051\063\126\123\080\081\076\123\113\037\051\076\024"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_5f7q9 = Wherigo.ZCommand{
		Text = _1Z1j("\090\001\037\053"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_mtBL_ = Wherigo.ZCommand{
		Text = _1Z1j("\090\001\037\053"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_Jfb = Wherigo.ZCommand{
		Text = _1Z1j("\090\001\037\053"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_FawQ.Commands._qdHz.Custom = true
_FawQ.Commands._qdHz.Id = "ed6598ef-b757-4d1e-9808-473b3c2f182a"
_FawQ.Commands._qdHz.WorksWithAll = true
_FawQ.Commands._KspV7.Custom = true
_FawQ.Commands._KspV7.Id = "1827f30a-374a-4f4f-8d7b-dcc6202649ce"
_FawQ.Commands._KspV7.WorksWithAll = true
_FawQ.Commands._uyK82.Custom = true
_FawQ.Commands._uyK82.Id = "08ec7bec-58d4-4012-93b3-736f928b5845"
_FawQ.Commands._uyK82.WorksWithAll = true
_FawQ.Commands._5f7q9.Custom = true
_FawQ.Commands._5f7q9.Id = "817e8992-17b2-4e5c-9de4-18c6a17ba7d0"
_FawQ.Commands._5f7q9.WorksWithAll = true
_FawQ.Commands._mtBL_.Custom = true
_FawQ.Commands._mtBL_.Id = "4044c70e-9a8a-4a34-879e-4be37e1e70f2"
_FawQ.Commands._mtBL_.WorksWithAll = true
_FawQ.Commands._Jfb.Custom = true
_FawQ.Commands._Jfb.Id = "7f7aa9eb-4779-4f7b-b6d7-fb58697a5443"
_FawQ.Commands._Jfb.WorksWithAll = true
_FawQ.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_FawQ.Gender = "Male"
_FawQ.Type = "NPC"
_xIp = Wherigo.ZCharacter{
	Cartridge = _kY69, 
	Container = _Q_2VJ
}
_xIp.Id = "61886e4b-5279-4759-be5d-529e09cea046"
_xIp.Name = _1Z1j("\105\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076")
_xIp.Description = ""
_xIp.Visible = true
_xIp.Media = _txi
_xIp.Icon = _iPb
_xIp.Commands = {
	_7Dk = Wherigo.ZCommand{
		Text = _1Z1j("\090\001\037\053"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_Di2E = Wherigo.ZCommand{
		Text = _1Z1j("\090\001\037\053"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_xIp.Commands._7Dk.Custom = true
_xIp.Commands._7Dk.Id = "248d3aa3-06f1-4106-b4f9-69b9b62f8525"
_xIp.Commands._7Dk.WorksWithAll = true
_xIp.Commands._Di2E.Custom = true
_xIp.Commands._Di2E.Id = "fbf3a366-b8c2-4cab-b341-72d0fae86fcf"
_xIp.Commands._Di2E.WorksWithAll = true
_xIp.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_xIp.Gender = "Male"
_xIp.Type = "NPC"
_lUkXM = Wherigo.ZCharacter{
	Cartridge = _kY69, 
	Container = _qSnu
}
_lUkXM.Id = "0f6ac72b-4eeb-4bf3-8b95-d00df77bf77a"
_lUkXM.Name = _1Z1j("\078\114\076\123\084\058\080\126\076\024\024")
_lUkXM.Description = _1Z1j("\033\126\123\076\114\076\123\085\058\080\126\076\024\024\123\085\081\045\123\001\104\104\076\001\063\024\123\080\045\123\059\076\123\058\126\123\001\123\104\001\126\058\050\066")
_lUkXM.Visible = true
_lUkXM.Media = _Ypz
_lUkXM.Icon = _b1osU
_lUkXM.Commands = {
	_qUr = Wherigo.ZCommand{
		Text = _1Z1j("\090\001\037\053"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_lUkXM.Commands._qUr.Custom = true
_lUkXM.Commands._qUr.Id = "18ab7840-f1de-4ad8-93da-30694e050e31"
_lUkXM.Commands._qUr.WorksWithAll = true
_lUkXM.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_lUkXM.Gender = "Male"
_lUkXM.Type = "NPC"
_fvg = Wherigo.ZCharacter(_kY69)
_fvg.Id = "8f8bfdf3-5494-4fec-ac81-721e65e389c1"
_fvg.Name = _1Z1j("\090\081\076\123\061\051\062\062\114")
_fvg.Description = ""
_fvg.Visible = true
_fvg.Media = _sR9K
_fvg.Icon = _87H
_fvg.Commands = {}
_fvg.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_fvg.Gender = "Male"
_fvg.Type = "NPC"

-- Items --
_0tkm = Wherigo.ZItem(_kY69)
_0tkm.Id = "3a601d76-2726-4357-b7d7-381506b423f0"
_0tkm.Name = _1Z1j("\018\001\063\050\045\104\081\001\039\051\024")
_0tkm.Description = ""
_0tkm.Visible = true
_0tkm.Media = _8Ez9Z
_0tkm.Icon = _P9W2I
_0tkm.Commands = {
	_4macR = Wherigo.ZCommand{
		Text = _1Z1j("\078\120\001\062\058\126\076"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_8B7D = Wherigo.ZCommand{
		Text = _1Z1j("\078\120\001\062\058\126\076\123\033\039\001\058\126"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_ZiTBq = Wherigo.ZCommand{
		Text = _1Z1j("\020\126\045\050\053\123\045\126\123\018\001\063\050\045\104\081\001\039\051\024"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_Zs8_V = Wherigo.ZCommand{
		Text = _1Z1j("\073\076\001\002\076\123\018\001\063\050\045\104\081\001\039\051\024"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_0tkm.Commands._4macR.Custom = true
_0tkm.Commands._4macR.Id = "58322339-0c31-4c32-80de-736924768e5d"
_0tkm.Commands._4macR.WorksWithAll = true
_0tkm.Commands._8B7D.Custom = true
_0tkm.Commands._8B7D.Id = "c31f79e0-2aef-4f32-96c7-5a7cd368609f"
_0tkm.Commands._8B7D.WorksWithAll = true
_0tkm.Commands._ZiTBq.Custom = true
_0tkm.Commands._ZiTBq.Id = "afeb56ab-ce46-4347-bf67-da505f6bd09c"
_0tkm.Commands._ZiTBq.WorksWithAll = true
_0tkm.Commands._Zs8_V.Custom = true
_0tkm.Commands._Zs8_V.Id = "59be2130-5e62-46f5-acac-75a3122af91d"
_0tkm.Commands._Zs8_V.WorksWithAll = true
_0tkm.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_0tkm.Locked = false
_0tkm.Opened = false
_gok_ = Wherigo.ZItem(_kY69)
_gok_.Id = "2254b4fa-9b3e-405c-b252-206f3434ec18"
_gok_.Name = _1Z1j("\026\001\126\055\001\039\076\024")
_gok_.Description = _1Z1j("\018\045\062\076\123\059\001\126\055\001\039\076\024\123\080\081\001\080\123\114\045\051\123\108\045\051\126\055\123\037\001\114\058\126\039\123\126\076\001\063\123\080\081\076\123\108\045\051\126\080\001\058\126\066")
_gok_.Visible = true
_gok_.Media = _WmfG
_gok_.Icon = _eWBJ
_gok_.Commands = {}
_gok_.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_gok_.Locked = false
_gok_.Opened = false
_9ljt7 = Wherigo.ZItem(_kY69)
_9ljt7.Id = "5eedae6d-1e48-45c8-98ab-5edc6a88531a"
_9ljt7.Name = _1Z1j("\121\037\001\114\076\063\123\113\045\062\104\037\076\080\058\045\126\123\113\045\055\076")
_9ljt7.Description = ""
_9ljt7.Visible = true
_9ljt7.Media = _eZg
_9ljt7.Commands = {}
_9ljt7.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_9ljt7.Locked = false
_9ljt7.Opened = false
_MQk = Wherigo.ZItem{
	Cartridge = _kY69, 
	Container = _gxY
}
_MQk.Id = "07a76e58-dab5-44f2-a756-14324c96b777"
_MQk.Name = _1Z1j("\113\063\001\050\053\076\055\123\084\058\126\055\045\085")
_MQk.Description = ""
_MQk.Visible = true
_MQk.Media = _u7Fg
_MQk.Icon = _tuvnf
_MQk.Commands = {
	_ErPQv = Wherigo.ZCommand{
		Text = _1Z1j("\078\120\001\062\058\126\076"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_MQk.Commands._ErPQv.Custom = true
_MQk.Commands._ErPQv.Id = "546e6b2d-3bf0-4404-aa55-15679926e35f"
_MQk.Commands._ErPQv.WorksWithAll = true
_MQk.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_MQk.Locked = false
_MQk.Opened = false
_EE9 = Wherigo.ZItem(_kY69)
_EE9.Id = "05c37c39-22e4-4e86-8582-3247107a5e51"
_EE9.Name = _1Z1j("\078\002\058\055\076\126\050\076\123\026\045\120")
_EE9.Description = _1Z1j("\010\058\037\037\076\055\123\085\058\080\081\123\076\002\058\055\076\126\050\076\123\080\081\001\080\123\114\045\051\123\108\045\051\126\055\123\001\080\123\080\081\076\123\050\063\058\062\076\123\024\050\076\126\076\024\066")
_EE9.Visible = true
_EE9.Media = _h6tHB
_EE9.Icon = _A7i
_EE9.Commands = {}
_EE9.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_EE9.Locked = false
_EE9.Opened = false
_PqgE = Wherigo.ZItem(_kY69)
_PqgE.Id = "0d668c55-07fc-4f03-946e-8379eadec2c3"
_PqgE.Name = _1Z1j("\010\045\051\126\080\001\058\126")
_PqgE.Description = ""
_PqgE.Visible = true
_PqgE.Media = _OTuwt
_PqgE.Commands = {
	_p2hZ6 = Wherigo.ZCommand{
		Text = _1Z1j("\078\120\001\062\058\126\076"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_PqgE.Commands._p2hZ6.Custom = true
_PqgE.Commands._p2hZ6.Id = "38f0c305-ccd2-4b24-9b43-ec041763c152"
_PqgE.Commands._p2hZ6.WorksWithAll = true
_PqgE.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_PqgE.Locked = false
_PqgE.Opened = false
_HGhDU = Wherigo.ZItem(_kY69)
_HGhDU.Id = "96d908e8-cdf8-4b33-99d7-59fa611905b2"
_HGhDU.Name = _1Z1j("\078\039\114\104\080\058\001\126\123\026\045\045\053\123\045\108\123\080\081\076\123\105\076\001\055")
_HGhDU.Description = ""
_HGhDU.Visible = true
_HGhDU.Media = _4CqLz
_HGhDU.Icon = _pTdVS
_HGhDU.Commands = {
	_D5h = Wherigo.ZCommand{
		Text = _1Z1j("\064\076\001\055"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_HGhDU.Commands._D5h.Custom = true
_HGhDU.Commands._D5h.Id = "26a3556d-6fe1-4c9b-96fc-1f27ea06c8cf"
_HGhDU.Commands._D5h.WorksWithAll = true
_HGhDU.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_HGhDU.Locked = false
_HGhDU.Opened = false
_Wfk = Wherigo.ZItem(_kY69)
_Wfk.Id = "78715ba5-a431-4cee-b273-4a59779c2e1f"
_Wfk.Name = _1Z1j("\018\081\045\080\039\051\126")
_Wfk.Description = ""
_Wfk.Visible = true
_Wfk.Media = _Ovc1
_Wfk.Icon = _D6c
_Wfk.Commands = {
	_artz = Wherigo.ZCommand{
		Text = _1Z1j("\010\058\063\076\123\013\051\126"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_MUn = Wherigo.ZCommand{
		Text = _1Z1j("\010\058\063\076\123\013\051\126\123\001\080\123\061\051\062\062\114"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_lSeQ = Wherigo.ZCommand{
		Text = _1Z1j("\064\076\037\045\001\055"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_Wfk.Commands._artz.Custom = true
_Wfk.Commands._artz.Id = "2f8f48c5-255e-4740-925d-217a65fc6a9b"
_Wfk.Commands._artz.WorksWithAll = true
_Wfk.Commands._MUn.Custom = true
_Wfk.Commands._MUn.Id = "97c614d1-2fa9-4ab8-b018-5ae30e2f6986"
_Wfk.Commands._MUn.WorksWithAll = true
_Wfk.Commands._lSeQ.Custom = true
_Wfk.Commands._lSeQ.Id = "9dd42503-2219-4092-850e-05f9bdd5e6a8"
_Wfk.Commands._lSeQ.WorksWithAll = true
_Wfk.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Wfk.Locked = false
_Wfk.Opened = false
_RjE2 = Wherigo.ZItem(_kY69)
_RjE2.Id = "848d26af-6647-43e4-9712-256f8052210e"
_RjE2.Name = _1Z1j("\013\051\126\123\113\001\024\076")
_RjE2.Description = ""
_RjE2.Visible = true
_RjE2.Media = _I6F3
_RjE2.Icon = _4nfn4
_RjE2.Commands = {
	_58V = Wherigo.ZCommand{
		Text = _1Z1j("\078\120\001\062\058\126\076"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_mL9a = Wherigo.ZCommand{
		Text = _1Z1j("\090\001\053\076\123\013\051\126"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_RjE2.Commands._58V.Custom = true
_RjE2.Commands._58V.Id = "610dbc13-a273-4268-834c-004d6deea3c0"
_RjE2.Commands._58V.WorksWithAll = true
_RjE2.Commands._mL9a.Custom = true
_RjE2.Commands._mL9a.Id = "3c99bd66-f623-4548-8712-128843fb58b8"
_RjE2.Commands._mL9a.WorksWithAll = true
_RjE2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_RjE2.Locked = false
_RjE2.Opened = false
_1F5k = Wherigo.ZItem(_kY69)
_1F5k.Id = "6f4d0a74-bd1c-4ffc-9a32-26feed9ddd4b"
_1F5k.Name = _1Z1j("\018\081\076\037\037\024")
_1F5k.Description = ""
_1F5k.Visible = true
_1F5k.Media = _2RY
_1F5k.Icon = _Pl5lq
_1F5k.Commands = {
	_j30IT = Wherigo.ZCommand{
		Text = _1Z1j("\064\076\037\045\001\055"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_1F5k.Commands._j30IT.Custom = true
_1F5k.Commands._j30IT.Id = "0e1825b6-5dc2-4bd6-b6ca-51f1b73ce01c"
_1F5k.Commands._j30IT.WorksWithAll = true
_1F5k.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_1F5k.Locked = false
_1F5k.Opened = false
_seuj8 = Wherigo.ZItem{
	Cartridge = _kY69, 
	Container = _Jth
}
_seuj8.Id = "9a2ab490-0535-4314-bebc-f20987aeeeb9"
_seuj8.Name = _1Z1j("\033\126\053\081\123\090\001\037\058\024\062\001\126")
_seuj8.Description = ""
_seuj8.Visible = true
_seuj8.Media = _qxpI
_seuj8.Icon = _pvv8j
_seuj8.Commands = {
	_POcm0 = Wherigo.ZCommand{
		Text = _1Z1j("\121\058\050\053\123\017\104"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_62ry = Wherigo.ZCommand{
		Text = _1Z1j("\017\024\076"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	_TgZ = Wherigo.ZCommand{
		Text = _1Z1j("\017\024\076\123\045\126\123\061\051\062\062\114"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_seuj8.Commands._POcm0.Custom = true
_seuj8.Commands._POcm0.Id = "4b7a7b63-ce7f-4b51-9066-2a80cbcc05f8"
_seuj8.Commands._POcm0.WorksWithAll = true
_seuj8.Commands._62ry.Custom = true
_seuj8.Commands._62ry.Id = "97ac1df8-46f6-4d1a-b146-8520649671f3"
_seuj8.Commands._62ry.WorksWithAll = true
_seuj8.Commands._TgZ.Custom = true
_seuj8.Commands._TgZ.Id = "0deb18bf-2e43-48e6-974b-724297bbe34a"
_seuj8.Commands._TgZ.WorksWithAll = true
_seuj8.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_seuj8.Locked = false
_seuj8.Opened = false
_Mix = Wherigo.ZItem(_kY69)
_Mix.Id = "c2de1222-49ce-4ef8-81ce-d2b74882dbc5"
_Mix.Name = _1Z1j("\061\001\104")
_Mix.Description = _1Z1j("\090\081\076\123\062\058\024\024\058\126\039\123\001\063\080\058\108\001\050\080\024\123\001\063\076\123\037\045\050\001\080\076\055\123\001\080\123\112\123\072\029\123\025\025\066\028\029\072\123\084\123\125\103\006\123\049\125\066\025\117\025\066")
_Mix.Visible = true
_Mix.Media = _9af
_Mix.Icon = _LFo
_Mix.Commands = {}
_Mix.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Mix.Locked = false
_Mix.Opened = false
_rIiGK = Wherigo.ZItem(_kY69)
_rIiGK.Id = "bb7c8ece-5187-48ec-8139-3c73fbee3a56"
_rIiGK.Name = _1Z1j("\050\081\076\001\080")
_rIiGK.Description = ""
_rIiGK.Visible = true
_rIiGK.Commands = {
	_MWj9Z = Wherigo.ZCommand{
		Text = _1Z1j("\050\081\076\001\080"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_rIiGK.Commands._MWj9Z.Custom = true
_rIiGK.Commands._MWj9Z.Id = "be01f631-bfe0-403b-998e-72db12d61771"
_rIiGK.Commands._MWj9Z.WorksWithAll = true
_rIiGK.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_rIiGK.Locked = false
_rIiGK.Opened = false
_MMB7 = Wherigo.ZItem{
	Cartridge = _kY69, 
	Container = Player
}
_MMB7.Id = "7fd08062-4e6e-4003-9e49-6476d45ba7a1"
_MMB7.Name = _1Z1j("\112\045\080\076\104\001\055")
_MMB7.Description = _1Z1j("\033\123\126\045\080\076\104\001\055\123\108\045\063\123\080\001\053\058\126\039\123\126\045\080\076\024\066")
_MMB7.Visible = true
_MMB7.Media = _sD1f
_MMB7.Icon = _58I1u
_MMB7.Commands = {
	_0y3 = Wherigo.ZCommand{
		Text = _1Z1j("\078\120\001\062\058\126\076"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}, 
	__uPVM = Wherigo.ZCommand{
		Text = _1Z1j("\084\063\058\080\076\123\112\045\080\076"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1Z1j("\112\045\080\081\058\126\039\123\001\002\001\058\037\001\059\037\076")
	}
}
_MMB7.Commands._0y3.Custom = true
_MMB7.Commands._0y3.Id = "721062c5-2fff-46a9-aec0-f1f97d4d9be1"
_MMB7.Commands._0y3.WorksWithAll = true
_MMB7.Commands.__uPVM.Custom = true
_MMB7.Commands.__uPVM.Id = "38fef0dc-0147-4492-be11-e5a99c07ff2d"
_MMB7.Commands.__uPVM.WorksWithAll = true
_MMB7.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_MMB7.Locked = false
_MMB7.Opened = false

-- Tasks --
_B5J = Wherigo.ZTask(_kY69)
_B5J.Id = "f273260b-4cae-45a5-b51b-a406ea2a7466"
_B5J.Name = _1Z1j("\090\001\037\053\123\080\045\123\105\063\066\123\015\076\058\126\063\058\050\081")
_B5J.Description = _1Z1j("\018\045\062\076\080\081\058\126\039\123\081\001\024\123\081\001\104\104\076\126\076\055\123\080\045\123\105\063\066\123\015\076\058\126\063\058\050\081\075\024\123\076\120\081\058\059\058\080\066\123\015\076\001\055\123\080\045\123\080\081\076\123\001\063\050\081\058\002\076\024\123\080\045\123\108\058\126\055\123\045\051\080\123\085\081\001\080\123\081\001\104\104\076\126\076\055\066")
_B5J.Visible = true
_B5J.Media = _AyT
_B5J.Icon = _rmPhh
_B5J.Active = false
_B5J.Complete = false
_B5J.CorrectState = "None"
_78rPo = Wherigo.ZTask(_kY69)
_78rPo.Id = "248c8a03-a89d-46dc-8c37-7c4b1a9f2faa"
_78rPo.Name = _1Z1j("\119\126\002\076\024\080\058\039\001\080\076\123\080\081\076\123\050\037\051\076\024")
_78rPo.Description = _1Z1j("\013\045\123\080\045\123\080\081\076\123\037\045\050\001\080\058\045\126\024\123\080\081\001\080\123\105\063\066\123\015\076\058\126\063\058\050\081\123\081\001\024\123\062\001\063\053\076\055\123\045\126\123\114\045\051\063\123\062\001\104\066\123\005\045\051\123\085\058\037\037\123\126\076\076\055\123\080\045\123\076\120\001\062\058\126\076\123\001\123\104\037\001\042\051\076\046\123\058\126\080\076\063\002\058\076\085\123\001\126\123\076\114\076\085\058\080\126\076\024\024\123\001\126\055\123\058\126\002\076\024\080\058\039\001\080\076\123\001\123\050\063\058\062\076\123\024\050\076\126\076\066")
_78rPo.Visible = true
_78rPo.Media = _AyT
_78rPo.Icon = _rmPhh
_78rPo.Active = false
_78rPo.Complete = false
_78rPo.CorrectState = "None"
_hDEx = Wherigo.ZTask(_kY69)
_hDEx.Id = "cf4032e7-77a9-4fec-9463-a042c919efe5"
_hDEx.Name = _1Z1j("\010\058\126\055\123\080\081\076\123\061\058\024\024\058\126\039\123\033\126\053\081\123\090\001\037\058\024\062\001\126")
_hDEx.Description = _1Z1j("\090\081\076\123\033\126\053\081\123\024\114\062\059\045\037\123\085\081\058\050\081\123\085\001\024\123\045\126\123\080\045\104\123\045\108\123\080\081\076\123\024\001\063\050\045\104\081\045\039\051\024\123\058\024\123\062\058\024\024\058\126\039\066\123\010\058\126\055\123\045\051\080\123\085\081\001\080\123\081\001\104\104\076\126\076\055\123\080\045\123\058\080\066")
_hDEx.Visible = true
_hDEx.Media = _AyT
_hDEx.Icon = _rmPhh
_hDEx.Active = false
_hDEx.Complete = false
_hDEx.CorrectState = "None"
_W4DWO = Wherigo.ZTask(_kY69)
_W4DWO.Id = "69b904c6-3360-442a-b23a-d88b355af791"
_W4DWO.Name = _1Z1j("\119\126\002\076\024\080\058\039\001\080\076\123\080\081\076\123\018\001\063\050\045\104\081\001\039\051\024")
_W4DWO.Description = _1Z1j("\113\037\045\024\076\037\114\123\076\120\001\062\058\126\076\123\080\081\076\123\076\062\104\080\114\123\024\001\063\050\045\104\081\001\039\051\024\123\058\126\123\080\081\076\123\035\058\080\076\062\024\035\123\062\076\126\051\123\108\045\063\123\001\126\114\123\076\120\080\063\001\123\050\037\051\076\024\066")
_W4DWO.Visible = true
_W4DWO.Media = _AyT
_W4DWO.Icon = _rmPhh
_W4DWO.Active = false
_W4DWO.Complete = false
_W4DWO.CorrectState = "None"
_Q41 = Wherigo.ZTask(_kY69)
_Q41.Id = "7755dd6f-6e3b-49a3-93b6-72b1e11da489"
_Q41.Name = _1Z1j("\090\001\053\076\123\055\045\085\126\123\080\081\076\123\061\051\062\062\114")
_Q41.Description = _1Z1j("\090\081\076\123\062\051\062\062\114\123\081\001\024\123\001\104\104\076\001\063\076\055\123\058\126\123\080\081\076\123\050\076\062\076\080\076\063\114\066\123\005\045\051\123\085\058\037\037\123\126\076\076\055\123\080\045\123\108\058\126\055\123\001\123\085\001\114\123\080\045\123\080\001\053\076\123\081\058\062\123\055\045\085\126\066\123\018\104\076\001\053\123\080\045\123\105\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076\123\045\063\123\105\063\066\123\015\076\058\126\063\058\050\081\123\108\045\063\123\024\045\062\076\123\058\055\076\001\024\123\045\126\123\081\045\085\123\080\045\123\080\001\053\076\123\081\058\062\123\055\045\085\126\066")
_Q41.Visible = true
_Q41.Media = _AyT
_Q41.Icon = _rmPhh
_Q41.Active = false
_Q41.Complete = false
_Q41.CorrectState = "None"
_UG_s = Wherigo.ZTask(_kY69)
_UG_s.Id = "4a8766fc-78dc-479d-8465-21f54ed7dcec"
_UG_s.Name = _1Z1j("\010\058\126\055\123\080\081\076\123\061\058\024\024\058\126\039\123\033\063\080\058\108\001\050\080\024")
_UG_s.Description = _1Z1j("\119\080\123\058\024\123\063\051\062\045\063\076\055\123\080\081\001\080\123\080\081\076\123\062\051\062\062\114\123\081\001\055\123\001\123\050\045\037\037\076\050\080\058\045\126\123\045\108\123\063\001\063\076\123\001\063\080\058\108\001\050\080\024\066\123\010\058\126\055\123\080\081\076\123\062\058\024\024\058\126\039\123\001\063\080\058\108\001\050\080\024\066\123")
_UG_s.Visible = true
_UG_s.Media = _AyT
_UG_s.Icon = _rmPhh
_UG_s.Active = false
_UG_s.Complete = false
_UG_s.CorrectState = "None"

-- Cartridge Variables --
_EV0 = ""
_k3Kq = ""
_Qv8mz = ""
_F5F = ""
_oBm = 0
_9iWbU = ""
_mBr = ""
_acwF = 0
_n_l = 3
_Kgtk = 6
_DOi1 = 8
_0dX = ""
_Wav = _1Z1j("\069\042\058\024")
_12nR = _1Z1j("\069\010\001\085\057")
_dKm = _1Z1j("\069\125\080\053\062")
_1a4s = _1Z1j("\069\026\094\086")
_cZN = _1Z1j("\069\121\006\080\086\039")
_wztto = _1Z1j("\069\073\078\057\044\053")
_kY69.ZVariables = {
	_EV0 = "", 
	_k3Kq = "", 
	_Qv8mz = "", 
	_F5F = "", 
	_oBm = 0, 
	_9iWbU = "", 
	_mBr = "", 
	_acwF = 0, 
	_n_l = 3, 
	_Kgtk = 6, 
	_DOi1 = 8, 
	_0dX = "", 
	_Wav = _1Z1j("\069\042\058\024"), 
	_12nR = _1Z1j("\069\010\001\085\057"), 
	_dKm = _1Z1j("\069\125\080\053\062"), 
	_1a4s = _1Z1j("\069\026\094\086"), 
	_cZN = _1Z1j("\069\121\006\080\086\039"), 
	_wztto = _1Z1j("\069\073\078\057\044\053")
}

-- Timers --
_LEQZk = Wherigo.ZTimer(_kY69)
_LEQZk.Id = "827cc3d5-a5be-406a-bcf3-78d165ae8cd7"
_LEQZk.Name = _1Z1j("\033\126\053\081\123\090\058\062\076\063")
_LEQZk.Description = ""
_LEQZk.Visible = true
_LEQZk.Duration = 3
_LEQZk.Type = "Countdown"
_z42p = Wherigo.ZTimer(_kY69)
_z42p.Id = "ec801341-9985-4b03-832a-ea91f4707369"
_z42p.Name = _1Z1j("\061\051\062\062\114\123\084\001\037\053\058\126\039")
_z42p.Description = ""
_z42p.Visible = true
_z42p.Duration = 8
_z42p.Type = "Countdown"
_rgYh = Wherigo.ZTimer(_kY69)
_rgYh.Id = "8c760a11-c03b-4b7a-8594-d831300ce777"
_rgYh.Name = _1Z1j("\061\051\062\062\114\123\033\080\080\001\050\053")
_rgYh.Description = ""
_rgYh.Visible = true
_rgYh.Duration = 16
_rgYh.Type = "Countdown"

-- Inputs --
_P9tJg = Wherigo.ZInput(_kY69)
_P9tJg.Id = "a31a03b6-cc9c-40c1-b778-56903cce5b5f"
_P9tJg.Name = _1Z1j("\084\058\037\037\123\114\045\051\123\081\076\037\104\123\062\076\123\058\126\002\076\024\080\058\039\001\080\076\123\062\114\123\062\058\024\024\058\126\039\123\076\120\081\058\059\058\080\098")
_P9tJg.Description = ""
_P9tJg.Visible = true
_P9tJg.Media = _D8OaO
_P9tJg.Choices = {
	"Yes", 
	"No"
}
_P9tJg.InputType = "MultipleChoice"
_P9tJg.Text = _1Z1j("\084\058\037\037\123\114\045\051\123\081\076\037\104\123\062\076\123\058\126\002\076\024\080\058\039\001\080\076\123\062\114\123\062\058\024\024\058\126\039\123\076\120\081\058\059\058\080\098")
_U9b0P = Wherigo.ZInput(_kY69)
_U9b0P.Id = "b28b1f8a-cebd-49b8-92fd-6e29b1be61a9"
_U9b0P.Name = _1Z1j("\010\045\051\126\080\001\058\126\123\121\037\001\042\051\076")
_U9b0P.Description = ""
_U9b0P.Visible = true
_U9b0P.Media = _OTuwt
_U9b0P.InputType = "Text"
_U9b0P.Text = _1Z1j("\005\045\051\123\024\076\076\123\024\050\063\001\080\050\081\123\062\001\063\053\024\123\126\076\001\063\123\080\081\076\123\085\045\063\055\123\058\126\123\080\081\076\123\050\076\126\080\076\063\123\045\108\123\080\081\076\123\104\037\001\042\051\076\066\123\084\081\001\080\123\058\024\123\080\081\058\024\123\085\045\063\055\098")
_vxfrV = Wherigo.ZInput(_kY69)
_vxfrV.Id = "cec0ae3d-0d90-46c0-a7eb-fd4c3f80f8f2"
_vxfrV.Name = _1Z1j("\062\058\024\024\058\126\039\123\001\063\080\058\108\001\050\080\024\123\119\126\104\051\080")
_vxfrV.Description = ""
_vxfrV.Visible = true
_vxfrV.Media = _cI6Fa
_vxfrV.Choices = {
	"Yes", 
	"No", 
	"Need Hint"
}
_vxfrV.InputType = "MultipleChoice"
_vxfrV.Text = _1Z1j("\105\058\055\123\114\045\051\123\108\058\126\055\123\080\081\076\123\062\058\024\024\058\126\039\123\001\063\080\058\108\001\050\080\024")
_v1V = Wherigo.ZInput(_kY69)
_v1V.Id = "4e37c3cb-ea4f-4ae1-8e12-f96fe9d86c75"
_v1V.Name = _1Z1j("\119\126\055\058\001\126\123\018\080\001\080\051\076\123\119\126\104\051\080")
_v1V.Description = ""
_v1V.Visible = true
_v1V.Media = _Ypz
_v1V.InputType = "Text"
_v1V.Text = _1Z1j("\084\081\001\080\123\058\024\123\080\081\076\123\108\058\063\024\080\123\055\001\080\076\123\114\045\051\123\024\076\076\123\062\001\063\053\076\055\123\126\076\001\063\123\080\081\076\123\080\045\104\123\045\108\123\080\081\076\123\104\037\001\042\051\076\098")
_0Lp = Wherigo.ZInput(_kY69)
_0Lp.Id = "aa08dd25-22e3-4cd7-9e10-0dae1d9e0f9a"
_0Lp.Name = _1Z1j("\013\045\123\085\058\080\081\123\080\081\076\123\055\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076\098")
_0Lp.Description = ""
_0Lp.Visible = true
_0Lp.Media = _txi
_0Lp.Choices = {
	"Yes", 
	"No"
}
_0Lp.InputType = "MultipleChoice"
_0Lp.Text = _1Z1j("\084\076\123\001\063\076\123\039\045\058\126\039\123\080\045\123\055\063\058\002\076\123\080\045\123\080\081\076\123\050\076\062\076\080\076\063\114\123\126\045\085\123\080\045\123\058\126\002\076\024\080\058\039\001\080\076\066\123\084\058\037\037\123\114\045\051\123\050\045\062\076\123\085\058\080\081\123\051\024\098")
_nD2S = Wherigo.ZInput(_kY69)
_nD2S.Id = "08f0fb68-e0f3-4302-aab4-03568408248b"
_nD2S.Name = _1Z1j("\024\001\063\050\045\104\081\001\039\051\024")
_nD2S.Description = ""
_nD2S.Visible = true
_nD2S.Media = _8Ez9Z
_nD2S.Choices = {
	"Examine Again", 
	"Leave"
}
_nD2S.InputType = "MultipleChoice"
_nD2S.Text = ""
_Uczx = Wherigo.ZInput(_kY69)
_Uczx.Id = "e792881b-44fa-4ed7-a2d5-681a742ba1e0"
_Uczx.Name = _1Z1j("\084\063\058\080\076\123\112\045\080\076")
_Uczx.Description = ""
_Uczx.Visible = true
_Uczx.InputType = "Text"
_Uczx.Text = _1Z1j("\084\063\058\080\076\123\001\123\126\045\080\076\123\081\076\063\076\095")

-- WorksWithList for object commands --

-- functions --
function _kY69:OnStart()
	_oBm = 0
	_FawQ.Commands._KspV7.Enabled = false
	_FawQ.Commands._uyK82.Enabled = false
	_Wfk.Commands._MUn.Enabled = false
	_B5J.Active = true
	_FawQ.Commands._Jfb.Enabled = false
	_FawQ.Commands._mtBL_.Enabled = false
	_FawQ.Commands._uyK82.Enabled = false
	_seuj8.Commands._TgZ.Enabled = false
	_seuj8.Commands._62ry.Enabled = false
	_xIp.Commands._Di2E.Enabled = false
	_FawQ.Commands._5f7q9.Enabled = false
	_n_l = 3
	_1F5k.Description = (_1Z1j("\005\045\051\123\050\051\063\063\076\126\080\037\114\123\081\001\002\076\123").._n_l).._1Z1j("\123\059\045\120\076\060\024\077\123\045\108\123\024\081\076\037\037\024\066")
	_Urwigo.MessageBox{
		Text = _1Z1j("\090\081\076\123\113\051\063\024\076\123\045\108\123\080\081\076\123\121\081\001\063\001\045\081\095\123\058\126\123\080\081\058\024\123\085\081\076\063\058\039\045\123\114\045\051\123\085\058\037\037\123\126\076\076\055\123\080\045\123\024\045\037\002\076\123\080\081\076\123\062\114\024\080\076\063\114\123\045\108\123\080\081\076\123\104\081\001\063\001\045\081\123\001\126\055\123\081\076\037\104\123\080\081\076\123\104\063\045\108\076\024\024\045\063\123\039\076\080\123\059\001\050\053\123\081\058\024\123\062\058\024\024\058\126\039\123\076\120\081\058\059\058\080\066\123"), 
		Media = _NarJ, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _1Z1j("\119\108\123\114\045\051\123\039\076\080\123\024\080\051\050\053\123\001\037\045\126\039\123\080\081\076\123\085\001\114\123\050\081\076\050\053\123\080\081\076\123\035\080\001\024\053\024\035\123\062\076\126\051\123\108\045\063\123\081\058\126\080\024\066\123"), 
					Media = _AyT, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\090\081\076\063\076\123\001\063\076\123\001\123\002\001\063\058\076\080\114\123\045\108\123\058\080\076\062\024\046\123\050\081\001\063\001\050\080\076\063\024\123\001\126\055\123\037\045\050\001\080\058\045\126\024\123\080\081\001\080\123\114\045\051\123\085\058\037\037\123\126\076\076\055\123\080\045\123\058\126\080\076\063\001\050\080\123\085\058\080\081\123\001\037\045\126\039\123\080\081\076\123\085\001\114\066\123\061\001\053\076\123\024\051\063\076\123\080\045\123\024\076\001\063\050\081\123\076\001\050\081\123\001\063\076\001\123\080\081\045\063\045\051\039\081\037\114\066"), 
								Media = _ExG, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _1Z1j("\121\063\045\050\076\076\055\123\080\045\123\080\081\076\123\001\063\050\081\058\002\076\024\123\059\051\058\037\055\058\126\039\123\126\045\085\123\080\045\123\024\104\076\001\053\123\085\058\080\081\123\105\063\066\123\015\076\058\126\063\058\050\081\066\123\015\076\123\058\024\123\085\001\058\080\058\126\039\123\080\081\076\063\076\123\085\058\080\081\123\001\123\062\058\024\024\058\045\126\123\108\045\063\123\114\045\051\066\123"), 
											Media = _jA2, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _kY69:OnRestore()
end
function _qis:OnEnter()
	_Wav = _1Z1j("\069\042\058\024")
	_Urwigo.MessageBox{
		Text = _1Z1j("\090\081\058\024\123\058\024\123\080\081\076\123\033\063\050\081\058\002\076\024\123\059\051\058\037\055\058\126\039\123\085\081\076\063\076\123\105\063\066\123\015\076\058\126\063\058\050\081\123\055\045\076\024\123\081\058\024\123\063\076\024\076\001\063\050\081\066"), 
		Media = _jA2, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _qis:OnExit()
	_Wav = _1Z1j("\069\042\058\024")
	if _acwF == 1 then
		_Jth.Active = true
		_Urwigo.MessageBox{
			Text = _1Z1j("\033\024\123\114\045\051\123\037\076\001\002\076\123\080\081\076\123\001\063\050\081\058\002\076\024\123\059\051\058\037\055\058\126\039\123\114\045\051\123\126\045\080\058\050\076\123\024\045\062\076\123\024\050\063\001\104\076\123\062\001\063\053\024\123\045\126\123\080\081\076\123\024\058\055\076\085\001\037\053\123\080\045\123\080\081\076\123\085\076\024\080\066"), 
			Media = _ExG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _1Z1j("\005\045\051\123\024\081\045\051\037\055\123\058\126\002\076\024\080\058\039\001\080\076\123\080\081\076\123\001\063\076\001\066\123\119\080\123\001\104\104\076\001\063\024\123\024\045\062\076\080\081\058\126\039\123\085\001\024\123\055\063\001\039\039\076\055\123\080\081\063\045\051\039\081\123\080\081\076\123\039\063\001\024\024\066"), 
						Media = _ExG
					}
				end
			end
		}
	end
end
function _qis:OnProximity()
	_Wav = _1Z1j("\069\042\058\024")
	_Urwigo.GlobalZoneProximity()
end
function _qis:OnSetActive()
	_Wav = _1Z1j("\069\042\058\024")
	_Urwigo.GlobalZoneActiveChanged()
end
function _qSnu:OnProximity()
	_Wav = _1Z1j("\069\042\018\126\051")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _1Z1j("\033\024\123\114\045\051\123\126\076\001\063\123\080\081\076\123\050\081\001\062\059\076\063\123\045\108\123\050\045\062\062\076\063\050\076\123\114\045\051\123\024\076\076\123\001\123\050\063\001\038\076\055\123\076\114\076\085\058\080\126\076\024\024\123\024\080\001\126\055\058\126\039\123\126\076\001\063\059\114\066"), 
		Media = _G1mCq, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _qSnu:OnSetActive()
	_Wav = _1Z1j("\069\042\018\126\051")
	_Urwigo.GlobalZoneActiveChanged()
end
function _Q_2VJ:OnEnter()
	_Wav = _1Z1j("\069\057\069\025\100\086")
	_Urwigo.MessageBox{
		Text = _1Z1j("\033\024\123\114\045\051\123\076\126\080\076\063\123\080\081\076\123\104\045\037\058\050\076\123\024\080\001\080\058\045\126\123\114\045\051\123\024\076\076\123\024\076\002\076\063\001\037\123\045\108\108\058\050\076\063\024\123\063\051\126\126\058\126\039\123\001\063\045\051\126\055\123\050\063\001\038\058\037\114\066\123\105\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076\075\024\123\045\108\108\058\050\076\123\058\024\123\037\045\050\001\080\076\055\123\058\126\123\080\081\076\123\059\001\050\053\066"), 
		Media = _7j08, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _Q_2VJ:OnProximity()
	_Wav = _1Z1j("\069\057\069\025\100\086")
	_Urwigo.GlobalZoneProximity()
end
function _Q_2VJ:OnSetActive()
	_Wav = _1Z1j("\069\057\069\025\100\086")
	_Urwigo.GlobalZoneActiveChanged()
end
function __5gT:OnProximity()
	_Wav = _1Z1j("\069\069\094\039\090")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _1Z1j("\033\024\123\114\045\051\123\126\076\001\063\123\080\081\076\123\108\045\051\126\080\001\058\126\123\114\045\051\123\126\045\080\058\050\076\123\024\050\063\001\080\050\081\123\062\001\063\053\024\123\045\126\123\080\081\076\123\104\037\001\042\051\076\123\058\126\123\108\063\045\126\080\123\045\108\123\080\081\076\123\108\045\051\126\080\001\058\126\066\123\090\081\076\063\076\123\001\063\076\123\024\076\002\076\063\001\037\123\059\001\126\055\001\039\076\024\123\037\001\114\058\126\039\123\126\076\001\063\059\114\066"), 
		Media = _OTuwt, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_U9b0P)
				end)
			end
		end
	}
end
function __5gT:OnSetActive()
	_Wav = _1Z1j("\069\069\094\039\090")
	_Urwigo.GlobalZoneActiveChanged()
end
function _gxY:OnProximity()
	_Wav = _1Z1j("\069\039\120\005")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _1Z1j("\033\024\123\114\045\051\123\085\001\037\053\123\051\104\123\080\045\123\080\081\076\123\059\051\024\058\126\076\024\024\123\055\058\024\050\063\058\050\080\066\123\033\123\024\080\045\063\076\123\045\085\126\076\063\123\050\045\062\076\024\123\045\051\080\123\080\045\123\039\063\076\076\080\123\114\045\051\066"), 
		Media = _KsS, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _1Z1j("\018\045\062\076\080\081\058\126\039\123\001\080\080\001\050\053\076\055\123\062\114\123\059\051\058\037\055\058\126\039\043\123\073\045\045\053\123\062\114\123\085\058\126\055\045\085\123\058\024\123\059\063\045\053\076\126\066"), 
					Media = _7MLu, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\005\045\051\123\024\081\045\051\037\055\123\058\126\002\076\024\080\058\039\001\080\076\123\080\081\076\123\059\063\045\053\076\126\123\085\058\126\055\045\085\123\080\045\123\108\058\126\055\123\045\051\080\123\085\081\001\080\123\081\001\104\104\076\126\076\055\066"), 
								Media = _ExG, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _gxY:OnSetActive()
	_Wav = _1Z1j("\069\039\120\005")
	_Urwigo.GlobalZoneActiveChanged()
end
function _Yt3vA:OnProximity()
	_Wav = _1Z1j("\069\005\080\072\002\033")
	_Urwigo.GlobalZoneProximity()
	_xIp.Commands._Di2E.Enabled = true
	_FawQ.Commands._Jfb.Enabled = true
	_FawQ.Commands._mtBL_.Enabled = false
	_Urwigo.MessageBox{
		Text = _1Z1j("\017\104\045\126\123\076\126\080\076\063\058\126\039\123\080\081\076\123\050\076\062\076\080\076\063\114\123\114\045\051\123\024\076\076\123\080\081\076\123\001\063\076\001\123\058\126\123\055\058\024\001\063\063\001\114\066\123\013\063\001\002\076\024\080\045\126\076\024\123\081\001\002\076\123\059\076\076\126\123\024\062\001\024\081\076\055\123\001\126\055\123\080\081\076\123\039\063\045\051\126\055\123\058\024\123\080\045\063\126\123\051\104\123\076\002\076\063\114\085\081\076\063\076\066"), 
		Media = _TEp, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _1Z1j("\010\063\045\062\123\001\050\063\045\024\024\123\080\081\076\123\108\058\076\037\055\123\114\045\051\123\024\076\076\123\001\123\085\001\037\053\058\126\039\123\050\045\063\104\024\076\123\050\045\002\076\063\076\055\123\058\126\123\059\001\126\055\001\039\076\024\066\123\119\080\123\058\024\123\080\081\076\123\061\051\062\062\114\043"), 
					Media = _sR9K, 
					Callback = function(action)
						if action ~= nil then
							_z42p:Start()
							Wherigo.PlayAudio(_z22QE)
						end
					end
				}
			end
		end
	}
end
function _Yt3vA:OnSetActive()
	_Wav = _1Z1j("\069\005\080\072\002\033")
	_Urwigo.GlobalZoneActiveChanged()
end
function _VT4Xx:OnProximity()
	_Wav = _1Z1j("\069\100\090\049\106\120")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _1Z1j("\005\045\051\123\001\063\076\123\039\076\080\080\058\126\039\123\002\076\063\114\123\050\037\045\024\076\123\080\045\123\080\081\076\123\062\058\024\024\058\126\039\123\001\063\080\058\108\001\050\080\024\066"), 
		Media = _cI6Fa, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_vxfrV)
				end)
			end
		end
	}
end
function _VT4Xx:OnSetActive()
	_Wav = _1Z1j("\069\100\090\049\106\120")
	_Urwigo.GlobalZoneActiveChanged()
end
function _Jth:OnProximity()
	_Wav = _1Z1j("\069\086\080\081")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _1Z1j("\005\045\051\123\126\045\080\058\050\076\123\024\045\062\076\080\081\058\126\039\123\058\126\123\080\081\076\123\039\063\001\024\024\066"), 
		Media = _ExG, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _Jth:OnSetActive()
	_Wav = _1Z1j("\069\086\080\081")
	_Urwigo.GlobalZoneActiveChanged()
end
function _P9tJg:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_EV0 = input
	if Wherigo.NoCaseEquals(_EV0, _1Z1j("\005\076\024")) then
		_Urwigo.MessageBox{
			Text = _1Z1j("\078\120\050\076\037\037\076\126\080\043\123\119\123\001\062\123\039\037\001\055\123\114\045\051\123\001\063\076\123\085\058\037\037\058\126\039\123\080\045\123\081\076\037\104\066"), 
			Media = _D8OaO, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _1Z1j("\090\081\076\063\076\123\001\063\076\123\024\076\002\076\063\001\037\123\037\076\001\055\024\123\114\045\051\123\024\081\045\051\037\055\123\108\045\037\037\045\085\066\123\119\123\085\058\037\037\123\062\001\063\053\123\080\081\076\123\037\045\050\001\080\058\045\126\024\123\045\126\123\114\045\051\063\123\062\001\104\066"), 
						Media = _D8OaO, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _1Z1j("\026\076\108\045\063\076\123\114\045\051\123\037\076\001\002\076\123\114\045\051\123\024\081\045\051\037\055\123\080\001\053\076\123\001\123\037\045\045\053\123\001\080\123\080\081\076\123\076\062\104\080\114\123\024\001\063\050\045\104\081\001\039\051\024\066\123\084\076\123\001\037\024\045\123\081\001\002\076\123\001\123\063\001\063\076\123\050\045\104\114\123\045\108\123\080\081\076\123\078\039\114\104\080\058\001\126\123\026\045\045\053\123\045\108\123\080\081\076\123\105\076\001\055\066\123"), 
									Media = _D8OaO, 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _1Z1j("\090\081\076\123\024\001\063\050\045\104\081\001\039\051\024\123\001\126\055\123\059\045\045\053\123\045\108\123\080\081\076\123\055\076\001\055\123\001\063\076\123\126\045\085\123\001\002\001\058\037\001\059\037\076\123\058\126\123\080\081\076\123\058\080\076\062\024\123\062\076\126\051\066"), 
												Media = _ExG, 
												Callback = function(action)
													if action ~= nil then
														__5gT.Active = true
														_gxY.Active = true
														_qSnu.Active = true
														Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
		_0tkm:MoveTo(_qis)
		_HGhDU:MoveTo(_qis)
		_FawQ.Commands._qdHz.Enabled = false
		_B5J.Complete = true
		_W4DWO.Active = true
		_78rPo.Active = true
		_0tkm.Commands._8B7D.Enabled = false
		_FawQ.Commands._KspV7.Enabled = false
		_FawQ.Commands._5f7q9.Enabled = true
		_FawQ.Description = _1Z1j("\105\063\066\123\015\076\058\126\063\058\050\081\123\001\104\104\076\001\063\024\123\080\045\123\059\076\123\085\001\058\080\058\126\039\123\001\063\045\051\126\055\123\126\076\063\002\045\051\024\037\114\066\123\064\076\080\051\063\126\123\080\045\123\081\058\062\123\001\108\080\076\063\123\114\045\051\123\081\001\002\076\123\058\126\002\076\024\080\058\039\001\080\076\055\123\080\081\076\123\050\037\051\076\024\066")
	elseif Wherigo.NoCaseEquals(_EV0, _1Z1j("\112\045")) then
		_Urwigo.MessageBox{
			Text = _1Z1j("\090\081\001\080\123\058\024\123\080\045\045\123\059\001\055\066\123\119\108\123\114\045\051\123\050\081\001\126\039\076\123\114\045\051\063\123\062\058\126\055\046\123\104\037\076\001\024\076\123\037\076\080\123\062\076\123\053\126\045\085\066"), 
			Media = _D8OaO, 
			Callback = function(action)
				if action ~= nil then
					_FawQ.Commands._KspV7.Enabled = true
					_FawQ.Commands._qdHz.Enabled = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _U9b0P:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_k3Kq = input
	if Wherigo.NoCaseEquals(_k3Kq, _1Z1j("\002\076\080\076\063\001\126\024")) then
		_Urwigo.MessageBox{
			Text = _1Z1j("\090\081\001\080\123\058\024\123\050\045\063\063\076\050\080\043"), 
			Media = _OTuwt, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _1Z1j("\005\045\051\123\062\001\053\076\123\126\045\080\076\123\045\108\123\080\081\076\123\062\001\063\053\058\126\039\024\123\045\126\123\080\081\076\123\104\037\001\042\051\076\123\001\126\055\123\104\058\050\053\123\051\104\123\024\045\062\076\123\045\108\123\080\081\076\123\059\001\126\055\001\039\076\024\123\126\076\001\063\059\114\123\080\045\123\053\076\076\104\123\001\024\123\076\002\058\055\076\126\050\076\066"), 
						Media = _sD1f, 
						Callback = function(action)
							if action ~= nil then
								_gok_:MoveTo(Player)
								__5gT.Active = false
								_oBm = 0
								if _qSnu.Active == false then
									_oBm = _oBm + 1
								end
								if __5gT.Active == false then
									_oBm = _oBm + 1
								end
								if _gxY.Active == false then
									_oBm = _oBm + 1
								end
								if _oBm >= 3 then
									_78rPo.Complete = true
									_FawQ.Commands._uyK82.Enabled = true
									_FawQ.Commands._5f7q9.Enabled = false
									_FawQ.Description = _1Z1j("\105\063\066\123\015\076\058\126\063\058\050\081\123\058\024\123\085\001\058\080\058\126\039\123\001\063\045\051\126\055\123\001\126\120\058\045\051\024\037\114\066\123")
									Wherigo.PlayAudio(_NJ_V)
									_Urwigo.MessageBox{
										Text = _1Z1j("\013\045\045\055\123\047\045\059\043\123\005\045\051\123\081\001\002\076\123\108\045\037\037\045\085\076\055\123\001\037\037\123\045\108\123\080\081\076\123\121\063\045\108\076\024\024\045\063\075\024\123\037\076\001\055\024\066\123\005\045\051\123\024\081\045\051\037\055\123\081\076\001\055\123\059\001\050\053\123\080\045\123\080\001\037\053\123\080\045\123\105\063\066\123\015\076\058\126\063\058\050\081\066"), 
										Media = _NarJ, 
										Callback = function(action)
											if action ~= nil then
												Wherigo.Command "StopSound"
											end
										end
									}
								end
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _1Z1j("\090\081\001\080\123\058\024\123\126\045\080\123\050\045\063\063\076\050\080\066\123\073\045\045\053\123\108\045\063\123\080\081\076\123\085\045\063\055\123\058\126\123\080\081\076\123\062\058\055\055\037\076\123\045\108\123\080\081\076\123\104\037\001\042\051\076\066"), 
			Media = _xt9, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_U9b0P)
					end)
				end
			end
		}
	end
end
function _vxfrV:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Qv8mz = input
	if Wherigo.NoCaseEquals(_Qv8mz, _1Z1j("\005\076\024")) then
		_Urwigo.MessageBox{
			Text = _1Z1j("\033\085\076\024\045\062\076\043\123\113\045\126\039\063\001\080\051\037\001\080\058\045\126\024\123\045\126\123\108\058\126\055\058\126\039\123\080\081\076\123\001\063\080\058\108\001\050\080\024\123\001\126\055\123\050\045\062\104\037\076\080\058\126\039\123\080\081\058\024\123\085\081\076\063\058\039\045\043\123\105\063\066\123\015\076\058\126\063\058\050\081\123\085\058\037\037\123\059\076\123\002\076\063\114\123\081\001\104\104\114\123\085\058\080\081\123\114\045\051\066\123\090\081\058\024\123\085\081\076\063\058\039\045\123\085\001\024\123\050\063\076\001\080\076\055\123\059\114\123\010\045\063\076\024\080\122\013\081\045\024\080\066"), 
			Media = _NarJ, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = (_1Z1j("\005\045\051\063\123\104\037\001\114\076\063\123\050\045\062\104\037\076\080\058\045\126\123\050\045\055\076\123\058\024\123")..string.sub(Player.CompletionCode, 1, 15)).._1Z1j("\123\005\045\051\123\050\001\126\123\001\037\024\045\123\108\058\126\055\123\114\045\051\063\123\104\037\001\114\076\063\123\050\045\062\104\037\076\080\058\045\126\123\050\045\055\076\123\058\126\123\114\045\051\063\123\058\126\002\076\126\080\045\063\114\066\123\061\001\053\076\123\024\051\063\076\123\080\045\123\037\045\039\123\114\045\051\063\123\076\120\104\076\063\058\076\126\050\076\123\045\126\123\085\081\076\063\058\039\045\066\050\045\062\066"), 
						Media = _eZg, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _1Z1j("\090\045\123\108\058\126\055\123\045\051\080\123\062\045\063\076\123\001\059\045\051\080\123\085\081\076\063\058\039\045\024\123\104\037\076\001\024\076\123\002\058\024\058\080\123\085\081\076\063\058\039\045\108\045\051\126\055\001\080\058\045\126\066\050\045\062\066\123\090\081\001\126\053\024\123\108\045\063\123\104\037\001\114\058\126\039\066"), 
									Media = _eZg
								}
							end
						end
					}
					_kY69.Complete = true
					_UG_s.Complete = true
					_9ljt7.Description = string.sub(Player.CompletionCode, 1, 15)
					_9ljt7:MoveTo(Player)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_Qv8mz, _1Z1j("\112\045")) then
		_Urwigo.MessageBox{
			Text = _1Z1j("\119\123\001\062\123\024\045\063\063\114\123\080\081\001\080\123\114\045\051\123\055\058\055\126\075\080\123\108\058\126\055\123\058\080\066\123\005\045\051\123\001\063\076\123\058\126\123\080\081\076\123\050\045\063\063\076\050\080\123\037\045\050\001\080\058\045\126\066\123\119\108\123\114\045\051\123\080\081\058\126\053\123\080\081\076\123\050\001\050\081\076\123\058\024\123\062\058\024\024\058\126\039\123\104\037\076\001\024\076\123\050\045\126\080\001\050\080\123\080\081\076\123\113\118\066"), 
			Media = _cI6Fa, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_vxfrV)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _1Z1j("\013\045\123\059\076\126\076\001\080\081\123\080\045\123\080\081\076\123\062\051\062\062\058\076\024\075\123\037\001\058\063\066\123\090\081\076\123\050\045\045\063\055\058\126\001\080\076\024\123\001\063\076\095\123\112\123\072\029\123\025\025\066\028\029\072\123\084\123\125\103\006\123\049\125\066\025\117\025\066"), 
			Media = _cI6Fa, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_vxfrV)
					end)
				end
			end
		}
	end
end
function _v1V:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_F5F = input
	if Wherigo.NoCaseEquals(_F5F, _1Z1j("\025\125\125\125")) then
		_Urwigo.MessageBox{
			Text = _1Z1j("\005\076\024\043\123\090\081\045\024\076\123\085\076\063\076\123\080\081\076\123\126\051\062\059\076\063\024\123\080\081\001\080\123\085\076\063\076\123\039\037\045\085\058\126\039\066\123\084\081\076\126\123\119\123\080\051\063\126\076\055\123\001\063\045\051\126\055\123\080\081\076\063\076\123\085\001\024\123\126\045\080\081\058\126\039\123\080\081\076\063\076\123\076\120\050\076\104\080\123\001\123\050\045\051\104\037\076\123\059\001\126\055\001\039\076\024\123\045\126\123\080\081\076\123\039\063\045\051\126\055\066\123"), 
			Media = _Ypz, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _1Z1j("\005\045\051\123\062\001\053\076\123\126\045\080\076\123\045\108\123\080\081\076\123\076\114\076\123\085\058\080\126\076\024\024\075\123\024\080\045\063\114\066"), 
						Media = _sD1f, 
						Callback = function(action)
							if action ~= nil then
								_qSnu.Active = false
								_oBm = 0
								if _qSnu.Active == false then
									_oBm = _oBm + 1
								end
								if __5gT.Active == false then
									_oBm = _oBm + 1
								end
								if _gxY.Active == false then
									_oBm = _oBm + 1
								end
								if _oBm >= 3 then
									_FawQ.Commands._uyK82.Enabled = true
									_FawQ.Commands._5f7q9.Enabled = false
									_78rPo.Complete = true
									_FawQ.Description = _1Z1j("\105\063\066\123\015\076\058\126\063\058\050\081\123\058\024\123\085\001\058\080\058\126\039\123\001\063\045\051\126\055\123\001\126\120\058\045\051\024\037\114\066\123")
									Wherigo.PlayAudio(_NJ_V)
									_Urwigo.MessageBox{
										Text = _1Z1j("\013\045\045\055\123\047\045\059\043\123\005\045\051\123\081\001\002\076\123\108\045\037\037\045\085\076\055\123\001\037\037\123\045\108\123\080\081\076\123\121\063\045\108\076\024\024\045\063\075\024\123\037\076\001\055\024\066\123\005\045\051\123\024\081\045\051\037\055\123\081\076\001\055\123\059\001\050\053\123\080\045\123\080\001\037\053\123\080\045\123\105\063\066\123\015\076\058\126\063\058\050\081\066"), 
										Media = _NarJ, 
										Callback = function(action)
											if action ~= nil then
												Wherigo.Command "StopSound"
											end
										end
									}
								end
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _1Z1j("\112\045\046\123\080\081\045\024\076\123\001\063\076\126\075\080\123\080\081\076\123\126\051\062\059\076\063\024\123\080\081\001\080\123\085\076\063\076\123\039\037\045\085\058\126\039\066\123\073\045\045\053\123\108\045\063\123\080\081\076\123\108\045\051\063\123\055\058\039\058\080\123\114\076\001\063\123\126\076\001\063\123\080\081\076\123\080\045\104\123\045\108\123\080\081\076\123\104\037\001\042\051\076\066\123"), 
			Media = _xt9, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_v1V)
					end)
				end
			end
		}
	end
end
function _0Lp:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_9iWbU = input
	if Wherigo.NoCaseEquals(_9iWbU, _1Z1j("\005\076\024")) then
		_Urwigo.MessageBox{
			Text = _1Z1j("\119\123\001\062\123\039\037\001\055\123\080\045\123\081\076\001\063\123\058\080\066\123\084\076\123\050\045\051\037\055\123\051\024\076\123\114\045\051\063\123\081\076\037\104\066\123"), 
			Media = _txi, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _1Z1j("\005\045\051\123\062\001\114\123\126\076\076\055\123\001\123\085\076\001\104\045\126\123\080\045\123\104\063\045\080\076\050\080\123\114\045\051\063\024\076\037\108\066\123\090\001\053\076\123\080\081\058\024\123\024\081\045\080\039\051\126\123\001\126\055\123\062\076\076\080\123\051\024\123\045\002\076\063\123\001\080\123\080\081\076\123\050\076\062\076\080\076\063\114\066"), 
						Media = _txi, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.PlayAudio(_F2E)
								_Urwigo.MessageBox{
									Text = _1Z1j("\105\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076\123\081\001\126\055\024\123\114\045\051\123\001\123\024\081\045\080\039\051\126\123\001\126\055\123\024\076\002\076\063\001\037\123\059\045\120\076\024\123\045\108\123\024\081\076\037\037\024\066"), 
									Media = _Ovc1, 
									Callback = function(action)
										if action ~= nil then
											_Q_2VJ.Active = false
											_xIp:MoveTo(_Yt3vA)
											_FawQ:MoveTo(_Yt3vA)
											_Yt3vA.Active = true
											_Wfk:MoveTo(Player)
											_1F5k:MoveTo(Player)
											_Q41.Active = true
											_xIp.Commands._7Dk.Enabled = false
											_xIp.Description = _1Z1j("\090\081\076\123\055\076\080\076\050\080\058\002\076\123\001\104\104\076\001\063\024\123\080\045\123\059\076\123\002\076\063\114\123\108\063\058\039\081\080\076\126\076\055\066")
											_FawQ.Description = _1Z1j("\105\063\066\123\015\076\058\126\063\058\050\081\123\001\104\104\076\001\063\024\123\080\045\123\059\076\123\002\076\063\114\123\108\063\058\039\081\080\076\126\076\055\066")
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _1Z1j("\118\053\001\114\046\123\114\045\051\123\050\001\126\123\108\058\126\055\123\051\024\123\001\080\123\080\081\076\123\050\076\062\076\080\076\063\114\123\058\108\123\114\045\051\123\050\081\001\126\039\076\123\114\045\051\063\123\062\058\126\055\066"), 
			Media = _txi, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _1Z1j("\090\081\076\123\104\063\045\108\076\024\024\045\063\123\001\126\055\123\074\126\059\024\104\092\055\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076\123\037\076\001\002\076\123\108\045\063\123\080\081\076\123\050\076\062\076\080\076\063\114\066\123\005\045\051\123\108\058\126\055\123\114\045\051\063\024\076\037\108\123\001\037\045\126\076\123\001\080\123\080\081\076\123\104\045\037\058\050\076\123\024\080\001\080\058\045\126\066"), 
						Media = _7j08, 
						Callback = function(action)
							if action ~= nil then
								_RjE2:MoveTo(_Q_2VJ)
								_xIp:MoveTo(_Yt3vA)
								_FawQ:MoveTo(_Yt3vA)
								_xIp.Commands._7Dk.Enabled = false
								_FawQ.Commands._Jfb.Enabled = true
								_Yt3vA.Active = true
								_FawQ.Commands._5f7q9.Enabled = false
								_Q41.Active = true
								_xIp.Description = _1Z1j("\090\081\076\123\055\076\080\076\050\080\058\002\076\123\001\104\104\076\001\063\024\123\080\045\123\059\076\123\002\076\063\114\123\108\063\058\039\081\080\076\126\076\055\066")
								_FawQ.Description = _1Z1j("\105\063\066\123\015\076\058\126\063\058\050\081\123\001\104\104\076\001\063\024\123\080\045\123\059\076\123\002\076\063\114\123\108\063\058\039\081\080\076\126\076\055\066")
							end
						end
					}
				end
			end
		}
	end
end
function _nD2S:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_mBr = input
	if Wherigo.NoCaseEquals(_mBr, _1Z1j("\078\120\001\062\058\126\076\123\033\039\001\058\126")) then
		_Urwigo.MessageBox{
			Text = _1Z1j("\017\104\045\126\123\050\037\045\024\076\063\123\058\126\024\104\076\050\080\058\045\126\123\114\045\051\123\126\045\080\058\050\076\123\080\081\001\080\123\024\045\062\076\080\081\058\126\039\123\081\001\024\123\059\063\045\053\076\126\123\045\108\108\123\108\063\045\062\123\080\081\076\123\080\045\104\123\045\108\123\080\081\076\123\024\001\063\050\045\104\081\045\039\051\024\066"), 
			Media = _8Ez9Z, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.PlayAudio(_NJ_V)
					_Urwigo.MessageBox{
						Text = _1Z1j("\119\080\123\037\045\045\053\024\123\037\058\053\076\123\080\081\076\123\001\126\053\081\123\024\114\062\059\045\037\123\085\081\058\050\081\123\085\001\024\123\045\126\123\080\045\104\123\045\108\123\080\081\076\123\024\001\063\050\045\104\081\045\039\051\024\123\058\024\123\062\058\024\024\058\126\039\043\123"), 
						Media = _NarJ, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _1Z1j("\005\045\051\123\024\081\045\051\037\055\123\058\126\002\076\024\080\058\039\001\080\076\123\080\081\076\123\062\058\024\024\058\126\039\123\001\126\053\081\123\024\114\062\059\045\037\066\123\119\080\123\062\001\114\123\059\076\123\024\045\062\076\123\085\081\076\063\076\123\126\076\001\063\059\114\066\123"), 
									Media = _NarJ, 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _1Z1j("\033\123\126\076\085\123\080\001\024\053\123\058\024\123\001\002\001\058\037\001\059\037\076\123\058\126\123\080\081\076\123\035\080\001\024\053\024\035\123\062\076\126\051\066"), 
												Media = _AyT, 
												Callback = function(action)
													if action ~= nil then
														Wherigo.Command "StopSound"
														_acwF = _acwF + 1
														_0tkm.Commands._8B7D.Enabled = false
														_W4DWO.Complete = true
														_hDEx.Active = true
														Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end
end
function _Uczx:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_0dX = input
	_MMB7.Description = _0dX
end
function _LEQZk:OnStart()
	_rgYh:Stop()
	Wherigo.PlayAudio(_rwnjR)
	_Urwigo.MessageBox{
		Text = "", 
		Media = __jbt
	}
end
function _LEQZk:OnTick()
	_Urwigo.MessageBox{
		Text = _1Z1j("\090\081\076\123\062\051\062\062\114\123\050\045\085\076\063\024\123\059\076\108\045\063\076\123\080\081\076\123\037\058\039\081\080\066"), 
		Media = __jbt, 
		Callback = function(action)
			if action ~= nil then
				_LEQZk:Stop()
				Wherigo.PlayAudio(_Kpf_)
				_Urwigo.MessageBox{
					Text = _1Z1j("\005\045\051\123\126\045\085\123\081\001\002\076\123\080\081\076\123\062\051\062\062\114\123\051\126\055\076\063\123\114\045\051\063\123\050\045\126\080\063\045\037\043"), 
					Media = _nf9ZN, 
					Callback = function(action)
						if action ~= nil then
							_Q41.Complete = true
							_CsY()
							Wherigo.Command "StopSound"
						end
					end
				}
			end
		end
	}
end
function _z42p:OnStart()
	_Urwigo.MessageBox{
		Text = _1Z1j("\090\081\076\123\062\051\062\062\114\123\058\024\123\085\001\037\053\058\126\039\123\080\045\085\001\063\055\024\123\114\045\051\066"), 
		Media = _sR9K, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.Command "StopSound"
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _z42p:OnTick()
	Wherigo.PlayAudio(_z22QE)
	_z42p:Stop()
	_Urwigo.MessageBox{
		Text = _1Z1j("\090\081\076\123\062\051\062\062\114\123\062\045\002\076\024\123\058\126\080\045\123\080\081\076\123\001\063\076\001\066\123\015\076\123\076\114\076\024\123\080\081\076\123\055\076\080\076\050\080\058\002\076\123\001\126\055\123\105\063\066\123\015\076\058\126\063\058\050\081\066"), 
		Media = _sR9K, 
		Callback = function(action)
			if action ~= nil then
				_seuj8.Commands._TgZ.Enabled = true
				_seuj8.Commands._62ry.Enabled = false
				_Wfk.Commands._artz.Enabled = false
				_Wfk.Commands._MUn.Enabled = true
				_fvg:MoveTo(_Yt3vA)
				Wherigo.Command "StopSound"
				_Urwigo.MessageBox{
					Text = _1Z1j("\090\081\076\123\062\051\062\062\114\123\001\080\080\001\050\053\024\043"), 
					Media = _chmel, 
					Callback = function(action)
						if action ~= nil then
							_rgYh:Start()
						end
					end
				}
			end
		end
	}
end
function _rgYh:OnTick()
	_Urwigo.MessageBox{
		Text = _1Z1j("\090\081\076\123\062\051\062\062\114\123\001\080\080\001\050\053\024\043"), 
		Media = _chmel, 
		Callback = function(action)
			if action ~= nil then
				local _rndChoiceValue = math.random()
				if _rndChoiceValue < 0.333333333333333 then
					_rgYh:Stop()
					Wherigo.PlayAudio(_XuMK)
					_Urwigo.MessageBox{
						Text = _1Z1j("\090\081\076\123\062\051\062\062\114\123\024\085\058\126\039\024\123\001\126\055\123\081\058\080\024\123\105\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076\123\085\058\080\081\123\001\123\050\063\051\024\081\058\126\039\123\059\037\045\085\066"), 
						Media = _chmel, 
						Callback = function(action)
							if action ~= nil then
								_rgYh:Start()
								Wherigo.Command "StopSound"
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				elseif _rndChoiceValue < 0.666666666666667 then
					_rgYh:Stop()
					Wherigo.PlayAudio(_XuMK)
					_Urwigo.MessageBox{
						Text = _1Z1j("\090\081\076\123\062\051\062\062\114\123\024\085\058\126\039\024\123\001\126\055\123\081\058\080\024\123\105\063\066\123\015\076\058\126\063\058\050\081\123\085\058\080\081\123\001\123\050\063\051\024\081\058\126\039\123\059\037\045\085\066"), 
						Media = _chmel, 
						Callback = function(action)
							if action ~= nil then
								_rgYh:Start()
								Wherigo.Command "StopSound"
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				else
					_rgYh:Stop()
					Wherigo.PlayAudio(_XuMK)
					_Urwigo.MessageBox{
						Text = _1Z1j("\090\081\076\123\062\051\062\062\114\123\024\085\058\126\039\024\123\001\080\123\114\045\051\123\059\051\080\123\114\045\051\123\001\063\076\123\001\059\037\076\123\080\045\123\039\063\001\050\076\108\051\037\037\114\123\055\045\055\039\076\123\081\058\062\066"), 
						Media = _chmel, 
						Callback = function(action)
							if action ~= nil then
								_rgYh:Start()
								Wherigo.Command "StopSound"
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				end
			end
		end
	}
end
function _FawQ:On_qdHz(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\015\076\037\037\045\046\123\062\114\123\126\001\062\076\123\058\024\123\074\126\059\024\104\092\105\063\066\123\015\076\058\126\063\058\050\081\123\026\063\051\039\024\050\081\066\123\119\123\081\001\002\076\123\059\076\076\126\123\024\080\051\055\114\058\126\039\123\080\081\076\123\001\126\050\058\076\126\080\123\078\039\114\104\080\058\001\126\123\121\081\001\063\045\001\081\123\033\053\081\076\126\001\080\076\126\066"), 
		Media = _D8OaO, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _1Z1j("\090\081\076\123\062\045\063\126\058\126\039\123\001\108\080\076\063\123\080\081\076\123\076\120\081\058\059\058\080\123\001\063\063\058\002\076\055\123\119\123\050\001\062\076\123\058\126\080\045\123\076\120\001\062\058\126\076\123\033\053\081\076\126\001\080\076\126\075\024\123\024\001\063\050\045\104\081\001\039\051\024\123\001\126\055\123\080\081\076\123\050\045\126\080\076\126\080\024\123\001\037\045\126\039\123\085\058\080\081\123\024\076\002\076\063\001\037\123\001\063\080\058\108\001\050\080\024\123\085\076\063\076\123\062\058\024\024\058\126\039\066"), 
					Media = _D8OaO, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\119\123\050\045\126\080\001\050\080\076\055\123\080\081\076\123\001\051\080\081\045\063\058\080\058\076\024\123\059\051\080\123\126\045\123\045\126\076\123\081\001\024\123\059\076\076\126\123\001\059\037\076\123\080\045\123\050\045\062\076\123\051\104\123\085\058\080\081\123\001\123\024\045\037\051\080\058\045\126\066"), 
								Media = _D8OaO, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(_P9tJg)
										end)
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _FawQ:On_KspV7(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\033\081\081\046\123\114\045\051\123\081\001\002\076\123\063\076\080\051\063\126\076\055\066"), 
		Media = _D8OaO, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_P9tJg)
				end)
			end
		end
	}
end
function _FawQ:On_uyK82(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\078\120\050\076\037\037\076\126\080\043\123\114\045\051\123\081\001\002\076\123\108\045\051\126\055\123\001\037\037\123\045\108\123\080\081\076\123\050\037\051\076\024\066\123"), 
		Media = _D8OaO, 
		Callback = function(action)
			if action ~= nil then
				_gok_:MoveTo(_FawQ)
				_EE9:MoveTo(_FawQ)
				_Urwigo.MessageBox{
					Text = _1Z1j("\119\123\085\058\037\037\123\080\001\053\076\123\001\126\114\123\076\002\058\055\076\126\050\076\123\080\081\001\080\123\114\045\051\123\081\001\002\076\123\108\045\051\126\055\066"), 
					Media = _D8OaO, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\026\076\108\045\063\076\123\085\076\123\050\045\126\080\058\126\051\076\123\080\081\045\051\039\081\046\123\119\123\081\001\002\076\123\001\123\050\045\126\108\076\024\024\058\045\126\095\123\119\123\081\001\002\076\123\126\045\080\123\059\076\076\126\123\050\045\062\104\037\076\080\076\037\114\123\051\104\108\063\045\126\080\123\085\058\080\081\123\114\045\051\066\123\090\081\076\063\076\123\058\024\123\062\045\063\076\123\080\045\123\080\081\058\024\123\050\001\024\076\123\080\081\076\126\123\119\123\081\001\002\076\123\024\081\001\063\076\055\066"), 
								Media = _D8OaO, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _1Z1j("\073\076\080\123\062\076\123\080\076\037\037\123\114\045\051\123\001\123\024\080\045\063\114\066\066\066"), 
											Media = _D8OaO, 
											Callback = function(action)
												if action ~= nil then
													_Qvsp()
													_FawQ.Commands._uyK82.Enabled = false
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _FawQ:On_5f7q9(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\119\123\024\076\076\123\080\081\001\080\123\114\045\051\123\081\001\002\076\123\126\045\080\123\108\045\051\126\055\123\001\037\037\123\045\108\123\080\081\076\123\050\037\051\076\024\123\114\076\080\066\123\121\037\076\001\024\076\123\063\076\080\051\063\126\123\081\076\063\076\123\085\081\076\126\123\114\045\051\123\081\001\002\076\123\055\045\126\076\123\024\045\066"), 
		Media = _D8OaO, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _FawQ:On_mtBL_(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\119\123\001\062\123\039\037\001\055\123\114\045\051\123\062\001\055\076\123\058\080\066\123\018\104\076\001\053\123\080\045\123\055\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076\123\080\045\123\108\058\126\055\123\045\051\080\123\045\051\063\123\126\076\120\080\123\062\045\002\076\066"), 
		Media = _D8OaO, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _FawQ:On_Jfb(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\015\076\037\104\043\043\043\043\123\119\080\024\123\080\081\076\123\062\051\062\062\114\043\123\119\075\002\076\123\081\076\001\063\055\123\080\081\001\080\123\001\123\050\076\063\080\001\058\126\123\001\126\053\081\123\080\001\037\058\024\062\001\126\123\081\001\024\123\104\045\085\076\063\123\045\002\076\063\123\080\081\076\123\062\051\062\062\114\066"), 
		Media = _D8OaO, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _xIp:On_7Dk(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\015\058\046\123\119\123\001\062\123\055\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076\066\123\119\123\001\062\123\058\126\123\050\081\001\063\039\076\123\045\108\123\080\081\058\024\123\050\001\024\076\066"), 
		Media = _txi, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _1Z1j("\078\002\076\063\123\024\058\126\050\076\123\119\123\039\045\080\123\104\051\080\123\045\126\123\080\081\058\024\123\050\001\024\076\123\080\081\058\126\039\024\123\081\001\002\076\123\126\045\080\123\059\076\076\126\123\063\058\039\081\080\123\058\126\123\080\045\085\126\066\123"), 
					Media = _txi, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\119\123\081\001\002\076\123\059\076\076\126\123\039\076\080\080\058\126\039\123\001\037\037\123\053\058\126\055\024\123\045\108\123\050\001\037\037\024\095\123\050\045\062\104\037\001\058\126\080\024\046\123\055\058\024\080\051\063\059\001\126\050\076\024\046\123\001\126\055\123\024\058\039\081\080\058\126\039\024\123\045\108\123\001\126\123\051\126\122\126\001\080\051\063\001\037\123\053\058\126\055\066"), 
								Media = _txi, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _1Z1j("\090\081\076\123\104\063\045\108\076\024\024\045\063\123\024\104\076\001\053\024\123\051\104\046\123\119\123\063\076\001\037\037\114\123\001\062\123\024\045\063\063\114\123\108\045\063\123\076\002\076\063\114\080\081\058\126\039\123\055\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076\066\123\119\123\059\037\001\062\076\123\062\114\024\076\037\108\123\108\045\063\123\085\081\001\080\123\081\001\024\123\081\001\104\104\076\126\076\055\066\123"), 
											Media = _D8OaO, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _1Z1j("\119\123\001\104\104\063\076\050\058\001\080\076\123\080\081\001\080\123\059\051\080\123\051\126\108\045\063\080\051\126\001\080\076\037\114\123\080\081\076\063\076\123\058\024\123\126\045\080\081\058\126\039\123\085\076\123\050\001\126\123\055\045\123\126\045\085\066\123\090\081\058\024\123\062\045\063\126\058\126\039\123\119\123\039\045\080\123\001\123\050\001\037\037\123\108\063\045\062\123\080\081\076\123\039\063\045\051\126\055\024\123\053\076\076\104\076\063\123\001\080\123\080\081\076\123\050\076\062\076\080\076\063\114\123\085\081\045\123\063\076\104\045\063\080\076\055\123\080\081\001\080\123\001\123\104\076\063\024\045\126\123\085\001\024\123\001\080\080\001\050\053\076\055\066"), 
														Media = _txi, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _1Z1j("\084\081\076\126\123\080\081\076\123\002\058\050\080\058\062\123\085\001\024\123\001\024\053\076\055\123\085\081\045\123\080\081\076\058\063\123\001\080\080\001\050\053\076\063\123\085\001\024\046\123\080\081\076\123\045\126\037\114\123\080\081\058\126\039\123\080\081\076\114\123\050\045\051\037\055\123\024\080\001\080\076\123\085\001\024\046\123\035\061\017\061\061\005\043\043\043\035"), 
																	Media = _txi, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.RunDialogs(function()
																				Wherigo.GetInput(_0Lp)
																			end)
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _xIp:On_Di2E(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\090\081\076\123\062\051\062\062\114\123\058\024\123\024\045\123\108\063\058\039\081\080\076\126\058\126\039\043\123\017\024\076\123\001\123\024\081\045\080\039\051\126\123\080\045\123\080\001\053\076\123\081\058\062\123\055\045\085\126\043\043\043"), 
		Media = _txi
	}
end
function _lUkXM:On_qUr(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\005\045\051\123\076\120\104\037\001\058\126\123\080\045\123\080\081\076\123\085\058\080\126\076\024\024\123\080\081\001\080\123\114\045\051\123\001\063\076\123\058\126\002\076\024\080\058\039\001\080\058\126\039\123\080\081\076\123\050\001\024\076\123\001\126\055\123\001\024\053\123\081\058\062\123\085\081\001\080\123\081\001\104\104\076\126\076\055\066"), 
		Media = _ExG, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _1Z1j("\090\081\076\123\076\114\076\123\085\058\080\126\076\024\024\123\047\051\062\104\024\123\051\104\123\126\076\063\002\045\051\024\037\114\066\123\119\123\085\001\024\123\081\076\063\076\123\001\126\055\123\119\123\081\076\001\063\055\123\058\080\043\043\043\043\043"), 
					Media = _Ypz, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\119\123\085\001\024\123\080\001\053\058\126\039\123\001\123\037\045\045\053\123\001\080\123\080\081\058\024\123\059\076\001\051\080\058\108\051\037\123\024\080\001\080\051\076\123\085\081\076\126\123\119\123\081\076\001\063\055\123\001\123\055\076\076\104\123\039\063\045\001\126\123\059\076\081\058\126\055\123\062\076\066\123\033\037\037\123\045\108\123\001\123\024\051\055\055\076\126\123\080\081\076\123\055\001\080\076\123\045\126\123\080\081\058\024\123\024\080\001\080\051\076\123\024\080\001\063\080\024\123\039\037\045\085\058\126\039\123\063\076\055\066"), 
								Media = _Ypz, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _1Z1j("\119\123\080\051\063\126\076\055\123\001\063\045\051\126\055\123\080\045\123\024\076\076\123\085\081\001\080\123\085\001\024\123\062\001\053\058\126\039\123\080\081\076\123\024\045\051\126\055\123\059\051\080\123\085\081\001\080\076\002\076\063\123\058\080\123\085\001\024\123\055\058\024\001\104\104\076\001\063\076\055\066"), 
											Media = _Ypz, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.RunDialogs(function()
														Wherigo.GetInput(_v1V)
													end)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _0tkm:On_4macR(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\017\104\045\126\123\076\120\001\062\058\126\058\126\039\123\080\081\076\123\024\001\063\050\045\104\081\001\039\051\024\123\114\045\051\123\024\076\076\123\024\045\062\076\123\024\050\063\001\080\050\081\123\062\001\063\053\024\123\045\126\123\080\081\076\123\024\051\063\108\001\050\076\123\059\051\080\123\126\045\080\123\062\051\050\081\123\076\037\024\076\066"), 
		Media = _8Ez9Z, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_nD2S)
				end)
				_0tkm.Commands._4macR.Enabled = false
				_0tkm.Commands._8B7D.Enabled = true
			end
		end
	}
end
function _0tkm:On_8B7D(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\017\104\045\126\123\050\037\045\024\076\063\123\058\126\024\104\076\050\080\058\045\126\123\114\045\051\123\126\045\080\058\050\076\123\080\081\001\080\123\024\045\062\076\080\081\058\126\039\123\081\001\024\123\059\063\045\053\076\126\123\045\108\108\123\108\063\045\062\123\080\081\076\123\080\045\104\123\045\108\123\080\081\076\123\024\001\063\050\045\104\081\045\039\051\024\066"), 
		Media = _8Ez9Z, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.PlayAudio(_NJ_V)
				_Urwigo.MessageBox{
					Text = _1Z1j("\119\080\123\037\045\045\053\024\123\037\058\053\076\123\080\081\076\123\001\126\053\081\123\024\114\062\059\045\037\123\085\081\058\050\081\123\085\001\024\123\045\126\123\080\045\104\123\045\108\123\080\081\076\123\024\001\063\050\045\104\081\045\039\051\024\123\058\024\123\062\058\024\024\058\126\039\043\123"), 
					Media = _NarJ, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\005\045\051\123\024\081\045\051\037\055\123\058\126\002\076\024\080\058\039\001\080\076\123\080\081\076\123\062\058\024\024\058\126\039\123\001\126\053\081\123\024\114\062\059\045\037\066\123\119\080\123\062\001\114\123\059\076\123\024\045\062\076\123\085\081\076\063\076\123\126\076\001\063\059\114\066\123"), 
								Media = _NarJ, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _1Z1j("\033\123\126\076\085\123\080\001\024\053\123\058\024\123\001\002\001\058\037\001\059\037\076\123\058\126\123\080\081\076\123\035\080\001\024\053\024\035\123\062\076\126\051\066"), 
											Media = _AyT, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.Command "StopSound"
													_0tkm.Commands._8B7D.Enabled = false
													_W4DWO.Complete = true
													_hDEx.Active = true
													_acwF = _acwF + 1
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _0tkm:On_ZiTBq(target)
	Wherigo.PlayAudio(_3r9)
	_Urwigo.MessageBox{
		Text = _1Z1j("\005\045\051\123\080\063\114\123\053\126\045\050\053\058\126\039\123\045\126\123\080\081\076\123\024\001\063\050\045\104\081\001\039\051\024\123\059\051\080\123\126\045\080\123\062\051\050\081\123\081\001\104\104\076\126\024\066"), 
		Media = _8Ez9Z, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.Command "StopSound"
			end
		end
	}
end
function _0tkm:On_Zs8_V(target)
	Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
function _MQk:On_ErPQv(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\073\045\045\053\058\126\039\123\050\037\045\024\076\037\114\123\001\080\123\080\081\076\123\050\063\001\050\053\076\055\123\085\058\126\055\045\085\123\114\045\051\123\024\076\076\123\024\045\062\076\123\045\037\055\123\108\058\059\076\063\123\050\001\051\039\081\080\123\058\126\123\080\081\076\123\059\063\045\053\076\126\123\039\037\001\024\024\066\123"), 
		Media = _u7Fg, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _1Z1j("\005\045\051\123\001\037\024\045\123\126\045\080\058\050\076\123\001\123\024\062\001\037\037\123\050\081\051\126\053\123\045\108\123\063\045\080\080\076\126\123\108\037\076\024\081\066\123"), 
					Media = _u7Fg, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\005\045\051\123\080\001\053\076\123\059\045\080\081\123\058\080\076\062\024\123\001\126\055\123\055\076\104\045\024\058\080\123\080\081\076\062\123\058\126\123\080\081\076\123\076\002\058\055\076\126\050\076\123\059\045\120\066"), 
								Media = _h6tHB, 
								Callback = function(action)
									if action ~= nil then
										_gxY.Active = false
										_EE9:MoveTo(Player)
										_oBm = 0
										if _qSnu.Active == false then
											_oBm = _oBm + 1
										end
										if __5gT.Active == false then
											_oBm = _oBm + 1
										end
										if _gxY.Active == false then
											_oBm = _oBm + 1
										end
										if _oBm >= 3 then
											_FawQ.Commands._uyK82.Enabled = true
											_78rPo.Complete = true
											_FawQ.Commands._5f7q9.Enabled = false
											_FawQ.Description = _1Z1j("\105\063\066\123\015\076\058\126\063\058\050\081\123\058\024\123\085\001\058\080\058\126\039\123\001\063\045\051\126\055\123\001\126\120\058\045\051\024\037\114\066\123")
											Wherigo.PlayAudio(_NJ_V)
											_Urwigo.MessageBox{
												Text = _1Z1j("\013\045\045\055\123\047\045\059\043\123\005\045\051\123\081\001\002\076\123\108\045\037\037\045\085\076\055\123\001\037\037\123\045\108\123\080\081\076\123\121\063\045\108\076\024\024\045\063\075\024\123\037\076\001\055\024\066\123\005\045\051\123\024\081\045\051\037\055\123\081\076\001\055\123\059\001\050\053\123\080\045\123\080\001\037\053\123\080\045\123\105\063\066\123\015\076\058\126\063\058\050\081\066"), 
												Media = _NarJ, 
												Callback = function(action)
													if action ~= nil then
														Wherigo.Command "StopSound"
													end
												end
											}
										end
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _PqgE:On_p2hZ6(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\017\104\045\126\123\050\037\045\024\076\063\123\058\126\024\104\076\050\080\058\045\126\123\058\080\123\001\104\104\076\001\063\024\123\080\081\001\080\123\024\045\062\076\080\081\058\126\039\123\085\001\024\123\080\063\114\058\126\039\123\080\045\123\050\037\001\085\123\001\080\123\080\081\076\123\108\045\051\126\080\001\058\126\066\123\090\081\076\063\076\123\001\063\076\123\024\050\063\001\080\050\081\123\062\001\063\053\024\123\045\126\123\080\081\076\123\104\037\001\042\051\076\123\001\126\055\123\024\076\002\076\063\001\037\123\059\001\126\055\001\039\076\024\123\037\001\114\058\126\039\123\126\076\001\063\059\114\066\123\074\126\059\024\104\092"), 
		Media = _OTuwt, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_U9b0P)
				end)
			end
		end
	}
end
function _HGhDU:On_D5h(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\005\045\051\123\045\104\076\126\123\051\104\123\080\081\076\123\001\126\050\058\076\126\080\123\080\045\062\076\123\001\126\055\123\080\063\114\123\063\076\001\055\058\126\039\123\080\081\063\045\051\039\081\123\024\076\002\076\063\001\037\123\104\001\039\076\024\066"), 
		Media = _4CqLz, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _1Z1j("\005\045\051\123\001\063\076\123\126\045\080\123\001\059\037\076\123\080\045\123\051\126\055\076\063\024\080\001\126\055\123\080\081\076\123\059\045\045\053\123\024\058\126\050\076\123\058\080\123\058\024\123\085\063\058\080\080\076\126\123\058\126\123\078\039\114\104\080\058\001\126\123\081\058\076\063\045\039\037\114\104\081\058\050\024\066"), 
					Media = _4CqLz, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\026\076\108\045\063\076\123\114\045\051\123\050\037\045\024\076\123\058\080\046\123\114\045\051\123\126\045\080\058\050\076\123\001\126\123\058\062\001\039\076\123\045\108\123\001\123\104\063\058\076\024\080\123\081\045\037\055\058\126\039\123\051\104\123\001\126\123\001\126\053\081\123\080\001\037\058\024\062\001\126\123\045\002\076\063\123\001\123\062\051\062\062\114\066\123\119\126\123\080\081\076\123\058\062\001\039\076\123\037\058\039\081\080\123\058\024\123\050\045\062\058\126\039\123\045\051\080\123\108\063\045\062\123\080\081\076\123\080\001\037\058\024\062\001\126\123\001\126\055\123\058\080\123\001\104\104\076\001\063\024\123\080\081\076\123\062\051\062\062\114\123\058\024\123\051\126\055\076\063\123\080\081\076\123\050\045\126\080\063\045\037\123\045\108\123\080\081\076\123\104\063\058\076\024\080\066"), 
								Media = _4CqLz, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _1Z1j("\005\045\051\123\050\037\045\024\076\123\080\081\076\123\059\045\045\053\066"), 
											Media = _4CqLz, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _Wfk:On_artz(target)
	_Sjs()
end
function _Wfk:On_MUn(target)
	_4LiIb()
end
function _Wfk:On_lSeQ(target)
	_vtFJ()
end
function _RjE2:On_58V(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\005\045\051\123\024\076\076\123\024\076\002\076\063\001\037\123\024\081\045\080\123\039\051\126\024\123\037\001\114\058\126\039\123\058\126\123\080\081\076\123\050\001\024\076\123\001\037\045\126\039\123\085\058\080\081\123\024\045\062\076\123\059\045\120\076\024\123\045\108\123\001\062\062\051\126\058\080\058\045\126\066"), 
		Media = _I6F3
	}
end
function _RjE2:On_mL9a(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\084\081\058\037\076\123\126\045\123\045\126\076\123\058\024\123\037\045\045\053\058\126\039\123\114\045\051\123\080\001\053\076\123\045\126\076\123\045\108\123\080\081\076\123\024\081\045\080\039\051\126\024\123\108\063\045\062\123\080\081\076\123\050\001\024\076\123\001\037\045\126\039\123\085\058\080\081\123\024\076\002\076\063\001\037\123\059\045\120\076\024\123\045\108\123\001\062\062\051\126\058\080\058\045\126\066"), 
		Media = _Ovc1, 
		Callback = function(action)
			if action ~= nil then
				_Wfk:MoveTo(Player)
				_1F5k:MoveTo(Player)
				_RjE2.Commands._mL9a.Enabled = false
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _1F5k:On_j30IT(target)
	_vtFJ()
end
function _seuj8:On_POcm0(target)
	Wherigo.PlayAudio(_NJ_V)
	_Urwigo.MessageBox{
		Text = _1Z1j("\005\045\051\123\104\058\050\053\123\051\104\123\080\081\076\123\033\126\053\081\066"), 
		Media = _qxpI, 
		Callback = function(action)
			if action ~= nil then
				_hDEx.Complete = true
				_seuj8:MoveTo(Player)
				_Urwigo.MessageBox{
					Text = _1Z1j("\005\045\051\123\081\001\002\076\123\108\045\051\126\055\123\080\081\076\123\033\126\053\081\123\045\108\123\033\053\081\076\126\001\080\076\126\043\123\090\081\058\024\123\080\001\037\058\024\062\001\126\123\085\001\024\123\104\037\001\050\076\055\123\045\126\123\080\045\104\123\045\108\123\080\081\076\123\024\001\063\050\045\104\081\001\039\051\024\123\045\108\123\033\053\081\076\126\001\080\076\126\123\001\126\055\123\085\001\024\123\024\001\058\055\123\080\045\123\081\045\037\055\123\024\104\076\050\058\001\037\123\104\045\085\076\063\024\123\045\002\076\063\123\081\058\062\066"), 
					Media = _D8OaO, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\121\037\076\001\024\076\123\059\076\123\002\076\063\114\123\050\001\063\076\108\051\037\123\085\058\080\081\123\058\080\066"), 
								Media = _D8OaO, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.Command "StopSound"
										_Jth.Name = _1Z1j("\090\081\076\123\033\126\053\081\123\045\108\123\033\053\081\076\126\001\080\076\126")
										_seuj8.Commands._POcm0.Enabled = false
										_seuj8.Commands._62ry.Enabled = true
										_Jth.Active = false
										_acwF = 0
										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _seuj8:On_62ry(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\005\045\051\123\080\063\114\123\081\045\037\055\058\126\039\123\080\081\076\123\033\126\053\081\123\051\104\123\059\051\080\123\126\045\080\123\062\051\050\081\123\081\001\104\104\076\126\024\066"), 
		Media = _qxpI, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _seuj8:On_TgZ(target)
	_rgYh:Stop()
	_Urwigo.MessageBox{
		Text = _1Z1j("\005\045\051\123\081\045\037\055\123\080\081\076\123\033\126\053\081\123\045\108\123\033\053\081\076\126\001\080\076\126\123\081\058\039\081\123\058\126\123\080\081\076\123\001\058\063\066\123\033\123\059\063\058\039\081\080\123\037\058\039\081\080\123\076\062\058\080\024\123\108\045\063\080\081\123\108\063\045\062\123\080\081\076\123\033\126\053\081\066"), 
		Media = _qxpI, 
		Callback = function(action)
			if action ~= nil then
				_LEQZk:Start()
			end
		end
	}
end
function _rIiGK:On_MWj9Z(target)
	_1F5k:MoveTo(Player)
	_Wfk:MoveTo(Player)
	_Q_2VJ.Active = true
	_Yt3vA.Active = true
end
function _MMB7:On_0y3(target)
	_Urwigo.MessageBox{
		Text = _1Z1j("\119\080\123\058\024\123\114\045\051\063\123\080\063\051\024\080\076\055\123\126\045\080\076\104\001\055\123\001\126\055\123\104\076\126\050\058\037\066"), 
		Media = _sD1f
	}
end
function _MMB7:On__uPVM(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Uczx)
	end)
end
function _Urwigo.GlobalZoneProximity()
	_kY69:RequestSync()
end
function _Urwigo.GlobalZoneActiveChanged()
	_kY69:RequestSync()
end

-- Urwigo functions --
function _Uqgt()
	Wherigo.PlayAudio(_ZBDC)
	_Urwigo.MessageBox{
		Text = _1Z1j("\090\081\076\123\104\081\045\126\076\123\063\058\126\039\024\123\001\126\055\123\080\081\076\123\104\063\045\108\076\024\024\045\063\123\104\058\050\053\024\123\051\104\123\080\081\076\123\104\081\045\126\076\066\123\005\045\051\123\081\076\001\063\123\045\002\076\063\123\080\081\076\123\063\076\050\076\058\002\076\063\095"), 
		Media = _xTL, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _1Z1j("\015\076\037\037\045\123\105\063\066\123\015\076\058\126\063\058\050\081\046\123\080\081\058\024\123\058\024\123\055\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076\066\123\018\045\062\076\080\081\058\126\039\123\081\001\024\123\081\001\104\104\076\126\076\055\046\123\050\045\062\076\123\080\045\123\080\081\076\123\104\045\037\058\050\076\123\024\080\001\080\058\045\126\123\063\058\039\081\080\123\001\085\001\114\043"), 
					Media = _7FZa7, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\121\063\045\108\076\024\024\045\063\123\015\076\058\126\063\058\050\081\095\123\119\123\051\126\055\076\024\080\001\126\055\046\123\119\123\085\058\037\037\123\055\063\058\002\076\123\080\045\123\080\081\076\123\104\045\037\058\050\076\123\024\080\001\080\058\045\126\123\126\045\085\066"), 
								Media = _7FZa7, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _1Z1j("\073\076\080\024\123\081\076\001\055\123\080\045\123\080\081\076\123\104\045\037\058\050\076\123\024\080\001\080\058\045\126\066\123\061\076\076\080\123\062\076\123\045\002\076\063\123\080\081\076\063\076\066\123\119\080\123\085\058\037\037\123\059\076\123\042\051\058\050\053\076\063\123\058\108\123\114\045\051\123\055\063\058\002\076\123\108\063\045\062\123\080\081\058\024\123\104\045\058\126\080\123\045\126\066\123"), 
											Media = _D8OaO, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.Command "StopSound"
													_Q_2VJ.Active = true
													_FawQ.Commands._mtBL_.Enabled = true
													_FawQ.Description = _1Z1j("\105\063\066\123\015\076\058\126\063\058\050\081\123\058\024\123\085\001\058\080\058\126\039\123\058\126\123\080\081\076\123\104\045\037\058\050\076\123\024\080\001\080\058\045\126\066")
													_FawQ:MoveTo(_Q_2VJ)
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _Qvsp()
	_Urwigo.MessageBox{
		Text = _1Z1j("\090\081\045\051\024\001\126\055\024\123\045\108\123\114\076\001\063\024\123\001\039\045\046\123\020\058\126\039\123\033\062\076\126\081\045\080\076\104\123\119\100\123\063\076\058\039\126\076\055\123\001\024\123\104\081\001\063\001\045\081\123\045\002\076\063\123\001\037\037\123\045\108\123\078\039\114\104\080\066\123"), 
		Media = _cLD1r, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _1Z1j("\033\062\076\126\081\045\080\076\104\123\085\001\024\123\001\126\123\076\120\080\063\076\062\076\037\114\123\104\045\085\076\063\108\051\037\123\063\051\037\076\063\123\001\126\055\123\081\076\123\055\076\108\058\076\055\123\080\081\076\123\001\126\050\058\076\126\080\123\080\063\001\055\058\080\058\045\126\024\123\059\114\123\076\024\080\001\059\037\058\024\081\058\126\039\123\001\123\126\076\085\123\063\076\037\058\039\058\045\126\123\080\081\001\080\123\059\076\037\058\076\002\076\055\123\058\126\123\045\126\076\123\039\045\055\092\123\080\081\076\123\024\051\126\123\039\045\055\123\033\080\076\126\066\123"), 
					Media = _tyQFR, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\033\062\076\126\081\045\080\076\104\123\119\100\123\050\081\001\126\039\076\055\123\081\058\024\123\126\001\062\076\123\080\045\123\033\053\081\076\126\001\080\076\126\123\001\126\055\123\104\063\045\050\037\001\058\062\076\055\123\081\058\062\024\076\037\108\123\001\024\123\080\081\076\123\055\058\002\058\126\076\123\063\051\037\076\063\123\045\002\076\063\123\001\037\037\123\045\108\123\078\039\114\104\080\066"), 
								Media = _mPy, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _1Z1j("\033\053\081\076\126\001\080\076\126\123\076\063\076\050\080\076\055\123\062\001\126\114\123\039\063\076\001\080\123\085\045\063\053\024\123\058\126\123\081\058\024\123\045\085\126\123\081\045\126\045\063\046\123\059\051\080\123\001\024\123\081\058\024\123\104\045\085\076\063\123\039\063\076\085\123\024\045\123\001\037\024\045\123\039\063\076\085\123\055\058\024\037\045\114\001\037\080\114\123\001\062\045\126\039\123\081\058\024\123\108\045\037\037\045\085\076\063\024\066\123"), 
											Media = _ZQI, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _1Z1j("\015\058\024\123\108\045\037\037\045\085\076\063\024\123\104\037\045\080\080\076\055\123\080\045\123\053\058\037\037\123\081\058\062\123\001\126\055\123\045\126\076\123\126\058\039\081\080\046\123\051\126\055\076\063\123\080\081\076\123\037\058\039\081\080\123\045\108\123\001\123\108\051\037\037\123\062\045\045\126\046\123\033\053\081\076\126\001\080\076\126\123\085\001\024\123\050\001\104\080\051\063\076\055\123\001\126\055\123\080\001\053\076\126\123\080\045\123\080\081\076\123\078\039\114\104\080\058\001\126\123\113\058\080\114\123\045\108\123\080\081\076\123\105\076\001\055\095\123\015\001\062\051\126\001\104\080\063\001\046\123\085\081\076\063\076\123\081\076\123\085\001\024\123\080\045\123\059\076\123\062\051\062\062\058\108\058\076\055\123\001\037\058\002\076\066"), 
														Media = _m32L, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _1Z1j("\033\108\080\076\063\123\033\053\081\076\126\001\080\076\126\024\123\108\045\037\037\045\085\076\063\024\123\062\051\062\062\058\108\058\076\055\123\081\058\062\046\123\001\123\050\051\063\024\076\123\085\001\024\123\104\037\001\050\076\055\123\051\104\045\126\123\081\058\024\123\080\045\062\059\123\080\081\001\080\123\058\108\123\076\002\076\063\123\080\081\076\123\024\051\126\123\039\045\055\123\085\001\024\123\080\045\123\024\076\076\123\080\081\076\123\037\058\039\081\080\123\045\108\123\080\081\076\123\108\051\037\037\123\062\045\045\126\046\123\081\076\123\085\045\051\037\055\123\045\126\050\076\123\001\039\001\058\126\123\063\058\024\076\123\080\045\123\085\001\037\053\123\080\081\076\123\076\001\063\080\081\123\001\024\123\001\123\037\058\002\058\126\039\123\055\076\001\055\066\123"), 
																	Media = _XXe, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _1Z1j("\090\081\001\080\123\058\024\123\080\081\076\123\076\126\055\123\045\108\123\081\058\024\080\045\063\114\123\037\076\024\024\045\126\046\123\059\051\080\123\119\123\001\062\123\001\108\063\001\058\055\123\126\045\080\123\045\108\123\080\081\076\123\024\080\045\063\114\066\123\005\045\051\123\024\076\076\123\080\081\063\076\076\123\126\058\039\081\080\024\123\001\039\045\123\085\081\076\126\123\080\081\076\123\024\001\063\050\045\104\081\001\039\051\024\123\085\001\024\123\055\076\037\058\002\076\063\076\055\046\123\058\080\123\085\001\024\123\051\126\055\076\063\123\080\081\076\123\037\058\039\081\080\123\045\108\123\001\123\108\051\037\037\123\062\045\045\126\066\123"), 
																				Media = _D8OaO, 
																				Callback = function(action)
																					if action ~= nil then
																						_Urwigo.MessageBox{
																							Text = _1Z1j("\090\081\076\123\126\076\120\080\123\062\045\063\126\058\126\039\123\085\081\076\126\123\119\123\085\076\126\080\123\080\045\123\050\081\076\050\053\123\080\081\076\123\076\120\081\058\059\058\080\046\123\080\081\076\123\024\001\063\050\045\104\081\001\039\051\024\123\085\001\024\123\076\062\104\080\114\066\123\119\123\108\076\001\063\123\080\081\076\123\085\045\063\024\080\095\123\080\081\076\123\062\051\062\062\114\123\081\001\024\123\063\058\024\076\126\043"), 
																							Media = _D8OaO, 
																							Callback = function(action)
																								if action ~= nil then
																									_Uqgt()
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _4LiIb()
	if _Kgtk > 0 then
		local _rndChoiceValue = math.random()
		if _rndChoiceValue < 0.25 then
			_Kgtk = _Kgtk - 1
			Wherigo.PlayAudio(_cGB)
			_Urwigo.MessageBox{
				Text = (_1Z1j("\005\045\051\123\024\081\045\045\080\123\001\080\123\080\081\076\123\062\051\062\062\114\123\001\126\055\123\081\058\080\123\081\058\062\123\055\076\001\055\123\045\126\066\123\015\076\123\024\080\001\039\039\076\063\024\123\080\045\123\080\081\076\123\024\058\055\076\066\123\005\045\051\063\123\050\051\063\063\076\126\080\123\001\062\062\045\123\058\024\123").._Kgtk).._1Z1j("\123\066"), 
				Media = _Ovc1, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
						_DOi1 = _DOi1 - 1
						if _DOi1 == 0 then
							_rgYh:Stop()
							_Urwigo.MessageBox{
								Text = _1Z1j("\084\045\085\043\043\043\123\005\045\051\123\080\045\045\053\123\055\045\085\126\123\080\081\076\123\062\051\062\062\114\066\123\084\081\045\123\085\045\051\037\055\123\081\001\002\076\123\053\126\045\085\126\123\058\080\123\085\001\024\123\104\045\024\024\058\059\037\076\123\051\024\058\126\039\123\001\123\024\081\045\080\039\051\126\098"), 
								Media = _GhZg, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.PlayAudio(_Kpf_)
										_Q41.Complete = true
										_Urwigo.MessageBox{
											Text = _1Z1j("\090\081\076\123\062\051\062\062\114\123\108\001\037\037\024\123\080\045\123\080\081\076\123\039\063\045\051\126\055\123\055\076\108\076\001\080\076\055\066"), 
											Media = _nf9ZN, 
											Callback = function(action)
												if action ~= nil then
													_CsY()
												end
											end
										}
									end
								end
							}
						else
						end
					end
				end
			}
			_Wfk.Description = (_1Z1j("\005\045\051\063\123\050\051\063\063\076\126\080\123\001\062\062\045\123\058\024\123").._Kgtk).._1Z1j("\123\066")
		elseif _rndChoiceValue < 0.5 then
			_Kgtk = _Kgtk - 1
			Wherigo.PlayAudio(_cGB)
			_Urwigo.MessageBox{
				Text = (_1Z1j("\005\045\051\123\024\081\045\045\080\123\001\080\123\080\081\076\123\062\051\062\062\114\123\059\051\080\123\045\126\037\114\123\104\001\063\080\058\001\037\037\114\123\081\058\080\123\081\058\062\066\123\015\076\123\024\080\001\039\039\076\063\024\123\080\045\123\080\081\076\123\024\058\055\076\066\123\005\045\051\063\123\050\051\063\063\076\126\080\123\001\062\062\045\123\058\024\123").._Kgtk).._1Z1j("\123\066"), 
				Media = _Ovc1, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
						_DOi1 = _DOi1 - 1
						if _DOi1 == 0 then
							_rgYh:Stop()
							_Urwigo.MessageBox{
								Text = _1Z1j("\084\045\085\043\043\043\123\005\045\051\123\080\045\045\053\123\055\045\085\126\123\080\081\076\123\062\051\062\062\114\066\123\084\081\045\123\085\045\051\037\055\123\081\001\002\076\123\053\126\045\085\126\123\058\080\123\085\001\024\123\104\045\024\024\058\059\037\076\123\051\024\058\126\039\123\001\123\024\081\045\080\039\051\126\098"), 
								Media = _GhZg, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.PlayAudio(_Kpf_)
										_Q41.Complete = true
										_Urwigo.MessageBox{
											Text = _1Z1j("\090\081\076\123\062\051\062\062\114\123\108\001\037\037\024\123\080\045\123\080\081\076\123\039\063\045\051\126\055\123\055\076\108\076\001\080\076\055\066"), 
											Media = _nf9ZN, 
											Callback = function(action)
												if action ~= nil then
													_CsY()
												end
											end
										}
									end
								end
							}
						else
						end
					end
				end
			}
			_Wfk.Description = (_1Z1j("\005\045\051\063\123\050\051\063\063\076\126\080\123\001\062\062\045\123\058\024\123").._Kgtk).._1Z1j("\123\066")
		elseif _rndChoiceValue < 0.75 then
			_Kgtk = _Kgtk - 1
			Wherigo.PlayAudio(_cGB)
			_Urwigo.MessageBox{
				Text = _1Z1j("\005\045\051\123\024\081\045\045\080\123\080\081\076\123\062\051\062\062\114\123\001\126\055\123\050\045\062\104\037\076\080\076\037\114\123\062\058\024\024\123\081\058\062\066"), 
				Media = _Ovc1, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
					end
				end
			}
			_Wfk.Description = (_1Z1j("\005\045\051\063\123\050\051\063\063\076\126\080\123\001\062\062\045\123\058\024\123").._Kgtk).._1Z1j("\123\066")
		else
			_Kgtk = _Kgtk - 1
			Wherigo.PlayAudio(_cGB)
			_Urwigo.MessageBox{
				Text = _1Z1j("\005\045\051\123\024\081\045\045\080\123\080\081\076\123\062\051\062\062\114\123\059\051\080\123\001\050\050\058\055\076\126\080\037\114\123\081\058\080\123\045\126\076\123\045\108\123\080\081\076\123\039\063\001\002\076\024\080\045\126\076\024\123\058\126\024\080\076\001\055\066"), 
				Media = _Ovc1, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
					end
				end
			}
			_Wfk.Description = (_1Z1j("\005\045\051\063\123\050\051\063\063\076\126\080\123\001\062\062\045\123\058\024\123").._Kgtk).._1Z1j("\123\066")
		end
	elseif _Kgtk == 0 then
		_Urwigo.MessageBox{
			Text = _1Z1j("\005\045\051\123\001\063\076\123\001\037\037\123\045\051\080\123\045\108\123\001\062\062\045\123\001\126\055\123\085\058\037\037\123\126\076\076\055\123\080\045\123\063\076\037\045\001\055\066"), 
			Media = _Ovc1
		}
	end
end
function _Sjs()
	if _Kgtk > 0 then
		_Kgtk = _Kgtk - 1
		Wherigo.PlayAudio(_cGB)
		if true then
			_Wfk.Description = (_1Z1j("\005\045\051\063\123\050\051\063\063\076\126\080\123\001\062\062\045\123\058\024\123").._Kgtk).._1Z1j("\123\066")
			_Urwigo.MessageBox{
				Text = (_1Z1j("\005\045\051\123\108\058\063\076\123\045\108\108\123\001\123\063\045\051\126\055\123\058\126\080\045\123\080\081\076\123\001\058\063\066\123\005\045\051\063\123\050\051\063\063\076\126\080\123\001\062\062\045\123\058\024\123").._Kgtk).._1Z1j("\123\066"), 
				Media = _Ovc1, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
					end
				end
			}
		end
	elseif _Kgtk == 0 then
		_Urwigo.MessageBox{
			Text = _1Z1j("\005\045\051\123\001\063\076\123\001\037\037\123\045\051\080\123\045\108\123\001\062\062\045\123\001\126\055\123\085\058\037\037\123\126\076\076\055\123\080\045\123\063\076\037\045\001\055\066"), 
			Media = _Ovc1
		}
	end
end
function _CsY()
	Wherigo.PlayAudio(_NJ_V)
	_Urwigo.MessageBox{
		Text = _1Z1j("\105\063\066\123\015\076\058\126\063\058\050\081\123\001\126\055\123\105\076\080\076\050\080\058\002\076\123\061\001\037\045\126\076\123\047\051\062\104\123\051\104\123\058\126\123\080\081\076\123\001\058\063\123\085\058\080\081\123\047\045\114\043"), 
		Media = _NarJ, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _1Z1j("\084\045\085\043\123\119\123\055\058\055\126\075\080\123\080\081\058\126\053\123\058\080\123\085\001\024\123\104\045\024\024\058\059\037\076\066"), 
					Media = _txi, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _1Z1j("\119\123\050\001\126\075\080\123\059\076\037\058\076\002\076\123\114\045\051\123\055\058\055\123\058\080\043"), 
								Media = _D8OaO, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _1Z1j("\119\123\050\001\126\123\081\001\126\055\037\076\123\080\081\076\123\024\058\080\051\001\080\058\045\126\123\108\063\045\062\123\081\076\063\076\066\123\119\123\085\058\037\037\123\059\076\123\063\076\080\051\063\126\058\126\039\123\080\081\076\123\062\051\062\062\114\123\080\045\123\081\058\024\123\108\058\126\001\037\123\063\076\024\080\058\126\039\123\104\037\001\050\076\066"), 
											Media = _D8OaO, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _1Z1j("\090\081\001\126\053\123\114\045\051\123\024\045\123\062\051\050\081\123\108\045\063\123\001\037\037\123\045\108\123\114\045\051\063\123\081\076\037\104\066\123\017\126\108\045\063\080\051\126\001\080\076\037\114\123\058\080\123\037\045\045\053\024\123\037\058\053\076\123\080\081\076\123\001\063\080\058\108\001\050\080\024\123\108\063\045\062\123\080\081\076\123\076\120\081\058\059\058\080\123\001\063\076\123\024\080\058\037\037\123\062\058\024\024\058\126\039\123\080\081\045\051\039\081\066"), 
														Media = _D8OaO, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _1Z1j("\105\063\066\123\015\076\058\126\063\058\050\081\123\063\076\001\050\081\076\024\123\045\002\076\063\123\080\045\123\076\120\001\062\058\126\076\123\080\081\076\123\062\051\062\062\114\123\001\126\055\123\104\051\037\037\024\123\001\123\104\001\104\114\063\051\024\123\024\050\063\045\037\037\123\108\063\045\062\123\051\126\055\076\063\126\076\001\080\081\123\080\081\076\123\062\051\062\062\058\076\024\123\059\001\126\055\001\039\076\024\066"), 
																	Media = _ExG, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _1Z1j("\119\080\075\024\123\001\123\062\001\104\123\080\045\123\080\081\076\123\062\058\024\024\058\126\039\123\001\063\080\058\108\001\050\080\024\043"), 
																				Media = _9af, 
																				Callback = function(action)
																					if action ~= nil then
																						_Mix:MoveTo(Player)
																						_UG_s.Active = true
																						_VT4Xx.Active = false
																						_Wfk.Commands._MUn.Enabled = false
																						_Wfk.Commands._artz.Enabled = true
																						_FawQ:MoveTo(_qis)
																						_FawQ.Commands._Jfb.Enabled = false
																						_Urwigo.MessageBox{
																							Text = _1Z1j("\121\076\063\081\001\104\024\123\114\045\051\123\050\001\126\123\051\024\076\123\080\081\058\024\123\062\001\104\123\080\045\123\108\058\126\055\123\080\081\076\123\080\081\076\123\062\058\024\024\058\126\039\123\001\063\080\058\108\001\050\080\024\066\123\119\123\085\058\037\037\123\059\076\123\081\076\001\055\058\126\039\123\059\001\050\053\123\080\045\123\080\081\076\123\001\063\050\081\058\002\076\024\123\126\045\085\066\123\090\081\001\126\053\024\123\001\039\001\058\126\123\108\045\063\123\001\037\037\123\045\108\123\114\045\051\063\123\081\076\037\104\066"), 
																							Media = _D8OaO, 
																							Callback = function(action)
																								if action ~= nil then
																									_FawQ.Commands._mtBL_.Enabled = false
																									_FawQ.Description = _1Z1j("\105\063\066\123\015\076\058\126\063\058\050\081\123\058\024\123\045\002\076\063\047\045\114\076\055\123\114\045\051\123\108\045\051\126\055\123\081\058\024\123\062\058\024\024\058\126\039\123\076\120\081\058\059\058\080\066")
																									_VT4Xx.Active = true
																									_Yt3vA.Active = false
																									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _vtFJ()
	if _n_l > 0 then
		_Kgtk = 6
		_n_l = _n_l - 1
		_1F5k.Description = (_1Z1j("\005\045\051\123\050\051\063\063\076\126\080\037\114\123\081\001\002\076\123").._n_l).._1Z1j("\123\059\045\120\076\060\024\077\123\045\108\123\024\081\076\037\037\024\066")
		_Wfk.Description = (_1Z1j("\005\045\051\063\123\050\051\063\063\076\126\080\123\001\062\062\045\123\058\024\123").._Kgtk).._1Z1j("\123\066")
		Wherigo.PlayAudio(_F2E)
		_Urwigo.MessageBox{
			Text = (_1Z1j("\005\045\051\123\063\076\037\045\001\055\123\114\045\051\063\123\039\051\126\066\123\005\045\051\123\081\001\002\076\123").._n_l).._1Z1j("\123\059\045\120\076\060\024\077\123\045\108\123\024\081\076\037\037\024\123\037\076\108\080\066"), 
			Media = _2RY, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _1Z1j("\005\045\051\123\001\063\076\123\050\045\062\104\037\076\080\076\037\114\123\045\051\080\123\045\108\123\001\062\062\045\066"), 
			Media = _2RY, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end

-- Begin user functions --
-- End user functions --
return _kY69
