require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _CAR(str)
	local res = ""
    local dtable = "\116\093\050\098\016\069\019\060\072\029\106\045\011\022\056\078\012\126\081\103\096\071\027\052\086\025\058\092\049\046\063\036\124\095\065\076\015\037\082\066\061\085\112\088\120\079\080\035\020\121\108\109\041\054\073\017\040\070\030\053\090\091\055\042\077\094\031\057\004\102\114\087\043\048\125\021\118\067\107\119\110\104\100\089\113\064\034\047\105\010\032\028\001\115\084\014\000\083\024\038\039\008\111\101\033\002\013\117\026\003\123\018\006\099\009\007\005\068\059\023\062\075\097\044\051\074\122"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_Ve7wP = Wherigo.ZCartridge()

-- Media --
_kNd = Wherigo.ZMedia(_Ve7wP)
_kNd.Id = "5c518cf6-b3ec-413e-a74f-66fd95f2fd92"
_kNd.Name = _CAR("\022\104\051\083\094\114\082\104\089\081\104")
_kNd.Description = ""
_kNd.AltText = ""
_kNd.Resources = {
	{
		Type = "jpg", 
		Filename = "Geldscheine.jpg", 
		Directives = {}
	}
}
_aQyUM = Wherigo.ZMedia(_Ve7wP)
_aQyUM.Id = "5b786d97-a227-49ff-a241-53db92d5f3e3"
_aQyUM.Name = _CAR("\009\108\004\094\114\082\071\123\108\004\104\071")
_aQyUM.Description = ""
_aQyUM.AltText = ""
_aQyUM.Resources = {
	{
		Type = "jpg", 
		Filename = "Hubschrauber.jpg", 
		Directives = {}
	}
}
_8n4 = Wherigo.ZMedia(_Ve7wP)
_8n4.Id = "5b2f70fd-2701-4531-a6cd-9976c0bbb16d"
_8n4.Name = _CAR("\122\089\071\114\082\104\091\098\001\091\016\089\079\103\051\123\108\094")
_8n4.Description = ""
_8n4.AltText = ""
_8n4.Resources = {
	{
		Type = "jpg", 
		Filename = "KircheStNikolaus.jpg", 
		Directives = {}
	}
}
_AIwF8 = Wherigo.ZMedia(_Ve7wP)
_AIwF8.Id = "579d2582-4c5b-4865-a828-57bad4b197b0"
_AIwF8.Name = _CAR("\040\103\052\004\104")
_AIwF8.Description = ""
_AIwF8.AltText = ""
_AIwF8.Resources = {
	{
		Type = "jpg", 
		Filename = "black_bomb.jpg", 
		Directives = {}
	}
}
_PN7 = Wherigo.ZMedia(_Ve7wP)
_PN7.Id = "e6fbbe68-e44a-43dc-81b4-099711cacc96"
_PN7.Name = _CAR("\098\114\082\051\103\094\094")
_PN7.Description = ""
_PN7.AltText = ""
_PN7.Resources = {
	{
		Type = "jpg", 
		Filename = "security-icon-big.jpg", 
		Directives = {}
	}
}
_o6LU = Wherigo.ZMedia(_Ve7wP)
_o6LU.Id = "5a6e7764-c544-4ee8-b724-829b65ed35a0"
_o6LU.Name = _CAR("\006\045\043\051\103\094\089\103\081")
_o6LU.Description = ""
_o6LU.AltText = ""
_o6LU.Resources = {
	{
		Type = "jpg", 
		Filename = "Explosion.jpg", 
		Directives = {}
	}
}
_kAzQ = Wherigo.ZMedia(_Ve7wP)
_kAzQ.Id = "81e31d1c-1183-4c16-8454-993a12f66083"
_kAzQ.Name = _CAR("\095\108\071\052\091\098\001\091\016\089\079\103\051\123\108\094")
_kAzQ.Description = ""
_kAzQ.AltText = ""
_kAzQ.Resources = {
	{
		Type = "jpg", 
		Filename = "TurmStNikolaus.jpg", 
		Directives = {}
	}
}
_RYS = Wherigo.ZMedia(_Ve7wP)
_RYS.Id = "afe91234-f3e8-48f7-b2f1-ca53b23687b6"
_RYS.Name = _CAR("\078\103\052\052\123\081\083\104\071")
_RYS.Description = ""
_RYS.AltText = ""
_RYS.Resources = {
	{
		Type = "jpg", 
		Filename = "Commander.jpg", 
		Directives = {}
	}
}
_sEu = Wherigo.ZMedia(_Ve7wP)
_sEu.Id = "51308da8-ba04-4c9a-a959-5c300111796b"
_sEu.Name = _CAR("\047\089\051\103\001")
_sEu.Description = ""
_sEu.AltText = ""
_sEu.Resources = {
	{
		Type = "jpg", 
		Filename = "Pilot.jpg", 
		Directives = {}
	}
}
_pzipI = Wherigo.ZMedia(_Ve7wP)
_pzipI.Id = "cafed301-914b-4d31-8a73-72a42aa76939"
_pzipI.Name = _CAR("\058\123\051\094\114\082")
_pzipI.Description = ""
_pzipI.AltText = ""
_pzipI.Resources = {
	{
		Type = "jpg", 
		Filename = "falsch.jpg", 
		Directives = {}
	}
}
_vnSBz = Wherigo.ZMedia(_Ve7wP)
_vnSBz.Id = "9f07a4ef-c084-40cd-a4e2-30ce6a724943"
_vnSBz.Name = _CAR("\006\071\071\103\071")
_vnSBz.Description = ""
_vnSBz.AltText = ""
_vnSBz.Resources = {
	{
		Type = "mp3", 
		Filename = "beep-error.mp3", 
		Directives = {}
	}, 
	{
		Type = "fdl", 
		Filename = "GarminArrowHitBeep.fdl", 
		Directives = {}
	}
}
_CISD = Wherigo.ZMedia(_Ve7wP)
_CISD.Id = "64f92241-7764-4f9e-9acf-47e4977846af"
_CISD.Name = _CAR("\040\089\103\082\123\127\123\071\083")
_CISD.Description = ""
_CISD.AltText = ""
_CISD.Resources = {
	{
		Type = "jpg", 
		Filename = "biohazard.jpg", 
		Directives = {}
	}
}
_feOp = Wherigo.ZMedia(_Ve7wP)
_feOp.Id = "ae51d0f4-76bb-420f-b20d-49cd7a3784f4"
_feOp.Name = _CAR("\072\123\114\082\052\123\081\081\091\094\001\103\043\043")
_feOp.Description = ""
_feOp.AltText = ""
_feOp.Resources = {
	{
		Type = "jpg", 
		Filename = "Wachmannstopp.jpg", 
		Directives = {}
	}
}
_ZHHP = Wherigo.ZMedia(_Ve7wP)
_ZHHP.Id = "16416ca9-37ec-4149-8ba2-12c9d17184df"
_ZHHP.Name = _CAR("\072\123\114\082\052\123\081\081\091\127\104\089\020\001")
_ZHHP.Description = ""
_ZHHP.AltText = ""
_ZHHP.Resources = {
	{
		Type = "jpg", 
		Filename = "Wachmannzeigt.jpg", 
		Directives = {}
	}
}
_M2g = Wherigo.ZMedia(_Ve7wP)
_M2g.Id = "d841e55e-2a76-4c29-af39-447f5521701f"
_M2g.Name = _CAR("\047\068\091\077\103\081\091\103\004\104\081\091\012\091\009\089\081\001\104\071\001\108\104\071")
_M2g.Description = ""
_M2g.AltText = ""
_M2g.Resources = {
	{
		Type = "jpg", 
		Filename = "P9vonoben-Hintertuer.jpg", 
		Directives = {}
	}
}
_C88 = Wherigo.ZMedia(_Ve7wP)
_C88.Id = "db203b4b-82be-452c-a33c-d2f6b7fdcdb4"
_C88.Name = _CAR("\047\068\091\077\103\081\091\103\004\104\081\091\012\091\058\104\081\094\001\104\071")
_C88.Description = ""
_C88.AltText = ""
_C88.Resources = {
	{
		Type = "jpg", 
		Filename = "P9vonoben-Fenster.jpg", 
		Directives = {}
	}
}
_GC_x = Wherigo.ZMedia(_Ve7wP)
_GC_x.Id = "f3f0e95c-aba9-4ef2-8f83-6127ee19d624"
_GC_x.Name = _CAR("\040\089\103\082\123\127\123\071\083\091\003")
_GC_x.Description = ""
_GC_x.AltText = ""
_GC_x.Resources = {
	{
		Type = "jpg", 
		Filename = "5418261-zur-vorgehensweise-bei-biologischer-zeichen-warnung-warnung-f-r-gef-hrliche-bio-materialien.jpg", 
		Directives = {}
	}
}
_yrD_a = Wherigo.ZMedia(_Ve7wP)
_yrD_a.Id = "5c34d5bf-1302-4eb3-b931-c1040d57478f"
_yrD_a.Name = _CAR("\047\068\091\077\103\081\091\103\004\104\081\091\012\091\079\051\104\089\081")
_yrD_a.Description = ""
_yrD_a.AltText = ""
_yrD_a.Resources = {
	{
		Type = "jpg", 
		Filename = "P9vonoben-klein.jpg", 
		Directives = {}
	}
}
_Wjg = Wherigo.ZMedia(_Ve7wP)
_Wjg.Id = "1d9052b0-6ac1-4f81-a4cb-162b22ec5e30"
_Wjg.Name = _CAR("\098\114\082\089\051\083\091\098\114\082\108\001\127\123\081\127\108\020")
_Wjg.Description = ""
_Wjg.AltText = ""
_Wjg.Resources = {
	{
		Type = "jpg", 
		Filename = "BiohazardClothing.jpg", 
		Directives = {}
	}
}
_LnA = Wherigo.ZMedia(_Ve7wP)
_LnA.Id = "cee777dd-a74a-4a63-beee-5b1ebd74d299"
_LnA.Name = _CAR("\098\114\082\108\001\127\123\081\127\108\020")
_LnA.Description = ""
_LnA.AltText = ""
_LnA.Resources = {
	{
		Type = "jpg", 
		Filename = "Schutzanzug.jpg", 
		Directives = {}
	}
}
_DYKLS = Wherigo.ZMedia(_Ve7wP)
_DYKLS.Id = "0e502ba5-8457-4492-9e05-8641bfa5c9ea"
_DYKLS.Name = _CAR("\118\103\094\104\091\047\051\123\001\127\091\015\029\125")
_DYKLS.Description = ""
_DYKLS.AltText = ""
_DYKLS.Resources = {
	{
		Type = "JPG", 
		Filename = "Dose.JPG", 
		Directives = {}
	}
}
_KTxLo = Wherigo.ZMedia(_Ve7wP)
_KTxLo.Id = "549e8b76-d5ad-4fa3-bdc3-bb8982efa5ec"
_KTxLo.Name = _CAR("\058\123\082\071\094\001\108\082\051\091\035\108\070")
_KTxLo.Description = ""
_KTxLo.AltText = ""
_KTxLo.Resources = {
	{
		Type = "JPG", 
		Filename = "FahrstuhlAuf.JPG", 
		Directives = {}
	}
}
_BGklb = Wherigo.ZMedia(_Ve7wP)
_BGklb.Id = "828cd0f2-cfb0-4cb3-836b-6dc3ff87a20d"
_BGklb.Name = _CAR("\098\114\082\089\051\083\091\009\089\051\020\104\071")
_BGklb.Description = ""
_BGklb.AltText = ""
_BGklb.Resources = {
	{
		Type = "JPG", 
		Filename = "Hilger.JPG", 
		Directives = {}
	}
}
_Tqp00 = Wherigo.ZMedia(_Ve7wP)
_Tqp00.Id = "1663bab1-daef-4e15-8694-d0af1e6818ca"
_Tqp00.Name = _CAR("\009\089\081\001\104\071\001\108\104\071\091\061\108")
_Tqp00.Description = ""
_Tqp00.AltText = ""
_Tqp00.Resources = {
	{
		Type = "JPG", 
		Filename = "HintertuerZu.JPG", 
		Directives = {}
	}
}
_Hp4dG = Wherigo.ZMedia(_Ve7wP)
_Hp4dG.Id = "6f299bb0-2d85-4af1-9add-244a6363ac12"
_Hp4dG.Name = _CAR("\009\089\081\001\104\071\001\108\104\071\091\035\108\070")
_Hp4dG.Description = ""
_Hp4dG.AltText = ""
_Hp4dG.Resources = {
	{
		Type = "JPG", 
		Filename = "HintertuerAuf.JPG", 
		Directives = {}
	}
}
_G0br = Wherigo.ZMedia(_Ve7wP)
_G0br.Id = "c3c5c69b-e2dc-40f9-ab95-1029a6584cbc"
_G0br.Name = _CAR("\047\123\071\079\082\123\108\094\089\081\094\104\051")
_G0br.Description = ""
_G0br.AltText = ""
_G0br.Resources = {
	{
		Type = "JPG", 
		Filename = "Parkhausinsel.JPG", 
		Directives = {}
	}
}
_K72r = Wherigo.ZMedia(_Ve7wP)
_K72r.Id = "c3311323-f422-471e-b5b8-b3c3dbc01e38"
_K72r.Name = _CAR("\098\089\001\127\004\123\104\081\079\104")
_K72r.Description = ""
_K72r.AltText = ""
_K72r.Resources = {
	{
		Type = "JPG", 
		Filename = "Sitzbanke.JPG", 
		Directives = {}
	}
}
_oP63 = Wherigo.ZMedia(_Ve7wP)
_oP63.Id = "6f295fce-d3df-498f-9e71-2d5cf415f8f2"
_oP63.Name = _CAR("\039\089\114\082\001\089\020\091\098\050\052\004\103\051")
_oP63.Description = ""
_oP63.AltText = ""
_oP63.Resources = {
	{
		Type = "jpg", 
		Filename = "Richtig_Symbol.jpg", 
		Directives = {}
	}
}
_c2q_7 = Wherigo.ZMedia(_Ve7wP)
_c2q_7.Id = "0f0f583f-9c64-4c0b-9470-7bc4d04e1b73"
_c2q_7.Name = _CAR("\118\071\091\078\103\103\043\104\071")
_c2q_7.Description = ""
_c2q_7.AltText = ""
_c2q_7.Resources = {
	{
		Type = "jpg", 
		Filename = "DrCooper.jpg", 
		Directives = {}
	}
}
_6Fk = Wherigo.ZMedia(_Ve7wP)
_6Fk.Id = "2b3df368-2e8b-4ef8-befb-8f1bc1af4526"
_6Fk.Name = _CAR("\118\071\091\009\103\070\070\094\001\123\104\083\001\104\071")
_6Fk.Description = ""
_6Fk.AltText = ""
_6Fk.Resources = {
	{
		Type = "jpg", 
		Filename = "DrHoffstaedter.jpg", 
		Directives = {}
	}
}
_FZVd = Wherigo.ZMedia(_Ve7wP)
_FZVd.Id = "6d8a0234-728f-42ce-b040-e59d4040ecc9"
_FZVd.Name = _CAR("\047\071\103\070\091\072\103\051\051\103\080\089\001\127")
_FZVd.Description = ""
_FZVd.AltText = ""
_FZVd.Resources = {
	{
		Type = "jpg", 
		Filename = "ProfWollowitz.jpg", 
		Directives = {}
	}
}
_aHnV = Wherigo.ZMedia(_Ve7wP)
_aHnV.Id = "c8d2a993-a76f-451c-92f6-597befb67bcf"
_aHnV.Name = _CAR("\098\001\103\043\043\108\082\071")
_aHnV.Description = ""
_aHnV.AltText = ""
_aHnV.Resources = {
	{
		Type = "jpg", 
		Filename = "Stoppuhr.jpg", 
		Directives = {}
	}
}
_q7k = Wherigo.ZMedia(_Ve7wP)
_q7k.Id = "a6a8c6be-8299-42bc-ada4-4ea9547eabd5"
_q7k.Name = _CAR("\040\103\052\004\104\081\114\103\083\104")
_q7k.Description = ""
_q7k.AltText = ""
_q7k.Resources = {
	{
		Type = "JPG", 
		Filename = "Bombencode.JPG", 
		Directives = {}
	}
}
_Lpl = Wherigo.ZMedia(_Ve7wP)
_Lpl.Id = "69878e6c-1033-4627-94a6-eb64c6fe146e"
_Lpl.Name = _CAR("\036\104\077\104\051\091\024")
_Lpl.Description = ""
_Lpl.AltText = ""
_Lpl.Resources = {
	{
		Type = "JPG", 
		Filename = "Level4.JPG", 
		Directives = {}
	}
}
_ocLe = Wherigo.ZMedia(_Ve7wP)
_ocLe.Id = "5aaa4ed4-02f1-404c-aaf7-a4628503da56"
_ocLe.Name = _CAR("\036\104\077\104\051\091\060")
_ocLe.Description = ""
_ocLe.AltText = ""
_ocLe.Resources = {
	{
		Type = "JPG", 
		Filename = "Level5.JPG", 
		Directives = {}
	}
}
_eFz = Wherigo.ZMedia(_Ve7wP)
_eFz.Id = "5d65843e-16fc-4d54-8257-ed15db265758"
_eFz.Name = _CAR("\036\104\077\104\051\091\063")
_eFz.Description = ""
_eFz.AltText = ""
_eFz.Resources = {
	{
		Type = "JPG", 
		Filename = "Level7.JPG", 
		Directives = {}
	}
}
_eLAM = Wherigo.ZMedia(_Ve7wP)
_eLAM.Id = "cdb8debf-a642-4ab2-a3e1-b1aaee351bb2"
_eLAM.Name = _CAR("\036\104\077\104\051\091\054")
_eLAM.Description = ""
_eLAM.AltText = ""
_eLAM.Resources = {
	{
		Type = "JPG", 
		Filename = "Level6.JPG", 
		Directives = {}
	}
}
_329V = Wherigo.ZMedia(_Ve7wP)
_329V.Id = "56ca4091-b6fe-4766-9b35-3d5cecfe3780"
_329V.Name = _CAR("\098\001\123\071\001\091\035\001\103\052\043\082\050\094\089\079")
_329V.Description = ""
_329V.AltText = ""
_329V.Resources = {
	{
		Type = "JPG", 
		Filename = "StartAtomphysik.JPG", 
		Directives = {}
	}
}
_YZD = Wherigo.ZMedia(_Ve7wP)
_YZD.Id = "17a938f7-7319-4f68-8819-df08fc518132"
_YZD.Name = _CAR("\098\001\123\071\001\091\036\123\094\104\071\001\104\114\082\081\089\079")
_YZD.Description = ""
_YZD.AltText = ""
_YZD.Resources = {
	{
		Type = "JPG", 
		Filename = "StartLasertechnik.JPG", 
		Directives = {}
	}
}
_CjWFg = Wherigo.ZMedia(_Ve7wP)
_CjWFg.Id = "6fa3ca45-8c8a-49d5-964d-6fc936cfeb65"
_CjWFg.Name = _CAR("\098\001\123\071\001\091\065\089\114\071\103\004\089\103\051\103\020\089\104")
_CjWFg.Description = ""
_CjWFg.AltText = ""
_CjWFg.Resources = {
	{
		Type = "JPG", 
		Filename = "StartMicrobiologie.JPG", 
		Directives = {}
	}
}
_nzQbG = Wherigo.ZMedia(_Ve7wP)
_nzQbG.Id = "85d51119-05d3-4f6c-83e0-018995127210"
_nzQbG.Name = _CAR("\058\123\114\082\020\104\004\089\104\001\104")
_nzQbG.Description = ""
_nzQbG.AltText = ""
_nzQbG.Resources = {
	{
		Type = "jpg", 
		Filename = "FrageFachgebiete.jpg", 
		Directives = {}
	}
}
_i1B = Wherigo.ZMedia(_Ve7wP)
_i1B.Id = "66ff1fa9-dabf-41df-9149-766a350aa80f"
_i1B.Name = _CAR("\042\025\091\036\089\114\082\001")
_i1B.Description = ""
_i1B.AltText = ""
_i1B.Resources = {
	{
		Type = "jpg", 
		Filename = "UV.jpg", 
		Directives = {}
	}
}
_RJdyD = Wherigo.ZMedia(_Ve7wP)
_RJdyD.Id = "b4133ff5-c9de-4928-aa1f-20cb1531c23c"
_RJdyD.Name = _CAR("\098\103\108\081\083\091\022\104\094\114\082\123\070\070\001")
_RJdyD.Description = ""
_RJdyD.AltText = ""
_RJdyD.Resources = {
	{
		Type = "mp3", 
		Filename = "beep-geschafft.mp3", 
		Directives = {}
	}
}
_vEWe = Wherigo.ZMedia(_Ve7wP)
_vEWe.Id = "21969270-bc92-4d07-bafd-840d865832db"
_vEWe.Name = _CAR("\022\123\071\052\089\081\091\098\103\108\081\083\091\055\081\083\089\123\081\123")
_vEWe.Description = ""
_vEWe.AltText = ""
_vEWe.Resources = {
	{
		Type = "fdl", 
		Filename = "IndianaJones.fdl", 
		Directives = {}
	}
}
_f1e = Wherigo.ZMedia(_Ve7wP)
_f1e.Id = "49d4a47f-c2cd-4186-b2af-b345a7303b68"
_f1e.Name = _CAR("\098\103\108\081\083\091\006\045\043\051\103\094\089\103\081")
_f1e.Description = ""
_f1e.AltText = ""
_f1e.Resources = {
	{
		Type = "mp3", 
		Filename = "Explosion.mp3", 
		Directives = {}
	}
}
_KWvi = Wherigo.ZMedia(_Ve7wP)
_KWvi.Id = "3188c39b-6a83-43d0-ab5f-2f2d7b77e958"
_KWvi.Name = _CAR("\022\123\071\052\089\081\091\098\103\108\081\083\091\016\123\081\081\050")
_KWvi.Description = ""
_KWvi.AltText = ""
_KWvi.Resources = {
	{
		Type = "fdl", 
		Filename = "NannyNannyBooBoo.fdl", 
		Directives = {}
	}
}
_vJyTz = Wherigo.ZMedia(_Ve7wP)
_vJyTz.Id = "43816e76-8ce9-4ee1-b4eb-7ec3bfb9ea2f"
_vJyTz.Name = _CAR("\022\104\094\043\104\089\114\082\104\071\001")
_vJyTz.Description = ""
_vJyTz.AltText = ""
_vJyTz.Resources = {
	{
		Type = "jpg", 
		Filename = "Save.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_Ve7wP.Id="abc69c41-c6c6-4c27-a606-7692bcdff9e5"
_Ve7wP.Name="Der Auftrag"
_Ve7wP.Description=[[Der Auftrag wenn Sie ihn annehmen, lautet: Finden Sie die toedliche Formel!

Sollten Sie oder ein Mitglied ihres Teams gefangen genommen werden, werden wir jegliche Kenntnis ueber Sie oder den Auftrag abstreiten.]]
_Ve7wP.Visible=true
_Ve7wP.Activity="Fiction"
_Ve7wP.StartingLocationDescription=[[Hier sollte sich der Spieler beim Start aufhalten!]]
_Ve7wP.StartingLocation = ZonePoint(47.858880690113,12.1327886687088,0)
_Ve7wP.Version="1.0"
_Ve7wP.Company=""
_Ve7wP.Author="Flaco76"
_Ve7wP.BuilderVersion="URWIGO 1.14.4469.18959"
_Ve7wP.CreateDate="09/25/2011 22:47:25"
_Ve7wP.PublishDate="1/1/0001 12:00:00 AM"
_Ve7wP.UpdateDate="08/15/2012 21:02:35"
_Ve7wP.LastPlayedDate="1/1/0001 12:00:00 AM"
_Ve7wP.TargetDevice="PocketPC"
_Ve7wP.TargetDeviceVersion="0"
_Ve7wP.StateId="1"
_Ve7wP.CountryId="2"
_Ve7wP.Complete=false
_Ve7wP.UseLogging=true

_Ve7wP.Media=_GC_x

_Ve7wP.Icon=_GC_x


-- Zones --
_6yfoT = Wherigo.Zone(_Ve7wP)
_6yfoT.Id = "6a4e16e6-9b9e-4133-a6ab-af80805a3a41"
_6yfoT.Name = _CAR("\036\123\081\083\104\127\103\081\104")
_6yfoT.Description = ""
_6yfoT.Visible = true
_6yfoT.Media = _aQyUM
_6yfoT.Commands = {}
_6yfoT.DistanceRange = Distance(-1, "feet")
_6yfoT.ShowObjects = "OnEnter"
_6yfoT.ProximityRange = Distance(60, "meters")
_6yfoT.AllowSetPositionTo = false
_6yfoT.Active = true
_6yfoT.Points = {
	ZonePoint(47.8581735434866, 12.1328450739384, 0), 
	ZonePoint(47.8582221347341, 12.132952362299, 0), 
	ZonePoint(47.8581735434871, 12.1329738199711, 0), 
	ZonePoint(47.8581267518728, 12.1328450739384, 0)
}
_6yfoT.OriginalPoint = ZonePoint(47.8581739933952, 12.1329040825367, 0)
_6yfoT.DistanceRangeUOM = "Feet"
_6yfoT.ProximityRangeUOM = "Meters"
_6yfoT.OutOfRangeName = ""
_6yfoT.InRangeName = ""
_HdF = Wherigo.Zone(_Ve7wP)
_HdF.Id = "24ae6f65-b25a-46f0-8693-63cc9b6ef593"
_HdF.Name = _CAR("\072\123\114\082\052\123\081\081")
_HdF.Description = ""
_HdF.Visible = true
_HdF.Media = _feOp
_HdF.Commands = {}
_HdF.DistanceRange = Distance(-1, "feet")
_HdF.ShowObjects = "OnEnter"
_HdF.ProximityRange = Distance(60, "meters")
_HdF.AllowSetPositionTo = false
_HdF.Active = false
_HdF.Points = {
	ZonePoint(47.8585937662839, 12.133221924305, 0), 
	ZonePoint(47.8586099632401, 12.1333023905754, 0), 
	ZonePoint(47.8585739699974, 12.1333372592926, 0), 
	ZonePoint(47.8585451753852, 12.1332809329033, 0)
}
_HdF.OriginalPoint = ZonePoint(47.8585807187267, 12.1332856267691, 0)
_HdF.DistanceRangeUOM = "Feet"
_HdF.ProximityRangeUOM = "Meters"
_HdF.OutOfRangeName = ""
_HdF.InRangeName = ""
_Weo = Wherigo.Zone(_Ve7wP)
_Weo.Id = "47af20f8-20d9-483e-aa6f-457d5807e643"
_Weo.Name = _CAR("\009\089\081\001\104\071\001\108\104\071")
_Weo.Description = ""
_Weo.Visible = true
_Weo.Media = _M2g
_Weo.Commands = {}
_Weo.DistanceRange = Distance(-1, "feet")
_Weo.ShowObjects = "OnEnter"
_Weo.ProximityRange = Distance(60, "meters")
_Weo.AllowSetPositionTo = false
_Weo.Active = false
_Weo.Points = {
	ZonePoint(47.8593352217558, 12.1320685744286, 0), 
	ZonePoint(47.859409006793, 12.1322160959244, 0), 
	ZonePoint(47.8592704348072, 12.1323555707932, 0), 
	ZonePoint(47.8592524384183, 12.1321249008179, 0)
}
_Weo.OriginalPoint = ZonePoint(47.8593167754436, 12.132191285491, 0)
_Weo.DistanceRangeUOM = "Feet"
_Weo.ProximityRangeUOM = "Meters"
_Weo.OutOfRangeName = ""
_Weo.InRangeName = ""

-- Characters --

-- Items --
_ZsTcw = Wherigo.ZItem{
	Cartridge = _Ve7wP, 
	Container = Player
}
_ZsTcw.Id = "7eb8a194-ee88-4326-b06b-70b41e14dff8"
_ZsTcw.Name = _CAR("\098\001\103\043\043\108\082\071")
_ZsTcw.Description = ""
_ZsTcw.Visible = false
_ZsTcw.Media = _aHnV
_ZsTcw.Commands = {
	_JMO = Wherigo.ZCommand{
		Text = _CAR("\035\004\020\104\051\123\108\070\104\081\104\091\061\104\089\001\091\123\081\127\104\089\020\104\081"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CAR("\016\089\114\082\001\091\077\104\071\070\108\020\004\123\071")
	}
}
_ZsTcw.Commands._JMO.Custom = true
_ZsTcw.Commands._JMO.Id = "6518fe8b-4ea5-40fa-a53c-48961d03c98e"
_ZsTcw.Commands._JMO.WorksWithAll = true
_ZsTcw.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_ZsTcw.Locked = false
_ZsTcw.Opened = true

-- Tasks --
_FXRGw = Wherigo.ZTask(_Ve7wP)
_FXRGw.Id = "dc39e41b-c9a9-49cc-8e1f-47e9f43c753a"
_FXRGw.Name = _CAR("\061\108\071\091\036\123\081\083\104\127\103\081\104\091\070\051\089\104\020\104\081")
_FXRGw.Description = _CAR("\058\051\089\104\020\104\081\091\098\089\104\091\052\089\001\091\083\104\052\091\047\089\051\103\001\091\127\108\071\091\036\123\081\083\104\127\103\081\104\105")
_FXRGw.Visible = true
_FXRGw.Media = _aQyUM
_FXRGw.Active = true
_FXRGw.Complete = false
_FXRGw.CorrectState = "None"
_ku_ = Wherigo.ZTask(_Ve7wP)
_ku_.Id = "ad567ac9-38e1-4e6f-8273-2cf897fb59e5"
_ku_.Name = _CAR("\061\108\052\091\072\123\114\082\052\123\081\081\091\020\104\082\104\081")
_ku_.Description = _CAR("\022\104\082\104\081\091\098\089\104\091\127\108\052\091\072\123\114\082\052\123\081\081\030")
_ku_.Visible = true
_ku_.Media = _feOp
_ku_.Active = false
_ku_.Complete = false
_ku_.CorrectState = "None"
_S8yIv = Wherigo.ZTask(_Ve7wP)
_S8yIv.Id = "657fb5db-29a3-457a-9799-c900e4a2dab4"
_S8yIv.Name = _CAR("\061\108\071\091\009\089\081\001\104\071\001\108\104\071\091\020\104\082\104\081")
_S8yIv.Description = _CAR("\022\104\082\104\081\091\098\089\104\091\127\108\071\091\009\089\081\001\104\071\001\108\104\071\124\091\127\123\104\082\051\104\081\091\098\089\104\091\123\108\070\091\083\104\052\091\072\104\020\091\083\103\071\001\082\089\081\091\083\089\104\091\094\114\082\052\123\051\104\081\091\058\104\081\094\001\104\071\091\083\104\071\091\016\103\071\083\103\094\001\094\104\089\001\104\091\083\104\094\091\047\068\030")
_S8yIv.Visible = true
_S8yIv.Media = _M2g
_S8yIv.Active = false
_S8yIv.Complete = false
_S8yIv.CorrectState = "None"

-- Cartridge Variables --
_IXK = _CAR("\015\063")
_YRh = _CAR("\003\060\029\074")
_gc1 = 65
_xqgt = 50
_jT8ua = 630
_ydCfB = _CAR("\126\123")
_36l = _CAR("\078\103\103\043\104\071")
_eKXcE = _CAR("\072\103\051\051\103\080\089\001\127")
_ZQz = _CAR("\009\103\070\070\094\001\123\104\083\001\104\071")
_trZ9 = _CAR("\035\001\103\052\043\082\050\094\089\079")
_RymoZ = _CAR("\065\089\114\071\103\004\089\103\051\103\020\089\104")
_9Ifl = _CAR("\036\123\094\104\071\001\104\114\082\081\089\079")
_wMQ = 666
_piP = _CAR("\103\052\104\020\123")
_sRur = _CAR("\034\054\050\070\103\095")
_b6q = _CAR("\083\108\052\052\050")
_LxgpF = _CAR("\034\061\094\095\114\080")
_VUPQ = _CAR("\034\058\044\039\022\080")
_shcR = _CAR("\034\127\044\081\034\103")
_lMl = _CAR("\034\114\080\082\015")
_Ve7wP.ZVariables = {
	_IXK = _CAR("\015\063"), 
	_YRh = _CAR("\003\060\029\074"), 
	_gc1 = 65, 
	_xqgt = 50, 
	_jT8ua = 630, 
	_ydCfB = _CAR("\126\123"), 
	_36l = _CAR("\078\103\103\043\104\071"), 
	_eKXcE = _CAR("\072\103\051\051\103\080\089\001\127"), 
	_ZQz = _CAR("\009\103\070\070\094\001\123\104\083\001\104\071"), 
	_trZ9 = _CAR("\035\001\103\052\043\082\050\094\089\079"), 
	_RymoZ = _CAR("\065\089\114\071\103\004\089\103\051\103\020\089\104"), 
	_9Ifl = _CAR("\036\123\094\104\071\001\104\114\082\081\089\079"), 
	_wMQ = 666, 
	_piP = _CAR("\103\052\104\020\123"), 
	_sRur = _CAR("\034\054\050\070\103\095"), 
	_b6q = _CAR("\083\108\052\052\050"), 
	_LxgpF = _CAR("\034\061\094\095\114\080"), 
	_VUPQ = _CAR("\034\058\044\039\022\080"), 
	_shcR = _CAR("\034\127\044\081\034\103"), 
	_lMl = _CAR("\034\114\080\082\015")
}

-- Timers --
_cwh8 = Wherigo.ZTimer(_Ve7wP)
_cwh8.Id = "a7c801c7-9461-41e8-b46d-fc98069d7695"
_cwh8.Name = _CAR("\078\103\108\081\001\083\103\080\081")
_cwh8.Description = ""
_cwh8.Visible = true
_cwh8.Duration = 8000
_cwh8.Type = "Countdown"

-- Inputs --
_zXn_o = Wherigo.ZInput(_Ve7wP)
_zXn_o.Id = "86d76cb4-0f22-4ee8-86bb-c420d4586c1b"
_zXn_o.Name = _CAR("\058\071\123\020\104\091\081\123\114\082\091\095\108\104\071\114\103\083\104")
_zXn_o.Description = ""
_zXn_o.Visible = true
_zXn_o.Media = _Tqp00
_zXn_o.InputType = "Text"
_zXn_o.Text = _CAR("\008\040\039\121\072\089\104\091\051\123\108\001\104\001\091\083\104\071\091\095\108\104\071\114\103\083\104\031")
_6jb = Wherigo.ZInput(_Ve7wP)
_6jb.Id = "201a207f-b87c-4dde-9e0b-74f84a2c65a7"
_6jb.Name = _CAR("\058\071\123\020\104\091\081\123\114\082\091\040\104\094\001\104\114\082\108\081\020\094\020\104\051\083")
_6jb.Description = ""
_6jb.Visible = true
_6jb.Media = _kNd
_6jb.InputType = "Text"
_6jb.Text = _CAR("\008\040\039\121\072\089\104\077\089\104\051\091\040\104\094\001\104\114\082\108\081\020\094\020\104\051\083\091\080\089\051\051\091\083\104\071\091\072\123\114\082\052\123\081\081\031")
_Te23p = Wherigo.ZInput(_Ve7wP)
_Te23p.Id = "dad057db-3679-4074-865a-65e4b6d46a8b"
_Te23p.Name = _CAR("\058\071\123\020\104\091\081\123\114\082\091\122\089\071\114\082\001\108\071\052\082\103\104\082\104")
_Te23p.Description = ""
_Te23p.Visible = true
_Te23p.Media = _kAzQ
_Te23p.InputType = "Text"
_Te23p.Text = _CAR("\008\040\039\121\072\089\104\091\082\103\114\082\091\089\094\001\091\083\104\071\091\122\089\071\114\082\001\108\071\052\031")
_AKCsv = Wherigo.ZInput(_Ve7wP)
_AKCsv.Id = "2052cc95-a840-42fb-9249-73090f282c07"
_AKCsv.Name = _CAR("\058\071\123\020\104\091\081\123\114\082\091\122\108\081\094\001\080\104\071\079")
_AKCsv.Description = ""
_AKCsv.Visible = true
_AKCsv.Media = _G0br
_AKCsv.InputType = "Text"
_AKCsv.Text = _CAR("\008\040\039\121\072\089\104\091\077\089\104\051\104\091\098\114\082\104\089\004\104\081\091\082\123\004\104\081\091\123\051\051\104\091\098\001\123\081\020\104\081\091\127\108\094\123\052\052\104\081\031")
_OOB = Wherigo.ZInput(_Ve7wP)
_OOB.Id = "0f4a1a46-e5c4-4080-829d-2ff6146e043a"
_OOB.Name = _CAR("\058\071\123\020\104\091\081\123\114\082\091\058\123\082\071\094\001\108\082\051\020\104\080\089\114\082\001")
_OOB.Description = ""
_OOB.Visible = true
_OOB.Media = _KTxLo
_OOB.InputType = "Text"
_OOB.Text = _CAR("\008\040\039\121\078\046\065\047\042\095\006\039\027\008\040\039\121\008\040\039\121\087\072\089\104\077\089\104\051\091\079\020\091\083\123\071\070\091\083\089\104\091\087\098\089\114\082\104\071\082\104\089\001\094\094\114\082\051\104\108\094\104\087\091\052\123\045\030\091\123\108\070\081\104\082\052\104\081\031\087\091")
_pSqRA = Wherigo.ZInput(_Ve7wP)
_pSqRA.Id = "92ae12db-827b-4f1b-8bff-e3f653052111"
_pSqRA.Name = _CAR("\058\071\123\020\104\091\103\004\091\058\123\114\082\020\104\004\089\104\001\104\091\082\104\071\123\108\094\020\104\070\108\081\083\104\081")
_pSqRA.Description = ""
_pSqRA.Visible = true
_pSqRA.Media = _nzQbG
_pSqRA.InputType = "Text"
_pSqRA.Text = _CAR("\008\040\039\121\009\123\004\104\081\091\098\089\104\091\083\089\104\091\058\123\114\082\020\104\004\089\104\001\104\091\035\036\036\006\039\091\072\089\094\094\104\081\094\114\082\123\070\001\051\104\071\091\082\104\071\123\108\094\020\104\070\108\081\083\104\081\031\091\008\040\039\121\008\040\039\121\035\081\001\080\103\071\001\104\081\091\098\089\104\091\052\089\001\091\087\126\123\087\091\103\083\104\071\091\087\016\104\089\081\087\030\008\040\039\121")
_Fe1 = Wherigo.ZInput(_Ve7wP)
_Fe1.Id = "2dfe67ec-be36-4282-ace2-9c9d02e0b7d0"
_Fe1.Name = _CAR("\058\071\123\020\104\091\081\123\114\082\091\016\123\052\104\081\091\083\104\071\091\072\089\094\094\104\081\094\114\082\123\070\001\051\104\071")
_Fe1.Description = ""
_Fe1.Visible = true
_Fe1.InputType = "Text"
_Fe1.Text = _CAR("\008\040\039\121\016\104\081\081\104\081\091\094\089\104\091\083\104\081\091\016\123\052\104\081\091\104\089\081\104\094\091\072\089\094\094\104\081\094\114\082\123\070\001\051\104\071\094\105\008\040\039\121")
_zNT = Wherigo.ZInput(_Ve7wP)
_zNT.Id = "3de55b49-747e-446d-b695-d27c38c992a5"
_zNT.Name = _CAR("\058\071\123\020\104\091\081\123\114\082\091\058\123\114\082\020\104\004\089\104\001\091\078\103\103\043\104\071")
_zNT.Description = ""
_zNT.Visible = true
_zNT.Media = _c2q_7
_zNT.InputType = "Text"
_zNT.Text = _CAR("\072\089\104\091\051\123\108\001\104\001\091\083\123\094\091\058\123\114\082\020\104\004\089\104\001\091\077\103\081\091\118\071\030\091\078\103\103\043\104\071\031")
_Cjff = Wherigo.ZInput(_Ve7wP)
_Cjff.Id = "dc4106ca-2cb9-4c52-886e-dbe74ae5a7b0"
_Cjff.Name = _CAR("\058\071\123\020\104\091\081\123\114\082\091\058\123\114\082\020\104\004\089\104\001\091\072\103\051\051\103\080\089\001\127")
_Cjff.Description = ""
_Cjff.Visible = true
_Cjff.Media = _FZVd
_Cjff.InputType = "Text"
_Cjff.Text = _CAR("\008\040\039\121\072\089\104\091\051\123\108\001\104\001\091\083\123\094\091\058\123\114\082\020\104\004\089\104\001\091\077\103\081\091\047\071\103\070\030\091\072\103\051\051\103\080\089\001\127\031")
_WJ69e = Wherigo.ZInput(_Ve7wP)
_WJ69e.Id = "f77b3649-2c3b-44f5-9fbe-43fc870be346"
_WJ69e.Name = _CAR("\058\071\123\020\104\091\081\123\114\082\091\058\123\114\082\020\104\004\089\104\001\091\009\103\070\070\094\001\123\104\083\001\104\071")
_WJ69e.Description = ""
_WJ69e.Visible = true
_WJ69e.Media = _6Fk
_WJ69e.InputType = "Text"
_WJ69e.Text = _CAR("\008\040\039\121\072\089\104\091\051\123\108\001\104\001\091\083\123\094\091\058\123\114\082\020\104\004\089\104\001\091\077\103\081\091\118\071\030\091\009\103\070\070\094\001\123\104\083\001\104\071\031")
_LTu1F = Wherigo.ZInput(_Ve7wP)
_LTu1F.Id = "a2b9dc3c-09fc-409d-b0de-517fdd17ef5c"
_LTu1F.Name = _CAR("\058\071\123\020\104\091\081\123\114\082\091\040\103\052\004\104\081\114\103\083\104")
_LTu1F.Description = ""
_LTu1F.Visible = true
_LTu1F.Media = _AIwF8
_LTu1F.InputType = "Text"
_LTu1F.Text = _CAR("\008\040\039\121\072\089\104\091\051\123\108\001\104\001\091\083\104\071\091\078\103\083\104\091\127\108\071\091\058\104\071\081\127\108\104\081\083\108\081\020\091\083\104\071\091\040\103\052\004\104\031")
_SRf0 = Wherigo.ZInput(_Ve7wP)
_SRf0.Id = "4cf349c4-50f4-4670-85c1-6c43b47ab1b6"
_SRf0.Name = _CAR("\058\071\123\020\104\091\081\123\114\082\091\001\103\104\083\051\089\114\082\104\071\091\058\103\071\052\104\051")
_SRf0.Description = ""
_SRf0.Visible = true
_SRf0.Media = _GC_x
_SRf0.InputType = "Text"
_SRf0.Text = _CAR("\008\040\039\121\072\089\104\091\051\123\108\001\104\001\091\083\089\104\091\001\103\104\083\051\089\114\082\104\091\058\103\071\052\104\051\031\008\040\039\121\008\040\039\121\098\089\104\091\004\104\070\089\081\083\104\001\091\094\089\114\082\091\089\052\091\055\081\081\104\071\081\091\083\104\094\091\040\104\082\123\104\051\001\081\089\094\094\104\094\105")

-- WorksWithList for object commands --

-- functions --
function _Ve7wP:OnStart()
	_Urwigo.OldDialog{
		{
			Text = (_CAR("\022\108\001\104\081\091\095\123\020\091\035\020\104\081\001\091")..Player.Name).._CAR("\091\105\008\040\039\121\008\040\039\121\098\089\104\091\082\123\004\104\081\091\083\104\081\091\035\108\070\001\071\123\020\091\123\081\020\104\081\103\052\052\104\081\105"), 
			Media = _RYS
		}, 
		{
			Text = _CAR("\008\040\039\121\055\114\082\091\004\089\081\091\089\082\071\091\078\103\052\052\123\081\083\104\071\030\008\040\039\121\091\008\040\039\121\098\104\089\104\081\091\098\089\104\091\082\103\114\082\079\103\081\127\104\081\001\071\089\104\071\001\124\091\083\104\071\091\035\108\070\001\071\123\020\091\089\094\001\091\079\104\089\081\091\061\108\114\079\104\071\094\114\082\051\104\114\079\104\081\030\091\008\040\039\121\008\040\039\121\061\104\089\020\104\081\091\098\089\104\091\080\123\094\091\094\089\104\091\083\071\123\108\070\091\082\123\004\104\081\105"), 
			Media = _RYS
		}, 
		{
			Text = _CAR("\008\040\039\121\118\104\071\091\047\089\051\103\001\091\082\123\001\091\035\081\080\104\089\094\108\081\020\091\098\089\104\091\127\108\052\091\006\089\081\094\123\001\127\020\104\004\089\104\001\091\127\108\091\070\051\089\104\020\104\081\030\008\040\039\121\008\040\039\121\016\123\114\082\091\083\104\071\091\036\123\081\083\108\081\020\091\080\104\071\083\104\091\089\114\082\091\098\089\104\091\104\071\081\104\108\001\091\079\103\081\001\123\079\001\089\104\071\104\081\091\108\081\083\091\094\089\104\091\104\071\082\123\051\001\104\081\091\055\081\070\103\071\052\123\001\089\103\081\104\081\091\108\104\004\104\071\091\083\123\094\091\061\089\104\051\103\004\011\104\079\001\105"), 
			Media = _RYS
		}
	}
end
function _Ve7wP:OnRestore()
end
function _6yfoT:OnEnter()
	_sRur = _CAR("\034\054\050\070\103\095")
	Wherigo.PlayAudio(_vEWe)
	Wherigo.PlayAudio(_RJdyD)
	_cwh8:Start()
	_Urwigo.Dialog(false, {
		{
			Text = (_CAR("\035\020\104\081\001\091")..Player.Name).._CAR("\091\105\008\040\039\121\008\040\039\121\072\089\071\091\004\104\070\089\081\083\104\081\091\108\081\094\091\011\104\001\127\001\091\108\104\004\104\071\091\083\104\052\091\006\089\081\094\123\001\127\020\104\004\089\104\001\105"), 
			Media = _sEu
		}, 
		{
			Text = _CAR("\008\040\039\121\118\104\071\091\058\051\108\020\091\082\089\104\071\091\082\089\081\091\080\123\071\091\020\123\081\127\091\094\114\082\103\104\081\091\071\108\114\079\104\051\089\020\124\091\080\123\094\031"), 
			Media = _sEu
		}, 
		{
			Text = _CAR("\008\040\039\121\009\123\004\104\081\091\098\089\104\091\004\104\089\052\091\035\081\070\051\108\020\091\123\108\114\082\091\083\104\081\091\095\108\071\052\091\083\104\071\091\122\089\071\114\082\104\091\098\001\030\091\016\089\079\103\051\123\108\094\091\020\104\094\104\082\104\081\031\091\008\040\039\121\008\040\039\121\072\123\094\091\094\114\082\123\104\001\127\104\081\091\098\089\104\091\080\089\104\091\082\103\114\082\091\083\104\071\091\080\123\071\031\008\040\039\121\008\040\039\121\057\098\114\082\123\104\001\127\104\081\091\098\089\104\091\123\108\070\091\083\104\081\091\065\104\001\104\071\091\020\104\081\123\108\105\053"), 
			Media = _8n4
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_Te23p)
		end)
	end)
end
function _HdF:OnEnter()
	_sRur = _CAR("\034\009\083\058")
	_Urwigo.Dialog(false, {
		{
			Text = _CAR("\009\123\051\001\105\008\040\039\121\008\040\039\121\035\082\105\091\072\089\104\091\089\114\082\091\094\104\082\104\124\091\082\123\004\104\081\091\098\089\104\091\104\001\080\123\094\091\070\108\104\071\091\052\089\114\082\105\008\040\039\121\008\040\039\121\025\089\104\051\104\081\091\118\123\081\079\105\008\040\039\121"), 
			Media = _feOp
		}, 
		{
			Text = _CAR("\009\089\104\071\091\123\052\091\025\103\071\083\104\071\104\089\081\020\123\081\020\091\079\123\081\081\091\089\114\082\091\098\089\104\091\123\004\104\071\091\081\089\114\082\001\091\071\104\089\081\091\051\123\094\094\104\081\030\008\040\039\121"), 
			Media = _ZHHP
		}, 
		{
			Text = _CAR("\118\103\114\082\091\123\052\091\009\089\081\001\104\071\104\089\081\020\123\081\020\091\094\089\081\083\091\098\089\104\091\108\081\020\104\094\001\103\104\071\001\105\008\040\039\121\008\040\039\121\118\103\071\001\091\004\071\123\108\114\082\104\081\091\098\089\104\091\123\004\104\071\091\104\089\081\104\081\091\095\042\006\039\078\046\118\006\091\108\052\091\071\104\089\081\091\127\108\091\079\103\052\052\104\081\105"), 
			Media = _M2g
		}, 
		{
			Text = _CAR("\022\104\082\104\081\091\098\089\104\091\083\104\094\082\123\051\004\091\123\081\091\083\104\071\091\016\103\071\083\103\094\001\094\104\089\001\104\091\057\098\114\082\103\104\081\070\104\051\083\094\001\071\123\094\094\104\053\091\104\081\001\051\123\081\020\091\004\089\094\091\127\108\071\091\009\089\081\001\104\071\001\108\104\071\104\030\008\040\039\121\008\040\039\121\061\123\104\082\051\104\081\091\098\089\104\091\123\051\051\104\091\094\114\082\052\123\051\104\081\091\058\104\081\094\001\104\071\091\123\108\070\091\083\089\104\094\104\071\091\098\104\089\001\104\030\008\040\039\121\008\040\039\121\016\055\078\009\095\091\118\055\006\091\035\042\058\091\118\006\039\091\016\046\039\118\072\006\098\095\098\006\055\095\006\105\008\040\039\121\008\040\039\121\118\089\104\094\091\089\094\001\091\083\123\081\081\091\020\051\104\089\114\082\127\104\089\001\089\020\091\083\104\071\091\095\042\006\039\078\046\118\006\105\008\040\039\121"), 
			Media = _C88
		}, 
		{
			Text = _CAR("\098\047\055\006\036\091\022\006\098\047\006\055\078\009\006\039\095"), 
			Media = _vJyTz
		}
	}, function(action)
		_HdF.Active = false
		_Weo.Active = true
		_ku_.Active = false
		_S8yIv.Active = true
		_Ve7wP:RequestSync()
	end)
	Wherigo.PlayAudio(_vEWe)
	Wherigo.PlayAudio(_RJdyD)
end
function _Weo:OnEnter()
	_sRur = _CAR("\034\072\104\103")
	_Urwigo.Dialog(false, {
		{
			Text = _CAR("\008\040\039\121\009\089\104\071\091\089\094\001\091\083\089\104\091\009\089\081\001\104\071\001\108\104\071\105\008\040\039\121"), 
			Media = _Tqp00
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_zXn_o)
		end)
	end)
	_Weo.Active = false
	_Weo.Visible = false
	_S8yIv.Active = false
	Wherigo.PlayAudio(_vEWe)
	Wherigo.PlayAudio(_RJdyD)
end
function _zXn_o:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.MessageBox{
			Text = _CAR("\008\040\039\121\098\089\104\091\052\108\104\094\094\104\081\091\061\089\070\070\104\071\081\091\104\089\081\020\104\004\104\081\030"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_zXn_o)
					end)
				end
			end
		}
		return
	end
	if Wherigo.NoCaseEquals(_IXK, tostring(input)) then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\122\103\071\071\104\079\001\105\008\040\039\121\008\040\039\121\118\089\104\091\009\089\081\001\104\071\001\108\104\071\091\089\094\001\091\103\070\070\104\081\105\091\008\040\039\121\008\040\039\121\040\104\001\071\104\001\104\081\091\098\089\104\091\011\104\001\127\001\091\083\123\094\091\047\068\008\040\039\121\008\040\039\121"), 
				Media = _Hp4dG
			}, 
			{
				Text = _CAR("\008\040\039\121\009\089\104\071\091\083\071\089\081\091\004\071\123\108\114\082\104\081\091\098\089\104\091\104\089\081\104\081\091\098\114\082\108\001\127\123\081\127\108\020\030"), 
				Media = _Wjg
			}, 
			{
				Text = _CAR("\040\104\001\071\104\001\104\081\091\098\089\104\091\083\089\104\091\098\089\114\082\104\071\082\104\089\001\094\094\114\082\051\104\108\094\104\030\008\040\039\121\008\040\039\121\040\104\123\081\001\080\103\071\001\104\081\091\098\089\104\091\083\104\052\091\078\103\052\043\108\001\104\071\091\104\089\081\104\091\058\071\123\020\104\105\008\040\039\121\008\040\039\121\118\123\081\081\091\104\071\082\123\051\001\104\081\091\098\089\104\091\055\082\071\104\081\091\098\114\082\108\001\127\123\081\127\108\020\030"), 
				Media = _KTxLo
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_OOB)
			end)
		end)
	else
		_Urwigo.MessageBox{
			Text = _CAR("\058\123\051\094\114\082\105\008\040\039\121\008\040\039\121\025\104\071\094\108\114\082\104\081\091\098\089\104\091\104\094\091\081\103\114\082\052\123\051\105\008\040\039\121\008\040\039\121\006\094\091\089\094\001\091\104\089\081\104\091\108\081\020\104\071\123\083\104\091\061\123\082\051\030"), 
			Media = _PN7, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_zXn_o)
					end)
				end
			end
		}
	end
end
function _6jb:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.MessageBox{
			Text = _CAR("\022\104\004\104\081\091\098\089\104\091\061\089\070\070\104\071\081\091\104\089\081\105\008\040\039\121\008\040\039\121\098\108\114\082\104\081\091\098\089\104\091\123\052\091\098\114\082\089\051\083\091\083\104\071\091\065\104\001\127\020\104\071\104\089\091\009\089\051\020\104\071\091\081\123\114\082\091\083\104\071\091\055\081\070\103\071\052\123\001\089\103\081\030"), 
			Media = _BGklb, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_6jb)
					end)
				end
			end
		}
		return
	end
	if Wherigo.NoCaseEquals(_YRh, tostring(input)) then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\008\040\039\121\039\089\114\082\001\089\020\105\008\040\039\121\008\040\039\121\126\104\001\127\001\091\080\089\094\094\104\081\091\098\089\104\091\040\104\094\114\082\104\089\083\030\008\040\039\121\008\040\039\121\022\104\082\104\081\091\098\089\104\091\011\104\001\127\001\091\127\108\052\091\072\123\114\082\052\123\081\081\105"), 
				Media = _RYS
			}, 
			{
				Text = _CAR("\098\047\055\006\036\091\022\006\098\047\006\055\078\009\006\039\095"), 
				Media = _vJyTz
			}
		}, function(action)
			_6yfoT.Active = false
			_6yfoT.Visible = true
			_HdF.Visible = true
			_HdF.Active = true
			_FXRGw.Active = false
			_ku_.Active = true
			_Ve7wP:RequestSync()
		end)
	else
		_Urwigo.MessageBox{
			Text = _CAR("\008\040\039\121\058\123\051\094\114\082\105\008\040\039\121\008\040\039\121\025\104\071\094\108\114\082\104\081\091\098\089\104\091\104\094\091\081\103\114\082\052\123\051\105\008\040\039\121\008\040\039\121\098\108\114\082\104\081\091\098\089\104\091\123\052\091\098\114\082\089\051\083\091\083\104\071\091\065\104\001\127\020\104\071\104\089\091\009\089\051\020\104\071\091\081\123\114\082\091\083\104\071\091\055\081\070\103\071\052\123\001\089\103\081\030"), 
			Media = _pzipI, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_6jb)
					end)
				end
			end
		}
	end
end
function _Te23p:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.MessageBox{
			Text = _CAR("\008\040\039\121\022\104\004\104\081\091\098\089\104\091\061\089\070\070\104\071\081\091\104\089\081\105\008\040\039\121\008\040\039\121\098\114\082\123\104\001\127\104\081\091\098\089\104\091\083\089\104\091\009\103\104\082\104\091\083\104\094\091\122\089\071\114\082\001\108\071\052\094\030"), 
			Media = _kAzQ, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Te23p)
					end)
				end
			end
		}
		return
	end
	if _gc1 < input then
		_Urwigo.MessageBox{
			Text = _CAR("\008\040\039\121\016\104\089\081\124\091\094\103\091\082\103\114\082\091\089\094\001\091\104\071\091\081\089\114\082\001\105"), 
			Media = _pzipI, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Te23p)
					end)
				end
			end
		}
	elseif _gc1 > input then
		_Urwigo.MessageBox{
			Text = _CAR("\008\040\039\121\006\001\080\123\094\091\082\103\104\082\104\071\091\089\094\001\091\104\071\091\094\114\082\103\081\105"), 
			Media = _pzipI, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Te23p)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _CAR("\008\040\039\121\039\089\114\082\001\089\020\124\091\083\104\071\091\122\089\071\114\082\001\108\071\052\091\089\094\001\091\054\060\091\065\104\001\104\071\091\082\103\114\082\105\008\040\039\121"), 
			Media = _kAzQ, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.Dialog(false, {
						{
							Text = _CAR("\055\114\082\091\094\104\001\127\104\091\098\089\104\091\011\104\001\127\001\091\123\004\030\008\040\039\121\008\040\039\121\025\089\104\051\091\006\071\070\103\051\020\105\008\040\039\121"), 
							Media = _sEu
						}, 
						{
							Text = _CAR("\008\040\039\121\047\055\036\046\095\027\091\087\040\123\094\089\094\091\070\108\104\071\091\035\083\051\104\071\027\091\118\123\094\091\047\123\079\104\001\091\089\094\001\091\123\004\020\104\051\089\104\070\104\071\001\105\091\012\091\122\103\052\052\104\081\105\087\008\040\039\121\008\040\039\121\040\035\098\055\098\027\091\087\025\104\071\094\001\123\081\083\104\081\124\091\070\051\089\104\020\104\081\091\098\089\104\091\127\108\052\091\072\123\071\001\104\043\108\081\079\001\105\087\008\040\039\121\008\040\039\121\047\055\036\046\095\027\091\087\025\104\071\094\001\123\081\083\104\081\124\091\006\081\083\104\105\087"), 
							Media = _aQyUM
						}, 
						{
							Text = (_CAR("\035\020\104\081\001\091")..Player.Name).._CAR("\091\105\008\040\039\121\008\040\039\121\072\089\104\091\089\114\082\091\094\104\082\104\091\094\089\081\083\091\098\089\104\091\020\108\001\091\020\104\051\123\081\083\104\001\105"), 
							Media = _RYS
						}, 
						{
							Text = _CAR("\118\123\094\091\089\094\001\091\108\081\094\104\071\091\061\089\104\051\124\091\083\123\094\091\047\068\091\057\047\071\103\083\108\079\001\089\103\081\094\082\123\051\051\104\091\068\053\105\008\040\039\121\008\040\039\121\055\081\091\083\089\104\094\104\052\091\009\103\114\082\094\089\114\082\104\071\082\104\089\001\094\001\071\123\079\001\091\004\104\070\089\081\083\104\001\091\094\089\114\082\091\083\089\104\091\001\103\104\083\051\089\114\082\104\091\058\103\071\052\104\051\030"), 
							Media = _yrD_a
						}, 
						{
							Text = _CAR("\009\089\104\071\091\089\094\001\091\104\089\081\091\058\103\001\103\091\077\103\052\091\072\123\114\082\052\123\081\081\091\083\104\094\091\047\068\030\008\040\039\121\008\040\039\121\006\071\091\089\094\001\091\004\104\094\001\104\114\082\051\089\114\082\105"), 
							Media = _feOp
						}, 
						{
							Text = _CAR("\008\040\039\121\098\089\104\091\094\104\082\104\081\091\077\103\081\091\082\089\104\071\091\083\123\094\091\098\114\082\089\051\083\091\083\104\071\091\065\104\001\127\020\104\071\104\089\091\009\089\051\020\104\071\030\008\040\039\121\008\040\039\121\098\108\114\082\104\081\091\098\089\104\091\083\103\071\001\091\083\089\104\091\055\081\070\103\071\052\123\001\089\103\081\091\108\104\004\104\071\091\083\089\104\091\009\103\104\082\104\091\083\104\094\091\040\104\094\001\104\114\082\108\081\020\094\020\104\051\083\104\094\091\083\104\094\091\072\123\114\082\052\123\081\081\094\105\008\040\039\121\008\040\039\121\091"), 
							Media = _BGklb
						}
					}, function(action)
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(_6jb)
						end)
					end)
				end
			end
		}
	end
end
function _AKCsv:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.MessageBox{
			Text = _CAR("\022\104\004\104\081\091\094\089\104\091\061\089\070\070\104\071\081\091\104\089\081\105\008\040\039\121\008\040\039\121\061\123\104\082\051\104\081\091\098\089\104\091\083\089\104\091\098\114\082\104\089\004\104\081\091\123\051\051\104\071\091\098\001\123\081\020\104\081\030"), 
			Media = _G0br, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_AKCsv)
					end)
				end
			end
		}
		return
	end
	if _xqgt == input then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\008\040\039\121\039\089\114\082\001\089\020\105\091\008\040\039\121\008\040\039\121\006\094\091\094\089\081\083\091\060\074\091\098\114\082\104\089\004\104\081\105\008\040\039\121\008\040\039\121"), 
				Media = _RYS
			}, 
			{
				Text = _CAR("\098\047\055\006\036\091\022\006\098\047\006\055\078\009\006\039\095"), 
				Media = _vJyTz
			}
		}, function(action)
			_Ve7wP:RequestSync()
			_Urwigo.Dialog(false, {
				{
					Text = _CAR("\008\040\039\121\009\089\104\071\091\004\104\070\089\081\083\104\081\091\094\089\114\082\091\123\108\114\082\091\125\091\098\089\001\127\004\123\104\081\079\104\030\008\040\039\121\008\040\039\121"), 
					Media = _K72r
				}, 
				{
					Text = _CAR("\008\040\039\121\055\052\091\047\068\091\123\071\004\104\089\001\104\081\091\125\091\072\089\094\094\104\081\094\114\082\123\070\001\051\104\071\124\091\083\089\104\091\011\104\080\104\089\051\094\091\104\089\081\104\081\091\095\104\089\051\091\127\108\071\091\001\103\104\083\051\089\114\082\104\081\091\058\103\071\052\104\051\091\004\104\089\020\104\001\071\123\020\104\081\091\082\123\004\104\081\030\008\040\039\121\008\040\039\121\035\081\091\011\104\083\104\071\091\040\123\081\079\091\070\089\081\083\104\081\091\098\089\104\091\011\104\080\104\089\051\094\091\104\089\081\104\081\091\016\035\065\006\016\091\083\104\071\091\125\091\072\089\094\094\104\081\094\114\082\123\070\001\051\104\071\030\008\040\039\121\008\040\039\121\072\104\081\081\091\094\089\104\091\083\089\104\091\016\123\052\104\081\091\020\104\070\108\081\083\104\081\091\082\123\004\104\081\124\091\089\094\001\091\104\094\091\055\082\071\104\091\035\108\070\020\123\004\104\091\077\103\081\091\011\104\083\104\052\091\072\089\094\094\104\081\094\114\082\123\070\001\051\104\071\091\083\123\094\091\058\035\078\009\022\006\040\055\006\095\091\082\104\071\123\108\094\127\108\070\089\081\083\104\081\105"), 
					Media = _RYS
				}
			}, function(action)
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_pSqRA)
				end)
			end)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\058\123\051\094\114\082\105\008\040\039\121\008\040\039\121\025\104\071\094\108\114\082\104\081\091\098\089\104\091\104\094\091\081\103\114\082\052\123\051\030\008\040\039\121\008\040\039\121\061\123\104\082\051\104\081\091\098\089\104\091\083\089\104\091\098\114\082\104\089\004\104\081\091\123\051\051\104\071\091\098\001\123\081\020\104\081\030"), 
				Media = _pzipI
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_AKCsv)
			end)
		end)
	end
end
function _OOB:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.MessageBox{
			Text = _CAR("\022\104\004\104\081\091\098\089\104\091\061\089\070\070\104\071\081\091\104\089\081\105\008\040\039\121\008\040\039\121\098\108\114\082\104\081\091\098\089\104\091\089\052\091\055\081\081\104\071\081\091\083\104\094\091\058\123\082\071\094\001\108\082\051\094\030"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_OOB)
					end)
				end
			end
		}
		return
	end
	if _jT8ua == input then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\078\046\065\047\042\095\006\039\027\008\040\039\121\008\040\039\121\012\012\012\091\122\103\071\071\104\001\079\001\105\091\009\089\104\071\091\089\094\001\091\083\104\071\091\098\114\082\108\001\127\123\081\127\108\020\105\091\012\012\012"), 
				Media = _LnA
			}, 
			{
				Text = _CAR("\098\047\055\006\036\091\022\006\098\047\006\055\078\009\006\039\095"), 
				Media = _vJyTz
			}
		}, function(action)
			_Urwigo.Dialog(false, {
				{
					Text = (_CAR("\098\104\082\071\091\020\108\001\091\035\020\104\081\001\091")..Player.Name).._CAR("\091\105\008\040\039\121\008\040\039\121\126\104\001\127\001\091\079\103\104\081\081\104\081\091\098\089\104\091\094\089\114\082\091\108\081\004\104\094\103\071\020\001\091\089\052\091\047\068\091\004\104\080\104\020\104\081\030\008\040\039\121\008\040\039\121\126\104\083\104\071\091\080\089\071\083\091\098\089\104\091\070\108\104\071\091\104\089\081\104\081\091\065\089\001\123\071\004\104\089\001\104\071\091\082\123\051\001\104\081\030"), 
					Media = _RYS
				}, 
				{
					Text = _CAR("\055\081\091\083\104\071\091\065\089\001\001\104\091\083\104\094\091\047\068\091\004\104\070\089\081\083\104\001\091\094\089\114\082\091\104\089\081\104\091\035\071\001\091\055\081\094\104\051\030\008\040\039\121\008\040\039\121\118\103\071\001\091\094\089\104\082\001\091\052\123\081\091\083\089\104\094\104\094\091\122\108\081\094\001\080\104\071\079\030"), 
					Media = _G0br
				}
			}, function(action)
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_AKCsv)
				end)
				_Ve7wP:RequestSync()
			end)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\058\123\051\094\114\082\105\008\040\039\121\008\040\039\121\025\104\071\094\108\114\082\104\081\091\098\089\104\091\104\094\091\081\103\114\082\052\123\051\030\008\040\039\121\008\040\039\121\098\108\114\082\104\081\091\098\089\104\091\089\052\091\055\081\081\104\071\081\091\083\104\071\091\098\114\082\051\104\108\094\104\091\081\123\114\082\091\083\104\071\091\055\081\070\103\071\052\123\001\089\103\081\030")
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_OOB)
			end)
		end)
	end
end
function _pSqRA:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(_ydCfB, input) then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\008\040\039\121\118\123\081\081\091\079\103\104\081\081\104\081\091\098\089\104\091\081\123\114\082\070\103\051\020\104\081\083\104\091\058\071\123\020\104\081\091\004\104\123\081\001\080\103\071\001\104\081\105"), 
				Media = _RYS
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_zNT)
			end)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\008\040\039\121\118\123\081\081\091\052\108\104\094\094\104\081\091\094\089\104\091\081\103\114\082\091\083\089\104\091\016\123\052\104\081\091\083\104\071\091\070\104\082\051\104\081\083\104\081\091\072\089\094\094\104\081\094\114\082\123\070\001\051\104\071\091\082\104\071\123\108\094\070\089\081\083\104\081\030\008\040\039\121\008\040\039\121\118\089\104\091\016\123\052\104\081\091\083\104\071\091\072\089\094\094\104\081\094\114\082\123\070\001\051\104\071\091\070\089\081\083\104\081\091\098\089\104\091\123\081\091\083\104\081\091\098\089\001\127\004\123\104\081\079\104\081\030"), 
				Media = _K72r
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_Fe1)
			end)
		end)
	end
end
function _Fe1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(_36l, input) then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\118\123\094\091\089\094\001\091\118\071\030\091\078\103\103\043\104\071\105\008\040\039\121\008\040\039\121\058\089\081\083\104\081\091\098\089\104\091\082\104\071\123\108\094\091\080\123\094\091\094\104\089\081\091\058\035\078\009\022\006\040\055\006\095\091\089\094\001\105"), 
				Media = _c2q_7
			}, 
			{
				Text = _CAR("\022\104\082\104\081\091\098\089\104\091\083\123\127\108\091\089\081\091\094\104\089\081\091\036\123\004\103\071\105\008\040\039\121\008\040\039\121\098\104\089\081\091\036\123\004\103\071\091\004\104\070\089\081\083\104\001\091\094\089\114\082\091\123\108\070\091\123\108\070\091\006\004\104\081\104\091\060"), 
				Media = _ocLe
			}, 
			{
				Text = _CAR("\098\108\114\082\104\081\091\098\089\104\091\127\108\081\123\104\114\082\094\001\091\089\081\091\083\104\071\091\035\004\001\104\089\051\108\081\020\091\060\074\029\091\081\123\114\082\091\104\089\081\104\052\091\009\089\081\080\104\089\094\030\008\040\039\121\008\040\039\121\006\094\091\079\123\081\081\091\094\104\089\081\124\091\083\123\094\094\091\052\123\081\091\094\089\104\091\083\103\071\001\091\080\104\089\001\104\071\051\104\089\001\104\001\124\091\004\089\094\091\098\089\104\091\094\114\082\051\089\104\094\094\051\089\114\082\091\089\082\071\091\061\089\104\051\091\104\071\071\104\089\114\082\104\081\030"), 
				Media = _329V
			}, 
			{
				Text = _CAR("\008\040\039\121\058\123\051\051\094\091\098\089\104\091\104\089\081\104\091\042\025\012\036\123\052\043\104\091\004\104\094\089\001\127\104\081\124\091\079\123\081\081\091\083\089\104\094\104\091\004\104\089\091\083\104\071\091\098\108\114\082\104\091\004\104\082\089\051\070\051\089\114\082\091\094\104\089\081\030\008\040\039\121\008\040\039\121\118\089\104\091\009\089\081\080\104\089\094\104\091\094\089\081\083\091\123\004\104\071\091\123\108\114\082\091\103\082\081\104\091\042\025\012\036\123\052\043\104\091\070\089\081\083\004\123\071\030\008\040\039\121\008\040\039\121"), 
				Media = _i1B
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_pSqRA)
			end)
		end)
	elseif Wherigo.NoCaseEquals(_eKXcE, input) then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\118\123\094\091\089\094\001\091\118\071\030\091\072\103\051\051\103\080\089\001\127\105\008\040\039\121\008\040\039\121\058\089\081\083\104\081\091\098\089\104\091\082\104\071\123\108\094\091\080\123\094\091\094\104\089\081\091\058\035\078\009\022\006\040\055\006\095\091\089\094\001\105"), 
				Media = _FZVd
			}, 
			{
				Text = _CAR("\022\104\082\104\081\091\098\089\104\091\083\123\127\108\091\089\081\091\094\104\089\081\091\036\123\004\103\071\105\008\040\039\121\008\040\039\121\098\104\089\081\091\036\123\004\103\071\091\004\104\070\089\081\083\104\001\091\094\089\114\082\091\123\108\070\091\123\108\070\091\006\004\104\081\104\091\054"), 
				Media = _eLAM
			}, 
			{
				Text = _CAR("\098\108\114\082\104\081\091\098\089\104\091\127\108\081\123\104\114\082\094\001\091\089\081\091\083\104\071\091\035\004\001\104\089\051\108\081\020\091\054\003\029\091\081\123\114\082\091\104\089\081\104\052\091\009\089\081\080\104\089\094\030\008\040\039\121\008\040\039\121\006\094\091\079\123\081\081\091\094\104\089\081\124\091\083\123\094\094\091\052\123\081\091\094\089\104\091\083\103\071\001\091\080\104\089\001\104\071\051\104\089\001\104\001\124\091\004\089\094\091\098\089\104\091\094\114\082\051\089\104\094\094\051\089\114\082\091\089\082\071\091\061\089\104\051\091\104\071\071\104\089\114\082\104\081\030"), 
				Media = _CjWFg
			}, 
			{
				Text = _CAR("\008\040\039\121\058\123\051\051\094\091\098\089\104\091\104\089\081\104\091\042\025\012\036\123\052\043\104\091\004\104\094\089\001\127\104\081\124\091\079\123\081\081\091\083\089\104\094\104\091\004\104\089\091\083\104\071\091\098\108\114\082\104\091\004\104\082\089\051\070\051\089\114\082\091\094\104\089\081\030\008\040\039\121\008\040\039\121\118\089\104\091\009\089\081\080\104\089\094\104\091\094\089\081\083\091\123\004\104\071\091\123\108\114\082\091\103\082\081\104\091\042\025\012\036\123\052\043\104\091\070\089\081\083\004\123\071\030"), 
				Media = _i1B
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_pSqRA)
			end)
		end)
	elseif Wherigo.NoCaseEquals(_ZQz, input) then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\118\123\094\091\089\094\001\091\118\071\030\091\009\103\070\070\094\001\123\104\083\001\104\071\105\008\040\039\121\008\040\039\121\058\089\081\083\104\081\091\098\089\104\091\082\104\071\123\108\094\091\080\123\094\091\094\104\089\081\091\058\035\078\009\022\006\040\055\006\095\091\089\094\001\105"), 
				Media = _6Fk
			}, 
			{
				Text = _CAR("\022\104\082\104\081\091\098\089\104\091\083\123\127\108\091\089\081\091\094\104\089\081\091\036\123\004\103\071\105\008\040\039\121\008\040\039\121\098\104\089\081\091\036\123\004\103\071\091\004\104\070\089\081\083\104\001\091\094\089\114\082\091\123\108\070\091\123\108\070\091\006\004\104\081\104\091\024"), 
				Media = _Lpl
			}, 
			{
				Text = _CAR("\098\108\114\082\104\081\091\098\089\104\091\127\108\081\123\104\114\082\094\001\091\089\081\091\083\104\071\091\035\004\001\104\089\051\108\081\020\091\024\024\068\091\081\123\114\082\091\104\089\081\104\052\091\009\089\081\080\104\089\094\030\008\040\039\121\008\040\039\121\006\094\091\079\123\081\081\091\094\104\089\081\124\091\083\123\094\094\091\052\123\081\091\094\089\104\091\083\103\071\001\091\080\104\089\001\104\071\051\104\089\001\104\001\124\091\004\089\094\091\098\089\104\091\094\114\082\051\089\104\094\094\051\089\114\082\091\089\082\071\091\061\089\104\051\091\104\071\071\104\089\114\082\104\081\030"), 
				Media = _YZD
			}, 
			{
				Text = _CAR("\008\040\039\121\058\123\051\051\094\091\098\089\104\091\104\089\081\104\091\042\025\012\036\123\052\043\104\091\004\104\094\089\001\127\104\081\124\091\079\123\081\081\091\083\089\104\094\104\091\004\104\089\091\083\104\071\091\098\108\114\082\104\091\004\104\082\089\051\070\051\089\114\082\091\094\104\089\081\030\008\040\039\121\008\040\039\121\118\089\104\091\009\089\081\080\104\089\094\104\091\094\089\081\083\091\123\004\104\071\091\123\108\114\082\091\103\082\081\104\091\042\025\012\036\123\052\043\104\091\070\089\081\083\004\123\071\030"), 
				Media = _i1B
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_pSqRA)
			end)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\098\089\104\091\082\123\004\104\081\091\104\089\081\104\081\091\070\123\051\094\114\082\104\081\091\016\123\052\104\081\091\104\089\081\020\104\020\104\004\104\081\030\008\040\039\121\091\008\040\039\121\095\089\043\043\027\091\035\071\052\051\104\082\081\104\105")
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_Fe1)
			end)
		end)
	end
end
function _zNT:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(_trZ9, input) then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\008\040\039\121\039\089\114\082\001\089\020\105"), 
				Media = _oP63
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_Cjff)
			end)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\058\123\051\094\114\082\105\008\040\039\121\008\040\039\121\025\104\071\094\108\114\082\104\081\091\098\089\104\091\104\094\091\081\103\114\082\052\123\051\030"), 
				Media = _PN7
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_pSqRA)
			end)
		end)
	end
end
function _Cjff:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(_RymoZ, input) then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\008\040\039\121\039\089\114\082\001\089\020\105"), 
				Media = _oP63
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_WJ69e)
			end)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\058\123\051\094\114\082\105\008\040\039\121\008\040\039\121\025\104\071\094\108\114\082\104\081\091\098\089\104\091\104\094\091\081\103\114\082\052\123\051\030"), 
				Media = _PN7
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_pSqRA)
			end)
		end)
	end
end
function _WJ69e:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(_9Ifl, input) then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\008\040\039\121\039\091\055\091\078\091\009\091\095\091\055\091\022\105"), 
				Media = _oP63
			}, 
			{
				Text = _CAR("\098\089\104\091\082\123\004\104\081\091\123\051\051\104\091\016\035\065\006\016\091\083\104\071\091\072\089\094\094\104\081\094\114\082\123\070\001\051\104\071\091\108\081\083\091\089\082\071\104\091\058\035\078\009\022\006\040\055\006\095\006\091\082\104\071\123\108\094\020\104\070\108\081\083\104\081\030"), 
				Media = _RYS
			}, 
			{
				Text = _CAR("\118\108\071\114\082\091\055\082\071\104\091\035\071\004\104\089\001\091\079\103\081\081\001\104\081\091\098\089\104\091\123\108\114\082\091\082\104\071\123\108\094\070\089\081\083\104\081\124\091\080\103\091\083\089\104\091\001\103\104\083\051\089\114\082\104\091\058\103\071\052\104\051\091\077\104\071\094\001\104\114\079\001\091\020\104\082\123\051\001\104\081\091\080\089\071\083\030"), 
				Media = _RYS
			}, 
			{
				Text = _CAR("\118\103\114\082\091\004\104\077\103\071\091\098\089\104\091\083\123\094\091\025\104\071\094\001\104\114\079\091\123\108\070\094\108\114\082\104\081\091\079\103\104\081\081\104\081\124\091\052\108\104\094\094\104\081\091\098\089\104\091\083\089\104\091\072\123\114\082\104\081\091\123\004\051\104\081\079\104\081\030\008\040\039\121\008\040\039\121\025\103\071\091\083\104\052\091\022\104\004\123\104\108\083\104\091\004\104\070\089\081\083\104\001\091\094\089\114\082\091\104\089\081\104\091\040\103\052\004\104\124\091\083\089\104\091\098\089\104\091\070\104\071\081\127\108\104\081\083\104\081\091\079\103\104\081\081\104\081\030\008\040\039\121\008\040\039\121\022\104\082\104\081\091\094\089\104\091\089\081\091\083\089\104\091\035\004\001\104\089\051\108\081\020\091\063\003\068\124\091\083\103\071\001\091\070\089\081\083\104\081\091\098\089\104\091\083\104\081\091\078\103\083\104\091\127\108\071\091\061\108\104\081\083\108\081\020\030\008\040\039\121\008\040\039\121\008\040\039\121"), 
				Media = _q7k
			}, 
			{
				Text = _CAR("\098\047\055\006\036\091\022\006\098\047\006\055\078\009\006\039\095"), 
				Media = _vJyTz
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_LTu1F)
			end)
			_Ve7wP:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\058\123\051\094\114\082\105\008\040\039\121\008\040\039\121\025\104\071\094\108\114\082\104\081\091\098\089\104\091\104\094\091\081\103\114\082\052\123\051\030"), 
				Media = _PN7
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_WJ69e)
			end)
		end)
	end
end
function _LTu1F:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\058\123\051\094\114\082\105\008\040\039\121\008\040\039\121\098\108\114\082\104\081\091\098\089\104\091\083\104\081\091\040\103\052\004\104\081\114\103\083\104\091\089\081\091\083\104\071\091\035\004\001\104\089\051\108\081\020\091\063\003\068"), 
				Media = _q7k
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_LTu1F)
			end)
		end)
		return
	end
	if _wMQ == input then
		Wherigo.PlayAudio(_f1e)
		Wherigo.PlayAudio(_KWvi)
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\040\046\046\046\046\046\046\046\046\046\046\065\091\105\105\105\105\105\105\105\008\040\039\121\008\040\039\121\118\089\104\091\040\103\052\004\104\091\089\094\001\091\123\108\070\091\083\104\052\091\025\103\071\043\051\123\001\127\091\104\045\043\103\051\083\089\104\071\001\105\008\040\039\121\008\040\039\121"), 
				Media = _o6LU
			}, 
			{
				Text = _CAR("\118\089\104\091\072\123\114\082\104\081\091\094\089\081\083\091\123\004\020\104\051\104\081\079\001\124\091\083\123\094\091\047\068\091\080\089\071\083\091\104\077\123\079\108\089\104\071\001\105"), 
				Media = _RYS
			}, 
			{
				Text = _CAR("\009\103\051\104\081\091\094\089\104\091\011\104\001\127\001\091\083\089\104\091\001\103\104\083\051\089\114\082\104\091\058\103\071\052\104\051\091\123\108\094\091\089\082\071\104\052\091\025\104\071\094\001\104\114\079\091\089\081\091\083\104\071\091\035\004\001\104\089\051\108\081\020\091\015\029\125\030\091\057\040\104\089\091\083\104\071\091\118\123\114\082\071\089\081\081\104\124\091\108\081\001\104\081\053\008\040\039\121\008\040\039\121\042\104\004\104\071\052\089\001\001\104\051\081\091\098\089\104\091\052\089\071\091\083\089\104\091\058\103\071\052\104\051\091\100\081\004\094\043\119\094\103\070\103\071\001\091\080\104\081\081\091\098\089\104\091\094\089\104\091\020\104\070\108\081\083\104\081\091\082\123\004\104\081\030"), 
				Media = _DYKLS
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_SRf0)
			end)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\058\123\051\094\114\082\105\008\040\039\121\008\040\039\121\098\108\114\082\104\081\091\098\089\104\091\089\081\091\083\104\071\091\035\004\001\104\089\051\108\081\020\091\063\003\068\030"), 
				Media = _q7k
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_LTu1F)
			end)
		end)
	end
end
function _SRf0:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(_piP, input) then
		_cwh8:Stop()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _CAR("\058\123\051\094\114\082\105\008\040\039\121\008\040\039\121\118\089\104\091\058\103\071\052\104\051\091\089\094\001\091\089\052\091\055\081\081\104\071\081\091\083\104\071\091\118\103\094\104\030"), 
				Media = _pzipI
			}, 
			{
				Text = _CAR("\008\040\039\121\098\108\114\082\104\081\091\098\089\104\091\083\089\104\091\001\103\104\083\051\089\114\082\104\091\058\103\071\052\104\051\091\089\081\091\083\104\071\091\035\004\001\104\089\051\108\081\020\091\015\029\125\030\091\008\040\039\121\008\040\039\121\057\040\104\089\091\083\104\071\091\118\123\114\082\071\089\081\081\104\124\091\108\081\001\104\081\053"), 
				Media = _DYKLS
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_SRf0)
			end)
		end)
	end
end
function _cwh8:OnStop()
	Wherigo.PlayAudio(_vEWe)
	Wherigo.PlayAudio(_RJdyD)
	_ZsTcw.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = (_CAR("\009\104\071\071\077\103\071\071\123\020\104\081\083\091\035\020\104\081\001\091\100\081\004\094\043\119")..Player.Name).._CAR("\091\105\008\040\039\121\008\040\039\121\098\089\104\091\082\123\004\104\081\091\104\094\091\020\104\094\114\082\123\070\070\001\105"), 
			Media = _RYS
		}, 
		{
			Text = (_CAR("\098\089\104\091\082\123\004\104\081\091\070\108\104\071\091\083\104\081\091\035\108\070\001\071\123\020\091")..(_cwh8.Duration - _cwh8.Remaining)).._CAR("\091\098\104\079\108\081\083\104\081\091\020\104\004\071\123\108\114\082\001\105\008\040\039\121\008\040\039\121\098\078\009\039\006\055\040\006\016\091\098\055\006\091\118\055\006\091\061\006\055\095\091\035\042\058\105\008\040\039\121\008\040\039\121\040\104\089\091\055\082\071\104\071\091\039\108\104\114\079\079\104\082\071\091\127\108\071\091\040\123\094\089\094\091\001\071\123\020\104\081\091\098\089\104\091\083\089\104\094\104\091\061\104\089\001\091\089\052\091\006\089\081\094\123\001\127\051\103\020\004\108\114\082\091\104\089\081\105\105\105"), 
			Media = _aHnV
		}, 
		{
			Text = _CAR("\055\081\091\055\082\071\104\052\091\087\055\081\077\104\081\001\123\071\087\091\004\104\070\089\081\083\104\001\091\094\089\114\082\091\104\089\081\104\091\098\001\103\043\043\108\082\071\030\008\040\039\121\008\040\039\121\118\089\104\094\104\091\127\104\089\020\001\091\055\082\081\104\081\091\081\103\114\082\052\123\051\091\083\089\104\091\123\004\020\104\051\123\108\070\104\081\104\091\061\104\089\001\030\008\040\039\121\008\040\039\121\006\094\091\080\123\071\091\052\089\071\091\104\089\081\104\091\006\082\071\104\091\052\089\001\091\055\082\081\104\081\091\123\071\004\104\089\001\104\081\091\127\108\091\083\108\104\071\070\104\081\105\008\040\039\121\008\040\039\121\040\089\094\091\127\108\052\091\081\123\104\114\082\094\001\104\081\091\006\089\081\094\123\001\127\105"), 
			Media = _RYS
		}, 
		{
			Text = _CAR("\098\047\055\006\036\091\022\006\098\047\006\055\078\009\006\039\095"), 
			Media = _vJyTz
		}
	}, function(action)
		_Ve7wP:RequestSync()
	end)
end
function _ZsTcw:On_JMO(target)
	_Urwigo.Dialog(false, {
		{
			Text = (_CAR("\098\089\104\091\082\123\004\104\081\091")..(_cwh8.Duration - _cwh8.Remaining)).._CAR("\091\098\104\079\108\081\083\104\081\091\070\108\104\071\091\083\104\081\091\035\108\070\001\071\123\020\091\020\104\004\071\123\108\114\082\001\030"), 
			Media = _aHnV
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end

-- Urwigo functions --
function _4uH()
end

-- Begin user functions --
-- End user functions --
return _Ve7wP
