require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _t0b(str)
	local res = ""
    local dtable = "\084\041\111\086\117\033\005\072\100\016\024\010\043\120\029\007\095\102\015\081\075\123\114\046\065\054\020\071\126\058\096\085\097\023\060\103\101\044\030\067\073\028\082\050\047\069\042\040\093\110\014\026\104\032\064\048\045\018\022\087\076\013\077\002\034\089\059\057\037\062\080\078\079\099\006\106\036\108\090\116\012\074\011\009\121\061\001\055\083\105\000\031\049\027\021\038\039\063\056\125\118\115\112\092\019\088\070\035\008\004\119\053\051\098\109\052\122\025\113\003\017\068\107\091\124\066\094"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

cartLaPulperie = Wherigo.ZCartridge()

-- Media --
zmediaJEADubuc = Wherigo.ZMedia(cartLaPulperie)
zmediaJEADubuc.Id = "e67539dc-3e6c-4e5b-8b2b-d140c8389299"
zmediaJEADubuc.Name = _t0b("\082\057\046\057\025\054\122\005\114\005\074")
zmediaJEADubuc.Description = _t0b("\061\037\054\114\033\050\119\005\090\037\023\054\033\102\102\003\074\090\037\054\033\054\082\057\122\054\028\005\033\085\024")
zmediaJEADubuc.AltText = ""
zmediaJEADubuc.Resources = {
	{
		Type = "jpg", 
		Filename = "Dubuc.jpg", 
		Directives = {}
	}
}
zmediaJDGuay = Wherigo.ZMedia(cartLaPulperie)
zmediaJDGuay.Id = "9c9d52ce-2826-48fc-83b0-a537ee811faa"
zmediaJDGuay.Name = _t0b("\082\057\122\054\028\005\033\085")
zmediaJDGuay.Description = _t0b("\061\037\054\115\033\090\023\037\054\037\078\005\054\009\037\054\040\053\090\074\003\005\080\090\115\090\054\033\054\078\097\037\103\003\119\005\037\024")
zmediaJDGuay.AltText = ""
zmediaJDGuay.Resources = {
	{
		Type = "jpg", 
		Filename = "JD_Guay_Maire.jpg", 
		Directives = {}
	}
}
zmediaPulperie = Wherigo.ZMedia(cartLaPulperie)
zmediaPulperie.Id = "59a84517-e4e6-46ae-88a2-8d6d79eaf108"
zmediaPulperie.Name = _t0b("\071\005\078\103\037\023\090\037")
zmediaPulperie.Description = _t0b("\046\009\090\018\090\074\037\054\103\023\090\050\074\090\103\033\078\037\054\093\068\044\093")
zmediaPulperie.AltText = ""
zmediaPulperie.Resources = {
	{
		Type = "jpg", 
		Filename = "1921.jpg", 
		Directives = {}
	}
}
zmediaPlandusite = Wherigo.ZMedia(cartLaPulperie)
zmediaPlandusite.Id = "1097c5cc-cb06-4773-92fe-6c779aed9b59"
zmediaPlandusite.Name = _t0b("\071\078\033\050\054\009\005\054\102\090\080\037")
zmediaPlandusite.Description = _t0b("\061\037\054\103\078\033\050\054\009\005\054\102\090\080\037\054\009\037\054\078\033\054\071\005\078\103\037\023\090\037\024")
zmediaPlandusite.AltText = ""
zmediaPlandusite.Resources = {
	{
		Type = "png", 
		Filename = "Pulperie_plan.png", 
		Directives = {}
	}
}
zmediaEdifice1903 = Wherigo.ZMedia(cartLaPulperie)
zmediaEdifice1903.Id = "c00eaaba-09b7-4364-9856-de15d123253c"
zmediaEdifice1903.Name = _t0b("\046\009\090\018\090\074\037\054\093\068\056\113")
zmediaEdifice1903.Description = _t0b("\061\097\046\009\090\018\090\074\037\054\093\068\056\113\024")
zmediaEdifice1903.AltText = ""
zmediaEdifice1903.Resources = {
	{
		Type = "jpg", 
		Filename = "1903.jpg", 
		Directives = {}
	}
}
zmediaStaff = Wherigo.ZMedia(cartLaPulperie)
zmediaStaff.Id = "4e5f0059-4a61-42ae-a3b2-1749933862a2"
zmediaStaff.Name = _t0b("\089\080\033\018\018")
zmediaStaff.Description = _t0b("\061\037\054\103\037\023\102\003\050\050\037\078\054\033\005\054\009\037\114\005\080\054\009\037\102\054\003\103\037\023\033\080\090\003\050\102\024")
zmediaStaff.AltText = ""
zmediaStaff.Resources = {
	{
		Type = "jpg", 
		Filename = "Staff.jpg", 
		Directives = {}
	}
}
zmediaSitedeLaPulperie = Wherigo.ZMedia(cartLaPulperie)
zmediaSitedeLaPulperie.Id = "a4b7fe9d-0a11-4909-b0b0-b07ef50f0bf8"
zmediaSitedeLaPulperie.Name = _t0b("\089\090\080\037\054\009\037\054\061\033\054\071\005\078\103\037\023\090\037")
zmediaSitedeLaPulperie.Description = _t0b("\004\005\037\054\036\037\050\037\023\033\078\037\054\009\005\054\102\090\080\037\054\009\037\054\061\033\054\071\005\078\103\037\023\090\037\024")
zmediaSitedeLaPulperie.AltText = ""
zmediaSitedeLaPulperie.Resources = {
	{
		Type = "jpg", 
		Filename = "Pulperie.jpg", 
		Directives = {}
	}
}
zmediaSculpture = Wherigo.ZMedia(cartLaPulperie)
zmediaSculpture.Id = "ff254ddf-16cf-4f85-8489-8ee787910a9d"
zmediaSculpture.Name = _t0b("\089\074\005\078\103\080\005\023\037")
zmediaSculpture.Description = _t0b("\061\033\054\089\074\005\078\103\080\005\023\037\054\009\037\054\115\037\080\033\078\054\033\054\078\097\037\050\080\023\037\037\054\009\005\054\102\090\080\037\054\009\037\054\061\033\054\071\005\078\103\037\023\090\037\024")
zmediaSculpture.AltText = ""
zmediaSculpture.Resources = {
	{
		Type = "JPG", 
		Filename = "Sculpture.JPG", 
		Directives = {}
	}
}
zmediaPoint_Interrogation = Wherigo.ZMedia(cartLaPulperie)
zmediaPoint_Interrogation.Id = "70faf8e9-a056-4651-b99f-4c1176a96474"
zmediaPoint_Interrogation.Name = _t0b("\071\003\090\050\080\017\041\050\080\037\023\023\003\036\033\080\090\003\050")
zmediaPoint_Interrogation.Description = ""
zmediaPoint_Interrogation.AltText = ""
zmediaPoint_Interrogation.Resources = {
	{
		Type = "jpg", 
		Filename = "pointd_interrogation.jpg", 
		Directives = {}
	}
}
zmediaExclamation = Wherigo.ZMedia(cartLaPulperie)
zmediaExclamation.Id = "190e0558-fbbe-4d0d-862a-b55ab969ef3d"
zmediaExclamation.Name = _t0b("\046\014\074\078\033\115\033\080\090\003\050")
zmediaExclamation.Description = ""
zmediaExclamation.AltText = ""
zmediaExclamation.Resources = {
	{
		Type = "jpg", 
		Filename = "Exclamation.jpg", 
		Directives = {}
	}
}
zmediaYes = Wherigo.ZMedia(cartLaPulperie)
zmediaYes.Id = "66dc47ed-5fbb-4b3b-b80f-91f8caf94e39"
zmediaYes.Name = _t0b("\066\037\102")
zmediaYes.Description = _t0b("\089\085\115\114\003\078\037\054\033\054\033\018\018\090\074\053\037\023\054\078\003\023\102\119\005\097\003\050\054\033\054\005\050\037\054\114\003\050\050\037\054\023\037\103\003\050\102\037\024")
zmediaYes.AltText = ""
zmediaYes.Resources = {
	{
		Type = "png", 
		Filename = "yesss.png", 
		Directives = {}
	}
}
zmediaQuestion = Wherigo.ZMedia(cartLaPulperie)
zmediaQuestion.Id = "aef57392-128d-4cbc-acfd-e59c298a9e9e"
zmediaQuestion.Name = _t0b("\020\005\037\102\080\090\003\050")
zmediaQuestion.Description = ""
zmediaQuestion.AltText = ""
zmediaQuestion.Resources = {
	{
		Type = "jpg", 
		Filename = "pointd_interrogation1.jpg", 
		Directives = {}
	}
}
zmediaVille = Wherigo.ZMedia(cartLaPulperie)
zmediaVille.Id = "fb8992d6-5e65-433a-9178-0236c3ea8470"
zmediaVille.Name = _t0b("\004\090\078\078\037")
zmediaVille.Description = _t0b("\004\005\037\054\102\005\023\054\078\033\054\101\090\078\078\037\054\009\037\054\040\053\090\074\003\005\080\090\115\090\054\033\054\103\033\023\080\090\023\054\009\005\054\102\090\080\037\054\009\037\054\061\033\054\071\005\078\103\037\023\090\037\024")
zmediaVille.AltText = ""
zmediaVille.Resources = {
	{
		Type = "jpg", 
		Filename = "Ville.jpg", 
		Directives = {}
	}
}
_wP1qt = Wherigo.ZMedia(cartLaPulperie)
_wP1qt.Id = "af11f5f2-c36b-4a17-94f3-d17aad1ed9b0"
_wP1qt.Name = _t0b("\061\003\074\003\115\003\080\090\101\037")
_wP1qt.Description = _t0b("\061\033\054\078\003\074\003\115\003\080\090\101\037\054\033\054\078\033\054\103\003\023\080\037\054\009\037\054\078\033\054\071\005\078\103\037\023\090\037\024\054\096\050\114\102\103\067\046\078\078\037\054\003\023\090\036\090\050\037\054\009\037\054\078\033\054\074\003\115\103\033\036\050\090\037\054\089\033\036\005\037\050\033\085\054\071\003\111\037\023\054\037\080\054\103\003\023\080\037\054\078\037\054\050\005\115\037\023\003\054\093\056\026\024")
_wP1qt.AltText = ""
_wP1qt.Resources = {
	{
		Type = "jpg", 
		Filename = "DSC00435.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
cartLaPulperie.Id="b25740f9-83dc-498c-be18-1c7226f85dca"
cartLaPulperie.Name="La Pulperie"
cartLaPulperie.Description=[[La Compagnie de pulpe de Chicoutimi (La Pulperie), mise sur pied par Julien-Edouard-Alfred Dubuc a fait de Chicoutimi une veritable metropole regionale. Cette entreprise a mis sur pied la premiere usine de pate de cette ville du Saguenay.  La Compagnie de pulpe de Chicoutimi recevait sa charte d'incorporation le 3 avril 1897. Le promoteur Julien-Edouard-Alfred Dubuc en devenait alors le directeur-gerant, poste qu'il occupera jusqu'en 1923. Sous la direction de Dubuc, cette entreprise employait 150 hommes des sa premiere annee d'operation, 800 en 1912, et plus de 1000 en 1920. Pendant la meme periode, la population de Chicoutimi passait de 3800, en 1901, a 9000, en 1921. Malgre son succes, la difficulte qu'eprouve la Compagnie a trouver du capital la mene vers la faillite. En mettant volontairement de cote la production de papier, Dubuc se fermait un marche qui n'allait s'ouvrir qu'une fois la crise d'apres-guerre terminee.]]
cartLaPulperie.Visible=true
cartLaPulperie.Activity="Geocache"
cartLaPulperie.StartingLocationDescription=[[Les coordonnees sont celles du stationnement. L'adresse civique est 300 rue Dubuc, Chicoutimi, QC]]
cartLaPulperie.StartingLocation = ZonePoint(48.422433,-71.079183,0)
cartLaPulperie.Version="2.1"
cartLaPulperie.Company=""
cartLaPulperie.Author="Danatisy"
cartLaPulperie.BuilderVersion="URWIGO 1.14.4469.18959"
cartLaPulperie.CreateDate="09/20/2009 14:23:12"
cartLaPulperie.PublishDate="1/1/0001 12:00:00 AM"
cartLaPulperie.UpdateDate="01/13/2013 17:38:41"
cartLaPulperie.LastPlayedDate="1/1/0001 12:00:00 AM"
cartLaPulperie.TargetDevice="PocketPC"
cartLaPulperie.TargetDeviceVersion="0"
cartLaPulperie.StateId="1"
cartLaPulperie.CountryId="2"
cartLaPulperie.Complete=false
cartLaPulperie.UseLogging=true

cartLaPulperie.Media=zmediaSitedeLaPulperie

cartLaPulperie.Icon=zmediaSitedeLaPulperie


-- Zones --
zoneSculpture = Wherigo.Zone(cartLaPulperie)
zoneSculpture.Id = "79a67c37-5da8-4b11-a329-70cdde58d6c2"
zoneSculpture.Name = _t0b("\089\074\005\078\103\080\005\023\037")
zoneSculpture.Description = _t0b("\071\003\090\050\080\054\009\037\054\009\037\103\033\023\080\030\054\061\090\037\005\054\093\024\054\096\050\114\102\103\067\004\003\005\102\054\101\003\085\037\117\054\074\037\080\080\037\054\102\074\005\078\103\080\005\023\037\054\074\003\050\074\005\037\054\103\033\023\054\025\050\009\023\037\054\107\003\005\023\050\037\078\078\037\054\037\080\054\018\033\114\023\090\119\005\037\037\054\103\033\023\054\063\037\080\033\078\054\082\033\103\037\080\037\074\054\037\050\054\044\056\056\113\024\054\096\050\114\102\103\067\046\078\078\037\054\037\102\080\054\080\003\005\080\037\054\009\097\033\074\090\037\023\054\037\080\054\074\097\037\102\080\054\103\003\005\023\054\074\037\080\080\037\054\023\033\090\102\003\050\054\119\005\097\037\078\078\037\054\037\102\080\054\009\037\054\074\037\080\080\037\054\074\003\005\078\037\005\023\024")
zoneSculpture.Visible = true
zoneSculpture.Media = zmediaSculpture
zoneSculpture.Commands = {}
zoneSculpture.DistanceRange = Distance(-1, "feet")
zoneSculpture.ShowObjects = "OnProximity"
zoneSculpture.ProximityRange = Distance(50, "meters")
zoneSculpture.AllowSetPositionTo = false
zoneSculpture.Active = true
zoneSculpture.Points = {
	ZonePoint(48.422782, -71.080395, 0), 
	ZonePoint(48.422708, -71.080459, 0), 
	ZonePoint(48.422667, -71.080293, 0), 
	ZonePoint(48.422754, -71.080231, 0), 
	ZonePoint(48.422782, -71.080395, 0)
}
zoneSculpture.OriginalPoint = ZonePoint(48.422809, -71.08039, 0)
zoneSculpture.DistanceRangeUOM = "Feet"
zoneSculpture.ProximityRangeUOM = "Meters"
zoneSculpture.OutOfRangeName = ""
zoneSculpture.InRangeName = ""
zoneEdifice1921 = Wherigo.Zone(cartLaPulperie)
zoneEdifice1921.Id = "db6ae9ee-1484-4c0d-9e9e-1b751aeb0c02"
zoneEdifice1921.Name = _t0b("\046\009\090\018\090\074\037\054\093\068\044\093")
zoneEdifice1921.Description = _t0b("\046\009\090\018\090\074\037\054\103\023\090\050\074\090\103\033\078\054\009\005\054\102\090\080\037\024\054\096\050\114\102\103\067\040\097\037\102\080\054\009\033\050\102\054\074\037\054\114\033\080\090\115\037\050\080\054\119\005\037\054\101\003\005\102\054\101\037\023\023\037\117\054\078\037\054\115\005\102\037\037\054\037\080\054\078\033\054\115\033\090\102\003\050\054\025\023\080\053\005\023\057\004\090\078\078\037\050\037\005\101\037\024")
zoneEdifice1921.Visible = true
zoneEdifice1921.Media = zmediaPulperie
zoneEdifice1921.Commands = {}
zoneEdifice1921.DistanceRange = Distance(1500, "feet")
zoneEdifice1921.ShowObjects = "OnProximity"
zoneEdifice1921.ProximityRange = Distance(50, "meters")
zoneEdifice1921.AllowSetPositionTo = false
zoneEdifice1921.Active = false
zoneEdifice1921.Points = {
	ZonePoint(48.422457, -71.081133, 0), 
	ZonePoint(48.42233, -71.081162, 0), 
	ZonePoint(48.422231, -71.081009, 0), 
	ZonePoint(48.422334, -71.080889, 0), 
	ZonePoint(48.422457, -71.081133, 0)
}
zoneEdifice1921.OriginalPoint = ZonePoint(48.422232, -71.081781, 0)
zoneEdifice1921.DistanceRangeUOM = "Feet"
zoneEdifice1921.ProximityRangeUOM = "Meters"
zoneEdifice1921.OutOfRangeName = ""
zoneEdifice1921.InRangeName = ""
zoneEdifice1903 = Wherigo.Zone(cartLaPulperie)
zoneEdifice1903.Id = "d132a4df-14e9-4f78-91f4-5b38a207a49a"
zoneEdifice1903.Name = _t0b("\046\009\090\018\090\074\037\054\093\068\056\113")
zoneEdifice1903.Description = _t0b("\061\037\054\103\003\090\050\080\054\074\005\078\115\090\050\033\050\080\054\009\005\054\102\090\080\037\038\054\103\023\037\102\054\009\037\054\078\097\046\009\090\018\090\074\037\054\093\068\056\113\024")
zoneEdifice1903.Visible = true
zoneEdifice1903.Media = zmediaEdifice1903
zoneEdifice1903.Commands = {}
zoneEdifice1903.DistanceRange = Distance(1500, "feet")
zoneEdifice1903.ShowObjects = "OnProximity"
zoneEdifice1903.ProximityRange = Distance(50, "meters")
zoneEdifice1903.AllowSetPositionTo = false
zoneEdifice1903.Active = false
zoneEdifice1903.Points = {
	ZonePoint(48.4205692545134, -71.0849176932888, 0), 
	ZonePoint(48.4209573080068, -71.0851456810551, 0), 
	ZonePoint(48.4210000293113, -71.0847862650471, 0), 
	ZonePoint(48.4207632816304, -71.0844858576374, 0), 
	ZonePoint(48.420556794031, -71.0845555950718, 0)
}
zoneEdifice1903.OriginalPoint = ZonePoint(48.421725, -71.08432, 0)
zoneEdifice1903.DistanceRangeUOM = "Feet"
zoneEdifice1903.ProximityRangeUOM = "Meters"
zoneEdifice1903.OutOfRangeName = ""
zoneEdifice1903.InRangeName = ""
zoneFinale = Wherigo.Zone(cartLaPulperie)
zoneFinale.Id = "8df8d2f6-a467-4288-a078-e3413bc01edc"
zoneFinale.Name = _t0b("\025\101\033\050\080\017\107\090\050\033\078\037")
zoneFinale.Description = _t0b("\061\033\054\061\090\037\005\054\009\037\054\078\097\033\101\033\050\080\057\018\090\050\033\078\037\054\003\005\054\101\003\005\102\054\009\037\101\023\037\117\054\023\037\103\003\050\009\023\037\054\033\054\005\050\037\054\119\005\037\102\080\090\003\050\054\018\033\074\090\078\037\054\033\101\033\050\080\054\009\037\054\101\003\005\102\054\009\090\023\090\036\037\023\054\101\037\023\102\054\078\033\054\107\090\050\033\078\037")
zoneFinale.Visible = true
zoneFinale.Media = zmediaPoint_Interrogation
zoneFinale.Commands = {}
zoneFinale.DistanceRange = Distance(1500, "feet")
zoneFinale.ShowObjects = "OnProximity"
zoneFinale.ProximityRange = Distance(50, "meters")
zoneFinale.AllowSetPositionTo = false
zoneFinale.Active = false
zoneFinale.Points = {
	ZonePoint(48.4219260904027, -71.0807000245543, 0), 
	ZonePoint(48.421968810893, -71.080461307952, 0), 
	ZonePoint(48.421873, -71.080398, 0), 
	ZonePoint(48.4218308591805, -71.0806678380461, 0)
}
zoneFinale.OriginalPoint = ZonePoint(48.421898, -71.081131, 0)
zoneFinale.DistanceRangeUOM = "Feet"
zoneFinale.ProximityRangeUOM = "Meters"
zoneFinale.OutOfRangeName = ""
zoneFinale.InRangeName = ""
_MPFoS = Wherigo.Zone(cartLaPulperie)
_MPFoS.Id = "6b4cd0c5-0158-4fee-8f95-fc8e485844e1"
_MPFoS.Name = _t0b("\107\090\050\033\078\037")
_MPFoS.Description = _t0b("\061\037\054\061\090\037\005\054\009\037\054\078\033\054\018\090\050\033\078\037\054\003\005\054\078\037\054\074\033\023\050\037\080\054\009\037\054\101\090\102\090\080\037\054\103\037\005\080\054\037\050\018\090\050\054\037\080\023\037\054\102\090\036\050\037\024")
_MPFoS.Visible = true
_MPFoS.Media = _wP1qt
_MPFoS.Commands = {}
_MPFoS.DistanceRange = Distance(-1, "feet")
_MPFoS.ShowObjects = "OnEnter"
_MPFoS.ProximityRange = Distance(60, "meters")
_MPFoS.AllowSetPositionTo = false
_MPFoS.Active = false
_MPFoS.Points = {
	ZonePoint(48.4221441730505, -71.0811814282417, 0), 
	ZonePoint(48.4222278423157, -71.0810534656048, 0), 
	ZonePoint(48.4221762219817, -71.0809502005577, 0), 
	ZonePoint(48.4220756511807, -71.081091016531, 0)
}
_MPFoS.OriginalPoint = ZonePoint(48.4221559721321, -71.0810690277338, 0)
_MPFoS.DistanceRangeUOM = "Feet"
_MPFoS.ProximityRangeUOM = "Meters"
_MPFoS.OutOfRangeName = ""
_MPFoS.InRangeName = ""

-- Characters --
zcharacterJulienEdouardAlfredDubuc = Wherigo.ZCharacter(cartLaPulperie)
zcharacterJulienEdouardAlfredDubuc.Id = "bfc4f34b-3ea5-4747-870f-fccf8e1c08aa"
zcharacterJulienEdouardAlfredDubuc.Name = _t0b("\082\005\078\090\037\050\057\046\009\003\005\033\023\009\057\025\078\018\023\037\009\054\122\005\114\005\074")
zcharacterJulienEdouardAlfredDubuc.Description = _t0b("\082\005\078\090\037\050\057\046\009\003\005\033\023\009\057\025\078\018\023\037\009\054\122\005\114\005\074\054\048\044\093\054\076\033\050\101\090\037\023\054\093\099\088\093\054\057\054\113\056\054\003\074\080\003\114\023\037\054\093\068\116\088\054\002\054\037\102\080\054\005\050\054\053\003\115\115\037\054\009\097\033\018\018\033\090\023\037\102\054\037\080\054\103\003\078\090\080\090\074\090\037\050\054\074\033\050\033\009\090\037\050\054\102\005\023\080\003\005\080\054\023\037\074\003\050\050\005\054\103\003\005\023\054\102\003\050\054\023\003\078\037\054\074\003\050\102\090\009\037\023\033\114\078\037\054\009\033\050\102\054\078\037\054\009\037\101\037\078\003\103\103\037\115\037\050\080\054\037\074\003\050\003\115\090\119\005\037\054\037\080\054\090\050\009\005\102\080\023\090\037\078\054\009\037\054\078\033\054\023\037\036\090\003\050\054\009\005\054\089\033\036\005\037\050\033\085\057\061\033\074\057\089\033\090\050\080\057\082\037\033\050\024\054\122\037\054\093\099\068\026\054\033\054\093\068\044\044\038\054\090\078\054\037\102\080\054\033\054\078\033\054\080\037\080\037\054\009\037\054\078\033\054\040\003\115\103\033\036\050\090\037\054\009\037\054\071\005\078\103\037\054\009\037\054\040\053\090\074\003\005\080\090\115\090\054\038\054\078\033\054\103\023\037\115\090\037\023\037\054\037\050\080\023\037\103\023\090\102\037\054\074\033\050\033\009\090\037\050\050\037\057\018\023\033\050\074\033\090\102\037\054\115\005\078\080\090\050\033\080\090\003\050\033\078\037\054\003\037\005\101\023\033\050\080\054\009\033\050\102\054\078\037\054\009\003\115\033\090\050\037\054\009\037\102\054\103\033\080\037\102\054\037\080\054\103\033\103\090\037\023\102\024\054\025\023\009\037\050\080\054\009\037\018\037\050\102\037\005\023\054\009\037\054\078\097\037\115\033\050\074\090\103\033\080\090\003\050\054\037\074\003\050\003\115\090\119\005\037\054\009\037\102\054\074\033\050\033\009\090\037\050\102\057\018\023\033\050\074\033\090\102\038\054\090\078\054\037\050\074\003\005\023\033\036\037\023\033\054\078\033\054\018\003\023\115\033\080\090\003\050\054\009\037\102\054\103\023\037\115\090\037\023\102\054\102\085\050\009\090\074\033\080\102\054\074\033\080\053\003\078\090\119\005\037\102\054\009\033\050\102\054\102\003\050\054\037\050\080\023\037\103\023\090\102\037\054\037\080\054\102\037\023\033\054\078\037\054\009\037\103\005\080\037\054\018\037\009\037\023\033\078\054\009\037\054\078\033\054\074\090\023\074\003\050\102\074\023\090\103\080\090\003\050\054\040\053\090\074\003\005\080\090\115\090\057\089\033\036\005\037\050\033\085\054\048\093\068\044\112\057\093\068\116\112\002\054\037\080\054\078\037\054\115\033\090\023\037\054\009\037\054\040\053\090\074\003\005\080\090\115\090\054\048\093\068\113\116\057\093\068\113\026\002\024")
zcharacterJulienEdouardAlfredDubuc.Visible = true
zcharacterJulienEdouardAlfredDubuc.Media = zmediaJEADubuc
zcharacterJulienEdouardAlfredDubuc.Commands = {}
zcharacterJulienEdouardAlfredDubuc.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterJulienEdouardAlfredDubuc.Gender = "Male"
zcharacterJulienEdouardAlfredDubuc.Type = "NPC"
zcharacterJosephDominiqueGuay = Wherigo.ZCharacter(cartLaPulperie)
zcharacterJosephDominiqueGuay.Id = "384c0b88-47fc-486f-a248-c9eb4a1e819e"
zcharacterJosephDominiqueGuay.Name = _t0b("\082\003\102\037\103\053\057\122\003\115\090\050\090\119\005\037\054\028\005\033\085")
zcharacterJosephDominiqueGuay.Description = _t0b("\072\037\054\033\054\040\053\090\074\003\005\080\090\115\090\054\078\037\054\093\116\054\033\101\023\090\078\054\093\099\026\026\038\054\082\003\102\037\103\053\057\122\003\115\090\050\090\119\005\037\054\028\005\033\085\038\054\018\090\078\102\054\009\005\054\115\033\023\074\053\033\050\009\054\082\003\053\050\050\085\054\028\005\033\085\054\037\080\033\090\080\054\005\050\054\053\003\115\115\037\054\009\097\033\018\018\033\090\023\037\102\054\037\080\054\005\050\054\053\003\115\115\037\054\103\003\078\090\080\090\119\005\037\054\074\033\050\033\009\090\037\050\057\018\023\033\050\074\033\090\102\024\054\096\050\114\102\103\067\041\115\103\078\090\119\005\037\054\009\033\050\102\054\080\003\005\080\037\102\054\102\003\023\080\037\102\054\009\097\037\050\080\023\037\103\023\090\102\037\102\038\054\082\003\102\037\103\053\057\122\003\115\090\050\090\119\005\037\054\028\005\033\085\054\018\003\050\009\037\038\054\037\050\054\093\099\099\088\038\054\078\037\054\076\003\005\023\050\033\078\054\078\037\054\071\023\003\036\023\037\102\054\122\005\054\089\033\036\005\037\050\033\085\038\054\090\078\054\103\005\114\078\090\037\054\102\003\050\054\103\023\037\115\090\037\023\054\050\005\115\037\023\003\054\078\037\054\093\099\054\033\003\005\080\054\093\099\099\099\024\054\071\037\050\009\033\050\080\054\103\078\005\102\054\009\037\054\044\056\054\033\050\102\038\054\090\078\054\102\037\023\033\054\103\023\003\103\023\090\037\080\033\090\023\037\038\054\037\009\090\080\037\005\023\054\037\080\054\023\037\009\033\074\080\037\005\023\024\054\096\050\114\102\103\067\046\078\005\054\115\033\090\023\037\054\009\037\054\040\053\090\074\003\005\080\090\115\090\054\037\050\054\093\099\068\112\038\054\090\050\090\080\090\033\080\037\005\023\054\009\005\054\103\023\003\076\037\080\054\009\037\054\078\033\054\040\024\071\024\040\024\054\090\078\054\018\003\050\009\037\054\078\033\054\074\003\115\103\033\036\050\090\037\054\078\037\054\044\116\054\050\003\101\037\115\114\023\037\054\093\099\068\026\038\054\037\050\054\102\097\033\102\102\003\074\090\033\050\080\054\033\101\037\074\054\119\005\037\078\119\005\037\102\054\033\115\090\102\054\009\003\050\080\054\005\050\054\076\037\005\050\037\054\053\003\115\115\037\054\009\097\033\018\018\033\090\023\037\102\038\054\082\005\078\090\037\050\057\046\009\003\005\033\023\009\057\025\078\018\023\037\009\054\122\005\114\005\074\054\037\080\054\078\037\054\050\003\115\115\037\054\122\090\023\037\074\080\037\005\023\057\036\037\023\033\050\080\054\009\037\054\078\033\054\040\024\071\024\040\024\054\048\040\003\115\103\033\036\050\090\037\054\009\037\054\071\005\078\103\037\054\009\037\054\040\053\090\074\003\005\080\090\115\090\002\024\054\041\078\054\009\003\080\033\054\078\033\054\101\090\078\078\037\054\009\037\054\078\097\037\078\037\074\080\023\090\074\090\080\037\054\037\080\054\009\097\005\050\054\023\037\102\037\033\005\054\009\097\033\119\005\037\009\005\074\102\038\054\037\080\054\009\037\115\090\102\102\090\003\050\050\037\054\009\037\054\102\003\050\054\103\003\102\080\037\054\009\037\054\115\033\090\023\037\054\033\103\023\037\102\054\088\054\033\050\102\054\048\093\068\056\044\002\054\037\080\054\023\037\080\003\005\023\050\037\054\033\054\102\037\102\054\033\018\018\033\090\023\037\102\054\048\040\024\071\024\040\024\038\054\071\023\003\036\023\037\102\054\122\005\054\089\033\036\005\037\050\033\085\002\024\054\043\037\080\003\005\023\054\037\050\054\093\068\044\044\054\033\054\078\033\054\115\033\090\023\090\037\024\054\122\037\074\037\009\037\054\033\054\040\053\090\074\003\005\080\090\115\090\038\054\078\037\054\093\099\054\102\037\103\080\037\115\114\023\037\054\093\068\044\112\024")
zcharacterJosephDominiqueGuay.Visible = true
zcharacterJosephDominiqueGuay.Media = zmediaJDGuay
zcharacterJosephDominiqueGuay.Commands = {}
zcharacterJosephDominiqueGuay.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterJosephDominiqueGuay.Gender = "Male"
zcharacterJosephDominiqueGuay.Type = "NPC"
zcharacterEmployes = Wherigo.ZCharacter(cartLaPulperie)
zcharacterEmployes.Id = "dd5f139b-db69-4e02-a34d-5852b6b8f798"
zcharacterEmployes.Name = _t0b("\046\115\103\078\003\085\037\102")
zcharacterEmployes.Description = _t0b("\032\050\054\036\023\003\005\103\037\054\009\097\037\115\103\078\003\085\037\102\054\119\005\090\054\080\023\033\101\033\090\078\078\033\090\037\050\080\054\033\054\078\033\054\071\005\078\103\037\023\090\037\054\009\037\054\040\053\090\074\003\005\080\090\115\090\024\054\040\037\080\080\037\054\037\050\080\023\037\103\023\090\102\037\054\037\115\103\078\003\085\033\090\080\054\093\112\056\054\053\003\115\115\037\102\054\009\037\102\054\102\033\054\103\023\037\115\090\037\023\037\054\033\050\050\037\037\054\009\097\003\103\037\023\033\080\090\003\050\038\054\099\056\056\054\037\050\054\093\068\093\044\038\054\037\080\054\103\078\005\102\054\009\037\054\093\056\056\056\054\037\050\054\093\068\044\056\024\054\071\037\050\009\033\050\080\054\078\033\054\115\037\115\037\054\103\037\023\090\003\009\037\038\054\078\033\054\103\003\103\005\078\033\080\090\003\050\054\009\037\054\040\053\090\074\003\005\080\090\115\090\054\103\033\102\102\033\090\080\054\009\037\054\113\099\056\056\038\054\037\050\054\093\068\056\093\038\054\033\054\068\056\056\056\038\054\037\050\054\093\068\044\093\024")
zcharacterEmployes.Visible = true
zcharacterEmployes.Media = zmediaStaff
zcharacterEmployes.Commands = {}
zcharacterEmployes.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterEmployes.Gender = "It"
zcharacterEmployes.Type = "NPC"

-- Items --
zitemInterrogation = Wherigo.ZItem(cartLaPulperie)
zitemInterrogation.Id = "37434b04-98f3-47d9-a9a6-d0d2bc0f5fbe"
zitemInterrogation.Name = _t0b("\041\050\080\037\023\023\003\036\033\080\090\003\050")
zitemInterrogation.Description = ""
zitemInterrogation.Visible = true
zitemInterrogation.Media = zmediaPoint_Interrogation
zitemInterrogation.Commands = {}
zitemInterrogation.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemInterrogation.Locked = false
zitemInterrogation.Opened = false
zitemQuestions = Wherigo.ZItem(cartLaPulperie)
zitemQuestions.Id = "b774de78-4170-4320-8c62-12cd79079906"
zitemQuestions.Name = _t0b("\020\005\037\102\080\090\003\050\102")
zitemQuestions.Description = _t0b("\004\003\005\102\054\037\080\037\102\054\037\050\080\023\037\054\033\054\078\097\090\050\080\037\023\090\037\005\023\054\009\005\054\102\090\080\037\054\003\005\054\102\037\054\080\023\003\005\101\037\054\078\033\054\074\033\074\053\037\024\054\096\050\114\102\103\067\061\037\102\054\074\003\003\023\009\003\050\050\037\037\102\054\102\037\023\003\050\080\054\033\018\018\090\074\053\037\037\054\009\033\050\102\054\005\050\054\103\023\003\074\053\033\090\050\054\115\037\102\102\033\036\037\024\054\089\003\085\037\117\054\033\080\080\037\050\080\090\018\006")
zitemQuestions.Visible = true
zitemQuestions.Media = zmediaQuestion
zitemQuestions.Commands = {}
zitemQuestions.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemQuestions.Locked = false
zitemQuestions.Opened = false
zitemExclamation = Wherigo.ZItem(cartLaPulperie)
zitemExclamation.Id = "2af238f9-020e-4a0d-bb37-e30acfcbc87d"
zitemExclamation.Name = _t0b("\046\014\074\078\033\115\033\080\090\003\050")
zitemExclamation.Description = ""
zitemExclamation.Visible = true
zitemExclamation.Media = zmediaExclamation
zitemExclamation.Commands = {}
zitemExclamation.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemExclamation.Locked = false
zitemExclamation.Opened = false
zitemYes = Wherigo.ZItem(cartLaPulperie)
zitemYes.Id = "9c008eaf-bbdf-4e16-b090-bd879f672322"
zitemYes.Name = _t0b("\066\037\102")
zitemYes.Description = ""
zitemYes.Visible = true
zitemYes.Media = zmediaYes
zitemYes.Commands = {}
zitemYes.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemYes.Locked = false
zitemYes.Opened = false

-- Tasks --
ztask1AllezaSculpture = Wherigo.ZTask(cartLaPulperie)
ztask1AllezaSculpture.Id = "33a84331-3543-42f3-acc7-662819a3e099"
ztask1AllezaSculpture.Name = _t0b("\093\057\054\025\078\078\037\117\054\033\054\089\074\005\078\103\080\005\023\037\024\024\024")
ztask1AllezaSculpture.Description = _t0b("\004\003\005\102\054\037\080\037\102\054\033\054\005\050\054\037\050\009\023\003\090\080\054\003\005\054\101\003\005\102\054\103\003\005\101\037\117\054\009\037\076\033\054\101\003\090\023\054\078\033\054\102\074\005\078\103\080\005\023\037\054\033\054\078\097\037\050\080\023\037\037\054\009\005\054\102\090\080\037\024\054\096\050\114\102\103\067\004\003\005\102\054\103\003\005\101\037\117\054\115\033\090\050\080\037\050\033\050\080\054\101\003\005\102\054\085\054\023\037\050\009\023\037\024")
ztask1AllezaSculpture.Visible = true
ztask1AllezaSculpture.Media = zmediaSculpture
ztask1AllezaSculpture.Active = true
ztask1AllezaSculpture.Complete = false
ztask1AllezaSculpture.CorrectState = "None"
ztask2AllezaEdifice1921 = Wherigo.ZTask(cartLaPulperie)
ztask2AllezaEdifice1921.Id = "36dc5fde-f169-4bd3-8e35-1e72894e4d2e"
ztask2AllezaEdifice1921.Name = _t0b("\044\057\054\025\078\078\037\117\054\033\054\046\009\090\018\090\074\037\054\093\068\044\093\024\024\024")
ztask2AllezaEdifice1921.Description = _t0b("\025\054\103\033\023\080\090\023\054\009\005\054\103\003\090\050\080\054\009\037\054\009\037\103\033\023\080\054\101\003\005\102\054\103\003\005\101\037\117\054\115\033\090\050\080\037\050\033\050\080\054\101\003\005\102\054\023\037\050\009\023\037\054\037\050\054\018\033\074\037\054\009\037\054\078\097\037\009\090\018\090\074\037\054\093\068\044\093\024")
ztask2AllezaEdifice1921.Visible = true
ztask2AllezaEdifice1921.Media = zmediaPulperie
ztask2AllezaEdifice1921.Active = true
ztask2AllezaEdifice1921.Complete = false
ztask2AllezaEdifice1921.CorrectState = "None"
ztask3AllezaEdifice1903 = Wherigo.ZTask(cartLaPulperie)
ztask3AllezaEdifice1903.Id = "b513ecac-9d2d-421e-8722-261305961a9f"
ztask3AllezaEdifice1903.Name = _t0b("\113\057\054\025\078\078\037\117\054\033\054\046\009\090\018\090\074\037\054\093\068\056\113\024\024\024")
ztask3AllezaEdifice1903.Description = _t0b("\122\037\054\078\097\046\009\090\018\090\074\037\054\093\068\044\093\038\054\101\003\005\102\054\101\003\005\102\054\023\037\050\009\037\117\054\033\054\078\097\046\009\090\018\090\074\037\054\093\068\056\113\054\037\050\054\080\023\033\101\037\023\102\033\050\080\054\078\033\054\023\090\101\090\037\023\037\024\054\096\050\114\102\103\067\040\090\023\074\005\078\037\117\054\009\033\050\102\054\078\097\037\009\090\018\090\074\037\054\102\033\050\102\054\080\003\090\080\005\023\037\054\037\080\054\037\115\103\023\005\050\080\037\117\054\078\037\102\054\037\102\074\033\074\078\090\037\023\102\054\033\005\054\018\003\050\009\054\009\037\054\078\033\054\114\033\080\090\102\102\037\054\033\054\101\003\080\023\037\054\036\033\005\074\053\037\024")
ztask3AllezaEdifice1903.Visible = true
ztask3AllezaEdifice1903.Media = zmediaEdifice1903
ztask3AllezaEdifice1903.Active = true
ztask3AllezaEdifice1903.Complete = false
ztask3AllezaEdifice1903.CorrectState = "None"
ztask4AllezalaFinale = Wherigo.ZTask(cartLaPulperie)
ztask4AllezalaFinale.Id = "29631ba2-5a76-4fd2-802d-634c90eb7870"
ztask4AllezalaFinale.Name = _t0b("\116\057\054\025\078\078\037\117\054\033\054\078\097\025\101\033\050\080\057\018\090\050\033\078\037\024\024\024")
ztask4AllezalaFinale.Description = _t0b("\122\037\054\023\037\080\003\005\023\054\009\005\054\061\090\037\005\054\046\009\090\018\090\074\037\054\093\068\056\113\024\054\096\050\114\102\103\067\004\003\005\102\054\037\080\037\102\054\102\005\023\054\078\037\054\103\003\090\050\080\054\009\097\033\080\080\037\090\050\009\023\037\054\078\033\054\117\003\050\037\054\025\101\033\050\080\057\018\090\050\033\078\037\024")
ztask4AllezalaFinale.Visible = true
ztask4AllezalaFinale.Media = zmediaSitedeLaPulperie
ztask4AllezalaFinale.Active = true
ztask4AllezalaFinale.Complete = false
ztask4AllezalaFinale.CorrectState = "None"
ztask5Questionfinale = Wherigo.ZTask(cartLaPulperie)
ztask5Questionfinale.Id = "72122d34-5874-40c7-9985-7cd754ecf87f"
ztask5Questionfinale.Name = _t0b("\112\057\054\020\005\037\102\080\090\003\050\054\025\101\033\050\080\057\018\090\050\033\078\037")
ztask5Questionfinale.Description = _t0b("\020\005\037\102\080\090\003\050\054\033\054\023\037\103\003\050\009\023\037\054\033\005\054\078\090\037\005\054\025\101\033\050\080\057\018\090\050\033\078\024")
ztask5Questionfinale.Visible = false
ztask5Questionfinale.Media = zmediaQuestion
ztask5Questionfinale.Active = true
ztask5Questionfinale.Complete = false
ztask5Questionfinale.CorrectState = "None"
_PDxyO = Wherigo.ZTask(cartLaPulperie)
_PDxyO.Id = "42185c9a-3f64-4e16-8b40-90a47f7cf2a4"
_PDxyO.Name = _t0b("\026\057\054\025\078\078\037\023\054\033\054\078\033\054\018\090\050\033\078\037")
_PDxyO.Description = _t0b("\001\033\074\053\037\054\103\003\005\023\054\102\037\054\023\037\050\009\023\037\054\033\054\078\033\054\018\090\050\033\078\037\024")
_PDxyO.Visible = true
_PDxyO.Media = _wP1qt
_PDxyO.Active = true
_PDxyO.Complete = false
_PDxyO.CorrectState = "None"

-- Cartridge Variables --
Compteurdetaches = 0
Reponsedelafinale = _t0b("\025\071\043\041\061")
_Ni_ = _t0b("\117\003\050\037\089\074\005\078\103\080\005\023\037")
_yA27 = _t0b("\117\074\053\033\023\033\074\080\037\023\082\005\078\090\037\050\046\009\003\005\033\023\009\025\078\018\023\037\009\122\005\114\005\074")
_FRdFo = _t0b("\117\090\080\037\115\041\050\080\037\023\023\003\036\033\080\090\003\050")
_8l6_Z = _t0b("\117\080\033\102\123\093\025\078\078\037\117\033\089\074\005\078\103\080\005\023\037")
_P74CC = _t0b("\025\005\080\003\115\033\080\090\074")
_7LaxJ = _t0b("\009\005\115\115\085")
cartLaPulperie.ZVariables = {
	Compteurdetaches = 0, 
	Reponsedelafinale = _t0b("\025\071\043\041\061"), 
	_Ni_ = _t0b("\117\003\050\037\089\074\005\078\103\080\005\023\037"), 
	_yA27 = _t0b("\117\074\053\033\023\033\074\080\037\023\082\005\078\090\037\050\046\009\003\005\033\023\009\025\078\018\023\037\009\122\005\114\005\074"), 
	_FRdFo = _t0b("\117\090\080\037\115\041\050\080\037\023\023\003\036\033\080\090\003\050"), 
	_8l6_Z = _t0b("\117\080\033\102\123\093\025\078\078\037\117\033\089\074\005\078\103\080\005\023\037"), 
	_P74CC = _t0b("\025\005\080\003\115\033\080\090\074"), 
	_7LaxJ = _t0b("\009\005\115\115\085")
}

-- Timers --

-- Inputs --
Automatic = Wherigo.ZInput(cartLaPulperie)
Automatic.Id = "0fce2716-e657-470e-b9d0-b898003bbfc5"
Automatic.Name = _t0b("\020\005\037\102\080\090\003\050\054\009\037\054\078\097\025\101\033\050\080\057\018\090\050\033\078\037")
Automatic.Description = _t0b("\032\050\037\054\119\005\037\102\080\090\003\050\054\102\090\115\103\078\037\038\054\102\033\050\102\054\074\053\003\090\014\054\009\037\054\023\037\103\003\050\102\037\024")
Automatic.Visible = true
Automatic.Media = zmediaQuestion
Automatic.InputType = "Text"
Automatic.Text = _t0b("\020\005\037\078\078\037\054\037\050\080\023\037\103\023\090\102\037\054\033\054\018\033\114\023\090\119\005\037\054\074\037\080\080\037\054\037\050\102\037\090\036\050\037\054\048\005\050\054\050\003\115\054\009\037\054\018\033\115\090\078\078\037\002\098")

-- WorksWithList for object commands --

-- functions --
function cartLaPulperie:OnStart()
	_Urwigo.MessageBox{
		Text = _t0b("\126\090\037\050\101\037\050\005\037\054\102\005\023\054\078\037\054\102\090\080\037\054\009\037\054\078\033\054\071\005\078\103\037\023\090\037\024\054\096\050\114\102\103\067\063\003\050\054\050\003\115\054\037\102\080\054\082\003\102\037\103\053\057\122\003\115\090\050\090\119\005\037\054\028\005\033\085\038\054\115\033\090\023\037\054\009\037\054\040\053\090\074\003\005\080\090\115\090\054\033\054\078\097\037\103\003\119\005\037\024\054\096\050\114\102\103\067\122\033\050\102\054\074\037\102\054\033\050\050\037\037\102\038\054\078\033\054\023\037\036\090\003\050\054\037\080\033\090\080\054\037\050\074\003\023\037\054\037\050\054\103\078\037\090\050\054\009\037\101\037\078\003\103\103\037\115\037\050\080\054\037\080\054\009\037\054\036\023\033\050\009\102\054\103\023\003\076\037\080\102\054\037\080\033\090\037\050\080\054\050\037\074\037\102\102\033\090\023\037\102\054\033\054\078\097\037\014\103\037\050\102\090\003\050\054\009\037\054\050\003\080\023\037\054\101\090\078\078\037\024\054\072\003\005\102\054\009\037\101\090\003\050\102\054\033\080\080\090\023\037\023\054\009\037\102\054\090\050\101\037\102\080\090\102\102\037\005\023\102\054\037\080\054\078\037\054\102\090\080\037\054\037\080\033\090\080\054\090\009\037\033\078\054\103\003\005\023\054\005\050\054\103\023\003\076\037\080\054\080\037\078\054\005\050\037\054\103\005\078\103\037\023\090\037\054\033\054\074\033\005\102\037\054\009\005\054\103\003\080\037\050\080\090\037\078\054\053\085\009\023\033\005\078\090\119\005\037\024\035\126\043\070\082\037\054\101\003\005\102\054\090\050\101\090\080\037\054\033\054\101\003\005\102\054\023\037\050\009\023\037\054\033\005\054\061\090\037\005\054\009\037\054\009\037\103\033\023\080\054\037\050\054\103\023\037\102\102\033\050\080\054\078\037\054\114\003\005\080\003\050\054\065\089\074\005\078\103\080\005\023\037\065\054\074\090\057\009\037\102\102\003\005\102\024"), 
		Media = zmediaJDGuay, 
		Buttons = {
			_t0b("\089\074\005\078\103\080\005\023\037")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneSculpture)
			end
		end
	}
	zoneSculpture.Active = true
	zoneSculpture.Visible = true
	zoneEdifice1921.Visible = true
	zoneEdifice1903.Visible = true
	zcharacterJosephDominiqueGuay:MoveTo(zoneSculpture)
	zcharacterJulienEdouardAlfredDubuc:MoveTo(zoneEdifice1921)
	zcharacterEmployes:MoveTo(zoneEdifice1903)
end
function cartLaPulperie:OnRestore()
end
function zoneSculpture:OnEnter()
	_Ni_ = _t0b("\117\003\050\037\089\074\005\078\103\080\005\023\037")
	zcharacterJulienEdouardAlfredDubuc.Visible = true
	zcharacterJulienEdouardAlfredDubuc.Visible = true
	_Urwigo.MessageBox{
		Text = _t0b("\126\090\037\050\101\037\050\005\037\054\033\005\054\102\090\080\037\054\009\037\054\061\033\054\071\005\078\103\037\023\090\037\054\009\037\054\040\053\090\074\003\005\080\090\115\090\024\054\096\050\114\102\103\067\082\037\054\115\097\033\103\103\037\078\078\037\054\082\003\102\037\103\053\057\046\080\090\037\050\050\037\057\025\078\018\023\037\009\054\122\005\114\005\074\024\054\096\050\114\102\103\067\025\054\078\097\037\103\003\119\005\037\038\054\076\097\037\080\033\090\102\054\005\050\054\076\037\005\050\037\054\114\033\050\119\005\090\037\023\054\037\080\054\076\037\054\115\037\054\102\005\090\102\054\033\102\102\003\074\090\037\054\033\005\054\115\033\090\023\037\054\009\037\054\040\053\090\074\003\005\080\090\115\090\054\103\003\005\023\054\018\033\090\023\037\054\009\037\054\074\037\054\102\090\080\037\054\005\050\054\103\023\003\076\037\080\054\103\023\003\102\103\037\023\037\024\054\096\050\114\102\103\067\025\005\054\074\003\005\023\102\054\009\037\102\054\033\050\050\037\037\102\038\054\050\003\005\102\054\033\101\003\050\102\054\009\037\101\037\078\003\103\103\037\054\078\037\054\102\090\080\037\054\037\080\054\102\005\115\037\102\054\037\050\054\018\033\090\023\037\054\103\023\003\018\090\080\037\023\054\078\037\102\054\053\033\114\090\080\033\050\080\102\054\009\037\054\078\033\054\101\090\078\078\037\024\054\071\078\005\102\090\037\005\023\102\054\037\101\037\050\037\115\037\050\080\102\054\023\037\078\033\080\090\003\050\050\037\078\102\054\102\003\050\080\054\102\005\023\101\037\050\005\102\024\054\096\050\114\102\103\067\072\003\005\102\054\037\050\054\023\037\103\033\023\078\037\023\003\050\102\024\054\096\050\114\102\103\067\004\003\005\102\054\103\003\005\101\037\117\054\033\101\033\050\074\037\023\054\101\037\023\102\054\078\097\037\009\090\018\090\074\037\054\037\050\054\018\033\074\037\054\009\037\054\101\003\005\102\024"), 
		Media = zmediaJEADubuc, 
		Buttons = {
			_t0b("\046\009\090\018\090\074\037\054\093\068\044\093")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneEdifice1921)
			end
		end
	}
	zoneEdifice1921.Visible = true
	zoneEdifice1921.Active = true
end
function zoneSculpture:OnExit()
	_Ni_ = _t0b("\117\003\050\037\089\074\005\078\103\080\005\023\037")
	_Urwigo.MessageBox{
		Text = _t0b("\004\003\005\102\054\033\103\037\023\074\037\101\037\117\054\078\097\046\009\090\018\090\074\037\054\093\068\044\093\054\009\005\054\102\090\080\037\054\009\037\054\061\033\054\071\005\078\103\037\023\090\037\054\037\050\054\018\033\074\037\054\009\037\054\101\003\005\102\024\054\096\050\114\102\103\067\040\037\054\114\033\080\090\115\037\050\080\054\037\080\033\090\080\054\078\097\033\080\037\078\090\037\023\054\009\037\054\115\037\074\033\050\090\119\005\037\054\074\003\050\102\080\023\005\090\080\054\103\003\005\023\054\078\037\102\054\114\037\102\003\090\050\102\054\009\037\054\078\097\037\103\003\119\005\037\024\054\096\050\114\102\103\067\040\003\050\080\090\050\005\037\117\054\009\097\033\101\033\050\074\037\023\024\024\024\054\061\003\023\102\119\005\037\054\101\003\005\102\054\037\050\080\023\037\023\037\117\054\009\033\050\102\054\074\037\080\080\037\054\079\003\050\037\038\054\102\005\090\101\023\037\054\078\037\102\054\090\050\009\090\074\033\080\090\003\050\102\024"), 
		Media = zmediaPulperie
	}
	ztask1AllezaSculpture.Visible = false
	ztask1AllezaSculpture.Complete = true
	cartLaPulperie:RequestSync()
end
function zoneEdifice1921:OnEnter()
	_Ni_ = _t0b("\117\003\050\037\046\009\090\018\090\074\037\093\068\044\093")
	_Urwigo.MessageBox{
		Text = _t0b("\040\037\054\114\033\080\090\115\037\050\080\054\033\114\023\090\080\037\054\115\033\090\050\080\037\050\033\050\080\054\078\033\054\074\037\078\037\114\023\037\054\115\033\090\102\003\050\054\025\023\080\053\005\023\057\004\090\078\078\037\050\037\005\101\037\054\119\005\090\054\018\005\080\054\009\037\115\037\050\033\036\037\037\054\009\037\054\102\003\050\054\102\090\080\037\054\103\023\037\102\054\009\037\054\093\054\123\115\054\009\097\090\074\090\054\037\080\054\037\050\080\023\037\037\054\103\033\023\054\078\097\033\023\023\090\037\023\037\024\054\096\050\114\102\103\067\073\050\054\085\054\080\023\003\005\101\037\054\037\036\033\078\037\115\037\050\080\054\005\050\054\115\005\102\037\037\054\103\037\023\115\033\050\037\050\080\054\037\080\054\005\050\054\115\005\102\037\037\054\080\053\037\115\033\080\090\119\005\037\024\054\089\090\054\005\050\037\054\101\090\102\090\080\037\054\101\003\005\102\054\090\050\080\037\023\037\102\102\037\038\054\018\037\023\115\037\117\054\037\080\054\102\033\005\101\037\036\033\023\009\037\117\054\078\033\054\074\033\023\080\003\005\074\053\037\054\103\003\005\023\054\103\078\005\102\054\080\033\023\009\024\035\126\043\070\071\003\005\023\054\074\003\050\080\090\050\005\037\023\038\054\074\053\003\090\102\090\102\102\037\117\054\078\037\054\061\090\037\005\054\046\009\090\018\090\074\037\054\093\068\056\113\054\037\080\054\102\005\090\101\037\117\054\078\033\054\009\090\023\037\074\080\090\003\050\054\009\037\054\101\003\080\023\037\054\023\037\074\037\103\080\037\005\023\054\028\071\089\024"), 
		Media = zmediaPulperie, 
		Buttons = {
			_t0b("\046\009\090\018\090\074\037\054\093\068\056\113")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneEdifice1903)
			end
		end
	}
	zoneEdifice1903.Visible = true
	zoneEdifice1903.Active = true
end
function zoneEdifice1921:OnExit()
	_Ni_ = _t0b("\117\003\050\037\046\009\090\018\090\074\037\093\068\044\093")
	zoneEdifice1903.Active = true
	zoneEdifice1903.Visible = true
	ztask2AllezaEdifice1921.Complete = true
	_Urwigo.OldDialog{
		{
			Text = _t0b("\046\050\054\102\003\023\080\033\050\080\054\009\037\054\078\033\054\117\003\050\037\054\009\037\054\078\097\046\009\090\018\090\074\037\054\093\068\044\093\038\054\101\003\005\102\054\037\080\037\102\054\090\050\101\090\080\037\054\033\054\101\090\102\090\080\037\023\054\078\037\054\115\005\102\037\037\054\003\005\054\101\003\005\102\054\023\037\050\009\023\037\054\033\005\054\103\023\003\074\053\033\090\050\054\061\090\037\005\038\054\074\037\078\005\090\054\009\037\054\078\097\046\009\090\018\090\074\037\054\093\068\056\113\024"), 
			Media = zmediaEdifice1903
		}, 
		{
			Text = _t0b("\046\050\054\101\003\005\102\054\023\037\050\009\033\050\080\054\101\037\023\102\054\078\037\054\103\023\003\074\053\033\090\050\054\061\090\037\005\054\048\046\009\090\018\090\074\037\054\093\068\056\113\002\038\054\101\003\005\102\054\009\037\101\023\037\117\054\078\003\050\036\037\023\054\078\033\054\023\090\101\090\037\023\037\024\054\046\050\054\102\033\090\102\003\050\038\054\101\003\005\102\054\103\003\005\101\037\117\054\037\050\054\103\023\003\018\090\080\037\023\054\103\003\005\023\054\080\023\033\101\037\023\102\037\023\054\078\037\054\103\003\050\080\054\037\080\054\101\090\102\090\080\037\023\054\078\037\054\082\033\023\009\090\050\054\009\037\102\054\101\037\102\080\090\036\037\102\054\037\080\054\078\037\054\040\090\050\037\057\071\005\078\103\037\024\054\096\050\114\102\103\067\071\023\037\050\037\117\054\037\050\102\005\090\080\037\054\078\033\054\102\003\023\080\090\037\054\101\037\023\102\054\078\037\102\054\037\102\074\033\078\090\037\023\102\054\119\005\090\054\115\037\050\037\050\080\054\033\005\014\054\102\003\115\115\037\080\102\054\074\005\078\115\090\050\033\050\080\054\078\037\054\102\090\080\037\054\009\037\054\061\033\054\071\005\078\103\037\023\090\037\024")
		}, 
		{
			Text = _t0b("\040\037\074\090\054\023\033\103\103\037\078\078\037\054\119\005\037\054\074\037\054\102\090\080\037\054\018\005\080\054\078\037\054\080\053\037\033\080\023\037\054\009\097\005\050\037\054\036\023\037\101\037\054\090\115\103\003\023\080\033\050\080\037\024\054\096\050\114\102\103\067\046\050\054\037\018\018\037\080\038\054\003\050\054\023\033\074\003\050\080\037\054\119\005\037\054\078\037\102\054\103\023\003\103\023\090\037\080\033\090\023\037\102\054\103\033\085\033\090\037\050\080\054\078\037\005\023\102\054\037\115\103\078\003\085\037\102\054\033\101\037\074\054\009\037\102\054\076\037\080\003\050\102\054\037\074\053\033\050\036\037\033\114\078\037\102\054\009\033\050\102\054\078\037\102\054\074\003\115\115\037\023\074\037\102\054\033\103\103\033\023\080\037\050\033\050\080\054\033\054\074\037\102\054\115\037\115\037\102\054\103\023\003\103\023\090\037\080\033\090\023\037\102\024\054\096\050\114\102\103\067\040\037\080\080\037\054\036\023\037\101\037\054\009\037\115\033\050\009\033\090\080\054\033\005\014\054\103\023\003\103\023\090\003\102\054\009\037\054\103\033\085\037\023\054\078\037\102\054\037\115\103\078\003\085\037\102\054\037\050\054\033\023\036\037\050\080\054\119\005\090\054\033\054\074\003\005\023\102\054\078\037\036\033\078\054\103\033\023\080\003\005\080\024"), 
			Media = zmediaStaff
		}
	}
	zcharacterEmployes.Visible = true
	ztask2AllezaEdifice1921.Visible = false
	cartLaPulperie:RequestSync()
end
function zoneEdifice1903:OnEnter()
	_Ni_ = _t0b("\117\003\050\037\046\009\090\018\090\074\037\093\068\056\113")
	zoneSculpture.Active = false
	zoneSculpture.Visible = false
	_Urwigo.MessageBox{
		Text = _t0b("\004\003\005\102\054\037\080\037\102\054\103\023\037\102\054\009\005\054\103\003\090\050\080\054\119\005\090\054\074\005\078\115\090\050\037\054\078\037\054\102\090\080\037\024\054\096\050\114\102\103\067\041\115\033\036\090\050\037\117\054\074\037\054\119\005\037\054\078\037\054\102\090\080\037\054\033\054\009\037\076\033\054\103\005\054\023\037\102\102\037\115\114\078\037\023\054\033\054\005\050\037\054\074\037\023\080\033\090\050\037\054\037\103\003\119\005\037\024\054\096\050\114\102\103\067\043\033\103\103\037\078\037\117\057\101\003\005\102\054\119\005\037\054\074\097\037\080\033\090\080\054\090\078\054\085\054\033\054\103\078\005\102\054\009\037\054\093\056\056\054\033\050\102\024\054\096\050\114\102\103\067\061\033\054\103\023\003\074\053\033\090\050\037\054\037\080\033\103\037\054\101\003\005\102\054\033\115\037\050\037\023\033\054\033\054\078\033\054\117\003\050\037\054\025\101\033\050\080\057\018\090\050\033\078\037\054\003\005\054\101\003\005\102\054\009\037\101\023\037\117\054\023\037\103\003\050\009\023\037\054\033\054\005\050\037\054\119\005\037\102\080\090\003\050\024\054\046\050\054\102\003\023\080\033\050\080\054\009\097\090\074\090\038\054\102\005\090\101\037\117\054\078\037\102\054\090\050\009\090\074\033\080\090\003\050\102\054\037\080\054\078\033\054\009\090\023\037\074\080\090\003\050\054\119\005\037\054\101\003\005\102\054\009\003\050\050\037\054\115\003\050\102\090\037\005\023\054\122\005\114\005\074\024"), 
		Media = zmediaEdifice1903, 
		Buttons = {
			_t0b("\079\003\050\037\054\025\101\033\050\080\057\018\090\050\033\078\037")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneFinale)
			end
		end
	}
	zoneFinale.Active = true
	zoneFinale.Visible = true
end
function zoneEdifice1903:OnExit()
	_Ni_ = _t0b("\117\003\050\037\046\009\090\018\090\074\037\093\068\056\113")
	zoneEdifice1921.Active = false
	zoneEdifice1921.Visible = false
	_Urwigo.OldDialog{
		{
			Text = _t0b("\004\003\005\102\054\037\080\037\102\054\115\033\090\050\080\037\050\033\050\080\054\102\003\023\080\090\054\009\005\054\080\023\003\090\102\090\037\115\037\054\061\090\037\005\054\009\037\054\074\037\080\080\037\054\074\033\023\080\003\005\074\053\037\024\054\096\050\114\102\103\067\004\037\005\090\078\078\037\117\054\101\003\005\102\054\023\037\050\009\023\037\054\101\037\023\102\054\078\033\054\018\090\050\033\078\037\054\037\050\054\103\033\102\102\033\050\080\054\103\033\023\054\078\097\033\023\023\090\037\023\037\054\009\037\054\078\097\046\009\090\018\090\074\037\054\093\068\044\093\024"), 
			Media = zmediaJEADubuc
		}, 
		{
			Text = _t0b("\061\003\023\102\119\005\037\054\101\003\005\102\054\102\037\023\037\117\054\033\054\078\097\033\023\023\090\037\023\037\054\009\005\054\078\097\046\009\090\018\090\074\037\054\093\068\044\093\038\054\023\037\115\033\023\119\005\037\117\054\078\033\054\074\003\005\078\037\005\023\054\009\005\054\115\003\023\080\090\037\023\054\009\037\102\054\103\090\037\023\023\037\102\024\054\096\050\114\102\103\067\061\033\054\009\037\115\033\023\119\005\033\080\090\003\050\054\009\005\054\115\003\023\080\090\037\023\054\103\078\005\102\054\103\033\078\037\054\090\050\009\090\119\005\037\054\078\097\037\050\009\023\003\090\080\054\003\005\054\037\102\080\054\037\050\080\023\037\037\054\078\033\054\115\033\090\102\003\050\054\025\023\080\053\005\023\057\004\090\078\078\037\050\037\005\101\037\024\054\096\050\114\102\103\067\004\003\005\102\054\103\003\005\101\037\117\054\074\003\050\080\090\050\005\037\023\024\024\024\054\037\080\054\074\053\003\090\102\090\023\054\025\101\033\050\080\017\018\090\050\033\078\037\054\009\033\050\102\054\078\037\054\115\037\050\005\054\061\090\037\005\014\054\009\037\054\101\003\080\023\037\054\023\037\074\037\103\080\037\005\023\054\028\071\089\024"), 
			Media = zmediaJEADubuc
		}
	}
	zcharacterJulienEdouardAlfredDubuc.Visible = true
	ztask3AllezaEdifice1903.Complete = true
	ztask3AllezaEdifice1903.Visible = false
	cartLaPulperie:RequestSync()
end
function zoneFinale:OnEnter()
	_Ni_ = _t0b("\117\003\050\037\107\090\050\033\078\037")
	zoneFinale.Active = true
	zoneFinale.Visible = true
	zcharacterJulienEdouardAlfredDubuc.Visible = true
	ztask4AllezalaFinale.Visible = false
	ztask5Questionfinale.Visible = true
	ztask5Questionfinale.Active = true
	_Urwigo.MessageBox{
		Text = _t0b("\004\003\005\102\054\037\050\080\023\037\117\054\009\033\050\102\054\078\037\054\102\037\074\080\037\005\023\054\003\005\054\101\003\005\102\054\080\023\003\005\101\037\023\037\117\054\078\033\054\023\037\103\003\050\102\037\054\033\054\005\050\037\054\119\005\037\102\080\090\003\050\024\035\126\043\070\040\037\080\080\037\054\023\037\103\003\050\102\037\054\102\037\054\080\023\003\005\101\037\054\102\005\023\054\078\097\037\050\102\037\090\036\050\037\054\033\054\009\023\003\090\080\037\054\009\037\054\078\097\037\102\074\033\078\090\037\023\024\035\126\043\070\071\023\037\102\102\037\117\054\078\037\054\114\003\005\080\003\050\054\065\043\037\103\003\050\009\023\037\065\054\103\003\005\023\054\037\050\080\023\037\023\054\101\003\080\023\037\054\023\037\103\003\050\102\037\024"), 
		Media = zmediaExclamation, 
		Buttons = {
			_t0b("\043\037\103\003\050\009\023\037")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(Automatic)
				end)
			end
		end
	}
end
function zoneFinale:OnExit()
	_Ni_ = _t0b("\117\003\050\037\107\090\050\033\078\037")
	_Urwigo.MessageBox{
		Text = _t0b("\066\037\102\102\102\006\054\004\003\005\102\054\033\101\037\117\054\103\023\037\102\119\005\037\054\080\037\023\115\090\050\037\054\080\003\005\080\037\102\054\078\037\102\054\080\033\074\053\037\102\024\054\096\050\114\102\103\067\082\097\037\102\103\037\023\037\054\119\005\037\054\101\003\005\102\054\033\090\115\037\117\054\101\003\080\023\037\054\037\014\103\037\023\090\037\050\074\037\054\060\053\037\023\090\036\003\006"), 
		Media = zmediaYes, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _MPFoS)
			end
		end
	}
	ztask4AllezalaFinale.Complete = true
	ztask4AllezalaFinale.Visible = false
	ztask5Questionfinale.Visible = false
	ztask5Questionfinale.Complete = true
	_PDxyO.Active = true
	_PDxyO.Visible = true
	zoneEdifice1903.Active = false
	zoneEdifice1903.Visible = false
	zoneFinale.Active = true
	zoneFinale.Visible = true
	zcharacterJosephDominiqueGuay:MoveTo(_MPFoS)
	zcharacterJulienEdouardAlfredDubuc:MoveTo(_MPFoS)
	_MPFoS.Active = true
	_MPFoS.Visible = true
	cartLaPulperie:RequestSync()
end
function _MPFoS:OnEnter()
	_Ni_ = _t0b("\017\063\071\107\003\089")
	_MPFoS.Visible = true
	zcharacterJulienEdouardAlfredDubuc.Visible = true
	_PDxyO.Visible = true
	_Urwigo.OldDialog{
		{
			Text = _t0b("\004\003\005\102\054\037\050\080\023\037\117\054\009\033\050\102\054\078\033\054\117\003\050\037\054\003\005\054\101\003\005\102\054\103\003\005\023\023\037\117\054\037\050\018\090\050\054\102\090\036\050\037\023\054\078\037\054\074\033\023\050\037\080\054\009\037\054\101\090\102\090\080\037\024\054\041\078\054\102\037\054\080\023\003\005\101\037\054\102\003\005\102\054\078\037\054\103\078\033\050\074\053\037\023\054\078\033\054\003\005\054\037\102\080\054\090\050\009\090\119\005\037\054\078\037\054\050\005\115\037\023\003\054\065\093\056\026\065\054\033\054\009\023\003\090\080\037\054\009\037\054\078\033\054\078\003\074\003\115\003\080\090\101\037\054\048\074\003\115\115\037\054\102\090\054\101\003\005\102\054\037\080\090\037\117\054\078\037\054\074\053\037\115\090\050\003\080\002\024\054\040\097\037\102\080\054\005\050\054\074\003\050\080\037\050\033\050\080\054\115\033\036\050\037\080\090\119\005\037\024\054\020\005\033\050\009\054\101\003\005\102\054\033\005\023\037\117\054\102\090\036\050\037\054\078\037\054\074\033\023\050\037\080\038\054\102\003\023\080\037\117\054\009\037\054\078\033\054\117\003\050\037\054\033\101\037\074\054\101\003\080\023\037\054\028\071\089\054\037\050\074\003\023\037\054\033\074\080\090\018\024"), 
			Media = zmediaJDGuay
		}, 
		{
			Text = _t0b("\089\090\054\101\003\005\102\054\037\080\037\102\054\009\037\054\103\033\102\102\033\036\037\054\033\054\040\053\090\074\003\005\080\090\115\090\038\054\103\023\003\018\090\080\037\117\057\037\050\054\103\003\005\023\054\018\033\090\023\037\054\005\050\054\080\003\005\023\054\009\037\054\101\090\078\078\037\054\033\101\037\074\054\005\050\037\054\044\037\054\060\053\037\023\090\036\003\054\009\003\050\080\054\078\037\054\050\003\115\054\037\102\080\030\054\096\050\114\102\103\067\065\061\037\054\071\037\080\090\080\054\071\023\090\050\074\037\065\024\054\096\050\114\102\103\067\061\037\054\080\003\005\023\054\103\023\037\050\009\054\044\054\053\037\005\023\037\102\054\033\054\103\090\037\009\102\038\054\093\054\053\037\005\023\037\054\033\054\101\037\078\003\054\037\080\054\113\056\054\115\090\050\005\080\037\102\054\037\050\054\101\003\090\080\005\023\037\024\054\061\037\054\023\037\078\090\037\018\054\037\102\080\054\090\115\103\003\023\080\033\050\080\024"), 
			Media = zmediaJDGuay
		}
	}
end
function _MPFoS:OnExit()
	_Ni_ = _t0b("\017\063\071\107\003\089")
	_PDxyO.Complete = true
	cartLaPulperie.Complete = true
	_Urwigo.MessageBox{
		Text = _t0b("\107\037\078\090\074\090\080\033\080\090\003\050\102\006\054\096\050\114\102\103\067\004\003\005\102\054\033\101\037\117\054\103\033\023\074\003\005\023\005\054\080\003\005\102\054\078\037\102\054\078\090\037\005\014\054\009\005\054\102\090\080\037\024\054\096\050\114\102\103\067\004\003\080\023\037\054\074\033\023\080\003\005\074\053\037\054\060\053\037\023\090\036\003\054\103\003\102\102\037\009\037\054\115\033\090\050\080\037\050\033\050\080\054\078\037\054\102\080\033\080\005\080\054\065\040\003\115\103\078\037\080\037\009\065\054\101\003\005\102\054\103\037\023\115\037\080\080\033\050\080\054\009\037\054\018\033\090\023\037\054\101\003\080\023\037\054\065\032\050\078\003\074\123\065\054\033\005\054\102\090\080\037\054\078\003\023\102\119\005\037\054\101\003\005\102\054\090\050\102\074\023\090\023\037\117\054\101\003\080\023\037\054\115\037\115\003\024\054\046\050\054\103\023\037\102\102\033\050\080\054\102\005\023\054\073\032\041\038\054\078\033\054\074\033\023\080\003\005\074\053\037\054\101\033\054\102\037\054\102\033\005\101\037\036\033\023\009\037\023\054\037\080\054\018\037\023\115\037\023\024"), 
		Media = zmediaJEADubuc
	}
	Wherigo.Command "SaveClose"
end
function ztask1AllezaSculpture:OnSetComplete()
	Compteurdetaches = Compteurdetaches + 1
	if Compteurdetaches == 6 then
		cartLaPulperie.Complete = true
	end
end
function ztask2AllezaEdifice1921:OnSetComplete()
	Compteurdetaches = Compteurdetaches + 1
	if Compteurdetaches == 6 then
		cartLaPulperie.Complete = true
	end
end
function ztask3AllezaEdifice1903:OnSetComplete()
	Compteurdetaches = Compteurdetaches + 1
	if Compteurdetaches == 6 then
		cartLaPulperie.Complete = true
	end
end
function ztask4AllezalaFinale:OnSetComplete()
	Compteurdetaches = Compteurdetaches + 1
	if Compteurdetaches == 6 then
		cartLaPulperie.Complete = true
	end
end
function ztask5Questionfinale:OnSetComplete()
	Compteurdetaches = Compteurdetaches + 1
	if Compteurdetaches == 6 then
	end
end
function ztask5Questionfinale:OnClick()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(Automatic)
	end)
end
function _PDxyO:OnSetComplete()
	Compteurdetaches = Compteurdetaches + 1
	if Compteurdetaches == 6 then
		cartLaPulperie.Complete = true
	end
end
function Automatic:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Reponsedelafinale = input
	if Wherigo.NoCaseEquals(Reponsedelafinale, _t0b("\025\071\043\041\061")) then
		_Urwigo.Dialog(false, {
			{
				Text = _t0b("\089\005\103\037\023\006\054\082\037\054\101\003\005\102\054\101\037\005\014\054\074\003\115\115\037\054\033\102\102\003\074\090\037\006\035\126\043\070\073\050\054\103\037\005\080\054\115\033\090\050\080\037\050\033\050\080\054\102\037\054\009\090\023\090\036\037\023\054\101\037\023\102\054\078\033\054\018\090\050\033\078\037\054\103\003\005\023\054\102\090\036\050\037\023\054\078\037\054\074\033\023\050\037\080\054\009\037\054\101\090\102\090\080\037\102\024"), 
				Media = zmediaJEADubuc
			}, 
			{
				Text = _t0b("\122\037\102\074\037\050\009\003\050\102\054\037\050\102\037\115\114\078\037\054\078\037\102\054\037\102\074\033\078\090\037\023\102\054\037\080\054\102\005\023\101\037\090\078\078\037\117\054\078\033\054\023\037\033\074\080\090\003\050\054\009\037\054\101\003\080\023\037\054\028\071\089\024"), 
				Media = zmediaJEADubuc
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _MPFoS)
		end)
	else
		_Urwigo.MessageBox{
			Text = _t0b("\008\005\115\006\054\043\037\103\003\050\102\037\054\090\050\074\003\023\023\037\074\080\037\024\054\046\102\102\033\085\037\117\054\009\037\054\050\003\005\101\037\033\005\024\024\024"), 
			Media = zmediaExclamation, 
			Buttons = {
				_t0b("\043\037\103\003\050\009\023\037"), 
				_t0b("\001\033\050\080\054\103\090\102\006")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(Automatic)
						end)
					end
				end
			end
		}
	end
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return cartLaPulperie
