require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _DvUW(str)
	local res = ""
    local dtable = "\110\088\000\017\061\003\093\037\033\022\092\048\006\001\099\072\094\083\075\012\124\015\119\074\058\005\045\087\056\079\111\082\032\059\121\052\016\042\107\054\029\122\041\050\038\013\116\030\020\014\115\118\112\023\008\068\021\101\004\043\089\113\057\097\103\040\071\073\108\117\125\024\114\126\066\055\106\046\007\109\019\051\064\053\070\018\076\062\036\086\027\091\039\025\100\034\078\123\090\096\060\102\010\080\085\098\002\069\084\031\081\120\067\104\011\063\047\105\065\028\095\009\035\044\026\049\077"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

cartCoimbra = Wherigo.ZCartridge()

-- Media --
zmediaTribunal = Wherigo.ZMedia(cartCoimbra)
zmediaTribunal.Id = "f302beb3-f193-438d-9157-6da968e5ebe8"
zmediaTribunal.Name = "Tribunal"
zmediaTribunal.Description = "Tribunal"
zmediaTribunal.AltText = "Tribunal / Court"
zmediaTribunal.Resources = {
	{
		Type = "jpg", 
		Filename = "001Tribunal.jpg", 
		Directives = {}
	}
}
zmediaIgrejadeNossaSenhoradoCarmo = Wherigo.ZMedia(cartCoimbra)
zmediaIgrejadeNossaSenhoradoCarmo.Id = "5ee93c5b-7190-4bef-a49e-2901a2d6d387"
zmediaIgrejadeNossaSenhoradoCarmo.Name = "Igreja de Nossa Senhora do Carmo"
zmediaIgrejadeNossaSenhoradoCarmo.Description = "02 Igreja de Nossa Senhora do Carmo"
zmediaIgrejadeNossaSenhoradoCarmo.AltText = ""
zmediaIgrejadeNossaSenhoradoCarmo.Resources = {
	{
		Type = "jpg", 
		Filename = "002PB250062-800.jpg", 
		Directives = {}
	}
}
zmediaPtiodaInquisio = Wherigo.ZMedia(cartCoimbra)
zmediaPtiodaInquisio.Id = "e723e844-f519-444a-b3b2-6a278fc695ac"
zmediaPtiodaInquisio.Name = "Patio da Inquisicao"
zmediaPtiodaInquisio.Description = "03 Patio da Inquisicao"
zmediaPtiodaInquisio.AltText = ""
zmediaPtiodaInquisio.Resources = {
	{
		Type = "jpg", 
		Filename = "003PatiodaInquisicao.jpg", 
		Directives = {}
	}
}
zmediaCamaraMunicipaldeCoimbra = Wherigo.ZMedia(cartCoimbra)
zmediaCamaraMunicipaldeCoimbra.Id = "7061ef4a-7e44-4404-a8db-1981f5b0ddab"
zmediaCamaraMunicipaldeCoimbra.Name = "Camara Municipal de Coimbra"
zmediaCamaraMunicipaldeCoimbra.Description = "04 Camara Municipal de Coimbra"
zmediaCamaraMunicipaldeCoimbra.AltText = ""
zmediaCamaraMunicipaldeCoimbra.Resources = {
	{
		Type = "jpg", 
		Filename = "004CamaraMunicipaldeCoimbra.jpg", 
		Directives = {}
	}
}
zmediaIgrejadeSantaCruz = Wherigo.ZMedia(cartCoimbra)
zmediaIgrejadeSantaCruz.Id = "348d4c51-35e9-4e71-909c-eb4099cf643f"
zmediaIgrejadeSantaCruz.Name = "Igreja de Santa Cruz"
zmediaIgrejadeSantaCruz.Description = "05 Igreja de Santa Cruz"
zmediaIgrejadeSantaCruz.AltText = ""
zmediaIgrejadeSantaCruz.Resources = {
	{
		Type = "jpg", 
		Filename = "005IgrejadeSantaCruz.jpg", 
		Directives = {}
	}
}
zmediaCafedeSantaCruz = Wherigo.ZMedia(cartCoimbra)
zmediaCafedeSantaCruz.Id = "07ad572a-0662-4b97-bc81-d2423c6b091c"
zmediaCafedeSantaCruz.Name = "Cafe de Santa Cruz"
zmediaCafedeSantaCruz.Description = "06 Cafe de Santa Cruz"
zmediaCafedeSantaCruz.AltText = ""
zmediaCafedeSantaCruz.Resources = {
	{
		Type = "jpg", 
		Filename = "006CafedeSantaCruz.jpg", 
		Directives = {}
	}
}
zmediaJardimdaManga = Wherigo.ZMedia(cartCoimbra)
zmediaJardimdaManga.Id = "c3714c65-0f1d-46d8-a120-a5fc5373d301"
zmediaJardimdaManga.Name = "Jardim da Manga"
zmediaJardimdaManga.Description = "07 Jardim da Manga"
zmediaJardimdaManga.AltText = ""
zmediaJardimdaManga.Resources = {
	{
		Type = "jpg", 
		Filename = "007JardimdaManga.jpg", 
		Directives = {}
	}
}
zmediaMercado = Wherigo.ZMedia(cartCoimbra)
zmediaMercado.Id = "1a703d46-6458-48e5-a8cb-13459ffa8233"
zmediaMercado.Name = "Mercado"
zmediaMercado.Description = "08 Mercado"
zmediaMercado.AltText = ""
zmediaMercado.Resources = {
	{
		Type = "jpg", 
		Filename = "008MercadodeCoimbra.jpg", 
		Directives = {}
	}
}
zmediaFaculdadedePsicologia = Wherigo.ZMedia(cartCoimbra)
zmediaFaculdadedePsicologia.Id = "6e3200df-d71e-48bd-b0e7-5a872f382aac"
zmediaFaculdadedePsicologia.Name = "Faculdade de Psicologia"
zmediaFaculdadedePsicologia.Description = "09 Faculdade de Psicologia"
zmediaFaculdadedePsicologia.AltText = ""
zmediaFaculdadedePsicologia.Resources = {
	{
		Type = "jpg", 
		Filename = "009FaculdadePsicologia.jpg", 
		Directives = {}
	}
}
zmediaEscadasnaaltadeCoimbra = Wherigo.ZMedia(cartCoimbra)
zmediaEscadasnaaltadeCoimbra.Id = "9be87373-1c55-43c5-84e6-8118d842750d"
zmediaEscadasnaaltadeCoimbra.Name = "Escadas na alta de Coimbra"
zmediaEscadasnaaltadeCoimbra.Description = "10 Escadas na alta de Coimbra"
zmediaEscadasnaaltadeCoimbra.AltText = ""
zmediaEscadasnaaltadeCoimbra.Resources = {
	{
		Type = "jpg", 
		Filename = "010Escadas.jpg", 
		Directives = {}
	}
}
zmediaMiradouro = Wherigo.ZMedia(cartCoimbra)
zmediaMiradouro.Id = "d1c30579-e451-4a26-8318-70c2bb78ec1a"
zmediaMiradouro.Name = "Miradouro"
zmediaMiradouro.Description = "11 Miradouro"
zmediaMiradouro.AltText = ""
zmediaMiradouro.Resources = {
	{
		Type = "jpg", 
		Filename = "011Miradouro.jpg", 
		Directives = {}
	}
}
zmediaLaboratorioQuimico = Wherigo.ZMedia(cartCoimbra)
zmediaLaboratorioQuimico.Id = "e57257f1-f9a5-43e9-b9d5-f20662c81683"
zmediaLaboratorioQuimico.Name = "Laboratorio Quimico"
zmediaLaboratorioQuimico.Description = "12 Laboratorio Quimico"
zmediaLaboratorioQuimico.AltText = ""
zmediaLaboratorioQuimico.Resources = {
	{
		Type = "jpg", 
		Filename = "012LaboratorioQuimico.jpg", 
		Directives = {}
	}
}
zmediaDomDinis = Wherigo.ZMedia(cartCoimbra)
zmediaDomDinis.Id = "4ec8e6a1-7b97-4dd8-b870-2b9e6bb4bf7a"
zmediaDomDinis.Name = "Dom Dinis"
zmediaDomDinis.Description = "13 D. DInis"
zmediaDomDinis.AltText = ""
zmediaDomDinis.Resources = {
	{
		Type = "jpg", 
		Filename = "013DDinis.jpg", 
		Directives = {}
	}
}
zmediaEscadasMonumentais = Wherigo.ZMedia(cartCoimbra)
zmediaEscadasMonumentais.Id = "8ccef033-5069-42d2-a520-f146628be381"
zmediaEscadasMonumentais.Name = "Escadas Monumentais"
zmediaEscadasMonumentais.Description = "14 Escadas Monumentais"
zmediaEscadasMonumentais.AltText = ""
zmediaEscadasMonumentais.Resources = {
	{
		Type = "jpg", 
		Filename = "014Escadasmonumentais.jpg", 
		Directives = {}
	}
}
zmediaFaculdadedeMatematica = Wherigo.ZMedia(cartCoimbra)
zmediaFaculdadedeMatematica.Id = "9ece674d-becf-4d48-badf-0c93595eb53d"
zmediaFaculdadedeMatematica.Name = "Faculdade de Matematica"
zmediaFaculdadedeMatematica.Description = "15 Faculdade de Matematica"
zmediaFaculdadedeMatematica.AltText = ""
zmediaFaculdadedeMatematica.Resources = {
	{
		Type = "jpg", 
		Filename = "015FaculdadedeMatematica.jpg", 
		Directives = {}
	}
}
zmediaArcosdeJardim = Wherigo.ZMedia(cartCoimbra)
zmediaArcosdeJardim.Id = "5d83a4cc-bc35-4050-8586-f575e4c3205a"
zmediaArcosdeJardim.Name = "Arcos de Jardim"
zmediaArcosdeJardim.Description = "16 Arcos de Jardim"
zmediaArcosdeJardim.AltText = ""
zmediaArcosdeJardim.Resources = {
	{
		Type = "jpg", 
		Filename = "016Arcosdejardim.jpg", 
		Directives = {}
	}
}
zmediaFaculdadedeLetras = Wherigo.ZMedia(cartCoimbra)
zmediaFaculdadedeLetras.Id = "fc3818d6-da43-448f-9652-fac88a43353f"
zmediaFaculdadedeLetras.Name = "Faculdade de Letras"
zmediaFaculdadedeLetras.Description = "17 Faculdade de Letras"
zmediaFaculdadedeLetras.AltText = ""
zmediaFaculdadedeLetras.Resources = {
	{
		Type = "jpg", 
		Filename = "017FaculdadedeLetras.jpg", 
		Directives = {}
	}
}
zmediaViaLactea = Wherigo.ZMedia(cartCoimbra)
zmediaViaLactea.Id = "69be21a9-0573-48bd-8fc6-84a264478523"
zmediaViaLactea.Name = "Via Lactea"
zmediaViaLactea.Description = "18 Via Lactea"
zmediaViaLactea.AltText = ""
zmediaViaLactea.Resources = {
	{
		Type = "jpg", 
		Filename = "018ViaLactea.jpg", 
		Directives = {}
	}
}
zmediaPortaFerrea = Wherigo.ZMedia(cartCoimbra)
zmediaPortaFerrea.Id = "ef385a29-4feb-427b-b691-195924d6e8b7"
zmediaPortaFerrea.Name = "Porta Ferrea"
zmediaPortaFerrea.Description = "19 Porta Ferrea"
zmediaPortaFerrea.AltText = ""
zmediaPortaFerrea.Resources = {
	{
		Type = "jpg", 
		Filename = "019PortaFerrea.jpg", 
		Directives = {}
	}
}
zmediaIgrejadoMuseuMachadodeCastro = Wherigo.ZMedia(cartCoimbra)
zmediaIgrejadoMuseuMachadodeCastro.Id = "123a0809-81bc-4e71-8805-9225f9380b3a"
zmediaIgrejadoMuseuMachadodeCastro.Name = "Igreja do Museu Machado de Castro"
zmediaIgrejadoMuseuMachadodeCastro.Description = "20 Igreja do Museu Machado de Castro"
zmediaIgrejadoMuseuMachadodeCastro.AltText = ""
zmediaIgrejadoMuseuMachadodeCastro.Resources = {
	{
		Type = "jpg", 
		Filename = "020IgrejaMuseuMachadodeCastro.jpg", 
		Directives = {}
	}
}
zmediaSeNova = Wherigo.ZMedia(cartCoimbra)
zmediaSeNova.Id = "2edc20f8-8d4c-4d1f-aa55-3396d314fa90"
zmediaSeNova.Name = "Se Nova"
zmediaSeNova.Description = "21 Se Nova"
zmediaSeNova.AltText = ""
zmediaSeNova.Resources = {
	{
		Type = "jpg", 
		Filename = "021SeNova.jpg", 
		Directives = {}
	}
}
zmediaMuseuMachadodeCastro = Wherigo.ZMedia(cartCoimbra)
zmediaMuseuMachadodeCastro.Id = "8f9fdc05-7480-4bfd-ab91-483a9eab5709"
zmediaMuseuMachadodeCastro.Name = "Museu Machado de Castro"
zmediaMuseuMachadodeCastro.Description = "22 Museu Machado de Castro"
zmediaMuseuMachadodeCastro.AltText = ""
zmediaMuseuMachadodeCastro.Resources = {
	{
		Type = "jpg", 
		Filename = "022DetrasdoMuseuMachadodedCastro.jpg", 
		Directives = {}
	}
}
zmediaSeVelha = Wherigo.ZMedia(cartCoimbra)
zmediaSeVelha.Id = "7865160b-c342-4ee2-8e85-cf4699767e2e"
zmediaSeVelha.Name = "Se Velha"
zmediaSeVelha.Description = "23 Se Velha"
zmediaSeVelha.AltText = ""
zmediaSeVelha.Resources = {
	{
		Type = "jpg", 
		Filename = "023SeVelha.jpg", 
		Directives = {}
	}
}
zmediaQuebraCostas = Wherigo.ZMedia(cartCoimbra)
zmediaQuebraCostas.Id = "8b5c7575-beb2-4d4e-9ee0-1f657fa0befc"
zmediaQuebraCostas.Name = "Quebra Costas"
zmediaQuebraCostas.Description = "24 Quebra Costas"
zmediaQuebraCostas.AltText = ""
zmediaQuebraCostas.Resources = {
	{
		Type = "jpg", 
		Filename = "024QuebraCostas.jpg", 
		Directives = {}
	}
}
zmediaArcodeAlmedina = Wherigo.ZMedia(cartCoimbra)
zmediaArcodeAlmedina.Id = "6067ecff-230f-467c-8135-6c8e40225d65"
zmediaArcodeAlmedina.Name = "Arco de Almedina"
zmediaArcodeAlmedina.Description = "25 Arco de Almedina"
zmediaArcodeAlmedina.AltText = ""
zmediaArcodeAlmedina.Resources = {
	{
		Type = "jpg", 
		Filename = "025ArcodeAlmedina.jpg", 
		Directives = {}
	}
}
zmediaIgreja = Wherigo.ZMedia(cartCoimbra)
zmediaIgreja.Id = "958c62fc-3bda-4699-b2ef-6f27528f2351"
zmediaIgreja.Name = "Igreja"
zmediaIgreja.Description = "26 Igreja"
zmediaIgreja.AltText = ""
zmediaIgreja.Resources = {
	{
		Type = "jpg", 
		Filename = "026.jpg", 
		Directives = {}
	}
}
zmediaCouraadeLisboa = Wherigo.ZMedia(cartCoimbra)
zmediaCouraadeLisboa.Id = "f5e494b5-fd9b-4b60-86a5-730689df3ffd"
zmediaCouraadeLisboa.Name = "Couraca de Lisboa"
zmediaCouraadeLisboa.Description = "27 Couraca de Lisboa"
zmediaCouraadeLisboa.AltText = ""
zmediaCouraadeLisboa.Resources = {
	{
		Type = "jpg", 
		Filename = "027CouracadeLisboa.jpg", 
		Directives = {}
	}
}
zmediaJuntoaoGovernoCivil = Wherigo.ZMedia(cartCoimbra)
zmediaJuntoaoGovernoCivil.Id = "a1302a68-04e4-4693-aaa2-17cd49b2e2f3"
zmediaJuntoaoGovernoCivil.Name = "Junto ao Governo Civil"
zmediaJuntoaoGovernoCivil.Description = "28 Junto ao Governo Civil"
zmediaJuntoaoGovernoCivil.AltText = ""
zmediaJuntoaoGovernoCivil.Resources = {
	{
		Type = "jpg", 
		Filename = "028Juntoaogovernocivil.jpg", 
		Directives = {}
	}
}
zmediaLargodaPortagem = Wherigo.ZMedia(cartCoimbra)
zmediaLargodaPortagem.Id = "bcce1f7c-8c8c-4721-8e6c-dbc110c5c653"
zmediaLargodaPortagem.Name = "Largo da Portagem"
zmediaLargodaPortagem.Description = "29 Largo da Portagem"
zmediaLargodaPortagem.AltText = ""
zmediaLargodaPortagem.Resources = {
	{
		Type = "jpg", 
		Filename = "029Largodaportagem.jpg", 
		Directives = {}
	}
}
zmediaEsttuaLargodaPortagem = Wherigo.ZMedia(cartCoimbra)
zmediaEsttuaLargodaPortagem.Id = "77a9f210-b84b-430b-821c-56ed40b94d80"
zmediaEsttuaLargodaPortagem.Name = "Estatua Largo da Portagem"
zmediaEsttuaLargodaPortagem.Description = "30 Estatua Largo da Portagem"
zmediaEsttuaLargodaPortagem.AltText = ""
zmediaEsttuaLargodaPortagem.Resources = {
	{
		Type = "jpg", 
		Filename = "030Estatualargodaportagem.jpg", 
		Directives = {}
	}
}
zmediaJuntoaPracadoComercio = Wherigo.ZMedia(cartCoimbra)
zmediaJuntoaPracadoComercio.Id = "88d1b365-14d0-4124-80ce-76996d91dbe7"
zmediaJuntoaPracadoComercio.Name = "Junto a Praca do Comercio"
zmediaJuntoaPracadoComercio.Description = "31 Junto a Praca do Comercio"
zmediaJuntoaPracadoComercio.AltText = ""
zmediaJuntoaPracadoComercio.Resources = {
	{
		Type = "jpg", 
		Filename = "031JuntoapracadoComercio.jpg", 
		Directives = {}
	}
}
zmediaIgrejajuntoapracadocomercio = Wherigo.ZMedia(cartCoimbra)
zmediaIgrejajuntoapracadocomercio.Id = "12671440-86b0-4753-8204-0f4cc8df9edb"
zmediaIgrejajuntoapracadocomercio.Name = "Igreja junto a praca do comercio"
zmediaIgrejajuntoapracadocomercio.Description = "32 Igreja junto a praca do comercio"
zmediaIgrejajuntoapracadocomercio.AltText = ""
zmediaIgrejajuntoapracadocomercio.Resources = {
	{
		Type = "jpg", 
		Filename = "032IgrejajuntoapracadoComercio.jpg", 
		Directives = {}
	}
}
zmediaPracadoComercio = Wherigo.ZMedia(cartCoimbra)
zmediaPracadoComercio.Id = "9303185f-47d9-42c1-88d5-be975b77e407"
zmediaPracadoComercio.Name = "Praca do Comercio"
zmediaPracadoComercio.Description = "33 Praca do Comercio"
zmediaPracadoComercio.AltText = ""
zmediaPracadoComercio.Resources = {
	{
		Type = "jpg", 
		Filename = "033PracadoComercio.jpg", 
		Directives = {}
	}
}
zmediaIgrejadeSaoTiago = Wherigo.ZMedia(cartCoimbra)
zmediaIgrejadeSaoTiago.Id = "63c8729d-fea7-45a2-bceb-f666245f8912"
zmediaIgrejadeSaoTiago.Name = "Igreja de Sao Tiago"
zmediaIgrejadeSaoTiago.Description = "34 Igreja de Sao Tiago"
zmediaIgrejadeSaoTiago.AltText = ""
zmediaIgrejadeSaoTiago.Resources = {
	{
		Type = "jpg", 
		Filename = "034IgrejanapracadoComercio.jpg", 
		Directives = {}
	}
}
zmediaEstacao = Wherigo.ZMedia(cartCoimbra)
zmediaEstacao.Id = "0cf35b69-01b1-4642-bded-70df1730708f"
zmediaEstacao.Name = "Estacao"
zmediaEstacao.Description = "35 Estacao"
zmediaEstacao.AltText = ""
zmediaEstacao.Resources = {
	{
		Type = "jpg", 
		Filename = "035EstacaodaCP.jpg", 
		Directives = {}
	}
}
zmediaRioMondego = Wherigo.ZMedia(cartCoimbra)
zmediaRioMondego.Id = "a201df35-a9b9-4aa9-b448-31a80e791653"
zmediaRioMondego.Name = "Rio Mondego"
zmediaRioMondego.Description = "36 Rio Mondego"
zmediaRioMondego.AltText = ""
zmediaRioMondego.Resources = {
	{
		Type = "jpg", 
		Filename = "036RioMondego.jpg", 
		Directives = {}
	}
}
zmediaProfessor = Wherigo.ZMedia(cartCoimbra)
zmediaProfessor.Id = "a1bbaddb-86fa-40a3-a7ef-02cbf0ac8ee0"
zmediaProfessor.Name = "Professor"
zmediaProfessor.Description = "Professor"
zmediaProfessor.AltText = ""
zmediaProfessor.Resources = {
	{
		Type = "jpg", 
		Filename = "Teacher.jpg", 
		Directives = {}
	}
}
zmediaItem_01_Coluna_tribunal = Wherigo.ZMedia(cartCoimbra)
zmediaItem_01_Coluna_tribunal.Id = "8decfcd3-8088-4f4c-8a10-aaada95f9058"
zmediaItem_01_Coluna_tribunal.Name = "Item_01_Coluna_tribunal"
zmediaItem_01_Coluna_tribunal.Description = ""
zmediaItem_01_Coluna_tribunal.AltText = ""
zmediaItem_01_Coluna_tribunal.Resources = {
	{
		Type = "jpg", 
		Filename = "01Coluna-tribunal-800.jpg", 
		Directives = {}
	}
}
zmediaItem_02_Candeeiro_CMC = Wherigo.ZMedia(cartCoimbra)
zmediaItem_02_Candeeiro_CMC.Id = "5dd8ef84-12ae-47f5-b4ed-ab1da6b116c2"
zmediaItem_02_Candeeiro_CMC.Name = "Item_02_Candeeiro_CMC"
zmediaItem_02_Candeeiro_CMC.Description = ""
zmediaItem_02_Candeeiro_CMC.AltText = ""
zmediaItem_02_Candeeiro_CMC.Resources = {
	{
		Type = "jpg", 
		Filename = "02Candeeiro-CMC-800.jpg", 
		Directives = {}
	}
}
zmedia20igrejapraadocomercio800 = Wherigo.ZMedia(cartCoimbra)
zmedia20igrejapraadocomercio800.Id = "1926dfc8-85de-4330-bd99-020467fd4060"
zmedia20igrejapraadocomercio800.Name = "20 igreja praca do comercio-800"
zmedia20igrejapraadocomercio800.Description = "[Batch Import Media]"
zmedia20igrejapraadocomercio800.AltText = ""
zmedia20igrejapraadocomercio800.Resources = {
	{
		Type = "jpg", 
		Filename = "20igrejapracadocomercio-800.jpg", 
		Directives = {}
	}
}
zmedia03dragaocafesantacruz800 = Wherigo.ZMedia(cartCoimbra)
zmedia03dragaocafesantacruz800.Id = "0c3b6124-61e7-40d3-95c0-cdde48d0c32e"
zmedia03dragaocafesantacruz800.Name = "03 - dragao - cafe santa cruz-800"
zmedia03dragaocafesantacruz800.Description = "[Batch Import Media]"
zmedia03dragaocafesantacruz800.AltText = ""
zmedia03dragaocafesantacruz800.Resources = {
	{
		Type = "jpg", 
		Filename = "03-dragao-cafesantacruz-800.jpg", 
		Directives = {}
	}
}
zmedia04fontedojardimdamanga800 = Wherigo.ZMedia(cartCoimbra)
zmedia04fontedojardimdamanga800.Id = "648cba50-5706-4204-b1e5-eea79633274f"
zmedia04fontedojardimdamanga800.Name = "04 - fonte do jardim da manga-800"
zmedia04fontedojardimdamanga800.Description = "[Batch Import Media]"
zmedia04fontedojardimdamanga800.AltText = ""
zmedia04fontedojardimdamanga800.Resources = {
	{
		Type = "jpg", 
		Filename = "04-fontedojardimdamanga-800.jpg", 
		Directives = {}
	}
}
zmedia05juntoaoLabquimico800 = Wherigo.ZMedia(cartCoimbra)
zmedia05juntoaoLabquimico800.Id = "c6d28e80-695f-4b5b-88ba-50275f019a6e"
zmedia05juntoaoLabquimico800.Name = "05 - junto ao Lab quimico-800"
zmedia05juntoaoLabquimico800.Description = "[Batch Import Media]"
zmedia05juntoaoLabquimico800.AltText = ""
zmedia05juntoaoLabquimico800.Resources = {
	{
		Type = "jpg", 
		Filename = "05-juntoaoLabquimico-800.jpg", 
		Directives = {}
	}
}
zmedia06Labquimico800 = Wherigo.ZMedia(cartCoimbra)
zmedia06Labquimico800.Id = "16ce3f30-4d26-460d-b790-044906b93e32"
zmedia06Labquimico800.Name = "06 - Lab quimico-800"
zmedia06Labquimico800.Description = "[Batch Import Media]"
zmedia06Labquimico800.AltText = ""
zmedia06Labquimico800.Resources = {
	{
		Type = "jpg", 
		Filename = "06-Labquimico-800.jpg", 
		Directives = {}
	}
}
zmedia07bolaescadamonumentais800 = Wherigo.ZMedia(cartCoimbra)
zmedia07bolaescadamonumentais800.Id = "75362e81-7d68-4fbf-aef4-4ba22f9b68b3"
zmedia07bolaescadamonumentais800.Name = "07 bola escada monumentais-800"
zmedia07bolaescadamonumentais800.Description = "[Batch Import Media]"
zmedia07bolaescadamonumentais800.AltText = ""
zmedia07bolaescadamonumentais800.Resources = {
	{
		Type = "jpg", 
		Filename = "07bolaescadamonumentais-800.jpg", 
		Directives = {}
	}
}
zmedia08telhadouniversidade800 = Wherigo.ZMedia(cartCoimbra)
zmedia08telhadouniversidade800.Id = "e3028a57-4c36-4b7e-a6e2-cd2972bd7c95"
zmedia08telhadouniversidade800.Name = "08 telhado universidade-800"
zmedia08telhadouniversidade800.Description = "[Batch Import Media]"
zmedia08telhadouniversidade800.AltText = ""
zmedia08telhadouniversidade800.Resources = {
	{
		Type = "jpg", 
		Filename = "08telhadouniversidade-800.jpg", 
		Directives = {}
	}
}
zmedia09estatuafaculdadedeletras800 = Wherigo.ZMedia(cartCoimbra)
zmedia09estatuafaculdadedeletras800.Id = "30601da0-c67c-4763-944e-1ac0a8cfc340"
zmedia09estatuafaculdadedeletras800.Name = "09 estatua - faculdade de letras-800"
zmedia09estatuafaculdadedeletras800.Description = "[Batch Import Media]"
zmedia09estatuafaculdadedeletras800.AltText = ""
zmedia09estatuafaculdadedeletras800.Resources = {
	{
		Type = "jpg", 
		Filename = "09estatua-faculdadedeletras-800.jpg", 
		Directives = {}
	}
}
zmedia10vieiravialactea800 = Wherigo.ZMedia(cartCoimbra)
zmedia10vieiravialactea800.Id = "5b48321e-1d4b-4e79-85b0-6da99fdc2ce1"
zmedia10vieiravialactea800.Name = "10 vieira - via lactea-800"
zmedia10vieiravialactea800.Description = "[Batch Import Media]"
zmedia10vieiravialactea800.AltText = ""
zmedia10vieiravialactea800.Resources = {
	{
		Type = "jpg", 
		Filename = "10vieira-vialactea-800.jpg", 
		Directives = {}
	}
}
zmedia11cruzigrejamuseumachadodecastro800 = Wherigo.ZMedia(cartCoimbra)
zmedia11cruzigrejamuseumachadodecastro800.Id = "70b709c5-a1cb-48d9-b2ce-1e4cebcad4f5"
zmedia11cruzigrejamuseumachadodecastro800.Name = "11 cruz - igreja - museu machado de castro-800"
zmedia11cruzigrejamuseumachadodecastro800.Description = "[Batch Import Media]"
zmedia11cruzigrejamuseumachadodecastro800.AltText = ""
zmedia11cruzigrejamuseumachadodecastro800.Resources = {
	{
		Type = "jpg", 
		Filename = "11cruz-igreja-museumachadodecastro-800.jpg", 
		Directives = {}
	}
}
zmedia12triangulosenova800 = Wherigo.ZMedia(cartCoimbra)
zmedia12triangulosenova800.Id = "48666a37-51fe-4620-95fc-ff1c4a45ec6c"
zmedia12triangulosenova800.Name = "12 triangulo - se nova-800"
zmedia12triangulosenova800.Description = "[Batch Import Media]"
zmedia12triangulosenova800.AltText = ""
zmedia12triangulosenova800.Resources = {
	{
		Type = "jpg", 
		Filename = "12triangulo-senova-800.jpg", 
		Directives = {}
	}
}
zmedia13santamuseumachadodecastro800 = Wherigo.ZMedia(cartCoimbra)
zmedia13santamuseumachadodecastro800.Id = "109a2a01-f68b-46c6-8b6b-24238e98825b"
zmedia13santamuseumachadodecastro800.Name = "13 santa museu machado de castro-800"
zmedia13santamuseumachadodecastro800.Description = "[Batch Import Media]"
zmedia13santamuseumachadodecastro800.AltText = ""
zmedia13santamuseumachadodecastro800.Resources = {
	{
		Type = "jpg", 
		Filename = "13santamuseumachadodecastro-800.jpg", 
		Directives = {}
	}
}
zmedia14sevelha800 = Wherigo.ZMedia(cartCoimbra)
zmedia14sevelha800.Id = "80576b87-cd0b-4bff-b1ee-797e6e488967"
zmedia14sevelha800.Name = "14 se velha-800"
zmedia14sevelha800.Description = "[Batch Import Media]"
zmedia14sevelha800.AltText = ""
zmedia14sevelha800.Resources = {
	{
		Type = "jpg", 
		Filename = "14sevelha-800.jpg", 
		Directives = {}
	}
}
zmedia15jarroquebracostas800 = Wherigo.ZMedia(cartCoimbra)
zmedia15jarroquebracostas800.Id = "6668d7a4-863c-4e57-bf6d-b09df3b7d0e9"
zmedia15jarroquebracostas800.Name = "15 jarro - quebra costas-800"
zmedia15jarroquebracostas800.Description = "[Batch Import Media]"
zmedia15jarroquebracostas800.AltText = ""
zmedia15jarroquebracostas800.Resources = {
	{
		Type = "jpg", 
		Filename = "15jarro-quebracostas-800.jpg", 
		Directives = {}
	}
}
zmedia16pedrasjuntoaogovernocivil800 = Wherigo.ZMedia(cartCoimbra)
zmedia16pedrasjuntoaogovernocivil800.Id = "93b2d832-4d33-4c61-9579-5ac28952913f"
zmedia16pedrasjuntoaogovernocivil800.Name = "16 pedras junto ao governo civil-800"
zmedia16pedrasjuntoaogovernocivil800.Description = "[Batch Import Media]"
zmedia16pedrasjuntoaogovernocivil800.AltText = ""
zmedia16pedrasjuntoaogovernocivil800.Resources = {
	{
		Type = "jpg", 
		Filename = "16pedrasjuntoaogovernocivil-800.jpg", 
		Directives = {}
	}
}
zmedia17maodemigueltorgaportagem800 = Wherigo.ZMedia(cartCoimbra)
zmedia17maodemigueltorgaportagem800.Id = "2f5924d9-d93b-441f-81fd-748e53eb398d"
zmedia17maodemigueltorgaportagem800.Name = "17 mao de miguel torga - portagem-800"
zmedia17maodemigueltorgaportagem800.Description = "[Batch Import Media]"
zmedia17maodemigueltorgaportagem800.AltText = ""
zmedia17maodemigueltorgaportagem800.Resources = {
	{
		Type = "jpg", 
		Filename = "17maodemigueltorga-portagem-800.jpg", 
		Directives = {}
	}
}
zmedia18pilarigrejapraodocomercio800 = Wherigo.ZMedia(cartCoimbra)
zmedia18pilarigrejapraodocomercio800.Id = "2bf11ad7-4a14-4b2d-8b48-890976a416a0"
zmedia18pilarigrejapraodocomercio800.Name = "18 pilar igreja praco do comercio-800"
zmedia18pilarigrejapraodocomercio800.Description = "[Batch Import Media]"
zmedia18pilarigrejapraodocomercio800.AltText = ""
zmedia18pilarigrejapraodocomercio800.Resources = {
	{
		Type = "jpg", 
		Filename = "18pilarigrejapracodocomercio-800.jpg", 
		Directives = {}
	}
}
zmedia19PraadoComrcio800 = Wherigo.ZMedia(cartCoimbra)
zmedia19PraadoComrcio800.Id = "25fec33c-9bd6-4a04-b4dd-d098b68e3068"
zmedia19PraadoComrcio800.Name = "19 Praca do Comercio-800"
zmedia19PraadoComrcio800.Description = "[Batch Import Media]"
zmedia19PraadoComrcio800.AltText = ""
zmedia19PraadoComrcio800.Resources = {
	{
		Type = "jpg", 
		Filename = "19PracadoComercio-800.jpg", 
		Directives = {}
	}
}
zmediaCoimbra = Wherigo.ZMedia(cartCoimbra)
zmediaCoimbra.Id = "adb81ad7-55e4-4cfa-a4a6-ef987d5a699e"
zmediaCoimbra.Name = "Coimbra"
zmediaCoimbra.Description = ""
zmediaCoimbra.AltText = ""
zmediaCoimbra.Resources = {
	{
		Type = "jpg", 
		Filename = "Coimbra.jpg", 
		Directives = {}
	}
}
zmediapatio_azulejo = Wherigo.ZMedia(cartCoimbra)
zmediapatio_azulejo.Id = "a59155bc-b13d-44e8-940d-5db92ee76c41"
zmediapatio_azulejo.Name = "patio_azulejo"
zmediapatio_azulejo.Description = ""
zmediapatio_azulejo.AltText = ""
zmediapatio_azulejo.Resources = {
	{
		Type = "JPG", 
		Filename = "patio.JPG", 
		Directives = {}
	}
}
_7oHN = Wherigo.ZMedia(cartCoimbra)
_7oHN.Id = "64783300-a5bc-49da-a733-f4fedc0db068"
_7oHN.Name = "Question "
_7oHN.Description = ""
_7oHN.AltText = "Question"
_7oHN.Resources = {
	{
		Type = "jpg", 
		Filename = "Teacher-Question.jpg", 
		Directives = {}
	}
}
_vAw = Wherigo.ZMedia(cartCoimbra)
_vAw.Id = "eeb62f0d-419c-4638-be1c-190131d6dbd7"
_vAw.Name = "Malevolus"
_vAw.Description = ""
_vAw.AltText = ""
_vAw.Resources = {
	{
		Type = "jpg", 
		Filename = "studentcartoon.jpg", 
		Directives = {}
	}
}
_aPh = Wherigo.ZMedia(cartCoimbra)
_aPh.Id = "d502c401-8c3c-4c2e-af0d-27c194a185a7"
_aPh.Name = "Icon_Coimbra"
_aPh.Description = ""
_aPh.AltText = ""
_aPh.Resources = {
	{
		Type = "jpg", 
		Filename = "Coimbra_icon.jpg", 
		Directives = {}
	}
}
_5cpm = Wherigo.ZMedia(cartCoimbra)
_5cpm.Id = "30a8b39b-779e-40d8-ae97-49dc24061b37"
_5cpm.Name = "Malevolus icon"
_5cpm.Description = ""
_5cpm.AltText = ""
_5cpm.Resources = {
	{
		Type = "JPG", 
		Filename = "studentcartoonicon2.JPG", 
		Directives = {}
	}
}
_Ggo = Wherigo.ZMedia(cartCoimbra)
_Ggo.Id = "4d801dbe-58e7-4b6e-b91c-28ca41eccf18"
_Ggo.Name = "Colina ICON"
_Ggo.Description = ""
_Ggo.AltText = ""
_Ggo.Resources = {
	{
		Type = "jpg", 
		Filename = "01Coluna-tribunal-800-32x32.jpg", 
		Directives = {}
	}
}
_UIS = Wherigo.ZMedia(cartCoimbra)
_UIS.Id = "174e8755-85c5-4dba-9667-1553ba4f9a3e"
_UIS.Name = "Tribunal"
_UIS.Description = ""
_UIS.AltText = ""
_UIS.Resources = {
	{
		Type = "jpg", 
		Filename = "001Tribunal-32x32.jpg", 
		Directives = {}
	}
}
_i_e = Wherigo.ZMedia(cartCoimbra)
_i_e.Id = "42df0ddf-62f8-4cb5-a9cb-1e172091385a"
_i_e.Name = "Candeeiro ICON"
_i_e.Description = ""
_i_e.AltText = ""
_i_e.Resources = {
	{
		Type = "jpg", 
		Filename = "02Candeeiro-CMC-800-32x32.jpg", 
		Directives = {}
	}
}
_GAp_ = Wherigo.ZMedia(cartCoimbra)
_GAp_.Id = "a356d9ac-a11d-4734-a090-b3888124843e"
_GAp_.Name = "ICON"
_GAp_.Description = ""
_GAp_.AltText = ""
_GAp_.Resources = {
	{
		Type = "jpg", 
		Filename = "002PB250062-800-32x32.jpg", 
		Directives = {}
	}
}
_MEjI = Wherigo.ZMedia(cartCoimbra)
_MEjI.Id = "5ab32267-932a-4741-86de-260f0d263cdb"
_MEjI.Name = "Eagle ICON"
_MEjI.Description = ""
_MEjI.AltText = ""
_MEjI.Resources = {
	{
		Type = "jpg", 
		Filename = "03-dragao-cafesantacruz-800-32x32.jpg", 
		Directives = {}
	}
}
_Flea = Wherigo.ZMedia(cartCoimbra)
_Flea.Id = "fdb4233f-c910-4296-be90-2941f6792f6c"
_Flea.Name = "Inquisicao ICON"
_Flea.Description = ""
_Flea.AltText = ""
_Flea.Resources = {
	{
		Type = "jpg", 
		Filename = "003PatiodaInquisicao-32x32.jpg", 
		Directives = {}
	}
}
_hay = Wherigo.ZMedia(cartCoimbra)
_hay.Id = "fad36be4-347c-4890-b784-9c6fbc42e83e"
_hay.Name = "Fone Manga ICON"
_hay.Description = ""
_hay.AltText = ""
_hay.Resources = {
	{
		Type = "jpg", 
		Filename = "04-fontedojardimdamanga-800-32x32.jpg", 
		Directives = {}
	}
}
_ojOq = Wherigo.ZMedia(cartCoimbra)
_ojOq.Id = "49db20d7-12fe-4eb7-88e0-0a8107e67de3"
_ojOq.Name = "CMC ICON"
_ojOq.Description = ""
_ojOq.AltText = ""
_ojOq.Resources = {
	{
		Type = "jpg", 
		Filename = "004CamaraMunicipaldeCoimbra-32x32.jpg", 
		Directives = {}
	}
}
_xRF06 = Wherigo.ZMedia(cartCoimbra)
_xRF06.Id = "cd079cb7-c4d6-45e4-a95e-403427825619"
_xRF06.Name = "Lab Quimico Object ICON"
_xRF06.Description = ""
_xRF06.AltText = ""
_xRF06.Resources = {
	{
		Type = "jpg", 
		Filename = "05-juntoaoLabquimico-800-32x32.jpg", 
		Directives = {}
	}
}
_mBsvF = Wherigo.ZMedia(cartCoimbra)
_mBsvF.Id = "72980927-511a-4def-8fad-6a42935bf26e"
_mBsvF.Name = "Cafe Santa Cruz ICON"
_mBsvF.Description = ""
_mBsvF.AltText = ""
_mBsvF.Resources = {
	{
		Type = "jpg", 
		Filename = "006CafedeSantaCruz-32x32.jpg", 
		Directives = {}
	}
}
_3BF = Wherigo.ZMedia(cartCoimbra)
_3BF.Id = "50b5c9b0-8683-41e5-b7cf-ed52eb380933"
_3BF.Name = "Bola ICON"
_3BF.Description = ""
_3BF.AltText = ""
_3BF.Resources = {
	{
		Type = "jpg", 
		Filename = "07bolaescadamonumentais-800-32x32.jpg", 
		Directives = {}
	}
}
_VcIi = Wherigo.ZMedia(cartCoimbra)
_VcIi.Id = "cba780e4-5c61-4c7b-98a2-4476d0489312"
_VcIi.Name = "Manga ICON"
_VcIi.Description = ""
_VcIi.AltText = ""
_VcIi.Resources = {
	{
		Type = "jpg", 
		Filename = "007JardimdaManga-32x32.jpg", 
		Directives = {}
	}
}
_cjTF = Wherigo.ZMedia(cartCoimbra)
_cjTF.Id = "75aa9b93-12bc-43fe-8f05-67cd4b0b2c26"
_cjTF.Name = "Mercado ICON"
_cjTF.Description = ""
_cjTF.AltText = ""
_cjTF.Resources = {
	{
		Type = "jpg", 
		Filename = "008MercadodeCoimbra-32x32.jpg", 
		Directives = {}
	}
}
_qUJ1 = Wherigo.ZMedia(cartCoimbra)
_qUJ1.Id = "aecef06e-12f9-496d-b039-f4fc744cec4b"
_qUJ1.Name = "Estatua ICON"
_qUJ1.Description = ""
_qUJ1.AltText = ""
_qUJ1.Resources = {
	{
		Type = "jpg", 
		Filename = "09estatua-faculdadedeletras-800-32x32.jpg", 
		Directives = {}
	}
}
_3kHN = Wherigo.ZMedia(cartCoimbra)
_3kHN.Id = "815db682-fd59-494b-ad58-70bd3cfbdae1"
_3kHN.Name = "Psicologia ICON"
_3kHN.Description = ""
_3kHN.AltText = ""
_3kHN.Resources = {
	{
		Type = "jpg", 
		Filename = "009FaculdadePsicologia-32x32.jpg", 
		Directives = {}
	}
}
_hFpJl = Wherigo.ZMedia(cartCoimbra)
_hFpJl.Id = "efb1344f-1441-4a4f-abe4-13c3ba92eec9"
_hFpJl.Name = "Escadas ICON"
_hFpJl.Description = ""
_hFpJl.AltText = ""
_hFpJl.Resources = {
	{
		Type = "jpg", 
		Filename = "010Escadas-32x32.jpg", 
		Directives = {}
	}
}
_5UG = Wherigo.ZMedia(cartCoimbra)
_5UG.Id = "22b57513-fe77-4626-b882-a1eea1ed65cd"
_5UG.Name = "Miradouro ICON"
_5UG.Description = ""
_5UG.AltText = ""
_5UG.Resources = {
	{
		Type = "jpg", 
		Filename = "011Miradouro-32x32.jpg", 
		Directives = {}
	}
}
_qK5aD = Wherigo.ZMedia(cartCoimbra)
_qK5aD.Id = "c62c615d-a854-46c3-b440-600b99675aca"
_qK5aD.Name = "Lab Quimico ICON"
_qK5aD.Description = ""
_qK5aD.AltText = ""
_qK5aD.Resources = {
	{
		Type = "jpg", 
		Filename = "012LaboratorioQuimico-32x32.jpg", 
		Directives = {}
	}
}
_fhg = Wherigo.ZMedia(cartCoimbra)
_fhg.Id = "72da3f37-b284-4817-959f-0fd3d8fbb432"
_fhg.Name = "Triangulo ICON"
_fhg.Description = ""
_fhg.AltText = ""
_fhg.Resources = {
	{
		Type = "jpg", 
		Filename = "12triangulo-senova-800-32x32.jpg", 
		Directives = {}
	}
}
_IWE = Wherigo.ZMedia(cartCoimbra)
_IWE.Id = "69183e04-075c-4472-8fd5-83426b29af7c"
_IWE.Name = "DDInis ICON"
_IWE.Description = ""
_IWE.AltText = ""
_IWE.Resources = {
	{
		Type = "jpg", 
		Filename = "013DDinis-32x32.jpg", 
		Directives = {}
	}
}
_TC3 = Wherigo.ZMedia(cartCoimbra)
_TC3.Id = "e3f79f97-87cb-4549-bba0-18643c65c600"
_TC3.Name = "escadas ICON"
_TC3.Description = ""
_TC3.AltText = ""
_TC3.Resources = {
	{
		Type = "jpg", 
		Filename = "014Escadasmonumentais-32x32.jpg", 
		Directives = {}
	}
}
_1Neu = Wherigo.ZMedia(cartCoimbra)
_1Neu.Id = "12a53abf-6e5a-49c1-9752-c26d4fb35f40"
_1Neu.Name = "SEVelha ICON"
_1Neu.Description = ""
_1Neu.AltText = ""
_1Neu.Resources = {
	{
		Type = "jpg", 
		Filename = "14sevelha-800-32x32.jpg", 
		Directives = {}
	}
}
_YtqY0 = Wherigo.ZMedia(cartCoimbra)
_YtqY0.Id = "b2810824-c2c1-443b-907f-1828f847e73a"
_YtqY0.Name = "Jarro ICON"
_YtqY0.Description = ""
_YtqY0.AltText = ""
_YtqY0.Resources = {
	{
		Type = "jpg", 
		Filename = "15jarro-quebracostas-800-32x32.jpg", 
		Directives = {}
	}
}
_IjAnS = Wherigo.ZMedia(cartCoimbra)
_IjAnS.Id = "239da6db-ddfb-4fd9-9d18-29fd345ba01a"
_IjAnS.Name = "ARCOS ICON"
_IjAnS.Description = ""
_IjAnS.AltText = ""
_IjAnS.Resources = {
	{
		Type = "jpg", 
		Filename = "016Arcosdejardim-32x32.jpg", 
		Directives = {}
	}
}
_R2J = Wherigo.ZMedia(cartCoimbra)
_R2J.Id = "b32a6e25-eb41-455e-b6d0-07c621102dc9"
_R2J.Name = "Pedras ICON"
_R2J.Description = ""
_R2J.AltText = ""
_R2J.Resources = {
	{
		Type = "jpg", 
		Filename = "16pedrasjuntoaogovernocivil-800-32x32.jpg", 
		Directives = {}
	}
}
_zXcA = Wherigo.ZMedia(cartCoimbra)
_zXcA.Id = "f242c0cf-e896-40b9-b2cd-ae7eb50bbd5f"
_zXcA.Name = "FAculdade Letras ICON"
_zXcA.Description = ""
_zXcA.AltText = ""
_zXcA.Resources = {
	{
		Type = "jpg", 
		Filename = "017FaculdadedeLetras-32x32.jpg", 
		Directives = {}
	}
}
_jvb = Wherigo.ZMedia(cartCoimbra)
_jvb.Id = "c29ed003-265f-40dd-84aa-d3c90b921125"
_jvb.Name = "Mao ICON"
_jvb.Description = ""
_jvb.AltText = ""
_jvb.Resources = {
	{
		Type = "jpg", 
		Filename = "17maodemigueltorga-portagem-800-32x32.jpg", 
		Directives = {}
	}
}
_2TmB5 = Wherigo.ZMedia(cartCoimbra)
_2TmB5.Id = "f4484f44-12d9-450f-9198-837360a4bbdd"
_2TmB5.Name = "Praca COmercio ICON"
_2TmB5.Description = ""
_2TmB5.AltText = ""
_2TmB5.Resources = {
	{
		Type = "jpg", 
		Filename = "19PracadoComercio-800-32x32.jpg", 
		Directives = {}
	}
}
_T7WgR = Wherigo.ZMedia(cartCoimbra)
_T7WgR.Id = "b4480fc4-4e2f-4418-86c8-77672bd22a8b"
_T7WgR.Name = "Machado ICON"
_T7WgR.Description = ""
_T7WgR.AltText = ""
_T7WgR.Resources = {
	{
		Type = "jpg", 
		Filename = "020IgrejaMuseuMachadodeCastro-32x32.jpg", 
		Directives = {}
	}
}
_tgk = Wherigo.ZMedia(cartCoimbra)
_tgk.Id = "66c9e538-39c6-4303-a3f6-fa4a865a12a5"
_tgk.Name = "SE NOva ICON"
_tgk.Description = ""
_tgk.AltText = ""
_tgk.Resources = {
	{
		Type = "jpg", 
		Filename = "021SeNova-32x32.jpg", 
		Directives = {}
	}
}
_kiJW = Wherigo.ZMedia(cartCoimbra)
_kiJW.Id = "0115b033-d5a4-4cb1-89f5-70a1b5b2837d"
_kiJW.Name = "Se Velha ICON "
_kiJW.Description = ""
_kiJW.AltText = ""
_kiJW.Resources = {
	{
		Type = "jpg", 
		Filename = "023SeVelha-32x32.jpg", 
		Directives = {}
	}
}
_cMtfB = Wherigo.ZMedia(cartCoimbra)
_cMtfB.Id = "7a8767c1-1be1-4db6-9145-2d8e811795b9"
_cMtfB.Name = "Quebra Costas ICON"
_cMtfB.Description = ""
_cMtfB.AltText = ""
_cMtfB.Resources = {
	{
		Type = "jpg", 
		Filename = "024QuebraCostas-32x32.jpg", 
		Directives = {}
	}
}
_c6GO0 = Wherigo.ZMedia(cartCoimbra)
_c6GO0.Id = "b17a515d-f417-4055-99ef-577d3c825dc7"
_c6GO0.Name = "Governo Civil ICON"
_c6GO0.Description = ""
_c6GO0.AltText = ""
_c6GO0.Resources = {
	{
		Type = "jpg", 
		Filename = "028Juntoaogovernocivil-32x32.jpg", 
		Directives = {}
	}
}
_3ip = Wherigo.ZMedia(cartCoimbra)
_3ip.Id = "70b191c8-3252-4b62-8995-32084ab74e3d"
_3ip.Name = "Portagem ICON"
_3ip.Description = ""
_3ip.AltText = ""
_3ip.Resources = {
	{
		Type = "jpg", 
		Filename = "029Largodaportagem-32x32.jpg", 
		Directives = {}
	}
}
_TGt_ = Wherigo.ZMedia(cartCoimbra)
_TGt_.Id = "de237eb6-6e5d-439e-a0f4-d9d3b3e45d28"
_TGt_.Name = "Estacao ICON"
_TGt_.Description = ""
_TGt_.AltText = ""
_TGt_.Resources = {
	{
		Type = "jpg", 
		Filename = "035EstacaodaCP-32x32.jpg", 
		Directives = {}
	}
}
_7U3k = Wherigo.ZMedia(cartCoimbra)
_7U3k.Id = "0574b93f-807b-4a64-8433-9e89303baee8"
_7U3k.Name = "Teacher ICON"
_7U3k.Description = ""
_7U3k.AltText = ""
_7U3k.Resources = {
	{
		Type = "jpg", 
		Filename = "CopyofTeacher-32x32.jpg", 
		Directives = {}
	}
}
_R43 = Wherigo.ZMedia(cartCoimbra)
_R43.Id = "b5f7ab81-98e7-402f-ae18-8b1c3cafba4b"
_R43.Name = "Teacher Question ICON"
_R43.Description = ""
_R43.AltText = ""
_R43.Resources = {
	{
		Type = "jpg", 
		Filename = "Teacher-Question-32x32_1.jpg", 
		Directives = {}
	}
}
_bXp = Wherigo.ZMedia(cartCoimbra)
_bXp.Id = "f446852e-21f5-427c-baa4-94c68b08225e"
_bXp.Name = "Coimbra ICON"
_bXp.Description = ""
_bXp.AltText = ""
_bXp.Resources = {
	{
		Type = "jpg", 
		Filename = "Coimbra-32x32.jpg", 
		Directives = {}
	}
}
_Yg5wD = Wherigo.ZMedia(cartCoimbra)
_Yg5wD.Id = "5fb2161d-c400-4618-8991-a53c8e341590"
_Yg5wD.Name = "Cache"
_Yg5wD.Description = ""
_Yg5wD.AltText = ""
_Yg5wD.Resources = {
	{
		Type = "jpg", 
		Filename = "Cache_new.jpg", 
		Directives = {}
	}
}
_Qap = Wherigo.ZMedia(cartCoimbra)
_Qap.Id = "a355a31d-5ffb-40eb-8c3e-c22221e45ae2"
_Qap.Name = "Spoiler"
_Qap.Description = ""
_Qap.AltText = ""
_Qap.Resources = {
	{
		Type = "jpg", 
		Filename = "spoiler2-240.jpg", 
		Directives = {}
	}
}
_T9B9 = Wherigo.ZMedia(cartCoimbra)
_T9B9.Id = "5b4759ec-c596-4514-b3ae-7829c3dafad4"
_T9B9.Name = "Botanico"
_T9B9.Description = ""
_T9B9.AltText = ""
_T9B9.Resources = {
	{
		Type = "jpg", 
		Filename = "Botanica-240.jpg", 
		Directives = {}
	}
}
_nCMpW = Wherigo.ZMedia(cartCoimbra)
_nCMpW.Id = "54e662f7-8a95-469e-98aa-2e2a70e8502f"
_nCMpW.Name = "portugues"
_nCMpW.Description = ""
_nCMpW.AltText = ""
_nCMpW.Resources = {
	{
		Type = "gif", 
		Filename = "bandeira-de-portugal.gif", 
		Directives = {}
	}
}
_h3B7 = Wherigo.ZMedia(cartCoimbra)
_h3B7.Id = "07ac233d-7b3b-4975-9357-c16c6ad08e8c"
_h3B7.Name = "ingles"
_h3B7.Description = ""
_h3B7.AltText = ""
_h3B7.Resources = {
	{
		Type = "jpg", 
		Filename = "UKflag.jpg", 
		Directives = {}
	}
}
_jkdy = Wherigo.ZMedia(cartCoimbra)
_jkdy.Id = "ec5726f5-26aa-4706-a560-23f9e75283b3"
_jkdy.Name = "Malevolus_jail"
_jkdy.Description = ""
_jkdy.AltText = ""
_jkdy.Resources = {
	{
		Type = "jpg", 
		Filename = "jail_studentcartoon.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
cartCoimbra.Id="4d7b7569-c0ce-4c31-8666-c30d2ded1674"
cartCoimbra.Name="Coimbra"
cartCoimbra.Description=[[[EN] A little adventure in Coimbra, where we have to go in a journey to try to stop the evil Malevolus from destroying some important places.
[PT] Uma pequena aventura em Coimbra, em que temos de percorrer as ruas da cidade para tentar impedir que Malevolus destrua alguns dos locais mais importantes.
]]
cartCoimbra.Visible=true
cartCoimbra.Activity="Geocache"
cartCoimbra.StartingLocationDescription=[[[EN] Coimbra is a city in the municipality of Coimbra in Portugal. Although it served as the nation's capital during the High Middle Ages, it is better-known for the its university, the University of Coimbra, which, established in 1290, is one of the oldest in Europe and the oldest academic institution in the Portuguese-speaking world.
[PT]
Coimbra e uma cidade situada no centro de Portugal. Foi durante a idade media capital de Portugal, sendo conhecida pela sua Universidade, que foi fundada em 1290, sendo uma das mais antigas da Europa e sendo esta a instituicao academica mais antiga de todo o mundo de lingua Portuguesa.]]
cartCoimbra.StartingLocation = ZonePoint(40.2050500258798,-8.42769492324828,0)
cartCoimbra.Version="1.05"
cartCoimbra.Company="vieira"
cartCoimbra.Author="Antonio Jose Vieira (avieira)"
cartCoimbra.BuilderVersion="URWIGO 1.14.4469.18959"
cartCoimbra.CreateDate="12/23/2010 13:57:36"
cartCoimbra.PublishDate="1/1/0001 12:00:00 AM"
cartCoimbra.UpdateDate="12/12/2012 20:18:40"
cartCoimbra.LastPlayedDate="1/1/0001 12:00:00 AM"
cartCoimbra.TargetDevice="PocketPC"
cartCoimbra.TargetDeviceVersion="0"
cartCoimbra.StateId="1"
cartCoimbra.CountryId="2"
cartCoimbra.Complete=false
cartCoimbra.UseLogging=true

cartCoimbra.Media=zmediaCoimbra

cartCoimbra.Icon=_bXp


-- Zones --
zoneTribunal = Wherigo.Zone(cartCoimbra)
zoneTribunal.Id = "7cebbabe-8389-4d19-b10e-26b70654f7cc"
zoneTribunal.Name = "Tribunal"
zoneTribunal.Description = [[[EN]
Tribunal de Coimbra - College of St Thomas 
Originally dating from the 16th century, it has been rebuilt several times, principally in the late 19th century, when the former college was adapted as a residence for the Counts of Ameal, and during the 20th century, when it became the Law Courts.  
[PT]
Tribunal de Coimbra - Colegio de Sao Tomas
Com origem no sec. XVI, sofreu diferentes obras de remodelacao, sendo as de maior vulto as realizadas no final do sec. XIX, que adaptaram o antigo espaco colegial a residencia dos Condes do Ameal, e durante o sec. XX, com nova adaptacao a Palacio da Justica.]]
zoneTribunal.Visible = false
zoneTribunal.Media = zmediaTribunal
zoneTribunal.Commands = {}
zoneTribunal.DistanceRange = Distance(-1, "feet")
zoneTribunal.ShowObjects = "OnEnter"
zoneTribunal.ProximityRange = Distance(199, "meters")
zoneTribunal.AllowSetPositionTo = false
zoneTribunal.Active = false
zoneTribunal.Points = {
	ZonePoint(40.2140494859831, -8.43186473286323, 0), 
	ZonePoint(40.2145738323736, -8.43231534397773, 0), 
	ZonePoint(40.2147059424454, -8.43198945558242, 0), 
	ZonePoint(40.2142123205505, -8.43146910703354, 0)
}
zoneTribunal.OriginalPoint = ZonePoint(40.214351, -8.431948, 0)
zoneTribunal.DistanceRangeUOM = "Feet"
zoneTribunal.ProximityRangeUOM = "Meters"
zoneTribunal.OutOfRangeName = ""
zoneTribunal.InRangeName = ""
zoneIgrejadeNossaSenhoradoCarmo = Wherigo.Zone(cartCoimbra)
zoneIgrejadeNossaSenhoradoCarmo.Id = "b117404f-65d7-461c-a2c6-a35beb087fee"
zoneIgrejadeNossaSenhoradoCarmo.Name = "Igreja de Nossa Senhora do Carmo"
zoneIgrejadeNossaSenhoradoCarmo.Description = [[[EN]
Church of our Lady of Mount Carmel-Igr. da N Sra. do Carmo
The college was founded in 1542. The church dates from 1597 and the adjoining cloister, which follows a Renaissance style typical of 16th-century Coimbra, is from 1600.
The sacristy has a Deposition of Christ in the Tomb by Joao de Ruao. In the 19th century the college building was given to its present occupants, the Third Order.
[PT]
Colegio fundado em 1542. A Igreja data de 1597 e o claustro anexo, que segue o modelo quinhentista conimbricense da Renascenca de 1600. 
Na sacristia pode ver-se uma Deposicao de Cristo no Tumulo, de Joao de Ruao. No sec. XIX o espaco do colegio foi cedido a Ordem Terceira, que ainda hoje ai permanece]]
zoneIgrejadeNossaSenhoradoCarmo.Visible = false
zoneIgrejadeNossaSenhoradoCarmo.Media = zmediaIgrejadeNossaSenhoradoCarmo
zoneIgrejadeNossaSenhoradoCarmo.Commands = {}
zoneIgrejadeNossaSenhoradoCarmo.DistanceRange = Distance(-1, "feet")
zoneIgrejadeNossaSenhoradoCarmo.ShowObjects = "Always"
zoneIgrejadeNossaSenhoradoCarmo.ProximityRange = Distance(200, "meters")
zoneIgrejadeNossaSenhoradoCarmo.AllowSetPositionTo = false
zoneIgrejadeNossaSenhoradoCarmo.Active = false
zoneIgrejadeNossaSenhoradoCarmo.Points = {
	ZonePoint(40.2128411344939, -8.43079052397729, 0), 
	ZonePoint(40.2125871482239, -8.43057930001737, 0), 
	ZonePoint(40.2127755897412, -8.43020177909852, 0), 
	ZonePoint(40.2130336718386, -8.43043379017831, 0)
}
zoneIgrejadeNossaSenhoradoCarmo.OriginalPoint = ZonePoint(40.212819, -8.430439, 0)
zoneIgrejadeNossaSenhoradoCarmo.DistanceRangeUOM = "Feet"
zoneIgrejadeNossaSenhoradoCarmo.ProximityRangeUOM = "Meters"
zoneIgrejadeNossaSenhoradoCarmo.OutOfRangeName = ""
zoneIgrejadeNossaSenhoradoCarmo.InRangeName = ""
zonePatiodaInquisicao = Wherigo.Zone(cartCoimbra)
zonePatiodaInquisicao.Id = "09588a13-6c41-4e25-98ba-730a36d74e46"
zonePatiodaInquisicao.Name = "Patio da Inquisicao"
zonePatiodaInquisicao.Description = [[[EN]
The Patio of the Inquisition
This owes its name to the group of buildings, of historical and architectural interest, where the Holy Office of the Inquisition functioned from 1566 until it was suppressed in 1821.
Besides these headquarters, the patio housed the early College of Arts. After excavation and alteration work, since 2003 part of the former college buildings have been used by the Visual Arts Centre (CAV). 
[PT]
O Patio da Inquisicao deve o seu nome ao conjunto de edificios de valor historico e arquitectonico, onde funcionou, desde 1566 ate a sua extincao, em 1821, o Tribunal do Santo Oficio.
Para alem do edificio que foi sede da Inquisicao coimbra, o patio congregou o primitivo Colegio das Artes. Apos obras de escavacao e adaptacao, funciona em parte dos antigos edificios colegiais, desde 2003, o Centro de Artes Visuais (CAV).]]
zonePatiodaInquisicao.Visible = false
zonePatiodaInquisicao.Media = zmediaPtiodaInquisio
zonePatiodaInquisicao.Commands = {}
zonePatiodaInquisicao.DistanceRange = Distance(-1, "feet")
zonePatiodaInquisicao.ShowObjects = "OnEnter"
zonePatiodaInquisicao.ProximityRange = Distance(200, "meters")
zonePatiodaInquisicao.AllowSetPositionTo = false
zonePatiodaInquisicao.Active = false
zonePatiodaInquisicao.Points = {
	ZonePoint(40.2123014028559, -8.42936678385968, 0), 
	ZonePoint(40.2126035247873, -8.42879010892148, 0), 
	ZonePoint(40.212059704341, -8.42817051863904, 0), 
	ZonePoint(40.2117944494702, -8.42900334453816, 0)
}
zonePatiodaInquisicao.OriginalPoint = ZonePoint(40.212052, -8.428685, 0)
zonePatiodaInquisicao.DistanceRangeUOM = "Feet"
zonePatiodaInquisicao.ProximityRangeUOM = "Meters"
zonePatiodaInquisicao.OutOfRangeName = ""
zonePatiodaInquisicao.InRangeName = ""
zoneCamaraMunicipaldeCoimbra = Wherigo.Zone(cartCoimbra)
zoneCamaraMunicipaldeCoimbra.Id = "e5832e2e-4740-4608-bcaa-9b13bb7fae14"
zoneCamaraMunicipaldeCoimbra.Name = "Camara Municipal de Coimbra"
zoneCamaraMunicipaldeCoimbra.Description = [[[EN]
City Hall
Left of Santa Cruz church, City Hall has a very controversial history. Formerly installed in a part of Santa Cruz convent, it was not functional, and suffered several transformations, always discussed until the recent version, dating from the 19th century, with a few changes.
[PT]
Situado a esquerda da Igreja de Santa Cruz, o edificio da Camara Municipal tem uma historia muito controversas. Fazendo parte anteriormente do Convento de Santa Cruz, nao era funcional, pelo que sofreu varias transformacoes, sempre muito discutiveis, ate que chegou a versao actual, que data do seculo XIX, com apenas algumas alteracoes.]]
zoneCamaraMunicipaldeCoimbra.Visible = false
zoneCamaraMunicipaldeCoimbra.Media = zmediaCamaraMunicipaldeCoimbra
zoneCamaraMunicipaldeCoimbra.Commands = {}
zoneCamaraMunicipaldeCoimbra.DistanceRange = Distance(-1, "feet")
zoneCamaraMunicipaldeCoimbra.ShowObjects = "OnEnter"
zoneCamaraMunicipaldeCoimbra.ProximityRange = Distance(200, "feet")
zoneCamaraMunicipaldeCoimbra.AllowSetPositionTo = false
zoneCamaraMunicipaldeCoimbra.Active = false
zoneCamaraMunicipaldeCoimbra.Points = {
	ZonePoint(40.2110521725192, -8.4293902939005, 0), 
	ZonePoint(40.211038858395, -8.42878009134961, 0), 
	ZonePoint(40.2115273826249, -8.42890213185979, 0), 
	ZonePoint(40.2114987062475, -8.42943857366276, 0)
}
zoneCamaraMunicipaldeCoimbra.OriginalPoint = ZonePoint(40.211142, -8.429033, 0)
zoneCamaraMunicipaldeCoimbra.DistanceRangeUOM = "Feet"
zoneCamaraMunicipaldeCoimbra.ProximityRangeUOM = "Feet"
zoneCamaraMunicipaldeCoimbra.OutOfRangeName = ""
zoneCamaraMunicipaldeCoimbra.InRangeName = ""
zoneIgrejadeSantaCruz = Wherigo.Zone(cartCoimbra)
zoneIgrejadeSantaCruz.Id = "8178af56-4441-41f5-8721-b81a52426ab0"
zoneIgrejadeSantaCruz.Name = "Igreja de Santa Cruz"
zoneIgrejadeSantaCruz.Description = [[[EN]
Santa Cruz Church The monastery was begun in 1131 under the patronage of Dom Afonso Henriques, and given to the order of Augustinian Canons. Among famous scholars of the monastery school was St Anthony of Lisbon, who joined the Franciscan order at Coimbra. The Romanesque church was designed by the French master builder Robert.
[PT]
Iniciado em 1131, sob o patrocinio de D. Afonso Henriques, e entregue a ordem dos Conegos Regrantes de St.? Agostinho. De entre os notaveis que frequentaram a escola do Mosteiro, destaca-se St.? Antonio, que em Coimbra tomou as ordens de S. Francisco. A igreja romanica teve plano do arquitecto frances Roberto.]]
zoneIgrejadeSantaCruz.Visible = false
zoneIgrejadeSantaCruz.Media = zmediaIgrejadeSantaCruz
zoneIgrejadeSantaCruz.Commands = {}
zoneIgrejadeSantaCruz.DistanceRange = Distance(1500, "feet")
zoneIgrejadeSantaCruz.ShowObjects = "OnEnter"
zoneIgrejadeSantaCruz.ProximityRange = Distance(200, "feet")
zoneIgrejadeSantaCruz.AllowSetPositionTo = false
zoneIgrejadeSantaCruz.Active = false
zoneIgrejadeSantaCruz.Points = {
	ZonePoint(40.2110366731221, -8.42878143861435, 0), 
	ZonePoint(40.2110530597368, -8.42948551848076, 0), 
	ZonePoint(40.2107345442058, -8.42940505221031, 0), 
	ZonePoint(40.2108297917723, -8.42877070977829, 0)
}
zoneIgrejadeSantaCruz.OriginalPoint = ZonePoint(40.210899, -8.429004, 0)
zoneIgrejadeSantaCruz.DistanceRangeUOM = "Feet"
zoneIgrejadeSantaCruz.ProximityRangeUOM = "Feet"
zoneIgrejadeSantaCruz.OutOfRangeName = ""
zoneIgrejadeSantaCruz.InRangeName = ""
zoneCafedeSantaCruz = Wherigo.Zone(cartCoimbra)
zoneCafedeSantaCruz.Id = "26412a61-66be-4582-be8f-be95edce7a1f"
zoneCafedeSantaCruz.Name = "Cafe de Santa Cruz"
zoneCafedeSantaCruz.Description = [[[EN]
Santa Cruz Cafe
Santa Cruz Cafe was opened in 1923 on May 8, as the cafe is built on Square 8 May. It is located in one of the most beautiful churches of Coimbra Santa Cruz, in its auxiliary chapel, that dates back to 1530, and this makes it a unique and must visit cafe in Coimbra. It is also the most famous cafe not only in Coimbra, but in all of northern Portugal. The architecture of the cafe is amazing due to its location. The ceilings are high and there are marble decorations and vaulted stone supporters. It is always crowded there during the day and night.
[PT]
Apos a passagem por Coimbra de D. Joao III em 1527, a reforma do Mosteiro de Santa Cruz e a instalacao da Universidade vao alterar profundamente a cidade.
Para Santa Cruz foi nomeado reformador Frei Bras de Braga que partira em 1517 para estudar em Paris tendo regressado em 1525 a Portugal para ocupar o cargo de Prior do Mosteiro da Serra de Sintra. Entre outras, a missao de Frei Bras passava pela reestruturacao das dependencias conventuais modernizando e construindo edificios.
Extinto o pequeno convento de S. Joao das Donas, restaurada a Igreja de Santa Cruz a dignidade do panteao dos primeiros monarcas, seria de toda a conveniencia reservar esta para o uso quotidiano e exclusivo dos frades cruzios. Para que tal sucedesse era necessario construir de raiz uma igreja paroquial que servisse a freguesia de S. Joao da Cruz. Foi entao que Frei Bras de Braga a mandou erguer em cerca de 1530.]]
zoneCafedeSantaCruz.Visible = false
zoneCafedeSantaCruz.Media = zmediaCafedeSantaCruz
zoneCafedeSantaCruz.Commands = {}
zoneCafedeSantaCruz.DistanceRange = Distance(-1, "feet")
zoneCafedeSantaCruz.ShowObjects = "OnEnter"
zoneCafedeSantaCruz.ProximityRange = Distance(200, "meters")
zoneCafedeSantaCruz.AllowSetPositionTo = false
zoneCafedeSantaCruz.Active = false
zoneCafedeSantaCruz.Points = {
	ZonePoint(40.2108374583662, -8.42878065641401, 0), 
	ZonePoint(40.2107125099326, -8.4293734246063, 0), 
	ZonePoint(40.2103796052392, -8.4293298387098, 0), 
	ZonePoint(40.2105261110212, -8.42869214351651, 0)
}
zoneCafedeSantaCruz.OriginalPoint = ZonePoint(40.210743, -8.428899, 0)
zoneCafedeSantaCruz.DistanceRangeUOM = "Feet"
zoneCafedeSantaCruz.ProximityRangeUOM = "Meters"
zoneCafedeSantaCruz.OutOfRangeName = ""
zoneCafedeSantaCruz.InRangeName = ""
zoneJardimdaManga = Wherigo.Zone(cartCoimbra)
zoneJardimdaManga.Id = "cd5cb031-e492-496f-b8c7-3a11d518d9ce"
zoneJardimdaManga.Name = "Jardim da Manga"
zoneJardimdaManga.Description = [[[EN]
This was formerly the centre of one of three cloisters in the Santa Cruz Monastery. Legend has it that its name derives from the fact that King John III sketched its design on the sleeve (manga) of his doublet.
Joao de Ruao drafted the plan and made the bas-reliefs for the interior of the four cubicles or chapels. This is one of the earliest complete examples of Renaissance architecture in Portugal, its structure symbolising the Source of Life.
[PT]
O Jardim da Manga, tambem conhecido como Claustro da Manga, localiza-se na freguesia de Santa Cruz, na cidade, Concelho e Distrito de Coimbra, em Portugal. Este logradouro publico situa-se nas traseiras do Mosteiro de Santa Cruz, na baixa da cidade.
E uma das primeiras obras arquitectonicas inteiramente renascentistas feitas em Portugal e a sua estrutura e evocativa da Fonte da Vida.]]
zoneJardimdaManga.Visible = false
zoneJardimdaManga.Media = zmediaJardimdaManga
zoneJardimdaManga.Commands = {}
zoneJardimdaManga.DistanceRange = Distance(-1, "feet")
zoneJardimdaManga.ShowObjects = "OnEnter"
zoneJardimdaManga.ProximityRange = Distance(200, "meters")
zoneJardimdaManga.AllowSetPositionTo = false
zoneJardimdaManga.Active = false
zoneJardimdaManga.Points = {
	ZonePoint(40.2114508905837, -8.42757984875061, 0), 
	ZonePoint(40.2114109484382, -8.42816054700234, 0), 
	ZonePoint(40.2107104208282, -8.42803716538765, 0), 
	ZonePoint(40.2108394659319, -8.42733710883476, 0)
}
zoneJardimdaManga.OriginalPoint = ZonePoint(40.211066, -8.427791, 0)
zoneJardimdaManga.DistanceRangeUOM = "Feet"
zoneJardimdaManga.ProximityRangeUOM = "Meters"
zoneJardimdaManga.OutOfRangeName = ""
zoneJardimdaManga.InRangeName = ""
zoneMercadoMunicipal = Wherigo.Zone(cartCoimbra)
zoneMercadoMunicipal.Id = "13de1258-4aa6-4662-a1b8-9d417e392033"
zoneMercadoMunicipal.Name = "Mercado Municipal"
zoneMercadoMunicipal.Description = [[[EN]
Mercado Municipal Dom Pedro V
This modern market is a colourful stop for self-caterers. It's full of lively fruit and vegetable stalls and butcher shops displaying Portuguese cuts of meat, hooves, claws and all. 
[PT]
Mercado Municipal Dom Pedro V
Trata-se de um mercado recente, recheio de cores, em que e possivel adquirir frutas, legumes, onde se encontram ainda varias lojas que vendem produtos Portugueses
]]
zoneMercadoMunicipal.Visible = false
zoneMercadoMunicipal.Media = zmediaMercado
zoneMercadoMunicipal.Commands = {}
zoneMercadoMunicipal.DistanceRange = Distance(-1, "feet")
zoneMercadoMunicipal.ShowObjects = "OnEnter"
zoneMercadoMunicipal.ProximityRange = Distance(200, "feet")
zoneMercadoMunicipal.AllowSetPositionTo = false
zoneMercadoMunicipal.Active = false
zoneMercadoMunicipal.Points = {
	ZonePoint(40.2113756887972, -8.42588664285279, 0), 
	ZonePoint(40.211212847414, -8.4269327043686, 0), 
	ZonePoint(40.2109178884407, -8.4267181276474, 0), 
	ZonePoint(40.2110592231089, -8.42591346494294, 0)
}
zoneMercadoMunicipal.OriginalPoint = ZonePoint(40.211083, -8.42649, 0)
zoneMercadoMunicipal.DistanceRangeUOM = "Feet"
zoneMercadoMunicipal.ProximityRangeUOM = "Feet"
zoneMercadoMunicipal.OutOfRangeName = ""
zoneMercadoMunicipal.InRangeName = ""
zoneFaculdadedePsicologia = Wherigo.Zone(cartCoimbra)
zoneFaculdadedePsicologia.Id = "79b4f5f9-11b5-48b5-a604-d54679be8047"
zoneFaculdadedePsicologia.Name = "Faculdade de Psicologia"
zoneFaculdadedePsicologia.Description = [[[EN]
Faculty of Psychology and Education Sciences,  which offers all levels of academic degrees in Psychology, Social Service and Education Sciences.
[PT]
A Faculdade de Psicologia e de Ciencias da Educacao foi criada em 5 de Novembro de 1980, sendo pois uma das mais jovens Faculdades da Universidade de Coimbra. Encontra-se actualmente instalada no Colegio de S.to Agostinho, bem como no edificio da Farmacia dos Ex- HUC enquanto aguarda pela construcao de instalacoes proprias e definitivas no Polo II da UC.
Acolhe neste ano cerca de 1800 alunos distribuidos por um Mestrado Integrado (Psicologia), duas licenciaturas (Ciencias da Educacao e Servico Social), diversos cursos de Pos-Graduacao, Mestrado e Doutoramento.]]
zoneFaculdadedePsicologia.Visible = false
zoneFaculdadedePsicologia.Media = zmediaFaculdadedePsicologia
zoneFaculdadedePsicologia.Commands = {}
zoneFaculdadedePsicologia.DistanceRange = Distance(-1, "feet")
zoneFaculdadedePsicologia.ShowObjects = "OnEnter"
zoneFaculdadedePsicologia.ProximityRange = Distance(200, "feet")
zoneFaculdadedePsicologia.AllowSetPositionTo = false
zoneFaculdadedePsicologia.Active = false
zoneFaculdadedePsicologia.Points = {
	ZonePoint(40.2107053563704, -8.42752469386573, 0), 
	ZonePoint(40.2106408337216, -8.42702714409347, 0), 
	ZonePoint(40.2100029361321, -8.42743003554722, 0), 
	ZonePoint(40.2100949491705, -8.42786935772415, 0)
}
zoneFaculdadedePsicologia.OriginalPoint = ZonePoint(40.21015, -8.427676, 0)
zoneFaculdadedePsicologia.DistanceRangeUOM = "Feet"
zoneFaculdadedePsicologia.ProximityRangeUOM = "Feet"
zoneFaculdadedePsicologia.OutOfRangeName = ""
zoneFaculdadedePsicologia.InRangeName = ""
zoneVistaPanormica = Wherigo.Zone(cartCoimbra)
zoneVistaPanormica.Id = "e5d3bf26-a417-4129-b880-2c9fb1faa767"
zoneVistaPanormica.Name = "Panoramic view / Vista Panoramica"
zoneVistaPanormica.Description = [[[EN]
A place where you can have a great view in Coimbra.
[PT]
Um local com uma excelente vista para a cidade de Coimbra.]]
zoneVistaPanormica.Visible = false
zoneVistaPanormica.Media = zmediaMiradouro
zoneVistaPanormica.Commands = {}
zoneVistaPanormica.DistanceRange = Distance(-1, "feet")
zoneVistaPanormica.ShowObjects = "OnEnter"
zoneVistaPanormica.ProximityRange = Distance(200, "feet")
zoneVistaPanormica.AllowSetPositionTo = false
zoneVistaPanormica.Active = false
zoneVistaPanormica.Points = {
	ZonePoint(40.2107319184005, -8.42534951289747, 0), 
	ZonePoint(40.2108799241877, -8.42499233250624, 0), 
	ZonePoint(40.2105106796089, -8.42479799751857, 0), 
	ZonePoint(40.2104404861391, -8.42526767609218, 0)
}
zoneVistaPanormica.OriginalPoint = ZonePoint(40.210608, -8.425162, 0)
zoneVistaPanormica.DistanceRangeUOM = "Feet"
zoneVistaPanormica.ProximityRangeUOM = "Feet"
zoneVistaPanormica.OutOfRangeName = ""
zoneVistaPanormica.InRangeName = ""
zoneLabQuimico = Wherigo.Zone(cartCoimbra)
zoneLabQuimico.Id = "254aa509-8854-46cf-9094-bbb954f40a12"
zoneLabQuimico.Name = "Chemical Lab / Laboratorio Quimico"
zoneLabQuimico.Description = [[[EN]
A Laboratory, in the University of Coimbra, where chemical experiments take place.
[PT]
O Laboratorio Chimico e o mais importante edificio neoclassico portugues. Foi construido para o ensino da Quimica, entre 1773 e 1777, durante a reforma da Universidade de Coimbra iniciada pelo Marques de Pombal.
Esta construcao materializa a ideologia iluminista do ensino pratico da ciencia em que o trabalho laboratorial se tornou central na formacao de medicos, farmaceuticos e estudantes da recem criada Faculdade de Filosofia. Foi desenhado pela Casa do Risco, sob orientacao do engenheiro militar tenente-coronel Guilherme Elsden, que se salientou como director das Obras da Universidade de Coimbra.]]
zoneLabQuimico.Visible = false
zoneLabQuimico.Media = zmediaLaboratorioQuimico
zoneLabQuimico.Commands = {}
zoneLabQuimico.DistanceRange = Distance(-1, "feet")
zoneLabQuimico.ShowObjects = "OnEnter"
zoneLabQuimico.ProximityRange = Distance(200, "feet")
zoneLabQuimico.AllowSetPositionTo = false
zoneLabQuimico.Active = false
zoneLabQuimico.Points = {
	ZonePoint(40.2104349871604, -8.4243486675806, 0), 
	ZonePoint(40.2105477797585, -8.42361659507174, 0), 
	ZonePoint(40.2098282020091, -8.42330750793462, 0), 
	ZonePoint(40.209691433754, -8.4241676184721, 0)
}
zoneLabQuimico.OriginalPoint = ZonePoint(40.210175, -8.423791, 0)
zoneLabQuimico.DistanceRangeUOM = "Feet"
zoneLabQuimico.ProximityRangeUOM = "Feet"
zoneLabQuimico.OutOfRangeName = ""
zoneLabQuimico.InRangeName = ""
zoneDomDinis = Wherigo.Zone(cartCoimbra)
zoneDomDinis.Id = "1123689e-aa1e-4655-b2d4-8ccad34616de"
zoneDomDinis.Name = "Dom Dinis"
zoneDomDinis.Description = [[[EN]
In the higher part of the city. The older part is situated in the former royal palace that was restored in 1540, given by king D.Joao III when it was established in Coimbra in 1537. The entrance is through the Porta Ferrea, dating back to the 17th century. It is a two sided gate with a statue of king D.Dinis and the king who gave the University to Coimbra, D.Joao III.
[PT]
Trata-se uma praca situada na parte mais alta da cidade. No centro encontra-se a estatua de D. Dinis, sendo este o rei que criou a Universidade de Coimbra, em 1290.]]
zoneDomDinis.Visible = false
zoneDomDinis.Media = zmediaDomDinis
zoneDomDinis.Commands = {}
zoneDomDinis.DistanceRange = Distance(1500, "feet")
zoneDomDinis.ShowObjects = "OnEnter"
zoneDomDinis.ProximityRange = Distance(200, "feet")
zoneDomDinis.AllowSetPositionTo = false
zoneDomDinis.Active = true
zoneDomDinis.Points = {
	ZonePoint(40.2077790945802, -8.42323772883606, 0), 
	ZonePoint(40.2078503610184, -8.42265560367014, 0), 
	ZonePoint(40.2082681059259, -8.42275404662701, 0), 
	ZonePoint(40.2082102996631, -8.42332259755324, 0)
}
zoneDomDinis.OriginalPoint = ZonePoint(40.208032, -8.423125, 0)
zoneDomDinis.DistanceRangeUOM = "Feet"
zoneDomDinis.ProximityRangeUOM = "Feet"
zoneDomDinis.OutOfRangeName = ""
zoneDomDinis.InRangeName = ""
zoneEscadasMonumentais = Wherigo.Zone(cartCoimbra)
zoneEscadasMonumentais.Id = "9191a629-32a8-45d9-848c-360703c170f5"
zoneEscadasMonumentais.Name = "Monumental Stairs / Escadas Monumentais"
zoneEscadasMonumentais.Description = [[[EN]
The Monumental Stairs give access to the University, there are 125 steps in 5 installments of 25 steps each.
[PT]
As 'Escadas Monumentais e um monumento na cidade portuguesa de Coimbra. Sao o resultado de uma intervencao urbanistica realizada durante o periodo do Estado Novo e que abrangeu uma vasta area - conhecida como a Alta Universitaria. Ligam a Praca D. Dinis a Rua de Oliveira Matos e a Praca da Republica.]]
zoneEscadasMonumentais.Visible = false
zoneEscadasMonumentais.Media = zmediaEscadasMonumentais
zoneEscadasMonumentais.Commands = {}
zoneEscadasMonumentais.DistanceRange = Distance(-1, "feet")
zoneEscadasMonumentais.ShowObjects = "OnEnter"
zoneEscadasMonumentais.ProximityRange = Distance(200, "feet")
zoneEscadasMonumentais.AllowSetPositionTo = false
zoneEscadasMonumentais.Active = false
zoneEscadasMonumentais.Points = {
	ZonePoint(40.2082468638842, -8.42251551289746, 0), 
	ZonePoint(40.208236, -8.42165599999998, 0), 
	ZonePoint(40.208114, -8.421651, 0), 
	ZonePoint(40.2078612716096, -8.4224684282417, 0)
}
zoneEscadasMonumentais.OriginalPoint = ZonePoint(40.208019, -8.422337, 0)
zoneEscadasMonumentais.DistanceRangeUOM = "Feet"
zoneEscadasMonumentais.ProximityRangeUOM = "Feet"
zoneEscadasMonumentais.OutOfRangeName = ""
zoneEscadasMonumentais.InRangeName = ""
zoneArcosdeJardim = Wherigo.Zone(cartCoimbra)
zoneArcosdeJardim.Id = "09784cf6-a45a-40d0-b02e-9825c0500867"
zoneArcosdeJardim.Name = "Aqueduct / Arcos de Jardim"
zoneArcosdeJardim.Description = [[[EN]
St Sebastian Aqueduct
Dating from the 17th century, it followed the structure, and probably made use of the remains, of a former aqueduct from Roman times. 
The ceremonial ashlar arch is crowned with a graceful small shrine with 2 statues, of St Sebastian and St Roque.
[PT]
Aqueduto de Sao Sebastiao
Obra do final do seculo XVI, tendo-se aproveitado o tracado, e provavelmente os restos de um anterior aqueduto que remontava ao periodo romano.
O arco de honra e de cantaria e no topo encontra-se um gracioso templete com duas esculturas: do martir Sao Sebastiao, do lado de cima, e de Sao Roque, do lado de baixo]]
zoneArcosdeJardim.Visible = false
zoneArcosdeJardim.Media = zmediaArcosdeJardim
zoneArcosdeJardim.Commands = {}
zoneArcosdeJardim.DistanceRange = Distance(-1, "feet")
zoneArcosdeJardim.ShowObjects = "OnEnter"
zoneArcosdeJardim.ProximityRange = Distance(200, "feet")
zoneArcosdeJardim.AllowSetPositionTo = false
zoneArcosdeJardim.Active = false
zoneArcosdeJardim.Points = {
	ZonePoint(40.2077742276462, -8.42226162698364, 0), 
	ZonePoint(40.207400761007, -8.42155190426445, 0), 
	ZonePoint(40.2069699788655, -8.42186023925206, 0), 
	ZonePoint(40.2075140968672, -8.42253940492822, 0)
}
zoneArcosdeJardim.OriginalPoint = ZonePoint(40.207348, -8.422059, 0)
zoneArcosdeJardim.DistanceRangeUOM = "Feet"
zoneArcosdeJardim.ProximityRangeUOM = "Feet"
zoneArcosdeJardim.OutOfRangeName = ""
zoneArcosdeJardim.InRangeName = ""
zoneJardimBotanico = Wherigo.Zone(cartCoimbra)
zoneJardimBotanico.Id = "f608ea25-777a-4eee-a72d-e6cdcabe15b2"
zoneJardimBotanico.Name = "Botanical Garden / Jardim Botanico"
zoneJardimBotanico.Description = [[Lovely botanical
A serene place to catch your breath, the lovely botanical garden sits in the shadow of the 16th-century Aqueduto de Sao Sebastiao. Founded by the Marques de Pombal, the gardens combine formal flowerbeds, meandering paths and elegant fountains. The green-fingered can also visit the lush greenhouses and the adjacent Museu Botanico.]]
zoneJardimBotanico.Visible = false
zoneJardimBotanico.Media = _T9B9
zoneJardimBotanico.Commands = {}
zoneJardimBotanico.DistanceRange = Distance(-1, "feet")
zoneJardimBotanico.ShowObjects = "OnEnter"
zoneJardimBotanico.ProximityRange = Distance(200, "feet")
zoneJardimBotanico.AllowSetPositionTo = false
zoneJardimBotanico.Active = false
zoneJardimBotanico.Points = {
	ZonePoint(40.2067759515442, -8.42398086623575, 0), 
	ZonePoint(40.2069982462299, -8.42402005274391, 0), 
	ZonePoint(40.2069371009887, -8.42463506382364, 0), 
	ZonePoint(40.206669, -8.42443600000001, 0)
}
zoneJardimBotanico.OriginalPoint = ZonePoint(40.206733, -8.424287, 0)
zoneJardimBotanico.DistanceRangeUOM = "Feet"
zoneJardimBotanico.ProximityRangeUOM = "Feet"
zoneJardimBotanico.OutOfRangeName = ""
zoneJardimBotanico.InRangeName = ""
zoneUniversidadeFaculdadedeLetras = Wherigo.Zone(cartCoimbra)
zoneUniversidadeFaculdadedeLetras.Id = "0660f3be-f453-4782-b55e-7deef7ca9833"
zoneUniversidadeFaculdadedeLetras.Name = "University / Universidade"
zoneUniversidadeFaculdadedeLetras.Description = [[[EN]
University of Coimbra
The University of Coimbra is one of the oldest in Europe. Founded in Lisbon by King Dinis in 1290, it was finally transferred to Coimbra in 1537, occupying the buildings of the medieval royal Palace. During the reigns of Joao V and Jose I the university was extensively restructured, not only in its teaching but also by the construction of new buildings in Baroque or neo-classical style.
[PT]
A Universidade de Coimbra e uma das mais antigas da Europa. Fundada em Lisboa por D. Dinis em 1290, foi definitivamente transferida para Coimbra em 1537, vindo a ocupar os edificios do Paco Real Medieval. Durante os reinados de D. Joao V e D. Jose I, a instituicao sofreu grandes reformas, nao so a nivel do ensino, mas tambem no que respeita a construcao de novos edificios de estilo barroco e neo-classico.]]
zoneUniversidadeFaculdadedeLetras.Visible = false
zoneUniversidadeFaculdadedeLetras.Media = zmediaFaculdadedeLetras
zoneUniversidadeFaculdadedeLetras.Commands = {}
zoneUniversidadeFaculdadedeLetras.DistanceRange = Distance(-1, "feet")
zoneUniversidadeFaculdadedeLetras.ShowObjects = "OnEnter"
zoneUniversidadeFaculdadedeLetras.ProximityRange = Distance(200, "feet")
zoneUniversidadeFaculdadedeLetras.AllowSetPositionTo = false
zoneUniversidadeFaculdadedeLetras.Active = false
zoneUniversidadeFaculdadedeLetras.Points = {
	ZonePoint(40.2076828934219, -8.424778099371, 0), 
	ZonePoint(40.2081471302935, -8.42488702331354, 0), 
	ZonePoint(40.2081099776717, -8.42570237549785, 0), 
	ZonePoint(40.207631038636, -8.42554038161472, 0)
}
zoneUniversidadeFaculdadedeLetras.OriginalPoint = ZonePoint(40.207958, -8.425361, 0)
zoneUniversidadeFaculdadedeLetras.DistanceRangeUOM = "Feet"
zoneUniversidadeFaculdadedeLetras.ProximityRangeUOM = "Feet"
zoneUniversidadeFaculdadedeLetras.OutOfRangeName = ""
zoneUniversidadeFaculdadedeLetras.InRangeName = ""
zoneSeNova = Wherigo.Zone(cartCoimbra)
zoneSeNova.Id = "cbb4a5d5-a7d7-4d7f-a312-38b421adf221"
zoneSeNova.Name = "New Cathedral / Se Nova"
zoneSeNova.Description = [[[]EN]
New Cathedral
The church belonged to the Jesuits until they were expelled from Portugal in 1759. Work commenced in 1598, but the church was only consecrated in 1640.
The facade shows 2 distinct phases of style and construction. The interior is in the shape of a Latin cross; it has semi-circular vaulting, with a cupola over the transept and pulpits near the centre of the church, typical of Counter-Reformation style.
[PT]
Se Nova
O templo pertenceu ao colegio da Companhia de Jesus ate a sua expulsao de Portugal, em 1759. As obras iniciaram-se em 1598, mas a Igreja so foi sagrada em 1640.
A fachada divide-se em duas fases distintas de construcao e concepcao. O interior do templo e em plano de cruz latina, com abobadas de berco e uma cupula no cruzeiro, com pulpitos quase no centro da igreja, numa concepcao artistica da contra-reforma.]]
zoneSeNova.Visible = false
zoneSeNova.Media = zmediaSeNova
zoneSeNova.Commands = {}
zoneSeNova.DistanceRange = Distance(-1, "feet")
zoneSeNova.ShowObjects = "OnEnter"
zoneSeNova.ProximityRange = Distance(200, "meters")
zoneSeNova.AllowSetPositionTo = false
zoneSeNova.Active = false
zoneSeNova.Points = {
	ZonePoint(40.2094138301088, -8.42491842824177, 0), 
	ZonePoint(40.2094951686075, -8.42412205274388, 0), 
	ZonePoint(40.2087839028369, -8.42398918402671, 0), 
	ZonePoint(40.2087111688608, -8.42478507853889, 0)
}
zoneSeNova.OriginalPoint = ZonePoint(40.209232, -8.424482, 0)
zoneSeNova.DistanceRangeUOM = "Feet"
zoneSeNova.ProximityRangeUOM = "Meters"
zoneSeNova.OutOfRangeName = ""
zoneSeNova.InRangeName = ""
zoneMuseuMachadodeCastroIgreja = Wherigo.Zone(cartCoimbra)
zoneMuseuMachadodeCastroIgreja.Id = "33079d96-5b7b-4197-a868-9773a12c40c4"
zoneMuseuMachadodeCastroIgreja.Name = "Museu Machado de Castro "
zoneMuseuMachadodeCastroIgreja.Description = [[[EN]
Museu Nacional de Machado de Castro
On the west side of the Largo da Feira, in the former Bishop's Palace (rebuilt in the late 16th C.) and in the church of Sao Joao, is the Museu Nacional de Machado de Castro, named after the Coimbra-born sculptor Machado de Castro (1736-1828) and containing Roman material from excavations, medieval sarcophaguses, Romanesque and Gothic sculpture in stone and wood, goldsmiths' work, furniture, tapestries, porcelain, paintings of the 16th-18th C. (including some notable Flemish pictures), a special section devoted to work by modern Portuguese painters and a department of religious art.
From the double loggia in the beautiful courtyard there is a very fine view of the town.
Hobbies & Activities category: Archeological exhibit, museum;  Architecture - Romanesque;  Fabrics, textiles, costumes exhibits;  Furniture display;  Paintings, art collections;  Gold, silver, metalworking exhibit;  Architecture - Gothic;  Historical museum;  Architecture - Medieval;  Scenic site or route
[PT]
As coleccoes espelham a riqueza da Igreja e a importancia do mecenato regio as quais se devem muitas das suas obras de arte e alfaias religiosas de maior valia. 
A escultura monocromatica ou policroma em madeira e pedra, ocupa lugar cimeiro, ilustrando com numerosas obras-primas o trabalho das melhores oficinas flamengas e tambem a evolucao das escolas portuguesas da Idade Media ao seculo XVIII. 
Nao obstante, os nucleos de pintura, ourivesaria, ceramica e texteis impoem-se com igual importancia e representatividade para a arte importada e a producao nacional. 
Distinguem-se ainda as coleccoes arqueologicas provenientes da cidade e as de arte oriental.]]
zoneMuseuMachadodeCastroIgreja.Visible = false
zoneMuseuMachadodeCastroIgreja.Media = zmediaIgrejadoMuseuMachadodeCastro
zoneMuseuMachadodeCastroIgreja.Commands = {}
zoneMuseuMachadodeCastroIgreja.DistanceRange = Distance(-1, "feet")
zoneMuseuMachadodeCastroIgreja.ShowObjects = "OnEnter"
zoneMuseuMachadodeCastroIgreja.ProximityRange = Distance(200, "feet")
zoneMuseuMachadodeCastroIgreja.AllowSetPositionTo = false
zoneMuseuMachadodeCastroIgreja.Active = false
zoneMuseuMachadodeCastroIgreja.Points = {
	ZonePoint(40.209028427466, -8.42533904051015, 0), 
	ZonePoint(40.2091266370634, -8.42492433250618, 0), 
	ZonePoint(40.2086386200947, -8.42481734722139, 0), 
	ZonePoint(40.2086209830067, -8.42523485400193, 0)
}
zoneMuseuMachadodeCastroIgreja.OriginalPoint = ZonePoint(40.20898, -8.425088, 0)
zoneMuseuMachadodeCastroIgreja.DistanceRangeUOM = "Feet"
zoneMuseuMachadodeCastroIgreja.ProximityRangeUOM = "Feet"
zoneMuseuMachadodeCastroIgreja.OutOfRangeName = ""
zoneMuseuMachadodeCastroIgreja.InRangeName = ""
zoneSVelha = Wherigo.Zone(cartCoimbra)
zoneSVelha.Id = "6e7961f2-a772-4988-a782-90e67275bfea"
zoneSVelha.Name = "Old Cathedral / Se Velha"
zoneSVelha.Description = [[[EN]
Old Cathedral
The present church, in the second phase of Coimbra Romanesque style, dates from the 2nd half of the 12th century and was consecrated in 1184. Designed by the French master Robert, its exterior is sturdy and symmetrical, with narrow window-slits and crenellated roof.
The main doorway shows obvious Islamic influence, while the side door, known as the Porta Especiosa (Beautiful Door), attributed to Joao de Ruao, has elegant Renaissance decoration. Inside, there is a triforium gallery above the side aisles. The high altar retable, flamboyantly Gothic in style, dates from around 1498 and is the work of the Flemish sculptors Olivier de Gand and Jean d Ypres. The Mannerist-style altarpiece in the Holy Sacrament chapel, surrounded by an elegant panelled cupola, is by Joao de Ruao and dates from 1566. The Gothic cloisters, with their naturalistic capitals, were begun in 1218.
[PT]
O templo actual data da segunda metade do seculo XII, tendo sido aberto ao culto em 1184 e segue o estilo romanico coimbrao da segunda fase. Com projecto do frances Mestre Roberto, a igreja tem um exterior robusto, simetrico, com escassas aberturas e coroamento de ameias.
O portal central tem decoracao de clara influencia islamica, enquanto que a porta lateral, chamada "Porta Especiosa", atribuida a Joao de Ruao, revela elegante decoracao renascentista. 
No interior, ao longo das naves laterais distribui-se a galeria do triforio. Destaque especial para o retabulo da capela-mor, em gotico flamejante, datado de cerca de 1498 e executado pelos escultores flamengos Olivier de Gand e Jean d'Ypres. O retabulo da Capela do Santissimo Sacramento, completado com uma elegante cupula de cartelas, em estilo maneirista, data de 1566 e foi executado por Joao de Ruao. O claustro, gotico, iniciou-se em 1218, nele se destacando os capiteis naturalistas.]]
zoneSVelha.Visible = false
zoneSVelha.Media = zmediaSeVelha
zoneSVelha.Commands = {}
zoneSVelha.DistanceRange = Distance(-1, "feet")
zoneSVelha.ShowObjects = "OnEnter"
zoneSVelha.ProximityRange = Distance(200, "feet")
zoneSVelha.AllowSetPositionTo = false
zoneSVelha.Active = false
zoneSVelha.Points = {
	ZonePoint(40.2091047338772, -8.42672903802873, 0), 
	ZonePoint(40.2086303060451, -8.4266395717583, 0), 
	ZonePoint(40.2086204348819, -8.42742565889546, 0), 
	ZonePoint(40.2090542419357, -8.42765490922739, 0)
}
zoneSVelha.OriginalPoint = ZonePoint(40.208828, -8.427241, 0)
zoneSVelha.DistanceRangeUOM = "Feet"
zoneSVelha.ProximityRangeUOM = "Feet"
zoneSVelha.OutOfRangeName = ""
zoneSVelha.InRangeName = ""
zoneQuebracostas = Wherigo.Zone(cartCoimbra)
zoneQuebracostas.Id = "def245fb-f0e0-4372-b68d-d1094981e115"
zoneQuebracostas.Name = "Quebra costas"
zoneQuebracostas.Description = [[[EN]
Quebra-Costas (Back-Breaker Street). Up a narrow stone stairway looms the 12th-century Romanesque Se Velha (Old Cathedral)
[PT]
Quebra-Costas. Trata-se de uma escadaria antiga que nos leva da baixa da Cidade de Coimbra ate a Se Velha.]]
zoneQuebracostas.Visible = false
zoneQuebracostas.Media = zmediaQuebraCostas
zoneQuebracostas.Commands = {}
zoneQuebracostas.DistanceRange = Distance(-1, "feet")
zoneQuebracostas.ShowObjects = "OnEnter"
zoneQuebracostas.ProximityRange = Distance(200, "feet")
zoneQuebracostas.AllowSetPositionTo = false
zoneQuebracostas.Active = false
zoneQuebracostas.Points = {
	ZonePoint(40.2090235808942, -8.42825699694163, 0), 
	ZonePoint(40.208695838036, -8.42798341162211, 0), 
	ZonePoint(40.2085688372524, -8.42848766691691, 0), 
	ZonePoint(40.2089293549847, -8.42863250620371, 0)
}
zoneQuebracostas.OriginalPoint = ZonePoint(40.208874, -8.428191, 0)
zoneQuebracostas.DistanceRangeUOM = "Feet"
zoneQuebracostas.ProximityRangeUOM = "Feet"
zoneQuebracostas.OutOfRangeName = ""
zoneQuebracostas.InRangeName = ""
zoneGovernoCivil1 = Wherigo.Zone(cartCoimbra)
zoneGovernoCivil1.Id = "72550f6f-3b2f-4b59-8943-5a92d86282a1"
zoneGovernoCivil1.Name = "Governo Civil"
zoneGovernoCivil1.Description = [[[EN]
This building is also known, according to historical records, as the House Doctor Angelo da Fonseca. Initially it was a single-family residence, later the residence of the Governor and now as the Civil Government of the District of Coimbra. Although the building is new, it deserves special mention for its historical importance, since it was built on the basis of the old tower Belcouce, which was part of the wall of Coimbra.
[PT]
Este edificio e tambem conhecido, de acordo com registros historicos, como a casa Doutor Angelo da Fonseca. Inicialmente era uma residencia unifamiliar, mais tarde residencia do governador e, agora, como o Governo Civil do Distrito de Coimbra. Embora o predio seja novo, merece uma mencao especial pela sua importancia historica, pois foi construido sobre a base da antiga torre Belcouce, que fazia parte da muralha de Coimbra.]]
zoneGovernoCivil1.Visible = false
zoneGovernoCivil1.Media = zmediaCouraadeLisboa
zoneGovernoCivil1.Commands = {}
zoneGovernoCivil1.DistanceRange = Distance(-1, "feet")
zoneGovernoCivil1.ShowObjects = "OnEnter"
zoneGovernoCivil1.ProximityRange = Distance(200, "feet")
zoneGovernoCivil1.AllowSetPositionTo = false
zoneGovernoCivil1.Active = false
zoneGovernoCivil1.Points = {
	ZonePoint(40.2071091801222, -8.42838298280333, 0), 
	ZonePoint(40.2069240660854, -8.42862415401942, 0), 
	ZonePoint(40.2066526457367, -8.42834922759539, 0), 
	ZonePoint(40.20685544293, -8.4280085870505, 0)
}
zoneGovernoCivil1.OriginalPoint = ZonePoint(40.206877, -8.428483, 0)
zoneGovernoCivil1.DistanceRangeUOM = "Feet"
zoneGovernoCivil1.ProximityRangeUOM = "Feet"
zoneGovernoCivil1.OutOfRangeName = ""
zoneGovernoCivil1.InRangeName = ""
zonePortagem = Wherigo.Zone(cartCoimbra)
zonePortagem.Id = "258597c9-9a61-4064-bf54-a236e21c8c7e"
zonePortagem.Name = "Portagem"
zonePortagem.Description = [[[EN]
Largo da Portagem  (tax square) is known by this name since old times. It was here, at the end of the bridge, that a tax to enter or pass by the city was payed. The statue of Joaquim Antonio de Aguiar, surnamed by the inhabitants of Coimbra monk s killer, stands up in the center of the square.
[PT]
 Largo da Portagem e um espaco publico situado na cidade de Coimbra, em Portugal, junto a beira do rio Mondego. O nome deste largo deve-se ao facto de antigamente se cobrarem impostos sobre as mercadorias que chegavam a cidade vindas do sul.
Neste largo, esta um dos simbolos arquitectonicos da cidade de Coimbra, o Hotel Astoria construido em 1926 e o Cafe Montanha, um cafe com mais de 50 anos de existencia.
Conectada a este largo fica a principal rua da Baixa de Coimbra, a rua Ferreira Borges, uma rua que actualmente esta fechada ao transito automovel e onde existem varias lojas de comercio tradicional.]]
zonePortagem.Visible = false
zonePortagem.Media = zmediaLargodaPortagem
zonePortagem.Commands = {}
zonePortagem.DistanceRange = Distance(-1, "feet")
zonePortagem.ShowObjects = "OnEnter"
zonePortagem.ProximityRange = Distance(200, "feet")
zonePortagem.AllowSetPositionTo = false
zonePortagem.Active = false
zonePortagem.Points = {
	ZonePoint(40.2071415831834, -8.42909864723867, 0), 
	ZonePoint(40.2069695136029, -8.42935613930422, 0), 
	ZonePoint(40.2073771539246, -8.42990330994326, 0), 
	ZonePoint(40.2076485713722, -8.42912144601542, 0)
}
zonePortagem.OriginalPoint = ZonePoint(40.207243, -8.429295, 0)
zonePortagem.DistanceRangeUOM = "Feet"
zonePortagem.ProximityRangeUOM = "Feet"
zonePortagem.OutOfRangeName = ""
zonePortagem.InRangeName = ""
zonePraadoComrcio1 = Wherigo.Zone(cartCoimbra)
zonePraadoComrcio1.Id = "8ab0f117-d350-4654-ba23-9029feb7acdf"
zonePraadoComrcio1.Name = "Praca do Comercio"
zonePraadoComrcio1.Description = [[[EN]
Igreja de S. Bartolomeu
Originally built in the 10th century, it was transformed in the 12th and 18th centuries.
[PT]
Igreja de S. Bartolomeu
Remonta ao sec. X, mas foi remodelada nos seculos XlI e XVIII. No interior, destacam-se os retabulos barrocos, de talha dourada, nomeadamente o da capela-mor (sec. XVIII), que inclui uma grande tela alusiva ao Martirio de S. Bartolomeu.
Do lado do Evangelho, num retabulo de estilo maneirista, sec. XVI, destacam-se as pinturas alusivas a Morte e Ressurreicao de Cristo.]]
zonePraadoComrcio1.Visible = false
zonePraadoComrcio1.Media = zmediaIgrejajuntoapracadocomercio
zonePraadoComrcio1.Commands = {}
zonePraadoComrcio1.DistanceRange = Distance(-1, "feet")
zonePraadoComrcio1.ShowObjects = "OnEnter"
zonePraadoComrcio1.ProximityRange = Distance(200, "feet")
zonePraadoComrcio1.AllowSetPositionTo = false
zonePraadoComrcio1.Active = false
zonePraadoComrcio1.Points = {
	ZonePoint(40.208365, -8.42960800000003, 0), 
	ZonePoint(40.2082027170847, -8.42919431530959, 0), 
	ZonePoint(40.2086531054197, -8.4291330061169, 0), 
	ZonePoint(40.2086816135955, -8.42959271412087, 0)
}
zonePraadoComrcio1.OriginalPoint = ZonePoint(40.2085, -8.429366, 0)
zonePraadoComrcio1.DistanceRangeUOM = "Feet"
zonePraadoComrcio1.ProximityRangeUOM = "Feet"
zonePraadoComrcio1.OutOfRangeName = ""
zonePraadoComrcio1.InRangeName = ""
zoneEstaodeComboios = Wherigo.Zone(cartCoimbra)
zoneEstaodeComboios.Id = "943c6720-0762-4633-933a-6769bdc0affd"
zoneEstaodeComboios.Name = "Train station / Estacao de Comboio"
zoneEstaodeComboios.Description = [[[EN]
This train station, usually know as Coimbra A, was officially opened  in 1931, on March 15, at the place where the passengers descended from the south and north, picked up a small branch, which, since 1885, put them in the city center.
Before that, the city connection was made through the cars of the American Rail Road Conimbricense .
[PT]
Estacao de comboios, normalmente conhecida como Coimbra A, foi inaugurada oficialmente em 1931, a 15 de Marco, sendo um local de embarque / desembarque para passageiros vindos do sul e do norte de Portugal. Antes da existencia desta estacao a ligacao dos comboios (que paravam so na estacao de Coimbra B) era feita atraves de carros americanos do Rail Roadconimbricense.]]
zoneEstaodeComboios.Visible = false
zoneEstaodeComboios.Media = zmediaEstacao
zoneEstaodeComboios.Commands = {}
zoneEstaodeComboios.DistanceRange = Distance(-1, "feet")
zoneEstaodeComboios.ShowObjects = "OnEnter"
zoneEstaodeComboios.ProximityRange = Distance(200, "feet")
zoneEstaodeComboios.AllowSetPositionTo = false
zoneEstaodeComboios.Active = false
zoneEstaodeComboios.Points = {
	ZonePoint(40.209386, -8.43221100000005, 0), 
	ZonePoint(40.208849, -8.43234400000006, 0), 
	ZonePoint(40.2083905545995, -8.43189550181773, 0), 
	ZonePoint(40.2087978869375, -8.43130741219898, 0)
}
zoneEstaodeComboios.OriginalPoint = ZonePoint(40.208777, -8.431988, 0)
zoneEstaodeComboios.DistanceRangeUOM = "Feet"
zoneEstaodeComboios.ProximityRangeUOM = "Feet"
zoneEstaodeComboios.OutOfRangeName = ""
zoneEstaodeComboios.InRangeName = ""
zoneRioMondego = Wherigo.Zone(cartCoimbra)
zoneRioMondego.Id = "220da4a6-320f-4711-a5ba-942991b5c92b"
zoneRioMondego.Name = "Rio Mondego"
zoneRioMondego.Description = "(Rio Mondego), a river in Portugal. Length, 227 km; basin area, 6,700 sq km. The Mondego rises on the northeastern slopes of the Serra da Estrela, flowing mostly in the mountains; it empties into the Atlantic. There is winter flooding; while low water is in summer. There are sharp fluctuations in water level and flow (changes in water discharges from 1 to 3,000 cu m per sec). The river is navigable for 80 km from its mouth. The city of Coimbra is on the river, and Figueira da Foz is near its mouth."
zoneRioMondego.Visible = false
zoneRioMondego.Media = zmediaRioMondego
zoneRioMondego.Commands = {}
zoneRioMondego.DistanceRange = Distance(-1, "feet")
zoneRioMondego.ShowObjects = "OnEnter"
zoneRioMondego.ProximityRange = Distance(200, "feet")
zoneRioMondego.AllowSetPositionTo = false
zoneRioMondego.Active = false
zoneRioMondego.Points = {
	ZonePoint(40.2089403228118, -8.43232494477456, 0), 
	ZonePoint(40.208732, -8.43261200000006, 0), 
	ZonePoint(40.209892, -8.43373900000006, 0), 
	ZonePoint(40.2101751759525, -8.4332301901436, 0)
}
zoneRioMondego.OriginalPoint = ZonePoint(40.209929, -8.433718, 0)
zoneRioMondego.DistanceRangeUOM = "Feet"
zoneRioMondego.ProximityRangeUOM = "Feet"
zoneRioMondego.OutOfRangeName = ""
zoneRioMondego.InRangeName = ""
_l_8u = Wherigo.Zone(cartCoimbra)
_l_8u.Id = "36a4b522-02a3-4938-b53d-dec6be76fd55"
_l_8u.Name = "Cache"
_l_8u.Description = "A small container "
_l_8u.Visible = false
_l_8u.Media = _Yg5wD
_l_8u.Commands = {}
_l_8u.DistanceRange = Distance(-1, "feet")
_l_8u.ShowObjects = "OnEnter"
_l_8u.ProximityRange = Distance(60, "meters")
_l_8u.AllowSetPositionTo = false
_l_8u.Active = false
_l_8u.Points = {
	ZonePoint(40.2119606556355, -8.43557614865301, 0), 
	ZonePoint(40.2118859316539, -8.4356271106243, 0), 
	ZonePoint(40.2118422960588, -8.43560565295218, 0), 
	ZonePoint(40.2119093540355, -8.43554463269709, 0)
}
_l_8u.OriginalPoint = ZonePoint(40.2118995593459, -8.43558838623165, 0)
_l_8u.DistanceRangeUOM = "Feet"
_l_8u.ProximityRangeUOM = "Meters"
_l_8u.OutOfRangeName = ""
_l_8u.InRangeName = ""

-- Characters --
zcharacterProfessor = Wherigo.ZCharacter(cartCoimbra)
zcharacterProfessor.Id = "cc45449f-06a2-40c8-b5d8-527dad1ff623"
zcharacterProfessor.Name = "Professor"
zcharacterProfessor.Description = [[Hello, my name is John, I am a teacher at the University in Coimbra.
I'm here to help you on your taks. Good Luck.]]
zcharacterProfessor.Visible = false
zcharacterProfessor.Media = zmediaProfessor
zcharacterProfessor.Icon = zmediaProfessor
zcharacterProfessor.Commands = {}
zcharacterProfessor.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterProfessor.Gender = "Male"
zcharacterProfessor.Type = "NPC"
_Cwc = Wherigo.ZCharacter{
	Cartridge = cartCoimbra, 
	Container = Player
}
_Cwc.Id = "6de59ccf-45ba-4637-bfaa-d1f60f8f5cea"
_Cwc.Name = "Malevolus"
_Cwc.Description = [[[EN]
Hi there, I'm the bad character of this adventure... can you find me? Can you stop me?
[PT]
Ola, eu sou o Malevolus, a personagem que te vai fazer percorrer as ruas de Coimbra... sera que me consegues encontrar?]]
_Cwc.Visible = true
_Cwc.Media = _vAw
_Cwc.Icon = _5cpm
_Cwc.Commands = {
	_tyQ = Wherigo.ZCommand{
		Text = "Score", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_Cwc.Commands._tyQ.Custom = true
_Cwc.Commands._tyQ.Id = "9f8bc845-f3b6-4611-9728-825da415d96f"
_Cwc.Commands._tyQ.WorksWithAll = true
_Cwc.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Cwc.Gender = "Male"
_Cwc.Type = "NPC"

-- Items --
zitemItem_01_coluna_tribunal = Wherigo.ZItem(cartCoimbra)
zitemItem_01_coluna_tribunal.Id = "3f6c357a-e302-46ed-be12-f9044350bcc3"
zitemItem_01_coluna_tribunal.Name = "Column in the Court / Coluna no tribunal"
zitemItem_01_coluna_tribunal.Description = [[[EN]
This is column that you can see in the front side of the Court in Coimbra.
[PT]
Uma coluna que podemos encontrar no Tribunal.]]
zitemItem_01_coluna_tribunal.Visible = false
zitemItem_01_coluna_tribunal.Media = zmediaItem_01_Coluna_tribunal
zitemItem_01_coluna_tribunal.Commands = {
	Take = Wherigo.ZCommand{
		Text = "Take/Obter", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing to take"
	}, 
	_jnO = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
zitemItem_01_coluna_tribunal.Commands.Take.Custom = true
zitemItem_01_coluna_tribunal.Commands.Take.Id = "be6eb004-f189-4a98-a84f-db08c6e0d0a1"
zitemItem_01_coluna_tribunal.Commands.Take.WorksWithAll = true
zitemItem_01_coluna_tribunal.Commands._jnO.Custom = true
zitemItem_01_coluna_tribunal.Commands._jnO.Id = "68d3e890-3e13-4455-8b63-6be4ef88dfcd"
zitemItem_01_coluna_tribunal.Commands._jnO.WorksWithAll = true
zitemItem_01_coluna_tribunal.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemItem_01_coluna_tribunal.Locked = false
zitemItem_01_coluna_tribunal.Opened = false
zitemItem_02_candeeiro_Cmc = Wherigo.ZItem(cartCoimbra)
zitemItem_02_candeeiro_Cmc.Id = "75bc952c-ed2c-4aed-9108-1f7a3c95fe8b"
zitemItem_02_candeeiro_Cmc.Name = "Lamp at city hall (Candeeiro)"
zitemItem_02_candeeiro_Cmc.Description = [[[EN]
This is a lamp that you can find in the City Hall front.
[PT]
Candeeiro que podemos encontrar na parte de frente da Camara Municipal de Coimbra.]]
zitemItem_02_candeeiro_Cmc.Visible = false
zitemItem_02_candeeiro_Cmc.Media = zmediaItem_02_Candeeiro_CMC
zitemItem_02_candeeiro_Cmc.Commands = {
	_9OPAH = Wherigo.ZCommand{
		Text = "Take/Obter", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	_vRpC = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
zitemItem_02_candeeiro_Cmc.Commands._9OPAH.Custom = true
zitemItem_02_candeeiro_Cmc.Commands._9OPAH.Id = "22d77bad-071e-4a6b-b433-8c380e6bf45f"
zitemItem_02_candeeiro_Cmc.Commands._9OPAH.WorksWithAll = true
zitemItem_02_candeeiro_Cmc.Commands._vRpC.Custom = true
zitemItem_02_candeeiro_Cmc.Commands._vRpC.Id = "edfdbcb2-e8e6-45c3-9e9e-d8d2016cd314"
zitemItem_02_candeeiro_Cmc.Commands._vRpC.WorksWithAll = true
zitemItem_02_candeeiro_Cmc.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemItem_02_candeeiro_Cmc.Locked = false
zitemItem_02_candeeiro_Cmc.Opened = false
zitemitem_03_dragao_cafe_santa_Cruz = Wherigo.ZItem(cartCoimbra)
zitemitem_03_dragao_cafe_santa_Cruz.Id = "f7d1871f-b635-4ee7-8078-079525fe2bf8"
zitemitem_03_dragao_cafe_santa_Cruz.Name = "Eagle at cafe de Santa Cruz (Aguia)"
zitemitem_03_dragao_cafe_santa_Cruz.Description = [[[EN]
An eagle, or even two eagles... a special symbol used by Malevolus on some of his notes.
[PT]
Uma aguia, ou mais, que podemos encontrar na fachada deste cafe. Trata-se de um simbolo que foi encontrado nalguns dos apontamentos do Malevolus.]]
zitemitem_03_dragao_cafe_santa_Cruz.Visible = false
zitemitem_03_dragao_cafe_santa_Cruz.Media = zmedia03dragaocafesantacruz800
zitemitem_03_dragao_cafe_santa_Cruz.Commands = {
	_h6G9 = Wherigo.ZCommand{
		Text = "Take/Obter", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	_2H9FN = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
zitemitem_03_dragao_cafe_santa_Cruz.Commands._h6G9.Custom = true
zitemitem_03_dragao_cafe_santa_Cruz.Commands._h6G9.Id = "a495b2b4-273b-43d5-a52f-1985b52e2953"
zitemitem_03_dragao_cafe_santa_Cruz.Commands._h6G9.WorksWithAll = true
zitemitem_03_dragao_cafe_santa_Cruz.Commands._2H9FN.Custom = true
zitemitem_03_dragao_cafe_santa_Cruz.Commands._2H9FN.Id = "69714ea5-2505-4784-b26e-647c59b1aa1e"
zitemitem_03_dragao_cafe_santa_Cruz.Commands._2H9FN.WorksWithAll = true
zitemitem_03_dragao_cafe_santa_Cruz.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemitem_03_dragao_cafe_santa_Cruz.Locked = false
zitemitem_03_dragao_cafe_santa_Cruz.Opened = false
zitemitem_04_fonte_jardim_da_manga = Wherigo.ZItem{
	Cartridge = cartCoimbra, 
	Container = zoneJardimdaManga
}
zitemitem_04_fonte_jardim_da_manga.Id = "11090cd6-a950-4742-a99c-236b6252ea44"
zitemitem_04_fonte_jardim_da_manga.Name = "Fountain/Fonte - Jardim da Manga"
zitemitem_04_fonte_jardim_da_manga.Description = [[[EN]
Here, at the Manga Garden you can find a small fountain, that  Malevolus used to take some special water
[PT]
Uma fonte que se encontra no Jardim da Manga. Malevolus utilizou esta fonte para recolher alguma agua, que acreditava ter propriedades especiais.]]
zitemitem_04_fonte_jardim_da_manga.Visible = false
zitemitem_04_fonte_jardim_da_manga.Media = zmedia04fontedojardimdamanga800
zitemitem_04_fonte_jardim_da_manga.Commands = {
	_WgJ_D = Wherigo.ZCommand{
		Text = "Take/Obter", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	_CKr = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
zitemitem_04_fonte_jardim_da_manga.Commands._WgJ_D.Custom = true
zitemitem_04_fonte_jardim_da_manga.Commands._WgJ_D.Id = "52318ab8-303e-473d-9d8d-e5425337cbef"
zitemitem_04_fonte_jardim_da_manga.Commands._WgJ_D.WorksWithAll = true
zitemitem_04_fonte_jardim_da_manga.Commands._CKr.Custom = true
zitemitem_04_fonte_jardim_da_manga.Commands._CKr.Id = "6a640a3f-04a6-452a-8f39-b278fc5ac156"
zitemitem_04_fonte_jardim_da_manga.Commands._CKr.WorksWithAll = true
zitemitem_04_fonte_jardim_da_manga.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemitem_04_fonte_jardim_da_manga.Locked = false
zitemitem_04_fonte_jardim_da_manga.Opened = false
zitemitem_06_lab_quimico = Wherigo.ZItem(cartCoimbra)
zitemitem_06_lab_quimico.Id = "0155dee2-a3bf-446d-a297-c28a7bffd029"
zitemitem_06_lab_quimico.Name = "Chemical Lab top / Objecto no telhado"
zitemitem_06_lab_quimico.Description = [[[EN]
You might need to use this item. Keep it with you until you find it's necessary.
[PT]
Podera ser necessario utilizar este objecto. Devera guarda-lo.]]
zitemitem_06_lab_quimico.Visible = true
zitemitem_06_lab_quimico.Media = zmedia06Labquimico800
zitemitem_06_lab_quimico.Commands = {
	_SAmAT = Wherigo.ZCommand{
		Text = "Take/Obter", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	_PGL = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
zitemitem_06_lab_quimico.Commands._SAmAT.Custom = true
zitemitem_06_lab_quimico.Commands._SAmAT.Id = "44742226-6302-4e6d-960b-24775c15f18c"
zitemitem_06_lab_quimico.Commands._SAmAT.WorksWithAll = true
zitemitem_06_lab_quimico.Commands._PGL.Custom = true
zitemitem_06_lab_quimico.Commands._PGL.Id = "fdd5e3cf-4c5c-4ce8-9a57-d9c5d32c76dc"
zitemitem_06_lab_quimico.Commands._PGL.WorksWithAll = true
zitemitem_06_lab_quimico.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemitem_06_lab_quimico.Locked = false
zitemitem_06_lab_quimico.Opened = false
zitemitem_07_bola_escadas_monumentais = Wherigo.ZItem(cartCoimbra)
zitemitem_07_bola_escadas_monumentais.Id = "a20df662-bd8d-443f-ad82-48c8a9fe9886"
zitemitem_07_bola_escadas_monumentais.Name = "Monumental Stairs/Bola"
zitemitem_07_bola_escadas_monumentais.Description = ""
zitemitem_07_bola_escadas_monumentais.Visible = true
zitemitem_07_bola_escadas_monumentais.Media = zmedia07bolaescadamonumentais800
zitemitem_07_bola_escadas_monumentais.Commands = {
	_4a87 = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	_XAYB = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	_pifk = Wherigo.ZCommand{
		Text = "Info/Informacao", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "In order to take this object you have to use the Eagle that you have."
	}
}
zitemitem_07_bola_escadas_monumentais.Commands._4a87.Custom = true
zitemitem_07_bola_escadas_monumentais.Commands._4a87.Id = "c7b948ff-8d36-49bd-9c06-b2b5272db8c1"
zitemitem_07_bola_escadas_monumentais.Commands._4a87.WorksWithAll = true
zitemitem_07_bola_escadas_monumentais.Commands._XAYB.Custom = true
zitemitem_07_bola_escadas_monumentais.Commands._XAYB.Id = "01a94af7-7ac8-49a5-8151-3bd5d8875675"
zitemitem_07_bola_escadas_monumentais.Commands._XAYB.WorksWithAll = true
zitemitem_07_bola_escadas_monumentais.Commands._pifk.Custom = true
zitemitem_07_bola_escadas_monumentais.Commands._pifk.Id = "345b88d5-69d2-4cb1-832c-b3ef0550de36"
zitemitem_07_bola_escadas_monumentais.Commands._pifk.WorksWithAll = true
zitemitem_07_bola_escadas_monumentais.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemitem_07_bola_escadas_monumentais.Locked = false
zitemitem_07_bola_escadas_monumentais.Opened = false
zitemitem_09_estatua_fac_letras = Wherigo.ZItem(cartCoimbra)
zitemitem_09_estatua_fac_letras.Id = "b1f8dd21-e3ae-4d40-af68-094cfd95cdf8"
zitemitem_09_estatua_fac_letras.Name = "Statue/Estatua"
zitemitem_09_estatua_fac_letras.Description = [[[EN]
This statue will help you on a task.
[PT]
Uma estatua que podera ser util no futuro.]]
zitemitem_09_estatua_fac_letras.Visible = false
zitemitem_09_estatua_fac_letras.Media = zmedia09estatuafaculdadedeletras800
zitemitem_09_estatua_fac_letras.Commands = {
	_J2Haj = Wherigo.ZCommand{
		Text = "Take/Obter", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	_PkS = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
zitemitem_09_estatua_fac_letras.Commands._J2Haj.Custom = true
zitemitem_09_estatua_fac_letras.Commands._J2Haj.Id = "94aed301-fc5c-46b1-953f-b4ab19b72396"
zitemitem_09_estatua_fac_letras.Commands._J2Haj.WorksWithAll = true
zitemitem_09_estatua_fac_letras.Commands._PkS.Custom = true
zitemitem_09_estatua_fac_letras.Commands._PkS.Id = "1af08cc0-0d8c-4a60-9919-ad46dc3a8d96"
zitemitem_09_estatua_fac_letras.Commands._PkS.WorksWithAll = true
zitemitem_09_estatua_fac_letras.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemitem_09_estatua_fac_letras.Locked = false
zitemitem_09_estatua_fac_letras.Opened = false
zitemitem_12_triangulo_se_nova = Wherigo.ZItem(cartCoimbra)
zitemitem_12_triangulo_se_nova.Id = "d9a8ba52-d8ac-43c5-87c1-8bdfc9676219"
zitemitem_12_triangulo_se_nova.Name = "Triangle/Triangulo"
zitemitem_12_triangulo_se_nova.Description = [[[EN]
A triangle that you can find in the New Cathedral.
[PT]
Um triangulo que se encontra na Se Nova]]
zitemitem_12_triangulo_se_nova.Visible = false
zitemitem_12_triangulo_se_nova.Media = zmedia12triangulosenova800
zitemitem_12_triangulo_se_nova.Commands = {
	_EuIj = Wherigo.ZCommand{
		Text = "Take/Obter", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	_4B5_ = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
zitemitem_12_triangulo_se_nova.Commands._EuIj.Custom = true
zitemitem_12_triangulo_se_nova.Commands._EuIj.Id = "f18b3f88-7236-49c9-82b0-9d61e9628a67"
zitemitem_12_triangulo_se_nova.Commands._EuIj.WorksWithAll = true
zitemitem_12_triangulo_se_nova.Commands._4B5_.Custom = true
zitemitem_12_triangulo_se_nova.Commands._4B5_.Id = "fbcd2941-ac82-49ab-8d6d-9ccc1b51df66"
zitemitem_12_triangulo_se_nova.Commands._4B5_.WorksWithAll = true
zitemitem_12_triangulo_se_nova.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemitem_12_triangulo_se_nova.Locked = false
zitemitem_12_triangulo_se_nova.Opened = false
zitemitem_15_jarro_quebra_costas = Wherigo.ZItem(cartCoimbra)
zitemitem_15_jarro_quebra_costas.Id = "0cfc9cb9-a85c-4f3e-bae9-941c1d471e22"
zitemitem_15_jarro_quebra_costas.Name = "Pitcher/Cantaro quebra costas"
zitemitem_15_jarro_quebra_costas.Description = ""
zitemitem_15_jarro_quebra_costas.Visible = false
zitemitem_15_jarro_quebra_costas.Media = zmedia15jarroquebracostas800
zitemitem_15_jarro_quebra_costas.Commands = {
	_VjOPQ = Wherigo.ZCommand{
		Text = "Take/Obter", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	_OjPDJ = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
zitemitem_15_jarro_quebra_costas.Commands._VjOPQ.Custom = true
zitemitem_15_jarro_quebra_costas.Commands._VjOPQ.Id = "158d2c16-163e-44d2-acd2-6a5c62119e19"
zitemitem_15_jarro_quebra_costas.Commands._VjOPQ.WorksWithAll = true
zitemitem_15_jarro_quebra_costas.Commands._OjPDJ.Custom = true
zitemitem_15_jarro_quebra_costas.Commands._OjPDJ.Id = "f002c9bd-c070-4cbc-86c1-c27a81db98fa"
zitemitem_15_jarro_quebra_costas.Commands._OjPDJ.WorksWithAll = true
zitemitem_15_jarro_quebra_costas.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemitem_15_jarro_quebra_costas.Locked = false
zitemitem_15_jarro_quebra_costas.Opened = false
zitemitem_16_pedras = Wherigo.ZItem(cartCoimbra)
zitemitem_16_pedras.Id = "8a9357e1-a620-438f-9c52-cbf9eec438c6"
zitemitem_16_pedras.Name = "Stones/Pedras"
zitemitem_16_pedras.Description = [[[EN]
Some stones that you can find on the wall.
[PT]
Algumas pedras que e possivel encontrar na parede.]]
zitemitem_16_pedras.Visible = false
zitemitem_16_pedras.Media = zmedia16pedrasjuntoaogovernocivil800
zitemitem_16_pedras.Commands = {
	_cIjw = Wherigo.ZCommand{
		Text = "Take/Obter", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	_FCz = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
zitemitem_16_pedras.Commands._cIjw.Custom = true
zitemitem_16_pedras.Commands._cIjw.Id = "6fdb8538-7938-44f2-80eb-9b37b9a03d35"
zitemitem_16_pedras.Commands._cIjw.WorksWithAll = true
zitemitem_16_pedras.Commands._FCz.Custom = true
zitemitem_16_pedras.Commands._FCz.Id = "894a4cb3-566a-4ed7-b79e-a2feefa948b5"
zitemitem_16_pedras.Commands._FCz.WorksWithAll = true
zitemitem_16_pedras.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemitem_16_pedras.Locked = false
zitemitem_16_pedras.Opened = false
zitemitem_17_mao_miguel_torga = Wherigo.ZItem(cartCoimbra)
zitemitem_17_mao_miguel_torga.Id = "67019f98-c1ca-478a-9fdc-d17abf1a8fe7"
zitemitem_17_mao_miguel_torga.Name = "Hand / Mao (Miguel Torga"
zitemitem_17_mao_miguel_torga.Description = ""
zitemitem_17_mao_miguel_torga.Visible = false
zitemitem_17_mao_miguel_torga.Media = zmedia17maodemigueltorgaportagem800
zitemitem_17_mao_miguel_torga.Commands = {
	_1oG = Wherigo.ZCommand{
		Text = "Take/Obter", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	_D4PWU = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
zitemitem_17_mao_miguel_torga.Commands._1oG.Custom = true
zitemitem_17_mao_miguel_torga.Commands._1oG.Id = "2b3a7e1d-add8-4756-aa69-1ec536a1c1f6"
zitemitem_17_mao_miguel_torga.Commands._1oG.WorksWithAll = true
zitemitem_17_mao_miguel_torga.Commands._D4PWU.Custom = true
zitemitem_17_mao_miguel_torga.Commands._D4PWU.Id = "b330bc80-9ee1-4c82-8299-adf15435d2cb"
zitemitem_17_mao_miguel_torga.Commands._D4PWU.WorksWithAll = true
zitemitem_17_mao_miguel_torga.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemitem_17_mao_miguel_torga.Locked = false
zitemitem_17_mao_miguel_torga.Opened = false
zitemitem_19_praca_comercio = Wherigo.ZItem(cartCoimbra)
zitemitem_19_praca_comercio.Id = "cf06b4b3-210e-4cc8-ab5f-f26191b82403"
zitemitem_19_praca_comercio.Name = "Object/Objecto Praca do Comercio"
zitemitem_19_praca_comercio.Description = ""
zitemitem_19_praca_comercio.Visible = false
zitemitem_19_praca_comercio.Media = zmedia19PraadoComrcio800
zitemitem_19_praca_comercio.Commands = {
	_pgqhz = Wherigo.ZCommand{
		Text = "Take/Obter", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	_4vx = Wherigo.ZCommand{
		Text = "Use/Utilizar", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
zitemitem_19_praca_comercio.Commands._pgqhz.Custom = true
zitemitem_19_praca_comercio.Commands._pgqhz.Id = "81bd3f39-d03f-4e29-973a-e75b1eb4dbfd"
zitemitem_19_praca_comercio.Commands._pgqhz.WorksWithAll = true
zitemitem_19_praca_comercio.Commands._4vx.Custom = true
zitemitem_19_praca_comercio.Commands._4vx.Id = "0d468447-4992-4bf0-9a0c-0afac1f131aa"
zitemitem_19_praca_comercio.Commands._4vx.WorksWithAll = true
zitemitem_19_praca_comercio.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemitem_19_praca_comercio.Locked = false
zitemitem_19_praca_comercio.Opened = false
_GFp1 = Wherigo.ZItem(cartCoimbra)
_GFp1.Id = "51cb80be-193b-4950-a932-f931ade99646"
_GFp1.Name = "Question Igreja de Nossa Senhora do Carmo"
_GFp1.Description = [[Malevolus was here, and to try to find him we have a little question to answer.
Please approach the Church and tell me the year when this Church was founded, it is very important,]]
_GFp1.Visible = false
_GFp1.Media = _7oHN
_GFp1.Icon = _7oHN
_GFp1.Commands = {
	_ra_ = Wherigo.ZCommand{
		Text = "Answer", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
_GFp1.Commands._ra_.Custom = true
_GFp1.Commands._ra_.Id = "a3d121e1-7e17-48fd-b0f0-249ccc2bc358"
_GFp1.Commands._ra_.WorksWithAll = true
_GFp1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_GFp1.Locked = false
_GFp1.Opened = false
_W7B = Wherigo.ZItem(cartCoimbra)
_W7B.Id = "08309a50-0259-4e7a-9cbc-4006b5bd3c04"
_W7B.Name = "Question at Patio da Inquisicao"
_W7B.Description = "On the way to build his destruction device Malevolus stopped here."
_W7B.Visible = false
_W7B.Media = _7oHN
_W7B.Icon = _7oHN
_W7B.Commands = {
	_R67h = Wherigo.ZCommand{
		Text = "Answer", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_W7B.Commands._R67h.Custom = true
_W7B.Commands._R67h.Id = "df770806-224f-4d67-9101-1e7dce4f158c"
_W7B.Commands._R67h.WorksWithAll = true
_W7B.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_W7B.Locked = false
_W7B.Opened = false
_m5_x6 = Wherigo.ZItem(cartCoimbra)
_m5_x6.Id = "dc6788cf-8f73-4901-ab33-06472b1ae561"
_m5_x6.Name = "Question at Santa Cruz Church"
_m5_x6.Description = "A question about this church. Take your time to answer"
_m5_x6.Visible = false
_m5_x6.Media = _7oHN
_m5_x6.Commands = {
	_upXA = Wherigo.ZCommand{
		Text = "Answer", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_m5_x6.Commands._upXA.Custom = true
_m5_x6.Commands._upXA.Id = "e31ab9ab-7ab6-4eb0-847b-8ce506d23c92"
_m5_x6.Commands._upXA.WorksWithAll = true
_m5_x6.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_m5_x6.Locked = false
_m5_x6.Opened = false
_jokfZ = Wherigo.ZItem(cartCoimbra)
_jokfZ.Id = "b978e65c-8d90-4d3c-b2e6-fb33778593e0"
_jokfZ.Name = "Question Get color of the Market"
_jokfZ.Description = "You need to tell me the color of the roof of the Market."
_jokfZ.Visible = true
_jokfZ.Media = _7oHN
_jokfZ.Commands = {
	_v0QSm = Wherigo.ZCommand{
		Text = "Answer", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_jokfZ.Commands._v0QSm.Custom = true
_jokfZ.Commands._v0QSm.Id = "10b7ca6c-67cb-42d3-965d-1f831a142e30"
_jokfZ.Commands._v0QSm.WorksWithAll = true
_jokfZ.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_jokfZ.Locked = false
_jokfZ.Opened = false
_QD04Y = Wherigo.ZItem(cartCoimbra)
_QD04Y.Id = "6f89b19a-558a-4261-9a3a-9fc3e4412d12"
_QD04Y.Name = "Question at  Aqueduct (Arcos de Jardim)"
_QD04Y.Description = ""
_QD04Y.Visible = false
_QD04Y.Media = _7oHN
_QD04Y.Commands = {
	_JmEf = Wherigo.ZCommand{
		Text = "Answer", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_QD04Y.Commands._JmEf.Custom = true
_QD04Y.Commands._JmEf.Id = "5e294e42-9f06-40f9-b682-cd3656be837a"
_QD04Y.Commands._JmEf.WorksWithAll = true
_QD04Y.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_QD04Y.Locked = false
_QD04Y.Opened = false
_jEM = Wherigo.ZItem(cartCoimbra)
_jEM.Id = "90adf67f-6a2e-4861-ad10-9b193955128d"
_jEM.Name = "Question botanical garden"
_jEM.Description = "Please answer to the next question."
_jEM.Visible = false
_jEM.Media = _7oHN
_jEM.Commands = {
	_KKG = Wherigo.ZCommand{
		Text = "Answer", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_jEM.Commands._KKG.Custom = true
_jEM.Commands._KKG.Id = "c07205b9-83f2-40ed-9bbd-6c0d0db2b90f"
_jEM.Commands._KKG.WorksWithAll = true
_jEM.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_jEM.Locked = false
_jEM.Opened = false
_FKqjH = Wherigo.ZItem(cartCoimbra)
_FKqjH.Id = "cd0f7ed7-730d-41c9-998a-6e414b0b0a83"
_FKqjH.Name = "Question at Largo da Portagem"
_FKqjH.Description = ""
_FKqjH.Visible = false
_FKqjH.Media = _7oHN
_FKqjH.Commands = {
	_wW0K8 = Wherigo.ZCommand{
		Text = "Answer", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_FKqjH.Commands._wW0K8.Custom = true
_FKqjH.Commands._wW0K8.Id = "269b6075-4aec-4ece-8894-c310f084fa9c"
_FKqjH.Commands._wW0K8.WorksWithAll = true
_FKqjH.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_FKqjH.Locked = false
_FKqjH.Opened = false
_g_bu = Wherigo.ZItem(cartCoimbra)
_g_bu.Id = "3d79aa15-54a8-4b22-bde7-66b539bbe7ea"
_g_bu.Name = "Question at D. Dinis"
_g_bu.Description = ""
_g_bu.Visible = true
_g_bu.Media = _7oHN
_g_bu.Commands = {
	_8XHTn = Wherigo.ZCommand{
		Text = "Answer", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_g_bu.Commands._8XHTn.Custom = true
_g_bu.Commands._8XHTn.Id = "04b4e59a-fa2e-4aa7-84d5-04d542d93a0e"
_g_bu.Commands._8XHTn.WorksWithAll = true
_g_bu.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_g_bu.Locked = false
_g_bu.Opened = false
_qej = Wherigo.ZItem(cartCoimbra)
_qej.Id = "40d83622-9a6a-4305-a919-f4c6fb3cc899"
_qej.Name = "Question at Arcos"
_qej.Description = ""
_qej.Visible = true
_qej.Media = _7oHN
_qej.Commands = {
	_MnK = Wherigo.ZCommand{
		Text = "Answer", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_qej.Commands._MnK.Custom = true
_qej.Commands._MnK.Id = "29caeb38-501c-4d18-9199-f9771903195b"
_qej.Commands._MnK.WorksWithAll = true
_qej.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_qej.Locked = false
_qej.Opened = false
_zkXRs = Wherigo.ZItem(cartCoimbra)
_zkXRs.Id = "f0a4a759-e341-4220-b771-70ff4521bead"
_zkXRs.Name = "Question at panoramic view"
_zkXRs.Description = ""
_zkXRs.Visible = false
_zkXRs.Media = _7oHN
_zkXRs.Commands = {
	_tBgB = Wherigo.ZCommand{
		Text = "Answer", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_zkXRs.Commands._tBgB.Custom = true
_zkXRs.Commands._tBgB.Id = "b60df086-96af-42bd-804c-475ef371c162"
_zkXRs.Commands._tBgB.WorksWithAll = true
_zkXRs.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_zkXRs.Locked = false
_zkXRs.Opened = false
_LMHO0 = Wherigo.ZItem(cartCoimbra)
_LMHO0.Id = "94dcf693-3b6d-4639-86d7-f847ac097683"
_LMHO0.Name = "Your Finish Code /Codigo"
_LMHO0.Description = ""
_LMHO0.Visible = false
_LMHO0.Media = zmediaProfessor
_LMHO0.Commands = {
	_Cso = Wherigo.ZCommand{
		Text = "Finish", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_LMHO0.Commands._Cso.Custom = true
_LMHO0.Commands._Cso.Id = "a865ae2c-e09d-44b2-994b-30457f95158e"
_LMHO0.Commands._Cso.WorksWithAll = true
_LMHO0.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_LMHO0.Locked = false
_LMHO0.Opened = false
_Y0ls = Wherigo.ZItem{
	Cartridge = cartCoimbra, 
	Container = _l_8u
}
_Y0ls.Id = "949347cf-dea5-4233-b3e0-d96b01dc83a3"
_Y0ls.Name = "Cache"
_Y0ls.Description = [[[EN]
This is the cache where you have to log your finding.
Let's go and find it.
[PT]
Aqui e que se encontra a cache para inserir o Log.
Vamos partir para a sua procura.]]
_Y0ls.Visible = false
_Y0ls.Media = _Qap
_Y0ls.Commands = {}
_Y0ls.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Y0ls.Locked = false
_Y0ls.Opened = false
__fyV = Wherigo.ZItem(cartCoimbra)
__fyV.Id = "94b140fb-89bd-4965-9021-41e62c625ebc"
__fyV.Name = "Questao na Igreja de Nossa Senhora do Carmo"
__fyV.Description = [[O Malevolus esteve aqui, e para o tentar encontrar temos de responder a uma pequena questao.
Deve aproximar-se da Igreja e verificar em que ano foi fundada esta igreja.]]
__fyV.Visible = false
__fyV.Media = _7oHN
__fyV.Icon = _7oHN
__fyV.Commands = {
	_JyZIq = Wherigo.ZCommand{
		Text = "Responder", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
__fyV.Commands._JyZIq.Custom = true
__fyV.Commands._JyZIq.Id = "089eb7ae-9bd6-4bbc-bbed-0e5a572aa322"
__fyV.Commands._JyZIq.WorksWithAll = true
__fyV.ObjectLocation = Wherigo.INVALID_ZONEPOINT
__fyV.Locked = false
__fyV.Opened = false
_tT6 = Wherigo.ZItem(cartCoimbra)
_tT6.Id = "462d5658-ece9-4a69-9301-07de420af4c6"
_tT6.Name = "Questao no Patio da Inquisicao"
_tT6.Description = "Na sua caminhada para a destruicao, o Malevolus passou por aqui, e para o encontrar-mos temos de verificar algo neste ponto."
_tT6.Visible = false
_tT6.Media = _7oHN
_tT6.Commands = {
	_FQf0 = Wherigo.ZCommand{
		Text = "Responder", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
_tT6.Commands._FQf0.Custom = true
_tT6.Commands._FQf0.Id = "bf9ed023-be05-4267-ba45-2b3394389440"
_tT6.Commands._FQf0.WorksWithAll = true
_tT6.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_tT6.Locked = false
_tT6.Opened = false
_MTAk = Wherigo.ZItem(cartCoimbra)
_MTAk.Id = "4665aa16-8906-42af-b5a4-eb358dd33bae"
_MTAk.Name = "Questao na Igreja de Santa Cruz"
_MTAk.Description = "Uma pequena questao acerca da igreja de Santa Cruz."
_MTAk.Visible = false
_MTAk.Media = _7oHN
_MTAk.Commands = {
	_j7whM = Wherigo.ZCommand{
		Text = "Responder", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_MTAk.Commands._j7whM.Custom = true
_MTAk.Commands._j7whM.Id = "c0f3d4ff-566a-4ce6-806a-38a389634867"
_MTAk.Commands._j7whM.WorksWithAll = true
_MTAk.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_MTAk.Locked = false
_MTAk.Opened = false
_Mz8 = Wherigo.ZItem(cartCoimbra)
_Mz8.Id = "96bfec34-8c67-4977-bfdd-f4a144fa6d3c"
_Mz8.Name = "Questao no Mercado"
_Mz8.Description = [[E necessario que indique a cor do Mercado
]]
_Mz8.Visible = true
_Mz8.Media = _7oHN
_Mz8.Commands = {
	_odvR = Wherigo.ZCommand{
		Text = "Responder", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_Mz8.Commands._odvR.Custom = true
_Mz8.Commands._odvR.Id = "cf5b2fb0-dd51-442a-961d-9956eb96a8c8"
_Mz8.Commands._odvR.WorksWithAll = true
_Mz8.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Mz8.Locked = false
_Mz8.Opened = false
_mY0 = Wherigo.ZItem(cartCoimbra)
_mY0.Id = "331b9a6d-c460-43e0-8751-d861f43cfb6b"
_mY0.Name = "Questao no Miradouro"
_mY0.Description = ""
_mY0.Visible = false
_mY0.Media = _7oHN
_mY0.Commands = {
	_Q2Ux = Wherigo.ZCommand{
		Text = "Responder", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_mY0.Commands._Q2Ux.Custom = true
_mY0.Commands._Q2Ux.Id = "46927f73-e35d-4d8f-9420-b0dfb9f46d0e"
_mY0.Commands._Q2Ux.WorksWithAll = true
_mY0.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_mY0.Locked = false
_mY0.Opened = false
_jh4n = Wherigo.ZItem(cartCoimbra)
_jh4n.Id = "b4abe22a-989b-4acc-b780-1d4c29f0dee1"
_jh4n.Name = "Questao no D. Dinis"
_jh4n.Description = ""
_jh4n.Visible = false
_jh4n.Media = _7oHN
_jh4n.Commands = {
	_UqPo5 = Wherigo.ZCommand{
		Text = "Responder", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_jh4n.Commands._UqPo5.Custom = true
_jh4n.Commands._UqPo5.Id = "140f6c7a-a1c9-4f40-a253-262c456ef02e"
_jh4n.Commands._UqPo5.WorksWithAll = true
_jh4n.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_jh4n.Locked = false
_jh4n.Opened = false
_OcS8 = Wherigo.ZItem(cartCoimbra)
_OcS8.Id = "659aa726-1d96-4897-a58b-4a4227300d6e"
_OcS8.Name = "Questao no Jardim Botanico"
_OcS8.Description = ""
_OcS8.Visible = false
_OcS8.Media = _7oHN
_OcS8.Commands = {
	_S5W = Wherigo.ZCommand{
		Text = "Responder", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
_OcS8.Commands._S5W.Custom = true
_OcS8.Commands._S5W.Id = "9ca516ba-73aa-4e68-aaa7-9ae70c17077e"
_OcS8.Commands._S5W.WorksWithAll = true
_OcS8.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_OcS8.Locked = false
_OcS8.Opened = false

-- Tasks --
ztaskGotototribunal = Wherigo.ZTask(cartCoimbra)
ztaskGotototribunal.Id = "00be31f9-3d13-4636-b61b-a74a903de11b"
ztaskGotototribunal.Name = "Go to Court / Ir para o Tribunal"
ztaskGotototribunal.Description = [[[EN]
You must go to the Court,which is at the end of the Sofia Street. There you will find information about Malevolus and how to stop him.
[PT]
Deve ir para o tribunal de Coimbra, la ira encontrar mais informacoes para continuar com a sua aventura.]]
ztaskGotototribunal.Visible = false
ztaskGotototribunal.Media = zmediaProfessor
ztaskGotototribunal.Active = false
ztaskGotototribunal.Complete = false
ztaskGotototribunal.CorrectState = "None"
ztaskGotoIgrejadeNossaSenhoradoCarmo = Wherigo.ZTask(cartCoimbra)
ztaskGotoIgrejadeNossaSenhoradoCarmo.Id = "6be39c5e-a807-4e0a-ad35-380cb7fbbfd2"
ztaskGotoIgrejadeNossaSenhoradoCarmo.Name = "Go to Igreja de Nossa Senhora do Carmo"
ztaskGotoIgrejadeNossaSenhoradoCarmo.Description = "You must go to the next stop, at Igreja de Nossa Senhora do Carmo, on the Sofia Street. There you will find some more information about Malevolus."
ztaskGotoIgrejadeNossaSenhoradoCarmo.Visible = false
ztaskGotoIgrejadeNossaSenhoradoCarmo.Media = zmediaProfessor
ztaskGotoIgrejadeNossaSenhoradoCarmo.Active = false
ztaskGotoIgrejadeNossaSenhoradoCarmo.Complete = false
ztaskGotoIgrejadeNossaSenhoradoCarmo.CorrectState = "None"
ztaskGotoPatiodainquisicao = Wherigo.ZTask(cartCoimbra)
ztaskGotoPatiodainquisicao.Id = "ba15881e-d71c-4724-b3ce-c92d1738ed1d"
ztaskGotoPatiodainquisicao.Name = "Go to Patio da inquisicao"
ztaskGotoPatiodainquisicao.Description = "Seems that Malevolus was seen recently on the Patio da Inquisicao, maybe you will find some information there."
ztaskGotoPatiodainquisicao.Visible = false
ztaskGotoPatiodainquisicao.Media = zmediaProfessor
ztaskGotoPatiodainquisicao.Active = false
ztaskGotoPatiodainquisicao.Complete = false
ztaskGotoPatiodainquisicao.CorrectState = "None"
ztaskGotoCityHall = Wherigo.ZTask(cartCoimbra)
ztaskGotoCityHall.Id = "8d52b2f1-8fb3-46a5-8724-421f0c43be4a"
ztaskGotoCityHall.Name = "Go to City Hall"
ztaskGotoCityHall.Description = "On the City Hall you will find a new Item that might help you on your adventure."
ztaskGotoCityHall.Visible = false
ztaskGotoCityHall.Media = zmediaProfessor
ztaskGotoCityHall.Active = false
ztaskGotoCityHall.Complete = false
ztaskGotoCityHall.CorrectState = "None"
ztaskGotoSantaCruzChurch = Wherigo.ZTask(cartCoimbra)
ztaskGotoSantaCruzChurch.Id = "ca86fecc-92a4-48e4-b491-0e410e457c3f"
ztaskGotoSantaCruzChurch.Name = "Go to Santa Cruz Church"
ztaskGotoSantaCruzChurch.Description = "On the Santa Cruz Church you will have some more information about the next steps you need to take in order to find Malevolus. It's a very important historical place, some of the first Portuguese Kings are there.... who knows what you can see."
ztaskGotoSantaCruzChurch.Visible = false
ztaskGotoSantaCruzChurch.Media = zmediaProfessor
ztaskGotoSantaCruzChurch.Active = false
ztaskGotoSantaCruzChurch.Complete = false
ztaskGotoSantaCruzChurch.CorrectState = "None"
ztaskGotoCafeSantaCruz = Wherigo.ZTask(cartCoimbra)
ztaskGotoCafeSantaCruz.Id = "3546bc78-fa7a-49fb-bb03-e197d4af1180"
ztaskGotoCafeSantaCruz.Name = "Go to Cafe Santa Cruz"
ztaskGotoCafeSantaCruz.Description = "Your task is to search near the Santa Cruz Cafe, some people there saw Malevolus, who knows if you can find him there, or around... enjoy the place, and stay a bit for a coffee."
ztaskGotoCafeSantaCruz.Visible = false
ztaskGotoCafeSantaCruz.Media = zmediaProfessor
ztaskGotoCafeSantaCruz.Active = false
ztaskGotoCafeSantaCruz.Complete = false
ztaskGotoCafeSantaCruz.CorrectState = "None"
ztaskGotoJardimdaManga = Wherigo.ZTask(cartCoimbra)
ztaskGotoJardimdaManga.Id = "8ff23792-5da7-452f-a9d2-f30546236f22"
ztaskGotoJardimdaManga.Name = "Go to Jardim da Manga"
ztaskGotoJardimdaManga.Description = "The Manga Garden is a good place for hiding, look what you can find there."
ztaskGotoJardimdaManga.Visible = false
ztaskGotoJardimdaManga.Media = zmediaProfessor
ztaskGotoJardimdaManga.Active = false
ztaskGotoJardimdaManga.Complete = false
ztaskGotoJardimdaManga.CorrectState = "None"
ztaskGotoMercado = Wherigo.ZTask(cartCoimbra)
ztaskGotoMercado.Id = "c7bde256-2595-431c-a99b-e70fe8ac3bcd"
ztaskGotoMercado.Name = "Go to Market"
ztaskGotoMercado.Description = "On the market you can buy some fresh products, and seems that Malevolus went there recently."
ztaskGotoMercado.Visible = false
ztaskGotoMercado.Media = zmediaProfessor
ztaskGotoMercado.Active = false
ztaskGotoMercado.Complete = false
ztaskGotoMercado.CorrectState = "None"
ztaskGotoFaculdadedePsicologia = Wherigo.ZTask(cartCoimbra)
ztaskGotoFaculdadedePsicologia.Id = "daae7416-34f5-47c9-94ab-093fddd02a24"
ztaskGotoFaculdadedePsicologia.Name = "Go to Psycology Faculty"
ztaskGotoFaculdadedePsicologia.Description = "Malevolus had some friends at this Faculty, so it's a good place for a search."
ztaskGotoFaculdadedePsicologia.Visible = false
ztaskGotoFaculdadedePsicologia.Media = zmediaProfessor
ztaskGotoFaculdadedePsicologia.Active = false
ztaskGotoFaculdadedePsicologia.Complete = false
ztaskGotoFaculdadedePsicologia.CorrectState = "None"
_wBvz = Wherigo.ZTask(cartCoimbra)
_wBvz.Id = "988c58f8-b5fe-4278-a621-6539bc4231f3"
_wBvz.Name = "Go to Panoramic View"
_wBvz.Description = "It's time to go to the Panoramic view. There you can have a nice view of Coimbra, maybe you can spot Malevolus."
_wBvz.Visible = false
_wBvz.Media = zmediaProfessor
_wBvz.Active = false
_wBvz.Complete = false
_wBvz.CorrectState = "None"
_zZVdF = Wherigo.ZTask(cartCoimbra)
_zZVdF.Id = "33b0af0c-df9d-42ad-b561-f5ea7ba94201"
_zZVdF.Name = "Go to the Chemical Laboratory"
_zZVdF.Description = "Malevolus was working at this lab. with some experiments, can you search for him there?"
_zZVdF.Visible = false
_zZVdF.Media = zmediaProfessor
_zZVdF.Active = false
_zZVdF.Complete = false
_zZVdF.CorrectState = "None"
_zIT = Wherigo.ZTask(cartCoimbra)
_zIT.Id = "47540d58-0ec2-4526-9d38-ca57e82e132a"
_zIT.Name = "Go to the D. Dinis Square"
_zIT.Description = "A very good place to look around the students, who always cross this square, for some information about Malevolus."
_zIT.Visible = false
_zIT.Media = zmediaProfessor
_zIT.Active = false
_zIT.Complete = false
_zIT.CorrectState = "None"
_EtzTn = Wherigo.ZTask(cartCoimbra)
_EtzTn.Id = "0c9e5f10-b95c-4dbf-b568-5799ed320031"
_EtzTn.Name = "Go to the Monumental Stairs"
_EtzTn.Description = "These stairs are the main entrance in the University, what will you find there?"
_EtzTn.Visible = false
_EtzTn.Media = zmediaProfessor
_EtzTn.Active = false
_EtzTn.Complete = false
_EtzTn.CorrectState = "None"
_J1B = Wherigo.ZTask(cartCoimbra)
_J1B.Id = "7315506d-fc0c-4aed-b03c-1ddab18edb21"
_J1B.Name = "Go to the Aqueduct (Arcos de Jardim)"
_J1B.Description = "A very nice place in Coimbra, but also good for hiding..."
_J1B.Visible = false
_J1B.Media = zmediaProfessor
_J1B.Active = false
_J1B.Complete = false
_J1B.CorrectState = "None"
_Ikf = Wherigo.ZTask(cartCoimbra)
_Ikf.Id = "7dcb6fbc-c9ad-4e4a-8ee1-bdc1d974f502"
_Ikf.Name = "Go to the botanical garden"
_Ikf.Description = "What if Malevolus come to this place, here he can find all kinds of botanical species."
_Ikf.Visible = false
_Ikf.Media = zmediaProfessor
_Ikf.Active = false
_Ikf.Complete = false
_Ikf.CorrectState = "None"
_s98 = Wherigo.ZTask(cartCoimbra)
_s98.Id = "b291a574-020f-4a2d-9eb9-dad050be83f4"
_s98.Name = "Go to the University"
_s98.Description = "This is almost the center of the University, everyone crosses this place, for sure you will have some clues there."
_s98.Visible = false
_s98.Media = zmediaProfessor
_s98.Active = false
_s98.Complete = false
_s98.CorrectState = "None"
_4rSXE = Wherigo.ZTask(cartCoimbra)
_4rSXE.Id = "97f6579f-9b8e-48a7-b4d0-a689bcfc2f08"
_4rSXE.Name = "Go to Se Nova (New cathedral)"
_4rSXE.Description = "A Mystical place, always good to look around."
_4rSXE.Visible = false
_4rSXE.Media = zmediaProfessor
_4rSXE.Active = false
_4rSXE.Complete = false
_4rSXE.CorrectState = "None"
_q6GM = Wherigo.ZTask(cartCoimbra)
_q6GM.Id = "4d2edcf5-2f0a-41d5-b933-d3a98449e72c"
_q6GM.Name = "Go to Machado de Castro Museum"
_q6GM.Description = "This Museum has very important peaces of the History of Coimbra, and a great view to the Old Part of the Town, can you spot Malevolus in here?"
_q6GM.Visible = false
_q6GM.Media = zmediaProfessor
_q6GM.Active = false
_q6GM.Complete = false
_q6GM.CorrectState = "None"
_5lfuU = Wherigo.ZTask(cartCoimbra)
_5lfuU.Id = "ae1a680a-566b-463d-af49-e8f3f061a353"
_5lfuU.Name = "Go to the Se Velha (Old cathedral)"
_5lfuU.Description = "One of the most important monuments in Coimbra, and a very nice place to stop."
_5lfuU.Visible = false
_5lfuU.Media = zmediaProfessor
_5lfuU.Active = false
_5lfuU.Complete = false
_5lfuU.CorrectState = "None"
_WtkI = Wherigo.ZTask(cartCoimbra)
_WtkI.Id = "d0d8359b-d64a-4090-a1c1-edacaf77b2a2"
_WtkI.Name = "Go to the Quebra Costas Stairs"
_WtkI.Description = "Seems that everyone crosses these stairs, ask the woman there if she saw Malevolus."
_WtkI.Visible = false
_WtkI.Media = zmediaProfessor
_WtkI.Active = false
_WtkI.Complete = false
_WtkI.CorrectState = "None"
_YM5s = Wherigo.ZTask(cartCoimbra)
_YM5s.Id = "f3cb418e-f0f8-4d08-9da1-6616e193c7c3"
_YM5s.Name = "Go to the Civil Government (Governo Civil)"
_YM5s.Description = "A place with a great view of the Mondego River and the Santa Clara Bridge, probably you are aproaching Malevolus."
_YM5s.Visible = false
_YM5s.Media = zmediaProfessor
_YM5s.Active = false
_YM5s.Complete = false
_YM5s.CorrectState = "None"
_pTS = Wherigo.ZTask(cartCoimbra)
_pTS.Id = "42440da0-3b86-40da-b0d8-f1301f14457f"
_pTS.Name = "Go to Portagem"
_pTS.Description = "One of the entrances of the Town, in here you will find something about this adventure."
_pTS.Visible = false
_pTS.Media = zmediaProfessor
_pTS.Active = false
_pTS.Complete = false
_pTS.CorrectState = "None"
_HeBPC = Wherigo.ZTask(cartCoimbra)
_HeBPC.Id = "7fcde055-2912-4cd0-9def-a8c4b6f97180"
_HeBPC.Name = "Go to the Praca do Comercio"
_HeBPC.Description = "One square in Coimbra, with nice views, can you see Malevolus there?"
_HeBPC.Visible = false
_HeBPC.Media = zmediaProfessor
_HeBPC.Active = false
_HeBPC.Complete = false
_HeBPC.CorrectState = "None"
_SZ0 = Wherigo.ZTask(cartCoimbra)
_SZ0.Id = "c496fc78-6007-412e-9870-2456244eeaa4"
_SZ0.Name = "Go to the Igreja de Sao Tiago (St. James Church)"
_SZ0.Description = ""
_SZ0.Visible = false
_SZ0.Media = zmediaProfessor
_SZ0.Active = false
_SZ0.Complete = false
_SZ0.CorrectState = "None"
_sN8g = Wherigo.ZTask(cartCoimbra)
_sN8g.Id = "4893c7dd-34b9-4036-9ab5-23cb9e8ea44c"
_sN8g.Name = "Go to the train station"
_sN8g.Description = "Seems that Malevolus plans to explode this Train Station, you need to STOP him, go there and use all the objects that you have to put an end to his evil actions. He is taking a train, your objects will not allow the train to move... the police will came soon to take him to jail."
_sN8g.Visible = false
_sN8g.Media = zmediaProfessor
_sN8g.Active = false
_sN8g.Complete = false
_sN8g.CorrectState = "None"
_6D2w = Wherigo.ZTask(cartCoimbra)
_6D2w.Id = "13e412bd-8e93-4048-be56-c628559310c4"
_6D2w.Name = "Go to the Mondego River"
_6D2w.Description = "It's time to finish your adventure, go and apreciate the river. Malevolus is going to jail again, but he left something like a geocache for you to find, can you see it? No, once it was taken a bit far from here, but if your feet allow you in a few minutes you will be there."
_6D2w.Visible = false
_6D2w.Media = zmediaProfessor
_6D2w.Active = false
_6D2w.Complete = false
_6D2w.CorrectState = "None"
_HPWA = Wherigo.ZTask(cartCoimbra)
_HPWA.Id = "b5f245c1-107c-45b0-bea7-266dcd229069"
_HPWA.Name = "Use the lamp"
_HPWA.Description = [[When Malevolus was here, at the School of Psycology, not so long ago, he switched of all the lighs, now it's your time to help them to have any light.
Does any of the objects you have can help you on this task?]]
_HPWA.Visible = false
_HPWA.Media = zmediaProfessor
_HPWA.Active = false
_HPWA.Complete = false
_HPWA.CorrectState = "None"
_Df4l = Wherigo.ZTask(cartCoimbra)
_Df4l.Id = "db2e1625-f24c-4d60-98ef-62b26670d0c3"
_Df4l.Name = "Repair da Aqueduct"
_Df4l.Description = "You have to use the object you collected from the Court to support the Acqued"
_Df4l.Visible = false
_Df4l.Media = zmediaProfessor
_Df4l.Active = false
_Df4l.Complete = false
_Df4l.CorrectState = "None"
_bmY = Wherigo.ZTask(cartCoimbra)
_bmY.Id = "a350169f-9aa9-48e9-bd22-31490dee8e49"
_bmY.Name = "Use the Fountain"
_bmY.Description = [[You need to use the fountain here. 
There's no water in de the Museum, and pleople there need to use water.]]
_bmY.Visible = false
_bmY.Media = zmediaProfessor
_bmY.Active = false
_bmY.Complete = false
_bmY.CorrectState = "None"
_mZVB4 = Wherigo.ZTask(cartCoimbra)
_mZVB4.Id = "7d35a552-201b-4f0d-a5d4-ddf5ec960ac1"
_mZVB4.Name = "Use statue"
_mZVB4.Description = "You need to use the statue you collected before, the Cathedral just lost most of its content, help on renewing it."
_mZVB4.Visible = false
_mZVB4.Media = zmediaProfessor
_mZVB4.Active = false
_mZVB4.Complete = false
_mZVB4.CorrectState = "None"
_V8uS = Wherigo.ZTask(cartCoimbra)
_V8uS.Id = "b3d22fd8-667f-4333-9bed-ffae275bba24"
_V8uS.Name = "Use Triangle"
_V8uS.Description = "In order to get the hand from the Portagem, you first need to use the triangle you collected on the New Cathedral."
_V8uS.Visible = false
_V8uS.Media = zmediaProfessor
_V8uS.Active = false
_V8uS.Complete = false
_V8uS.CorrectState = "None"
_T3G = Wherigo.ZTask(cartCoimbra)
_T3G.Id = "05431dd2-7c9f-4b84-a67b-e74b97b5f35d"
_T3G.Name = "Use objects"
_T3G.Description = [[Malevolus is on the run, he is at the Train Station, going away. With the objects you have, you can stop him and make sure that the police will catch him.

Here you can use all the objects that you still have with you.
]]
_T3G.Visible = false
_T3G.Media = zmediaProfessor
_T3G.Active = false
_T3G.Complete = false
_T3G.CorrectState = "None"
_yWyx = Wherigo.ZTask(cartCoimbra)
_yWyx.Id = "18cc77ee-6959-4ca1-bc74-fa55826a8172"
_yWyx.Name = "Final"
_yWyx.Description = [[[EN]
You achieved it, now it's time to look for the Geocache.
Look also for your code on the items.
[PT]
Conseguiu chegar quase ao fim, agora e tempo de procurar a Geocache.
Deve ver tambem o codigo que permite registar este jogo em www.wherigo.com
]]
_yWyx.Visible = false
_yWyx.Media = zmediaProfessor
_yWyx.Active = false
_yWyx.Complete = false
_yWyx.CorrectState = "None"
_n4s = Wherigo.ZTask(cartCoimbra)
_n4s.Id = "48068478-a0cb-4c9a-8c4f-fa1dbf796304"
_n4s.Name = "Use Column"
_n4s.Description = [[You need to use the Column that you took from the Court to prevent this Aqueduct from falling.
]]
_n4s.Visible = false
_n4s.Media = zmediaProfessor
_n4s.Active = false
_n4s.Complete = false
_n4s.CorrectState = "None"
_h0l = Wherigo.ZTask(cartCoimbra)
_h0l.Id = "7547cce3-063d-4316-9389-767936f5d435"
_h0l.Name = "Ir ao Tribunal de Coimbra"
_h0l.Description = "Deve ir para o tribunal de Coimbra, la ira encontrar mais informacoes para continuar com a sua aventura. Foi de la que fugiu o Malevolus, portanto havera algo para verificar la."
_h0l.Visible = false
_h0l.Media = zmediaProfessor
_h0l.Active = false
_h0l.Complete = false
_h0l.CorrectState = "None"
_OYBgZ = Wherigo.ZTask(cartCoimbra)
_OYBgZ.Id = "79c2b6fc-1faf-4d4e-8432-e0045d66ac9d"
_OYBgZ.Name = "Ir para a Igreja de Nossa Senhora do Carmo"
_OYBgZ.Description = [[Deve agora derigir-se para a proxima paragem, a Igreja de Nossa Senhora do Carmo, um pouco mais a frente na Rua da Sofia. Mais pistas estaraao disponiveis neste local.
]]
_OYBgZ.Visible = false
_OYBgZ.Media = zmediaProfessor
_OYBgZ.Active = false
_OYBgZ.Complete = false
_OYBgZ.CorrectState = "None"
_5Tk = Wherigo.ZTask(cartCoimbra)
_5Tk.Id = "85f20f11-306e-42b6-954b-03d519f240d3"
_5Tk.Name = "Ir para o Cafe Santa Cruz"
_5Tk.Description = [[A proxima tarefa e procurar junto ao cafe de Santa Cruz, onde foi avista ha pouco tempo o Malevolus, quem sabe se o encontraremos por la...
]]
_5Tk.Visible = false
_5Tk.Media = zmediaProfessor
_5Tk.Active = false
_5Tk.Complete = false
_5Tk.CorrectState = "None"
_04Z = Wherigo.ZTask(cartCoimbra)
_04Z.Id = "4b02f559-1c5b-4b35-8cf9-d1775467d3fc"
_04Z.Name = "Ir para a Camara Municipal de Coimbra"
_04Z.Description = "Na Camara Municipal de Coimbra iremos encontrar um item que nos ira ajudar na aventura."
_04Z.Visible = false
_04Z.Media = zmediaProfessor
_04Z.Active = false
_04Z.Complete = false
_04Z.CorrectState = "None"
_udkY = Wherigo.ZTask(cartCoimbra)
_udkY.Id = "96f3807a-c8a4-43a3-8f6f-6e132a8def33"
_udkY.Name = "Ir para o Jardim da Manga"
_udkY.Description = [[O Jardim da Manga e um bom local para se esonder, vamos ver o que sera possivel la encontrar.
]]
_udkY.Visible = false
_udkY.Media = zmediaProfessor
_udkY.Active = false
_udkY.Complete = false
_udkY.CorrectState = "None"
_KHYA = Wherigo.ZTask(cartCoimbra)
_KHYA.Id = "67601ac1-dfd1-4396-b88f-37dd33a48fb6"
_KHYA.Name = "Ir para o Museu Machado de Castro"
_KHYA.Description = "Este Museu tem alguns itens muito importantes de Historia de Coimrba e uma vista magnifica para a parte antiga da cidade, sera que e possivel daqui ver o Malevolus?"
_KHYA.Visible = false
_KHYA.Media = zmediaProfessor
_KHYA.Active = false
_KHYA.Complete = false
_KHYA.CorrectState = "None"
_ZQPu = Wherigo.ZTask(cartCoimbra)
_ZQPu.Id = "a969726f-b651-428c-976f-a48a05b44770"
_ZQPu.Name = "Ir para o Mercado"
_ZQPu.Description = "No mercado poderemos comprar produtos frescos, e parece que o Malevolus esteve la recentemente."
_ZQPu.Visible = false
_ZQPu.Media = zmediaProfessor
_ZQPu.Active = false
_ZQPu.Complete = false
_ZQPu.CorrectState = "None"
_Uu5s = Wherigo.ZTask(cartCoimbra)
_Uu5s.Id = "34001016-c4ed-42a6-af03-558673a1d119"
_Uu5s.Name = "Ir para a vista panoramica"
_Uu5s.Description = "E a altura de subir ate um local onde temos uma vista panoramica da cidade Coimbra. La sera possivel observar varios locais, e quem sabe encontrar o Malevolus."
_Uu5s.Visible = false
_Uu5s.Media = zmediaProfessor
_Uu5s.Active = false
_Uu5s.Complete = false
_Uu5s.CorrectState = "None"
_tHrj6 = Wherigo.ZTask(cartCoimbra)
_tHrj6.Id = "ceea826b-4115-45e9-9c44-d16694e3c07b"
_tHrj6.Name = "Ir para o Patio da Inquisicao"
_tHrj6.Description = "Parace que recentemente viram o Malevolus no Patio da Inquisicao, sera que conseguimos encontrar la alguma informacao."
_tHrj6.Visible = false
_tHrj6.Media = zmediaProfessor
_tHrj6.Active = false
_tHrj6.Complete = false
_tHrj6.CorrectState = "None"
_MMoVA = Wherigo.ZTask(cartCoimbra)
_MMoVA.Id = "0ad0cecd-5e31-4556-b5f1-19f53b2ebcfb"
_MMoVA.Name = "Ir para a Portagem"
_MMoVA.Description = "Uma das entradas da cidade de Coimbra, la sera possivel encontrar algo para prosseguir a aventura."
_MMoVA.Visible = false
_MMoVA.Media = zmediaProfessor
_MMoVA.Active = false
_MMoVA.Complete = false
_MMoVA.CorrectState = "None"
_tMIo = Wherigo.ZTask(cartCoimbra)
_tMIo.Id = "05ffa954-2181-4657-8e06-419de9956618"
_tMIo.Name = "Ir para a Faculdade de Psicologia"
_tMIo.Description = "O Malevolus tinha alguns amigos a estudar na Faculdade de Psicologia, pelo que e um bom local para procurar."
_tMIo.Visible = false
_tMIo.Media = zmediaProfessor
_tMIo.Active = false
_tMIo.Complete = false
_tMIo.CorrectState = "None"
_txLs1 = Wherigo.ZTask(cartCoimbra)
_txLs1.Id = "ed684982-3e94-4bb2-9be9-845b9f219d58"
_txLs1.Name = "Ir para a Igreja de Santa Cruz"
_txLs1.Description = "Na Igreja de Santa Cruz poderemos encontrar mais alguma informacao para continuar na busca do Malevolus."
_txLs1.Visible = false
_txLs1.Media = zmediaProfessor
_txLs1.Active = false
_txLs1.Complete = false
_txLs1.CorrectState = "None"
_Ysiz = Wherigo.ZTask(cartCoimbra)
_Ysiz.Id = "17c30e42-b79d-424e-a3db-a38148543c47"
_Ysiz.Name = "Ir para a Se Nova"
_Ysiz.Description = "O local de grande interesse religioso em Coimbra, quem sabe se o Malevolus nao passou por aqui."
_Ysiz.Visible = false
_Ysiz.Media = zmediaProfessor
_Ysiz.Active = false
_Ysiz.Complete = false
_Ysiz.CorrectState = "None"
_mASe = Wherigo.ZTask(cartCoimbra)
_mASe.Id = "970589d4-434d-4e44-828d-5e19cde5991b"
_mASe.Name = "Ir para o Aqueduto dos Arcos de Jardim"
_mASe.Description = "O excelente local em Combra, tanto para os turistas como para o Malevolus se esconder..."
_mASe.Visible = false
_mASe.Media = zmediaProfessor
_mASe.Active = false
_mASe.Complete = false
_mASe.CorrectState = "None"
_5sXX = Wherigo.ZTask(cartCoimbra)
_5sXX.Id = "3e73521c-cd45-4497-8db3-b3cd16a790b3"
_5sXX.Name = "Ir para o Jardim Botanico"
_5sXX.Description = "E se o Malevolus escolheu o Jardim Botanico para se esconder... aqui tem muitos locais com vegetacao para o tornar quase invisivel."
_5sXX.Visible = false
_5sXX.Media = zmediaProfessor
_5sXX.Active = false
_5sXX.Complete = false
_5sXX.CorrectState = "None"
_5Z0 = Wherigo.ZTask(cartCoimbra)
_5Z0.Id = "2c7bdc2a-c20f-4113-b9a7-3bf05ed40840"
_5Z0.Name = "Ir para o Laboratorio Quimico"
_5Z0.Description = "O Malevolus chegou a trabalhar neste laboratorio, sera que o encontraremos aqui?"
_5Z0.Visible = false
_5Z0.Media = zmediaProfessor
_5Z0.Active = false
_5Z0.Complete = false
_5Z0.CorrectState = "None"
_JPnuw = Wherigo.ZTask(cartCoimbra)
_JPnuw.Id = "35a838ff-a5a9-42a5-827c-237d05ef3f50"
_JPnuw.Name = "Ir para o Governo Civil de Coimbra"
_JPnuw.Description = "Um local com uma excelente vista para o Rio Mondego e para a Ponte de Santa Clara, provavelmente o Malevolus esta proximo."
_JPnuw.Visible = false
_JPnuw.Media = zmediaProfessor
_JPnuw.Active = false
_JPnuw.Complete = false
_JPnuw.CorrectState = "None"
_Ws4 = Wherigo.ZTask(cartCoimbra)
_Ws4.Id = "990d403e-0b4f-4a02-8864-5fadb3013963"
_Ws4.Name = "Ir para o Praca do D. Dinis"
_Ws4.Description = "Um local cheio de estudantes, que estao sempre a passar nesta praca, quem sabe tenham alguma informacao sobre o Malevolus."
_Ws4.Visible = false
_Ws4.Media = zmediaProfessor
_Ws4.Active = false
_Ws4.Complete = false
_Ws4.CorrectState = "None"
_HRO = Wherigo.ZTask(cartCoimbra)
_HRO.Id = "f36cb63d-220a-4879-aa3e-aaa05da8b91b"
_HRO.Name = "Ir para o Rio Mondego"
_HRO.Description = "E a altura de terminar a aventura, aqui nas margens do Mondego temos umas excelentes vistas."
_HRO.Visible = false
_HRO.Media = zmediaProfessor
_HRO.Active = false
_HRO.Complete = false
_HRO.CorrectState = "None"
_jD3W = Wherigo.ZTask(cartCoimbra)
_jD3W.Id = "30923126-f7ea-47e0-b003-49fcfb34142a"
_jD3W.Name = "Ir para as escadas Monumentais"
_jD3W.Description = "Estas escadas sao uma das principais entradas na Universidade, o que poderemos la encontrar?"
_jD3W.Visible = false
_jD3W.Media = zmediaProfessor
_jD3W.Active = false
_jD3W.Complete = false
_jD3W.CorrectState = "None"
_bzYd = Wherigo.ZTask(cartCoimbra)
_bzYd.Id = "14b2a0f7-38e4-49e1-951e-63e6471a0707"
_bzYd.Name = "Ir para a Praca do Comercio"
_bzYd.Description = "Uma praca em Coimbra, situada na Baixa da cidade, sera que encontraremos por la o Malevolus?"
_bzYd.Visible = false
_bzYd.Media = zmediaProfessor
_bzYd.Active = false
_bzYd.Complete = false
_bzYd.CorrectState = "None"
_5AuV = Wherigo.ZTask(cartCoimbra)
_5AuV.Id = "0b8f3736-a909-4f82-acff-c8a9eaaed78f"
_5AuV.Name = "Ir para as escadas do Quebra Costas"
_5AuV.Description = "Parece que todos passam por estas escadas, devemos perguntar a mulher da estatua se ela viu por aqui o Malevolus."
_5AuV.Visible = false
_5AuV.Media = zmediaProfessor
_5AuV.Active = false
_5AuV.Complete = false
_5AuV.CorrectState = "None"
_1AIN = Wherigo.ZTask(cartCoimbra)
_1AIN.Id = "1b4a55f6-80e8-40a9-9a4f-1a8b8195adb7"
_1AIN.Name = "Ir para Se Velha"
_1AIN.Description = "Um dos Monumentos mais importantes em Coimbra, e um excelente local para efectuar uma paragem."
_1AIN.Visible = false
_1AIN.Media = zmediaProfessor
_1AIN.Active = false
_1AIN.Complete = false
_1AIN.CorrectState = "None"
_rTL0 = Wherigo.ZTask(cartCoimbra)
_rTL0.Id = "bd7c15d8-f8a9-4625-af04-f49e818129d1"
_rTL0.Name = "Ir para a Estacao de Comboios"
_rTL0.Description = "Parece que o Malevolus planeia explodir um comboio nesta estacao, precisamos de o PARAR. Aqui devera utilizar todosos objectos que traz para terminar as suas accoes."
_rTL0.Visible = false
_rTL0.Media = zmediaProfessor
_rTL0.Active = false
_rTL0.Complete = false
_rTL0.CorrectState = "None"
_xZ6IR = Wherigo.ZTask(cartCoimbra)
_xZ6IR.Id = "d72be96c-8dc8-45ae-8382-91d6b0eef172"
_xZ6IR.Name = "Ir para a Universidade"
_xZ6IR.Description = "Estamos no centro da Universidade, todos os estudantes passam por aqui, certamente encontra aqui novas pistas."
_xZ6IR.Visible = false
_xZ6IR.Media = zmediaProfessor
_xZ6IR.Active = false
_xZ6IR.Complete = false
_xZ6IR.CorrectState = "None"
_6qZO = Wherigo.ZTask(cartCoimbra)
_6qZO.Id = "9a059e07-f65e-4329-81c0-d535077c27c1"
_6qZO.Name = "Reparar o Aqueduto"
_6qZO.Description = "Sera necessario utilizar  o objecto que obteve no tribunal (a coluna), para que o Aqueduto se mantenha intacto e nao caia."
_6qZO.Visible = false
_6qZO.Media = zmediaProfessor
_6qZO.Active = false
_6qZO.Complete = false
_6qZO.CorrectState = "None"
_jhB = Wherigo.ZTask(cartCoimbra)
_jhB.Id = "6973e6a3-fdea-44ec-a0a3-17e2adc40c35"
_jhB.Name = "Utilizar a coluna"
_jhB.Description = "Deve utilizar a coluna que obteve no tribunal para evitar que o Aqueduto seja destruido."
_jhB.Visible = false
_jhB.Media = zmediaProfessor
_jhB.Active = false
_jhB.Complete = false
_jhB.CorrectState = "None"
_FWM3A = Wherigo.ZTask(cartCoimbra)
_FWM3A.Id = "6297eeba-7dc9-446e-b99a-59c6444505f7"
_FWM3A.Name = "Utilizar objectos"
_FWM3A.Description = "Aqui devera utilizar todos os objectos que ainda tem. Para alem de os mesmos serem utilizados para impedir que o Malevolus consiga fugir num comboio tera ainda acesso a mais pontuacao nesta aventura."
_FWM3A.Visible = false
_FWM3A.Media = zmediaProfessor
_FWM3A.Active = false
_FWM3A.Complete = false
_FWM3A.CorrectState = "None"
_Ta2cL = Wherigo.ZTask(cartCoimbra)
_Ta2cL.Id = "5a319dd1-94ee-4db6-9427-94ddfbcd3c3f"
_Ta2cL.Name = "Utilizar a estatua"
_Ta2cL.Description = "Deve utilizar a estatua que obteve anteriormente, a Se perdeu recentemente grande parte do seu conteudo, e altura de ajudar na sua renovacao."
_Ta2cL.Visible = false
_Ta2cL.Media = zmediaProfessor
_Ta2cL.Active = false
_Ta2cL.Complete = false
_Ta2cL.CorrectState = "None"
_dqmB3 = Wherigo.ZTask(cartCoimbra)
_dqmB3.Id = "d7b318fa-f12f-47d3-922e-a5d9f3be88a9"
_dqmB3.Name = "Utilize a fonte"
_dqmB3.Description = [[Devera utilizar a fonte aqui.
Nao existe agua no museu, o Malevolus destruiu o abastecimento quando passou por aqui.]]
_dqmB3.Visible = false
_dqmB3.Media = zmediaProfessor
_dqmB3.Active = false
_dqmB3.Complete = false
_dqmB3.CorrectState = "None"
__bnFq = Wherigo.ZTask(cartCoimbra)
__bnFq.Id = "8a3df4a0-00eb-4707-8e1f-e69b6986f754"
__bnFq.Name = "Utilize o candeeiro"
__bnFq.Description = [[Quando o Malevolus passou pela Faculdade de Psicologia, ha pouco tempo, ele destruiu toda a iluminacao, agora e a altura de ajudar restabelecer a iluminacao.
Sera que tem algum objecto que o pode ajudar?]]
__bnFq.Visible = false
__bnFq.Media = zmediaProfessor
__bnFq.Active = false
__bnFq.Complete = false
__bnFq.CorrectState = "None"
_Y_jG = Wherigo.ZTask(cartCoimbra)
_Y_jG.Id = "2846e23a-2052-456b-9d41-e793a8637224"
_Y_jG.Name = "Utilize o triangulo"
_Y_jG.Description = "Para que possa aceder ao simbolo da mao, necessita em primeiro lugar de utilizar o triangulo que obteve na Se Nova."
_Y_jG.Visible = false
_Y_jG.Media = zmediaProfessor
_Y_jG.Active = false
_Y_jG.Complete = false
_Y_jG.CorrectState = "None"

-- Cartridge Variables --
azulejos = 0
Color_mercado = ""
Numerodetelefone = ""
Data_1 = 0
Data_de_Santa_Cruz = 0
Pontuacao = 0
_hRs = ""
_Q3F = ""
_TI1 = ""
_YeFf = 0
lang = [[PORTUGUES
]]
_2_Nn = false
_qiAU = false
_Gpe = true
_Yn5T = false
_t2yz = true
_ujvjx = false
_AVqo = false
_k56 = false
_AjS8 = false
__3Ohc = false
_5wjX = false
_DL74t = false
_0duLV = false
_2sNt_ = false
_7jj = false
_ISCF = false
_h7G = false
_LEG = false
_J9bwF = false
_PNq = false
_4YZ = false
_h5so = false
_Jbco = false
_ZR3h = false
_GkFvM = false
_w0S = false
__FZr = false
_JRzS = false
_MXx29 = false
_HULI = "zoneTribunal"
_sH1Ve = "zcharacterProfessor"
_DmvW = "zitemItem_01_coluna_tribunal"
_KYOdm = "ztaskGotototribunal"
_V3hrk = "zinputObternumerodetelefone"
_lUY = "dummy"
cartCoimbra.ZVariables = {
	azulejos = 0, 
	Color_mercado = "", 
	Numerodetelefone = "", 
	Data_1 = 0, 
	Data_de_Santa_Cruz = 0, 
	Pontuacao = 0, 
	_hRs = "", 
	_Q3F = "", 
	_TI1 = "", 
	_YeFf = 0, 
	lang = [[PORTUGUES
]], 
	_2_Nn = false, 
	_qiAU = false, 
	_Gpe = true, 
	_Yn5T = false, 
	_t2yz = true, 
	_ujvjx = false, 
	_AVqo = false, 
	_k56 = false, 
	_AjS8 = false, 
	__3Ohc = false, 
	_5wjX = false, 
	_DL74t = false, 
	_0duLV = false, 
	_2sNt_ = false, 
	_7jj = false, 
	_ISCF = false, 
	_h7G = false, 
	_LEG = false, 
	_J9bwF = false, 
	_PNq = false, 
	_4YZ = false, 
	_h5so = false, 
	_Jbco = false, 
	_ZR3h = false, 
	_GkFvM = false, 
	_w0S = false, 
	__FZr = false, 
	_JRzS = false, 
	_MXx29 = false, 
	_HULI = "zoneTribunal", 
	_sH1Ve = "zcharacterProfessor", 
	_DmvW = "zitemItem_01_coluna_tribunal", 
	_KYOdm = "ztaskGotototribunal", 
	_V3hrk = "zinputObternumerodetelefone", 
	_lUY = "dummy"
}

-- Timers --

-- Inputs --
zinputObternumerodetelefone = Wherigo.ZInput(cartCoimbra)
zinputObternumerodetelefone.Id = "aa758112-d125-4c0d-909c-dd87c1a9ed7e"
zinputObternumerodetelefone.Name = "Get phone number"
zinputObternumerodetelefone.Description = ""
zinputObternumerodetelefone.Visible = false
zinputObternumerodetelefone.Media = _7oHN
zinputObternumerodetelefone.Choices = {
	"239829681", 
	"239829682", 
	"239829683", 
	"None of the above"
}
zinputObternumerodetelefone.InputType = "MultipleChoice"
zinputObternumerodetelefone.Text = [[Look at the phone booth and search for the number that is writen there.
What is the number?]]
zinputObter_data_1 = Wherigo.ZInput(cartCoimbra)
zinputObter_data_1.Id = "7bee236d-76ec-40ac-8d81-7873a1ef7d2d"
zinputObter_data_1.Name = "Get date at Igreja de Nossa Senhora do Carmo"
zinputObter_data_1.Description = ""
zinputObter_data_1.Visible = false
zinputObter_data_1.Media = _7oHN
zinputObter_data_1.Choices = {
	"1531", 
	"1542", 
	"1562"
}
zinputObter_data_1.InputType = "MultipleChoice"
zinputObter_data_1.Text = "You have to find the year when this Church was founded, it is very important for the future of your adventure"
zinputObternumeroazulejos = Wherigo.ZInput(cartCoimbra)
zinputObternumeroazulejos.Id = "c4c3974b-1a4a-4220-bd61-d1adb05143c0"
zinputObternumeroazulejos.Name = "Get number of tiles "
zinputObternumeroazulejos.Description = ""
zinputObternumeroazulejos.Visible = true
zinputObternumeroazulejos.Media = zmediapatio_azulejo
zinputObternumeroazulejos.Choices = {
	"4", 
	"6", 
	"8"
}
zinputObternumeroazulejos.InputType = "MultipleChoice"
zinputObternumeroazulejos.Text = "Look for an inscription  Patio da inquisicao , pointing to the left. How many tiles are on this?"
zinputGetDataSantaCruz = Wherigo.ZInput(cartCoimbra)
zinputGetDataSantaCruz.Id = "487d75b6-0eaa-409b-8aad-d88de7d80057"
zinputGetDataSantaCruz.Name = "Get Date Santa Cruz"
zinputGetDataSantaCruz.Description = ""
zinputGetDataSantaCruz.Visible = true
zinputGetDataSantaCruz.Media = _7oHN
zinputGetDataSantaCruz.Choices = {
	"1100", 
	"1131", 
	"1151"
}
zinputGetDataSantaCruz.InputType = "MultipleChoice"
zinputGetDataSantaCruz.Text = "Look for the date when this old Church was founded: It will be a variable on the equation to find Malevolus."
zinputGetColor = Wherigo.ZInput(cartCoimbra)
zinputGetColor.Id = "7854e6c0-f253-42e9-b14e-a357e0cf5fdb"
zinputGetColor.Name = "Get Color Market"
zinputGetColor.Description = "What color is the roof of the market?"
zinputGetColor.Visible = false
zinputGetColor.Media = _7oHN
zinputGetColor.Choices = {
	"Green", 
	"Brown", 
	"Blue"
}
zinputGetColor.InputType = "MultipleChoice"
zinputGetColor.Text = "What color is the roof of the market?"
_y9HM = Wherigo.ZInput(cartCoimbra)
_y9HM.Id = "ec9548ec-f334-4002-8f50-89b4358961d6"
_y9HM.Name = "D.Dinis"
_y9HM.Description = ""
_y9HM.Visible = true
_y9HM.Media = _7oHN
_y9HM.Choices = {
	"MCCLXI", 
	"MCCLXIII", 
	"MCCLXVI"
}
_y9HM.InputType = "MultipleChoice"
_y9HM.Text = [[[EN]
What is the year that you can find first in Roman inscription?
[PT]
Qual e o ano que encontra em primeiro lugar na inscricao da estatua em numeracao romana?]]
_kMR0 = Wherigo.ZInput(cartCoimbra)
_kMR0.Id = "e6f37d1b-e345-47a8-82ee-73ebec64047d"
_kMR0.Name = "Arcos"
_kMR0.Description = ""
_kMR0.Visible = true
_kMR0.Media = _7oHN
_kMR0.InputType = "Text"
_kMR0.Text = ""
_Hykon = Wherigo.ZInput(cartCoimbra)
_Hykon.Id = "942c9fa4-cc6a-4a72-9966-0ecb50b3bf10"
_Hykon.Name = "Botanico"
_Hykon.Description = ""
_Hykon.Visible = true
_Hykon.Media = _7oHN
_Hykon.Choices = {
	"1836", 
	"1838", 
	"1936"
}
_Hykon.InputType = "MultipleChoice"
_Hykon.Text = [[[EN]
In which year was demolished the Traitors gate?
[PT]
Em que ano foi demolida a Porta da Traicao?]]
_bRnJ = Wherigo.ZInput(cartCoimbra)
_bRnJ.Id = "1672b255-febf-46ca-8335-80027a8b14c2"
_bRnJ.Name = "GameOver"
_bRnJ.Description = ""
_bRnJ.Visible = true
_bRnJ.InputType = "Text"
_bRnJ.Text = "Please insert your name"
_5CW = Wherigo.ZInput(cartCoimbra)
_5CW.Id = "d7950958-5f31-4002-bb0e-dbd83c6f91d6"
_5CW.Name = "Escolhe Idioma"
_5CW.Description = ""
_5CW.Visible = true
_5CW.Media = zmediaProfessor
_5CW.Choices = {
	"PORTUGUES", 
	"INGLES"
}
_5CW.InputType = "MultipleChoice"
_5CW.Text = [[[EN] Please choose the language for the Game.
[PT] Por favor escolha o idioma que pretende utilizar neste jogo]]
_TAHim = Wherigo.ZInput(cartCoimbra)
_TAHim.Id = "115265d9-08ec-4391-bbc5-c3d25b75f9ee"
_TAHim.Name = "Obter data Igreja Nossa Senhora do Carmo"
_TAHim.Description = ""
_TAHim.Visible = false
_TAHim.Media = _7oHN
_TAHim.Icon = _7oHN
_TAHim.Choices = {
	"1531", 
	"1542", 
	"1562"
}
_TAHim.InputType = "MultipleChoice"
_TAHim.Text = "Deve verificar a data em que esta Igreja foi fundada. Escolha o valor corredto."
_brUf = Wherigo.ZInput(cartCoimbra)
_brUf.Id = "46ad82d9-c9f9-4863-be32-6efd18968ce9"
_brUf.Name = "Obter numero de azulejos"
_brUf.Description = ""
_brUf.Visible = false
_brUf.Media = zmediapatio_azulejo
_brUf.Choices = {
	"4", 
	"6", 
	"8"
}
_brUf.InputType = "MultipleChoice"
_brUf.Text = "Procure uma inscricao em azulejo, identica a da imagem mostrada (\"Patio da Inquisicao\" - com uma seta para a esquerda). Quantos azulejos encontra la inseridos?"
_YkI = Wherigo.ZInput(cartCoimbra)
_YkI.Id = "39ae4e97-e0a5-4e55-9914-91583a44958c"
_YkI.Name = "Obter data na Igreja de Santa Cruz"
_YkI.Description = ""
_YkI.Visible = false
_YkI.Media = _7oHN
_YkI.Choices = {
	"1100", 
	"1131", 
	"1151"
}
_YkI.InputType = "MultipleChoice"
_YkI.Text = [[Indique a data em que esta igreja foi construida.
Sera um dado importante para prosseguir na procura do Malevolus.]]
_m9en = Wherigo.ZInput(cartCoimbra)
_m9en.Id = "cd0b865f-0bb4-48fd-9777-212405e5e1d4"
_m9en.Name = "Obter a cor do mercado"
_m9en.Description = [[Qual e a cor do telhado do mercado?
]]
_m9en.Visible = true
_m9en.Media = _7oHN
_m9en.Choices = {
	"Verde", 
	"Castanho", 
	"Azul"
}
_m9en.InputType = "MultipleChoice"
_m9en.Text = [[Qual e a cor do telhado do mercado?
]]
_xR4 = Wherigo.ZInput(cartCoimbra)
_xR4.Id = "a87fd9fa-c35e-4de3-afe4-cdece84d2bb3"
_xR4.Name = "Obter o numero de telefone"
_xR4.Description = ""
_xR4.Visible = false
_xR4.Media = _7oHN
_xR4.Choices = {
	"239829681", 
	"239829682", 
	"239829683", 
	"Nenhum dos acima"
}
_xR4.InputType = "MultipleChoice"
_xR4.Text = [[Procure uma cabine telefonica e procure o numero que la se encontra inscrito.
Indique por favor o numero:
]]

-- WorksWithList for object commands --

-- functions --
function cartCoimbra:OnStart()
	if (_G[_DvUW("\108\001\052")][_DvUW("\104\069\064\047\102\031\073\080")] == _DvUW("\028\118\001\082\044")) or (_G[_DvUW("\108\001\052")][_DvUW("\056\058\052\118\015\058\068\056")] == _DvUW("\056\058\051\039\047\031\053")) then
		for k, v in pairs(_G[_DvUW("\015\064\073\047\113\031\118\080\106\073\064")][_DvUW("\119\069\069\099\030\106\077\058\015\047\051")]) do
			v[_DvUW("\090\118\051\118\106\069\058")] = false
			v[_DvUW("\119\015\047\118\052\058")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_DvUW("\092\108\097\007\101\075\032\088\018\031\073\073\035\124\033\035\031\070\033\114\064\052\058\033\047\031\033\053\069\064\035\033\047\114\118\051\033\031\001\033\047\114\058\033\051\047\073\058\058\047\078\101\075\032\088\092\104\109\007\101\075\032\088\109\058\080\033\062\070\058\033\070\047\118\069\118\042\064\073\033\058\051\047\058\033\077\031\065\031\033\058\080\033\113\031\118\080\106\073\064")), 
			Callback = function(action)
				if action ~= nil then
					_G[_DvUW("\028\114\058\073\118\065\031")][_DvUW("\113\031\080\080\064\001\095")](_DvUW("\018\064\052\058\113\069\031\051\058"))
				end
			end
		}
		return
	end
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_5CW)
	end)
	zoneTribunal.Active = true
	zoneTribunal.Visible = true
	zcharacterProfessor:MoveTo(zoneTribunal)
	zitemItem_01_coluna_tribunal:MoveTo(zoneTribunal)
	ztaskGotototribunal.Visible = true
	ztaskGotototribunal.Active = true
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
	else
	end
	zoneCamaraMunicipaldeCoimbra.Active = true
	zoneCamaraMunicipaldeCoimbra.Visible = true
	ztaskGotoCityHall.Active = true
	ztaskGotoCityHall.Visible = true
end
function cartCoimbra:OnRestore()
end
function cartCoimbra:OnSync()
	_Urwigo.MessageBox{
		Text = [[[EN]
Saving the Game.
[PT]
A gravar o jogo.
]]
	}
end
function zoneTribunal:OnEnter()
	_HULI = "zoneTribunal"
	if _Gpe == true then
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_Urwigo.OldDialog{
				{
					Text = "Aqui tem um objecto para levar, olhe para o tribunal e procure a coluna. Este objecto vai-lhe ser util mais a frente.", 
					Media = zmediaProfessor
				}
			}
		else
			_Urwigo.OldDialog{
				{
					Text = "Here you have an object to pick, please look in to the \"Tribunal\" (Court) and look for it.", 
					Media = zmediaProfessor
				}
			}
		end
		zoneTribunal.Visible = true
		zoneTribunal.Active = true
		zitemItem_01_coluna_tribunal.Visible = true
		ztaskGotototribunal.Visible = false
		ztaskGotototribunal.Active = false
		_h0l.Active = false
		zoneCamaraMunicipaldeCoimbra.Visible = false
		ztaskGotoCityHall.Visible = false
		ztaskGotoCityHall.Active = false
		_04Z.Active = false
		_04Z.Visible = false
	else
	end
end
function zoneIgrejadeNossaSenhoradoCarmo:OnEnter()
	_HULI = "zoneIgrejadeNossaSenhoradoCarmo"
	if _Yn5T == true then
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneIgrejadeNossaSenhoradoCarmo)
		zoneIgrejadeNossaSenhoradoCarmo.Visible = true
		zoneIgrejadeNossaSenhoradoCarmo.Active = true
		ztaskGotoIgrejadeNossaSenhoradoCarmo.Complete = true
		_OYBgZ.Complete = true
		zoneTribunal.Active = false
		zoneTribunal.Visible = false
		_GFp1:MoveTo(zoneIgrejadeNossaSenhoradoCarmo)
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			__fyV.Visible = true
			__fyV.Commands._JyZIq.Enabled = true
			__fyV:MoveTo(zoneIgrejadeNossaSenhoradoCarmo)
		else
			_GFp1.Visible = true
			_GFp1.Commands._ra_.Enabled = true
			_GFp1:MoveTo(zoneIgrejadeNossaSenhoradoCarmo)
		end
		ztaskGotoIgrejadeNossaSenhoradoCarmo.Active = false
		ztaskGotoIgrejadeNossaSenhoradoCarmo.Visible = false
		_OYBgZ.Active = false
		_OYBgZ.Visible = false
		_Yn5T = false
		cartCoimbra:RequestSync()
	else
	end
end
function zonePatiodaInquisicao:OnEnter()
	_HULI = "zonePatiodaInquisicao"
	if _AVqo == true then
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zonePatiodaInquisicao)
		zoneIgrejadeNossaSenhoradoCarmo.Active = false
		zoneIgrejadeNossaSenhoradoCarmo.Active = false
		zoneIgrejadeNossaSenhoradoCarmo.Visible = false
		zonePatiodaInquisicao.Active = true
		zonePatiodaInquisicao.Visible = true
		ztaskGotoPatiodainquisicao.Active = false
		ztaskGotoPatiodainquisicao.Visible = false
		zoneCamaraMunicipaldeCoimbra.Active = false
		zoneCamaraMunicipaldeCoimbra.Visible = false
		ztaskGotoCityHall.Visible = false
		ztaskGotoCityHall.Active = false
		--[[Portugues]]
		_tHrj6.Active = false
		_tHrj6.Visible = false
		_04Z.Active = false
		_04Z.Visible = false
		--[[Questao]]
		--[[]]
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_tT6.Visible = true
			_tT6:MoveTo(zonePatiodaInquisicao)
			_tT6.Commands._FQf0.Enabled = true
		else
			_W7B.Visible = true
			_W7B:MoveTo(zonePatiodaInquisicao)
		end
		_AVqo = false
		_t2yz = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneCamaraMunicipaldeCoimbra:OnEnter()
	_HULI = "zoneCamaraMunicipaldeCoimbra"
	if _t2yz == true then
		ztaskGotototribunal.Visible = false
		ztaskGotototribunal.Active = false
		_h0l.Active = false
		_h0l.Visible = false
		zoneTribunal.Visible = false
		zoneTribunal.Active = false
		zoneIgrejadeNossaSenhoradoCarmo.Visible = false
		_Gpe = false
		zoneIgrejadeNossaSenhoradoCarmo.Active = false
		zonePatiodaInquisicao.Visible = false
		zonePatiodaInquisicao.Active = false
		--[[FIM DO PORTUGUES]]
		_tHrj6.Visible = false
		_tHrj6.Active = false
		_04Z.Visible = false
		_04Z.Active = false
		--[[PORTUGUES]]
		ztaskGotoCityHall.Visible = false
		ztaskGotoCityHall.Active = false
		ztaskGotoPatiodainquisicao.Visible = false
		ztaskGotoPatiodainquisicao.Active = false
		zitemItem_02_candeeiro_Cmc.Visible = true
		zitemItem_02_candeeiro_Cmc:MoveTo(zoneCamaraMunicipaldeCoimbra)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneCamaraMunicipaldeCoimbra)
		_t2yz = false
		_AVqo = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneIgrejadeSantaCruz:OnEnter()
	_HULI = "zoneIgrejadeSantaCruz"
	if _ujvjx == true then
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneIgrejadeSantaCruz)
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_MTAk:MoveTo(zoneIgrejadeSantaCruz)
			_MTAk.Commands._j7whM.Enabled = true
			_MTAk.Visible = true
		else
			_m5_x6:MoveTo(zoneIgrejadeSantaCruz)
			_m5_x6.Visible = true
			_m5_x6.Visible = true
		end
		ztaskGotoSantaCruzChurch.Active = false
		ztaskGotoSantaCruzChurch.Visible = false
		zoneCamaraMunicipaldeCoimbra.Active = false
		zoneCamaraMunicipaldeCoimbra.Visible = false
		_txLs1.Active = false
		_txLs1.Visible = false
		_ujvjx = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneCafedeSantaCruz:OnEnter()
	_HULI = "zoneCafedeSantaCruz"
	if _k56 == true then
		zitemitem_03_dragao_cafe_santa_Cruz:MoveTo(zoneCafedeSantaCruz)
		zitemitem_03_dragao_cafe_santa_Cruz.Visible = true
		ztaskGotoCafeSantaCruz.Visible = false
		ztaskGotoCafeSantaCruz.Active = false
		_5Tk.Active = false
		_5Tk.Visible = false
		zoneIgrejadeSantaCruz.Active = false
		zoneIgrejadeSantaCruz.Visible = false
		_k56 = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneJardimdaManga:OnEnter()
	_HULI = "zoneJardimdaManga"
	if _AjS8 == true then
		ztaskGotoJardimdaManga.Active = false
		ztaskGotoJardimdaManga.Visible = false
		_udkY.Active = false
		_udkY.Visible = false
		zitemitem_04_fonte_jardim_da_manga:MoveTo(zoneJardimdaManga)
		zitemitem_04_fonte_jardim_da_manga.Visible = true
		zoneCafedeSantaCruz.Active = false
		zoneCafedeSantaCruz.Visible = false
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneJardimdaManga)
		_AjS8 = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneMercadoMunicipal:OnEnter()
	_HULI = "zoneMercadoMunicipal"
	if __3Ohc == true then
		zoneJardimdaManga.Active = false
		zoneJardimdaManga.Visible = false
		ztaskGotoMercado.Active = false
		ztaskGotoMercado.Visible = false
		_ZQPu.Active = false
		_ZQPu.Visible = false
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_Mz8:MoveTo(zoneMercadoMunicipal)
			_Mz8.Visible = true
		else
			_jokfZ:MoveTo(zoneMercadoMunicipal)
			_jokfZ.Visible = true
		end
		__3Ohc = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneFaculdadedePsicologia:OnEnter()
	_HULI = "zoneFaculdadedePsicologia"
	if _5wjX == true then
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			__bnFq.Active = true
			__bnFq.Visible = true
		else
			_HPWA.Active = true
			_HPWA.Visible = true
		end
		zitemItem_02_candeeiro_Cmc.Commands._vRpC.Enabled = true
		zoneMercadoMunicipal.Active = false
		zoneMercadoMunicipal.Visible = false
		ztaskGotoFaculdadedePsicologia.Active = false
		ztaskGotoFaculdadedePsicologia.Visible = false
		_tMIo.Active = false
		_tMIo.Visible = false
		_5wjX = false
		_DL74t = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneVistaPanormica:OnEnter()
	_HULI = "zoneVistaPanormica"
	if _DL74t == true then
		zoneMercadoMunicipal.Active = false
		zoneMercadoMunicipal.Visible = false
		zoneFaculdadedePsicologia.Active = false
		zoneFaculdadedePsicologia.Visible = false
		zoneSVelha.Visible = false
		zoneSVelha.Active = false
		_5lfuU.Active = false
		_5lfuU.Visible = false
		_1AIN.Active = false
		_1AIN.Visible = false
		_wBvz.Active = false
		_wBvz.Visible = false
		_Uu5s.Active = false
		_Uu5s.Visible = false
		_zkXRs:MoveTo(zoneVistaPanormica)
		_mY0:MoveTo(zoneVistaPanormica)
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_mY0.Visible = true
		else
			_zkXRs.Visible = true
		end
		_DL74t = false
		_5wjX = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneLabQuimico:OnEnter()
	_HULI = "zoneLabQuimico"
	if _0duLV == true then
		_zZVdF.Active = false
		_zZVdF.Visible = false
		_5Z0.Active = false
		_5Z0.Visible = false
		zoneVistaPanormica.Active = false
		zoneVistaPanormica.Visible = false
		zitemitem_06_lab_quimico:MoveTo(zoneLabQuimico)
		zitemitem_06_lab_quimico.Visible = true
		_0duLV = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneDomDinis:OnEnter()
	_HULI = "zoneDomDinis"
	if _2sNt_ == true then
		_s98.Active = false
		_s98.Visible = false
		_xZ6IR.Active = false
		_xZ6IR.Visible = false
		_zIT.Active = false
		_zIT.Visible = false
		_Ws4.Active = false
		_Ws4.Visible = false
		zoneLabQuimico.Active = false
		zoneLabQuimico.Visible = false
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_g_bu:MoveTo(zoneDomDinis)
			_g_bu.Visible = true
		else
			_g_bu:MoveTo(zoneDomDinis)
			_g_bu.Visible = true
		end
		_2sNt_ = false
		_LEG = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneEscadasMonumentais:OnEnter()
	_HULI = "zoneEscadasMonumentais"
	if _7jj == true then
		zoneDomDinis.Active = false
		zoneDomDinis.Visible = false
		_EtzTn.Active = false
		_EtzTn.Visible = false
		_jD3W.Active = false
		_jD3W.Visible = false
		zitemitem_07_bola_escadas_monumentais.Visible = true
		zitemitem_07_bola_escadas_monumentais:MoveTo(zoneEscadasMonumentais)
		zitemitem_03_dragao_cafe_santa_Cruz.Commands._2H9FN.Enabled = true
		_7jj = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneArcosdeJardim:OnEnter()
	_HULI = "zoneArcosdeJardim"
	if _ISCF == true then
		zoneArcosdeJardim.Active = false
		zoneArcosdeJardim.Visible = false
		zoneEscadasMonumentais.Active = false
		zoneEscadasMonumentais.Visible = false
		_J1B.Active = false
		_J1B.Visible = false
		_mASe.Active = false
		_mASe.Visible = false
		zitemItem_01_coluna_tribunal.Commands._jnO.Enabled = true
		if _MXx29 == true then
			if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
				_jhB.Active = true
				_jhB.Visible = true
			else
				_n4s.Active = true
				_n4s.Visible = true
			end
		else
			if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
				_Urwigo.MessageBox{
					Text = [[Como optou por nao ir ao Tribunal, falta-lhe aqui um objecto para utilizar...
Vamos continuar a nossa aventura, agora em direccao ao Jardim Botanico.]]
				}
			else
				_Urwigo.MessageBox{
					Text = [[Once you started without going to the Court, you don't have an object needed here...
We will continue our adventure going to the Botanical Garden.]]
				}
			end
			if lang ~= "PORTUGUES" then
				_5sXX.Active = true
				_5sXX.Visible = true
			else
				_Ikf.Active = true
				_Ikf.Visible = true
			end
			zoneJardimBotanico.Active = true
			zoneJardimBotanico.Visible = true
			_h7G = true
		end
		_ISCF = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneJardimBotanico:OnEnter()
	_HULI = "zoneJardimBotanico"
	if _h7G == true then
		zoneArcosdeJardim.Active = false
		zoneArcosdeJardim.Visible = false
		_Ikf.Active = false
		_Ikf.Visible = false
		_5sXX.Active = false
		_5sXX.Visible = false
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_OcS8.Visible = true
			_OcS8:MoveTo(zoneJardimBotanico)
		else
			_jEM.Visible = true
			_jEM:MoveTo(zoneJardimBotanico)
		end
		_h7G = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneUniversidadeFaculdadedeLetras:OnEnter()
	_HULI = "zoneUniversidadeFaculdadedeLetras"
	if _LEG == true then
		_s98.Active = false
		_s98.Visible = false
		zoneJardimBotanico.Active = false
		zoneJardimBotanico.Visible = false
		zoneLabQuimico.Active = false
		zoneLabQuimico.Visible = false
		zitemitem_09_estatua_fac_letras:MoveTo(zoneUniversidadeFaculdadedeLetras)
		zitemitem_09_estatua_fac_letras.Visible = true
		zoneDomDinis.Active = false
		zoneDomDinis.Visible = false
		_zIT.Active = false
		_zIT.Visible = false
		_xZ6IR.Active = false
		_xZ6IR.Visible = false
		_Ws4.Active = false
		_Ws4.Visible = false
		_LEG = false
		_2sNt_ = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneSeNova:OnEnter()
	_HULI = "zoneSeNova"
	if _PNq == true then
		zoneMuseuMachadodeCastroIgreja.Active = false
		zoneMuseuMachadodeCastroIgreja.Visible = false
		zoneUniversidadeFaculdadedeLetras.Active = false
		zitemitem_04_fonte_jardim_da_manga.Commands._CKr.Enabled = false
		zoneUniversidadeFaculdadedeLetras.Visible = false
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_Ysiz.Active = false
			_Ysiz.Visible = false
			_dqmB3.Active = false
			_dqmB3.Visible = false
			_KHYA.Active = false
			_KHYA.Visible = false
		else
			_4rSXE.Active = false
			_4rSXE.Visible = false
			_bmY.Active = false
			_bmY.Visible = false
			_q6GM.Active = false
			_q6GM.Visible = false
		end
		zitemitem_12_triangulo_se_nova.Visible = true
		zitemitem_12_triangulo_se_nova:MoveTo(zoneSeNova)
		_PNq = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneMuseuMachadodeCastroIgreja:OnEnter()
	_HULI = "zoneMuseuMachadodeCastroIgreja"
	if _J9bwF == true then
		_q6GM.Active = false
		_q6GM.Visible = false
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_dqmB3.Active = true
			_dqmB3.Visible = true
		else
			_bmY.Active = true
			_bmY.Visible = true
		end
		zitemitem_04_fonte_jardim_da_manga.Commands._CKr.Enabled = true
		zoneUniversidadeFaculdadedeLetras.Active = false
		zoneUniversidadeFaculdadedeLetras.Visible = false
		_KHYA.Active = false
		_KHYA.Visible = false
		_J9bwF = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneSVelha:OnEnter()
	_HULI = "zoneSVelha"
	if _4YZ == true then
		zoneSeNova.Active = false
		zoneSeNova.Visible = false
		zoneFaculdadedePsicologia.Visible = false
		zoneFaculdadedePsicologia.Active = false
		zoneVistaPanormica.Active = false
		zoneVistaPanormica.Visible = false
		_5lfuU.Active = false
		_5lfuU.Visible = false
		zitemitem_09_estatua_fac_letras.Commands._PkS.Enabled = true
		if _2_Nn == true then
			if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
				_Ta2cL.Active = true
				_Ta2cL.Visible = true
			else
				_mZVB4.Active = true
				_mZVB4.Visible = true
			end
		else
			if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
				_Urwigo.OldDialog{
					{
						Text = "Como se trata de um atalho, apenas tem de apreciar a Se Velha, e quando terminar siga para o destno seguinte, as escadas do Quebra Costas."
					}
				}
				_5AuV.Active = true
				_5AuV.Visible = true
			else
				_Urwigo.OldDialog{
					{
						Text = "As this is a shortcut, simply enjoy the Old Cathedral, and when finished go to your next point, \"Quebra Costas\""
					}
				}
				_WtkI.Active = true
				_WtkI.Visible = true
			end
			_h5so = true
		end
		--[[Colocar disponivel o quebra costas]]
		zoneQuebracostas.Active = true
		zoneQuebracostas.Visible = true
		_1AIN.Active = false
		_1AIN.Visible = false
		_wBvz.Active = false
		_wBvz.Visible = false
		_Uu5s.Active = false
		_Uu5s.Visible = false
		_DL74t = false
		_4YZ = false
		ztaskGotoMercado.Visible = false
		ztaskGotoMercado.Active = false
		__3Ohc = false
		_ZQPu.Active = false
		_ZQPu.Visible = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneQuebracostas:OnEnter()
	_HULI = "zoneQuebracostas"
	if _h5so == true then
		zoneSVelha.Active = false
		zoneSVelha.Visible = false
		_WtkI.Active = false
		_WtkI.Visible = false
		zitemitem_15_jarro_quebra_costas:MoveTo(zoneQuebracostas)
		zitemitem_15_jarro_quebra_costas.Visible = true
		_5AuV.Active = false
		_5AuV.Visible = false
		_h5so = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneGovernoCivil1:OnEnter()
	_HULI = "zoneGovernoCivil1"
	if _Jbco == true then
		zoneQuebracostas.Active = false
		zoneQuebracostas.Visible = false
		zonePraadoComrcio1.Active = false
		zonePraadoComrcio1.Visible = false
		_YM5s.Active = false
		_YM5s.Visible = false
		_HeBPC.Active = false
		_HeBPC.Visible = false
		zitemitem_16_pedras.Visible = true
		zitemitem_16_pedras:MoveTo(zoneGovernoCivil1)
		_JPnuw.Active = false
		_JPnuw.Visible = false
		_bzYd.Active = false
		_bzYd.Visible = false
		_Jbco = false
		_GkFvM = false
		cartCoimbra:RequestSync()
	else
	end
end
function zonePortagem:OnEnter()
	_HULI = "zonePortagem"
	if _ZR3h == true then
		_pTS.Visible = false
		_pTS.Active = false
		_MMoVA.Active = false
		_MMoVA.Visible = false
		zitemitem_17_mao_miguel_torga:MoveTo(zonePortagem)
		zitemitem_17_mao_miguel_torga.Visible = true
		if _qiAU ~= true then
			zitemitem_17_mao_miguel_torga.Commands._1oG.Enabled = true
			zitemitem_17_mao_miguel_torga.Commands._D4PWU.Enabled = false
		else
			zitemitem_17_mao_miguel_torga.Commands._1oG.Enabled = true
			zitemitem_17_mao_miguel_torga.Commands._D4PWU.Enabled = true
			if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
				_Y_jG.Active = true
				_Y_jG.Visible = true
			else
				_V8uS.Active = true
				_V8uS.Visible = true
			end
			zitemitem_12_triangulo_se_nova.Commands._4B5_.Enabled = true
		end
		_ZR3h = false
		cartCoimbra:RequestSync()
	else
	end
end
function zonePraadoComrcio1:OnEnter()
	_HULI = "zonePraadoComrcio1"
	if _GkFvM == true then
		zoneQuebracostas.Active = false
		zoneQuebracostas.Visible = false
		zoneGovernoCivil1.Active = false
		zoneGovernoCivil1.Visible = false
		zonePortagem.Active = false
		zonePortagem.Visible = false
		--[[Ingles]]
		_HeBPC.Active = false
		_HeBPC.Visible = false
		_YM5s.Active = false
		_YM5s.Visible = false
		--[[Portugues]]
		_bzYd.Visible = false
		_bzYd.Active = false
		_JPnuw.Active = false
		_JPnuw.Visible = false
		zitemitem_19_praca_comercio:MoveTo(zonePraadoComrcio1)
		zitemitem_19_praca_comercio.Visible = true
		_GkFvM = false
		_Jbco = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneEstaodeComboios:OnEnter()
	_HULI = "zoneEstaodeComboios"
	if _w0S == true then
		zonePraadoComrcio1.Active = false
		zonePraadoComrcio1.Visible = false
		_sN8g.Active = false
		_sN8g.Visible = false
		_rTL0.Active = false
		_rTL0.Visible = false
		zitemItem_01_coluna_tribunal.Visible = false
		zitemitem_03_dragao_cafe_santa_Cruz.Visible = false
		zitemitem_04_fonte_jardim_da_manga.Visible = false
		zoneRioMondego.Active = true
		zoneRioMondego.Visible = true
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_HRO.Active = true
			_HRO.Visible = true
			_FWM3A.Active = true
			_FWM3A.Visible = true
		else
			_6D2w.Active = true
			_6D2w.Visible = true
			_T3G.Active = true
			_T3G.Visible = true
		end
		zitemitem_06_lab_quimico.Commands._PGL.Enabled = true
		zitemitem_07_bola_escadas_monumentais.Commands._XAYB.Enabled = true
		zitemitem_15_jarro_quebra_costas.Commands._OjPDJ.Enabled = true
		zitemitem_16_pedras.Commands._FCz.Enabled = true
		zitemitem_17_mao_miguel_torga.Commands._D4PWU.Enabled = true
		zitemitem_19_praca_comercio.Commands._4vx.Enabled = true
		__FZr = true
		_w0S = false
		cartCoimbra:RequestSync()
	else
	end
end
function zoneRioMondego:OnEnter()
	_HULI = "zoneRioMondego"
	if __FZr == true then
		_6D2w.Active = false
		_6D2w.Visible = false
		_T3G.Active = false
		_T3G.Visible = false
		zoneEstaodeComboios.Active = false
		zoneEstaodeComboios.Visible = false
		_yWyx.Active = true
		_yWyx.Visible = true
		cartCoimbra.Complete = true
		_LMHO0.Visible = true
		_LMHO0:MoveTo(zoneRioMondego)
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_Urwigo.OldDialog{
				{
					Text = "Espero que estejas feliz por me teres colocado novamente na prisao... mas eu vou voltar, um dia vou voltar...", 
					Media = _jkdy
				}
			}
		else
			_Urwigo.OldDialog{
				{
					Text = "Are you happy for sending me back to jail again??? I will be back one day....", 
					Media = _jkdy
				}
			}
		end
		_HRO.Active = false
		_HRO.Visible = false
		_FWM3A.Active = false
		_FWM3A.Visible = false
		_JRzS = true
		__FZr = false
	else
	end
end
function _l_8u:OnEnter()
	_HULI = "_l_8u"
	if _JRzS == true then
		_Y0ls.Visible = true
		_JRzS = false
	else
	end
end
function ztaskGotoIgrejadeNossaSenhoradoCarmo:OnClick()
	_Urwigo.MessageBox{
		Text = "You must go the \"Igreja de Nossa Senhora do Carmo\", not far from here, in there you will find some more information for your adventure.", 
		Media = zmediaProfessor, 
		Buttons = {
			"Ok"
		}
	}
	zoneIgrejadeNossaSenhoradoCarmo.Visible = true
	zoneIgrejadeNossaSenhoradoCarmo.Active = true
end
function ztaskGotoPatiodainquisicao:OnClick()
	_Urwigo.MessageBox{
		Text = "You have to go to Patio da Inquisicao", 
		Media = zmediaProfessor
	}
end
function ztaskGotoCityHall:OnClick()
	_Urwigo.MessageBox{
		Text = "You should go to the City Hall, seems that there you can find something to help you on your future tasks", 
		Media = zmediaProfessor
	}
end
function ztaskGotoSantaCruzChurch:OnClick()
	_Urwigo.MessageBox{
		Text = "You have to go to the Santa Cruz Church.", 
		Media = zmediaProfessor
	}
end
function ztaskGotoCafeSantaCruz:OnClick()
	_Urwigo.MessageBox{
		Text = "You should now go to the Santa Cruz Church.", 
		Media = zmediaProfessor
	}
end
function ztaskGotoJardimdaManga:OnClick()
	_Urwigo.MessageBox{
		Text = "You should now go to Jardim da Manga", 
		Media = zmediaProfessor
	}
end
function ztaskGotoMercado:OnClick()
	_Urwigo.MessageBox{
		Text = "Time to go to \"Mercado Municipal\"", 
		Media = zmediaProfessor
	}
end
function ztaskGotoFaculdadedePsicologia:OnClick()
	_Urwigo.MessageBox{
		Text = "You should now go to School of Psychology.", 
		Media = zmediaProfessor
	}
end
function zinputObternumerodetelefone:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Numerodetelefone = input
	if Numerodetelefone ~= "239829681" then
		_Urwigo.OldDialog{
			{
				Text = "Please try again.", 
				Media = zmediaProfessor
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = [[You have choosen the right number.
Now you have to go to the
- Chemical Lab ]], 
				Media = zmediaProfessor
			}
		}
		_zZVdF.Active = true
		_zZVdF.Visible = true
		Pontuacao = Pontuacao + 1
		_zkXRs.Commands._tBgB.Enabled = false
		_zkXRs.Visible = false
		zoneLabQuimico.Active = true
		zoneLabQuimico.Visible = true
		_0duLV = true
	end
end
function zinputObter_data_1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Data_1 = tonumber(input)
	if Data_1 ~= 1542 then
		_Urwigo.OldDialog{
			{
				Text = "The value you entered is not correct, please try again."
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = "The value is correct, now you have to decide between two ways, you can go to Patio da Inquisicao (recommended) or go directly to City Hall (faster)."
			}
		}
		ztaskGotoCityHall.Visible = true
		_GFp1.Commands._ra_.Enabled = false
		_GFp1.Visible = false
		ztaskGotoCityHall.Active = true
		ztaskGotoPatiodainquisicao.Visible = true
		ztaskGotoPatiodainquisicao.Active = true
		Pontuacao = Pontuacao + 1
		zoneCamaraMunicipaldeCoimbra.Active = true
		zoneCamaraMunicipaldeCoimbra.Visible = true
		zonePatiodaInquisicao.Active = true
		zonePatiodaInquisicao.Visible = true
		_t2yz = true
		_AVqo = true
	end
end
function zinputObternumeroazulejos:OnGetInput(input)
	if input == nil then
		input = ""
	end
	azulejos = tonumber(input)
	if azulejos ~= 6 then
		_Urwigo.MessageBox{
			Text = "The value you entered is not correct, please try again.", 
			Media = zmediaProfessor
		}
	else
		_W7B.Commands._R67h.Enabled = false
		_Urwigo.MessageBox{
			Text = "Correct, now it's time to go to City Hall", 
			Media = zmediaProfessor
		}
		ztaskGotoCityHall.Active = true
		ztaskGotoCityHall.Visible = true
		zinputObternumeroazulejos.Visible = false
		zoneCamaraMunicipaldeCoimbra.Active = true
		zoneCamaraMunicipaldeCoimbra.Visible = true
		Pontuacao = Pontuacao + 3
		_W7B.Visible = false
		_t2yz = true
	end
end
function zinputGetDataSantaCruz:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Data_de_Santa_Cruz = tonumber(input)
	if Data_de_Santa_Cruz ~= 1131 then
		_Urwigo.OldDialog{
			{
				Text = "The answer is not correct, please try again."
			}
		}
	else
		_m5_x6.Commands._upXA.Enabled = false
		_Urwigo.OldDialog{
			{
				Text = "The date you inserted is correct, now it's time to move on with this adventure. Your next stop is near..."
			}
		}
		ztaskGotoCafeSantaCruz.Active = true
		ztaskGotoCafeSantaCruz.Visible = true
		zoneCafedeSantaCruz.Active = true
		zoneCafedeSantaCruz.Visible = true
		_m5_x6.Visible = false
		_k56 = true
		Pontuacao = Pontuacao + 1
	end
end
function zinputGetColor:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Color_mercado = input
	if Color_mercado ~= "Blue" then
		_Urwigo.MessageBox{
			Text = "This is not correct, please try again.", 
			Media = zmediaProfessor
		}
	else
		_jokfZ.Commands._v0QSm.Enabled = false
		_Urwigo.OldDialog{
			{
				Text = [[The answer is correct. It's time to move on.
Your next stop will be on one of two places:
- Psycology Faculty (Malevolus was seen there)
- Panoramic View (a great place to look for Malevolus)
Take your decision and move on.]]
			}
		}
		Pontuacao = Pontuacao + 1
		zoneFaculdadedePsicologia.Active = true
		zoneFaculdadedePsicologia.Visible = true
		zoneVistaPanormica.Active = true
		zoneVistaPanormica.Visible = true
		_jokfZ.Visible = false
		ztaskGotoFaculdadedePsicologia.Active = false
		ztaskGotoFaculdadedePsicologia.Visible = false
		_wBvz.Active = false
		_wBvz.Visible = false
		_DL74t = true
		_5wjX = true
	end
end
function _y9HM:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Q3F = input
	if _Q3F ~= "MCCLXI" then
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_Urwigo.OldDialog{
				{
					Text = [[Errado, tente novamente.

]], 
					Media = _7oHN
				}
			}
		else
			_Urwigo.OldDialog{
				{
					Text = [[Please try again.
]], 
					Media = _7oHN
				}
			}
		end
	else
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_Urwigo.OldDialog{
				{
					Text = [[Acertou. 
Deve agora dirigir-se para as escadas Monumentais, perto daqui.
]], 
					Media = zmediaProfessor
				}
			}
			_jh4n.Commands._UqPo5.Enabled = false
			_jh4n.Visible = false
			_jD3W.Visible = true
			_jD3W.Active = true
		else
			_Urwigo.OldDialog{
				{
					Text = [[Correct.
Now you have to go to the Monumental Stairs, not far from here.
]], 
					Media = zmediaProfessor
				}
			}
			_g_bu.Commands._8XHTn.Enabled = false
			_g_bu.Visible = false
			_EtzTn.Visible = true
			_EtzTn.Active = true
		end
		zoneEscadasMonumentais.Active = true
		zoneEscadasMonumentais.Visible = true
		_7jj = true
		Pontuacao = Pontuacao + 3
	end
end
function _kMR0:OnGetInput(input)
	if input == nil then
		input = ""
	end
end
function _Hykon:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_YeFf = tonumber(input)
	if _YeFf ~= 1836 then
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_Urwigo.OldDialog{
				{
					Text = [[Errado. Necessita de tentar novamente.
]], 
					Media = _7oHN
				}
			}
		else
			_Urwigo.OldDialog{
				{
					Text = "You need to try again.", 
					Media = _7oHN
				}
			}
		end
	else
		if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
			_Urwigo.OldDialog{
				{
					Text = [[Correcto
Vamos agora para a Universidade (Faculdade de Letras).

]], 
					Media = zmediaProfessor
				}
			}
			_OcS8.Commands._S5W.Enabled = false
			_OcS8.Visible = false
			_xZ6IR.Active = true
			_xZ6IR.Visible = true
		else
			_Urwigo.OldDialog{
				{
					Text = [[Correct.
Now it's time to go to the University.
]], 
					Media = zmediaProfessor
				}
			}
			_jEM.Commands._KKG.Enabled = false
			_jEM.Visible = false
			_s98.Active = true
			_s98.Visible = true
		end
		zoneUniversidadeFaculdadedeLetras.Active = true
		zoneUniversidadeFaculdadedeLetras.Visible = true
		_LEG = true
		Pontuacao = Pontuacao + 4
	end
end
function _bRnJ:OnGetInput(input)
	if input == nil then
		input = ""
	end
end
function _5CW:OnGetInput(input)
	if input == nil then
		input = ""
	end
	lang = input
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = [[Vamos agora comecar a nossa aventura, em Portugues.

Por favor va ate ao tribunal da cidade de Coimbra, que se situa no final da Rua da Sofia, la tera inicio a aventura.]], 
				Media = _nCMpW
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = [[Now we will start our adventure, in English.

Please go to the ciry Court, on the Sofia Street, there will begin your adventure.]], 
				Media = _h3B7
			}
		}
	end
end
function _TAHim:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Data_1 = tonumber(input)
	if Data_1 ~= 1542 then
		_Urwigo.OldDialog{
			{
				Text = "O valor que inseriu nao esta correcto, tente novamente."
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = [[O valor que inseriu esta correcto.
Agora tem que escolher o proximo ponto, existem duas formas de continuar este percurso, podemos ir:
- ao Patio da Inquisicao (recomendado)
- para a Camara Municipal (mais rapido)]]
			}
		}
		__fyV.Commands._JyZIq.Enabled = false
		__fyV.Visible = false
		_04Z.Active = true
		_04Z.Visible = true
		_tHrj6.Active = true
		_tHrj6.Visible = true
		Pontuacao = Pontuacao + 1
		zoneCamaraMunicipaldeCoimbra.Active = true
		zoneCamaraMunicipaldeCoimbra.Visible = true
		zonePatiodaInquisicao.Active = true
		zonePatiodaInquisicao.Visible = true
		_t2yz = true
		_AVqo = true
	end
end
function _brUf:OnGetInput(input)
	if input == nil then
		input = ""
	end
	azulejos = tonumber(input)
	if azulejos ~= 6 then
		_Urwigo.MessageBox{
			Text = "O valor que inseriu nao esta correcto, tente novamente.", 
			Media = zmediaProfessor
		}
	else
		_tT6.Commands._FQf0.Enabled = false
		_Urwigo.MessageBox{
			Text = [[Acertou, agora e altura de ir para a Camara Municipal de Coimbra.
]], 
			Media = zmediaProfessor
		}
		_04Z.Active = true
		_04Z.Visible = true
		_brUf.Visible = false
		zoneCamaraMunicipaldeCoimbra.Active = true
		zoneCamaraMunicipaldeCoimbra.Visible = true
		Pontuacao = Pontuacao + 3
		_t2yz = true
		_tT6.Visible = false
	end
end
function _YkI:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Data_de_Santa_Cruz = tonumber(input)
	if Data_de_Santa_Cruz ~= 1131 then
		_Urwigo.OldDialog{
			{
				Text = [[A sua resposta nao esta correcta. Tente novamente.
]]
			}
		}
	else
		_MTAk.Commands._j7whM.Enabled = false
		_Urwigo.OldDialog{
			{
				Text = "A data que inseriu esta correcta. Agora deve segui para a etapa seguinte, que e bem proxima deste local."
			}
		}
		_5Tk.Active = true
		_5Tk.Visible = true
		zoneCafedeSantaCruz.Active = true
		zoneCafedeSantaCruz.Visible = true
		_MTAk.Visible = false
		_k56 = true
		Pontuacao = Pontuacao + 1
	end
end
function _m9en:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Color_mercado = input
	if Color_mercado ~= "Azul" then
		_Urwigo.MessageBox{
			Text = "Nao esta correcto, tente novamente.", 
			Media = zmediaProfessor
		}
	else
		_Mz8.Commands._odvR.Enabled = false
		_Urwigo.OldDialog{
			{
				Text = [[A resposta esta correcta. E agora altura de continuar.
A proxima paragem sera num dos seguintes locais:
- Faculdade de Psicologia (o Malevolus esteve aqui);
- Miradouro (um excelente local para procurar o Malevolus),]]
			}
		}
		Pontuacao = Pontuacao + 1
		zoneFaculdadedePsicologia.Active = true
		zoneFaculdadedePsicologia.Visible = true
		zoneVistaPanormica.Active = true
		zoneVistaPanormica.Visible = true
		_Mz8.Visible = false
		_Uu5s.Active = false
		_Uu5s.Visible = false
		_tMIo.Active = false
		_tMIo.Visible = false
		_DL74t = true
		_5wjX = true
	end
end
function _xR4:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Numerodetelefone = input
	if Numerodetelefone ~= "239829681" then
		_Urwigo.OldDialog{
			{
				Text = "Esta errado, tente novamente.", 
				Media = zmediaProfessor
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = "Acertou no numero, agora tem que ir em direccao ao Laboratorio Quimico.", 
				Media = zmediaProfessor
			}
		}
		_5Z0.Active = true
		_5Z0.Visible = true
		Pontuacao = Pontuacao + 1
		_mY0.Commands._Q2Ux.Enabled = false
		_mY0.Visible = false
		zoneLabQuimico.Active = true
		zoneLabQuimico.Visible = true
		_0duLV = true
	end
end
function _Cwc:On_tyQ(target)
	_Urwigo.MessageBox{
		Text = tostring(Pontuacao), 
		Media = _vAw
	}
end
function zitemItem_01_coluna_tribunal:OnTake(target)
	zitemItem_01_coluna_tribunal.Commands.Take.Enabled = false
	zitemItem_01_coluna_tribunal:MoveTo(Player)
	Pontuacao = Pontuacao + 1
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_OYBgZ.Visible = true
		_OYBgZ.Active = true
	else
		ztaskGotoIgrejadeNossaSenhoradoCarmo.Active = true
		ztaskGotoIgrejadeNossaSenhoradoCarmo.Visible = true
	end
	zoneIgrejadeNossaSenhoradoCarmo.Active = true
	zoneIgrejadeNossaSenhoradoCarmo.Visible = true
	_Yn5T = true
	_MXx29 = true
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = [[Agora que ja temos a coluna do tribunal, que nos sera util mais a frente nesta aventura. E altura de seguir. para o proximo ponto.
]]
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = [[You now have the column of the tribunal. It will help you this adventure.
Time to move on.]]
			}
		}
	end
end
function zitemItem_01_coluna_tribunal:On_jnO(target)
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = [[Este objecto vai ajuda-lo a preservar o Aqueduto, que foi danificado pelo Malevolus.
Agora que o utilizou devera continuar a aventura.]], 
				Media = zmediaProfessor
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = [[This item will help to preserv the Aqueduct.
Now you will have to go on with your adventure.
]], 
				Media = zmediaProfessor
			}
		}
	end
	zitemItem_01_coluna_tribunal.Visible = false
	zitemItem_01_coluna_tribunal.Commands._jnO.Enabled = false
	zitemItem_01_coluna_tribunal:MoveTo(zoneArcosdeJardim)
	if lang ~= "PORTUGUES" then
		_5sXX.Active = true
		_5sXX.Visible = true
	else
		_Ikf.Active = true
		_Ikf.Visible = true
	end
	zoneJardimBotanico.Active = true
	_n4s.Active = false
	_n4s.Visible = false
	_jhB.Active = false
	_jhB.Visible = false
	_h7G = true
	zoneJardimBotanico.Visible = true
	Pontuacao = Pontuacao + 1
end
function zitemItem_02_candeeiro_Cmc:On_9OPAH(target)
	zitemItem_02_candeeiro_Cmc.Commands._9OPAH.Enabled = false
	zitemItem_02_candeeiro_Cmc:MoveTo(Player)
	Pontuacao = Pontuacao + 1
	ztaskGotoCityHall.Active = false
	_04Z.Active = false
	ztaskGotoCityHall.Visible = false
	_04Z.Visible = false
	zoneIgrejadeSantaCruz.Active = true
	zoneIgrejadeSantaCruz.Visible = true
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = "Agora que temos o Candeeiro, ja temos alguma \"luz\" para encontrar o Malevolus. Parece que ele esteve junto da Igreja de Santa Cruz, e la a proxima paragem."
			}
		}
		_txLs1.Active = true
		_txLs1.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = "Now you have a lamp, it will light your way to find Malevolus. Seems that he was near the Igreja de Santa Cruz (Santa Cruz Church). Your next stop."
			}
		}
		ztaskGotoSantaCruzChurch.Active = true
		ztaskGotoSantaCruzChurch.Visible = true
	end
	_ujvjx = true
end
function zitemItem_02_candeeiro_Cmc:On_vRpC(target)
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = [[Apos utilizarmos a luz na Faculdade de Psicologia, temos 2 opcoes, que vao determinar o nosso percurso:
- vamos para a Se Velha (percurso mais rapido);
- vamos para a vista Panoramica (percurso mais long).]], 
				Media = zmediaProfessor
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = [[You will use this lamp to light the School of Psycology, and after that you will find your new way.
It's time to choose your next step:
- Old Cathedral (Faster);
- Panoramic View]], 
				Media = zmediaProfessor
			}
		}
	end
	zitemItem_02_candeeiro_Cmc:MoveTo(zoneFaculdadedePsicologia)
	zitemItem_02_candeeiro_Cmc.Visible = false
	_HPWA.Active = false
	__bnFq.Active = false
	_HPWA.Visible = false
	__bnFq.Visible = false
	zoneVistaPanormica.Active = true
	zoneVistaPanormica.Visible = true
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Uu5s.Visible = true
		_Uu5s.Active = true
		_1AIN.Active = true
		_1AIN.Visible = true
	else
		_wBvz.Visible = true
		_wBvz.Active = true
		_5lfuU.Active = true
		_5lfuU.Visible = true
	end
	_4YZ = true
	_DL74t = true
	--[[Se Velha]]
	zoneSVelha.Active = true
	zoneSVelha.Visible = true
	Pontuacao = Pontuacao + 2
end
function zitemitem_03_dragao_cafe_santa_Cruz:On_h6G9(target)
	zitemitem_03_dragao_cafe_santa_Cruz.Commands._h6G9.Enabled = false
	zitemitem_03_dragao_cafe_santa_Cruz:MoveTo(Player)
	zoneJardimdaManga.Active = true
	zoneJardimdaManga.Visible = true
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_udkY.Active = true
		_udkY.Visible = true
	else
		ztaskGotoJardimdaManga.Active = true
		ztaskGotoJardimdaManga.Visible = true
	end
	_AjS8 = true
	Pontuacao = Pontuacao + 2
end
function zitemitem_03_dragao_cafe_santa_Cruz:On_2H9FN(target)
	zitemitem_07_bola_escadas_monumentais.Commands._pifk.Enabled = false
	zitemitem_07_bola_escadas_monumentais:MoveTo(Player)
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = "Agora que recolheu a esfera nas escadas Monumentais e altura de ir em direccao ao Aqueduto (Arcos do Jardim).", 
				Media = zmediaProfessor
			}
		}
		_mASe.Active = true
		_mASe.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = [[You have now the ball from the Monumental stairs. Lets go to the Aqueduct.
]], 
				Media = zmediaProfessor
			}
		}
		_J1B.Active = true
		_J1B.Visible = true
	end
	zitemitem_03_dragao_cafe_santa_Cruz.Visible = false
	zitemitem_03_dragao_cafe_santa_Cruz:MoveTo(zoneEscadasMonumentais)
	zoneArcosdeJardim.Active = true
	zoneArcosdeJardim.Visible = true
	_ISCF = true
	Pontuacao = Pontuacao + 3
end
function zitemitem_04_fonte_jardim_da_manga:On_WgJ_D(target)
	zitemitem_04_fonte_jardim_da_manga.Commands._WgJ_D.Enabled = false
	zitemitem_04_fonte_jardim_da_manga:MoveTo(Player)
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = [[Agora que temos a Fonte e altura de prosseguir. No seu percurso, Malevolus passwou pelo Mercado e depois pela Faculdade de Psicologia. 
Podemos escolher agora se passarmos no mercado, ou em alternativa se vamos directamento para a Faculdade de Piscologia.]], 
				Media = zmediaProfessor
			}
		}
		_ZQPu.Active = true
		_ZQPu.Visible = true
		_tMIo.Active = true
		_tMIo.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = "Now that you have the Fountain its time to move on.  On his journey Malevolus went by the Mercado and then by Psychology Faculty. You can decide here were to go. Or directly to the Psychology Faculty or passing by the Market, it?s up to you.", 
				Media = zmediaProfessor
			}
		}
		ztaskGotoFaculdadedePsicologia.Active = true
		ztaskGotoFaculdadedePsicologia.Visible = true
		ztaskGotoMercado.Active = true
		ztaskGotoMercado.Visible = true
	end
	zoneMercadoMunicipal.Active = true
	zoneMercadoMunicipal.Visible = true
	zoneFaculdadedePsicologia.Active = true
	zoneFaculdadedePsicologia.Visible = true
	__3Ohc = true
	_5wjX = true
	Pontuacao = Pontuacao + 1
end
function zitemitem_04_fonte_jardim_da_manga:On_CKr(target)
	zitemitem_04_fonte_jardim_da_manga.Commands._CKr.Enabled = false
	zitemitem_04_fonte_jardim_da_manga:MoveTo(zoneMuseuMachadodeCastroIgreja)
	zitemitem_04_fonte_jardim_da_manga.Visible = false
	zoneSeNova.Active = true
	zoneSeNova.Visible = true
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Ysiz.Active = true
		_Ysiz.Visible = true
		_dqmB3.Active = false
		_dqmB3.Visible = false
	else
		_4rSXE.Active = true
		_4rSXE.Visible = true
		_bmY.Active = false
		_bmY.Visible = false
	end
	_PNq = true
	Pontuacao = Pontuacao + 2
end
function zitemitem_06_lab_quimico:On_SAmAT(target)
	zitemitem_06_lab_quimico.Commands._SAmAT.Enabled = false
	zitemitem_06_lab_quimico:MoveTo(Player)
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = [[Com este novo objecto, e sabendo tambem que o Malevolus utilizou este Laboratorio para realizar algumas experiencias, e entao a altura de continuar.
Temos duas possibilidades para continuar o nosso percurso:
1. Ir para a praca do D.Dinis (sera necessario andar um pouco mais);
2. Ir para a Universidade (mais rapido)]], 
				Media = zmediaProfessor
			}
		}
		_Ws4.Active = true
		_Ws4.Visible = true
		_xZ6IR.Active = true
		_xZ6IR.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = [[Now that you have this item, and that you found out that Malevolus used this Lab. to do some of his experiments, it's time to go on searching for him.
Your route should be decided by you now, once there are two options:
1. Go to the D.Dinis Statue and find out some more about the University there (you will have to walk a bit more);
2. Go directly to the University (faster)]], 
				Media = zmediaProfessor
			}
		}
		_zIT.Active = true
		_zIT.Visible = true
		_s98.Active = true
		_s98.Visible = true
	end
	zoneUniversidadeFaculdadedeLetras.Active = true
	zoneUniversidadeFaculdadedeLetras.Visible = true
	zoneDomDinis.Visible = true
	zoneDomDinis.Active = true
	_2sNt_ = true
	_LEG = true
	Pontuacao = Pontuacao + 1
end
function zitemitem_06_lab_quimico:On_PGL(target)
	zitemitem_06_lab_quimico.Visible = false
	zitemitem_06_lab_quimico:MoveTo(zoneEstaodeComboios)
	Pontuacao = Pontuacao + 4
end
function zitemitem_07_bola_escadas_monumentais:On_4a87(target)
end
function zitemitem_07_bola_escadas_monumentais:On_XAYB(target)
	zitemitem_07_bola_escadas_monumentais:MoveTo(zoneEstaodeComboios)
	zitemitem_07_bola_escadas_monumentais.Visible = false
	Pontuacao = Pontuacao + 6
end
function zitemitem_07_bola_escadas_monumentais:On_pifk(target)
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = [[E necessario utilizar a aguia para obter este Item.
Com esta bola sera possivel deter o Malevolus.]], 
				Media = zmediaProfessor
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = [[You need to use the Eagle to get this Item.
With this item you will be able to stop Malevolus.

]], 
				Media = zmediaProfessor
			}
		}
	end
end
function zitemitem_09_estatua_fac_letras:On_J2Haj(target)
	zitemitem_09_estatua_fac_letras:MoveTo(Player)
	zitemitem_09_estatua_fac_letras.Commands._J2Haj.Enabled = false
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = [[Agora e altura para decidir o local para onde pretendemos ir a seguir:
- Museu Machado de Castro (mais rapido)
- Se Nova]], 
				Media = zmediaProfessor
			}
		}
		_Ysiz.Active = true
		_Ysiz.Visible = true
		_KHYA.Active = true
		_KHYA.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = [[You should decide where do you want to go now:
- Machado de Castro Museum (Faster)
- New Cathedral ]], 
				Media = zmediaProfessor
			}
		}
		_4rSXE.Active = true
		_4rSXE.Visible = true
		_q6GM.Active = true
		_q6GM.Visible = true
	end
	zoneSeNova.Active = true
	zoneSeNova.Visible = true
	zoneMuseuMachadodeCastroIgreja.Active = true
	zoneMuseuMachadodeCastroIgreja.Visible = true
	_PNq = true
	_J9bwF = true
	_2_Nn = true
end
function zitemitem_09_estatua_fac_letras:On_PkS(target)
	zitemitem_09_estatua_fac_letras.Commands._PkS.Enabled = false
	_mZVB4.Visible = false
	_mZVB4.Active = false
	zitemitem_09_estatua_fac_letras.Visible = false
	zitemitem_09_estatua_fac_letras:MoveTo(zoneSVelha)
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = [[E agora altua de seguir para as escadas do Quebra Costas, muito perto daqui... vamos.
]], 
				Media = zmediaProfessor
			}
		}
		_5AuV.Active = true
		_5AuV.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = "Time to go to the Quebra Costas Stairs, not far... lets go.", 
				Media = zmediaProfessor
			}
		}
		_WtkI.Active = true
		_WtkI.Visible = true
	end
	_mZVB4.Active = false
	_mZVB4.Visible = false
	zoneQuebracostas.Active = true
	zoneQuebracostas.Visible = true
	_h5so = true
	Pontuacao = Pontuacao + 5
end
function zitemitem_12_triangulo_se_nova:On_EuIj(target)
	zitemitem_12_triangulo_se_nova:MoveTo(Player)
	zitemitem_12_triangulo_se_nova.Commands._EuIj.Enabled = false
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = "Agora, a partir da Se Nova temos de ir para Se Velha, um pouco mais abaixo...", 
				Media = zmediaProfessor
			}
		}
		_1AIN.Active = true
		_1AIN.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = "Now, from the New Cathedral you have to find the Old Cathedral... a little bit down from here.", 
				Media = zmediaProfessor
			}
		}
		_5lfuU.Active = true
		_5lfuU.Visible = true
	end
	zoneSVelha.Active = true
	zoneSVelha.Visible = true
	Pontuacao = Pontuacao + 3
	_4YZ = true
	_qiAU = true
end
function zitemitem_12_triangulo_se_nova:On_4B5_(target)
	zitemitem_12_triangulo_se_nova:MoveTo(zonePortagem)
	zitemitem_12_triangulo_se_nova.Commands._4B5_.Enabled = false
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Y_jG.Active = false
		_Y_jG.Visible = false
		_Urwigo.OldDialog{
			{
				Text = "Com este triangulo sera possivel obter a mao no Largo da Portagem.", 
				Media = zmediaProfessor
			}
		}
		_bzYd.Active = true
		_bzYd.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = [[With this triangle you can get the hand in the Portagem Square.
]], 
				Media = zmediaProfessor
			}
		}
		_V8uS.Active = false
		_V8uS.Visible = false
		_HeBPC.Active = true
		_HeBPC.Visible = true
	end
	zitemitem_12_triangulo_se_nova.Visible = false
	zitemitem_17_mao_miguel_torga:MoveTo(Player)
	zonePraadoComrcio1.Active = true
	zonePraadoComrcio1.Visible = true
	_GkFvM = true
	Pontuacao = Pontuacao + 3
end
function zitemitem_15_jarro_quebra_costas:On_VjOPQ(target)
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = [[Agora que obteve este objecto, tem de escolher o proximo destino:
- Praca do Comercio (mais rapido);
- Governo Civil]], 
				Media = zmediaProfessor
			}
		}
		_JPnuw.Active = true
		_JPnuw.Visible = true
		_bzYd.Active = true
		_bzYd.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = [[Now that you have colected this object, you have to choose where to go:
- Praca do Comercio (Faster)
- Governo Civil]], 
				Media = zmediaProfessor
			}
		}
		_YM5s.Active = true
		_YM5s.Visible = true
		_HeBPC.Active = true
		_HeBPC.Visible = true
	end
	zitemitem_15_jarro_quebra_costas:MoveTo(Player)
	zitemitem_15_jarro_quebra_costas.Commands._VjOPQ.Enabled = false
	zoneGovernoCivil1.Active = true
	zoneGovernoCivil1.Visible = true
	zonePraadoComrcio1.Active = true
	zonePraadoComrcio1.Visible = true
	_Jbco = true
	_GkFvM = true
	Pontuacao = Pontuacao + 2
end
function zitemitem_15_jarro_quebra_costas:On_OjPDJ(target)
	zitemitem_15_jarro_quebra_costas.Visible = false
	zitemitem_15_jarro_quebra_costas:MoveTo(zoneEstaodeComboios)
	Pontuacao = Pontuacao + 4
end
function zitemitem_16_pedras:On_cIjw(target)
	zitemitem_16_pedras:MoveTo(Player)
	zitemitem_16_pedras.Commands._cIjw.Enabled = false
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = "Agora que recolhemos as pedras e altura de passar para o ponto seguinte, o Largo da Portagem."
			}
		}
		_MMoVA.Active = true
		_MMoVA.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = "Now that you have the stones with you, you must go to the next step - Largo da Portagem."
			}
		}
		_pTS.Active = true
		_pTS.Visible = true
	end
	zonePortagem.Active = true
	zonePortagem.Visible = true
	_ZR3h = true
	Pontuacao = Pontuacao + 5
end
function zitemitem_16_pedras:On_FCz(target)
	zitemitem_16_pedras.Visible = false
	zitemitem_16_pedras:MoveTo(zoneEstaodeComboios)
	Pontuacao = Pontuacao + 8
end
function zitemitem_17_mao_miguel_torga:On_1oG(target)
	zitemitem_17_mao_miguel_torga.Commands._1oG.Enabled = false
	zitemitem_17_mao_miguel_torga:MoveTo(Player)
	Pontuacao = Pontuacao + 5
	zonePraadoComrcio1.Active = true
	zonePraadoComrcio1.Visible = true
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_Urwigo.OldDialog{
			{
				Text = [[E altura de seguir para a Praca do Comercio.
]], 
				Media = zmediaProfessor
			}
		}
		_bzYd.Active = true
		_bzYd.Visible = true
	else
		_Urwigo.OldDialog{
			{
				Text = [[Time to go to the Praca do Comercio.

]], 
				Media = zmediaProfessor
			}
		}
		_HeBPC.Active = true
		_HeBPC.Visible = true
	end
	_GkFvM = true
end
function zitemitem_17_mao_miguel_torga:On_D4PWU(target)
	zitemitem_17_mao_miguel_torga:MoveTo(zoneEstaodeComboios)
	zitemitem_17_mao_miguel_torga.Visible = false
	Pontuacao = Pontuacao + 10
end
function zitemitem_19_praca_comercio:On_pgqhz(target)
	zitemitem_19_praca_comercio.Commands._pgqhz.Enabled = false
	zitemitem_19_praca_comercio:MoveTo(Player)
	zoneEstaodeComboios.Active = true
	zoneEstaodeComboios.Visible = true
	if Wherigo.NoCaseEquals(lang, "PORTUGUES") then
		_rTL0.Active = true
		_rTL0.Visible = true
	else
		_sN8g.Active = true
		_sN8g.Visible = true
	end
	_w0S = true
	Pontuacao = Pontuacao + 2
end
function zitemitem_19_praca_comercio:On_4vx(target)
	zitemitem_19_praca_comercio.Visible = false
	zitemitem_19_praca_comercio:MoveTo(zoneEstaodeComboios)
	Pontuacao = Pontuacao + 3
end
function _GFp1:On_ra_(target)
	zinputObter_data_1.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputObter_data_1)
	end)
end
function _W7B:On_R67h(target)
	zinputObternumeroazulejos.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputObternumeroazulejos)
	end)
end
function _m5_x6:On_upXA(target)
	zinputGetDataSantaCruz.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputGetDataSantaCruz)
	end)
end
function _jokfZ:On_v0QSm(target)
	zinputGetColor.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputGetColor)
	end)
end
function _QD04Y:On_JmEf(target)
end
function _jEM:On_KKG(target)
	_Hykon.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Hykon)
	end)
end
function _FKqjH:On_wW0K8(target)
end
function _g_bu:On_8XHTn(target)
	_y9HM.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_y9HM)
	end)
end
function _qej:On_MnK(target)
end
function _zkXRs:On_tBgB(target)
	zinputObternumerodetelefone.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputObternumerodetelefone)
	end)
end
function _LMHO0:On_Cso(target)
	_Urwigo.OldDialog{
		{
			Text = string.sub(Player.CompletionCode, 1, 15)
		}
	}
	_Y0ls.Visible = true
	_l_8u.Active = true
	_l_8u.Visible = true
	_JRzS = true
end
function __fyV:On_JyZIq(target)
	_TAHim.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_TAHim)
	end)
end
function _tT6:On_FQf0(target)
	_brUf.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_brUf)
	end)
end
function _MTAk:On_j7whM(target)
	_YkI.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_YkI)
	end)
end
function _Mz8:On_odvR(target)
	_m9en.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_m9en)
	end)
end
function _mY0:On_Q2Ux(target)
	_xR4.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_xR4)
	end)
end
function _jh4n:On_UqPo5(target)
	_y9HM.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_y9HM)
	end)
end
function _OcS8:On_S5W(target)
	_Hykon.Visible = true
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Hykon)
	end)
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return cartCoimbra
