require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _efb(str)
	local res = ""
    local dtable = "\071\119\017\079\029\056\005\103\068\035\102\037\045\060\091\083\051\044\038\104\096\085\115\016\065\025\053\080\123\004\105\114\074\076\031\048\024\126\077\032\013\047\108\000\112\021\022\073\046\095\023\118\019\054\007\010\110\099\041\089\106\042\052\011\075\113\098\057\003\027\063\088\097\055\090\050\124\034\087\040\002\086\117\058\066\014\109\009\026\028\072\078\094\036\062\049\059\121\008\061\033\015\125\043\081\092\067\006\039\093\107\101\070\012\120\064\001\030\116\018\100\084\122\082\020\111\069"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

objInitiation = Wherigo.ZCartridge()

-- Media --
objJune = Wherigo.ZMedia(objInitiation)
objJune.Id = "ccb4ba14-dc28-4936-986e-9d3c4b545d24"
objJune.Name = "June"
objJune.Description = "June"
objJune.AltText = ""
objJune.Resources = {
	{
		Type = "gif", 
		Filename = "NOARAPH.gif", 
		Directives = {}
	}
}
objicon_June = Wherigo.ZMedia(objInitiation)
objicon_June.Id = "f98b9bbf-0a78-48af-928b-155ce669c445"
objicon_June.Name = "icon_June"
objicon_June.Description = "icon_June"
objicon_June.AltText = ""
objicon_June.Resources = {
	{
		Type = "jpg", 
		Filename = "NOARAPH3232.jpg", 
		Directives = {}
	}
}
objTresor = Wherigo.ZMedia(objInitiation)
objTresor.Id = "6e4d14be-e66c-43f4-b707-748fcc5b22f4"
objTresor.Name = "Tresor"
objTresor.Description = "tresor"
objTresor.AltText = ""
objTresor.Resources = {
	{
		Type = "png", 
		Filename = "Coffre300300.png", 
		Directives = {}
	}
}
objicon_tresor = Wherigo.ZMedia(objInitiation)
objicon_tresor.Id = "2e979686-d1a4-43bd-b2b8-34566e5ec7a4"
objicon_tresor.Name = "icon_tresor"
objicon_tresor.Description = "icone tresor"
objicon_tresor.AltText = ""
objicon_tresor.Resources = {
	{
		Type = "png", 
		Filename = "IcoCoffre3232.png", 
		Directives = {}
	}
}
objBravo = Wherigo.ZMedia(objInitiation)
objBravo.Id = "b98967c1-8185-44f2-8876-2b01028beb63"
objBravo.Name = "Bravo"
objBravo.Description = "Bravo"
objBravo.AltText = ""
objBravo.Resources = {
	{
		Type = "jpg", 
		Filename = "bravo220220.jpg", 
		Directives = {}
	}
}
objicon_Bravo = Wherigo.ZMedia(objInitiation)
objicon_Bravo.Id = "a83f2b2e-b97d-447c-bb74-94f0b5b1a7d4"
objicon_Bravo.Name = "icon_Bravo"
objicon_Bravo.Description = "icone Bravo"
objicon_Bravo.AltText = ""
objicon_Bravo.Resources = {
	{
		Type = "jpg", 
		Filename = "Iconbravo-32-32.jpg", 
		Directives = {}
	}
}
objposter = Wherigo.ZMedia(objInitiation)
objposter.Id = "a48d289f-7910-4821-9e04-3b2168ce9876"
objposter.Name = "poster"
objposter.Description = ""
objposter.AltText = ""
objposter.Resources = {
	{
		Type = "png", 
		Filename = "logo.png", 
		Directives = {}
	}
}
objicon = Wherigo.ZMedia(objInitiation)
objicon.Id = "9145bcfe-52ee-470b-8c76-0615d6445ec2"
objicon.Name = "icon"
objicon.Description = ""
objicon.AltText = ""
objicon.Resources = {
	{
		Type = "png", 
		Filename = "iconewherigo.png", 
		Directives = {}
	}
}
-- Cartridge Info --
objInitiation.Id="f46ad3ab-a09e-408b-857e-bbc1bf924ed1"
objInitiation.Name="Initiation"
objInitiation.Description=[[Cartouche pour l event initiation wherigo realise par Team verturin et Zombi.dc]]
objInitiation.Visible=true
objInitiation.Activity="Geocache"
objInitiation.StartingLocationDescription=[[Cartouche pour l event initiation wherigo realise par Team verturin et Zombi.dc]]
objInitiation.StartingLocation = ZonePoint(48.6213333333333,2.56475,0)
objInitiation.Version="v3"
objInitiation.Company="Team Verturin et Zombi.dc"
objInitiation.Author="Team Verturin et Zombi.dc"
objInitiation.BuilderVersion="URWIGO 1.21.5528.18461"
objInitiation.CreateDate="03/01/2015 16:29:22"
objInitiation.PublishDate="1/1/0001 12:00:00 AM"
objInitiation.UpdateDate="03/05/2015 17:39:47"
objInitiation.LastPlayedDate="1/1/0001 12:00:00 AM"
objInitiation.TargetDevice="PocketPC"
objInitiation.TargetDeviceVersion="0"
objInitiation.StateId="1"
objInitiation.CountryId="2"
objInitiation.Complete=false
objInitiation.UseLogging=true

objInitiation.Media=objposter

objInitiation.Icon=objicon


-- Zones --
objMapremierezone = Wherigo.Zone(objInitiation)
objMapremierezone.Id = "66ac76a1-6011-4183-8114-43770646fab6"
objMapremierezone.Name = "Ma premiere zone"
objMapremierezone.Description = "La premiere zone de cette aventure"
objMapremierezone.Visible = true
objMapremierezone.Commands = {}
objMapremierezone.DistanceRange = Distance(-1, "feet")
objMapremierezone.ShowObjects = "OnEnter"
objMapremierezone.ProximityRange = Distance(60, "meters")
objMapremierezone.AllowSetPositionTo = false
objMapremierezone.Active = true
objMapremierezone.Points = {
	ZonePoint(48.6213654972257, 2.56449872951694, 0), 
	ZonePoint(48.621414242503, 2.56461233082566, 0), 
	ZonePoint(48.6213299263179, 2.56469803005853, 0), 
	ZonePoint(48.6212785460736, 2.56458841476069, 0)
}
objMapremierezone.OriginalPoint = ZonePoint(48.6213470530301, 2.56459937629046, 0)
objMapremierezone.DistanceRangeUOM = "Feet"
objMapremierezone.ProximityRangeUOM = "Meters"
objMapremierezone.OutOfRangeName = ""
objMapremierezone.InRangeName = ""
objZonequestion = Wherigo.Zone(objInitiation)
objZonequestion.Id = "41ad91cd-49ab-4ab2-a44a-718fafb097c4"
objZonequestion.Name = "Zone question"
objZonequestion.Description = "Emplacement de la zone question"
objZonequestion.Visible = false
objZonequestion.Commands = {}
objZonequestion.DistanceRange = Distance(-1, "feet")
objZonequestion.ShowObjects = "OnEnter"
objZonequestion.ProximityRange = Distance(60, "meters")
objZonequestion.AllowSetPositionTo = false
objZonequestion.Active = false
objZonequestion.Points = {
	ZonePoint(48.6178217092593, 2.56854106637742, 0), 
	ZonePoint(48.6176677110602, 2.56871470865717, 0), 
	ZonePoint(48.6179001978173, 2.56937996504955, 0), 
	ZonePoint(48.618042503417, 2.56922406569716, 0)
}
objZonequestion.OriginalPoint = ZonePoint(48.6178580303885, 2.56896495144533, 0)
objZonequestion.DistanceRangeUOM = "Feet"
objZonequestion.ProximityRangeUOM = "Meters"
objZonequestion.OutOfRangeName = ""
objZonequestion.InRangeName = ""

-- Characters --
objJune1 = Wherigo.ZCharacter{
	Cartridge = objInitiation, 
	Container = objZonequestion
}
objJune1.Id = "42d45f5a-b2c7-4bed-abd6-90e027b82e31"
objJune1.Name = "June"
objJune1.Description = ""
objJune1.Visible = true
objJune1.Media = objJune
objJune1.Icon = objicon_June
objJune1.Commands = {
	cmdParler = Wherigo.ZCommand{
		Text = "Parler", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objJune1.Commands.cmdParler.Custom = true
objJune1.Commands.cmdParler.Id = "5339bf7c-3094-4029-85ed-a82dc20252ae"
objJune1.Commands.cmdParler.WorksWithAll = true
objJune1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objJune1.Gender = "It"
objJune1.Type = "NPC"

-- Items --
objCompletionCode = Wherigo.ZItem(objInitiation)
objCompletionCode.Id = "ba4272b2-d10c-4140-a0fa-a43db49148a9"
objCompletionCode.Name = "Completion Code"
objCompletionCode.Description = ""
objCompletionCode.Visible = true
objCompletionCode.Media = objBravo
objCompletionCode.Icon = objicon_Bravo
objCompletionCode.Commands = {}
objCompletionCode.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objCompletionCode.Locked = false
objCompletionCode.Opened = false
objSolution = Wherigo.ZItem(objInitiation)
objSolution.Id = "ab48998e-bdae-4fb5-9700-655c249c5452"
objSolution.Name = "Solution"
objSolution.Description = [[N48 37.076 E002 34.151
Dans l'arbre]]
objSolution.Visible = true
objSolution.Media = objTresor
objSolution.Icon = objicon_tresor
objSolution.Commands = {}
objSolution.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objSolution.Locked = false
objSolution.Opened = false

-- Tasks --
objRejoindrelaZonequestion = Wherigo.ZTask(objInitiation)
objRejoindrelaZonequestion.Id = "d90a6a91-43ef-48a1-b73d-d2c11b3942b5"
objRejoindrelaZonequestion.Name = "Rejoindre la \"Zone question\""
objRejoindrelaZonequestion.Description = "Rejoindre la \"Zone question\""
objRejoindrelaZonequestion.Visible = true
objRejoindrelaZonequestion.Active = false
objRejoindrelaZonequestion.Complete = false
objRejoindrelaZonequestion.CorrectState = "None"
objParleravecJune = Wherigo.ZTask(objInitiation)
objParleravecJune.Id = "a05b788a-f06b-4fae-96f3-9c274b63f025"
objParleravecJune.Name = "Parler avec June"
objParleravecJune.Description = "Parler avec June"
objParleravecJune.Visible = true
objParleravecJune.Active = false
objParleravecJune.Complete = false
objParleravecJune.CorrectState = "None"

-- Cartridge Variables --
currentZone = "objMapremierezone"
currentCharacter = "objJune1"
currentItem = "objCompletionCode"
currentTask = "objRejoindrelaZonequestion"
currentInput = "objQuestion"
currentTimer = "dummy"
objInitiation.ZVariables = {
	currentZone = "objMapremierezone", 
	currentCharacter = "objJune1", 
	currentItem = "objCompletionCode", 
	currentTask = "objRejoindrelaZonequestion", 
	currentInput = "objQuestion", 
	currentTimer = "dummy"
}

-- Timers --

-- Inputs --
objQuestion = Wherigo.ZInput(objInitiation)
objQuestion.Id = "ab05cd51-4b6b-4bb2-8b57-8129d2947541"
objQuestion.Name = "Question"
objQuestion.Description = "Question de la zone 2"
objQuestion.Visible = true
objQuestion.InputType = "Text"
objQuestion.Text = "Combien font 2 + 2"

-- WorksWithList for object commands --

-- functions --
function objInitiation:OnStart()
	_Urwigo.MessageBox{
		Text = [[Bonjour et bienvenu dans votre premiere cartouche.
Direction "Ma premiere zone".]], 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, objMapremierezone)
			end
		end
	}
end
function objInitiation:OnRestore()
end
function objMapremierezone:OnEnter()
	currentZone = "objMapremierezone"
	_Urwigo.MessageBox{
		Text = "Bienvenu dans \"Ma premiere zone\", direction la \"Zone question\"", 
		Callback = function(action)
			if action ~= nil then
				objZonequestion.Visible = true
				objZonequestion.Active = true
				objMapremierezone.Visible = false
				objMapremierezone.Active = false
				objRejoindrelaZonequestion.Active = true
				objInitiation:RequestSync()
			end
		end
	}
end
function objZonequestion:OnEnter()
	currentZone = "objZonequestion"
	_Urwigo.MessageBox{
		Text = "Bravo pour avoir rejoint la \"Zone question\", allez voir June"
	}
	objParleravecJune.Active = true
	objRejoindrelaZonequestion.Complete = true
end
function objQuestion:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 4 then
		_Urwigo.OldDialog{
			{
				Text = "Bravo c est la bonne reponse, vous etes un aventurier accompli! Je vous donne les coordonnes du tresor et le code de completion dans votre inventaire", 
				Media = objBravo
			}
		}
		objSolution:MoveTo(Player)
		objCompletionCode.Description = string.sub(Player.CompletionCode, 1, 15)
		objCompletionCode:MoveTo(Player)
	elseif input ~= 4 then
		_Urwigo.Dialog(false, {
			{
				Text = "Ce n est pas la bonne reponse, essayer encore!"
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(objQuestion)
			end)
		end)
	end
end
function objJune1:OncmdParler(target)
	objParleravecJune.Complete = true
	_Urwigo.Dialog(false, {
		{
			Text = "Maintenant un petit cacul"
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(objQuestion)
		end)
	end)
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return objInitiation
