require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

_JRwJ = Wherigo.ZCartridge()

-- String decode --
function _IPh2(str)
	local res = ""
    local dtable = "\106\103\000\043\067\024\032\051\080\030\065\035\100\076\042\050\109\120\059\031\105\068\098\028\008\007\040\116\029\009\012\026\115\110\095\117\064\069\052\025\093\002\006\081\022\053\094\101\113\126\096\044\074\112\061\118\019\036\017\073\027\063\072\102\078\122\055\047\086\124\049\004\060\088\108\056\111\058\011\091\034\066\046\023\114\041\015\014\087\062\045\090\048\033\121\119\016\104\038\082\077\083\070\125\099\092\005\013\085\003\001\084\020\089\123\079\039\057\107\021\054\075\010\071\018\037\097"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
_9T7N = Wherigo.ZMedia(_JRwJ)
_9T7N.Id = "12d873bc-071a-4306-86b2-f3c66157773c"
_9T7N.Name = _IPh2("\122\127\017\048\085\007\028\077\056\048\034\127\127\085")
_9T7N.Description = ""
_9T7N.AltText = ""
_9T7N.Resources = {
	{
		Type = "jpg", 
		Filename = "Alchemist.jpg", 
		Directives = {}
	}
}
_N3iAm = Wherigo.ZMedia(_JRwJ)
_N3iAm.Id = "0a92bd98-a336-4619-9f0b-995fc6d31b71"
_N3iAm.Name = _IPh2("\082\077\033")
_N3iAm.Description = ""
_N3iAm.AltText = ""
_N3iAm.Resources = {
	{
		Type = "jpg", 
		Filename = "Bos.jpg", 
		Directives = {}
	}
}
_eqN = Wherigo.ZMedia(_JRwJ)
_eqN.Id = "bf9330b8-e2ee-4786-9859-f774682a8e3f"
_eqN.Name = _IPh2("\082\077\033\007\013\077\034\119\048\085")
_eqN.Description = ""
_eqN.AltText = ""
_eqN.Resources = {
	{
		Type = "jpg", 
		Filename = "Bos2.jpg", 
		Directives = {}
	}
}
_u7FNe = Wherigo.ZMedia(_JRwJ)
_u7FNe.Id = "b4c6bc43-ac15-4c7e-9ab9-b476fd467fc6"
_u7FNe.Name = _IPh2("\082\077\033\048\075\064")
_u7FNe.Description = ""
_u7FNe.AltText = ""
_u7FNe.Resources = {
	{
		Type = "jpg", 
		Filename = "Boself.jpg", 
		Directives = {}
	}
}
_J23 = Wherigo.ZMedia(_JRwJ)
_J23.Id = "89f3481b-130e-47c5-8c51-96c177760e14"
_J23.Name = _IPh2("\082\077\095")
_J23.Description = ""
_J23.AltText = ""
_J23.Resources = {
	{
		Type = "jpg", 
		Filename = "Boy.jpg", 
		Directives = {}
	}
}
_m93H_ = Wherigo.ZMedia(_JRwJ)
_m93H_.Id = "d5b87f49-85f9-4d33-bf7b-8855c2844a53"
_m93H_.Name = _IPh2("\102\105\098\127\028\007\013\021\105\098\028")
_m93H_.Description = ""
_m93H_.AltText = ""
_m93H_.Resources = {
	{
		Type = "jpg", 
		Filename = "Dicht.jpg", 
		Directives = {}
	}
}
_2iAc = Wherigo.ZMedia(_JRwJ)
_2iAc.Id = "838ef18b-e6d6-41f4-9a6b-90739da7ff8f"
_2iAc.Name = _IPh2("\022\077\034\119\048\085\007\054\127\013")
_2iAc.Description = ""
_2iAc.AltText = ""
_2iAc.Resources = {
	{
		Type = "jpg", 
		Filename = "Doorgang.jpg", 
		Directives = {}
	}
}
_RoAD3 = Wherigo.ZMedia(_JRwJ)
_RoAD3.Id = "f5163cd7-f3fb-4db2-8989-06a887e4e5e2"
_RoAD3.Name = _IPh2("\022\085\127\127\119")
_RoAD3.Description = ""
_RoAD3.AltText = ""
_RoAD3.Resources = {
	{
		Type = "jpg", 
		Filename = "Draak.jpg", 
		Directives = {}
	}
}
_nsH = Wherigo.ZMedia(_JRwJ)
_nsH.Id = "f09e1489-c970-4e45-b666-b524f2dda77c"
_nsH.Name = _IPh2("\022\085\127\119\048\034\048\021")
_nsH.Description = ""
_nsH.AltText = ""
_nsH.Resources = {
	{
		Type = "jpg", 
		Filename = "dragonegg.jpg", 
		Directives = {}
	}
}
_zEcc = Wherigo.ZMedia(_JRwJ)
_zEcc.Id = "e9ec6134-fb31-4b18-a2b4-00bdc856f4ae"
_zEcc.Name = _IPh2("\038\048\034\098\077\077\085\034")
_zEcc.Description = ""
_zEcc.AltText = ""
_zEcc.Resources = {
	{
		Type = "jpg", 
		Filename = "eenhoorn.jpg", 
		Directives = {}
	}
}
_lTED = Wherigo.ZMedia(_JRwJ)
_lTED.Id = "3d6f6fef-0b54-4340-8c66-67b18f626c41"
_lTED.Name = _IPh2("\048\021")
_lTED.Description = ""
_lTED.AltText = ""
_lTED.Resources = {
	{
		Type = "jpg", 
		Filename = "Ei.jpg", 
		Directives = {}
	}
}
_4e5L = Wherigo.ZMedia(_JRwJ)
_4e5L.Id = "69e56cbc-34c2-4e11-aa25-ff14f09d05f5"
_4e5L.Name = _IPh2("\063\048\075\054\033\028\048\085")
_4e5L.Description = ""
_4e5L.AltText = ""
_4e5L.Resources = {
	{
		Type = "jpg", 
		Filename = "fantasygirl.jpg", 
		Directives = {}
	}
}
__MBWj = Wherigo.ZMedia(_JRwJ)
__MBWj.Id = "10c29e18-a0fa-4c3f-b27b-35f0fa5587c2"
__MBWj.Name = _IPh2("\069\021\034\013\054\075\127\127\028\033\007\066\096\127\127\085\013")
__MBWj.Description = ""
__MBWj.AltText = ""
__MBWj.Resources = {
	{
		Type = "jpg", 
		Filename = "Findingplacesword.jpg", 
		Directives = {}
	}
}
_1KcOS = Wherigo.ZMedia(_JRwJ)
_1KcOS.Id = "ed30bea2-0f4f-4e72-a910-367512b984c3"
_1KcOS.Name = _IPh2("\124\021\085\075")
_1KcOS.Description = ""
_1KcOS.AltText = ""
_1KcOS.Resources = {
	{
		Type = "jpg", 
		Filename = "Girl.jpg", 
		Directives = {}
	}
}
_jn_ = Wherigo.ZMedia(_JRwJ)
_jn_.Id = "4a1f7f1f-40e0-438c-ba5f-99bae863cdae"
_jn_.Name = _IPh2("\122\048\085\119\098\077\064")
_jn_.Description = ""
_jn_.AltText = ""
_jn_.Resources = {
	{
		Type = "jpg", 
		Filename = "Kerkhof.jpg", 
		Directives = {}
	}
}
_JvpY = Wherigo.ZMedia(_JRwJ)
_JvpY.Id = "0feeda8d-6b85-490d-9fde-bb6275a7c7bf"
_JvpY.Name = _IPh2("\102\075\048\036\028\048\075")
_JvpY.Description = ""
_JvpY.AltText = ""
_JvpY.Resources = {
	{
		Type = "jpg", 
		Filename = "Key.jpg", 
		Directives = {}
	}
}
_1Ewq = Wherigo.ZMedia(_JRwJ)
_1Ewq.Id = "f1ef3e8d-040b-49bb-9ef0-1845c2497d74"
_1Ewq.Name = _IPh2("\060\105\077\077\034\007\033\075\048\036\028\048\075")
_1Ewq.Description = ""
_1Ewq.AltText = ""
_1Ewq.Resources = {
	{
		Type = "jpg", 
		Filename = "Keyicoon.jpg", 
		Directives = {}
	}
}
_P8O = Wherigo.ZMedia(_JRwJ)
_P8O.Id = "a83f741d-28b7-46e8-a071-adf30f4fc1fd"
_P8O.Name = _IPh2("\122\034\021\119\119\048\085\033")
_P8O.Description = ""
_P8O.AltText = ""
_P8O.Resources = {
	{
		Type = "jpg", 
		Filename = "knikkers.jpg", 
		Directives = {}
	}
}
_Mv1Y3 = Wherigo.ZMedia(_JRwJ)
_Mv1Y3.Id = "ba632e8b-b15a-4e58-996d-3ffd661bc1dc"
_Mv1Y3.Name = _IPh2("\060\105\077\077\034\007\122\034\021\119\119\048\085\033")
_Mv1Y3.Description = ""
_Mv1Y3.AltText = ""
_Mv1Y3.Resources = {
	{
		Type = "jpg", 
		Filename = "knikkersicoon.jpg", 
		Directives = {}
	}
}
_WHxJ = Wherigo.ZMedia(_JRwJ)
_WHxJ.Id = "1cfaf827-a245-4be0-b31f-ea22fd228510"
_WHxJ.Name = _IPh2("\122\077\119\048\034")
_WHxJ.Description = ""
_WHxJ.AltText = ""
_WHxJ.Resources = {
	{
		Type = "jpg", 
		Filename = "Koken.jpg", 
		Directives = {}
	}
}
_6_z6 = Wherigo.ZMedia(_JRwJ)
_6_z6.Id = "475f08b5-d6a9-45a7-b484-458cb8e4c5e2"
_6_z6.Name = _IPh2("\075\127\056\048\034\013\048\075")
_6_z6.Description = ""
_6_z6.AltText = ""
_6_z6.Resources = {
	{
		Type = "jpg", 
		Filename = "Lavendal.jpg", 
		Directives = {}
	}
}
_JqE = Wherigo.ZMedia(_JRwJ)
_JqE.Id = "b59f3529-f280-4d54-b6e5-6b1cd5d83333"
_JqE.Name = _IPh2("\060\105\077\077\034\007\014\127\056\048\034\013\048\075")
_JqE.Description = ""
_JqE.AltText = ""
_JqE.Resources = {
	{
		Type = "jpg", 
		Filename = "LavendalIcoon.jpg", 
		Directives = {}
	}
}
_tUO = Wherigo.ZMedia(_JRwJ)
_tUO.Id = "920b5137-266a-4b47-8c47-724fca77e74f"
_tUO.Name = _IPh2("\014\127\056\048\034\013\048\075\056\048\075\013")
_tUO.Description = ""
_tUO.AltText = ""
_tUO.Resources = {
	{
		Type = "jpg", 
		Filename = "lavendelveld.jpg", 
		Directives = {}
	}
}
_njheF = Wherigo.ZMedia(_JRwJ)
_njheF.Id = "4c1efb52-6eef-4396-80a3-3f5aa644e99d"
_njheF.Name = _IPh2("\112\077\056\048\085\013\085\127\034\119")
_njheF.Description = ""
_njheF.AltText = ""
_njheF.Resources = {
	{
		Type = "jpg", 
		Filename = "mana-energy-potion.jpg", 
		Directives = {}
	}
}
_q48 = Wherigo.ZMedia(_JRwJ)
_q48.Id = "ef276499-15f1-438c-97d4-bfc0f2289e53"
_q48.Name = _IPh2("\060\105\077\077\034\007\028\077\056\048\085\013\085\127\034\119")
_q48.Description = ""
_q48.AltText = ""
_q48.Resources = {
	{
		Type = "jpg", 
		Filename = "mana-energy-potionicoon.jpg", 
		Directives = {}
	}
}
_bwp = Wherigo.ZMedia(_JRwJ)
_bwp.Id = "b47a0ad2-6e37-49e8-a426-a230a31d22db"
_bwp.Name = _IPh2("\101\077\048\085\127\033")
_bwp.Description = ""
_bwp.AltText = ""
_bwp.Resources = {
	{
		Type = "jpg", 
		Filename = "Moeras.jpg", 
		Directives = {}
	}
}
_vJKc = Wherigo.ZMedia(_JRwJ)
_vJKc.Id = "156092cf-78ac-4141-9810-df9414340286"
_vJKc.Name = _IPh2("\009\077\028")
_vJKc.Description = ""
_vJKc.AltText = ""
_vJKc.Resources = {
	{
		Type = "jpg", 
		Filename = "Pot.jpg", 
		Directives = {}
	}
}
_RoJ2e = Wherigo.ZMedia(_JRwJ)
_RoJ2e.Id = "aeb39add-c990-4635-90e7-219d62ea1eca"
_RoJ2e.Name = _IPh2("\060\105\077\077\034\007\054\077\028")
_RoJ2e.Description = ""
_RoJ2e.AltText = ""
_RoJ2e.Resources = {
	{
		Type = "jpg", 
		Filename = "poticoon.jpg", 
		Directives = {}
	}
}
_jJzD = Wherigo.ZMedia(_JRwJ)
_jJzD.Id = "db828ed8-5c0d-4fc4-a8ae-d75b0440190f"
_jJzD.Name = _IPh2("\060\105\077\077\034\007\102\105\098\048\013\048\075")
_jJzD.Description = ""
_jJzD.AltText = ""
_jJzD.Resources = {
	{
		Type = "jpg", 
		Filename = "Schedel2icoon.jpg", 
		Directives = {}
	}
}
_K3Rd = Wherigo.ZMedia(_JRwJ)
_K3Rd.Id = "c6f09d15-2f6f-4799-8d49-50f598dc4852"
_K3Rd.Name = _IPh2("\102\105\098\048\013\048\075")
_K3Rd.Description = ""
_K3Rd.AltText = ""
_K3Rd.Resources = {
	{
		Type = "jpg", 
		Filename = "Schedel2.jpg", 
		Directives = {}
	}
}
_TsRb = Wherigo.ZMedia(_JRwJ)
_TsRb.Id = "71d55c20-ee74-4e89-a294-acf33018bd29"
_TsRb.Name = _IPh2("\102\054\085\077\077\119\001\048\033\023\077\033")
_TsRb.Description = ""
_TsRb.AltText = ""
_TsRb.Resources = {
	{
		Type = "jpg", 
		Filename = "Sprookjesbos.jpg", 
		Directives = {}
	}
}
_sR91 = Wherigo.ZMedia(_JRwJ)
_sR91.Id = "b31d03f5-8424-41bd-87ee-bda4ce4c6241"
_sR91.Name = _IPh2("\092\096\127\127\085\013")
_sR91.Description = ""
_sR91.AltText = ""
_sR91.Resources = {
	{
		Type = "jpg", 
		Filename = "Sword.jpg", 
		Directives = {}
	}
}
_J3n7 = Wherigo.ZMedia(_JRwJ)
_J3n7.Id = "00176e45-1add-4796-85ec-951204ef1645"
_J3n7.Name = _IPh2("\060\105\077\077\034\007\092\096\127\127\085\013")
_J3n7.Description = ""
_J3n7.AltText = ""
_J3n7.Resources = {
	{
		Type = "jpg", 
		Filename = "Swordicoon.jpg", 
		Directives = {}
	}
}
_EqW9I = Wherigo.ZMedia(_JRwJ)
_EqW9I.Id = "dcb25d8b-9b3d-4767-a6e8-8336a81cfe11"
_EqW9I.Name = _IPh2("\102\105\098\127\028")
_EqW9I.Description = ""
_EqW9I.AltText = ""
_EqW9I.Resources = {
	{
		Type = "jpg", 
		Filename = "Treasure.jpg", 
		Directives = {}
	}
}
_tcNw = Wherigo.ZMedia(_JRwJ)
_tcNw.Id = "0fec6295-877d-4c83-b91f-9e64833a3408"
_tcNw.Name = _IPh2("\022\085\127\127\119\007\056\075\021\048\002\048\034\013")
_tcNw.Description = ""
_tcNw.AltText = ""
_tcNw.Resources = {
	{
		Type = "jpg", 
		Filename = "Vliegendedraak.jpg", 
		Directives = {}
	}
}
_3zxK = Wherigo.ZMedia(_JRwJ)
_3zxK.Id = "7f02fb55-1a18-4d4c-b1eb-e932dcfa09e1"
_3zxK.Name = _IPh2("\089\127\028\048\085\048\075\064")
_3zxK.Description = ""
_3zxK.AltText = ""
_3zxK.Resources = {
	{
		Type = "jpg", 
		Filename = "Waterelf.jpg", 
		Directives = {}
	}
}
_PmV = Wherigo.ZMedia(_JRwJ)
_PmV.Id = "d8123738-e73d-43dd-8fff-e359e825cee2"
_PmV.Name = _IPh2("\089\048\048\085\096\077\075\064")
_PmV.Description = ""
_PmV.AltText = ""
_PmV.Resources = {
	{
		Type = "jpg", 
		Filename = "Weerwolf.jpg", 
		Directives = {}
	}
}
_r4bN = Wherigo.ZMedia(_JRwJ)
_r4bN.Id = "8302061f-5081-4027-b0ee-1939eba42399"
_r4bN.Name = _IPh2("\112\077\056\048\034\127\127\085")
_r4bN.Description = ""
_r4bN.AltText = ""
_r4bN.Resources = {
	{
		Type = "jpg", 
		Filename = "wizard.jpg", 
		Directives = {}
	}
}
_ILaS = Wherigo.ZMedia(_JRwJ)
_ILaS.Id = "1783e816-2b3c-4bf7-89b9-965f52d07dcf"
_ILaS.Name = _IPh2("\060\105\077\077\034")
_ILaS.Description = ""
_ILaS.AltText = ""
_ILaS.Resources = {
	{
		Type = "jpg", 
		Filename = "Eiicoon.jpg", 
		Directives = {}
	}
}
_svEJf = Wherigo.ZMedia(_JRwJ)
_svEJf.Id = "abb1578b-50dc-466d-8727-4297ffb38616"
_svEJf.Name = _IPh2("\022\085\127\119\048\034\033\105\098\127\028")
_svEJf.Description = ""
_svEJf.AltText = ""
_svEJf.Resources = {
	{
		Type = "jpg", 
		Filename = "Drakenschat.jpg", 
		Directives = {}
	}
}
_fTF = Wherigo.ZMedia(_JRwJ)
_fTF.Id = "2e0e1042-1db9-4c5f-b201-ecc9d02109e2"
_fTF.Name = _IPh2("\022\085\127\127\021\048\085\021\002")
_fTF.Description = ""
_fTF.AltText = ""
_fTF.Resources = {
	{
		Type = "jpg", 
		Filename = "Draaierig.jpg", 
		Directives = {}
	}
}
_zpdP4 = Wherigo.ZMedia(_JRwJ)
_zpdP4.Id = "2d7feb8d-2051-4c8d-9e22-c9ab46405e07"
_zpdP4.Name = _IPh2("\102\035\119\048\085\119\098\077\064")
_zpdP4.Description = ""
_zpdP4.AltText = ""
_zpdP4.Resources = {
	{
		Type = "mp3", 
		Filename = "geluidheksen.mp3", 
		Directives = {}
	}
}
_rLqn = Wherigo.ZMedia(_JRwJ)
_rLqn.Id = "5a9d1d79-8350-4e48-b09d-9872f53b2ec1"
_rLqn.Name = _IPh2("\102\035\066\096\127\127\085\013")
_rLqn.Description = ""
_rLqn.AltText = ""
_rLqn.Resources = {
	{
		Type = "mp3", 
		Filename = "sword.mp3", 
		Directives = {}
	}
}
_PCsOM = Wherigo.ZMedia(_JRwJ)
_PCsOM.Id = "b3131539-ea1e-4112-bb43-8122ee980bf0"
_PCsOM.Name = _IPh2("\102\035\017\077\048\085\127\033")
_PCsOM.Description = ""
_PCsOM.AltText = ""
_PCsOM.Resources = {
	{
		Type = "mp3", 
		Filename = "Bats.mp3", 
		Directives = {}
	}
}
_jKa = Wherigo.ZMedia(_JRwJ)
_jKa.Id = "56aa27d6-48be-4ab0-91ea-3c1195503be3"
_jKa.Name = _IPh2("\102\035\082\077\033")
_jKa.Description = ""
_jKa.AltText = ""
_jKa.Resources = {
	{
		Type = "mp3", 
		Filename = "forest.mp3", 
		Directives = {}
	}
}
_tvV = Wherigo.ZMedia(_JRwJ)
_tvV.Id = "7de217ba-3650-4912-ae2d-bc5e37d06daa"
_tvV.Name = _IPh2("\102\035\056\075\021\048\002\048\034\013\048\007\013\085\127\127\119")
_tvV.Description = ""
_tvV.AltText = ""
_tvV.Resources = {
	{
		Type = "mp3", 
		Filename = "junglebird.mp3", 
		Directives = {}
	}
}
_iy2 = Wherigo.ZMedia(_JRwJ)
_iy2.Id = "371b5ffc-c603-4c00-aea5-246d8ab5044b"
_iy2.Name = _IPh2("\102\035\096\048\048\085\096\077\075\064")
_iy2.Description = ""
_iy2.AltText = ""
_iy2.Resources = {
	{
		Type = "mp3", 
		Filename = "Lion.mp3", 
		Directives = {}
	}
}
_qe7 = Wherigo.ZMedia(_JRwJ)
_qe7.Id = "bc885e3f-1725-4d0b-9147-6ca255fd5d6d"
_qe7.Name = _IPh2("\102\035\054\077\028")
_qe7.Description = ""
_qe7.AltText = ""
_qe7.Resources = {
	{
		Type = "mp3", 
		Filename = "pan.mp3", 
		Directives = {}
	}
}
_ZnbZw = Wherigo.ZMedia(_JRwJ)
_ZnbZw.Id = "29b2d2f7-baba-4d88-b7cc-a8fd1722758e"
_ZnbZw.Name = _IPh2("\102\035\098\048\085\085\021\048")
_ZnbZw.Description = ""
_ZnbZw.AltText = ""
_ZnbZw.Resources = {
	{
		Type = "mp3", 
		Filename = "potsandpans.mp3", 
		Directives = {}
	}
}
_8qaUE = Wherigo.ZMedia(_JRwJ)
_8qaUE.Id = "7cd2eed4-3bb7-49db-8158-f924334cc606"
_8qaUE.Name = _IPh2("\102\035\096\127\028\048\085\034\021\017\064")
_8qaUE.Description = ""
_8qaUE.AltText = ""
_8qaUE.Resources = {
	{
		Type = "mp3", 
		Filename = "swampjungle.mp3", 
		Directives = {}
	}
}
_N4l7E = Wherigo.ZMedia(_JRwJ)
_N4l7E.Id = "7eca7a19-0ae1-48fb-b7d0-bf2e19a74cea"
_N4l7E.Name = _IPh2("\102\035\119\077\119\048\034")
_N4l7E.Description = ""
_N4l7E.AltText = ""
_N4l7E.Resources = {
	{
		Type = "mp3", 
		Filename = "bubbling.mp3", 
		Directives = {}
	}
}
_8jF = Wherigo.ZMedia(_JRwJ)
_8jF.Id = "8cd6c7fb-1116-49b9-a118-4eabeea9fe84"
_8jF.Name = _IPh2("\102\035\002\048\002\085\077\017")
_8jF.Description = ""
_8jF.AltText = ""
_8jF.Resources = {
	{
		Type = "mp3", 
		Filename = "GEGROM.mp3", 
		Directives = {}
	}
}
_g6tLU = Wherigo.ZMedia(_JRwJ)
_g6tLU.Id = "981b388b-9de0-4fd1-8427-9a8b7ea73c0f"
_g6tLU.Name = _IPh2("\102\035\002\048\098\021\001\002")
_g6tLU.Description = ""
_g6tLU.AltText = ""
_g6tLU.Resources = {
	{
		Type = "mp3", 
		Filename = "PantingMale.mp3", 
		Directives = {}
	}
}
_Ata = Wherigo.ZMedia(_JRwJ)
_Ata.Id = "b43e926e-48ae-46c9-9932-6e9f18039d04"
_Ata.Name = _IPh2("\102\035\028\077\056\048\085\013\085\127\034\119")
_Ata.Description = ""
_Ata.AltText = ""
_Ata.Resources = {
	{
		Type = "mp3", 
		Filename = "Swirl03.mp3", 
		Directives = {}
	}
}
_99O = Wherigo.ZMedia(_JRwJ)
_99O.Id = "cdef00a3-1b87-4f5a-9384-96c517a20049"
_99O.Name = _IPh2("\102\035\048\048\034\098\077\077\085\034")
_99O.Description = ""
_99O.AltText = ""
_99O.Resources = {
	{
		Type = "mp3", 
		Filename = "Horse.mp3", 
		Directives = {}
	}
}
_MY4 = Wherigo.ZMedia(_JRwJ)
_MY4.Id = "d2e9c783-a4b6-46f5-83e6-ddc5f4112c3f"
_MY4.Name = _IPh2("\102\035\002\048\056\048\105\098\028")
_MY4.Description = ""
_MY4.AltText = ""
_MY4.Resources = {
	{
		Type = "mp3", 
		Filename = "Zwaardgevecht.mp3", 
		Directives = {}
	}
}
_NUcJ = Wherigo.ZMedia(_JRwJ)
_NUcJ.Id = "6b0e601b-417e-49b8-8eef-348ee58630c6"
_NUcJ.Name = _IPh2("\102\035\033\105\098\048\013\048\075")
_NUcJ.Description = ""
_NUcJ.AltText = ""
_NUcJ.Resources = {
	{
		Type = "mp3", 
		Filename = "aaa.mp3", 
		Directives = {}
	}
}
_VBpm7 = Wherigo.ZMedia(_JRwJ)
_VBpm7.Id = "0ebacdc6-8853-4cc8-a90e-12b47820e8c6"
_VBpm7.Name = _IPh2("\102\035\075\127\056\048\034\013\048\075\056\048\075\013")
_VBpm7.Description = ""
_VBpm7.AltText = ""
_VBpm7.Resources = {
	{
		Type = "mp3", 
		Filename = "99Veldleeuwerik.mp3", 
		Directives = {}
	}
}
_liXm7 = Wherigo.ZMedia(_JRwJ)
_liXm7.Id = "b034f316-be26-497b-b553-3f7e1b928690"
_liXm7.Name = _IPh2("\102\035\096\077\075\064")
_liXm7.Description = ""
_liXm7.AltText = ""
_liXm7.Resources = {
	{
		Type = "mp3", 
		Filename = "Wolf.mp3", 
		Directives = {}
	}
}
_hFW = Wherigo.ZMedia(_JRwJ)
_hFW.Id = "ab1bfdeb-b224-4a9e-8ab4-dbaad433e370"
_hFW.Name = _IPh2("\102\035\033\034\036\085\119")
_hFW.Description = ""
_hFW.AltText = ""
_hFW.Resources = {
	{
		Type = "mp3", 
		Filename = "Snurkk.mp3", 
		Directives = {}
	}
}
_51R = Wherigo.ZMedia(_JRwJ)
_51R.Id = "5a1bba6f-b0cb-47e0-b8a4-24e58d85a0e4"
_51R.Name = _IPh2("\089\048\119\119\048\085")
_51R.Description = ""
_51R.AltText = ""
_51R.Resources = {
	{
		Type = "mp3", 
		Filename = "alarm-clock-1.mp3", 
		Directives = {}
	}
}
-- Cartridge Info --
_JRwJ.Id="5782f79d-900b-42e0-8e22-bad36eee4189"
_JRwJ.Name="De drakenschat"
_JRwJ.Description=[[Kun jij de schat van de draak vinden? ]]
_JRwJ.Visible=true
_JRwJ.Activity="Fiction"
_JRwJ.StartingLocationDescription=[[]]
_JRwJ.StartingLocation = ZonePoint(52.1861815672834,6.88867952674627,0)
_JRwJ.Version="2"
_JRwJ.Company=""
_JRwJ.Author="Chemruz"
_JRwJ.BuilderVersion="URWIGO 1.12.4281.38707"
_JRwJ.CreateDate="10/17/2010 16:28:45"
_JRwJ.PublishDate="1/1/0001 12:00:00 AM"
_JRwJ.UpdateDate="03/04/2012 18:52:18"
_JRwJ.LastPlayedDate="1/1/0001 12:00:00 AM"
_JRwJ.TargetDevice="PocketPC"
_JRwJ.TargetDeviceVersion="0"
_JRwJ.StateId="1"
_JRwJ.CountryId="2"
_JRwJ.Complete=false
_JRwJ.UseLogging=true

_JRwJ.Media=_svEJf


-- Zones --
_vcPpg = Wherigo.Zone(_JRwJ)
_vcPpg.Id = "598dbd61-0ab5-4ea1-892d-1e6640ff50a5"
_vcPpg.Name = _IPh2("\124\048\098\048\021\017\066\021\034\034\021\002\048\007\054\075\048\119")
_vcPpg.Description = ""
_vcPpg.Visible = false
_vcPpg.Media = _N3iAm
_vcPpg.Commands = {}
_vcPpg.DistanceRange = Distance(-1, "feet")
_vcPpg.ShowObjects = "OnEnter"
_vcPpg.ProximityRange = Distance(20, "meters")
_vcPpg.AllowSetPositionTo = false
_vcPpg.Active = false
_vcPpg.Points = {
	ZonePoint(52.1846933097722, 6.88985701650381, 0), 
	ZonePoint(52.1844696557195, 6.88991066068411, 0), 
	ZonePoint(52.1844564995637, 6.88949223607779, 0), 
	ZonePoint(52.1846735756363, 6.88944932073355, 0)
}
_vcPpg.OriginalPoint = ZonePoint(52.1845732601729, 6.88967730849981, 0)
_vcPpg.DistanceRangeUOM = "Feet"
_vcPpg.ProximityRangeUOM = "Meters"
_vcPpg.OutOfRangeName = ""
_vcPpg.InRangeName = ""
_RmH = Wherigo.Zone(_JRwJ)
_RmH.Id = "aaabdc3d-c97c-43e8-87dd-856f450ff562"
_RmH.Name = _IPh2("\082\077\033")
_RmH.Description = _IPh2("\063\021\048\085\007\002\048\023\048\036\085\048\034\007\056\085\048\048\017\013\048\007\013\021\034\002\048\034")
_RmH.Visible = false
_RmH.Media = _eqN
_RmH.Commands = {}
_RmH.DistanceRange = Distance(-1, "feet")
_RmH.ShowObjects = "OnEnter"
_RmH.ProximityRange = Distance(60, "meters")
_RmH.AllowSetPositionTo = false
_RmH.Active = true
_RmH.Points = {
	ZonePoint(52.1857161838233, 6.8958705291152, 0), 
	ZonePoint(52.1852425730398, 6.89604219049215, 0), 
	ZonePoint(52.1853478203165, 6.89784463495016, 0), 
	ZonePoint(52.185847741479, 6.89775880426168, 0)
}
_RmH.OriginalPoint = ZonePoint(52.1855385796647, 6.8968790397048, 0)
_RmH.DistanceRangeUOM = "Feet"
_RmH.ProximityRangeUOM = "Meters"
_RmH.OutOfRangeName = ""
_RmH.InRangeName = ""
_V1Hc = Wherigo.Zone(_JRwJ)
_V1Hc.Id = "a827df46-8423-4b56-8df9-cd38f9f2f9af"
_V1Hc.Name = _IPh2("\022\077\077\085\002\127\034\002")
_V1Hc.Description = ""
_V1Hc.Visible = false
_V1Hc.Media = _2iAc
_V1Hc.Commands = {}
_V1Hc.DistanceRange = Distance(-1, "feet")
_V1Hc.ShowObjects = "OnEnter"
_V1Hc.ProximityRange = Distance(60, "meters")
_V1Hc.AllowSetPositionTo = false
_V1Hc.Active = true
_V1Hc.Points = {
	ZonePoint(52.184787046798, 6.89694073051214, 0), 
	ZonePoint(52.1848643385829, 6.89766760915518, 0), 
	ZonePoint(52.1837855304578, 6.89827915281057, 0), 
	ZonePoint(52.1837000140602, 6.89750667661428, 0)
}
_V1Hc.OriginalPoint = ZonePoint(52.1842842324747, 6.89759854227304, 0)
_V1Hc.DistanceRangeUOM = "Feet"
_V1Hc.ProximityRangeUOM = "Meters"
_V1Hc.OutOfRangeName = ""
_V1Hc.InRangeName = ""
_jF2F = Wherigo.Zone(_JRwJ)
_jF2F.Id = "9b1d20c2-360f-465c-9830-c7def276183b"
_jF2F.Name = _IPh2("\122\048\085\119\098\077\064")
_jF2F.Description = _IPh2("\063\021\048\085\007\013\077\077\075\028\007\013\048\007\096\048\048\085\096\077\075\064\007\085\077\034\013\083\007\009\127\033\007\099\034\023\033\054\019\002\077\048\013\007\077\054\007\048\034\007\066\077\085\002\007\013\127\028\007\001\048\007\033\034\048\075\007\001\048\007\013\085\127\119\048\034\013\077\013\048\085\007\119\036\034\028\007\054\127\119\119\048\034\083")
_jF2F.Visible = false
_jF2F.Media = _jn_
_jF2F.Commands = {}
_jF2F.DistanceRange = Distance(-1, "feet")
_jF2F.ShowObjects = "OnEnter"
_jF2F.ProximityRange = Distance(30, "meters")
_jF2F.AllowSetPositionTo = false
_jF2F.Active = true
_jF2F.Points = {
	ZonePoint(52.1845880609465, 6.89322050660849, 0), 
	ZonePoint(52.1852540844729, 6.89249362796545, 0), 
	ZonePoint(52.1855254245312, 6.89343240112066, 0), 
	ZonePoint(52.1852195501649, 6.89368721097708, 0)
}
_jF2F.OriginalPoint = ZonePoint(52.1851467800289, 6.89320843666792, 0)
_jF2F.DistanceRangeUOM = "Feet"
_jF2F.ProximityRangeUOM = "Meters"
_jF2F.OutOfRangeName = ""
_jF2F.InRangeName = ""
_1bkW = Wherigo.Zone(_JRwJ)
_1bkW.Id = "c18568c3-0a91-42f5-8771-a4b761b660bb"
_1bkW.Name = _IPh2("\101\077\048\085\127\033")
_1bkW.Description = ""
_1bkW.Visible = false
_1bkW.Media = _bwp
_1bkW.Commands = {}
_1bkW.DistanceRange = Distance(-1, "feet")
_1bkW.ShowObjects = "OnEnter"
_1bkW.ProximityRange = Distance(20, "meters")
_1bkW.AllowSetPositionTo = false
_1bkW.Active = false
_1bkW.Points = {
	ZonePoint(52.1839549182218, 6.89417269080877, 0), 
	ZonePoint(52.1841654186214, 6.89461257308722, 0), 
	ZonePoint(52.183336567535, 6.89542796462774, 0), 
	ZonePoint(52.1831523763068, 6.89494516700506, 0)
}
_1bkW.OriginalPoint = ZonePoint(52.1836523201712, 6.8947895988822, 0)
_1bkW.DistanceRangeUOM = "Feet"
_1bkW.ProximityRangeUOM = "Meters"
_1bkW.OutOfRangeName = ""
_1bkW.InRangeName = ""
_9Fsgz = Wherigo.Zone(_JRwJ)
_9Fsgz.Id = "df2e8cff-a40a-4a65-bd61-f1ade4bf44c3"
_9Fsgz.Name = _IPh2("\014\127\056\048\034\013\048\075\056\048\075\013")
_9Fsgz.Description = ""
_9Fsgz.Visible = false
_9Fsgz.Media = _tUO
_9Fsgz.Commands = {}
_9Fsgz.DistanceRange = Distance(-1, "feet")
_9Fsgz.ShowObjects = "OnEnter"
_9Fsgz.ProximityRange = Distance(60, "meters")
_9Fsgz.AllowSetPositionTo = false
_9Fsgz.Active = false
_9Fsgz.Points = {
	ZonePoint(52.1855320024513, 6.89420755952597, 0), 
	ZonePoint(52.1859200980238, 6.89563449472189, 0), 
	ZonePoint(52.1852672403926, 6.89591076225042, 0), 
	ZonePoint(52.1849531417444, 6.89491029828787, 0)
}
_9Fsgz.OriginalPoint = ZonePoint(52.185418120653, 6.89516577869654, 0)
_9Fsgz.DistanceRangeUOM = "Feet"
_9Fsgz.ProximityRangeUOM = "Meters"
_9Fsgz.OutOfRangeName = ""
_9Fsgz.InRangeName = ""
_5w1HT = Wherigo.Zone(_JRwJ)
_5w1HT.Id = "38ff9dc9-3e8a-496a-afeb-04793cb8217a"
_5w1HT.Name = _IPh2("\102\054\085\077\077\119\001\048\033\023\077\033")
_5w1HT.Description = ""
_5w1HT.Visible = false
_5w1HT.Commands = {}
_5w1HT.DistanceRange = Distance(-1, "feet")
_5w1HT.ShowObjects = "OnEnter"
_5w1HT.ProximityRange = Distance(60, "meters")
_5w1HT.AllowSetPositionTo = false
_5w1HT.Active = false
_5w1HT.Points = {
	ZonePoint(52.1868031672757, 6.89191427081823, 0), 
	ZonePoint(52.1872504507829, 6.89202155917883, 0), 
	ZonePoint(52.187066275766, 6.88951101154089, 0), 
	ZonePoint(52.187210984772, 6.88760127872229, 0), 
	ZonePoint(52.184211465451, 6.8858202919364, 0), 
	ZonePoint(52.1814880424037, 6.89217176288366, 0), 
	ZonePoint(52.1810275437615, 6.89549770206213, 0), 
	ZonePoint(52.1818959086476, 6.89938154071569, 0), 
	ZonePoint(52.186303256855, 6.90176334232092, 0), 
	ZonePoint(52.187210984772, 6.89242925494909, 0), 
	ZonePoint(52.1868163227372, 6.89242925494909, 0), 
	ZonePoint(52.1860138324635, 6.90114106982946, 0), 
	ZonePoint(52.1821853598417, 6.89908113330603, 0), 
	ZonePoint(52.1814880424037, 6.89599122852087, 0), 
	ZonePoint(52.1817774962524, 6.89320173114538, 0), 
	ZonePoint(52.1844088084664, 6.88663568347692, 0), 
	ZonePoint(52.1868426336485, 6.88790168613195, 0)
}
_5w1HT.OriginalPoint = ZonePoint(52.184705916253, 6.8932055177934, 0)
_5w1HT.DistanceRangeUOM = "Feet"
_5w1HT.ProximityRangeUOM = "Meters"
_5w1HT.OutOfRangeName = ""
_5w1HT.InRangeName = ""
__gNg_ = Wherigo.Zone(_JRwJ)
__gNg_.Id = "7839c4e1-c50b-43b4-bec8-f8a1771cb600"
__gNg_.Name = _IPh2("\069\021\034\013\054\075\127\127\028\033\007\033\105\098\127\028")
__gNg_.Description = ""
__gNg_.Visible = false
__gNg_.Media = _m93H_
__gNg_.Commands = {}
__gNg_.DistanceRange = Distance(-1, "feet")
__gNg_.ShowObjects = "OnEnter"
__gNg_.ProximityRange = Distance(30, "meters")
__gNg_.AllowSetPositionTo = false
__gNg_.Active = false
__gNg_.Points = {
	ZonePoint(52.1862473454716, 6.8896934017539, 0), 
	ZonePoint(52.1860500106155, 6.88958611339331, 0), 
	ZonePoint(52.1859842321355, 6.88992943614721, 0), 
	ZonePoint(52.1861552559811, 6.89003672450781, 0)
}
__gNg_.OriginalPoint = ZonePoint(52.1861092110509, 6.88981141895056, 0)
__gNg_.DistanceRangeUOM = "Feet"
__gNg_.ProximityRangeUOM = "Meters"
__gNg_.OutOfRangeName = ""
__gNg_.InRangeName = ""

-- Characters --
_qCfK = Wherigo.ZCharacter{
	Cartridge = _JRwJ, 
	Container = _RmH
}
_qCfK.Id = "1c1b744c-e640-4289-b358-338914f83dd5"
_qCfK.Name = _IPh2("\082\077\033\048\075\064")
_qCfK.Description = ""
_qCfK.Visible = true
_qCfK.Media = _u7FNe
_qCfK.Commands = {}
_qCfK.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_qCfK.Gender = "Female"
_qCfK.Type = "NPC"
_7MF = Wherigo.ZCharacter{
	Cartridge = _JRwJ, 
	Container = _V1Hc
}
_7MF.Id = "09ac5e17-446a-456d-8738-a4f09c505e64"
_7MF.Name = _IPh2("\112\077\056\048\034\127\127\085")
_7MF.Description = ""
_7MF.Visible = true
_7MF.Media = _r4bN
_7MF.Commands = {}
_7MF.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_7MF.Gender = "Male"
_7MF.Type = "NPC"
_vk6 = Wherigo.ZCharacter(_JRwJ)
_vk6.Id = "374e2657-c5ca-4648-92d4-912f970c6d67"
_vk6.Name = _IPh2("\038\048\034\098\077\077\085\034")
_vk6.Description = ""
_vk6.Visible = true
_vk6.Media = _zEcc
_vk6.Commands = {}
_vk6.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_vk6.Gender = "Male"
_vk6.Type = "NPC"
_35I = Wherigo.ZCharacter{
	Cartridge = _JRwJ, 
	Container = _vcPpg
}
_35I.Id = "fa574c08-46dc-42e6-aa48-a2368aff360f"
_35I.Name = _IPh2("\089\127\028\048\085\034\021\017\064")
_35I.Description = ""
_35I.Visible = true
_35I.Media = _3zxK
_35I.Commands = {}
_35I.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_35I.Gender = "Female"
_35I.Type = "NPC"
_Yyf = Wherigo.ZCharacter(_JRwJ)
_Yyf.Id = "fd1abe75-a1f3-4537-8208-1d2f2ef61672"
_Yyf.Name = _IPh2("\089\048\048\085\096\077\075\064")
_Yyf.Description = ""
_Yyf.Visible = false
_Yyf.Media = _PmV
_Yyf.Commands = {}
_Yyf.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Yyf.Gender = "Male"
_Yyf.Type = "NPC"

-- Items --
_X2E = Wherigo.ZItem(_JRwJ)
_X2E.Id = "770655da-5d5d-408a-af99-0338456b18c7"
_X2E.Name = _IPh2("\038\048\034\007\048\021")
_X2E.Description = ""
_X2E.Visible = true
_X2E.Media = _lTED
_X2E.Icon = _ILaS
_X2E.Commands = {}
_X2E.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_X2E.Locked = false
_X2E.Opened = false
_G2xGV = Wherigo.ZItem(_JRwJ)
_G2xGV.Id = "791a27a2-8c09-4f3e-9d5f-4024e6778d1e"
_G2xGV.Name = _IPh2("\102\075\048\036\028\048\075")
_G2xGV.Description = ""
_G2xGV.Visible = true
_G2xGV.Media = _JvpY
_G2xGV.Icon = _1Ewq
_G2xGV.Commands = {}
_G2xGV.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_G2xGV.Locked = false
_G2xGV.Opened = false
_A1A6u = Wherigo.ZItem(_JRwJ)
_A1A6u.Id = "3911bd48-e03c-408a-ac30-02672caf0e7e"
_A1A6u.Name = _IPh2("\122\034\021\119\119\048\085\033")
_A1A6u.Description = _IPh2("\089\127\028\007\017\077\048\028\007\021\119\007\098\021\048\085\007\034\127\036\096\007\017\048\048\062")
_A1A6u.Visible = true
_A1A6u.Media = _P8O
_A1A6u.Icon = _Mv1Y3
_A1A6u.Commands = {}
_A1A6u.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_A1A6u.Locked = false
_A1A6u.Opened = false
_yBxF = Wherigo.ZItem(_JRwJ)
_yBxF.Id = "0111eb30-5f72-45e0-bab1-381f36b43661"
_yBxF.Name = _IPh2("\014\127\056\048\034\013\048\075")
_yBxF.Description = ""
_yBxF.Visible = true
_yBxF.Media = _6_z6
_yBxF.Icon = _JqE
_yBxF.Commands = {}
_yBxF.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_yBxF.Locked = false
_yBxF.Opened = false
_RJl7n = Wherigo.ZItem(_JRwJ)
_RJl7n.Id = "3b924e4b-fb9b-4857-a51c-3523eefcbb7a"
_RJl7n.Name = _IPh2("\112\077\056\048\085\013\085\127\034\119")
_RJl7n.Description = ""
_RJl7n.Visible = true
_RJl7n.Media = _njheF
_RJl7n.Icon = _q48
_RJl7n.Commands = {}
_RJl7n.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_RJl7n.Locked = false
_RJl7n.Opened = false
_5B91S = Wherigo.ZItem(_JRwJ)
_5B91S.Id = "7ad2ea34-57c7-4742-90ef-1701477a2fdf"
_5B91S.Name = _IPh2("\102\105\098\048\013\048\075")
_5B91S.Description = ""
_5B91S.Visible = true
_5B91S.Media = _K3Rd
_5B91S.Icon = _jJzD
_5B91S.Commands = {}
_5B91S.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_5B91S.Locked = false
_5B91S.Opened = false
_DELM3 = Wherigo.ZItem(_JRwJ)
_DELM3.Id = "617c30be-809a-4a2e-b080-e6a11a0e5c14"
_DELM3.Name = _IPh2("\022\085\127\119\048\034\013\077\013\048\085")
_DELM3.Description = ""
_DELM3.Visible = true
_DELM3.Media = _sR91
_DELM3.Icon = _J3n7
_DELM3.Commands = {}
_DELM3.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_DELM3.Locked = false
_DELM3.Opened = false
_fp0s = Wherigo.ZItem(_JRwJ)
_fp0s.Id = "9d84bc6f-8a70-4911-8218-6a24b058b861"
_fp0s.Name = _IPh2("\122\077\077\119\054\077\028")
_fp0s.Description = ""
_fp0s.Visible = true
_fp0s.Media = _vJKc
_fp0s.Icon = _RoJ2e
_fp0s.Commands = {}
_fp0s.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_fp0s.Locked = false
_fp0s.Opened = false
_Ve59 = Wherigo.ZItem{
	Cartridge = _JRwJ, 
	Container = __gNg_
}
_Ve59.Id = "c68e846a-a16a-4da8-810f-59f8be9520fb"
_Ve59.Name = _IPh2("\102\105\098\127\028")
_Ve59.Description = ""
_Ve59.Visible = true
_Ve59.Media = _m93H_
_Ve59.Commands = {}
_Ve59.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Ve59.Locked = false
_Ve59.Opened = false

-- Tasks --
_8Wwb = Wherigo.ZTask(_JRwJ)
_8Wwb.Id = "bad1dd40-f1d5-44a1-a12a-714d360dd5fc"
_8Wwb.Name = _IPh2("\092\077\085\002\007\013\127\028\007\001\048\007\048\048\034\007\013\085\127\119\048\034\013\077\013\048\085\007\098\048\023\028\083")
_8Wwb.Description = _IPh2("\022\048\007\013\085\127\119\048\034\013\077\013\048\085\007\021\033\007\048\048\034\007\033\054\048\105\021\127\127\075\007\066\096\127\127\085\013\007\056\127\034\007\033\054\048\105\021\127\075\048\007\075\048\002\048\085\021\034\002\083\007\011\075\075\048\034\007\017\048\028\007\013\048\007\013\085\127\119\048\034\013\077\013\048\085\007\017\127\127\119\007\001\048\007\048\048\034\007\119\127\034\033\007\028\048\002\048\034\007\013\048\007\013\085\127\127\119\083")
_8Wwb.Visible = false
_8Wwb.Media = _sR91
_8Wwb.Active = true
_8Wwb.Complete = false
_8Wwb.CorrectState = "None"
_nfst = Wherigo.ZTask(_JRwJ)
_nfst.Id = "8f8454c1-7723-4e2d-8057-77da4d016dae"
_nfst.Name = _IPh2("\063\127\127\075\007\028\077\056\048\085\013\085\127\034\119")
_nfst.Description = _IPh2("\053\048\007\023\048\034\028\007\034\021\048\028\007\033\028\048\085\119\007\002\048\034\077\048\002\007\077\017\007\066\096\127\127\085\013\007\036\021\028\007\013\048\007\033\028\048\048\034\007\028\048\007\028\085\048\119\119\048\034\083\007\063\127\127\075\007\048\048\085\033\028\007\028\077\056\048\085\013\085\127\034\119\007\023\021\001\007\013\048\007\028\077\056\048\085\034\127\127\085\083\007")
_nfst.Visible = false
_nfst.Media = _njheF
_nfst.Active = false
_nfst.Complete = false
_nfst.CorrectState = "None"
_t0EeY = Wherigo.ZTask(_JRwJ)
_t0EeY.Id = "79348adb-ff1f-43b4-8f46-aa4e79987949"
_t0EeY.Name = _IPh2("\092\077\048\119\007\013\048\007\048\048\034\098\077\077\085\034")
_t0EeY.Description = _IPh2("\053\048\007\023\048\034\028\007\002\048\096\077\034\013\007\077\064\007\099\034\023\033\054\019\001\048\007\017\127\034\119\048\048\085\028\007\096\127\028\007\127\034\013\048\085\033\052\007\013\048\007\048\048\034\098\077\077\085\034\007\021\034\007\098\048\028\007\033\054\085\077\077\119\001\048\033\023\077\033\007\021\033\007\013\048\007\048\034\021\002\048\007\013\021\048\007\001\048\007\119\127\034\007\098\048\075\054\048\034\083")
_t0EeY.Visible = false
_t0EeY.Media = _zEcc
_t0EeY.Active = false
_t0EeY.Complete = false
_t0EeY.CorrectState = "None"
_S89 = Wherigo.ZTask(_JRwJ)
_S89.Id = "c2c09d04-7b11-43e7-87b7-e8edf1168a99"
_S89.Name = _IPh2("\092\077\048\119\007\013\048\007\013\085\127\119\048\034\033\105\098\127\028")
_S89.Description = ""
_S89.Visible = true
_S89.Media = _EqW9I
_S89.Active = true
_S89.Complete = false
_S89.CorrectState = "None"
_TaG5 = Wherigo.ZTask(_JRwJ)
_TaG5.Id = "92e73562-29a2-4a13-ba43-ba8c86195dbd"
_TaG5.Name = _IPh2("\069\048\085\119\085\021\001\002\007\013\048\007\033\075\048\036\028\048\075")
_TaG5.Description = _IPh2("\022\048\007\033\105\098\127\028\007\021\033\007\034\127\028\036\036\085\075\021\001\119\007\077\054\007\033\075\077\028\083\007\022\048\007\033\075\048\036\028\048\075\007\098\048\048\064\028\007\013\048\007\013\085\127\127\119\083\007\009\085\077\023\048\048\085\007\013\048\066\048\007\017\127\127\085\007\048\048\034\033\007\028\048\007\119\085\021\001\002\048\034\083")
_TaG5.Visible = false
_TaG5.Media = _JvpY
_TaG5.Active = true
_TaG5.Complete = false
_TaG5.CorrectState = "None"

-- Cartridge Variables --
_p7y = true
_A3u = ""
_uFlDR = false
_pys = false
_fog = false
_6FBch = false
_H28qD = false
_vsSn4 = false
__fjJM = false
_bNSc = false
_SAPk = false
_JRwJ.ZVariables = {
	_p7y = true, 
	_A3u = "", 
	_uFlDR = false, 
	_pys = false, 
	_fog = false, 
	_6FBch = false, 
	_H28qD = false, 
	_vsSn4 = false, 
	__fjJM = false, 
	_bNSc = false, 
	_SAPk = false
}

-- Timers --
_a5Py = Wherigo.ZTimer(_JRwJ)
_a5Py.Id = "08377f6f-b0a0-45f3-b8f3-5ca3f7f2b9e9"
_a5Py.Name = _IPh2("\022\085\127\127\119\007\056\075\021\048\002\028\007\077\056\048\085")
_a5Py.Description = ""
_a5Py.Visible = true
_a5Py.Duration = 60
_a5Py.Type = "Countdown"
_yxEJ7 = Wherigo.ZTimer(_JRwJ)
_yxEJ7.Id = "7e23d4a1-2144-4678-a54a-03faef251828"
_yxEJ7.Name = _IPh2("\102\075\127\054\048\034")
_yxEJ7.Description = ""
_yxEJ7.Visible = true
_yxEJ7.Duration = 300
_yxEJ7.Type = "Countdown"
_808 = Wherigo.ZTimer(_JRwJ)
_808.Id = "1b6f5a0f-7d91-43cb-b9a0-b707920be005"
_808.Name = _IPh2("\089\048\048\085\096\077\075\064\007\056\048\085\033\105\098\021\001\034\028")
_808.Description = ""
_808.Visible = true
_808.Duration = 30
_808.Type = "Countdown"
_fzkob = Wherigo.ZTimer(_JRwJ)
_fzkob.Id = "fc6e5cfd-c516-4d98-90d9-c433add6360e"
_fzkob.Name = _IPh2("\112\085\048\119\119\048\034")
_fzkob.Description = ""
_fzkob.Visible = true
_fzkob.Duration = 60
_fzkob.Type = "Countdown"
_v53b = Wherigo.ZTimer(_JRwJ)
_v53b.Id = "49220988-7600-44c8-8f37-913485395f37"
_v53b.Name = _IPh2("\102\028\048\085\119")
_v53b.Description = ""
_v53b.Visible = true
_v53b.Duration = 60
_v53b.Type = "Countdown"
_oFzo = Wherigo.ZTimer(_JRwJ)
_oFzo.Id = "ae19696c-87b1-4e37-886d-e513dbe313e4"
_oFzo.Name = _IPh2("\060\034\007\075\127\056\048\034\013\048\075\056\048\075\013")
_oFzo.Description = ""
_oFzo.Visible = true
_oFzo.Duration = 30
_oFzo.Type = "Countdown"
_YK2sZ = Wherigo.ZTimer(_JRwJ)
_YK2sZ.Id = "eba82361-b214-4cfb-831e-430aae09c98d"
_YK2sZ.Name = _IPh2("\082\021\001\007\013\048\007\013\085\127\127\119")
_YK2sZ.Description = ""
_YK2sZ.Visible = true
_YK2sZ.Duration = 30
_YK2sZ.Type = "Countdown"
_FlMS = Wherigo.ZTimer(_JRwJ)
_FlMS.Id = "3bdc769c-f840-4bcb-bca5-7bdcc1a5cfde"
_FlMS.Name = _IPh2("\112\085\048\119\007\066\096\127\127\085\013")
_FlMS.Description = ""
_FlMS.Visible = true
_FlMS.Duration = 15
_FlMS.Type = "Countdown"

-- Inputs --
_aQJfO = Wherigo.ZInput(_JRwJ)
_aQJfO.Id = "917ea169-78b7-48d3-9de5-621742a922ad"
_aQJfO.Name = _IPh2("\065\127\127\017")
_aQJfO.Description = ""
_aQJfO.Visible = true
_aQJfO.InputType = "Text"
_aQJfO.Text = _IPh2("\089\127\028\007\021\033\007\001\048\007\034\127\127\017\062")
_wwspA = Wherigo.ZInput(_JRwJ)
_wwspA.Id = "e1f0cb54-1663-46b6-87c3-d4b8123c4d35"
_wwspA.Name = _IPh2("\089\127\028\048\085\034\021\017\064")
_wwspA.Description = ""
_wwspA.Visible = true
_wwspA.Media = _3zxK
_wwspA.Choices = {
	"Draak", 
	"Schat", 
	"Waar moet ik voor uitkijken?", 
	"Wie kunnen mij helpen?", 
	"Ik heb geen vragen."
}
_wwspA.InputType = "MultipleChoice"
_wwspA.Text = _IPh2("\089\127\127\085\007\096\021\075\007\001\048\007\017\048\048\085\007\077\056\048\085\007\096\048\028\048\034\062")
_4Qa = Wherigo.ZInput(_JRwJ)
_4Qa.Id = "bdf18a92-336c-457e-8143-77adc15b2865"
_4Qa.Name = _IPh2("\082\077\033\048\075\064")
_4Qa.Description = ""
_4Qa.Visible = true
_4Qa.Media = _u7FNe
_4Qa.Choices = {
	"Drakendoder", 
	"Toverdrankje", 
	"Lavendel", 
	"Schedel", 
	"Knikkers", 
	"Waternimf", 
	"Ik heb geen vragen"
}
_4Qa.InputType = "MultipleChoice"
_4Qa.Text = _IPh2("\089\127\127\085\007\096\021\075\007\001\048\007\017\048\048\085\007\077\056\048\085\007\096\048\028\048\034\062")

-- WorksWithList for object commands --

-- functions --
function _JRwJ:OnStart()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_aQJfO)
	end)
	_A1A6u:MoveTo(Player)
	_yBxF:MoveTo(_9Fsgz)
	_G2xGV:MoveTo(nil)
	_5B91S:MoveTo(_1bkW)
	_DELM3:MoveTo(_RmH)
	_vk6:MoveTo(_RmH)
	_1bkW.Active = true
	_1bkW.Visible = true
	_vcPpg.Active = true
	_vcPpg.Visible = true
	_9Fsgz.Active = true
	_nfst.Active = true
	_S89.Visible = true
end
function _JRwJ:OnRestore()
end
function _vcPpg:OnEnter()
	Wherigo.PlayAudio(_8qaUE)
	_SAPk = true
end
function _vcPpg:OnExit()
	_vcPpg.Active = false
	_5w1HT.Active = true
	_JRwJ:RequestSync()
end
function _vcPpg:OnProximity()
	if _SAPk == false then
		_Urwigo.MessageBox{
			Text = (_IPh2("\022\127\002\052\007").._A3u).._IPh2("\052\007\021\119\007\096\077\077\034\007\098\021\048\085\007\021\034\007\013\048\007\023\036\036\085\028\083\007\060\119\007\023\048\034\007\048\048\034\007\096\127\028\048\085\034\021\017\064\007\048\034\007\119\127\034\007\001\048\007\099\034\023\033\054\019\017\021\033\033\105\098\021\048\034\007\098\048\075\054\048\034\007\077\017\007\013\048\007\033\105\098\127\028\007\056\127\034\007\013\048\007\013\085\127\127\119\007\028\048\007\056\021\034\013\048\034\083\007\122\036\034\007\001\048\007\017\021\001\007\056\021\034\013\048\034\062"), 
			Media = _3zxK
		}
	end
end
function _RmH:OnEnter()
	Wherigo.PlayAudio(_jKa)
	_a5Py:Stop()
	_RmH.Visible = true
end
function _RmH:OnExit()
	_vk6:MoveTo(_9Fsgz)
	_RmH.Visible = false
	_JRwJ:RequestSync()
end
function _V1Hc:OnEnter()
	_V1Hc.Visible = true
end
function _V1Hc:OnExit()
	_vk6:MoveTo(_RmH)
	_V1Hc.Visible = false
	_JRwJ:RequestSync()
end
function _jF2F:OnEnter()
	_jF2F.Visible = true
	Wherigo.PlayAudio(_zpdP4)
	_808:Start()
	_fog = true
end
function _jF2F:OnExit()
	_808:Stop()
	_jF2F.Visible = false
	Wherigo.Command "StopSound"
	if _pys == true then
		_t0EeY.Active = true
		_t0EeY.Visible = true
		_pys = false
		_1bkW.Active = false
		_jF2F.Active = false
		_Urwigo.MessageBox{
			Text = _IPh2("\053\048\007\023\048\034\028\007\002\048\023\048\028\048\034\007\013\077\077\085\007\013\048\007\096\048\048\085\096\077\075\064\083\007\124\127\007\077\054\007\066\077\048\119\007\034\127\127\085\007\013\048\007\048\048\034\098\077\077\085\034\083"), 
			Media = _zEcc
		}
	end
	_JRwJ:RequestSync()
end
function _jF2F:OnProximity()
	if _fog == false then
		Wherigo.PlayAudio(_liXm7)
		_Urwigo.MessageBox{
			Text = _IPh2("\053\048\007\034\127\013\048\085\028\007\098\048\028\007\119\048\085\119\098\077\064\083\007\038\048\034\007\002\048\056\127\127\085\075\021\001\119\048\007\054\075\127\127\028\033\007\056\077\077\085\127\075\007\127\075\033\007\001\048\007\077\034\002\048\096\127\054\048\034\013\007\023\048\034\028\083"), 
			Media = _4e5L
		}
	end
end
function _1bkW:OnEnter()
	_uFlDR = true
	_Urwigo.MessageBox{
		Text = "", 
		Media = _bwp, 
		Callback = function(action)
			if action ~= nil then
				local _rndChoiceValue = math.random()
				if _rndChoiceValue < 0.333333333333333 then
					Wherigo.PlayAudio(_8jF)
					_YK2sZ:Start()
				elseif _rndChoiceValue < 0.666666666666667 then
					Wherigo.PlayAudio(_8jF)
					_YK2sZ:Start()
				else
					Wherigo.PlayAudio(_PCsOM)
					_Urwigo.MessageBox{
						Text = _IPh2("\022\048\007\013\085\127\127\119\007\021\033\007\096\048\002\083\007\122\077\017\007\075\127\028\048\085\007\034\077\002\007\048\048\034\033\007\028\048\085\036\002\083"), 
						Media = _bwp
					}
				end
			end
		end
	}
end
function _1bkW:OnExit()
	_YK2sZ:Stop()
	_FlMS:Stop()
	_JRwJ:RequestSync()
	_bNSc = false
	_vsSn4 = false
	if Player:Contains(_G2xGV) then
		_RmH.Active = false
		_V1Hc.Active = false
		_jF2F.Active = false
		_1bkW.Active = false
		_9Fsgz.Active = false
		__gNg_.Active = true
		__gNg_.Visible = true
	end
end
function _1bkW:OnProximity()
	if Player:Contains(_G2xGV) or (_uFlDR == true) then
	else
		if Player:Contains(_DELM3) or Player:Contains(_X2E) then
			_Urwigo.MessageBox{
				Text = Player.Name.._IPh2("\052\007\056\048\048\075\007\033\036\105\105\048\033\083\007\060\119\007\098\077\077\054\007\013\127\028\007\098\048\028\007\001\048\007\075\036\119\028"), 
				Media = _4e5L
			}
		else
			_Urwigo.MessageBox{
				Text = _A3u.._IPh2("\052\007\001\048\007\096\048\048\028\007\034\021\048\028\007\096\127\028\007\001\048\007\013\077\048\028\083\007\053\048\007\075\077\077\054\028\007\002\048\056\127\127\085\007\127\075\033\007\001\048\007\056\048\085\013\048\085\007\002\127\127\028\083\007\124\127\007\028\048\085\036\002\007\034\036\007\098\048\028\007\034\077\002\007\119\127\034\083"), 
				Media = _4e5L
			}
		end
	end
end
function _9Fsgz:OnEnter()
	_9Fsgz.Visible = true
	Wherigo.PlayAudio(_VBpm7)
	_oFzo:Start()
end
function _9Fsgz:OnExit()
	_oFzo:Stop()
	_yxEJ7:Stop()
	_vk6:MoveTo(_V1Hc)
	_9Fsgz.Visible = false
	_JRwJ:RequestSync()
end
function _5w1HT:OnEnter()
	_Urwigo.MessageBox{
		Text = _IPh2("\053\048\007\056\048\085\075\127\127\028\007\098\048\028\007\033\054\085\077\077\119\001\048\033\023\077\033\052\007\127\075\033\007\013\127\028\007\034\021\048\028\007\013\048\007\023\048\013\077\048\075\021\034\002\007\021\033\007\013\127\034\007\017\077\048\028\007\001\048\007\077\017\013\085\127\127\021\048\034\083"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _IPh2("\112\077\028\007\066\021\048\034\033")
				}
			end
		end
	}
end
function __gNg_:OnEnter()
	_Urwigo.MessageBox{
		Text = _A3u.._IPh2("\052\007\098\048\048\075\007\002\077\048\013\007\002\048\013\127\127\034\083\007\099\034\023\033\054\019\022\048\007\033\105\098\127\028\007\021\033\007\056\077\077\085\007\001\077\036\096\083"), 
		Media = _4e5L
	}
end
function __gNg_:OnExit()
	_JRwJ:RequestSync()
end
function _aQJfO:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_A3u = input
	_Urwigo.MessageBox{
		Text = _IPh2("\082\048\034\007\001\048\007\048\048\034\007\001\077\034\002\048\034\007\077\064\007\048\048\034\007\017\048\021\033\001\048\062"), 
		Media = _svEJf, 
		Buttons = {
			_IPh2("\053\077\034\002\048\034"), 
			_IPh2("\101\048\021\033\001\048")
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					_Urwigo.MessageBox{
						Text = _A3u.._IPh2("\052\007\022\021\028\007\023\048\034\007\001\021\001\083"), 
						Media = _J23
					}
				elseif action == "Button2" then
					_Urwigo.MessageBox{
						Text = _A3u.._IPh2("\052\007\022\021\028\007\023\048\034\007\001\021\001\083"), 
						Media = _1KcOS
					}
					_p7y = false
				end
			end
		end
	}
end
function _wwspA:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 60673 then
		_Urwigo.MessageBox{
			Text = _IPh2("\022\048\007\013\085\127\127\119\007\096\077\077\034\028\007\021\034\007\098\048\028\007\017\077\048\085\127\033\083\007\092\021\001\007\021\033\007\023\021\001\034\127\007\127\075\028\021\001\013\007\096\127\119\119\048\085\007\048\034\007\033\077\017\033\007\056\075\021\048\002\028\007\066\021\001\007\085\077\034\013\007\023\077\056\048\034\007\098\048\028\007\033\054\085\077\077\119\001\048\033\023\077\033\083\007\011\075\033\007\001\048\007\098\127\127\085\007\085\077\034\013\007\066\021\048\028\007\056\075\021\048\002\048\034\007\017\077\048\028\007\001\048\007\033\034\048\075\007\033\105\098\036\021\075\048\034\007\021\034\007\098\048\028\007\023\077\033\007\096\127\034\028\007\127\034\013\048\085\033\007\023\048\034\007\001\048\007\066\021\105\098\028\023\127\127\085\007\048\034\007\017\077\048\028\007\001\048\007\098\048\028\007\048\085\002\033\028\048\007\056\085\048\066\048\034\083\073\082\100\090\011\075\033\007\001\048\007\048\048\034\007\023\048\066\077\048\119\007\127\127\034\007\098\127\127\085\007\096\021\075\007\077\056\048\085\075\048\056\048\034\007\119\127\034\007\013\127\028\007\127\075\075\048\048\034\007\017\048\028\007\048\048\034\007\075\021\033\028\007\077\064\007\066\096\127\127\085\023\048\096\127\054\048\034\013\083"), 
			Media = _RoAD3
		}
	elseif _Urwigo.Hash(string.lower(input)) == 30894 then
		_Urwigo.MessageBox{
			Text = _IPh2("\022\048\007\013\085\127\127\119\007\023\048\096\127\127\119\028\007\034\021\048\028\007\013\048\007\033\105\098\127\028\083\007\017\127\127\085\007\098\048\048\064\028\007\013\048\007\033\075\048\036\028\048\075\007\056\127\034\007\013\048\007\033\105\098\127\028\119\021\033\028\083\007\053\048\007\119\036\034\028\007\013\048\066\048\007\127\075\075\048\048\034\007\028\048\007\054\127\119\119\048\034\007\119\085\021\001\002\048\034\007\127\075\033\007\001\048\007\098\048\048\075\007\033\075\021\017\007\023\048\034\028\007\048\034\007\098\048\048\075\007\013\127\054\054\048\085\083\007\022\048\007\033\105\098\127\028\007\021\033\007\048\085\002\048\034\033\007\127\034\013\048\085\033\052\007\021\119\007\096\048\048\028\007\034\021\048\028\007\096\127\127\085\083"), 
			Media = _EqW9I
		}
	elseif _Urwigo.Hash(string.lower(input)) == 60381 then
		_Urwigo.MessageBox{
			Text = _IPh2("\022\048\007\096\048\048\085\096\077\075\064\007\021\033\007\066\048\048\085\007\002\048\056\127\127\085\075\021\001\119\007\048\034\007\033\077\017\033\007\119\077\017\028\007\098\021\001\007\077\054\007\098\048\028\007\119\048\085\119\098\077\064\083\007\063\021\001\007\119\127\034\007\001\048\007\033\077\017\033\007\066\077\034\013\048\085\007\085\048\013\048\034\007\127\127\034\056\127\075\075\048\034\083\007"), 
			Media = _PmV, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _A3u.._IPh2("\052\007\002\127\007\034\021\048\028\007\034\127\127\085\007\013\048\007\013\085\127\127\119\052\007\066\077\007\056\048\075\048\034\007\066\021\001\034\007\001\048\007\056\077\077\085\007\002\048\002\127\127\034\007\048\034\007\034\021\048\028\007\028\048\085\036\002\007\002\048\119\048\048\085\013\083"), 
						Media = _RoAD3
					}
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 38650 then
		_Urwigo.MessageBox{
			Text = _IPh2("\101\021\001\034\007\056\085\021\048\034\013\021\034\007\013\048\007\023\077\033\048\075\064\083\007\092\021\001\007\096\048\048\028\007\056\048\048\075\007\077\056\048\085\007\013\048\007\013\021\034\002\048\034\007\013\021\048\007\001\048\007\098\021\048\085\007\021\034\007\098\048\028\007\033\054\085\077\077\119\001\048\033\023\077\033\007\119\127\034\007\056\021\034\013\048\034\083\007\092\021\001\007\096\077\077\034\028\007\034\127\028\036\036\085\075\021\001\119\007\021\034\007\098\048\028\007\023\077\033\083\007\092\021\001\007\096\048\048\028\007\077\077\119\007\098\077\048\007\001\048\007\017\021\001\007\119\036\034\028\007\028\048\085\036\002\007\056\021\034\013\048\034\083"), 
			Media = _u7FNe, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IPh2("\022\048\007\048\048\034\098\077\077\085\034\007\021\033\007\048\048\034\007\017\127\002\021\033\105\098\007\013\021\048\085\083\007\101\077\105\098\028\007\001\048\007\077\017\007\096\127\028\007\056\077\077\085\007\085\048\013\048\034\007\002\048\096\077\034\013\007\066\021\001\034\007\013\127\034\007\017\077\048\028\007\001\048\007\013\021\028\007\013\021\048\085\007\066\077\048\119\048\034\083\007\063\021\001\007\119\127\034\007\001\048\007\002\048\034\048\066\048\034\007\056\127\034\007\127\075\007\001\048\007\096\077\034\013\048\034\083\007\063\021\001\007\066\096\048\085\064\028\007\085\077\034\013\083"), 
						Media = _zEcc, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _IPh2("\022\048\007\028\077\056\048\034\127\127\085\052\007\005\098\048\017\085\036\066\007\013\021\048\007\048\048\034\007\023\048\048\028\001\048\007\056\048\085\033\028\077\077\021\013\007\021\033\083\007\011\075\033\007\001\048\007\098\048\017\007\098\048\075\054\028\007\013\127\034\007\021\033\007\098\021\001\007\023\048\085\048\021\013\007\077\017\007\001\077\036\096\007\077\077\119\007\028\048\007\098\048\075\054\048\034\083\007\063\021\001\007\021\033\007\021\034\007\013\048\007\081\022\077\077\085\002\127\034\002\081\083"), 
									Media = _r4bN, 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _IPh2("\060\119\007\119\048\034\007\098\127\127\085\007\034\021\048\028\052\007\017\127\127\085\007\066\048\007\013\077\048\028\007\002\048\048\034\007\119\096\127\127\013\083"), 
												Media = _4e5L
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
		_V1Hc.Visible = true
		_RmH.Visible = true
	end
end
function _4Qa:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 36914 then
		_Urwigo.MessageBox{
			Text = _IPh2("\022\048\007\013\085\127\119\048\034\013\077\013\048\085\007\021\033\007\002\048\017\127\127\119\028\007\013\077\077\085\007\013\096\048\085\002\048\034\007\048\048\036\096\048\034\007\002\048\075\048\013\048\034\083\007\063\048\028\007\021\033\007\002\048\017\127\127\119\028\007\056\127\034\007\048\048\034\007\033\054\048\105\021\127\075\048\007\075\048\002\048\085\021\034\002\007\048\034\007\013\127\127\085\013\077\077\085\007\119\127\034\007\098\048\028\007\013\077\077\085\013\085\021\034\002\048\034\007\021\034\007\098\048\028\007\054\127\034\033\048\085\007\056\127\034\007\013\048\007\013\085\127\127\119\083\007\011\075\075\048\048\034\007\096\021\048\007\033\028\048\085\119\007\002\048\034\077\048\002\007\021\033\007\119\127\034\007\098\048\028\007\066\096\127\127\085\013\007\036\021\028\007\013\048\007\033\028\048\048\034\007\028\085\048\119\119\048\034\083"), 
			Media = __MBWj
		}
	elseif _Urwigo.Hash(string.lower(input)) == 32646 then
		_Urwigo.MessageBox{
			Text = _IPh2("\022\048\007\033\105\098\048\013\048\075\007\021\033\007\056\127\034\007\048\048\034\007\054\048\085\033\077\077\034\007\096\127\127\085\056\127\034\007\013\048\007\066\021\048\075\007\034\077\002\007\085\077\034\013\013\077\077\075\028\007\021\034\007\098\048\028\007\033\054\085\077\077\119\001\048\033\023\077\033\083\007\011\075\033\007\001\048\007\098\048\028\007\023\048\002\085\127\127\064\028\007\077\054\007\098\048\028\007\119\048\085\119\098\077\064\007\013\127\034\007\066\127\075\007\001\048\007\013\048\007\066\021\048\075\007\085\036\033\028\007\056\021\034\013\048\034\083\007\065\127\028\036\036\085\075\021\001\119\007\119\085\021\001\002\007\001\048\007\098\021\048\085\056\077\077\085\007\048\048\034\007\023\048\075\077\034\021\034\002\083"), 
			Media = _K3Rd
		}
	elseif _Urwigo.Hash(string.lower(input)) == 19489 then
		_Urwigo.MessageBox{
			Text = _IPh2("\014\127\056\048\034\013\048\075\007\021\033\007\048\048\034\007\002\048\036\085\021\002\048\007\054\075\127\034\028\083\007\053\048\007\096\077\085\013\028\007\048\085\007\033\075\127\054\048\085\021\002\007\056\127\034\007\048\034\007\013\048\007\013\085\127\127\119\007\077\077\119\083"), 
			Media = _6_z6
		}
	elseif _Urwigo.Hash(string.lower(input)) == 32619 then
		_Urwigo.MessageBox{
			Text = _IPh2("\022\048\007\028\077\056\048\034\127\127\085\052\007\005\098\048\017\085\036\066\007\119\127\034\007\013\021\028\007\013\085\127\034\119\001\048\007\017\127\119\048\034\007\127\075\033\007\001\048\007\096\021\075\028\083\007\063\048\028\007\096\048\085\119\028\007\034\021\048\028\007\066\077\007\075\127\034\002\052\007\017\127\127\085\007\048\048\034\007\017\021\034\036\036\028\007\077\064\007\066\077\052\007\013\036\033\007\002\048\023\085\036\021\119\007\098\048\028\007\056\048\085\033\028\127\034\013\021\002\083\007\082\021\001\056\077\077\085\023\048\048\075\013\007\077\017\007\013\048\007\013\085\127\119\048\034\013\077\013\048\085\007\036\021\028\007\013\048\007\033\028\048\048\034\007\028\048\007\028\085\048\119\119\048\034\083"), 
			Media = _njheF
		}
		_nfst.Visible = true
	elseif _Urwigo.Hash(string.lower(input)) == 38635 then
		_Urwigo.MessageBox{
			Text = _IPh2("\112\001\127\052\007\021\119\007\096\048\048\028\007\098\048\028\007\034\021\048\028\007\096\127\028\007\001\048\007\098\021\048\085\007\017\048\048\007\017\077\048\028\083\007\122\034\021\119\119\048\085\048\034\007\017\021\033\033\105\098\021\048\034\062"), 
			Media = _P8O
		}
	elseif _Urwigo.Hash(string.lower(input)) == 51249 then
		_vcPpg.Active = true
		_vcPpg.Visible = true
		_SAPk = true
	end
end
function _a5Py:OnStart()
	Wherigo.PlayAudio(_tvV)
end
function _a5Py:OnStop()
	_Urwigo.MessageBox{
		Text = _IPh2("\124\048\075\036\119\119\021\002\007\034\048\028\007\077\054\007\028\021\001\013\007\021\034\007\098\048\028\007\023\077\033\083\007"), 
		Media = _eqN
	}
end
function _a5Py:OnTick()
	_Urwigo.MessageBox{
		Text = _IPh2("\022\048\007\013\085\127\127\119\007\098\048\048\064\028\007\001\048\007\028\048\007\054\127\119\119\048\034\007\002\048\119\085\048\002\048\034\007\048\034\007\034\036\007\023\048\034\007\001\048\007\002\048\096\077\034\013\083\007\092\077\048\119\007\013\048\007\048\048\034\098\077\077\085\034\007\077\017\007\056\048\085\013\048\085\007\028\048\007\119\036\034\034\048\034\083"), 
		Media = _RoAD3
	}
	_jF2F.Active = false
	_1bkW.Active = false
	_t0EeY.Active = false
	_t0EeY.Visible = false
end
function _yxEJ7:OnStop()
	_Urwigo.MessageBox{
		Text = _IPh2("\053\048\007\023\048\034\028\007\034\021\048\028\007\036\021\028\002\048\033\075\127\054\048\034\083\007\022\048\007\048\048\034\098\077\077\085\034\007\119\127\034\007\001\048\007\096\048\048\085\007\064\021\028\007\017\127\119\048\034\007\066\077\013\127\028\007\001\048\007\096\048\048\085\007\056\048\085\013\048\085\007\119\127\034\083"), 
		Media = _fTF
	}
	_jF2F.Active = false
	_1bkW.Active = false
	_t0EeY.Active = true
	_t0EeY.Visible = true
end
function _yxEJ7:OnTick()
	Wherigo.PlayAudio(_51R)
end
function _808:OnTick()
	local _rndChoiceValue = math.random()
	if _rndChoiceValue < 0.5 then
		_Urwigo.MessageBox{
			Text = _IPh2("\112\085\048\119\007\033\034\048\075\007\013\048\007\013\085\127\119\048\034\013\077\013\048\085\007\077\017\007\001\048\007\028\048\007\056\048\085\013\048\013\021\002\048\034\083"), 
			Media = _PmV
		}
		Wherigo.PlayAudio(_iy2)
		_pys = true
	else
		_Urwigo.MessageBox{
			Text = _IPh2("\124\048\048\034\007\096\048\048\085\096\077\075\064\007\028\048\007\066\021\048\034\083"), 
			Media = _jn_
		}
	end
end
function _fzkob:OnTick()
	_Urwigo.MessageBox{
		Text = _IPh2("\011\075\033\001\048\023\075\021\048\064\028\052\007\048\034\007\077\034\028\098\077\036\013\007\098\048\028\007\021\033\007\017\127\127\085\007\071\093\093\007\028\048\075\075\048\034\007\096\048\085\119\066\127\127\017\083"), 
		Media = _njheF, 
		Callback = function(action)
			if action ~= nil then
				_RJl7n:MoveTo(Player)
			end
		end
	}
	_nfst.Active = false
	_nfst.Visible = false
	_8Wwb.Visible = true
end
function _v53b:OnStart()
	_6FBch = true
	_RJl7n:MoveTo(_7MF)
	_Urwigo.MessageBox{
		Text = "", 
		Media = _fTF
	}
end
function _v53b:OnTick()
	_Urwigo.MessageBox{
		Text = "", 
		Media = _fTF
	}
	_6FBch = false
	_nfst.Active = true
	_A1A6u:MoveTo(_9Fsgz)
end
function _oFzo:OnTick()
	local _rndChoiceValue = math.random()
	if _rndChoiceValue < 0.25 then
		_Urwigo.MessageBox{
			Text = _IPh2("\022\048\007\013\085\127\127\119\007\056\075\021\048\002\028\007\077\056\048\085\007\056\048\085\033\028\077\054\007\001\048\007\023\021\034\034\048\034\007\048\048\034\007\017\021\034\036\036\028\007\021\034\007\098\048\028\007\023\077\033\083"), 
			Media = _tcNw, 
			Callback = function(action)
				if action ~= nil then
					_a5Py:Start()
					_RmH.Visible = true
				end
			end
		}
	elseif _rndChoiceValue < 0.5 then
		_Urwigo.MessageBox{
			Text = _IPh2("\053\048\007\023\048\034\028\007\021\034\007\098\048\028\007\014\127\056\048\034\013\048\075\056\048\075\013\007\048\034\007\013\077\077\085\007\013\048\007\002\048\036\085\007\056\127\034\007\075\127\056\048\034\013\048\075\007\096\077\085\013\007\001\048\007\033\075\127\054\048\085\021\002\083\007\053\048\007\013\077\048\028\007\056\077\077\085\007\017\021\034\021\017\127\127\075\007\046\007\017\021\034\036\028\048\034\007\048\034\007\013\036\028\001\048\083\007\027\069\048\085\075\127\127\028\007\056\077\077\085\007\066\048\119\048\085\007\046\007\017\021\034\036\028\048\034\007\034\021\048\028\007\013\048\066\048\007\066\077\034\048\094\086"), 
			Media = _tUO, 
			Callback = function(action)
				if action ~= nil then
					_yxEJ7:Start()
				end
			end
		}
	elseif _rndChoiceValue < 0.75 then
		_Urwigo.MessageBox{
			Text = _IPh2("\022\048\007\013\085\127\127\119\007\056\075\021\048\002\028\007\077\056\048\085\007\056\048\085\033\028\077\054\007\001\048\007\023\021\034\034\048\034\007\048\048\034\007\017\021\034\036\036\028\007\021\034\007\098\048\028\007\023\077\033\083"), 
			Media = _tcNw, 
			Callback = function(action)
				if action ~= nil then
					_a5Py:Start()
					_RmH.Visible = true
				end
			end
		}
	else
	end
end
function _YK2sZ:OnTick()
	if _H28qD == true then
		_Urwigo.MessageBox{
			Text = _IPh2("\022\085\127\127\119\001\048\052\007\119\021\001\119\007\048\048\034\033\083\007\100\036\021\075\048\034\007\028\048\002\048\034\007\013\048\007\033\075\048\036\028\048\075\062"), 
			Media = _lTED, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IPh2("\101\021\001\034\007\048\021\028\001\048\052\007\013\021\048\007\021\033\007\066\048\119\048\085\085\007\096\048\002\002\048\085\077\075\013\083\007\100\036\021\075\048\034\007\056\077\077\085\007\013\048\066\048\007\077\036\013\048\007\033\075\048\036\028\048\075\052\007\001\127\007\034\127\028\036\036\085\075\021\001\119\083"), 
						Media = _RoAD3, 
						Callback = function(action)
							if action ~= nil then
								_G2xGV:MoveTo(Player)
								_X2E:MoveTo(nil)
								_Urwigo.MessageBox{
									Text = "", 
									Media = _JvpY
								}
								_TaG5.Complete = true
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IPh2("\053\048\007\098\048\023\028\007\071\046\007\028\048\075\075\048\034\007\077\017\007\098\048\028\007\066\096\127\127\085\013\007\028\048\007\028\085\048\119\119\048\034\007\077\064\007\028\048\007\056\075\036\105\098\028\048\034\083"), 
			Media = _RoAD3, 
			Callback = function(action)
				if action ~= nil then
					_FlMS:Start()
				end
			end
		}
	end
end
function _FlMS:OnStart()
	__fjJM = true
end
function _FlMS:OnStop()
	if _p7y == false then
		_Urwigo.MessageBox{
			Text = _IPh2("\053\048\007\075\048\048\064\028\007\034\077\002\083\007\089\127\028\007\048\048\034\007\002\048\075\036\119\083"), 
			Media = _1KcOS
		}
		Wherigo.PlayAudio(_g6tLU)
	else
		_Urwigo.MessageBox{
			Text = _IPh2("\053\048\007\075\048\048\064\028\007\034\077\002\083\007\089\127\028\007\048\048\034\007\002\048\075\036\119\083"), 
			Media = _J23
		}
		Wherigo.PlayAudio(_g6tLU)
	end
	__fjJM = false
end
function _FlMS:OnTick()
	__fjJM = false
	if _vsSn4 == true then
		_Urwigo.MessageBox{
			Text = _IPh2("\022\127\028\007\066\096\127\127\085\013\007\066\127\075\007\001\048\007\034\021\048\028\007\098\048\075\054\048\034\083\007\053\048\007\119\036\034\028\007\028\077\105\098\007\034\021\048\028\007\023\021\001\007\017\048\007\119\077\017\048\034\007\066\077\034\013\048\085\007\028\048\007\056\048\085\023\085\127\034\013\048\034\083"), 
			Media = _RoAD3, 
			Callback = function(action)
				if action ~= nil then
					_bNSc = true
				end
			end
		}
		Wherigo.PlayAudio(_MY4)
	else
		_Urwigo.MessageBox{
			Text = _IPh2("\112\048\007\075\127\127\028\007\001\048\007\023\048\034\028\007\002\048\096\077\034\013\007\099\034\023\033\054\019\048\034\007\001\048\007\066\036\075\028\007\077\054\007\066\077\048\119\007\017\077\048\028\048\034\007\034\127\127\085\007\013\048\007\048\048\034\098\077\077\085\034\007\077\017\007\056\127\034\007\001\048\007\096\077\034\013\048\034\007\028\048\007\098\048\085\033\028\048\075\075\048\034\083"), 
			Media = _zEcc
		}
		_jF2F.Active = false
		_t0EeY.Active = true
		_t0EeY.Visible = true
	end
	_vsSn4 = false
end
function _qCfK:OnClick()
	_Urwigo.MessageBox{
		Text = (_IPh2("\022\127\002\052\007").._A3u).._IPh2("\083\007\060\119\007\023\048\034\007\048\048\034\007\023\077\033\048\075\064\007\048\034\007\021\119\007\096\048\048\028\007\098\048\048\075\007\056\048\048\075\007\056\127\034\007\013\048\007\013\021\034\002\048\034\007\013\021\048\007\001\048\007\021\034\007\013\021\028\007\033\054\085\077\077\119\001\048\033\023\077\033\007\119\036\034\028\007\056\021\034\013\048\034\052\007\056\048\048\075\007\017\127\127\085\007\034\021\048\028\007\127\075\075\048\033\083"), 
		Media = _u7FNe, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_4Qa)
				end)
			end
		end
	}
end
function _7MF:OnClick()
	Wherigo.PlayAudio(_ZnbZw)
	if _nfst.Active == true then
		if Player:Contains(_fp0s) and Player:Contains(_A1A6u) then
			_Urwigo.MessageBox{
				Text = _IPh2("\122\021\001\119\007\021\119\007\098\048\023\007\001\048\007\054\077\028\007\002\048\056\077\034\013\048\034"), 
				Media = _vJKc, 
				Callback = function(action)
					if action ~= nil then
						_Urwigo.MessageBox{
							Text = _IPh2("\092\048\028\007\098\048\017\007\017\127\127\085\007\077\054\007\098\048\028\007\056\036\036\085\083"), 
							Media = _9T7N, 
							Callback = function(action)
								if action ~= nil then
									_Urwigo.MessageBox{
										Text = _IPh2("\060\119\007\098\048\023\007\119\127\028\028\048\034\077\002\048\034\007\034\077\013\021\002\083\007\099\034\023\033\054\019\063\048\023\007\001\048\007\013\021\048\007\023\021\001\007\001\048\083"), 
										Media = _r4bN, 
										Buttons = {
											_IPh2("\053\127"), 
											_IPh2("\065\048\048")
										}, 
										Callback = function(action)
											if action ~= nil then
												if action == "Button1" then
													_Urwigo.MessageBox{
														Text = _IPh2("\022\127\028\007\119\127\034\007\034\021\048\028\052\007\001\048\007\119\036\034\028\007\002\048\048\034\007\119\127\028\028\048\034\077\002\048\034\007\098\048\023\023\048\034\083"), 
														Media = _r4bN, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _IPh2("\022\127\028\007\066\021\001\034\007\119\034\021\119\119\048\085\033\052\007\033\036\119\119\048\075\083\007\101\127\127\085\007\013\127\028\007\017\127\002\007\077\077\119\083\007\102\077\017\017\021\002\048\007\119\034\021\119\119\048\085\033\007\098\048\028\048\034\007\119\127\028\028\048\034\077\002\048\034\083"), 
																	Media = _P8O, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _IPh2("\092\077\007\034\036\007\048\056\048\034\007\028\077\028\007\071\093\093\007\028\048\075\075\048\034\007\048\034\007\013\127\034\007\021\033\007\001\048\007\013\085\127\034\119\001\048\007\119\075\127\127\085\083"), 
																				Media = _WHxJ, 
																				Callback = function(action)
																					if action ~= nil then
																						_fzkob:Start()
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												elseif action == "Button2" then
													_Urwigo.MessageBox{
														Text = _IPh2("\124\048\048\064\028\007\034\021\048\028\007\098\077\077\085\083\007\060\119\007\119\127\034\007\077\077\119\007\002\048\096\077\077\034\007\119\034\021\119\119\048\085\033\007\002\048\023\085\036\021\119\048\034\083"), 
														Media = _r4bN, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = "", 
																	Media = _P8O, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _IPh2("\092\077\007\034\036\007\048\056\048\034\007\028\077\028\007\071\093\093\007\028\048\075\075\048\034\007\048\034\007\013\127\034\007\021\033\007\001\048\007\013\085\127\034\119\001\048\007\119\075\127\127\085\083"), 
																				Media = _WHxJ, 
																				Callback = function(action)
																					if action ~= nil then
																						_fzkob:Start()
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												end
												_A1A6u:MoveTo(_7MF)
												_fp0s:MoveTo(_7MF)
											end
										end
									}
								end
							end
						}
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = (_IPh2("\122\077\017\007\056\048\085\013\048\085\052\007").._A3u).._IPh2("\007\089\127\127\085\077\017\007\119\077\017\007\001\048\007\023\021\001\007\017\021\001\052\007\127\075\033\007\021\119\007\056\085\127\002\048\034\007\017\127\002\062"), 
				Media = _r4bN, 
				Callback = function(action)
					if action ~= nil then
						if _p7y == false then
							_Urwigo.MessageBox{
								Text = _IPh2("\005\098\048\017\085\036\066\052\007\119\036\034\007\001\048\007\048\048\034\007\028\077\056\048\085\013\085\127\034\119\001\048\007\017\127\119\048\034\007\056\077\077\085\007\017\021\001\062"), 
								Media = _1KcOS, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _IPh2("\060\119\007\098\048\023\007\127\075\075\048\048\034\007\002\048\048\034\007\119\077\077\119\054\077\028\083\007\022\021\048\007\017\077\048\028\007\098\021\048\085\007\048\085\002\048\034\033\007\066\021\001\034\083"), 
											Media = _r4bN, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						else
							_Urwigo.MessageBox{
								Text = _IPh2("\005\098\048\017\085\036\066\052\007\119\036\034\007\001\048\007\048\048\034\007\028\077\056\048\085\013\085\127\034\119\001\048\007\017\127\119\048\034\007\056\077\077\085\007\017\021\001\062"), 
								Media = _J23, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _IPh2("\060\119\007\098\048\023\007\127\075\075\048\048\034\007\002\048\048\034\007\119\077\077\119\054\077\028\083\007\022\021\048\007\017\077\048\028\007\098\021\048\085\007\048\085\002\048\034\033\007\066\021\001\034\083"), 
											Media = _r4bN, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
						_fp0s:MoveTo(_V1Hc)
					end
				end
			}
		end
	else
		_Urwigo.MessageBox{
			Text = _IPh2("\102\028\077\077\085\007\017\048\007\034\021\048\028\052\007\066\021\048\007\034\021\048\028\007\013\127\028\007\021\119\007\017\021\001\007\119\077\077\119\054\077\028\007\066\077\048\119\083"), 
			Media = _r4bN
		}
	end
end
function _vk6:OnClick()
	Wherigo.PlayAudio(_99O)
	if _t0EeY.Active then
		_Urwigo.MessageBox{
			Text = _IPh2("\053\048\007\098\048\023\028\007\017\021\001\007\002\048\056\077\034\013\048\034\007\048\034\007\077\054\007\013\127\028\007\021\119\007\048\048\034\007\017\127\002\021\033\105\098\048\007\013\021\048\085\007\023\048\034\052\007\023\048\034\007\001\048\007\034\036\007\056\127\034\007\127\075\075\048\007\077\034\002\048\017\127\119\119\048\034\007\127\064\083"), 
			Media = _zEcc
		}
		_t0EeY.Active = false
		_t0EeY.Visible = false
		_jF2F.Active = true
		_1bkW.Active = true
	else
		_Urwigo.MessageBox{
			Text = _IPh2("\011\075\033\007\001\048\007\096\127\028\007\017\127\034\119\048\048\085\028\007\119\127\034\007\021\119\007\001\048\007\002\048\034\048\066\048\034\083\007\060\119\007\066\096\048\085\064\007\085\077\034\013\007\021\034\007\098\048\028\007\023\077\033\052\007\013\077\077\085\002\127\034\002\007\048\034\007\098\048\028\007\075\127\056\048\034\013\048\075\056\048\075\013\083"), 
			Media = _zEcc
		}
	end
end
function _35I:OnClick()
	_Urwigo.MessageBox{
		Text = _IPh2("\053\048\007\098\048\023\028\007\017\021\001\007\002\048\056\077\034\013\048\034\052\007\013\048\007\056\077\075\002\048\034\013\048\007\119\048\048\085\007\066\127\075\007\013\127\028\007\048\048\034\007\033\028\036\119\007\017\077\048\021\075\021\001\119\048\085\007\002\127\127\034\083\007\089\127\127\085\017\048\048\007\119\127\034\007\021\119\007\001\048\007\034\036\007\098\048\075\054\048\034\062"), 
		Media = _3zxK, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_wwspA)
				end)
			end
		end
	}
end
function _X2E:OnClick()
	if _9Fsgz:Contains(Player) then
		_Urwigo.MessageBox{
			Text = _IPh2("\038\048\034\007\013\085\127\119\048\034\048\021\083\007\101\021\033\033\105\098\021\048\034\007\119\036\034\007\001\048\007\013\021\048\007\085\036\021\075\048\034\007\056\077\077\085\007\013\048\007\033\075\048\036\028\048\075\062"), 
			Media = _nsH
		}
		_H28qD = true
	else
		_Urwigo.MessageBox{
			Text = _IPh2("\038\048\034\007\048\021\083\007\063\077\036\013\007\098\048\028\007\028\048\002\048\034\007\098\048\028\007\066\077\034\075\021\105\098\028\007\021\034\007\098\048\028\007\077\054\048\034\007\075\127\056\048\034\013\048\075\056\048\075\013\052\007\013\127\034\007\119\036\034\007\001\048\007\066\021\048\034\007\096\127\028\007\048\085\007\021\034\007\066\021\028\062"), 
			Media = _lTED
		}
	end
end
function _G2xGV:OnClick()
	_Urwigo.MessageBox{
		Text = _IPh2("\038\021\034\013\048\075\021\001\119\052\007\001\048\007\098\048\023\028\007\013\048\007\033\075\048\036\028\048\075\007\017\127\127\085\007\096\127\127\085\007\021\033\007\034\036\007\013\048\007\033\105\098\127\028\062"), 
		Media = _JvpY, 
		Callback = function(action)
			if action ~= nil then
				_Ve59:MoveTo(__gNg_)
				__gNg_.Active = true
				__gNg_.Visible = true
				_RmH.Active = false
				_V1Hc.Active = false
				_9Fsgz.Active = false
				_jF2F.Active = false
				_1bkW.Active = false
				_TaG5.Complete = true
			end
		end
	}
end
function _A1A6u:OnClick()
	_Urwigo.MessageBox{
		Text = _IPh2("\116\017\007\017\048\048\007\028\048\007\119\034\021\119\119\048\085\048\034\083"), 
		Media = _P8O, 
		Callback = function(action)
			if action ~= nil then
				if _9Fsgz:Contains(_A1A6u) then
					_A1A6u:MoveTo(Player)
				end
			end
		end
	}
end
function _yBxF:OnClick()
	if _bNSc == true then
		_Urwigo.MessageBox{
			Text = _IPh2("\100\036\021\119\007\098\021\048\085\007\017\127\127\085\007\048\048\034\033\007\127\127\034\083\007\089\048\075\028\085\036\033\028\048\034\007\013\085\127\127\119\083"), 
			Media = _6_z6, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.PlayAudio(_hFW)
					_Urwigo.MessageBox{
						Text = _IPh2("\092\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066"), 
						Media = _RoAD3, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _IPh2("\053\048\007\119\036\034\028\007\034\036\007\013\048\007\033\075\048\036\028\048\075\007\054\127\119\119\048\034\083"), 
									Media = _JvpY, 
									Callback = function(action)
										if action ~= nil then
											_G2xGV:MoveTo(Player)
											_yBxF:MoveTo(_9Fsgz)
											_TaG5.Complete = true
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		if Player:Contains(_yBxF) then
			_Urwigo.MessageBox{
				Text = _IPh2("\101\017\017\017\052\007\096\127\028\007\085\036\021\119\028\007\013\127\028\007\075\048\119\119\048\085\083"), 
				Media = _6_z6
			}
		else
			_Urwigo.MessageBox{
				Text = _IPh2("\009\075\036\119\007\001\048\007\096\127\028\007\075\127\056\048\034\013\048\075\062"), 
				Media = _tUO, 
				Buttons = {
					_IPh2("\053\127"), 
					_IPh2("\065\048\048")
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							_yBxF:MoveTo(Player)
							_Urwigo.MessageBox{
								Text = _IPh2("\101\017\017\017\052\007\096\127\028\007\085\036\021\119\028\007\013\127\028\007\075\048\119\119\048\085\083"), 
								Media = _6_z6
							}
						end
					end
				end
			}
		end
	end
end
function _RJl7n:OnClick()
	_Urwigo.MessageBox{
		Text = _IPh2("\089\021\075\007\001\048\007\028\077\056\048\085\013\085\127\034\119\007\002\048\023\085\036\021\119\048\034\062"), 
		Media = _njheF, 
		Buttons = {
			_IPh2("\053\127"), 
			_IPh2("\065\048\048")
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					Wherigo.PlayAudio(_Ata)
					_v53b:Start()
				end
			end
		end
	}
end
function _5B91S:OnClick()
	if Player:Contains(_5B91S) then
		if _jF2F:Contains(Player) then
			_Urwigo.MessageBox{
				Text = _IPh2("\063\021\048\085\007\119\036\034\007\001\048\007\017\021\001\007\023\048\002\085\127\056\048\034\083\007\089\021\075\007\001\048\007\013\127\028\007\013\077\048\034\062"), 
				Media = _K3Rd, 
				Buttons = {
					_IPh2("\053\127\007"), 
					_IPh2("\065\048\048")
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							_5B91S:MoveTo(_jF2F)
							_X2E:MoveTo(Player)
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _IPh2("\101\021\001\034\007\066\021\048\075\007\056\021\034\013\028\007\085\036\033\028\007\127\075\033\007\001\048\007\017\021\001\007\023\048\002\085\127\127\064\028\007\077\054\007\098\048\028\007\119\048\085\119\098\077\064\083\007\060\119\007\066\127\075\007\001\048\007\023\048\075\077\034\048\034\007\017\048\028\007\048\048\034\007\075\048\056\048\034\083"), 
				Media = _K3Rd
			}
		end
	else
		if _1bkW:Contains(_5B91S) then
			_Urwigo.MessageBox{
				Text = _IPh2("\009\127\119\007\001\048\007\098\048\017\007\077\054\007\048\034\007\034\048\048\017\007\001\048\007\013\048\007\033\105\098\048\013\048\075\007\017\048\048\062"), 
				Media = _K3Rd, 
				Buttons = {
					_IPh2("\053\127"), 
					_IPh2("\065\048\048")
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							Wherigo.PlayAudio(_NUcJ)
							_Urwigo.MessageBox{
								Text = _IPh2("\101\021\001\034\007\066\021\048\075\007\056\021\034\013\028\007\085\036\033\028\007\127\075\033\007\001\048\007\017\021\001\007\023\048\002\085\127\127\064\028\007\077\054\007\098\048\028\007\119\048\085\119\098\077\064\083\007\060\119\007\066\127\075\007\001\048\007\023\048\075\077\034\048\034\007\017\048\028\007\048\048\034\007\075\048\056\048\034\083"), 
								Media = _K3Rd
							}
							_5B91S:MoveTo(Player)
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _IPh2("\038\048\034\007\033\105\098\048\013\048\075\007\013\021\048\007\001\048\007\098\048\023\028\007\023\048\002\085\127\056\048\034"), 
				Media = _K3Rd
			}
		end
	end
end
function _DELM3:OnClick()
	if __fjJM == true then
		_vsSn4 = true
		_Urwigo.MessageBox{
			Text = _IPh2("\053\048\007\023\048\034\028\007\034\036\007\002\048\096\127\054\048\034\013"), 
			Media = _sR91
		}
		Wherigo.PlayAudio(_rLqn)
	else
		if _pys == true then
			_Urwigo.MessageBox{
				Text = _IPh2("\124\077\048\013\007\066\077\083\007\053\127\127\002\007\098\048\017\007\034\036\007\096\048\002\083"), 
				Media = _sR91
			}
			_pys = false
			Wherigo.PlayAudio(_rLqn)
		elseif _RmH:Contains(_DELM3) then
			if Player:Contains(_DELM3) then
				_Urwigo.MessageBox{
					Text = _IPh2("\038\048\034\007\017\077\077\021\007\056\075\021\001\017\033\105\098\048\085\054\007\066\096\127\127\085\013\083"), 
					Media = _sR91
				}
				Wherigo.PlayAudio(_rLqn)
			else
				_Urwigo.MessageBox{
					Text = _IPh2("\009\085\077\023\048\048\085\007\098\048\028\007\048\085\007\017\127\127\085\007\036\021\028\007\028\048\007\028\085\048\119\119\048\034\083"), 
					Media = __MBWj, 
					Callback = function(action)
						if action ~= nil then
							if _6FBch == true then
								_Urwigo.MessageBox{
									Text = _IPh2("\124\048\075\036\119\028\094\007\053\048\007\098\048\023\028\007\013\048\007\013\085\127\119\048\034\013\077\013\048\085\007\021\034\007\098\127\034\013\048\034\083"), 
									Media = _sR91
								}
								_DELM3:MoveTo(Player)
								_8Wwb.Complete = true
								_nfst.Active = true
								_TaG5.Visible = true
								Wherigo.PlayAudio(_rLqn)
							else
								_Urwigo.MessageBox{
									Text = _IPh2("\053\048\007\023\048\034\028\007\034\021\048\028\007\033\028\048\085\119\007\002\048\034\077\048\002\083\007\092\077\085\002\007\013\127\028\007\001\048\007\028\077\056\048\085\013\085\127\034\119\007\119\085\021\001\002\028\083"), 
									Media = __MBWj
								}
								_nfst.Visible = true
							end
						end
					end
				}
			end
		else
			_Urwigo.MessageBox{
				Text = _IPh2("\038\048\034\007\017\077\077\021\007\056\075\021\001\017\033\105\098\048\085\054\007\066\096\127\127\085\013\083"), 
				Media = _sR91
			}
			Wherigo.PlayAudio(_rLqn)
		end
	end
end
function _fp0s:OnClick()
	_Urwigo.MessageBox{
		Text = _IPh2("\011\098\127\052\007\013\021\028\007\066\127\075\007\005\098\048\017\085\036\066\007\066\048\119\048\085\007\023\048\013\077\048\075\048\034\083\007\060\119\007\066\127\075\007\098\048\017\007\017\048\048\034\048\017\048\034"), 
		Media = _vJKc, 
		Callback = function(action)
			if action ~= nil then
				_fp0s:MoveTo(Player)
				Wherigo.PlayAudio(_qe7)
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _Ve59:OnClick()
	_Urwigo.MessageBox{
		Text = _IPh2("\022\048\007\036\034\075\077\105\119\105\077\013\048\007\021\033\078\007")..string.sub(Player.CompletionCode, 1, 15), 
		Media = _EqW9I, 
		Callback = function(action)
			if action ~= nil then
				_JRwJ.Complete = true
				_5w1HT.Active = false
			end
		end
	}
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return _JRwJ
