require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _xaE(str)
	local res = ""
    local dtable = "\078\018\092\123\070\125\066\103\072\012\052\083\035\079\068\046\074\060\098\124\010\088\085\091\009\061\112\025\039\115\027\045\054\065\002\064\041\019\095\081\106\087\059\038\076\107\120\080\033\022\024\050\006\126\013\049\057\004\000\055\084\034\117\114\032\016\051\029\005\111\011\048\008\007\047\071\110\031\028\093\037\043\073\089\102\077\100\119\105\056\044\094\109\003\116\090\063\001\082\075\020\067\021\062\104\113\118\030\017\101\023\026\097\053\036\122\108\040\096\099\014\042\121\015\086\069\058"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_cZcj = Wherigo.ZCartridge()

-- Media --
zmediaAlienGeocacher = Wherigo.ZMedia(_cZcj)
zmediaAlienGeocacher.Id = "668e349e-7735-408b-b0c6-c0b937b91c94"
zmediaAlienGeocacher.Name = _xaE("\034\117\089\110\077\065\076\110\070\120\113\120\105\110\064")
zmediaAlienGeocacher.Description = ""
zmediaAlienGeocacher.AltText = ""
zmediaAlienGeocacher.Resources = {
	{
		Type = "jpg", 
		Filename = "alien_geocacher.jpg", 
		Directives = {}
	}
}
zmediaAlienMechanic = Wherigo.ZMedia(_cZcj)
zmediaAlienMechanic.Id = "d73f04f8-5d5c-47d4-8a23-88632b9fcb0f"
zmediaAlienMechanic.Name = _xaE("\034\117\089\110\077\065\086\110\120\105\113\077\089\120")
zmediaAlienMechanic.Description = ""
zmediaAlienMechanic.AltText = ""
zmediaAlienMechanic.Resources = {
	{
		Type = "jpg", 
		Filename = "alien_mechanic.jpg", 
		Directives = {}
	}
}
zmediaCar = Wherigo.ZMedia(_cZcj)
zmediaCar.Id = "57a1d0e5-1dc8-4dc3-8fbc-5f570862bf63"
zmediaCar.Name = _xaE("\102\113\064")
zmediaCar.Description = ""
zmediaCar.AltText = ""
zmediaCar.Resources = {
	{
		Type = "jpg", 
		Filename = "car.jpg", 
		Directives = {}
	}
}
zmediaFluxCapacitorOff = Wherigo.ZMedia(_cZcj)
zmediaFluxCapacitorOff.Id = "39ce021e-4d46-4b09-b987-10edabdad680"
zmediaFluxCapacitorOff.Name = _xaE("\005\117\063\047\065\102\113\027\113\120\089\095\070\064\065\014\085\085")
zmediaFluxCapacitorOff.Description = ""
zmediaFluxCapacitorOff.AltText = ""
zmediaFluxCapacitorOff.Resources = {
	{
		Type = "jpg", 
		Filename = "flux_capacitor_off.jpg", 
		Directives = {}
	}
}
zmediaFluxCapacitorOn = Wherigo.ZMedia(_cZcj)
zmediaFluxCapacitorOn.Id = "4f57146b-525b-4948-96bb-435703c2df2b"
zmediaFluxCapacitorOn.Name = _xaE("\005\117\063\047\065\102\113\027\113\120\089\095\070\064\065\014\077")
zmediaFluxCapacitorOn.Description = ""
zmediaFluxCapacitorOn.AltText = ""
zmediaFluxCapacitorOn.Resources = {
	{
		Type = "jpg", 
		Filename = "flux_capacitor_on.jpg", 
		Directives = {}
	}
}
zmediaFlyingSaucer = Wherigo.ZMedia(_cZcj)
zmediaFlyingSaucer.Id = "3ebdbbdf-a364-4d05-ab10-7b54b0e0c92d"
zmediaFlyingSaucer.Name = _xaE("\005\117\123\089\077\008\065\012\113\063\120\110\064")
zmediaFlyingSaucer.Description = ""
zmediaFlyingSaucer.AltText = ""
zmediaFlyingSaucer.Resources = {
	{
		Type = "jpg", 
		Filename = "flying_saucer.jpg", 
		Directives = {}
	}
}
zmediaSpaceshipPart1 = Wherigo.ZMedia(_cZcj)
zmediaSpaceshipPart1.Id = "faf85936-ed98-4ad3-b30a-2a8003e0e132"
zmediaSpaceshipPart1.Name = _xaE("\012\027\113\120\110\030\105\089\027\065\048\113\064\095\065\056")
zmediaSpaceshipPart1.Description = ""
zmediaSpaceshipPart1.AltText = ""
zmediaSpaceshipPart1.Resources = {
	{
		Type = "jpg", 
		Filename = "gadget_1.jpg", 
		Directives = {}
	}
}
zmediaSpaceshipPart2 = Wherigo.ZMedia(_cZcj)
zmediaSpaceshipPart2.Id = "37c1ec34-3e10-4e1f-84c8-ea408f29a183"
zmediaSpaceshipPart2.Name = _xaE("\012\027\113\120\110\030\105\089\027\065\048\113\064\095\065\052")
zmediaSpaceshipPart2.Description = ""
zmediaSpaceshipPart2.AltText = ""
zmediaSpaceshipPart2.Resources = {
	{
		Type = "jpg", 
		Filename = "gadget_2.jpg", 
		Directives = {}
	}
}
zmediaSpaceshipPart3 = Wherigo.ZMedia(_cZcj)
zmediaSpaceshipPart3.Id = "9d98e0f0-6d2e-48b3-ba59-6fa0ce357be2"
zmediaSpaceshipPart3.Name = _xaE("\012\027\113\120\110\030\105\089\027\065\048\113\064\095\065\067")
zmediaSpaceshipPart3.Description = ""
zmediaSpaceshipPart3.AltText = ""
zmediaSpaceshipPart3.Resources = {
	{
		Type = "jpg", 
		Filename = "gadget_3.jpg", 
		Directives = {}
	}
}
zmediaGloves = Wherigo.ZMedia(_cZcj)
zmediaGloves.Id = "9625d679-2371-487f-a279-bb8e7b5ccea7"
zmediaGloves.Name = _xaE("\076\117\070\107\110\030")
zmediaGloves.Description = ""
zmediaGloves.AltText = ""
zmediaGloves.Resources = {
	{
		Type = "jpg", 
		Filename = "gloves.jpg", 
		Directives = {}
	}
}
zmediaWalkieTalkie = Wherigo.ZMedia(_cZcj)
zmediaWalkieTalkie.Id = "1aa544af-a3b3-49d4-b3c9-35e998b602c3"
zmediaWalkieTalkie.Name = _xaE("\042\113\117\046\089\110\065\061\113\117\046\089\110")
zmediaWalkieTalkie.Description = ""
zmediaWalkieTalkie.AltText = ""
zmediaWalkieTalkie.Resources = {
	{
		Type = "jpg", 
		Filename = "radio.jpg", 
		Directives = {}
	}
}
zmediaSunglasses = Wherigo.ZMedia(_cZcj)
zmediaSunglasses.Id = "f59caaec-3679-4861-ad41-4b12eef4ceaf"
zmediaSunglasses.Name = _xaE("\012\063\077\008\117\113\030\030\110\030")
zmediaSunglasses.Description = ""
zmediaSunglasses.AltText = ""
zmediaSunglasses.Resources = {
	{
		Type = "jpg", 
		Filename = "sunglasses.jpg", 
		Directives = {}
	}
}
zmediaAlienMultiTool = Wherigo.ZMedia(_cZcj)
zmediaAlienMultiTool.Id = "bd67d032-3cc2-47ed-b9fc-66f856fa732c"
zmediaAlienMultiTool.Name = _xaE("\034\117\089\110\077\065\086\063\117\095\089\061\070\070\117")
zmediaAlienMultiTool.Description = ""
zmediaAlienMultiTool.AltText = ""
zmediaAlienMultiTool.Resources = {
	{
		Type = "jpg", 
		Filename = "wrench.jpg", 
		Directives = {}
	}
}
zmediaMap = Wherigo.ZMedia(_cZcj)
zmediaMap.Id = "df7bb841-83b6-4d3f-88d5-ddadd0dc7b8c"
zmediaMap.Name = _xaE("\086\113\027")
zmediaMap.Description = ""
zmediaMap.AltText = ""
zmediaMap.Resources = {
	{
		Type = "jpg", 
		Filename = "map.jpg", 
		Directives = {}
	}
}
zmediaGeocacher = Wherigo.ZMedia(_cZcj)
zmediaGeocacher.Id = "ba7c5624-5ab0-4c98-b43d-cb2a97f29654"
zmediaGeocacher.Name = _xaE("\076\110\070\120\113\120\105\110\064")
zmediaGeocacher.Description = ""
zmediaGeocacher.AltText = ""
zmediaGeocacher.Resources = {
	{
		Type = "jpg", 
		Filename = "geocacher.jpg", 
		Directives = {}
	}
}
zmediaTask = Wherigo.ZMedia(_cZcj)
zmediaTask.Id = "dbc2d6e8-bd36-4014-a307-2addcd26f9f1"
zmediaTask.Name = _xaE("\061\113\030\046")
zmediaTask.Description = ""
zmediaTask.AltText = ""
zmediaTask.Resources = {
	{
		Type = "jpg", 
		Filename = "task.jpg", 
		Directives = {}
	}
}
zmediaSpaceCraftinOrbit = Wherigo.ZMedia(_cZcj)
zmediaSpaceCraftinOrbit.Id = "b7735d86-fe3e-4735-984e-600d10977ff8"
zmediaSpaceCraftinOrbit.Name = _xaE("\012\027\113\120\110\065\102\064\113\085\095\065\089\077\065\014\064\019\089\095")
zmediaSpaceCraftinOrbit.Description = ""
zmediaSpaceCraftinOrbit.AltText = ""
zmediaSpaceCraftinOrbit.Resources = {
	{
		Type = "jpg", 
		Filename = "space_craftinorbit.jpg", 
		Directives = {}
	}
}
zmediaWherigo = Wherigo.ZMedia(_cZcj)
zmediaWherigo.Id = "7504aabc-1d8b-4f6c-b3ba-ad27ed1fefe3"
zmediaWherigo.Name = _xaE("\042\105\110\064\089\008\070")
zmediaWherigo.Description = ""
zmediaWherigo.AltText = ""
zmediaWherigo.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo.jpg", 
		Directives = {}
	}
}
zmediaGeocache = Wherigo.ZMedia(_cZcj)
zmediaGeocache.Id = "743bdd35-43a9-4c5f-8533-4077bd80a43c"
zmediaGeocache.Name = _xaE("\076\110\070\120\113\120\105\110")
zmediaGeocache.Description = ""
zmediaGeocache.AltText = ""
zmediaGeocache.Resources = {
	{
		Type = "jpg", 
		Filename = "geocache.jpg", 
		Directives = {}
	}
}
zmediaSpoiler = Wherigo.ZMedia(_cZcj)
zmediaSpoiler.Id = "7530bb32-cce5-4c6d-98fc-e151476a3e62"
zmediaSpoiler.Name = _xaE("\012\027\070\089\117\110\064")
zmediaSpoiler.Description = ""
zmediaSpoiler.AltText = ""
zmediaSpoiler.Resources = {
	{
		Type = "jpg", 
		Filename = "spoiler.jpg", 
		Directives = {}
	}
}
zmediaAlienSWAG = Wherigo.ZMedia(_cZcj)
zmediaAlienSWAG.Id = "c20f099e-d6d0-4333-989c-7a099b14ab4e"
zmediaAlienSWAG.Name = _xaE("\034\117\089\110\077\065\012\042\034\076")
zmediaAlienSWAG.Description = ""
zmediaAlienSWAG.AltText = ""
zmediaAlienSWAG.Resources = {
	{
		Type = "jpg", 
		Filename = "swag.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_cZcj.Id="762b6d1a-5710-4f61-b239-de2c914c2ee1"
_cZcj.Name="Alien Cacher"
_cZcj.Description=[[A small quest type game that will eventually lead you to find a geocache.]]
_cZcj.Visible=true
_cZcj.Activity="Fiction"
_cZcj.StartingLocationDescription=[[One day a geocacher went to the park to do some geocaching... And he ended helping some aliens from the Acheron System. For a reward they gave him...]]
_cZcj.StartingLocation = ZonePoint(42.14448,24.74096,0)
_cZcj.Version=""
_cZcj.Company="www.geocaching-bg.org"
_cZcj.Author="Squiffy"
_cZcj.BuilderVersion="URWIGO 1.22.5798.37755"
_cZcj.CreateDate="12/03/2012 21:25:00"
_cZcj.PublishDate="1/1/0001 12:00:00 AM"
_cZcj.UpdateDate="04/28/2017 18:05:16"
_cZcj.LastPlayedDate="1/1/0001 12:00:00 AM"
_cZcj.TargetDevice="PocketPC"
_cZcj.TargetDeviceVersion="0"
_cZcj.StateId="1"
_cZcj.CountryId="2"
_cZcj.Complete=false
_cZcj.UseLogging=true


-- Zones --
_AZY4 = Wherigo.Zone(_cZcj)
_AZY4.Id = "5bb33641-171b-41ce-a7eb-86911b254db1"
_AZY4.Name = _xaE("\048\113\064\046\089\077\008")
_AZY4.Description = ""
_AZY4.Visible = true
_AZY4.Media = zmediaMap
_AZY4.Commands = {}
_AZY4.DistanceRange = Distance(-1, "feet")
_AZY4.ShowObjects = "OnEnter"
_AZY4.ProximityRange = Distance(200, "feet")
_AZY4.AllowSetPositionTo = false
_AZY4.Active = true
_AZY4.Points = {
	ZonePoint(42.1445888680725, 24.7408034435113, 0), 
	ZonePoint(42.1445773203173, 24.7408748546574, 0), 
	ZonePoint(42.1445463892208, 24.7409348698604, 0), 
	ZonePoint(42.1445007837384, 24.7409743523498, 0), 
	ZonePoint(42.1444474468685, 24.7409872912744, 0), 
	ZonePoint(42.1443944986571, 24.7409717168003, 0), 
	ZonePoint(42.14435, 24.74093, 0), 
	ZonePoint(42.144320725438, 24.7408684918781, 0), 
	ZonePoint(42.1443111317808, 24.7407965564887, 0), 
	ZonePoint(42.1443226795846, 24.7407251453426, 0), 
	ZonePoint(42.1443536107904, 24.7406651301396, 0), 
	ZonePoint(42.1443992163788, 24.7406256476502, 0), 
	ZonePoint(42.1444525532893, 24.7406127087256, 0), 
	ZonePoint(42.1445055014522, 24.7406282831997, 0), 
	ZonePoint(42.14455, 24.74067, 0), 
	ZonePoint(42.144579274456, 24.7407315081219, 0)
}
_AZY4.OriginalPoint = ZonePoint(42.14445, 24.7408, 0)
_AZY4.DistanceRangeUOM = "Feet"
_AZY4.ProximityRangeUOM = "Feet"
_AZY4.OutOfRangeName = ""
_AZY4.InRangeName = ""
_vPT__ = Wherigo.Zone(_cZcj)
_vPT__.Id = "d6c086da-5638-46f5-ab53-0e2ccbb08429"
_vPT__.Name = _xaE("\102\064\113\030\105\065\012\089\095\110")
_vPT__.Description = ""
_vPT__.Visible = false
_vPT__.Media = zmediaMap
_vPT__.Commands = {}
_vPT__.DistanceRange = Distance(-1, "feet")
_vPT__.ShowObjects = "OnEnter"
_vPT__.ProximityRange = Distance(50, "meters")
_vPT__.AllowSetPositionTo = false
_vPT__.Active = false
_vPT__.Points = {
	ZonePoint(42.1444764748281, 24.739981467036, 0), 
	ZonePoint(42.1444698973296, 24.7400155504691, 0), 
	ZonePoint(42.1444541495876, 24.7400436446454, 0), 
	ZonePoint(42.1444316290473, 24.740061472481, 0), 
	ZonePoint(42.1444057642517, 24.7400663198497, 0), 
	ZonePoint(42.14438049288, 24.7400574487834, 0), 
	ZonePoint(42.1443596622721, 24.7400362098217, 0), 
	ZonePoint(42.1443464437051, 24.7400058364039, 0), 
	ZonePoint(42.1443428495909, 24.7399709526075, 0), 
	ZonePoint(42.1443494271026, 24.7399368691743, 0), 
	ZonePoint(42.1443651748707, 24.739908774998, 0), 
	ZonePoint(42.1443876954346, 24.7398909471624, 0), 
	ZonePoint(42.1444135602375, 24.7398860997937, 0), 
	ZonePoint(42.1444388315961, 24.73989497086, 0), 
	ZonePoint(42.1444596621779, 24.7399162098217, 0), 
	ZonePoint(42.1444728807213, 24.7399465832395, 0)
}
_vPT__.OriginalPoint = ZonePoint(42.14435, 24.73994, 0)
_vPT__.DistanceRangeUOM = "Feet"
_vPT__.ProximityRangeUOM = "Meters"
_vPT__.OutOfRangeName = ""
_vPT__.InRangeName = ""
_2F0 = Wherigo.Zone(_cZcj)
_2F0.Id = "04378a03-7f84-40af-b398-a3a83edfcdd8"
_2F0.Name = _xaE("\012\105\089\027\065\048\113\064\095\065\056")
_2F0.Description = ""
_2F0.Visible = false
_2F0.Media = zmediaMap
_2F0.Commands = {}
_2F0.DistanceRange = Distance(-1, "feet")
_2F0.ShowObjects = "OnEnter"
_2F0.ProximityRange = Distance(50, "meters")
_2F0.AllowSetPositionTo = false
_2F0.Active = false
_2F0.Points = {
	ZonePoint(42.1438910675052, 24.7408351014622, 0), 
	ZonePoint(42.1438869158326, 24.740869345106, 0), 
	ZonePoint(42.1438733637141, 24.7408988393463, 0), 
	ZonePoint(42.1438524743317, 24.7409190939522, 0), 
	ZonePoint(42.1438274278992, 24.7409270253437, 0), 
	ZonePoint(42.1438020375063, 24.7409214260383, 0), 
	ZonePoint(42.143780168612, 24.7409031484795, 0), 
	ZonePoint(42.1437651505623, 24.7408749752599, 0), 
	ZonePoint(42.1437592697245, 24.7408411954968, 0), 
	ZonePoint(42.1437634214055, 24.7408069518529, 0), 
	ZonePoint(42.1437769735476, 24.7407774576126, 0), 
	ZonePoint(42.1437978629548, 24.7407572030067, 0), 
	ZonePoint(42.1438229093991, 24.7407492716152, 0), 
	ZonePoint(42.1438482997836, 24.7407548709206, 0), 
	ZonePoint(42.1438701686544, 24.7407731484795, 0), 
	ZonePoint(42.1438851866791, 24.7408013216991, 0)
}
_2F0.OriginalPoint = ZonePoint(42.143856, 24.740758, 0)
_2F0.DistanceRangeUOM = "Feet"
_2F0.ProximityRangeUOM = "Meters"
_2F0.OutOfRangeName = ""
_2F0.InRangeName = ""
zoneShipPart2 = Wherigo.Zone(_cZcj)
zoneShipPart2.Id = "292beefa-22aa-4df8-8e7f-65a0ffc5db74"
zoneShipPart2.Name = _xaE("\012\105\089\027\065\048\113\064\095\065\052")
zoneShipPart2.Description = ""
zoneShipPart2.Visible = false
zoneShipPart2.Media = zmediaMap
zoneShipPart2.Commands = {}
zoneShipPart2.DistanceRange = Distance(-1, "feet")
zoneShipPart2.ShowObjects = "OnEnter"
zoneShipPart2.ProximityRange = Distance(50, "meters")
zoneShipPart2.AllowSetPositionTo = false
zoneShipPart2.Active = false
zoneShipPart2.Points = {
	ZonePoint(42.1429516171705, 24.739678550562, 0), 
	ZonePoint(42.142945039898, 24.7397126336489, 0), 
	ZonePoint(42.14292929223, 24.7397407277035, 0), 
	ZonePoint(42.1429067716006, 24.7397585556608, 0), 
	ZonePoint(42.1428809065664, 24.7397634033758, 0), 
	ZonePoint(42.1428556348428, 24.7397545328278, 0), 
	ZonePoint(42.1428348038235, 24.7397332944775, 0), 
	ZonePoint(42.1428215848479, 24.739702921671, 0), 
	ZonePoint(42.1428179903904, 24.7396680383929, 0), 
	ZonePoint(42.1428245676761, 24.739633955306, 0), 
	ZonePoint(42.1428403153702, 24.7396058612514, 0), 
	ZonePoint(42.1428628360232, 24.7395880332942, 0), 
	ZonePoint(42.1428887010648, 24.7395831855792, 0), 
	ZonePoint(42.1429139727752, 24.7395920561271, 0), 
	ZonePoint(42.1429348037685, 24.7396132944775, 0), 
	ZonePoint(42.1429480227204, 24.7396436672839, 0)
}
zoneShipPart2.OriginalPoint = ZonePoint(42.14285, 24.73968, 0)
zoneShipPart2.DistanceRangeUOM = "Feet"
zoneShipPart2.ProximityRangeUOM = "Meters"
zoneShipPart2.OutOfRangeName = ""
zoneShipPart2.InRangeName = ""
_ejX = Wherigo.Zone(_cZcj)
_ejX.Id = "99329f21-f111-43c6-839e-63350892c032"
_ejX.Name = _xaE("\012\105\089\027\065\048\113\064\095\065\067")
_ejX.Description = ""
_ejX.Visible = false
_ejX.Media = zmediaMap
_ejX.Commands = {}
_ejX.DistanceRange = Distance(-1, "feet")
_ejX.ShowObjects = "OnEnter"
_ejX.ProximityRange = Distance(50, "meters")
_ejX.AllowSetPositionTo = false
_ejX.Active = false
_ejX.Points = {
	ZonePoint(42.1430005414153, 24.7410333095809, 0), 
	ZonePoint(42.1429947677774, 24.7410690148076, 0), 
	ZonePoint(42.1429793022978, 24.7410990222875, 0), 
	ZonePoint(42.1429564994496, 24.7411187636538, 0), 
	ZonePoint(42.1429298307541, 24.7411252334625, 0), 
	ZonePoint(42.1429033562761, 24.7411174467437, 0), 
	ZonePoint(42.1428811065176, 24.7410965889549, 0), 
	ZonePoint(42.1428664688086, 24.7410658355054, 0), 
	ZonePoint(42.1428616716132, 24.7410298683289, 0), 
	ZonePoint(42.1428674452632, 24.7409941631022, 0), 
	ZonePoint(42.1428829107702, 24.7409641556223, 0), 
	ZonePoint(42.1429057136448, 24.740944414256, 0), 
	ZonePoint(42.1429323823505, 24.7409379444474, 0), 
	ZonePoint(42.1429588568163, 24.7409457311661, 0), 
	ZonePoint(42.1429811065475, 24.7409665889549, 0), 
	ZonePoint(42.1429957442301, 24.7409973424045, 0)
}
_ejX.OriginalPoint = ZonePoint(42.14295, 24.741044, 0)
_ejX.DistanceRangeUOM = "Feet"
_ejX.ProximityRangeUOM = "Meters"
_ejX.OutOfRangeName = ""
_ejX.InRangeName = ""
_N4Yq = Wherigo.Zone(_cZcj)
_N4Yq.Id = "a07cf0de-c6ba-49c8-b241-6898cc6a8886"
_N4Yq.Name = _xaE("\005\117\063\047\065\102\113\027\113\120\089\095\070\064")
_N4Yq.Description = ""
_N4Yq.Visible = false
_N4Yq.Media = zmediaMap
_N4Yq.Commands = {}
_N4Yq.DistanceRange = Distance(-1, "feet")
_N4Yq.ShowObjects = "OnEnter"
_N4Yq.ProximityRange = Distance(50, "meters")
_N4Yq.AllowSetPositionTo = false
_N4Yq.Active = false
_N4Yq.Points = {
	ZonePoint(42.1451121993608, 24.7403665866555, 0), 
	ZonePoint(42.1451108420804, 24.7404059979125, 0), 
	ZonePoint(42.1450984055745, 24.740441708633, 0), 
	ZonePoint(42.1450767831826, 24.7404682821837, 0), 
	ZonePoint(42.1450492667106, 24.7404816729822, 0), 
	ZonePoint(42.1450200452872, 24.740479842401, 0), 
	ZonePoint(42.1449935676098, 24.7404630691294, 0), 
	ZonePoint(42.1449738646706, 24.7404339067459, 0), 
	ZonePoint(42.1449639360707, 24.7403967949591, 0), 
	ZonePoint(42.1449652933542, 24.7403573837022, 0), 
	ZonePoint(42.1449777298863, 24.7403216729817, 0), 
	ZonePoint(42.144999352312, 24.740295099431, 0), 
	ZonePoint(42.1450268688057, 24.7402817086325, 0), 
	ZonePoint(42.145056090226, 24.7402835392137, 0), 
	ZonePoint(42.1450825678772, 24.7403003124853, 0), 
	ZonePoint(42.1451022707826, 24.7403294748688, 0)
}
_N4Yq.OriginalPoint = ZonePoint(42.14505, 24.74032, 0)
_N4Yq.DistanceRangeUOM = "Feet"
_N4Yq.ProximityRangeUOM = "Meters"
_N4Yq.OutOfRangeName = ""
_N4Yq.InRangeName = ""
_WJZ = Wherigo.Zone(_cZcj)
_WJZ.Id = "8037f21b-3d3e-4840-837d-f8fca939300c"
_WJZ.Name = _xaE("\086\123\030\095\110\064\123\065\001\063\093\019\110\064")
_WJZ.Description = ""
_WJZ.Visible = false
_WJZ.Media = zmediaMap
_WJZ.Commands = {}
_WJZ.DistanceRange = Distance(-1, "feet")
_WJZ.ShowObjects = "OnEnter"
_WJZ.ProximityRange = Distance(50, "meters")
_WJZ.AllowSetPositionTo = false
_WJZ.Active = false
_WJZ.Points = {
	ZonePoint(42.1454653432099, 24.7399974512922, 0), 
	ZonePoint(42.1454595691741, 24.7400331570799, 0), 
	ZonePoint(42.1454441035623, 24.7400631647569, 0), 
	ZonePoint(42.1454213008675, 24.7400829059261, 0), 
	ZonePoint(42.1453946325876, 24.7400893751737, 0), 
	ZonePoint(42.1453681587243, 24.7400815876153, 0), 
	ZonePoint(42.1453459096859, 24.7400607288361, 0), 
	ZonePoint(42.1453312726928, 24.740029974396, 0), 
	ZonePoint(42.1453264761001, 24.7399940063799, 0), 
	ZonePoint(42.145332250148, 24.7399583005922, 0), 
	ZonePoint(42.1453477157872, 24.7399282929153, 0), 
	ZonePoint(42.1453705185085, 24.739908551746, 0), 
	ZonePoint(42.1453971867985, 24.7399020824984, 0), 
	ZonePoint(42.1454236606497, 24.7399098700568, 0), 
	ZonePoint(42.1454459096608, 24.7399307288361, 0), 
	ZonePoint(42.1454605466274, 24.7399614832761, 0)
}
_WJZ.OriginalPoint = ZonePoint(42.145382, 24.739989, 0)
_WJZ.DistanceRangeUOM = "Feet"
_WJZ.ProximityRangeUOM = "Meters"
_WJZ.OutOfRangeName = ""
_WJZ.InRangeName = ""
_LAyl = Wherigo.Zone(_cZcj)
_LAyl.Id = "0185206b-175a-45ef-aebf-5b49d29184c8"
_LAyl.Name = _xaE("\076\110\070\120\113\120\105\110")
_LAyl.Description = ""
_LAyl.Visible = false
_LAyl.Media = zmediaMap
_LAyl.Commands = {}
_LAyl.DistanceRange = Distance(-1, "feet")
_LAyl.ShowObjects = "OnEnter"
_LAyl.ProximityRange = Distance(50, "meters")
_LAyl.AllowSetPositionTo = false
_LAyl.Active = false
_LAyl.Points = {
	ZonePoint(42.1447711260002, 24.735817, 0), 
	ZonePoint(42.1447670059054, 24.7358449358906, 0), 
	ZonePoint(42.1447552728666, 24.735868618795, 0), 
	ZonePoint(42.144737713129, 24.7358844432059, 0), 
	ZonePoint(42.144717, 24.73589, 0), 
	ZonePoint(42.1446962868642, 24.7358844432059, 0), 
	ZonePoint(42.1446787271103, 24.735868618795, 0), 
	ZonePoint(42.1446669940551, 24.7358449358906, 0), 
	ZonePoint(42.1446628739535, 24.735817, 0), 
	ZonePoint(42.1446669940551, 24.7357890641094, 0), 
	ZonePoint(42.1446787271103, 24.735765381205, 0), 
	ZonePoint(42.1446962868642, 24.7357495567941, 0), 
	ZonePoint(42.144717, 24.735744, 0), 
	ZonePoint(42.144737713129, 24.7357495567941, 0), 
	ZonePoint(42.1447552728666, 24.735765381205, 0), 
	ZonePoint(42.1447670059054, 24.7357890641094, 0)
}
_LAyl.OriginalPoint = ZonePoint(42.1447, 24.735433, 0)
_LAyl.DistanceRangeUOM = "Feet"
_LAyl.ProximityRangeUOM = "Meters"
_LAyl.OutOfRangeName = ""
_LAyl.InRangeName = ""
_q_Z1d = Wherigo.Zone(_cZcj)
_q_Z1d.Id = "a53fc5f1-3c93-4181-9ad4-f42f2f98d2ac"
_q_Z1d.Name = _xaE("\086\123\030\095\110\064\123\065\001\063\093\019\110\064\065\052")
_q_Z1d.Description = ""
_q_Z1d.Visible = false
_q_Z1d.Media = zmediaMap
_q_Z1d.Commands = {}
_q_Z1d.DistanceRange = Distance(-1, "feet")
_q_Z1d.ShowObjects = "OnEnter"
_q_Z1d.ProximityRange = Distance(50, "meters")
_q_Z1d.AllowSetPositionTo = false
_q_Z1d.Active = false
_q_Z1d.Points = {
	ZonePoint(42.1470203299171, 24.7379786786264, 0), 
	ZonePoint(42.1470104034711, 24.7380486290352, 0), 
	ZonePoint(42.1469813855058, 24.7381081312955, 0), 
	ZonePoint(42.1469376937213, 24.7381481267276, 0), 
	ZonePoint(42.1468859797733, 24.7381625263895, 0), 
	ZonePoint(42.1468341166322, 24.7381491380632, 0), 
	ZonePoint(42.14679, 24.73811, 0), 
	ZonePoint(42.1467603462559, 24.7380510706153, 0), 
	ZonePoint(42.1467496699361, 24.7379813213736, 0), 
	ZonePoint(42.146759596423, 24.7379113709648, 0), 
	ZonePoint(42.14678861449, 24.7378518687045, 0), 
	ZonePoint(42.1468323063774, 24.7378118732724, 0), 
	ZonePoint(42.1468840203692, 24.7377974736105, 0), 
	ZonePoint(42.1469358834694, 24.7378108619368, 0), 
	ZonePoint(42.14698, 24.73785, 0), 
	ZonePoint(42.1470096536411, 24.7379089293847, 0)
}
_q_Z1d.OriginalPoint = ZonePoint(42.146883, 24.737983, 0)
_q_Z1d.DistanceRangeUOM = "Feet"
_q_Z1d.ProximityRangeUOM = "Meters"
_q_Z1d.OutOfRangeName = ""
_q_Z1d.InRangeName = ""

-- Characters --
_46q = Wherigo.ZCharacter{
	Cartridge = _cZcj, 
	Container = _vPT__
}
_46q.Id = "f7e84806-7df4-4ea3-9de1-566717c1143b"
_46q.Name = _xaE("\034\117\089\110\077\065\076\110\070\120\113\120\105\110\064")
_46q.Description = ""
_46q.Visible = false
_46q.Media = zmediaAlienGeocacher
_46q.Commands = {
	_WUm3 = Wherigo.ZCommand{
		Text = _xaE("\045\070\070\046\065\034\095"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_46q.Commands._WUm3.Custom = true
_46q.Commands._WUm3.Id = "78c8f975-2ef6-4151-aed6-6138f5f0841a"
_46q.Commands._WUm3.WorksWithAll = true
_46q.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_46q.Gender = "Male"
_46q.Type = "NPC"
_zu5 = Wherigo.ZCharacter{
	Cartridge = _cZcj, 
	Container = _vPT__
}
_zu5.Id = "faceb0d8-2de5-4e04-863d-ba9f12355440"
_zu5.Name = _xaE("\100\064\113\077\008")
_zu5.Description = ""
_zu5.Visible = false
_zu5.Media = zmediaAlienMechanic
_zu5.Commands = {
	_DGJ = Wherigo.ZCommand{
		Text = _xaE("\061\113\117\046"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_zu5.Commands._DGJ.Custom = true
_zu5.Commands._DGJ.Id = "ca1dd26c-5ece-4ca7-904a-52701d1f2dc2"
_zu5.Commands._DGJ.WorksWithAll = true
_zu5.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_zu5.Gender = "Male"
_zu5.Type = "NPC"
_IKhw = Wherigo.ZCharacter{
	Cartridge = _cZcj, 
	Container = _vPT__
}
_IKhw.Id = "92b83894-9ab7-45f2-8950-00eb12568859"
_IKhw.Name = _xaE("\100\064\113\095\105")
_IKhw.Description = ""
_IKhw.Visible = false
_IKhw.Media = zmediaAlienGeocacher
_IKhw.Commands = {
	_fhJM = Wherigo.ZCommand{
		Text = _xaE("\061\113\117\046"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_IKhw.Commands._fhJM.Custom = true
_IKhw.Commands._fhJM.Id = "911f8e03-2a57-4e00-94c8-0c57b00f54b6"
_IKhw.Commands._fhJM.WorksWithAll = true
_IKhw.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_IKhw.Gender = "Male"
_IKhw.Type = "NPC"

-- Items --
_ip_po = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = _AZY4
}
_ip_po.Id = "855b820c-6cbe-40ca-8dfa-ea0caac01f6a"
_ip_po.Name = _xaE("\084\070\063\064\065\102\113\064")
_ip_po.Description = ""
_ip_po.Visible = true
_ip_po.Media = zmediaCar
_ip_po.Commands = {
	_ERS = Wherigo.ZCommand{
		Text = _xaE("\045\070\070\046\065\083\077\030\089\087\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_ip_po.Commands._ERS.Custom = true
_ip_po.Commands._ERS.Id = "16c6431c-6ee3-4d69-8e32-3076f25f5194"
_ip_po.Commands._ERS.WorksWithAll = true
_ip_po.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_ip_po.Locked = false
_ip_po.Opened = false
_uFEK = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = _AZY4
}
_uFEK.Id = "ed63147d-3817-4d14-b49f-72f1d3ff4785"
_uFEK.Name = _xaE("\076\117\070\107\110\030")
_uFEK.Description = ""
_uFEK.Visible = false
_uFEK.Media = zmediaGloves
_uFEK.Commands = {
	_XkrHw = Wherigo.ZCommand{
		Text = _xaE("\126\047\113\093\089\077\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_uFEK.Commands._XkrHw.Custom = true
_uFEK.Commands._XkrHw.Id = "d894be3b-1c37-4d3c-8ba7-4ae22aa74fb6"
_uFEK.Commands._XkrHw.WorksWithAll = true
_uFEK.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_uFEK.Locked = false
_uFEK.Opened = false
_mRxqq = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = _AZY4
}
_mRxqq.Id = "83feba43-86ac-408b-aedb-57b450257828"
_mRxqq.Name = _xaE("\042\113\117\046\089\110\065\061\113\117\046\089\110")
_mRxqq.Description = ""
_mRxqq.Visible = false
_mRxqq.Media = zmediaWalkieTalkie
_mRxqq.Commands = {
	_9w1j6 = Wherigo.ZCommand{
		Text = _xaE("\126\047\113\093\089\077\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_mRxqq.Commands._9w1j6.Custom = true
_mRxqq.Commands._9w1j6.Id = "185bf4bf-dc59-457f-8954-4f7aa2a2683e"
_mRxqq.Commands._9w1j6.WorksWithAll = true
_mRxqq.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_mRxqq.Locked = false
_mRxqq.Opened = false
_YdN = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = _AZY4
}
_YdN.Id = "864785cd-d26c-4473-8ca6-741dd7d98707"
_YdN.Name = _xaE("\012\063\077\008\117\113\030\030\110\030")
_YdN.Description = ""
_YdN.Visible = false
_YdN.Media = zmediaSunglasses
_YdN.Commands = {
	_kgY = Wherigo.ZCommand{
		Text = _xaE("\126\047\113\093\089\077\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_YdN.Commands._kgY.Custom = true
_YdN.Commands._kgY.Id = "b5d627ec-5354-4501-8ced-b3367f1235a4"
_YdN.Commands._kgY.WorksWithAll = true
_YdN.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_YdN.Locked = false
_YdN.Opened = false
_XZ9s = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = _vPT__
}
_XZ9s.Id = "4fa0c5eb-85ae-4c87-88ca-ec53d6c3eace"
_XZ9s.Name = _xaE("\034\117\089\110\077\065\012\027\113\120\110\065\102\064\113\085\095")
_XZ9s.Description = ""
_XZ9s.Visible = true
_XZ9s.Media = zmediaFlyingSaucer
_XZ9s.Commands = {
	_fIP = Wherigo.ZCommand{
		Text = _xaE("\126\047\113\093\089\077\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_XZ9s.Commands._fIP.Custom = true
_XZ9s.Commands._fIP.Id = "c2eaf294-d5ae-447e-9d09-addd5b79e179"
_XZ9s.Commands._fIP.WorksWithAll = true
_XZ9s.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_XZ9s.Locked = false
_XZ9s.Opened = false
_72cpo = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = _2F0
}
_72cpo.Id = "d6edc685-84e4-4e43-b651-ed276b268719"
_72cpo.Name = _xaE("\012\027\113\120\110\065\012\105\089\027\065\048\113\064\095\065\056")
_72cpo.Description = ""
_72cpo.Visible = true
_72cpo.Media = zmediaSpaceshipPart1
_72cpo.Commands = {
	_JN00j = Wherigo.ZCommand{
		Text = _xaE("\126\047\113\093\089\077\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_72cpo.Commands._JN00j.Custom = true
_72cpo.Commands._JN00j.Id = "46b886fb-4f33-41e6-b0ad-379460649466"
_72cpo.Commands._JN00j.WorksWithAll = true
_72cpo.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_72cpo.Locked = false
_72cpo.Opened = false
_v4DA = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = zoneShipPart2
}
_v4DA.Id = "1cca377d-5802-4577-ae9d-c937f2770cae"
_v4DA.Name = _xaE("\012\027\113\120\110\065\012\105\089\027\065\048\113\064\095\065\052")
_v4DA.Description = ""
_v4DA.Visible = true
_v4DA.Media = zmediaSpaceshipPart2
_v4DA.Commands = {
	_RGe = Wherigo.ZCommand{
		Text = _xaE("\126\047\113\093\089\077\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_v4DA.Commands._RGe.Custom = true
_v4DA.Commands._RGe.Id = "6793557e-7a60-48ae-8798-5705dd36edb7"
_v4DA.Commands._RGe.WorksWithAll = true
_v4DA.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_v4DA.Locked = false
_v4DA.Opened = false
__kUY7 = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = _ejX
}
__kUY7.Id = "c2150bc4-ec54-4876-b917-d821db944890"
__kUY7.Name = _xaE("\012\027\113\120\110\065\012\105\089\027\065\048\113\064\095\065\067")
__kUY7.Description = ""
__kUY7.Visible = true
__kUY7.Media = zmediaSpaceshipPart3
__kUY7.Commands = {
	_Uemk = Wherigo.ZCommand{
		Text = _xaE("\126\047\113\093\089\077\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
__kUY7.Commands._Uemk.Custom = true
__kUY7.Commands._Uemk.Id = "d47526da-b639-443d-8416-62fcf31be12d"
__kUY7.Commands._Uemk.WorksWithAll = true
__kUY7.ObjectLocation = Wherigo.INVALID_ZONEPOINT
__kUY7.Locked = false
__kUY7.Opened = false
_sL6t = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = _vPT__
}
_sL6t.Id = "a0cd2663-d4d3-49f7-8828-eec9e43d38a4"
_sL6t.Name = _xaE("\034\117\089\110\077\065\086\063\117\095\089\065\061\070\070\117")
_sL6t.Description = ""
_sL6t.Visible = false
_sL6t.Media = zmediaAlienMultiTool
_sL6t.Commands = {
	_6KgeA = Wherigo.ZCommand{
		Text = _xaE("\126\047\027\117\070\064\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_sL6t.Commands._6KgeA.Custom = true
_sL6t.Commands._6KgeA.Id = "15271db5-9c62-4b87-9f82-f399f236ada5"
_sL6t.Commands._6KgeA.WorksWithAll = true
_sL6t.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_sL6t.Locked = false
_sL6t.Opened = false
_iOb = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = _N4Yq
}
_iOb.Id = "b9897778-b6bd-416a-befb-c01027ac96d0"
_iOb.Name = _xaE("\005\117\063\047\065\102\113\027\113\120\089\095\070\064")
_iOb.Description = ""
_iOb.Visible = true
_iOb.Media = zmediaFluxCapacitorOn
_iOb.Commands = {
	_7F4U = Wherigo.ZCommand{
		Text = _xaE("\126\047\113\093\089\077\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_iOb.Commands._7F4U.Custom = true
_iOb.Commands._7F4U.Id = "587877f3-a3f7-4f21-9914-36e2eab1a213"
_iOb.Commands._7F4U.WorksWithAll = true
_iOb.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_iOb.Locked = false
_iOb.Opened = false
zitemDisabledFluxCapacitor = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = _N4Yq
}
zitemDisabledFluxCapacitor.Id = "43cb84ff-8e06-4fc9-97a0-512b47830edf"
zitemDisabledFluxCapacitor.Name = _xaE("\015\089\030\113\019\117\110\087\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064")
zitemDisabledFluxCapacitor.Description = ""
zitemDisabledFluxCapacitor.Visible = false
zitemDisabledFluxCapacitor.Media = zmediaFluxCapacitorOff
zitemDisabledFluxCapacitor.Commands = {
	_bKb7 = Wherigo.ZCommand{
		Text = _xaE("\126\047\027\117\070\064\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
zitemDisabledFluxCapacitor.Commands._bKb7.Custom = true
zitemDisabledFluxCapacitor.Commands._bKb7.Id = "5066ac29-3de3-49a9-b6f5-6bdb9f9102d9"
zitemDisabledFluxCapacitor.Commands._bKb7.WorksWithAll = true
zitemDisabledFluxCapacitor.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemDisabledFluxCapacitor.Locked = false
zitemDisabledFluxCapacitor.Opened = false
_tCsJZ = Wherigo.ZItem(_cZcj)
_tCsJZ.Id = "f702abf6-65ed-432b-8554-b1b2d59accd1"
_tCsJZ.Name = _xaE("\014\064\019\089\095\089\077\008\065\012\027\113\120\110\120\064\113\085\095")
_tCsJZ.Description = ""
_tCsJZ.Visible = false
_tCsJZ.Media = zmediaSpaceCraftinOrbit
_tCsJZ.Commands = {
	_WYVn = Wherigo.ZCommand{
		Text = _xaE("\126\047\113\093\089\077\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_tCsJZ.Commands._WYVn.Custom = true
_tCsJZ.Commands._WYVn.Id = "3e8467e1-62be-449f-af0a-75aba1d0164c"
_tCsJZ.Commands._WYVn.WorksWithAll = true
_tCsJZ.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_tCsJZ.Locked = false
_tCsJZ.Opened = false
_0jJzh = Wherigo.ZItem(_cZcj)
_0jJzh.Id = "5cf47f29-2ca4-45e5-bc16-6528ad3cadaf"
_0jJzh.Name = _xaE("\034\117\089\110\077\065\012\042\034\076")
_0jJzh.Description = ""
_0jJzh.Visible = false
_0jJzh.Media = zmediaAlienSWAG
_0jJzh.Commands = {
	_atZc = Wherigo.ZCommand{
		Text = _xaE("\126\047\113\093\089\077\110"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_0jJzh.Commands._atZc.Custom = true
_0jJzh.Commands._atZc.Id = "7b171fd6-294e-4393-9108-de667678c4a3"
_0jJzh.Commands._atZc.WorksWithAll = true
_0jJzh.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_0jJzh.Locked = false
_0jJzh.Opened = false
_WFC = Wherigo.ZItem(_cZcj)
_WFC.Id = "ef186211-ea60-4c09-922b-39ab24720597"
_WFC.Name = _xaE("\076\110\070\120\113\120\105\110\065\102\070\070\064\087\089\077\113\095\110\030")
_WFC.Description = ""
_WFC.Visible = false
_WFC.Media = zmediaGeocache
_WFC.Commands = {
	_mDW = Wherigo.ZCommand{
		Text = _xaE("\125\089\110\088"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_WFC.Commands._mDW.Custom = true
_WFC.Commands._mDW.Id = "ffa80f09-ee17-40ad-8975-5bed92514aa9"
_WFC.Commands._mDW.WorksWithAll = true
_WFC.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_WFC.Locked = false
_WFC.Opened = false
_TK0N = Wherigo.ZItem(_cZcj)
_TK0N.Id = "90c389ff-c8ec-4b9c-9c69-d790100c5d0c"
_TK0N.Name = _xaE("\102\070\093\027\117\110\095\089\070\077\065\102\070\087\110")
_TK0N.Description = ""
_TK0N.Visible = false
_TK0N.Media = zmediaWherigo
_TK0N.Commands = {
	_DrIp = Wherigo.ZCommand{
		Text = _xaE("\125\089\110\088"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_TK0N.Commands._DrIp.Custom = true
_TK0N.Commands._DrIp.Id = "55d5c2d7-9d3c-491d-be03-b91640fbdcce"
_TK0N.Commands._DrIp.WorksWithAll = true
_TK0N.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_TK0N.Locked = false
_TK0N.Opened = false
_zv4YR = Wherigo.ZItem(_cZcj)
_zv4YR.Id = "65a04440-5db1-4f3c-aa7c-5955bf2509cc"
_zv4YR.Name = _xaE("\012\027\070\089\117\110\064")
_zv4YR.Description = ""
_zv4YR.Visible = false
_zv4YR.Media = zmediaGeocache
_zv4YR.Commands = {
	_vtvsN = Wherigo.ZCommand{
		Text = _xaE("\125\089\110\088"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_zv4YR.Commands._vtvsN.Custom = true
_zv4YR.Commands._vtvsN.Id = "264843d1-25a8-4937-871a-fcf4f6ebbdd1"
_zv4YR.Commands._vtvsN.WorksWithAll = true
_zv4YR.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_zv4YR.Locked = false
_zv4YR.Opened = false
_TgNo = Wherigo.ZItem{
	Cartridge = _cZcj, 
	Container = Player
}
_TgNo.Id = "b356ec2f-3821-4c1b-9d77-99e1a38a3c66"
_TgNo.Name = _xaE("\084\070\063\064\065\086\113\027")
_TgNo.Description = _xaE("\034\065\093\113\027\065\070\085\065\095\105\110\065\113\064\110\113\016")
_TgNo.Visible = true
_TgNo.Media = zmediaMap
_TgNo.Commands = {
	_YgKwt = Wherigo.ZCommand{
		Text = _xaE("\102\105\110\120\046"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _xaE("\001\070\095\105\089\077\008\065\113\107\113\089\117\113\019\117\110")
	}
}
_TgNo.Commands._YgKwt.Custom = true
_TgNo.Commands._YgKwt.Id = "e52fa587-5fa5-4b26-8b3c-fc9fd67ca815"
_TgNo.Commands._YgKwt.WorksWithAll = true
_TgNo.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_TgNo.Locked = false
_TgNo.Opened = false

-- Tasks --
_yFk = Wherigo.ZTask(_cZcj)
_yFk.Id = "fd4c388c-77d9-4859-8bc4-52758d13230f"
_yFk.Name = _xaE("\102\105\110\120\046\065\084\070\063\064\065\086\113\027")
_yFk.Description = _xaE("\102\105\110\120\046\065\084\070\063\064\065\086\113\027")
_yFk.Visible = false
_yFk.Media = zmediaTask
_yFk.Active = false
_yFk.Complete = false
_yFk.CorrectState = "None"
_Ga713 = Wherigo.ZTask(_cZcj)
_Ga713.Id = "4d881d3f-82fb-4ca5-92e2-bcceaf15ee1e"
_Ga713.Name = _xaE("\126\047\027\117\070\064\110\065\102\064\113\030\105\065\012\089\095\110")
_Ga713.Description = _xaE("\126\047\027\117\070\064\110\065\102\064\113\030\105\065\012\089\095\110")
_Ga713.Visible = false
_Ga713.Media = zmediaTask
_Ga713.Active = false
_Ga713.Complete = false
_Ga713.CorrectState = "None"
_BzSn9 = Wherigo.ZTask(_cZcj)
_BzSn9.Id = "bedf2a2a-eb76-4c45-a33b-4a4d28d97377"
_BzSn9.Name = _xaE("\005\089\077\087\065\034\117\117\065\086\089\030\030\089\077\008\065\048\113\064\095\030")
_BzSn9.Description = _xaE("\005\089\077\087\065\034\117\117\065\086\089\030\030\089\077\008\065\048\113\064\095\030")
_BzSn9.Visible = false
_BzSn9.Media = zmediaTask
_BzSn9.Active = false
_BzSn9.Complete = false
_BzSn9.CorrectState = "None"
_G54iE = Wherigo.ZTask(_cZcj)
_G54iE.Id = "4578318f-aa00-4cb5-9cfe-06824bc9af8d"
_G54iE.Name = _xaE("\005\089\077\087\065\095\105\110\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064")
_G54iE.Description = ""
_G54iE.Visible = false
_G54iE.Media = zmediaTask
_G54iE.Active = false
_G54iE.Complete = false
_G54iE.CorrectState = "None"
_j34au = Wherigo.ZTask(_cZcj)
_j34au.Id = "bb008c1b-788e-42fa-af9d-bcac725187cb"
_j34au.Name = _xaE("\061\113\046\110\065\034\117\117\065\048\113\064\095\030\065\095\070\065\100\064\113\077\008")
_j34au.Description = ""
_j34au.Visible = false
_j34au.Media = zmediaTask
_j34au.Active = false
_j34au.Complete = false
_j34au.CorrectState = "None"
_DCPGg = Wherigo.ZTask(_cZcj)
_DCPGg.Id = "429541b0-20cd-4f16-8e3d-652773bc8a5f"
_DCPGg.Name = _xaE("\076\070\065\019\113\120\046\065\095\070\065\095\105\110\065\102\064\113\030\105\065\012\089\095\110")
_DCPGg.Description = ""
_DCPGg.Visible = false
_DCPGg.Media = zmediaTask
_DCPGg.Active = false
_DCPGg.Complete = false
_DCPGg.CorrectState = "None"
_EtH = Wherigo.ZTask(_cZcj)
_EtH.Id = "d1a17594-0f5f-4201-9a6d-4b5084831f4d"
_EtH.Name = _xaE("\099\113\087\089\070\065\095\105\110\065\014\064\019\089\095\089\077\008\065\012\027\113\120\110\120\064\113\085\095\065")
_EtH.Description = _xaE("\015\089\087\065\123\070\063\065\008\110\095\065\123\070\063\064\065\064\113\087\089\070\065\085\064\070\093\065\123\070\063\064\065\120\113\064\097\065\023\030\110\065\089\095\065\095\070\065\120\113\117\117\065\095\105\110\065\034\117\089\110\077\065\012\027\113\120\110\030\105\089\027\065\089\077\065\070\064\019\089\095\065\085\070\064\065\085\063\064\095\105\110\064\065\089\077\030\095\064\063\120\095\089\070\077\030\016")
_EtH.Visible = false
_EtH.Media = zmediaTask
_EtH.Active = false
_EtH.Complete = false
_EtH.CorrectState = "None"
_ZtzCV = Wherigo.ZTask(_cZcj)
_ZtzCV.Id = "9fc34265-92f0-4039-addc-d80687b00fb7"
_ZtzCV.Name = _xaE("\005\089\077\087\065\086\123\030\095\110\064\123\065\001\063\093\019\110\064")
_ZtzCV.Description = _xaE("\076\070\065\095\070\065\095\105\110\065\008\089\107\110\077\065\120\070\070\064\087\089\077\113\095\110\030\065\113\077\087\065\085\089\077\087\065\070\063\095\065\088\105\113\095\065\095\105\110\065\093\123\030\095\110\064\123\065\085\070\063\064\065\087\089\008\089\095\065\077\063\093\019\110\064\065\089\030\016")
_ZtzCV.Visible = false
_ZtzCV.Media = zmediaTask
_ZtzCV.Active = false
_ZtzCV.Complete = false
_ZtzCV.CorrectState = "None"
_rS7aS = Wherigo.ZTask(_cZcj)
_rS7aS.Id = "f7e73b70-e032-4e49-9371-ede85ed043cb"
_rS7aS.Name = _xaE("\005\089\077\087\065\086\123\030\095\110\064\123\065\001\063\093\019\110\064\065\052")
_rS7aS.Description = _xaE("\076\070\065\095\070\065\095\105\110\065\008\089\107\110\077\065\117\070\120\113\095\089\070\077\065\113\077\087\065\064\110\095\064\089\110\107\110\065\095\105\110\065\030\110\120\070\077\087\065\093\123\030\095\110\064\123\065\077\063\093\019\110\064\016")
_rS7aS.Visible = false
_rS7aS.Media = zmediaTask
_rS7aS.Active = false
_rS7aS.Complete = false
_rS7aS.CorrectState = "None"
_KRD = Wherigo.ZTask(_cZcj)
_KRD.Id = "c98f38db-7329-4445-9821-e203f9e7cfb3"
_KRD.Name = _xaE("\076\070\065\005\089\077\087\065\061\105\110\065\076\110\070\120\113\120\105\110")
_KRD.Description = _xaE("\076\070\065\008\110\095\065\095\105\089\030\065\076\110\070\120\113\120\105\110\049\049\049")
_KRD.Visible = false
_KRD.Media = zmediaTask
_KRD.Active = false
_KRD.Complete = false
_KRD.CorrectState = "None"

-- Cartridge Variables --
_IOv = _xaE("\015\110\030\046\095\070\027")
_hGR = false
_wzg = false
_tzTPq = 1954
_eKTb = 0
_wKkft = false
_D30 = false
_7W2 = 1993
_oZtMr = ""
_wRx = false
_HrdV = false
_M5C = 0
_P0T8 = false
_xb5I = false
_3yN = false
_RcVW9 = 0
_7OQm = _xaE("\039\034\096\084\011")
_JcdT2 = _xaE("\039\011\033\106")
_jDql = _xaE("\039\089\027\039\027\070")
_F44oq = _xaE("\039\123\005\046")
_YIG = _xaE("\039\114\123\088")
_q17bK = _xaE("\087\063\093\093\123")
_cZcj.ZVariables = {
	_IOv = _xaE("\015\110\030\046\095\070\027"), 
	_hGR = false, 
	_wzg = false, 
	_tzTPq = 1954, 
	_eKTb = 0, 
	_wKkft = false, 
	_D30 = false, 
	_7W2 = 1993, 
	_oZtMr = "", 
	_wRx = false, 
	_HrdV = false, 
	_M5C = 0, 
	_P0T8 = false, 
	_xb5I = false, 
	_3yN = false, 
	_RcVW9 = 0, 
	_7OQm = _xaE("\039\034\096\084\011"), 
	_JcdT2 = _xaE("\039\011\033\106"), 
	_jDql = _xaE("\039\089\027\039\027\070"), 
	_F44oq = _xaE("\039\123\005\046"), 
	_YIG = _xaE("\039\114\123\088"), 
	_q17bK = _xaE("\087\063\093\093\123")
}

-- Timers --

-- Inputs --
_5yw = Wherigo.ZInput(_cZcj)
_5yw.Id = "5e534738-04d8-4632-a1f3-724209bae620"
_5yw.Name = _xaE("\086\123\030\095\110\064\123\065\102\070\087\110")
_5yw.Description = ""
_5yw.Visible = true
_5yw.InputType = "Text"
_5yw.Text = _xaE("\126\077\095\110\064\065\095\105\110\065\086\123\030\095\110\064\123\065\102\070\087\110\127")
_tGl = Wherigo.ZInput(_cZcj)
_tGl.Id = "0cd009ac-bf99-45f2-bfef-739d534b23ab"
_tGl.Name = _xaE("\086\123\030\095\110\064\123\065\102\070\087\110\065\052")
_tGl.Description = ""
_tGl.Visible = true
_tGl.InputType = "Text"
_tGl.Text = _xaE("\126\077\095\110\064\065\095\105\110\065\093\123\030\095\110\064\123\065\120\070\087\110\127")

-- WorksWithList for object commands --

-- functions --
function _cZcj:OnStart()
	_oZtMr = Env.DeviceID
end
function _cZcj:OnRestore()
end
function _vPT__:OnEnter()
	_7OQm = _xaE("\039\107\048\061\039\039")
	_wRx = true
	if _3yN == false then
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\065\105\113\107\110\065\064\110\113\120\105\110\087\065\095\105\110\065\120\064\113\030\105\065\030\089\095\110\016\065\084\070\063\065\095\113\046\110\065\113\065\107\110\064\123\065\120\113\064\110\085\063\117\117\065\117\070\070\046\065\113\064\070\063\077\087\016\065\034\065\030\095\064\113\077\008\110\065\030\093\110\117\117\065\085\089\117\117\030\065\095\105\110\065\113\089\064\016"), 
			Media = zmediaMap, 
			Callback = function(action)
				if action ~= nil then
					_3yN = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					_cZcj:RequestSync()
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\065\113\064\110\065\113\095\065\095\105\110\065\034\117\089\110\077\065\012\027\113\120\110\030\105\089\027\065\120\064\113\030\105\065\030\089\095\110\016"), 
			Media = zmediaMap, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					_cZcj:RequestSync()
				end
			end
		}
	end
end
function _vPT__:OnExit()
	_7OQm = _xaE("\039\107\048\061\039\039")
	_wRx = false
end
function _2F0:OnEnter()
	_7OQm = _xaE("\039\052\005\072")
	_Urwigo.MessageBox{
		Text = _xaE("\084\070\063\065\105\113\107\110\065\064\110\113\120\105\110\087\065\095\105\110\065\113\064\110\113\065\088\105\110\064\110\065\070\077\110\065\070\085\065\095\105\110\065\117\070\030\095\065\027\113\064\095\030\065\089\030\065\030\063\027\027\070\030\110\087\065\095\070\065\019\110\016\065\045\110\095\029\030\065\105\113\107\110\065\113\065\117\070\070\046\065\113\064\070\063\077\087\016"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				_cZcj:RequestSync()
			end
		end
	}
end
function zoneShipPart2:OnEnter()
	_7OQm = _xaE("\116\070\077\110\012\105\089\027\048\113\064\095\052")
	_Urwigo.MessageBox{
		Text = _xaE("\084\070\063\065\105\113\107\110\065\064\110\113\120\105\110\087\065\095\105\110\065\113\064\110\113\065\088\105\110\064\110\065\070\077\110\065\070\085\065\095\105\110\065\117\070\030\095\065\027\113\064\095\030\065\089\030\065\030\063\027\027\070\030\110\087\065\095\070\065\019\110\016\065\045\110\095\029\030\065\105\113\107\110\065\113\065\117\070\070\046\065\113\064\070\063\077\087\016"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				_cZcj:RequestSync()
			end
		end
	}
end
function _ejX:OnEnter()
	_7OQm = _xaE("\039\110\041\022")
	_Urwigo.MessageBox{
		Text = _xaE("\084\070\063\065\105\113\107\110\065\064\110\113\120\105\110\087\065\095\105\110\065\113\064\110\113\065\088\105\110\064\110\065\070\077\110\065\070\085\065\095\105\110\065\117\070\030\095\065\027\113\064\095\030\065\089\030\065\030\063\027\027\070\030\110\087\065\095\070\065\019\110\016\065\045\110\095\029\030\065\105\113\107\110\065\113\065\117\070\070\046\065\113\064\070\063\077\087\016"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				_cZcj:RequestSync()
			end
		end
	}
end
function _N4Yq:OnEnter()
	_7OQm = _xaE("\039\001\011\084\106")
	_Urwigo.MessageBox{
		Text = _xaE("\034\064\070\063\077\087\065\105\110\064\110\065\123\070\063\065\120\113\077\065\085\089\077\087\065\095\105\110\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064\016"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				_D30 = true
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				_cZcj:RequestSync()
			end
		end
	}
end
function _N4Yq:OnExit()
	_7OQm = _xaE("\039\001\011\084\106")
	_D30 = false
end
function _WJZ:OnEnter()
	_7OQm = _xaE("\039\042\017\096")
	_Urwigo.MessageBox{
		Text = _xaE("\045\070\070\046\065\113\064\070\063\077\087\016\016\016\065\012\070\093\110\088\105\110\064\110\065\123\070\063\065\030\105\070\063\117\087\065\030\110\110\065\113\065\085\070\063\064\065\087\089\008\089\095\065\077\063\093\019\110\064\016\016\016"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				_tCsJZ:MoveTo(_WJZ)
				_hGR = true
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				_cZcj:RequestSync()
			end
		end
	}
end
function _LAyl:OnEnter()
	_7OQm = _xaE("\039\045\034\123\117")
	_zv4YR.Visible = true
	_zv4YR:MoveTo(Player)
	_Urwigo.MessageBox{
		Text = _xaE("\084\070\063\065\113\064\110\065\107\110\064\123\065\077\110\113\064\016\065\034\065\012\027\070\089\117\110\064\065\027\089\120\095\063\064\110\065\120\113\077\065\019\110\065\085\070\063\077\087\065\089\077\065\123\070\063\064\065\089\077\107\110\077\095\070\064\123\016"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				_cZcj:RequestSync()
			end
		end
	}
end
function _q_Z1d:OnEnter()
	_7OQm = _xaE("\039\106\039\096\056\087")
	_Urwigo.MessageBox{
		Text = _xaE("\045\070\070\046\065\113\064\070\063\077\087\016\016\016\065\012\070\093\110\088\105\110\064\110\065\123\070\063\065\030\105\070\063\117\087\065\030\110\110\065\113\065\085\070\063\064\065\087\089\008\089\095\065\077\063\093\019\110\064\016\016\016"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				_tCsJZ:MoveTo(_q_Z1d)
				_HrdV = true
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				_cZcj:RequestSync()
			end
		end
	}
end
function _5yw:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_eKTb = tonumber(input)
	if _tzTPq == _eKTb then
		_AZY4.Active = false
		_vPT__.Active = false
		_WJZ.Active = false
		_AZY4.Visible = false
		_vPT__.Visible = false
		_WJZ.Visible = false
		_ZtzCV.Complete = true
		_ZtzCV.Visible = false
		_ZtzCV.Active = false
		_Urwigo.MessageBox{
			Text = _xaE("\042\070\088\049\049\049\065\083\095\065\089\030\065\087\070\063\019\117\110\065\120\070\087\110\087\049\065\083\065\088\089\117\117\065\077\110\110\087\065\113\065\030\110\120\070\077\087\065\093\123\030\095\110\064\123\065\120\070\087\110\065\095\070\065\019\064\110\113\046\065\095\105\089\030\065\120\123\027\105\110\064\049\065\076\070\070\087\065\095\105\089\077\008\065\083\065\046\077\070\088\065\088\105\110\064\110\065\123\070\063\065\120\113\077\065\085\089\077\087\065\089\095\049\065\083\065\113\093\065\063\027\117\070\113\087\089\077\008\065\095\105\110\065\120\070\070\064\087\089\077\113\095\110\030\065\095\070\065\123\070\063\064\065\087\110\107\089\120\110\049\065\076\070\065\085\089\077\087\065\095\105\110\065\030\110\120\070\077\087\065\093\123\030\095\110\064\123\065\077\063\093\019\110\064\049\065\042\105\110\077\065\123\070\063\065\085\089\077\087\065\095\105\110\065\120\070\087\110\065\120\113\117\117\065\093\110\065\019\113\120\046\049"), 
			Media = zmediaSpaceCraftinOrbit, 
			Callback = function(action)
				if action ~= nil then
					_q_Z1d.Visible = true
					_q_Z1d.Active = true
					_rS7aS.Active = true
					_rS7aS.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _xaE("\001\014\049\065\061\009\083\012\065\001\023\086\007\126\099\065\083\012\065\001\014\061\065\102\014\099\099\126\102\061\049\065\061\099\084\065\034\076\034\083\001\049"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_5yw)
					end)
				end
			end
		}
	end
end
function _tGl:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_RcVW9 = tonumber(input)
	if _7W2 == _RcVW9 then
		_Urwigo.MessageBox{
			Text = _xaE("\084\063\027\110\110\049\049\049\065\083\095\065\088\070\064\046\110\087\049\065\061\105\110\065\027\063\116\116\117\110\065\089\030\065\030\070\117\107\110\087\049\065\083\065\113\093\065\063\027\117\070\113\087\089\077\008\065\095\105\110\065\085\089\077\113\117\065\120\070\070\064\087\089\077\113\095\110\030\065\095\070\065\123\070\063\064\065\087\110\107\089\120\110\049\065\102\105\110\120\046\065\123\070\063\064\065\089\077\107\110\077\095\070\064\123\049\065\076\070\070\087\065\117\063\120\046\065\126\113\064\095\105\117\089\077\008\049"), 
			Media = zmediaSpaceCraftinOrbit, 
			Callback = function(action)
				if action ~= nil then
					_WFC:MoveTo(Player)
					_rS7aS.Complete = true
					_rS7aS.Visible = false
					_rS7aS.Active = false
					_KRD.Active = true
					_KRD.Visible = true
					_WFC.Visible = true
					_q_Z1d.Active = false
					_q_Z1d.Visible = false
					_uFEK:MoveTo(nil)
					_mRxqq:MoveTo(nil)
					_YdN:MoveTo(nil)
					_TgNo:MoveTo(nil)
					_LAyl.Active = true
					_LAyl.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _xaE("\001\014\049\065\061\009\083\012\065\001\023\086\007\126\099\065\083\012\065\001\014\061\065\102\014\099\099\126\102\061\049\065\061\099\084\065\034\076\034\083\001\049"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_tGl)
					end)
				end
			end
		}
	end
end
function _46q:On_WUm3(target)
	_Ga713.Complete = true
	_Ga713.Visible = false
	_BzSn9.Active = true
	_BzSn9.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _xaE("\009\110\117\117\070\065\126\113\064\095\105\117\089\077\008\049\065\083\065\113\093\065\100\064\113\095\105\065\085\064\070\093\065\095\105\110\065\034\120\105\110\064\070\077\065\012\123\030\095\110\093\049\065\083\065\120\070\093\110\065\089\077\065\027\110\113\120\110\016\016\016"), 
			Media = zmediaAlienGeocacher
		}, 
		{
			Text = _xaE("\009\105\105\110\117\117\070\049\065\083\029\093\016\016\016\065\083\065\113\093\065\113\065\008\110\070\120\113\120\105\110\064\016\016\016\065\083\016\016\016\065\083\016\016\016"), 
			Media = zmediaGeocacher
		}, 
		{
			Text = _xaE("\083\065\120\113\077\065\030\110\110\065\095\105\113\095\049\065\032\065\100\064\113\095\105\065\117\113\063\008\105\110\087\016\018\007\099\104\032\065\083\065\113\093\065\113\065\008\110\070\120\113\105\110\064\065\093\123\030\110\117\085\049\065\034\117\113\030\065\077\070\095\065\095\070\070\065\117\063\120\046\123\065\095\070\087\113\123\016"), 
			Media = zmediaAlienGeocacher
		}, 
		{
			Text = _xaE("\042\105\123\065\088\105\113\095\065\105\113\027\027\110\077\110\087\097"), 
			Media = zmediaGeocacher
		}, 
		{
			Text = _xaE("\086\123\065\085\064\089\110\077\087\065\105\110\064\110\065\032\065\100\064\113\077\008\065\089\030\065\113\065\107\110\064\123\065\008\070\070\087\065\093\110\120\105\113\077\089\120\065\019\063\095\065\113\065\117\070\063\030\123\065\027\089\117\070\095\016\016\016\065\086\113\123\019\110\065\095\105\113\095\029\030\065\088\105\123\065\105\110\065\089\030\065\030\063\120\105\065\113\065\008\070\070\087\065\093\110\120\105\113\077\089\120\065\113\085\095\110\064\065\113\117\117\016\016\016\065\083\077\065\030\105\070\064\095\065\095\070\087\113\123\065\105\110\065\120\064\113\030\105\110\087\065\089\077\095\070\065\095\105\110\065\095\064\110\110\030\065\113\008\113\089\077\065\113\077\087\065\088\110\065\117\070\030\095\065\030\070\093\110\065\027\113\064\095\030\065\070\085\065\070\063\064\065\030\105\089\027\016\065\001\070\088\065\088\110\065\077\110\110\087\065\095\070\065\030\110\113\064\120\105\065\085\070\064\065\095\105\110\093\016\065\042\089\117\117\065\123\070\063\065\105\110\117\027\065\063\030\097"), 
			Media = zmediaAlienGeocacher
		}, 
		{
			Text = _xaE("\012\063\064\110\065\083\065\088\089\117\117\049\065\007\063\095\065\095\105\110\065\027\113\064\046\065\089\030\065\105\063\008\110\065\105\070\088\065\120\113\077\065\088\110\065\085\089\077\087\065\095\105\070\030\110\065\027\113\064\095\030\097"), 
			Media = zmediaGeocacher
		}, 
		{
			Text = _xaE("\083\065\105\113\107\110\065\113\077\065\089\087\110\113\065\088\105\110\064\110\065\095\105\110\123\065\093\089\008\105\095\065\019\110\016\016\016\065\076\089\107\110\065\093\110\065\123\070\063\064\065\093\113\027\065\083\065\088\089\117\117\065\027\070\089\077\095\065\095\105\110\065\120\070\070\064\087\089\077\113\095\110\030\065\095\070\065\123\070\063\016\065"), 
			Media = zmediaAlienGeocacher
		}, 
		{
			Text = _xaE("\042\110\117\117\065\095\105\113\095\029\030\065\113\065\027\089\110\120\110\065\070\085\065\120\113\046\110\049\065\084\070\063\065\030\095\113\123\065\105\089\087\087\110\077\065\105\110\064\110\049\065\001\070\065\093\063\008\008\117\110\065\030\105\070\063\117\087\065\030\110\110\065\123\070\063\049\065\083\065\088\089\117\117\065\064\063\077\065\106\063\089\120\046\117\123\065\113\077\087\065\085\110\095\120\105\065\095\105\110\065\027\113\064\095\030\065\085\070\064\065\123\070\063\049\049\049"), 
			Media = zmediaGeocacher
		}
	}, function(action)
		_Ga713.Visible = false
		_46q.Visible = false
		_2F0.Active = true
		_2F0.Visible = true
		zoneShipPart2.Active = true
		zoneShipPart2.Visible = true
		_ejX.Active = true
		_ejX.Visible = true
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _zu5:On_DGJ(target)
	if ((not _zu5:Contains(_72cpo)) or (not _zu5:Contains(_v4DA))) or (not _zu5:Contains(__kUY7)) then
		_Urwigo.MessageBox{
			Text = _xaE("\015\089\087\065\123\070\063\065\085\089\077\087\065\113\117\117\065\095\105\064\110\110\065\093\089\030\030\089\077\008\065\027\113\064\095\030\097\065\076\089\107\110\065\095\105\110\093\065\095\070\065\093\110\049"), 
			Media = zmediaAlienMechanic, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
				end
			end
		}
	else
		_Urwigo.Dialog(false, {
			{
				Text = _xaE("\084\070\063\029\107\110\065\087\070\077\110\065\113\065\008\064\110\113\095\065\041\070\019\049\065\014\077\117\123\016\016\016\065\095\105\110\064\110\065\089\030\065\113\077\070\095\105\110\064\065\027\064\070\019\117\110\093\016\065\042\110\065\113\064\110\065\093\089\030\030\089\077\008\065\070\063\064\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064\016\065\061\105\110\065\008\070\070\087\065\077\110\088\030\065\089\030\065\083\065\089\077\095\110\064\120\110\027\095\110\087\065\089\095\030\065\120\070\070\064\087\089\077\113\095\110\030\016\065\042\089\117\117\065\123\070\063\065\008\110\095\065\089\095\065\085\070\064\065\093\110\097"), 
				Media = zmediaAlienMechanic
			}, 
			{
				Text = _xaE("\007\063\095\065\070\085\065\120\070\063\064\030\110\049\065\076\089\107\110\065\093\110\065\095\105\110\065\120\070\070\064\087\089\077\113\095\110\030\049"), 
				Media = zmediaGeocacher
			}, 
			{
				Text = _xaE("\009\110\064\110\016\016\016\065\007\063\095\065\088\113\089\095\065\113\065\093\089\077\063\095\110\049\065\083\085\065\095\105\110\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064\065\089\030\065\030\095\089\117\117\065\070\027\110\064\113\095\089\070\077\113\117\065\089\095\065\093\089\008\105\095\065\019\110\065\087\113\077\008\110\064\070\063\030\065\095\070\065\105\113\077\087\117\110\016\065\084\070\063\065\088\089\117\117\065\105\113\107\110\065\095\070\065\087\089\030\110\077\008\113\008\110\065\089\095\065\085\089\064\030\095\049\049\049"), 
				Media = zmediaAlienMechanic
			}, 
			{
				Text = _xaE("\009\070\088\065\087\070\065\083\065\087\070\065\095\105\113\095\097"), 
				Media = zmediaGeocacher
			}, 
			{
				Text = _xaE("\061\113\046\110\065\093\123\065\030\027\110\120\089\113\117\065\095\070\070\117\065\113\077\087\065\063\030\110\065\089\095\065\095\070\065\087\089\030\110\077\008\113\008\110\065\095\105\110\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064\016"), 
				Media = zmediaAlienMechanic
			}
		}, function(action)
			_sL6t.Visible = true
			_j34au.Visible = false
			_j34au.Complete = true
			_G54iE.Visible = true
			_zu5.Commands._DGJ.Enabled = false
			_N4Yq.Active = true
			_N4Yq.Visible = true
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	end
end
function _IKhw:On_fhJM(target)
	if not _IKhw:Contains(zitemDisabledFluxCapacitor) then
		_Urwigo.MessageBox{
			Text = _xaE("\086\123\065\093\110\120\105\113\077\089\120\065\089\030\065\113\117\117\093\070\030\095\065\064\110\113\087\123\016\065\009\110\065\105\113\030\065\095\070\065\085\089\047\065\041\063\030\095\065\095\105\110\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064\016\065\015\089\087\065\123\070\063\065\085\089\077\087\065\089\095\097"), 
			Media = zmediaAlienGeocacher, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
				end
			end
		}
	else
		_Urwigo.Dialog(false, {
			{
				Text = _xaE("\084\070\063\065\105\113\107\110\065\087\070\077\110\065\113\065\008\064\110\113\095\065\041\070\019\091\065\019\063\087\087\123\049\065\083\065\087\070\077\029\095\065\046\077\070\088\065\105\070\088\065\095\070\065\064\110\088\113\064\087\065\123\070\063\065\085\070\064\065\123\070\063\064\065\110\085\085\070\064\095\030\016\016\016"), 
				Media = zmediaAlienGeocacher
			}, 
			{
				Text = _xaE("\042\110\117\117\091\065\089\095\065\088\113\030\065\077\070\095\105\089\077\008\065\064\110\113\117\117\123\016\065\083\065\113\093\065\008\117\113\087\065\083\065\120\070\063\117\087\065\105\110\117\027\049"), 
				Media = zmediaGeocacher
			}, 
			{
				Text = _xaE("\042\113\089\095\049\065\083\065\046\077\070\088\065\088\105\113\095\065\095\070\065\087\070\049\065\042\110\065\120\113\093\110\065\105\110\064\110\065\095\070\065\093\113\046\110\065\113\065\005\061\005\065\070\085\065\008\110\070\120\113\120\105\110\016\065\001\070\088\065\095\105\110\065\005\061\005\065\089\030\065\123\070\063\064\030\049\049\049"), 
				Media = zmediaAlienGeocacher
			}, 
			{
				Text = _xaE("\042\070\088\049\065\061\105\113\077\046\065\123\070\063\065\030\070\065\093\063\120\105\049\065\007\063\095\065\088\105\089\120\105\065\120\113\120\105\110\065\089\030\065\095\105\113\095\097\065\083\065\087\070\077\029\095\065\105\113\107\110\065\089\095\065\070\077\065\093\123\065\093\113\027\049"), 
				Media = zmediaGeocacher
			}, 
			{
				Text = _xaE("\083\095\065\089\030\065\077\070\095\065\027\063\019\117\089\030\105\110\087\065\123\110\095\065\070\077\065\126\113\064\095\105\029\030\065\008\110\070\120\113\120\105\089\077\008\065\030\089\095\110\016\065\083\065\120\113\077\065\008\089\107\110\065\123\070\063\065\095\105\110\065\120\070\070\064\087\089\077\113\095\110\030\091\065\019\063\095\065\083\065\088\089\117\117\065\077\110\110\087\065\113\065\030\110\120\064\110\095\065\120\070\087\110\016\065\061\070\065\027\064\070\120\110\030\030\065\095\105\110\065\120\070\087\110\065\088\110\065\088\089\117\117\065\105\113\107\110\065\095\070\065\008\070\065\089\077\065\027\117\113\077\110\095\113\064\123\065\070\064\019\089\095\065\113\030\065\088\110\065\105\113\107\110\065\077\070\065\120\070\077\077\110\120\095\089\070\077\065\088\089\095\105\065\070\063\064\065\012\123\030\095\110\093\029\030\065\086\113\089\077\085\064\113\093\110\065\120\070\093\027\063\095\110\064\065\105\110\064\110\016\065\014\100\091\065\077\070\088\065\088\110\065\095\113\046\110\065\070\085\085\065\113\077\087\065\088\110\065\088\089\117\117\065\120\070\093\093\063\077\089\120\113\095\110\065\019\123\065\064\113\087\089\070\016"), 
				Media = zmediaAlienGeocacher
			}, 
			{
				Text = _xaE("\076\070\070\087\065\019\123\110\065\093\123\065\113\117\089\110\077\065\085\064\089\110\077\087\049\065\009\070\027\110\065\083\029\117\117\065\030\110\110\065\123\070\063\065\113\008\113\089\077\065\030\070\093\110\065\087\113\123\049"), 
				Media = zmediaGeocacher
			}, 
			{
				Text = _xaE("\009\110\064\110\065\095\113\046\110\065\093\123\065\113\117\089\110\077\065\012\042\034\076\049\065\005\113\064\110\088\110\117\117\065\126\113\064\095\105\117\089\077\008\049"), 
				Media = zmediaAlienGeocacher
			}
		}, function(action)
			_DCPGg.Complete = true
			_DCPGg.Visible = false
			_IKhw.Visible = false
			_tCsJZ:MoveTo(_vPT__)
			_tCsJZ.Visible = true
			_0jJzh.Visible = true
			_0jJzh:MoveTo(Player)
			_EtH.Visible = true
			_EtH.Active = true
			_wzg = true
			Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
		end)
	end
end
function _ip_po:On_ERS(target)
	_Urwigo.MessageBox{
		Text = _xaE("\084\070\063\064\065\008\070\070\087\065\070\117\087\065\120\113\064\016\065\034\065\095\064\063\030\095\123\065\093\070\019\089\117\089\095\123\065\087\110\107\089\120\110\065\095\070\065\105\110\117\027\065\123\070\063\065\095\064\113\107\110\117\065\089\077\065\030\110\113\064\120\105\065\085\070\064\065\008\110\070\120\113\120\105\110\030\016"), 
		Media = zmediaCar, 
		Callback = function(action)
			_uFEK.Visible = true
			_mRxqq.Visible = true
			_YdN.Visible = true
			_yFk.Active = true
			_yFk.Visible = true
			_TgNo.Commands._YgKwt.Enabled = true
			_ip_po.Commands._ERS.Enabled = false
			Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
		end
	}
end
function _uFEK:On_XkrHw(target)
	if not Player:Contains(_uFEK) then
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\064\065\088\070\064\046\089\077\008\065\008\117\070\107\110\030\016\065\125\110\064\123\065\063\030\110\085\063\117\065\095\070\065\105\113\077\087\117\110\065\030\063\030\027\089\120\089\070\063\030\065\070\019\041\110\120\095\030\016\065\083\064\064\110\027\117\113\120\110\113\019\117\110\065\088\105\110\077\065\087\070\089\077\008\065\102\083\061\014\016"), 
			Media = zmediaGloves, 
			Buttons = {
				_xaE("\061\034\100\126"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_uFEK:MoveTo(Player)
						Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
					end
				end
			end
		}
	elseif _xb5I == false then
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\064\065\088\070\064\046\089\077\008\065\008\117\070\107\110\030\016\065\125\110\064\123\065\063\030\110\085\063\117\065\095\070\065\105\113\077\087\117\110\065\030\063\030\027\089\120\089\070\063\030\065\070\019\041\110\120\095\030\016\065\083\064\064\110\027\117\113\120\110\113\019\117\110\065\088\105\110\077\065\087\070\089\077\008\065\102\083\061\014\016"), 
			Media = zmediaGloves, 
			Buttons = {
				_xaE("\048\023\061\065\014\001"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_xb5I = true
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					elseif action == "Button2" then
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\064\065\088\070\064\046\089\077\008\065\008\117\070\107\110\030\016\065\125\110\064\123\065\063\030\110\085\063\117\065\095\070\065\105\113\077\087\117\110\065\030\063\030\027\089\120\089\070\063\030\065\070\019\041\110\120\095\030\016\065\083\064\064\110\027\117\113\120\110\113\019\117\110\065\088\105\110\077\065\087\070\089\077\008\065\102\083\061\014\016"), 
			Media = zmediaGloves, 
			Buttons = {
				_xaE("\061\034\100\126\065\014\005\005"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_xb5I = false
					elseif action == "Button2" then
					end
				end
			end
		}
	end
end
function _mRxqq:On_9w1j6(target)
	if not Player:Contains(_mRxqq) then
		_Urwigo.MessageBox{
			Text = _xaE("\034\065\027\070\064\095\113\019\117\110\065\064\113\087\089\070\016\065\084\070\063\065\120\113\077\065\063\030\110\065\089\095\065\095\070\065\095\113\117\046\065\095\070\065\070\095\105\110\064\065\064\113\087\089\070\065\070\027\110\064\113\095\070\064\030\016"), 
			Media = zmediaWalkieTalkie, 
			Buttons = {
				_xaE("\061\034\100\126"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_mRxqq:MoveTo(Player)
						Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
					else
						Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
					end
				end
			end
		}
	elseif _wzg == true then
		if _ZtzCV.Active then
			if _hGR == true then
				_Urwigo.MessageBox{
					Text = _xaE("\084\070\063\064\065\027\070\064\095\113\019\117\110\065\064\113\087\089\070\016\065\023\030\110\065\089\095\065\095\070\065\120\070\093\093\063\077\089\120\113\095\110\065\095\070\065\070\095\105\110\064\065\064\113\087\089\070\065\070\027\110\064\113\095\070\064\030\016"), 
					Media = zmediaWalkieTalkie, 
					Buttons = {
						_xaE("\102\034\045\045\065\100\099\034\061\009"), 
						_xaE("\001\014\061\065\001\014\042")
					}, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _xaE("\015\089\087\065\123\070\063\065\085\089\077\087\065\061\105\110\065\086\123\030\095\110\064\123\065\001\063\093\019\110\064\097"), 
								Media = zmediaSpaceCraftinOrbit, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(_5yw)
										end)
									end
								end
							}
						end
					end
				}
			else
				_Urwigo.MessageBox{
					Text = _xaE("\084\070\063\064\065\027\070\064\095\113\019\117\110\065\064\113\087\089\070\016\065\023\030\110\065\089\095\065\095\070\065\120\070\093\093\063\077\089\120\113\095\110\065\095\070\065\070\095\105\110\064\065\064\113\087\089\070\065\070\027\110\064\113\095\070\064\030\016\065\102\113\117\117\065\019\113\120\046\065\100\064\113\095\105\065\088\105\110\077\065\123\070\063\065\085\089\077\087\065\095\105\110\065\093\123\030\095\110\064\123\065\077\063\093\019\110\064\016"), 
					Media = zmediaWalkieTalkie
				}
			end
		elseif _rS7aS.Active then
			if _HrdV == true then
				_Urwigo.MessageBox{
					Text = _xaE("\084\070\063\064\065\027\070\064\095\113\019\117\110\065\064\113\087\089\070\016\065\023\030\110\065\089\095\065\095\070\065\120\070\093\093\063\077\089\120\113\095\110\065\095\070\065\070\095\105\110\064\065\064\113\087\089\070\065\070\027\110\064\113\095\070\064\030\016"), 
					Media = zmediaWalkieTalkie, 
					Buttons = {
						_xaE("\102\034\045\045\065\100\099\034\061\009"), 
						_xaE("\001\014\061\065\001\014\042")
					}, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _xaE("\015\089\087\065\123\070\063\065\085\089\077\087\065\061\105\110\065\012\110\120\070\077\087\065\086\123\030\095\110\064\123\065\001\063\093\019\110\064\097"), 
								Media = zmediaSpaceCraftinOrbit, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(_tGl)
										end)
									end
								end
							}
						end
					end
				}
			else
				_Urwigo.MessageBox{
					Text = _xaE("\084\070\063\064\065\027\070\064\095\113\019\117\110\065\064\113\087\089\070\016\065\023\030\110\065\089\095\065\095\070\065\120\070\093\093\063\077\089\120\113\095\110\065\095\070\065\070\095\105\110\064\065\064\113\087\089\070\065\070\027\110\064\113\095\070\064\030\016\065\102\113\117\117\065\019\113\120\046\065\100\064\113\095\105\065\088\105\110\077\065\123\070\063\065\085\089\077\087\065\095\105\110\065\030\110\120\070\077\087\065\093\123\030\095\110\064\123\065\077\063\093\019\110\064\016"), 
					Media = zmediaWalkieTalkie
				}
			end
		else
			_Urwigo.MessageBox{
				Text = _xaE("\084\070\063\064\065\027\070\064\095\113\019\117\110\065\064\113\087\089\070\016\065\023\030\110\065\089\095\065\095\070\065\120\070\093\093\063\077\089\120\113\095\110\065\095\070\065\070\095\105\110\064\065\064\113\087\089\070\065\070\027\110\064\113\095\070\064\030\016"), 
				Media = zmediaWalkieTalkie, 
				Buttons = {
					_xaE("\102\034\045\045\065\100\099\034\061\009"), 
					_xaE("\001\014\061\065\001\014\042")
				}, 
				Callback = function(action)
					if action ~= nil then
						_ZtzCV.Visible = true
						_ZtzCV.Active = true
						_Urwigo.Dialog(false, {
							{
								Text = _xaE("\007\116\116\116\116\095\016\016\016\065\009\070\088\065\087\070\065\123\070\063\065\064\110\113\087\065\093\110\065\126\113\064\095\105\117\089\077\008\097"), 
								Media = zmediaAlienGeocacher
							}, 
							{
								Text = _xaE("\045\070\063\087\065\113\077\087\065\120\117\110\113\064\049\065\076\070\065\113\105\110\113\087\049"), 
								Media = zmediaGeocacher
							}, 
							{
								Text = _xaE("\034\117\117\065\064\089\008\105\095\049\065\083\065\113\093\065\063\027\117\070\113\087\089\077\008\065\095\070\065\123\070\063\064\065\087\110\107\089\120\110\065\095\105\110\065\120\070\070\064\087\089\077\113\095\110\030\065\070\085\065\095\105\110\065\027\117\113\120\110\065\088\105\110\064\110\065\123\070\063\065\120\113\077\065\085\089\077\087\065\095\105\110\065\086\123\030\095\110\064\123\065\102\070\087\110\016\065\042\105\110\077\065\123\070\063\065\085\089\077\087\065\095\105\110\065\120\070\087\110\065\120\113\117\117\065\093\110\065\019\113\120\046\049"), 
								Media = zmediaAlienGeocacher
							}
						}, function(action)
							_WJZ.Active = true
							_WJZ.Visible = true
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end)
					end
				end
			}
		end
	else
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\064\065\027\070\064\095\113\019\117\110\065\064\113\087\089\070\016\065\023\030\110\065\089\095\065\095\070\065\120\070\093\093\063\077\089\120\113\095\110\065\095\070\065\070\095\105\110\064\065\064\113\087\089\070\065\070\027\110\064\113\095\070\064\030\016"), 
			Media = zmediaWalkieTalkie
		}
	end
end
function _YdN:On_kgY(target)
	if not Player:Contains(_YdN) then
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\064\065\030\063\077\008\117\113\030\030\110\030\016\065\042\110\113\064\089\077\008\065\095\105\110\093\065\088\089\117\117\065\027\064\070\095\110\120\095\065\123\070\063\064\065\110\123\110\030\016"), 
			Media = zmediaSunglasses, 
			Buttons = {
				_xaE("\061\034\100\126"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_YdN:MoveTo(Player)
						Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
					end
				end
			end
		}
	elseif _wKkft == false then
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\064\065\030\063\077\008\117\113\030\030\110\030\065\027\064\070\095\110\120\095\065\123\070\063\064\065\110\123\110\030\065\085\064\070\093\065\095\105\110\065\019\064\089\008\105\095\065\030\063\077\117\089\008\105\095\016"), 
			Media = zmediaSunglasses, 
			Buttons = {
				_xaE("\048\023\061\065\014\001"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_wKkft = true
					elseif action == "Button2" then
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\065\117\070\070\046\065\107\110\064\123\065\120\070\070\117\065\088\089\095\105\065\123\070\063\064\065\030\063\077\008\117\113\030\030\110\030\016\065\034\077\087\065\123\070\063\064\065\110\123\110\030\065\113\064\110\065\027\064\070\095\110\120\095\110\087\016"), 
			Media = zmediaSunglasses, 
			Buttons = {
				_xaE("\061\034\100\126\065\014\005\005"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_wKkft = false
					elseif action == "Button2" then
					end
				end
			end
		}
	end
end
function _XZ9s:On_fIP(target)
	_Urwigo.MessageBox{
		Text = _xaE("\084\070\063\065\030\095\113\077\087\065\027\110\064\027\117\110\047\110\087\049\049\049\065\099\089\008\105\095\065\019\110\085\070\064\110\065\123\070\063\064\065\107\110\064\123\065\110\123\110\030\065\095\105\110\064\110\065\089\030\065\113\065\030\093\113\117\117\065\113\117\089\110\077\065\030\027\113\120\110\120\064\113\085\095\049\065\084\070\063\065\113\064\110\065\093\070\095\089\070\077\117\110\030\030\065\085\070\064\065\113\065\120\070\063\027\117\110\065\070\085\065\093\089\077\063\095\110\030\016\065\061\105\110\077\065\030\063\087\087\110\077\117\123\065\123\070\063\065\105\110\113\064\065\113\065\117\070\088\065\105\089\030\030\089\077\008\065\107\070\089\120\110\065\120\070\093\089\077\008\065\085\064\070\093\065\019\110\105\089\077\087\016\018\007\099\104\032\065\009\110\123\065\126\113\064\095\105\117\089\077\008\049\018\007\099\104\084\070\063\065\030\117\070\088\117\123\065\095\063\064\077\065\113\064\070\063\077\087\091\065\095\105\110\065\019\117\070\070\087\065\085\064\070\116\110\077\065\089\077\065\123\070\063\064\065\107\110\089\077\030\049"), 
		Media = zmediaFlyingSaucer, 
		Callback = function(action)
			if action ~= nil then
				_46q.Visible = true
				_XZ9s.Visible = false
				_Ga713.Visible = false
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _72cpo:On_JN00j(target)
	if not Player:Contains(_72cpo) then
		_Urwigo.MessageBox{
			Text = _xaE("\012\095\064\113\077\008\110\065\117\070\070\046\089\077\008\065\008\113\087\008\110\095\049\065\015\110\085\089\077\089\095\110\117\123\065\113\117\089\110\077\065\070\085\065\070\064\089\008\089\077\016\065\083\095\029\065\093\063\030\095\065\019\110\065\095\105\110\065\093\089\030\030\089\077\008\065\027\113\064\095\049"), 
			Media = zmediaSpaceshipPart1, 
			Buttons = {
				_xaE("\061\034\100\126"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_72cpo:MoveTo(Player)
						_M5C = _M5C + 1
						_2F0.Visible = false
						_2F0.Active = false
						if _M5C == 3 then
							_Urwigo.MessageBox{
								Text = _xaE("\084\070\063\065\105\113\107\110\065\085\070\063\077\087\065\113\117\117\065\095\105\064\110\110\065\093\089\030\030\089\077\008\065\027\113\064\095\030\016\065\061\113\046\110\065\095\105\110\093\065\095\070\065\100\064\113\077\008\065\095\105\110\065\093\110\120\105\113\077\089\120\016"), 
								Media = zmediaTask, 
								Callback = function(action)
									if action ~= nil then
										_j34au.Active = true
										_j34au.Visible = true
										_BzSn9.Visible = false
										_BzSn9.Complete = true
										_zu5.Visible = true
										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									end
								end
							}
						else
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			end
		}
	elseif _wRx == true then
		_Urwigo.MessageBox{
			Text = _xaE("\045\070\030\095\065\030\027\113\120\110\030\105\089\027\065\027\113\064\095\016"), 
			Media = zmediaSpaceshipPart1, 
			Buttons = {
				_xaE("\076\083\125\126\065\061\014\065\100\099\034\001\076"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_72cpo:MoveTo(_zu5)
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _xaE("\014\077\110\065\070\085\065\095\105\110\065\117\070\030\095\065\030\027\113\120\110\065\030\105\089\027\065\027\113\064\095\030\016"), 
			Media = zmediaSpaceshipPart1, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _v4DA:On_RGe(target)
	if not Player:Contains(_v4DA) then
		_Urwigo.MessageBox{
			Text = _xaE("\012\095\064\113\077\008\110\065\117\070\070\046\089\077\008\065\008\113\087\008\110\095\049\065\015\110\085\089\077\089\095\110\117\123\065\113\117\089\110\077\065\070\085\065\070\064\089\008\089\077\016\065\083\095\029\065\093\063\030\095\065\019\110\065\095\105\110\065\093\089\030\030\089\077\008\065\027\113\064\095\049"), 
			Media = zmediaSpaceshipPart2, 
			Buttons = {
				_xaE("\061\034\100\126"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if (action == "Button1") and (_xb5I == true) then
						_v4DA:MoveTo(Player)
						_M5C = _M5C + 1
						zoneShipPart2.Visible = false
						zoneShipPart2.Active = false
						if _M5C == 3 then
							_Urwigo.MessageBox{
								Text = _xaE("\084\070\063\065\105\113\107\110\065\085\070\063\077\087\065\113\117\117\065\095\105\064\110\110\065\093\089\030\030\089\077\008\065\027\113\064\095\030\016\065\061\113\046\110\065\095\105\110\093\065\095\070\065\100\064\113\077\008\065\095\105\110\065\093\110\120\105\113\077\089\120\016"), 
								Media = zmediaTask, 
								Callback = function(action)
									if action ~= nil then
										_j34au.Active = true
										_j34au.Visible = true
										_BzSn9.Visible = false
										_BzSn9.Complete = true
										_zu5.Visible = true
										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									end
								end
							}
						else
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					elseif (action == "Button1") and (_xb5I == false) then
						_Urwigo.MessageBox{
							Text = _xaE("\042\070\088\049\065\061\105\089\030\065\095\105\089\077\008\065\117\070\070\046\030\065\105\070\095\049\065\084\070\063\065\093\089\008\105\095\065\019\063\064\077\065\123\070\063\064\065\105\113\077\087\030\049\049\049\065\084\070\063\065\027\063\095\065\123\070\063\064\065\088\070\064\046\089\077\008\065\008\117\070\107\110\030\065\089\077\065\123\070\063\064\065\120\113\064\065\089\077\065\095\105\110\065\093\070\064\077\089\077\008\091\065\087\089\087\029\095\065\123\070\063\097"), 
							Media = zmediaSpaceshipPart2, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
								end
							end
						}
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			end
		}
	elseif _wRx == true then
		_Urwigo.MessageBox{
			Text = _xaE("\045\070\030\095\065\030\027\113\120\110\030\105\089\027\065\027\113\064\095\016"), 
			Media = zmediaSpaceshipPart2, 
			Buttons = {
				_xaE("\076\083\125\126\065\061\014\065\100\099\034\001\076"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_v4DA:MoveTo(_zu5)
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _xaE("\014\077\110\065\070\085\065\095\105\110\065\117\070\030\095\065\030\027\113\120\110\065\030\105\089\027\065\027\113\064\095\030\016"), 
			Media = zmediaSpaceshipPart2
		}
	end
end
function __kUY7:On_Uemk(target)
	if not Player:Contains(__kUY7) then
		_Urwigo.MessageBox{
			Text = _xaE("\012\095\064\113\077\008\110\065\117\070\070\046\089\077\008\065\008\113\087\008\110\095\049\065\015\110\085\089\077\089\095\110\117\123\065\113\117\089\110\077\065\070\085\065\070\064\089\008\089\077\016\065\083\095\029\065\093\063\030\095\065\019\110\065\095\105\110\065\093\089\030\030\089\077\008\065\027\113\064\095\049"), 
			Media = zmediaSpaceshipPart3, 
			Buttons = {
				_xaE("\061\034\100\126"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						__kUY7:MoveTo(Player)
						_M5C = _M5C + 1
						_ejX.Visible = false
						_ejX.Active = false
						if _M5C == 3 then
							_Urwigo.MessageBox{
								Text = _xaE("\084\070\063\065\105\113\107\110\065\085\070\063\077\087\065\113\117\117\065\095\105\064\110\110\065\093\089\030\030\089\077\008\065\027\113\064\095\030\016\065\061\113\046\110\065\095\105\110\093\065\095\070\065\100\064\113\077\008\065\095\105\110\065\093\110\120\105\113\077\089\120\016"), 
								Media = zmediaTask, 
								Callback = function(action)
									if action ~= nil then
										_j34au.Active = true
										_j34au.Visible = true
										_BzSn9.Visible = false
										_BzSn9.Complete = true
										_zu5.Visible = true
										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									end
								end
							}
						else
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
					end
				end
			end
		}
	elseif _wRx == true then
		_Urwigo.MessageBox{
			Text = _xaE("\045\070\030\095\065\030\027\113\120\110\030\105\089\027\065\027\113\064\095\016"), 
			Media = zmediaSpaceshipPart3, 
			Buttons = {
				_xaE("\076\083\125\126\065\061\014\065\100\099\034\001\076"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						__kUY7:MoveTo(_zu5)
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _xaE("\014\077\110\065\070\085\065\095\105\110\065\117\070\030\095\065\030\027\113\120\110\065\030\105\089\027\065\027\113\064\095\030\016"), 
			Media = zmediaSpaceshipPart3
		}
	end
end
function _sL6t:On_6KgeA(target)
	if not Player:Contains(_sL6t) then
		_Urwigo.MessageBox{
			Text = _xaE("\034\065\107\110\064\123\065\105\113\077\087\123\065\086\063\117\095\089\065\061\070\070\117\049"), 
			Media = zmediaAlienMultiTool, 
			Buttons = {
				_xaE("\061\034\100\126"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_sL6t:MoveTo(Player)
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					elseif action == "Button2" then
					end
				end
			end
		}
	elseif (_D30 == true) and (_wKkft == true) then
		_Urwigo.MessageBox{
			Text = _xaE("\042\089\095\105\065\095\105\089\030\065\034\117\089\110\077\065\086\063\117\095\089\065\061\070\070\117\065\123\070\063\065\120\113\077\065\087\089\030\113\019\117\110\065\061\105\110\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064"), 
			Media = zmediaAlienMultiTool, 
			Buttons = {
				_xaE("\023\012\126\065\061\014\014\045")
			}, 
			Callback = function(action)
				if action ~= nil then
					_iOb.Visible = false
					zitemDisabledFluxCapacitor.Visible = true
					_zu5.Visible = false
					_IKhw.Visible = true
					Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
				end
			end
		}
	elseif (_D30 == true) and (_wKkft == false) then
		_Urwigo.MessageBox{
			Text = _xaE("\061\105\110\065\117\089\008\105\095\065\085\064\070\093\065\095\105\110\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064\065\089\030\065\095\070\070\065\030\095\064\070\077\008\016\065\084\070\063\065\120\113\077\077\070\095\065\008\070\065\077\110\113\064\065\019\110\120\113\063\030\110\065\123\070\063\064\065\110\123\110\030\065\105\063\064\095\016"), 
			Media = zmediaAlienMultiTool
		}
	else
		_Urwigo.MessageBox{
			Text = _xaE("\125\110\064\123\065\105\113\077\087\123\065\034\117\089\110\077\065\086\063\117\095\089\065\061\070\070\117\016\065\084\070\063\065\120\113\077\065\087\070\065\107\113\064\089\070\063\030\065\041\070\019\030\065\088\089\095\105\065\089\095\016\065\045\089\046\110\065\087\089\030\113\019\117\089\077\008\065\113\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064\016"), 
			Media = zmediaAlienMultiTool
		}
	end
end
function _iOb:On_7F4U(target)
	_Urwigo.MessageBox{
		Text = _xaE("\084\070\063\065\085\070\063\077\087\065\095\105\110\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064\065\019\063\095\065\089\095\065\089\030\065\070\027\110\064\113\095\089\070\077\113\117\016\065\084\070\063\065\088\089\117\117\065\105\113\107\110\065\095\070\065\087\089\030\113\019\117\110\065\089\095\065\085\089\064\030\095\016"), 
		Media = zmediaFluxCapacitorOn, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function zitemDisabledFluxCapacitor:On_bKb7(target)
	if not Player:Contains(zitemDisabledFluxCapacitor) then
		_Urwigo.MessageBox{
			Text = _xaE("\001\070\088\065\089\095\065\089\030\065\030\113\085\110\065\095\070\065\095\113\046\110\065\095\105\110\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064\016"), 
			Media = zmediaFluxCapacitorOff, 
			Buttons = {
				_xaE("\061\034\100\126"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemDisabledFluxCapacitor:MoveTo(Player)
						_G54iE.Complete = true
						_G54iE.Visible = false
						_N4Yq.Active = false
						_N4Yq.Visible = false
						_DCPGg.Visible = true
						_DCPGg.Active = true
						_IKhw.Visible = true
						_D30 = false
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					elseif action == "Button2" then
					end
				end
			end
		}
	elseif _wRx == true then
		_Urwigo.MessageBox{
			Text = _xaE("\061\105\110\065\034\117\089\110\077\065\012\105\089\027\065\120\113\077\077\070\095\065\064\063\077\065\088\089\095\105\070\063\095\065\113\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064\016"), 
			Media = zmediaFluxCapacitorOff, 
			Buttons = {
				_xaE("\076\083\125\126\065\061\014\065\100\099\034\061\009"), 
				_xaE("\001\014\061\065\001\014\042")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemDisabledFluxCapacitor:MoveTo(_IKhw)
						_sL6t:MoveTo(_IKhw)
						Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
					elseif action == "Button2" then
					end
				end
			end
		}
	elseif _D30 == false then
		_Urwigo.MessageBox{
			Text = _xaE("\015\089\030\113\019\117\110\087\065\005\117\063\047\065\102\113\027\113\120\089\095\070\064\016\065\061\105\110\065\113\117\089\110\077\030\065\088\089\117\117\065\077\110\110\087\065\089\095\065\095\070\065\085\089\047\065\095\105\110\089\064\065\030\105\089\027\016"), 
			Media = zmediaFluxCapacitorOff
		}
	end
end
function _tCsJZ:On_WYVn(target)
	_Urwigo.MessageBox{
		Text = _xaE("\061\105\110\065\012\027\113\120\110\120\064\113\085\095\065\089\030\065\089\077\065\027\117\113\077\110\095\113\064\123\065\070\064\019\089\095\016\065\084\070\063\065\120\113\077\065\120\070\093\093\063\077\089\120\113\095\110\065\088\089\095\105\065\089\095\065\019\123\065\064\113\087\089\070\016"), 
		Media = zmediaSpaceCraftinOrbit, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
			end
		end
	}
end
function _0jJzh:On_atZc(target)
	_Urwigo.MessageBox{
		Text = _xaE("\012\070\093\110\065\107\110\064\123\065\077\089\120\110\065\113\117\089\110\077\065\012\042\034\076\049"), 
		Media = zmediaAlienSWAG, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _WFC:On_mDW(target)
	_ZtzCV.Complete = true
	_EtH.Complete = true
	_ZtzCV.Visible = false
	_EtH.Visible = false
	if Wherigo.NoCaseEquals(Env.DeviceID, _xaE("\015\110\030\046\095\070\027")) then
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\065\113\064\110\065\027\117\113\123\089\077\008\065\089\077\065\113\077\065\110\093\063\117\113\095\070\064\016\065\061\105\089\030\065\089\095\110\093\065\088\089\117\117\065\077\070\095\065\019\110\065\087\089\030\027\117\113\123\110\087\049\049\049"), 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "SaveClose"
				end
			end
		}
	elseif Wherigo.NoCaseEquals(Env.DeviceID, _xaE("\088\110\019\088\088\089\008\070")) then
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\065\113\064\110\065\027\117\113\123\089\077\008\065\089\077\065\113\077\065\110\093\063\117\113\095\070\064\016\065\061\105\089\030\065\089\095\110\093\065\088\089\117\117\065\077\070\095\065\019\110\065\087\089\030\027\117\113\123\110\087\049\049\049"), 
			Callback = function(action)
				if action ~= nil then
					_WFC:MoveTo(nil)
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(Env.Platform, _xaE("\042\089\077\067\052")) then
		_Urwigo.MessageBox{
			Text = _xaE("\084\070\063\065\113\064\110\065\027\117\113\123\089\077\008\065\089\077\065\113\077\065\110\093\063\117\113\095\070\064\016\065\061\105\089\030\065\089\095\110\093\065\088\089\117\117\065\077\070\095\065\019\110\065\087\089\030\027\117\113\123\110\087\049\049\049"), 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "SaveClose"
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _xaE("\061\105\110\065\076\110\070\120\113\120\105\110\065\089\030\065\117\070\120\113\095\110\087\065\113\095\065\001\065\011\052\065\072\090\016\033\090\067\065\126\065\072\052\011\065\011\011\016\056\011\057\016\065\042\105\110\077\065\123\070\063\065\064\110\113\120\105\065\095\105\110\065\027\117\113\120\110\065\083\065\088\089\117\117\065\063\027\117\070\113\087\065\113\065\030\027\070\089\117\110\064\065\027\089\120\095\063\064\110\065\113\077\087\065\113\065\105\089\077\095\065\095\070\065\123\070\063\064\065\087\110\107\089\120\110\016"), 
			Media = zmediaGeocache, 
			Callback = function(action)
				if action ~= nil then
					_KRD.Active = true
					_KRD.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _TK0N:On_DrIp(target)
	_Urwigo.MessageBox{
		Text = (_xaE("\084\070\063\064\065\120\070\093\027\117\110\095\089\070\077\065\120\070\087\110\065\089\030\127\065")..string.sub(Player.CompletionCode, 1, 15)).._xaE("\065\048\117\110\113\030\110\065\063\030\110\065\095\105\110\065\085\089\064\030\095\065\056\114\065\120\105\113\064\113\120\095\110\064\030\065\070\085\065\089\095\065\070\077\065\042\105\110\064\089\008\070\016\120\070\093\065\095\070\065\063\077\117\070\120\046\065\095\105\110\065\120\113\064\095\064\089\087\008\110")
	}
end
function _zv4YR:On_vtvsN(target)
	_Urwigo.MessageBox{
		Text = _xaE("\007\110\105\089\077\087\065\113\065\030\095\070\077\110\065\089\077\065\095\105\110\065\088\113\117\117\016"), 
		Media = zmediaSpoiler, 
		Callback = function(action)
			if action ~= nil then
				if Player:Contains(_TK0N) then
					_Urwigo.MessageBox{
						Text = _xaE("\015\089\087\065\123\070\063\065\085\089\077\087\065\095\105\110\065\008\110\070\120\113\120\105\110\097\065\083\085\065\123\070\063\065\085\070\063\077\087\065\095\105\110\065\027\117\113\120\110\065\113\077\087\065\123\070\063\065\113\064\110\065\030\063\064\110\065\095\105\113\095\065\095\105\110\065\120\113\120\105\110\065\089\030\065\093\089\030\030\089\077\008\091\065\027\117\110\113\030\110\065\085\110\110\117\065\088\110\117\120\070\093\110\065\095\070\065\117\070\008\065\123\070\063\064\065\085\089\077\087\016\065\034\065\120\070\093\027\117\110\095\089\070\077\065\120\070\087\110\065\095\070\065\117\070\008\065\095\105\089\030\065\120\113\064\095\064\089\087\008\110\065\113\095\065\088\105\110\064\089\008\070\016\120\070\093\065\120\113\077\065\019\110\065\085\070\063\077\087\065\089\077\065\123\070\063\064\065\089\077\107\110\077\095\070\064\123\016"), 
						Media = zmediaGeocache, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
							end
						end
					}
				else
					_Urwigo.MessageBox{
						Text = _xaE("\015\089\087\065\123\070\063\065\085\089\077\087\065\095\105\110\065\008\110\070\120\113\120\105\110\097\065\083\085\065\123\070\063\065\085\070\063\077\087\065\095\105\110\065\027\117\113\120\110\065\113\077\087\065\123\070\063\065\113\064\110\065\030\063\064\110\065\095\105\113\095\065\095\105\110\065\120\113\120\105\110\065\089\030\065\093\089\030\030\089\077\008\091\065\027\117\110\113\030\110\065\085\110\110\117\065\088\110\117\120\070\093\110\065\095\070\065\117\070\008\065\123\070\063\064\065\085\089\077\087\016\065\034\065\120\070\093\027\117\110\095\089\070\077\065\120\070\087\110\065\095\070\065\117\070\008\065\095\105\089\030\065\120\113\064\095\064\089\087\008\110\065\113\095\065\088\105\110\064\089\008\070\016\120\070\093\065\120\113\077\065\019\110\065\085\070\063\077\087\065\089\077\065\123\070\063\064\065\089\077\107\110\077\095\070\064\123\016"), 
						Media = zmediaGeocache, 
						Callback = function(action)
							if action ~= nil then
								_TK0N.Visible = true
								_TK0N:MoveTo(Player)
								Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
							end
						end
					}
				end
			end
		end
	}
end
function _TgNo:On_YgKwt(target)
	_Urwigo.MessageBox{
		Text = _xaE("\084\070\063\065\095\113\046\110\065\070\063\095\065\123\070\063\064\065\093\113\027\065\070\085\065\095\105\110\065\113\064\110\113\065\113\077\087\065\110\047\027\117\070\064\110\065\089\095\065\095\070\065\085\089\077\087\065\095\105\110\065\030\105\070\064\095\110\030\095\065\088\113\123\065\095\070\065\123\070\063\064\065\008\070\113\117\065\085\070\064\065\095\070\087\113\123\016\065\012\063\087\087\110\077\117\123\065\123\070\063\065\105\110\113\064\065\113\065\030\095\064\113\077\008\110\065\077\070\089\030\110\065\070\107\110\064\105\110\113\087\091\065\113\065\019\064\089\008\105\095\065\117\089\008\105\095\065\085\117\113\030\105\110\030\065\113\077\087\065\030\070\093\110\095\105\089\077\008\065\063\077\063\030\063\113\117\065\120\064\113\030\105\110\030\065\089\077\095\070\065\095\105\110\065\077\110\113\064\019\123\065\019\063\030\105\110\030\016"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _xaE("\084\070\063\065\113\064\110\065\120\063\064\089\070\063\030\065\088\105\113\095\065\105\113\027\027\110\077\110\087\065\113\077\087\065\087\110\120\089\087\110\065\095\070\065\008\070\065\113\077\087\065\095\113\046\110\065\113\065\120\117\070\030\110\064\065\117\070\070\046"), 
					Media = zmediaTask, 
					Callback = function(action)
						if action ~= nil then
							_vPT__.Visible = true
							_vPT__.Active = true
							_yFk.Complete = true
							_yFk.Visible = false
							_Ga713.Visible = true
							_Ga713.Active = true
							_TgNo.Commands._YgKwt.Enabled = false
							if (Player:Contains(_uFEK) and Player:Contains(_mRxqq)) and Player:Contains(_YdN) then
								_AZY4.Visible = false
								_AZY4.Active = false
								_ip_po.Visible = false
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							else
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					end
				}
			end
		end
	}
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return _cZcj
