require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _vHmo(str)
	local res = ""
    local dtable = "\117\092\100\008\080\086\020\011\124\078\045\046\024\047\019\099\077\096\018\030\114\022\074\081\069\028\094\007\043\061\101\042\040\073\113\106\027\033\004\006\085\122\060\009\057\108\001\097\021\084\065\111\048\035\072\064\066\102\076\010\107\075\079\037\071\031\118\123\055\016\104\015\109\039\093\110\087\058\050\112\063\105\041\051\098\126\091\056\082\083\088\005\044\034\054\070\025\002\049\090\125\036\089\053\023\059\121\013\012\052\103\062\120\017\115\000\014\032\116\003\038\026\029\068\095\067\119"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_hZRKU = Wherigo.ZCartridge()

-- Media --
_bcc4j = Wherigo.ZMedia(_hZRKU)
_bcc4j.Id = "5ef7bcbe-a811-4301-96a9-0815a3af19d4"
_bcc4j.Name = _vHmo("\003\052\073\031\016\031\061")
_bcc4j.Description = ""
_bcc4j.AltText = ""
_bcc4j.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek1.jpg", 
		Directives = {}
	}
}
_Rb8w = Wherigo.ZMedia(_hZRKU)
_Rb8w.Id = "29b415e3-2c98-4aad-a0ff-fe0984b7794e"
_Rb8w.Name = _vHmo("\003\052\073\031\016\031\061\118\051")
_Rb8w.Description = ""
_Rb8w.AltText = ""
_Rb8w.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-a.jpg", 
		Directives = {}
	}
}
_Jzkz = Wherigo.ZMedia(_hZRKU)
_Jzkz.Id = "0f83ef94-45c8-4ecf-8cf9-9e260f37dfeb"
_Jzkz.Name = _vHmo("\003\052\073\031\016\031\061\118\057")
_Jzkz.Description = ""
_Jzkz.AltText = ""
_Jzkz.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-b.jpg", 
		Directives = {}
	}
}
_Suv = Wherigo.ZMedia(_hZRKU)
_Suv.Id = "cd8b4d64-8fa9-40f2-9613-d7239c8c62b4"
_Suv.Name = _vHmo("\003\052\073\031\016\031\061\118\126")
_Suv.Description = ""
_Suv.AltText = ""
_Suv.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-c.jpg", 
		Directives = {}
	}
}
_Cu_o = Wherigo.ZMedia(_hZRKU)
_Cu_o.Id = "6af371ff-59fb-4c8e-a87b-e20744ecb4e3"
_Cu_o.Name = _vHmo("\003\052\073\031\016\031\061\118\124")
_Cu_o.Description = ""
_Cu_o.AltText = ""
_Cu_o.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-d.jpg", 
		Directives = {}
	}
}
_Oca0a = Wherigo.ZMedia(_hZRKU)
_Oca0a.Id = "e2249ec7-84bb-41a8-ad12-c05905de0978"
_Oca0a.Name = _vHmo("\003\052\073\031\016\031\061\118\025")
_Oca0a.Description = ""
_Oca0a.AltText = ""
_Oca0a.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-e.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_hZRKU.Id="bb2bcb8c-4fcf-4828-bbeb-5feb541240a7"
_hZRKU.Name="Domecek jednim tahem"
_hZRKU.Description=[[]]
_hZRKU.Visible=true
_hZRKU.Activity="Geocache"
_hZRKU.StartingLocationDescription=[[]]
_hZRKU.StartingLocation = Wherigo.INVALID_ZONEPOINT
_hZRKU.Version="1.9"
_hZRKU.Company="URWIGO.CZ"
_hZRKU.Author="Maxinoha"
_hZRKU.BuilderVersion="URWIGO 1.20.5218.24064"
_hZRKU.CreateDate="06/02/2011 19:33:47"
_hZRKU.PublishDate="1/1/0001 12:00:00 AM"
_hZRKU.UpdateDate="01/14/2015 10:48:24"
_hZRKU.LastPlayedDate="1/1/0001 12:00:00 AM"
_hZRKU.TargetDevice="PocketPC"
_hZRKU.TargetDeviceVersion="0"
_hZRKU.StateId="1"
_hZRKU.CountryId="2"
_hZRKU.Complete=false
_hZRKU.UseLogging=true

_hZRKU.Media=_bcc4j


-- Zones --
zoneA = Wherigo.Zone(_hZRKU)
zoneA.Id = "2f95c949-2e7a-47e9-a00b-bdb5c6a4937a"
zoneA.Name = _vHmo("\051")
zoneA.Description = _vHmo("\059\031\067\048\118\003\052\046\076\082")
zoneA.Visible = true
zoneA.Media = _Rb8w
zoneA.Commands = {}
zoneA.DistanceRange = Distance(-1, "feet")
zoneA.ShowObjects = "OnEnter"
zoneA.ProximityRange = Distance(60, "meters")
zoneA.AllowSetPositionTo = false
zoneA.Active = false
zoneA.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneA.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneA.DistanceRangeUOM = "Feet"
zoneA.ProximityRangeUOM = "Meters"
zoneA.OutOfRangeName = ""
zoneA.InRangeName = ""
zoneB = Wherigo.Zone(_hZRKU)
zoneB.Id = "43ca6dfa-477a-455c-b9dc-5d4b58b72f7d"
zoneB.Name = _vHmo("\057")
zoneB.Description = _vHmo("\005\021\048\067\048\118\003\052\046\076\082")
zoneB.Visible = true
zoneB.Media = _Jzkz
zoneB.Commands = {}
zoneB.DistanceRange = Distance(-1, "feet")
zoneB.ShowObjects = "OnEnter"
zoneB.ProximityRange = Distance(60, "meters")
zoneB.AllowSetPositionTo = false
zoneB.Active = false
zoneB.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneB.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneB.DistanceRangeUOM = "Feet"
zoneB.ProximityRangeUOM = "Meters"
zoneB.OutOfRangeName = ""
zoneB.InRangeName = ""
zoneC = Wherigo.Zone(_hZRKU)
zoneC.Id = "f6124f86-6b29-4ec2-8b22-eef70a1d4324"
zoneC.Name = _vHmo("\124")
zoneC.Description = _vHmo("\005\021\048\067\048\118\071\052\021\076\082")
zoneC.Visible = true
zoneC.Media = _Cu_o
zoneC.Commands = {}
zoneC.DistanceRange = Distance(-1, "feet")
zoneC.ShowObjects = "OnEnter"
zoneC.ProximityRange = Distance(60, "meters")
zoneC.AllowSetPositionTo = false
zoneC.Active = false
zoneC.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneC.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneC.DistanceRangeUOM = "Feet"
zoneC.ProximityRangeUOM = "Meters"
zoneC.OutOfRangeName = ""
zoneC.InRangeName = ""
zoneD = Wherigo.Zone(_hZRKU)
zoneD.Id = "cfbc7f94-c524-403c-aa59-b97612eb007b"
zoneD.Name = _vHmo("\025")
zoneD.Description = _vHmo("\090\119\021\031\016\071\048")
zoneD.Visible = true
zoneD.Media = _Oca0a
zoneD.Commands = {}
zoneD.DistanceRange = Distance(-1, "feet")
zoneD.ShowObjects = "OnEnter"
zoneD.ProximityRange = Distance(60, "meters")
zoneD.AllowSetPositionTo = false
zoneD.Active = false
zoneD.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneD.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneD.DistanceRangeUOM = "Feet"
zoneD.ProximityRangeUOM = "Meters"
zoneD.OutOfRangeName = ""
zoneD.InRangeName = ""
zoneE = Wherigo.Zone(_hZRKU)
zoneE.Id = "f02f158a-da1a-4b1d-b379-7326d9bfb63c"
zoneE.Name = _vHmo("\126")
zoneE.Description = _vHmo("\059\031\067\048\118\071\052\021\076\082")
zoneE.Visible = true
zoneE.Media = _Suv
zoneE.Commands = {}
zoneE.DistanceRange = Distance(-1, "feet")
zoneE.ShowObjects = "OnEnter"
zoneE.ProximityRange = Distance(60, "meters")
zoneE.AllowSetPositionTo = false
zoneE.Active = false
zoneE.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneE.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneE.DistanceRangeUOM = "Feet"
zoneE.ProximityRangeUOM = "Meters"
zoneE.OutOfRangeName = ""
zoneE.InRangeName = ""
pomocnaA = Wherigo.Zone(_hZRKU)
pomocnaA.Id = "10239a76-6c6f-4745-9b53-368516b464d4"
pomocnaA.Name = _vHmo("\080\052\073\052\016\076\048\051")
pomocnaA.Description = ""
pomocnaA.Visible = false
pomocnaA.Commands = {}
pomocnaA.DistanceRange = Distance(-1, "feet")
pomocnaA.ShowObjects = "OnEnter"
pomocnaA.ProximityRange = Distance(60, "meters")
pomocnaA.AllowSetPositionTo = false
pomocnaA.Active = false
pomocnaA.Points = {
	ZonePoint(50.0883105759415, 14.4861529022455, 0), 
	ZonePoint(50.0885153651931, 14.486067071557, 0), 
	ZonePoint(50.0884637377332, 14.4863674789667, 0)
}
pomocnaA.OriginalPoint = ZonePoint(50.0884298929559, 14.4861958175897, 0)
pomocnaA.DistanceRangeUOM = "Feet"
pomocnaA.ProximityRangeUOM = "Meters"
pomocnaA.OutOfRangeName = ""
pomocnaA.InRangeName = ""
pomocnaB = Wherigo.Zone(_hZRKU)
pomocnaB.Id = "a4ad9cd7-f6ab-4be3-9339-30f7b8c9b448"
pomocnaB.Name = _vHmo("\126\051\126\055\025")
pomocnaB.Description = ""
pomocnaB.Visible = false
pomocnaB.Commands = {}
pomocnaB.DistanceRange = Distance(-1, "feet")
pomocnaB.ShowObjects = "OnEnter"
pomocnaB.ProximityRange = Distance(60, "meters")
pomocnaB.AllowSetPositionTo = false
pomocnaB.Active = false
pomocnaB.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
pomocnaB.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
pomocnaB.DistanceRangeUOM = "Feet"
pomocnaB.ProximityRangeUOM = "Meters"
pomocnaB.OutOfRangeName = ""
pomocnaB.InRangeName = ""

-- Characters --

-- Items --
_4dE = Wherigo.ZItem{
	Cartridge = _hZRKU, 
	Container = Player
}
_4dE.Id = "02c916f2-7704-4ab4-9f50-70be70d7e842"
_4dE.Name = _vHmo("\119\001\042\061\048")
_4dE.Description = ""
_4dE.Visible = true
_4dE.Media = _Rb8w
_4dE.Commands = {
	_AO_ = Wherigo.ZCommand{
		Text = _vHmo("\042\048\061\021\031\115\046\082\119\118\085\052\003\118\051"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _vHmo("\010\082\016\118\061\118\003\082\115\080\052\042\082\016\082")
	}, 
	_WpB = Wherigo.ZCommand{
		Text = _vHmo("\042\048\061\021\031\115\046\082\119\118\085\052\003\118\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _vHmo("\010\082\016\118\061\118\003\082\115\080\052\042\082\016\082")
	}, 
	__hO1 = Wherigo.ZCommand{
		Text = _vHmo("\042\048\016\082\119\118\061\021\031\115\046\082\119"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _vHmo("\010\082\016\118\061\118\003\082\115\080\052\042\082\016\082")
	}, 
	_TY_q = Wherigo.ZCommand{
		Text = _vHmo("\042\048\016\082\119\118\061\021\031\115\046\082\119"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _vHmo("\010\082\016\118\061\118\003\082\115\080\052\042\082\016\082")
	}, 
	_pqSd = Wherigo.ZCommand{
		Text = _vHmo("\042\048\016\082\119\118\061\021\031\115\046\082\119"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _vHmo("\010\082\016\118\061\118\003\082\115\080\052\042\082\016\082")
	}
}
_4dE.Commands._AO_.Custom = true
_4dE.Commands._AO_.Id = "e809ab1c-003d-47c0-976d-348ddb662866"
_4dE.Commands._AO_.WorksWithAll = true
_4dE.Commands._WpB.Custom = true
_4dE.Commands._WpB.Id = "d8d05477-961f-4739-9f29-f6ef7875d1e4"
_4dE.Commands._WpB.WorksWithAll = true
_4dE.Commands.__hO1.Custom = true
_4dE.Commands.__hO1.Id = "1e284680-e310-452f-9ddf-7695b82eca5d"
_4dE.Commands.__hO1.WorksWithAll = true
_4dE.Commands._TY_q.Custom = true
_4dE.Commands._TY_q.Id = "4d5a876d-b474-4e54-83b8-7666e586c2a2"
_4dE.Commands._TY_q.WorksWithAll = true
_4dE.Commands._pqSd.Custom = true
_4dE.Commands._pqSd.Id = "794979c4-ddae-4c66-bac1-5fd876aaa2cd"
_4dE.Commands._pqSd.WorksWithAll = true
_4dE.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_4dE.Locked = false
_4dE.Opened = false
_iFwRc = Wherigo.ZItem{
	Cartridge = _hZRKU, 
	Container = Player
}
_iFwRc.Id = "77a4a748-92e0-4600-8adb-d75b0795b2d1"
_iFwRc.Name = _vHmo("\063\003\031\073\107\061\048\016\082\118\061\052\003")
_iFwRc.Description = ""
_iFwRc.Visible = false
_iFwRc.Commands = {}
_iFwRc.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_iFwRc.Locked = false
_iFwRc.Opened = false

-- Tasks --
_jGG62 = Wherigo.ZTask(_hZRKU)
_jGG62.Id = "246e8e5f-7ba3-43fc-b48b-ec10f0e4f42d"
_jGG62.Name = _vHmo("\100\048\061\021\031\115\046\082\118\085\052\003\118\051")
_jGG62.Description = ""
_jGG62.Visible = true
_jGG62.Active = true
_jGG62.Complete = false
_jGG62.CorrectState = "None"
_yTiJl = Wherigo.ZTask(_hZRKU)
_yTiJl.Id = "b9d2dc92-db38-4276-8714-203113569954"
_yTiJl.Name = _vHmo("\100\048\061\021\031\115\046\082\118\085\052\003\118\057")
_yTiJl.Description = ""
_yTiJl.Visible = true
_yTiJl.Active = false
_yTiJl.Complete = false
_yTiJl.CorrectState = "None"
_4_g = Wherigo.ZTask(_hZRKU)
_4_g.Id = "22c74aca-9d4c-404a-a7d1-4327130f2a18"
_4_g.Name = _vHmo("\010\048\046\031\042\076\082\118\099\012\118\021\031\115\031\076\082")
_4_g.Description = ""
_4_g.Visible = true
_4_g.Active = false
_4_g.Complete = false
_4_g.CorrectState = "None"
_ZIr = Wherigo.ZTask(_hZRKU)
_ZIr.Id = "cca46ea7-0cab-49f5-89fb-a0d9274dd60d"
_ZIr.Name = _vHmo("\010\048\046\031\042\076\082\118\079\012\118\021\031\115\031\076\082")
_ZIr.Description = ""
_ZIr.Visible = true
_ZIr.Active = false
_ZIr.Complete = false
_ZIr.CorrectState = "None"
_b7E = Wherigo.ZTask(_hZRKU)
_b7E.Id = "bc7eba1a-d42b-445e-b5b9-9a92295637be"
_b7E.Name = _vHmo("\010\048\046\031\042\076\082\118\084\012\118\021\031\115\031\076\082")
_b7E.Description = ""
_b7E.Visible = true
_b7E.Active = false
_b7E.Complete = false
_b7E.CorrectState = "None"
_nMxZ2 = Wherigo.ZTask(_hZRKU)
_nMxZ2.Id = "03a472ac-66d6-49e8-a342-0b08184568b4"
_nMxZ2.Name = _vHmo("\010\048\036\082\119\118\016\048\016\071\031")
_nMxZ2.Description = ""
_nMxZ2.Visible = true
_nMxZ2.Active = false
_nMxZ2.Complete = false
_nMxZ2.CorrectState = "None"

-- Cartridge Variables --
pointALat = 0
pointALon = 0
_AJzF1 = false
_h6OV = false
_qiZe = false
_ZdT = false
_RYz = false
_6nbTS = false
_LJ3 = false
_jNMx = false
_F06 = ""
_HWVYQ = ""
_9Xug1 = ""
_MkI = ""
_MKzn = false
_j1yR = false
_BOC4 = false
_cW5 = ""
_ekAw_ = ""
gckod = _vHmo("\065\126\084\065\079\103\124")
esouradnice = 0
nsouradnice = 0
nasobic = 0
_BqDcB = false
radius = 0
_DdYJ = _vHmo("\042\052\076\031\051")
_KSFx7 = _vHmo("\003\001\073\073\107")
_garu = _vHmo("\125\110\003\025")
_C4Xo = _vHmo("\125\036\065\065\095\079")
_sEAln = _vHmo("\003\001\073\073\107")
_E95x = _vHmo("\003\001\073\073\107")
_hZRKU.ZVariables = {
	pointALat = 0, 
	pointALon = 0, 
	_AJzF1 = false, 
	_h6OV = false, 
	_qiZe = false, 
	_ZdT = false, 
	_RYz = false, 
	_6nbTS = false, 
	_LJ3 = false, 
	_jNMx = false, 
	_F06 = "", 
	_HWVYQ = "", 
	_9Xug1 = "", 
	_MkI = "", 
	_MKzn = false, 
	_j1yR = false, 
	_BOC4 = false, 
	_cW5 = "", 
	_ekAw_ = "", 
	gckod = _vHmo("\065\126\084\065\079\103\124"), 
	esouradnice = 0, 
	nsouradnice = 0, 
	nasobic = 0, 
	_BqDcB = false, 
	radius = 0, 
	_DdYJ = _vHmo("\042\052\076\031\051"), 
	_KSFx7 = _vHmo("\003\001\073\073\107"), 
	_garu = _vHmo("\125\110\003\025"), 
	_C4Xo = _vHmo("\125\036\065\065\095\079"), 
	_sEAln = _vHmo("\003\001\073\073\107"), 
	_E95x = _vHmo("\003\001\073\073\107")
}

-- Timers --

-- Inputs --

-- WorksWithList for object commands --

-- functions --
function _hZRKU:OnStart()
	if (_G[_vHmo("\025\076\067")][_vHmo("\005\046\048\119\058\052\021\073")] == _vHmo("\077\082\076\084\079")) or (_G[_vHmo("\025\076\067")][_vHmo("\124\031\067\082\016\031\034\124")] == _vHmo("\124\031\115\061\119\052\080")) then
		for k, v in pairs(_G[_vHmo("\125\071\100\089\062\041")][_vHmo("\051\046\046\100\063\085\036\031\016\119\115")]) do
			v[_vHmo("\006\082\115\082\085\046\031")] = false
			v[_vHmo("\051\016\119\082\067\031")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_vHmo("\090\082\111\076\048\046\118\065\005\090\118\076\031\076\082\118\061\118\003\082\115\080\052\042\082\016\082\012")), 
			Callback = function(action)
				if action ~= nil then
					_G[_vHmo("\077\071\031\021\082\111\052")][_vHmo("\126\052\073\073\048\076\003")](_vHmo("\090\048\067\031\126\046\052\115\031"))
				end
			end
		}
		return
	end
	_Urwigo.Dialog(false, {
		{
			Text = _vHmo("\023\082\115\119\031\118\042\076\048\115\118\061\046\048\115\082\016\061\052\001\118\115\061\052\046\076\082\118\001\046\052\071\001\118\076\048\061\021\031\115\046\082\119\118\003\052\073\031\016\031\061\118\036\031\003\076\082\073\118\119\048\071\031\073\012"), 
			Media = _bcc4j
		}, 
		{
			Text = _vHmo("\050\048\061\031\118\073\076\031\118\119\048\119\052\118\073\107\115\046\031\076\061\048\118\052\115\046\052\067\082\046\048\118\011\118\061\052\046\082\061\118\021\031\115\031\076\082\118\067\001\085\031\016\118\031\113\082\115\119\001\036\031\081\043\057\089\112\023\031\003\076\052\093\118\003\067\031\093\118\076\031\085\052\118\115\076\048\003\118\067\082\016\031\081")
		}, 
		{
			Text = _vHmo("\010\031\085\001\003\001\118\119\031\118\003\046\052\001\071\052\118\076\048\080\082\076\048\119\093\118\073\052\042\076\107\016\071\118\021\031\115\031\076\082\118\036\031\118\088\088\012\043\057\089\112\051\118\119\067\107\073\118\001\061\052\046\031\073\118\085\001\003\031\118\076\048\046\031\042\119\118\048\046\031\115\080\052\076\118\119\021\082\118\042\118\076\082\016\071\012"), 
			Buttons = {
				_vHmo("\023\124\041\118\010\051\118\050\063")
			}
		}
	}, function(action)
		_Urwigo.Dialog(false, {
			{
				Text = _vHmo("\010\107\076\082\118\073\001\042\031\115\118\042\048\016\082\119\118\115\118\067\107\042\076\048\016\031\076\082\073\118\021\052\071\052\067\107\016\071\118\085\052\003\001\118\003\052\073\031\016\061\001\012"), 
				Media = _bcc4j
			}, 
			{
				Text = _vHmo("\010\048\036\003\082\118\115\082\118\003\052\115\119\048\119\031\016\076\031\118\067\031\046\061\031\118\080\021\052\115\119\021\048\076\115\119\067\082\012\043\057\089\112\126\082\073\118\067\031\119\115\082\093\118\119\082\073\118\046\031\080\031\093\118\048\046\031\118\073\082\076\082\073\048\046\076\031\118\104\053\113\104\053\118\073\031\119\021\001\012")
			}, 
			{
				Text = _vHmo("\005\021\031\036\003\082\118\003\052\118\073\082\115\119\048\093\118\061\003\031\118\085\107\118\073\031\046\118\085\107\119\118\085\052\003\118\051\118\048\118\080\052\001\042\082\036\118\119\001\042\061\001\093\118\061\119\031\021\052\001\118\076\048\046\031\042\076\031\115\118\067\031\118\115\067\031\073\118\085\048\119\001\042\061\001\012"), 
				Media = _Rb8w, 
				Buttons = {
					_vHmo("\023\082\119\118\003\052\118\085\052\003\001\118\051")
				}
			}
		}, function(action)
			_iFwRc.Description = _vHmo("\063\003\031\073\107\061\048\016\082\118\061\052\003\118\033\126\052\073\080\046\031\119\082\052\076\118\126\052\003\031\083\118\080\021\052\118\052\042\076\048\016\031\076\082\118\071\021\107\118\036\048\061\052\118\003\052\061\052\076\016\031\076\031\118\076\048\118\080\052\021\119\048\046\001\118\127\127\012\127\071\031\021\082\111\052\058\052\001\076\003\048\119\082\052\076\012\016\052\073\118\036\031\078\043\057\089\112")..string.sub(Player.CompletionCode, 1, 15)
		end)
	end)
end
function _hZRKU:OnRestore()
end
function zoneA:OnEnter()
	_DdYJ = _vHmo("\042\052\076\031\051")
	_ph0L()
end
function zoneB:OnEnter()
	_DdYJ = _vHmo("\042\052\076\031\057")
	_ph0L()
end
function zoneC:OnEnter()
	_DdYJ = _vHmo("\042\052\076\031\126")
	_ph0L()
end
function zoneD:OnEnter()
	_DdYJ = _vHmo("\042\052\076\031\124")
	_ph0L()
end
function zoneE:OnEnter()
	_DdYJ = _vHmo("\042\052\076\031\025")
	_ph0L()
end
function pomocnaA:OnEnter()
	_DdYJ = _vHmo("\080\052\073\052\016\076\048\051")
	_4dE.Commands._WpB.Enabled = false
end
function pomocnaA:OnExit()
	_DdYJ = _vHmo("\080\052\073\052\016\076\048\051")
	_4dE.Commands._WpB.Enabled = true
end
function pomocnaB:OnEnter()
	_DdYJ = _vHmo("\080\052\073\052\016\076\048\057")
	if _BqDcB == false then
		_BqDcB = true
		_hZRKU.Complete = true
		_nMxZ2.Complete = true
		_Urwigo.MessageBox{
			Text = _vHmo("\124\052\021\048\042\082\046\118\036\115\082\118\076\048\118\073\082\115\119\052\118\061\003\031\118\036\031\118\001\061\021\107\119\048\118\016\048\016\071\031\118\048\118\119\082\073\118\119\048\119\052\118\071\021\048\118\061\052\076\016\082\012\043\057\089\112\043\057\089\112\076\048\080\052\067\031\003\048\078\118\055\046\031\003\031\036\118\121\076\085\115\080\106\124\063\017\025\126\025\062\012"), 
			Callback = function(action)
				if action ~= nil then
					_hZRKU:RequestSync()
					_Urwigo.MessageBox{
						Text = _vHmo("\055\021\048\118\001\046\052\042\031\076\048\012"), 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _vHmo("\055\046\031\003\031\036\118\121\076\085\115\080\106\124\063\017\025\126\025\062\012"), 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _4dE:On_AO_(target)
	CenterZoneOnPoint(pomocnaA, Player.ObjectLocation, 10)
	pomocnaA.Visible = false
	pointALat = Player.ObjectLocation.latitude
	pointALon = Player.ObjectLocation.longitude
	_4dE.Commands._AO_.Enabled = false
	_jGG62.Complete = true
	_yTiJl.Active = true
	_4dE.Media = _Jzkz
	_Urwigo.Dialog(false, {
		{
			Text = _vHmo("\057\052\003\118\051\118\085\107\046\118\076\048\061\021\031\115\046\031\076\012\043\057\089\112\010\107\076\082\118\080\021\031\036\003\082\118\076\048\118\073\082\115\119\052\118\061\003\031\118\016\071\016\031\115\118\076\048\061\021\031\115\046\082\119\118\085\052\003\118\057\118\048\118\052\080\031\119\118\080\052\001\042\082\036\118\119\001\042\061\001\012"), 
			Media = _Jzkz
		}, 
		{
			Text = _vHmo("\005\052\061\001\003\118\085\001\003\031\115\118\080\021\082\046\082\115\118\085\046\082\042\061\052\118\085\052\003\001\118\051\093\118\119\048\061\118\119\082\118\119\001\042\061\048\118\076\031\003\052\067\052\046\082\118\085\052\003\118\057\118\076\048\061\021\031\115\046\082\119\012"), 
			Buttons = {
				_vHmo("\023\082\119\118\003\052\118\085\052\003\001\118\057")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _4dE:On_WpB(target)
	radius = _Urwigo.Floor(Wherigo.VectorToPoint(Player.ObjectLocation, pomocnaA.OriginalPoint):GetValue "m" / 4.8, 0)
	pomocnaA.Active = false
	_4dE.Commands._WpB.Enabled = false
	_4dE.Commands.__hO1.Enabled = true
	_yTiJl.Complete = true
	_4dE.Media = _bcc4j
	_4_g.Active = true
	BuildHouse(
	  Wherigo.ZonePoint(pointALat, pointALon, 0),
	  Player.ObjectLocation,
	  zoneA,
	  zoneB,
	  zoneC,
	  zoneD,
	  zoneE,
	  radius)
	_Urwigo.Dialog(false, {
		{
			Text = _vHmo("\057\052\003\118\057\118\085\107\046\118\042\048\061\021\031\115\046\031\076\012\043\057\089\112\124\048\046\115\082\118\085\052\003\107\118\126\093\124\093\025\118\085\107\046\107\118\067\107\119\067\052\021\031\076\107\118\048\001\119\052\073\048\119\082\016\061\107\012")
		}, 
		{
			Text = _vHmo("\010\107\076\082\118\036\082\042\118\073\001\042\031\115\118\042\048\016\082\119\118\115\118\061\021\031\115\046\031\076\082\073\118\099\012\118\021\031\115\031\076\082\012"), 
			Media = _bcc4j
		}, 
		{
			Text = _vHmo("\005\021\031\115\001\076\118\115\031\118\003\052\118\085\052\003\001\118\067\031\118\061\119\031\021\031\073\118\016\071\016\031\115\118\042\048\016\082\119\118\061\021\031\115\046\082\119\118\003\052\073\031\016\031\061\118\036\031\003\076\082\073\118\119\048\071\031\073\118\048\118\052\080\031\119\118\080\052\001\042\082\036\118\119\001\042\061\001\012\043\057\089\112\050\067\001\036\118\080\052\071\107\085\118\080\021\082\118\067\107\119\067\048\021\031\076\082\118\085\052\003\001\118\115\031\118\003\052\118\021\031\115\031\076\082\118\010\025\080\052\016\082\119\048\012"), 
			Media = _bcc4j, 
			Buttons = {
				_vHmo("\023\003\082\118\076\048\118\042\048\016\048\119\031\061")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _4dE:On__hO1(target)
	if (((zoneA:Contains(Player) or zoneB:Contains(Player)) or zoneE:Contains(Player)) or zoneC:Contains(Player)) or zoneD:Contains(Player) then
		_4dE.Commands.__hO1.Enabled = false
		_MKzn = true
		_tsDe()
		_FiYu()
		_Urwigo.Dialog(false, {
			{
				Text = _vHmo("\100\048\016\048\046\118\036\115\082\118\061\021\031\115\046\082\119\118\003\052\073\031\016\031\061\118\036\031\003\076\082\073\118\119\048\071\031\073\012\043\057\089\112\010\107\076\082\118\115\031\118\119\067\001\036\118\080\052\071\107\085\118\073\031\042\082\118\036\031\003\076\052\119\046\082\067\107\073\082\118\085\052\003\107\118\042\048\042\076\048\073\031\076\048\067\048\118\036\048\061\052\118\061\021\031\115\046\031\076\082\118\036\031\003\076\082\073\118\119\048\071\031\073\012")
			}, 
			{
				Text = _vHmo("\051\061\119\001\048\046\076\031\118\073\048\115\118\076\048\061\021\031\115\046\031\076\052\078\118").._F06, 
				Media = _bcc4j, 
				Buttons = {
					_vHmo("\005\052\061\021\048\016\052\067\048\119")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.MessageBox{
			Text = _vHmo("\010\031\115\119\052\036\082\115\118\076\048\118\042\048\003\076\031\073\118\085\052\003\031\012"), 
			Buttons = {
				_vHmo("\023\003\082\118\076\048\118\080\052\016\048\119\031\016\076\082\118\085\052\003")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _4dE:On_TY_q(target)
	if (((zoneA:Contains(Player) or zoneB:Contains(Player)) or zoneE:Contains(Player)) or zoneC:Contains(Player)) or zoneD:Contains(Player) then
		_4dE.Commands._TY_q.Enabled = false
		_j1yR = true
		_tsDe()
		_FiYu()
		_Urwigo.Dialog(false, {
			{
				Text = _vHmo("\100\048\016\048\046\118\036\115\082\118\061\021\031\115\046\082\119\118\003\052\073\031\016\031\061\118\036\031\003\076\082\073\118\119\048\071\031\073\012\043\057\089\112\010\107\076\082\118\115\031\118\119\067\001\036\118\080\052\071\107\085\118\073\031\042\082\118\036\031\003\076\052\119\046\082\067\107\073\082\118\085\052\003\107\118\042\048\042\076\048\073\031\076\048\067\048\118\036\048\061\052\118\061\021\031\115\046\031\076\082\118\036\031\003\076\082\073\118\119\048\071\031\073\012")
			}, 
			{
				Text = _vHmo("\051\061\119\001\048\046\076\031\118\073\048\115\118\076\048\061\021\031\115\046\031\076\052\078\118").._HWVYQ, 
				Media = _bcc4j, 
				Buttons = {
					_vHmo("\005\052\061\021\048\016\052\067\048\119")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.MessageBox{
			Text = _vHmo("\010\031\115\119\052\036\082\115\118\076\048\118\042\048\003\076\031\073\118\085\052\003\031\012"), 
			Buttons = {
				_vHmo("\023\003\082\118\076\048\118\080\052\016\048\119\031\016\076\082\118\085\052\003")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _4dE:On_pqSd(target)
	if (((zoneA:Contains(Player) or zoneB:Contains(Player)) or zoneE:Contains(Player)) or zoneC:Contains(Player)) or zoneD:Contains(Player) then
		_4dE.Commands._pqSd.Enabled = false
		_BOC4 = true
		_tsDe()
		_FiYu()
		_Urwigo.Dialog(false, {
			{
				Text = _vHmo("\100\048\016\048\046\118\036\115\082\118\061\021\031\115\046\082\119\118\003\052\073\031\016\031\061\118\036\031\003\076\082\073\118\119\048\071\031\073\012\043\057\089\112\010\107\076\082\118\115\031\118\119\067\001\036\118\080\052\071\107\085\118\073\031\042\082\118\036\031\003\076\052\119\046\082\067\107\073\082\118\085\052\003\107\118\042\048\042\076\048\073\031\076\048\067\048\118\036\048\061\052\118\061\021\031\115\046\031\076\082\118\036\031\003\076\082\073\118\119\048\071\031\073\012")
			}, 
			{
				Text = _vHmo("\051\061\119\001\048\046\076\031\118\073\048\115\118\076\048\061\021\031\115\046\031\076\052\078\118").._9Xug1, 
				Media = _bcc4j, 
				Buttons = {
					_vHmo("\005\052\061\021\048\016\052\067\048\119")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.MessageBox{
			Text = _vHmo("\010\031\115\119\052\036\082\115\118\076\048\118\042\048\003\076\031\073\118\085\052\003\031\012"), 
			Buttons = {
				_vHmo("\023\003\082\118\076\048\118\080\052\016\048\119\031\016\076\082\118\085\052\003")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end

-- Urwigo functions --
function _tsDe()
	if zoneA:Contains(Player) then
		_MkI = _vHmo("\051")
	elseif zoneB:Contains(Player) then
		_MkI = _vHmo("\057")
	elseif zoneE:Contains(Player) then
		_MkI = _vHmo("\126")
	elseif zoneC:Contains(Player) then
		_MkI = _vHmo("\124")
	elseif zoneD:Contains(Player) then
		_MkI = _vHmo("\025")
	end
end
function _FiYu()
	if _MKzn == true then
		_F06 = _F06.._MkI
		_4_g.Description = _F06
	elseif _j1yR == true then
		_HWVYQ = _HWVYQ.._MkI
		_ZIr.Description = _HWVYQ
	elseif _BOC4 == true then
		_9Xug1 = _9Xug1.._MkI
		_b7E.Description = _9Xug1
	end
end
function _SzgZ()
	_ekAw_ = _cW5.._MkI
	if Wherigo.NoCaseEquals(_ekAw_, _vHmo("\051\057")) or Wherigo.NoCaseEquals(_ekAw_, _vHmo("\057\051")) then
		if _AJzF1 == false then
			_AJzF1 = true
			_pn2k()
		else
			_xyTj()
		end
	elseif Wherigo.NoCaseEquals(_ekAw_, _vHmo("\051\124")) or Wherigo.NoCaseEquals(_ekAw_, _vHmo("\124\051")) then
		if _h6OV == false then
			_h6OV = true
			_pn2k()
		else
			_xyTj()
		end
	elseif Wherigo.NoCaseEquals(_ekAw_, _vHmo("\051\126")) or Wherigo.NoCaseEquals(_ekAw_, _vHmo("\126\051")) then
		if _qiZe == false then
			_qiZe = true
			_pn2k()
		else
			_xyTj()
		end
	elseif Wherigo.NoCaseEquals(_ekAw_, _vHmo("\057\126")) or Wherigo.NoCaseEquals(_ekAw_, _vHmo("\126\057")) then
		if _ZdT == false then
			_ZdT = true
			_pn2k()
		else
			_xyTj()
		end
	elseif Wherigo.NoCaseEquals(_ekAw_, _vHmo("\057\124")) or Wherigo.NoCaseEquals(_ekAw_, _vHmo("\124\057")) then
		if _RYz == false then
			_RYz = true
			_pn2k()
		else
			_xyTj()
		end
	elseif Wherigo.NoCaseEquals(_ekAw_, _vHmo("\126\124")) or Wherigo.NoCaseEquals(_ekAw_, _vHmo("\124\126")) then
		if _6nbTS == false then
			_6nbTS = true
			_pn2k()
		else
			_xyTj()
		end
	elseif Wherigo.NoCaseEquals(_ekAw_, _vHmo("\126\025")) or Wherigo.NoCaseEquals(_ekAw_, _vHmo("\025\126")) then
		if _LJ3 == false then
			_LJ3 = true
			_pn2k()
		else
			_xyTj()
		end
	elseif Wherigo.NoCaseEquals(_ekAw_, _vHmo("\124\025")) or Wherigo.NoCaseEquals(_ekAw_, _vHmo("\025\124")) then
		if _jNMx == false then
			_jNMx = true
			_pn2k()
		else
			_xyTj()
		end
	end
end
function _pn2k()
	if (((((((_AJzF1 == true) and (_h6OV == true)) and (_qiZe == true)) and (_ZdT == true)) and (_RYz == true)) and (_6nbTS == true)) and (_LJ3 == true)) and (_jNMx == true) then
		_HEJ()
		if _MKzn == true then
			_MKzn = false
			_4dE.Commands._TY_q.Enabled = true
			_4_g.Complete = true
			_ZIr.Active = true
			_Urwigo.Dialog(false, {
				{
					Text = _vHmo("\065\021\048\119\001\046\001\036\082\118\061\118\099\012\118\115\080\021\048\067\076\031\073\001\118\021\031\115\031\076\082\012")
				}, 
				{
					Text = _vHmo("\010\107\076\082\118\115\031\118\073\001\042\031\115\118\080\001\115\119\082\119\118\003\052\118\076\048\046\031\042\031\076\082\118\003\021\001\071\031\071\052\118\021\031\115\031\076\082\012")
				}, 
				{
					Text = _vHmo("\005\021\031\115\001\076\118\115\031\118\003\052\118\085\052\003\001\118\067\031\118\061\119\031\021\031\073\118\016\071\016\031\115\118\042\048\016\082\119\118\061\021\031\115\046\082\119\118\003\052\073\031\016\031\061\118\036\031\003\076\082\073\118\119\048\071\031\073\118\048\118\080\052\001\042\082\036\118\119\001\042\061\001\012"), 
					Media = _bcc4j, 
					Buttons = {
						_vHmo("\023\003\082\118\076\048\118\042\048\016\048\119\031\061")
					}
				}
			}, function(action)
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end)
		elseif _j1yR == true then
			if Wherigo.NoCaseEquals(_F06, _HWVYQ) then
				_xyTj()
			else
				_j1yR = false
				_4dE.Commands._pqSd.Enabled = true
				_ZIr.Complete = true
				_b7E.Active = true
				_Urwigo.Dialog(false, {
					{
						Text = _vHmo("\065\021\048\119\001\046\001\036\082\118\061\118\079\012\118\115\080\021\048\067\076\031\073\001\118\021\031\115\031\076\082\012")
					}, 
					{
						Text = _vHmo("\010\107\076\082\118\119\082\118\036\082\042\118\042\085\107\067\048\118\076\048\046\031\042\119\118\080\052\115\046\031\003\076\082\118\021\031\115\031\076\082\012")
					}, 
					{
						Text = _vHmo("\005\021\031\115\001\076\118\115\031\118\003\052\118\085\052\003\001\118\067\031\118\061\119\031\021\031\073\118\016\071\016\031\115\118\042\048\016\082\119\118\061\021\031\115\046\082\119\118\003\052\073\031\016\031\061\118\036\031\003\076\082\073\118\119\048\071\031\073\118\048\118\080\052\001\042\082\036\118\119\001\042\061\001\012"), 
						Media = _bcc4j, 
						Buttons = {
							_vHmo("\023\003\082\118\076\048\118\042\048\016\048\119\031\061")
						}
					}
				}, function(action)
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end)
			end
		elseif _BOC4 == true then
			if Wherigo.NoCaseEquals(_9Xug1, _HWVYQ) or Wherigo.NoCaseEquals(_9Xug1, _F06) then
				_xyTj()
			else
				_BOC4 = false
				_4dE:MoveTo(nil)
				_b7E.Complete = true
				zoneA.Active = false
				zoneB.Active = false
				zoneE.Active = false
				zoneC.Active = false
				zoneD.Active = false
				_Urwigo.Dialog(false, {
					{
						Text = _vHmo("\065\021\048\119\001\046\001\036\082\118\061\118\084\012\118\115\080\021\048\067\076\031\073\001\118\021\031\115\031\076\082\012")
					}, 
					{
						Text = _vHmo("\010\107\076\082\118\073\001\042\031\115\118\036\082\042\118\067\107\021\048\042\082\119\118\071\046\031\003\048\119\118\016\048\016\071\031\012"), 
						Buttons = {
							_vHmo("\041\059\063\100\034\050\118\055\089\041")
						}
					}
				}, function(action)
					_hZRKU:RequestSync()
					_24t()
				end)
			end
		end
	else
		_RiKuj()
	end
end
function _xyTj()
	_HEJ()
	if _MKzn == true then
		_4_g.Description = ""
		_F06 = ""
		_MKzn = false
		_4dE.Commands.__hO1.Enabled = true
	elseif _j1yR == true then
		_ZIr.Description = ""
		_HWVYQ = ""
		_j1yR = false
		_4dE.Commands._TY_q.Enabled = true
	elseif _BOC4 == true then
		_b7E.Description = ""
		_9Xug1 = ""
		_BOC4 = false
		_4dE.Commands._pqSd.Enabled = true
	end
	_Urwigo.Dialog(false, {
		{
			Text = _vHmo("\041\003\031\046\048\046\118\036\115\082\118\016\071\107\085\001\118\076\031\085\052\118\076\048\061\021\031\115\082\046\118\003\052\073\031\016\031\061\118\115\119\031\036\076\031\118\036\048\061\052\118\067\118\080\021\031\003\016\071\052\042\082\073\118\021\031\115\031\076\082\012\043\057\089\112\090\118\048\061\119\001\048\046\076\082\073\118\021\031\115\031\076\082\073\118\073\001\115\082\115\118\042\048\016\082\119\118\042\076\052\067\001\012")
		}, 
		{
			Text = _vHmo("\005\021\031\115\001\076\118\115\031\118\003\052\118\085\052\003\001\118\067\031\118\061\119\031\021\031\073\118\016\071\016\031\115\118\042\048\016\082\119\118\061\021\031\115\046\082\119\118\003\052\073\031\016\031\061\118\036\031\003\076\082\073\118\119\048\071\031\073\118\048\118\080\052\001\042\082\036\118\119\001\042\061\001\012")
		}, 
		{
			Text = _vHmo("\124\052\080\052\021\001\016\001\036\082\118\042\048\016\082\119\118\067\118\085\052\003\031\118\051\118\076\031\085\052\118\067\118\085\052\003\031\118\057\012"), 
			Buttons = {
				_vHmo("\023\082\119\118\003\052\118\067\107\016\071\052\042\082\071\052\118\085\052\003\001")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _ph0L()
	if ((_MKzn == true) or (_j1yR == true)) or (_BOC4 == true) then
		_cW5 = _MkI
		_tsDe()
		if Wherigo.NoCaseEquals(_MkI, _cW5) then
			_Urwigo.MessageBox{
				Text = _vHmo("\006\119\048\119\082\046\118\036\115\082\118\115\031\118\003\052\118\085\052\003\001\118").._MkI, 
				Buttons = {
					_vHmo("\005\052\061\021\048\016\052\067\048\119")
				}, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			}
		else
			_FiYu()
			_SzgZ()
		end
	else
	end
end
function _HEJ()
	_AJzF1 = false
	_h6OV = false
	_qiZe = false
	_ZdT = false
	_RYz = false
	_6nbTS = false
	_LJ3 = false
	_jNMx = false
end
function _RiKuj()
	if _MKzn == true then
		_Urwigo.MessageBox{
			Text = _vHmo("\051\061\119\001\048\046\076\031\118\073\048\115\118\076\048\061\021\031\115\046\031\076\052\078\118").._F06, 
			Media = _bcc4j, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _j1yR == true then
		_Urwigo.MessageBox{
			Text = _vHmo("\051\061\119\001\048\046\076\031\118\073\048\115\118\076\048\061\021\031\115\046\031\076\052\078\118").._HWVYQ, 
			Media = _bcc4j, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _BOC4 == true then
		_Urwigo.MessageBox{
			Text = _vHmo("\051\061\119\001\048\046\076\031\118\073\048\115\118\076\048\061\021\031\115\046\031\076\052\078\118").._9Xug1, 
			Media = _bcc4j, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _24t()
	nasobic = string.sub(gckod, 3, 3)
	nasobic = tonumber(nasobic..(string.sub(gckod, 5, 5)))
	nsouradnice = 1.55934009375 * nasobic
	esouradnice = 452.525856 / nasobic
	pomocnaB.Visible = true
	CenterZoneOnPoint(pomocnaB, ZonePoint(nsouradnice,esouradnice,0), 7)
	_nMxZ2.Active = true
	_iFwRc.Visible = true
	_Urwigo.MessageBox{
		Text = _vHmo("\057\107\046\048\118\052\003\061\021\107\119\048\118\042\052\076\048\118\126\051\126\055\025\012\118"), 
		Buttons = {
			_vHmo("\010\051\006\034\065\063\006\051\050")
		}, 
		Callback = function(action)
			if action ~= nil then
				_hZRKU:RequestSync()
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, pomocnaB)
			end
		end
	}
end

-- Begin user functions --
function CenterZoneOnPoint(zZone, point, ZoneRadius)
  local dist = Wherigo.Distance(0, 'ft')
  local newZp = Wherigo.TranslatePoint(point, dist, 0)   -- new center point for the new zone    
  dist = Wherigo.Distance(ZoneRadius, 'm')
  local pts = {
    Wherigo.TranslatePoint(newZp, dist, 0),
    Wherigo.TranslatePoint(newZp, dist, 45),
    Wherigo.TranslatePoint(newZp, dist, 90),
    Wherigo.TranslatePoint(newZp, dist, 135),
    Wherigo.TranslatePoint(newZp, dist, 180),
    Wherigo.TranslatePoint(newZp, dist, 225),
    Wherigo.TranslatePoint(newZp, dist, 270),
    Wherigo.TranslatePoint(newZp, dist, 315),
  }

  zZone.Active = false
  zZone.OriginalPoint.latitude = newZp.latitude
  zZone.OriginalPoint.longitude = newZp.longitude

  zZone.Points = pts
  zZone.Active = true
end

function BuildHouse(pointA, pointB, zoneA, zoneB, zoneC, zoneD, zoneE, zoneRadius)
  print(pointA)
  print(pointB)
  CenterZoneOnPoint(zoneA, pointA, zoneRadius)
  CenterZoneOnPoint(zoneB, pointB, zoneRadius)
  local dist, bearing = Wherigo.VectorToPoint(pointA, pointB)
  local dist2 = Wherigo.Distance(dist.value * 0.7071, dist.units)
  local pointC = Wherigo.TranslatePoint(pointB, dist, bearing - 90)
  CenterZoneOnPoint(zoneC, pointC, zoneRadius)
  local pointD = Wherigo.TranslatePoint(pointC, dist2, bearing - 135)
  CenterZoneOnPoint(zoneD, pointD, zoneRadius)
  local pointE = Wherigo.TranslatePoint(pointC, dist, bearing - 180)
  CenterZoneOnPoint(zoneE, pointE, zoneRadius)
end
-- End user functions --
return _hZRKU
