require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _XiCk1(str)
	local res = ""
    local dtable = "\024\085\110\055\108\109\119\056\090\106\048\036\040\063\031\023\104\083\102\120\069\087\032\095\011\111\041\126\035\125\118\100\116\004\008\091\012\019\066\077\025\076\038\060\047\018\093\068\105\080\016\073\049\027\071\051\046\005\001\088\053\014\058\115\009\045\029\039\086\117\067\074\114\078\113\112\000\084\037\101\099\042\096\020\044\061\089\081\082\052\059\030\010\098\028\065\103\003\062\092\026\094\017\022\075\122\034\123\121\070\015\007\057\033\107\079\002\072\006\064\043\097\021\054\050\013\124"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

cartLegendsofSLAGA = Wherigo.ZCartridge()

-- Media --
zmedia029e81d04655454f9566dde1af9803a7 = Wherigo.ZMedia(cartLegendsofSLAGA)
zmedia029e81d04655454f9566dde1af9803a7.Id = "7fe15fb1-8519-4cf7-ac8c-a95c6ce8097c"
zmedia029e81d04655454f9566dde1af9803a7.Name = _XiCk1("\011\125\113\080\008\053\032\011\090\124\061\061\090\061\090\019\113\061\124\124\032\032\080\053\122\019\113\008\011\056\122\004")
zmedia029e81d04655454f9566dde1af9803a7.Description = _XiCk1("\006\080\032\049\122")
zmedia029e81d04655454f9566dde1af9803a7.AltText = ""
zmedia029e81d04655454f9566dde1af9803a7.Resources = {
	{
		Type = "jpg", 
		Filename = "029e81d0-4655-454f-9566-dde1af9803a7.jpg", 
		Directives = {}
	}
}
_HxRF = Wherigo.ZMedia(cartLegendsofSLAGA)
_HxRF.Id = "f963e72d-308f-42f4-84cf-91b19db41a37"
_HxRF.Name = _XiCk1("\007\017\080\073\049\097\026")
_HxRF.Description = ""
_HxRF.AltText = ""
_HxRF.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo_icon.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
cartLegendsofSLAGA.Id="b029170a-fba7-4f9b-8743-f3dc4243ff0a"
cartLegendsofSLAGA.Name="Legends of SLAGA"
cartLegendsofSLAGA.Description=[[The Legends of SLAGA wherigo geoart series. This series of 28 caches covers the history of SLAGA from 2001-2016. ]]
cartLegendsofSLAGA.Visible=true
cartLegendsofSLAGA.Activity="Puzzle"
cartLegendsofSLAGA.StartingLocationDescription=[[]]
cartLegendsofSLAGA.StartingLocation = ZonePoint(38.5287,-90.4356333333333,0)
cartLegendsofSLAGA.Version="0.01"
cartLegendsofSLAGA.Company=""
cartLegendsofSLAGA.Author="Cachin Hounds"
cartLegendsofSLAGA.BuilderVersion="URWIGO 1.22.5798.37755"
cartLegendsofSLAGA.CreateDate="04/28/2016 02:59:13"
cartLegendsofSLAGA.PublishDate="1/1/0001 12:00:00 AM"
cartLegendsofSLAGA.UpdateDate="05/12/2016 15:31:57"
cartLegendsofSLAGA.LastPlayedDate="1/1/0001 12:00:00 AM"
cartLegendsofSLAGA.TargetDevice="PocketPC"
cartLegendsofSLAGA.TargetDeviceVersion="0"
cartLegendsofSLAGA.StateId="1"
cartLegendsofSLAGA.CountryId="2"
cartLegendsofSLAGA.Complete=false
cartLegendsofSLAGA.UseLogging=true

cartLegendsofSLAGA.Media=zmedia029e81d04655454f9566dde1af9803a7

cartLegendsofSLAGA.Icon=_HxRF


-- Zones --
zone1 = Wherigo.Zone(cartLegendsofSLAGA)
zone1.Id = "1e96c36e-79e8-4989-aec2-853fade6cb46"
zone1.Name = _XiCk1("\053")
zone1.Description = _XiCk1("\074\023\056\008\023\056\053\057\004\125\125\023\022\023\113\011\023\125\124\057\053\056\008")
zone1.Visible = true
zone1.Media = zmedia029e81d04655454f9566dde1af9803a7
zone1.Commands = {}
zone1.DistanceRange = Distance(-1, "feet")
zone1.ShowObjects = "OnEnter"
zone1.ProximityRange = Distance(8, "meters")
zone1.AllowSetPositionTo = false
zone1.Active = false
zone1.Points = {
	ZonePoint(38.528735, -90.4355983333333, 0), 
	ZonePoint(38.528735, -90.4356683333333, 0), 
	ZonePoint(38.528665, -90.4356683333333, 0), 
	ZonePoint(38.528665, -90.4355983333333, 0)
}
zone1.OriginalPoint = ZonePoint(38.5287, -90.4356333333333, 0)
zone1.DistanceRangeUOM = "Feet"
zone1.ProximityRangeUOM = "Meters"
zone1.OutOfRangeName = ""
zone1.InRangeName = ""
zone2 = Wherigo.Zone(cartLegendsofSLAGA)
zone2.Id = "9f22f7da-8ac6-4c38-89e6-61caea58b18a"
zone2.Name = _XiCk1("\125")
zone2.Description = _XiCk1("\074\056\008\023\056\053\057\113\053\004\023\043\003\094\064\076\091\022\011\113\011\023\125\124\057\053\056\004")
zone2.Visible = true
zone2.Media = zmedia029e81d04655454f9566dde1af9803a7
zone2.Commands = {}
zone2.DistanceRange = Distance(-1, "feet")
zone2.ShowObjects = "OnEnter"
zone2.ProximityRange = Distance(8, "meters")
zone2.AllowSetPositionTo = false
zone2.Active = false
zone2.Points = {
	ZonePoint(38.531985, -90.4355816666667, 0), 
	ZonePoint(38.531985, -90.4356516666667, 0), 
	ZonePoint(38.531915, -90.4356516666667, 0), 
	ZonePoint(38.531915, -90.4355816666667, 0)
}
zone2.OriginalPoint = ZonePoint(38.53195, -90.4356166666667, 0)
zone2.DistanceRangeUOM = "Feet"
zone2.ProximityRangeUOM = "Meters"
zone2.OutOfRangeName = ""
zone2.InRangeName = ""
zone3 = Wherigo.Zone(cartLegendsofSLAGA)
zone3.Id = "96b81d67-69d5-4aa7-a0b3-c41432bc3275"
zone3.Name = _XiCk1("\056")
zone3.Description = _XiCk1("\074\056\008\023\056\125\057\011\053\004\023\043\003\094\064\076\091\022\011\113\011\023\125\124\057\053\090\053")
zone3.Visible = true
zone3.Media = zmedia029e81d04655454f9566dde1af9803a7
zone3.Commands = {}
zone3.DistanceRange = Distance(-1, "feet")
zone3.ShowObjects = "OnEnter"
zone3.ProximityRange = Distance(8, "meters")
zone3.AllowSetPositionTo = false
zone3.Active = false
zone3.Points = {
	ZonePoint(38.5336516666667, -90.4356483333333, 0), 
	ZonePoint(38.5336516666667, -90.4357183333333, 0), 
	ZonePoint(38.5335816666667, -90.4357183333333, 0), 
	ZonePoint(38.5335816666667, -90.4356483333333, 0)
}
zone3.OriginalPoint = ZonePoint(38.5336166666667, -90.4356833333333, 0)
zone3.DistanceRangeUOM = "Feet"
zone3.ProximityRangeUOM = "Meters"
zone3.OutOfRangeName = ""
zone3.InRangeName = ""
zone4 = Wherigo.Zone(cartLegendsofSLAGA)
zone4.Id = "101efd5f-5233-4f5c-a9ab-0bb59c55629a"
zone4.Name = _XiCk1("\090")
zone4.Description = _XiCk1("\074\056\008\023\056\125\057\053\011\124\023\043\003\094\064\076\091\022\011\113\011\023\125\124\057\053\056\061")
zone4.Visible = true
zone4.Media = zmedia029e81d04655454f9566dde1af9803a7
zone4.Commands = {}
zone4.DistanceRange = Distance(-1, "feet")
zone4.ShowObjects = "OnEnter"
zone4.ProximityRange = Distance(8, "meters")
zone4.AllowSetPositionTo = false
zone4.Active = false
zone4.Points = {
	ZonePoint(38.535135, -90.4355483333333, 0), 
	ZonePoint(38.535135, -90.4356183333333, 0), 
	ZonePoint(38.535065, -90.4356183333333, 0), 
	ZonePoint(38.535065, -90.4355483333333, 0)
}
zone4.OriginalPoint = ZonePoint(38.5351, -90.4355833333333, 0)
zone4.DistanceRangeUOM = "Feet"
zone4.ProximityRangeUOM = "Meters"
zone4.OutOfRangeName = ""
zone4.InRangeName = ""
zone5 = Wherigo.Zone(cartLegendsofSLAGA)
zone5.Id = "809693ad-a67f-40ab-9f64-a271ab2c16d7"
zone5.Name = _XiCk1("\061")
zone5.Description = _XiCk1("\074\056\008\023\056\056\057\056\090\008\023\043\003\094\064\076\091\022\011\113\011\023\125\124\057\090\061\124")
zone5.Visible = true
zone5.Media = zmedia029e81d04655454f9566dde1af9803a7
zone5.Commands = {}
zone5.DistanceRange = Distance(-1, "feet")
zone5.ShowObjects = "OnEnter"
zone5.ProximityRange = Distance(8, "meters")
zone5.AllowSetPositionTo = false
zone5.Active = false
zone5.Points = {
	ZonePoint(38.555835, -90.4408983333333, 0), 
	ZonePoint(38.555835, -90.4409683333333, 0), 
	ZonePoint(38.555765, -90.4409683333333, 0), 
	ZonePoint(38.555765, -90.4408983333333, 0)
}
zone5.OriginalPoint = ZonePoint(38.5558, -90.4409333333333, 0)
zone5.DistanceRangeUOM = "Feet"
zone5.ProximityRangeUOM = "Meters"
zone5.OutOfRangeName = ""
zone5.InRangeName = ""
zone6 = Wherigo.Zone(cartLegendsofSLAGA)
zone6.Id = "2e5424e3-7e00-4a7b-abda-eb726fb61b08"
zone6.Name = _XiCk1("\124")
zone6.Description = _XiCk1("\074\056\008\023\056\056\057\090\125\125\023\043\003\094\064\076\091\022\011\113\011\023\125\124\057\061\056\004")
zone6.Visible = true
zone6.Media = zmedia029e81d04655454f9566dde1af9803a7
zone6.Commands = {}
zone6.DistanceRange = Distance(-1, "feet")
zone6.ShowObjects = "OnEnter"
zone6.ProximityRange = Distance(8, "meters")
zone6.AllowSetPositionTo = false
zone6.Active = false
zone6.Points = {
	ZonePoint(38.5570683333333, -90.4422483333333, 0), 
	ZonePoint(38.5570683333333, -90.4423183333333, 0), 
	ZonePoint(38.5569983333333, -90.4423183333333, 0), 
	ZonePoint(38.5569983333333, -90.4422483333333, 0)
}
zone6.OriginalPoint = ZonePoint(38.5570333333333, -90.4422833333333, 0)
zone6.DistanceRangeUOM = "Feet"
zone6.ProximityRangeUOM = "Meters"
zone6.OutOfRangeName = ""
zone6.InRangeName = ""
zone7 = Wherigo.Zone(cartLegendsofSLAGA)
zone7.Id = "25982392-6aab-4170-b22d-44fbba790c45"
zone7.Name = _XiCk1("\004")
zone7.Description = _XiCk1("\074\056\008\023\056\056\057\090\004\011\023\043\003\094\064\076\091\022\011\113\011\023\125\124\057\124\056\053")
zone7.Visible = true
zone7.Media = zmedia029e81d04655454f9566dde1af9803a7
zone7.Commands = {}
zone7.DistanceRange = Distance(-1, "feet")
zone7.ShowObjects = "OnEnter"
zone7.ProximityRange = Distance(8, "meters")
zone7.AllowSetPositionTo = false
zone7.Active = false
zone7.Points = {
	ZonePoint(38.5578683333333, -90.443815, 0), 
	ZonePoint(38.5578683333333, -90.443885, 0), 
	ZonePoint(38.5577983333333, -90.443885, 0), 
	ZonePoint(38.5577983333333, -90.443815, 0)
}
zone7.OriginalPoint = ZonePoint(38.5578333333333, -90.44385, 0)
zone7.DistanceRangeUOM = "Feet"
zone7.ProximityRangeUOM = "Meters"
zone7.OutOfRangeName = ""
zone7.InRangeName = ""
zone8 = Wherigo.Zone(cartLegendsofSLAGA)
zone8.Id = "a7cfb6d4-e8d1-4dbe-b372-55df97b6753c"
zone8.Name = _XiCk1("\008")
zone8.Description = _XiCk1("\074\056\008\023\056\056\057\056\004\061\023\043\003\094\064\076\091\022\011\113\011\023\125\124\057\004\090\056")
zone8.Visible = true
zone8.Media = zmedia029e81d04655454f9566dde1af9803a7
zone8.Commands = {}
zone8.DistanceRange = Distance(-1, "feet")
zone8.ShowObjects = "OnEnter"
zone8.ProximityRange = Distance(8, "meters")
zone8.AllowSetPositionTo = false
zone8.Active = false
zone8.Points = {
	ZonePoint(38.556285, -90.4456816666667, 0), 
	ZonePoint(38.556285, -90.4457516666667, 0), 
	ZonePoint(38.556215, -90.4457516666667, 0), 
	ZonePoint(38.556215, -90.4456816666667, 0)
}
zone8.OriginalPoint = ZonePoint(38.55625, -90.4457166666667, 0)
zone8.DistanceRangeUOM = "Feet"
zone8.ProximityRangeUOM = "Meters"
zone8.OutOfRangeName = ""
zone8.InRangeName = ""
zone9 = Wherigo.Zone(cartLegendsofSLAGA)
zone9.Id = "2ec3be78-b582-4ea1-888a-9784a1e5aab1"
zone9.Name = _XiCk1("\113")
zone9.Description = _XiCk1("\074\056\008\023\056\125\057\004\053\053\023\043\003\094\064\076\091\022\011\113\023\125\008\057\090\008\053")
zone9.Visible = true
zone9.Media = zmedia029e81d04655454f9566dde1af9803a7
zone9.Commands = {}
zone9.DistanceRange = Distance(-1, "feet")
zone9.ShowObjects = "OnEnter"
zone9.ProximityRange = Distance(8, "meters")
zone9.AllowSetPositionTo = false
zone9.Active = false
zone9.Points = {
	ZonePoint(38.5452183333333, -90.4746483333333, 0), 
	ZonePoint(38.5452183333333, -90.4747183333333, 0), 
	ZonePoint(38.5451483333333, -90.4747183333333, 0), 
	ZonePoint(38.5451483333333, -90.4746483333333, 0)
}
zone9.OriginalPoint = ZonePoint(38.5451833333333, -90.4746833333333, 0)
zone9.DistanceRangeUOM = "Feet"
zone9.ProximityRangeUOM = "Meters"
zone9.OutOfRangeName = ""
zone9.InRangeName = ""
zone10 = Wherigo.Zone(cartLegendsofSLAGA)
zone10.Id = "d30be211-40d3-43d0-8a02-764dde01b93d"
zone10.Name = _XiCk1("\053\011")
zone10.Description = _XiCk1("\074\056\008\023\056\125\057\008\061\008\023\043\003\094\064\076\091\022\011\113\011\023\125\008\057\056\056\113")
zone10.Visible = true
zone10.Media = zmedia029e81d04655454f9566dde1af9803a7
zone10.Commands = {}
zone10.DistanceRange = Distance(-1, "feet")
zone10.ShowObjects = "OnEnter"
zone10.ProximityRange = Distance(8, "meters")
zone10.AllowSetPositionTo = false
zone10.Active = false
zone10.Points = {
	ZonePoint(38.5476683333333, -90.4722816666667, 0), 
	ZonePoint(38.5476683333333, -90.4723516666667, 0), 
	ZonePoint(38.5475983333333, -90.4723516666667, 0), 
	ZonePoint(38.5475983333333, -90.4722816666667, 0)
}
zone10.OriginalPoint = ZonePoint(38.5476333333333, -90.4723166666667, 0)
zone10.DistanceRangeUOM = "Feet"
zone10.ProximityRangeUOM = "Meters"
zone10.OutOfRangeName = ""
zone10.InRangeName = ""
zone11 = Wherigo.Zone(cartLegendsofSLAGA)
zone11.Id = "57a8b850-942a-4ad8-b951-5dde6d4667da"
zone11.Name = _XiCk1("\053\053")
zone11.Description = _XiCk1("\074\056\008\023\056\125\057\113\011\113\023\043\003\094\064\076\091\022\011\113\011\023\125\008\057\125\090\061")
zone11.Visible = true
zone11.Media = zmedia029e81d04655454f9566dde1af9803a7
zone11.Commands = {}
zone11.DistanceRange = Distance(-1, "feet")
zone11.ShowObjects = "OnEnter"
zone11.ProximityRange = Distance(8, "meters")
zone11.AllowSetPositionTo = false
zone11.Active = false
zone11.Points = {
	ZonePoint(38.5485183333333, -90.470715, 0), 
	ZonePoint(38.5485183333333, -90.470785, 0), 
	ZonePoint(38.5484483333333, -90.470785, 0), 
	ZonePoint(38.5484483333333, -90.470715, 0)
}
zone11.OriginalPoint = ZonePoint(38.5484833333333, -90.47075, 0)
zone11.DistanceRangeUOM = "Feet"
zone11.ProximityRangeUOM = "Meters"
zone11.OutOfRangeName = ""
zone11.InRangeName = ""
zone12 = Wherigo.Zone(cartLegendsofSLAGA)
zone12.Id = "427f058d-bc0e-42a9-8689-86c68961113d"
zone12.Name = _XiCk1("\053\125")
zone12.Description = _XiCk1("\074\056\008\023\056\056\057\011\053\011\023\043\003\094\064\076\091\022\011\113\011\023\125\008\057\011\008\004")
zone12.Visible = true
zone12.Media = zmedia029e81d04655454f9566dde1af9803a7
zone12.Commands = {}
zone12.DistanceRange = Distance(-1, "feet")
zone12.ShowObjects = "OnEnter"
zone12.ProximityRange = Distance(8, "meters")
zone12.AllowSetPositionTo = false
zone12.Active = false
zone12.Points = {
	ZonePoint(38.5502016666667, -90.4680816666667, 0), 
	ZonePoint(38.5502016666667, -90.4681516666667, 0), 
	ZonePoint(38.5501316666667, -90.4681516666667, 0), 
	ZonePoint(38.5501316666667, -90.4680816666667, 0)
}
zone12.OriginalPoint = ZonePoint(38.5501666666667, -90.4681166666667, 0)
zone12.DistanceRangeUOM = "Feet"
zone12.ProximityRangeUOM = "Meters"
zone12.OutOfRangeName = ""
zone12.InRangeName = ""
zone13 = Wherigo.Zone(cartLegendsofSLAGA)
zone13.Id = "ca4acb07-0536-4967-931c-523a342040bf"
zone13.Name = _XiCk1("\053\056")
zone13.Description = _XiCk1("\074\056\008\023\056\056\057\011\056\053\023\043\003\094\064\076\091\022\011\113\011\023\125\004\057\113\124\056")
zone13.Visible = true
zone13.Media = zmedia029e81d04655454f9566dde1af9803a7
zone13.Commands = {}
zone13.DistanceRange = Distance(-1, "feet")
zone13.ShowObjects = "OnEnter"
zone13.ProximityRange = Distance(8, "meters")
zone13.AllowSetPositionTo = false
zone13.Active = false
zone13.Points = {
	ZonePoint(38.5505516666667, -90.466015, 0), 
	ZonePoint(38.5505516666667, -90.466085, 0), 
	ZonePoint(38.5504816666667, -90.466085, 0), 
	ZonePoint(38.5504816666667, -90.466015, 0)
}
zone13.OriginalPoint = ZonePoint(38.5505166666667, -90.46605, 0)
zone13.DistanceRangeUOM = "Feet"
zone13.ProximityRangeUOM = "Meters"
zone13.OutOfRangeName = ""
zone13.InRangeName = ""
zone14 = Wherigo.Zone(cartLegendsofSLAGA)
zone14.Id = "ffc5ab71-45d1-4a4f-8f7a-ed8195665b73"
zone14.Name = _XiCk1("\053\090")
zone14.Description = _XiCk1("\074\056\008\023\056\056\057\011\008\053\023\043\003\094\064\076\091\022\011\113\011\023\125\004\057\008\061\061")
zone14.Visible = true
zone14.Media = zmedia029e81d04655454f9566dde1af9803a7
zone14.Commands = {}
zone14.DistanceRange = Distance(-1, "feet")
zone14.ShowObjects = "OnEnter"
zone14.ProximityRange = Distance(8, "meters")
zone14.AllowSetPositionTo = false
zone14.Active = false
zone14.Points = {
	ZonePoint(38.551385, -90.464215, 0), 
	ZonePoint(38.551385, -90.464285, 0), 
	ZonePoint(38.551315, -90.464285, 0), 
	ZonePoint(38.551315, -90.464215, 0)
}
zone14.OriginalPoint = ZonePoint(38.55135, -90.46425, 0)
zone14.DistanceRangeUOM = "Feet"
zone14.ProximityRangeUOM = "Meters"
zone14.OutOfRangeName = ""
zone14.InRangeName = ""
zone15 = Wherigo.Zone(cartLegendsofSLAGA)
zone15.Id = "74af8dbb-0135-4112-8619-e79f2ba83f25"
zone15.Name = _XiCk1("\053\061")
zone15.Description = _XiCk1("\074\023\056\008\023\056\056\057\053\090\124\023\022\023\113\011\023\125\004\057\124\113\056")
zone15.Visible = true
zone15.Media = zmedia029e81d04655454f9566dde1af9803a7
zone15.Commands = {}
zone15.DistanceRange = Distance(-1, "feet")
zone15.ShowObjects = "OnEnter"
zone15.ProximityRange = Distance(8, "meters")
zone15.AllowSetPositionTo = false
zone15.Active = false
zone15.Points = {
	ZonePoint(38.5524683333333, -90.461515, 0), 
	ZonePoint(38.5524683333333, -90.461585, 0), 
	ZonePoint(38.5523983333333, -90.461585, 0), 
	ZonePoint(38.5523983333333, -90.461515, 0)
}
zone15.OriginalPoint = ZonePoint(38.5524333333333, -90.46155, 0)
zone15.DistanceRangeUOM = "Feet"
zone15.ProximityRangeUOM = "Meters"
zone15.OutOfRangeName = ""
zone15.InRangeName = ""
zone16 = Wherigo.Zone(cartLegendsofSLAGA)
zone16.Id = "a35aa3db-a291-4cdf-b8cc-254d21f95e3e"
zone16.Name = _XiCk1("\053\124")
zone16.Description = _XiCk1("\074\056\008\023\056\056\057\053\004\053\023\043\003\094\064\076\091\022\011\113\011\023\125\004\057\061\113\125")
zone16.Visible = true
zone16.Media = zmedia029e81d04655454f9566dde1af9803a7
zone16.Commands = {}
zone16.DistanceRange = Distance(-1, "feet")
zone16.ShowObjects = "OnEnter"
zone16.ProximityRange = Distance(8, "meters")
zone16.AllowSetPositionTo = false
zone16.Active = false
zone16.Points = {
	ZonePoint(38.552885, -90.4598316666667, 0), 
	ZonePoint(38.552885, -90.4599016666667, 0), 
	ZonePoint(38.552815, -90.4599016666667, 0), 
	ZonePoint(38.552815, -90.4598316666667, 0)
}
zone16.OriginalPoint = ZonePoint(38.55285, -90.4598666666667, 0)
zone16.DistanceRangeUOM = "Feet"
zone16.ProximityRangeUOM = "Meters"
zone16.OutOfRangeName = ""
zone16.InRangeName = ""
zone17 = Wherigo.Zone(cartLegendsofSLAGA)
zone17.Id = "6e4cc532-91d4-4c51-a980-65208cb9b490"
zone17.Name = _XiCk1("\053\004")
zone17.Description = _XiCk1("\074\056\008\023\056\056\057\125\011\113\023\043\003\094\064\076\091\022\011\113\011\023\125\004\057\090\124\124")
zone17.Visible = true
zone17.Media = zmedia029e81d04655454f9566dde1af9803a7
zone17.Commands = {}
zone17.DistanceRange = Distance(-1, "feet")
zone17.ShowObjects = "OnEnter"
zone17.ProximityRange = Distance(8, "meters")
zone17.AllowSetPositionTo = false
zone17.Active = false
zone17.Points = {
	ZonePoint(38.5535183333333, -90.4577316666667, 0), 
	ZonePoint(38.5535183333333, -90.4578016666667, 0), 
	ZonePoint(38.5534483333333, -90.4578016666667, 0), 
	ZonePoint(38.5534483333333, -90.4577316666667, 0)
}
zone17.OriginalPoint = ZonePoint(38.5534833333333, -90.4577666666667, 0)
zone17.DistanceRangeUOM = "Feet"
zone17.ProximityRangeUOM = "Meters"
zone17.OutOfRangeName = ""
zone17.InRangeName = ""
zone18 = Wherigo.Zone(cartLegendsofSLAGA)
zone18.Id = "419d3e6b-f0cb-4c08-bd20-eefdd1bb9eb4"
zone18.Name = _XiCk1("\053\008")
zone18.Description = _XiCk1("\074\056\008\023\056\056\057\125\090\008\023\043\003\094\064\076\091\022\011\113\011\023\125\004\057\056\090\061")
zone18.Visible = true
zone18.Media = zmedia029e81d04655454f9566dde1af9803a7
zone18.Commands = {}
zone18.DistanceRange = Distance(-1, "feet")
zone18.ShowObjects = "OnEnter"
zone18.ProximityRange = Distance(8, "meters")
zone18.AllowSetPositionTo = false
zone18.Active = false
zone18.Points = {
	ZonePoint(38.5541683333333, -90.455715, 0), 
	ZonePoint(38.5541683333333, -90.455785, 0), 
	ZonePoint(38.5540983333333, -90.455785, 0), 
	ZonePoint(38.5540983333333, -90.455715, 0)
}
zone18.OriginalPoint = ZonePoint(38.5541333333333, -90.45575, 0)
zone18.DistanceRangeUOM = "Feet"
zone18.ProximityRangeUOM = "Meters"
zone18.OutOfRangeName = ""
zone18.InRangeName = ""
zone19 = Wherigo.Zone(cartLegendsofSLAGA)
zone19.Id = "978af876-83be-4b90-839e-9ab1e57efaf2"
zone19.Name = _XiCk1("\053\113")
zone19.Description = _XiCk1("\074\056\008\023\056\056\057\125\113\056\023\043\003\094\064\076\091\022\011\113\011\023\125\004\057\053\113\004")
zone19.Visible = true
zone19.Media = zmedia029e81d04655454f9566dde1af9803a7
zone19.Commands = {}
zone19.DistanceRange = Distance(-1, "feet")
zone19.ShowObjects = "OnEnter"
zone19.ProximityRange = Distance(8, "meters")
zone19.AllowSetPositionTo = false
zone19.Active = false
zone19.Points = {
	ZonePoint(38.5549183333333, -90.4532483333333, 0), 
	ZonePoint(38.5549183333333, -90.4533183333333, 0), 
	ZonePoint(38.5548483333333, -90.4533183333333, 0), 
	ZonePoint(38.5548483333333, -90.4532483333333, 0)
}
zone19.OriginalPoint = ZonePoint(38.5548833333333, -90.4532833333333, 0)
zone19.DistanceRangeUOM = "Feet"
zone19.ProximityRangeUOM = "Meters"
zone19.OutOfRangeName = ""
zone19.InRangeName = ""
zone20 = Wherigo.Zone(cartLegendsofSLAGA)
zone20.Id = "2114aa65-7cef-4a2c-ac90-7f77fa8726d9"
zone20.Name = _XiCk1("\125\011")
zone20.Description = _XiCk1("\074\023\056\008\023\056\056\057\056\056\113\023\022\023\113\011\023\125\004\057\011\008\090")
zone20.Visible = true
zone20.Media = zmedia029e81d04655454f9566dde1af9803a7
zone20.Commands = {}
zone20.DistanceRange = Distance(-1, "feet")
zone20.ShowObjects = "OnEnter"
zone20.ProximityRange = Distance(8, "meters")
zone20.AllowSetPositionTo = false
zone20.Active = false
zone20.Points = {
	ZonePoint(38.55566, -90.45139, 0), 
	ZonePoint(38.55566, -90.45141, 0), 
	ZonePoint(38.55564, -90.45141, 0), 
	ZonePoint(38.55564, -90.45139, 0)
}
zone20.OriginalPoint = ZonePoint(38.55565, -90.4514, 0)
zone20.DistanceRangeUOM = "Feet"
zone20.ProximityRangeUOM = "Meters"
zone20.OutOfRangeName = ""
zone20.InRangeName = ""

-- Characters --

-- Items --
_dbW = Wherigo.ZItem{
	Cartridge = cartLegendsofSLAGA, 
	Container = Player
}
_dbW.Id = "6b70307d-c4d9-4b24-9cdb-c43fc9d3ef59"
_dbW.Name = _XiCk1("\042\080\097\080\003\032\064\023\026\019\023\018\005\122\097\122\023\053\125\066\125\011")
_dbW.Description = _XiCk1("\050\073\080\064\064\023\080\020\122\006\049\003\080\023\033\026\023\064\080\080\023\033\017\080\023\081\026\026\073\032\049\003\122\033\080\064\023\019\026\073\023\042\080\097\080\003\032\064\023\026\019\023\018\042\096\055\096\023\053\125\066\125\011\057")
_dbW.Visible = true
_dbW.Media = zmedia029e81d04655454f9566dde1af9803a7
_dbW.Icon = _HxRF
_dbW.Commands = {
	_uQ4 = Wherigo.ZCommand{
		Text = _XiCk1("\021\020\122\006\049\003\080"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _XiCk1("\074\026\033\017\049\003\097\023\122\031\122\049\005\122\094\005\080")
	}
}
_dbW.Commands._uQ4.Custom = true
_dbW.Commands._uQ4.Id = "2ccaf694-35ee-4d40-9bc1-2688f73a848a"
_dbW.Commands._uQ4.WorksWithAll = true
_dbW.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_dbW.Locked = false
_dbW.Opened = false
_TGQ = Wherigo.ZItem{
	Cartridge = cartLegendsofSLAGA, 
	Container = Player
}
_TGQ.Id = "935cba74-d705-47a9-80bf-1067cde3b501"
_TGQ.Name = _XiCk1("\042\080\097\080\003\032\064\023\026\019\023\018\005\122\097\122\023\053\066\008")
_TGQ.Description = _XiCk1("\050\073\080\064\064\023\080\020\122\006\049\003\080\023\033\026\023\064\080\080\023\033\017\080\023\081\026\026\073\032\049\003\122\033\080\064\023\019\026\073\023\042\080\097\080\003\032\064\023\026\019\023\018\042\096\055\096\023\053\066\008\057")
_TGQ.Visible = true
_TGQ.Media = zmedia029e81d04655454f9566dde1af9803a7
_TGQ.Icon = _HxRF
_TGQ.Commands = {
	_9paw = Wherigo.ZCommand{
		Text = _XiCk1("\021\020\122\006\049\003\080"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _XiCk1("\074\026\033\017\049\003\097\023\122\031\122\049\005\122\094\005\080")
	}
}
_TGQ.Commands._9paw.Custom = true
_TGQ.Commands._9paw.Id = "a9511f1c-5cc2-4fd9-a77b-75c05384bf42"
_TGQ.Commands._9paw.WorksWithAll = true
_TGQ.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_TGQ.Locked = false
_TGQ.Opened = false
_04uQc = Wherigo.ZItem(cartLegendsofSLAGA)
_04uQc.Id = "8f1ee67b-65a3-4570-b8ee-411016f3ec93"
_04uQc.Name = _XiCk1("\071\026\006\076\005\080\033\049\026\003\023\071\026\032\080")
_04uQc.Description = ""
_04uQc.Visible = true
_04uQc.Media = zmedia029e81d04655454f9566dde1af9803a7
_04uQc.Icon = _HxRF
_04uQc.Commands = {}
_04uQc.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_04uQc.Locked = false
_04uQc.Opened = false
_ebwTy = Wherigo.ZItem{
	Cartridge = cartLegendsofSLAGA, 
	Container = Player
}
_ebwTy.Id = "36202902-b1a2-4dff-89cd-f6264c4b4125"
_ebwTy.Name = _XiCk1("\074\122\031\049\097\122\033\026\073")
_ebwTy.Description = _XiCk1("\002\064\080\023\033\017\049\064\023\049\033\080\006\023\033\026\023\074\122\031\049\097\122\033\080\023\033\026\023\122\003\109\023\026\019\023\033\017\080\023\007\017\080\073\049\097\026\064\023\053\066\125\011\057")
_ebwTy.Visible = true
_ebwTy.Media = zmedia029e81d04655454f9566dde1af9803a7
_ebwTy.Icon = _HxRF
_ebwTy.Commands = {
	_IxnI = Wherigo.ZCommand{
		Text = _XiCk1("\074\122\031\049\097\122\033\080"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _XiCk1("\074\026\033\017\049\003\097\023\122\031\122\049\005\122\094\005\080")
	}
}
_ebwTy.Commands._IxnI.Custom = true
_ebwTy.Commands._IxnI.Id = "88bd39c3-4ecf-4fdc-a4b7-1fe33cea0132"
_ebwTy.Commands._IxnI.WorksWithAll = true
_ebwTy.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_ebwTy.Locked = false
_ebwTy.Opened = false

-- Tasks --

-- Cartridge Variables --
Answer = ""
_MQv = _XiCk1("\106\026\003\080\053")
_p7YY = _XiCk1("\032\070\006\006\109")
_qgGE = _XiCk1("\024\032\094\022")
_ZiKzY = _XiCk1("\032\070\006\006\109")
_Ibt = _XiCk1("\024\017\011\113\021\118")
_iDe = _XiCk1("\032\070\006\006\109")
cartLegendsofSLAGA.ZVariables = {
	Answer = "", 
	_MQv = _XiCk1("\106\026\003\080\053"), 
	_p7YY = _XiCk1("\032\070\006\006\109"), 
	_qgGE = _XiCk1("\024\032\094\022"), 
	_ZiKzY = _XiCk1("\032\070\006\006\109"), 
	_Ibt = _XiCk1("\024\017\011\113\021\118"), 
	_iDe = _XiCk1("\032\070\006\006\109")
}

-- Timers --

-- Inputs --
_h09EH = Wherigo.ZInput(cartLegendsofSLAGA)
_h09EH.Id = "2b77cf44-ad69-40d3-a257-95ed948c5352"
_h09EH.Name = _XiCk1("\074\122\031\049\097\122\033\080")
_h09EH.Description = ""
_h09EH.Visible = true
_h09EH.InputType = "Text"
_h09EH.Text = _XiCk1("\022\017\049\081\017\023\042\116\018\023\007\017\080\073\049\097\026\023\007\026\070\005\032\023\109\026\070\023\005\049\115\080\023\033\026\023\003\122\031\049\097\122\033\080\023\033\026\014\023\021\003\033\080\073\023\122\023\003\070\006\094\080\073\023\094\080\033\007\080\080\003\023\053\023\122\003\032\023\125\011\057")

-- WorksWithList for object commands --

-- functions --
function cartLegendsofSLAGA:OnStart()
	_Urwigo.MessageBox{
		Text = _XiCk1("\022\080\005\081\026\006\080\023\033\026\023\033\017\080\023\042\080\097\080\003\032\064\023\026\019\023\018\042\096\055\096\023\007\017\080\073\049\097\026\057\023\052\003\023\033\017\049\064\023\081\122\073\033\073\049\032\097\080\023\109\026\070\023\007\049\005\005\023\019\049\003\032\023\033\017\080\023\081\026\026\073\032\049\003\122\033\080\064\023\033\026\023\033\017\080\023\019\049\073\064\033\023\033\007\080\003\033\109\023\042\080\097\080\003\032\064\023\026\019\023\018\042\096\055\096\023\081\122\081\017\080\064\057\023\116\076\080\003\023\109\026\070\073\023\049\033\080\006\064\023\006\080\003\070\023\033\026\023\122\081\081\080\064\064\023\033\017\080\023\081\026\026\073\032\049\003\122\033\080\064\023\019\026\073\023\080\122\081\017\023\026\019\023\033\017\080\023\081\122\081\017\080\064\057"), 
		Media = zmedia029e81d04655454f9566dde1af9803a7, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _XiCk1("\087\026\070\023\081\122\003\023\122\005\064\026\023\070\064\080\023\033\017\080\023\007\017\080\073\049\097\026\023\003\122\031\049\097\122\033\026\073\023\049\003\023\033\017\080\023\049\033\080\006\064\023\006\080\003\070\023\033\026\023\003\122\031\049\097\122\033\080\023\033\026\023\080\122\081\017\023\026\019\023\033\017\080\023\033\007\080\003\033\109\023\106\026\003\080\064\057\023"), 
					Media = zmedia029e81d04655454f9566dde1af9803a7
				}
			end
		end
	}
end
function cartLegendsofSLAGA:OnRestore()
end
function zone1:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\053")
	_Urwigo.GlobalZoneProximity()
	zone1.Active = false
	zone2.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone2:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\125")
	_Urwigo.GlobalZoneProximity()
	zone2.Active = false
	zone3.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone3:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\056")
	_Urwigo.GlobalZoneProximity()
	zone3.Active = false
	zone4.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone4:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\090")
	_Urwigo.GlobalZoneProximity()
	zone4.Active = false
	zone5.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone5:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\061")
	_Urwigo.GlobalZoneProximity()
	zone5.Active = false
	zone6.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone6:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\124")
	_Urwigo.GlobalZoneProximity()
	zone6.Active = false
	zone7.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone7:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\004")
	_Urwigo.GlobalZoneProximity()
	zone7.Active = false
	zone8.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone8:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\008")
	_Urwigo.GlobalZoneProximity()
	zone8.Active = false
	cartLegendsofSLAGA:RequestSync()
end
function zone9:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\113")
	_Urwigo.GlobalZoneProximity()
	zone9.Active = false
	zone10.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone10:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\053\011")
	_Urwigo.GlobalZoneProximity()
	zone10.Active = false
	zone11.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone11:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\053\053")
	_Urwigo.GlobalZoneProximity()
	zone11.Active = false
	zone12.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone12:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\053\125")
	_Urwigo.GlobalZoneProximity()
	zone12.Active = false
	_Urwigo.MessageBox{
		Text = _XiCk1("\078\017\080\023\081\122\081\017\080\023\049\064\023\017\049\032\032\080\003\023\049\003\023\033\017\080\023\005\122\073\097\080\023\017\026\005\005\026\007\023\033\073\080\080\057"), 
		Media = zmedia029e81d04655454f9566dde1af9803a7, 
		Callback = function(action)
			if action ~= nil then
				zone13.Active = true
				cartLegendsofSLAGA:RequestSync()
			end
		end
	}
end
function zone13:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\053\056")
	_Urwigo.GlobalZoneProximity()
	zone13.Active = false
	zone14.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone14:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\053\090")
	_Urwigo.GlobalZoneProximity()
	zone14.Active = false
	zone15.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone15:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\053\061")
	_Urwigo.GlobalZoneProximity()
	zone15.Active = false
	zone16.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone16:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\053\124")
	_Urwigo.GlobalZoneProximity()
	zone16.Active = false
	zone17.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone17:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\053\004")
	_Urwigo.GlobalZoneProximity()
	zone17.Active = false
	zone18.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone18:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\053\008")
	_Urwigo.GlobalZoneProximity()
	zone18.Active = false
	zone19.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone19:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\053\113")
	_Urwigo.GlobalZoneProximity()
	zone19.Active = false
	zone20.Active = true
	cartLegendsofSLAGA:RequestSync()
end
function zone20:OnProximity()
	_MQv = _XiCk1("\106\026\003\080\125\011")
	_Urwigo.GlobalZoneProximity()
	if true then
		zone20.Active = false
	end
end
function _h09EH:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	Answer = tostring(input)
	if input == 1 then
		_OvawU()
		zone1.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 2 then
		_OvawU()
		zone2.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 3 then
		_OvawU()
		zone3.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 4 then
		_OvawU()
		zone4.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 5 then
		_OvawU()
		zone5.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 6 then
		_OvawU()
		zone6.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 7 then
		_OvawU()
		zone7.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 8 then
		_OvawU()
		zone8.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 9 then
		_OvawU()
		zone9.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 10 then
		_OvawU()
		zone10.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 11 then
		_OvawU()
		zone11.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 12 then
		_OvawU()
		zone12.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 13 then
		_OvawU()
		zone13.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 14 then
		_OvawU()
		zone14.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 15 then
		_OvawU()
		zone15.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 16 then
		_OvawU()
		zone16.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 17 then
		_OvawU()
		zone17.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 18 then
		_OvawU()
		zone18.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 19 then
		_OvawU()
		zone19.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif input == 20 then
		_OvawU()
		zone20.Active = true
		_Urwigo.MessageBox{
			Text = (_XiCk1("\087\026\070\023\122\073\080\023\003\026\007\023\003\122\031\049\097\122\033\049\003\097\023\033\026\023\007\017\080\073\049\097\026\023\003\070\006\094\080\073\023")..Answer).._XiCk1("\057"), 
			Callback = function(action)
				if action ~= nil then
					_G[_MQv].Active = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _XiCk1("\078\017\122\033\023\049\064\023\003\026\033\023\122\003\023\026\076\033\049\026\003\057\023\050\005\080\122\064\080\023\080\003\033\080\073\023\122\023\003\070\006\094\080\073\023\094\080\033\007\080\080\003\023\053\023\122\003\032\023\125\011\057")
		}
	end
end
function _dbW:On_uQ4(target)
	_Urwigo.MessageBox{
		Text = _XiCk1("\113\023\074\023\056\008\023\056\125\057\004\053\053\023\022\023\113\011\023\125\008\057\090\008\053\044\039\089\099\053\011\023\074\023\056\008\023\056\125\057\008\061\008\023\022\023\113\011\023\125\008\057\056\056\113\044\039\089\099\053\053\023\074\023\056\008\023\056\125\057\113\011\113\023\022\023\113\011\023\125\008\057\125\090\061\044\039\089\099\053\125\023\074\023\056\008\023\056\056\057\011\053\011\023\022\023\113\011\023\125\008\057\011\008\004\044\039\089\099\053\056\023\074\023\056\008\023\056\056\057\011\056\053\023\022\023\113\011\023\125\004\057\113\124\056\044\039\089\099\053\090\023\074\023\056\008\023\056\056\057\011\008\053\023\022\023\113\011\023\125\004\057\008\061\061\044\039\089\099\053\061\023\074\023\056\008\023\056\056\057\053\090\124\023\022\023\113\011\023\125\004\057\124\113\056\044\039\089\099\053\124\023\074\023\056\008\023\056\056\057\053\004\053\023\022\023\113\011\023\125\004\057\061\113\125\044\039\089\099\053\004\023\074\023\056\008\023\056\056\057\125\011\113\023\022\023\113\011\023\125\004\057\090\124\124\044\039\089\099\053\008\023\074\023\056\008\023\056\056\057\125\090\008\023\022\023\113\011\023\125\004\057\056\090\061\044\039\089\099\053\113\023\074\023\056\008\023\056\056\057\125\113\056\023\022\023\113\011\023\125\004\057\053\113\004\044\039\089\099\125\011\023\074\023\056\008\023\056\056\057\056\056\113\023\022\023\113\011\023\125\004\057\011\008\090")
	}
end
function _TGQ:On_9paw(target)
	_Urwigo.MessageBox{
		Text = _XiCk1("\053\023\074\023\056\008\023\056\053\057\004\125\125\023\022\023\113\011\023\125\124\057\053\056\008\044\039\089\099\125\023\074\023\056\008\023\056\053\057\113\053\004\023\022\023\113\011\023\125\124\057\053\056\004\044\039\089\099\056\023\074\023\056\008\023\056\125\057\011\053\004\023\022\023\113\011\023\125\124\057\053\090\053\044\039\089\099\090\023\074\023\056\008\023\056\125\057\053\011\124\023\022\023\113\011\023\125\124\057\053\056\061\044\039\089\099\061\023\074\023\056\008\023\056\056\057\056\090\008\023\022\023\113\011\023\125\124\057\090\061\124\044\039\089\099\124\023\074\023\056\008\023\056\056\057\090\125\125\023\022\023\113\011\023\125\124\057\061\056\004\044\039\089\099\004\023\074\023\056\008\023\056\056\057\090\004\011\023\022\023\113\011\023\125\124\057\124\056\053\044\039\089\099\008\023\074\023\056\008\023\056\056\057\056\004\061\023\022\023\113\011\023\125\124\057\004\090\056")
	}
end
function _ebwTy:On_IxnI(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_h09EH)
	end)
end
function _Urwigo.GlobalZoneProximity()
	cartLegendsofSLAGA.Complete = true
	_04uQc.Description = string.sub(Player.CompletionCode, 1, 15)
	_04uQc:MoveTo(Player)
end

-- Urwigo functions --
function _OvawU()
	zone1.Active = false
	zone2.Active = false
	zone3.Active = false
	zone4.Active = false
	zone5.Active = false
	zone6.Active = false
	zone7.Active = false
	zone8.Active = false
	zone9.Active = false
	zone10.Active = false
	zone11.Active = false
	zone12.Active = false
	zone13.Active = false
	zone14.Active = false
	zone15.Active = false
	zone16.Active = false
	zone17.Active = false
	zone18.Active = false
	zone19.Active = false
	zone20.Active = false
end

-- Begin user functions --
-----------------------------------------------------------------------------------------------
-- URWIGO: Following code is imported from the Wherigo Builder cartridge.
-- It is only neccessary if the cartridge uses Author functions that use message box callbacks.
-- Otherwise it can be removed.
cartLegendsofSLAGA.MsgBoxCBFuncs = {}
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=2#--






cartLegendsofSLAGA.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Callback --
Wherigo.Command("SaveClose")
end
end





cartLegendsofSLAGA.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Callback --
zone13.Active = true
cartLegendsofSLAGA:RequestSync()
end
end

-----------------------------------------------------------------------------------------------
-- URWIGO: Here follow imported Author functions

function gsub_wig (str, obf)
    local result = ""
    if (obf == nil) then
        obf = true
    end
    local rot_palette = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@.-~"
    local plen = string.len(rot_palette)
    local magic = { ["\001"] = "B"; ["\002"] = "R"; ["\003"] = "" }
    str = string.gsub(str, "\038nbsp;", " ")
    
    for i = 1, string.len(str) do
        local c = string.sub(str, i, i)
        local p = string.find(rot_palette, c, 1, true)	-- true -> plain text search
        if (p) then
            local jump = (i-1) % 8 + 9
            if (obf) then
                p = p + jump
                if (p > plen) then
                    p = p - plen
                end
            else
                p = p - jump
                if (p < 1) then
                    p = p + plen
                end
            end
            c = string.sub(rot_palette, p, p)		--(debug) .. "(" .. string.byte(c) .. ")"
        else
            x = magic[c]
            if (x) then
                --c = x					--(debug) .. "(*)"
            else
                --(debug) c = c .. "(=" .. string.byte(c) .. ")"
            end
        end

        if (p) then
            p = p
        else
            p = "null"
        end

        result = result .. c			--(debug) .. "[i=" .. i .. "]"
    end
    return result
end

ucoderes = ""
function ucode_wig(ucodenum)
   if pcall(toucode_wig,ucodenum) then
       return ucoderes
   else
       return "?"
   end
end
function toucode_wig(ucodenum)
    ucoderes = string.char(ucodenum)
end





-- End user functions --
return cartLegendsofSLAGA
