﻿require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _IGB(str)
	local res = ""
    local dtable = "\065\014\109\102\028\124\122\032\116\051\096\006\000\067\059\005\022\048\035\093\094\057\098\037\049\066\060\041\091\021\069\027\034\072\118\081\108\064\061\053\011\002\095\113\012\062\026\086\031\125\004\114\055\087\039\084\056\107\009\003\042\100\074\103\068\058\063\001\079\013\099\106\024\044\088\112\115\052\089\016\017\025\076\010\077\120\101\097\029\040\046\110\075\050\082\085\119\126\043\073\030\038\070\018\111\019\083\033\104\105\047\007\045\008\036\080\015\071\092\054\123\121\023\090\020\078\117"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_iwV = Wherigo.ZCartridge()

-- Media --
_n5ZX = Wherigo.ZMedia(_iwV)
_n5ZX.Id = "43a57456-6856-46bc-9c1e-c5db7a45bd3c"
_n5ZX.Name = _IGB("\126\107\118\093\088\052\009\087")
_n5ZX.Description = ""
_n5ZX.AltText = ""
_n5ZX.Resources = {
	{
		Type = "jpg", 
		Filename = "Bodentypen-NSG-Eldena.jpg", 
		Directives = {}
	}
}
_xFt = Wherigo.ZMedia(_iwV)
_xFt.Id = "e43ad44b-90c7-4e2e-b5c4-0f5eb4851fb4"
_xFt.Name = _IGB("\026\105\062\087\092\109\105\052\110\007\105\092\009")
_xFt.Description = ""
_xFt.AltText = ""
_xFt.Resources = {
	{
		Type = "png", 
		Filename = "800px-Soil_profile.png", 
		Directives = {}
	}
}
_qSAL = Wherigo.ZMedia(_iwV)
_qSAL.Id = "89d83d88-3463-4460-8fa6-97c9915ce671"
_qSAL.Name = _IGB("\087\127\037\087")
_qSAL.Description = ""
_qSAL.AltText = ""
_qSAL.Resources = {
	{
		Type = "jpg", 
		Filename = "nsg.jpg", 
		Directives = {}
	}
}
_KN2D = Wherigo.ZMedia(_iwV)
_KN2D.Id = "9dc1cf90-00c3-4730-be63-94016c52b8de"
_KN2D.Name = _IGB("\110\071\105\043\087\127\037\087")
_KN2D.Description = ""
_KN2D.AltText = ""
_KN2D.Resources = {
	{
		Type = "png", 
		Filename = "eule.png", 
		Directives = {}
	}
}
_L1m = Wherigo.ZMedia(_iwV)
_L1m.Id = "1213acf9-fdc3-4dc6-83b9-24a552627ba8"
_L1m.Name = _IGB("\110\071\105\043\037\110\009\087\052\088\009\127\052")
_L1m.Description = ""
_L1m.AltText = ""
_L1m.Resources = {
	{
		Type = "png", 
		Filename = "ico_literatur.png", 
		Directives = {}
	}
}
_kpuU = Wherigo.ZMedia(_iwV)
_kpuU.Id = "e5845ab7-0fe6-4295-ad3d-4e3ecf8d86b3"
_kpuU.Name = _IGB("\110\071\105\043\077\105\037")
_kpuU.Description = ""
_kpuU.AltText = ""
_kpuU.Resources = {
	{
		Type = "png", 
		Filename = "sol.png", 
		Directives = {}
	}
}
_Hbom = Wherigo.ZMedia(_iwV)
_Hbom.Id = "a3d7f2aa-a50b-4db5-a78f-a88c4e1b178d"
_Hbom.Name = _IGB("\077\105\037")
_Hbom.Description = ""
_Hbom.AltText = ""
_Hbom.Resources = {
	{
		Type = "jpg", 
		Filename = "fons.jpg", 
		Directives = {}
	}
}
_VeT = Wherigo.ZMedia(_iwV)
_VeT.Id = "7411ba5c-353d-4351-8722-c80c71aef375"
_VeT.Name = _IGB("\110\071\105\043\076\088\076\087\052")
_VeT.Description = ""
_VeT.AltText = ""
_VeT.Resources = {
	{
		Type = "png", 
		Filename = "ico_antworten.png", 
		Directives = {}
	}
}
_rER = Wherigo.ZMedia(_iwV)
_rER.Id = "2b0d4968-52db-473f-a00d-7d1485f68689"
_rER.Name = _IGB("\110\071\105\043\004\127\071\109\077")
_rER.Description = ""
_rER.AltText = ""
_rER.Resources = {
	{
		Type = "png", 
		Filename = "fuchs.png", 
		Directives = {}
	}
}
_3dhz = Wherigo.ZMedia(_iwV)
_3dhz.Id = "9e6fb625-2fc9-4f23-ae75-02fb7669e842"
_3dhz.Name = _IGB("\110\071\105\043\105\071\087\037\037")
_3dhz.Description = ""
_3dhz.AltText = ""
_3dhz.Resources = {
	{
		Type = "png", 
		Filename = "specht.png", 
		Directives = {}
	}
}
_zm7 = Wherigo.ZMedia(_iwV)
_zm7.Id = "93488d24-7377-4db7-afeb-9c3a27402b0e"
_zm7.Name = _IGB("\110\071\105\043\087\077\044\127\110\052\105\037")
_zm7.Description = ""
_zm7.AltText = ""
_zm7.Resources = {
	{
		Type = "png", 
		Filename = "esquirol.png", 
		Directives = {}
	}
}
_zPrjV = Wherigo.ZMedia(_iwV)
_zPrjV.Id = "5d392898-ea5c-4cce-a0bd-baaed1342db2"
_zPrjV.Name = _IGB("\110\071\105\043\052\087\109")
_zPrjV.Description = ""
_zPrjV.AltText = ""
_zPrjV.Resources = {
	{
		Type = "png", 
		Filename = "reh.png", 
		Directives = {}
	}
}
_BOI = Wherigo.ZMedia(_iwV)
_BOI.Id = "c4b42b6b-c0ae-46ae-881c-91590d22cd67"
_BOI.Name = _IGB("\110\071\105\043\088\003\077\087\037")
_BOI.Description = ""
_BOI.AltText = ""
_BOI.Resources = {
	{
		Type = "png", 
		Filename = "amsel.png", 
		Directives = {}
	}
}
_O6XAb = Wherigo.ZMedia(_iwV)
_O6XAb.Id = "67fb9c94-4458-4a25-afae-2c475e3b459d"
_O6XAb.Name = _IGB("\110\071\105\043\003\087\110\077\087")
_O6XAb.Description = ""
_O6XAb.AltText = ""
_O6XAb.Resources = {
	{
		Type = "png", 
		Filename = "meise.png", 
		Directives = {}
	}
}
_g2r2 = Wherigo.ZMedia(_iwV)
_g2r2.Id = "5a3722fb-68bc-4cc6-a4b4-5bfe6570153d"
_g2r2.Name = _IGB("\077\105\043\077\076\087\071\109\009")
_g2r2.Description = ""
_g2r2.AltText = ""
_g2r2.Resources = {
	{
		Type = "wav", 
		Filename = "spechtwav.wav", 
		Directives = {}
	}
}
_K_xf = Wherigo.ZMedia(_iwV)
_K_xf.Id = "9dca141c-5a38-4794-a573-ab456bcb2d2c"
_K_xf.Name = _IGB("\077\105\043\058\105\109\037\003\087\110\077\087")
_K_xf.Description = ""
_K_xf.AltText = ""
_K_xf.Resources = {
	{
		Type = "wav", 
		Filename = "kohlmeisewav.wav", 
		Directives = {}
	}
}
_iwVl6 = Wherigo.ZMedia(_iwV)
_iwVl6.Id = "de905fa6-7d39-4ac1-854f-7facabc133f9"
_iwVl6.Name = _IGB("\077\105\043\003\087\052\037\088")
_iwVl6.Description = ""
_iwVl6.AltText = ""
_iwVl6.Resources = {
	{
		Type = "wav", 
		Filename = "merlawav.wav", 
		Directives = {}
	}
}
_QTNK = Wherigo.ZMedia(_iwV)
_QTNK.Id = "65972f93-146c-429d-ba74-fa9b46c111cf"
_QTNK.Name = _IGB("\077\105\043\004\127\071\109\077")
_QTNK.Description = ""
_QTNK.AltText = ""
_QTNK.Resources = {
	{
		Type = "ogg", 
		Filename = "fuchs.ogg", 
		Directives = {}
	}
}
_k_dsD = Wherigo.ZMedia(_iwV)
_k_dsD.Id = "23208640-6755-4225-bfa8-b462639a37ab"
_k_dsD.Name = _IGB("\110\071\105")
_k_dsD.Description = ""
_k_dsD.AltText = ""
_k_dsD.Resources = {
	{
		Type = "png", 
		Filename = "earthigo.png", 
		Directives = {}
	}
}
_FdMeN = Wherigo.ZMedia(_iwV)
_FdMeN.Id = "f3c261ab-9ddd-4ad9-ab63-8bc1c9b2eb4f"
_FdMeN.Name = _IGB("\023\037\088\127\003\087\110\077\087")
_FdMeN.Description = ""
_FdMeN.AltText = ""
_FdMeN.Resources = {
	{
		Type = "JPG", 
		Filename = "blaumeise.JPG", 
		Directives = {}
	}
}
_69J = Wherigo.ZMedia(_iwV)
_69J.Id = "018f553d-62fd-42ef-bdea-48eca276cb3d"
_69J.Name = _IGB("\087\077\044\127\110\052\105\037")
_69J.Description = ""
_69J.AltText = ""
_69J.Resources = {
	{
		Type = "JPG", 
		Filename = "esquirol.JPG", 
		Directives = {}
	}
}
_esZP6 = Wherigo.ZMedia(_iwV)
_esZP6.Id = "df7c8aca-04be-43c6-a4d5-8ffbdc75dda8"
_esZP6.Name = _IGB("\004\052\105\077\071\109")
_esZP6.Description = ""
_esZP6.AltText = ""
_esZP6.Resources = {
	{
		Type = "JPG", 
		Filename = "frosch.JPG", 
		Directives = {}
	}
}
_X4e = Wherigo.ZMedia(_iwV)
_X4e.Id = "1910a502-dfe2-436f-bf8f-565789d93318"
_X4e.Name = _IGB("\004\127\071\109\077")
_X4e.Description = ""
_X4e.AltText = ""
_X4e.Resources = {
	{
		Type = "jpg", 
		Filename = "fuchs.jpg", 
		Directives = {}
	}
}
_xegod = Wherigo.ZMedia(_iwV)
_xegod.Id = "1b21ad5f-6bf8-48e4-b10e-a4981aa81a76"
_xegod.Name = _IGB("\052\087\109")
_xegod.Description = ""
_xegod.AltText = ""
_xegod.Resources = {
	{
		Type = "jpg", 
		Filename = "reh.jpg", 
		Directives = {}
	}
}
_CK72n = Wherigo.ZMedia(_iwV)
_CK72n.Id = "a908fdfa-8f20-484b-9423-4d1ca49f7624"
_CK72n.Name = _IGB("\077\076\087\071\109\009")
_CK72n.Description = ""
_CK72n.AltText = ""
_CK72n.Resources = {
	{
		Type = "JPG", 
		Filename = "specht.JPG", 
		Directives = {}
	}
}
_c3Eu = Wherigo.ZMedia(_iwV)
_c3Eu.Id = "45156014-0978-48cd-8212-dc0efcb1e8cf"
_c3Eu.Name = _IGB("\003\088\127\077")
_c3Eu.Description = ""
_c3Eu.AltText = ""
_c3Eu.Resources = {
	{
		Type = "jpg", 
		Filename = "maus.jpg", 
		Directives = {}
	}
}
_5Fr2 = Wherigo.ZMedia(_iwV)
_5Fr2.Id = "4e4bceb0-10d8-41d8-84f1-21b0700ab661"
_5Fr2.Name = _IGB("\110\071\105\043\003\088\127\077")
_5Fr2.Description = ""
_5Fr2.AltText = ""
_5Fr2.Resources = {
	{
		Type = "png", 
		Filename = "maus.png", 
		Directives = {}
	}
}
_vMM = Wherigo.ZMedia(_iwV)
_vMM.Id = "0de0af33-bd01-4868-89b7-54056b47fdd9"
_vMM.Name = _IGB("\110\071\105\043\004\052\105\077\071\109")
_vMM.Description = ""
_vMM.AltText = ""
_vMM.Resources = {
	{
		Type = "png", 
		Filename = "frog.png", 
		Directives = {}
	}
}
_Y6bf = Wherigo.ZMedia(_iwV)
_Y6bf.Id = "3b7f3249-007d-458e-a9fa-8d1778ffdc29"
_Y6bf.Name = _IGB("\088\003\077\087\037")
_Y6bf.Description = ""
_Y6bf.AltText = ""
_Y6bf.Resources = {
	{
		Type = "png", 
		Filename = "amsel_gran.png", 
		Directives = {}
	}
}
-- Cartridge Info --
_iwV.Id="3b059350-3f36-45c7-a967-a6dd0afecbae"
_iwV.Name="Die Böden eines Waldes"
_iwV.Description=[[Mit diesem Wherigo hast du eine Hilfe um dem Earthcache „Die Böden eines Waldes“ (GC7YVN1) lösen zu können. Es ist natürlich freiwillig. Alle die Informationen befinden sich am Listing des Earthcache, nichts neues (über Geologie) ist am Wherigo erzählt.
Mit dem Wherigo wirst du durch den Wald geführt und du kannst die Antworten am Spiel speichern um die später zu Hause verbessern/ergänzen.
Ich hoffe ihr habt Spaß!]]
_iwV.Visible=true
_iwV.Activity="TourGuide"
_iwV.StartingLocationDescription=[[NSG Eldena]]
_iwV.StartingLocation = ZonePoint(54.0739667,13.4610667,0)
_iwV.Version="1.0"
_iwV.Company=""
_iwV.Author="SastR'e.O"
_iwV.BuilderVersion="URWIGO 1.22.5798.37755"
_iwV.CreateDate="04/03/2019 21:24:55"
_iwV.PublishDate="1/1/0001 12:00:00 AM"
_iwV.UpdateDate="04/07/2019 13:52:30"
_iwV.LastPlayedDate="1/1/0001 12:00:00 AM"
_iwV.TargetDevice="PocketPC"
_iwV.TargetDeviceVersion="0"
_iwV.StateId="1"
_iwV.CountryId="2"
_iwV.Complete=false
_iwV.UseLogging=true

_iwV.Icon=_k_dsD


-- Zones --
_knK = Wherigo.Zone(_iwV)
_knK.Id = "781276aa-d34b-4a29-bb36-7d90b69ada72"
_knK.Name = _IGB("\126\107\118\008\031\037\062\087\092\088")
_knK.Description = _IGB("\065\088\077\008\126\088\009\127\052\077\071\109\127\009\007\064\087\023\110\087\009\008\031\037\062\087\092\088\008\090\126\107\118\008\031\037\062\087\092\088\028\008\110\077\009\008\087\110\092\008\088\037\077\008\126\088\009\127\052\077\071\109\127\009\007\064\087\023\110\087\009\008\088\127\077\064\087\097\110\087\077\087\092\087\052\008\083\088\127\023\097\088\037\062\008\110\003\008\107\195\188\062\105\077\009\087\092\008\062\087\052\008\034\088\092\077\087\077\009\088\062\009\008\118\052\087\110\004\077\097\088\037\062\008\110\092\008\085\087\071\058\037\087\092\023\127\052\064\113\048\105\052\076\105\003\003\087\052\092\074\008\062\110\087\008\087\110\092\008\118\087\023\110\087\009\008\035\105\092\008\078\018\053\074\025\008\109\088\008\127\003\004\088\077\077\009\091\008\065\110\087\077\087\077\008\054\088\037\062\064\087\023\110\087\009\008\077\009\087\109\009\008\088\037\077\008\126\088\009\127\052\077\071\109\127\009\007\008\077\087\110\009\008\025\022\120\025\091\027\026\095\046\065\087\052\008\064\052\195\182\195\159\009\087\008\056\087\110\037\008\062\087\077\008\126\107\118\008\031\037\062\087\092\088\008\097\110\052\062\008\035\105\092\008\092\088\009\127\052\092\088\109\087\092\008\031\077\071\109\087\092\113\026\127\071\109\087\092\097\088\037\062\023\087\077\009\195\164\092\062\087\092\008\087\110\092\064\087\092\105\003\003\087\092\074\008\062\110\087\008\009\087\110\037\097\087\110\077\087\008\003\087\109\052\087\052\087\008\109\127\092\062\087\052\009\008\063\088\109\052\087\008\088\037\009\008\077\110\092\062\091\008\054\110\052\008\004\110\092\062\087\092\008\088\023\087\052\008\088\127\071\109\008\026\087\052\064\113\001\109\105\052\092\074\008\107\009\110\087\037\113\031\110\071\109\087\074\008\034\088\110\092\023\127\071\109\087\074\008\048\105\064\087\037\113\093\110\052\077\071\109\087\074\008\026\087\052\064\113\096\037\003\087\008\127\092\062\008\107\076\110\009\007\113\001\109\105\052\092\074\008\127\091\088\091\027\026\095\046\096\092\009\087\052\008\062\087\092\008\085\110\009\023\087\097\105\109\092\087\052\092\008\062\087\077\008\054\088\037\062\087\077\008\097\110\052\008\058\195\182\092\092\087\092\066\008\034\110\052\077\071\109\087\074\008\103\195\188\071\109\077\087\074\008\054\088\037\062\003\195\164\127\077\087\074\008\107\076\087\071\109\009\087\074\008\095\105\009\003\110\037\088\092\008\127\092\062\008\035\110\087\037\008\003\087\109\052\008\004\110\092\062\087\092\091")
_knK.Visible = true
_knK.Commands = {}
_knK.DistanceRange = Distance(0, "meters")
_knK.ShowObjects = "OnEnter"
_knK.ProximityRange = Distance(60, "meters")
_knK.AllowSetPositionTo = false
_knK.Active = true
_knK.Points = {
	ZonePoint(54.0833465464072, 13.4444711634283, 0), 
	ZonePoint(54.0824291312182, 13.4451671468074, 0), 
	ZonePoint(54.0824099181179, 13.4457239335106, 0), 
	ZonePoint(54.0834137907018, 13.4464362929692, 0), 
	ZonePoint(54.0832648924743, 13.4476317467732, 0), 
	ZonePoint(54.082986307259, 13.4491629102071, 0), 
	ZonePoint(54.0827029169316, 13.4504975606869, 0), 
	ZonePoint(54.0831256001004, 13.4505712530447, 0), 
	ZonePoint(54.0830343393261, 13.4521515447171, 0), 
	ZonePoint(54.0829478815653, 13.45305222909, 0), 
	ZonePoint(54.0827461460897, 13.4537400244293, 0), 
	ZonePoint(54.0820304575635, 13.4536908961908, 0), 
	ZonePoint(54.0817758808166, 13.4531095453683, 0), 
	ZonePoint(54.0806903096149, 13.4528065878973, 0), 
	ZonePoint(54.080257994594, 13.4529867247719, 0), 
	ZonePoint(54.0798160679184, 13.4537891526678, 0), 
	ZonePoint(54.0793501183928, 13.4551483672668, 0), 
	ZonePoint(54.0792156165259, 13.4564502655876, 0), 
	ZonePoint(54.0795134415023, 13.4576784715507, 0), 
	ZonePoint(54.07999860342, 13.4578913605843, 0), 
	ZonePoint(54.080555812091, 13.4591031904678, 0), 
	ZonePoint(54.0812042782806, 13.4588084210366, 0), 
	ZonePoint(54.0815453193965, 13.458996745951, 0), 
	ZonePoint(54.0817662741164, 13.4597172934493, 0), 
	ZonePoint(54.0821457370862, 13.4594470881374, 0), 
	ZonePoint(54.0823090491951, 13.4599219944431, 0), 
	ZonePoint(54.082304245907, 13.4604705931066, 0), 
	ZonePoint(54.0820784907369, 13.460920935293, 0), 
	ZonePoint(54.0813579872995, 13.4609454994123, 0), 
	ZonePoint(54.0805894365128, 13.461518662195, 0), 
	ZonePoint(54.0790667032363, 13.4618379957454, 0), 
	ZonePoint(54.0784470260683, 13.4617888675069, 0), 
	ZonePoint(54.0766263706378, 13.4613303372807, 0), 
	ZonePoint(54.0765447034834, 13.4629925093506, 0), 
	ZonePoint(54.0765398995281, 13.4641879631546, 0), 
	ZonePoint(54.0764198004657, 13.4649494508517, 0), 
	ZonePoint(54.0759970490021, 13.4657109385488, 0), 
	ZonePoint(54.0758048878227, 13.4660630242582, 0), 
	ZonePoint(54.0755935094979, 13.4671356574659, 0), 
	ZonePoint(54.0755262525325, 13.4677743245667, 0), 
	ZonePoint(54.0760883252507, 13.468396615588, 0), 
	ZonePoint(54.0767945083911, 13.4688551458142, 0), 
	ZonePoint(54.0776399907706, 13.468961590331, 0), 
	ZonePoint(54.0784182036492, 13.4686013165818, 0), 
	ZonePoint(54.0789081820507, 13.4684784959855, 0), 
	ZonePoint(54.0800802637792, 13.4686995730588, 0), 
	ZonePoint(54.0806182574241, 13.469190855444, 0), 
	ZonePoint(54.0814156280347, 13.4700178474591, 0), 
	ZonePoint(54.0817614707654, 13.4709430959513, 0), 
	ZonePoint(54.082092900678, 13.4717782760062, 0), 
	ZonePoint(54.0821025073027, 13.4725888919418, 0), 
	ZonePoint(54.0819824243345, 13.4741364314552, 0), 
	ZonePoint(54.0817710774668, 13.4747259703174, 0), 
	ZonePoint(54.0813147566955, 13.4750616799473, 0), 
	ZonePoint(54.0803204403753, 13.4760524327574, 0), 
	ZonePoint(54.0797776392894, 13.4768548606533, 0), 
	ZonePoint(54.0794317800279, 13.4775590320721, 0), 
	ZonePoint(54.0795566739826, 13.4785743490014, 0), 
	ZonePoint(54.078994648227, 13.4800727602763, 0), 
	ZonePoint(54.0776976366693, 13.480416657946, 0), 
	ZonePoint(54.0760835212427, 13.4802283330316, 0), 
	ZonePoint(54.0758961644938, 13.4800318200776, 0), 
	ZonePoint(54.0749353473664, 13.4801055124353, 0), 
	ZonePoint(54.0740753971789, 13.4803511536279, 0), 
	ZonePoint(54.0736862518543, 13.4802610851906, 0), 
	ZonePoint(54.0734364282419, 13.480048196157, 0), 
	ZonePoint(54.0728214714066, 13.4799663157594, 0), 
	ZonePoint(54.0725812514187, 13.4800727602762, 0), 
	ZonePoint(54.0721200251458, 13.4798598712426, 0), 
	ZonePoint(54.0718317561232, 13.4796551702487, 0), 
	ZonePoint(54.0712840394661, 13.4797534267258, 0), 
	ZonePoint(54.0706354182906, 13.4803347775482, 0), 
	ZonePoint(54.0701741704011, 13.4804575981446, 0), 
	ZonePoint(54.0699483492534, 13.4804330340253, 0), 
	ZonePoint(54.0693717790501, 13.4805886067805, 0), 
	ZonePoint(54.0688432493304, 13.4804985383433, 0), 
	ZonePoint(54.0685645673148, 13.4807196154166, 0), 
	ZonePoint(54.0680168075573, 13.4812436499608, 0), 
	ZonePoint(54.0674978705953, 13.481137205444, 0), 
	ZonePoint(54.0672191795502, 13.480768743655, 0), 
	ZonePoint(54.0663734849296, 13.4792621443404, 0), 
	ZonePoint(54.0658160858767, 13.4789182466707, 0), 
	ZonePoint(54.0656430984425, 13.4783287078084, 0), 
	ZonePoint(54.0646484067114, 13.4778456134629, 0), 
	ZonePoint(54.0639227952991, 13.4777637330654, 0), 
	ZonePoint(54.0633509469091, 13.4781813230928, 0), 
	ZonePoint(54.0621687815767, 13.4790001270682, 0), 
	ZonePoint(54.0619299151891, 13.4792100768974, 0), 
	ZonePoint(54.0615180481154, 13.4725027832684, 0), 
	ZonePoint(54.0616015670185, 13.4718857286085, 0), 
	ZonePoint(54.0618899070673, 13.4711406169029, 0), 
	ZonePoint(54.0615775385912, 13.4696667697472, 0), 
	ZonePoint(54.0612363334173, 13.4665471266011, 0), 
	ZonePoint(54.0609576003501, 13.4639433299595, 0), 
	ZonePoint(54.0610729383979, 13.4618390037427, 0), 
	ZonePoint(54.0613324478344, 13.4610038236879, 0), 
	ZonePoint(54.0619716030504, 13.4607254303363, 0), 
	ZonePoint(54.06113541304, 13.4596855492876, 0), 
	ZonePoint(54.0631345519725, 13.4555751533313, 0), 
	ZonePoint(54.0645713736442, 13.4525701427417, 0), 
	ZonePoint(54.0649269673206, 13.4508588424332, 0), 
	ZonePoint(54.0650855418974, 13.4497452690267, 0), 
	ZonePoint(54.0650086573297, 13.4494996278341, 0), 
	ZonePoint(54.0652248948134, 13.4490820378067, 0), 
	ZonePoint(54.065955288656, 13.4486562597395, 0), 
	ZonePoint(54.0661858095979, 13.4480737811574, 0), 
	ZonePoint(54.0662578849072, 13.447557948493, 0), 
	ZonePoint(54.066373205142, 13.4472795626106, 0), 
	ZonePoint(54.0669449965758, 13.4471567453095, 0), 
	ZonePoint(54.0672765359019, 13.4467637299461, 0), 
	ZonePoint(54.067608072581, 13.4464771562437, 0), 
	ZonePoint(54.0680549221776, 13.4463543389426, 0), 
	ZonePoint(54.0683576240111, 13.446280648562, 0), 
	ZonePoint(54.068415281253, 13.4466572882852, 0), 
	ZonePoint(54.0685882524983, 13.4467801055863, 0), 
	ZonePoint(54.0689053645767, 13.4466818517455, 0), 
	ZonePoint(54.0688909504438, 13.4458221306381, 0), 
	ZonePoint(54.0692176695595, 13.4457484402575, 0), 
	ZonePoint(54.0695203629166, 13.4460186383199, 0), 
	ZonePoint(54.0696020416985, 13.4464198415034, 0), 
	ZonePoint(54.0699527781705, 13.4475988875935, 0), 
	ZonePoint(54.0701497658486, 13.4482047862787, 0), 
	ZonePoint(54.0718073080732, 13.4490808830263, 0), 
	ZonePoint(54.0724126548237, 13.4504810002584, 0), 
	ZonePoint(54.0727633675538, 13.4512342797049, 0), 
	ZonePoint(54.0723982419084, 13.4527244629578, 0), 
	ZonePoint(54.0720283087035, 13.4537233770064, 0), 
	ZonePoint(54.071446978436, 13.4544029660722, 0), 
	ZonePoint(54.071216365827, 13.4549106109166, 0), 
	ZonePoint(54.0717640686818, 13.4558440224047, 0), 
	ZonePoint(54.0725952179844, 13.4567283069723, 0), 
	ZonePoint(54.0732149658836, 13.4571540736159, 0), 
	ZonePoint(54.0751942538063, 13.4559832153459, 0), 
	ZonePoint(54.0758812176023, 13.4536333109857, 0), 
	ZonePoint(54.0751606259161, 13.4522659450339, 0), 
	ZonePoint(54.0755065114865, 13.4517664880096, 0), 
	ZonePoint(54.0755929824288, 13.4503499951375, 0), 
	ZonePoint(54.075525727267, 13.4495230253104, 0), 
	ZonePoint(54.0752278816693, 13.4495148374903, 0), 
	ZonePoint(54.074949249982, 13.4498669137533, 0), 
	ZonePoint(54.0745889476137, 13.4496376547913, 0), 
	ZonePoint(54.0744063932202, 13.4488761875249, 0), 
	ZonePoint(54.0740412820248, 13.446796481227, 0), 
	ZonePoint(54.0738395086708, 13.4460186383204, 0), 
	ZonePoint(54.0736617551417, 13.4444957037873, 0), 
	ZonePoint(54.0728930824703, 13.4445038916074, 0), 
	ZonePoint(54.0721243955669, 13.4444711403271, 0), 
	ZonePoint(54.071619937052, 13.4442418813652, 0), 
	ZonePoint(54.0712692146629, 13.4436605461402, 0), 
	ZonePoint(54.0709713385263, 13.4426616320916, 0), 
	ZonePoint(54.0708464220911, 13.4421130481469, 0), 
	ZonePoint(54.071591110666, 13.4405082354131, 0), 
	ZonePoint(54.0727441504944, 13.4393210015029, 0), 
	ZonePoint(54.0731573153063, 13.4392718745825, 0), 
	ZonePoint(54.0737482299265, 13.4396485143058, 0), 
	ZonePoint(54.0743343320543, 13.4402789764512, 0), 
	ZonePoint(54.0747186568264, 13.4412205757593, 0), 
	ZonePoint(54.074992486056, 13.441998418666, 0), 
	ZonePoint(54.0755785706174, 13.4441108762443, 0), 
	ZonePoint(54.076736303508, 13.4450688511925, 0), 
	ZonePoint(54.0774568678429, 13.4460432017809, 0), 
	ZonePoint(54.078090954111, 13.4470339280095, 0), 
	ZonePoint(54.07850886931, 13.4476807657951, 0), 
	ZonePoint(54.0793302765764, 13.4476480145148, 0), 
	ZonePoint(54.0796425031448, 13.4472877504318, 0), 
	ZonePoint(54.0796376996769, 13.4449705973519, 0), 
	ZonePoint(54.0797385723856, 13.4431938403966, 0), 
	ZonePoint(54.0798730689493, 13.4429318301544, 0), 
	ZonePoint(54.0804398711076, 13.443111962196, 0), 
	ZonePoint(54.0814101415815, 13.4436196070403, 0), 
	ZonePoint(54.0819240875439, 13.4437751756218, 0), 
	ZonePoint(54.0823419641493, 13.4437178608812, 0), 
	ZonePoint(54.082889520229, 13.4436523583207, 0), 
	ZonePoint(54.0832545536021, 13.4439716833034, 0), 
	ZonePoint(54.0833794327031, 13.4442582570059, 0)
}
_knK.OriginalPoint = ZonePoint(54.0742062434436, 13.4587003542151, 0)
_knK.DistanceRangeUOM = "Meters"
_knK.ProximityRangeUOM = "Meters"
_knK.OutOfRangeName = ""
_knK.InRangeName = ""
_B8xb = Wherigo.Zone(_iwV)
_B8xb.Id = "ecb87821-4be7-4b33-b09f-f6e3b16fb08b"
_B8xb.Name = _IGB("\095\087\109\023\052\127\071\109")
_B8xb.Description = ""
_B8xb.Visible = false
_B8xb.Commands = {}
_B8xb.DistanceRange = Distance(-1, "feet")
_B8xb.ShowObjects = "OnEnter"
_B8xb.ProximityRange = Distance(60, "meters")
_B8xb.AllowSetPositionTo = false
_B8xb.Active = true
_B8xb.Points = {
	ZonePoint(54.0708444555304, 13.4421093894085, 0), 
	ZonePoint(54.0709788589396, 13.4427065583315, 0), 
	ZonePoint(54.0712668647798, 13.4436554842914, 0), 
	ZonePoint(54.0716220692313, 13.4442281120258, 0), 
	ZonePoint(54.0721212703509, 13.4444735239119, 0), 
	ZonePoint(54.0736620359531, 13.4444980651005, 0), 
	ZonePoint(54.0738396283129, 13.4459950776062, 0), 
	ZonePoint(54.0740508182384, 13.4468212976229, 0), 
	ZonePoint(54.0745883877464, 13.4496353539177, 0), 
	ZonePoint(54.0749579627452, 13.4498644050115, 0), 
	ZonePoint(54.075226742496, 13.4495208283708, 0), 
	ZonePoint(54.0755291176355, 13.449529008767, 0), 
	ZonePoint(54.0756011113917, 13.4503552287838, 0), 
	ZonePoint(54.0755099192794, 13.4517622569312, 0), 
	ZonePoint(54.0751643473518, 13.4522612610997, 0), 
	ZonePoint(54.0758794860743, 13.453627387266, 0), 
	ZonePoint(54.0751931451223, 13.455975160977, 0), 
	ZonePoint(54.0732156518022, 13.4571613184268, 0), 
	ZonePoint(54.0717660701702, 13.455852455034, 0), 
	ZonePoint(54.0712236640311, 13.4549117094703, 0), 
	ZonePoint(54.0714396673249, 13.4544045249056, 0), 
	ZonePoint(54.0720204706084, 13.4537337324167, 0), 
	ZonePoint(54.0723900684676, 13.4527520848721, 0), 
	ZonePoint(54.0727596630366, 13.4512305311779, 0), 
	ZonePoint(54.0717996703174, 13.4490709065796, 0), 
	ZonePoint(54.0701484309155, 13.448211964978, 0), 
	ZonePoint(54.0695195986448, 13.446019618795, 0), 
	ZonePoint(54.0692267803682, 13.4457578461164, 0), 
	ZonePoint(54.0689051579142, 13.4457987480974, 0), 
	ZonePoint(54.0691257236655, 13.4445395758706, 0), 
	ZonePoint(54.0692911472101, 13.4441824971794, 0), 
	ZonePoint(54.0696550766883, 13.4435998951042, 0), 
	ZonePoint(54.0702285348474, 13.4420024378012, 0), 
	ZonePoint(54.0703510505859, 13.4419551504445, 0)
}
_B8xb.OriginalPoint = ZonePoint(54.072326548464, 13.448476570491, 0)
_B8xb.DistanceRangeUOM = "Feet"
_B8xb.ProximityRangeUOM = "Meters"
_B8xb.OutOfRangeName = ""
_B8xb.InRangeName = ""
_OvbSS = Wherigo.Zone(_iwV)
_OvbSS.Id = "1f2cf491-c595-4675-b53a-87ea6325bd21"
_OvbSS.Name = _IGB("\107\009\088\009\110\105\092\008\025")
_OvbSS.Description = _IGB("\126\008\040\078\008\018\078\091\078\010\057\008\031\008\018\025\010\008\094\053\091\120\120\078")
_OvbSS.Visible = true
_OvbSS.Commands = {}
_OvbSS.DistanceRange = Distance(-1, "feet")
_OvbSS.ShowObjects = "OnEnter"
_OvbSS.ProximityRange = Distance(60, "meters")
_OvbSS.AllowSetPositionTo = false
_OvbSS.Active = true
_OvbSS.Points = {
	ZonePoint(54.0741156956448, 13.4604721283175, 0), 
	ZonePoint(54.0741156956448, 13.461339238468, 0), 
	ZonePoint(54.073626124812, 13.461339238468, 0), 
	ZonePoint(54.073626124812, 13.4604721283175, 0)
}
_OvbSS.OriginalPoint = ZonePoint(54.0738709102284, 13.4609056833927, 0)
_OvbSS.DistanceRangeUOM = "Feet"
_OvbSS.ProximityRangeUOM = "Meters"
_OvbSS.OutOfRangeName = ""
_OvbSS.InRangeName = ""
_p9kK = Wherigo.Zone(_iwV)
_p9kK.Id = "e3c2ff10-1823-4259-b94a-6a1ea60e8083"
_p9kK.Name = _IGB("\107\009\088\009\110\105\092\008\094")
_p9kK.Description = _IGB("\126\008\040\078\008\018\078\091\010\053\025\008\031\008\018\025\010\008\094\053\091\057\078\120")
_p9kK.Visible = true
_p9kK.Commands = {}
_p9kK.DistanceRange = Distance(-1, "feet")
_p9kK.ShowObjects = "OnEnter"
_p9kK.ProximityRange = Distance(60, "meters")
_p9kK.AllowSetPositionTo = false
_p9kK.Active = true
_p9kK.Points = {
	ZonePoint(54.0729973538029, 13.4637115209551, 0), 
	ZonePoint(54.0724885702909, 13.4637115209551, 0), 
	ZonePoint(54.0724885702909, 13.4646113522433, 0), 
	ZonePoint(54.0729973538029, 13.4646113522433, 0)
}
_p9kK.OriginalPoint = ZonePoint(54.0727429620469, 13.4641614365992, 0)
_p9kK.DistanceRangeUOM = "Feet"
_p9kK.ProximityRangeUOM = "Meters"
_p9kK.OutOfRangeName = ""
_p9kK.InRangeName = ""
_4yYc = Wherigo.Zone(_iwV)
_4yYc.Id = "175564de-a1df-4f8d-ad68-d60e847f3573"
_4yYc.Name = _IGB("\107\009\088\009\110\105\092\008\010")
_4yYc.Description = _IGB("\126\008\040\078\008\018\078\091\078\078\010\008\031\008\018\025\010\008\094\057\091\010\010\057")
_4yYc.Visible = true
_4yYc.Commands = {}
_4yYc.DistanceRange = Distance(-1, "feet")
_4yYc.ShowObjects = "OnEnter"
_4yYc.ProximityRange = Distance(60, "meters")
_4yYc.AllowSetPositionTo = false
_4yYc.Active = true
_4yYc.Points = {
	ZonePoint(54.0742622707441, 13.4718030024982, 0), 
	ZonePoint(54.0736965311578, 13.4718030024982, 0), 
	ZonePoint(54.0736965311578, 13.472855429758, 0), 
	ZonePoint(54.0742622707441, 13.472855429758, 0)
}
_4yYc.OriginalPoint = ZonePoint(54.0739794009509, 13.4723292161281, 0)
_4yYc.DistanceRangeUOM = "Feet"
_4yYc.ProximityRangeUOM = "Meters"
_4yYc.OutOfRangeName = ""
_4yYc.InRangeName = ""
_TFN = Wherigo.Zone(_iwV)
_TFN.Id = "f85aae3c-d606-4a8b-8e0d-7e8cc7ab15d9"
_TFN.Name = _IGB("\107\009\088\009\110\105\092\008\078")
_TFN.Description = _IGB("\126\008\040\078\008\018\078\091\010\022\120\008\031\008\018\025\010\008\094\053\091\078\078\053")
_TFN.Visible = true
_TFN.Commands = {}
_TFN.DistanceRange = Distance(-1, "feet")
_TFN.ShowObjects = "OnEnter"
_TFN.ProximityRange = Distance(60, "meters")
_TFN.AllowSetPositionTo = false
_TFN.Active = true
_TFN.Points = {
	ZonePoint(54.0734317566633, 13.456912325393, 0), 
	ZonePoint(54.0734317566633, 13.4574846409638, 0), 
	ZonePoint(54.0730623695568, 13.4574846409638, 0), 
	ZonePoint(54.0730623695568, 13.456912325393, 0)
}
_TFN.OriginalPoint = ZonePoint(54.07324706311, 13.4571984831784, 0)
_TFN.DistanceRangeUOM = "Feet"
_TFN.ProximityRangeUOM = "Meters"
_TFN.OutOfRangeName = ""
_TFN.InRangeName = ""
_aHI1 = Wherigo.Zone(_iwV)
_aHI1.Id = "0dc8528d-23ea-462a-9b2c-d60bea05b49e"
_aHI1.Name = _IGB("\107\009\088\009\110\105\092\008\040")
_aHI1.Description = _IGB("\126\008\040\078\008\018\010\091\120\053\018\008\031\008\018\025\010\008\094\053\091\022\010\120")
_aHI1.Visible = true
_aHI1.Commands = {}
_aHI1.DistanceRange = Distance(-1, "feet")
_aHI1.ShowObjects = "OnEnter"
_aHI1.ProximityRange = Distance(60, "meters")
_aHI1.AllowSetPositionTo = false
_aHI1.Active = true
_aHI1.Points = {
	ZonePoint(54.0615913955894, 13.4649182184423, 0), 
	ZonePoint(54.061126730301, 13.4649182184423, 0), 
	ZonePoint(54.061126730301, 13.4657915405557, 0), 
	ZonePoint(54.0615913955894, 13.4657915405557, 0)
}
_aHI1.OriginalPoint = ZonePoint(54.0613590629452, 13.465354879499, 0)
_aHI1.DistanceRangeUOM = "Feet"
_aHI1.ProximityRangeUOM = "Meters"
_aHI1.OutOfRangeName = ""
_aHI1.InRangeName = ""
_dvDF = Wherigo.Zone(_iwV)
_dvDF.Id = "0b0ddd36-2cc7-410a-ab6a-f187ee029240"
_dvDF.Name = _IGB("\058\105\037\037\127\035\110\018\025")
_dvDF.Description = ""
_dvDF.Visible = false
_dvDF.Commands = {}
_dvDF.DistanceRange = Distance(30, "meters")
_dvDF.ShowObjects = "OnEnter"
_dvDF.ProximityRange = Distance(60, "meters")
_dvDF.AllowSetPositionTo = false
_dvDF.Active = true
_dvDF.Points = {
	ZonePoint(54.0617047070988, 13.4716198243904, 0), 
	ZonePoint(54.0618867390094, 13.4711382729447, 0), 
	ZonePoint(54.0615753681512, 13.4696609710519, 0), 
	ZonePoint(54.0609574098423, 13.4639639725925, 0), 
	ZonePoint(54.0610349832761, 13.4625708583774, 0), 
	ZonePoint(54.0615879388687, 13.4614962025384, 0), 
	ZonePoint(54.063106643245, 13.460896167443, 0), 
	ZonePoint(54.0641520958682, 13.4605586477019, 0), 
	ZonePoint(54.0647353369477, 13.4611961849907, 0), 
	ZonePoint(54.0650171786798, 13.461947108792, 0), 
	ZonePoint(54.0655040669209, 13.4645862456959, 0), 
	ZonePoint(54.0665461804898, 13.4668199476327, 0), 
	ZonePoint(54.0669643134029, 13.4670824525274, 0), 
	ZonePoint(54.0669643134029, 13.467701214065, 0), 
	ZonePoint(54.066964295201, 13.4682074218099, 0), 
	ZonePoint(54.0669973358514, 13.4689011950849, 0), 
	ZonePoint(54.0671844302045, 13.4695385725652, 0), 
	ZonePoint(54.0671803672949, 13.4705348528848, 0), 
	ZonePoint(54.0671693699757, 13.4713406506416, 0), 
	ZonePoint(54.0669824267596, 13.4720714727493, 0), 
	ZonePoint(54.0666525168322, 13.4733644845351, 0), 
	ZonePoint(54.0663445985352, 13.4740390993799, 0), 
	ZonePoint(54.066069669555, 13.4740765779824, 0), 
	ZonePoint(54.0658827168087, 13.4740203600786, 0), 
	ZonePoint(54.0658277305467, 13.4738891849699, 0), 
	ZonePoint(54.0658057360215, 13.4736455740538, 0), 
	ZonePoint(54.0658057360215, 13.472352562268, 0), 
	ZonePoint(54.0658167332856, 13.4710970290846, 0), 
	ZonePoint(54.0658607223127, 13.4699164531063, 0), 
	ZonePoint(54.0658607223127, 13.4695604063826, 0), 
	ZonePoint(54.0657507496576, 13.4688483129354, 0), 
	ZonePoint(54.0656077847706, 13.4685297448142, 0), 
	ZonePoint(54.0654318273109, 13.468286133898, 0), 
	ZonePoint(54.0653108561249, 13.4681362194881, 0), 
	ZonePoint(54.0652778639221, 13.467667736957, 0), 
	ZonePoint(54.0652668665154, 13.466899425606, 0), 
	ZonePoint(54.0652668665154, 13.4664496823761, 0), 
	ZonePoint(54.0648599604181, 13.4655876745189, 0), 
	ZonePoint(54.0647719801972, 13.4648193631679, 0), 
	ZonePoint(54.0647279900168, 13.4638823981057, 0), 
	ZonePoint(54.0645740240186, 13.4633576976709, 0), 
	ZonePoint(54.0642880856504, 13.463057868851, 0), 
	ZonePoint(54.0640791294439, 13.4626081256211, 0), 
	ZonePoint(54.0638993019318, 13.4621255428526, 0), 
	ZonePoint(54.0636243464651, 13.4618069628002, 0), 
	ZonePoint(54.063415379093, 13.4617882227971, 0), 
	ZonePoint(54.0631954123022, 13.4618631828094, 0), 
	ZonePoint(54.0631404204224, 13.4619568828249, 0), 
	ZonePoint(54.0631624171831, 13.4623691628927, 0), 
	ZonePoint(54.063184413932, 13.4627814429605, 0), 
	ZonePoint(54.0632614024617, 13.4631937230283, 0), 
	ZonePoint(54.0634043807811, 13.463587263093, 0), 
	ZonePoint(54.0635702627564, 13.4637819407708, 0), 
	ZonePoint(54.0637473915478, 13.4639369249144, 0), 
	ZonePoint(54.0638335620374, 13.4642305790787, 0), 
	ZonePoint(54.0638814344544, 13.4646384320847, 0), 
	ZonePoint(54.0638814344544, 13.4650462850907, 0), 
	ZonePoint(54.0638335620374, 13.4655601798782, 0), 
	ZonePoint(54.0637617533085, 13.4658293628622, 0), 
	ZonePoint(54.0635846245795, 13.466155645267, 0), 
	ZonePoint(54.0633883459164, 13.4662861582288, 0), 
	ZonePoint(54.0632686633494, 13.4663595717699, 0), 
	ZonePoint(54.0631011071763, 13.4664003570705, 0), 
	ZonePoint(54.0629526997156, 13.4662127446878, 0), 
	ZonePoint(54.0629239756296, 13.4657885775615, 0), 
	ZonePoint(54.0629096135792, 13.4653562533752, 0), 
	ZonePoint(54.0629191882801, 13.4647363168061, 0), 
	ZonePoint(54.0629526997156, 13.4643937202811, 0), 
	ZonePoint(54.062904826228, 13.4640919090567, 0), 
	ZonePoint(54.0626798200973, 13.4634719724876, 0), 
	ZonePoint(54.0624643875533, 13.4629662347602, 0), 
	ZonePoint(54.0621962921601, 13.462680737656, 0), 
	ZonePoint(54.0620813936047, 13.4625175964536, 0), 
	ZonePoint(54.0617558459716, 13.4626644235357, 0), 
	ZonePoint(54.0616026462025, 13.4629336065197, 0), 
	ZonePoint(54.0615643461719, 13.4636840560507, 0), 
	ZonePoint(54.0615547711587, 13.4642713643793, 0), 
	ZonePoint(54.0615978587006, 13.4648260444674, 0), 
	ZonePoint(54.0616840336502, 13.4653154680746, 0), 
	ZonePoint(54.0618132957393, 13.4658130487419, 0), 
	ZonePoint(54.0619042577091, 13.4663106294092, 0), 
	ZonePoint(54.0620861810509, 13.4668897806777, 0), 
	ZonePoint(54.0622585287449, 13.4676239160884, 0), 
	ZonePoint(54.0623638520261, 13.4681051828266, 0), 
	ZonePoint(54.0624213009759, 13.4686027636945, 0), 
	ZonePoint(54.0624500254211, 13.469132972816, 0), 
	ZonePoint(54.0624978994522, 13.4696550248741, 0), 
	ZonePoint(54.0625122616507, 13.4699649932836, 0), 
	ZonePoint(54.062521836447, 13.4704054747076, 0), 
	ZonePoint(54.0624691750402, 13.4708296420048, 0), 
	ZonePoint(54.0623303401019, 13.471253809302, 0), 
	ZonePoint(54.0621771423901, 13.4715719347749, 0), 
	ZonePoint(54.0620766060846, 13.4717432331065, 0), 
	ZonePoint(54.0619760695358, 13.4718084896137, 0), 
	ZonePoint(54.0619425572988, 13.4718248037405, 0)
}
_dvDF.OriginalPoint = ZonePoint(54.0638109653849, 13.4666638831707, 0)
_dvDF.DistanceRangeUOM = "Meters"
_dvDF.ProximityRangeUOM = "Meters"
_dvDF.OutOfRangeName = ""
_dvDF.InRangeName = ""
_xf4 = Wherigo.Zone(_iwV)
_xf4.Id = "002ce58d-d048-4272-b3a7-fdafa66a009d"
_xf4.Name = _IGB("\058\105\037\037\127\035\110\018\094")
_xf4.Description = ""
_xf4.Visible = false
_xf4.Commands = {}
_xf4.DistanceRange = Distance(30, "meters")
_xf4.ShowObjects = "OnEnter"
_xf4.ProximityRange = Distance(60, "meters")
_xf4.AllowSetPositionTo = false
_xf4.Active = true
_xf4.Points = {
	ZonePoint(54.0616596807263, 13.4747354663202, 0), 
	ZonePoint(54.0619665602832, 13.4749315430959, 0), 
	ZonePoint(54.0623405666775, 13.475282847319, 0), 
	ZonePoint(54.0625083889649, 13.4756178118109, 0), 
	ZonePoint(54.0624748245617, 13.4760017954966, 0), 
	ZonePoint(54.0624076956739, 13.4763122503915, 0), 
	ZonePoint(54.0623165920097, 13.4765655162267, 0), 
	ZonePoint(54.0622734375727, 13.4768759711216, 0), 
	ZonePoint(54.0622158982536, 13.4772599548073, 0), 
	ZonePoint(54.0622686426325, 13.4777909960748, 0), 
	ZonePoint(54.0623597464018, 13.4782403386858, 0), 
	ZonePoint(54.0624700296447, 13.4787877196846, 0), 
	ZonePoint(54.0621487689473, 13.4790083060573, 0), 
	ZonePoint(54.0619329954421, 13.4792125526986, 0)
}
_xf4.OriginalPoint = ZonePoint(54.0622388448423, 13.4769016478422, 0)
_xf4.DistanceRangeUOM = "Meters"
_xf4.ProximityRangeUOM = "Meters"
_xf4.OutOfRangeName = ""
_xf4.InRangeName = ""
_OGmN5 = Wherigo.Zone(_iwV)
_OGmN5.Id = "a530e80b-5082-4b8c-b43c-2b2016245476"
_OGmN5.Name = _IGB("\058\105\037\037\127\035\110\018\010")
_OGmN5.Description = ""
_OGmN5.Visible = false
_OGmN5.Commands = {}
_OGmN5.DistanceRange = Distance(30, "meters")
_OGmN5.ShowObjects = "OnEnter"
_OGmN5.ProximityRange = Distance(60, "meters")
_OGmN5.AllowSetPositionTo = false
_OGmN5.Active = true
_OGmN5.Points = {
	ZonePoint(54.0650864538752, 13.4780640015227, 0), 
	ZonePoint(54.0648991961902, 13.4769753750191, 0), 
	ZonePoint(54.0648220898391, 13.4762809063875, 0), 
	ZonePoint(54.0647670137865, 13.475548898911, 0), 
	ZonePoint(54.0644806171351, 13.4751547410391, 0), 
	ZonePoint(54.0642603106747, 13.4746855054772, 0), 
	ZonePoint(54.0641721877633, 13.4743288864502, 0), 
	ZonePoint(54.064205233877, 13.4738596508883, 0), 
	ZonePoint(54.0639628950994, 13.4734279541714, 0), 
	ZonePoint(54.0636654773941, 13.4729587186095, 0), 
	ZonePoint(54.0636434463682, 13.4726959466948, 0), 
	ZonePoint(54.0637095394107, 13.4722079417105, 0), 
	ZonePoint(54.0637976633038, 13.4717011673037, 0), 
	ZonePoint(54.0637536013807, 13.4712131623193, 0), 
	ZonePoint(54.0636544618826, 13.4707814656024, 0), 
	ZonePoint(54.0637205549076, 13.4703685383079, 0), 
	ZonePoint(54.0637425858926, 13.4701245358158, 0), 
	ZonePoint(54.0637866478274, 13.4696365308314, 0), 
	ZonePoint(54.0639304905352, 13.4694404540561, 0), 
	ZonePoint(54.0641989955903, 13.4695221527126, 0), 
	ZonePoint(54.0643716050661, 13.4697427390853, 0), 
	ZonePoint(54.0645106510666, 13.4700286843831, 0), 
	ZonePoint(54.0646113392591, 13.4703963283375, 0), 
	ZonePoint(54.0646353126022, 13.4707966517546, 0), 
	ZonePoint(54.0646065445888, 13.4709600490677, 0), 
	ZonePoint(54.064549008502, 13.471164295709, 0), 
	ZonePoint(54.0645298297887, 13.4715074300665, 0), 
	ZonePoint(54.0645681872065, 13.4717770356331, 0), 
	ZonePoint(54.0644866776514, 13.4722999070349, 0), 
	ZonePoint(54.064457909535, 13.4726103619298, 0), 
	ZonePoint(54.0646496966015, 13.4730433648094, 0), 
	ZonePoint(54.064875045273, 13.4739828993596, 0), 
	ZonePoint(54.0651099819476, 13.4740891076131, 0), 
	ZonePoint(54.0651339550029, 13.4739338801657, 0), 
	ZonePoint(54.0650092949641, 13.4736969540617, 0), 
	ZonePoint(54.0649373755406, 13.4733701594355, 0), 
	ZonePoint(54.0648942238268, 13.4729943456154, 0), 
	ZonePoint(54.0647983309689, 13.4727165701832, 0), 
	ZonePoint(54.0647791523708, 13.4723979454227, 0), 
	ZonePoint(54.0647887416709, 13.4719894521399, 0), 
	ZonePoint(54.0647935363202, 13.4716463177825, 0), 
	ZonePoint(54.0647983309689, 13.4714420711411, 0), 
	ZonePoint(54.0648366881386, 13.4711397861119, 0), 
	ZonePoint(54.0648654559927, 13.4707312928292, 0), 
	ZonePoint(54.0648606613517, 13.4703391392778, 0), 
	ZonePoint(54.0648606613517, 13.4701594022334, 0), 
	ZonePoint(54.0647839470211, 13.4697754185476, 0), 
	ZonePoint(54.0647072325488, 13.4695793417719, 0), 
	ZonePoint(54.0644866776515, 13.4690891498326, 0), 
	ZonePoint(54.06434283687, 13.4688603935943, 0), 
	ZonePoint(54.0641078958555, 13.4687378456095, 0), 
	ZonePoint(54.0639640537621, 13.4687215058782, 0), 
	ZonePoint(54.0637866478274, 13.4687378456095, 0), 
	ZonePoint(54.0635373192869, 13.4689992813104, 0), 
	ZonePoint(54.0634414232958, 13.4691871882204, 0), 
	ZonePoint(54.0633263478142, 13.469456793787, 0), 
	ZonePoint(54.0631825030139, 13.4700205145172, 0), 
	ZonePoint(54.0631105804269, 13.4703636488746, 0), 
	ZonePoint(54.0631057855833, 13.4707884818887, 0), 
	ZonePoint(54.0630722216629, 13.4712133149026, 0), 
	ZonePoint(54.0630961958945, 13.4719649425428, 0), 
	ZonePoint(54.0630530422676, 13.4725204934073, 0), 
	ZonePoint(54.063024273158, 13.4728554578991, 0), 
	ZonePoint(54.0631105804269, 13.4732476114505, 0), 
	ZonePoint(54.0632400409938, 13.4736397650019, 0), 
	ZonePoint(54.0633023737154, 13.4739992390906, 0), 
	ZonePoint(54.0633311426323, 13.4744976008955, 0), 
	ZonePoint(54.0633455270833, 13.4748080557903, 0), 
	ZonePoint(54.0633838855949, 13.4753309271922, 0), 
	ZonePoint(54.0634941661183, 13.4757475903406, 0), 
	ZonePoint(54.0635469088738, 13.476090724698, 0), 
	ZonePoint(54.0637003419635, 13.4763685001303, 0), 
	ZonePoint(54.0638106216466, 13.4766054262343, 0), 
	ZonePoint(54.0638106216466, 13.4770465989796, 0), 
	ZonePoint(54.0638010321206, 13.4773733936057, 0), 
	ZonePoint(54.0637818530619, 13.4778799252763, 0), 
	ZonePoint(54.0639154856091, 13.4777630486013, 0), 
	ZonePoint(54.0646538706002, 13.4778529171232, 0)
}
_OGmN5.OriginalPoint = ZonePoint(54.0641273730297, 13.4725263544566, 0)
_OGmN5.DistanceRangeUOM = "Meters"
_OGmN5.ProximityRangeUOM = "Meters"
_OGmN5.OutOfRangeName = ""
_OGmN5.InRangeName = ""
_k1V = Wherigo.Zone(_iwV)
_k1V.Id = "131c3356-32a6-4048-87ec-b5586a9d6f3d"
_k1V.Name = _IGB("\064\037\087\122\018\025")
_k1V.Description = ""
_k1V.Visible = false
_k1V.Commands = {}
_k1V.DistanceRange = Distance(-1, "feet")
_k1V.ShowObjects = "OnEnter"
_k1V.ProximityRange = Distance(60, "meters")
_k1V.AllowSetPositionTo = false
_k1V.Active = true
_k1V.Points = {
	ZonePoint(54.0651045666749, 13.474078439191, 0), 
	ZonePoint(54.0651764858088, 13.4742500063697, 0), 
	ZonePoint(54.0652148426292, 13.4744869324737, 0), 
	ZonePoint(54.0652148426292, 13.4747810476373, 0), 
	ZonePoint(54.0651333343434, 13.4751078422634, 0), 
	ZonePoint(54.0650278527949, 13.4753937875613, 0), 
	ZonePoint(54.0648983978009, 13.4755408451431, 0), 
	ZonePoint(54.0647662347449, 13.4755419027276, 0), 
	ZonePoint(54.0644875233207, 13.4751533053168, 0), 
	ZonePoint(54.0642634138916, 13.4746876229745, 0), 
	ZonePoint(54.0641744013215, 13.4743235351606, 0), 
	ZonePoint(54.0642127590675, 13.4738496829527, 0), 
	ZonePoint(54.0636711232936, 13.4729558227702, 0), 
	ZonePoint(54.0636481657527, 13.4726962245083, 0), 
	ZonePoint(54.0638026071468, 13.4716969490071, 0), 
	ZonePoint(54.063758779242, 13.4712097577486, 0), 
	ZonePoint(54.0636606880493, 13.4707794647391, 0), 
	ZonePoint(54.0637253865215, 13.4703598401515, 0), 
	ZonePoint(54.063790084893, 13.469637943615, 0), 
	ZonePoint(54.0639299165127, 13.4694459120241, 0), 
	ZonePoint(54.0641991432308, 13.4695241471167, 0), 
	ZonePoint(54.0643723657004, 13.4697446278323, 0), 
	ZonePoint(54.0645080213467, 13.4700255629376, 0), 
	ZonePoint(54.0646040235364, 13.4703882892761, 0), 
	ZonePoint(54.0646290675494, 13.470797245442, 0), 
	ZonePoint(54.0645998495328, 13.4709750524707, 0), 
	ZonePoint(54.0645435004427, 13.47115641564, 0), 
	ZonePoint(54.0645247173957, 13.471497805135, 0), 
	ZonePoint(54.064564370485, 13.4717751840998, 0), 
	ZonePoint(54.0644850642685, 13.4722837122018, 0), 
	ZonePoint(54.0644537591414, 13.4726179894157, 0), 
	ZonePoint(54.0646457635497, 13.4730482824252, 0), 
	ZonePoint(54.0648732458845, 13.4739906596772, 0)
}
_k1V.OriginalPoint = ZonePoint(54.0644443726819, 13.4725394496365, 0)
_k1V.DistanceRangeUOM = "Feet"
_k1V.ProximityRangeUOM = "Meters"
_k1V.OutOfRangeName = ""
_k1V.InRangeName = ""
_EuXA = Wherigo.Zone(_iwV)
_EuXA.Id = "9c86fbde-43b7-40fb-a5ed-c33c81689379"
_EuXA.Name = _IGB("\064\037\087\122\018\094")
_EuXA.Description = ""
_EuXA.Visible = false
_EuXA.Commands = {}
_EuXA.DistanceRange = Distance(-1, "feet")
_EuXA.ShowObjects = "OnEnter"
_EuXA.ProximityRange = Distance(60, "meters")
_EuXA.AllowSetPositionTo = false
_EuXA.Active = true
_EuXA.Points = {
	ZonePoint(54.0619424369809, 13.4718217338595, 0), 
	ZonePoint(54.0619280557551, 13.4731939171962, 0), 
	ZonePoint(54.0619664056796, 13.4749173141252, 0), 
	ZonePoint(54.0616601172022, 13.4747293631397, 0), 
	ZonePoint(54.0615182273983, 13.4725037934509, 0), 
	ZonePoint(54.0616016920475, 13.4718851846237, 0), 
	ZonePoint(54.0617060226232, 13.4716220981109, 0)
}
_EuXA.OriginalPoint = ZonePoint(54.0617604225267, 13.4729533435009, 0)
_EuXA.DistanceRangeUOM = "Feet"
_EuXA.ProximityRangeUOM = "Meters"
_EuXA.OutOfRangeName = ""
_EuXA.InRangeName = ""
_mSCV = Wherigo.Zone(_iwV)
_mSCV.Id = "c9a79ec9-f151-4718-97c4-0ce92a55d3d3"
_mSCV.Name = _IGB("\076\077\087\127\062\105\018\025")
_mSCV.Description = ""
_mSCV.Visible = false
_mSCV.Commands = {}
_mSCV.DistanceRange = Distance(-1, "feet")
_mSCV.ShowObjects = "OnEnter"
_mSCV.ProximityRange = Distance(60, "meters")
_mSCV.AllowSetPositionTo = false
_mSCV.Active = true
_mSCV.Points = {
	ZonePoint(54.066455828012, 13.4793407881701, 0), 
	ZonePoint(54.0663359531101, 13.4787361510163, 0), 
	ZonePoint(54.0664606230009, 13.4783848078053, 0), 
	ZonePoint(54.0666476271353, 13.4780988307731, 0), 
	ZonePoint(54.0668825798541, 13.4776085844322, 0), 
	ZonePoint(54.0671894548725, 13.4770039472783, 0), 
	ZonePoint(54.0674244045256, 13.4766199209779, 0), 
	ZonePoint(54.0674483789052, 13.476293090084, 0), 
	ZonePoint(54.0672853528506, 13.4758355268325, 0), 
	ZonePoint(54.0673524813036, 13.4752717435404, 0), 
	ZonePoint(54.0675490711486, 13.4748550341507, 0), 
	ZonePoint(54.0677984032719, 13.474511861712, 0), 
	ZonePoint(54.0681292455089, 13.474160518501, 0), 
	ZonePoint(54.0684888536462, 13.4736702721601, 0), 
	ZonePoint(54.0687621537478, 13.4731636842745, 0), 
	ZonePoint(54.0688820216459, 13.4725590471206, 0), 
	ZonePoint(54.0689012004774, 13.4719135561051, 0), 
	ZonePoint(54.0688772269366, 13.4714233097642, 0), 
	ZonePoint(54.068709411763, 13.4712680650896, 0), 
	ZonePoint(54.0685703643911, 13.4714314805366, 0), 
	ZonePoint(54.0683689846132, 13.4717011160241, 0), 
	ZonePoint(54.0681617648191, 13.4722616128925, 0), 
	ZonePoint(54.0678202816823, 13.473012473113, 0), 
	ZonePoint(54.0674677800149, 13.4736694758058, 0), 
	ZonePoint(54.0670932437145, 13.4743452500042, 0), 
	ZonePoint(54.0669330679896, 13.4742414597418, 0), 
	ZonePoint(54.0668083997886, 13.4740617029327, 0), 
	ZonePoint(54.0670001972835, 13.4735387735024, 0), 
	ZonePoint(54.0671824040831, 13.4732119426084, 0), 
	ZonePoint(54.0674413281598, 13.4723703530566, 0), 
	ZonePoint(54.0676427124366, 13.4716431543176, 0), 
	ZonePoint(54.067834506078, 13.471161078749, 0), 
	ZonePoint(54.0678536853934, 13.4704665630994, 0), 
	ZonePoint(54.0679304025665, 13.4699518044414, 0), 
	ZonePoint(54.0680262988335, 13.4689631409873, 0), 
	ZonePoint(54.0679639662851, 13.4685872854592, 0), 
	ZonePoint(54.0679304025665, 13.4681705760695, 0), 
	ZonePoint(54.0679783507277, 13.467713012818, 0), 
	ZonePoint(54.0678365914347, 13.4671556385181, 0), 
	ZonePoint(54.0676162783298, 13.4667238938914, 0), 
	ZonePoint(54.0673298695459, 13.4663860067922, 0), 
	ZonePoint(54.0669663478599, 13.4656726895828, 0), 
	ZonePoint(54.0668011096779, 13.4648092003293, 0), 
	ZonePoint(54.0667019664531, 13.4638518535482, 0), 
	ZonePoint(54.0667129823787, 13.4630822218223, 0), 
	ZonePoint(54.0667570460517, 13.4621811895577, 0), 
	ZonePoint(54.0664375833631, 13.4613740148207, 0), 
	ZonePoint(54.0661621825211, 13.4608671841719, 0), 
	ZonePoint(54.0657215373749, 13.4602101814791, 0), 
	ZonePoint(54.06456482162, 13.460135095457, 0), 
	ZonePoint(54.063968500588, 13.4603236914098, 0), 
	ZonePoint(54.0637575078908, 13.4604135698976, 0), 
	ZonePoint(54.0634793795177, 13.4604299114423, 0), 
	ZonePoint(54.0630382065535, 13.4607567423362, 0), 
	ZonePoint(54.0628799585875, 13.4607567423362, 0), 
	ZonePoint(54.0625778471597, 13.4608384500596, 0), 
	ZonePoint(54.0622085968747, 13.4609773531895, 0), 
	ZonePoint(54.061743432752, 13.4611897932706, 0), 
	ZonePoint(54.061628339794, 13.4612633302217, 0), 
	ZonePoint(54.0615899754038, 13.4614757703028, 0), 
	ZonePoint(54.0632472715349, 13.4608420327586, 0), 
	ZonePoint(54.0641531505132, 13.4605503968694, 0), 
	ZonePoint(54.0647375780776, 13.4611870166764, 0), 
	ZonePoint(54.065021439927, 13.4619338890758, 0), 
	ZonePoint(54.0655077575566, 13.4645728382203, 0), 
	ZonePoint(54.0665534255321, 13.4668170119537, 0), 
	ZonePoint(54.0669729376185, 13.467080195561, 0), 
	ZonePoint(54.0669666762752, 13.4681933910897, 0), 
	ZonePoint(54.0670021572079, 13.4688975850663, 0), 
	ZonePoint(54.067192084038, 13.4695342048733, 0), 
	ZonePoint(54.0671733001045, 13.4713338117023, 0), 
	ZonePoint(54.0666556950384, 13.4733752629273, 0), 
	ZonePoint(54.0663467986184, 13.4740438915515, 0), 
	ZonePoint(54.066073381627, 13.4740865699743, 0), 
	ZonePoint(54.0658813625111, 13.4740296654106, 0), 
	ZonePoint(54.0658250089064, 13.4738945170717, 0), 
	ZonePoint(54.0658020500085, 13.4736526726756, 0), 
	ZonePoint(54.0658020500085, 13.4722762935397, 0), 
	ZonePoint(54.0658124858728, 13.4711595414758, 0), 
	ZonePoint(54.0658584036444, 13.4699147541435, 0), 
	ZonePoint(54.0658584036444, 13.4695555440848, 0), 
	ZonePoint(54.0657477834721, 13.4688513501082, 0), 
	ZonePoint(54.0656037680893, 13.4685277054018, 0), 
	ZonePoint(54.0653094742322, 13.4681435995964, 0), 
	ZonePoint(54.0652739918532, 13.4676670238749, 0), 
	ZonePoint(54.0652614686534, 13.4664471322892, 0), 
	ZonePoint(54.0648544626035, 13.4655900072976, 0), 
	ZonePoint(54.0647667992399, 13.4648111260811, 0), 
	ZonePoint(54.064725054716, 13.4638793138494, 0), 
	ZonePoint(54.0645726868477, 13.4633600597051, 0), 
	ZonePoint(54.0642825601828, 13.4630648672805, 0), 
	ZonePoint(54.0638964172332, 13.4621259419785, 0), 
	ZonePoint(54.0636271586734, 13.4618129668778, 0), 
	ZonePoint(54.0634079934407, 13.4617987407368, 0), 
	ZonePoint(54.0631992635723, 13.4618698714415, 0), 
	ZonePoint(54.0631533428605, 13.4619516717519, 0), 
	ZonePoint(54.0631909143557, 13.4627767879265, 0), 
	ZonePoint(54.0632702318452, 13.4631857894786, 0), 
	ZonePoint(54.063410080734, 13.4635805648897, 0), 
	ZonePoint(54.0635708020097, 13.4637726177924, 0), 
	ZonePoint(54.0637544827061, 13.4639255488075, 0), 
	ZonePoint(54.0638379736631, 13.4642100716263, 0), 
	ZonePoint(54.0638880681568, 13.464629742784, 0), 
	ZonePoint(54.063883893618, 13.4650565270123, 0), 
	ZonePoint(54.0638379736631, 13.4655615550157, 0), 
	ZonePoint(54.0637649190849, 13.4658354082288, 0), 
	ZonePoint(54.0635895875728, 13.4661661660056, 0), 
	ZonePoint(54.0632744064458, 13.4663617754436, 0), 
	ZonePoint(54.0631032474806, 13.4664044538664, 0), 
	ZonePoint(54.0629504075574, 13.4662137418374, 0), 
	ZonePoint(54.0629222422731, 13.4657911182152, 0), 
	ZonePoint(54.0629086139029, 13.4653746868805, 0), 
	ZonePoint(54.0629167909255, 13.46473068898, 0), 
	ZonePoint(54.0629513161146, 13.464393209311, 0), 
	ZonePoint(54.0629031625535, 13.464092883367, 0), 
	ZonePoint(54.0626778394881, 13.4634721065447, 0), 
	ZonePoint(54.0624634180165, 13.462967435113, 0), 
	ZonePoint(54.0621944810465, 13.4626841379597, 0), 
	ZonePoint(54.0620809091679, 13.4625215904127, 0), 
	ZonePoint(54.0617565461726, 13.4626655610972, 0), 
	ZonePoint(54.0616048124733, 13.4629349256036, 0), 
	ZonePoint(54.0615666518149, 13.4636718078167, 0), 
	ZonePoint(54.0615575659387, 13.4642693635609, 0), 
	ZonePoint(54.0616011781264, 13.4648235732926, 0), 
	ZonePoint(54.0616865851945, 13.4653127640055, 0), 
	ZonePoint(54.0618174212136, 13.4658081470058, 0), 
	ZonePoint(54.0619073707377, 13.46630662615, 0), 
	ZonePoint(54.0620899949297, 13.4668871531035, 0), 
	ZonePoint(54.0623671097072, 13.4681008414544, 0), 
	ZonePoint(54.0624243495784, 13.4686024167423, 0), 
	ZonePoint(54.0624516066322, 13.4691148285333, 0), 
	ZonePoint(54.0625006692839, 13.4696489133306, 0), 
	ZonePoint(54.0625242920215, 13.470405920478, 0), 
	ZonePoint(54.0624725036946, 13.4708300921721, 0), 
	ZonePoint(54.0623316754617, 13.4712573600099, 0), 
	ZonePoint(54.0621808524375, 13.471568522457, 0), 
	ZonePoint(54.0620790920154, 13.4717450026509, 0), 
	ZonePoint(54.0619446225038, 13.4718270504603, 0), 
	ZonePoint(54.0619309938128, 13.4731909017832, 0), 
	ZonePoint(54.0619700627151, 13.4749262903564, 0), 
	ZonePoint(54.062339852598, 13.4752792507442, 0), 
	ZonePoint(54.0625124806544, 13.4756167304132, 0), 
	ZonePoint(54.0624788636681, 13.4760022003103, 0), 
	ZonePoint(54.0624098124758, 13.4763102666137, 0), 
	ZonePoint(54.0623189554688, 13.4765641504014, 0), 
	ZonePoint(54.0622181039584, 13.4772592346738, 0), 
	ZonePoint(54.0622698926024, 13.4777902233274, 0), 
	ZonePoint(54.0624743208301, 13.4787856335437, 0), 
	ZonePoint(54.0637799120426, 13.4778614346337, 0), 
	ZonePoint(54.0638085230281, 13.4770480585368, 0), 
	ZonePoint(54.0638103401051, 13.4766068580521, 0), 
	ZonePoint(54.0637013153494, 13.4763715511269, 0), 
	ZonePoint(54.0635459545782, 13.4760944462611, 0), 
	ZonePoint(54.06349325898, 13.4757507743046, 0), 
	ZonePoint(54.0633805992008, 13.4753327948981, 0), 
	ZonePoint(54.0633415316254, 13.4747692967351, 0), 
	ZonePoint(54.0633015554636, 13.4740045492283, 0), 
	ZonePoint(54.0632397740471, 13.473646944625, 0), 
	ZonePoint(54.0631098510624, 13.4732552824403, 0), 
	ZonePoint(54.0630226298097, 13.4728527837525, 0), 
	ZonePoint(54.0630944056456, 13.4719703827831, 0), 
	ZonePoint(54.0630707832323, 13.4712118275638, 0), 
	ZonePoint(54.0631043997395, 13.4707953962291, 0), 
	ZonePoint(54.0631080339549, 13.4703603880319, 0), 
	ZonePoint(54.0631807181954, 13.4700244564347, 0), 
	ZonePoint(54.0633251777457, 13.4694532179124, 0), 
	ZonePoint(54.0635368691351, 13.4689949886371, 0), 
	ZonePoint(54.0637858095601, 13.4687349125618, 0), 
	ZonePoint(54.0639602486768, 13.4687163356993, 0), 
	ZonePoint(54.0641101567073, 13.4687349125619, 0), 
	ZonePoint(54.0643463743239, 13.4688556621682, 0), 
	ZonePoint(54.0644908298197, 13.4690925171652, 0), 
	ZonePoint(54.0647879159582, 13.4697721207189, 0), 
	ZonePoint(54.0648651398357, 13.4701544944723, 0), 
	ZonePoint(54.0648705909275, 13.4707334733539, 0), 
	ZonePoint(54.0648387928819, 13.4711483566168, 0), 
	ZonePoint(54.0648024522285, 13.4714409422014, 0), 
	ZonePoint(54.0647815563383, 13.4723976506208, 0), 
	ZonePoint(54.064800635195, 13.4727150053555, 0), 
	ZonePoint(54.0648978463759, 13.4729874660057, 0), 
	ZonePoint(54.0649387295149, 13.4733574551841, 0), 
	ZonePoint(54.0650132275757, 13.4736933867812, 0), 
	ZonePoint(54.0651395105687, 13.4739271456345, 0), 
	ZonePoint(54.0651140722989, 13.4740912412533, 0), 
	ZonePoint(54.0651803934698, 13.4742491445847, 0), 
	ZonePoint(54.0652185508078, 13.474482903438, 0), 
	ZonePoint(54.0652176423002, 13.4747801332382, 0), 
	ZonePoint(54.0651358765312, 13.4751129686917, 0), 
	ZonePoint(54.0650313978142, 13.4753978139169, 0), 
	ZonePoint(54.0649005719198, 13.4755433326732, 0), 
	ZonePoint(54.0647724711655, 13.4755495249607, 0), 
	ZonePoint(54.0648260736569, 13.4762724745269, 0), 
	ZonePoint(54.0649014804344, 13.4769660107274, 0), 
	ZonePoint(54.065087725503, 13.4780527571845, 0), 
	ZonePoint(54.0656437302023, 13.478322121691, 0), 
	ZonePoint(54.0658190700096, 13.4789134851477, 0), 
	ZonePoint(54.0663768818819, 13.4792556090323, 0), 
	ZonePoint(54.0664377501507, 13.4793701663511, 0)
}
_mSCV.OriginalPoint = ZonePoint(54.0647645316035, 13.4696432793013, 0)
_mSCV.DistanceRangeUOM = "Feet"
_mSCV.ProximityRangeUOM = "Meters"
_mSCV.OutOfRangeName = ""
_mSCV.InRangeName = ""
_ZgXl = Wherigo.Zone(_iwV)
_ZgXl.Id = "8aec6de0-5f2e-4f36-8e6b-827330a6a2c1"
_ZgXl.Name = _IGB("\023\052\088\127\092\018\025")
_ZgXl.Description = ""
_ZgXl.Visible = false
_ZgXl.Commands = {}
_ZgXl.DistanceRange = Distance(-1, "feet")
_ZgXl.ShowObjects = "OnEnter"
_ZgXl.ProximityRange = Distance(60, "meters")
_ZgXl.AllowSetPositionTo = false
_ZgXl.Active = true
_ZgXl.Points = {
	ZonePoint(54.0740911070637, 13.460494164923, 0), 
	ZonePoint(54.0739472835902, 13.4606085557359, 0), 
	ZonePoint(54.0738082537589, 13.4606984342317, 0), 
	ZonePoint(54.0737219591466, 13.4609762404915, 0), 
	ZonePoint(54.0737651064752, 13.4612949006132, 0), 
	ZonePoint(54.0738801657988, 13.4617442930923, 0), 
	ZonePoint(54.0740048130394, 13.4621446609374, 0), 
	ZonePoint(54.0740431659613, 13.4623162471567, 0), 
	ZonePoint(54.0743883406634, 13.4622181978885, 0), 
	ZonePoint(54.0744410754346, 13.4620139285798, 0), 
	ZonePoint(54.0745033982597, 13.4616462438241, 0), 
	ZonePoint(54.0744602516984, 13.4612622175237, 0), 
	ZonePoint(54.0744075169516, 13.4609680697192, 0), 
	ZonePoint(54.074311635422, 13.4604614818335, 0)
}
_ZgXl.OriginalPoint = ZonePoint(54.0741267195188, 13.4613462597536, 0)
_ZgXl.DistanceRangeUOM = "Feet"
_ZgXl.ProximityRangeUOM = "Meters"
_ZgXl.OutOfRangeName = ""
_ZgXl.InRangeName = ""
_PkX = Wherigo.Zone(_iwV)
_PkX.Id = "323a4a68-d96d-4db0-a147-0ef551c15312"
_PkX.Name = _IGB("\003\105\105\052\018\025")
_PkX.Description = ""
_PkX.Visible = false
_PkX.Commands = {}
_PkX.DistanceRange = Distance(-1, "feet")
_PkX.ShowObjects = "OnEnter"
_PkX.ProximityRange = Distance(60, "meters")
_PkX.AllowSetPositionTo = false
_PkX.Active = true
_PkX.Points = {
	ZonePoint(54.0708489659059, 13.442117815772, 0), 
	ZonePoint(54.0709735857971, 13.4427059393592, 0), 
	ZonePoint(54.0712707547974, 13.4436534718052, 0), 
	ZonePoint(54.0716254375942, 13.4442252586261, 0), 
	ZonePoint(54.0721191126595, 13.4444784785039, 0), 
	ZonePoint(54.0736672012533, 13.4445029836533, 0), 
	ZonePoint(54.0738253618534, 13.4459977977707, 0), 
	ZonePoint(54.0740266562911, 13.4467329522547, 0), 
	ZonePoint(54.0745826072867, 13.4496245598915, 0), 
	ZonePoint(54.07518446502, 13.4496301700655, 0), 
	ZonePoint(54.0753496215345, 13.4492173177006, 0), 
	ZonePoint(54.0759772102969, 13.4488982954187, 0), 
	ZonePoint(54.0765167088421, 13.449198551684, 0), 
	ZonePoint(54.076758930398, 13.4497990642148, 0), 
	ZonePoint(54.0770451904146, 13.450606002928, 0), 
	ZonePoint(54.0771112501381, 13.4510751533427, 0), 
	ZonePoint(54.0771332700226, 13.4516193678237, 0), 
	ZonePoint(54.0774046338313, 13.4516485188272, 0), 
	ZonePoint(54.0775771571046, 13.452375504928, 0), 
	ZonePoint(54.0775196494265, 13.4526777351047, 0), 
	ZonePoint(54.0774238031193, 13.4532985322245, 0), 
	ZonePoint(54.0773183719257, 13.4537722984475, 0), 
	ZonePoint(54.077303994924, 13.4540908653905, 0), 
	ZonePoint(54.0772464868675, 13.4544747793988, 0), 
	ZonePoint(54.0771458475769, 13.4547279992766, 0), 
	ZonePoint(54.0770020767384, 13.4550547346028, 0), 
	ZonePoint(54.0768487206285, 13.4552262706491, 0), 
	ZonePoint(54.0768103815125, 13.4554468169942, 0), 
	ZonePoint(54.0768103815125, 13.4558470677688, 0), 
	ZonePoint(54.0766953639521, 13.4564106862065, 0), 
	ZonePoint(54.0765180445887, 13.4568436105137, 0), 
	ZonePoint(54.0763215546797, 13.457072325242, 0), 
	ZonePoint(54.0761538186556, 13.457178514223, 0), 
	ZonePoint(54.0759237795777, 13.457129503924, 0), 
	ZonePoint(54.0757560419463, 13.4567700950651, 0), 
	ZonePoint(54.075784797017, 13.4566148957852, 0), 
	ZonePoint(54.0758518921044, 13.4563044972253, 0), 
	ZonePoint(54.0759812894667, 13.4559940986654, 0), 
	ZonePoint(54.0760531767159, 13.4558143942359, 0), 
	ZonePoint(54.0761011014796, 13.4554958272928, 0), 
	ZonePoint(54.0760963090057, 13.455136418434, 0), 
	ZonePoint(54.0760963090057, 13.4547034941267, 0), 
	ZonePoint(54.0761298563112, 13.4544911161647, 0), 
	ZonePoint(54.0761154788979, 13.4539601712595, 0), 
	ZonePoint(54.0760483842365, 13.4536497726996, 0), 
	ZonePoint(54.0758950246033, 13.4534864050366, 0), 
	ZonePoint(54.075861477108, 13.4535844256344, 0), 
	ZonePoint(54.0752001066653, 13.4559450883663, 0), 
	ZonePoint(54.0734459861989, 13.4570233149427, 0), 
	ZonePoint(54.0734411934185, 13.4574807443994, 0), 
	ZonePoint(54.0730577691938, 13.4574807443994, 0), 
	ZonePoint(54.0730721476662, 13.4569743046438, 0), 
	ZonePoint(54.07184995974, 13.4558797413009, 0), 
	ZonePoint(54.0714856928496, 13.4552752809475, 0), 
	ZonePoint(54.071289179121, 13.4549485456212, 0), 
	ZonePoint(54.0712843860916, 13.454572799996, 0), 
	ZonePoint(54.0712508348704, 13.4540663602404, 0), 
	ZonePoint(54.0711070436153, 13.4527512505524, 0), 
	ZonePoint(54.071174146263, 13.4523755049272, 0), 
	ZonePoint(54.0714617278106, 13.4525470409735, 0), 
	ZonePoint(54.0719218541434, 13.4525307042072, 0), 
	ZonePoint(54.0722957030341, 13.4528084292345, 0), 
	ZonePoint(54.0724251114812, 13.4526287248051, 0), 
	ZonePoint(54.072760612984, 13.4512809415844, 0), 
	ZonePoint(54.0718164089759, 13.4490591413662, 0), 
	ZonePoint(54.0704168386585, 13.4484791861622, 0), 
	ZonePoint(54.0701340430362, 13.4488222582547, 0), 
	ZonePoint(54.0700429728496, 13.4489202788525, 0), 
	ZonePoint(54.0698128999093, 13.448789584722, 0), 
	ZonePoint(54.0697457950616, 13.4486262170589, 0), 
	ZonePoint(54.0697745542953, 13.4483403236484, 0), 
	ZonePoint(54.0699758683737, 13.4479972515559, 0), 
	ZonePoint(54.0700285933282, 13.4478012103602, 0), 
	ZonePoint(54.0695301001737, 13.4459959976829, 0), 
	ZonePoint(54.0692472985119, 13.4457264410388, 0), 
	ZonePoint(54.0689405284297, 13.4457427778051, 0), 
	ZonePoint(54.0691322599966, 13.4445420254812, 0), 
	ZonePoint(54.0696834833202, 13.4435699878857, 0), 
	ZonePoint(54.0702394924765, 13.4420098267031, 0), 
	ZonePoint(54.070349455546, 13.4419594682535, 0)
}
_PkX.OriginalPoint = ZonePoint(54.0738400697839, 13.4515789506767, 0)
_PkX.DistanceRangeUOM = "Feet"
_PkX.ProximityRangeUOM = "Meters"
_PkX.OutOfRangeName = ""
_PkX.InRangeName = ""
_hnGa = Wherigo.Zone(_iwV)
_hnGa.Id = "d3cb33c4-48b3-43dc-a072-fd620779a6ec"
_hnGa.Name = _IGB("\076\077\087\127\062\105\018\025")
_hnGa.Description = ""
_hnGa.Visible = false
_hnGa.Commands = {}
_hnGa.DistanceRange = Distance(-1, "feet")
_hnGa.ShowObjects = "OnEnter"
_hnGa.ProximityRange = Distance(60, "meters")
_hnGa.AllowSetPositionTo = false
_hnGa.Active = true
_hnGa.Points = {
	ZonePoint(54.0740365307447, 13.4623102898045, 0), 
	ZonePoint(54.0739981904527, 13.4621550962778, 0), 
	ZonePoint(54.0738783768121, 13.4617548603404, 0), 
	ZonePoint(54.0737681479573, 13.4613301201619, 0), 
	ZonePoint(54.0737154297059, 13.4609952288673, 0), 
	ZonePoint(54.0737969033389, 13.4606930098942, 0), 
	ZonePoint(54.0733559852985, 13.460227429314, 0), 
	ZonePoint(54.0730205010438, 13.4598516976176, 0), 
	ZonePoint(54.0727521116881, 13.4593126043142, 0), 
	ZonePoint(54.0724980987355, 13.4586754940465, 0), 
	ZonePoint(54.072368695313, 13.4584141154751, 0), 
	ZonePoint(54.072148229294, 13.458365106993, 0), 
	ZonePoint(54.0719229693263, 13.4583977793144, 0), 
	ZonePoint(54.0717504289499, 13.4586264855643, 0), 
	ZonePoint(54.07162581601, 13.4588061833322, 0), 
	ZonePoint(54.07162581601, 13.4589532087785, 0), 
	ZonePoint(54.0717408433524, 13.4592227554303, 0), 
	ZonePoint(54.0719229693263, 13.459631159448, 0), 
	ZonePoint(54.0721003017436, 13.4599252103409, 0), 
	ZonePoint(54.0723159752845, 13.4602846058765, 0), 
	ZonePoint(54.0724980987354, 13.4605623206086, 0), 
	ZonePoint(54.0726802213874, 13.4608155310996, 0), 
	ZonePoint(54.0729725745003, 13.4610524054299, 0), 
	ZonePoint(54.0730540495912, 13.4611994308763, 0), 
	ZonePoint(54.0730492569432, 13.461444473287, 0), 
	ZonePoint(54.0730205010437, 13.4616323391351, 0), 
	ZonePoint(54.0729198552387, 13.4619182219475, 0), 
	ZonePoint(54.0727569043703, 13.4620815835547, 0), 
	ZonePoint(54.0725651966476, 13.4622857855635, 0), 
	ZonePoint(54.0724166225535, 13.4623838025278, 0), 
	ZonePoint(54.0722344987452, 13.4625716683759, 0), 
	ZonePoint(54.0721692306623, 13.4626093420296, 0), 
	ZonePoint(54.0718609286124, 13.462684402624, 0), 
	ZonePoint(54.0716186896815, 13.4627782283671, 0), 
	ZonePoint(54.0714204931412, 13.4630597055964, 0), 
	ZonePoint(54.0713434164534, 13.4634725388659, 0), 
	ZonePoint(54.0712443176445, 13.4637352509466, 0), 
	ZonePoint(54.0713103835434, 13.4641480842161, 0), 
	ZonePoint(54.0713103835434, 13.4645609174856, 0), 
	ZonePoint(54.0712002736535, 13.4650300462011, 0), 
	ZonePoint(54.0711342075794, 13.4653678188762, 0), 
	ZonePoint(54.0710351082712, 13.4658181824429, 0), 
	ZonePoint(54.0711782516405, 13.4661371899694, 0), 
	ZonePoint(54.0713764493371, 13.4665687883876, 0), 
	ZonePoint(54.0712773506071, 13.467037917103, 0), 
	ZonePoint(54.0710791524374, 13.4675070458184, 0), 
	ZonePoint(54.0709249976513, 13.4678260533449, 0), 
	ZonePoint(54.0708919644084, 13.4682388866144, 0), 
	ZonePoint(54.0709029754923, 13.4686141895867, 0), 
	ZonePoint(54.0709360087264, 13.4688581365187, 0), 
	ZonePoint(54.0707267977996, 13.4695149167203, 0), 
	ZonePoint(54.0706827532596, 13.4694398561258, 0), 
	ZonePoint(54.0702863502973, 13.4694398561258, 0), 
	ZonePoint(54.0700000569154, 13.4695149167203, 0), 
	ZonePoint(54.0697688185119, 13.4696838030578, 0), 
	ZonePoint(54.069570613141, 13.4697963939496, 0), 
	ZonePoint(54.0695485902636, 13.4701154014761, 0), 
	ZonePoint(54.0695596017038, 13.4709223028666, 0), 
	ZonePoint(54.0694825215614, 13.4714477270278, 0), 
	ZonePoint(54.069416452754, 13.4719919163377, 0), 
	ZonePoint(54.0693613953342, 13.4725736359448, 0), 
	ZonePoint(54.0693283608473, 13.4729677040658, 0), 
	ZonePoint(54.0693283608473, 13.4734743630784, 0), 
	ZonePoint(54.0694959919143, 13.4736534212852, 0), 
	ZonePoint(54.069721262981, 13.4738249493975, 0), 
	ZonePoint(54.069793157745, 13.4739801414991, 0), 
	ZonePoint(54.0697596068706, 13.4742415176703, 0), 
	ZonePoint(54.0696541610889, 13.474421213788, 0), 
	ZonePoint(54.069505577942, 13.4745110618468, 0), 
	ZonePoint(54.0694049245404, 13.4746254139217, 0), 
	ZonePoint(54.0695678870683, 13.4748949580982, 0), 
	ZonePoint(54.0697596068706, 13.4752625183389, 0), 
	ZonePoint(54.0700280131066, 13.4756790866117, 0), 
	ZonePoint(54.0703251751297, 13.4759404627829, 0), 
	ZonePoint(54.0705887848216, 13.4758832867455, 0), 
	ZonePoint(54.0707388352547, 13.4758367939037, 0), 
	ZonePoint(54.0710328582953, 13.4760984091695, 0), 
	ZonePoint(54.0711957426675, 13.4762535329238, 0), 
	ZonePoint(54.0714688120931, 13.4763025193725, 0), 
	ZonePoint(54.0716364854118, 13.4761065735776, 0), 
	ZonePoint(54.0717945767778, 13.4766290956975, 0), 
	ZonePoint(54.0717562516534, 13.4768821923493, 0), 
	ZonePoint(54.0716029508022, 13.4773149059798, 0), 
	ZonePoint(54.0715167188246, 13.4777231263859, 0), 
	ZonePoint(54.0715167188246, 13.4780088806702, 0), 
	ZonePoint(54.071650857379, 13.4785395671982, 0), 
	ZonePoint(54.0717658329378, 13.4787436774012, 0), 
	ZonePoint(54.0719670393996, 13.4788334858906, 0), 
	ZonePoint(54.0722017790393, 13.4788743079312, 0), 
	ZonePoint(54.07239819282, 13.4786212112794, 0), 
	ZonePoint(54.0726506674932, 13.4784643571481, 0), 
	ZonePoint(54.0727800118596, 13.4782684113532, 0), 
	ZonePoint(54.0728854032676, 13.4779336706201, 0), 
	ZonePoint(54.072947679883, 13.4776887383765, 0), 
	ZonePoint(54.0730243278967, 13.4773376688273, 0), 
	ZonePoint(54.0730722328334, 13.476782489075, 0), 
	ZonePoint(54.0730578613582, 13.4764314195257, 0), 
	ZonePoint(54.0729716324024, 13.4762191449146, 0), 
	ZonePoint(54.072952470388, 13.4758680753654, 0), 
	ZonePoint(54.0729955849081, 13.4754843481836, 0), 
	ZonePoint(54.0730626518505, 13.4749128396151, 0), 
	ZonePoint(54.0731057662562, 13.4745617700658, 0), 
	ZonePoint(54.0731249282, 13.4742025361085, 0), 
	ZonePoint(54.0732063663622, 13.4734269173369, 0), 
	ZonePoint(54.0732734329641, 13.4728880664008, 0), 
	ZonePoint(54.0732973852956, 13.4724390239542, 0), 
	ZonePoint(54.0732973852956, 13.4719573238749, 0), 
	ZonePoint(54.0733213376133, 13.4715817611013, 0), 
	ZonePoint(54.0733261280752, 13.4712306915521, 0), 
	ZonePoint(54.0733261280752, 13.4706265253511, 0), 
	ZonePoint(54.0732303187324, 13.4702264693531, 0), 
	ZonePoint(54.073077023324, 13.4694426861734, 0), 
	ZonePoint(54.0730818138141, 13.4690752878079, 0), 
	ZonePoint(54.073273432964, 13.4684221351582, 0), 
	ZonePoint(54.0734315180969, 13.4680057503439, 0), 
	ZonePoint(54.0735848121963, 13.4674832282241, 0), 
	ZonePoint(54.0737524769694, 13.4669851993288, 0), 
	ZonePoint(54.0739009794887, 13.4666831162282, 0), 
	ZonePoint(54.0738195426891, 13.4659891415379, 0), 
	ZonePoint(54.0738578659088, 13.4657197160698, 0), 
	ZonePoint(54.0738818179032, 13.4653114956637, 0), 
	ZonePoint(54.0739728353558, 13.4649196040739, 0), 
	ZonePoint(54.0739872065142, 13.4645766989328, 0), 
	ZonePoint(54.0742602575801, 13.4642664514241, 0), 
	ZonePoint(54.0743273224795, 13.4639643683236, 0), 
	ZonePoint(54.0744997745804, 13.4635479835094, 0), 
	ZonePoint(54.0746099519364, 13.4633357088982, 0), 
	ZonePoint(54.0746099519364, 13.4630989410627, 0), 
	ZonePoint(54.0745237262044, 13.4628213511865, 0), 
	ZonePoint(54.0744662422835, 13.4626090765754, 0), 
	ZonePoint(54.0743895969319, 13.4622171849855, 0)
}
_hnGa.OriginalPoint = ZonePoint(54.0720751985412, 13.4685153374612, 0)
_hnGa.DistanceRangeUOM = "Feet"
_hnGa.ProximityRangeUOM = "Meters"
_hnGa.OutOfRangeName = ""
_hnGa.InRangeName = ""
_kG9gL = Wherigo.Zone(_iwV)
_kG9gL.Id = "e4f3d058-d28b-4c2d-953e-c1505cac51c9"
_kG9gL.Name = _IGB("\064\037\087\122\018\018")
_kG9gL.Description = _IGB("\124\105\092\088\008\064\087\092\087\052\088\037\008\076\087\052\008\004\105\052\088\074\008\110\008\076\087\052\008\105\092\008\076\088\077\077\087\092\008\044\127\088\092\008\004\088\092\008\037\055\087\088\052\009\109\071\088\071\109\087\091\008\031\077\008\076\105\009\008\003\110\037\037\105\052\088\052\008\110\008\076\052\087\071\110\077\088\052\008\087\092\071\088\052\088\091")
_kG9gL.Visible = false
_kG9gL.Commands = {}
_kG9gL.DistanceRange = Distance(-1, "feet")
_kG9gL.ShowObjects = "OnEnter"
_kG9gL.ProximityRange = Distance(60, "meters")
_kG9gL.AllowSetPositionTo = false
_kG9gL.Active = true
_kG9gL.Points = {
	ZonePoint(54.0727903502715, 13.4782490291566, 0), 
	ZonePoint(54.0746870087155, 13.4786979898188, 0), 
	ZonePoint(54.0766483106712, 13.4765841954511, 0), 
	ZonePoint(54.0773560776412, 13.4736113881677, 0), 
	ZonePoint(54.0770527507451, 13.4702077398411, 0), 
	ZonePoint(54.0758899771098, 13.4689582993161, 0), 
	ZonePoint(54.0753844131962, 13.4673641855429, 0), 
	ZonePoint(54.0759152551439, 13.4657269876136, 0), 
	ZonePoint(54.0762691460044, 13.4643482946205, 0), 
	ZonePoint(54.0764460903033, 13.4621510026628, 0), 
	ZonePoint(54.0765472009927, 13.4609446462938, 0), 
	ZonePoint(54.0768758090321, 13.4600829631732, 0), 
	ZonePoint(54.0780385550533, 13.4589196909603, 0), 
	ZonePoint(54.0793529243795, 13.457282493031, 0), 
	ZonePoint(54.0813244003314, 13.4565500623784, 0), 
	ZonePoint(54.0822848290512, 13.4546112753569, 0), 
	ZonePoint(54.0822090065392, 13.4523708992432, 0), 
	ZonePoint(54.0813244003314, 13.4512937953423, 0), 
	ZonePoint(54.0795804071531, 13.4509922062501, 0), 
	ZonePoint(54.0780891084893, 13.4506906171578, 0), 
	ZonePoint(54.0778300492923, 13.4507820240919, 0), 
	ZonePoint(54.0775840700747, 13.4523809272264, 0), 
	ZonePoint(54.0774298111694, 13.4533189503242, 0), 
	ZonePoint(54.0773297510323, 13.4537666431663, 0), 
	ZonePoint(54.0773151589089, 13.454065105061, 0), 
	ZonePoint(54.0772526211788, 13.4544737136075, 0), 
	ZonePoint(54.0770108077359, 13.4550599780436, 0), 
	ZonePoint(54.0768586313126, 13.4552269745799, 0), 
	ZonePoint(54.0768190236589, 13.4554508210011, 0), 
	ZonePoint(54.0768190236589, 13.4558274514873, 0), 
	ZonePoint(54.0767043697114, 13.4564066096878, 0), 
	ZonePoint(54.0765250919951, 13.4568507494122, 0), 
	ZonePoint(54.076322882479, 13.4570817020689, 0), 
	ZonePoint(54.0761561110029, 13.4571882956027, 0), 
	ZonePoint(54.0759226298107, 13.4571349988358, 0), 
	ZonePoint(54.0757558567266, 13.4567761339385, 0), 
	ZonePoint(54.0758398379595, 13.4562602231106, 0), 
	ZonePoint(54.0760409858997, 13.4558112672144, 0), 
	ZonePoint(54.0760888781228, 13.4554602653319, 0), 
	ZonePoint(54.0760888781228, 13.4547011217256, 0), 
	ZonePoint(54.0755524820685, 13.4547990757393, 0), 
	ZonePoint(54.0752124416945, 13.455941872566, 0), 
	ZonePoint(54.0732391946883, 13.457174460572, 0), 
	ZonePoint(54.0729470312135, 13.4569295755376, 0), 
	ZonePoint(54.0717927259021, 13.4559173840625, 0), 
	ZonePoint(54.0712179561023, 13.4549296810908, 0), 
	ZonePoint(54.0712754334404, 13.4547419358979, 0), 
	ZonePoint(54.0710790522069, 13.4527338786166, 0), 
	ZonePoint(54.0708686831443, 13.4519151970987, 0), 
	ZonePoint(54.069073813773, 13.4501919532456, 0), 
	ZonePoint(54.0679786839351, 13.4504443058521, 0), 
	ZonePoint(54.0674435651667, 13.4517757075321, 0), 
	ZonePoint(54.0671657554735, 13.4525556988268, 0), 
	ZonePoint(54.0665384977593, 13.4536058184042, 0), 
	ZonePoint(54.0663074004392, 13.4548622115388, 0), 
	ZonePoint(54.0656030959121, 13.4582751003523, 0), 
	ZonePoint(54.0647337035389, 13.4593814763962, 0), 
	ZonePoint(54.064172440567, 13.4594002285326, 0), 
	ZonePoint(54.063958159847, 13.4596316530038, 0), 
	ZonePoint(54.0634838966287, 13.4598520445313, 0), 
	ZonePoint(54.063301854763, 13.4596316530038, 0), 
	ZonePoint(54.0631533463343, 13.459394936178, 0), 
	ZonePoint(54.0628802810633, 13.4595010506172, 0), 
	ZonePoint(54.0622287496556, 13.4597459300922, 0), 
	ZonePoint(54.0619748412659, 13.4599989722163, 0), 
	ZonePoint(54.0618646541232, 13.460423429973, 0), 
	ZonePoint(54.0619796320046, 13.4607172853429, 0), 
	ZonePoint(54.0613347454559, 13.4610125804121, 0), 
	ZonePoint(54.0610761646739, 13.4618475352746, 0), 
	ZonePoint(54.0610386286201, 13.4625510291588, 0), 
	ZonePoint(54.0615849833896, 13.4614780233355, 0), 
	ZonePoint(54.0616225189496, 13.4612541843723, 0), 
	ZonePoint(54.061701760576, 13.4612044423806, 0), 
	ZonePoint(54.0623294323279, 13.4609237554268, 0), 
	ZonePoint(54.0625045948448, 13.460856248438, 0), 
	ZonePoint(54.062815297968, 13.4607603174538, 0), 
	ZonePoint(54.0630363336743, 13.4607425524567, 0), 
	ZonePoint(54.0634763163428, 13.46041922951, 0), 
	ZonePoint(54.0637599045972, 13.4603979115136, 0), 
	ZonePoint(54.0640309797948, 13.4602913215313, 0), 
	ZonePoint(54.0645585287609, 13.4601243305588, 0), 
	ZonePoint(54.0650110061321, 13.4601492015548, 0), 
	ZonePoint(54.0657262022445, 13.4601882845484, 0), 
	ZonePoint(54.066168241496, 13.4608598014378, 0), 
	ZonePoint(54.0664184503076, 13.4613074793641, 0), 
	ZonePoint(54.0667645700118, 13.4621601992237, 0), 
	ZonePoint(54.0667186988915, 13.4630697670739, 0), 
	ZonePoint(54.0667103586824, 13.4638478739458, 0), 
	ZonePoint(54.0668104410814, 13.4648178427861, 0), 
	ZonePoint(54.0669751595045, 13.4656634566468, 0), 
	ZonePoint(54.0673316996763, 13.466366950531, 0), 
	ZonePoint(54.0676319416571, 13.4667186974731, 0), 
	ZonePoint(54.0678341867677, 13.4671024214098, 0), 
	ZonePoint(54.0679863912013, 13.4677064313104, 0), 
	ZonePoint(54.0679426064214, 13.4681683212344, 0), 
	ZonePoint(54.0679759662579, 13.4686088931618, 0), 
	ZonePoint(54.0680385158791, 13.4689641931033, 0), 
	ZonePoint(54.0679426064214, 13.4699590329395, 0), 
	ZonePoint(54.0678633767023, 13.4704671118558, 0), 
	ZonePoint(54.0678487817376, 13.4711599467417, 0), 
	ZonePoint(54.0676507067088, 13.471650260661, 0), 
	ZonePoint(54.0675339462492, 13.4720624085929, 0), 
	ZonePoint(54.0674067603749, 13.4725029805204, 0), 
	ZonePoint(54.067196173071, 13.4732100274039, 0), 
	ZonePoint(54.0670064350806, 13.4735546683471, 0), 
	ZonePoint(54.0668187812703, 13.4740663002629, 0), 
	ZonePoint(54.0669376287819, 13.4742297382359, 0), 
	ZonePoint(54.0670898365018, 13.4743256692202, 0), 
	ZonePoint(54.0678216767894, 13.472996847439, 0), 
	ZonePoint(54.0681406800577, 13.4722791415572, 0), 
	ZonePoint(54.0683637723905, 13.4716928966538, 0), 
	ZonePoint(54.0687140457843, 13.4712452187275, 0), 
	ZonePoint(54.0688766717127, 13.4714051037012, 0), 
	ZonePoint(54.0689100307988, 13.4718883116217, 0), 
	ZonePoint(54.0688912663162, 13.472559828511, 0), 
	ZonePoint(54.0687745093449, 13.4731638384116, 0), 
	ZonePoint(54.068499295185, 13.4736683643285, 0), 
	ZonePoint(54.0681365100962, 13.4741657842466, 0), 
	ZonePoint(54.0678195917926, 13.4745068721904, 0), 
	ZonePoint(54.0675527113452, 13.4748692781308, 0), 
	ZonePoint(54.0673588049442, 13.4752743200641, 0), 
	ZonePoint(54.067294169276, 13.4758356939717, 0), 
	ZonePoint(54.0674609707952, 13.4762798188985, 0), 
	ZonePoint(54.06743595061, 13.4766280128411, 0), 
	ZonePoint(54.0672045131825, 13.4769975247803, 0), 
	ZonePoint(54.0667395494069, 13.4779213046282, 0), 
	ZonePoint(54.0666540622268, 13.4781238255948, 0), 
	ZonePoint(54.0664705769535, 13.478390300551, 0), 
	ZonePoint(54.0664761864751, 13.4793525391861, 0), 
	ZonePoint(54.067031848248, 13.4802994064894, 0), 
	ZonePoint(54.0676449836444, 13.480283081191, 0), 
	ZonePoint(54.068425760146, 13.4755569073238, 0), 
	ZonePoint(54.0693071098454, 13.4734917570847, 0), 
	ZonePoint(54.0693236444791, 13.4729624819111, 0), 
	ZonePoint(54.069412580824, 13.4719928058324, 0), 
	ZonePoint(54.0694833667582, 13.4714221352215, 0), 
	ZonePoint(54.0695550600814, 13.4709210585874, 0), 
	ZonePoint(54.069545984984, 13.470121501119, 0), 
	ZonePoint(54.0695686727237, 13.469793636161, 0), 
	ZonePoint(54.069756526732, 13.4696838323308, 0), 
	ZonePoint(54.0699979224225, 13.4695075275892, 0), 
	ZonePoint(54.070283783925, 13.4694332940138, 0), 
	ZonePoint(54.0706821717523, 13.4694302009483, 0), 
	ZonePoint(54.0707266384936, 13.4695044345237, 0), 
	ZonePoint(54.070933544337, 13.4688533442061, 0), 
	ZonePoint(54.0708981526211, 13.4686089920204, 0), 
	ZonePoint(54.0708890778173, 13.468231638012, 0), 
	ZonePoint(54.0709226545814, 13.4678218068145, 0), 
	ZonePoint(54.0710878155667, 13.4674815695939, 0), 
	ZonePoint(54.071275662702, 13.4670361681415, 0), 
	ZonePoint(54.0713727620957, 13.4665660221639, 0), 
	ZonePoint(54.0710306445308, 13.4658190468114, 0), 
	ZonePoint(54.071135004299, 13.465356633498, 0), 
	ZonePoint(54.071197620034, 13.4650318616056, 0), 
	ZonePoint(54.0713074242109, 13.4645586225623, 0), 
	ZonePoint(54.0713074242109, 13.4641518844305, 0), 
	ZonePoint(54.0712402712777, 13.4637343205688, 0), 
	ZonePoint(54.0713382782249, 13.4634729565221, 0), 
	ZonePoint(54.0714172280974, 13.4630476599963, 0), 
	ZonePoint(54.0716168707834, 13.4627677375557, 0), 
	ZonePoint(54.0718528109019, 13.4626764921193, 0), 
	ZonePoint(54.0721667906726, 13.4626007120111, 0), 
	ZonePoint(54.0722294048515, 13.4625682348219, 0), 
	ZonePoint(54.0724118021389, 13.4623780112849, 0), 
	ZonePoint(54.0725633455444, 13.4622805797172, 0), 
	ZonePoint(54.0729163397153, 13.4619140514386, 0), 
	ZonePoint(54.0730188798759, 13.4616294893996, 0), 
	ZonePoint(54.0730461028849, 13.4614408123955, 0), 
	ZonePoint(54.0730515474845, 13.4612010998082, 0), 
	ZonePoint(54.0729707858498, 13.4610603653216, 0), 
	ZonePoint(54.0726794981993, 13.4608237458, 0), 
	ZonePoint(54.072492564861, 13.4605623817533, 0), 
	ZonePoint(54.0722393868133, 13.4601742020153, 0), 
	ZonePoint(54.0719208703022, 13.4596375551265, 0), 
	ZonePoint(54.0716250379636, 13.458960173751, 0), 
	ZonePoint(54.0716232230348, 13.4588086135345, 0), 
	ZonePoint(54.0717493603995, 13.4586214830632, 0), 
	ZonePoint(54.0719217777601, 13.4583925962057, 0), 
	ZonePoint(54.0721495490703, 13.4583585724836, 0), 
	ZonePoint(54.0723709669949, 13.4584065150011, 0), 
	ZonePoint(54.0725061765402, 13.4586833443761, 0), 
	ZonePoint(54.0727466488046, 13.4592942248404, 0), 
	ZonePoint(54.0730216021775, 13.4598447905247, 0), 
	ZonePoint(54.0733346656821, 13.4601974000079, 0), 
	ZonePoint(54.0737965434694, 13.4606768251825, 0), 
	ZonePoint(54.0740851010507, 13.4604866016455, 0), 
	ZonePoint(54.0743119530869, 13.4604541244563, 0), 
	ZonePoint(54.0744740173734, 13.4612752813054, 0), 
	ZonePoint(54.0745157106055, 13.4616447932446, 0), 
	ZonePoint(54.0744010541164, 13.4622203791498, 0), 
	ZonePoint(54.0745245332291, 13.4627950667975, 0), 
	ZonePoint(54.0746183525337, 13.4630899962589, 0), 
	ZonePoint(54.0746225222757, 13.4633458386832, 0), 
	ZonePoint(54.0745120239724, 13.4635448272354, 0), 
	ZonePoint(54.0744244590704, 13.4637722427237, 0), 
	ZonePoint(54.0743348090984, 13.4639570178079, 0), 
	ZonePoint(54.0742764322683, 13.4642626073702, 0), 
	ZonePoint(54.0739928864977, 13.4645930705017, 0), 
	ZonePoint(54.0739776039722, 13.4649119076155, 0), 
	ZonePoint(54.0738868531876, 13.4653125010569, 0), 
	ZonePoint(54.0738623504418, 13.4657161878838, 0), 
	ZonePoint(54.0738224200102, 13.4659806723566, 0), 
	ZonePoint(54.0739050033604, 13.4666813242057, 0), 
	ZonePoint(54.0737552641977, 13.4669844759991, 0), 
	ZonePoint(54.0735873741911, 13.4674840577811, 0), 
	ZonePoint(54.0734385414013, 13.4680052932626, 0), 
	ZonePoint(54.073274280203, 13.4684244470178, 0), 
	ZonePoint(54.0730855151504, 13.4690771513893, 0), 
	ZonePoint(54.0730800699919, 13.4694468109742, 0), 
	ZonePoint(54.0732361642519, 13.4702340776214, 0), 
	ZonePoint(54.073332361585, 13.470623844213, 0), 
	ZonePoint(54.073330546543, 13.4712069474075, 0), 
	ZonePoint(54.0733251014167, 13.471570420221, 0), 
	ZonePoint(54.0733005983393, 13.471957093427, 0), 
	ZonePoint(54.0733051359473, 13.4724288347381, 0), 
	ZonePoint(54.073279725336, 13.4728959359708, 0), 
	ZonePoint(54.0732352567289, 13.4732191947709, 0), 
	ZonePoint(54.0731281688672, 13.4742137182565, 0), 
	ZonePoint(54.0731100183548, 13.4745833778413, 0), 
	ZonePoint(54.0730673646194, 13.474901996563, 0), 
	ZonePoint(54.0729557386789, 13.4758717729634, 0), 
	ZonePoint(54.0729738892588, 13.4762135920775, 0), 
	ZonePoint(54.0730628269854, 13.4764239423015, 0), 
	ZonePoint(54.0730773474124, 13.4767827750365, 0), 
	ZonePoint(54.0730274334231, 13.4773473179171, 0), 
	ZonePoint(54.0729475709154, 13.477707697345, 0), 
	ZonePoint(54.0728867664031, 13.4779613549681, 0)
}
_kG9gL.OriginalPoint = ZonePoint(54.070934213159, 13.4646778751028, 0)
_kG9gL.DistanceRangeUOM = "Feet"
_kG9gL.ProximityRangeUOM = "Meters"
_kG9gL.OutOfRangeName = ""
_kG9gL.InRangeName = ""

-- Characters --
_DlXh = Wherigo.ZCharacter{
	Cartridge = _iwV, 
	Container = _knK
}
_DlXh.Id = "749814ba-9e41-4a0c-a4b3-4b42a1278ca5"
_DlXh.Name = _IGB("\031\127\037\087")
_DlXh.Description = _IGB("\100\071\109\008\109\087\037\004\087\008\062\110\052\008\003\110\009\008\062\087\003\008\031\088\052\009\109\071\088\071\109\087\091\008\054\088\077\008\097\110\037\037\077\009\008\062\127\008\097\110\077\077\087\092\067")
_DlXh.Visible = true
_DlXh.Media = _qSAL
_DlXh.Icon = _KN2D
_DlXh.Commands = {
	_uq76 = Wherigo.ZCommand{
		Text = _IGB("\054\088\077\008\110\077\009\008\062\087\052\008\026\105\062\087\092\067"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _IGB("\126\105\009\109\110\092\064\008\088\035\088\110\037\088\023\037\087")
	}, 
	_v6v = Wherigo.ZCommand{
		Text = _IGB("\026\105\062\087\092\109\105\052\110\007\105\092\009\087"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _IGB("\126\105\009\109\110\092\064\008\088\035\088\110\037\088\023\037\087")
	}, 
	_3HUa = Wherigo.ZCommand{
		Text = _IGB("\054\087\037\071\109\087\092\008\026\105\062\087\092\009\122\076\008\004\110\092\062\087\008\110\071\109\008\109\110\087\052\067"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _IGB("\126\105\009\109\110\092\064\008\088\035\088\110\037\088\023\037\087")
	}, 
	_p8yx = Wherigo.ZCommand{
		Text = _IGB("\048\087\052\009\087\110\037\127\092\064\008\062\087\052\008\026\195\182\062\087\092"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _IGB("\126\105\009\109\110\092\064\008\088\035\088\110\037\088\023\037\087")
	}, 
	_n0tf = Wherigo.ZCommand{
		Text = _IGB("\026\105\062\087\092\009\122\076\087\092"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _IGB("\126\105\009\109\110\092\064\008\088\035\088\110\037\088\023\037\087")
	}
}
_DlXh.Commands._uq76.Custom = true
_DlXh.Commands._uq76.Id = "070812b9-44ab-4265-8a36-6c0c865d989c"
_DlXh.Commands._uq76.WorksWithAll = true
_DlXh.Commands._v6v.Custom = true
_DlXh.Commands._v6v.Id = "206b98bc-98fa-4201-9f30-e11a9c6e307b"
_DlXh.Commands._v6v.WorksWithAll = true
_DlXh.Commands._3HUa.Custom = true
_DlXh.Commands._3HUa.Id = "3ba5fffc-243f-4936-8526-643909cd8feb"
_DlXh.Commands._3HUa.WorksWithAll = true
_DlXh.Commands._p8yx.Custom = true
_DlXh.Commands._p8yx.Id = "a0d2594c-a2b4-434e-ae1d-d2bc5c6b040f"
_DlXh.Commands._p8yx.WorksWithAll = true
_DlXh.Commands._n0tf.Custom = true
_DlXh.Commands._n0tf.Id = "d79aa5de-eb1c-4147-bde7-a64e5068fd23"
_DlXh.Commands._n0tf.WorksWithAll = true
_DlXh.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_DlXh.Gender = "It"
_DlXh.Type = "NPC"
_cpM = Wherigo.ZCharacter{
	Cartridge = _iwV, 
	Container = _knK
}
_cpM.Id = "0f56257c-a3fd-40b2-a38f-52f2e9c0d616"
_cpM.Name = _IGB("\103\127\071\109\077")
_cpM.Description = ""
_cpM.Visible = false
_cpM.Media = _X4e
_cpM.Icon = _rER
_cpM.Commands = {}
_cpM.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_cpM.Gender = "Male"
_cpM.Type = "NPC"
_o6OuP = Wherigo.ZCharacter{
	Cartridge = _iwV, 
	Container = _knK
}
_o6OuP.Id = "62f046a4-9375-46e8-9f43-9331b59eb60b"
_o6OuP.Name = _IGB("\095\087\109")
_o6OuP.Description = ""
_o6OuP.Visible = false
_o6OuP.Media = _xegod
_o6OuP.Icon = _zPrjV
_o6OuP.Commands = {}
_o6OuP.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_o6OuP.Gender = "Male"
_o6OuP.Type = "NPC"
_Uyo3j = Wherigo.ZCharacter{
	Cartridge = _iwV, 
	Container = _knK
}
_Uyo3j.Id = "d029e5f7-7e2c-48b0-a5e6-1e481afacf0f"
_Uyo3j.Name = _IGB("\026\037\088\127\003\087\110\077\087")
_Uyo3j.Description = ""
_Uyo3j.Visible = false
_Uyo3j.Media = _FdMeN
_Uyo3j.Icon = _O6XAb
_Uyo3j.Commands = {}
_Uyo3j.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Uyo3j.Gender = "Male"
_Uyo3j.Type = "NPC"
_tlF2O = Wherigo.ZCharacter{
	Cartridge = _iwV, 
	Container = _knK
}
_tlF2O.Id = "2236c929-7e88-4e39-bba1-f240fbe870d2"
_tlF2O.Name = _IGB("\107\076\087\071\109\009")
_tlF2O.Description = ""
_tlF2O.Visible = false
_tlF2O.Media = _CK72n
_tlF2O.Icon = _3dhz
_tlF2O.Commands = {}
_tlF2O.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_tlF2O.Gender = "Male"
_tlF2O.Type = "NPC"
_9IvKe = Wherigo.ZCharacter{
	Cartridge = _iwV, 
	Container = _knK
}
_9IvKe.Id = "352667c5-cd56-4572-b731-4193c6030cb2"
_9IvKe.Name = _IGB("\031\110\071\109\109\195\182\052\092\071\109\087\092")
_9IvKe.Description = ""
_9IvKe.Visible = false
_9IvKe.Media = _69J
_9IvKe.Icon = _zm7
_9IvKe.Commands = {}
_9IvKe.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_9IvKe.Gender = "Male"
_9IvKe.Type = "NPC"
_j6xbl = Wherigo.ZCharacter{
	Cartridge = _iwV, 
	Container = _knK
}
_j6xbl.Id = "89689786-36b7-49ea-bd6f-3209ed732d5b"
_j6xbl.Name = _IGB("\001\003\077\087\037")
_j6xbl.Description = ""
_j6xbl.Visible = false
_j6xbl.Media = _Y6bf
_j6xbl.Icon = _BOI
_j6xbl.Commands = {}
_j6xbl.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_j6xbl.Gender = "Male"
_j6xbl.Type = "NPC"
_4eUcg = Wherigo.ZCharacter{
	Cartridge = _iwV, 
	Container = _knK
}
_4eUcg.Id = "39559dbe-f931-40b2-8d71-e24d6b31ab78"
_4eUcg.Name = _IGB("\103\052\105\077\071\109")
_4eUcg.Description = ""
_4eUcg.Visible = false
_4eUcg.Media = _esZP6
_4eUcg.Icon = _vMM
_4eUcg.Commands = {}
_4eUcg.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_4eUcg.Gender = "Male"
_4eUcg.Type = "NPC"
_onek = Wherigo.ZCharacter{
	Cartridge = _iwV, 
	Container = _knK
}
_onek.Id = "4ddcb696-4b11-41bb-b7ff-8e1134f3fe2d"
_onek.Name = _IGB("\054\088\037\062\003\195\164\127\077\071\109\087\092")
_onek.Description = ""
_onek.Visible = false
_onek.Media = _c3Eu
_onek.Icon = _5Fr2
_onek.Commands = {}
_onek.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_onek.Gender = "Male"
_onek.Type = "NPC"

-- Items --
_2SGn2 = Wherigo.ZItem{
	Cartridge = _iwV, 
	Container = Player
}
_2SGn2.Id = "76b8d399-a007-41fc-ab1d-21c6a9a9e4f3"
_2SGn2.Name = _IGB("\083\110\009\087\052\088\009\127\052")
_2SGn2.Description = _IGB("\025\091\008\093\054\001\107\126\100\069\054\107\093\100\074\008\063\008\090\094\018\018\025\028\008\065\110\087\008\026\195\182\062\087\092\008\110\003\008\126\088\009\127\052\077\071\109\127\009\007\064\087\023\110\087\009\008\031\037\062\087\092\088\008\090\048\105\052\076\105\003\003\087\052\092\028\074\008\118\052\087\110\004\077\097\088\037\062\087\052\008\118\087\105\064\052\088\004\110\077\071\109\087\008\001\052\023\087\110\009\087\092\074\008\094\010\074\008\025\040\040\113\025\057\040\027\026\095\046\027\026\095\046\094\091\008\026\105\062\087\092\037\087\109\052\076\004\088\062\008\031\037\062\087\092\088\008\090\109\009\009\076\077\066\111\111\064\087\105\091\127\092\110\113\064\052\087\110\004\077\097\088\037\062\091\062\087\028\008\029\018\057\091\025\018\091\094\018\025\057\020\027\026\095\046\027\026\095\046\010\091\008\100\092\004\105\009\088\004\087\037\027\026\095\046\027\026\095\046\078\091\008\026\105\062\087\092\009\122\076\087\092\008\090\109\009\009\076\077\066\111\111\097\097\097\091\023\105\062\087\092\009\122\076\087\092\091\062\087\111\028\008\029\018\053\091\025\018\091\094\018\025\057\020\027\026\095\046\027\026\095\046\040\091\008\026\105\062\087\092\097\087\037\009\087\092\008\090\109\009\009\076\077\066\111\111\097\097\097\091\023\105\062\087\092\097\087\037\009\087\092\091\062\087\111\028\008\029\018\057\091\025\018\091\094\018\025\057\020\027\026\095\046\027\026\095\046\120\091\008\054\110\058\110\076\087\062\110\088\008\090\109\009\009\076\077\066\111\111\062\087\091\097\110\058\110\076\087\062\110\088\091\105\052\064\111\097\110\058\110\111\026\105\062\087\092\043\090\026\105\062\087\092\058\127\092\062\087\028\028\008\090\109\009\009\076\077\066\111\111\062\087\091\097\110\058\110\076\087\062\110\088\091\105\052\064\111\097\110\058\110\111\026\105\062\087\092\109\105\052\110\007\105\092\009\028\008\029\018\057\091\025\018\091\094\018\025\057\020\027\026\095\046")
_2SGn2.Visible = true
_2SGn2.Icon = _L1m
_2SGn2.Commands = {}
_2SGn2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_2SGn2.Locked = false
_2SGn2.Opened = false
_YYoMq = Wherigo.ZItem(_iwV)
_YYoMq.Id = "75e998a8-e413-46ee-ace0-72315b3c3f63"
_YYoMq.Name = _IGB("\026\105\062\087\092\076\052\105\004\110\037")
_YYoMq.Description = _IGB("\034\110\087\052\008\064\110\023\009\008\087\077\008\087\110\092\087\008\103\052\088\064\087\008\007\127\008\062\110\087\077\087\003\008\026\105\062\087\092\076\052\105\004\110\037")
_YYoMq.Visible = true
_YYoMq.Media = _Hbom
_YYoMq.Icon = _kpuU
_YYoMq.Commands = {
	_dGO = Wherigo.ZCommand{
		Text = _IGB("\103\052\088\064\087\008\025"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _IGB("\126\105\009\109\110\092\064\008\088\035\088\110\037\088\023\037\087")
	}, 
	_ZkVDT = Wherigo.ZCommand{
		Text = _IGB("\103\052\088\064\087\008\094"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _IGB("\126\105\009\109\110\092\064\008\088\035\088\110\037\088\023\037\087")
	}, 
	_I0f = Wherigo.ZCommand{
		Text = _IGB("\103\052\088\064\087\008\010"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _IGB("\126\105\009\109\110\092\064\008\088\035\088\110\037\088\023\037\087")
	}, 
	_qe7 = Wherigo.ZCommand{
		Text = _IGB("\103\052\088\064\087\008\078"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _IGB("\126\105\009\109\110\092\064\008\088\035\088\110\037\088\023\037\087")
	}, 
	_BRXS = Wherigo.ZCommand{
		Text = _IGB("\103\052\088\064\087\008\040"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _IGB("\126\105\009\109\110\092\064\008\088\035\088\110\037\088\023\037\087")
	}
}
_YYoMq.Commands._dGO.Custom = true
_YYoMq.Commands._dGO.Id = "1da6a27f-98d4-4f30-bbc0-c9051ab5e501"
_YYoMq.Commands._dGO.WorksWithAll = true
_YYoMq.Commands._ZkVDT.Custom = true
_YYoMq.Commands._ZkVDT.Id = "22b74b08-452c-48af-91dc-f9d5d9feac31"
_YYoMq.Commands._ZkVDT.WorksWithAll = true
_YYoMq.Commands._I0f.Custom = true
_YYoMq.Commands._I0f.Id = "8706fe7d-c59e-4c6a-88bd-2ce72062623a"
_YYoMq.Commands._I0f.WorksWithAll = true
_YYoMq.Commands._qe7.Custom = true
_YYoMq.Commands._qe7.Id = "0bc3678e-bd3b-4790-b5cc-6a336bb537e0"
_YYoMq.Commands._qe7.WorksWithAll = true
_YYoMq.Commands._BRXS.Custom = true
_YYoMq.Commands._BRXS.Id = "4a41a4aa-ff84-4b3f-a670-3335502980e4"
_YYoMq.Commands._BRXS.WorksWithAll = true
_YYoMq.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_YYoMq.Locked = false
_YYoMq.Opened = false
_4JMt = Wherigo.ZItem{
	Cartridge = _iwV, 
	Container = Player
}
_4JMt.Id = "07fa833c-b9a3-4fb2-89a6-d5586bd5638d"
_4JMt.Name = _IGB("\001\092\009\097\105\052\009\087\092")
_4JMt.Description = _IGB("\065\127\008\109\088\077\009\008\004\105\037\064\087\092\062\087\077\008\064\087\088\092\009\097\105\052\009\087\009\066\027\026\095\046\103\052\088\064\087\008\025\088\066\027\026\095\046\103\052\088\064\087\008\025\023\066\027\026\095\046\103\052\088\064\087\008\094\066\027\026\095\046\103\052\088\064\087\008\010\066\027\026\095\046\103\052\088\064\087\008\078\066\027\026\095\046\103\052\088\064\087\008\040\088\066\027\026\095\046\103\052\088\064\087\008\040\023\066")
_4JMt.Visible = true
_4JMt.Icon = _VeT
_4JMt.Commands = {}
_4JMt.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_4JMt.Locked = false
_4JMt.Opened = false
_Kn8 = Wherigo.ZItem(_iwV)
_Kn8.Id = "5dad8c58-95c3-4704-b5ef-a66c2540ad9b"
_Kn8.Name = _IGB("\014\105\003\076\037\087\009\110\105\092\008\014\105\062\087")
_Kn8.Description = _IGB("\025\094\010")
_Kn8.Visible = true
_Kn8.Icon = _VeT
_Kn8.Commands = {}
_Kn8.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Kn8.Locked = false
_Kn8.Opened = false

-- Tasks --
_NXQ = Wherigo.ZTask(_iwV)
_NXQ.Id = "15e6b951-89d0-4014-829e-58be00154b59"
_NXQ.Name = _IGB("\103\052\088\064\087\008\025")
_NXQ.Description = _IGB("\118\087\109\008\007\127\008\107\009\088\009\110\105\092\008\025\091")
_NXQ.Visible = true
_NXQ.Active = true
_NXQ.Complete = false
_NXQ.CorrectState = "None"
_DUzc = Wherigo.ZTask(_iwV)
_DUzc.Id = "99490cb4-80c9-4f4f-8129-fff96ecc34c5"
_DUzc.Name = _IGB("\103\052\088\064\087\008\094")
_DUzc.Description = _IGB("\118\087\109\008\007\127\008\107\009\088\009\110\105\092\008\094\091")
_DUzc.Visible = true
_DUzc.Active = true
_DUzc.Complete = false
_DUzc.CorrectState = "None"
_RhO = Wherigo.ZTask(_iwV)
_RhO.Id = "de79a245-0344-48fa-acb9-35c04cb9885a"
_RhO.Name = _IGB("\103\052\088\064\087\008\010")
_RhO.Description = _IGB("\118\087\109\008\007\127\008\107\009\088\009\110\105\092\008\010\091")
_RhO.Visible = true
_RhO.Active = true
_RhO.Complete = false
_RhO.CorrectState = "None"
_IhZ = Wherigo.ZTask(_iwV)
_IhZ.Id = "f3ecf037-fa8f-42d9-84de-c6038bb4110d"
_IhZ.Name = _IGB("\103\052\088\064\087\008\078")
_IhZ.Description = _IGB("\118\087\109\008\007\127\008\107\009\088\009\110\105\092\008\078\091")
_IhZ.Visible = true
_IhZ.Active = true
_IhZ.Complete = false
_IhZ.CorrectState = "None"
_T4Ml = Wherigo.ZTask(_iwV)
_T4Ml.Id = "8bcb1ba3-440f-40ff-b6d2-7937203ae816"
_T4Ml.Name = _IGB("\103\052\088\064\087\008\040")
_T4Ml.Description = _IGB("\118\087\109\008\007\127\008\107\009\088\009\110\105\092\008\040\091")
_T4Ml.Visible = true
_T4Ml.Active = true
_T4Ml.Complete = false
_T4Ml.CorrectState = "None"

-- Cartridge Variables --
_EvbW = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\118\037\087\122\087\091")
_n3V = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\116\077\087\127\062\105\064\037\087\122\008\003\110\009\008\026\052\088\127\092\087\052\062\087\092\091")
_FqDwt = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\026\052\088\127\092\087\052\062\087\092\091")
_UMln = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\126\110\087\062\087\052\003\105\105\052\087\091")
_xgL2 = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\093\105\037\037\127\035\110\077\105\037\091")
_aEEx2 = ""
_u5ds = ""
_FRD = ""
_lKY = ""
_yQmY = ""
_4hRz = ""
_myVlc = ""
_Uxx = ""
_k7K = 30
_bbp = _IGB("\043\058\092\093")
_TcnYs = _IGB("\043\065\037\075\109")
_CcZRc = _IGB("\043\094\107\118\092\094")
_UO7g = _IGB("\043\126\075\036")
_5KtPm = _IGB("\043\079\003\054\026")
_g5XA = _IGB("\043\003\018\097\093")
_iwV.ZVariables = {
	_EvbW = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\118\037\087\122\087\091"), 
	_n3V = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\116\077\087\127\062\105\064\037\087\122\008\003\110\009\008\026\052\088\127\092\087\052\062\087\092\091"), 
	_FqDwt = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\026\052\088\127\092\087\052\062\087\092\091"), 
	_UMln = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\126\110\087\062\087\052\003\105\105\052\087\091"), 
	_xgL2 = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\093\105\037\037\127\035\110\077\105\037\091"), 
	_aEEx2 = "", 
	_u5ds = "", 
	_FRD = "", 
	_lKY = "", 
	_yQmY = "", 
	_4hRz = "", 
	_myVlc = "", 
	_Uxx = "", 
	_k7K = 30, 
	_bbp = _IGB("\043\058\092\093"), 
	_TcnYs = _IGB("\043\065\037\075\109"), 
	_CcZRc = _IGB("\043\094\107\118\092\094"), 
	_UO7g = _IGB("\043\126\075\036"), 
	_5KtPm = _IGB("\043\079\003\054\026"), 
	_g5XA = _IGB("\043\003\018\097\093")
}

-- Timers --
_m0wK = Wherigo.ZTimer(_iwV)
_m0wK.Id = "4da5536f-44cd-4b2e-8249-2b951226ae97"
_m0wK.Name = _IGB("\088\092\110\003\088\037")
_m0wK.Description = _IGB("\001\076\088\052\087\110\086\008\127\092\008\088\092\110\003\088\037\008\071\088\062\088\008\086\074\008\087\037\008\009\087\003\105\077\008\087\077\008\064\087\092\087\052\088\008\071\088\062\088\008\071\105\076\008\087\092\009\052\087\008\010\018\008\077\087\064\105\092\077\008\110\008\040\008\003\110\092\127\009\077\008\090\010\018\113\010\018\018\028")
_m0wK.Visible = true
_m0wK.Duration = 10
_m0wK.Type = "Countdown"
_gVT_ = Wherigo.ZTimer(_iwV)
_gVT_.Id = "3cc2723b-4868-481b-ad44-ed75c2338a23"
_gVT_.Name = _IGB("\088\092\110\003\088\037\065\087\077\088\076\088\052\087\110\086")
_gVT_.Description = _IGB("\083\055\088\092\110\003\088\037\008\087\037\008\076\105\009\077\008\035\087\127\052\087\008\127\092\077\008\010\018\008\077\087\064\105\092\077\091")
_gVT_.Visible = true
_gVT_.Duration = 30
_gVT_.Type = "Countdown"

-- Inputs --
_YmWB = Wherigo.ZInput(_iwV)
_YmWB.Id = "e6c1e77b-53fd-48ef-a9c6-b5541aac63b2"
_YmWB.Name = _IGB("\107\009\088\009\110\105\092\025\088")
_YmWB.Description = ""
_YmWB.Visible = true
_YmWB.InputType = "Text"
_YmWB.Text = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\087\110\092\087\008\062\087\052\008\097\087\092\110\064\087\092\008\026\087\052\087\110\071\109\087\092\008\003\110\009\008\026\052\088\127\092\087\052\062\087\091\008\054\088\052\127\003\008\077\110\092\062\008\026\052\088\127\092\087\052\062\087\092\008\110\003\008\126\107\118\008\031\037\062\087\092\088\008\092\110\071\109\009\008\077\105\008\109\195\164\127\004\110\064\067")
_cv4t = Wherigo.ZInput(_iwV)
_cv4t.Id = "71eac7c4-9b62-405d-aae1-4e7b814c8aba"
_cv4t.Name = _IGB("\107\009\088\009\110\105\092\025\023")
_cv4t.Description = ""
_cv4t.Visible = true
_cv4t.InputType = "Text"
_cv4t.Text = _IGB("\026\087\052\195\188\109\052\087\008\062\110\087\008\035\087\052\077\071\109\110\087\062\087\092\087\092\008\107\071\109\110\071\109\009\087\092\008\062\087\077\008\116\052\105\004\110\037\077\074\008\062\110\087\008\062\127\008\087\052\058\087\092\092\087\092\008\058\088\092\092\077\009\091\008\093\088\092\092\077\009\008\062\127\008\087\110\092\008\127\092\009\087\052\077\071\109\110\087\062\008\007\097\110\077\071\109\087\092\008\062\087\092\008\107\071\109\110\071\109\009\087\092\008\003\087\052\058\087\092\067\008\054\110\052\062\008\087\077\008\064\052\195\182\023\087\052\008\105\062\087\052\008\004\087\110\092\087\052\008\110\092\008\062\087\092\008\127\092\009\087\052\087\092\008\107\071\109\110\071\109\009\087\092\067")
__DAh = Wherigo.ZInput(_iwV)
__DAh.Id = "6d65a61e-9038-41d8-90b6-76bd1d5dc9e4"
__DAh.Name = _IGB("\107\009\088\009\110\105\092\094")
__DAh.Description = ""
__DAh.Visible = true
__DAh.InputType = "Text"
__DAh.Text = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\088\127\071\109\008\087\110\092\008\026\052\088\127\092\087\052\062\076\052\105\004\110\037\008\088\023\087\052\074\008\062\088\077\008\092\110\071\109\009\008\195\188\023\087\052\008\087\110\092\008\077\088\092\062\110\064\087\052\008\107\127\023\077\009\052\088\009\008\037\110\087\064\009\008\110\003\008\118\087\064\087\092\077\088\009\007\008\007\127\003\008\116\052\105\004\110\037\008\035\105\092\008\107\009\088\009\110\105\092\008\025\091\027\026\095\046\093\088\092\092\077\009\008\062\127\008\109\110\087\052\008\087\110\092\008\096\092\009\087\052\077\071\109\110\087\062\008\007\097\110\077\071\109\087\092\008\062\110\087\008\105\023\087\052\087\008\127\092\062\008\127\092\009\087\052\087\008\107\071\109\110\071\109\009\008\003\087\052\058\087\092\067")
_7qGL = Wherigo.ZInput(_iwV)
_7qGL.Id = "b4a2bd45-c46a-4846-831b-410b2069a288"
_7qGL.Name = _IGB("\107\009\088\009\110\105\092\010")
_7qGL.Description = ""
_7qGL.Visible = true
_7qGL.InputType = "Text"
_7qGL.Text = _IGB("\034\110\087\052\008\004\110\092\062\087\077\009\008\062\127\008\087\110\092\008\026\087\110\077\076\110\087\037\008\035\105\092\008\118\037\087\122\091\008\001\092\008\062\087\092\008\054\195\164\092\062\087\092\008\062\087\077\008\116\052\105\004\110\037\077\008\058\088\092\092\008\062\088\077\008\035\105\052\109\087\052\008\110\003\008\118\052\127\092\062\097\088\077\077\087\052\008\064\087\037\195\182\077\009\087\008\031\110\077\087\092\008\105\086\110\062\110\087\052\087\092\008\127\092\062\008\103\037\087\071\058\087\092\008\087\092\009\077\009\087\109\087\092\091\027\026\095\046\093\088\092\092\077\009\008\062\127\008\062\110\087\008\103\037\087\071\058\087\092\008\087\052\058\087\092\092\087\092\067\008\100\092\008\097\087\037\071\109\087\003\008\034\105\052\110\007\105\092\009\008\077\105\037\037\009\087\077\009\008\062\127\008\062\110\087\008\077\087\109\087\092\067\008\054\087\037\071\109\087\008\103\088\052\023\087\008\109\088\023\087\092\008\062\110\087\067")
_LGI_ = Wherigo.ZInput(_iwV)
_LGI_.Id = "1ef07df1-0ded-466a-8676-5ee7f834f437"
_LGI_.Name = _IGB("\107\009\088\009\110\105\092\078")
_LGI_.Description = ""
_LGI_.Visible = true
_LGI_.InputType = "Text"
_LGI_.Text = _IGB("\048\105\092\008\109\110\087\052\008\088\127\077\008\109\088\077\009\008\062\127\008\087\110\092\008\077\071\109\195\182\092\087\092\008\026\037\110\071\058\008\062\087\003\008\095\087\109\023\052\127\071\109\091\008\100\092\062\087\003\008\004\037\110\087\195\159\087\092\008\062\087\052\008\026\110\087\052\023\088\071\109\074\008\062\087\052\008\058\127\052\007\008\109\110\092\009\087\052\008\062\087\003\008\095\087\109\023\052\127\071\109\008\009\052\105\071\058\087\092\064\087\037\087\064\009\008\110\077\009\074\008\127\092\062\008\062\087\052\008\034\105\109\087\092\008\118\052\088\023\087\092\074\008\062\087\052\008\023\087\052\087\110\009\077\008\088\092\008\062\087\052\008\118\052\105\195\159\087\092\008\054\110\087\077\087\111\031\110\071\109\087\092\023\052\110\092\058\008\062\088\077\008\126\107\118\008\095\110\071\109\009\127\092\064\008\118\052\087\110\004\077\097\088\037\062\087\052\008\026\105\062\062\087\092\008\035\087\052\037\195\164\077\077\009\091\008\065\127\008\058\088\092\092\077\009\008\003\110\009\008\034\110\037\004\087\008\062\087\052\008\048\087\064\087\009\088\009\110\105\092\008\087\052\058\087\092\092\087\092\008\097\105\008\062\110\087\008\026\195\164\071\109\087\008\004\037\110\087\195\159\087\092\091\027\026\095\046\001\127\077\008\097\087\037\071\109\087\003\008\026\105\062\087\092\008\062\087\092\058\077\009\008\062\127\074\008\062\088\077\077\008\062\087\052\008\095\087\109\023\052\127\071\109\008\087\092\009\077\009\088\092\062\087\092\008\110\077\009\067\008\054\088\052\127\003\067")
_76M2H = Wherigo.ZInput(_iwV)
_76M2H.Id = "23a491e3-b1d8-47cc-899b-bc7a73c347ed"
_76M2H.Name = _IGB("\107\009\088\009\110\105\092\040\088")
_76M2H.Description = ""
_76M2H.Visible = true
_76M2H.InputType = "Text"
_76M2H.Text = _IGB("\034\110\087\052\008\023\087\004\110\092\062\087\077\009\008\062\127\008\062\110\071\109\008\064\088\092\007\008\092\088\109\074\008\077\195\188\062\037\110\071\109\008\062\087\077\008\031\023\087\052\009\077\023\087\052\064\077\074\008\062\087\052\008\109\195\182\071\109\077\009\087\008\116\127\092\058\009\008\062\087\077\008\126\107\118\008\031\037\062\087\092\088\074\008\127\092\062\008\088\003\008\095\088\092\062\087\008\062\087\077\008\126\088\009\127\052\077\071\109\127\009\007\064\087\023\110\087\009\074\008\092\087\023\087\092\008\087\110\092\087\003\008\001\071\058\087\052\091\027\026\095\046\107\071\109\088\127\087\008\062\110\052\008\062\088\077\077\008\116\052\105\004\110\037\008\088\092\091\008\054\110\087\008\035\110\087\037\087\008\107\071\109\110\071\109\009\087\008\058\088\092\092\077\009\008\062\127\008\087\052\058\087\092\092\087\092\067")
_KHDY = Wherigo.ZInput(_iwV)
_KHDY.Id = "07a1f70a-915f-4ee6-8556-be5b23bb3102"
_KHDY.Name = _IGB("\107\009\088\009\110\105\092\040\023")
_KHDY.Description = ""
_KHDY.Visible = true
_KHDY.InputType = "Text"
_KHDY.Text = _IGB("\054\087\037\071\109\087\092\008\026\105\062\087\092\009\122\076\008\064\037\088\127\023\077\009\008\062\127\074\008\062\088\077\077\008\087\077\008\110\077\009\067\008\054\088\052\127\003\067")
_LPWzD = Wherigo.ZInput(_iwV)
_LPWzD.Id = "f8ba424b-ac01-4e26-a213-19b222c18903"
_LPWzD.Name = _IGB("\026\105\062\087\092\009\122\076\087\092")
_LPWzD.Description = ""
_LPWzD.Visible = true
_LPWzD.Choices = {
	"Gleye", 
	"Pseudogleye", 
	"Braunerden", 
	"Niedermoore", 
	"Kolluvisol"
}
_LPWzD.InputType = "MultipleChoice"
_LPWzD.Text = _IGB("\195\156\023\087\052\008\097\087\037\071\109\087\092\008\026\105\092\062\087\009\122\076\008\097\110\037\037\077\009\008\062\127\008\097\088\077\008\097\110\077\077\087\092\067")

-- WorksWithList for object commands --

-- functions --
function _iwV:OnStart()
	_m0wK:Start()
	_Urwigo.OldDialog{
		{
			Text = _IGB("\054\110\037\037\058\105\003\003\087\092\008\110\003\008\126\107\118\008\031\037\062\087\092\088\091\008\100\071\109\008\023\110\092\008\062\110\087\008\031\127\037\087\008\062\087\077\008\054\088\037\062\087\077\091\027\026\095\046\100\071\109\008\097\087\052\062\087\008\062\110\052\008\003\110\009\008\062\087\003\008\031\088\052\009\109\071\088\071\109\087\008\109\087\037\004\087\092\091\008\100\071\109\008\007\087\110\064\087\008\062\110\052\008\097\105\008\062\110\087\008\026\105\062\087\092\076\052\105\004\110\037\087\008\077\110\092\062\008\127\092\062\008\097\088\077\008\062\088\052\195\188\023\087\052\008\037\087\052\092\087\092\008\058\088\092\092\077\009\091\008\065\127\008\058\088\092\092\077\009\008\003\110\071\109\008\088\127\071\109\008\004\052\088\064\087\092\008\127\092\062\008\110\071\109\008\087\052\007\195\164\109\037\087\008\062\110\052\008\088\037\037\087\077\008\097\088\077\008\110\071\109\008\195\188\023\087\052\008\026\195\182\062\087\092\008\097\110\077\077\087\091\027\026\095\046\048\110\087\037\037\087\110\071\109\009\008\058\088\092\092\077\009\008\062\127\008\088\127\071\109\008\127\092\009\087\052\097\087\064\077\008\088\092\062\087\052\087\008\056\110\087\052\008\077\087\109\087\092\008\105\062\087\052\008\109\195\182\052\087\092\091\027\026\095\046\048\110\087\037\008\107\076\088\195\159\108"), 
			Media = _qSAL
		}
	}
end
function _iwV:OnRestore()
end
function _knK:OnEnter()
	_bbp = _IGB("\043\058\092\093")
	_Urwigo.GlobalZoneEnter()
	_DlXh:MoveTo(_knK)
end
function _B8xb:OnEnter()
	_bbp = _IGB("\043\026\057\086\023")
	_Urwigo.GlobalZoneEnter()
	_DlXh:MoveTo(_B8xb)
end
function _OvbSS:OnEnter()
	_bbp = _IGB("\043\069\035\023\107\107")
	_Urwigo.GlobalZoneEnter()
	_YYoMq:MoveTo(_OvbSS)
	_YYoMq.Commands._dGO.Enabled = true
	_YYoMq.Commands._ZkVDT.Enabled = false
	_YYoMq.Commands._I0f.Enabled = false
	_YYoMq.Commands._qe7.Enabled = false
	_YYoMq.Commands._BRXS.Enabled = false
	_YYoMq.Name = _IGB("\026\105\062\087\092\076\052\105\004\110\037")
	_YYoMq.Description = _IGB("\034\110\087\052\008\064\110\023\009\008\087\077\008\087\110\092\087\008\103\052\088\064\087\008\007\127\008\062\110\087\077\087\003\008\026\105\062\087\092\076\052\105\004\110\037")
end
function _p9kK:OnEnter()
	_bbp = _IGB("\043\076\022\058\093")
	_Urwigo.GlobalZoneEnter()
	_YYoMq:MoveTo(_p9kK)
	_YYoMq.Commands._dGO.Enabled = false
	_YYoMq.Commands._ZkVDT.Enabled = true
	_YYoMq.Commands._I0f.Enabled = false
	_YYoMq.Commands._qe7.Enabled = false
	_YYoMq.Commands._BRXS.Enabled = false
	_YYoMq.Name = _IGB("\026\105\062\087\092\076\052\105\004\110\037")
	_YYoMq.Description = _IGB("\034\110\087\052\008\064\110\023\009\008\087\077\008\087\110\092\087\008\103\052\088\064\087\008\007\127\008\062\110\087\077\087\003\008\026\105\062\087\092\076\052\105\004\110\037")
end
function _4yYc:OnEnter()
	_bbp = _IGB("\043\078\122\079\071")
	_Urwigo.GlobalZoneEnter()
	_YYoMq:MoveTo(_4yYc)
	_YYoMq.Commands._dGO.Enabled = false
	_YYoMq.Commands._ZkVDT.Enabled = false
	_YYoMq.Commands._I0f.Enabled = true
	_YYoMq.Commands._qe7.Enabled = false
	_YYoMq.Commands._BRXS.Enabled = false
	_YYoMq.Name = _IGB("\026\105\062\087\092\076\052\105\004\110\037")
	_YYoMq.Description = _IGB("\034\110\087\052\008\064\110\023\009\008\087\077\008\087\110\092\087\008\103\052\088\064\087\008\007\127\008\062\110\087\077\087\003\008\026\105\062\087\092\076\052\105\004\110\037")
end
function _TFN:OnEnter()
	_bbp = _IGB("\043\056\103\126")
	_Urwigo.GlobalZoneEnter()
	_YYoMq:MoveTo(_TFN)
	_YYoMq.Commands._dGO.Enabled = false
	_YYoMq.Commands._ZkVDT.Enabled = false
	_YYoMq.Commands._I0f.Enabled = false
	_YYoMq.Commands._qe7.Enabled = true
	_YYoMq.Commands._BRXS.Enabled = false
	_YYoMq.Name = _IGB("\095\087\109\023\052\127\071\109")
	_YYoMq.Description = _IGB("\034\110\087\052\008\064\110\023\009\008\087\077\008\087\110\092\087\008\103\052\088\064\087\008\007\127\008\062\087\003\008\095\087\109\023\052\127\071\109")
end
function _aHI1:OnEnter()
	_bbp = _IGB("\043\088\034\100\025")
	_Urwigo.GlobalZoneEnter()
	_YYoMq:MoveTo(_aHI1)
	_YYoMq.Commands._dGO.Enabled = false
	_YYoMq.Commands._ZkVDT.Enabled = false
	_YYoMq.Commands._I0f.Enabled = false
	_YYoMq.Commands._qe7.Enabled = false
	_YYoMq.Commands._BRXS.Enabled = true
	_YYoMq.Name = _IGB("\026\105\062\087\092\076\052\105\004\110\037")
	_YYoMq.Description = _IGB("\034\110\087\052\008\064\110\023\009\008\087\077\008\087\110\092\087\008\103\052\088\064\087\008\007\127\008\062\110\087\077\087\003\008\026\105\062\087\092\076\052\105\004\110\037")
end
function _dvDF:OnEnter()
	_bbp = _IGB("\043\062\035\065\103")
	_Urwigo.GlobalZoneEnter()
	_aEEx2 = _IGB("\058\105\037\037\127\035\110")
end
function _xf4:OnEnter()
	_bbp = _IGB("\043\086\004\078")
	_Urwigo.GlobalZoneEnter()
	_aEEx2 = _IGB("\058\105\037\037\127\035\110")
end
function _OGmN5:OnEnter()
	_bbp = _IGB("\043\069\118\003\126\040")
	_Urwigo.GlobalZoneEnter()
	_aEEx2 = _IGB("\058\105\037\037\127\035\110")
end
function _k1V:OnEnter()
	_bbp = _IGB("\043\058\025\048")
	_Urwigo.GlobalZoneEnter()
	_aEEx2 = _IGB("\064\037\087\122")
end
function _EuXA:OnEnter()
	_bbp = _IGB("\043\031\127\075\001")
	_Urwigo.GlobalZoneEnter()
	_aEEx2 = _IGB("\064\037\087\122")
end
function _mSCV:OnEnter()
	_bbp = _IGB("\043\003\107\014\048")
	_Urwigo.GlobalZoneEnter()
end
function _ZgXl:OnEnter()
	_bbp = _IGB("\043\124\064\075\037")
	_Urwigo.GlobalZoneEnter()
	_aEEx2 = _IGB("\023\052\088\127\092")
end
function _PkX:OnEnter()
	_bbp = _IGB("\043\116\058\075")
	_Urwigo.GlobalZoneEnter()
	_aEEx2 = _IGB("\003\105\105\052")
end
function _hnGa:OnEnter()
	_bbp = _IGB("\043\109\092\118\088")
	_Urwigo.GlobalZoneEnter()
	_aEEx2 = _IGB("\076\077\087\127\062\105")
end
function _kG9gL:OnEnter()
	_bbp = _IGB("\043\058\118\022\064\083")
	_Urwigo.GlobalZoneEnter()
	_aEEx2 = _IGB("\064\037\087\122")
end
function _YmWB:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_u5ds = input
	_D6D()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_cv4t)
	end)
end
function _cv4t:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FRD = input
	_D6D()
	_NXQ.Complete = true
	_EP0S()
end
function __DAh:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_lKY = input
	_D6D()
	_DUzc.Complete = true
	_EP0S()
end
function _7qGL:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_yQmY = input
	_D6D()
	_RhO.Complete = true
	_EP0S()
end
function _LGI_:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_4hRz = input
	_D6D()
	_IhZ.Complete = true
	_EP0S()
end
function _76M2H:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_myVlc = input
	_D6D()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_KHDY)
	end)
end
function _KHDY:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Uxx = input
	_D6D()
	_T4Ml.Complete = true
	_EP0S()
end
function _LPWzD:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 36021 then
		_Urwigo.OldDialog{
			{
				Text = _IGB("\118\037\087\122\087\008\077\110\092\062\008\035\105\003\008\118\052\127\092\062\097\088\077\077\087\052\008\023\087\087\110\092\004\037\127\077\077\009\087\008\026\195\182\062\087\092\008\127\092\062\008\062\088\109\087\052\008\110\092\008\126\110\087\062\087\052\127\092\064\087\092\008\127\092\062\008\107\087\092\058\087\092\008\109\195\164\127\004\110\064\008\088\092\007\127\009\052\087\004\004\087\092\091\008\065\088\077\008\109\105\071\109\088\092\077\009\087\109\087\092\062\087\008\127\092\062\008\023\087\097\087\064\037\110\071\109\087\008\118\052\127\092\062\097\088\077\077\087\052\008\037\195\182\077\009\008\110\092\008\077\087\110\092\087\003\008\009\110\087\004\087\052\087\092\008\076\087\052\003\088\092\087\092\009\087\092\008\054\110\052\058\127\092\064\077\023\087\052\087\110\071\109\008\035\087\052\077\071\109\110\087\062\087\092\087\008\026\105\062\087\092\076\088\052\009\110\058\087\037\091\029\094\020\027\026\095\046\065\110\087\008\127\092\009\087\052\077\071\109\110\087\062\037\110\071\109\087\092\008\026\105\062\087\092\009\122\076\087\092\008\062\087\052\008\118\037\087\122\087\008\097\087\052\062\087\092\008\088\127\004\008\118\052\127\092\062\008\062\087\077\008\034\127\003\127\077\064\087\109\088\037\009\087\077\008\110\003\008\069\023\087\052\023\105\062\087\092\008\127\092\062\008\062\087\052\008\034\195\182\109\087\008\062\087\077\008\118\052\127\092\062\097\088\077\077\087\052\077\076\110\087\064\087\037\077\008\023\087\077\009\110\003\003\009\091\029\120\020")
			}, 
			{
				Text = _IGB("\118\037\087\122\087\008\109\088\023\087\092\008\110\062\087\088\037\009\122\076\110\077\071\109\008\062\110\087\008\034\105\052\110\007\105\092\009\110\087\052\127\092\064\008\001\111\118\105\111\118\052\066\027\026\095\046\027\026\095\046\113\001\109\066\008\034\127\003\105\077\087\052\008\069\023\087\052\023\105\062\087\092\074\008\105\004\009\008\105\023\087\052\109\088\037\023\008\062\087\077\008\118\052\127\092\062\097\088\077\077\087\052\087\110\092\004\037\127\077\077\087\077\027\026\095\046\113\118\105\066\008\069\086\110\062\088\009\110\105\092\077\109\105\052\110\007\105\092\009\091\008\107\088\127\087\052\077\009\105\004\004\088\052\003\087\008\107\071\109\110\071\109\009\008\097\105\008\035\105\052\008\088\037\037\087\003\008\031\110\077\087\092\008\110\092\008\052\087\062\127\007\110\087\052\009\087\008\103\105\052\003\008\003\105\023\110\037\110\077\110\087\052\009\008\077\110\092\062\091\008\118\052\127\092\062\097\088\077\077\087\052\008\077\009\087\110\064\009\008\127\092\062\008\077\110\092\058\009\008\110\003\008\063\088\109\052\087\077\035\087\052\037\088\127\004\008\088\023\109\195\164\092\064\110\064\008\035\105\092\008\103\088\058\009\105\052\087\092\008\097\110\087\008\126\110\087\062\087\052\077\071\109\037\088\064\074\008\107\071\109\092\087\087\077\071\109\003\087\037\007\087\008\105\062\087\052\008\116\004\037\088\092\007\087\092\035\087\052\023\052\088\127\071\109\074\008\127\092\062\008\062\052\110\092\064\009\008\092\127\052\008\062\127\052\071\109\008\035\105\052\195\188\023\087\052\064\087\109\087\092\062\087\008\195\132\092\062\087\052\127\092\064\087\092\008\062\087\077\008\118\052\127\092\062\097\088\077\077\087\052\077\076\110\087\064\087\037\077\008\105\062\087\052\008\093\088\076\110\037\037\088\052\058\052\195\164\004\009\087\008\087\110\092\091\027\026\095\046\113\118\052\066\008\095\087\062\127\058\009\110\105\092\077\109\105\052\110\007\105\092\009\091\008\100\092\008\062\110\087\077\087\052\008\107\071\109\110\071\109\009\008\109\087\052\052\077\071\109\087\092\008\077\088\127\087\052\077\009\105\004\004\004\052\087\110\087\074\008\088\092\088\087\052\105\023\087\092\008\026\087\062\110\092\064\127\092\064\087\092\091\008\065\110\087\008\087\052\109\195\164\037\009\008\064\087\097\195\182\109\092\037\110\071\109\008\087\110\092\087\008\023\037\195\164\127\037\110\071\109\113\064\052\088\127\087\008\103\088\052\023\087\008\127\092\062\008\077\009\195\164\092\062\110\064\008\110\003\008\118\052\127\092\062\097\088\077\077\087\052\023\087\052\087\110\071\109\091")
			}
		}
	elseif _Urwigo.Hash(string.lower(input)) == 53441 then
		_Urwigo.OldDialog{
			{
				Text = _IGB("\065\088\077\008\097\110\071\109\009\110\064\077\009\087\008\096\092\009\087\052\077\071\109\110\087\062\008\007\097\110\077\071\109\087\092\008\118\037\087\122\087\008\127\092\062\008\116\077\087\127\062\105\064\037\087\122\087\008\110\077\009\074\008\062\088\077\008\116\077\087\127\062\105\064\037\087\122\087\008\092\110\071\109\009\008\003\110\009\008\062\087\092\008\103\195\188\195\159\087\092\008\110\003\008\118\052\127\092\062\097\088\077\077\087\052\008\077\009\087\109\009\074\008\088\023\087\052\008\088\127\004\008\087\110\092\087\052\008\009\105\092\110\064\087\092\008\107\071\109\110\071\109\009\074\008\062\110\087\008\062\088\077\008\054\088\077\077\087\052\008\023\087\110\008\109\105\109\087\092\008\126\110\087\062\087\052\077\071\109\037\195\164\064\087\092\008\077\009\088\127\009\091\008\096\092\009\087\052\008\107\088\127\087\052\077\009\105\004\004\003\088\092\064\087\037\008\077\110\092\062\008\062\110\087\008\064\037\087\110\071\109\087\092\008\116\052\105\007\087\077\077\087\008\097\110\087\008\023\087\110\003\008\118\037\087\122\008\007\127\008\023\087\105\023\088\071\109\009\087\092\091\029\040\020")
			}, 
			{
				Text = _IGB("\116\077\087\127\062\105\064\037\087\122\087\008\109\088\023\087\092\008\087\110\092\087\008\034\105\052\110\007\105\092\009\110\087\052\127\092\064\008\001\109\111\107\097\111\107\062\066\027\026\095\046\027\026\095\046\113\001\109\066\008\034\127\003\105\077\087\052\008\069\023\087\052\023\105\062\087\092\074\008\105\004\009\008\105\023\087\052\109\088\037\023\008\062\087\077\008\118\052\127\092\062\097\088\077\077\087\052\087\110\092\004\037\127\077\077\087\077\091\027\026\095\046\113\107\097\066\008\107\009\088\127\097\088\077\077\087\052\037\087\110\009\087\092\062\087\008\107\071\109\110\071\109\009\008\110\003\008\096\092\009\087\052\023\105\062\087\092\008\035\105\003\008\007\087\110\009\097\087\110\077\087\008\088\127\004\009\052\087\009\087\092\062\087\092\008\107\009\088\127\097\088\077\077\087\052\008\064\087\076\052\195\164\064\009\008\090\093\087\092\092\007\087\110\071\109\087\092\008\062\087\077\008\116\077\087\127\062\105\064\037\087\122\028\091\008\065\088\052\110\092\008\058\195\182\092\092\087\092\008\058\037\087\110\092\087\008\077\071\109\097\088\052\007\023\052\088\127\092\087\008\085\088\092\064\088\092\113\093\092\195\182\037\037\071\109\087\092\008\087\110\092\064\087\037\088\064\087\052\009\008\077\087\110\092\091\027\026\095\046\113\107\062\066\008\065\110\071\109\009\087\074\008\097\088\077\077\087\052\077\009\088\127\087\092\062\087\074\008\009\105\092\052\087\110\071\109\087\008\127\092\062\008\003\087\110\077\009\008\023\037\088\127\064\052\088\127\008\023\110\077\008\052\105\077\009\023\052\088\127\092\008\003\088\052\003\105\052\110\087\052\009\087\008\096\092\009\087\052\023\105\062\087\092\008\034\105\052\110\007\105\092\009\091")
			}
		}
	elseif _Urwigo.Hash(string.lower(input)) == 22382 then
		_Urwigo.OldDialog{
			{
				Text = _IGB("\026\052\088\127\087\052\062\087\092\008\077\110\092\062\008\087\110\092\008\026\105\062\087\092\009\122\076\008\062\087\077\008\064\087\003\195\164\195\159\110\064\009\008\109\127\003\110\062\087\092\008\093\037\110\003\088\077\091\008\065\088\077\008\001\127\077\064\088\092\064\077\003\088\009\087\052\110\088\037\008\062\087\052\008\026\105\062\087\092\023\110\037\062\127\092\064\008\110\077\009\008\087\110\092\008\077\071\109\097\088\071\109\008\077\071\109\037\127\004\004\110\064\087\052\008\107\088\092\062\091\008\065\110\087\008\026\052\088\127\092\087\052\062\087\092\008\110\003\008\126\107\118\008\031\037\062\087\092\088\008\087\092\009\077\009\088\092\062\087\092\008\127\092\009\087\052\008\026\087\062\110\092\064\127\092\064\087\092\008\077\071\109\097\088\071\109\004\037\110\087\195\159\087\092\062\087\092\008\023\110\077\008\077\009\087\109\087\092\062\087\092\008\054\088\077\077\087\052\077\008\007\097\110\077\071\109\087\092\008\092\110\087\062\087\052\009\088\127\087\092\062\087\092\008\056\105\009\087\110\077\023\037\195\182\071\058\087\092\008\062\087\052\008\037\087\009\007\009\087\092\008\064\052\105\195\159\087\092\008\077\058\088\092\062\110\092\088\035\110\077\071\109\087\092\008\048\087\052\064\037\087\009\077\071\109\087\052\127\092\064\091\029\094\020")
			}, 
			{
				Text = _IGB("\026\052\088\127\092\087\052\062\087\092\008\109\088\023\087\092\008\087\110\092\087\008\009\122\076\110\077\071\109\087\008\034\105\052\110\007\105\092\009\110\087\052\127\092\064\008\001\109\111\026\035\111\014\029\040\020\066\027\026\095\046\027\026\095\046\113\001\109\066\008\034\127\003\105\077\087\052\008\069\023\087\052\023\105\062\087\092\091\008\034\127\003\127\077\077\071\109\110\071\109\009\008\003\110\009\008\097\087\092\110\064\087\052\008\088\037\077\008\010\018\024\008\105\052\064\088\092\110\077\071\109\087\052\008\107\127\023\077\009\088\092\007\091\027\026\095\046\113\026\035\066\008\085\110\092\087\052\088\037\110\077\071\109\087\052\008\048\087\052\097\110\009\009\087\052\127\092\064\077\109\105\052\110\007\105\092\009\074\008\062\087\052\008\062\127\052\071\109\008\062\110\087\077\087\052\008\048\087\052\097\110\009\009\087\052\127\092\064\008\090\124\087\052\058\037\087\110\092\087\052\127\092\064\074\008\083\195\182\077\127\092\064\008\105\062\087\052\008\124\087\052\004\088\037\037\008\035\105\092\008\118\087\077\009\087\110\092\087\092\008\127\092\062\008\085\110\092\087\052\088\037\087\092\008\088\092\008\062\087\052\008\031\052\062\105\023\087\052\004\037\195\164\071\109\087\008\110\092\008\001\023\109\195\164\092\064\110\064\058\087\110\009\008\035\105\092\008\058\037\110\003\088\009\110\077\071\109\087\092\008\026\087\062\110\092\064\127\092\064\087\092\028\008\035\087\052\023\052\088\127\092\009\008\127\092\062\008\035\087\052\037\087\109\003\009\008\110\077\009\091\027\026\095\046\113\014\066\008\096\092\009\087\052\064\052\127\092\062\091\008\001\127\077\064\088\092\064\077\064\087\077\009\087\110\092\074\008\088\127\077\008\062\087\003\008\026\105\062\087\092\008\087\092\009\077\009\087\109\009\091")
			}
		}
	elseif _Urwigo.Hash(string.lower(input)) == 13349 then
		_Urwigo.OldDialog{
			{
				Text = _IGB("\031\110\092\008\085\105\105\052\023\105\062\087\092\008\110\077\009\008\087\110\092\008\097\088\077\077\087\052\064\087\077\195\164\009\009\110\064\009\087\052\008\026\105\062\087\092\074\008\062\087\052\008\088\127\077\008\003\195\164\071\109\009\110\064\087\092\008\056\105\052\004\077\071\109\110\071\109\009\087\092\008\090\105\052\064\088\092\110\077\071\109\087\077\008\107\087\062\110\003\087\092\009\028\008\023\087\077\009\087\109\009\091\008\065\110\087\008\056\105\052\004\088\127\004\037\088\064\087\008\003\127\077\077\008\003\110\092\062\087\077\009\087\092\077\008\010\018\008\071\003\008\003\195\164\071\109\009\110\064\008\077\087\110\092\091\008\085\105\105\052\087\008\097\087\052\062\087\092\008\009\052\088\062\110\009\110\105\092\087\037\037\008\092\088\071\109\008\062\087\052\008\054\088\077\077\087\052\035\087\052\077\105\052\064\127\092\064\008\110\092\008\034\105\071\109\003\105\105\052\087\008\127\092\062\008\126\110\087\062\087\052\003\105\105\052\087\008\127\092\009\087\052\077\071\109\110\087\062\087\092\074\008\097\105\023\087\110\008\126\110\087\062\087\052\003\105\105\052\087\008\093\105\092\009\088\058\009\008\007\127\003\008\118\052\127\092\062\097\088\077\077\087\052\008\109\088\023\087\092\008\127\092\062\008\034\105\071\109\003\105\105\052\087\008\127\092\088\023\109\195\164\092\064\110\064\008\062\088\035\105\092\008\062\127\052\071\109\008\095\087\064\087\092\097\088\077\077\087\052\008\087\092\009\077\009\088\092\062\087\092\008\077\110\092\062\091\029\040\020")
			}, 
			{
				Text = _IGB("\065\110\087\008\056\105\052\004\077\071\109\110\071\109\009\087\092\008\087\092\009\077\009\087\109\087\092\074\008\097\087\092\092\008\085\110\058\052\105\105\052\064\088\092\110\077\003\087\092\008\088\023\064\087\077\009\105\052\023\087\092\087\008\116\004\037\088\092\007\087\092\052\087\077\009\087\008\088\127\004\064\052\127\092\062\008\035\105\092\008\107\088\127\087\052\077\009\105\004\004\003\088\092\064\087\037\008\092\110\071\109\009\008\035\105\037\037\077\009\195\164\092\062\110\064\008\088\023\023\088\127\087\092\008\058\195\182\092\092\087\092\091\008\065\110\087\077\008\076\088\077\077\110\087\052\009\008\109\195\164\127\004\110\064\008\088\092\008\064\052\127\092\062\097\088\077\077\087\052\023\087\087\110\092\004\037\127\195\159\009\087\092\008\107\009\088\092\062\105\052\009\087\092\091\008\056\105\052\004\087\008\097\088\071\109\077\087\092\008\064\087\097\195\182\109\092\037\110\071\109\008\092\127\052\008\037\088\092\064\077\088\003\091\008\065\088\008\092\087\023\087\092\008\062\087\092\008\064\052\105\023\087\092\008\116\004\037\088\092\007\087\092\052\087\077\009\087\092\008\088\127\071\109\008\116\105\037\037\087\092\008\092\110\071\109\009\008\035\105\037\037\077\009\195\164\092\062\110\064\008\088\023\064\087\023\088\127\009\008\097\110\052\062\008\023\110\037\062\087\009\008\037\087\009\007\009\087\052\087\052\008\087\110\092\008\004\088\092\009\088\077\009\110\077\071\109\087\077\008\001\052\071\109\110\035\008\062\087\052\008\072\195\188\092\064\077\009\087\092\008\031\092\009\097\110\071\058\037\127\092\064\008\127\092\077\087\052\087\052\008\109\087\110\003\110\077\071\109\087\092\008\103\037\105\052\088\091\029\094\020")
			}
		}
	elseif _Urwigo.Hash(string.lower(input)) == 41117 then
		_Urwigo.OldDialog{
			{
				Text = _IGB("\093\105\037\037\127\035\110\077\105\037\008\077\110\092\062\008\026\195\182\062\087\092\008\062\087\077\077\087\092\008\023\105\062\087\092\023\110\037\062\087\092\062\087\008\116\052\105\007\087\077\077\087\008\077\110\071\109\008\110\092\062\110\052\087\058\009\008\088\127\004\008\062\088\077\008\003\087\092\077\071\109\037\110\071\109\087\008\054\110\052\058\087\092\008\007\127\052\195\188\071\058\035\087\052\004\105\037\064\087\092\008\037\088\077\077\087\092\091\008\065\110\087\077\087\052\008\026\105\062\087\092\008\087\092\009\097\110\071\058\087\037\009\008\077\110\071\109\008\088\092\008\107\009\088\092\062\105\052\009\087\092\074\008\088\092\008\062\087\092\087\092\008\077\110\071\109\008\088\127\004\064\052\127\092\062\008\062\087\052\008\083\088\064\087\008\035\105\092\008\088\092\062\087\052\087\052\008\107\009\087\037\037\087\008\088\023\064\087\009\052\088\064\087\092\087\077\008\026\105\062\087\092\003\088\009\087\052\110\088\037\008\097\110\087\062\087\052\008\088\092\077\088\003\003\087\037\092\008\058\088\092\092\091\008\065\110\087\008\103\088\058\009\105\052\087\092\074\008\062\110\087\008\007\127\008\031\052\105\077\110\105\092\008\035\105\092\008\026\105\062\087\092\003\088\009\087\052\110\088\037\008\088\092\008\088\092\062\087\052\087\052\008\107\009\087\037\037\087\008\004\195\188\109\052\087\092\008\077\110\092\062\008\023\087\110\003\008\093\105\037\037\127\035\110\077\105\037\008\195\188\023\087\052\097\110\087\064\087\092\062\008\003\087\092\077\071\109\037\110\071\109\087\092\008\096\052\077\076\052\127\092\064\077\008\097\110\087\008\023\087\110\077\076\110\087\037\077\097\087\110\077\087\008\062\110\087\008\095\105\062\127\092\064\008\035\105\092\008\054\195\164\037\062\087\052\092\008\088\092\008\034\088\092\064\037\088\064\087\092\091\008\093\105\037\037\127\035\110\077\105\037\008\026\195\182\062\087\092\008\004\110\092\062\087\092\008\077\110\071\109\008\105\004\009\008\110\003\008\026\087\052\087\110\071\109\008\035\105\092\008\001\071\058\087\052\023\087\052\064\087\092\008\077\105\097\110\087\008\088\092\008\054\087\064\023\195\182\077\071\109\127\092\064\087\092\008\127\092\062\008\023\087\110\008\109\110\077\009\105\052\110\077\071\109\087\092\008\001\071\058\087\052\009\087\052\052\088\077\077\087\092\008\127\092\009\087\052\008\054\088\037\062\091\008\034\195\164\127\004\110\064\087\052\008\077\110\092\062\008\058\105\037\037\127\035\110\088\037\087\008\195\156\023\087\052\062\087\071\058\127\092\064\087\092\008\023\087\110\008\087\052\105\062\110\087\052\009\087\092\008\026\195\182\062\087\092\008\097\110\087\008\026\052\088\127\092\087\052\062\087\092\091\027\026\095\046\065\127\052\071\109\008\062\087\092\008\004\087\109\037\087\092\062\087\092\008\026\087\097\127\071\109\077\008\097\110\052\062\008\109\127\003\105\077\087\077\008\069\023\087\052\023\105\062\087\092\003\088\009\087\052\110\088\037\008\037\087\110\071\109\009\087\052\008\062\087\092\008\034\088\092\064\008\109\110\092\127\092\009\087\052\008\064\087\009\052\088\064\087\092\091\008\001\003\008\034\088\092\064\004\127\195\159\008\105\062\087\052\008\110\092\008\107\087\092\058\087\092\008\037\088\064\087\052\009\008\077\110\071\109\008\062\110\087\077\087\077\008\085\088\009\087\052\110\088\037\008\097\110\087\062\087\052\008\088\023\074\008\062\087\052\008\093\105\037\037\127\035\110\077\105\037\008\087\092\009\077\009\087\109\009\091\029\078\020")
			}, 
			{
				Text = _IGB("\093\105\037\037\127\035\110\077\105\037\023\195\182\062\087\092\008\109\088\023\087\092\008\087\110\092\087\008\009\122\076\110\077\071\109\087\008\034\105\052\110\007\105\092\009\110\087\052\127\092\064\008\001\109\111\085\111\100\100\066\027\026\095\046\027\026\095\046\113\001\109\066\008\034\127\003\105\077\087\052\008\069\023\087\052\023\105\062\087\092\091\008\034\127\003\127\077\077\071\109\110\071\109\009\008\003\110\009\008\097\087\092\110\064\087\052\008\088\037\077\008\010\018\024\008\105\052\064\088\092\110\077\071\109\087\052\008\107\127\023\077\009\088\092\007\091\027\026\095\046\113\085\066\008\026\105\062\087\092\109\105\052\110\007\105\092\009\008\088\127\077\008\077\087\062\110\003\087\092\009\110\087\052\009\087\003\074\008\109\127\003\105\077\087\003\008\026\105\062\087\092\003\088\009\087\052\110\088\037\091\008\065\087\052\008\071\109\088\052\088\058\009\087\052\110\077\009\110\077\071\109\087\008\085\113\034\105\052\110\007\105\092\009\008\110\077\009\008\077\087\109\052\008\062\127\092\058\087\037\074\008\109\127\003\105\077\008\127\092\062\008\092\195\164\109\052\077\009\105\004\004\052\087\110\071\109\008\077\105\097\110\087\008\003\110\092\062\087\077\009\087\092\077\008\078\018\008\071\003\008\003\195\164\071\109\009\110\064\091")
			}
		}
	end
end
function _m0wK:OnTick()
	local _rndChoiceValue = math.random()
	if _rndChoiceValue < 0.233333333333333 then
		Wherigo.PlayAudio(_K_xf)
		_Uyo3j.Visible = true
	elseif _rndChoiceValue < 0.266666666666667 then
		Wherigo.PlayAudio(_QTNK)
		_cpM.Visible = true
	elseif _rndChoiceValue < 0.366666666666667 then
		Wherigo.PlayAudio(_K_xf)
		_9IvKe.Visible = true
	elseif _rndChoiceValue < 0.6 then
		Wherigo.PlayAudio(_iwVl6)
		_j6xbl.Visible = true
	elseif _rndChoiceValue < 0.7 then
		Wherigo.PlayAudio(_g2r2)
		_tlF2O.Visible = true
	elseif _rndChoiceValue < 0.833333333333333 then
		Wherigo.PlayAudio(_K_xf)
		_o6OuP.Visible = true
	elseif _rndChoiceValue < 0.933333333333333 then
		Wherigo.PlayAudio(_K_xf)
		_4eUcg.Visible = true
	else
		Wherigo.PlayAudio(_iwVl6)
		_onek.Visible = true
	end
	_gVT_:Start()
	_k7K = math.random(30, 300)
	_m0wK.Duration = _k7K
	_m0wK:Start()
end
function _gVT_:OnTick()
	Wherigo.Command "StopSound"
	_cpM.Visible = false
	_Uyo3j.Visible = false
	_9IvKe.Visible = false
	_tlF2O.Visible = false
	_o6OuP.Visible = false
	_j6xbl.Visible = false
	_4eUcg.Visible = false
	_onek.Visible = false
end
function _DlXh:On_uq76(target)
	_Urwigo.MessageBox{
		Text = _IGB("\065\087\052\008\026\105\062\087\092\008\110\077\009\008\062\087\052\008\105\023\087\052\077\009\087\008\056\087\110\037\008\062\087\052\008\031\052\062\058\052\127\077\009\087\091\008\065\110\087\008\026\195\182\062\087\092\008\077\110\092\062\008\062\088\077\008\031\052\064\087\023\092\110\077\008\062\087\077\008\124\127\077\088\003\003\087\092\097\110\052\058\087\092\077\008\035\105\092\008\064\087\105\037\105\064\110\077\071\109\087\003\008\107\127\023\077\009\052\088\009\074\008\095\087\037\110\087\004\074\008\093\037\110\003\088\074\008\026\105\062\087\092\097\088\077\077\087\052\074\008\056\110\087\052\113\008\127\092\062\008\116\004\037\088\092\007\087\092\097\087\037\009\074\008\003\087\092\077\071\109\037\110\071\109\087\052\008\056\195\164\009\110\064\058\087\110\009\008\127\092\062\008\035\087\052\004\195\188\064\023\088\052\087\052\008\124\087\110\009\091\008\065\110\087\077\087\008\103\088\058\009\105\052\087\092\008\097\087\071\109\077\087\037\092\008\035\105\092\008\069\052\009\008\007\127\008\069\052\009\091\008\065\087\077\109\088\037\023\008\064\110\023\009\008\087\077\008\110\003\008\126\107\118\008\031\037\062\087\092\088\008\088\127\071\109\008\035\110\087\037\087\008\035\087\052\077\071\109\110\087\062\087\092\088\052\009\110\064\087\092\008\026\195\182\062\087\092\091\029\010\020\027\026\095\046\054\110\071\109\009\110\064\077\009\087\092\008\031\052\058\087\092\092\127\092\064\077\003\087\052\058\003\088\037\008\062\087\052\008\026\105\062\087\092\008\110\077\009\008\062\110\087\008\001\127\077\023\110\037\062\127\092\064\008\127\092\062\008\001\023\004\105\037\064\087\008\127\092\009\087\052\077\071\109\110\087\062\037\110\071\109\008\064\087\004\195\164\052\023\009\087\052\008\026\105\062\087\092\109\105\052\110\007\105\092\009\087\074\008\062\110\087\008\035\105\092\008\105\023\087\092\008\092\088\071\109\008\127\092\009\087\092\008\062\088\077\008\026\105\062\087\092\076\052\105\004\110\037\008\023\110\037\062\087\092\091\008\026\105\062\087\092\076\052\105\004\110\037\087\008\003\110\009\008\064\037\087\110\071\109\087\092\008\105\062\087\052\008\195\164\109\092\037\110\071\109\087\092\008\085\087\052\058\003\088\037\087\008\097\087\052\062\087\092\008\110\092\008\026\105\062\087\092\009\122\076\087\092\008\007\127\077\088\003\003\087\092\064\087\004\088\077\077\009\074\008\062\110\087\008\023\087\077\009\110\003\003\009\087\008\097\110\077\077\087\092\077\071\109\088\004\009\037\110\071\109\087\008\026\087\007\087\110\071\109\092\127\092\064\087\092\008\009\052\088\064\087\092\091")
	}
end
function _DlXh:On_v6v(target)
	_Urwigo.OldDialog{
		{
			Text = _IGB("\026\105\062\087\092\109\105\052\110\007\105\092\009\087\008\077\110\092\062\008\026\087\052\087\110\071\109\087\008\110\092\092\087\052\109\088\037\023\008\062\087\077\008\026\105\062\087\092\077\074\008\062\110\087\008\087\110\092\109\087\110\009\037\110\071\109\008\195\164\109\092\037\110\071\109\087\008\085\087\052\058\003\088\037\087\008\127\092\062\008\031\110\064\087\092\077\071\109\088\004\009\087\092\008\023\087\077\110\009\007\087\092\008\127\092\062\008\077\110\071\109\008\035\105\092\008\062\088\052\195\188\023\087\052\037\110\087\064\087\092\062\087\092\008\105\062\087\052\008\062\088\052\127\092\009\087\052\004\105\037\064\087\092\062\087\092\008\026\087\052\087\110\071\109\087\092\008\127\092\009\087\052\077\071\109\087\110\062\087\092\091")
		}, 
		{
			Text = _IGB("\065\110\087\008\026\105\062\087\092\109\105\052\110\007\105\092\009\087\008\037\088\077\077\087\092\008\077\110\071\109\074\008\110\003\008\026\105\062\087\092\076\052\105\004\110\037\008\035\105\092\008\105\023\087\092\008\092\088\071\109\008\127\092\009\087\092\074\008\064\052\105\023\008\097\110\087\008\004\105\037\064\009\008\087\110\092\009\087\110\037\087\092\066\029\120\020\027\026\095\046\008\102\092\023\077\076\015\102\092\023\077\076\015\102\092\023\077\076\015\069\113\034\105\052\110\007\105\092\009\087\066\008\105\052\064\088\092\110\077\071\109\087\008\001\127\004\037\088\064\087\091\027\026\095\046\008\102\092\023\077\076\015\102\092\023\077\076\015\102\092\023\077\076\015\001\113\034\105\052\110\007\105\092\009\087\066\008\003\110\092\087\052\088\037\110\077\071\109\087\052\008\069\023\087\052\023\105\062\087\092\091\027\026\095\046\008\102\092\023\077\076\015\102\092\023\077\076\015\102\092\023\077\076\015\026\113\034\105\052\110\007\105\092\009\087\066\008\003\110\092\087\052\088\037\110\077\071\109\087\052\008\096\092\009\087\052\023\105\062\087\092\091\027\026\095\046\008\102\092\023\077\076\015\102\092\023\077\076\015\102\092\023\077\076\015\014\113\034\105\052\110\007\105\092\009\087\066\008\003\110\092\087\052\088\037\110\077\071\109\087\052\008\096\092\009\087\052\064\052\127\092\062\091\027\026\095\046"), 
			Media = _xFt
		}, 
		{
			Text = _IGB("\001\127\195\159\087\052\062\087\003\008\064\110\023\009\008\087\077\008\097\087\110\009\087\052\087\008\035\105\052\088\092\064\087\077\009\087\037\037\009\087\008\026\127\071\109\077\009\088\023\087\092\008\007\127\052\008\093\087\092\092\007\087\110\071\109\092\127\092\064\008\023\087\077\105\092\062\087\052\087\052\008\116\052\105\007\087\077\077\087\008\127\092\062\008\031\110\064\087\092\077\071\109\088\004\009\087\092\074\008\062\110\087\008\092\110\071\109\009\008\062\127\052\071\109\008\062\110\087\008\026\105\062\087\092\023\110\037\062\127\092\064\008\087\092\009\077\009\088\092\062\087\092\008\077\110\092\062\074\008\127\092\062\008\003\110\009\008\052\195\182\003\110\077\071\109\087\008\124\088\109\037\087\092\008\097\110\052\062\008\087\110\092\008\007\097\087\110\009\087\008\107\071\109\110\071\109\009\008\023\087\007\087\110\071\109\092\087\009\091\008\065\110\087\008\077\087\109\087\092\008\097\087\052\062\087\092\008\097\110\052\008\004\195\188\052\008\072\087\062\087\092\008\026\105\062\087\092\009\122\076\008\064\087\092\088\127\087\052\008\088\092\077\087\109\087\092\091")
		}
	}
end
function _DlXh:On_3HUa(target)
	if Wherigo.NoCaseEquals(_aEEx2, _IGB("\064\037\087\122")) then
		_Urwigo.MessageBox{
			Text = _EvbW
		}
	elseif Wherigo.NoCaseEquals(_aEEx2, _IGB("\076\077\087\127\062\105")) then
		_Urwigo.MessageBox{
			Text = _n3V
		}
	elseif Wherigo.NoCaseEquals(_aEEx2, _IGB("\023\052\088\127\092")) then
		_Urwigo.MessageBox{
			Text = _FqDwt
		}
	elseif Wherigo.NoCaseEquals(_aEEx2, _IGB("\003\105\105\052")) then
		_Urwigo.MessageBox{
			Text = _UMln
		}
	elseif Wherigo.NoCaseEquals(_aEEx2, _IGB("\058\105\037\037\127\035\110")) then
		_Urwigo.MessageBox{
			Text = _xgL2
		}
	end
end
function _DlXh:On_p8yx(target)
	_Urwigo.OldDialog{
		{
			Text = _IGB("\100\003\008\126\107\118\008\031\037\062\087\092\088\008\062\105\003\110\092\110\087\052\087\092\008\092\195\164\077\077\087\064\087\076\052\195\164\064\009\087\008\026\195\182\062\087\092\074\008\097\105\023\087\110\008\118\052\127\092\062\097\088\077\077\087\052\008\035\087\052\077\071\109\110\087\062\087\092\087\008\056\122\076\087\092\008\035\105\092\008\126\110\087\062\087\052\003\105\105\052\023\195\182\062\087\092\008\127\092\062\008\118\037\087\122\087\092\008\127\092\062\008\107\009\088\127\097\195\164\077\077\087\052\008\116\077\087\127\062\105\064\037\087\122\087\008\076\052\195\164\064\087\092\091\008\065\110\087\008\048\087\052\009\087\110\037\127\092\064\008\062\087\052\008\026\195\182\062\087\092\008\109\195\164\092\064\087\092\008\035\105\092\008\062\087\052\008\001\127\077\076\052\195\164\064\127\092\064\008\035\105\092\008\054\088\077\077\087\052\074\008\107\127\023\077\009\052\088\009\008\127\092\062\008\095\087\037\110\087\004\008\088\023\091\008\065\088\023\087\110\008\077\076\110\087\037\009\008\023\087\077\105\092\062\087\052\077\008\062\088\077\008\026\105\062\087\092\097\088\077\077\087\052\074\008\062\087\052\087\092\008\031\052\077\071\109\087\110\092\127\092\064\077\004\105\052\003\008\035\105\092\008\107\127\023\077\009\052\088\009\008\127\092\062\008\095\087\037\110\087\004\008\064\087\077\009\087\127\087\052\009\008\097\110\052\062\074\008\087\110\092\087\008\097\087\077\087\092\009\037\110\071\109\087\008\095\105\037\037\087\091\008\026\195\182\062\087\092\008\105\109\092\087\008\034\122\062\052\105\003\105\052\076\109\110\087\003\087\052\058\003\088\037\087\008\077\110\092\062\008\088\127\004\008\058\037\087\110\092\087\008\001\052\087\088\037\087\008\023\087\064\052\087\092\007\009\091"), 
			Media = _n5ZX
		}, 
		{
			Text = _IGB("\100\092\008\062\087\092\008\107\087\092\058\087\092\008\127\092\062\008\126\110\087\062\087\052\127\092\064\087\092\074\008\003\110\009\008\064\088\092\007\072\195\164\109\052\110\064\008\109\105\109\087\003\008\118\052\127\092\062\097\088\077\077\087\052\077\009\088\092\062\074\008\109\088\023\087\092\008\077\110\071\109\008\126\110\087\062\087\052\003\105\105\052\087\008\064\087\023\110\037\062\087\009\091\008\065\110\087\008\095\087\109\023\052\127\071\109\113\056\105\052\004\087\008\077\110\092\062\008\035\087\052\023\052\087\110\009\087\009\008\035\105\092\008\003\110\092\087\052\088\037\110\077\071\109\087\092\008\088\092\009\109\052\105\076\105\064\087\092\008\088\127\004\064\087\023\052\088\071\109\009\087\092\008\026\105\062\087\092\003\088\009\087\052\110\088\037\110\087\092\008\023\087\062\087\071\058\009\091\008\065\110\087\008\088\092\064\052\087\092\007\087\092\062\087\092\008\026\087\052\087\110\071\109\087\008\062\087\052\008\107\087\092\058\087\092\008\097\087\052\062\087\092\008\035\105\092\008\118\037\087\122\087\092\008\088\127\004\008\077\088\092\062\110\064\087\092\008\105\062\087\052\008\037\087\109\003\110\064\087\092\008\107\127\023\077\009\052\088\009\087\092\008\087\110\092\064\087\092\105\003\003\087\092\091"), 
			Media = _n5ZX
		}, 
		{
			Text = _IGB("\100\092\008\062\087\092\008\009\110\087\004\077\009\087\092\008\026\087\052\087\110\071\109\087\092\008\062\105\003\110\092\110\087\052\087\092\008\118\052\127\092\062\097\088\077\077\087\052\023\195\182\062\087\092\091\008\118\037\087\122\008\127\092\062\008\116\077\087\127\062\105\064\037\087\122\087\074\008\062\110\087\008\062\127\052\071\109\008\062\110\087\008\195\156\023\087\052\037\088\064\087\052\127\092\064\008\035\105\092\008\064\052\127\092\062\113\008\127\092\062\008\077\009\088\127\097\088\077\077\087\052\023\087\087\110\092\004\037\127\077\077\009\087\092\008\026\087\052\087\110\071\109\087\092\008\087\092\009\077\009\087\109\087\092\008\004\110\092\062\087\092\008\109\110\087\052\008\004\037\195\164\071\109\087\092\109\088\004\009\087\008\048\087\052\023\052\087\110\009\127\092\064\091"), 
			Media = _n5ZX
		}, 
		{
			Text = _IGB("\026\052\088\127\092\087\052\062\087\092\008\023\110\037\062\087\092\008\077\110\071\109\008\110\092\008\107\009\088\092\062\105\052\009\087\092\008\004\052\087\110\008\035\105\092\008\118\052\127\092\062\097\088\077\077\087\052\008\097\105\008\062\087\052\008\105\023\087\052\004\037\195\164\071\109\087\092\092\088\109\087\008\034\088\127\076\009\035\087\052\097\110\009\009\087\052\127\092\064\077\023\087\052\087\110\071\109\008\110\092\008\103\105\052\003\008\087\110\092\087\052\008\023\052\088\127\087\092\008\103\195\164\052\023\127\092\064\008\007\127\003\008\048\105\052\077\071\109\087\110\092\008\058\105\003\003\087\092\008\058\088\092\092\091\008\065\087\077\109\088\037\023\008\092\087\109\003\087\092\008\026\052\088\127\092\087\052\062\087\092\008\087\110\092\008\064\087\052\110\092\064\087\092\008\001\092\009\087\110\037\008\062\087\077\008\126\107\118\008\031\037\062\087\092\088\008\087\110\092\091"), 
			Media = _n5ZX
		}, 
		{
			Text = _IGB("\065\110\087\008\126\127\009\007\127\092\064\008\062\087\052\008\083\088\092\062\077\071\109\088\004\009\008\062\127\052\071\109\008\062\087\092\008\085\087\092\077\071\109\087\092\008\004\195\188\109\052\009\087\008\007\127\052\008\097\087\110\009\087\052\087\092\008\065\110\004\004\087\052\087\092\007\110\087\052\127\092\064\008\062\087\052\008\026\105\062\087\092\062\087\071\058\087\091\008\031\077\008\023\110\037\062\087\009\087\092\008\077\110\071\109\008\031\052\105\077\110\105\092\077\113\008\127\092\062\008\001\058\058\127\003\127\037\088\009\110\105\092\077\076\052\105\004\110\037\087\091\008\103\052\195\188\109\087\052\087\008\001\071\058\087\052\092\127\009\007\127\092\064\008\097\110\052\062\008\195\188\023\087\052\008\093\105\037\037\127\035\110\088\037\023\195\182\062\087\092\008\077\110\071\109\009\023\088\052\091"), 
			Media = _n5ZX
		}
	}
end
function _DlXh:On_n0tf(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_LPWzD)
	end)
end
function _YYoMq:On_dGO(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_YmWB)
	end)
end
function _YYoMq:On_ZkVDT(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(__DAh)
	end)
end
function _YYoMq:On_I0f(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_7qGL)
	end)
end
function _YYoMq:On_qe7(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_LGI_)
	end)
end
function _YYoMq:On_BRXS(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_76M2H)
	end)
end
function _Urwigo.GlobalZoneEnter()
	_iwV:RequestSync()
end

-- Urwigo functions --
function _D6D()
	_4JMt.Description = ((((((((((((_IGB("\065\127\008\109\088\077\009\008\004\105\037\064\087\092\062\087\077\008\064\087\088\092\009\097\105\052\009\087\009\066\027\026\095\046\103\052\088\064\087\008\025\088\066\008").._u5ds).._IGB("\027\026\095\046\103\052\088\064\087\008\025\023\066\008")).._FRD).._IGB("\027\026\095\046\103\052\088\064\087\008\094\066\008")).._lKY).._IGB("\027\026\095\046\103\052\088\064\087\008\010\066\008")).._yQmY).._IGB("\027\026\095\046\103\052\088\064\087\008\078\066\008")).._4hRz).._IGB("\027\026\095\046\103\052\088\064\087\008\040\088\066\008")).._myVlc).._IGB("\027\026\095\046\103\052\088\064\087\008\040\023\066\008")).._Uxx
end
function _EP0S()
	if _NXQ.Complete == true then
		if _DUzc.Complete == true then
			if _RhO.Complete == true then
				if _IhZ.Complete == true then
					if _T4Ml.Complete == true then
						_iwV.Complete = true
						_Urwigo.Dialog(false, {
							{
								Text = _IGB("\065\127\008\109\088\077\009\008\088\037\037\087\008\062\110\087\008\103\052\088\064\087\092\008\064\087\088\092\009\097\105\052\009\087\009\108\027\026\095\046\031\077\008\110\077\009\008\058\087\110\092\087\008\083\105\064\023\087\062\110\092\064\127\092\064\008\088\023\087\052\008\097\087\092\092\008\062\127\008\087\077\008\003\195\182\071\109\009\087\077\009\074\008\062\127\008\058\088\092\092\077\009\008\088\127\071\109\008\064\087\052\092\087\008\087\110\092\008\103\105\009\105\008\035\105\003\008\062\087\003\008\069\052\009\008\110\003\008\126\107\118\074\008\062\087\052\008\062\127\008\088\003\008\037\110\087\023\077\009\087\092\008\109\088\009\009\087\077\009\091\008\031\077\008\064\110\023\009\008\035\110\087\037\087\008\077\071\109\195\182\092\087\008\031\071\058\087\092\008\109\110\087\052\108\027\026\095\046\085\110\009\008\001\023\077\087\092\062\127\092\064\008\062\087\052\008\001\092\009\097\105\052\009\087\092\008\088\092\008\003\110\071\109\008\109\088\077\009\008\062\127\008\083\105\064\004\052\087\110\064\088\023\087\091\008\065\127\008\023\052\088\127\071\109\077\009\008\126\100\014\034\056\008\088\092\008\003\087\110\092\087\052\008\001\092\009\097\105\052\009\111\026\087\077\009\195\164\009\110\064\127\092\064\008\097\088\052\009\087\092\091\008\100\071\109\008\003\087\037\062\087\008\003\110\071\109\008\097\087\092\092\008\097\088\077\008\004\088\037\077\071\109\008\077\087\110\092\008\077\105\037\037\009\087\091"), 
								Media = _qSAL
							}, 
							{
								Text = _IGB("\034\110\087\052\008\109\088\077\009\008\062\127\008\088\127\071\109\008\062\087\092\008\014\105\003\076\037\087\009\110\105\092\008\014\105\062\087\066\008")..string.sub(Player.CompletionCode, 1, 15)
							}
						}, function(action)
							_Kn8.Description = string.sub(Player.CompletionCode, 1, 15)
							_Kn8:MoveTo(Player)
						end)
					end
				end
			end
		end
	end
end

-- Begin user functions --
-- End user functions --
return _iwV
