require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

objLehighCanalattheLVGGPWherigoTour = Wherigo.ZCartridge()

-- String decode --
function _IqY(str)
	local res = ""
    local dtable = "\065\076\053\110\075\042\050\093\038\016\104\019\079\043\035\097\008\058\036\010\060\037\092\115\080\032\105\020\056\024\025\004\026\052\089\067\069\029\121\100\000\001\112\011\101\103\070\117\107\111\077\096\099\083\062\073\015\006\014\002\085\087\119\120\068\054\123\064\118\055\040\086\095\082\044\116\023\046\005\106\013\108\061\094\045\090\031\088\066\033\041\047\049\059\125\098\018\091\048\007\012\003\027\074\084\063\057\071\078\109\022\028\039\102\081\114\126\122\017\113\124\021\034\009\072\051\030"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
objFurnance = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objFurnance.Id = "1345b699-8764-4c8a-9b15-b1ea54abbea8"
objFurnance.Name = _IqY("\047\048\116\004\016\004\053\045")
objFurnance.Description = ""
objFurnance.AltText = ""
objFurnance.Resources = {
	{
		Type = "JPG", 
		Filename = "Furnace.JPG", 
		Directives = {}
	}
}
objDavidThomas = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objDavidThomas.Id = "d90d9bd5-e960-414b-89c5-d8942e56aacd"
objDavidThomas.Name = _IqY("\065\016\069\027\040\026\105\011\050\110\016\024")
objDavidThomas.Description = _IqY("\047\050\048\004\040\045\116\026\050\114\026\051\050\040\045\116\004\026\056\116\050\004\026\056\004\040\048\024\076\116\039")
objDavidThomas.AltText = ""
objDavidThomas.Resources = {
	{
		Type = "JPG", 
		Filename = "DavidThomasSm.JPG", 
		Directives = {}
	}
}
objIronPlant = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objIronPlant.Id = "db12b983-8080-475c-9b98-956ae04a6beb"
objIronPlant.Name = _IqY("\056\116\050\004\026\025\082\016\004\076")
objIronPlant.Description = ""
objIronPlant.AltText = ""
objIronPlant.Resources = {
	{
		Type = "JPG", 
		Filename = "IronPlant.JPG", 
		Directives = {}
	}
}
objHughMoore = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objHughMoore.Id = "30720526-fcc1-47ed-89b4-3d0be5412415"
objHughMoore.Name = _IqY("\125\048\046\011\026\051\050\050\116\045")
objHughMoore.Description = ""
objHughMoore.AltText = ""
objHughMoore.Resources = {
	{
		Type = "JPG", 
		Filename = "HughMoore.JPG", 
		Directives = {}
	}
}
objLockTender = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objLockTender.Id = "e0ed8039-7fee-40fe-afcd-67978a07f81d"
objLockTender.Name = _IqY("\002\050\053\049\026\105\045\004\040\045\116")
objLockTender.Description = ""
objLockTender.AltText = ""
objLockTender.Resources = {
	{
		Type = "JPG", 
		Filename = "LockTender.JPG", 
		Directives = {}
	}
}
objWilliamFirmstone = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objWilliamFirmstone.Id = "fd0edcf8-5c54-4850-b116-487c7c37376e"
objWilliamFirmstone.Name = _IqY("\062\027\082\082\027\016\110\026\047\027\116\110\024\076\050\004\045")
objWilliamFirmstone.Description = ""
objWilliamFirmstone.AltText = ""
objWilliamFirmstone.Resources = {
	{
		Type = "JPG", 
		Filename = "WilliamFirmstone.JPG", 
		Directives = {}
	}
}
objBoat = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objBoat.Id = "bde413c5-7652-44c9-85ad-3ad153d175e9"
objBoat.Name = _IqY("\089\050\016\076")
objBoat.Description = ""
objBoat.AltText = ""
objBoat.Resources = {
	{
		Type = "JPG", 
		Filename = "Boat.JPG", 
		Directives = {}
	}
}
objKeystoneFurnance = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objKeystoneFurnance.Id = "066b516a-e7f9-4083-a83a-f13d11fa849d"
objKeystoneFurnance.Name = _IqY("\005\045\039\024\076\050\004\045\026\047\048\116\004\016\004\053\045")
objKeystoneFurnance.Description = ""
objKeystoneFurnance.AltText = ""
objKeystoneFurnance.Resources = {
	{
		Type = "JPG", 
		Filename = "KeystoneFurnance.JPG", 
		Directives = {}
	}
}
objDemolitionOfGlendonFurnance = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objDemolitionOfGlendonFurnance.Id = "92f089b4-e268-4acb-b7da-e1ca3e14531e"
objDemolitionOfGlendonFurnance.Name = _IqY("\065\045\110\050\082\027\076\027\050\004\026\013\114\026\108\082\045\004\040\050\004\026\047\048\116\004\016\004\053\045")
objDemolitionOfGlendonFurnance.Description = ""
objDemolitionOfGlendonFurnance.AltText = ""
objDemolitionOfGlendonFurnance.Resources = {
	{
		Type = "JPG", 
		Filename = "DemolitionofGlendon.JPG", 
		Directives = {}
	}
}
objLucyFurnance = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objLucyFurnance.Id = "71e4ed52-11d4-47a3-9071-f19e5c098d11"
objLucyFurnance.Name = _IqY("\002\048\053\039\026\047\048\116\004\016\004\053\045")
objLucyFurnance.Description = ""
objLucyFurnance.AltText = ""
objLucyFurnance.Resources = {
	{
		Type = "JPG", 
		Filename = "LucyFurnance.JPG", 
		Directives = {}
	}
}
objGlendonFurnance3 = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objGlendonFurnance3.Id = "40794b50-7718-405a-a11f-4f242af98af2"
objGlendonFurnance3.Name = _IqY("\108\082\045\004\040\050\004\026\047\048\116\004\016\004\053\045\026\126")
objGlendonFurnance3.Description = ""
objGlendonFurnance3.AltText = ""
objGlendonFurnance3.Resources = {
	{
		Type = "JPG", 
		Filename = "GlendonFurnance3.JPG", 
		Directives = {}
	}
}
objEarthcache = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objEarthcache.Id = "cb6d8ecb-9bae-4689-be29-015c0eea3399"
objEarthcache.Name = _IqY("\037\016\116\076\011\053\016\053\011\045")
objEarthcache.Description = ""
objEarthcache.AltText = ""
objEarthcache.Resources = {
	{
		Type = "JPG", 
		Filename = "Earthcache.JPG", 
		Directives = {}
	}
}
objNever = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objNever.Id = "d8e95b86-56ef-4978-942b-2301dc0d9afc"
objNever.Name = _IqY("\109\045\069\045\116")
objNever.Description = ""
objNever.AltText = ""
objNever.Resources = {
	{
		Type = "JPG", 
		Filename = "NevertooLate.JPG", 
		Directives = {}
	}
}
objFinalView = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objFinalView.Id = "2a20903c-e0c4-4292-8b19-1088ba58a948"
objFinalView.Name = _IqY("\047\027\004\016\082\026\072\027\045\063")
objFinalView.Description = ""
objFinalView.AltText = ""
objFinalView.Resources = {
	{
		Type = "JPG", 
		Filename = "Final.JPG", 
		Directives = {}
	}
}
objSpoiler = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objSpoiler.Id = "511ce60b-0b49-4639-9669-664a88f589e5"
objSpoiler.Name = _IqY("\054\043\050\027\082\045\116")
objSpoiler.Description = ""
objSpoiler.AltText = ""
objSpoiler.Resources = {
	{
		Type = "JPG", 
		Filename = "Spoiler.JPG", 
		Directives = {}
	}
}
objFinalGZ = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objFinalGZ.Id = "2337ff22-8a26-46ad-828c-3c2f0ca2033d"
objFinalGZ.Name = _IqY("\047\027\004\016\082\026\108\086")
objFinalGZ.Description = ""
objFinalGZ.AltText = ""
objFinalGZ.Resources = {
	{
		Type = "JPG", 
		Filename = "Final1.JPG", 
		Directives = {}
	}
}
objSpoiler1 = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objSpoiler1.Id = "eb27eddb-ded6-45d4-860e-41c9044b8cd7"
objSpoiler1.Name = _IqY("\054\043\050\027\082\045\116")
objSpoiler1.Description = ""
objSpoiler1.AltText = ""
objSpoiler1.Resources = {
	{
		Type = "JPG", 
		Filename = "Spoiler1.JPG", 
		Directives = {}
	}
}
objRailroadSpike = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objRailroadSpike.Id = "0a633dec-fa6c-4355-9baf-cf03eea31ca9"
objRailroadSpike.Name = _IqY("\074\016\027\082\116\050\016\040\026\054\043\027\049\045")
objRailroadSpike.Description = ""
objRailroadSpike.AltText = ""
objRailroadSpike.Resources = {
	{
		Type = "JPG", 
		Filename = "Railroadspike.JPG", 
		Directives = {}
	}
}
objSpikearea = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objSpikearea.Id = "9512dbac-367b-4d39-aeb7-22eac0c30861"
objSpikearea.Name = _IqY("\054\043\027\049\045\026\016\116\045\016")
objSpikearea.Description = ""
objSpikearea.AltText = ""
objSpikearea.Resources = {
	{
		Type = "JPG", 
		Filename = "Spikeview.JPG", 
		Directives = {}
	}
}
objCritter = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objCritter.Id = "7568b9e0-859a-49c7-97ae-7c97a07185fe"
objCritter.Name = _IqY("\036\116\027\076\076\045\116")
objCritter.Description = ""
objCritter.AltText = ""
objCritter.Resources = {
	{
		Type = "JPG", 
		Filename = "ImportantCritters.JPG", 
		Directives = {}
	}
}
objRuins = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objRuins.Id = "597f6089-ef2e-4fec-94d4-9bf211749331"
objRuins.Name = _IqY("\074\048\027\004\024")
objRuins.Description = ""
objRuins.AltText = ""
objRuins.Resources = {
	{
		Type = "JPG", 
		Filename = "Ruins.JPG", 
		Directives = {}
	}
}
objCrossing = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objCrossing.Id = "88a71ae8-bef7-45a2-81d8-88b9d948d48d"
objCrossing.Name = _IqY("\036\116\050\024\024\027\004\046")
objCrossing.Description = ""
objCrossing.AltText = ""
objCrossing.Resources = {
	{
		Type = "JPG", 
		Filename = "Crossing.JPG", 
		Directives = {}
	}
}
objCanalLife = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objCanalLife.Id = "4436d33e-65a6-4928-b59a-7f6b368820b5"
objCanalLife.Name = _IqY("\036\016\004\016\082\026\002\027\114\045")
objCanalLife.Description = ""
objCanalLife.AltText = ""
objCanalLife.Resources = {
	{
		Type = "JPG", 
		Filename = "CanelLife.JPG", 
		Directives = {}
	}
}
objCable = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objCable.Id = "cbd48c96-ec57-4d3e-9688-a140974a81a5"
objCable.Name = _IqY("\036\016\096\082\045")
objCable.Description = ""
objCable.AltText = ""
objCable.Resources = {
	{
		Type = "JPG", 
		Filename = "cable.JPG", 
		Directives = {}
	}
}
objTrain = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objTrain.Id = "a4c38275-817e-42b8-a24a-4806304fffb7"
objTrain.Name = _IqY("\105\116\016\027\004")
objTrain.Description = ""
objTrain.AltText = ""
objTrain.Resources = {
	{
		Type = "JPG", 
		Filename = "Train.JPG", 
		Directives = {}
	}
}
objOldThings = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objOldThings.Id = "93bcefb3-9f5b-40f0-a592-50e2d7e391a0"
objOldThings.Name = _IqY("\013\082\040\026\105\011\027\004\046\024")
objOldThings.Description = ""
objOldThings.AltText = ""
objOldThings.Resources = {
	{
		Type = "JPG", 
		Filename = "OldThings.JPG", 
		Directives = {}
	}
}
objFurnanceHill = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objFurnanceHill.Id = "31ec69fa-2651-4d31-9fc3-4b8e1f5ad9f4"
objFurnanceHill.Name = _IqY("\047\048\116\004\016\004\053\045\026\125\027\082\082")
objFurnanceHill.Description = ""
objFurnanceHill.AltText = ""
objFurnanceHill.Resources = {
	{
		Type = "JPG", 
		Filename = "FurnanceHill.JPG", 
		Directives = {}
	}
}
objTroxellSteckelHouse = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objTroxellSteckelHouse.Id = "c64957fc-7171-4e9a-a34c-3d669c79b237"
objTroxellSteckelHouse.Name = _IqY("\105\116\050\064\045\082\082\085\054\076\045\053\049\045\082\026\125\050\048\024\045")
objTroxellSteckelHouse.Description = ""
objTroxellSteckelHouse.AltText = ""
objTroxellSteckelHouse.Resources = {
	{
		Type = "JPG", 
		Filename = "TroxellSteckelHouse.JPG", 
		Directives = {}
	}
}
objCoveredBridge = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objCoveredBridge.Id = "13fc2742-847c-448a-8ce4-ccbb4f27c734"
objCoveredBridge.Name = _IqY("\036\050\069\045\116\045\040\026\089\116\027\040\046\045")
objCoveredBridge.Description = ""
objCoveredBridge.AltText = ""
objCoveredBridge.Resources = {
	{
		Type = "JPG", 
		Filename = "CoveredBridge.JPG", 
		Directives = {}
	}
}
objCementKlin = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objCementKlin.Id = "ebfecb9c-59f4-4dc1-89d1-922d2e5989bf"
objCementKlin.Name = _IqY("\036\045\110\045\004\076\026\005\082\027\004")
objCementKlin.Description = ""
objCementKlin.AltText = ""
objCementKlin.Resources = {
	{
		Type = "JPG", 
		Filename = "CementKilne.JPG", 
		Directives = {}
	}
}
objEaston = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objEaston.Id = "5f34bb5a-23e6-49b1-8cfd-90408b919e69"
objEaston.Name = _IqY("\037\016\024\076\050\004")
objEaston.Description = ""
objEaston.AltText = ""
objEaston.Resources = {
	{
		Type = "JPG", 
		Filename = "Easton.JPG", 
		Directives = {}
	}
}
objGeorgeTaylorHouse = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objGeorgeTaylorHouse.Id = "bb605b69-2f89-4726-b7e7-d82ae406909c"
objGeorgeTaylorHouse.Name = _IqY("\108\045\050\116\046\045\026\105\016\039\082\050\116\026\125\050\048\024\045")
objGeorgeTaylorHouse.Description = ""
objGeorgeTaylorHouse.AltText = ""
objGeorgeTaylorHouse.Resources = {
	{
		Type = "JPG", 
		Filename = "GeorgeTaylorHouse.JPG", 
		Directives = {}
	}
}
objBoatView = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objBoatView.Id = "e9e28bcf-89a9-4463-88fe-fd80f1355c8e"
objBoatView.Name = _IqY("\089\050\016\076\026\072\027\045\063")
objBoatView.Description = ""
objBoatView.AltText = ""
objBoatView.Resources = {
	{
		Type = "JPG", 
		Filename = "BoatView.JPG", 
		Directives = {}
	}
}
objBoatAction = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objBoatAction.Id = "099d6a00-4a2a-41ed-bc50-122f4efb6e56"
objBoatAction.Name = _IqY("\089\050\016\076\026\001\053\076\027\050\004")
objBoatAction.Description = ""
objBoatAction.AltText = ""
objBoatAction.Resources = {
	{
		Type = "JPG", 
		Filename = "BoatAction.JPG", 
		Directives = {}
	}
}
objNewHopeLock = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objNewHopeLock.Id = "96bf9f15-cec0-4143-8b48-6cc9528e896e"
objNewHopeLock.Name = _IqY("\109\045\063\026\125\050\043\045\026\002\050\053\049")
objNewHopeLock.Description = ""
objNewHopeLock.AltText = ""
objNewHopeLock.Resources = {
	{
		Type = "JPG", 
		Filename = "NewHopeLockHouse.JPG", 
		Directives = {}
	}
}
objLock2 = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objLock2.Id = "307c7c59-600c-4761-8059-f91aa2784da2"
objLock2.Name = _IqY("\002\050\053\049\026\007")
objLock2.Description = ""
objLock2.AltText = ""
objLock2.Resources = {
	{
		Type = "JPG", 
		Filename = "LockHouse2.JPG", 
		Directives = {}
	}
}
objThreetransportmodes = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objThreetransportmodes.Id = "45b790dd-ba84-4b1c-9e4a-2ccf8743a2b8"
objThreetransportmodes.Name = _IqY("\105\011\116\045\045\026\076\116\016\004\024\043\050\116\076\026\110\050\040\045\024")
objThreetransportmodes.Description = ""
objThreetransportmodes.AltText = ""
objThreetransportmodes.Resources = {
	{
		Type = "JPG", 
		Filename = "Transport.JPG", 
		Directives = {}
	}
}
objBidgeView2 = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objBidgeView2.Id = "af5af104-fd1d-44dc-978a-534a147ac180"
objBidgeView2.Name = _IqY("\089\027\040\046\045\026\072\027\045\063\026\007")
objBidgeView2.Description = ""
objBidgeView2.AltText = ""
objBidgeView2.Resources = {
	{
		Type = "JPG", 
		Filename = "ChainBridge2.JPG", 
		Directives = {}
	}
}
objChainView = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objChainView.Id = "bb8834c6-518d-4f4b-9626-080eb1b673f5"
objChainView.Name = _IqY("\036\011\016\027\004\026\072\027\045\063")
objChainView.Description = ""
objChainView.AltText = ""
objChainView.Resources = {
	{
		Type = "JPG", 
		Filename = "Chainview.JPG", 
		Directives = {}
	}
}
objBridgeView1 = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objBridgeView1.Id = "27f76691-c00e-4593-8727-6f8a2e019433"
objBridgeView1.Name = _IqY("\089\116\027\040\046\045\026\072\027\045\063\026\093")
objBridgeView1.Description = ""
objBridgeView1.AltText = ""
objBridgeView1.Resources = {
	{
		Type = "JPG", 
		Filename = "ChainBridge1.JPG", 
		Directives = {}
	}
}
objTrolley = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objTrolley.Id = "a3a8a7dd-c575-4893-ac02-c6cf79bd307c"
objTrolley.Name = _IqY("\105\116\050\082\082\045\039")
objTrolley.Description = ""
objTrolley.AltText = ""
objTrolley.Resources = {
	{
		Type = "JPG", 
		Filename = "Trolly.JPG", 
		Directives = {}
	}
}
objFullCircle = Wherigo.ZMedia(objLehighCanalattheLVGGPWherigoTour)
objFullCircle.Id = "5740604a-5931-4d46-aff1-8a2a47933cfc"
objFullCircle.Name = _IqY("\047\048\082\082\026\036\027\116\053\082\045")
objFullCircle.Description = ""
objFullCircle.AltText = ""
objFullCircle.Resources = {
	{
		Type = "JPG", 
		Filename = "FullCircle1.JPG", 
		Directives = {}
	}
}
-- Cartridge Info --
objLehighCanalattheLVGGPWherigoTour.Id="630e5643-1253-43e1-a49e-1b597def6894"
objLehighCanalattheLVGGPWherigoTour.Name="Lehigh Canal at the LVGGP Wherigo Tour"
objLehighCanalattheLVGGPWherigoTour.Description=[[This wherigo is a part of the Lehigh Valley Geocacher?s GeoPark.  It is designed to take you on an educational tour of the Lehigh Valley Canal area.  Be sure to read the question carefully or face some additional challenges. Completing this Wherigo can help you in completing the "One Busy Day" Challenge. At each zone you will need to answer questions in order to unlock the next zone. There is nothing too hard on this one but if you mess up the game may make you pay.  Please be sure to park in a legal and safe spot and be aware of traffic and your surroundings! This cartridge is related to geocache # GC3BARN and will lead you to a micro size container just off the trail in the woods!]]
objLehighCanalattheLVGGPWherigoTour.Visible=true
objLehighCanalattheLVGGPWherigoTour.Activity="Geocache"
objLehighCanalattheLVGGPWherigoTour.StartingLocationDescription=[[]]
objLehighCanalattheLVGGPWherigoTour.StartingLocation = ZonePoint(40.6687992175052,-75.2365024973551,0)
objLehighCanalattheLVGGPWherigoTour.Version="1-31-12"
objLehighCanalattheLVGGPWherigoTour.Company=""
objLehighCanalattheLVGGPWherigoTour.Author="agility3d"
objLehighCanalattheLVGGPWherigoTour.BuilderVersion="URWIGO 1.12.4281.38707"
objLehighCanalattheLVGGPWherigoTour.CreateDate="01/08/2012 22:20:53"
objLehighCanalattheLVGGPWherigoTour.PublishDate="1/1/0001 12:00:00 AM"
objLehighCanalattheLVGGPWherigoTour.UpdateDate="02/01/2012 01:59:37"
objLehighCanalattheLVGGPWherigoTour.LastPlayedDate="1/1/0001 12:00:00 AM"
objLehighCanalattheLVGGPWherigoTour.TargetDevice="PocketPC"
objLehighCanalattheLVGGPWherigoTour.TargetDeviceVersion="0"
objLehighCanalattheLVGGPWherigoTour.StateId="1"
objLehighCanalattheLVGGPWherigoTour.CountryId="2"
objLehighCanalattheLVGGPWherigoTour.Complete=false
objLehighCanalattheLVGGPWherigoTour.UseLogging=true


-- Zones --
objZone1InformationSign = Wherigo.Zone(objLehighCanalattheLVGGPWherigoTour)
objZone1InformationSign.Id = "85b0030c-7bf8-4e87-80b2-639de766a6c1"
objZone1InformationSign.Name = _IqY("\086\050\004\045\026\093\026\056\004\114\050\116\110\016\076\027\050\004\026\054\027\046\004")
objZone1InformationSign.Description = ""
objZone1InformationSign.Visible = true
objZone1InformationSign.Media = objFurnance
objZone1InformationSign.Commands = {}
objZone1InformationSign.DistanceRange = Distance(-1, "feet")
objZone1InformationSign.ShowObjects = "OnEnter"
objZone1InformationSign.ProximityRange = Distance(60, "meters")
objZone1InformationSign.AllowSetPositionTo = false
objZone1InformationSign.Active = false
objZone1InformationSign.Points = {
	ZonePoint(40.6688419404568, -75.2363724102179, 0), 
	ZonePoint(40.6688688965906, -75.2365058501164, 0), 
	ZonePoint(40.6687325899906, -75.2365648587148, 0), 
	ZonePoint(40.6686857981084, -75.2363730807702, 0), 
	ZonePoint(40.6688170187384, -75.2362939556043, 0)
}
objZone1InformationSign.OriginalPoint = ZonePoint(40.668789248777, -75.2364220310847, 0)
objZone1InformationSign.DistanceRangeUOM = "Feet"
objZone1InformationSign.ProximityRangeUOM = "Meters"
objZone1InformationSign.OutOfRangeName = ""
objZone1InformationSign.InRangeName = ""
objZone2Earthcachestrangestone = Wherigo.Zone(objLehighCanalattheLVGGPWherigoTour)
objZone2Earthcachestrangestone.Id = "09783cc8-1de5-4f50-ac0f-2a7e2a36917c"
objZone2Earthcachestrangestone.Name = _IqY("\086\050\004\045\026\007\026\037\016\116\076\011\053\016\053\011\045\026\024\076\116\016\004\046\045\026\024\076\050\004\045")
objZone2Earthcachestrangestone.Description = ""
objZone2Earthcachestrangestone.Visible = true
objZone2Earthcachestrangestone.Media = objEarthcache
objZone2Earthcachestrangestone.Commands = {}
objZone2Earthcachestrangestone.DistanceRange = Distance(-1, "feet")
objZone2Earthcachestrangestone.ShowObjects = "OnEnter"
objZone2Earthcachestrangestone.ProximityRange = Distance(60, "meters")
objZone2Earthcachestrangestone.AllowSetPositionTo = false
objZone2Earthcachestrangestone.Active = false
objZone2Earthcachestrangestone.Points = {
	ZonePoint(40.6684975743876, -75.2365406216939, 0), 
	ZonePoint(40.668572339873, -75.2364903302749, 0), 
	ZonePoint(40.6685367372714, -75.2363535376151, 0), 
	ZonePoint(40.6684156882837, -75.2363884063323, 0), 
	ZonePoint(40.6684309465715, -75.2365453155597, 0)
}
objZone2Earthcachestrangestone.OriginalPoint = ZonePoint(40.6684906572774, -75.2364636422952, 0)
objZone2Earthcachestrangestone.DistanceRangeUOM = "Feet"
objZone2Earthcachestrangestone.ProximityRangeUOM = "Meters"
objZone2Earthcachestrangestone.OutOfRangeName = ""
objZone2Earthcachestrangestone.InRangeName = ""
objZone3EdgeofParking = Wherigo.Zone(objLehighCanalattheLVGGPWherigoTour)
objZone3EdgeofParking.Id = "9257a752-7511-4ec5-acf4-e5918ca0f019"
objZone3EdgeofParking.Name = _IqY("\086\050\004\045\026\126\026\037\040\046\045\026\050\114\026\025\016\116\049\027\004\046\026")
objZone3EdgeofParking.Description = ""
objZone3EdgeofParking.Visible = true
objZone3EdgeofParking.Media = objKeystoneFurnance
objZone3EdgeofParking.Commands = {}
objZone3EdgeofParking.DistanceRange = Distance(-1, "feet")
objZone3EdgeofParking.ShowObjects = "OnEnter"
objZone3EdgeofParking.ProximityRange = Distance(57, "meters")
objZone3EdgeofParking.AllowSetPositionTo = false
objZone3EdgeofParking.Active = false
objZone3EdgeofParking.Points = {
	ZonePoint(40.6637821291797, -75.2381746255795, 0), 
	ZonePoint(40.6637282127888, -75.2379520022313, 0), 
	ZonePoint(40.6635735844073, -75.2380029642026, 0), 
	ZonePoint(40.6636315700923, -75.2382416808049, 0)
}
objZone3EdgeofParking.OriginalPoint = ZonePoint(40.663678874117, -75.2380928182046, 0)
objZone3EdgeofParking.DistanceRangeUOM = "Feet"
objZone3EdgeofParking.ProximityRangeUOM = "Meters"
objZone3EdgeofParking.OutOfRangeName = ""
objZone3EdgeofParking.InRangeName = ""
objZone4Historicsign = Wherigo.Zone(objLehighCanalattheLVGGPWherigoTour)
objZone4Historicsign.Id = "0130ffa4-257a-41f2-be79-41567d76ec71"
objZone4Historicsign.Name = _IqY("\086\050\004\045\026\034\026\125\027\024\076\050\116\027\053\026\024\027\046\004")
objZone4Historicsign.Description = ""
objZone4Historicsign.Visible = true
objZone4Historicsign.Media = objGlendonFurnance3
objZone4Historicsign.Commands = {}
objZone4Historicsign.DistanceRange = Distance(-1, "feet")
objZone4Historicsign.ShowObjects = "OnEnter"
objZone4Historicsign.ProximityRange = Distance(62, "meters")
objZone4Historicsign.AllowSetPositionTo = false
objZone4Historicsign.Active = false
objZone4Historicsign.Points = {
	ZonePoint(40.6626379112169, -75.238610456268, 0), 
	ZonePoint(40.6625605958071, -75.2385058501164, 0), 
	ZonePoint(40.6625046438099, -75.2384455004136, 0), 
	ZonePoint(40.6626714823538, -75.238248358051, 0), 
	ZonePoint(40.6627233649866, -75.2383207776944, 0), 
	ZonePoint(40.662786437937, -75.238422701637, 0)
}
objZone4Historicsign.OriginalPoint = ZonePoint(40.6626474060186, -75.2384256073634, 0)
objZone4Historicsign.DistanceRangeUOM = "Feet"
objZone4Historicsign.ProximityRangeUOM = "Meters"
objZone4Historicsign.OutOfRangeName = ""
objZone4Historicsign.InRangeName = ""
objZone5RailRoadSpike = Wherigo.Zone(objLehighCanalattheLVGGPWherigoTour)
objZone5RailRoadSpike.Id = "992f4d75-2b2f-49be-8164-6ada62347fb3"
objZone5RailRoadSpike.Name = _IqY("\086\050\004\045\026\003\026\074\016\027\082\026\074\050\016\040\026\054\043\027\049\045")
objZone5RailRoadSpike.Description = ""
objZone5RailRoadSpike.Visible = true
objZone5RailRoadSpike.Media = objLucyFurnance
objZone5RailRoadSpike.Commands = {}
objZone5RailRoadSpike.DistanceRange = Distance(-1, "feet")
objZone5RailRoadSpike.ShowObjects = "OnEnter"
objZone5RailRoadSpike.ProximityRange = Distance(60, "meters")
objZone5RailRoadSpike.AllowSetPositionTo = false
objZone5RailRoadSpike.Active = false
objZone5RailRoadSpike.Points = {
	ZonePoint(40.661131625102, -75.240188503472, 0), 
	ZonePoint(40.6609647827065, -75.2399685623328, 0), 
	ZonePoint(40.6608050612417, -75.2401898445765, 0), 
	ZonePoint(40.6609810600317, -75.2404164912384, 0)
}
objZone5RailRoadSpike.OriginalPoint = ZonePoint(40.6609706322705, -75.2401908504049, 0)
objZone5RailRoadSpike.DistanceRangeUOM = "Feet"
objZone5RailRoadSpike.ProximityRangeUOM = "Meters"
objZone5RailRoadSpike.OutOfRangeName = ""
objZone5RailRoadSpike.InRangeName = ""
objZone6LockTender = Wherigo.Zone(objLehighCanalattheLVGGPWherigoTour)
objZone6LockTender.Id = "c2573682-f177-4a76-a598-5300769b2553"
objZone6LockTender.Name = _IqY("\086\050\004\045\026\066\026\002\050\053\049\026\105\045\004\040\045\116")
objZone6LockTender.Description = ""
objZone6LockTender.Visible = true
objZone6LockTender.Media = objLockTender
objZone6LockTender.Commands = {}
objZone6LockTender.DistanceRange = Distance(-1, "feet")
objZone6LockTender.ShowObjects = "OnEnter"
objZone6LockTender.ProximityRange = Distance(60, "meters")
objZone6LockTender.AllowSetPositionTo = false
objZone6LockTender.Active = false
objZone6LockTender.Points = {
	ZonePoint(40.6579168864831, -75.2440346461614, 0), 
	ZonePoint(40.6576086198019, -75.2437181454977, 0), 
	ZonePoint(40.6572515170143, -75.2440949958643, 0), 
	ZonePoint(40.6574956900672, -75.2443994265875, 0), 
	ZonePoint(40.6576055676494, -75.2445429247697, 0)
}
objZone6LockTender.OriginalPoint = ZonePoint(40.6575756562032, -75.2441580277761, 0)
objZone6LockTender.DistanceRangeUOM = "Feet"
objZone6LockTender.ProximityRangeUOM = "Meters"
objZone6LockTender.OutOfRangeName = ""
objZone6LockTender.InRangeName = ""
objZone7FullCircle = Wherigo.Zone(objLehighCanalattheLVGGPWherigoTour)
objZone7FullCircle.Id = "ed87d553-8edb-4a4b-802d-5e95f1c2b6c9"
objZone7FullCircle.Name = _IqY("\086\050\004\045\026\070\026\047\048\082\082\026\036\027\116\053\082\045")
objZone7FullCircle.Description = ""
objZone7FullCircle.Visible = true
objZone7FullCircle.Media = objFullCircle
objZone7FullCircle.Commands = {}
objZone7FullCircle.DistanceRange = Distance(-1, "feet")
objZone7FullCircle.ShowObjects = "OnEnter"
objZone7FullCircle.ProximityRange = Distance(60, "meters")
objZone7FullCircle.AllowSetPositionTo = false
objZone7FullCircle.Active = false
objZone7FullCircle.Points = {
	ZonePoint(40.6570147796341, -75.2450800965627, 0), 
	ZonePoint(40.6572991404254, -75.2448836247524, 0), 
	ZonePoint(40.6571312710529, -75.2445429842074, 0), 
	ZonePoint(40.6568657313648, -75.2447428087791, 0)
}
objZone7FullCircle.OriginalPoint = ZonePoint(40.6570777306193, -75.2448123785754, 0)
objZone7FullCircle.DistanceRangeUOM = "Feet"
objZone7FullCircle.ProximityRangeUOM = "Meters"
objZone7FullCircle.OutOfRangeName = ""
objZone7FullCircle.InRangeName = ""
objZoneFinalGZ = Wherigo.Zone(objLehighCanalattheLVGGPWherigoTour)
objZoneFinalGZ.Id = "722d6ce3-0ecf-49bb-aabb-b6a4a365c98b"
objZoneFinalGZ.Name = _IqY("\086\050\004\045\026\047\027\004\016\082\026\108\086")
objZoneFinalGZ.Description = ""
objZoneFinalGZ.Visible = true
objZoneFinalGZ.Media = objFinalGZ
objZoneFinalGZ.Commands = {}
objZoneFinalGZ.DistanceRange = Distance(-1, "feet")
objZoneFinalGZ.ShowObjects = "OnEnter"
objZoneFinalGZ.ProximityRange = Distance(57, "meters")
objZoneFinalGZ.AllowSetPositionTo = false
objZoneFinalGZ.Active = false
objZoneFinalGZ.Points = {
	ZonePoint(40.6613556828378, -75.2405682991902, 0), 
	ZonePoint(40.6612549673897, -75.2403108071248, 0), 
	ZonePoint(40.6610728653349, -75.2404569875162, 0), 
	ZonePoint(40.6611593384396, -75.2407211851041, 0)
}
objZoneFinalGZ.OriginalPoint = ZonePoint(40.6612107135005, -75.2405143197338, 0)
objZoneFinalGZ.DistanceRangeUOM = "Feet"
objZoneFinalGZ.ProximityRangeUOM = "Meters"
objZoneFinalGZ.OutOfRangeName = ""
objZoneFinalGZ.InRangeName = ""
objZone1Penalty = Wherigo.Zone(objLehighCanalattheLVGGPWherigoTour)
objZone1Penalty.Id = "f6ff5cb5-5490-4350-a7d8-361eb93beccf"
objZone1Penalty.Name = _IqY("\086\050\004\045\026\093\026\025\045\004\016\082\076\039")
objZone1Penalty.Description = ""
objZone1Penalty.Visible = true
objZone1Penalty.Media = objDemolitionOfGlendonFurnance
objZone1Penalty.Commands = {}
objZone1Penalty.DistanceRange = Distance(-1, "feet")
objZone1Penalty.ShowObjects = "OnEnter"
objZone1Penalty.ProximityRange = Distance(60, "meters")
objZone1Penalty.AllowSetPositionTo = false
objZone1Penalty.Active = false
objZone1Penalty.Points = {
	ZonePoint(40.6688419404568, -75.2363724102179, 0), 
	ZonePoint(40.6688688965906, -75.2365058501164, 0), 
	ZonePoint(40.6687325899906, -75.2365648587148, 0), 
	ZonePoint(40.6686857981084, -75.2363730807702, 0), 
	ZonePoint(40.6688170187384, -75.2362939556043, 0)
}
objZone1Penalty.OriginalPoint = ZonePoint(40.668789248777, -75.2364220310847, 0)
objZone1Penalty.DistanceRangeUOM = "Feet"
objZone1Penalty.ProximityRangeUOM = "Meters"
objZone1Penalty.OutOfRangeName = ""
objZone1Penalty.InRangeName = ""
objZone2Repeated = Wherigo.Zone(objLehighCanalattheLVGGPWherigoTour)
objZone2Repeated.Id = "936057da-a428-4f0d-a995-c3c526034dd6"
objZone2Repeated.Name = _IqY("\086\050\004\045\026\007\026\074\045\043\045\016\076\045\040")
objZone2Repeated.Description = ""
objZone2Repeated.Visible = true
objZone2Repeated.Media = objEarthcache
objZone2Repeated.Commands = {}
objZone2Repeated.DistanceRange = Distance(-1, "feet")
objZone2Repeated.ShowObjects = "OnEnter"
objZone2Repeated.ProximityRange = Distance(60, "meters")
objZone2Repeated.AllowSetPositionTo = false
objZone2Repeated.Active = false
objZone2Repeated.Points = {
	ZonePoint(40.6685926842082, -75.2365292223056, 0), 
	ZonePoint(40.6685448750106, -75.2363226922114, 0), 
	ZonePoint(40.6683617756386, -75.2363817008098, 0), 
	ZonePoint(40.6684177227222, -75.2366056652625, 0), 
	ZonePoint(40.6685097810033, -75.2366056652625, 0)
}
objZone2Repeated.OriginalPoint = ZonePoint(40.6684853677166, -75.2364889891704, 0)
objZone2Repeated.DistanceRangeUOM = "Feet"
objZone2Repeated.ProximityRangeUOM = "Meters"
objZone2Repeated.OutOfRangeName = ""
objZone2Repeated.InRangeName = ""

-- Characters --

-- Items --

-- Tasks --

-- Cartridge Variables --
objanswer = ""
objLehighCanalattheLVGGPWherigoTour.ZVariables = {
	objanswer = ""
}

-- Timers --
objName = Wherigo.ZTimer(objLehighCanalattheLVGGPWherigoTour)
objName.Id = "126f3cb3-8a43-4622-8556-b3c3d825ca63"
objName.Name = _IqY("\109\016\110\045")
objName.Description = ""
objName.Visible = true
objName.Duration = 60.4138986647194
objName.Type = "Countdown"

-- Inputs --
objZone11 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone11.Id = "2e7197e5-eccb-47df-bf0d-6c7af1ac75f8"
objZone11.Name = _IqY("\086\050\004\045\026\093\085\093")
objZone11.Description = ""
objZone11.Visible = true
objZone11.Media = objDavidThomas
objZone11.Choices = {
	"A: Thomas Hughes", 
	"B: Josiah White", 
	"C: David Thomas", 
	"D: Erskine Hazard"
}
objZone11.InputType = "MultipleChoice"
objZone11.Text = _IqY("\062\011\050\026\027\024\026\076\011\045\026\114\016\076\011\045\116\026\050\114\026\076\011\045\026\110\050\040\045\116\004\026\001\110\045\116\027\053\016\004\026\056\116\050\004\026\056\004\040\048\024\076\116\039\106\021\089\074\055")
objZone12 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone12.Id = "60d3d4f2-ef8a-453c-b4cb-17c0ca7e45c8"
objZone12.Name = _IqY("\086\050\004\045\026\093\085\007")
objZone12.Description = ""
objZone12.Visible = true
objZone12.Media = objFurnance
objZone12.Choices = {
	"A: 38", 
	"B: 55", 
	"C: 63", 
	"D: 87"
}
objZone12.InputType = "MultipleChoice"
objZone12.Text = _IqY("\056\004\026\093\029\070\099\026\011\050\063\026\110\016\004\039\026\096\082\016\024\076\026\114\048\116\004\016\053\045\024\026\063\045\116\045\026\050\043\045\116\016\076\027\004\046\026\009\004\096\024\043\094\016\076\026\076\011\045\026\007\093\026\082\050\053\016\076\027\050\004\024\026\004\045\016\116\026\076\011\045\026\002\045\011\027\046\011\026\036\016\004\016\082\106")
objZone13 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone13.Id = "cd671958-90aa-449e-bfaf-d51d4433e327"
objZone13.Name = _IqY("\086\050\004\045\026\093\085\126")
objZone13.Description = ""
objZone13.Visible = true
objZone13.Media = objIronPlant
objZone13.Choices = {
	"A: August 12, 1832", 
	"B: February 23, 1837", 
	"C: October 31, 1839", 
	"D: July 4th, 1840"
}
objZone13.InputType = "MultipleChoice"
objZone13.Text = _IqY("\062\011\016\076\026\040\016\076\045\026\040\027\040\026\076\011\045\026\036\116\016\004\045\026\056\116\050\004\026\036\050\110\043\016\004\039\026\096\045\046\027\004\026\076\050\026\043\116\050\040\048\053\045\026\027\116\050\004\106")
objZone14 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone14.Id = "74e9c004-0503-4d05-9bc3-60c152c3cde9"
objZone14.Name = _IqY("\086\050\004\045\026\093\085\034")
objZone14.Description = ""
objZone14.Visible = true
objZone14.Media = objHughMoore
objZone14.Choices = {
	"A: Dixie Cup Company", 
	"B: Bethlehem Steel Company", 
	"C: Lehigh Coal and Navigation Company", 
	"D: The city of Easton"
}
objZone14.InputType = "MultipleChoice"
objZone14.Text = _IqY("\125\048\046\011\026\051\050\050\116\045\026\063\016\024\026\076\011\045\026\114\050\048\004\040\045\116\026\050\114\026\063\011\016\076\106\021\089\074\055")
objZone15 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone15.Id = "25c05b9f-4ba8-4544-a369-60291a654c02"
objZone15.Name = _IqY("\086\050\004\045\026\093\085\003")
objZone15.Description = ""
objZone15.Visible = true
objZone15.Media = objLockTender
objZone15.Choices = {
	"True", 
	"False"
}
objZone15.InputType = "MultipleChoice"
objZone15.Text = _IqY("\125\048\046\011\026\051\050\050\116\045\026\024\050\082\040\026\076\011\045\026\036\016\004\045\082\026\043\116\050\043\045\116\076\039\026\076\050\026\076\011\045\026\105\050\063\004\024\011\027\043\106")
objZone21 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone21.Id = "e10f4b75-51af-47d3-9b8e-f98cb8ea6afb"
objZone21.Name = _IqY("\086\050\004\045\026\007\085\093")
objZone21.Description = ""
objZone21.Visible = true
objZone21.Media = objDemolitionOfGlendonFurnance
objZone21.Choices = {
	"A: same size", 
	"B: 3/4's the size", 
	"C: less than 1/2 the size", 
	"D: There is only one rock here."
}
objZone21.InputType = "MultipleChoice"
objZone21.Text = _IqY("\001\096\050\048\076\026\011\050\063\026\096\027\046\026\027\024\026\076\011\045\026\024\045\053\050\004\040\026\116\050\053\049\026\114\116\050\110\026\076\011\045\026\046\116\050\048\004\040\026\053\050\110\043\016\116\045\040\026\076\050\026\076\011\045\026\114\027\116\024\076\106")
objZone11APenaltyQuestion = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone11APenaltyQuestion.Id = "1c2d1df5-b551-409f-a08d-d79404cdb7c6"
objZone11APenaltyQuestion.Name = _IqY("\086\050\004\045\026\093\085\093\001\026\025\045\004\016\082\076\039\026\115\048\045\024\076\027\050\004")
objZone11APenaltyQuestion.Description = ""
objZone11APenaltyQuestion.Visible = true
objZone11APenaltyQuestion.Media = objKeystoneFurnance
objZone11APenaltyQuestion.InputType = "Text"
objZone11APenaltyQuestion.Text = _IqY("\062\011\016\076\026\039\045\016\116\026\063\016\024\026\076\011\045\026\005\045\039\024\076\050\004\045\026\047\048\116\004\016\004\053\045\026\045\024\076\016\096\082\027\024\011\045\040\106")
objZone21Repeat = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone21Repeat.Id = "f80c9983-ff48-482b-9849-7e7e7723fa9e"
objZone21Repeat.Name = _IqY("\086\050\004\045\026\007\085\093\026\074\045\043\045\016\076")
objZone21Repeat.Description = ""
objZone21Repeat.Visible = true
objZone21Repeat.Media = objDemolitionOfGlendonFurnance
objZone21Repeat.Choices = {
	"A: same size", 
	"B: 3/4's the size", 
	"C: less than 1/2 the size", 
	"D: There is only one rock here."
}
objZone21Repeat.InputType = "MultipleChoice"
objZone21Repeat.Text = _IqY("\001\096\050\048\076\026\011\050\063\026\096\027\046\026\027\024\026\076\011\045\026\024\045\053\050\004\040\026\116\050\053\049\026\114\116\050\110\026\076\011\045\026\046\116\050\048\004\040\026\053\050\110\043\016\116\045\040\026\076\050\026\076\011\045\026\114\027\116\024\076\106")
objZone31 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone31.Id = "80fc0784-9803-4f23-bb1e-cf329e7919e2"
objZone31.Name = _IqY("\086\050\004\045\026\126\085\093")
objZone31.Description = ""
objZone31.Visible = true
objZone31.Media = objCanalLife
objZone31.Choices = {
	"A: Heritage", 
	"B: Enconomy", 
	"C: Development"
}
objZone31.InputType = "MultipleChoice"
objZone31.Text = _IqY("\123\013\048\116\026\116\045\024\027\040\045\004\076\024\026\076\016\049\045\026\043\116\027\040\045\026\016\004\040\026\043\016\116\076\004\045\116\026\027\004\026\076\011\045\027\116\106\123")
objZone32 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone32.Id = "f74e20dc-ea17-47d6-8406-de18382a1c6c"
objZone32.Name = _IqY("\086\050\004\045\026\126\085\007")
objZone32.Description = ""
objZone32.Visible = true
objZone32.Media = objCritter
objZone32.Choices = {
	"A: Gave kids rides", 
	"B: Towed the Canal Boats", 
	"C: Closed the locks"
}
objZone32.InputType = "MultipleChoice"
objZone32.Text = _IqY("\001\053\053\050\116\040\027\004\046\026\076\050\026\076\011\045\026\024\027\046\004\026\110\048\082\045\024\026\043\048\082\082\045\040\026\076\011\045\026\110\027\004\045\026\053\016\116\024\075\026\114\016\116\110\045\040\026\076\011\045\026\082\016\004\040\026\016\004\040\026\063\011\016\076\026\050\076\011\045\116\026\027\110\043\050\116\076\016\004\076\026\114\048\004\053\076\027\050\004\106")
objZone31C = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone31C.Id = "8e91b6c8-dd49-4ab6-a4bf-d6c897d3e0a3"
objZone31C.Name = _IqY("\086\050\004\045\026\126\085\093\036")
objZone31C.Description = ""
objZone31C.Visible = true
objZone31C.Media = objOldThings
objZone31C.Choices = {
	"A: Ducth", 
	"B: Amish", 
	"C: Colonial", 
	"D: Mordern"
}
objZone31C.InputType = "MultipleChoice"
objZone31C.Text = _IqY("\001\053\053\050\116\040\027\004\046\026\076\050\026\076\011\045\026\024\027\046\004\026\063\011\016\076\026\049\027\004\040\026\050\114\026\047\016\116\110\024\076\045\016\040\024\026\063\027\082\082\026\039\050\048\026\114\027\004\040\026\027\004\026\089\048\053\049\024\026\036\050\048\004\076\039\106")
objZone31B = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone31B.Id = "f07bd8ae-9abc-4f56-bf69-af1c465264a8"
objZone31B.Name = _IqY("\086\050\004\045\026\126\085\093\089")
objZone31B.Description = ""
objZone31B.Visible = true
objZone31B.Media = objCrossing
objZone31B.Choices = {
	"A: Fishing", 
	"B: Lumber", 
	"C: Oil", 
	"D: Power"
}
objZone31B.InputType = "MultipleChoice"
objZone31B.Text = _IqY("\001\053\053\050\116\040\027\004\046\026\076\050\026\076\011\045\026\024\027\046\004\026\027\004\026\036\016\116\096\050\004\026\036\050\048\004\076\039\026\039\050\048\026\063\027\082\082\026\024\045\045\026\046\082\027\110\043\024\045\024\026\050\114\026\076\063\050\026\046\116\045\016\076\026\027\004\040\048\024\076\116\027\045\024\026\114\116\050\110\026\040\016\039\024\026\046\050\004\045\026\096\039\075\026\076\011\045\039\026\016\116\045\026\076\011\045\026\053\050\016\082\026\027\004\040\048\024\076\116\039\026\016\004\040\026\076\011\027\024\026\050\076\011\045\116\026\027\004\040\048\024\076\116\039\106")
objZone31A = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone31A.Id = "79928435-e9c7-4b72-958c-bfaa2b40361c"
objZone31A.Name = _IqY("\086\050\004\045\026\126\085\093\001")
objZone31A.Description = ""
objZone31A.Visible = true
objZone31A.Media = objFurnanceHill
objZone31A.Choices = {
	"A: 3", 
	"B: 4", 
	"C: 5", 
	"D: 6", 
	"E: 7"
}
objZone31A.InputType = "MultipleChoice"
objZone31A.Text = _IqY("\054\027\004\053\045\026\039\050\048\026\110\027\024\024\045\040\026\016\026\120\048\045\024\076\027\050\004\026\016\096\050\048\076\026\076\011\045\026\065\045\082\016\063\016\116\045\026\009\016\110\043\094\026\002\045\011\027\046\011\026\109\016\076\027\050\004\016\082\026\016\004\040\026\054\076\016\076\045\026\125\045\116\027\076\016\046\045\026\036\050\116\116\027\040\050\116\026\039\050\048\026\063\027\082\082\026\004\050\063\026\046\045\076\026\076\050\026\024\076\048\040\039\026\027\076\026\016\026\082\027\076\076\082\045\026\110\050\116\045\026\053\082\050\024\045\082\039\078\026\125\050\063\026\110\016\004\039\026\053\050\048\004\076\027\045\024\026\110\016\049\045\026\048\043\026\076\011\027\024\026\036\050\116\116\027\040\050\116\106")
objZone31D = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone31D.Id = "e50916a1-5d40-4fb2-85dd-0578ee75d850"
objZone31D.Name = _IqY("\086\050\004\045\026\126\085\093\065")
objZone31D.Description = ""
objZone31D.Visible = true
objZone31D.Media = objCanalLife
objZone31D.Choices = {
	"A: Heritage", 
	"B: Enconomy", 
	"C: Development"
}
objZone31D.InputType = "MultipleChoice"
objZone31D.Text = _IqY("\123\013\048\116\026\116\045\024\027\040\045\004\076\024\026\076\016\049\045\026\043\116\027\040\045\026\016\004\040\026\043\016\116\076\004\045\116\026\027\004\026\076\011\045\027\116\106\123")
objZone32A = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone32A.Id = "32021cc3-31d6-4208-848c-fcaacebb2946"
objZone32A.Name = _IqY("\086\050\004\045\026\126\085\007\001")
objZone32A.Description = ""
objZone32A.Visible = true
objZone32A.Media = objBoat
objZone32A.Choices = {
	"A: 1807", 
	"B: 1818", 
	"C: 1827", 
	"D: 1834"
}
objZone32A.InputType = "MultipleChoice"
objZone32A.Text = _IqY("\062\011\016\076\026\039\045\016\116\026\040\027\040\026\076\011\045\026\002\045\011\027\046\011\075\026\051\050\116\116\027\024\026\016\004\040\026\065\045\082\016\063\016\116\045\026\036\016\004\016\082\026\024\039\024\076\045\110\026\050\043\045\004\106")
objZone32B = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone32B.Id = "8a192311-6c5b-4b13-a858-865f04d5f945"
objZone32B.Name = _IqY("\086\050\004\045\026\126\085\007\089")
objZone32B.Description = ""
objZone32B.Visible = true
objZone32B.Media = objTrain
objZone32B.Choices = {
	"A: Easton Railroad", 
	"B: Lehigh Valley Ralroad", 
	"C: Indian Railroad", 
	"D: Canel Express Railroad"
}
objZone32B.InputType = "MultipleChoice"
objZone32B.Text = _IqY("\105\011\045\026\109\050\116\076\011\045\116\004\026\002\045\011\027\046\011\026\108\016\076\045\063\016\039\026\016\082\082\050\063\024\026\039\050\048\026\076\050\026\096\027\049\045\026\050\116\026\011\027\049\045\026\076\011\045\026\002\045\011\027\046\011\026\036\016\004\016\082\026\076\050\063\043\016\076\011\026\016\004\040\026\063\011\016\076\026\114\050\116\110\045\116\026\116\016\027\082\116\050\016\040\106")
objZone32C = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone32C.Id = "03f9f966-16c8-453d-b1e4-c2721b38fc3f"
objZone32C.Name = _IqY("\086\050\004\045\026\126\085\007\036")
objZone32C.Description = ""
objZone32C.Visible = true
objZone32C.Media = objTroxellSteckelHouse
objZone32C.Choices = {
	"A: 1748", 
	"B: 1751", 
	"C: 1756", 
	"D: 1773"
}
objZone32C.InputType = "MultipleChoice"
objZone32C.Text = _IqY("\062\011\016\076\026\039\045\016\116\026\063\016\024\026\076\011\045\026\105\116\050\064\045\082\082\085\054\076\045\053\049\045\082\026\125\050\048\024\045\026\096\048\027\082\076\106")
objZone32D = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone32D.Id = "ab5f2767-b4be-47bf-a1ca-16a5fcbcab05"
objZone32D.Name = _IqY("\086\050\004\045\026\126\085\007\065")
objZone32D.Description = ""
objZone32D.Visible = true
objZone32D.Media = objCritter
objZone32D.Choices = {
	"A: Gave kids rides", 
	"B: Towed the Canal Boats", 
	"C: Closed the locks"
}
objZone32D.InputType = "MultipleChoice"
objZone32D.Text = _IqY("\051\048\082\045\024\026\043\048\082\082\045\040\026\076\011\045\026\110\027\004\045\026\053\016\116\024\075\026\114\016\116\110\045\040\026\076\011\045\026\082\016\004\040\026\016\004\040\026\063\011\016\076\026\050\076\011\045\116\026\027\110\043\050\116\076\016\004\076\026\114\048\004\053\076\027\050\004\106")
objZone33 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone33.Id = "3d354cb3-096e-4817-8fb3-9b72360b42c3"
objZone33.Name = _IqY("\086\050\004\045\026\126\085\126")
objZone33.Description = ""
objZone33.Visible = true
objZone33.Media = objEaston
objZone33.Choices = {
	"A: Declaration of Independence", 
	"B: The first lady", 
	"C: Washingoton's Letters", 
	"D: The Liberty Bell"
}
objZone33.InputType = "MultipleChoice"
objZone33.Text = _IqY("\065\048\116\027\004\046\026\076\011\045\026\001\110\045\116\027\053\016\004\026\074\045\069\050\082\048\076\027\050\004\026\063\011\016\076\026\063\016\024\026\011\027\040\040\045\004\026\027\004\026\001\082\082\045\004\076\050\063\004\106")
objZone33A = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone33A.Id = "fca029b0-de1b-4806-8f4b-89d6bc22a6cc"
objZone33A.Name = _IqY("\086\050\004\045\026\126\085\126\001")
objZone33A.Description = ""
objZone33A.Visible = true
objZone33A.Media = objCoveredBridge
objZone33A.Choices = {
	"A: 7", 
	"B: 10", 
	"C: 13", 
	"D: 20"
}
objZone33A.InputType = "MultipleChoice"
objZone33A.Text = _IqY("\001\053\053\050\116\040\027\004\046\026\076\050\026\076\011\045\026\024\027\046\004\075\026\036\050\069\045\116\045\040\026\089\116\027\040\046\045\024\026\027\004\026\109\050\116\076\011\016\110\043\076\050\004\026\016\004\040\026\002\045\011\027\046\011\026\036\050\048\004\076\027\045\024\026\053\050\110\043\116\027\024\045\026\011\050\063\026\110\016\004\039\026\050\114\026\025\045\004\004\024\039\082\069\016\004\027\016\113\024\026\024\048\116\069\027\069\027\004\046\026\007\003\099\026\063\050\050\040\045\004\026\002\016\004\040\110\016\116\049\024\106")
objZone33B = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone33B.Id = "56591170-bbae-404b-8cfa-e1d0443af163"
objZone33B.Name = _IqY("\086\050\004\045\026\126\085\126\089")
objZone33B.Description = ""
objZone33B.Visible = true
objZone33B.Media = objGeorgeTaylorHouse
objZone33B.InputType = "Text"
objZone33B.Text = _IqY("\062\011\016\076\026\063\016\024\026\108\045\050\116\046\045\026\105\016\039\082\050\116\026\114\016\110\050\048\024\026\114\050\116\106")
objZone33D = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone33D.Id = "c656103b-c7f8-472c-9110-e299f8657bf7"
objZone33D.Name = _IqY("\086\050\004\045\026\126\085\126\065")
objZone33D.Description = ""
objZone33D.Visible = true
objZone33D.Media = objEaston
objZone33D.Choices = {
	"A: Declaration of Independence", 
	"B: The First lady", 
	"C: Washingoton's Letters", 
	"D: The Liberty Bell"
}
objZone33D.InputType = "MultipleChoice"
objZone33D.Text = _IqY("\065\048\116\027\004\046\026\076\011\045\026\001\110\045\116\027\053\016\004\026\074\045\069\050\082\048\076\027\050\004\026\063\011\016\076\026\063\016\024\026\011\027\040\040\045\004\026\027\004\026\001\082\082\045\004\076\050\063\004\106")
objZone33C = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone33C.Id = "df2d61db-29d5-4fba-b911-58978d367504"
objZone33C.Name = _IqY("\086\050\004\045\026\126\085\126\036")
objZone33C.Description = ""
objZone33C.Visible = true
objZone33C.Media = objCementKlin
objZone33C.Choices = {
	"A: February 14, 1752", 
	"B:  April 1, 1776", 
	"C: December 24, 1741", 
	"D: The exact date is unknown"
}
objZone33C.InputType = "MultipleChoice"
objZone33C.Text = _IqY("\062\011\016\076\026\040\016\076\045\026\063\016\024\026\089\045\076\011\082\045\011\045\110\026\004\016\110\045\040\026\096\039\026\036\050\048\004\076\026\086\027\004\118\045\004\040\050\116\114\106")
objZone43 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone43.Id = "79a0fbb5-d4de-4564-a577-66f15536b897"
objZone43.Name = _IqY("\086\050\004\045\026\034\085\126")
objZone43.Description = ""
objZone43.Visible = true
objZone43.Media = objNewHopeLock
objZone43.InputType = "Text"
objZone43.Text = _IqY("\062\011\016\076\026\039\045\016\116\026\063\016\024\026\076\011\045\026\011\027\024\076\050\116\027\053\026\110\016\116\049\045\116\026\043\082\016\053\045\040\106")
objZone42 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone42.Id = "5ef4abe3-3da1-4736-bfe3-5ec627ad2f99"
objZone42.Name = _IqY("\086\050\004\045\026\034\085\007")
objZone42.Description = ""
objZone42.Visible = true
objZone42.Media = objLock2
objZone42.InputType = "Text"
objZone42.Text = _IqY("\062\011\016\076\026\039\045\016\116\026\063\016\024\026\076\011\027\024\026\024\045\053\076\027\050\004\026\114\048\082\082\039\026\116\045\024\076\050\116\045\040\106")
objZone41 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone41.Id = "4cae653e-32e3-43da-b8c2-67fcc4ff5659"
objZone41.Name = _IqY("\086\050\004\045\026\034\085\093")
objZone41.Description = ""
objZone41.Visible = true
objZone41.Media = objBoatView
objZone41.InputType = "Text"
objZone41.Text = _IqY("\125\050\063\026\110\016\004\039\026\110\027\082\045\024\026\040\027\040\026\076\011\045\026\053\016\004\016\082\026\053\050\069\045\116\026\114\116\050\110\026\051\016\048\053\011\026\036\011\048\004\049\026\076\050\026\037\016\024\076\050\004\106")
objZone46 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone46.Id = "7fc25ace-bf70-4095-ba42-59349b27946f"
objZone46.Name = _IqY("\086\050\004\045\026\034\085\066")
objZone46.Description = ""
objZone46.Visible = true
objZone46.Media = objLockTender
objZone46.Choices = {
	"A: Shared the Locktenders House", 
	"B: A tiny cabin on the boat", 
	"C: In nearby communities", 
	"D: They shared houses with other Captains"
}
objZone46.InputType = "MultipleChoice"
objZone46.Text = _IqY("\062\011\045\116\045\026\040\027\040\026\076\011\045\026\036\016\043\076\016\027\004\075\026\016\004\040\026\024\050\110\045\076\027\110\045\024\026\011\027\024\026\063\011\050\082\045\026\114\016\110\027\082\039\075\026\082\027\069\045\026\040\048\116\027\004\046\026\076\011\045\026\045\004\076\027\116\045\026\024\045\016\024\050\004\106\026")
objZone45 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone45.Id = "d955aca2-456b-421b-822b-07c047f975f2"
objZone45.Name = _IqY("\086\050\004\045\026\034\085\003")
objZone45.Description = ""
objZone45.Visible = true
objZone45.Media = objBoat
objZone45.Choices = {
	"A: 8 p.m.", 
	"B: 9 p.m.", 
	"C: 10 p.m.", 
	"D: 11 p.m."
}
objZone45.InputType = "MultipleChoice"
objZone45.Text = _IqY("\001\053\053\050\116\040\027\004\046\026\076\050\026\110\048\082\045\026\040\116\027\069\045\116\026\104\050\024\045\043\011\026\001\026\002\048\110\026\016\026\110\048\082\045\026\040\116\027\069\045\116\026\116\050\024\045\026\016\096\050\048\076\026\126\018\126\099\026\016\078\110\078\026\016\040\026\116\045\027\076\116\045\040\026\016\076\106")
objZone44 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone44.Id = "94cce3a1-68ec-4cda-9ee9-84aa524db476"
objZone44.Name = _IqY("\086\050\004\045\026\034\085\034")
objZone44.Description = ""
objZone44.Visible = true
objZone44.Media = objBoatAction
objZone44.InputType = "Text"
objZone44.Text = _IqY("\065\048\116\027\004\046\026\016\026\063\050\116\049\026\040\016\039\026\011\050\063\026\110\016\004\039\026\011\050\048\116\024\026\040\027\040\026\076\011\045\026\002\050\053\049\076\045\004\040\045\116\026\063\050\116\049\106")
objZone47 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone47.Id = "4b71f81e-1f9a-4a51-927c-712565caf21f"
objZone47.Name = _IqY("\086\050\004\045\026\034\085\070")
objZone47.Description = ""
objZone47.Visible = true
objZone47.Media = objCoveredBridge
objZone47.Choices = {
	"A: Diesel Engine", 
	"B: Sails", 
	"C: Mules", 
	"D: Oars"
}
objZone47.InputType = "MultipleChoice"
objZone47.Text = _IqY("\062\011\016\076\026\040\027\040\026\076\011\045\039\026\048\024\045\026\076\050\026\043\050\063\045\116\026\076\011\045\026\096\050\016\076\024\106")
objZone61 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone61.Id = "19b9375c-1355-4a97-903f-bd510a54de04"
objZone61.Name = _IqY("\086\050\004\045\026\066\085\093")
objZone61.Description = ""
objZone61.Visible = true
objZone61.Media = objNewHopeLock
objZone61.Choices = {
	"A; None", 
	"B: 1", 
	"C: 2", 
	"D: 3"
}
objZone61.InputType = "MultipleChoice"
objZone61.Text = _IqY("\125\050\063\026\110\016\004\039\026\096\050\016\076\024\026\016\116\045\026\063\116\045\053\049\045\040\026\011\045\116\045\106")
objZone74 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone74.Id = "d3329c95-46f8-4e01-af01-d86f3e30e4f5"
objZone74.Name = _IqY("\086\050\004\045\026\070\085\034")
objZone74.Description = ""
objZone74.Visible = true
objZone74.Media = objBidgeView2
objZone74.Choices = {
	"A: World War", 
	"B: Flood", 
	"C: Depression", 
	"D: Sold to Bethlehem Steel"
}
objZone74.InputType = "MultipleChoice"
objZone74.Text = _IqY("\062\011\016\076\026\011\016\043\043\045\004\045\040\026\027\004\026\093\107\093\107\026\076\011\016\076\026\053\016\048\024\045\040\026\076\011\045\026\016\110\048\024\045\110\045\004\076\026\043\016\116\049\026\076\050\026\043\045\110\016\004\045\004\076\082\039\026\053\082\050\024\045\106")
objZone71 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone71.Id = "373038a2-bdde-4bea-bad4-9e4f7b92da4a"
objZone71.Name = _IqY("\086\050\004\045\026\070\085\093")
objZone71.Description = ""
objZone71.Visible = true
objZone71.Media = objCable
objZone71.Choices = {
	"A: They were made from horse hair", 
	"B: Oldest stranded iron ropes in America", 
	"C: Imported from France", 
	"C: it is really new rope just made to look old"
}
objZone71.InputType = "MultipleChoice"
objZone71.Text = _IqY("\062\011\016\076\026\110\016\049\045\024\026\076\011\045\026\053\016\096\082\045\024\026\050\004\026\076\011\045\026\036\011\016\004\046\045\026\096\116\027\040\046\045\026\024\043\045\053\027\016\082\106")
objZone73 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone73.Id = "cf73c3ae-a340-4c00-aa00-590d999118de"
objZone73.Name = _IqY("\086\050\004\045\026\070\085\126")
objZone73.Description = ""
objZone73.Visible = true
objZone73.Media = objFullCircle
objZone73.Choices = {
	"A: Boat", 
	"B: Walking bridge", 
	"C: Trolley", 
	"D: Car"
}
objZone73.InputType = "MultipleChoice"
objZone73.Text = _IqY("\125\050\063\026\040\027\040\026\110\050\024\076\026\043\045\050\043\082\045\026\016\053\053\045\024\024\026\076\011\045\026\056\024\082\016\004\040\026\040\048\116\027\004\046\026\027\076\024\026\016\110\048\024\110\045\004\076\026\043\016\116\049\026\040\016\039\024\106")
objZone72 = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objZone72.Id = "da74d52c-ad62-4817-8c06-8b8c45e728fe"
objZone72.Name = _IqY("\086\050\004\045\026\070\085\007")
objZone72.Description = ""
objZone72.Visible = true
objZone72.Media = objTrolley
objZone72.Choices = {
	"A: Petticott Junction", 
	"B: Igloo Island", 
	"C: Smiths Island", 
	"D: Change Bridge Island"
}
objZone72.InputType = "MultipleChoice"
objZone72.Text = _IqY("\105\050\040\016\039\026\056\024\082\016\004\040\026\025\016\116\049\026\027\024\026\016\026\062\027\082\040\082\027\114\045\026\054\016\004\053\076\048\016\116\039\026\096\048\076\026\027\076\026\011\016\024\026\011\016\040\026\016\026\024\076\116\016\004\046\045\026\082\027\114\045\078\026\001\076\026\050\004\045\026\076\027\110\045\026\027\076\026\063\016\024\026\016\004\026\027\053\045\085\053\048\076\076\027\004\046\026\016\004\040\026\024\076\050\116\016\046\045\026\027\004\040\048\024\076\116\039\078\026\009\004\096\024\043\094\062\011\016\076\026\063\016\024\026\076\011\027\024\026\027\024\082\016\004\040\113\024\026\114\050\116\110\045\116\026\004\016\110\045\078")
objFinal = Wherigo.ZInput(objLehighCanalattheLVGGPWherigoTour)
objFinal.Id = "4054c142-6a39-4add-b662-03f3ffe81ecb"
objFinal.Name = _IqY("\047\027\004\016\082")
objFinal.Description = ""
objFinal.Visible = true
objFinal.Choices = {
	"Yes", 
	"No"
}
objFinal.InputType = "MultipleChoice"
objFinal.Text = _IqY("\125\016\069\045\026\039\050\048\026\063\116\027\076\076\045\004\026\040\050\063\004\026\076\011\045\026\053\050\110\043\082\045\076\027\050\004\026\053\050\040\045\106")

-- WorksWithList for object commands --

-- functions --
function objLehighCanalattheLVGGPWherigoTour:OnStart()
	if (_G[_IqY("\037\004\069")][_IqY("\025\082\016\076\114\050\116\110")] == _IqY("\062\027\004\126\007")) or (_G[_IqY("\037\004\069")][_IqY("\065\045\069\027\053\045\056\065")] == _IqY("\065\045\024\049\076\050\043")) then
		for k, v in pairs(_G[_IqY("\050\096\080\002\045\011\027\046\011\036\016\004\016\082\016\076\076\011\045\002\072\108\108\025\062\011\045\116\027\046\050\105\050\048\116")][_IqY("\001\082\082\086\013\096\080\045\053\076\024")]) do
			v[_IqY("\072\027\024\027\096\082\045")] = false
			v[_IqY("\001\053\076\027\069\045")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_IqY("\054\050\116\116\039\026\076\011\027\024\026\046\016\110\045\026\053\016\004\004\050\076\026\096\045\026\043\082\016\039\045\040\026\050\004\026\076\011\045\026\045\110\048\082\016\076\050\116")), 
			Callback = function(action)
				if action ~= nil then
					_G[_IqY("\062\011\045\116\027\046\050")][_IqY("\036\050\110\110\016\004\040")](_IqY("\054\016\069\045\036\082\050\024\045"))
				end
			end
		}
		return
	end
	objName[_IqY("\054\076\016\116\076")](objName)
	objZone1InformationSign.Active = true
	objZone1InformationSign.Visible = true
end
function objLehighCanalattheLVGGPWherigoTour:OnRestore()
	objName[_IqY("\054\076\016\116\076")](objName)
end
function objZone1InformationSign:OnEnter()
	_Urwigo.MessageBox{
		Text = _IqY("\062\045\082\053\050\110\045\026\076\011\045\026\002\045\011\027\046\011\026\036\016\004\016\082\026\105\050\048\116\026\016\004\040\026\076\050\026\076\011\045\026\002\072\108\108\025\090\026\089\045\024\076\026\050\114\026\082\048\053\049\026\063\027\076\011\026\076\011\027\024\026\016\004\040\026\016\082\082\026\076\011\045\026\050\076\011\045\116\026\053\016\053\011\045\024\026\050\004\026\050\048\116\026\027\024\082\016\004\040\075\026\056\026\011\050\043\045\026\039\050\048\116\026\114\027\004\040\024\026\016\116\045\026\016\082\082\026\114\016\024\076\026\016\004\040\026\045\016\024\039\078"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _IqY("\105\011\027\024\026\053\016\116\076\116\027\040\046\045\026\063\027\082\082\026\076\016\049\045\026\039\050\048\026\050\004\026\016\026\024\011\050\116\076\026\076\050\048\116\026\050\114\026\063\011\016\076\026\050\004\053\045\026\063\016\024\026\016\026\046\116\045\016\076\026\056\116\050\004\026\056\004\040\048\024\076\116\027\016\082\026\024\027\076\045\078\026\105\011\045\116\045\026\063\045\116\045\026\050\004\053\045\026\110\027\046\011\076\039\026\056\116\050\004\026\047\048\116\004\016\053\045\024\026\011\045\116\045\075\026\016\082\050\004\046\026\063\027\076\011\026\076\011\045\026\016\110\016\118\027\004\046\026\053\016\004\016\082\026\076\116\016\004\024\043\050\116\076\016\076\027\050\004\026\024\039\024\076\045\110\078\026"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _IqY("\089\048\076\026\056\026\011\045\016\116\026\039\050\048\026\110\027\046\011\076\026\096\045\026\024\045\076\026\114\050\116\026\016\026\096\048\024\039\026\040\016\039\026\076\050\040\016\039\026\024\050\026\082\045\076\113\024\026\046\045\076\026\116\027\046\011\076\026\076\050\026\076\011\045\026\063\050\116\049\078"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(objZone11)
										end)
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function objZone2Earthcachestrangestone:OnEnter()
	_Urwigo.MessageBox{
		Text = _IqY("\062\045\082\053\050\110\045\026\076\050\026\076\011\045\026\024\045\053\050\004\040\026\024\076\050\043\026\050\114\026\050\048\116\026\076\050\048\116\078\026\056\076\026\027\024\026\096\045\082\027\045\069\045\040\026\076\011\016\076\026\076\011\045\026\116\050\053\049\026\011\045\116\045\026\063\016\024\026\076\011\045\026\123\043\027\076\123\026\076\050\026\016\026\046\116\045\016\076\026\114\048\116\004\016\053\045\026\076\011\016\076\026\050\004\053\045\026\024\076\050\050\040\026\011\045\116\045\078\026"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _IqY("\056\114\026\039\050\048\026\016\116\045\026\076\116\039\027\004\046\026\114\050\116\026\076\011\045\026\123\013\004\045\026\089\048\024\039\026\065\016\039\123\026\053\016\053\011\045\026\039\050\048\026\024\011\050\048\082\040\026\076\016\049\045\026\016\026\120\048\027\053\049\026\096\116\045\016\049\026\016\004\040\026\040\050\026\076\011\045\026\004\045\016\116\096\039\026\123\045\016\116\076\011\053\016\053\011\045\123\078\026"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(objZone21)
							end)
						end
					end
				}
			end
		end
	}
end
function objZone3EdgeofParking:OnEnter()
	_Urwigo.MessageBox{
		Text = _IqY("\062\045\082\053\050\110\045\026\076\050\026\076\011\045\026\076\011\027\116\040\026\024\076\016\046\045\026\050\114\026\076\011\027\024\026\046\016\110\045\078\026\105\011\027\024\026\027\024\026\016\024\026\114\016\116\026\016\024\026\039\050\048\116\026\043\050\063\045\116\045\040\026\063\016\046\050\004\026\046\050\045\024\078\026"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _IqY("\056\076\026\027\024\026\076\027\110\045\026\114\050\116\026\039\050\048\026\076\050\026\076\116\016\069\045\082\026\076\011\045\026\050\082\040\026\114\016\024\011\027\050\004\026\063\016\039\078"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _IqY("\025\082\045\016\024\045\026\076\016\049\045\026\004\050\076\045\026\076\011\016\076\026\050\048\116\026\053\016\004\027\004\045\026\114\116\027\045\004\040\024\026\016\116\045\026\004\050\076\026\063\045\082\053\050\110\045\026\027\004\026\076\011\027\024\026\016\116\045\016\075\026\024\050\026\076\011\045\039\026\053\016\004\004\050\076\026\053\050\110\045\026\050\048\076\026\050\004\026\076\011\027\024\026\011\048\004\076\078"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _IqY("\056\004\026\076\011\027\024\026\024\076\016\046\045\026\039\050\048\026\063\027\082\082\026\096\045\026\046\027\069\045\004\026\024\045\069\045\116\016\082\026\120\048\045\024\076\027\050\004\024\026\076\050\026\016\004\024\063\045\116\078\026\108\045\076\026\076\011\045\110\026\116\027\046\011\076\026\016\004\040\026\039\050\048\026\063\027\082\082\026\096\045\026\050\004\026\039\050\048\116\026\063\016\039\026\027\004\026\004\050\076\026\076\027\110\045\078\026\051\027\024\024\026\016\026\120\048\045\024\076\027\050\004\026\016\004\040\026\039\050\048\026\063\027\082\082\026\046\045\076\026\016\040\040\027\076\027\050\004\016\082\026\120\048\045\024\076\027\050\004\024\026\076\050\026\016\004\024\063\045\116\026\110\016\049\027\004\046\026\039\050\048\116\026\024\076\016\039\026\011\045\116\045\026\076\016\049\045\026\016\026\082\027\076\076\082\045\026\082\050\004\046\045\116\078"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _IqY("\089\048\076\026\050\004\026\076\011\045\026\096\116\027\046\011\076\026\024\027\040\045\026\039\050\048\026\110\016\039\026\082\045\016\116\004\026\024\050\110\045\026\016\040\040\027\076\027\050\004\016\082\026\076\011\027\004\046\024\026\016\096\050\048\076\026\050\048\116\026\016\116\045\016\078\026"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.RunDialogs(function()
																	Wherigo.GetInput(objZone31)
																end)
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function objZone4Historicsign:OnEnter()
	_Urwigo.MessageBox{
		Text = _IqY("\035\050\048\026\011\016\069\045\026\110\016\040\045\026\027\076\026\076\050\026\024\076\016\046\045\026\114\050\048\116\026\050\114\026\050\048\116\026\046\016\110\045\078"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _IqY("\105\011\045\116\045\026\027\024\026\024\050\026\110\048\053\011\026\027\004\114\050\116\110\016\076\027\050\004\026\016\096\050\048\076\026\082\027\114\045\026\050\004\026\076\011\045\026\116\027\069\045\116\026\011\045\116\045\078\026\056\026\011\050\043\045\026\039\050\048\026\063\027\082\082\026\024\043\045\004\040\026\076\011\045\026\076\027\110\045\026\076\050\026\116\045\016\040\026\016\082\082\026\076\011\045\026\011\027\024\076\050\116\027\053\026\110\016\049\045\116\024\078\026\105\011\045\116\045\026\016\116\045\026\024\045\069\045\116\016\082\026\004\045\016\116\096\039\026\016\076\026\076\011\045\026\096\050\016\076\011\050\048\024\045\078"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(objZone41)
							end)
						end
					end
				}
			end
		end
	}
end
function objZone5RailRoadSpike:OnEnter()
	_Urwigo.MessageBox{
		Text = _IqY("\037\016\053\011\026\053\016\004\016\082\026\096\050\016\076\026\053\050\048\082\040\026\011\050\082\040\026\048\043\026\076\050\026\093\099\099\026\076\050\004\024\026\050\114\026\001\004\076\011\116\016\053\027\076\045\026\027\004\026\027\076\024\026\011\048\082\082\078"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _IqY("\001\004\076\011\116\016\053\027\076\045\026\027\024\026\016\082\024\050\026\049\004\050\063\004\026\016\024\026\011\016\116\040\026\053\050\016\082\078\021\089\074\055"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _IqY("\105\011\027\024\026\027\024\026\080\048\024\076\026\009\004\096\024\043\094\016\026\120\048\027\053\049\026\040\116\027\069\045\026\096\039\026\118\050\004\045\078\026\009\004\096\024\043\094\056\114\026\039\050\048\026\082\050\050\049\026\053\082\050\024\045\082\039\026\039\050\048\026\063\027\082\082\026\024\045\045\026\076\011\045\039\026\053\016\110\045\026\048\043\026\063\027\076\011\026\016\026\004\045\063\026\048\024\045\026\114\050\116\026\016\026\116\016\027\082\116\050\016\040\026\024\043\027\049\045\078\026\056\076\026\027\024\026\049\045\045\043\027\004\046\026\076\011\045\026\046\045\016\116\024\026\011\045\116\045\026\114\116\050\110\026\110\050\069\027\004\046\078"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _IqY("\105\011\045\026\002\045\011\027\046\011\026\109\016\069\027\046\016\076\027\050\004\026\024\039\024\076\045\110\026\063\016\024\026\053\050\004\024\027\040\045\116\045\040\026\016\026\053\027\069\027\082\026\045\004\046\027\004\045\045\116\027\004\046\026\114\045\016\076\026\040\048\116\027\004\046\026\027\076\024\026\076\027\110\045\078\026\056\076\026\076\016\110\045\040\026\016\004\026\016\082\110\050\024\076\026\093\099\099\099\026\114\050\050\076\026\045\082\045\069\016\076\027\050\004\026\040\116\050\043\026\076\116\016\069\045\082\027\004\046\026\114\116\050\110\026\062\011\027\076\045\026\125\016\069\045\004\026\076\050\026\037\016\024\076\050\004\078"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _IqY("\109\050\026\063\050\116\116\027\045\024\026\016\096\050\048\076\026\046\045\076\076\027\004\046\026\016\004\039\026\120\048\045\024\076\027\050\004\024\026\063\116\050\004\046\026\011\045\116\045\026\080\048\024\076\026\049\045\045\043\026\050\004\026\011\027\049\027\004\046\026\076\050\063\016\116\040\026\076\011\045\026\002\050\053\049\076\045\004\040\045\116\024\026\011\050\048\024\045\090")
													}
												end
											end
										}
										objZone6LockTender.Active = true
										objZone6LockTender.Visible = true
										objZone5RailRoadSpike.Active = false
										objZone5RailRoadSpike.Visible = false
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function objZone6LockTender:OnEnter()
	_Urwigo.MessageBox{
		Text = _IqY("\054\050\026\076\011\027\024\026\027\024\026\063\011\045\116\045\026\076\011\045\026\082\050\053\049\076\045\004\040\045\116\026\082\027\069\045\040\026\016\004\040\026\063\050\116\049\045\040\078\026\105\011\045\039\026\024\045\082\040\050\110\026\046\050\076\026\076\050\026\082\045\016\069\045\026\011\045\116\045\026\016\024\026\076\011\045\039\026\063\050\116\049\045\040\026\093\029\026\011\050\048\116\024\026\016\026\040\016\039\026\024\027\064\026\040\016\039\024\026\016\026\063\045\045\049\078"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _IqY("\054\043\045\004\040\026\024\050\110\045\026\076\027\110\045\026\016\004\040\026\045\064\043\082\050\116\045\026\076\011\045\026\082\050\053\049\078\026\056\076\026\027\024\026\016\026\116\045\016\082\082\039\026\049\045\063\082\026\024\043\050\076\078"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _IqY("\105\011\045\026\082\016\024\076\026\096\050\016\076\026\114\082\050\016\076\045\040\026\043\045\016\053\045\114\048\082\082\039\026\016\082\050\004\046\026\076\011\045\026\053\016\004\016\082\026\076\011\045\026\045\069\045\004\027\004\046\026\096\045\114\050\116\045\026\076\011\045\026\046\116\045\016\076\026\114\082\050\050\040\026\050\114\026\093\107\034\007\078\026\105\011\045\026\114\082\050\050\040\026\110\016\116\049\045\040\026\076\011\045\026\045\004\040\026\050\114\026\076\011\045\026\045\116\016\078"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _IqY("\105\011\045\116\045\026\063\045\116\045\026\114\027\114\076\039\085\076\011\116\045\045\026\050\114\026\076\011\045\024\045\026\082\050\053\049\024\026\016\082\050\004\046\026\076\011\045\026\053\016\004\016\082\078"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.RunDialogs(function()
														Wherigo.GetInput(objZone61)
													end)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function objZone7FullCircle:OnEnter()
	_Urwigo.MessageBox{
		Text = _IqY("\062\050\063\026\076\011\045\116\045\026\027\024\026\016\026\082\050\076\026\050\114\026\027\004\114\050\116\110\016\076\027\050\004\026\011\045\116\045\026\016\024\026\063\045\082\082\078\026\047\116\050\110\026\011\045\116\045\026\039\050\048\026\053\016\004\026\024\045\045\026\056\024\082\016\004\040\026\025\016\116\049\026\016\024\026\063\045\082\082\026\016\024\026\076\011\045\026\116\045\110\016\027\004\024\026\050\114\026\076\011\045\026\036\011\016\004\046\045\026\089\116\027\040\046\045\078"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _IqY("\035\050\048\026\063\027\082\082\026\096\045\026\046\045\076\076\027\004\046\026\039\050\048\116\026\114\027\004\016\082\026\120\048\045\024\076\027\050\004\024\026\011\045\116\045\026\096\045\114\050\116\045\026\011\045\016\040\027\004\046\026\009\004\096\024\043\094\096\016\053\049\026\076\050\026\076\011\045\026\114\027\004\016\082\078"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _IqY("\105\011\027\024\026\027\024\026\076\116\048\045\082\039\026\016\004\026\016\110\016\118\027\004\046\026\016\116\045\016\078"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _IqY("\062\045\026\063\027\082\082\026\024\076\016\116\076\026\096\039\026\082\045\016\116\004\027\004\046\026\016\026\082\027\076\076\082\045\026\110\050\116\045\026\016\096\050\048\076\026\076\011\045\026\053\016\004\016\082\026\016\004\040\026\076\011\045\026\036\011\016\004\046\045\026\089\027\116\040\046\045\078"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _IqY("\056\114\026\039\050\048\026\082\050\050\049\026\048\043\026\116\027\069\045\116\026\114\116\050\110\026\011\045\116\045\026\039\050\048\026\063\027\082\082\026\024\045\045\026\016\026\043\027\045\116\026\027\004\026\076\011\045\026\116\027\069\045\116\078\026\002\050\050\049\026\016\026\082\027\076\076\082\045\026\053\082\050\024\045\116\026\016\004\040\026\039\050\048\026\063\027\082\082\026\024\045\045\026\076\011\016\076\026\076\011\045\116\045\026\016\116\045\026\024\076\027\082\082\026\053\016\096\082\045\024\026\016\076\076\016\011\045\040\026\076\050\026\076\011\045\026\043\027\045\116\026\053\116\050\024\024\027\004\046\026\076\011\045\026\116\027\069\045\116\078\026"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _IqY("\105\011\027\024\026\027\024\026\063\011\016\076\026\027\024\026\082\045\114\076\026\050\114\026\076\011\045\026\036\011\016\004\046\045\026\089\116\027\040\046\045\078\026\056\076\026\027\024\026\076\011\045\026\050\004\082\039\026\082\050\053\016\076\027\050\004\026\050\004\026\076\011\045\026\002\045\011\027\046\011\026\036\016\004\016\082\026\076\011\016\076\026\076\011\045\026\096\050\016\076\024\026\011\016\040\026\076\050\026\053\116\050\024\024\026\076\011\045\026\116\027\069\045\116\075\026\076\011\027\024\026\096\116\027\040\046\045\026\063\016\024\026\040\045\024\027\046\004\045\040\026\076\050\026\016\082\082\050\063\026\076\011\045\026\110\048\082\045\024\026\076\050\026\024\076\016\039\026\016\076\076\016\053\011\045\040\026\016\004\040\026\076\016\049\045\026\076\011\045\026\096\050\016\076\024\026\016\053\116\050\024\024\078"), 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.RunDialogs(function()
																				Wherigo.GetInput(objZone71)
																			end)
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function objZoneFinalGZ:OnEnter()
	if (_G[_IqY("\037\004\069")][_IqY("\025\082\016\076\114\050\116\110")] == _IqY("\062\027\004\126\007")) or (_G[_IqY("\037\004\069")][_IqY("\065\045\069\027\053\045\056\065")] == _IqY("\065\045\024\049\076\050\043")) then
		_Urwigo.MessageBox{
			Text = _IqY("\105\011\016\004\049\026\035\050\048\026\114\050\116\026\043\082\016\039\027\004\046\026\076\011\027\024\026\046\016\110\045\026\027\004\026\045\110\048\082\016\076\050\116\026\110\050\040\045\078\026\056\026\016\110\026\024\050\116\116\039\026\096\048\076\026\039\050\048\026\053\016\004\004\050\076\026\114\027\004\027\024\011\026\076\011\045\026\046\016\110\045\026\063\027\076\011\050\048\076\026\046\050\027\004\046\026\076\050\026\076\011\045\026\027\024\082\016\004\040\026\114\050\116\026\116\045\016\082\078\026\035\050\048\116\026\046\016\110\045\026\045\004\040\024\026\011\045\116\045\090")
		}
		Wherigo.Command "SaveClose"
	else
		_Urwigo.MessageBox{
			Text = _IqY("\035\050\048\026\011\016\069\045\026\116\045\016\053\011\045\040\026\076\011\045\026\114\027\004\016\082\026\024\076\016\046\045\026\050\114\026\076\011\027\024\026\063\011\045\116\027\046\050\078\026\035\050\048\116\026\050\004\082\039\026\116\045\110\016\027\004\027\004\046\026\076\016\024\049\026\027\024\026\076\050\026\114\027\004\040\026\016\004\040\026\024\027\046\004\026\076\011\045\026\082\050\046\026\050\114\026\076\011\045\026\053\016\053\011\045\078\026\056\076\026\027\024\026\082\050\053\016\076\045\040\026\016\076\026\109\026\034\099\026\126\107\078\066\070\066\026\062\026\099\070\003\026\093\034\078\034\126\093\078\026\056\076\026\027\024\026\016\026\063\045\082\082\026\011\027\040\040\045\004\026\110\027\053\116\050\078\026"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\002\050\053\016\076\045\026\036\016\053\011\045\026\053\050\004\076\016\027\004\045\116\026\016\076\021\089\074\055\109\026\034\099\026\126\107\078\066\070\066\026\062\026\099\070\003\026\093\034\078\034\126\093\021\089\074\055\016\004\040\026\024\027\046\004\026\027\076\090"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _IqY("\035\050\048\026\063\027\082\082\026\016\082\024\050\026\004\045\045\040\026\076\050\026\063\116\027\076\045\026\040\050\063\004\026\076\011\045\026\114\050\082\082\050\063\027\004\046\026\123\053\050\110\043\082\045\076\027\050\004\026\053\050\040\045\123\026\027\004\026\050\116\040\045\116\026\076\050\026\048\004\082\050\053\049\026\076\011\045\026\053\016\116\076\116\027\040\046\045\026\050\004\026\076\011\045\026\063\011\045\116\027\046\050\026\024\027\076\045\026\016\004\040\026\024\011\050\063\026\076\011\016\076\026\039\050\048\026\053\050\110\043\082\045\076\045\040\026\076\011\045\026\046\016\110\045\078\026\056\114\026\039\050\048\026\016\116\045\026\043\082\016\039\027\004\046\026\048\024\027\004\046\026\024\050\110\045\050\004\045\026\045\082\024\045\024\026\040\045\069\027\053\045\026\039\050\048\026\063\027\082\082\026\004\045\045\040\026\076\011\045\027\116\026\048\024\045\116\026\004\016\110\045\026\016\004\040\026\076\011\045\026\053\050\040\045\026\076\050\026\048\004\082\050\053\049\026\076\011\045\026\046\016\110\045\026\114\027\082\045\026\114\050\116\026\039\050\048\078"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = string.sub(Player.CompletionCode, 1, 15), 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _IqY("\056\026\011\050\043\045\026\039\050\048\026\011\016\069\045\026\045\004\080\050\039\045\040\026\076\011\027\024\026\053\016\116\076\116\027\040\046\045\026\016\004\040\026\045\004\080\050\039\026\039\050\048\116\026\069\027\024\027\076\026\076\050\026\076\011\045\026\002\072\108\108\025\078\026\009\004\096\024\043\094\035\050\048\026\110\016\039\026\004\050\063\026\082\050\046\026\076\011\027\024\026\050\004\026\096\050\076\011\026\076\011\045\026\108\045\050\053\016\053\011\027\004\046\026\016\004\040\026\062\011\045\116\027\046\050\026\024\027\076\045\024\078"), 
															Callback = function(action)
																if action ~= nil then
																	_Urwigo.MessageBox{
																		Text = _IqY("\001\046\016\027\004\026\027\114\026\039\050\048\026\011\016\069\045\026\004\050\076\026\040\050\004\045\026\024\050\026\043\082\045\016\024\045\026\063\116\027\076\045\026\040\050\063\004\026\039\050\048\116\026\053\050\110\043\082\045\076\027\050\004\026\053\050\040\045\090\026\035\050\048\026\063\027\082\082\026\048\024\045\026\076\011\027\024\026\053\050\040\045\026\063\011\045\004\026\082\050\046\046\027\004\046\026\076\011\045\026\053\016\053\011\045\026\050\004\026\076\011\045\026\063\011\045\116\027\046\050\026\024\027\076\045\075\026\027\076\026\048\004\082\050\053\049\024\026\076\011\045\026\053\016\116\076\116\027\040\046\045\075\026\063\011\027\053\011\026\027\024\026\016\050\076\011\045\116\026\063\016\039\026\050\114\026\024\016\039\027\004\046\026\076\011\016\076\026\027\024\026\024\011\050\063\026\076\011\045\026\053\016\116\076\116\027\040\046\045\026\016\024\026\011\016\069\027\004\046\026\096\045\045\004\026\053\050\110\043\082\045\076\045\040\026\096\039\026\039\050\048\078\026\056\076\026\024\011\050\063\024\026\050\076\011\045\116\024\026\076\011\016\076\026\076\011\045\026\046\016\110\045\026\063\050\116\049\024\026\016\004\040\026\027\024\026\063\050\116\076\011\026\076\011\045\026\076\027\110\045\026\076\050\026\043\082\016\039\078"), 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.MessageBox{
																					Text = string.sub(Player.CompletionCode, 1, 15), 
																					Callback = function(action)
																						if action ~= nil then
																							_Urwigo.MessageBox{
																								Text = _IqY("\056\114\026\039\050\048\026\016\116\045\026\011\016\069\027\004\046\026\043\116\050\096\082\045\110\024\026\114\027\004\040\027\004\046\026\076\011\045\026\053\016\053\011\045\075\026\027\076\026\027\024\026\116\027\046\011\076\026\011\045\116\045\078"), 
																								Media = objSpoiler, 
																								Callback = function(action)
																									if action ~= nil then
																										_Urwigo.RunDialogs(function()
																											Wherigo.GetInput(objFinal)
																										end)
																									end
																								end
																							}
																						end
																					end
																				}
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	end
end
function objZone1Penalty:OnEnter()
	_Urwigo.MessageBox{
		Text = _IqY("\056\026\016\110\026\024\050\026\024\050\116\116\039\026\076\050\026\024\045\045\026\039\050\048\026\096\016\053\049\026\011\045\116\045\078\026\056\026\011\050\043\045\026\039\050\048\026\016\116\045\026\004\050\076\026\011\016\069\027\004\046\026\043\116\050\096\082\045\110\024\026\063\027\076\011\026\039\050\048\116\026\040\045\069\027\053\045\078\026\056\114\026\039\050\048\026\011\016\069\045\026\076\050\026\049\045\045\043\026\096\016\053\049\076\116\016\053\049\027\004\046\026\039\050\048\026\063\027\082\082\026\004\045\069\045\116\026\114\027\004\027\024\011\026\076\011\045\026\123\013\004\045\026\089\048\024\039\026\065\016\039\123\026\116\045\120\048\027\116\045\110\045\004\076\024\026\076\050\040\016\039\090"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(objZone11APenaltyQuestion)
				end)
			end
		end
	}
end
function objZone2Repeated:OnEnter()
	_Urwigo.MessageBox{
		Text = _IqY("\056\076\026\027\024\026\016\096\050\048\076\026\076\027\110\045\026\039\050\048\026\046\050\076\026\096\016\053\049\026\011\045\116\045\078\026\025\082\045\016\024\045\026\096\045\026\053\016\116\045\114\048\082\026\063\027\076\011\026\039\050\048\116\026\016\004\024\063\045\116\024\026\114\116\050\110\026\004\050\063\026\050\004\078"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(objZone21Repeat)
				end)
			end
		end
	}
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone11:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\036\018\026\065\016\069\027\040\026\105\011\050\110\016\024")) then
		_Urwigo.MessageBox{
			Text = _IqY("\062\045\082\082\026\039\050\048\026\016\116\045\026\050\114\114\026\076\050\026\016\026\046\116\045\016\076\026\024\076\016\116\076\078\026\025\016\039\026\016\076\076\045\004\076\027\050\004\026\076\050\026\040\045\076\016\027\082\026\016\004\040\026\016\004\024\063\045\116\026\045\016\053\011\026\120\048\045\024\076\027\050\004\026\053\050\116\116\045\053\076\082\039\026\016\004\040\026\076\011\027\024\026\063\027\082\082\026\096\045\026\016\026\063\016\082\049\026\027\004\026\076\011\045\026\043\016\116\049\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\089\045\026\024\048\116\045\026\004\050\076\026\076\050\026\046\050\026\076\050\050\026\114\016\024\076\026\016\004\040\026\046\045\076\026\016\082\082\026\039\050\048\116\026\016\004\024\063\045\116\024\026\053\050\116\116\045\053\076\026\076\011\045\026\114\027\116\024\076\026\076\027\110\045\078\026\037\116\116\050\116\024\026\110\016\040\045\026\082\016\076\045\116\026\027\004\026\076\011\045\026\046\016\110\045\026\110\016\039\026\116\045\120\048\027\116\045\026\039\050\048\026\076\050\026\076\016\049\045\026\016\026\040\045\076\050\048\116\026\050\116\026\040\050\026\016\026\082\027\076\076\082\045\026\110\050\116\045\026\063\050\116\049\026\016\076\026\016\026\046\027\069\045\004\026\082\050\053\016\076\027\050\004\090"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _IqY("\108\082\045\004\040\050\004\026\056\116\050\004\026\036\050\110\043\016\004\039\026\116\016\004\026\114\048\116\004\016\053\045\024\026\114\116\050\110\026\093\029\034\034\026\048\004\076\027\082\026\076\011\045\026\053\050\110\043\016\004\039\026\053\082\050\024\045\040\026\027\076\024\026\040\050\050\116\024\026\114\050\116\026\076\011\045\026\082\016\024\076\026\076\027\110\045\026\027\004\026\093\029\107\034\078\026\105\011\045\026\114\048\116\004\016\053\045\024\026\063\045\116\045\026\076\050\116\045\026\040\050\063\004\026\016\004\040\026\048\024\045\040\026\114\050\116\026\024\053\116\016\043\078\026\009\004\096\024\043\094\105\011\045\116\045\026\016\116\045\026\024\076\027\082\082\026\024\045\069\045\116\016\082\026\116\045\110\016\027\004\024\026\050\114\026\076\011\045\026\043\082\016\004\076\026\016\004\040\026\024\050\110\045\026\114\048\116\004\016\053\045\026\114\050\048\004\040\016\076\027\050\004\024\026\011\045\116\045\026\027\004\026\076\011\045\026\043\016\116\049\078"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.RunDialogs(function()
												Wherigo.GetInput(objZone12)
											end)
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\056\026\040\050\004\113\076\026\049\004\050\063\026\063\011\016\076\026\039\050\048\026\016\116\045\026\116\045\016\040\027\004\046\026\096\048\076\026\076\011\016\076\026\027\024\026\004\050\076\026\063\011\016\076\026\056\026\082\045\016\116\004\045\040\026\011\045\116\045\078\026\035\050\048\026\016\116\045\026\082\048\053\049\039\026\076\011\027\024\026\027\024\026\076\011\045\026\114\027\116\024\076\026\024\076\016\046\045\026\024\050\026\039\050\048\026\046\045\076\026\076\050\026\046\048\045\024\024\026\016\046\016\027\004\078\026\105\011\027\024\026\027\024\026\039\050\048\116\026\114\116\045\045\026\053\011\016\004\053\045\026\076\050\026\082\045\016\116\004\026\011\050\063\026\076\011\045\026\046\016\110\045\026\063\050\116\049\024\026\050\004\026\039\050\048\116\026\040\045\069\027\053\045\078\026"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\108\050\026\016\011\045\016\040\026\016\004\040\026\076\116\039\026\076\011\027\024\026\120\048\045\024\076\027\050\004\026\016\046\016\027\004\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone11)
								end)
							end
						end
					}
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone12:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\089\018\026\003\003")) then
		_Urwigo.MessageBox{
			Text = _IqY("\072\045\116\039\026\004\027\053\045\090\026\056\026\016\110\026\046\082\016\040\026\003\003\026\027\024\026\050\004\082\039\026\076\011\045\026\016\004\024\063\045\116\026\076\050\026\076\011\027\024\026\120\048\045\024\076\027\050\004\026\016\004\040\026\004\050\026\082\050\004\046\045\116\026\076\011\045\026\024\043\045\045\040\026\082\027\110\027\076\078\026\125\045\053\049\026\076\011\016\076\026\063\050\048\082\040\026\024\082\050\063\026\048\024\026\016\082\082\026\040\050\063\004\026\063\011\045\004\026\011\045\016\040\027\004\046\026\050\048\076\026\114\050\116\026\016\026\114\027\116\024\076\026\076\050\026\114\027\004\040\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\056\026\116\045\016\082\082\039\026\082\045\016\116\004\045\040\026\016\026\082\050\076\026\116\045\016\040\027\004\046\026\076\011\045\024\045\026\024\027\046\004\024\078\026\056\026\011\050\043\045\026\039\050\048\026\016\082\024\050\026\045\004\080\050\039\026\082\045\016\116\004\027\004\046\026\016\026\082\027\076\076\082\045\026\016\096\050\048\076\026\050\048\116\026\043\016\024\076\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _IqY("\065\050\004\113\076\026\063\050\116\116\039\026\076\011\045\116\045\026\063\027\082\082\026\004\050\076\026\096\045\026\110\016\004\039\026\120\048\045\024\076\027\050\004\024\026\016\076\026\076\011\045\026\050\076\011\045\116\026\024\076\016\046\045\024\078\026\089\048\076\026\056\026\040\050\026\063\016\004\076\026\039\050\048\026\076\050\026\082\045\016\116\004\026\016\026\082\027\076\076\082\045\026\063\011\027\082\045\026\011\045\116\045\078\021\089\074\055"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.RunDialogs(function()
												Wherigo.GetInput(objZone13)
											end)
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\036\050\110\045\026\050\004\026\004\050\063\026\076\011\045\026\016\004\024\063\045\116\026\027\024\026\116\027\046\011\076\026\076\011\045\116\045\026\050\004\026\076\011\045\026\024\027\046\004\026\080\048\024\076\026\016\096\050\069\045\026\076\011\045\026\096\027\046\026\043\027\053\076\048\116\045\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\056\026\011\050\043\045\026\039\050\048\026\114\027\046\048\116\045\026\076\011\027\024\026\050\048\076\026\024\050\026\039\050\048\026\040\050\026\004\050\076\026\011\016\069\045\026\076\050\026\040\050\026\045\064\076\116\016\026\063\050\116\049\026\016\024\026\063\045\026\110\050\069\045\026\016\082\050\004\046\026\027\004\026\076\011\045\026\046\016\110\045\078\026\105\011\045\026\050\004\082\039\026\046\050\050\040\026\076\011\027\004\046\026\063\050\048\082\040\026\096\045\026\016\082\082\026\076\011\045\026\045\064\076\116\016\026\049\004\050\063\082\045\040\046\045\026\039\050\048\026\063\050\048\082\040\026\046\016\027\004\026\016\004\024\063\045\116\027\004\046\026\016\082\082\026\076\011\050\024\045\026\045\064\076\116\016\026\120\048\045\024\076\027\050\004\024\078\026\108\050\026\016\011\045\016\040\026\016\004\040\026\076\116\039\026\016\046\016\027\004\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone12)
								end)
							end
						end
					}
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone13:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\065\018\026\104\048\082\039\026\034\076\011\075\026\093\029\034\099")) then
		_Urwigo.MessageBox{
			Text = _IqY("\056\026\053\016\004\026\024\045\045\026\016\026\043\082\016\053\045\026\076\116\039\027\004\046\026\076\050\026\050\043\045\004\026\048\043\026\114\050\116\026\076\011\045\026\114\027\116\024\076\026\076\027\110\045\026\050\004\026\016\026\011\050\082\027\040\016\039\026\004\050\063\016\040\016\039\024\090\026\105\011\045\026\034\076\011\026\050\114\026\104\048\082\039\026\027\024\026\050\004\045\026\050\114\026\110\039\026\114\016\069\050\116\027\076\045\026\011\050\082\027\040\016\039\024\090\026\089\089\115\113\024\075\026\114\027\116\045\063\050\116\049\024\026\016\004\040\026\063\016\116\110\026\024\048\004\026\063\011\016\076\026\053\050\048\082\040\026\096\045\026\096\045\076\076\045\116\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone14)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\125\045\116\045\026\027\024\026\016\026\011\027\004\076\018\026\056\076\026\027\024\026\016\026\011\050\082\027\040\016\039\026\076\011\016\076\026\043\045\050\043\082\045\026\076\045\004\040\026\076\050\026\048\024\045\026\114\027\116\045\063\050\116\049\024\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\108\050\076\026\027\076\106\026\108\048\045\024\024\026\016\046\016\027\004\090"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone13)
								end)
							end
						end
					}
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone14:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\001\018\026\065\027\064\027\045\026\036\048\043\026\036\050\110\043\016\004\039")) then
		_Urwigo.MessageBox{
			Text = _IqY("\105\011\016\076\026\027\024\026\053\050\116\116\045\053\076\078\026\051\039\026\016\046\027\082\027\076\039\026\046\050\082\040\045\004\026\116\045\076\116\027\045\069\045\116\113\024\026\004\016\110\045\026\027\024\026\065\027\064\027\045\078\026\054\011\045\026\063\016\024\026\016\026\024\048\043\045\116\024\076\016\116\026\027\004\026\011\045\116\026\040\016\039\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\125\045\116\026\116\045\046\027\024\076\045\116\045\040\026\004\016\110\045\026\027\024\026\123\005\027\024\024\026\110\039\026\108\116\027\076\024\123\090\026\002\027\049\045\026\039\050\048\026\053\016\116\045\075\026\082\045\076\113\024\026\046\045\076\026\096\016\053\049\026\076\050\026\076\011\045\026\046\016\110\045\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _IqY("\013\004\045\026\082\016\024\076\026\120\048\045\024\076\027\050\004\026\011\045\116\045\090"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.RunDialogs(function()
												Wherigo.GetInput(objZone15)
											end)
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\054\050\116\116\039\026\053\016\053\011\045\116\026\076\011\016\076\026\027\024\026\004\050\076\026\116\027\046\011\076\078\026\105\011\116\045\045\026\082\016\024\011\045\024\026\063\027\076\011\026\016\026\063\045\076\026\004\050\050\040\082\045\090\026\109\050\063\026\076\116\039\026\016\046\016\027\004\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone14)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone15:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\047\016\082\024\045")) then
		_Urwigo.MessageBox{
			Text = _IqY("\056\076\026\024\048\116\045\026\024\050\048\004\040\024\026\082\027\049\045\026\011\045\026\063\016\024\026\016\026\046\116\045\016\076\026\043\045\116\024\050\004\078\026\056\026\096\045\076\026\011\045\026\063\050\048\082\040\026\011\016\069\045\026\045\004\080\050\039\045\040\026\050\048\116\026\082\027\076\076\082\045\026\046\016\110\045\026\016\004\040\026\063\050\048\082\040\026\011\016\069\045\026\063\045\082\053\050\110\045\040\026\048\024\026\050\004\026\011\027\024\026\043\116\050\043\045\116\076\027\045\024\078\026\125\050\043\045\114\048\082\082\039\026\011\027\024\026\024\043\027\116\027\076\026\063\027\082\082\026\011\045\082\043\026\046\027\069\045\026\039\050\048\026\024\050\110\045\026\046\050\050\040\026\049\016\116\110\016\026\076\050\040\016\039\026\016\004\040\026\024\043\045\045\040\026\039\050\048\026\016\082\050\004\046\026\076\011\027\024\026\053\016\053\011\027\004\046\026\016\040\069\045\004\076\048\116\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\035\050\048\116\026\004\045\064\076\026\024\076\050\043\026\027\024\026\080\048\024\076\026\016\026\024\011\050\116\076\026\040\027\024\076\016\004\053\045\026\016\063\016\039\078\026\054\050\026\082\045\076\113\024\026\046\045\076\026\046\050\027\004\046\090")
					}
					objZone2Earthcachestrangestone.Active = true
					objZone2Earthcachestrangestone.Visible = true
					objZone1InformationSign.Active = false
					objZone1InformationSign.Visible = false
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\035\050\048\026\110\048\024\076\026\004\050\076\026\096\045\026\116\045\016\040\027\004\046\026\076\011\027\004\046\024\026\069\045\116\039\026\053\016\116\045\114\048\082\082\039\078\026\125\045\026\043\116\050\069\027\040\045\040\026\114\048\004\040\024\026\076\050\026\011\045\082\043\026\043\048\116\053\011\016\024\045\026\024\027\064\026\110\027\082\045\024\026\050\114\026\076\011\045\026\053\016\004\016\082\026\016\004\040\026\016\040\080\016\053\045\004\076\026\082\016\004\040\024\078\026\125\045\026\045\004\053\050\048\116\016\046\045\040\026\082\050\053\016\082\026\076\050\063\004\024\026\076\050\026\043\048\116\053\011\016\024\045\026\043\116\050\043\045\116\076\039\026\053\016\004\016\082\026\082\016\004\040\026\016\004\040\026\063\016\024\026\016\026\043\116\050\110\050\076\045\116\026\050\114\026\123\050\043\045\004\026\024\043\016\053\045\123\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone15)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone21:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\036\018\026\082\045\024\024\026\076\011\016\004\026\093\092\007\026\076\011\045\026\024\027\118\045")) then
		_Urwigo.MessageBox{
			Text = _IqY("\105\011\016\076\026\063\016\024\026\069\045\116\039\026\045\016\024\039\026\016\004\040\026\027\076\026\027\024\026\039\050\048\116\026\050\004\082\039\026\120\048\045\024\076\027\050\004\026\011\045\116\045\026\024\050\026\046\045\076\026\110\050\069\027\004\046\026\076\050\026\024\076\016\046\045\026\076\011\116\045\045\075\026\040\050\004\106\076\026\110\016\049\045\026\110\045\026\043\048\076\026\016\026\076\027\110\045\116\026\050\004\026\076\011\027\024\026\046\016\110\045\078")
		}
		objZone3EdgeofParking.Active = true
		objZone3EdgeofParking.Visible = true
		objZone2Earthcachestrangestone.Active = false
		objZone2Earthcachestrangestone.Visible = false
	else
		_Urwigo.MessageBox{
			Text = _IqY("\013\049\026\056\026\049\004\050\063\026\027\076\026\027\024\026\050\004\082\039\026\016\026\046\048\045\024\024\026\096\048\076\026\056\026\053\016\004\004\050\076\026\096\048\039\026\039\050\048\116\026\016\004\024\063\045\116\078\026\056\026\016\110\026\016\082\024\050\026\024\050\116\116\039\026\096\048\076\026\039\050\048\026\110\048\024\076\026\004\050\063\026\024\045\116\069\045\026\016\026\043\045\004\016\082\076\039\078\026\035\050\048\026\063\027\082\082\026\004\045\045\040\026\076\050\026\096\016\053\049\076\116\016\053\049\026\016\004\040\026\016\004\024\063\045\116\026\016\004\050\076\011\045\116\026\120\048\045\024\076\027\050\004\090"), 
			Callback = function(action)
				if action ~= nil then
					objZone1Penalty.Active = true
					objZone1Penalty.Visible = true
					objZone2Earthcachestrangestone.Active = false
					objZone2Earthcachestrangestone.Visible = false
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone11APenaltyQuestion:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\093\029\070\066")) then
		_Urwigo.MessageBox{
			Text = _IqY("\072\045\116\039\026\046\050\050\040\075\026\004\050\063\026\011\045\016\040\026\096\039\026\076\050\026\024\076\016\046\045\026\076\063\050\026\016\004\040\026\046\045\076\026\076\011\016\076\026\120\048\045\024\076\027\050\004\026\053\050\116\116\045\053\076\078\026\065\050\004\106\076\026\046\045\076\026\024\076\048\053\049\026\011\045\116\045\026\027\004\026\076\011\045\026\114\027\116\024\076\026\125\001\002\047\090")
		}
		objZone2Repeated.Active = true
		objZone2Repeated.Visible = true
		objZone1Penalty.Active = false
		objZone1Penalty.Visible = false
	else
		_Urwigo.MessageBox{
			Text = _IqY("\005\045\045\043\026\046\048\045\024\024\027\004\046\026\096\048\076\026\027\076\026\082\050\050\049\024\026\082\027\049\045\026\076\011\027\024\026\027\024\026\046\050\027\004\046\026\076\050\026\096\045\026\016\026\082\050\004\046\026\046\016\110\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone11APenaltyQuestion)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone21Repeat:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\036\018\026\082\045\024\024\026\076\011\016\004\026\093\092\007\026\076\011\045\026\024\027\118\045")) then
		_Urwigo.MessageBox{
			Text = _IqY("\035\050\048\026\110\016\040\045\026\076\011\016\076\026\082\050\050\049\026\045\016\024\039\026\076\011\027\024\026\076\027\110\045\026\016\116\050\048\004\040\090\026\109\050\063\026\039\050\048\026\096\045\076\076\045\116\026\011\048\024\076\082\045\026\016\004\040\026\110\016\049\045\026\048\043\026\024\050\110\045\026\076\027\110\045\078\026\125\045\016\040\026\050\004\026\050\048\076\026\076\050\026\024\076\016\046\045\026\076\011\116\045\045\090")
		}
		objZone3EdgeofParking.Active = true
		objZone3EdgeofParking.Visible = true
		objZone2Repeated.Active = false
		objZone2Repeated.Visible = false
	else
		_Urwigo.MessageBox{
			Text = _IqY("\013\049\026\056\026\049\004\050\063\026\027\076\026\027\024\026\050\004\082\039\026\016\026\046\048\045\024\024\026\096\048\076\026\056\026\024\076\027\082\082\026\053\016\004\004\050\076\026\096\048\039\026\039\050\048\116\026\016\004\024\063\045\116\078\026\054\027\004\053\045\026\039\050\048\026\011\016\069\045\026\016\082\116\045\016\040\039\026\024\045\116\069\045\040\026\076\011\045\026\043\045\004\016\082\076\039\026\046\050\026\016\011\045\016\040\026\016\004\040\026\046\048\045\024\024\026\016\046\016\027\004\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone21Repeat)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone31:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\001\018\026\125\045\116\027\076\016\046\045")) then
		_Urwigo.MessageBox{
			Text = _IqY("\062\045\082\082\026\040\050\004\045\075\026\076\011\016\076\026\027\024\026\050\004\045\026\120\048\045\024\076\027\050\004\026\040\050\063\004\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\105\011\045\026\005\045\039\024\076\050\004\045\026\047\048\116\004\016\053\045\026\063\016\024\026\050\004\045\026\050\114\026\076\011\045\026\110\050\024\076\026\043\116\050\040\048\053\076\027\069\045\026\016\004\076\011\116\016\053\027\076\045\026\114\048\116\004\016\053\045\024\026\027\004\026\076\011\045\026\002\045\011\027\046\011\026\072\016\082\082\045\039\078\026\056\076\026\063\016\024\026\024\050\082\040\026\114\050\116\026\024\053\116\016\043\026\016\114\076\045\116\026\024\011\048\076\076\027\004\046\026\040\050\063\004\026\027\004\026\093\107\007\126\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone32)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\036\113\110\050\004\026\004\050\063\026\076\011\045\026\027\004\114\050\116\110\016\076\027\050\004\026\039\050\048\026\024\045\045\049\026\027\024\026\116\027\046\011\076\026\076\011\045\116\045\026\050\004\026\076\011\045\026\024\027\046\004\024\078\026\109\050\063\026\039\050\048\026\063\027\082\082\026\011\016\069\045\026\045\064\076\116\016\026\120\048\045\024\076\027\050\004\024\026\076\050\026\016\004\024\063\045\116\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\125\045\116\045\026\027\024\026\039\050\048\116\026\114\027\116\024\076\026\043\045\004\016\082\076\039\026\120\048\045\024\076\027\050\004\090"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone31A)
								end)
							end
						end
					}
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone32:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\089\018\026\105\050\063\045\040\026\076\011\045\026\036\016\004\016\082\026\089\050\016\076\024")) then
		_Urwigo.MessageBox{
			Text = _IqY("\089\045\114\050\116\045\026\056\026\053\016\110\045\026\011\045\116\045\026\056\026\063\050\048\082\040\026\011\016\069\045\026\004\045\069\045\116\026\046\048\045\024\024\045\040\026\076\011\016\076\026\076\011\045\039\026\048\024\045\040\026\110\048\082\045\024\026\076\050\026\043\048\082\082\026\076\011\045\026\053\016\004\016\082\026\096\050\016\076\024\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\105\011\045\026\002\048\053\039\026\114\048\116\004\016\053\045\075\026\016\026\024\110\016\082\082\026\024\027\004\046\082\045\026\114\048\116\004\016\053\045\026\063\016\024\026\096\048\027\082\076\026\027\004\026\093\029\070\007\026\096\048\076\026\120\048\027\053\049\082\039\026\114\045\082\082\026\069\027\053\076\027\110\026\076\050\026\076\011\045\026\065\045\043\116\045\024\024\027\050\004\026\050\114\026\093\029\070\126\078\026\056\076\026\063\016\024\026\024\050\082\040\026\076\050\026\065\116\078\026\002\027\004\040\045\116\110\016\004\078\026\105\011\045\026\114\048\116\004\016\053\045\026\050\043\045\116\016\076\045\040\026\024\048\053\053\045\024\024\114\048\082\082\039\026\048\004\076\027\082\026\093\029\029\066\026\063\011\045\004\026\027\076\026\063\016\024\026\024\050\082\040\026\076\050\026\089\045\076\011\082\045\011\045\110\026\056\116\050\004\026\036\050\110\043\016\004\039\078\026\105\011\045\039\026\114\027\004\016\082\082\039\026\024\011\048\076\026\027\076\026\040\050\063\004\026\027\004\026\093\029\107\070\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone33)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\054\050\116\116\039\026\076\011\016\076\026\027\024\026\004\050\076\026\053\050\116\116\045\053\076\090\026\109\050\063\026\076\050\026\024\045\116\069\045\026\039\050\048\116\026\043\045\004\016\082\076\039\026\096\039\026\082\045\016\116\004\027\004\046\026\016\026\082\027\076\076\082\045\026\110\050\116\045\026\011\045\116\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone32A)
					end)
				end
			end
		}
	end
end
function objZone31C:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\036\018\026\036\050\082\050\004\027\016\082")) then
		_Urwigo.MessageBox{
			Text = _IqY("\062\011\045\063\090\026\056\026\049\004\045\063\026\039\050\048\026\053\050\048\082\040\026\040\050\026\027\076\078\026\109\050\063\026\096\016\053\049\026\076\050\026\076\011\045\026\114\027\116\024\076\026\120\048\045\024\076\027\050\004\026\039\050\048\026\110\027\024\024\045\040\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone31D)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\035\050\048\026\016\116\045\026\063\116\050\004\046\026\016\046\016\027\004\078\026\105\011\045\026\046\050\050\040\026\076\011\027\004\046\026\016\096\050\048\076\026\076\011\045\024\045\026\043\045\004\016\082\076\039\026\120\048\045\024\076\027\050\004\024\026\027\024\026\039\050\048\026\046\045\076\026\076\050\026\076\116\039\026\016\046\016\027\004\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone31C)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone31B:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\089\018\026\002\048\110\096\045\116")) then
		_Urwigo.MessageBox{
			Text = _IqY("\062\045\082\082\026\040\050\004\045\090\026\013\004\045\026\110\050\116\045\026\120\048\045\024\076\027\050\004\026\016\004\040\026\039\050\048\026\063\027\082\082\026\096\045\026\040\050\004\045\026\063\027\076\011\026\076\011\027\024\026\043\045\004\016\082\076\039\026\043\011\016\024\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone31C)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\001\082\082\026\076\011\045\026\027\004\114\050\116\110\016\076\027\050\004\026\039\050\048\026\004\045\045\040\026\027\024\026\050\004\026\076\011\045\026\024\027\046\004\024\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone31B)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone31A:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\036\018\026\003")) then
		_Urwigo.MessageBox{
			Text = _IqY("\072\045\116\039\026\046\050\050\040\075\026\004\050\063\026\039\050\048\026\016\116\045\026\046\045\076\076\027\004\046\026\076\011\045\026\011\016\004\046\026\050\114\026\076\011\027\024\075\026\080\048\024\076\026\016\026\053\050\048\043\082\045\026\110\050\116\045\026\043\045\004\016\082\076\039\026\120\048\045\024\076\027\050\004\024\026\016\004\040\026\039\050\048\026\053\016\004\026\046\045\076\026\096\016\053\049\026\050\004\026\076\116\016\053\049\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone31B)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\056\026\016\110\026\024\050\026\024\050\116\116\039\026\039\050\048\026\016\116\045\026\011\016\069\027\004\046\026\024\048\053\011\026\076\116\050\048\096\082\045\026\063\027\076\011\026\076\011\045\024\045\026\120\048\045\024\076\027\050\004\024\075\026\043\082\045\016\024\045\026\076\116\039\026\016\046\016\027\004\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone31A)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone31D:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\001\018\026\125\045\116\027\076\016\046\045")) then
		_Urwigo.MessageBox{
			Text = _IqY("\108\116\045\016\076\026\004\050\063\026\039\050\048\026\016\116\045\026\050\004\026\076\050\026\039\050\048\116\026\024\045\053\050\004\040\026\120\048\045\024\076\027\050\004\026\114\050\116\026\076\011\027\024\026\024\076\016\046\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone32)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\001\076\026\076\011\027\024\026\043\050\027\004\076\026\039\050\048\026\110\027\046\011\076\026\016\024\026\063\045\082\082\026\046\048\045\024\024\026\016\076\026\076\011\027\024\026\050\004\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone31D)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone32A:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\065\018\026\093\029\126\034")) then
		_Urwigo.MessageBox{
			Text = _IqY("\108\050\050\040\075\026\004\045\064\076\026\120\048\045\024\076\027\050\004\026\043\082\045\016\024\045\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone32B)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\062\045\082\082\026\039\050\048\026\016\116\045\026\004\050\076\026\040\050\027\004\046\026\063\045\082\082\026\016\076\026\076\011\027\024\026\016\076\026\016\082\082\078\026\104\048\024\076\026\049\045\045\043\026\116\027\046\011\076\026\050\004\026\046\048\045\024\024\027\004\046\078\026\035\050\048\026\063\027\082\082\026\046\045\076\026\027\076\026\116\027\046\011\076\026\045\069\045\004\076\048\016\082\082\039\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone32A)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone32B:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\089\018\026\002\045\011\027\046\011\026\072\016\082\082\045\039\026\074\016\082\116\050\016\040")) then
		_Urwigo.MessageBox{
			Text = _IqY("\105\011\016\076\026\027\024\026\053\050\116\116\045\053\076\090\026\105\011\045\026\002\045\011\027\046\011\026\072\016\082\082\045\039\026\074\016\027\082\116\050\016\040\026\063\016\024\026\016\076\026\050\004\045\026\076\027\110\045\026\016\026\069\045\116\039\026\027\110\043\050\116\076\016\004\076\026\027\004\026\076\011\045\026\109\050\116\076\011\045\016\024\076\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\056\026\016\110\026\043\082\016\004\004\027\004\046\026\016\004\050\076\011\045\116\026\062\011\045\116\027\046\050\026\027\004\026\016\026\004\045\016\116\096\039\026\076\050\063\004\026\076\011\016\076\026\053\050\069\045\116\024\026\016\026\082\027\076\076\082\045\026\110\050\116\045\026\050\114\026\076\011\045\026\011\027\024\076\050\116\039\026\050\114\026\076\011\027\024\026\116\016\027\082\116\050\016\040\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone32C)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\062\045\082\082\026\039\050\048\026\063\050\048\082\040\026\011\016\069\045\026\096\045\045\004\026\063\016\027\076\027\004\046\026\114\050\116\026\076\011\016\076\026\076\116\016\027\004\026\114\050\116\026\016\026\069\045\116\039\026\082\050\004\046\026\076\027\110\045\078\026\035\050\048\116\026\016\004\024\063\045\116\026\027\024\026\004\050\076\026\053\050\116\116\045\053\076\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone32B)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone32C:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\036\018\026\093\070\003\066")) then
		_Urwigo.MessageBox{
			Text = _IqY("\035\050\048\026\016\116\045\026\053\050\116\116\045\053\076\075\026\004\050\063\026\096\016\053\049\026\076\050\026\076\011\045\026\120\048\045\024\076\027\050\004\026\076\011\016\076\026\053\016\048\024\045\040\026\039\050\048\026\076\011\027\024\026\040\045\082\016\039\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone32D)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\035\050\048\026\016\116\045\026\004\050\076\026\069\045\116\039\026\046\050\050\040\026\016\076\026\076\011\027\024\075\026\096\048\076\026\049\045\045\043\026\046\048\045\024\024\027\004\046\026\016\063\016\039\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone32C)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone32D:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\089\018\026\105\050\063\045\040\026\076\011\045\026\036\016\004\016\082\026\089\050\016\076\024")) then
		_Urwigo.MessageBox{
			Text = _IqY("\109\050\063\026\027\114\026\039\050\048\026\011\016\040\026\080\048\024\076\026\046\050\076\076\045\004\026\076\011\016\076\026\053\050\116\116\045\053\076\026\076\011\045\026\114\027\116\024\076\026\076\027\110\045\026\063\045\026\053\050\048\082\040\026\011\016\069\045\026\016\069\050\027\040\045\040\026\016\082\082\026\076\011\045\024\045\026\045\064\076\116\016\026\120\048\045\024\076\027\050\004\024\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\089\045\026\110\050\116\045\026\053\016\116\045\114\048\082\026\063\027\076\011\026\076\011\045\026\004\045\064\076\026\120\048\045\024\076\027\050\004\026\024\050\026\063\045\026\053\016\004\026\110\050\069\045\026\016\082\050\004\046\026\076\011\045\026\053\016\004\016\082\026\076\050\026\076\011\045\026\004\045\064\076\026\024\076\016\046\045\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone33)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\108\050\026\016\011\045\016\040\026\016\004\040\026\049\045\045\043\026\046\048\045\024\024\027\004\046\026\039\050\048\026\011\016\069\045\026\082\050\076\024\026\050\114\026\076\027\110\045\026\096\045\114\050\116\045\026\040\016\116\049\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone32D)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone33:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\065\018\026\105\011\045\026\002\027\096\045\116\076\039\026\089\045\082\082")) then
		_Urwigo.MessageBox{
			Text = _IqY("\035\045\043\026\076\011\016\076\026\027\024\026\053\050\116\116\045\053\076\026\016\004\040\026\024\050\110\045\076\011\027\004\046\026\056\026\040\027\040\026\004\050\076\026\049\004\050\063\026\043\116\027\050\116\026\076\050\026\024\076\016\116\076\027\004\046\026\076\011\027\024\026\053\016\116\076\116\027\040\046\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\056\026\016\110\026\024\050\026\045\064\053\027\076\045\040\026\076\050\026\011\016\069\045\026\082\045\016\116\004\045\040\026\024\050\110\045\076\011\027\004\046\026\004\045\063\026\011\045\116\045\026\076\011\016\076\026\056\026\016\110\026\024\045\004\040\027\004\046\026\039\050\048\026\050\004\026\039\050\048\116\026\063\016\039\026\076\050\026\076\011\045\026\004\045\064\076\026\024\076\016\046\045\078")
					}
				end
			end
		}
		objZone4Historicsign.Active = true
		objZone4Historicsign.Visible = true
		objZone3EdgeofParking.Active = false
		objZone3EdgeofParking.Visible = false
	else
		_Urwigo.MessageBox{
			Text = _IqY("\062\045\082\082\026\076\011\016\076\026\063\050\048\082\040\026\011\016\069\045\026\096\045\045\004\026\027\004\076\045\116\045\024\076\027\004\046\026\096\048\076\026\027\024\026\004\050\076\026\063\011\016\076\026\076\011\045\026\024\027\046\004\026\024\016\039\024\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\108\050\024\011\026\016\004\040\026\076\011\016\076\026\063\050\048\082\040\026\011\016\069\045\026\096\045\045\004\026\076\011\045\026\082\016\024\076\026\120\048\045\024\076\027\050\004\026\011\045\116\045\075\026\096\048\076\026\004\050\063\026\039\050\048\026\046\045\076\026\076\050\026\082\045\016\116\004\026\016\026\114\045\063\026\110\050\116\045\026\076\011\027\004\046\024\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone33A)
								end)
							end
						end
					}
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone33A:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\001\018\026\070")) then
		_Urwigo.MessageBox{
			Text = _IqY("\072\045\116\039\026\046\050\050\040\026\039\050\048\026\063\027\082\082\026\096\045\026\096\016\053\049\026\050\004\026\076\116\016\053\049\026\116\045\016\082\026\024\050\050\004\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\054\050\110\045\050\004\045\026\053\050\048\082\040\026\040\050\026\016\026\069\045\116\039\026\004\027\053\045\026\063\011\045\116\027\046\050\026\069\027\024\027\076\027\004\046\026\016\082\082\026\076\011\045\026\053\050\069\045\116\045\040\026\096\116\027\040\046\045\024\026\027\004\026\076\011\045\026\016\116\045\016\078\026\001\004\039\026\076\016\049\045\116\024\106\026\056\026\063\050\048\082\040\026\011\045\082\043\026\039\050\048\026\063\027\076\011\026\076\011\045\026\053\016\116\076\116\027\040\046\045\090"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone33C)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\062\045\082\082\026\056\026\016\110\026\048\024\027\004\046\026\076\011\045\026\027\004\114\116\050\110\016\076\027\050\004\026\050\004\026\076\011\045\026\024\027\046\004\026\114\050\116\026\076\011\027\024\026\050\004\045\078\026\062\011\050\026\049\004\050\063\024\026\076\011\045\116\045\026\110\016\039\026\011\016\069\045\026\096\045\045\004\026\024\050\110\045\026\053\011\016\004\046\045\024\026\040\048\045\026\076\050\026\116\045\053\045\004\076\026\114\082\050\050\040\024\075\026\096\048\076\026\046\050\026\063\027\076\011\026\076\011\045\026\024\027\046\004\026\043\082\045\016\024\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone33A)
					end)
				end
			end
		}
	end
end
function objZone33B:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\001\018\026\054\027\046\004\045\040\026\065\045\053\082\016\116\016\076\027\050\004\026\050\114\026\056\004\040\045\043\045\004\040\045\004\053\045")) then
		_Urwigo.MessageBox{
			Text = _IqY("\072\045\116\039\026\046\050\050\040\026\039\050\048\026\063\027\082\082\026\096\045\026\096\016\053\049\026\050\004\026\076\116\016\053\049\026\116\045\016\082\026\024\050\050\004\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone33C)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\108\048\045\024\024\026\039\045\076\026\016\046\016\027\004\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone33B)
					end)
				end
			end
		}
	end
end
function objZone33D:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\065\018\026\105\011\045\026\002\027\096\045\116\076\039\026\089\045\082\082")) then
		_Urwigo.MessageBox{
			Text = _IqY("\035\045\043\026\076\011\016\076\026\027\024\026\053\050\116\116\045\053\076\026\016\004\040\026\024\050\110\045\076\011\027\004\046\026\056\026\040\027\040\026\004\050\076\026\049\004\050\063\026\043\116\027\050\116\026\076\050\026\024\076\016\116\076\027\004\046\026\076\011\027\024\026\053\016\116\076\116\027\040\046\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\056\026\016\110\026\024\050\026\046\082\016\040\026\039\050\048\026\046\050\076\026\027\076\026\053\050\116\116\045\053\076\026\076\011\027\024\026\076\027\110\045\075\026\004\050\063\026\050\004\026\076\050\026\076\011\045\026\004\045\064\076\026\024\076\016\046\045\078")
					}
				end
			end
		}
		objZone4Historicsign.Active = true
		objZone4Historicsign.Visible = true
		objZone3EdgeofParking.Active = false
		objZone3EdgeofParking.Visible = false
	else
		_Urwigo.MessageBox{
			Text = _IqY("\062\045\082\082\026\076\011\016\076\026\063\050\048\082\040\026\011\016\069\045\026\096\045\045\004\026\027\004\076\045\116\045\024\076\027\004\046\026\096\048\076\026\027\024\026\004\050\076\026\063\011\016\076\026\076\011\045\026\024\027\046\004\026\024\016\039\024\078\026\105\116\039\026\001\046\016\027\004\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone33D)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone33C:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\036\018\026\065\045\053\045\110\096\045\116\026\007\034\075\026\093\070\034\093")) then
		_Urwigo.MessageBox{
			Text = _IqY("\025\116\045\076\076\039\026\114\048\004\004\039\026\076\011\016\076\026\027\076\026\063\016\024\026\004\016\110\045\040\026\050\004\026\036\011\116\027\024\076\110\016\024\026\045\069\045\090\026\013\049\075\026\004\050\063\026\096\016\053\049\026\076\050\026\076\011\045\026\120\048\045\024\076\027\050\004\026\039\050\048\026\110\027\024\024\045\040\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone33D)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\109\027\053\045\026\076\116\039\075\026\096\048\076\026\027\004\053\050\116\116\045\053\076\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone33C)
					end)
				end
			end
		}
	end
end
function objZone43:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\093\107\107\003")) then
		_Urwigo.MessageBox{
			Text = _IqY("\035\050\048\026\016\116\045\026\046\045\076\076\027\004\046\026\069\045\116\039\026\046\050\050\040\026\016\076\026\076\011\027\024\026\046\016\110\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\109\050\063\026\063\045\026\063\027\082\082\026\082\045\016\116\004\026\016\026\082\027\076\076\082\045\026\016\096\050\048\076\026\082\027\114\045\026\016\082\050\004\046\026\076\011\045\026\116\027\069\045\116\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone44)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\001\053\053\050\116\040\027\004\046\026\076\050\026\076\011\045\026\096\027\046\026\096\082\048\045\026\024\027\046\004\026\039\050\048\116\026\016\004\024\063\045\116\026\027\024\026\004\050\076\026\053\050\116\116\045\053\076\078\026\125\050\063\045\069\045\116\026\039\050\048\026\011\016\069\045\026\116\045\016\053\011\045\040\026\016\026\043\050\027\004\076\026\027\004\026\076\011\045\026\046\016\110\045\026\063\045\116\045\026\076\011\045\116\045\026\063\027\082\082\026\096\045\026\004\050\026\110\050\116\045\026\043\045\004\016\082\076\027\045\024\075\026\039\050\048\026\046\045\076\026\076\050\026\046\048\045\024\024\026\016\046\016\027\004\090\026\056\026\016\110\026\082\050\050\049\027\004\046\026\114\050\116\026\016\026\114\050\048\116\026\040\027\046\027\076\026\004\048\110\096\045\116\026\063\011\027\053\011\026\027\024\026\082\050\053\016\076\045\040\026\016\076\026\076\011\045\026\082\050\063\045\116\026\116\027\046\011\076\026\053\050\116\004\045\116\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone43)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone42:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\093\107\070\066")) then
		_Urwigo.MessageBox{
			Text = _IqY("\056\026\116\045\110\045\110\096\045\116\026\093\107\070\066\026\069\045\116\039\026\063\045\082\082\078\026\056\076\026\063\016\024\026\024\048\053\011\026\016\026\046\116\045\016\076\026\034\076\011\026\050\114\026\104\048\082\039\026\076\011\016\076\026\039\045\016\116\026\114\050\116\026\076\011\045\026\096\027\053\045\004\076\045\004\004\027\016\082\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone43)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\001\053\053\050\116\040\027\004\046\026\076\050\026\076\011\045\026\096\027\046\026\096\082\048\045\026\024\027\046\004\026\039\050\048\116\026\016\004\024\063\045\116\026\027\024\026\004\050\076\026\053\050\116\116\045\053\076\078\026\125\050\063\045\069\045\116\026\039\050\048\026\011\016\069\045\026\116\045\016\053\011\045\040\026\016\026\043\050\027\004\076\026\027\004\026\076\011\045\026\046\016\110\045\026\063\045\116\045\026\076\011\045\116\045\026\063\027\082\082\026\096\045\026\004\050\026\110\050\116\045\026\043\045\004\016\082\076\027\045\024\075\026\039\050\048\026\046\045\076\026\076\050\026\046\048\045\024\024\026\016\046\016\027\004\090\026\056\026\016\110\026\082\050\050\049\027\004\046\026\114\050\116\026\016\026\114\050\048\116\026\040\027\046\027\076\026\004\048\110\096\045\116\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone42)
					end)
				end
			end
		}
	end
end
function objZone41:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\034\070")) then
		_Urwigo.MessageBox{
			Text = _IqY("\072\045\116\039\026\046\050\050\040\090\026\035\050\048\026\049\004\050\063\026\011\050\063\026\082\050\004\046\026\027\076\026\063\050\048\082\040\026\076\016\049\045\026\027\004\026\076\050\040\016\039\024\026\063\050\116\082\040\026\076\050\026\096\048\027\082\040\026\024\050\110\045\011\076\027\004\046\026\076\011\027\024\026\096\027\046\106"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\105\011\045\026\053\016\004\016\082\026\096\045\053\016\110\045\026\049\004\050\063\004\026\016\024\026\076\011\045\026\082\016\116\046\045\024\076\026\053\016\043\016\053\027\076\039\026\016\004\040\026\082\050\004\046\045\024\076\026\116\048\004\004\027\004\046\026\076\050\063\043\016\076\011\026\053\016\004\016\082\026\027\004\026\001\110\045\116\027\053\016\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _IqY("\105\011\045\026\072\016\004\026\089\048\116\045\004\026\047\048\116\004\016\053\045\026\063\016\024\026\016\004\040\026\045\016\116\082\039\026\045\064\043\045\116\027\110\045\004\076\016\082\026\027\116\050\004\026\114\048\116\004\016\053\045\026\076\011\016\076\026\063\016\024\026\082\050\053\016\076\045\040\026\050\004\026\076\011\045\026\046\116\050\048\004\040\024\026\050\114\026\125\048\046\011\026\051\050\050\116\045\026\025\016\116\049\078\026\009\004\096\024\043\094\056\076\026\050\043\045\116\016\076\045\040\026\114\050\116\026\080\048\024\076\026\050\069\045\116\026\016\026\039\045\016\116\026\096\045\046\027\004\004\027\004\046\026\027\004\026\093\029\126\029\078"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.RunDialogs(function()
												Wherigo.GetInput(objZone42)
											end)
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\001\053\053\050\116\040\027\004\046\026\076\050\026\076\011\045\026\096\027\046\026\096\082\048\045\026\024\027\046\004\026\039\050\048\116\026\016\004\024\063\045\116\026\027\024\026\004\050\076\026\053\050\116\116\045\053\076\078\026\125\050\063\045\069\045\116\026\039\050\048\026\011\016\069\045\026\116\045\016\053\011\045\040\026\016\026\043\050\027\004\076\026\027\004\026\076\011\045\026\046\016\110\045\026\063\045\116\045\026\076\011\045\116\045\026\063\027\082\082\026\096\045\026\004\050\026\110\050\116\045\026\043\045\004\016\082\076\027\045\024\075\026\039\050\048\026\046\045\076\026\076\050\026\046\048\045\024\024\026\016\046\016\027\004\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone41)
					end)
				end
			end
		}
	end
end
function objZone46:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\089\018\026\001\026\076\027\004\039\026\053\016\096\027\004\026\050\004\026\076\011\045\026\096\050\016\076")) then
		_Urwigo.MessageBox{
			Text = _IqY("\105\011\016\076\026\027\024\026\053\050\116\116\045\053\076\094\026\076\011\045\039\026\045\069\045\004\026\076\116\016\040\045\040\026\016\004\076\011\116\016\053\027\076\045\026\114\050\116\026\114\050\050\040\075\026\024\048\043\043\082\027\045\024\026\016\004\040\026\024\045\116\069\027\053\045\024\026\016\024\026\076\011\045\039\026\110\050\069\045\040\026\016\053\116\050\024\024\026\076\011\045\026\053\016\004\016\082\026\045\082\027\110\027\004\016\076\027\004\046\026\076\011\045\026\004\045\045\040\026\114\050\116\026\024\011\050\043\043\027\004\046\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\054\050\026\056\026\046\048\045\024\024\026\082\027\069\045\026\011\045\116\045\026\063\016\024\026\043\116\045\076\076\039\026\116\050\048\046\011\026\114\050\116\026\045\069\045\116\039\050\004\045\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone47)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\054\050\116\116\039\026\096\048\076\026\039\050\048\026\053\016\004\026\114\027\004\040\026\076\011\045\026\016\004\024\063\045\116\026\076\050\026\076\011\027\024\026\050\004\026\123\105\011\045\026\036\016\004\016\082\045\116\113\024\026\002\027\114\045\026\024\027\046\004\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone46)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone45:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\065\018\026\093\093\026\043\078\110\078")) then
		_Urwigo.MessageBox{
			Text = _IqY("\105\011\016\076\026\040\050\045\024\026\004\050\076\026\024\050\048\004\040\026\082\027\049\045\026\016\026\046\116\045\016\076\026\024\011\027\114\076\026\076\050\026\110\045\078\026\001\046\016\027\004\026\076\011\045\024\045\026\046\048\039\024\026\063\050\048\082\040\026\063\050\116\049\026\066\026\040\016\039\024\026\016\026\063\045\045\049\078\026"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\089\048\076\026\056\026\096\045\076\026\076\011\045\026\096\050\016\076\026\053\016\043\076\027\016\004\024\026\011\016\040\026\016\026\110\048\053\011\026\096\045\076\076\045\116\026\082\027\114\045\026\016\004\040\026\016\026\082\050\076\026\096\045\076\076\045\116\026\043\016\039\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone46)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\054\050\116\116\039\026\096\048\076\026\039\050\048\026\053\016\004\026\114\027\004\040\026\076\011\045\026\016\004\024\063\045\116\026\076\050\026\076\011\027\024\026\050\004\026\123\105\011\045\026\036\016\004\016\082\045\116\113\024\026\002\027\114\045\026\024\027\046\004\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone45)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone44:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\093\029")) then
		_Urwigo.MessageBox{
			Text = _IqY("\105\011\016\076\026\027\024\026\053\050\116\116\045\053\076\026\076\011\045\039\026\116\016\004\026\076\011\045\026\082\050\053\049\024\026\093\029\026\011\050\048\116\024\026\016\026\040\016\039\026\024\027\064\026\040\016\039\024\026\016\026\063\045\045\049\078\026"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\105\011\045\039\026\063\045\116\045\026\004\050\076\026\043\016\027\040\026\096\039\026\076\011\045\026\011\050\048\116\026\096\048\076\026\096\039\026\076\050\004\024\026\040\045\082\027\069\045\116\045\040\078\026\105\011\045\039\026\063\045\116\045\026\043\116\050\069\027\040\045\040\026\016\026\011\050\048\024\045\026\039\045\016\116\026\116\050\048\004\040\026\016\004\040\026\043\016\027\040\026\050\004\082\039\026\040\048\116\027\004\046\026\050\043\045\116\016\076\027\050\004\016\082\026\110\050\004\076\011\024\078\026\051\016\004\039\026\063\050\116\049\045\040\026\050\076\011\045\116\026\080\050\096\024\026\063\011\027\082\045\026\076\011\045\027\116\026\050\082\040\045\116\026\053\011\027\082\040\116\045\004\026\116\016\004\026\076\011\045\026\082\050\053\049\024\078\026\105\011\045\026\063\050\110\016\004\026\050\114\076\045\004\026\076\050\050\049\026\027\004\026\082\016\048\004\040\116\039\026\027\004\026\045\064\053\011\016\004\046\045\026\114\050\116\026\046\050\050\040\024\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone45)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\056\026\016\110\026\024\050\116\116\039\026\096\048\076\026\076\011\016\076\026\027\024\026\004\050\076\026\063\011\016\076\026\056\026\116\045\016\040\078\026\105\011\027\024\026\004\048\110\096\045\116\026\027\024\026\004\050\063\026\076\011\045\026\082\045\046\016\082\026\016\046\045\026\076\050\026\069\050\076\045\026\027\004\026\050\048\116\026\053\050\048\004\076\116\039\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone44)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone47:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\036\018\026\051\048\082\045\024")) then
		_Urwigo.MessageBox{
			Text = _IqY("\105\011\016\076\026\027\024\026\053\050\116\116\045\053\076\078\026\105\011\045\039\026\048\024\045\040\026\076\063\050\026\110\048\082\045\024\026\063\016\082\049\027\004\046\026\027\004\026\024\027\004\046\082\045\026\114\027\082\045\026\076\050\026\043\048\082\082\026\076\011\045\026\096\050\016\076\024\078\026\105\011\045\039\026\048\024\045\040\026\076\011\027\024\026\110\045\076\011\050\040\026\076\011\045\026\045\004\076\027\116\045\026\076\027\110\045\026\076\011\045\026\053\016\004\016\082\026\050\043\045\116\016\076\045\040\078\026\105\011\045\039\026\043\116\045\114\045\116\116\045\040\026\110\048\082\045\024\026\076\050\026\011\050\116\024\045\026\096\045\053\016\048\024\045\026\076\011\045\039\026\096\045\082\027\045\069\045\040\026\076\011\045\039\026\063\045\116\045\026\110\050\116\045\026\027\004\076\045\082\082\027\046\045\004\076\026\016\004\040\026\011\016\040\026\110\050\116\045\026\024\076\116\045\004\046\076\011\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\035\050\048\026\011\016\069\045\026\040\050\004\045\026\063\045\082\082\026\011\045\116\045\026\016\004\040\026\027\076\026\027\024\026\076\027\110\045\026\076\050\026\110\050\069\045\026\050\004\026\048\043\026\076\011\045\026\076\116\016\027\082\026\076\050\063\016\116\040\026\039\050\048\116\026\114\027\004\016\082\026\046\050\016\082\078")
					}
					objZone5RailRoadSpike.Active = true
					objZone5RailRoadSpike.Visible = true
					objZone4Historicsign.Active = false
					objZone4Historicsign.Visible = false
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\054\050\116\116\039\026\096\048\076\026\039\050\048\026\053\016\004\026\114\027\004\040\026\076\011\045\026\016\004\024\063\045\116\026\076\050\026\076\011\027\024\026\050\004\026\123\105\011\045\026\036\016\004\016\082\045\116\113\024\026\002\027\114\045\026\024\027\046\004\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone47)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone61:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\089\018\026\093")) then
		_Urwigo.MessageBox{
			Text = _IqY("\035\045\043\026\056\026\024\045\045\026\050\004\045\026\050\082\040\026\063\050\050\040\045\004\026\053\016\004\016\082\026\096\050\016\076\026\024\076\048\053\049\026\040\050\063\004\026\076\011\045\116\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\056\026\063\050\004\040\045\116\026\027\114\026\076\011\016\076\026\063\016\024\026\050\004\045\026\050\114\026\076\011\045\026\082\016\024\076\026\050\043\045\116\016\076\027\004\046\026\096\050\016\076\024\026\076\011\016\076\026\114\045\082\082\026\069\027\053\076\027\110\026\076\050\026\076\011\045\026\114\082\050\050\040\026\050\114\026\093\107\034\007\106"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _IqY("\056\026\063\050\004\040\045\116\026\027\114\026\076\011\045\116\045\026\016\116\045\026\016\004\039\026\053\016\053\011\045\024\026\050\069\045\116\082\050\050\049\027\004\046\026\076\011\027\024\026\096\050\016\076\078\026\056\026\076\011\027\004\049\026\056\026\024\016\063\026\024\050\110\045\076\011\027\004\046\026\076\011\016\076\026\053\050\048\082\040\026\011\016\069\045\026\096\045\045\004\026\050\004\045\026\063\011\027\082\045\026\045\064\043\082\050\116\027\004\046\026\076\011\027\024\026\016\116\045\016\078"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _IqY("\062\045\082\082\026\027\114\026\039\050\048\026\016\116\045\026\046\050\027\004\046\026\076\050\026\114\027\004\040\026\016\082\082\026\076\011\050\024\045\026\050\076\011\045\116\026\053\016\053\011\045\024\026\063\045\026\096\045\076\076\045\116\026\046\045\076\026\110\050\069\027\004\046\078\026\105\011\045\026\004\045\064\076\026\024\076\050\043\026\027\024\026\080\048\024\076\026\016\026\024\011\050\116\076\026\040\027\024\076\016\004\053\045\026\016\063\016\039\078")
											}
											objZone7FullCircle.Active = true
											objZone7FullCircle.Visible = true
											objZone6LockTender.Active = false
											objZone6LockTender.Visible = false
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\061\004\082\045\024\024\026\076\011\045\116\045\026\011\016\024\026\096\045\045\004\026\016\004\050\076\011\045\116\026\046\116\045\016\076\026\114\082\050\050\040\026\056\026\040\050\026\004\050\076\026\076\011\027\004\049\026\076\011\016\076\026\027\024\026\053\050\116\116\045\053\076\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone61)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone74:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\089\018\026\047\082\050\050\040")) then
		_Urwigo.MessageBox{
			Text = _IqY("\036\050\116\116\045\053\076\075\026\016\026\114\082\050\050\040\026\040\045\024\076\116\050\039\045\040\026\076\011\045\026\076\116\050\082\082\045\039\026\016\004\040\026\076\011\045\026\043\016\116\049\026\063\016\024\026\016\096\050\004\040\050\004\045\040\078\026\024\011\050\116\076\082\039\026\016\114\076\045\116\026\076\011\016\076\026\076\011\045\026\116\027\040\045\024\026\063\045\116\045\026\040\027\024\110\016\004\076\082\045\040\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\105\011\045\116\045\026\016\116\045\026\024\076\027\082\082\026\016\026\114\045\063\026\114\050\048\004\040\016\076\027\050\004\024\026\082\045\114\076\026\050\004\026\076\011\045\026\027\024\082\016\004\040\026\114\116\050\110\026\027\076\024\026\040\016\039\024\026\016\024\026\096\050\076\011\026\016\004\040\026\016\110\048\024\045\110\045\004\076\026\043\016\116\049\026\016\004\040\026\114\116\050\110\026\076\011\045\026\027\053\045\026\027\004\040\048\024\076\116\039\078\026\056\026\040\050\026\096\045\082\027\045\069\045\026\076\011\045\116\045\026\027\024\026\024\076\027\082\082\026\016\026\053\016\053\011\045\026\050\048\076\026\076\011\045\116\045\026\076\011\016\076\026\027\024\026\050\004\082\039\026\016\053\053\045\024\024\016\096\082\045\026\096\039\026\096\050\016\076\078\026"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _IqY("\056\026\011\050\043\045\026\016\026\046\116\045\016\076\026\114\082\050\050\040\026\040\050\045\024\026\004\050\076\026\076\016\049\045\026\016\082\082\026\050\048\116\026\053\016\053\011\045\024\078"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _IqY("\062\045\082\082\026\056\026\011\050\043\045\026\039\050\048\026\011\016\069\045\026\045\004\080\050\039\045\040\026\039\050\048\116\026\076\050\048\116\026\050\114\026\076\011\045\026\027\024\082\016\004\040\075\026\027\076\026\027\024\026\076\027\110\045\026\076\050\026\011\045\016\040\026\096\016\053\049\026\076\050\063\016\116\040\026\076\011\045\026\043\016\116\049\027\004\046\026\016\116\045\016\075\026\114\050\082\082\050\063\027\004\046\026\076\011\045\026\004\050\116\076\011\045\116\004\026\043\016\076\011\026\114\116\050\110\026\076\011\045\026\002\050\053\049\076\045\004\040\045\116\024\026\011\050\048\024\045\026\076\050\026\024\045\016\116\053\011\026\114\050\116\026\076\011\045\026\114\027\004\016\082\026\053\016\053\011\045\026\053\050\004\076\016\027\004\045\116\078"), 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _IqY("\108\050\050\040\026\082\048\053\049\026\039\050\048\026\063\027\082\082\026\096\045\026\082\050\050\049\027\004\046\026\114\050\116\026\016\026\110\027\053\116\050\026\027\004\026\076\011\045\026\063\050\050\040\024\078")
														}
													end
												end
											}
										end
									end
								}
								objZoneFinalGZ.Active = true
								objZoneFinalGZ.Visible = true
								objZone7FullCircle.Active = false
								objZone7FullCircle.Visible = false
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\089\045\076\063\045\045\004\026\093\029\003\099\026\016\004\040\026\093\029\029\099\075\026\076\011\045\026\002\045\011\027\046\011\026\072\016\082\082\045\039\026\063\016\024\026\001\110\045\116\027\053\016\106\024\026\046\116\045\016\076\045\024\076\026\027\116\050\004\026\043\116\050\040\048\053\027\004\046\026\116\045\046\027\050\004\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\062\045\082\082\026\039\050\048\026\016\116\045\026\004\050\076\026\040\050\027\004\046\026\063\045\082\082\026\016\076\026\076\011\027\024\026\016\076\026\016\082\082\078\026\104\048\024\076\026\049\045\045\043\026\116\027\046\011\076\026\050\004\026\046\048\045\024\024\027\004\046\078\026\035\050\048\026\063\027\082\082\026\046\045\076\026\027\076\026\116\027\046\011\076\026\045\069\045\004\076\048\016\082\082\039\090"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone74)
								end)
							end
						end
					}
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone71:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\089\018\026\013\082\040\045\024\076\026\024\076\116\016\004\040\045\040\026\027\116\050\004\026\116\050\043\045\024\026\027\004\026\001\110\045\116\027\053\016")) then
		_Urwigo.MessageBox{
			Text = _IqY("\105\011\016\076\026\027\024\026\053\050\116\116\045\053\076\026\016\004\040\026\076\011\016\076\026\053\011\016\027\004\026\063\016\024\026\110\016\040\045\026\116\027\046\011\076\026\011\045\116\045\026\050\004\026\024\027\076\045\078\026"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\001\082\076\011\050\048\046\011\026\082\027\024\076\045\040\026\027\004\026\076\011\045\026\109\016\076\027\050\004\016\082\026\074\045\046\027\024\076\045\116\026\016\024\026\036\011\016\027\004\026\089\116\027\040\046\045\075\026\027\024\026\027\024\026\016\053\076\048\016\082\082\039\026\016\026\053\011\016\004\046\045\026\096\116\027\040\046\045\085\085\016\026\024\043\045\053\027\016\082\026\024\076\116\048\053\076\048\116\045\026\063\027\076\011\026\016\004\026\048\004\040\045\116\043\016\024\024\026\076\011\016\076\026\016\082\082\050\063\045\040\026\110\048\082\045\024\026\076\050\063\027\004\046\026\053\016\004\016\082\026\096\050\016\076\024\026\076\050\026\110\050\069\045\075\026\053\082\050\069\045\116\082\045\016\114\026\024\076\039\082\045\075\026\114\116\050\110\026\050\004\045\026\024\027\040\045\026\050\114\026\076\011\045\026\053\016\004\016\082\026\076\050\026\076\011\045\026\050\076\011\045\116\026\063\027\076\011\050\048\076\026\048\004\011\027\076\053\011\027\004\046\078\026"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _IqY("\105\011\045\026\040\016\110\026\039\050\048\026\024\045\045\026\040\050\063\004\116\027\069\045\116\026\114\116\050\110\026\011\045\116\045\026\063\016\024\026\050\116\027\046\016\004\082\082\039\026\016\026\036\011\016\027\004\026\065\016\110\026\016\004\040\026\063\016\024\026\040\045\024\027\046\004\045\040\026\076\050\026\053\116\045\016\076\045\026\016\026\054\082\016\053\049\063\016\076\045\116\026\043\050\050\082\026\050\114\026\063\016\076\045\116\026\076\011\016\076\026\045\004\016\096\082\045\040\026\076\011\045\026\096\050\016\076\024\026\076\050\026\110\016\049\045\026\076\011\045\026\053\116\050\024\024\027\004\046\026\011\045\116\045\078\026\056\076\026\011\016\024\026\024\027\004\053\045\026\096\045\045\004\026\116\045\043\082\016\053\045\040\026\096\039\026\016\026\053\050\004\053\116\045\076\045\026\040\016\110\078"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _IqY("\025\116\027\050\116\026\076\050\026\096\048\027\082\040\027\004\046\026\076\011\027\024\026\096\116\027\040\046\045\026\027\004\026\093\029\003\070\075\026\053\016\004\016\082\026\096\050\016\076\024\026\063\045\116\045\026\043\050\082\045\040\026\050\116\026\011\016\048\082\045\040\026\016\053\116\050\024\024\026\076\011\045\026\116\027\069\045\116\026\096\039\026\082\027\004\049\026\053\011\016\027\004\026\016\004\040\026\063\027\004\053\011\078\026\054\050\110\045\026\096\050\016\076\024\026\063\045\116\045\026\082\050\024\076\026\063\011\045\004\026\076\011\045\026\053\011\016\027\004\026\096\116\050\049\045\026\016\004\040\026\076\011\045\026\096\050\016\076\024\026\114\082\050\016\076\045\040\026\011\045\082\043\082\045\024\024\082\039\026\040\050\063\004\116\027\069\045\116\078"), 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _IqY("\002\036\009\016\110\043\094\109\026\063\016\024\026\076\011\045\026\114\027\116\024\076\026\001\110\045\116\027\053\016\004\026\053\050\110\043\016\004\039\026\076\050\026\110\016\024\024\085\043\116\050\040\048\053\045\026\063\116\050\048\046\011\076\026\027\116\050\004\026\063\027\116\045\026\116\050\043\045\078"), 
															Callback = function(action)
																if action ~= nil then
																	_Urwigo.MessageBox{
																		Text = _IqY("\109\050\063\026\063\045\026\063\027\082\082\026\082\050\050\049\026\016\026\082\027\076\076\082\045\026\110\050\116\045\026\016\076\026\076\011\045\026\027\024\082\016\004\040\026\027\076\024\045\082\114\078"), 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.RunDialogs(function()
																					Wherigo.GetInput(objZone72)
																				end)
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\074\045\016\082\082\039\075\026\056\026\040\050\026\004\050\076\026\076\011\027\004\049\026\024\050\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone71)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone73:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\036\018\026\105\116\050\082\082\045\039")) then
		_Urwigo.MessageBox{
			Text = _IqY("\035\045\043\075\026\096\045\027\004\046\026\050\004\026\016\004\026\027\024\082\016\004\040\026\082\027\110\027\076\045\040\026\004\050\116\110\016\082\026\016\053\053\045\024\024\026\024\050\026\016\026\076\116\050\082\082\045\039\026\063\016\024\026\076\011\045\026\096\045\024\076\026\063\016\039\026\050\048\076\026\076\011\045\116\045\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone74)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\062\045\082\082\026\039\050\048\026\016\116\045\026\004\050\076\026\040\050\027\004\046\026\063\045\082\082\026\016\076\026\076\011\027\024\026\016\076\026\016\082\082\078\026\104\048\024\076\026\049\045\045\043\026\116\027\046\011\076\026\050\004\026\046\048\045\024\024\027\004\046\078\026\035\050\048\026\063\027\082\082\026\046\045\076\026\027\076\026\116\027\046\011\076\026\045\069\045\004\076\048\016\082\082\039\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone73)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objZone72:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\036\018\026\054\110\027\076\011\024\026\056\024\082\016\004\040")) then
		_Urwigo.MessageBox{
			Text = _IqY("\105\011\016\076\024\026\116\027\046\011\076\026\016\004\040\026\076\011\027\024\026\027\024\082\016\004\040\026\063\016\024\026\069\045\116\039\026\027\110\043\050\116\076\016\004\076\026\076\050\026\076\011\045\026\076\050\063\043\016\076\011\090\026\105\011\027\024\026\063\016\024\026\076\011\045\026\050\004\082\039\026\024\043\050\076\026\050\004\026\076\011\027\024\026\053\016\004\016\082\026\076\011\016\076\026\076\011\045\026\096\050\016\076\024\026\053\116\050\024\024\045\040\026\076\011\045\026\116\027\069\045\116\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _IqY("\089\045\076\063\045\045\004\026\093\029\107\034\026\016\004\040\026\093\107\093\107\026\076\011\045\026\056\024\082\016\004\040\026\063\016\024\026\011\050\110\045\026\076\050\026\016\026\082\016\116\046\045\026\016\110\048\024\045\110\045\004\076\026\043\016\116\049\078\026\009\004\096\024\043\094\056\076\026\011\016\040\026\024\045\069\045\116\016\082\026\096\027\046\026\116\027\040\045\024\026\027\004\053\082\048\040\027\004\046\026\016\026\116\050\082\082\045\116\026\053\050\016\024\076\045\116\078\026\105\011\045\116\045\026\063\045\116\045\026\016\116\053\016\040\045\024\026\016\026\040\016\004\053\045\026\043\016\069\027\082\082\027\050\004\026\016\004\040\026\016\026\053\016\110\043\046\116\050\048\004\040\078"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objZone73)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _IqY("\054\050\116\116\039\026\096\048\076\026\039\050\048\026\053\016\004\026\114\027\004\040\026\076\011\045\026\016\004\024\063\045\116\026\076\050\026\076\011\027\024\026\050\004\026\076\011\045\026\047\048\082\082\026\036\027\116\053\082\045\026\024\027\046\004\024\078"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objZone72)
					end)
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objFinal:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _IqY("\035\045\024")) then
		_Urwigo.MessageBox{
			Text = _IqY("\105\011\016\004\049\026\039\050\048\026\114\050\116\026\043\082\016\039\027\004\046\026\039\050\048\116\026\046\016\110\045\026\027\024\026\004\050\063\026\053\050\110\043\082\045\076\045\090")
		}
		objZoneFinalGZ.Active = false
		objZoneFinalGZ.Visible = false
		objLehighCanalattheLVGGPWherigoTour.Complete = true
		Wherigo.Command "SaveClose"
	else
		_Urwigo.MessageBox{
			Text = _IqY("\025\082\045\016\024\045\026\063\116\027\076\045\026\040\050\063\004\026\076\011\027\024\026\053\050\040\045\090"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = string.sub(Player.CompletionCode, 1, 15), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objFinal)
								end)
							end
						end
					}
				end
			end
		}
	end
	objLehighCanalattheLVGGPWherigoTour:RequestSync()
end
function objName:OnTick()
	if _G[_IqY("\025\082\016\039\045\116")][_IqY("\025\050\024\027\076\027\050\004\001\053\053\048\116\016\053\039")][_IqY("\108\045\076\072\016\082\048\045")](_G[_IqY("\025\082\016\039\045\116")][_IqY("\025\050\024\027\076\027\050\004\001\053\053\048\116\016\053\039")], _IqY("\110")) == 3 then
		for k, v in pairs(_G[_IqY("\050\096\080\002\045\011\027\046\011\036\016\004\016\082\016\076\076\011\045\002\072\108\108\025\062\011\045\116\027\046\050\105\050\048\116")][_IqY("\001\082\082\086\013\096\080\045\053\076\024")]) do
			v[_IqY("\072\027\024\027\096\082\045")] = false
			v[_IqY("\001\053\076\027\069\045")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_IqY("\054\050\116\116\039\026\076\011\027\024\026\046\016\110\045\026\053\016\004\004\050\076\026\096\045\026\043\082\016\039\045\040\026\027\004\026\024\027\110\048\082\016\076\027\050\004")), 
			Callback = function(action)
				if action ~= nil then
					_G[_IqY("\062\011\045\116\027\046\050")][_IqY("\036\050\110\110\016\004\040")](_IqY("\054\016\069\045\036\082\050\024\045"))
				end
			end
		}
		return
	end
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return objLehighCanalattheLVGGPWherigoTour
