require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

_Gpst = Wherigo.ZCartridge()

-- String decode --
function _nLZ(str)
	local res = ""
    local dtable = "\071\046\064\062\031\074\067\123\048\050\034\073\011\110\001\036\023\013\009\028\039\055\085\069\054\042\037\003\088\120\068\038\065\020\091\030\012\096\095\029\116\097\124\019\112\113\114\044\060\005\052\117\021\098\115\007\080\015\061\026\083\118\107\102\094\092\084\104\082\041\119\057\033\024\125\053\047\027\066\040\051\108\043\109\077\093\087\078\000\121\049\045\100\014\076\010\004\058\002\063\089\122\032\105\070\103\072\018\008\006\079\059\022\081\090\086\016\017\075\035\111\025\099\106\056\126\101"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
_ryKjm = Wherigo.ZMedia(_Gpst)
_ryKjm.Id = "5fa6928f-55de-4bc2-bdaa-d666ecf9b0f3"
_ryKjm.Name = _nLZ("\115\121\014\127\103\091")
_ryKjm.Description = ""
_ryKjm.AltText = ""
_ryKjm.Resources = {
	{
		Type = "jpg", 
		Filename = "zone1.jpg", 
		Directives = {}
	}
}
_tH4 = Wherigo.ZMedia(_Gpst)
_tH4.Id = "e82e6beb-011d-49a3-9b6d-47cb33619c36"
_tH4.Name = _nLZ("\115\121\014\127\103\010")
_tH4.Description = ""
_tH4.AltText = ""
_tH4.Resources = {
	{
		Type = "jpg", 
		Filename = "Zone2.jpg", 
		Directives = {}
	}
}
_a5kg = Wherigo.ZMedia(_Gpst)
_a5kg.Id = "93524c5d-afa5-4504-8505-73403d15540e"
_a5kg.Name = _nLZ("\115\121\014\127\103\081")
_a5kg.Description = ""
_a5kg.AltText = ""
_a5kg.Resources = {
	{
		Type = "jpg", 
		Filename = "Zone3.jpg", 
		Directives = {}
	}
}
_3lmqD = Wherigo.ZMedia(_Gpst)
_3lmqD.Id = "6ae52ae6-2609-4cd9-b4a6-6c81e60042a7"
_3lmqD.Name = _nLZ("\115\121\014\127\103\051")
_3lmqD.Description = ""
_3lmqD.AltText = ""
_3lmqD.Resources = {
	{
		Type = "jpg", 
		Filename = "Zone4.jpg", 
		Directives = {}
	}
}
_DfHv = Wherigo.ZMedia(_Gpst)
_DfHv.Id = "e933e7ee-9490-49d4-b531-1f203a723597"
_DfHv.Name = _nLZ("\007\042\123\068\127\103\091")
_DfHv.Description = ""
_DfHv.AltText = ""
_DfHv.Resources = {
	{
		Type = "jpg", 
		Filename = "cache1.jpg", 
		Directives = {}
	}
}
_SyR = Wherigo.ZMedia(_Gpst)
_SyR.Id = "9f976a7a-95c2-4899-a05e-84bd7b01b6c1"
_SyR.Name = _nLZ("\115\121\014\127\103\076")
_SyR.Description = ""
_SyR.AltText = ""
_SyR.Resources = {
	{
		Type = "jpg", 
		Filename = "zone5.jpg", 
		Directives = {}
	}
}
_X3f = Wherigo.ZMedia(_Gpst)
_X3f.Id = "787fe75b-e71f-42b5-a598-7adabb0ca54c"
_X3f.Name = _nLZ("\115\121\014\127\103\025")
_X3f.Description = ""
_X3f.AltText = ""
_X3f.Resources = {
	{
		Type = "jpg", 
		Filename = "zone6.jpg", 
		Directives = {}
	}
}
_XcW = Wherigo.ZMedia(_Gpst)
_XcW.Id = "850b7c00-14d7-422a-8c05-71c1f66a83ed"
_XcW.Name = _nLZ("\115\121\014\127\103\032\014\054\055\045\112\072")
_XcW.Description = ""
_XcW.AltText = ""
_XcW.Resources = {
	{
		Type = "jpg", 
		Filename = "zone9.jpg", 
		Directives = {}
	}
}
_sL0j = Wherigo.ZMedia(_Gpst)
_sL0j.Id = "c54d89f2-289a-4378-90a3-61aeb1f0afdd"
_sL0j.Name = _nLZ("\084\127\055\055\042\106\127")
_sL0j.Description = ""
_sL0j.AltText = ""
_sL0j.Resources = {
	{
		Type = "jpg", 
		Filename = "message.jpg", 
		Directives = {}
	}
}
_mKm = Wherigo.ZMedia(_Gpst)
_mKm.Id = "641a4bd5-3da8-4751-a288-78bcbca4d46c"
_mKm.Name = _nLZ("\007\042\084\045")
_mKm.Description = ""
_mKm.AltText = ""
_mKm.Resources = {
	{
		Type = "jpg", 
		Filename = "camp.jpg", 
		Directives = {}
	}
}
_FgT = Wherigo.ZMedia(_Gpst)
_FgT.Id = "5242ad95-15af-481c-8608-d95ea5458677"
_FgT.Name = _nLZ("\115\121\014\127\103\125")
_FgT.Description = ""
_FgT.AltText = ""
_FgT.Resources = {
	{
		Type = "jpg", 
		Filename = "zone8.jpg", 
		Directives = {}
	}
}
_dc1 = Wherigo.ZMedia(_Gpst)
_dc1.Id = "8a84f56d-0166-46c3-b049-6f169515298f"
_dc1.Name = _nLZ("\115\121\014\127\103\022")
_dc1.Description = ""
_dc1.AltText = ""
_dc1.Resources = {
	{
		Type = "jpg", 
		Filename = "zone7.jpg", 
		Directives = {}
	}
}
_Ytd = Wherigo.ZMedia(_Gpst)
_Ytd.Id = "64b95951-87c6-4e27-bb91-29c035a96c92"
_Ytd.Name = _nLZ("\007\042\123\068\127\103\010")
_Ytd.Description = ""
_Ytd.AltText = ""
_Ytd.Resources = {
	{
		Type = "jpg", 
		Filename = "cache2.jpg", 
		Directives = {}
	}
}
_bt61J = Wherigo.ZMedia(_Gpst)
_bt61J.Id = "c68db232-0f3c-4d81-b9d9-68e404a8c03c"
_bt61J.Name = _nLZ("\007\042\123\068\127\103\081")
_bt61J.Description = ""
_bt61J.AltText = ""
_bt61J.Resources = {
	{
		Type = "jpg", 
		Filename = "cache3.jpg", 
		Directives = {}
	}
}
_iZ9t = Wherigo.ZMedia(_Gpst)
_iZ9t.Id = "e6115a06-563b-4ea7-8549-fa3b8bd5089a"
_iZ9t.Name = _nLZ("\061\045\121\104\082\127\047\103\123\042\123\068\127\103\091")
_iZ9t.Description = ""
_iZ9t.AltText = ""
_iZ9t.Resources = {
	{
		Type = "jpg", 
		Filename = "spoilercache1.jpg", 
		Directives = {}
	}
}
_g15PF = Wherigo.ZMedia(_Gpst)
_g15PF.Id = "664df74d-1f13-4735-8225-bc67226a88ef"
_g15PF.Name = _nLZ("\061\045\121\104\082\127\047\103\123\042\123\068\127\103\010")
_g15PF.Description = ""
_g15PF.AltText = ""
_g15PF.Resources = {
	{
		Type = "jpg", 
		Filename = "spoilercache2.jpg", 
		Directives = {}
	}
}
_v58i = Wherigo.ZMedia(_Gpst)
_v58i.Id = "29df6170-749b-46a8-ae3f-4a11a0eac1f4"
_v58i.Name = _nLZ("\061\045\121\104\082\127\047\103\123\042\123\068\127\103\081")
_v58i.Description = ""
_v58i.AltText = ""
_v58i.Resources = {
	{
		Type = "jpg", 
		Filename = "spoilercache3.jpg", 
		Directives = {}
	}
}
_ns9 = Wherigo.ZMedia(_Gpst)
_ns9.Id = "de61c437-4d1a-42f1-a0af-94bef7824550"
_ns9.Name = _nLZ("\045\042\047\063\104\014\106")
_ns9.Description = ""
_ns9.AltText = ""
_ns9.Resources = {
	{
		Type = "jpg", 
		Filename = "parking.jpg", 
		Directives = {}
	}
}
_T1q4_ = Wherigo.ZMedia(_Gpst)
_T1q4_.Id = "389264cd-e693-4d0c-b7e4-8f7ced49ae5b"
_T1q4_.Name = _nLZ("\055\127\082\127\123\041\127\052\047\103\093\127\103\082\042\014\106\052\127\055")
_T1q4_.Description = ""
_T1q4_.AltText = ""
_T1q4_.Resources = {
	{
		Type = "jpg", 
		Filename = "flags.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_Gpst.Id="2a4b2c55-219f-42c1-b9ae-c90baa544a1e"
_Gpst.Name="Gurs: le camp d'internement "
_Gpst.Description=[[Gurs, une drole de syllabe,
comme un sanglot
qui ne sort pas de la gorge.
 Louis Aragon]]
_Gpst.Visible=true
_Gpst.Activity="TourGuide"
_Gpst.StartingLocationDescription=[[]]
_Gpst.StartingLocation = ZonePoint(43.2729430581548,-0.740790052743918,0)
_Gpst.Version=""
_Gpst.Company=""
_Gpst.Author=""
_Gpst.BuilderVersion="URWIGO 1.12.4091.37853"
_Gpst.CreateDate="01/14/2011 20:24:46"
_Gpst.PublishDate="1/1/0001 12:00:00 AM"
_Gpst.UpdateDate="06/02/2011 17:41:00"
_Gpst.LastPlayedDate="1/1/0001 12:00:00 AM"
_Gpst.TargetDevice="PocketPC"
_Gpst.TargetDeviceVersion="0"
_Gpst.StateId="1"
_Gpst.CountryId="2"
_Gpst.Complete=false
_Gpst.UseLogging=true

_Gpst.Media=_mKm

_Gpst.Icon=_sL0j


-- Zones --
_SHqsd = Wherigo.Zone(_Gpst)
_SHqsd.Id = "12ae8659-5e27-4aa0-9424-3293874a1058"
_SHqsd.Name = _nLZ("\115\121\014\127\103\091")
_SHqsd.Description = ""
_SHqsd.Visible = true
_SHqsd.Media = _ryKjm
_SHqsd.Commands = {}
_SHqsd.DistanceRange = Distance(-1, "feet")
_SHqsd.ShowObjects = "OnEnter"
_SHqsd.ProximityRange = Distance(60, "meters")
_SHqsd.AllowSetPositionTo = false
_SHqsd.Active = false
_SHqsd.Points = {
	ZonePoint(43.2729284113497, -0.740851743551261, 0), 
	ZonePoint(43.2728971648204, -0.740806145998008, 0), 
	ZonePoint(43.2728717770035, -0.740875883432395, 0), 
	ZonePoint(43.2729010706374, -0.740956349702842, 0), 
	ZonePoint(43.2729635636759, -0.740902705522544, 0)
}
_SHqsd.OriginalPoint = ZonePoint(43.2729123974974, -0.74087856564141, 0)
_SHqsd.DistanceRangeUOM = "Feet"
_SHqsd.ProximityRangeUOM = "Meters"
_SHqsd.OutOfRangeName = ""
_SHqsd.InRangeName = ""
_JKC = Wherigo.Zone(_Gpst)
_JKC.Id = "cf35766a-d8ce-4b42-a6a6-630a00f6d4fd"
_JKC.Name = _nLZ("\115\121\014\127\103\010")
_JKC.Description = ""
_JKC.Visible = false
_JKC.Media = _tH4
_JKC.Commands = {}
_JKC.DistanceRange = Distance(-1, "feet")
_JKC.ShowObjects = "OnEnter"
_JKC.ProximityRange = Distance(60, "meters")
_JKC.AllowSetPositionTo = false
_JKC.Active = false
_JKC.Points = {
	ZonePoint(43.271876, -0.739605, 0), 
	ZonePoint(43.2719355646821, -0.739550014715198, 0), 
	ZonePoint(43.2718554941124, -0.73950709937096, 0), 
	ZonePoint(43.271791046992, -0.739563425760272, 0), 
	ZonePoint(43.2718340117465, -0.739721676092151, 0), 
	ZonePoint(43.2719062705834, -0.739689489583972, 0), 
	ZonePoint(43.2719589999508, -0.739646574239734, 0), 
	ZonePoint(43.2719277529238, -0.739560743551257, 0)
}
_JKC.OriginalPoint = ZonePoint(43.2718856426239, -0.739605502914193, 0)
_JKC.DistanceRangeUOM = "Feet"
_JKC.ProximityRangeUOM = "Meters"
_JKC.OutOfRangeName = ""
_JKC.InRangeName = ""
_flBN = Wherigo.Zone(_Gpst)
_flBN.Id = "f2d212f7-ad28-4328-b9ce-22cd8f321f54"
_flBN.Name = _nLZ("\115\121\014\127\103\081")
_flBN.Description = ""
_flBN.Visible = false
_flBN.Media = _a5kg
_flBN.Commands = {}
_flBN.DistanceRange = Distance(-1, "feet")
_flBN.ShowObjects = "OnEnter"
_flBN.ProximityRange = Distance(60, "meters")
_flBN.AllowSetPositionTo = false
_flBN.Active = false
_flBN.Points = {
	ZonePoint(43.271662, -0.739314, 0), 
	ZonePoint(43.2716805530052, -0.739371667493827, 0), 
	ZonePoint(43.2717391414057, -0.739315341104514, 0), 
	ZonePoint(43.2717059413191, -0.739232192625052, 0), 
	ZonePoint(43.2716395410914, -0.739213417161948, 0), 
	ZonePoint(43.2716063409504, -0.73928583680535, 0), 
	ZonePoint(43.2716082939003, -0.739358256448752, 0), 
	ZonePoint(43.2716766471099, -0.739368985284812, 0)
}
_flBN.OriginalPoint = ZonePoint(43.2716648073477, -0.739307462115532, 0)
_flBN.DistanceRangeUOM = "Feet"
_flBN.ProximityRangeUOM = "Meters"
_flBN.OutOfRangeName = ""
_flBN.InRangeName = ""
_jxu9 = Wherigo.Zone(_Gpst)
_jxu9.Id = "2b5a1144-54e4-471b-ac11-578b3dcfa4b4"
_jxu9.Name = _nLZ("\115\121\014\127\103\051")
_jxu9.Description = ""
_jxu9.Visible = false
_jxu9.Media = _3lmqD
_jxu9.Commands = {}
_jxu9.DistanceRange = Distance(-1, "feet")
_jxu9.ShowObjects = "OnEnter"
_jxu9.ProximityRange = Distance(60, "meters")
_jxu9.AllowSetPositionTo = false
_jxu9.Active = false
_jxu9.Points = {
	ZonePoint(43.27175, -0.739174, 0), 
	ZonePoint(43.2717626941437, -0.739250442956918, 0), 
	ZonePoint(43.2717060587128, -0.739175341104501, 0), 
	ZonePoint(43.2717216822852, -0.739094874834054, 0), 
	ZonePoint(43.2717724588679, -0.739100239252084, 0), 
	ZonePoint(43.2718271412942, -0.739140472387307, 0), 
	ZonePoint(43.2718310471799, -0.739210209821695, 0), 
	ZonePoint(43.2718154236355, -0.739261171792978, 0), 
	ZonePoint(43.2717724588679, -0.739285311674112, 0)
}
_jxu9.OriginalPoint = ZonePoint(43.2717732183319, -0.739188007091517, 0)
_jxu9.DistanceRangeUOM = "Feet"
_jxu9.ProximityRangeUOM = "Meters"
_jxu9.OutOfRangeName = ""
_jxu9.InRangeName = ""
_AhQ5 = Wherigo.Zone(_Gpst)
_AhQ5.Id = "6b1311d8-714d-4962-8ca0-72f856a607c2"
_AhQ5.Name = _nLZ("\007\042\123\068\127\103\091")
_AhQ5.Description = ""
_AhQ5.Visible = false
_AhQ5.Media = _DfHv
_AhQ5.Commands = {}
_AhQ5.DistanceRange = Distance(-1, "feet")
_AhQ5.ShowObjects = "OnEnter"
_AhQ5.ProximityRange = Distance(60, "meters")
_AhQ5.AllowSetPositionTo = false
_AhQ5.Active = false
_AhQ5.Points = {
	ZonePoint(43.271789, -0.739045, 0), 
	ZonePoint(43.2718388000553, -0.739083892030707, 0), 
	ZonePoint(43.2718563765356, -0.739011472387305, 0), 
	ZonePoint(43.2718075529665, -0.738944417161933, 0), 
	ZonePoint(43.2717372469582, -0.738984650297156, 0), 
	ZonePoint(43.2717352940124, -0.739067798776618, 0), 
	ZonePoint(43.2718212235698, -0.739073163194648, 0)
}
_AhQ5.OriginalPoint = ZonePoint(43.2717979277283, -0.739030056264052, 0)
_AhQ5.DistanceRangeUOM = "Feet"
_AhQ5.ProximityRangeUOM = "Meters"
_AhQ5.OutOfRangeName = ""
_AhQ5.InRangeName = ""
_N3K = Wherigo.Zone(_Gpst)
_N3K.Id = "ff4fe8a9-1adf-4a9f-b9a9-174e01b2ce31"
_N3K.Name = _nLZ("\115\121\014\127\103\076")
_N3K.Description = ""
_N3K.Visible = false
_N3K.Media = _SyR
_N3K.Commands = {}
_N3K.DistanceRange = Distance(-1, "feet")
_N3K.ShowObjects = "OnEnter"
_N3K.ProximityRange = Distance(60, "meters")
_N3K.AllowSetPositionTo = false
_N3K.Active = false
_N3K.Points = {
	ZonePoint(43.271553, -0.73876, 0), 
	ZonePoint(43.2715754589406, -0.738798892030708, 0), 
	ZonePoint(43.2716028002484, -0.738769387731544, 0), 
	ZonePoint(43.2715910825465, -0.738715743551246, 0), 
	ZonePoint(43.2715559294275, -0.738713061342231, 0), 
	ZonePoint(43.2715149174296, -0.738747930059425, 0), 
	ZonePoint(43.2715266351461, -0.738780116567603, 0), 
	ZonePoint(43.2715710648007, -0.738794198164932, 0)
}
_N3K.OriginalPoint = ZonePoint(43.2715613610674, -0.738759916180961, 0)
_N3K.DistanceRangeUOM = "Feet"
_N3K.ProximityRangeUOM = "Meters"
_N3K.OutOfRangeName = ""
_N3K.InRangeName = ""
_sJet8 = Wherigo.Zone(_Gpst)
_sJet8.Id = "0fc7e150-3eb2-4dd2-8a15-42577e4354f7"
_sJet8.Name = _nLZ("\115\121\014\127\103\025")
_sJet8.Description = ""
_sJet8.Visible = true
_sJet8.Media = _X3f
_sJet8.Commands = {}
_sJet8.DistanceRange = Distance(-1, "feet")
_sJet8.ShowObjects = "OnEnter"
_sJet8.ProximityRange = Distance(10, "meters")
_sJet8.AllowSetPositionTo = false
_sJet8.Active = false
_sJet8.Points = {
	ZonePoint(43.271343, -0.738553, 0), 
	ZonePoint(43.27104, -0.738526, 0), 
	ZonePoint(43.2710850635948, -0.738374544145577, 0), 
	ZonePoint(43.2712159122251, -0.738355768682473, 0), 
	ZonePoint(43.2713506664906, -0.738398684026711, 0), 
	ZonePoint(43.2714248788573, -0.738489879133217, 0), 
	ZonePoint(43.2714678438703, -0.738567663194649, 0), 
	ZonePoint(43.2714365965911, -0.738674951555245, 0), 
	ZonePoint(43.2713662901543, -0.73867226934623, 0), 
	ZonePoint(43.2712725481122, -0.738648129465096, 0), 
	ZonePoint(43.2712041944488, -0.738621307374947, 0), 
	ZonePoint(43.2711319347783, -0.738581074239724, 0), 
	ZonePoint(43.2710206156586, -0.738524747850411, 0), 
	ZonePoint(43.270999132998, -0.738527430059426, 0)
}
_sJet8.OriginalPoint = ZonePoint(43.2712399055557, -0.738536817790979, 0)
_sJet8.DistanceRangeUOM = "Feet"
_sJet8.ProximityRangeUOM = "Meters"
_sJet8.OutOfRangeName = ""
_sJet8.InRangeName = ""
_tOwB = Wherigo.Zone(_Gpst)
_tOwB.Id = "14fda698-40f4-4f4c-b932-101627cf20f4"
_tOwB.Name = _nLZ("\115\121\014\127\103\022")
_tOwB.Description = ""
_tOwB.Visible = false
_tOwB.Media = _dc1
_tOwB.Commands = {}
_tOwB.DistanceRange = Distance(-1, "feet")
_tOwB.ShowObjects = "OnEnter"
_tOwB.ProximityRange = Distance(60, "meters")
_tOwB.AllowSetPositionTo = false
_tOwB.Active = false
_tOwB.Points = {
	ZonePoint(43.270938, -0.738379, 0), 
	ZonePoint(43.2705238839565, -0.738070459489821, 0), 
	ZonePoint(43.2705746615385, -0.737912209157943, 0), 
	ZonePoint(43.2706937933915, -0.737896115903853, 0), 
	ZonePoint(43.2708305017879, -0.738024861936568, 0), 
	ZonePoint(43.270932056398, -0.738121421461104, 0), 
	ZonePoint(43.2709925984887, -0.73821798098564, 0), 
	ZonePoint(43.2710277519331, -0.738282354001998, 0), 
	ZonePoint(43.2710238459958, -0.738386960153579, 0), 
	ZonePoint(43.2709828336394, -0.738499612932204, 0), 
	ZonePoint(43.270922291539, -0.738504977350234, 0), 
	ZonePoint(43.2708539374822, -0.738464744215011, 0), 
	ZonePoint(43.2707914422774, -0.738411100034713, 0), 
	ZonePoint(43.2706976993499, -0.73834404480934, 0), 
	ZonePoint(43.2706469218706, -0.738295765047072, 0), 
	ZonePoint(43.270586379436, -0.738226027612685, 0), 
	ZonePoint(43.270496542164, -0.738043637399672, 0)
}
_tOwB.OriginalPoint = ZonePoint(43.2707950083087, -0.738240074852437, 0)
_tOwB.DistanceRangeUOM = "Feet"
_tOwB.ProximityRangeUOM = "Meters"
_tOwB.OutOfRangeName = ""
_tOwB.InRangeName = ""
_WtF = Wherigo.Zone(_Gpst)
_WtF.Id = "462196f7-6682-458a-8f33-20dc4170bc95"
_WtF.Name = _nLZ("\115\121\014\127\103\125")
_WtF.Description = ""
_WtF.Visible = false
_WtF.Media = _FgT
_WtF.Commands = {}
_WtF.DistanceRange = Distance(-1, "feet")
_WtF.ShowObjects = "OnEnter"
_WtF.ProximityRange = Distance(60, "meters")
_WtF.AllowSetPositionTo = false
_WtF.Active = false
_WtF.Points = {
	ZonePoint(43.270294, -0.737556, 0), 
	ZonePoint(43.2703633311806, -0.737533201223366, 0), 
	ZonePoint(43.2703594252007, -0.737627078538887, 0), 
	ZonePoint(43.2702832585424, -0.737627078538887, 0), 
	ZonePoint(43.270228574729, -0.73755197668647, 0), 
	ZonePoint(43.2702441986807, -0.737460781579964, 0), 
	ZonePoint(43.2703066944474, -0.737439323907845, 0), 
	ZonePoint(43.2703574722106, -0.737530519014351, 0)
}
_WtF.OriginalPoint = ZonePoint(43.2703046193739, -0.737540744936221, 0)
_WtF.DistanceRangeUOM = "Feet"
_WtF.ProximityRangeUOM = "Meters"
_WtF.OutOfRangeName = ""
_WtF.InRangeName = ""
_cc2uF = Wherigo.Zone(_Gpst)
_cc2uF.Id = "48cefec9-6a86-4a2b-8774-9ccc22f83da5"
_cc2uF.Name = _nLZ("\115\121\014\127\103\072")
_cc2uF.Description = ""
_cc2uF.Visible = false
_cc2uF.Media = _XcW
_cc2uF.Commands = {}
_cc2uF.DistanceRange = Distance(-1, "feet")
_cc2uF.ShowObjects = "OnEnter"
_cc2uF.ProximityRange = Distance(60, "meters")
_cc2uF.AllowSetPositionTo = false
_cc2uF.Active = false
_cc2uF.Points = {
	ZonePoint(43.270127, -0.737756, 0), 
	ZonePoint(43.2701572714533, -0.737829760747903, 0), 
	ZonePoint(43.2700771985441, -0.737819031911844, 0), 
	ZonePoint(43.2700518095509, -0.737735883432382, 0), 
	ZonePoint(43.2700986815301, -0.737647370534891, 0), 
	ZonePoint(43.2701611774462, -0.737660781579965, 0), 
	ZonePoint(43.2701963313708, -0.737727836805337, 0), 
	ZonePoint(43.2701514124635, -0.737827078538889, 0)
}
_cc2uF.OriginalPoint = ZonePoint(43.2701276102949, -0.737750467943901, 0)
_cc2uF.DistanceRangeUOM = "Feet"
_cc2uF.ProximityRangeUOM = "Meters"
_cc2uF.OutOfRangeName = ""
_cc2uF.InRangeName = ""
_C76H = Wherigo.Zone(_Gpst)
_C76H.Id = "16027ca0-dc8f-4cb5-92ff-ac61cc3025b8"
_C76H.Name = _nLZ("\007\042\123\068\127\103\010")
_C76H.Description = ""
_C76H.Visible = false
_C76H.Media = _Ytd
_C76H.Commands = {}
_C76H.DistanceRange = Distance(-1, "feet")
_C76H.ShowObjects = "OnEnter"
_C76H.ProximityRange = Distance(60, "meters")
_C76H.AllowSetPositionTo = false
_C76H.Active = false
_C76H.Points = {
	ZonePoint(43.270518, -0.737799, 0), 
	ZonePoint(43.2704877287261, -0.737866055225367, 0), 
	ZonePoint(43.2704369510716, -0.737811069940562, 0), 
	ZonePoint(43.2704330450964, -0.737693052743906, 0), 
	ZonePoint(43.2704955406692, -0.737674277280802, 0), 
	ZonePoint(43.2705463182749, -0.737701099370951, 0), 
	ZonePoint(43.2705931898732, -0.737749379133219, 0), 
	ZonePoint(43.2705990488205, -0.737835209821696, 0), 
	ZonePoint(43.270573660045, -0.737894218420023, 0), 
	ZonePoint(43.270536553354, -0.737931769346232, 0), 
	ZonePoint(43.270468198864, -0.737892877315516, 0)
}
_C76H.OriginalPoint = ZonePoint(43.2705171122541, -0.737804364418025, 0)
_C76H.DistanceRangeUOM = "Feet"
_C76H.ProximityRangeUOM = "Meters"
_C76H.OutOfRangeName = ""
_C76H.InRangeName = ""
_L2w = Wherigo.Zone(_Gpst)
_L2w.Id = "1b423b3c-6046-40a2-a076-08eeb77b7f08"
_L2w.Name = _nLZ("\007\042\123\068\127\103\081")
_L2w.Description = ""
_L2w.Visible = true
_L2w.Media = _bt61J
_L2w.Commands = {}
_L2w.DistanceRange = Distance(-1, "feet")
_L2w.ShowObjects = "OnEnter"
_L2w.ProximityRange = Distance(60, "meters")
_L2w.AllowSetPositionTo = false
_L2w.Active = false
_L2w.Points = {
	ZonePoint(43.272904, -0.740896, 0), 
	ZonePoint(43.2729420817012, -0.74087320122338, 0), 
	ZonePoint(43.2729245055344, -0.740843696924216, 0), 
	ZonePoint(43.2728756828222, -0.740854425760276, 0), 
	ZonePoint(43.2728581066362, -0.740894658895499, 0), 
	ZonePoint(43.2728737299129, -0.740934892030722, 0), 
	ZonePoint(43.2729147409951, -0.740959031911856, 0), 
	ZonePoint(43.2729655165824, -0.740921480985648, 0), 
	ZonePoint(43.2729518462361, -0.74086783680535, 0)
}
_L2w.OriginalPoint = ZonePoint(43.2729122456023, -0.740893913837439, 0)
_L2w.DistanceRangeUOM = "Feet"
_L2w.ProximityRangeUOM = "Meters"
_L2w.OutOfRangeName = ""
_L2w.InRangeName = ""
_BC_ = Wherigo.Zone(_Gpst)
_BC_.Id = "07935e3b-467c-45b0-8c15-746c9281c6fb"
_BC_.Name = _nLZ("\057\042\047\063\104\014\106\103")
_BC_.Description = ""
_BC_.Visible = true
_BC_.Media = _ns9
_BC_.Commands = {}
_BC_.DistanceRange = Distance(-1, "feet")
_BC_.ShowObjects = "OnEnter"
_BC_.ProximityRange = Distance(60, "meters")
_BC_.AllowSetPositionTo = false
_BC_.Active = false
_BC_.Points = {
	ZonePoint(43.2733575738401, -0.739238005136484, 0), 
	ZonePoint(43.2734786531357, -0.739136081193918, 0), 
	ZonePoint(43.2734083490579, -0.739071708177561, 0), 
	ZonePoint(43.2732755522449, -0.739280920480723, 0), 
	ZonePoint(43.2733302333206, -0.739393573259348, 0), 
	ZonePoint(43.2734786531357, -0.739141445611948, 0)
}
_BC_.OriginalPoint = ZonePoint(43.2733881691225, -0.739210288976664, 0)
_BC_.DistanceRangeUOM = "Feet"
_BC_.ProximityRangeUOM = "Meters"
_BC_.OutOfRangeName = ""
_BC_.InRangeName = ""

-- Characters --

-- Items --
_jZa3E = Wherigo.ZItem(_Gpst)
_jZa3E.Id = "30f1d1ba-c0bb-448a-8018-a6a37d9e5e46"
_jZa3E.Name = _nLZ("\061\045\121\104\082\127\047\103\123\042\123\068\127\103\091")
_jZa3E.Description = ""
_jZa3E.Visible = true
_jZa3E.Media = _iZ9t
_jZa3E.Commands = {}
_jZa3E.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_jZa3E.Locked = false
_jZa3E.Opened = false
_lGb = Wherigo.ZItem(_Gpst)
_lGb.Id = "a30f6815-fd94-4914-914d-cab10189acde"
_lGb.Name = _nLZ("\061\045\121\104\082\127\047\103\123\042\123\068\127\103\010")
_lGb.Description = ""
_lGb.Visible = true
_lGb.Media = _g15PF
_lGb.Commands = {}
_lGb.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_lGb.Locked = false
_lGb.Opened = false
_7RgM6 = Wherigo.ZItem(_Gpst)
_7RgM6.Id = "e015b78a-3689-405e-98df-ab5e6c77e99b"
_7RgM6.Name = _nLZ("\061\045\121\104\082\127\047\103\123\042\123\068\127\103\081")
_7RgM6.Description = ""
_7RgM6.Visible = true
_7RgM6.Media = _v58i
_7RgM6.Commands = {}
_7RgM6.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_7RgM6.Locked = false
_7RgM6.Opened = false
_cWIeu = Wherigo.ZItem(_Gpst)
_cWIeu.Id = "e975d58b-d542-4e3d-a3ff-643db694259e"
_cWIeu.Name = _nLZ("\055\127\082\127\123\041\127\052\047\103\093\127\103\082\042\014\106\052\127\055")
_cWIeu.Description = ""
_cWIeu.Visible = true
_cWIeu.Media = _T1q4_
_cWIeu.Commands = {
	_NjXNY = Wherigo.ZCommand{
		Text = _nLZ("\105\047\042\014\123\042\104\055"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _nLZ("\088\121\041\068\104\014\106\103\042\062\042\104\082\042\054\082\127")
	}, 
	_siaL = Wherigo.ZCommand{
		Text = _nLZ("\024\055\045\042\106\014\121\082"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _nLZ("\088\121\041\068\104\014\106\103\042\062\042\104\082\042\054\082\127")
	}, 
	_Nv8ck = Wherigo.ZCommand{
		Text = _nLZ("\033\014\106\082\042\104\055"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _nLZ("\088\121\041\068\104\014\106\103\042\062\042\104\082\042\054\082\127")
	}
}
_cWIeu.Commands._NjXNY.Custom = true
_cWIeu.Commands._NjXNY.Id = "823e682f-8e4f-40b5-8189-12671a0853f8"
_cWIeu.Commands._NjXNY.WorksWithAll = true
_cWIeu.Commands._siaL.Custom = true
_cWIeu.Commands._siaL.Id = "bdc02241-981d-4a6e-a22a-daef4931467a"
_cWIeu.Commands._siaL.WorksWithAll = true
_cWIeu.Commands._Nv8ck.Custom = true
_cWIeu.Commands._Nv8ck.Id = "2bfdaba2-c949-4f1b-bf46-362d9c1bc229"
_cWIeu.Commands._Nv8ck.WorksWithAll = true
_cWIeu.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_cWIeu.Locked = false
_cWIeu.Opened = false

-- Tasks --

-- Cartridge Variables --
_fudB = ""
__2n = 382
_7FkQ6 = 144
_wul2f = 53
_CTn44 = 12000
_5Dr0 = 1940
_4zCUq = 18185
_Kk7z = ""
_GX0uQ = ""
_qaVlf = ""
_OM1J = ""
_P8V = 7
_9RsqC = 250
_g7L = _nLZ("\116\069\033\012")
_jDNmB = 1942
_IPcmq = _nLZ("\091\076\091")
_NY5 = 1585
_iA1AF = ""
_Gpst.ZVariables = {
	_fudB = "", 
	__2n = 382, 
	_7FkQ6 = 144, 
	_wul2f = 53, 
	_CTn44 = 12000, 
	_5Dr0 = 1940, 
	_4zCUq = 18185, 
	_Kk7z = "", 
	_GX0uQ = "", 
	_qaVlf = "", 
	_OM1J = "", 
	_P8V = 7, 
	_9RsqC = 250, 
	_g7L = _nLZ("\116\069\033\012"), 
	_jDNmB = 1942, 
	_IPcmq = _nLZ("\091\076\091"), 
	_NY5 = 1585, 
	_iA1AF = ""
}

-- Timers --

-- Inputs --
_OhJfQ = Wherigo.ZInput(_Gpst)
_OhJfQ.Id = "341f4e5d-f71a-4f42-917f-12de5d885023"
_OhJfQ.Name = _nLZ("\115\091")
_OhJfQ.Description = ""
_OhJfQ.Visible = true
_OhJfQ.Media = _sL0j
_OhJfQ.Choices = {
	"As de pique", 
	"As de trefle", 
	"As de coeur", 
	"As de carreau"
}
_OhJfQ.InputType = "MultipleChoice"
_OhJfQ.Text = _nLZ("\007\121\084\084\127\014\041\103\055\021\042\045\045\127\082\082\127\103\123\127\041\041\127\103\054\042\047\042\046\052\127\103\100")
_oQk = Wherigo.ZInput(_Gpst)
_oQk.Id = "a890f928-d605-49c7-b483-1a1722e0b67a"
_oQk.Name = _nLZ("\115\010")
_oQk.Description = ""
_oQk.Visible = true
_oQk.Media = _sL0j
_oQk.Choices = {
	"380", 
	"382", 
	"384", 
	"386"
}
_oQk.InputType = "MultipleChoice"
_oQk.Text = _nLZ("\095\127\103\123\042\084\045\103\093\127\103\001\052\047\055\103\032\014\054\055\045\112\123\121\084\045\041\127\103\123\121\084\054\104\127\014\103\093\127\103\054\042\047\042\046\052\127\055\103\100")
_jE7 = Wherigo.ZInput(_Gpst)
_jE7.Id = "506481cb-1f56-451e-972c-adfef32f197b"
_jE7.Name = _nLZ("\115\076")
_jE7.Description = ""
_jE7.Visible = true
_jE7.Media = _sL0j
_jE7.InputType = "Text"
_jE7.Text = _nLZ("\024\014\103\091\072\051\009\103\082\127\103\014\121\084\054\047\127\103\093\127\055\103\104\014\041\127\047\014\127\055\103\045\042\055\055\127\103\093\127\103\091\076\009\009\103\042\103\002\002\002")
_azz = Wherigo.ZInput(_Gpst)
_azz.Id = "552fa7ba-c4a6-43ba-a9dd-cbf4013dc026"
_azz.Name = _nLZ("\115\081")
_azz.Description = ""
_azz.Visible = true
_azz.Media = _sL0j
_azz.InputType = "Text"
_azz.Text = _nLZ("\114\052\127\082\082\127\103\127\055\041\103\082\042\103\055\052\047\064\042\123\127\103\093\021\052\014\127\103\054\042\047\042\046\052\127\103\100")
_M_5J = Wherigo.ZInput(_Gpst)
_M_5J.Id = "8ec772bc-7935-4ac1-a3a1-530df36ffed7"
_M_5J.Name = _nLZ("\115\051")
_M_5J.Description = ""
_M_5J.Visible = true
_M_5J.Media = _sL0j
_M_5J.InputType = "Text"
_M_5J.Text = _nLZ("\031\127\103\123\121\084\054\104\127\014\103\093\127\103\045\042\090\055\103\055\121\014\041\103\121\047\104\106\104\014\042\104\047\127\055\103\082\127\055\103\045\047\127\084\104\127\047\055\103\001\052\047\055\104\127\014\055\103\100")
_UdFx = Wherigo.ZInput(_Gpst)
_UdFx.Id = "b05c1d69-8ebf-4685-8e3a-dc65530ecd2d"
_UdFx.Name = _nLZ("\115\025\103\057\072")
_UdFx.Description = ""
_UdFx.Visible = true
_UdFx.Media = _sL0j
_UdFx.Choices = {
	"1938", 
	"1939", 
	"1940"
}
_UdFx.InputType = "MultipleChoice"
_UdFx.Text = _nLZ("\049\079\069\004\095\021\127\041\042\041\103\064\047\042\014\123\042\104\055\103\045\047\121\084\052\082\106\052\127\103\052\014\103\045\047\127\084\104\127\047\103\032\014\054\055\045\112\055\041\042\041\052\041\103\093\127\055\103\124\052\104\064\055\103\082\127\103\081\103\121\123\041\121\054\047\127\103\002\002\002\002")
_dQfl = Wherigo.ZInput(_Gpst)
_dQfl.Id = "686b7750-cda9-40d1-a45d-c41c9d40aed7"
_dQfl.Name = _nLZ("\115\025\057\091\009")
_dQfl.Description = ""
_dQfl.Visible = true
_dQfl.Media = _sL0j
_dQfl.Choices = {
	"18851", 
	"18185", 
	"18518"
}
_dQfl.InputType = "MultipleChoice"
_dQfl.Text = _nLZ("\024\014\041\047\127\103\121\123\041\121\054\047\127\103\091\072\051\009\103\127\041\103\014\121\062\127\084\054\047\127\103\091\072\051\081\103\123\121\084\054\104\127\014\103\093\127\103\045\127\047\055\121\014\014\127\055\103\055\121\014\041\103\042\047\047\127\041\127\127\055\103\100")
_kZF = Wherigo.ZInput(_Gpst)
_kZF.Id = "6dd296b1-a4aa-47bd-bcb3-becbdb756ab1"
_kZF.Name = _nLZ("\115\025\057\091\010")
_kZF.Description = ""
_kZF.Visible = true
_kZF.Media = _sL0j
_kZF.Choices = {
	"VRAI", 
	"FAUX"
}
_kZF.InputType = "MultipleChoice"
_kZF.Text = _nLZ("\095\021\042\093\084\104\014\104\055\041\047\041\104\121\014\103\093\052\103\123\042\084\045\103\127\055\041\103\042\055\055\052\047\127\127\103\045\042\047\103\082\127\055\103\084\104\082\104\041\042\104\047\127\055\103\064\047\042\014\123\042\104\055\103\124\052\055\046\052\021\042\052\103\010\010\103\124\052\104\014\103\091\072\051\009")
_voEB = Wherigo.ZInput(_Gpst)
_voEB.Id = "6a4aad6c-a635-49d2-bd6c-7a6ba54552a5"
_voEB.Name = _nLZ("\115\025\057\091\081")
_voEB.Description = ""
_voEB.Visible = true
_voEB.Media = _sL0j
_voEB.InputType = "Text"
_voEB.Text = _nLZ("\061\052\047\103\082\042\103\055\042\014\106\052\104\014\127\103\093\127\103\006\052\082\052\104\055\103\007\103\067\052\084\127\047\103\048\123\121\084\054\104\127\014\103\090\103\042\103\041\021\104\082\103\093\127\103\062\104\055\042\106\127\055")
_bldj = Wherigo.ZInput(_Gpst)
_bldj.Id = "d11d15c6-42db-431d-9d4b-8c376a6861a8"
_bldj.Name = _nLZ("\022\057\091\051")
_bldj.Description = ""
_bldj.Visible = true
_bldj.Media = _sL0j
_bldj.Choices = {
	"200", 
	"250", 
	"300"
}
_bldj.InputType = "MultipleChoice"
_bldj.Text = _nLZ("\095\042\103\047\042\041\104\121\014\103\093\127\103\045\042\104\014\103\127\055\041\103\093\127\103\123\121\084\054\104\127\014\103\093\127\103\106\047\042\084\084\127\055\103\100")
_3YTbl = Wherigo.ZInput(_Gpst)
_3YTbl.Id = "1d21251d-e2b8-4ecc-857b-0f48c135c679"
_3YTbl.Name = _nLZ("\115\022\057\091\025")
_3YTbl.Description = ""
_3YTbl.Visible = true
_3YTbl.Media = _sL0j
_3YTbl.Choices = {
	"VRAI", 
	"FAUX"
}
_3YTbl.InputType = "MultipleChoice"
_3YTbl.Text = _nLZ("\085\042\093\127\082\127\104\014\127\103\079\042\047\121\041\103\123\047\127\042\103\082\042\103\007\012\085\033\031\024\103\032\014\054\055\045\112\042\052\103\123\042\084\045\103\093\127\103\001\052\047\055\103")
_GffQZ = Wherigo.ZInput(_Gpst)
_GffQZ.Id = "7e965d57-be03-4957-86a3-26ed1a328362"
_GffQZ.Name = _nLZ("\115\022\057\091\125")
_GffQZ.Description = ""
_GffQZ.Visible = true
_GffQZ.Media = _sL0j
_GffQZ.InputType = "Text"
_GffQZ.Text = _nLZ("\011\114\052\104\103\121\052\054\082\104\127\047\042\103\082\127\055\103\082\121\014\106\052\127\055\103\123\121\082\121\014\014\127\055\103\093\021\068\121\084\084\127\055\103\127\041\103\093\127\103\064\127\084\084\127\055\103\041\047\042\062\127\047\055\042\014\041\103\082\127\103\123\042\084\045\103\055\104\082\127\014\123\104\127\052\055\127\084\127\014\041\103\127\041\103\082\042\104\055\055\042\014\041\103\093\127\047\047\104\127\047\127\103\127\082\082\127\055\103\052\014\103\062\104\093\127\103\093\042\014\055\103\082\127\046\052\127\082\103\121\014\103\123\047\121\090\042\104\041\103\127\041\121\052\064\064\127\047\103\100\011\049\079\069\004\061\104\127\106\054\127\047\041\103\032\014\054\055\045\112\057\082\042\055\041\127\047\127\123\063\049\079\069\004\080\024\029\098\103\010\009\091\091\070")
_lRK = Wherigo.ZInput(_Gpst)
_lRK.Id = "00eb00a1-7e74-4cc0-98e4-20c82e2691ef"
_lRK.Name = _nLZ("\115\022\057\091\072")
_lRK.Description = ""
_lRK.Visible = true
_lRK.Media = _sL0j
_lRK.Choices = {
	"149", 
	"150", 
	"151", 
	"152"
}
_lRK.InputType = "MultipleChoice"
_lRK.Text = _nLZ("\095\127\103\076\103\124\052\104\014\103\091\072\051\051\103\123\121\084\054\104\127\014\103\093\127\103\064\127\084\084\127\055\103\042\047\047\104\062\127\014\041\103\093\052\103\123\042\084\045\103\093\127\103\079\047\127\014\055\103\100")
_F_0s = Wherigo.ZInput(_Gpst)
_F_0s.Id = "f5b90097-781f-4a38-9f33-6a9377e7530c"
_F_0s.Name = _nLZ("\115\125")
_F_0s.Description = ""
_F_0s.Visible = true
_F_0s.Media = _sL0j
_F_0s.InputType = "Text"
_F_0s.Text = _nLZ("\007\121\084\054\104\127\014\103\093\127\103\011\123\121\082\082\042\054\121\055\011\103\055\121\014\041\103\127\014\064\127\047\084\127\055\103\045\042\047\103\082\127\103\045\047\127\064\127\041\103\100")
_oFWdA = Wherigo.ZInput(_Gpst)
_oFWdA.Id = "ab0a699e-a6de-427e-ab41-5894c2f0ff85"
_oFWdA.Name = _nLZ("\115\072")
_oFWdA.Description = ""
_oFWdA.Visible = true
_oFWdA.Media = _sL0j
_oFWdA.InputType = "Text"
_oFWdA.Text = _nLZ("\033\052\103\045\104\127\093\103\093\127\103\123\127\103\045\042\014\014\127\042\052\103\055\052\047\103\052\014\127\103\045\104\127\047\047\127\103\054\082\042\014\123\068\127\103\042\052\103\055\121\082\103\104\082\103\127\055\041\103\127\123\047\104\041\103\011\088\127\103\093\127\041\121\052\047\014\127\102\103\045\042\055\103\082\127\055\103\090\127\052\030\103\002\002\002")
_JHH = Wherigo.ZInput(_Gpst)
_JHH.Id = "4201869a-607f-4b75-be17-27ba753640a0"
_JHH.Name = _nLZ("\115\025\103\057\072\103\024")
_JHH.Description = ""
_JHH.Visible = true
_JHH.Media = _sL0j
_JHH.Choices = {
	"1938", 
	"1939", 
	"1940"
}
_JHH.InputType = "MultipleChoice"
_JHH.Text = _nLZ("\024\082\103\127\055\041\042\093\121\103\064\047\042\014\123\127\055\103\045\047\121\084\052\082\106\042\103\052\014\103\127\055\041\042\041\052\041\121\103\093\127\103\045\047\104\084\127\047\042\103\006\052\093\104\121\055\103\127\082\103\081\103\093\127\103\121\123\041\052\054\047\127\103\002\002\002\002")
_Q6O = Wherigo.ZInput(_Gpst)
_Q6O.Id = "5acef43f-1f66-4f91-8ef8-92ca88481f1a"
_Q6O.Name = _nLZ("\115\025\057\091\009\103\024")
_Q6O.Description = ""
_Q6O.Visible = true
_Q6O.Media = _sL0j
_Q6O.Choices = {
	"18851", 
	"18185", 
	"18518"
}
_Q6O.InputType = "MultipleChoice"
_Q6O.Text = _nLZ("\024\014\041\047\127\103\082\042\055\103\121\123\041\052\054\047\127\103\091\072\051\009\103\090\103\014\121\062\104\127\084\054\047\127\103\093\127\103\091\072\051\081\103\127\082\103\014\052\084\127\047\121\103\093\127\103\045\127\047\055\121\014\042\055\103\127\055\041\042\014\103\093\127\041\127\014\104\093\042\055\100")
_1uP5 = Wherigo.ZInput(_Gpst)
_1uP5.Id = "c5f2bea4-5530-4200-9910-1cdfbcc70ca1"
_1uP5.Name = _nLZ("\115\025\103\057\072\103\033")
_1uP5.Description = ""
_1uP5.Visible = true
_1uP5.Media = _sL0j
_1uP5.Choices = {
	"1938", 
	"1939", 
	"1940"
}
_1uP5.InputType = "MultipleChoice"
_1uP5.Text = _nLZ("\067\068\127\103\064\047\127\014\123\068\103\055\041\042\041\127\103\127\014\042\123\041\055\103\042\103\064\104\047\055\041\103\055\041\042\041\052\055\103\121\064\103\006\127\071\055\103\121\014\103\111\123\041\121\054\127\047\103\081\103\002\002\002\002")
_QeT1 = Wherigo.ZInput(_Gpst)
_QeT1.Id = "f81ece02-9b03-4e2c-97c7-05ca6e0a0cd4"
_QeT1.Name = _nLZ("\115\010\103\024")
_QeT1.Description = ""
_QeT1.Visible = true
_QeT1.Media = _sL0j
_QeT1.Choices = {
	"380", 
	"382", 
	"384", 
	"386"
}
_QeT1.InputType = "MultipleChoice"
_QeT1.Text = _nLZ("\007\042\084\045\121\103\093\127\103\001\052\047\055\103\123\052\127\014\041\042\103\127\082\103\014\052\084\127\047\121\103\093\127\103\045\052\127\055\041\121\055\100")
_tdX2U = Wherigo.ZInput(_Gpst)
_tdX2U.Id = "0f8cc876-06b0-4466-90c2-bcac9fca71f1"
_tdX2U.Name = _nLZ("\115\010\103\033")
_tdX2U.Description = ""
_tdX2U.Visible = true
_tdX2U.Media = _sL0j
_tdX2U.Choices = {
	"380", 
	"382", 
	"384", 
	"386"
}
_tdX2U.InputType = "MultipleChoice"
_tdX2U.Text = _nLZ("\007\042\084\045\103\001\052\047\055\103\123\121\052\014\041\055\103\068\121\071\103\084\042\014\090\103\054\042\047\047\042\123\063\055\100")
_lf2f = Wherigo.ZInput(_Gpst)
_lf2f.Id = "ac2a8b4d-e44b-4227-a58a-d849f1f47e2e"
_lf2f.Name = _nLZ("\115\091\103\024")
_lf2f.Description = ""
_lf2f.Visible = true
_lf2f.Media = _sL0j
_lf2f.Choices = {
	"As de pique", 
	"As de trefle", 
	"As de coeur", 
	"As de carreau"
}
_lf2f.InputType = "MultipleChoice"
_lf2f.Text = _nLZ("\100\007\121\084\121\103\055\127\103\082\082\042\084\042\103\127\055\041\042\103\123\042\055\042\100")
_s99W = Wherigo.ZInput(_Gpst)
_s99W.Id = "65c3dae4-9be4-44e1-9850-451655685a47"
_s99W.Name = _nLZ("\115\076\103\024")
_s99W.Description = ""
_s99W.Visible = true
_s99W.Media = _sL0j
_s99W.InputType = "Text"
_s99W.Text = _nLZ("\024\014\103\127\082\103\091\072\051\009\103\127\082\103\014\052\084\127\047\121\103\093\127\103\104\014\041\127\047\014\042\093\121\055\103\093\127\103\091\002\076\009\009\103\042\082\103\002\002\002")
_9JJA = Wherigo.ZInput(_Gpst)
_9JJA.Id = "b02d2941-2d0f-41a8-9102-f8b69388adf0"
_9JJA.Name = _nLZ("\115\091\103\033")
_9JJA.Description = ""
_9JJA.Visible = true
_9JJA.Media = _sL0j
_9JJA.Choices = {
	"As de pique", 
	"As de trefle", 
	"As de coeur", 
	"As de carreau"
}
_9JJA.InputType = "MultipleChoice"
_9JJA.Text = _nLZ("\087\068\042\041\103\093\121\103\071\127\103\123\042\082\082\103\041\068\104\055\103\068\121\052\055\127\100")
_hIm = Wherigo.ZInput(_Gpst)
_hIm.Id = "1d64e2ab-2543-4205-8bf2-b96b90bbd003"
_hIm.Name = _nLZ("\115\051\103\033")
_hIm.Description = ""
_hIm.Visible = true
_hIm.Media = _sL0j
_hIm.InputType = "Text"
_hIm.Text = _nLZ("\107\121\071\103\084\042\014\090\103\123\121\052\014\041\047\104\127\055\103\042\047\127\103\064\047\121\084\103\041\068\127\103\064\104\047\055\041\103\001\052\047\055\104\127\014\055\100")
_s1fKM = Wherigo.ZInput(_Gpst)
_s1fKM.Id = "af69bd0e-30fb-4fd2-ac23-8d1a4240b546"
_s1fKM.Name = _nLZ("\115\051\103\024")
_s1fKM.Description = ""
_s1fKM.Visible = true
_s1fKM.Media = _sL0j
_s1fKM.InputType = "Text"
_s1fKM.Text = _nLZ("\100\007\052\042\014\041\121\055\103\045\042\104\055\127\055\103\055\121\014\103\093\127\103\082\042\103\001\052\047\055\104\127\014\055\103\045\047\104\084\127\047\121\100")
_FQ8Vx = Wherigo.ZInput(_Gpst)
_FQ8Vx.Id = "2b335a27-c1ea-4b4c-8ea7-bfc01ac2fbe5"
_FQ8Vx.Name = _nLZ("\115\076\103\033")
_FQ8Vx.Description = ""
_FQ8Vx.Visible = true
_FQ8Vx.Media = _sL0j
_FQ8Vx.InputType = "Text"
_FQ8Vx.Text = _nLZ("\012\014\103\091\072\051\009\103\041\068\127\103\014\052\084\054\127\047\103\121\064\103\104\014\041\127\047\014\127\127\055\103\064\047\121\084\103\091\048\076\009\009\103\041\121\103\002\002\002")
_SY_e = Wherigo.ZInput(_Gpst)
_SY_e.Id = "1c8475d9-c445-44b9-8b7f-f4c08f2748ae"
_SY_e.Name = _nLZ("\115\025\057\091\009\103\033")
_SY_e.Description = ""
_SY_e.Visible = true
_SY_e.Media = _sL0j
_SY_e.Choices = {
	"18851", 
	"18185", 
	"18518"
}
_SY_e.InputType = "MultipleChoice"
_SY_e.Text = _nLZ("\079\127\041\071\127\127\014\103\111\123\041\121\054\127\047\103\091\072\051\009\103\042\014\093\103\088\121\062\127\084\054\127\047\103\091\072\051\081\103\068\121\071\103\084\042\014\090\103\045\127\121\045\082\127\103\042\047\127\103\042\047\047\127\055\041\127\093")
_eI3H = Wherigo.ZInput(_Gpst)
_eI3H.Id = "356dcf6a-c68d-4599-b43f-c4938ca9cff4"
_eI3H.Name = _nLZ("\115\025\057\091\010\103\033")
_eI3H.Description = ""
_eI3H.Visible = true
_eI3H.Media = _sL0j
_eI3H.Choices = {
	"TRUE", 
	"FALSE"
}
_eI3H.InputType = "MultipleChoice"
_eI3H.Text = _nLZ("\067\068\127\103\033\093\084\104\014\104\055\041\047\042\041\104\062\127\103\111\064\064\104\123\127\047\103\121\064\103\041\068\127\103\123\042\084\045\103\104\055\103\045\047\121\062\104\093\127\093\103\054\090\103\041\068\127\103\064\047\127\014\123\068\103\084\104\082\104\041\042\047\090\103\052\014\041\104\082\103\006\052\014\127\103\010\010\048\103\091\072\051\009")
_RiTT = Wherigo.ZInput(_Gpst)
_RiTT.Id = "261a9f19-f044-4b39-aad0-22e16fbd588c"
_RiTT.Name = _nLZ("\115\025\057\091\010\103\024")
_RiTT.Description = ""
_RiTT.Visible = true
_RiTT.Media = _sL0j
_RiTT.Choices = {
	"VERDAD", 
	"FALSO"
}
_RiTT.InputType = "MultipleChoice"
_RiTT.Text = _nLZ("\024\082\103\121\064\104\123\104\042\082\103\042\093\084\104\014\104\055\041\047\042\041\104\062\121\103\093\127\082\103\123\042\084\045\042\084\127\014\041\121\103\127\055\103\045\047\121\045\121\047\123\104\121\014\042\093\121\103\045\121\047\103\127\082\103\127\124\127\047\123\104\041\121\103\064\047\042\014\123\127\055\103\068\042\055\041\042\103\127\082\103\010\010\103\093\127\103\124\052\014\104\121\103\091\072\051\009")
_jzQm = Wherigo.ZInput(_Gpst)
_jzQm.Id = "b3555804-5cfb-4831-bed1-f9aed21dc2f1"
_jzQm.Name = _nLZ("\115\025\057\091\081\103\033")
_jzQm.Description = ""
_jzQm.Visible = true
_jzQm.Media = _sL0j
_jzQm.InputType = "Text"
_jzQm.Text = _nLZ("\111\014\103\054\082\121\121\093\055\041\047\127\042\084\103\006\023\095\012\023\061\103\007\002\103\067\052\084\127\047\048\103\068\121\071\103\084\042\014\090\103\064\042\123\127\055\103\090\121\052\103\104\041\103\068\042\055")
_LgBS = Wherigo.ZInput(_Gpst)
_LgBS.Id = "cbac7f0f-eb1b-4dfe-8583-e7062399968a"
_LgBS.Name = _nLZ("\115\025\057\091\081\103\024")
_LgBS.Description = ""
_LgBS.Visible = true
_LgBS.Media = _sL0j
_LgBS.InputType = "Text"
_LgBS.Text = _nLZ("\024\014\103\055\042\014\106\052\104\014\127\121\055\103\006\023\095\012\111\103\007\002\103\067\052\084\127\047\048\103\100\123\052\042\014\041\042\055\103\123\042\047\042\055\103\041\104\127\014\127")
_Fox = Wherigo.ZInput(_Gpst)
_Fox.Id = "eb154316-eb3f-4767-a3e8-d9da5a68f97e"
_Fox.Name = _nLZ("\115\022\057\091\025\103\033")
_Fox.Description = ""
_Fox.Visible = true
_Fox.Media = _sL0j
_Fox.Choices = {
	"TRUE", 
	"FALSE"
}
_Fox.InputType = "MultipleChoice"
_Fox.Text = _nLZ("\085\042\093\127\082\127\104\014\127\103\079\042\047\121\041\103\123\047\127\042\041\127\093\103\007\012\085\033\031\024\103\007\042\084\045\103\001\052\047\055")
_Nan = Wherigo.ZInput(_Gpst)
_Nan.Id = "808cd0ac-ac67-4fbc-8332-fd2a709a834b"
_Nan.Name = _nLZ("\115\022\057\091\025\103\024")
_Nan.Description = ""
_Nan.Visible = true
_Nan.Media = _sL0j
_Nan.Choices = {
	"VERDAD", 
	"FALSO"
}
_Nan.InputType = "MultipleChoice"
_Nan.Text = _nLZ("\085\042\093\127\082\127\104\014\127\103\079\042\047\121\041\103\123\047\127\042\093\121\055\103\007\012\085\033\031\024\103\007\042\084\045\121\103\093\127\103\001\052\047\055")
_upVK = Wherigo.ZInput(_Gpst)
_upVK.Id = "9883faf5-c850-4fb9-82aa-68e2202cae29"
_upVK.Name = _nLZ("\115\022\057\091\125\103\033")
_upVK.Description = ""
_upVK.Visible = true
_upVK.Media = _sL0j
_upVK.InputType = "Text"
_upVK.Text = _nLZ("\011\114\052\104\103\121\052\054\082\104\127\047\042\103\082\127\055\103\082\121\014\106\052\127\055\103\123\121\082\121\014\014\127\055\103\093\021\068\121\084\084\127\055\103\127\041\103\093\127\103\064\127\084\084\127\055\103\041\047\042\062\127\047\055\042\014\041\103\082\127\103\123\042\084\045\103\055\104\082\127\014\123\104\127\052\055\127\084\127\014\041\103\127\041\103\082\042\104\055\055\042\014\041\103\093\127\047\047\104\127\047\127\103\127\082\082\127\055\103\052\014\103\062\104\093\127\103\093\042\014\055\103\082\127\046\052\127\082\103\121\014\103\123\047\121\090\042\104\041\103\127\041\121\052\064\064\127\047\103\100\011\049\079\069\004\061\104\127\106\054\127\047\041\103\032\014\054\055\045\112\057\082\042\055\041\127\047\127\123\063\049\079\069\004\080\024\029\098\103\010\009\091\091\070")
_Id_u = Wherigo.ZInput(_Gpst)
_Id_u.Id = "9a2089d8-aa2c-426d-bc8b-23abe9cd1061"
_Id_u.Name = _nLZ("\115\022\057\091\125\103\024")
_Id_u.Description = ""
_Id_u.Visible = true
_Id_u.Media = _sL0j
_Id_u.InputType = "Text"
_Id_u.Text = _nLZ("\011\114\052\104\103\121\052\054\082\104\127\047\042\103\082\127\055\103\082\121\014\106\052\127\055\103\123\121\082\121\014\014\127\055\103\093\021\068\121\084\084\127\055\103\127\041\103\093\127\103\064\127\084\084\127\055\103\041\047\042\062\127\047\055\042\014\041\103\082\127\103\123\042\084\045\103\055\104\082\127\014\123\104\127\052\055\127\084\127\014\041\103\127\041\103\082\042\104\055\055\042\014\041\103\093\127\047\047\104\127\047\127\103\127\082\082\127\055\103\052\014\103\062\104\093\127\103\093\042\014\055\103\082\127\046\052\127\082\103\121\014\103\123\047\121\090\042\104\041\103\127\041\121\052\064\064\127\047\103\100\011\049\079\069\004\061\104\127\106\054\127\047\041\103\032\014\054\055\045\112\057\082\042\055\041\127\047\127\123\063\049\079\069\004\080\024\029\098\103\010\009\091\091\070")
_7i9 = Wherigo.ZInput(_Gpst)
_7i9.Id = "f67643ce-bc4f-4562-ac71-5e6273cfad1c"
_7i9.Name = _nLZ("\115\022\057\091\072\103\033")
_7i9.Description = ""
_7i9.Visible = true
_7i9.Media = _sL0j
_7i9.Choices = {
	"149", 
	"150", 
	"151", 
	"152"
}
_7i9.InputType = "MultipleChoice"
_7i9.Text = _nLZ("\111\014\103\006\052\014\127\103\076\048\103\091\072\051\051\103\068\121\071\103\084\042\014\090\103\071\121\084\127\014\103\123\121\084\127\103\079\047\127\014\055\103\123\042\084\045\100")
_5mvqr = Wherigo.ZInput(_Gpst)
_5mvqr.Id = "6b18c981-a7f8-4115-b0d4-81bec46cd763"
_5mvqr.Name = _nLZ("\115\022\057\091\072\103\024")
_5mvqr.Description = ""
_5mvqr.Visible = true
_5mvqr.Media = _sL0j
_5mvqr.Choices = {
	"149", 
	"150", 
	"151", 
	"152"
}
_5mvqr.InputType = "MultipleChoice"
_5mvqr.Text = _nLZ("\024\082\103\009\076\103\093\127\103\124\052\014\104\121\103\091\072\051\051\103\127\082\103\014\052\084\127\047\121\103\093\127\103\084\052\124\127\047\127\055\103\062\104\127\014\127\014\103\123\042\084\045\121\103\093\127\103\079\047\127\014\055\100")
_3UMw = Wherigo.ZInput(_Gpst)
_3UMw.Id = "a075dff0-b80d-4833-a799-61bb3b1e6d86"
_3UMw.Name = _nLZ("\115\125\103\033")
_3UMw.Description = ""
_3UMw.Visible = true
_3UMw.Media = _sL0j
_3UMw.InputType = "Text"
_3UMw.Text = _nLZ("\107\121\071\103\084\042\014\090\103\011\123\121\082\082\042\054\121\055\011\103\042\047\127\103\127\014\123\082\121\055\127\093\103\054\090\103\041\068\127\103\045\047\127\064\127\123\041\100")
_0f1 = Wherigo.ZInput(_Gpst)
_0f1.Id = "2f8607c3-a3f3-4197-b417-c8ff2d573a6b"
_0f1.Name = _nLZ("\115\125\103\024")
_0f1.Description = ""
_0f1.Visible = true
_0f1.Media = _sL0j
_0f1.InputType = "Text"
_0f1.Text = _nLZ("\100\007\052\042\014\041\121\055\103\011\123\121\082\082\042\054\121\055\011\103\055\121\014\103\104\014\123\082\052\104\093\121\055\103\045\121\047\103\127\082\103\045\047\127\064\127\123\041\121\100")
_T6w = Wherigo.ZInput(_Gpst)
_T6w.Id = "a1931b58-998c-454d-b1f1-04fa242566d3"
_T6w.Name = _nLZ("\115\072\103\033")
_T6w.Description = ""
_T6w.Visible = true
_T6w.Media = _sL0j
_T6w.InputType = "Text"
_T6w.Text = _nLZ("\033\041\103\041\068\127\103\064\121\121\041\103\121\064\103\041\068\104\055\103\045\042\014\127\082\103\121\014\103\042\103\047\127\093\103\106\047\121\052\014\093\103\104\041\103\055\042\090\055\049\079\069\004\011\088\127\103\093\127\041\121\052\047\014\127\102\103\045\042\055\103\082\127\055\103\090\127\052\030\103\002\002\002")
_UyDV = Wherigo.ZInput(_Gpst)
_UyDV.Id = "6ff0c99d-ea8a-4064-a3e6-60d69f250579"
_UyDV.Name = _nLZ("\115\072\103\024")
_UyDV.Description = ""
_UyDV.Visible = true
_UyDV.Media = _sL0j
_UyDV.InputType = "Text"
_UyDV.Text = _nLZ("\033\082\103\045\104\127\103\093\127\103\127\055\041\127\103\045\042\014\127\082\103\055\121\054\047\127\103\064\121\014\093\121\103\047\121\124\121\103\046\052\127\103\093\104\123\127\103\049\079\069\004\103\011\088\127\103\093\127\041\121\052\047\014\127\102\103\045\042\055\103\082\127\055\103\090\127\052\030\103\002\002\002")
_ehjG = Wherigo.ZInput(_Gpst)
_ehjG.Id = "35fa760b-2e85-4f0b-b372-7e984922aad9"
_ehjG.Name = _nLZ("\115\081\103\033")
_ehjG.Description = ""
_ehjG.Visible = true
_ehjG.Media = _sL0j
_ehjG.InputType = "Text"
_ehjG.Text = _nLZ("\087\068\042\041\103\104\055\103\041\068\127\103\055\052\047\064\042\123\127\103\121\064\103\042\103\054\042\047\047\042\123\063\100")
_4FJ = Wherigo.ZInput(_Gpst)
_4FJ.Id = "3169f361-22cd-4261-90ca-8cdfa88db555"
_4FJ.Name = _nLZ("\115\081\103\024")
_4FJ.Description = ""
_4FJ.Visible = true
_4FJ.Media = _sL0j
_4FJ.InputType = "Text"
_4FJ.Text = _nLZ("\100\007\052\042\082\103\127\055\103\082\042\103\055\052\045\127\047\064\104\123\104\127\103\093\127\103\052\014\042\103\007\042\054\042\014\042\100")
_Nvl = Wherigo.ZInput(_Gpst)
_Nvl.Id = "8bf4cc1c-42a6-4ed5-ba81-5c57a2cb392f"
_Nvl.Name = _nLZ("\022\057\091\051\103\024")
_Nvl.Description = ""
_Nvl.Visible = true
_Nvl.Media = _sL0j
_Nvl.Choices = {
	"200", 
	"250", 
	"300"
}
_Nvl.InputType = "MultipleChoice"
_Nvl.Text = _nLZ("\095\042\103\047\042\123\104\121\014\103\093\127\103\045\042\014\103\127\055\103\123\052\042\014\041\121\055\103\106\047\042\084\121\055\100")
_wUPHK = Wherigo.ZInput(_Gpst)
_wUPHK.Id = "1de85cc3-4ce1-420b-bdb6-185e9e2e0db1"
_wUPHK.Name = _nLZ("\022\057\091\051\103\033")
_wUPHK.Description = ""
_wUPHK.Visible = true
_wUPHK.Media = _sL0j
_wUPHK.Choices = {
	"200", 
	"250", 
	"300"
}
_wUPHK.InputType = "MultipleChoice"
_wUPHK.Text = _nLZ("\067\068\127\103\047\042\041\104\121\014\103\121\064\103\054\047\127\042\093\103\104\055\103\068\121\071\103\084\042\014\090\103\106\047\042\084\055\100")

-- WorksWithList for object commands --

-- functions --
function _Gpst:OnStart()
	_cWIeu:MoveTo(Player)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _cWIeu)
end
function _Gpst:OnRestore()
end
function _SHqsd:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_OhJfQ)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_lf2f)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_9JJA)
		end)
	end
end
function _JKC:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_oQk)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_QeT1)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_tdX2U)
		end)
	end
end
function _flBN:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_azz)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_4FJ)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_ehjG)
		end)
	end
end
function _jxu9:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_M_5J)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_s1fKM)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_hIm)
		end)
	end
end
function _AhQ5:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\023\014\103\104\014\093\104\123\127\103\055\052\047\103\082\127\103\082\104\127\052\103\093\127\103\082\042\103\123\042\123\068\127\103\055\127\103\041\047\121\052\062\127\103\093\042\014\055\103\062\121\041\047\127\103\104\014\062\127\014\041\042\104\047\127\103"), 
				Media = _sL0j
			}
		}, function(action)
			_jZa3E:MoveTo(Player)
			_AhQ5.Visible = false
			_AhQ5.Active = false
			_N3K.Active = true
			_N3K.Visible = true
			_Gpst:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\023\014\042\103\045\104\055\041\042\103\042\082\103\082\042\103\082\121\123\042\082\104\102\042\123\104\121\014\103\093\127\103\082\042\103\123\042\123\068\127\103\127\055\041\042\103\127\014\103\127\082\103\104\014\062\127\014\041\042\047\104\121"), 
				Media = _sL0j
			}
		}, function(action)
			_jZa3E:MoveTo(Player)
			_AhQ5.Visible = false
			_AhQ5.Active = false
			_N3K.Active = true
			_N3K.Visible = true
			_Gpst:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\033\103\123\082\052\127\103\041\121\103\041\068\127\103\082\121\123\042\041\104\121\014\103\121\064\103\041\068\127\103\123\042\123\068\127\103\104\055\103\104\014\103\090\121\052\047\103\104\014\062\127\014\041\121\047\090"), 
				Media = _sL0j
			}
		}, function(action)
			_jZa3E:MoveTo(Player)
			_AhQ5.Visible = false
			_AhQ5.Active = false
			_N3K.Active = true
			_N3K.Visible = true
			_Gpst:RequestSync()
		end)
	end
end
function _N3K:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_jE7)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_s99W)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_FQ8Vx)
		end)
	end
end
function _sJet8:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_UdFx)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_JHH)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_1uP5)
		end)
	end
end
function _sJet8:OnProximity()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\031\042\014\055\103\082\042\103\045\047\121\123\068\042\104\014\127\103\102\121\014\127\103\045\082\052\055\104\127\052\047\055\103\046\052\127\055\041\104\121\014\055\103\062\121\052\055\103\055\127\047\121\014\041\103\045\121\055\127\127\055\049\079\069\004\067\047\121\052\062\127\102\103\032\014\054\055\045\112\082\127\055\103\054\121\014\055\103\045\042\014\014\127\042\052\030\103\073\073\073\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			_Gpst:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\024\014\103\127\082\103\082\042\103\102\121\014\042\103\045\047\121\030\104\084\042\103\062\127\102\103\046\052\127\103\055\127\103\068\104\102\121\103\062\042\047\104\042\055\103\045\047\127\106\052\014\041\042\055\049\079\069\004\024\014\123\052\127\014\041\047\042\103\082\042\055\103\104\082\052\055\041\047\042\123\104\121\014\127\055\103\093\127\103\082\042\103\093\127\047\127\123\068\042\073\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			_Gpst:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\012\014\103\041\068\127\103\014\127\030\041\103\042\047\127\042\103\090\121\052\103\071\104\082\082\103\054\127\103\042\055\063\127\093\103\055\127\062\127\047\042\082\103\046\052\127\055\041\104\121\014\055\049\079\069\004\105\104\014\093\103\041\068\127\103\047\104\106\068\041\103\045\042\014\127\082\055\073\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			_Gpst:RequestSync()
		end)
	end
end
function _tOwB:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_bldj)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_Nvl)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_wUPHK)
		end)
	end
end
function _WtF:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_lGb.Visible = false
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_F_0s)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_lGb.Visible = false
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_0f1)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_lGb.Visible = false
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_3UMw)
		end)
	end
end
function _cc2uF:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_oFWdA)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_UyDV)
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_T6w)
		end)
	end
end
function _C76H:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\023\014\103\104\014\093\104\123\127\103\055\052\047\103\082\127\103\082\104\127\052\103\093\127\103\082\042\103\123\042\123\068\127\103\055\127\103\041\047\121\052\062\127\103\093\042\014\055\103\062\121\041\047\127\103\104\014\062\127\014\041\042\104\047\127\103"), 
				Media = _sL0j
			}
		}, function(action)
			_lGb:MoveTo(Player)
			_C76H.Active = false
			_C76H.Visible = false
			_WtF.Active = true
			_WtF.Visible = true
			_Gpst:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\023\014\042\103\045\104\055\041\042\103\042\082\103\082\042\103\082\121\123\042\082\104\102\042\123\104\121\014\103\093\127\103\082\042\103\123\042\123\068\127\103\127\055\041\042\103\127\014\103\041\052\103\104\014\062\127\014\041\042\047\104\121\002"), 
				Media = _sL0j
			}
		}, function(action)
			_lGb:MoveTo(Player)
			_C76H.Active = false
			_C76H.Visible = false
			_WtF.Active = true
			_WtF.Visible = true
			_Gpst:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\033\103\123\082\052\127\103\041\121\103\041\068\127\103\082\121\123\042\041\104\121\014\103\121\064\103\041\068\127\103\123\042\123\068\127\103\104\055\103\104\014\103\090\121\052\047\103\104\014\062\127\014\041\121\047\090\002"), 
				Media = _sL0j
			}
		}, function(action)
			_lGb:MoveTo(Player)
			_C76H.Active = false
			_C76H.Visible = false
			_WtF.Active = true
			_WtF.Visible = true
			_Gpst:RequestSync()
		end)
	end
end
function _L2w:OnEnter()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\049\079\069\004\023\014\103\104\014\093\104\123\127\103\055\052\047\103\082\127\103\082\104\127\052\103\093\127\103\082\042\103\123\042\123\068\127\103\055\127\103\041\047\121\052\062\127\103\093\042\014\055\103\062\121\041\047\127\103\104\014\062\127\014\041\042\104\047\127\103\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			_7RgM6:MoveTo(Player)
			_Gpst.Complete = true
			_BC_.Active = true
			_BC_.Visible = true
			_Gpst:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\049\079\069\004\023\014\042\103\045\104\055\041\042\103\042\082\103\082\042\103\082\121\123\042\082\104\102\042\123\104\121\014\103\093\127\103\082\042\103\123\042\123\068\127\103\127\055\041\042\103\127\014\103\041\052\103\104\014\062\127\014\041\042\047\104\121\002\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			_7RgM6:MoveTo(Player)
			_Gpst.Complete = true
			_BC_.Active = true
			_BC_.Visible = true
			_Gpst:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\049\079\069\004\033\103\123\082\052\127\103\041\121\103\041\068\127\103\082\121\123\042\041\104\121\014\103\121\064\103\041\068\127\103\123\042\123\068\127\103\104\055\103\104\014\103\090\121\052\047\103\104\014\062\127\014\041\121\047\090\002\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			_7RgM6:MoveTo(Player)
			_Gpst.Complete = true
			_BC_.Active = true
			_BC_.Visible = true
			_Gpst:RequestSync()
		end)
	end
end
function _L2w:OnExit()
	if Wherigo.NoCaseEquals(_iA1AF, _nLZ("\091")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\006\127\103\062\121\052\055\103\047\127\084\127\047\123\104\127\103\093\127\103\084\103\042\062\121\104\047\103\055\052\104\062\104\103\041\121\052\041\103\042\052\103\082\121\014\106\103\093\127\103\123\127\041\041\127\103\071\068\127\047\104\106\121\103\046\052\104\103\124\103\127\055\045\127\047\127\103\062\121\052\055\103\042\052\047\042\103\045\082\052\002"), 
				Media = _sL0j
			}
		}, function(action)
			Wherigo.Command "SaveClose"
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\010")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\001\047\042\123\104\042\055\103\084\103\068\042\014\103\055\127\106\052\104\093\121\103\093\052\047\042\014\041\127\103\041\121\093\121\103\127\082\103\093\104\042\103\127\014\103\046\052\127\103\087\068\127\047\104\106\121\103\127\055\045\127\047\042\103\046\052\127\103\068\042\090\042\103\093\104\055\064\047\052\041\042\093\121\002\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			Wherigo.Command "SaveClose"
		end)
	elseif Wherigo.NoCaseEquals(_iA1AF, _nLZ("\081")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\067\068\042\014\063\103\090\121\052\103\084\103\068\042\062\127\103\064\121\082\082\121\071\127\093\103\041\068\047\121\052\106\068\121\052\041\103\041\068\127\103\093\042\090\103\041\068\042\041\103\087\068\127\047\104\106\121\103\068\121\045\127\055\103\090\121\052\103\127\014\124\121\090\127\093\002"), 
				Media = _sL0j
			}
		}, function(action)
			Wherigo.Command "SaveClose"
		end)
	end
end
function _OhJfQ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_fudB = input
	_SHqsd.Active = false
	_SHqsd.Visible = false
	_JKC.Active = true
	_JKC.Visible = true
	_Gpst:RequestSync()
end
function _oQk:OnGetInput(input)
	if input == nil then
		input = ""
	end
	__2n = tonumber(input)
	_JKC.Active = false
	_JKC.Visible = false
	_flBN.Active = true
	_flBN.Visible = true
	_Gpst:RequestSync()
end
function _jE7:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_jZa3E.Visible = false
	_CTn44 = input
	if _CTn44 == 12000 then
		_N3K.Visible = false
		_N3K.Active = false
		_sJet8.Active = true
		_sJet8.Visible = true
		_Gpst:RequestSync()
	else
		_Urwigo.MessageBox{
			Text = _nLZ("\085\042\052\062\042\104\055\127\103\047\127\045\121\014\055\127\103\073\073\073\103\023\014\103\014\121\052\062\127\082\103\127\055\055\042\104\103\100"), 
			Media = _sL0j, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_jE7)
					end)
				end
			end
		}
		_Gpst:RequestSync()
	end
end
function _azz:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_7FkQ6 = input
	_flBN.Active = false
	_flBN.Visible = false
	_jxu9.Active = true
	_jxu9.Visible = true
	_Gpst:RequestSync()
end
function _M_5J:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_wul2f = input
	if ((Wherigo.NoCaseEquals(_fudB, _nLZ("\033\055\103\093\127\103\123\121\127\052\047")) and (__2n == 382)) and (_7FkQ6 == 144)) and (_wul2f == 53) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\116\121\052\055\103\042\062\127\102\103\032\014\054\055\045\112\054\104\127\014\103\047\127\045\121\014\093\052\103\042\052\030\103\046\052\127\055\041\104\121\014\055\103\127\041\103\084\042\104\014\041\127\014\042\014\041\103\062\121\052\055\103\045\121\052\062\127\102\103\042\082\082\127\047\103\123\068\127\047\123\068\127\047\103\082\042\103\123\042\123\068\127\103\085\090\055\041\127\047\090\103\032\014\054\055\045\112\001\007\010\085\001\072\072\103"), 
				Media = _sL0j
			}
		}, function(action)
			_jxu9.Active = false
			_jxu9.Visible = false
			_AhQ5.Active = true
			_AhQ5.Visible = true
			_Gpst:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\031\127\055\121\082\127\103\062\121\052\055\103\042\062\127\102\103\042\052\103\084\121\104\014\055\103\052\014\127\103\047\127\045\121\014\055\127\103\093\127\103\064\042\052\055\055\127\103\127\041\103\104\082\103\062\121\052\055\103\064\042\052\041\103\047\127\062\127\014\104\047\103\042\103\082\042\103\102\121\014\127\103\091"), 
				Media = _sL0j
			}
		}, function(action)
			_jxu9.Active = false
			_jxu9.Visible = false
			_SHqsd.Active = true
			_SHqsd.Visible = true
			_Gpst:RequestSync()
		end)
	end
end
function _UdFx:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_5Dr0 = tonumber(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_dQfl)
	end)
end
function _dQfl:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_4zCUq = tonumber(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_kZF)
	end)
end
function _kZF:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Kk7z = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_voEB)
	end)
end
function _voEB:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_P8V = input
	if (((_5Dr0 == 1940) and (_4zCUq == 18185)) and Wherigo.NoCaseEquals(_Kk7z, _nLZ("\116\069\033\012"))) and (_P8V == 7) then
		_Urwigo.MessageBox{
			Text = _nLZ("\049\079\069\004\116\121\052\055\103\042\062\127\102\103\032\014\054\055\045\112\054\104\127\014\103\047\127\045\121\014\093\052\103\042\052\030\103\046\052\127\055\041\104\121\014\055\103\127\041\103\084\042\104\014\041\127\014\042\014\041\103\052\014\127\103\042\052\041\047\127\103\045\127\041\104\041\127\103\055\127\047\104\127\103\093\127\103\046\052\127\055\041\104\121\014\055\049\079\069\004"), 
			Media = _sL0j
		}
		_sJet8.Active = false
		_sJet8.Visible = false
		_tOwB.Active = true
		_tOwB.Visible = true
		_Gpst:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\031\127\055\121\082\127\103\062\121\052\055\103\042\062\127\102\103\042\052\103\084\121\104\014\055\103\052\014\127\103\047\127\045\121\014\055\127\103\093\127\103\064\042\052\055\055\127\103\127\041\103\104\082\103\062\121\052\055\103\064\042\052\041\103\047\123\121\084\084\127\014\123\127\047\103\123\127\041\041\127\103\102\121\014\127"), 
				Media = _sL0j
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_UdFx)
			end)
		end)
		_Gpst:RequestSync()
	end
end
function _bldj:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_9RsqC = tonumber(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_3YTbl)
	end)
end
function _3YTbl:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_g7L = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_GffQZ)
	end)
end
function _GffQZ:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_jDNmB = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_lRK)
	end)
end
function _lRK:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_IPcmq = input
	if (((_9RsqC == 250) and Wherigo.NoCaseEquals(_g7L, _nLZ("\116\069\033\012"))) and (_jDNmB == 1942)) and Wherigo.NoCaseEquals(_IPcmq, _nLZ("\091\076\091")) then
		_tOwB.Active = false
		_tOwB.Visible = false
		_C76H.Active = true
		_C76H.Visible = true
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\031\127\055\121\082\127\103\062\121\052\055\103\042\062\127\102\103\042\052\103\084\121\104\014\055\103\052\014\127\103\047\127\045\121\014\055\127\103\093\127\103\064\042\052\055\055\127\103\127\041\103\104\082\103\062\121\052\055\103\064\042\052\041\103\047\127\062\127\014\104\047\103\042\052\103\093\127\054\052\041\103\093\127\103\123\127\041\041\127\103\102\121\014\127\103"), 
				Media = _sL0j
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_bldj)
			end)
		end)
	end
end
function _F_0s:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_NY5 = input
	_WtF.Visible = false
	_WtF.Active = false
	_cc2uF.Active = true
	_cc2uF.Visible = true
end
function _oFWdA:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_GX0uQ = input
	if (_NY5 == 1585) and Wherigo.NoCaseEquals(_GX0uQ, _nLZ("\047\127\042\106\104\055\055\127\102")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\049\079\069\004\116\121\052\055\103\042\062\127\102\103\032\014\054\055\045\112\054\104\127\014\103\047\127\045\121\014\093\052\103\042\052\030\103\046\052\127\055\041\104\121\014\055\103\127\041\103\084\042\104\014\041\127\014\042\014\041\103\062\121\052\055\103\045\121\052\062\127\102\103\042\082\082\127\047\103\123\068\127\047\123\068\127\047\103\082\042\103\123\042\123\068\127\103\085\090\055\041\127\047\090\103\032\014\054\055\045\112\001\007\010\085\001\072\007\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			_cc2uF.Active = false
			_cc2uF.Visible = false
			_L2w.Active = true
			_L2w.Visible = true
			_Gpst:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\031\127\055\121\082\127\103\062\121\052\055\103\042\062\127\102\103\042\052\103\084\121\104\014\055\103\052\014\127\103\047\127\045\121\014\055\127\103\093\127\103\064\042\052\055\055\127\103\127\041\103\104\082\103\062\121\052\055\103\064\042\052\041\103\047\127\062\127\014\104\047\103\042\103\082\042\103\102\121\014\127\103\125"), 
				Media = _sL0j
			}
		}, function(action)
			_WtF.Active = true
			_WtF.Visible = true
			_cc2uF.Active = false
			_cc2uF.Visible = false
			_Gpst:RequestSync()
		end)
	end
end
function _JHH:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_5Dr0 = tonumber(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Q6O)
	end)
end
function _Q6O:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_4zCUq = tonumber(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_RiTT)
	end)
end
function _1uP5:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_5Dr0 = tonumber(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_SY_e)
	end)
end
function _QeT1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	__2n = tonumber(input)
	_JKC.Active = false
	_JKC.Visible = false
	_flBN.Active = true
	_flBN.Visible = true
	_Gpst:RequestSync()
end
function _tdX2U:OnGetInput(input)
	if input == nil then
		input = ""
	end
	__2n = tonumber(input)
	_JKC.Active = false
	_JKC.Visible = false
	_flBN.Active = true
	_flBN.Visible = true
	_Gpst:RequestSync()
end
function _lf2f:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_fudB = input
	_SHqsd.Active = false
	_SHqsd.Visible = false
	_JKC.Active = true
	_JKC.Visible = true
	_Gpst:RequestSync()
end
function _s99W:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_jZa3E.Visible = false
	_CTn44 = input
	if _CTn44 == 12000 then
		_N3K.Visible = false
		_N3K.Active = false
		_sJet8.Active = true
		_sJet8.Visible = true
		_Gpst:RequestSync()
	else
		_Urwigo.MessageBox{
			Text = _nLZ("\095\042\103\047\127\055\045\052\127\055\041\042\103\127\055\103\104\014\123\121\047\047\127\123\041\042\073\103\023\014\103\014\052\127\062\121\103\124\052\104\123\104\121\100\055\127\103\073\073\073\103"), 
			Media = _sL0j, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_s99W)
					end)
				end
			end
		}
		_Gpst:RequestSync()
	end
end
function _9JJA:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_fudB = input
	_SHqsd.Active = false
	_SHqsd.Visible = false
	_JKC.Active = true
	_JKC.Visible = true
	_Gpst:RequestSync()
end
function _hIm:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_wul2f = input
	if ((Wherigo.NoCaseEquals(_fudB, _nLZ("\033\055\103\093\127\103\123\121\127\052\047")) and (__2n == 382)) and (_7FkQ6 == 144)) and (_wul2f == 53) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\101\121\052\103\068\042\062\127\103\042\014\055\071\127\047\127\093\103\041\068\127\103\046\052\127\055\041\104\121\014\055\103\042\014\093\103\014\121\071\103\090\121\052\103\123\042\014\103\106\121\103\064\121\047\103\041\068\127\103\085\090\055\041\127\047\090\103\123\042\123\068\127\103\001\007\010\085\001\072\072\103"), 
				Media = _sL0j
			}
		}, function(action)
			_jxu9.Active = false
			_jxu9.Visible = false
			_AhQ5.Active = true
			_AhQ5.Visible = true
			_Gpst:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\061\121\047\047\090\103\090\121\052\103\068\042\062\127\103\042\041\103\082\127\042\055\041\103\121\014\127\103\042\014\055\071\127\047\103\071\047\121\014\106\103\042\014\093\103\090\121\052\103\068\042\062\127\103\041\121\103\106\121\103\054\042\123\063\103\041\121\103\102\121\014\127\103\091"), 
				Media = _sL0j
			}
		}, function(action)
			_jxu9.Active = false
			_jxu9.Visible = false
			_SHqsd.Active = true
			_SHqsd.Visible = true
			_Gpst:RequestSync()
		end)
	end
end
function _s1fKM:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_wul2f = input
	if ((Wherigo.NoCaseEquals(_fudB, _nLZ("\033\055\103\093\127\103\123\121\127\052\047")) and (__2n == 382)) and (_7FkQ6 == 144)) and (_wul2f == 53) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\107\042\103\047\127\055\045\121\014\093\104\093\121\103\042\103\082\042\055\103\045\047\127\106\052\014\041\042\055\103\090\103\042\068\121\047\042\103\052\055\041\127\093\103\045\052\127\093\127\103\104\047\103\045\042\047\042\103\127\082\103\032\014\054\055\045\112\123\042\123\068\127\103\085\104\055\041\127\047\090\103\001\007\010\085\001\072\072"), 
				Media = _sL0j
			}
		}, function(action)
			_jxu9.Active = false
			_jxu9.Visible = false
			_AhQ5.Active = true
			_AhQ5.Visible = true
			_Gpst:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\095\121\103\055\104\127\014\041\121\103\046\052\127\103\068\042\090\042\103\042\082\103\084\127\014\121\055\103\052\014\042\103\047\127\055\045\052\127\055\041\042\103\127\046\052\104\062\121\123\042\093\042\103\090\103\068\042\090\103\046\052\127\103\062\121\082\062\127\047\103\042\082\103\082\042\103\102\121\014\042\103\091"), 
				Media = _sL0j
			}
		}, function(action)
			_jxu9.Active = false
			_jxu9.Visible = false
			_SHqsd.Active = true
			_SHqsd.Visible = true
			_Gpst:RequestSync()
		end)
	end
end
function _FQ8Vx:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_jZa3E.Visible = false
	_CTn44 = input
	if _CTn44 == 12000 then
		_N3K.Visible = false
		_N3K.Active = false
		_sJet8.Active = true
		_sJet8.Visible = true
		_Gpst:RequestSync()
	else
		_Urwigo.MessageBox{
			Text = _nLZ("\087\047\121\014\106\103\042\014\055\071\127\047\073\103\033\103\014\127\071\103\041\047\104\042\082\100"), 
			Media = _sL0j, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_FQ8Vx)
					end)
				end
			end
		}
		_Gpst:RequestSync()
	end
end
function _SY_e:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_4zCUq = tonumber(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_eI3H)
	end)
end
function _eI3H:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Kk7z = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_jzQm)
	end)
end
function _RiTT:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Kk7z = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_LgBS)
	end)
end
function _jzQm:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_P8V = input
	if (((_5Dr0 == 1940) and (_4zCUq == 18185)) and Wherigo.NoCaseEquals(_Kk7z, _nLZ("\067\069\023\024"))) and (_P8V == 7) then
		_Urwigo.MessageBox{
			Text = _nLZ("\049\079\069\004\101\121\052\103\068\042\062\127\103\042\014\055\071\127\047\127\093\103\041\068\127\103\046\052\127\055\041\104\121\014\055\103\042\014\093\103\014\121\071\103\042\014\121\041\068\127\047\103\055\084\042\082\082\103\055\127\047\104\127\055\103\121\064\103\046\052\127\055\041\104\121\014\055\049\079\069\004"), 
			Media = _sL0j
		}
		_sJet8.Active = false
		_sJet8.Visible = false
		_tOwB.Active = true
		_tOwB.Visible = true
		_Gpst:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\061\121\047\047\090\103\090\121\052\103\068\042\062\127\103\042\041\103\082\127\042\055\041\103\121\014\127\103\042\014\055\071\127\047\103\071\047\121\014\106\103\042\014\093\103\090\121\052\103\014\127\127\093\103\047\123\121\084\084\127\014\123\127\047\103\041\068\104\055\103\042\047\127\042"), 
				Media = _sL0j
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_1uP5)
			end)
		end)
		_Gpst:RequestSync()
	end
end
function _LgBS:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_P8V = input
	if (((_5Dr0 == 1940) and (_4zCUq == 18185)) and Wherigo.NoCaseEquals(_Kk7z, _nLZ("\116\024\069\031\033\031"))) and (_P8V == 7) then
		_Urwigo.MessageBox{
			Text = _nLZ("\049\079\069\004\107\042\103\047\127\055\045\121\014\093\104\093\121\103\042\103\082\042\055\103\045\047\127\106\052\014\041\042\055\103\090\103\042\068\121\047\042\103\121\041\047\042\103\045\127\046\052\127\014\042\103\055\127\047\104\127\103\093\127\103\045\047\127\106\052\014\041\042\055\049\079\069\004"), 
			Media = _sL0j
		}
		_sJet8.Active = false
		_sJet8.Visible = false
		_tOwB.Active = true
		_tOwB.Visible = true
		_Gpst:RequestSync()
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\095\121\103\055\104\127\014\041\121\103\046\052\127\103\068\042\090\042\103\042\082\103\084\127\014\121\055\103\052\014\042\103\047\127\055\045\052\127\055\041\042\103\127\046\052\104\062\121\123\042\093\042\103\090\103\014\127\123\127\055\104\041\042\103\047\123\121\084\084\127\014\123\127\047\103\127\055\041\042\103\102\121\014\042\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_JHH)
			end)
		end)
		_Gpst:RequestSync()
	end
end
function _Fox:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_g7L = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_upVK)
	end)
end
function _Nan:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_g7L = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Id_u)
	end)
end
function _upVK:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_jDNmB = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_7i9)
	end)
end
function _Id_u:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_jDNmB = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_5mvqr)
	end)
end
function _7i9:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_IPcmq = input
	if (((_9RsqC == 250) and Wherigo.NoCaseEquals(_g7L, _nLZ("\067\069\023\024"))) and (_jDNmB == 1942)) and Wherigo.NoCaseEquals(_IPcmq, _nLZ("\091\076\091")) then
		_tOwB.Active = false
		_tOwB.Visible = false
		_C76H.Active = true
		_C76H.Visible = true
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\061\121\047\047\090\103\090\121\052\103\068\042\062\127\103\042\041\103\082\127\042\055\041\103\121\014\127\103\042\014\055\071\127\047\103\071\047\121\014\106\103\042\014\093\103\090\121\052\103\084\052\055\041\103\047\127\041\052\047\014\103\041\121\103\041\068\127\103\054\127\106\104\014\014\104\014\106\103\121\064\103\041\068\104\055\103\102\121\014\127\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_wUPHK)
			end)
		end)
	end
end
function _5mvqr:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_IPcmq = input
	if (((_9RsqC == 250) and Wherigo.NoCaseEquals(_g7L, _nLZ("\116\024\069\031\033\031"))) and (_jDNmB == 1942)) and Wherigo.NoCaseEquals(_IPcmq, _nLZ("\091\076\091")) then
		_tOwB.Active = false
		_tOwB.Visible = false
		_C76H.Active = true
		_C76H.Visible = true
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\031\127\055\121\082\127\103\062\121\052\055\103\042\062\127\102\103\042\052\103\084\121\104\014\055\103\052\014\127\103\047\127\045\121\014\055\127\103\093\127\103\064\042\052\055\055\127\103\127\041\103\104\082\103\062\121\052\055\103\064\042\052\041\103\047\127\062\127\014\104\047\103\042\052\103\093\127\054\052\041\103\093\127\103\123\127\041\041\127\103\102\121\014\127\103"), 
				Media = _sL0j
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_Nvl)
			end)
		end)
	end
end
function _3UMw:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_NY5 = input
	_WtF.Visible = false
	_WtF.Active = false
	_cc2uF.Active = true
	_cc2uF.Visible = true
end
function _0f1:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_NY5 = input
	_WtF.Visible = false
	_WtF.Active = false
	_cc2uF.Active = true
	_cc2uF.Visible = true
end
function _T6w:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_GX0uQ = input
	if (_NY5 == 1585) and Wherigo.NoCaseEquals(_GX0uQ, _nLZ("\047\127\042\106\104\055\055\127\102")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\049\079\069\004\101\121\052\103\068\042\062\127\103\042\014\055\071\127\047\127\093\103\041\068\127\103\046\052\127\055\041\104\121\014\055\103\042\014\093\103\014\121\071\103\090\121\052\103\123\042\014\103\106\121\103\064\121\047\103\041\068\127\103\085\090\055\041\127\047\090\103\123\042\123\068\127\103\001\007\010\085\001\072\007\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			_cc2uF.Active = false
			_cc2uF.Visible = false
			_L2w.Active = true
			_L2w.Visible = true
			_Gpst:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\061\121\047\047\090\103\090\121\052\103\068\042\062\127\103\042\041\103\082\127\042\055\041\103\121\014\127\103\042\014\055\071\127\047\103\071\047\121\014\106\103\042\014\093\103\090\121\052\103\084\052\055\041\103\047\127\041\052\047\014\103\041\121\103\041\068\127\103\115\121\014\127\103\125"), 
				Media = _sL0j
			}
		}, function(action)
			_WtF.Active = true
			_WtF.Visible = true
			_cc2uF.Active = false
			_cc2uF.Visible = false
			_Gpst:RequestSync()
		end)
	end
end
function _UyDV:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_GX0uQ = input
	if (_NY5 == 1585) and Wherigo.NoCaseEquals(_GX0uQ, _nLZ("\047\127\042\106\104\055\055\127\102")) then
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\049\079\069\004\107\042\103\047\127\055\045\121\014\093\104\093\121\103\042\103\082\042\055\103\045\047\127\106\052\014\041\042\055\103\090\103\042\068\121\047\042\103\052\055\041\127\093\103\045\052\127\093\127\103\104\047\103\045\042\047\042\103\082\042\103\123\042\123\068\127\103\085\104\055\041\127\047\090\103\001\007\010\085\001\072\007\103\049\079\069\004"), 
				Media = _sL0j
			}
		}, function(action)
			_cc2uF.Active = false
			_cc2uF.Visible = false
			_L2w.Active = true
			_L2w.Visible = true
			_Gpst:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _nLZ("\095\121\103\055\104\127\014\041\121\103\046\052\127\103\068\042\090\042\103\042\082\103\084\127\014\121\055\103\052\014\042\103\047\127\055\045\052\127\055\041\042\103\127\046\052\104\062\121\123\042\093\042\103\090\103\093\127\054\127\103\062\121\082\062\127\047\103\042\103\082\042\103\102\121\014\042\103\125"), 
				Media = _sL0j
			}
		}, function(action)
			_WtF.Active = true
			_WtF.Visible = true
			_cc2uF.Active = false
			_cc2uF.Visible = false
			_Gpst:RequestSync()
		end)
	end
end
function _ehjG:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_7FkQ6 = input
	_flBN.Active = false
	_flBN.Visible = false
	_jxu9.Active = true
	_jxu9.Visible = true
	_Gpst:RequestSync()
end
function _4FJ:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_7FkQ6 = input
	_flBN.Active = false
	_flBN.Visible = false
	_jxu9.Active = true
	_jxu9.Visible = true
	_Gpst:RequestSync()
end
function _Nvl:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_9RsqC = tonumber(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Nan)
	end)
end
function _wUPHK:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_9RsqC = tonumber(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Fox)
	end)
end
function _cWIeu:On_NjXNY(target)
	_iA1AF = _nLZ("\091")
	_cWIeu.Visible = false
	_SHqsd.Active = true
	_SHqsd.Visible = true
end
function _cWIeu:On_siaL(target)
	_iA1AF = _nLZ("\010")
	_cWIeu.Visible = false
	_SHqsd.Active = true
	_SHqsd.Visible = true
end
function _cWIeu:On_Nv8ck(target)
	_iA1AF = _nLZ("\081")
	_cWIeu.Visible = false
	_SHqsd.Active = true
	_SHqsd.Visible = true
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return _Gpst
