require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartSGNWieKentEvent = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartSGNWieKentEvent.MsgBoxCBFuncs = {}

-- Cartridge Info --
cartSGNWieKentEvent.Id="34c86705-57ef-42fb-8ac4-29dc185a7183"
cartSGNWieKentEvent.Name="SGN Wie-Kent-Event"
cartSGNWieKentEvent.Description=[[Deze cartridge is gemaakt voor de wherigo workshop op 26 september tijdens het Wie-Kent-Event van de Stichting Geocaching Nederland. Dit is GEEN Geocache!!]]
cartSGNWieKentEvent.Visible=true
cartSGNWieKentEvent.Activity="TourGuide"
cartSGNWieKentEvent.StartingLocationDescription=[[]]
cartSGNWieKentEvent.StartingLocation = ZonePoint(52.1319166660309,5.75083332061768,0)
cartSGNWieKentEvent.Version="0.1"
cartSGNWieKentEvent.Company="Delta123 & Co"
cartSGNWieKentEvent.Author="Delta123"
cartSGNWieKentEvent.BuilderVersion="2.0.5129.5086"
cartSGNWieKentEvent.CreateDate="9/22/2009 11:01:27 PM"
cartSGNWieKentEvent.PublishDate="1/1/0001 12:00:00 AM"
cartSGNWieKentEvent.UpdateDate="9/24/2009 11:11:55 PM"
cartSGNWieKentEvent.LastPlayedDate="1/1/0001 12:00:00 AM"
cartSGNWieKentEvent.TargetDevice="PocketPC"
cartSGNWieKentEvent.TargetDeviceVersion="0"
cartSGNWieKentEvent.StateId="1"
cartSGNWieKentEvent.CountryId="2"
cartSGNWieKentEvent.Complete=false
cartSGNWieKentEvent.UseLogging=true

-- Zones --
zoneKampeerterrein = Wherigo.Zone(cartSGNWieKentEvent)
zoneKampeerterrein.Id="d12ea25d-6012-4d58-ac69-69c4134da91e"
zoneKampeerterrein.Name="Kampeerterrein"
zoneKampeerterrein.Description=[[Dit is het event-terrein]]
zoneKampeerterrein.Visible=true
zoneKampeerterrein.DistanceRange = Distance(-1, "meters")
zoneKampeerterrein.ShowObjects="OnEnter"
zoneKampeerterrein.ProximityRange = Distance(50, "meters")
zoneKampeerterrein.AllowSetPositionTo=false
zoneKampeerterrein.Active=true
zoneKampeerterrein.Points = {
  ZonePoint(52.15054,5.74071,0),
  ZonePoint(52.15054,5.74123,0),
  ZonePoint(52.15022,5.74123,0),
  ZonePoint(52.15022,5.74071,0)
}
zoneKampeerterrein.OriginalPoint = ZonePoint(52.1503833293915,5.74096666971843,0)
zoneKampeerterrein.DistanceRangeUOM = "Meters"
zoneKampeerterrein.ProximityRangeUOM = "Meters"
zoneKampeerterrein.OutOfRangeName = ""
zoneKampeerterrein.InRangeName = ""

zoneKruising = Wherigo.Zone(cartSGNWieKentEvent)
zoneKruising.Id="f10d02ed-5a44-4e2c-bc4b-c27ab1c0915b"
zoneKruising.Name="Kruising"
zoneKruising.Description=[[Hier start een geocache]]
zoneKruising.Visible=true
zoneKruising.DistanceRange = Distance(500, "meters")
zoneKruising.ShowObjects="OnEnter"
zoneKruising.ProximityRange = Distance(25, "meters")
zoneKruising.AllowSetPositionTo=false
zoneKruising.Active=true
zoneKruising.Points = {
  ZonePoint(52.15225,5.73973,0),
  ZonePoint(52.15225,5.73994,0),
  ZonePoint(52.15212,5.73994,0),
  ZonePoint(52.15212,5.73973,0)
}
zoneKruising.OriginalPoint = ZonePoint(52.1521833260854,5.73983332316081,0)
zoneKruising.DistanceRangeUOM = "Meters"
zoneKruising.ProximityRangeUOM = "Meters"
zoneKruising.OutOfRangeName = ""
zoneKruising.InRangeName = ""

-- Characters --
zcharacterDelta123 = Wherigo.ZCharacter{Cartridge=cartSGNWieKentEvent, Container=zoneKampeerterrein}
zcharacterDelta123.Id="2e6afc35-7f12-4e2b-8cfc-a6930559c825"
zcharacterDelta123.Name="Delta123"
zcharacterDelta123.Description=[[Delta123 en hondje Luuk]]
zcharacterDelta123.Visible=true
zcharacterDelta123.Gender="Male"
zcharacterDelta123.Type="NPC"
zcharacterDelta123.ObjectLocation = ZonePoint(52.1503818813508,5.74096999532127,360)
zcharacterDelta123.Commands = {
  Gajemee = Wherigo.ZCommand{Text="Ga je mee?", CmdWith=false, Enabled=true, EmptyTargetListText="Delta123, heb je zin om met mij een cache te lopen?"},
}
zcharacterDelta123.Commands.Gajemee.Custom = true
zcharacterDelta123.Commands.Gajemee.Id="849ebfd8-c5fd-4c21-9613-be4b2dc0eaee"
zcharacterDelta123.Commands.Gajemee.WorksWithAll = true

zcharacterKarelKraak = Wherigo.ZCharacter{Cartridge=cartSGNWieKentEvent, Container=zoneKampeerterrein}
zcharacterKarelKraak.Id="2a78ad7b-aa2b-42f2-86d8-276c39948478"
zcharacterKarelKraak.Name="KarelKraak"
zcharacterKarelKraak.Description=[[KarelKraak verkoopt de event geocoin]]
zcharacterKarelKraak.Visible=true
zcharacterKarelKraak.Gender="Male"
zcharacterKarelKraak.Type="NPC"
zcharacterKarelKraak.ObjectLocation = ZonePoint(52.1503818813508,5.74096999532127,360)
zcharacterKarelKraak.Commands = {
  koopgeocoin = Wherigo.ZCommand{Text="koop geocoin", CmdWith=true, Enabled=true, EmptyTargetListText="Koop een event geocoin van Karelkraak"},
}
zcharacterKarelKraak.Commands.koopgeocoin.Custom = true
zcharacterKarelKraak.Commands.koopgeocoin.Id="5724bde2-f46f-43df-bb48-ecde1e99974b"
zcharacterKarelKraak.Commands.koopgeocoin.WorksWithAll = false
zcharacterKarelKraak.Commands.koopgeocoin.WorksWithListIds = {"b3c7385d-1fa2-402f-9167-0e182d2be520", }

-- Items --
zitemGeocoin = Wherigo.ZItem{Cartridge=cartSGNWieKentEvent, Container=zoneKampeerterrein}
zitemGeocoin.Id="b3c7385d-1fa2-402f-9167-0e182d2be520"
zitemGeocoin.Name="Geocoin"
zitemGeocoin.Description=[[De prachtige event geocoin ontworprn door KarelKraak]]
zitemGeocoin.Visible=true
zitemGeocoin.ObjectLocation = ZonePoint(52.15038,5.74097,0)
zitemGeocoin.Locked = false
zitemGeocoin.Opened = false

-- Tasks --
ztaskGanaarhetkruispunt = Wherigo.ZTask(cartSGNWieKentEvent)
ztaskGanaarhetkruispunt.Id="6ecaf7f6-91b3-49f7-b5b4-7eaec2392fc1"
ztaskGanaarhetkruispunt.Name="Ga naar het kruispunt"
ztaskGanaarhetkruispunt.Description=[[Ga naar het kruispunt om samenmet Delta123 een cache te gaan doen]]
ztaskGanaarhetkruispunt.Visible=true
ztaskGanaarhetkruispunt.Active=true
ztaskGanaarhetkruispunt.Complete=false
ztaskGanaarhetkruispunt.CorrectState = "None"

ztaskGanaarhetevent = Wherigo.ZTask(cartSGNWieKentEvent)
ztaskGanaarhetevent.Id="ea196cc5-26f2-4319-9b4d-005763b88252"
ztaskGanaarhetevent.Name="Ga naar het event"
ztaskGanaarhetevent.Description=[[Ga naar het event terrein]]
ztaskGanaarhetevent.Visible=true
ztaskGanaarhetevent.Active=true
ztaskGanaarhetevent.Complete=false
ztaskGanaarhetevent.CorrectState = "None"

ztaskKoopeeneventcoin = Wherigo.ZTask(cartSGNWieKentEvent)
ztaskKoopeeneventcoin.Id="e6397f7c-45de-4a3a-ba7d-ff448020662a"
ztaskKoopeeneventcoin.Name="Koop een event coin"
ztaskKoopeeneventcoin.Description=[[Koop een event coin als herinering aan deze bijzondere dag]]
ztaskKoopeeneventcoin.Visible=true
ztaskKoopeeneventcoin.Active=true
ztaskKoopeeneventcoin.Complete=false
ztaskKoopeeneventcoin.CorrectState = "None"

-- Cartridge Variables --
-- Builder Variables (to be read by the builder only) --
buildervar = {}
-- ZTimers --

-- Inputs --

-- WorksWithList for zobject zcommands --
zcharacterKarelKraak.Commands.koopgeocoin.WorksWithList={zitemGeocoin, }

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function zoneKampeerterrein:OnProximity()
-- #GroupDescription=camping --
-- #Comment=camping Comment --
ztaskGanaarhetevent.Complete = true
Wherigo.MessageBox{Text=[[Welkom op het event. Lekker kletsen en genieten op dit event midden in de natuur. Er is ook een prachtige event geocoin te koop bij KarelKraak. Zoek hem maar op om er eentje te kopen. Maar hier beginnen ook prachtige caches. Zoek Delta123 op en ga met hem op pad.]],Buttons={"ok",},Callback=cartSGNWieKentEvent.MsgBoxCBFuncs.MsgBoxCB1}
end

function cartSGNWieKentEvent:OnStart()
-- #GroupDescription=start --
-- #Comment=start Comment --
zcharacterKarelKraak.Visible = false
zoneKruising.Visible = false
ztaskGanaarhetkruispunt.Visible = false
zcharacterDelta123.Visible = false
end

function zoneKampeerterrein:OnEnter()
-- #GroupDescription=camping --
-- #Comment=camping Comment --
ztaskGanaarhetevent.Complete = true
zcharacterDelta123.Visible = true
zcharacterKarelKraak.Visible = true
end

function zcharacterKarelKraak:Onkoopgeocoin(target)
-- #GroupDescription=geocoin --
-- #Comment=geocoin Comment --
ztaskKoopeeneventcoin.Complete = true
zitemGeocoin:MoveTo(Player)
end

function zcharacterDelta123:OnGajemee()
-- #GroupDescription=antwoord --
-- #Comment=antwoord Comment --
Wherigo.MessageBox{Text=[[Jahoor, ik ga graag met je mee! Mag Luuk ook mee?]],Buttons={"Natuurlijk","Liever niet",},Callback=cartSGNWieKentEvent.MsgBoxCBFuncs.MsgBoxCB2}
zoneKruising.Visible = true
end

function zoneKruising:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
ztaskGanaarhetkruispunt.Complete = true
Wherigo.MessageBox{Text=[[Op dit kruispunt kan je beginnen met een echte geocache. Deze wherigo is nu klaar.Je hebt alle taken volbracht. Alsje nu op ok klikt zal deze wherigo worden opgeslagen en beeindigd.]],Buttons={"Ok",},Callback=cartSGNWieKentEvent.MsgBoxCBFuncs.MsgBoxCB3}
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=3#--
cartSGNWieKentEvent.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=delta123 --
-- #Comment=delta123 Comment --
ztaskGanaarhetkruispunt.Visible = true
end
end

cartSGNWieKentEvent.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
if action ~= nil then
-- #GroupDescription=klaar --
-- #Comment=klaar Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartSGNWieKentEvent.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
if action ~= nil then
-- #GroupDescription=einde --
-- #Comment=einde Comment --
Wherigo.Command("SaveClose")
end
end

------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
-- #End Author Functions# --
-- Nothing after this line --
return cartSGNWieKentEvent
