require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

cartRenameMe7 = Wherigo.ZCartridge()

-- String decode --
function _37kNH(str)
	local res = ""
    local dtable = "\084\018\045\039\014\031\103\026\116\096\119\081\074\075\063\050\007\093\047\098\043\002\053\029\072\036\001\087\009\049\113\000\107\111\042\078\121\017\091\122\015\092\115\025\067\109\112\020\071\037\082\004\070\102\069\054\125\064\013\023\048\123\058\024\057\052\044\101\097\076\005\106\010\040\027\104\065\066\110\046\016\059\034\085\003\086\120\095\099\051\028\041\032\055\019\012\088\006\056\061\094\068\117\035\021\124\062\079\080\030\108\118\100\073\033\114\022\060\105\083\090\089\008\011\126\077\038"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
zmediastart = Wherigo.ZMedia(cartRenameMe7)
zmediastart.Id = "9109d7cb-2b19-4c2d-bb13-cdc9c49d5821"
zmediastart.Name = _37kNH("\043\009\069\116\009")
zmediastart.Description = ""
zmediastart.AltText = ""
zmediastart.Resources = {
	{
		Type = "JPG", 
		Filename = "1093.JPG", 
		Directives = {}
	}
}
zmediago = Wherigo.ZMedia(cartRenameMe7)
zmediago.Id = "9006148d-146f-4124-b838-3f832c32cce6"
zmediago.Name = _37kNH("\007\034")
zmediago.Description = ""
zmediago.AltText = ""
zmediago.Resources = {
	{
		Type = "jpg", 
		Filename = "Go1.jpg", 
		Directives = {}
	}
}
zmediaquestion = Wherigo.ZMedia(cartRenameMe7)
zmediaquestion.Id = "8b853d34-57fb-40d7-b8fc-0be8a1c93c48"
zmediaquestion.Name = _37kNH("\031\103\068\043\009\119\034\079")
zmediaquestion.Description = ""
zmediaquestion.AltText = ""
zmediaquestion.Resources = {
	{
		Type = "jpg", 
		Filename = "Question.jpg", 
		Directives = {}
	}
}
zmediafinal = Wherigo.ZMedia(cartRenameMe7)
zmediafinal.Id = "9145d5d3-422f-44a9-a36c-e3fffc217686"
zmediafinal.Name = _37kNH("\054\119\079\069\111")
zmediafinal.Description = ""
zmediafinal.AltText = ""
zmediafinal.Resources = {
	{
		Type = "JPG", 
		Filename = "003_3.JPG", 
		Directives = {}
	}
}
zmediawrong = Wherigo.ZMedia(cartRenameMe7)
zmediawrong.Id = "0a41effd-3466-46a2-84ba-c6528768fe57"
zmediawrong.Name = _37kNH("\011\116\034\079\007")
zmediawrong.Description = ""
zmediawrong.AltText = ""
zmediawrong.Resources = {
	{
		Type = "jpg", 
		Filename = "Wrong.jpg", 
		Directives = {}
	}
}
__nAI1 = Wherigo.ZMedia(cartRenameMe7)
__nAI1.Id = "8ec009d9-9e7f-47e1-aa2e-35dee843db85"
__nAI1.Name = _37kNH("\053\119\111\089\076\068\116\093\053\119\043\076\119\079\007")
__nAI1.Description = ""
__nAI1.AltText = ""
__nAI1.Resources = {
	{
		Type = "JPG", 
		Filename = "Filchner1.JPG", 
		Directives = {}
	}
}
_DRWPv = Wherigo.ZMedia(cartRenameMe7)
_DRWPv.Id = "aff102b0-cb90-43ee-9f01-3102af71206c"
_DRWPv.Name = _37kNH("\001\076\068\093\102\034\089\009\034\116")
_DRWPv.Description = ""
_DRWPv.AltText = ""
_DRWPv.Resources = {
	{
		Type = "JPG", 
		Filename = "TheDoctor1.JPG", 
		Directives = {}
	}
}
_bDCI = Wherigo.ZMedia(cartRenameMe7)
_bDCI.Id = "37578260-07c8-4f3f-8ae8-62dcf60dee41"
_bDCI.Name = _37kNH("\055\116\068\089\009\068\113\093\113\069\009\068")
_bDCI.Description = ""
_bDCI.AltText = ""
_bDCI.Resources = {
	{
		Type = "JPG", 
		Filename = "003_1.JPG", 
		Directives = {}
	}
}
_mTa = Wherigo.ZMedia(cartRenameMe7)
_mTa.Id = "c1339a51-480b-4222-a0fc-3dffb9967858"
_mTa.Name = _37kNH("\028\116\068\069\009\076\093\012\103\068\043\009\119\034\079")
_mTa.Description = ""
_mTa.AltText = ""
_mTa.Resources = {
	{
		Type = "JPG", 
		Filename = "March1.JPG", 
		Directives = {}
	}
}
_6bZ5u = Wherigo.ZMedia(cartRenameMe7)
_6bZ5u.Id = "3bf9a098-e7fc-49b9-9d18-0f9eeeb17b3a"
_6bZ5u.Name = _37kNH("\028\116\068\069\009\076\093\012\103\068\043\009\119\034\079\093\011\116\034\079\007")
_6bZ5u.Description = ""
_6bZ5u.AltText = ""
_6bZ5u.Resources = {
	{
		Type = "JPG", 
		Filename = "Wreathsquestionwrong.JPG", 
		Directives = {}
	}
}
_evzt = Wherigo.ZMedia(cartRenameMe7)
_evzt.Id = "abe6f62a-de4d-42e9-9d3c-41ae5ab3afba"
_evzt.Name = _37kNH("\046\119\046\119")
_evzt.Description = ""
_evzt.AltText = ""
_evzt.Resources = {
	{
		Type = "JPG", 
		Filename = "mimi.JPG", 
		Directives = {}
	}
}
_XBY = Wherigo.ZMedia(cartRenameMe7)
_XBY.Id = "f1b69f32-6146-4d68-9a1e-24b60a040e81"
_XBY.Name = _37kNH("\078\119\043\034\079\093\001\103\020\068")
_XBY.Description = ""
_XBY.AltText = ""
_XBY.Resources = {
	{
		Type = "JPG", 
		Filename = "005_2.JPG", 
		Directives = {}
	}
}
_MVv = Wherigo.ZMedia(cartRenameMe7)
_MVv.Id = "44026399-deb3-450b-bbc1-8af1b32e1d6f"
_MVv.Name = _37kNH("\089\069\116\043")
_MVv.Description = ""
_MVv.AltText = ""
_MVv.Resources = {
	{
		Type = "JPG", 
		Filename = "Cars1.JPG", 
		Directives = {}
	}
}
_ypz = Wherigo.ZMedia(cartRenameMe7)
_ypz.Id = "69c7e4e7-aae3-4151-9018-78a3b8f92942"
_ypz.Name = _37kNH("\001\034\047\093\102\034\007")
_ypz.Description = ""
_ypz.AltText = ""
_ypz.Resources = {
	{
		Type = "JPG", 
		Filename = "RosenberryDog1.JPG", 
		Directives = {}
	}
}
_mU9PC = Wherigo.ZMedia(cartRenameMe7)
_mU9PC.Id = "13d31a53-59de-4e35-b6a4-a99d8364ee0e"
_mU9PC.Name = _37kNH("\120\111\068\113\043")
_mU9PC.Description = ""
_mU9PC.AltText = ""
_mU9PC.Resources = {
	{
		Type = "JPG", 
		Filename = "004.JPG", 
		Directives = {}
	}
}
_Z6Edj = Wherigo.ZMedia(cartRenameMe7)
_Z6Edj.Id = "2efbb5e5-6917-4589-a96f-d5be40eacf2a"
_Z6Edj.Name = _37kNH("\113\068\068\116")
_Z6Edj.Description = ""
_Z6Edj.AltText = ""
_Z6Edj.Resources = {
	{
		Type = "JPG", 
		Filename = "005.JPG", 
		Directives = {}
	}
}
_mMP = Wherigo.ZMedia(cartRenameMe7)
_mMP.Id = "7ead3292-8a2d-43fe-8553-4488e5140b25"
_mMP.Name = _37kNH("\077\079\007\068\111")
_mMP.Description = ""
_mMP.AltText = ""
_mMP.Resources = {
	{
		Type = "JPG", 
		Filename = "003_2.JPG", 
		Directives = {}
	}
}
_xzww = Wherigo.ZMedia(cartRenameMe7)
_xzww.Id = "ab203b7a-e437-446f-9f47-ec29730378a9"
_xzww.Name = _37kNH("\079\119\089\033\103\046")
_xzww.Description = ""
_xzww.AltText = ""
_xzww.Resources = {
	{
		Type = "JPG", 
		Filename = "nickum.JPG", 
		Directives = {}
	}
}
_hSLQ = Wherigo.ZMedia(cartRenameMe7)
_hSLQ.Id = "6a6189ef-a456-4ec6-b9bb-d3c091c829af"
_hSLQ.Name = _37kNH("\046\119\033\068\037")
_hSLQ.Description = ""
_hSLQ.AltText = ""
_hSLQ.Resources = {
	{
		Type = "JPG", 
		Filename = "mikey.JPG", 
		Directives = {}
	}
}
_8z2 = Wherigo.ZMedia(cartRenameMe7)
_8z2.Id = "ac9c7c81-bc96-4aab-8b80-2930787e5a3f"
_8z2.Name = _37kNH("\111\069\046\020")
_8z2.Description = ""
_8z2.AltText = ""
_8z2.Resources = {
	{
		Type = "JPG", 
		Filename = "Lamb.JPG", 
		Directives = {}
	}
}
_MKGdN = Wherigo.ZMedia(cartRenameMe7)
_MKGdN.Id = "6f127a3f-33f7-40ec-a696-7f0338962a7c"
_MKGdN.Name = _37kNH("\126\069\047")
_MKGdN.Description = ""
_MKGdN.AltText = ""
_MKGdN.Resources = {
	{
		Type = "JPG", 
		Filename = "002_2.JPG", 
		Directives = {}
	}
}
_wZM = Wherigo.ZMedia(cartRenameMe7)
_wZM.Id = "248e7c65-ed1e-4362-b141-8079f13ace84"
_wZM.Name = _37kNH("\116\034\111\111\068\113\093\111\034\007")
_wZM.Description = ""
_wZM.AltText = ""
_wZM.Resources = {
	{
		Type = "JPG", 
		Filename = "002_1.JPG", 
		Directives = {}
	}
}
_LzUU = Wherigo.ZMedia(cartRenameMe7)
_LzUU.Id = "5f53b516-5cdf-4bca-a6c2-a57847aad19f"
_LzUU.Name = _37kNH("\103\043\068\113\093\111\034\007")
_LzUU.Description = ""
_LzUU.AltText = ""
_LzUU.Resources = {
	{
		Type = "JPG", 
		Filename = "014_1.JPG", 
		Directives = {}
	}
}
_T7a = Wherigo.ZMedia(cartRenameMe7)
_T7a.Id = "ac3b6a29-024c-4e82-a12c-c4d4f088c9f2"
_T7a.Name = _37kNH("\109\053\045")
_T7a.Description = ""
_T7a.AltText = ""
_T7a.Resources = {
	{
		Type = "JPG", 
		Filename = "006.JPG", 
		Directives = {}
	}
}
_1P0 = Wherigo.ZMedia(cartRenameMe7)
_1P0.Id = "efec336a-323d-4815-981b-1f3ac9f03608"
_1P0.Name = _37kNH("\108\093\051\119\079\007")
_1P0.Description = ""
_1P0.AltText = ""
_1P0.Resources = {
	{
		Type = "JPG", 
		Filename = "014_2.JPG", 
		Directives = {}
	}
}
_cMebx = Wherigo.ZMedia(cartRenameMe7)
_cMebx.Id = "f2cad4fc-145c-499d-8776-24d6e5665993"
_cMebx.Name = _37kNH("\120\047\034\119\111\068\116")
_cMebx.Description = ""
_cMebx.AltText = ""
_cMebx.Resources = {
	{
		Type = "JPG", 
		Filename = "003_4.JPG", 
		Directives = {}
	}
}
-- Cartridge Info --
cartRenameMe7.Id="4d199035-0b3c-4221-9913-a6bf91082b9f"
cartRenameMe7.Name="Hope Cemetery Hecktown"
cartRenameMe7.Description=[[This Wherigo cartridge takes place in Hope Cemetery off Route 191 near Lower Nazareth Park. The can be done as a complete walking tour or you can drive from zone to zone just hopping in and out of the car to get your answers.  Just be sure to give correct answers or you will have a much longer journey. You may want to bring some supplies along including water, pencil, paper, cache repair supplies, CITO bag, and a device with internet access or a phone to call someone that does as it may help you answer a question here or there. I am hoping this wherigo will show you some of the abilities of this type cache and maybe inspire you to give designing one a try!  This was desinged using the Urwigo program! This wherigo leads to geocache GC34A0R which can be found on www.geocaching.com]]
cartRenameMe7.Visible=true
cartRenameMe7.Activity="Geocache"
cartRenameMe7.StartingLocationDescription=[[This cartridge starts at the northern entrance to Hope Cemetery off Route 191 in Lower Nazareth Township, Pa.
Geocache GC34A0R coordinates N40 42.056 W075 19.841]]
cartRenameMe7.StartingLocation = ZonePoint(40.7009394456746,-75.3306897759437,0)
cartRenameMe7.Version=""
cartRenameMe7.Company=""
cartRenameMe7.Author="agility3d"
cartRenameMe7.BuilderVersion="URWIGO 1.12.4091.37853"
cartRenameMe7.CreateDate="05/06/2011 09:55:07"
cartRenameMe7.PublishDate="1/1/0001 12:00:00 AM"
cartRenameMe7.UpdateDate="09/18/2011 18:42:19"
cartRenameMe7.LastPlayedDate="1/1/0001 12:00:00 AM"
cartRenameMe7.TargetDevice="PocketPC"
cartRenameMe7.TargetDeviceVersion="0"
cartRenameMe7.StateId="1"
cartRenameMe7.CountryId="2"
cartRenameMe7.Complete=false
cartRenameMe7.UseLogging=true

cartRenameMe7.Media=zmediastart

cartRenameMe7.Icon=zmediastart


-- Zones --
zonestage1 = Wherigo.Zone(cartRenameMe7)
zonestage1.Id = "d8114fea-3569-4903-9eff-1caefcd9ecdf"
zonestage1.Name = _37kNH("\120\009\069\007\068\093\030")
zonestage1.Description = _37kNH("\049\034\093\009\034\093\009\076\068\093\045\068\079\009\068\116\093\045\119\116\089\111\068\115")
zonestage1.Visible = true
zonestage1.Media = zmediago
zonestage1.Commands = {}
zonestage1.DistanceRange = Distance(1500, "feet")
zonestage1.ShowObjects = "OnEnter"
zonestage1.ProximityRange = Distance(200, "feet")
zonestage1.AllowSetPositionTo = false
zonestage1.Active = true
zonestage1.Points = {
	ZonePoint(40.7006472461667, -75.3319801787281, 0), 
	ZonePoint(40.7005648911887, -75.331686476841, 0), 
	ZonePoint(40.7003066415847, -75.3318111995603, 0), 
	ZonePoint(40.7004083147766, -75.3321062425518, 0)
}
zonestage1.OriginalPoint = ZonePoint(43.1254666646322, -86.2755166689555, 0)
zonestage1.DistanceRangeUOM = "Feet"
zonestage1.ProximityRangeUOM = "Feet"
zonestage1.OutOfRangeName = ""
zonestage1.InRangeName = ""
zonestage2 = Wherigo.Zone(cartRenameMe7)
zonestage2.Id = "46cedd91-d932-4e2c-9dd5-7d24ae8fc96d"
zonestage2.Name = _37kNH("\043\009\069\007\068\093\016")
zonestage2.Description = _37kNH("\108\079\093\037\034\103\116\093\011\069\037\093\009\034\093\120\009\069\007\068\093\016\093\069\116\068\069\080\118\078\051\107\118\078\051\107")
zonestage2.Visible = false
zonestage2.Media = zmediago
zonestage2.Commands = {}
zonestage2.DistanceRange = Distance(1500, "feet")
zonestage2.ShowObjects = "OnEnter"
zonestage2.ProximityRange = Distance(200, "feet")
zonestage2.AllowSetPositionTo = false
zonestage2.Active = false
zonestage2.Points = {
	ZonePoint(40.701416819004, -75.3308117796564, 0), 
	ZonePoint(40.7013131139168, -75.3304832090521, 0), 
	ZonePoint(40.7016232119814, -75.3303048421527, 0), 
	ZonePoint(40.7017116659188, -75.3306562115336, 0)
}
zonestage2.OriginalPoint = ZonePoint(43.1257999976476, -86.2757500012716, 0)
zonestage2.DistanceRangeUOM = "Feet"
zonestage2.ProximityRangeUOM = "Feet"
zonestage2.OutOfRangeName = ""
zonestage2.InRangeName = ""
zonestage3 = Wherigo.Zone(cartRenameMe7)
zonestage3.Id = "dbb4aa4d-44d9-42e5-84d3-bfc2e05b5e3a"
zonestage3.Name = _37kNH("\043\009\069\007\068\093\090")
zonestage3.Description = _37kNH("\025\068\069\113\119\079\007\093\009\034\093\043\009\069\007\068\093\090\093\054\034\116\093\046\034\116\068\093\054\103\079\115")
zonestage3.Visible = false
zonestage3.Media = zmediago
zonestage3.Commands = {}
zonestage3.DistanceRange = Distance(1500, "feet")
zonestage3.ShowObjects = "OnEnter"
zonestage3.ProximityRange = Distance(200, "feet")
zonestage3.AllowSetPositionTo = false
zonestage3.Active = false
zonestage3.Points = {
	ZonePoint(40.7017061167219, -75.3318190976644, 0), 
	ZonePoint(40.7020395972046, -75.3316393896604, 0), 
	ZonePoint(40.7021656686595, -75.3321248694921, 0), 
	ZonePoint(40.7018525229931, -75.3323099419142, 0)
}
zonestage3.OriginalPoint = ZonePoint(43.126016664505, -86.2758666674296, 0)
zonestage3.DistanceRangeUOM = "Feet"
zonestage3.ProximityRangeUOM = "Feet"
zonestage3.OutOfRangeName = ""
zonestage3.InRangeName = ""
zonestage4 = Wherigo.Zone(cartRenameMe7)
zonestage4.Id = "3e8abcd9-20a9-4574-8288-d16d3e29402e"
zonestage4.Name = _37kNH("\043\009\069\007\068\093\066")
zonestage4.Description = _37kNH("\049\034\119\079\007\093\009\034\093\043\009\069\007\068\093\066\093\111\034\089\069\009\119\034\079\093\114\093\011\034\079\113\068\116\093\011\076\069\009\093\119\043\093\119\079\093\043\009\034\116\068\093\009\076\068\116\068\115")
zonestage4.Visible = false
zonestage4.Media = zmediago
zonestage4.Commands = {}
zonestage4.DistanceRange = Distance(1500, "feet")
zonestage4.ShowObjects = "OnEnter"
zonestage4.ProximityRange = Distance(200, "feet")
zonestage4.AllowSetPositionTo = false
zonestage4.Active = false
zonestage4.Points = {
	ZonePoint(40.7025489650851, -75.3330086573625, 0), 
	ZonePoint(40.7023537586931, -75.3322361811663, 0), 
	ZonePoint(40.7018799741331, -75.3324936732317, 0), 
	ZonePoint(40.7020792487363, -75.333271513846, 0)
}
zonestage4.OriginalPoint = ZonePoint(43.1262666702271, -86.2759833335876, 0)
zonestage4.DistanceRangeUOM = "Feet"
zonestage4.ProximityRangeUOM = "Feet"
zonestage4.OutOfRangeName = ""
zonestage4.InRangeName = ""
zonestage6 = Wherigo.Zone(cartRenameMe7)
zonestage6.Id = "8f07f78e-6e85-4bd7-b55a-293e68c44fe6"
zonestage6.Name = _37kNH("\043\009\069\007\068\093\056")
zonestage6.Description = _37kNH("\049\034\119\079\007\093\009\034\093\009\076\068\093\043\119\087\009\076\093\043\009\069\007\068\115\093\114\043\093\009\076\069\009\093\069\079\037\009\076\119\079\007\093\111\119\033\068\093\069\093\043\119\087\009\076\093\043\068\079\043\068\015")
zonestage6.Visible = false
zonestage6.Media = zmediago
zonestage6.Commands = {}
zonestage6.DistanceRange = Distance(1500, "feet")
zonestage6.ShowObjects = "OnEnter"
zonestage6.ProximityRange = Distance(200, "feet")
zonestage6.AllowSetPositionTo = false
zonestage6.Active = false
zonestage6.Points = {
	ZonePoint(40.700286772578, -75.3325097664859, 0), 
	ZonePoint(40.6998678772657, -75.3327753051783, 0), 
	ZonePoint(40.6997041820224, -75.33236224499, 0), 
	ZonePoint(40.7001535804222, -75.3320859774615, 0)
}
zonestage6.OriginalPoint = ZonePoint(43.1273333311081, -86.2765500068665, 0)
zonestage6.DistanceRangeUOM = "Feet"
zonestage6.ProximityRangeUOM = "Feet"
zonestage6.OutOfRangeName = ""
zonestage6.InRangeName = ""
zonestage5 = Wherigo.Zone(cartRenameMe7)
zonestage5.Id = "6d5798d6-ef7a-44b9-9e53-fdf40ba73643"
zonestage5.Name = _37kNH("\043\009\069\007\068\093\023")
zonestage5.Description = _37kNH("\025\068\069\113\068\113\093\009\034\093\043\009\069\007\068\093\023\115\093\025\069\111\054\093\011\069\037\093\076\034\046\068\115")
zonestage5.Visible = false
zonestage5.Media = zmediago
zonestage5.Commands = {}
zonestage5.DistanceRange = Distance(1500, "feet")
zonestage5.ShowObjects = "OnEnter"
zonestage5.ProximityRange = Distance(200, "feet")
zonestage5.AllowSetPositionTo = false
zonestage5.Active = false
zonestage5.Points = {
	ZonePoint(40.7014743061345, -75.3323045774961, 0), 
	ZonePoint(40.7013746680025, -75.3319719835782, 0), 
	ZonePoint(40.7008205552635, -75.3322764143015, 0), 
	ZonePoint(40.7009242611176, -75.3326063260103, 0)
}
zonestage5.OriginalPoint = ZonePoint(43.1269500017166, -86.2765500068665, 0)
zonestage5.DistanceRangeUOM = "Feet"
zonestage5.ProximityRangeUOM = "Feet"
zonestage5.OutOfRangeName = ""
zonestage5.InRangeName = ""
zoneFinalHide = Wherigo.Zone(cartRenameMe7)
zoneFinalHide.Id = "ffbde1db-f97f-4904-bb64-9a8506b5f235"
zoneFinalHide.Name = _37kNH("\120\009\069\007\068\093\099")
zoneFinalHide.Description = _37kNH("\049\034\119\079\007\093\009\034\093\009\076\068\093\054\119\079\069\111\093\043\009\069\007\068\067\093\043\034\034\079\093\037\034\103\093\011\119\111\111\093\020\068\093\113\034\079\068\115")
zoneFinalHide.Visible = false
zoneFinalHide.Media = zmediago
zoneFinalHide.Commands = {}
zoneFinalHide.DistanceRange = Distance(1500, "feet")
zoneFinalHide.ShowObjects = "OnEnter"
zoneFinalHide.ProximityRange = Distance(200, "feet")
zoneFinalHide.AllowSetPositionTo = false
zoneFinalHide.Active = false
zoneFinalHide.Points = {
	ZonePoint(40.699674696501, -75.3323769971395, 0), 
	ZonePoint(40.6996065747294, -75.3322294756437, 0), 
	ZonePoint(40.6997845045834, -75.3321315750146, 0), 
	ZonePoint(40.6998414420362, -75.3322723909879, 0)
}
zoneFinalHide.OriginalPoint = ZonePoint(43.1283333301544, -86.275999991099, 0)
zoneFinalHide.DistanceRangeUOM = "Feet"
zoneFinalHide.ProximityRangeUOM = "Feet"
zoneFinalHide.OutOfRangeName = ""
zoneFinalHide.InRangeName = ""
zonestage7 = Wherigo.Zone(cartRenameMe7)
zonestage7.Id = "efc8df11-92f2-4145-97f0-ee65a16ba5d0"
zonestage7.Name = _37kNH("\043\009\069\007\068\093\094")
zonestage7.Description = _37kNH("\049\034\119\079\007\093\009\034\093\043\009\069\007\068\093\111\034\089\069\009\119\034\079\093\094\093\009\076\068\116\068\093\069\116\068\093\111\034\009\043\093\034\054\093\037\034\103\079\007\093\034\079\068\043\093\076\068\116\068\115")
zonestage7.Visible = false
zonestage7.Media = zmediago
zonestage7.Commands = {}
zonestage7.DistanceRange = Distance(1500, "feet")
zonestage7.ShowObjects = "OnEnter"
zonestage7.ProximityRange = Distance(200, "feet")
zonestage7.AllowSetPositionTo = false
zonestage7.Active = false
zonestage7.Points = {
	ZonePoint(40.6994296611462, -75.332922826674, 0), 
	ZonePoint(40.699355438641, -75.3326921566987, 0), 
	ZonePoint(40.6991683568909, -75.3327444597746, 0), 
	ZonePoint(40.6992202111243, -75.3330301150347, 0)
}
zonestage7.OriginalPoint = ZonePoint(43.1281666676203, -86.2768833478292, 0)
zonestage7.DistanceRangeUOM = "Feet"
zonestage7.ProximityRangeUOM = "Feet"
zonestage7.OutOfRangeName = ""
zonestage7.InRangeName = ""

-- Characters --
_h9zdY = Wherigo.ZCharacter(cartRenameMe7)
_h9zdY.Id = "55efa624-cf3a-4c67-a3b3-98c648d2064f"
_h9zdY.Name = _37kNH("\045\069\116\068\009\069\033\068\116")
_h9zdY.Description = ""
_h9zdY.Visible = false
_h9zdY.Commands = {}
_h9zdY.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_h9zdY.Gender = "Male"
_h9zdY.Type = "NPC"

-- Items --
_KJi_ = Wherigo.ZItem(cartRenameMe7)
_KJi_.Id = "6fb10df3-4896-4b6c-b53f-41e720cba236"
_KJi_.Name = _37kNH("\047\068\079\069\111\009\037\093\046\069\116\033\068\116")
_KJi_.Description = _37kNH("\047\068\079\069\111\009\037\093\046\069\116\033\068\116")
_KJi_.Visible = false
_KJi_.Commands = {}
_KJi_.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_KJi_.Locked = false
_KJi_.Opened = false
_iIY7 = Wherigo.ZItem(cartRenameMe7)
_iIY7.Id = "508d522b-8f63-4c08-9cba-749fc6c98331"
_iIY7.Name = _37kNH("\020\069\089\033\093\034\079\093\009\116\069\089\033")
_iIY7.Description = _37kNH("\020\069\089\033\093\054\116\034\046\093\047\068\079\069\111\009\037\118\078\051\107")
_iIY7.Visible = false
_iIY7.Commands = {}
_iIY7.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_iIY7.Locked = false
_iIY7.Opened = false
_8x0t8 = Wherigo.ZItem{
	Cartridge = cartRenameMe7, 
	Container = zonestage2
}
_8x0t8.Id = "56398bdb-a310-4222-8756-2703bfe2b750"
_8x0t8.Name = _37kNH("\078\119\043\034\079\093\001\103\020\068")
_8x0t8.Description = _37kNH("\077\093\043\046\069\111\111\093\089\069\089\076\068\093\089\034\079\009\069\119\079\068\116")
_8x0t8.Visible = false
_8x0t8.Media = _XBY
_8x0t8.Icon = _XBY
_8x0t8.Commands = {
	_7uab = Wherigo.ZCommand{
		Text = _37kNH("\109\119\089\033\093\084\047"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _37kNH("\036\034\009\076\119\079\007\093\069\112\069\119\111\069\020\111\068")
	}, 
	_QECI = Wherigo.ZCommand{
		Text = _37kNH("\055\087\069\046\119\079\068"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _37kNH("\036\034\009\076\119\079\007\093\069\112\069\119\111\069\020\111\068")
	}, 
	__1F = Wherigo.ZCommand{
		Text = _37kNH("\051\068\047\111\069\089\068\093\083\108\083\093\051\119\079\007"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _37kNH("\036\034\009\076\119\079\007\093\069\112\069\119\111\069\020\111\068")
	}, 
	_mv8s = Wherigo.ZCommand{
		Text = _37kNH("\051\068\047\111\069\089\068\093\070\034\007"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _37kNH("\036\034\009\076\119\079\007\093\069\112\069\119\111\069\020\111\068")
	}
}
_8x0t8.Commands._7uab.Custom = true
_8x0t8.Commands._7uab.Id = "cde082c5-5e96-41c3-a39d-59ba4d7cb1b1"
_8x0t8.Commands._7uab.WorksWithAll = true
_8x0t8.Commands._QECI.Custom = true
_8x0t8.Commands._QECI.Id = "9080ff31-7c17-4ab2-9675-ac88dcd4c37f"
_8x0t8.Commands._QECI.WorksWithAll = true
_8x0t8.Commands.__1F.Custom = true
_8x0t8.Commands.__1F.Id = "fc4acf4c-2977-4c26-b708-b41e4a8529dd"
_8x0t8.Commands.__1F.WorksWithAll = true
_8x0t8.Commands._mv8s.Custom = true
_8x0t8.Commands._mv8s.Id = "780c2f57-d6af-45db-ada5-7561ed42b780"
_8x0t8.Commands._mv8s.WorksWithAll = true
_8x0t8.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_8x0t8.Locked = false
_8x0t8.Opened = false
_kYaKR = Wherigo.ZItem(cartRenameMe7)
_kYaKR.Id = "f57b3f2f-742f-419c-9977-a4712d927762"
_kYaKR.Name = _37kNH("\114\079\093\120\069\054\068")
_kYaKR.Description = ""
_kYaKR.Visible = false
_kYaKR.Commands = {}
_kYaKR.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_kYaKR.Locked = false
_kYaKR.Opened = false
_l0r = Wherigo.ZItem(cartRenameMe7)
_l0r.Id = "d3a37bea-b628-4e69-b887-f4b4f615fe74"
_l0r.Name = _37kNH("\047\068\079\069\111\009\037\093\046\069\116\033\068\116\093\016")
_l0r.Description = ""
_l0r.Visible = false
_l0r.Commands = {}
_l0r.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_l0r.Locked = false
_l0r.Opened = false
_RdecT = Wherigo.ZItem(cartRenameMe7)
_RdecT.Id = "664df4da-33d4-4a51-8059-ea21816a100b"
_RdecT.Name = _37kNH("\009\119\046\068\093\068\111\069\047\043\068\113")
_RdecT.Description = ""
_RdecT.Visible = true
_RdecT.Commands = {}
_RdecT.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_RdecT.Locked = false
_RdecT.Opened = false
_edW = Wherigo.ZItem(cartRenameMe7)
_edW.Id = "f49ed964-b3b3-4ae1-89e5-c8097d144b52"
_edW.Name = _37kNH("\046\069\047")
_edW.Description = ""
_edW.Visible = false
_edW.Media = _MKGdN
_edW.Commands = {
	_5eQCy = Wherigo.ZCommand{
		Text = _37kNH("\109\119\089\033\093\084\047"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _37kNH("\036\034\009\076\119\079\007\093\069\112\069\119\111\069\020\111\068")
	}, 
	_TtC = Wherigo.ZCommand{
		Text = _37kNH("\055\087\069\046\119\079\068"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _37kNH("\036\034\009\076\119\079\007\093\069\112\069\119\111\069\020\111\068")
	}, 
	_LBRM = Wherigo.ZCommand{
		Text = _37kNH("\025\119\079\009"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _37kNH("\036\034\009\076\119\079\007\093\069\112\069\119\111\069\020\111\068")
	}, 
	_L7Vt6 = Wherigo.ZCommand{
		Text = _37kNH("\120\047\034\119\111\068\116"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _37kNH("\036\034\009\076\119\079\007\093\069\112\069\119\111\069\020\111\068")
	}
}
_edW.Commands._5eQCy.Custom = true
_edW.Commands._5eQCy.Id = "f3497b1c-85d1-4e60-b19a-703cef572bc3"
_edW.Commands._5eQCy.WorksWithAll = true
_edW.Commands._TtC.Custom = true
_edW.Commands._TtC.Id = "3d50e777-978c-4575-9fad-ebf6aa739834"
_edW.Commands._TtC.WorksWithAll = true
_edW.Commands._LBRM.Custom = true
_edW.Commands._LBRM.Id = "9ad8225f-201e-4f80-9a73-38d2dbd3865a"
_edW.Commands._LBRM.WorksWithAll = true
_edW.Commands._L7Vt6.Custom = true
_edW.Commands._L7Vt6.Id = "2c0dec29-9f74-4f37-8cc7-74f8bbc0d80a"
_edW.Commands._L7Vt6.WorksWithAll = true
_edW.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_edW.Locked = false
_edW.Opened = false
_SmX2 = Wherigo.ZItem(cartRenameMe7)
_SmX2.Id = "67522ccb-a3ea-4e66-b873-3e46db8f4c83"
_SmX2.Name = _37kNH("\045\034\046\047\111\068\009\119\034\079\093\045\034\113\068")
_SmX2.Description = _37kNH("\028\119\116\009\068\093\113\034\011\079\093\009\076\068\093\079\103\046\020\068\116\093\054\034\116\093\103\043\068\093\034\079\093\011\076\068\116\119\007\034\093\011\068\020\093\043\119\009\068\115\093\122\034\103\093\011\119\111\111\093\103\043\068\093\009\076\068\093\089\034\113\068\093\009\034\093\103\079\111\034\089\033\093\009\076\068\093\089\069\116\009\116\119\113\007\068\093\011\076\119\089\076\093\046\068\069\079\043\093\009\076\069\009\093\037\034\103\093\011\119\111\111\093\043\076\034\011\093\009\076\069\009\093\037\034\103\093\089\034\046\047\111\068\009\068\113\093\119\009\080\093\122\034\103\093\011\119\111\111\093\069\111\043\034\093\043\103\020\046\119\009\093\069\093\111\034\007\093\009\076\068\116\068\093\069\054\009\068\116\093\037\034\103\093\103\079\111\034\089\033\093\119\009\080")
_SmX2.Visible = false
_SmX2.Commands = {
	_7XW = Wherigo.ZCommand{
		Text = _37kNH("\120\076\034\011\093\045\034\113\068"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _37kNH("\036\034\009\076\119\079\007\093\069\112\069\119\111\069\020\111\068")
	}, 
	_hslE = Wherigo.ZCommand{
		Text = _37kNH("\084\043\068\116\079\069\046\068"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _37kNH("\036\034\009\076\119\079\007\093\069\112\069\119\111\069\020\111\068")
	}
}
_SmX2.Commands._7XW.Custom = true
_SmX2.Commands._7XW.Id = "1d4a658c-09dd-4bbd-b3e8-0bdc756c751c"
_SmX2.Commands._7XW.WorksWithAll = true
_SmX2.Commands._hslE.Custom = true
_SmX2.Commands._hslE.Id = "145a6023-7415-4a52-918a-287ad87fcd6f"
_SmX2.Commands._hslE.WorksWithAll = true
_SmX2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_SmX2.Locked = false
_SmX2.Opened = false
_fhJlI = Wherigo.ZItem(cartRenameMe7)
_fhJlI.Id = "4d851b6a-bf66-4355-8d03-c9190538678f"
_fhJlI.Name = _37kNH("\109\069\043\043\093\020\037")
_fhJlI.Description = ""
_fhJlI.Visible = false
_fhJlI.Commands = {}
_fhJlI.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_fhJlI.Locked = false
_fhJlI.Opened = false
_4GSe = Wherigo.ZItem(cartRenameMe7)
_4GSe.Id = "57a2e172-5648-486d-9172-9a0d8ee41e0e"
_4GSe.Name = _37kNH("\078\111\069\089\033\093\083\108\083\093\051\119\079\007")
_4GSe.Description = _37kNH("\045\034\046\046\034\079\111\037\093\103\043\068\113\093\009\034\093\033\068\068\047\093\011\069\009\068\116\093\034\103\009\093\034\054\118\078\051\107\043\046\069\111\111\093\020\119\043\034\079\093\009\103\020\068\043\080\118\078\051\107")
_4GSe.Visible = true
_4GSe.Media = _1P0
_4GSe.Commands = {}
_4GSe.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_4GSe.Locked = false
_4GSe.Opened = false
_xDq = Wherigo.ZItem(cartRenameMe7)
_xDq.Id = "4c550391-1715-4e2d-a7c8-ed71fbd99552"
_xDq.Name = _37kNH("\051\034\111\111\068\113\093\070\034\007")
_xDq.Description = _37kNH("\077\093\079\068\011\093\116\034\111\111\068\113\093\103\047\093\111\034\007\093\072\103\043\009\093\009\076\068\093\116\119\007\076\009\093\043\119\040\068\093\054\034\116\093\069\093\020\119\113\043\034\079\093\009\103\020\068\080")
_xDq.Visible = true
_xDq.Media = _wZM
_xDq.Commands = {}
_xDq.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_xDq.Locked = false
_xDq.Opened = false
_guU = Wherigo.ZItem(cartRenameMe7)
_guU.Id = "3009a4db-6f4b-4fdc-9482-b77c10ea9902"
_guU.Name = _37kNH("\078\068\079\009\093\011\116\068\069\009\076\093\076\034\111\113\068\116")
_guU.Description = ""
_guU.Visible = false
_guU.Commands = {}
_guU.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_guU.Locked = false
_guU.Opened = false

-- Tasks --
_wm35M = Wherigo.ZTask(cartRenameMe7)
_wm35M.Id = "0e4b020c-f677-40b8-872c-3d770c47846f"
_wm35M.Name = _37kNH("\051\068\047\069\111\089\068\093\009\076\068\093\111\034\007\115")
_wm35M.Description = ""
_wm35M.Visible = false
_wm35M.Active = false
_wm35M.Complete = false
_wm35M.CorrectState = "None"
_o7H = Wherigo.ZTask(cartRenameMe7)
_o7H.Id = "d9d66772-aeb4-4ef6-a531-1144fecd46da"
_o7H.Name = _37kNH("\109\103\009\093\009\076\068\093\089\069\089\076\068\093\089\034\079\009\069\119\079\068\116\093\020\069\089\033\093\011\076\068\116\068\093\119\009\093\020\068\111\034\079\007\043\115")
_o7H.Description = ""
_o7H.Visible = true
_o7H.Active = false
_o7H.Complete = false
_o7H.CorrectState = "None"
_Csq = Wherigo.ZTask(cartRenameMe7)
_Csq.Id = "f54329f5-c6c3-48a2-a02f-23a7772d1352"
_Csq.Name = _37kNH("\051\068\047\111\069\089\068\093\009\076\068\093\116\103\020\020\068\116\093\116\119\079\007")
_Csq.Description = ""
_Csq.Visible = true
_Csq.Active = false
_Csq.Complete = false
_Csq.CorrectState = "None"
_YRE = Wherigo.ZTask(cartRenameMe7)
_YRE.Id = "34d851ed-fe2f-4bad-8610-79f94f9e3eba"
_YRE.Name = _37kNH("\070\034\007\093\037\034\103\093\112\119\043\119\009")
_YRE.Description = ""
_YRE.Visible = true
_YRE.Active = false
_YRE.Complete = false
_YRE.CorrectState = "None"

-- Cartridge Variables --
Answer = ""
_JWGJ = ""
_FSK = ""
cartRenameMe7.ZVariables = {
	Answer = "", 
	_JWGJ = "", 
	_FSK = ""
}

-- Timers --
_C0gnd = Wherigo.ZTimer(cartRenameMe7)
_C0gnd.Id = "79415256-1d10-4dd8-9bf9-2a50013418cf"
_C0gnd.Name = _37kNH("\036\069\046\068")
_C0gnd.Description = ""
_C0gnd.Visible = true
_C0gnd.Duration = 60.9990172572429
_C0gnd.Type = "Countdown"
_CHOuX = Wherigo.ZTimer(cartRenameMe7)
_CHOuX.Id = "161564d6-d5e0-4a8c-be35-bc8486a5caf8"
_CHOuX.Name = _37kNH("\120\009\069\007\068\093\066\093\001\119\046\068\116")
_CHOuX.Description = _37kNH("\077\093\009\011\034\093\046\119\079\103\009\068\093\047\116\068\043\043\103\116\068\093\009\068\043\009\068\116")
_CHOuX.Visible = true
_CHOuX.Duration = 120
_CHOuX.Type = "Countdown"
_uiLn = Wherigo.ZTimer(cartRenameMe7)
_uiLn.Id = "d67ef4b5-809d-43af-a3b2-178bbf1b514b"
_uiLn.Name = _37kNH("\120\009\069\007\068\093\094\093\009\119\046\068\093\034\103\009")
_uiLn.Description = _37kNH("\077\093\034\079\068\093\046\119\079\103\009\068\093\047\068\079\069\111\009\037")
_uiLn.Visible = true
_uiLn.Duration = 60
_uiLn.Type = "Countdown"

-- Inputs --
zinputquestion1 = Wherigo.ZInput(cartRenameMe7)
zinputquestion1.Id = "60fd0f52-7796-4bb6-b5e6-e30ae12e2633"
zinputquestion1.Name = _37kNH("\031\103\068\043\009\119\034\079\093\030")
zinputquestion1.Description = _37kNH("\001\076\119\043\093\119\043\093\037\034\103\116\093\054\119\116\043\009\093\031\103\068\043\009\119\034\079\093\054\034\116\093\121\034\079\068\093\030\118\078\051\107")
zinputquestion1.Visible = true
zinputquestion1.Media = zmediaquestion
zinputquestion1.Choices = {
	"January", 
	"February", 
	"March", 
	"April"
}
zinputquestion1.InputType = "MultipleChoice"
zinputquestion1.Text = _37kNH("\045\076\116\119\043\009\046\069\043\093\011\116\068\069\009\076\043\093\046\069\037\093\079\034\009\093\020\068\093\103\043\068\113\093\069\054\009\068\116\093\009\076\068\093\054\119\116\043\009\093\113\069\037\093\034\054\093\011\076\069\009\093\046\034\079\009\076\015\118\078\051\107")
zinputquestion2 = Wherigo.ZInput(cartRenameMe7)
zinputquestion2.Id = "3273a657-230f-4dd9-b91d-b615904b7540"
zinputquestion2.Name = _37kNH("\031\103\068\043\009\119\034\079\093\016")
zinputquestion2.Description = _37kNH("\055\113\011\119\079\093\070\093\053\119\111\089\076\079\068\116\093\120\009\034\079\068")
zinputquestion2.Visible = true
zinputquestion2.Media = zmediaquestion
zinputquestion2.Choices = {
	"Praying", 
	"Fishing", 
	"Kissing", 
	"Hunting"
}
zinputquestion2.InputType = "MultipleChoice"
zinputquestion2.Text = _37kNH("\108\079\093\055\113\011\119\079\093\070\093\053\119\111\089\076\079\068\116\093\007\116\069\112\068\043\009\034\079\068\093\011\076\069\009\093\069\116\068\093\009\076\068\093\009\011\034\093\047\068\034\047\111\068\093\113\034\119\079\007\015")
zinputquestion3 = Wherigo.ZInput(cartRenameMe7)
zinputquestion3.Id = "6d0b0e40-8631-45e6-bd34-b488f9ea8acf"
zinputquestion3.Name = _37kNH("\031\103\068\043\009\119\034\079\093\090")
zinputquestion3.Description = ""
zinputquestion3.Visible = true
zinputquestion3.Media = zmediaquestion
zinputquestion3.Choices = {
	"Prayer Hands", 
	"Heart", 
	"Angel", 
	"Pony"
}
zinputquestion3.InputType = "MultipleChoice"
zinputquestion3.Text = _37kNH("\028\076\069\009\093\043\119\009\043\093\034\079\093\009\034\047\093\034\054\093\014\119\046\020\068\116\111\037\093\077\079\079\004\043\093\043\009\034\079\068\015\093")
zinputquestion4 = Wherigo.ZInput(cartRenameMe7)
zinputquestion4.Id = "f4cfab4d-fb72-43d6-88d8-d2896d37c83c"
zinputquestion4.Name = _37kNH("\031\103\068\043\009\119\034\079\093\066")
zinputquestion4.Description = _37kNH("\001\076\119\043\093\119\043\093\069\093\074\001\068\087\009\092\093\031\103\068\043\009\119\034\079\093\043\076\034\011\119\079\007\093\037\034\103\093\009\076\069\009\093\037\034\103\093\043\076\034\103\111\113\093\046\069\033\068\093\001\068\087\009\093\031\103\068\043\009\119\034\079\093\069\079\043\011\068\116\043\093\043\076\034\116\009\093\069\079\113\093\068\069\043\037\093\009\034\093\119\079\047\103\009\080\093\001\076\068\093\069\079\043\011\068\116\093\119\043\093\074\028\076\068\116\119\007\034\093\049\069\046\068\092\093\069\079\113\093\009\076\119\043\093\089\034\103\111\113\093\020\068\093\089\034\079\054\103\043\119\079\007\093\034\116\093\072\103\043\009\093\009\034\093\111\034\079\007\080")
zinputquestion4.Visible = true
zinputquestion4.Media = zmediaquestion
zinputquestion4.Choices = {
	"8 and 17", 
	"17 and 34", 
	"33 and 38", 
	"9 and 81"
}
zinputquestion4.InputType = "MultipleChoice"
zinputquestion4.Text = _37kNH("\001\076\119\043\093\043\009\069\007\068\093\119\043\093\069\093\047\116\068\043\043\103\116\068\093\089\034\034\033\068\116\067\093\119\054\093\037\034\103\093\007\068\009\093\009\076\119\043\093\069\079\043\011\068\116\093\119\079\093\103\079\113\068\116\093\016\093\046\119\079\103\009\068\043\093\119\009\093\011\119\111\111\093\020\068\093\037\034\103\116\093\034\079\111\037\093\031\103\068\043\009\119\034\079\093\076\068\116\068\067\093\119\054\093\079\034\009\093\119\009\093\119\043\093\047\068\079\069\111\009\037\093\009\119\046\068\115\093\049\034\068\116\007\068\093\053\093\028\069\046\020\034\111\113\093\076\069\043\093\009\011\034\093\089\069\116\043\093\034\079\093\076\119\043\093\043\009\034\079\068\067\093\011\076\069\009\093\069\116\068\093\009\076\068\119\116\093\079\103\046\020\068\116\043\015")
zinputquestion5 = Wherigo.ZInput(cartRenameMe7)
zinputquestion5.Id = "c12a472b-d6b2-4888-9cca-0e714971fa9a"
zinputquestion5.Name = _37kNH("\031\103\068\043\009\119\034\079\093\023")
zinputquestion5.Description = _37kNH("\001\076\119\043\093\119\043\093\020\069\089\033\093\009\034\093\069\093\036\119\089\068\093\031\103\068\043\009\119\034\079\093\074\001\068\087\009\092\093\119\079\047\103\009\080")
zinputquestion5.Visible = true
zinputquestion5.Media = zmediaquestion
zinputquestion5.InputType = "Text"
zinputquestion5.Text = _37kNH("\028\076\069\009\093\116\069\079\033\093\011\069\043\093\045\069\116\111\093\070\093\126\034\116\116\119\043\093\119\079\093\028\028\114\114\015")
zinputquestion6 = Wherigo.ZInput(cartRenameMe7)
zinputquestion6.Id = "00dd5dd8-a805-4383-bb34-f1f2c0f18678"
zinputquestion6.Name = _37kNH("\031\103\068\043\009\119\034\079\093\056")
zinputquestion6.Description = _37kNH("\001\076\068\093\031\103\068\043\009\119\034\079\093\068\087\069\046\047\111\068\093\127\079\020\043\047\082\119\043\093\069\093\074\009\068\087\009\092\093\119\079\047\103\009\093\031\103\068\043\009\119\034\079\080")
zinputquestion6.Visible = true
zinputquestion6.Media = zmediaquestion
zinputquestion6.Choices = {
	"Nicole Berkov", 
	"Andrea Ritter", 
	"Laura Nickum", 
	"Mary White"
}
zinputquestion6.InputType = "MultipleChoice"
zinputquestion6.Text = _37kNH("\028\076\034\093\119\043\093\079\068\087\009\093\009\034\093\070\119\009\009\111\068\093\028\119\111\111\119\068\015")
zinputquestion7 = Wherigo.ZInput(cartRenameMe7)
zinputquestion7.Id = "e4f3cdd1-9569-483f-b2ad-7416da9c7c4f"
zinputquestion7.Name = _37kNH("\031\103\068\043\009\119\034\079\093\094")
zinputquestion7.Description = _37kNH("\001\068\043\009\093\031\103\068\043\009\119\034\079\118\078\051\107")
zinputquestion7.Visible = true
zinputquestion7.Media = zmediaquestion
zinputquestion7.InputType = "Text"
zinputquestion7.Text = _37kNH("\028\076\069\009\093\083\011\034\116\113\083\093\119\043\093\009\076\068\093\069\079\119\046\069\111\093\076\034\111\113\119\079\007\093\034\079\093\126\119\089\076\068\069\111\093\077\079\009\076\034\079\037\093\070\034\046\020\069\116\113\004\093\043\009\034\079\068\015\118\078\051\107")
_92t = Wherigo.ZInput(cartRenameMe7)
_92t.Id = "8c8fb736-f2d2-4df1-b57f-3825a4c299f5"
_92t.Name = _37kNH("\109\068\079\069\111\009\037\093\127\079\020\043\047\082\030\093")
_92t.Description = _37kNH("\109\068\079\069\111\009\037\093\054\034\116\093\046\119\043\043\119\079\007\093\040\034\079\068\093\016\093\031\103\068\043\009\119\034\079\093\069\043\033\068\113\093\069\009\093\040\034\079\068\093\030\080")
_92t.Visible = true
_92t.Media = zmediaquestion
_92t.InputType = "Text"
_92t.Text = _37kNH("\120\111\068\113\113\119\079\007\093\119\043\093\069\111\111\034\011\068\113\093\119\079\093\009\076\068\093\089\068\046\068\009\068\116\037\093\001\116\103\068\093\034\116\093\053\069\111\043\068\015")
_wEqX = Wherigo.ZInput(cartRenameMe7)
_wEqX.Id = "bab03b4d-43de-435b-bd1f-65e32c883e9c"
_wEqX.Name = _37kNH("\031\103\068\043\009\119\034\079\093\030\069")
_wEqX.Description = ""
_wEqX.Visible = true
_wEqX.Media = zmediaquestion
_wEqX.InputType = "Text"
_wEqX.Text = _37kNH("\028\076\069\009\093\037\068\069\116\093\011\069\043\093\009\076\068\093\020\103\119\111\113\119\079\007\093\076\068\116\068\093\068\116\068\089\009\068\113\015")
_kPK = Wherigo.ZInput(cartRenameMe7)
_kPK.Id = "6ff5f1a7-b61d-4e09-8eb5-2e59307fdd5d"
_kPK.Name = _37kNH("\116\068\047\068\069\009\093\031\103\068\043\009\119\034\079\093\016")
_kPK.Description = _37kNH("\121\034\079\068\093\016\093\012\103\068\043\009\119\034\079\093\054\034\116\093\069\054\009\068\116\093\047\068\079\069\111\009\037")
_kPK.Visible = true
_kPK.Media = zmediaquestion
_kPK.Choices = {
	"Praying", 
	"Fishing", 
	"Kissing", 
	"Hunting"
}
_kPK.InputType = "MultipleChoice"
_kPK.Text = _37kNH("\108\079\093\055\113\011\119\079\093\070\093\053\119\111\089\076\079\068\116\093\007\116\069\112\068\043\009\034\079\068\093\011\076\069\009\093\069\116\068\093\009\076\068\093\009\011\034\093\047\068\034\047\111\068\093\113\034\119\079\007\015")
_VV9v = Wherigo.ZInput(cartRenameMe7)
_VV9v.Id = "1ecd5027-8708-44f2-9856-06c5a4e272f6"
_VV9v.Name = _37kNH("\012\103\068\043\009\119\034\079\093\099")
_VV9v.Description = _37kNH("\053\119\079\069\111\093\012\103\068\043\009\119\034\079")
_VV9v.Visible = true
_VV9v.Media = zmediaquestion
_VV9v.Choices = {
	"Andrew T Ritter", 
	"Griffith J Scholl", 
	"Jacob Von Straus", 
	"Peter Winegold"
}
_VV9v.InputType = "MultipleChoice"
_VV9v.Text = _37kNH("\108\033\069\037\115\093\122\034\103\093\076\069\112\068\093\046\069\113\068\093\119\009\093\009\034\093\009\076\068\093\053\119\079\069\111\093\031\103\068\043\009\119\034\079\115\093\028\076\069\009\093\011\069\043\093\009\076\068\093\102\034\089\009\034\116\004\043\093\036\069\046\068\015")
_bxlbN = Wherigo.ZInput(cartRenameMe7)
_bxlbN.Id = "a170208c-b6dc-4bc3-a9dc-9fff1c38f9fc"
_bxlbN.Name = _37kNH("\031\103\068\043\009\119\034\079\093\016\069")
_bxlbN.Description = ""
_bxlbN.Visible = true
_bxlbN.Media = zmediaquestion
_bxlbN.InputType = "Text"
_bxlbN.Text = _37kNH("\028\076\069\009\093\011\069\043\093\036\069\079\089\037\093\070\093\078\103\009\040\093\079\119\089\033\079\069\046\068\015")
_z4SPT = Wherigo.ZInput(cartRenameMe7)
_z4SPT.Id = "98343792-e028-4f20-a486-60257cf3b465"
_z4SPT.Name = _37kNH("\031\103\068\043\009\119\034\079\093\090\069")
_z4SPT.Description = ""
_z4SPT.Visible = true
_z4SPT.Choices = {
	"Yes", 
	"No"
}
_z4SPT.InputType = "MultipleChoice"
_z4SPT.Text = _37kNH("\028\068\093\079\068\068\113\093\009\034\093\047\034\043\009\093\069\093\111\034\007\093\009\034\093\126\069\113\076\069\103\111\068\116\093\043\034\093\076\068\093\113\034\068\043\093\079\034\009\093\116\103\079\093\034\103\009\093\076\068\116\068\093\069\079\113\093\089\076\068\089\033\093\034\079\093\009\076\119\043\093\089\069\089\076\068\093\011\076\068\079\093\076\068\093\007\068\009\043\093\076\034\046\068\080\093\102\119\113\093\037\034\103\093\047\034\043\009\093\037\034\103\116\093\046\069\119\079\009\068\079\069\079\089\068\093\111\034\007\093\054\034\116\093\126\069\113\076\069\103\111\068\116\004\043\093\089\069\089\076\068\093\037\068\009\015")
_emDpz = Wherigo.ZInput(cartRenameMe7)
_emDpz.Id = "048423a1-03b4-47ea-ab8a-d5c612de8f41"
_emDpz.Name = _37kNH("\031\103\068\043\009\119\034\079\093\066\069")
_emDpz.Description = ""
_emDpz.Visible = true
_emDpz.Media = zmediaquestion
_emDpz.Choices = {
	"Rover", 
	"Snoopy", 
	"Lady", 
	"Daisy"
}
_emDpz.InputType = "MultipleChoice"
_emDpz.Text = _37kNH("\028\076\069\009\093\119\043\093\009\076\068\093\079\069\046\068\093\034\054\093\009\076\068\093\009\034\047\093\113\034\007\093\034\079\093\009\076\068\093\020\069\089\033\093\034\054\093\009\076\068\093\051\034\043\068\020\068\116\116\037\004\043\093\043\009\034\079\068\015")
_CdnRp = Wherigo.ZInput(cartRenameMe7)
_CdnRp.Id = "705b6ee8-3e3c-49b7-b644-1d061cf96633"
_CdnRp.Name = _37kNH("\031\103\068\043\009\119\034\079\093\066\020")
_CdnRp.Description = ""
_CdnRp.Visible = true
_CdnRp.Media = zmediaquestion
_CdnRp.Choices = {
	"1", 
	"2", 
	"3"
}
_CdnRp.InputType = "MultipleChoice"
_CdnRp.Text = _37kNH("\025\034\011\093\046\069\079\037\093\113\068\068\116\093\034\079\093\009\076\068\093\053\069\103\043\009\093\013\034\076\079\043\034\079\093\120\009\034\079\068\015")
_KHY8_ = Wherigo.ZInput(cartRenameMe7)
_KHY8_.Id = "bb424cfe-f24a-4e70-83bf-525beb60fa7a"
_KHY8_.Name = _37kNH("\031\103\068\043\009\119\034\079\093\094\069")
_KHY8_.Description = ""
_KHY8_.Visible = true
_KHY8_.Media = zmediaquestion
_KHY8_.Choices = {
	"Angel", 
	"Lamb", 
	"Puppy", 
	"Kitten"
}
_KHY8_.InputType = "MultipleChoice"
_KHY8_.Text = _37kNH("\028\076\069\009\093\119\043\093\034\079\093\009\034\047\093\034\054\093\049\111\034\116\119\069\093\126\093\036\068\054\068\068\113\068\116\004\043\093\043\009\034\079\068\015")
_bL0v = Wherigo.ZInput(cartRenameMe7)
_bL0v.Id = "b6038298-aef8-4037-86ca-1cc568ba6b3b"
_bL0v.Name = _37kNH("\031\103\068\043\009\119\034\079\093\094\020")
_bL0v.Description = ""
_bL0v.Visible = true
_bL0v.Media = zmediaquestion
_bL0v.InputType = "Text"
_bL0v.Text = _37kNH("\013\103\079\007\093\112\054\093\007\103\116\093\043\112\068\054\007\093\072\020\068\031\093\112\069\093\007\103\116\093\069\079\040\116\093\020\043\093\007\103\112\054\093\047\116\040\116\007\116\068\111\015")
_1c7o = Wherigo.ZInput(cartRenameMe7)
_1c7o.Id = "fbe79383-e0ee-4de0-8bbd-da152be03acd"
_1c7o.Name = _37kNH("\031\103\068\043\009\119\034\079\093\056\069")
_1c7o.Description = ""
_1c7o.Visible = true
_1c7o.Media = zmediaquestion
_1c7o.InputType = "Text"
_1c7o.Text = _37kNH("\109\069\043\043\089\034\113\068\100\013\034\076\079\093\051\119\009\009\068\116\004\043\093\069\007\068\093\119\079\093\011\068\068\033\043\067\093\055\112\068\079\093\079\103\046\020\068\116\043\093\034\079\093\119\079\054\069\079\009\093\043\034\079\093\034\054\093\051\119\089\076\069\116\113\093\120\089\076\069\054\068\116\067\093\013\034\043\068\047\076\093\102\068\089\076\093\037\068\069\116\043\093\113\119\112\119\113\068\113\093\020\037\093\046\034\079\009\076\043\067\093\079\103\046\020\068\116\093\034\054\093\111\068\009\009\068\116\043\093\119\079\093\013\034\076\079\093\053\034\087\004\043\093\011\119\054\068\043\093\054\119\116\043\009\093\079\069\046\068\118\078\051\107\055\079\009\068\116\093\109\069\043\043\089\034\113\068\063")

-- WorksWithList for object commands --

-- functions --
function cartRenameMe7:OnStart()
	if (_G[_37kNH("\055\079\112")][_37kNH("\102\068\112\119\089\068\114\102")] == _37kNH("\102\068\043\033\009\034\047")) or (_G[_37kNH("\055\079\112")][_37kNH("\109\111\069\009\054\034\116\046")] == _37kNH("\028\119\079\090\016")) then
		for k, v in pairs(_G[_37kNH("\089\069\116\009\051\068\079\069\046\068\126\068\094")][_37kNH("\077\111\111\121\108\020\072\068\089\009\043")]) do
			v[_37kNH("\086\119\043\119\020\111\068")] = false
			v[_37kNH("\077\089\009\119\112\068")] = false
		end
		_G[_37kNH("\028\076\068\116\119\007\034")][_37kNH("\045\034\046\046\069\079\113")](_37kNH("\120\069\112\068\045\111\034\043\068"))
		return
	end
	_C0gnd[_37kNH("\120\009\069\116\009")](_C0gnd)
	_Urwigo.MessageBox{
		Text = _37kNH("\028\068\111\089\034\046\068\093\009\034\093\083\025\034\047\068\093\045\068\046\068\009\068\116\037\093\025\068\089\033\009\034\011\079\083\093\001\076\119\043\093\089\068\046\068\009\068\116\037\093\119\043\093\069\093\046\119\087\093\034\054\093\034\111\113\068\116\093\007\116\069\112\068\043\009\034\079\068\093\043\068\089\009\119\034\079\043\093\069\079\113\093\079\068\011\068\116\093\043\009\119\111\111\093\069\089\009\119\112\068\093\069\116\068\069\043\080\093\114\009\093\069\047\047\068\069\116\043\093\009\076\068\116\068\093\119\043\093\047\111\068\079\009\037\093\034\054\093\111\069\079\113\093\119\079\093\009\076\068\093\020\069\089\033\093\054\034\116\093\009\076\119\043\093\089\068\046\068\009\068\116\037\093\009\034\093\089\034\079\009\119\079\103\068\093\009\034\093\007\116\034\011\093\054\034\116\093\046\069\079\037\093\037\068\069\116\043\093\009\034\093\089\034\046\068\080\093"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _37kNH("\114\054\093\009\076\068\116\068\093\119\043\093\069\093\043\068\116\112\119\089\068\093\007\034\119\079\007\093\034\079\093\011\076\068\079\093\037\034\103\093\007\068\009\093\076\068\116\068\093\047\111\068\069\043\068\093\111\068\069\112\068\093\069\079\113\093\089\034\046\068\093\020\069\089\033\093\069\079\034\009\076\068\116\093\009\119\046\068\080\093\114\054\093\043\034\046\068\034\079\068\093\119\043\093\009\076\068\116\068\093\112\119\043\119\009\119\079\007\093\009\076\068\119\116\093\111\034\112\068\113\093\034\079\068\043\093\047\111\068\069\043\068\093\020\068\093\116\068\043\047\068\089\009\054\103\111\093\020\037\093\068\119\009\076\068\116\093\011\069\119\009\119\079\007\093\054\034\116\093\009\076\068\046\093\009\034\093\089\034\079\089\111\103\113\068\093\009\076\068\119\116\093\112\119\043\119\009\093\034\116\093\089\034\046\119\079\007\093\020\069\089\033\093\069\009\093\069\093\111\069\009\068\116\093\009\119\046\068\093\009\034\093\047\111\069\037\093\009\076\119\043\093\007\069\046\068\080\093"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _37kNH("\114\054\093\068\112\068\116\037\009\076\119\079\007\093\119\043\093\031\103\119\068\009\093\069\079\113\093\047\068\069\089\068\054\103\111\093\047\111\068\069\043\068\093\068\079\072\034\037\093\037\034\103\116\093\069\113\112\068\079\009\103\116\068\093\009\034\113\069\037\115\093\122\034\103\116\093\054\119\116\043\009\093\043\009\034\047\093\011\119\111\111\093\020\068\093\069\009\093\009\076\068\093\089\068\079\009\068\116\093\089\119\116\089\111\068\093\034\054\093\009\076\068\093\034\111\113\068\116\093\043\068\089\009\119\034\079\093\034\054\093\009\076\068\093\089\068\046\068\009\068\116\037\115")
							}
						end
					end
				}
				_4GSe:MoveTo(Player)
				_xDq:MoveTo(Player)
				zonestage1.Active = true
				zonestage1.Visible = true
			end
		end
	}
end
function cartRenameMe7:OnRestore()
	_C0gnd[_37kNH("\120\009\069\116\009")](_C0gnd)
end
function zonestage1:OnEnter()
	if not Player:Contains(_fhJlI) then
		if Player:Contains(_KJi_) then
			_Urwigo.MessageBox{
				Text = _37kNH("\114\093\069\046\093\043\034\116\116\037\093\009\034\093\043\068\068\093\009\076\069\009\093\037\034\103\093\076\069\112\068\093\020\068\068\079\093\054\034\116\089\068\113\093\009\034\093\043\068\116\112\068\093\069\093\047\068\079\069\111\009\037\115\093\109\111\068\069\043\068\093\020\068\093\089\069\116\068\054\103\111\093\068\079\009\068\116\119\079\007\093\037\034\103\116\093\069\079\043\011\068\116\043\093\069\079\113\093\113\034\093\079\034\009\093\007\103\068\043\043\093\069\009\093\009\076\119\079\007\043\080\093"), 
				Callback = function(action)
					if action ~= nil then
						_Urwigo.MessageBox{
							Text = _37kNH("\093\001\069\033\068\093\037\034\103\116\093\009\119\046\068\093\069\079\113\093\111\034\034\033\093\054\034\116\093\009\076\068\093\119\079\054\034\116\046\069\009\119\034\079\093\037\034\103\093\079\068\068\113\080\093\108\033\093\076\068\116\068\093\119\043\093\037\034\103\116\093\047\068\079\069\111\009\037\093\031\103\068\043\009\119\034\079\093\011\076\119\089\076\093\089\069\079\093\007\068\009\093\037\034\103\093\020\069\089\033\093\034\079\093\037\034\103\116\093\011\069\037\115"), 
							Callback = function(action)
								if action ~= nil then
									_Urwigo.RunDialogs(function()
										Wherigo.GetInput(_92t)
									end)
								end
							end
						}
					end
				end
			}
		else
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(zinputquestion1)
			end)
		end
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\120\068\068\093\009\076\069\009\093\011\069\043\093\079\034\009\093\076\069\116\113\093\009\034\093\113\034\093\069\009\093\069\111\111\080\093\114\054\093\037\034\103\093\076\069\113\093\043\034\046\068\034\079\068\093\076\068\111\047\093\037\034\103\093\047\111\068\069\043\068\093\116\068\046\068\046\020\068\116\093\009\034\093\009\076\069\079\033\093\009\076\068\046\115"), 
			Media = zmediago, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\036\034\011\093\007\068\009\093\007\034\119\079\007\093\009\034\093\009\076\068\093\120\119\087\009\076\093\043\009\069\007\068\115"), 
						Media = zmediago
					}
					zonestage6.Active = true
					zonestage6.Visible = true
					zonestage5.Active = false
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function zonestage2:OnEnter()
	if Player:Contains(_l0r) then
		_8x0t8.Visible = true
		_8x0t8.Commands._7uab.Enabled = true
	elseif Player:Contains(_iIY7) then
		_Urwigo.MessageBox{
			Text = _37kNH("\114\093\069\046\093\043\034\093\076\069\047\047\037\093\009\076\069\009\093\037\034\103\093\043\103\089\089\068\043\043\054\103\111\111\037\093\069\079\043\011\068\116\068\113\093\009\076\068\093\047\068\079\069\111\009\037\093\031\103\068\043\009\119\034\079\093\069\079\113\093\046\069\113\068\093\119\009\093\020\069\089\033\093\076\068\116\068\080\093\109\111\068\069\043\068\093\020\068\093\089\069\116\068\054\103\111\093\011\119\009\076\093\037\034\103\116\093\069\079\043\011\068\116\093\009\076\119\043\093\009\119\046\068\093\069\043\093\114\093\116\068\069\111\111\037\093\113\034\093\079\034\009\093\111\119\033\068\093\047\103\079\119\043\076\119\079\007\093\037\034\103\115"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\049\034\034\113\093\079\068\011\043\093\119\043\093\034\079\089\068\093\037\034\103\093\007\068\009\093\069\093\047\068\079\069\111\009\037\067\093\034\079\089\068\093\034\079\093\069\093\043\009\069\007\068\067\093\114\093\011\034\079\004\009\093\046\069\033\068\093\037\034\103\093\007\034\093\020\069\089\033\093\069\007\069\119\079\093\119\054\093\037\034\103\093\007\068\009\093\009\076\069\009\093\069\079\043\011\068\116\093\011\116\034\079\007\093\119\079\093\009\076\119\043\093\043\009\069\007\068\115\093\063\003\092"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_kPK)
								end)
							end
						end
					}
				end
			end
		}
	else
		_kYaKR:MoveTo(Player)
		_Urwigo.MessageBox{
			Text = _37kNH("\028\068\111\089\034\046\068\093\009\034\093\009\076\068\093\043\068\089\034\079\113\093\043\009\069\007\068\093\034\054\093\009\076\119\043\093\007\069\046\068\080\093\127\079\020\043\047\082\114\009\093\119\043\093\089\111\068\069\116\093\037\034\103\093\103\079\113\068\116\043\009\069\079\113\093\076\034\011\093\009\034\093\047\111\069\037\067\093\043\034\093\069\009\093\009\076\119\043\093\047\034\119\079\009\093\069\079\037\093\011\116\034\079\007\093\069\079\043\011\068\116\093\011\119\111\111\093\054\034\116\089\068\093\037\034\103\093\009\034\093\043\068\116\112\068\093\069\093\047\068\079\069\111\009\037\080\093\078\103\009\093\111\068\009\004\043\093\079\034\009\093\011\034\116\116\037\093\069\020\034\103\009\093\009\076\069\009\093\069\043\093\079\034\079\068\093\034\054\093\046\037\093\031\103\068\043\009\119\034\079\043\093\069\116\068\093\009\076\069\009\093\076\069\116\113\080"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputquestion2)
					end)
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function zonestage3:OnEnter()
	if not Player:Contains(_8x0t8) then
		_Urwigo.MessageBox{
			Text = _37kNH("\114\093\069\046\093\116\068\069\111\111\037\093\113\119\043\069\047\047\034\119\079\009\068\113\093\009\076\069\009\093\037\034\103\093\113\119\113\093\079\034\009\093\047\119\089\033\093\103\047\093\009\076\068\093\089\069\089\076\068\093\089\034\079\009\069\119\079\068\116\080\093"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\114\079\093\009\076\068\093\089\069\089\076\119\079\007\093\011\034\116\111\113\093\011\068\093\069\116\068\093\068\087\047\068\089\009\068\113\093\009\034\093\076\068\111\047\093\011\119\009\076\093\046\119\079\034\116\093\119\043\043\103\068\043\093\011\119\009\076\093\009\076\068\093\089\069\089\076\068\043\093\011\068\093\054\119\079\113\080"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _37kNH("\093\114\093\069\046\093\043\034\116\116\037\093\020\103\009\093\114\093\046\103\043\009\093\119\079\043\119\043\009\093\009\076\069\009\093\037\034\103\093\007\034\093\020\069\089\033\093\069\079\113\093\047\119\089\033\093\119\009\093\103\047\093\079\034\011\080")
								}
							end
						end
					}
				end
			end
		}
		_l0r:MoveTo(Player)
		zonestage2.Active = true
		zonestage2.Visible = true
		zonestage3.Active = false
		zonestage3.Visible = false
	else
		zonestage2.Active = false
		zonestage2.Visible = false
		_Urwigo.MessageBox{
			Text = _37kNH("\028\068\111\089\034\046\068\093\009\034\093\009\076\068\093\009\076\119\116\113\093\043\009\069\007\068\093\034\054\093\009\076\119\043\093\011\076\068\116\119\007\034\093\089\069\089\076\068\080\093\127\079\020\043\047\082\070\068\009\004\043\093\007\068\009\093\116\119\007\076\009\093\009\034\093\037\034\103\116\093\031\103\068\043\009\119\034\079\093\079\034\011\115"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputquestion3)
					end)
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function zonestage4:OnEnter()
	_Urwigo.MessageBox{
		Text = _37kNH("\025\068\037\093\011\068\093\054\034\116\007\034\009\093\043\034\046\068\009\076\119\079\007\115"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_z4SPT)
				end)
			end
		end
	}
end
function zonestage6:OnEnter()
	_Urwigo.MessageBox{
		Text = _37kNH("\122\034\103\093\069\116\068\093\046\034\112\119\079\007\093\116\119\007\076\009\093\069\111\034\079\007\093\079\034\011\080\093\120\009\069\007\068\093\043\119\087\067\093\034\079\111\037\093\069\093\089\034\103\047\111\068\093\046\034\116\068\093\043\009\034\047\043\093\009\034\093\007\034\080"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(zinputquestion6)
				end)
			end
		end
	}
end
function zonestage5:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputquestion5)
	end)
end
function zoneFinalHide:OnEnter()
	_edW:MoveTo(zoneFinalHide)
	_Urwigo.MessageBox{
		Text = _37kNH("\028\034\011\093\037\034\103\093\076\069\112\068\093\046\069\113\068\093\119\009\093\009\034\093\009\076\068\093\111\069\043\009\093\043\009\069\007\068\093\034\054\093\009\076\119\043\093\011\076\068\116\119\007\034\080\093\114\093\076\034\047\068\093\037\034\103\093\076\069\112\068\093\068\079\072\034\037\068\113\093\037\034\103\116\093\112\119\043\119\009\093\076\068\116\068\093\069\079\113\093\047\111\069\037\119\079\007\093\046\037\093\007\069\046\068\093\089\069\116\009\116\119\113\007\068\080\118\078\051\107"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_VV9v)
				end)
			end
		end
	}
end
function zonestage7:OnEnter()
	_Urwigo.MessageBox{
		Text = _37kNH("\028\068\111\089\034\046\068\093\009\034\093\009\076\068\093\043\068\112\068\079\009\076\093\043\009\069\007\068\093\034\054\093\009\076\119\043\093\011\076\068\116\119\007\034\093\089\069\089\076\068\080\093\122\034\103\093\069\116\068\093\007\068\009\009\119\079\007\093\089\111\034\043\068\093\009\034\093\009\076\068\093\068\079\113\093\043\034\093\113\034\093\079\034\009\093\007\119\112\068\093\103\047\093\079\034\011\115"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(zinputquestion7)
				end)
			end
		end
	}
end
function zinputquestion1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _37kNH("\046\069\116\089\076")) then
		_Urwigo.MessageBox{
			Text = _37kNH("\122\068\043\093\037\034\103\093\007\034\009\093\119\009\093\116\119\007\076\009\115\093\120\034\093\076\068\116\068\093\089\034\046\068\043\093\037\034\103\116\093\043\068\089\034\079\113\093\031\103\068\043\009\119\034\079\115"), 
			Media = _mTa, 
			Buttons = {
				_37kNH("\049\034\093\036\034\011")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_wEqX)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\114\093\069\046\093\043\034\093\043\034\116\116\037\067\093\009\076\069\009\093\119\043\093\079\034\009\093\009\076\068\093\089\034\116\116\068\089\009\093\069\079\043\011\068\116\115\093\001\076\068\093\069\079\043\011\068\116\093\037\034\103\093\069\116\068\093\111\034\034\033\119\079\007\093\054\034\116\093\119\043\093\034\079\093\009\076\068\093\020\119\007\093\043\119\007\079\080\093\001\076\119\043\093\009\119\046\068\093\037\034\103\093\089\069\079\093\007\034\093\069\076\068\069\113\093\069\079\113\093\007\103\068\043\043\093\069\007\069\119\079\080\093\078\103\009\093\020\068\093\011\069\116\079\068\113\093\119\079\089\034\116\116\068\089\009\093\069\079\043\011\068\116\043\093\011\119\111\111\093\119\079\089\103\116\093\069\093\047\068\079\069\111\009\037\093\111\069\009\068\116\093\119\079\093\009\076\068\093\007\069\046\068\115"), 
			Media = zmediawrong, 
			Buttons = {
				_37kNH("\001\116\037\093\069\007\069\119\079")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputquestion1)
					end)
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function zinputquestion2:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _37kNH("\053\119\043\076\119\079\007")) then
		_Urwigo.MessageBox{
			Text = _37kNH("\028\108\028\115\093\122\034\103\093\051\108\045\014\115\093\001\076\069\009\093\119\043\093\068\087\069\089\009\111\037\093\011\076\069\009\093\009\076\068\037\093\069\116\068\093\113\034\119\079\007\115"), 
			Media = __nAI1, 
			Buttons = {
				_37kNH("\049\034\093\036\034\011")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\036\034\011\093\054\034\116\093\037\034\103\116\093\043\068\089\034\079\113\093\031\103\068\043\009\119\034\079\093\076\068\116\068\115\093\077\116\068\093\037\034\103\093\043\103\116\068\093\037\034\103\093\069\116\068\093\116\068\069\113\037\015"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_bxlbN)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\051\068\046\068\046\020\068\116\093\114\093\011\069\116\079\068\113\093\037\034\103\093\079\034\009\093\009\034\093\007\103\068\043\043\093\069\079\113\093\079\034\011\093\037\034\103\093\046\103\043\009\093\047\069\037\093\009\076\068\093\047\116\119\089\068\115\093\122\034\103\093\046\103\043\009\093\116\068\009\103\116\079\093\009\034\093\009\076\068\093\046\069\119\079\093\089\119\116\089\111\068\093\069\079\113\093\069\079\043\011\068\116\093\069\079\034\009\076\068\116\093\031\103\068\043\009\119\034\079\115\093\078\103\009\093\009\076\069\009\093\119\043\093\034\033\067\093\020\068\089\069\103\043\068\093\068\087\009\116\069\093\011\069\111\033\119\079\007\093\119\043\093\007\116\068\069\009\093\068\087\068\116\089\119\043\068\115"), 
			Media = zmediawrong, 
			Buttons = {
				_37kNH("\001\116\037\093\077\007\069\119\079")
			}
		}
		zonestage1.Active = true
		zonestage1.Visible = true
		zonestage2.Active = false
		zonestage2.Visible = false
		_KJi_:MoveTo(Player)
	end
	cartRenameMe7:RequestSync()
end
function zinputquestion3:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _37kNH("\077\079\007\068\111")) then
		_Urwigo.MessageBox{
			Text = _37kNH("\108\079\089\068\093\069\007\069\119\079\093\037\034\103\093\069\116\068\093\116\119\007\076\009\093\034\079\093\009\076\068\093\046\069\116\033\115"), 
			Media = _mMP, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\025\068\037\093\114\093\116\068\046\068\046\020\068\116\093\009\076\119\043\093\043\047\034\009\080\093\126\069\113\076\069\103\111\068\116\004\043\093\089\069\089\076\068\093\119\043\093\072\103\043\009\093\069\093\054\068\011\093\054\068\068\009\093\069\011\069\037\080\093"), 
						Callback = function(action)
							if action ~= nil then
								if Player:Contains(_4GSe) then
									_Urwigo.MessageBox{
										Text = _37kNH("\036\034\011\093\011\034\103\111\113\093\020\068\093\069\093\007\116\068\069\009\093\009\119\046\068\093\009\034\093\054\119\087\093\119\009\080\093\028\076\037\093\113\034\079\004\009\093\037\034\103\093\007\034\093\069\076\068\069\113\093\069\079\113\093\116\068\047\111\069\089\068\093\009\076\069\009\093\034\111\113\093\083\108\083\051\119\079\007\015"), 
										Callback = function(action)
											if action ~= nil then
												_4GSe:MoveTo(nil)
												_Csq.Active = true
												_Csq.Visible = true
												_Urwigo.MessageBox{
													Text = _37kNH("\049\034\034\113\093\009\076\068\093\079\068\011\093\083\108\083\093\116\119\079\007\093\043\076\034\103\111\113\093\047\116\034\009\068\089\009\093\009\076\068\093\111\034\007\093\069\007\069\119\079\093\079\034\011\115\093\078\103\009\093\009\076\119\043\093\034\111\113\093\111\034\007\093\119\043\093\043\034\069\033\068\113\093\069\079\113\093\009\034\009\069\111\111\037\093\103\043\068\111\068\043\043\080\093\028\076\037\093\113\034\079\004\009\093\037\034\103\093\116\068\047\111\069\089\068\093\119\009\093\069\043\093\011\068\111\111\115"), 
													Media = _1P0, 
													Callback = function(action)
														if action ~= nil then
															_Csq.Complete = true
															_Urwigo.MessageBox{
																Text = _37kNH("\114\054\093\037\034\103\093\076\069\112\068\093\079\034\009\093\054\034\103\079\113\093\009\076\119\043\093\089\069\089\076\068\093\020\068\054\034\116\068\093\007\034\093\069\076\068\069\113\093\069\079\113\093\043\119\007\079\093\009\076\068\093\079\068\011\093\111\034\007\115\093\001\076\068\079\093\037\034\103\093\089\069\079\093\007\068\009\093\089\116\068\113\119\009\093\054\034\116\093\009\076\068\093\089\069\089\076\068\093\020\037\093\111\034\007\007\119\079\007\093\119\009\093\034\079\093\049\068\034\089\069\076\119\079\007\080\089\034\046\115"), 
																Media = _wZM, 
																Callback = function(action)
																	if action ~= nil then
																		_wm35M.Visible = true
																		_wm35M.Active = true
																		_xDq:MoveTo(nil)
																		_Urwigo.MessageBox{
																			Text = _37kNH("\036\034\011\093\009\076\068\093\111\069\043\009\093\043\009\068\047\093\119\043\093\054\034\116\093\037\034\103\093\009\034\093\047\103\009\093\009\076\068\093\089\034\079\009\069\119\079\068\116\093\020\069\089\033\093\011\076\068\116\068\093\119\009\093\007\034\068\043\080\093\001\076\068\093\089\034\116\116\068\089\009\093\089\034\034\116\113\119\079\069\009\068\043\093\069\116\068\093\036\066\061\093\066\016\080\030\016\094\093\028\061\094\023\080\030\065\080\065\016\094\093\069\079\113\093\037\034\103\093\043\076\034\103\111\113\093\020\068\093\069\020\111\068\093\009\034\093\054\119\007\103\116\068\093\034\103\009\093\076\034\011\093\119\009\093\011\069\043\093\076\119\113\113\068\079\115"), 
																			Callback = function(action)
																				if action ~= nil then
																					_wm35M.Complete = true
																					_o7H.Active = true
																					_o7H.Visible = true
																					_Urwigo.MessageBox{
																						Text = _37kNH("\049\116\068\069\009\093\011\034\116\033\093\116\068\047\069\119\116\119\079\007\093\009\076\068\093\089\069\089\076\068\080\093\114\093\069\046\093\043\103\116\068\093\126\069\113\076\069\103\111\068\116\093\069\047\047\116\068\089\119\069\009\068\043\093\009\076\068\093\076\068\111\047\080"), 
																						Callback = function(action)
																							if action ~= nil then
																								_o7H.Complete = true
																								_8x0t8:MoveTo(nil)
																								_Urwigo.MessageBox{
																									Text = _37kNH("\049\116\068\069\009\115\093\120\119\079\089\068\093\037\034\103\093\054\119\087\068\113\093\009\076\119\043\093\089\069\089\076\068\093\127\079\020\043\047\082\054\034\116\093\126\069\113\076\069\103\111\068\116\093\114\093\009\076\119\079\033\093\011\068\093\076\069\112\068\093\043\047\068\079\009\093\068\079\034\103\007\076\093\009\119\046\068\093\119\079\093\009\076\119\043\093\069\116\068\069\080\093\036\034\093\046\034\116\068\093\031\103\068\043\009\119\034\079\043\093\076\068\116\068\067\093\076\068\069\113\093\034\079\093\034\103\009\093\054\034\116\093\009\076\068\093\054\034\103\116\009\076\093\043\009\069\007\068\080")
																								}
																								zonestage4.Active = true
																								zonestage4.Visible = true
																								zonestage3.Active = false
																								zonestage3.Visible = false
																							end
																						end
																					}
																				end
																			end
																		}
																	end
																end
															}
														end
													end
												}
											end
										end
									}
								else
									_Urwigo.MessageBox{
										Text = _37kNH("\036\034\011\093\011\034\103\111\113\093\020\068\093\069\093\007\034\034\113\093\009\119\046\068\093\009\034\093\047\103\009\093\009\076\068\093\089\034\079\009\069\119\079\068\116\093\020\069\089\033\093\011\076\068\116\068\093\119\009\093\007\034\068\043\080\093\001\076\068\093\089\034\116\116\068\089\009\093\089\034\034\116\113\119\079\069\009\068\043\093\069\116\068\093\036\066\061\093\066\016\080\030\016\094\093\028\061\094\023\080\030\065\080\065\016\094\093\069\079\113\093\037\034\103\093\043\076\034\103\111\113\093\020\068\093\069\020\111\068\093\009\034\093\054\119\007\103\116\068\093\034\103\009\093\076\034\011\093\119\009\093\011\069\043\093\076\119\113\113\068\079\115\093"), 
										Callback = function(action)
											if action ~= nil then
												_o7H.Active = true
												_o7H.Visible = true
												_Urwigo.MessageBox{
													Text = _37kNH("\049\116\068\069\009\093\011\034\116\033\093\007\068\009\009\119\079\007\093\009\076\068\093\089\069\089\076\068\093\020\069\089\033\093\009\034\093\119\009\004\043\093\043\047\034\009\080\093\114\093\069\046\093\043\103\116\068\093\126\069\113\076\069\103\111\068\116\093\069\047\047\116\068\089\119\069\009\068\043\093\009\076\068\093\076\068\111\047\080"), 
													Callback = function(action)
														if action ~= nil then
															_Urwigo.MessageBox{
																Text = _37kNH("\049\116\068\069\009\115\093\120\119\079\089\068\093\037\034\103\093\054\119\087\068\113\093\009\076\119\043\093\089\069\089\076\068\093\127\079\020\043\047\082\054\034\116\093\126\069\113\076\069\103\111\068\116\093\114\093\009\076\119\079\033\093\011\068\093\076\069\112\068\093\043\047\068\079\009\093\068\079\034\103\007\076\093\009\119\046\068\093\119\079\093\009\076\119\043\093\069\116\068\069\080\093\036\034\093\046\034\116\068\093\031\103\068\043\009\119\034\079\043\093\076\068\116\068\067\093\076\068\069\113\093\034\079\093\034\103\009\093\054\034\116\093\009\076\068\093\054\034\103\116\009\076\093\043\009\069\007\068\080")
															}
															_o7H.Complete = true
															_8x0t8:MoveTo(nil)
															zonestage4.Active = true
															zonestage4.Visible = true
															zonestage3.Active = false
															zonestage3.Visible = false
														end
													end
												}
											end
										end
									}
								end
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\120\069\037\093\028\076\069\009\015\093\114\093\007\103\068\043\043\093\037\034\103\093\069\116\068\093\103\079\113\068\116\093\069\093\116\034\089\033\093\034\116\093\043\034\046\068\009\076\119\079\007\115\093\102\034\079\004\009\093\037\034\103\093\043\068\068\093\009\076\068\093\069\079\043\011\068\116\015\093\114\009\093\119\043\093\116\119\007\076\009\093\034\112\068\116\093\009\076\068\116\068\115\093\028\068\093\079\068\068\113\093\009\034\093\007\068\009\093\009\076\069\009\093\089\069\089\076\068\093\054\119\087\068\113\115"), 
			Media = zmediawrong, 
			Buttons = {
				_37kNH("\001\116\037\093\077\007\069\119\079")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\120\034\093\114\093\011\119\111\111\093\079\034\009\093\047\103\079\119\043\076\093\037\034\103\093\054\034\116\093\007\068\009\009\119\079\007\093\009\076\119\043\093\034\079\068\093\011\116\034\079\007\067\093\007\034\093\069\076\068\069\113\093\069\079\113\093\009\116\037\093\069\007\069\119\079\115"), 
						Media = zmediawrong, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputquestion3)
								end)
							end
						end
					}
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function zinputquestion4:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if _CHOuX.Remaining > 0 then
		if Wherigo.NoCaseEquals(Answer, _37kNH("\065\093\069\079\113\093\099\030")) then
			_CHOuX:Stop()
			_Urwigo.MessageBox{
				Text = _37kNH("\028\034\011\093\037\034\103\093\007\034\009\093\009\076\119\043\093\034\079\068\093\116\119\007\076\009\115\093\036\034\011\093\034\079\093\009\034\093\009\076\068\093\079\068\087\009\093\043\009\069\007\068\080"), 
				Media = _MVv, 
				Buttons = {
					_37kNH("\049\034\093\036\034\011")
				}, 
				Callback = function(action)
					if action ~= nil then
						zonestage4.Active = false
						zonestage4.Visible = false
						zonestage5.Visible = true
						zonestage5.Active = true
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _37kNH("\025\046\046\093\076\069\043\093\009\076\068\093\009\119\046\068\116\093\069\113\113\068\113\093\009\034\093\046\103\089\076\093\047\116\068\043\043\103\116\068\093\054\034\116\093\037\034\103\015\093\122\034\103\093\069\079\043\011\068\116\068\113\093\119\079\089\034\116\116\068\089\009\111\037\093\069\079\113\093\079\034\011\093\076\069\112\068\093\009\034\093\069\079\043\011\068\116\093\009\076\068\093\009\011\034\093\047\068\079\069\111\009\037\093\031\103\068\043\009\119\034\079\043\115"), 
				Media = zmediawrong, 
				Callback = function(action)
					if action ~= nil then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(_emDpz)
						end)
					end
				end
			}
		end
	elseif _CHOuX.Remaining == 0 then
		if Wherigo.NoCaseEquals(Answer, _37kNH("\065\093\069\079\113\093\099\030")) then
			_Urwigo.MessageBox{
				Text = _37kNH("\120\034\116\116\037\093\020\103\009\093\037\034\103\093\113\119\113\093\079\034\009\093\069\079\043\011\068\116\093\119\009\093\054\069\043\009\093\068\079\034\103\007\076\115\093\055\112\068\079\093\009\076\034\103\007\076\093\037\034\103\116\093\069\079\043\011\068\116\093\011\069\043\093\089\034\116\116\068\089\009\093\037\034\103\093\046\103\043\009\093\113\034\093\009\076\068\093\047\068\079\069\111\009\037\115"), 
				Callback = function(action)
					if action ~= nil then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(_emDpz)
						end)
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _37kNH("\036\034\009\093\034\079\111\037\093\113\119\113\093\037\034\103\093\007\068\009\093\009\076\068\093\069\079\043\011\068\116\093\011\116\034\079\113\093\020\103\009\093\037\034\103\093\069\111\043\034\093\116\069\079\093\034\103\009\093\034\054\093\009\119\046\068\080\093\025\068\116\068\093\069\116\068\093\037\034\103\116\093\047\068\079\069\111\009\037\093\031\103\068\043\009\119\034\079\043\115"), 
				Callback = function(action)
					if action ~= nil then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(_emDpz)
						end)
					end
				end
			}
		end
	end
	cartRenameMe7:RequestSync()
end
function zinputquestion5:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _37kNH("\047\054\089")) then
		_Urwigo.MessageBox{
			Text = _37kNH("\049\116\068\069\009\093\011\034\116\033\115"), 
			Media = _T7a, 
			Buttons = {
				_37kNH("\049\034\093\036\034\011")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\036\034\011\093\054\034\116\093\043\034\046\068\009\076\119\079\007\093\069\093\111\119\009\009\111\068\093\113\119\054\054\068\116\068\079\009\080\093\114\093\076\034\047\068\093\037\034\103\093\076\069\112\068\093\069\089\089\068\043\043\093\009\034\093\009\076\068\093\119\079\009\068\116\079\068\009\093\034\116\093\089\069\079\093\089\069\111\111\093\043\034\046\068\034\079\068\093\009\076\069\009\093\113\034\068\043\080\093"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _37kNH("\049\034\093\009\034\093\011\011\011\080\090\113\113\034\007\009\116\069\119\079\119\079\007\080\089\034\046\115\118\078\051\107"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _37kNH("\049\034\093\009\034\093\011\011\011\080\090\113\113\034\007\009\116\069\119\079\119\079\007\080\089\034\046\118\078\051\107\001\076\068\079\093\007\034\093\009\034\093\009\076\068\093\083\049\116\068\069\009\093\070\119\079\033\043\083\093\109\069\007\068"), 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _37kNH("\049\034\093\009\034\093\011\011\011\080\090\113\113\034\007\009\116\069\119\079\119\079\007\080\089\034\046\118\078\051\107\001\076\068\079\093\007\034\093\009\034\093\009\076\068\093\083\049\116\068\069\009\093\070\119\079\033\043\083\093\109\069\007\068\118\078\051\107\053\119\079\113\093\037\034\103\116\093\119\079\043\009\116\103\089\009\119\034\079\043\093\069\009\093\009\076\068\093\020\034\009\009\034\046\093\034\054\093\009\076\068\093\047\069\007\068")
														}
													end
												end
											}
										end
									end
								}
							end
						end
					}
					zonestage5.Visible = false
					zonestage5.Active = false
					zonestage1.Active = true
					_fhJlI:MoveTo(Player)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\001\076\069\009\093\069\119\079\004\009\093\116\119\007\076\009\115\093\025\068\116\068\093\119\043\093\069\093\020\119\007\093\076\119\079\009\093\054\034\116\093\037\034\103\093\076\068\093\011\069\043\093\119\079\093\009\076\068\093\077\116\046\037\115"), 
			Media = zmediawrong, 
			Buttons = {
				_37kNH("\001\116\076\093\077\007\069\119\079")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputquestion5)
					end)
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function zinputquestion6:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _37kNH("\070\069\103\116\069\093\036\119\089\033\103\046")) then
		_Urwigo.MessageBox{
			Text = _37kNH("\045\034\116\116\068\089\009\093\069\007\069\119\079\115\093\122\034\103\093\069\116\068\093\007\068\009\009\119\079\007\093\009\076\119\043\093\113\034\079\068\093\031\103\119\089\033\111\037\115"), 
			Media = _xzww, 
			Buttons = {
				_37kNH("\036\068\087\009\093\120\009\069\007\068")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_1c7o)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\036\034\093\037\034\103\093\113\034\079\004\009\093\079\068\068\113\093\046\034\116\068\093\076\068\111\047\015\093\001\116\037\093\069\007\069\119\079\080\080\080\080"), 
			Media = zmediawrong, 
			Buttons = {
				_37kNH("\001\116\037\093\077\007\069\119\079")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputquestion6)
					end)
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function zinputquestion7:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _37kNH("\046\119\033\068\037")) then
		_Urwigo.MessageBox{
			Text = _37kNH("\049\116\068\069\009\093\072\034\020\115\093\025\068\116\068\093\089\034\046\068\043\093\037\034\103\116\093\043\068\089\034\079\113\093\031\103\068\043\009\119\034\079\115"), 
			Media = _hSLQ, 
			Buttons = {
				_37kNH("\049\034\093\036\034\011")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\025\034\111\113\093\034\079\093\069\093\043\068\089\034\079\113\093\046\037\093\047\076\034\079\068\093\119\043\093\116\119\079\007\119\079\007\115"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _37kNH("\114\009\093\119\043\093\126\069\113\076\069\103\111\068\116\115"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _37kNH("\025\068\093\011\069\043\093\089\069\111\111\119\079\007\093\009\034\093\009\076\069\079\033\093\037\034\103\093\054\034\116\093\054\119\087\119\079\007\093\076\119\043\093\089\069\089\076\068\080\093"), 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _37kNH("\093\025\068\093\119\043\093\034\079\093\009\076\068\093\011\068\043\009\093\089\034\069\043\009\093\069\079\113\093\011\034\103\111\113\093\079\034\009\093\076\069\112\068\093\020\068\068\079\093\069\020\111\068\093\009\034\093\116\068\047\069\119\116\093\119\009\093\103\079\009\119\111\093\079\068\087\009\093\011\068\068\033\080\093"), 
															Callback = function(action)
																if action ~= nil then
																	_Urwigo.MessageBox{
																		Text = _37kNH("\078\037\093\009\076\068\079\093\076\119\043\093\089\034\079\009\069\119\079\068\116\093\011\034\103\111\113\093\076\069\112\068\093\020\068\068\079\093\007\034\079\068\115"), 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.MessageBox{
																					Text = _37kNH("\077\079\037\011\069\037\043\067\093\020\069\089\033\093\009\034\093\009\076\068\093\031\103\068\043\009\119\034\079\115"), 
																					Callback = function(action)
																						if action ~= nil then
																							_Urwigo.MessageBox{
																								Text = _37kNH("\122\034\103\093\069\116\068\093\007\068\009\009\119\079\007\093\043\034\093\089\111\034\043\068\093\009\034\093\009\076\068\093\068\079\113\115"), 
																								Callback = function(action)
																									if action ~= nil then
																										_Urwigo.RunDialogs(function()
																											Wherigo.GetInput(_KHY8_)
																										end)
																									end
																								end
																							}
																						end
																					end
																				}
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\049\103\068\043\043\093\069\007\069\119\079\115"), 
			Media = zmediawrong, 
			Buttons = {
				_37kNH("\001\116\037\093\077\007\069\119\079")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputquestion7)
					end)
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function _92t:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if _Urwigo.Hash(string.lower(input)) == 33119 then
		_Urwigo.MessageBox{
			Text = _37kNH("\120\068\068\093\054\119\079\113\119\079\007\093\009\076\068\093\069\079\043\011\068\116\043\093\119\043\093\079\034\009\093\116\068\069\111\111\037\093\009\076\069\009\093\076\069\116\113\080\093\013\103\043\009\093\009\069\033\068\093\037\034\103\116\093\009\119\046\068\093\069\079\113\093\054\119\079\113\093\009\076\068\093\119\079\054\034\116\046\069\009\119\034\079\093\037\034\103\093\079\068\068\113\080\093\122\034\103\093\046\069\037\093\047\116\034\089\068\068\113\093\034\079\093\037\034\103\116\093\011\069\037\093\020\069\089\033\093\069\079\113\093\114\093\076\034\047\068\093\037\034\103\093\007\068\009\093\009\076\068\093\089\034\116\116\068\089\009\093\069\079\043\011\068\116\093\009\076\119\043\093\009\119\046\068\080"), 
			Media = _mU9PC
		}
		zonestage1.Active = false
		zonestage1.Visible = false
		zonestage2.Active = true
		zonestage2.Visible = true
		_KJi_:MoveTo(nil)
		_iIY7:MoveTo(Player)
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\122\034\103\093\116\068\069\111\111\037\093\069\116\068\093\007\103\068\043\043\119\079\007\080\093\102\034\093\037\034\103\093\116\068\069\111\111\037\093\009\076\119\079\033\093\009\076\068\037\093\011\034\103\111\113\093\069\111\111\034\011\093\043\111\068\113\113\119\079\007\093\076\068\116\068\015\093\127\079\020\043\047\082\001\116\037\093\077\007\069\119\079\115"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_92t)
					end)
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function _wEqX:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_JWGJ = input
	if _Urwigo.Hash(string.lower(input)) == 64345 then
		_Urwigo.MessageBox{
			Text = _37kNH("\028\034\011\115\093\122\034\103\093\069\116\068\093\007\034\034\113\093\069\009\093\009\076\119\043\093\007\069\046\068\080\093\014\068\068\047\093\069\079\043\011\068\116\119\079\007\093\009\076\068\093\031\103\068\043\009\119\034\079\043\093\089\034\116\116\068\089\009\111\037\093\069\079\113\093\037\034\103\093\011\119\111\111\093\076\069\112\068\093\079\034\093\047\116\034\020\111\068\046\093\011\119\009\076\093\009\076\119\043\093\011\076\068\116\119\007\034\115\093\122\034\103\093\046\069\037\093\007\034\093\034\079\093\009\034\093\009\076\068\093\079\068\087\009\093\040\034\079\068\080"), 
			Media = _bDCI
		}
		zonestage1.Visible = false
		zonestage1.Active = false
		zonestage2.Visible = true
		zonestage2.Active = true
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\108\076\093\036\034\115\115\093\001\076\069\009\093\119\043\093\079\034\009\093\009\076\068\093\069\079\043\011\068\116\093\009\076\069\009\093\114\093\069\046\093\111\034\034\033\119\079\007\093\054\034\116\080\093\001\076\068\093\069\079\043\011\068\116\093\043\076\034\103\111\113\093\020\068\093\054\034\103\116\093\079\103\046\020\068\116\043\080\093\127\079\020\043\047\082\109\111\068\069\043\068\093\020\068\093\089\069\116\068\054\103\111\093\119\079\047\103\009\009\119\079\007\093\119\079\054\034\116\046\069\009\119\034\079\093\069\043\093\011\116\034\079\007\093\068\079\009\116\119\068\043\093\089\069\079\093\116\068\043\103\111\009\093\119\079\093\037\034\103\093\046\034\116\068\093\011\034\116\033\093\009\034\093\113\034\080\093\109\111\068\069\043\068\093\009\116\037\093\069\007\069\119\079\115"), 
			Media = zmediawrong, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_wEqX)
					end)
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function _kPK:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _37kNH("\053\119\043\076\119\079\007")) then
		_Urwigo.MessageBox{
			Text = _37kNH("\028\108\028\115\093\122\034\103\093\051\108\045\014\115\093\001\076\069\009\093\119\043\093\068\087\069\089\009\111\037\093\011\076\069\009\093\009\076\068\037\093\069\116\068\093\113\034\119\079\007\115"), 
			Media = __nAI1, 
			Buttons = {
				_37kNH("\049\034\093\036\034\011")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\036\034\011\093\054\034\116\093\037\034\103\116\093\043\068\089\034\079\113\093\031\103\068\043\009\119\034\079\093\076\068\116\068\115\093\077\116\068\093\037\034\103\093\043\103\116\068\093\037\034\103\093\069\116\068\093\116\068\069\113\037\015"), 
						Media = __nAI1, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_bxlbN)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\114\093\116\068\069\111\111\037\093\113\034\093\079\034\009\093\103\079\113\068\116\043\009\069\079\113\093\011\076\037\093\037\034\103\093\069\116\068\093\076\069\112\119\079\007\093\043\103\089\076\093\069\093\047\116\034\020\111\068\046\093\011\119\009\076\093\009\076\119\043\093\031\103\068\043\009\119\034\079\080\093\025\068\116\068\093\119\043\093\069\093\076\119\079\009\063\093\122\034\103\093\103\043\068\093\069\093\116\034\113\093\079\093\116\068\068\111\067\093\020\069\119\009\093\069\079\113\093\069\093\076\034\034\033\093\054\034\116\093\009\076\119\043\115"), 
			Media = zmediawrong, 
			Buttons = {
				_37kNH("\001\116\037\093\077\007\069\119\079")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\109\111\068\069\043\068\093\009\116\037\093\069\007\069\119\079\093\103\079\009\119\111\093\037\034\103\093\007\068\009\093\119\009\093\116\119\007\076\009\093\043\034\093\011\068\093\089\069\079\093\046\034\112\068\093\034\079\115"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_kPK)
								end)
							end
						end
					}
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function _VV9v:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if _Urwigo.Hash(string.lower(input)) == 2405 then
		_Urwigo.MessageBox{
			Text = _37kNH("\114\043\093\009\076\069\009\093\037\034\103\116\093\054\119\079\069\111\093\069\079\043\011\068\116\015"), 
			Media = zmediaquestion, 
			Buttons = {
				_37kNH("\122\068\043"), 
				_37kNH("\036\034")
			}, 
			Callback = function(action)
				if action ~= nil then
					if (action == "Button1") == true then
						if true then
							_edW:MoveTo(zoneFinalHide)
							_edW.Visible = true
							_edW.Commands._5eQCy.Enabled = true
							_Urwigo.MessageBox{
								Text = _37kNH("\122\034\103\093\076\069\112\068\093\113\034\079\068\093\011\068\111\111\080\093"), 
								Media = _DRWPv, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _37kNH("\028\068\111\111\093\009\076\119\043\093\046\069\037\093\079\034\009\093\020\068\093\009\076\068\093\046\034\043\009\093\089\116\068\069\009\119\112\068\093\011\076\068\116\119\007\034\093\043\009\034\116\037\111\119\079\068\093\114\093\076\034\047\068\093\119\009\093\076\069\043\093\007\119\112\068\079\093\037\034\103\093\069\093\111\119\009\009\111\068\093\009\069\043\009\068\093\034\054\093\011\076\069\009\093\009\076\068\093\043\034\054\009\011\069\116\068\093\089\069\079\093\113\034\093\069\079\113\093\046\069\037\020\068\093\119\079\043\047\119\116\068\113\093\037\034\103\093\009\034\093\009\116\037\093\009\034\093\089\034\046\068\093\103\047\093\011\119\009\076\093\034\079\068\093\034\054\093\037\034\103\116\093\034\011\079\080"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _37kNH("\109\111\068\069\043\068\093\116\068\046\068\046\020\068\116\093\009\034\093\103\043\068\093\037\034\103\116\093\089\034\046\047\111\068\009\119\034\079\093\089\034\113\068\093\009\034\093\103\079\111\034\089\033\093\009\076\119\043\093\089\069\116\009\116\119\113\007\068\093\069\079\113\093\111\034\007\093\009\076\119\043\093\069\043\093\089\034\046\047\111\068\009\068\113\093\009\076\068\116\068\080\093\001\076\069\009\093\034\009\076\068\116\043\093\011\119\111\111\093\033\079\034\011\093\009\076\068\093\089\069\116\009\116\119\113\007\068\093\011\034\116\033\043\093\069\079\113\093\007\119\112\068\093\119\009\093\069\093\009\116\037\115"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _37kNH("\122\034\103\093\089\034\103\111\113\093\089\116\068\069\009\068\093\069\093\079\119\089\068\093\011\076\068\116\119\007\034\093\119\079\093\046\069\079\037\093\047\111\069\089\068\043\093\009\076\069\009\093\069\093\112\119\116\009\103\069\111\093\011\034\103\111\113\093\076\069\112\068\093\007\034\079\068\093\119\079\093\009\076\068\093\047\069\043\009\067\093\047\103\009\009\119\079\007\093\009\076\068\093\089\069\089\076\068\093\119\079\093\069\093\111\068\007\069\111\093\043\047\034\009\093\079\068\069\116\020\037\115"), 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _37kNH("\049\034\093\069\076\068\069\113\093\069\079\113\093\047\119\089\033\093\103\047\093\069\079\113\093\009\076\068\079\093\068\087\069\046\119\079\068\093\037\034\103\116\093\046\069\047\093\009\034\093\054\119\079\113\093\009\076\068\093\007\068\034\089\069\089\076\068\093\104\049\045\090\066\077\061\051"), 
																				Callback = function(action)
																					if action ~= nil then
																						zoneFinalHide.Visible = false
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					else
						_Urwigo.MessageBox{
							Text = _37kNH("\028\068\111\111\093\034\033\093\009\076\068\079\067\093\076\068\116\068\093\119\043\093\037\034\103\116\093\089\076\069\079\089\068\093\009\034\093\007\103\068\043\043\093\069\007\069\119\079\115"), 
							Media = zmediaquestion, 
							Callback = function(action)
								if action ~= nil then
									_Urwigo.RunDialogs(function()
										Wherigo.GetInput(_VV9v)
									end)
								end
							end
						}
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\028\076\069\009\093\043\076\034\103\111\113\093\114\093\113\034\093\079\034\011\080\015\093\122\034\103\093\076\069\112\068\093\046\119\043\043\068\113\093\009\076\068\093\054\119\079\069\111\093\031\103\068\043\009\119\034\079\080\093\077\111\111\093\009\076\069\009\093\076\069\116\113\093\011\034\116\033\093\113\034\011\079\093\009\076\068\093\113\116\069\119\079\080\093\120\076\034\103\111\113\093\114\093\043\068\079\113\093\037\034\103\093\020\069\089\033\093\009\034\093\009\076\068\093\043\009\069\116\009\015"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\001\076\069\009\093\069\119\079\004\009\093\116\119\007\076\009\115\093\114\093\009\076\119\079\033\093\037\034\103\093\076\069\112\068\093\047\116\034\112\068\079\093\037\034\103\116\043\068\111\054\093\011\034\116\009\076\037\093\067\093\069\079\113\093\119\009\093\119\043\093\007\068\009\009\119\079\007\093\111\069\009\068\093\043\034\093\007\034\093\069\076\068\069\113\093\069\079\113\093\007\103\068\043\043\093\069\007\069\119\079\115"), 
						Media = zmediawrong, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_VV9v)
								end)
							end
						end
					}
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function _bxlbN:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if _Urwigo.Hash(string.lower(input)) == 55272 then
		_Urwigo.MessageBox{
			Text = _37kNH("\122\034\103\093\069\116\068\093\089\034\116\116\068\089\009\115\093\036\119\089\068\093\011\034\116\033\093\034\079\093\009\076\119\043\093\034\079\068\115"), 
			Media = _evzt, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\122\034\103\093\007\068\009\093\009\034\093\007\034\093\034\079\093\009\034\093\009\076\068\093\079\068\087\009\093\043\068\089\009\119\034\079\080"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _37kNH("\108\076\093\011\069\119\009\067\093\011\076\069\009\093\119\043\093\009\076\069\009\093\111\037\119\079\007\093\034\079\093\009\076\068\093\007\116\034\103\079\113\080\093\114\009\093\111\034\034\033\043\093\111\119\033\068\093\119\009\093\089\034\103\111\113\093\020\068\093\069\093\089\069\089\076\068\093\089\034\079\009\069\119\079\068\116\080\093\126\069\037\020\068\093\037\034\103\093\043\076\034\103\111\113\093\047\119\089\033\093\119\009\093\103\047\093\069\079\113\093\111\034\034\033\093\069\009\093\119\009\080\093"), 
									Callback = function(action)
										if action ~= nil then
											_8x0t8.Visible = true
											_8x0t8.Commands._7uab.Enabled = true
										end
									end
								}
							end
						end
					}
					zonestage3.Active = true
					zonestage3.Visible = true
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\120\069\037\093\011\076\069\009\015\093\001\076\069\009\093\119\043\093\079\034\009\093\011\076\069\009\093\114\093\043\069\011\093\011\116\119\009\009\068\079\093\034\079\093\076\068\116\093\043\009\034\079\068\115\093\028\076\069\009\093\009\076\068\093\076\068\089\033\067\093\114\093\069\046\093\054\068\068\111\119\079\007\093\079\119\089\068\093\043\034\093\007\034\093\069\076\068\069\113\093\069\079\113\093\007\103\068\043\043\093\069\007\069\119\079\115"), 
			Media = zmediawrong, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_bxlbN)
					end)
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function _z4SPT:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if _Urwigo.Hash(string.lower(input)) == 34270 then
		_YRE.Complete = true
		_Urwigo.MessageBox{
			Text = _37kNH("\049\116\068\069\009\115\093\036\034\011\093\011\076\068\116\068\093\011\068\116\068\093\011\068\093\034\079\093\009\076\119\043\093\007\069\046\068\115"), 
			Callback = function(action)
				if action ~= nil then
					_CHOuX:Start()
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputquestion4)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\025\068\037\067\093\011\068\093\079\068\068\113\093\009\034\093\111\068\009\093\126\069\113\076\069\103\111\068\116\093\033\079\034\011\093\011\068\093\054\119\087\068\113\093\009\076\119\043\093\043\034\093\011\068\093\089\069\079\093\043\069\112\068\093\076\119\046\093\069\093\009\116\119\047\093\034\103\009\093\076\068\116\068\115\118\078\051\107"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\049\034\093\069\076\068\069\113\093\069\079\113\093\047\034\043\009\093\119\009\093\079\034\011\115\093\114\093\011\119\111\111\093\011\069\119\009\093\069\043\093\114\093\069\046\093\119\079\093\079\034\093\076\103\116\116\037\093\069\009\093\069\111\111\115"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_z4SPT)
								end)
							end
						end
					}
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function _emDpz:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if _Urwigo.Hash(string.lower(input)) == 10165 then
		_Urwigo.MessageBox{
			Text = _37kNH("\049\116\068\069\009\093\072\034\020\067\093\076\068\116\068\093\119\043\093\037\034\103\116\093\079\068\087\009\093\031\103\068\043\009\119\034\079\115"), 
			Media = _ypz, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_CdnRp)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\001\076\069\009\093\069\119\079\004\009\093\116\119\007\076\009\115\093\077\116\068\093\037\034\103\093\076\069\112\119\079\007\093\009\116\034\103\020\111\068\093\054\119\079\113\119\079\007\093\009\076\068\093\069\079\043\011\068\116\015"), 
			Media = zmediawrong, 
			Buttons = {
				_37kNH("\122\068\043"), 
				_37kNH("\036\108")
			}, 
			Callback = function(action)
				if action ~= nil then
					if (action == "Button1") == true then
						_Urwigo.MessageBox{
							Text = _37kNH("\001\076\068\116\068\093\011\069\043\093\034\079\089\068\093\069\093\089\034\089\033\068\116\093\043\047\069\079\119\068\111\093\079\069\046\068\113\093\009\076\119\043\093\119\079\093\009\076\068\093\046\034\112\119\068\043\115"), 
							Callback = function(action)
								if action ~= nil then
									_Urwigo.RunDialogs(function()
										Wherigo.GetInput(_emDpz)
									end)
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = _37kNH("\108\033\093\011\068\111\111\093\007\103\068\043\043\093\069\007\069\119\079\115"), 
							Callback = function(action)
								if action ~= nil then
									_Urwigo.RunDialogs(function()
										Wherigo.GetInput(_emDpz)
									end)
								end
							end
						}
					end
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function _CdnRp:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if _Urwigo.Hash(string.lower(input)) == 49 then
		_Urwigo.MessageBox{
			Text = _37kNH("\122\034\103\093\046\069\113\068\093\031\103\119\089\033\093\011\034\116\033\093\034\054\093\009\076\068\093\047\068\079\069\111\009\037\093\031\103\068\043\009\119\034\079\043\093\034\079\093\009\076\068\093\043\009\069\007\068\067\093\069\079\113\093\037\034\103\093\069\116\068\093\079\034\011\093\034\112\068\116\093\076\069\111\054\093\011\069\037\093\113\034\079\068\080\093\118\078\051\107"), 
			Media = _Z6Edj, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\114\009\093\119\043\093\009\119\046\068\093\054\034\116\093\043\009\069\007\068\093\023")
					}
					zonestage4.Active = false
					zonestage4.Visible = false
					zonestage5.Active = true
					zonestage5.Visible = true
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\028\116\034\079\007\067\093\011\116\034\079\007\067\093\011\116\034\079\007\115\093\049\103\068\043\043\093\069\007\069\119\079\115"), 
			Media = zmediawrong, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_CdnRp)
					end)
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function _KHY8_:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if _Urwigo.Hash(string.lower(input)) == 56123 then
		_Urwigo.MessageBox{
			Text = _37kNH("\001\076\068\116\068\093\119\043\093\034\079\068\093\046\034\116\068\093\009\034\103\007\076\093\031\103\068\043\009\119\034\079\093\009\034\093\007\034\093\020\068\054\034\116\068\093\076\068\069\113\119\079\007\093\009\034\093\009\076\068\093\054\119\079\069\111\093\043\009\069\007\068\093\034\054\093\009\076\068\093\011\076\068\116\119\007\034\093\069\079\113\093\007\068\009\009\119\079\007\093\009\076\068\093\089\034\034\116\113\119\079\069\009\068\043\093\054\034\116\093\009\076\068\093\089\069\089\076\068\115"), 
			Media = _8z2, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\001\076\119\043\093\034\079\068\093\119\043\093\007\034\119\079\007\093\009\034\093\009\068\043\009\093\037\034\103\093\069\093\020\119\009\093\046\034\116\068\093\020\103\009\093\069\079\037\093\007\068\034\089\069\089\076\068\116\093\043\076\034\103\111\113\093\020\068\093\069\020\111\068\093\009\034\093\054\119\007\103\116\068\093\119\009\093\034\103\009\115"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_bL0v)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\122\034\103\093\007\034\009\093\009\076\119\043\093\034\079\068\093\011\116\034\079\007\067\093\020\103\009\093\043\119\079\089\068\093\119\009\093\119\043\093\009\076\068\093\043\068\089\034\079\113\093\031\103\068\043\009\119\034\079\093\037\034\103\093\034\079\111\037\093\047\103\079\119\043\076\046\068\079\009\093\011\119\111\111\093\020\068\093\069\093\034\079\068\093\046\119\079\103\009\068\093\113\068\111\069\037\093\119\079\093\069\079\043\068\116\119\079\007\093\069\007\069\119\079\115\093"), 
			Media = zmediawrong, 
			Callback = function(action)
				if action ~= nil then
					_uiLn:Start()
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function _bL0v:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if _Urwigo.Hash(string.lower(input)) == 54736 then
		_Urwigo.MessageBox{
			Text = _37kNH("\086\068\116\037\093\119\046\047\116\068\043\043\119\112\068\115\093\122\034\103\093\046\103\043\009\093\020\068\093\069\093\043\033\119\111\111\068\113\093\007\068\034\089\069\089\076\068\116\115"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _37kNH("\001\076\068\116\068\093\119\043\093\034\079\111\037\093\034\079\068\093\043\009\069\007\068\093\069\079\113\093\034\079\068\093\112\068\116\037\093\068\069\043\037\093\031\103\068\043\009\119\034\079\093\009\034\093\007\034\115")
					}
					zoneFinalHide.Active = true
					zoneFinalHide.Visible = true
					zonestage7.Active = false
					zonestage7.Visible = false
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\114\093\069\046\093\043\034\116\116\037\093\009\076\069\009\093\037\034\103\093\113\119\113\093\079\034\009\093\054\119\007\103\116\068\093\034\103\009\093\046\037\093\068\079\089\116\047\037\009\068\113\093\046\068\043\043\069\007\068\080\093"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_bL0v)
					end)
				end
			end
		}
	end
	cartRenameMe7:RequestSync()
end
function _1c7o:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if _Urwigo.Hash(string.lower(input)) == 16043 then
		_Urwigo.MessageBox{
			Text = _37kNH("\036\034\009\093\046\103\089\076\093\034\054\093\069\093\047\103\040\040\111\068\093\020\103\009\093\114\093\069\046\093\007\111\069\113\093\037\034\103\093\007\034\009\093\119\009\115")
		}
		zonestage7.Active = true
		zonestage7.Visible = true
		zonestage6.Active = false
		zonestage6.Visible = false
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\028\034\011\093\037\034\103\093\116\068\069\111\111\037\093\069\116\068\093\047\116\068\009\009\037\093\020\069\113\093\069\009\093\047\103\040\040\111\068\043\080\093\114\009\093\119\043\093\069\093\054\034\103\116\093\079\103\046\020\068\116\093\089\034\113\068\115\093\001\116\037\093\069\007\069\119\079\115"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_1c7o)
					end)
				end
			end
		}
	end
end
function _C0gnd:OnTick()
	if _G[_37kNH("\109\111\069\037\068\116")][_37kNH("\109\034\043\119\009\119\034\079\077\089\089\103\116\069\089\037")][_37kNH("\049\068\009\086\069\111\103\068")](_G[_37kNH("\109\111\069\037\068\116")][_37kNH("\109\034\043\119\009\119\034\079\077\089\089\103\116\069\089\037")], _37kNH("\046")) == 3 then
		for k, v in pairs(_G[_37kNH("\089\069\116\009\051\068\079\069\046\068\126\068\094")][_37kNH("\077\111\111\121\108\020\072\068\089\009\043")]) do
			v[_37kNH("\086\119\043\119\020\111\068")] = false
			v[_37kNH("\077\089\009\119\112\068")] = false
		end
		_G[_37kNH("\028\076\068\116\119\007\034")][_37kNH("\045\034\046\046\069\079\113")](_37kNH("\120\069\112\068\045\111\034\043\068"))
		return
	end
end
function _uiLn:OnTick()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_KHY8_)
	end)
end
function _8x0t8:On_7uab(target)
	_8x0t8:MoveTo(Player)
	_8x0t8.Commands._7uab.Enabled = false
	_8x0t8.Commands._QECI.Enabled = true
	_Urwigo.MessageBox{
		Text = _37kNH("\122\034\103\093\043\076\034\103\111\113\093\009\069\033\068\093\069\093\046\034\046\068\079\009\093\009\034\093\111\034\034\033\093\119\079\093\037\034\103\116\093\119\079\112\068\079\009\034\116\037\093\069\079\113\093\068\087\069\046\119\079\068\093\009\076\068\093\020\119\043\034\079\093\009\103\020\068\067\093\126\069\037\020\068\093\037\034\103\093\089\069\079\093\054\119\007\103\116\068\093\034\103\009\093\011\076\068\116\068\093\119\009\093\007\034\068\043\115")
	}
	_o7H.Active = true
	_o7H.Visible = true
end
function _8x0t8:On_QECI(target)
	if Player:Contains(_8x0t8) then
		_Urwigo.MessageBox{
			Text = _37kNH("\001\069\033\119\079\007\093\069\093\089\111\034\043\068\116\093\111\034\034\033\093\069\009\093\009\076\068\093\089\034\079\009\069\119\079\068\116\093\119\009\093\119\043\093\119\079\113\068\068\113\093\069\093\020\111\069\089\033\093\020\119\043\034\079\093\009\103\020\068\080\093\077\043\093\037\034\103\093\034\047\068\079\093\119\009\093\037\034\103\093\079\034\009\119\089\068\093\009\076\068\093\116\103\020\020\068\116\093\083\108\083\093\116\119\079\007\093\119\043\093\007\034\079\068\080\093"), 
			Callback = function(action)
				if action ~= nil then
					_8x0t8.Commands.__1F.Enabled = true
					_Urwigo.MessageBox{
						Text = _37kNH("\093\122\034\103\093\054\119\079\119\043\076\093\034\047\068\079\119\079\007\093\119\009\093\069\079\113\093\054\119\079\113\093\069\093\112\068\116\037\093\011\068\009\093\111\034\007\093\111\069\020\068\111\068\113\093\049\045\016\012\099\086\056\093\083\051\068\031\103\119\068\043\089\069\009\093\119\079\093\109\069\089\068\083\093\020\037\093\126\069\113\076\069\103\111\068\116\115"), 
						Media = _LzUU, 
						Callback = function(action)
							if action ~= nil then
								_8x0t8.Commands._mv8s.Enabled = true
								_Urwigo.MessageBox{
									Text = _37kNH("\025\068\037\093\009\076\069\009\093\089\069\089\076\068\093\020\068\111\034\079\007\043\093\076\068\116\068\093\119\079\093\009\076\068\093\089\068\046\068\009\068\116\037\093\069\079\113\093\046\103\043\009\093\076\069\112\068\093\089\034\046\068\093\111\034\034\043\068\093\054\116\034\046\093\119\009\043\093\076\119\113\119\079\007\093\043\047\034\009\093\037\034\103\093\089\069\079\093\054\119\079\113\093\119\009\093\007\068\034\089\069\089\076\119\079\007\080\089\034\046\080"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _37kNH("\114\093\069\046\093\043\103\116\068\093\126\069\113\076\069\103\111\068\116\093\011\034\103\111\113\093\111\034\112\068\093\054\034\116\093\037\034\103\093\009\034\093\116\068\047\069\119\116\093\119\009\093\054\034\116\093\076\119\046\080\093\077\054\009\068\116\093\069\111\111\093\076\068\093\119\043\093\111\119\033\068\111\037\093\034\079\093\009\076\068\093\116\034\069\113\093\043\034\046\068\011\076\068\116\068\093\113\116\119\112\119\079\007\093\009\076\069\009\093\020\119\007\093\116\119\007\115")
											}
											_wm35M.Active = true
											_Csq.Active = true
											zonestage3.Active = true
											zonestage3.Visible = true
											zonestage2.Active = false
											zonestage2.Visible = false
											_8x0t8.Commands._QECI.Enabled = false
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif not Player:Contains(_8x0t8) then
		_8x0t8.Commands._QECI.Enabled = false
	end
end
function _8x0t8:On__1F(target)
	_Urwigo.MessageBox{
		Text = _37kNH("\036\068\011\093\083\108\083\093\119\079\043\009\069\111\111\068\113"), 
		Media = _1P0
	}
	_4GSe:MoveTo(nil)
	_Csq.Complete = true
	_8x0t8.Commands.__1F.Enabled = false
end
function _8x0t8:On_mv8s(target)
	_Urwigo.MessageBox{
		Text = _37kNH("\051\068\047\111\069\089\068\113\093\070\034\007\115"), 
		Media = _wZM
	}
	_xDq:MoveTo(nil)
	_wm35M.Complete = true
	_8x0t8.Commands._mv8s.Enabled = false
end
function _edW:On_5eQCy(target)
	if (_G[_37kNH("\055\079\112")][_37kNH("\109\111\069\009\054\034\116\046")] == _37kNH("\028\119\079\090\016")) or (_G[_37kNH("\055\079\112")][_37kNH("\102\068\112\119\089\068\114\102")] == _37kNH("\102\068\043\033\009\034\047")) then
		_Urwigo.MessageBox{
			Text = _37kNH("\122\034\103\093\046\069\037\093\079\034\009\093\089\034\046\047\111\068\009\068\093\009\076\119\043\093\007\069\046\068\093\119\079\093\009\076\068\093\068\046\103\111\069\009\034\116\093\046\034\113\068\115\093\001\076\069\079\033\043\093\054\034\116\093\047\111\069\037\119\079\007\093\009\034\113\069\037\067\093\114\093\076\034\047\068\093\037\034\103\093\007\068\009\093\009\034\093\047\111\069\037\093\119\009\093\054\034\116\093\116\068\069\111\093\043\034\046\068\113\069\037\093\043\034\034\079\080"), 
			Callback = function(action)
				if action ~= nil then
					_edW.Visible = false
					_edW.Commands._5eQCy.Enabled = false
					zoneFinalHide.Active = false
					zoneFinalHide.Visible = false
				end
			end
		}
		Wherigo.Command "SaveClose"
	else
		_Urwigo.MessageBox{
			Text = _37kNH("\055\087\069\046\119\079\068\093\009\076\068\093\046\069\047\093\054\034\116\093\009\076\068\093\089\069\089\076\068\093\089\034\034\116\113\119\079\069\009\068\043\115")
		}
		_edW.Commands._TtC.Enabled = true
		_edW:MoveTo(Player)
		_edW.Commands._5eQCy.Enabled = false
		cartRenameMe7.Complete = true
		zoneFinalHide.Active = false
		zoneFinalHide.Visible = false
		cartRenameMe7:RequestSync()
	end
end
function _edW:On_TtC(target)
	_Urwigo.MessageBox{
		Text = _37kNH("\122\034\103\093\011\119\111\111\093\054\119\079\113\093\009\076\068\093\089\069\089\076\068\093\089\034\079\009\069\119\079\068\116\093\079\068\069\116\093\009\076\068\093\111\034\011\068\116\093\068\079\009\116\069\079\089\068\093\009\034\093\009\076\068\093\089\068\046\068\009\068\116\037\080\093\114\093\069\046\093\043\034\116\116\037\093\009\076\069\009\093\119\009\093\119\043\093\079\034\009\093\076\119\113\113\068\079\093\020\068\009\009\068\116\093\034\116\093\069\093\111\069\116\007\068\116\093\089\034\079\009\069\119\079\068\116\093\020\103\009\093\069\043\093\037\034\103\093\089\069\079\093\043\068\068\093\009\076\068\116\068\093\069\116\068\093\112\068\116\037\093\054\068\011\093\076\119\113\119\079\007\093\043\047\034\009\043\093\076\068\116\068\115"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _37kNH("\045\069\089\076\068\093\089\034\034\116\113\119\079\069\009\068\043\093\069\116\068\118\078\051\107\093\036\066\061\093\066\030\080\065\094\030\093\020\037\093\028\061\094\023\093\030\065\080\099\065\016"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _37kNH("\045\069\089\076\068\093\089\034\034\116\113\119\079\069\009\068\043\093\069\116\068\118\078\051\107\093\036\066\061\093\066\030\080\065\094\030\093\020\037\093\028\061\094\023\093\030\065\080\099\065\016\118\078\051\107\109\111\068\069\043\068\093\089\111\119\089\033\093\034\079\093\009\076\068\093\089\034\046\047\111\068\009\068\009\119\034\079\093\089\034\113\068\093\119\079\093\037\034\103\116\093\119\079\112\068\079\009\034\116\037\093\069\079\113\093\011\119\116\009\068\093\113\034\011\079\093\009\076\068\093\079\103\046\020\068\116\093\054\034\116\093\103\043\068\093\034\079\093\009\076\068\093\011\076\068\116\119\007\034\093\011\068\020\093\043\119\009\068\080")
							}
						end
					end
				}
				cartRenameMe7.Complete = true
				_SmX2:MoveTo(Player)
				_SmX2.Visible = true
				cartRenameMe7:RequestSync()
			end
		end
	}
end
function _edW:On_LBRM(target)
end
function _edW:On_L7Vt6(target)
	_Urwigo.MessageBox{
		Text = "", 
		Media = _cMebx
	}
end
function _SmX2:On_7XW(target)
	_Urwigo.MessageBox{
		Text = string.sub(Player.CompletionCode, 1, 15)
	}
end
function _SmX2:On_hslE(target)
	_Urwigo.MessageBox{
		Text = Player.Name
	}
end

-- Begin user functions --
-- End Urwigo functions --
-----------------------------------------------------------------------------------------------
-- URWIGO: Following code is imported from the Wherigo Builder cartridge.
-- It is only neccessary if the cartridge uses Author functions that use message box callbacks.
-- Otherwise it can be removed.
cartRenameMe7.MsgBoxCBFuncs = {}
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=23#--
cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zonestage2.Visible = true
zonestage2.Active = true
zonestage1.Visible = false
zonestage1.Active = false
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputquestion1)
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB4 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputquestion1)
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB6 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputquestion2)
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB7 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zonestage3.Visible = false
zonestage3.Active = false
zonestage4.Visible = true
zonestage4.Active = true
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB8 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputquestion3)
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB5 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zonestage2.Active = false
zonestage2.Visible = false
zonestage3.Visible = true
zonestage3.Active = true
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB10 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.GetInput(zinputquestion4)
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB9 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zonestage4.Active = false
zonestage4.Visible = false
zonestage5.Active = true
zonestage5.Visible = true
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB11 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zonestage4.Active = false
zonestage4.Visible = false
zonestage5.Visible = true
zonestage5.Active = true
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB12 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text=[[Yes this is a Wherigo Game. You may go to the next stage.]],Media=zmediawright,Buttons={"Go Now",},Callback=cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB11}
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB13 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zonestage4.Active = false
zonestage4.Visible = false
zonestage5.Visible = true
zonestage5.Active = true
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB14 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputquestion4)
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zonestage1.Visible = false
zonestage1.Active = false
zonestage2.Visible = true
zonestage2.Active = true
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB16 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputquestion5)
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB23 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputquestion8)
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB19 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
cartRenameMe7.Complete = true
Wherigo.Command("SaveClose")
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB15 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zonestage5.Visible = false
zonestage5.Active = false
zonestage6.Visible = true
zonestage6.Active = true
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB22 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zonestage8.Visible = false
zonestage8.Active = false
zoneFinalHide.Visible = true
zoneFinalHide.Active = true
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB17 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zonestage6.Visible = false
zonestage6.Active = false
zonestage7.Visible = true
zonestage7.Active = true
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB20 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zonestage7.Visible = false
zonestage7.Active = false
zoneFinalHide.Visible = true
zoneFinalHide.Active = true
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB21 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputquestion7)
end
end

cartRenameMe7.MsgBoxCBFuncs.MsgBoxCB18 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputquestion6)
end
end


-----------------------------------------------------------------------------------------------
-- URWIGO: Here follow imported Author functions


-- End user functions --
return cartRenameMe7
