require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

_po7 = Wherigo.ZCartridge()

-- String decode --
function _6rq(str)
	local res = ""
    local dtable = "\058\115\052\060\081\006\093\029\101\064\046\116\009\047\100\062\051\105\070\091\018\082\039\008\034\054\063\003\048\079\038\120\016\102\067\059\021\097\061\066\112\069\117\040\014\098\095\013\074\030\078\000\124\104\086\090\106\087\111\045\012\001\028\092\011\035\017\043\080\042\053\002\123\119\005\114\075\056\031\073\113\007\072\026\032\068\103\089\025\024\121\033\083\118\065\071\023\049\125\004\010\057\126\050\027\085\084\110\108\055\041\109\036\022\019\037\096\099\088\107\076\094\015\122\077\044\020"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
_mX6A = Wherigo.ZMedia(_po7)
_mX6A.Id = "46a5979d-90de-4c0e-850a-07d64a8d7d14"
_mX6A.Name = _6rq("\040\018\109\015\077\038\076\012\009")
_mX6A.Description = ""
_mX6A.AltText = ""
_mX6A.Resources = {
	{
		Type = "jpg", 
		Filename = "WegzumSchloss.jpg", 
		Directives = {}
	}
}
_Usp = Wherigo.ZMedia(_po7)
_Usp.Id = "8ff8ca0e-b82e-40f7-a7f2-7c6cab2f84a4"
_Usp.Name = _6rq("\040\018\109\015\107\043\118\054")
_Usp.Description = ""
_Usp.AltText = ""
_Usp.Resources = {
	{
		Type = "jpg", 
		Filename = "Tuch.jpg", 
		Directives = {}
	}
}
_RZ03E = Wherigo.ZMedia(_po7)
_RZ03E.Id = "8115a4f2-fa6d-4811-ae59-e796e9489330"
_RZ03E.Name = _6rq("\040\018\109\015\086\018\009\012\009\112\038\108\108")
_RZ03E.Description = ""
_RZ03E.AltText = ""
_RZ03E.Resources = {
	{
		Type = "jpg", 
		Filename = "Dietemann.jpg", 
		Directives = {}
	}
}
_ys3g = Wherigo.ZMedia(_po7)
_ys3g.Id = "5592e5af-9395-4195-83f6-3e73535231a8"
_ys3g.Name = _6rq("\040\018\109\015\121\043\112\041\009\108")
_ys3g.Description = ""
_ys3g.AltText = ""
_ys3g.Resources = {
	{
		Type = "jpg", 
		Filename = "Olle_Lumpen.jpg", 
		Directives = {}
	}
}
_cfT = Wherigo.ZMedia(_po7)
_cfT.Id = "b14f979d-3c72-4f07-bae7-438112591132"
_cfT.Name = _6rq("\086\043")
_cfT.Description = ""
_cfT.AltText = ""
_cfT.Resources = {
	{
		Type = "jpg", 
		Filename = "DU.jpg", 
		Directives = {}
	}
}
_sfSsz = Wherigo.ZMedia(_po7)
_sfSsz.Id = "79370f43-9e4d-4ea4-92e2-047e7bdcc15a"
_sfSsz.Name = _6rq("\019\009\043\086\018")
_sfSsz.Description = ""
_sfSsz.AltText = ""
_sfSsz.Resources = {
	{
		Type = "jpg", 
		Filename = "FeuDi.jpg", 
		Directives = {}
	}
}
_u3Xqs = Wherigo.ZMedia(_po7)
_u3Xqs.Id = "66a0a772-c8ed-4411-820d-d02c62fef48d"
_u3Xqs.Name = _6rq("\040\096\125")
_u3Xqs.Description = ""
_u3Xqs.AltText = ""
_u3Xqs.Resources = {
	{
		Type = "jpg", 
		Filename = "BGM1.jpg", 
		Directives = {}
	}
}
_dX5 = Wherigo.ZMedia(_po7)
_dX5.Id = "a6d45b64-ffef-4d65-85e5-4da1317e18b2"
_dX5.Name = _6rq("\046\009\002\059\034\034\009\108\009\076")
_dX5.Description = ""
_dX5.AltText = ""
_dX5.Resources = {
	{
		Type = "png", 
		Filename = "besoffen.png", 
		Directives = {}
	}
}
_MbGJ = Wherigo.ZMedia(_po7)
_MbGJ.Id = "e0b03f42-390c-454f-a5d1-9d1b34129dfe"
_MbGJ.Name = _6rq("\083\009\108\076\091")
_MbGJ.Description = ""
_MbGJ.AltText = ""
_MbGJ.Resources = {
	{
		Type = "jpg", 
		Filename = "HenryvomSchulberg.jpg", 
		Directives = {}
	}
}
_pdXH = Wherigo.ZMedia(_po7)
_pdXH.Id = "9b7caa33-76ae-48ba-badd-83337ea5e52f"
_pdXH.Name = _6rq("\042\015\074\038\076\015")
_pdXH.Description = ""
_pdXH.AltText = ""
_pdXH.Resources = {
	{
		Type = "jpg", 
		Filename = "Edward.jpg", 
		Directives = {}
	}
}
_akD = Wherigo.ZMedia(_po7)
_akD.Id = "82a24913-172f-41a2-b7eb-cc30ed0ea47d"
_akD.Name = _6rq("\042\112\112\038")
_akD.Description = ""
_akD.AltText = ""
_akD.Resources = {
	{
		Type = "jpg", 
		Filename = "Emma.jpg", 
		Directives = {}
	}
}
_Egeai = Wherigo.ZMedia(_po7)
_Egeai.Id = "4993f044-6019-4084-b580-eca79e5fc35d"
_Egeai.Name = _6rq("\095\109\018\118\009")
_Egeai.Description = ""
_Egeai.AltText = ""
_Egeai.Resources = {
	{
		Type = "jpg", 
		Filename = "Alice.jpg", 
		Directives = {}
	}
}
_b_20w = Wherigo.ZMedia(_po7)
_b_20w.Id = "36963321-f94b-42a5-b57d-b3498ebee152"
_b_20w.Name = _6rq("\086\018\112\038\104")
_b_20w.Description = ""
_b_20w.AltText = ""
_b_20w.Resources = {
	{
		Type = "jpg", 
		Filename = "Dietemann2.jpg", 
		Directives = {}
	}
}
_mMlzu = Wherigo.ZMedia(_po7)
_mMlzu.Id = "b7303ecf-fc13-4f32-91de-7770278078fb"
_mMlzu.Name = _6rq("\030\002\120\038\076")
_mMlzu.Description = ""
_mMlzu.AltText = ""
_mMlzu.Resources = {
	{
		Type = "jpg", 
		Filename = "Oskar.jpg", 
		Directives = {}
	}
}
_0IAa = Wherigo.ZMedia(_po7)
_0IAa.Id = "ee8f2fcd-8653-4bcc-b57c-60e52beeb312"
_0IAa.Name = _6rq("\030\112\038")
_0IAa.Description = ""
_0IAa.AltText = ""
_0IAa.Resources = {
	{
		Type = "jpg", 
		Filename = "oma.jpg", 
		Directives = {}
	}
}
_jCcc = Wherigo.ZMedia(_po7)
_jCcc.Id = "473448c8-056b-498f-ba9c-1633cff9e73b"
_jCcc.Name = _6rq("\002\041\059\018\109\009\076")
_jCcc.Description = ""
_jCcc.AltText = ""
_jCcc.Resources = {
	{
		Type = "jpg", 
		Filename = "spoiler1.jpg", 
		Directives = {}
	}
}
_WxWjz = Wherigo.ZMedia(_po7)
_WxWjz.Id = "7bdbd243-5b6f-4fd0-9fd2-6ddd18169683"
_WxWjz.Name = _6rq("\106\112\002\118\054\109\038\087")
_WxWjz.Description = ""
_WxWjz.AltText = ""
_WxWjz.Resources = {
	{
		Type = "jpg", 
		Filename = "Umschlag.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_po7.Id="02b74218-6708-4ac9-a338-7dd31ace5132"
_po7.Name="Auf der Suche nach dem Dietemann"
_po7.Description=[[Der Dietemann, das Wahrzeichen Eschweges blaest tagsueber zu jeder vollen Stunde bei einem Rundgang um die Spitze des Schlossturms, von wo er die Stadt bewacht. Einmal im Jahr, zum Johannisfest am ersten Wochenende im Juli, steigt er von seinem Turm und fuehrt gemeinsam mit zwoelf Biedermeiermaedchen den Festzug an. 
Heute erschien der Dietemann nicht an der Spitze des Schlossturmes, er wurde weder um 8 Uhr, noch um 9 Uhr gesichtet. Als man nachsah, was mit ihm los sei, stellte man fest, dass er entfuehrt wurde. Alle Ermittlungen blieben bisher erfolglos. 
Kannst du bei der Suche nach dem Wahrzeichen Eschweges eine Hilfe sein?]]
_po7.Visible=true
_po7.Activity="Geocache"
_po7.StartingLocationDescription=[[]]
_po7.StartingLocation = ZonePoint(51.1892153899299,10.0596651434898,0)
_po7.Version=""
_po7.Company=""
_po7.Author="SK-112"
_po7.BuilderVersion="URWIGO 1.12.4281.38707"
_po7.CreateDate="11/12/2011 21:17:03"
_po7.PublishDate="1/1/0001 12:00:00 AM"
_po7.UpdateDate="11/24/2011 17:12:57"
_po7.LastPlayedDate="1/1/0001 12:00:00 AM"
_po7.TargetDevice="PocketPC"
_po7.TargetDeviceVersion="0"
_po7.StateId="1"
_po7.CountryId="2"
_po7.Complete=false
_po7.UseLogging=true


-- Zones --
_Wm9 = Wherigo.Zone(_po7)
_Wm9.Id = "cf1dfc6c-292d-49b6-bcda-2d153b772ff3"
_Wm9.Name = _6rq("\086\009\076\085\093\118\054\109\059\002\002\012\043\076\112")
_Wm9.Description = _6rq("\083\018\009\076\085\018\002\012\085\015\009\076\085\086\018\009\012\009\112\038\108\108\085\012\038\009\087\109\018\118\054\085\009\076\002\118\054\018\009\108\009\108\085\043\112\085\018\108\002\085\121\038\108\015\085\124\043\085\046\109\038\002\009\108\092")
_Wm9.Visible = false
_Wm9.Commands = {}
_Wm9.DistanceRange = Distance(-1, "feet")
_Wm9.ShowObjects = "OnEnter"
_Wm9.ProximityRange = Distance(5, "meters")
_Wm9.AllowSetPositionTo = false
_Wm9.Active = false
_Wm9.Points = {
	ZonePoint(51.1887228320822, 10.0531098246574, 0), 
	ZonePoint(51.1885042893715, 10.052852332592, 0), 
	ZonePoint(51.1883899743099, 10.0531715154648, 0), 
	ZonePoint(51.1886169230519, 10.0533136725426, 0)
}
_Wm9.OriginalPoint = ZonePoint(51.1885585047039, 10.0531118363142, 0)
_Wm9.DistanceRangeUOM = "Feet"
_Wm9.ProximityRangeUOM = "Meters"
_Wm9.OutOfRangeName = ""
_Wm9.InRangeName = ""
_O0H = Wherigo.Zone(_po7)
_O0H.Id = "b62448ba-bb01-46aa-99ec-7637516c7ff5"
_O0H.Name = _6rq("\107\038\108\124\120\076\009\018\002")
_O0H.Description = ""
_O0H.Visible = false
_O0H.Commands = {}
_O0H.DistanceRange = Distance(-1, "feet")
_O0H.ShowObjects = "OnEnter"
_O0H.ProximityRange = Distance(0, "meters")
_O0H.AllowSetPositionTo = false
_O0H.Active = false
_O0H.Points = {
	ZonePoint(51.1895255473755, 10.0603021681309, 0), 
	ZonePoint(51.1895154609874, 10.0604952871799, 0), 
	ZonePoint(51.1893944241574, 10.060500651598, 0), 
	ZonePoint(51.1893876998797, 10.060328990221, 0)
}
_O0H.OriginalPoint = ZonePoint(51.1894557831, 10.0604067742825, 0)
_O0H.DistanceRangeUOM = "Feet"
_O0H.ProximityRangeUOM = "Meters"
_O0H.OutOfRangeName = ""
_O0H.InRangeName = ""
_lInE = Wherigo.Zone(_po7)
_lInE.Id = "93590b80-4017-470c-a14b-208290a28b82"
_lInE.Name = _6rq("\019\009\043\086\018")
_lInE.Description = ""
_lInE.Visible = false
_lInE.Commands = {}
_lInE.DistanceRange = Distance(-1, "feet")
_lInE.ShowObjects = "OnEnter"
_lInE.ProximityRange = Distance(5, "meters")
_lInE.AllowSetPositionTo = false
_lInE.Active = false
_lInE.Points = {
	ZonePoint(51.186067467948, 10.0511156022549, 0), 
	ZonePoint(51.1858741306179, 10.0510700047016, 0), 
	ZonePoint(51.1858455502481, 10.0513811409473, 0), 
	ZonePoint(51.1860355253146, 10.0513730943203, 0)
}
_lInE.OriginalPoint = ZonePoint(51.1859556685321, 10.051234960556, 0)
_lInE.DistanceRangeUOM = "Feet"
_lInE.ProximityRangeUOM = "Meters"
_lInE.OutOfRangeName = ""
_lInE.InRangeName = ""
_BLi = Wherigo.Zone(_po7)
_BLi.Id = "bd9ae5bd-08c4-4c92-aebc-126a6457c1a6"
_BLi.Name = _6rq("\051\018\120\059\109\038\018\012\043\076\112")
_BLi.Description = ""
_BLi.Visible = false
_BLi.Commands = {}
_BLi.DistanceRange = Distance(-1, "feet")
_BLi.ShowObjects = "OnEnter"
_BLi.ProximityRange = Distance(5, "meters")
_BLi.AllowSetPositionTo = false
_BLi.Active = false
_BLi.Points = {
	ZonePoint(51.1868416497396, 10.0536569952965, 0), 
	ZonePoint(51.1870534757164, 10.0536838173866, 0), 
	ZonePoint(51.186994635265, 10.0533539056778, 0), 
	ZonePoint(51.1868416497396, 10.0533485412598, 0)
}
_BLi.OriginalPoint = ZonePoint(51.1869328526151, 10.0535108149052, 0)
_BLi.DistanceRangeUOM = "Feet"
_BLi.ProximityRangeUOM = "Meters"
_BLi.OutOfRangeName = ""
_BLi.InRangeName = ""
_Fm6rD = Wherigo.Zone(_po7)
_Fm6rD.Id = "e2517643-c83e-4904-b577-87d8c92932dc"
_Fm6rD.Name = _6rq("\093\118\054\043\109\046\009\076\087")
_Fm6rD.Description = ""
_Fm6rD.Visible = false
_Fm6rD.Commands = {}
_Fm6rD.DistanceRange = Distance(-1, "feet")
_Fm6rD.ShowObjects = "OnEnter"
_Fm6rD.ProximityRange = Distance(5, "meters")
_Fm6rD.AllowSetPositionTo = false
_Fm6rD.Active = false
_Fm6rD.Points = {
	ZonePoint(51.1883000350551, 10.0576360523701, 0), 
	ZonePoint(51.1882142984056, 10.0576119124889, 0), 
	ZonePoint(51.18819244394, 10.0578720867634, 0), 
	ZonePoint(51.1882983539459, 10.0578801333904, 0)
}
_Fm6rD.OriginalPoint = ZonePoint(51.1882512828367, 10.0577500462532, 0)
_Fm6rD.DistanceRangeUOM = "Feet"
_Fm6rD.ProximityRangeUOM = "Meters"
_Fm6rD.OutOfRangeName = ""
_Fm6rD.InRangeName = ""
_6Ig4 = Wherigo.Zone(_po7)
_6Ig4.Id = "7e8a1427-bb61-4697-897f-b85b9a7cbd13"
_6Ig4.Name = _6rq("\125\038\076\120\012\120\018\076\118\054\009")
_6Ig4.Description = ""
_6Ig4.Visible = false
_6Ig4.Commands = {}
_6Ig4.DistanceRange = Distance(-1, "feet")
_6Ig4.ShowObjects = "OnEnter"
_6Ig4.ProximityRange = Distance(5, "meters")
_6Ig4.AllowSetPositionTo = false
_6Ig4.Active = false
_6Ig4.Points = {
	ZonePoint(51.1870652437977, 10.0596383213997, 0), 
	ZonePoint(51.1872400835084, 10.0596061348915, 0), 
	ZonePoint(51.1872602572785, 10.059874355793, 0), 
	ZonePoint(51.1870618814891, 10.059874355793, 0)
}
_6Ig4.OriginalPoint = ZonePoint(51.1871568665184, 10.0597482919693, 0)
_6Ig4.DistanceRangeUOM = "Feet"
_6Ig4.ProximityRangeUOM = "Meters"
_6Ig4.OutOfRangeName = ""
_6Ig4.InRangeName = ""
_nEn = Wherigo.Zone(_po7)
_nEn.Id = "5101ca5a-b807-42fa-8ee7-e0bf2e599b21"
_nEn.Name = _6rq("\022\038\012\054\038\043\002")
_nEn.Description = ""
_nEn.Visible = false
_nEn.Commands = {}
_nEn.DistanceRange = Distance(-1, "feet")
_nEn.ShowObjects = "OnEnter"
_nEn.ProximityRange = Distance(5, "meters")
_nEn.AllowSetPositionTo = false
_nEn.Active = false
_nEn.Points = {
	ZonePoint(51.1868651860075, 10.0572136044502, 0), 
	ZonePoint(51.1870585191803, 10.0572779774666, 0), 
	ZonePoint(51.1870635626434, 10.0578036904335, 0), 
	ZonePoint(51.1868904034238, 10.0578305125237, 0)
}
_nEn.OriginalPoint = ZonePoint(51.1869694178137, 10.0575314462185, 0)
_nEn.DistanceRangeUOM = "Feet"
_nEn.ProximityRangeUOM = "Meters"
_nEn.OutOfRangeName = ""
_nEn.InRangeName = ""
_Ig1 = Wherigo.Zone(_po7)
_Ig1.Id = "c14ebb55-7709-419c-9e00-ac8929b795e1"
_Ig1.Name = _6rq("\056\018\109\109\009")
_Ig1.Description = ""
_Ig1.Visible = false
_Ig1.Commands = {}
_Ig1.DistanceRange = Distance(-1, "feet")
_Ig1.ShowObjects = "OnEnter"
_Ig1.ProximityRange = Distance(5, "meters")
_Ig1.AllowSetPositionTo = false
_Ig1.Active = false
_Ig1.Points = {
	ZonePoint(51.1866357068845, 10.0551603734493, 0), 
	ZonePoint(51.1866273010341, 10.0553749501705, 0), 
	ZonePoint(51.1865096189679, 10.0554929673672, 0), 
	ZonePoint(51.1865163436655, 10.0552488863468, 0)
}
_Ig1.OriginalPoint = ZonePoint(51.186572242638, 10.0553192943335, 0)
_Ig1.DistanceRangeUOM = "Feet"
_Ig1.ProximityRangeUOM = "Meters"
_Ig1.OutOfRangeName = ""
_Ig1.InRangeName = ""
_Br3_a = Wherigo.Zone(_po7)
_Br3_a.Id = "e1a10be4-ac3d-4dc8-bbd0-a0ff0e31a363"
_Br3_a.Name = _6rq("\040\076\038\043\009\076\009\018")
_Br3_a.Description = ""
_Br3_a.Visible = false
_Br3_a.Commands = {}
_Br3_a.DistanceRange = Distance(-1, "feet")
_Br3_a.ShowObjects = "OnEnter"
_Br3_a.ProximityRange = Distance(5, "meters")
_Br3_a.AllowSetPositionTo = false
_Br3_a.Active = false
_Br3_a.Points = {
	ZonePoint(51.1854252486459, 10.0563459098339, 0), 
	ZonePoint(51.1853882619214, 10.0560213625431, 0), 
	ZonePoint(51.1855244401695, 10.0559918582439, 0), 
	ZonePoint(51.1855412522711, 10.0563244521618, 0)
}
_Br3_a.OriginalPoint = ZonePoint(51.185469800752, 10.0561708956957, 0)
_Br3_a.DistanceRangeUOM = "Feet"
_Br3_a.ProximityRangeUOM = "Meters"
_Br3_a.OutOfRangeName = ""
_Br3_a.InRangeName = ""
_1b800 = Wherigo.Zone(_po7)
_1b800.Id = "e4c28163-1468-4d7f-812f-226f1393c117"
_1b800.Name = _6rq("\019\018\108\038\109")
_1b800.Description = ""
_1b800.Visible = false
_1b800.Commands = {}
_1b800.DistanceRange = Distance(-1, "feet")
_1b800.ShowObjects = "OnEnter"
_1b800.ProximityRange = Distance(5, "meters")
_1b800.AllowSetPositionTo = false
_1b800.Active = false
_1b800.Points = {
	ZonePoint(51.1856765894648, 10.0569024682045, 0), 
	ZonePoint(51.1856143848412, 10.0567173957825, 0), 
	ZonePoint(51.1852680548619, 10.056813955307, 0), 
	ZonePoint(51.1853638842913, 10.057181417942, 0)
}
_1b800.OriginalPoint = ZonePoint(51.1854807283648, 10.056903809309, 0)
_1b800.DistanceRangeUOM = "Feet"
_1b800.ProximityRangeUOM = "Meters"
_1b800.OutOfRangeName = ""
_1b800.InRangeName = ""

-- Characters --
_tOPq = Wherigo.ZCharacter{
	Cartridge = _po7, 
	Container = Player
}
_tOPq.Id = "85973457-54a7-4494-ab1e-9e4a16cc1e9b"
_tOPq.Name = _6rq("\086\106")
_tOPq.Description = _6rq("\086\038\002\085\046\018\002\012\085\086\043\092")
_tOPq.Visible = true
_tOPq.Media = _cfT
_tOPq.Commands = {}
_tOPq.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_tOPq.Gender = "Male"
_tOPq.Type = "NPC"
_EYsPd = Wherigo.ZCharacter{
	Cartridge = _po7, 
	Container = _lInE
}
_EYsPd.Id = "625f1346-2fb8-4124-a44e-6edee119ef15"
_EYsPd.Name = _6rq("\019\009\043\086\018")
_EYsPd.Description = ""
_EYsPd.Visible = true
_EYsPd.Media = _sfSsz
_EYsPd.Commands = {}
_EYsPd.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_EYsPd.Gender = "Male"
_EYsPd.Type = "NPC"
_IgAz = Wherigo.ZCharacter{
	Cartridge = _po7, 
	Container = _nEn
}
_IgAz.Id = "38301e2d-6c22-4a24-8a1c-2c3777bf072a"
_IgAz.Name = _6rq("\040\043\076\087\009\076\112\009\018\002\012\009\076")
_IgAz.Description = ""
_IgAz.Visible = true
_IgAz.Media = _u3Xqs
_IgAz.Commands = {}
_IgAz.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_IgAz.Gender = "Male"
_IgAz.Type = "NPC"
_va78M = Wherigo.ZCharacter{
	Cartridge = _po7, 
	Container = _Fm6rD
}
_va78M.Id = "c709168e-6b52-40e6-943e-44a2a913719c"
_va78M.Name = _6rq("\083\009\108\076\091")
_va78M.Description = ""
_va78M.Visible = true
_va78M.Media = _MbGJ
_va78M.Commands = {}
_va78M.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_va78M.Gender = "Male"
_va78M.Type = "NPC"
_RANn = Wherigo.ZCharacter{
	Cartridge = _po7, 
	Container = _6Ig4
}
_RANn.Id = "b7807a82-f8af-4a7e-8b8c-db558d252534"
_RANn.Name = _6rq("\095\109\018\118\009")
_RANn.Description = ""
_RANn.Visible = true
_RANn.Media = _Egeai
_RANn.Commands = {}
_RANn.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_RANn.Gender = "Female"
_RANn.Type = "NPC"
_EOF0K = Wherigo.ZCharacter{
	Cartridge = _po7, 
	Container = _6Ig4
}
_EOF0K.Id = "90c24abe-4202-44d4-bc0e-31dee7218424"
_EOF0K.Name = _6rq("\042\112\112\038\085\015\018\009\085\040\018\109\015\124\009\018\012\043\108\087")
_EOF0K.Description = ""
_EOF0K.Visible = true
_EOF0K.Media = _akD
_EOF0K.Commands = {}
_EOF0K.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_EOF0K.Gender = "Female"
_EOF0K.Type = "NPC"
_rYK = Wherigo.ZCharacter{
	Cartridge = _po7, 
	Container = _6Ig4
}
_rYK.Id = "9677890e-b6be-4e23-b6b2-b8dbe6a8015b"
_rYK.Name = _6rq("\042\015\074\038\076\015")
_rYK.Description = ""
_rYK.Visible = true
_rYK.Media = _pdXH
_rYK.Commands = {}
_rYK.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_rYK.Gender = "Male"
_rYK.Type = "NPC"
_8petH = Wherigo.ZCharacter{
	Cartridge = _po7, 
	Container = _Ig1
}
_8petH.Id = "618e0456-dd47-465a-9f7d-04a16b46b9a8"
_8petH.Name = _6rq("\077\038\076\109\085\015\009\076\085\107\076\018\108\120\009\076")
_8petH.Description = ""
_8petH.Visible = true
_8petH.Media = _dX5
_8petH.Commands = {}
_8petH.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_8petH.Gender = "Male"
_8petH.Type = "NPC"
_yXu5 = Wherigo.ZCharacter{
	Cartridge = _po7, 
	Container = _Br3_a
}
_yXu5.Id = "17a13936-e82a-456e-8a85-e22f498dc16b"
_yXu5.Name = _6rq("\086\018\009\012\009\112\038\108\108")
_yXu5.Description = ""
_yXu5.Visible = true
_yXu5.Media = _b_20w
_yXu5.Commands = {}
_yXu5.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_yXu5.Gender = "Male"
_yXu5.Type = "NPC"
_yiR8 = Wherigo.ZCharacter{
	Cartridge = _po7, 
	Container = _Wm9
}
_yiR8.Id = "c54916fa-b583-4780-996d-3df62fed09d0"
_yiR8.Name = _6rq("\030\002\120\038\076")
_yiR8.Description = ""
_yiR8.Visible = true
_yiR8.Media = _mMlzu
_yiR8.Commands = {}
_yiR8.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_yiR8.Gender = "Male"
_yiR8.Type = "NPC"
_c0S = Wherigo.ZCharacter{
	Cartridge = _po7, 
	Container = _Br3_a
}
_c0S.Id = "f8c855da-d198-43d0-88a4-e57ae1fdf372"
_c0S.Name = _6rq("\069\038\002\002\038\108\012")
_c0S.Description = ""
_c0S.Visible = false
_c0S.Commands = {}
_c0S.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_c0S.Gender = "Male"
_c0S.Type = "NPC"

-- Items --
_oOVKu = Wherigo.ZItem{
	Cartridge = _po7, 
	Container = _lInE
}
_oOVKu.Id = "cc2d8e02-25bf-4c05-8574-9dd31f376ca7"
_oOVKu.Name = _6rq("\019\059\012\059\085\094\059\112\085\086\018\009\012\009\112\038\108\108")
_oOVKu.Description = ""
_oOVKu.Visible = false
_oOVKu.Media = _RZ03E
_oOVKu.Commands = {}
_oOVKu.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_oOVKu.Locked = false
_oOVKu.Opened = false
_jf7A = Wherigo.ZItem{
	Cartridge = _po7, 
	Container = _O0H
}
_jf7A.Id = "3abffe97-fc29-4834-9c4f-8352b40b8f43"
_jf7A.Name = _6rq("\077\038\076\012\009")
_jf7A.Description = ""
_jf7A.Visible = true
_jf7A.Media = _mX6A
_jf7A.Commands = {}
_jf7A.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_jf7A.Locked = false
_jf7A.Opened = true
_MZ4zV = Wherigo.ZItem{
	Cartridge = _po7, 
	Container = _Wm9
}
_MZ4zV.Id = "0666b593-a7ef-4963-9c5a-74028209fd14"
_MZ4zV.Name = _6rq("\107\043\118\054")
_MZ4zV.Description = ""
_MZ4zV.Visible = true
_MZ4zV.Media = _Usp
_MZ4zV.Commands = {}
_MZ4zV.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_MZ4zV.Locked = false
_MZ4zV.Opened = false
_OeqsO = Wherigo.ZItem{
	Cartridge = _po7, 
	Container = _Fm6rD
}
_OeqsO.Id = "70392d8d-c10d-4472-bdef-35c98b0d7d33"
_OeqsO.Name = _6rq("\121\043\112\041\009\108")
_OeqsO.Description = ""
_OeqsO.Visible = true
_OeqsO.Media = _ys3g
_OeqsO.Commands = {}
_OeqsO.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_OeqsO.Locked = false
_OeqsO.Opened = false
_ttf = Wherigo.ZItem(_po7)
_ttf.Id = "5d1223e3-bbfb-4daa-a6e7-d76e485f1414"
_ttf.Name = _6rq("\002\041\059\018\109\009\076")
_ttf.Description = ""
_ttf.Visible = true
_ttf.Media = _jCcc
_ttf.Commands = {
	_ZcGf = Wherigo.ZCommand{
		Text = _6rq("\040\009\034\009\054\109"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _6rq("\051\018\118\054\012\085\094\009\076\034\043\087\046\038\076")
	}
}
_ttf.Commands._ZcGf.Custom = true
_ttf.Commands._ZcGf.Id = "6b14143e-b5ab-4f5b-80b1-18aed0062fd9"
_ttf.Commands._ZcGf.WorksWithAll = true
_ttf.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_ttf.Locked = false
_ttf.Opened = false

-- Tasks --
_gNK = Wherigo.ZTask(_po7)
_gNK.Id = "b177839b-d757-40c2-84d3-0a15b34deffc"
_gNK.Name = _6rq("\040\009\087\018\046\085\015\018\118\054\085\124\043\112\085\093\118\054\109\059\002\002")
_gNK.Description = _6rq("\040\009\087\018\046\085\015\018\118\054\085\108\043\108\085\124\043\112\085\093\118\054\109\059\002\002\012\043\076\112\126\085\043\112\085\108\038\118\054\085\083\018\108\074\009\018\002\009\108\085\124\043\085\002\043\118\054\009\108\126\085\015\018\009\085\034\043\009\076\085\015\038\002\085\095\043\034\034\018\108\015\009\108\085\015\009\002\085\086\018\009\012\009\112\038\108\108\009\002\085\054\018\109\034\076\009\018\118\054\085\002\009\018\108\085\120\059\009\108\108\012\009\108\011\085\086\043\085\034\018\108\015\009\002\012\085\015\009\108\085\058\009\087\085\124\043\112\085\093\118\054\109\059\002\002\012\043\076\112\085\038\043\034\085\015\009\076\085\077\038\076\012\009\085\002\059\074\018\009\085\018\108\085\015\009\018\108\009\108\085\121\059\118\038\012\018\059\108\002\092")
_gNK.Visible = false
_gNK.Active = false
_gNK.Complete = false
_gNK.CorrectState = "None"
_FE_ = Wherigo.ZTask(_po7)
_FE_.Id = "83612a89-8dd0-4fa7-846c-73da82cc4cba"
_FE_.Name = _6rq("\093\043\118\054\009\085\015\009\108\085\107\038\108\124\120\076\009\018\002")
_FE_.Description = _6rq("\093\043\118\054\009\085\015\009\108\085\107\038\108\124\120\076\009\018\002\085\043\108\015\085\046\009\087\018\046\085\015\018\118\054\085\018\108\085\002\009\018\108\009\085\125\018\012\012\009\126\085\054\018\009\076\085\009\076\054\038\009\109\012\002\012\085\015\043\085\074\009\018\012\009\076\009\085\080\108\002\012\076\043\120\012\018\059\108\009\108\092\004\040\022\016\055\018\009\109\085\093\041\038\002\002\092")
_FE_.Visible = true
_FE_.Active = true
_FE_.Complete = false
_FE_.CorrectState = "None"
_lt35e = Wherigo.ZTask(_po7)
_lt35e.Id = "d922cea3-a7ce-485e-b498-ef899d3b3436"
_lt35e.Name = _6rq("\093\043\118\054\009\085\015\009\002\085\086\018\009\012\009\112\038\108\108\009\002\085\083\038\109\046\046\076\043\015\009\076")
_lt35e.Description = _6rq("\058\018\009\085\015\043\085\094\059\108\085\030\002\120\038\076\085\009\076\034\038\054\076\009\108\085\054\038\002\012\126\085\054\009\018\002\002\012\085\015\018\009\002\009\076\085\083\038\109\046\046\076\043\015\009\076\085\019\009\043\086\018\126\085\046\009\087\018\046\085\015\018\118\054\085\038\043\034\085\015\009\108\085\058\009\087\085\124\043\085\018\054\112\092")
_lt35e.Visible = false
_lt35e.Media = _sfSsz
_lt35e.Active = false
_lt35e.Complete = false
_lt35e.CorrectState = "None"
_Jpslm = Wherigo.ZTask(_po7)
_Jpslm.Id = "91bcffa3-0959-490e-a2f6-325cc0f53c92"
_Jpslm.Name = _6rq("\093\043\118\054\009\085\015\009\108\085\051\018\120\059\109\038\018\012\043\076\112")
_Jpslm.Description = _6rq("\086\009\076\085\107\043\076\112\085\038\043\034\085\015\009\112\085\083\059\034\085\015\009\076\085\019\009\043\009\076\074\038\118\054\009\085\018\002\012\085\009\002\085\108\018\118\054\012\092\085\036\111")
_Jpslm.Visible = false
_Jpslm.Active = false
_Jpslm.Complete = false
_Jpslm.CorrectState = "None"
_6BPL = Wherigo.ZTask(_po7)
_6BPL.Id = "022536ec-9214-4aa0-a2e7-5b1dedd4e5e3"
_6BPL.Name = _6rq("\040\009\087\018\046\085\015\018\118\054\085\108\043\108\085\038\043\034\085\015\009\108\085\107\043\076\112\092")
_6BPL.Description = ""
_6BPL.Visible = true
_6BPL.Active = false
_6BPL.Complete = false
_6BPL.CorrectState = "None"
_Bro = Wherigo.ZTask(_po7)
_Bro.Id = "eeda73c9-a329-49c4-b43b-037efe88ba9d"
_Bro.Name = _6rq("\093\118\054\108\009\109\109\085\124\043\112\085\093\118\054\043\109\046\009\076\087")
_Bro.Description = _6rq("\086\043\085\054\038\002\012\085\108\043\076\085\071\085\125\018\108\043\012\009\108\011\011\011")
_Bro.Visible = true
_Bro.Active = false
_Bro.Complete = false
_Bro.CorrectState = "None"

-- Cartridge Variables --
_vdz = _6rq("\049\038")
_GGms = _6rq("\049\038")
_qxO = _6rq("\049\038")
_f_W = _6rq("\057\038")
_ouGq = _6rq("\098\029\029")
_po7.ZVariables = {
	_vdz = _6rq("\049\038"), 
	_GGms = _6rq("\049\038"), 
	_qxO = _6rq("\049\038"), 
	_f_W = _6rq("\057\038"), 
	_ouGq = _6rq("\098\029\029")
}

-- Timers --
_cKV = Wherigo.ZTimer(_po7)
_cKV.Id = "0c833982-91c8-42b6-bc58-b522af6c0292"
_cKV.Name = _6rq("\051\038\112\009")
_cKV.Description = ""
_cKV.Visible = true
_cKV.Duration = 60.9727491889953
_cKV.Type = "Countdown"
_2tQy = Wherigo.ZTimer(_po7)
_2tQy.Id = "973e1cad-fa7e-4701-8492-6d326af8a9a8"
_2tQy.Name = _6rq("\086\018\009\085\056\009\018\012\085\109\038\009\043\034\012\011\011\011")
_2tQy.Description = ""
_2tQy.Visible = true
_2tQy.Duration = 300
_2tQy.Type = "Countdown"

-- Inputs --
_0_0d = Wherigo.ZInput(_po7)
_0_0d.Id = "deebc3f9-5a4e-47db-ab60-5daa9beb3fea"
_0_0d.Name = _6rq("\019\076\038\087\009\030\002\120\038\076")
_0_0d.Description = ""
_0_0d.Visible = true
_0_0d.Media = _mMlzu
_0_0d.InputType = "Text"
_0_0d.Text = _6rq("\125\059\009\118\054\012\009\002\012\085\015\043\085\030\002\120\038\076\085\043\009\046\009\076\085\015\009\108\085\086\018\009\012\009\112\038\108\108\085\043\108\015\085\015\009\002\002\009\108\085\055\009\076\046\109\009\018\046\085\046\009\034\076\038\087\009\108\027")
_VV1 = Wherigo.ZInput(_po7)
_VV1.Id = "71b76a4c-6dcb-4693-871b-a72e8f4183c6"
_VV1.Name = _6rq("\019\076\038\087\009\107\043\076\112")
_VV1.Description = ""
_VV1.Visible = true
_VV1.InputType = "Text"
_VV1.Text = _6rq("\040\018\002\012\085\015\043\085\059\046\009\108\085\038\108\087\009\120\059\112\112\009\108\027\004\040\022\016\004\040\022\016\093\009\018\085\009\054\076\109\018\118\054\092\092\092\085\093\059\108\002\012\085\018\002\012\085\009\002\085\038\043\002\092\092\092\092")
_CIJ = Wherigo.ZInput(_po7)
_CIJ.Id = "351aa55d-f5a8-4bed-8c82-2ce61c11cea6"
_CIJ.Name = _6rq("\019\076\038\087\009\069\059\109\018\124\009\018")
_CIJ.Description = ""
_CIJ.Visible = true
_CIJ.InputType = "Text"
_CIJ.Text = _6rq("\058\038\038\038\038\038\002\027\085\022\009\015\009\108\085\093\018\009\085\112\038\109\085\109\038\043\012\009\076\126\085\018\118\054\085\054\059\009\076\009\085\002\118\054\074\009\076\092\092\092\004\040\022\016\095\038\038\118\054\126\085\093\018\009\085\074\059\109\109\009\108\085\009\012\074\038\002\085\043\009\046\009\076\085\015\009\108\085\086\018\009\012\009\112\038\108\108\085\054\059\009\076\009\108\027\004\040\022\016\093\018\108\015\085\093\018\009\085\015\009\108\108\085\094\059\108\085\015\009\076\085\069\059\109\018\124\009\018\027")
_x9m6 = Wherigo.ZInput(_po7)
_x9m6.Id = "f0d3d181-41ba-4d21-b338-6a6000cad74e"
_x9m6.Name = _6rq("\019\076\038\087\009\107\018\108\120\087\009\109\015")
_x9m6.Description = ""
_x9m6.Visible = true
_x9m6.InputType = "Text"
_x9m6.Text = _6rq("\030\054\054\126\085\009\018\108\085\058\038\118\054\012\112\009\018\002\012\009\076\126\085\057\038\085\038\109\002\059\085\074\009\076\085\015\009\076\085\086\018\009\012\009\112\038\108\108\085\018\002\012\126\085\046\076\038\043\118\054\009\085\018\118\054\085\002\018\118\054\009\076\085\108\018\118\054\012\085\124\043\085\009\076\124\038\009\054\109\009\108\011\085\095\046\009\076\085\074\018\002\002\009\108\085\093\018\009\126\085\018\118\054\085\074\043\009\002\002\012\009\085\015\038\085\002\118\054\059\108\085\009\012\074\038\002\126\085\074\038\002\085\080\054\108\009\108\085\002\018\118\054\009\076\085\074\009\018\012\009\076\054\009\109\034\009\108\085\074\043\009\076\015\009\126\085\038\046\009\076\085\018\118\054\085\038\109\012\009\085\086\038\112\009\126\085\018\118\054\085\054\038\046\085\002\059\085\074\009\108\018\087\085\096\009\109\015\126\085\009\076\054\038\109\012\009\085\018\118\054\085\015\009\108\108\085\034\043\009\076\085\009\018\108\009\108\085\087\043\012\009\108\085\107\018\041\041\085\009\018\108\085\107\076\018\108\120\087\009\109\015\027")
_VSwPZ = Wherigo.ZInput(_po7)
_VSwPZ.Id = "e6e83307-380b-4050-966b-00ac4437820b"
_VSwPZ.Name = _6rq("\019\076\038\087\009\058\018\009\094\018\009\109\107\076\018\108\120\087\009\109\015")
_VSwPZ.Description = ""
_VSwPZ.Visible = true
_VSwPZ.InputType = "Text"
_VSwPZ.Text = _6rq("\051\038\085\015\038\085\054\059\009\076\009\085\018\118\054\085\057\038\085\087\109\009\018\118\054\085\094\018\009\109\085\046\009\002\002\009\076\126\085\074\018\009\094\018\009\109\085\074\059\109\109\009\108\085\093\018\009\085\112\018\076\085\015\009\108\108\085\087\009\046\009\108\027")

-- WorksWithList for object commands --

-- functions --
function _po7:OnStart()
	if (_G[_6rq("\042\108\094")][_6rq("\086\009\094\018\118\009\080\086")] == _6rq("\086\009\002\120\012\059\041")) or (_G[_6rq("\042\108\094")][_6rq("\069\109\038\012\034\059\076\112")] == _6rq("\058\018\108\017\104")) then
		for k, v in pairs(_G[_6rq("\047\041\059\110")][_6rq("\095\109\109\056\030\046\057\009\118\012\002")]) do
			v[_6rq("\055\018\002\018\046\109\009")] = false
			v[_6rq("\095\118\012\018\094\009")] = false
		end
		_G[_6rq("\058\054\009\076\018\087\059")][_6rq("\035\059\112\112\038\108\015")](_6rq("\093\038\094\009\035\109\059\002\009"))
		return
	end
	_cKV[_6rq("\093\012\038\076\012")](_cKV)
end
function _po7:OnRestore()
	_cKV[_6rq("\093\012\038\076\012")](_cKV)
end
function _Wm9:OnEnter()
	_gNK.Active = false
	_gNK.Visible = false
end
function _Wm9:OnExit()
	_Wm9.Visible = false
end
function _O0H:OnEnter()
	_Urwigo.MessageBox{
		Text = _6rq("\086\043\085\046\018\002\012\085\038\109\002\059\085\046\009\076\009\018\012\126\085\043\108\002\085\046\009\018\085\015\009\076\085\093\043\118\054\009\085\108\038\118\054\085\015\009\112\085\086\018\009\012\009\112\038\108\108\126\085\015\009\112\085\058\038\054\076\124\009\018\118\054\009\108\085\015\009\076\085\077\076\009\018\002\002\012\038\015\012\085\042\002\118\054\074\009\087\009\126\085\046\009\054\018\109\034\109\018\118\054\085\124\043\085\002\009\018\108\011\004\040\022\016\004\040\022\016\095\112\085\046\009\002\012\009\108\085\046\009\087\018\046\002\012\085\015\043\085\015\018\118\054\085\038\109\002\085\009\076\002\012\009\002\085\015\059\076\012\054\018\108\126\085\074\059\085\015\009\076\085\086\018\009\012\009\112\038\108\108\085\015\038\002\085\109\009\012\124\012\009\085\125\038\109\085\087\009\002\009\054\009\108\085\074\043\076\015\009\011\004\040\022\016\004\040\022\016\086\038\085\074\018\076\085\054\059\009\076\012\009\108\126\085\015\038\002\002\085\015\043\085\108\009\043\085\018\108\085\015\009\076\085\093\012\038\015\012\085\046\018\002\012\126\085\054\038\046\009\108\085\074\018\076\085\054\018\009\076\085\009\018\108\009\085\120\109\009\018\108\009\085\077\038\076\012\009\085\034\043\009\076\085\015\018\118\054\092"), 
		Media = _mX6A, 
		Buttons = {
			_6rq("\074\009\018\012\009\076\011\011\011")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	_FE_.Complete = true
	_gNK.Active = true
	_gNK.Visible = true
end
function _O0H:OnExit()
	_O0H.Active = false
	_O0H.Visible = false
end
function _lInE:OnEnter()
	_lt35e.Visible = false
	_lt35e.Active = false
end
function _lInE:OnExit()
	_lInE.Active = false
	_lInE.Visible = false
end
function _BLi:OnEnter()
	_Urwigo.MessageBox{
		Text = _6rq("\042\108\015\109\018\118\054\126\085\015\043\085\054\038\002\012\085\015\009\108\085\051\018\120\059\109\038\018\012\043\076\112\085\087\009\034\043\108\015\009\108\011\085\049\009\012\124\012\085\002\059\109\109\012\009\002\012\085\015\043\085\015\018\118\054\085\108\038\118\054\085\059\046\009\108\085\046\009\087\009\046\009\108\085\043\108\015\085\095\043\002\002\118\054\038\043\085\108\038\118\054\085\015\009\112\085\086\018\009\012\009\112\038\108\108\085\054\038\109\012\009\108\011"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.TASKSCREEN)
			end
		end
	}
	_6BPL.Active = true
	_6BPL.Visible = true
	_Jpslm.Visible = false
end
function _BLi:OnExit()
	_BLi.Active = false
	_BLi.Visible = false
end
function _Fm6rD:OnEnter()
	_2tQy:Stop()
end
function _Fm6rD:OnExit()
	_Fm6rD.Active = false
	_Fm6rD.Visible = false
end
function _6Ig4:OnEnter()
	_Fm6rD.Active = false
	_Fm6rD.Visible = false
	_Urwigo.MessageBox{
		Text = _6rq("\086\043\085\046\009\034\018\108\015\009\002\012\085\015\018\118\054\085\108\043\108\085\038\108\085\015\009\076\085\042\002\118\054\074\009\087\009\076\085\125\038\076\120\012\120\018\076\118\054\009\126\085\054\018\009\076\085\112\043\002\002\085\018\076\087\009\108\015\074\059\085\042\112\112\038\126\085\015\018\009\085\034\109\009\018\002\118\054\087\009\074\059\076\015\009\108\009\085\040\018\109\015\124\009\018\012\043\108\087\085\002\009\018\108\011\085\004\040\022\016\019\076\038\087\085\002\018\009\085\015\059\118\054\085\112\038\109\126\085\074\038\002\085\002\018\009\085\124\043\085\009\076\124\038\009\054\109\009\108\085\054\038\012\011\085\004\040\022\016\004\040\022\016\095\118\054\057\038\126\085\002\059\109\109\012\009\002\012\085\015\043\085\108\059\118\054\085\038\108\015\009\076\009\085\125\009\108\002\118\054\009\108\085\012\076\009\034\034\009\108\126\085\015\009\108\120\085\015\076\038\108\126\085\019\076\038\087\009\108\085\120\059\002\012\009\012\085\108\018\118\054\012\002\092"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _6Ig4:OnExit()
	_6Ig4.Active = false
	_6Ig4.Visible = false
	_Urwigo.MessageBox{
		Text = _6rq("\093\018\009\085\054\038\046\009\108\085\069\059\002\012\092"), 
		Media = _WxWjz, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _6rq("\083\038\109\109\059\126\085\015\038\002\085\107\043\118\054\126\085\074\009\109\118\054\009\002\085\093\018\009\085\043\108\002\085\124\043\076\085\095\108\038\109\091\002\009\085\043\009\046\009\076\087\009\046\009\108\085\054\038\046\009\108\126\085\054\038\046\009\108\085\074\018\076\085\087\076\043\009\108\015\109\018\118\054\085\043\108\012\009\076\002\043\118\054\012\011\085\004\040\022\016\042\002\085\002\018\108\015\085\120\009\018\108\009\085\022\043\009\118\120\002\012\038\009\108\015\009\085\094\059\108\085\035\054\109\059\076\059\041\054\059\076\112\085\059\015\009\076\085\038\009\054\108\109\018\118\054\009\112\085\124\043\085\034\018\108\015\009\108\011\085\004\040\022\016\121\009\015\018\087\109\018\118\054\085\086\051\095\085\093\041\043\076\009\108\085\015\009\002\085\086\018\009\012\009\112\038\108\108\009\002\085\054\038\046\009\108\085\074\018\076\085\034\018\108\015\009\108\085\120\059\009\108\108\009\108\011\004\040\022\016\004\040\022\016\055\018\009\109\085\096\109\043\118\120\085\046\009\018\085\080\054\076\009\076\085\074\009\018\012\009\076\009\108\085\093\043\118\054\009\092\004\040\022\016\004\040\022\016\086\038\002\085\107\009\038\112\085\094\059\112\085\121\038\046\059\076\092"), 
					Callback = function(action)
						if action ~= nil then
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					end
				}
			end
		end
	}
end
function _Br3_a:OnEnter()
	_Urwigo.MessageBox{
		Text = _6rq("\086\043\085\046\018\002\012\085\108\043\108\085\038\108\085\015\009\076\085\040\076\038\043\009\076\009\018\085\038\108\087\009\120\059\112\112\009\108\011\085\004\040\022\016\083\018\009\076\085\018\108\085\015\009\076\085\077\038\041\009\109\109\009\085\015\009\076\085\040\076\038\043\009\076\009\018\085\009\108\015\009\108\085\015\018\009\085\040\076\038\043\009\076\009\018\046\009\002\018\118\054\012\018\087\043\108\087\009\108\085\112\018\012\085\015\009\076\085\055\059\109\109\094\009\076\041\034\109\009\087\043\108\087\085\015\009\076\085\096\038\009\002\012\009\011\085\004\040\022\016\106\108\015\085\055\059\109\109\094\009\076\041\034\109\009\087\043\108\087\085\018\002\012\085\059\034\012\112\038\109\002\085\074\059\009\076\012\109\018\118\054\085\124\043\085\108\009\054\112\009\108\011\004\040\022\016\004\040\022\016\093\118\054\038\043\085\015\018\118\054\085\043\112\126\085\094\018\009\109\109\009\018\118\054\012\085\074\018\076\002\012\085\015\043\085\054\018\009\076\085\057\038\085\034\043\009\108\015\018\087\011\011\011"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _Br3_a:OnExit()
	_Br3_a.Visible = false
end
function _1b800:OnEnter()
	_Urwigo.MessageBox{
		Text = _6rq("\049\009\012\124\012\085\054\038\002\012\085\015\043\085\009\002\085\034\038\002\012\085\087\009\002\118\054\038\034\034\012\126\085\054\018\109\034\085\015\009\112\085\086\018\009\012\009\112\038\108\108\085\108\043\108\085\108\059\118\054\085\002\118\054\108\009\109\109\085\002\009\018\108\009\085\107\076\059\009\012\009\085\124\043\085\034\018\108\015\009\108\011\085\004\040\022\016\004\040\022\016\040\009\087\018\046\085\015\018\118\054\085\015\038\124\043\085\018\108\085\015\018\009\085\059\046\009\076\002\012\009\085\042\012\038\087\009\011\085\004\040\022\016\004\040\022\016\106\108\015\085\046\009\038\118\054\012\009\085\015\038\002\085\093\041\059\018\109\009\076\034\059\012\059\092\004\040\022\016\004\040\022\016\086\009\018\108\009\108\085\106\108\109\059\118\120\085\035\059\015\009\085\009\076\054\038\009\109\012\002\012\085\015\043\085\046\009\018\112\085\055\009\076\109\038\002\002\009\108\085\015\009\002\085\069\038\076\120\054\038\043\002\009\002\092"), 
		Callback = function(action)
			if action ~= nil then
				_ttf:MoveTo(Player)
				Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
			end
		end
	}
end
function _1b800:OnExit()
	_Urwigo.OldDialog{
		{
			Text = _6rq("\086\043\085\074\038\076\002\012\085\009\076\034\059\109\087\076\009\018\118\054\085\046\009\018\085\015\009\076\085\093\043\118\054\009\085\015\009\002\085\086\018\009\012\009\112\038\108\108\009\002\085\002\059\074\018\009\085\002\009\018\108\009\076\085\107\076\059\009\012\009\011\004\040\022\016\004\040\022\016\086\038\034\043\009\076\085\002\059\109\109\002\012\085\015\043\085\112\018\012\085\015\009\018\108\009\112\085\041\009\076\002\059\009\108\109\018\118\054\009\108\085\106\108\109\059\118\120\085\035\059\015\009\085\046\009\109\054\059\108\012\085\074\009\076\015\009\108\011\004\040\022\016\004\040\022\016\019\059\043\108\015\085\121\059\087\002\085\059\054\108\009\085\009\108\012\002\041\076\009\118\054\009\108\015\009\108\085\106\108\109\059\118\120\085\015\009\076\085\035\038\076\012\018\015\087\009\085\038\043\034\085\058\054\009\076\018\087\059\085\074\009\076\015\009\108\085\087\009\109\059\002\118\054\012\092")
		}, 
		{
			Text = string.sub(Player.CompletionCode, 1, 15)
		}
	}
end
function _gNK:OnClick()
	_Wm9.Active = true
	_Wm9.Visible = true
	_Urwigo.MessageBox{
		Text = _6rq("\040\009\087\018\046\085\015\018\118\054\085\108\043\108\085\124\043\112\085\093\118\054\109\059\002\002\012\043\076\112\126\085\043\112\085\108\038\118\054\085\083\018\108\074\009\018\002\009\108\085\124\043\085\002\043\118\054\009\108\126\085\015\018\009\085\034\043\076\085\015\038\002\085\095\043\034\034\018\108\015\009\108\085\015\009\002\085\086\018\009\012\009\112\038\108\108\009\002\085\054\018\109\034\076\009\018\118\054\085\002\009\018\108\085\120\059\108\108\012\009\108\011\085\086\043\085\034\018\108\015\009\002\012\085\015\009\108\085\058\009\087\085\124\043\112\085\093\118\054\109\059\002\002\012\043\076\112\085\038\043\034\085\015\009\076\085\077\038\076\012\009\085\002\059\074\018\009\085\018\108\085\015\009\018\108\009\108\085\121\059\118\038\012\018\059\108\002\092"), 
		Buttons = {
			_6rq("\030\077")
		}
	}
end
function _FE_:OnSetComplete()
	_FE_.Active = false
end
function _FE_:OnClick()
	_Urwigo.MessageBox{
		Text = _FE_.Description
	}
	_O0H.Active = true
	_O0H.Visible = true
end
function _lt35e:OnClick()
	_Urwigo.MessageBox{
		Text = _lt35e.Description, 
		Media = _sfSsz
	}
	_lInE.Active = true
	_lInE.Visible = true
end
function _Jpslm:OnClick()
	_Urwigo.MessageBox{
		Text = _Jpslm.Description
	}
	_BLi.Active = true
	_BLi.Visible = true
end
function _6BPL:OnClick()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_VV1)
	end)
end
function _0_0d:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(_vdz, input) then
		_Urwigo.MessageBox{
			Text = _6rq("\095\118\054\085\074\009\018\002\002\012\085\015\043\011\011\011\085\004\040\022\016\004\040\022\016\011\011\011\043\009\046\009\076\085\015\009\108\085\087\043\012\009\108\085\038\109\012\009\108\085\086\018\009\012\009\112\038\108\108\085\120\059\009\108\108\012\009\085\018\118\054\085\015\018\076\085\002\059\059\059\059\059\059\085\094\018\009\109\085\009\076\124\038\054\109\009\108\126\085\038\046\009\076\085\015\038\124\043\085\054\038\046\009\085\018\118\054\085\054\009\043\012\009\085\109\009\018\015\009\076\085\087\038\076\085\120\009\018\108\009\085\056\009\018\012\011\085\004\040\022\016\004\040\022\016\055\018\009\109\109\009\018\118\054\012\085\034\076\038\087\002\012\085\015\043\085\112\038\109\085\002\009\018\108\009\108\085\083\038\109\046\046\076\043\015\009\076\126\085\015\009\076\085\054\009\018\002\002\012\085\019\009\043\015\018\126\085\009\076\085\054\038\009\109\012\085\002\018\118\054\085\112\009\018\002\012\085\018\108\085\015\009\076\085\040\018\002\112\038\076\118\120\002\012\076\038\002\002\009\085\038\043\034\011\085\004\040\022\016\004\040\022\016\055\018\009\109\109\009\018\118\054\012\085\120\038\108\108\085\015\009\076\085\015\018\076\085\057\038\085\074\009\018\012\009\076\054\009\109\034\009\108\092"), 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
		_lt35e.Active = true
		_lt35e.Visible = true
	else
		_Urwigo.MessageBox{
			Text = _6rq("\051\038\085\015\043\085\112\043\002\002\012\085\015\018\118\054\085\002\118\054\059\108\085\009\018\108\085\046\018\002\002\118\054\009\108\085\046\009\002\002\009\076\085\043\112\054\059\009\076\009\108\085\043\112\085\038\043\034\085\015\018\009\085\093\041\043\076\085\015\009\002\085\086\018\009\012\009\112\038\108\108\009\002\085\124\043\085\120\059\112\112\009\108\011\085\004\040\022\016\004\040\022\016\077\009\018\108\009\085\093\118\054\009\043\126\085\015\018\009\085\042\002\118\054\074\009\087\009\076\085\046\009\018\002\002\009\108\085\015\059\118\054\085\108\018\118\054\012\011\085\004\040\022\016\004\040\022\016\051\038\057\038\085\124\043\112\018\108\015\009\002\012\085\108\018\118\054\012\085\038\109\109\009\085\036\111"), 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _VV1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(_GGms, input) then
		_Urwigo.MessageBox{
			Text = _6rq("\093\018\009\054\002\012\085\015\043\085\038\043\118\054\126\085\074\038\002\085\018\118\054\085\002\009\054\009\027\004\040\022\016\004\040\022\016\080\108\085\022\018\118\054\012\043\108\087\085\051\059\076\015\085\030\002\012\126\085\015\038\085\059\046\009\108\085\038\043\034\085\015\009\112\085\083\043\009\087\009\109\126\085\015\009\112\085\002\059\087\009\108\038\108\108\012\009\108\085\093\118\054\043\109\046\009\076\087\126\085\015\038\085\002\118\054\109\009\018\034\009\108\085\124\074\009\018\085\125\038\009\108\108\009\076\085\009\018\108\009\108\085\087\076\059\002\002\009\108\085\093\038\118\120\085\054\018\108\012\009\076\085\002\018\118\054\085\054\009\076\011\085\004\040\022\016\004\040\022\016\083\038\046\009\108\085\002\018\009\085\015\009\108\085\086\018\009\012\009\112\038\108\108\085\009\108\012\034\043\009\054\076\012\027\004\040\022\016\004\040\022\016\040\009\009\018\109\085\015\018\118\054\085\015\059\076\012\085\054\018\108\085\124\043\085\120\059\112\112\009\108\011\004\040\022\016\004\040\022\016\086\018\009\085\056\009\018\012\085\109\038\009\043\034\012\011\011\011\011"), 
			Buttons = {
				_6rq("\074\009\018\012\009\076\011\011\011")
			}, 
			Callback = function(action)
				if action ~= nil then
					_2tQy:Start()
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _6rq("\030\077\126\085\018\118\054\085\054\059\034\034\009\085\009\002\085\109\018\009\087\012\085\015\038\076\038\108\126\085\015\038\002\002\085\015\009\076\085\107\043\076\112\085\087\009\002\118\054\109\059\002\002\009\108\085\018\002\012\126\085\038\108\002\059\108\002\012\009\108\085\054\038\002\012\085\015\043\085\069\009\118\054\085\087\009\054\038\046\012\126\085\094\059\108\085\015\038\085\059\046\009\108\085\054\038\009\012\012\009\002\012\085\015\043\085\009\018\108\009\108\085\002\043\041\009\076\085\095\043\002\046\109\018\118\120\085\087\009\054\038\046\012\092\004\040\022\016\004\040\022\016\095\046\009\076\126\085\015\038\085\015\038\002\085\094\009\076\112\043\012\109\018\118\054\085\108\018\118\054\012\085\124\043\085\094\009\076\112\009\018\015\009\108\085\074\038\076\126\085\054\018\009\076\085\009\018\108\009\085\080\108\034\059\001\004\040\022\016\004\040\022\016\080\108\085\022\018\118\054\012\043\108\087\085\051\059\076\015\085\030\002\012\126\085\015\038\085\059\046\009\108\085\038\043\034\085\015\009\112\085\083\043\009\087\009\109\126\085\015\009\112\085\002\059\087\009\108\038\108\108\012\009\108\085\093\118\054\043\109\046\009\076\087\126\085\015\038\085\002\118\054\109\009\018\034\009\108\085\124\074\009\018\085\125\038\009\108\108\009\076\085\009\018\108\009\108\085\087\076\059\002\002\009\108\085\093\038\118\120\085\054\018\108\012\009\076\085\002\018\118\054\085\054\009\076\011\085\004\040\022\016\004\040\022\016\083\038\046\009\108\085\002\018\009\085\015\009\108\085\086\018\009\012\009\112\038\108\108\085\009\108\012\034\043\009\054\076\012\027\004\040\022\016\004\040\022\016\040\009\009\018\109\085\015\018\118\054\085\015\059\076\012\085\054\018\108\085\124\043\085\120\059\112\112\009\108\011\004\040\022\016\004\040\022\016\086\018\009\085\056\009\018\012\085\109\038\009\043\034\012\011\011\011\011"), 
			Buttons = {
				_6rq("\074\009\018\012\009\076\011\011\011")
			}, 
			Callback = function(action)
				if action ~= nil then
					_2tQy:Start()
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _CIJ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(_qxO, input) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_x9m6)
		end)
	else
		_Urwigo.MessageBox{
			Text = _6rq("\051\038\085\015\038\108\108\085\120\038\108\108\085\018\118\054\085\108\043\076\085\009\018\108\085\046\018\002\002\118\054\009\108\085\012\076\038\009\109\109\009\076\108\001\004\040\022\016\004\040\022\016\042\018\108\085\093\012\038\009\015\012\109\009\018\108\085\109\018\009\087\012\085\038\112\085\058\009\076\076\038\002\012\076\038\108\015\126\004\040\022\016\038\112\085\058\009\076\076\038\002\012\076\038\108\015\126\085\038\112\085\058\009\076\076\038\002\012\076\038\108\015\126\004\040\022\016\015\038\085\046\109\038\009\002\012\085\009\018\108\085\125\038\108\108\085\094\059\112\085\107\043\076\112\085\018\108\002\085\121\038\108\015\126\004\040\022\016\009\018\108\085\125\038\009\108\108\109\009\018\108\085\046\109\038\009\002\012\085\018\108\002\085\121\038\108\015\036\004\040\022\016\043\108\015\085\074\009\018\109\085\009\076\085\002\059\085\002\118\054\059\009\108\085\046\109\038\002\009\108\085\120\038\108\108\126\004\040\022\016\015\076\043\112\085\108\009\108\108\012\085\112\038\108\085\018\054\108\085\015\009\108\085\086\018\009\012\009\112\038\108\108\126\004\040\022\016\015\076\043\112\085\108\009\108\108\012\085\112\038\108\085\018\054\108\085\015\009\108\085\086\018\009\012\009\112\038\108\108\126\004\040\022\016\015\009\108\085\086\018\009\012\009\060\086\018\009\012\009\112\038\108\108\011\004\040\022\016\004\040\022\016\080\118\054\085\124\059\087\085\043\112\054\009\076\085\015\018\009\085\077\076\009\043\124\085\043\108\015\085\005\043\009\076\126\004\040\022\016\015\018\009\085\077\076\009\043\124\085\043\108\015\085\005\043\009\076\126\085\015\018\009\085\077\076\009\043\124\085\043\108\015\085\005\043\009\076\126\004\040\022\016\112\038\108\085\034\076\038\087\012\126\085\074\059\085\018\118\054\085\124\043\085\083\038\043\002\009\085\074\038\009\076\023\126\004\040\022\016\074\059\085\018\118\054\085\124\043\085\083\038\043\002\009\085\074\038\009\076\023\027\004\040\022\016\058\059\054\109\038\108\126\085\018\054\076\085\109\018\009\046\009\108\085\121\009\043\012\009\126\085\002\009\054\012\126\004\040\022\016\074\059\023\002\085\125\038\009\108\108\109\009\018\108\085\038\043\034\085\015\009\112\085\107\043\076\112\009\085\002\012\009\054\012\126\004\040\022\016\074\059\023\002\085\125\038\009\108\108\109\009\018\108\085\038\043\034\085\015\009\112\085\107\043\076\112\009\085\002\012\009\054\012\126\004\040\022\016\057\038\085\038\043\034\085\015\009\112\085\107\043\076\112\009\085\002\012\009\054\012\011\004\040\022\016\004\040\022\016\086\038\085\002\041\076\038\118\054\009\108\085\002\018\009\085\112\018\012\085\038\076\087\009\076\085\121\018\002\012\126\004\040\022\016\112\018\012\085\038\076\087\009\076\085\121\018\002\012\126\085\112\018\012\085\038\076\087\009\076\085\121\018\002\012\001\004\040\022\016\025\051\043\108\085\074\018\002\002\009\108\085\074\018\076\126\085\074\009\076\085\015\043\085\015\059\118\054\085\046\018\002\012\126\004\040\022\016\074\018\076\085\074\018\002\002\009\108\126\085\074\009\076\085\015\043\085\046\018\002\012\092\004\040\022\016\015\043\085\046\018\002\012\126\085\074\018\076\085\002\038\054\009\108\023\002\085\087\109\009\018\118\054\085\015\018\076\085\038\108\126\004\040\022\016\015\043\085\046\018\002\012\085\009\018\108\085\076\009\118\054\012\009\076\085\086\018\009\012\009\112\038\108\108\126\004\040\022\016\015\043\085\046\018\002\012\085\009\018\108\085\076\009\118\054\012\009\076\085\086\018\009\012\009\112\038\108\108\126\004\040\022\016\009\018\108\085\076\009\118\054\012\009\076\085\086\018\009\012\009\112\038\108\108\092\025\004\040\022\016\004\040\022\016\125\018\076\085\018\002\012\085\009\002\085\087\109\009\018\118\054\126\085\074\018\009\085\018\054\076\085\112\018\118\054\085\108\009\108\108\012\126\004\040\022\016\074\018\009\085\018\054\076\085\112\018\118\054\085\108\009\108\108\012\126\085\074\018\009\085\018\054\076\085\112\018\118\054\085\108\009\108\108\012\126\004\040\022\016\112\018\118\054\085\034\076\009\043\012\023\002\126\085\015\038\002\002\085\018\054\076\085\015\038\002\085\125\038\009\108\108\109\009\018\108\085\120\009\108\108\012\126\004\040\022\016\015\038\002\002\085\018\054\076\085\015\038\002\085\125\038\009\108\108\109\009\018\108\085\120\009\108\108\012\011\004\040\022\016\086\059\076\012\126\085\074\059\085\009\002\085\012\043\012\009\012\085\093\012\043\108\015\023\085\043\112\085\093\012\043\108\015\023\004\040\022\016\015\009\054\108\012\085\002\018\118\054\085\015\009\076\085\012\076\038\043\012\009\108\085\083\009\018\112\038\012\085\096\076\043\108\015\126\004\040\022\016\015\009\054\108\012\085\002\018\118\054\085\015\009\076\085\012\076\038\043\012\009\108\085\083\009\018\112\038\012\085\096\076\043\108\015\126\004\040\022\016\015\009\076\085\012\076\038\043\012\009\108\085\083\009\018\112\038\012\085\096\076\043\108\015\011\004\040\022\016\004\040\022\016\106\108\015\085\002\059\109\109\012\023\085\018\118\054\085\009\018\108\002\012\085\087\009\002\012\059\076\046\009\108\085\002\009\018\108\126\004\040\022\016\087\009\002\012\059\076\046\009\108\085\002\009\018\108\126\085\087\009\002\012\059\076\046\009\108\085\002\009\018\108\126\004\040\022\016\109\009\087\012\085\112\018\118\054\085\018\108\085\009\018\108\009\108\085\042\002\118\054\009\108\054\038\018\108\126\004\040\022\016\018\108\085\009\018\108\009\108\085\042\002\118\054\009\108\054\038\018\108\092\004\040\022\016\093\118\054\076\009\018\046\012\085\038\108\085\015\009\108\085\093\012\009\018\108\085\015\018\009\085\080\108\002\118\054\076\018\034\012\085\038\108\001\004\040\022\016\083\018\009\076\085\076\043\054\012\085\009\018\108\085\076\009\118\054\012\009\076\085\086\018\009\012\009\112\038\108\108\126\004\040\022\016\054\018\009\076\085\076\043\054\012\085\009\018\108\085\076\009\118\054\012\009\076\085\086\018\009\012\009\112\038\108\108\126\004\040\022\016\009\018\108\085\076\009\118\054\012\009\076\085\086\018\009\012\009\112\038\108\108\011\004\040\022\016\004\040\022\016\093\059\085\080\118\054\085\112\043\002\002\085\057\009\012\124\012\085\074\009\087\092")
		}
	end
end
function _x9m6:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(_f_W, input) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_VSwPZ)
		end)
	else
		_Urwigo.MessageBox{
			Text = _6rq("\080\118\054\085\009\076\124\038\009\054\109\009\085\074\038\002\085\043\108\015\085\046\009\120\059\112\112\009\085\108\018\118\054\012\002\027\004\040\022\016\004\040\022\016\055\009\076\041\018\002\002\085\015\018\118\054\085\040\043\109\109\009\092\092\092"), 
			Media = _0IAa
		}
	end
end
function _VSwPZ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(_ouGq, input) then
		_Urwigo.MessageBox{
			Text = _6rq("\083\009\076\085\112\018\012\085\015\009\112\085\096\009\109\015\126\085\038\046\009\076\085\015\038\109\109\018\126\085\009\076\002\012\085\015\009\076\085\056\038\002\012\009\076\126\085\015\038\108\108\085\015\018\009\085\095\043\002\120\043\108\034\012\011\011\011\011\011\004\040\022\016\004\040\022\016\004\040\022\016\004\040\022\016\004\040\022\016\004\040\022\016\004\040\022\016\004\040\022\016\095\109\002\059\011\011\011\004\040\022\016\004\040\022\016\011\011\011\018\118\054\085\054\038\046\009\085\087\009\054\059\009\076\012\126\085\015\038\002\002\085\015\038\085\094\059\076\054\018\108\085\057\009\112\038\108\015\085\046\009\018\085\043\108\002\009\076\009\112\085\040\043\009\076\087\009\076\112\009\018\002\012\009\076\085\074\038\076\085\043\108\015\085\018\054\112\085\009\076\124\038\009\054\109\012\085\054\038\012\126\085\074\018\009\085\009\076\085\015\009\108\085\086\018\009\012\009\112\038\108\108\085\034\018\108\015\009\108\085\120\038\108\108\011\085\004\040\022\016\004\040\022\016\080\118\054\085\094\009\076\112\043\012\009\085\112\038\109\126\085\009\002\085\074\038\076\085\009\018\108\085\042\076\041\076\009\002\002\009\076\011\004\040\022\016\004\040\022\016\095\046\009\076\085\012\043\012\085\112\018\076\085\109\009\018\015\126\085\112\009\054\076\085\074\009\018\002\002\085\018\118\054\085\108\018\118\054\012\011\004\040\022\016\004\040\022\016\004\040\022\016\080\118\054\085\112\043\002\002\085\057\009\012\124\012\085\038\043\118\054\085\109\059\002\126\085\018\118\054\085\054\038\046\009\085\087\109\009\018\118\054\085\009\018\108\085\086\038\012\009\085\018\108\085\015\009\076\085\093\041\018\009\109\059\012\054\009\120\126\085\038\118\054\057\038\085\015\038\108\120\009\085\034\043\076\085\015\009\108\085\056\038\002\012\009\076\092"), 
			Callback = function(action)
				if action ~= nil then
					_nEn.Active = true
					_nEn.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _6rq("\086\038\034\043\009\076\085\015\038\076\034\002\012\085\015\043\085\112\018\118\054\085\009\018\087\009\108\012\109\018\118\054\085\108\018\118\054\012\085\112\038\109\085\038\108\002\041\076\009\118\054\009\108\126\085\054\038\043\085\038\046\092"), 
			Media = _0IAa, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _cKV:OnTick()
	if _G[_6rq("\069\109\038\091\009\076")][_6rq("\069\059\002\018\012\018\059\108\095\118\118\043\076\038\118\091")][_6rq("\096\009\012\055\038\109\043\009")](_G[_6rq("\069\109\038\091\009\076")][_6rq("\069\059\002\018\012\018\059\108\095\118\118\043\076\038\118\091")], _6rq("\112")) == 3 then
		for k, v in pairs(_G[_6rq("\047\041\059\110")][_6rq("\095\109\109\056\030\046\057\009\118\012\002")]) do
			v[_6rq("\055\018\002\018\046\109\009")] = false
			v[_6rq("\095\118\012\018\094\009")] = false
		end
		_G[_6rq("\058\054\009\076\018\087\059")][_6rq("\035\059\112\112\038\108\015")](_6rq("\093\038\094\009\035\109\059\002\009"))
		return
	end
end
function _2tQy:OnStart()
	_Urwigo.MessageBox{
		Text = _6rq("\086\043\085\054\038\002\012\085\108\043\108\085\071\085\125\018\108\043\012\009\108\085\043\112\085\015\009\108\085\093\118\054\043\109\046\009\076\087\085\124\043\085\009\076\076\009\018\118\054\009\108\011\004\040\022\016\004\040\022\016\086\018\009\085\056\009\018\012\085\121\038\009\043\034\012\092"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	_Fm6rD.Active = true
	_Fm6rD.Visible = true
	_Bro.Visible = true
	_Bro.Active = true
	_6BPL.Visible = false
end
function _2tQy:OnStop()
	_Bro.Visible = false
	_Urwigo.MessageBox{
		Text = _6rq("\086\043\085\054\038\002\012\085\009\002\085\087\009\002\118\054\038\034\034\012\085\043\108\015\085\015\018\118\054\085\074\038\054\076\109\018\118\054\085\046\009\009\018\109\012\126\085\038\046\009\076\085\015\018\009\085\046\009\002\038\087\012\009\108\085\125\038\009\108\108\009\076\085\002\018\108\015\085\108\018\118\054\012\085\112\009\054\076\085\124\043\085\002\009\054\009\108\011\085\004\040\022\016\004\040\022\016\055\009\076\015\038\112\112\012\092\004\040\022\016\004\040\022\016\095\046\009\076\085\046\009\018\085\087\009\108\038\043\009\076\009\076\085\093\043\118\054\009\085\034\018\108\015\009\002\012\085\015\043\085\009\018\108\085\077\109\009\018\015\043\108\087\002\002\012\043\009\118\120\126\085\018\002\012\085\015\038\002\085\094\018\009\109\109\009\018\118\054\012\085\094\059\112\085\086\018\009\012\009\112\038\108\108\027\085\004\040\022\016\004\040\022\016\093\118\054\038\043\085\009\002\085\015\018\076\085\038\108\092"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _2tQy:OnTick()
	_Fm6rD.Visible = false
	_Fm6rD.Active = false
	_BLi.Active = true
	_BLi.Visible = true
	_Bro.Visible = false
	_Urwigo.MessageBox{
		Text = _6rq("\058\038\002\085\018\002\012\085\041\038\002\002\018\009\076\012\027\085\083\038\012\085\112\038\108\085\015\018\076\085\038\043\034\085\015\009\112\085\058\009\087\085\015\018\009\085\093\118\054\043\054\009\085\046\009\002\059\054\109\012\027\004\040\022\016\086\043\085\074\038\076\002\012\085\124\043\085\109\038\108\087\002\038\112\011\085\049\009\012\124\012\085\112\043\002\002\012\085\015\043\085\109\009\018\015\009\076\085\094\059\108\085\094\059\076\108\085\038\108\034\038\108\087\009\108\092"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _6rq("\086\038\002\085\074\038\076\085\108\038\012\043\009\076\109\018\118\054\085\009\018\108\085\093\118\054\009\076\124\126\085\002\059\059\059\059\085\087\009\112\009\018\108\085\074\059\109\109\009\108\085\074\018\076\085\112\038\109\085\108\018\118\054\012\085\002\009\018\108\011\085\004\040\022\016\004\040\022\016\095\046\009\076\085\009\018\108\009\085\120\109\009\018\108\009\085\093\012\076\038\034\009\085\112\043\002\002\012\085\015\043\085\002\118\054\059\108\085\018\108\085\077\038\043\034\085\108\009\054\112\009\108\092\004\040\022\016\004\040\022\016\096\009\054\009\085\124\043\076\043\009\118\120\085\124\043\112\085\051\018\120\059\109\038\018\012\043\076\112\085\043\108\015\085\094\009\076\002\043\118\054\009\085\015\018\009\002\112\038\109\085\018\108\085\015\009\076\085\056\009\018\012\085\124\043\085\046\109\009\018\046\009\108\092"), 
					Callback = function(action)
						if action ~= nil then
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					end
				}
			end
		end
	}
end
function _tOPq:OnClick()
	_Urwigo.MessageBox{
		Text = _6rq("\086\038\002\085\046\018\002\012\085\015\043\092"), 
		Media = _cfT, 
		Buttons = {
			_6rq("\038\054\038\011\011\011")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _EYsPd:OnClick()
	_Urwigo.MessageBox{
		Text = _6rq("\083\038\109\109\059\126\085\093\018\009\085\074\059\109\109\009\108\085\038\109\002\059\085\046\009\018\085\015\009\076\085\093\043\118\054\009\085\112\009\018\108\009\002\085\083\038\109\046\046\076\043\015\009\076\002\085\046\009\054\018\109\034\109\018\118\054\085\002\009\018\108\027\004\040\022\016\004\040\022\016\086\038\085\054\038\046\009\108\085\093\018\009\085\002\018\118\054\085\038\046\009\076\085\087\038\108\124\085\002\118\054\059\009\108\085\074\038\002\085\094\059\076\087\009\108\059\112\112\009\108\092\004\040\022\016\004\040\022\016\080\118\054\085\120\038\108\108\085\080\054\108\009\108\085\109\009\018\015\009\076\085\124\043\112\085\055\009\076\046\109\009\018\046\085\015\009\002\085\086\018\009\012\009\112\038\108\108\009\002\085\038\043\118\054\085\120\009\018\108\009\085\095\108\087\038\046\009\108\085\112\038\118\054\009\108\011\004\040\022\016\080\118\054\085\054\038\009\012\012\009\085\054\018\009\076\085\038\109\109\009\076\015\018\108\087\002\085\009\018\108\085\019\059\012\059\085\094\059\108\085\018\054\112\126\085\074\009\108\108\085\093\018\009\085\112\059\009\118\054\012\009\108\126\085\120\059\009\108\108\009\108\085\093\018\009\085\009\002\085\054\038\046\009\108\092\004\040\022\016\004\040\022\016\058\018\009\085\093\018\009\085\002\009\054\009\108\126\085\120\038\108\108\085\018\118\054\085\054\018\009\076\085\038\043\118\054\085\108\018\118\054\012\085\074\009\087\126\085\018\118\054\085\120\038\108\108\085\038\109\002\059\085\046\009\018\085\015\009\076\085\093\043\118\054\009\085\108\018\118\054\012\085\038\120\012\018\094\085\046\009\054\018\109\034\109\018\118\054\085\002\009\018\108\011\085\004\040\022\016\004\040\022\016\058\009\108\108\085\018\118\054\085\057\009\015\059\118\054\085\120\059\009\108\108\012\009\126\085\015\038\108\108\085\074\043\009\076\015\009\085\018\118\054\085\009\018\108\009\108\085\040\109\018\118\120\085\094\059\112\085\108\038\054\009\108\085\051\018\120\059\109\038\018\012\043\076\112\085\074\009\076\034\009\108\126\085\094\018\009\109\109\009\018\118\054\012\085\018\002\012\085\015\038\085\057\038\085\009\012\074\038\002\085\124\043\085\002\009\054\009\108\092"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	_oOVKu.Visible = true
	_Jpslm.Visible = true
	_Jpslm.Active = true
end
function _IgAz:OnClick()
	_Urwigo.MessageBox{
		Text = _6rq("\080\118\054\085\120\038\108\108\085\018\112\085\093\038\118\054\009\108\085\086\018\009\012\009\112\038\108\108\085\120\009\018\108\009\085\095\043\002\002\038\087\009\108\085\012\076\009\034\034\009\108\126\085\046\018\012\012\009\085\094\009\076\002\012\009\054\009\108\085\093\018\009\126\085\015\038\002\002\085\112\018\076\085\054\018\009\076\085\015\018\009\085\083\038\009\108\015\009\085\087\009\046\043\108\015\009\108\085\002\018\108\015\092\004\040\022\016\004\040\022\016\019\076\038\087\009\108\085\093\018\009\085\015\059\118\054\085\015\009\108\085\019\009\043\086\018\126\085\015\038\002\085\018\002\012\085\015\009\076\085\083\038\109\046\046\076\043\015\009\076\085\015\009\002\085\086\018\009\012\009\112\038\108\108\009\002\126\085\015\009\076\085\120\038\108\108\085\018\054\108\009\108\085\094\018\009\109\109\009\018\118\054\012\085\054\009\109\034\009\108\011"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _va78M:OnClick()
	_Urwigo.MessageBox{
		Text = _6rq("\083\038\109\109\059\085\019\076\009\112\015\009\076\126\085\015\043\085\112\059\009\118\054\012\009\002\012\085\087\009\076\108\085\074\018\002\002\009\108\126\085\074\009\076\085\015\018\009\085\125\038\009\108\108\009\076\085\094\059\076\054\018\108\085\112\018\012\085\015\009\112\085\087\076\059\002\002\009\108\085\093\038\118\120\085\074\038\076\009\108\027\004\040\022\016\004\040\022\016\086\038\002\085\074\038\076\009\108\085\015\018\009\085\121\043\112\041\009\108\002\038\112\112\109\009\076\126\085\015\018\009\085\120\059\112\112\009\108\085\038\109\109\009\085\041\038\038\076\085\058\059\118\054\009\108\085\112\038\109\085\054\018\009\076\085\094\059\076\046\009\018\085\043\108\015\085\002\038\112\112\009\109\108\085\038\109\012\009\085\121\043\112\041\009\108\085\009\018\108\011\004\040\022\016\125\009\054\076\085\120\038\108\108\085\018\118\054\085\015\018\076\085\124\043\085\015\009\108\009\108\085\109\009\018\015\009\076\085\108\018\118\054\012\085\002\038\087\009\108\011\085\004\040\022\016\004\040\022\016\095\046\009\076\085\094\018\009\109\109\009\018\118\054\012\085\034\076\038\087\002\012\085\015\043\085\112\038\109\085\043\108\002\009\076\009\085\034\109\009\018\002\118\054\087\009\074\059\076\015\009\108\009\085\040\018\109\015\124\009\018\012\043\108\087\085\038\108\085\015\009\076\085\125\038\076\120\012\120\018\076\118\054\009\126\085\015\018\009\085\054\038\012\085\018\112\112\009\076\085\074\038\002\085\124\043\085\009\076\124\038\009\054\109\009\108\011"), 
		Media = _MbGJ, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	_6Ig4.Active = true
	_6Ig4.Visible = true
end
function _RANn:OnClick()
	_Urwigo.MessageBox{
		Text = _6rq("\080\002\118\054\085\046\018\108\085\095\043\041\038\018\076\085\038\043\002\085\015\018\009\085\019\076\038\120\076\009\018\002\118\054\011\085\040\018\108\085\087\009\120\059\112\112\009\108\085\087\009\076\038\015\009\085\108\038\118\054\085\086\009\043\012\002\118\054\009\109\038\108\015\011\085\080\118\054\085\108\018\032\085\120\009\108\108\009\085\015\009\108\085\069\009\076\002\059\108\085\012\043\085\038\041\009\109\109\009\076\085\086\018\009\012\009\112\038\108\108\011\004\040\022\016\004\040\022\016\107\043\012\085\112\018\002\118\054\085\109\009\018\015\085\094\018\009\109\011\085\004\040\022\016\004\040\022\016\055\018\009\109\085\096\109\043\118\120\085\046\009\018\085\015\009\112\085\093\043\118\054\009\011\004\040\022\016\004\040\022\016\095\043\085\022\009\094\059\018\076\011\011\011"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _EOF0K:OnClick()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_CIJ)
	end)
end
function _rYK:OnClick()
	_Urwigo.MessageBox{
		Text = _6rq("\086\009\076\085\086\018\009\012\009\112\038\108\108\085\018\002\012\085\009\108\012\034\043\009\054\076\012\085\074\059\076\015\009\108\027\085\004\040\022\016\004\040\022\016\051\009\018\108\126\085\015\038\094\059\108\085\054\038\046\009\085\018\118\054\085\108\059\118\054\085\108\018\118\054\012\002\085\087\009\054\059\009\076\012\011\004\040\022\016\004\040\022\016\095\046\009\076\085\015\009\076\085\058\018\076\012\085\015\009\076\085\096\038\002\012\038\012\009\012\012\009\085\056\018\109\109\009\126\085\040\109\009\118\054\112\043\009\012\124\009\126\085\059\015\009\076\085\074\018\009\085\015\009\076\085\054\009\018\002\002\012\126\085\015\009\076\085\074\009\018\002\002\085\009\018\087\009\108\012\109\018\118\054\085\002\059\085\124\018\009\112\109\018\118\054\085\038\109\109\009\002\126\085\074\038\002\085\018\108\085\015\009\076\085\093\012\038\015\012\085\041\038\002\002\018\009\076\012\126\085\094\018\009\109\109\009\018\118\054\012\085\002\059\109\109\012\009\108\085\093\018\009\085\015\009\108\085\112\038\109\085\034\076\038\087\009\108\092"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	_Ig1.Visible = true
	_Ig1.Active = true
end
function _8petH:OnClick()
	_Urwigo.MessageBox{
		Text = _6rq("\042\091\085\038\109\012\009\076\085\120\059\112\112\085\109\038\002\002\085\043\108\015\085\009\018\108\009\108\085\124\018\002\118\054\009\108\126\085\015\038\108\108\085\009\076\124\038\009\054\109\085\018\118\054\085\108\009\046\009\108\054\009\076\085\112\038\109\085\074\038\002\085\043\009\046\009\076\085\015\009\108\085\038\109\012\009\108\085\049\043\108\087\009\108\085\038\043\002\085\015\009\112\085\093\118\054\109\059\002\002\012\043\076\112\011\004\040\022\016\004\040\022\016\093\118\054\108\038\041\002\085\043\108\002\009\076\126\004\040\022\016\015\009\076\085\015\043\085\046\018\002\012\085\018\112\085\096\109\038\002\009\004\040\022\016\087\009\002\009\087\108\009\012\085\074\009\076\015\009\085\015\009\076\085\015\018\118\054\085\087\009\046\076\038\108\108\012\085\054\038\012\004\040\022\016\015\009\018\108\085\022\038\043\002\118\054\085\120\059\112\112\009\126\004\040\022\016\015\009\018\108\085\058\018\109\109\009\085\087\009\002\118\054\009\054\009\126\004\040\022\016\074\018\009\085\124\043\085\083\038\043\002\009\085\038\109\002\085\038\043\118\054\085\018\108\085\015\009\076\085\077\108\009\018\041\009\011\004\040\022\016\106\108\002\009\076\009\108\085\012\038\009\087\109\018\118\054\009\108\085\086\043\076\002\012\085\087\018\046\085\043\108\002\085\054\009\043\012\009\004\040\022\016\043\108\015\085\094\009\076\087\018\046\085\043\108\002\085\043\108\002\009\076\009\085\093\118\054\043\109\015\126\004\040\022\016\074\018\009\085\038\043\118\054\085\074\018\076\085\094\009\076\087\009\046\009\108\085\043\108\002\009\076\009\108\085\093\118\054\043\109\015\108\009\076\108\011\004\040\022\016\106\108\015\085\034\043\009\054\076\009\085\043\108\002\085\108\018\118\054\012\085\018\108\085\015\018\009\085\125\018\109\118\054\046\038\076\126\004\040\022\016\002\059\108\015\009\076\108\085\087\018\046\085\043\108\002\085\077\076\038\034\012\085\124\043\112\085\074\009\018\012\009\076\002\038\043\034\009\108\011\004\040\022\016\086\009\108\108\085\015\009\018\108\085\018\002\012\085\015\009\076\085\093\043\034\034\126\004\040\022\016\015\009\076\085\022\038\043\002\118\054\085\043\108\015\085\015\009\076\085\086\043\076\002\012\004\040\022\016\043\108\015\085\015\018\009\085\040\009\108\059\112\112\009\108\054\009\018\012\004\040\022\016\018\108\085\042\074\018\087\120\009\018\012\011\004\040\022\016\004\040\022\016\095\118\054\074\038\002\126\085\015\043\085\002\043\118\054\002\012\085\074\018\076\120\109\018\118\054\085\015\009\108\085\086\018\009\012\009\112\038\108\108\027\085\004\040\022\016\004\040\022\016\086\009\108\085\054\038\046\085\018\118\054\085\015\059\118\054\085\094\059\076\054\018\108\085\046\009\018\085\015\009\076\085\040\076\038\043\009\076\009\018\046\009\002\018\118\054\012\018\087\043\108\087\085\087\009\012\076\059\034\034\009\108\011\085\004\040\022\016\004\040\022\016\086\009\112\085\087\009\054\012\002\085\046\109\009\009\009\009\009\009\108\015\009\108\015\085\112\009\018\108\085\019\076\009\043\108\015\011\004\040\022\016\004\040\022\016\004\040\022\016\004\040\022\016\004\040\022\016\030\054\074\009\018\126\085\018\118\054\085\087\109\038\043\046\085\018\118\054\085\112\043\002\002\085\112\038\109\011\011\011\011"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	_nEn.Active = false
	_Ig1.Visible = false
	_Ig1.Active = false
	_Br3_a.Active = true
	_Br3_a.Visible = true
	_nEn.Visible = false
end
function _yXu5:OnClick()
	_Urwigo.MessageBox{
		Text = _6rq("\070\054\018\118\120\002\070\085\093\018\009\085\002\043\118\054\009\108\085\112\018\118\054\027\085\095\046\009\076\085\074\038\076\043\112\085\015\009\108\108\027\085\070\054\018\118\120\002\070\004\040\022\016\077\038\108\108\085\112\038\108\085\015\009\108\108\085\054\018\009\076\085\108\018\118\054\012\085\009\018\108\112\038\109\085\070\054\018\118\120\002\070\085\018\108\085\022\043\054\009\085\009\018\108\009\108\085\012\076\018\108\120\009\108\027\085\070\054\018\118\120\002\070\004\040\022\016\004\040\022\016\051\038\057\038\126\085\074\009\108\108\085\093\018\009\085\070\054\018\118\120\002\070\085\002\118\054\059\108\085\009\018\108\112\038\109\085\054\018\009\076\085\002\018\108\015\085\070\054\018\118\120\002\070\085\120\059\009\108\108\009\108\085\093\018\009\085\112\018\118\054\085\002\018\118\054\009\076\085\070\054\018\118\120\002\070\085\108\038\118\054\085\083\038\043\002\009\085\046\076\018\108\087\009\108\085\070\054\018\118\120\002\070"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _6rq("\093\107\030\069\069\092\085\058\059\085\018\002\012\085\015\009\108\108\085\108\043\076\085\070\054\018\118\120\002\070\085\112\009\018\108\009\085\107\076\059\009\012\009\027"), 
					Callback = function(action)
						if action ~= nil then
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					end
				}
			end
		end
	}
	_c0S.Visible = true
end
function _yiR8:OnClick()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_0_0d)
	end)
end
function _c0S:OnClick()
	_Urwigo.MessageBox{
		Text = _6rq("\093\018\009\085\002\043\118\054\009\108\085\009\018\108\009\085\107\076\059\009\012\009\027\085\004\040\022\016\004\040\022\016\080\118\054\085\054\038\046\009\085\009\046\009\108\085\009\018\108\009\085\018\112\085\069\038\076\120\054\038\043\002\085\109\018\009\087\009\108\085\002\009\054\009\108\011"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	_1b800.Active = true
	_1b800.Visible = true
end
function _oOVKu:OnClick()
	_oOVKu:MoveTo(Player)
	_Urwigo.MessageBox{
		Text = _6rq("\083\018\009\076\085\009\018\108\085\019\059\012\059\085\094\059\112\085\086\018\009\012\009\112\038\108\108\092"), 
		Media = _RZ03E, 
		Buttons = {
			_6rq("\124\043\076\043\009\118\120")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
			end
		end
	}
end
function _jf7A:OnClick()
	_Urwigo.MessageBox{
		Text = "", 
		Media = _mX6A, 
		Buttons = {
			_6rq("\124\043\076\043\118\120")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	_jf7A:MoveTo(Player)
end
function _MZ4zV:OnClick()
	_Urwigo.MessageBox{
		Text = _6rq("\086\018\009\002\009\002\085\107\043\118\054\085\087\018\046\002\012\085\015\043\085\002\059\034\059\076\012\085\018\108\002\085\121\038\046\059\076\085\043\112\085\009\002\085\038\043\034\085\035\054\109\059\076\059\041\054\059\076\112\076\043\009\118\120\002\012\038\108\015\009\085\059\015\009\076\085\038\009\054\108\109\018\118\054\009\002\085\124\043\085\043\009\046\009\076\041\076\043\009\034\009\108\092"), 
		Media = _Usp, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	_MZ4zV.Visible = false
end
function _OeqsO:OnClick()
	_Urwigo.MessageBox{
		Text = "", 
		Media = _ys3g, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	_OeqsO:MoveTo(Player)
end
function _ttf:On_ZcGf(target)
end
function _ttf:OnClick()
	_Urwigo.MessageBox{
		Text = _6rq("\015\009\108\120\085\015\076\038\108\126\085\059\046\009\076\002\012\009\085\042\012\038\087\009\092\092\092"), 
		Media = _jCcc, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return _po7
