require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _HoM(str)
	local res = ""
    local dtable = "\025\008\102\104\070\013\003\012\049\052\097\092\125\103\035\120\099\076\031\118\030\000\039\124\082\036\098\027\028\018\088\121\109\087\112\033\007\032\089\026\045\048\090\080\006\066\086\064\038\023\060\034\068\002\017\081\117\005\100\029\053\043\084\075\077\014\115\065\054\091\094\105\093\010\113\067\011\107\024\062\016\079\019\078\020\037\004\022\101\042\106\063\056\083\072\071\123\122\015\047\096\059\009\074\069\046\055\050\085\057\061\001\108\126\058\040\044\116\110\119\095\114\021\041\051\073\111"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

objPerkasieInPlaneSight = Wherigo.ZCartridge()

-- Media --
objSamFull = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSamFull.Id = "bdf44314-733a-4f04-9adb-2516d3659d78"
objSamFull.Name = "Sam Full"
objSamFull.Description = ""
objSamFull.AltText = ""
objSamFull.Resources = {
	{
		Type = "jpg", 
		Filename = "zcharacter_SamFull_ppc.jpg", 
		Directives = {}
	}
}
objSamCloseup = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSamCloseup.Id = "7d5df825-9432-42ae-8e82-d458564bca88"
objSamCloseup.Name = "Sam Closeup"
objSamCloseup.Description = ""
objSamCloseup.AltText = ""
objSamCloseup.Resources = {
	{
		Type = "jpg", 
		Filename = "zcharacter_SamClose_ppc.jpg", 
		Directives = {}
	}
}
objKayleeFull = Wherigo.ZMedia(objPerkasieInPlaneSight)
objKayleeFull.Id = "7cebc885-a955-42fc-9534-9424b435b126"
objKayleeFull.Name = "Kaylee Full"
objKayleeFull.Description = ""
objKayleeFull.AltText = ""
objKayleeFull.Resources = {
	{
		Type = "jpg", 
		Filename = "zcharacter_KayleeFull_ppc.jpg", 
		Directives = {}
	}
}
objKayleeCloseup = Wherigo.ZMedia(objPerkasieInPlaneSight)
objKayleeCloseup.Id = "deba8c7a-9c82-4be1-a154-b5d97bdf64e9"
objKayleeCloseup.Name = "Kaylee Closeup"
objKayleeCloseup.Description = ""
objKayleeCloseup.AltText = ""
objKayleeCloseup.Resources = {
	{
		Type = "jpg", 
		Filename = "zcharacter_KayleeCloseup_ppc.jpg", 
		Directives = {}
	}
}
objCodeCylinder = Wherigo.ZMedia(objPerkasieInPlaneSight)
objCodeCylinder.Id = "75c2cb19-fdf4-4be0-9f5c-6a77231dad6f"
objCodeCylinder.Name = "Code Cylinder"
objCodeCylinder.Description = ""
objCodeCylinder.AltText = ""
objCodeCylinder.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemCodeCylinder_ppc.jpg", 
		Directives = {}
	}
}
objPlanePart2Fire = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPlanePart2Fire.Id = "269b8ec6-004e-4ea8-9eb7-0633aed8348f"
objPlanePart2Fire.Name = "Plane Part 2 Fire"
objPlanePart2Fire.Description = ""
objPlanePart2Fire.AltText = ""
objPlanePart2Fire.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemEngineOnFire_ppc.jpg", 
		Directives = {}
	}
}
objPlanePart2Foam = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPlanePart2Foam.Id = "d8a9d4df-7a09-46d6-a649-6029a19ebb62"
objPlanePart2Foam.Name = "Plane Part 2 Foam"
objPlanePart2Foam.Description = ""
objPlanePart2Foam.AltText = ""
objPlanePart2Foam.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemEngineFoam_ppc.jpg", 
		Directives = {}
	}
}
objFireExtinguisher = Wherigo.ZMedia(objPerkasieInPlaneSight)
objFireExtinguisher.Id = "e1c5141a-819b-49a4-bc14-77c2d22cfebc"
objFireExtinguisher.Name = "Fire Extinguisher"
objFireExtinguisher.Description = ""
objFireExtinguisher.AltText = ""
objFireExtinguisher.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemFireExtinguisher_ppc.jpg", 
		Directives = {}
	}
}
objGloves = Wherigo.ZMedia(objPerkasieInPlaneSight)
objGloves.Id = "67743182-2304-444b-b870-1e078792360c"
objGloves.Name = "Gloves"
objGloves.Description = ""
objGloves.AltText = ""
objGloves.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemGloves_ppc.jpg", 
		Directives = {}
	}
}
objHandheldRadio = Wherigo.ZMedia(objPerkasieInPlaneSight)
objHandheldRadio.Id = "9a72b097-c16e-43e5-aa8b-76c9290dc0a6"
objHandheldRadio.Name = "Handheld Radio"
objHandheldRadio.Description = ""
objHandheldRadio.AltText = ""
objHandheldRadio.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemHandheldRadio_ppc.jpg", 
		Directives = {}
	}
}
objLadder = Wherigo.ZMedia(objPerkasieInPlaneSight)
objLadder.Id = "72d54964-4ef1-46fb-8a4a-24c6dbbadc03"
objLadder.Name = "Ladder"
objLadder.Description = ""
objLadder.AltText = ""
objLadder.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemLadder_ppc.jpg", 
		Directives = {}
	}
}
objPackage = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPackage.Id = "857f3c73-f3b2-4f4c-b71e-0d5f9c694418"
objPackage.Name = "Package"
objPackage.Description = ""
objPackage.AltText = ""
objPackage.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemPackage_ppc.jpg", 
		Directives = {}
	}
}
objSaveGame = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSaveGame.Id = "e070f11f-8c6f-43d2-a528-6f4d7759738e"
objSaveGame.Name = "Save Game"
objSaveGame.Description = ""
objSaveGame.AltText = ""
objSaveGame.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemSave.jpg", 
		Directives = {}
	}
}
objHouse = Wherigo.ZMedia(objPerkasieInPlaneSight)
objHouse.Id = "a26eedec-c98b-41ee-b81e-abdb831690f5"
objHouse.Name = "House"
objHouse.Description = ""
objHouse.AltText = ""
objHouse.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemHouse_ppc.jpg", 
		Directives = {}
	}
}
objSamRadio = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSamRadio.Id = "97bf326a-d1fa-4131-9898-b12943c9a278"
objSamRadio.Name = "Sam Radio"
objSamRadio.Description = ""
objSamRadio.AltText = ""
objSamRadio.Resources = {
	{
		Type = "jpg", 
		Filename = "zcharacter_SamRadio.jpg", 
		Directives = {}
	}
}
objPlanePart3 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPlanePart3.Id = "7efe34a2-d6c3-4a45-92e0-875fe47f6ebc"
objPlanePart3.Name = "Plane Part 3"
objPlanePart3.Description = "The \"Hot\" piece"
objPlanePart3.AltText = ""
objPlanePart3.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemPlanePart_Hot_ppc.jpg", 
		Directives = {}
	}
}
objPlanePart4 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPlanePart4.Id = "1db54a1e-c916-41d8-badf-bccb31967a08"
objPlanePart4.Name = "Plane Part 4"
objPlanePart4.Description = ""
objPlanePart4.AltText = ""
objPlanePart4.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemPlanePiece4_ppc.jpg", 
		Directives = {}
	}
}
objPlane = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPlane.Id = "bc0418ff-8078-48df-8aa4-e5835db711b9"
objPlane.Name = "Plane"
objPlane.Description = ""
objPlane.AltText = ""
objPlane.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemPlane.jpg", 
		Directives = {}
	}
}
objCar = Wherigo.ZMedia(objPerkasieInPlaneSight)
objCar.Id = "53eeddae-9e75-4d52-9d0a-124234805f6d"
objCar.Name = "Car"
objCar.Description = ""
objCar.AltText = ""
objCar.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemCar_ppc.jpg", 
		Directives = {}
	}
}
objPlanePart1 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPlanePart1.Id = "88f40525-151e-4cc6-ac6c-3349c9971c83"
objPlanePart1.Name = "Plane Part 1"
objPlanePart1.Description = ""
objPlanePart1.AltText = ""
objPlanePart1.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemPlanePart1_ppc.jpg", 
		Directives = {}
	}
}
objYou = Wherigo.ZMedia(objPerkasieInPlaneSight)
objYou.Id = "08ca638f-efab-492a-9b6b-9ca95b72bd9b"
objYou.Name = "You"
objYou.Description = ""
objYou.AltText = ""
objYou.Resources = {
	{
		Type = "jpg", 
		Filename = "zcharacterYou_ppc.jpg", 
		Directives = {}
	}
}
objPlaneFlying = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPlaneFlying.Id = "e6dc48ac-ccae-4b64-a079-9bae1a512bac"
objPlaneFlying.Name = "Plane Flying"
objPlaneFlying.Description = ""
objPlaneFlying.AltText = ""
objPlaneFlying.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemPlaneFlying_ppc.jpg", 
		Directives = {}
	}
}
objPlanePart1Inventory = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPlanePart1Inventory.Id = "8d6437f4-e99a-4f76-944a-ca0582a1db35"
objPlanePart1Inventory.Name = "Plane Part 1 Inventory"
objPlanePart1Inventory.Description = ""
objPlanePart1Inventory.AltText = ""
objPlanePart1Inventory.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemPlanePart1_Inv_ppc.jpg", 
		Directives = {}
	}
}
objPlanePart2Inventory = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPlanePart2Inventory.Id = "65b815c3-8394-4912-8822-7786da10e051"
objPlanePart2Inventory.Name = "Plane Part 2 Inventory"
objPlanePart2Inventory.Description = ""
objPlanePart2Inventory.AltText = ""
objPlanePart2Inventory.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemPlanePart2_Inv_ppc.jpg", 
		Directives = {}
	}
}
objPlanePart3Inventory = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPlanePart3Inventory.Id = "24eb824d-c39b-4ea7-b517-d316718edbaa"
objPlanePart3Inventory.Name = "Plane Part 3 Inventory"
objPlanePart3Inventory.Description = ""
objPlanePart3Inventory.AltText = ""
objPlanePart3Inventory.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemPlanePart3_Inv_ppc.jpg", 
		Directives = {}
	}
}
objPlanePart4Inventory = Wherigo.ZMedia(objPerkasieInPlaneSight)
objPlanePart4Inventory.Id = "c4b5408c-0533-446e-91bc-3e22827ef30b"
objPlanePart4Inventory.Name = "Plane Part 4 Inventory"
objPlanePart4Inventory.Description = ""
objPlanePart4Inventory.AltText = ""
objPlanePart4Inventory.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemPlanePart4_Inv_ppc.jpg", 
		Directives = {}
	}
}
objTitle = Wherigo.ZMedia(objPerkasieInPlaneSight)
objTitle.Id = "32029b7e-c825-4ff4-bd93-0664a857a818"
objTitle.Name = "Title"
objTitle.Description = ""
objTitle.AltText = ""
objTitle.Resources = {
	{
		Type = "jpg", 
		Filename = "Title_ppc.jpg", 
		Directives = {}
	}
}
objRoute = Wherigo.ZMedia(objPerkasieInPlaneSight)
objRoute.Id = "69312abc-151a-4ea2-8ae1-341668dc1089"
objRoute.Name = "Route"
objRoute.Description = ""
objRoute.AltText = ""
objRoute.Resources = {
	{
		Type = "jpg", 
		Filename = "Route_ppc.jpg", 
		Directives = {}
	}
}
objTaskComplete = Wherigo.ZMedia(objPerkasieInPlaneSight)
objTaskComplete.Id = "229a137a-ac51-4653-b8cb-a96fa36e8f4e"
objTaskComplete.Name = "Task Complete"
objTaskComplete.Description = ""
objTaskComplete.AltText = ""
objTaskComplete.Resources = {
	{
		Type = "jpg", 
		Filename = "TaskComplete_ppc.jpg", 
		Directives = {}
	}
}
objGeocacheAlert = Wherigo.ZMedia(objPerkasieInPlaneSight)
objGeocacheAlert.Id = "637f0d00-89a5-415f-8f84-34eab520d554"
objGeocacheAlert.Name = "Geocache Alert"
objGeocacheAlert.Description = ""
objGeocacheAlert.AltText = ""
objGeocacheAlert.Resources = {
	{
		Type = "jpg", 
		Filename = "GeocacheAlert_ppc.jpg", 
		Directives = {}
	}
}
objCompletionCode = Wherigo.ZMedia(objPerkasieInPlaneSight)
objCompletionCode.Id = "07b3f9c1-7c8a-4678-8fde-50c26642f30c"
objCompletionCode.Name = "Completion Code"
objCompletionCode.Description = ""
objCompletionCode.AltText = ""
objCompletionCode.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemCompletionCode.jpg", 
		Directives = {}
	}
}
objParkingLot = Wherigo.ZMedia(objPerkasieInPlaneSight)
objParkingLot.Id = "409d3f09-c8fb-4a5b-bd9f-148627e84035"
objParkingLot.Name = "Parking Lot"
objParkingLot.Description = ""
objParkingLot.AltText = ""
objParkingLot.Resources = {
	{
		Type = "jpg", 
		Filename = "zzone_ParkingLot.jpg", 
		Directives = {}
	}
}
objiconSave = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconSave.Id = "d059be8a-b1dd-4908-902e-ff7764b5db1f"
objiconSave.Name = "icon Save"
objiconSave.Description = ""
objiconSave.AltText = ""
objiconSave.Resources = {
	{
		Type = "jpg", 
		Filename = "iconSave.jpg", 
		Directives = {}
	}
}
objiconRadio = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconRadio.Id = "dfa82d60-d5d6-400f-a5ff-4824c9d3643d"
objiconRadio.Name = "icon Radio"
objiconRadio.Description = ""
objiconRadio.AltText = ""
objiconRadio.Resources = {
	{
		Type = "jpg", 
		Filename = "iconRadio.jpg", 
		Directives = {}
	}
}
objiconTitle = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconTitle.Id = "51afe7ee-649c-46cd-8a4b-79c33beb296c"
objiconTitle.Name = "icon Title"
objiconTitle.Description = ""
objiconTitle.AltText = ""
objiconTitle.Resources = {
	{
		Type = "jpg", 
		Filename = "iconTitle.jpg", 
		Directives = {}
	}
}
objiconComplete = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconComplete.Id = "a5900c1f-d596-407d-b579-05f2caecb7e6"
objiconComplete.Name = "icon Complete"
objiconComplete.Description = ""
objiconComplete.AltText = ""
objiconComplete.Resources = {
	{
		Type = "jpg", 
		Filename = "iconCompletion.jpg", 
		Directives = {}
	}
}
objiconPlaneCrash = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconPlaneCrash.Id = "50617805-2083-47a1-8fde-6135be594958"
objiconPlaneCrash.Name = "icon Plane Crash"
objiconPlaneCrash.Description = ""
objiconPlaneCrash.AltText = ""
objiconPlaneCrash.Resources = {
	{
		Type = "jpg", 
		Filename = "iconCrashSite.jpg", 
		Directives = {}
	}
}
objiconParking = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconParking.Id = "181cb601-b7c9-4180-8d57-06c21fcd7034"
objiconParking.Name = "icon Parking"
objiconParking.Description = ""
objiconParking.AltText = ""
objiconParking.Resources = {
	{
		Type = "jpg", 
		Filename = "iconParking.jpg", 
		Directives = {}
	}
}
objiconBatteryPack = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconBatteryPack.Id = "e64759df-0e49-4745-a739-815a261f4bdd"
objiconBatteryPack.Name = "icon Battery Pack"
objiconBatteryPack.Description = ""
objiconBatteryPack.AltText = ""
objiconBatteryPack.Resources = {
	{
		Type = "jpg", 
		Filename = "iconBatteryPack.jpg", 
		Directives = {}
	}
}
objiconGloves = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconGloves.Id = "621a5f1d-24af-4ebb-b926-f8ce04e28ff3"
objiconGloves.Name = "icon Gloves"
objiconGloves.Description = ""
objiconGloves.AltText = ""
objiconGloves.Resources = {
	{
		Type = "jpg", 
		Filename = "iconGloves.jpg", 
		Directives = {}
	}
}
objiconSam = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconSam.Id = "7c97cbe1-5a27-498b-bc50-e0ead8fc4ab2"
objiconSam.Name = "icon Sam"
objiconSam.Description = ""
objiconSam.AltText = ""
objiconSam.Resources = {
	{
		Type = "jpg", 
		Filename = "iconSam.jpg", 
		Directives = {}
	}
}
objiconKaylee = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconKaylee.Id = "be40e06f-09bc-4769-b5c2-23a7b8c562a2"
objiconKaylee.Name = "icon Kaylee"
objiconKaylee.Description = ""
objiconKaylee.AltText = ""
objiconKaylee.Resources = {
	{
		Type = "jpg", 
		Filename = "iconKaylee.jpg", 
		Directives = {}
	}
}
objiconCar = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconCar.Id = "027c3335-b563-40af-b057-57029c772264"
objiconCar.Name = "icon Car"
objiconCar.Description = ""
objiconCar.AltText = ""
objiconCar.Resources = {
	{
		Type = "jpg", 
		Filename = "iconCar.jpg", 
		Directives = {}
	}
}
objiconFireExtinguisher = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconFireExtinguisher.Id = "216ff19f-5fb3-4f24-98f6-447ca69b876d"
objiconFireExtinguisher.Name = "icon Fire Extinguisher"
objiconFireExtinguisher.Description = ""
objiconFireExtinguisher.AltText = ""
objiconFireExtinguisher.Resources = {
	{
		Type = "jpg", 
		Filename = "iconFireExtinguisher.jpg", 
		Directives = {}
	}
}
objiconHouse = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconHouse.Id = "b302309e-b60a-4c45-bbb7-4d90bd1a1503"
objiconHouse.Name = "icon House"
objiconHouse.Description = ""
objiconHouse.AltText = ""
objiconHouse.Resources = {
	{
		Type = "jpg", 
		Filename = "iconHouse.jpg", 
		Directives = {}
	}
}
objiconLadder = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconLadder.Id = "1971ac91-8a0b-46f5-aa2e-f6fb5e1bb664"
objiconLadder.Name = "icon Ladder"
objiconLadder.Description = ""
objiconLadder.AltText = ""
objiconLadder.Resources = {
	{
		Type = "jpg", 
		Filename = "iconLadder.jpg", 
		Directives = {}
	}
}
objiconSpoiler = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconSpoiler.Id = "774d304f-57ac-4e56-91de-67b4691269b8"
objiconSpoiler.Name = "icon Spoiler"
objiconSpoiler.Description = ""
objiconSpoiler.AltText = ""
objiconSpoiler.Resources = {
	{
		Type = "jpg", 
		Filename = "iconSpoiler.jpg", 
		Directives = {}
	}
}
objiconPlanePart4 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconPlanePart4.Id = "2c7f61c2-b1d4-4048-af0c-d061a89a973e"
objiconPlanePart4.Name = "icon Plane Part 4"
objiconPlanePart4.Description = ""
objiconPlanePart4.AltText = ""
objiconPlanePart4.Resources = {
	{
		Type = "jpg", 
		Filename = "iconPlanePart4.jpg", 
		Directives = {}
	}
}
objiconPlanePart3 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconPlanePart3.Id = "a37dd879-25d1-4814-b61e-37c8feb9e6c2"
objiconPlanePart3.Name = "icon Plane Part 3"
objiconPlanePart3.Description = ""
objiconPlanePart3.AltText = ""
objiconPlanePart3.Resources = {
	{
		Type = "jpg", 
		Filename = "iconPlanePart3.jpg", 
		Directives = {}
	}
}
objiconPlanePart3_1 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconPlanePart3_1.Id = "235a7792-f4e8-455c-9c68-aa548f5f680e"
objiconPlanePart3_1.Name = "icon Plane Part 3"
objiconPlanePart3_1.Description = ""
objiconPlanePart3_1.AltText = ""
objiconPlanePart3_1.Resources = {
	{
		Type = "jpg", 
		Filename = "iconPlanePart3_1.jpg", 
		Directives = {}
	}
}
objiconPlanePart2 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconPlanePart2.Id = "27f3e68d-8393-4e36-aca9-21e37ee26af0"
objiconPlanePart2.Name = "icon Plane Part 2"
objiconPlanePart2.Description = ""
objiconPlanePart2.AltText = ""
objiconPlanePart2.Resources = {
	{
		Type = "jpg", 
		Filename = "iconPlanePart2.jpg", 
		Directives = {}
	}
}
objiconPlanePart1 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconPlanePart1.Id = "38475d8e-ef86-41d3-9202-efafe657b71f"
objiconPlanePart1.Name = "icon Plane Part 1"
objiconPlanePart1.Description = ""
objiconPlanePart1.AltText = ""
objiconPlanePart1.Resources = {
	{
		Type = "jpg", 
		Filename = "iconPlanePart1.jpg", 
		Directives = {}
	}
}
objiconCodeCylinder = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconCodeCylinder.Id = "40f43703-8901-4d5f-8102-75225713a815"
objiconCodeCylinder.Name = "icon Code Cylinder"
objiconCodeCylinder.Description = ""
objiconCodeCylinder.AltText = ""
objiconCodeCylinder.Resources = {
	{
		Type = "jpg", 
		Filename = "iconCodeCylinder.jpg", 
		Directives = {}
	}
}
objiconPackage = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconPackage.Id = "90425289-86c9-4e98-9583-b715985462d9"
objiconPackage.Name = "icon Package"
objiconPackage.Description = ""
objiconPackage.AltText = ""
objiconPackage.Resources = {
	{
		Type = "jpg", 
		Filename = "iconPackage.jpg", 
		Directives = {}
	}
}
objiconZonePlaneParts = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconZonePlaneParts.Id = "4ab94715-2efe-4ea2-9e79-3b6b2c9a85d6"
objiconZonePlaneParts.Name = "icon Zone Plane Parts"
objiconZonePlaneParts.Description = ""
objiconZonePlaneParts.AltText = ""
objiconZonePlaneParts.Resources = {
	{
		Type = "jpg", 
		Filename = "iconZonePlaneParts.jpg", 
		Directives = {}
	}
}
objZoneParts34 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objZoneParts34.Id = "7ef9b1ae-a9c5-429b-a203-999942339cb6"
objZoneParts34.Name = "Zone Parts 3-4"
objZoneParts34.Description = ""
objZoneParts34.AltText = ""
objZoneParts34.Resources = {
	{
		Type = "jpg", 
		Filename = "zZone_Parts34.jpg", 
		Directives = {}
	}
}
objSpoilerArtsImports = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSpoilerArtsImports.Id = "8e198446-f16a-4ea6-9fb3-3cc05d0b15bb"
objSpoilerArtsImports.Name = "Spoiler - Arts Imports"
objSpoilerArtsImports.Description = ""
objSpoilerArtsImports.AltText = ""
objSpoilerArtsImports.Resources = {
	{
		Type = "jpg", 
		Filename = "zSpoilerPic_ArtsImports.jpg", 
		Directives = {}
	}
}
objSpoilerRidgeRd = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSpoilerRidgeRd.Id = "6ccc1677-66d6-4a71-b98b-740650957646"
objSpoilerRidgeRd.Name = "Spoiler - Ridge Rd"
objSpoilerRidgeRd.Description = ""
objSpoilerRidgeRd.AltText = ""
objSpoilerRidgeRd.Resources = {
	{
		Type = "jpg", 
		Filename = "zSpoilerPic_RidgeRdTB.jpg", 
		Directives = {}
	}
}
objSpoilerPart2 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSpoilerPart2.Id = "c8fa0c10-99bd-4a31-b923-bfa034f45c0a"
objSpoilerPart2.Name = "Spoiler - Part 2"
objSpoilerPart2.Description = ""
objSpoilerPart2.AltText = ""
objSpoilerPart2.Resources = {
	{
		Type = "jpg", 
		Filename = "zSpoilerPic_Part2.jpg", 
		Directives = {}
	}
}
objSpoilerPart3 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSpoilerPart3.Id = "2e3fa575-26f2-4bda-a3d6-4b021c0c9137"
objSpoilerPart3.Name = "Spoiler - Part 3"
objSpoilerPart3.Description = ""
objSpoilerPart3.AltText = ""
objSpoilerPart3.Resources = {
	{
		Type = "jpg", 
		Filename = "zSpoilerPic_Part3.jpg", 
		Directives = {}
	}
}
objSpoilerACRONYM = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSpoilerACRONYM.Id = "80b0ce62-16c3-47cc-bf2a-4bad97d0eaa5"
objSpoilerACRONYM.Name = "Spoiler - ACRONYM"
objSpoilerACRONYM.Description = ""
objSpoilerACRONYM.AltText = ""
objSpoilerACRONYM.Resources = {
	{
		Type = "jpg", 
		Filename = "zSpoilerPic_ACRONYM.jpg", 
		Directives = {}
	}
}
objSpoilerCodeCylinder1 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSpoilerCodeCylinder1.Id = "0112aefc-53ea-453f-a719-a542a31154a5"
objSpoilerCodeCylinder1.Name = "Spoiler - Code Cylinder 1"
objSpoilerCodeCylinder1.Description = ""
objSpoilerCodeCylinder1.AltText = ""
objSpoilerCodeCylinder1.Resources = {
	{
		Type = "jpg", 
		Filename = "zSpoilerPic_Code1.jpg", 
		Directives = {}
	}
}
objSpoilerCodeCylinder2 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSpoilerCodeCylinder2.Id = "95a835f3-3849-4501-88b7-64467a392256"
objSpoilerCodeCylinder2.Name = "Spoiler - Code Cylinder 2"
objSpoilerCodeCylinder2.Description = ""
objSpoilerCodeCylinder2.AltText = ""
objSpoilerCodeCylinder2.Resources = {
	{
		Type = "jpg", 
		Filename = "zSpoilerPic_Code2.jpg", 
		Directives = {}
	}
}
objSpoilerCodeCylinder3 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSpoilerCodeCylinder3.Id = "88b21fb4-7c72-4f57-81cb-78b6df6b46be"
objSpoilerCodeCylinder3.Name = "Spoiler - Code Cylinder 3"
objSpoilerCodeCylinder3.Description = ""
objSpoilerCodeCylinder3.AltText = ""
objSpoilerCodeCylinder3.Resources = {
	{
		Type = "jpg", 
		Filename = "zSpoilerPic_Code3.jpg", 
		Directives = {}
	}
}
objSpoilerFinal = Wherigo.ZMedia(objPerkasieInPlaneSight)
objSpoilerFinal.Id = "73bdeadb-49f4-4194-a370-36acab0ddaf8"
objSpoilerFinal.Name = "Spoiler - Final"
objSpoilerFinal.Description = ""
objSpoilerFinal.AltText = ""
objSpoilerFinal.Resources = {
	{
		Type = "jpg", 
		Filename = "zSpoilerPic_Final.jpg", 
		Directives = {}
	}
}
objZonePart1 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objZonePart1.Id = "f3ef4f0e-78f5-44b8-b36d-a18e8c3c11ed"
objZonePart1.Name = "Zone Part 1"
objZonePart1.Description = ""
objZonePart1.AltText = ""
objZonePart1.Resources = {
	{
		Type = "jpg", 
		Filename = "zZone_Part1.jpg", 
		Directives = {}
	}
}
objZonePart2 = Wherigo.ZMedia(objPerkasieInPlaneSight)
objZonePart2.Id = "dd441562-3024-4881-b183-5954c0f48ab6"
objZonePart2.Name = "Zone Part 2"
objZonePart2.Description = ""
objZonePart2.AltText = ""
objZonePart2.Resources = {
	{
		Type = "jpg", 
		Filename = "zZone_Part2.jpg", 
		Directives = {}
	}
}
objJournal = Wherigo.ZMedia(objPerkasieInPlaneSight)
objJournal.Id = "53495956-be8d-47ae-880e-9b1725c041e4"
objJournal.Name = "Journal"
objJournal.Description = ""
objJournal.AltText = ""
objJournal.Resources = {
	{
		Type = "jpg", 
		Filename = "zitemJournal.jpg", 
		Directives = {}
	}
}
objiconJournal = Wherigo.ZMedia(objPerkasieInPlaneSight)
objiconJournal.Id = "c09a8d1b-85f9-499f-ad4c-5ad47a1352e6"
objiconJournal.Name = "icon Journal"
objiconJournal.Description = ""
objiconJournal.AltText = ""
objiconJournal.Resources = {
	{
		Type = "jpg", 
		Filename = "iconJournal.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
objPerkasieInPlaneSight.Id="208baa62-8208-4eb4-a70c-622ee3cd061e"
objPerkasieInPlaneSight.Name="Perkasie In Plane Sight"
objPerkasieInPlaneSight.Description=[[]]
objPerkasieInPlaneSight.Visible=true
objPerkasieInPlaneSight.Activity="Geocache"
objPerkasieInPlaneSight.StartingLocationDescription=[[]]
objPerkasieInPlaneSight.StartingLocation = ZonePoint(40.3942094387728,-75.2783907204868,0)
objPerkasieInPlaneSight.Version="1.5"
objPerkasieInPlaneSight.Company=""
objPerkasieInPlaneSight.Author="ggggeo2 & perkwhite"
objPerkasieInPlaneSight.BuilderVersion="URWIGO 1.14.4469.18959"
objPerkasieInPlaneSight.CreateDate="02/24/2012 16:20:49"
objPerkasieInPlaneSight.PublishDate="1/1/0001 12:00:00 AM"
objPerkasieInPlaneSight.UpdateDate="04/30/2012 23:26:11"
objPerkasieInPlaneSight.LastPlayedDate="1/1/0001 12:00:00 AM"
objPerkasieInPlaneSight.TargetDevice="PocketPC"
objPerkasieInPlaneSight.TargetDeviceVersion="0"
objPerkasieInPlaneSight.StateId="1"
objPerkasieInPlaneSight.CountryId="2"
objPerkasieInPlaneSight.Complete=false
objPerkasieInPlaneSight.UseLogging=true

objPerkasieInPlaneSight.Media=objTitle

objPerkasieInPlaneSight.Icon=objiconTitle


-- Zones --
objParkingArea = Wherigo.Zone(objPerkasieInPlaneSight)
objParkingArea.Id = "3439dcc6-8456-4c40-9426-78cdaf9e2a71"
objParkingArea.Name = "Parking Area"
objParkingArea.Description = ""
objParkingArea.Visible = true
objParkingArea.Media = objParkingLot
objParkingArea.Icon = objiconParking
objParkingArea.Commands = {}
objParkingArea.DistanceRange = Distance(-1, "feet")
objParkingArea.ShowObjects = "OnEnter"
objParkingArea.ProximityRange = Distance(60, "feet")
objParkingArea.AllowSetPositionTo = false
objParkingArea.Active = true
objParkingArea.Points = {
	ZonePoint(40.3945342401037, -75.2782116830351, 0), 
	ZonePoint(40.3944341442631, -75.2780400216582, 0), 
	ZonePoint(40.3939500051378, -75.2784825861456, 0), 
	ZonePoint(40.3940521444835, -75.2786730229857, 0)
}
objParkingArea.OriginalPoint = ZonePoint(40.394242633497, -75.2783518284562, 0)
objParkingArea.DistanceRangeUOM = "Feet"
objParkingArea.ProximityRangeUOM = "Feet"
objParkingArea.OutOfRangeName = ""
objParkingArea.InRangeName = ""
objCrashSite = Wherigo.Zone(objPerkasieInPlaneSight)
objCrashSite.Id = "6d4b6611-1abe-4d8b-b2ed-b34f55946efb"
objCrashSite.Name = "Crash Site"
objCrashSite.Description = ""
objCrashSite.Visible = false
objCrashSite.Media = objPlane
objCrashSite.Icon = objiconPlaneCrash
objCrashSite.Commands = {}
objCrashSite.DistanceRange = Distance(-1, "feet")
objCrashSite.ShowObjects = "OnEnter"
objCrashSite.ProximityRange = Distance(60, "feet")
objCrashSite.AllowSetPositionTo = false
objCrashSite.Active = false
objCrashSite.Points = {
	ZonePoint(40.3951537074824, -75.2778489142657, 0), 
	ZonePoint(40.3956664362687, -75.2786991745235, 0), 
	ZonePoint(40.3953109991986, -75.2790988236667, 0), 
	ZonePoint(40.3947809042188, -75.2782204002143, 0)
}
objCrashSite.OriginalPoint = ZonePoint(40.3952280117921, -75.2784668281676, 0)
objCrashSite.DistanceRangeUOM = "Feet"
objCrashSite.ProximityRangeUOM = "Feet"
objCrashSite.OutOfRangeName = ""
objCrashSite.InRangeName = ""
objCrashPiece1 = Wherigo.Zone(objPerkasieInPlaneSight)
objCrashPiece1.Id = "53a51bbb-fc82-4f5c-97da-6db41f901035"
objCrashPiece1.Name = "Crash Piece 1"
objCrashPiece1.Description = ""
objCrashPiece1.Visible = false
objCrashPiece1.Media = objZonePart1
objCrashPiece1.Icon = objiconZonePlaneParts
objCrashPiece1.Commands = {}
objCrashPiece1.DistanceRange = Distance(-1, "feet")
objCrashPiece1.ShowObjects = "OnEnter"
objCrashPiece1.ProximityRange = Distance(60, "feet")
objCrashPiece1.AllowSetPositionTo = false
objCrashPiece1.Active = false
objCrashPiece1.Points = {
	ZonePoint(40.3946282074922, -75.2769228816032, 0), 
	ZonePoint(40.3943994171, -75.277239382267, 0), 
	ZonePoint(40.3941379414142, -75.2769175171852, 0), 
	ZonePoint(40.3943953315502, -75.2766036987304, 0)
}
objCrashPiece1.OriginalPoint = ZonePoint(40.3943902243891, -75.2769208699465, 0)
objCrashPiece1.DistanceRangeUOM = "Feet"
objCrashPiece1.ProximityRangeUOM = "Feet"
objCrashPiece1.OutOfRangeName = ""
objCrashPiece1.InRangeName = ""
objCrashPiece2 = Wherigo.Zone(objPerkasieInPlaneSight)
objCrashPiece2.Id = "24f97473-ace4-4032-8479-419cdd3fec36"
objCrashPiece2.Name = "Crash Piece 2"
objCrashPiece2.Description = ""
objCrashPiece2.Visible = false
objCrashPiece2.Media = objZonePart2
objCrashPiece2.Icon = objiconZonePlaneParts
objCrashPiece2.Commands = {}
objCrashPiece2.DistanceRange = Distance(-1, "feet")
objCrashPiece2.ShowObjects = "OnEnter"
objCrashPiece2.ProximityRange = Distance(60, "feet")
objCrashPiece2.AllowSetPositionTo = false
objCrashPiece2.Active = false
objCrashPiece2.Points = {
	ZonePoint(40.3958364938571, -75.2780802547932, 0), 
	ZonePoint(40.3959907198885, -75.2778978645802, 0), 
	ZonePoint(40.3958814339292, -75.2777127921582, 0), 
	ZonePoint(40.3957261862803, -75.2778844535351, 0)
}
objCrashPiece2.OriginalPoint = ZonePoint(40.3958587084888, -75.2778938412667, 0)
objCrashPiece2.DistanceRangeUOM = "Feet"
objCrashPiece2.ProximityRangeUOM = "Feet"
objCrashPiece2.OutOfRangeName = ""
objCrashPiece2.InRangeName = ""
objCrashPiece3 = Wherigo.Zone(objPerkasieInPlaneSight)
objCrashPiece3.Id = "543ae011-2eb2-4d18-84bb-123ca99a4e76"
objCrashPiece3.Name = "Crash Piece 3"
objCrashPiece3.Description = ""
objCrashPiece3.Visible = false
objCrashPiece3.Media = objZoneParts34
objCrashPiece3.Icon = objiconZonePlaneParts
objCrashPiece3.Commands = {}
objCrashPiece3.DistanceRange = Distance(-1, "feet")
objCrashPiece3.ShowObjects = "OnEnter"
objCrashPiece3.ProximityRange = Distance(60, "feet")
objCrashPiece3.AllowSetPositionTo = false
objCrashPiece3.Active = false
objCrashPiece3.Points = {
	ZonePoint(40.3956454982161, -75.279654711485, 0), 
	ZonePoint(40.3955280407346, -75.2798210084441, 0), 
	ZonePoint(40.3956454982161, -75.2799578011037, 0), 
	ZonePoint(40.3957609127592, -75.2797941863537, 0)
}
objCrashPiece3.OriginalPoint = ZonePoint(40.3956449874815, -75.2798069268466, 0)
objCrashPiece3.DistanceRangeUOM = "Feet"
objCrashPiece3.ProximityRangeUOM = "Feet"
objCrashPiece3.OutOfRangeName = ""
objCrashPiece3.InRangeName = ""
objHouse1 = Wherigo.Zone(objPerkasieInPlaneSight)
objHouse1.Id = "f67e0f98-014f-406c-8579-2110abf00027"
objHouse1.Name = "House"
objHouse1.Description = ""
objHouse1.Visible = false
objHouse1.Media = objHouse
objHouse1.Icon = objiconHouse
objHouse1.Commands = {}
objHouse1.DistanceRange = Distance(-1, "feet")
objHouse1.ShowObjects = "OnEnter"
objHouse1.ProximityRange = Distance(60, "feet")
objHouse1.AllowSetPositionTo = false
objHouse1.Active = false
objHouse1.Points = {
	ZonePoint(40.395831387029, -75.2802126109601, 0), 
	ZonePoint(40.3956301776866, -75.2799752354622, 0), 
	ZonePoint(40.3954596088901, -75.2802501618863, 0), 
	ZonePoint(40.395660818742, -75.2804835140706, 0)
}
objHouse1.OriginalPoint = ZonePoint(40.3956454980869, -75.2802303805948, 0)
objHouse1.DistanceRangeUOM = "Feet"
objHouse1.ProximityRangeUOM = "Feet"
objHouse1.OutOfRangeName = ""
objHouse1.InRangeName = ""
objCrashPiece4 = Wherigo.Zone(objPerkasieInPlaneSight)
objCrashPiece4.Id = "4247dd51-3557-4292-ab7b-446d48506ad6"
objCrashPiece4.Name = "Crash Piece 4"
objCrashPiece4.Description = ""
objCrashPiece4.Visible = false
objCrashPiece4.Media = objZoneParts34
objCrashPiece4.Icon = objiconZonePlaneParts
objCrashPiece4.Commands = {}
objCrashPiece4.DistanceRange = Distance(-1, "feet")
objCrashPiece4.ShowObjects = "OnEnter"
objCrashPiece4.ProximityRange = Distance(60, "feet")
objCrashPiece4.AllowSetPositionTo = false
objCrashPiece4.Active = false
objCrashPiece4.Points = {
	ZonePoint(40.396039745308, -75.2819218486548, 0), 
	ZonePoint(40.3958487502434, -75.2821645885706, 0), 
	ZonePoint(40.3959621217108, -75.2823416143656, 0), 
	ZonePoint(40.3961582232575, -75.2820988744497, 0)
}
objCrashPiece4.OriginalPoint = ZonePoint(40.3960022101299, -75.2821317315102, 0)
objCrashPiece4.DistanceRangeUOM = "Feet"
objCrashPiece4.ProximityRangeUOM = "Feet"
objCrashPiece4.OutOfRangeName = ""
objCrashPiece4.InRangeName = ""
objSamWaiting = Wherigo.Zone(objPerkasieInPlaneSight)
objSamWaiting.Id = "be903ca3-5861-4232-82e9-c8ef965533bc"
objSamWaiting.Name = "Sam Waiting"
objSamWaiting.Description = ""
objSamWaiting.Visible = false
objSamWaiting.Media = objSamFull
objSamWaiting.Icon = objiconSam
objSamWaiting.Commands = {}
objSamWaiting.DistanceRange = Distance(-1, "feet")
objSamWaiting.ShowObjects = "OnEnter"
objSamWaiting.ProximityRange = Distance(60, "feet")
objSamWaiting.AllowSetPositionTo = false
objSamWaiting.Active = false
objSamWaiting.Points = {
	ZonePoint(40.3968690865773, -75.2796781808139, 0), 
	ZonePoint(40.3969865417194, -75.2795480936767, 0), 
	ZonePoint(40.3970896978056, -75.279699638486, 0), 
	ZonePoint(40.3969681574498, -75.2798270434142, 0)
}
objSamWaiting.OriginalPoint = ZonePoint(40.396978370888, -75.2796882390977, 0)
objSamWaiting.DistanceRangeUOM = "Feet"
objSamWaiting.ProximityRangeUOM = "Feet"
objSamWaiting.OutOfRangeName = ""
objSamWaiting.InRangeName = ""
objCodeCylinder1 = Wherigo.Zone(objPerkasieInPlaneSight)
objCodeCylinder1.Id = "6197e4a0-6b51-4f36-ae63-cfafcf48a530"
objCodeCylinder1.Name = "Code Cylinder 1"
objCodeCylinder1.Description = ""
objCodeCylinder1.Visible = false
objCodeCylinder1.Media = objCodeCylinder
objCodeCylinder1.Icon = objiconCodeCylinder
objCodeCylinder1.Commands = {}
objCodeCylinder1.DistanceRange = Distance(-1, "feet")
objCodeCylinder1.ShowObjects = "OnEnter"
objCodeCylinder1.ProximityRange = Distance(60, "feet")
objCodeCylinder1.AllowSetPositionTo = false
objCodeCylinder1.Active = false
objCodeCylinder1.Points = {
	ZonePoint(40.3945485394979, -75.28425604105, 0), 
	ZonePoint(40.3944719355679, -75.2841272950174, 0), 
	ZonePoint(40.3945975659674, -75.2839643508196, 0), 
	ZonePoint(40.3946782552873, -75.2840863913298, 0)
}
objCodeCylinder1.OriginalPoint = ZonePoint(40.3945740740801, -75.2841085195542, 0)
objCodeCylinder1.DistanceRangeUOM = "Feet"
objCodeCylinder1.ProximityRangeUOM = "Feet"
objCodeCylinder1.OutOfRangeName = ""
objCodeCylinder1.InRangeName = ""
objCodeCylinder2 = Wherigo.Zone(objPerkasieInPlaneSight)
objCodeCylinder2.Id = "4f09244e-11f9-4dab-81dc-9a6b3c74300a"
objCodeCylinder2.Name = "Code Cylinder 2"
objCodeCylinder2.Description = ""
objCodeCylinder2.Visible = false
objCodeCylinder2.Media = objCodeCylinder
objCodeCylinder2.Icon = objiconCodeCylinder
objCodeCylinder2.Commands = {}
objCodeCylinder2.DistanceRange = Distance(-1, "feet")
objCodeCylinder2.ShowObjects = "OnEnter"
objCodeCylinder2.ProximityRange = Distance(60, "feet")
objCodeCylinder2.AllowSetPositionTo = false
objCodeCylinder2.Active = false
objCodeCylinder2.Points = {
	ZonePoint(40.3929520955801, -75.2822282910349, 0), 
	ZonePoint(40.3930460651763, -75.2820821106434, 0), 
	ZonePoint(40.3931839551074, -75.2822725474835, 0), 
	ZonePoint(40.3930899857035, -75.2824200689795, 0)
}
objCodeCylinder2.OriginalPoint = ZonePoint(40.3930680253918, -75.2822507545353, 0)
objCodeCylinder2.DistanceRangeUOM = "Feet"
objCodeCylinder2.ProximityRangeUOM = "Feet"
objCodeCylinder2.OutOfRangeName = ""
objCodeCylinder2.InRangeName = ""
objCodeCylinder3 = Wherigo.Zone(objPerkasieInPlaneSight)
objCodeCylinder3.Id = "7f4ed830-a67a-42dc-8322-00e797640b5a"
objCodeCylinder3.Name = "Code Cylinder 3"
objCodeCylinder3.Description = ""
objCodeCylinder3.Visible = false
objCodeCylinder3.Media = objCodeCylinder
objCodeCylinder3.Icon = objiconCodeCylinder
objCodeCylinder3.Commands = {}
objCodeCylinder3.DistanceRange = Distance(-1, "feet")
objCodeCylinder3.ShowObjects = "OnEnter"
objCodeCylinder3.ProximityRange = Distance(60, "feet")
objCodeCylinder3.AllowSetPositionTo = false
objCodeCylinder3.Active = false
objCodeCylinder3.Points = {
	ZonePoint(40.3916783860522, -75.2797794342043, 0), 
	ZonePoint(40.3918040216636, -75.2795568108561, 0), 
	ZonePoint(40.391636507463, -75.2794052660468, 0), 
	ZonePoint(40.3915027000887, -75.2796278893949, 0)
}
objCodeCylinder3.OriginalPoint = ZonePoint(40.3916554038169, -75.2795923501255, 0)
objCodeCylinder3.DistanceRangeUOM = "Feet"
objCodeCylinder3.ProximityRangeUOM = "Feet"
objCodeCylinder3.OutOfRangeName = ""
objCodeCylinder3.InRangeName = ""
objSamsPackage = Wherigo.Zone(objPerkasieInPlaneSight)
objSamsPackage.Id = "7e1703c2-69d7-4c3e-9c62-78fca91709e9"
objSamsPackage.Name = "Sam's Package"
objSamsPackage.Description = ""
objSamsPackage.Visible = true
objSamsPackage.Media = objPackage
objSamsPackage.Icon = objiconPackage
objSamsPackage.Commands = {}
objSamsPackage.DistanceRange = Distance(-1, "feet")
objSamsPackage.ShowObjects = "OnEnter"
objSamsPackage.ProximityRange = Distance(60, "feet")
objSamsPackage.AllowSetPositionTo = false
objSamsPackage.Active = false
objSamsPackage.Points = {
	ZonePoint(40.3929255389315, -75.2773305773736, 0), 
	ZonePoint(40.3929949947602, -75.27758538723, 0), 
	ZonePoint(40.3931716982364, -75.2774995565416, 0), 
	ZonePoint(40.393101221183, -75.2772474288942, 0)
}
objSamsPackage.OriginalPoint = ZonePoint(40.3930483632778, -75.2774157375099, 0)
objSamsPackage.DistanceRangeUOM = "Feet"
objSamsPackage.ProximityRangeUOM = "Feet"
objSamsPackage.OutOfRangeName = ""
objSamsPackage.InRangeName = ""

-- Characters --
objSam = Wherigo.ZCharacter(objPerkasieInPlaneSight)
objSam.Id = "fbf3567a-fb65-4b59-a06f-e42230c36005"
objSam.Name = "Sam"
objSam.Description = ""
objSam.Visible = true
objSam.Media = objSamFull
objSam.Icon = objiconSam
objSam.Commands = {
	cmdTalk = Wherigo.ZCommand{
		Text = "Talk", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objSam.Commands.cmdTalk.Custom = true
objSam.Commands.cmdTalk.Id = "dcd357ee-e6ce-4ca0-a40f-ec6f8b3e403a"
objSam.Commands.cmdTalk.WorksWithAll = true
objSam.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objSam.Gender = "Male"
objSam.Type = "NPC"
objKaylee = Wherigo.ZCharacter{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objHouse1
}
objKaylee.Id = "a13d9237-6e3e-4468-af7e-678ea0bc9509"
objKaylee.Name = "Kaylee"
objKaylee.Description = ""
objKaylee.Visible = false
objKaylee.Media = objKayleeFull
objKaylee.Icon = objiconKaylee
objKaylee.Commands = {
	cmdTalk = Wherigo.ZCommand{
		Text = "Talk", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objKaylee.Commands.cmdTalk.Custom = true
objKaylee.Commands.cmdTalk.Id = "6d8e8a85-acee-46b6-b068-cca9e9253a67"
objKaylee.Commands.cmdTalk.WorksWithAll = true
objKaylee.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objKaylee.Gender = "Female"
objKaylee.Type = "NPC"

-- Items --
objSaveGame1 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = Player
}
objSaveGame1.Id = "19aca939-f525-4f4e-b8c5-9b2a6bf5a2e3"
objSaveGame1.Name = "Save Game"
objSaveGame1.Description = "Use this item to save your progress throughout the game"
objSaveGame1.Visible = false
objSaveGame1.Media = objSaveGame
objSaveGame1.Icon = objiconSave
objSaveGame1.Commands = {
	cmdSave = Wherigo.ZCommand{
		Text = "Save", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
objSaveGame1.Commands.cmdSave.Custom = true
objSaveGame1.Commands.cmdSave.Id = "728729e4-a0fb-4247-abd8-7a1be7fad583"
objSaveGame1.Commands.cmdSave.WorksWithAll = true
objSaveGame1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objSaveGame1.Locked = false
objSaveGame1.Opened = false
objPlane1 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objCrashSite
}
objPlane1.Id = "11e2ede9-ee84-4dec-ae02-fb7c306fa44f"
objPlane1.Name = "Plane"
objPlane1.Description = "A downed plane. It has seen better days, but is probably salvageable."
objPlane1.Visible = true
objPlane1.Media = objPlane
objPlane1.Icon = objiconPlaneCrash
objPlane1.Commands = {
	cmdInspect = Wherigo.ZCommand{
		Text = "Inspect", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objPlane1.Commands.cmdInspect.Custom = true
objPlane1.Commands.cmdInspect.Id = "cc22e314-a54e-4035-a944-1303a4bb671d"
objPlane1.Commands.cmdInspect.WorksWithAll = true
objPlane1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objPlane1.Locked = false
objPlane1.Opened = false
objGloves1 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objParkingArea
}
objGloves1.Id = "221349b8-7a77-4ec3-84b1-b1d65469fcd5"
objGloves1.Name = "Gloves"
objGloves1.Description = "Your handy heat-resistant gloves."
objGloves1.Visible = false
objGloves1.Media = objGloves
objGloves1.Icon = objiconGloves
objGloves1.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdPutOn = Wherigo.ZCommand{
		Text = "Put On", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdTakeOff = Wherigo.ZCommand{
		Text = "Take Off", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objGloves1.Commands.cmdTake.Custom = true
objGloves1.Commands.cmdTake.Id = "689781fe-b8ee-4aa6-905e-ba18232ab9be"
objGloves1.Commands.cmdTake.WorksWithAll = true
objGloves1.Commands.cmdPutOn.Custom = true
objGloves1.Commands.cmdPutOn.Id = "686fb78f-4ead-4caa-ba5b-4f2d45cf8ecc"
objGloves1.Commands.cmdPutOn.WorksWithAll = true
objGloves1.Commands.cmdTakeOff.Custom = true
objGloves1.Commands.cmdTakeOff.Id = "b04e0a1f-4c4a-4ab2-ba84-5d96dd6a6588"
objGloves1.Commands.cmdTakeOff.WorksWithAll = true
objGloves1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objGloves1.Locked = false
objGloves1.Opened = false
objFireExtinguisher1 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objCrashSite
}
objFireExtinguisher1.Id = "be164f74-6553-4586-9e8c-4f02e550deae"
objFireExtinguisher1.Name = "Fire Extinguisher"
objFireExtinguisher1.Description = "Red and shiny. You can use to put out fires."
objFireExtinguisher1.Visible = false
objFireExtinguisher1.Media = objFireExtinguisher
objFireExtinguisher1.Icon = objiconFireExtinguisher
objFireExtinguisher1.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdPutOutPlane = Wherigo.ZCommand{
		Text = "Put Out Plane", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdPutOutPlanePart = Wherigo.ZCommand{
		Text = "Put Out Plane Part", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objFireExtinguisher1.Commands.cmdTake.Custom = true
objFireExtinguisher1.Commands.cmdTake.Id = "06789734-6b31-4e8d-9e64-eb6a2e565ce9"
objFireExtinguisher1.Commands.cmdTake.WorksWithAll = true
objFireExtinguisher1.Commands.cmdPutOutPlane.Custom = true
objFireExtinguisher1.Commands.cmdPutOutPlane.Id = "8b3cf8f5-c4cc-479d-812e-6ec02f13928b"
objFireExtinguisher1.Commands.cmdPutOutPlane.WorksWithAll = true
objFireExtinguisher1.Commands.cmdPutOutPlanePart.Custom = true
objFireExtinguisher1.Commands.cmdPutOutPlanePart.Id = "994f7a51-97ab-4a34-af46-caac73e60d5e"
objFireExtinguisher1.Commands.cmdPutOutPlanePart.WorksWithAll = true
objFireExtinguisher1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objFireExtinguisher1.Locked = false
objFireExtinguisher1.Opened = false
objLadder1 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objHouse1
}
objLadder1.Id = "a8a6582c-8c2d-4a0c-80c6-61fa53cde1ca"
objLadder1.Name = "Ladder"
objLadder1.Description = "A collapsible aluminum ladder."
objLadder1.Visible = true
objLadder1.Media = objLadder
objLadder1.Icon = objiconLadder
objLadder1.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdSetUp = Wherigo.ZCommand{
		Text = "Set Up", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "You can't set up a ladder here!"
	}, 
	cmdClimb = Wherigo.ZCommand{
		Text = "Climb", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objLadder1.Commands.cmdTake.Custom = true
objLadder1.Commands.cmdTake.Id = "4bff5228-d281-4274-8526-7c77791d17f1"
objLadder1.Commands.cmdTake.WorksWithAll = true
objLadder1.Commands.cmdSetUp.Custom = true
objLadder1.Commands.cmdSetUp.Id = "eaae5d3a-1720-4db1-8d32-0230b4f346cc"
objLadder1.Commands.cmdSetUp.WorksWithAll = true
objLadder1.Commands.cmdClimb.Custom = true
objLadder1.Commands.cmdClimb.Id = "deb1e583-ec03-4360-a4c9-c030a3d888dc"
objLadder1.Commands.cmdClimb.WorksWithAll = true
objLadder1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objLadder1.Locked = false
objLadder1.Opened = false
objPlanePart1_1 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objCrashPiece1
}
objPlanePart1_1.Id = "d1b9e969-81ec-4dd1-98d3-fed2192d7f3a"
objPlanePart1_1.Name = "Plane Part 1"
objPlanePart1_1.Description = "A piece of Sam's plane. It looks like landing gear."
objPlanePart1_1.Visible = true
objPlanePart1_1.Media = objPlanePart1
objPlanePart1_1.Icon = objiconPlanePart1
objPlanePart1_1.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objPlanePart1_1.Commands.cmdTake.Custom = true
objPlanePart1_1.Commands.cmdTake.Id = "f19563d2-b7d7-46bf-a6b9-4298b983f2c6"
objPlanePart1_1.Commands.cmdTake.WorksWithAll = true
objPlanePart1_1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objPlanePart1_1.Locked = false
objPlanePart1_1.Opened = false
objPlanePart2 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objCrashPiece2
}
objPlanePart2.Id = "f87dbb04-a083-45b4-abbb-a1d7010f69a6"
objPlanePart2.Name = "Plane Part 2"
objPlanePart2.Description = "A piece of Sam's plane; perhaps part of the engine. It is on fire. You are not sure if you can pick it up while it is on fire."
objPlanePart2.Visible = true
objPlanePart2.Media = objPlanePart2Fire
objPlanePart2.Icon = objiconPlanePart2
objPlanePart2.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objPlanePart2.Commands.cmdTake.Custom = true
objPlanePart2.Commands.cmdTake.Id = "e6ca8519-f4a8-4142-8fdf-deaf24349537"
objPlanePart2.Commands.cmdTake.WorksWithAll = true
objPlanePart2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objPlanePart2.Locked = false
objPlanePart2.Opened = false
objPlanePart3_1 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objCrashPiece3
}
objPlanePart3_1.Id = "252d1d2d-42a7-481a-a242-389ab360e5c5"
objPlanePart3_1.Name = "Plane Part 3"
objPlanePart3_1.Description = "A piece of Sam's plane, probably a fuel tank. It looks really hot."
objPlanePart3_1.Visible = true
objPlanePart3_1.Media = objPlanePart3
objPlanePart3_1.Icon = objiconPlanePart3_1
objPlanePart3_1.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objPlanePart3_1.Commands.cmdTake.Custom = true
objPlanePart3_1.Commands.cmdTake.Id = "cac410a4-36d1-4313-b2ad-e86dd5de5e42"
objPlanePart3_1.Commands.cmdTake.WorksWithAll = true
objPlanePart3_1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objPlanePart3_1.Locked = false
objPlanePart3_1.Opened = false
objPlanePart4_1 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objCrashPiece4
}
objPlanePart4_1.Id = "3fc3ac5c-0ca4-462a-8ba6-bdfeea98ab21"
objPlanePart4_1.Name = "Plane Part 4"
objPlanePart4_1.Description = "A piece of Sam's plane, unfortunately stuck up in a tree. It looks like the propeller from down here."
objPlanePart4_1.Visible = true
objPlanePart4_1.Media = objPlanePart4
objPlanePart4_1.Icon = objiconPlanePart4
objPlanePart4_1.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objPlanePart4_1.Commands.cmdTake.Custom = true
objPlanePart4_1.Commands.cmdTake.Id = "f9d6de88-c44d-4eb7-9a21-60d831bfc44d"
objPlanePart4_1.Commands.cmdTake.WorksWithAll = true
objPlanePart4_1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objPlanePart4_1.Locked = false
objPlanePart4_1.Opened = false
objHandheldRadio1 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objParkingArea
}
objHandheldRadio1.Id = "7745b429-4846-45f9-af68-62b131633498"
objHandheldRadio1.Name = "Handheld Radio"
objHandheldRadio1.Description = "Your handheld radio, you can use it to talk to other radio operators."
objHandheldRadio1.Visible = false
objHandheldRadio1.Media = objHandheldRadio
objHandheldRadio1.Icon = objiconRadio
objHandheldRadio1.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdCallSam = Wherigo.ZCommand{
		Text = "Call Sam", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objHandheldRadio1.Commands.cmdTake.Custom = true
objHandheldRadio1.Commands.cmdTake.Id = "b15141a8-b0cc-4c8e-a362-bc039b0363ba"
objHandheldRadio1.Commands.cmdTake.WorksWithAll = true
objHandheldRadio1.Commands.cmdCallSam.Custom = true
objHandheldRadio1.Commands.cmdCallSam.Id = "3c7937b9-93a7-4b8d-b806-2f613c8f96de"
objHandheldRadio1.Commands.cmdCallSam.WorksWithAll = true
objHandheldRadio1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objHandheldRadio1.Locked = false
objHandheldRadio1.Opened = false
objCar1 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objParkingArea
}
objCar1.Id = "207bce6a-ac47-4ad1-81ce-7b793bc82c30"
objCar1.Name = "Car"
objCar1.Description = "Your cachemobile"
objCar1.Visible = true
objCar1.Media = objCar
objCar1.Icon = objiconCar
objCar1.Commands = {
	cmdSearch = Wherigo.ZCommand{
		Text = "Search", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objCar1.Commands.cmdSearch.Custom = true
objCar1.Commands.cmdSearch.Id = "78b1c5df-d2ab-4ca8-99b5-6fadf4a13002"
objCar1.Commands.cmdSearch.WorksWithAll = true
objCar1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objCar1.Locked = false
objCar1.Opened = false
objHouse2 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objHouse1
}
objHouse2.Id = "73916196-bd76-4dfb-8572-819fe218d0bd"
objHouse2.Name = "House"
objHouse2.Description = "A small house. Someone seems to be inside."
objHouse2.Visible = true
objHouse2.Media = objHouse
objHouse2.Icon = objiconHouse
objHouse2.Commands = {
	cmdKnockondoor = Wherigo.ZCommand{
		Text = "Knock on door", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}
}
objHouse2.Commands.cmdKnockondoor.Custom = true
objHouse2.Commands.cmdKnockondoor.Id = "4e55c6f3-0758-4209-9c6c-81cdf51bb6ad"
objHouse2.Commands.cmdKnockondoor.WorksWithAll = true
objHouse2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objHouse2.Locked = false
objHouse2.Opened = false
objCompletionCode1 = Wherigo.ZItem(objPerkasieInPlaneSight)
objCompletionCode1.Id = "fc50cfc9-5e4f-4dab-b085-4059b4ea9862"
objCompletionCode1.Name = "Completion Code"
objCompletionCode1.Description = "Use this to register completion of this cartridge on Wherigo.com"
objCompletionCode1.Visible = true
objCompletionCode1.Media = objCompletionCode
objCompletionCode1.Icon = objiconComplete
objCompletionCode1.Commands = {}
objCompletionCode1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objCompletionCode1.Locked = false
objCompletionCode1.Opened = false
objSpoilerPic = Wherigo.ZItem(objPerkasieInPlaneSight)
objSpoilerPic.Id = "bd057d57-76f1-4097-875c-47d018b1b49c"
objSpoilerPic.Name = "Spoiler Pic"
objSpoilerPic.Description = "A Spoiler Picture for a geocache"
objSpoilerPic.Visible = false
objSpoilerPic.Media = objRoute
objSpoilerPic.Icon = objiconSpoiler
objSpoilerPic.Commands = {}
objSpoilerPic.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objSpoilerPic.Locked = false
objSpoilerPic.Opened = false
objJournal1 = Wherigo.ZItem{
	Cartridge = objPerkasieInPlaneSight, 
	Container = objParkingArea
}
objJournal1.Id = "c0435137-25d9-4b14-bb91-b91a3ba8819b"
objJournal1.Name = "Journal"
objJournal1.Description = "Your journal; it probably has something that can help you if you get really stuck"
objJournal1.Visible = false
objJournal1.Media = objJournal
objJournal1.Icon = objiconJournal
objJournal1.Commands = {
	cmdTake = Wherigo.ZCommand{
		Text = "Take", 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = "Nothing available"
	}, 
	cmdRead = Wherigo.ZCommand{
		Text = "Read", 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = "Nothing available"
	}
}
objJournal1.Commands.cmdTake.Custom = true
objJournal1.Commands.cmdTake.Id = "3e467ba7-a963-4088-a16f-e37281147a5f"
objJournal1.Commands.cmdTake.WorksWithAll = true
objJournal1.Commands.cmdRead.Custom = true
objJournal1.Commands.cmdRead.Id = "66a0aa3a-f13f-4041-a194-a4137f4f2fea"
objJournal1.Commands.cmdRead.WorksWithAll = true
objJournal1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objJournal1.Locked = false
objJournal1.Opened = false

-- Tasks --
objTalktothedazedguy = Wherigo.ZTask(objPerkasieInPlaneSight)
objTalktothedazedguy.Id = "0bf72f2d-9bb9-43be-9e3b-32f28b6a142d"
objTalktothedazedguy.Name = "Talk to the dazed guy"
objTalktothedazedguy.Description = "See that dazed guy wandering around the parking lot? Go talk to him and see if he knows anything about the plane crash."
objTalktothedazedguy.Visible = false
objTalktothedazedguy.Media = objSamFull
objTalktothedazedguy.Icon = objiconSam
objTalktothedazedguy.Active = false
objTalktothedazedguy.Complete = false
objTalktothedazedguy.CorrectState = "None"
objFindalltheplanepieces = Wherigo.ZTask(objPerkasieInPlaneSight)
objFindalltheplanepieces.Id = "e7d59ccf-bba9-44da-9231-0b101835e060"
objFindalltheplanepieces.Name = "Find all the plane pieces"
objFindalltheplanepieces.Description = "Plance pieces are scattered all around the park. Practice some CITO and help Sam all at once!"
objFindalltheplanepieces.Visible = false
objFindalltheplanepieces.Media = objPlane
objFindalltheplanepieces.Icon = objiconPlaneCrash
objFindalltheplanepieces.Active = false
objFindalltheplanepieces.Complete = false
objFindalltheplanepieces.CorrectState = "None"
objGetsuppliesfromyourcar = Wherigo.ZTask(objPerkasieInPlaneSight)
objGetsuppliesfromyourcar.Id = "d533d512-b2ed-4641-81d8-df3867a5b50f"
objGetsuppliesfromyourcar.Name = "Get supplies from your car"
objGetsuppliesfromyourcar.Description = "A few things you will probably need on your adventure today are in your car; better grab everything."
objGetsuppliesfromyourcar.Visible = true
objGetsuppliesfromyourcar.Media = objCar
objGetsuppliesfromyourcar.Icon = objiconCar
objGetsuppliesfromyourcar.Active = false
objGetsuppliesfromyourcar.Complete = false
objGetsuppliesfromyourcar.CorrectState = "None"
objCheckouttheplanecrash = Wherigo.ZTask(objPerkasieInPlaneSight)
objCheckouttheplanecrash.Id = "0e8aa324-62cf-4362-b1f8-b7b98fa33fd5"
objCheckouttheplanecrash.Name = "Check out the plane crash"
objCheckouttheplanecrash.Description = "A plane crashed! Here, in the park! Better go check it out and see if you can help."
objCheckouttheplanecrash.Visible = false
objCheckouttheplanecrash.Media = objPlane
objCheckouttheplanecrash.Icon = objiconPlaneCrash
objCheckouttheplanecrash.Active = false
objCheckouttheplanecrash.Complete = false
objCheckouttheplanecrash.CorrectState = "None"
objGettheplanerunning = Wherigo.ZTask(objPerkasieInPlaneSight)
objGettheplanerunning.Id = "4cfee339-4646-4e5f-ae29-969398e95aea"
objGettheplanerunning.Name = "Get the plane running"
objGettheplanerunning.Description = "Help Sam fix his plane and get it back in the air."
objGettheplanerunning.Visible = false
objGettheplanerunning.Media = objPlaneFlying
objGettheplanerunning.Icon = objiconPlaneCrash
objGettheplanerunning.Active = false
objGettheplanerunning.Complete = false
objGettheplanerunning.CorrectState = "None"
objFindallthecodecylinders = Wherigo.ZTask(objPerkasieInPlaneSight)
objFindallthecodecylinders.Id = "77bc713c-1b23-48b3-9343-e49cf6a2e12c"
objFindallthecodecylinders.Name = "Find all the code cylinders"
objFindallthecodecylinders.Description = "Help Sam find all of the code cylinders that fell out of his plane"
objFindallthecodecylinders.Visible = false
objFindallthecodecylinders.Media = objCodeCylinder
objFindallthecodecylinders.Icon = objiconCodeCylinder
objFindallthecodecylinders.Active = false
objFindallthecodecylinders.Complete = false
objFindallthecodecylinders.CorrectState = "None"
objGetthebatterypack = Wherigo.ZTask(objPerkasieInPlaneSight)
objGetthebatterypack.Id = "5614fc30-eff7-41a5-8a87-cc829df692a7"
objGetthebatterypack.Name = "Get the battery pack"
objGetthebatterypack.Description = "Kaylee needs her battery pack and jumper cables to restart the plane. Go get them from behind her house."
objGetthebatterypack.Visible = false
objGetthebatterypack.Icon = objiconBatteryPack
objGetthebatterypack.Active = false
objGetthebatterypack.Complete = false
objGetthebatterypack.CorrectState = "None"
objFindthepackage = Wherigo.ZTask(objPerkasieInPlaneSight)
objFindthepackage.Id = "d04ae709-b9db-4e8d-bebb-aecf8db25123"
objFindthepackage.Name = "Find the package"
objFindthepackage.Description = "Find Sam's package and get the password inside"
objFindthepackage.Visible = false
objFindthepackage.Media = objPackage
objFindthepackage.Icon = objiconPackage
objFindthepackage.Active = false
objFindthepackage.Complete = false
objFindthepackage.CorrectState = "None"

-- Cartridge Variables --
objbolGlovesOn = false
objbolPartOnFire = true
objbolOKtoTakeLadder = false
objstrCodeCyl1 = "3435"
objstrCodeCyl2 = "4291"
objstrCodeCyl3 = "8773"
objnumSamStage = 0
objnumKayleeStage = 1
objbolClimbedLadder = false
objbolTalkedToKayleeAtCrashSite = false
objnumSamRadio = 1
objstrPassword = "NOTANLPC"
objstrPlayerName = ""
objnumPlanePartsHave = 0
currentZone = "objParkingArea"
currentCharacter = "objSam"
currentItem = "objSaveGame1"
currentTask = "objTalktothedazedguy"
currentInput = "objCodeCylinder1_1"
currentTimer = "dummy"
objPerkasieInPlaneSight.ZVariables = {
	objbolGlovesOn = false, 
	objbolPartOnFire = true, 
	objbolOKtoTakeLadder = false, 
	objstrCodeCyl1 = "3435", 
	objstrCodeCyl2 = "4291", 
	objstrCodeCyl3 = "8773", 
	objnumSamStage = 0, 
	objnumKayleeStage = 1, 
	objbolClimbedLadder = false, 
	objbolTalkedToKayleeAtCrashSite = false, 
	objnumSamRadio = 1, 
	objstrPassword = "NOTANLPC", 
	objstrPlayerName = "", 
	objnumPlanePartsHave = 0, 
	currentZone = "objParkingArea", 
	currentCharacter = "objSam", 
	currentItem = "objSaveGame1", 
	currentTask = "objTalktothedazedguy", 
	currentInput = "objCodeCylinder1_1", 
	currentTimer = "dummy"
}

-- Timers --

-- Inputs --
objCodeCylinder1_1 = Wherigo.ZInput(objPerkasieInPlaneSight)
objCodeCylinder1_1.Id = "9d196b3c-4b37-4cf0-851c-c9db6f3936d3"
objCodeCylinder1_1.Name = "Code Cylinder 1"
objCodeCylinder1_1.Description = ""
objCodeCylinder1_1.Visible = true
objCodeCylinder1_1.Media = objCodeCylinder
objCodeCylinder1_1.InputType = "Text"
objCodeCylinder1_1.Text = "What is the code?"
objCodeCylinder2_1 = Wherigo.ZInput(objPerkasieInPlaneSight)
objCodeCylinder2_1.Id = "450086a7-d572-4c2d-bd15-97aaf40fa329"
objCodeCylinder2_1.Name = "Code Cylinder 2"
objCodeCylinder2_1.Description = ""
objCodeCylinder2_1.Visible = true
objCodeCylinder2_1.Media = objCodeCylinder
objCodeCylinder2_1.InputType = "Text"
objCodeCylinder2_1.Text = "What is the code?"
objCodeCylinder3_1 = Wherigo.ZInput(objPerkasieInPlaneSight)
objCodeCylinder3_1.Id = "932b8692-70d3-4628-bbe5-2d5ec2385660"
objCodeCylinder3_1.Name = "Code Cylinder 3"
objCodeCylinder3_1.Description = ""
objCodeCylinder3_1.Visible = true
objCodeCylinder3_1.Media = objCodeCylinder
objCodeCylinder3_1.InputType = "Text"
objCodeCylinder3_1.Text = "What is the code?"
objFinalCode = Wherigo.ZInput(objPerkasieInPlaneSight)
objFinalCode.Id = "3b1c5105-5ef3-474c-a012-948a1e731a01"
objFinalCode.Name = "Final Code"
objFinalCode.Description = ""
objFinalCode.Visible = true
objFinalCode.Media = objPackage
objFinalCode.InputType = "Text"
objFinalCode.Text = "What is the passcode?"
objPlayerName = Wherigo.ZInput(objPerkasieInPlaneSight)
objPlayerName.Id = "646b2f40-74c6-424b-9c97-cfef5b4563e0"
objPlayerName.Name = "Player Name"
objPlayerName.Description = "Get the player's name"
objPlayerName.Visible = true
objPlayerName.Media = objYou
objPlayerName.InputType = "Text"
objPlayerName.Text = [[You: Hi, Sam, my name is:

(Enter your name)]]

-- WorksWithList for object commands --

-- functions --
function objPerkasieInPlaneSight:OnStart()
	_Urwigo.OldDialog{
		{
			Text = [[Welcome to Perkasie In Plane Sight! If you have not played a Wherigo before, you are in for a treat!

It's time to gear up for adventure. Check out your car, grab everything, and get started on your journey.]], 
			Media = objTitle
		}, 
		{
			Text = "If you are not sure what you should be doing, check your task list to keep you on the right path. It will show you the things you have done so far and the things you still need to do.", 
			Media = objRoute
		}, 
		{
			Text = "Your game will be automatically saved each time you enter a new area, so if the cartridge crashes, simply restart your app or device.", 
			Media = objSaveGame
		}
	}
	objGetsuppliesfromyourcar.Active = true
	objGetsuppliesfromyourcar.Visible = true
	objSpoilerPic:MoveTo(Player)
end
function objPerkasieInPlaneSight:OnRestore()
end
function objParkingArea:OnEnter()
	currentZone = "objParkingArea"
	objPerkasieInPlaneSight:RequestSync()
end
function objCrashSite:OnEnter()
	currentZone = "objCrashSite"
	objFireExtinguisher1.Commands.cmdPutOutPlane.Enabled = true
	objPerkasieInPlaneSight:RequestSync()
end
function objCrashSite:OnExit()
	currentZone = "objCrashSite"
	objFireExtinguisher1.Commands.cmdPutOutPlane.Enabled = false
end
function objCrashPiece1:OnEnter()
	currentZone = "objCrashPiece1"
	objPerkasieInPlaneSight:RequestSync()
end
function objCrashPiece2:OnEnter()
	currentZone = "objCrashPiece2"
	objFireExtinguisher1.Commands.cmdPutOutPlanePart.Enabled = true
	objPerkasieInPlaneSight:RequestSync()
end
function objCrashPiece2:OnExit()
	currentZone = "objCrashPiece2"
	objFireExtinguisher1.Commands.cmdPutOutPlanePart.Enabled = false
end
function objCrashPiece3:OnEnter()
	currentZone = "objCrashPiece3"
	objGloves1.Commands.cmdPutOn.Enabled = true
	objPerkasieInPlaneSight:RequestSync()
end
function objHouse1:OnEnter()
	currentZone = "objHouse1"
	objPerkasieInPlaneSight:RequestSync()
end
function objCrashPiece4:OnEnter()
	currentZone = "objCrashPiece4"
	if Player:Contains(objLadder1) and (objLadder1.Commands.cmdSetUp.Enabled == false) then
		objLadder1.Commands.cmdSetUp.Enabled = true
	end
	objPerkasieInPlaneSight:RequestSync()
end
function objCrashPiece4:OnExit()
	currentZone = "objCrashPiece4"
	if objbolClimbedLadder == true then
		objbolClimbedLadder = false
	end
	if objCrashPiece4:Contains(objLadder1) then
		_Urwigo.OldDialog{
			{
				Text = "As you leave the area you realize you did not grab the ladder again. You borrowed it from Kaylee; she is probably going to want it back, Maybe you should grab it.", 
				Media = objLadder
			}
		}
	end
	objbolOKtoTakeLadder = true
end
function objSamWaiting:OnEnter()
	currentZone = "objSamWaiting"
	objPerkasieInPlaneSight:RequestSync()
end
function objCodeCylinder1:OnEnter()
	currentZone = "objCodeCylinder1"
	_Urwigo.OldDialog{
		{
			Text = "Sam: Great, you've made it to the right spot!", 
			Media = objSamRadio
		}, 
		{
			Text = [[Sam: OK, you're looking for a small code cylinder. My readings indicate you'll find it in the center of an evergreen tree, about eye level. You won't need to go in the underbrush, you can reach it from the grassy area on the opposite side of the brushy area from the parking lot. See your inventory for a spoiler picture if you need it.
---
Radio me back once you've found it.]], 
			Media = objSamRadio
		}, 
		{
			Text = [[Your device beeps and lets you know that a geocache is located very close. In fact, it *is* the code cylinder! It is: 
GC3FMPQ - PIPS: Code 1
Difficulty: 1.5
Terrain: 1.5
Size: Micro
Coords: N 40 23.670 W 075 17.044]], 
			Media = objGeocacheAlert
		}
	}
	objSpoilerPic.Visible = true
	objSpoilerPic.Media = objSpoilerCodeCylinder1
	objSpoilerPic.Description = "A Spoiler Picture for PIPS: Code 1 - GC3FMPQ"
	objnumSamRadio = 3
	objPerkasieInPlaneSight:RequestSync()
end
function objCodeCylinder2:OnEnter()
	currentZone = "objCodeCylinder2"
	_Urwigo.OldDialog{
		{
			Text = "Sam: OK, you're there.", 
			Media = objSamRadio
		}, 
		{
			Text = [[Sam: Again, you're looking for a small code cylinder. My readings indicate you'll find it under the bridge, hanging from a bolt about 6 inches in from the side. It is on the first support beam on the south-west side. See your inventory for a spoiler picture if you need it.
---
Radio back to me once you have the code.]], 
			Media = objSamRadio
		}, 
		{
			Text = [[Your device beeps and lets you know that a geocache is located very close - the code cylinder again. It is: 
GC3FMPR - PIPS: Code 2
Difficulty: 1.5
Terrain: 1.5
Size: Micro
Coords: N 40 23.582 W 075 16.934]], 
			Media = objGeocacheAlert
		}
	}
	objSpoilerPic.Visible = true
	objSpoilerPic.Media = objSpoilerCodeCylinder2
	objSpoilerPic.Description = "A Spoiler Picture for PIPS: Code 2 - GC3FMPR"
	objnumSamRadio = 4
	objPerkasieInPlaneSight:RequestSync()
end
function objCodeCylinder3:OnEnter()
	currentZone = "objCodeCylinder3"
	_Urwigo.OldDialog{
		{
			Text = "Sam: Hey, you're in range.", 
			Media = objSamRadio
		}, 
		{
			Text = [[Sam: Look for the code cylinder. If you're heading south (back toward the parking lot,) it's in the second landscaping group on the left. If you're standing on the path, it's at the base of the second bush on the left of the tree at the center. See your inventory for a spoiler picture if you need it.
---
Let me know by radio once you have the final code.]], 
			Media = objSamRadio
		}, 
		{
			Text = [[Your device beeps and lets you know that a geocache is located very close - another code cylinder. It is: 
GC3FMPT - PIPS: Code 3
Difficulty: 1.5
Terrain: 1.5
Size: Micro
Coords: N 40 23.500 W 075 16.779]], 
			Media = objGeocacheAlert
		}
	}
	objSpoilerPic.Visible = true
	objSpoilerPic.Media = objSpoilerCodeCylinder3
	objSpoilerPic.Description = "A Spoiler Picture for PIPS: Code 3 - GC3FMPT"
	objnumSamRadio = 5
	objPerkasieInPlaneSight:RequestSync()
end
function objSamsPackage:OnEnter()
	currentZone = "objSamsPackage"
	_Urwigo.OldDialog{
		{
			Text = "Sam: You've almost made it to the package!", 
			Media = objSamRadio
		}, 
		{
			Text = [[Sam: Look for the package under a fallen tree, next to a big tree on a little hill, about 40-50 feet south of the trail. See your inventory for a spoiler picture if you need it.
---
When you've found the package, locate the passcode inside and give me a call back.]], 
			Media = objSamRadio
		}, 
		{
			Text = [[Your device beeps and lets you know that a geocache is located very close - Sam's package must be a geocache! It is: 
GC3EK8Y - Wherigo: Perkasie in Plane Sight
Difficulty: 2.0
Terrain: 2.0
Size: Regular
Coords: N 40 23.579 W 075 16.651]], 
			Media = objGeocacheAlert
		}
	}
	objSpoilerPic.Media = objSpoilerFinal
	objSpoilerPic.Description = "A Spoiler Picture for Wherigo: Perkasie in Plane Sight - GC3EK8Y"
	objnumSamRadio = 6
	objPerkasieInPlaneSight:RequestSync()
end
function objCodeCylinder1_1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(input, objstrCodeCyl1) then
		_Urwigo.OldDialog{
			{
				Text = "Sam: I'm entering those numbers...it took! You got it. I'm sending the coordinates to the next code cylinder to your device now. I'll radio back to you when you get near the spot. Good luck!", 
				Media = objSamRadio
			}
		}
		objCodeCylinder1.Active = false
		objCodeCylinder1.Visible = false
		objCodeCylinder2.Active = true
		objCodeCylinder2.Visible = true
		objnumSamRadio = 0
	else
		_Urwigo.OldDialog{
			{
				Text = "Sam: I'm entering those numbers...no good. Can you check the numbers and try again?", 
				Media = objSamRadio
			}
		}
	end
end
function objCodeCylinder2_1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(input, objstrCodeCyl2) then
		_Urwigo.OldDialog{
			{
				Text = "Sam: I'm entering those numbers...You got it again! I'm sending the coordinates to the next code cylinder to your device now. I'll radio back to you when you get near the spot. Good luck!", 
				Media = objSamRadio
			}
		}
		objCodeCylinder2.Active = false
		objCodeCylinder2.Visible = false
		objCodeCylinder3.Active = true
		objCodeCylinder3.Visible = true
		objnumSamRadio = 0
	else
		_Urwigo.OldDialog{
			{
				Text = "Sam: I'm entering those numbers...no good. Can you check the numbers and try again?", 
				Media = objSamRadio
			}
		}
	end
end
function objCodeCylinder3_1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(input, objstrCodeCyl3) then
		_Urwigo.OldDialog{
			{
				Text = [[Sam: I'm entering those numbers...that's the code! You got them all! 
---
I'm showing the package on the radar. We have the final coordinates! I'm sending them to your device. I'll radio back to you when you get near the spot. You're almost done!]], 
				Media = objSamRadio
			}, 
			{
				Text = "You have completed the task 'Find all the code cylinders'", 
				Media = objTaskComplete
			}
		}
		objFindallthecodecylinders.Complete = true
		objFindthepackage.Active = true
		objFindthepackage.Visible = true
		objCodeCylinder3.Active = false
		objCodeCylinder3.Visible = false
		objSamsPackage.Active = true
		objSamsPackage.Visible = true
		objnumSamRadio = 8
	else
		_Urwigo.OldDialog{
			{
				Text = "Sam: I'm entering those numbers...no good. Can you check the numbers and try again?", 
				Media = objSamRadio
			}
		}
	end
end
function objFinalCode:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(input, objstrPassword) then
		_Urwigo.OldDialog{
			{
				Text = "Sam: I'm checking the password now...", 
				Media = objSamRadio
			}, 
			{
				Text = "Sam: That's it! You've found it! I have entered the code and have everything I need. Thank you SOOOOO MUCH! I couldn't have got my plane back in the air, found the codes, and found my package without you.", 
				Media = objSamRadio
			}, 
			{
				Text = "Sam: I have sent a Completion Code to the inventory on your device. Thanks again for all your help.", 
				Media = objSamRadio
			}, 
			{
				Text = "You have completed the task 'Find the package' and completed the game. Congratulations!", 
				Media = objTaskComplete
			}
		}
		objFindthepackage.Complete = true
		objSamsPackage.Active = false
		objSamsPackage.Visible = false
		objPerkasieInPlaneSight.Complete = true
		objCompletionCode1.Description = ("You have completed this cartridge. The completion code is "..string.sub(Player.CompletionCode, 1, 15))..[[
Use this to register completion of this cartridge on Wherigo.com]]
		objCompletionCode1:MoveTo(Player)
		objnumSamRadio = 7
	else
		_Urwigo.OldDialog{
			{
				Text = "Sam: I'm checking the password now...", 
				Media = objSamRadio
			}, 
			{
				Text = "Sam: I put in that passcode, but it didn't work. Can you try again?", 
				Media = objSamRadio
			}
		}
	end
end
function objPlayerName:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objstrPlayerName = input
	objSam.Name = "Sam"
	_Urwigo.Dialog(false, {
		{
			Text = ("You: Hi, Sam, my name is "..objstrPlayerName)..". Are you ok? I saw your plane crash!", 
			Media = objYou
		}, 
		{
			Text = "Sam: Yeah...I think. I lost a few pieces of my plane circling the park and had to crash land. I think if I can find those pieces and find someone to fix my plane I will be able to get back in the air.", 
			Media = objSamCloseup
		}, 
		{
			Text = "Sam: It's critical that I get back up there; I lost three code cylinders and a very important package I was carrying. The code cyliders each contain a frequency I need to tune my plane's on-board equipment to locate the package.", 
			Media = objSamCloseup
		}
	}, function(action)
		_Urwigo.MessageBox{
			Text = ("Sam: "..objstrPlayerName)..", I need your help to fix my plane and find what is in that package. Will you help me?", 
			Media = objSamCloseup, 
			Buttons = {
				"Sure thing!", 
				"Sorry, I can't!"
			}, 
			Callback = function(action)
				if action ~= nil then
					objTalktothedazedguy.Complete = true
					if (action == "Button1") == true then
						_Urwigo.OldDialog{
							{
								Text = "Sam: That is great! Thank you! I think I know the area where some of the parts fell. I am marking the areas on your device.", 
								Media = objSamCloseup
							}, 
							{
								Text = "Sam: I'm going to try to recover a bit with a walk around the park. Come find me if you somehow manage to find the missing parts and figure out how to get the plane running.", 
								Media = objSamCloseup
							}, 
							{
								Text = "You have completed the task 'Talk to the dazed guy'", 
								Media = objTaskComplete
							}
						}
						objCrashPiece1.Active = true
						objCrashPiece1.Visible = true
						objCrashPiece2.Active = true
						objCrashPiece2.Visible = true
						objCrashPiece3.Active = true
						objCrashPiece3.Visible = true
						objnumSamStage = 2
						objSam:MoveTo(objSamWaiting)
						objFindalltheplanepieces.Active = true
						objFindalltheplanepieces.Visible = true
						objGettheplanerunning.Active = true
						objGettheplanerunning.Visible = true
					else
						_Urwigo.OldDialog{
							{
								Text = "Sam: Bummer, but I understand. It's a lot to ask. I guess I'm on my own. See you around...", 
								Media = objSamCloseup
							}, 
							{
								Text = "You have completed the task 'Talk to the dazed guy'", 
								Media = objTaskComplete
							}
						}
						objnumSamStage = 1
					end
				end
			end
		}
	end)
end
function objSam:OncmdTalk(target)
	if objnumSamStage == 0 then
		_Urwigo.Dialog(false, {
			{
				Text = "Dazed guy: Oh hi. My name is Sam. I could really use some help...", 
				Media = objSamCloseup
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(objPlayerName)
			end)
		end)
	elseif objnumSamStage == 1 then
		_Urwigo.MessageBox{
			Text = ("Sam: "..objstrPlayerName)..", Did you change your mind? Are you going to help me?", 
			Media = objSamCloseup, 
			Buttons = {
				"Sure thing!", 
				"Sorry, I can't!"
			}, 
			Callback = function(action)
				if action ~= nil then
					if (action == "Button1") == true then
						_Urwigo.OldDialog{
							{
								Text = "Sam: That is great, thank you! I think I know the area where some of the parts fell. I am marking the areas on your device.", 
								Media = objSamCloseup
							}, 
							{
								Text = "Sam: I'm going to try to recover with a walk around the park. Come find me if you somehow manage to find the missing parts and figure out how to get the plane running.", 
								Media = objSamCloseup
							}
						}
						objCrashPiece1.Active = true
						objCrashPiece1.Visible = true
						objCrashPiece2.Active = true
						objCrashPiece2.Visible = true
						objCrashPiece3.Active = true
						objCrashPiece3.Visible = true
						objnumSamStage = 2
						objSam:MoveTo(objSamWaiting)
						objFindalltheplanepieces.Active = true
						objFindalltheplanepieces.Visible = true
					else
						_Urwigo.OldDialog{
							{
								Text = "Sam: Sure, I understand.", 
								Media = objSamCloseup
							}
						}
					end
				end
			end
		}
	elseif objnumSamStage == 2 then
		_Urwigo.Dialog(false, {
			{
				Text = "Sam: Oh hi! I was wondering where you were. I found something in the rocks there, do you want to check it out? I think it might be one of those geocache things.", 
				Media = objSamCloseup
			}
		}, function(action)
			_Urwigo.MessageBox{
				Text = [[Your device beeps and lets you know that another geocache is located very close. It is: 
GC2PPG2 - Ridge Rd TB / Geocoin Hotel
Difficulty: 1.5
Terrain: 1.5
Size: Regular
---
Do you want to look for it now?]], 
				Media = objGeocacheAlert, 
				Buttons = {
					"Yes", 
					"No"
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							_Urwigo.OldDialog{
								{
									Text = "The coordinates for this geocache are N 40 23.822 W 075 16.779. You will find it up the hill slightly, in the big rock pile. See your inventory for a spoiler picture if you need it.", 
									Media = objGeocacheAlert
								}, 
								{
									Text = "Sam: Talk to me again when you are ready to move on.", 
									Media = objSamCloseup
								}
							}
							objSpoilerPic.Visible = true
							objSpoilerPic.Media = objSpoilerRidgeRd
							objSpoilerPic.Description = "A Spoiler Picture for Ridge Rd TB / Geocoin Hotel - GC2PPG2"
						else
							_Urwigo.OldDialog{
								{
									Text = "Sam: Just talk to me again when you are ready to continue.", 
									Media = objSamCloseup
								}
							}
						end
					end
				end
			}
		end)
		objnumSamStage = 3
	elseif objnumSamStage == 3 then
		if objFindalltheplanepieces.Complete == true then
			_Urwigo.OldDialog{
				{
					Text = "Sam: Great, it looks like you found all the pieces of my plane! Let's head back over to the crash site and see if we can get it running again.", 
					Media = objSamCloseup
				}
			}
			objSamWaiting.Active = false
			objSamWaiting.Visible = false
			objnumSamStage = 4
			objSam:MoveTo(objCrashSite)
		else
			_Urwigo.OldDialog{
				{
					Text = "Sam: It seems like we are still missing a few pieces of the plane. Would you mind terribly checking again and make sure you found all of the pieces? I think four pieces total fell off.", 
					Media = objSamCloseup
				}
			}
		end
	elseif objnumSamStage == 4 then
		_Urwigo.OldDialog{
			{
				Text = "Sam: Who is that person messing around with my plane? Let's talk to her and find out what on earth she is doing!", 
				Media = objSamCloseup
			}
		}
	end
end
function objKaylee:OncmdTalk(target)
	if objnumKayleeStage == 1 then
		objbolOKtoTakeLadder = true
		objCrashPiece4.Active = true
		objCrashPiece4.Visible = true
		_Urwigo.OldDialog{
			{
				Text = "You: Hi there. Did you hear the plane go down across the field a few minutes ago?", 
				Media = objYou
			}, 
			{
				Text = "Girl in coveralls: I heard something, but I just figured it was a plane landing at the airport nearby.", 
				Media = objKayleeCloseup
			}, 
			{
				Text = ("You: I'm "..objstrPlayerName)..", and a plane crashed just over those trees. I'm rounding up a few pieces of it that fell in the park, to help the pilot. I still haven't figured out what to do once I have all of them.", 
				Media = objYou
			}, 
			{
				Text = "Kaylee: Well, golly! I am a mechanic! I bet if you can find all the pieces of the plane, I can get it running again. I'll head over there now and assess the situation.", 
				Media = objKayleeCloseup
			}, 
			{
				Text = "Kaylee: You know, I saw something fall out of the sky and land in a tree a little to the north. I'll mark the spot in your device. You can borrow my ladder to get it out of the tree, but please bring it back to me!", 
				Media = objKayleeCloseup
			}
		}
		objHouse2.Description = "Kaylee's house"
		objnumKayleeStage = 2
		objKaylee:MoveTo(objCrashSite)
		objKaylee.Name = "Kaylee"
	elseif objnumKayleeStage == 2 then
		if not Player:Contains(objLadder1) then
			_Urwigo.OldDialog{
				{
					Text = [[Kaylee peers out from under the plane at you.

Kaylee: I'm going to need my ladder to fix this plane. Can you please bring it to me?]], 
					Media = objKayleeCloseup
				}
			}
		elseif objFindalltheplanepieces.Complete == true then
			objGettheplanerunning.Complete = true
			objPlanePart4_1:MoveTo(objKaylee)
			objPlanePart3_1:MoveTo(objKaylee)
			objPlanePart2:MoveTo(objKaylee)
			objPlanePart1_1:MoveTo(objKaylee)
			objLadder1:MoveTo(objKaylee)
			_Urwigo.Dialog(false, {
				{
					Text = ("Kaylee: Hey, there you are, "..objstrPlayerName).."! I think I can fix this plane, but I need the missing pieces. Do you have them?", 
					Media = objKayleeCloseup
				}, 
				{
					Text = [[Sam: Hello! I'm Sam, the pilot of this craft. We have all the parts right here! You think you can get my airplane running again?

You give all the plane parts you have collected to Kaylee.]], 
					Media = objSamCloseup
				}, 
				{
					Text = "Kaylee: Well, Sam, I think I can. Just give me a few minutes to get everything back in place, and we will go from there, ok?", 
					Media = objKayleeCloseup
				}, 
				{
					Text = [[Kaylee: Are you done with my ladder? I think I'm going to need it here to get some of these parts back on.
---
She takes her ladder, sets it up against the plane and gets to work.]], 
					Media = objKayleeCloseup
				}, 
				{
					Text = [[

A short time passes....]]
				}, 
				{
					Text = [[Kaylee: Well, it's all fixed! Let's fire her up!
...
She starts up the engine and it roars to life!]], 
					Media = objKayleeCloseup
				}, 
				{
					Text = "Sam: WOW!!! You did it! I am eternally grateful to both of you!", 
					Media = objSamCloseup
				}, 
				{
					Text = [[Kaylee: No problem, glad to help! Hey, listen, I need to be going. Firefly is on, and it's my favorite show so I'm going to go back to my house. It was nice meeting both of you, best of luck!

She grabs all of her equipment and heads home.]], 
					Media = objKayleeCloseup
				}, 
				{
					Text = "You have completed the task 'Get the plane running'", 
					Media = objTaskComplete
				}, 
				{
					Text = ([[Sam turns to you.

Sam: You've been such a great help to me, ]]..objstrPlayerName)..", but I need to ask you for more help. I am missing the very important package that fell out of my plane when I crash landed. ", 
					Media = objSamCloseup
				}, 
				{
					Text = "Sam: I'm going to take off so that I can use the on-board radar to find the code cylinders. I had the radar tuned to the frequency of the first one. ", 
					Media = objSamCloseup
				}, 
				{
					Text = "Sam: When we find that one we can use the code to locate the frequency of the next cylinders in turn. Once we've found all three, we can enter all the frequencies to locate my package.", 
					Media = objSamCloseup
				}
			}, function(action)
				_Urwigo.MessageBox{
					Text = "Sam: So I know you've helped so much, but will you help me find my lost package?", 
					Media = objSamCloseup, 
					Buttons = {
						"Yes, of course!", 
						"Nope, too busy"
					}, 
					Callback = function(action)
						if action ~= nil then
							if action == "Button1" then
								_Urwigo.OldDialog{
									{
										Text = [[Sam: Oh thank you, I was really hoping you'd help. I'm going to take off and I will radio the location of the first code cylinder to you.
I'm going to take my fire extinguisher back, if you don't mind.]], 
										Media = objSamCloseup
									}, 
									{
										Text = [[Sam takes the fire extinguisher, gets in the plane and takes off.
---
If a few minutes, your radio buzzes and crackles. You hear Sam come over the speaker.]], 
										Media = objPlaneFlying
									}, 
									{
										Text = "Sam: Alright, I think I've located the cylinder, It's in the north east section of the park. I'm sending the coordinates to your device now. I will call you on the radio when you're close.", 
										Media = objSamRadio
									}
								}
								objnumSamRadio = 2
								objCodeCylinder1.Active = true
								objCodeCylinder1.Visible = true
								objFindallthecodecylinders.Active = true
								objFindallthecodecylinders.Visible = true
							else
								_Urwigo.OldDialog{
									{
										Text = [[Sam: Well, I guess I am asking a lot. Thanks anyway for all of your help. Radio me if you change your mind.
I'm going to take my fire extinguisher back, if you don't mind.]], 
										Media = objSamCloseup
									}, 
									{
										Text = "Sam takes the fire extinguisher, gets in the plane and takes off.", 
										Media = objPlaneFlying
									}
								}
								objnumSamRadio = 1
							end
						end
					end
				}
			end)
			objFireExtinguisher1:MoveTo(objSam)
			objCrashSite.Visible = false
			objCrashSite.Active = false
			objHandheldRadio1.Commands.cmdCallSam.Enabled = true
		else
			if objbolTalkedToKayleeAtCrashSite == false then
				_Urwigo.OldDialog{
					{
						Text = "Kaylee: Hey, there you are! I think I can fix this plane, but there are some parts I need first.", 
						Media = objKayleeCloseup
					}, 
					{
						Text = "Kaylee: I can't do much to fix this until I have all the parts. Can you go try to round them up and then come back here?", 
						Media = objKayleeCloseup
					}, 
					{
						Text = "You: Sure, I will go find the last parts and come back here.", 
						Media = objYou
					}, 
					{
						Text = "Kaylee: Great, see you in a few!", 
						Media = objKayleeCloseup
					}
				}
				objbolTalkedToKayleeAtCrashSite = true
			else
				_Urwigo.OldDialog{
					{
						Text = "Kaylee: Hi again! I'm still missing a few parts. I can't finish here until I have them all."
					}
				}
			end
		end
	elseif objnumKayleeStage == 4 then
		objGettheplanerunning.Complete = true
		_Urwigo.Dialog(false, {
			{
				Text = [[Kaylee: Well, it's all fixed! Now, let me just attach the battery pack....
...
She connects the battery to the plane with the jumper cables, waits a few minutes, and starts up the engine. It roars to life!]], 
				Media = objKayleeCloseup
			}, 
			{
				Text = "Sam: WOW!!! You did it! I am eternally grateful to both of you!", 
				Media = objSamCloseup
			}, 
			{
				Text = [[Kaylee: No problem, glad to help! Hey, listen, I need to be going. Firefly is on, and it's my favorite show so I'm going to go back to my house. It was nice meeting both of you, best of luck!

She grabs all of her equipment and heads home.]], 
				Media = objKayleeCloseup
			}, 
			{
				Text = "You have completed the task 'Get the plane running'", 
				Media = objTaskComplete
			}, 
			{
				Text = ([[Sam turns to you.

Sam: You've been such a great help to me, ]]..objstrPlayerName)..", but I need to ask you for more help. I am missing the very important package that fell out of my plane when I crash landed. ", 
				Media = objSamCloseup
			}, 
			{
				Text = "Sam: I'm going to take off so that I can use the on-board radar to find the code cylinders. I had the radar tuned to the frequency of the first one. ", 
				Media = objSamCloseup
			}, 
			{
				Text = "Sam: When we find that one we can use the code to locate the frequency of the next cylinders in turn. Once we've found all three, we can enter all the frequencies to locate my package.", 
				Media = objSamCloseup
			}
		}, function(action)
			_Urwigo.MessageBox{
				Text = "Sam: So I know you've helped so much, but will you help me find my lost package?", 
				Media = objSamCloseup, 
				Buttons = {
					"Yes, of course!", 
					"Nope, too busy"
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							_Urwigo.OldDialog{
								{
									Text = [[Sam: Oh thank you, I was really hoping you'd help. I'm going to take off and I will radio the location of the first code cylinder to you.
I'm going to take my fire extinguisher back, if you don't mind.]], 
									Media = objSamCloseup
								}, 
								{
									Text = [[Sam takes the fire extinguisher, gets in the plane and takes off.
---
If a few minutes, your radio buzzes and crackles. You hear Sam come over the speaker.]], 
									Media = objPlaneFlying
								}, 
								{
									Text = "Sam: Alright, I think I've located the cylinder, It's in the north east section of the park. I'm sending the coordinates to your device now. I will call you on the radio when you're close.", 
									Media = objSamRadio
								}
							}
							objnumSamRadio = 2
							objCodeCylinder1.Active = true
							objCodeCylinder1.Visible = true
							objFindallthecodecylinders.Active = true
							objFindallthecodecylinders.Visible = true
						else
							_Urwigo.OldDialog{
								{
									Text = [[Sam: Well, I guess I am asking a lot. Thanks anyway for all of your help. Radio me if you change your mind.
I'm going to take my fire extinguisher back, if you don't mind.]], 
									Media = objSamCloseup
								}, 
								{
									Text = "Sam takes the fire extinguisher, gets in the plane and takes off.", 
									Media = objPlaneFlying
								}
							}
							objnumSamRadio = 1
						end
						objFireExtinguisher1:MoveTo(objSam)
						objHandheldRadio1.Commands.cmdCallSam.Enabled = true
						objCrashSite.Active = false
						objCrashSite.Visible = false
					end
				end
			}
		end)
	end
end
function objSaveGame1:OncmdSave(target)
	_Urwigo.OldDialog{
		{
			Text = "Your game has been saved", 
			Media = objSaveGame
		}
	}
	objPerkasieInPlaneSight:RequestSync()
end
function objPlane1:OncmdInspect(target)
	_Urwigo.OldDialog{
		{
			Text = [[You look at the plane. It is obviously damaged but probably not a total loss. You peek inside to see if anyone is inside, but no one is.
A fire extinguisher is here; you have a feeling you might need it.]], 
			Media = objPlane
		}, 
		{
			Text = "You turn around and see a guy walking away in somewhat of a daze. He has circled around and is headed back to the parking lot. You decide to catch up to him to see if he knows anything about what happened here.", 
			Media = objSamFull
		}, 
		{
			Text = "You have completed the task 'Check out the plane crash'", 
			Media = objTaskComplete
		}
	}
	objCheckouttheplanecrash.Complete = true
	objTalktothedazedguy.Active = true
	objTalktothedazedguy.Visible = true
	objFireExtinguisher1.Commands.cmdPutOutPlane.Enabled = false
	objFireExtinguisher1.Visible = true
	objPlane1.Commands.cmdInspect.Enabled = false
	objSam:MoveTo(objParkingArea)
	objSam.Name = "Dazed Guy"
end
function objGloves1:OncmdTake(target)
	_Urwigo.MessageBox{
		Text = "You take the gloves", 
		Media = objGloves, 
		Buttons = {
			"OK"
		}, 
		Callback = function(action)
			if action ~= nil then
				objGloves1:MoveTo(Player)
				objGloves1.Commands.cmdTake.Enabled = false
				objPlaneCrash()
			end
		end
	}
end
function objGloves1:OncmdPutOn(target)
	_Urwigo.OldDialog{
		{
			Text = "You put the gloves on", 
			Media = objGloves
		}
	}
	objbolGlovesOn = true
	objGloves1.Commands.cmdPutOn.Enabled = false
	objGloves1.Commands.cmdTakeOff.Enabled = true
end
function objGloves1:OncmdTakeOff(target)
	_Urwigo.OldDialog{
		{
			Text = "You take the gloves off", 
			Media = objGloves
		}
	}
	objbolGlovesOn = false
	objGloves1.Commands.cmdPutOn.Enabled = true
	objGloves1.Commands.cmdTakeOff.Enabled = false
end
function objFireExtinguisher1:OncmdTake(target)
	objFireExtinguisher1:MoveTo(Player)
	_Urwigo.OldDialog{
		{
			Text = "You take the fire extinguisher", 
			Media = objFireExtinguisher
		}
	}
	objFireExtinguisher1.Commands.cmdTake.Enabled = false
	objFireExtinguisher1.Commands.cmdPutOutPlane.Enabled = true
end
function objFireExtinguisher1:OncmdPutOutPlane(target)
	_Urwigo.OldDialog{
		{
			Text = "The plane is not on fire. It has many problems, but being on fire is not one of them.", 
			Media = objPlane
		}
	}
end
function objFireExtinguisher1:OncmdPutOutPlanePart(target)
	_Urwigo.OldDialog{
		{
			Text = "Wow, that piece is really burning! You decide to put it out. You raise the fire extinguisher, pull the pin, and hose that sucker down!", 
			Media = objPlanePart2Fire
		}, 
		{
			Text = "You now see a piece of plane covered in white fire extinguisher foam.", 
			Media = objPlanePart2Foam
		}
	}
	objPlanePart2.Description = "A piece of the plane, slightly burned and coated with fire extinguisher foam.  It is probably still usable..."
	objPlanePart2.Media = objPlanePart2Foam
	objFireExtinguisher1.Commands.cmdPutOutPlanePart.Enabled = false
	objbolPartOnFire = false
end
function objLadder1:OncmdTake(target)
	if objbolOKtoTakeLadder == true then
		objLadder1:MoveTo(Player)
		_Urwigo.OldDialog{
			{
				Text = "You take the ladder", 
				Media = objLadder
			}
		}
		if Player:Contains(objPlanePart4_1) then
			objCrashPiece4.Active = false
			objCrashPiece4.Visible = false
		elseif objHouse1:Contains(Player) then
			objHouse1.Visible = false
			objHouse1.Active = false
		end
		if objCrashPiece4:Contains(Player) then
			objLadder1.Commands.cmdSetUp.Enabled = true
		end
		objLadder1.Commands.cmdTake.Enabled = false
		objLadder1.Commands.cmdClimb.Enabled = false
		objbolClimbedLadder = false
	else
		if objHouse2.Commands.cmdKnockondoor.Enabled == true then
			_Urwigo.OldDialog{
				{
					Text = "That ladder looks really nice. You really want it. But you know it does not belong to you and you just would not feel right taking it. You decide to leave it where it is, even as you stare at it longingly.", 
					Media = objLadder
				}
			}
		else
			_Urwigo.OldDialog{
				{
					Text = "You start to take the ladder, but the woman in coveralls steps in front of you.", 
					Media = objLadder
				}, 
				{
					Text = "Kaylee: Excuse me??? That is my ladder, you can't just take things that don't belong to you!", 
					Media = objKayleeFull
				}, 
				{
					Text = "You stop in your tracks, not sure what to do. You know you should not take the ladder with this woman in your path.", 
					Media = objLadder
				}
			}
		end
	end
end
function objLadder1:OncmdSetUp(target)
	if objCrashPiece4:Contains(Player) then
		_Urwigo.OldDialog{
			{
				Text = "You carefully set the ladder up against the tree in which the piece of plane has landed.", 
				Media = objLadder
			}
		}
		objLadder1:MoveTo(objCrashPiece4)
		objLadder1.Commands.cmdTake.Enabled = true
		objLadder1.Commands.cmdSetUp.Enabled = false
		objLadder1.Commands.cmdClimb.Enabled = true
	else
		_Urwigo.OldDialog{
			{
				Text = "You look around to see what you can prop the ladder against but you do not see anything sturdy enough.", 
				Media = objLadder
			}
		}
	end
end
function objLadder1:OncmdClimb(target)
	objbolClimbedLadder = true
	_Urwigo.OldDialog{
		{
			Text = "You climb up the ladder slowly. You get just about to the top and you are pretty sure you can reach that plane piece from here.", 
			Media = objLadder
		}
	}
end
function objPlanePart1_1:OncmdTake(target)
	_Urwigo.MessageBox{
		Text = "You take the landing gear", 
		Media = objPlanePart1, 
		Buttons = {
			"OK"
		}, 
		Callback = function(action)
			if action ~= nil then
				objnumPlanePartsHave = objnumPlanePartsHave + 1
				objPlanePart1_1:MoveTo(Player)
				objPlanePart1_1.Media = objPlanePart1Inventory
				objPlanePart1_1.Commands.cmdTake.Enabled = false
				objCrashPiece1.Active = false
				objCrashPiece1.Visible = false
				_Urwigo.MessageBox{
					Text = [[Your device beeps and lets you know that a geocache is located very close. It is: 
GCJVX1 - "Art's Imports" Cache
Difficulty: 1.5
Terrain: 1.5
Size: Regular
---
Do you want to look for it now?]], 
					Media = objGeocacheAlert, 
					Buttons = {
						"Yes", 
						"No"
					}, 
					Callback = function(action)
						if action ~= nil then
							if action == "Button1" then
								_Urwigo.Dialog(false, {
									{
										Text = [[The coordinates for this geocache are N 40 23.662 W 075 16.617. You will find it in an old stump, out by itself.  See your inventory for a spoiler picture if you need it.
---
When you are ready, continue playing this Wherigo.]], 
										Media = objGeocacheAlert
									}
								}, function(action)
									objSpoilerPic.Visible = true
									objSpoilerPic.Media = objSpoilerArtsImports
									objSpoilerPic.Description = "A Spoiler Picture for \"Art's Imports\" Cache - GCJVX1"
									objCheckAllPlaneParts()
								end)
							else
								_Urwigo.Dialog(false, {
									{
										Text = "You take the landing gear and continue on your way.", 
										Media = objPlanePart1Inventory
									}
								}, function(action)
									objCheckAllPlaneParts()
								end)
							end
						end
					end
				}
			end
		end
	}
end
function objPlanePart2:OncmdTake(target)
	if objbolPartOnFire == false then
		_Urwigo.MessageBox{
			Text = "You take the engine part", 
			Media = objPlanePart2Foam, 
			Buttons = {
				"OK"
			}, 
			Callback = function(action)
				if action ~= nil then
					objnumPlanePartsHave = objnumPlanePartsHave + 1
					objPlanePart2:MoveTo(Player)
					objPlanePart2.Media = objPlanePart2Inventory
					objPlanePart2.Description = "A piece of Sam's plane; perhaps part of the engine."
					objPlanePart2.Commands.cmdTake.Enabled = false
					objCrashPiece2.Active = false
					objCrashPiece2.Visible = false
					_Urwigo.MessageBox{
						Text = [[Your device beeps and lets you know that another geocache is located very close. It is: 
GC3FMPM - PIPS: Part 2
Difficulty: 1.5
Terrain: 1.5
Size: Micro
---
Do you want to look for it now?]], 
						Media = objGeocacheAlert, 
						Buttons = {
							"Yes", 
							"No"
						}, 
						Callback = function(action)
							if action ~= nil then
								if action == "Button1" then
									_Urwigo.Dialog(false, {
										{
											Text = [[The coordinates for this geocache are N 40 23.755 W 075 16.670. You will find it in an tree with three trunks, about 20 feet from the paved trail. The micro cache is hidden near the base of the tree, facing away from the trail.  See your inventory for a spoiler picture if you need it.
---
When you are ready, continue playing this Wherigo.]], 
											Media = objGeocacheAlert
										}
									}, function(action)
										objSpoilerPic.Visible = true
										objSpoilerPic.Media = objSpoilerPart2
										objSpoilerPic.Description = "A Spoiler Picture for PIPS: Part 2 - GC3FMPM"
										objCheckAllPlaneParts()
									end)
								else
									_Urwigo.Dialog(false, {
										{
											Text = "You take the engine part and continue on your way.", 
											Media = objPlanePart2Inventory
										}
									}, function(action)
										objCheckAllPlaneParts()
									end)
								end
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.OldDialog{
			{
				Text = "Are you crazy? That piece is on fire! You should do something about that before you try to take it!", 
				Media = objPlanePart2Fire
			}
		}
	end
end
function objPlanePart3_1:OncmdTake(target)
	if objbolGlovesOn == true then
		_Urwigo.MessageBox{
			Text = "With the gloves on you barely notice the heat and you take the fuel tank.", 
			Media = objPlanePart3, 
			Buttons = {
				"OK"
			}, 
			Callback = function(action)
				if action ~= nil then
					objnumPlanePartsHave = objnumPlanePartsHave + 1
					objPlanePart3_1:MoveTo(Player)
					objPlanePart3_1.Commands.cmdTake.Enabled = false
					objPlanePart3_1.Media = objPlanePart3Inventory
					objPlanePart3_1.Description = "A piece of Sam's plane, probably a fuel tank."
					objCrashPiece3.Active = false
					objCrashPiece3.Visible = false
					_Urwigo.Dialog(false, {
						{
							Text = "Out of the corner of your eye you think you see someone going into the house nearby. Maybe they can help? You decide to go find out.", 
							Media = objHouse
						}
					}, function(action)
						objKaylee.Name = "Girl in coveralls"
						objHouse1.Active = true
						objHouse1.Visible = true
						_Urwigo.MessageBox{
							Text = [[Your device beeps and lets you know that another geocache is located very close. It is: 
GC3FMPP - PIPS: Part 3
Difficulty: 1.5
Terrain: 1.5
Size: Micro
---
Do you want to look for it now?]], 
							Media = objGeocacheAlert, 
							Buttons = {
								"Yes", 
								"No"
							}, 
							Callback = function(action)
								if action ~= nil then
									if action == "Button1" then
										_Urwigo.Dialog(false, {
											{
												Text = [[The coordinates for this geocache are N 40 23.735 W 075 16.790. You will find it in tree with 8-10 trunks, next to a grassy path through the trees.  It will be in a knot in the tree about 3-4 feet high on the side opposite the house nearby. See your inventory for a spoiler picture if you need it.
---
When you are ready, continue playing this Wherigo.]], 
												Media = objGeocacheAlert
											}
										}, function(action)
											objSpoilerPic.Visible = true
											objSpoilerPic.Media = objSpoilerPart3
											objSpoilerPic.Description = "A Spoiler Picture for PIPS: Part 3 - GC3FMPP"
										end)
									else
										_Urwigo.OldDialog{
											{
												Text = "You take the fuel tank and continue on your way.", 
												Media = objPlanePart3Inventory
											}
										}
									end
								end
							end
						}
					end)
				end
			end
		}
	else
		_Urwigo.OldDialog{
			{
				Text = "You take the fuel tank...ow...oww...OWW...OUCH! Too hot, too hot! You drop the part as you wave you hands around wildly trying to cool them off. It is too hot to handle with your bare hands!", 
				Media = objPlanePart3
			}
		}
	end
end
function objPlanePart4_1:OncmdTake(target)
	if objbolClimbedLadder == true then
		objnumPlanePartsHave = objnumPlanePartsHave + 1
		_Urwigo.Dialog(false, {
			{
				Text = "You stretch ever so carefully...and you are just able to reach the propeller. You gently lift it out of the tree. Then, you carefully start to climb back down the ladder, propeller in hand.", 
				Media = objPlanePart4
			}, 
			{
				Text = "As you climb down, you look around and see Sam standing off in the distance. Now that you have all of the plane pieces, maybe you should go let him know.", 
				Media = objSamFull
			}
		}, function(action)
			_Urwigo.MessageBox{
				Text = [[Your device beeps and lets you know that another geocache is located very close. It is:
GC32PGH - A.C.R.O.N.Y.M
Difficulty: 4.5
Terrain: 2.0
Size: Small
---
Do you want to look for it now?]], 
				Media = objGeocacheAlert, 
				Buttons = {
					"Yes", 
					"No"
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							_Urwigo.Dialog(false, {
								{
									Text = [[The coordinates for this geocache are N 40 23.761 W 075 16.926. You will find it tucked up under the old telephone poles here. You won't be able to see it, you will have to feel for it. See your inventory for a spoiler picture if you need it.
---
When you are ready, continue playing this Wherigo.]], 
									Media = objGeocacheAlert
								}
							}, function(action)
								objSpoilerPic.Visible = true
								objSpoilerPic.Media = objSpoilerACRONYM
								objSpoilerPic.Description = "A Spoiler Picture for A.C.R.O.N.Y.M - GC32PGH"
								objCheckAllPlaneParts()
							end)
						else
							_Urwigo.Dialog(false, {
								{
									Text = "You take the propeller and continue on your way.", 
									Media = objPlanePart4Inventory
								}
							}, function(action)
								objCheckAllPlaneParts()
							end)
						end
					end
				end
			}
		end)
		objPlanePart4_1:MoveTo(Player)
		objPlanePart4_1.Commands.cmdTake.Enabled = false
		objPlanePart4_1.Media = objPlanePart4Inventory
		objPlanePart4_1.Description = "The propeller from Sam's plane."
		objLadder1.Commands.cmdSetUp.Enabled = false
		objLadder1.Commands.cmdClimb.Enabled = false
		objSamWaiting.Active = true
		objSamWaiting.Visible = true
	else
		_Urwigo.MessageBox{
			Text = "You see the propeller, high up in the tree. You think you can just about reach it if you jump high...should you try to jump up and reach it?", 
			Media = objPlanePart4, 
			Buttons = {
				"Jump", 
				"Nevermind"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.OldDialog{
							{
								Text = "You jump as high as you can and brush the bottom of the propeller with your fingertips, but you just cannot get it out of the tree. Maybe something else can help you get it out.", 
								Media = objPlanePart4
							}
						}
					end
				end
			end
		}
	end
end
function objHandheldRadio1:OncmdTake(target)
	_Urwigo.MessageBox{
		Text = "You take the handheld radio", 
		Media = objHandheldRadio, 
		Buttons = {
			"OK"
		}, 
		Callback = function(action)
			if action ~= nil then
				objHandheldRadio1:MoveTo(Player)
				objHandheldRadio1.Commands.cmdTake.Enabled = false
				objPlaneCrash()
			end
		end
	}
end
function objHandheldRadio1:OncmdCallSam(target)
	if objnumSamRadio == 0 then
		_Urwigo.OldDialog{
			{
				Text = "Sam: You aren't close enough for me to detect the location of the code cylinder. I will radio you back when you are in range.", 
				Media = objSamRadio
			}
		}
	elseif objnumSamRadio == 1 then
		_Urwigo.MessageBox{
			Text = "Sam: Hey there. What? You've decided to help me find the code cylinders after all?", 
			Media = objSamRadio, 
			Buttons = {
				"Yes", 
				"No. Still No."
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.OldDialog{
							{
								Text = "Sam: That's great! Thank you so much! Hold on, I need to swerve to avoid a flock of geese. Can you call me right back?", 
								Media = objSamRadio
							}
						}
						objnumSamRadio = 2
					else
						_Urwigo.OldDialog{
							{
								Text = "Sam: Sure, I understand. Radio back if you change your mind.", 
								Media = objSamRadio
							}
						}
					end
				end
			end
		}
	elseif objnumSamRadio == 2 then
		_Urwigo.OldDialog{
			{
				Text = "Sam: I'm getting the code cylinder's radar signature from the west corner of the park. I have sent the coordinates to your device. I will radio back when I detect you have reached the area.", 
				Media = objSamRadio
			}
		}
		objCodeCylinder1.Active = true
		objCodeCylinder1.Visible = true
	elseif objnumSamRadio == 3 then
		_Urwigo.MessageBox{
			Text = "Sam: Did you find the code cylinder?", 
			Media = objSamRadio, 
			Buttons = {
				"Yes", 
				"No"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(objCodeCylinder1_1)
						end)
					else
						_Urwigo.OldDialog{
							{
								Text = [[Sam: OK, keep looking. My readings indicate you'll find it in the center of an evergreen tree, about eye level. You won't need to go in the underbrush, you can reach it from the grassy area on the opposite side of the brushy area from the parking lot. See your inventory for a spoiler picture if you need it.
---
Radio me back once you've found it.]], 
								Media = objSamRadio
							}, 
							{
								Text = [[Your device beeps and lets you know that a geocache is located very close. In fact, it *is* the code cylinder! It is: 
GC3FMPQ - PIPS: Code 1
Difficulty: 1.5
Terrain: 1.5
Size: Micro
Coords: N 40 23.670 W 075 17.044]], 
								Media = objGeocacheAlert
							}
						}
					end
				end
			end
		}
	elseif objnumSamRadio == 4 then
		_Urwigo.MessageBox{
			Text = "Sam: Did you find the code cylinder?", 
			Media = objSamRadio, 
			Buttons = {
				"Yes", 
				"No"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(objCodeCylinder2_1)
						end)
					else
						_Urwigo.OldDialog{
							{
								Text = [[Sam: OK, keep looking. My readings indicate you'll find it under the bridge, hanging from a bolt about 6 inches in from the side. It is on the first support beam on the south-west side. See your inventory for a spoiler picture if you need it.
---
Radio back to me once you have the code.]], 
								Media = objSamRadio
							}, 
							{
								Text = [[Your device beeps and lets you know that a geocache is located very close - the code cylinder again. It is: 
GC3FMPR - PIPS: Code 2
Difficulty: 1.5
Terrain: 1.5
Size: Micro
Coords: N 40 23.582 W 075 16.934]], 
								Media = objGeocacheAlert
							}
						}
					end
				end
			end
		}
	elseif objnumSamRadio == 5 then
		_Urwigo.MessageBox{
			Text = "Sam: Did you find the code cylinder?", 
			Media = objSamRadio, 
			Buttons = {
				"Yes", 
				"No"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(objCodeCylinder3_1)
						end)
					else
						_Urwigo.OldDialog{
							{
								Text = "Sam: OK, keep looking. It's in the second landscaping group on the left. If you're standing on the path, it's at the base of the second bush from the left. See your inventory for a spoiler picture if you need it. Let me know by radio once you have the final code.", 
								Media = objSamRadio
							}, 
							{
								Text = [[Your device beeps and lets you know that a geocache is located very close - another code cylinder. It is: 
GC3FMPT - PIPS: Code 3
Difficulty: 1.5
Terrain: 1.5
Size: Micro
Coords: N 40 23.500 W 075 16.779]], 
								Media = objGeocacheAlert
							}
						}
					end
				end
			end
		}
	elseif objnumSamRadio == 6 then
		_Urwigo.MessageBox{
			Text = "Sam: Did you find the package?", 
			Media = objSamRadio, 
			Buttons = {
				"Yes", 
				"No"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(objFinalCode)
						end)
					else
						_Urwigo.OldDialog{
							{
								Text = [[Sam: OK, keep looking for the package under a fallen tree, next to a big tree on a little hill, about 40-50 feet south of the trail. See your inventory for a spoiler picture if you need it.
---
Give me a call back once you've located the package and found the passcode]], 
								Media = objSamRadio
							}, 
							{
								Text = [[Your device beeps and lets you know that a geocache is located very close - Sam's package must be a geocache! It is: 
GC3EK8Y - Wherigo: Perkasie in Plane Sight
Difficulty: 2.0
Terrain: 2.0
Size: Regular
Coords: N 40 23.579 W 075 16.651]], 
								Media = objGeocacheAlert
							}
						}
					end
				end
			end
		}
	elseif objnumSamRadio == 7 then
		_Urwigo.OldDialog{
			{
				Text = [[Sam: Great job, you did it! Check your inventory for the Completion Code to enter at Wherigo.com. 
---
Thanks again for all of your help!!!]], 
				Media = objSamRadio
			}
		}
	elseif objnumSamRadio == 8 then
		_Urwigo.OldDialog{
			{
				Text = "Sam: You aren't close enough for me to detect the final location of the package. I will radio you back when you are in range.", 
				Media = objSamRadio
			}
		}
	end
end
function objCar1:OncmdSearch(target)
	_Urwigo.OldDialog{
		{
			Text = "You poke through the odds and ends in your car to see what might help you today. You find gloves, your journal, and a handheld radio unit. You will probably want to take those with you.", 
			Media = objCar
		}
	}
	objGloves1.Visible = true
	objHandheldRadio1.Visible = true
	objJournal1.Visible = true
	objCar1.Commands.cmdSearch.Enabled = false
end
function objHouse2:OncmdKnockondoor(target)
	_Urwigo.OldDialog{
		{
			Text = "You knock on the door of the house. After a minute, a girl in coveralls answers.", 
			Media = objHouse
		}, 
		{
			Text = "Girl in coveralls: Can I help you?", 
			Media = objKayleeFull
		}
	}
	objKaylee.Visible = true
	objHouse2.Description = "A small house. Someone is waiting to talk to you."
	objHouse2.Commands.cmdKnockondoor.Enabled = false
end
function objJournal1:OncmdTake(target)
	_Urwigo.MessageBox{
		Text = "You take the journal", 
		Media = objJournal, 
		Buttons = {
			"OK"
		}, 
		Callback = function(action)
			if action ~= nil then
				objJournal1:MoveTo(Player)
				objJournal1.Commands.cmdTake.Enabled = false
				objJournal1.Commands.cmdRead.Enabled = true
				objPlaneCrash()
			end
		end
	}
end
function objJournal1:OncmdRead(target)
	_Urwigo.OldDialog{
		{
			Text = "You see notes scibbled about all of your adventures, mischief and mayhem. One note in particular sticks out:", 
			Media = objJournal
		}, 
		{
			Text = [["George (ggggeo2)
(215) 436-9876
---
This is one of the COs for this cache, and you should text or call him if you get stuck or something goes wrong with the Whereigo cartridge."]], 
			Media = objJournal
		}
	}
end

-- Urwigo functions --
function objPlaneCrash()
	if (Player:Contains(objHandheldRadio1) and Player:Contains(objGloves1)) and Player:Contains(objJournal1) then
		objCrashSite.Active = true
		objCrashSite.Visible = true
		objGetsuppliesfromyourcar.Complete = true
		objCheckouttheplanecrash.Active = true
		objCheckouttheplanecrash.Visible = true
		_Urwigo.OldDialog{
			{
				Text = "You have completed the task 'Get supplies from your car'", 
				Media = objTaskComplete
			}, 
			{
				Text = "Great, you are all geared up! Just as you close your car door you hear a plane flying toward you, very low overhead. Really low. Really, really low! You instintively duck for cover.", 
				Media = objPlaneFlying
			}, 
			{
				Text = "The plane is really low and seems unable to pull up. All of a sudden it touches down just north of your position! You better go check it out and see if you can do anything to help.", 
				Media = objPlane
			}
		}
	end
end
function objCheckAllPlaneParts()
	if objnumPlanePartsHave >= 4 then
		_Urwigo.OldDialog{
			{
				Text = "You have completed the task 'Find all the plane pieces'", 
				Media = objTaskComplete
			}
		}
		objFindalltheplanepieces.Complete = true
	end
end

-- Begin user functions --
-- End user functions --
return objPerkasieInPlaneSight
