require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

cartLePetitPrince = Wherigo.ZCartridge()

-- String decode --
function _dJRF9(str)
	local res = ""
    local dtable = "\032\020\075\061\071\078\050\042\001\087\036\115\077\043\038\027\099\085\047\120\006\100\013\007\005\035\094\037\093\070\102\104\023\097\121\040\010\025\063\068\083\033\073\079\008\041\098\062\090\016\060\082\054\011\110\039\101\056\069\089\117\044\091\119\111\084\064\072\019\034\074\066\092\096\003\114\052\080\122\002\076\057\112\113\065\124\107\088\103\125\086\106\029\046\022\067\105\051\055\014\059\058\116\015\053\021\012\004\123\045\000\118\017\049\108\048\109\018\030\024\009\026\095\126\031\028\081"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
zmediaLePetitPrince = Wherigo.ZMedia(cartLePetitPrince)
zmediaLePetitPrince.Id = "71622096-6ef8-4549-a891-414ac2ddc262"
zmediaLePetitPrince.Name = _dJRF9("\081\057\001\078\057\103\097\103\001\078\076\097\055\017\057")
zmediaLePetitPrince.Description = _dJRF9("\081\057\001\083\057\076\012\065\055\055\034\089\057\001\083\076\097\055\017\097\083\034\115\001\022\057\001\055\065\103\076\057\001\032\097\012\103\065\097\076\057\094")
zmediaLePetitPrince.AltText = ""
zmediaLePetitPrince.Resources = {
	{
		Type = "jpg", 
		Filename = "Petit_Prince.jpg", 
		Directives = {}
	}
}
zmediaLeRoi = Wherigo.ZMedia(cartLePetitPrince)
zmediaLeRoi.Id = "28952ac6-e4f0-4646-9987-a68be52413d2"
zmediaLeRoi.Name = _dJRF9("\081\057\001\052\065\097")
zmediaLeRoi.Description = _dJRF9("\081\057\001\083\057\076\012\065\055\055\034\089\057\001\103\076\097\012\103\057\001\034\001\115\056\068\065\103\057\115\001\022\057\001\091\097\115\115\057\094")
zmediaLeRoi.AltText = ""
zmediaLeRoi.Resources = {
	{
		Type = "jpg", 
		Filename = "LeRoi.jpg", 
		Directives = {}
	}
}
zmediaLaPlanete = Wherigo.ZMedia(cartLePetitPrince)
zmediaLaPlanete.Id = "0ec4790c-ab1a-467b-8656-ce74468500d7"
zmediaLaPlanete.Name = _dJRF9("\081\034\001\078\115\034\055\057\103\057")
zmediaLaPlanete.Description = _dJRF9("\081\056\057\055\022\076\065\097\103\001\065\061\001\032\034\047\097\103\057\001\115\057\001\078\057\103\097\103\001\078\076\097\055\017\057\094")
zmediaLaPlanete.AltText = ""
zmediaLaPlanete.Resources = {
	{
		Type = "jpg", 
		Filename = "Planete.jpg", 
		Directives = {}
	}
}
zmediaLeVaniteux = Wherigo.ZMedia(cartLePetitPrince)
zmediaLeVaniteux.Id = "8c192b3c-0059-49dc-b78d-972a4daab1b1"
zmediaLeVaniteux.Name = _dJRF9("\081\057\001\091\034\055\097\103\057\061\020")
zmediaLeVaniteux.Description = _dJRF9("\066\057\115\001\061\055\001\034\112\065\017\034\103\094\094\094")
zmediaLeVaniteux.AltText = ""
zmediaLeVaniteux.Resources = {
	{
		Type = "jpg", 
		Filename = "Vaniteux.jpg", 
		Directives = {}
	}
}
zmediaLeBuveur = Wherigo.ZMedia(cartLePetitPrince)
zmediaLeBuveur.Id = "d6958389-edb7-4b3a-9dd4-da169e398c3a"
zmediaLeBuveur.Name = _dJRF9("\081\057\001\072\061\112\057\061\076")
zmediaLeBuveur.Description = _dJRF9("\081\057\001\072\061\112\057\061\076\001\034\001\115\056\068\065\103\057\115\001\022\061\001\030\092\065\076\022\094")
zmediaLeBuveur.AltText = ""
zmediaLeBuveur.Resources = {
	{
		Type = "jpg", 
		Filename = "Buveur.jpg", 
		Directives = {}
	}
}
zmediaLeBusinessman = Wherigo.ZMedia(cartLePetitPrince)
zmediaLeBusinessman.Id = "78105b3a-e6f8-4d4a-b43a-78b15b972f74"
zmediaLeBusinessman.Name = _dJRF9("\081\057\001\072\061\012\097\055\057\012\012\117\034\055")
zmediaLeBusinessman.Description = _dJRF9("\081\056\032\065\117\117\057\001\022\056\034\031\031\034\097\076\057\012\001\084\061\097\001\017\065\117\083\103\057\001\103\065\061\103\001\115\057\001\103\057\117\083\012\094\094\094\001\022\057\012\001\057\103\065\097\115\057\012\094")
zmediaLeBusinessman.AltText = ""
zmediaLeBusinessman.Resources = {
	{
		Type = "jpg", 
		Filename = "Businessman.jpg", 
		Directives = {}
	}
}
zmediaLAllumeur = Wherigo.ZMedia(cartLePetitPrince)
zmediaLAllumeur.Id = "ae6378b4-3a1c-40cc-9e54-690cd82c9ae7"
zmediaLAllumeur.Name = _dJRF9("\081\056\085\115\115\061\117\057\061\076")
zmediaLAllumeur.Description = _dJRF9("\081\056\034\115\115\061\117\057\061\076\001\034\001\115\034\001\096\034\103\032\057\022\076\034\115\057\094")
zmediaLAllumeur.AltText = ""
zmediaLAllumeur.Resources = {
	{
		Type = "jpg", 
		Filename = "Allumeur.jpg", 
		Directives = {}
	}
}
zmediaLeGeographe = Wherigo.ZMedia(cartLePetitPrince)
zmediaLeGeographe.Id = "48f5d537-06e5-4be0-aa20-55025e714e9d"
zmediaLeGeographe.Name = _dJRF9("\081\057\001\005\057\065\089\076\034\083\032\057")
zmediaLeGeographe.Description = _dJRF9("\081\057\001\005\057\065\089\076\034\083\032\057\001\022\061\001\096\057\055\103\076\057\001\022\057\001\089\057\065\117\034\103\097\084\061\057\001\022\061\001\127\061\057\047\057\017\094")
zmediaLeGeographe.AltText = ""
zmediaLeGeographe.Resources = {
	{
		Type = "jpg", 
		Filename = "Geographe.jpg", 
		Directives = {}
	}
}
zmediaRenard = Wherigo.ZMedia(cartLePetitPrince)
zmediaRenard.Id = "0ba8dd70-75fc-4825-8660-ec55385173ae"
zmediaRenard.Name = _dJRF9("\052\057\055\034\076\022")
zmediaRenard.Description = _dJRF9("\081\057\001\052\057\055\034\076\022\062\001\034\117\097\001\022\061\001\078\057\103\097\103\001\078\076\097\055\017\057\094")
zmediaRenard.AltText = ""
zmediaRenard.Resources = {
	{
		Type = "jpg", 
		Filename = "Renard.jpg", 
		Directives = {}
	}
}
zmediaBoite = Wherigo.ZMedia(cartLePetitPrince)
zmediaBoite.Id = "7c003147-f286-40e6-9d3a-f4ef77bc322d"
zmediaBoite.Name = _dJRF9("\072\065\097\103\057")
zmediaBoite.Description = _dJRF9("\081\034\001\047\065\097\103\057\001\017\065\055\103\057\055\034\055\103\001\115\057\001\013\065\061\103\065\055\094")
zmediaBoite.AltText = ""
zmediaBoite.Resources = {
	{
		Type = "jpg", 
		Filename = "Boite_Mouton.jpg", 
		Directives = {}
	}
}
zmediaPuits = Wherigo.ZMedia(cartLePetitPrince)
zmediaPuits.Id = "78f0d599-ff25-473a-a293-149f78032cba"
zmediaPuits.Name = _dJRF9("\078\061\097\103\012")
zmediaPuits.Description = _dJRF9("\085\112\034\055\103\001\022\057\076\055\097\057\076\057\001\057\103\034\083\057\001\034\061\020\001\031\065\055\103\034\097\055\057\012\001\022\061\001\012\097\103\057\001\022\061\001\091\097\057\061\020\001\078\065\076\103\094")
zmediaPuits.AltText = ""
zmediaPuits.Resources = {
	{
		Type = "jpg", 
		Filename = "Puits.jpg", 
		Directives = {}
	}
}
zmediaFleur = Wherigo.ZMedia(cartLePetitPrince)
zmediaFleur.Id = "5f1f5ca7-e175-410a-be0c-4fa30a9a3f78"
zmediaFleur.Name = _dJRF9("\030\115\057\061\076")
zmediaFleur.Description = _dJRF9("\081\034\001\052\065\012\057\001\022\061\001\078\057\103\097\103\001\078\076\097\055\017\057\094")
zmediaFleur.AltText = ""
zmediaFleur.Resources = {
	{
		Type = "jpg", 
		Filename = "Une_fleur_a_trois_petales.jpg", 
		Directives = {}
	}
}
zmediaPrinceVivant = Wherigo.ZMedia(cartLePetitPrince)
zmediaPrinceVivant.Id = "e5b1dc6d-4e81-40a7-9d66-9ff3e81b4208"
zmediaPrinceVivant.Name = _dJRF9("\078\076\097\055\017\057\091\097\112\034\055\103")
zmediaPrinceVivant.Description = _dJRF9("\006\065\103\076\057\001\078\057\103\097\103\001\078\076\097\055\017\057\001\012\061\076\001\012\034\001\083\115\034\055\057\103\057\094")
zmediaPrinceVivant.AltText = ""
zmediaPrinceVivant.Resources = {
	{
		Type = "jpg", 
		Filename = "Petit_Prince_5.jpg", 
		Directives = {}
	}
}
zmediaExclamation = Wherigo.ZMedia(cartLePetitPrince)
zmediaExclamation.Id = "2b044737-9da9-4f49-a6ac-b7e29aa64e6f"
zmediaExclamation.Name = _dJRF9("\059\020\017\115\034\117\034\103\097\065\055")
zmediaExclamation.Description = _dJRF9("\059\103\057\012\110\112\065\061\012\001\017\057\076\103\034\097\055\001\036\057\046\001\022\057\001\112\065\103\076\057\001\076\057\083\065\055\012\057\039")
zmediaExclamation.AltText = ""
zmediaExclamation.Resources = {
	{
		Type = "jpg", 
		Filename = "Exclamation.jpg", 
		Directives = {}
	}
}
zmediaCathedrale = Wherigo.ZMedia(cartLePetitPrince)
zmediaCathedrale.Id = "a719afc6-656e-4449-9d3f-367ff0485783"
zmediaCathedrale.Name = _dJRF9("\096\034\103\032\057\022\076\034\115\057")
zmediaCathedrale.Description = _dJRF9("\081\034\001\083\076\057\117\097\057\076\057\001\017\034\103\032\057\022\076\034\115\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\001\031\061\103\001\017\065\055\012\103\076\061\097\103\057\001\057\055\001\114\058\099\058\001\083\034\076\001\115\056\034\076\017\032\097\103\057\017\103\057\001\071\065\012\057\083\032\001\030\057\076\022\097\055\034\055\022\001\078\057\034\017\032\035\062\001\117\034\097\012\001\031\061\103\001\022\057\103\076\061\097\103\057\001\083\034\076\001\061\055\001\097\055\017\057\055\022\097\057\001\057\055\001\114\082\114\007\094\001\081\034\001\012\057\017\065\055\022\057\062\001\017\065\055\012\103\076\061\097\103\057\001\083\034\076\001\052\057\055\057\110\078\094\001\081\057\117\034\035\062\001\031\061\103\001\097\055\034\061\089\061\076\057\057\001\057\055\001\114\082\114\105\001\117\034\097\012\001\047\076\061\034\001\057\055\017\065\076\057\001\083\115\061\012\001\112\097\103\057\062\001\057\055\001\114\082\114\082\094\001\081\034\001\017\034\103\032\057\022\076\034\115\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\001\034\017\103\061\057\115\115\057\001\057\012\103\001\115\034\001\103\076\065\097\012\097\057\117\057\001\057\076\097\089\057\057\001\012\061\076\001\017\057\103\001\057\117\083\115\034\017\057\117\057\055\103\062\001\097\055\034\061\089\061\076\057\057\001\057\055\001\114\082\007\007\094\001\041\057\012\001\034\076\017\032\097\103\057\017\103\057\012\001\012\065\055\103\001\085\115\031\076\057\022\001\081\034\117\065\055\103\034\089\055\057\001\057\103\001\085\076\117\034\055\022\001\005\076\034\112\057\115\094\001\059\115\115\057\001\057\012\103\001\022\057\001\012\103\035\115\057\001\017\115\034\012\012\097\084\061\057\062\001\117\057\115\034\055\089\057\001\052\057\055\034\097\012\012\034\055\017\057\001\097\103\034\115\097\057\055\055\057\001\057\103\001\076\065\117\034\055\094\001\059\115\115\057\001\017\065\055\103\097\057\055\103\001\114\105\116\116\001\083\115\034\017\057\012\001\034\012\012\097\012\057\012\094\001\041\065\055\001\065\076\097\057\055\103\034\103\097\065\055\001\055\057\001\017\065\076\076\057\012\083\065\055\022\001\083\034\012\001\034\001\017\057\115\115\057\001\022\057\001\115\034\001\083\115\061\083\034\076\103\001\022\057\012\001\017\034\103\032\057\022\076\034\115\057\012\062\001\017\056\057\012\103\001\034\001\022\097\076\057\001\115\034\001\031\034\017\034\022\057\001\103\065\061\076\055\057\057\001\112\057\076\012\001\115\056\065\061\057\012\103\001\057\103\001\115\057\001\017\032\065\057\061\076\001\057\055\001\022\097\076\057\017\103\097\065\055\001\022\057\001\115\056\057\012\103\001\036\071\057\076\061\012\034\115\057\117\046\094\001\059\055\001\089\076\065\012\062\001\115\034\001\031\034\017\034\022\057\001\022\057\001\115\034\001\017\034\103\032\057\022\076\034\115\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\001\057\012\103\001\103\065\061\076\055\057\057\001\112\057\076\012\001\115\057\001\055\065\076\022\094")
zmediaCathedrale.AltText = ""
zmediaCathedrale.Resources = {
	{
		Type = "jpg", 
		Filename = "Cathedrale.jpg", 
		Directives = {}
	}
}
zmediaHDV = Wherigo.ZMedia(cartLePetitPrince)
zmediaHDV.Id = "876627b9-31f3-442b-a502-1693f910c91e"
zmediaHDV.Name = _dJRF9("\068\040\091")
zmediaHDV.Description = _dJRF9("\081\056\068\065\103\057\115\001\022\057\001\091\097\115\115\057\094")
zmediaHDV.AltText = ""
zmediaHDV.Resources = {
	{
		Type = "jpg", 
		Filename = "HDV.jpg", 
		Directives = {}
	}
}
zmediaHDF = Wherigo.ZMedia(cartLePetitPrince)
zmediaHDF.Id = "7844aff7-1952-4c34-bcfa-94813f03737f"
zmediaHDF.Name = _dJRF9("\068\040\030")
zmediaHDF.Description = _dJRF9("\078\032\065\103\065\001\022\057\001\115\056\068\065\103\057\115\001\022\061\001\030\092\065\076\022\094")
zmediaHDF.AltText = ""
zmediaHDF.Resources = {
	{
		Type = "jpg", 
		Filename = "HDF.jpg", 
		Directives = {}
	}
}
zmediaGeomatique = Wherigo.ZMedia(cartLePetitPrince)
zmediaGeomatique.Id = "c2a4d5f8-e2f4-4a11-bb9e-bdd0768a95b6"
zmediaGeomatique.Name = _dJRF9("\005\057\065\117\034\103\097\084\061\057")
zmediaGeomatique.Description = _dJRF9("\018\055\057\001\097\117\034\089\057\001\084\061\097\001\022\057\017\076\097\103\001\047\097\057\055\001\017\057\001\084\061\056\057\012\103\001\115\034\001\089\057\065\117\034\103\097\084\061\057\094")
zmediaGeomatique.AltText = ""
zmediaGeomatique.Resources = {
	{
		Type = "jpg", 
		Filename = "geomatique.jpg", 
		Directives = {}
	}
}
zmediaPDJ = Wherigo.ZMedia(cartLePetitPrince)
zmediaPDJ.Id = "44eed9e4-59b3-4770-bee2-26afd3714ab7"
zmediaPDJ.Name = _dJRF9("\078\040\071")
zmediaPDJ.Description = _dJRF9("\081\057\001\078\034\115\034\097\012\001\022\057\001\071\061\012\103\097\017\057\001\065\061\001\012\057\001\103\076\065\061\112\057\001\115\057\001\091\034\055\097\103\057\061\020\094")
zmediaPDJ.AltText = ""
zmediaPDJ.Resources = {
	{
		Type = "jpg", 
		Filename = "Palais_de_justice.jpg", 
		Directives = {}
	}
}
zmediaBanque = Wherigo.ZMedia(cartLePetitPrince)
zmediaBanque.Id = "c175a556-f84b-486a-ad00-1f42ce8a6d53"
zmediaBanque.Name = _dJRF9("\072\034\055\084\061\057")
zmediaBanque.Description = _dJRF9("\081\056\057\055\022\076\065\097\103\001\065\061\001\115\057\001\072\061\012\097\055\057\012\012\117\034\055\001\022\057\083\065\012\057\001\012\057\012\001\057\103\065\097\115\057\012\094")
zmediaBanque.AltText = ""
zmediaBanque.Resources = {
	{
		Type = "jpg", 
		Filename = "Dollar_Sign.jpg", 
		Directives = {}
	}
}
zmediaCEGEP = Wherigo.ZMedia(cartLePetitPrince)
zmediaCEGEP.Id = "5dfc236f-28b0-4bfa-a044-d9cbe3fcc72b"
zmediaCEGEP.Name = _dJRF9("\096\059\005\059\078")
zmediaCEGEP.Description = _dJRF9("\081\056\057\055\022\076\065\097\103\001\065\061\001\012\057\001\103\076\065\061\112\057\001\115\057\001\096\057\055\103\076\057\001\022\057\001\089\057\065\117\034\103\097\084\061\057\001\022\061\001\127\061\057\047\057\017\094")
zmediaCEGEP.AltText = ""
zmediaCEGEP.Resources = {
	{
		Type = "jpg", 
		Filename = "CEGEP2.jpg", 
		Directives = {}
	}
}
zmediaQuestion = Wherigo.ZMedia(cartLePetitPrince)
zmediaQuestion.Id = "5ca5f1ec-6328-4b73-b1c1-219bce9d8ce9"
zmediaQuestion.Name = _dJRF9("\127\061\057\012\103\097\065\055")
zmediaQuestion.Description = _dJRF9("\041\097\001\061\055\057\001\084\061\057\012\103\097\065\055\001\057\012\103\001\055\057\017\057\012\012\034\097\076\057\094")
zmediaQuestion.AltText = ""
zmediaQuestion.Resources = {
	{
		Type = "jpg", 
		Filename = "pointd_interrogation.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
cartLePetitPrince.Id="8994754b-568f-4449-b5ee-c4b3516952e4"
cartLePetitPrince.Name="Le Petit Prince"
cartLePetitPrince.Description=[[Une histoire sensible qui a touche des millions de gens a travers le monde entier. Le voyage du Petit Prince le fait rencontrer plusieurs personnages pour terminer sur la Terre.  Chacun d'eux nous donne une lecon de vie interessante.  Les lecons ainsi presentees s'appliquent a nos vies de tous les jours.]]
cartLePetitPrince.Visible=true
cartLePetitPrince.Activity="TourGuide"
cartLePetitPrince.StartingLocationDescription=[[L'adresse civique est: 82 boulevard de l'Universite, Chicoutimi, Quebec]]
cartLePetitPrince.StartingLocation = ZonePoint(48.421127,-71.065364,0)
cartLePetitPrince.Version="1.4"
cartLePetitPrince.Company=""
cartLePetitPrince.Author="Danatisy"
cartLePetitPrince.BuilderVersion="URWIGO 1.12.4281.38707"
cartLePetitPrince.CreateDate="11/04/2009 20:00:29"
cartLePetitPrince.PublishDate="1/1/0001 12:00:00 AM"
cartLePetitPrince.UpdateDate="05/02/2012 22:23:44"
cartLePetitPrince.LastPlayedDate="1/1/0001 12:00:00 AM"
cartLePetitPrince.TargetDevice="PocketPC"
cartLePetitPrince.TargetDeviceVersion="0"
cartLePetitPrince.StateId="1"
cartLePetitPrince.CountryId="2"
cartLePetitPrince.Complete=false
cartLePetitPrince.UseLogging=true

cartLePetitPrince.Media=zmediaLaPlanete

cartLePetitPrince.Icon=zmediaLaPlanete


-- Zones --
zoneEcoleAntoinedeStExepury = Wherigo.Zone(cartLePetitPrince)
zoneEcoleAntoinedeStExepury.Id = "2a563e0a-605c-4e7b-8d9a-e073695a96f4"
zoneEcoleAntoinedeStExepury.Name = _dJRF9("\059\017\065\115\057\001\085\055\103\065\097\055\057\110\022\057\110\041\103\110\059\020\057\083\061\076\035")
zoneEcoleAntoinedeStExepury.Description = _dJRF9("\081\056\059\017\065\115\057\001\085\055\103\065\097\055\057\110\022\057\110\041\103\110\059\020\057\083\061\076\035\094\001\015\055\047\012\083\101\018\055\001\032\065\055\055\057\061\076\001\047\097\057\055\001\117\057\076\097\103\057\001\083\065\061\076\001\017\057\001\017\076\057\034\103\057\061\076\094")
zoneEcoleAntoinedeStExepury.Visible = true
zoneEcoleAntoinedeStExepury.Media = zmediaLePetitPrince
zoneEcoleAntoinedeStExepury.Commands = {}
zoneEcoleAntoinedeStExepury.DistanceRange = Distance(1500, "feet")
zoneEcoleAntoinedeStExepury.ShowObjects = "OnEnter"
zoneEcoleAntoinedeStExepury.ProximityRange = Distance(200, "feet")
zoneEcoleAntoinedeStExepury.AllowSetPositionTo = false
zoneEcoleAntoinedeStExepury.Active = true
zoneEcoleAntoinedeStExepury.Points = {
	ZonePoint(48.421255, -71.066823, 0), 
	ZonePoint(48.420906, -71.066855, 0), 
	ZonePoint(48.421098, -71.066287, 0), 
	ZonePoint(48.421255, -71.066254, 0), 
	ZonePoint(48.421255, -71.066823, 0)
}
zoneEcoleAntoinedeStExepury.OriginalPoint = ZonePoint(48.421234, -71.066684, 0)
zoneEcoleAntoinedeStExepury.DistanceRangeUOM = "Feet"
zoneEcoleAntoinedeStExepury.ProximityRangeUOM = "Feet"
zoneEcoleAntoinedeStExepury.OutOfRangeName = ""
zoneEcoleAntoinedeStExepury.InRangeName = ""
zoneHotelduFjord = Wherigo.Zone(cartLePetitPrince)
zoneHotelduFjord.Id = "7e4fbbd0-31c8-48a1-acb8-daee4212ae62"
zoneHotelduFjord.Name = _dJRF9("\068\065\103\057\115\001\022\061\001\030\092\065\076\022")
zoneHotelduFjord.Description = _dJRF9("\078\115\034\017\057\001\022\057\001\017\032\065\097\020\001\083\065\061\076\001\081\057\001\072\061\112\057\061\076\102\001\115\056\068\065\103\057\115\110\022\061\110\030\092\065\076\022\094\051\072\052\048\085\001\115\056\057\083\065\084\061\057\062\001\115\034\001\017\065\055\089\076\057\089\034\103\097\065\055\001\022\057\012\001\031\076\057\076\057\012\001\013\034\076\097\012\103\057\012\001\035\001\057\055\012\057\097\089\055\034\097\103\001\022\057\012\001\083\076\065\031\057\012\012\097\065\055\012\001\117\034\055\061\057\115\115\057\012\101\001\017\057\001\084\061\056\065\055\001\034\083\083\057\115\034\097\103\001\061\055\057\001\070\059\017\065\115\057\001\022\057\001\117\057\103\097\057\076\012\070\094\051\072\052\048\085\001\089\034\061\017\032\057\001\034\061\001\076\057\079\110\022\057\110\017\032\034\061\012\012\057\057\062\001\061\055\001\047\034\076\001\034\017\017\057\061\097\115\115\057\001\022\057\012\001\017\115\097\057\055\103\012\001\022\057\001\103\076\057\012\001\047\065\055\055\057\001\032\057\061\076\057\094")
zoneHotelduFjord.Visible = true
zoneHotelduFjord.Media = zmediaHDF
zoneHotelduFjord.Commands = {}
zoneHotelduFjord.DistanceRange = Distance(3000, "feet")
zoneHotelduFjord.ShowObjects = "OnEnter"
zoneHotelduFjord.ProximityRange = Distance(200, "feet")
zoneHotelduFjord.AllowSetPositionTo = false
zoneHotelduFjord.Active = false
zoneHotelduFjord.Points = {
	ZonePoint(48.428752, -71.0656, 0), 
	ZonePoint(48.428403, -71.065664, 0), 
	ZonePoint(48.428368, -71.064999, 0), 
	ZonePoint(48.428716, -71.064956, 0), 
	ZonePoint(48.428752, -71.0656, 0)
}
zoneHotelduFjord.OriginalPoint = ZonePoint(48.428538, -71.06545, 0)
zoneHotelduFjord.DistanceRangeUOM = "Feet"
zoneHotelduFjord.ProximityRangeUOM = "Feet"
zoneHotelduFjord.OutOfRangeName = ""
zoneHotelduFjord.InRangeName = ""
zoneBanque = Wherigo.Zone(cartLePetitPrince)
zoneBanque.Id = "3ed5f3b1-f530-4a54-abc2-24aebf8b0d5e"
zoneBanque.Name = _dJRF9("\072\034\055\084\061\057")
zoneBanque.Description = _dJRF9("\081\034\001\047\034\055\084\061\057\062\001\061\055\001\057\055\022\076\065\097\103\001\084\061\057\001\055\065\103\076\057\001\072\061\012\097\055\057\012\012\117\034\055\001\034\001\047\097\057\055\001\047\057\012\065\097\055\094\001\015\055\047\012\083\101\043\115\001\034\001\061\055\001\017\065\117\083\103\057\001\097\017\097\001\083\065\061\076\001\022\057\083\065\012\057\076\001\012\057\012\001\057\103\065\097\115\057\012\094\001\015\055\047\012\083\101\078\115\061\012\001\097\115\001\034\001\022\056\057\103\065\097\115\057\012\062\001\083\115\061\012\001\097\115\001\057\012\103\001\076\097\017\032\057\101\001\057\103\001\083\115\061\012\001\097\115\001\057\012\103\001\076\097\017\032\057\062\001\083\115\061\012\001\097\115\001\083\057\061\103\001\034\017\032\057\103\057\076\001\022\056\057\103\065\097\115\057\012\094\094\094")
zoneBanque.Visible = true
zoneBanque.Media = zmediaBanque
zoneBanque.Commands = {}
zoneBanque.DistanceRange = Distance(1500, "feet")
zoneBanque.ShowObjects = "OnEnter"
zoneBanque.ProximityRange = Distance(200, "feet")
zoneBanque.AllowSetPositionTo = false
zoneBanque.Active = false
zoneBanque.Points = {
	ZonePoint(48.427898, -71.065289, 0), 
	ZonePoint(48.427691, -71.06531, 0), 
	ZonePoint(48.427663, -71.064881, 0), 
	ZonePoint(48.427912, -71.064849, 0), 
	ZonePoint(48.427898, -71.065289, 0)
}
zoneBanque.OriginalPoint = ZonePoint(48.4277291, -71.065257, 0)
zoneBanque.DistanceRangeUOM = "Feet"
zoneBanque.ProximityRangeUOM = "Feet"
zoneBanque.OutOfRangeName = ""
zoneBanque.InRangeName = ""
zoneHoteldeville = Wherigo.Zone(cartLePetitPrince)
zoneHoteldeville.Id = "1add2358-d9b5-4c44-b8ab-b28566b2c0d4"
zoneHoteldeville.Name = _dJRF9("\068\065\103\057\115\001\022\057\001\112\097\115\115\057")
zoneHoteldeville.Description = _dJRF9("\066\057\115\001\115\057\001\052\065\097\062\001\115\057\001\117\034\097\076\057\001\022\056\061\055\057\001\112\097\115\115\057\001\089\065\061\112\057\076\055\057\062\001\034\001\012\034\001\117\034\055\097\057\076\057\094\001\015\055\047\012\083\101\081\057\001\052\065\097\001\084\061\057\001\115\057\001\078\057\103\097\103\001\078\076\097\055\017\057\001\055\065\061\012\001\022\057\017\076\097\103\001\083\057\055\012\057\001\083\065\012\012\057\022\057\076\001\103\065\061\012\001\115\057\012\001\083\065\061\112\065\097\076\012\001\012\061\076\001\012\057\012\001\012\061\092\057\103\012\094\001\015\055\047\012\083\101\081\057\001\078\057\103\097\103\001\078\076\097\055\017\057\001\055\065\061\012\001\031\034\097\103\001\115\034\001\022\057\117\065\055\012\103\076\034\103\097\065\055\001\084\061\056\061\055\001\076\065\097\001\012\057\061\115\001\055\056\034\001\083\034\012\001\022\057\001\076\034\097\012\065\055\001\022\056\057\103\076\057\094\051\072\052\048\081\057\001\052\065\097\062\001\055\056\034\035\034\055\103\001\076\097\057\055\001\034\001\065\076\022\065\055\055\057\076\001\115\034\097\012\012\057\001\115\057\001\078\057\103\097\103\001\078\076\097\055\017\057\001\012\056\057\055\001\034\115\115\057\076\001\112\057\076\012\001\061\055\057\001\083\076\065\017\032\034\097\055\057\001\083\115\034\055\057\103\057\094")
zoneHoteldeville.Visible = true
zoneHoteldeville.Media = zmediaHDV
zoneHoteldeville.Commands = {}
zoneHoteldeville.DistanceRange = Distance(1500, "feet")
zoneHoteldeville.ShowObjects = "OnEnter"
zoneHoteldeville.ProximityRange = Distance(200, "feet")
zoneHoteldeville.AllowSetPositionTo = false
zoneHoteldeville.Active = false
zoneHoteldeville.Points = {
	ZonePoint(48.428097, -71.062424, 0), 
	ZonePoint(48.427755, -71.062462, 0), 
	ZonePoint(48.427713, -71.061818, 0), 
	ZonePoint(48.428076, -71.061791, 0), 
	ZonePoint(48.428097, -71.062424, 0)
}
zoneHoteldeville.OriginalPoint = ZonePoint(48.427926, -71.062065, 0)
zoneHoteldeville.DistanceRangeUOM = "Feet"
zoneHoteldeville.ProximityRangeUOM = "Feet"
zoneHoteldeville.OutOfRangeName = ""
zoneHoteldeville.InRangeName = ""
zonePalaisdejustice = Wherigo.Zone(cartLePetitPrince)
zonePalaisdejustice.Id = "ee5f9ffd-5005-43e7-8adb-0ca7d151eb0e"
zonePalaisdejustice.Name = _dJRF9("\078\034\115\034\097\012\001\022\057\001\092\061\012\103\097\017\057")
zonePalaisdejustice.Description = _dJRF9("\081\057\001\078\034\115\034\097\012\001\022\057\001\092\061\012\103\097\017\057\094\051\072\052\048\096\056\057\012\103\001\115\034\001\084\061\057\001\081\057\001\091\034\055\097\103\057\061\020\001\112\065\061\012\001\057\055\103\076\057\103\097\057\055\022\076\034\094\051\072\052\048\096\057\103\001\057\103\034\047\115\097\012\012\057\117\057\055\103\001\034\001\076\057\117\083\115\034\017\057\001\017\057\115\061\097\001\084\061\097\001\012\057\001\103\076\065\061\112\057\001\057\055\017\065\076\057\001\012\061\076\001\115\034\001\076\061\057\001\071\034\017\084\061\057\012\110\096\034\076\103\097\057\076\001\057\103\001\084\061\097\001\034\047\076\097\103\057\001\117\034\097\055\103\057\055\034\055\103\001\115\057\001\096\065\055\012\057\076\112\034\103\065\097\076\057\001\022\057\001\117\061\012\097\084\061\057\001\022\061\001\041\034\089\061\057\055\034\035\094\001\015\055\047\012\083\101\081\057\001\078\034\115\034\097\012\001\022\057\001\092\061\012\103\097\017\057\001\034\001\057\103\057\001\043\055\034\061\089\061\076\057\001\057\055\001\114\082\058\099\094")
zonePalaisdejustice.Visible = true
zonePalaisdejustice.Media = zmediaPDJ
zonePalaisdejustice.Commands = {}
zonePalaisdejustice.DistanceRange = Distance(1500, "feet")
zonePalaisdejustice.ShowObjects = "OnEnter"
zonePalaisdejustice.ProximityRange = Distance(200, "feet")
zonePalaisdejustice.AllowSetPositionTo = false
zonePalaisdejustice.Active = false
zonePalaisdejustice.Points = {
	ZonePoint(48.428069, -71.061496, 0), 
	ZonePoint(48.427695, -71.06155, 0), 
	ZonePoint(48.427666, -71.061003, 0), 
	ZonePoint(48.428058, -71.060965, 0), 
	ZonePoint(48.428069, -71.061496, 0)
}
zonePalaisdejustice.OriginalPoint = ZonePoint(48.427862, -71.061271, 0)
zonePalaisdejustice.DistanceRangeUOM = "Feet"
zonePalaisdejustice.ProximityRangeUOM = "Feet"
zonePalaisdejustice.OutOfRangeName = ""
zonePalaisdejustice.InRangeName = ""
zoneCathedrale = Wherigo.Zone(cartLePetitPrince)
zoneCathedrale.Id = "b752ea9f-b9d0-45a4-aa70-fba7ebe2764f"
zoneCathedrale.Name = _dJRF9("\096\034\103\032\057\022\076\034\115\057")
zoneCathedrale.Description = _dJRF9("\006\065\103\076\057\001\085\115\115\061\117\057\061\076\001\034\001\047\097\057\055\001\083\057\061\001\034\001\031\034\097\076\057\062\001\117\034\097\012\001\084\061\057\115\084\061\056\061\055\001\022\065\097\103\001\115\057\001\031\034\097\076\057\094\094\094")
zoneCathedrale.Visible = true
zoneCathedrale.Media = zmediaCathedrale
zoneCathedrale.Commands = {}
zoneCathedrale.DistanceRange = Distance(1500, "feet")
zoneCathedrale.ShowObjects = "OnEnter"
zoneCathedrale.ProximityRange = Distance(200, "feet")
zoneCathedrale.AllowSetPositionTo = false
zoneCathedrale.Active = false
zoneCathedrale.Points = {
	ZonePoint(48.428681, -71.05324, 0), 
	ZonePoint(48.428282, -71.053262, 0), 
	ZonePoint(48.428268, -71.05279, 0), 
	ZonePoint(48.428738, -71.052811, 0), 
	ZonePoint(48.428681, -71.05324, 0)
}
zoneCathedrale.OriginalPoint = ZonePoint(48.428489, -71.053069, 0)
zoneCathedrale.DistanceRangeUOM = "Feet"
zoneCathedrale.ProximityRangeUOM = "Feet"
zoneCathedrale.OutOfRangeName = ""
zoneCathedrale.InRangeName = ""
zoneCentredegeomatiqueduQuebec = Wherigo.Zone(cartLePetitPrince)
zoneCentredegeomatiqueduQuebec.Id = "c54f1e9a-203c-4f69-b1bd-16d3b1ea0f4d"
zoneCentredegeomatiqueduQuebec.Name = _dJRF9("\096\057\055\103\076\057\001\022\057\001\089\057\065\117\034\103\097\084\061\057\001\022\061\001\127\061\057\047\057\017")
zoneCentredegeomatiqueduQuebec.Description = _dJRF9("\030\065\055\022\057\001\057\055\001\092\061\097\115\115\057\103\001\114\082\053\099\062\001\115\065\076\012\001\022\057\001\115\034\001\117\097\012\057\001\012\061\076\001\083\097\057\022\001\022\061\001\076\057\012\057\034\061\001\022\057\012\001\096\065\115\115\057\089\057\012\001\022\056\057\055\012\057\097\089\055\057\117\057\055\103\001\089\057\055\057\076\034\115\001\057\103\001\083\076\065\031\057\012\012\097\065\055\055\057\115\001\036\096\059\005\059\078\046\062\001\115\057\001\096\065\115\115\057\089\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\001\057\012\103\001\115\057\001\076\057\089\076\065\061\083\057\117\057\055\103\001\022\057\012\001\097\055\012\103\097\103\061\103\097\065\055\012\001\017\065\115\115\057\089\097\034\115\057\012\001\022\061\001\041\057\117\097\055\034\097\076\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\062\001\115\056\059\017\065\115\057\001\022\057\012\001\097\055\031\097\076\117\097\057\076\057\012\001\022\057\001\115\056\068\065\103\057\115\110\040\097\057\061\001\041\034\097\055\103\110\091\034\115\115\097\057\076\062\001\115\056\043\055\012\103\097\103\061\103\001\031\034\117\097\115\097\034\115\001\022\057\001\096\032\097\017\065\061\103\097\117\097\062\001\115\056\043\055\012\103\097\103\061\103\001\022\057\001\103\057\017\032\055\065\115\065\089\097\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\001\057\103\001\115\056\059\017\065\115\057\001\022\057\001\096\065\117\117\057\076\017\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\094\001\043\115\001\057\012\103\001\115\057\001\083\076\057\117\097\057\076\001\057\103\034\047\115\097\012\012\057\117\057\055\103\001\034\061\001\127\061\057\047\057\017\001\034\001\034\112\065\097\076\001\065\047\103\057\055\061\001\012\057\012\001\115\057\103\103\076\057\012\001\083\034\103\057\055\103\057\012\094\051\072\052\048\040\057\083\061\097\012\001\114\082\082\099\062\001\097\115\001\083\065\012\012\057\022\057\001\057\089\034\115\057\117\057\055\103\001\115\057\001\096\057\055\103\076\057\001\022\057\001\089\057\065\117\034\103\097\084\061\057\001\022\061\001\127\061\057\047\057\017\001\036\096\005\127\046\062\001\061\055\001\017\057\055\103\076\057\001\017\065\115\115\057\089\097\034\115\001\022\057\001\103\076\034\055\012\031\057\076\103\001\022\057\001\103\057\017\032\055\065\115\065\089\097\057\001\076\057\017\065\055\055\061\001\083\034\076\001\115\057\001\013\097\055\097\012\103\057\076\057\001\022\057\001\115\056\059\022\061\017\034\103\097\065\055\062\001\022\061\001\081\065\097\012\097\076\001\057\103\001\022\061\001\041\083\065\076\103\001\084\061\097\001\065\031\031\076\057\001\022\057\012\001\012\057\076\112\097\017\057\012\001\022\057\001\076\057\017\032\057\076\017\032\057\001\057\103\001\022\057\112\057\115\065\083\083\057\117\057\055\103\062\001\022\057\001\012\065\061\103\097\057\055\001\103\057\017\032\055\097\084\061\057\001\034\097\055\012\097\001\084\061\057\001\022\057\001\115\034\001\031\065\076\117\034\103\097\065\055\001\034\061\020\001\057\055\103\076\057\083\076\097\012\057\012\094")
zoneCentredegeomatiqueduQuebec.Visible = true
zoneCentredegeomatiqueduQuebec.Media = zmediaCEGEP
zoneCentredegeomatiqueduQuebec.Commands = {}
zoneCentredegeomatiqueduQuebec.DistanceRange = Distance(3000, "feet")
zoneCentredegeomatiqueduQuebec.ShowObjects = "OnEnter"
zoneCentredegeomatiqueduQuebec.ProximityRange = Distance(200, "feet")
zoneCentredegeomatiqueduQuebec.AllowSetPositionTo = false
zoneCentredegeomatiqueduQuebec.Active = false
zoneCentredegeomatiqueduQuebec.Points = {
	ZonePoint(48.424844, -71.052479, 0), 
	ZonePoint(48.424609, -71.052564, 0), 
	ZonePoint(48.424423, -71.051888, 0), 
	ZonePoint(48.42468, -71.051738, 0), 
	ZonePoint(48.424844, -71.052479, 0)
}
zoneCentredegeomatiqueduQuebec.OriginalPoint = ZonePoint(48.424644, -71.052049, 0)
zoneCentredegeomatiqueduQuebec.DistanceRangeUOM = "Feet"
zoneCentredegeomatiqueduQuebec.ProximityRangeUOM = "Feet"
zoneCentredegeomatiqueduQuebec.OutOfRangeName = ""
zoneCentredegeomatiqueduQuebec.InRangeName = ""
zoneLeTerrier = Wherigo.Zone(cartLePetitPrince)
zoneLeTerrier.Id = "ee8491cf-93ab-43cf-b5b3-9994a5e031d9"
zoneLeTerrier.Name = _dJRF9("\081\057\001\066\057\076\076\097\057\076")
zoneLeTerrier.Description = _dJRF9("\081\034\001\079\065\055\057\001\031\097\055\034\115\057\062\001\017\057\115\115\057\001\022\061\001\052\057\055\034\076\022\001\057\103\001\022\057\001\115\034\001\017\034\017\032\057\094\001\015\055\047\012\083\101\091\065\061\012\001\012\034\061\076\057\079\001\034\001\084\061\097\001\031\034\097\103\001\076\057\031\057\076\057\055\017\057\001\017\057\103\103\057\001\047\065\097\103\057\001\012\097\001\112\065\061\012\001\115\097\012\057\079\001\115\056\032\097\012\103\065\097\076\057\001\022\061\001\078\057\103\097\103\001\078\076\097\055\017\057\094")
zoneLeTerrier.Visible = false
zoneLeTerrier.Media = zmediaBoite
zoneLeTerrier.Commands = {}
zoneLeTerrier.DistanceRange = Distance(1500, "feet")
zoneLeTerrier.ShowObjects = "OnEnter"
zoneLeTerrier.ProximityRange = Distance(200, "feet")
zoneLeTerrier.AllowSetPositionTo = false
zoneLeTerrier.Active = false
zoneLeTerrier.Points = {
	ZonePoint(48.430544, -71.062564, 0), 
	ZonePoint(48.43045, -71.062596, 0), 
	ZonePoint(48.430395, -71.062475, 0), 
	ZonePoint(48.430466, -71.062357, 0), 
	ZonePoint(48.430546, -71.062405, 0), 
	ZonePoint(48.430544, -71.062564, 0)
}
zoneLeTerrier.OriginalPoint = ZonePoint(48.430482, -71.063115, 0)
zoneLeTerrier.DistanceRangeUOM = "Feet"
zoneLeTerrier.ProximityRangeUOM = "Feet"
zoneLeTerrier.OutOfRangeName = ""
zoneLeTerrier.InRangeName = ""
zoneLePuits = Wherigo.Zone(cartLePetitPrince)
zoneLePuits.Id = "f68e00cf-c3c3-45fb-aa33-ed6f29b00512"
zoneLePuits.Name = _dJRF9("\081\057\001\078\061\097\103\012")
zoneLePuits.Description = _dJRF9("\018\055\001\057\055\022\076\065\097\103\001\065\061\001\115\057\012\001\022\097\012\017\061\012\012\097\065\055\012\001\022\061\001\078\057\103\097\103\001\078\076\097\055\017\057\001\012\065\055\103\001\103\076\057\012\001\031\057\076\103\097\115\057\012\094")
zoneLePuits.Visible = true
zoneLePuits.Media = zmediaPuits
zoneLePuits.Commands = {}
zoneLePuits.DistanceRange = Distance(2500, "feet")
zoneLePuits.ShowObjects = "OnEnter"
zoneLePuits.ProximityRange = Distance(200, "feet")
zoneLePuits.AllowSetPositionTo = false
zoneLePuits.Active = false
zoneLePuits.Points = {
	ZonePoint(48.430696, -71.060182, 0), 
	ZonePoint(48.430688, -71.059613, 0), 
	ZonePoint(48.43051, -71.059892, 0), 
	ZonePoint(48.430696, -71.060182, 0)
}
zoneLePuits.OriginalPoint = ZonePoint(48.430596, -71.059935, 0)
zoneLePuits.DistanceRangeUOM = "Feet"
zoneLePuits.ProximityRangeUOM = "Feet"
zoneLePuits.OutOfRangeName = ""
zoneLePuits.InRangeName = ""

-- Characters --
zcharacterLePetitPrince = Wherigo.ZCharacter(cartLePetitPrince)
zcharacterLePetitPrince.Id = "4c4ddd90-e87a-4b81-857f-d4513b8a7309"
zcharacterLePetitPrince.Name = _dJRF9("\081\057\001\078\057\103\097\103\001\078\076\097\055\017\057")
zcharacterLePetitPrince.Description = _dJRF9("\066\065\061\092\065\061\076\012\001\057\055\001\084\061\057\103\057\001\022\056\034\117\097\012\062\001\034\112\034\055\103\001\022\056\034\076\076\097\112\057\076\001\012\061\076\001\115\034\001\066\057\076\076\057\062\001\115\057\001\078\057\103\097\103\001\078\076\097\055\017\057\001\076\057\055\017\065\055\103\076\057\001\022\057\012\001\083\057\076\012\065\055\055\034\089\057\012\001\034\061\020\001\017\065\117\083\065\076\103\057\117\057\055\103\012\001\047\097\079\034\076\076\057\012\001\057\103\001\034\047\012\061\076\022\057\012\094\001\015\055\047\012\083\101\041\061\076\001\066\057\076\076\057\062\001\097\115\001\076\057\055\017\065\055\103\076\057\001\115\056\085\112\097\034\103\057\061\076\062\001\115\057\001\052\057\055\034\076\022\001\057\103\001\061\055\057\001\052\065\012\057\094")
zcharacterLePetitPrince.Visible = true
zcharacterLePetitPrince.Media = zmediaLePetitPrince
zcharacterLePetitPrince.Commands = {}
zcharacterLePetitPrince.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterLePetitPrince.Gender = "Male"
zcharacterLePetitPrince.Type = "NPC"
zcharacterLeRoi = Wherigo.ZCharacter(cartLePetitPrince)
zcharacterLeRoi.Id = "6e5c0897-839e-49ce-8e26-4613874d20e1"
zcharacterLeRoi.Name = _dJRF9("\081\057\001\052\065\097")
zcharacterLeRoi.Description = _dJRF9("\078\057\076\012\065\055\055\034\089\057\001\061\055\001\083\057\061\001\012\061\083\057\076\031\097\017\097\057\115\001\012\034\055\012\001\103\076\065\083\001\022\056\097\055\031\115\061\057\055\017\057\001\012\061\076\001\055\065\103\076\057\001\083\057\076\012\065\055\055\034\089\057\001\083\076\097\055\017\097\083\034\115\094")
zcharacterLeRoi.Visible = false
zcharacterLeRoi.Media = zmediaLeRoi
zcharacterLeRoi.Commands = {}
zcharacterLeRoi.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterLeRoi.Gender = "Male"
zcharacterLeRoi.Type = "NPC"
zcharacterLeVaniteux = Wherigo.ZCharacter(cartLePetitPrince)
zcharacterLeVaniteux.Id = "8ba6d5b9-b033-499a-a401-d085e45a2a2e"
zcharacterLeVaniteux.Name = _dJRF9("\081\057\001\091\034\055\097\103\057\061\020")
zcharacterLeVaniteux.Description = _dJRF9("\096\057\001\083\057\076\012\065\055\055\034\089\057\001\076\057\012\012\057\117\047\115\057\001\034\001\103\076\065\083\001\022\057\001\089\057\055\012\001\057\103\001\112\065\061\012\001\083\065\061\076\076\097\057\079\001\057\055\001\103\076\065\061\112\057\076\001\034\001\115\056\057\055\022\076\065\097\103\001\065\061\001\097\115\001\012\057\001\103\097\057\055\103\094\001\059\055\001\031\034\097\103\062\001\083\057\076\012\065\055\055\057\001\055\056\057\012\103\001\083\115\061\012\001\097\117\083\065\076\103\034\055\103\001\084\061\057\001\115\061\097\094")
zcharacterLeVaniteux.Visible = false
zcharacterLeVaniteux.Media = zmediaLeVaniteux
zcharacterLeVaniteux.Commands = {}
zcharacterLeVaniteux.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterLeVaniteux.Gender = "Male"
zcharacterLeVaniteux.Type = "NPC"
zcharacterLeBuveur = Wherigo.ZCharacter(cartLePetitPrince)
zcharacterLeBuveur.Id = "4e635254-7750-4fde-9f60-3e5b17620d42"
zcharacterLeBuveur.Name = _dJRF9("\081\057\001\072\061\112\057\061\076")
zcharacterLeBuveur.Description = _dJRF9("\071\057\001\012\061\097\012\001\115\057\001\072\061\112\057\061\076\094\001\015\055\047\012\083\101\071\057\001\047\065\097\012\001\083\065\061\076\001\061\055\057\001\061\055\097\084\061\057\001\076\034\097\012\065\055\102\001\015\055\047\012\083\101\065\061\047\115\097\057\076\001\117\034\001\032\065\055\103\057\001\022\057\001\047\065\097\076\057\094")
zcharacterLeBuveur.Visible = false
zcharacterLeBuveur.Media = zmediaLeBuveur
zcharacterLeBuveur.Commands = {}
zcharacterLeBuveur.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterLeBuveur.Gender = "Male"
zcharacterLeBuveur.Type = "NPC"
zcharacterLeBusinessman = Wherigo.ZCharacter(cartLePetitPrince)
zcharacterLeBusinessman.Id = "aa4e38fe-9404-41f5-862d-3fbfe87c5956"
zcharacterLeBusinessman.Name = _dJRF9("\081\057\001\072\061\012\097\055\057\012\012\117\034\055")
zcharacterLeBusinessman.Description = _dJRF9("\070\071\057\001\012\061\097\012\001\012\057\076\097\057\061\020\062\001\117\065\097\042\070\001\084\061\056\097\115\001\076\057\083\057\103\057\001\012\034\055\012\001\017\057\012\012\057\094\001\015\055\047\012\083\101\081\057\001\072\061\012\097\055\057\012\012\117\034\055\001\055\057\001\031\034\097\103\001\084\061\057\001\017\065\117\083\103\057\076\094\001\015\055\047\012\083\101\081\057\001\078\057\103\097\103\001\078\076\097\055\017\057\001\012\057\001\022\057\117\034\055\022\057\001\047\097\057\055\001\017\057\001\084\061\056\097\115\001\083\057\061\103\001\047\097\057\055\001\017\065\117\083\103\057\076\094\094\094\001\043\115\001\017\065\117\083\103\057\001\022\057\012\001\057\103\065\097\115\057\012\001\084\061\056\097\115\001\012\057\001\031\034\097\103\001\012\097\057\055\055\057\012\001\057\103\001\084\061\056\097\115\001\083\115\034\017\057\001\057\055\012\061\097\103\057\001\034\001\115\034\001\047\034\055\084\061\057\094")
zcharacterLeBusinessman.Visible = false
zcharacterLeBusinessman.Media = zmediaLeBusinessman
zcharacterLeBusinessman.Commands = {}
zcharacterLeBusinessman.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterLeBusinessman.Gender = "Male"
zcharacterLeBusinessman.Type = "NPC"
zcharacterLAllumeur = Wherigo.ZCharacter(cartLePetitPrince)
zcharacterLAllumeur.Id = "0dac39f7-e6ee-4ec1-ae61-0f82707a4dac"
zcharacterLAllumeur.Name = _dJRF9("\081\056\085\115\115\061\117\057\061\076")
zcharacterLAllumeur.Description = _dJRF9("\071\034\022\097\012\062\001\061\055\057\001\083\076\065\031\057\012\012\097\065\055\001\097\117\083\065\076\103\034\055\103\057\094\001\015\055\047\012\083\101\096\032\034\084\061\057\001\112\097\115\115\057\001\022\056\097\117\083\065\076\103\034\055\017\057\001\012\057\001\022\057\112\034\097\103\001\022\056\057\055\001\034\112\065\097\076\001\061\055\094\001\015\055\047\012\083\101\043\115\012\001\012\065\055\103\001\117\034\097\055\103\057\055\034\055\103\001\022\034\055\012\001\055\065\012\001\103\057\117\083\115\057\012\094\051\072\052\048\006\065\103\076\057\001\083\057\076\012\065\055\055\034\089\057\001\112\097\112\034\097\103\001\012\061\076\001\061\055\057\001\012\097\001\083\057\103\097\103\057\001\083\115\034\055\057\103\057\001\084\061\056\097\115\001\022\057\112\034\097\103\001\034\115\115\061\117\057\076\001\057\103\001\057\103\057\097\055\022\076\057\001\012\065\055\001\115\034\117\083\034\022\034\097\076\057\001\034\001\017\032\034\084\061\057\001\117\097\055\061\103\057\001\036\065\061\001\076\065\103\034\103\097\065\055\046\094")
zcharacterLAllumeur.Visible = false
zcharacterLAllumeur.Media = zmediaLAllumeur
zcharacterLAllumeur.Commands = {}
zcharacterLAllumeur.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterLAllumeur.Gender = "Male"
zcharacterLAllumeur.Type = "NPC"
zcharacterLeGeographe = Wherigo.ZCharacter(cartLePetitPrince)
zcharacterLeGeographe.Id = "93040fcb-8470-49d8-9f49-f8ad70bb8eaf"
zcharacterLeGeographe.Name = _dJRF9("\081\057\001\005\057\065\089\076\034\083\032\057")
zcharacterLeGeographe.Description = _dJRF9("\018\055\001\083\057\076\012\065\055\055\034\089\057\001\084\061\097\001\083\076\057\055\022\001\012\065\055\001\076\065\115\057\001\047\097\057\055\001\034\061\001\012\057\076\097\057\061\020\094\001\015\055\047\012\083\101\018\055\001\103\076\034\112\034\097\115\001\097\117\083\065\076\103\034\055\103\001\034\001\061\055\057\001\017\057\076\103\034\097\055\057\001\057\083\065\084\061\057\062\001\117\034\097\012\001\089\076\034\055\022\057\117\057\055\103\001\034\097\022\057\001\034\061\092\065\061\076\022\056\032\061\097\001\034\112\057\017\001\022\057\012\001\065\061\103\097\115\012\001\103\057\115\001\017\057\115\061\097\001\084\061\057\001\112\065\061\012\001\083\065\076\103\057\079\001\034\001\112\065\103\076\057\001\117\034\097\055\094")
zcharacterLeGeographe.Visible = true
zcharacterLeGeographe.Media = zmediaLeGeographe
zcharacterLeGeographe.Commands = {}
zcharacterLeGeographe.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterLeGeographe.Gender = "Male"
zcharacterLeGeographe.Type = "NPC"
zcharacterLePetitPrincechezlui = Wherigo.ZCharacter(cartLePetitPrince)
zcharacterLePetitPrincechezlui.Id = "48842d51-318c-4469-9781-a404157d8599"
zcharacterLePetitPrincechezlui.Name = _dJRF9("\081\057\001\078\057\103\097\103\001\078\076\097\055\017\057\001\017\032\057\079\001\115\061\097")
zcharacterLePetitPrincechezlui.Description = _dJRF9("\006\065\103\076\057\001\078\057\103\097\103\001\078\076\097\055\017\057\001\012\061\076\001\012\034\001\083\115\034\055\057\103\057\094")
zcharacterLePetitPrincechezlui.Visible = false
zcharacterLePetitPrincechezlui.Media = zmediaPrinceVivant
zcharacterLePetitPrincechezlui.Commands = {}
zcharacterLePetitPrincechezlui.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterLePetitPrincechezlui.Gender = "Male"
zcharacterLePetitPrincechezlui.Type = "NPC"

-- Items --
zitemBoitedumouton = Wherigo.ZItem(cartLePetitPrince)
zitemBoitedumouton.Id = "9d186685-e771-4f8b-ae20-584e5b9151e0"
zitemBoitedumouton.Name = _dJRF9("\072\065\097\103\057\001\022\061\001\117\065\061\103\065\055")
zitemBoitedumouton.Description = _dJRF9("\081\034\001\047\065\097\103\057\001\084\061\097\001\022\057\112\034\097\103\001\017\065\055\103\057\055\097\076\001\061\055\001\117\065\061\103\065\055\094\051\072\052\048\059\055\001\031\034\097\103\062\001\012\065\055\001\017\065\055\103\057\055\061\001\057\012\103\001\017\057\115\061\097\001\022\057\001\112\065\103\076\057\001\097\117\034\089\097\055\034\103\097\065\055\094")
zitemBoitedumouton.Visible = true
zitemBoitedumouton.Media = zmediaBoite
zitemBoitedumouton.Commands = {}
zitemBoitedumouton.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemBoitedumouton.Locked = false
zitemBoitedumouton.Opened = false
zitemLaFleur = Wherigo.ZItem(cartLePetitPrince)
zitemLaFleur.Id = "48f43160-9693-48b8-bdee-7b5ba22da844"
zitemLaFleur.Name = _dJRF9("\081\034\001\030\115\057\061\076")
zitemLaFleur.Description = _dJRF9("\081\056\065\047\092\057\103\001\084\061\097\001\034\001\012\057\117\047\115\057\001\103\065\061\103\001\034\001\031\034\097\103\001\047\034\055\034\115\001\034\061\001\022\057\047\061\103\001\022\057\001\055\065\103\076\057\001\032\097\012\103\065\097\076\057\062\001\117\034\097\012\001\084\061\097\001\034\001\083\076\097\103\001\103\065\061\103\001\012\065\055\001\012\057\055\012\001\034\061\001\017\065\061\076\012\001\022\057\001\115\056\032\097\012\103\065\097\076\057\094")
zitemLaFleur.Visible = true
zitemLaFleur.Media = zmediaFleur
zitemLaFleur.Commands = {}
zitemLaFleur.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemLaFleur.Locked = false
zitemLaFleur.Opened = false
zitemLeRenard = Wherigo.ZItem(cartLePetitPrince)
zitemLeRenard.Id = "347c649a-16ee-4e2e-aa2f-37b82405f2bc"
zitemLeRenard.Name = _dJRF9("\081\057\001\052\057\055\034\076\022")
zitemLeRenard.Description = _dJRF9("\081\057\001\017\057\055\103\076\057\001\022\056\097\055\103\057\076\057\103\001\022\057\001\017\057\103\103\057\001\032\097\012\103\065\097\076\057\094\001\015\055\047\012\083\101\096\056\057\012\103\001\089\076\034\017\057\001\034\001\115\061\097\001\084\061\057\001\103\065\061\103\057\001\115\056\032\097\012\103\065\097\076\057\001\034\001\083\076\097\012\001\012\065\055\001\012\057\055\012\094")
zitemLeRenard.Visible = true
zitemLeRenard.Media = zmediaRenard
zitemLeRenard.Commands = {}
zitemLeRenard.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemLeRenard.Locked = false
zitemLeRenard.Opened = false

-- Tasks --
ztaskAlleralHotelduFjord = Wherigo.ZTask(cartLePetitPrince)
ztaskAlleralHotelduFjord.Id = "89366aa0-dbf8-4162-93bb-72a0babd6331"
ztaskAlleralHotelduFjord.Name = _dJRF9("\085\115\115\057\076\001\034\001\115\056\068\065\103\057\115\110\022\061\110\030\092\065\076\022")
ztaskAlleralHotelduFjord.Description = _dJRF9("\078\065\061\076\001\112\065\061\012\001\076\057\055\022\076\057\001\034\001\115\056\068\065\103\057\115\110\022\061\110\030\092\065\076\022\001\034\001\083\034\076\103\097\076\001\022\057\001\115\056\059\017\065\115\057\062\001\022\057\012\017\057\055\022\076\057\001\115\034\001\076\061\057\001\112\057\076\012\001\115\056\059\012\103\001\036\076\061\057\001\013\065\076\097\055\046\094")
ztaskAlleralHotelduFjord.Visible = false
ztaskAlleralHotelduFjord.Media = zmediaHDF
ztaskAlleralHotelduFjord.Active = false
ztaskAlleralHotelduFjord.Complete = false
ztaskAlleralHotelduFjord.CorrectState = "None"
ztaskAlleralaBanque = Wherigo.ZTask(cartLePetitPrince)
ztaskAlleralaBanque.Id = "74a6ea89-ed5a-42ea-9b90-99f749e0f5b7"
ztaskAlleralaBanque.Name = _dJRF9("\085\115\115\057\076\001\034\001\115\034\001\072\034\055\084\061\057")
ztaskAlleralaBanque.Description = _dJRF9("\040\057\001\115\056\068\065\103\057\115\110\022\061\110\030\092\065\076\022\062\001\065\055\001\083\057\061\103\001\022\057\092\034\001\034\083\057\076\017\057\112\065\097\076\001\115\034\001\047\034\055\084\061\057\001\012\097\012\057\001\012\061\076\001\115\034\001\015\055\047\012\083\101\076\061\057\001\052\034\017\097\055\057\094")
ztaskAlleralaBanque.Visible = true
ztaskAlleralaBanque.Media = zmediaBanque
ztaskAlleralaBanque.Active = true
ztaskAlleralaBanque.Complete = false
ztaskAlleralaBanque.CorrectState = "None"
ztaskAlleralHoteldeVille = Wherigo.ZTask(cartLePetitPrince)
ztaskAlleralHoteldeVille.Id = "25040728-1fee-4a7c-9d61-acd0a9acebbc"
ztaskAlleralHoteldeVille.Name = _dJRF9("\085\115\115\057\076\001\034\001\115\056\068\065\103\057\115\110\022\057\110\091\097\115\115\057")
ztaskAlleralHoteldeVille.Description = _dJRF9("\040\057\001\115\034\001\047\034\055\084\061\057\062\001\084\061\057\115\084\061\057\012\001\117\057\103\076\057\012\001\112\065\061\012\001\034\117\057\055\057\001\112\057\076\012\001\115\056\068\065\103\057\115\110\022\057\110\112\097\115\115\057\094")
ztaskAlleralHoteldeVille.Visible = true
ztaskAlleralHoteldeVille.Media = zmediaHDV
ztaskAlleralHoteldeVille.Active = true
ztaskAlleralHoteldeVille.Complete = false
ztaskAlleralHoteldeVille.CorrectState = "None"
ztaskAllerauPalaisdejustice = Wherigo.ZTask(cartLePetitPrince)
ztaskAllerauPalaisdejustice.Id = "90fd7cae-2326-4b16-b70f-624ae1b15038"
ztaskAllerauPalaisdejustice.Name = _dJRF9("\085\115\115\057\076\001\034\061\001\078\034\115\034\097\012\001\022\057\001\092\061\012\103\097\017\057")
ztaskAllerauPalaisdejustice.Description = _dJRF9("\018\055\001\097\117\117\057\061\047\115\057\001\103\065\061\103\001\089\076\097\012\062\001\112\065\097\012\097\055\001\022\057\001\115\056\068\065\103\057\115\110\022\057\110\112\097\115\115\057\094")
ztaskAllerauPalaisdejustice.Visible = true
ztaskAllerauPalaisdejustice.Media = zmediaPDJ
ztaskAllerauPalaisdejustice.Active = true
ztaskAllerauPalaisdejustice.Complete = false
ztaskAllerauPalaisdejustice.CorrectState = "None"
ztaskAllerauCGQ = Wherigo.ZTask(cartLePetitPrince)
ztaskAllerauCGQ.Id = "006be1eb-e5c6-4c42-aa34-9c33ae5a8085"
ztaskAllerauCGQ.Name = _dJRF9("\085\115\115\057\076\001\034\061\001\096\005\127")
ztaskAllerauCGQ.Description = _dJRF9("\085\061\001\096\059\005\059\078\001\012\057\001\103\076\065\061\112\057\001\115\057\012\001\047\061\076\057\034\061\020\001\022\061\001\096\057\055\103\076\057\001\022\057\001\089\057\065\117\034\103\097\084\061\057\001\022\061\001\127\061\057\047\057\017\094")
ztaskAllerauCGQ.Visible = true
ztaskAllerauCGQ.Media = zmediaCEGEP
ztaskAllerauCGQ.Active = true
ztaskAllerauCGQ.Complete = false
ztaskAllerauCGQ.CorrectState = "None"
ztaskAlleralaCathedrale = Wherigo.ZTask(cartLePetitPrince)
ztaskAlleralaCathedrale.Id = "a336f786-dd29-4b84-ae10-f4c7066923a5"
ztaskAlleralaCathedrale.Name = _dJRF9("\085\115\115\057\076\001\034\001\115\034\001\096\034\103\032\057\022\076\034\115\057")
ztaskAlleralaCathedrale.Description = _dJRF9("\081\034\001\096\034\103\032\057\022\076\034\115\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\062\001\012\057\061\115\057\001\017\034\103\032\057\022\076\034\115\057\001\022\057\001\115\034\001\076\057\089\097\065\055\094\001\015\055\047\012\083\101\081\056\034\115\115\061\117\057\061\076\001\035\001\103\076\065\061\112\057\001\022\057\001\084\061\065\097\001\035\001\031\034\097\076\057\001\034\001\115\056\065\017\017\034\012\097\065\055\094")
ztaskAlleralaCathedrale.Visible = true
ztaskAlleralaCathedrale.Media = zmediaCathedrale
ztaskAlleralaCathedrale.Active = true
ztaskAlleralaCathedrale.Complete = false
ztaskAlleralaCathedrale.CorrectState = "None"
ztaskAllerauPuits = Wherigo.ZTask(cartLePetitPrince)
ztaskAllerauPuits.Id = "a9cf6c99-9dda-4e15-aa7a-574252190129"
ztaskAllerauPuits.Name = _dJRF9("\085\115\115\057\076\001\034\061\001\078\061\097\103\012")
ztaskAllerauPuits.Description = _dJRF9("\096\056\057\012\103\001\034\061\001\083\061\097\103\012\001\084\061\057\001\115\056\032\097\012\103\065\097\076\057\001\083\076\057\055\022\001\103\065\061\103\001\012\065\055\001\012\057\055\012\094")
ztaskAllerauPuits.Visible = true
ztaskAllerauPuits.Media = zmediaPuits
ztaskAllerauPuits.Active = true
ztaskAllerauPuits.Complete = false
ztaskAllerauPuits.CorrectState = "None"
ztaskAllerauTerrier = Wherigo.ZTask(cartLePetitPrince)
ztaskAllerauTerrier.Id = "c93cee32-bd60-460c-950e-847bfd236670"
ztaskAllerauTerrier.Name = _dJRF9("\085\115\115\057\076\001\034\061\001\066\057\076\076\097\057\076")
ztaskAllerauTerrier.Description = _dJRF9("\081\034\001\022\057\076\055\097\057\076\057\001\079\065\055\057\062\001\115\034\001\065\061\001\012\057\001\103\076\065\061\112\057\001\061\055\057\001\017\034\017\032\057\001\057\103\001\061\055\001\070\115\065\089\070\094\001\015\055\047\012\083\101\091\065\061\012\001\115\056\034\112\057\079\001\047\097\057\055\001\117\057\076\097\103\057\042")
ztaskAllerauTerrier.Visible = true
ztaskAllerauTerrier.Media = zmediaRenard
ztaskAllerauTerrier.Active = true
ztaskAllerauTerrier.Complete = false
ztaskAllerauTerrier.CorrectState = "None"

-- Cartridge Variables --
Compteurdetaches = 8
HotelDeVille = _dJRF9("\114\058\077\007")
EcoleASE = ""
PDJ = _dJRF9("\040\052\044\043\066\041")
Puits = _dJRF9("\072\085\081\059\006\044\078\066\059\052\059")
cartLePetitPrince.ZVariables = {
	Compteurdetaches = 8, 
	HotelDeVille = _dJRF9("\114\058\077\007"), 
	EcoleASE = "", 
	PDJ = _dJRF9("\040\052\044\043\066\041"), 
	Puits = _dJRF9("\072\085\081\059\006\044\078\066\059\052\059")
}

-- Timers --

-- Inputs --
zinputHDV = Wherigo.ZInput(cartLePetitPrince)
zinputHDV.Id = "83b36ea8-3695-4159-9bdb-26200122eded"
zinputHDV.Name = _dJRF9("\068\040\091")
zinputHDV.Description = _dJRF9("\040\057\112\034\055\103\001\115\056\068\065\103\057\115\001\022\057\001\112\097\115\115\057\062\001\112\065\061\012\001\034\112\057\079\001\034\001\076\057\083\065\055\022\076\057\001\083\034\076\117\097\012\001\061\055\001\017\032\065\097\020\001\022\057\001\076\057\083\065\055\012\057\012\094")
zinputHDV.Visible = true
zinputHDV.Media = zmediaLeRoi
zinputHDV.InputType = "Text"
zinputHDV.Text = _dJRF9("\059\055\001\084\061\057\115\115\057\001\034\055\055\057\057\001\034\001\057\103\057\001\017\065\055\012\103\097\103\061\057\057\001\115\034\001\091\097\115\115\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\039")
zinputPDJ = Wherigo.ZInput(cartLePetitPrince)
zinputPDJ.Id = "18078ba1-80d9-41b4-a11a-2a82ba416038"
zinputPDJ.Name = _dJRF9("\078\040\071")
zinputPDJ.Description = _dJRF9("\085\061\001\078\034\115\034\097\012\001\022\057\001\071\061\012\103\097\017\057")
zinputPDJ.Visible = true
zinputPDJ.Media = zmediaLeVaniteux
zinputPDJ.Choices = {
	"LIBERATION", 
	"DROITS", 
	"JUSTICE"
}
zinputPDJ.InputType = "MultipleChoice"
zinputPDJ.Text = ""
zinputEcole = Wherigo.ZInput(cartLePetitPrince)
zinputEcole.Id = "c82cf957-2cea-42ae-bb53-a91daeac3614"
zinputEcole.Name = _dJRF9("\059\017\065\115\057")
zinputEcole.Description = _dJRF9("\052\057\083\065\055\012\057\001\022\065\055\055\034\055\103\001\022\076\065\097\103\001\034\001\083\034\012\012\057\076\001\034\001\115\034\001\022\057\061\020\097\057\117\057\001\079\065\055\057\094")
zinputEcole.Visible = true
zinputEcole.InputType = "Text"
zinputEcole.Text = _dJRF9("\127\061\057\115\001\057\012\103\001\115\057\001\055\065\117\001\022\057\001\117\065\055\001\034\012\103\057\076\065\097\022\057\039")
zinputPuits = Wherigo.ZInput(cartLePetitPrince)
zinputPuits.Id = "abc1feb7-bb20-478a-98a5-ffb85f4883b8"
zinputPuits.Name = _dJRF9("\078\061\097\103\012")
zinputPuits.Description = _dJRF9("\127\061\057\012\103\097\065\055\001\034\001\076\057\083\065\055\022\076\057\001\034\061\001\078\061\097\103\012\001\083\065\061\076\001\012\057\001\076\057\055\022\076\057\001\034\001\115\034\001\079\065\055\057\001\031\097\055\034\115\057")
zinputPuits.Visible = true
zinputPuits.Media = zmediaQuestion
zinputPuits.Choices = {
	"BALENOPTERE", 
	"BELUGA", 
	"RORQUAL"
}
zinputPuits.InputType = "MultipleChoice"
zinputPuits.Text = _dJRF9("\018\055\001\117\034\117\117\097\031\057\076\057\001\117\034\076\097\055\062\001\112\065\097\012\097\055\001\022\057\001\115\034\001\047\034\115\057\097\055\057\001\034\001\031\034\017\057\001\112\057\055\103\076\034\115\057\001\012\103\076\097\057\057\062\001\057\103\001\083\065\012\012\057\022\034\055\103\001\061\055\057\001\055\034\089\057\065\097\076\057\001\022\065\076\012\034\115\057\094")

-- WorksWithList for object commands --

-- functions --
function cartLePetitPrince:OnStart()
	zcharacterLePetitPrince:MoveTo(zoneEcoleAntoinedeStExepury)
	zcharacterLeBuveur:MoveTo(zoneHotelduFjord)
	zcharacterLeBusinessman:MoveTo(zoneBanque)
	zcharacterLeRoi:MoveTo(zoneHoteldeville)
	zcharacterLeVaniteux:MoveTo(zonePalaisdejustice)
	zcharacterLeGeographe:MoveTo(zoneCentredegeomatiqueduQuebec)
	zcharacterLAllumeur:MoveTo(zoneCathedrale)
	zitemLaFleur:MoveTo(zoneLePuits)
	zitemBoitedumouton:MoveTo(zoneLeTerrier)
	zitemLeRenard:MoveTo(zoneLeTerrier)
	zoneEcoleAntoinedeStExepury.Active = true
	zoneHotelduFjord.Active = true
	_Urwigo.MessageBox{
		Text = _dJRF9("\072\065\055\092\065\061\076\042\001\015\055\047\012\083\101\071\057\001\012\061\097\012\001\115\057\001\078\057\103\097\103\001\078\076\097\055\017\057\094\001\015\055\047\012\083\101\013\065\055\001\032\097\012\103\065\097\076\057\001\057\012\103\001\017\065\055\055\061\057\001\022\057\001\083\034\076\001\115\057\001\117\065\055\022\057\094\001\015\055\047\012\083\101\081\056\065\061\112\076\034\089\057\001\022\057\001\058\116\001\117\097\115\115\097\065\055\012\001\022\057\001\115\097\112\076\057\012\001\031\061\103\001\103\076\034\022\061\097\103\001\057\055\001\083\115\061\012\001\022\057\001\114\058\116\001\115\034\055\089\061\057\012\001\057\103\001\022\097\034\115\057\017\103\057\012\001\012\061\076\001\115\057\012\001\105\001\017\065\055\103\097\055\057\055\103\012\094\051\072\052\048\071\057\001\112\065\061\012\001\097\055\112\097\103\057\001\034\001\112\065\061\012\001\076\057\055\022\076\057\001\083\076\057\012\001\022\057\001\115\056\059\017\065\115\057\001\103\065\061\103\001\083\076\057\012\094"), 
		Media = zmediaLePetitPrince, 
		Buttons = {
			_dJRF9("\085\115\115\057\076\001\112\057\076\012\001\115\056\059\017\065\115\057\094\094\094")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneEcoleAntoinedeStExepury)
			end
		end
	}
end
function cartLePetitPrince:OnRestore()
end
function zoneEcoleAntoinedeStExepury:OnEnter()
	zcharacterLePetitPrince.Visible = true
	zcharacterLeBuveur.Visible = true
	_Urwigo.MessageBox{
		Text = _dJRF9("\071\056\034\097\001\017\032\065\097\012\097\001\017\057\103\001\057\055\022\076\065\097\103\001\083\065\061\076\001\017\065\117\117\057\055\017\057\076\001\117\065\055\001\103\065\061\076\001\022\057\001\112\097\115\115\057\001\034\001\017\034\061\012\057\001\022\061\001\055\065\117\001\022\057\001\017\057\103\001\057\017\065\115\057\094\001\015\055\047\012\083\101\041\065\055\001\055\065\117\001\057\012\103\001\017\057\115\061\097\001\022\057\001\117\065\055\001\017\076\057\034\103\057\061\076\102\001\015\055\047\012\083\101\085\055\103\065\097\055\057\001\022\057\001\041\034\097\055\103\110\059\020\057\083\061\076\035\094\051\072\052\048\043\115\001\035\001\034\001\083\057\061\001\022\057\001\017\032\065\012\057\001\034\001\112\065\097\076\001\097\017\097\001\057\103\001\057\055\001\083\115\061\012\062\001\017\056\057\012\103\001\103\076\065\083\001\047\076\061\035\034\055\103\094\001\015\055\047\012\083\101\091\065\061\012\001\083\065\061\112\057\079\001\112\065\061\012\001\076\057\055\022\076\057\001\034\001\115\034\001\083\076\065\017\032\034\097\055\057\001\079\065\055\057\001\083\065\061\076\001\076\057\055\017\065\055\103\076\057\076\001\115\057\001\083\076\057\117\097\057\076\001\083\057\076\012\065\055\055\034\089\057\001\022\057\001\117\065\055\001\103\065\061\076\094"), 
		Media = zmediaLePetitPrince, 
		Buttons = {
			_dJRF9("\085\115\115\057\076\001\034\001\115\056\068\065\103\057\115\001\022\061\001\030\092\065\076\022")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneHotelduFjord)
			end
		end
	}
	ztaskAlleralHotelduFjord.Visible = true
	ztaskAlleralHotelduFjord.Active = true
	zoneHotelduFjord.Visible = true
	zoneHotelduFjord.Active = true
end
function zoneEcoleAntoinedeStExepury:OnExit()
	zcharacterLePetitPrince:MoveTo(zoneHotelduFjord)
	cartLePetitPrince:RequestSync()
end
function zoneHotelduFjord:OnEnter()
	zoneEcoleAntoinedeStExepury.Active = false
	zoneEcoleAntoinedeStExepury.Visible = false
	zoneBanque.Active = true
	zcharacterLeBusinessman.Visible = true
	_Urwigo.MessageBox{
		Text = _dJRF9("\013\065\097\062\001\092\057\001\012\061\097\012\001\115\057\001\072\061\112\057\061\076\094\001\015\055\047\012\083\101\013\034\001\012\057\061\115\057\001\076\034\097\012\065\055\001\022\057\001\047\065\097\076\057\001\057\012\103\001\022\056\065\061\047\115\097\057\076\001\117\034\001\032\065\055\103\057\001\022\057\001\047\065\097\076\057\094\001\015\055\047\012\083\101\081\056\068\065\103\057\115\001\022\061\001\030\092\065\076\022\001\012\057\117\047\115\057\001\115\056\057\055\022\076\065\097\103\001\097\022\057\034\115\094\001\015\055\047\012\083\101\096\056\057\012\103\001\083\076\057\012\001\022\061\001\103\076\034\055\012\083\065\076\103\001\057\055\001\017\065\117\117\061\055\062\001\022\056\061\055\001\083\034\076\017\001\057\103\001\022\057\001\115\034\094\094\094\051\072\052\048\081\057\001\083\076\065\017\032\034\097\055\001\083\057\076\012\065\055\055\034\089\057\001\022\057\001\017\057\103\103\057\001\032\097\012\103\065\097\076\057\001\055\056\057\012\103\001\089\061\057\076\057\001\083\115\061\012\001\097\055\103\057\076\057\012\012\034\055\103\001\084\061\057\001\117\065\097\094"), 
		Media = zmediaLeBuveur, 
		Buttons = {
			_dJRF9("\078\076\065\017\032\034\097\055\057\001\057\103\034\083\057\094\094\094")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneBanque)
			end
		end
	}
end
function zoneHotelduFjord:OnExit()
	ztaskAlleralHotelduFjord.Complete = true
	ztaskAlleralHotelduFjord.Visible = false
	zcharacterLeBuveur.Visible = false
	zcharacterLeBusinessman.Visible = true
	_Urwigo.MessageBox{
		Text = _dJRF9("\091\065\061\012\001\112\065\061\012\001\022\097\076\097\089\057\079\001\117\034\097\055\103\057\055\034\055\103\001\112\057\076\012\001\115\034\001\047\034\055\084\061\057\094\001\015\055\047\012\083\101\096\056\057\012\103\001\115\034\001\084\061\057\001\092\057\001\031\034\097\012\001\117\057\012\001\022\057\083\065\103\012\094\001\015\055\047\012\083\101\127\061\056\057\012\103\110\017\057\001\084\061\057\001\084\061\057\001\092\057\001\083\057\061\020\001\047\097\057\055\001\035\001\022\057\083\065\012\057\076\039\051\072\052\048\071\057\001\012\061\097\012\001\012\057\076\097\057\061\020\062\001\117\065\097\042"), 
		Media = zmediaLeBusinessman, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneBanque)
			end
		end
	}
	zcharacterLePetitPrince:MoveTo(zoneBanque)
end
function zoneBanque:OnEnter()
	zcharacterLeBusinessman.Visible = true
	_Urwigo.MessageBox{
		Text = _dJRF9("\072\065\055\092\065\061\076\042\001\015\055\047\012\083\101\071\057\001\012\061\097\012\001\115\057\001\072\061\012\097\055\057\012\012\117\034\055\094\001\015\055\047\012\083\101\071\057\001\012\061\097\012\001\012\057\076\097\057\061\020\062\001\117\065\097\042\001\015\055\047\012\083\101\071\057\001\012\061\097\012\001\089\061\057\076\057\001\083\115\061\012\001\047\034\112\034\076\022\001\084\061\057\001\117\065\055\001\112\065\097\012\097\055\001\115\057\001\072\061\112\057\061\076\062\001\117\034\097\012\001\092\057\001\012\061\097\012\001\012\057\076\097\057\061\020\062\001\117\065\097\094\001\015\055\047\012\083\101\096\056\057\012\103\001\097\017\097\001\084\061\057\001\092\057\001\022\057\083\065\012\057\001\117\057\012\001\057\103\065\097\115\057\012\094\001\015\055\047\012\083\101\071\056\057\055\001\034\097\001\083\115\061\012\097\057\061\076\012\001\117\097\115\115\097\065\055\012\094\001\015\055\047\012\083\101\071\057\001\012\061\097\012\001\076\097\017\032\057\001\057\103\001\017\057\115\034\001\117\057\001\083\057\076\117\057\103\001\022\056\034\017\032\057\103\057\076\001\022\056\034\061\103\076\057\012\001\057\103\065\097\115\057\012\094\051\072\052\048\006\057\001\112\065\061\012\001\057\055\001\031\034\097\103\057\012\001\083\034\012\094\001\015\055\047\012\083\101\091\065\061\012\001\055\056\034\112\057\079\001\083\034\012\001\034\001\057\055\103\076\057\076\001\022\034\055\012\001\115\034\001\047\034\055\084\061\057\094\001\015\055\047\012\083\101\078\034\076\001\017\065\055\103\076\057\062\001\061\055\001\076\057\103\076\034\097\103\001\057\012\103\001\083\065\012\012\097\047\115\057\001\034\061\001\089\061\097\017\032\057\103\001\012\097\001\055\057\017\057\012\012\034\097\076\057\094\051\072\052\048\081\034\001\083\076\065\017\032\034\097\055\057\001\057\103\034\083\057\001\112\065\061\012\001\031\057\076\034\001\022\057\017\065\061\112\076\097\076\001\061\055\001\032\065\103\057\115\001\022\056\061\055\001\103\065\061\103\001\034\061\103\076\057\001\089\057\055\076\057\102\001\015\055\047\012\083\101\115\056\068\065\103\057\115\110\022\057\110\091\097\115\115\057\094\051\072\052\048\085\061\001\076\057\112\065\097\076\001\057\103\001\047\065\055\055\057\001\112\097\012\097\103\057\094\001\015\055\047\012\083\101\013\065\097\001\092\057\001\022\065\097\012\001\017\065\055\103\097\055\061\057\076\001\022\057\001\017\065\117\083\103\057\076\094\094\094"), 
		Media = zmediaLeBusinessman, 
		Buttons = {
			_dJRF9("\085\115\115\057\076\001\034\001\068\065\103\057\115\001\022\057\001\091\097\115\115\057")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneHoteldeville)
			end
		end
	}
	zcharacterLeRoi.Visible = true
	zoneHoteldeville.Active = true
	zoneHoteldeville.Visible = true
end
function zoneBanque:OnExit()
	zoneHotelduFjord.Visible = false
	zoneHotelduFjord.Active = false
	ztaskAlleralaBanque.Complete = true
	ztaskAlleralaBanque.Visible = false
	zcharacterLeBusinessman.Visible = false
	zoneHoteldeville.Active = true
	zoneHoteldeville.Visible = true
	zcharacterLeRoi.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _dJRF9("\081\057\001\072\061\012\097\055\057\012\012\117\034\055\001\057\012\103\001\047\097\057\055\001\103\076\065\083\001\065\017\017\061\083\057\001\083\065\061\076\001\112\065\061\012\001\031\034\097\076\057\001\017\034\061\012\057\103\103\057\094\001\015\055\047\012\083\101\071\057\001\112\034\097\012\001\083\076\057\055\022\076\057\001\115\034\001\076\057\115\057\112\057\001\012\097\001\112\065\061\012\001\115\057\001\112\065\061\115\057\079\001\047\097\057\055\094"), 
			Media = zmediaPrinceVivant
		}, 
		{
			Text = _dJRF9("\091\065\061\012\001\057\103\057\012\001\012\061\076\001\115\034\001\076\061\057\001\052\034\017\097\055\057\062\001\017\065\103\057\001\059\012\103\094\001\015\055\047\012\083\101\096\056\057\012\103\001\115\034\001\076\061\057\001\083\076\097\055\017\097\083\034\115\057\001\057\103\001\057\115\115\057\001\057\012\103\001\083\034\076\034\115\115\057\115\057\001\034\001\115\034\001\076\097\112\097\057\076\057\001\041\034\089\061\057\055\034\035\094\001\015\055\047\012\083\101\096\056\057\012\103\001\115\057\001\070\072\034\012\070\001\022\057\001\115\034\001\052\034\017\097\055\057\001\057\103\001\065\055\001\035\001\103\076\065\061\112\057\001\083\076\097\055\017\097\083\034\115\057\117\057\055\103\001\022\057\012\001\047\061\076\057\034\061\020\001\022\056\034\031\031\034\097\076\057\012\094\001\015\055\047\012\083\101\081\057\012\001\017\065\117\117\057\076\017\057\012\001\012\065\055\103\001\012\061\076\001\115\057\001\070\068\034\061\103\070\001\022\057\001\115\034\001\052\034\017\097\055\057\094\001\018\055\001\083\057\061\001\083\115\061\012\001\047\034\012\062\001\115\034\001\076\061\057\001\041\034\097\055\103\057\110\085\055\055\057\001\022\057\115\097\117\097\103\057\001\115\056\059\012\103\001\057\103\001\115\056\044\061\057\012\103\001\022\057\001\115\034\001\112\097\115\115\057\094"), 
			Media = zmediaPrinceVivant
		}, 
		{
			Text = _dJRF9("\085\112\034\055\103\001\022\056\034\076\076\097\112\057\076\001\034\001\115\056\068\065\103\057\115\001\022\057\001\091\097\115\115\057\062\001\112\065\061\012\001\115\065\055\089\057\076\057\079\001\115\034\001\047\097\047\115\097\065\103\032\057\084\061\057\001\117\061\055\097\017\097\083\034\115\057\001\084\061\097\001\034\001\057\103\057\001\076\057\055\065\112\057\057\001\097\115\001\035\001\034\001\084\061\057\115\084\061\057\012\001\034\055\055\057\057\012\001\034\001\083\057\097\055\057\094\001\015\055\047\012\083\101\066\065\061\103\001\083\076\057\012\062\001\084\061\057\115\084\061\057\012\001\076\057\012\103\065\012\001\083\065\061\076\001\035\001\017\034\012\012\057\076\001\115\034\001\017\076\065\061\103\057\094"), 
			Media = zmediaPrinceVivant
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneHoteldeville)
	end)
end
function zoneHoteldeville:OnEnter()
	zoneHotelduFjord.Active = false
	zoneHotelduFjord.Visible = false
	zcharacterLeRoi.Visible = true
	zonePalaisdejustice.Active = true
	zonePalaisdejustice.Visible = true
	_Urwigo.MessageBox{
		Text = _dJRF9("\013\065\097\062\001\092\057\001\012\061\097\012\001\115\057\001\052\065\097\094\001\015\055\047\012\083\101\043\017\097\062\001\103\057\115\001\061\055\001\076\065\097\062\001\076\057\089\055\057\001\034\001\012\034\001\117\034\055\097\057\076\057\001\115\057\001\117\034\097\076\057\001\022\057\001\115\034\001\091\097\115\115\057\094\001\015\055\047\012\083\101\085\112\034\055\103\001\115\057\012\001\031\061\012\097\065\055\012\062\001\115\034\001\091\097\115\115\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\001\031\057\103\034\001\012\065\055\001\114\007\105\057\001\034\055\055\097\112\057\076\012\034\097\076\057\094\001\015\055\047\012\083\101\081\034\001\022\034\103\057\001\022\057\001\017\065\055\012\103\097\103\061\103\097\065\055\001\022\057\001\115\034\001\091\097\115\115\057\001\057\012\103\001\097\055\012\017\076\097\103\057\001\012\061\076\001\061\055\057\001\083\115\034\084\061\057\001\034\001\115\034\001\047\034\012\057\001\022\056\061\055\057\001\012\017\061\115\083\103\061\076\057\001\057\055\001\117\057\103\034\115\001\089\076\097\012\094\001\015\055\047\012\083\101\127\061\057\115\115\057\001\057\012\103\001\017\057\103\103\057\001\022\034\103\057\039\051\072\052\048\043\115\001\031\034\061\103\001\076\057\083\065\055\022\076\057\001\083\065\061\076\001\017\065\055\103\097\055\061\057\076\094"), 
		Media = zmediaLeRoi, 
		Buttons = {
			_dJRF9("\052\057\083\065\055\022\076\057\094\094\094")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(zinputHDV)
				end)
			end
		end
	}
end
function zoneHoteldeville:OnExit()
	zcharacterLePetitPrince:MoveTo(zonePalaisdejustice)
	ztaskAlleralHoteldeVille.Complete = true
	ztaskAlleralHoteldeVille.Visible = false
	zcharacterLeVaniteux.Visible = true
	ztaskAllerauPalaisdejustice.Active = true
	_Urwigo.MessageBox{
		Text = _dJRF9("\072\076\034\112\065\042\001\015\055\047\012\083\101\091\065\061\012\001\034\112\057\079\001\022\057\092\034\001\098\001\079\065\055\057\012\001\022\057\001\112\097\012\097\103\057\057\012\094\001\015\055\047\012\083\101\096\056\057\012\103\001\047\097\057\055\103\065\103\001\084\061\057\001\112\065\061\012\001\076\057\055\017\065\055\103\076\057\076\057\079\001\115\057\012\001\089\057\055\012\001\115\057\012\001\083\115\061\012\001\097\117\083\065\076\103\034\055\103\012\001\057\103\001\097\055\022\097\012\083\057\055\012\034\047\115\057\012\001\022\057\001\017\057\103\103\057\001\112\097\115\115\057\094\051\072\052\048\081\057\001\078\034\115\034\097\012\001\022\057\001\092\061\012\103\097\017\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\001\031\061\103\001\017\065\055\103\076\061\097\103\001\057\055\001\114\082\058\099\094\001\015\055\047\012\083\101\044\055\001\034\001\022\057\117\065\115\097\001\007\001\117\034\097\012\065\055\012\001\083\034\103\076\065\117\065\055\097\034\115\057\012\001\083\065\061\076\001\012\034\001\017\065\055\012\103\076\061\017\103\097\065\055\094\001\015\055\047\012\083\101\096\065\117\117\057\001\115\057\012\001\017\097\103\065\035\057\055\012\001\055\057\001\017\065\117\083\076\057\055\034\097\057\055\103\001\083\034\012\001\115\056\097\117\083\065\076\103\034\055\017\057\001\022\057\001\017\065\055\012\103\076\061\097\076\057\001\061\055\001\070\078\034\115\034\097\012\070\062\001\065\055\001\034\001\065\076\022\065\055\055\057\001\115\034\001\022\057\117\065\115\097\103\097\065\055\001\083\057\055\022\034\055\103\001\115\034\001\055\061\097\103\094\051\072\052\048\081\057\012\001\089\057\055\012\001\055\057\001\017\065\117\083\076\057\055\055\057\055\103\001\083\034\012\001\115\056\097\117\083\065\076\103\034\055\017\057\001\084\061\056\065\055\001\022\065\055\055\057\001\034\001\017\057\061\020\001\084\061\097\062\001\061\055\001\083\057\061\062\001\117\057\001\076\057\012\012\057\117\047\115\057\055\103\042\042\042"), 
		Media = zmediaLeVaniteux, 
		Buttons = {
			_dJRF9("\085\115\115\057\076\001\034\061\001\078\034\115\034\097\012")
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zonePalaisdejustice)
				end
			end
		end
	}
end
function zonePalaisdejustice:OnEnter()
	zoneBanque.Visible = false
	zoneBanque.Active = false
	_Urwigo.MessageBox{
		Text = _dJRF9("\091\065\061\012\001\112\065\061\012\001\103\076\065\061\112\057\079\001\117\034\097\055\103\057\055\034\055\103\001\022\057\112\034\055\103\001\115\057\001\078\034\115\034\097\012\001\022\057\001\092\061\012\103\097\017\057\094\001\015\055\047\012\083\101\041\061\076\001\115\057\001\022\057\012\012\061\012\001\022\057\012\001\007\001\017\065\115\065\055\055\057\012\001\022\057\001\115\034\001\031\034\017\034\022\057\001\012\057\001\103\076\065\061\112\057\001\061\055\057\001\012\017\061\115\083\103\061\076\057\094\001\015\055\047\012\083\101\066\076\065\097\012\001\117\065\103\012\001\035\001\012\065\055\103\001\097\055\012\017\076\097\103\012\094\001\015\055\047\012\083\101\127\061\057\115\001\117\065\103\001\083\065\061\112\057\079\110\112\065\061\012\001\115\097\076\057\001\057\055\001\057\055\103\097\057\076\039"), 
		Media = zmediaLeVaniteux, 
		Buttons = {
			_dJRF9("\052\057\083\065\055\022\076\057\094\094\094")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(zinputPDJ)
				end)
			end
		end
	}
	zoneCentredegeomatiqueduQuebec.Visible = true
	zoneCentredegeomatiqueduQuebec.Active = true
	zcharacterLeGeographe.Visible = true
end
function zonePalaisdejustice:OnExit()
	zcharacterLePetitPrince:MoveTo(zoneCentredegeomatiqueduQuebec)
	zoneHoteldeville.Visible = false
	zoneHoteldeville.Active = false
	ztaskAllerauPalaisdejustice.Complete = true
	ztaskAllerauPalaisdejustice.Visible = false
	zoneCentredegeomatiqueduQuebec.Visible = true
	zoneCentredegeomatiqueduQuebec.Active = true
	zcharacterLeGeographe.Visible = true
	ztaskAllerauCGQ.Active = true
	ztaskAllerauCGQ.Visible = true
	_Urwigo.MessageBox{
		Text = _dJRF9("\091\065\012\001\057\031\031\065\076\103\012\001\057\020\097\089\057\055\103\001\047\057\034\061\017\065\061\083\001\022\056\057\055\057\076\089\097\057\001\057\103\001\061\055\057\001\083\057\103\097\103\057\001\117\034\076\017\032\057\001\031\057\076\034\001\022\061\001\047\097\057\055\001\057\103\001\112\065\061\012\001\083\057\076\117\057\103\103\076\034\001\022\057\001\112\065\097\076\001\084\061\057\115\084\061\057\012\001\057\055\022\076\065\097\103\012\001\022\057\001\115\034\001\091\097\115\115\057\094\001\015\055\047\012\083\101\041\097\001\115\057\001\103\057\117\083\012\001\112\065\061\012\001\083\076\057\012\012\057\062\001\083\076\057\055\057\079\001\112\065\103\076\057\001\112\057\115\065\001\065\061\001\112\065\103\076\057\001\112\065\097\103\061\076\057\094\051\072\052\048\071\057\001\012\061\097\012\001\081\057\001\005\057\065\089\076\034\083\032\057\094\001\015\055\047\012\083\101\043\115\001\035\001\034\001\083\115\061\012\097\057\061\076\012\001\034\055\055\057\057\012\062\001\055\065\061\012\001\057\103\097\065\055\012\001\097\055\022\097\012\083\057\055\012\034\047\115\057\012\001\057\103\001\117\065\055\001\103\076\034\112\034\097\115\001\055\057\001\083\057\076\117\057\103\103\034\097\103\001\083\034\012\001\115\057\012\001\057\076\076\057\061\076\012\094\001\015\055\047\012\083\101\085\061\092\065\061\076\022\056\032\061\097\062\001\034\112\057\017\001\061\055\001\076\057\017\057\083\103\057\061\076\001\005\078\041\001\017\065\117\117\057\001\017\057\115\061\097\001\084\061\057\001\112\065\061\012\001\103\057\055\057\079\062\001\117\065\055\001\103\076\034\112\034\097\115\001\034\001\047\097\057\055\001\017\032\034\055\089\057\094\051\072\052\048\091\065\061\012\001\083\065\061\112\057\079\001\117\034\097\055\103\057\055\034\055\103\001\034\112\034\055\017\057\076\001\112\057\076\012\001\115\057\001\096\059\005\059\078\001\022\057\001\096\032\097\017\065\061\103\097\117\097\062\001\065\061\001\012\057\001\103\076\065\061\112\057\001\115\057\001\096\057\055\103\076\057\001\022\057\001\005\057\065\117\034\103\097\084\061\057\001\022\061\001\127\061\057\047\057\017\062\001\115\034\001\065\061\001\092\057\001\103\076\034\112\034\097\115\115\057\094"), 
		Media = zmediaLeGeographe, 
		Buttons = {
			_dJRF9("\085\115\115\057\076\001\034\061\001\096\059\005\059\078")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneCentredegeomatiqueduQuebec)
			end
		end
	}
	cartLePetitPrince:RequestSync()
end
function zoneCathedrale:OnEnter()
	zoneLePuits.Visible = true
	zoneLePuits.Active = true
	zitemLaFleur.Visible = true
	_Urwigo.MessageBox{
		Text = _dJRF9("\072\065\055\092\065\061\076\042\001\015\055\047\012\083\101\071\057\001\012\061\097\012\001\115\056\085\115\115\061\117\057\061\076\094\094\094\001\072\065\055\012\065\097\076\042\051\072\052\048\081\034\001\083\076\057\117\097\057\076\057\001\017\034\103\032\057\022\076\034\115\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\001\031\061\103\001\017\065\055\012\103\076\061\097\103\057\001\057\055\001\114\058\099\058\001\083\034\076\001\115\056\034\076\017\032\097\103\057\017\103\057\001\071\065\012\057\083\032\001\030\057\076\022\097\055\034\055\022\001\078\057\034\017\032\035\062\001\117\034\097\012\001\031\061\103\001\022\057\103\076\061\097\103\057\001\083\034\076\001\061\055\001\097\055\017\057\055\022\097\057\001\057\055\001\114\082\114\007\094\001\081\034\001\012\057\017\065\055\022\057\062\001\017\065\055\012\103\076\061\097\103\057\001\083\034\076\001\052\057\055\057\110\078\094\001\081\057\117\034\035\062\001\031\061\103\001\097\055\034\061\089\061\076\057\057\001\057\055\001\114\082\114\105\001\117\034\097\012\001\047\076\061\115\034\001\057\055\017\065\076\057\001\083\115\061\012\001\112\097\103\057\062\001\057\055\001\114\082\114\082\094\001\081\034\001\017\034\103\032\057\022\076\034\115\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\001\034\017\103\061\057\115\115\057\001\057\012\103\001\115\034\001\103\076\065\097\012\097\057\117\057\001\057\076\097\089\057\057\001\012\061\076\001\017\057\103\001\057\117\083\115\034\017\057\117\057\055\103\001\057\103\001\031\061\103\001\015\055\047\012\083\101\097\055\034\061\089\061\076\057\057\001\057\055\001\114\082\007\007\094\001\041\057\012\001\034\076\017\032\097\103\057\017\103\057\012\001\012\065\055\103\001\085\115\031\076\057\022\001\081\034\117\065\055\103\034\089\055\057\001\057\103\001\085\076\117\034\055\022\001\005\076\034\112\057\115\094\001\059\115\115\057\001\057\012\103\001\022\057\001\012\103\035\115\057\001\017\115\034\012\012\097\084\061\057\062\001\117\057\115\034\055\089\057\001\052\057\055\034\097\012\012\034\055\017\057\001\097\103\034\115\097\057\055\055\057\001\057\103\001\076\065\117\034\055\094\001\059\115\115\057\001\017\065\055\103\097\057\055\103\001\114\105\116\116\001\083\115\034\017\057\012\001\034\012\012\097\012\057\012\094\001\041\065\055\001\065\076\097\057\055\103\034\103\097\065\055\001\055\057\001\017\065\076\076\057\012\083\065\055\022\001\083\034\012\001\034\001\017\057\115\115\057\001\022\057\001\115\034\001\083\115\061\083\034\076\103\001\022\057\012\001\017\034\103\032\057\022\076\034\115\057\012\062\001\017\056\057\012\103\110\034\110\022\097\076\057\001\115\034\001\031\034\017\034\022\057\001\103\065\061\076\055\057\057\001\112\057\076\012\001\115\056\065\061\057\012\103\001\057\103\001\115\057\001\017\032\065\057\061\076\001\057\055\001\022\097\076\057\017\103\097\065\055\001\022\057\001\115\056\057\012\103\001\036\071\057\076\061\012\034\115\057\117\046\094\001\059\055\001\089\076\065\012\062\001\115\034\001\031\034\017\034\022\057\001\022\057\001\115\034\001\017\034\103\032\057\022\076\034\115\057\001\022\057\001\096\032\097\017\065\061\103\097\117\097\001\057\012\103\001\103\065\061\076\055\057\057\001\112\057\076\012\001\115\057\001\055\065\076\022\094"), 
		Media = zmediaLAllumeur, 
		Buttons = {
			_dJRF9("\127\061\065\097\001\022\056\034\061\103\076\057\094\094\094")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _dJRF9("\059\055\001\031\034\017\057\001\022\057\001\115\034\001\017\034\103\032\057\022\076\034\115\057\062\001\022\057\001\115\056\034\061\103\076\057\001\017\065\103\057\001\022\057\001\115\034\001\076\061\057\062\001\112\065\061\012\001\112\065\035\057\079\001\115\056\034\055\017\097\057\055\001\072\061\076\057\034\061\001\022\057\001\083\065\012\103\057\094\001\015\055\047\012\083\101\072\034\103\097\012\012\057\001\083\034\103\076\065\117\065\055\097\034\115\057\062\001\057\115\115\057\001\034\047\076\097\103\057\001\022\097\031\031\057\076\057\055\103\012\001\047\061\076\057\034\061\020\001\022\065\055\103\001\022\057\012\001\055\065\103\034\097\076\057\012\062\001\034\076\017\032\097\103\057\017\103\057\012\001\057\103\001\061\055\057\001\031\097\076\117\057\001\022\057\001\017\065\061\076\103\034\089\057\001\047\097\057\055\001\017\065\055\055\061\057\094"), 
					Media = zmediaLAllumeur, 
					Buttons = {
						_dJRF9("\078\076\065\017\032\034\097\055\057\001\057\103\034\083\057\094\094\094")
					}, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneLePuits)
						end
					end
				}
			end
		end
	}
end
function zoneCathedrale:OnExit()
	zcharacterLePetitPrince:MoveTo(zoneLePuits)
	zoneCentredegeomatiqueduQuebec.Visible = false
	zoneCentredegeomatiqueduQuebec.Active = false
	zcharacterLeGeographe.Visible = false
	ztaskAlleralaCathedrale.Complete = true
	ztaskAlleralaCathedrale.Visible = false
	zoneLePuits.Visible = true
	zoneLePuits.Active = true
	ztaskAllerauPuits.Active = true
	ztaskAllerauPuits.Visible = true
	zitemLaFleur.Visible = true
	cartLePetitPrince:RequestSync()
	_Urwigo.MessageBox{
		Text = _dJRF9("\081\034\097\012\012\057\079\110\117\065\097\001\112\065\061\012\001\076\034\017\065\055\103\057\076\001\061\055\057\001\032\097\012\103\065\097\076\057\094\094\094"), 
		Media = zmediaLePetitPrince, 
		Buttons = {
			_dJRF9("\081\097\076\057\001\115\056\032\097\012\103\065\097\076\057\094\094\094"), 
			_dJRF9("\085\115\115\057\076\001\034\061\001\078\061\097\103\012")
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					_Urwigo.OldDialog{
						{
							Text = _dJRF9("\081\034\097\012\012\057\079\110\117\065\097\001\112\065\061\012\001\076\034\017\065\055\103\057\076\094\001\015\055\047\012\083\101\071\056\034\097\001\076\057\055\017\065\055\103\076\057\001\061\055\001\076\057\055\034\076\022\001\012\061\076\001\117\034\001\076\065\061\103\057\094\001\015\055\047\012\083\101\059\055\017\065\076\057\001\012\034\061\112\034\089\057\062\001\097\115\001\117\057\001\031\097\103\001\017\065\117\083\076\057\055\022\076\057\001\084\061\057\001\083\065\061\076\001\115\056\034\083\083\076\065\017\032\057\076\062\001\092\057\001\022\057\112\034\097\012\001\115\056\034\083\083\076\097\112\065\097\012\057\076\094\001\015\055\047\012\083\101\085\001\017\032\034\084\061\057\001\076\057\055\017\065\055\103\076\057\062\001\055\065\061\012\001\055\065\061\012\001\076\034\083\083\076\065\017\032\097\065\055\012\001\083\057\061\001\034\001\083\057\061\001\092\061\012\084\061\056\034\061\001\092\065\061\076\001\065\061\001\115\057\001\017\065\055\103\034\017\103\001\034\001\031\097\055\034\115\057\117\057\055\103\001\057\103\057\001\083\065\012\012\097\047\115\057\094"), 
							Media = zmediaLePetitPrince
						}, 
						{
							Text = _dJRF9("\006\065\061\012\001\012\065\117\117\057\012\001\022\057\112\057\055\061\012\001\022\057\012\001\034\117\097\012\001\057\103\001\092\056\034\097\001\017\065\117\083\076\097\012\001\084\061\057\001\115\065\076\012\084\061\056\065\055\001\057\012\103\001\034\083\083\076\097\112\065\097\012\057\062\001\115\057\001\022\057\083\034\076\103\001\022\056\061\055\001\034\117\097\001\076\057\055\022\001\103\076\097\012\103\057\001\057\103\001\115\056\097\022\057\057\001\022\057\001\012\065\055\001\076\057\103\065\061\076\001\076\057\055\022\001\032\057\061\076\057\061\020\001\057\103\001\031\057\047\076\097\115\057\094"), 
							Media = zmediaRenard
						}, 
						{
							Text = _dJRF9("\040\057\001\017\057\103\103\057\001\076\057\115\034\103\097\065\055\062\001\092\057\001\117\057\001\012\061\097\012\001\012\065\061\112\057\055\061\001\022\057\001\117\034\001\076\065\012\057\001\115\034\097\012\012\057\057\001\034\001\057\115\115\057\110\012\057\061\115\057\001\012\061\076\001\117\034\001\083\115\034\055\057\103\057\094\001\015\055\047\012\083\101\059\115\115\057\001\034\061\012\012\097\001\057\012\103\001\117\065\055\001\034\117\097\057\094\001\015\055\047\012\083\101\071\057\001\083\057\061\020\001\115\061\097\001\083\034\076\115\057\076\001\057\103\001\057\115\115\057\001\117\057\001\076\057\083\065\055\022\094\001\066\065\061\103\057\001\012\057\061\115\057\001\115\034\110\032\034\061\103\062\001\057\115\115\057\001\057\012\103\001\012\061\076\057\117\057\055\103\001\103\076\097\012\103\057\001\022\057\001\117\065\055\001\022\057\083\034\076\103\094"), 
							Media = zmediaFleur
						}, 
						{
							Text = _dJRF9("\052\057\055\022\065\055\012\110\055\065\061\012\001\034\061\001\078\061\097\103\012\094\001\015\055\047\012\083\101\071\057\001\112\065\061\012\001\076\034\017\065\055\103\057\076\034\097\001\115\034\001\031\097\055\001\022\057\001\017\057\103\103\057\001\047\057\115\115\057\001\032\097\012\103\065\097\076\057\094"), 
							Media = zmediaLePetitPrince
						}
					}
				else
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneLePuits)
				end
			end
		end
	}
end
function zoneCentredegeomatiqueduQuebec:OnEnter()
	zoneCathedrale.Visible = true
	zoneCathedrale.Active = true
	zcharacterLAllumeur.Visible = true
	_Urwigo.MessageBox{
		Text = _dJRF9("\040\056\061\055\057\001\117\034\055\097\057\076\057\001\103\076\057\012\001\012\097\117\083\115\097\031\097\057\057\062\001\115\034\001\089\057\065\117\034\103\097\084\061\057\001\057\012\103\001\115\057\001\031\076\061\097\103\001\022\056\061\055\001\092\061\117\057\115\034\089\057\001\022\057\001\022\057\061\020\001\022\097\012\017\097\083\115\097\055\057\012\062\001\115\034\001\005\059\044\005\052\085\078\068\043\059\001\057\103\001\115\056\043\006\030\044\052\013\085\066\043\127\018\059\094\001\096\057\103\103\057\001\012\035\055\057\076\089\097\057\001\083\057\076\117\057\103\001\022\057\001\022\057\112\057\115\065\083\083\057\076\001\022\057\012\001\017\034\076\103\057\012\001\097\055\103\057\115\115\097\089\057\055\103\057\012\001\057\103\001\097\055\103\057\076\076\065\089\057\034\047\115\057\012\062\001\017\056\057\012\103\110\034\110\022\097\076\057\001\061\055\057\001\017\034\076\103\065\089\076\034\083\032\097\057\001\022\035\055\034\117\097\084\061\057\001\083\034\076\001\065\083\083\065\012\097\103\097\065\055\001\034\001\061\055\057\001\017\034\076\103\057\001\089\057\065\089\076\034\083\032\097\084\061\057\001\012\061\076\001\083\034\083\097\057\076\062\001\084\061\097\001\057\115\115\057\062\001\057\012\103\001\012\103\034\103\097\084\061\057\094\051\072\052\048\081\034\001\089\057\065\117\034\103\097\084\061\057\001\057\012\103\001\115\057\001\117\057\097\115\115\057\061\076\001\097\055\012\103\076\061\117\057\055\103\001\022\056\065\083\103\097\117\097\012\034\103\097\065\055\001\022\057\012\001\083\065\103\057\055\103\097\057\115\012\001\022\057\001\089\057\012\103\097\065\055\062\001\022\056\034\117\057\055\034\089\057\117\057\055\103\001\057\103\001\022\057\001\022\057\112\057\115\065\083\083\057\117\057\055\103\001\057\017\065\055\065\117\097\084\061\057\001\083\065\061\076\001\061\055\057\001\076\057\089\097\065\055\001\012\083\057\017\097\031\097\084\061\057\094\051\072\052\048\078\034\076\001\034\097\115\115\057\061\076\012\062\001\061\103\097\115\097\012\057\012\001\017\065\117\117\057\001\012\061\083\083\065\076\103\001\034\001\115\034\001\083\076\097\012\057\001\022\057\001\022\057\017\097\012\097\065\055\062\001\115\057\012\001\065\061\103\097\115\012\001\089\057\065\117\034\103\097\084\061\057\012\001\012\065\055\103\001\034\061\092\065\061\076\022\056\032\061\097\001\022\057\012\001\117\065\035\057\055\012\001\057\031\031\097\017\034\017\057\012\001\022\056\034\103\103\057\097\055\022\076\057\001\022\057\012\001\055\065\061\112\057\034\061\020\001\012\103\034\055\103\034\076\022\012\001\022\057\001\083\057\076\031\065\076\117\034\055\017\057\001\057\103\001\022\057\001\083\076\065\022\061\017\103\097\112\097\103\057\094\001\040\057\001\083\034\076\001\115\034\001\017\034\083\034\017\097\103\057\001\022\056\034\055\034\115\035\012\057\001\057\103\001\022\056\097\022\057\055\103\097\031\097\017\034\103\097\065\055\001\022\057\012\001\103\057\055\022\034\055\017\057\012\062\001\115\034\001\089\057\065\117\034\103\097\084\061\057\001\022\065\055\055\057\001\061\055\057\001\117\057\097\115\115\057\061\076\057\001\117\034\097\103\076\097\012\057\001\022\061\001\022\057\112\057\115\065\083\083\057\117\057\055\103\001\057\103\001\012\061\083\083\065\076\103\057\001\083\061\097\012\012\034\117\117\057\055\103\001\115\034\001\083\076\097\012\057\001\022\057\001\022\057\017\097\012\097\065\055\012\001\012\103\076\034\103\057\089\097\084\061\057\012\094"), 
		Media = zmediaGeomatique, 
		Buttons = {
			_dJRF9("\078\076\065\017\032\034\097\055\057\001\057\103\034\083\057\094\094\094")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _dJRF9("\081\034\001\083\076\065\017\032\034\097\055\057\001\079\065\055\057\001\112\065\061\012\001\031\057\076\034\001\022\057\017\065\061\112\076\097\076\001\115\057\001\053\057\001\083\057\076\012\065\055\055\034\089\057\001\022\057\001\017\057\001\103\065\061\076\001\022\057\001\112\097\115\115\057\001\036\065\061\001\022\057\001\017\057\103\103\057\001\032\097\012\103\065\097\076\057\046\094\001\015\055\047\012\083\101\071\057\001\115\056\034\097\001\076\057\055\017\065\055\103\076\057\001\012\061\076\001\061\055\057\001\083\115\034\055\057\103\057\001\103\057\115\115\057\117\057\055\103\001\083\057\103\097\103\057\001\084\061\056\097\115\001\022\057\112\034\097\103\001\034\115\115\061\117\057\076\001\057\103\001\057\103\057\097\055\022\076\057\001\061\055\001\076\057\112\057\076\047\057\076\057\001\034\001\017\032\034\084\061\057\001\117\097\055\061\103\057\001\036\065\061\001\076\065\103\034\103\097\065\055\046\094"), 
					Media = zmediaLePetitPrince, 
					Buttons = {
						_dJRF9("\085\115\115\057\076\001\034\001\115\034\001\096\034\103\032\057\022\076\034\115\057\094\094\094")
					}, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneCathedrale)
						end
					end
				}
			end
		end
	}
end
function zoneCentredegeomatiqueduQuebec:OnExit()
	zcharacterLePetitPrince:MoveTo(zoneCathedrale)
	zonePalaisdejustice.Visible = false
	zonePalaisdejustice.Active = false
	zcharacterLeVaniteux.Visible = false
	ztaskAllerauCGQ.Complete = true
	ztaskAllerauCGQ.Visible = false
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneCathedrale)
end
function zoneLeTerrier:OnEnter()
	_Urwigo.MessageBox{
		Text = _dJRF9("\091\065\061\012\001\057\103\057\012\001\034\076\076\097\112\057\001\034\061\001\066\057\076\076\097\057\076\094\001\015\055\047\012\083\101\096\056\057\012\103\001\097\017\097\001\084\061\057\001\117\065\055\001\032\097\012\103\065\097\076\057\001\012\057\001\103\057\076\117\097\055\057\062\001\034\097\055\012\097\001\084\061\057\001\112\065\103\076\057\001\103\065\061\076\001\022\057\001\112\097\115\115\057\094\001\015\055\047\012\083\101\081\034\001\017\034\017\032\057\001\012\057\001\103\076\065\061\112\057\001\034\001\115\056\057\055\022\076\065\097\103\001\084\061\057\001\115\034\001\031\115\057\017\032\057\001\022\057\001\112\065\103\076\057\001\076\057\017\057\083\103\057\061\076\001\005\078\041\001\097\055\022\097\084\061\057\001\036\034\001\084\061\057\115\084\061\057\012\001\117\057\103\076\057\012\001\083\076\057\012\046\094\001\085\001\112\065\061\012\001\022\057\001\103\076\065\061\112\057\076\001\057\103\001\022\057\001\012\097\089\055\057\076\001\115\057\001\070\081\065\089\070\094\051\072\052\048\081\065\076\012\084\061\057\001\112\065\061\012\001\012\065\076\103\097\076\057\079\001\022\057\001\115\034\001\079\065\055\057\062\001\115\034\001\017\034\076\103\065\061\017\032\057\001\012\057\001\012\034\061\112\057\089\034\076\022\057\076\034\001\022\056\057\115\115\057\110\117\057\117\057\094"), 
		Media = zmediaRenard, 
		Buttons = {
			_dJRF9("\066\076\065\061\112\057\076\001\115\034\001\017\034\017\032\057\094\094\094")
		}, 
		Callback = function(action)
			if action ~= nil then
				ztaskAllerauTerrier.Complete = true
				ztaskAllerauTerrier.Visible = false
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneLeTerrier)
			end
		end
	}
end
function zoneLeTerrier:OnExit()
	_Urwigo.MessageBox{
		Text = _dJRF9("\081\057\001\078\057\103\097\103\001\078\076\097\055\017\057\001\057\012\103\001\076\057\083\034\076\103\097\001\012\061\076\001\012\034\001\083\115\034\055\057\103\057\094\094\094\051\072\052\048\059\055\001\103\034\055\103\001\084\061\057\001\070\017\076\057\034\103\057\061\076\070\001\022\057\001\017\057\103\103\057\001\017\034\076\103\065\061\017\032\057\001\010\032\057\076\097\089\065\062\001\092\057\001\112\065\061\012\001\076\057\117\057\076\017\097\057\001\022\057\001\115\056\034\112\065\097\076\001\092\065\061\057\057\094\001\015\055\047\012\083\101\081\057\012\001\017\065\117\117\057\055\103\034\097\076\057\012\001\083\065\012\097\103\097\031\012\001\065\061\001\055\057\089\034\103\097\031\012\001\012\065\055\103\001\103\065\061\012\001\115\057\012\001\047\097\057\055\112\057\055\061\012\094\051\072\052\048\091\065\061\012\001\083\065\061\112\057\079\001\031\057\076\117\057\076\001\115\034\001\017\034\076\103\065\061\017\032\057\001\057\055\001\083\076\057\012\012\034\055\103\001\012\061\076\001\115\057\001\047\065\061\103\065\055\001\070\030\057\076\117\057\076\001\115\034\001\017\034\076\103\065\061\017\032\057\070\001\083\115\061\012\001\047\034\012\094\001\015\055\047\012\083\101\018\055\057\001\012\034\061\112\057\089\034\076\022\057\001\034\061\103\065\117\034\103\097\084\061\057\001\012\056\057\020\057\017\061\103\057\076\034\001\057\103\001\115\057\001\012\103\034\103\061\103\001\070\096\065\117\083\115\057\103\057\022\070\001\112\065\061\012\001\083\057\076\117\057\103\103\076\034\001\022\057\001\022\057\112\057\076\076\065\061\097\115\115\057\076\001\115\034\001\017\034\076\103\065\061\017\032\057\001\012\061\076\001\010\032\057\076\097\089\065\094\017\065\117\094"), 
		Media = zmediaLaPlanete, 
		Buttons = {
			_dJRF9("\030\057\076\117\057\076\001\115\034\001\017\034\076\103\065\061\017\032\057")
		}, 
		Callback = function(action)
			if action ~= nil then
				cartLePetitPrince.Complete = true
				Wherigo.Command "SaveClose"
			end
		end
	}
end
function zoneLePuits:OnEnter()
	_Urwigo.MessageBox{
		Text = _dJRF9("\081\056\034\112\097\034\103\057\061\076\001\057\103\001\117\065\097\001\117\034\076\017\032\097\065\055\012\001\022\034\055\012\001\115\057\001\022\057\012\057\076\103\001\057\055\001\084\061\057\103\057\001\022\056\057\034\061\094\001\015\055\047\012\083\101\006\065\061\012\001\103\076\065\061\112\034\117\057\012\001\061\055\001\083\061\097\103\012\094\001\015\055\047\012\083\101\071\057\001\032\097\012\012\034\097\001\115\057\001\012\017\057\034\061\001\092\061\012\084\061\056\034\001\115\034\001\117\034\076\089\057\115\115\057\094\001\006\065\061\012\001\034\112\065\055\012\001\047\061\001\022\057\001\017\057\103\103\057\001\057\034\061\001\084\061\097\001\031\097\103\001\061\055\001\089\076\034\055\022\001\047\097\057\055\094\001\015\055\047\012\083\101\040\057\001\012\034\089\057\012\001\022\097\012\017\061\012\012\097\065\055\012\001\012\061\097\112\097\076\057\055\103\094\051\072\052\048\096\057\001\084\061\057\001\055\065\061\012\001\022\057\112\065\055\012\001\076\057\103\057\055\097\076\001\022\057\001\017\057\103\103\057\001\032\097\012\103\065\097\076\057\001\112\065\061\012\001\012\057\076\034\001\076\057\112\057\115\057\001\057\055\001\112\065\061\012\001\076\057\055\022\034\055\103\001\112\057\076\012\001\115\034\001\079\065\055\057\001\031\097\055\034\115\057\094\001\015\055\047\012\083\101\013\034\097\012\001\112\065\061\012\001\022\057\112\076\057\079\001\076\057\083\065\055\022\076\057\001\017\065\076\076\057\017\103\057\117\057\055\103\001\034\001\061\055\057\001\084\061\057\012\103\097\065\055\094\001\015\055\047\012\083\101\081\034\001\076\057\083\065\055\012\057\001\057\012\103\001\057\017\076\097\103\057\001\012\061\076\001\061\055\057\001\083\115\034\084\061\057\001\034\001\089\034\061\017\032\057\001\022\057\001\115\034\001\031\065\055\103\034\097\055\057\094"), 
		Media = zmediaLePetitPrince, 
		Buttons = {
			_dJRF9("\052\057\083\065\055\022\076\057\094\094\094")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(zinputPuits)
				end)
				if Wherigo.NoCaseEquals(Puits, _dJRF9("\072\085\081\059\006\044\078\066\059\052\059")) then
					zoneLeTerrier.Visible = true
					zoneLeTerrier.Active = true
				else
				end
			end
		end
	}
end
function zoneLePuits:OnExit()
	zcharacterLePetitPrince:MoveTo(zoneLeTerrier)
	zoneCathedrale.Visible = false
	zoneCathedrale.Active = false
	ztaskAllerauPuits.Complete = true
	ztaskAllerauPuits.Visible = false
	_Urwigo.MessageBox{
		Text = _dJRF9("\091\065\097\017\097\001\115\034\001\012\061\097\103\057\001\022\057\001\117\065\055\001\032\097\012\103\065\097\076\057\001\057\055\103\076\057\001\115\056\085\112\097\034\103\057\061\076\001\036\117\065\055\001\017\076\057\034\103\057\061\076\046\001\057\103\001\117\065\097\094"), 
		Media = zmediaLePetitPrince, 
		Buttons = {
			_dJRF9("\081\097\076\057\001\115\056\032\097\012\103\065\097\076\057\094\094\094"), 
			_dJRF9("\085\115\115\057\076\001\034\061\001\066\057\076\076\097\057\076")
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					_Urwigo.OldDialog{
						{
							Text = _dJRF9("\013\065\055\001\022\057\083\034\076\103\001\057\012\103\001\083\076\065\017\032\057\094\001\015\055\047\012\083\101\071\057\001\012\061\097\012\001\097\055\084\061\097\057\103\094\001\015\055\047\012\083\101\040\034\055\012\001\055\065\012\001\022\097\012\017\061\012\012\097\065\055\012\001\012\057\001\022\057\017\115\057\055\017\032\057\055\103\001\022\057\012\001\076\097\076\057\012\001\055\057\076\112\057\061\020\001\084\061\097\001\012\057\022\061\097\012\057\055\103\001\115\056\085\112\097\034\103\057\061\076\001\036\041\103\110\059\020\046\094\001\015\055\047\012\083\101\043\115\001\034\097\117\057\001\117\056\057\055\103\057\055\022\076\057\001\076\097\076\057\094\001\015\055\047\012\083\101\043\115\001\012\034\097\103\001\084\061\057\001\092\057\001\112\034\097\012\001\083\034\076\103\097\076\001\057\103\001\083\057\055\012\057\001\022\057\092\034\001\076\057\089\076\057\103\103\057\076\001\022\057\001\117\056\057\055\103\057\055\022\076\057\001\076\097\076\057\094\001\015\055\047\012\083\101\096\056\057\103\034\097\103\001\083\065\061\076\001\115\061\097\001\017\065\117\117\057\001\061\055\057\001\031\065\055\103\034\097\055\057\001\022\034\055\012\001\115\057\001\022\057\012\057\076\103\094"), 
							Media = zmediaLePetitPrince
						}, 
						{
							Text = _dJRF9("\070\078\057\103\097\103\001\047\065\055\032\065\117\117\057\062\001\092\057\001\112\057\061\020\001\057\055\017\065\076\057\001\103\056\057\055\103\057\055\022\076\057\001\076\097\076\057\094\094\094\001\015\055\047\012\083\101\040\097\012\110\117\065\097\001\084\061\057\001\017\056\057\012\103\001\061\055\001\117\034\061\112\034\097\012\001\076\057\112\057\001\103\065\055\001\022\057\083\034\076\103\042\070\051\072\052\048\071\057\001\115\061\097\001\076\057\083\065\055\022\097\103\001\084\061\057\001\115\056\097\117\083\065\076\103\034\055\103\001\055\057\001\012\057\001\112\065\097\103\001\083\034\012\094\001\096\056\057\012\103\001\017\065\117\117\057\001\083\065\061\076\001\061\055\057\001\031\115\057\061\076\094\001\041\097\001\103\061\001\034\097\117\057\012\001\061\055\057\001\031\115\057\061\076\001\084\061\097\001\012\057\001\103\076\065\061\112\057\001\022\034\055\012\001\061\055\057\001\057\103\065\097\115\057\062\001\017\056\057\012\103\001\022\065\061\020\062\001\115\034\001\055\061\097\103\062\001\022\057\001\076\057\089\034\076\022\057\076\001\115\057\001\017\097\057\115\094\001\015\055\047\012\083\101\066\065\061\103\057\012\001\115\057\012\001\057\103\065\097\115\057\012\001\012\065\055\103\001\034\115\065\076\012\001\031\115\057\061\076\097\057\012\094"), 
							Media = zmediaFleur
						}, 
						{
							Text = _dJRF9("\070\066\061\001\076\057\089\034\076\022\057\076\034\012\062\001\115\034\001\055\061\097\103\062\001\115\057\012\001\057\103\065\097\115\057\012\094\001\015\055\047\012\083\101\096\056\057\012\103\001\103\076\065\083\001\083\057\103\097\103\001\017\032\057\079\001\117\065\097\001\083\065\061\076\001\084\061\057\001\092\057\001\103\057\001\117\065\055\103\076\057\001\065\061\001\012\057\001\103\076\065\061\112\057\001\115\034\001\117\097\057\055\055\057\094\001\096\056\057\012\103\001\117\097\057\061\020\001\017\065\117\117\057\001\017\034\094\001\013\065\055\001\057\103\065\097\115\057\001\017\034\001\012\057\076\034\001\083\065\061\076\001\103\065\097\001\061\055\057\001\022\057\012\001\057\103\065\097\115\057\012\094\001\015\055\047\012\083\101\085\115\065\076\012\062\001\103\065\061\103\057\012\001\115\057\012\001\057\103\065\097\115\057\012\062\001\103\061\001\034\097\117\057\076\034\012\001\115\057\012\001\076\057\089\034\076\022\057\076\094\094\094\001\059\115\115\057\012\001\012\057\076\065\055\103\001\103\065\061\103\057\012\001\103\057\012\001\034\117\097\057\012\094\001\059\103\001\083\061\097\012\001\092\057\001\112\034\097\012\001\103\057\001\031\034\097\076\057\001\061\055\001\017\034\022\057\034\061\094\094\094\070"), 
							Media = zmediaLePetitPrince
						}, 
						{
							Text = _dJRF9("\070\127\061\034\055\022\001\103\061\001\076\057\089\034\076\022\057\076\034\012\001\115\057\001\017\097\057\115\062\001\115\034\001\055\061\097\103\062\001\083\061\097\012\084\061\057\001\092\056\032\034\047\097\103\057\076\034\097\001\022\034\055\012\001\115\056\061\055\057\001\022\056\057\115\115\057\012\062\001\083\061\097\012\084\061\057\001\092\057\001\076\097\076\034\097\001\022\034\055\012\001\115\056\061\055\057\001\022\056\057\115\115\057\012\062\001\034\115\065\076\012\001\017\057\001\012\057\076\034\001\083\065\061\076\001\103\065\097\001\017\065\117\117\057\001\012\097\001\076\097\034\097\057\055\103\001\103\065\061\103\057\012\001\115\057\012\001\057\103\065\097\115\057\012\094\001\015\055\047\012\083\101\066\061\001\034\061\076\034\012\062\001\103\065\097\062\001\022\057\012\001\057\103\065\097\115\057\012\001\084\061\097\001\012\034\112\057\055\103\001\076\097\076\057\042\070\051\072\052\048\070\059\103\001\084\061\034\055\022\001\103\061\001\012\057\076\034\012\001\017\065\055\012\065\115\057\001\036\065\055\001\012\057\001\017\065\055\012\065\115\057\001\103\065\061\092\065\061\076\012\046\001\103\061\001\012\057\076\034\012\001\017\065\055\103\057\055\103\001\022\057\001\117\056\034\112\065\097\076\001\017\065\055\055\061\094\001\066\061\001\012\057\076\034\012\001\103\065\061\092\065\061\076\012\001\117\065\055\001\034\117\097\094\001\066\061\001\034\061\076\034\012\001\057\055\112\097\057\001\022\057\001\076\097\076\057\001\034\112\057\017\001\117\065\097\070"), 
							Media = zmediaLePetitPrince
						}
					}
				else
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneLeTerrier)
				end
			end
		end
	}
end
function zinputHDV:OnGetInput(input)
	if input == nil then
		input = ""
	end
	HotelDeVille = input
	if Wherigo.NoCaseEquals(HotelDeVille, _dJRF9("\114\058\077\007")) then
		_Urwigo.MessageBox{
			Text = _dJRF9("\041\061\083\057\076\042\001\091\065\061\012\001\057\103\057\012\001\103\076\057\012\001\031\065\076\103\094\001\015\055\047\012\083\101\091\065\061\012\001\083\065\061\112\057\079\001\117\034\097\055\103\057\055\034\055\103\001\017\065\055\103\097\055\061\057\076\001\057\055\001\012\061\097\112\034\055\103\001\115\034\001\022\097\076\057\017\103\097\065\055\001\022\057\001\112\065\103\076\057\001\076\057\017\057\083\103\057\061\076\001\005\078\041\094"), 
			Media = zmediaLeRoi, 
			Buttons = {
				_dJRF9("\085\115\115\057\076\001\034\061\001\078\034\115\034\097\012")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zonePalaisdejustice)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _dJRF9("\068\061\117\117\042\001\013\034\061\112\034\097\012\057\001\076\057\083\065\055\012\057\094\001\059\012\012\034\035\057\079\001\034\001\055\065\061\112\057\034\061\094\094\094"), 
			Media = zmediaExclamation, 
			Buttons = {
				_dJRF9("\059\012\012\034\035\057\079\001\034\001\055\065\061\112\057\034\061\094\094\094"), 
				_dJRF9("\071\056\034\047\034\055\022\065\055\055\057")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputHDV)
						end)
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			end
		}
	end
end
function zinputPDJ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	PDJ = input
	if Wherigo.NoCaseEquals(PDJ, _dJRF9("\040\052\044\043\066\041")) then
		_Urwigo.MessageBox{
			Text = _dJRF9("\041\061\083\057\076\042\001\015\055\047\012\083\101\091\065\061\012\001\057\103\057\012\001\083\076\057\012\084\061\057\001\117\057\097\115\115\057\061\076\001\084\061\057\001\013\044\043\094"), 
			Media = zmediaLeVaniteux, 
			Buttons = {
				_dJRF9("\078\076\065\017\032\034\097\055\057\001\057\103\034\083\057\094\094\094")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneCentredegeomatiqueduQuebec)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _dJRF9("\068\061\117\117\042\001\015\055\047\012\083\101\013\034\061\112\034\097\012\057\001\076\057\083\065\055\012\057\094\001\015\055\047\012\083\101\059\012\012\034\035\057\079\001\022\057\001\055\065\061\112\057\034\061\094\094\094"), 
			Media = zmediaExclamation, 
			Buttons = {
				_dJRF9("\059\012\012\034\035\057\079\001\022\057\001\055\065\061\112\057\034\061\094\094\094")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputPDJ)
					end)
				end
			end
		}
	end
end
function zinputEcole:OnGetInput(input)
	if input == nil then
		input = ""
	end
end
function zinputPuits:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Puits = input
	if Wherigo.NoCaseEquals(Puits, _dJRF9("\072\085\081\059\006\044\078\066\059\052\059")) then
		_Urwigo.MessageBox{
			Text = _dJRF9("\072\065\055\055\057\001\076\057\083\065\055\012\057\094\001\015\055\047\012\083\101\081\034\001\079\065\055\057\001\031\097\055\034\115\057\001\057\012\103\001\117\034\097\055\103\057\055\034\055\103\001\034\017\103\097\112\057\057\001\057\103\001\112\065\061\012\001\083\065\061\112\057\079\001\112\065\061\012\001\035\001\076\057\055\022\076\057\094"), 
			Media = zmediaLePetitPrince, 
			Buttons = {
				_dJRF9("\085\115\115\057\076\001\034\001\115\034\001\031\097\055\034\115\057\094\094\094")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneLeTerrier)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _dJRF9("\068\061\117\117\042\001\015\055\047\012\083\101\013\034\061\112\034\097\012\057\001\076\057\083\065\055\012\057\094\001\015\055\047\012\083\101\059\012\012\034\035\057\079\001\034\001\055\065\061\112\057\034\061\094\094\094"), 
			Media = zmediaExclamation, 
			Buttons = {
				_dJRF9("\059\012\012\034\035\057\079\001\034\001\055\065\061\112\057\034\061\094\094\094")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputPuits)
					end)
				end
			end
		}
	end
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return cartLePetitPrince
