require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _y_6d(str)
	local res = ""
    local dtable = "\066\040\033\029\027\030\018\083\005\067\043\064\023\091\044\123\099\016\063\088\039\053\118\098\076\054\124\049\011\003\002\101\090\062\084\065\087\102\031\010\114\041\080\017\000\004\113\125\036\119\019\112\070\079\014\122\035\050\045\060\093\042\015\057\037\078\106\104\008\094\068\071\012\055\109\051\061\081\021\025\059\117\020\100\116\120\082\097\108\034\103\075\110\072\007\126\073\046\069\096\058\121\006\024\009\077\056\052\047\022\026\001\032\086\111\105\013\115\074\089\038\095\028\048\092\107\085"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

__jC = Wherigo.ZCartridge()

-- Media --
_YqIq = Wherigo.ZMedia(__jC)
_YqIq.Id = "f124c176-9c9e-43a4-a86e-a2403f9eb02a"
_YqIq.Name = _y_6d("\118\085\088\041\085")
_YqIq.Description = ""
_YqIq.AltText = ""
_YqIq.Resources = {
	{
		Type = "jpg", 
		Filename = "start.jpg", 
		Directives = {}
	}
}
_mpP = Wherigo.ZMedia(__jC)
_mpP.Id = "f45b0c14-6083-4338-b21d-694464b3fbc4"
_mpP.Name = _y_6d("\050\088\052\052\032\093\122\116\017\115")
_mpP.Description = ""
_mpP.AltText = ""
_mpP.Resources = {
	{
		Type = "jpg", 
		Filename = "wappen_ico.jpg", 
		Directives = {}
	}
}
_0BT = Wherigo.ZMedia(__jC)
_0BT.Id = "e5a3cc91-152a-4243-89df-c4edb83136fb"
_0BT.Name = _y_6d("\085\088\038\032\089")
_0BT.Description = ""
_0BT.AltText = ""
_0BT.Resources = {
	{
		Type = "jpg", 
		Filename = "wege_deutscher.jpg", 
		Directives = {}
	}
}
_Xqzb = Wherigo.ZMedia(__jC)
_Xqzb.Id = "5d6f35b8-ef38-44bd-94b3-945ac3e3f706"
_Xqzb.Name = _y_6d("\072\082\093\093\088\041")
_Xqzb.Description = ""
_Xqzb.AltText = ""
_Xqzb.Resources = {
	{
		Type = "jpg", 
		Filename = "zwerg_gunnar.jpg", 
		Directives = {}
	}
}
_F7TM_ = Wherigo.ZMedia(__jC)
_F7TM_.Id = "bbe6ba58-80df-4e9a-a5a4-0628eeb7db82"
_F7TM_.Name = _y_6d("\072\082\093\093\088\041\122\116\017\115")
_F7TM_.Description = ""
_F7TM_.AltText = ""
_F7TM_.Resources = {
	{
		Type = "jpg", 
		Filename = "zwerg_ico.jpg", 
		Directives = {}
	}
}
_v5zG = Wherigo.ZMedia(__jC)
_v5zG.Id = "4c62cbdd-d492-4c92-a11c-f7a0d8e0cd66"
_v5zG.Name = _y_6d("\072\082\093\093\088\041\113\091\032\068\085\113\089\116\093\126\118")
_v5zG.Description = ""
_v5zG.AltText = ""
_v5zG.Resources = {
	{
		Type = "jpg", 
		Filename = "zwerg_geht.jpg", 
		Directives = {}
	}
}
_l45z = Wherigo.ZMedia(__jC)
_l45z.Id = "1bc54e26-9365-452d-9b07-321a4e0226b3"
_l45z.Name = _y_6d("\072\082\093\093\088\041\113\075\116\085\113\008\088\017\126")
_l45z.Description = ""
_l45z.AltText = ""
_l45z.Resources = {
	{
		Type = "jpg", 
		Filename = "zwerg_mit_sack.jpg", 
		Directives = {}
	}
}
_zQk = Wherigo.ZMedia(__jC)
_zQk.Id = "dde1210b-a913-4d52-8fae-0098f8fba4eb"
_zQk.Name = _y_6d("\091\082\093\093\088\041\113\118\116\085\056\032\093\084")
_zQk.Description = ""
_zQk.AltText = ""
_zQk.Resources = {
	{
		Type = "jpg", 
		Filename = "zwerg_sitzt.jpg", 
		Directives = {}
	}
}
_prO = Wherigo.ZMedia(__jC)
_prO.Id = "27b79dfd-628f-406c-9021-03b0ae966d22"
_prO.Name = _y_6d("\072\082\093\093\088\041\113\118\082\017\068\085")
_prO.Description = ""
_prO.AltText = ""
_prO.Resources = {
	{
		Type = "jpg", 
		Filename = "zwerg_sucht.jpg", 
		Directives = {}
	}
}
_Qbe = Wherigo.ZMedia(__jC)
_Qbe.Id = "d45e7da2-ed95-4c62-8586-697985c15255"
_Qbe.Name = _y_6d("\072\082\093\093\088\041\113\050\088\041\085\032\085")
_Qbe.Description = ""
_Qbe.AltText = ""
_Qbe.Resources = {
	{
		Type = "jpg", 
		Filename = "zwerg_warten.jpg", 
		Directives = {}
	}
}
_CiY10 = Wherigo.ZMedia(__jC)
_CiY10.Id = "430c5452-a551-40a2-91d0-63816959514d"
_CiY10.Name = _y_6d("\041\032\093\093\038\032\082\032\041\115\038\032\093")
_CiY10.Description = ""
_CiY10.AltText = ""
_CiY10.Resources = {
	{
		Type = "jpg", 
		Filename = "rennfeuerofen.jpg", 
		Directives = {}
	}
}
_8b4l = Wherigo.ZMedia(__jC)
_8b4l.Id = "99db09e9-8a47-4b0d-9b60-7889b431027a"
_8b4l.Name = _y_6d("\052\089\088\093")
_8b4l.Description = ""
_8b4l.AltText = ""
_8b4l.Resources = {
	{
		Type = "jpg", 
		Filename = "jasperode_hist.jpg", 
		Directives = {}
	}
}
_b7n = Wherigo.ZMedia(__jC)
_b7n.Id = "7e2892cb-985f-4bad-86ef-e62357bda4cb"
_b7n.Name = _y_6d("\078\082\032\089\089\032")
_b7n.Description = ""
_b7n.AltText = ""
_b7n.Resources = {
	{
		Type = "jpg", 
		Filename = "quelle.jpg", 
		Directives = {}
	}
}
_UrdgH = Wherigo.ZMedia(__jC)
_UrdgH.Id = "7cdda1d0-3b48-48bb-b5e2-b281ec09881e"
_UrdgH.Name = _y_6d("\072\082\093\093\088\041\113\091\032\068\085\113\041\032\017\068\085\118")
_UrdgH.Description = ""
_UrdgH.AltText = ""
_UrdgH.Resources = {
	{
		Type = "jpg", 
		Filename = "zwerg_geht_rechts.jpg", 
		Directives = {}
	}
}
_sxL = Wherigo.ZMedia(__jC)
_sxL.Id = "455967b5-373d-4cae-83ae-e89f474e18a6"
_sxL.Name = _y_6d("\008\085\082\075\052\038")
_sxL.Description = ""
_sxL.AltText = ""
_sxL.Resources = {
	{
		Type = "jpg", 
		Filename = "baumstumpf.jpg", 
		Directives = {}
	}
}
_UIo = Wherigo.ZMedia(__jC)
_UIo.Id = "95d1ce9d-660f-41f7-ac84-0c891532c252"
_UIo.Name = _y_6d("\066\088\085\082\041\028")
_UIo.Description = ""
_UIo.AltText = ""
_UIo.Resources = {
	{
		Type = "jpg", 
		Filename = "natur_adl.jpg", 
		Directives = {}
	}
}
_I80 = Wherigo.ZMedia(__jC)
_I80.Id = "d82bd53a-2c34-4802-a530-0f9027056aa0"
_I80.Name = _y_6d("\066\088\085\082\041\058")
_I80.Description = ""
_I80.AltText = ""
_I80.Resources = {
	{
		Type = "jpg", 
		Filename = "natur_eule_drei.jpg", 
		Directives = {}
	}
}
_QBrS = Wherigo.ZMedia(__jC)
_QBrS.Id = "933f09c6-0e31-418d-8a4c-f668f542b681"
_QBrS.Name = _y_6d("\066\088\085\082\041\076")
_QBrS.Description = ""
_QBrS.AltText = ""
_QBrS.Resources = {
	{
		Type = "jpg", 
		Filename = "natur_eule_gelb.jpg", 
		Directives = {}
	}
}
_mG9x = Wherigo.ZMedia(__jC)
_mG9x.Id = "c7ad1307-587f-40bf-991b-e797381e06b9"
_mG9x.Name = _y_6d("\066\088\085\082\041\108")
_mG9x.Description = ""
_mG9x.AltText = ""
_mG9x.Resources = {
	{
		Type = "jpg", 
		Filename = "natur_eule_sa.jpg", 
		Directives = {}
	}
}
_nyiw = Wherigo.ZMedia(__jC)
_nyiw.Id = "199f5c83-7087-46f8-aba8-3d436c1166c1"
_nyiw.Name = _y_6d("\066\088\085\082\041\022")
_nyiw.Description = ""
_nyiw.AltText = ""
_nyiw.Resources = {
	{
		Type = "jpg", 
		Filename = "amphibienwanderung.jpg", 
		Directives = {}
	}
}
_E65 = Wherigo.ZMedia(__jC)
_E65.Id = "f7526a63-3da0-4c45-aa1f-8da56738f603"
_E65.Name = _y_6d("\024\032\041\091\024\088\082")
_E65.Description = ""
_E65.AltText = ""
_E65.Resources = {
	{
		Type = "jpg", 
		Filename = "bergbau.jpg", 
		Directives = {}
	}
}
_6Hwk = Wherigo.ZMedia(__jC)
_6Hwk.Id = "a5140003-b426-4a2a-b77d-b3e86969320a"
_6Hwk.Name = _y_6d("\024\088\082\075\068\088\082\118")
_6Hwk.Description = ""
_6Hwk.AltText = ""
_6Hwk.Resources = {
	{
		Type = "jpg", 
		Filename = "baumhaus.jpg", 
		Directives = {}
	}
}
_nKpZT = Wherigo.ZMedia(__jC)
_nKpZT.Id = "c02cc896-380d-4584-a9a6-5af67951a2a4"
_nKpZT.Name = _y_6d("\024\115\068\041\032\093")
_nKpZT.Description = ""
_nKpZT.AltText = ""
_nKpZT.Resources = {
	{
		Type = "jpg", 
		Filename = "bohrung.jpg", 
		Directives = {}
	}
}
_vptKq = Wherigo.ZMedia(__jC)
_vptKq.Id = "d58f9444-b74d-4f42-a076-faf500b95808"
_vptKq.Name = _y_6d("\118\017\068\082\041\038")
_vptKq.Description = ""
_vptKq.AltText = ""
_vptKq.Resources = {
	{
		Type = "jpg", 
		Filename = "suche.jpg", 
		Directives = {}
	}
}
_FbS2K = Wherigo.ZMedia(__jC)
_FbS2K.Id = "74030c84-b6df-423a-a7c9-63f4fdbdfa6f"
_FbS2K.Name = _y_6d("\052\041\115\118\052\032\126\085")
_FbS2K.Description = ""
_FbS2K.AltText = ""
_FbS2K.Resources = {
	{
		Type = "jpg", 
		Filename = "prospektion.jpg", 
		Directives = {}
	}
}
_97jm = Wherigo.ZMedia(__jC)
_97jm.Id = "d3905596-763a-42aa-a831-910f9bbc5035"
_97jm.Name = _y_6d("\091\115\089\084")
_97jm.Description = ""
_97jm.AltText = ""
_97jm.Resources = {
	{
		Type = "jpg", 
		Filename = "gold.jpg", 
		Directives = {}
	}
}
_xGU = Wherigo.ZMedia(__jC)
_xGU.Id = "9e3aff2a-f36b-4f38-9a84-a85cfb9780ac"
_xGU.Name = _y_6d("\067\088\118\052\032\041")
_xGU.Description = ""
_xGU.AltText = ""
_xGU.Resources = {
	{
		Type = "jpg", 
		Filename = "jasper.jpg", 
		Directives = {}
	}
}
_Pud7 = Wherigo.ZMedia(__jC)
_Pud7.Id = "f9bfc5b3-da09-4b25-8d48-97512d84897d"
_Pud7.Name = _y_6d("\091\041\032\093\056\032\028")
_Pud7.Description = ""
_Pud7.AltText = ""
_Pud7.Resources = {
	{
		Type = "jpg", 
		Filename = "grenze1.jpg", 
		Directives = {}
	}
}
_rGF = Wherigo.ZMedia(__jC)
_rGF.Id = "99afd3f2-4dbd-4b3f-8561-5b768498c830"
_rGF.Name = _y_6d("\091\041\032\093\056\032\058")
_rGF.Description = ""
_rGF.AltText = ""
_rGF.Resources = {
	{
		Type = "jpg", 
		Filename = "grenze2.jpg", 
		Directives = {}
	}
}
_9SoNb = Wherigo.ZMedia(__jC)
_9SoNb.Id = "7b46efe2-d225-4ec4-96cf-6504b8c432bc"
_9SoNb.Name = _y_6d("\038\032\041\116\032\093\089\088\091\032\041")
_9SoNb.Description = ""
_9SoNb.AltText = ""
_9SoNb.Resources = {
	{
		Type = "jpg", 
		Filename = "ferienlager.jpg", 
		Directives = {}
	}
}
_fIgp_ = Wherigo.ZMedia(__jC)
_fIgp_.Id = "dce4a246-b28c-4f59-9c3b-125a555a397d"
_fIgp_.Name = _y_6d("\085\032\116\017\068\032")
_fIgp_.Description = ""
_fIgp_.AltText = ""
_fIgp_.Resources = {
	{
		Type = "jpg", 
		Filename = "fischteich2.jpg", 
		Directives = {}
	}
}
_lWv8z = Wherigo.ZMedia(__jC)
_lWv8z.Id = "2117e90b-199f-4c28-b28f-00a03a790e57"
_lWv8z.Name = _y_6d("\036\068\115\041\093")
_lWv8z.Description = ""
_lWv8z.AltText = ""
_lWv8z.Resources = {
	{
		Type = "jpg", 
		Filename = "ahorn_sommer.jpg", 
		Directives = {}
	}
}
_MbD = Wherigo.ZMedia(__jC)
_MbD.Id = "3a03d7b5-1839-4097-964d-327b8d9d782d"
_MbD.Name = _y_6d("\087\116\093\093\032")
_MbD.Description = ""
_MbD.AltText = ""
_MbD.Resources = {
	{
		Type = "jpg", 
		Filename = "rinne.jpg", 
		Directives = {}
	}
}
_t_xQ6 = Wherigo.ZMedia(__jC)
_t_xQ6.Id = "6685728f-5382-4fd0-945d-d773f518c93a"
_t_xQ6.Name = _y_6d("\041\032\093\093\032\093")
_t_xQ6.Description = ""
_t_xQ6.AltText = ""
_t_xQ6.Resources = {
	{
		Type = "jpg", 
		Filename = "rennen.jpg", 
		Directives = {}
	}
}
_P8F = Wherigo.ZMedia(__jC)
_P8F.Id = "e7aa94e1-5fa2-457c-b88a-85149d92ec72"
_P8F.Name = _y_6d("\088\068\115\041\093\058")
_P8F.Description = ""
_P8F.AltText = ""
_P8F.Resources = {
	{
		Type = "jpg", 
		Filename = "ahorn2.jpg", 
		Directives = {}
	}
}
_HT54v = Wherigo.ZMedia(__jC)
_HT54v.Id = "6da2c46b-b1a9-402e-8a4e-70e8ab4fa7b5"
_HT54v.Name = _y_6d("\052\088\041\126\032\093")
_HT54v.Description = ""
_HT54v.AltText = ""
_HT54v.Resources = {
	{
		Type = "jpg", 
		Filename = "parken.jpg", 
		Directives = {}
	}
}
_5lg = Wherigo.ZMedia(__jC)
_5lg.Id = "ed5755b0-fda7-47e5-863d-9ae2c7c941de"
_5lg.Name = _y_6d("\089\115\091\115")
_5lg.Description = ""
_5lg.AltText = ""
_5lg.Resources = {
	{
		Type = "jpg", 
		Filename = "SecuRitty_bq.jpg", 
		Directives = {}
	}
}
_rqVE = Wherigo.ZMedia(__jC)
_rqVE.Id = "36a83aa8-49cf-4673-abf4-b6155481ce65"
_rqVE.Name = _y_6d("\066\088\085\082\041\118\017\068\082\085\056")
_rqVE.Description = ""
_rqVE.AltText = ""
_rqVE.Resources = {
	{
		Type = "jpg", 
		Filename = "naturschutz.jpg", 
		Directives = {}
	}
}
_IS06 = Wherigo.ZMedia(__jC)
_IS06.Id = "f83e55fa-2392-493f-a0dd-f463a23d90b3"
_IS06.Name = _y_6d("\033\032\085\085\032\089")
_IS06.Description = ""
_IS06.AltText = ""
_IS06.Resources = {
	{
		Type = "jpg", 
		Filename = "zettel.jpg", 
		Directives = {}
	}
}
_6EG = Wherigo.ZMedia(__jC)
_6EG.Id = "84581209-418b-4618-9529-3fc7bacc7cca"
_6EG.Name = _y_6d("\056\032\085\085\032\089\122\116\017\115")
_6EG.Description = ""
_6EG.AltText = ""
_6EG.Resources = {
	{
		Type = "jpg", 
		Filename = "zettel_ico.jpg", 
		Directives = {}
	}
}
_ypp = Wherigo.ZMedia(__jC)
_ypp.Id = "c249da71-bd06-4cb9-8736-0893c37eabfa"
_ypp.Name = _y_6d("\017\115\116\093")
_ypp.Description = ""
_ypp.AltText = ""
_ypp.Resources = {
	{
		Type = "jpg", 
		Filename = "CoinSR.jpg", 
		Directives = {}
	}
}
_d15j = Wherigo.ZMedia(__jC)
_d15j.Id = "6143e2ac-9d56-4874-b692-b26b7f3d9ec1"
_d15j.Name = _y_6d("\017\115\116\093\113\116\017\115")
_d15j.Description = ""
_d15j.AltText = ""
_d15j.Resources = {
	{
		Type = "jpg", 
		Filename = "CoinSRico.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
__jC.Id="c29abdde-ef27-48cb-9f0d-7d1b0dfe9907"
__jC.Name="Jasperode"
__jC.Description=[[Quellort des Goldbaches, mittelalterliches Bergbaugebiet und Industriezentrum, Wallanlage, Ferienlager und Ferienhaussiedlung - all das war diese Siedlung, welche neben JASPERODE noch viele andere Namen hatte. Heute heisst sie Eggeroeder Brunnen, die, so klein sie auch zu sein scheint, doch einige Besonderheiten bereit haelt. 

Gespannt? Komm mit!]]
__jC.Visible=true
__jC.Activity="Puzzle"
__jC.StartingLocationDescription=[[An den Start-Koordinaten kann auch geparkt werden. Von hieraus beginnt die Tour.]]
__jC.StartingLocation = ZonePoint(51.7829238454566,10.8574953867626,0)
__jC.Version="1.3"
__jC.Company=""
__jC.Author="SecuRitty"
__jC.BuilderVersion="URWIGO 1.14.4469.18959"
__jC.CreateDate="01/30/2012 10:23:45"
__jC.PublishDate="1/1/0001 12:00:00 AM"
__jC.UpdateDate="10/24/2012 19:55:59"
__jC.LastPlayedDate="1/1/0001 12:00:00 AM"
__jC.TargetDevice="PocketPC"
__jC.TargetDeviceVersion="0"
__jC.StateId="1"
__jC.CountryId="2"
__jC.Complete=false
__jC.UseLogging=true

__jC.Media=_YqIq

__jC.Icon=_mpP


-- Zones --
_awC4D = Wherigo.Zone(__jC)
_awC4D.Id = "121434b1-0d91-4306-9240-0f06a49af77a"
_awC4D.Name = _y_6d("\094\116\093\050\032\116\118\085\088\038\032\089")
_awC4D.Description = _y_6d("\094\116\032\041\113\118\085\032\068\085\113\032\116\093\113\008\017\068\116\089\084\113\056\082\075\113\035\068\032\075\088\113\090\037\032\091\032\113\084\032\082\085\118\017\068\032\041\113\092\088\116\118\032\041\113\082\093\084\113\092\115\032\093\116\091\032\113\084\032\118\113\106\116\085\085\032\089\088\089\085\032\041\118\113\116\075\113\094\088\041\056\090\098\113\071\088\041\088\082\038\113\116\118\085\113\032\116\093\032\113\126\082\041\056\032\113\001\032\118\017\068\041\032\116\024\082\093\091\113\056\082\041\113\072\032\118\017\068\116\017\068\085\032\113\084\032\041\113\008\116\032\084\089\082\093\091\113\082\093\084\113\032\116\093\113\126\089\032\116\093\032\041\113\127\032\024\032\041\024\089\116\017\126\113\023\115\093\113\116\068\041\098")
_awC4D.Visible = false
_awC4D.Media = _0BT
_awC4D.Commands = {}
_awC4D.DistanceRange = Distance(-1, "feet")
_awC4D.ShowObjects = "OnEnter"
_awC4D.ProximityRange = Distance(60, "meters")
_awC4D.AllowSetPositionTo = false
_awC4D.Active = false
_awC4D.Points = {
	ZonePoint(51.7830018338385, 10.8577166690063, 0), 
	ZonePoint(51.7829935372085, 10.8576093806457, 0), 
	ZonePoint(51.7830798220855, 10.8575771941375, 0), 
	ZonePoint(51.7830864593769, 10.857654978199, 0)
}
_awC4D.OriginalPoint = ZonePoint(51.7830404131273, 10.8576395554971, 0)
_awC4D.DistanceRangeUOM = "Feet"
_awC4D.ProximityRangeUOM = "Meters"
_awC4D.OutOfRangeName = ""
_awC4D.InRangeName = ""
_ewA6 = Wherigo.Zone(__jC)
_ewA6.Id = "84531c46-1f44-4d6f-b58d-e30cf4742ed5"
_ewA6.Name = _y_6d("\008\085\088\041\085")
_ewA6.Description = _y_6d("\094\116\032\041\113\038\116\093\084\032\118\085\113\071\082\113\024\032\118\085\116\075\075\085\113\032\116\093\032\093\113\043\088\041\126\052\089\088\085\056\098")
_ewA6.Visible = true
_ewA6.Media = _HT54v
_ewA6.Commands = {}
_ewA6.DistanceRange = Distance(-1, "feet")
_ewA6.ShowObjects = "OnEnter"
_ewA6.ProximityRange = Distance(60, "meters")
_ewA6.AllowSetPositionTo = false
_ewA6.Active = false
_ewA6.Points = {
	ZonePoint(51.7829039335078, 10.8574229671192, 0), 
	ZonePoint(51.7828840215502, 10.8576375438404, 0), 
	ZonePoint(51.7829968558608, 10.8575838996601, 0), 
	ZonePoint(51.7829968558608, 10.8574176027012, 0)
}
_ewA6.OriginalPoint = ZonePoint(51.7829454166949, 10.8575155033302, 0)
_ewA6.DistanceRangeUOM = "Feet"
_ewA6.ProximityRangeUOM = "Meters"
_ewA6.OutOfRangeName = ""
_ewA6.InRangeName = ""
_Kcp4m = Wherigo.Zone(__jC)
_Kcp4m.Id = "9c64790c-fa9b-44e8-9947-5ad5b3e76810"
_Kcp4m.Name = _y_6d("\078\082\032\089\089\032")
_Kcp4m.Description = _y_6d("\036\093\113\084\116\032\118\032\041\113\008\085\032\089\089\032\113\032\093\085\118\052\041\116\093\091\085\113\084\032\041\113\072\115\089\084\024\088\017\068\098")
_Kcp4m.Visible = false
_Kcp4m.Media = _b7n
_Kcp4m.Commands = {}
_Kcp4m.DistanceRange = Distance(-1, "feet")
_Kcp4m.ShowObjects = "OnEnter"
_Kcp4m.ProximityRange = Distance(60, "meters")
_Kcp4m.AllowSetPositionTo = false
_Kcp4m.Active = false
_Kcp4m.Points = {
	ZonePoint(51.7829000760526, 10.8580015365696, 0), 
	ZonePoint(51.7829470760527, 10.8579567267132, 0), 
	ZonePoint(51.7830018338386, 10.8580962015819, 0), 
	ZonePoint(51.7829520540359, 10.8581686212253, 0)
}
_Kcp4m.OriginalPoint = ZonePoint(51.7829502599949, 10.8580557715225, 0)
_Kcp4m.DistanceRangeUOM = "Feet"
_Kcp4m.ProximityRangeUOM = "Meters"
_Kcp4m.OutOfRangeName = ""
_Kcp4m.InRangeName = ""
_IQbE = Wherigo.Zone(__jC)
_IQbE.Id = "40e61757-a56e-401e-928d-d62075bb3fc4"
_IQbE.Name = _y_6d("\001\088\082\075\118\085\082\075\052\038")
_IQbE.Description = _y_6d("\094\116\032\041\113\050\082\041\084\032\113\032\116\093\113\032\116\093\118\085\113\052\041\088\032\017\068\085\116\091\032\041\113\072\032\118\032\089\089\032\113\023\032\041\118\085\082\032\075\075\032\089\085\098")
_IQbE.Visible = false
_IQbE.Media = _sxL
_IQbE.Commands = {}
_IQbE.DistanceRange = Distance(-1, "feet")
_IQbE.ShowObjects = "OnEnter"
_IQbE.ProximityRange = Distance(60, "meters")
_IQbE.AllowSetPositionTo = false
_IQbE.Active = false
_IQbE.Points = {
	ZonePoint(51.7843988282073, 10.8569569768715, 0), 
	ZonePoint(51.7844434955601, 10.8570752272033, 0), 
	ZonePoint(51.7843870802491, 10.8572120198631, 0), 
	ZonePoint(51.7842842050887, 10.8571556934737, 0), 
	ZonePoint(51.7842891829244, 10.8569893965148, 0)
}
_IQbE.OriginalPoint = ZonePoint(51.7843605584059, 10.8570778627853, 0)
_IQbE.DistanceRangeUOM = "Feet"
_IQbE.ProximityRangeUOM = "Meters"
_IQbE.OutOfRangeName = ""
_IQbE.InRangeName = ""
_dnY = Wherigo.Zone(__jC)
_dnY.Id = "7b6c42fa-e04c-45fd-a829-3cea352923ba"
_dnY.Name = _y_6d("\008\017\068\088\017\068\085")
_dnY.Description = _y_6d("\008\017\068\088\032\085\056\032\113\088\082\118\113\084\032\041\113\099\041\084\032")
_dnY.Visible = false
_dnY.Media = _E65
_dnY.Commands = {}
_dnY.DistanceRange = Distance(-1, "feet")
_dnY.ShowObjects = "OnEnter"
_dnY.ProximityRange = Distance(60, "meters")
_dnY.AllowSetPositionTo = false
_dnY.Active = false
_dnY.Points = {
	ZonePoint(51.7846026967578, 10.8579713475799, 0), 
	ZonePoint(51.7846065920524, 10.8578197156332, 0), 
	ZonePoint(51.7844650661015, 10.8578128346824, 0), 
	ZonePoint(51.7844401770142, 10.857933534088, 0)
}
_dnY.OriginalPoint = ZonePoint(51.7845286329815, 10.8578843579959, 0)
_dnY.DistanceRangeUOM = "Feet"
_dnY.ProximityRangeUOM = "Meters"
_dnY.OutOfRangeName = ""
_dnY.InRangeName = ""
_ffHh = Wherigo.Zone(__jC)
_ffHh.Id = "8d31b479-5d37-4ac5-bd7d-eae5f9fe4028"
_ffHh.Name = _y_6d("\037\088\017\068\085\082\041\075")
_ffHh.Description = _y_6d("\099\116\093\032\113\126\082\041\056\032\113\087\032\116\118\032\113\116\093\113\084\116\032\113\114\032\041\091\088\093\091\032\093\068\032\116\085")
_ffHh.Visible = false
_ffHh.Media = _6Hwk
_ffHh.Commands = {}
_ffHh.DistanceRange = Distance(-1, "feet")
_ffHh.ShowObjects = "OnEnter"
_ffHh.ProximityRange = Distance(60, "meters")
_ffHh.AllowSetPositionTo = false
_ffHh.Active = false
_ffHh.Points = {
	ZonePoint(51.7841132990616, 10.8586940716266, 0), 
	ZonePoint(51.7841448254648, 10.8585143636226, 0), 
	ZonePoint(51.7844351991952, 10.858589465475, 0), 
	ZonePoint(51.7843854209741, 10.8590078900813, 0)
}
_ffHh.OriginalPoint = ZonePoint(51.7842696861739, 10.8587014477014, 0)
_ffHh.DistanceRangeUOM = "Feet"
_ffHh.ProximityRangeUOM = "Meters"
_ffHh.OutOfRangeName = ""
_ffHh.InRangeName = ""
_PhG = Wherigo.Zone(__jC)
_PhG.Id = "e36ae31f-42f1-4f12-b5b2-32aeb24d6818"
_PhG.Name = _y_6d("\094\088\089\084\032")
_PhG.Description = _y_6d("\092\089\032\116\093\032\041\113\127\032\024\032\041\024\089\116\017\126")
_PhG.Visible = false
_PhG.Media = _YqIq
_PhG.Commands = {}
_PhG.DistanceRange = Distance(-1, "feet")
_PhG.ShowObjects = "OnEnter"
_PhG.ProximityRange = Distance(60, "meters")
_PhG.AllowSetPositionTo = false
_PhG.Active = false
_PhG.Points = {
	ZonePoint(51.7839041153806, 10.8617936267087, 0), 
	ZonePoint(51.7838909543293, 10.8615895162582, 0), 
	ZonePoint(51.7840734762051, 10.8615868340491, 0), 
	ZonePoint(51.7840618611986, 10.8617772708892, 0)
}
_PhG.OriginalPoint = ZonePoint(51.7839826017784, 10.8616868119763, 0)
_PhG.DistanceRangeUOM = "Feet"
_PhG.ProximityRangeUOM = "Meters"
_PhG.OutOfRangeName = ""
_PhG.InRangeName = ""
_ibQpx = Wherigo.Zone(__jC)
_ibQpx.Id = "83244b8b-9c83-460d-a087-40e6d1428968"
_ibQpx.Name = _y_6d("\053\116\118\017\068\085\032\116\017\068\032")
_ibQpx.Description = _y_6d("\114\115\041\118\116\017\068\085\003\113\053\032\082\017\068\085\032\113\053\082\032\118\118\032\113\098\098\098\098")
_ibQpx.Visible = false
_ibQpx.Media = _fIgp_
_ibQpx.Commands = {}
_ibQpx.DistanceRange = Distance(-1, "feet")
_ibQpx.ShowObjects = "OnEnter"
_ibQpx.ProximityRange = Distance(60, "meters")
_ibQpx.AllowSetPositionTo = false
_ibQpx.Active = false
_ibQpx.Points = {
	ZonePoint(51.7821805173021, 10.8622240046882, 0), 
	ZonePoint(51.7821915392355, 10.8624344120979, 0), 
	ZonePoint(51.7822628914717, 10.8624370943069, 0), 
	ZonePoint(51.7822562540591, 10.8622225175857, 0)
}
_ibQpx.OriginalPoint = ZonePoint(51.7822228005171, 10.8623295071697, 0)
_ibQpx.DistanceRangeUOM = "Feet"
_ibQpx.ProximityRangeUOM = "Meters"
_ibQpx.OutOfRangeName = ""
_ibQpx.InRangeName = ""
_PEJMF = Wherigo.Zone(__jC)
_PEJMF.Id = "0d6c2a46-5986-4517-90ea-d0d232b15b3c"
_PEJMF.Name = _y_6d("\036\068\115\041\093")
_PEJMF.Description = _y_6d("\099\116\093\113\001\088\082\075\113\023\115\093\113\108\124\124\113\119\088\068\041\032\093")
_PEJMF.Visible = false
_PEJMF.Media = _P8F
_PEJMF.Commands = {}
_PEJMF.DistanceRange = Distance(-1, "feet")
_PEJMF.ShowObjects = "OnEnter"
_PEJMF.ProximityRange = Distance(60, "meters")
_PEJMF.AllowSetPositionTo = false
_PEJMF.Active = false
_PEJMF.Points = {
	ZonePoint(51.78177, 10.86235, 0), 
	ZonePoint(51.7817601751014, 10.8622088048935, 0), 
	ZonePoint(51.7818369002334, 10.8622773472214, 0)
}
_PEJMF.OriginalPoint = ZonePoint(51.7817890251116, 10.8622787173716, 0)
_PEJMF.DistanceRangeUOM = "Feet"
_PEJMF.ProximityRangeUOM = "Meters"
_PEJMF.OutOfRangeName = ""
_PEJMF.InRangeName = ""
_awjS = Wherigo.Zone(__jC)
_awjS.Id = "7bb2c52b-d91e-49b0-a873-b15eee09cbd5"
_awjS.Name = _y_6d("\037\032\085\085\089\088\082\038")
_awjS.Description = _y_6d("\008\017\068\093\032\089\089\003\113\008\017\068\093\032\089\089\003\113\098\098\098\098\113\008\017\068\093\032\089\089\032\041\003\003\003\003\003\003")
_awjS.Visible = false
_awjS.Media = _t_xQ6
_awjS.Commands = {}
_awjS.DistanceRange = Distance(-1, "feet")
_awjS.ShowObjects = "OnEnter"
_awjS.ProximityRange = Distance(60, "meters")
_awjS.AllowSetPositionTo = false
_awjS.Active = false
_awjS.Points = {
	ZonePoint(51.7819092333667, 10.8625524049282, 0), 
	ZonePoint(51.7819196715382, 10.8626628417683, 0), 
	ZonePoint(51.7820806297182, 10.8625689644527, 0), 
	ZonePoint(51.7820756516387, 10.8624616760922, 0)
}
_awjS.OriginalPoint = ZonePoint(51.7819962965655, 10.8625614718104, 0)
_awjS.DistanceRangeUOM = "Feet"
_awjS.ProximityRangeUOM = "Meters"
_awjS.OutOfRangeName = ""
_awjS.InRangeName = ""
_niq = Wherigo.Zone(__jC)
_niq.Id = "4cde0ead-b373-4cdd-a503-e4d0d99252ca"
_niq.Name = _y_6d("\033\116\032\089")
_niq.Description = _y_6d("\071\032\041\113\091\041\115\118\118\032\113\088\089\085\032\113\036\068\115\041\093\024\088\082\075\113\024\116\041\091\085\113\093\116\017\068\085\113\093\082\041\113\084\032\093\113\008\017\068\088\085\056\113\118\032\116\093\032\118\113\008\032\116\093\118\003")
_niq.Visible = false
_niq.Media = _lWv8z
_niq.Commands = {}
_niq.DistanceRange = Distance(-1, "feet")
_niq.ShowObjects = "OnEnter"
_niq.ProximityRange = Distance(60, "meters")
_niq.AllowSetPositionTo = false
_niq.Active = false
_niq.Points = {
	ZonePoint(51.78185, 10.86218, 0), 
	ZonePoint(51.781901221459, 10.8621000000001, 0), 
	ZonePoint(51.7819331435144, 10.8621953644181, 0)
}
_niq.OriginalPoint = ZonePoint(51.7818947883245, 10.8621584548061, 0)
_niq.DistanceRangeUOM = "Feet"
_niq.ProximityRangeUOM = "Meters"
_niq.OutOfRangeName = ""
_niq.InRangeName = ""

-- Characters --
_spe0G = Wherigo.ZCharacter{
	Cartridge = __jC, 
	Container = _ewA6
}
_spe0G.Id = "1e9d20ad-5696-4041-a46b-a13b9d92a1c9"
_spe0G.Name = _y_6d("\092\089\032\116\093\032\041\113\106\088\093\093\113\075\116\085\113\001\088\041\085")
_spe0G.Description = _y_6d("\094\116\032\041\113\118\116\085\056\085\113\032\116\093\113\126\089\032\116\093\032\041\113\106\088\093\093\113\075\116\085\113\032\116\093\032\075\113\001\088\041\085\113\082\093\084\113\126\115\075\116\118\017\068\032\041\113\033\116\052\038\032\089\075\082\032\085\056\032\113\088\082\038\113\084\032\041\113\037\116\032\118\032\098\113\066\032\024\032\093\113\116\068\075\113\118\116\032\068\118\085\113\071\082\113\032\116\093\032\113\025\088\085\032\041\093\032\113\118\085\032\068\032\093\098\113\099\041\113\118\017\068\032\116\093\085\113\093\116\017\068\085\113\118\115\113\041\032\017\068\085\113\056\082\113\050\116\118\118\032\093\015\113\050\116\032\113\032\041\113\118\116\017\068\113\084\116\032\113\033\032\116\085\113\023\032\041\085\041\032\116\024\032\093\113\118\115\089\089\098\060\001\087\034\060\001\087\034\037\088\118\113\050\116\089\089\118\085\113\071\082\113\085\082\093\019")
_spe0G.Visible = false
_spe0G.Media = _zQk
_spe0G.Icon = _F7TM_
_spe0G.Commands = {
	_ZtOoC = Wherigo.ZCommand{
		Text = _y_6d("\021\094\088\089\089\115\003\021\113\118\088\091\032\093"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _y_6d("\066\116\017\068\085\113\023\032\041\038\082\091\024\088\041")
	}, 
	_FVlR = Wherigo.ZCommand{
		Text = _y_6d("\097\017\068\113\089\088\118\118\032\113\116\068\093\113\116\093\113\087\082\068\032"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _y_6d("\066\116\017\068\085\113\023\032\041\038\082\091\024\088\041")
	}, 
	_tkZ = Wherigo.ZCommand{
		Text = _y_6d("\097\118\085\113\075\116\041\113\082\093\091\032\068\032\082\032\041\003"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _y_6d("\066\116\017\068\085\113\023\032\041\038\082\091\024\088\041")
	}, 
	_ELsi = Wherigo.ZCommand{
		Text = _y_6d("\066\032\032\113\066\032\032\098\098\098\113\050\032\091\113\068\116\032\041\003"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _y_6d("\066\116\017\068\085\113\023\032\041\038\082\091\024\088\041")
	}, 
	_UyA = Wherigo.ZCommand{
		Text = _y_6d("\097\017\068\113\091\032\068\032\113\075\116\085\113\116\068\075"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _y_6d("\066\116\017\068\085\113\023\032\041\038\082\091\024\088\041")
	}, 
	_C_pY1 = Wherigo.ZCommand{
		Text = _y_6d("\037\088\118\113\091\116\024\085\113\032\118\113\068\116\032\041\019"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _y_6d("\066\116\017\068\085\113\023\032\041\038\082\091\024\088\041")
	}, 
	_Lr242 = Wherigo.ZCommand{
		Text = _y_6d("\037\088\118\113\116\118\085\113\075\116\085\113\084\032\075\113\001\088\082\075\019"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _y_6d("\066\116\017\068\085\113\023\032\041\038\082\091\024\088\041")
	}, 
	_7yc = Wherigo.ZCommand{
		Text = _y_6d("\037\088\118\113\116\118\085\113\075\116\085\113\071\116\041\019"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _y_6d("\066\116\017\068\085\113\023\032\041\038\082\091\024\088\041")
	}, 
	_GM9aa = Wherigo.ZCommand{
		Text = _y_6d("\097\017\068\113\068\032\089\038\032\113\116\068\075\113\118\082\017\068\032\093"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _y_6d("\066\116\017\068\085\113\023\032\041\038\082\091\024\088\041")
	}
}
_spe0G.Commands._ZtOoC.Custom = true
_spe0G.Commands._ZtOoC.Id = "9100650c-373d-4709-8bb1-478b21bfa730"
_spe0G.Commands._ZtOoC.WorksWithAll = true
_spe0G.Commands._FVlR.Custom = true
_spe0G.Commands._FVlR.Id = "4d4e047c-bba5-47c8-9e7e-5b13015c746f"
_spe0G.Commands._FVlR.WorksWithAll = true
_spe0G.Commands._tkZ.Custom = true
_spe0G.Commands._tkZ.Id = "5313210c-ce3c-4bdd-8cab-d2b121356f52"
_spe0G.Commands._tkZ.WorksWithAll = true
_spe0G.Commands._ELsi.Custom = true
_spe0G.Commands._ELsi.Id = "4892c4b1-1224-4c12-83d0-c22e46a31658"
_spe0G.Commands._ELsi.WorksWithAll = true
_spe0G.Commands._UyA.Custom = true
_spe0G.Commands._UyA.Id = "b843650a-8b21-40bc-89c5-a2cc32776a3f"
_spe0G.Commands._UyA.WorksWithAll = true
_spe0G.Commands._C_pY1.Custom = true
_spe0G.Commands._C_pY1.Id = "6b1c1b93-b41b-4240-a6c4-a763dda4809d"
_spe0G.Commands._C_pY1.WorksWithAll = true
_spe0G.Commands._Lr242.Custom = true
_spe0G.Commands._Lr242.Id = "7e4ed13d-8e40-4689-8316-07f5aeeb8d02"
_spe0G.Commands._Lr242.WorksWithAll = true
_spe0G.Commands._7yc.Custom = true
_spe0G.Commands._7yc.Id = "f89b3d1d-7633-4378-8250-e9bd526ef02c"
_spe0G.Commands._7yc.WorksWithAll = true
_spe0G.Commands._GM9aa.Custom = true
_spe0G.Commands._GM9aa.Id = "aac7e02d-9858-452c-b00a-c503e24704e2"
_spe0G.Commands._GM9aa.WorksWithAll = true
_spe0G.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_spe0G.Gender = "Male"
_spe0G.Type = "NPC"

-- Items --
_9CwZP = Wherigo.ZItem{
	Cartridge = __jC, 
	Container = Player
}
_9CwZP.Id = "50969fdd-187d-4ab6-a830-1966ab2eb7c1"
_9CwZP.Name = _y_6d("\127\093\089\115\017\126\059\010\115\084\032")
_9CwZP.Description = ""
_9CwZP.Visible = false
_9CwZP.Icon = _6EG
_9CwZP.Commands = {}
_9CwZP.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_9CwZP.Locked = false
_9CwZP.Opened = false
_1BpB5 = Wherigo.ZItem{
	Cartridge = __jC, 
	Container = Player
}
_1BpB5.Id = "b07bbba4-2835-443a-abe0-122674fdf9c9"
_1BpB5.Name = _y_6d("\008\032\017\082\087\116\085\085\102\113\010\115\116\093")
_1BpB5.Description = _y_6d("\071\032\093\113\084\088\041\038\118\085\113\071\082\113\075\116\085\093\032\068\075\032\093\113\050\032\093\093\113\071\082\113\075\088\091\118\085\113\101\059\042\060\001\087\034\035\041\088\017\126\116\093\091\093\082\075\075\032\041\101\113\106\037\120\114\092\094")
_1BpB5.Visible = false
_1BpB5.Media = _ypp
_1BpB5.Icon = _d15j
_1BpB5.Commands = {}
_1BpB5.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_1BpB5.Locked = false
_1BpB5.Opened = false

-- Tasks --

-- Cartridge Variables --
_XDrR6 = ""
_fbDs = 0
_zInpu = _y_6d("\122\088\050\010\108\071")
_hAz9 = _y_6d("\122\118\052\032\124\072")
_cYCb = _y_6d("\122\064\010\050\033\043")
_ZBA = _y_6d("\084\082\075\075\102")
_zsqL = _y_6d("\122\097\028\087\097")
__BPD9 = _y_6d("\122\001\094\072")
__jC.ZVariables = {
	_XDrR6 = "", 
	_fbDs = 0, 
	_zInpu = _y_6d("\122\088\050\010\108\071"), 
	_hAz9 = _y_6d("\122\118\052\032\124\072"), 
	_cYCb = _y_6d("\122\064\010\050\033\043"), 
	_ZBA = _y_6d("\084\082\075\075\102"), 
	_zsqL = _y_6d("\122\097\028\087\097"), 
	__BPD9 = _y_6d("\122\001\094\072")
}

-- Timers --
_BHG = Wherigo.ZTimer(__jC)
_BHG.Id = "31d03a7b-503a-4ff3-adba-fd89ff6f5df3"
_BHG.Name = _y_6d("\010\115\082\093\085\084\115\050\093")
_BHG.Description = ""
_BHG.Visible = true
_BHG.Duration = 20
_BHG.Type = "Countdown"
_hbESp = Wherigo.ZTimer(__jC)
_hbESp.Id = "c3d2880f-01d3-40f3-8a51-3a965a5b85c5"
_hbESp.Name = _y_6d("\037\032\085\085\089\088\082\038")
_hbESp.Description = ""
_hbESp.Visible = true
_hbESp.Duration = 150
_hbESp.Type = "Countdown"

-- Inputs --
_I1RI = Wherigo.ZInput(__jC)
_I1RI.Id = "138b1847-7bcb-460d-bf63-c887efea10ab"
_I1RI.Name = _y_6d("\094\116\093\050\032\116\118\085\088\038\032\089")
_I1RI.Description = ""
_I1RI.Visible = true
_I1RI.Media = _8b4l
_I1RI.InputType = "Text"
_I1RI.Text = _y_6d("\036\082\038\113\084\032\041\113\035\088\038\032\089\113\068\088\118\085\113\071\082\113\032\116\093\032\093\113\126\089\032\116\093\032\093\113\043\089\088\093\113\084\032\118\113\054\041\085\032\118\098\060\001\087\034\037\116\032\023\116\032\089\032\113\084\032\041\113\088\089\118\113\021\043\116\093\091\032\093\021\113\024\032\056\032\116\017\068\093\032\085\032\093\113\008\085\032\089\089\032\093\113\118\116\093\084\113\084\115\041\085\113\032\116\093\091\032\085\041\088\091\032\093\019")
_Dp5s = Wherigo.ZInput(__jC)
_Dp5s.Id = "df579abd-8874-44e8-b45c-0846915cd8ab"
_Dp5s.Name = _y_6d("\078\082\032\089\089\032")
_Dp5s.Description = ""
_Dp5s.Visible = true
_Dp5s.Media = _b7n
_Dp5s.Choices = {
	"eingezaeunt", 
	"bedeckt", 
	"eingehaust", 
	"renaturiert"
}
_Dp5s.InputType = "MultipleChoice"
_Dp5s.Text = _y_6d("\037\116\032\113\093\032\093\093\085\113\075\088\093\113\032\118\015\113\050\032\093\093\113\084\116\032\113\078\082\032\089\089\032\113\118\115\113\023\115\032\089\089\116\091\113\082\075\024\088\082\085\113\116\118\085\019\060\001\087\034\008\116\032\113\116\118\085\113\098\098\098\098")
_LcQ = Wherigo.ZInput(__jC)
_LcQ.Id = "2bb16200-bc40-4888-be7b-1aa133cff10d"
_LcQ.Name = _y_6d("\066\088\085\082\041\118\017\068\082\085\056")
_LcQ.Description = ""
_LcQ.Visible = true
_LcQ.Media = _rqVE
_LcQ.InputType = "Text"
_LcQ.Text = _y_6d("\037\116\041\113\024\032\038\116\093\084\032\093\113\082\093\118\113\068\116\032\041\113\082\032\024\041\116\091\032\093\118\113\116\093\113\032\116\093\032\075\113\066\088\085\082\041\118\017\068\082\085\056\091\032\024\116\032\085\098\060\001\087\034\037\032\116\118\118\085\113\071\082\113\050\032\089\017\068\032\118\113\033\032\116\017\068\032\093\113\088\082\038\113\092\099\097\066\113\066\088\085\082\041\118\017\068\082\085\056\091\032\024\116\032\085\113\126\032\093\093\056\032\116\017\068\093\032\085\019")
_gsNQ = Wherigo.ZInput(__jC)
_gsNQ.Id = "18b486ba-005e-493b-bec9-c7532654f18f"
_gsNQ.Name = _y_6d("\008\085\115\089\089\032\093")
_gsNQ.Description = ""
_gsNQ.Visible = false
_gsNQ.Media = _E65
_gsNQ.Choices = {
	"Bohren", 
	"Schuerfen", 
	"Prospektion"
}
_gsNQ.InputType = "MultipleChoice"
_gsNQ.Text = _y_6d("\037\116\032\113\050\082\041\084\032\113\084\088\118\113\008\082\017\068\032\093\113\082\093\084\113\053\116\093\084\032\093\113\023\115\093\113\106\116\093\032\041\088\089\059\113\082\093\084\113\099\041\056\089\088\091\032\041\118\085\088\032\085\085\032\093\113\056\082\113\075\032\116\093\032\041\113\033\032\116\085\113\091\032\093\088\093\093\085\019")
_UB3D0 = Wherigo.ZInput(__jC)
_UB3D0.Id = "e4dc1d64-2419-4852-8e29-57b250818d2d"
_UB3D0.Name = _y_6d("\094\088\089\084\032")
_UB3D0.Description = ""
_UB3D0.Visible = false
_UB3D0.Media = _8b4l
_UB3D0.InputType = "Text"
_UB3D0.Text = _y_6d("\094\116\032\041\113\082\093\085\032\093\113\088\075\113\094\088\093\091\113\068\088\085\113\075\088\093\113\084\116\032\113\023\116\032\089\032\093\113\094\116\093\050\032\116\118\032\113\088\082\038\113\032\116\093\032\113\038\041\082\032\068\032\113\001\032\041\091\024\088\082\085\088\032\085\116\091\126\032\116\085\113\091\032\038\082\093\084\032\093\098\113\037\116\032\113\093\088\093\093\085\032\113\075\088\093\113\084\116\032\118\032\113\126\032\116\089\059\015\113\091\041\088\024\032\093\059\113\115\084\032\041\113\085\041\116\017\068\085\032\041\038\115\032\041\075\116\091\032\093\113\114\032\041\085\116\032\038\082\093\091\032\093\015\113\084\116\032\113\068\088\032\082\038\116\091\113\084\082\041\017\068\113\084\032\093\113\099\116\093\118\085\082\041\056\113\088\089\085\032\041\113\035\116\032\038\024\088\082\091\041\082\024\032\093\113\032\093\085\118\085\032\068\032\093\019")

-- WorksWithList for object commands --

-- functions --
function __jC:OnStart()
	if (_G[_y_6d("\099\093\023")][_y_6d("\043\089\088\085\038\115\041\075")] == _y_6d("\037\116\093\076\058")) or (_G[_y_6d("\099\093\023")][_y_6d("\071\032\023\116\017\032\097\071")] == _y_6d("\071\032\118\126\085\115\052")) then
		for k, v in pairs(_G[_y_6d("\122\122\067\010")][_y_6d("\036\089\089\033\054\024\067\032\017\085\118")]) do
			v[_y_6d("\114\116\118\116\024\089\032")] = false
			v[_y_6d("\036\017\085\116\023\032")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_y_6d("\093\116\017\068\085\113\075\115\032\091\089\116\017\068")), 
			Callback = function(action)
				if action ~= nil then
					_G[_y_6d("\037\068\032\041\116\091\115")][_y_6d("\010\115\075\075\088\093\084")](_y_6d("\008\088\023\032\010\089\115\118\032"))
				end
			end
		}
		return
	end
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\036\082\118\113\084\032\075\113\092\088\089\126\118\085\032\116\093\113\084\032\118\113\001\041\088\082\093\032\118\082\075\052\038\059\008\088\085\085\032\089\118\113\032\093\085\118\052\041\116\093\091\085\113\088\093\113\084\032\075\113\053\089\032\017\126\032\093\113\099\091\091\032\041\115\032\084\032\041\113\001\041\082\093\093\032\093\113\002\054\041\085\118\085\032\116\089\113\119\088\118\052\032\041\115\084\032\113\084\032\041\113\008\085\088\084\085\113\099\089\024\116\093\091\032\041\115\084\032\042\113\032\116\093\032\113\092\088\041\118\085\047\082\032\089\089\032\015\113\050\032\089\017\068\032\113\088\089\118\113\002\032\116\093\032\042\113\094\088\082\052\085\047\082\032\089\089\032\113\084\032\118\113\072\115\089\084\024\088\017\068\032\118\113\091\116\089\085\015\113\084\032\041\113\024\032\116\113\037\032\091\032\089\032\024\032\093\113\116\093\113\084\116\032\113\001\115\084\032\113\075\082\032\093\084\032\085\098\113\033\082\113\032\041\041\032\116\017\068\032\093\113\116\118\085\113\119\088\118\052\032\041\115\084\032\113\082\032\024\032\041\113\032\116\093\032\093\113\115\032\038\038\032\093\085\089\116\017\068\032\093\113\037\088\089\084\050\032\091\015\113\084\032\041\113\093\115\041\084\115\032\118\085\089\116\017\068\113\099\089\024\116\093\091\032\041\115\084\032\113\023\115\093\113\084\032\041\113\093\088\017\068\113\094\032\116\075\024\082\041\091\113\038\082\032\068\041\032\093\084\032\093\113\008\085\041\088\118\118\032\113\116\075\113\071\041\032\017\126\085\088\089\113\088\075\113\071\041\032\116\059\094\032\041\041\032\093\059\008\085\032\116\093\113\088\024\056\050\032\116\091\085\098"), 
			Media = _YqIq
		}, 
		{
			Text = _y_6d("\036\041\017\068\088\032\115\089\115\091\116\118\017\068\032\113\053\082\093\084\032\113\024\032\089\032\091\032\093\015\113\084\088\118\118\113\118\017\068\115\093\113\116\075\113\064\098\109\028\124\098\119\068\113\088\075\113\099\091\091\032\041\115\032\084\032\041\113\001\041\082\093\093\032\093\113\116\093\113\087\032\093\093\038\032\082\032\041\115\032\038\032\093\113\099\116\118\032\093\032\041\056\032\113\023\032\041\068\082\032\085\085\032\085\113\050\082\041\084\032\093\098\113\001\032\041\032\116\085\118\113\064\022\026\113\118\017\068\032\093\126\032\113\092\088\116\118\032\041\113\054\085\085\115\113\084\032\041\113\072\041\115\118\118\032\113\084\116\032\113\071\115\041\038\118\085\032\089\089\032\113\084\082\041\017\068\113\033\082\115\041\084\082\093\091\113\056\082\041\113\093\088\068\032\089\116\032\091\032\093\084\032\093\113\106\116\017\068\088\032\089\116\118\126\116\041\017\068\032\113\088\075\113\021\114\115\089\126\075\088\041\118\126\032\089\089\032\041\021\113\002\087\082\116\093\032\093\113\093\115\017\068\113\032\041\068\088\089\085\032\093\042\113\084\032\075\015\113\023\115\093\113\118\032\116\093\032\041\113\106\082\085\085\032\041\113\091\032\091\041\082\032\093\084\032\085\032\093\015\113\087\032\116\017\068\118\118\085\116\038\085\113\116\093\113\078\082\032\084\089\116\093\024\082\041\091\098"), 
			Media = _CiY10
		}, 
		{
			Text = _y_6d("\071\082\041\017\068\113\084\116\032\113\114\032\041\068\082\032\085\085\082\093\091\113\023\115\093\113\087\115\068\032\116\118\032\093\113\032\041\041\032\116\017\068\085\032\113\084\088\118\113\084\088\075\088\089\116\091\032\113\099\093\091\032\041\115\084\032\113\084\032\093\113\008\085\088\085\082\118\113\032\116\093\032\118\113\075\116\085\085\032\089\088\089\085\032\041\089\116\017\068\032\093\113\097\093\084\082\118\085\041\116\032\056\032\093\085\041\082\075\118\015\113\050\032\089\017\068\032\118\113\050\032\091\032\093\113\084\116\032\118\032\041\113\001\032\084\032\082\085\082\093\091\113\023\032\041\075\082\085\089\116\017\068\113\084\082\041\017\068\113\032\116\093\032\113\037\088\089\089\059\113\082\093\084\113\072\041\088\024\032\093\088\093\089\088\091\032\113\091\032\118\017\068\082\032\085\056\085\113\050\088\041\098")
		}, 
		{
			Text = _y_6d("\066\088\017\068\113\084\032\075\113\066\116\032\084\032\041\091\088\093\091\113\084\032\118\113\001\032\041\091\024\088\082\032\118\113\116\093\113\084\116\032\118\032\041\113\072\032\091\032\093\084\113\032\041\089\088\093\091\085\032\113\084\116\032\113\116\093\056\050\116\118\017\068\032\093\113\119\088\118\052\032\041\115\084\032\113\091\032\093\088\093\093\085\032\113\036\093\118\116\032\084\089\082\093\091\113\002\093\088\017\068\113\094\032\116\093\041\116\017\068\113\119\088\118\052\032\041\015\113\028\064\028\064\113\024\116\118\113\028\064\076\076\113\036\024\091\032\115\041\084\093\032\085\032\041\113\084\032\118\113\001\041\088\082\093\118\017\068\050\032\116\091\116\118\017\068\032\093\113\025\088\093\084\085\088\091\032\118\113\082\093\084\113\106\116\093\116\118\085\032\041\052\041\088\118\116\084\032\093\085\113\084\032\118\113\053\041\032\116\118\085\088\088\085\032\118\113\001\041\088\082\093\118\017\068\050\032\116\091\015\113\028\064\108\022\113\116\075\113\092\033\113\082\075\091\032\126\115\075\075\032\093\042\113\088\089\118\113\053\032\041\116\032\093\068\088\082\118\118\116\032\084\089\082\093\091\113\050\116\032\084\032\041\113\032\116\093\032\093\113\126\089\032\116\093\032\093\113\036\082\038\118\017\068\050\082\093\091\098\113\037\088\032\068\041\032\093\084\113\084\032\041\113\071\071\087\113\091\088\024\113\032\118\113\068\116\032\041\113\088\082\017\068\113\032\116\093\113\053\032\041\116\032\093\089\088\091\032\041\015\113\050\032\089\017\068\032\118\113\067\032\085\056\085\113\023\032\041\050\088\116\118\085\113\116\118\085\098")
		}
	}, function(action)
		_ewA6.Active = true
		_spe0G.Visible = true
	end)
end
function __jC:OnEnd()
	_Urwigo.OldDialog{
		{
			Text = _y_6d("\106\032\068\041\113\025\082\118\085\113\088\082\038\113\037\068\032\041\116\091\115\113\023\115\093\113\008\032\017\082\087\116\085\085\116\019\113\060\001\087\034\050\050\050\098\050\068\032\041\116\091\115\098\017\115\075\060\001\087\034\008\082\017\068\032\113\082\093\085\032\041\113\008\088\017\068\118\032\093\059\036\093\068\088\089\085\003\113\114\116\032\089\113\008\052\088\019\003"), 
			Media = _5lg
		}
	}
end
function __jC:OnRestore()
	_spe0G.Commands._ELsi.Enabled = false
end
function _awC4D:OnEnter()
	_zInpu = _y_6d("\122\088\050\010\108\071")
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\066\088\015\113\084\032\041\113\053\089\116\093\126\032\118\085\032\113\024\116\118\085\113\071\082\113\067\088\113\093\116\017\068\085\113\091\032\041\088\084\032\003\113\036\024\032\041\113\071\032\116\093\113\126\089\032\116\093\032\041\113\033\088\082\024\032\041\126\088\118\085\032\093\113\084\115\041\085\015\113\056\032\116\091\085\113\071\116\041\113\067\088\113\116\075\075\032\041\113\050\115\113\071\082\113\068\116\093\113\075\082\118\118\085\098\113\106\088\093\113\118\088\091\085\032\113\075\116\041\113\082\032\024\041\116\091\032\093\118\015\113\084\088\118\118\113\075\116\085\113\084\032\075\113\071\116\093\091\032\093\113\116\075\075\032\041\113\075\088\089\113\021\056\050\116\118\017\068\032\093\091\032\118\052\032\116\017\068\032\041\085\021\113\050\032\041\084\032\093\113\075\082\118\118\098\113\037\088\118\113\088\082\017\068\113\116\075\075\032\041\113\075\088\093\113\075\116\085\113\084\116\032\118\032\075\113\127\093\038\082\091\113\075\032\116\093\085\032\113\098\098\098"), 
			Media = _Xqzb
		}, 
		{
			Text = _y_6d("\036\024\032\041\113\118\017\068\088\082\113\071\116\041\113\075\088\089\113\084\116\032\118\032\113\116\093\085\032\041\032\118\118\088\093\085\032\113\035\088\038\032\089\113\088\093\003\113\037\032\093\093\113\071\082\113\038\032\041\085\116\091\113\024\116\118\085\113\024\032\088\093\085\050\115\041\085\032\113\075\116\041\113\084\115\017\068\113\075\088\089\113\032\116\093\032\113\053\041\088\091\032\003"), 
			Media = _Xqzb
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_I1RI)
		end)
	end)
end
function _awC4D:OnExit()
	_zInpu = _y_6d("\122\088\050\010\108\071")
	_awC4D.Visible = false
	_awC4D.Active = false
	__jC:RequestSync()
end
function _ewA6:OnExit()
	_zInpu = _y_6d("\122\032\050\036\026")
	_ewA6.Active = false
	_ewA6.Visible = false
	__jC:RequestSync()
end
function _Kcp4m:OnEnter()
	_zInpu = _y_6d("\122\092\017\052\108\075")
	_spe0G.Description = _y_6d("\072\082\093\093\088\041\113\050\088\041\085\032\085\113\118\017\068\115\093\113\088\082\038\113\071\116\017\068\113\082\093\084\113\050\032\116\118\118\113\024\032\118\085\116\075\075\085\113\050\116\032\084\032\041\113\032\085\050\088\118\113\116\093\085\032\041\032\118\118\088\093\085\032\118\113\056\082\113\024\032\041\116\017\068\085\032\093\098\098\098\098")
	_spe0G.Commands._C_pY1.Enabled = true
end
function _Kcp4m:OnExit()
	_zInpu = _y_6d("\122\092\017\052\108\075")
	_Kcp4m.Visible = false
	_Kcp4m.Active = false
	__jC:RequestSync()
end
function _IQbE:OnEnter()
	_zInpu = _y_6d("\122\097\078\024\099")
	_spe0G.Commands._Lr242.Enabled = true
end
function _IQbE:OnExit()
	_zInpu = _y_6d("\122\097\078\024\099")
	_IQbE.Visible = false
	_IQbE.Active = false
	__jC:RequestSync()
end
function _dnY:OnEnter()
	_zInpu = _y_6d("\122\084\093\120")
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\008\017\068\088\082\113\032\116\093\075\088\089\003\113\071\116\032\118\113\118\116\032\068\085\113\088\082\118\113\050\116\032\113\084\032\041\113\099\116\093\091\088\093\091\113\056\082\113\032\116\093\032\075\113\008\085\115\089\089\032\093\113\088\082\118\113\084\032\075\113\050\116\041\113\038\041\082\068\032\041\113\084\088\118\113\099\041\056\113\116\093\113\075\082\032\068\032\023\115\089\089\032\041\113\036\041\024\032\116\085\113\068\032\041\088\082\118\113\068\115\089\085\032\093\098\060\001\087\034\060\001\087\034\071\088\118\113\068\116\032\041\113\116\118\085\113\050\115\068\089\113\093\082\041\113\084\116\032\113\001\127\071\099\113\023\115\093\113\092\116\093\084\032\041\093\015\113\084\116\032\113\068\116\032\041\113\053\032\041\116\032\093\113\075\088\017\068\085\032\093\098"), 
			Media = _Xqzb
		}
	}, function(action)
		_spe0G.Description = _y_6d("\072\082\093\093\088\041\113\116\118\085\113\068\116\032\041\113\082\093\084\113\056\032\116\091\085\113\071\116\041\113\116\093\085\032\041\032\118\118\088\093\085\032\113\071\116\093\091\032")
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_gsNQ)
		end)
	end)
end
function _dnY:OnExit()
	_zInpu = _y_6d("\122\084\093\120")
	_dnY.Visible = false
	_dnY.Active = false
	__jC:RequestSync()
end
function _ffHh:OnEnter()
	_zInpu = _y_6d("\122\038\038\094\068")
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\097\075\075\032\041\113\050\032\093\093\113\116\017\068\113\068\116\032\041\113\023\115\041\024\032\116\113\126\115\075\075\032\113\032\041\116\093\093\032\041\085\113\075\116\017\068\113\084\116\032\118\032\118\113\001\088\082\075\068\088\082\118\113\088\093\113\032\116\093\032\113\033\032\116\085\015\113\116\093\113\084\032\041\113\032\118\113\068\116\032\041\113\116\093\113\084\032\041\113\072\032\091\032\093\084\113\023\116\032\089\032\113\088\032\068\093\089\116\017\068\032\113\035\082\032\041\075\032\113\091\088\024\098"), 
			Media = _Xqzb
		}, 
		{
			Text = _y_6d("\106\116\085\113\084\032\075\113\099\041\041\116\017\068\085\032\093\113\084\032\041\113\001\087\071\113\082\093\084\113\084\032\041\113\071\071\087\113\050\082\041\084\032\113\028\064\108\064\113\088\082\118\113\084\032\041\113\072\041\032\093\056\032\113\056\050\116\118\017\068\032\093\113\023\032\041\118\017\068\116\032\084\032\093\032\093\113\001\032\118\088\085\056\082\093\091\118\056\115\093\032\093\113\093\088\017\068\113\084\032\075\113\056\050\032\116\085\032\093\113\037\032\089\085\126\041\116\032\091\113\084\116\032\113\084\032\082\085\118\017\068\059\084\032\082\085\118\017\068\032\113\072\041\032\093\056\032\015\113\084\116\032\113\118\116\017\068\113\088\082\017\068\113\047\082\032\041\113\084\082\041\017\068\113\084\032\093\113\094\088\041\056\113\056\115\091\098"), 
			Media = _rGF
		}, 
		{
			Text = _y_6d("\008\017\068\115\093\113\088\024\113\028\064\022\058\113\050\082\041\084\032\113\084\116\032\113\071\032\075\088\041\126\088\085\116\115\093\118\089\116\093\116\032\113\056\082\041\113\001\087\071\113\118\032\116\085\032\093\118\113\084\032\041\113\071\071\087\113\023\032\041\118\085\088\041\126\085\113\088\024\091\032\041\116\032\091\032\089\085\098\113\008\032\116\085\113\084\032\075\113\106\088\032\041\056\113\028\064\026\108\113\091\088\089\085\113\118\116\032\113\115\038\038\116\056\116\032\089\089\113\088\089\118\113\084\116\032\113\008\085\088\088\085\118\091\041\032\093\056\032\113\084\032\041\113\071\032\082\085\118\017\068\032\093\113\071\032\075\115\126\041\088\085\116\118\017\068\032\093\113\087\032\052\082\024\089\116\126\113\082\093\084\113\050\088\041\113\024\116\118\113\066\115\023\032\075\024\032\041\113\028\064\107\064\113\118\017\068\050\032\041\113\024\032\050\088\017\068\085\098"), 
			Media = _Pud7
		}, 
		{
			Text = _y_6d("\037\088\032\068\041\032\093\084\113\084\116\032\118\032\041\113\033\032\116\085\113\068\116\032\118\118\113\084\116\032\118\032\113\008\116\032\084\089\082\093\091\113\068\116\032\041\113\119\088\118\052\032\041\115\084\032\098\113\094\032\116\093\041\116\017\068\113\119\088\118\052\032\041\113\118\115\089\089\085\032\113\084\088\075\116\085\113\032\116\093\113\071\032\093\126\075\088\089\113\091\032\118\032\085\056\085\113\050\032\041\084\032\093\098\113\099\041\113\050\082\041\084\032\113\028\107\074\022\113\091\032\024\115\041\032\093\098\113\036\089\118\113\087\032\017\068\085\118\088\093\050\088\089\085\113\050\082\041\084\032\113\106\116\085\091\089\116\032\084\113\084\032\041\113\008\043\071\113\082\093\084\113\024\041\088\017\068\085\032\113\032\118\113\024\116\118\113\056\082\075\113\106\116\093\116\118\085\032\041\052\041\088\118\116\084\032\093\085\113\084\032\118\113\053\041\032\116\118\085\088\088\085\032\118\113\001\041\088\082\093\118\017\068\050\032\116\091\098\113\066\088\017\068\113\084\032\041\113\106\088\017\068\085\082\032\024\032\041\093\088\068\075\032\113\084\032\041\113\066\088\085\116\115\093\088\089\118\115\056\116\088\089\116\118\085\032\093\113\028\064\076\076\113\023\115\093\113\032\041\113\023\115\093\113\084\116\032\118\032\093\113\023\032\041\038\115\089\091\085\015\113\116\093\113\008\017\068\082\085\056\068\088\038\085\113\091\032\093\115\075\075\032\093\113\082\093\084\113\126\088\075\113\116\093\113\023\032\041\118\017\068\116\032\084\032\093\032\113\092\033\021\118\098\113\097\093\113\001\032\041\091\032\093\059\001\032\089\056\032\093\113\118\115\089\089\113\032\041\113\088\075\113\028\064\098\113\053\032\024\041\082\088\041\113\028\064\108\022\113\088\093\113\053\089\032\017\126\085\102\052\068\082\118\113\091\032\118\085\115\041\024\032\093\113\118\032\116\093\098"), 
			Media = _xGU
		}, 
		{
			Text = _y_6d("\097\093\113\084\032\041\113\033\032\116\085\113\084\032\041\113\071\071\087\113\032\093\085\050\116\017\126\032\089\085\032\113\118\116\017\068\113\084\116\032\118\032\041\113\053\089\032\017\126\032\093\113\056\082\041\113\053\032\041\116\032\093\068\088\082\118\118\116\032\084\089\082\093\091\015\113\116\093\113\084\032\041\113\050\116\041\113\118\116\032\113\068\032\082\085\032\113\118\032\068\032\093\098\113\036\082\017\068\113\091\088\024\113\032\118\113\068\116\032\041\113\032\116\093\113\092\116\093\084\032\041\038\032\041\116\032\093\089\088\091\032\041\098\113\060\001\087\034\114\115\032\089\089\116\091\113\032\116\093\075\088\089\116\091\113\082\093\084\113\093\116\017\068\085\113\023\032\041\091\089\032\116\017\068\024\088\041\113\075\116\085\113\068\032\082\085\116\091\032\093\113\119\082\091\032\093\084\038\088\068\041\085\032\093\113\115\084\032\041\113\119\082\091\032\093\084\017\088\075\052\118\113\050\088\041\032\093\113\084\116\032\113\001\032\085\041\116\032\024\118\038\032\041\116\032\093\089\088\091\032\041\113\116\093\113\084\032\041\113\071\071\087\098\113\053\088\118\085\113\067\032\084\032\041\113\114\115\089\126\118\032\116\091\032\093\032\113\001\032\085\041\116\032\024\113\002\114\099\001\042\113\116\093\113\084\032\041\113\071\071\087\113\068\088\085\085\032\113\116\041\091\032\093\084\050\115\113\116\075\113\025\088\093\084\113\032\116\093\113\001\032\085\041\116\032\024\118\038\032\041\116\032\093\089\088\091\032\041\015\113\116\093\113\084\032\075\113\050\088\032\068\041\032\093\084\113\084\032\041\113\088\017\068\085\050\115\032\017\068\116\091\032\093\113\008\115\075\075\032\041\038\032\041\116\032\093\113\084\116\032\113\092\116\093\084\032\041\015\113\116\075\113\036\089\085\032\041\113\023\115\093\113\074\113\024\116\118\113\028\108\113\119\088\068\041\032\015\113\084\032\041\113\106\116\085\088\041\024\032\116\085\032\041\113\038\082\032\041\113\050\032\093\116\091\113\072\032\089\084\113\002\017\088\098\113\058\124\059\076\124\113\106\088\041\126\042\113\056\050\032\116\113\024\116\118\113\084\041\032\116\113\037\115\017\068\032\093\113\023\032\041\024\041\116\093\091\032\093\113\126\115\093\093\085\032\093\098"), 
			Media = _9SoNb
		}, 
		{
			Text = _y_6d("\092\115\075\075\015\113\116\017\068\113\056\032\116\091\032\113\032\118\113\071\116\041\003"), 
			Media = _v5zG
		}
	}, function(action)
		_spe0G:MoveTo(_PhG)
		_PhG.Visible = true
		_PhG.Active = true
	end)
end
function _ffHh:OnExit()
	_zInpu = _y_6d("\122\038\038\094\068")
	_ffHh.Visible = false
	_ffHh.Active = false
	__jC:RequestSync()
end
function _PhG:OnEnter()
	_zInpu = _y_6d("\122\043\068\072")
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\114\115\093\113\068\116\032\041\113\023\115\041\093\113\068\088\118\085\113\071\082\113\032\116\093\032\093\113\126\089\032\116\093\032\093\113\127\032\024\032\041\024\089\116\017\126\113\082\032\024\032\041\113\119\088\118\052\032\041\115\084\032\098\113\127\093\085\032\041\068\088\089\024\113\084\032\118\113\094\088\093\091\032\118\113\041\032\017\068\085\118\098\098\098\113\114\115\041\118\116\017\068\085\015\113\084\088\118\118\113\071\082\113\093\116\017\068\085\113\038\088\032\089\089\118\085\003\113\098\098\098\126\088\093\093\118\085\113\071\082\113\084\088\118\113\053\032\041\116\032\093\089\088\091\032\041\113\118\032\068\032\093\113\082\093\084\113\084\088\068\116\093\085\032\041\113\084\116\032\113\053\116\118\017\068\085\032\116\017\068\032\098\060\001\087\034\071\088\113\050\115\089\089\032\093\113\050\116\041\113\091\089\032\116\017\068\113\068\116\093\098\113\036\024\032\041\113\024\032\088\093\085\050\115\041\085\032\113\075\116\041\113\084\115\017\068\113\023\115\041\068\032\041\113\093\115\017\068\113\075\088\089\113\032\116\093\032\113\053\041\088\091\032\003"), 
			Media = _Xqzb
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_UB3D0)
		end)
	end)
end
function _PhG:OnExit()
	_zInpu = _y_6d("\122\043\068\072")
	_PhG.Visible = false
	_PhG.Active = false
	__jC:RequestSync()
end
function _ibQpx:OnEnter()
	_zInpu = _y_6d("\122\116\024\078\052\086")
	_spe0G.Description = _y_6d("\072\082\093\093\088\041\113\050\088\041\085\032\085\113\118\017\068\115\093\113\082\093\091\032\084\082\089\084\116\091")
	if _fbDs == 0 then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\071\082\113\068\088\118\085\113\067\088\113\032\050\116\091\113\091\032\024\088\082\017\068\085\113\024\116\118\113\068\116\032\041\113\068\032\041\003\113\037\032\093\093\113\071\082\113\050\032\116\085\032\041\113\118\115\113\085\041\115\032\084\032\089\118\085\113\050\032\041\084\032\093\113\050\116\041\113\084\116\032\113\087\082\093\084\032\113\093\116\032\113\056\082\032\093\084\032\113\024\041\116\093\091\032\093\113\024\032\023\115\041\113\032\118\113\084\082\093\126\032\089\113\050\116\041\084\098\113\071\088\093\093\113\091\032\068\085\113\075\032\116\093\032\113\025\088\085\032\041\093\032\113\088\082\118\113\082\093\084\113\071\082\113\126\088\093\093\118\085\113\075\116\017\068\113\093\116\017\068\085\113\075\032\068\041\113\118\032\068\032\093\098\060\001\087\034\060\001\087\034\036\089\118\115\113\089\115\118\003\113\008\116\032\068\118\085\113\071\082\113\084\116\032\113\008\085\032\089\089\032\113\050\115\113\084\032\041\113\072\115\089\084\024\088\017\068\113\088\082\118\113\084\032\075\113\035\032\116\017\068\113\068\032\041\088\082\118\113\038\089\116\032\118\118\085\019\113\071\115\041\085\068\116\093\113\075\088\017\068\032\093\113\050\116\041\113\067\032\085\056\085\113\032\116\093\032\093\113\037\032\085\085\089\088\082\038\113\082\093\084\113\050\032\093\093\113\071\082\113\093\088\017\068\113\075\116\041\113\084\115\041\085\113\088\093\126\115\075\075\118\085\015\113\084\088\093\093\113\075\082\118\118\085\113\071\082\113\093\115\017\068\113\032\116\093\075\088\089\113\068\116\032\041\113\068\116\093\113\056\082\041\082\032\017\126\003"), 
				Media = _zQk
			}, 
			{
				Text = _y_6d("\036\082\038\113\084\116\032\113\043\089\088\032\085\056\032\113\098\098\098\098\113\053\032\041\085\116\091\113\098\098\098\098"), 
				Media = _Xqzb
			}, 
			{
				Text = _y_6d("\098\098\098\098\098\113\025\054\008\003"), 
				Media = _v5zG
			}
		}, function(action)
			_awjS.Visible = true
			_awjS.Active = true
			_hbESp:Start()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\066\082\093\113\084\032\093\093\113\098\098\098\113\088\082\038\113\032\116\093\113\066\032\082\032\118\113\098\098\098"), 
				Media = _zQk
			}, 
			{
				Text = _y_6d("\036\082\038\113\084\116\032\113\043\089\088\032\085\056\032\113\098\098\098\098\113\053\032\041\085\116\091\113\098\098\098\098"), 
				Media = _Xqzb
			}, 
			{
				Text = _y_6d("\098\098\098\098\098\113\025\054\008\003"), 
				Media = _v5zG
			}
		}, function(action)
			_awjS.Visible = true
			_awjS.Active = true
			_hbESp.Duration = 400
			_hbESp:Start()
		end)
	end
end
function _ibQpx:OnExit()
	_zInpu = _y_6d("\122\116\024\078\052\086")
	_ibQpx.Active = false
	_ibQpx.Visible = false
	__jC:RequestSync()
end
function _PEJMF:OnEnter()
	_zInpu = _y_6d("\122\043\099\119\106\053")
	_niq.Visible = true
	_spe0G.Description = _y_6d("\072\082\093\093\032\041\113\118\017\068\088\082\085\113\050\116\032\113\068\102\052\093\115\085\116\118\116\032\041\085\113\088\082\038\113\084\032\093\113\091\041\115\118\118\032\093\113\091\032\118\052\088\089\085\032\093\032\093\113\001\088\082\075\015\113\084\032\041\113\118\032\068\041\113\088\089\085\113\056\082\113\118\032\116\093\113\118\017\068\032\116\093\085\098")
	_spe0G.Commands._7yc.Enabled = true
end
function _PEJMF:OnExit()
	_zInpu = _y_6d("\122\043\099\119\106\053")
	_PEJMF.Visible = false
	_PEJMF.Active = false
	__jC:RequestSync()
end
function _awjS:OnEnter()
	_zInpu = _y_6d("\122\088\050\067\008")
	_hbESp:Stop()
	_awjS.Name = _y_6d("\094\116\118\085\115\041\116\118\017\068\032\113\037\088\118\118\032\041\089\032\116\085\082\093\091")
	_awjS.Media = _MbD
	_awjS.Description = _y_6d("\053\041\082\032\068\032\041\113\050\082\041\084\032\093\113\088\082\118\091\032\068\115\032\089\085\032\113\001\088\082\075\118\085\088\032\075\075\032\113\088\089\118\113\037\088\118\118\032\041\089\032\116\085\082\093\091\113\023\032\041\050\032\093\084\032\085\015\113\082\075\113\056\098\001\098\113\084\088\118\113\089\032\024\032\093\118\050\116\017\068\085\116\091\032\113\066\088\118\118\113\088\082\118\113\084\032\093\113\001\032\041\091\032\093\113\056\082\113\084\032\093\113\072\032\068\115\032\038\085\032\093\113\056\082\113\024\041\116\093\091\032\093\098")
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\072\082\093\093\088\041\113\116\118\085\113\056\050\088\041\113\093\082\041\113\126\093\088\052\052\113\068\116\093\085\032\041\113\071\116\041\015\113\088\024\032\041\113\071\082\113\068\088\118\085\113\032\118\113\091\032\118\017\068\088\038\038\085\098"), 
			Media = _UrdgH
		}, 
		{
			Text = _y_6d("\043\082\068\068\068\068\113\098\098\098\098\098\113\099\118\113\091\032\068\085\113\067\088\113\084\115\017\068\113\075\116\085\113\071\116\041\003\113\071\082\113\068\088\118\085\113\050\115\068\089\113\091\032\084\088\017\068\085\113\116\017\068\113\050\082\032\041\084\032\113\071\116\017\068\113\024\032\116\075\113\093\088\032\017\068\118\085\032\093\113\106\088\089\113\024\116\118\113\056\082\075\113\036\093\038\088\093\091\113\084\032\041\113\087\082\093\084\032\113\056\082\041\082\032\017\126\113\118\017\068\116\017\126\032\093\019\060\001\087\034\060\001\087\034\087\116\017\068\085\116\091\113\091\032\084\088\017\068\085\003"), 
			Media = _Qbe
		}, 
		{
			Text = _y_6d("\098\098\098\098\113\067\032\085\056\085\113\024\116\093\113\116\017\068\113\088\024\032\041\113\091\032\118\017\068\088\038\038\085\003\113\121\093\024\118\052\081\025\088\118\118\113\082\093\118\113\126\082\041\056\113\023\032\041\118\017\068\093\088\082\038\032\093\113\082\093\084\113\084\116\032\113\033\032\116\085\113\093\082\085\056\032\093\113\082\093\118\113\068\116\032\041\113\075\088\089\113\082\075\056\082\118\032\068\032\093\098\098\098\098\098"), 
			Media = _Qbe
		}, 
		{
			Text = _y_6d("\008\017\068\088\082\113\075\088\089\113\068\116\032\041\003\113\008\115\113\118\088\068\032\093\113\056\082\113\075\032\116\093\032\041\113\033\032\116\085\113\084\116\032\113\037\088\118\118\032\041\089\032\116\085\082\093\091\032\093\113\088\082\118\098\113\037\116\041\113\075\088\017\068\085\032\093\113\001\088\082\075\118\085\088\032\075\075\032\113\068\115\068\089\113\082\093\084\113\126\115\093\093\085\032\093\113\118\115\113\037\088\118\118\032\041\113\023\115\093\113\084\032\041\113\078\082\032\089\089\032\113\056\082\113\082\093\118\032\041\032\075\113\094\115\038\113\089\032\116\085\032\093\098\113\060\001\087\034\094\088\024\032\093\113\050\116\041\113\084\032\093\113\008\085\088\075\075\113\084\088\093\093\113\093\115\017\068\113\091\032\085\032\116\089\085\015\113\118\115\113\068\088\085\085\032\093\113\050\116\041\113\091\089\032\116\017\068\113\056\050\032\116\113\087\116\093\093\032\093\113\088\082\118\113\032\116\093\032\075\113\001\088\082\075\098\113\036\089\089\032\041\084\116\093\091\118\113\126\088\075\032\093\113\084\088\093\093\113\088\082\017\068\113\116\075\075\032\041\113\075\088\089\113\001\089\088\032\085\085\032\041\113\082\093\084\113\126\089\032\116\093\032\113\036\032\118\085\032\113\075\116\085\098"), 
			Media = _MbD
		}, 
		{
			Text = _y_6d("\008\115\015\113\093\082\093\113\088\024\032\041\113\091\032\093\082\091\113\023\032\041\050\032\116\089\085\098\113\099\085\050\088\118\113\091\088\093\056\113\024\032\118\115\093\084\032\041\032\118\113\068\088\024\032\113\116\017\068\113\093\115\017\068\113\038\082\032\041\113\071\116\017\068\113\024\032\023\115\041\113\082\093\118\032\041\032\113\087\082\093\084\113\056\082\113\032\093\084\032\113\116\118\085\098"), 
			Media = _Xqzb
		}
	}, function(action)
		_spe0G:MoveTo(_PEJMF)
		_PEJMF.Active = true
		_PEJMF.Visible = true
	end)
end
function _awjS:OnExit()
	_zInpu = _y_6d("\122\088\050\067\008")
	_awjS.Active = false
	_awjS.Visible = false
	__jC:RequestSync()
end
function _niq:OnEnter()
	_zInpu = _y_6d("\122\093\116\047")
	_spe0G.Description = _y_6d("\072\082\093\093\088\041\113\116\118\085\113\068\116\032\041\113\075\116\085\113\071\116\041\113\116\075\113\001\088\082\075\113\082\093\084\113\118\082\017\068\085\113\032\085\050\088\118\113\098\098\098\098\113")
	_spe0G.Media = _prO
	_spe0G.Commands._GM9aa.Enabled = true
end
function _niq:OnExit()
	_zInpu = _y_6d("\122\093\116\047")
	_niq.Active = false
	_niq.Visible = false
	__jC:RequestSync()
end
function _I1RI:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_I1RI)
		end)
		return
	end
	_XDrR6 = tostring(input)
	if Wherigo.NoCaseEquals(_XDrR6, _y_6d("\028\124")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\087\116\017\068\085\116\091\003"), 
				Media = _Xqzb
			}, 
			{
				Text = _y_6d("\099\116\093\032\113\043\116\093\091\032\113\115\084\032\041\113\001\116\093\091\032\113\116\118\085\113\032\116\093\032\113\126\032\116\089\059\015\113\091\041\088\024\032\093\059\113\115\084\032\041\113\085\041\116\017\068\085\032\041\038\115\032\041\075\116\091\032\113\114\032\041\085\116\032\038\082\093\091\015\113\084\116\032\113\084\082\041\017\068\113\001\032\041\091\024\088\082\085\088\032\085\116\091\126\032\116\085\032\093\113\032\093\085\118\085\088\093\084\032\093\113\116\118\085\098\113\071\116\032\118\032\113\114\032\041\085\116\032\038\082\093\091\032\093\113\032\093\085\118\085\032\068\032\093\113\068\088\032\082\038\116\091\113\084\082\041\017\068\113\084\032\093\113\099\116\093\118\085\082\041\056\113\088\089\085\032\041\113\035\116\032\038\024\088\082\091\041\082\024\032\093\015\113\084\116\032\113\116\093\113\091\032\041\116\093\091\032\041\113\035\116\032\038\032\113\024\032\085\041\116\032\024\032\093\113\050\082\041\084\032\093\098"), 
				Media = _Xqzb
			}, 
			{
				Text = _y_6d("\036\082\038\113\056\082\075\113\093\088\032\017\068\118\085\032\093\113\036\024\032\093\085\032\082\032\041\003\113\099\118\113\091\116\024\085\113\067\088\113\118\115\113\023\116\032\089\113\056\082\113\032\093\085\084\032\017\126\032\093\098\098\098\098\060\001\087\034\060\001\087\034\092\115\075\075\113\118\017\068\093\032\089\089\003"), 
				Media = _Xqzb
			}, 
			{
				Text = _y_6d("\098\098\098\113\082\093\084\113\126\088\082\075\113\084\088\118\118\113\072\082\093\093\088\041\113\118\032\116\093\032\113\008\088\017\068\032\093\113\091\032\093\115\075\075\032\093\113\068\088\085\015\113\116\118\085\113\032\041\113\088\082\017\068\113\118\017\068\115\093\113\050\116\032\084\032\041\113\050\032\091\113\098\098\098\098"), 
				Media = _UrdgH
			}
		}, function(action)
			_spe0G:MoveTo(_Kcp4m)
			_Kcp4m.Visible = true
			_Kcp4m.Active = true
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\071\088\118\113\116\118\085\113\089\032\116\084\032\041\113\093\116\017\068\085\113\091\088\093\056\113\041\116\017\068\085\116\091\098\113\114\032\041\118\082\017\068\032\113\032\118\113\093\115\017\068\113\032\116\093\075\088\089\003"), 
				Media = _Xqzb
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_I1RI)
			end)
		end)
	end
end
function _Dp5s:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_XDrR6 = input
	if Wherigo.NoCaseEquals(_XDrR6, _y_6d("\032\116\093\091\032\068\088\082\118\085")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\119\088\015\113\041\116\017\068\085\116\091\003\113\037\032\093\093\113\032\085\050\088\118\113\082\075\024\088\082\085\113\116\118\085\113\050\116\032\113\082\093\118\032\041\032\113\078\082\032\089\089\032\015\113\084\088\093\093\113\116\118\085\113\032\118\113\021\032\116\093\091\032\068\088\082\118\085\021\098\113\099\118\113\118\085\032\068\085\113\067\088\113\088\082\017\068\113\032\116\093\113\094\088\032\082\118\017\068\032\093\113\084\088\041\082\032\024\032\041\098"), 
				Media = _Xqzb
			}, 
			{
				Text = _y_6d("\099\118\113\075\088\017\068\085\113\008\052\088\118\118\113\075\116\085\113\071\116\041\113\071\116\093\091\032\113\056\082\113\032\093\085\084\032\017\126\032\093\098\113\092\115\075\075\113\118\017\068\093\032\089\089\113\050\032\116\085\032\041\003"), 
				Media = _Xqzb
			}, 
			{
				Text = _y_6d("\098\098\098\113\082\093\084\113\118\017\068\115\093\113\116\118\085\113\072\082\093\093\088\041\113\050\116\032\084\032\041\113\082\093\085\032\041\050\032\091\118\098\113\060\001\087\034\060\001\087\034\053\115\089\091\032\113\116\068\075\113\118\017\068\093\032\089\089\003"), 
				Media = _v5zG
			}
		}, function(action)
			_spe0G.Commands._C_pY1.Enabled = false
			_IQbE.Visible = true
			_IQbE.Active = true
			_spe0G:MoveTo(_IQbE)
		end)
	elseif Wherigo.NoCaseEquals(_XDrR6, _y_6d("\032\116\093\091\032\056\088\032\082\093\085")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\066\032\116\093\015\113\084\088\093\093\113\050\088\032\041\032\113\084\115\017\068\113\032\116\093\113\033\088\082\093\113\084\088\041\082\075\003"), 
				Media = _Xqzb
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_Dp5s)
			end)
		end)
	elseif Wherigo.NoCaseEquals(_XDrR6, _y_6d("\024\032\084\032\017\126\085")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\037\032\093\093\113\118\116\032\113\021\024\032\084\032\017\126\085\021\113\050\088\032\041\032\015\113\084\088\093\093\113\050\082\032\041\084\032\093\113\023\116\032\089\089\032\116\017\068\085\113\032\116\093\113\052\088\088\041\113\001\032\085\115\093\052\089\088\085\085\032\093\113\084\088\041\082\032\024\032\041\113\089\116\032\091\032\093\098\113\036\089\118\115\113\023\032\041\118\082\017\068\032\113\032\118\113\093\115\017\068\113\032\116\093\075\088\089\003"), 
				Media = _Xqzb
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_Dp5s)
			end)
		end)
	elseif Wherigo.NoCaseEquals(_XDrR6, _y_6d("\041\032\093\088\085\082\041\116\032\041\085")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\054\068\113\098\098\098\113\091\088\093\056\113\082\093\084\113\091\088\041\113\093\116\017\068\085\003\113\001\032\116\113\032\116\093\032\041\113\021\087\032\093\088\085\082\041\116\032\041\082\093\091\021\113\050\082\032\041\084\032\113\084\116\032\113\127\075\024\088\082\082\093\091\113\032\093\085\038\032\041\093\085\113\050\032\041\084\032\093\113\082\093\084\113\050\116\041\113\126\115\032\093\093\085\032\093\113\084\032\093\113\038\041\115\032\068\089\116\017\068\113\118\052\041\082\084\032\089\093\084\032\093\113\078\082\032\089\089\085\115\052\038\113\118\032\068\032\093\098\113\099\118\113\075\082\118\118\113\088\089\118\115\113\032\085\050\088\118\113\088\093\084\032\041\032\118\113\118\032\116\093\098"), 
				Media = _Xqzb
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_Dp5s)
			end)
		end)
	end
end
function _LcQ:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_LcQ)
		end)
		return
	end
	_XDrR6 = tostring(input)
	if Wherigo.NoCaseEquals(_XDrR6, _y_6d("\028")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\066\088\085\082\041\118\017\068\082\085\056\091\032\024\116\032\085\032\113\050\082\041\084\032\093\113\116\093\113\084\032\093\113\036\089\085\089\088\032\093\084\032\041\093\113\084\032\041\113\001\087\071\113\084\082\041\017\068\113\084\116\032\113\091\041\082\032\093\032\093\113\008\017\068\116\089\084\032\041\113\075\116\085\113\084\032\075\113\008\032\032\088\084\089\032\041\113\091\032\126\032\093\093\056\032\116\017\068\093\032\085\098\113\060\001\087\034\094\088\075\024\082\041\091\015\113\066\115\041\084\041\068\032\116\093\059\037\032\118\085\038\088\089\032\093\015\113\094\032\118\118\032\093\015\113\087\068\032\116\093\089\088\093\084\059\043\038\088\089\056\015\113\084\088\118\113\008\088\088\041\089\088\093\084\015\113\001\088\084\032\093\059\037\082\041\085\085\032\075\024\032\041\091\113\082\093\084\113\001\088\102\032\041\093\113\023\032\041\050\032\093\084\032\093\113\084\116\032\118\032\118\113\033\032\116\017\068\032\093\113\068\032\082\085\032\113\093\115\017\068\098"), 
				Media = _UIo
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_LcQ)
			end)
		end)
	elseif Wherigo.NoCaseEquals(_XDrR6, _y_6d("\058")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\097\093\113\084\032\041\113\038\041\082\032\068\032\041\032\093\113\071\071\087\113\024\056\050\098\113\116\093\113\084\032\093\113\075\032\116\118\085\032\093\113\093\032\082\032\093\113\001\082\093\084\032\118\089\088\032\093\084\032\041\093\113\050\032\041\084\032\093\113\066\088\085\082\041\118\017\068\082\085\056\091\032\024\116\032\085\032\113\075\116\085\113\084\032\075\113\038\082\032\093\038\032\017\126\116\091\032\093\113\091\032\089\024\032\093\113\008\017\068\116\089\084\113\075\116\085\113\084\032\041\113\037\088\089\084\115\068\041\032\082\089\032\113\091\032\126\032\093\093\056\032\116\017\068\093\032\085\098"), 
				Media = _QBrS
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_LcQ)
			end)
		end)
	elseif Wherigo.NoCaseEquals(_XDrR6, _y_6d("\076")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\071\032\041\113\008\052\032\056\116\088\089\038\088\089\089\113\008\088\017\068\118\032\093\059\036\093\068\088\089\085\101\113\037\032\116\118\118\032\118\113\038\082\032\093\038\032\017\126\116\091\032\118\113\008\017\068\116\089\084\113\075\116\085\113\091\041\082\032\093\032\041\113\008\052\116\085\056\032\113\082\093\084\113\084\032\041\113\037\088\089\084\115\068\041\032\082\089\032\098"), 
				Media = _mG9x
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_LcQ)
			end)
		end)
	elseif Wherigo.NoCaseEquals(_XDrR6, _y_6d("\108")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\066\088\017\068\113\084\032\041\113\071\032\082\085\118\017\068\032\093\113\037\116\032\084\032\041\023\032\041\032\116\093\116\091\082\093\091\113\032\075\052\038\088\068\089\113\084\116\032\113\076\026\098\113\127\075\050\032\089\085\075\116\093\116\118\085\032\041\126\115\093\038\032\041\032\093\056\113\028\064\064\028\015\113\084\088\118\113\099\082\089\032\093\118\102\075\024\115\089\113\116\075\113\091\041\082\032\093\032\093\113\071\041\032\116\032\017\126\113\126\082\032\093\038\085\116\091\113\116\093\113\091\088\093\056\113\071\032\082\085\118\017\068\089\088\093\084\113\056\082\041\113\092\032\093\093\056\032\116\017\068\093\082\093\091\113\023\115\093\113\066\088\085\082\041\118\017\068\082\085\056\091\032\024\116\032\085\032\093\113\056\082\113\023\032\041\050\032\093\084\032\093\098\113\071\116\032\118\032\113\099\075\052\038\032\068\089\082\093\091\113\050\082\041\084\032\113\088\089\089\032\041\084\116\093\091\118\113\023\115\093\113\084\032\093\113\025\088\032\093\084\032\041\093\015\113\116\093\113\084\032\041\032\093\113\033\082\118\085\088\032\093\084\116\091\126\032\116\085\113\084\116\032\113\127\075\050\032\089\085\052\115\089\116\085\116\126\113\089\116\032\091\085\015\113\093\116\017\068\085\113\038\089\088\032\017\068\032\093\084\032\017\126\032\093\084\113\082\075\091\032\118\032\085\056\085\098\060\001\087\034\071\116\032\118\032\113\033\032\116\017\068\032\093\113\091\116\089\085\113\116\093\113\001\032\041\089\116\093\015\113\066\116\032\084\032\041\118\088\017\068\118\032\093\113\082\093\084\113\001\041\032\075\032\093\098"), 
				Media = _I80
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_LcQ)
			end)
		end)
	elseif Wherigo.NoCaseEquals(_XDrR6, _y_6d("\022")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\072\032\093\088\082\003\113\071\116\032\113\092\041\115\032\085\032\113\116\075\113\041\115\085\032\093\113\071\041\032\116\032\017\126\113\116\118\085\113\032\116\093\113\114\032\041\126\032\068\041\118\056\032\116\017\068\032\093\015\113\091\116\089\085\113\116\093\113\091\088\093\056\113\071\032\082\085\118\017\068\089\088\093\084\113\082\093\084\113\126\032\093\093\056\032\116\017\068\093\032\085\113\021\036\075\052\068\116\024\116\032\093\050\088\093\084\032\041\082\093\091\021\015\113\088\024\032\041\113\126\032\116\093\113\066\088\085\082\041\118\017\068\082\085\056\091\032\024\116\032\085\098"), 
				Media = _nyiw
			}, 
			{
				Text = _y_6d("\071\088\118\113\068\088\118\085\113\071\082\113\091\082\085\113\091\032\050\082\118\118\085\098\113\054\068\098\098\098\050\088\118\113\118\032\068\032\113\116\017\068\113\084\032\093\093\113\084\088\113\084\041\082\032\024\032\093\019\019\019\019\060\001\087\034\060\001\087\034\092\115\075\075\113\075\088\089\113\075\116\085\003"), 
				Media = _Xqzb
			}
		}, function(action)
			_dnY.Active = true
			_spe0G.Commands._Lr242.Enabled = false
			_dnY.Visible = true
			_spe0G:MoveTo(_dnY)
		end)
	end
end
function _gsNQ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_XDrR6 = input
	if Wherigo.NoCaseEquals(_XDrR6, _y_6d("\001\115\068\041\032\093")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\072\032\115\089\115\091\116\118\017\068\032\113\001\115\068\041\082\093\091\032\093\113\084\116\032\093\032\093\113\084\088\056\082\015\113\087\032\091\116\115\093\032\093\113\084\032\041\113\099\041\084\115\024\032\041\038\089\088\032\017\068\032\113\056\082\113\032\041\041\032\116\017\068\032\093\015\113\084\116\032\113\075\116\085\113\088\093\084\032\041\032\093\113\106\032\085\068\115\084\032\093\113\093\116\017\068\085\113\056\082\091\088\032\093\091\089\116\017\068\113\118\116\093\084\098\113\060\001\087\034\106\116\085\113\099\041\126\082\093\084\082\093\091\118\024\115\068\041\082\093\091\032\093\113\050\032\041\084\032\093\113\084\116\032\113\091\032\115\089\115\091\116\118\017\068\032\093\113\114\032\041\068\088\032\089\085\093\116\118\118\032\113\023\115\093\113\099\041\084\118\017\068\116\017\068\085\032\093\113\082\093\085\032\041\118\082\017\068\085\015\113\053\115\041\084\032\041\024\115\068\041\082\093\091\032\093\113\050\032\041\084\032\093\113\088\089\118\113\035\041\088\093\118\052\115\041\085\050\032\091\113\024\032\093\082\085\056\085\015\113\082\075\113\008\085\115\038\038\032\113\088\093\113\084\116\032\113\099\041\084\115\024\032\041\038\089\088\032\017\068\032\113\056\082\113\068\115\089\032\093\113\002\056\098\113\001\098\113\099\041\084\115\032\089\042\113\115\084\032\041\113\084\088\041\116\093\113\056\082\113\023\032\041\118\032\093\126\032\093\113\002\056\098\113\001\098\113\092\115\068\089\032\093\118\085\115\038\038\084\116\115\086\116\084\113\116\093\113\082\093\085\032\041\116\041\084\116\118\017\068\032\093\113\008\052\032\116\017\068\032\041\118\017\068\116\017\068\085\032\093\042\098\060\001\087\034\060\001\087\034\001\115\068\041\082\093\091\032\093\113\118\116\093\084\113\088\089\118\115\113\041\032\089\088\085\116\023\113\066\099\127\003"), 
				Media = _nKpZT
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_gsNQ)
			end)
		end)
	elseif Wherigo.NoCaseEquals(_XDrR6, _y_6d("\008\017\068\082\032\041\038\032\093")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\008\017\068\082\032\041\038\032\093\113\024\032\084\032\082\085\032\085\032\113\084\088\118\113\008\082\017\068\032\093\113\082\093\084\113\053\116\093\084\032\093\113\023\115\093\113\106\116\093\032\041\088\089\059\113\082\093\084\113\099\041\056\089\088\091\032\041\118\085\088\032\085\085\032\093\015\113\050\032\089\017\068\032\118\113\032\068\032\041\113\088\082\038\113\084\032\041\113\099\041\038\088\068\041\082\093\091\113\082\093\084\113\084\032\075\113\033\082\038\088\089\089\113\024\032\041\082\068\085\032\098\113\121\093\024\118\052\081\008\115\091\088\041\113\037\082\032\093\118\017\068\032\089\041\082\085\032\093\113\126\088\075\032\093\113\056\082\075\113\099\116\093\118\088\085\056\098\060\001\087\034\001\032\116\113\084\032\041\113\008\017\068\082\041\038\113\050\082\041\084\032\113\032\116\093\113\008\017\068\082\041\038\091\041\088\024\032\093\113\056\082\041\113\099\041\126\082\093\084\082\093\091\113\084\032\041\113\084\116\041\032\126\085\113\082\093\085\032\041\113\084\032\041\113\099\041\084\115\024\032\041\038\089\088\032\017\068\032\113\023\032\041\075\082\085\032\085\032\093\113\025\088\091\032\041\118\085\088\032\085\085\032\113\088\093\091\032\089\032\091\085\098"), 
				Media = _vptKq
			}, 
			{
				Text = _y_6d("\071\032\041\113\001\032\091\041\116\038\038\113\050\116\041\084\113\068\032\082\085\056\082\085\088\091\032\113\126\088\082\075\113\093\115\017\068\113\023\032\041\050\032\093\084\032\085\015\113\084\088\113\025\088\091\032\041\118\085\088\085\085\032\093\113\068\032\082\085\032\113\118\102\118\085\032\075\088\085\116\118\017\068\113\088\082\038\113\084\032\041\113\072\041\082\093\084\089\088\091\032\113\050\116\118\118\032\093\118\017\068\088\038\085\089\116\017\068\032\041\113\099\041\126\032\093\093\085\093\116\118\118\032\113\099\087\092\127\066\071\099\035\113\050\032\041\084\032\093\098\113\021\008\017\068\082\032\041\038\032\093\021\113\050\082\041\084\032\113\084\088\068\032\041\113\023\115\093\113\084\032\075\113\001\032\091\041\116\038\038\113\021\043\041\115\118\052\032\126\085\116\115\093\021\113\088\024\091\032\089\115\032\118\085\098\060\001\087\034\060\001\087\034\127\075\091\088\093\091\118\118\052\041\088\017\068\089\116\017\068\113\118\052\041\116\017\068\085\113\075\088\093\113\088\082\017\068\113\023\115\075\113\021\072\115\089\084\113\118\017\068\082\032\041\038\032\093\021\113\082\093\084\113\075\032\116\093\085\113\084\088\093\093\113\088\024\032\041\113\075\032\116\118\085\113\072\115\089\084\050\088\118\017\068\032\093\015\113\050\088\118\113\067\088\113\088\082\017\068\113\032\068\032\041\113\088\082\038\113\033\082\038\088\032\089\089\116\091\126\032\116\085\113\024\032\041\082\068\085\098"), 
				Media = _97jm
			}, 
			{
				Text = _y_6d("\071\088\118\113\068\088\118\085\113\071\082\113\091\082\085\113\091\032\050\082\118\118\085\003\060\001\087\034\060\001\087\034\092\115\075\075\113\118\017\068\093\032\089\089\113\050\032\116\085\032\041\003\003\003"), 
				Media = _Xqzb
			}
		}, function(action)
			_spe0G:MoveTo(_ffHh)
			_ffHh.Visible = true
			_ffHh.Active = true
		end)
	elseif Wherigo.NoCaseEquals(_XDrR6, _y_6d("\043\041\115\118\052\032\126\085\116\115\093")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\106\116\085\113\043\041\115\118\052\032\126\085\116\115\093\113\024\032\056\032\116\017\068\093\032\085\113\075\088\093\113\068\032\082\085\032\113\084\116\032\113\008\082\017\068\032\113\082\093\084\113\099\041\126\082\093\084\082\093\091\113\023\115\093\113\093\032\082\032\093\015\113\023\115\041\068\032\041\113\082\093\024\032\126\088\093\093\085\032\093\113\025\088\091\032\041\118\085\088\085\085\032\093\113\093\088\017\068\113\091\032\115\089\115\091\116\118\017\068\032\093\015\113\091\032\115\052\068\102\118\116\126\088\089\116\118\017\068\032\093\015\113\091\032\115\017\068\032\075\116\118\017\068\032\093\113\082\093\084\113\024\032\041\091\075\088\032\093\093\116\118\017\068\032\093\113\106\032\085\068\115\084\032\093\098"), 
				Media = _FbS2K
			}, 
			{
				Text = _y_6d("\054\024\032\041\038\089\088\032\017\068\032\093\093\088\068\032\113\025\088\091\032\041\118\085\088\032\085\085\032\093\113\050\082\041\084\032\093\113\116\075\113\025\088\082\038\113\084\032\041\113\072\032\118\017\068\116\017\068\085\032\113\115\038\085\113\056\082\038\088\032\089\089\116\091\113\032\093\085\084\032\017\126\085\098\113\094\032\082\085\032\113\024\032\091\116\093\093\085\113\084\116\032\113\118\102\118\085\032\075\088\085\116\118\017\068\032\113\008\082\017\068\032\113\093\088\017\068\113\093\032\082\032\093\113\025\088\091\032\041\118\085\088\032\085\085\032\093\113\091\032\050\115\032\068\093\089\116\017\068\113\075\116\085\113\032\116\093\032\075\113\091\041\082\032\093\084\089\116\017\068\032\093\113\025\116\085\032\041\088\085\082\041\059\113\082\093\084\113\092\088\041\085\032\093\118\085\082\084\116\082\075\015\113\024\032\116\113\084\032\093\113\091\032\115\089\115\091\116\118\017\068\032\093\113\071\116\032\093\118\085\032\093\113\084\032\041\113\067\032\050\032\116\089\116\091\032\093\113\025\088\032\093\084\032\041\113\082\093\084\113\024\032\116\113\001\032\041\091\024\088\082\038\116\041\075\032\093\015\113\084\116\032\113\116\093\113\084\032\041\113\087\032\091\116\115\093\113\024\032\041\032\116\085\118\113\088\126\085\116\023\113\118\116\093\084\098\113\060\001\087\034\071\088\113\084\116\032\113\092\115\118\085\032\093\113\038\082\032\041\113\084\116\032\113\099\041\126\082\093\084\082\093\091\113\023\115\093\113\025\088\091\032\041\118\085\088\032\085\085\032\093\113\118\032\068\041\113\068\115\017\068\113\118\116\093\084\015\113\050\116\041\084\113\084\116\032\118\032\113\116\093\113\023\032\041\118\017\068\116\032\084\032\093\032\093\113\043\068\088\118\032\093\113\084\082\041\017\068\091\032\038\082\032\068\041\085\015\113\084\116\032\113\067\032\050\032\116\089\118\113\075\116\085\113\032\116\093\032\041\113\126\089\088\041\032\093\113\099\093\085\118\017\068\032\116\084\082\093\091\113\084\032\118\113\072\032\115\089\115\091\032\093\113\032\093\084\032\093\015\113\115\024\113\032\118\113\118\116\017\068\113\089\115\068\093\085\015\113\084\116\032\113\036\041\024\032\116\085\032\093\113\038\115\041\085\056\082\118\032\085\056\032\093\015\113\115\084\032\041\113\088\024\056\082\024\041\032\017\068\032\093\098"), 
				Media = _FbS2K
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_gsNQ)
			end)
		end)
	end
end
function _UB3D0:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_XDrR6 = input
	if Wherigo.NoCaseEquals(_XDrR6, _y_6d("\043\116\093\091\032\093")) then
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\072\032\093\088\082\003\113\099\118\113\050\088\041\032\093\113\084\116\032\113\021\043\116\093\091\032\093\021\113\115\084\032\041\113\021\001\116\093\091\032\093\021\015\113\084\116\032\113\091\032\075\032\116\093\085\113\050\088\041\032\093\098\060\001\087\034\060\001\087\034\119\032\085\056\085\113\072\032\068\032\093\113\050\116\041\113\056\082\113\084\032\093\113\053\116\118\017\068\085\032\116\017\068\032\093\003\113\094\088\118\085\113\071\082\113\071\032\116\093\032\113\036\093\091\032\089\113\075\116\085\019"), 
				Media = _Xqzb
			}
		}, function(action)
			_ibQpx.Visible = true
			_ibQpx.Active = true
			_spe0G:MoveTo(_ibQpx)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _y_6d("\106\075\068\068\068\068\113\098\098\098\098\113\084\088\118\113\050\088\041\113\093\116\017\068\085\113\091\088\093\056\113\041\116\017\068\085\116\091\003\113\114\032\041\118\082\017\068\032\113\032\118\113\093\115\017\068\113\032\116\093\075\088\089\098\113\114\116\032\089\089\032\116\017\068\085\113\068\088\118\085\113\071\082\113\071\116\017\068\113\088\082\017\068\113\093\082\041\113\023\032\041\085\116\052\052\085\098"), 
				Media = _Xqzb
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_UB3D0)
			end)
		end)
	end
end
function _BHG:OnTick()
	Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	_spe0G.Description = _y_6d("\071\082\113\068\088\118\085\113\071\116\017\068\113\084\115\017\068\113\032\093\085\118\017\068\116\032\084\032\093\113\093\115\017\068\113\032\116\093\075\088\089\113\082\075\056\082\084\041\032\068\032\093\113\082\093\084\113\075\116\085\113\084\032\075\113\106\088\032\093\093\089\032\116\093\113\056\082\113\118\052\041\032\017\068\032\093\098")
	_spe0G.Commands._ZtOoC.Enabled = true
	_spe0G.Commands._ELsi.Enabled = true
	_spe0G.Media = _Qbe
	Wherigo.Command "SaveClose"
end
function _hbESp:OnTick()
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\008\115\113\050\116\041\084\113\084\088\118\113\066\097\099\113\032\085\050\088\118\113\075\116\085\113\071\116\041\003\060\001\087\034\060\001\087\034\066\115\017\068\113\032\116\093\075\088\089\003"), 
			Media = _zQk
		}
	}, function(action)
		_ibQpx.Description = _y_6d("\066\082\093\113\075\082\118\118\085\113\071\082\113\093\115\017\068\113\032\116\093\075\088\089\113\068\116\032\041\068\032\041\113\056\082\041\082\032\017\126\113\098\098\098\113\024\032\116\075\113\093\088\032\017\068\118\085\032\093\113\106\088\089\113\024\116\118\085\113\071\082\113\118\017\068\093\032\089\089\032\041\003")
		_awjS.Visible = false
		_awjS.Active = false
		_ibQpx.Visible = true
		_ibQpx.Active = true
		_fbDs = _fbDs + 1
	end)
end
function _spe0G:On_ZtOoC(target)
	_Urwigo.OldDialog{
		{
			Text = _y_6d("\094\088\089\089\115\003\113\097\017\068\113\024\116\093\113\072\082\093\093\088\041\113\082\093\084\113\116\017\068\113\091\032\068\115\032\041\032\113\056\082\113\084\032\075\113\126\089\032\116\093\032\093\113\114\115\089\126\015\113\084\088\118\113\023\115\041\113\068\082\093\084\032\041\085\032\093\113\023\115\093\113\119\088\068\041\032\093\113\088\082\118\113\084\032\075\113\008\082\032\084\032\093\113\068\116\032\041\113\068\032\041\113\126\088\075\015\113\082\075\113\099\041\056\113\088\082\118\113\084\032\075\113\001\032\041\091\113\056\082\113\068\115\089\032\093\098\113"), 
			Media = _Xqzb
		}, 
		{
			Text = _y_6d("\071\082\113\068\088\118\085\113\072\089\082\032\017\126\015\113\084\032\093\093\113\068\032\082\085\032\113\116\118\085\113\032\116\093\032\041\113\084\032\041\113\050\032\093\116\091\032\093\113\035\088\091\032\113\116\075\113\119\088\068\041\113\088\093\113\084\032\075\113\075\032\116\093\032\113\037\082\093\084\032\041\089\088\075\052\032\113\089\032\082\017\068\085\032\085\113\082\093\084\113\116\017\068\113\038\082\032\041\113\106\032\093\118\017\068\032\093\113\050\116\032\113\071\116\017\068\113\056\082\113\118\032\068\032\093\113\024\116\093\098"), 
			Media = _Xqzb
		}, 
		{
			Text = _y_6d("\106\115\032\017\068\085\032\118\085\113\071\082\113\032\085\050\088\118\113\082\032\024\032\041\113\084\088\118\113\088\089\085\032\113\099\072\097\066\097\066\092\097\008\087\054\071\113\032\041\038\088\068\041\032\093\019\113\097\017\068\113\126\088\093\093\113\071\116\017\068\113\038\082\032\068\041\032\093\113\082\093\084\113\071\116\041\113\075\088\093\017\068\032\118\113\056\032\116\091\032\093\113\098\098\098\113\023\116\032\089\089\032\116\017\068\085\113\118\115\091\088\041\113\032\116\093\032\093\113\008\017\068\088\085\056\003"), 
			Media = _Xqzb
		}
	}
	_spe0G.Name = _y_6d("\072\082\093\093\088\041")
	_spe0G.Media = _Xqzb
	_spe0G.Commands._ZtOoC.Enabled = false
	_spe0G.Commands._tkZ.Enabled = true
	_spe0G.Description = _y_6d("\072\082\093\093\088\041\113\089\032\024\085\113\118\032\116\085\113\023\116\032\089\032\093\113\068\082\093\084\032\041\085\113\119\088\068\041\032\093\113\068\116\032\041\113\082\093\084\113\050\032\116\118\118\113\118\115\113\075\088\093\017\068\032\118\113\082\032\024\032\041\113\084\032\093\113\054\041\085\098\060\001\087\034\060\001\087\034\037\088\118\113\050\116\089\089\118\085\113\071\082\113\085\082\093\019")
	_spe0G.Commands._FVlR.Enabled = false
	_spe0G.Commands._UyA.Enabled = true
end
function _spe0G:On_FVlR(target)
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\035\041\115\085\056\113\088\089\089\032\075\113\118\017\068\032\116\093\085\113\032\041\113\071\116\017\068\113\024\032\075\032\041\126\085\113\056\082\113\068\088\024\032\093\098"), 
			Media = _zQk
		}, 
		{
			Text = _y_6d("\099\041\113\118\052\041\116\093\091\085\113\088\082\038\113\082\093\084\113\041\082\038\085\113\071\116\017\068\098"), 
			Media = _Xqzb
		}
	}, function(action)
		_spe0G.Commands._FVlR.Enabled = false
		_spe0G.Media = _Xqzb
		_spe0G.Description = _y_6d("\114\115\041\113\071\116\041\113\118\085\032\068\085\113\067\032\075\088\093\084\015\113\084\032\093\113\071\082\113\075\116\085\113\084\032\041\113\092\032\093\093\085\093\116\118\113\082\075\113\106\088\032\041\017\068\032\093\113\082\093\084\113\088\089\085\032\113\072\032\118\017\068\116\017\068\085\032\093\113\088\089\118\113\033\037\099\087\072\113\024\032\056\032\116\017\068\093\032\093\113\050\082\032\041\084\032\118\085\098\113\099\041\113\068\088\032\089\085\113\032\116\093\032\113\025\088\085\032\041\093\032\113\068\115\017\068\113\082\093\084\113\091\041\082\032\118\118\085\113\071\116\017\068\113\038\041\032\082\093\084\089\116\017\068\098")
		_spe0G.Commands._tkZ.Enabled = true
	end)
end
function _spe0G:On_tkZ(target)
	_spe0G.Description = _y_6d("\099\041\113\038\041\088\091\085\113\071\116\017\068\113\093\115\017\068\113\032\116\093\075\088\089\113\038\041\032\082\093\084\089\116\017\068\113\093\088\017\068\113\071\032\116\093\032\075\113\001\032\091\032\068\041\098")
	_spe0G.Commands._tkZ.Enabled = false
	_spe0G.Commands._ELsi.Enabled = true
end
function _spe0G:On_ELsi(target)
	_spe0G.Commands._ELsi.Enabled = false
	_spe0G.Commands._ZtOoC.Enabled = false
	_spe0G.Commands._UyA.Enabled = false
	_spe0G.Description = _y_6d("\098\098\098\113\071\082\113\084\041\032\068\118\085\113\071\116\017\068\113\082\075\113\082\093\084\113\041\032\093\093\118\085\113\050\032\091\015\113\088\089\118\113\050\082\032\041\084\032\113\084\032\041\113\035\032\082\038\032\089\113\068\116\093\085\032\041\113\071\116\041\113\068\032\041\113\118\032\116\093\098\113\071\088\118\113\106\088\032\093\093\089\032\116\093\113\041\082\038\085\113\093\115\017\068\113\032\085\050\088\118\113\050\116\032\101\021\098\098\082\098\098\088\041\098\098\021\015\113\068\116\093\085\032\041\113\071\116\041\113\068\032\041\015\113\088\024\032\041\113\071\082\113\050\116\089\089\118\113\091\088\041\113\093\116\017\068\085\118\113\084\088\023\115\093\113\050\116\118\118\032\093\113\098\098\098\113\050\088\118\113\118\017\068\088\084\032\113\116\118\085\015\113\084\032\093\093\113\067\032\085\056\085\113\050\116\041\118\085\113\071\082\113\093\116\017\068\085\118\113\082\032\024\032\041\113\119\088\118\052\032\041\115\084\032\113\032\041\038\088\068\041\032\093\113\098\098\098\113\060\001\087\034\098\098\098\113\082\093\084\113\024\116\118\085\113\091\088\093\056\113\082\075\113\118\115\093\118\085\113\068\116\032\041\113\068\032\041\113\091\032\126\115\075\075\032\093\098")
	_BHG:Start()
end
function _spe0G:On_UyA(target)
	_spe0G.Commands._ZtOoC.Enabled = false
	_spe0G.Commands._FVlR.Enabled = false
	_spe0G.Commands._tkZ.Enabled = false
	_spe0G.Commands._ELsi.Enabled = false
	_spe0G.Commands._UyA.Enabled = false
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\071\088\118\113\116\118\085\113\118\017\068\115\032\093\113\082\093\084\113\116\017\068\113\038\041\032\082\032\113\075\116\017\068\113\118\032\068\041\113\084\088\041\082\032\024\032\041\113\075\088\089\113\067\032\075\088\093\084\032\093\113\032\085\050\088\118\113\056\082\113\056\032\116\091\032\093\098\113\097\093\113\084\116\032\118\032\041\113\118\115\093\118\085\113\118\115\113\023\032\041\089\088\118\118\032\093\032\093\113\072\032\091\032\093\084\113\126\115\075\075\085\113\126\088\082\075\113\075\088\089\113\067\032\075\088\093\084\113\023\115\041\024\032\116\113\082\093\084\113\050\032\093\093\113\084\115\017\068\015\113\084\088\093\093\113\089\088\082\038\032\093\113\023\116\032\089\032\113\091\089\032\116\017\068\113\050\032\091\113\050\032\093\093\113\118\116\032\113\075\116\017\068\113\118\032\068\032\093\098"), 
			Media = _Xqzb
		}, 
		{
			Text = _y_6d("\037\116\041\113\075\082\032\118\118\032\093\113\082\093\118\113\088\024\032\041\113\024\032\032\116\089\032\093\015\113\084\032\093\093\113\050\032\093\093\113\075\032\116\093\032\113\025\088\075\052\032\113\032\041\089\116\118\017\068\085\113\050\116\041\118\085\113\071\082\113\075\116\017\068\113\093\116\017\068\085\113\075\032\068\041\113\118\032\068\032\093\113\126\115\032\093\093\032\093\098\060\001\087\034\060\001\087\034\072\089\032\116\017\068\113\068\116\032\041\113\084\041\082\032\024\032\093\113\068\088\024\032\093\113\106\032\093\118\017\068\032\093\113\032\116\093\032\113\035\088\038\032\089\113\088\082\038\091\032\118\085\032\089\089\085\098\113\071\088\113\050\116\041\084\113\071\116\041\113\118\017\068\115\093\113\032\116\093\116\091\032\118\113\024\032\041\116\017\068\085\032\085\098\113\036\082\017\068\113\038\116\093\084\032\118\085\113\071\082\113\032\116\093\032\093\113\126\089\032\116\093\032\093\113\127\032\024\032\041\024\089\116\017\126\113\023\115\075\113\054\041\085\098\060\001\087\034\060\001\087\034\053\115\089\091\032\113\075\116\041\003"), 
			Media = _Xqzb
		}, 
		{
			Text = _y_6d("\072\082\093\093\088\041\113\093\116\075\075\085\113\118\032\116\093\032\113\118\116\032\024\032\093\113\008\088\017\068\032\093\113\082\093\084\113\091\032\068\085\113\075\116\085\113\091\041\115\118\118\032\093\113\008\017\068\041\116\085\085\032\093\113\023\115\041\088\082\118\098\113\060\001\087\034\035\041\115\085\056\113\118\032\116\093\032\041\113\126\082\041\056\032\093\113\001\032\116\093\032\113\116\118\085\113\032\041\113\091\088\093\056\113\118\017\068\115\032\093\113\038\089\116\093\126\113\082\093\084\113\071\082\113\075\082\118\118\085\113\071\116\017\068\113\032\116\089\032\093\113\116\068\075\113\056\082\113\038\115\089\091\032\093\003"), 
			Media = _v5zG
		}
	}, function(action)
		_spe0G:MoveTo(_awC4D)
		_awC4D.Visible = true
		_awC4D.Active = true
	end)
end
function _spe0G:On_C_pY1(target)
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\097\093\113\084\116\032\118\032\075\113\082\093\118\017\068\032\116\093\024\088\041\032\093\113\094\088\032\082\118\017\068\032\093\113\024\032\038\116\093\084\032\085\113\118\116\017\068\113\032\116\093\032\113\078\082\032\089\089\032\098\113\114\116\032\089\032\113\118\088\091\032\093\015\113\084\088\118\118\113\068\116\032\041\113\084\032\041\113\072\054\025\071\001\036\010\094\113\032\093\085\118\052\041\116\093\091\085\015\113\084\032\041\113\093\088\017\068\113\017\088\098\113\076\124\113\092\116\089\115\075\032\085\032\041\093\113\024\032\116\113\037\032\091\032\089\032\024\032\093\113\116\093\113\084\116\032\113\001\115\084\032\113\075\082\032\093\084\032\085\098\060\001\087\034\036\089\089\032\041\084\116\093\091\118\113\091\116\024\085\113\032\118\113\023\116\032\089\032\113\078\082\032\089\089\032\093\113\116\093\113\084\116\032\118\032\041\113\072\032\091\032\093\084\015\113\118\115\113\084\088\118\118\113\084\032\041\113\072\115\089\084\024\088\017\068\113\093\116\017\068\085\113\093\082\041\113\032\116\093\032\113\078\082\032\089\089\032\113\068\088\085\015\113\050\115\024\032\116\113\088\024\032\041\113\084\032\041\113\089\088\032\093\091\118\085\032\113\078\082\032\089\089\088\041\075\113\068\116\032\041\113\032\093\085\118\052\041\116\093\091\085"), 
			Media = _Xqzb
		}, 
		{
			Text = _y_6d("\025\032\116\084\032\041\113\126\088\093\093\113\075\088\093\113\084\032\093\113\078\082\032\089\089\085\115\052\038\113\093\116\017\068\085\113\118\032\068\032\093\015\113\050\032\116\089\113\084\116\032\118\032\113\092\088\085\032\113\084\088\041\082\024\032\041\113\118\085\032\068\085\098"), 
			Media = _Xqzb
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_Dp5s)
		end)
	end)
end
function _spe0G:On_Lr242(target)
	_spe0G.Commands._Lr242.Enabled = false
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\071\116\032\118\032\041\113\088\089\085\032\113\072\032\118\032\089\089\032\113\068\116\032\041\113\116\118\085\113\032\116\093\113\001\032\041\091\088\068\115\041\093\113\002\036\017\032\041\113\052\118\032\082\084\115\052\089\088\085\088\093\082\118\042\098\113\121\093\024\118\052\081\071\032\041\113\001\032\041\091\088\068\115\041\093\113\126\088\093\093\113\082\032\024\032\041\113\076\124\113\106\032\085\032\041\113\068\115\017\068\113\082\093\084\113\082\032\024\032\041\113\022\124\124\113\119\088\068\041\032\113\088\089\085\113\050\032\041\084\032\093\098\113\106\116\085\113\118\032\116\093\032\093\113\082\032\024\032\041\113\022\113\106\032\085\032\041\113\127\075\038\088\093\091\113\068\088\032\085\085\032\113\032\041\113\032\118\113\024\032\116\093\088\068\032\113\116\093\113\084\116\032\113\025\116\118\085\032\113\084\032\041\113\022\124\124\113\088\032\089\085\032\118\085\032\093\113\001\088\032\082\075\032\113\071\032\082\085\118\017\068\089\088\093\084\118\113\091\032\118\017\068\088\038\038\085\098\113\060\001\087\034\071\116\032\113\001\088\082\075\091\041\082\052\052\032\113\088\075\113\099\091\091\032\041\115\032\084\032\041\113\001\041\082\093\093\032\093\113\091\116\089\085\113\088\089\118\113\066\088\085\082\041\084\032\093\126\075\088\089\113\082\093\084\113\121\093\024\118\052\081\118\085\032\068\085\113\082\093\085\032\041\113\071\032\093\126\075\088\089\118\017\068\082\085\056\098"), 
			Media = _Xqzb
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_LcQ)
		end)
	end)
end
function _spe0G:On_7yc(target)
	_niq.Visible = true
	_spe0G.Commands._7yc.Enabled = false
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\008\017\068\088\082\113\116\068\093\113\071\116\041\113\088\093\015\113\084\116\032\118\032\093\113\088\089\085\032\093\015\113\085\116\032\038\113\091\032\118\052\088\089\085\032\093\032\093\113\072\032\118\032\089\089\032\093\098\113\036\082\017\068\113\032\041\113\116\118\085\113\032\116\093\113\001\032\041\091\088\068\115\041\093\098\113\060\001\087\034\036\089\118\113\116\017\068\113\116\093\113\084\116\032\118\032\113\072\032\091\032\093\084\113\126\088\075\113\091\088\024\113\032\118\113\116\068\093\113\082\093\084\113\088\089\089\032\113\088\093\084\032\041\032\093\113\118\032\116\093\032\041\113\001\041\082\032\084\032\041\113\068\116\032\041\113\093\115\017\068\113\091\088\041\113\093\116\017\068\085\098\113\066\082\041\113\050\032\116\089\113\050\116\041\113\023\116\032\089\113\094\115\089\056\113\038\082\032\041\113\084\116\032\113\008\085\115\089\089\032\093\113\024\041\088\082\017\068\085\032\093\113\118\017\068\088\038\038\085\032\093\113\050\116\041\113\084\032\093\113\043\089\088\085\056\113\038\082\032\041\113\116\068\093\113\082\093\084\113\088\089\089\032\113\088\093\084\032\041\032\093\113\001\088\032\082\075\032\113\068\116\032\041\098"), 
			Media = _lWv8z
		}, 
		{
			Text = _y_6d("\114\115\041\113\084\041\032\116\068\082\093\084\032\041\085\113\119\088\068\041\032\093\113\075\082\118\118\113\032\118\113\091\032\050\032\118\032\093\113\118\032\116\093\015\113\088\089\118\113\032\116\093\113\001\089\116\085\056\113\116\068\093\113\118\052\088\089\085\032\085\032\098\113\071\115\017\068\113\032\041\113\082\032\024\032\041\089\032\024\085\032\113\032\118\113\082\093\084\113\068\032\082\085\032\113\126\088\093\093\113\032\116\093\113\106\088\093\093\113\115\068\093\032\113\043\041\115\024\089\032\075\032\113\116\093\113\116\068\075\113\023\032\041\118\017\068\050\116\093\084\032\093\015\113\084\032\093\093\113\118\032\116\093\113\127\075\038\088\093\091\113\088\075\113\008\085\088\075\075\113\024\032\085\041\088\032\091\085\113\075\032\068\041\113\088\089\118\113\118\116\032\024\032\093\113\106\032\085\032\041\098\113\094\032\082\085\032\113\056\088\032\068\089\085\113\032\041\113\082\075\113\084\116\032\113\023\116\032\041\068\082\093\084\032\041\085\113\119\088\068\041\032\098"), 
			Media = _P8F
		}, 
		{
			Text = _y_6d("\071\088\041\082\075\113\116\118\085\113\032\041\113\088\082\017\068\113\116\093\113\084\116\032\113\008\088\075\075\089\082\093\091\113\084\032\041\113\022\124\124\113\088\032\089\085\032\118\085\032\093\113\001\088\032\082\075\032\113\071\032\082\085\118\017\068\089\088\093\084\118\113\088\082\038\091\032\093\115\075\075\032\093\113\050\115\041\084\032\093\098\060\001\087\034\060\001\087\034\097\017\068\113\050\082\032\041\084\032\113\118\088\091\032\093\101\113\021\033\032\116\085\113\032\116\093\113\001\116\089\084\113\056\082\113\075\088\017\068\032\093\003\021\113\094\088\024\032\113\091\032\068\115\032\041\085\015\113\084\088\118\118\113\032\118\113\116\041\091\032\093\084\050\115\113\032\116\093\032\113\126\089\032\116\093\032\113\001\116\089\084\032\041\118\088\075\075\089\082\093\091\113\091\116\024\085\015\113\116\093\113\084\032\041\113\032\116\093\032\113\072\088\089\032\041\116\032\113\084\032\118\113\088\089\085\032\093\113\001\082\041\118\017\068\032\093\113\056\082\113\088\089\089\032\093\113\119\088\068\041\032\118\056\032\116\085\032\093\113\032\093\085\118\085\032\068\032\093\113\118\115\089\089\098"), 
			Media = _Xqzb
		}, 
		{
			Text = _y_6d("\001\116\118\085\113\071\082\113\118\115\050\032\116\085\019\113\097\017\068\113\068\088\024\032\113\093\088\032\075\089\116\017\068\113\088\082\017\068\113\091\032\068\115\032\041\085\015\113\084\088\118\118\113\084\032\041\113\088\089\085\032\113\072\032\118\032\089\089\032\113\093\115\017\068\113\032\116\093\113\091\088\093\056\113\024\032\118\115\093\084\032\041\032\118\113\072\032\068\032\116\075\093\116\118\113\024\116\041\091\085\113\098\098\098\113\032\116\093\032\093\113\008\017\068\088\085\056\003"), 
			Media = _Xqzb
		}, 
		{
			Text = _y_6d("\072\082\093\093\088\041\113\091\032\068\085\113\023\115\041\088\082\118\113\082\093\084\113\023\032\041\118\017\068\050\116\093\084\032\085\113\116\075\113\001\088\082\075\098\113\053\115\089\091\032\113\116\068\075\015\113\050\032\093\093\113\071\082\113\071\032\116\093\113\001\116\089\084\113\091\032\075\088\017\068\085\113\068\088\118\085\003"), 
			Media = _prO
		}
	}, function(action)
		_spe0G:MoveTo(_niq)
		_PEJMF.Active = false
		_PEJMF.Visible = false
		_niq.Active = true
	end)
end
function _spe0G:On_GM9aa(target)
	_Urwigo.Dialog(false, {
		{
			Text = _y_6d("\097\041\091\032\093\084\050\032\041\113\068\088\085\113\075\116\041\113\075\088\089\113\032\041\056\088\032\068\089\085\015\113\084\088\118\118\113\032\118\113\068\116\032\041\113\032\116\093\032\113\008\017\068\088\085\056\126\116\118\085\032\113\091\032\024\032\093\113\118\115\089\089\098\060\001\087\034\060\001\087\034\008\116\032\068\118\085\113\071\082\113\032\085\050\088\118\019"), 
			Media = _prO, 
			Buttons = {
				_y_6d("\066\032\116\093"), 
				_y_6d("\119\088")
			}
		}
	}, function(action)
		if action == "Button1" then
			_Urwigo.MessageBox{
				Text = _y_6d("\071\088\093\093\113\118\082\017\068\113\050\032\116\085\032\041\003\113\099\118\113\075\082\118\118\113\032\085\050\088\118\113\068\116\032\041\113\118\032\116\093\015\113\084\116\032\113\072\032\118\017\068\116\017\068\085\032\113\126\089\088\093\091\113\041\032\017\068\085\113\091\089\088\082\024\050\082\032\041\084\116\091\098"), 
				Media = _prO
			}
		elseif action == "Button2" then
			_Urwigo.Dialog(false, {
				{
					Text = _y_6d("\037\088\118\019\113\071\088\118\113\116\118\085\113\088\089\089\032\118\019\113\127\093\084\113\084\088\113\068\088\024\032\113\116\017\068\113\075\116\041\113\118\115\113\032\116\093\032\093\113\091\041\115\118\118\032\093\113\008\088\017\126\113\024\032\118\115\041\091\085\113\098\098\098\098\113\071\036\008\113\084\088\113\126\088\093\093\118\085\113\071\082\113\024\032\068\088\089\085\032\093\113\115\084\032\041\113\023\032\041\118\085\032\017\126\118\085\113\032\118\113\088\075\113\024\032\118\085\032\093\113\091\089\032\116\017\068\113\050\116\032\084\032\041\098"), 
					Media = _l45z
				}, 
				{
					Text = _y_6d("\021\098\098\098\113\050\088\041\085\032\003\113\001\116\118\113\088\082\038\113\084\088\118\113\068\116\032\041\113\023\116\032\089\089\032\116\017\068\085\003\021\060\001\087\034\072\082\093\093\088\041\113\038\116\118\017\068\085\113\088\082\118\113\084\032\075\113\091\088\093\056\032\093\113\093\082\085\056\089\115\118\032\093\113\033\032\082\091\113\032\116\093\113\036\041\085\113\106\082\093\056\032\113\082\093\084\113\091\116\024\085\113\118\116\032\113\071\116\041\101\113\021\071\088\118\113\068\116\032\041\113\118\116\032\068\085\113\116\093\085\032\041\032\118\118\088\093\085\113\088\082\118\003\021"), 
					Media = _ypp
				}, 
				{
					Text = _y_6d("\036\024\032\041\113\118\115\093\118\085\098\098\098\098\113\008\017\068\088\084\032\015\113\088\024\032\041\113\050\088\118\113\118\115\089\089\118\113\084\041\082\075\003\113\037\116\041\113\068\088\024\032\093\113\091\088\093\056\113\118\017\068\115\032\093\113\023\116\032\089\113\032\041\089\032\024\085\113\068\032\082\085\032\098\113\099\118\113\068\088\085\113\075\116\041\113\091\041\115\118\118\032\093\113\008\052\088\118\118\113\091\032\075\088\017\068\085\113\082\093\084\113\116\017\068\113\091\089\088\082\024\032\015\113\071\082\113\068\088\118\085\113\032\116\093\032\113\106\032\093\091\032\113\082\032\024\032\041\113\084\116\032\118\032\093\113\053\089\032\017\126\032\093\113\032\041\038\088\068\041\032\093\098"), 
					Media = _l45z
				}, 
				{
					Text = _y_6d("\094\116\032\041\113\116\118\085\113\093\115\017\068\113\032\116\093\113\033\032\085\085\032\089\113\075\116\085\113\032\116\093\032\041\113\033\088\082\024\032\041\038\115\041\075\032\089\015\113\084\032\093\113\116\017\068\113\071\116\041\113\091\032\024\032\093\113\118\115\089\089\113\050\032\093\093\113\071\082\113\032\118\113\024\116\118\113\068\116\032\041\113\068\032\041\113\091\032\118\017\068\088\038\038\085\113\068\088\118\085\098"), 
					Media = _IS06
				}, 
				{
					Text = _y_6d("\099\118\113\116\118\085\113\088\093\113\084\032\041\113\033\032\116\085\003\113\097\017\068\113\050\032\041\084\032\113\071\116\017\068\113\068\116\032\041\113\023\032\041\089\088\118\118\032\093\098\113\071\032\116\093\032\113\033\088\082\024\032\041\126\116\118\085\032\113\056\032\116\091\085\113\071\116\041\113\084\032\093\113\037\032\091\113\056\082\041\082\032\017\126\098\113\097\017\068\113\075\082\118\118\113\116\093\113\084\116\032\113\088\093\084\032\041\032\113\087\116\017\068\085\082\093\091\113\056\082\113\114\115\089\126\075\032\041\118\126\032\089\089\032\041\098\113\071\088\118\113\116\118\085\113\084\088\118\113\106\082\093\084\089\115\017\068\113\056\082\113\032\116\093\032\075\113\088\089\085\032\093\113\008\017\068\088\017\068\085\098\113\071\115\041\085\113\050\032\041\084\032\113\116\017\068\113\075\032\116\093\032\093\113\008\088\017\126\113\068\032\082\085\032\113\024\032\118\085\116\075\075\085\113\093\115\017\068\113\023\115\089\089\113\024\032\126\115\075\075\032\093\098"), 
					Media = _Xqzb
				}, 
				{
					Text = _y_6d("\071\116\041\113\093\115\017\068\113\072\089\082\032\017\126\113\088\082\038\113\084\032\093\113\037\032\091\015\113\050\115\068\116\093\113\088\082\017\068\113\116\075\075\032\041\113\032\041\113\071\116\017\068\113\068\032\082\085\032\113\093\115\017\068\113\038\082\032\068\041\032\093\113\050\116\041\084\003\113\114\116\032\089\089\032\116\017\068\085\113\118\032\068\032\093\113\050\116\041\113\082\093\118\113\067\088\113\032\116\093\075\088\089\113\050\116\032\084\032\041\113\098\098\098\098"), 
					Media = _Xqzb
				}, 
				{
					Text = _y_6d("\071\088\041\088\082\038\068\116\093\113\093\116\075\075\085\113\072\082\093\093\088\041\113\118\032\116\093\032\113\008\088\017\068\032\093\015\113\084\041\032\068\085\113\118\116\017\068\113\082\075\113\082\093\084\113\023\032\041\118\017\068\050\116\093\084\032\085\113\075\116\085\113\032\116\093\032\075\113\021\072\089\082\032\017\126\113\088\082\038\003\021\113\068\116\093\085\032\041\113\084\032\041\113\093\088\032\017\068\118\085\032\093\113\037\032\091\024\116\032\091\082\093\091\098"), 
					Media = _UrdgH
				}
			}, function(action)
				_spe0G:MoveTo(nil)
				__jC.Complete = true
				_1BpB5.Visible = true
				_9CwZP.Description = string.sub(Player.CompletionCode, 1, 15)
				_9CwZP.Visible = true
				_ewA6.Description = _y_6d("\098\098\098\056\082\075\113\043\088\041\126\052\089\088\085\056")
				_ewA6.Active = true
				_ewA6.Visible = true
			end)
		end
	end)
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return __jC
