require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

objMeettheCOSattheLVGGPWherigo = Wherigo.ZCartridge()

-- String decode --
function _sDDfW(str)
	local res = ""
    local dtable = "\034\106\075\022\046\003\045\033\088\005\063\084\039\062\028\125\048\104\043\099\044\014\076\095\001\030\053\074\054\060\036\097\066\015\096\016\040\059\090\024\111\010\121\124\115\004\103\051\027\112\055\098\123\068\080\023\017\118\041\083\067\038\069\020\019\102\117\109\071\058\037\091\057\012\000\081\052\110\050\101\009\002\122\120\026\094\072\035\116\056\086\089\107\105\082\119\047\093\032\006\085\029\013\011\064\061\126\113\070\114\021\031\008\108\092\073\100\065\078\049\079\025\077\018\087\007\042"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
objMadhauler = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objMadhauler.Id = "8e90ac68-64a0-4fd0-9b2e-9aae13d9e1df"
objMadhauler.Name = _sDDfW("\123\032\117\018\032\067\114\080\110")
objMadhauler.Description = ""
objMadhauler.AltText = ""
objMadhauler.Resources = {
	{
		Type = "jpg", 
		Filename = "madhauler.jpg", 
		Directives = {}
	}
}
objGreyvin = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objGreyvin.Id = "05d1cbe8-190c-43fd-952f-627edf478573"
objGreyvin.Name = _sDDfW("\069\110\080\043\058\094\078")
objGreyvin.Description = ""
objGreyvin.AltText = ""
objGreyvin.Resources = {
	{
		Type = "jpg", 
		Filename = "greyvin1.jpg", 
		Directives = {}
	}
}
objagility3d = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objagility3d.Id = "d04c9714-3aee-432b-b2b1-5e7674771ce3"
objagility3d.Name = _sDDfW("\032\047\094\114\094\089\043\048\117")
objagility3d.Description = ""
objagility3d.AltText = ""
objagility3d.Resources = {
	{
		Type = "jpg", 
		Filename = "Discoweave119x120.jpg", 
		Directives = {}
	}
}
objGreyvin2 = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objGreyvin2.Id = "b2a6bc80-2f4a-4755-8f6a-7d6bb848bba2"
objGreyvin2.Name = _sDDfW("\069\110\080\043\058\094\078\099\079")
objGreyvin2.Description = ""
objGreyvin2.AltText = ""
objGreyvin2.Resources = {
	{
		Type = "jpg", 
		Filename = "Greyvin2.jpg", 
		Directives = {}
	}
}
objArubaXpress = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objArubaXpress.Id = "73c98839-9d76-4805-97ba-0a384b8e8fc3"
objArubaXpress.Name = _sDDfW("\118\110\067\052\032\009\050\110\080\045\045")
objArubaXpress.Description = ""
objArubaXpress.AltText = ""
objArubaXpress.Resources = {
	{
		Type = "jpg", 
		Filename = "ArubaXpress.jpg", 
		Directives = {}
	}
}
objWizard = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objWizard.Id = "fc6e0ab8-3329-4795-b0a8-15f89e350fd1"
objWizard.Name = _sDDfW("\125\094\083\032\110\117")
objWizard.Description = ""
objWizard.AltText = ""
objWizard.Resources = {
	{
		Type = "jpg", 
		Filename = "Wizard.jpg", 
		Directives = {}
	}
}
objTheeNightHunters = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objTheeNightHunters.Id = "85ad7eec-5449-43ee-bd73-caf87cbafbc8"
objTheeNightHunters.Name = _sDDfW("\012\018\080\080\119\094\047\018\089\087\067\078\089\080\110\045")
objTheeNightHunters.Description = ""
objTheeNightHunters.AltText = ""
objTheeNightHunters.Resources = {
	{
		Type = "jpg", 
		Filename = "TheeNightHunters.jpg", 
		Directives = {}
	}
}
objCanalLockHouse = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objCanalLockHouse.Id = "c3dba169-ee20-4513-8e6f-5ff6811cf863"
objCanalLockHouse.Name = _sDDfW("\061\032\078\032\114\099\023\041\020\093\099\087\041\067\045\080")
objCanalLockHouse.Description = ""
objCanalLockHouse.AltText = ""
objCanalLockHouse.Resources = {
	{
		Type = "JPG", 
		Filename = "LockTender.JPG", 
		Directives = {}
	}
}
objTheeNightHunters2 = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objTheeNightHunters2.Id = "6988f6f0-60ef-42aa-84ca-0f0f65fed548"
objTheeNightHunters2.Name = _sDDfW("\012\018\080\080\119\094\047\018\089\087\067\078\089\080\110\045\099\079")
objTheeNightHunters2.Description = ""
objTheeNightHunters2.AltText = ""
objTheeNightHunters2.Resources = {
	{
		Type = "jpg", 
		Filename = "TheeNightHunters2.jpg", 
		Directives = {}
	}
}
objGreyvin3 = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objGreyvin3.Id = "d9cbfb11-a508-4ae5-b1a7-5ce80fc1db06"
objGreyvin3.Name = _sDDfW("\069\110\080\043\058\094\078\099\048")
objGreyvin3.Description = ""
objGreyvin3.AltText = ""
objGreyvin3.Resources = {
	{
		Type = "jpg", 
		Filename = "greyvin1-Copy.jpg", 
		Directives = {}
	}
}
objGreyvin4 = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objGreyvin4.Id = "d148bbc7-db38-43d5-9efc-ebfd8ddf4442"
objGreyvin4.Name = _sDDfW("\069\110\080\043\058\094\078\099\077")
objGreyvin4.Description = ""
objGreyvin4.AltText = ""
objGreyvin4.Resources = {
	{
		Type = "jpg", 
		Filename = "greyvin1-Copy2.jpg", 
		Directives = {}
	}
}
objGreyvin5 = Wherigo.ZMedia(objMeettheCOSattheLVGGPWherigo)
objGreyvin5.Id = "b8f5c53b-fe17-44ad-8f8e-94fef0197239"
objGreyvin5.Name = _sDDfW("\069\110\080\043\058\094\078\099\027")
objGreyvin5.Description = ""
objGreyvin5.AltText = ""
objGreyvin5.Resources = {
	{
		Type = "jpg", 
		Filename = "greyvin1-Copy3.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
objMeettheCOSattheLVGGPWherigo.Id="126a227b-300e-426e-9e58-c69d3c30158d"
objMeettheCOSattheLVGGPWherigo.Name="Meet the CO'S at the LVGGP Wherigo"
objMeettheCOSattheLVGGPWherigo.Description=[[This simple but long Wherigo is a tour of our Lehigh Valley Geocachers Geo Park. It can be used to help you plan your caching day here. It is also designed to give those that were not able to be here for our opening event to get to know each of the cache owners from the park a little better. It will serve as our own virtual event to give you the feel of being here on the opening day. This is the easiest wherigo I have created so far as there are no challenges, questions or penalties to pay on this one. It will simple accompany you from cache to cache across our park sharing little tidbits of information about the cache owners and our geo park. This Wherigo is associated with cache GC3BTRD which you will find and log in the end.  If you can I would suggest using a smart phone for the cartridge while continuing to hunt for each cache on a separate phone or GPS, it should be safe to leave the game to do the caches and resume the game from where you left off but I would really hate for you to lose the game in the middle. Good Luck and best wishes from all the Cache Owners! We hope you enjoy doing our park as much as we have enjoyed setting it up for you.]]
objMeettheCOSattheLVGGPWherigo.Visible=true
objMeettheCOSattheLVGGPWherigo.Activity="Geocache"
objMeettheCOSattheLVGGPWherigo.StartingLocationDescription=[[This cartridge will begin in the west side parking area in Hugh Moore Park where we are holding our caching event. The event is GC3B3N0 there are driving directions to the GZ on that cache page.]]
objMeettheCOSattheLVGGPWherigo.StartingLocation = ZonePoint(40.664167,-75.237917,0)
objMeettheCOSattheLVGGPWherigo.Version="1.0"
objMeettheCOSattheLVGGPWherigo.Company=""
objMeettheCOSattheLVGGPWherigo.Author="agility3d"
objMeettheCOSattheLVGGPWherigo.BuilderVersion="URWIGO 1.12.4281.38707"
objMeettheCOSattheLVGGPWherigo.CreateDate="01/26/2012 02:12:02"
objMeettheCOSattheLVGGPWherigo.PublishDate="1/1/0001 12:00:00 AM"
objMeettheCOSattheLVGGPWherigo.UpdateDate="02/01/2012 02:04:37"
objMeettheCOSattheLVGGPWherigo.LastPlayedDate="1/1/0001 12:00:00 AM"
objMeettheCOSattheLVGGPWherigo.TargetDevice="PocketPC"
objMeettheCOSattheLVGGPWherigo.TargetDeviceVersion="0"
objMeettheCOSattheLVGGPWherigo.StateId="1"
objMeettheCOSattheLVGGPWherigo.CountryId="2"
objMeettheCOSattheLVGGPWherigo.Complete=false
objMeettheCOSattheLVGGPWherigo.UseLogging=true

objMeettheCOSattheLVGGPWherigo.Icon=objCanalLockHouse


-- Zones --
obj13MadhaulerTrad = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj13MadhaulerTrad.Id = "e185cc2b-c960-4593-b406-6ee3d82ac207"
obj13MadhaulerTrad.Name = _sDDfW("\120\048\099\123\032\117\018\032\067\114\080\110\099\012\110\032\117")
obj13MadhaulerTrad.Description = _sDDfW("\069\061\048\118\029\055\091")
obj13MadhaulerTrad.Visible = true
obj13MadhaulerTrad.Media = objMadhauler
obj13MadhaulerTrad.Commands = {}
obj13MadhaulerTrad.DistanceRange = Distance(-1, "feet")
obj13MadhaulerTrad.ShowObjects = "OnEnter"
obj13MadhaulerTrad.ProximityRange = Distance(60, "meters")
obj13MadhaulerTrad.AllowSetPositionTo = false
obj13MadhaulerTrad.Active = false
obj13MadhaulerTrad.Points = {
	ZonePoint(40.6734658971464, -75.2333542864561, 0), 
	ZonePoint(40.6731933024611, -75.23350717237, 0), 
	ZonePoint(40.6733143427762, -75.2340087454558, 0), 
	ZonePoint(40.6735635427328, -75.2338062386752, 0)
}
obj13MadhaulerTrad.OriginalPoint = ZonePoint(40.6733842712791, -75.2336691107393, 0)
obj13MadhaulerTrad.DistanceRangeUOM = "Feet"
obj13MadhaulerTrad.ProximityRangeUOM = "Meters"
obj13MadhaulerTrad.OutOfRangeName = ""
obj13MadhaulerTrad.InRangeName = ""
obj5GreyvinEarth = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj5GreyvinEarth.Id = "19e92824-43c7-4df6-88d9-105dd3d9caac"
obj5GreyvinEarth.Name = _sDDfW("\027\099\069\110\080\043\058\094\078\099\063\032\110\089\018")
obj5GreyvinEarth.Description = _sDDfW("\069\061\048\118\003\076\054\030\033\095\014")
obj5GreyvinEarth.Visible = true
obj5GreyvinEarth.Media = objGreyvin2
obj5GreyvinEarth.Commands = {}
obj5GreyvinEarth.DistanceRange = Distance(-1, "feet")
obj5GreyvinEarth.ShowObjects = "OnEnter"
obj5GreyvinEarth.ProximityRange = Distance(60, "meters")
obj5GreyvinEarth.AllowSetPositionTo = false
obj5GreyvinEarth.Active = false
obj5GreyvinEarth.Points = {
	ZonePoint(40.6686910208139, -75.2364953613597, 0), 
	ZonePoint(40.6685221628923, -75.2361721551734, 0), 
	ZonePoint(40.6682709096513, -75.2363438165504, 0), 
	ZonePoint(40.6684102688533, -75.2367166436032, 0)
}
obj5GreyvinEarth.OriginalPoint = ZonePoint(40.6684735905527, -75.2364319941717, 0)
obj5GreyvinEarth.DistanceRangeUOM = "Feet"
obj5GreyvinEarth.ProximityRangeUOM = "Meters"
obj5GreyvinEarth.OutOfRangeName = ""
obj5GreyvinEarth.InRangeName = ""
obj1WizardTrad = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj1WizardTrad.Id = "cc480a96-b927-4f9f-a2c2-5f7e7b25f265"
obj1WizardTrad.Name = _sDDfW("\120\099\125\094\083\032\110\117\099\012\110\032\117")
obj1WizardTrad.Description = _sDDfW("\012\018\094\045\099\094\045\099\089\018\080\099\069\039\099\032\110\080\032\099\066\041\110\099\125\094\083\032\110\117\120\029\079\029\099\020\032\020\018\080\099\069\061\048\033\087\087\063\008\030\033\095\014")
obj1WizardTrad.Visible = true
obj1WizardTrad.Media = objWizard
obj1WizardTrad.Commands = {}
obj1WizardTrad.DistanceRange = Distance(-1, "feet")
obj1WizardTrad.ShowObjects = "OnEnter"
obj1WizardTrad.ProximityRange = Distance(60, "meters")
obj1WizardTrad.AllowSetPositionTo = false
obj1WizardTrad.Active = true
obj1WizardTrad.Points = {
	ZonePoint(40.664451636534, -75.2386391834498, 0), 
	ZonePoint(40.6643427875097, -75.23838035028, 0), 
	ZonePoint(40.6641240716434, -75.2385010496856, 0), 
	ZonePoint(40.6641912124042, -75.2388054804087, 0)
}
obj1WizardTrad.OriginalPoint = ZonePoint(40.6642774270228, -75.238581515956, 0)
obj1WizardTrad.DistanceRangeUOM = "Feet"
obj1WizardTrad.ProximityRangeUOM = "Meters"
obj1WizardTrad.OutOfRangeName = ""
obj1WizardTrad.InRangeName = ""
obj2TheeNightHuntersStage1 = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj2TheeNightHuntersStage1.Id = "470a020e-636c-4446-9b20-3adcffc19b27"
obj2TheeNightHuntersStage1.Name = _sDDfW("\079\099\012\018\080\080\119\094\047\018\089\087\067\078\089\080\110\045\099\060\089\032\047\080\099\120")
obj2TheeNightHuntersStage1.Description = _sDDfW("\060\089\032\047\080\099\120\099\041\066\099\069\061\048\033\090\061\055\030\033\095\014")
obj2TheeNightHuntersStage1.Visible = true
obj2TheeNightHuntersStage1.Media = objTheeNightHunters2
obj2TheeNightHuntersStage1.Commands = {}
obj2TheeNightHuntersStage1.DistanceRange = Distance(-1, "feet")
obj2TheeNightHuntersStage1.ShowObjects = "OnEnter"
obj2TheeNightHuntersStage1.ProximityRange = Distance(60, "meters")
obj2TheeNightHuntersStage1.AllowSetPositionTo = false
obj2TheeNightHuntersStage1.Active = false
obj2TheeNightHuntersStage1.Points = {
	ZonePoint(40.658850868279, -75.2432164454384, 0), 
	ZonePoint(40.6590212767309, -75.2430776411219, 0), 
	ZonePoint(40.6588269601927, -75.2428067380114, 0), 
	ZonePoint(40.6586977546419, -75.2429690116568, 0)
}
obj2TheeNightHuntersStage1.OriginalPoint = ZonePoint(40.6588492149611, -75.2430174590571, 0)
obj2TheeNightHuntersStage1.DistanceRangeUOM = "Feet"
obj2TheeNightHuntersStage1.ProximityRangeUOM = "Meters"
obj2TheeNightHuntersStage1.OutOfRangeName = ""
obj2TheeNightHuntersStage1.InRangeName = ""
obj10ArubaXpress1 = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj10ArubaXpress1.Id = "e53e8e23-9f53-46a1-83e0-1b963a0adf6a"
obj10ArubaXpress1.Name = _sDDfW("\120\017\099\118\110\067\052\032\009\050\110\080\045\045\099\120")
obj10ArubaXpress1.Description = _sDDfW("\069\061\048\033\048\033\076")
obj10ArubaXpress1.Visible = true
obj10ArubaXpress1.Media = objArubaXpress
obj10ArubaXpress1.Commands = {}
obj10ArubaXpress1.DistanceRange = Distance(-1, "feet")
obj10ArubaXpress1.ShowObjects = "OnEnter"
obj10ArubaXpress1.ProximityRange = Distance(60, "meters")
obj10ArubaXpress1.AllowSetPositionTo = false
obj10ArubaXpress1.Active = false
obj10ArubaXpress1.Points = {
	ZonePoint(40.6827560571779, -75.2245934712333, 0), 
	ZonePoint(40.6828775886306, -75.2241234141034, 0), 
	ZonePoint(40.6825735053325, -75.2239182251138, 0), 
	ZonePoint(40.6824494308123, -75.2243742006463, 0)
}
obj10ArubaXpress1.OriginalPoint = ZonePoint(40.6826641454883, -75.2242523277742, 0)
obj10ArubaXpress1.DistanceRangeUOM = "Feet"
obj10ArubaXpress1.ProximityRangeUOM = "Meters"
obj10ArubaXpress1.OutOfRangeName = ""
obj10ArubaXpress1.InRangeName = ""
obj7Agility3dPuzzleS1 = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj7Agility3dPuzzleS1.Id = "f75790b1-963d-45e0-af6e-798eca51a675"
obj7Agility3dPuzzleS1.Name = _sDDfW("\051\099\118\047\094\114\094\089\043\048\117\099\055\067\083\083\114\080\099\060\120")
obj7Agility3dPuzzleS1.Description = _sDDfW("\060\089\032\047\080\099\120\099\041\066\099\069\061\048\033\033\091\063")
obj7Agility3dPuzzleS1.Visible = true
obj7Agility3dPuzzleS1.Media = objagility3d
obj7Agility3dPuzzleS1.Commands = {}
obj7Agility3dPuzzleS1.DistanceRange = Distance(-1, "feet")
obj7Agility3dPuzzleS1.ShowObjects = "OnEnter"
obj7Agility3dPuzzleS1.ProximityRange = Distance(60, "meters")
obj7Agility3dPuzzleS1.AllowSetPositionTo = false
obj7Agility3dPuzzleS1.Active = false
obj7Agility3dPuzzleS1.Points = {
	ZonePoint(40.6746101712489, -75.2315639103813, 0), 
	ZonePoint(40.6747978305127, -75.2320420141381, 0), 
	ZonePoint(40.6745781318096, -75.2322190399332, 0), 
	ZonePoint(40.674383860594, -75.2316745515031, 0)
}
obj7Agility3dPuzzleS1.OriginalPoint = ZonePoint(40.6745924985413, -75.2318748789889, 0)
obj7Agility3dPuzzleS1.DistanceRangeUOM = "Feet"
obj7Agility3dPuzzleS1.ProximityRangeUOM = "Meters"
obj7Agility3dPuzzleS1.OutOfRangeName = ""
obj7Agility3dPuzzleS1.InRangeName = ""
obj11GreyvinBusy = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj11GreyvinBusy.Id = "0853d623-b602-43a9-a7fb-cbb05734cacd"
obj11GreyvinBusy.Name = _sDDfW("\120\120\099\069\110\080\043\058\094\078\099\033\067\045\043")
obj11GreyvinBusy.Description = _sDDfW("\069\061\048\118\003\055\077")
obj11GreyvinBusy.Visible = true
obj11GreyvinBusy.Media = objGreyvin
obj11GreyvinBusy.Commands = {}
obj11GreyvinBusy.DistanceRange = Distance(-1, "feet")
obj11GreyvinBusy.ShowObjects = "OnEnter"
obj11GreyvinBusy.ProximityRange = Distance(58, "meters")
obj11GreyvinBusy.AllowSetPositionTo = false
obj11GreyvinBusy.Active = false
obj11GreyvinBusy.Points = {
	ZonePoint(40.6811553745528, -75.2275128012579, 0), 
	ZonePoint(40.6813226749479, -75.2273230349703, 0), 
	ZonePoint(40.6811487638902, -75.2271205281896, 0), 
	ZonePoint(40.6810409591472, -75.2272948717756, 0)
}
obj11GreyvinBusy.OriginalPoint = ZonePoint(40.6811669431345, -75.2273128090484, 0)
obj11GreyvinBusy.DistanceRangeUOM = "Feet"
obj11GreyvinBusy.ProximityRangeUOM = "Meters"
obj11GreyvinBusy.OutOfRangeName = ""
obj11GreyvinBusy.InRangeName = ""
obj12ArubaXpress2 = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj12ArubaXpress2.Id = "3ec41148-837e-4c83-b701-966aa64d80cf"
obj12ArubaXpress2.Name = _sDDfW("\120\079\099\118\110\067\052\032\009\050\110\080\045\045\099\079")
obj12ArubaXpress2.Description = _sDDfW("\069\061\048\033\120\039\087")
obj12ArubaXpress2.Visible = true
obj12ArubaXpress2.Media = objArubaXpress
obj12ArubaXpress2.Commands = {}
obj12ArubaXpress2.DistanceRange = Distance(-1, "feet")
obj12ArubaXpress2.ShowObjects = "OnEnter"
obj12ArubaXpress2.ProximityRange = Distance(60, "meters")
obj12ArubaXpress2.AllowSetPositionTo = false
obj12ArubaXpress2.Active = false
obj12ArubaXpress2.Points = {
	ZonePoint(40.6798181818407, -75.2292160663052, 0), 
	ZonePoint(40.6801166839847, -75.2289914313001, 0), 
	ZonePoint(40.6798990368976, -75.2287352803393, 0), 
	ZonePoint(40.6796874913842, -75.2289297404928, 0)
}
obj12ArubaXpress2.OriginalPoint = ZonePoint(40.6798803485268, -75.2289681296094, 0)
obj12ArubaXpress2.DistanceRangeUOM = "Feet"
obj12ArubaXpress2.ProximityRangeUOM = "Meters"
obj12ArubaXpress2.OutOfRangeName = ""
obj12ArubaXpress2.InRangeName = ""
obj8Agility3dPuzzleS2 = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj8Agility3dPuzzleS2.Id = "14a8e74e-414f-4334-a05d-86276f5475ed"
obj8Agility3dPuzzleS2.Name = _sDDfW("\090\099\118\047\094\114\094\089\043\048\117\099\055\067\083\083\114\080\099\060\079")
obj8Agility3dPuzzleS2.Description = _sDDfW("\060\089\032\047\080\099\079\099\041\066\099\069\061\048\033\033\091\063")
obj8Agility3dPuzzleS2.Visible = true
obj8Agility3dPuzzleS2.Media = objagility3d
obj8Agility3dPuzzleS2.Commands = {}
obj8Agility3dPuzzleS2.DistanceRange = Distance(-1, "feet")
obj8Agility3dPuzzleS2.ShowObjects = "OnEnter"
obj8Agility3dPuzzleS2.ProximityRange = Distance(60, "meters")
obj8Agility3dPuzzleS2.AllowSetPositionTo = false
obj8Agility3dPuzzleS2.Active = false
obj8Agility3dPuzzleS2.Points = {
	ZonePoint(40.6759334355559, -75.2314793288708, 0), 
	ZonePoint(40.676155672546, -75.2313485711812, 0), 
	ZonePoint(40.676026500564, -75.2309744030237, 0), 
	ZonePoint(40.6758068059097, -75.2310535281896, 0)
}
obj8Agility3dPuzzleS2.OriginalPoint = ZonePoint(40.6759806036439, -75.2312139578163, 0)
obj8Agility3dPuzzleS2.DistanceRangeUOM = "Feet"
obj8Agility3dPuzzleS2.ProximityRangeUOM = "Meters"
obj8Agility3dPuzzleS2.OutOfRangeName = ""
obj8Agility3dPuzzleS2.InRangeName = ""
obj9Agility3dPuzzleS3 = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj9Agility3dPuzzleS3.Id = "d5535726-8e0d-4797-b6c4-d240e73526e9"
obj9Agility3dPuzzleS3.Name = _sDDfW("\073\099\118\047\094\114\094\089\043\048\117\099\055\067\083\083\114\080\099\060\048")
obj9Agility3dPuzzleS3.Description = _sDDfW("\060\089\032\047\080\099\048\099\041\066\099\069\061\048\033\033\091\063")
obj9Agility3dPuzzleS3.Visible = true
obj9Agility3dPuzzleS3.Media = objagility3d
obj9Agility3dPuzzleS3.Commands = {}
obj9Agility3dPuzzleS3.DistanceRange = Distance(-1, "feet")
obj9Agility3dPuzzleS3.ShowObjects = "OnEnter"
obj9Agility3dPuzzleS3.ProximityRange = Distance(56, "meters")
obj9Agility3dPuzzleS3.AllowSetPositionTo = false
obj9Agility3dPuzzleS3.Active = false
obj9Agility3dPuzzleS3.Points = {
	ZonePoint(40.677496385102, -75.2307964393215, 0), 
	ZonePoint(40.6777796414975, -75.2306589761095, 0), 
	ZonePoint(40.677676916696, -75.2302123883085, 0), 
	ZonePoint(40.6773738267553, -75.230303583415, 0)
}
obj9Agility3dPuzzleS3.OriginalPoint = ZonePoint(40.6775816925127, -75.2304928467886, 0)
obj9Agility3dPuzzleS3.DistanceRangeUOM = "Feet"
obj9Agility3dPuzzleS3.ProximityRangeUOM = "Meters"
obj9Agility3dPuzzleS3.OutOfRangeName = ""
obj9Agility3dPuzzleS3.InRangeName = ""
obj3TheeNightHuntersStage2 = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj3TheeNightHuntersStage2.Id = "992c84bf-e8d3-40af-8a6c-ba7d281d3be0"
obj3TheeNightHuntersStage2.Name = _sDDfW("\048\099\012\018\080\080\119\094\047\018\089\087\067\078\089\080\110\045\099\060\089\032\047\080\099\079")
obj3TheeNightHuntersStage2.Description = _sDDfW("\060\089\032\047\080\099\079\099\041\066\099\069\061\048\033\090\061\055")
obj3TheeNightHuntersStage2.Visible = true
obj3TheeNightHuntersStage2.Media = objTheeNightHunters
obj3TheeNightHuntersStage2.Commands = {}
obj3TheeNightHuntersStage2.DistanceRange = Distance(-1, "feet")
obj3TheeNightHuntersStage2.ShowObjects = "OnEnter"
obj3TheeNightHuntersStage2.ProximityRange = Distance(56, "meters")
obj3TheeNightHuntersStage2.AllowSetPositionTo = false
obj3TheeNightHuntersStage2.Active = false
obj3TheeNightHuntersStage2.Points = {
	ZonePoint(40.6575175911168, -75.2445513693809, 0), 
	ZonePoint(40.657517082424, -75.2442073760748, 0), 
	ZonePoint(40.6575109781106, -75.2441376386404, 0), 
	ZonePoint(40.657498769482, -75.2439498840092, 0), 
	ZonePoint(40.6572393355955, -75.2442261515379, 0)
}
obj3TheeNightHuntersStage2.OriginalPoint = ZonePoint(40.6574567513458, -75.2442144839286, 0)
obj3TheeNightHuntersStage2.DistanceRangeUOM = "Feet"
obj3TheeNightHuntersStage2.ProximityRangeUOM = "Meters"
obj3TheeNightHuntersStage2.OutOfRangeName = ""
obj3TheeNightHuntersStage2.InRangeName = ""
obj4TheeNightHuntersStage3 = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj4TheeNightHuntersStage3.Id = "9c1067fe-621e-4fdb-9923-d614ae105d37"
obj4TheeNightHuntersStage3.Name = _sDDfW("\077\099\012\018\080\080\119\094\047\018\089\087\067\078\089\080\110\045\099\060\089\032\047\080\099\048")
obj4TheeNightHuntersStage3.Description = _sDDfW("\060\089\032\047\080\099\048\099\041\066\099\069\061\048\033\090\061\055")
obj4TheeNightHuntersStage3.Visible = true
obj4TheeNightHuntersStage3.Media = objTheeNightHunters2
obj4TheeNightHuntersStage3.Commands = {}
obj4TheeNightHuntersStage3.DistanceRange = Distance(-1, "feet")
obj4TheeNightHuntersStage3.ShowObjects = "OnEnter"
obj4TheeNightHuntersStage3.ProximityRange = Distance(60, "meters")
obj4TheeNightHuntersStage3.AllowSetPositionTo = false
obj4TheeNightHuntersStage3.Active = false
obj4TheeNightHuntersStage3.Points = {
	ZonePoint(40.6577731024963, -75.2438281901435, 0), 
	ZonePoint(40.6577675068971, -75.2442083932714, 0), 
	ZonePoint(40.6575304565367, -75.2444766141729, 0), 
	ZonePoint(40.6575121435983, -75.244038072999, 0)
}
obj4TheeNightHuntersStage3.OriginalPoint = ZonePoint(40.6576458023821, -75.2441378176467, 0)
obj4TheeNightHuntersStage3.DistanceRangeUOM = "Feet"
obj4TheeNightHuntersStage3.ProximityRangeUOM = "Meters"
obj4TheeNightHuntersStage3.OutOfRangeName = ""
obj4TheeNightHuntersStage3.InRangeName = ""
obj15FINAL = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj15FINAL.Id = "78be67db-dee8-472b-b9c9-6566c6b2ff7f"
obj15FINAL.Name = _sDDfW("\120\027\099\109\116\119\118\023")
obj15FINAL.Description = _sDDfW("\125\018\080\110\094\047\041\099\109\094\078\032\114")
obj15FINAL.Visible = true
obj15FINAL.Media = objagility3d
obj15FINAL.Commands = {}
obj15FINAL.DistanceRange = Distance(-1, "feet")
obj15FINAL.ShowObjects = "OnEnter"
obj15FINAL.ProximityRange = Distance(60, "meters")
obj15FINAL.AllowSetPositionTo = false
obj15FINAL.Active = false
obj15FINAL.Points = {
	ZonePoint(40.6654784980812, -75.2375748711987, 0), 
	ZonePoint(40.665730270473, -75.2375058043165, 0), 
	ZonePoint(40.6657211151299, -75.2371504116221, 0), 
	ZonePoint(40.6653691420999, -75.2371852803392, 0)
}
obj15FINAL.OriginalPoint = ZonePoint(40.665574756446, -75.2373540918691, 0)
obj15FINAL.DistanceRangeUOM = "Feet"
obj15FINAL.ProximityRangeUOM = "Meters"
obj15FINAL.OutOfRangeName = ""
obj15FINAL.InRangeName = ""
obj6GreyvinLetter = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj6GreyvinLetter.Id = "1471475d-4cbf-4669-8601-53c2423cba2d"
obj6GreyvinLetter.Name = _sDDfW("\029\099\069\110\080\043\058\094\078\099\023\080\089\089\080\110")
obj6GreyvinLetter.Description = _sDDfW("\069\061\048\118\003\087\012")
obj6GreyvinLetter.Visible = true
obj6GreyvinLetter.Media = objGreyvin
obj6GreyvinLetter.Commands = {}
obj6GreyvinLetter.DistanceRange = Distance(-1, "feet")
obj6GreyvinLetter.ShowObjects = "OnEnter"
obj6GreyvinLetter.ProximityRange = Distance(60, "meters")
obj6GreyvinLetter.AllowSetPositionTo = false
obj6GreyvinLetter.Active = false
obj6GreyvinLetter.Points = {
	ZonePoint(40.6700261911669, -75.2358180779618, 0), 
	ZonePoint(40.67006586175, -75.2353393036527, 0), 
	ZonePoint(40.6697647716063, -75.23537417237, 0), 
	ZonePoint(40.6697515480214, -75.23585026447, 0)
}
obj6GreyvinLetter.OriginalPoint = ZonePoint(40.6699020931362, -75.2355954546136, 0)
obj6GreyvinLetter.DistanceRangeUOM = "Feet"
obj6GreyvinLetter.ProximityRangeUOM = "Meters"
obj6GreyvinLetter.OutOfRangeName = ""
obj6GreyvinLetter.InRangeName = ""
obj12GreyvinPaintPuzzle = Wherigo.Zone(objMeettheCOSattheLVGGPWherigo)
obj12GreyvinPaintPuzzle.Id = "14bce90e-82a1-41aa-bc0c-600f07c6f8c4"
obj12GreyvinPaintPuzzle.Name = _sDDfW("\120\079\099\069\110\080\043\058\094\078\099\055\032\094\078\089\099\055\067\083\083\114\080")
obj12GreyvinPaintPuzzle.Description = _sDDfW("\069\061\118\003\003\039")
obj12GreyvinPaintPuzzle.Visible = true
obj12GreyvinPaintPuzzle.Media = objGreyvin
obj12GreyvinPaintPuzzle.Commands = {}
obj12GreyvinPaintPuzzle.DistanceRange = Distance(-1, "feet")
obj12GreyvinPaintPuzzle.ShowObjects = "OnEnter"
obj12GreyvinPaintPuzzle.ProximityRange = Distance(60, "meters")
obj12GreyvinPaintPuzzle.AllowSetPositionTo = false
obj12GreyvinPaintPuzzle.Active = false
obj12GreyvinPaintPuzzle.Points = {
	ZonePoint(40.6714752798203, -75.2352686188857, 0), 
	ZonePoint(40.6718195918685, -75.2349447421472, 0), 
	ZonePoint(40.6715602136812, -75.2342259101312, 0), 
	ZonePoint(40.6712031855852, -75.2346362881104, 0)
}
obj12GreyvinPaintPuzzle.OriginalPoint = ZonePoint(40.6715145677388, -75.2347688898186, 0)
obj12GreyvinPaintPuzzle.DistanceRangeUOM = "Feet"
obj12GreyvinPaintPuzzle.ProximityRangeUOM = "Meters"
obj12GreyvinPaintPuzzle.OutOfRangeName = ""
obj12GreyvinPaintPuzzle.InRangeName = ""

-- Characters --

-- Items --

-- Tasks --

-- Cartridge Variables --
objanswer = ""
objMeettheCOSattheLVGGPWherigo.ZVariables = {
	objanswer = ""
}

-- Timers --
objName = Wherigo.ZTimer(objMeettheCOSattheLVGGPWherigo)
objName.Id = "2fec35e1-ddf5-49ba-8fdd-49a293143e9c"
objName.Name = _sDDfW("\119\032\068\080")
objName.Description = ""
objName.Visible = true
objName.Duration = 60.7390311578005
objName.Type = "Countdown"

-- Inputs --
objFinalZone = Wherigo.ZInput(objMeettheCOSattheLVGGPWherigo)
objFinalZone.Id = "849054d7-6691-40a1-a45e-0074674574a4"
objFinalZone.Name = _sDDfW("\109\094\078\032\114\099\039\041\078\080")
objFinalZone.Description = ""
objFinalZone.Visible = true
objFinalZone.Choices = {
	"Yes", 
	"No"
}
objFinalZone.InputType = "MultipleChoice"
objFinalZone.Text = _sDDfW("\054\094\117\099\043\041\067\099\068\032\078\032\047\080\099\089\041\099\066\094\078\117\099\069\110\080\043\058\094\078\045\099\050\067\083\083\114\080\099\020\032\020\018\080\099\069\061\118\003\003\039\011")
objFinal2 = Wherigo.ZInput(objMeettheCOSattheLVGGPWherigo)
objFinal2.Id = "c5465a44-b2e2-4730-b627-51f7bd57e7d2"
objFinal2.Name = _sDDfW("\109\094\078\032\114\099\079")
objFinal2.Description = ""
objFinal2.Visible = true
objFinal2.Choices = {
	"Yes", 
	"No"
}
objFinal2.InputType = "MultipleChoice"
objFinal2.Text = _sDDfW("\087\032\058\080\099\043\041\067\099\096\110\094\089\089\080\078\099\117\041\096\078\099\089\018\080\099\020\041\068\050\114\080\089\094\041\078\099\020\041\117\080\011")

-- WorksWithList for object commands --

-- functions --
function objMeettheCOSattheLVGGPWherigo:OnStart()
	if (_G[_sDDfW("\063\078\058")][_sDDfW("\055\114\032\089\066\041\110\068")] == _sDDfW("\125\094\078\048\079")) or (_G[_sDDfW("\063\078\058")][_sDDfW("\054\080\058\094\020\080\116\054")] == _sDDfW("\054\080\045\093\089\041\050")) then
		for k, v in pairs(_G[_sDDfW("\041\052\002\123\080\080\089\089\018\080\061\121\060\032\089\089\018\080\023\091\069\069\055\125\018\080\110\094\047\041")][_sDDfW("\118\114\114\039\121\052\002\080\020\089\045")]) do
			v[_sDDfW("\091\094\045\094\052\114\080")] = false
			v[_sDDfW("\118\020\089\094\058\080")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_sDDfW("\060\041\110\110\043\099\043\041\067\099\020\032\078\078\041\089\099\050\114\032\043\099\089\018\094\045\099\047\032\068\080\099\094\078\099\089\018\080\099\080\068\067\114\032\089\041\110\099\068\041\117\080\008")), 
			Callback = function(action)
				if action ~= nil then
					_G[_sDDfW("\125\018\080\110\094\047\041")][_sDDfW("\061\041\068\068\032\078\117")](_sDDfW("\060\032\058\080\061\114\041\045\080"))
				end
			end
		}
		return
	end
	objName[_sDDfW("\060\089\032\110\089")](objName)
	_Urwigo.MessageBox{
		Text = _sDDfW("\125\080\114\020\041\068\080\099\089\041\099\089\018\080\099\023\080\018\094\047\018\099\091\032\114\114\080\043\099\069\080\041\020\032\020\018\080\110\045\099\069\080\041\099\055\032\110\093\008"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\123\032\117\018\032\067\114\080\110\099\020\032\068\080\099\067\050\099\096\094\089\018\099\089\018\080\099\094\117\080\032\099\066\041\110\099\089\018\094\045\099\050\032\110\093\099\032\078\117\099\032\099\045\068\032\114\114\099\047\110\041\067\050\099\041\066\099\114\041\020\032\114\099\020\032\020\018\080\110\045\099\018\080\114\050\080\117\099\089\041\099\068\032\093\080\099\094\089\099\018\032\050\050\080\078\005\099\125\080\099\018\041\050\080\099\043\041\067\099\080\078\002\041\043\099\066\094\078\117\094\078\047\099\089\018\080\045\080\099\020\032\020\018\080\045\021\099\096\080\099\080\032\020\018\099\080\078\002\041\043\080\117\099\050\114\032\020\094\078\047\099\089\018\080\068\099\018\080\110\080\099\032\078\117\099\114\041\058\080\117\099\089\018\080\099\094\117\080\032\099\041\066\099\050\110\080\045\080\078\089\094\078\047\099\032\099\045\050\080\020\094\032\114\099\020\032\020\018\094\078\047\099\083\041\078\080\008"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\055\114\032\043\094\078\047\099\089\018\094\045\099\096\018\080\110\094\047\041\099\096\094\114\114\099\089\032\093\080\099\043\041\067\099\041\078\099\032\099\002\041\067\110\078\080\043\099\032\020\110\041\045\045\099\041\067\110\099\094\045\114\032\078\117\099\032\078\117\099\018\080\114\050\099\043\041\067\099\108\067\032\114\094\066\043\099\066\041\110\099\089\018\080\099\121\078\080\099\033\067\045\043\099\054\032\043\099\061\018\032\114\114\080\078\047\080\099\032\089\099\089\018\080\099\023\091\069\069\055\099\069\061\048\118\003\055\077\099\020\032\020\018\080\005\099\125\018\094\114\080\099\089\018\080\110\080\099\094\045\099\078\041\099\110\080\108\067\110\094\080\068\080\078\089\099\066\041\110\099\089\018\080\099\041\110\117\080\110\099\089\018\032\089\099\043\041\067\099\066\094\078\117\099\089\018\080\045\080\099\020\032\020\018\080\045\099\089\018\094\045\099\020\032\110\089\110\094\117\047\080\099\096\094\114\114\099\066\041\114\114\041\096\099\096\018\032\089\099\020\041\067\114\117\099\052\080\099\089\018\080\099\080\032\045\094\080\045\089\099\050\032\089\018\005"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\116\066\099\043\041\067\099\032\110\080\099\018\080\110\080\099\041\078\099\089\018\080\099\041\050\080\078\094\078\047\099\117\032\043\099\052\080\099\045\067\110\080\099\089\041\099\045\094\047\078\099\089\018\080\099\114\041\047\099\066\041\110\099\089\018\080\099\080\058\080\078\089\099\020\032\020\018\080\005\099\063\078\002\041\043\099\045\041\068\080\099\020\041\066\066\080\080\099\041\110\099\018\041\089\099\020\018\041\020\041\114\032\089\080\099\032\078\117\099\032\099\117\041\067\047\018\078\067\089\005\099\119\041\096\099\089\018\032\089\099\096\032\045\099\032\078\099\080\032\045\043\099\096\032\043\099\089\041\099\047\080\089\099\043\041\067\110\099\066\094\110\045\089\099\020\032\020\018\080\099\089\043\050\080\099\117\041\078\080\099\066\041\110\099\089\018\080\099\117\032\043\005")
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	obj1WizardTrad.Active = true
	obj1WizardTrad.Visible = true
end
function objMeettheCOSattheLVGGPWherigo:OnRestore()
	objName[_sDDfW("\060\089\032\110\089")](objName)
end
function obj13MadhaulerTrad:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\087\094\099\116\099\032\068\099\123\032\117\018\032\067\114\080\110\099\041\110\099\095\094\020\018\099\089\041\099\068\067\047\047\114\080\045\008"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\116\099\018\041\050\080\099\043\041\067\099\032\110\080\099\080\078\002\041\043\094\078\047\099\089\018\094\045\099\069\080\041\050\032\110\093\099\032\078\117\099\116\099\032\068\099\047\114\032\117\099\080\058\080\110\043\041\078\080\099\114\094\093\080\117\099\032\078\117\099\045\067\050\050\041\110\089\080\117\099\089\018\080\099\094\117\080\032\099\096\018\080\078\099\116\099\050\110\080\045\080\078\089\080\117\099\089\041\099\089\018\080\099\114\041\020\032\114\099\047\080\041\020\032\020\018\080\110\045\005"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\116\099\117\110\094\058\080\099\032\078\099\120\090\007\096\018\080\080\114\080\110\099\020\110\041\045\045\099\020\041\067\078\089\110\043\099\045\041\099\020\018\041\041\045\094\078\047\099\068\043\099\047\080\041\099\078\032\068\080\099\096\032\045\099\050\110\080\089\089\043\099\080\032\045\043\005"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\116\099\018\032\058\080\099\052\080\080\078\099\020\032\020\018\094\078\047\099\045\094\078\020\080\099\123\032\110\020\018\021\099\079\017\120\017\099\032\078\117\099\052\080\020\032\067\045\080\099\041\066\099\068\043\099\002\041\052\099\116\099\018\032\058\080\099\066\094\078\117\045\099\094\078\099\032\089\099\114\080\032\045\089\099\048\051\099\045\089\032\089\080\045\005"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\123\043\099\066\032\058\041\110\094\089\080\099\020\032\020\018\080\099\066\094\078\117\099\094\045\099\089\018\080\099\062\078\052\045\050\038\087\041\050\080\099\061\080\068\080\089\080\110\043\099\125\018\080\110\080\094\047\041\099\012\041\067\110\099\069\061\048\077\118\017\095\099\096\018\094\020\018\099\094\045\099\078\041\089\099\089\041\041\099\066\032\110\099\066\110\041\068\099\041\067\110\099\069\080\041\055\032\110\093\005"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _sDDfW("\123\043\099\066\032\058\041\110\094\089\080\099\018\094\117\117\080\078\099\020\032\020\018\080\099\096\041\067\114\117\099\052\080\099\089\018\080\099\096\018\041\114\080\099\045\080\110\094\080\045\099\116\099\050\067\089\099\094\078\099\032\089\099\089\018\080\099\063\032\045\089\041\078\099\061\080\068\080\089\080\110\043\099\061\032\020\018\080\099\069\061\079\003\051\029\119\099\116\099\080\078\002\041\043\080\117\099\110\080\045\080\032\110\020\018\094\078\047\099\089\018\094\078\047\045\099\096\018\094\114\080\099\116\099\096\032\045\099\089\018\080\110\080\099\018\094\117\094\078\047\099\089\018\080\099\020\032\020\018\080\045\005"), 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _sDDfW("\116\099\114\094\093\080\099\020\032\020\018\094\078\047\099\052\080\020\032\067\045\080\099\094\089\099\094\045\099\066\032\068\094\114\043\099\041\110\094\080\078\089\080\117\008\099\116\089\013\045\099\080\117\067\020\032\089\094\041\078\032\114\008\099\116\089\013\045\099\066\067\078\008\099\116\099\117\041\078\013\089\099\093\078\041\096\099\032\078\043\099\041\089\018\080\110\099\032\020\089\094\058\094\089\043\099\089\018\032\089\099\032\114\114\099\068\080\068\052\080\110\045\099\041\066\099\032\099\066\032\068\094\114\043\099\020\032\078\099\080\078\002\041\043\099\089\041\047\080\089\018\080\110\005\099\012\018\080\099\052\080\045\089\099\050\032\110\089\099\094\045\099\094\089\099\066\094\089\045\099\032\099\066\032\068\094\114\043\045\099\052\067\117\047\080\089\099\045\094\078\020\080\099\094\089\099\117\041\080\045\078\013\089\099\020\041\045\089\099\032\099\096\018\041\114\080\099\114\041\089\099\041\066\099\068\041\078\080\043\005"), 
																				Callback = function(action)
																					if action ~= nil then
																						_Urwigo.MessageBox{
																							Text = _sDDfW("\116\099\080\078\002\041\043\099\096\032\089\020\018\094\078\047\099\089\018\080\099\080\084\050\110\080\045\045\094\041\078\045\099\041\078\099\093\094\117\045\013\099\066\032\020\080\045\099\096\018\080\078\099\089\018\080\043\099\066\094\078\117\099\032\099\020\032\020\018\080\008\099\116\013\058\080\099\052\080\080\078\099\041\067\089\099\020\032\020\018\094\078\047\099\096\094\089\018\099\012\032\094\114\045\050\094\078\120\077\099\032\078\117\099\018\094\045\099\043\041\067\078\047\099\045\041\078\045\005\099\125\032\089\020\018\094\078\047\099\089\018\080\094\110\099\045\068\094\114\080\045\099\096\018\080\078\099\089\018\080\043\099\066\094\078\117\099\032\099\020\032\020\018\080\099\094\045\099\032\099\110\080\096\032\110\117\099\052\043\099\094\089\045\080\114\066\008"), 
																							Callback = function(action)
																								if action ~= nil then
																									_Urwigo.MessageBox{
																										Text = _sDDfW("\118\047\032\094\078\099\116\099\018\041\050\080\099\043\041\067\099\080\078\002\041\043\099\068\043\099\020\032\020\018\080\099\018\080\110\080\099\032\078\117\099\032\114\114\099\089\018\080\099\020\032\020\018\080\045\099\094\078\099\041\067\110\099\069\080\041\055\032\110\093\005\099\062\078\052\045\050\038\092\041\067\099\032\110\080\099\032\114\068\041\045\089\099\117\041\078\080\099\096\094\089\018\099\041\067\110\099\050\032\110\093\005\099\116\066\099\043\041\067\099\018\032\058\080\099\045\041\114\058\080\117\099\089\018\080\099\050\067\083\083\114\080\099\066\041\110\099\069\061\048\118\003\003\039\099\096\018\094\020\018\099\094\045\099\069\110\080\043\058\094\078\045\099\050\067\083\083\114\080\099\020\032\020\018\080\099\043\041\067\099\020\032\078\099\018\080\032\117\099\041\078\099\041\058\080\110\099\089\041\099\117\041\099\094\089\099\078\041\096\005\099\116\066\099\078\041\089\099\089\018\080\078\099\043\041\067\099\032\110\080\099\041\066\066\099\089\041\099\066\094\078\094\045\018\099\089\018\094\045\099\047\032\068\080")
																									}
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
																obj15FINAL.Active = true
																obj15FINAL.Visible = true
																obj13MadhaulerTrad.Active = false
																obj13MadhaulerTrad.Visible = false
																obj12GreyvinPaintPuzzle.Active = true
																obj12GreyvinPaintPuzzle.Visible = false
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj5GreyvinEarth:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\087\094\099\096\080\099\032\110\080\099\123\094\093\080\099\032\078\117\099\119\094\020\041\114\080\099\032\078\117\099\096\080\099\032\110\080\099\093\078\041\096\078\099\032\045\099\069\110\080\043\058\094\078\005"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\121\067\110\099\020\032\020\018\094\078\047\099\078\032\068\080\099\094\045\099\032\099\020\041\068\052\094\078\032\089\094\041\078\099\041\066\099\041\067\110\099\093\094\117\045\013\099\078\032\068\080\045\005"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\125\080\099\045\089\032\110\089\080\117\099\020\032\020\018\094\078\047\099\041\078\099\017\120\097\079\090\097\079\017\017\090\099\045\041\099\096\080\099\018\032\058\080\099\052\080\080\078\099\020\032\020\018\094\078\047\099\066\041\110\099\066\041\067\110\099\043\080\032\110\045\005"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\125\080\099\096\080\110\080\099\058\080\110\043\099\018\032\050\050\043\099\089\041\099\018\080\114\050\099\068\032\093\080\099\089\018\094\045\099\069\080\041\050\032\110\093\099\018\032\050\050\080\078\099\032\078\117\099\089\041\099\052\110\094\078\047\099\032\099\121\078\080\099\033\067\045\043\099\054\032\043\099\061\032\020\018\080\099\061\018\032\114\114\080\078\047\080\099\089\041\099\041\067\110\099\032\110\080\032\005\099\012\041\099\018\080\114\050\099\043\041\067\099\020\041\068\050\114\080\089\080\099\089\018\032\089\099\089\032\045\093\099\096\080\099\018\032\058\080\099\094\078\020\114\067\117\080\117\099\041\067\110\099\066\094\110\045\089\099\063\032\110\089\018\099\020\032\020\018\080\099\018\080\110\080\005"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\123\032\093\080\099\045\067\110\080\099\043\041\067\099\045\080\078\117\099\067\045\099\089\018\080\099\110\080\108\067\094\110\080\117\099\094\078\066\041\099\096\018\080\078\099\043\041\067\099\114\041\047\099\089\018\080\099\066\094\078\117\099\018\080\110\080\005")
													}
													obj6GreyvinLetter.Active = true
													obj6GreyvinLetter.Visible = true
													obj5GreyvinEarth.Active = false
													obj5GreyvinEarth.Visible = false
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj1WizardTrad:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\087\094\099\069\080\041\020\032\020\018\080\110\045\021\099\116\099\032\068\099\055\032\067\114\005\099\062\078\052\045\050\038\116\099\032\068\099\125\094\083\032\110\117\120\029\079\029\008"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\116\099\018\032\058\080\099\050\114\032\020\080\117\099\032\099\012\110\032\117\094\089\094\041\078\032\114\099\020\032\020\018\080\099\078\080\032\110\099\018\080\110\080\099\094\089\099\094\045\099\069\061\048\033\087\087\063\008"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\116\099\018\032\058\080\099\052\080\080\078\099\047\080\041\020\032\020\018\094\078\047\099\045\094\078\020\080\099\012\018\032\078\093\045\047\094\058\094\078\047\099\079\017\017\073\008"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\116\099\018\032\058\080\099\080\078\002\041\043\080\117\099\110\041\114\080\099\050\114\032\043\094\078\047\099\047\032\068\080\045\099\045\094\078\020\080\099\089\018\080\099\045\080\058\080\078\089\094\080\045\099\032\078\117\099\114\094\093\080\099\089\041\099\050\114\032\043\099\089\018\080\068\099\032\045\099\032\099\125\094\083\032\110\117\099\045\041\099\020\018\041\041\045\094\078\047\099\068\043\099\020\032\020\018\094\078\047\099\078\032\068\080\099\096\032\045\099\002\067\045\089\099\032\099\068\032\089\089\080\110\099\041\066\099\032\117\117\094\078\047\099\032\099\078\067\068\052\080\110\099\052\080\018\094\078\117\099\089\018\080\099\125\094\083\032\110\117\099\089\094\089\114\080\005"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\116\099\018\032\058\080\099\089\096\041\099\066\032\058\041\110\094\089\080\099\020\032\020\018\080\099\066\094\078\117\045\008\099\109\094\110\045\089\099\094\045\099\109\095\121\069\039\099\032\078\117\099\119\101\012\060\099\032\089\099\089\018\080\099\055\041\041\114\099\069\061\120\017\123\109\061\099\094\089\099\096\032\045\099\068\043\099\120\017\017\089\018\099\066\094\078\117\099\032\078\117\099\096\032\045\099\032\114\045\041\099\117\041\078\080\099\041\078\099\068\043\099\052\094\110\089\018\117\032\043\005"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _sDDfW("\012\018\080\099\045\080\020\041\078\117\099\094\045\099\012\018\041\067\045\032\078\117\099\060\089\080\050\045\099\061\032\020\018\080\099\069\061\027\073\118\109\099\032\045\099\068\043\099\120\017\017\017\089\018\005\099\116\099\050\032\110\089\094\032\114\114\043\099\045\089\032\110\089\080\117\099\020\032\020\018\094\078\047\099\089\041\099\114\041\045\080\099\096\080\094\047\018\089\099\032\078\117\099\020\041\067\114\117\099\078\080\058\080\110\099\018\032\058\080\099\117\041\078\080\099\089\018\094\045\099\020\032\020\018\080\099\096\018\080\078\099\116\099\066\094\110\045\089\099\045\089\032\110\089\080\117\005"), 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _sDDfW("\123\043\099\066\032\058\041\110\094\089\080\099\018\094\117\080\099\094\045\099\109\032\068\094\114\043\099\123\032\089\089\080\110\045\099\069\061\079\051\076\076\069\005"), 
																				Callback = function(action)
																					if action ~= nil then
																						_Urwigo.MessageBox{
																							Text = _sDDfW("\123\043\099\066\032\058\041\110\094\089\080\099\089\018\094\078\047\045\099\032\052\041\067\089\099\047\080\041\020\032\020\018\094\078\047\099\032\110\080\099\047\080\089\089\094\078\047\099\041\067\089\117\041\041\110\045\099\032\078\117\099\096\032\114\093\094\078\047\005"), 
																							Callback = function(action)
																								if action ~= nil then
																									_Urwigo.MessageBox{
																										Text = _sDDfW("\116\099\018\041\050\080\099\043\041\067\099\080\078\002\041\043\099\068\043\099\020\032\020\018\080\099\018\080\110\080\021\099\041\078\020\080\099\043\041\067\099\018\032\058\080\099\066\041\067\078\117\099\094\089\099\043\041\067\099\020\032\078\099\018\080\032\117\099\041\058\080\110\099\089\041\099\012\018\080\080\119\094\047\018\089\087\067\078\089\080\110\045\099\123\043\099\054\094\078\047\099\118\099\023\094\078\047\099\068\067\114\089\094\099\020\032\020\018\080\099\069\061\048\033\090\061\055\008\099\063\078\002\041\043\099\043\041\067\110\099\020\032\020\018\094\078\047\099\117\032\043\099\032\089\099\041\067\110\099\069\080\041\055\032\110\093\008"), 
																										Callback = function(action)
																											if action ~= nil then
																												obj2TheeNightHuntersStage1.Active = true
																												obj2TheeNightHuntersStage1.Visible = true
																												obj1WizardTrad.Active = false
																												obj1WizardTrad.Visible = false
																											end
																										end
																									}
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj2TheeNightHuntersStage1:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\125\080\013\110\080\099\033\110\094\032\078\099\032\078\117\099\087\080\032\089\018\080\110\099\032\078\117\099\041\067\110\099\020\032\020\018\094\078\047\099\078\032\068\080\099\094\045\099\012\018\080\080\119\094\047\018\089\018\067\078\089\080\110\045\005\099\125\080\099\096\080\110\080\099\066\041\110\068\080\110\114\043\099\119\094\047\018\089\018\067\078\089\080\110\051\073\005\099\125\080\099\018\032\058\080\099\018\094\117\117\080\078\099\032\099\066\067\078\099\068\067\114\089\094\050\114\080\099\045\089\032\047\080\099\020\032\020\018\080\099\018\080\110\080\099\066\041\110\099\043\041\067\005\099"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\125\080\099\096\080\110\080\099\096\094\089\018\099\066\110\094\080\078\117\045\099\041\078\099\087\032\114\114\041\096\080\080\078\099\079\017\120\017\021\099\089\110\043\094\078\047\099\089\041\099\066\094\047\067\110\080\099\041\067\089\099\096\018\032\089\099\068\094\045\020\018\094\080\066\099\089\041\099\047\080\089\099\094\078\089\041\005\099\121\067\110\099\066\110\094\080\078\117\099\018\032\117\099\018\080\032\110\117\099\032\052\041\067\089\099\069\080\041\020\032\020\018\094\078\047\099\045\041\099\096\080\099\117\080\020\094\117\080\117\099\089\041\099\020\018\080\020\093\099\094\089\099\041\067\089"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\060\094\078\020\080\099\094\089\099\096\032\045\099\032\089\099\078\094\047\018\089\099\032\078\117\099\087\032\114\114\041\096\080\080\078\021\099\096\080\099\089\018\041\067\047\018\089\099\094\089\099\096\032\045\099\066\094\089\089\094\078\047\099\089\041\099\094\078\020\114\067\117\080\099\078\094\047\018\089\018\067\078\089\080\110\045\099\094\078\099\041\067\110\099\078\032\068\080\099\032\078\117\099\094\089\099\045\089\067\020\093"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\125\080\099\089\110\043\099\089\041\099\018\032\058\080\099\041\067\110\099\050\067\050\045\099\096\094\089\018\099\067\045\099\096\018\080\078\099\096\080\099\020\032\078\099\032\078\117\099\096\080\013\110\080\099\032\114\096\032\043\045\099\114\041\041\093\094\078\047\099\066\041\110\099\032\099\078\080\096\099\032\117\058\080\078\089\067\110\080\005"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\118\099\114\094\089\089\114\080\099\052\094\110\117\094\080\099\089\041\114\117\099\068\080\099\043\041\067\099\018\032\058\080\099\066\041\067\078\117\099\089\018\094\045\099\045\089\032\047\080\099\032\114\110\080\032\117\043\099\045\041\099\041\066\066\099\089\041\099\045\089\032\047\080\099\089\096\041\099\043\041\067\099\047\041\005")
													}
													obj3TheeNightHuntersStage2.Active = true
													obj3TheeNightHuntersStage2.Visible = true
													obj2TheeNightHuntersStage1.Active = false
													obj2TheeNightHuntersStage1.Visible = false
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj10ArubaXpress1:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\087\094\099\096\080\099\032\110\080\099\069\080\110\110\043\099\032\078\117\099\054\080\078\094\045\099\032\078\117\099\096\080\099\047\041\099\052\043\099\089\018\080\099\020\032\020\018\094\078\047\099\078\032\068\080\099\041\066\099\118\110\067\052\032\009\050\110\080\045\045\008"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\054\067\110\094\078\047\099\041\067\110\099\066\094\110\045\089\099\066\094\078\117\099\096\080\099\096\080\110\080\099\096\094\089\018\099\069\110\080\043\058\094\078\099\032\089\099\032\099\061\110\032\020\093\080\110\099\033\032\110\110\080\114\099\110\080\045\089\032\067\110\032\078\089\005\099\121\078\080\099\041\066\099\041\067\110\099\047\110\032\078\117\045\041\078\045\099\096\032\045\099\110\080\032\117\094\078\047\099\089\018\080\099\045\094\047\078\045\099\041\078\099\089\018\080\099\096\032\114\114\099\089\110\043\094\078\047\099\089\041\099\018\080\114\050\099\067\045\099\089\041\099\020\041\068\080\099\067\050\099\096\094\089\018\099\032\099\020\032\020\018\094\078\047\099\078\032\068\080\005\099\087\080\099\045\032\096\099\089\018\080\099\096\041\110\117\099\013\063\084\050\110\080\045\045\013\099\041\078\099\032\099\045\094\047\078\099\032\078\117\099\045\094\078\020\080\099\118\110\067\052\032\099\094\045\099\041\067\110\099\066\032\058\041\110\094\089\080\099\058\032\020\032\089\094\041\078\099\045\050\041\089\021\099\096\080\099\020\041\068\052\094\078\080\117\099\089\018\080\099\089\096\041\099\089\041\099\052\080\020\041\068\080\099\118\110\067\052\032\009\050\110\080\045\045\005"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\125\080\099\018\032\058\080\099\032\099\052\094\047\099\020\032\020\018\094\078\047\099\066\032\068\094\114\043\099\089\018\032\089\099\094\078\020\114\067\117\080\045\099\041\067\110\099\020\018\094\114\117\110\080\078\099\069\110\080\043\058\094\078\099\023\080\066\032\114\032\066\099\032\078\117\099\061\032\089\078\032\117\032\068"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\125\080\099\045\089\032\110\089\080\117\099\020\032\020\018\094\078\047\099\041\078\099\119\041\058\080\068\052\080\110\099\079\073\099\079\017\017\073\005"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\121\067\110\099\066\032\058\041\110\094\089\080\099\066\094\078\117\099\094\045\099\089\018\080\099\063\032\047\114\080\099\055\041\094\078\089\099\060\020\018\041\041\114\099\087\041\067\045\080\099\020\032\020\018\080\099\032\078\117\099\094\089\045\099\069\061\099\078\067\068\052\080\110\099\094\045\099\069\061\055\092\119\069\099"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _sDDfW("\121\067\110\099\066\032\058\041\110\094\089\080\099\018\094\117\080\099\094\045\099\055\032\084\094\078\041\045\032\099\012\110\032\058\080\114\099\033\067\047\099\087\041\089\080\114\099\069\061\079\061\125\090\003"), 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _sDDfW("\125\080\099\018\041\050\080\099\043\041\067\099\018\032\117\099\066\067\078\099\066\094\078\117\094\078\047\099\089\018\094\045\099\020\032\020\018\080\099\032\078\117\099\096\080\099\096\094\114\114\099\089\032\114\093\099\089\041\099\043\041\067\099\032\047\032\094\078\099\114\032\089\080\110\005")
																			}
																		end
																	end
																}
																obj11GreyvinBusy.Active = true
																obj11GreyvinBusy.Visible = true
																obj10ArubaXpress1.Active = false
																obj10ArubaXpress1.Visible = false
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj7Agility3dPuzzleS1:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\087\094\099\116\099\032\068\099\054\032\110\110\043\114\099\032\078\117\099\116\099\067\045\080\099\089\018\080\099\020\032\020\018\094\078\047\099\078\032\068\080\099\041\066\099\032\047\094\114\094\089\043\048\117\005"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\123\043\099\020\032\020\018\094\078\047\099\078\032\068\080\099\020\041\068\080\045\099\066\110\041\068\099\068\043\099\117\041\047\099\052\067\045\094\078\080\045\045\099\078\032\068\080\099\096\018\094\020\018\099\094\045\099\048\054\099\054\041\047\099\012\110\032\094\078\094\078\047\099\032\078\117\099\041\067\110\099\066\032\058\041\110\089\094\080\099\032\020\089\094\058\094\089\043\099\096\018\094\020\018\099\094\045\099\117\041\047\099\032\047\094\114\094\089\043\005"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\116\099\066\041\067\078\117\099\089\018\080\099\047\080\041\020\032\020\018\094\078\047\099\045\094\089\080\099\094\078\099\079\017\017\090\099\052\067\089\099\117\094\117\099\078\041\089\099\018\032\058\080\099\032\099\047\050\045\099\089\041\099\067\045\080\099\045\041\099\116\099\066\041\110\047\041\089\099\032\052\041\067\089\099\094\089\099\067\078\089\094\114\099\116\099\117\094\045\020\041\058\080\110\080\117\099\089\018\080\099\116\050\018\041\078\080\099\032\050\050\099\094\078\099\028\067\114\043\099\079\017\017\073\099\032\078\117\099\116\099\018\032\058\080\099\052\080\080\078\099\032\117\117\094\020\089\080\117\099\045\094\078\020\080\005"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\123\043\099\066\032\058\041\110\094\089\080\099\020\032\020\018\080\099\066\094\078\117\099\096\041\067\114\117\099\052\080\099\089\018\080\099\123\094\045\045\094\041\078\099\073\070\099\012\067\078\078\080\114\099\041\066\099\023\094\047\018\089\099\069\061\120\120\029\073\099\118\050\080\099\020\032\020\018\080\005\099\119\041\089\099\041\078\114\043\099\052\080\020\032\067\045\080\099\094\089\099\096\032\045\099\032\099\018\094\045\089\041\110\094\020\099\020\032\020\018\080\099\052\067\089\099\052\080\020\032\067\045\080\099\041\066\099\089\018\080\099\096\041\078\117\080\110\066\067\114\099\018\094\093\080\099\089\041\099\047\080\089\099\089\018\080\110\080\005\099\116\099\047\041\089\099\089\041\099\066\094\078\117\099\089\018\080\099\121\110\047\094\078\032\114\099\020\032\020\018\080\099\032\078\117\099\089\018\080\099\023\094\114\114\043\099\055\032\117\099\032\045\099\096\080\114\114\005\099"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\123\043\099\066\032\058\041\110\094\089\080\099\018\094\117\080\099\096\041\067\114\117\099\052\080\099\032\099\089\041\045\045\099\067\050\099\052\080\089\096\080\080\078\099\068\043\099\087\041\050\080\099\061\080\068\080\089\080\110\043\099\125\018\080\110\094\047\041\099\012\041\067\110\099\069\061\048\077\118\017\095\099\032\078\117\099\012\018\032\078\093\045\047\094\058\094\078\047\099\060\050\080\020\094\032\114\045\099\088\048\099\125\018\080\110\080\099\117\094\117\099\089\018\032\089\099\012\067\110\093\080\043\099\047\041\011\099\069\061\079\120\063\109\027\005\099\030\033\095\014\030\033\095\014"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _sDDfW("\012\018\080\099\087\041\050\080\099\061\080\068\080\089\032\110\043\099\125\018\080\094\110\047\041\099\089\032\067\047\018\089\099\068\080\099\045\041\099\068\067\020\018\099\032\052\041\067\089\099\117\080\045\094\047\078\094\078\047\099\032\099\096\018\080\110\094\047\041\099\032\078\117\099\002\067\045\089\099\096\018\032\089\099\043\041\067\099\020\032\078\099\117\041\099\096\094\089\018\099\089\018\080\099\047\032\068\080\005\099\012\067\110\093\080\043\099\088\048\099\096\032\045\099\045\041\099\068\067\020\018\099\066\067\078\099\110\080\032\117\094\078\047\099\032\114\114\099\089\018\080\099\080\032\110\114\043\099\114\041\047\045\099\032\045\099\020\032\020\018\080\110\045\099\045\080\032\110\020\018\099\080\058\080\110\043\096\018\080\110\080\099\066\041\110\099\094\089\005"), 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _sDDfW("\060\041\099\094\066\099\043\041\067\099\018\032\058\080\099\066\094\078\032\114\114\043\099\066\094\047\067\110\080\117\099\041\067\089\099\089\018\094\045\099\045\089\032\047\080\099\041\066\099\089\018\094\045\099\020\032\020\018\080\099\096\080\099\096\094\114\114\099\068\041\058\080\099\041\078\099\067\050\099\089\018\080\099\089\110\094\032\114\005\099\116\099\050\110\041\068\094\045\080\099\078\041\099\068\041\110\080\099\089\110\094\020\093\045\099\041\078\099\089\018\094\045\099\041\078\080\005")
																			}
																		end
																	end
																}
																obj8Agility3dPuzzleS2.Active = true
																obj8Agility3dPuzzleS2.Visible = true
																obj7Agility3dPuzzleS1.Active = false
																obj7Agility3dPuzzleS1.Visible = false
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj11GreyvinBusy:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\087\080\043\099\089\018\094\045\099\094\045\099\069\110\080\043\058\094\078\099\032\047\032\094\078\005\099\125\080\099\117\094\117\099\032\099\114\041\089\099\041\066\099\096\041\110\093\099\041\078\099\089\018\094\045\099\094\045\114\032\078\117\005"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\092\041\067\099\018\032\058\080\099\110\080\032\020\018\080\117\099\089\018\080\099\121\078\080\099\033\067\045\043\099\054\032\043\099\061\018\032\114\114\080\078\047\080\099\032\089\099\089\018\080\099\023\091\069\069\055\099\020\032\020\018\080\099\069\061\048\118\003\055\077\099\116\066\099\043\041\067\099\032\110\080\099\018\080\110\080\099\041\078\099\041\067\110\099\047\110\032\078\117\099\041\050\080\078\094\078\047\099\117\032\043\099\032\078\117\099\032\089\089\080\078\117\080\117\099\089\018\080\099\080\058\080\078\089\099\043\041\067\099\032\114\110\080\032\117\043\099\018\032\058\080\099\089\018\080\099\110\080\108\067\094\110\080\117\099\020\032\020\018\080\099\089\043\050\080\045\099\089\041\117\032\043\099\032\078\117\099\089\018\094\045\099\096\018\080\110\094\047\041\099\096\094\114\114\099\052\080\099\089\018\080\099\045\080\058\080\078\089\018\099\089\043\050\080\005\099\092\041\067\099\020\032\078\099\047\041\099\032\018\080\032\117\099\032\078\117\099\114\041\047\099\089\018\094\045\099\020\032\020\018\080\021\099\094\066\099\078\041\089\099\043\041\067\099\020\032\078\099\045\094\047\078\099\094\089\099\078\041\096\099\032\078\117\099\114\041\047\099\094\089\099\041\078\020\080\099\043\041\067\099\018\032\058\080\099\020\041\068\050\114\080\089\080\117\099\089\018\080\099\047\032\068\080\005"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\116\066\099\066\041\110\099\045\041\068\080\099\110\080\032\045\041\078\099\032\078\043\099\041\066\099\089\018\080\045\080\099\020\032\020\018\080\045\099\096\080\110\080\099\117\094\045\032\052\114\080\117\099\096\018\094\114\080\099\043\041\067\099\096\080\110\080\099\058\094\045\094\089\094\078\047\099\089\018\080\110\080\099\032\110\080\099\045\041\068\080\099\032\117\117\094\089\094\041\078\032\114\099\020\032\020\018\080\045\099\052\041\089\018\099\041\078\099\089\018\080\099\094\045\114\032\078\117\099\032\078\117\099\078\080\032\110\052\043\099\089\018\032\089\099\045\018\041\067\114\117\099\018\080\114\050\099\043\041\067\099\066\094\078\094\045\018\099\089\018\080\099\052\067\045\043\099\117\032\043\099\110\080\108\067\094\110\080\068\080\078\089\005"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\116\066\099\043\041\067\099\018\032\058\080\099\078\041\089\099\117\041\078\080\099\089\018\080\099\078\080\032\110\052\043\099\058\094\110\089\067\032\114\045\099\043\041\067\099\068\032\043\099\096\032\078\089\099\089\041\099\117\041\099\041\078\080\099\041\066\099\089\018\080\068\099\032\045\099\096\080\114\114\099\032\045\099\045\080\058\080\110\032\114\099\052\067\045\043\099\117\032\043\099\020\032\020\018\080\045\099\110\080\108\067\094\110\080\099\043\041\067\099\089\041\099\018\032\058\080\099\066\041\067\078\117\099\080\094\047\018\089\099\089\043\050\080\045\099\094\078\099\041\078\080\099\117\032\043\005"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\121\067\110\099\109\032\058\041\110\094\089\080\099\020\032\020\018\094\078\047\099\045\089\041\110\043\099\096\041\067\114\117\099\018\032\058\080\099\089\041\099\052\080\099\062\078\052\045\050\038\116\078\089\080\110\045\089\032\089\080\099\033\041\041\089\043\099\037\069\061\009\029\118\087\059\099\018\080\110\080\099\094\045\099\096\018\032\089\099\089\018\080\099\114\041\047\099\041\067\110\099\066\110\094\080\078\117\099\123\045\117\110\067\068\068\080\110\099\050\041\045\089\080\117\099\045\032\043\045\070\099"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _sDDfW("\120\120\097\079\120\097\079\017\017\073\099\007\099\088\029\029\099\041\066\099\029\029\099\066\094\078\117\045\099\089\041\117\032\043\099\096\018\094\114\080\099\020\032\020\018\094\078\047\099\094\078\099\089\018\080\099\032\110\080\032\099\096\094\089\018\099\041\067\110\099\047\080\041\052\067\117\117\094\080\045\021\099\069\110\080\043\058\094\078\005\099\125\018\094\114\080\099\096\080\099\096\080\110\080\099\114\041\041\093\094\078\047\099\066\041\110\099\089\018\080\099\020\032\020\018\080\021\099\032\099\114\041\020\032\114\099\050\041\114\094\020\080\099\041\066\066\094\020\080\110\099\050\067\114\114\080\117\099\067\050\099\096\094\089\018\099\018\094\045\099\114\094\047\018\089\045\099\041\078\021\099\045\041\099\096\080\099\020\032\068\080\099\117\041\096\078\099\032\078\117\099\089\032\114\093\080\117\099\096\094\089\018\099\018\094\068\005\099\087\080\099\032\045\093\080\117\099\096\018\032\089\099\096\080\099\096\080\110\080\099\117\041\094\078\047\021\099\045\041\099\096\080\099\080\084\050\114\032\094\078\080\117\099\089\018\032\089\099\096\080\099\096\080\110\080\099\047\080\041\020\032\020\018\094\078\047\099\032\078\117\099\089\018\080\099\020\032\020\018\080\099\096\032\045\099\120\027\029\099\066\080\080\089\099\067\050\099\089\018\094\045\099\050\032\089\018\099\094\078\099\089\018\080\099\096\041\041\117\045\005"), 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _sDDfW("\087\080\099\045\080\080\068\080\117\099\020\067\110\094\041\067\045\021\099\032\078\117\099\116\099\032\045\093\080\117\099\094\066\099\018\080\099\096\041\067\114\117\099\114\094\093\080\099\089\041\099\047\110\032\052\099\018\094\045\099\066\114\032\045\018\114\094\047\018\089\099\032\078\117\099\002\041\094\078\099\067\045\099\094\078\099\066\094\078\117\094\078\047\099\089\018\080\099\020\032\020\018\080\021\099\032\078\117\099\018\080\099\117\094\117\005\099\125\018\094\114\080\099\089\018\080\099\089\018\110\080\080\099\041\066\099\067\045\099\096\080\110\080\099\114\041\041\093\094\078\047\099\066\041\110\099\089\018\080\099\020\032\020\018\080\021\099\032\099\045\089\032\089\080\099\089\110\041\041\050\080\110\099\050\067\114\114\080\117\099\067\050\099\032\078\117\099\002\041\094\078\080\117\099\067\045\099\066\041\110\099\089\018\080\099\018\067\078\089\005"), 
																				Callback = function(action)
																					if action ~= nil then
																						_Urwigo.MessageBox{
																							Text = _sDDfW("\125\080\099\068\032\117\080\099\089\018\080\099\066\094\078\117\099\108\067\094\020\093\114\043\099\096\094\089\018\099\089\018\080\099\018\080\114\050\099\041\066\099\089\018\080\094\110\099\050\041\096\080\110\066\067\114\099\066\114\032\045\018\114\094\047\018\089\045\005\099\125\080\099\096\080\110\080\099\032\052\114\080\099\089\041\099\045\018\041\096\099\089\018\080\099\041\066\066\094\020\080\110\045\099\096\018\032\089\099\089\018\080\099\020\032\020\018\080\099\096\032\045\021\099\032\078\117\099\094\089\099\018\032\117\099\032\099\018\067\047\080\099\047\080\041\020\032\020\018\094\078\047\099\045\089\094\020\093\080\110\099\041\078\099\089\018\080\099\045\094\117\080\021\099\096\018\094\020\018\099\096\032\045\099\058\080\110\043\099\020\041\041\114\005\099"), 
																							Callback = function(action)
																								if action ~= nil then
																									_Urwigo.MessageBox{
																										Text = _sDDfW("\118\078\043\096\032\043\021\099\096\080\099\045\094\047\078\080\117\099\089\018\080\099\114\041\047\021\099\096\032\114\093\080\117\099\052\032\020\093\099\089\041\099\041\067\110\099\020\032\110\045\021\099\032\078\117\099\096\080\099\045\018\041\041\093\099\089\018\080\099\041\066\066\094\020\080\110\045\099\018\032\078\117\045\099\032\078\117\099\018\080\032\117\080\117\099\018\041\068\080\099\066\041\110\099\089\018\080\099\117\032\043\005\099\012\018\094\045\099\096\032\045\099\032\099\058\080\110\043\099\020\041\041\114\099\096\032\043\099\089\041\099\080\078\117\099\089\018\080\099\114\041\078\047\099\117\032\043\099\041\066\099\020\032\020\018\094\078\047\099\094\078\099\089\018\080\099\032\110\080\032\099\089\041\117\032\043\005\099\033\041\089\018\099\041\066\066\094\020\080\110\045\099\096\080\110\080\099\047\041\094\078\047\099\089\041\099\114\041\041\093\099\067\050\099\047\080\041\020\032\020\018\094\078\047\099\032\078\117\099\050\041\045\045\094\052\114\043\099\020\018\080\020\093\099\094\089\099\041\067\089\005\099\116\013\068\099\045\067\110\080\099\096\080\099\068\032\117\080\099\089\018\080\094\110\099\078\094\047\018\089\005\005\005\099"), 
																										Callback = function(action)
																											if action ~= nil then
																												_Urwigo.MessageBox{
																													Text = _sDDfW("\125\080\099\032\110\080\099\032\114\045\041\099\050\041\110\067\117\099\089\041\099\018\032\058\080\099\117\041\078\080\099\032\099\020\041\067\050\114\080\099\041\066\099\027\097\027\099\020\032\020\018\080\045\099\096\094\089\018\099\110\041\050\080\045\099\094\078\020\114\067\117\094\078\047\099\032\099\020\032\058\080\099\094\078\099\125\080\045\089\099\091\094\110\047\094\078\094\032\005\099\125\080\013\058\080\099\020\032\020\018\080\117\099\089\018\080\099\080\078\089\094\110\080\099\063\005\012\005\099\087\094\047\018\096\032\043\099\032\078\117\099\089\018\080\078\099\045\041\068\080\099\094\078\099\119\080\058\032\117\032\099\094\078\099\121\020\089\041\052\080\110\099\079\017\120\017\099\096\018\094\020\018\099\096\032\045\099\120\017\079\120\019\099\020\032\020\018\080\045\099\096\094\089\018\094\078\099\079\099\117\032\043\045\099\032\078\117\099\047\041\089\099\032\099\050\080\110\045\041\078\032\114\099\110\080\020\041\110\117\099\041\066\099\090\120\017\099\020\032\020\018\080\045\099\094\078\099\120\099\117\032\043\005"), 
																													Callback = function(action)
																														if action ~= nil then
																															_Urwigo.MessageBox{
																																Text = _sDDfW("\125\080\099\089\018\032\078\093\099\043\041\067\099\066\041\110\099\058\094\045\094\089\094\078\047\099\041\067\110\099\020\032\020\018\080\045\099\018\080\110\080\099\032\078\117\099\020\041\078\047\110\032\089\067\114\032\089\080\099\043\041\067\099\041\078\099\066\094\078\094\045\018\094\078\047\099\089\018\080\099\052\067\045\043\099\117\032\043\099\020\018\032\114\114\080\078\047\080\099\089\041\117\032\043\005")
																															}
																														end
																													end
																												}
																											end
																										end
																									}
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
																obj12ArubaXpress2.Active = true
																obj12ArubaXpress2.Visible = true
																obj11GreyvinBusy.Active = false
																obj11GreyvinBusy.Visible = false
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj12ArubaXpress2:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\087\094\099\089\018\094\045\099\094\045\099\118\110\067\052\032\009\050\110\080\045\045\099\032\047\032\094\078\099\032\078\117\099\043\041\067\099\018\032\058\080\099\032\110\110\094\058\080\117\099\032\089\099\089\018\080\099\069\039\099\066\041\110\099\041\067\110\099\045\080\020\041\078\117\099\020\032\020\018\080\099\032\089\099\089\018\080\099\069\080\041\050\032\110\093\005"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\069\080\041\020\032\020\018\094\078\047\099\018\032\045\099\110\080\032\114\114\043\099\052\110\041\067\047\018\089\099\041\067\110\099\066\032\068\094\114\043\099\089\041\047\080\089\018\080\110\005\099\116\089\099\018\032\045\099\052\080\020\041\068\080\099\032\099\066\067\078\099\032\020\089\094\058\094\089\043\099\089\018\032\089\099\096\080\099\018\032\058\080\099\052\080\080\078\099\045\018\032\110\094\078\047\099\096\094\089\018\099\041\067\110\099\020\018\094\114\117\110\080\078\099\032\078\117\099\041\067\110\099\066\041\067\110\099\047\110\032\078\117\020\018\094\114\117\110\080\078\005\099"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\069\080\041\020\032\020\018\094\078\047\099\018\032\045\099\032\114\045\041\099\052\110\041\067\047\018\089\099\067\045\099\089\041\099\045\041\068\080\099\032\068\032\083\094\078\047\099\114\041\020\032\089\094\041\078\045\099\089\018\032\089\099\096\080\099\050\110\041\052\032\052\114\043\099\096\041\067\114\117\099\078\080\058\080\110\099\018\032\058\080\099\117\094\045\020\041\058\080\110\080\117\005\099\125\080\013\058\080\099\080\058\080\078\099\020\032\020\018\080\117\099\094\078\099\041\067\110\099\066\032\058\041\110\094\089\080\021\099\118\110\067\052\032\021\099\096\018\080\110\080\099\096\080\099\066\041\067\078\117\099\120\051\099\041\066\099\089\018\080\099\079\048\099\020\032\020\018\080\045\099\041\078\099\089\018\080\099\094\045\114\032\078\117\005"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\121\067\110\099\047\110\080\032\089\080\045\089\099\047\080\041\020\032\020\018\094\078\047\099\032\020\020\041\068\050\114\094\045\018\068\080\078\089\099\094\045\099\041\067\110\099\048\029\029\099\117\032\043\099\020\032\020\018\094\078\047\099\045\089\110\080\032\093\005\099"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\121\067\110\099\066\032\058\041\110\094\089\080\099\020\032\020\018\094\078\047\099\045\089\041\110\043\099\096\041\067\114\117\099\052\080\099\062\078\052\045\050\038\060\020\041\041\052\043\070\099\120\017\021\017\017\017\099\091\041\114\089\099\069\018\041\045\089\099\061\069\079\077\055\012\048\099"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _sDDfW("\118\045\099\089\110\067\080\099\020\032\020\018\094\078\047\099\032\117\117\094\020\089\045\021\099\041\078\099\032\099\020\041\114\117\099\123\032\110\020\018\099\117\032\043\021\099\061\032\089\078\032\117\032\068\099\002\041\094\078\080\117\099\118\110\067\052\032\009\050\110\080\045\045\099\094\078\099\032\099\089\110\080\093\099\089\018\110\041\067\047\018\099\089\018\080\099\096\041\041\117\045\021\099\052\067\045\018\096\032\020\093\094\078\047\021\099\114\041\089\045\099\041\066\099\089\018\041\110\078\045\021\099\068\067\117\099\032\078\117\099\045\078\041\096\099\089\041\099\066\094\078\117\099\089\018\094\045\099\060\020\041\041\052\043\099\020\032\020\018\080\005"), 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _sDDfW("\054\080\089\080\110\068\094\078\080\117\099\089\041\099\068\032\093\080\099\089\018\080\099\066\094\078\117\021\099\096\080\099\045\050\080\078\089\099\032\114\068\041\045\089\099\032\078\099\018\041\067\110\021\099\117\110\080\045\045\080\117\099\067\050\099\066\110\041\068\099\032\089\089\080\078\117\094\078\047\099\032\099\052\110\094\117\032\114\099\045\018\041\096\080\110\099\080\032\110\114\094\080\110\099\089\018\032\089\099\117\032\043\021\099\045\080\032\110\020\018\094\078\047\099\089\018\080\099\096\041\041\117\045\005\099\063\084\020\094\089\080\117\099\032\052\041\067\089\099\041\067\110\099\066\094\078\117\021\099\096\080\099\110\080\032\114\094\083\080\117\099\089\018\032\089\099\096\080\099\020\041\067\114\117\099\066\094\078\117\099\089\018\080\099\050\032\089\018\099\052\032\020\093\005\099"), 
																				Callback = function(action)
																					if action ~= nil then
																						_Urwigo.MessageBox{
																							Text = _sDDfW("\118\066\089\080\110\099\068\067\020\018\099\089\110\080\093\093\094\078\047\021\099\096\080\099\066\094\078\032\114\114\043\099\066\041\067\078\117\099\032\099\050\032\058\080\117\099\110\041\032\117\021\099\032\078\117\099\096\032\114\093\080\117\099\052\032\020\093\099\089\041\099\089\018\080\099\020\032\110\005\099\125\032\045\099\094\089\099\096\041\110\089\018\011\099\092\041\067\099\052\080\089\099\094\089\099\096\032\045\008"), 
																							Callback = function(action)
																								if action ~= nil then
																									_Urwigo.MessageBox{
																										Text = _sDDfW("\087\067\110\110\043\099\067\050\099\032\078\117\099\045\094\047\078\099\041\067\110\099\114\041\047\099\032\078\117\099\068\041\058\080\099\041\078\099\089\041\099\123\032\117\018\032\067\114\080\110\045\099\020\032\020\018\080\005\099\012\018\094\045\099\069\080\041\055\032\110\093\099\096\032\045\099\018\094\045\099\094\117\080\032\099\032\078\117\099\096\080\099\096\080\110\080\099\045\041\099\018\032\050\050\043\099\089\041\099\018\080\114\050\099\018\094\068\099\068\032\093\080\099\094\089\099\018\032\050\050\080\078\005")
																									}
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
																obj13MadhaulerTrad.Active = true
																obj13MadhaulerTrad.Visible = true
																obj12ArubaXpress2.Active = false
																obj12ArubaXpress2.Visible = false
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj8Agility3dPuzzleS2:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\121\093\099\043\041\067\099\018\032\058\080\099\078\041\096\099\110\080\032\020\018\080\117\099\089\018\080\099\045\080\020\041\078\117\099\045\089\032\047\080\099\041\066\099\089\018\094\045\099\020\032\020\018\080\005\099\060\094\078\020\080\099\043\041\067\099\066\041\067\078\117\099\045\089\032\047\080\099\041\078\080\099\089\018\094\045\099\045\018\041\067\114\117\099\052\080\099\058\080\110\043\099\080\032\045\043\005\099"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\116\099\032\068\099\032\099\117\041\047\099\032\047\094\114\094\089\043\099\002\067\117\047\080\099\032\078\117\099\089\110\032\058\080\114\099\068\041\045\089\099\096\080\080\093\080\078\117\045\005\099\116\089\099\018\032\045\099\047\094\058\080\078\099\068\080\099\032\099\020\018\032\078\020\080\099\089\041\099\020\032\020\018\080\099\094\078\099\114\041\089\045\099\041\066\099\078\080\096\099\050\114\032\020\080\045\005"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\116\099\018\032\058\080\099\078\041\096\099\020\032\020\018\080\117\099\094\078\099\077\017\099\045\089\032\089\080\045\099\094\078\020\114\067\117\094\078\047\099\118\114\032\045\093\032\005\099\012\018\094\045\099\043\080\032\110\099\116\099\096\094\114\114\099\052\080\099\047\041\094\078\047\099\089\041\099\045\080\058\080\110\032\114\099\068\041\110\080\099\045\089\032\089\080\045\005"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\116\099\068\032\043\099\080\058\080\078\099\018\032\058\080\099\089\041\099\067\045\080\099\045\041\068\080\099\032\094\110\114\094\078\080\099\068\094\114\080\045\099\089\041\099\052\041\041\093\099\032\099\108\067\094\020\093\099\020\032\020\018\094\078\047\099\089\110\094\050\099\089\041\099\087\032\096\032\094\094\099\094\066\099\116\099\117\041\099\078\041\089\099\047\080\089\099\114\067\020\093\043\099\080\078\041\067\047\018\099\089\041\099\047\080\089\099\032\078\099\002\067\117\047\094\078\047\099\032\045\045\094\047\078\068\080\078\089\099\089\018\080\110\080\099\045\041\041\078\005\030\033\095\014"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\116\099\110\080\032\114\114\043\099\080\078\002\041\043\099\068\032\093\094\078\047\099\089\018\080\045\080\099\096\018\080\110\094\047\041\045\005\099\116\099\045\080\080\099\089\018\080\068\099\032\045\099\018\032\058\094\078\047\099\047\110\080\032\089\099\050\041\089\080\078\089\094\032\114\005\099\012\018\080\043\099\020\041\067\114\117\099\052\080\099\067\045\080\099\089\041\099\052\110\094\078\047\099\020\032\020\018\080\110\045\099\089\041\099\032\078\043\099\050\114\032\020\080\099\089\018\032\089\099\043\041\067\099\068\032\043\099\018\032\058\080\099\096\032\078\089\080\117\099\089\041\099\050\114\032\020\080\099\032\099\058\094\110\089\067\032\114\099\052\080\066\041\110"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _sDDfW("\125\080\114\114\099\052\043\099\078\041\096\099\043\041\067\099\018\032\058\080\099\047\041\089\089\080\078\099\089\018\080\099\094\078\066\041\110\068\032\089\094\041\078\099\043\041\067\099\078\080\080\117\099\066\041\110\068\099\018\080\110\080\099\045\041\099\068\041\058\080\099\032\114\041\078\047\099\089\041\099\089\018\080\099\066\094\078\032\114\099\045\089\032\047\080\099\041\066\099\089\018\094\045\099\020\032\020\018\080\005")
																}
																obj9Agility3dPuzzleS3.Active = true
																obj9Agility3dPuzzleS3.Visible = true
																obj8Agility3dPuzzleS2.Active = false
																obj8Agility3dPuzzleS2.Visible = false
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj9Agility3dPuzzleS3:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\125\080\114\020\041\068\080\099\089\041\099\089\018\080\099\066\094\078\032\114\099\045\089\032\047\080\099\041\066\099\068\043\099\020\032\020\018\080\005"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\116\099\117\041\099\068\041\045\089\099\041\066\099\068\043\099\020\032\020\018\094\078\047\099\096\018\080\078\099\116\099\032\068\099\041\067\089\099\041\066\099\089\041\096\078\099\045\041\099\116\099\018\032\058\080\099\068\041\110\080\099\066\094\078\117\045\099\041\067\089\045\094\117\080\099\041\066\099\055\032\099\089\018\080\078\099\116\099\117\041\099\094\078\099\041\067\110\099\045\089\032\089\080\005\099\116\099\032\114\045\041\099\117\041\099\068\041\045\089\099\041\066\099\068\043\099\020\032\020\018\094\078\047\099\032\114\041\078\080\005"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\061\032\020\018\094\078\047\099\032\114\041\078\080\099\068\080\032\078\045\099\089\018\032\089\099\116\099\117\041\099\078\041\089\099\047\080\089\099\089\041\099\047\041\099\032\066\089\080\110\099\045\041\099\041\066\099\089\018\080\099\080\084\089\110\080\068\080\099\020\032\020\018\080\045\099\041\067\089\099\089\018\080\110\080\005\099\116\099\032\114\045\041\099\110\080\032\114\114\043\099\080\078\002\041\043\099\020\032\020\018\094\078\047\099\096\094\089\018\099\068\043\099\050\067\050\045\099\096\018\080\078\099\116\099\032\068\099\018\041\068\080\005\099"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\123\043\099\054\094\045\020\041\099\117\041\047\099\110\080\032\114\114\043\099\080\078\002\041\043\045\099\018\094\093\094\078\047\099\089\018\080\099\089\110\032\094\114\045\099\032\078\117\099\018\067\078\089\094\078\047\099\066\041\110\099\020\032\020\018\080\045\005\099\087\080\099\110\080\032\114\114\043\099\114\094\093\080\045\099\094\066\099\096\018\080\078\099\018\094\045\099\020\032\078\094\078\080\099\047\080\041\066\110\094\080\078\117\045\099\047\080\089\099\089\041\099\002\041\094\078\099\067\045\099\041\078\099\089\018\080\099\018\067\078\089\005"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\123\043\099\068\041\045\089\099\094\078\089\080\110\080\045\089\094\078\047\099\047\080\041\099\045\089\041\110\043\099\096\041\067\114\117\099\052\080\099\041\078\080\099\041\067\089\099\041\066\099\109\114\041\110\094\117\032\005\099\116\099\096\032\045\099\094\078\099\089\018\080\099\012\032\068\050\032\099\032\110\080\032\099\002\067\117\047\094\078\047\099\032\078\099\032\047\094\114\094\089\043\099\089\110\094\032\114\099\089\018\080\110\080\005\099\118\066\089\080\110\099\066\094\078\094\045\018\094\078\047\099\096\041\110\093\099\066\041\110\099\089\018\080\099\117\032\043\099\116\099\117\080\020\094\117\080\117\099\089\041\099\047\041\099\020\032\020\018\094\078\047\099\089\018\080\099\089\110\032\094\114\099\089\018\032\089\099\116\099\018\032\117\099\020\018\041\045\080\078\099\096\032\045\099\020\032\114\114\080\117\099\023\032\093\080\099\023\041\041\050\099\089\110\032\094\114\005\099\030\033\095\014"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _sDDfW("\116\099\117\094\117\099\078\041\089\099\018\032\058\080\099\089\018\080\099\114\041\020\032\114\099\068\032\050\045\099\114\041\032\117\080\117\099\041\078\099\068\043\099\069\032\110\068\094\078\099\052\067\089\099\020\041\067\114\117\099\045\080\080\099\089\018\080\110\080\099\096\032\045\099\032\099\078\094\020\080\099\089\110\032\094\114\099\041\066\099\020\032\020\018\094\078\047\099\032\110\041\067\078\117\099\089\018\094\045\099\114\032\093\080\005\099\062\078\052\045\050\038\060\041\099\089\041\099\068\032\093\080\099\094\089\099\045\018\041\110\089\099\032\114\114\099\068\043\099\080\114\080\020\089\110\041\078\094\020\045\099\117\094\080\117\099\094\078\020\114\067\117\094\078\047\099\068\043\099\050\018\041\078\080\021\099\047\032\110\068\094\078\099\032\078\117\099\066\114\032\045\018\114\094\047\018\089\021\099\094\089\099\047\041\089\099\117\032\110\093\099\032\078\117\099\089\018\080\099\089\110\094\032\114\099\094\078\099\089\018\080\099\045\096\032\068\050\099\117\094\117\099\078\041\089\099\047\041\099\032\110\041\067\078\117\099\089\018\080\099\114\032\093\080\005\099"), 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _sDDfW("\116\099\047\041\089\099\058\080\110\043\099\114\041\045\089\021\099\093\078\080\080\099\117\080\080\050\099\094\078\099\032\099\045\096\032\068\050\021\099\020\041\114\117\021\099\096\080\089\099\032\078\117\099\089\094\110\080\117\099\116\099\080\078\117\080\117\099\067\050\099\041\078\099\089\018\080\099\096\110\041\078\047\099\045\094\117\080\099\041\066\099\089\018\080\099\114\032\093\080\099\096\018\080\078\099\116\099\066\094\078\032\114\114\043\099\066\041\067\078\117\099\032\099\110\041\032\117\099\114\080\032\117\094\078\047\099\089\041\099\032\099\114\041\078\047\099\018\094\093\080\099\067\078\089\094\114\099\032\099\114\041\020\032\114\099\018\032\117\099\050\094\089\043\099\041\078\099\068\080\099\032\078\117\099\047\032\058\080\099\068\080\099\032\099\110\094\117\080\099\089\018\080\099\114\032\045\089\099\020\041\067\050\114\080\099\068\094\114\080\045\099\052\032\020\093\099\089\041\099\068\043\099\110\080\078\089\032\114\099\020\032\110\099\096\018\094\020\018\099\116\099\096\041\067\114\117\099\018\032\058\080\099\078\080\058\080\110\099\066\041\067\078\117\099\045\094\078\020\080\099\116\099\096\032\045\099\047\041\094\078\047\099\089\018\080\099\096\110\041\078\047\099\096\032\043\005\099\060\067\110\050\110\094\045\080\117\099\089\018\080\043\099\114\080\089\099\068\080\099\094\078\099\089\018\080\094\110\099\020\032\110\005\099"), 
																				Callback = function(action)
																					if action ~= nil then
																						_Urwigo.MessageBox{
																							Text = _sDDfW("\060\094\078\020\080\099\089\018\032\089\099\078\094\047\018\089\099\116\099\018\032\058\080\099\052\080\080\078\099\068\067\020\018\099\068\041\110\080\099\020\032\110\080\066\067\114\099\032\052\041\067\089\099\020\032\020\018\094\078\047\099\094\078\099\089\018\080\099\096\094\114\117\045\005"), 
																							Callback = function(action)
																								if action ~= nil then
																									_Urwigo.MessageBox{
																										Text = _sDDfW("\121\093\099\089\094\068\080\099\066\041\110\099\043\041\067\099\089\041\099\068\041\058\080\099\032\114\041\078\047\005\099\061\041\078\089\094\078\067\080\099\080\032\045\089\099\041\078\099\089\018\080\099\089\110\094\032\114\099\032\078\117\099\043\041\067\099\096\094\114\114\099\066\094\078\117\099\032\099\045\050\041\089\099\117\041\096\078\099\089\041\099\089\018\080\099\114\041\096\080\110\099\089\110\094\032\114\099\032\078\117\099\089\018\080\099\041\089\018\080\110\099\020\032\020\018\080\045\008")
																									}
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
																obj10ArubaXpress1.Active = true
																obj10ArubaXpress1.Visible = true
																obj9Agility3dPuzzleS3.Active = false
																obj9Agility3dPuzzleS3.Visible = false
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj3TheeNightHuntersStage2:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\125\080\099\045\080\080\099\043\041\067\099\018\032\058\080\099\068\032\117\080\099\094\089\099\089\041\099\089\018\080\099\045\080\020\041\078\117\099\045\089\032\047\080\099\041\066\099\041\067\110\099\020\032\020\018\080\005\099\125\080\099\018\041\050\080\099\043\041\067\099\032\110\080\099\018\032\058\094\078\047\099\066\067\078\005"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\121\067\110\099\066\032\058\041\110\094\089\080\099\020\032\020\018\080\099\066\094\078\117\099\094\045\099\095\116\055\099\047\041\041\117\099\066\110\094\080\078\117\008\008\008\099\116\078\099\119\092\099\052\043\099\039\094\047\047\043\099\061\110\080\096\099\069\061\120\091\029\003\048\099\094\089\099\094\045\099\032\099\068\080\068\041\110\094\032\114\099\089\041\099\032\099\066\080\114\114\041\096\099\020\032\020\018\080\110\099\032\078\117\099\032\099\018\067\047\080\099\020\041\078\089\032\094\078\080\110\005"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\121\067\110\099\066\032\058\041\110\094\089\080\099\018\094\117\080\099\094\045\099\061\041\078\089\110\032\099\069\061\048\077\012\119\051\099\096\080\099\080\078\002\041\043\099\110\080\032\117\094\078\047\099\089\018\080\099\114\041\047\045\099\032\078\117\099\045\041\068\080\089\094\068\080\045\099\020\032\089\020\018\094\078\047\099\032\099\066\080\114\114\041\096\099\020\032\020\018\080\110\099\089\110\043\094\078\047\099\089\041\099\020\041\068\050\114\080\089\080\099\089\018\080\099\066\094\078\032\114\099\045\089\032\047\080\005"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\121\067\110\099\066\032\058\041\110\094\089\080\099\089\018\094\078\047\099\032\052\041\067\089\099\020\032\020\018\094\078\047\099\094\045\099\089\018\080\099\089\018\110\094\114\114\099\041\066\099\089\018\080\099\018\067\078\089\021\099\080\084\018\094\114\032\110\032\089\094\041\078\099\041\066\099\089\018\080\099\066\094\078\117\021\099\032\078\117\099\068\080\080\089\094\078\047\099\110\080\032\114\114\043\099\047\110\080\032\089\099\050\080\041\050\114\080\099\032\114\041\078\047\099\089\018\080\099\096\032\043\005"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\092\041\067\099\045\018\041\067\114\117\099\068\032\093\080\099\108\067\094\020\093\099\096\041\110\093\099\041\066\099\089\018\094\045\099\045\089\032\047\080\099\032\078\117\099\096\080\099\096\094\114\114\099\089\080\114\114\099\043\041\067\099\041\067\110\099\066\032\058\041\110\094\089\080\099\020\032\020\018\094\078\047\099\045\089\041\110\043\099\032\089\099\089\018\080\099\066\094\078\032\114\005")
													}
													obj4TheeNightHuntersStage3.Active = true
													obj4TheeNightHuntersStage3.Visible = true
													obj3TheeNightHuntersStage2.Active = false
													obj3TheeNightHuntersStage2.Visible = false
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj4TheeNightHuntersStage3:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\099\121\067\110\099\066\032\058\041\110\094\089\080\099\020\032\020\018\094\078\047\099\032\117\058\080\078\089\067\110\080\099\096\041\067\114\117\099\018\032\058\080\099\089\041\099\052\080\099\089\018\080\099\047\110\080\032\089\099\012\033\099\110\080\045\020\067\080\099\017\120\097\079\017\120\079\008\099\125\080\099\050\094\020\093\080\117\099\067\050\099\060\012\005\109\101\099\032\078\117\099\018\080\032\117\080\117\099\067\050\099\089\041\099\089\018\080\099\061\032\089\045\093\094\114\114\045\021\099\032\052\041\058\080\099\055\041\067\047\018\080\050\045\094\080\021\099\119\092\005\099"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\125\018\043\021\099\043\041\067\099\032\045\093\011\099\012\041\099\045\032\058\080\099\032\099\020\041\067\050\114\080\099\041\066\099\012\033\045\099\089\018\032\089\099\060\012\005\109\101\099\032\078\117\099\018\094\045\099\045\041\078\099\045\080\089\099\041\066\066\099\094\078\099\032\099\110\032\020\080\005\099"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\012\018\080\043\099\096\080\110\080\099\045\067\050\050\041\045\080\117\099\089\041\099\052\080\099\018\080\032\117\094\078\047\099\045\041\067\089\018\099\089\041\099\054\094\045\078\080\043\099\125\041\110\114\117\099\052\067\089\099\045\041\068\080\099\078\094\020\080\099\047\080\078\089\114\080\068\032\078\099\050\114\032\020\080\117\099\089\018\080\068\099\094\078\099\032\099\020\032\020\018\080\099\078\041\110\089\018\099\041\066\099\018\080\110\080\008\099"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\116\089\099\096\032\045\099\032\099\048\099\018\041\067\110\099\117\110\094\058\080\099\068\067\020\018\099\114\094\093\080\099\089\018\080\099\089\018\110\080\080\099\018\041\067\110\099\089\041\067\110\099\041\078\099\069\094\114\114\094\047\032\078\045\099\116\045\114\032\078\117\008\099\116\089\099\096\032\045\099\041\078\114\043\099\050\032\110\089\094\032\114\114\043\099\045\067\020\020\080\045\045\066\067\114\099\052\080\020\032\067\045\080\099\041\078\080\099\041\066\099\089\018\080\099\012\110\032\058\080\114\099\033\067\047\045\099\096\032\045\099\047\041\078\080\005\099"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\125\018\094\114\080\099\089\018\080\110\080\021\099\096\080\099\110\080\045\020\067\080\117\099\041\089\018\080\110\099\012\033\045\099\032\078\117\099\032\110\080\099\018\080\114\050\094\078\047\099\110\080\114\041\020\032\089\080\099\089\018\080\068\005\099\125\080\099\066\041\067\078\117\099\041\067\110\099\066\032\058\041\110\094\089\080\099\020\032\020\018\080\099\041\078\099\089\018\080\099\096\032\043\099\089\018\080\110\080\021\099\068\032\094\078\114\043\099\052\080\020\032\067\045\080\099\041\066\099\089\018\080\099\020\041\078\089\032\094\078\080\110\021\099\032\078\117\099\066\110\041\083\080\099\041\067\110\099\052\067\089\089\045\099\041\066\066\008"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _sDDfW("\060\094\047\078\099\041\067\110\099\114\041\047\099\032\078\117\099\018\080\032\117\099\041\078\099\089\041\099\089\018\080\099\063\032\110\089\018\020\032\020\018\080\008")
																}
															end
														end
													}
													obj5GreyvinEarth.Active = true
													obj5GreyvinEarth.Visible = true
													obj4TheeNightHuntersStage3.Visible = false
													obj4TheeNightHuntersStage3.Active = false
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj15FINAL:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\125\080\114\020\041\068\080\099\089\041\099\089\018\080\099\066\094\078\032\114\099\045\089\032\047\080\099\041\066\099\089\018\094\045\099\096\018\080\110\094\047\041\005\099"), 
		Callback = function(action)
			if action ~= nil then
				if (_G[_sDDfW("\063\078\058")][_sDDfW("\054\080\058\094\020\080\116\054")] == _sDDfW("\054\080\045\093\089\041\050")) or (_G[_sDDfW("\063\078\058")][_sDDfW("\055\114\032\089\066\041\110\068")] == _sDDfW("\125\094\078\048\079")) then
					_Urwigo.MessageBox{
						Text = _sDDfW("\116\099\032\068\099\045\041\110\110\043\099\052\067\089\099\089\018\094\045\099\094\045\099\032\045\099\066\032\110\099\032\045\099\043\041\067\099\020\032\078\099\047\041\099\094\078\099\089\018\080\099\080\068\067\114\032\089\041\110\099\068\041\117\080\005\099\116\099\018\041\050\080\099\043\041\067\099\047\080\089\099\089\041\099\020\041\068\080\099\041\067\089\099\032\078\117\099\050\114\032\043\099\041\078\099\041\067\110\099\094\045\114\032\078\117\099\066\041\110\099\110\080\032\114\099\045\041\068\080\117\032\043\008"), 
						Callback = function(action)
							if action ~= nil then
								Wherigo.Command "SaveClose"
							end
						end
					}
				else
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objFinalZone)
					end)
				end
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj6GreyvinLetter:OnEnter()
	_Urwigo.MessageBox{
		Text = _sDDfW("\099\121\067\110\099\109\032\058\041\110\094\089\080\099\020\032\020\018\080\099\066\094\078\117\099\094\045\099\012\087\063\099\123\092\060\012\063\095\092\099\123\118\061\087\116\119\063\099\037\069\061\079\073\087\073\028\059"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\121\067\110\099\066\032\058\041\110\094\089\080\099\020\032\020\018\080\099\018\094\117\080\099\094\045\099\060\020\041\041\052\043\070\099\012\018\080\099\060\050\094\110\094\089\099\041\066\099\095\041\020\093\013\078\099\095\041\114\114\099\037\069\061\079\017\077\091\009\059"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\125\080\099\032\110\080\099\060\020\041\041\052\043\099\118\117\117\094\020\089\045\008\099"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\125\080\099\020\041\068\050\114\080\089\080\117\099\032\099\077\017\017\099\117\032\043\099\020\032\020\018\094\078\047\099\045\089\110\080\032\093\005\099"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\069\080\041\020\032\020\018\094\078\047\099\094\045\099\032\099\066\067\078\099\032\020\089\094\058\094\089\043\099\066\041\110\099\041\067\110\099\066\032\068\094\114\043\099\089\041\099\117\041\099\089\041\047\080\089\018\080\110\005\099\125\080\099\080\045\050\080\020\094\032\114\114\043\099\114\094\093\080\099\096\080\114\114\099\089\018\041\067\047\018\089\099\041\067\089\099\018\094\117\080\045\099\032\078\117\099\020\041\078\089\032\094\078\080\110\045\021\099\117\094\045\020\041\058\080\110\094\078\047\099\050\114\032\020\080\045\099\096\080\099\078\080\058\080\110\099\093\078\080\096\099\080\084\094\045\089\080\117\099\032\078\117\099\089\018\080\099\032\117\058\080\078\089\067\110\080\045\099\096\080\099\018\032\058\080\099\047\041\078\080\099\041\078\005"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _sDDfW("\121\078\020\080\099\043\041\067\099\018\032\058\080\099\020\041\068\050\114\080\089\080\117\099\089\018\094\045\099\020\032\020\018\080\099\043\041\067\099\096\094\114\114\099\052\080\099\018\080\032\117\094\078\047\099\041\066\066\099\089\041\099\089\018\080\099\050\067\083\083\114\080\099\050\114\032\020\080\117\099\052\043\099\118\047\094\114\094\089\043\048\117\005\099\116\089\099\094\045\099\032\099\050\110\080\089\089\043\099\080\032\045\043\099\050\067\083\083\114\080\099\089\041\099\045\041\114\058\080\005\099\012\018\080\099\020\032\020\018\080\099\078\067\068\052\080\110\099\094\045\099\069\061\048\033\033\091\063\099\116\089\099\094\045\099\032\114\041\078\047\099\089\018\080\099\067\050\050\080\110\099\089\110\032\094\114\099\078\080\084\089\099\089\041\099\089\018\080\099\020\032\078\032\114\005"), 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _sDDfW("\121\078\020\080\099\043\041\067\099\047\080\089\099\089\041\099\089\018\080\099\066\094\110\045\089\099\069\039\099\043\041\067\099\096\094\114\114\099\068\080\080\089\099\118\047\094\114\094\089\043\048\117\008")
																			}
																		end
																	end
																}
															end
														end
													}
													obj7Agility3dPuzzleS1.Active = true
													obj6GreyvinLetter.Active = false
													obj6GreyvinLetter.Visible = false
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function obj12GreyvinPaintPuzzle:OnEnter()
	obj12GreyvinPaintPuzzle.Visible = true
	_Urwigo.MessageBox{
		Text = _sDDfW("\087\080\043\099\096\032\094\089\099\096\018\032\089\099\094\045\099\089\018\094\045\011\099"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _sDDfW("\116\099\045\068\080\114\114\099\032\099\020\032\020\018\080\099\078\080\032\110\099\052\043\005"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _sDDfW("\061\041\078\047\110\032\089\067\114\032\089\094\041\078\045\021\099\043\041\067\013\058\080\099\066\041\067\078\117\099\094\089\008\099\116\078\089\080\078\089\094\041\078\032\114\114\043\099\041\110\099\078\041\089\008"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _sDDfW("\121\067\110\099\032\089\099\114\080\032\045\089\099\089\018\080\099\047\080\078\080\110\032\114\099\069\039\099\066\041\110\099\020\032\020\018\080\099\069\061\048\118\003\003\039\099\118\078\041\089\018\080\110\099\033\110\094\020\093\099\094\078\099\089\018\080\099\125\032\114\114\099\032\089\099\089\018\080\099\023\091\069\069\055\005"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _sDDfW("\060\041\099\018\041\050\080\066\067\114\114\043\099\043\041\067\099\080\094\089\018\080\110\099\018\032\058\080\099\041\110\099\020\032\078\099\045\041\114\058\080\099\089\018\080\099\050\067\083\083\114\080\099\032\078\117\099\066\094\078\117\099\089\018\094\045\099\080\058\094\114\099\114\094\089\089\080\099\018\094\117\080\005\099\033\067\089\099\066\094\078\117\099\094\089\099\041\067\110\099\078\041\089\099\043\041\067\099\096\094\114\114\099\078\080\080\117\099\089\041\099\020\041\078\089\094\078\067\080\099\117\041\096\078\099\089\018\080\099\089\110\032\094\114\099\089\041\099\066\094\078\094\045\018\099\067\050\099\089\018\094\045\099\047\032\068\080\005")
													}
													obj12GreyvinPaintPuzzle.Active = false
													obj12GreyvinPaintPuzzle.Visible = false
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function objFinalZone:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _sDDfW("\092\080\045")) then
		_Urwigo.MessageBox{
			Text = _sDDfW("\118\114\114\099\089\018\080\099\061\121\013\045\099\018\080\110\080\099\032\089\099\089\018\080\099\023\080\018\094\047\018\099\091\032\114\114\080\043\099\069\080\041\020\032\020\018\080\110\045\099\069\080\041\055\032\110\093\099\018\041\050\080\099\089\018\032\089\099\043\041\067\099\080\078\002\041\043\080\117\099\043\041\067\110\099\080\084\050\080\110\094\080\078\020\080\099\018\080\110\080\005\099\125\080\099\018\041\050\080\099\089\018\032\089\099\089\018\094\045\099\096\094\114\114\099\052\080\099\052\080\020\041\068\080\099\032\099\068\041\117\080\114\099\066\041\110\099\041\089\018\080\110\099\047\110\041\067\050\045\099\089\041\099\066\041\114\114\041\096\005"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _sDDfW("\069\041\041\117\099\002\041\052\021\099\089\018\032\089\099\114\080\032\058\080\045\099\043\041\067\099\002\067\045\089\099\012\018\080\099\023\080\018\094\047\018\099\061\032\078\032\114\099\032\089\099\089\018\080\099\023\091\069\069\055\099\125\018\080\110\094\047\041\099\012\041\067\110\099\069\061\048\033\118\095\119\099\089\041\099\117\041\099\066\110\041\068\099\041\067\110\099\041\110\047\094\078\032\114\099\020\032\020\018\080\045\099\018\080\110\080\005\099\033\067\089\099\043\041\067\099\045\018\041\067\114\117\099\020\018\080\020\093\099\089\041\099\052\080\099\045\067\110\080\099\032\045\099\089\018\080\110\080\099\032\110\080\099\045\080\058\080\110\032\114\099\041\089\018\080\110\099\020\032\020\018\080\045\099\052\080\094\078\047\099\050\114\032\078\078\080\117\099\089\018\032\089\099\068\032\043\099\041\110\099\068\032\043\099\078\041\089\099\052\080\099\032\020\089\094\058\080\099\032\089\099\089\018\094\045\099\089\094\068\080\005\099"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _sDDfW("\012\018\080\099\066\094\078\032\114\099\020\041\078\089\032\094\078\080\110\099\066\041\110\099\089\018\094\045\099\125\018\080\110\094\047\041\099\094\045\099\114\041\020\032\089\080\117\099\032\089\099\119\099\077\017\099\048\073\005\073\048\077\099\052\043\099\125\099\017\051\027\099\120\077\005\079\077\079\008"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _sDDfW("\119\099\077\017\099\048\073\005\073\048\077\099\052\043\099\125\099\017\051\027\099\120\077\005\079\077\079"), 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _sDDfW("\055\114\080\032\080\099\096\110\094\089\080\099\117\041\096\078\099\089\018\080\099\066\041\114\114\041\096\094\078\047\099\020\041\117\080\099\089\041\099\067\078\114\041\020\093\099\089\018\080\099\020\032\110\089\110\094\117\047\080\099\032\078\117\099\045\018\041\096\099\094\089\099\032\045\099\020\041\068\050\114\080\089\080\117\099\041\078\099\089\018\080\099\096\018\080\110\094\047\041\099\045\094\089\080\005\099\116\066\099\043\041\067\099\032\110\080\099\050\114\032\043\094\078\047\099\096\094\089\018\099\045\041\068\080\041\078\080\099\080\114\045\080\099\041\078\099\089\018\080\094\110\099\117\080\058\094\020\080\099\043\041\067\099\096\094\114\114\099\078\080\080\117\099\089\018\080\094\110\099\020\041\117\080\099\032\078\117\099\067\045\080\110\099\094\117\099\089\041\099\101\078\114\041\020\093\099\089\018\080\099\047\032\068\080\005\099"), 
															Callback = function(action)
																if action ~= nil then
																	_Urwigo.MessageBox{
																		Text = string.sub(Player.CompletionCode, 1, 15), 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.RunDialogs(function()
																					Wherigo.GetInput(objFinal2)
																				end)
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _sDDfW("\125\080\114\114\099\096\080\099\018\041\050\080\099\043\041\067\099\096\094\114\114\099\089\110\043\099\066\041\110\099\094\089\099\032\047\032\094\078\005\099\012\018\080\110\080\099\094\045\099\045\089\094\114\114\099\041\078\080\099\068\041\110\080\099\041\066\099\089\018\080\099\041\110\047\094\078\032\114\099\020\032\020\018\080\045\099\114\080\066\089\099\066\041\110\099\043\041\067\099\089\041\099\117\041\099\018\080\110\080\005\099\094\089\099\094\045\099\068\043\099\041\089\018\080\110\099\125\018\080\110\094\047\041\099\012\018\080\099\023\080\018\094\047\018\099\061\032\078\032\114\099\032\089\099\089\018\080\099\023\091\069\069\055\099\125\018\080\110\094\047\041\099\012\041\067\110\099\069\061\048\033\118\095\119\008"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _sDDfW("\012\018\080\110\080\099\032\110\080\099\066\080\096\099\068\041\110\080\099\020\032\020\018\080\045\099\089\018\032\089\099\089\018\080\099\061\121\013\045\099\018\032\058\080\099\050\114\032\078\078\080\117\099\089\018\032\089\099\068\032\043\099\041\110\099\068\032\043\099\078\041\089\099\052\080\099\032\020\089\094\058\080\099\032\089\099\089\018\094\045\099\089\094\068\080\005"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _sDDfW("\118\114\114\099\089\018\080\099\020\032\020\018\080\099\041\096\078\080\110\045\099\018\080\110\080\099\032\089\099\089\018\080\099\023\080\018\094\047\018\099\091\032\114\114\080\043\099\069\080\041\020\032\020\018\080\110\045\099\069\080\041\055\032\110\093\099\018\041\050\080\099\089\018\032\089\099\043\041\067\099\018\032\058\080\099\080\078\002\041\043\080\117\099\043\041\067\110\099\117\032\043\099\018\080\110\080\005\099\125\080\099\018\041\096\099\089\018\032\089\099\089\018\094\045\099\069\080\041\055\032\110\093\099\052\080\020\041\068\080\045\099\032\099\068\041\117\080\114\099\066\041\110\099\041\089\018\080\110\099\020\032\020\018\094\078\047\099\047\110\041\067\050\045\099\089\041\099\066\041\114\114\041\096\005"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _sDDfW("\012\018\080\099\066\094\078\032\114\099\020\041\078\089\032\094\078\080\110\099\066\041\110\099\089\018\094\045\099\125\018\080\110\094\047\041\099\094\045\099\114\041\020\032\089\080\117\099\032\089\099\119\099\077\017\099\048\073\005\073\048\077\099\052\043\099\125\099\017\051\027\099\120\077\005\079\077\079\008"), 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _sDDfW("\119\099\077\017\099\048\073\005\073\048\077\099\052\043\099\125\099\017\051\027\099\120\077\005\079\077\079"), 
															Callback = function(action)
																if action ~= nil then
																	_Urwigo.MessageBox{
																		Text = _sDDfW("\055\114\080\032\080\099\096\110\094\089\080\099\117\041\096\078\099\089\018\080\099\066\041\114\114\041\096\094\078\047\099\020\041\117\080\099\089\041\099\067\078\114\041\020\093\099\089\018\080\099\020\032\110\089\110\094\117\047\080\099\032\078\117\099\045\018\041\096\099\094\089\099\032\045\099\020\041\068\050\114\080\089\080\117\099\041\078\099\089\018\080\099\096\018\080\110\094\047\041\099\045\094\089\080\005\099\116\066\099\043\041\067\099\032\110\080\099\050\114\032\043\094\078\047\099\096\094\089\018\099\045\041\068\080\041\078\080\099\080\114\045\080\099\041\078\099\089\018\080\094\110\099\117\080\058\094\020\080\099\043\041\067\099\096\094\114\114\099\078\080\080\117\099\089\018\080\094\110\099\020\041\117\080\099\032\078\117\099\067\045\080\110\099\094\117\099\089\041\099\101\078\114\041\020\093\099\089\018\080\099\047\032\068\080\005\099"), 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.MessageBox{
																					Text = string.sub(Player.CompletionCode, 1, 15), 
																					Callback = function(action)
																						if action ~= nil then
																							_Urwigo.RunDialogs(function()
																								Wherigo.GetInput(objFinal2)
																							end)
																						end
																					end
																				}
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	end
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function objFinal2:OnGetInput(input)
	if input == nil then
		input = ""
	end
	objanswer = input
	if Wherigo.NoCaseEquals(objanswer, _sDDfW("\092\080\045")) then
		_Urwigo.MessageBox{
			Text = _sDDfW("\012\018\032\078\093\099\043\041\067\099\066\041\110\099\050\114\032\043\094\078\047\099\068\043\099\047\032\068\080\021\099\116\099\018\041\050\080\099\043\041\067\099\080\078\002\041\043\080\117\099\094\089\099\032\078\117\099\089\018\080\099\069\080\041\050\032\110\093\099\032\045\099\068\067\020\018\099\032\045\099\096\080\099\032\114\114\099\018\041\050\080\117\099\043\041\067\099\096\041\067\114\117\005\099\061\032\020\018\080\099\121\078\008"), 
			Callback = function(action)
				if action ~= nil then
					obj15FINAL.Active = false
					obj15FINAL.Visible = false
					objMeettheCOSattheLVGGPWherigo.Complete = true
				end
			end
		}
		Wherigo.Command "SaveClose"
	else
		_Urwigo.MessageBox{
			Text = _sDDfW("\055\114\080\032\045\080\099\089\032\093\080\099\089\018\080\099\089\094\068\080\099\089\041\099\117\041\099\089\018\094\045\099\032\045\099\094\089\099\094\045\099\094\068\050\041\110\089\032\078\089\099\089\041\099\045\018\041\096\099\069\110\041\067\078\117\045\050\080\032\093\099\032\078\117\099\041\089\018\080\110\099\050\114\032\043\080\110\045\099\089\018\032\089\099\041\067\110\099\096\018\080\110\094\047\041\099\020\032\110\089\110\094\117\047\080\045\099\032\110\080\099\096\041\110\093\094\078\047\099\032\078\117\099\020\032\020\018\080\110\045\099\080\078\002\041\043\099\050\114\032\043\094\078\047\099\089\018\080\068\005"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = string.sub(Player.CompletionCode, 1, 15), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(objFinal2)
								end)
							end
						end
					}
				end
			end
		}
	end
	objMeettheCOSattheLVGGPWherigo:RequestSync()
end
function objName:OnTick()
	if _G[_sDDfW("\055\114\032\043\080\110")][_sDDfW("\055\041\045\094\089\094\041\078\118\020\020\067\110\032\020\043")][_sDDfW("\069\080\089\091\032\114\067\080")](_G[_sDDfW("\055\114\032\043\080\110")][_sDDfW("\055\041\045\094\089\094\041\078\118\020\020\067\110\032\020\043")], _sDDfW("\068")) == 3 then
		for k, v in pairs(_G[_sDDfW("\041\052\002\123\080\080\089\089\018\080\061\121\060\032\089\089\018\080\023\091\069\069\055\125\018\080\110\094\047\041")][_sDDfW("\118\114\114\039\121\052\002\080\020\089\045")]) do
			v[_sDDfW("\091\094\045\094\052\114\080")] = false
			v[_sDDfW("\118\020\089\094\058\080")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_sDDfW("\060\041\110\110\043\099\043\041\067\099\020\032\078\078\041\089\099\050\114\032\043\099\089\018\094\045\099\047\032\068\080\099\094\078\099\089\018\080\099\060\094\068\067\114\032\089\094\041\078\099\068\041\117\080\008")), 
			Callback = function(action)
				if action ~= nil then
					_G[_sDDfW("\125\018\080\110\094\047\041")][_sDDfW("\061\041\068\068\032\078\117")](_sDDfW("\060\032\058\080\061\114\041\045\080"))
				end
			end
		}
		return
	end
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return objMeettheCOSattheLVGGPWherigo
