require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _ZFP8(str)
	local res = ""
    local dtable = "\109\057\093\047\102\018\014\027\044\004\104\026\089\072\015\079\052\036\071\075\068\100\001\017\078\016\055\037\107\034\058\060\046\125\040\031\115\023\011\006\116\123\101\073\063\043\050\053\076\099\038\009\077\021\088\122\059\113\105\080\091\010\118\042\013\020\087\098\110\108\106\121\074\028\000\112\039\095\066\081\019\097\086\049\035\033\119\002\084\070\022\092\117\067\120\062\003\090\082\032\069\048\126\111\007\008\083\041\103\045\025\054\114\056\094\005\051\096\024\064\085\124\030\029\065\061\012"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

objTourGuideByTeamVerturin = Wherigo.ZCartridge()

-- Media --
objLogo = Wherigo.ZMedia(objTourGuideByTeamVerturin)
objLogo.Id = "efbc2a02-fc1a-4744-b4b5-cda7d5874140"
objLogo.Name = "Logo"
objLogo.Description = ""
objLogo.AltText = ""
objLogo.Resources = {
	{
		Type = "jpg", 
		Filename = "WTour-1.jpg", 
		Directives = {}
	}
}
objtresor = Wherigo.ZMedia(objTourGuideByTeamVerturin)
objtresor.Id = "e591178b-35a0-4ca8-a883-3dd45c81e875"
objtresor.Name = "tresor"
objtresor.Description = ""
objtresor.AltText = ""
objtresor.Resources = {
	{
		Type = "jpg", 
		Filename = "tresor1.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "tresor1_1.jpg", 
		Directives = {}
	}
}
objInconeTresor = Wherigo.ZMedia(objTourGuideByTeamVerturin)
objInconeTresor.Id = "a1c67ee9-7f0d-4f49-a73d-8b81b9085906"
objInconeTresor.Name = "InconeTresor"
objInconeTresor.Description = ""
objInconeTresor.AltText = ""
objInconeTresor.Resources = {
	{
		Type = "jpg", 
		Filename = "IconTresor1.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "IconTresor1_1.jpg", 
		Directives = {}
	}
}
objTv300 = Wherigo.ZMedia(objTourGuideByTeamVerturin)
objTv300.Id = "6b8c0011-2329-49cd-b951-853f4442e352"
objTv300.Name = "Tv300"
objTv300.Description = ""
objTv300.AltText = ""
objTv300.Resources = {
	{
		Type = "jpg", 
		Filename = "logorougeau.jpg", 
		Directives = {}
	}
}
objIconTV = Wherigo.ZMedia(objTourGuideByTeamVerturin)
objIconTV.Id = "986a1417-0b6e-4560-b825-dfb413d89ee1"
objIconTV.Name = "IconTV"
objIconTV.Description = ""
objIconTV.AltText = ""
objIconTV.Resources = {
	{
		Type = "jpg", 
		Filename = "logorougeau-32.jpg", 
		Directives = {}
	}
}
objLogoHaut = Wherigo.ZMedia(objTourGuideByTeamVerturin)
objLogoHaut.Id = "9002a9cb-0ba6-4856-b681-fd7261dcdb9f"
objLogoHaut.Name = "LogoHaut"
objLogoHaut.Description = ""
objLogoHaut.AltText = ""
objLogoHaut.Resources = {
	{
		Type = "jpg", 
		Filename = "WTour-Logo-1.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
objTourGuideByTeamVerturin.Id="29fc63f3-b015-4100-b4b7-f17936a90b42"
objTourGuideByTeamVerturin.Name="Tour Guide - By Team Verturin"
objTourGuideByTeamVerturin.Description=[[Wherigo creer pour decouvrir la realisation d'une Wherigo simple
Wherigo Demonstration Team Verturin
Dirigeons nous vers le point de depart.]]
objTourGuideByTeamVerturin.Visible=true
objTourGuideByTeamVerturin.Activity="Geocache"
objTourGuideByTeamVerturin.StartingLocationDescription=[[Wherigo creer pour decouvrir la realisation d'un Wherigo simple
 
Wherigo Demonstration Team Verturin]]
objTourGuideByTeamVerturin.StartingLocation = ZonePoint(48.6563584520495,2.49265193939209,0)
objTourGuideByTeamVerturin.Version="1.0"
objTourGuideByTeamVerturin.Company="Team Verturin"
objTourGuideByTeamVerturin.Author="Team Verturin"
objTourGuideByTeamVerturin.BuilderVersion="URWIGO 1.20.5218.24064"
objTourGuideByTeamVerturin.CreateDate="10/06/2012 17:07:43"
objTourGuideByTeamVerturin.PublishDate="1/1/0001 12:00:00 AM"
objTourGuideByTeamVerturin.UpdateDate="12/18/2014 11:51:01"
objTourGuideByTeamVerturin.LastPlayedDate="1/1/0001 12:00:00 AM"
objTourGuideByTeamVerturin.TargetDevice="PocketPC"
objTourGuideByTeamVerturin.TargetDeviceVersion="0"
objTourGuideByTeamVerturin.StateId="1"
objTourGuideByTeamVerturin.CountryId="2"
objTourGuideByTeamVerturin.Complete=false
objTourGuideByTeamVerturin.UseLogging=true

objTourGuideByTeamVerturin.Media=objLogo

objTourGuideByTeamVerturin.Icon=objIconTV


-- Zones --
obj01 = Wherigo.Zone(objTourGuideByTeamVerturin)
obj01.Id = "84211c52-68cb-4019-a7ee-813fdae53e13"
obj01.Name = "01"
obj01.Description = "Texte zone 01"
obj01.Visible = true
obj01.Media = objTv300
obj01.Icon = objIconTV
obj01.Commands = {}
obj01.DistanceRange = Distance(-1, "feet")
obj01.ShowObjects = "OnEnter"
obj01.ProximityRange = Distance(60, "meters")
obj01.AllowSetPositionTo = false
obj01.Active = false
obj01.Points = {
	ZonePoint(48.6483351179989, 2.49020576477051, 0), 
	ZonePoint(48.6461235152646, 2.49320983886719, 0), 
	ZonePoint(48.6445923488618, 2.48797416687012, 0), 
	ZonePoint(48.6466906021352, 2.48600006103516, 0)
}
obj01.OriginalPoint = ZonePoint(48.6464353960651, 2.48934745788574, 0)
obj01.DistanceRangeUOM = "Feet"
obj01.ProximityRangeUOM = "Meters"
obj01.OutOfRangeName = ""
obj01.InRangeName = ""
objFinal = Wherigo.Zone(objTourGuideByTeamVerturin)
objFinal.Id = "353de5b8-c839-4771-8270-621b73792747"
objFinal.Name = "Final"
objFinal.Description = ""
objFinal.Visible = true
objFinal.Media = objtresor
objFinal.Icon = objtresor
objFinal.Commands = {}
objFinal.DistanceRange = Distance(-1, "feet")
objFinal.ShowObjects = "OnEnter"
objFinal.ProximityRange = Distance(60, "meters")
objFinal.AllowSetPositionTo = false
objFinal.Active = false
objFinal.Points = {
	ZonePoint(48.6863141738246, 2.46608734130859, 0), 
	ZonePoint(48.686654155466, 2.46969223022461, 0), 
	ZonePoint(48.6845008996395, 2.46952056884766, 0), 
	ZonePoint(48.6845008996395, 2.46694564819336, 0)
}
objFinal.OriginalPoint = ZonePoint(48.6854925321424, 2.46806144714355, 0)
objFinal.DistanceRangeUOM = "Feet"
objFinal.ProximityRangeUOM = "Meters"
objFinal.OutOfRangeName = ""
objFinal.InRangeName = ""
obj00Depart = Wherigo.Zone(objTourGuideByTeamVerturin)
obj00Depart.Id = "93019024-41d9-4713-a287-05c7680097f4"
obj00Depart.Name = "00-Depart"
obj00Depart.Description = "Texte zone 00"
obj00Depart.Visible = true
obj00Depart.Media = objLogoHaut
obj00Depart.Icon = objIconTV
obj00Depart.Commands = {}
obj00Depart.DistanceRange = Distance(-1, "feet")
obj00Depart.ShowObjects = "OnEnter"
obj00Depart.ProximityRange = Distance(60, "meters")
obj00Depart.AllowSetPositionTo = false
obj00Depart.Active = false
obj00Depart.Points = {
	ZonePoint(48.657747521563, 2.48917579650879, 0), 
	ZonePoint(48.6584845633131, 2.49509811401367, 0), 
	ZonePoint(48.6539487508827, 2.49634265899658, 0), 
	ZonePoint(48.6538353503431, 2.48960494995117, 0)
}
obj00Depart.OriginalPoint = ZonePoint(48.6560040465255, 2.49255537986755, 0)
obj00Depart.DistanceRangeUOM = "Feet"
obj00Depart.ProximityRangeUOM = "Meters"
obj00Depart.OutOfRangeName = ""
obj00Depart.InRangeName = ""
obj03 = Wherigo.Zone(objTourGuideByTeamVerturin)
obj03.Id = "15279bf6-5d41-4d67-8a50-bdd8ca9aee48"
obj03.Name = "03"
obj03.Description = "Texte zone 03"
obj03.Visible = true
obj03.Media = objTv300
obj03.Icon = objIconTV
obj03.Commands = {}
obj03.DistanceRange = Distance(-1, "feet")
obj03.ShowObjects = "OnEnter"
obj03.ProximityRange = Distance(60, "meters")
obj03.AllowSetPositionTo = false
obj03.Active = false
obj03.Points = {
	ZonePoint(48.6636435538306, 2.46316909790039, 0), 
	ZonePoint(48.6631900373724, 2.46883392333984, 0), 
	ZonePoint(48.6603554670506, 2.46849060058594, 0), 
	ZonePoint(48.6605822385427, 2.46591567993164, 0), 
	ZonePoint(48.6580876960175, 2.46505737304688, 0), 
	ZonePoint(48.6580876960175, 2.46162414550781, 0), 
	ZonePoint(48.6554796332022, 2.46110916137695, 0), 
	ZonePoint(48.6547992467991, 2.45922088623047, 0)
}
obj03.OriginalPoint = ZonePoint(48.6592781961041, 2.46417760848999, 0)
obj03.DistanceRangeUOM = "Feet"
obj03.ProximityRangeUOM = "Meters"
obj03.OutOfRangeName = ""
obj03.InRangeName = ""
obj05 = Wherigo.Zone(objTourGuideByTeamVerturin)
obj05.Id = "58da5e20-4cf7-42bc-9c64-6577e18e4706"
obj05.Name = "05"
obj05.Description = "Texte zone 05"
obj05.Visible = true
obj05.Media = objTv300
obj05.Icon = objIconTV
obj05.Commands = {}
obj05.DistanceRange = Distance(-1, "feet")
obj05.ShowObjects = "OnEnter"
obj05.ProximityRange = Distance(60, "meters")
obj05.AllowSetPositionTo = false
obj05.Active = false
obj05.Points = {
	ZonePoint(48.6537786499777, 2.46849060058594, 0), 
	ZonePoint(48.6544590501542, 2.47364044189453, 0), 
	ZonePoint(48.6492424141397, 2.47501373291016, 0), 
	ZonePoint(48.6494692356242, 2.46917724609375, 0)
}
obj05.OriginalPoint = ZonePoint(48.651737337474, 2.4715805053711, 0)
obj05.DistanceRangeUOM = "Feet"
obj05.ProximityRangeUOM = "Meters"
obj05.OutOfRangeName = ""
obj05.InRangeName = ""
obj02 = Wherigo.Zone(objTourGuideByTeamVerturin)
obj02.Id = "b41c5387-ea4a-4877-85b6-4d2edecb8049"
obj02.Name = "02"
obj02.Description = "Texte zone 02"
obj02.Visible = true
obj02.Media = objTv300
obj02.Icon = objIconTV
obj02.Commands = {}
obj02.DistanceRange = Distance(-1, "feet")
obj02.ShowObjects = "OnEnter"
obj02.ProximityRange = Distance(60, "meters")
obj02.AllowSetPositionTo = false
obj02.Active = false
obj02.Points = {
	ZonePoint(48.6609223938678, 2.48711585998535, 0), 
	ZonePoint(48.6626231360608, 2.4953556060791, 0), 
	ZonePoint(48.6666479972936, 2.49286651611328, 0), 
	ZonePoint(48.6651174541367, 2.48419761657715, 0), 
	ZonePoint(48.6630199676484, 2.48213768005371, 0)
}
obj02.OriginalPoint = ZonePoint(48.6636661898015, 2.48833465576172, 0)
obj02.DistanceRangeUOM = "Feet"
obj02.ProximityRangeUOM = "Meters"
obj02.OutOfRangeName = ""
obj02.InRangeName = ""
objQuestions = Wherigo.Zone(objTourGuideByTeamVerturin)
objQuestions.Id = "ca1ecdf1-88c6-4e75-8924-65df95405ea6"
objQuestions.Name = "Questions"
objQuestions.Description = "Texte zone Questions"
objQuestions.Visible = true
objQuestions.Media = objLogo
objQuestions.Commands = {}
objQuestions.DistanceRange = Distance(-1, "feet")
objQuestions.ShowObjects = "OnEnter"
objQuestions.ProximityRange = Distance(60, "meters")
objQuestions.AllowSetPositionTo = false
objQuestions.Active = false
objQuestions.Points = {
	ZonePoint(48.6570671657674, 2.4774169921875, 0), 
	ZonePoint(48.6578609133029, 2.48299598693848, 0), 
	ZonePoint(48.6536652490555, 2.48488426208496, 0), 
	ZonePoint(48.6536085484988, 2.47810363769531, 0)
}
objQuestions.OriginalPoint = ZonePoint(48.6555504691561, 2.48085021972656, 0)
objQuestions.DistanceRangeUOM = "Feet"
objQuestions.ProximityRangeUOM = "Meters"
objQuestions.OutOfRangeName = ""
objQuestions.InRangeName = ""

-- Characters --

-- Items --
objSolutionCode = Wherigo.ZItem(objTourGuideByTeamVerturin)
objSolutionCode.Id = "5880aed7-7a59-4585-8caa-d76acf454c75"
objSolutionCode.Name = "Solution Code"
objSolutionCode.Description = [[Code de Confirmation pour le 
site Wherigo]]
objSolutionCode.Visible = true
objSolutionCode.Media = objtresor
objSolutionCode.Icon = objInconeTresor
objSolutionCode.Commands = {}
objSolutionCode.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objSolutionCode.Locked = false
objSolutionCode.Opened = false
objCache = Wherigo.ZItem(objTourGuideByTeamVerturin)
objCache.Id = "8ea9efef-b48e-41d7-921a-92316152ddfc"
objCache.Name = "Cache"
objCache.Description = [[Bravo Felicitations
la cache se trouve a cote de vous !
Mais faut me trouver maintenant !!
Ici coorodonnees Finales]]
objCache.Visible = false
objCache.Media = objtresor
objCache.Icon = objInconeTresor
objCache.Commands = {}
objCache.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objCache.Locked = false
objCache.Opened = false

-- Tasks --

-- Cartridge Variables --
currentZone = "obj01"
currentCharacter = "dummy"
currentItem = "objSolutionCode"
currentTask = "dummy"
currentInput = "objQ01"
currentTimer = "dummy"
objTourGuideByTeamVerturin.ZVariables = {
	currentZone = "obj01", 
	currentCharacter = "dummy", 
	currentItem = "objSolutionCode", 
	currentTask = "dummy", 
	currentInput = "objQ01", 
	currentTimer = "dummy"
}

-- Timers --

-- Inputs --
objQ01 = Wherigo.ZInput(objTourGuideByTeamVerturin)
objQ01.Id = "a1bae0c2-ece3-4b77-aebb-9f958b1abef8"
objQ01.Name = "Q01"
objQ01.Description = ""
objQ01.Visible = true
objQ01.Media = objLogo
objQ01.Choices = {
	"01", 
	"02", 
	"03"
}
objQ01.InputType = "MultipleChoice"
objQ01.Text = "Question 1"
objQ02 = Wherigo.ZInput(objTourGuideByTeamVerturin)
objQ02.Id = "cd712891-3510-4545-b97c-03e9c62f0e69"
objQ02.Name = "Q02"
objQ02.Description = ""
objQ02.Visible = true
objQ02.Media = objLogo
objQ02.Choices = {
	"01", 
	"02", 
	"03"
}
objQ02.InputType = "MultipleChoice"
objQ02.Text = "Question 2"
objQ03 = Wherigo.ZInput(objTourGuideByTeamVerturin)
objQ03.Id = "d696d276-3ebb-4376-90d6-25c63f418f79"
objQ03.Name = "Q03"
objQ03.Description = ""
objQ03.Visible = true
objQ03.Media = objLogo
objQ03.Choices = {
	"01", 
	"02", 
	"03", 
	"04"
}
objQ03.InputType = "MultipleChoice"
objQ03.Text = "Question 3"

-- WorksWithList for object commands --

-- functions --
function objTourGuideByTeamVerturin:OnStart()
	obj00Depart.Active = true
	_Urwigo.MessageBox{
		Text = "Dirigeons nous vers le point de depart.", 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, obj00Depart)
			end
		end
	}
end
function objTourGuideByTeamVerturin:OnRestore()
end
function obj01:OnEnter()
	currentZone = "obj01"
	obj01.Active = false
	obj02.Active = true
	_Urwigo.MessageBox{
		Text = "Zone 01", 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, obj02)
			end
		end
	}
	objTourGuideByTeamVerturin:RequestSync()
end
function objFinal:OnEnter()
	currentZone = "objFinal"
	objTourGuideByTeamVerturin:RequestSync()
	objTourGuideByTeamVerturin.Complete = true
	objSolutionCode:MoveTo(Player)
	objCache:MoveTo(Player)
	objSolutionCode.Name = "UNLOCK CODE"
	objSolutionCode.Description = "Le code pour debloquer la cartouche est : "..string.sub(Player.CompletionCode, 1, 15)
	objCache.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = [[Bravo Felicitations
la cache se trouve 
dans votre inventaire !

Bravo voici le code de validation de votre cartouche Wherigo]]..string.sub(Player.CompletionCode, 1, 15)
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, objFinal)
		objTourGuideByTeamVerturin:RequestSync()
	end)
end
function obj00Depart:OnEnter()
	currentZone = "obj00Depart"
	obj00Depart.Active = false
	obj01.Active = true
	_Urwigo.MessageBox{
		Text = "Zone Depart", 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, obj01)
			end
		end
	}
end
function obj03:OnEnter()
	currentZone = "obj03"
	obj03.Active = false
	objQuestions.Active = true
	_Urwigo.MessageBox{
		Text = "Zone 03 avec une Question", 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, objQuestions)
			end
		end
	}
end
function obj05:OnEnter()
	currentZone = "obj05"
	obj05.Active = false
	objQuestions.Active = true
	objTourGuideByTeamVerturin:RequestSync()
	_Urwigo.MessageBox{
		Text = "Le seul reste d'une ancienne ferme", 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, objQuestions)
			end
		end
	}
end
function obj02:OnEnter()
	currentZone = "obj02"
	obj02.Active = false
	obj03.Active = true
	_Urwigo.MessageBox{
		Text = "Zone 02", 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, obj03)
			end
		end
	}
end
function objQuestions:OnEnter()
	currentZone = "objQuestions"
	obj03.Active = false
	obj05.Active = false
	objQuestions.Active = true
	objVerificationParcours()
end
function objQ01:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(input, "02") then
		objQuestions.Active = false
		objFinal.Active = true
		_Urwigo.MessageBox{
			Text = [[Bravo !
en route pour le Final]], 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, objFinal)
				end
			end
		}
	else
		objVerificationParcours()
	end
end
function objQ02:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(input, "01") then
		objQuestions.Active = false
		objFinal.Active = true
		_Urwigo.MessageBox{
			Text = [[Bravo !
en route pour le Final]], 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, objFinal)
				end
			end
		}
	else
		objVerificationParcours()
	end
end
function objQ03:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if Wherigo.NoCaseEquals(input, "04") then
		objQuestions.Active = false
		objFinal.Active = true
		_Urwigo.MessageBox{
			Text = [[Bravo !
en route pour le Final]], 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, objFinal)
				end
			end
		}
	else
		objVerificationParcours()
	end
end

-- Urwigo functions --
function objVerificationParcours()
	_Urwigo.MessageBox{
		Text = [[Maintenant que la wherigo est complete 
on peut poser une question de verification.
Verifions si vous avez bien tout lu !]], 
		Media = objLogo, 
		Callback = function(action)
			if action ~= nil then
				local _rndChoiceValue = math.random()
				if _rndChoiceValue < 0.333333333333333 then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objQ01)
					end)
				elseif _rndChoiceValue < 0.666666666666667 then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objQ02)
					end)
				else
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objQ03)
					end)
				end
			end
		end
	}
end

-- Begin user functions --
-- End user functions --
return objTourGuideByTeamVerturin
