require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

objToerkeindekampsebossen = Wherigo.ZCartridge()

-- String decode --
function _bhFvz(str)
	local res = ""
    local dtable = "\038\078\073\027\111\057\065\103\097\058\064\098\031\108\043\012\063\033\001\106\067\082\071\011\015\075\105\090\023\096\049\045\018\119\069\050\113\109\107\059\118\086\039\006\034\081\084\117\016\055\009\013\121\104\035\066\003\114\101\048\020\100\004\068\115\062\007\046\060\044\124\126\095\032\083\030\047\072\099\026\102\089\014\079\052\085\123\053\029\110\010\087\005\022\040\088\054\061\080\093\077\051\091\125\116\094\120\122\092\112\037\002\025\021\000\076\017\042\041\019\024\036\008\056\028\074\070"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end


-- Media --
obj3paaltjes = Wherigo.ZMedia(objToerkeindekampsebossen)
obj3paaltjes.Id = "bb090b5c-48ce-48f5-b94f-9b66ebe18740"
obj3paaltjes.Name = _bhFvz("\102\074\110\009\009\014\105\020\059\065")
obj3paaltjes.Description = ""
obj3paaltjes.AltText = ""
obj3paaltjes.Resources = {
	{
		Type = "jpg", 
		Filename = "3paaltjes.jpg", 
		Directives = {}
	}
}
objgeelzwartpaaltje = Wherigo.ZMedia(objToerkeindekampsebossen)
objgeelzwartpaaltje.Id = "f718c1f1-17a2-47ce-85ec-5961ea6f5be8"
objgeelzwartpaaltje.Name = _bhFvz("\008\059\059\014\032\108\034\009\058\105\074\110\009\009\014\105\020\059")
objgeelzwartpaaltje.Description = ""
objgeelzwartpaaltje.AltText = ""
objgeelzwartpaaltje.Resources = {
	{
		Type = "jpg", 
		Filename = "geel-zwart paaltje1.jpg", 
		Directives = {}
	}
}
objGeodetischPunt = Wherigo.ZMedia(objToerkeindekampsebossen)
objGeodetischPunt.Id = "8015fc85-59c5-489b-8499-4e5a5853a9d7"
objGeodetischPunt.Name = _bhFvz("\023\059\005\062\059\105\027\065\079\054\074\099\048\090\105")
objGeodetischPunt.Description = ""
objGeodetischPunt.AltText = ""
objGeodetischPunt.Resources = {
	{
		Type = "jpg", 
		Filename = "geodetischpunt1.jpg", 
		Directives = {}
	}
}
objIjskelder = Wherigo.ZMedia(objToerkeindekampsebossen)
objIjskelder.Id = "8d69e3ab-ae90-4955-9365-2e5590f14c1f"
objIjskelder.Name = _bhFvz("\003\020\065\039\059\014\062\059\058")
objIjskelder.Description = ""
objIjskelder.AltText = ""
objIjskelder.Resources = {
	{
		Type = "jpg", 
		Filename = "Vleermuis Kelder1.jpg", 
		Directives = {}
	}
}
objGemeneBest = Wherigo.ZMedia(objToerkeindekampsebossen)
objGemeneBest.Id = "3010a4dd-7897-47bc-b2a2-8b3197e5f7ad"
objGemeneBest.Name = _bhFvz("\023\059\038\059\090\059\074\056\059\065\105")
objGemeneBest.Description = ""
objGemeneBest.AltText = ""
objGemeneBest.Resources = {
	{
		Type = "jpg", 
		Filename = "Gemene Best1.jpg", 
		Directives = {}
	}
}
obj2paaltjes = Wherigo.ZMedia(objToerkeindekampsebossen)
obj2paaltjes.Id = "104a64b6-2e5d-4e77-be50-a24b4662f9b4"
obj2paaltjes.Name = _bhFvz("\036\074\110\009\009\014\105\020\059\065")
obj2paaltjes.Description = ""
obj2paaltjes.AltText = ""
obj2paaltjes.Resources = {
	{
		Type = "jpg", 
		Filename = "2paaltjes1.jpg", 
		Directives = {}
	}
}
objWitRood = Wherigo.ZMedia(objToerkeindekampsebossen)
objWitRood.Id = "d1687e81-3cca-422b-b2d5-20e62182d51f"
objWitRood.Name = _bhFvz("\092\027\105\032\022\005\005\062")
objWitRood.Description = ""
objWitRood.AltText = ""
objWitRood.Resources = {
	{
		Type = "jpg", 
		Filename = "Wit-Rood1.jpg", 
		Directives = {}
	}
}
objGaatjes = Wherigo.ZMedia(objToerkeindekampsebossen)
objGaatjes.Id = "303ecf8b-6ff9-47a4-96a2-89fe91d4540b"
objGaatjes.Name = _bhFvz("\023\009\009\105\020\059\065")
objGaatjes.Description = ""
objGaatjes.AltText = ""
objGaatjes.Resources = {
	{
		Type = "JPG", 
		Filename = "Gaatjes.JPG", 
		Directives = {}
	}
}
objMilitairkerkhof = Wherigo.ZMedia(objToerkeindekampsebossen)
objMilitairkerkhof.Id = "c5631274-202f-4938-bf42-b7ce42e390d7"
objMilitairkerkhof.Name = _bhFvz("\101\027\014\027\105\009\027\058\074\039\059\058\039\054\005\081")
objMilitairkerkhof.Description = ""
objMilitairkerkhof.AltText = ""
objMilitairkerkhof.Resources = {
	{
		Type = "JPG", 
		Filename = "militairkerkhof.JPG", 
		Directives = {}
	}
}
-- Cartridge Info --
objToerkeindekampsebossen.Id="ce098dfa-7779-45cb-9483-e0fd3cb169cf"
objToerkeindekampsebossen.Name="Toerke in de kampsebossen"
objToerkeindekampsebossen.Description=[[]]
objToerkeindekampsebossen.Visible=true
objToerkeindekampsebossen.Activity="TourGuide"
objToerkeindekampsebossen.StartingLocationDescription=[[]]
objToerkeindekampsebossen.StartingLocation = ZonePoint(51.1124785678064,5.26566043496132,0)
objToerkeindekampsebossen.Version=""
objToerkeindekampsebossen.Company=""
objToerkeindekampsebossen.Author=""
objToerkeindekampsebossen.BuilderVersion="URWIGO 1.2.3718.30064"
objToerkeindekampsebossen.CreateDate="08/02/2010 17:39:57"
objToerkeindekampsebossen.PublishDate="1/1/0001 12:00:00 AM"
objToerkeindekampsebossen.UpdateDate="08/16/2010 00:06:41"
objToerkeindekampsebossen.LastPlayedDate="1/1/0001 12:00:00 AM"
objToerkeindekampsebossen.TargetDevice="PocketPC"
objToerkeindekampsebossen.TargetDeviceVersion="0"
objToerkeindekampsebossen.StateId="1"
objToerkeindekampsebossen.CountryId="2"
objToerkeindekampsebossen.Complete=false
objToerkeindekampsebossen.UseLogging=true


-- Zones --
objMilitairebegraafplaats = Wherigo.Zone(objToerkeindekampsebossen)
objMilitairebegraafplaats.Id = "20e0d5b5-dc61-45b1-a648-c465c3cb39a0"
objMilitairebegraafplaats.Name = _bhFvz("\101\027\014\027\105\009\027\058\059\074\012\059\008\058\009\009\081\110\014\009\009\105\065")
objMilitairebegraafplaats.Description = ""
objMilitairebegraafplaats.Visible = true
objMilitairebegraafplaats.Media = objMilitairkerkhof
objMilitairebegraafplaats.Commands = {}
objMilitairebegraafplaats.DistanceRange = Distance(-1, "feet")
objMilitairebegraafplaats.ShowObjects = "OnEnter"
objMilitairebegraafplaats.ProximityRange = Distance(60, "meters")
objMilitairebegraafplaats.AllowSetPositionTo = false
objMilitairebegraafplaats.Active = false
objMilitairebegraafplaats.Points = {
	ZonePoint(51.1126090678194, 5.26590585708618, 0), 
	ZonePoint(51.1125888613899, 5.26538014411926, 0), 
	ZonePoint(51.1123564868155, 5.26551425457001, 0), 
	ZonePoint(51.1123699578372, 5.26588976383209, 0)
}
objMilitairebegraafplaats.OriginalPoint = ZonePoint(51.1124810934655, 5.26567250490189, 0)
objMilitairebegraafplaats.DistanceRangeUOM = "Feet"
objMilitairebegraafplaats.ProximityRangeUOM = "Meters"
objMilitairebegraafplaats.OutOfRangeName = ""
objMilitairebegraafplaats.InRangeName = ""
objMilitairkerkhofGemenebest = Wherigo.Zone(objToerkeindekampsebossen)
objMilitairkerkhofGemenebest.Id = "2045de44-3499-4ff8-bf85-ea1968fe84ca"
objMilitairkerkhofGemenebest.Name = _bhFvz("\101\027\014\027\105\009\027\058\074\039\059\058\039\054\005\081\074\023\059\038\059\090\059\012\059\065\105")
objMilitairkerkhofGemenebest.Description = _bhFvz("\101\027\014\027\105\009\027\058\074\039\059\058\039\054\005\081\074\041\009\090\074\054\059\105\074\023\059\038\059\090\059\012\059\065\105\068")
objMilitairkerkhofGemenebest.Visible = true
objMilitairkerkhofGemenebest.Media = objGemeneBest
objMilitairkerkhofGemenebest.Commands = {}
objMilitairkerkhofGemenebest.DistanceRange = Distance(-1, "feet")
objMilitairkerkhofGemenebest.ShowObjects = "OnEnter"
objMilitairkerkhofGemenebest.ProximityRange = Distance(60, "meters")
objMilitairkerkhofGemenebest.AllowSetPositionTo = false
objMilitairkerkhofGemenebest.Active = true
objMilitairkerkhofGemenebest.Points = {
	ZonePoint(51.1127614576907, 5.26799127459526, 0), 
	ZonePoint(51.1125459226979, 5.26801541447639, 0), 
	ZonePoint(51.1125913871941, 5.26857867836952, 0), 
	ZonePoint(51.1128035542516, 5.26855185627937, 0)
}
objMilitairkerkhofGemenebest.OriginalPoint = ZonePoint(51.1126755804586, 5.26828430593014, 0)
objMilitairkerkhofGemenebest.DistanceRangeUOM = "Feet"
objMilitairkerkhofGemenebest.ProximityRangeUOM = "Meters"
objMilitairkerkhofGemenebest.OutOfRangeName = ""
objMilitairkerkhofGemenebest.InRangeName = ""
objGeodetischpunt = Wherigo.Zone(objToerkeindekampsebossen)
objGeodetischpunt.Id = "09323fd1-2e07-48da-8ed7-dc2d1b12b5be"
objGeodetischpunt.Name = _bhFvz("\023\059\005\062\059\105\027\065\079\054\074\110\048\090\105")
objGeodetischpunt.Description = ""
objGeodetischpunt.Visible = true
objGeodetischpunt.Media = objGeodetischPunt
objGeodetischpunt.Commands = {}
objGeodetischpunt.DistanceRange = Distance(-1, "feet")
objGeodetischpunt.ShowObjects = "OnEnter"
objGeodetischpunt.ProximityRange = Distance(60, "meters")
objGeodetischpunt.AllowSetPositionTo = false
objGeodetischpunt.Active = false
objGeodetischpunt.Points = {
	ZonePoint(51.1138315403673, 5.2702322602272, 0), 
	ZonePoint(51.1135991720418, 5.27022689580917, 0), 
	ZonePoint(51.1136109588691, 5.27036905288696, 0), 
	ZonePoint(51.1138416433115, 5.27039587497711, 0)
}
objGeodetischpunt.OriginalPoint = ZonePoint(51.1137208286474, 5.27030602097511, 0)
objGeodetischpunt.DistanceRangeUOM = "Feet"
objGeodetischpunt.ProximityRangeUOM = "Meters"
objGeodetischpunt.OutOfRangeName = ""
objGeodetischpunt.InRangeName = ""
objHolleboom = Wherigo.Zone(objToerkeindekampsebossen)
objHolleboom.Id = "9ff17aeb-097e-46a6-8e4a-f3193941bfe3"
objHolleboom.Name = _bhFvz("\078\005\014\014\059\074\012\005\005\038")
objHolleboom.Description = ""
objHolleboom.Visible = true
objHolleboom.Media = objgeelzwartpaaltje
objHolleboom.Commands = {}
objHolleboom.DistanceRange = Distance(-1, "feet")
objHolleboom.ShowObjects = "OnEnter"
objHolleboom.ProximityRange = Distance(60, "meters")
objHolleboom.AllowSetPositionTo = false
objHolleboom.Active = false
objHolleboom.Points = {
	ZonePoint(51.1135233995092, 5.27085453271866, 0), 
	ZonePoint(51.1134206854332, 5.27085185050964, 0), 
	ZonePoint(51.1133971116786, 5.2711147069931, 0), 
	ZonePoint(51.1135166641669, 5.27112007141113, 0)
}
objHolleboom.OriginalPoint = ZonePoint(51.113464465197, 5.27098529040813, 0)
objHolleboom.DistanceRangeUOM = "Feet"
objHolleboom.ProximityRangeUOM = "Meters"
objHolleboom.OutOfRangeName = ""
objHolleboom.InRangeName = ""
obj2paaltjes1 = Wherigo.Zone(objToerkeindekampsebossen)
obj2paaltjes1.Id = "9f16362d-eece-4f58-9031-4fe5ea4631d2"
obj2paaltjes1.Name = _bhFvz("\036\074\110\009\009\014\105\020\059\065")
obj2paaltjes1.Description = ""
obj2paaltjes1.Visible = true
obj2paaltjes1.Media = obj2paaltjes
obj2paaltjes1.Commands = {}
obj2paaltjes1.DistanceRange = Distance(-1, "feet")
obj2paaltjes1.ShowObjects = "OnEnter"
obj2paaltjes1.ProximityRange = Distance(60, "meters")
obj2paaltjes1.AllowSetPositionTo = false
obj2paaltjes1.Active = false
obj2paaltjes1.Points = {
	ZonePoint(51.1131626363578, 5.27129642665386, 0), 
	ZonePoint(51.1130195090064, 5.27130983769894, 0), 
	ZonePoint(51.1130380313945, 5.2715914696455, 0), 
	ZonePoint(51.1131761071446, 5.27158878743649, 0)
}
obj2paaltjes1.OriginalPoint = ZonePoint(51.1130990709758, 5.2714466303587, 0)
obj2paaltjes1.DistanceRangeUOM = "Feet"
obj2paaltjes1.ProximityRangeUOM = "Meters"
obj2paaltjes1.OutOfRangeName = ""
obj2paaltjes1.InRangeName = ""
obj3paaltjes1 = Wherigo.Zone(objToerkeindekampsebossen)
obj3paaltjes1.Id = "217f0a05-db0e-465f-857f-b627aaab1abd"
obj3paaltjes1.Name = _bhFvz("\102\074\110\009\009\014\105\020\059\065")
obj3paaltjes1.Description = ""
obj3paaltjes1.Visible = true
obj3paaltjes1.Media = obj3paaltjes
obj3paaltjes1.Commands = {}
obj3paaltjes1.DistanceRange = Distance(-1, "feet")
obj3paaltjes1.ShowObjects = "OnEnter"
obj3paaltjes1.ProximityRange = Distance(60, "meters")
obj3paaltjes1.AllowSetPositionTo = false
obj3paaltjes1.Active = false
obj3paaltjes1.Points = {
	ZonePoint(51.1128405991936, 5.26899039745331, 0), 
	ZonePoint(51.1127395674639, 5.26901185512543, 0), 
	ZonePoint(51.1127547222375, 5.26919156312943, 0), 
	ZonePoint(51.1128456507743, 5.26917815208435, 0)
}
obj3paaltjes1.OriginalPoint = ZonePoint(51.1127951349173, 5.26909299194813, 0)
obj3paaltjes1.DistanceRangeUOM = "Feet"
obj3paaltjes1.ProximityRangeUOM = "Meters"
obj3paaltjes1.OutOfRangeName = ""
obj3paaltjes1.InRangeName = ""
objAcacia = Wherigo.Zone(objToerkeindekampsebossen)
objAcacia.Id = "f67137da-773d-4f56-8b58-9705e3288fbe"
objAcacia.Name = _bhFvz("\007\079\009\079\027\009")
objAcacia.Description = ""
objAcacia.Visible = true
objAcacia.Commands = {}
objAcacia.DistanceRange = Distance(-1, "feet")
objAcacia.ShowObjects = "OnEnter"
objAcacia.ProximityRange = Distance(60, "meters")
objAcacia.AllowSetPositionTo = false
objAcacia.Active = false
objAcacia.Points = {
	ZonePoint(51.111925412047, 5.26963546872139, 0), 
	ZonePoint(51.1117536545736, 5.26960596442223, 0), 
	ZonePoint(51.111684614625, 5.27017995715141, 0), 
	ZonePoint(51.1118327978024, 5.27023360133171, 0)
}
objAcacia.OriginalPoint = ZonePoint(51.111799119762, 5.26991374790668, 0)
objAcacia.DistanceRangeUOM = "Feet"
objAcacia.ProximityRangeUOM = "Meters"
objAcacia.OutOfRangeName = ""
objAcacia.InRangeName = ""
objGaatjes1 = Wherigo.Zone(objToerkeindekampsebossen)
objGaatjes1.Id = "dd0b7d0f-3d82-4e89-a0b7-6de816dfe875"
objGaatjes1.Name = _bhFvz("\023\009\009\105\020\059\065")
objGaatjes1.Description = ""
objGaatjes1.Visible = true
objGaatjes1.Media = objGaatjes
objGaatjes1.Commands = {}
objGaatjes1.DistanceRange = Distance(-1, "feet")
objGaatjes1.ShowObjects = "OnEnter"
objGaatjes1.ProximityRange = Distance(60, "meters")
objGaatjes1.AllowSetPositionTo = false
objGaatjes1.Active = false
objGaatjes1.Points = {
	ZonePoint(51.1118656337831, 5.27072042226791, 0), 
	ZonePoint(51.1116568302263, 5.27070432901382, 0), 
	ZonePoint(51.1116534624193, 5.27118176221848, 0), 
	ZonePoint(51.1118487948215, 5.27120858430862, 0)
}
objGaatjes1.OriginalPoint = ZonePoint(51.1117561803125, 5.27095377445221, 0)
objGaatjes1.DistanceRangeUOM = "Feet"
objGaatjes1.ProximityRangeUOM = "Meters"
objGaatjes1.OutOfRangeName = ""
objGaatjes1.InRangeName = ""
objWitbordjemetroderand = Wherigo.Zone(objToerkeindekampsebossen)
objWitbordjemetroderand.Id = "66438be2-b61e-4cc3-92e5-5e195e510b9a"
objWitbordjemetroderand.Name = _bhFvz("\092\027\105\074\012\005\058\062\020\059\074\038\059\105\074\058\005\062\059\074\058\009\090\062")
objWitbordjemetroderand.Description = ""
objWitbordjemetroderand.Visible = true
objWitbordjemetroderand.Media = objWitRood
objWitbordjemetroderand.Commands = {}
objWitbordjemetroderand.DistanceRange = Distance(-1, "feet")
objWitbordjemetroderand.ShowObjects = "OnEnter"
objWitbordjemetroderand.ProximityRange = Distance(60, "meters")
objWitbordjemetroderand.AllowSetPositionTo = false
objWitbordjemetroderand.Active = false
objWitbordjemetroderand.Points = {
	ZonePoint(51.10956369083, 5.26939809322357, 0), 
	ZonePoint(51.1093414049718, 5.26958048343658, 0), 
	ZonePoint(51.109375084716, 5.26992380619049, 0), 
	ZonePoint(51.1096175781498, 5.26985943317413, 0)
}
objWitbordjemetroderand.OriginalPoint = ZonePoint(51.1094744396669, 5.26969045400619, 0)
objWitbordjemetroderand.DistanceRangeUOM = "Feet"
objWitbordjemetroderand.ProximityRangeUOM = "Meters"
objWitbordjemetroderand.OutOfRangeName = ""
objWitbordjemetroderand.InRangeName = ""
objBrackeBoom = Wherigo.Zone(objToerkeindekampsebossen)
objBrackeBoom.Id = "d49998d8-c37c-4d7c-9573-b07b977f4cf8"
objBrackeBoom.Name = _bhFvz("\056\058\009\079\039\059\074\056\005\005\038")
objBrackeBoom.Description = ""
objBrackeBoom.Visible = true
objBrackeBoom.Commands = {}
objBrackeBoom.DistanceRange = Distance(-1, "feet")
objBrackeBoom.ShowObjects = "OnEnter"
objBrackeBoom.ProximityRange = Distance(60, "meters")
objBrackeBoom.AllowSetPositionTo = false
objBrackeBoom.Active = false
objBrackeBoom.Points = {
	ZonePoint(51.1106582646888, 5.26628136634827, 0), 
	ZonePoint(51.1098398626796, 5.26632964611053, 0), 
	ZonePoint(51.1097455602824, 5.26761710643768, 0), 
	ZonePoint(51.1098769099973, 5.26772975921631, 0)
}
objBrackeBoom.OriginalPoint = ZonePoint(51.110030149412, 5.2669894695282, 0)
objBrackeBoom.DistanceRangeUOM = "Feet"
objBrackeBoom.ProximityRangeUOM = "Meters"
objBrackeBoom.OutOfRangeName = ""
objBrackeBoom.InRangeName = ""
objVleermuiskelder = Wherigo.Zone(objToerkeindekampsebossen)
objVleermuiskelder.Id = "3fe941f6-1c1e-4440-a48e-b59ab70c5b03"
objVleermuiskelder.Name = _bhFvz("\042\014\059\059\058\038\048\027\065\074\039\059\014\062\059\058")
objVleermuiskelder.Description = ""
objVleermuiskelder.Visible = true
objVleermuiskelder.Media = objIjskelder
objVleermuiskelder.Commands = {}
objVleermuiskelder.DistanceRange = Distance(-1, "feet")
objVleermuiskelder.ShowObjects = "OnEnter"
objVleermuiskelder.ProximityRange = Distance(60, "meters")
objVleermuiskelder.AllowSetPositionTo = false
objVleermuiskelder.Active = false
objVleermuiskelder.Points = {
	ZonePoint(51.1117460770232, 5.26739716529846, 0), 
	ZonePoint(51.1112712147261, 5.2674400806427, 0), 
	ZonePoint(51.111274582561, 5.26840567588806, 0), 
	ZonePoint(51.1117359736209, 5.26835203170776, 0)
}
objVleermuiskelder.OriginalPoint = ZonePoint(51.1115069619828, 5.26789873838425, 0)
objVleermuiskelder.DistanceRangeUOM = "Feet"
objVleermuiskelder.ProximityRangeUOM = "Meters"
objVleermuiskelder.OutOfRangeName = ""
objVleermuiskelder.InRangeName = ""

-- Characters --

-- Items --
objUnlockCode = Wherigo.ZItem(objToerkeindekampsebossen)
objUnlockCode.Id = "adb63f70-846e-4986-881e-bbe866564ae2"
objUnlockCode.Name = _bhFvz("\086\090\014\005\079\039\074\021\005\062\059")
objUnlockCode.Description = ""
objUnlockCode.Visible = true
objUnlockCode.Commands = {}
objUnlockCode.ObjectLocation = Wherigo.INVALID_ZONEPOINT
objUnlockCode.Locked = false
objUnlockCode.Opened = false

-- Tasks --
objMilitairkerkhof1 = Wherigo.ZTask(objToerkeindekampsebossen)
objMilitairkerkhof1.Id = "fe6c2f61-941b-4ce6-8de8-a19216455bfb"
objMilitairkerkhof1.Name = _bhFvz("\101\027\014\027\105\009\027\058\074\039\059\058\039\054\005\081")
objMilitairkerkhof1.Description = _bhFvz("\023\009\074\090\009\009\058\074\054\059\105\074\101\027\014\027\105\009\027\058\074\039\059\058\039\054\005\081\074\041\009\090\074\054\059\105\074\023\059\038\059\090\059\012\059\065\105\068")
objMilitairkerkhof1.Visible = true
objMilitairkerkhof1.Active = true
objMilitairkerkhof1.Complete = false
objMilitairkerkhof1.CorrectState = "None"
objGeodetischPunt1 = Wherigo.ZTask(objToerkeindekampsebossen)
objGeodetischPunt1.Id = "8f16ffdd-d767-455c-978c-337ffaa9f84c"
objGeodetischPunt1.Name = _bhFvz("\023\059\005\062\059\105\027\065\079\054\074\099\048\090\105")
objGeodetischPunt1.Description = _bhFvz("\028\005\059\039\074\054\059\105\074\008\059\005\062\059\105\027\065\079\054\074\110\048\090\105\068")
objGeodetischPunt1.Visible = true
objGeodetischPunt1.Active = false
objGeodetischPunt1.Complete = false
objGeodetischPunt1.CorrectState = "None"
objZoekdeholleboom = Wherigo.ZTask(objToerkeindekampsebossen)
objZoekdeholleboom.Id = "5fbd630c-f3f2-48f5-979e-4560a6814280"
objZoekdeholleboom.Name = _bhFvz("\028\005\059\039\074\062\059\074\054\005\014\014\059\074\012\005\005\038\068")
objZoekdeholleboom.Description = ""
objZoekdeholleboom.Visible = true
objZoekdeholleboom.Active = false
objZoekdeholleboom.Complete = false
objZoekdeholleboom.CorrectState = "None"
objZoek2paaltjes = Wherigo.ZTask(objToerkeindekampsebossen)
objZoek2paaltjes.Id = "7fb36153-0a90-4846-964a-46f76db079f2"
objZoek2paaltjes.Name = _bhFvz("\028\005\059\039\074\036\074\110\009\009\014\105\020\059\065\068")
objZoek2paaltjes.Description = _bhFvz("\028\005\059\039\074\062\059\074\036\074\034\027\105\105\059\074\110\009\009\014\105\020\059\065\068")
objZoek2paaltjes.Visible = true
objZoek2paaltjes.Active = false
objZoek2paaltjes.Complete = false
objZoek2paaltjes.CorrectState = "None"
objZoekditmaal3wittepaaltjes = Wherigo.ZTask(objToerkeindekampsebossen)
objZoekditmaal3wittepaaltjes.Id = "003fd0eb-654b-4ae6-956e-b5b31f4b28a8"
objZoekditmaal3wittepaaltjes.Name = _bhFvz("\028\005\059\039\074\062\027\105\038\009\009\014\074\102\074\034\027\105\105\059\074\110\009\009\014\105\020\059\065\068")
objZoekditmaal3wittepaaltjes.Description = _bhFvz("\028\005\059\039\074\062\027\105\038\009\009\014\074\102\074\034\027\105\105\059\074\110\009\009\014\105\020\059\065\068")
objZoekditmaal3wittepaaltjes.Visible = true
objZoekditmaal3wittepaaltjes.Active = false
objZoekditmaal3wittepaaltjes.Complete = false
objZoekditmaal3wittepaaltjes.CorrectState = "None"
objAcaciaboom = Wherigo.ZTask(objToerkeindekampsebossen)
objAcaciaboom.Id = "3f69854f-889a-43cb-97a6-77dc2819d723"
objAcaciaboom.Name = _bhFvz("\007\079\009\079\027\009\012\005\005\038")
objAcaciaboom.Description = _bhFvz("\028\005\059\039\074\062\059\074\007\079\009\079\027\009\012\005\005\038\068")
objAcaciaboom.Visible = true
objAcaciaboom.Active = false
objAcaciaboom.Complete = false
objAcaciaboom.CorrectState = "None"
objGanaardevolgendezone = Wherigo.ZTask(objToerkeindekampsebossen)
objGanaardevolgendezone.Id = "af6fdee3-81d1-40c1-b75d-4093b3b251ef"
objGanaardevolgendezone.Name = _bhFvz("\023\009\074\090\009\009\058\074\062\059\074\041\005\014\008\059\090\062\059\074\108\005\090\059\068")
objGanaardevolgendezone.Description = ""
objGanaardevolgendezone.Visible = true
objGanaardevolgendezone.Active = false
objGanaardevolgendezone.Complete = false
objGanaardevolgendezone.CorrectState = "None"
objOpnaardevolgendeplaats = Wherigo.ZTask(objToerkeindekampsebossen)
objOpnaardevolgendeplaats.Id = "ea6404d8-b7ff-4575-b4e6-e6737b3929e2"
objOpnaardevolgendeplaats.Name = _bhFvz("\084\110\074\090\009\009\058\074\062\059\074\041\005\014\008\059\090\062\059\074\110\014\009\009\105\065\068")
objOpnaardevolgendeplaats.Description = _bhFvz("\028\005\059\039\074\059\059\090\074\034\027\105\074\012\005\058\062\020\059\074\038\059\105\074\058\005\062\059\074\058\009\090\062\069\056\022\066")
objOpnaardevolgendeplaats.Visible = true
objOpnaardevolgendeplaats.Active = false
objOpnaardevolgendeplaats.Complete = false
objOpnaardevolgendeplaats.CorrectState = "None"
objGeelblauwbordje = Wherigo.ZTask(objToerkeindekampsebossen)
objGeelblauwbordje.Id = "c70f5f69-30e4-4c07-b019-09787db383ba"
objGeelblauwbordje.Name = _bhFvz("\023\059\059\014\032\012\014\009\048\034\074\012\005\058\062\020\059\068")
objGeelblauwbordje.Description = _bhFvz("\028\005\059\039\074\059\059\090\074\012\005\005\038\074\038\059\105\074\059\059\090\074\008\059\059\014\032\012\014\009\048\034\074\012\005\058\062\020\059\068")
objGeelblauwbordje.Visible = true
objGeelblauwbordje.Active = false
objGeelblauwbordje.Complete = false
objGeelblauwbordje.CorrectState = "None"
objIjskelder1 = Wherigo.ZTask(objToerkeindekampsebossen)
objIjskelder1.Id = "19b6816d-bf62-42af-aa33-f0aefd8ad68b"
objIjskelder1.Name = _bhFvz("\003\020\065\039\059\014\062\059\058")
objIjskelder1.Description = _bhFvz("\028\005\059\039\074\062\059\074\027\020\065\039\059\014\062\059\058\068")
objIjskelder1.Visible = true
objIjskelder1.Active = false
objIjskelder1.Complete = false
objIjskelder1.CorrectState = "None"
objBelgischmilitairkerkhof = Wherigo.ZTask(objToerkeindekampsebossen)
objBelgischmilitairkerkhof.Id = "3e53aee5-5189-497d-be8c-f033a6802861"
objBelgischmilitairkerkhof.Name = _bhFvz("\056\059\014\008\027\065\079\054\074\038\027\014\027\105\009\027\058\074\039\059\058\039\054\005\081")
objBelgischmilitairkerkhof.Description = _bhFvz("\075\027\090\062\065\074\034\059\014\039\074\020\009\009\058\074\034\005\058\062\105\074\062\027\105\074\039\059\058\039\054\005\081\074\012\059\054\059\059\058\062\074\062\005\005\058\074\062\059\074\062\059\081\059\090\065\027\059\017\074\069\056\022\066")
objBelgischmilitairkerkhof.Visible = true
objBelgischmilitairkerkhof.Active = false
objBelgischmilitairkerkhof.Complete = false
objBelgischmilitairkerkhof.CorrectState = "None"

-- Cartridge Variables --
objAntwoord1 = _bhFvz("\078\035\047\074\056\035\116\023\003\075\021\078\035\074\042\084\116\026")
objAntwoord2 = 59
objAntwoord3 = 2
objAntwoord4 = _bhFvz("\064\084\086\023\116\007\075")
objAntwoord4a = _bhFvz("\056\022\007\021\026\035")
objAntwoord5 = _bhFvz("\101\035\035\086\092\035\002")
objAntwoord6 = 2
objAntwoord7 = 3
objAntwoord8 = 9
objAntwoord9 = _bhFvz("\056\022\007\021\026\035")
objAntwoord10 = 1837
objAntwoord1a = _bhFvz("\056\035\116\023\003\075\021\078\035\074\042\084\116\026")
objAntwoord11 = 2004
objToerkeindekampsebossen.ZVariables = {
	objAntwoord1 = _bhFvz("\078\035\047\074\056\035\116\023\003\075\021\078\035\074\042\084\116\026"), 
	objAntwoord2 = 59, 
	objAntwoord3 = 2, 
	objAntwoord4 = _bhFvz("\064\084\086\023\116\007\075"), 
	objAntwoord4a = _bhFvz("\056\022\007\021\026\035"), 
	objAntwoord5 = _bhFvz("\101\035\035\086\092\035\002"), 
	objAntwoord6 = 2, 
	objAntwoord7 = 3, 
	objAntwoord8 = 9, 
	objAntwoord9 = _bhFvz("\056\022\007\021\026\035"), 
	objAntwoord10 = 1837, 
	objAntwoord1a = _bhFvz("\056\035\116\023\003\075\021\078\035\074\042\084\116\026"), 
	objAntwoord11 = 2004
}

-- Timers --

-- Inputs --
objVraag1 = Wherigo.ZInput(objToerkeindekampsebossen)
objVraag1.Id = "f64ad78a-42a8-4a09-a15b-11930c3c8a40"
objVraag1.Name = _bhFvz("\042\058\009\009\008\074\031")
objVraag1.Description = ""
objVraag1.Visible = true
objVraag1.InputType = "Text"
objVraag1.Text = _bhFvz("\064\005\005\058\074\034\027\059\074\027\065\074\062\059\074\008\058\005\090\062\074\034\009\009\058\005\110\074\062\027\105\074\039\059\058\039\054\005\081\074\108\027\079\054\074\012\059\041\027\090\062\105\074\008\059\065\079\054\005\090\039\059\090\017")
objVraag2 = Wherigo.ZInput(objToerkeindekampsebossen)
objVraag2.Id = "9119ed20-0cbd-4042-a82a-b5c6b9d978db"
objVraag2.Name = _bhFvz("\042\058\009\009\008\074\036")
objVraag2.Description = ""
objVraag2.Visible = true
objVraag2.InputType = "Text"
objVraag2.Text = _bhFvz("\056\005\041\059\090\005\110\074\054\059\105\074\008\059\005\062\059\105\027\065\079\054\074\110\048\090\105\074\065\105\009\009\105\074\059\059\090\074\110\009\009\014\105\020\059\068\069\056\022\066\092\059\014\039\074\008\059\105\009\014\074\065\105\009\009\105\074\054\027\059\058\005\110\017")
objVraag3 = Wherigo.ZInput(objToerkeindekampsebossen)
objVraag3.Id = "db4f9ce5-91fe-4b1c-93a5-f9f8e20aba0a"
objVraag3.Name = _bhFvz("\042\058\009\009\008\074\102")
objVraag3.Description = ""
objVraag3.Visible = true
objVraag3.InputType = "Text"
objVraag3.Text = _bhFvz("\002\027\059\105\074\041\059\058\074\041\009\090\074\054\059\105\074\008\059\005\062\059\105\027\065\079\054\074\110\048\090\105\074\065\105\009\009\105\074\059\059\090\074\008\059\059\014\032\108\034\009\058\105\074\110\009\009\014\105\020\059\074\041\009\090\074\059\059\090\074\034\009\090\062\059\014\027\090\008\068\074\064\027\079\054\105\074\012\027\020\074\062\027\105\074\110\009\009\014\105\020\059\074\065\105\009\009\105\074\059\059\090\074\054\005\014\014\059\074\012\005\005\038\068\074\064\059\074\065\105\009\038\074\041\009\090\074\062\059\108\059\074\012\005\005\038\074\065\110\014\027\105\065\105\074\108\027\079\054\074\005\110\074\027\090\074\068\068\068\074\008\058\005\105\059\074\065\105\009\038\038\059\090\068")
objVraag4 = Wherigo.ZInput(objToerkeindekampsebossen)
objVraag4.Id = "1d49104d-5069-4571-83c5-293022445492"
objVraag4.Name = _bhFvz("\042\058\009\009\008\074\085")
objVraag4.Description = ""
objVraag4.Visible = true
objVraag4.InputType = "Text"
objVraag4.Text = _bhFvz("\078\027\059\058\074\065\105\009\009\105\074\059\059\090\074\012\005\005\038\074\034\009\009\058\005\110\074\062\059\074\009\079\054\105\059\058\090\009\009\038\074\041\009\090\074\059\059\090\074\012\059\039\059\090\062\074\110\059\058\065\005\005\090\074\065\105\009\009\105\068\074\092\009\105\074\027\065\074\062\059\108\059\074\009\079\054\105\059\058\090\009\009\038\017")
objVraag5 = Wherigo.ZInput(objToerkeindekampsebossen)
objVraag5.Id = "ef80f09e-c6dd-4f0f-b8dc-1e0f4fb116f8"
objVraag5.Name = _bhFvz("\042\058\009\009\008\074\088")
objVraag5.Description = ""
objVraag5.Visible = true
objVraag5.InputType = "Text"
objVraag5.Text = _bhFvz("\078\027\059\058\074\039\005\038\105\074\048\074\105\059\058\048\008\074\012\027\020\074\054\059\105\074\039\059\058\039\054\005\081\074\041\009\090\074\054\059\105\074\023\059\038\059\090\059\012\059\065\105\068\074\092\059\014\039\059\074\041\005\008\059\014\065\074\108\027\059\105\074\048\074\054\027\059\058\017")
objVraag6 = Wherigo.ZInput(objToerkeindekampsebossen)
objVraag6.Id = "b375f2ae-42b5-4c0e-b556-27650fe8dc6d"
objVraag6.Name = _bhFvz("\042\058\009\009\008\074\097")
objVraag6.Description = ""
objVraag6.Visible = true
objVraag6.InputType = "Text"
objVraag6.Text = _bhFvz("\078\005\059\041\059\059\014\074\008\059\041\059\058\081\062\059\074\065\105\058\059\110\059\090\074\065\105\009\009\090\074\059\058\074\005\110\074\062\059\074\007\079\009\079\027\009\017")
objVraag7 = Wherigo.ZInput(objToerkeindekampsebossen)
objVraag7.Id = "7e1f9799-07d7-4986-8e1d-737bec69691a"
objVraag7.Name = _bhFvz("\042\058\009\009\008\074\050")
objVraag7.Description = ""
objVraag7.Visible = true
objVraag7.InputType = "Text"
objVraag7.Text = _bhFvz("\028\005\059\039\074\054\027\059\058\074\059\059\090\074\110\009\009\014\105\020\059\074\038\059\105\074\059\059\090\074\058\005\005\062\032\034\027\105\074\110\014\009\039\009\009\105\020\059\068\074\078\005\059\041\059\059\014\074\008\009\009\105\020\059\065\074\038\009\009\039\105\074\062\027\105\074\110\009\009\014\105\020\059\017")
objVraag8 = Wherigo.ZInput(objToerkeindekampsebossen)
objVraag8.Id = "a68cdd90-3402-4568-8a01-53dbf30e5260"
objVraag8.Name = _bhFvz("\042\058\009\009\008\074\124")
objVraag8.Description = ""
objVraag8.Visible = true
objVraag8.InputType = "Text"
objVraag8.Text = _bhFvz("\078\027\059\058\074\012\059\041\027\090\062\105\074\108\027\079\054\074\059\059\090\074\034\027\105\074\012\005\058\062\020\059\074\038\059\105\074\058\005\062\059\074\058\009\090\062\068\069\056\022\066\092\059\014\039\074\008\059\105\009\014\074\039\058\027\020\008\105\074\038\059\090\074\009\014\065\074\038\059\090\074\009\014\074\062\059\074\079\027\020\081\059\058\065\074\005\110\105\059\014\105\017")
objVraag9 = Wherigo.ZInput(objToerkeindekampsebossen)
objVraag9.Id = "9b1d8852-0d90-40c7-8ed5-114db2c4964d"
objVraag9.Name = _bhFvz("\042\058\009\009\008\074\006")
objVraag9.Description = ""
objVraag9.Visible = true
objVraag9.InputType = "Text"
objVraag9.Text = _bhFvz("\028\005\059\039\074\059\059\090\074\012\005\005\038\074\038\059\105\074\059\059\090\074\008\059\059\014\032\012\014\009\048\034\074\012\005\058\062\020\059\068\074\064\059\074\059\059\058\065\105\059\074\108\059\065\074\014\059\105\105\059\058\065\074\041\005\058\038\059\090\074\059\059\090\074\090\009\009\038\068\074\092\059\014\039\059\017")
objVraag10 = Wherigo.ZInput(objToerkeindekampsebossen)
objVraag10.Id = "397105fc-4a9f-40d3-be4e-eb0e3db418a9"
objVraag10.Name = _bhFvz("\042\058\009\009\008\074\031\060")
objVraag10.Description = ""
objVraag10.Visible = true
objVraag10.InputType = "Text"
objVraag10.Text = _bhFvz("\003\090\074\034\059\014\039\074\020\009\009\058\074\027\065\074\062\059\074\027\020\065\039\059\014\062\059\058\074\008\059\012\005\048\034\062\017")
objVraag11 = Wherigo.ZInput(objToerkeindekampsebossen)
objVraag11.Id = "598dcafc-bd75-44fa-b90a-ebad7cc56c6d"
objVraag11.Name = _bhFvz("\042\058\009\009\008\074\031\031")
objVraag11.Description = ""
objVraag11.Visible = true
objVraag11.InputType = "Text"
objVraag11.Text = _bhFvz("\075\027\090\062\065\074\034\059\014\039\074\020\009\009\058\074\034\005\058\062\105\074\062\027\105\074\039\059\058\039\054\005\081\074\012\059\054\059\059\058\062\074\062\005\005\058\074\062\059\074\062\059\081\059\090\065\027\059\017\074")

-- WorksWithList for object commands --

-- functions --
function objToerkeindekampsebossen:OnStart()
end
function objToerkeindekampsebossen:OnRestore()
end
function objMilitairebegraafplaats:OnEnter()
	if objIjskelder1.Active == true then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(objVraag11)
		end)
	end
end
function objMilitairkerkhofGemenebest:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objVraag1)
	end)
end
function objGeodetischpunt:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objVraag2)
	end)
end
function objHolleboom:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objVraag3)
	end)
end
function obj2paaltjes1:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objVraag4)
	end)
end
function obj3paaltjes1:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objVraag5)
	end)
end
function objAcacia:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objVraag6)
	end)
end
function objGaatjes1:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objVraag7)
	end)
end
function objWitbordjemetroderand:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objVraag8)
	end)
end
function objBrackeBoom:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objVraag9)
	end)
end
function objVleermuiskelder:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(objVraag10)
	end)
end
function objVraag1:OnGetInput(input)
	if (Wherigo.NoCaseEquals(input, objAntwoord1) or Wherigo.NoCaseEquals(input, objAntwoord1a)) == true then
		objGeodetischpunt.Active = true
		objGeodetischPunt1.Active = true
		objMilitairkerkhofGemenebest.Active = false
		objMilitairkerkhof1.Complete = true
		_Urwigo.MessageBox{
			Text = _bhFvz("\023\005\059\062\018\074\084\110\074\090\009\009\058\074\054\059\105\074\008\059\005\062\059\105\027\065\079\054\074\099\048\090\105\068")
		}
		objToerkeindekampsebossen:RequestSync()
	elseif (Wherigo.NoCaseEquals(input, objAntwoord1) or Wherigo.NoCaseEquals(input, objAntwoord1a)) == false then
		_Urwigo.MessageBox{
			Text = _bhFvz("\127\005\048\105\018\074\099\058\005\012\059\059\058\074\005\110\090\027\059\048\034\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag1)
					end)
				end
			end
		}
	end
end
function objVraag2:OnGetInput(input)
	if Wherigo.NoCaseEquals(input, tostring(objAntwoord2)) then
		objHolleboom.Active = true
		objGeodetischPunt1.Complete = true
		objZoekdeholleboom.Active = true
		objGeodetischpunt.Active = false
		_Urwigo.MessageBox{
			Text = _bhFvz("\084\110\074\108\005\059\039\074\090\009\009\058\074\062\059\074\054\005\014\014\059\074\012\005\005\038\068")
		}
		objToerkeindekampsebossen:RequestSync()
	elseif input ~= tostring(objAntwoord2) then
		_Urwigo.MessageBox{
			Text = _bhFvz("\127\005\048\105\068\074\099\058\005\012\059\059\058\074\090\005\008\074\059\059\090\065\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag2)
					end)
				end
			end
		}
	end
end
function objVraag3:OnGetInput(input)
	if Wherigo.NoCaseEquals(input, tostring(objAntwoord3)) then
		_Urwigo.MessageBox{
			Text = _bhFvz("\023\005\059\062\068\074\028\005\059\039\074\090\048\074\062\059\074\036\074\034\027\105\105\059\074\110\009\009\014\105\020\059\065\068")
		}
		obj2paaltjes1.Active = true
		objZoek2paaltjes.Active = true
		objZoekdeholleboom.Complete = true
		objHolleboom.Active = false
		objToerkeindekampsebossen:RequestSync()
	elseif input ~= tostring(objAntwoord3) then
		_Urwigo.MessageBox{
			Text = _bhFvz("\127\005\048\105\018\074\099\058\005\012\059\059\058\074\005\110\090\027\059\048\034\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag3)
					end)
				end
			end
		}
	end
end
function objVraag4:OnGetInput(input)
	if Wherigo.NoCaseEquals(input, objAntwoord4) then
		objZoek2paaltjes.Complete = true
		obj3paaltjes1.Active = true
		obj2paaltjes1.Active = false
		objZoekditmaal3wittepaaltjes.Active = true
		_Urwigo.MessageBox{
			Text = _bhFvz("\126\009\034\059\014\074\101\027\079\054\009\059\014\074\064\005\048\008\014\009\065\068\074\084\110\074\090\009\009\058\074\062\059\074\041\005\014\008\059\090\062\059\074\108\005\090\059\074\034\009\009\058\074\020\059\074\062\058\027\059\074\034\027\105\105\059\074\110\009\009\014\105\020\059\065\074\105\059\008\059\090\074\039\005\038\105\068")
		}
		objToerkeindekampsebossen:RequestSync()
	elseif Wherigo.NoCaseEquals(input, objAntwoord4a) then
		_Urwigo.MessageBox{
			Text = _bhFvz("\002\059\059\074\090\027\059\105\074\062\027\059\074\038\059\105\074\108\027\020\090\074\065\105\058\027\039\020\059\068\074\078\059\105\074\027\065\074\059\059\090\074\027\090\105\059\058\090\009\105\027\005\090\009\009\014\074\012\059\039\059\090\062\074\110\059\058\065\005\005\090\068\074\001\090\012\065\110\040\099\058\005\012\059\059\058\074\005\110\090\027\059\048\034\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag4)
					end)
				end
			end
		}
	elseif input ~= tostring((input ~= objAntwoord4) or (input ~= objAntwoord4a)) then
		_Urwigo.MessageBox{
			Text = _bhFvz("\099\058\005\012\059\059\058\074\005\110\074\090\027\059\048\034\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag4)
					end)
				end
			end
		}
	end
end
function objVraag5:OnGetInput(input)
	if Wherigo.NoCaseEquals(input, objAntwoord5) then
		objZoekditmaal3wittepaaltjes.Complete = true
		objAcacia.Active = true
		obj3paaltjes1.Active = false
		objAcaciaboom.Active = true
		_Urwigo.MessageBox{
			Text = _bhFvz("\084\039\018\074\028\005\059\039\074\062\059\074\007\079\009\079\027\009\012\005\005\038\068")
		}
		objToerkeindekampsebossen:RequestSync()
	elseif input ~= objAntwoord5 then
		_Urwigo.MessageBox{
			Text = _bhFvz("\028\059\074\108\027\105\105\059\090\074\005\110\074\054\059\105\074\054\059\039\034\059\058\039\068\069\056\022\066\099\058\005\012\059\059\058\074\005\110\090\027\059\048\034\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag5)
					end)
				end
			end
		}
	end
end
function objVraag6:OnGetInput(input)
	if Wherigo.NoCaseEquals(input, tostring(objAntwoord6)) then
		objAcaciaboom.Complete = true
		objGaatjes1.Active = true
		objAcacia.Active = false
		objGanaardevolgendezone.Active = true
		_Urwigo.MessageBox{
			Text = _bhFvz("\084\110\074\090\009\009\058\074\054\059\105\074\041\005\014\008\059\090\062\059\074\110\048\090\105\068")
		}
	elseif input ~= tostring(objAntwoord6) then
		_Urwigo.MessageBox{
			Text = _bhFvz("\099\058\005\012\059\059\058\074\005\110\090\027\059\048\034\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag6)
					end)
				end
			end
		}
	end
end
function objVraag7:OnGetInput(input)
	if Wherigo.NoCaseEquals(input, tostring(objAntwoord7)) then
		objGanaardevolgendezone.Complete = true
		objGaatjes1.Active = false
		objWitbordjemetroderand.Active = true
		objOpnaardevolgendeplaats.Active = true
		_Urwigo.MessageBox{
			Text = _bhFvz("\023\005\059\062\018\074\028\059\105\074\062\059\074\034\009\090\062\059\014\027\090\008\074\062\005\005\058\074\090\009\009\058\074\062\059\074\041\005\014\008\059\090\062\059\074\108\005\090\059\068")
		}
	elseif input ~= tostring(objAntwoord7) then
		_Urwigo.MessageBox{
			Text = _bhFvz("\127\005\048\105\018\074\099\058\005\012\059\059\058\074\005\110\090\027\059\048\034\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag7)
					end)
				end
			end
		}
	end
end
function objVraag8:OnGetInput(input)
	if Wherigo.NoCaseEquals(input, tostring(objAntwoord8)) then
		objOpnaardevolgendeplaats.Complete = true
		objBrackeBoom.Active = true
		objWitbordjemetroderand.Active = false
		objGeelblauwbordje.Active = true
		_Urwigo.MessageBox{
			Text = _bhFvz("\023\009\074\090\009\009\058\074\062\059\074\041\005\014\008\059\090\062\059\074\108\005\090\059\074\059\090\074\108\005\059\039\074\059\059\090\074\012\005\005\038\074\038\059\105\074\059\059\090\074\008\059\059\014\032\012\014\009\048\034\074\012\005\058\062\020\059\068")
		}
		objToerkeindekampsebossen:RequestSync()
	elseif input ~= tostring(objAntwoord8) then
		_Urwigo.MessageBox{
			Text = _bhFvz("\127\005\048\105\070\074\020\059\074\038\005\059\105\074\059\059\090\074\041\027\059\058\039\009\090\105\074\012\005\058\062\020\059\074\108\005\059\039\059\090\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag8)
					end)
				end
			end
		}
	end
end
function objVraag9:OnGetInput(input)
	if Wherigo.NoCaseEquals(input, objAntwoord9) then
		objGeelblauwbordje.Complete = true
		objBrackeBoom.Active = false
		objVleermuiskelder.Active = true
		objIjskelder1.Active = true
		_Urwigo.MessageBox{
			Text = _bhFvz("\126\048\027\065\105\068\074\028\005\059\039\074\062\059\074\027\020\065\039\059\014\062\059\058\068")
		}
		objToerkeindekampsebossen:RequestSync()
	elseif input ~= objAntwoord9 then
		_Urwigo.MessageBox{
			Text = _bhFvz("\127\005\048\105\070\074\110\058\005\012\059\059\058\074\005\110\090\027\059\048\034\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag9)
					end)
				end
			end
		}
	end
end
function objVraag10:OnGetInput(input)
	if Wherigo.NoCaseEquals(input, tostring(objAntwoord10)) then
		objIjskelder1.Complete = true
		objVleermuiskelder.Active = false
		objMilitairebegraafplaats.Active = true
		objBelgischmilitairkerkhof.Active = true
		_Urwigo.MessageBox{
			Text = _bhFvz("\023\009\074\090\009\009\058\074\054\059\105\074\012\059\014\008\027\065\079\054\074\038\027\014\027\105\009\027\058\074\039\059\058\039\054\005\081\068\074\075\027\090\062\065\074\034\059\014\039\074\020\009\009\058\074\034\005\058\062\105\074\062\027\105\074\039\059\058\039\054\005\081\074\012\059\054\059\059\058\062\074\062\005\005\058\074\062\059\074\062\059\081\059\090\065\027\059\017\074")
		}
		objToerkeindekampsebossen:RequestSync()
	elseif input ~= tostring(objAntwoord10) then
		_Urwigo.MessageBox{
			Text = _bhFvz("\099\058\005\012\059\059\058\074\005\110\090\027\059\048\034\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag10)
					end)
				end
			end
		}
	end
end
function objVraag11:OnGetInput(input)
	if Wherigo.NoCaseEquals(input, tostring(objAntwoord11)) then
		objToerkeindekampsebossen.Complete = true
		objMilitairebegraafplaats.Active = false
		_Urwigo.MessageBox{
			Text = _bhFvz("\099\058\005\081\027\079\027\009\105\068\074\064\059\074\048\090\014\005\079\039\079\005\062\059\074\027\065\074\010")..string.sub(Player.CompletionCode, 1, 15)
		}
		objUnlockCode:MoveTo(Player)
	elseif input ~= tostring(objAntwoord11) then
		_Urwigo.MessageBox{
			Text = _bhFvz("\099\058\005\012\059\059\058\074\005\110\090\027\059\048\034\068"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(objVraag11)
					end)
				end
			end
		}
	end
end
function objUnlockCode:OnClick()
	_Urwigo.MessageBox{
		Text = string.sub(Player.CompletionCode, 1, 15)
	}
end
return objToerkeindekampsebossen
