require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

cartAroundtheRiver = Wherigo.ZCartridge()

-- String decode --
function _XQxqd(str)
	local res = ""
    local dtable = "\079\038\026\092\008\084\085\005\100\023\037\095\118\114\049\030\031\015\022\111\078\009\050\104\073\099\101\088\048\010\024\077\021\126\121\067\064\125\011\062\017\004\120\063\044\115\087\103\124\119\046\057\107\105\071\025\019\116\108\032\074\091\112\014\020\069\006\001\016\042\068\034\054\082\041\060\039\072\076\083\094\012\013\053\098\065\102\052\110\106\086\058\045\055\051\122\109\007\070\002\047\033\036\117\096\081\003\090\035\061\089\043\080\123\066\093\000\028\040\113\097\056\029\027\018\059\075"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
zmediadrowningswimmer = Wherigo.ZMedia(cartAroundtheRiver)
zmediadrowningswimmer.Id = "fa849d75-9023-4f29-a578-1d11d301b35a"
zmediadrowningswimmer.Name = _XQxqd("\009\014\020\050\089\054\089\048\060\046\050\054\097\097\027\014")
zmediadrowningswimmer.Description = ""
zmediadrowningswimmer.AltText = ""
zmediadrowningswimmer.Resources = {
	{
		Type = "jpg", 
		Filename = "drowning-swimmer-at-a-lake-in-summer.jpg", 
		Directives = {}
	}
}
zmediaswimmer = Wherigo.ZMedia(cartAroundtheRiver)
zmediaswimmer.Id = "22aa58a6-8c98-439e-a1fb-fbf4d065974a"
zmediaswimmer.Name = _XQxqd("\046\050\054\097\097\027\014")
zmediaswimmer.Description = ""
zmediaswimmer.AltText = ""
zmediaswimmer.Resources = {
	{
		Type = "JPG", 
		Filename = "swimmer.JPG", 
		Directives = {}
	}
}
zmediaCacheowner = Wherigo.ZMedia(cartAroundtheRiver)
zmediaCacheowner.Id = "4abb09dd-3b44-4314-8066-5f7293ec10e9"
zmediaCacheowner.Name = _XQxqd("\036\121\026\024\027\060\020\050\089\027\014")
zmediaCacheowner.Description = ""
zmediaCacheowner.AltText = ""
zmediaCacheowner.Resources = {
	{
		Type = "JPG", 
		Filename = "DSCF1097_edited.JPG", 
		Directives = {}
	}
}
zmediacode = Wherigo.ZMedia(cartAroundtheRiver)
zmediacode.Id = "49a60486-fc6e-4d8f-b7bf-c262cb481995"
zmediacode.Name = _XQxqd("\026\020\009\027")
zmediacode.Description = ""
zmediacode.AltText = ""
zmediacode.Resources = {
	{
		Type = "gif", 
		Filename = "parchment_code.gif", 
		Directives = {}
	}
}
zmedialifering = Wherigo.ZMedia(cartAroundtheRiver)
zmedialifering.Id = "4eff2011-6ab8-41e2-a0b6-6c0ce10505c8"
zmedialifering.Name = _XQxqd("\059\054\087\027\060\014\054\089\048")
zmedialifering.Description = ""
zmedialifering.AltText = ""
zmedialifering.Resources = {
	{
		Type = "jpg", 
		Filename = "Life_Ring.jpg", 
		Directives = {}
	}
}
zmediaclue = Wherigo.ZMedia(cartAroundtheRiver)
zmediaclue.Id = "037abc74-d226-49e3-bd75-5de3acf942d0"
zmediaclue.Name = _XQxqd("\026\059\104\027")
zmediaclue.Description = ""
zmediaclue.AltText = ""
zmediaclue.Resources = {
	{
		Type = "gif", 
		Filename = "clue.gif", 
		Directives = {}
	}
}
zmediariver = Wherigo.ZMedia(cartAroundtheRiver)
zmediariver.Id = "89e95cdb-a9f6-404d-9579-acd7ce1817b0"
zmediariver.Name = _XQxqd("\014\054\013\027\014")
zmediariver.Description = ""
zmediariver.AltText = ""
zmediariver.Resources = {
	{
		Type = "jpg", 
		Filename = "River_Nidd.jpg", 
		Directives = {}
	}
}
zmediaconyngham = Wherigo.ZMedia(cartAroundtheRiver)
zmediaconyngham.Id = "b1a0155d-87fa-47b2-ac78-2f9bda622f4a"
zmediaconyngham.Name = _XQxqd("\026\020\089\035\089\048\024\121\097")
zmediaconyngham.Description = ""
zmediaconyngham.AltText = ""
zmediaconyngham.Resources = {
	{
		Type = "jpg", 
		Filename = "ConynghamHall.jpg", 
		Directives = {}
	}
}
zmediahenshaws = Wherigo.ZMedia(cartAroundtheRiver)
zmediahenshaws.Id = "c112dae5-fd22-4bc5-ae4e-eca2bc293a15"
zmediahenshaws.Name = _XQxqd("\024\027\089\046\024\121\050\046")
zmediahenshaws.Description = ""
zmediahenshaws.AltText = ""
zmediahenshaws.Resources = {
	{
		Type = "jpg", 
		Filename = "front_entrance.jpg", 
		Directives = {}
	}
}
zmediacastle = Wherigo.ZMedia(cartAroundtheRiver)
zmediacastle.Id = "8a67e48f-781d-4464-8cc1-dd262874631e"
zmediacastle.Name = _XQxqd("\026\121\046\058\059\027")
zmediacastle.Description = ""
zmediacastle.AltText = ""
zmediacastle.Resources = {
	{
		Type = "jpg", 
		Filename = "knaresborough-castle1.jpg", 
		Directives = {}
	}
}
zmediacafe = Wherigo.ZMedia(cartAroundtheRiver)
zmediacafe.Id = "59481c38-846b-47fe-bfdf-c222824fb8ce"
zmediacafe.Name = _XQxqd("\026\121\087\027")
zmediacafe.Description = ""
zmediacafe.AltText = ""
zmediacafe.Resources = {
	{
		Type = "jpg", 
		Filename = "2310079241_9bcfafcf38_s.jpg", 
		Directives = {}
	}
}
zmediastjohns = Wherigo.ZMedia(cartAroundtheRiver)
zmediastjohns.Id = "34fbfeab-38cd-4ca6-87b0-2365e35e64bc"
zmediastjohns.Name = _XQxqd("\046\058\060\090\020\024\089\046")
zmediastjohns.Description = ""
zmediastjohns.AltText = ""
zmediastjohns.Resources = {
	{
		Type = "jpg", 
		Filename = "4991316292_99e6f3c077.jpg", 
		Directives = {}
	}
}
zmedialibrary = Wherigo.ZMedia(cartAroundtheRiver)
zmedialibrary.Id = "1b12cc42-65f8-49df-88ae-1becab3620a0"
zmedialibrary.Name = _XQxqd("\059\054\085\014\121\014\035")
zmedialibrary.Description = ""
zmedialibrary.AltText = ""
zmedialibrary.Resources = {
	{
		Type = "jpg", 
		Filename = "images.jpg", 
		Directives = {}
	}
}
zmediastation = Wherigo.ZMedia(cartAroundtheRiver)
zmediastation.Id = "6c46561c-33d9-4774-90ea-a2ab2b659084"
zmediastation.Name = _XQxqd("\046\058\121\058\054\020\089")
zmediastation.Description = ""
zmediastation.AltText = ""
zmediastation.Resources = {
	{
		Type = "jpg", 
		Filename = "images1.jpg", 
		Directives = {}
	}
}
zmediaviaduct = Wherigo.ZMedia(cartAroundtheRiver)
zmediaviaduct.Id = "94245a8b-a8d7-4ce5-bf75-bd5e3c6cdf19"
zmediaviaduct.Name = _XQxqd("\013\054\121\009\104\026\058")
zmediaviaduct.Description = ""
zmediaviaduct.AltText = ""
zmediaviaduct.Resources = {
	{
		Type = "jpg", 
		Filename = "images2.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
cartAroundtheRiver.Id="529cd972-09b1-47d9-a651-a2147680b895"
cartAroundtheRiver.Name="Around the River"
cartAroundtheRiver.Description=[[I did this in spare time. it took about 16 hours. WARNING: DO NOT try this at home]]
cartAroundtheRiver.Visible=true
cartAroundtheRiver.Activity="Geocache"
cartAroundtheRiver.StartingLocationDescription=[[]]
cartAroundtheRiver.StartingLocation = ZonePoint(54.010851,-1.4742064,0)
cartAroundtheRiver.Version="the only version"
cartAroundtheRiver.Company=""
cartAroundtheRiver.Author="Thomas Butler AKA Tb942"
cartAroundtheRiver.BuilderVersion="URWIGO 1.12.4281.38707"
cartAroundtheRiver.CreateDate="08/31/2011 17:09:14"
cartAroundtheRiver.PublishDate="1/1/0001 12:00:00 AM"
cartAroundtheRiver.UpdateDate="01/17/2012 16:36:40"
cartAroundtheRiver.LastPlayedDate="1/1/0001 12:00:00 AM"
cartAroundtheRiver.TargetDevice="PocketPC"
cartAroundtheRiver.TargetDeviceVersion="0"
cartAroundtheRiver.StateId="1"
cartAroundtheRiver.CountryId="2"
cartAroundtheRiver.Complete=false
cartAroundtheRiver.UseLogging=true

cartAroundtheRiver.Media=zmediariver


-- Zones --
zonehenshaws = Wherigo.Zone(cartAroundtheRiver)
zonehenshaws.Id = "25332ef0-5f91-4661-a64e-f77e5dced2d0"
zonehenshaws.Name = _XQxqd("\024\027\089\046\024\121\050\046")
zonehenshaws.Description = _XQxqd("\006\024\054\046\060\085\014\121\089\026\024\060\020\087\060\024\027\089\046\024\121\050\046\060\046\026\024\020\020\059\060\087\020\014\060\013\054\046\104\121\059\059\035\060\054\097\063\121\014\027\009\060\063\027\020\063\059\027\060\054\046\060\058\024\027\060\121\014\058\046\060\121\089\009\060\026\014\121\087\058\046\060\026\027\089\058\027\014\060")
zonehenshaws.Visible = false
zonehenshaws.Media = zmediahenshaws
zonehenshaws.Commands = {}
zonehenshaws.DistanceRange = Distance(1500, "feet")
zonehenshaws.ShowObjects = "OnEnter"
zonehenshaws.ProximityRange = Distance(200, "feet")
zonehenshaws.AllowSetPositionTo = false
zonehenshaws.Active = true
zonehenshaws.Points = {
	ZonePoint(54.01087, -1.47423, 0), 
	ZonePoint(54.01087, -1.47418, 0), 
	ZonePoint(54.01084, -1.47418, 0), 
	ZonePoint(54.01084, -1.47423, 0)
}
zonehenshaws.OriginalPoint = ZonePoint(54.010852, -1.474206, 0)
zonehenshaws.DistanceRangeUOM = "Feet"
zonehenshaws.ProximityRangeUOM = "Feet"
zonehenshaws.OutOfRangeName = ""
zonehenshaws.InRangeName = ""
zonehenshawspath = Wherigo.Zone(cartAroundtheRiver)
zonehenshawspath.Id = "fce7dea7-b870-4928-b5a2-52c0e3f0b70f"
zonehenshawspath.Name = _XQxqd("\024\027\089\046\024\121\050\046\060\063\121\058\024")
zonehenshawspath.Description = _XQxqd("\048\020\060\009\020\050\089\060\058\024\027\060\063\121\058\024\060\121\089\009\060\087\054\089\009\060\058\024\027\060\050\020\020\009\027\089\060\063\020\046\058\060\054\087\060\054\058\060\054\046\060\089\020\058\060\121\058\060\058\024\027\060\059\020\026\121\058\054\020\089\045\060\059\020\020\053\060\087\020\014\060\054\058\060\121\089\009\060\058\121\053\027\060\089\020\058\027\060\020\087\060\050\024\121\058\060\054\058\060\046\121\035\046\051")
zonehenshawspath.Visible = false
zonehenshawspath.Commands = {}
zonehenshawspath.DistanceRange = Distance(1500, "feet")
zonehenshawspath.ShowObjects = "OnEnter"
zonehenshawspath.ProximityRange = Distance(200, "feet")
zonehenshawspath.AllowSetPositionTo = false
zonehenshawspath.Active = true
zonehenshawspath.Points = {
	ZonePoint(54.0119025550481, -1.47617731779098, 0), 
	ZonePoint(54.0118678805677, -1.47600562698358, 0), 
	ZonePoint(54.0118031522318, -1.47600294477456, 0), 
	ZonePoint(54.0118, -1.47618, 0)
}
zonehenshawspath.OriginalPoint = ZonePoint(54.011832, -1.476124, 0)
zonehenshawspath.DistanceRangeUOM = "Feet"
zonehenshawspath.ProximityRangeUOM = "Feet"
zonehenshawspath.OutOfRangeName = ""
zonehenshawspath.InRangeName = ""
zonebehindConynghamHall = Wherigo.Zone(cartAroundtheRiver)
zonebehindConynghamHall.Id = "bfe7de7b-335f-4b12-afb1-e39c53acb06e"
zonebehindConynghamHall.Name = _XQxqd("\085\027\024\054\089\009\060\036\020\089\035\089\048\024\121\097\060\078\121\059\059")
zonebehindConynghamHall.Description = _XQxqd("\060\086\060\089\020\014\058\024\060\035\020\014\053\046\024\054\014\027\060\026\020\104\089\058\035\060\026\020\104\089\026\054\059\060\026\121\014\060\063\121\014\053")
zonebehindConynghamHall.Visible = false
zonebehindConynghamHall.Media = zmediaconyngham
zonebehindConynghamHall.Commands = {}
zonebehindConynghamHall.DistanceRange = Distance(1500, "feet")
zonebehindConynghamHall.ShowObjects = "OnEnter"
zonebehindConynghamHall.ProximityRange = Distance(200, "feet")
zonebehindConynghamHall.AllowSetPositionTo = false
zonebehindConynghamHall.Active = true
zonebehindConynghamHall.Points = {
	ZonePoint(54.0115736418749, -1.47916536441801, 0), 
	ZonePoint(54.011554728376, -1.47903562698366, 0), 
	ZonePoint(54.01151, -1.47910000000002, 0), 
	ZonePoint(54.0115115761269, -1.47923778406141, 0)
}
zonebehindConynghamHall.OriginalPoint = ZonePoint(54.011534, -1.479128, 0)
zonebehindConynghamHall.DistanceRangeUOM = "Feet"
zonebehindConynghamHall.ProximityRangeUOM = "Feet"
zonebehindConynghamHall.OutOfRangeName = ""
zonebehindConynghamHall.InRangeName = ""
zonethebridge = Wherigo.Zone(cartAroundtheRiver)
zonethebridge.Id = "12ee43ac-29ed-43bb-9ab7-f63f5a5f0fd7"
zonethebridge.Name = _XQxqd("\058\024\027\060\085\014\054\009\048\027")
zonethebridge.Description = _XQxqd("\121\060\085\027\121\104\058\054\087\104\059\060\059\054\058\058\059\027\060\085\014\054\009\048\027")
zonethebridge.Visible = false
zonethebridge.Commands = {}
zonethebridge.DistanceRange = Distance(1500, "feet")
zonethebridge.ShowObjects = "OnEnter"
zonethebridge.ProximityRange = Distance(200, "feet")
zonethebridge.AllowSetPositionTo = false
zonethebridge.Active = true
zonethebridge.Points = {
	ZonePoint(54.0122211979381, -1.47930510185245, 0), 
	ZonePoint(54.0121534255822, -1.47900320734027, 0), 
	ZonePoint(54.01195, -1.47908635581973, 0), 
	ZonePoint(54.0119909788473, -1.47938020370486, 0)
}
zonethebridge.OriginalPoint = ZonePoint(54.01198, -1.479187, 0)
zonethebridge.DistanceRangeUOM = "Feet"
zonethebridge.ProximityRangeUOM = "Feet"
zonethebridge.OutOfRangeName = ""
zonethebridge.InRangeName = ""
zoneriverview = Wherigo.Zone(cartAroundtheRiver)
zoneriverview.Id = "cac63432-9df7-4138-80f9-25cd8cc8fdce"
zoneriverview.Name = _XQxqd("\014\054\013\027\014\060\013\054\027\050")
zoneriverview.Description = _XQxqd("\058\121\053\027\060\121\060\046\027\121\058\060\121\089\009\060\027\089\090\020\035\060\058\024\027\060\046\026\027\089\027\014\035")
zoneriverview.Visible = false
zoneriverview.Commands = {}
zoneriverview.DistanceRange = Distance(1500, "feet")
zoneriverview.ShowObjects = "OnEnter"
zoneriverview.ProximityRange = Distance(200, "feet")
zoneriverview.AllowSetPositionTo = false
zoneriverview.Active = true
zoneriverview.Points = {
	ZonePoint(54.0102178808802, -1.47989268220908, 0), 
	ZonePoint(54.010239947337, -1.47974099140174, 0), 
	ZonePoint(54.0101253240676, -1.47974099140174, 0), 
	ZonePoint(54.01016, -1.47989000000007, 0)
}
zoneriverview.OriginalPoint = ZonePoint(54.010185, -1.479844, 0)
zoneriverview.DistanceRangeUOM = "Feet"
zoneriverview.ProximityRangeUOM = "Feet"
zoneriverview.OutOfRangeName = ""
zoneriverview.InRangeName = ""
zonehighandlow = Wherigo.Zone(cartAroundtheRiver)
zonehighandlow.Id = "abd95892-2124-4855-bab9-ee04d3ad1607"
zonehighandlow.Name = _XQxqd("\024\054\048\024\060\121\089\009\060\059\020\050")
zonehighandlow.Description = _XQxqd("\121\089\020\058\024\027\014\060\120\104\027\046\058\054\020\089\060\121\050\121\054\058\046\102")
zonehighandlow.Visible = false
zonehighandlow.Commands = {}
zonehighandlow.DistanceRange = Distance(1500, "feet")
zonehighandlow.ShowObjects = "OnEnter"
zonehighandlow.ProximityRange = Distance(200, "feet")
zonehighandlow.AllowSetPositionTo = false
zonehighandlow.Active = true
zonehighandlow.Points = {
	ZonePoint(54.0122657609863, -1.48090755092619, 0), 
	ZonePoint(54.012278369771, -1.48075781349189, 0), 
	ZonePoint(54.0121889672928, -1.48075781349189, 0), 
	ZonePoint(54.0121574452562, -1.48092364418028, 0)
}
zonehighandlow.OriginalPoint = ZonePoint(54.012229, -1.480829, 0)
zonehighandlow.DistanceRangeUOM = "Feet"
zonehighandlow.ProximityRangeUOM = "Feet"
zonehighandlow.OutOfRangeName = ""
zonehighandlow.InRangeName = ""
zoneConynghamcarpark = Wherigo.Zone(cartAroundtheRiver)
zoneConynghamcarpark.Id = "2e3b2313-9b38-41a6-9328-652b6cfc92e6"
zoneConynghamcarpark.Name = _XQxqd("\036\020\089\035\089\048\024\121\097\060\026\121\014\060\063\121\014\053")
zoneConynghamcarpark.Description = _XQxqd("\006\024\054\046\060\054\046\060\058\024\027\060\097\020\104\058\024\060\020\087\060\058\024\027\060\026\121\014\063\121\014\053\060\054\089\060\050\024\054\026\024\060\035\020\104\060\046\024\020\104\059\009\060\024\121\013\027\060\063\121\014\053\027\009\051")
zoneConynghamcarpark.Visible = false
zoneConynghamcarpark.Commands = {}
zoneConynghamcarpark.DistanceRange = Distance(1500, "feet")
zoneConynghamcarpark.ShowObjects = "OnEnter"
zoneConynghamcarpark.ProximityRange = Distance(200, "feet")
zoneConynghamcarpark.AllowSetPositionTo = false
zoneConynghamcarpark.Active = true
zoneConynghamcarpark.Points = {
	ZonePoint(54.00948, -1.47494, 0), 
	ZonePoint(54.00948, -1.47485, 0), 
	ZonePoint(54.00943, -1.47485, 0), 
	ZonePoint(54.00943, -1.47494, 0)
}
zoneConynghamcarpark.OriginalPoint = ZonePoint(54.009457, -1.474896, 0)
zoneConynghamcarpark.DistanceRangeUOM = "Feet"
zoneConynghamcarpark.ProximityRangeUOM = "Feet"
zoneConynghamcarpark.OutOfRangeName = ""
zoneConynghamcarpark.InRangeName = ""
zoneprettygardens = Wherigo.Zone(cartAroundtheRiver)
zoneprettygardens.Id = "10b40282-210b-4ff3-96bd-9e7ba407ee6d"
zoneprettygardens.Name = _XQxqd("\063\014\027\058\058\035\060\048\121\014\009\027\089\046")
zoneprettygardens.Description = _XQxqd("\006\024\054\046\060\054\046\060\121\060\085\027\121\104\058\054\087\104\059\060\048\121\014\009\027\089\060\020\089\060\058\024\027\060\014\054\013\027\014\060\085\121\089\053\051")
zoneprettygardens.Visible = false
zoneprettygardens.Commands = {}
zoneprettygardens.DistanceRange = Distance(1500, "feet")
zoneprettygardens.ShowObjects = "OnEnter"
zoneprettygardens.ProximityRange = Distance(200, "feet")
zoneprettygardens.AllowSetPositionTo = false
zoneprettygardens.Active = true
zoneprettygardens.Points = {
	ZonePoint(54.0093386547262, -1.47432075595862, 0), 
	ZonePoint(54.0092362010021, -1.47383402215951, 0), 
	ZonePoint(54.0090442896349, -1.47390644180291, 0), 
	ZonePoint(54.0091152194902, -1.47441463327414, 0), 
	ZonePoint(54.0093010192236, -1.47426246148109, 0)
}
zoneprettygardens.OriginalPoint = ZonePoint(54.009132, -1.473437, 0)
zoneprettygardens.DistanceRangeUOM = "Feet"
zoneprettygardens.ProximityRangeUOM = "Feet"
zoneprettygardens.OutOfRangeName = ""
zoneprettygardens.InRangeName = ""
zoneTheviaduct = Wherigo.Zone(cartAroundtheRiver)
zoneTheviaduct.Id = "329d8e74-ffe2-4ffa-8bdf-5f1213fb4f64"
zoneTheviaduct.Name = _XQxqd("\006\024\027\060\013\054\121\009\104\026\058")
zoneTheviaduct.Description = _XQxqd("\006\024\027\060\046\035\097\085\020\059\060\020\087\060\127\089\121\014\027\046\085\020\014\020\104\048\024\051\060\058\024\027\060\013\054\121\009\104\026\058")
zoneTheviaduct.Visible = false
zoneTheviaduct.Media = zmediaviaduct
zoneTheviaduct.Commands = {}
zoneTheviaduct.DistanceRange = Distance(1500, "feet")
zoneTheviaduct.ShowObjects = "OnEnter"
zoneTheviaduct.ProximityRange = Distance(200, "feet")
zoneTheviaduct.AllowSetPositionTo = false
zoneTheviaduct.Active = true
zoneTheviaduct.Points = {
	ZonePoint(54.0085604396682, -1.47115198280335, 0), 
	ZonePoint(54.0084768989345, -1.47100711408621, 0), 
	ZonePoint(54.0084105939099, -1.47112244907385, 0), 
	ZonePoint(54.00846891491, -1.47128877546311, 0)
}
zoneTheviaduct.OriginalPoint = ZonePoint(54.008477, -1.471217, 0)
zoneTheviaduct.DistanceRangeUOM = "Feet"
zoneTheviaduct.ProximityRangeUOM = "Feet"
zoneTheviaduct.OutOfRangeName = ""
zoneTheviaduct.InRangeName = ""
zonethecafe = Wherigo.Zone(cartAroundtheRiver)
zonethecafe.Id = "729b0de8-400a-4470-a151-0cecc8086de3"
zonethecafe.Name = _XQxqd("\058\024\027\060\026\121\087\027")
zonethecafe.Description = _XQxqd("\121\060\013\027\014\035\060\085\104\046\035\060\026\121\087\027\060\050\054\058\024\060\013\027\014\035\060\087\014\054\027\089\009\059\035\060\046\058\121\087\087\051")
zonethecafe.Visible = false
zonethecafe.Media = zmediacafe
zonethecafe.Commands = {}
zonethecafe.DistanceRange = Distance(1500, "feet")
zonethecafe.ShowObjects = "OnEnter"
zonethecafe.ProximityRange = Distance(200, "feet")
zonethecafe.AllowSetPositionTo = false
zonethecafe.Active = true
zonethecafe.Points = {
	ZonePoint(54.0079157116549, -1.47027072883611, 0), 
	ZonePoint(54.0078826101167, -1.47011099140173, 0), 
	ZonePoint(54.0078026610624, -1.47013513128286, 0), 
	ZonePoint(54.00782, -1.47026000000005, 0)
}
zonethecafe.OriginalPoint = ZonePoint(54.007843, -1.470218, 0)
zonethecafe.DistanceRangeUOM = "Feet"
zonethecafe.ProximityRangeUOM = "Feet"
zonethecafe.OutOfRangeName = ""
zonethecafe.InRangeName = ""
zoneThecarpark = Wherigo.Zone(cartAroundtheRiver)
zoneThecarpark.Id = "af526122-04cc-4958-8341-771d8200e0ec"
zoneThecarpark.Name = _XQxqd("\006\024\027\060\026\121\014\063\121\014\053")
zoneThecarpark.Description = _XQxqd("\086\060\063\027\014\087\027\026\058\060\026\121\014\063\121\014\053\060\087\020\014\060\050\121\059\053\054\089\048\060\009\020\050\089\060\050\121\058\027\014\046\054\009\027\051")
zoneThecarpark.Visible = false
zoneThecarpark.Commands = {}
zoneThecarpark.DistanceRange = Distance(1500, "feet")
zoneThecarpark.ShowObjects = "OnEnter"
zoneThecarpark.ProximityRange = Distance(200, "feet")
zoneThecarpark.AllowSetPositionTo = false
zoneThecarpark.Active = true
zoneThecarpark.Points = {
	ZonePoint(54.0056457634937, -1.47090900859837, 0), 
	ZonePoint(54.0056930539391, -1.47070390674594, 0), 
	ZonePoint(54.00555, -1.47072000000003, 0), 
	ZonePoint(54.00555, -1.47085000000004, 0)
}
zoneThecarpark.OriginalPoint = ZonePoint(54.005592, -1.470784, 0)
zoneThecarpark.DistanceRangeUOM = "Feet"
zoneThecarpark.ProximityRangeUOM = "Feet"
zoneThecarpark.OutOfRangeName = ""
zoneThecarpark.InRangeName = ""
zoneBaseofabighill = Wherigo.Zone(cartAroundtheRiver)
zoneBaseofabighill.Id = "dc691ed6-9f25-4bd2-a3c7-6717ca403b2a"
zoneBaseofabighill.Name = _XQxqd("\115\121\046\027\060\020\087\060\121\060\085\054\048\060\024\054\059\059")
zoneBaseofabighill.Description = _XQxqd("\058\024\054\046\060\054\046\060\058\024\027\060\085\121\046\027\060\020\087\060\026\121\046\058\059\027\060\054\089\048\046\060\014\020\121\009\045\060\050\024\054\026\024\060\058\024\027\089\060\058\104\014\089\046\060\054\089\058\020\060\085\014\027\050\027\014\058\020\089\060\046\058\014\027\027\058\060\046\020\097\027\050\024\027\014\027\060\104\063")
zoneBaseofabighill.Visible = false
zoneBaseofabighill.Commands = {}
zoneBaseofabighill.DistanceRange = Distance(1500, "feet")
zoneBaseofabighill.ShowObjects = "OnEnter"
zoneBaseofabighill.ProximityRange = Distance(200, "feet")
zoneBaseofabighill.AllowSetPositionTo = false
zoneBaseofabighill.Active = true
zoneBaseofabighill.Points = {
	ZonePoint(54.00403, -1.46899, 0), 
	ZonePoint(54.00403, -1.46893, 0), 
	ZonePoint(54.004, -1.46893, 0), 
	ZonePoint(54.004, -1.46899, 0)
}
zoneBaseofabighill.OriginalPoint = ZonePoint(54.004019, -1.46896, 0)
zoneBaseofabighill.DistanceRangeUOM = "Feet"
zoneBaseofabighill.ProximityRangeUOM = "Feet"
zoneBaseofabighill.OutOfRangeName = ""
zoneBaseofabighill.InRangeName = ""
zonehalfwayup = Wherigo.Zone(cartAroundtheRiver)
zonehalfwayup.Id = "8a96cb25-d29e-4428-abff-afe56a5f104e"
zonehalfwayup.Name = _XQxqd("\024\121\059\087\093\050\121\035\060\104\063")
zonehalfwayup.Description = _XQxqd("\035\020\104\077\014\027\060\024\121\059\087\060\050\121\035\060\058\024\027\014\027\060\009\020\089\077\058\060\048\054\013\027\060\104\063\102")
zonehalfwayup.Visible = false
zonehalfwayup.Commands = {}
zonehalfwayup.DistanceRange = Distance(1500, "feet")
zonehalfwayup.ShowObjects = "OnEnter"
zonehalfwayup.ProximityRange = Distance(200, "feet")
zonehalfwayup.AllowSetPositionTo = false
zonehalfwayup.Active = true
zonehalfwayup.Points = {
	ZonePoint(54.00603, -1.46874, 0), 
	ZonePoint(54.00603, -1.46852, 0), 
	ZonePoint(54.0059, -1.46852, 0), 
	ZonePoint(54.0059, -1.46874, 0)
}
zonehalfwayup.OriginalPoint = ZonePoint(54.005962, -1.468627, 0)
zonehalfwayup.DistanceRangeUOM = "Feet"
zonehalfwayup.ProximityRangeUOM = "Feet"
zonehalfwayup.OutOfRangeName = ""
zonehalfwayup.InRangeName = ""
zonefinalyatthetop = Wherigo.Zone(cartAroundtheRiver)
zonefinalyatthetop.Id = "1e168487-89f6-452d-8839-f63e7a6aabd0"
zonefinalyatthetop.Name = _XQxqd("\087\054\089\121\059\035\060\121\058\060\058\024\027\060\058\020\063\102\102")
zonefinalyatthetop.Description = _XQxqd("\087\054\089\121\059\035\102\102\060\035\020\104\060\097\121\009\027\060\054\058\102")
zonefinalyatthetop.Visible = false
zonefinalyatthetop.Commands = {}
zonefinalyatthetop.DistanceRange = Distance(1500, "feet")
zonefinalyatthetop.ShowObjects = "OnEnter"
zonefinalyatthetop.ProximityRange = Distance(200, "feet")
zonefinalyatthetop.AllowSetPositionTo = false
zonefinalyatthetop.Active = true
zonefinalyatthetop.Points = {
	ZonePoint(54.00687, -1.46717, 0), 
	ZonePoint(54.00687, -1.46696, 0), 
	ZonePoint(54.00674, -1.46696, 0), 
	ZonePoint(54.00674, -1.46717, 0)
}
zonefinalyatthetop.OriginalPoint = ZonePoint(54.006807, -1.467064, 0)
zonefinalyatthetop.DistanceRangeUOM = "Feet"
zonefinalyatthetop.ProximityRangeUOM = "Feet"
zonefinalyatthetop.OutOfRangeName = ""
zonefinalyatthetop.InRangeName = ""
zonenearthecastle = Wherigo.Zone(cartAroundtheRiver)
zonenearthecastle.Id = "de3f0cf7-ee71-4883-8007-4c242cf4d2be"
zonenearthecastle.Name = _XQxqd("\089\027\121\014\060\058\024\027\060\026\121\046\058\059\027")
zonenearthecastle.Description = _XQxqd("\111\020\104\060\121\014\027\060\089\020\050\060\089\027\043\058\060\058\020\060\053\089\121\014\027\046\085\020\014\020\104\048\024\060\026\121\046\058\059\027\051\060\050\024\035\060\089\020\058\060\058\121\053\027\060\121\060\120\104\054\026\053\060\058\020\104\014\044")
zonenearthecastle.Visible = false
zonenearthecastle.Media = zmediacastle
zonenearthecastle.Commands = {}
zonenearthecastle.DistanceRange = Distance(1500, "feet")
zonenearthecastle.ShowObjects = "OnEnter"
zonenearthecastle.ProximityRange = Distance(200, "feet")
zonenearthecastle.AllowSetPositionTo = false
zonenearthecastle.Active = true
zonenearthecastle.Points = {
	ZonePoint(54.00699, -1.46759, 0), 
	ZonePoint(54.00699, -1.46754, 0), 
	ZonePoint(54.00696, -1.46754, 0), 
	ZonePoint(54.00696, -1.46759, 0)
}
zonenearthecastle.OriginalPoint = ZonePoint(54.006976, -1.467565, 0)
zonenearthecastle.DistanceRangeUOM = "Feet"
zonenearthecastle.ProximityRangeUOM = "Feet"
zonenearthecastle.OutOfRangeName = ""
zonenearthecastle.InRangeName = ""
zonetherailwaystation = Wherigo.Zone(cartAroundtheRiver)
zonetherailwaystation.Id = "bbc8bfae-cb9a-4688-bce2-2a06465a8587"
zonetherailwaystation.Name = _XQxqd("\058\024\027\060\014\121\054\059\050\121\035\060\046\058\121\058\054\020\089")
zonetherailwaystation.Description = _XQxqd("\006\024\027\060\113\014\027\058\058\035\060\127\089\121\014\027\046\085\020\014\020\104\048\024\060\014\121\054\059\050\121\035\060\046\058\121\058\054\020\089")
zonetherailwaystation.Visible = false
zonetherailwaystation.Media = zmediastation
zonetherailwaystation.Commands = {}
zonetherailwaystation.DistanceRange = Distance(1500, "feet")
zonetherailwaystation.ShowObjects = "OnEnter"
zonetherailwaystation.ProximityRange = Distance(200, "feet")
zonetherailwaystation.AllowSetPositionTo = false
zonetherailwaystation.Active = true
zonetherailwaystation.Points = {
	ZonePoint(54.00873, -1.47046999999998, 0), 
	ZonePoint(54.00873, -1.47024999999996, 0), 
	ZonePoint(54.0085558653356, -1.47025536441799, 0), 
	ZonePoint(54.0086, -1.47046999999998, 0)
}
zonetherailwaystation.OriginalPoint = ZonePoint(54.008667, -1.470357, 0)
zonetherailwaystation.DistanceRangeUOM = "Feet"
zonetherailwaystation.ProximityRangeUOM = "Feet"
zonetherailwaystation.OutOfRangeName = ""
zonetherailwaystation.InRangeName = ""
zonethechurch = Wherigo.Zone(cartAroundtheRiver)
zonethechurch.Id = "d9d26086-0929-49f7-bf90-e378040c0ef0"
zonethechurch.Name = _XQxqd("\058\024\027\060\026\024\104\014\026\024")
zonethechurch.Description = _XQxqd("\080\058\060\061\020\024\089\060\058\024\027\060\115\121\063\058\054\046\058\077\046\060\036\024\104\014\026\024\051\060\086\060\013\027\014\035\060\063\014\027\058\058\035\060\085\104\054\059\009\054\089\048\051")
zonethechurch.Visible = false
zonethechurch.Media = zmediastjohns
zonethechurch.Commands = {}
zonethechurch.DistanceRange = Distance(1500, "feet")
zonethechurch.ShowObjects = "OnEnter"
zonethechurch.ProximityRange = Distance(200, "feet")
zonethechurch.AllowSetPositionTo = false
zonethechurch.Active = true
zonethechurch.Points = {
	ZonePoint(54.00946, -1.47221999999999, 0), 
	ZonePoint(54.00946, -1.47209999999995, 0), 
	ZonePoint(54.009297003668, -1.4720544024467, 0), 
	ZonePoint(54.0093553234259, -1.47223341104507, 0)
}
zonethechurch.OriginalPoint = ZonePoint(54.009424, -1.47216, 0)
zonethechurch.DistanceRangeUOM = "Feet"
zonethechurch.ProximityRangeUOM = "Feet"
zonethechurch.OutOfRangeName = ""
zonethechurch.InRangeName = ""
zonedownthelane = Wherigo.Zone(cartAroundtheRiver)
zonedownthelane.Id = "b3a61c0b-fdce-404a-a13f-b01304be354a"
zonedownthelane.Name = _XQxqd("\009\020\050\089\060\058\024\027\060\059\121\089\027")
zonedownthelane.Description = _XQxqd("\006\024\054\046\060\054\046\060\024\121\059\087\050\121\035\009\020\050\089\060\121\060\059\054\058\058\059\027\060\059\121\089\027\060\048\020\054\089\048\060\087\014\020\097\060\080\006\060\061\020\024\089\060\058\024\027\060\115\121\063\058\054\046\058\077\046\060\026\024\104\014\026\024\060\020\104\058\060\058\020\060\058\024\027\060\097\121\054\089\060\014\020\121\009\051")
zonedownthelane.Visible = false
zonedownthelane.Commands = {}
zonedownthelane.DistanceRange = Distance(1500, "feet")
zonedownthelane.ShowObjects = "OnEnter"
zonedownthelane.ProximityRange = Distance(200, "feet")
zonedownthelane.AllowSetPositionTo = false
zonedownthelane.Active = true
zonedownthelane.Points = {
	ZonePoint(54.0097836428919, -1.47365950429912, 0), 
	ZonePoint(54.00976, -1.47341000000006, 0), 
	ZonePoint(54.00963, -1.47341000000006, 0), 
	ZonePoint(54.00963, -1.47362999999996, 0)
}
zonedownthelane.OriginalPoint = ZonePoint(54.009693, -1.47352, 0)
zonedownthelane.DistanceRangeUOM = "Feet"
zonedownthelane.ProximityRangeUOM = "Feet"
zonedownthelane.OutOfRangeName = ""
zonedownthelane.InRangeName = ""
zonefinallocation = Wherigo.Zone(cartAroundtheRiver)
zonefinallocation.Id = "b55eb6d9-7e67-48aa-8815-573fcd50ba1e"
zonefinallocation.Name = _XQxqd("\087\054\089\121\059\060\059\020\026\121\058\054\020\089")
zonefinallocation.Description = _XQxqd("\058\024\027\060\026\121\026\024\027\060\054\046\060\024\027\014\027\051\060\054\089\060\035\020\104\014\060\072\035\020\104\060\046\027\027\072\060\063\121\089\027\059\060\058\024\027\014\027\060\050\054\059\059\060\085\027\060\121\060\026\059\104\027\045\060\121\089\009\060\054\089\060\035\020\104\014\060\072\054\089\013\027\089\058\020\014\035\072\060\063\121\089\027\059\060\058\024\027\014\027\060\050\054\059\059\060\085\027\060\058\024\027\060\026\020\097\085\054\089\121\058\054\020\089\060\026\020\009\027\051")
zonefinallocation.Visible = false
zonefinallocation.Commands = {}
zonefinallocation.DistanceRange = Distance(1500, "feet")
zonefinallocation.ShowObjects = "OnEnter"
zonefinallocation.ProximityRange = Distance(200, "feet")
zonefinallocation.AllowSetPositionTo = false
zonefinallocation.Active = true
zonefinallocation.Points = {
	ZonePoint(54.00892, -1.47562, 0), 
	ZonePoint(54.00892, -1.47559, 0), 
	ZonePoint(54.0089, -1.47559, 0), 
	ZonePoint(54.0089, -1.47562, 0)
}
zonefinallocation.OriginalPoint = ZonePoint(54.008914, -1.475608, 0)
zonefinallocation.DistanceRangeUOM = "Feet"
zonefinallocation.ProximityRangeUOM = "Feet"
zonefinallocation.OutOfRangeName = ""
zonefinallocation.InRangeName = ""
zonethelibrary = Wherigo.Zone(cartAroundtheRiver)
zonethelibrary.Id = "745c1a89-b701-4b3b-a021-42583c1a5456"
zonethelibrary.Name = _XQxqd("\058\024\027\060\059\054\085\014\121\014\035")
zonethelibrary.Description = _XQxqd("\086\060\059\054\085\014\121\014\035\051\060\050\024\121\058\060\097\020\014\027\060\058\020\060\046\121\035\044")
zonethelibrary.Visible = false
zonethelibrary.Media = zmedialibrary
zonethelibrary.Commands = {}
zonethelibrary.DistanceRange = Distance(1500, "feet")
zonethelibrary.ShowObjects = "OnEnter"
zonethelibrary.ProximityRange = Distance(200, "feet")
zonethelibrary.AllowSetPositionTo = false
zonethelibrary.Active = true
zonethelibrary.Points = {
	ZonePoint(54.0081710337754, -1.46754294477466, 0), 
	ZonePoint(54.0081174411244, -1.46742930059429, 0), 
	ZonePoint(54.0080679835406, -1.46749367361065, 0), 
	ZonePoint(54.0081042374434, -1.46761000000004, 0)
}
zonethelibrary.OriginalPoint = ZonePoint(54.008139, -1.467579, 0)
zonethelibrary.DistanceRangeUOM = "Feet"
zonethelibrary.ProximityRangeUOM = "Feet"
zonethelibrary.OutOfRangeName = ""
zonethelibrary.InRangeName = ""
zonetheoldschool = Wherigo.Zone(cartAroundtheRiver)
zonetheoldschool.Id = "93c13a9f-c134-488f-933b-e973f0764595"
zonetheoldschool.Name = _XQxqd("\058\024\027\060\020\059\009\060\046\026\024\020\020\059")
zonetheoldschool.Description = _XQxqd("\006\024\027\060\020\059\009\060\127\089\121\014\027\046\085\020\014\020\104\048\024\060\085\020\035\046\060\046\026\024\020\020\059\051\060\058\024\054\046\060\054\046\060\089\020\050\060\121\060\009\027\089\058\054\046\058\046\045\060\121\089\009\060\058\024\027\060\048\054\014\059\046\060\046\026\024\020\020\059\060\121\026\014\020\046\046\060\058\024\027\060\014\020\121\009\060\024\121\046\060\121\060\009\121\089\026\027\060\046\026\024\020\020\059\060\020\089\060\058\024\027\060\085\020\058\058\020\097\060\087\059\020\020\014\060\121\089\009\060\121\060\046\026\020\104\058\060\058\014\020\104\063\060\020\089\060\058\024\027\060\058\020\063\060\087\059\020\020\014\051")
zonetheoldschool.Visible = false
zonetheoldschool.Commands = {}
zonetheoldschool.DistanceRange = Distance(1500, "feet")
zonetheoldschool.ShowObjects = "OnEnter"
zonetheoldschool.ProximityRange = Distance(200, "feet")
zonetheoldschool.AllowSetPositionTo = false
zonetheoldschool.Active = true
zonetheoldschool.Points = {
	ZonePoint(54.0074489153736, -1.46810486871721, 0), 
	ZonePoint(54.0074583730572, -1.46792122453689, 0), 
	ZonePoint(54.00736, -1.46794, 0), 
	ZonePoint(54.0073820679722, -1.46816119510652, 0)
}
zonetheoldschool.OriginalPoint = ZonePoint(54.007394, -1.468002, 0)
zonetheoldschool.DistanceRangeUOM = "Feet"
zonetheoldschool.ProximityRangeUOM = "Feet"
zonetheoldschool.OutOfRangeName = ""
zonetheoldschool.InRangeName = ""

-- Characters --
zcharactercacheowner = Wherigo.ZCharacter(cartAroundtheRiver)
zcharactercacheowner.Id = "10e5afd6-7b76-4279-b519-046ab7611633"
zcharactercacheowner.Name = _XQxqd("\026\121\026\024\027\060\020\050\089\027\014")
zcharactercacheowner.Description = ""
zcharactercacheowner.Visible = false
zcharactercacheowner.Commands = {}
zcharactercacheowner.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharactercacheowner.Gender = "Male"
zcharactercacheowner.Type = "NPC"
zcharacterswimmer = Wherigo.ZCharacter(cartAroundtheRiver)
zcharacterswimmer.Id = "9880b477-d89e-46e4-b8f0-37accbb41adf"
zcharacterswimmer.Name = _XQxqd("\046\050\054\097\097\027\014")
zcharacterswimmer.Description = ""
zcharacterswimmer.Visible = true
zcharacterswimmer.Commands = {}
zcharacterswimmer.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterswimmer.Gender = "Male"
zcharacterswimmer.Type = "NPC"
zcharacterdrowningswimmer = Wherigo.ZCharacter(cartAroundtheRiver)
zcharacterdrowningswimmer.Id = "021267ea-5a99-4f75-a0f9-f28bce0eb1e2"
zcharacterdrowningswimmer.Name = _XQxqd("\009\014\020\050\089\054\089\048\060\046\050\054\097\097\027\014")
zcharacterdrowningswimmer.Description = ""
zcharacterdrowningswimmer.Visible = false
zcharacterdrowningswimmer.Media = zmediadrowningswimmer
zcharacterdrowningswimmer.Commands = {}
zcharacterdrowningswimmer.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterdrowningswimmer.Gender = "Male"
zcharacterdrowningswimmer.Type = "NPC"

-- Items --
zitemcode = Wherigo.ZItem(cartAroundtheRiver)
zitemcode.Id = "22371783-c999-46b3-8a9c-4db3aae1847c"
zitemcode.Name = _XQxqd("\026\020\009\027")
zitemcode.Description = ""
zitemcode.Visible = true
zitemcode.Media = zmediacode
zitemcode.Commands = {}
zitemcode.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemcode.Locked = false
zitemcode.Opened = false
zitemlifering = Wherigo.ZItem(cartAroundtheRiver)
zitemlifering.Id = "b5c3187e-cf9a-4e45-b793-79cb4d4582b9"
zitemlifering.Name = _XQxqd("\059\054\087\027\060\014\054\089\048")
zitemlifering.Description = _XQxqd("\086\060\079\054\087\027\060\074\054\089\048")
zitemlifering.Visible = true
zitemlifering.Media = zmedialifering
zitemlifering.Commands = {
	throw = Wherigo.ZCommand{
		Text = _XQxqd("\058\024\014\020\050"), 
		CmdWith = true, 
		Enabled = true, 
		EmptyTargetListText = _XQxqd("\021\020\058\024\054\089\048\060\121\013\121\054\059\121\085\059\027")
	}
}
zitemlifering.Commands.throw.Custom = true
zitemlifering.Commands.throw.Id = "eae6ef0f-edbd-4404-9c2d-b103f7c592d1"
zitemlifering.Commands.throw.WorksWithAll = false
zitemlifering.Commands.throw.WorksWithListIds = {
	"021267ea-5a99-4f75-a0f9-f28bce0eb1e2"
}
zitemlifering.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemlifering.Locked = false
zitemlifering.Opened = false
zitemclue = Wherigo.ZItem(cartAroundtheRiver)
zitemclue.Id = "d66c1273-7916-4b69-abf5-cf666a244282"
zitemclue.Name = _XQxqd("\026\059\104\027")
zitemclue.Description = _XQxqd("\085\027\024\054\089\009\060\050\121\059\059\060\020\089\060\087\059\020\020\014")
zitemclue.Visible = false
zitemclue.Media = zmediaclue
zitemclue.Commands = {}
zitemclue.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemclue.Locked = false
zitemclue.Opened = false

-- Tasks --
ztaskgotohenshawspath = Wherigo.ZTask(cartAroundtheRiver)
ztaskgotohenshawspath.Id = "0bbb4a3f-216f-47eb-abb8-bdfb86925199"
ztaskgotohenshawspath.Name = _XQxqd("\048\020\060\058\020\060\024\027\089\046\024\121\050\046\060\063\121\058\024")
ztaskgotohenshawspath.Description = _XQxqd("\035\020\104\060\097\104\046\058\060\089\020\050\060\048\020\060\009\020\050\089\060\058\024\027\060\059\054\058\058\059\027\060\063\121\058\024\051\060\071\020\050\089\060\054\058\060\035\020\104\060\050\054\059\059\060\087\054\089\009\060\121\060\063\020\046\058\060\050\054\058\024\060\121\089\060\121\089\046\050\027\014\060\058\020\060\121\060\120\104\027\046\058\054\020\089\060\020\089\060\054\058\051\060\063\014\027\046\046\060\085\121\026\053\060\121\089\009\060\046\027\059\027\026\058\060\059\020\026\121\058\054\020\089\046\045\060\058\024\027\089\060\024\027\089\046\024\121\050\046\060\063\121\058\024\060\058\020\060\089\121\013\054\048\121\058\027\060\058\024\027\014\027\051")
ztaskgotohenshawspath.Visible = false
ztaskgotohenshawspath.Active = true
ztaskgotohenshawspath.Complete = false
ztaskgotohenshawspath.CorrectState = "None"
ztaskgotothebridge = Wherigo.ZTask(cartAroundtheRiver)
ztaskgotothebridge.Id = "ebff4389-1a95-4a09-a27c-b8236397fe89"
ztaskgotothebridge.Name = _XQxqd("\048\020\060\058\020\060\058\024\027\060\085\014\054\009\048\027")
ztaskgotothebridge.Description = _XQxqd("\087\054\014\046\058\060\048\020\060\058\020\060\085\027\024\054\089\009\060\026\020\089\089\035\089\048\024\121\097\060\024\121\059\059\051\060\058\024\027\060\053\027\027\063\060\048\020\054\089\048\060\121\089\009\060\058\121\053\027\060\058\024\027\060\087\054\014\046\058\060\014\054\048\024\058\060\009\020\050\089\060\058\020\060\058\024\027\060\085\014\054\009\048\027\051\060\009\020\089\077\058\060\050\020\014\014\035\045\060\035\020\104\060\026\121\089\060\048\020\060\058\024\014\020\104\048\024\060\058\024\027\060\026\121\014\060\063\121\014\053\051")
ztaskgotothebridge.Visible = false
ztaskgotothebridge.Active = true
ztaskgotothebridge.Complete = false
ztaskgotothebridge.CorrectState = "None"
ztaskgotoprettygardens = Wherigo.ZTask(cartAroundtheRiver)
ztaskgotoprettygardens.Id = "76ed0446-7978-46c1-a60c-c9eec4d7b7fa"
ztaskgotoprettygardens.Name = _XQxqd("\048\020\060\058\020\060\063\014\027\058\058\035\060\048\121\014\009\027\089\046")
ztaskgotoprettygardens.Description = _XQxqd("\089\020\050\060\035\020\104\060\097\104\046\058\060\048\020\060\058\020\060\058\024\027\060\063\014\027\058\058\035\060\048\121\014\009\027\089\046\045\013\054\121\060\058\024\027\060\072\024\054\048\024\060\121\089\009\060\059\020\050\072\045\060\072\014\054\013\027\014\060\013\054\027\050\072\060\121\089\009\060\072\026\020\089\089\035\089\048\024\121\097\060\026\121\014\060\063\121\014\053\060\096\020\089\027\046\051\060\009\020\089\077\058\060\050\020\014\014\035\051\060\058\024\027\035\060\050\054\059\059\060\085\027\026\020\097\027\060\013\054\046\054\085\059\027\060\020\089\027\060\121\058\060\121\060\058\054\097\027\051")
ztaskgotoprettygardens.Visible = false
ztaskgotoprettygardens.Active = true
ztaskgotoprettygardens.Complete = false
ztaskgotoprettygardens.CorrectState = "None"
ztaskgotothecafe = Wherigo.ZTask(cartAroundtheRiver)
ztaskgotothecafe.Id = "c04a4400-05e9-4bd2-8a68-3af15784d458"
ztaskgotothecafe.Name = _XQxqd("\048\020\060\058\020\060\058\024\027\060\026\121\087\027")
ztaskgotothecafe.Description = _XQxqd("\035\020\104\060\097\104\046\058\060\048\020\060\058\020\060\058\024\027\060\026\121\087\027\045\060\013\054\121\060\058\024\027\060\013\054\121\009\104\026\058\051\060\058\024\027\035\060\050\054\059\059\060\085\027\026\020\097\027\060\013\054\046\054\085\059\027\060\054\089\009\054\013\054\009\104\121\059\059\035")
ztaskgotothecafe.Visible = false
ztaskgotothecafe.Active = true
ztaskgotothecafe.Complete = false
ztaskgotothecafe.CorrectState = "None"
ztaskgetthecodefromthelibrary = Wherigo.ZTask(cartAroundtheRiver)
ztaskgetthecodefromthelibrary.Id = "28fd4921-3181-44cf-8487-cc015e159dba"
ztaskgetthecodefromthelibrary.Name = _XQxqd("\048\027\058\060\058\024\027\060\026\020\009\027\060\087\014\020\097\060\058\024\027\060\059\054\085\014\121\014\035")
ztaskgetthecodefromthelibrary.Description = _XQxqd("\048\027\058\060\058\024\027\060\026\020\009\027\060\087\014\020\097\060\058\024\027\060\059\054\085\014\121\014\035\051\060\048\020\060\013\054\121\060\072\089\027\121\014\060\058\024\027\060\026\121\046\058\059\027\072\060\121\089\009\060\072\058\024\027\060\020\059\009\060\046\026\024\020\020\059\072\051")
ztaskgetthecodefromthelibrary.Visible = false
ztaskgetthecodefromthelibrary.Active = true
ztaskgetthecodefromthelibrary.Complete = false
ztaskgetthecodefromthelibrary.CorrectState = "None"
ztaskgotothebaseofabighill = Wherigo.ZTask(cartAroundtheRiver)
ztaskgotothebaseofabighill.Id = "5c1bec27-4293-4b46-8e06-e3520c15281c"
ztaskgotothebaseofabighill.Name = _XQxqd("\048\020\060\058\020\060\058\024\027\060\085\121\046\027\060\020\087\060\121\060\085\054\048\060\024\054\059\059")
ztaskgotothebaseofabighill.Description = _XQxqd("\048\020\060\058\020\060\058\024\027\060\085\121\046\027\060\020\087\060\121\060\085\054\048\060\024\054\059\059\060\013\054\121\060\058\024\027\060\026\121\014\063\121\014\053\051")
ztaskgotothebaseofabighill.Visible = false
ztaskgotothebaseofabighill.Active = true
ztaskgotothebaseofabighill.Complete = false
ztaskgotothebaseofabighill.CorrectState = "None"
ztaskgotothechurch = Wherigo.ZTask(cartAroundtheRiver)
ztaskgotothechurch.Id = "4410cf90-9530-42c7-86ac-c9cd1ace4b44"
ztaskgotothechurch.Name = _XQxqd("\048\020\060\058\020\060\058\024\027\060\026\024\104\014\026\024")
ztaskgotothechurch.Description = _XQxqd("\048\020\060\058\020\060\058\024\027\060\026\024\104\014\026\024\060\013\054\121\060\058\024\027\060\014\121\054\059\050\121\035\060\046\058\121\058\054\020\089")
ztaskgotothechurch.Visible = false
ztaskgotothechurch.Active = true
ztaskgotothechurch.Complete = false
ztaskgotothechurch.CorrectState = "None"
ztaskgetthecache = Wherigo.ZTask(cartAroundtheRiver)
ztaskgetthecache.Id = "c174e64c-73e8-4f03-bbe5-745edba7aaca"
ztaskgetthecache.Name = _XQxqd("\048\027\058\060\058\024\027\060\026\121\026\024\027\102")
ztaskgetthecache.Description = _XQxqd("\060\048\020\060\013\054\121\060\058\024\027\060\059\121\089\027\045\060\058\020\060\048\027\058\060\058\024\027\060\026\121\026\024\027\051\060\121\058\060\058\024\027\060\059\020\026\121\058\054\020\089\060\058\024\027\014\027\060\050\054\059\059\060\085\027\060\121\060\026\059\104\027\060\054\089\060\058\024\027\060\035\020\104\060\046\027\027\060\058\121\085\051\060\020\089\059\035\060\104\046\027\060\058\024\054\046\060\054\087\060\035\020\104\060\089\027\027\009\060\058\020\051")
ztaskgetthecache.Visible = false
ztaskgetthecache.Active = true
ztaskgetthecache.Complete = false
ztaskgetthecache.CorrectState = "None"
ztaskgoupthehill = Wherigo.ZTask(cartAroundtheRiver)
ztaskgoupthehill.Id = "a7224c15-b5f6-4f19-9fe3-268299b5ff87"
ztaskgoupthehill.Name = _XQxqd("\048\020\060\104\063\060\058\024\027\060\024\054\059\059")
ztaskgoupthehill.Description = _XQxqd("\035\027\046\060\054\058\046\060\085\054\048\045\060\085\104\058\060\046\020\014\014\035\060\058\024\121\058\077\046\060\058\024\027\060\050\121\035\051")
ztaskgoupthehill.Visible = false
ztaskgoupthehill.Active = true
ztaskgoupthehill.Complete = false
ztaskgoupthehill.CorrectState = "None"

-- Cartridge Variables --
touristinfoquestion = ""
postnumberquestion = ""
signpostquestion = ""
gutterquestion = ""
cafequestion = ""
postquestion = ""
postnumberquestion2 = ""
gatequestion1 = 0
cartAroundtheRiver.ZVariables = {
	touristinfoquestion = "", 
	postnumberquestion = "", 
	signpostquestion = "", 
	gutterquestion = "", 
	cafequestion = "", 
	postquestion = "", 
	postnumberquestion2 = "", 
	gatequestion1 = 0
}

-- Timers --

-- Inputs --
zinputpostquestion = Wherigo.ZInput(cartAroundtheRiver)
zinputpostquestion.Id = "d22901f8-5fc6-40cd-8314-7976d594dcc4"
zinputpostquestion.Name = _XQxqd("\063\020\046\058\060\120\104\027\046\058\054\020\089")
zinputpostquestion.Description = ""
zinputpostquestion.Visible = true
zinputpostquestion.Choices = {
	"walk 1", 
	"walk 2", 
	"walk 3"
}
zinputpostquestion.InputType = "MultipleChoice"
zinputpostquestion.Text = _XQxqd("\050\024\054\026\024\060\050\121\059\053\060\121\014\027\060\035\020\104\060\020\089\044")
zinputgatequestion = Wherigo.ZInput(cartAroundtheRiver)
zinputgatequestion.Id = "6defc1a1-0dfa-4a7a-88dc-588491f45082"
zinputgatequestion.Name = _XQxqd("\048\121\058\027\060\120\104\027\046\058\054\020\089")
zinputgatequestion.Description = ""
zinputgatequestion.Visible = true
zinputgatequestion.InputType = "Text"
zinputgatequestion.Text = _XQxqd("\050\024\121\058\060\054\046\060\058\024\027\060\089\104\097\085\027\014\060\020\087\060\024\020\014\054\096\020\089\058\121\059\060\063\059\121\089\053\046\060\020\089\060\058\024\027\060\048\121\058\027\044\060\048\054\013\027\060\035\020\104\014\060\121\089\046\050\027\014\060\121\046\060\121\060\046\054\089\048\059\027\060\089\104\097\027\014\054\026\121\059\060\009\054\048\054\058\051")
zinputsignpostquestion = Wherigo.ZInput(cartAroundtheRiver)
zinputsignpostquestion.Id = "9cf63a1f-16c7-4df8-9386-95c61528172e"
zinputsignpostquestion.Name = _XQxqd("\046\054\048\089\063\020\046\058\060\120\104\027\046\058\054\020\089")
zinputsignpostquestion.Description = ""
zinputsignpostquestion.Visible = true
zinputsignpostquestion.InputType = "Text"
zinputsignpostquestion.Text = _XQxqd("\050\024\020\060\097\121\035\060\085\027\060\063\014\020\046\027\026\104\058\027\009\044\060\048\054\013\027\060\121\089\046\050\027\014\060\027\043\121\026\058\059\035\060\121\046\060\050\014\054\058\058\027\089\051")
zinputtouristinfoquestion = Wherigo.ZInput(cartAroundtheRiver)
zinputtouristinfoquestion.Id = "d2fe9271-5b42-44d8-b669-409a2e9ab8f3"
zinputtouristinfoquestion.Name = _XQxqd("\058\020\104\014\054\046\058\060\054\089\087\020\060\120\104\027\046\058\054\020\089")
zinputtouristinfoquestion.Description = ""
zinputtouristinfoquestion.Visible = true
zinputtouristinfoquestion.InputType = "Text"
zinputtouristinfoquestion.Text = _XQxqd("\024\020\050\060\097\121\089\035\060\085\014\020\050\089\060\058\020\104\014\054\046\058\060\054\089\087\020\060\046\054\048\089\046\060\121\014\027\060\063\059\121\026\027\009\060\054\089\060\058\024\027\060\027\089\058\014\121\089\026\027\060\058\020\060\058\024\027\060\026\121\014\060\063\121\014\053\044\060\063\059\027\121\046\027\060\048\054\013\027\060\035\020\104\014\060\121\089\046\050\027\014\060\121\046\060\121\060\089\104\097\027\014\054\026\121\059\060\009\054\048\054\058\051")
zinputpostnumberquestion = Wherigo.ZInput(cartAroundtheRiver)
zinputpostnumberquestion.Id = "5c0695a3-cb5d-4231-be90-3fb5fd50090c"
zinputpostnumberquestion.Name = _XQxqd("\063\020\046\058\060\089\104\097\085\027\014\060\120\104\027\046\058\054\020\089")
zinputpostnumberquestion.Description = ""
zinputpostnumberquestion.Visible = true
zinputpostnumberquestion.InputType = "Text"
zinputpostnumberquestion.Text = _XQxqd("\121\009\009\060\058\024\027\060\089\104\097\085\027\014\046\060\020\089\060\058\024\027\060\009\027\121\009\060\027\089\009\060\046\054\048\089\060\058\020\048\027\058\024\027\014\051\060\048\054\013\027\060\035\020\104\014\060\121\089\046\050\027\014\060\121\046\060\121\060\058\050\020\060\009\054\048\054\058\060\121\089\046\050\027\014")
zinputcafequestion = Wherigo.ZInput(cartAroundtheRiver)
zinputcafequestion.Id = "8eeeae71-1852-49ae-8ee0-79222f01cb5c"
zinputcafequestion.Name = _XQxqd("\026\121\087\027\060\120\104\027\046\058\054\020\089")
zinputcafequestion.Description = ""
zinputcafequestion.Visible = true
zinputcafequestion.InputType = "Text"
zinputcafequestion.Text = _XQxqd("\050\024\121\058\060\087\059\020\050\027\014\060\089\121\097\027\060\054\046\060\050\014\054\058\058\027\089\060\054\089\060\048\020\059\009\044\060\113\059\027\121\046\027\060\048\054\013\027\060\035\020\104\014\060\121\089\046\050\027\014\060\121\046\060\050\014\054\058\058\027\089")
zinputpostnumberquestion2 = Wherigo.ZInput(cartAroundtheRiver)
zinputpostnumberquestion2.Id = "4a947630-979e-4262-8e4f-155668473d03"
zinputpostnumberquestion2.Name = _XQxqd("\063\020\046\058\060\089\104\097\085\027\014\060\120\104\027\046\058\054\020\089\060\023")
zinputpostnumberquestion2.Description = ""
zinputpostnumberquestion2.Visible = true
zinputpostnumberquestion2.InputType = "Text"
zinputpostnumberquestion2.Text = _XQxqd("\121\009\009\060\058\024\027\060\058\050\020\060\089\104\097\085\027\014\046\060\058\020\048\027\058\024\027\014\060\020\089\060\058\024\027\060\020\089\027\060\050\121\035\060\046\054\048\089")
zinputgutterquestion = Wherigo.ZInput(cartAroundtheRiver)
zinputgutterquestion.Id = "c4f26699-aa70-404c-9fc8-358cbd79b643"
zinputgutterquestion.Name = _XQxqd("\048\104\058\058\027\014\060\120\104\027\046\058\054\020\089")
zinputgutterquestion.Description = ""
zinputgutterquestion.Visible = true
zinputgutterquestion.InputType = "Text"
zinputgutterquestion.Text = _XQxqd("\050\024\121\058\060\035\027\121\014\060\054\046\060\050\014\054\058\058\027\089\060\020\089\060\058\024\027\060\050\024\054\058\027\060\048\104\058\058\027\014\044\060\113\059\027\121\046\027\060\048\054\013\027\060\035\020\104\014\060\121\089\046\050\027\014\060\054\089\060\089\104\097\027\014\054\026\121\059\060\009\054\048\054\058\046\051")

-- WorksWithList for object commands --
zitemlifering.Commands.throw.WorksWithList = {
	zcharacterdrowningswimmer
}

-- functions --
function cartAroundtheRiver:OnStart()
	zcharactercacheowner:MoveTo(zonehenshaws)
	zitemcode:MoveTo(zonethelibrary)
	zcharacterdrowningswimmer:MoveTo(zoneprettygardens)
	zitemlifering:MoveTo(zonethebridge)
	zcharacterswimmer:MoveTo(zoneprettygardens)
	zonehenshaws.Visible = true
end
function cartAroundtheRiver:OnRestore()
end
function zonehenshaws:OnEnter()
	_Urwigo.MessageBox{
		Text = _XQxqd("\001\024\060\024\054\102\060\025\060\024\027\121\014\060\035\020\104\060\121\014\027\060\024\027\014\027\060\058\020\060\026\020\097\063\059\027\058\027\060\097\035\060\050\024\027\014\054\048\020\045\060\090\104\046\058\060\087\020\059\059\020\050\060\058\024\027\060\014\020\104\058\027\060\121\089\009\060\026\020\097\063\059\027\058\027\060\058\024\027\060\058\121\046\053\046\060\121\059\020\089\048\060\058\024\027\060\050\121\035\051\060\002\089\085\046\063\126\002\089\085\046\063\126\002\089\085\046\063\126\002\089\085\046\063\126\002\089\085\046\063\126\002\089\085\046\063\126\002\089\085\046\063\126\002\089\085\046\063\126\002\089\085\046\063\126\002\089\085\046\063\126\002\089\085\046\063\126\002\089\085\046\063\126\002\089\085\046\063\126\021\020\050\045\060\035\020\104\060\085\027\058\058\027\014\060\048\027\058\060\048\020\054\089\048\051\060"), 
		Media = zmediaCacheowner, 
		Buttons = {
			_XQxqd("\001\127")
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					zonehenshaws.Visible = false
				end
			end
		end
	}
	ztaskgotohenshawspath.Visible = true
	zonehenshawspath.Visible = true
end
function zonehenshawspath:OnEnter()
	ztaskgotohenshawspath.Complete = true
	ztaskgotohenshawspath.Visible = false
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputpostquestion)
	end)
end
function zonehenshawspath:OnExit()
	zonehenshawspath.Visible = false
end
function zonebehindConynghamHall:OnExit()
	zonebehindConynghamHall.Visible = false
end
function zonethebridge:OnEnter()
	ztaskgotothebridge.Visible = false
	_Urwigo.MessageBox{
		Text = _XQxqd("\024\027\035\060\059\020\020\053\060\121\060\059\054\087\027\060\014\054\089\048\102\060\048\020\060\058\020\060\058\024\027\060\035\020\104\060\046\027\027\060\063\121\089\027\059\060\121\089\009\060\063\054\026\053\060\054\058\060\104\063\051")
	}
end
function zonethebridge:OnExit()
	zonethebridge.Visible = false
end
function zoneriverview:OnEnter()
	_Urwigo.MessageBox{
		Text = _XQxqd("\089\020\050\060\048\020\060\058\020\060\026\020\089\089\035\089\048\024\121\097\060\026\121\014\063\121\014\053\051")
	}
	zoneConynghamcarpark.Visible = true
end
function zoneriverview:OnExit()
	zoneriverview.Visible = false
end
function zonehighandlow:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputsignpostquestion)
	end)
end
function zonehighandlow:OnExit()
	zonehighandlow.Visible = false
end
function zoneConynghamcarpark:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputtouristinfoquestion)
	end)
end
function zoneConynghamcarpark:OnExit()
	zoneConynghamcarpark.Visible = false
end
function zoneprettygardens:OnEnter()
	ztaskgotoprettygardens.Visible = false
	_Urwigo.MessageBox{
		Text = _XQxqd("\024\027\059\063\060\025\077\097\060\009\014\020\050\089\054\089\048"), 
		Media = zmediadrowningswimmer, 
		Buttons = {
			_XQxqd("\058\024\014\020\050\060\059\054\087\027\060\014\054\089\048")
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					zitemlifering.Visible = false
					_Urwigo.MessageBox{
						Text = _XQxqd("\058\024\121\089\053\060\035\020\104\060\013\027\014\035\060\097\104\026\024\045\060\054\060\089\027\121\014\059\035\060\009\054\027\009\102\060\025\060\046\027\027\060\058\024\121\058\060\035\020\104\060\121\014\027\060\009\020\054\089\048\060\058\024\027\060\050\024\027\014\054\048\020\051\060\025\060\121\097\060\087\014\054\027\089\009\046\060\050\054\058\024\060\058\024\027\060\026\121\026\024\027\060\020\050\089\027\014\060\121\089\009\060\025\060\053\089\020\050\060\058\024\121\058\060\035\020\104\060\002\089\085\046\063\126\104\046\027\009\060\058\020\060\089\027\027\009\060\121\060\026\020\009\027\060\058\020\060\020\063\027\089\060\058\024\027\060\026\020\089\058\121\054\089\027\014\045\060\025\060\009\020\089\077\058\060\127\089\020\050\060\054\087\060\035\020\104\060\046\058\054\059\059\060\009\020\045\060\085\104\058\060\054\087\060\035\020\104\060\009\020\045\060\054\058\060\054\046\060\121\058\060\058\024\027\060\059\054\085\014\121\014\035\051"), 
						Media = zmediaswimmer, 
						Buttons = {
							_XQxqd("\058\024\121\089\053\060\035\020\104")
						}, 
						Callback = function(action)
							if action ~= nil then
								if action == "Button1" then
									_Urwigo.MessageBox{
										Text = _XQxqd("\058\024\027\060\059\054\085\014\121\014\035\060\054\046\060\020\089\060\035\020\104\014\060\050\121\035\051\060\035\020\104\060\026\121\089\060\063\054\026\053\060\054\058\060\104\063\060\059\121\058\027\014\051"), 
										Media = zmediaswimmer, 
										Buttons = {
											_XQxqd("\001\127")
										}, 
										Callback = function(action)
											if action ~= nil then
												if action == "Button1" then
													zoneTheviaduct.Visible = true
													ztaskgotothecafe.Visible = true
												end
											end
										end
									}
								end
							end
						end
					}
				end
			end
		end
	}
	ztaskgotothecafe.Visible = true
end
function zoneprettygardens:OnExit()
	zoneprettygardens.Visible = false
end
function zoneTheviaduct:OnEnter()
	zonethecafe.Visible = true
	zoneTheviaduct.Visible = false
end
function zonethecafe:OnEnter()
	ztaskgotothecafe.Visible = false
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputcafequestion)
	end)
end
function zoneThecarpark:OnEnter()
	zoneThecarpark.Visible = false
	zoneBaseofabighill.Visible = true
end
function zoneBaseofabighill:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputpostnumberquestion)
	end)
	ztaskgotothebaseofabighill.Visible = false
end
function zonehalfwayup:OnEnter()
	zonehalfwayup.Visible = false
	zonefinalyatthetop.Visible = true
end
function zonefinalyatthetop:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputpostnumberquestion2)
	end)
end
function zonefinalyatthetop:OnExit()
	zonefinalyatthetop.Visible = false
end
function zonenearthecastle:OnEnter()
	zonetheoldschool.Visible = true
	zonenearthecastle.Visible = false
end
function zonetherailwaystation:OnEnter()
	zonetherailwaystation.Visible = false
	zonethechurch.Visible = true
end
function zonethechurch:OnEnter()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputgutterquestion)
	end)
	ztaskgotothechurch.Visible = false
end
function zonedownthelane:OnEnter()
	zonefinallocation.Visible = true
	zonedownthelane.Visible = false
end
function zonefinallocation:OnEnter()
	zitemclue.Visible = true
end
function zonethelibrary:OnEnter()
	_Urwigo.MessageBox{
		Text = _XQxqd("\048\020\060\058\020\060\058\024\027\060\035\020\104\060\046\027\027\060\085\020\043\060\121\089\009\060\063\054\026\053\060\104\063\060\058\024\027\060\026\020\009\027\051")
	}
end
function zonethelibrary:OnExit()
	zonethelibrary.Visible = false
end
function zonetheoldschool:OnEnter()
	zonethelibrary.Visible = true
	zonetheoldschool.Visible = false
end
function zinputpostquestion:OnGetInput(input)
	if input == nil then
		input = ""
	end
	postquestion = input
	if Wherigo.NoCaseEquals(postquestion, _XQxqd("\050\121\059\053\060\015")) then
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\027\059\059\060\009\020\089\027\051\060\050\024\035\060\089\020\058\060\048\020\060\058\020\060\058\024\027\060\085\014\054\009\048\027\051\060\048\020\060\085\121\026\053\060\121\089\009\060\046\027\059\027\026\058\060\058\024\027\060\048\020\060\058\020\060\085\014\054\009\048\027\060\058\121\046\053\060\058\024\027\060\058\121\046\053\060\050\054\059\059\060\058\027\059\059\060\035\020\104\060\058\024\027\060\050\121\035\051")
		}
		ztaskgotothebridge.Visible = true
		zonebehindConynghamHall.Visible = true
		zonethebridge.Visible = true
	elseif not Wherigo.NoCaseEquals(postquestion, "walk 1") then
		_Urwigo.MessageBox{
			Text = _XQxqd("\020\020\063\046\060\058\024\121\058\077\046\060\089\020\058\060\120\104\054\058\027\060\014\054\048\024\058\102"), 
			Buttons = {
				_XQxqd("\058\014\035\060\121\048\121\054\089")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputpostquestion)
						end)
					end
				end
			end
		}
	end
end
function zinputgatequestion:OnGetInput(input)
	if input == nil then
		input = ""
	end
	gatequestion1 = tonumber(input)
	if gatequestion1 == 5 then
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\027\059\059\060\009\020\089\027\102\060\048\020\060\058\020\060\058\024\027\060\089\027\043\058\060\058\121\046\053")
		}
		ztaskgotoprettygardens.Visible = true
		zonehighandlow.Visible = true
	elseif gatequestion1 ~= 15 then
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\014\020\089\048\102\102"), 
			Buttons = {
				_XQxqd("\058\014\035\060\121\048\121\054\089")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputgatequestion)
						end)
					end
				end
			end
		}
	end
end
function zinputsignpostquestion:OnGetInput(input)
	if input == nil then
		input = ""
	end
	signpostquestion = input
	if Wherigo.NoCaseEquals(signpostquestion, _XQxqd("\001\087\087\027\089\009\027\014\046")) then
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\027\059\059\060\009\020\089\027\102\060\026\020\089\058\054\089\104\027\060\009\020\050\089\060\058\024\027\060\059\020\050\060\063\121\058\024\060\058\020\060\014\054\013\027\014\060\013\054\027\050\051")
		}
		zoneriverview.Visible = true
	elseif not Wherigo.NoCaseEquals(signpostquestion, "Offenders") then
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\014\020\089\048\102"), 
			Buttons = {
				_XQxqd("\058\014\035\060\121\048\121\054\089")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputsignpostquestion)
						end)
					end
				end
			end
		}
	end
end
function zinputtouristinfoquestion:OnGetInput(input)
	if input == nil then
		input = ""
	end
	touristinfoquestion = input
	if Wherigo.NoCaseEquals(touristinfoquestion, _XQxqd("\023")) then
		_Urwigo.MessageBox{
			Text = _XQxqd("\026\020\014\014\027\026\058\060\121\048\121\054\089\102")
		}
		zoneprettygardens.Visible = true
	else
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\014\020\089\048\102"), 
			Buttons = {
				_XQxqd("\058\014\035\060\121\048\121\054\089\102")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputtouristinfoquestion)
						end)
					end
				end
			end
		}
	end
end
function zinputpostnumberquestion:OnGetInput(input)
	if input == nil then
		input = ""
	end
	postnumberquestion = input
	if Wherigo.NoCaseEquals(postnumberquestion, _XQxqd("\015\015")) then
		_Urwigo.MessageBox{
			Text = _XQxqd("\026\020\014\014\027\026\058\102\060\089\020\050\060\048\020\060\058\020\060\058\024\027\060\058\020\063\060\020\087\060\058\024\027\060\024\054\059\059\060\013\054\121\060\024\121\059\087\060\050\121\035\060\058\024\027\014\027\051\060\058\024\027\060\096\020\089\027\046\060\050\054\059\059\060\085\027\026\020\097\027\060\013\054\046\054\085\059\027\060\046\027\063\027\014\121\058\027\059\035\051")
		}
		zonehalfwayup.Visible = true
		zoneBaseofabighill.Visible = false
		ztaskgoupthehill.Visible = true
	else
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\014\020\089\048\102"), 
			Buttons = {
				_XQxqd("\058\014\035\060\121\048\121\054\089\102")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputpostnumberquestion)
						end)
					end
				end
			end
		}
	end
end
function zinputcafequestion:OnGetInput(input)
	if input == nil then
		input = ""
	end
	cafequestion = input
	if Wherigo.NoCaseEquals(cafequestion, _XQxqd("\032\086\074\025\055\001\079\071")) then
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\027\059\059\060\009\020\089\027\045\060\089\020\050\060\026\020\097\063\059\027\058\027\060\058\024\027\060\089\027\043\058\060\058\121\046\053\051")
		}
		zoneThecarpark.Visible = true
		zonethecafe.Visible = false
		ztaskgotothebaseofabighill.Visible = true
	else
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\014\020\089\048\102"), 
			Buttons = {
				_XQxqd("\058\014\035\060\121\048\121\054\089\102")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputcafequestion)
						end)
					end
				end
			end
		}
	end
end
function zinputpostnumberquestion2:OnGetInput(input)
	if input == nil then
		input = ""
	end
	postnumberquestion2 = input
	if Wherigo.NoCaseEquals(postnumberquestion2, _XQxqd("\015\015")) then
		_Urwigo.MessageBox{
			Text = _XQxqd("\036\020\014\014\027\026\058\102")
		}
		zonenearthecastle.Visible = true
		_Urwigo.MessageBox{
			Text = _XQxqd("\026\020\097\063\059\027\058\027\060\058\024\027\060\089\027\043\058\060\058\121\046\053"), 
			Buttons = {
				_XQxqd("\001\127")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						ztaskgetthecodefromthelibrary.Visible = true
						zonenearthecastle.Visible = true
						ztaskgoupthehill.Visible = false
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\014\020\089\048\102"), 
			Buttons = {
				_XQxqd("\006\014\035\060\121\048\121\054\089\102")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputpostnumberquestion2)
						end)
					end
				end
			end
		}
	end
end
function zinputgutterquestion:OnGetInput(input)
	if input == nil then
		input = ""
	end
	gutterquestion = input
	if Wherigo.NoCaseEquals(gutterquestion, _XQxqd("\015\122\094\015")) then
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\027\059\059\060\009\020\089\027\102\060\089\020\050\060\035\020\104\060\085\027\058\058\027\014\060\048\020\060\048\027\058\060\035\020\104\014\060\026\121\026\024\027\102\060\048\020\060\013\054\121\060\072\009\020\050\089\060\058\024\027\060\059\121\089\027\072"), 
			Buttons = {
				_XQxqd("\001\127")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zonedownthelane.Visible = true
						zonethechurch.Visible = false
						ztaskgetthecache.Visible = true
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _XQxqd("\050\014\020\089\048"), 
			Buttons = {
				_XQxqd("\058\014\035\060\121\048\121\054\089\102")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputgutterquestion)
						end)
					end
				end
			end
		}
	end
end
function zitemcode:OnClick()
	_Urwigo.MessageBox{
		Text = _XQxqd("\046\058\121\014\058\060\121\058\060\029\060\058\104\014\089\060\036\059\020\026\053\050\054\046\027\060\095\060\014\027\013\020\059\104\058\054\020\089\046\060\058\020\060\095\052\051\060\002\089\085\046\063\126\058\024\027\089\060\121\089\054\093\026\059\020\026\053\050\054\046\027\060\020\089\027\060\014\027\013\020\059\104\058\054\020\089\060\058\020\060\015\015\051\060\058\024\027\089\060\026\059\020\026\053\050\054\046\027\060\058\020\060\029\051\060\063\104\059\059\060\058\024\027\060\046\024\121\026\053\059\027\051\060\085\027\060\063\121\058\054\027\089\058\051\060\014\027\121\009\060\026\121\014\027\087\104\059\059\035"), 
		Media = zmediacode, 
		Buttons = {
			_XQxqd("\063\054\026\053\060\104\063")
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					zitemcode:MoveTo(Player)
				end
				if Player:Contains(zitemcode) and zonethelibrary:Contains(Player) then
					zonetherailwaystation.Visible = true
					ztaskgotothechurch.Visible = true
					ztaskgetthecodefromthelibrary.Visible = false
				end
			end
		end
	}
end
function zitemlifering:Onthrow(target)
end
function zitemlifering:OnClick()
	if zonethebridge:Contains(zitemlifering) and (not Player:Contains(zitemlifering)) then
		_Urwigo.MessageBox{
			Text = _XQxqd("\121\060\079\054\087\027\060\014\054\089\048\060\058\024\054\046\060\026\020\104\059\009\060\026\020\097\027\060\054\089\060\024\121\089\009\035\102"), 
			Buttons = {
				_XQxqd("\113\054\026\053\060\007\063")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemlifering:MoveTo(Player)
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputgatequestion)
						end)
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _XQxqd("\086\060\059\054\087\027\060\074\054\089\048\045\060\058\024\054\046\060\026\020\104\059\009\060\026\020\097\027\060\054\089\060\024\121\089\009\035\102")
		}
	end
end

-- Begin user functions --
-- End Urwigo functions --
-----------------------------------------------------------------------------------------------
-- URWIGO: Following code is imported from the Wherigo Builder cartridge.
-- It is only neccessary if the cartridge uses Author functions that use message box callbacks.
-- Otherwise it can be removed.
cartAroundtheRiver.MsgBoxCBFuncs = {}
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=19#--
cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.GetInput(zinputpostquestion)
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.MessageBox{Text=[[well, thats on your way so we'll collect that later.]],}
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB4 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemlifering:MoveTo(zcharacterdrowningswimmer)
end
if   zcharacterdrowningswimmer:Contains(zitemlifering) then
Wherigo.MessageBox{Text=[[thankyou for saving me, I am very gratefull. I see you are looking for the wherigo. I am friends with the owner and I know that you have to get a code from the library to open the box. I hope that this information helps you.]],Media=zmediaswimmer,Buttons={"thank swimmer",},Callback=cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB3}
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB5 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.GetInput(zinputgatequestion)
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB6 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.GetInput(zinputsignpostquestion)
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB7 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.GetInput(zinputtouristinfoquestion)
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB10 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zoneTheviaduct.Visible = true
ztaskgotothecafe.Visible = true
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB8 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.MessageBox{Text=[[the library is on your way. you can pick it up later.]],Media=zmediaswimmer,Buttons={"OK",},Callback=cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB10}
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB9 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemlifering.Visible = false
Wherigo.MessageBox{Text=[[thank you very much, i nearly died! I see that you are doing the wherigo. I am friends with the cache owner and I know that you need a code to open the container. this is at the library.]],Media=zmediaswimmer,Buttons={"thank you",},Callback=cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB8}
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB11 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.GetInput(zinputcafequestion)
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB12 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.GetInput(zinputpostnumberquestion)
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB13 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.GetInput(zinputpostnumberquestion2)
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemlifering:MoveTo(Player)
end
if   Player:Contains(zitemlifering) then
Wherigo.GetInput(zinputgatequestion)
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB16 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zonedownthelane.Visible = true
zonethechurch.Visible = false
ztaskgetthecache.Visible = true
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB17 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.GetInput(zinputgutterquestion)
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB15 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemcode:MoveTo(Player)
end
if   Player:Contains(zitemcode) and zonethelibrary:Contains(Player) then
zonetherailwaystation.Visible = true
ztaskgotothechurch.Visible = true
ztaskgetthecodefromthelibrary.Visible = false
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB14 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
ztaskgetthecodefromthelibrary.Visible = true
zonenearthecastle.Visible = true
ztaskgoupthehill.Visible = false
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB18 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zonehenshaws.Visible = false
end
end

cartAroundtheRiver.MsgBoxCBFuncs.MsgBoxCB19 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemlifering:MoveTo(Player)
Wherigo.GetInput(zinputgatequestion)
end
end


-----------------------------------------------------------------------------------------------
-- URWIGO: Here follow imported Author functions


-- End user functions --
return cartAroundtheRiver
