require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _oTE(str)
	local res = ""
    local dtable = "\107\067\066\084\037\077\113\007\061\028\123\040\058\039\009\096\004\019\080\099\101\001\079\050\095\045\126\122\029\030\051\114\055\076\014\118\062\087\075\124\110\091\065\018\006\073\116\013\049\024\090\111\105\109\008\003\088\098\125\108\106\027\047\102\010\002\064\048\115\081\089\056\036\119\046\023\083\011\092\052\021\005\060\085\100\042\117\082\031\038\000\104\016\059\070\057\025\033\112\044\022\120\053\086\094\121\093\012\078\026\034\103\069\063\068\072\054\071\017\074\097\043\041\015\020\032\035"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_GNTH = Wherigo.ZCartridge()

-- Media --
_Egu7 = Wherigo.ZMedia(_GNTH)
_Egu7.Id = "9162784d-90ee-4095-9a26-0410b92d8962"
_Egu7.Name = _oTE("\120\087\041\021")
_Egu7.Description = _oTE("\120\087\041\021")
_Egu7.AltText = ""
_Egu7.Resources = {
	{
		Type = "gif", 
		Filename = "NOARAPH.gif", 
		Directives = {}
	}
}
_Ajw3p = Wherigo.ZMedia(_GNTH)
_Ajw3p.Id = "49a391a6-b847-40e3-bfb8-77ba7d01e64b"
_Ajw3p.Name = _oTE("\053\020\052\041\025\120\087\041\021")
_Ajw3p.Description = _oTE("\053\020\052\041\025\120\087\041\021")
_Ajw3p.AltText = ""
_Ajw3p.Resources = {
	{
		Type = "jpg", 
		Filename = "NOARAPH3232.jpg", 
		Directives = {}
	}
}
_NK6Uz = Wherigo.ZMedia(_GNTH)
_NK6Uz.Id = "e701c714-b48e-4630-b9b5-4de5b6f4b4de"
_NK6Uz.Name = _oTE("\004\032\021\069\052\032")
_NK6Uz.Description = _oTE("\047\032\021\069\052\032")
_NK6Uz.AltText = ""
_NK6Uz.Resources = {
	{
		Type = "png", 
		Filename = "Coffre300300.png", 
		Directives = {}
	}
}
_AC9R = Wherigo.ZMedia(_GNTH)
_AC9R.Id = "b2c316ac-5bb9-4d1e-8fd2-622c5e9b2ff8"
_AC9R.Name = _oTE("\053\020\052\041\025\047\032\021\069\052\032")
_AC9R.Description = _oTE("\053\020\052\041\021\126\047\032\021\069\052\032")
_AC9R.AltText = ""
_AC9R.Resources = {
	{
		Type = "png", 
		Filename = "IcoCoffre3232.png", 
		Directives = {}
	}
}
_XaLBi = Wherigo.ZMedia(_GNTH)
_XaLBi.Id = "73bf2c07-dffd-4352-8ecd-b4aa18c9ffd1"
_XaLBi.Name = _oTE("\003\032\121\036\052")
_XaLBi.Description = _oTE("\003\032\121\036\052")
_XaLBi.AltText = ""
_XaLBi.Resources = {
	{
		Type = "jpg", 
		Filename = "bravo220220.jpg", 
		Directives = {}
	}
}
_SUaej = Wherigo.ZMedia(_GNTH)
_SUaej.Id = "d01aef3e-5b27-4edb-ad6c-ebb7a599de63"
_SUaej.Name = _oTE("\053\020\052\041\025\003\032\121\036\052")
_SUaej.Description = _oTE("\053\020\052\041\021\126\003\032\121\036\052")
_SUaej.AltText = ""
_SUaej.Resources = {
	{
		Type = "jpg", 
		Filename = "Iconbravo-32-32.jpg", 
		Directives = {}
	}
}
__gmz7 = Wherigo.ZMedia(_GNTH)
__gmz7.Id = "f1a55807-a529-419c-a2d9-87b90757b011"
__gmz7.Name = _oTE("\099\052\069\047\021\032")
__gmz7.Description = ""
__gmz7.AltText = ""
__gmz7.Resources = {
	{
		Type = "png", 
		Filename = "logo.png", 
		Directives = {}
	}
}
_hInt = Wherigo.ZMedia(_GNTH)
_hInt.Id = "c9c59b82-005e-436e-94a0-73032eda0e4e"
_hInt.Name = _oTE("\053\020\052\041")
_hInt.Description = ""
_hInt.AltText = ""
_hInt.Resources = {
	{
		Type = "png", 
		Filename = "iconewherigo.png", 
		Directives = {}
	}
}
-- Cartridge Info --
_GNTH.Id="1a8e0de2-3af3-4ffd-b18b-47283a99f931"
_GNTH.Name="Initiation"
_GNTH.Description=[[Cartouche pour l event initiation wherigo realise par Team verturin et Zombi.dc]]
_GNTH.Visible=true
_GNTH.Activity="Geocache"
_GNTH.StartingLocationDescription=[[Cartouche pour l event initiation wherigo realise par Team verturin et Zombi.dc]]
_GNTH.StartingLocation = ZonePoint(48.6213333333333,2.56475,0)
_GNTH.Version="V1"
_GNTH.Company="Team Verturin et Zombi.dc"
_GNTH.Author="Team Verturin et Zombi.dc"
_GNTH.BuilderVersion="URWIGO 1.21.5528.18461"
_GNTH.CreateDate="03/01/2015 16:29:22"
_GNTH.PublishDate="1/1/0001 12:00:00 AM"
_GNTH.UpdateDate="03/05/2015 17:28:17"
_GNTH.LastPlayedDate="1/1/0001 12:00:00 AM"
_GNTH.TargetDevice="PocketPC"
_GNTH.TargetDeviceVersion="0"
_GNTH.StateId="1"
_GNTH.CountryId="2"
_GNTH.Complete=false
_GNTH.UseLogging=true

_GNTH.Media=__gmz7

_GNTH.Icon=_hInt


-- Zones --
_NPZ = Wherigo.Zone(_GNTH)
_NPZ.Id = "8f22ef74-5dfd-48a7-ae65-9ab6a4366bbd"
_NPZ.Name = _oTE("\006\121\126\099\032\021\054\053\021\032\021\126\028\052\041\021")
_NPZ.Description = _oTE("\034\121\126\099\032\021\054\053\021\032\021\126\028\052\041\021\126\085\021\126\020\021\047\047\021\126\121\036\021\041\047\087\032\021")
_NPZ.Visible = true
_NPZ.Commands = {}
_NPZ.DistanceRange = Distance(-1, "feet")
_NPZ.ShowObjects = "OnEnter"
_NPZ.ProximityRange = Distance(60, "meters")
_NPZ.AllowSetPositionTo = false
_NPZ.Active = true
_NPZ.Points = {
	ZonePoint(48.6213654972257, 2.56449872951694, 0), 
	ZonePoint(48.621414242503, 2.56461233082566, 0), 
	ZonePoint(48.6213299263179, 2.56469803005853, 0), 
	ZonePoint(48.6212785460736, 2.56458841476069, 0)
}
_NPZ.OriginalPoint = ZonePoint(48.6213470530301, 2.56459937629046, 0)
_NPZ.DistanceRangeUOM = "Feet"
_NPZ.ProximityRangeUOM = "Meters"
_NPZ.OutOfRangeName = ""
_NPZ.InRangeName = ""
_o5nqK = Wherigo.Zone(_GNTH)
_o5nqK.Id = "ac56faeb-36b5-40af-b0f1-7ebcd0d4e50e"
_o5nqK.Name = _oTE("\051\052\041\021\126\007\087\021\069\047\053\052\041")
_o5nqK.Description = _oTE("\113\054\099\060\121\020\021\054\021\041\047\126\085\021\126\060\121\126\028\052\041\021\126\007\087\021\069\047\053\052\041")
_o5nqK.Visible = false
_o5nqK.Commands = {}
_o5nqK.DistanceRange = Distance(-1, "feet")
_o5nqK.ShowObjects = "OnEnter"
_o5nqK.ProximityRange = Distance(60, "meters")
_o5nqK.AllowSetPositionTo = false
_o5nqK.Active = false
_o5nqK.Points = {
	ZonePoint(48.6178217092593, 2.56854106637742, 0), 
	ZonePoint(48.6176677110602, 2.56871470865717, 0), 
	ZonePoint(48.6179001978173, 2.56937996504955, 0), 
	ZonePoint(48.618042503417, 2.56922406569716, 0)
}
_o5nqK.OriginalPoint = ZonePoint(48.6178580303885, 2.56896495144533, 0)
_o5nqK.DistanceRangeUOM = "Feet"
_o5nqK.ProximityRangeUOM = "Meters"
_o5nqK.OutOfRangeName = ""
_o5nqK.InRangeName = ""

-- Characters --
_GuuuJ = Wherigo.ZCharacter{
	Cartridge = _GNTH, 
	Container = _o5nqK
}
_GuuuJ.Id = "a34af33e-72a9-423a-bb3f-13c0d9ab8dee"
_GuuuJ.Name = _oTE("\120\087\041\021")
_GuuuJ.Description = ""
_GuuuJ.Visible = true
_GuuuJ.Media = _Egu7
_GuuuJ.Icon = _Ajw3p
_GuuuJ.Commands = {
	_BPh = Wherigo.ZCommand{
		Text = _oTE("\019\121\032\060\021\032"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _oTE("\109\052\047\092\053\041\112\126\121\036\121\053\060\121\058\060\021")
	}
}
_GuuuJ.Commands._BPh.Custom = true
_GuuuJ.Commands._BPh.Id = "61d8f4da-9a3e-478e-b2d3-075a05597b49"
_GuuuJ.Commands._BPh.WorksWithAll = true
_GuuuJ.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_GuuuJ.Gender = "It"
_GuuuJ.Type = "NPC"

-- Items --
_5D5 = Wherigo.ZItem(_GNTH)
_5D5.Id = "ce14e16c-1c83-4880-a5d1-f8516cad5ada"
_5D5.Name = _oTE("\002\052\054\099\060\021\047\053\052\041\126\002\052\085\021")
_5D5.Description = ""
_5D5.Visible = true
_5D5.Media = _XaLBi
_5D5.Icon = _SUaej
_5D5.Commands = {}
_5D5.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_5D5.Locked = false
_5D5.Opened = false
_OnoEa = Wherigo.ZItem(_GNTH)
_OnoEa.Id = "5f7ca449-2536-41ec-a0ce-5a89b2e33825"
_OnoEa.Name = _oTE("\077\052\060\087\047\053\052\041")
_OnoEa.Description = _oTE("\109\080\072\126\031\033\075\068\033\117\126\113\068\068\024\126\031\080\075\049\103\049\083\003\088\037\115\121\041\069\126\060\014\121\032\058\032\021")
_OnoEa.Visible = true
_OnoEa.Media = _NK6Uz
_OnoEa.Icon = _AC9R
_OnoEa.Commands = {}
_OnoEa.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_OnoEa.Locked = false
_OnoEa.Opened = false

-- Tasks --
_iVDX0 = Wherigo.ZTask(_GNTH)
_iVDX0.Id = "3868f56b-0d95-4877-9db7-513e77e6a946"
_iVDX0.Name = _oTE("\088\021\061\052\053\041\085\032\021\126\060\121\126\028\052\041\021\126\007\087\021\069\047\053\052\041")
_iVDX0.Description = _oTE("\088\021\061\052\053\041\085\032\021\126\060\121\126\028\052\041\021\126\007\087\021\069\047\053\052\041")
_iVDX0.Visible = true
_iVDX0.Active = false
_iVDX0.Complete = false
_iVDX0.CorrectState = "None"
_t_D2X = Wherigo.ZTask(_GNTH)
_t_D2X.Id = "988d7e11-3aa2-4b8c-b7f4-9081ef198498"
_t_D2X.Name = _oTE("\019\121\032\060\021\032\126\121\036\021\020\126\120\087\041\021")
_t_D2X.Description = _oTE("\019\121\032\060\021\032\126\121\036\021\020\126\120\087\041\021")
_t_D2X.Visible = true
_t_D2X.Active = false
_t_D2X.Complete = false
_t_D2X.CorrectState = "None"

-- Cartridge Variables --
_K0EW4 = _oTE("\025\109\019\051")
_xkR = _oTE("\025\118\087\087\087\120")
_geujV = _oTE("\025\103\115\103")
_fbPTp = _oTE("\025\053\104\115\057\068")
_JV2Hv = _oTE("\025\068\002\054\032\003")
_47A = _oTE("\085\087\054\054\106")
_GNTH.ZVariables = {
	_K0EW4 = _oTE("\025\109\019\051"), 
	_xkR = _oTE("\025\118\087\087\087\120"), 
	_geujV = _oTE("\025\103\115\103"), 
	_fbPTp = _oTE("\025\053\104\115\057\068"), 
	_JV2Hv = _oTE("\025\068\002\054\032\003"), 
	_47A = _oTE("\085\087\054\054\106")
}

-- Timers --

-- Inputs --
_0CmrB = Wherigo.ZInput(_GNTH)
_0CmrB.Id = "c28589aa-86cc-47c6-8574-a74add015337"
_0CmrB.Name = _oTE("\070\087\021\069\047\053\052\041")
_0CmrB.Description = _oTE("\070\087\021\069\047\053\052\041\126\085\021\126\060\121\126\028\052\041\021\126\024")
_0CmrB.Visible = true
_0CmrB.InputType = "Text"
_0CmrB.Text = _oTE("\002\052\054\058\053\021\041\126\064\052\041\047\126\024\126\122\126\024")

-- WorksWithList for object commands --

-- functions --
function _GNTH:OnStart()
	_Urwigo.MessageBox{
		Text = _oTE("\003\052\041\061\052\087\032\126\021\047\126\058\053\021\041\036\021\041\087\126\085\121\041\069\126\036\052\047\032\021\126\099\032\021\054\053\021\032\021\126\020\121\032\047\052\087\020\092\021\075\083\003\088\037\115\053\032\021\020\047\053\052\041\126\060\121\126\028\052\041\021\126\049"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _NPZ)
			end
		end
	}
end
function _GNTH:OnRestore()
end
function _NPZ:OnEnter()
	_K0EW4 = _oTE("\025\109\019\051")
	_Urwigo.MessageBox{
		Text = _oTE("\003\053\021\041\036\021\041\087\126\085\121\041\069\126\060\121\126\028\052\041\021\126\049\100\126\085\053\032\021\020\047\053\052\041\126\060\121\126\028\052\041\021\126\007\087\021\069\047\053\052\041"), 
		Callback = function(action)
			if action ~= nil then
				_o5nqK.Visible = true
				_o5nqK.Active = true
				_NPZ.Visible = false
				_NPZ.Active = false
				_iVDX0.Active = true
				_GNTH:RequestSync()
			end
		end
	}
end
function _o5nqK:OnEnter()
	_K0EW4 = _oTE("\025\052\103\041\007\039")
	_Urwigo.MessageBox{
		Text = _oTE("\003\032\121\036\052\126\099\052\087\032\126\121\036\052\053\032\126\032\021\061\052\053\041\047\126\060\121\126\028\052\041\021\126\007\087\021\069\047\053\052\041\100\126\121\060\060\021\028\126\036\052\053\032\126\120\087\041\021")
	}
	_t_D2X.Active = true
	_iVDX0.Complete = true
end
function _0CmrB:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 4 then
		_Urwigo.OldDialog{
			{
				Text = _oTE("\003\032\121\036\052\126\020\126\021\069\047\126\060\121\126\058\052\041\041\021\126\032\021\099\052\041\069\021\100\126\036\052\087\069\126\021\047\021\069\126\087\041\126\121\036\021\041\047\087\032\053\021\032\126\121\020\020\052\054\099\060\053\098\126\120\021\126\036\052\087\069\126\085\052\041\041\021\126\060\021\069\126\020\052\052\032\085\052\041\041\021\069\126\085\087\126\047\032\021\069\052\032\126\021\047\126\060\021\126\020\052\085\021\126\085\021\126\020\052\054\099\060\021\047\053\052\041\126\085\121\041\069\126\036\052\047\032\021\126\053\041\036\021\041\047\121\053\032\021"), 
				Media = _XaLBi
			}
		}
		_OnoEa:MoveTo(Player)
		_5D5.Description = string.sub(Player.CompletionCode, 1, 15)
		_5D5:MoveTo(Player)
	elseif input ~= 4 then
		_Urwigo.Dialog(false, {
			{
				Text = _oTE("\002\021\126\041\126\021\069\047\126\099\121\069\126\060\121\126\058\052\041\041\021\126\032\021\099\052\041\069\021\100\126\021\069\069\121\106\021\032\126\021\041\020\052\032\021\098")
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_0CmrB)
			end)
		end)
	end
end
function _GuuuJ:On_BPh(target)
	_t_D2X.Complete = true
	_Urwigo.Dialog(false, {
		{
			Text = _oTE("\006\121\053\041\047\021\041\121\041\047\126\087\041\126\099\021\047\053\047\126\020\121\020\087\060")
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_0CmrB)
		end)
	end)
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return _GNTH
