require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _vth(str)
	local res = ""
    local dtable = "\025\078\035\105\037\005\119\108\017\094\085\059\110\100\002\109\102\047\121\048\007\099\031\033\021\026\001\029\067\022\082\123\062\008\112\046\106\096\042\040\003\071\058\032\019\010\113\030\116\122\061\049\060\044\083\018\093\124\052\051\039\006\079\092\081\077\054\043\055\063\090\091\023\013\069\068\000\126\087\103\050\038\057\024\053\073\125\066\056\089\012\004\114\120\088\070\014\075\118\086\101\076\045\016\111\028\065\117\011\027\041\115\009\036\104\015\098\097\074\107\084\080\072\034\095\020\064"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

cartItsForestGhostsBirthda = Wherigo.ZCartridge()

-- Media --
zmedia365321e811354e1a91469f1619f81d09 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia365321e811354e1a91469f1619f81d09.Id = "a0129c73-1444-4591-9809-7aa9501ec565"
zmedia365321e811354e1a91469f1619f81d09.Name = _vth("\060\067\085\060\081\052\101\089\052\052\060\085\059\101\052\118\083\052\059\067\083\017\052\067\052\083\017\089\052\014\020\083")
zmedia365321e811354e1a91469f1619f81d09.Description = _vth("\016\101\014\004\118")
zmedia365321e811354e1a91469f1619f81d09.AltText = ""
zmedia365321e811354e1a91469f1619f81d09.Resources = {
	{
		Type = "jpg", 
		Filename = "365321e8-1135-4e1a-9146-9f1619f81d09.jpg", 
		Directives = {}
	}
}
zmedia3814cc131c0d4e77a25a082639535148 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia3814cc131c0d4e77a25a082639535148.Id = "1b66adf6-c58d-4cc4-97dd-7ba63fc2e683"
zmedia3814cc131c0d4e77a25a082639535148.Name = _vth("\060\089\052\059\022\022\052\060\052\022\020\014\059\101\069\069\118\081\085\118\020\089\081\067\060\083\085\060\085\052\059\089")
zmedia3814cc131c0d4e77a25a082639535148.Description = _vth("\016\101\014\004\118")
zmedia3814cc131c0d4e77a25a082639535148.AltText = ""
zmedia3814cc131c0d4e77a25a082639535148.Resources = {
	{
		Type = "jpg", 
		Filename = "3814cc13-1c0d-4e77-a25a-082639535148.jpg", 
		Directives = {}
	}
}
zmedia998a6b21f71d46cabc38c18f5965e636 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia998a6b21f71d46cabc38c18f5965e636.Id = "12c53fc2-07df-4dbf-9860-bc3a2f9760d9"
zmedia998a6b21f71d46cabc38c18f5965e636.Name = _vth("\083\083\089\118\067\117\081\052\017\069\052\014\059\067\022\118\117\022\060\089\022\052\089\017\085\083\067\085\101\067\060\067")
zmedia998a6b21f71d46cabc38c18f5965e636.Description = _vth("\016\101\014\004\118")
zmedia998a6b21f71d46cabc38c18f5965e636.AltText = ""
zmedia998a6b21f71d46cabc38c18f5965e636.Resources = {
	{
		Type = "jpg", 
		Filename = "998a6b21-f71d-46ca-bc38-c18f5965e636.jpg", 
		Directives = {}
	}
}
zmediab1781b820a274772b6ef1143235f0e16 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmediab1781b820a274772b6ef1143235f0e16.Id = "f88c16a4-e6d5-49b4-916c-aa6c9462fb97"
zmediab1781b820a274772b6ef1143235f0e16.Name = _vth("\117\052\069\089\052\117\089\081\020\118\081\069\059\069\069\081\117\067\101\017\052\052\059\060\081\060\085\017\020\101\052\067")
zmediab1781b820a274772b6ef1143235f0e16.Description = _vth("\016\101\014\004\118")
zmediab1781b820a274772b6ef1143235f0e16.AltText = ""
zmediab1781b820a274772b6ef1143235f0e16.Resources = {
	{
		Type = "jpg", 
		Filename = "b1781b82-0a27-4772-b6ef-1143235f0e16.jpg", 
		Directives = {}
	}
}
zmedia1ebeb3e3874a45b3af165f54c85d17f3 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia1ebeb3e3874a45b3af165f54c85d17f3.Id = "2fd90ea0-a5ee-4622-9853-494524c9f317"
zmedia1ebeb3e3874a45b3af165f54c85d17f3.Name = _vth("\052\101\117\101\117\060\101\060\089\069\059\118\059\085\117\060\118\017\052\067\085\017\085\059\022\089\085\014\052\069\017\060")
zmedia1ebeb3e3874a45b3af165f54c85d17f3.Description = _vth("\016\101\014\004\118")
zmedia1ebeb3e3874a45b3af165f54c85d17f3.AltText = ""
zmedia1ebeb3e3874a45b3af165f54c85d17f3.Resources = {
	{
		Type = "jpg", 
		Filename = "1ebeb3e3-874a-45b3-af16-5f54c85d17f3.jpg", 
		Directives = {}
	}
}
zmedia924bbf47cc714bd490a0010444ee3999 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia924bbf47cc714bd490a0010444ee3999.Id = "bb0971eb-ddaf-45aa-a443-b5b4bad4f61e"
zmedia924bbf47cc714bd490a0010444ee3999.Name = _vth("\083\081\059\117\117\017\059\069\022\022\069\052\059\117\014\059\083\020\118\020\020\052\020\059\059\059\101\101\060\083\083\083")
zmedia924bbf47cc714bd490a0010444ee3999.Description = _vth("\016\101\014\004\118")
zmedia924bbf47cc714bd490a0010444ee3999.AltText = ""
zmedia924bbf47cc714bd490a0010444ee3999.Resources = {
	{
		Type = "jpg", 
		Filename = "924bbf47-cc71-4bd4-90a0-010444ee3999.jpg", 
		Directives = {}
	}
}
zmedia3caa46ab22e4486d87037b7835563890 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia3caa46ab22e4486d87037b7835563890.Id = "d6dd6cda-35e5-4e60-8317-7ab39af6e956"
zmedia3caa46ab22e4486d87037b7835563890.Name = _vth("\060\022\118\118\059\067\118\117\081\081\101\059\059\089\067\014\089\069\020\060\069\117\069\089\060\085\085\067\060\089\083\020")
zmedia3caa46ab22e4486d87037b7835563890.Description = _vth("\016\101\014\004\118")
zmedia3caa46ab22e4486d87037b7835563890.AltText = ""
zmedia3caa46ab22e4486d87037b7835563890.Resources = {
	{
		Type = "jpg", 
		Filename = "3caa46ab-22e4-486d-8703-7b7835563890.jpg", 
		Directives = {}
	}
}
zmedia82cc89e7144243239a4cbdc6f3c873a2 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia82cc89e7144243239a4cbdc6f3c873a2.Id = "ca1ed6fb-b30d-4fd6-9849-eb07a11c561f"
zmedia82cc89e7144243239a4cbdc6f3c873a2.Name = _vth("\089\081\022\022\089\083\101\069\052\059\059\081\059\060\081\060\083\118\059\022\117\014\022\067\017\060\022\089\069\060\118\081")
zmedia82cc89e7144243239a4cbdc6f3c873a2.Description = _vth("\016\101\014\004\118")
zmedia82cc89e7144243239a4cbdc6f3c873a2.AltText = ""
zmedia82cc89e7144243239a4cbdc6f3c873a2.Resources = {
	{
		Type = "jpg", 
		Filename = "82cc89e7-1442-4323-9a4c-bdc6f3c873a2.jpg", 
		Directives = {}
	}
}
zmedia193061bfa6584125b2fc739f7c1ea934 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia193061bfa6584125b2fc739f7c1ea934.Id = "8d2797ac-baac-4b08-8e70-b712609a473a"
zmedia193061bfa6584125b2fc739f7c1ea934.Name = _vth("\052\083\060\020\067\052\117\017\118\067\085\089\059\052\081\085\117\081\017\022\069\060\083\017\069\022\052\101\118\083\060\059")
zmedia193061bfa6584125b2fc739f7c1ea934.Description = _vth("\016\101\014\004\118")
zmedia193061bfa6584125b2fc739f7c1ea934.AltText = ""
zmedia193061bfa6584125b2fc739f7c1ea934.Resources = {
	{
		Type = "jpg", 
		Filename = "193061bf-a658-4125-b2fc-739f7c1ea934.jpg", 
		Directives = {}
	}
}
zmedia2212b3f5fed840d68b0b165813b64fa8 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia2212b3f5fed840d68b0b165813b64fa8.Id = "d6b80c2c-b922-4975-92a2-d0888f2efb53"
zmedia2212b3f5fed840d68b0b165813b64fa8.Name = _vth("\081\081\052\081\117\060\017\085\017\101\014\089\059\020\014\067\089\117\020\117\052\067\085\089\052\060\117\067\059\017\118\089")
zmedia2212b3f5fed840d68b0b165813b64fa8.Description = _vth("\016\101\014\004\118")
zmedia2212b3f5fed840d68b0b165813b64fa8.AltText = ""
zmedia2212b3f5fed840d68b0b165813b64fa8.Resources = {
	{
		Type = "jpg", 
		Filename = "2212b3f5-fed8-40d6-8b0b-165813b64fa8.jpg", 
		Directives = {}
	}
}
zmedia2fb387e7a7b84fbc9a88b35c7462e540 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia2fb387e7a7b84fbc9a88b35c7462e540.Id = "ce0504c1-0edb-4003-ba49-9631df62ab2f"
zmedia2fb387e7a7b84fbc9a88b35c7462e540.Name = _vth("\081\017\117\060\089\069\101\069\118\069\117\089\059\017\117\022\083\118\089\089\117\060\085\022\069\059\067\081\101\085\059\020")
zmedia2fb387e7a7b84fbc9a88b35c7462e540.Description = _vth("\016\101\014\004\118")
zmedia2fb387e7a7b84fbc9a88b35c7462e540.AltText = ""
zmedia2fb387e7a7b84fbc9a88b35c7462e540.Resources = {
	{
		Type = "jpg", 
		Filename = "2fb387e7-a7b8-4fbc-9a88-b35c7462e540.jpg", 
		Directives = {}
	}
}
zmedia026247aa1c6649fbb600891b9ba9fb06 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia026247aa1c6649fbb600891b9ba9fb06.Id = "00dfee99-af2d-4ad5-8717-5c6f69935639"
zmedia026247aa1c6649fbb600891b9ba9fb06.Name = _vth("\020\081\067\081\059\069\118\118\052\022\067\067\059\083\017\117\117\067\020\020\089\083\052\117\083\117\118\083\017\117\020\067")
zmedia026247aa1c6649fbb600891b9ba9fb06.Description = _vth("\016\101\014\004\118")
zmedia026247aa1c6649fbb600891b9ba9fb06.AltText = ""
zmedia026247aa1c6649fbb600891b9ba9fb06.Resources = {
	{
		Type = "jpg", 
		Filename = "026247aa-1c66-49fb-b600-891b9ba9fb06.jpg", 
		Directives = {}
	}
}
zmedia28ff90ba58c8440397a5cacf54834e97 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia28ff90ba58c8440397a5cacf54834e97.Id = "ee3d9b14-8d99-4a79-a94e-0ad3e0714bfd"
zmedia28ff90ba58c8440397a5cacf54834e97.Name = _vth("\081\089\017\017\083\020\117\118\085\089\022\089\059\059\020\060\083\069\118\085\022\118\022\017\085\059\089\060\059\101\083\069")
zmedia28ff90ba58c8440397a5cacf54834e97.Description = _vth("\016\101\014\004\118")
zmedia28ff90ba58c8440397a5cacf54834e97.AltText = ""
zmedia28ff90ba58c8440397a5cacf54834e97.Resources = {
	{
		Type = "jpg", 
		Filename = "28ff90ba-58c8-4403-97a5-cacf54834e97.jpg", 
		Directives = {}
	}
}
zmediad76536b3bcac4768ad8f58bafbb3ade9 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmediad76536b3bcac4768ad8f58bafbb3ade9.Id = "ea6eb559-9404-4cb5-af82-4f159284b069"
zmediad76536b3bcac4768ad8f58bafbb3ade9.Name = _vth("\014\069\067\085\060\067\117\060\117\022\118\022\059\069\067\089\118\014\089\017\085\089\117\118\017\117\117\060\118\014\101\083")
zmediad76536b3bcac4768ad8f58bafbb3ade9.Description = _vth("\016\101\014\004\118")
zmediad76536b3bcac4768ad8f58bafbb3ade9.AltText = ""
zmediad76536b3bcac4768ad8f58bafbb3ade9.Resources = {
	{
		Type = "jpg", 
		Filename = "d76536b3-bcac-4768-ad8f-58bafbb3ade9.jpg", 
		Directives = {}
	}
}
zmediaf6855ba486e249dd8ce8be32eb43627f = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmediaf6855ba486e249dd8ce8be32eb43627f.Id = "99b7fe72-f044-4940-8f54-d4ab8ec0bd54"
zmediaf6855ba486e249dd8ce8be32eb43627f.Name = _vth("\017\067\089\085\085\117\118\059\089\067\101\081\059\083\014\014\089\022\101\089\117\101\060\081\101\117\059\060\067\081\069\017")
zmediaf6855ba486e249dd8ce8be32eb43627f.Description = _vth("\016\101\014\004\118")
zmediaf6855ba486e249dd8ce8be32eb43627f.AltText = ""
zmediaf6855ba486e249dd8ce8be32eb43627f.Resources = {
	{
		Type = "jpg", 
		Filename = "f6855ba4-86e2-49dd-8ce8-be32eb43627f.jpg", 
		Directives = {}
	}
}
zmediab8900ca4d91a43d7b3528a614fdb71a7 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmediab8900ca4d91a43d7b3528a614fdb71a7.Id = "6b037cba-cc5e-4b59-a5b0-c163932b2a6c"
zmediab8900ca4d91a43d7b3528a614fdb71a7.Name = _vth("\117\089\083\020\020\022\118\059\014\083\052\118\059\060\014\069\117\060\085\081\089\118\067\052\059\017\014\117\069\052\118\069")
zmediab8900ca4d91a43d7b3528a614fdb71a7.Description = _vth("\016\101\014\004\118")
zmediab8900ca4d91a43d7b3528a614fdb71a7.AltText = ""
zmediab8900ca4d91a43d7b3528a614fdb71a7.Resources = {
	{
		Type = "jpg", 
		Filename = "b8900ca4-d91a-43d7-b352-8a614fdb71a7.jpg", 
		Directives = {}
	}
}
zmedia89927a218ae44510b1287653d5110486 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia89927a218ae44510b1287653d5110486.Id = "dc10818b-1f05-45f1-9423-d00cc047db51"
zmedia89927a218ae44510b1287653d5110486.Name = _vth("\089\083\083\081\069\118\081\052\089\118\101\059\059\085\052\020\117\052\081\089\069\067\085\060\014\085\052\052\020\059\089\067")
zmedia89927a218ae44510b1287653d5110486.Description = _vth("\016\101\014\004\118")
zmedia89927a218ae44510b1287653d5110486.AltText = ""
zmedia89927a218ae44510b1287653d5110486.Resources = {
	{
		Type = "jpg", 
		Filename = "89927a21-8ae4-4510-b128-7653d5110486.jpg", 
		Directives = {}
	}
}
zmediafab68ebd5b3a47fba1564c63cda0f54b = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmediafab68ebd5b3a47fba1564c63cda0f54b.Id = "1c7003e3-47a2-45c8-9f2c-ac9f6a6c219b"
zmediafab68ebd5b3a47fba1564c63cda0f54b.Name = _vth("\017\118\117\067\089\101\117\014\085\117\060\118\059\069\017\117\118\052\085\067\059\022\067\060\022\014\118\020\017\085\059\117")
zmediafab68ebd5b3a47fba1564c63cda0f54b.Description = _vth("\016\101\014\004\118")
zmediafab68ebd5b3a47fba1564c63cda0f54b.AltText = ""
zmediafab68ebd5b3a47fba1564c63cda0f54b.Resources = {
	{
		Type = "jpg", 
		Filename = "fab68ebd-5b3a-47fb-a156-4c63cda0f54b.jpg", 
		Directives = {}
	}
}
zmediaa695563474c24aa2a26006de202f6a2f = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmediaa695563474c24aa2a26006de202f6a2f.Id = "1bd3bf27-3386-433a-a4d4-e4b1a925a353"
zmediaa695563474c24aa2a26006de202f6a2f.Name = _vth("\118\067\083\085\085\067\060\059\069\059\022\081\059\118\118\081\118\081\067\020\020\067\014\101\081\020\081\017\067\118\081\017")
zmediaa695563474c24aa2a26006de202f6a2f.Description = _vth("\016\101\014\004\118")
zmediaa695563474c24aa2a26006de202f6a2f.AltText = ""
zmediaa695563474c24aa2a26006de202f6a2f.Resources = {
	{
		Type = "jpg", 
		Filename = "a6955634-74c2-4aa2-a260-06de202f6a2f.jpg", 
		Directives = {}
	}
}
zmediac58106905d714d7081e7a011c6701db6 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmediac58106905d714d7081e7a011c6701db6.Id = "b8e0a998-ec1c-4919-b169-9c24ca234481"
zmediac58106905d714d7081e7a011c6701db6.Name = _vth("\022\085\089\052\020\067\083\020\085\014\069\052\059\014\069\020\089\052\101\069\118\020\052\052\022\067\069\020\052\014\117\067")
zmediac58106905d714d7081e7a011c6701db6.Description = _vth("\016\101\014\004\118")
zmediac58106905d714d7081e7a011c6701db6.AltText = ""
zmediac58106905d714d7081e7a011c6701db6.Resources = {
	{
		Type = "jpg", 
		Filename = "c5810690-5d71-4d70-81e7-a011c6701db6.jpg", 
		Directives = {}
	}
}
zmedia77539f7956f84a09b3da5533c474bd8c = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia77539f7956f84a09b3da5533c474bd8c.Id = "36793594-3c24-43d1-bbf8-e6eb4dc781dc"
zmedia77539f7956f84a09b3da5533c474bd8c.Name = _vth("\069\069\085\060\083\017\069\083\085\067\017\089\059\118\020\083\117\060\014\118\085\085\060\060\022\059\069\059\117\014\089\022")
zmedia77539f7956f84a09b3da5533c474bd8c.Description = _vth("\016\101\014\004\118")
zmedia77539f7956f84a09b3da5533c474bd8c.AltText = ""
zmedia77539f7956f84a09b3da5533c474bd8c.Resources = {
	{
		Type = "jpg", 
		Filename = "77539f79-56f8-4a09-b3da-5533c474bd8c.jpg", 
		Directives = {}
	}
}
zmedia1f4e7de7556d47a18c36f002a7e78b0c = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia1f4e7de7556d47a18c36f002a7e78b0c.Id = "726b6ccc-0b08-4eb4-be80-9194718ba1f1"
zmedia1f4e7de7556d47a18c36f002a7e78b0c.Name = _vth("\052\017\059\101\069\014\101\069\085\085\067\014\059\069\118\052\089\022\060\067\017\020\020\081\118\069\101\069\089\117\020\022")
zmedia1f4e7de7556d47a18c36f002a7e78b0c.Description = _vth("\016\101\014\004\118")
zmedia1f4e7de7556d47a18c36f002a7e78b0c.AltText = ""
zmedia1f4e7de7556d47a18c36f002a7e78b0c.Resources = {
	{
		Type = "jpg", 
		Filename = "1f4e7de7-556d-47a1-8c36-f002a7e78b0c.jpg", 
		Directives = {}
	}
}
zmediad60c009145b44fb4a7803c246adf30fa = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmediad60c009145b44fb4a7803c246adf30fa.Id = "df105ac9-5811-4ea3-aaec-d5aa639011d7"
zmediad60c009145b44fb4a7803c246adf30fa.Name = _vth("\014\067\020\022\020\020\083\052\059\085\117\059\059\017\117\059\118\069\089\020\060\022\081\059\067\118\014\017\060\020\017\118")
zmediad60c009145b44fb4a7803c246adf30fa.Description = _vth("\016\101\014\004\118")
zmediad60c009145b44fb4a7803c246adf30fa.AltText = ""
zmediad60c009145b44fb4a7803c246adf30fa.Resources = {
	{
		Type = "jpg", 
		Filename = "d60c0091-45b4-4fb4-a780-3c246adf30fa.jpg", 
		Directives = {}
	}
}
zmedia91d1d2f08de347a9ad8ee81893ab55f5 = Wherigo.ZMedia(cartItsForestGhostsBirthda)
zmedia91d1d2f08de347a9ad8ee81893ab55f5.Id = "a25f68d3-4dc9-4724-a22e-12740671badb"
zmedia91d1d2f08de347a9ad8ee81893ab55f5.Name = _vth("\083\052\014\052\014\081\017\020\089\014\101\060\059\069\118\083\118\014\089\101\101\089\052\089\083\060\118\117\085\085\017\085")
zmedia91d1d2f08de347a9ad8ee81893ab55f5.Description = _vth("\016\101\014\004\118")
zmedia91d1d2f08de347a9ad8ee81893ab55f5.AltText = ""
zmedia91d1d2f08de347a9ad8ee81893ab55f5.Resources = {
	{
		Type = "jpg", 
		Filename = "91d1d2f0-8de3-47a9-ad8e-e81893ab55f5.jpg", 
		Directives = {}
	}
}
_Cg2B = Wherigo.ZMedia(cartItsForestGhostsBirthda)
_Cg2B.Id = "2943effb-e2a4-464a-8722-536ab532ff1d"
_Cg2B.Name = _vth("\002\118\016\101")
_Cg2B.Description = ""
_Cg2B.AltText = ""
_Cg2B.Resources = {
	{
		Type = "jpg", 
		Filename = "icon.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
cartItsForestGhostsBirthda.Id="27cbf159-3a33-465c-9f33-153512a2fc39"
cartItsForestGhostsBirthda.Name="It's Forest-Ghosts Birthday"
cartItsForestGhostsBirthda.Description=[[The Forest-Ghost is having a birthday! He's probably spending the day at some of his favorite local places. Let's track him down so we can celebrate together!]]
cartItsForestGhostsBirthda.Visible=true
cartItsForestGhostsBirthda.Activity="Geocache"
cartItsForestGhostsBirthda.StartingLocationDescription=[[]]
cartItsForestGhostsBirthda.StartingLocation = ZonePoint(38.6035166666667,-90.2612333333333,0)
cartItsForestGhostsBirthda.Version="0.01"
cartItsForestGhostsBirthda.Company=""
cartItsForestGhostsBirthda.Author="curlycue109"
cartItsForestGhostsBirthda.BuilderVersion="URWIGO 1.20.5218.24064"
cartItsForestGhostsBirthda.CreateDate="02/12/2015 05:13:00"
cartItsForestGhostsBirthda.PublishDate="1/1/0001 12:00:00 AM"
cartItsForestGhostsBirthda.UpdateDate="02/11/2015 23:15:52"
cartItsForestGhostsBirthda.LastPlayedDate="1/1/0001 12:00:00 AM"
cartItsForestGhostsBirthda.TargetDevice="PocketPC"
cartItsForestGhostsBirthda.TargetDeviceVersion="0"
cartItsForestGhostsBirthda.StateId="1"
cartItsForestGhostsBirthda.CountryId="2"
cartItsForestGhostsBirthda.Complete=false
cartItsForestGhostsBirthda.UseLogging=true

cartItsForestGhostsBirthda.Media=zmedia365321e811354e1a91469f1619f81d09

cartItsForestGhostsBirthda.Icon=_Cg2B


-- Zones --
zoneIsForestGhosthere = Wherigo.Zone(cartItsForestGhostsBirthda)
zoneIsForestGhosthere.Id = "5e55b2c2-91f5-4b6b-8d06-2fba4be7a0e3"
zoneIsForestGhosthere.Name = _vth("\086\112\044\096\105\093\101\112\049\103\042\115\105\112\049\044\115\101\093\101\070")
zoneIsForestGhosthere.Description = _vth("\086\049\061\112\044\118\044\117\101\118\108\049\004\017\108\008\044\014\118\019\044\017\105\093\044\118\044\117\004\093\049\115\014\118\019\024\044\121\115\101\044\096\105\093\101\112\049\103\042\115\105\112\049\044\004\112\044\035\093\101\049\049\019\044\112\016\118\093\049\044\118\013\014\044\035\093\101\049\049\019\044\118\022\049\004\099\101\054\044\112\105\044\086\061\008\008\044\117\101\049\044\115\101\044\112\049\118\093\049\101\014\044\115\004\112\044\014\118\019\044\105\017\017\044\093\004\080\115\049\044\007\004\049\115\044\112\105\016\101\044\117\093\101\118\120\017\118\112\049\024")
zoneIsForestGhosthere.Visible = true
zoneIsForestGhosthere.Media = zmedia3814cc131c0d4e77a25a082639535148
zoneIsForestGhosthere.Commands = {}
zoneIsForestGhosthere.DistanceRange = Distance(-1, "feet")
zoneIsForestGhosthere.ShowObjects = "OnEnter"
zoneIsForestGhosthere.ProximityRange = Distance(3, "meters")
zoneIsForestGhosthere.AllowSetPositionTo = false
zoneIsForestGhosthere.Active = true
zoneIsForestGhosthere.Points = {
	ZonePoint(38.6035516666667, -90.2611983333333, 0), 
	ZonePoint(38.6035516666667, -90.2612683333333, 0), 
	ZonePoint(38.6034816666667, -90.2612683333333, 0), 
	ZonePoint(38.6034816666667, -90.2611983333333, 0)
}
zoneIsForestGhosthere.OriginalPoint = ZonePoint(38.6035166666667, -90.2612333333333, 0)
zoneIsForestGhosthere.DistanceRangeUOM = "Feet"
zoneIsForestGhosthere.ProximityRangeUOM = "Meters"
zoneIsForestGhosthere.OutOfRangeName = ""
zoneIsForestGhosthere.InRangeName = ""
zoneMaybevisitingfriends = Wherigo.Zone(cartItsForestGhostsBirthda)
zoneMaybevisitingfriends.Id = "7ba3e68c-2e12-459b-b93a-63de0f7be538"
zoneMaybevisitingfriends.Name = _vth("\066\118\019\117\101\044\099\004\112\004\049\004\013\080\044\017\093\004\101\013\014\112\070")
zoneMaybevisitingfriends.Description = _vth("\121\115\101\044\096\105\093\101\112\049\103\042\115\105\112\049\044\004\112\044\118\013\044\118\007\101\112\105\016\101\044\080\108\019\044\007\004\049\115\044\017\093\004\101\013\014\112\044\004\013\044\118\008\008\044\014\004\017\017\101\093\101\013\049\044\022\004\093\022\008\101\112\036\044\121\115\105\112\101\044\117\093\101\118\120\017\118\112\049\044\022\093\108\016\117\112\044\112\101\101\016\044\049\105\044\101\013\014\044\115\101\093\101\036\036\036\016\118\019\117\101\044\115\101\061\112\044\115\118\099\004\013\080\044\118\044\035\118\093\049\019\044\007\004\049\115\044\115\004\112\044\118\013\004\016\118\008\044\035\118\008\112\024\044")
zoneMaybevisitingfriends.Visible = true
zoneMaybevisitingfriends.Media = zmedia1ebeb3e3874a45b3af165f54c85d17f3
zoneMaybevisitingfriends.Commands = {}
zoneMaybevisitingfriends.DistanceRange = Distance(-1, "feet")
zoneMaybevisitingfriends.ShowObjects = "OnEnter"
zoneMaybevisitingfriends.ProximityRange = Distance(6, "meters")
zoneMaybevisitingfriends.AllowSetPositionTo = false
zoneMaybevisitingfriends.Active = false
zoneMaybevisitingfriends.Points = {
	ZonePoint(38.6338709574115, -90.2912604011696, 0), 
	ZonePoint(38.6338709574115, -90.2913304011696, 0), 
	ZonePoint(38.6338009574115, -90.2913304011696, 0), 
	ZonePoint(38.6338009574115, -90.2912604011696, 0)
}
zoneMaybevisitingfriends.OriginalPoint = ZonePoint(38.6338359574115, -90.2912954011696, 0)
zoneMaybevisitingfriends.DistanceRangeUOM = "Feet"
zoneMaybevisitingfriends.ProximityRangeUOM = "Meters"
zoneMaybevisitingfriends.OutOfRangeName = ""
zoneMaybevisitingfriends.InRangeName = ""
zoneFunontheWater = Wherigo.Zone(cartItsForestGhostsBirthda)
zoneFunontheWater.Id = "6620d43f-754c-4768-b441-13ceb5f880cc"
zoneFunontheWater.Name = _vth("\096\108\013\044\105\013\044\049\115\101\044\079\118\049\101\093")
zoneFunontheWater.Description = _vth("\123\101\093\101\061\112\044\118\044\080\093\101\118\049\044\112\035\105\049\044\049\105\044\112\035\101\013\014\044\112\105\016\101\044\049\004\016\101\044\105\013\044\049\115\101\044\007\118\049\101\093\024\044\102\101\049\061\112\044\118\112\120\044\049\115\101\044\112\049\118\017\017\044\004\017\044\049\115\101\019\061\099\101\044\112\101\101\013\044\105\108\093\044\117\108\014\014\019\044\096\105\093\101\112\049\103\042\115\105\112\049\036")
zoneFunontheWater.Visible = true
zoneFunontheWater.Media = zmedia193061bfa6584125b2fc739f7c1ea934
zoneFunontheWater.Commands = {}
zoneFunontheWater.DistanceRange = Distance(-1, "feet")
zoneFunontheWater.ShowObjects = "OnEnter"
zoneFunontheWater.ProximityRange = Distance(3, "meters")
zoneFunontheWater.AllowSetPositionTo = false
zoneFunontheWater.Active = false
zoneFunontheWater.Points = {
	ZonePoint(38.6400516666667, -90.2848983333333, 0), 
	ZonePoint(38.6400516666667, -90.2849683333333, 0), 
	ZonePoint(38.6399816666667, -90.2849683333333, 0), 
	ZonePoint(38.6399816666667, -90.2848983333333, 0)
}
zoneFunontheWater.OriginalPoint = ZonePoint(38.6400166666667, -90.2849333333333, 0)
zoneFunontheWater.DistanceRangeUOM = "Feet"
zoneFunontheWater.ProximityRangeUOM = "Meters"
zoneFunontheWater.OutOfRangeName = ""
zoneFunontheWater.InRangeName = ""
zoneAForestGhostFavorite = Wherigo.Zone(cartItsForestGhostsBirthda)
zoneAForestGhostFavorite.Id = "f4636718-9075-4be3-b617-203dead706e3"
zoneAForestGhostFavorite.Name = _vth("\107\044\096\105\093\101\112\049\103\042\115\105\112\049\044\096\118\099\105\093\004\049\101")
zoneAForestGhostFavorite.Description = _vth("\121\115\101\044\014\093\105\035\008\101\049\112\044\112\101\101\016\044\049\105\044\093\108\013\044\105\108\049\044\115\101\093\101\036\044\107\008\008\044\049\115\118\049\044\035\118\014\014\008\004\013\080\044\016\108\112\049\044\115\118\099\101\044\007\105\093\120\101\014\044\108\035\044\118\013\044\118\035\035\101\049\004\049\101\044\004\013\044\112\108\022\115\044\118\044\115\004\080\115\103\101\013\101\093\080\019\044\096\105\093\101\112\049\103\042\115\105\112\049\024\044")
zoneAForestGhostFavorite.Visible = true
zoneAForestGhostFavorite.Media = zmedia026247aa1c6649fbb600891b9ba9fb06
zoneAForestGhostFavorite.Commands = {}
zoneAForestGhostFavorite.DistanceRange = Distance(-1, "feet")
zoneAForestGhostFavorite.ShowObjects = "OnEnter"
zoneAForestGhostFavorite.ProximityRange = Distance(6, "meters")
zoneAForestGhostFavorite.AllowSetPositionTo = false
zoneAForestGhostFavorite.Active = false
zoneAForestGhostFavorite.Points = {
	ZonePoint(38.5970220575181, -90.2175609766865, 0), 
	ZonePoint(38.5970220575181, -90.2176309766865, 0), 
	ZonePoint(38.5969520575181, -90.2176309766865, 0), 
	ZonePoint(38.5969520575181, -90.2175609766865, 0)
}
zoneAForestGhostFavorite.OriginalPoint = ZonePoint(38.5969870575181, -90.2175959766865, 0)
zoneAForestGhostFavorite.DistanceRangeUOM = "Feet"
zoneAForestGhostFavorite.ProximityRangeUOM = "Meters"
zoneAForestGhostFavorite.OutOfRangeName = ""
zoneAForestGhostFavorite.InRangeName = ""
zoneCanwecatchhimhere = Wherigo.Zone(cartItsForestGhostsBirthda)
zoneCanwecatchhimhere.Id = "4fbd317b-eb48-45ef-ba15-1a6d49511209"
zoneCanwecatchhimhere.Name = _vth("\029\118\013\044\007\101\044\022\118\049\022\115\044\115\004\016\044\115\101\093\101\070")
zoneCanwecatchhimhere.Description = _vth("\121\115\101\044\096\105\093\101\112\049\044\042\115\105\112\049\044\016\108\112\049\044\115\118\099\101\044\022\105\016\101\044\115\101\093\101\044\013\101\094\049\024\044\123\101\044\022\105\108\008\014\044\115\118\099\101\044\118\044\093\101\017\093\101\112\115\004\013\080\044\117\101\099\101\093\118\080\101\044\118\013\014\044\014\105\044\112\105\016\101\044\101\094\035\008\105\093\004\013\080\054\044\007\115\004\022\115\044\007\101\044\120\013\105\007\044\115\101\044\008\105\099\101\112\044\049\105\044\014\105\024")
zoneCanwecatchhimhere.Visible = true
zoneCanwecatchhimhere.Media = zmediaf6855ba486e249dd8ce8be32eb43627f
zoneCanwecatchhimhere.Commands = {}
zoneCanwecatchhimhere.DistanceRange = Distance(-1, "feet")
zoneCanwecatchhimhere.ShowObjects = "OnEnter"
zoneCanwecatchhimhere.ProximityRange = Distance(3, "meters")
zoneCanwecatchhimhere.AllowSetPositionTo = false
zoneCanwecatchhimhere.Active = false
zoneCanwecatchhimhere.Points = {
	ZonePoint(38.5994635270112, -90.214257677378, 0), 
	ZonePoint(38.5994635270112, -90.214327677378, 0), 
	ZonePoint(38.5993935270112, -90.214327677378, 0), 
	ZonePoint(38.5993935270112, -90.214257677378, 0)
}
zoneCanwecatchhimhere.OriginalPoint = ZonePoint(38.5994285270112, -90.214292677378, 0)
zoneCanwecatchhimhere.DistanceRangeUOM = "Feet"
zoneCanwecatchhimhere.ProximityRangeUOM = "Meters"
zoneCanwecatchhimhere.OutOfRangeName = ""
zoneCanwecatchhimhere.InRangeName = ""
zoneBirthdayDinner = Wherigo.Zone(cartItsForestGhostsBirthda)
zoneBirthdayDinner.Id = "7ac6d7fe-68fd-4e8a-a4d2-495c32a77f2d"
zoneBirthdayDinner.Name = _vth("\088\004\093\049\115\014\118\019\044\076\004\013\013\101\093")
zoneBirthdayDinner.Description = _vth("\079\101\044\016\118\014\101\044\004\049\024\044\086\044\115\118\099\101\044\118\044\017\101\101\008\004\013\080\044\049\115\101\044\096\105\093\101\112\049\103\042\115\105\112\049\044\004\112\044\118\093\105\108\013\014\044\115\101\093\101\036\044\076\105\044\019\105\108\044\112\101\101\044\115\004\016\070")
zoneBirthdayDinner.Visible = true
zoneBirthdayDinner.Media = zmediafab68ebd5b3a47fba1564c63cda0f54b
zoneBirthdayDinner.Commands = {}
zoneBirthdayDinner.DistanceRange = Distance(-1, "feet")
zoneBirthdayDinner.ShowObjects = "OnEnter"
zoneBirthdayDinner.ProximityRange = Distance(3, "meters")
zoneBirthdayDinner.AllowSetPositionTo = false
zoneBirthdayDinner.Active = false
zoneBirthdayDinner.Points = {
	ZonePoint(38.6060330077402, -90.3036912287097, 0), 
	ZonePoint(38.6060330077402, -90.3037612287097, 0), 
	ZonePoint(38.6059630077402, -90.3037612287097, 0), 
	ZonePoint(38.6059630077402, -90.3036912287097, 0)
}
zoneBirthdayDinner.OriginalPoint = ZonePoint(38.6059980077402, -90.3037262287097, 0)
zoneBirthdayDinner.DistanceRangeUOM = "Feet"
zoneBirthdayDinner.ProximityRangeUOM = "Meters"
zoneBirthdayDinner.OutOfRangeName = ""
zoneBirthdayDinner.InRangeName = ""
zoneLastShot = Wherigo.Zone(cartItsForestGhostsBirthda)
zoneLastShot.Id = "797e3a18-1f8f-4a75-adf8-7941d50150c5"
zoneLastShot.Name = _vth("\102\118\112\049\044\055\115\105\049")
zoneLastShot.Description = _vth("\079\101\044\017\105\108\013\014\044\115\004\016\024\044\123\105\105\093\118\019\024\044\002\105\007\044\007\101\044\022\118\013\044\093\101\118\008\008\019\044\022\101\008\101\117\093\118\049\101\024\044\053\088\031\033\053\088\031\033")
zoneLastShot.Visible = true
zoneLastShot.Media = zmedia1f4e7de7556d47a18c36f002a7e78b0c
zoneLastShot.Commands = {}
zoneLastShot.DistanceRange = Distance(-1, "feet")
zoneLastShot.ShowObjects = "OnEnter"
zoneLastShot.ProximityRange = Distance(5, "meters")
zoneLastShot.AllowSetPositionTo = false
zoneLastShot.Active = false
zoneLastShot.Points = {
	ZonePoint(38.5895662369453, -90.3077046776315, 0), 
	ZonePoint(38.5895662369453, -90.3077746776315, 0), 
	ZonePoint(38.5894962369453, -90.3077746776315, 0), 
	ZonePoint(38.5894962369453, -90.3077046776315, 0)
}
zoneLastShot.OriginalPoint = ZonePoint(38.5895312369453, -90.3077396776315, 0)
zoneLastShot.DistanceRangeUOM = "Feet"
zoneLastShot.ProximityRangeUOM = "Meters"
zoneLastShot.OutOfRangeName = ""
zoneLastShot.InRangeName = ""
zoneNewCache = Wherigo.Zone(cartItsForestGhostsBirthda)
zoneNewCache.Id = "64f06bf8-1d89-4d68-9322-da61b23a3663"
zoneNewCache.Name = _vth("\002\101\007\044\029\118\022\115\101\024")
zoneNewCache.Description = _vth("\124\079\101\008\022\105\016\101\044\049\105\044\016\019\044\115\105\016\101\024\044\086\061\016\044\115\118\035\035\019\044\049\105\044\112\101\101\044\019\105\108\044\016\118\014\101\044\004\049\044\049\105\044\080\093\105\108\013\014\044\050\101\093\105\036\044\121\115\101\044\022\118\022\115\101\044\004\112\044\008\105\022\118\049\101\014\044\118\049\043\044\002\044\060\089\044\060\060\036\089\060\020\044\079\044\083\020\044\052\089\036\081\069\083\036\124")
zoneNewCache.Visible = true
zoneNewCache.Media = zmedia91d1d2f08de347a9ad8ee81893ab55f5
zoneNewCache.Commands = {}
zoneNewCache.DistanceRange = Distance(-1, "feet")
zoneNewCache.ShowObjects = "OnEnter"
zoneNewCache.ProximityRange = Distance(3, "meters")
zoneNewCache.AllowSetPositionTo = false
zoneNewCache.Active = false
zoneNewCache.Points = {
	ZonePoint(38.5638433333333, -90.30464, 0), 
	ZonePoint(38.5638433333333, -90.30466, 0), 
	ZonePoint(38.5638233333333, -90.30466, 0), 
	ZonePoint(38.5638233333333, -90.30464, 0)
}
zoneNewCache.OriginalPoint = ZonePoint(38.5638333333333, -90.30465, 0)
zoneNewCache.DistanceRangeUOM = "Feet"
zoneNewCache.ProximityRangeUOM = "Meters"
zoneNewCache.OutOfRangeName = ""
zoneNewCache.InRangeName = ""

-- Characters --

-- Items --
zitemUnlockCode = Wherigo.ZItem(cartItsForestGhostsBirthda)
zitemUnlockCode.Id = "884b171d-6cb0-4868-a787-90e3f424183b"
zitemUnlockCode.Name = _vth("\011\013\008\105\022\120\044\029\105\014\101")
zitemUnlockCode.Description = _vth("\090\105\108\093\044\022\105\016\035\008\101\049\004\105\013\044\022\105\014\101\044\004\112\043\044")
zitemUnlockCode.Visible = true
zitemUnlockCode.Commands = {}
zitemUnlockCode.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemUnlockCode.Locked = false
zitemUnlockCode.Opened = false

-- Tasks --

-- Cartridge Variables --
Answer = ""
_sS02o = _vth("\050\105\013\101\086\112\096\105\093\101\112\049\042\115\105\112\049\115\101\093\101")
_ND5y = _vth("\014\108\016\016\019")
_kbnvP = _vth("\050\004\049\101\016\011\013\008\105\022\120\029\105\014\101")
_5Rb = _vth("\014\108\016\016\019")
_B8L1T = _vth("\050\004\013\035\108\049\086\013\035\108\049\020")
_nYV = _vth("\014\108\016\016\019")
cartItsForestGhostsBirthda.ZVariables = {
	Answer = "", 
	_sS02o = _vth("\050\105\013\101\086\112\096\105\093\101\112\049\042\115\105\112\049\115\101\093\101"), 
	_ND5y = _vth("\014\108\016\016\019"), 
	_kbnvP = _vth("\050\004\049\101\016\011\013\008\105\022\120\029\105\014\101"), 
	_5Rb = _vth("\014\108\016\016\019"), 
	_B8L1T = _vth("\050\004\013\035\108\049\086\013\035\108\049\020"), 
	_nYV = _vth("\014\108\016\016\019")
}

-- Timers --

-- Inputs --
zinputInput0 = Wherigo.ZInput(cartItsForestGhostsBirthda)
zinputInput0.Id = "494af36a-87db-4a44-a8cb-51ad86045f9c"
zinputInput0.Name = _vth("\086\013\035\108\049\020")
zinputInput0.Description = ""
zinputInput0.Visible = true
zinputInput0.Media = zmedia998a6b21f71d46cabc38c18f5965e636
zinputInput0.Choices = {
	"Bacon and Eggs", 
	"Doughnuts", 
	"Tea and a Scone"
}
zinputInput0.InputType = "MultipleChoice"
zinputInput0.Text = _vth("\121\118\120\101\044\118\044\008\105\105\120\044\118\093\105\108\013\014\036\044\079\115\118\049\044\014\004\014\044\049\115\101\044\096\105\093\101\112\049\103\042\115\105\112\049\044\035\093\105\117\118\117\008\019\044\101\013\037\105\019\044\017\105\093\044\117\093\101\118\120\017\118\112\049\070")
zinputInput1 = Wherigo.ZInput(cartItsForestGhostsBirthda)
zinputInput1.Id = "cb0e70f5-abbf-42f0-88af-e28c927f4360"
zinputInput1.Name = _vth("\086\013\035\108\049\052")
zinputInput1.Description = ""
zinputInput1.Visible = true
zinputInput1.Media = zmedia924bbf47cc714bd490a0010444ee3999
zinputInput1.InputType = "Text"
zinputInput1.Text = _vth("\096\105\093\101\112\049\103\042\115\105\112\049\061\112\044\118\013\004\016\118\008\044\035\118\008\112\044\118\093\101\044\049\115\101\044\112\049\118\093\112\044\115\101\093\101\036\044\079\115\118\049\044\016\105\049\049\105\044\004\112\044\035\105\112\049\101\014\070")
zinputInput2 = Wherigo.ZInput(cartItsForestGhostsBirthda)
zinputInput2.Id = "86c91743-de18-465d-a2fa-7048b9fe0f99"
zinputInput2.Name = _vth("\086\013\035\108\049\081")
zinputInput2.Description = ""
zinputInput2.Visible = true
zinputInput2.Media = zmedia2212b3f5fed840d68b0b165813b64fa8
zinputInput2.InputType = "Text"
zinputInput2.Text = _vth("\063\115\044\016\118\013\054\044\112\105\108\013\014\112\044\008\004\120\101\044\007\101\044\037\108\112\049\044\016\004\112\112\101\014\044\115\004\016\024\044\121\115\101\019\044\112\118\019\044\115\101\044\007\118\112\044\105\108\049\044\105\013\044\049\115\101\044\007\118\049\101\093\044\037\108\112\049\044\118\044\008\004\049\049\008\101\044\007\115\004\008\101\044\118\080\105\036\044\079\115\118\049\044\014\004\014\044\115\101\044\017\008\105\118\049\044\004\013\044\017\105\093\044\115\004\112\044\117\004\093\049\115\014\118\019\044\112\035\008\118\112\115\004\013\080\044\017\108\013\070")
zinputInput3 = Wherigo.ZInput(cartItsForestGhostsBirthda)
zinputInput3.Id = "417fca1a-f191-4e0f-b166-659c82d23600"
zinputInput3.Name = _vth("\086\013\035\108\049\060")
zinputInput3.Description = ""
zinputInput3.Visible = true
zinputInput3.Media = zmedia2212b3f5fed840d68b0b165813b64fa8
zinputInput3.Choices = {
	"Ice Cream", 
	"Pretzels", 
	"Potato Chips"
}
zinputInput3.InputType = "MultipleChoice"
zinputInput3.Text = _vth("\079\115\118\049\044\112\013\118\022\120\044\014\004\014\044\049\115\101\044\096\105\093\101\112\049\103\042\115\105\112\049\044\101\013\037\105\019\070")
zinputInput4 = Wherigo.ZInput(cartItsForestGhostsBirthda)
zinputInput4.Id = "a85dc6ee-e3f4-4fc0-a323-4436d3102c6e"
zinputInput4.Name = _vth("\086\013\035\108\049\059")
zinputInput4.Description = ""
zinputInput4.Visible = true
zinputInput4.Media = zmediab8900ca4d91a43d7b3528a614fdb71a7
zinputInput4.Choices = {
	"a walking tour", 
	"a horseback ride", 
	"a tunnel visit"
}
zinputInput4.InputType = "MultipleChoice"
zinputInput4.Text = _vth("\079\115\118\049\044\105\049\115\101\093\044\118\022\049\004\099\004\049\019\044\022\105\108\008\014\044\049\115\101\044\096\105\093\101\112\049\103\042\115\105\112\049\044\115\118\099\101\044\014\105\013\101\044\049\105\044\022\101\008\101\117\093\118\049\101\044\115\004\112\044\117\004\093\049\115\014\118\019\044\115\101\093\101\070")
zinputInput5 = Wherigo.ZInput(cartItsForestGhostsBirthda)
zinputInput5.Id = "698f4a3e-0053-4529-99ab-7ed32c1a4136"
zinputInput5.Name = _vth("\086\013\035\108\049\085")
zinputInput5.Description = ""
zinputInput5.Visible = true
zinputInput5.Media = zmediaa695563474c24aa2a26006de202f6a2f
zinputInput5.InputType = "Text"
zinputInput5.Text = _vth("\102\105\105\120\044\118\093\105\108\013\014\044\017\105\093\044\118\044\022\008\108\101\103\103\004\017\044\115\101\044\022\118\016\101\044\115\101\093\101\044\049\105\044\101\118\049\054\044\007\115\118\049\044\004\112\044\049\115\101\044\096\105\093\101\112\049\103\042\115\105\112\049\061\112\044\017\118\099\105\093\004\049\101\044\017\105\105\014\070")
zinputInput6 = Wherigo.ZInput(cartItsForestGhostsBirthda)
zinputInput6.Id = "287c27b3-c2a8-4fc0-a2f7-7d34d6b48497"
zinputInput6.Name = _vth("\086\013\035\108\049\067")
zinputInput6.Description = ""
zinputInput6.Visible = true
zinputInput6.Media = zmedia1f4e7de7556d47a18c36f002a7e78b0c
zinputInput6.Choices = {
	"Yes", 
	"No"
}
zinputInput6.InputType = "MultipleChoice"
zinputInput6.Text = _vth("\124\076\004\014\044\019\105\108\044\017\004\013\014\044\049\115\101\044\080\101\105\022\118\022\115\101\070\124")

-- WorksWithList for object commands --

-- functions --
function cartItsForestGhostsBirthda:OnStart()
end
function cartItsForestGhostsBirthda:OnRestore()
end
function zoneIsForestGhosthere:OnProximity()
	_sS02o = _vth("\050\105\013\101\086\112\096\105\093\101\112\049\042\115\105\112\049\115\101\093\101")
	zoneIsForestGhosthere.Active = false
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputInput0)
	end)
end
function zoneMaybevisitingfriends:OnProximity()
	_sS02o = _vth("\050\105\013\101\066\118\019\117\101\099\004\112\004\049\004\013\080\017\093\004\101\013\014\112")
	zoneMaybevisitingfriends.Active = false
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputInput1)
	end)
end
function zoneFunontheWater:OnProximity()
	_sS02o = _vth("\050\105\013\101\096\108\013\105\013\049\115\101\079\118\049\101\093")
	zoneFunontheWater.Active = false
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputInput2)
	end)
end
function zoneAForestGhostFavorite:OnProximity()
	_sS02o = _vth("\050\105\013\101\107\096\105\093\101\112\049\042\115\105\112\049\096\118\099\105\093\004\049\101")
	zoneAForestGhostFavorite.Active = false
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputInput3)
	end)
end
function zoneCanwecatchhimhere:OnProximity()
	_sS02o = _vth("\050\105\013\101\029\118\013\007\101\022\118\049\022\115\115\004\016\115\101\093\101")
	zoneCanwecatchhimhere.Active = false
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputInput4)
	end)
end
function zoneBirthdayDinner:OnProximity()
	_sS02o = _vth("\050\105\013\101\088\004\093\049\115\014\118\019\076\004\013\013\101\093")
	zoneBirthdayDinner.Active = false
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputInput5)
	end)
end
function zoneLastShot:OnProximity()
	_sS02o = _vth("\050\105\013\101\102\118\112\049\055\115\105\049")
	zoneLastShot.Active = false
	_Urwigo.MessageBox{
		Text = _vth("\123\107\122\122\090\044\088\086\031\121\123\076\107\090\054\044\096\105\093\101\112\049\103\042\115\105\112\049\024\024\024"), 
		Media = zmediad60c009145b44fb4a7803c246adf30fa, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _vth("\124\121\115\118\013\120\112\024\044\086\061\016\044\080\008\118\014\044\019\105\108\044\016\118\014\101\044\004\049\103\103\086\044\037\108\112\049\044\035\008\118\022\101\014\044\118\013\105\049\115\101\093\044\022\118\022\115\101\044\017\105\093\044\019\105\108\044\118\008\008\044\049\105\044\101\013\037\105\019\044\117\118\022\120\044\004\013\044\016\019\044\013\101\022\120\044\105\017\044\049\115\101\044\007\105\105\014\112\036\044\079\115\019\044\014\105\013\061\049\044\019\105\108\044\115\101\118\014\044\105\099\101\093\044\049\105\044\049\115\101\112\101\044\022\105\105\093\014\004\013\118\049\101\112\070\044\121\115\101\013\044\019\105\108\044\022\118\013\044\017\004\013\004\112\115\044\049\115\101\044\022\101\008\101\117\093\118\049\004\105\013\044\105\108\049\044\093\004\080\115\049\024\124\053\088\031\033\053\088\031\033\002\044\060\089\044\060\060\036\089\060\020\044\079\044\083\020\044\052\089\036\081\069\083"), 
					Media = zmediad60c009145b44fb4a7803c246adf30fa, 
					Callback = function(action)
						if action ~= nil then
							zoneNewCache.Active = true
						end
					end
				}
			end
		end
	}
end
function zoneNewCache:OnProximity()
	_sS02o = _vth("\050\105\013\101\002\101\007\029\118\022\115\101")
	zoneNewCache.Active = false
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputInput6)
	end)
end
function zinputInput0:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _vth("\121\101\118\044\118\013\014\044\118\044\055\022\105\013\101")) then
		_Urwigo.MessageBox{
			Text = _vth("\121\115\118\049\061\112\044\093\004\080\115\049\024\044\123\101\044\014\105\101\112\013\061\049\044\112\101\101\016\044\049\105\044\112\049\004\008\008\044\117\101\044\115\101\093\101\054\044\112\105\044\008\101\049\061\112\044\017\105\008\008\105\007\044\049\115\101\044\022\093\108\016\117\112\044\118\013\014\044\112\101\101\044\007\115\101\093\101\044\115\101\044\115\101\118\014\101\014\044\013\101\094\049\036"), 
			Media = zmediab1781b820a274772b6ef1143235f0e16, 
			Callback = function(action)
				if action ~= nil then
					zoneMaybevisitingfriends.Active = true
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _vth("\055\105\108\013\014\112\044\049\118\112\049\019\054\044\117\108\049\044\115\101\044\022\105\108\008\014\013\061\049\044\117\108\019\044\049\115\118\049\044\115\101\093\101\036\044\121\118\120\101\044\118\013\105\049\115\101\093\044\008\105\105\120\044\118\093\105\108\013\014\036"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputInput0)
					end)
				end
			end
		}
	end
end
function zinputInput1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _vth("\107\013\004\016\118\008\112\044\107\008\007\118\019\112")) then
		_Urwigo.MessageBox{
			Text = _vth("\090\105\108\061\099\101\044\080\105\049\044\004\049\024\044\076\105\044\019\105\108\044\112\101\101\044\049\115\101\044\096\105\093\101\112\049\103\042\115\105\112\049\044\118\013\019\007\115\101\093\101\070"), 
			Media = zmedia3caa46ab22e4486d87037b7835563890, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _vth("\002\105\044\008\108\022\120\044\017\004\013\014\004\013\080\044\115\004\016\070\044\123\016\016\036\036\036\086\044\120\013\105\007\024\044\121\115\101\044\096\105\093\101\112\049\103\042\115\105\112\049\044\008\105\099\101\112\044\112\035\101\013\014\004\013\080\044\049\004\016\101\044\105\013\044\049\115\101\044\007\118\049\101\093\036\044\086\061\099\101\044\080\105\049\044\037\108\112\049\044\049\115\101\044\112\035\105\049\044\049\105\044\008\105\105\120\024"), 
						Media = zmedia82cc89e7144243239a4cbdc6f3c873a2, 
						Callback = function(action)
							if action ~= nil then
								zoneFunontheWater.Active = true
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _vth("\002\105\049\044\047\108\004\049\101\036\044\121\118\120\101\044\118\013\105\049\115\101\093\044\008\105\105\120\044\118\049\044\007\115\118\049\061\112\044\007\093\004\049\049\101\013\044\105\013\044\049\115\101\044\080\093\101\101\013\044\118\007\013\004\013\080\112\036"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputInput1)
					end)
				end
			end
		}
	end
end
function zinputInput2:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _vth("\122\118\014\014\008\101\117\105\118\049")) then
		_Urwigo.MessageBox{
			Text = _vth("\031\004\080\115\049\044\105\013\024\044\123\101\044\016\108\112\049\044\115\118\099\101\044\080\105\049\049\101\013\044\118\044\112\007\004\016\044\004\013\044\049\105\105\054\044\117\101\022\118\108\112\101\044\086\044\112\101\101\044\118\044\049\093\118\004\008\044\105\017\044\007\118\049\101\093\044\014\093\105\035\112\044\008\101\118\014\004\013\080\044\004\013\044\049\115\101\044\014\004\093\101\022\049\004\105\013\044\105\017\044\118\013\105\049\115\101\093\044\035\008\118\022\101\044\115\101\044\008\004\120\101\112\044\049\105\044\099\004\112\004\049\036\044\102\101\049\061\112\044\017\105\008\008\105\007\044\049\115\004\112\044\008\101\118\014\024"), 
			Media = zmedia2fb387e7a7b84fbc9a88b35c7462e540, 
			Callback = function(action)
				if action ~= nil then
					zoneAForestGhostFavorite.Active = true
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _vth("\002\105\049\044\047\108\004\049\101\036\044\123\004\112\044\008\101\080\112\044\007\105\108\008\014\044\115\118\099\101\044\080\105\049\049\101\013\044\035\093\101\049\049\019\044\049\004\093\101\014\044\080\105\004\013\080\044\118\093\105\108\013\014\044\004\013\044\049\115\004\112\044\007\118\049\101\093\022\093\118\017\049\036"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputInput2)
					end)
				end
			end
		}
	end
end
function zinputInput3:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _vth("\122\093\101\049\050\101\008\112")) then
		_Urwigo.MessageBox{
			Text = _vth("\123\101\044\112\108\093\101\044\014\004\014\024\044\121\115\004\013\120\044\115\101\044\007\118\013\049\101\014\044\112\105\016\101\049\115\004\013\080\044\049\105\044\007\118\112\115\044\049\115\101\016\044\014\105\007\013\070"), 
			Media = zmedia28ff90ba58c8440397a5cacf54834e97, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _vth("\102\105\105\120\112\044\008\004\120\101\044\007\101\044\037\108\112\049\044\016\004\112\112\101\014\044\115\004\016\044\118\080\118\004\013\024\044\079\115\019\044\014\105\013\061\049\044\007\101\044\008\105\105\120\044\017\105\093\044\118\044\035\008\118\022\101\044\013\101\118\093\117\019\044\115\101\044\022\105\108\008\014\044\115\118\099\101\044\080\105\049\049\101\013\044\112\105\016\101\044\093\101\017\093\101\112\115\016\101\013\049\112\070"), 
						Media = zmediad76536b3bcac4768ad8f58bafbb3ade9, 
						Callback = function(action)
							if action ~= nil then
								zoneCanwecatchhimhere.Active = true
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _vth("\002\105\049\044\049\115\004\112\044\049\004\016\101\036\044\121\118\120\101\044\118\013\105\049\115\101\093\044\080\108\101\112\112\024"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputInput3)
					end)
				end
			end
		}
	end
end
function zinputInput4:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _vth("\118\044\007\118\008\120\004\013\080\044\049\105\108\093")) then
		_Urwigo.MessageBox{
			Text = _vth("\121\115\118\049\061\112\044\093\004\080\115\049\024\044\086\044\022\118\013\061\049\044\117\101\008\004\101\099\101\044\007\101\044\115\118\099\101\013\061\049\044\022\118\108\080\115\049\044\108\035\044\049\105\044\115\004\016\044\019\101\049\054\044\117\108\049\044\117\019\044\013\105\007\044\049\115\101\044\096\105\093\101\112\049\103\042\115\105\112\049\044\016\108\112\049\044\117\101\044\118\008\016\105\112\049\044\093\101\118\014\019\044\017\105\093\044\014\004\013\013\101\093\036\044\121\115\101\093\101\061\112\044\105\013\101\044\017\118\099\105\093\004\049\101\044\017\105\105\014\044\115\101\061\112\044\016\105\112\049\044\008\004\120\101\008\019\044\049\105\044\080\105\044\118\017\049\101\093\024"), 
			Media = zmedia89927a218ae44510b1287653d5110486, 
			Callback = function(action)
				if action ~= nil then
					zoneBirthdayDinner.Active = true
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _vth("\121\115\101\044\096\105\093\101\112\049\103\042\115\105\112\049\044\007\105\108\008\014\044\101\013\037\105\019\044\049\115\118\049\054\044\117\108\049\044\004\049\061\112\044\013\105\049\044\118\013\044\105\035\049\004\105\013\044\115\101\093\101\036\044\121\093\019\044\118\080\118\004\013\024"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputInput4)
					end)
				end
			end
		}
	end
end
function zinputInput5:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _vth("\122\004\050\050\118")) then
		_Urwigo.MessageBox{
			Text = _vth("\086\049\044\112\108\093\101\044\004\112\024\044\107\013\014\044\118\044\008\105\022\118\008\044\049\105\008\014\044\016\101\044\049\115\101\019\044\037\108\112\049\044\112\118\007\044\115\004\016\044\008\101\118\099\101\044\115\101\093\101\036\044\042\105\105\014\044\049\115\004\013\080\044\115\101\044\080\105\049\044\115\004\112\044\017\118\099\105\093\004\049\101\044\016\101\118\008\044\017\105\093\044\115\004\112\044\117\004\093\049\115\014\118\019\024\044\079\101\044\117\101\049\049\101\093\044\115\108\093\093\019\054\044\049\115\105\108\080\115\054\044\004\017\044\007\101\061\093\101\044\080\105\013\013\118\044\022\118\049\022\115\044\115\004\016\044\117\101\017\105\093\101\044\049\115\101\044\014\118\019\061\112\044\014\105\013\101\024"), 
			Media = zmediac58106905d714d7081e7a011c6701db6, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _vth("\121\115\101\093\101\061\112\044\093\101\118\008\008\019\044\105\013\008\019\044\105\013\101\044\007\118\019\044\049\105\044\049\105\035\044\105\017\017\044\049\115\118\049\044\014\101\008\004\022\004\105\108\112\044\035\004\050\050\118\044\014\004\013\013\101\093\036\044\086\017\044\007\101\044\093\101\118\008\008\019\044\115\108\093\093\019\054\044\086\044\120\013\105\007\044\007\101\044\022\118\013\044\022\118\049\022\115\044\049\115\101\044\096\105\093\101\112\049\044\042\115\105\112\049\044\117\101\017\105\093\101\044\115\101\044\017\004\013\004\112\115\101\112\044\115\004\112\044\014\101\112\112\101\093\049\024"), 
						Media = zmedia77539f7956f84a09b3da5533c474bd8c, 
						Callback = function(action)
							if action ~= nil then
								zoneLastShot.Active = true
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _vth("\002\105\049\044\047\108\004\049\101\036\044\121\093\019\044\118\080\118\004\013\024"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputInput5)
					end)
				end
			end
		}
	end
end
function zinputInput6:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Answer = input
	if Wherigo.NoCaseEquals(Answer, _vth("\090\101\112")) then
		_Urwigo.MessageBox{
			Text = _vth("\124\029\105\013\080\093\118\049\108\008\118\049\004\105\013\112\024\044\121\115\118\013\120\112\044\017\105\093\044\022\101\008\101\117\093\118\049\004\013\080\044\016\019\044\117\004\093\049\115\014\118\019\044\007\004\049\115\044\016\101\024\124"), 
			Media = zmedia365321e811354e1a91469f1619f81d09, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = (_vth("\121\115\101\044\022\118\093\049\093\004\014\080\101\044\004\112\044\022\105\016\035\008\101\049\101\036\044\082\013\117\112\035\012\090\105\108\093\044\022\105\016\035\008\101\049\004\105\013\044\022\105\014\101\044\004\112\044")..(string.sub(Player.CompletionCode, 1, 15))).._vth("\036\044\082\013\117\112\035\012\066\118\120\101\044\112\108\093\101\044\049\105\044\007\093\004\049\101\044\049\115\004\112\044\014\105\007\013\036")
					}
					cartItsForestGhostsBirthda.Complete = true
					zitemUnlockCode.Description = zitemUnlockCode.Description..(string.sub(Player.CompletionCode, 1, 15))
					zitemUnlockCode:MoveTo(Player)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _vth("\124\086\061\016\044\112\108\093\101\044\019\105\108\061\093\101\044\105\013\044\049\115\101\044\093\004\080\115\049\044\049\093\118\022\120\024\044\055\101\118\093\022\115\044\008\105\007\044\013\101\118\093\044\118\044\017\118\008\008\101\013\044\049\093\101\101\044\118\013\014\044\112\049\108\016\035\036\044\121\115\101\044\022\118\022\115\101\044\004\112\044\008\105\022\118\049\101\014\044\118\049\043\044\002\044\060\089\044\060\060\036\089\060\020\044\079\044\083\020\044\052\089\036\081\069\083\036\124"), 
			Media = zmedia1f4e7de7556d47a18c36f002a7e78b0c, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputInput6)
					end)
				end
			end
		}
	end
end

-- Urwigo functions --

-- Begin user functions --
-----------------------------------------------------------------------------------------------
-- URWIGO: Following code is imported from the Wherigo Builder cartridge.
-- It is only neccessary if the cartridge uses Author functions that use message box callbacks.
-- Otherwise it can be removed.
cartItsForestGhostsBirthda.MsgBoxCBFuncs = {}
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=19#--




cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
Wherigo.GetInput(zinputInput0)
end
end

cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
zoneMaybevisitingfriends.Active = true
end
end



cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
Wherigo.GetInput(zinputInput1)
end
end

cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB4 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
Wherigo.MessageBox{Text=[[No luck finding him? Hmm...I know! The Forest-Ghost loves spending time on the water. I've got just the spot to look!]],Media=zmedia82cc89e7144243239a4cbdc6f3c873a2,Callback=cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB5}
end
end

cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB5 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Callback --
zoneFunontheWater.Active = true
end
end



cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB6 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
Wherigo.GetInput(zinputInput2)
end
end

cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB7 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
zoneAForestGhostFavorite.Active = true
end
end



cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB8 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
Wherigo.GetInput(zinputInput3)
end
end

cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB9 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
Wherigo.MessageBox{Text=[[Looks like we just missed him again! Why don't we look for a place nearby he could have gotten some refreshments?]],Media=zmediad76536b3bcac4768ad8f58bafbb3ade9,Callback=cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB10}
end
end

cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB10 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Callback --
zoneCanwecatchhimhere.Active = true
end
end



cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB11 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
Wherigo.GetInput(zinputInput4)
end
end

cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB12 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
zoneBirthdayDinner.Active = true
end
end



cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB13 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
Wherigo.GetInput(zinputInput5)
end
end

cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB14 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
Wherigo.MessageBox{Text=[[There's really only one way to top off that delicious pizza dinner. If we really hurry, I know we can catch the Forest Ghost before he finishes his dessert!]],Media=zmedia77539f7956f84a09b3da5533c474bd8c,Callback=cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB15}
end
end

cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB15 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Callback --
zoneLastShot.Active = true
end
end



cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB16 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Callback --
Wherigo.MessageBox{Text=[["Thanks! I'm glad you made it--I just placed another cache for you all to enjoy back in my neck of the woods. Why don't you head over to these coordinates? Then you can finish the celebration out right!"

N 38 33.830 W 90 18.279]],Media=zmediad60c009145b44fb4a7803c246adf30fa,Callback=cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB17}
end
end

cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB17 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Callback --
zoneNewCache.Active = true
end
end



cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB18 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
Wherigo.GetInput(zinputInput6)
end
end

cartItsForestGhostsBirthda.MsgBoxCBFuncs.MsgBoxCB19 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Wrong answer --
Wherigo.MessageBox{Text=[[The cartridge is complete.  Your completion code is ]] .. string.sub(Player.CompletionCode, 1, 15) .. [[.  Make sure to write this down.]],}
cartItsForestGhostsBirthda.Complete = true
zitemUnlockCode.Description = zitemUnlockCode.Description .. string.sub(Player.CompletionCode, 1, 15)
zitemUnlockCode:MoveTo(Player)
end
end

-----------------------------------------------------------------------------------------------
-- URWIGO: Here follow imported Author functions



-- End user functions --
return cartItsForestGhostsBirthda
