require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

_t1hZ = Wherigo.ZCartridge()

-- String decode --
function _qIn5(str)
	local res = ""
    local dtable = "\060\031\100\026\021\033\064\072\071\019\081\049\105\052\113\005\118\025\051\123\096\040\120\011\097\124\065\034\098\126\069\032\092\018\112\027\038\116\108\102\015\073\024\029\048\058\119\001\095\089\061\125\039\068\077\083\063\022\057\000\036\066\010\079\111\075\009\002\043\114\020\055\082\074\030\101\110\008\099\041\103\045\013\094\003\012\017\053\070\047\028\085\104\006\109\091\080\054\106\076\093\087\086\115\035\016\078\007\042\037\107\084\117\056\121\014\088\059\067\062\122\023\046\044\004\050\090"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
_jP8cb = Wherigo.ZMedia(_t1hZ)
_jP8cb.Id = "36b30c31-a03b-45c9-a661-0ae57432d529"
_jP8cb.Name = _qIn5("\100\076\038\038\070\076\104")
_jP8cb.Description = ""
_jP8cb.AltText = ""
_jP8cb.Resources = {
	{
		Type = "jpg", 
		Filename = "lettres241_1.jpg", 
		Directives = {}
	}
}
_DSw = Wherigo.ZMedia(_t1hZ)
_DSw.Id = "634eee7d-672d-4de8-bd6f-0f8db73a4b7a"
_DSw.Name = _qIn5("\100\076\038\038\070\076\104\032\012\114\045")
_DSw.Description = ""
_DSw.AltText = ""
_DSw.Resources = {
	{
		Type = "jpg", 
		Filename = "lettres-180.jpg", 
		Directives = {}
	}
}
_Aqe = Wherigo.ZMedia(_t1hZ)
_Aqe.Id = "ae7c32b1-ec29-446f-bf3a-c6f35f6ac880"
_Aqe.Name = _qIn5("\055\079\054\065")
_Aqe.Description = ""
_Aqe.AltText = ""
_Aqe.Resources = {
	{
		Type = "jpg", 
		Filename = "mcdo-180_1.jpg", 
		Directives = {}
	}
}
_3HWBb = Wherigo.ZMedia(_t1hZ)
_3HWBb.Id = "da41104f-5e0f-48b0-823c-a44d5359133f"
_3HWBb.Name = _qIn5("\031\077\076\070\081\013\076")
_3HWBb.Description = ""
_3HWBb.AltText = ""
_3HWBb.Resources = {
	{
		Type = "jpg", 
		Filename = "09-cardio.jpg", 
		Directives = {}
	}
}
_Ze2j = Wherigo.ZMedia(_t1hZ)
_Ze2j.Id = "c64ae7d4-0896-4500-b496-18cbb01aa521"
_Ze2j.Name = _qIn5("\042\009\027")
_Ze2j.Description = ""
_Ze2j.AltText = ""
_Ze2j.Resources = {
	{
		Type = "jpg", 
		Filename = "IGA_180.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_t1hZ.Id="3fea8e12-8040-494c-a4c3-eb5ce433ac4d"
_t1hZ.Name="Magie des lettres"
_t1hZ.Description=[[Cette cache  a ete faite dans le cadre de  l'EVENT  GO! Victo 2011!]]
_t1hZ.Visible=true
_t1hZ.Activity="Geocache"
_t1hZ.StartingLocationDescription=[[Vous devez trouvez les 5 lettres qui constituent le mot magique.]]
_t1hZ.StartingLocation = ZonePoint(46.0506166666667,-71.9375666666667,0)
_t1hZ.Version="1.2"
_t1hZ.Company="Les Productions KO"
_t1hZ.Author="Pirouet"
_t1hZ.BuilderVersion="URWIGO 1.12.4091.37853"
_t1hZ.CreateDate="04/07/2011 21:00:46"
_t1hZ.PublishDate="1/1/0001 12:00:00 AM"
_t1hZ.UpdateDate="05/08/2011 17:14:44"
_t1hZ.LastPlayedDate="1/1/0001 12:00:00 AM"
_t1hZ.TargetDevice="PocketPC"
_t1hZ.TargetDeviceVersion="0"
_t1hZ.StateId="1"
_t1hZ.CountryId="2"
_t1hZ.Complete=false
_t1hZ.UseLogging=true

_t1hZ.Media=_DSw


-- Zones --
_f2r_R = Wherigo.Zone(_t1hZ)
_f2r_R.Id = "5596eb42-0dfc-40b4-b362-1fa806df4824"
_f2r_R.Name = _qIn5("\127\065\077\076\032\012")
_f2r_R.Description = _qIn5("\073\076\104\038\025\113\070\025\077\038\032\039\076\104\032\025\070\079\093\076\104\032\003\053\065\070")
_f2r_R.Visible = true
_f2r_R.Media = _Aqe
_f2r_R.Icon = _Aqe
_f2r_R.Commands = {}
_f2r_R.DistanceRange = Distance(-1, "feet")
_f2r_R.ShowObjects = "OnEnter"
_f2r_R.ProximityRange = Distance(60, "meters")
_f2r_R.AllowSetPositionTo = false
_f2r_R.Active = true
_f2r_R.Points = {
	ZonePoint(46.050561691047, -71.9373074920654, 0), 
	ZonePoint(46.0504127696008, -71.937591806221, 0), 
	ZonePoint(46.0503085243496, -71.9371411951065, 0)
}
_f2r_R.OriginalPoint = ZonePoint(46.0504276616658, -71.937346831131, 0)
_f2r_R.DistanceRangeUOM = "Feet"
_f2r_R.ProximityRangeUOM = "Meters"
_f2r_R.OutOfRangeName = ""
_f2r_R.InRangeName = ""
_8Eiw = Wherigo.Zone(_t1hZ)
_8Eiw.Id = "d9ec7be0-c1c2-4bd7-832b-c5b82f89b170"
_8Eiw.Name = _qIn5("\127\065\077\076\032\126")
_8Eiw.Description = _qIn5("\055\025\081\025\104\013\077\032\031\077\076\070\081\013\076\032\119\025\070\003\013\065")
_8Eiw.Visible = true
_8Eiw.Media = _3HWBb
_8Eiw.Icon = _3HWBb
_8Eiw.Commands = {}
_8Eiw.DistanceRange = Distance(-1, "feet")
_8Eiw.ShowObjects = "OnEnter"
_8Eiw.ProximityRange = Distance(60, "meters")
_8Eiw.AllowSetPositionTo = false
_8Eiw.Active = false
_8Eiw.Points = {
	ZonePoint(46.0502265839716, -71.9366335370381, 0), 
	ZonePoint(46.0499957541585, -71.9367569186528, 0), 
	ZonePoint(46.0499212927226, -71.9363170363744, 0)
}
_8Eiw.OriginalPoint = ZonePoint(46.0500478769509, -71.9365691640218, 0)
_8Eiw.DistanceRangeUOM = "Feet"
_8Eiw.ProximityRangeUOM = "Meters"
_8Eiw.OutOfRangeName = ""
_8Eiw.InRangeName = ""
_CpPC = Wherigo.Zone(_t1hZ)
_CpPC.Id = "fe772672-c464-4933-b49c-4513677f4fa3"
_CpPC.Name = _qIn5("\127\065\077\076\032\019")
_CpPC.Description = _qIn5("\062\065\013\104\032\089\070\025\077\079\104\032\076\038\032\009\025\081\077\065\077")
_CpPC.Visible = true
_CpPC.Media = _Ze2j
_CpPC.Commands = {}
_CpPC.DistanceRange = Distance(-1, "feet")
_CpPC.ShowObjects = "OnEnter"
_CpPC.ProximityRange = Distance(60, "meters")
_CpPC.AllowSetPositionTo = false
_CpPC.Active = false
_CpPC.Points = {
	ZonePoint(46.049874810457, -71.93555405159, 0), 
	ZonePoint(46.0497184409834, -71.9353233816147, 0), 
	ZonePoint(46.0499567180998, -71.9351731779099, 0)
}
_CpPC.OriginalPoint = ZonePoint(46.0498499898467, -71.9353502037049, 0)
_CpPC.DistanceRangeUOM = "Feet"
_CpPC.ProximityRangeUOM = "Meters"
_CpPC.OutOfRangeName = ""
_CpPC.InRangeName = ""
_eah = Wherigo.Zone(_t1hZ)
_eah.Id = "afaa23ce-827c-496f-8a40-adfaa4556c1a"
_eah.Name = _qIn5("\089\013\077\025\039\076")
_eah.Description = _qIn5("\031\077\040\013\077\032\039\025\032\040\013\077\025\039\076\123\123\123")
_eah.Visible = true
_eah.Commands = {}
_eah.DistanceRange = Distance(-1, "feet")
_eah.ShowObjects = "OnEnter"
_eah.ProximityRange = Distance(60, "meters")
_eah.AllowSetPositionTo = false
_eah.Active = false
_eah.Points = {
	ZonePoint(46.0513441236392, -71.937675675265, 0), 
	ZonePoint(46.0512766446146, -71.9373400638621, 0), 
	ZonePoint(46.0511505284235, -71.9376250485699, 0)
}
_eah.OriginalPoint = ZonePoint(46.0512570988924, -71.9375469292323, 0)
_eah.DistanceRangeUOM = "Feet"
_eah.ProximityRangeUOM = "Meters"
_eah.OutOfRangeName = ""
_eah.InRangeName = ""

-- Characters --

-- Items --

-- Tasks --

-- Cartridge Variables --
_si8NW = ""
_QXU = _qIn5("\095\025\081\013\076")
_t1hZ.ZVariables = {
	_si8NW = "", 
	_QXU = _qIn5("\095\025\081\013\076")
}

-- Timers --

-- Inputs --
_fZX = Wherigo.ZInput(_t1hZ)
_fZX.Id = "e00b53fc-27f3-441b-88e2-7cceb713147b"
_fZX.Name = _qIn5("\042\077\035\113\038\049\095\065\038")
_fZX.Description = _qIn5("\100\053\113\104\025\081\076\070\032\003\065\013\038\032\076\077\038\070\076\070\032\104\065\077\032\095\065\038\032\013\079\013")
_fZX.Visible = true
_fZX.InputType = "Text"
_fZX.Text = _qIn5("\011\113\076\039\032\076\104\038\032\017\065\038\070\076\032\095\065\038\123\123\123\123\123\123")

-- WorksWithList for object commands --

-- functions --
function _t1hZ:OnStart()
	if (_G[_qIn5("\031\077\017")][_qIn5("\054\076\017\013\079\076\042\054")] == _qIn5("\054\076\104\111\038\065\035")) or (_G[_qIn5("\031\077\017")][_qIn5("\097\039\025\038\040\065\070\095")] == _qIn5("\102\013\077\019\126")) then
		for k, v in pairs(_G[_qIn5("\049\038\012\093\127")][_qIn5("\027\039\039\127\064\029\099\076\079\038\104")]) do
			v[_qIn5("\103\013\104\013\029\039\076")] = false
			v[_qIn5("\027\079\038\013\017\076")] = false
		end
		_G[_qIn5("\102\093\076\070\013\081\065")][_qIn5("\119\065\095\095\025\077\003")](_qIn5("\056\025\017\076\119\039\065\104\076"))
		return
	end
	_Urwigo.MessageBox{
		Text = _qIn5("\103\065\113\104\032\003\076\017\076\121\032\017\065\113\104\032\070\076\077\003\070\076\032\025\032\039\025\032\035\070\076\095\013\076\070\076\032\121\065\077\076\032\015\113\013\032\077\053\076\104\038\032\035\025\104\032\038\070\076\104\032\039\065\013\077\032\076\038\032\035\070\076\077\003\070\076\032\077\065\038\076\032\003\076\032\039\025\032\081\070\065\104\104\076\032\039\076\038\038\070\076\032\123\001\062\073\120")
	}
end
function _t1hZ:OnRestore()
end
function _f2r_R:OnEnter()
	_Urwigo.MessageBox{
		Text = _qIn5("\103\065\113\104\032\017\065\013\079\013\032\003\076\017\025\077\038\032\113\077\032\079\076\039\076\029\070\076\032\070\076\104\038\025\113\070\025\077\038\123\032\037\077\029\104\035\118\097\070\076\077\076\121\032\077\065\038\076\032\003\076\032\039\025\032\081\070\065\104\104\076\032\039\076\038\038\070\076\032\099\025\113\077\076\124\032\079\076\039\039\076\082\079\013\032\079\065\077\104\038\013\038\113\076\032\039\025\032\035\070\076\095\013\076\070\076\032\039\076\038\038\070\076\032\003\076\032\017\065\038\070\076\032\095\065\038\032\095\115\104\038\076\070\076\123\001\062\073\120\001\062\073\120\089\025\013\038\076\104\032\073\031\112\064\092\073\032\076\038\032\025\039\039\076\121\032\025\032\039\025\032\127\065\077\076\032\126"), 
		Media = _Aqe
	}
	_8Eiw.Active = true
	_f2r_R.Active = false
end
function _8Eiw:OnEnter()
	_Urwigo.MessageBox{
		Text = _qIn5("\031\038\025\035\076\032\126\032\082\032\103\065\113\104\032\017\065\115\076\121\032\039\076\032\003\076\104\104\013\077\032\003\053\113\077\032\065\070\081\025\077\076\032\015\113\013\032\025\104\104\113\070\076\032\039\025\032\079\013\070\079\113\039\025\038\013\065\077\032\003\113\032\104\025\077\081\123\032\037\077\029\104\035\118\097\070\076\077\076\121\032\077\065\038\076\032\003\076\032\039\025\032\035\070\076\095\013\076\070\076\032\039\076\038\038\070\076\032\003\113\032\095\065\038\032\025\032\081\025\113\079\093\076\032\003\076\032\039\053\065\070\081\025\077\076\123\001\062\073\120\119\076\079\013\032\076\104\038\032\039\025\032\054\031\073\107\042\031\073\107\031\032\100\031\112\112\073\031\032\003\113\032\095\065\038\032\040\013\077\025\039\123")
	}
	_CpPC.Active = true
	_8Eiw.Active = false
end
function _CpPC:OnEnter()
	_Urwigo.MessageBox{
		Text = _qIn5("\054\076\070\077\013\076\070\076\032\076\038\025\035\076\046\032\037\077\029\104\035\118\042\107\103\031\073\056\031\127\032\039\076\104\032\019\032\039\076\038\038\070\076\104\032\003\113\032\077\065\095\032\003\113\032\055\025\070\079\093\076\032\003\053\027\039\013\095\076\077\038\025\038\013\065\077\032\015\113\076\032\017\065\113\104\032\017\065\115\076\121\123"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.Dialog(false, {
					{
						Text = _qIn5("\103\065\113\104\032\025\017\076\121\032\038\065\113\038\076\104\032\039\076\104\032\039\076\038\038\070\076\104\032\015\113\013\032\079\065\095\035\065\104\076\077\038\032\039\076\032\095\065\038\123\032\037\077\029\104\035\118\031\077\038\070\076\121\082\039\076\032\076\038\032\104\013\032\017\065\113\104\032\025\017\076\121\032\039\025\032\029\065\077\077\076\032\070\076\035\065\077\104\076\124\032\039\025\032\040\013\077\025\039\076\032\076\104\038\032\025\032\017\065\113\104\123")
					}
				}, function(action)
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_fZX)
					end)
				end)
			end
		end
	}
end
function _eah:OnEnter()
	_Urwigo.MessageBox{
		Text = _qIn5("\103\065\113\104\032\017\065\013\079\013\032\025\032\039\025\032\040\013\077\025\039\076\123\001\062\073\120\055\076\070\079\013\032\003\053\025\017\065\013\070\032\040\025\013\038\032\079\076\038\038\076\032\079\025\079\093\076\032\076\038\032\029\065\077\077\076\032\099\065\113\070\077\076\076\123\001\062\073\120\097\042\073\064\092\031\112"), 
		Callback = function(action)
			if action ~= nil then
				Wherigo.Command "SaveClose"
			end
		end
	}
end
function _fZX:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_si8NW = input
	if Wherigo.NoCaseEquals(_si8NW, _QXU) then
		_Urwigo.MessageBox{
			Text = _qIn5("\103\065\113\104\032\025\017\076\121\032\039\025\032\029\065\077\077\076\032\070\076\035\065\077\104\076\123\032\037\077\029\104\035\118\089\031\100\042\119\042\112\027\112\042\064\107\056\006\006\006\006")
		}
		_CpPC.Active = false
		_eah.Active = true
	else
		_Urwigo.MessageBox{
			Text = _qIn5("\054\076\104\065\039\076\123\032\037\077\029\104\035\118\055\076\013\039\039\076\113\070\032\079\093\025\077\079\076\032\039\025\032\035\070\065\079\093\025\013\077\076\032\040\065\013\104\123")
		}
	end
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return _t1hZ
