require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _DTPUC(str)
	local res = ""
    local dtable = "\044\057\054\008\082\003\019\081\120\039\089\114\009\100\076\103\021\124\126\070\122\088\106\045\050\073\040\077\018\091\105\086\109\016\006\119\037\121\085\112\011\080\068\108\115\067\046\033\079\013\035\101\118\007\083\094\010\036\111\002\125\074\099\110\049\031\022\113\047\096\042\020\005\116\123\026\092\064\060\078\075\087\048\059\069\032\001\098\072\061\056\065\028\004\053\030\084\017\041\012\107\117\063\025\015\052\104\023\014\027\097\043\051\058\066\095\055\102\029\038\062\000\024\071\034\090\093"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_nMx = Wherigo.ZCartridge()

-- Media --
_cTPs = Wherigo.ZMedia(_nMx)
_cTPs.Id = "124c2a11-b81a-42c8-9ba1-7b193784d664"
_cTPs.Name = _DTPUC("\014\059\033\052\063\052\101")
_cTPs.Description = ""
_cTPs.AltText = ""
_cTPs.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek1.jpg", 
		Directives = {}
	}
}
_yJvW = Wherigo.ZMedia(_nMx)
_yJvW.Id = "8a70fae4-a43b-4333-9319-4befbb7e75c0"
_yJvW.Name = _DTPUC("\014\059\033\052\063\052\101\086\092")
_yJvW.Description = ""
_yJvW.AltText = ""
_yJvW.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-a.jpg", 
		Directives = {}
	}
}
_5gEjQ = Wherigo.ZMedia(_nMx)
_5gEjQ.Id = "b94f872b-d842-4e8c-bb9d-d3df0abd1935"
_5gEjQ.Name = _DTPUC("\014\059\033\052\063\052\101\086\115")
_5gEjQ.Description = ""
_5gEjQ.AltText = ""
_5gEjQ.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-b.jpg", 
		Directives = {}
	}
}
_wUMb = Wherigo.ZMedia(_nMx)
_wUMb.Id = "11728745-c6f1-48cc-815a-6bdf77237e2c"
_wUMb.Name = _DTPUC("\014\059\033\052\063\052\101\086\046")
_wUMb.Description = ""
_wUMb.AltText = ""
_wUMb.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-c.jpg", 
		Directives = {}
	}
}
_tYbN = Wherigo.ZMedia(_nMx)
_tYbN.Id = "5b265cd0-6acd-42d8-ab78-df9d6af106b3"
_tYbN.Name = _DTPUC("\014\059\033\052\063\052\101\086\043")
_tYbN.Description = ""
_tYbN.AltText = ""
_tYbN.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-d.jpg", 
		Directives = {}
	}
}
_X7P = Wherigo.ZMedia(_nMx)
_X7P.Id = "2886fffd-bc14-4041-a818-5cb6f2ac0e6d"
_X7P.Name = _DTPUC("\014\059\033\052\063\052\101\086\085")
_X7P.Description = ""
_X7P.AltText = ""
_X7P.Resources = {
	{
		Type = "jpg", 
		Filename = "domecek-e.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_nMx.Id="276f8d49-f1e8-4760-b6db-6cbc47d0dd2b"
_nMx.Name="Domecek jednim tahem"
_nMx.Description=[[]]
_nMx.Visible=true
_nMx.Activity="Geocache"
_nMx.StartingLocationDescription=[[]]
_nMx.StartingLocation = Wherigo.INVALID_ZONEPOINT
_nMx.Version="3"
_nMx.Company="URWIGO.CZ"
_nMx.Author="Maxinoha"
_nMx.BuilderVersion="URWIGO 1.22.5798.37755"
_nMx.CreateDate="06/02/2011 19:33:47"
_nMx.PublishDate="1/1/0001 12:00:00 AM"
_nMx.UpdateDate="03/09/2018 17:10:20"
_nMx.LastPlayedDate="1/1/0001 12:00:00 AM"
_nMx.TargetDevice="PocketPC"
_nMx.TargetDeviceVersion="0"
_nMx.StateId="1"
_nMx.CountryId="2"
_nMx.Complete=false
_nMx.UseLogging=true

_nMx.Media=_cTPs


-- Zones --
zoneA = Wherigo.Zone(_nMx)
zoneA.Id = "6c0a8c09-f8d0-441d-840c-232400f9754f"
zoneA.Name = _DTPUC("\092")
zoneA.Description = _DTPUC("\015\052\053\111\086\014\059\044\064\031")
zoneA.Visible = true
zoneA.Media = _yJvW
zoneA.Commands = {}
zoneA.DistanceRange = Distance(-1, "feet")
zoneA.ShowObjects = "OnEnter"
zoneA.ProximityRange = Distance(60, "meters")
zoneA.AllowSetPositionTo = false
zoneA.Active = false
zoneA.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneA.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneA.DistanceRangeUOM = "Feet"
zoneA.ProximityRangeUOM = "Meters"
zoneA.OutOfRangeName = ""
zoneA.InRangeName = ""
zoneB = Wherigo.Zone(_nMx)
zoneB.Id = "29d83f97-8cd4-4969-b021-8c5824da1197"
zoneB.Name = _DTPUC("\115")
zoneB.Description = _DTPUC("\042\012\111\053\111\086\014\059\044\064\031")
zoneB.Visible = true
zoneB.Media = _5gEjQ
zoneB.Commands = {}
zoneB.DistanceRange = Distance(-1, "feet")
zoneB.ShowObjects = "OnEnter"
zoneB.ProximityRange = Distance(60, "meters")
zoneB.AllowSetPositionTo = false
zoneB.Active = false
zoneB.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneB.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneB.DistanceRangeUOM = "Feet"
zoneB.ProximityRangeUOM = "Meters"
zoneB.OutOfRangeName = ""
zoneB.InRangeName = ""
zoneC = Wherigo.Zone(_nMx)
zoneC.Id = "65c9a5e2-2178-46a9-9f2b-32b29f5e92f8"
zoneC.Name = _DTPUC("\043")
zoneC.Description = _DTPUC("\042\012\111\053\111\086\107\059\012\064\031")
zoneC.Visible = true
zoneC.Media = _tYbN
zoneC.Commands = {}
zoneC.DistanceRange = Distance(-1, "feet")
zoneC.ShowObjects = "OnEnter"
zoneC.ProximityRange = Distance(60, "meters")
zoneC.AllowSetPositionTo = false
zoneC.Active = false
zoneC.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneC.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneC.DistanceRangeUOM = "Feet"
zoneC.ProximityRangeUOM = "Meters"
zoneC.OutOfRangeName = ""
zoneC.InRangeName = ""
zoneD = Wherigo.Zone(_nMx)
zoneD.Id = "78e1ff4d-138c-4fd0-8f54-33dea0f22aca"
zoneD.Name = _DTPUC("\085")
zoneD.Description = _DTPUC("\055\074\012\052\063\107\111")
zoneD.Visible = true
zoneD.Media = _X7P
zoneD.Commands = {}
zoneD.DistanceRange = Distance(-1, "feet")
zoneD.ShowObjects = "OnEnter"
zoneD.ProximityRange = Distance(60, "meters")
zoneD.AllowSetPositionTo = false
zoneD.Active = false
zoneD.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneD.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneD.DistanceRangeUOM = "Feet"
zoneD.ProximityRangeUOM = "Meters"
zoneD.OutOfRangeName = ""
zoneD.InRangeName = ""
zoneE = Wherigo.Zone(_nMx)
zoneE.Id = "b86ee37a-b455-4d1c-a1d4-ca272020a5b4"
zoneE.Name = _DTPUC("\046")
zoneE.Description = _DTPUC("\015\052\053\111\086\107\059\012\064\031")
zoneE.Visible = true
zoneE.Media = _wUMb
zoneE.Commands = {}
zoneE.DistanceRange = Distance(-1, "feet")
zoneE.ShowObjects = "OnEnter"
zoneE.ProximityRange = Distance(60, "meters")
zoneE.AllowSetPositionTo = false
zoneE.Active = false
zoneE.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
zoneE.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
zoneE.DistanceRangeUOM = "Feet"
zoneE.ProximityRangeUOM = "Meters"
zoneE.OutOfRangeName = ""
zoneE.InRangeName = ""
pomocnaA = Wherigo.Zone(_nMx)
pomocnaA.Id = "a6e263ca-1f46-4fdb-81e6-cbb2f6070896"
pomocnaA.Name = _DTPUC("\040\059\033\059\063\064\111\092")
pomocnaA.Description = ""
pomocnaA.Visible = false
pomocnaA.Commands = {}
pomocnaA.DistanceRange = Distance(-1, "feet")
pomocnaA.ShowObjects = "OnEnter"
pomocnaA.ProximityRange = Distance(60, "meters")
pomocnaA.AllowSetPositionTo = false
pomocnaA.Active = false
pomocnaA.Points = {
	ZonePoint(50.0883105759415, 14.4861529022455, 0), 
	ZonePoint(50.0885153651931, 14.486067071557, 0), 
	ZonePoint(50.0884637377332, 14.4863674789667, 0)
}
pomocnaA.OriginalPoint = ZonePoint(50.0884298929559, 14.4861958175897, 0)
pomocnaA.DistanceRangeUOM = "Feet"
pomocnaA.ProximityRangeUOM = "Meters"
pomocnaA.OutOfRangeName = ""
pomocnaA.InRangeName = ""
pomocnaB = Wherigo.Zone(_nMx)
pomocnaB.Id = "fddf5546-1e42-4235-b07d-ce430efc41ff"
pomocnaB.Name = _DTPUC("\046\092\046\089\085")
pomocnaB.Description = ""
pomocnaB.Visible = false
pomocnaB.Commands = {}
pomocnaB.DistanceRange = Distance(-1, "feet")
pomocnaB.ShowObjects = "OnEnter"
pomocnaB.ProximityRange = Distance(60, "meters")
pomocnaB.AllowSetPositionTo = false
pomocnaB.Active = false
pomocnaB.Points = {
	ZonePoint(50.0831904354134, 14.4061231613159, 0), 
	ZonePoint(50.0873759814898, 14.4061231613159, 0), 
	ZonePoint(50.0872658402229, 14.4186544418335, 0), 
	ZonePoint(50.0839614845219, 14.4168519973755, 0)
}
pomocnaB.OriginalPoint = ZonePoint(50.085448435412, 14.4119381904602, 0)
pomocnaB.DistanceRangeUOM = "Feet"
pomocnaB.ProximityRangeUOM = "Meters"
pomocnaB.OutOfRangeName = ""
pomocnaB.InRangeName = ""

-- Characters --

-- Items --
_hs0_1 = Wherigo.ZItem{
	Cartridge = _nMx, 
	Container = Player
}
_hs0_1.Id = "c9777014-b811-4604-ada9-0a46173a17df"
_hs0_1.Name = _DTPUC("\074\102\021\101\111")
_hs0_1.Description = ""
_hs0_1.Visible = true
_hs0_1.Media = _yJvW
_hs0_1.Commands = {
	_toeM = Wherigo.ZCommand{
		Text = _DTPUC("\021\111\101\012\052\045\044\031\074\086\088\059\014\086\092"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _DTPUC("\080\031\063\086\101\086\014\031\045\040\059\021\031\063\031")
	}, 
	_OAk = Wherigo.ZCommand{
		Text = _DTPUC("\021\111\101\012\052\045\044\031\074\086\088\059\014\086\115"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _DTPUC("\080\031\063\086\101\086\014\031\045\040\059\021\031\063\031")
	}, 
	_NkLW = Wherigo.ZCommand{
		Text = _DTPUC("\021\111\063\031\074\086\101\012\052\045\044\031\074"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _DTPUC("\080\031\063\086\101\086\014\031\045\040\059\021\031\063\031")
	}, 
	_23WP = Wherigo.ZCommand{
		Text = _DTPUC("\021\111\063\031\074\086\101\012\052\045\044\031\074"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _DTPUC("\080\031\063\086\101\086\014\031\045\040\059\021\031\063\031")
	}, 
	_U7OPw = Wherigo.ZCommand{
		Text = _DTPUC("\021\111\063\031\074\086\101\012\052\045\044\031\074"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _DTPUC("\080\031\063\086\101\086\014\031\045\040\059\021\031\063\031")
	}
}
_hs0_1.Commands._toeM.Custom = true
_hs0_1.Commands._toeM.Id = "f7d4fc34-0153-4069-a12e-c8bda6766a35"
_hs0_1.Commands._toeM.WorksWithAll = true
_hs0_1.Commands._OAk.Custom = true
_hs0_1.Commands._OAk.Id = "2df84455-70fc-4a88-8ea6-be405ec8ea11"
_hs0_1.Commands._OAk.WorksWithAll = true
_hs0_1.Commands._NkLW.Custom = true
_hs0_1.Commands._NkLW.Id = "8380c51f-f1ee-4a43-a1d4-e518ed56bc8e"
_hs0_1.Commands._NkLW.WorksWithAll = true
_hs0_1.Commands._23WP.Custom = true
_hs0_1.Commands._23WP.Id = "a4e90ce9-8f80-497f-9dd1-7956a608032d"
_hs0_1.Commands._23WP.WorksWithAll = true
_hs0_1.Commands._U7OPw.Custom = true
_hs0_1.Commands._U7OPw.Id = "fb8d8d59-eec1-4de2-959a-fd2edc6642d7"
_hs0_1.Commands._U7OPw.WorksWithAll = true
_hs0_1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_hs0_1.Locked = false
_hs0_1.Opened = false
_OQeP = Wherigo.ZItem{
	Cartridge = _nMx, 
	Container = Player
}
_OQeP.Id = "3c2f0bd8-a392-4fae-970e-d115d9c313aa"
_OQeP.Name = _DTPUC("\049\014\052\033\038\101\111\063\031\086\101\059\014")
_OQeP.Description = ""
_OQeP.Visible = false
_OQeP.Commands = {}
_OQeP.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_OQeP.Locked = false
_OQeP.Opened = false

-- Tasks --
_iFtd = Wherigo.ZTask(_nMx)
_iFtd.Id = "278d3822-bd41-48cb-9223-22619270e1b5"
_iFtd.Name = _DTPUC("\126\111\101\012\052\045\044\031\086\088\059\014\086\092")
_iFtd.Description = ""
_iFtd.Visible = true
_iFtd.Active = true
_iFtd.Complete = false
_iFtd.CorrectState = "None"
_hP_ = Wherigo.ZTask(_nMx)
_hP_.Id = "4cd560b3-e195-4f40-b0d3-620e3fd25c1a"
_hP_.Name = _DTPUC("\126\111\101\012\052\045\044\031\086\088\059\014\086\115")
_hP_.Description = ""
_hP_.Visible = true
_hP_.Active = false
_hP_.Complete = false
_hP_.CorrectState = "None"
_94NCa = Wherigo.ZTask(_nMx)
_94NCa.Id = "2d4b6d60-e841-4500-b3d7-7253f3ce7a43"
_94NCa.Name = _DTPUC("\080\111\044\052\021\064\031\086\065\047\086\012\052\045\052\064\031")
_94NCa.Description = ""
_94NCa.Visible = true
_94NCa.Active = false
_94NCa.Complete = false
_94NCa.CorrectState = "None"
_ljj2q = Wherigo.ZTask(_nMx)
_ljj2q.Id = "1e08e5d4-897e-4ca4-986f-c7a73116d0dd"
_ljj2q.Name = _DTPUC("\080\111\044\052\021\064\031\086\025\047\086\012\052\045\052\064\031")
_ljj2q.Description = ""
_ljj2q.Visible = true
_ljj2q.Active = false
_ljj2q.Complete = false
_ljj2q.CorrectState = "None"
_tjgR = Wherigo.ZTask(_nMx)
_tjgR.Id = "432d1063-83d5-4de7-be89-6a45df07a8a2"
_tjgR.Name = _DTPUC("\080\111\044\052\021\064\031\086\113\047\086\012\052\045\052\064\031")
_tjgR.Description = ""
_tjgR.Visible = true
_tjgR.Active = false
_tjgR.Complete = false
_tjgR.CorrectState = "None"
_JTaM9 = Wherigo.ZTask(_nMx)
_JTaM9.Id = "8a5b8a2e-865c-4e24-a0ca-d49e4effad58"
_JTaM9.Name = _DTPUC("\080\111\023\031\074\086\063\111\063\107\052")
_JTaM9.Description = ""
_JTaM9.Visible = true
_JTaM9.Active = false
_JTaM9.Complete = false
_JTaM9.CorrectState = "None"

-- Cartridge Variables --
pointALat = 0
pointALon = 0
_G9EQ = false
_TsT = false
_W44 = false
_slPzA = false
_Goze = false
_vmxJI = false
_0l_Ih = false
_Gs5B = false
_hdVBr = ""
_yE6 = ""
_LhC = ""
_g5Q = ""
_fwT = false
_pXS = false
_tlRjg = false
_cPhv = ""
_yd8 = ""
gckod = _DTPUC("\124\046\113\124\025\011\043")
esouradnice = 0
nsouradnice = 0
nasobic = 0
_eONyd = false
radius = 0
_AaL2 = _DTPUC("\021\059\064\052\092")
_Yfi8Y = _DTPUC("\014\102\033\033\038")
_Ty9nX = _DTPUC("\116\107\045\083\116\065")
_nfeXa = _DTPUC("\116\031\020\074\014")
_Jrqjy = _DTPUC("\014\102\033\033\038")
_HNzO = _DTPUC("\014\102\033\033\038")
_nMx.ZVariables = {
	pointALat = 0, 
	pointALon = 0, 
	_G9EQ = false, 
	_TsT = false, 
	_W44 = false, 
	_slPzA = false, 
	_Goze = false, 
	_vmxJI = false, 
	_0l_Ih = false, 
	_Gs5B = false, 
	_hdVBr = "", 
	_yE6 = "", 
	_LhC = "", 
	_g5Q = "", 
	_fwT = false, 
	_pXS = false, 
	_tlRjg = false, 
	_cPhv = "", 
	_yd8 = "", 
	gckod = _DTPUC("\124\046\113\124\025\011\043"), 
	esouradnice = 0, 
	nsouradnice = 0, 
	nasobic = 0, 
	_eONyd = false, 
	radius = 0, 
	_AaL2 = _DTPUC("\021\059\064\052\092"), 
	_Yfi8Y = _DTPUC("\014\102\033\033\038"), 
	_Ty9nX = _DTPUC("\116\107\045\083\116\065"), 
	_nfeXa = _DTPUC("\116\031\020\074\014"), 
	_Jrqjy = _DTPUC("\014\102\033\033\038"), 
	_HNzO = _DTPUC("\014\102\033\033\038")
}

-- Timers --

-- Inputs --

-- WorksWithList for object commands --

-- functions --
function _nMx:OnStart()
	if (_G[_DTPUC("\085\064\053")][_DTPUC("\042\044\111\074\118\059\012\033")] == _DTPUC("\082\031\064\113\025")) or (_G[_DTPUC("\085\064\053")][_DTPUC("\043\052\053\031\063\052\026\043")] == _DTPUC("\043\052\045\101\074\059\040")) then
		for k, v in pairs(_G[_DTPUC("\116\064\028\009")][_DTPUC("\092\044\044\126\049\088\023\052\063\074\045")]) do
			v[_DTPUC("\032\031\045\031\088\044\052")] = false
			v[_DTPUC("\092\063\074\031\053\052")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_DTPUC("\055\031\016\064\111\044\086\124\042\055\086\064\052\064\031\086\101\086\014\031\045\040\059\021\031\063\031\047")), 
			Callback = function(action)
				if action ~= nil then
					_G[_DTPUC("\082\107\052\012\031\016\059")][_DTPUC("\046\059\033\033\111\064\014")](_DTPUC("\055\111\053\052\046\044\059\045\052"))
				end
			end
		}
		return
	end
	_Urwigo.Dialog(false, {
		{
			Text = _DTPUC("\062\031\045\074\052\086\021\064\111\045\086\101\044\111\045\031\063\101\059\102\086\045\101\059\044\064\031\086\102\044\059\107\102\086\064\111\101\012\052\045\044\031\074\086\014\059\033\052\063\052\101\086\023\052\014\064\031\033\086\074\111\107\052\033\047"), 
			Media = _cTPs
		}, 
		{
			Text = _DTPUC("\097\111\101\052\086\033\064\052\086\074\111\074\059\086\033\038\045\044\052\064\101\111\086\059\045\044\059\053\031\044\111\086\024\086\101\059\044\031\101\086\012\052\045\052\064\031\086\053\102\088\052\063\086\052\009\031\045\074\102\023\052\103\079\115\005\121\062\052\014\064\059\001\086\014\053\052\001\086\064\052\088\059\086\045\064\111\014\086\053\031\063\052\103")
		}, 
		{
			Text = _DTPUC("\080\052\088\102\014\102\086\074\052\086\014\044\059\102\107\059\086\064\111\040\031\064\111\074\001\086\033\059\021\064\038\063\107\086\012\052\045\052\064\031\086\023\052\086\091\091\047\079\115\005\121\092\086\074\053\038\033\086\102\101\059\044\052\033\086\088\102\014\052\086\064\111\044\052\021\074\086\111\044\052\045\040\059\064\086\074\012\031\086\021\086\064\031\063\107\047"), 
			Buttons = {
				_DTPUC("\062\043\039\086\080\092\086\097\049")
			}
		}
	}, function(action)
		if Wherigo.NoCaseEquals(Env.DeviceID, _DTPUC("\036\052\088\036\031\016\059")) then
			_hs0_1.Visible = false
			_Urwigo.MessageBox{
				Text = _DTPUC("\126\101\102\045\086\074\059\086\053\052\064\101\102\086\033\031\045\074\059\086\064\111\086\040\059\063\031\074\111\063\031\047"), 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "SaveClose"
					end
				end
			}
		else
			_Urwigo.Dialog(false, {
				{
					Text = _DTPUC("\080\038\064\031\086\033\102\021\052\045\086\021\111\063\031\074\086\045\086\053\038\021\064\111\063\052\064\031\033\086\012\059\107\059\053\038\063\107\086\088\059\014\102\086\014\059\033\052\063\101\102\047"), 
					Media = _cTPs
				}, 
				{
					Text = _DTPUC("\080\111\023\014\031\086\045\031\086\014\059\045\074\111\074\052\063\064\052\086\053\052\044\101\052\086\040\012\059\045\074\012\111\064\045\074\053\031\047\079\115\005\121\046\031\033\086\053\052\074\045\031\001\086\074\031\033\086\044\052\040\052\001\086\111\044\052\086\033\031\064\031\033\111\044\064\052\086\095\083\009\095\083\086\033\052\074\012\102\047")
				}, 
				{
					Text = _DTPUC("\042\012\052\023\014\031\086\014\059\086\033\031\045\074\111\001\086\101\014\052\086\088\038\086\033\052\044\086\088\038\074\086\088\059\014\086\092\086\111\086\040\059\102\021\031\023\086\074\102\021\101\102\001\086\101\074\052\012\059\102\086\064\111\044\052\021\064\052\045\086\053\052\086\045\053\052\033\086\088\111\074\102\021\101\102\047"), 
					Media = _yJvW, 
					Buttons = {
						_DTPUC("\062\031\074\086\014\059\086\088\059\014\102\086\092")
					}
				}
			}, function(action)
				_OQeP.Description = _DTPUC("\049\014\052\033\038\101\111\063\031\086\101\059\014\086\027\046\059\033\040\044\052\074\031\059\064\086\046\059\014\052\099\086\040\012\059\086\059\021\064\111\063\052\064\031\086\107\012\038\086\023\111\101\059\086\014\059\101\059\064\063\052\064\052\086\064\111\086\040\059\012\074\111\044\102\086\036\036\047\036\107\052\012\031\016\059\118\059\102\064\014\111\074\031\059\064\047\063\059\033\086\023\052\114\079\115\005\121")..string.sub(Player.CompletionCode, 1, 15)
			end)
		end
	end)
end
function _nMx:OnRestore()
end
function zoneA:OnEnter()
	_AaL2 = _DTPUC("\021\059\064\052\092")
	_4kgt()
end
function zoneB:OnEnter()
	_AaL2 = _DTPUC("\021\059\064\052\115")
	_4kgt()
end
function zoneC:OnEnter()
	_AaL2 = _DTPUC("\021\059\064\052\046")
	_4kgt()
end
function zoneD:OnEnter()
	_AaL2 = _DTPUC("\021\059\064\052\043")
	_4kgt()
end
function zoneE:OnEnter()
	_AaL2 = _DTPUC("\021\059\064\052\085")
	_4kgt()
end
function pomocnaA:OnEnter()
	_AaL2 = _DTPUC("\040\059\033\059\063\064\111\092")
	_hs0_1.Commands._OAk.Enabled = false
end
function pomocnaA:OnExit()
	_AaL2 = _DTPUC("\040\059\033\059\063\064\111\092")
	_hs0_1.Commands._OAk.Enabled = true
end
function pomocnaB:OnEnter()
	_AaL2 = _DTPUC("\040\059\033\059\063\064\111\115")
	if _eONyd == false then
		_eONyd = true
		_nMx.Complete = true
		_JTaM9.Complete = true
		_Urwigo.MessageBox{
			Text = _DTPUC("\043\059\012\111\021\031\044\086\023\045\031\086\064\111\086\033\031\045\074\059\086\101\014\052\086\023\052\086\102\101\012\038\074\111\086\063\111\063\107\052\086\111\086\074\031\033\086\074\111\074\059\086\107\012\111\086\101\059\064\063\031\047\079\115\005\121\079\115\005\121\064\111\040\059\053\052\014\111\114\086\089\044\052\014\052\023\086\120\064\088\045\040\084\043\049\028\085\046\085\081\047"), 
			Callback = function(action)
				if action ~= nil then
					_nMx:RequestSync()
					_Urwigo.MessageBox{
						Text = _DTPUC("\089\012\111\086\102\044\059\021\052\064\111\047"), 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _DTPUC("\089\044\052\014\052\023\086\120\064\088\045\040\084\043\049\028\085\046\085\081\047"), 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _hs0_1:On_toeM(target)
	CenterZoneOnPoint(pomocnaA, Player.ObjectLocation, 10)
	pomocnaA.Visible = false
	pointALat = Player.ObjectLocation.latitude
	pointALon = Player.ObjectLocation.longitude
	_hs0_1.Commands._toeM.Enabled = false
	_iFtd.Complete = true
	_hP_.Active = true
	_hs0_1.Media = _5gEjQ
	_Urwigo.Dialog(false, {
		{
			Text = _DTPUC("\115\059\014\086\092\086\088\038\044\086\064\111\101\012\052\045\044\052\064\047\079\115\005\121\080\038\064\031\086\040\012\052\023\014\031\086\064\111\086\033\031\045\074\059\086\101\014\052\086\063\107\063\052\045\086\064\111\101\012\052\045\044\031\074\086\088\059\014\086\115\086\111\086\059\040\052\074\086\040\059\102\021\031\023\086\074\102\021\101\102\047"), 
			Media = _5gEjQ
		}, 
		{
			Text = _DTPUC("\042\059\101\102\014\086\088\102\014\052\045\086\040\012\031\044\031\045\086\088\044\031\021\101\059\086\088\059\014\102\086\092\001\086\074\111\101\086\074\031\086\074\102\021\101\111\086\064\052\014\059\053\059\044\031\086\088\059\014\086\115\086\064\111\101\012\052\045\044\031\074\047"), 
			Buttons = {
				_DTPUC("\062\031\074\086\014\059\086\088\059\014\102\086\115")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _hs0_1:On_OAk(target)
	radius = _Urwigo.Floor(Wherigo.VectorToPoint(Player.ObjectLocation, pomocnaA.OriginalPoint):GetValue "m" / 4.8, 0)
	pomocnaA.Active = false
	_hs0_1.Commands._OAk.Enabled = false
	_hs0_1.Commands._NkLW.Enabled = true
	_hP_.Complete = true
	_hs0_1.Media = _cTPs
	_94NCa.Active = true
	BuildHouse(
	  Wherigo.ZonePoint(pointALat, pointALon, 0),
	  Player.ObjectLocation,
	  zoneA,
	  zoneB,
	  zoneC,
	  zoneD,
	  zoneE,
	  radius)
	_Urwigo.Dialog(false, {
		{
			Text = _DTPUC("\115\059\014\086\115\086\088\038\044\086\021\111\101\012\052\045\044\052\064\047\079\115\005\121\043\111\044\045\031\086\088\059\014\038\086\046\001\043\001\085\086\088\038\044\038\086\053\038\074\053\059\012\052\064\038\086\111\102\074\059\033\111\074\031\063\101\038\047")
		}, 
		{
			Text = _DTPUC("\080\038\064\031\086\023\031\021\086\033\102\021\052\045\086\021\111\063\031\074\086\045\086\101\012\052\045\044\052\064\031\033\086\065\047\086\012\052\045\052\064\031\047"), 
			Media = _cTPs
		}, 
		{
			Text = _DTPUC("\042\012\052\045\102\064\086\045\052\086\014\059\086\088\059\014\102\086\053\052\086\101\074\052\012\052\033\086\063\107\063\052\045\086\021\111\063\031\074\086\101\012\052\045\044\031\074\086\014\059\033\052\063\052\101\086\023\052\014\064\031\033\086\074\111\107\052\033\086\111\086\059\040\052\074\086\040\059\102\021\031\023\086\074\102\021\101\102\047\079\115\005\121\097\053\102\023\086\040\059\107\038\088\086\040\012\031\086\053\038\074\053\111\012\052\064\031\086\088\059\014\102\086\045\052\086\014\059\086\012\052\045\052\064\031\086\080\085\040\059\063\031\074\111\047"), 
			Media = _cTPs, 
			Buttons = {
				_DTPUC("\062\014\031\086\064\111\086\021\111\063\111\074\052\101")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _hs0_1:On_NkLW(target)
	if (((zoneA:Contains(Player) or zoneB:Contains(Player)) or zoneE:Contains(Player)) or zoneC:Contains(Player)) or zoneD:Contains(Player) then
		_hs0_1.Commands._NkLW.Enabled = false
		_fwT = true
		_T9G()
		_HwP()
		_Urwigo.Dialog(false, {
			{
				Text = _DTPUC("\126\111\063\111\044\086\023\045\031\086\101\012\052\045\044\031\074\086\014\059\033\052\063\052\101\086\023\052\014\064\031\033\086\074\111\107\052\033\047\079\115\005\121\080\038\064\031\086\045\052\086\074\053\102\023\086\040\059\107\038\088\086\033\052\021\031\086\023\052\014\064\059\074\044\031\053\038\033\031\086\088\059\014\038\086\021\111\021\064\111\033\052\064\111\053\111\086\023\111\101\059\086\101\012\052\045\044\052\064\031\086\023\052\014\064\031\033\086\074\111\107\052\033\047")
			}, 
			{
				Text = _DTPUC("\092\101\074\102\111\044\064\052\086\033\111\045\086\064\111\101\012\052\045\044\052\064\059\114\086").._hdVBr, 
				Media = _cTPs, 
				Buttons = {
					_DTPUC("\042\059\101\012\111\063\059\053\111\074")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.MessageBox{
			Text = _DTPUC("\080\052\045\074\059\023\031\045\086\064\111\086\021\111\014\064\052\033\086\088\059\014\052\047"), 
			Buttons = {
				_DTPUC("\062\014\031\086\064\111\086\040\059\063\111\074\052\063\064\031\086\088\059\014")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _hs0_1:On_23WP(target)
	if (((zoneA:Contains(Player) or zoneB:Contains(Player)) or zoneE:Contains(Player)) or zoneC:Contains(Player)) or zoneD:Contains(Player) then
		_hs0_1.Commands._23WP.Enabled = false
		_pXS = true
		_T9G()
		_HwP()
		_Urwigo.Dialog(false, {
			{
				Text = _DTPUC("\126\111\063\111\044\086\023\045\031\086\101\012\052\045\044\031\074\086\014\059\033\052\063\052\101\086\023\052\014\064\031\033\086\074\111\107\052\033\047\079\115\005\121\080\038\064\031\086\045\052\086\074\053\102\023\086\040\059\107\038\088\086\033\052\021\031\086\023\052\014\064\059\074\044\031\053\038\033\031\086\088\059\014\038\086\021\111\021\064\111\033\052\064\111\053\111\086\023\111\101\059\086\101\012\052\045\044\052\064\031\086\023\052\014\064\031\033\086\074\111\107\052\033\047")
			}, 
			{
				Text = _DTPUC("\092\101\074\102\111\044\064\052\086\033\111\045\086\064\111\101\012\052\045\044\052\064\059\114\086").._yE6, 
				Media = _cTPs, 
				Buttons = {
					_DTPUC("\042\059\101\012\111\063\059\053\111\074")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.MessageBox{
			Text = _DTPUC("\080\052\045\074\059\023\031\045\086\064\111\086\021\111\014\064\052\033\086\088\059\014\052\047"), 
			Buttons = {
				_DTPUC("\062\014\031\086\064\111\086\040\059\063\111\074\052\063\064\031\086\088\059\014")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _hs0_1:On_U7OPw(target)
	if (((zoneA:Contains(Player) or zoneB:Contains(Player)) or zoneE:Contains(Player)) or zoneC:Contains(Player)) or zoneD:Contains(Player) then
		_hs0_1.Commands._U7OPw.Enabled = false
		_tlRjg = true
		_T9G()
		_HwP()
		_Urwigo.Dialog(false, {
			{
				Text = _DTPUC("\126\111\063\111\044\086\023\045\031\086\101\012\052\045\044\031\074\086\014\059\033\052\063\052\101\086\023\052\014\064\031\033\086\074\111\107\052\033\047\079\115\005\121\080\038\064\031\086\045\052\086\074\053\102\023\086\040\059\107\038\088\086\033\052\021\031\086\023\052\014\064\059\074\044\031\053\038\033\031\086\088\059\014\038\086\021\111\021\064\111\033\052\064\111\053\111\086\023\111\101\059\086\101\012\052\045\044\052\064\031\086\023\052\014\064\031\033\086\074\111\107\052\033\047")
			}, 
			{
				Text = _DTPUC("\092\101\074\102\111\044\064\052\086\033\111\045\086\064\111\101\012\052\045\044\052\064\059\114\086").._LhC, 
				Media = _cTPs, 
				Buttons = {
					_DTPUC("\042\059\101\012\111\063\059\053\111\074")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.MessageBox{
			Text = _DTPUC("\080\052\045\074\059\023\031\045\086\064\111\086\021\111\014\064\052\033\086\088\059\014\052\047"), 
			Buttons = {
				_DTPUC("\062\014\031\086\064\111\086\040\059\063\111\074\052\063\064\031\086\088\059\014")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end

-- Urwigo functions --
function _T9G()
	if zoneA:Contains(Player) then
		_g5Q = _DTPUC("\092")
	elseif zoneB:Contains(Player) then
		_g5Q = _DTPUC("\115")
	elseif zoneE:Contains(Player) then
		_g5Q = _DTPUC("\046")
	elseif zoneC:Contains(Player) then
		_g5Q = _DTPUC("\043")
	elseif zoneD:Contains(Player) then
		_g5Q = _DTPUC("\085")
	end
end
function _HwP()
	if _fwT == true then
		_hdVBr = _hdVBr.._g5Q
		_94NCa.Description = _hdVBr
	elseif _pXS == true then
		_yE6 = _yE6.._g5Q
		_ljj2q.Description = _yE6
	elseif _tlRjg == true then
		_LhC = _LhC.._g5Q
		_tjgR.Description = _LhC
	end
end
function _0Vr4A()
	_yd8 = _cPhv.._g5Q
	if Wherigo.NoCaseEquals(_yd8, _DTPUC("\092\115")) or Wherigo.NoCaseEquals(_yd8, _DTPUC("\115\092")) then
		if _G9EQ == false then
			_G9EQ = true
			__VA()
		else
			_bJR()
		end
	elseif Wherigo.NoCaseEquals(_yd8, _DTPUC("\092\043")) or Wherigo.NoCaseEquals(_yd8, _DTPUC("\043\092")) then
		if _TsT == false then
			_TsT = true
			__VA()
		else
			_bJR()
		end
	elseif Wherigo.NoCaseEquals(_yd8, _DTPUC("\092\046")) or Wherigo.NoCaseEquals(_yd8, _DTPUC("\046\092")) then
		if _W44 == false then
			_W44 = true
			__VA()
		else
			_bJR()
		end
	elseif Wherigo.NoCaseEquals(_yd8, _DTPUC("\115\046")) or Wherigo.NoCaseEquals(_yd8, _DTPUC("\046\115")) then
		if _slPzA == false then
			_slPzA = true
			__VA()
		else
			_bJR()
		end
	elseif Wherigo.NoCaseEquals(_yd8, _DTPUC("\115\043")) or Wherigo.NoCaseEquals(_yd8, _DTPUC("\043\115")) then
		if _Goze == false then
			_Goze = true
			__VA()
		else
			_bJR()
		end
	elseif Wherigo.NoCaseEquals(_yd8, _DTPUC("\046\043")) or Wherigo.NoCaseEquals(_yd8, _DTPUC("\043\046")) then
		if _vmxJI == false then
			_vmxJI = true
			__VA()
		else
			_bJR()
		end
	elseif Wherigo.NoCaseEquals(_yd8, _DTPUC("\046\085")) or Wherigo.NoCaseEquals(_yd8, _DTPUC("\085\046")) then
		if _0l_Ih == false then
			_0l_Ih = true
			__VA()
		else
			_bJR()
		end
	elseif Wherigo.NoCaseEquals(_yd8, _DTPUC("\043\085")) or Wherigo.NoCaseEquals(_yd8, _DTPUC("\085\043")) then
		if _Gs5B == false then
			_Gs5B = true
			__VA()
		else
			_bJR()
		end
	end
end
function __VA()
	if (((((((_G9EQ == true) and (_TsT == true)) and (_W44 == true)) and (_slPzA == true)) and (_Goze == true)) and (_vmxJI == true)) and (_0l_Ih == true)) and (_Gs5B == true) then
		_SEAl()
		if _fwT == true then
			_fwT = false
			_hs0_1.Commands._23WP.Enabled = true
			_94NCa.Complete = true
			_ljj2q.Active = true
			_Urwigo.Dialog(false, {
				{
					Text = _DTPUC("\124\012\111\074\102\044\102\023\031\086\101\086\065\047\086\045\040\012\111\053\064\052\033\102\086\012\052\045\052\064\031\047")
				}, 
				{
					Text = _DTPUC("\080\038\064\031\086\045\052\086\033\102\021\052\045\086\040\102\045\074\031\074\086\014\059\086\064\111\044\052\021\052\064\031\086\014\012\102\107\052\107\059\086\012\052\045\052\064\031\047")
				}, 
				{
					Text = _DTPUC("\042\012\052\045\102\064\086\045\052\086\014\059\086\088\059\014\102\086\053\052\086\101\074\052\012\052\033\086\063\107\063\052\045\086\021\111\063\031\074\086\101\012\052\045\044\031\074\086\014\059\033\052\063\052\101\086\023\052\014\064\031\033\086\074\111\107\052\033\086\111\086\040\059\102\021\031\023\086\074\102\021\101\102\047"), 
					Media = _cTPs, 
					Buttons = {
						_DTPUC("\062\014\031\086\064\111\086\021\111\063\111\074\052\101")
					}
				}
			}, function(action)
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end)
		elseif _pXS == true then
			if Wherigo.NoCaseEquals(_hdVBr, _yE6) then
				_bJR()
			else
				_pXS = false
				_hs0_1.Commands._U7OPw.Enabled = true
				_ljj2q.Complete = true
				_tjgR.Active = true
				_Urwigo.Dialog(false, {
					{
						Text = _DTPUC("\124\012\111\074\102\044\102\023\031\086\101\086\025\047\086\045\040\012\111\053\064\052\033\102\086\012\052\045\052\064\031\047")
					}, 
					{
						Text = _DTPUC("\080\038\064\031\086\074\031\086\023\031\021\086\021\088\038\053\111\086\064\111\044\052\021\074\086\040\059\045\044\052\014\064\031\086\012\052\045\052\064\031\047")
					}, 
					{
						Text = _DTPUC("\042\012\052\045\102\064\086\045\052\086\014\059\086\088\059\014\102\086\053\052\086\101\074\052\012\052\033\086\063\107\063\052\045\086\021\111\063\031\074\086\101\012\052\045\044\031\074\086\014\059\033\052\063\052\101\086\023\052\014\064\031\033\086\074\111\107\052\033\086\111\086\040\059\102\021\031\023\086\074\102\021\101\102\047"), 
						Media = _cTPs, 
						Buttons = {
							_DTPUC("\062\014\031\086\064\111\086\021\111\063\111\074\052\101")
						}
					}
				}, function(action)
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end)
			end
		elseif _tlRjg == true then
			if Wherigo.NoCaseEquals(_LhC, _yE6) or Wherigo.NoCaseEquals(_LhC, _hdVBr) then
				_bJR()
			else
				_tlRjg = false
				_hs0_1:MoveTo(nil)
				_tjgR.Complete = true
				zoneA.Active = false
				zoneB.Active = false
				zoneE.Active = false
				zoneC.Active = false
				zoneD.Active = false
				_Urwigo.Dialog(false, {
					{
						Text = _DTPUC("\124\012\111\074\102\044\102\023\031\086\101\086\113\047\086\045\040\012\111\053\064\052\033\102\086\012\052\045\052\064\031\047")
					}, 
					{
						Text = _DTPUC("\080\038\064\031\086\033\102\021\052\045\086\023\031\021\086\053\038\012\111\021\031\074\086\107\044\052\014\111\074\086\063\111\063\107\052\047"), 
						Buttons = {
							_DTPUC("\039\015\049\126\026\097\086\089\005\039")
						}
					}
				}, function(action)
					_nMx:RequestSync()
					_fcfc()
				end)
			end
		end
	else
		_Cdwgr()
	end
end
function _bJR()
	_SEAl()
	if _fwT == true then
		_94NCa.Description = ""
		_hdVBr = ""
		_fwT = false
		_hs0_1.Commands._NkLW.Enabled = true
	elseif _pXS == true then
		_ljj2q.Description = ""
		_yE6 = ""
		_pXS = false
		_hs0_1.Commands._23WP.Enabled = true
	elseif _tlRjg == true then
		_tjgR.Description = ""
		_LhC = ""
		_tlRjg = false
		_hs0_1.Commands._U7OPw.Enabled = true
	end
	_Urwigo.Dialog(false, {
		{
			Text = _DTPUC("\039\014\052\044\111\044\086\023\045\031\086\063\107\038\088\102\086\064\052\088\059\086\064\111\101\012\052\045\031\044\086\014\059\033\052\063\052\101\086\045\074\052\023\064\052\086\023\111\101\059\086\053\086\040\012\052\014\063\107\059\021\031\033\086\012\052\045\052\064\031\047\079\115\005\121\055\086\111\101\074\102\111\044\064\031\033\086\012\052\045\052\064\031\033\086\033\102\045\031\045\086\021\111\063\031\074\086\021\064\059\053\102\047")
		}, 
		{
			Text = _DTPUC("\042\012\052\045\102\064\086\045\052\086\014\059\086\088\059\014\102\086\053\052\086\101\074\052\012\052\033\086\063\107\063\052\045\086\021\111\063\031\074\086\101\012\052\045\044\031\074\086\014\059\033\052\063\052\101\086\023\052\014\064\031\033\086\074\111\107\052\033\086\111\086\040\059\102\021\031\023\086\074\102\021\101\102\047")
		}, 
		{
			Text = _DTPUC("\043\059\040\059\012\102\063\102\023\031\086\021\111\063\031\074\086\053\086\088\059\014\052\086\092\086\064\052\088\059\086\053\086\088\059\014\052\086\115\047"), 
			Buttons = {
				_DTPUC("\062\031\074\086\014\059\086\053\038\063\107\059\021\031\107\059\086\088\059\014\102")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function _4kgt()
	if ((_fwT == true) or (_pXS == true)) or (_tlRjg == true) then
		_cPhv = _g5Q
		_T9G()
		if Wherigo.NoCaseEquals(_g5Q, _cPhv) then
			_Urwigo.MessageBox{
				Text = _DTPUC("\032\074\111\074\031\044\086\023\045\031\086\045\052\086\014\059\086\088\059\014\102\086").._g5Q, 
				Buttons = {
					_DTPUC("\042\059\101\012\111\063\059\053\111\074")
				}, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			}
		else
			_HwP()
			_0Vr4A()
		end
	else
	end
end
function _SEAl()
	_G9EQ = false
	_TsT = false
	_W44 = false
	_slPzA = false
	_Goze = false
	_vmxJI = false
	_0l_Ih = false
	_Gs5B = false
end
function _Cdwgr()
	if _fwT == true then
		_Urwigo.MessageBox{
			Text = _DTPUC("\092\101\074\102\111\044\064\052\086\033\111\045\086\064\111\101\012\052\045\044\052\064\059\114\086").._hdVBr, 
			Media = _cTPs, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _pXS == true then
		_Urwigo.MessageBox{
			Text = _DTPUC("\092\101\074\102\111\044\064\052\086\033\111\045\086\064\111\101\012\052\045\044\052\064\059\114\086").._yE6, 
			Media = _cTPs, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _tlRjg == true then
		_Urwigo.MessageBox{
			Text = _DTPUC("\092\101\074\102\111\044\064\052\086\033\111\045\086\064\111\101\012\052\045\044\052\064\059\114\086").._LhC, 
			Media = _cTPs, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _fcfc()
	nasobic = string.sub(gckod, 3, 3)
	nasobic = tonumber(nasobic..(string.sub(gckod, 5, 5)))
	nsouradnice = 1.55934009375 * nasobic
	esouradnice = 452.525856 / nasobic
	pomocnaB.Visible = true
	CenterZoneOnPoint(pomocnaB, ZonePoint(nsouradnice,esouradnice,0), 7)
	_JTaM9.Active = true
	_OQeP.Visible = true
	_Urwigo.MessageBox{
		Text = _DTPUC("\115\038\044\111\086\059\014\101\012\038\074\111\086\021\059\064\111\086\046\092\046\089\085\047\086"), 
		Buttons = {
			_DTPUC("\080\092\032\026\124\049\032\092\097")
		}, 
		Callback = function(action)
			if action ~= nil then
				_nMx:RequestSync()
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, pomocnaB)
			end
		end
	}
end

-- Begin user functions --
function CenterZoneOnPoint(zZone, point, ZoneRadius)
  local dist = Wherigo.Distance(0, 'ft')
  local newZp = Wherigo.TranslatePoint(point, dist, 0)   -- new center point for the new zone    
  dist = Wherigo.Distance(ZoneRadius, 'm')
  local pts = {
    Wherigo.TranslatePoint(newZp, dist, 0),
    Wherigo.TranslatePoint(newZp, dist, 45),
    Wherigo.TranslatePoint(newZp, dist, 90),
    Wherigo.TranslatePoint(newZp, dist, 135),
    Wherigo.TranslatePoint(newZp, dist, 180),
    Wherigo.TranslatePoint(newZp, dist, 225),
    Wherigo.TranslatePoint(newZp, dist, 270),
    Wherigo.TranslatePoint(newZp, dist, 315),
  }

  zZone.Active = false
  zZone.OriginalPoint.latitude = newZp.latitude
  zZone.OriginalPoint.longitude = newZp.longitude

  zZone.Points = pts
  zZone.Active = true
end

function BuildHouse(pointA, pointB, zoneA, zoneB, zoneC, zoneD, zoneE, zoneRadius)
  print(pointA)
  print(pointB)
  CenterZoneOnPoint(zoneA, pointA, zoneRadius)
  CenterZoneOnPoint(zoneB, pointB, zoneRadius)
  local dist, bearing = Wherigo.VectorToPoint(pointA, pointB)
  local dist2 = Wherigo.Distance(dist:GetValue 'm' * 0.7071, 'm')
  local pointC = Wherigo.TranslatePoint(pointB, dist, bearing - 90)
  CenterZoneOnPoint(zoneC, pointC, zoneRadius)
  local pointD = Wherigo.TranslatePoint(pointC, dist2, bearing - 135)
  CenterZoneOnPoint(zoneD, pointD, zoneRadius)
  local pointE = Wherigo.TranslatePoint(pointC, dist, bearing - 180)
  CenterZoneOnPoint(zoneE, pointE, zoneRadius)
end
-- End user functions --
return _nMx
