require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

_bUT = Wherigo.ZCartridge()

-- String decode --
function _1yM(str)
	local res = ""
    local dtable = "\025\125\016\012\042\022\111\108\076\114\020\046\080\075\049\110\085\061\119\097\086\034\015\018\010\060\004\043\056\088\051\008\038\062\094\063\054\055\098\104\078\117\089\041\047\124\058\011\013\064\090\048\019\044\113\095\033\003\057\077\027\026\045\035\092\006\009\050\007\052\002\068\036\070\087\074\024\071\099\072\112\059\028\103\106\100\005\126\039\118\115\105\014\031\067\000\053\029\037\023\116\069\066\091\101\121\120\123\081\109\122\083\096\021\079\017\084\032\093\001\040\107\082\065\073\102\030"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
_sS7dQ = Wherigo.ZMedia(_bUT)
_sS7dQ.Id = "e4bde70e-e551-44a6-9d9c-54d9322b2560"
_sS7dQ.Name = _1yM("\072\092\091\079\007\118\072\007\084")
_sS7dQ.Description = ""
_sS7dQ.AltText = ""
_sS7dQ.Resources = {
	{
		Type = "jpg", 
		Filename = "Discoweave296x321.jpg", 
		Directives = {}
	}
}
_Husm = Wherigo.ZMedia(_bUT)
_Husm.Id = "13d2b310-605e-41ea-885d-5071f2fba759"
_Husm.Name = _1yM("\117\092\010\105")
_Husm.Description = ""
_Husm.AltText = ""
_Husm.Resources = {
	{
		Type = "jpg", 
		Filename = "tire.jpg", 
		Directives = {}
	}
}
_c_Tzk = Wherigo.ZMedia(_bUT)
_c_Tzk.Id = "cf7f9bd3-0d7d-476f-989f-f80e8424425c"
_c_Tzk.Name = _1yM("\103\007\101\101\008\105\091")
_c_Tzk.Description = ""
_c_Tzk.AltText = ""
_c_Tzk.Resources = {
	{
		Type = "JPG", 
		Filename = "bottles.JPG", 
		Directives = {}
	}
}
_xQJqx = Wherigo.ZMedia(_bUT)
_xQJqx.Id = "30e3e788-a03c-4cb5-83a7-3c7a8dc1292a"
_xQJqx.Name = _1yM("\101\090")
_xQJqx.Description = ""
_xQJqx.AltText = ""
_xQJqx.Resources = {
	{
		Type = "JPG", 
		Filename = "TV.JPG", 
		Directives = {}
	}
}
_LnQ = Wherigo.ZMedia(_bUT)
_LnQ.Id = "729ca1b4-3803-4f03-a84c-69dd04a06aca"
_LnQ.Name = _1yM("\101\010\020\091\040\118\039\020\084")
_LnQ.Description = ""
_LnQ.AltText = ""
_LnQ.Resources = {
	{
		Type = "JPG", 
		Filename = "trashbags.JPG", 
		Directives = {}
	}
}
_5oV = Wherigo.ZMedia(_bUT)
_5oV.Id = "d442f37f-da42-42ce-b29a-c5b6bc4301c8"
_5oV.Name = _1yM("\084\008\007\090\105\091")
_5oV.Description = ""
_5oV.AltText = ""
_5oV.Resources = {
	{
		Type = "JPG", 
		Filename = "gloves.JPG", 
		Directives = {}
	}
}
_VAYan = Wherigo.ZMedia(_bUT)
_VAYan.Id = "89fc2b16-392c-4dd6-b1c7-a2aed8664b83"
_VAYan.Name = _1yM("\079\020\079\040\105")
_VAYan.Description = ""
_VAYan.AltText = ""
_VAYan.Resources = {
	{
		Type = "JPG", 
		Filename = "cachecan.JPG", 
		Directives = {}
	}
}
_Cxr2 = Wherigo.ZMedia(_bUT)
_Cxr2.Id = "7067fea2-ce82-4924-ae65-d0aa57642c2a"
_Cxr2.Name = _1yM("\079\092\084\020\010\105\101\101\105\091")
_Cxr2.Description = ""
_Cxr2.AltText = ""
_Cxr2.Resources = {
	{
		Type = "JPG", 
		Filename = "Cigs.JPG", 
		Directives = {}
	}
}
_31e = Wherigo.ZMedia(_bUT)
_31e.Id = "051b2202-324c-449c-bc0b-c666f89b2624"
_31e.Name = _1yM("\091\040\007\105")
_31e.Description = ""
_31e.AltText = ""
_31e.Resources = {
	{
		Type = "JPG", 
		Filename = "ashoe.JPG", 
		Directives = {}
	}
}
_rE_AN = Wherigo.ZMedia(_bUT)
_rE_AN.Id = "5a6a0cc4-e106-411a-9ea3-34428073213e"
_rE_AN.Name = _1yM("\110\020\081")
_rE_AN.Description = ""
_rE_AN.AltText = ""
_rE_AN.Resources = {
	{
		Type = "JPG", 
		Filename = "map.JPG", 
		Directives = {}
	}
}
_C4M = Wherigo.ZMedia(_bUT)
_C4M.Id = "76907f93-31d8-4af6-bf64-e3d262dafd6a"
_C4M.Name = _1yM("\040\042\039\079\020\081")
_C4M.Description = ""
_C4M.AltText = ""
_C4M.Resources = {
	{
		Type = "JPG", 
		Filename = "hubcap.JPG", 
		Directives = {}
	}
}
_Ku1aG = Wherigo.ZMedia(_bUT)
_Ku1aG.Id = "9d2ecb97-a5fe-4057-968d-1c2d27530961"
_Ku1aG.Name = _1yM("\081\008\020\101\105")
_Ku1aG.Description = ""
_Ku1aG.AltText = ""
_Ku1aG.Resources = {
	{
		Type = "JPG", 
		Filename = "paperplate.JPG", 
		Directives = {}
	}
}
_fHy7 = Wherigo.ZMedia(_bUT)
_fHy7.Id = "77508813-9286-4637-b0f4-c3dff13d48a2"
_fHy7.Name = _1yM("\101\092\016\118\079\020\016")
_fHy7.Description = ""
_fHy7.AltText = ""
_fHy7.Resources = {
	{
		Type = "JPG", 
		Filename = "tincan.JPG", 
		Directives = {}
	}
}
_lTmI = Wherigo.ZMedia(_bUT)
_lTmI.Id = "52226927-bbe0-4772-9a09-d980f402f8a6"
_lTmI.Name = _1yM("\081\040\007\016\105")
_lTmI.Description = ""
_lTmI.AltText = ""
_lTmI.Resources = {
	{
		Type = "jpg", 
		Filename = "phones.jpg", 
		Directives = {}
	}
}
_azS = Wherigo.ZMedia(_bUT)
_azS.Id = "64a6c9f0-fe15-46a8-8841-09b60c721995"
_azS.Name = _1yM("\112\092\084\016")
_azS.Description = ""
_azS.AltText = ""
_azS.Resources = {
	{
		Type = "jpg", 
		Filename = "Geocachercleanup1.jpg", 
		Directives = {}
	}
}
_FsHHz = Wherigo.ZMedia(_bUT)
_FsHHz.Id = "e9a9f9e8-f88d-4d9b-bb35-c0a146758f92"
_FsHHz.Name = _1yM("\117\010\020\126\126\092\079\118\112\020\126\105\101\106\118\021\105\091\101")
_FsHHz.Description = ""
_FsHHz.AltText = ""
_FsHHz.Resources = {
	{
		Type = "JPG", 
		Filename = "vest.JPG", 
		Directives = {}
	}
}
_6ZiG = Wherigo.ZMedia(_bUT)
_6ZiG.Id = "918b51e4-66d4-403e-901b-24863e8b2285"
_6ZiG.Name = _1yM("\117\010\020\091\040\118\095\020\016\091")
_6ZiG.Description = ""
_6ZiG.AltText = ""
_6ZiG.Resources = {
	{
		Type = "JPG", 
		Filename = "trashcans.JPG", 
		Directives = {}
	}
}
-- Cartridge Info --
_bUT.Id="00f223ca-8ca3-4834-b1ab-c1945c89465b"
_bUT.Name="Lehigh Valley CITO "
_bUT.Description=[[The Lehigh Valley Geocacher's have adopted the nearby highway as our little section of the world to practice CITO. We will hold three events here every year. This Wherigo is here to allow everyone a chance to help keep our area clean. You will find Disco my geo dog at the CITO registration tent to assist you with the supplies and directions you need to help us clean up the area. He will also provide you with a map to your final reward, a nice smiley for helping us out!]]
_bUT.Visible=true
_bUT.Activity="Geocache"
_bUT.StartingLocationDescription=[[This Wherigo cartridge leads to the physical cache GC33TE9]]
_bUT.StartingLocation = ZonePoint(40.6968545144393,-75.3315736651412,0)
_bUT.Version="1.3"
_bUT.Company=""
_bUT.Author="agility3d"
_bUT.BuilderVersion="URWIGO 1.12.4091.37853"
_bUT.CreateDate="05/10/2010 02:14:01"
_bUT.PublishDate="1/1/0001 12:00:00 AM"
_bUT.UpdateDate="09/18/2011 18:48:57"
_bUT.LastPlayedDate="1/1/0001 12:00:00 AM"
_bUT.TargetDevice="PocketPC"
_bUT.TargetDeviceVersion="0"
_bUT.StateId="1"
_bUT.CountryId="2"
_bUT.Complete=false
_bUT.UseLogging=true

_bUT.Media=_azS

_bUT.Icon=_azS


-- Zones --
_Imf = Wherigo.Zone(_bUT)
_Imf.Id = "a3bdf388-6eb7-48d8-bbd9-89576551d214"
_Imf.Name = _1yM("\117\105\016\016\092\091\118\095\007\042\010\101\091")
_Imf.Description = ""
_Imf.Visible = true
_Imf.Commands = {}
_Imf.DistanceRange = Distance(-1, "feet")
_Imf.ShowObjects = "OnEnter"
_Imf.ProximityRange = Distance(60, "meters")
_Imf.AllowSetPositionTo = false
_Imf.Active = false
_Imf.Points = {
	ZonePoint(40.6968931522729, -75.3307475447645, 0), 
	ZonePoint(40.6966450563209, -75.3307153582565, 0), 
	ZonePoint(40.696670476031, -75.3305980116121, 0), 
	ZonePoint(40.6968667158633, -75.3306261748068, 0)
}
_Imf.OriginalPoint = ZonePoint(40.696768850122, -75.33067177236, 0)
_Imf.DistanceRangeUOM = "Feet"
_Imf.ProximityRangeUOM = "Meters"
_Imf.OutOfRangeName = ""
_Imf.InRangeName = ""
_sMxW = Wherigo.Zone(_bUT)
_sMxW.Id = "88d2a962-3871-434c-a2b8-0ab75a570865"
_sMxW.Name = _1yM("\074\007\007\101\039\020\008\008\118\112\101\020\016\086\091")
_sMxW.Description = ""
_sMxW.Visible = true
_sMxW.Commands = {}
_sMxW.DistanceRange = Distance(-1, "feet")
_sMxW.ShowObjects = "OnEnter"
_sMxW.ProximityRange = Distance(60, "meters")
_sMxW.AllowSetPositionTo = false
_sMxW.Active = false
_sMxW.Points = {
	ZonePoint(40.6964925378593, -75.3301748931401, 0), 
	ZonePoint(40.6963949258605, -75.3301252722734, 0), 
	ZonePoint(40.6964091609525, -75.3298516869539, 0), 
	ZonePoint(40.6965118568837, -75.3298798501486, 0)
}
_sMxW.OriginalPoint = ZonePoint(40.696452120389, -75.330007925629, 0)
_sMxW.DistanceRangeUOM = "Feet"
_sMxW.ProximityRangeUOM = "Meters"
_sMxW.OutOfRangeName = ""
_sMxW.InRangeName = ""
_mvB = Wherigo.Zone(_bUT)
_mvB.Id = "f22606d6-5483-4d0b-95cf-609798ff1b30"
_mvB.Name = _1yM("\102\016\086\118\007\126\118\013\020\101\040")
_mvB.Description = ""
_mvB.Visible = true
_mvB.Commands = {}
_mvB.DistanceRange = Distance(-1, "feet")
_mvB.ShowObjects = "OnEnter"
_mvB.ProximityRange = Distance(60, "meters")
_mvB.AllowSetPositionTo = false
_mvB.Active = false
_mvB.Points = {
	ZonePoint(40.6968163849768, -75.3291643708934, 0), 
	ZonePoint(40.6967045384265, -75.3291201144446, 0), 
	ZonePoint(40.6967848646044, -75.3287003487338, 0), 
	ZonePoint(40.6968865431716, -75.3287204653014, 0)
}
_mvB.OriginalPoint = ZonePoint(40.6967980827948, -75.3289263248433, 0)
_mvB.DistanceRangeUOM = "Feet"
_mvB.ProximityRangeUOM = "Meters"
_mvB.OutOfRangeName = ""
_mvB.InRangeName = ""
_efW = Wherigo.Zone(_bUT)
_efW.Id = "d41a67fe-60bd-41cf-8212-22165e1e6212"
_efW.Name = _1yM("\103\020\079\122\118\007\126\118\013\020\010\122")
_efW.Description = ""
_efW.Visible = true
_efW.Commands = {}
_efW.DistanceRange = Distance(-1, "feet")
_efW.ShowObjects = "OnEnter"
_efW.ProximityRange = Distance(60, "meters")
_efW.AllowSetPositionTo = false
_efW.Active = false
_efW.Points = {
	ZonePoint(40.6975560926612, -75.3285296931852, 0), 
	ZonePoint(40.6977014912814, -75.3285068944086, 0), 
	ZonePoint(40.6977187764109, -75.3283982649435, 0), 
	ZonePoint(40.6973822239646, -75.3283526673902, 0), 
	ZonePoint(40.6974157776081, -75.3285082355131, 0)
}
_efW.OriginalPoint = ZonePoint(40.6975548723852, -75.3284591510881, 0)
_efW.DistanceRangeUOM = "Feet"
_efW.ProximityRangeUOM = "Meters"
_efW.OutOfRangeName = ""
_efW.InRangeName = ""
_3vrdk = Wherigo.Zone(_bUT)
_3vrdk.Id = "c41b4e47-99a0-488a-bc55-5d9077ecfc43"
_3vrdk.Name = _1yM("\115\008\086\118\103\020\091\105\039\020\008\008\118\074\092\105\008\086")
_3vrdk.Description = ""
_3vrdk.Visible = true
_3vrdk.Commands = {}
_3vrdk.DistanceRange = Distance(-1, "feet")
_3vrdk.ShowObjects = "OnEnter"
_3vrdk.ProximityRange = Distance(60, "meters")
_3vrdk.AllowSetPositionTo = false
_3vrdk.Active = false
_3vrdk.Points = {
	ZonePoint(40.6980853217785, -75.3293040134004, 0), 
	ZonePoint(40.6979236556929, -75.3293160833409, 0), 
	ZonePoint(40.6978987448461, -75.329715061932, 0), 
	ZonePoint(40.6980980313597, -75.3297298140815, 0)
}
_3vrdk.OriginalPoint = ZonePoint(40.6980014384193, -75.3295162431887, 0)
_3vrdk.DistanceRangeUOM = "Feet"
_3vrdk.ProximityRangeUOM = "Meters"
_3vrdk.OutOfRangeName = ""
_3vrdk.InRangeName = ""
_AsYt = Wherigo.Zone(_bUT)
_AsYt.Id = "a04cf19e-7f71-4925-b76b-584f5bc7f796"
_AsYt.Name = _1yM("\123\105\084\092\091\101\010\020\101\092\007\016\118\117\105\016\101")
_AsYt.Description = _1yM("\117\040\092\091\118\092\091\118\019\040\105\010\105\118\106\007\042\118\019\092\008\008\118\079\040\105\079\122\118\092\016\118\101\007\118\091\101\020\010\101\118\106\007\042\010\118\009\105\040\092\084\040\118\021\020\008\008\105\106\118\095\125\117\115\118\105\090\105\016\101\012\118\043\007\042\118\019\092\008\008\118\081\092\079\122\118\042\081\118\091\042\081\081\008\092\105\091\118\040\105\010\105\118\020\016\086\118\086\010\007\081\118\007\126\126\118\101\010\020\091\040\118\040\105\010\105\118\020\091\118\106\007\042\010\118\039\020\084\091\118\084\105\101\118\126\042\008\008\012\118\123\105\110\105\110\039\105\010\118\020\016\106\101\092\110\105\118\106\007\042\010\118\039\020\084\118\092\091\118\126\042\008\008\118\106\007\042\118\110\042\091\101\118\079\007\110\105\118\039\020\084\118\040\105\010\105\118\101\007\118\086\010\007\081\118\007\126\126\118\106\007\042\010\118\101\010\020\091\040\118\020\016\086\118\084\105\101\118\020\118\016\105\019\118\039\020\084\012\118\117\040\105\118\110\007\010\105\118\039\020\084\091\118\042\091\105\086\118\101\040\105\118\079\008\105\020\016\105\010\118\007\042\010\118\081\020\010\122\118\019\092\008\008\118\084\105\101\012\118")
_AsYt.Visible = true
_AsYt.Media = _sS7dQ
_AsYt.Icon = _6ZiG
_AsYt.Commands = {}
_AsYt.DistanceRange = Distance(-1, "feet")
_AsYt.ShowObjects = "OnEnter"
_AsYt.ProximityRange = Distance(56, "meters")
_AsYt.AllowSetPositionTo = false
_AsYt.Active = true
_AsYt.Points = {
	ZonePoint(40.6965779482409, -75.3313765227788, 0), 
	ZonePoint(40.6964854203225, -75.3313872516148, 0), 
	ZonePoint(40.6965047393489, -75.3311699926846, 0), 
	ZonePoint(40.6966059099492, -75.3312041908495, 0)
}
_AsYt.OriginalPoint = ZonePoint(40.6965435044654, -75.3312844894819, 0)
_AsYt.DistanceRangeUOM = "Feet"
_AsYt.ProximityRangeUOM = "Meters"
_AsYt.OutOfRangeName = ""
_AsYt.InRangeName = ""
_8Tqz = Wherigo.Zone(_bUT)
_8Tqz.Id = "4e401ea7-0606-411a-8d5e-3bd046345002"
_8Tqz.Name = _1yM("\041\105\020\010\118\013\008\020\106\084\010\007\042\016\086")
_8Tqz.Description = ""
_8Tqz.Visible = true
_8Tqz.Commands = {}
_8Tqz.DistanceRange = Distance(-1, "feet")
_8Tqz.ShowObjects = "OnEnter"
_8Tqz.ProximityRange = Distance(100, "meters")
_8Tqz.AllowSetPositionTo = false
_8Tqz.Active = false
_8Tqz.Points = {
	ZonePoint(40.6978565489007, -75.3309066332868, 0), 
	ZonePoint(40.6976033726669, -75.3308972455554, 0), 
	ZonePoint(40.6976450603861, -75.33057135716, 0), 
	ZonePoint(40.6979353485361, -75.3305592872194, 0)
}
_8Tqz.OriginalPoint = ZonePoint(40.6977600826225, -75.3307336308054, 0)
_8Tqz.DistanceRangeUOM = "Feet"
_8Tqz.ProximityRangeUOM = "Meters"
_8Tqz.OutOfRangeName = ""
_8Tqz.InRangeName = ""

-- Characters --
_Nd_NK = Wherigo.ZCharacter(_bUT)
_Nd_NK.Id = "f2fa22a7-a815-431f-8fa1-8c4bf7561235"
_Nd_NK.Name = _1yM("\072\092\091\079\007\118\072\007\084")
_Nd_NK.Description = ""
_Nd_NK.Visible = true
_Nd_NK.Media = _sS7dQ
_Nd_NK.Commands = {}
_Nd_NK.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Nd_NK.Gender = "Male"
_Nd_NK.Type = "NPC"

-- Items --
_RON = Wherigo.ZItem(_bUT)
_RON.Id = "7cffbb04-deb2-4908-a14e-04cf444f4b30"
_RON.Name = _1yM("\117\010\020\091\040\118\039\020\084\091")
_RON.Description = ""
_RON.Visible = true
_RON.Media = _LnQ
_RON.Commands = {
	_Wk2x = Wherigo.ZCommand{
		Text = _1yM("\013\092\079\122\118\042\081"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_RON.Commands._Wk2x.Custom = true
_RON.Commands._Wk2x.Id = "b19c4ad3-9ea0-4b0d-a190-b3d16e683be8"
_RON.Commands._Wk2x.WorksWithAll = true
_RON.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_RON.Locked = false
_RON.Opened = false
_tXi9 = Wherigo.ZItem(_bUT)
_tXi9.Id = "16dfd67a-5475-4d9d-96e7-8beb31ad147e"
_tXi9.Name = _1yM("\078\008\007\090\105\091")
_tXi9.Description = ""
_tXi9.Visible = true
_tXi9.Media = _5oV
_tXi9.Commands = {
	_poxIQ = Wherigo.ZCommand{
		Text = _1yM("\013\042\101\118\007\016"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_tXi9.Commands._poxIQ.Custom = true
_tXi9.Commands._poxIQ.Id = "a613cbb1-6bcc-4d82-89a7-a9619a95de1f"
_tXi9.Commands._poxIQ.WorksWithAll = true
_tXi9.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_tXi9.Locked = false
_tXi9.Opened = false
_FtV = Wherigo.ZItem(_bUT)
_FtV.Id = "fae48c21-9265-4930-9038-45cb9279b3a1"
_FtV.Name = _1yM("\095\092\084\020\010\105\101\101\105\091")
_FtV.Description = ""
_FtV.Visible = true
_FtV.Media = _Cxr2
_FtV.Commands = {
	_E87JH = Wherigo.ZCommand{
		Text = _1yM("\013\008\020\079\105\118\092\016\118\101\010\020\091\040\118\039\020\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_FtV.Commands._E87JH.Custom = true
_FtV.Commands._E87JH.Id = "f0c46a8b-b24b-4301-ac7c-4f9871d194ed"
_FtV.Commands._E87JH.WorksWithAll = true
_FtV.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_FtV.Locked = false
_FtV.Opened = false
_fin = Wherigo.ZItem(_bUT)
_fin.Id = "f4428392-4ec5-4aa9-bbd8-beef65e2b684"
_fin.Name = _1yM("\013\007\010\101\020\039\008\105\118\081\040\007\016\105")
_fin.Description = ""
_fin.Visible = true
_fin.Media = _lTmI
_fin.Commands = {
	_ONAP = Wherigo.ZCommand{
		Text = _1yM("\013\008\020\079\105\118\092\016\118\101\010\020\091\040\118\039\020\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_fin.Commands._ONAP.Custom = true
_fin.Commands._ONAP.Id = "260926d5-d9b6-4145-aaec-35551d56d374"
_fin.Commands._ONAP.WorksWithAll = true
_fin.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_fin.Locked = false
_fin.Opened = false
_pBA1s = Wherigo.ZItem(_bUT)
_pBA1s.Id = "f71f20b6-16d1-44b4-aed3-c15687334883"
_pBA1s.Name = _1yM("\103\007\101\101\008\105\091")
_pBA1s.Description = ""
_pBA1s.Visible = true
_pBA1s.Media = _c_Tzk
_pBA1s.Commands = {
	_LtM = Wherigo.ZCommand{
		Text = _1yM("\013\008\020\079\105\118\092\016\118\101\010\020\091\040\118\039\020\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_pBA1s.Commands._LtM.Custom = true
_pBA1s.Commands._LtM.Id = "d11dbd5a-86dc-45e1-b71d-c46e3bd3765f"
_pBA1s.Commands._LtM.WorksWithAll = true
_pBA1s.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_pBA1s.Locked = false
_pBA1s.Opened = false
_yRB9 = Wherigo.ZItem(_bUT)
_yRB9.Id = "c8b57f48-efa7-4962-9f07-7cb059c3a60d"
_yRB9.Name = _1yM("\103\042\091\101\105\086\118\117\012\021\012")
_yRB9.Description = ""
_yRB9.Visible = true
_yRB9.Media = _xQJqx
_yRB9.Commands = {
	_Wy4 = Wherigo.ZCommand{
		Text = _1yM("\013\008\020\079\105\118\092\016\118\101\010\020\091\040\118\039\020\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1yM("\041\007\101\040\092\016\084\118\020\090\020\092\008\020\039\008\105")
	}
}
_yRB9.Commands._Wy4.Custom = true
_yRB9.Commands._Wy4.Id = "044ebe33-1b26-4e05-9a17-7511016945f6"
_yRB9.Commands._Wy4.WorksWithAll = true
_yRB9.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_yRB9.Locked = false
_yRB9.Opened = false
_b1os2 = Wherigo.ZItem(_bUT)
_b1os2.Id = "ed8b9f3e-6671-4ee8-87da-1f6580d1ef1f"
_b1os2.Name = _1yM("\115\008\086\118\112\040\007\105")
_b1os2.Description = ""
_b1os2.Visible = true
_b1os2.Media = _31e
_b1os2.Commands = {
	_nP7v = Wherigo.ZCommand{
		Text = _1yM("\013\008\020\079\105\118\092\016\118\101\010\020\091\040\118\039\020\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_b1os2.Commands._nP7v.Custom = true
_b1os2.Commands._nP7v.Id = "1314499c-133c-4d94-8018-7c91960b3d3c"
_b1os2.Commands._nP7v.WorksWithAll = true
_b1os2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_b1os2.Locked = false
_b1os2.Opened = false
_MZS = Wherigo.ZItem(_bUT)
_MZS.Id = "9dac50e9-edc4-4446-a7e7-bb6e4ddb8f41"
_MZS.Name = _1yM("\117\007\122\105\016")
_MZS.Description = ""
_MZS.Visible = false
_MZS.Commands = {}
_MZS.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_MZS.Locked = false
_MZS.Opened = false
_A5eDD = Wherigo.ZItem(_bUT)
_A5eDD.Id = "591559bc-2d93-410c-8f07-6c27d378c75a"
_A5eDD.Name = _1yM("\060\020\081")
_A5eDD.Description = ""
_A5eDD.Visible = false
_A5eDD.Media = _rE_AN
_A5eDD.Commands = {
	_5Nu7 = Wherigo.ZCommand{
		Text = _1yM("\013\092\079\122\118\042\081"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1yM("\041\007\101\040\092\016\084\118\020\090\020\092\008\020\039\008\105")
	}, 
	_uPk = Wherigo.ZCommand{
		Text = _1yM("\102\107\020\110\092\016\105"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = ""
	}, 
	_2qVMO = Wherigo.ZCommand{
		Text = _1yM("\080\092\016\101"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _1yM("\041\007\101\040\092\016\084\118\020\090\020\092\008\020\039\008\105")
	}, 
	_biK = Wherigo.ZCommand{
		Text = _1yM("\112\081\007\092\008\105\010"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _1yM("\041\007\101\040\092\016\084\118\020\090\020\092\008\020\039\008\105")
	}
}
_A5eDD.Commands._5Nu7.Custom = true
_A5eDD.Commands._5Nu7.Id = "d7a18522-28b6-49b3-896b-3670c7a55ebf"
_A5eDD.Commands._5Nu7.WorksWithAll = true
_A5eDD.Commands._uPk.Custom = true
_A5eDD.Commands._uPk.Id = "6f386e1f-902b-4f71-8ef2-1461cb0f4ece"
_A5eDD.Commands._uPk.WorksWithAll = true
_A5eDD.Commands._2qVMO.Custom = true
_A5eDD.Commands._2qVMO.Id = "401d649e-8ea5-4182-8128-74e8dc8cb7b6"
_A5eDD.Commands._2qVMO.WorksWithAll = true
_A5eDD.Commands._biK.Custom = true
_A5eDD.Commands._biK.Id = "6bc92b38-a31a-4fc4-8678-23f3304415eb"
_A5eDD.Commands._biK.WorksWithAll = true
_A5eDD.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_A5eDD.Locked = false
_A5eDD.Opened = false
_eFQ9 = Wherigo.ZItem(_bUT)
_eFQ9.Id = "31484d97-e380-43af-a449-affa1cabdc99"
_eFQ9.Name = _1yM("\115\008\086\118\101\092\010\105")
_eFQ9.Description = ""
_eFQ9.Visible = true
_eFQ9.Media = _Husm
_eFQ9.Commands = {
	_bK0V = Wherigo.ZCommand{
		Text = _1yM("\013\008\020\079\105\118\092\016\118\101\010\020\091\040\118\039\020\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_eFQ9.Commands._bK0V.Custom = true
_eFQ9.Commands._bK0V.Id = "13105022-86d3-47a8-9e2f-9fb33a6dfb0e"
_eFQ9.Commands._bK0V.WorksWithAll = true
_eFQ9.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_eFQ9.Locked = false
_eFQ9.Opened = false
_vS6A = Wherigo.ZItem(_bUT)
_vS6A.Id = "ba16c3c1-5f21-43af-b753-e3f6f4415ca2"
_vS6A.Name = _1yM("\117\092\016\118\095\020\016")
_vS6A.Description = ""
_vS6A.Visible = true
_vS6A.Media = _fHy7
_vS6A.Commands = {
	_hn6 = Wherigo.ZCommand{
		Text = _1yM("\013\008\020\079\105\118\092\016\118\101\010\020\091\040\118\039\020\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_vS6A.Commands._hn6.Custom = true
_vS6A.Commands._hn6.Id = "67d2d06e-c579-493d-91d9-41a98e9a7b8b"
_vS6A.Commands._hn6.WorksWithAll = true
_vS6A.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_vS6A.Locked = false
_vS6A.Opened = false
_SiJE = Wherigo.ZItem(_bUT)
_SiJE.Id = "189b42be-bd08-45d3-a0c1-5f1310ced701"
_SiJE.Name = _1yM("\080\042\039\079\020\081")
_SiJE.Description = ""
_SiJE.Visible = true
_SiJE.Media = _C4M
_SiJE.Commands = {
	_F53me = Wherigo.ZCommand{
		Text = _1yM("\013\008\020\079\105\118\092\016\118\101\010\020\091\040\118\039\020\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_SiJE.Commands._F53me.Custom = true
_SiJE.Commands._F53me.Id = "6a6ce238-53f2-4934-b7af-63926aed84a3"
_SiJE.Commands._F53me.WorksWithAll = true
_SiJE.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_SiJE.Locked = false
_SiJE.Opened = false
_zVEf = Wherigo.ZItem(_bUT)
_zVEf.Id = "60df9ceb-232b-4c5f-bb9f-f43794914266"
_zVEf.Name = _1yM("\013\020\081\105\010\118\081\008\020\101\105\091")
_zVEf.Description = ""
_zVEf.Visible = true
_zVEf.Media = _Ku1aG
_zVEf.Commands = {
	_jnQ3 = Wherigo.ZCommand{
		Text = _1yM("\013\008\020\079\105\118\092\016\118\101\010\020\091\040\118\039\020\084"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_zVEf.Commands._jnQ3.Custom = true
_zVEf.Commands._jnQ3.Id = "788d7243-d7ad-418f-8968-9ff8f2e17410"
_zVEf.Commands._jnQ3.WorksWithAll = true
_zVEf.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_zVEf.Locked = false
_zVEf.Opened = false
_Iw5NN = Wherigo.ZItem(_bUT)
_Iw5NN.Id = "73dd8325-acfb-4e70-858e-120e5253ab4e"
_Iw5NN.Name = _1yM("\095\007\110\081\008\105\101\092\007\016\118\095\007\086\105")
_Iw5NN.Description = _1yM("\043\115\017\123\118\072\115\041\102\057")
_Iw5NN.Visible = false
_Iw5NN.Media = _azS
_Iw5NN.Commands = {
	_vuC = Wherigo.ZCommand{
		Text = _1yM("\112\040\007\019\118\079\007\086\105"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _1yM("\041\007\101\040\092\016\084\118\020\090\020\092\008\020\039\008\105")
	}, 
	_ZgW3 = Wherigo.ZCommand{
		Text = _1yM("\017\091\105\010\016\020\110\105"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_Iw5NN.Commands._vuC.Custom = true
_Iw5NN.Commands._vuC.Id = "18f8e75a-b7c7-4c4e-83e4-a04e0affc5c9"
_Iw5NN.Commands._vuC.WorksWithAll = true
_Iw5NN.Commands._ZgW3.Custom = true
_Iw5NN.Commands._ZgW3.Id = "73e7189b-2c87-4ca9-8b97-e51c363a83f1"
_Iw5NN.Commands._ZgW3.WorksWithAll = true
_Iw5NN.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Iw5NN.Locked = false
_Iw5NN.Opened = false
_FbT = Wherigo.ZItem(_bUT)
_FbT.Id = "6e94909f-97bb-4e6c-9c12-2c5e65e7191f"
_FbT.Name = _1yM("\117\010\020\126\126\092\079\118\112\020\126\105\101\106\118\021\105\091\101")
_FbT.Description = ""
_FbT.Visible = true
_FbT.Media = _FsHHz
_FbT.Commands = {
	_Jky6 = Wherigo.ZCommand{
		Text = _1yM("\013\042\101\118\007\016"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}
}
_FbT.Commands._Jky6.Custom = true
_FbT.Commands._Jky6.Id = "4ae0879a-9bed-4d7b-a716-886ba60fa86e"
_FbT.Commands._Jky6.WorksWithAll = true
_FbT.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_FbT.Locked = false
_FbT.Opened = false

-- Tasks --

-- Cartridge Variables --
_jKn = 0
_ca6Hc = 0
_kWQ3 = 0
_wJHV = 0
_1s_N = 0
_bUT.ZVariables = {
	_jKn = 0, 
	_ca6Hc = 0, 
	_kWQ3 = 0, 
	_wJHV = 0, 
	_1s_N = 0
}

-- Timers --
_xPiC = Wherigo.ZTimer(_bUT)
_xPiC.Id = "08e102d9-a145-44ab-948d-2b7c14974c1d"
_xPiC.Name = _1yM("\041\020\110\105")
_xPiC.Description = ""
_xPiC.Visible = true
_xPiC.Duration = 60.2141437503575
_xPiC.Type = "Countdown"

-- Inputs --

-- WorksWithList for object commands --

-- functions --
function _bUT:OnStart()
	if (_G[_1yM("\102\016\090")][_1yM("\072\105\090\092\079\105\125\072")] == _1yM("\072\105\091\122\101\007\081")) or (_G[_1yM("\102\016\090")][_1yM("\013\008\020\101\126\007\010\110")] == _1yM("\075\092\016\031\068")) then
		for k, v in pairs(_G[_1yM("\056\039\017\117")][_1yM("\124\008\008\051\115\039\085\105\079\101\091")]) do
			v[_1yM("\021\092\091\092\039\008\105")] = false
			v[_1yM("\124\079\101\092\090\105")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_1yM("\043\007\042\118\110\020\106\118\016\007\101\118\042\091\105\118\020\016\118\105\110\042\008\020\101\007\010\118\019\092\101\040\118\101\040\092\091\118\079\020\010\101\010\092\086\084\105\012")), 
			Callback = function(action)
				if action ~= nil then
					_G[_1yM("\075\040\105\010\092\084\007")][_1yM("\095\007\110\110\020\016\086")](_1yM("\112\020\090\105\095\008\007\091\105"))
				end
			end
		}
		return
	end
	_xPiC[_1yM("\112\101\020\010\101")](_xPiC)
	_Urwigo.MessageBox{
		Text = _1yM("\075\105\008\079\007\110\105\118\101\007\118\101\040\105\118\019\040\105\010\092\084\007\118\009\105\040\092\084\040\118\021\020\008\008\105\106\118\095\125\117\115\012\118\112\105\105\122\118\007\042\101\118\101\040\105\118\095\125\117\115\118\010\105\084\092\091\101\010\020\101\092\007\016\118\101\105\016\101\118\101\007\118\084\105\101\118\091\101\020\010\101\105\086\012"), 
		Media = _azS
	}
	_RON:MoveTo(_AsYt)
	_tXi9:MoveTo(_AsYt)
	_FbT:MoveTo(_AsYt)
	_Nd_NK:MoveTo(_AsYt)
end
function _bUT:OnRestore()
	_xPiC[_1yM("\112\101\020\010\101")](_xPiC)
end
function _Imf:OnEnter()
	Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end
function _Imf:OnExit()
	if (#_Imf.Inventory) == 0 then
		_Imf.Active = false
	end
end
function _sMxW:OnEnter()
	Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end
function _sMxW:OnExit()
	if (#_sMxW.Inventory) == 0 then
		_sMxW.Active = false
	end
end
function _mvB:OnEnter()
	Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end
function _mvB:OnExit()
	if (#_mvB.Inventory) == 0 then
		_mvB.Active = false
	end
end
function _efW:OnEnter()
	Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end
function _efW:OnExit()
	if (#_efW.Inventory) == 0 then
		_efW.Active = false
	end
end
function _3vrdk:OnEnter()
	Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end
function _3vrdk:OnExit()
	if (#_3vrdk.Inventory) == 0 then
		_3vrdk.Active = false
	end
end
function _AsYt:OnEnter()
	if not Player:Contains(_MZS) then
		if not Player:Contains(_A5eDD) then
			local _rndChoiceValue = math.random()
			if _rndChoiceValue < 0.166666666666667 then
				_pBA1s:MoveTo(_mvB)
				_b1os2:MoveTo(_efW)
				_fin:MoveTo(_3vrdk)
			elseif _rndChoiceValue < 0.333333333333333 then
				_FtV:MoveTo(_mvB)
				_yRB9:MoveTo(_Imf)
				_pBA1s:MoveTo(_efW)
				_b1os2:MoveTo(_3vrdk)
				_fin:MoveTo(_sMxW)
			elseif _rndChoiceValue < 0.5 then
				_FtV:MoveTo(_3vrdk)
				_yRB9:MoveTo(_sMxW)
				_pBA1s:MoveTo(_Imf)
				_b1os2:MoveTo(_mvB)
				_fin:MoveTo(_efW)
			elseif _rndChoiceValue < 0.666666666666667 then
				_FtV:MoveTo(_sMxW)
				_yRB9:MoveTo(_efW)
				_pBA1s:MoveTo(_3vrdk)
				_b1os2:MoveTo(_Imf)
				_fin:MoveTo(_mvB)
			elseif _rndChoiceValue < 0.833333333333333 then
				_FtV:MoveTo(_sMxW)
				_yRB9:MoveTo(_mvB)
				_pBA1s:MoveTo(_3vrdk)
				_b1os2:MoveTo(_efW)
				_fin:MoveTo(_Imf)
			else
				_FtV:MoveTo(_efW)
				_yRB9:MoveTo(_3vrdk)
				_pBA1s:MoveTo(_mvB)
				_b1os2:MoveTo(_Imf)
				_fin:MoveTo(_sMxW)
			end
			local _rndChoiceValue = math.random()
			if _rndChoiceValue < 0.142857142857143 then
				_eFQ9:MoveTo(_Imf)
			elseif _rndChoiceValue < 0.285714285714286 then
				_eFQ9:MoveTo(_sMxW)
			elseif _rndChoiceValue < 0.428571428571429 then
				_eFQ9:MoveTo(_mvB)
			elseif _rndChoiceValue < 0.571428571428571 then
				_eFQ9:MoveTo(_efW)
			elseif _rndChoiceValue < 0.714285714285714 then
				_eFQ9:MoveTo(_3vrdk)
			elseif _rndChoiceValue < 0.857142857142857 then
				_eFQ9.Visible = false
			else
				_eFQ9:MoveTo(_8Tqz)
				_8Tqz.Active = true
			end
			local _rndChoiceValue = math.random()
			if _rndChoiceValue < 0.142857142857143 then
				_vS6A:MoveTo(_Imf)
			elseif _rndChoiceValue < 0.285714285714286 then
				_vS6A:MoveTo(_sMxW)
			elseif _rndChoiceValue < 0.428571428571429 then
				_vS6A:MoveTo(_mvB)
			elseif _rndChoiceValue < 0.571428571428571 then
				_vS6A:MoveTo(_efW)
			elseif _rndChoiceValue < 0.714285714285714 then
				_vS6A:MoveTo(_3vrdk)
			elseif _rndChoiceValue < 0.857142857142857 then
				_vS6A.Visible = false
			else
				_vS6A:MoveTo(_8Tqz)
				_8Tqz.Active = true
			end
			local _rndChoiceValue = math.random()
			if _rndChoiceValue < 0.142857142857143 then
				_SiJE:MoveTo(_Imf)
			elseif _rndChoiceValue < 0.285714285714286 then
				_SiJE:MoveTo(_sMxW)
			elseif _rndChoiceValue < 0.428571428571429 then
				_SiJE:MoveTo(_mvB)
			elseif _rndChoiceValue < 0.571428571428571 then
				_SiJE:MoveTo(_efW)
			elseif _rndChoiceValue < 0.714285714285714 then
				_SiJE:MoveTo(_3vrdk)
			elseif _rndChoiceValue < 0.857142857142857 then
				_SiJE.Visible = false
			else
				_SiJE:MoveTo(_8Tqz)
				_8Tqz.Active = true
			end
			local _rndChoiceValue = math.random()
			if _rndChoiceValue < 0.142857142857143 then
				_zVEf:MoveTo(_Imf)
			elseif _rndChoiceValue < 0.285714285714286 then
				_zVEf:MoveTo(_sMxW)
			elseif _rndChoiceValue < 0.428571428571429 then
				_zVEf:MoveTo(_mvB)
			elseif _rndChoiceValue < 0.571428571428571 then
				_zVEf:MoveTo(_efW)
			elseif _rndChoiceValue < 0.714285714285714 then
				_zVEf:MoveTo(_3vrdk)
			elseif _rndChoiceValue < 0.857142857142857 then
				_zVEf.Visible = false
			else
				_zVEf:MoveTo(_8Tqz)
				_8Tqz.Active = true
			end
			_Imf.Active = true
			_sMxW.Active = true
			_mvB.Active = true
			_efW.Active = true
			_3vrdk.Active = true
			_MZS:MoveTo(Player)
			_A5eDD:MoveTo(_AsYt)
			_Urwigo.MessageBox{
				Text = _1yM("\075\105\008\079\007\110\105\118\101\007\118\101\040\105\118\019\040\105\010\092\084\007\118\009\105\040\092\084\040\118\021\020\008\008\105\106\118\095\125\117\115\012\118\117\040\092\091\118\081\020\010\122\118\092\091\118\020\118\110\105\091\091\118\091\007\118\008\105\101\091\118\079\008\105\020\016\118\092\101\118\042\081\012"), 
				Media = _sS7dQ, 
				Callback = function(action)
					if action ~= nil then
						_Urwigo.MessageBox{
							Text = _1yM("\117\020\122\105\118\020\118\101\010\020\091\040\118\039\020\084\054\118\091\020\126\105\101\106\118\090\105\091\101\118\020\016\086\118\091\007\110\105\118\084\008\007\090\105\091\118\020\016\086\118\008\105\101\091\118\084\105\101\118\091\101\020\010\101\105\086\012\118"), 
							Media = _sS7dQ, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
								end
							end
						}
					end
				end
			}
		end
	elseif Player:Contains(_MZS) then
		if _ca6Hc > 0 then
			_wJHV = _ca6Hc + _wJHV
			_ca6Hc = 0
			_RON:MoveTo(_AsYt)
			_RON.Commands._Wk2x.Enabled = true
			if _RON:Contains(_yRB9) then
				_yRB9.Visible = false
			end
			if _RON:Contains(_b1os2) then
				_b1os2.Visible = false
			end
			if _RON:Contains(_pBA1s) then
				_pBA1s.Visible = false
			end
			if _RON:Contains(_FtV) then
				_FtV.Visible = false
			end
			if _RON:Contains(_fin) then
				_zVEf.Visible = false
			end
			if _RON:Contains(_eFQ9) then
				_eFQ9.Visible = false
			end
			if _RON:Contains(_vS6A) then
				_vS6A.Visible = false
			end
			if _RON:Contains(_SiJE) then
				_SiJE.Visible = false
			end
			if _RON:Contains(_zVEf) then
				_zVEf.Visible = false
			end
		end
		if _wJHV >= 20 then
			_A5eDD.Visible = true
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\118\040\020\090\105\118\081\092\079\122\105\086\118\042\081\118\105\016\007\042\084\040\118\101\010\020\091\040\118\101\007\118\033\016\039\091\081\082\084\105\101\118\106\007\042\010\118\010\105\019\020\010\086\054\118\020\118\110\020\081\118\101\007\118\101\040\105\118\084\105\007\079\020\079\040\105\118\007\010\118\106\007\042\118\079\020\016\118\079\007\016\101\092\016\042\105\118\101\007\118\079\008\105\020\016\118\042\081\118\101\040\105\118\081\020\010\122\118\126\092\010\091\101\012\012\118\026\103\123\034"), 
				Media = _sS7dQ, 
				Callback = function(action)
					if action ~= nil then
						_Urwigo.MessageBox{
							Text = _1yM("\117\020\122\105\118\101\040\105\118\110\020\081\118\092\101\118\019\092\008\008\118\008\105\020\086\118\106\007\042\118\101\007\118\101\040\105\118\081\010\092\111\105\054\118\101\040\105\118\126\092\016\020\008\118\084\105\007\079\020\079\040\105\118\008\007\079\020\101\092\007\016\012\118"), 
							Media = _sS7dQ, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
								end
							end
						}
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _1yM("\117\040\092\091\118\081\020\010\122\118\092\091\118\091\101\092\008\008\118\020\118\110\105\091\091\012\118\117\020\122\105\118\020\118\016\105\019\118\101\010\020\091\040\118\039\020\084\118\101\007\118\084\105\101\118\091\007\110\105\118\110\007\010\105\118\101\010\020\091\040\012\118"), 
				Media = _sS7dQ, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
					end
				end
			}
		end
	end
	_bUT:RequestSync()
end
function _AsYt:OnExit()
	if Player:Contains(_FbT) then
		_Urwigo.MessageBox{
			Text = _1yM("\103\105\118\091\042\010\105\118\101\007\118\122\105\105\081\118\106\007\042\010\118\090\105\091\101\118\007\016\118\020\091\118\106\007\042\118\019\007\010\122\118\040\105\010\105\118\092\016\118\007\042\010\118\081\020\010\122\118\019\040\092\008\105\118\101\040\105\010\105\118\110\020\106\118\016\007\101\118\039\105\118\020\118\008\007\101\118\007\126\118\101\010\020\126\126\092\079\118\020\010\007\042\016\086\054\118\013\105\016\016\086\007\101\118\091\101\092\008\008\118\010\105\055\042\092\010\105\091\118\042\091\118\101\007\118\019\105\020\010\118\101\040\105\110\012")
		}
	else
		_Urwigo.MessageBox{
			Text = _1yM("\112\007\010\010\106\118\039\042\101\118\106\007\042\118\040\020\090\105\118\126\007\010\084\007\101\101\105\016\118\101\007\118\081\042\101\118\007\016\118\106\007\042\010\118\091\020\126\105\101\106\118\090\105\091\101\012\118\043\007\042\118\110\042\091\101\118\010\105\101\042\010\016\118\101\007\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\118\020\016\086\118\081\042\101\118\092\101\118\007\016\012")
		}
	end
end
function _8Tqz:OnEnter()
	Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end
function _8Tqz:OnExit()
	if (#_8Tqz.Inventory) == 0 then
		_8Tqz.Active = false
	end
end
function _xPiC:OnTick()
	if _G[_1yM("\013\008\020\106\105\010")][_1yM("\013\007\091\092\101\092\007\016\124\079\079\042\010\020\079\106")][_1yM("\078\105\101\021\020\008\042\105")](_G[_1yM("\013\008\020\106\105\010")][_1yM("\013\007\091\092\101\092\007\016\124\079\079\042\010\020\079\106")], _1yM("\110")) == 3 then
		for k, v in pairs(_G[_1yM("\056\039\017\117")][_1yM("\124\008\008\051\115\039\085\105\079\101\091")]) do
			v[_1yM("\021\092\091\092\039\008\105")] = false
			v[_1yM("\124\079\101\092\090\105")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_1yM("\043\007\042\118\110\020\106\118\016\007\101\118\042\091\105\118\101\040\092\091\118\079\020\010\101\010\092\086\084\105\118\019\040\092\008\105\118\092\016\118\091\092\110\042\008\020\101\092\007\016\118\110\007\086\105\012")), 
			Callback = function(action)
				if action ~= nil then
					_G[_1yM("\075\040\105\010\092\084\007")][_1yM("\095\007\110\110\020\016\086")](_1yM("\112\020\090\105\095\008\007\091\105"))
				end
			end
		}
		return
	end
end
function _RON:On_Wk2x(target)
	_RON:MoveTo(Player)
	_RON.Commands._Wk2x.Enabled = false
end
function _tXi9:On_poxIQ(target)
	_tXi9:MoveTo(Player)
	_tXi9.Commands._poxIQ.Enabled = false
end
function _FtV:On_E87JH(target)
	if Player:Contains(_RON) then
		if Player:Contains(_tXi9) then
			if _ca6Hc > 13 then
				_Urwigo.MessageBox{
					Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\092\091\118\101\007\007\118\126\042\008\008\118\126\007\010\118\101\040\092\091\118\092\101\105\110\118\101\007\118\039\105\118\081\008\020\079\105\086\118\092\016\118\092\101\012\118\033\016\039\091\081\082\043\007\042\118\079\020\016\118\084\010\020\039\118\020\118\016\105\019\118\101\010\020\091\040\118\039\020\084\118\126\010\007\110\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\012")
				}
			elseif _ca6Hc <= 13 then
				_FtV:MoveTo(_RON)
				_ca6Hc = _ca6Hc + 2
				_FtV.Commands._E87JH.Enabled = false
				if _ca6Hc > 12 then
					_Urwigo.MessageBox{
						Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\008\007\007\122\091\118\008\092\122\105\118\092\101\118\092\091\118\020\008\110\007\091\101\118\126\042\008\008\012\118\043\007\042\118\091\040\007\042\008\086\118\010\105\101\042\010\016\118\101\007\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\118\020\016\086\118\081\092\079\122\118\042\081\118\020\118\016\105\019\118\007\016\105\012\118")
					}
				end
			end
		elseif not Player:Contains(_tXi9) then
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\118\091\040\007\042\008\086\118\081\042\101\118\007\016\118\091\007\110\105\118\084\008\007\090\105\091\118\039\105\126\007\010\105\118\081\092\079\122\092\016\084\118\042\081\118\101\040\092\091\118\092\101\105\110\012\026\103\123\034\117\040\105\010\105\118\020\010\105\118\091\007\110\105\118\084\008\007\090\105\091\118\039\020\079\122\118\092\016\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\012")
			}
		end
	elseif not Player:Contains(_RON) then
		_Urwigo.MessageBox{
			Text = _1yM("\043\007\042\118\016\105\105\086\118\020\118\101\010\020\091\040\118\039\020\084\118\101\007\118\081\008\020\079\105\118\101\040\092\091\118\092\101\105\110\118\092\016\012\118\043\007\042\118\079\020\016\118\081\092\079\122\118\007\016\105\118\042\081\118\020\101\118\101\040\105\118\040\042\101\012")
		}
	end
end
function _fin:On_ONAP(target)
	if Player:Contains(_RON) then
		if Player:Contains(_tXi9) then
			if _ca6Hc > 13 then
				_Urwigo.MessageBox{
					Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\092\091\118\101\007\007\118\126\042\008\008\118\126\007\010\118\101\040\092\091\118\092\101\105\110\118\101\007\118\039\105\118\081\008\020\079\105\086\118\092\016\118\092\101\012\118\033\016\039\091\081\082\043\007\042\118\079\020\016\118\084\010\020\039\118\020\118\016\105\019\118\101\010\020\091\040\118\039\020\084\118\126\010\007\110\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122")
				}
			elseif _ca6Hc <= 13 then
				_fin:MoveTo(_RON)
				_ca6Hc = _ca6Hc + 2
				_fin.Commands._ONAP.Enabled = false
				if _ca6Hc > 12 then
					_Urwigo.MessageBox{
						Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\008\007\007\122\091\118\008\092\122\105\118\092\101\118\092\091\118\020\008\110\007\091\101\118\126\042\008\008\012\118\043\007\042\118\091\040\007\042\008\086\118\010\105\101\042\010\016\118\101\007\118\101\040\105\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\118\020\016\086\118\081\092\079\122\118\042\081\118\020\118\016\105\019\118\007\016\105\012\118")
					}
				end
			end
		elseif not Player:Contains(_tXi9) then
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\118\091\040\007\042\008\086\118\081\042\101\118\007\016\118\091\007\110\105\118\084\008\007\090\105\091\118\039\105\126\007\010\105\118\081\092\079\122\092\016\084\118\042\081\118\101\040\092\091\118\092\101\105\110\012\026\103\123\034\117\040\105\010\105\118\020\010\105\118\091\007\110\105\118\084\008\007\090\105\091\118\039\020\079\122\118\020\101\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\012")
			}
		end
	elseif not Player:Contains(_RON) then
		_Urwigo.MessageBox{
			Text = _1yM("\043\007\042\118\016\105\105\086\118\020\118\101\010\020\091\040\118\039\020\084\118\101\007\118\081\008\020\079\105\118\101\040\092\091\118\092\101\105\110\118\092\016\012\118\043\007\042\118\079\020\016\118\081\092\079\122\118\007\016\105\118\042\081\118\020\101\118\101\040\105\118\040\042\101\012")
		}
	end
end
function _pBA1s:On_LtM(target)
	if Player:Contains(_RON) then
		if Player:Contains(_tXi9) then
			if _ca6Hc > 12 then
				_Urwigo.MessageBox{
					Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\092\091\118\101\007\007\118\126\042\008\008\118\126\007\010\118\101\040\092\091\118\092\101\105\110\118\101\007\118\039\105\118\081\008\020\079\105\086\118\092\016\118\092\101\012\118\033\016\039\091\081\082\043\007\042\118\079\020\016\118\084\010\020\039\118\020\118\016\105\019\118\101\010\020\091\040\118\039\020\084\118\126\010\007\110\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\012")
				}
			elseif _ca6Hc <= 12 then
				_pBA1s:MoveTo(_RON)
				_ca6Hc = _ca6Hc + 3
				_pBA1s.Commands._LtM.Enabled = false
				if _ca6Hc > 12 then
					_Urwigo.MessageBox{
						Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\008\007\007\122\091\118\008\092\122\105\118\092\101\118\092\091\118\020\008\110\007\091\101\118\126\042\008\008\012\118\043\007\042\118\091\040\007\042\008\086\118\010\105\101\042\010\016\118\101\007\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\118\020\016\086\118\081\092\079\122\118\042\081\118\020\118\016\105\019\118\007\016\105\012\118")
					}
				end
			end
		elseif not Player:Contains(_tXi9) then
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\118\091\040\007\042\008\086\118\081\042\101\118\007\016\118\091\007\110\105\118\084\008\007\090\105\091\118\039\105\126\007\010\105\118\081\092\079\122\092\016\084\118\042\081\118\101\040\092\091\118\092\101\105\110\012\026\103\123\034\117\040\105\010\105\118\020\010\105\118\091\007\110\105\118\084\008\007\090\105\091\118\039\020\079\122\118\020\101\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\012")
			}
		end
	elseif not Player:Contains(_RON) then
		_Urwigo.MessageBox{
			Text = _1yM("\043\007\042\118\016\105\105\086\118\020\118\101\010\020\091\040\118\039\020\084\118\101\007\118\081\008\020\079\105\118\101\040\092\091\118\092\101\105\110\118\092\016\012\118\043\007\042\118\079\020\016\118\081\092\079\122\118\007\016\105\118\042\081\118\020\101\118\101\040\105\118\040\042\101\012")
		}
	end
end
function _yRB9:On_Wy4(target)
	if Player:Contains(_RON) then
		if _ca6Hc > 2 then
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\092\091\118\101\007\007\118\126\042\008\008\118\126\007\010\118\101\040\092\091\118\092\101\105\110\118\101\007\118\039\105\118\081\008\020\079\105\086\118\092\016\118\092\101\012\118\033\016\039\091\081\082\043\007\042\118\079\020\016\118\084\010\020\039\118\020\118\016\105\019\118\101\010\020\091\040\118\039\020\084\118\126\010\007\110\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\012")
			}
		elseif _ca6Hc <= 2 then
			_yRB9:MoveTo(_RON)
			_ca6Hc = _ca6Hc + 13
			_yRB9.Commands._Wy4.Enabled = false
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\092\091\118\008\007\007\122\091\118\008\092\122\105\118\092\101\118\092\091\118\020\008\110\007\091\101\118\126\042\008\008\012\118\043\007\042\118\091\040\007\042\008\086\118\010\105\101\042\010\016\118\101\007\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\118\020\016\086\118\081\092\079\122\118\042\081\118\020\118\016\105\019\118\007\016\105\012\118")
			}
		end
	elseif not Player:Contains(_RON) then
		_Urwigo.MessageBox{
			Text = _1yM("\043\007\042\118\016\105\105\086\118\020\118\101\010\020\091\040\118\039\020\084\118\101\007\118\081\008\020\079\105\118\101\040\092\091\118\092\101\105\110\118\092\016\012\118\043\007\042\118\079\020\016\118\081\092\079\122\118\007\016\105\118\042\081\118\020\101\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122")
		}
	end
end
function _b1os2:On_nP7v(target)
	if Player:Contains(_RON) then
		if _ca6Hc > 11 then
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\092\091\118\101\007\007\118\126\042\008\008\118\126\007\010\118\101\040\092\091\118\092\101\105\110\118\101\007\118\039\105\118\081\008\020\079\105\086\118\092\016\118\092\101\012\118\033\016\039\091\081\082\043\007\042\118\079\020\016\118\084\010\020\039\118\020\118\016\105\019\118\101\010\020\091\040\118\039\020\084\118\126\010\007\110\118\101\040\105\118\040\042\101\012")
			}
		elseif _ca6Hc <= 11 then
			_b1os2:MoveTo(_RON)
			_ca6Hc = _ca6Hc + 4
			_b1os2.Commands._nP7v.Enabled = false
			if _ca6Hc > 12 then
				_Urwigo.MessageBox{
					Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\008\007\007\122\091\118\008\092\122\105\118\092\101\118\092\091\118\020\008\110\007\091\101\118\126\042\008\008\012\118\043\007\042\118\091\040\007\042\008\086\118\010\105\101\042\010\016\118\101\007\118\101\040\105\118\040\042\101\118\020\016\086\118\081\092\079\122\118\042\081\118\020\118\016\105\019\118\007\016\105\012\118")
				}
			end
		end
	elseif not Player:Contains(_RON) then
		_Urwigo.MessageBox{
			Text = _1yM("\043\007\042\118\016\105\105\086\118\020\118\101\010\020\091\040\118\039\020\084\118\101\007\118\081\008\020\079\105\118\101\040\092\091\118\092\101\105\110\118\092\016\012\118\043\007\042\118\079\020\016\118\081\092\079\122\118\007\016\105\118\042\081\118\020\101\118\101\040\105\118\040\042\101\012")
		}
	end
end
function _A5eDD:On_5Nu7(target)
	if (_G[_1yM("\102\016\090")][_1yM("\013\008\020\101\126\007\010\110")] == _1yM("\075\092\016\031\068")) or (_G[_1yM("\102\016\090")][_1yM("\072\105\090\092\079\105\125\072")] == _1yM("\072\105\091\122\101\007\081")) then
		_Urwigo.MessageBox{
			Text = _1yM("\102\110\042\008\020\101\007\010\118\110\020\106\118\016\007\101\118\039\105\118\042\091\105\086\118\101\007\118\126\092\016\086\118\101\040\092\091\118\079\020\079\040\105\012\118")
		}
		_A5eDD.Visible = false
		_Nd_NK.Visible = false
		_AsYt.Visible = false
	else
		_A5eDD:MoveTo(Player)
		_A5eDD.Commands._5Nu7.Enabled = false
		_A5eDD.Commands._uPk.Enabled = true
		_bUT.Complete = true
		_Iw5NN:MoveTo(Player)
		_Iw5NN.Visible = true
	end
	_tXi9.Visible = false
	_RON.Visible = false
	_MZS:MoveTo(_AsYt)
	_Imf.Active = false
	_sMxW.Active = false
	_mvB.Active = false
	_efW.Active = false
	_3vrdk.Active = false
	_8Tqz.Active = false
end
function _A5eDD:On_uPk(target)
	if _1s_N == 0 then
		_Urwigo.MessageBox{
			Text = _1yM("\043\007\042\118\019\092\008\008\118\126\092\016\086\118\101\040\105\118\079\020\079\040\105\118\008\007\079\020\101\105\086\118\020\101\047\026\103\123\034\041\070\052\118\070\015\012\038\097\068\026\103\123\034\075\052\038\097\118\015\059\012\037\059\031\026\103\123\034\026\103\123\034\117\040\105\118\079\020\079\040\105\118\092\091\118\040\020\016\084\092\016\084\118\092\016\118\020\118\091\110\020\008\008\118\105\090\105\010\084\010\105\105\016\118\039\042\091\040\118\101\040\020\101\118\092\091\118\105\090\105\016\118\019\092\101\040\118\101\040\105\118\007\042\101\091\092\086\105\118\126\105\016\079\105\118\007\126\118\101\040\105\118\126\007\007\101\039\020\008\008\118\126\092\105\008\086\012"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _1yM("\125\118\040\020\090\105\118\110\020\010\122\105\086\118\101\040\092\091\118\079\020\010\101\010\020\084\105\118\020\091\118\079\007\110\081\008\105\101\105\012\118\026\103\123\034\043\007\042\118\019\092\008\008\118\126\092\016\086\118\020\118\079\007\110\081\008\105\101\092\101\092\007\016\118\079\007\086\105\118\092\016\118\106\007\042\010\118\092\016\090\105\016\101\007\010\106\118\101\007\118\042\016\008\007\079\122\118\101\040\092\091\118\079\020\010\101\010\020\086\084\105\118\007\016\118\019\040\105\010\092\084\007\012\079\007\110\012\026\103\123\034\117\040\020\016\122\118\106\007\042\118\126\007\010\118\081\008\020\106\092\016\084\012"), 
						Media = _sS7dQ
					}
					_bUT.Complete = true
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _1yM("\043\007\042\118\019\092\008\008\118\126\092\016\086\118\101\040\105\118\079\020\079\040\105\118\008\007\079\020\101\105\086\118\020\101\047\026\103\123\034\041\070\052\118\070\015\012\038\097\068\026\103\123\034\075\052\038\097\118\015\059\012\037\059\031\026\103\123\034\026\103\123\034\117\040\105\118\079\020\079\040\105\118\092\091\118\040\020\016\084\092\016\084\118\092\016\118\020\118\091\110\020\008\008\118\105\090\105\010\084\010\105\105\016\118\039\042\091\040\118\101\040\020\101\118\092\091\118\105\090\105\016\118\019\092\101\040\118\101\040\105\118\007\042\101\091\092\086\105\118\126\105\016\079\105\118\007\126\118\101\040\105\118\126\007\007\101\039\020\008\008\118\126\092\105\008\086\026\103\123\034\012")
		}
	end
	_A5eDD.Commands._2qVMO.Enabled = true
	_1s_N = _1s_N + 5
	_bUT:RequestSync()
end
function _A5eDD:On_2qVMO(target)
	_Urwigo.MessageBox{
		Text = _1yM("\009\020\010\084\105\118\103\092\091\007\016\118\117\042\039\105")
	}
	_A5eDD.Commands._biK.Enabled = false
end
function _A5eDD:On_biK(target)
	_Urwigo.MessageBox{
		Text = ""
	}
end
function _eFQ9:On_bK0V(target)
	if Player:Contains(_RON) then
		if _ca6Hc > 1 then
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\092\091\118\101\007\007\118\126\042\008\008\118\126\007\010\118\101\040\092\091\118\092\101\105\110\118\101\007\118\039\105\118\081\008\020\079\105\086\118\092\016\118\092\101\012\118\033\016\039\091\081\082\043\007\042\118\079\020\016\118\084\010\020\039\118\020\118\016\105\019\118\101\010\020\091\040\118\039\020\084\118\126\010\007\110\118\101\040\105\118\040\042\101\012")
			}
		elseif _ca6Hc <= 1 then
			_eFQ9:MoveTo(_RON)
			_ca6Hc = _ca6Hc + 14
			_eFQ9.Commands._bK0V.Enabled = false
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\008\007\007\122\091\118\008\092\122\105\118\092\101\118\092\091\118\020\008\110\007\091\101\118\126\042\008\008\012\118\043\007\042\118\091\040\007\042\008\086\118\010\105\101\042\010\016\118\101\007\118\101\040\105\118\040\042\101\118\020\016\086\118\081\092\079\122\118\042\081\118\020\118\016\105\019\118\007\016\105\012\118")
			}
		end
	elseif not Player:Contains(_RON) then
		_Urwigo.MessageBox{
			Text = _1yM("\043\007\042\118\016\105\105\086\118\020\118\101\010\020\091\040\118\039\020\084\118\101\007\118\081\008\020\079\105\118\101\040\092\091\118\092\101\105\110\118\092\016\012\118\043\007\042\118\079\020\016\118\081\092\079\122\118\007\016\105\118\042\081\118\020\101\118\101\040\105\118\040\042\101\012")
		}
	end
end
function _vS6A:On_hn6(target)
	if Player:Contains(_RON) then
		if _ca6Hc > 12 then
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\092\091\118\101\007\007\118\126\042\008\008\118\126\007\010\118\101\040\092\091\118\092\101\105\110\118\101\007\118\039\105\118\081\008\020\079\105\086\118\092\016\118\092\101\012\118\033\016\039\091\081\082\043\007\042\118\079\020\016\118\084\010\020\039\118\020\118\016\105\019\118\101\010\020\091\040\118\039\020\084\118\126\010\007\110\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\012")
			}
		elseif _ca6Hc <= 12 then
			_vS6A:MoveTo(_RON)
			_ca6Hc = _ca6Hc + 3
			_vS6A.Commands._hn6.Enabled = false
			if _ca6Hc > 12 then
				_Urwigo.MessageBox{
					Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\008\007\007\122\091\118\008\092\122\105\118\092\101\118\092\091\118\020\008\110\007\091\101\118\126\042\008\008\012\118\043\007\042\118\091\040\007\042\008\086\118\010\105\101\042\010\016\118\101\007\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\118\020\016\086\118\081\092\079\122\118\042\081\118\020\118\016\105\019\118\007\016\105\012\118")
				}
			end
		end
	elseif not Player:Contains(_RON) then
		_Urwigo.MessageBox{
			Text = _1yM("\043\007\042\118\016\105\105\086\118\020\118\101\010\020\091\040\118\039\020\084\118\101\007\118\081\008\020\079\105\118\101\040\092\091\118\092\101\105\110\118\092\016\012\118\043\007\042\118\079\020\016\118\081\092\079\122\118\007\016\105\118\042\081\118\020\101\118\101\040\105\118\010\105\084\092\091\101\010\020\101\092\007\016\118\086\105\091\122\012\026\103\123\034")
		}
	end
end
function _SiJE:On_F53me(target)
	if Player:Contains(_RON) then
		if _ca6Hc > 7 then
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\092\091\118\101\007\007\118\126\042\008\008\118\126\007\010\118\101\040\092\091\118\092\101\105\110\118\101\007\118\039\105\118\081\008\020\079\105\086\118\092\016\118\092\101\012\118\033\016\039\091\081\082\043\007\042\118\079\020\016\118\084\010\020\039\118\020\118\016\105\019\118\101\010\020\091\040\118\039\020\084\118\126\010\007\110\118\101\040\105\118\040\042\101\012")
			}
		elseif _ca6Hc <= 7 then
			_SiJE:MoveTo(_RON)
			_ca6Hc = _ca6Hc + 8
			_SiJE.Commands._F53me.Enabled = false
			if _ca6Hc > 12 then
				_Urwigo.MessageBox{
					Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\008\007\007\122\091\118\008\092\122\105\118\092\101\118\092\091\118\020\008\110\007\091\101\118\126\042\008\008\012\118\043\007\042\118\091\040\007\042\008\086\118\010\105\101\042\010\016\118\101\007\118\101\040\105\118\040\042\101\118\020\016\086\118\081\092\079\122\118\042\081\118\020\118\016\105\019\118\007\016\105\012\118")
				}
			end
		end
	elseif not Player:Contains(_RON) then
		_Urwigo.MessageBox{
			Text = _1yM("\043\007\042\118\016\105\105\086\118\020\118\101\010\020\091\040\118\039\020\084\118\101\007\118\081\008\020\079\105\118\101\040\092\091\118\092\101\105\110\118\092\016\012\118\043\007\042\118\079\020\016\118\081\092\079\122\118\007\016\105\118\042\081\118\020\101\118\101\040\105\118\040\042\101\012")
		}
	end
end
function _zVEf:On_jnQ3(target)
	if Player:Contains(_RON) then
		if Player:Contains(_tXi9) then
			if _ca6Hc > 12 then
				_Urwigo.MessageBox{
					Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\092\091\118\101\007\007\118\126\042\008\008\118\126\007\010\118\101\040\092\091\118\092\101\105\110\118\101\007\118\039\105\118\081\008\020\079\105\086\118\092\016\118\092\101\012\118\033\016\039\091\081\082\043\007\042\118\079\020\016\118\084\010\020\039\118\020\118\016\105\019\118\101\010\020\091\040\118\039\020\084\118\126\010\007\110\118\101\040\105\118\040\042\101\012")
				}
			elseif _ca6Hc <= 12 then
				_zVEf:MoveTo(_RON)
				_ca6Hc = _ca6Hc + 3
				_zVEf.Commands._jnQ3.Enabled = false
				if _ca6Hc > 12 then
					_Urwigo.MessageBox{
						Text = _1yM("\043\007\042\010\118\101\010\020\091\040\118\039\020\084\118\008\007\007\122\091\118\008\092\122\105\118\092\101\118\092\091\118\020\008\110\007\091\101\118\126\042\008\008\012\118\043\007\042\118\091\040\007\042\008\086\118\010\105\101\042\010\016\118\101\007\118\101\040\105\118\040\042\101\118\020\016\086\118\081\092\079\122\118\042\081\118\020\118\016\105\019\118\007\016\105\012\118")
					}
				end
			end
		elseif not Player:Contains(_tXi9) then
			_Urwigo.MessageBox{
				Text = _1yM("\043\007\042\118\091\040\007\042\008\086\118\081\042\101\118\007\016\118\091\007\110\105\118\084\008\007\090\105\091\118\039\105\126\007\010\105\118\081\092\079\122\092\016\084\118\042\081\118\101\040\092\091\118\092\101\105\110\012\026\103\123\034\117\040\105\010\105\118\020\010\105\118\091\007\110\105\118\084\008\007\090\105\091\118\039\020\079\122\118\092\016\118\101\040\105\118\040\042\101\012")
			}
		end
	elseif not Player:Contains(_RON) then
		_Urwigo.MessageBox{
			Text = _1yM("\043\007\042\118\016\105\105\086\118\020\118\101\010\020\091\040\118\039\020\084\118\101\007\118\081\008\020\079\105\118\101\040\092\091\118\092\101\105\110\118\092\016\012\118\043\007\042\118\079\020\016\118\081\092\079\122\118\007\016\105\118\042\081\118\020\101\118\101\040\105\118\040\042\101\012")
		}
	end
end
function _Iw5NN:On_vuC(target)
	_Urwigo.MessageBox{
		Text = string.sub(Player.CompletionCode, 1, 15)
	}
end
function _Iw5NN:On_ZgW3(target)
	_Urwigo.MessageBox{
		Text = Player.Name
	}
end
function _FbT:On_Jky6(target)
	_FbT:MoveTo(Player)
	_FbT.Commands._Jky6.Enabled = false
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return _bUT
